pub mod dev;
pub mod arch;
pub mod disk;

pub use dev::*;
pub use arch::*;
pub use disk::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_dev() {
        let mut disk = Disk::new();
        let mut device = Device::new();

        match disk.write_all(0, vec![
            JMP_F, 2,
            QHALT,
            JMP_B, 2
        ].into_boxed_slice()) {
            Some(some) => panic!("{}", some.to_string()),
            None => assert!(true)
        };

        device.attach(0, &mut disk);
        device.power();

        device.detach(0);
    }

    #[test]
    fn test_disk() {
        let mut disk = Disk::new();

        match disk.write(0xA, 200) {
            Ok(ok) => assert_eq!(ok, 0x0),
            Err(err) => panic!("{}", err.to_string())
        };

        match disk.read(200) {
            Ok(ok) => assert_eq!(ok, 0xA),
            Err(err) => panic!("{}", err.to_string())
        };

        match disk.write(0x0, 200) {
            Ok(ok) => assert_eq!(ok, 0xA),
            Err(err) => panic!("{}", err.to_string())
        };

        assert_eq!(disk.clone_into_vec(), vec![0x0; 0x3FFF]);
    }
}
