use super::*;

#[derive(Clone)]
pub struct Mut {
    mem: Vec<Byte>,
    size: usize
}

impl Mut {
    pub fn new(size: usize) -> Mut {
        Mut {
            mem: vec![0; size],
            size
        }
    }

    pub fn from(mem: Vec<Byte>) -> Mut {
        Mut {
            mem: mem.clone(),
            size: mem.len()
        }
    }

    pub fn get(&self, index: usize) -> Option<&Byte> {
        if index < self.size {
            return Some(match self.mem.get(index) {
                Some(some) => some,
                None => return None
            });
        } else {
            return None;
        }
    }

    pub fn get_mut(&mut self, index: usize) -> Option<&mut Byte> {
        if index < self.size {
            return Some(match self.mem.get_mut(index) {
                Some(some) => some,
                None => return None
            });
        } else {
            return None;
        }
    }

    pub fn len(&self) -> usize {
        self.size
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.mem.clone()
    }
}

#[derive(Clone)]
pub struct Immut {
    mem: Vec<Byte>,
    size: usize
}

impl Immut {
    pub fn new(size: usize) -> Immut {
        Immut {
            mem: vec![0; size],
            size
        }
    }

    pub fn from(mem: Vec<Byte>) -> Immut {
        Immut {
            mem: mem.clone(),
            size: mem.len()
        }
    }

    pub fn get(&self, index: usize) -> Option<&Byte> {
        if index < self.size {
            return Some(match self.mem.get(index) {
                Some(some) => some,
                None => return None
            });
        } else {
            return None;
        }
    }

    pub fn len(&self) -> usize {
        self.size
    }

    pub fn clone_into_vec(&self) -> Vec<Byte> {
        self.mem.clone()
    }
}
