pub mod mem;
pub mod byte;

pub use mem::*;
pub use byte::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_mut() {
        fn test_new() {
            let mut mutable = Mut::new(10);

            for i in 0..10 {
                assert_eq!(match mutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 0);
            }

            assert_eq!(mutable.get(10), None);

            for i in 0..10 {
                match mutable.get_mut(i) {
                    Some(some) => *some = 1,
                    None => panic!("value of index {} is 'None'", i)
                }
            }

            for i in 0..10 {
                assert_eq!(match mutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 1);
            }

            assert_eq!(mutable.get_mut(10), None);
            assert_eq!(mutable.len(), 10);
            assert_eq!(mutable.clone_into_vec(), vec![1, 1, 1, 1, 1, 1, 1, 1, 1, 1]);
        }

        fn test_from() {
            let mut mutable = Mut::from(vec![0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);

            for i in 0..10 {
                assert_eq!(match mutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 0);
            }

            assert_eq!(mutable.get(10), None);

            for i in 0..10 {
                match mutable.get_mut(i) {
                    Some(some) => *some = 1,
                    None => panic!("value of index {} is 'None'", i)
                }
            }

            for i in 0..10 {
                assert_eq!(match mutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 1);
            }

            assert_eq!(mutable.get_mut(10), None);
            assert_eq!(mutable.len(), 10);
            assert_eq!(mutable.clone_into_vec(), vec![1, 1, 1, 1, 1, 1, 1, 1, 1, 1]);
        }

        test_new();
        test_from();
    }

    #[test]
    fn test_immut() {
        fn test_new() {
            let immutable = Immut::new(10);

            for i in 0..10 {
                assert_eq!(match immutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 0);
            }

            assert_eq!(immutable.get(10), None);
            assert_eq!(immutable.len(), 10);
            assert_eq!(immutable.clone_into_vec(), vec![0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
        }

        fn test_from() {
            let immutable = Immut::from(vec![0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);

            for i in 0..10 {
                assert_eq!(match immutable.get(i) {
                    Some(some) => *some,
                    None => panic!("value of index {} is 'None'", i)
                }, 0);
            }

            assert_eq!(immutable.get(10), None);
            assert_eq!(immutable.len(), 10);
            assert_eq!(immutable.clone_into_vec(), vec![0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
        }

        test_new();
        test_from();
    }
}
