use std::{fs::File, io::Write, fs};
use rsap::Parser as ArgParser;

fn main() {
    let title = "ttir".to_string();
    let arg_parser = ArgParser::with_collect();

    let input: String;
    let mut output = "a.out".to_string();
    let mut load: Option<String> = None;

    if arg_parser.contains("i") {
        input = arg_parser.value_of("i");
    } else if arg_parser.contains("input") {
        input = arg_parser.value_of("input");
    } else {
        mtk::eprintln_exit(title, "no input file".to_string());
    }
    
    if arg_parser.contains("o") {
        output = arg_parser.value_of("o");
    } else if arg_parser.contains("output") {
        output = arg_parser.value_of("output");
    } else if arg_parser.contains("l") {
        load = Some(arg_parser.value_of("l"));
    } else if arg_parser.contains("load") {
        load = Some(arg_parser.value_of("load"));
    }

    let mut source = match ttvm::ir::Source::open(&input) {
        Ok(ok) => ok,
        Err(err) => mtk::exit(title, err)
    };

    let output_bytes = match source.compile() {
        Ok(ok) => ok,
        Err(err) => mtk::exit(title, err)
    };

    let mut file = match File::create(&output) {
        Ok(ok) => ok,
        Err(err) => mtk::eprintln_exit(title, format!("unable to open file '{}': {}", output, err.to_string()))
    };

    match file.write_all(&output_bytes) {
        Ok(ok) => ok,
        Err(err) => mtk::eprintln_exit(title, format!("unable to write to file '{}': {}", output, err.to_string()))
    };

    if load != None {
        let load_file = load.unwrap();
        let load_content = match fs::read(&load_file) {
            Ok(ok) => ok,
            Err(err) => mtk::eprintln_exit(title, format!("unable to read file '{}': {}", output, err.to_string()))
        };

        let mut fm_disk = ttvm::Disk::new();
        let mut device = ttvm::Device::new();

        fm_disk.write_all(0, load_content.into_boxed_slice());

        device.attach(0, &mut fm_disk);
        device.power();

        device.detach(0);
    }
}
