pub mod lexer;
pub mod token;

pub use lexer::*;
pub use token::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_lexer() {
        let mut lexer = Lexer::new("identifier \"string\" 1 2 3 456 = + - ! * / == != < > <= >= , ; ( ) { } if else return def throw call");

        let mut token: Token = lexer.read_next_token();
        let mut tokens: Vec<Token> = Vec::new();

        while token != Token::EOF {
            tokens.push(token);

            token = lexer.read_next_token();
        }

        // Print the tokens
        for token in tokens.iter() {
            println!("{:?}", token);
        }
        
        assert_eq!(tokens.len(), 30);

        assert_eq!(tokens[0], Token::Identifier("identifier".to_string()));
        assert_eq!(tokens[1], Token::String("string".to_string()));
        assert_eq!(tokens[2], Token::Number(1));
        assert_eq!(tokens[3], Token::Number(2));
        assert_eq!(tokens[4], Token::Number(3));
        assert_eq!(tokens[5], Token::Number(456));
        assert_eq!(tokens[6], Token::Assign);
        assert_eq!(tokens[7], Token::Plus);
        assert_eq!(tokens[8], Token::Minus);
        assert_eq!(tokens[9], Token::Bang);
        assert_eq!(tokens[10], Token::Asterisk);
        assert_eq!(tokens[11], Token::Slash);
        assert_eq!(tokens[12], Token::Equal);
        assert_eq!(tokens[13], Token::NotEqual);
        assert_eq!(tokens[14], Token::LessThan);
        assert_eq!(tokens[15], Token::GreaterThan);
        assert_eq!(tokens[16], Token::LessThanEqual);
        assert_eq!(tokens[17], Token::GreaterThanEqual);
        assert_eq!(tokens[18], Token::Comma);
        assert_eq!(tokens[19], Token::Semicolon);
        assert_eq!(tokens[20], Token::LParen);
        assert_eq!(tokens[21], Token::RParen);
        assert_eq!(tokens[22], Token::LBrace);
        assert_eq!(tokens[23], Token::RBrace);
        assert_eq!(tokens[24], Token::If);
        assert_eq!(tokens[25], Token::Else);
        assert_eq!(tokens[26], Token::Return);
        assert_eq!(tokens[27], Token::Def);
        assert_eq!(tokens[28], Token::Throw);
        assert_eq!(tokens[29], Token::Call);
    }
}
