#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub enum Token {
    // None
    None,

    // Special tokens
    EOF,
    Illegal,

    // Identifiers and literals
    Identifier(String),
    String(String),
    Number(i128),

    // Operators
    Assign,
    Plus,
    Minus,
    Bang,
    Asterisk,
    Slash,
    Equal,
    NotEqual,
    LessThan,
    GreaterThan,
    LessThanEqual,
    GreaterThanEqual,
    Comment,

    // Delimiters
    Comma,
    Semicolon,
    LParen,
    RParen,
    LBrace,
    RBrace,

    // Keywords
    If,
    Else,
    Return,
    Def,
    Throw,
    Call
}

impl Token {
    pub fn new() -> Token {
        Token::None
    }
}
