use super::*;

#[derive(Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
pub struct AST {
    value: Token,
    children: Vec<AST>
}

impl AST {
    pub fn new() -> AST {
        AST {
            value: Token::new(),
            children: Vec::new()
        }
    }

    pub fn add_child(&mut self, value: Token) {
        self.children.push(AST {
            value,
            children: Vec::new()
        })
    }
}
