use std::{
    env,
    io::{self, prelude::*},
    process,
};

pub(crate) const DEBUG_ASSERTIONS: &str = "DEBUG_ASSERTIONS";
pub(crate) const NO_STDOUT: &str = "NO_STDOUT";
pub(crate) const NO_STDERR: &str = "NO_STDERR";
pub(crate) const UPDATE_STDOUT: &str = "UPDATE_STDOUT";
pub(crate) const UPDATE_STDERR: &str = "UPDATE_STDERR";
pub(crate) const NON_UNICODE: &str = "NON_UNICODE";
pub(crate) const FAIL: &str = "FAIL";
pub(crate) const EXIT_CODE: i32 = 123;

#[allow(dead_code)]
fn main() {
    assert_eq!(
        cfg!(debug_assertions),
        env::var(DEBUG_ASSERTIONS).unwrap().parse().unwrap()
    );
    let stdout = io::stdout();
    let mut stdout = stdout.lock();
    if env::var_os(NO_STDOUT).is_none() {
        writeln!(stdout, "args: {:?}\nstdin:", env::args_os()).unwrap();
        io::copy(&mut io::stdin().lock(), &mut io::stdout().lock()).unwrap();
        stdout.write_all(b"[stdin end]\nstdout\n").unwrap();
        if env::var_os(NON_UNICODE).is_some() {
            stdout.write_all(b"\xffstdout\x80\n").unwrap();
        }
    } else {
        let stdin = io::stdin();
        let mut stdin = stdin.lock();
        while stdin.read(&mut [0]).unwrap() != 0 {}
    }
    let stderr = io::stderr();
    let mut stderr = stderr.lock();
    if env::var_os(NO_STDERR).is_none() {
        stderr.write_all(b"stderr\n").unwrap();
        if env::var_os(NON_UNICODE).is_some() {
            stderr.write_all(b"\xffstderr\x80\n").unwrap();
        }
    }
    if env::var_os(UPDATE_STDOUT).is_some() {
        stdout.write_all(b"updated stdout\n").unwrap();
    }
    if env::var_os(UPDATE_STDERR).is_some() {
        stderr.write_all(b"updated stderr\n").unwrap();
    }
    if env::var_os(FAIL).is_some() {
        process::exit(EXIT_CODE);
    }
}
