#![forbid(unsafe_code)]

use std::{
    env,
    io::{self, prelude::*},
    process::{Command, Stdio},
};

fn main() {
    let rustc = env::var("RUSTC").unwrap();
    let stdout = io::stdout();
    let mut stdout = stdout.lock();
    if Command::new(&rustc)
        .args(&["-VZunstable-options"])
        .stdin(Stdio::null())
        .status()
        .expect("failed to spawn rustc")
        .success()
    {
        writeln!(stdout, "cargo:rustc-cfg=nightly").unwrap();
    }
    if env::var_os("PROFILE").unwrap() == "release" {
        writeln!(stdout, "cargo:rustc-cfg=release").unwrap();
    }
    writeln!(
        stdout,
        "cargo:rerun-if-changed=build.rs\n\
         cargo:rustc-env=TRYRUN_RUSTC={}\n\
         cargo:rustc-env=TRYRUN_RUSTDOC={}\n\
         cargo:rustc-env=TRYRUN_OPT_LEVEL={}",
        rustc,
        env::var("RUSTDOC").unwrap(),
        env::var("OPT_LEVEL").unwrap()
    )
    .unwrap();
}
