//! Accept commandline arguments
use std::env;

pub struct Args {
    pub text: String,
}

impl Args {
    pub fn new() -> Result<Self, String> {
        let args = env::args().skip(1);
        if args.len() == 0 {
            return Err("Error: Expected one Argument.".to_string());
        }
        let mut text = String::new();
        for arg in args {
            text.push_str(&arg);
            text.push(' ');
        }
        Ok(Self { text })
    }
}
