//! Command line utility:
//! ```sh
//! $ truth-table "a and not b"
//! a b | a and not b
//! 0 0 | 0
//! 1 0 | 0
//! 0 1 | 1
//! 1 1 | 0
//! ```

#![warn(missing_docs)]

mod args;
mod eval;
mod format;
mod lexer;
mod parse;

use std::io;

fn main() {
    if let Err(err) = run() {
        eprintln!("{}", err);
        std::process::exit(0);
    }
}

fn run() -> Result<(), Box<dyn std::error::Error>> {
    let args = args::Args::new()?;
    format::write_as_table(&mut io::stdout(), args, true)?;
    Ok(())
}
