# Overview

Trust-DNS Util is a support library for the Trust-DNS libraries.

## resolve

Useful for testing trust-dns-resolver and it's features via an independent CLI

```shell
$ cargo install --bin resolve trust-dns-util
```

### example

```shell
$ resolve www.example.com.
Querying for www.example.com. A from udp:8.8.8.8:53, tcp:8.8.8.8:53, udp:8.8.4.4:53, tcp:8.8.4.4:53, udp:[2001:4860:4860::8888]:53, tcp:[2001:4860:4860::8888]:53, udp:[2001:4860:4860::8844]:53, tcp:[2001:4860:4860::8844]:53
Success for query name: www.example.com. type: A class: IN
        www.example.com. 21063 IN A 93.184.216.34
```

### help

```shell
$ resolve -h
resolve 0.20.0-alpha.3
A CLI interface for the trust-dns-resolver.

This utility directly uses the trust-dns-resolver to perform a lookup to a set of nameservers. Many of the features can
be directly tested via the FLAGS and OPTIONS. By default (like trust-dns-resolver) the configured nameservers are the
Google provided ones. The system configured ones can be used with the `--system` FLAG. Other nameservers, as many as
desired, can be configured directly with the `--nameserver` OPTION.

USAGE:
    resolve [FLAGS] [OPTIONS] <domainname>

FLAGS:
        --cloudflare    Use cloudflare resolvers
        --debug         Enable debug and all logging
        --error         Enable error logging
        --google        Use google resolvers, default
    -e, --happy         Happy eye balls lookup, ipv4 and ipv6
    -h, --help          Prints help information
        --info          Enable info + warning + error logging
        --ipv4          Use ipv4 addresses only, default is both ipv4 and ipv6
        --ipv6          Use ipv6 addresses only, default is both ipv4 and ipv6
        --quad9         Use quad9 resolvers
    -s, --system        Use system configuration, e.g. /etc/resolv.conf, instead of defaults
        --tcp           Use only TCP, default to UDP and TCP
        --udp           Use only UDP, default to UDP and TCP
    -V, --version       Prints version information
        --warn          Enable warning + error logging

OPTIONS:
    -n, --nameserver <nameserver>...    Specify a nameserver to use, ip and port e.g. 8.8.8.8:53 or
                                        [2001:4860:4860::8888]:53 (port required)
    -t, --type <ty>                     Type of query to issue, e.g. A, AAAA, NS, etc [default: A]

ARGS:
    <domainname>    Name to attempt to resolve, if followed by a '.' then it's a fully-qualified-domain-name
```

## dnskey-to-pem

This will take a private DNSKEY as generated by BIND9 and output an OpenSSL compatible PEM formatted file. *WARNING* this will contain private key material.

```console
$ cargo run --bin pem-to-public-dnskey -- --help
Trust-DNS dnskey-to-pem 0.11.3
Benjamin Fry <benjaminfry@me.com>
Converts a dnskey, as generated from BIND's dnssec-keygen, into pem format

USAGE:
    dnskey-to-pem [OPTIONS] <PRIVATE_KEY_FILE>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
    -o, --output <OUTPUT_FILE>    Output FILE to write to [default: out.pem]

ARGS:
    <PRIVATE_KEY_FILE>    Input FILE from which to read the DNSSec private key
```


## pem-to-public-dnskey

This utility can be used to output raw bytes in the DNSKEY RDATA format. This is useful for associating custom public keys with the TrustAnchor facility in Trust-DNS.

```console
$ cargo run --bin pem-to-public-dnskey -- --help
Trust-DNS pem-to-public-dnskey 0.11.3
Benjamin Fry <benjaminfry@me.com>
Converts a PEM formatted public key into a raw public dnskey (this is not the inverse of bind_dnskey_to_pem). This can be used to create a dnskey in the TrustAnchor internal
format.

USAGE:
    pem-to-public-dnskey [OPTIONS] <PEM_KEY_FILE>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
    -o, --output <OUTPUT_FILE>    Output FILE to write to [default: out.dnskey]

ARGS:
    <PEM_KEY_FILE>    Input PEM FILE from which to read the public key
```

## Versioning

Trust-DNS does it's best job to follow semver. Trust-DNS will be promoted to 1.0 upon stabilization of the publicly exposed APIs. This does not mean that Trust-DNS will necessarily break on upgrades between 0.x updates. Whenever possible, old APIs will be deprecated with notes on what replaced those deprecations. Trust-DNS will make a best effort to never break software which depends on it due to API changes, though this can not be guaranteed. Deprecated interfaces will be maintained for at minimum one major release after that in which they were deprecated (where possible), with the exception of the upgrade to 1.0 where all deprecated interfaces will be planned to be removed.
