+++
title = "Trunk v0.10 – v0.13"
description = "Automatic wasm-bindgen & wasm-opt downloads, cut over to Tokio & Axum, and various other features and fixes."
[extra]
author = "Doddzilla"
+++

Hello fellow Rustaceans! It's been quite some time since our last blog post. We've seen 5 releases since then, so we've got a lot to cover.

## Automatic Tool Downloads
After building wasm-opt integration for Trunk, `dnaka91` then built a system which is able to automatically download and install `wasm-bindgen` & `wasm-opt` if they are missing from the host system. This system will check the version of `wasm-bindgen` being used by the parent application and will ensure that the versions match. External tools downloaded by this system are cached in a well-defined location based on the host OS.

Overall this feature lowers the barrier of entry for getting started with Trunk. It was quite common that folks in the community discord would drop in with an error message indicating that Trunk was not able to call `wasm-bindgen` (the error message was not so great). Now, such issues should be a thing of the past.

There is a lot of great potential with this feature. There has been some good discussion in the community around moving away from our current sass solution, which is to link to a C-based sass lib, and instead to use our new download system to pull down [dart-sass](https://sass-lang.com/dart-sass). This is the primary sass implementation these days, getting all of the new features before any of the other implementations. More design work to be done here, but this could be a big win.

Not only does this apply to sass, but this could apply to any other integrations we build in the future. Especially in cases where the integration is a standalone binary which we can download and call. This will quite likely be an important piece of our plugin system once the plugin system is ready for prime time.

## Tokio & Axum
Trunk has shipped with a static file server from the beginning. Somewhere along the way we added support for HTTP proxies, and then WebSocket proxies after that. Originally, Trunk was based on the `async-std` runtime, so we used `tide` for all things HTTP.

The Rust community evolves quickly. The async runtime ecosystem, even faster. Not long ago, the Tokio team released [Tokio 1.0](https://tokio.rs/blog/2020-12-tokio-1-0). This was a big win for the Rust ecosystem overall. Since then, they've continued to crank out new 1.x releases, along with new support libraries, io_uring support (love it), as well as a new server framework called [Axum](https://github.com/tokio-rs/axum) ([blog post](https://tokio.rs/blog/2021-07-announcing-axum)).

All that to say, I decided to cut Trunk over to the Tokio ecosystem, and while I was in the middle finishing up that work, I found myself wishing that we had a nice, simple, ergonomic web framework for Tokio ... and then literally the very next day Axum was released. This couldn't have come at a better time. Axum is built on Hyper & Tower, so it has direct interoperability with that entire ecosystem. This made the switch rather simple on the Trunk side.

I have to say, I'm quite stoked. Very happy with how this turned out for Trunk, and happy to see this new option come about for the Rust ecosystem. The wins here are obvious, but the biggest win is that we have a greater stability guarantee overall, and the success of the Tokio ecosystem to draw from.

## Other Features & Fixes
Lots of big wins so far, but these last few releases have also seen many other smaller features and fixes. Let's take a look.

### `indicatif`
After sinking more time than I care to admit, and finding myself frustrated rather often with `indicatif`, I decided to completely remove it from Trunk. Now, to be sure, `indicatif` is great, and its maintainer is quite literally a hero among the greater software community, but the difficulties I ran into here seemed to be more closely related to async interop.

Without going into too many details, deadlocks from progress bars, consoles not clearing properly, inflexibility of design, all of these things were causing me to spend more time on the console than spending time building other **real** features for Trunk. So, I decided to instead just use the good ol' [tracing](https://github.com/tokio-rs/tracing) crate, and now things are quite stable.

Truth be told, I would love to circle back at some point in the future and add a nicer console UI to Trunk. This is currently fairly low priority for me, as this is purely aesthetic. If you are passionate about such things, drop by our community discord and let us know!

There are many other features and fixes of note. Have a look at the [changelog](https://github.com/thedodd/trunk/blob/master/CHANGELOG.md) for more details.

## Conclusion
All in all, some great progress for Trunk. As far as Trunk's future, the plugin system and exploring patterns around code splitting and HMR are the things I'm most excited about.

As a community, building web apps in Rust, finding the pain points, and then working together to fix them, that is how we make progress. Let's keep on pushing forward!

Cheers!
