+++
title = "Trunk v0.9.0"
description = "WebSocket proxy for dev server & wasm-opt integration."
[extra]
author = "Doddzilla"
+++

Hello fellow Rustaceans! As you may know, Trunk is a WASM web application bundler for Rust. It works out of the box with any web UI framework based on `wasm-bindgen`, and supports bundling of a good number of asset types including SASS/SCSS, CSS, JS snippets, images, and more.

I'm happy to announce the release of Trunk `v0.9.0`. There are two major items to highlight here, let's dig in.

## WebSocket Proxy for Dev Server
First, shoutout to `hamza1311` for all of their work trailblazing this feature within Trunk, and also a shoutout to `jbg` for their work on `tide-websockets`, which is what we are using to power our new WebSocket proxy system.

The new WebSocket proxy is identical in structure to the way standard HTTP proxies are declared. On the CLI — where only one proxy can be declared – simply add the new `--proxy-ws` flag to enable WebSocket proxy mode.

In a `Trunk.toml` file — where multiple proxies may be declared — simply add the `ws = true` field to a proxy section to turn it into a WebSocket proxy, as such:

```toml
[[proxy]]
backend = "ws://localhost:9000/api/ws"
ws = true
```

## Integration with `wasm-opt`
Shoutout to `dnaka91` for all of the work on this one. More details on wasm-opt itself can be found in the [WebAssembly/binaryen](https://github.com/WebAssembly/binaryen) repo.

Trunk now has an awesome integration with `wasm-opt`. In your `index.html` file, simply add the `data-wasm-opt={level}` attribute to your `<link data-trunk rel="rust" .../>` as described [here in the docs](https://trunkrs.dev/assets/#rust). The opt `level` can be any of the values `0`, `1`, `2`, `3`, `4`, `s` or `z` where `0` explicitly disables `wasm-opt`.

For now, `wasm-opt` will need to be manually installed on your system if you are planning on using it with Trunk. We already have an issue scoping out the work for automatically installing `wasm-opt` (along with `wasm-bindgen-cli` as well). This will come in a future release.

As of this release, the default opt level is `0`, effectively disabling `wasm-opt`. This is primarily to maintain backwards compatibility given the fact that we do not yet automatically install `wasm-opt`. After we've finished the work for automatic installation of `wasm-opt`, we will quite likely set the default to something between `2` & `4`.

## Conclusion
The integration with `wasm-opt` was a blocker keeping some folks back from using Trunk (though it never precluded manual use of `wasm-opt`). Now that integration has landed, hopefully Trunk will be able to help more folks on their journey with Rust & WebAssembly.

Our new WebSocket support is also a major step forward for Trunk. WebSocket proxy support is a common need for folks building web applications, so being able to support this use case is a great step forward for the maturity of Trunk.

As community member `lukechu10` has pointed out, creating our own UI error overlay to communicate errors coming from the Trunk build system is now an option for us to pursue. Automatic UI reloading, WASM HMR (I hope), and an integrated UI error overlay are all excellent features for us to hack on next!

I'm stoked, let's continue to push this thing forward! If you are interested in getting involved, drop by our Discord server and say hello.

Cheers!
