+++
title = "Trunk v0.8.0 & Project Update"
description = "A new website, new maintainers, and a new Trunk release."
[extra]
author = "Doddzilla"
+++

Hello fellow Rustaceans! Welcome to the very first official blog post of the Trunk community. In case you don't know, Trunk is a WASM web application bundler for Rust. It works out of the box with any web UI framework based on `wasm-bindgen`, and supports bundling of a good number of asset types including SASS/SCSS, CSS, JS snippets, images, and more. There's a lot to cover here, so let's dig in.

# New Site & New Blog
First off, if you are reading this blog post, then you've found our new Trunk website. All of our documentation is here, and the maintainers team plans on continuing to expand this site, adding new documentation and improving the site as we go. This is a community driven website, so if you see things which you would like to improve, content you would like to add (including new blog posts), or any other sorts of changes, please open a PR! Just to make that process even easier, let's talk about how the site is built.

We are using the excellent [Zola static site engine](https://getzola.org). It is another great Rust project. Putting together this entire site from nothing took only a few hours. Sure there's not too much here, but the quality is quite solid, and Zola really delivered on providing a robust development process. Using Zola to make changes to this site will be quite simple for newcomers and experienced users alike.

We are also using the Zola [Juice theme](https://juice.huhu.io/). I have to say, I quite like the theme, and very few changes were needed to make things work.

For now we are using Github Pages to host the site. This was so quick and easy, there are Github Actions which do most of the heavy lifting. Hard to beat that level of convenience.

Overall, adding a new blog post for maintainers and community members will typically be as simple as adding a new markdown file with your content ... AND THAT'S ALL. Doesn't get easier than that. It is the hope of the maintainers team that community members will feel empowered to write a blog post on anything and everything related to Trunk. Use cases, future plans for contributions, pain points, areas where they would like to see Trunk improve, how to use Trunk with [Seed](https://github.com/seed-rs/seed), [Yew](https://github.com/yewstack/yew), or any other project. The more content the better.

Last thing I will say about the site, we are in the process of adding some new art work. Right now we've got a placeholder Ferris holding down the fort. They're doing a great job, but we're looking for some Trunk specific art, images, Ferris logos, etc. We've got some discussion going on over in [Trunk #120](https://github.com/thedodd/trunk/issues/120). I am especially excited about the possibility of an SVG of a bunch of little Ferris crabs packing a trunk full of sea shells, assets logos, scripts/scrolls, coral chunks and the like. If you've got some skills on this front, and you would like to jump on this hype train, DO IT!!! **We would love to show off your skills on the site.**

# New Maintainers
The biggest news we have, and probably one of the best things for the Trunk project itself, is that we have 3 new maintainers!!! 🎉🍻 Rakshith Ravi, Philip Peterson and Martin Kavik. I'm very excited to have these guys on the team, they've each already contributed in many ways to the Trunk project, and having a strong group of maintainers is very important for the long-term success of any open source project. We are all stronger together!

If you are interested in helping out as a maintainer, the best way to get started is with PR reviews, reviewing issues and making sure they are ready to be moved to the coding phase, and then actually getting your hands dirty with some code! Trunk so far has been able to maintain a pretty solid and enjoyable code base. Now is a great time to get involved.

# Trunk v0.8.0 has Landed
Trunk v0.8.0 has now been released. See the [release page](https://github.com/thedodd/trunk/releases/tag/v0.8.0) for all of the details. In summary:

- The `trunk watch` & `trunk serve` commands now accept the `--watch` option which allows users to specify multiple different directories and files to be watched, triggering new builds as changes are detected. A community member `@malobre` knocked this one out.
- Another community member `@DzenanJupic` has added the `inline` asset type. This allows users to target various file types and have their content "inlined" into the parent HTML document as-is. Go checkout the docs on the [inline asset type](https://trunkrs.dev/assets/#inline) for more details (wow, felt great to be able to provide a link to the docs like that).
- A community member `@hamza1311` & one of our maintainers `@philip-peterson` squashed a bug where old build artifacts would continually accumulate in the dist dir. That has now been fixed, and any time a successful build goes through, all of the old artifacts will be removed, and only the fresh new artifacts will exist in the `dist` dir.
- Lastly, `@MartinKavik` fixed an infinite rebuild loop bug on Windows.

# Immediate Plans
In the immediate term, we have a few community lead efforts for cutting Trunk over to the Tokio ecosystem. This is primarily to address our need for a robust WebSockets & SSE solution, and the Tokio community happens to have some pretty solid options on that front.

We've also got another community lead effort on getting `wasm-opt` integrated into the standard Trunk build pipeline.

Both of these initiatives are exciting and will go far to provide an even better experience for folks building Rust WASM applications using Trunk.

# Conclusion
I am quite excited and optimistic about Rust's future with WebAssembly. WebAssembly has a long way to go, but it has already come so far. Working together to continue making Rust the best option for WebAssembly, and to ship more safe, robust, and powerful Rust code to the web is definitely for the better as far as I can see.

**BONUS:** head on over to [the next blog post](/blog/plugin-system/) where we discuss design patterns around a Trunk plugin system.

Let's keep on doing this. Cheers!

