pub fn truncate_text(text: &str, truncate_len: usize) -> &str {
    if text.len() <= truncate_len {
        return text;
    }

    let c = text.chars().nth(truncate_len);
    match c {
        Some(s) => match char::is_whitespace(s) {
            true => text.split_at(truncate_len).0,
            false => {
                let chars: Vec<_> = text.chars().collect();
                let truncated = chars.split_at(truncate_len);
                let first = truncated.0.iter().collect::<String>();
                let last = truncated.1.iter().collect::<String>();

                let prev_ws = match first.rfind(char::is_whitespace) {
                    Some(i) => {
                        let mut ws = i;
                        loop {
                            if text.is_char_boundary(ws) {
                                break;
                            }
                            ws -= 1;
                        }
                        ws
                    }
                    None => 0,
                };
                let next_ws = match last.find(char::is_whitespace) {
                    Some(i) => {
                        let mut ws = truncate_len + i;
                        loop {
                            if text.is_char_boundary(ws) {
                                break;
                            }
                            ws += 1;
                        }
                        ws
                    }
                    None => text.len(),
                };
                match next_ws > prev_ws && prev_ws > 0 {
                    true => text.split_at(prev_ws).0,
                    false => text.split_at(next_ws).0,
                }
            }
        },
        None => text,
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn returns_on_short_string() {
        assert_eq!(truncate_text("test", 7), "test");
    }

    #[test]
    fn truncates_on_whitespace_exact() {
        assert_eq!(truncate_text("test test", 4), "test");
    }

    #[test]
    fn truncates_on_whitespace_after() {
        assert_eq!(truncate_text("test test", 3), "test");
    }

    #[test]
    fn truncates_on_whitespace_before() {
        assert_eq!(truncate_text("test test", 5), "test");
    }

    #[test]
    fn truncates_on_whitespace_unicode() {
        assert_eq!(truncate_text("te😀t test", 5), "te😀t");
    }
}
