
use thiserror::Error;

/// Modeling errors
#[derive(Debug, PartialEq, Error)]
pub enum Error {
    /// wrapper of topological error
    #[error(transparent)]
    FromTopology(#[from] truck_topology::errors::Error),
    /// tried to attach a plane to a wire that was not on one plane.
    /// cf. [`builder::try_attach_plane`](../builder/fn.try_attach_plane.html)
    #[error("cannot attach a plane to a wire that is not on one plane.")]
    WireNotInOnePlane,
}

#[test]
fn print_messages() {
    use std::io::Write;
    writeln!(&mut std::io::stderr(), "****** test of the expressions of error messages ******\n").unwrap();
    writeln!(&mut std::io::stderr(), "{}\n", Error::FromTopology(truck_topology::errors::Error::SameVertex)).unwrap();
    writeln!(&mut std::io::stderr(), "{}\n", Error::WireNotInOnePlane).unwrap();
    writeln!(&mut std::io::stderr(), "*******************************************************").unwrap();
}
