# truck-modeling

[![Crates.io](https://img.shields.io/crates/v/truck-modeling.svg)](https://crates.io/crates/truck-modeling) [![Docs.rs](https://docs.rs/truck-modeling/badge.svg)](https://docs.rs/truck-modeling)

Integrated modeling algorithms by geometry and topology

## Sample Codes

### bottle

Modeling a bottle.

This is a technical indicator for comparing with Open CASCADE Technology, a great senior.
We want to reproduce the bottle made in the [OCCT tutorial].
Now, one cannot make a fillet or run boolean operations by truck.
So, the bottle made by this script is not completed.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.

[OCCT tutorial]: https://dev.opencascade.org/doc/overview/html/occt__tutorial.html

### cone

Modeling a unit cube by three sweeps.

### cube

Modeling a unit cube by three sweeps.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.

### cylinder

Modeling a cylinder by two sweeps.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.

### punched-cube

Modeling a unit cube with a hole through it.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.

### torus-punched-cube

A cube punched by a torus.

### torus

Modeling a torus by two sweeps.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.

### tsudumi

Modeling a one-leaf hyperboloid.

Generated json file can be visualized by `simple-shape-viewer`, an example of `truck-rendimpl`.
