//! Trout is a tree-based routing library.
//! It is fairly generic, but designed to be used for HTTP servers.

#![warn(missing_docs)]

#[cfg(feature = "hyper")]
pub mod hyper;
mod internal;
pub mod node;

pub use node::Node;

#[derive(Debug, Clone, Copy)]
/// Ways that routing can fail
pub enum RoutingFailure {
    /// No node was found for the request path
    NotFound,
    /// No handler was found for the request method
    MethodNotAllowed,
}

/// Trait to represent a Request which can be handled
pub trait Request {
    /// Path of request. Should *not* have a leading slash.
    fn path<'a>(&'a self) -> &'a str;
    /// Request method, as in HTTP
    fn method<'a>(&'a self) -> &'a str;
}

impl Request for String {
    fn path(&self) -> &str {
        &self
    }

    fn method(&self) -> &str {
        ""
    }
}
