//! Provides implementations for more convenient use with hyper.

use crate::RoutingFailure;

impl<B> crate::Request for hyper::Request<B> {
    fn path(&self) -> &str {
        let path = self.uri().path();
        assert!(path.starts_with('/'));
        &path[1..]
    }

    fn method(&self) -> &str {
        self.method().as_str()
    }
}

/// Extension trait for RoutingFailure to provide `to_simple_response`
pub trait RoutingFailureExtHyper {
    /// Convert a `RoutingFailure` to a simple hyper Response
    fn to_simple_response<B: From<&'static str>>(&self) -> hyper::Response<B>;
}

impl RoutingFailureExtHyper for RoutingFailure {
    fn to_simple_response<B: From<&'static str>>(&self) -> hyper::Response<B> {
        let code = match self {
            RoutingFailure::NotFound => hyper::StatusCode::NOT_FOUND,
            RoutingFailure::MethodNotAllowed => hyper::StatusCode::METHOD_NOT_ALLOWED,
        };

        let mut resp = hyper::Response::new(code.canonical_reason().unwrap().into());
        *resp.status_mut() = code;

        resp
    }
}
