use trout::hyper::RoutingFailureExtHyper;

#[tokio::main]
async fn main() {
    let target_node = trout::Node::new().with_handler_async("GET", |(target,), _, _| async move {
        Ok::<_, std::convert::Infallible>(hyper::Response::new(hyper::Body::from(format!(
            "Hello, {}!",
            target
        ))))
    });

    let root = trout::Node::new()
        .with_handler_async("GET", |_, _, _| async {
            Ok(hyper::Response::new(hyper::Body::from("Hello, world!")))
        })
        .with_child(
            "target",
            trout::Node::new().with_child_parse::<String, _>(target_node),
        );

    let root = std::sync::Arc::new(root);

    hyper::Server::bind(&std::net::SocketAddr::from(([127, 0, 0, 1], 3000)))
        .serve(hyper::service::make_service_fn(move |_conn| {
            let root = root.clone();
            async {
                Ok::<_, std::convert::Infallible>(hyper::service::service_fn(move |req| {
                    let root = root.clone();
                    async move {
                        match root.route(req, ()) {
                            Ok(task) => task.await,
                            Err(err) => Ok(err.to_simple_response()),
                        }
                    }
                }))
            }
        }))
        .await
        .unwrap();
}
