# Tri-Sync CLI

[Crates.io](https://crates.io/crates/trisync) package

A friendly CLI Tool for automating synchronization of multiple TRIRIGA environment by using the OM API.

To install using `crate` (You will need [rustup](https://rustup.rs/))

`crate install trisync`

To build from source

`cargo build --release`

## Known issues

### Unauthenticated SSH Key

If you encounter the following error

```azurecli
thread 'main' panicked at 'called `Result::unwrap()` on an `Err` value: Error { code: -1, klass: 23, message: "Failed to authenticate SSH session: " }'
```

then it is probably because your SSH Key is not in right format. Delete your old SSH Key and regenerate a new one with

```bash
ssh-keygen -m pem
```

A _private key_ (`id_rsa` file) starting with the following characters: `-----BEGIN OPENSSH PRIVATE KEY-----` will fail the program. The private key file is expected to begin with:
`-----BEGIN RSA PRIVATE KEY-----`.

## How to use

There are several commands available. For help, simply type `trisync` or `trisync -h`

This tool only works if you have a Git directory setup with upstream. Refer to this [template](https://github.ibm.com/tri-sync/template) when initializing a new project.

### init

This command initialize the current directory to a Tri-sync project. It will walk you through a serie of questions and will create a `config.yaml` and a `tririga.yaml` file.

**Note:** you shoud not touch these files unless you know what you are doing.

Running this command when a configuration is already created will **replace** existing one.

There might be times when this command crashes which probably means the configuration files are corrupted. Make a backup of the config files and delete them, then rerun the command.

### push

This command pushes/upload all changes on the specified objects in the configuration from current TRIRIGA environment to the Github repository. You will be asked for a commit message before push.

### pull

This command pull/download all updates from the Github repository and automatically deploy the package to current TRIRIGA environment.

### deploy

This command deploys the package to TRIRIGA. You might want to use this command to force the deployment when the `push` or `pull` has failed.

### object

#### add

This command adds a TRIRIGA object to the configuration. All changes to the object will be kept track of.

#### delete

This command removes a TRIRIGA object from the configuration. You will be prompted with a multi-select dialog for selection.
