use std::error::Error;
use std::fs;
use std::path::Path;
pub struct Deployer {
	om_path: String,
	package_name: String,
}
impl Deployer {
	pub fn new(om_path: &str, package_name: &str) -> Result<Deployer, Box<dyn Error>> {
		if !Path::new(&om_path).exists() {
			panic!("The path specified for the om_path is not valid");
		}

		Ok(Deployer {
			om_path: om_path.to_owned(),
			package_name: package_name.to_owned(),
		})
	}

	pub fn execute(
		&self,
		project_dir: &str,
		target_file_name: &str,
	) -> Result<(), Box<dyn Error>> {
		let package_name_with_zip = format!("{}.zip", &self.package_name);
		let file_path = Path::new(project_dir).join(Path::new(&package_name_with_zip));
		let target_path = Path::new(&self.om_path).join(Path::new(target_file_name));
		if !file_path.exists() {
			println!("File path (project_path/package_name): {:?}", file_path);
			Err("Deployment file does not exists. Verify its path.")?
		}
		fs::copy(&file_path, &target_path)
			.expect("Error copying deployment file to target folder");
		println!(
			"File copied from {} to {}",
			file_path.to_str().unwrap(),
			self.om_path
		);
		Ok(())
	}
}
