use anchor_lang::prelude::*;

declare_id!("eP2pkrKbYtT2Xb75HhLw3LTGSA6VTZzP1NLf85CtPDZ");

static SEED: &[u8] = b"vault";
// static authority_on_chain: Pubkey = !pubkey("3sqYF5JAHWgQqCX8F9Q2PVHMHK2y5QS7YE8cTDQSypL7");

#[program]
pub mod teleport_contract {
    use super::*;

    //dont call it vault
    pub fn init_vault(ctx: Context<InitVault>, _bump: u8) -> ProgramResult {
        ctx.accounts.vault_pda.authority = ctx.accounts.creator.key();
        ctx.accounts.vault_pda.close_authority = ctx.accounts.creator.key();
        Ok(())
    }

    pub fn delete_vault(ctx: Context<DeleteVault>, _bump: u8) -> ProgramResult {
        let remaining_lamports = **ctx
            .accounts
            .vault_pda
            .to_account_info()
            .try_borrow_mut_lamports()?;

        **ctx
            .accounts
            .vault_pda
            .to_account_info()
            .try_borrow_mut_lamports()? -= remaining_lamports;

        **ctx
            .accounts
            .deletor
            .to_account_info()
            .try_borrow_mut_lamports()? += remaining_lamports;
        Ok(())
    }

    pub fn update_authority(ctx: Context<UpdateAuthority>, _bump: u8) -> ProgramResult {
        ctx.accounts.vault_pda.authority = ctx.accounts.new_authority.key();
        Ok(())
    }

    pub fn update_close_authority(ctx: Context<UpdateAuthority>, _bump: u8) -> ProgramResult {
        ctx.accounts.vault_pda.close_authority = ctx.accounts.new_authority.key();
        Ok(())
    }

    pub fn collect_money(ctx: Context<CollectMoney>, _bump: u8, amu: u64) -> ProgramResult {
        **ctx
            .accounts
            .vault_pda
            .to_account_info()
            .try_borrow_mut_lamports()? -= amu;

        **ctx
            .accounts
            .signer
            .to_account_info()
            .try_borrow_mut_lamports()? += amu;
        Ok(())
    }

    pub fn rider_pay_contract(
        ctx: Context<RiderPayContract>,
        _bump: u8,
        _vault_bump: u8,
        cost: u64,
    ) -> ProgramResult {
        let ix = anchor_lang::solana_program::system_instruction::transfer(
            &ctx.accounts.rider.key(),
            &ctx.accounts.vault_pda.key(),
            cost,
        );

        anchor_lang::solana_program::program::invoke(
            &ix,
            &[
                ctx.accounts.rider.to_account_info(),
                ctx.accounts.vault_pda.to_account_info(),
                ctx.accounts.system_program.to_account_info(),
            ],
        )?;

        ctx.accounts.rider_paid_pda.payment = cost;

        Ok(())
    }

    pub fn end_search(ctx: Context<EndSearch>, _bump: u8, _vault_bump: u8) -> ProgramResult {
        let cost = ctx.accounts.rider_paid_pda.payment.clone();

        **ctx
            .accounts
            .vault_pda
            .to_account_info()
            .try_borrow_mut_lamports()? -= cost;

        **ctx
            .accounts
            .rider
            .to_account_info()
            .try_borrow_mut_lamports()? += cost;

        let remaining_lamports = **ctx
            .accounts
            .rider_paid_pda
            .to_account_info()
            .try_borrow_mut_lamports()?;

        **ctx
            .accounts
            .rider_paid_pda
            .to_account_info()
            .try_borrow_mut_lamports()? -= remaining_lamports;

        **ctx
            .accounts
            .rider
            .to_account_info()
            .try_borrow_mut_lamports()? += remaining_lamports;
        Ok(())
    }

    pub fn close_pda(ctx: Context<ClosePDA>, _bump: u8) -> ProgramResult {
        let remaining_lamports = **ctx
            .accounts
            .rider_paid_pda
            .to_account_info()
            .try_borrow_mut_lamports()?;

        **ctx
            .accounts
            .rider_paid_pda
            .to_account_info()
            .try_borrow_mut_lamports()? -= remaining_lamports;

        **ctx
            .accounts
            .rider
            .to_account_info()
            .try_borrow_mut_lamports()? += remaining_lamports;
        Ok(())
    }
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct InitVault<'info> {
    #[account(mut)]
    creator: Signer<'info>,
    #[account(init, seeds=[b"vault"], bump, payer=creator, space=200)]
    vault_pda: Account<'info, VaultPDA>,
    system_program: Program<'info, System>,
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct DeleteVault<'info> {
    #[account(mut)]
    deletor: Signer<'info>,
    #[account(mut, seeds=[b"vault"], bump)]
    vault_pda: Account<'info, VaultPDA>,
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct UpdateAuthority<'info> {
    #[account(mut, constraint=signer.key()==vault_pda.authority)]
    signer: Signer<'info>,
    #[account(seeds=[b"vault"], bump)]
    vault_pda: Account<'info, VaultPDA>,
    new_authority: AccountInfo<'info>,
    system_program: Program<'info, System>,
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct CollectMoney<'info> {
    #[account(mut, constraint=signer.key()==vault_pda.authority)]
    signer: Signer<'info>,
    #[account(seeds=[b"vault"], bump)]
    vault_pda: Account<'info, VaultPDA>,
    system_program: Program<'info, System>,
}

#[derive(Accounts)]
#[instruction(bump: u8, vault_bump: u8)]
pub struct RiderPayContract<'info> {
    rider: Signer<'info>,
    #[account(init, seeds=[rider.key.as_ref()], bump, payer=rider, space=80)]
    rider_paid_pda: Account<'info, RiderPaidPDA>,
    #[account(mut, seeds=[SEED], bump=vault_bump)]
    vault_pda: AccountInfo<'info>,
    system_program: Program<'info, System>,
}

#[derive(Accounts)]
#[instruction(bump: u8, vault_bump: u8)]
pub struct EndSearch<'info> {
    #[account(mut, constraint=authority.key()==vault_pda.close_authority)]
    authority: Signer<'info>,
    #[account(mut)]
    rider: Signer<'info>,
    #[account(mut, seeds=[rider.key.as_ref()], bump=bump)]
    rider_paid_pda: Account<'info, RiderPaidPDA>,
    #[account(mut, seeds=[SEED], bump=vault_bump)]
    vault_pda: Account<'info, VaultPDA>,
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct ClosePDA<'info> {
    #[account(mut)]
    rider: Signer<'info>,
    #[account(mut, seeds=[rider.key.as_ref()], bump)]
    rider_paid_pda: Account<'info, RiderPaidPDA>,
}

#[derive(Accounts)]
#[instruction(bump: u8)]
pub struct RiderPayBump<'info> {
    rider: Signer<'info>,
    #[account(mut)]
    bumped_account: AccountInfo<'info>,
    system_program: Program<'info, System>,
}

#[account]
#[derive(Default)]
pub struct VaultPDA {
    pub authority: Pubkey,
    pub close_authority: Pubkey,
}

#[account]
#[derive(Default)]
pub struct DriverPDA {
    driver: Pubkey,
    is_looking: bool,
    region: u64,
    lat: u64,
    long: u64,
}

#[account]
#[derive(Default)]
pub struct RiderPaidPDA {
    pub payment: u64,
}
