use gtk::gdk;
use gtk::prelude::*;
use std::sync::Once;

#[cfg(feature = "bindings")]
pub mod ffi;
pub mod prelude;
pub mod subclass;

mod notification;
mod notification_bin;
mod notification_widget;
mod progress_icon;
mod qr_code;

pub use notification::Notification;
pub use notification_bin::NotificationBin;
pub(crate) use notification_widget::NotificationWidget;
pub use progress_icon::ProgressIcon;
pub use qr_code::QRCode;

/// Initializes Trinket.
///
/// Call this function just after initializing GTK, if you are using
/// `GtkApplication` it means it must be called when the
/// `GApplication::startup` signal is emitted.
///
/// If Trinket has already been initialized, the function will simply return.
///
/// This makes sure translations, and types for the Trinket
/// library are set up properly.
#[doc(alias = "tri_init")]
pub fn init() {
    static INIT: Once = Once::new();

    INIT.call_once(|| {
        ProgressIcon::static_type();
        NotificationBin::static_type();

        gtk::init().unwrap();
        let provider = gtk::CssProvider::new();
        provider.load_from_data(include_bytes!("style.css"));
        if let Some(display) = gdk::Display::default() {
            gtk::StyleContext::add_provider_for_display(
                &display,
                &provider,
                gtk::STYLE_PROVIDER_PRIORITY_THEME,
            );
        }
    });
}
