#[cfg(feature = "bindings")]
mod ffi;
mod imp;

use gtk::glib;
use gtk::prelude::*;
use gtk::subclass::prelude::*;

glib::wrapper! {
    pub struct ProgressIcon(ObjectSubclass<imp::ProgressIcon>)
        @extends gtk::Widget;
}

impl Default for ProgressIcon {
    fn default() -> Self {
        glib::Object::new(&[]).unwrap()
    }
}

impl ProgressIcon {
    pub fn new() -> Self {
        Self::default()
    }
}

pub trait ProgressIconExt {
    fn progress(&self) -> f32;
    fn set_progress(&self, progress: f32);
    fn icon_size(&self) -> u32;
    fn set_icon_size(&self, icon_size: u32);
    fn inverted(&self) -> bool;
    fn set_inverted(&self, inverted: bool);
    fn clockwise(&self) -> bool;
    fn set_clockwise(&self, clockwise: bool);
}

impl<W: IsA<ProgressIcon>> ProgressIconExt for W {
    fn progress(&self) -> f32 {
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        *this.progress.borrow()
    }
    fn set_progress(&self, progress: f32) {
        if progress == self.progress() {
            return;
        }
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        let clamped = progress.clamp(0.0, 1.0);
        this.progress.replace(clamped);
        self.as_ref().queue_draw();
        self.notify("progress");
    }

    fn icon_size(&self) -> u32 {
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        *this.icon_size.borrow()
    }
    fn set_icon_size(&self, icon_size: u32) {
        if icon_size == self.icon_size() {
            return;
        }
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        this.icon_size.replace(icon_size);
        self.as_ref().queue_draw();
        self.as_ref().queue_resize();
        self.notify("icon-size");
    }

    fn inverted(&self) -> bool {
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        *this.inverted.borrow()
    }
    fn set_inverted(&self, inverted: bool) {
        if inverted == self.inverted() {
            return;
        }
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        this.inverted.replace(inverted);
        self.as_ref().queue_draw();
        self.notify("inverted");
    }

    fn clockwise(&self) -> bool {
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        *this.clockwise.borrow()
    }
    fn set_clockwise(&self, clockwise: bool) {
        if clockwise == self.clockwise() {
            return;
        }
        let this = imp::ProgressIcon::from_instance(self.as_ref());
        this.clockwise.replace(clockwise);
        self.as_ref().queue_draw();
        self.notify("clockwise");
    }
}
