// use gettextrs::*;
use gtk::prelude::*;
use once_cell::sync::OnceCell;

// #[rustfmt::skip]
// mod config;
#[cfg(feature = "bindings")]
pub mod ffi;
pub mod prelude;
pub mod subclass;

pub mod progress_icon;

pub use progress_icon::ProgressIcon;

static INITIALIZED: OnceCell<()> = OnceCell::new();

/// Initializes Trinket.
///
/// Call this function just after initializing GTK, if you are using
/// `Gtk::Application` it means it must be called when the
/// `GApplication::startup` signal is emitted.
///
/// If Trinket has already been initialized, the function will simply return.
///
/// This makes sure translations, and types for the Trinet
/// library are set up properly.
pub fn init() {
    if INITIALIZED.get().is_some() {
        return;
    }
    // FIXME Add translations without meson.
    // setlocale(LocaleCategory::LcAll, "");
    // bindtextdomain("trinket", config::LOCALEDIR).expect("Could not bind text domain");
    // textdomain("trinket").expect("Could not set text domain");

    ProgressIcon::static_type();

    INITIALIZED.set(()).unwrap();
}
