#![forbid(unsafe_code)]
#![deny(
    missing_copy_implementations,
    missing_crate_level_docs,
    missing_debug_implementations,
    missing_docs,
    nonstandard_style,
    unused_qualifications
)]

/*!
This crate provides rustls trait implementations for trillium
client ([`RustlsConnector`]) and server ([`RustlsAcceptor`]).
*/

mod client;
pub use client::{RustlsConfig, RustlsConnector};

mod server;
pub use server::RustlsAcceptor;

pub use async_rustls;
pub use rustls;
