use crate::Receiver;

pub trait Sender<T> {
    /// Emits an event of type T to a receiver node
    /// A receiver may contain any number of child-nodes that might also be interested
    /// in the event.
    /// Should return true if the event was handeled by the receiver
    fn emit(&self, event: T, target: &mut dyn Receiver<T>) -> bool;
}
