use cc;

fn main() {
    println!("cargo:rerun-if-changed=src/triangle.c");
    let mut build = cc::Build::new();
    if !cfg!(unix) {
        build.flag("-DNO_TIMER");
    }
    if cfg!(windows) {
        build.flag("-DCPU86");
    }
    if cfg!(linux) {
        build.flag("-DLINUX");
    }
    build
        .file("src/triangle.c")
        .flag("-O")
        .flag("-DTRILIBRARY")
        .include("src")
        .define("REAL", "double")
        .warnings(false)
        .compile("triangle");
}
