use tree_sitter::Language;

extern "C" {
    fn tree_sitter_cpp() -> Language;
}

/// Returns the tree-sitter [Language][] for this grammar.
///
/// [Language]: https://docs.rs/tree-sitter/*/tree_sitter/struct.Language.html
pub fn language() -> Language {
    unsafe { tree_sitter_cpp() }
}

/// The source of the Cpp tree-sitter grammar description.
pub const GRAMMAR: &str = include_str!("../languages/tree-sitter-cpp/grammar.js");

/// The syntax highlighting query for this language.
pub const HIGHLIGHT_QUERY: &str =
    include_str!("../languages/tree-sitter-cpp/queries/highlights.scm");

/// The content of the [`node-types.json`][] file for this grammar.
///
/// [`node-types.json`]: https://tree-sitter.github.io/tree-sitter/using-parsers#static-node-types
pub const NODE_TYPES: &str = include_str!("../languages/tree-sitter-cpp/src/node-types.json");

#[cfg(test)]
mod tests {
    #[test]
    fn can_load_grammar() {
        let mut parser = tree_sitter::Parser::new();
        parser
            .set_language(super::language())
            .expect("Error loading Cpp grammar");
    }
}
