#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1039
#define LARGE_STATE_COUNT 274
#define SYMBOL_COUNT 280
#define ALIAS_COUNT 1
#define TOKEN_COUNT 126
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 172

enum {
  sym_identifier = 1,
  sym_decimal_integer_literal = 2,
  sym_hex_integer_literal = 3,
  sym_octal_integer_literal = 4,
  sym_binary_integer_literal = 5,
  sym_decimal_floating_point_literal = 6,
  sym_hex_floating_point_literal = 7,
  sym_true = 8,
  sym_false = 9,
  sym_character_literal = 10,
  sym_string_literal = 11,
  sym_null_literal = 12,
  anon_sym_LPAREN = 13,
  anon_sym_AMP = 14,
  anon_sym_RPAREN = 15,
  anon_sym_EQ = 16,
  anon_sym_PLUS_EQ = 17,
  anon_sym_DASH_EQ = 18,
  anon_sym_STAR_EQ = 19,
  anon_sym_SLASH_EQ = 20,
  anon_sym_AMP_EQ = 21,
  anon_sym_PIPE_EQ = 22,
  anon_sym_CARET_EQ = 23,
  anon_sym_PERCENT_EQ = 24,
  anon_sym_LT_LT_EQ = 25,
  anon_sym_GT_GT_EQ = 26,
  anon_sym_GT_GT_GT_EQ = 27,
  anon_sym_GT = 28,
  anon_sym_LT = 29,
  anon_sym_GT_EQ = 30,
  anon_sym_LT_EQ = 31,
  anon_sym_EQ_EQ = 32,
  anon_sym_BANG_EQ = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_PLUS = 36,
  anon_sym_DASH = 37,
  anon_sym_STAR = 38,
  anon_sym_SLASH = 39,
  anon_sym_PIPE = 40,
  anon_sym_CARET = 41,
  anon_sym_PERCENT = 42,
  anon_sym_LT_LT = 43,
  anon_sym_GT_GT = 44,
  anon_sym_GT_GT_GT = 45,
  anon_sym_instanceof = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_COMMA = 48,
  anon_sym_QMARK = 49,
  anon_sym_COLON = 50,
  anon_sym_BANG = 51,
  anon_sym_TILDE = 52,
  anon_sym_PLUS_PLUS = 53,
  anon_sym_DASH_DASH = 54,
  anon_sym_new = 55,
  anon_sym_LBRACK = 56,
  anon_sym_RBRACK = 57,
  anon_sym_DOT = 58,
  anon_sym_class = 59,
  anon_sym_COLON_COLON = 60,
  anon_sym_extends = 61,
  anon_sym_switch = 62,
  anon_sym_LBRACE = 63,
  anon_sym_RBRACE = 64,
  anon_sym_case = 65,
  anon_sym_default = 66,
  anon_sym_SEMI = 67,
  anon_sym_assert = 68,
  anon_sym_do = 69,
  anon_sym_while = 70,
  anon_sym_break = 71,
  anon_sym_continue = 72,
  anon_sym_return = 73,
  anon_sym_yield = 74,
  anon_sym_synchronized = 75,
  anon_sym_throw = 76,
  anon_sym_try = 77,
  anon_sym_catch = 78,
  anon_sym_finally = 79,
  anon_sym_if = 80,
  anon_sym_else = 81,
  anon_sym_for = 82,
  anon_sym_AT = 83,
  anon_sym_open = 84,
  anon_sym_module = 85,
  anon_sym_requires = 86,
  anon_sym_exports = 87,
  anon_sym_to = 88,
  anon_sym_opens = 89,
  anon_sym_uses = 90,
  anon_sym_provides = 91,
  anon_sym_with = 92,
  anon_sym_transitive = 93,
  anon_sym_static = 94,
  anon_sym_package = 95,
  anon_sym_import = 96,
  anon_sym_enum = 97,
  anon_sym_public = 98,
  anon_sym_protected = 99,
  anon_sym_private = 100,
  anon_sym_abstract = 101,
  anon_sym_final = 102,
  anon_sym_strictfp = 103,
  anon_sym_native = 104,
  anon_sym_transient = 105,
  anon_sym_volatile = 106,
  anon_sym_implements = 107,
  anon_sym_record = 108,
  anon_sym_ATinterface = 109,
  anon_sym_interface = 110,
  anon_sym_byte = 111,
  anon_sym_short = 112,
  anon_sym_int = 113,
  anon_sym_long = 114,
  anon_sym_char = 115,
  anon_sym_float = 116,
  anon_sym_double = 117,
  sym_boolean_type = 118,
  sym_void_type = 119,
  anon_sym_DOT_DOT_DOT = 120,
  anon_sym_throws = 121,
  sym_this = 122,
  sym_super = 123,
  sym_line_comment = 124,
  sym_block_comment = 125,
  sym_program = 126,
  sym__literal = 127,
  sym_expression = 128,
  sym_cast_expression = 129,
  sym_assignment_expression = 130,
  sym_binary_expression = 131,
  sym_instanceof_expression = 132,
  sym_lambda_expression = 133,
  sym_inferred_parameters = 134,
  sym_ternary_expression = 135,
  sym_unary_expression = 136,
  sym_update_expression = 137,
  sym_primary_expression = 138,
  sym_array_creation_expression = 139,
  sym_dimensions_expr = 140,
  sym_parenthesized_expression = 141,
  sym_class_literal = 142,
  sym_object_creation_expression = 143,
  sym__unqualified_object_creation_expression = 144,
  sym_field_access = 145,
  sym_array_access = 146,
  sym_method_invocation = 147,
  sym_argument_list = 148,
  sym_method_reference = 149,
  sym_type_arguments = 150,
  sym_wildcard = 151,
  sym__wildcard_bounds = 152,
  sym_dimensions = 153,
  sym_switch_expression = 154,
  sym_switch_block = 155,
  sym_switch_block_statement_group = 156,
  sym_switch_rule = 157,
  sym_switch_label = 158,
  sym_statement = 159,
  sym_block = 160,
  sym_expression_statement = 161,
  sym_labeled_statement = 162,
  sym_assert_statement = 163,
  sym_do_statement = 164,
  sym_break_statement = 165,
  sym_continue_statement = 166,
  sym_return_statement = 167,
  sym_yield_statement = 168,
  sym_synchronized_statement = 169,
  sym_throw_statement = 170,
  sym_try_statement = 171,
  sym_catch_clause = 172,
  sym_catch_formal_parameter = 173,
  sym_catch_type = 174,
  sym_finally_clause = 175,
  sym_try_with_resources_statement = 176,
  sym_resource_specification = 177,
  sym_resource = 178,
  sym_if_statement = 179,
  sym_while_statement = 180,
  sym_for_statement = 181,
  sym_enhanced_for_statement = 182,
  sym__annotation = 183,
  sym_marker_annotation = 184,
  sym_annotation = 185,
  sym_annotation_argument_list = 186,
  sym_element_value_pair = 187,
  sym__element_value = 188,
  sym_element_value_array_initializer = 189,
  sym_declaration = 190,
  sym_module_declaration = 191,
  sym_module_body = 192,
  sym_module_directive = 193,
  sym_requires_modifier = 194,
  sym_package_declaration = 195,
  sym_import_declaration = 196,
  sym_asterisk = 197,
  sym_enum_declaration = 198,
  sym_enum_body = 199,
  sym_enum_body_declarations = 200,
  sym_enum_constant = 201,
  sym_class_declaration = 202,
  sym_modifiers = 203,
  sym_type_parameters = 204,
  sym_type_parameter = 205,
  sym_type_bound = 206,
  sym_superclass = 207,
  sym_super_interfaces = 208,
  sym_interface_type_list = 209,
  sym_class_body = 210,
  sym_static_initializer = 211,
  sym_constructor_declaration = 212,
  sym__constructor_declarator = 213,
  sym_constructor_body = 214,
  sym_explicit_constructor_invocation = 215,
  sym_scoped_identifier = 216,
  sym_field_declaration = 217,
  sym_record_declaration = 218,
  sym_annotation_type_declaration = 219,
  sym_annotation_type_body = 220,
  sym_annotation_type_element_declaration = 221,
  sym__default_value = 222,
  sym_interface_declaration = 223,
  sym_extends_interfaces = 224,
  sym_interface_body = 225,
  sym_constant_declaration = 226,
  sym__variable_declarator_list = 227,
  sym_variable_declarator = 228,
  sym__variable_declarator_id = 229,
  sym_array_initializer = 230,
  sym__type = 231,
  sym__unannotated_type = 232,
  sym_annotated_type = 233,
  sym_scoped_type_identifier = 234,
  sym_generic_type = 235,
  sym_array_type = 236,
  sym_integral_type = 237,
  sym_floating_point_type = 238,
  sym__method_header = 239,
  sym__method_declarator = 240,
  sym_formal_parameters = 241,
  sym_formal_parameter = 242,
  sym_receiver_parameter = 243,
  sym_spread_parameter = 244,
  sym_throws = 245,
  sym_local_variable_declaration = 246,
  sym_method_declaration = 247,
  aux_sym_program_repeat1 = 248,
  aux_sym_cast_expression_repeat1 = 249,
  aux_sym_inferred_parameters_repeat1 = 250,
  aux_sym_array_creation_expression_repeat1 = 251,
  aux_sym_dimensions_expr_repeat1 = 252,
  aux_sym_argument_list_repeat1 = 253,
  aux_sym_type_arguments_repeat1 = 254,
  aux_sym_dimensions_repeat1 = 255,
  aux_sym_switch_block_repeat1 = 256,
  aux_sym_switch_block_repeat2 = 257,
  aux_sym_switch_block_statement_group_repeat1 = 258,
  aux_sym_try_statement_repeat1 = 259,
  aux_sym_catch_type_repeat1 = 260,
  aux_sym_resource_specification_repeat1 = 261,
  aux_sym_for_statement_repeat1 = 262,
  aux_sym_for_statement_repeat2 = 263,
  aux_sym_annotation_argument_list_repeat1 = 264,
  aux_sym_element_value_array_initializer_repeat1 = 265,
  aux_sym_module_body_repeat1 = 266,
  aux_sym_module_directive_repeat1 = 267,
  aux_sym_module_directive_repeat2 = 268,
  aux_sym_enum_body_repeat1 = 269,
  aux_sym_enum_body_declarations_repeat1 = 270,
  aux_sym_modifiers_repeat1 = 271,
  aux_sym_type_parameters_repeat1 = 272,
  aux_sym_type_bound_repeat1 = 273,
  aux_sym_interface_type_list_repeat1 = 274,
  aux_sym_annotation_type_body_repeat1 = 275,
  aux_sym_interface_body_repeat1 = 276,
  aux_sym__variable_declarator_list_repeat1 = 277,
  aux_sym_array_initializer_repeat1 = 278,
  aux_sym_formal_parameters_repeat1 = 279,
  alias_sym_type_identifier = 280,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_octal_integer_literal] = "octal_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [sym_hex_floating_point_literal] = "hex_floating_point_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_character_literal] = "character_literal",
  [sym_string_literal] = "string_literal",
  [sym_null_literal] = "null_literal",
  [anon_sym_LPAREN] = "(",
  [anon_sym_AMP] = "&",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_COMMA] = ",",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_extends] = "extends",
  [anon_sym_switch] = "switch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_SEMI] = ";",
  [anon_sym_assert] = "assert",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_return] = "return",
  [anon_sym_yield] = "yield",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_throw] = "throw",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_AT] = "@",
  [anon_sym_open] = "open",
  [anon_sym_module] = "module",
  [anon_sym_requires] = "requires",
  [anon_sym_exports] = "exports",
  [anon_sym_to] = "to",
  [anon_sym_opens] = "opens",
  [anon_sym_uses] = "uses",
  [anon_sym_provides] = "provides",
  [anon_sym_with] = "with",
  [anon_sym_transitive] = "transitive",
  [anon_sym_static] = "static",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_enum] = "enum",
  [anon_sym_public] = "public",
  [anon_sym_protected] = "protected",
  [anon_sym_private] = "private",
  [anon_sym_abstract] = "abstract",
  [anon_sym_final] = "final",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_native] = "native",
  [anon_sym_transient] = "transient",
  [anon_sym_volatile] = "volatile",
  [anon_sym_implements] = "implements",
  [anon_sym_record] = "record",
  [anon_sym_ATinterface] = "@interface",
  [anon_sym_interface] = "interface",
  [anon_sym_byte] = "byte",
  [anon_sym_short] = "short",
  [anon_sym_int] = "int",
  [anon_sym_long] = "long",
  [anon_sym_char] = "char",
  [anon_sym_float] = "float",
  [anon_sym_double] = "double",
  [sym_boolean_type] = "boolean_type",
  [sym_void_type] = "void_type",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_throws] = "throws",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_line_comment] = "line_comment",
  [sym_block_comment] = "block_comment",
  [sym_program] = "program",
  [sym__literal] = "_literal",
  [sym_expression] = "expression",
  [sym_cast_expression] = "cast_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_instanceof_expression] = "instanceof_expression",
  [sym_lambda_expression] = "lambda_expression",
  [sym_inferred_parameters] = "inferred_parameters",
  [sym_ternary_expression] = "ternary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_array_creation_expression] = "array_creation_expression",
  [sym_dimensions_expr] = "dimensions_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_class_literal] = "class_literal",
  [sym_object_creation_expression] = "object_creation_expression",
  [sym__unqualified_object_creation_expression] = "_unqualified_object_creation_expression",
  [sym_field_access] = "field_access",
  [sym_array_access] = "array_access",
  [sym_method_invocation] = "method_invocation",
  [sym_argument_list] = "argument_list",
  [sym_method_reference] = "method_reference",
  [sym_type_arguments] = "type_arguments",
  [sym_wildcard] = "wildcard",
  [sym__wildcard_bounds] = "_wildcard_bounds",
  [sym_dimensions] = "dimensions",
  [sym_switch_expression] = "switch_expression",
  [sym_switch_block] = "switch_block",
  [sym_switch_block_statement_group] = "switch_block_statement_group",
  [sym_switch_rule] = "switch_rule",
  [sym_switch_label] = "switch_label",
  [sym_statement] = "statement",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_return_statement] = "return_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_synchronized_statement] = "synchronized_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_catch_formal_parameter] = "catch_formal_parameter",
  [sym_catch_type] = "catch_type",
  [sym_finally_clause] = "finally_clause",
  [sym_try_with_resources_statement] = "try_with_resources_statement",
  [sym_resource_specification] = "resource_specification",
  [sym_resource] = "resource",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym_enhanced_for_statement] = "enhanced_for_statement",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_annotation_argument_list] = "annotation_argument_list",
  [sym_element_value_pair] = "element_value_pair",
  [sym__element_value] = "_element_value",
  [sym_element_value_array_initializer] = "element_value_array_initializer",
  [sym_declaration] = "declaration",
  [sym_module_declaration] = "module_declaration",
  [sym_module_body] = "module_body",
  [sym_module_directive] = "module_directive",
  [sym_requires_modifier] = "requires_modifier",
  [sym_package_declaration] = "package_declaration",
  [sym_import_declaration] = "import_declaration",
  [sym_asterisk] = "asterisk",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_body_declarations] = "enum_body_declarations",
  [sym_enum_constant] = "enum_constant",
  [sym_class_declaration] = "class_declaration",
  [sym_modifiers] = "modifiers",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_super_interfaces] = "super_interfaces",
  [sym_interface_type_list] = "interface_type_list",
  [sym_class_body] = "class_body",
  [sym_static_initializer] = "static_initializer",
  [sym_constructor_declaration] = "constructor_declaration",
  [sym__constructor_declarator] = "_constructor_declarator",
  [sym_constructor_body] = "constructor_body",
  [sym_explicit_constructor_invocation] = "explicit_constructor_invocation",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_field_declaration] = "field_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_annotation_type_declaration] = "annotation_type_declaration",
  [sym_annotation_type_body] = "annotation_type_body",
  [sym_annotation_type_element_declaration] = "annotation_type_element_declaration",
  [sym__default_value] = "_default_value",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_interfaces] = "extends_interfaces",
  [sym_interface_body] = "interface_body",
  [sym_constant_declaration] = "constant_declaration",
  [sym__variable_declarator_list] = "_variable_declarator_list",
  [sym_variable_declarator] = "variable_declarator",
  [sym__variable_declarator_id] = "_variable_declarator_id",
  [sym_array_initializer] = "array_initializer",
  [sym__type] = "_type",
  [sym__unannotated_type] = "_unannotated_type",
  [sym_annotated_type] = "annotated_type",
  [sym_scoped_type_identifier] = "scoped_type_identifier",
  [sym_generic_type] = "generic_type",
  [sym_array_type] = "array_type",
  [sym_integral_type] = "integral_type",
  [sym_floating_point_type] = "floating_point_type",
  [sym__method_header] = "_method_header",
  [sym__method_declarator] = "_method_declarator",
  [sym_formal_parameters] = "formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym_receiver_parameter] = "receiver_parameter",
  [sym_spread_parameter] = "spread_parameter",
  [sym_throws] = "throws",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_method_declaration] = "method_declaration",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_cast_expression_repeat1] = "cast_expression_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_array_creation_expression_repeat1] = "array_creation_expression_repeat1",
  [aux_sym_dimensions_expr_repeat1] = "dimensions_expr_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_block_repeat2] = "switch_block_repeat2",
  [aux_sym_switch_block_statement_group_repeat1] = "switch_block_statement_group_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_catch_type_repeat1] = "catch_type_repeat1",
  [aux_sym_resource_specification_repeat1] = "resource_specification_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_for_statement_repeat2] = "for_statement_repeat2",
  [aux_sym_annotation_argument_list_repeat1] = "annotation_argument_list_repeat1",
  [aux_sym_element_value_array_initializer_repeat1] = "element_value_array_initializer_repeat1",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_directive_repeat1] = "module_directive_repeat1",
  [aux_sym_module_directive_repeat2] = "module_directive_repeat2",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_enum_body_declarations_repeat1] = "enum_body_declarations_repeat1",
  [aux_sym_modifiers_repeat1] = "modifiers_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_bound_repeat1] = "type_bound_repeat1",
  [aux_sym_interface_type_list_repeat1] = "interface_type_list_repeat1",
  [aux_sym_annotation_type_body_repeat1] = "annotation_type_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym__variable_declarator_list_repeat1] = "_variable_declarator_list_repeat1",
  [aux_sym_array_initializer_repeat1] = "array_initializer_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_octal_integer_literal] = sym_octal_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [sym_hex_floating_point_literal] = sym_hex_floating_point_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_character_literal] = sym_character_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_null_literal] = sym_null_literal,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_exports] = anon_sym_exports,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_opens] = anon_sym_opens,
  [anon_sym_uses] = anon_sym_uses,
  [anon_sym_provides] = anon_sym_provides,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_ATinterface] = anon_sym_ATinterface,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_char] = anon_sym_char,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_double] = anon_sym_double,
  [sym_boolean_type] = sym_boolean_type,
  [sym_void_type] = sym_void_type,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_throws] = anon_sym_throws,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_line_comment] = sym_line_comment,
  [sym_block_comment] = sym_block_comment,
  [sym_program] = sym_program,
  [sym__literal] = sym__literal,
  [sym_expression] = sym_expression,
  [sym_cast_expression] = sym_cast_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_instanceof_expression] = sym_instanceof_expression,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_inferred_parameters] = sym_inferred_parameters,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_array_creation_expression] = sym_array_creation_expression,
  [sym_dimensions_expr] = sym_dimensions_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_class_literal] = sym_class_literal,
  [sym_object_creation_expression] = sym_object_creation_expression,
  [sym__unqualified_object_creation_expression] = sym__unqualified_object_creation_expression,
  [sym_field_access] = sym_field_access,
  [sym_array_access] = sym_array_access,
  [sym_method_invocation] = sym_method_invocation,
  [sym_argument_list] = sym_argument_list,
  [sym_method_reference] = sym_method_reference,
  [sym_type_arguments] = sym_type_arguments,
  [sym_wildcard] = sym_wildcard,
  [sym__wildcard_bounds] = sym__wildcard_bounds,
  [sym_dimensions] = sym_dimensions,
  [sym_switch_expression] = sym_switch_expression,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_block_statement_group] = sym_switch_block_statement_group,
  [sym_switch_rule] = sym_switch_rule,
  [sym_switch_label] = sym_switch_label,
  [sym_statement] = sym_statement,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_synchronized_statement] = sym_synchronized_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_catch_formal_parameter] = sym_catch_formal_parameter,
  [sym_catch_type] = sym_catch_type,
  [sym_finally_clause] = sym_finally_clause,
  [sym_try_with_resources_statement] = sym_try_with_resources_statement,
  [sym_resource_specification] = sym_resource_specification,
  [sym_resource] = sym_resource,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_enhanced_for_statement] = sym_enhanced_for_statement,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_annotation_argument_list] = sym_annotation_argument_list,
  [sym_element_value_pair] = sym_element_value_pair,
  [sym__element_value] = sym__element_value,
  [sym_element_value_array_initializer] = sym_element_value_array_initializer,
  [sym_declaration] = sym_declaration,
  [sym_module_declaration] = sym_module_declaration,
  [sym_module_body] = sym_module_body,
  [sym_module_directive] = sym_module_directive,
  [sym_requires_modifier] = sym_requires_modifier,
  [sym_package_declaration] = sym_package_declaration,
  [sym_import_declaration] = sym_import_declaration,
  [sym_asterisk] = sym_asterisk,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_body_declarations] = sym_enum_body_declarations,
  [sym_enum_constant] = sym_enum_constant,
  [sym_class_declaration] = sym_class_declaration,
  [sym_modifiers] = sym_modifiers,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_super_interfaces] = sym_super_interfaces,
  [sym_interface_type_list] = sym_interface_type_list,
  [sym_class_body] = sym_class_body,
  [sym_static_initializer] = sym_static_initializer,
  [sym_constructor_declaration] = sym_constructor_declaration,
  [sym__constructor_declarator] = sym__constructor_declarator,
  [sym_constructor_body] = sym_constructor_body,
  [sym_explicit_constructor_invocation] = sym_explicit_constructor_invocation,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_field_declaration] = sym_field_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_annotation_type_declaration] = sym_annotation_type_declaration,
  [sym_annotation_type_body] = sym_annotation_type_body,
  [sym_annotation_type_element_declaration] = sym_annotation_type_element_declaration,
  [sym__default_value] = sym__default_value,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_interfaces] = sym_extends_interfaces,
  [sym_interface_body] = sym_interface_body,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym__variable_declarator_list] = sym__variable_declarator_list,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym__variable_declarator_id] = sym__variable_declarator_id,
  [sym_array_initializer] = sym_array_initializer,
  [sym__type] = sym__type,
  [sym__unannotated_type] = sym__unannotated_type,
  [sym_annotated_type] = sym_annotated_type,
  [sym_scoped_type_identifier] = sym_scoped_type_identifier,
  [sym_generic_type] = sym_generic_type,
  [sym_array_type] = sym_array_type,
  [sym_integral_type] = sym_integral_type,
  [sym_floating_point_type] = sym_floating_point_type,
  [sym__method_header] = sym__method_header,
  [sym__method_declarator] = sym__method_declarator,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym_receiver_parameter] = sym_receiver_parameter,
  [sym_spread_parameter] = sym_spread_parameter,
  [sym_throws] = sym_throws,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_cast_expression_repeat1] = aux_sym_cast_expression_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_array_creation_expression_repeat1] = aux_sym_array_creation_expression_repeat1,
  [aux_sym_dimensions_expr_repeat1] = aux_sym_dimensions_expr_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_block_repeat2] = aux_sym_switch_block_repeat2,
  [aux_sym_switch_block_statement_group_repeat1] = aux_sym_switch_block_statement_group_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_catch_type_repeat1] = aux_sym_catch_type_repeat1,
  [aux_sym_resource_specification_repeat1] = aux_sym_resource_specification_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym_for_statement_repeat2] = aux_sym_for_statement_repeat2,
  [aux_sym_annotation_argument_list_repeat1] = aux_sym_annotation_argument_list_repeat1,
  [aux_sym_element_value_array_initializer_repeat1] = aux_sym_element_value_array_initializer_repeat1,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_directive_repeat1] = aux_sym_module_directive_repeat1,
  [aux_sym_module_directive_repeat2] = aux_sym_module_directive_repeat2,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_enum_body_declarations_repeat1] = aux_sym_enum_body_declarations_repeat1,
  [aux_sym_modifiers_repeat1] = aux_sym_modifiers_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_bound_repeat1] = aux_sym_type_bound_repeat1,
  [aux_sym_interface_type_list_repeat1] = aux_sym_interface_type_list_repeat1,
  [aux_sym_annotation_type_body_repeat1] = aux_sym_annotation_type_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym__variable_declarator_list_repeat1] = aux_sym__variable_declarator_list_repeat1,
  [aux_sym_array_initializer_repeat1] = aux_sym_array_initializer_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_character_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_opens] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uses] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_provides] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_char] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean_type] = {
    .visible = true,
    .named = true,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instanceof_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_object_creation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unqualified_object_creation_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_method_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_method_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_bounds] = {
    .visible = false,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block_statement_group] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_synchronized_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_type] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_with_resources_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_resource_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_resource] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enhanced_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element_value] = {
    .visible = false,
    .named = true,
  },
  [sym_element_value_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_requires_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_package_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body_declarations] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_super_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_static_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__constructor_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_body] = {
    .visible = true,
    .named = true,
  },
  [sym_explicit_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_type_element_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__default_value] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_list] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_declarator_id] = {
    .visible = false,
    .named = true,
  },
  [sym_array_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__unannotated_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_annotated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_integral_type] = {
    .visible = true,
    .named = true,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [sym__method_header] = {
    .visible = false,
    .named = true,
  },
  [sym__method_declarator] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_receiver_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_throws] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cast_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_creation_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_statement_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_catch_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_resource_specification_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_value_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_directive_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_declarations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_bound_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_declarator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_array = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_constructor = 7,
  field_declarator = 8,
  field_dimensions = 9,
  field_element = 10,
  field_field = 11,
  field_index = 12,
  field_init = 13,
  field_interfaces = 14,
  field_key = 15,
  field_left = 16,
  field_name = 17,
  field_object = 18,
  field_operand = 19,
  field_operator = 20,
  field_parameters = 21,
  field_resources = 22,
  field_right = 23,
  field_scope = 24,
  field_superclass = 25,
  field_type = 26,
  field_type_arguments = 27,
  field_type_parameters = 28,
  field_update = 29,
  field_value = 30,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_array] = "array",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declarator] = "declarator",
  [field_dimensions] = "dimensions",
  [field_element] = "element",
  [field_field] = "field",
  [field_index] = "index",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_resources] = "resources",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_superclass] = "superclass",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 3},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 1},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 3},
  [15] = {.index = 17, .length = 2},
  [16] = {.index = 19, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 1},
  [22] = {.index = 26, .length = 1},
  [23] = {.index = 27, .length = 2},
  [24] = {.index = 29, .length = 2},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 31, .length = 2},
  [27] = {.index = 33, .length = 3},
  [28] = {.index = 21, .length = 2},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 36, .length = 2},
  [32] = {.index = 33, .length = 3},
  [33] = {.index = 38, .length = 2},
  [35] = {.index = 40, .length = 2},
  [36] = {.index = 42, .length = 3},
  [37] = {.index = 45, .length = 2},
  [38] = {.index = 45, .length = 2},
  [39] = {.index = 47, .length = 2},
  [40] = {.index = 49, .length = 2},
  [42] = {.index = 51, .length = 3},
  [43] = {.index = 54, .length = 1},
  [44] = {.index = 55, .length = 2},
  [45] = {.index = 57, .length = 2},
  [46] = {.index = 59, .length = 3},
  [47] = {.index = 62, .length = 3},
  [48] = {.index = 59, .length = 3},
  [49] = {.index = 62, .length = 3},
  [50] = {.index = 65, .length = 3},
  [51] = {.index = 65, .length = 3},
  [52] = {.index = 68, .length = 3},
  [53] = {.index = 71, .length = 3},
  [54] = {.index = 74, .length = 3},
  [55] = {.index = 77, .length = 2},
  [56] = {.index = 77, .length = 2},
  [57] = {.index = 79, .length = 2},
  [58] = {.index = 79, .length = 2},
  [60] = {.index = 81, .length = 2},
  [61] = {.index = 83, .length = 3},
  [62] = {.index = 83, .length = 3},
  [64] = {.index = 86, .length = 2},
  [65] = {.index = 88, .length = 2},
  [66] = {.index = 90, .length = 1},
  [67] = {.index = 91, .length = 2},
  [68] = {.index = 93, .length = 3},
  [70] = {.index = 96, .length = 3},
  [72] = {.index = 99, .length = 2},
  [73] = {.index = 101, .length = 4},
  [74] = {.index = 105, .length = 4},
  [75] = {.index = 109, .length = 5},
  [76] = {.index = 114, .length = 6},
  [77] = {.index = 120, .length = 4},
  [78] = {.index = 124, .length = 4},
  [79] = {.index = 128, .length = 4},
  [80] = {.index = 132, .length = 2},
  [81] = {.index = 134, .length = 3},
  [82] = {.index = 137, .length = 1},
  [83] = {.index = 138, .length = 2},
  [84] = {.index = 140, .length = 2},
  [85] = {.index = 142, .length = 3},
  [86] = {.index = 145, .length = 2},
  [87] = {.index = 145, .length = 2},
  [88] = {.index = 147, .length = 4},
  [89] = {.index = 147, .length = 4},
  [90] = {.index = 151, .length = 3},
  [91] = {.index = 154, .length = 3},
  [92] = {.index = 157, .length = 3},
  [93] = {.index = 160, .length = 3},
  [94] = {.index = 163, .length = 2},
  [95] = {.index = 165, .length = 2},
  [96] = {.index = 165, .length = 2},
  [97] = {.index = 167, .length = 4},
  [98] = {.index = 171, .length = 5},
  [99] = {.index = 176, .length = 6},
  [100] = {.index = 182, .length = 3},
  [101] = {.index = 185, .length = 5},
  [102] = {.index = 190, .length = 4},
  [103] = {.index = 99, .length = 2},
  [104] = {.index = 194, .length = 5},
  [105] = {.index = 199, .length = 4},
  [106] = {.index = 203, .length = 2},
  [107] = {.index = 205, .length = 1},
  [108] = {.index = 206, .length = 2},
  [109] = {.index = 208, .length = 2},
  [110] = {.index = 210, .length = 3},
  [111] = {.index = 213, .length = 3},
  [112] = {.index = 213, .length = 3},
  [113] = {.index = 216, .length = 4},
  [114] = {.index = 220, .length = 4},
  [115] = {.index = 224, .length = 4},
  [116] = {.index = 228, .length = 3},
  [117] = {.index = 231, .length = 3},
  [118] = {.index = 234, .length = 4},
  [119] = {.index = 238, .length = 5},
  [120] = {.index = 243, .length = 3},
  [121] = {.index = 243, .length = 3},
  [122] = {.index = 246, .length = 4},
  [123] = {.index = 250, .length = 1},
  [124] = {.index = 251, .length = 2},
  [125] = {.index = 253, .length = 2},
  [126] = {.index = 255, .length = 1},
  [127] = {.index = 256, .length = 2},
  [128] = {.index = 258, .length = 2},
  [129] = {.index = 260, .length = 2},
  [130] = {.index = 262, .length = 3},
  [131] = {.index = 265, .length = 3},
  [133] = {.index = 268, .length = 3},
  [134] = {.index = 271, .length = 4},
  [135] = {.index = 271, .length = 4},
  [136] = {.index = 275, .length = 5},
  [137] = {.index = 280, .length = 3},
  [138] = {.index = 283, .length = 2},
  [139] = {.index = 285, .length = 3},
  [140] = {.index = 288, .length = 3},
  [141] = {.index = 291, .length = 3},
  [142] = {.index = 294, .length = 3},
  [143] = {.index = 297, .length = 3},
  [144] = {.index = 300, .length = 5},
  [145] = {.index = 305, .length = 4},
  [146] = {.index = 309, .length = 4},
  [149] = {.index = 313, .length = 2},
  [150] = {.index = 315, .length = 3},
  [151] = {.index = 318, .length = 4},
  [152] = {.index = 322, .length = 4},
  [153] = {.index = 326, .length = 4},
  [154] = {.index = 330, .length = 4},
  [155] = {.index = 334, .length = 4},
  [156] = {.index = 338, .length = 5},
  [157] = {.index = 343, .length = 5},
  [158] = {.index = 348, .length = 2},
  [159] = {.index = 350, .length = 1},
  [160] = {.index = 351, .length = 3},
  [161] = {.index = 354, .length = 3},
  [162] = {.index = 357, .length = 3},
  [163] = {.index = 360, .length = 5},
  [164] = {.index = 365, .length = 5},
  [165] = {.index = 370, .length = 5},
  [166] = {.index = 375, .length = 3},
  [167] = {.index = 378, .length = 3},
  [168] = {.index = 381, .length = 4},
  [169] = {.index = 385, .length = 4},
  [170] = {.index = 389, .length = 6},
  [171] = {.index = 395, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_arguments, 0, .inherited = true},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_arguments, 1},
    {field_name, 0},
  [8] =
    {field_name, 0},
  [9] =
    {field_dimensions, 1},
    {field_element, 0},
  [11] =
    {field_declarator, 0},
  [12] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [14] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
  [17] =
    {field_arguments, 2},
    {field_type, 1},
  [19] =
    {field_dimensions, 2},
    {field_type, 1},
  [21] =
    {field_body, 2},
    {field_name, 1},
  [23] =
    {field_body, 2},
    {field_condition, 1},
  [25] =
    {field_body, 2},
  [26] =
    {field_body, 1},
  [27] =
    {field_body, 2},
    {field_resources, 1},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_arguments, 2},
    {field_name, 1},
  [33] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [36] =
    {field_field, 2},
    {field_object, 0},
  [38] =
    {field_body, 2},
    {field_parameters, 0},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_arguments, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
  [45] =
    {field_dimensions, 1},
    {field_name, 0},
  [47] =
    {field_declarator, 1, .inherited = true},
    {field_type, 0},
  [49] =
    {field_declarator, 0},
    {field_declarator, 1, .inherited = true},
  [51] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
  [54] =
    {field_type, 1},
  [55] =
    {field_type, 1},
    {field_value, 3},
  [57] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [59] =
    {field_dimensions, 2},
    {field_type, 1},
    {field_value, 3},
  [62] =
    {field_dimensions, 2},
    {field_dimensions, 3},
    {field_type, 1},
  [65] =
    {field_arguments, 3},
    {field_type, 2},
    {field_type_arguments, 1},
  [68] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [71] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [74] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [77] =
    {field_name, 2},
    {field_scope, 0},
  [79] =
    {field_body, 3},
    {field_name, 2},
  [81] =
    {field_body, 3},
    {field_name, 1},
  [83] =
    {field_arguments, 3},
    {field_name, 2},
    {field_object, 0},
  [86] =
    {field_array, 0},
    {field_index, 2},
  [88] =
    {field_declarator, 2, .inherited = true},
    {field_type, 1},
  [90] =
    {field_declarator, 1},
  [91] =
    {field_declarator, 0, .inherited = true},
    {field_declarator, 1, .inherited = true},
  [93] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [96] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [99] =
    {field_name, 0},
    {field_parameters, 1},
  [101] =
    {field_body, 1},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [105] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 0},
  [109] =
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [114] =
    {field_body, 1},
    {field_dimensions, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [120] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [124] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [128] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [132] =
    {field_body, 1},
    {field_condition, 3},
  [134] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [137] =
    {field_init, 1},
  [138] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [140] =
    {field_body, 1},
    {field_name, 0},
  [142] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [145] =
    {field_field, 4},
    {field_object, 0},
  [147] =
    {field_arguments, 4},
    {field_name, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [151] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [154] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [157] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [160] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [163] =
    {field_body, 4},
    {field_name, 2},
  [165] =
    {field_body, 4},
    {field_name, 3},
  [167] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [171] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [176] =
    {field_body, 2},
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [182] =
    {field_name, 1},
    {field_parameters, 2},
    {field_type_parameters, 0},
  [185] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_parameters, 2, .inherited = true},
    {field_type, 1},
    {field_type_parameters, 0},
  [190] =
    {field_body, 2},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [194] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [199] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0},
    {field_value, 3},
  [203] =
    {field_dimensions, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [205] =
    {field_body, 5},
  [206] =
    {field_body, 5},
    {field_init, 2},
  [208] =
    {field_key, 0},
    {field_value, 2},
  [210] =
    {field_arguments, 1},
    {field_body, 2},
    {field_name, 0},
  [213] =
    {field_arguments, 5},
    {field_name, 4},
    {field_object, 0},
  [216] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [220] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [224] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [228] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [231] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [234] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [238] =
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_type, 2},
    {field_type_parameters, 0},
  [243] =
    {field_dimensions, 2},
    {field_name, 0},
    {field_parameters, 1},
  [246] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_type, 1},
    {field_value, 4},
  [250] =
    {field_body, 4},
  [251] =
    {field_dimensions, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [253] =
    {field_body, 6},
    {field_update, 4},
  [255] =
    {field_update, 1},
  [256] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [258] =
    {field_body, 6},
    {field_condition, 3},
  [260] =
    {field_body, 6},
    {field_init, 2},
  [262] =
    {field_body, 6},
    {field_init, 2},
    {field_update, 4},
  [265] =
    {field_body, 6},
    {field_condition, 3},
    {field_init, 2},
  [268] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [271] =
    {field_arguments, 6},
    {field_name, 5},
    {field_object, 0},
    {field_type_arguments, 4},
  [275] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [280] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [283] =
    {field_arguments, 1},
    {field_constructor, 0},
  [285] =
    {field_body, 7},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [288] =
    {field_body, 7},
    {field_condition, 3},
    {field_update, 5},
  [291] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 5},
  [294] =
    {field_body, 7},
    {field_condition, 4},
    {field_init, 2},
  [297] =
    {field_body, 7},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [300] =
    {field_body, 7},
    {field_dimensions, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [305] =
    {field_body, 7},
    {field_init, 2},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [309] =
    {field_body, 7},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
  [313] =
    {field_name, 1},
    {field_type, 0},
  [315] =
    {field_arguments, 2},
    {field_constructor, 1},
    {field_type_arguments, 0},
  [318] =
    {field_body, 8},
    {field_condition, 3},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [322] =
    {field_body, 8},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [326] =
    {field_body, 8},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
  [330] =
    {field_body, 8},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
  [334] =
    {field_body, 8},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
  [338] =
    {field_body, 8},
    {field_dimensions, 4, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [343] =
    {field_body, 8},
    {field_condition, 3},
    {field_init, 2},
    {field_update, 5},
    {field_update, 6, .inherited = true},
  [348] =
    {field_name, 2},
    {field_type, 1},
  [350] =
    {field_value, 1},
  [351] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
  [354] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 4, .inherited = true},
  [357] =
    {field_arguments, 3},
    {field_constructor, 2},
    {field_object, 0},
  [360] =
    {field_body, 9},
    {field_condition, 4},
    {field_init, 2},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [365] =
    {field_body, 9},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 6},
    {field_update, 7, .inherited = true},
  [370] =
    {field_body, 9},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
  [375] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
  [378] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 5, .inherited = true},
  [381] =
    {field_dimensions, 4},
    {field_name, 1},
    {field_type, 0},
    {field_value, 5, .inherited = true},
  [385] =
    {field_arguments, 4},
    {field_constructor, 3},
    {field_object, 0},
    {field_type_arguments, 2},
  [389] =
    {field_body, 10},
    {field_condition, 5},
    {field_init, 2},
    {field_init, 3, .inherited = true},
    {field_update, 7},
    {field_update, 8, .inherited = true},
  [395] =
    {field_dimensions, 5},
    {field_name, 2},
    {field_type, 1},
    {field_value, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [7] = {
    [0] = sym_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [18] = {
    [1] = alias_sym_type_identifier,
  },
  [25] = {
    [1] = sym_identifier,
  },
  [27] = {
    [0] = sym_identifier,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [30] = {
    [2] = sym_identifier,
  },
  [34] = {
    [0] = alias_sym_type_identifier,
    [2] = alias_sym_type_identifier,
  },
  [37] = {
    [0] = sym_identifier,
  },
  [41] = {
    [2] = alias_sym_type_identifier,
  },
  [48] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [1] = alias_sym_type_identifier,
  },
  [51] = {
    [2] = alias_sym_type_identifier,
  },
  [55] = {
    [0] = sym_identifier,
  },
  [57] = {
    [2] = sym_identifier,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [61] = {
    [2] = sym_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_type_identifier,
  },
  [69] = {
    [3] = alias_sym_type_identifier,
  },
  [71] = {
    [1] = alias_sym_type_identifier,
  },
  [86] = {
    [4] = sym_identifier,
  },
  [88] = {
    [3] = sym_identifier,
  },
  [95] = {
    [3] = sym_identifier,
  },
  [103] = {
    [0] = sym_identifier,
  },
  [111] = {
    [4] = sym_identifier,
  },
  [120] = {
    [0] = sym_identifier,
  },
  [132] = {
    [1] = sym_identifier,
    [2] = sym_identifier,
  },
  [134] = {
    [5] = sym_identifier,
  },
  [147] = {
    [1] = sym_identifier,
    [3] = sym_identifier,
  },
  [148] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= '$' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6400
    ? (c < 2979
      ? (c < 2365
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : (c <= 170 || c == 181))))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1749
              ? (c < 1632
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1641 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1808
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1984 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2185
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : (c <= 2154 || (c >= 2160 && c <= 2183)))
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2534
            ? (c < 2474
              ? (c < 2417
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2406 && c <= 2415)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : (c <= 2448 || (c >= 2451 && c <= 2472)))))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2662
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : (c <= 2652 || c == 2654))
                : (c <= 2671 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2866
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2831
                ? (c < 2809
                  ? (c >= 2790 && c <= 2799)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2947
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2929
                  ? (c >= 2918 && c <= 2927)
                  : c <= 2929)))
              : (c <= 2947 || (c < 2969
                ? (c < 2958
                  ? (c >= 2949 && c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 3872
        ? (c < 3406
          ? (c < 3205
            ? (c < 3114
              ? (c < 3046
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3055 || (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3200
                  ? (c >= 3174 && c <= 3183)
                  : c <= 3200)))))
            : (c <= 3212 || (c < 3296
              ? (c < 3253
                ? (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))
                : (c <= 3257 || (c < 3293
                  ? c == 3261
                  : c <= 3294)))
              : (c <= 3297 || (c < 3342
                ? (c < 3313
                  ? (c >= 3302 && c <= 3311)
                  : (c <= 3314 || (c >= 3332 && c <= 3340)))
                : (c <= 3344 || (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)))))))
          : (c <= 3406 || (c < 3664
            ? (c < 3507
              ? (c < 3450
                ? (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : (c <= 3425 || (c >= 3430 && c <= 3439)))
                : (c <= 3455 || (c < 3482
                  ? (c >= 3461 && c <= 3478)
                  : c <= 3505)))
              : (c <= 3515 || (c < 3585
                ? (c < 3520
                  ? c == 3517
                  : (c <= 3526 || (c >= 3558 && c <= 3567)))
                : (c <= 3632 || (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : c <= 3654)))))
            : (c <= 3673 || (c < 3762
              ? (c < 3724
                ? (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : (c <= 3716 || (c >= 3718 && c <= 3722)))
                : (c <= 3747 || (c < 3751
                  ? c == 3749
                  : c <= 3760)))
              : (c <= 3763 || (c < 3792
                ? (c < 3776
                  ? c == 3773
                  : (c <= 3780 || c == 3782))
                : (c <= 3801 || (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)))))))))
        : (c <= 3881 || (c < 4802
          ? (c < 4295
            ? (c < 4193
              ? (c < 4096
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4176
                  ? (c >= 4159 && c <= 4169)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))
              : (c <= 4193 || (c < 4238
                ? (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : (c <= 4208 || (c >= 4213 && c <= 4225)))
                : (c <= 4238 || (c < 4256
                  ? (c >= 4240 && c <= 4249)
                  : c <= 4293)))))
            : (c <= 4295 || (c < 4698
              ? (c < 4682
                ? (c < 4304
                  ? c == 4301
                  : (c <= 4346 || (c >= 4348 && c <= 4680)))
                : (c <= 4685 || (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : c <= 4696)))
              : (c <= 4701 || (c < 4786
                ? (c < 4746
                  ? (c >= 4704 && c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)))))))
          : (c <= 4805 || (c < 5919
            ? (c < 5112
              ? (c < 4888
                ? (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : (c <= 4880 || (c >= 4882 && c <= 4885)))
                : (c <= 4954 || (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : c <= 5109)))
              : (c <= 5117 || (c < 5792
                ? (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))
                : (c <= 5866 || (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : c <= 5905)))))
            : (c <= 5937 || (c < 6112
              ? (c < 6016
                ? (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : (c <= 5996 || (c >= 5998 && c <= 6000)))
                : (c <= 6067 || (c < 6108
                  ? c == 6103
                  : c <= 6108)))
              : (c <= 6121 || (c < 6279
                ? (c < 6176
                  ? (c >= 6160 && c <= 6169)
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))))))))))))
    : (c <= 6430 || (c < 43216
      ? (c < 8490
        ? (c < 7968
          ? (c < 7086
            ? (c < 6784
              ? (c < 6576
                ? (c < 6512
                  ? (c >= 6470 && c <= 6509)
                  : (c <= 6516 || (c >= 6528 && c <= 6571)))
                : (c <= 6601 || (c < 6656
                  ? (c >= 6608 && c <= 6617)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6793 || (c < 6981
                ? (c < 6823
                  ? (c >= 6800 && c <= 6809)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7043
                  ? (c >= 6992 && c <= 7001)
                  : c <= 7072)))))
            : (c <= 7141 || (c < 7401
              ? (c < 7296
                ? (c < 7232
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7241 || (c >= 7245 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))
              : (c <= 7404 || (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))))))
          : (c <= 8005 || (c < 8160
            ? (c < 8064
              ? (c < 8027
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : (c <= 8023 || c == 8025))
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))
              : (c <= 8116 || (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))))
            : (c <= 8172 || (c < 8455
              ? (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))
              : (c <= 8455 || (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))))))))
        : (c <= 8493 || (c < 12449
          ? (c < 11680
            ? (c < 11506
              ? (c < 8526
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : (c <= 8511 || (c >= 8517 && c <= 8521)))
                : (c <= 8526 || (c < 11264
                  ? (c >= 8579 && c <= 8580)
                  : (c <= 11492 || (c >= 11499 && c <= 11502)))))
              : (c <= 11507 || (c < 11568
                ? (c < 11559
                  ? (c >= 11520 && c <= 11557)
                  : (c <= 11559 || c == 11565))
                : (c <= 11623 || (c < 11648
                  ? c == 11631
                  : c <= 11670)))))
            : (c <= 11686 || (c < 11736
              ? (c < 11712
                ? (c < 11696
                  ? (c >= 11688 && c <= 11694)
                  : (c <= 11702 || (c >= 11704 && c <= 11710)))
                : (c <= 11718 || (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : c <= 11734)))
              : (c <= 11742 || (c < 12347
                ? (c < 12293
                  ? c == 11823
                  : (c <= 12294 || (c >= 12337 && c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)))))))
          : (c <= 12538 || (c < 42623
            ? (c < 19903
              ? (c < 12704
                ? (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : (c <= 12591 || (c >= 12593 && c <= 12686)))
                : (c <= 12735 || (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : c <= 13312)))
              : (c <= 19903 || (c < 42240
                ? (c < 40959
                  ? c == 19968
                  : (c <= 42124 || (c >= 42192 && c <= 42237)))
                : (c <= 42508 || (c < 42560
                  ? (c >= 42512 && c <= 42539)
                  : c <= 42606)))))
            : (c <= 42653 || (c < 42965
              ? (c < 42891
                ? (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))
                : (c <= 42954 || (c < 42963
                  ? (c >= 42960 && c <= 42961)
                  : c <= 42963)))
              : (c <= 42969 || (c < 43020
                ? (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : (c <= 43013 || (c >= 43015 && c <= 43018)))
                : (c <= 43042 || (c < 43138
                  ? (c >= 43072 && c <= 43123)
                  : c <= 43187)))))))))))
      : (c <= 43225 || (c < 65296
        ? (c < 43808
          ? (c < 43616
            ? (c < 43471
              ? (c < 43264
                ? (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : (c <= 43259 || (c >= 43261 && c <= 43262)))
                : (c <= 43301 || (c < 43360
                  ? (c >= 43312 && c <= 43334)
                  : (c <= 43388 || (c >= 43396 && c <= 43442)))))
              : (c <= 43481 || (c < 43584
                ? (c < 43494
                  ? (c >= 43488 && c <= 43492)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43600
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43609)))))
            : (c <= 43638 || (c < 43714
              ? (c < 43701
                ? (c < 43646
                  ? c == 43642
                  : (c <= 43695 || c == 43697))
                : (c <= 43702 || (c < 43712
                  ? (c >= 43705 && c <= 43709)
                  : c <= 43712)))
              : (c <= 43714 || (c < 43777
                ? (c < 43744
                  ? (c >= 43739 && c <= 43741)
                  : (c <= 43754 || (c >= 43762 && c <= 43764)))
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64285
            ? (c < 55203
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 44032
                  ? (c >= 44016 && c <= 44025)
                  : c <= 44032)))
              : (c <= 55203 || (c < 64112
                ? (c < 55243
                  ? (c >= 55216 && c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64275
                  ? (c >= 64256 && c <= 64262)
                  : c <= 64279)))))
            : (c <= 64285 || (c < 64326
              ? (c < 64318
                ? (c < 64298
                  ? (c >= 64287 && c <= 64296)
                  : (c <= 64310 || (c >= 64312 && c <= 64316)))
                : (c <= 64318 || (c < 64323
                  ? (c >= 64320 && c <= 64321)
                  : c <= 64324)))
              : (c <= 64433 || (c < 65008
                ? (c < 64848
                  ? (c >= 64467 && c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65305 || (c < 66816
          ? (c < 65664
            ? (c < 65498
              ? (c < 65474
                ? (c < 65345
                  ? (c >= 65313 && c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65470)))
                : (c <= 65479 || (c < 65490
                  ? (c >= 65482 && c <= 65487)
                  : c <= 65495)))
              : (c <= 65500 || (c < 65596
                ? (c < 65549
                  ? (c >= 65536 && c <= 65547)
                  : (c <= 65574 || (c >= 65576 && c <= 65594)))
                : (c <= 65597 || (c < 65616
                  ? (c >= 65599 && c <= 65613)
                  : c <= 65629)))))
            : (c <= 65786 || (c < 66432
              ? (c < 66349
                ? (c < 66208
                  ? (c >= 66176 && c <= 66204)
                  : (c <= 66256 || (c >= 66304 && c <= 66335)))
                : (c <= 66368 || (c < 66384
                  ? (c >= 66370 && c <= 66377)
                  : c <= 66421)))
              : (c <= 66461 || (c < 66720
                ? (c < 66504
                  ? (c >= 66464 && c <= 66499)
                  : (c <= 66511 || (c >= 66560 && c <= 66717)))
                : (c <= 66729 || (c < 66776
                  ? (c >= 66736 && c <= 66771)
                  : c <= 66811)))))))
          : (c <= 66855 || (c < 67463
            ? (c < 66979
              ? (c < 66956
                ? (c < 66928
                  ? (c >= 66864 && c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))
                : (c <= 66962 || (c < 66967
                  ? (c >= 66964 && c <= 66965)
                  : c <= 66977)))
              : (c <= 66993 || (c < 67392
                ? (c < 67003
                  ? (c >= 66995 && c <= 67001)
                  : (c <= 67004 || (c >= 67072 && c <= 67382)))
                : (c <= 67413 || (c < 67456
                  ? (c >= 67424 && c <= 67431)
                  : c <= 67461)))))
            : (c <= 67504 || (c < 67647
              ? (c < 67594
                ? (c < 67584
                  ? (c >= 67506 && c <= 67514)
                  : (c <= 67589 || c == 67592))
                : (c <= 67637 || (c < 67644
                  ? (c >= 67639 && c <= 67640)
                  : c <= 67644)))
              : (c <= 67669 || (c < 67828
                ? (c < 67712
                  ? (c >= 67680 && c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(133);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(140);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '~') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(139);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(110);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '~') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '%') ADVANCE(113);
      if (lookahead == '&') ADVANCE(72);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(104);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(106);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(91);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(139);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(111);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(108);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(139);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(110);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(139);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 6:
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '.') ADVANCE(131);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(14);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(90);
      if (lookahead == '>') ADVANCE(87);
      if (lookahead == '@') ADVANCE(140);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(143);
      END_STATE();
    case 7:
      if (lookahead == '\'') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead == '/') ADVANCE(145);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(9);
      if (lookahead != 0) ADVANCE(10);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(142);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == ':') ADVANCE(135);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 17:
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(7);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 20:
      if (lookahead == '_') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(27);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(24);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 33:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 34:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 41:
      if (lookahead != 0) ADVANCE(4);
      END_STATE();
    case 42:
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 43:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(134);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(140);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(110);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '~') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(43)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 44:
      if (eof) ADVANCE(45);
      if (lookahead == '!') ADVANCE(125);
      if (lookahead == '"') ADVANCE(4);
      if (lookahead == '%') ADVANCE(112);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(103);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(121);
      if (lookahead == '-') ADVANCE(102);
      if (lookahead == '.') ADVANCE(36);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '0') ADVANCE(47);
      if (lookahead == ':') ADVANCE(123);
      if (lookahead == ';') ADVANCE(138);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(16);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(122);
      if (lookahead == '@') ADVANCE(140);
      if (lookahead == ']') ADVANCE(130);
      if (lookahead == '^') ADVANCE(110);
      if (lookahead == '{') ADVANCE(136);
      if (lookahead == '|') ADVANCE(109);
      if (lookahead == '}') ADVANCE(137);
      if (lookahead == '~') ADVANCE(126);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(44)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(143);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(34);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(35);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(46);
      if (lookahead == '_') ADVANCE(18);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(49);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(52);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_octal_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(53);
      if (lookahead == '_') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(55);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(19);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(23);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('D' <= lookahead && lookahead <= 'F') ||
          ('d' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= 'C') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '_') ADVANCE(22);
      if (lookahead == 'D' ||
          lookahead == 'F' ||
          lookahead == 'd' ||
          lookahead == 'f') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_hex_floating_point_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_character_literal);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_string_literal);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(93);
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(93);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(127);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(127);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(128);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(128);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(98);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(85);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(135);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_ATinterface);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'u') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == 'y') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 'y') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'h') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      if (lookahead == 'l') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(38);
      if (lookahead == 'm') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'p') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(51);
      if (lookahead == 't') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      if (lookahead == 'w') ADVANCE(54);
      if (lookahead == 'y') ADVANCE(55);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(63);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(69);
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(74);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 33:
      if (lookahead == 'p') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 35:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(85);
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(88);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(90);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(93);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(94);
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 49:
      if (lookahead == 'b') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(97);
      if (lookahead == 'q') ADVANCE(98);
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(101);
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(103);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_to);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(108);
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == 'y') ADVANCE(110);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(112);
      if (lookahead == 'l') ADVANCE(113);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 71:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(128);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(130);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(131);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 87:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 92:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 93:
      if (lookahead == 'k') ADVANCE(145);
      END_STATE();
    case 94:
      if (lookahead == 'v') ADVANCE(146);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(147);
      if (lookahead == 'v') ADVANCE(148);
      END_STATE();
    case 96:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 98:
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 99:
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(159);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 108:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(164);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(165);
      END_STATE();
    case 114:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 115:
      if (lookahead == 'h') ADVANCE(167);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 117:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 120:
      if (lookahead == 'k') ADVANCE(172);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 123:
      if (lookahead == 'h') ADVANCE(173);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_char);
      END_STATE();
    case 125:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 131:
      if (lookahead == 'r') ADVANCE(178);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(179);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 137:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 142:
      if (lookahead == 'v') ADVANCE(188);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_null_literal);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_open);
      if (lookahead == 's') ADVANCE(189);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(190);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(194);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(196);
      END_STATE();
    case 152:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(199);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(200);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(202);
      END_STATE();
    case 158:
      if (lookahead == 'h') ADVANCE(203);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 160:
      if (lookahead == 'w') ADVANCE(204);
      END_STATE();
    case 161:
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_uses);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 168:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(211);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 176:
      if (lookahead == 'l') ADVANCE(213);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(215);
      END_STATE();
    case 179:
      if (lookahead == 'd') ADVANCE(216);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(217);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 183:
      if (lookahead == 'm') ADVANCE(218);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 186:
      if (lookahead == 'f') ADVANCE(221);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_opens);
      END_STATE();
    case 190:
      if (lookahead == 'g') ADVANCE(224);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 192:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 193:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 194:
      if (lookahead == 'c') ADVANCE(228);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(229);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(230);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(232);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 202:
      if (lookahead == 'h') ADVANCE(234);
      END_STATE();
    case 203:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(236);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(237);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(238);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(239);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(240);
      END_STATE();
    case 212:
      if (lookahead == 'u') ADVANCE(241);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(242);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 215:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 216:
      if (lookahead == 's') ADVANCE(244);
      END_STATE();
    case 217:
      if (lookahead == 'y') ADVANCE(245);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 220:
      if (lookahead == 'c') ADVANCE(247);
      END_STATE();
    case 221:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(249);
      END_STATE();
    case 225:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 233:
      if (lookahead == 'f') ADVANCE(254);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 235:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(256);
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_boolean_type);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_exports);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 246:
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 248:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 252:
      if (lookahead == 's') ADVANCE(265);
      END_STATE();
    case 253:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 254:
      if (lookahead == 'p') ADVANCE(267);
      END_STATE();
    case 255:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(270);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 261:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 262:
      if (lookahead == 'o') ADVANCE(273);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 264:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_provides);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 268:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 269:
      if (lookahead == 't') ADVANCE(277);
      END_STATE();
    case 270:
      if (lookahead == 'v') ADVANCE(278);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 272:
      if (lookahead == 's') ADVANCE(279);
      END_STATE();
    case 273:
      if (lookahead == 'f') ADVANCE(280);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 276:
      if (lookahead == 'z') ADVANCE(281);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    case 283:
      if (lookahead == 'd') ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 44},
  [2] = {.lex_state = 44},
  [3] = {.lex_state = 44},
  [4] = {.lex_state = 44},
  [5] = {.lex_state = 44},
  [6] = {.lex_state = 44},
  [7] = {.lex_state = 44},
  [8] = {.lex_state = 44},
  [9] = {.lex_state = 44},
  [10] = {.lex_state = 44},
  [11] = {.lex_state = 44},
  [12] = {.lex_state = 44},
  [13] = {.lex_state = 44},
  [14] = {.lex_state = 44},
  [15] = {.lex_state = 44},
  [16] = {.lex_state = 44},
  [17] = {.lex_state = 44},
  [18] = {.lex_state = 44},
  [19] = {.lex_state = 44},
  [20] = {.lex_state = 44},
  [21] = {.lex_state = 44},
  [22] = {.lex_state = 44},
  [23] = {.lex_state = 44},
  [24] = {.lex_state = 44},
  [25] = {.lex_state = 44},
  [26] = {.lex_state = 44},
  [27] = {.lex_state = 44},
  [28] = {.lex_state = 44},
  [29] = {.lex_state = 44},
  [30] = {.lex_state = 44},
  [31] = {.lex_state = 44},
  [32] = {.lex_state = 44},
  [33] = {.lex_state = 44},
  [34] = {.lex_state = 44},
  [35] = {.lex_state = 44},
  [36] = {.lex_state = 44},
  [37] = {.lex_state = 44},
  [38] = {.lex_state = 44},
  [39] = {.lex_state = 44},
  [40] = {.lex_state = 44},
  [41] = {.lex_state = 44},
  [42] = {.lex_state = 44},
  [43] = {.lex_state = 44},
  [44] = {.lex_state = 44},
  [45] = {.lex_state = 43},
  [46] = {.lex_state = 43},
  [47] = {.lex_state = 44},
  [48] = {.lex_state = 44},
  [49] = {.lex_state = 44},
  [50] = {.lex_state = 44},
  [51] = {.lex_state = 43},
  [52] = {.lex_state = 44},
  [53] = {.lex_state = 44},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 44},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 44},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 44},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 44},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 44},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 44},
  [77] = {.lex_state = 44},
  [78] = {.lex_state = 44},
  [79] = {.lex_state = 44},
  [80] = {.lex_state = 44},
  [81] = {.lex_state = 44},
  [82] = {.lex_state = 44},
  [83] = {.lex_state = 44},
  [84] = {.lex_state = 44},
  [85] = {.lex_state = 44},
  [86] = {.lex_state = 44},
  [87] = {.lex_state = 44},
  [88] = {.lex_state = 44},
  [89] = {.lex_state = 44},
  [90] = {.lex_state = 44},
  [91] = {.lex_state = 44},
  [92] = {.lex_state = 44},
  [93] = {.lex_state = 44},
  [94] = {.lex_state = 44},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 44},
  [98] = {.lex_state = 44},
  [99] = {.lex_state = 44},
  [100] = {.lex_state = 44},
  [101] = {.lex_state = 44},
  [102] = {.lex_state = 44},
  [103] = {.lex_state = 44},
  [104] = {.lex_state = 44},
  [105] = {.lex_state = 44},
  [106] = {.lex_state = 44},
  [107] = {.lex_state = 44},
  [108] = {.lex_state = 44},
  [109] = {.lex_state = 44},
  [110] = {.lex_state = 44},
  [111] = {.lex_state = 44},
  [112] = {.lex_state = 44},
  [113] = {.lex_state = 44},
  [114] = {.lex_state = 44},
  [115] = {.lex_state = 44},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 44},
  [118] = {.lex_state = 44},
  [119] = {.lex_state = 44},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 44},
  [139] = {.lex_state = 44},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 44},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 44},
  [151] = {.lex_state = 44},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 44},
  [154] = {.lex_state = 44},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 44},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 44},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 44},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 44},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 44},
  [171] = {.lex_state = 44},
  [172] = {.lex_state = 44},
  [173] = {.lex_state = 44},
  [174] = {.lex_state = 44},
  [175] = {.lex_state = 44},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 44},
  [178] = {.lex_state = 44},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 44},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 44},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 44},
  [186] = {.lex_state = 44},
  [187] = {.lex_state = 44},
  [188] = {.lex_state = 44},
  [189] = {.lex_state = 44},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 44},
  [192] = {.lex_state = 44},
  [193] = {.lex_state = 44},
  [194] = {.lex_state = 44},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 44},
  [198] = {.lex_state = 44},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 44},
  [201] = {.lex_state = 44},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 44},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 44},
  [214] = {.lex_state = 44},
  [215] = {.lex_state = 44},
  [216] = {.lex_state = 44},
  [217] = {.lex_state = 44},
  [218] = {.lex_state = 44},
  [219] = {.lex_state = 44},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 44},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 44},
  [225] = {.lex_state = 44},
  [226] = {.lex_state = 44},
  [227] = {.lex_state = 44},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 44},
  [230] = {.lex_state = 44},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 44},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 44},
  [235] = {.lex_state = 44},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 44},
  [238] = {.lex_state = 44},
  [239] = {.lex_state = 44},
  [240] = {.lex_state = 44},
  [241] = {.lex_state = 44},
  [242] = {.lex_state = 44},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 44},
  [245] = {.lex_state = 44},
  [246] = {.lex_state = 44},
  [247] = {.lex_state = 44},
  [248] = {.lex_state = 44},
  [249] = {.lex_state = 44},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 44},
  [252] = {.lex_state = 44},
  [253] = {.lex_state = 44},
  [254] = {.lex_state = 44},
  [255] = {.lex_state = 44},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 44},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 44},
  [263] = {.lex_state = 44},
  [264] = {.lex_state = 44},
  [265] = {.lex_state = 44},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 44},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 44},
  [270] = {.lex_state = 44},
  [271] = {.lex_state = 44},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 2},
  [280] = {.lex_state = 2},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 2},
  [286] = {.lex_state = 2},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 2},
  [292] = {.lex_state = 2},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 2},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 2},
  [301] = {.lex_state = 2},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 2},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 3},
  [309] = {.lex_state = 3},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 2},
  [320] = {.lex_state = 3},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 3},
  [323] = {.lex_state = 3},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 3},
  [326] = {.lex_state = 3},
  [327] = {.lex_state = 3},
  [328] = {.lex_state = 2},
  [329] = {.lex_state = 2},
  [330] = {.lex_state = 3},
  [331] = {.lex_state = 3},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 3},
  [334] = {.lex_state = 3},
  [335] = {.lex_state = 3},
  [336] = {.lex_state = 3},
  [337] = {.lex_state = 3},
  [338] = {.lex_state = 3},
  [339] = {.lex_state = 3},
  [340] = {.lex_state = 3},
  [341] = {.lex_state = 3},
  [342] = {.lex_state = 3},
  [343] = {.lex_state = 3},
  [344] = {.lex_state = 3},
  [345] = {.lex_state = 3},
  [346] = {.lex_state = 3},
  [347] = {.lex_state = 3},
  [348] = {.lex_state = 3},
  [349] = {.lex_state = 3},
  [350] = {.lex_state = 3},
  [351] = {.lex_state = 3},
  [352] = {.lex_state = 3},
  [353] = {.lex_state = 3},
  [354] = {.lex_state = 3},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 3},
  [358] = {.lex_state = 3},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 3},
  [361] = {.lex_state = 3},
  [362] = {.lex_state = 3},
  [363] = {.lex_state = 3},
  [364] = {.lex_state = 3},
  [365] = {.lex_state = 3},
  [366] = {.lex_state = 3},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 3},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 3},
  [371] = {.lex_state = 3},
  [372] = {.lex_state = 3},
  [373] = {.lex_state = 3},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 3},
  [376] = {.lex_state = 3},
  [377] = {.lex_state = 3},
  [378] = {.lex_state = 3},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 44},
  [412] = {.lex_state = 44},
  [413] = {.lex_state = 44},
  [414] = {.lex_state = 44},
  [415] = {.lex_state = 44},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 44},
  [418] = {.lex_state = 44},
  [419] = {.lex_state = 44},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 44},
  [422] = {.lex_state = 44},
  [423] = {.lex_state = 44},
  [424] = {.lex_state = 44},
  [425] = {.lex_state = 44},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 44},
  [428] = {.lex_state = 44},
  [429] = {.lex_state = 44},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 44},
  [432] = {.lex_state = 44},
  [433] = {.lex_state = 44},
  [434] = {.lex_state = 5},
  [435] = {.lex_state = 44},
  [436] = {.lex_state = 44},
  [437] = {.lex_state = 44},
  [438] = {.lex_state = 5},
  [439] = {.lex_state = 44},
  [440] = {.lex_state = 44},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 3},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 44},
  [451] = {.lex_state = 44},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 44},
  [456] = {.lex_state = 44},
  [457] = {.lex_state = 44},
  [458] = {.lex_state = 44},
  [459] = {.lex_state = 44},
  [460] = {.lex_state = 44},
  [461] = {.lex_state = 5},
  [462] = {.lex_state = 44},
  [463] = {.lex_state = 44},
  [464] = {.lex_state = 5},
  [465] = {.lex_state = 44},
  [466] = {.lex_state = 44},
  [467] = {.lex_state = 44},
  [468] = {.lex_state = 44},
  [469] = {.lex_state = 44},
  [470] = {.lex_state = 44},
  [471] = {.lex_state = 44},
  [472] = {.lex_state = 44},
  [473] = {.lex_state = 44},
  [474] = {.lex_state = 44},
  [475] = {.lex_state = 44},
  [476] = {.lex_state = 5},
  [477] = {.lex_state = 44},
  [478] = {.lex_state = 44},
  [479] = {.lex_state = 44},
  [480] = {.lex_state = 44},
  [481] = {.lex_state = 44},
  [482] = {.lex_state = 5},
  [483] = {.lex_state = 44},
  [484] = {.lex_state = 44},
  [485] = {.lex_state = 44},
  [486] = {.lex_state = 44},
  [487] = {.lex_state = 44},
  [488] = {.lex_state = 44},
  [489] = {.lex_state = 44},
  [490] = {.lex_state = 44},
  [491] = {.lex_state = 44},
  [492] = {.lex_state = 44},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 44},
  [496] = {.lex_state = 44},
  [497] = {.lex_state = 44},
  [498] = {.lex_state = 44},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 44},
  [501] = {.lex_state = 44},
  [502] = {.lex_state = 44},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 44},
  [505] = {.lex_state = 44},
  [506] = {.lex_state = 44},
  [507] = {.lex_state = 44},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 44},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 44},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 44},
  [515] = {.lex_state = 44},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 44},
  [519] = {.lex_state = 44},
  [520] = {.lex_state = 44},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 1},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 5},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 5},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 5},
  [548] = {.lex_state = 5},
  [549] = {.lex_state = 5},
  [550] = {.lex_state = 5},
  [551] = {.lex_state = 5},
  [552] = {.lex_state = 5},
  [553] = {.lex_state = 2},
  [554] = {.lex_state = 5},
  [555] = {.lex_state = 5},
  [556] = {.lex_state = 5},
  [557] = {.lex_state = 5},
  [558] = {.lex_state = 5},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 5},
  [561] = {.lex_state = 5},
  [562] = {.lex_state = 2},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 2},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 5},
  [572] = {.lex_state = 5},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 2},
  [575] = {.lex_state = 1},
  [576] = {.lex_state = 1},
  [577] = {.lex_state = 1},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 2},
  [580] = {.lex_state = 2},
  [581] = {.lex_state = 2},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 1},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 2},
  [588] = {.lex_state = 1},
  [589] = {.lex_state = 1},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 1},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 2},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 2},
  [600] = {.lex_state = 2},
  [601] = {.lex_state = 2},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 2},
  [605] = {.lex_state = 2},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 2},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 1},
  [618] = {.lex_state = 2},
  [619] = {.lex_state = 2},
  [620] = {.lex_state = 2},
  [621] = {.lex_state = 2},
  [622] = {.lex_state = 1},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 2},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 2},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 6},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 1},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 1},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 1},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 1},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 1},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 1},
  [660] = {.lex_state = 1},
  [661] = {.lex_state = 1},
  [662] = {.lex_state = 1},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 1},
  [665] = {.lex_state = 1},
  [666] = {.lex_state = 1},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 1},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 1},
  [675] = {.lex_state = 1},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 1},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 1},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 1},
  [684] = {.lex_state = 1},
  [685] = {.lex_state = 1},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 6},
  [688] = {.lex_state = 2},
  [689] = {.lex_state = 0},
  [690] = {.lex_state = 2},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 6},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 2},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 2},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 2},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 2},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 2},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 2},
  [726] = {.lex_state = 6},
  [727] = {.lex_state = 2},
  [728] = {.lex_state = 6},
  [729] = {.lex_state = 2},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 2},
  [738] = {.lex_state = 2},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 2},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 2},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 6},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 6},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 6},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 2},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 6},
  [774] = {.lex_state = 2},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 2},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 6},
  [807] = {.lex_state = 6},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 6},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 2},
  [813] = {.lex_state = 2},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 2},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 6},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 6},
  [840] = {.lex_state = 6},
  [841] = {.lex_state = 2},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 6},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 2},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 2},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 6},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 2},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 2},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 6},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 6},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 6},
  [887] = {.lex_state = 2},
  [888] = {.lex_state = 2},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 2},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 2},
  [902] = {.lex_state = 6},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 2},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 2},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 6},
  [923] = {.lex_state = 6},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 6},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 2},
  [936] = {.lex_state = 2},
  [937] = {.lex_state = 2},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 2},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 2},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 2},
  [951] = {.lex_state = 2},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 2},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 2},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_octal_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [sym_hex_floating_point_literal] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_character_literal] = ACTIONS(1),
    [sym_string_literal] = ACTIONS(1),
    [sym_null_literal] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_open] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_exports] = ACTIONS(1),
    [anon_sym_to] = ACTIONS(1),
    [anon_sym_opens] = ACTIONS(1),
    [anon_sym_uses] = ACTIONS(1),
    [anon_sym_provides] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_ATinterface] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_char] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [sym_boolean_type] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(1017),
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(6),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_switch_label] = STATE(988),
    [sym_statement] = STATE(5),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(188),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_case] = ACTIONS(85),
    [anon_sym_default] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(446),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_type_arguments] = STATE(892),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(10),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_explicit_constructor_invocation] = STATE(8),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LT] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(91),
    [sym_super] = ACTIONS(93),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [ts_builtin_sym_end] = ACTIONS(95),
    [sym_identifier] = ACTIONS(97),
    [sym_decimal_integer_literal] = ACTIONS(100),
    [sym_hex_integer_literal] = ACTIONS(100),
    [sym_octal_integer_literal] = ACTIONS(103),
    [sym_binary_integer_literal] = ACTIONS(103),
    [sym_decimal_floating_point_literal] = ACTIONS(103),
    [sym_hex_floating_point_literal] = ACTIONS(100),
    [sym_true] = ACTIONS(100),
    [sym_false] = ACTIONS(100),
    [sym_character_literal] = ACTIONS(103),
    [sym_string_literal] = ACTIONS(103),
    [sym_null_literal] = ACTIONS(100),
    [anon_sym_LPAREN] = ACTIONS(106),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(112),
    [anon_sym_TILDE] = ACTIONS(112),
    [anon_sym_PLUS_PLUS] = ACTIONS(115),
    [anon_sym_DASH_DASH] = ACTIONS(115),
    [anon_sym_new] = ACTIONS(118),
    [anon_sym_class] = ACTIONS(121),
    [anon_sym_switch] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(127),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_case] = ACTIONS(130),
    [anon_sym_default] = ACTIONS(132),
    [anon_sym_SEMI] = ACTIONS(135),
    [anon_sym_assert] = ACTIONS(138),
    [anon_sym_do] = ACTIONS(141),
    [anon_sym_while] = ACTIONS(144),
    [anon_sym_break] = ACTIONS(147),
    [anon_sym_continue] = ACTIONS(150),
    [anon_sym_return] = ACTIONS(153),
    [anon_sym_yield] = ACTIONS(156),
    [anon_sym_synchronized] = ACTIONS(159),
    [anon_sym_throw] = ACTIONS(162),
    [anon_sym_try] = ACTIONS(165),
    [anon_sym_if] = ACTIONS(168),
    [anon_sym_for] = ACTIONS(171),
    [anon_sym_AT] = ACTIONS(174),
    [anon_sym_open] = ACTIONS(177),
    [anon_sym_module] = ACTIONS(180),
    [anon_sym_static] = ACTIONS(132),
    [anon_sym_package] = ACTIONS(183),
    [anon_sym_import] = ACTIONS(186),
    [anon_sym_enum] = ACTIONS(189),
    [anon_sym_public] = ACTIONS(132),
    [anon_sym_protected] = ACTIONS(132),
    [anon_sym_private] = ACTIONS(132),
    [anon_sym_abstract] = ACTIONS(132),
    [anon_sym_final] = ACTIONS(132),
    [anon_sym_strictfp] = ACTIONS(132),
    [anon_sym_native] = ACTIONS(132),
    [anon_sym_transient] = ACTIONS(132),
    [anon_sym_volatile] = ACTIONS(132),
    [anon_sym_ATinterface] = ACTIONS(192),
    [anon_sym_interface] = ACTIONS(195),
    [anon_sym_byte] = ACTIONS(198),
    [anon_sym_short] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_long] = ACTIONS(198),
    [anon_sym_char] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(201),
    [anon_sym_double] = ACTIONS(201),
    [sym_boolean_type] = ACTIONS(204),
    [sym_void_type] = ACTIONS(204),
    [sym_this] = ACTIONS(207),
    [sym_super] = ACTIONS(210),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(213),
    [anon_sym_case] = ACTIONS(215),
    [anon_sym_default] = ACTIONS(215),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [ts_builtin_sym_end] = ACTIONS(217),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(7),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(221),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(9),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(4),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(227),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(12),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(229),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(165),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(244),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(175),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(172),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(171),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(232),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(222),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(240),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(253),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(213),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(235),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(170),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(239),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(181),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(167),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(173),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(174),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(191),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(238),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(227),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(139),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(263),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(225),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(234),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(138),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(262),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(1007),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(224),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(177),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(201),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(53),
    [sym_statement] = STATE(264),
    [sym_block] = STATE(200),
    [sym_expression_statement] = STATE(200),
    [sym_labeled_statement] = STATE(200),
    [sym_assert_statement] = STATE(200),
    [sym_do_statement] = STATE(200),
    [sym_break_statement] = STATE(200),
    [sym_continue_statement] = STATE(200),
    [sym_return_statement] = STATE(200),
    [sym_yield_statement] = STATE(200),
    [sym_synchronized_statement] = STATE(200),
    [sym_throw_statement] = STATE(200),
    [sym_try_statement] = STATE(200),
    [sym_try_with_resources_statement] = STATE(200),
    [sym_if_statement] = STATE(200),
    [sym_while_statement] = STATE(200),
    [sym_for_statement] = STATE(200),
    [sym_enhanced_for_statement] = STATE(200),
    [sym__annotation] = STATE(420),
    [sym_marker_annotation] = STATE(420),
    [sym_annotation] = STATE(420),
    [sym_declaration] = STATE(200),
    [sym_module_declaration] = STATE(189),
    [sym_package_declaration] = STATE(189),
    [sym_import_declaration] = STATE(189),
    [sym_enum_declaration] = STATE(189),
    [sym_class_declaration] = STATE(189),
    [sym_modifiers] = STATE(545),
    [sym_annotation_type_declaration] = STATE(189),
    [sym_interface_declaration] = STATE(189),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(568),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(200),
    [aux_sym_dimensions_expr_repeat1] = STATE(513),
    [aux_sym_modifiers_repeat1] = STATE(367),
    [sym_identifier] = ACTIONS(7),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_default] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(31),
    [anon_sym_assert] = ACTIONS(33),
    [anon_sym_do] = ACTIONS(35),
    [anon_sym_while] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_return] = ACTIONS(43),
    [anon_sym_yield] = ACTIONS(45),
    [anon_sym_synchronized] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_for] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_open] = ACTIONS(59),
    [anon_sym_module] = ACTIONS(61),
    [anon_sym_static] = ACTIONS(29),
    [anon_sym_package] = ACTIONS(63),
    [anon_sym_import] = ACTIONS(65),
    [anon_sym_enum] = ACTIONS(67),
    [anon_sym_public] = ACTIONS(29),
    [anon_sym_protected] = ACTIONS(29),
    [anon_sym_private] = ACTIONS(29),
    [anon_sym_abstract] = ACTIONS(29),
    [anon_sym_final] = ACTIONS(29),
    [anon_sym_strictfp] = ACTIONS(29),
    [anon_sym_native] = ACTIONS(29),
    [anon_sym_transient] = ACTIONS(29),
    [anon_sym_volatile] = ACTIONS(29),
    [anon_sym_ATinterface] = ACTIONS(69),
    [anon_sym_interface] = ACTIONS(71),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [45] = {
    [ts_builtin_sym_end] = ACTIONS(231),
    [sym_identifier] = ACTIONS(233),
    [sym_decimal_integer_literal] = ACTIONS(233),
    [sym_hex_integer_literal] = ACTIONS(233),
    [sym_octal_integer_literal] = ACTIONS(231),
    [sym_binary_integer_literal] = ACTIONS(231),
    [sym_decimal_floating_point_literal] = ACTIONS(231),
    [sym_hex_floating_point_literal] = ACTIONS(233),
    [sym_true] = ACTIONS(233),
    [sym_false] = ACTIONS(233),
    [sym_character_literal] = ACTIONS(231),
    [sym_string_literal] = ACTIONS(231),
    [sym_null_literal] = ACTIONS(233),
    [anon_sym_LPAREN] = ACTIONS(231),
    [anon_sym_AMP] = ACTIONS(233),
    [anon_sym_RPAREN] = ACTIONS(231),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(231),
    [anon_sym_LT_EQ] = ACTIONS(231),
    [anon_sym_EQ_EQ] = ACTIONS(231),
    [anon_sym_BANG_EQ] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(233),
    [anon_sym_DASH] = ACTIONS(233),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_SLASH] = ACTIONS(233),
    [anon_sym_PIPE] = ACTIONS(233),
    [anon_sym_CARET] = ACTIONS(231),
    [anon_sym_PERCENT] = ACTIONS(231),
    [anon_sym_LT_LT] = ACTIONS(231),
    [anon_sym_GT_GT] = ACTIONS(233),
    [anon_sym_GT_GT_GT] = ACTIONS(231),
    [anon_sym_instanceof] = ACTIONS(233),
    [anon_sym_DASH_GT] = ACTIONS(231),
    [anon_sym_COMMA] = ACTIONS(231),
    [anon_sym_QMARK] = ACTIONS(231),
    [anon_sym_COLON] = ACTIONS(233),
    [anon_sym_BANG] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(231),
    [anon_sym_PLUS_PLUS] = ACTIONS(231),
    [anon_sym_DASH_DASH] = ACTIONS(231),
    [anon_sym_new] = ACTIONS(233),
    [anon_sym_LBRACK] = ACTIONS(231),
    [anon_sym_RBRACK] = ACTIONS(231),
    [anon_sym_DOT] = ACTIONS(233),
    [anon_sym_class] = ACTIONS(233),
    [anon_sym_COLON_COLON] = ACTIONS(231),
    [anon_sym_switch] = ACTIONS(233),
    [anon_sym_LBRACE] = ACTIONS(231),
    [anon_sym_RBRACE] = ACTIONS(231),
    [anon_sym_case] = ACTIONS(233),
    [anon_sym_default] = ACTIONS(233),
    [anon_sym_SEMI] = ACTIONS(231),
    [anon_sym_assert] = ACTIONS(233),
    [anon_sym_do] = ACTIONS(233),
    [anon_sym_while] = ACTIONS(233),
    [anon_sym_break] = ACTIONS(233),
    [anon_sym_continue] = ACTIONS(233),
    [anon_sym_return] = ACTIONS(233),
    [anon_sym_yield] = ACTIONS(233),
    [anon_sym_synchronized] = ACTIONS(233),
    [anon_sym_throw] = ACTIONS(233),
    [anon_sym_try] = ACTIONS(233),
    [anon_sym_if] = ACTIONS(233),
    [anon_sym_else] = ACTIONS(233),
    [anon_sym_for] = ACTIONS(233),
    [anon_sym_AT] = ACTIONS(233),
    [anon_sym_open] = ACTIONS(233),
    [anon_sym_module] = ACTIONS(233),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_package] = ACTIONS(233),
    [anon_sym_import] = ACTIONS(233),
    [anon_sym_enum] = ACTIONS(233),
    [anon_sym_public] = ACTIONS(233),
    [anon_sym_protected] = ACTIONS(233),
    [anon_sym_private] = ACTIONS(233),
    [anon_sym_abstract] = ACTIONS(233),
    [anon_sym_final] = ACTIONS(233),
    [anon_sym_strictfp] = ACTIONS(233),
    [anon_sym_native] = ACTIONS(233),
    [anon_sym_transient] = ACTIONS(233),
    [anon_sym_volatile] = ACTIONS(233),
    [anon_sym_record] = ACTIONS(233),
    [anon_sym_ATinterface] = ACTIONS(231),
    [anon_sym_interface] = ACTIONS(233),
    [anon_sym_byte] = ACTIONS(233),
    [anon_sym_short] = ACTIONS(233),
    [anon_sym_int] = ACTIONS(233),
    [anon_sym_long] = ACTIONS(233),
    [anon_sym_char] = ACTIONS(233),
    [anon_sym_float] = ACTIONS(233),
    [anon_sym_double] = ACTIONS(233),
    [sym_boolean_type] = ACTIONS(233),
    [sym_void_type] = ACTIONS(233),
    [sym_this] = ACTIONS(233),
    [sym_super] = ACTIONS(233),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(235),
    [sym_identifier] = ACTIONS(237),
    [sym_decimal_integer_literal] = ACTIONS(237),
    [sym_hex_integer_literal] = ACTIONS(237),
    [sym_octal_integer_literal] = ACTIONS(235),
    [sym_binary_integer_literal] = ACTIONS(235),
    [sym_decimal_floating_point_literal] = ACTIONS(235),
    [sym_hex_floating_point_literal] = ACTIONS(237),
    [sym_true] = ACTIONS(237),
    [sym_false] = ACTIONS(237),
    [sym_character_literal] = ACTIONS(235),
    [sym_string_literal] = ACTIONS(235),
    [sym_null_literal] = ACTIONS(237),
    [anon_sym_LPAREN] = ACTIONS(235),
    [anon_sym_AMP] = ACTIONS(237),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(237),
    [anon_sym_LT] = ACTIONS(237),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_AMP_AMP] = ACTIONS(235),
    [anon_sym_PIPE_PIPE] = ACTIONS(235),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_SLASH] = ACTIONS(237),
    [anon_sym_PIPE] = ACTIONS(237),
    [anon_sym_CARET] = ACTIONS(235),
    [anon_sym_PERCENT] = ACTIONS(235),
    [anon_sym_LT_LT] = ACTIONS(235),
    [anon_sym_GT_GT] = ACTIONS(237),
    [anon_sym_GT_GT_GT] = ACTIONS(235),
    [anon_sym_instanceof] = ACTIONS(237),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_COMMA] = ACTIONS(235),
    [anon_sym_QMARK] = ACTIONS(235),
    [anon_sym_COLON] = ACTIONS(237),
    [anon_sym_BANG] = ACTIONS(237),
    [anon_sym_TILDE] = ACTIONS(235),
    [anon_sym_PLUS_PLUS] = ACTIONS(235),
    [anon_sym_DASH_DASH] = ACTIONS(235),
    [anon_sym_new] = ACTIONS(237),
    [anon_sym_LBRACK] = ACTIONS(235),
    [anon_sym_RBRACK] = ACTIONS(235),
    [anon_sym_DOT] = ACTIONS(237),
    [anon_sym_class] = ACTIONS(237),
    [anon_sym_COLON_COLON] = ACTIONS(235),
    [anon_sym_switch] = ACTIONS(237),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_case] = ACTIONS(237),
    [anon_sym_default] = ACTIONS(237),
    [anon_sym_SEMI] = ACTIONS(235),
    [anon_sym_assert] = ACTIONS(237),
    [anon_sym_do] = ACTIONS(237),
    [anon_sym_while] = ACTIONS(237),
    [anon_sym_break] = ACTIONS(237),
    [anon_sym_continue] = ACTIONS(237),
    [anon_sym_return] = ACTIONS(237),
    [anon_sym_yield] = ACTIONS(237),
    [anon_sym_synchronized] = ACTIONS(237),
    [anon_sym_throw] = ACTIONS(237),
    [anon_sym_try] = ACTIONS(237),
    [anon_sym_if] = ACTIONS(237),
    [anon_sym_else] = ACTIONS(237),
    [anon_sym_for] = ACTIONS(237),
    [anon_sym_AT] = ACTIONS(237),
    [anon_sym_open] = ACTIONS(237),
    [anon_sym_module] = ACTIONS(237),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_package] = ACTIONS(237),
    [anon_sym_import] = ACTIONS(237),
    [anon_sym_enum] = ACTIONS(237),
    [anon_sym_public] = ACTIONS(237),
    [anon_sym_protected] = ACTIONS(237),
    [anon_sym_private] = ACTIONS(237),
    [anon_sym_abstract] = ACTIONS(237),
    [anon_sym_final] = ACTIONS(237),
    [anon_sym_strictfp] = ACTIONS(237),
    [anon_sym_native] = ACTIONS(237),
    [anon_sym_transient] = ACTIONS(237),
    [anon_sym_volatile] = ACTIONS(237),
    [anon_sym_record] = ACTIONS(237),
    [anon_sym_ATinterface] = ACTIONS(235),
    [anon_sym_interface] = ACTIONS(237),
    [anon_sym_byte] = ACTIONS(237),
    [anon_sym_short] = ACTIONS(237),
    [anon_sym_int] = ACTIONS(237),
    [anon_sym_long] = ACTIONS(237),
    [anon_sym_char] = ACTIONS(237),
    [anon_sym_float] = ACTIONS(237),
    [anon_sym_double] = ACTIONS(237),
    [sym_boolean_type] = ACTIONS(237),
    [sym_void_type] = ACTIONS(237),
    [sym_this] = ACTIONS(237),
    [sym_super] = ACTIONS(237),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(239),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(241),
    [sym_hex_integer_literal] = ACTIONS(241),
    [sym_octal_integer_literal] = ACTIONS(239),
    [sym_binary_integer_literal] = ACTIONS(239),
    [sym_decimal_floating_point_literal] = ACTIONS(239),
    [sym_hex_floating_point_literal] = ACTIONS(241),
    [sym_true] = ACTIONS(241),
    [sym_false] = ACTIONS(241),
    [sym_character_literal] = ACTIONS(239),
    [sym_string_literal] = ACTIONS(239),
    [sym_null_literal] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(239),
    [anon_sym_AMP] = ACTIONS(241),
    [anon_sym_RPAREN] = ACTIONS(239),
    [anon_sym_GT] = ACTIONS(241),
    [anon_sym_LT] = ACTIONS(241),
    [anon_sym_GT_EQ] = ACTIONS(239),
    [anon_sym_LT_EQ] = ACTIONS(239),
    [anon_sym_EQ_EQ] = ACTIONS(239),
    [anon_sym_BANG_EQ] = ACTIONS(239),
    [anon_sym_AMP_AMP] = ACTIONS(239),
    [anon_sym_PIPE_PIPE] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_PIPE] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(239),
    [anon_sym_PERCENT] = ACTIONS(239),
    [anon_sym_LT_LT] = ACTIONS(239),
    [anon_sym_GT_GT] = ACTIONS(241),
    [anon_sym_GT_GT_GT] = ACTIONS(239),
    [anon_sym_instanceof] = ACTIONS(241),
    [anon_sym_DASH_GT] = ACTIONS(239),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(239),
    [anon_sym_COLON] = ACTIONS(239),
    [anon_sym_BANG] = ACTIONS(241),
    [anon_sym_TILDE] = ACTIONS(239),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_new] = ACTIONS(241),
    [anon_sym_RBRACK] = ACTIONS(239),
    [anon_sym_class] = ACTIONS(241),
    [anon_sym_switch] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_case] = ACTIONS(241),
    [anon_sym_default] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_assert] = ACTIONS(241),
    [anon_sym_do] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(241),
    [anon_sym_break] = ACTIONS(241),
    [anon_sym_continue] = ACTIONS(241),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_yield] = ACTIONS(241),
    [anon_sym_synchronized] = ACTIONS(241),
    [anon_sym_throw] = ACTIONS(241),
    [anon_sym_try] = ACTIONS(241),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(241),
    [anon_sym_static] = ACTIONS(241),
    [anon_sym_package] = ACTIONS(241),
    [anon_sym_import] = ACTIONS(241),
    [anon_sym_enum] = ACTIONS(241),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_abstract] = ACTIONS(241),
    [anon_sym_final] = ACTIONS(241),
    [anon_sym_strictfp] = ACTIONS(241),
    [anon_sym_native] = ACTIONS(241),
    [anon_sym_transient] = ACTIONS(241),
    [anon_sym_volatile] = ACTIONS(241),
    [anon_sym_record] = ACTIONS(241),
    [anon_sym_ATinterface] = ACTIONS(239),
    [anon_sym_interface] = ACTIONS(241),
    [anon_sym_byte] = ACTIONS(241),
    [anon_sym_short] = ACTIONS(241),
    [anon_sym_int] = ACTIONS(241),
    [anon_sym_long] = ACTIONS(241),
    [anon_sym_char] = ACTIONS(241),
    [anon_sym_float] = ACTIONS(241),
    [anon_sym_double] = ACTIONS(241),
    [sym_boolean_type] = ACTIONS(241),
    [sym_void_type] = ACTIONS(241),
    [sym_this] = ACTIONS(241),
    [sym_super] = ACTIONS(241),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(243),
    [sym_identifier] = ACTIONS(245),
    [sym_decimal_integer_literal] = ACTIONS(245),
    [sym_hex_integer_literal] = ACTIONS(245),
    [sym_octal_integer_literal] = ACTIONS(243),
    [sym_binary_integer_literal] = ACTIONS(243),
    [sym_decimal_floating_point_literal] = ACTIONS(243),
    [sym_hex_floating_point_literal] = ACTIONS(245),
    [sym_true] = ACTIONS(245),
    [sym_false] = ACTIONS(245),
    [sym_character_literal] = ACTIONS(243),
    [sym_string_literal] = ACTIONS(243),
    [sym_null_literal] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_AMP] = ACTIONS(245),
    [anon_sym_RPAREN] = ACTIONS(243),
    [anon_sym_GT] = ACTIONS(245),
    [anon_sym_LT] = ACTIONS(245),
    [anon_sym_GT_EQ] = ACTIONS(243),
    [anon_sym_LT_EQ] = ACTIONS(243),
    [anon_sym_EQ_EQ] = ACTIONS(243),
    [anon_sym_BANG_EQ] = ACTIONS(243),
    [anon_sym_AMP_AMP] = ACTIONS(243),
    [anon_sym_PIPE_PIPE] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_STAR] = ACTIONS(243),
    [anon_sym_SLASH] = ACTIONS(245),
    [anon_sym_PIPE] = ACTIONS(245),
    [anon_sym_CARET] = ACTIONS(243),
    [anon_sym_PERCENT] = ACTIONS(243),
    [anon_sym_LT_LT] = ACTIONS(243),
    [anon_sym_GT_GT] = ACTIONS(245),
    [anon_sym_GT_GT_GT] = ACTIONS(243),
    [anon_sym_instanceof] = ACTIONS(245),
    [anon_sym_DASH_GT] = ACTIONS(243),
    [anon_sym_COMMA] = ACTIONS(243),
    [anon_sym_QMARK] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(243),
    [anon_sym_BANG] = ACTIONS(245),
    [anon_sym_TILDE] = ACTIONS(243),
    [anon_sym_PLUS_PLUS] = ACTIONS(243),
    [anon_sym_DASH_DASH] = ACTIONS(243),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_RBRACK] = ACTIONS(243),
    [anon_sym_class] = ACTIONS(245),
    [anon_sym_switch] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_case] = ACTIONS(245),
    [anon_sym_default] = ACTIONS(245),
    [anon_sym_SEMI] = ACTIONS(243),
    [anon_sym_assert] = ACTIONS(245),
    [anon_sym_do] = ACTIONS(245),
    [anon_sym_while] = ACTIONS(245),
    [anon_sym_break] = ACTIONS(245),
    [anon_sym_continue] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(245),
    [anon_sym_yield] = ACTIONS(245),
    [anon_sym_synchronized] = ACTIONS(245),
    [anon_sym_throw] = ACTIONS(245),
    [anon_sym_try] = ACTIONS(245),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_else] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(245),
    [anon_sym_open] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_static] = ACTIONS(245),
    [anon_sym_package] = ACTIONS(245),
    [anon_sym_import] = ACTIONS(245),
    [anon_sym_enum] = ACTIONS(245),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_abstract] = ACTIONS(245),
    [anon_sym_final] = ACTIONS(245),
    [anon_sym_strictfp] = ACTIONS(245),
    [anon_sym_native] = ACTIONS(245),
    [anon_sym_transient] = ACTIONS(245),
    [anon_sym_volatile] = ACTIONS(245),
    [anon_sym_record] = ACTIONS(245),
    [anon_sym_ATinterface] = ACTIONS(243),
    [anon_sym_interface] = ACTIONS(245),
    [anon_sym_byte] = ACTIONS(245),
    [anon_sym_short] = ACTIONS(245),
    [anon_sym_int] = ACTIONS(245),
    [anon_sym_long] = ACTIONS(245),
    [anon_sym_char] = ACTIONS(245),
    [anon_sym_float] = ACTIONS(245),
    [anon_sym_double] = ACTIONS(245),
    [sym_boolean_type] = ACTIONS(245),
    [sym_void_type] = ACTIONS(245),
    [sym_this] = ACTIONS(245),
    [sym_super] = ACTIONS(245),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(247),
    [sym_identifier] = ACTIONS(249),
    [sym_decimal_integer_literal] = ACTIONS(249),
    [sym_hex_integer_literal] = ACTIONS(249),
    [sym_octal_integer_literal] = ACTIONS(247),
    [sym_binary_integer_literal] = ACTIONS(247),
    [sym_decimal_floating_point_literal] = ACTIONS(247),
    [sym_hex_floating_point_literal] = ACTIONS(249),
    [sym_true] = ACTIONS(249),
    [sym_false] = ACTIONS(249),
    [sym_character_literal] = ACTIONS(247),
    [sym_string_literal] = ACTIONS(247),
    [sym_null_literal] = ACTIONS(249),
    [anon_sym_LPAREN] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT_EQ] = ACTIONS(247),
    [anon_sym_LT_EQ] = ACTIONS(247),
    [anon_sym_EQ_EQ] = ACTIONS(247),
    [anon_sym_BANG_EQ] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_PLUS] = ACTIONS(249),
    [anon_sym_DASH] = ACTIONS(249),
    [anon_sym_STAR] = ACTIONS(247),
    [anon_sym_SLASH] = ACTIONS(249),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_CARET] = ACTIONS(247),
    [anon_sym_PERCENT] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_GT_GT_GT] = ACTIONS(247),
    [anon_sym_instanceof] = ACTIONS(249),
    [anon_sym_DASH_GT] = ACTIONS(247),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_QMARK] = ACTIONS(247),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_TILDE] = ACTIONS(247),
    [anon_sym_PLUS_PLUS] = ACTIONS(247),
    [anon_sym_DASH_DASH] = ACTIONS(247),
    [anon_sym_new] = ACTIONS(249),
    [anon_sym_RBRACK] = ACTIONS(247),
    [anon_sym_class] = ACTIONS(249),
    [anon_sym_switch] = ACTIONS(249),
    [anon_sym_LBRACE] = ACTIONS(247),
    [anon_sym_RBRACE] = ACTIONS(247),
    [anon_sym_case] = ACTIONS(249),
    [anon_sym_default] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(247),
    [anon_sym_assert] = ACTIONS(249),
    [anon_sym_do] = ACTIONS(249),
    [anon_sym_while] = ACTIONS(249),
    [anon_sym_break] = ACTIONS(249),
    [anon_sym_continue] = ACTIONS(249),
    [anon_sym_return] = ACTIONS(249),
    [anon_sym_yield] = ACTIONS(249),
    [anon_sym_synchronized] = ACTIONS(249),
    [anon_sym_throw] = ACTIONS(249),
    [anon_sym_try] = ACTIONS(249),
    [anon_sym_if] = ACTIONS(249),
    [anon_sym_else] = ACTIONS(249),
    [anon_sym_for] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [anon_sym_open] = ACTIONS(249),
    [anon_sym_module] = ACTIONS(249),
    [anon_sym_static] = ACTIONS(249),
    [anon_sym_package] = ACTIONS(249),
    [anon_sym_import] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(249),
    [anon_sym_public] = ACTIONS(249),
    [anon_sym_protected] = ACTIONS(249),
    [anon_sym_private] = ACTIONS(249),
    [anon_sym_abstract] = ACTIONS(249),
    [anon_sym_final] = ACTIONS(249),
    [anon_sym_strictfp] = ACTIONS(249),
    [anon_sym_native] = ACTIONS(249),
    [anon_sym_transient] = ACTIONS(249),
    [anon_sym_volatile] = ACTIONS(249),
    [anon_sym_ATinterface] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_byte] = ACTIONS(249),
    [anon_sym_short] = ACTIONS(249),
    [anon_sym_int] = ACTIONS(249),
    [anon_sym_long] = ACTIONS(249),
    [anon_sym_char] = ACTIONS(249),
    [anon_sym_float] = ACTIONS(249),
    [anon_sym_double] = ACTIONS(249),
    [sym_boolean_type] = ACTIONS(249),
    [sym_void_type] = ACTIONS(249),
    [sym_this] = ACTIONS(249),
    [sym_super] = ACTIONS(249),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(251),
    [sym_identifier] = ACTIONS(253),
    [sym_decimal_integer_literal] = ACTIONS(253),
    [sym_hex_integer_literal] = ACTIONS(253),
    [sym_octal_integer_literal] = ACTIONS(251),
    [sym_binary_integer_literal] = ACTIONS(251),
    [sym_decimal_floating_point_literal] = ACTIONS(251),
    [sym_hex_floating_point_literal] = ACTIONS(253),
    [sym_true] = ACTIONS(253),
    [sym_false] = ACTIONS(253),
    [sym_character_literal] = ACTIONS(251),
    [sym_string_literal] = ACTIONS(251),
    [sym_null_literal] = ACTIONS(253),
    [anon_sym_LPAREN] = ACTIONS(251),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_EQ] = ACTIONS(251),
    [anon_sym_EQ_EQ] = ACTIONS(251),
    [anon_sym_BANG_EQ] = ACTIONS(251),
    [anon_sym_AMP_AMP] = ACTIONS(251),
    [anon_sym_PIPE_PIPE] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(251),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(251),
    [anon_sym_PERCENT] = ACTIONS(251),
    [anon_sym_LT_LT] = ACTIONS(251),
    [anon_sym_GT_GT] = ACTIONS(253),
    [anon_sym_GT_GT_GT] = ACTIONS(251),
    [anon_sym_instanceof] = ACTIONS(253),
    [anon_sym_DASH_GT] = ACTIONS(251),
    [anon_sym_COMMA] = ACTIONS(251),
    [anon_sym_QMARK] = ACTIONS(251),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_BANG] = ACTIONS(253),
    [anon_sym_TILDE] = ACTIONS(251),
    [anon_sym_PLUS_PLUS] = ACTIONS(251),
    [anon_sym_DASH_DASH] = ACTIONS(251),
    [anon_sym_new] = ACTIONS(253),
    [anon_sym_RBRACK] = ACTIONS(251),
    [anon_sym_class] = ACTIONS(253),
    [anon_sym_switch] = ACTIONS(253),
    [anon_sym_LBRACE] = ACTIONS(251),
    [anon_sym_RBRACE] = ACTIONS(251),
    [anon_sym_case] = ACTIONS(253),
    [anon_sym_default] = ACTIONS(253),
    [anon_sym_SEMI] = ACTIONS(251),
    [anon_sym_assert] = ACTIONS(253),
    [anon_sym_do] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_break] = ACTIONS(253),
    [anon_sym_continue] = ACTIONS(253),
    [anon_sym_return] = ACTIONS(253),
    [anon_sym_yield] = ACTIONS(253),
    [anon_sym_synchronized] = ACTIONS(253),
    [anon_sym_throw] = ACTIONS(253),
    [anon_sym_try] = ACTIONS(253),
    [anon_sym_if] = ACTIONS(253),
    [anon_sym_else] = ACTIONS(253),
    [anon_sym_for] = ACTIONS(253),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_open] = ACTIONS(253),
    [anon_sym_module] = ACTIONS(253),
    [anon_sym_static] = ACTIONS(253),
    [anon_sym_package] = ACTIONS(253),
    [anon_sym_import] = ACTIONS(253),
    [anon_sym_enum] = ACTIONS(253),
    [anon_sym_public] = ACTIONS(253),
    [anon_sym_protected] = ACTIONS(253),
    [anon_sym_private] = ACTIONS(253),
    [anon_sym_abstract] = ACTIONS(253),
    [anon_sym_final] = ACTIONS(253),
    [anon_sym_strictfp] = ACTIONS(253),
    [anon_sym_native] = ACTIONS(253),
    [anon_sym_transient] = ACTIONS(253),
    [anon_sym_volatile] = ACTIONS(253),
    [anon_sym_ATinterface] = ACTIONS(251),
    [anon_sym_interface] = ACTIONS(253),
    [anon_sym_byte] = ACTIONS(253),
    [anon_sym_short] = ACTIONS(253),
    [anon_sym_int] = ACTIONS(253),
    [anon_sym_long] = ACTIONS(253),
    [anon_sym_char] = ACTIONS(253),
    [anon_sym_float] = ACTIONS(253),
    [anon_sym_double] = ACTIONS(253),
    [sym_boolean_type] = ACTIONS(253),
    [sym_void_type] = ACTIONS(253),
    [sym_this] = ACTIONS(253),
    [sym_super] = ACTIONS(253),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_identifier] = ACTIONS(255),
    [sym_decimal_integer_literal] = ACTIONS(255),
    [sym_hex_integer_literal] = ACTIONS(255),
    [sym_octal_integer_literal] = ACTIONS(257),
    [sym_binary_integer_literal] = ACTIONS(257),
    [sym_decimal_floating_point_literal] = ACTIONS(257),
    [sym_hex_floating_point_literal] = ACTIONS(255),
    [sym_true] = ACTIONS(255),
    [sym_false] = ACTIONS(255),
    [sym_character_literal] = ACTIONS(257),
    [sym_string_literal] = ACTIONS(257),
    [sym_null_literal] = ACTIONS(255),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_AMP] = ACTIONS(255),
    [anon_sym_RPAREN] = ACTIONS(257),
    [anon_sym_GT] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(255),
    [anon_sym_GT_EQ] = ACTIONS(257),
    [anon_sym_LT_EQ] = ACTIONS(257),
    [anon_sym_EQ_EQ] = ACTIONS(257),
    [anon_sym_BANG_EQ] = ACTIONS(257),
    [anon_sym_AMP_AMP] = ACTIONS(257),
    [anon_sym_PIPE_PIPE] = ACTIONS(257),
    [anon_sym_PLUS] = ACTIONS(255),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_STAR] = ACTIONS(257),
    [anon_sym_SLASH] = ACTIONS(255),
    [anon_sym_PIPE] = ACTIONS(255),
    [anon_sym_CARET] = ACTIONS(257),
    [anon_sym_PERCENT] = ACTIONS(257),
    [anon_sym_LT_LT] = ACTIONS(257),
    [anon_sym_GT_GT] = ACTIONS(255),
    [anon_sym_GT_GT_GT] = ACTIONS(257),
    [anon_sym_instanceof] = ACTIONS(255),
    [anon_sym_DASH_GT] = ACTIONS(257),
    [anon_sym_COMMA] = ACTIONS(257),
    [anon_sym_QMARK] = ACTIONS(257),
    [anon_sym_COLON] = ACTIONS(255),
    [anon_sym_BANG] = ACTIONS(255),
    [anon_sym_TILDE] = ACTIONS(257),
    [anon_sym_PLUS_PLUS] = ACTIONS(257),
    [anon_sym_DASH_DASH] = ACTIONS(257),
    [anon_sym_new] = ACTIONS(255),
    [anon_sym_LBRACK] = ACTIONS(257),
    [anon_sym_RBRACK] = ACTIONS(257),
    [anon_sym_DOT] = ACTIONS(255),
    [anon_sym_class] = ACTIONS(255),
    [anon_sym_COLON_COLON] = ACTIONS(257),
    [anon_sym_switch] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(257),
    [anon_sym_RBRACE] = ACTIONS(257),
    [anon_sym_default] = ACTIONS(255),
    [anon_sym_SEMI] = ACTIONS(257),
    [anon_sym_assert] = ACTIONS(255),
    [anon_sym_do] = ACTIONS(255),
    [anon_sym_while] = ACTIONS(255),
    [anon_sym_break] = ACTIONS(255),
    [anon_sym_continue] = ACTIONS(255),
    [anon_sym_return] = ACTIONS(255),
    [anon_sym_yield] = ACTIONS(255),
    [anon_sym_synchronized] = ACTIONS(255),
    [anon_sym_throw] = ACTIONS(255),
    [anon_sym_try] = ACTIONS(255),
    [anon_sym_if] = ACTIONS(255),
    [anon_sym_for] = ACTIONS(255),
    [anon_sym_AT] = ACTIONS(255),
    [anon_sym_open] = ACTIONS(255),
    [anon_sym_module] = ACTIONS(255),
    [anon_sym_static] = ACTIONS(255),
    [anon_sym_package] = ACTIONS(255),
    [anon_sym_import] = ACTIONS(255),
    [anon_sym_enum] = ACTIONS(255),
    [anon_sym_public] = ACTIONS(255),
    [anon_sym_protected] = ACTIONS(255),
    [anon_sym_private] = ACTIONS(255),
    [anon_sym_abstract] = ACTIONS(255),
    [anon_sym_final] = ACTIONS(255),
    [anon_sym_strictfp] = ACTIONS(255),
    [anon_sym_native] = ACTIONS(255),
    [anon_sym_transient] = ACTIONS(255),
    [anon_sym_volatile] = ACTIONS(255),
    [anon_sym_ATinterface] = ACTIONS(257),
    [anon_sym_interface] = ACTIONS(255),
    [anon_sym_byte] = ACTIONS(255),
    [anon_sym_short] = ACTIONS(255),
    [anon_sym_int] = ACTIONS(255),
    [anon_sym_long] = ACTIONS(255),
    [anon_sym_char] = ACTIONS(255),
    [anon_sym_float] = ACTIONS(255),
    [anon_sym_double] = ACTIONS(255),
    [sym_boolean_type] = ACTIONS(255),
    [sym_void_type] = ACTIONS(255),
    [sym_this] = ACTIONS(255),
    [sym_super] = ACTIONS(255),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(259),
    [sym_identifier] = ACTIONS(261),
    [sym_decimal_integer_literal] = ACTIONS(261),
    [sym_hex_integer_literal] = ACTIONS(261),
    [sym_octal_integer_literal] = ACTIONS(259),
    [sym_binary_integer_literal] = ACTIONS(259),
    [sym_decimal_floating_point_literal] = ACTIONS(259),
    [sym_hex_floating_point_literal] = ACTIONS(261),
    [sym_true] = ACTIONS(261),
    [sym_false] = ACTIONS(261),
    [sym_character_literal] = ACTIONS(259),
    [sym_string_literal] = ACTIONS(259),
    [sym_null_literal] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_LT] = ACTIONS(261),
    [anon_sym_GT_EQ] = ACTIONS(259),
    [anon_sym_LT_EQ] = ACTIONS(259),
    [anon_sym_EQ_EQ] = ACTIONS(259),
    [anon_sym_BANG_EQ] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(259),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_CARET] = ACTIONS(259),
    [anon_sym_PERCENT] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(259),
    [anon_sym_GT_GT] = ACTIONS(261),
    [anon_sym_GT_GT_GT] = ACTIONS(259),
    [anon_sym_instanceof] = ACTIONS(261),
    [anon_sym_DASH_GT] = ACTIONS(259),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_QMARK] = ACTIONS(259),
    [anon_sym_COLON] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(259),
    [anon_sym_PLUS_PLUS] = ACTIONS(259),
    [anon_sym_DASH_DASH] = ACTIONS(259),
    [anon_sym_new] = ACTIONS(261),
    [anon_sym_RBRACK] = ACTIONS(259),
    [anon_sym_class] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(259),
    [anon_sym_assert] = ACTIONS(261),
    [anon_sym_do] = ACTIONS(261),
    [anon_sym_while] = ACTIONS(261),
    [anon_sym_break] = ACTIONS(261),
    [anon_sym_continue] = ACTIONS(261),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_yield] = ACTIONS(261),
    [anon_sym_synchronized] = ACTIONS(261),
    [anon_sym_throw] = ACTIONS(261),
    [anon_sym_try] = ACTIONS(261),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_else] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_open] = ACTIONS(261),
    [anon_sym_module] = ACTIONS(261),
    [anon_sym_static] = ACTIONS(261),
    [anon_sym_package] = ACTIONS(261),
    [anon_sym_import] = ACTIONS(261),
    [anon_sym_enum] = ACTIONS(261),
    [anon_sym_public] = ACTIONS(261),
    [anon_sym_protected] = ACTIONS(261),
    [anon_sym_private] = ACTIONS(261),
    [anon_sym_abstract] = ACTIONS(261),
    [anon_sym_final] = ACTIONS(261),
    [anon_sym_strictfp] = ACTIONS(261),
    [anon_sym_native] = ACTIONS(261),
    [anon_sym_transient] = ACTIONS(261),
    [anon_sym_volatile] = ACTIONS(261),
    [anon_sym_ATinterface] = ACTIONS(259),
    [anon_sym_interface] = ACTIONS(261),
    [anon_sym_byte] = ACTIONS(261),
    [anon_sym_short] = ACTIONS(261),
    [anon_sym_int] = ACTIONS(261),
    [anon_sym_long] = ACTIONS(261),
    [anon_sym_char] = ACTIONS(261),
    [anon_sym_float] = ACTIONS(261),
    [anon_sym_double] = ACTIONS(261),
    [sym_boolean_type] = ACTIONS(261),
    [sym_void_type] = ACTIONS(261),
    [sym_this] = ACTIONS(261),
    [sym_super] = ACTIONS(261),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(265),
    [sym_decimal_integer_literal] = ACTIONS(265),
    [sym_hex_integer_literal] = ACTIONS(265),
    [sym_octal_integer_literal] = ACTIONS(263),
    [sym_binary_integer_literal] = ACTIONS(263),
    [sym_decimal_floating_point_literal] = ACTIONS(263),
    [sym_hex_floating_point_literal] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_character_literal] = ACTIONS(263),
    [sym_string_literal] = ACTIONS(263),
    [sym_null_literal] = ACTIONS(265),
    [anon_sym_LPAREN] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(267),
    [anon_sym_GT_EQ] = ACTIONS(269),
    [anon_sym_LT_EQ] = ACTIONS(269),
    [anon_sym_EQ_EQ] = ACTIONS(269),
    [anon_sym_BANG_EQ] = ACTIONS(269),
    [anon_sym_AMP_AMP] = ACTIONS(269),
    [anon_sym_PIPE_PIPE] = ACTIONS(269),
    [anon_sym_PLUS] = ACTIONS(267),
    [anon_sym_DASH] = ACTIONS(267),
    [anon_sym_STAR] = ACTIONS(269),
    [anon_sym_SLASH] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_CARET] = ACTIONS(269),
    [anon_sym_PERCENT] = ACTIONS(269),
    [anon_sym_LT_LT] = ACTIONS(269),
    [anon_sym_GT_GT] = ACTIONS(267),
    [anon_sym_GT_GT_GT] = ACTIONS(269),
    [anon_sym_instanceof] = ACTIONS(267),
    [anon_sym_QMARK] = ACTIONS(269),
    [anon_sym_BANG] = ACTIONS(265),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(269),
    [anon_sym_DASH_DASH] = ACTIONS(269),
    [anon_sym_new] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_switch] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(269),
    [anon_sym_assert] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(265),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(265),
    [anon_sym_synchronized] = ACTIONS(265),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_open] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(265),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_package] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(265),
    [anon_sym_enum] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(265),
    [anon_sym_strictfp] = ACTIONS(265),
    [anon_sym_native] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(265),
    [anon_sym_volatile] = ACTIONS(265),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_double] = ACTIONS(265),
    [sym_boolean_type] = ACTIONS(265),
    [sym_void_type] = ACTIONS(265),
    [sym_this] = ACTIONS(265),
    [sym_super] = ACTIONS(265),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(501),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(563),
    [sym__type] = STATE(720),
    [sym__unannotated_type] = STATE(553),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_formal_parameter] = STATE(825),
    [sym_receiver_parameter] = STATE(313),
    [sym_spread_parameter] = STATE(825),
    [aux_sym_dimensions_expr_repeat1] = STATE(540),
    [aux_sym_modifiers_repeat1] = STATE(454),
    [sym_identifier] = ACTIONS(271),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(501),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(563),
    [sym__type] = STATE(741),
    [sym__unannotated_type] = STATE(553),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_formal_parameter] = STATE(825),
    [sym_receiver_parameter] = STATE(313),
    [sym_spread_parameter] = STATE(825),
    [aux_sym_dimensions_expr_repeat1] = STATE(540),
    [aux_sym_modifiers_repeat1] = STATE(454),
    [sym_identifier] = ACTIONS(271),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(474),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(531),
    [sym_marker_annotation] = STATE(531),
    [sym_annotation] = STATE(531),
    [sym_modifiers] = STATE(565),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(562),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [sym_local_variable_declaration] = STATE(123),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [aux_sym_modifiers_repeat1] = STATE(454),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(283),
    [anon_sym_synchronized] = ACTIONS(275),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_abstract] = ACTIONS(275),
    [anon_sym_final] = ACTIONS(275),
    [anon_sym_strictfp] = ACTIONS(275),
    [anon_sym_native] = ACTIONS(275),
    [anon_sym_transient] = ACTIONS(275),
    [anon_sym_volatile] = ACTIONS(275),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_catch_clause] = STATE(63),
    [sym_finally_clause] = STATE(198),
    [aux_sym_try_statement_repeat1] = STATE(63),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(287),
    [sym_decimal_integer_literal] = ACTIONS(287),
    [sym_hex_integer_literal] = ACTIONS(287),
    [sym_octal_integer_literal] = ACTIONS(285),
    [sym_binary_integer_literal] = ACTIONS(285),
    [sym_decimal_floating_point_literal] = ACTIONS(285),
    [sym_hex_floating_point_literal] = ACTIONS(287),
    [sym_true] = ACTIONS(287),
    [sym_false] = ACTIONS(287),
    [sym_character_literal] = ACTIONS(285),
    [sym_string_literal] = ACTIONS(285),
    [sym_null_literal] = ACTIONS(287),
    [anon_sym_LPAREN] = ACTIONS(285),
    [anon_sym_PLUS] = ACTIONS(287),
    [anon_sym_DASH] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(285),
    [anon_sym_TILDE] = ACTIONS(285),
    [anon_sym_PLUS_PLUS] = ACTIONS(285),
    [anon_sym_DASH_DASH] = ACTIONS(285),
    [anon_sym_new] = ACTIONS(287),
    [anon_sym_class] = ACTIONS(287),
    [anon_sym_switch] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_case] = ACTIONS(287),
    [anon_sym_default] = ACTIONS(287),
    [anon_sym_SEMI] = ACTIONS(285),
    [anon_sym_assert] = ACTIONS(287),
    [anon_sym_do] = ACTIONS(287),
    [anon_sym_while] = ACTIONS(287),
    [anon_sym_break] = ACTIONS(287),
    [anon_sym_continue] = ACTIONS(287),
    [anon_sym_return] = ACTIONS(287),
    [anon_sym_yield] = ACTIONS(287),
    [anon_sym_synchronized] = ACTIONS(287),
    [anon_sym_throw] = ACTIONS(287),
    [anon_sym_try] = ACTIONS(287),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(287),
    [anon_sym_else] = ACTIONS(287),
    [anon_sym_for] = ACTIONS(287),
    [anon_sym_AT] = ACTIONS(287),
    [anon_sym_open] = ACTIONS(287),
    [anon_sym_module] = ACTIONS(287),
    [anon_sym_static] = ACTIONS(287),
    [anon_sym_package] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(287),
    [anon_sym_enum] = ACTIONS(287),
    [anon_sym_public] = ACTIONS(287),
    [anon_sym_protected] = ACTIONS(287),
    [anon_sym_private] = ACTIONS(287),
    [anon_sym_abstract] = ACTIONS(287),
    [anon_sym_final] = ACTIONS(287),
    [anon_sym_strictfp] = ACTIONS(287),
    [anon_sym_native] = ACTIONS(287),
    [anon_sym_transient] = ACTIONS(287),
    [anon_sym_volatile] = ACTIONS(287),
    [anon_sym_ATinterface] = ACTIONS(285),
    [anon_sym_interface] = ACTIONS(287),
    [anon_sym_byte] = ACTIONS(287),
    [anon_sym_short] = ACTIONS(287),
    [anon_sym_int] = ACTIONS(287),
    [anon_sym_long] = ACTIONS(287),
    [anon_sym_char] = ACTIONS(287),
    [anon_sym_float] = ACTIONS(287),
    [anon_sym_double] = ACTIONS(287),
    [sym_boolean_type] = ACTIONS(287),
    [sym_void_type] = ACTIONS(287),
    [sym_this] = ACTIONS(287),
    [sym_super] = ACTIONS(287),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym_element_value_pair] = STATE(863),
    [sym__element_value] = STATE(1028),
    [sym_element_value_array_initializer] = STATE(1028),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(293),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(295),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_catch_clause] = STATE(66),
    [sym_finally_clause] = STATE(193),
    [aux_sym_try_statement_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(301),
    [sym_hex_integer_literal] = ACTIONS(301),
    [sym_octal_integer_literal] = ACTIONS(299),
    [sym_binary_integer_literal] = ACTIONS(299),
    [sym_decimal_floating_point_literal] = ACTIONS(299),
    [sym_hex_floating_point_literal] = ACTIONS(301),
    [sym_true] = ACTIONS(301),
    [sym_false] = ACTIONS(301),
    [sym_character_literal] = ACTIONS(299),
    [sym_string_literal] = ACTIONS(299),
    [sym_null_literal] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_BANG] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(299),
    [anon_sym_DASH_DASH] = ACTIONS(299),
    [anon_sym_new] = ACTIONS(301),
    [anon_sym_class] = ACTIONS(301),
    [anon_sym_switch] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_case] = ACTIONS(301),
    [anon_sym_default] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_assert] = ACTIONS(301),
    [anon_sym_do] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_break] = ACTIONS(301),
    [anon_sym_continue] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_yield] = ACTIONS(301),
    [anon_sym_synchronized] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_else] = ACTIONS(301),
    [anon_sym_for] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(301),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_static] = ACTIONS(301),
    [anon_sym_package] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(301),
    [anon_sym_enum] = ACTIONS(301),
    [anon_sym_public] = ACTIONS(301),
    [anon_sym_protected] = ACTIONS(301),
    [anon_sym_private] = ACTIONS(301),
    [anon_sym_abstract] = ACTIONS(301),
    [anon_sym_final] = ACTIONS(301),
    [anon_sym_strictfp] = ACTIONS(301),
    [anon_sym_native] = ACTIONS(301),
    [anon_sym_transient] = ACTIONS(301),
    [anon_sym_volatile] = ACTIONS(301),
    [anon_sym_ATinterface] = ACTIONS(299),
    [anon_sym_interface] = ACTIONS(301),
    [anon_sym_byte] = ACTIONS(301),
    [anon_sym_short] = ACTIONS(301),
    [anon_sym_int] = ACTIONS(301),
    [anon_sym_long] = ACTIONS(301),
    [anon_sym_char] = ACTIONS(301),
    [anon_sym_float] = ACTIONS(301),
    [anon_sym_double] = ACTIONS(301),
    [sym_boolean_type] = ACTIONS(301),
    [sym_void_type] = ACTIONS(301),
    [sym_this] = ACTIONS(301),
    [sym_super] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(509),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym_block] = STATE(832),
    [sym_expression_statement] = STATE(832),
    [sym_throw_statement] = STATE(832),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym_element_value_pair] = STATE(834),
    [sym__element_value] = STATE(1008),
    [sym_element_value_array_initializer] = STATE(1008),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(293),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(303),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(797),
    [sym_element_value_array_initializer] = STATE(797),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(305),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_catch_clause] = STATE(66),
    [sym_finally_clause] = STATE(178),
    [aux_sym_try_statement_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_identifier] = ACTIONS(311),
    [sym_decimal_integer_literal] = ACTIONS(311),
    [sym_hex_integer_literal] = ACTIONS(311),
    [sym_octal_integer_literal] = ACTIONS(309),
    [sym_binary_integer_literal] = ACTIONS(309),
    [sym_decimal_floating_point_literal] = ACTIONS(309),
    [sym_hex_floating_point_literal] = ACTIONS(311),
    [sym_true] = ACTIONS(311),
    [sym_false] = ACTIONS(311),
    [sym_character_literal] = ACTIONS(309),
    [sym_string_literal] = ACTIONS(309),
    [sym_null_literal] = ACTIONS(311),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(311),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(309),
    [anon_sym_DASH_DASH] = ACTIONS(309),
    [anon_sym_new] = ACTIONS(311),
    [anon_sym_class] = ACTIONS(311),
    [anon_sym_switch] = ACTIONS(311),
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_case] = ACTIONS(311),
    [anon_sym_default] = ACTIONS(311),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_assert] = ACTIONS(311),
    [anon_sym_do] = ACTIONS(311),
    [anon_sym_while] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(311),
    [anon_sym_continue] = ACTIONS(311),
    [anon_sym_return] = ACTIONS(311),
    [anon_sym_yield] = ACTIONS(311),
    [anon_sym_synchronized] = ACTIONS(311),
    [anon_sym_throw] = ACTIONS(311),
    [anon_sym_try] = ACTIONS(311),
    [anon_sym_catch] = ACTIONS(289),
    [anon_sym_finally] = ACTIONS(291),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_else] = ACTIONS(311),
    [anon_sym_for] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_static] = ACTIONS(311),
    [anon_sym_package] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(311),
    [anon_sym_enum] = ACTIONS(311),
    [anon_sym_public] = ACTIONS(311),
    [anon_sym_protected] = ACTIONS(311),
    [anon_sym_private] = ACTIONS(311),
    [anon_sym_abstract] = ACTIONS(311),
    [anon_sym_final] = ACTIONS(311),
    [anon_sym_strictfp] = ACTIONS(311),
    [anon_sym_native] = ACTIONS(311),
    [anon_sym_transient] = ACTIONS(311),
    [anon_sym_volatile] = ACTIONS(311),
    [anon_sym_ATinterface] = ACTIONS(309),
    [anon_sym_interface] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(311),
    [anon_sym_short] = ACTIONS(311),
    [anon_sym_int] = ACTIONS(311),
    [anon_sym_long] = ACTIONS(311),
    [anon_sym_char] = ACTIONS(311),
    [anon_sym_float] = ACTIONS(311),
    [anon_sym_double] = ACTIONS(311),
    [sym_boolean_type] = ACTIONS(311),
    [sym_void_type] = ACTIONS(311),
    [sym_this] = ACTIONS(311),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(924),
    [sym_element_value_array_initializer] = STATE(924),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_RBRACE] = ACTIONS(313),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(470),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym_array_initializer] = STATE(843),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(315),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_catch_clause] = STATE(66),
    [aux_sym_try_statement_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(321),
    [sym_identifier] = ACTIONS(323),
    [sym_decimal_integer_literal] = ACTIONS(323),
    [sym_hex_integer_literal] = ACTIONS(323),
    [sym_octal_integer_literal] = ACTIONS(321),
    [sym_binary_integer_literal] = ACTIONS(321),
    [sym_decimal_floating_point_literal] = ACTIONS(321),
    [sym_hex_floating_point_literal] = ACTIONS(323),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_character_literal] = ACTIONS(321),
    [sym_string_literal] = ACTIONS(321),
    [sym_null_literal] = ACTIONS(323),
    [anon_sym_LPAREN] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_BANG] = ACTIONS(321),
    [anon_sym_TILDE] = ACTIONS(321),
    [anon_sym_PLUS_PLUS] = ACTIONS(321),
    [anon_sym_DASH_DASH] = ACTIONS(321),
    [anon_sym_new] = ACTIONS(323),
    [anon_sym_class] = ACTIONS(323),
    [anon_sym_switch] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(321),
    [anon_sym_case] = ACTIONS(323),
    [anon_sym_default] = ACTIONS(323),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_assert] = ACTIONS(323),
    [anon_sym_do] = ACTIONS(323),
    [anon_sym_while] = ACTIONS(323),
    [anon_sym_break] = ACTIONS(323),
    [anon_sym_continue] = ACTIONS(323),
    [anon_sym_return] = ACTIONS(323),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_synchronized] = ACTIONS(323),
    [anon_sym_throw] = ACTIONS(323),
    [anon_sym_try] = ACTIONS(323),
    [anon_sym_catch] = ACTIONS(325),
    [anon_sym_finally] = ACTIONS(323),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_else] = ACTIONS(323),
    [anon_sym_for] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(323),
    [anon_sym_open] = ACTIONS(323),
    [anon_sym_module] = ACTIONS(323),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_package] = ACTIONS(323),
    [anon_sym_import] = ACTIONS(323),
    [anon_sym_enum] = ACTIONS(323),
    [anon_sym_public] = ACTIONS(323),
    [anon_sym_protected] = ACTIONS(323),
    [anon_sym_private] = ACTIONS(323),
    [anon_sym_abstract] = ACTIONS(323),
    [anon_sym_final] = ACTIONS(323),
    [anon_sym_strictfp] = ACTIONS(323),
    [anon_sym_native] = ACTIONS(323),
    [anon_sym_transient] = ACTIONS(323),
    [anon_sym_volatile] = ACTIONS(323),
    [anon_sym_ATinterface] = ACTIONS(321),
    [anon_sym_interface] = ACTIONS(323),
    [anon_sym_byte] = ACTIONS(323),
    [anon_sym_short] = ACTIONS(323),
    [anon_sym_int] = ACTIONS(323),
    [anon_sym_long] = ACTIONS(323),
    [anon_sym_char] = ACTIONS(323),
    [anon_sym_float] = ACTIONS(323),
    [anon_sym_double] = ACTIONS(323),
    [sym_boolean_type] = ACTIONS(323),
    [sym_void_type] = ACTIONS(323),
    [sym_this] = ACTIONS(323),
    [sym_super] = ACTIONS(323),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(924),
    [sym_element_value_array_initializer] = STATE(924),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(490),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(911),
    [sym_element_value_array_initializer] = STATE(911),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(487),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym_array_initializer] = STATE(917),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_RBRACE] = ACTIONS(330),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(911),
    [sym_element_value_array_initializer] = STATE(911),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(924),
    [sym_element_value_array_initializer] = STATE(924),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(487),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym_array_initializer] = STATE(917),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_RBRACE] = ACTIONS(332),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(451),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(575),
    [sym_marker_annotation] = STATE(575),
    [sym_annotation] = STATE(575),
    [sym__element_value] = STATE(994),
    [sym_element_value_array_initializer] = STATE(994),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(334),
    [sym_identifier] = ACTIONS(336),
    [sym_decimal_integer_literal] = ACTIONS(336),
    [sym_hex_integer_literal] = ACTIONS(336),
    [sym_octal_integer_literal] = ACTIONS(334),
    [sym_binary_integer_literal] = ACTIONS(334),
    [sym_decimal_floating_point_literal] = ACTIONS(334),
    [sym_hex_floating_point_literal] = ACTIONS(336),
    [sym_true] = ACTIONS(336),
    [sym_false] = ACTIONS(336),
    [sym_character_literal] = ACTIONS(334),
    [sym_string_literal] = ACTIONS(334),
    [sym_null_literal] = ACTIONS(336),
    [anon_sym_LPAREN] = ACTIONS(334),
    [anon_sym_LT] = ACTIONS(334),
    [anon_sym_PLUS] = ACTIONS(336),
    [anon_sym_DASH] = ACTIONS(336),
    [anon_sym_BANG] = ACTIONS(334),
    [anon_sym_TILDE] = ACTIONS(334),
    [anon_sym_PLUS_PLUS] = ACTIONS(334),
    [anon_sym_DASH_DASH] = ACTIONS(334),
    [anon_sym_new] = ACTIONS(336),
    [anon_sym_class] = ACTIONS(336),
    [anon_sym_switch] = ACTIONS(336),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_RBRACE] = ACTIONS(334),
    [anon_sym_case] = ACTIONS(336),
    [anon_sym_default] = ACTIONS(336),
    [anon_sym_SEMI] = ACTIONS(334),
    [anon_sym_assert] = ACTIONS(336),
    [anon_sym_do] = ACTIONS(336),
    [anon_sym_while] = ACTIONS(336),
    [anon_sym_break] = ACTIONS(336),
    [anon_sym_continue] = ACTIONS(336),
    [anon_sym_return] = ACTIONS(336),
    [anon_sym_yield] = ACTIONS(336),
    [anon_sym_synchronized] = ACTIONS(336),
    [anon_sym_throw] = ACTIONS(336),
    [anon_sym_try] = ACTIONS(336),
    [anon_sym_if] = ACTIONS(336),
    [anon_sym_else] = ACTIONS(336),
    [anon_sym_for] = ACTIONS(336),
    [anon_sym_AT] = ACTIONS(336),
    [anon_sym_open] = ACTIONS(336),
    [anon_sym_module] = ACTIONS(336),
    [anon_sym_static] = ACTIONS(336),
    [anon_sym_package] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(336),
    [anon_sym_enum] = ACTIONS(336),
    [anon_sym_public] = ACTIONS(336),
    [anon_sym_protected] = ACTIONS(336),
    [anon_sym_private] = ACTIONS(336),
    [anon_sym_abstract] = ACTIONS(336),
    [anon_sym_final] = ACTIONS(336),
    [anon_sym_strictfp] = ACTIONS(336),
    [anon_sym_native] = ACTIONS(336),
    [anon_sym_transient] = ACTIONS(336),
    [anon_sym_volatile] = ACTIONS(336),
    [anon_sym_record] = ACTIONS(336),
    [anon_sym_ATinterface] = ACTIONS(334),
    [anon_sym_interface] = ACTIONS(336),
    [anon_sym_byte] = ACTIONS(336),
    [anon_sym_short] = ACTIONS(336),
    [anon_sym_int] = ACTIONS(336),
    [anon_sym_long] = ACTIONS(336),
    [anon_sym_char] = ACTIONS(336),
    [anon_sym_float] = ACTIONS(336),
    [anon_sym_double] = ACTIONS(336),
    [sym_boolean_type] = ACTIONS(336),
    [sym_void_type] = ACTIONS(336),
    [sym_this] = ACTIONS(336),
    [sym_super] = ACTIONS(336),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(432),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym_block] = STATE(411),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(338),
    [sym_identifier] = ACTIONS(340),
    [sym_decimal_integer_literal] = ACTIONS(340),
    [sym_hex_integer_literal] = ACTIONS(340),
    [sym_octal_integer_literal] = ACTIONS(338),
    [sym_binary_integer_literal] = ACTIONS(338),
    [sym_decimal_floating_point_literal] = ACTIONS(338),
    [sym_hex_floating_point_literal] = ACTIONS(340),
    [sym_true] = ACTIONS(340),
    [sym_false] = ACTIONS(340),
    [sym_character_literal] = ACTIONS(338),
    [sym_string_literal] = ACTIONS(338),
    [sym_null_literal] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_LT] = ACTIONS(338),
    [anon_sym_PLUS] = ACTIONS(340),
    [anon_sym_DASH] = ACTIONS(340),
    [anon_sym_BANG] = ACTIONS(338),
    [anon_sym_TILDE] = ACTIONS(338),
    [anon_sym_PLUS_PLUS] = ACTIONS(338),
    [anon_sym_DASH_DASH] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(340),
    [anon_sym_class] = ACTIONS(340),
    [anon_sym_switch] = ACTIONS(340),
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_case] = ACTIONS(340),
    [anon_sym_default] = ACTIONS(340),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_assert] = ACTIONS(340),
    [anon_sym_do] = ACTIONS(340),
    [anon_sym_while] = ACTIONS(340),
    [anon_sym_break] = ACTIONS(340),
    [anon_sym_continue] = ACTIONS(340),
    [anon_sym_return] = ACTIONS(340),
    [anon_sym_yield] = ACTIONS(340),
    [anon_sym_synchronized] = ACTIONS(340),
    [anon_sym_throw] = ACTIONS(340),
    [anon_sym_try] = ACTIONS(340),
    [anon_sym_if] = ACTIONS(340),
    [anon_sym_else] = ACTIONS(340),
    [anon_sym_for] = ACTIONS(340),
    [anon_sym_AT] = ACTIONS(340),
    [anon_sym_open] = ACTIONS(340),
    [anon_sym_module] = ACTIONS(340),
    [anon_sym_static] = ACTIONS(340),
    [anon_sym_package] = ACTIONS(340),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_enum] = ACTIONS(340),
    [anon_sym_public] = ACTIONS(340),
    [anon_sym_protected] = ACTIONS(340),
    [anon_sym_private] = ACTIONS(340),
    [anon_sym_abstract] = ACTIONS(340),
    [anon_sym_final] = ACTIONS(340),
    [anon_sym_strictfp] = ACTIONS(340),
    [anon_sym_native] = ACTIONS(340),
    [anon_sym_transient] = ACTIONS(340),
    [anon_sym_volatile] = ACTIONS(340),
    [anon_sym_record] = ACTIONS(340),
    [anon_sym_ATinterface] = ACTIONS(338),
    [anon_sym_interface] = ACTIONS(340),
    [anon_sym_byte] = ACTIONS(340),
    [anon_sym_short] = ACTIONS(340),
    [anon_sym_int] = ACTIONS(340),
    [anon_sym_long] = ACTIONS(340),
    [anon_sym_char] = ACTIONS(340),
    [anon_sym_float] = ACTIONS(340),
    [anon_sym_double] = ACTIONS(340),
    [sym_boolean_type] = ACTIONS(340),
    [sym_void_type] = ACTIONS(340),
    [sym_this] = ACTIONS(340),
    [sym_super] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(342),
    [sym_identifier] = ACTIONS(344),
    [sym_decimal_integer_literal] = ACTIONS(344),
    [sym_hex_integer_literal] = ACTIONS(344),
    [sym_octal_integer_literal] = ACTIONS(342),
    [sym_binary_integer_literal] = ACTIONS(342),
    [sym_decimal_floating_point_literal] = ACTIONS(342),
    [sym_hex_floating_point_literal] = ACTIONS(344),
    [sym_true] = ACTIONS(344),
    [sym_false] = ACTIONS(344),
    [sym_character_literal] = ACTIONS(342),
    [sym_string_literal] = ACTIONS(342),
    [sym_null_literal] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_LT] = ACTIONS(342),
    [anon_sym_PLUS] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(344),
    [anon_sym_BANG] = ACTIONS(342),
    [anon_sym_TILDE] = ACTIONS(342),
    [anon_sym_PLUS_PLUS] = ACTIONS(342),
    [anon_sym_DASH_DASH] = ACTIONS(342),
    [anon_sym_new] = ACTIONS(344),
    [anon_sym_class] = ACTIONS(344),
    [anon_sym_switch] = ACTIONS(344),
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_RBRACE] = ACTIONS(342),
    [anon_sym_case] = ACTIONS(344),
    [anon_sym_default] = ACTIONS(344),
    [anon_sym_SEMI] = ACTIONS(342),
    [anon_sym_assert] = ACTIONS(344),
    [anon_sym_do] = ACTIONS(344),
    [anon_sym_while] = ACTIONS(344),
    [anon_sym_break] = ACTIONS(344),
    [anon_sym_continue] = ACTIONS(344),
    [anon_sym_return] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(344),
    [anon_sym_synchronized] = ACTIONS(344),
    [anon_sym_throw] = ACTIONS(344),
    [anon_sym_try] = ACTIONS(344),
    [anon_sym_if] = ACTIONS(344),
    [anon_sym_else] = ACTIONS(344),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_AT] = ACTIONS(344),
    [anon_sym_open] = ACTIONS(344),
    [anon_sym_module] = ACTIONS(344),
    [anon_sym_static] = ACTIONS(344),
    [anon_sym_package] = ACTIONS(344),
    [anon_sym_import] = ACTIONS(344),
    [anon_sym_enum] = ACTIONS(344),
    [anon_sym_public] = ACTIONS(344),
    [anon_sym_protected] = ACTIONS(344),
    [anon_sym_private] = ACTIONS(344),
    [anon_sym_abstract] = ACTIONS(344),
    [anon_sym_final] = ACTIONS(344),
    [anon_sym_strictfp] = ACTIONS(344),
    [anon_sym_native] = ACTIONS(344),
    [anon_sym_transient] = ACTIONS(344),
    [anon_sym_volatile] = ACTIONS(344),
    [anon_sym_record] = ACTIONS(344),
    [anon_sym_ATinterface] = ACTIONS(342),
    [anon_sym_interface] = ACTIONS(344),
    [anon_sym_byte] = ACTIONS(344),
    [anon_sym_short] = ACTIONS(344),
    [anon_sym_int] = ACTIONS(344),
    [anon_sym_long] = ACTIONS(344),
    [anon_sym_char] = ACTIONS(344),
    [anon_sym_float] = ACTIONS(344),
    [anon_sym_double] = ACTIONS(344),
    [sym_boolean_type] = ACTIONS(344),
    [sym_void_type] = ACTIONS(344),
    [sym_this] = ACTIONS(344),
    [sym_super] = ACTIONS(344),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [78] = {
    [ts_builtin_sym_end] = ACTIONS(346),
    [sym_identifier] = ACTIONS(348),
    [sym_decimal_integer_literal] = ACTIONS(348),
    [sym_hex_integer_literal] = ACTIONS(348),
    [sym_octal_integer_literal] = ACTIONS(346),
    [sym_binary_integer_literal] = ACTIONS(346),
    [sym_decimal_floating_point_literal] = ACTIONS(346),
    [sym_hex_floating_point_literal] = ACTIONS(348),
    [sym_true] = ACTIONS(348),
    [sym_false] = ACTIONS(348),
    [sym_character_literal] = ACTIONS(346),
    [sym_string_literal] = ACTIONS(346),
    [sym_null_literal] = ACTIONS(348),
    [anon_sym_LPAREN] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(348),
    [anon_sym_DASH] = ACTIONS(348),
    [anon_sym_BANG] = ACTIONS(346),
    [anon_sym_TILDE] = ACTIONS(346),
    [anon_sym_PLUS_PLUS] = ACTIONS(346),
    [anon_sym_DASH_DASH] = ACTIONS(346),
    [anon_sym_new] = ACTIONS(348),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_switch] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(346),
    [anon_sym_RBRACE] = ACTIONS(346),
    [anon_sym_case] = ACTIONS(348),
    [anon_sym_default] = ACTIONS(348),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_assert] = ACTIONS(348),
    [anon_sym_do] = ACTIONS(348),
    [anon_sym_while] = ACTIONS(348),
    [anon_sym_break] = ACTIONS(348),
    [anon_sym_continue] = ACTIONS(348),
    [anon_sym_return] = ACTIONS(348),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_synchronized] = ACTIONS(348),
    [anon_sym_throw] = ACTIONS(348),
    [anon_sym_try] = ACTIONS(348),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_else] = ACTIONS(348),
    [anon_sym_for] = ACTIONS(348),
    [anon_sym_AT] = ACTIONS(348),
    [anon_sym_open] = ACTIONS(348),
    [anon_sym_module] = ACTIONS(348),
    [anon_sym_static] = ACTIONS(348),
    [anon_sym_package] = ACTIONS(348),
    [anon_sym_import] = ACTIONS(348),
    [anon_sym_enum] = ACTIONS(348),
    [anon_sym_public] = ACTIONS(348),
    [anon_sym_protected] = ACTIONS(348),
    [anon_sym_private] = ACTIONS(348),
    [anon_sym_abstract] = ACTIONS(348),
    [anon_sym_final] = ACTIONS(348),
    [anon_sym_strictfp] = ACTIONS(348),
    [anon_sym_native] = ACTIONS(348),
    [anon_sym_transient] = ACTIONS(348),
    [anon_sym_volatile] = ACTIONS(348),
    [anon_sym_record] = ACTIONS(348),
    [anon_sym_ATinterface] = ACTIONS(346),
    [anon_sym_interface] = ACTIONS(348),
    [anon_sym_byte] = ACTIONS(348),
    [anon_sym_short] = ACTIONS(348),
    [anon_sym_int] = ACTIONS(348),
    [anon_sym_long] = ACTIONS(348),
    [anon_sym_char] = ACTIONS(348),
    [anon_sym_float] = ACTIONS(348),
    [anon_sym_double] = ACTIONS(348),
    [sym_boolean_type] = ACTIONS(348),
    [sym_void_type] = ACTIONS(348),
    [sym_this] = ACTIONS(348),
    [sym_super] = ACTIONS(348),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(350),
    [sym_identifier] = ACTIONS(352),
    [sym_decimal_integer_literal] = ACTIONS(352),
    [sym_hex_integer_literal] = ACTIONS(352),
    [sym_octal_integer_literal] = ACTIONS(350),
    [sym_binary_integer_literal] = ACTIONS(350),
    [sym_decimal_floating_point_literal] = ACTIONS(350),
    [sym_hex_floating_point_literal] = ACTIONS(352),
    [sym_true] = ACTIONS(352),
    [sym_false] = ACTIONS(352),
    [sym_character_literal] = ACTIONS(350),
    [sym_string_literal] = ACTIONS(350),
    [sym_null_literal] = ACTIONS(352),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_LT] = ACTIONS(350),
    [anon_sym_PLUS] = ACTIONS(352),
    [anon_sym_DASH] = ACTIONS(352),
    [anon_sym_BANG] = ACTIONS(350),
    [anon_sym_TILDE] = ACTIONS(350),
    [anon_sym_PLUS_PLUS] = ACTIONS(350),
    [anon_sym_DASH_DASH] = ACTIONS(350),
    [anon_sym_new] = ACTIONS(352),
    [anon_sym_class] = ACTIONS(352),
    [anon_sym_switch] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_case] = ACTIONS(352),
    [anon_sym_default] = ACTIONS(352),
    [anon_sym_SEMI] = ACTIONS(350),
    [anon_sym_assert] = ACTIONS(352),
    [anon_sym_do] = ACTIONS(352),
    [anon_sym_while] = ACTIONS(352),
    [anon_sym_break] = ACTIONS(352),
    [anon_sym_continue] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(352),
    [anon_sym_yield] = ACTIONS(352),
    [anon_sym_synchronized] = ACTIONS(352),
    [anon_sym_throw] = ACTIONS(352),
    [anon_sym_try] = ACTIONS(352),
    [anon_sym_if] = ACTIONS(352),
    [anon_sym_else] = ACTIONS(352),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(352),
    [anon_sym_open] = ACTIONS(352),
    [anon_sym_module] = ACTIONS(352),
    [anon_sym_static] = ACTIONS(352),
    [anon_sym_package] = ACTIONS(352),
    [anon_sym_import] = ACTIONS(352),
    [anon_sym_enum] = ACTIONS(352),
    [anon_sym_public] = ACTIONS(352),
    [anon_sym_protected] = ACTIONS(352),
    [anon_sym_private] = ACTIONS(352),
    [anon_sym_abstract] = ACTIONS(352),
    [anon_sym_final] = ACTIONS(352),
    [anon_sym_strictfp] = ACTIONS(352),
    [anon_sym_native] = ACTIONS(352),
    [anon_sym_transient] = ACTIONS(352),
    [anon_sym_volatile] = ACTIONS(352),
    [anon_sym_record] = ACTIONS(352),
    [anon_sym_ATinterface] = ACTIONS(350),
    [anon_sym_interface] = ACTIONS(352),
    [anon_sym_byte] = ACTIONS(352),
    [anon_sym_short] = ACTIONS(352),
    [anon_sym_int] = ACTIONS(352),
    [anon_sym_long] = ACTIONS(352),
    [anon_sym_char] = ACTIONS(352),
    [anon_sym_float] = ACTIONS(352),
    [anon_sym_double] = ACTIONS(352),
    [sym_boolean_type] = ACTIONS(352),
    [sym_void_type] = ACTIONS(352),
    [sym_this] = ACTIONS(352),
    [sym_super] = ACTIONS(352),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [80] = {
    [ts_builtin_sym_end] = ACTIONS(354),
    [sym_identifier] = ACTIONS(356),
    [sym_decimal_integer_literal] = ACTIONS(356),
    [sym_hex_integer_literal] = ACTIONS(356),
    [sym_octal_integer_literal] = ACTIONS(354),
    [sym_binary_integer_literal] = ACTIONS(354),
    [sym_decimal_floating_point_literal] = ACTIONS(354),
    [sym_hex_floating_point_literal] = ACTIONS(356),
    [sym_true] = ACTIONS(356),
    [sym_false] = ACTIONS(356),
    [sym_character_literal] = ACTIONS(354),
    [sym_string_literal] = ACTIONS(354),
    [sym_null_literal] = ACTIONS(356),
    [anon_sym_LPAREN] = ACTIONS(354),
    [anon_sym_LT] = ACTIONS(354),
    [anon_sym_PLUS] = ACTIONS(356),
    [anon_sym_DASH] = ACTIONS(356),
    [anon_sym_BANG] = ACTIONS(354),
    [anon_sym_TILDE] = ACTIONS(354),
    [anon_sym_PLUS_PLUS] = ACTIONS(354),
    [anon_sym_DASH_DASH] = ACTIONS(354),
    [anon_sym_new] = ACTIONS(356),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_switch] = ACTIONS(356),
    [anon_sym_LBRACE] = ACTIONS(354),
    [anon_sym_RBRACE] = ACTIONS(354),
    [anon_sym_case] = ACTIONS(356),
    [anon_sym_default] = ACTIONS(356),
    [anon_sym_SEMI] = ACTIONS(354),
    [anon_sym_assert] = ACTIONS(356),
    [anon_sym_do] = ACTIONS(356),
    [anon_sym_while] = ACTIONS(356),
    [anon_sym_break] = ACTIONS(356),
    [anon_sym_continue] = ACTIONS(356),
    [anon_sym_return] = ACTIONS(356),
    [anon_sym_yield] = ACTIONS(356),
    [anon_sym_synchronized] = ACTIONS(356),
    [anon_sym_throw] = ACTIONS(356),
    [anon_sym_try] = ACTIONS(356),
    [anon_sym_if] = ACTIONS(356),
    [anon_sym_else] = ACTIONS(356),
    [anon_sym_for] = ACTIONS(356),
    [anon_sym_AT] = ACTIONS(356),
    [anon_sym_open] = ACTIONS(356),
    [anon_sym_module] = ACTIONS(356),
    [anon_sym_static] = ACTIONS(356),
    [anon_sym_package] = ACTIONS(356),
    [anon_sym_import] = ACTIONS(356),
    [anon_sym_enum] = ACTIONS(356),
    [anon_sym_public] = ACTIONS(356),
    [anon_sym_protected] = ACTIONS(356),
    [anon_sym_private] = ACTIONS(356),
    [anon_sym_abstract] = ACTIONS(356),
    [anon_sym_final] = ACTIONS(356),
    [anon_sym_strictfp] = ACTIONS(356),
    [anon_sym_native] = ACTIONS(356),
    [anon_sym_transient] = ACTIONS(356),
    [anon_sym_volatile] = ACTIONS(356),
    [anon_sym_record] = ACTIONS(356),
    [anon_sym_ATinterface] = ACTIONS(354),
    [anon_sym_interface] = ACTIONS(356),
    [anon_sym_byte] = ACTIONS(356),
    [anon_sym_short] = ACTIONS(356),
    [anon_sym_int] = ACTIONS(356),
    [anon_sym_long] = ACTIONS(356),
    [anon_sym_char] = ACTIONS(356),
    [anon_sym_float] = ACTIONS(356),
    [anon_sym_double] = ACTIONS(356),
    [sym_boolean_type] = ACTIONS(356),
    [sym_void_type] = ACTIONS(356),
    [sym_this] = ACTIONS(356),
    [sym_super] = ACTIONS(356),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(358),
    [sym_identifier] = ACTIONS(360),
    [sym_decimal_integer_literal] = ACTIONS(360),
    [sym_hex_integer_literal] = ACTIONS(360),
    [sym_octal_integer_literal] = ACTIONS(358),
    [sym_binary_integer_literal] = ACTIONS(358),
    [sym_decimal_floating_point_literal] = ACTIONS(358),
    [sym_hex_floating_point_literal] = ACTIONS(360),
    [sym_true] = ACTIONS(360),
    [sym_false] = ACTIONS(360),
    [sym_character_literal] = ACTIONS(358),
    [sym_string_literal] = ACTIONS(358),
    [sym_null_literal] = ACTIONS(360),
    [anon_sym_LPAREN] = ACTIONS(358),
    [anon_sym_LT] = ACTIONS(358),
    [anon_sym_PLUS] = ACTIONS(360),
    [anon_sym_DASH] = ACTIONS(360),
    [anon_sym_BANG] = ACTIONS(358),
    [anon_sym_TILDE] = ACTIONS(358),
    [anon_sym_PLUS_PLUS] = ACTIONS(358),
    [anon_sym_DASH_DASH] = ACTIONS(358),
    [anon_sym_new] = ACTIONS(360),
    [anon_sym_class] = ACTIONS(360),
    [anon_sym_switch] = ACTIONS(360),
    [anon_sym_LBRACE] = ACTIONS(358),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_case] = ACTIONS(360),
    [anon_sym_default] = ACTIONS(360),
    [anon_sym_SEMI] = ACTIONS(358),
    [anon_sym_assert] = ACTIONS(360),
    [anon_sym_do] = ACTIONS(360),
    [anon_sym_while] = ACTIONS(360),
    [anon_sym_break] = ACTIONS(360),
    [anon_sym_continue] = ACTIONS(360),
    [anon_sym_return] = ACTIONS(360),
    [anon_sym_yield] = ACTIONS(360),
    [anon_sym_synchronized] = ACTIONS(360),
    [anon_sym_throw] = ACTIONS(360),
    [anon_sym_try] = ACTIONS(360),
    [anon_sym_if] = ACTIONS(360),
    [anon_sym_else] = ACTIONS(360),
    [anon_sym_for] = ACTIONS(360),
    [anon_sym_AT] = ACTIONS(360),
    [anon_sym_open] = ACTIONS(360),
    [anon_sym_module] = ACTIONS(360),
    [anon_sym_static] = ACTIONS(360),
    [anon_sym_package] = ACTIONS(360),
    [anon_sym_import] = ACTIONS(360),
    [anon_sym_enum] = ACTIONS(360),
    [anon_sym_public] = ACTIONS(360),
    [anon_sym_protected] = ACTIONS(360),
    [anon_sym_private] = ACTIONS(360),
    [anon_sym_abstract] = ACTIONS(360),
    [anon_sym_final] = ACTIONS(360),
    [anon_sym_strictfp] = ACTIONS(360),
    [anon_sym_native] = ACTIONS(360),
    [anon_sym_transient] = ACTIONS(360),
    [anon_sym_volatile] = ACTIONS(360),
    [anon_sym_record] = ACTIONS(360),
    [anon_sym_ATinterface] = ACTIONS(358),
    [anon_sym_interface] = ACTIONS(360),
    [anon_sym_byte] = ACTIONS(360),
    [anon_sym_short] = ACTIONS(360),
    [anon_sym_int] = ACTIONS(360),
    [anon_sym_long] = ACTIONS(360),
    [anon_sym_char] = ACTIONS(360),
    [anon_sym_float] = ACTIONS(360),
    [anon_sym_double] = ACTIONS(360),
    [sym_boolean_type] = ACTIONS(360),
    [sym_void_type] = ACTIONS(360),
    [sym_this] = ACTIONS(360),
    [sym_super] = ACTIONS(360),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(362),
    [sym_identifier] = ACTIONS(364),
    [sym_decimal_integer_literal] = ACTIONS(364),
    [sym_hex_integer_literal] = ACTIONS(364),
    [sym_octal_integer_literal] = ACTIONS(362),
    [sym_binary_integer_literal] = ACTIONS(362),
    [sym_decimal_floating_point_literal] = ACTIONS(362),
    [sym_hex_floating_point_literal] = ACTIONS(364),
    [sym_true] = ACTIONS(364),
    [sym_false] = ACTIONS(364),
    [sym_character_literal] = ACTIONS(362),
    [sym_string_literal] = ACTIONS(362),
    [sym_null_literal] = ACTIONS(364),
    [anon_sym_LPAREN] = ACTIONS(362),
    [anon_sym_LT] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(362),
    [anon_sym_TILDE] = ACTIONS(362),
    [anon_sym_PLUS_PLUS] = ACTIONS(362),
    [anon_sym_DASH_DASH] = ACTIONS(362),
    [anon_sym_new] = ACTIONS(364),
    [anon_sym_class] = ACTIONS(364),
    [anon_sym_switch] = ACTIONS(364),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(362),
    [anon_sym_case] = ACTIONS(364),
    [anon_sym_default] = ACTIONS(364),
    [anon_sym_SEMI] = ACTIONS(362),
    [anon_sym_assert] = ACTIONS(364),
    [anon_sym_do] = ACTIONS(364),
    [anon_sym_while] = ACTIONS(364),
    [anon_sym_break] = ACTIONS(364),
    [anon_sym_continue] = ACTIONS(364),
    [anon_sym_return] = ACTIONS(364),
    [anon_sym_yield] = ACTIONS(364),
    [anon_sym_synchronized] = ACTIONS(364),
    [anon_sym_throw] = ACTIONS(364),
    [anon_sym_try] = ACTIONS(364),
    [anon_sym_if] = ACTIONS(364),
    [anon_sym_else] = ACTIONS(364),
    [anon_sym_for] = ACTIONS(364),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_open] = ACTIONS(364),
    [anon_sym_module] = ACTIONS(364),
    [anon_sym_static] = ACTIONS(364),
    [anon_sym_package] = ACTIONS(364),
    [anon_sym_import] = ACTIONS(364),
    [anon_sym_enum] = ACTIONS(364),
    [anon_sym_public] = ACTIONS(364),
    [anon_sym_protected] = ACTIONS(364),
    [anon_sym_private] = ACTIONS(364),
    [anon_sym_abstract] = ACTIONS(364),
    [anon_sym_final] = ACTIONS(364),
    [anon_sym_strictfp] = ACTIONS(364),
    [anon_sym_native] = ACTIONS(364),
    [anon_sym_transient] = ACTIONS(364),
    [anon_sym_volatile] = ACTIONS(364),
    [anon_sym_record] = ACTIONS(364),
    [anon_sym_ATinterface] = ACTIONS(362),
    [anon_sym_interface] = ACTIONS(364),
    [anon_sym_byte] = ACTIONS(364),
    [anon_sym_short] = ACTIONS(364),
    [anon_sym_int] = ACTIONS(364),
    [anon_sym_long] = ACTIONS(364),
    [anon_sym_char] = ACTIONS(364),
    [anon_sym_float] = ACTIONS(364),
    [anon_sym_double] = ACTIONS(364),
    [sym_boolean_type] = ACTIONS(364),
    [sym_void_type] = ACTIONS(364),
    [sym_this] = ACTIONS(364),
    [sym_super] = ACTIONS(364),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(366),
    [sym_identifier] = ACTIONS(368),
    [sym_decimal_integer_literal] = ACTIONS(368),
    [sym_hex_integer_literal] = ACTIONS(368),
    [sym_octal_integer_literal] = ACTIONS(366),
    [sym_binary_integer_literal] = ACTIONS(366),
    [sym_decimal_floating_point_literal] = ACTIONS(366),
    [sym_hex_floating_point_literal] = ACTIONS(368),
    [sym_true] = ACTIONS(368),
    [sym_false] = ACTIONS(368),
    [sym_character_literal] = ACTIONS(366),
    [sym_string_literal] = ACTIONS(366),
    [sym_null_literal] = ACTIONS(368),
    [anon_sym_LPAREN] = ACTIONS(366),
    [anon_sym_LT] = ACTIONS(366),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_PLUS_PLUS] = ACTIONS(366),
    [anon_sym_DASH_DASH] = ACTIONS(366),
    [anon_sym_new] = ACTIONS(368),
    [anon_sym_class] = ACTIONS(368),
    [anon_sym_switch] = ACTIONS(368),
    [anon_sym_LBRACE] = ACTIONS(366),
    [anon_sym_RBRACE] = ACTIONS(366),
    [anon_sym_case] = ACTIONS(368),
    [anon_sym_default] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(366),
    [anon_sym_assert] = ACTIONS(368),
    [anon_sym_do] = ACTIONS(368),
    [anon_sym_while] = ACTIONS(368),
    [anon_sym_break] = ACTIONS(368),
    [anon_sym_continue] = ACTIONS(368),
    [anon_sym_return] = ACTIONS(368),
    [anon_sym_yield] = ACTIONS(368),
    [anon_sym_synchronized] = ACTIONS(368),
    [anon_sym_throw] = ACTIONS(368),
    [anon_sym_try] = ACTIONS(368),
    [anon_sym_if] = ACTIONS(368),
    [anon_sym_else] = ACTIONS(368),
    [anon_sym_for] = ACTIONS(368),
    [anon_sym_AT] = ACTIONS(368),
    [anon_sym_open] = ACTIONS(368),
    [anon_sym_module] = ACTIONS(368),
    [anon_sym_static] = ACTIONS(368),
    [anon_sym_package] = ACTIONS(368),
    [anon_sym_import] = ACTIONS(368),
    [anon_sym_enum] = ACTIONS(368),
    [anon_sym_public] = ACTIONS(368),
    [anon_sym_protected] = ACTIONS(368),
    [anon_sym_private] = ACTIONS(368),
    [anon_sym_abstract] = ACTIONS(368),
    [anon_sym_final] = ACTIONS(368),
    [anon_sym_strictfp] = ACTIONS(368),
    [anon_sym_native] = ACTIONS(368),
    [anon_sym_transient] = ACTIONS(368),
    [anon_sym_volatile] = ACTIONS(368),
    [anon_sym_record] = ACTIONS(368),
    [anon_sym_ATinterface] = ACTIONS(366),
    [anon_sym_interface] = ACTIONS(368),
    [anon_sym_byte] = ACTIONS(368),
    [anon_sym_short] = ACTIONS(368),
    [anon_sym_int] = ACTIONS(368),
    [anon_sym_long] = ACTIONS(368),
    [anon_sym_char] = ACTIONS(368),
    [anon_sym_float] = ACTIONS(368),
    [anon_sym_double] = ACTIONS(368),
    [sym_boolean_type] = ACTIONS(368),
    [sym_void_type] = ACTIONS(368),
    [sym_this] = ACTIONS(368),
    [sym_super] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(370),
    [sym_identifier] = ACTIONS(372),
    [sym_decimal_integer_literal] = ACTIONS(372),
    [sym_hex_integer_literal] = ACTIONS(372),
    [sym_octal_integer_literal] = ACTIONS(370),
    [sym_binary_integer_literal] = ACTIONS(370),
    [sym_decimal_floating_point_literal] = ACTIONS(370),
    [sym_hex_floating_point_literal] = ACTIONS(372),
    [sym_true] = ACTIONS(372),
    [sym_false] = ACTIONS(372),
    [sym_character_literal] = ACTIONS(370),
    [sym_string_literal] = ACTIONS(370),
    [sym_null_literal] = ACTIONS(372),
    [anon_sym_LPAREN] = ACTIONS(370),
    [anon_sym_LT] = ACTIONS(370),
    [anon_sym_PLUS] = ACTIONS(372),
    [anon_sym_DASH] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(370),
    [anon_sym_PLUS_PLUS] = ACTIONS(370),
    [anon_sym_DASH_DASH] = ACTIONS(370),
    [anon_sym_new] = ACTIONS(372),
    [anon_sym_class] = ACTIONS(372),
    [anon_sym_switch] = ACTIONS(372),
    [anon_sym_LBRACE] = ACTIONS(370),
    [anon_sym_RBRACE] = ACTIONS(370),
    [anon_sym_case] = ACTIONS(372),
    [anon_sym_default] = ACTIONS(372),
    [anon_sym_SEMI] = ACTIONS(370),
    [anon_sym_assert] = ACTIONS(372),
    [anon_sym_do] = ACTIONS(372),
    [anon_sym_while] = ACTIONS(372),
    [anon_sym_break] = ACTIONS(372),
    [anon_sym_continue] = ACTIONS(372),
    [anon_sym_return] = ACTIONS(372),
    [anon_sym_yield] = ACTIONS(372),
    [anon_sym_synchronized] = ACTIONS(372),
    [anon_sym_throw] = ACTIONS(372),
    [anon_sym_try] = ACTIONS(372),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_else] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(372),
    [anon_sym_AT] = ACTIONS(372),
    [anon_sym_open] = ACTIONS(372),
    [anon_sym_module] = ACTIONS(372),
    [anon_sym_static] = ACTIONS(372),
    [anon_sym_package] = ACTIONS(372),
    [anon_sym_import] = ACTIONS(372),
    [anon_sym_enum] = ACTIONS(372),
    [anon_sym_public] = ACTIONS(372),
    [anon_sym_protected] = ACTIONS(372),
    [anon_sym_private] = ACTIONS(372),
    [anon_sym_abstract] = ACTIONS(372),
    [anon_sym_final] = ACTIONS(372),
    [anon_sym_strictfp] = ACTIONS(372),
    [anon_sym_native] = ACTIONS(372),
    [anon_sym_transient] = ACTIONS(372),
    [anon_sym_volatile] = ACTIONS(372),
    [anon_sym_record] = ACTIONS(372),
    [anon_sym_ATinterface] = ACTIONS(370),
    [anon_sym_interface] = ACTIONS(372),
    [anon_sym_byte] = ACTIONS(372),
    [anon_sym_short] = ACTIONS(372),
    [anon_sym_int] = ACTIONS(372),
    [anon_sym_long] = ACTIONS(372),
    [anon_sym_char] = ACTIONS(372),
    [anon_sym_float] = ACTIONS(372),
    [anon_sym_double] = ACTIONS(372),
    [sym_boolean_type] = ACTIONS(372),
    [sym_void_type] = ACTIONS(372),
    [sym_this] = ACTIONS(372),
    [sym_super] = ACTIONS(372),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(374),
    [sym_identifier] = ACTIONS(376),
    [sym_decimal_integer_literal] = ACTIONS(376),
    [sym_hex_integer_literal] = ACTIONS(376),
    [sym_octal_integer_literal] = ACTIONS(374),
    [sym_binary_integer_literal] = ACTIONS(374),
    [sym_decimal_floating_point_literal] = ACTIONS(374),
    [sym_hex_floating_point_literal] = ACTIONS(376),
    [sym_true] = ACTIONS(376),
    [sym_false] = ACTIONS(376),
    [sym_character_literal] = ACTIONS(374),
    [sym_string_literal] = ACTIONS(374),
    [sym_null_literal] = ACTIONS(376),
    [anon_sym_LPAREN] = ACTIONS(374),
    [anon_sym_PLUS] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(376),
    [anon_sym_BANG] = ACTIONS(374),
    [anon_sym_TILDE] = ACTIONS(374),
    [anon_sym_PLUS_PLUS] = ACTIONS(374),
    [anon_sym_DASH_DASH] = ACTIONS(374),
    [anon_sym_new] = ACTIONS(376),
    [anon_sym_class] = ACTIONS(376),
    [anon_sym_switch] = ACTIONS(376),
    [anon_sym_LBRACE] = ACTIONS(374),
    [anon_sym_RBRACE] = ACTIONS(374),
    [anon_sym_case] = ACTIONS(376),
    [anon_sym_default] = ACTIONS(376),
    [anon_sym_SEMI] = ACTIONS(374),
    [anon_sym_assert] = ACTIONS(376),
    [anon_sym_do] = ACTIONS(376),
    [anon_sym_while] = ACTIONS(376),
    [anon_sym_break] = ACTIONS(376),
    [anon_sym_continue] = ACTIONS(376),
    [anon_sym_return] = ACTIONS(376),
    [anon_sym_yield] = ACTIONS(376),
    [anon_sym_synchronized] = ACTIONS(376),
    [anon_sym_throw] = ACTIONS(376),
    [anon_sym_try] = ACTIONS(376),
    [anon_sym_catch] = ACTIONS(376),
    [anon_sym_finally] = ACTIONS(376),
    [anon_sym_if] = ACTIONS(376),
    [anon_sym_else] = ACTIONS(376),
    [anon_sym_for] = ACTIONS(376),
    [anon_sym_AT] = ACTIONS(376),
    [anon_sym_open] = ACTIONS(376),
    [anon_sym_module] = ACTIONS(376),
    [anon_sym_static] = ACTIONS(376),
    [anon_sym_package] = ACTIONS(376),
    [anon_sym_import] = ACTIONS(376),
    [anon_sym_enum] = ACTIONS(376),
    [anon_sym_public] = ACTIONS(376),
    [anon_sym_protected] = ACTIONS(376),
    [anon_sym_private] = ACTIONS(376),
    [anon_sym_abstract] = ACTIONS(376),
    [anon_sym_final] = ACTIONS(376),
    [anon_sym_strictfp] = ACTIONS(376),
    [anon_sym_native] = ACTIONS(376),
    [anon_sym_transient] = ACTIONS(376),
    [anon_sym_volatile] = ACTIONS(376),
    [anon_sym_ATinterface] = ACTIONS(374),
    [anon_sym_interface] = ACTIONS(376),
    [anon_sym_byte] = ACTIONS(376),
    [anon_sym_short] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_long] = ACTIONS(376),
    [anon_sym_char] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_double] = ACTIONS(376),
    [sym_boolean_type] = ACTIONS(376),
    [sym_void_type] = ACTIONS(376),
    [sym_this] = ACTIONS(376),
    [sym_super] = ACTIONS(376),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [86] = {
    [ts_builtin_sym_end] = ACTIONS(378),
    [sym_identifier] = ACTIONS(380),
    [sym_decimal_integer_literal] = ACTIONS(380),
    [sym_hex_integer_literal] = ACTIONS(380),
    [sym_octal_integer_literal] = ACTIONS(378),
    [sym_binary_integer_literal] = ACTIONS(378),
    [sym_decimal_floating_point_literal] = ACTIONS(378),
    [sym_hex_floating_point_literal] = ACTIONS(380),
    [sym_true] = ACTIONS(380),
    [sym_false] = ACTIONS(380),
    [sym_character_literal] = ACTIONS(378),
    [sym_string_literal] = ACTIONS(378),
    [sym_null_literal] = ACTIONS(380),
    [anon_sym_LPAREN] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(380),
    [anon_sym_DASH] = ACTIONS(380),
    [anon_sym_BANG] = ACTIONS(378),
    [anon_sym_TILDE] = ACTIONS(378),
    [anon_sym_PLUS_PLUS] = ACTIONS(378),
    [anon_sym_DASH_DASH] = ACTIONS(378),
    [anon_sym_new] = ACTIONS(380),
    [anon_sym_class] = ACTIONS(380),
    [anon_sym_switch] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(378),
    [anon_sym_RBRACE] = ACTIONS(378),
    [anon_sym_case] = ACTIONS(380),
    [anon_sym_default] = ACTIONS(380),
    [anon_sym_SEMI] = ACTIONS(378),
    [anon_sym_assert] = ACTIONS(380),
    [anon_sym_do] = ACTIONS(380),
    [anon_sym_while] = ACTIONS(380),
    [anon_sym_break] = ACTIONS(380),
    [anon_sym_continue] = ACTIONS(380),
    [anon_sym_return] = ACTIONS(380),
    [anon_sym_yield] = ACTIONS(380),
    [anon_sym_synchronized] = ACTIONS(380),
    [anon_sym_throw] = ACTIONS(380),
    [anon_sym_try] = ACTIONS(380),
    [anon_sym_if] = ACTIONS(380),
    [anon_sym_else] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(380),
    [anon_sym_open] = ACTIONS(380),
    [anon_sym_module] = ACTIONS(380),
    [anon_sym_static] = ACTIONS(380),
    [anon_sym_package] = ACTIONS(380),
    [anon_sym_import] = ACTIONS(380),
    [anon_sym_enum] = ACTIONS(380),
    [anon_sym_public] = ACTIONS(380),
    [anon_sym_protected] = ACTIONS(380),
    [anon_sym_private] = ACTIONS(380),
    [anon_sym_abstract] = ACTIONS(380),
    [anon_sym_final] = ACTIONS(380),
    [anon_sym_strictfp] = ACTIONS(380),
    [anon_sym_native] = ACTIONS(380),
    [anon_sym_transient] = ACTIONS(380),
    [anon_sym_volatile] = ACTIONS(380),
    [anon_sym_record] = ACTIONS(380),
    [anon_sym_ATinterface] = ACTIONS(378),
    [anon_sym_interface] = ACTIONS(380),
    [anon_sym_byte] = ACTIONS(380),
    [anon_sym_short] = ACTIONS(380),
    [anon_sym_int] = ACTIONS(380),
    [anon_sym_long] = ACTIONS(380),
    [anon_sym_char] = ACTIONS(380),
    [anon_sym_float] = ACTIONS(380),
    [anon_sym_double] = ACTIONS(380),
    [sym_boolean_type] = ACTIONS(380),
    [sym_void_type] = ACTIONS(380),
    [sym_this] = ACTIONS(380),
    [sym_super] = ACTIONS(380),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [87] = {
    [ts_builtin_sym_end] = ACTIONS(382),
    [sym_identifier] = ACTIONS(384),
    [sym_decimal_integer_literal] = ACTIONS(384),
    [sym_hex_integer_literal] = ACTIONS(384),
    [sym_octal_integer_literal] = ACTIONS(382),
    [sym_binary_integer_literal] = ACTIONS(382),
    [sym_decimal_floating_point_literal] = ACTIONS(382),
    [sym_hex_floating_point_literal] = ACTIONS(384),
    [sym_true] = ACTIONS(384),
    [sym_false] = ACTIONS(384),
    [sym_character_literal] = ACTIONS(382),
    [sym_string_literal] = ACTIONS(382),
    [sym_null_literal] = ACTIONS(384),
    [anon_sym_LPAREN] = ACTIONS(382),
    [anon_sym_LT] = ACTIONS(382),
    [anon_sym_PLUS] = ACTIONS(384),
    [anon_sym_DASH] = ACTIONS(384),
    [anon_sym_BANG] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(382),
    [anon_sym_PLUS_PLUS] = ACTIONS(382),
    [anon_sym_DASH_DASH] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(384),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_RBRACE] = ACTIONS(382),
    [anon_sym_case] = ACTIONS(384),
    [anon_sym_default] = ACTIONS(384),
    [anon_sym_SEMI] = ACTIONS(382),
    [anon_sym_assert] = ACTIONS(384),
    [anon_sym_do] = ACTIONS(384),
    [anon_sym_while] = ACTIONS(384),
    [anon_sym_break] = ACTIONS(384),
    [anon_sym_continue] = ACTIONS(384),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_yield] = ACTIONS(384),
    [anon_sym_synchronized] = ACTIONS(384),
    [anon_sym_throw] = ACTIONS(384),
    [anon_sym_try] = ACTIONS(384),
    [anon_sym_if] = ACTIONS(384),
    [anon_sym_else] = ACTIONS(384),
    [anon_sym_for] = ACTIONS(384),
    [anon_sym_AT] = ACTIONS(384),
    [anon_sym_open] = ACTIONS(384),
    [anon_sym_module] = ACTIONS(384),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_package] = ACTIONS(384),
    [anon_sym_import] = ACTIONS(384),
    [anon_sym_enum] = ACTIONS(384),
    [anon_sym_public] = ACTIONS(384),
    [anon_sym_protected] = ACTIONS(384),
    [anon_sym_private] = ACTIONS(384),
    [anon_sym_abstract] = ACTIONS(384),
    [anon_sym_final] = ACTIONS(384),
    [anon_sym_strictfp] = ACTIONS(384),
    [anon_sym_native] = ACTIONS(384),
    [anon_sym_transient] = ACTIONS(384),
    [anon_sym_volatile] = ACTIONS(384),
    [anon_sym_record] = ACTIONS(384),
    [anon_sym_ATinterface] = ACTIONS(382),
    [anon_sym_interface] = ACTIONS(384),
    [anon_sym_byte] = ACTIONS(384),
    [anon_sym_short] = ACTIONS(384),
    [anon_sym_int] = ACTIONS(384),
    [anon_sym_long] = ACTIONS(384),
    [anon_sym_char] = ACTIONS(384),
    [anon_sym_float] = ACTIONS(384),
    [anon_sym_double] = ACTIONS(384),
    [sym_boolean_type] = ACTIONS(384),
    [sym_void_type] = ACTIONS(384),
    [sym_this] = ACTIONS(384),
    [sym_super] = ACTIONS(384),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [88] = {
    [ts_builtin_sym_end] = ACTIONS(386),
    [sym_identifier] = ACTIONS(388),
    [sym_decimal_integer_literal] = ACTIONS(388),
    [sym_hex_integer_literal] = ACTIONS(388),
    [sym_octal_integer_literal] = ACTIONS(386),
    [sym_binary_integer_literal] = ACTIONS(386),
    [sym_decimal_floating_point_literal] = ACTIONS(386),
    [sym_hex_floating_point_literal] = ACTIONS(388),
    [sym_true] = ACTIONS(388),
    [sym_false] = ACTIONS(388),
    [sym_character_literal] = ACTIONS(386),
    [sym_string_literal] = ACTIONS(386),
    [sym_null_literal] = ACTIONS(388),
    [anon_sym_LPAREN] = ACTIONS(386),
    [anon_sym_LT] = ACTIONS(386),
    [anon_sym_PLUS] = ACTIONS(388),
    [anon_sym_DASH] = ACTIONS(388),
    [anon_sym_BANG] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(386),
    [anon_sym_PLUS_PLUS] = ACTIONS(386),
    [anon_sym_DASH_DASH] = ACTIONS(386),
    [anon_sym_new] = ACTIONS(388),
    [anon_sym_class] = ACTIONS(388),
    [anon_sym_switch] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(386),
    [anon_sym_RBRACE] = ACTIONS(386),
    [anon_sym_case] = ACTIONS(388),
    [anon_sym_default] = ACTIONS(388),
    [anon_sym_SEMI] = ACTIONS(386),
    [anon_sym_assert] = ACTIONS(388),
    [anon_sym_do] = ACTIONS(388),
    [anon_sym_while] = ACTIONS(388),
    [anon_sym_break] = ACTIONS(388),
    [anon_sym_continue] = ACTIONS(388),
    [anon_sym_return] = ACTIONS(388),
    [anon_sym_yield] = ACTIONS(388),
    [anon_sym_synchronized] = ACTIONS(388),
    [anon_sym_throw] = ACTIONS(388),
    [anon_sym_try] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(388),
    [anon_sym_else] = ACTIONS(388),
    [anon_sym_for] = ACTIONS(388),
    [anon_sym_AT] = ACTIONS(388),
    [anon_sym_open] = ACTIONS(388),
    [anon_sym_module] = ACTIONS(388),
    [anon_sym_static] = ACTIONS(388),
    [anon_sym_package] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(388),
    [anon_sym_enum] = ACTIONS(388),
    [anon_sym_public] = ACTIONS(388),
    [anon_sym_protected] = ACTIONS(388),
    [anon_sym_private] = ACTIONS(388),
    [anon_sym_abstract] = ACTIONS(388),
    [anon_sym_final] = ACTIONS(388),
    [anon_sym_strictfp] = ACTIONS(388),
    [anon_sym_native] = ACTIONS(388),
    [anon_sym_transient] = ACTIONS(388),
    [anon_sym_volatile] = ACTIONS(388),
    [anon_sym_record] = ACTIONS(388),
    [anon_sym_ATinterface] = ACTIONS(386),
    [anon_sym_interface] = ACTIONS(388),
    [anon_sym_byte] = ACTIONS(388),
    [anon_sym_short] = ACTIONS(388),
    [anon_sym_int] = ACTIONS(388),
    [anon_sym_long] = ACTIONS(388),
    [anon_sym_char] = ACTIONS(388),
    [anon_sym_float] = ACTIONS(388),
    [anon_sym_double] = ACTIONS(388),
    [sym_boolean_type] = ACTIONS(388),
    [sym_void_type] = ACTIONS(388),
    [sym_this] = ACTIONS(388),
    [sym_super] = ACTIONS(388),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [89] = {
    [ts_builtin_sym_end] = ACTIONS(390),
    [sym_identifier] = ACTIONS(392),
    [sym_decimal_integer_literal] = ACTIONS(392),
    [sym_hex_integer_literal] = ACTIONS(392),
    [sym_octal_integer_literal] = ACTIONS(390),
    [sym_binary_integer_literal] = ACTIONS(390),
    [sym_decimal_floating_point_literal] = ACTIONS(390),
    [sym_hex_floating_point_literal] = ACTIONS(392),
    [sym_true] = ACTIONS(392),
    [sym_false] = ACTIONS(392),
    [sym_character_literal] = ACTIONS(390),
    [sym_string_literal] = ACTIONS(390),
    [sym_null_literal] = ACTIONS(392),
    [anon_sym_LPAREN] = ACTIONS(390),
    [anon_sym_LT] = ACTIONS(390),
    [anon_sym_PLUS] = ACTIONS(392),
    [anon_sym_DASH] = ACTIONS(392),
    [anon_sym_BANG] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(390),
    [anon_sym_PLUS_PLUS] = ACTIONS(390),
    [anon_sym_DASH_DASH] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_switch] = ACTIONS(392),
    [anon_sym_LBRACE] = ACTIONS(390),
    [anon_sym_RBRACE] = ACTIONS(390),
    [anon_sym_case] = ACTIONS(392),
    [anon_sym_default] = ACTIONS(392),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_assert] = ACTIONS(392),
    [anon_sym_do] = ACTIONS(392),
    [anon_sym_while] = ACTIONS(392),
    [anon_sym_break] = ACTIONS(392),
    [anon_sym_continue] = ACTIONS(392),
    [anon_sym_return] = ACTIONS(392),
    [anon_sym_yield] = ACTIONS(392),
    [anon_sym_synchronized] = ACTIONS(392),
    [anon_sym_throw] = ACTIONS(392),
    [anon_sym_try] = ACTIONS(392),
    [anon_sym_if] = ACTIONS(392),
    [anon_sym_else] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(392),
    [anon_sym_AT] = ACTIONS(392),
    [anon_sym_open] = ACTIONS(392),
    [anon_sym_module] = ACTIONS(392),
    [anon_sym_static] = ACTIONS(392),
    [anon_sym_package] = ACTIONS(392),
    [anon_sym_import] = ACTIONS(392),
    [anon_sym_enum] = ACTIONS(392),
    [anon_sym_public] = ACTIONS(392),
    [anon_sym_protected] = ACTIONS(392),
    [anon_sym_private] = ACTIONS(392),
    [anon_sym_abstract] = ACTIONS(392),
    [anon_sym_final] = ACTIONS(392),
    [anon_sym_strictfp] = ACTIONS(392),
    [anon_sym_native] = ACTIONS(392),
    [anon_sym_transient] = ACTIONS(392),
    [anon_sym_volatile] = ACTIONS(392),
    [anon_sym_record] = ACTIONS(392),
    [anon_sym_ATinterface] = ACTIONS(390),
    [anon_sym_interface] = ACTIONS(392),
    [anon_sym_byte] = ACTIONS(392),
    [anon_sym_short] = ACTIONS(392),
    [anon_sym_int] = ACTIONS(392),
    [anon_sym_long] = ACTIONS(392),
    [anon_sym_char] = ACTIONS(392),
    [anon_sym_float] = ACTIONS(392),
    [anon_sym_double] = ACTIONS(392),
    [sym_boolean_type] = ACTIONS(392),
    [sym_void_type] = ACTIONS(392),
    [sym_this] = ACTIONS(392),
    [sym_super] = ACTIONS(392),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [90] = {
    [ts_builtin_sym_end] = ACTIONS(394),
    [sym_identifier] = ACTIONS(396),
    [sym_decimal_integer_literal] = ACTIONS(396),
    [sym_hex_integer_literal] = ACTIONS(396),
    [sym_octal_integer_literal] = ACTIONS(394),
    [sym_binary_integer_literal] = ACTIONS(394),
    [sym_decimal_floating_point_literal] = ACTIONS(394),
    [sym_hex_floating_point_literal] = ACTIONS(396),
    [sym_true] = ACTIONS(396),
    [sym_false] = ACTIONS(396),
    [sym_character_literal] = ACTIONS(394),
    [sym_string_literal] = ACTIONS(394),
    [sym_null_literal] = ACTIONS(396),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_LT] = ACTIONS(394),
    [anon_sym_PLUS] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(394),
    [anon_sym_DASH_DASH] = ACTIONS(394),
    [anon_sym_new] = ACTIONS(396),
    [anon_sym_class] = ACTIONS(396),
    [anon_sym_switch] = ACTIONS(396),
    [anon_sym_LBRACE] = ACTIONS(394),
    [anon_sym_RBRACE] = ACTIONS(394),
    [anon_sym_case] = ACTIONS(396),
    [anon_sym_default] = ACTIONS(396),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_assert] = ACTIONS(396),
    [anon_sym_do] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(396),
    [anon_sym_break] = ACTIONS(396),
    [anon_sym_continue] = ACTIONS(396),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_yield] = ACTIONS(396),
    [anon_sym_synchronized] = ACTIONS(396),
    [anon_sym_throw] = ACTIONS(396),
    [anon_sym_try] = ACTIONS(396),
    [anon_sym_if] = ACTIONS(396),
    [anon_sym_else] = ACTIONS(396),
    [anon_sym_for] = ACTIONS(396),
    [anon_sym_AT] = ACTIONS(396),
    [anon_sym_open] = ACTIONS(396),
    [anon_sym_module] = ACTIONS(396),
    [anon_sym_static] = ACTIONS(396),
    [anon_sym_package] = ACTIONS(396),
    [anon_sym_import] = ACTIONS(396),
    [anon_sym_enum] = ACTIONS(396),
    [anon_sym_public] = ACTIONS(396),
    [anon_sym_protected] = ACTIONS(396),
    [anon_sym_private] = ACTIONS(396),
    [anon_sym_abstract] = ACTIONS(396),
    [anon_sym_final] = ACTIONS(396),
    [anon_sym_strictfp] = ACTIONS(396),
    [anon_sym_native] = ACTIONS(396),
    [anon_sym_transient] = ACTIONS(396),
    [anon_sym_volatile] = ACTIONS(396),
    [anon_sym_record] = ACTIONS(396),
    [anon_sym_ATinterface] = ACTIONS(394),
    [anon_sym_interface] = ACTIONS(396),
    [anon_sym_byte] = ACTIONS(396),
    [anon_sym_short] = ACTIONS(396),
    [anon_sym_int] = ACTIONS(396),
    [anon_sym_long] = ACTIONS(396),
    [anon_sym_char] = ACTIONS(396),
    [anon_sym_float] = ACTIONS(396),
    [anon_sym_double] = ACTIONS(396),
    [sym_boolean_type] = ACTIONS(396),
    [sym_void_type] = ACTIONS(396),
    [sym_this] = ACTIONS(396),
    [sym_super] = ACTIONS(396),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [91] = {
    [ts_builtin_sym_end] = ACTIONS(398),
    [sym_identifier] = ACTIONS(400),
    [sym_decimal_integer_literal] = ACTIONS(400),
    [sym_hex_integer_literal] = ACTIONS(400),
    [sym_octal_integer_literal] = ACTIONS(398),
    [sym_binary_integer_literal] = ACTIONS(398),
    [sym_decimal_floating_point_literal] = ACTIONS(398),
    [sym_hex_floating_point_literal] = ACTIONS(400),
    [sym_true] = ACTIONS(400),
    [sym_false] = ACTIONS(400),
    [sym_character_literal] = ACTIONS(398),
    [sym_string_literal] = ACTIONS(398),
    [sym_null_literal] = ACTIONS(400),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(398),
    [anon_sym_PLUS] = ACTIONS(400),
    [anon_sym_DASH] = ACTIONS(400),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_PLUS_PLUS] = ACTIONS(398),
    [anon_sym_DASH_DASH] = ACTIONS(398),
    [anon_sym_new] = ACTIONS(400),
    [anon_sym_class] = ACTIONS(400),
    [anon_sym_switch] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(398),
    [anon_sym_case] = ACTIONS(400),
    [anon_sym_default] = ACTIONS(400),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_assert] = ACTIONS(400),
    [anon_sym_do] = ACTIONS(400),
    [anon_sym_while] = ACTIONS(400),
    [anon_sym_break] = ACTIONS(400),
    [anon_sym_continue] = ACTIONS(400),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_yield] = ACTIONS(400),
    [anon_sym_synchronized] = ACTIONS(400),
    [anon_sym_throw] = ACTIONS(400),
    [anon_sym_try] = ACTIONS(400),
    [anon_sym_if] = ACTIONS(400),
    [anon_sym_else] = ACTIONS(400),
    [anon_sym_for] = ACTIONS(400),
    [anon_sym_AT] = ACTIONS(400),
    [anon_sym_open] = ACTIONS(400),
    [anon_sym_module] = ACTIONS(400),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_package] = ACTIONS(400),
    [anon_sym_import] = ACTIONS(400),
    [anon_sym_enum] = ACTIONS(400),
    [anon_sym_public] = ACTIONS(400),
    [anon_sym_protected] = ACTIONS(400),
    [anon_sym_private] = ACTIONS(400),
    [anon_sym_abstract] = ACTIONS(400),
    [anon_sym_final] = ACTIONS(400),
    [anon_sym_strictfp] = ACTIONS(400),
    [anon_sym_native] = ACTIONS(400),
    [anon_sym_transient] = ACTIONS(400),
    [anon_sym_volatile] = ACTIONS(400),
    [anon_sym_record] = ACTIONS(400),
    [anon_sym_ATinterface] = ACTIONS(398),
    [anon_sym_interface] = ACTIONS(400),
    [anon_sym_byte] = ACTIONS(400),
    [anon_sym_short] = ACTIONS(400),
    [anon_sym_int] = ACTIONS(400),
    [anon_sym_long] = ACTIONS(400),
    [anon_sym_char] = ACTIONS(400),
    [anon_sym_float] = ACTIONS(400),
    [anon_sym_double] = ACTIONS(400),
    [sym_boolean_type] = ACTIONS(400),
    [sym_void_type] = ACTIONS(400),
    [sym_this] = ACTIONS(400),
    [sym_super] = ACTIONS(400),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(402),
    [sym_identifier] = ACTIONS(404),
    [sym_decimal_integer_literal] = ACTIONS(404),
    [sym_hex_integer_literal] = ACTIONS(404),
    [sym_octal_integer_literal] = ACTIONS(402),
    [sym_binary_integer_literal] = ACTIONS(402),
    [sym_decimal_floating_point_literal] = ACTIONS(402),
    [sym_hex_floating_point_literal] = ACTIONS(404),
    [sym_true] = ACTIONS(404),
    [sym_false] = ACTIONS(404),
    [sym_character_literal] = ACTIONS(402),
    [sym_string_literal] = ACTIONS(402),
    [sym_null_literal] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(402),
    [anon_sym_PLUS] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(404),
    [anon_sym_BANG] = ACTIONS(402),
    [anon_sym_TILDE] = ACTIONS(402),
    [anon_sym_PLUS_PLUS] = ACTIONS(402),
    [anon_sym_DASH_DASH] = ACTIONS(402),
    [anon_sym_new] = ACTIONS(404),
    [anon_sym_class] = ACTIONS(404),
    [anon_sym_switch] = ACTIONS(404),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_case] = ACTIONS(404),
    [anon_sym_default] = ACTIONS(404),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_assert] = ACTIONS(404),
    [anon_sym_do] = ACTIONS(404),
    [anon_sym_while] = ACTIONS(404),
    [anon_sym_break] = ACTIONS(404),
    [anon_sym_continue] = ACTIONS(404),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(404),
    [anon_sym_synchronized] = ACTIONS(404),
    [anon_sym_throw] = ACTIONS(404),
    [anon_sym_try] = ACTIONS(404),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_else] = ACTIONS(404),
    [anon_sym_for] = ACTIONS(404),
    [anon_sym_AT] = ACTIONS(404),
    [anon_sym_open] = ACTIONS(404),
    [anon_sym_module] = ACTIONS(404),
    [anon_sym_static] = ACTIONS(404),
    [anon_sym_package] = ACTIONS(404),
    [anon_sym_import] = ACTIONS(404),
    [anon_sym_enum] = ACTIONS(404),
    [anon_sym_public] = ACTIONS(404),
    [anon_sym_protected] = ACTIONS(404),
    [anon_sym_private] = ACTIONS(404),
    [anon_sym_abstract] = ACTIONS(404),
    [anon_sym_final] = ACTIONS(404),
    [anon_sym_strictfp] = ACTIONS(404),
    [anon_sym_native] = ACTIONS(404),
    [anon_sym_transient] = ACTIONS(404),
    [anon_sym_volatile] = ACTIONS(404),
    [anon_sym_record] = ACTIONS(404),
    [anon_sym_ATinterface] = ACTIONS(402),
    [anon_sym_interface] = ACTIONS(404),
    [anon_sym_byte] = ACTIONS(404),
    [anon_sym_short] = ACTIONS(404),
    [anon_sym_int] = ACTIONS(404),
    [anon_sym_long] = ACTIONS(404),
    [anon_sym_char] = ACTIONS(404),
    [anon_sym_float] = ACTIONS(404),
    [anon_sym_double] = ACTIONS(404),
    [sym_boolean_type] = ACTIONS(404),
    [sym_void_type] = ACTIONS(404),
    [sym_this] = ACTIONS(404),
    [sym_super] = ACTIONS(404),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [93] = {
    [ts_builtin_sym_end] = ACTIONS(406),
    [sym_identifier] = ACTIONS(408),
    [sym_decimal_integer_literal] = ACTIONS(408),
    [sym_hex_integer_literal] = ACTIONS(408),
    [sym_octal_integer_literal] = ACTIONS(406),
    [sym_binary_integer_literal] = ACTIONS(406),
    [sym_decimal_floating_point_literal] = ACTIONS(406),
    [sym_hex_floating_point_literal] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_character_literal] = ACTIONS(406),
    [sym_string_literal] = ACTIONS(406),
    [sym_null_literal] = ACTIONS(408),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_LT] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(408),
    [anon_sym_DASH] = ACTIONS(408),
    [anon_sym_BANG] = ACTIONS(406),
    [anon_sym_TILDE] = ACTIONS(406),
    [anon_sym_PLUS_PLUS] = ACTIONS(406),
    [anon_sym_DASH_DASH] = ACTIONS(406),
    [anon_sym_new] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(408),
    [anon_sym_switch] = ACTIONS(408),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_case] = ACTIONS(408),
    [anon_sym_default] = ACTIONS(408),
    [anon_sym_SEMI] = ACTIONS(406),
    [anon_sym_assert] = ACTIONS(408),
    [anon_sym_do] = ACTIONS(408),
    [anon_sym_while] = ACTIONS(408),
    [anon_sym_break] = ACTIONS(408),
    [anon_sym_continue] = ACTIONS(408),
    [anon_sym_return] = ACTIONS(408),
    [anon_sym_yield] = ACTIONS(408),
    [anon_sym_synchronized] = ACTIONS(408),
    [anon_sym_throw] = ACTIONS(408),
    [anon_sym_try] = ACTIONS(408),
    [anon_sym_if] = ACTIONS(408),
    [anon_sym_else] = ACTIONS(408),
    [anon_sym_for] = ACTIONS(408),
    [anon_sym_AT] = ACTIONS(408),
    [anon_sym_open] = ACTIONS(408),
    [anon_sym_module] = ACTIONS(408),
    [anon_sym_static] = ACTIONS(408),
    [anon_sym_package] = ACTIONS(408),
    [anon_sym_import] = ACTIONS(408),
    [anon_sym_enum] = ACTIONS(408),
    [anon_sym_public] = ACTIONS(408),
    [anon_sym_protected] = ACTIONS(408),
    [anon_sym_private] = ACTIONS(408),
    [anon_sym_abstract] = ACTIONS(408),
    [anon_sym_final] = ACTIONS(408),
    [anon_sym_strictfp] = ACTIONS(408),
    [anon_sym_native] = ACTIONS(408),
    [anon_sym_transient] = ACTIONS(408),
    [anon_sym_volatile] = ACTIONS(408),
    [anon_sym_record] = ACTIONS(408),
    [anon_sym_ATinterface] = ACTIONS(406),
    [anon_sym_interface] = ACTIONS(408),
    [anon_sym_byte] = ACTIONS(408),
    [anon_sym_short] = ACTIONS(408),
    [anon_sym_int] = ACTIONS(408),
    [anon_sym_long] = ACTIONS(408),
    [anon_sym_char] = ACTIONS(408),
    [anon_sym_float] = ACTIONS(408),
    [anon_sym_double] = ACTIONS(408),
    [sym_boolean_type] = ACTIONS(408),
    [sym_void_type] = ACTIONS(408),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [94] = {
    [ts_builtin_sym_end] = ACTIONS(239),
    [sym_identifier] = ACTIONS(241),
    [sym_decimal_integer_literal] = ACTIONS(241),
    [sym_hex_integer_literal] = ACTIONS(241),
    [sym_octal_integer_literal] = ACTIONS(239),
    [sym_binary_integer_literal] = ACTIONS(239),
    [sym_decimal_floating_point_literal] = ACTIONS(239),
    [sym_hex_floating_point_literal] = ACTIONS(241),
    [sym_true] = ACTIONS(241),
    [sym_false] = ACTIONS(241),
    [sym_character_literal] = ACTIONS(239),
    [sym_string_literal] = ACTIONS(239),
    [sym_null_literal] = ACTIONS(241),
    [anon_sym_LPAREN] = ACTIONS(239),
    [anon_sym_PLUS] = ACTIONS(241),
    [anon_sym_DASH] = ACTIONS(241),
    [anon_sym_BANG] = ACTIONS(239),
    [anon_sym_TILDE] = ACTIONS(239),
    [anon_sym_PLUS_PLUS] = ACTIONS(239),
    [anon_sym_DASH_DASH] = ACTIONS(239),
    [anon_sym_new] = ACTIONS(241),
    [anon_sym_class] = ACTIONS(241),
    [anon_sym_switch] = ACTIONS(241),
    [anon_sym_LBRACE] = ACTIONS(239),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_case] = ACTIONS(241),
    [anon_sym_default] = ACTIONS(241),
    [anon_sym_SEMI] = ACTIONS(239),
    [anon_sym_assert] = ACTIONS(241),
    [anon_sym_do] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(241),
    [anon_sym_break] = ACTIONS(241),
    [anon_sym_continue] = ACTIONS(241),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_yield] = ACTIONS(241),
    [anon_sym_synchronized] = ACTIONS(241),
    [anon_sym_throw] = ACTIONS(241),
    [anon_sym_try] = ACTIONS(241),
    [anon_sym_catch] = ACTIONS(241),
    [anon_sym_finally] = ACTIONS(241),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_else] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(241),
    [anon_sym_AT] = ACTIONS(241),
    [anon_sym_open] = ACTIONS(241),
    [anon_sym_module] = ACTIONS(241),
    [anon_sym_static] = ACTIONS(241),
    [anon_sym_package] = ACTIONS(241),
    [anon_sym_import] = ACTIONS(241),
    [anon_sym_enum] = ACTIONS(241),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_abstract] = ACTIONS(241),
    [anon_sym_final] = ACTIONS(241),
    [anon_sym_strictfp] = ACTIONS(241),
    [anon_sym_native] = ACTIONS(241),
    [anon_sym_transient] = ACTIONS(241),
    [anon_sym_volatile] = ACTIONS(241),
    [anon_sym_ATinterface] = ACTIONS(239),
    [anon_sym_interface] = ACTIONS(241),
    [anon_sym_byte] = ACTIONS(241),
    [anon_sym_short] = ACTIONS(241),
    [anon_sym_int] = ACTIONS(241),
    [anon_sym_long] = ACTIONS(241),
    [anon_sym_char] = ACTIONS(241),
    [anon_sym_float] = ACTIONS(241),
    [anon_sym_double] = ACTIONS(241),
    [sym_boolean_type] = ACTIONS(241),
    [sym_void_type] = ACTIONS(241),
    [sym_this] = ACTIONS(241),
    [sym_super] = ACTIONS(241),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [95] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(462),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym_block] = STATE(411),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [96] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(478),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym_array_initializer] = STATE(849),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [97] = {
    [ts_builtin_sym_end] = ACTIONS(422),
    [sym_identifier] = ACTIONS(424),
    [sym_decimal_integer_literal] = ACTIONS(424),
    [sym_hex_integer_literal] = ACTIONS(424),
    [sym_octal_integer_literal] = ACTIONS(422),
    [sym_binary_integer_literal] = ACTIONS(422),
    [sym_decimal_floating_point_literal] = ACTIONS(422),
    [sym_hex_floating_point_literal] = ACTIONS(424),
    [sym_true] = ACTIONS(424),
    [sym_false] = ACTIONS(424),
    [sym_character_literal] = ACTIONS(422),
    [sym_string_literal] = ACTIONS(422),
    [sym_null_literal] = ACTIONS(424),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(422),
    [anon_sym_PLUS] = ACTIONS(424),
    [anon_sym_DASH] = ACTIONS(424),
    [anon_sym_BANG] = ACTIONS(422),
    [anon_sym_TILDE] = ACTIONS(422),
    [anon_sym_PLUS_PLUS] = ACTIONS(422),
    [anon_sym_DASH_DASH] = ACTIONS(422),
    [anon_sym_new] = ACTIONS(424),
    [anon_sym_class] = ACTIONS(424),
    [anon_sym_switch] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(422),
    [anon_sym_RBRACE] = ACTIONS(422),
    [anon_sym_case] = ACTIONS(424),
    [anon_sym_default] = ACTIONS(424),
    [anon_sym_SEMI] = ACTIONS(422),
    [anon_sym_assert] = ACTIONS(424),
    [anon_sym_do] = ACTIONS(424),
    [anon_sym_while] = ACTIONS(424),
    [anon_sym_break] = ACTIONS(424),
    [anon_sym_continue] = ACTIONS(424),
    [anon_sym_return] = ACTIONS(424),
    [anon_sym_yield] = ACTIONS(424),
    [anon_sym_synchronized] = ACTIONS(424),
    [anon_sym_throw] = ACTIONS(424),
    [anon_sym_try] = ACTIONS(424),
    [anon_sym_if] = ACTIONS(424),
    [anon_sym_else] = ACTIONS(424),
    [anon_sym_for] = ACTIONS(424),
    [anon_sym_AT] = ACTIONS(424),
    [anon_sym_open] = ACTIONS(424),
    [anon_sym_module] = ACTIONS(424),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_package] = ACTIONS(424),
    [anon_sym_import] = ACTIONS(424),
    [anon_sym_enum] = ACTIONS(424),
    [anon_sym_public] = ACTIONS(424),
    [anon_sym_protected] = ACTIONS(424),
    [anon_sym_private] = ACTIONS(424),
    [anon_sym_abstract] = ACTIONS(424),
    [anon_sym_final] = ACTIONS(424),
    [anon_sym_strictfp] = ACTIONS(424),
    [anon_sym_native] = ACTIONS(424),
    [anon_sym_transient] = ACTIONS(424),
    [anon_sym_volatile] = ACTIONS(424),
    [anon_sym_record] = ACTIONS(424),
    [anon_sym_ATinterface] = ACTIONS(422),
    [anon_sym_interface] = ACTIONS(424),
    [anon_sym_byte] = ACTIONS(424),
    [anon_sym_short] = ACTIONS(424),
    [anon_sym_int] = ACTIONS(424),
    [anon_sym_long] = ACTIONS(424),
    [anon_sym_char] = ACTIONS(424),
    [anon_sym_float] = ACTIONS(424),
    [anon_sym_double] = ACTIONS(424),
    [sym_boolean_type] = ACTIONS(424),
    [sym_void_type] = ACTIONS(424),
    [sym_this] = ACTIONS(424),
    [sym_super] = ACTIONS(424),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [98] = {
    [ts_builtin_sym_end] = ACTIONS(426),
    [sym_identifier] = ACTIONS(428),
    [sym_decimal_integer_literal] = ACTIONS(428),
    [sym_hex_integer_literal] = ACTIONS(428),
    [sym_octal_integer_literal] = ACTIONS(426),
    [sym_binary_integer_literal] = ACTIONS(426),
    [sym_decimal_floating_point_literal] = ACTIONS(426),
    [sym_hex_floating_point_literal] = ACTIONS(428),
    [sym_true] = ACTIONS(428),
    [sym_false] = ACTIONS(428),
    [sym_character_literal] = ACTIONS(426),
    [sym_string_literal] = ACTIONS(426),
    [sym_null_literal] = ACTIONS(428),
    [anon_sym_LPAREN] = ACTIONS(426),
    [anon_sym_LT] = ACTIONS(426),
    [anon_sym_PLUS] = ACTIONS(428),
    [anon_sym_DASH] = ACTIONS(428),
    [anon_sym_BANG] = ACTIONS(426),
    [anon_sym_TILDE] = ACTIONS(426),
    [anon_sym_PLUS_PLUS] = ACTIONS(426),
    [anon_sym_DASH_DASH] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(428),
    [anon_sym_class] = ACTIONS(428),
    [anon_sym_switch] = ACTIONS(428),
    [anon_sym_LBRACE] = ACTIONS(426),
    [anon_sym_RBRACE] = ACTIONS(426),
    [anon_sym_case] = ACTIONS(428),
    [anon_sym_default] = ACTIONS(428),
    [anon_sym_SEMI] = ACTIONS(426),
    [anon_sym_assert] = ACTIONS(428),
    [anon_sym_do] = ACTIONS(428),
    [anon_sym_while] = ACTIONS(428),
    [anon_sym_break] = ACTIONS(428),
    [anon_sym_continue] = ACTIONS(428),
    [anon_sym_return] = ACTIONS(428),
    [anon_sym_yield] = ACTIONS(428),
    [anon_sym_synchronized] = ACTIONS(428),
    [anon_sym_throw] = ACTIONS(428),
    [anon_sym_try] = ACTIONS(428),
    [anon_sym_if] = ACTIONS(428),
    [anon_sym_else] = ACTIONS(428),
    [anon_sym_for] = ACTIONS(428),
    [anon_sym_AT] = ACTIONS(428),
    [anon_sym_open] = ACTIONS(428),
    [anon_sym_module] = ACTIONS(428),
    [anon_sym_static] = ACTIONS(428),
    [anon_sym_package] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(428),
    [anon_sym_enum] = ACTIONS(428),
    [anon_sym_public] = ACTIONS(428),
    [anon_sym_protected] = ACTIONS(428),
    [anon_sym_private] = ACTIONS(428),
    [anon_sym_abstract] = ACTIONS(428),
    [anon_sym_final] = ACTIONS(428),
    [anon_sym_strictfp] = ACTIONS(428),
    [anon_sym_native] = ACTIONS(428),
    [anon_sym_transient] = ACTIONS(428),
    [anon_sym_volatile] = ACTIONS(428),
    [anon_sym_record] = ACTIONS(428),
    [anon_sym_ATinterface] = ACTIONS(426),
    [anon_sym_interface] = ACTIONS(428),
    [anon_sym_byte] = ACTIONS(428),
    [anon_sym_short] = ACTIONS(428),
    [anon_sym_int] = ACTIONS(428),
    [anon_sym_long] = ACTIONS(428),
    [anon_sym_char] = ACTIONS(428),
    [anon_sym_float] = ACTIONS(428),
    [anon_sym_double] = ACTIONS(428),
    [sym_boolean_type] = ACTIONS(428),
    [sym_void_type] = ACTIONS(428),
    [sym_this] = ACTIONS(428),
    [sym_super] = ACTIONS(428),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [99] = {
    [ts_builtin_sym_end] = ACTIONS(430),
    [sym_identifier] = ACTIONS(432),
    [sym_decimal_integer_literal] = ACTIONS(432),
    [sym_hex_integer_literal] = ACTIONS(432),
    [sym_octal_integer_literal] = ACTIONS(430),
    [sym_binary_integer_literal] = ACTIONS(430),
    [sym_decimal_floating_point_literal] = ACTIONS(430),
    [sym_hex_floating_point_literal] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_character_literal] = ACTIONS(430),
    [sym_string_literal] = ACTIONS(430),
    [sym_null_literal] = ACTIONS(432),
    [anon_sym_LPAREN] = ACTIONS(430),
    [anon_sym_LT] = ACTIONS(430),
    [anon_sym_PLUS] = ACTIONS(432),
    [anon_sym_DASH] = ACTIONS(432),
    [anon_sym_BANG] = ACTIONS(430),
    [anon_sym_TILDE] = ACTIONS(430),
    [anon_sym_PLUS_PLUS] = ACTIONS(430),
    [anon_sym_DASH_DASH] = ACTIONS(430),
    [anon_sym_new] = ACTIONS(432),
    [anon_sym_class] = ACTIONS(432),
    [anon_sym_switch] = ACTIONS(432),
    [anon_sym_LBRACE] = ACTIONS(430),
    [anon_sym_RBRACE] = ACTIONS(430),
    [anon_sym_case] = ACTIONS(432),
    [anon_sym_default] = ACTIONS(432),
    [anon_sym_SEMI] = ACTIONS(430),
    [anon_sym_assert] = ACTIONS(432),
    [anon_sym_do] = ACTIONS(432),
    [anon_sym_while] = ACTIONS(432),
    [anon_sym_break] = ACTIONS(432),
    [anon_sym_continue] = ACTIONS(432),
    [anon_sym_return] = ACTIONS(432),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_synchronized] = ACTIONS(432),
    [anon_sym_throw] = ACTIONS(432),
    [anon_sym_try] = ACTIONS(432),
    [anon_sym_if] = ACTIONS(432),
    [anon_sym_else] = ACTIONS(432),
    [anon_sym_for] = ACTIONS(432),
    [anon_sym_AT] = ACTIONS(432),
    [anon_sym_open] = ACTIONS(432),
    [anon_sym_module] = ACTIONS(432),
    [anon_sym_static] = ACTIONS(432),
    [anon_sym_package] = ACTIONS(432),
    [anon_sym_import] = ACTIONS(432),
    [anon_sym_enum] = ACTIONS(432),
    [anon_sym_public] = ACTIONS(432),
    [anon_sym_protected] = ACTIONS(432),
    [anon_sym_private] = ACTIONS(432),
    [anon_sym_abstract] = ACTIONS(432),
    [anon_sym_final] = ACTIONS(432),
    [anon_sym_strictfp] = ACTIONS(432),
    [anon_sym_native] = ACTIONS(432),
    [anon_sym_transient] = ACTIONS(432),
    [anon_sym_volatile] = ACTIONS(432),
    [anon_sym_record] = ACTIONS(432),
    [anon_sym_ATinterface] = ACTIONS(430),
    [anon_sym_interface] = ACTIONS(432),
    [anon_sym_byte] = ACTIONS(432),
    [anon_sym_short] = ACTIONS(432),
    [anon_sym_int] = ACTIONS(432),
    [anon_sym_long] = ACTIONS(432),
    [anon_sym_char] = ACTIONS(432),
    [anon_sym_float] = ACTIONS(432),
    [anon_sym_double] = ACTIONS(432),
    [sym_boolean_type] = ACTIONS(432),
    [sym_void_type] = ACTIONS(432),
    [sym_this] = ACTIONS(432),
    [sym_super] = ACTIONS(432),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [100] = {
    [ts_builtin_sym_end] = ACTIONS(434),
    [sym_identifier] = ACTIONS(436),
    [sym_decimal_integer_literal] = ACTIONS(436),
    [sym_hex_integer_literal] = ACTIONS(436),
    [sym_octal_integer_literal] = ACTIONS(434),
    [sym_binary_integer_literal] = ACTIONS(434),
    [sym_decimal_floating_point_literal] = ACTIONS(434),
    [sym_hex_floating_point_literal] = ACTIONS(436),
    [sym_true] = ACTIONS(436),
    [sym_false] = ACTIONS(436),
    [sym_character_literal] = ACTIONS(434),
    [sym_string_literal] = ACTIONS(434),
    [sym_null_literal] = ACTIONS(436),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_LT] = ACTIONS(434),
    [anon_sym_PLUS] = ACTIONS(436),
    [anon_sym_DASH] = ACTIONS(436),
    [anon_sym_BANG] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(434),
    [anon_sym_PLUS_PLUS] = ACTIONS(434),
    [anon_sym_DASH_DASH] = ACTIONS(434),
    [anon_sym_new] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(436),
    [anon_sym_switch] = ACTIONS(436),
    [anon_sym_LBRACE] = ACTIONS(434),
    [anon_sym_RBRACE] = ACTIONS(434),
    [anon_sym_case] = ACTIONS(436),
    [anon_sym_default] = ACTIONS(436),
    [anon_sym_SEMI] = ACTIONS(434),
    [anon_sym_assert] = ACTIONS(436),
    [anon_sym_do] = ACTIONS(436),
    [anon_sym_while] = ACTIONS(436),
    [anon_sym_break] = ACTIONS(436),
    [anon_sym_continue] = ACTIONS(436),
    [anon_sym_return] = ACTIONS(436),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_synchronized] = ACTIONS(436),
    [anon_sym_throw] = ACTIONS(436),
    [anon_sym_try] = ACTIONS(436),
    [anon_sym_if] = ACTIONS(436),
    [anon_sym_else] = ACTIONS(436),
    [anon_sym_for] = ACTIONS(436),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_open] = ACTIONS(436),
    [anon_sym_module] = ACTIONS(436),
    [anon_sym_static] = ACTIONS(436),
    [anon_sym_package] = ACTIONS(436),
    [anon_sym_import] = ACTIONS(436),
    [anon_sym_enum] = ACTIONS(436),
    [anon_sym_public] = ACTIONS(436),
    [anon_sym_protected] = ACTIONS(436),
    [anon_sym_private] = ACTIONS(436),
    [anon_sym_abstract] = ACTIONS(436),
    [anon_sym_final] = ACTIONS(436),
    [anon_sym_strictfp] = ACTIONS(436),
    [anon_sym_native] = ACTIONS(436),
    [anon_sym_transient] = ACTIONS(436),
    [anon_sym_volatile] = ACTIONS(436),
    [anon_sym_record] = ACTIONS(436),
    [anon_sym_ATinterface] = ACTIONS(434),
    [anon_sym_interface] = ACTIONS(436),
    [anon_sym_byte] = ACTIONS(436),
    [anon_sym_short] = ACTIONS(436),
    [anon_sym_int] = ACTIONS(436),
    [anon_sym_long] = ACTIONS(436),
    [anon_sym_char] = ACTIONS(436),
    [anon_sym_float] = ACTIONS(436),
    [anon_sym_double] = ACTIONS(436),
    [sym_boolean_type] = ACTIONS(436),
    [sym_void_type] = ACTIONS(436),
    [sym_this] = ACTIONS(436),
    [sym_super] = ACTIONS(436),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [101] = {
    [ts_builtin_sym_end] = ACTIONS(438),
    [sym_identifier] = ACTIONS(440),
    [sym_decimal_integer_literal] = ACTIONS(440),
    [sym_hex_integer_literal] = ACTIONS(440),
    [sym_octal_integer_literal] = ACTIONS(438),
    [sym_binary_integer_literal] = ACTIONS(438),
    [sym_decimal_floating_point_literal] = ACTIONS(438),
    [sym_hex_floating_point_literal] = ACTIONS(440),
    [sym_true] = ACTIONS(440),
    [sym_false] = ACTIONS(440),
    [sym_character_literal] = ACTIONS(438),
    [sym_string_literal] = ACTIONS(438),
    [sym_null_literal] = ACTIONS(440),
    [anon_sym_LPAREN] = ACTIONS(438),
    [anon_sym_LT] = ACTIONS(438),
    [anon_sym_PLUS] = ACTIONS(440),
    [anon_sym_DASH] = ACTIONS(440),
    [anon_sym_BANG] = ACTIONS(438),
    [anon_sym_TILDE] = ACTIONS(438),
    [anon_sym_PLUS_PLUS] = ACTIONS(438),
    [anon_sym_DASH_DASH] = ACTIONS(438),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_class] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(440),
    [anon_sym_LBRACE] = ACTIONS(438),
    [anon_sym_RBRACE] = ACTIONS(438),
    [anon_sym_case] = ACTIONS(440),
    [anon_sym_default] = ACTIONS(440),
    [anon_sym_SEMI] = ACTIONS(438),
    [anon_sym_assert] = ACTIONS(440),
    [anon_sym_do] = ACTIONS(440),
    [anon_sym_while] = ACTIONS(440),
    [anon_sym_break] = ACTIONS(440),
    [anon_sym_continue] = ACTIONS(440),
    [anon_sym_return] = ACTIONS(440),
    [anon_sym_yield] = ACTIONS(440),
    [anon_sym_synchronized] = ACTIONS(440),
    [anon_sym_throw] = ACTIONS(440),
    [anon_sym_try] = ACTIONS(440),
    [anon_sym_if] = ACTIONS(440),
    [anon_sym_else] = ACTIONS(440),
    [anon_sym_for] = ACTIONS(440),
    [anon_sym_AT] = ACTIONS(440),
    [anon_sym_open] = ACTIONS(440),
    [anon_sym_module] = ACTIONS(440),
    [anon_sym_static] = ACTIONS(440),
    [anon_sym_package] = ACTIONS(440),
    [anon_sym_import] = ACTIONS(440),
    [anon_sym_enum] = ACTIONS(440),
    [anon_sym_public] = ACTIONS(440),
    [anon_sym_protected] = ACTIONS(440),
    [anon_sym_private] = ACTIONS(440),
    [anon_sym_abstract] = ACTIONS(440),
    [anon_sym_final] = ACTIONS(440),
    [anon_sym_strictfp] = ACTIONS(440),
    [anon_sym_native] = ACTIONS(440),
    [anon_sym_transient] = ACTIONS(440),
    [anon_sym_volatile] = ACTIONS(440),
    [anon_sym_record] = ACTIONS(440),
    [anon_sym_ATinterface] = ACTIONS(438),
    [anon_sym_interface] = ACTIONS(440),
    [anon_sym_byte] = ACTIONS(440),
    [anon_sym_short] = ACTIONS(440),
    [anon_sym_int] = ACTIONS(440),
    [anon_sym_long] = ACTIONS(440),
    [anon_sym_char] = ACTIONS(440),
    [anon_sym_float] = ACTIONS(440),
    [anon_sym_double] = ACTIONS(440),
    [sym_boolean_type] = ACTIONS(440),
    [sym_void_type] = ACTIONS(440),
    [sym_this] = ACTIONS(440),
    [sym_super] = ACTIONS(440),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [102] = {
    [ts_builtin_sym_end] = ACTIONS(442),
    [sym_identifier] = ACTIONS(444),
    [sym_decimal_integer_literal] = ACTIONS(444),
    [sym_hex_integer_literal] = ACTIONS(444),
    [sym_octal_integer_literal] = ACTIONS(442),
    [sym_binary_integer_literal] = ACTIONS(442),
    [sym_decimal_floating_point_literal] = ACTIONS(442),
    [sym_hex_floating_point_literal] = ACTIONS(444),
    [sym_true] = ACTIONS(444),
    [sym_false] = ACTIONS(444),
    [sym_character_literal] = ACTIONS(442),
    [sym_string_literal] = ACTIONS(442),
    [sym_null_literal] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(442),
    [anon_sym_LT] = ACTIONS(442),
    [anon_sym_PLUS] = ACTIONS(444),
    [anon_sym_DASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(442),
    [anon_sym_DASH_DASH] = ACTIONS(442),
    [anon_sym_new] = ACTIONS(444),
    [anon_sym_class] = ACTIONS(444),
    [anon_sym_switch] = ACTIONS(444),
    [anon_sym_LBRACE] = ACTIONS(442),
    [anon_sym_RBRACE] = ACTIONS(442),
    [anon_sym_case] = ACTIONS(444),
    [anon_sym_default] = ACTIONS(444),
    [anon_sym_SEMI] = ACTIONS(442),
    [anon_sym_assert] = ACTIONS(444),
    [anon_sym_do] = ACTIONS(444),
    [anon_sym_while] = ACTIONS(444),
    [anon_sym_break] = ACTIONS(444),
    [anon_sym_continue] = ACTIONS(444),
    [anon_sym_return] = ACTIONS(444),
    [anon_sym_yield] = ACTIONS(444),
    [anon_sym_synchronized] = ACTIONS(444),
    [anon_sym_throw] = ACTIONS(444),
    [anon_sym_try] = ACTIONS(444),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_else] = ACTIONS(444),
    [anon_sym_for] = ACTIONS(444),
    [anon_sym_AT] = ACTIONS(444),
    [anon_sym_open] = ACTIONS(444),
    [anon_sym_module] = ACTIONS(444),
    [anon_sym_static] = ACTIONS(444),
    [anon_sym_package] = ACTIONS(444),
    [anon_sym_import] = ACTIONS(444),
    [anon_sym_enum] = ACTIONS(444),
    [anon_sym_public] = ACTIONS(444),
    [anon_sym_protected] = ACTIONS(444),
    [anon_sym_private] = ACTIONS(444),
    [anon_sym_abstract] = ACTIONS(444),
    [anon_sym_final] = ACTIONS(444),
    [anon_sym_strictfp] = ACTIONS(444),
    [anon_sym_native] = ACTIONS(444),
    [anon_sym_transient] = ACTIONS(444),
    [anon_sym_volatile] = ACTIONS(444),
    [anon_sym_record] = ACTIONS(444),
    [anon_sym_ATinterface] = ACTIONS(442),
    [anon_sym_interface] = ACTIONS(444),
    [anon_sym_byte] = ACTIONS(444),
    [anon_sym_short] = ACTIONS(444),
    [anon_sym_int] = ACTIONS(444),
    [anon_sym_long] = ACTIONS(444),
    [anon_sym_char] = ACTIONS(444),
    [anon_sym_float] = ACTIONS(444),
    [anon_sym_double] = ACTIONS(444),
    [sym_boolean_type] = ACTIONS(444),
    [sym_void_type] = ACTIONS(444),
    [sym_this] = ACTIONS(444),
    [sym_super] = ACTIONS(444),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [103] = {
    [ts_builtin_sym_end] = ACTIONS(446),
    [sym_identifier] = ACTIONS(448),
    [sym_decimal_integer_literal] = ACTIONS(448),
    [sym_hex_integer_literal] = ACTIONS(448),
    [sym_octal_integer_literal] = ACTIONS(446),
    [sym_binary_integer_literal] = ACTIONS(446),
    [sym_decimal_floating_point_literal] = ACTIONS(446),
    [sym_hex_floating_point_literal] = ACTIONS(448),
    [sym_true] = ACTIONS(448),
    [sym_false] = ACTIONS(448),
    [sym_character_literal] = ACTIONS(446),
    [sym_string_literal] = ACTIONS(446),
    [sym_null_literal] = ACTIONS(448),
    [anon_sym_LPAREN] = ACTIONS(446),
    [anon_sym_LT] = ACTIONS(446),
    [anon_sym_PLUS] = ACTIONS(448),
    [anon_sym_DASH] = ACTIONS(448),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_new] = ACTIONS(448),
    [anon_sym_class] = ACTIONS(448),
    [anon_sym_switch] = ACTIONS(448),
    [anon_sym_LBRACE] = ACTIONS(446),
    [anon_sym_RBRACE] = ACTIONS(446),
    [anon_sym_case] = ACTIONS(448),
    [anon_sym_default] = ACTIONS(448),
    [anon_sym_SEMI] = ACTIONS(446),
    [anon_sym_assert] = ACTIONS(448),
    [anon_sym_do] = ACTIONS(448),
    [anon_sym_while] = ACTIONS(448),
    [anon_sym_break] = ACTIONS(448),
    [anon_sym_continue] = ACTIONS(448),
    [anon_sym_return] = ACTIONS(448),
    [anon_sym_yield] = ACTIONS(448),
    [anon_sym_synchronized] = ACTIONS(448),
    [anon_sym_throw] = ACTIONS(448),
    [anon_sym_try] = ACTIONS(448),
    [anon_sym_if] = ACTIONS(448),
    [anon_sym_else] = ACTIONS(448),
    [anon_sym_for] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(448),
    [anon_sym_open] = ACTIONS(448),
    [anon_sym_module] = ACTIONS(448),
    [anon_sym_static] = ACTIONS(448),
    [anon_sym_package] = ACTIONS(448),
    [anon_sym_import] = ACTIONS(448),
    [anon_sym_enum] = ACTIONS(448),
    [anon_sym_public] = ACTIONS(448),
    [anon_sym_protected] = ACTIONS(448),
    [anon_sym_private] = ACTIONS(448),
    [anon_sym_abstract] = ACTIONS(448),
    [anon_sym_final] = ACTIONS(448),
    [anon_sym_strictfp] = ACTIONS(448),
    [anon_sym_native] = ACTIONS(448),
    [anon_sym_transient] = ACTIONS(448),
    [anon_sym_volatile] = ACTIONS(448),
    [anon_sym_record] = ACTIONS(448),
    [anon_sym_ATinterface] = ACTIONS(446),
    [anon_sym_interface] = ACTIONS(448),
    [anon_sym_byte] = ACTIONS(448),
    [anon_sym_short] = ACTIONS(448),
    [anon_sym_int] = ACTIONS(448),
    [anon_sym_long] = ACTIONS(448),
    [anon_sym_char] = ACTIONS(448),
    [anon_sym_float] = ACTIONS(448),
    [anon_sym_double] = ACTIONS(448),
    [sym_boolean_type] = ACTIONS(448),
    [sym_void_type] = ACTIONS(448),
    [sym_this] = ACTIONS(448),
    [sym_super] = ACTIONS(448),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [104] = {
    [ts_builtin_sym_end] = ACTIONS(450),
    [sym_identifier] = ACTIONS(452),
    [sym_decimal_integer_literal] = ACTIONS(452),
    [sym_hex_integer_literal] = ACTIONS(452),
    [sym_octal_integer_literal] = ACTIONS(450),
    [sym_binary_integer_literal] = ACTIONS(450),
    [sym_decimal_floating_point_literal] = ACTIONS(450),
    [sym_hex_floating_point_literal] = ACTIONS(452),
    [sym_true] = ACTIONS(452),
    [sym_false] = ACTIONS(452),
    [sym_character_literal] = ACTIONS(450),
    [sym_string_literal] = ACTIONS(450),
    [sym_null_literal] = ACTIONS(452),
    [anon_sym_LPAREN] = ACTIONS(450),
    [anon_sym_LT] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(452),
    [anon_sym_DASH] = ACTIONS(452),
    [anon_sym_BANG] = ACTIONS(450),
    [anon_sym_TILDE] = ACTIONS(450),
    [anon_sym_PLUS_PLUS] = ACTIONS(450),
    [anon_sym_DASH_DASH] = ACTIONS(450),
    [anon_sym_new] = ACTIONS(452),
    [anon_sym_class] = ACTIONS(452),
    [anon_sym_switch] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(450),
    [anon_sym_RBRACE] = ACTIONS(450),
    [anon_sym_case] = ACTIONS(452),
    [anon_sym_default] = ACTIONS(452),
    [anon_sym_SEMI] = ACTIONS(450),
    [anon_sym_assert] = ACTIONS(452),
    [anon_sym_do] = ACTIONS(452),
    [anon_sym_while] = ACTIONS(452),
    [anon_sym_break] = ACTIONS(452),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_return] = ACTIONS(452),
    [anon_sym_yield] = ACTIONS(452),
    [anon_sym_synchronized] = ACTIONS(452),
    [anon_sym_throw] = ACTIONS(452),
    [anon_sym_try] = ACTIONS(452),
    [anon_sym_if] = ACTIONS(452),
    [anon_sym_else] = ACTIONS(452),
    [anon_sym_for] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(452),
    [anon_sym_open] = ACTIONS(452),
    [anon_sym_module] = ACTIONS(452),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_package] = ACTIONS(452),
    [anon_sym_import] = ACTIONS(452),
    [anon_sym_enum] = ACTIONS(452),
    [anon_sym_public] = ACTIONS(452),
    [anon_sym_protected] = ACTIONS(452),
    [anon_sym_private] = ACTIONS(452),
    [anon_sym_abstract] = ACTIONS(452),
    [anon_sym_final] = ACTIONS(452),
    [anon_sym_strictfp] = ACTIONS(452),
    [anon_sym_native] = ACTIONS(452),
    [anon_sym_transient] = ACTIONS(452),
    [anon_sym_volatile] = ACTIONS(452),
    [anon_sym_record] = ACTIONS(452),
    [anon_sym_ATinterface] = ACTIONS(450),
    [anon_sym_interface] = ACTIONS(452),
    [anon_sym_byte] = ACTIONS(452),
    [anon_sym_short] = ACTIONS(452),
    [anon_sym_int] = ACTIONS(452),
    [anon_sym_long] = ACTIONS(452),
    [anon_sym_char] = ACTIONS(452),
    [anon_sym_float] = ACTIONS(452),
    [anon_sym_double] = ACTIONS(452),
    [sym_boolean_type] = ACTIONS(452),
    [sym_void_type] = ACTIONS(452),
    [sym_this] = ACTIONS(452),
    [sym_super] = ACTIONS(452),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [105] = {
    [ts_builtin_sym_end] = ACTIONS(454),
    [sym_identifier] = ACTIONS(456),
    [sym_decimal_integer_literal] = ACTIONS(456),
    [sym_hex_integer_literal] = ACTIONS(456),
    [sym_octal_integer_literal] = ACTIONS(454),
    [sym_binary_integer_literal] = ACTIONS(454),
    [sym_decimal_floating_point_literal] = ACTIONS(454),
    [sym_hex_floating_point_literal] = ACTIONS(456),
    [sym_true] = ACTIONS(456),
    [sym_false] = ACTIONS(456),
    [sym_character_literal] = ACTIONS(454),
    [sym_string_literal] = ACTIONS(454),
    [sym_null_literal] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(454),
    [anon_sym_LT] = ACTIONS(454),
    [anon_sym_PLUS] = ACTIONS(456),
    [anon_sym_DASH] = ACTIONS(456),
    [anon_sym_BANG] = ACTIONS(454),
    [anon_sym_TILDE] = ACTIONS(454),
    [anon_sym_PLUS_PLUS] = ACTIONS(454),
    [anon_sym_DASH_DASH] = ACTIONS(454),
    [anon_sym_new] = ACTIONS(456),
    [anon_sym_class] = ACTIONS(456),
    [anon_sym_switch] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(454),
    [anon_sym_RBRACE] = ACTIONS(454),
    [anon_sym_case] = ACTIONS(456),
    [anon_sym_default] = ACTIONS(456),
    [anon_sym_SEMI] = ACTIONS(454),
    [anon_sym_assert] = ACTIONS(456),
    [anon_sym_do] = ACTIONS(456),
    [anon_sym_while] = ACTIONS(456),
    [anon_sym_break] = ACTIONS(456),
    [anon_sym_continue] = ACTIONS(456),
    [anon_sym_return] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(456),
    [anon_sym_synchronized] = ACTIONS(456),
    [anon_sym_throw] = ACTIONS(456),
    [anon_sym_try] = ACTIONS(456),
    [anon_sym_if] = ACTIONS(456),
    [anon_sym_else] = ACTIONS(456),
    [anon_sym_for] = ACTIONS(456),
    [anon_sym_AT] = ACTIONS(456),
    [anon_sym_open] = ACTIONS(456),
    [anon_sym_module] = ACTIONS(456),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_package] = ACTIONS(456),
    [anon_sym_import] = ACTIONS(456),
    [anon_sym_enum] = ACTIONS(456),
    [anon_sym_public] = ACTIONS(456),
    [anon_sym_protected] = ACTIONS(456),
    [anon_sym_private] = ACTIONS(456),
    [anon_sym_abstract] = ACTIONS(456),
    [anon_sym_final] = ACTIONS(456),
    [anon_sym_strictfp] = ACTIONS(456),
    [anon_sym_native] = ACTIONS(456),
    [anon_sym_transient] = ACTIONS(456),
    [anon_sym_volatile] = ACTIONS(456),
    [anon_sym_record] = ACTIONS(456),
    [anon_sym_ATinterface] = ACTIONS(454),
    [anon_sym_interface] = ACTIONS(456),
    [anon_sym_byte] = ACTIONS(456),
    [anon_sym_short] = ACTIONS(456),
    [anon_sym_int] = ACTIONS(456),
    [anon_sym_long] = ACTIONS(456),
    [anon_sym_char] = ACTIONS(456),
    [anon_sym_float] = ACTIONS(456),
    [anon_sym_double] = ACTIONS(456),
    [sym_boolean_type] = ACTIONS(456),
    [sym_void_type] = ACTIONS(456),
    [sym_this] = ACTIONS(456),
    [sym_super] = ACTIONS(456),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(458),
    [sym_identifier] = ACTIONS(460),
    [sym_decimal_integer_literal] = ACTIONS(460),
    [sym_hex_integer_literal] = ACTIONS(460),
    [sym_octal_integer_literal] = ACTIONS(458),
    [sym_binary_integer_literal] = ACTIONS(458),
    [sym_decimal_floating_point_literal] = ACTIONS(458),
    [sym_hex_floating_point_literal] = ACTIONS(460),
    [sym_true] = ACTIONS(460),
    [sym_false] = ACTIONS(460),
    [sym_character_literal] = ACTIONS(458),
    [sym_string_literal] = ACTIONS(458),
    [sym_null_literal] = ACTIONS(460),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_LT] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(460),
    [anon_sym_DASH] = ACTIONS(460),
    [anon_sym_BANG] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_PLUS_PLUS] = ACTIONS(458),
    [anon_sym_DASH_DASH] = ACTIONS(458),
    [anon_sym_new] = ACTIONS(460),
    [anon_sym_class] = ACTIONS(460),
    [anon_sym_switch] = ACTIONS(460),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_case] = ACTIONS(460),
    [anon_sym_default] = ACTIONS(460),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_assert] = ACTIONS(460),
    [anon_sym_do] = ACTIONS(460),
    [anon_sym_while] = ACTIONS(460),
    [anon_sym_break] = ACTIONS(460),
    [anon_sym_continue] = ACTIONS(460),
    [anon_sym_return] = ACTIONS(460),
    [anon_sym_yield] = ACTIONS(460),
    [anon_sym_synchronized] = ACTIONS(460),
    [anon_sym_throw] = ACTIONS(460),
    [anon_sym_try] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(460),
    [anon_sym_else] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(460),
    [anon_sym_AT] = ACTIONS(460),
    [anon_sym_open] = ACTIONS(460),
    [anon_sym_module] = ACTIONS(460),
    [anon_sym_static] = ACTIONS(460),
    [anon_sym_package] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(460),
    [anon_sym_enum] = ACTIONS(460),
    [anon_sym_public] = ACTIONS(460),
    [anon_sym_protected] = ACTIONS(460),
    [anon_sym_private] = ACTIONS(460),
    [anon_sym_abstract] = ACTIONS(460),
    [anon_sym_final] = ACTIONS(460),
    [anon_sym_strictfp] = ACTIONS(460),
    [anon_sym_native] = ACTIONS(460),
    [anon_sym_transient] = ACTIONS(460),
    [anon_sym_volatile] = ACTIONS(460),
    [anon_sym_record] = ACTIONS(460),
    [anon_sym_ATinterface] = ACTIONS(458),
    [anon_sym_interface] = ACTIONS(460),
    [anon_sym_byte] = ACTIONS(460),
    [anon_sym_short] = ACTIONS(460),
    [anon_sym_int] = ACTIONS(460),
    [anon_sym_long] = ACTIONS(460),
    [anon_sym_char] = ACTIONS(460),
    [anon_sym_float] = ACTIONS(460),
    [anon_sym_double] = ACTIONS(460),
    [sym_boolean_type] = ACTIONS(460),
    [sym_void_type] = ACTIONS(460),
    [sym_this] = ACTIONS(460),
    [sym_super] = ACTIONS(460),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(462),
    [sym_identifier] = ACTIONS(464),
    [sym_decimal_integer_literal] = ACTIONS(464),
    [sym_hex_integer_literal] = ACTIONS(464),
    [sym_octal_integer_literal] = ACTIONS(462),
    [sym_binary_integer_literal] = ACTIONS(462),
    [sym_decimal_floating_point_literal] = ACTIONS(462),
    [sym_hex_floating_point_literal] = ACTIONS(464),
    [sym_true] = ACTIONS(464),
    [sym_false] = ACTIONS(464),
    [sym_character_literal] = ACTIONS(462),
    [sym_string_literal] = ACTIONS(462),
    [sym_null_literal] = ACTIONS(464),
    [anon_sym_LPAREN] = ACTIONS(462),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(462),
    [anon_sym_PLUS_PLUS] = ACTIONS(462),
    [anon_sym_DASH_DASH] = ACTIONS(462),
    [anon_sym_new] = ACTIONS(464),
    [anon_sym_class] = ACTIONS(464),
    [anon_sym_switch] = ACTIONS(464),
    [anon_sym_LBRACE] = ACTIONS(462),
    [anon_sym_RBRACE] = ACTIONS(462),
    [anon_sym_case] = ACTIONS(464),
    [anon_sym_default] = ACTIONS(464),
    [anon_sym_SEMI] = ACTIONS(462),
    [anon_sym_assert] = ACTIONS(464),
    [anon_sym_do] = ACTIONS(464),
    [anon_sym_while] = ACTIONS(464),
    [anon_sym_break] = ACTIONS(464),
    [anon_sym_continue] = ACTIONS(464),
    [anon_sym_return] = ACTIONS(464),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_synchronized] = ACTIONS(464),
    [anon_sym_throw] = ACTIONS(464),
    [anon_sym_try] = ACTIONS(464),
    [anon_sym_if] = ACTIONS(464),
    [anon_sym_else] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(464),
    [anon_sym_AT] = ACTIONS(464),
    [anon_sym_open] = ACTIONS(464),
    [anon_sym_module] = ACTIONS(464),
    [anon_sym_static] = ACTIONS(464),
    [anon_sym_package] = ACTIONS(464),
    [anon_sym_import] = ACTIONS(464),
    [anon_sym_enum] = ACTIONS(464),
    [anon_sym_public] = ACTIONS(464),
    [anon_sym_protected] = ACTIONS(464),
    [anon_sym_private] = ACTIONS(464),
    [anon_sym_abstract] = ACTIONS(464),
    [anon_sym_final] = ACTIONS(464),
    [anon_sym_strictfp] = ACTIONS(464),
    [anon_sym_native] = ACTIONS(464),
    [anon_sym_transient] = ACTIONS(464),
    [anon_sym_volatile] = ACTIONS(464),
    [anon_sym_record] = ACTIONS(464),
    [anon_sym_ATinterface] = ACTIONS(462),
    [anon_sym_interface] = ACTIONS(464),
    [anon_sym_byte] = ACTIONS(464),
    [anon_sym_short] = ACTIONS(464),
    [anon_sym_int] = ACTIONS(464),
    [anon_sym_long] = ACTIONS(464),
    [anon_sym_char] = ACTIONS(464),
    [anon_sym_float] = ACTIONS(464),
    [anon_sym_double] = ACTIONS(464),
    [sym_boolean_type] = ACTIONS(464),
    [sym_void_type] = ACTIONS(464),
    [sym_this] = ACTIONS(464),
    [sym_super] = ACTIONS(464),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(466),
    [sym_identifier] = ACTIONS(468),
    [sym_decimal_integer_literal] = ACTIONS(468),
    [sym_hex_integer_literal] = ACTIONS(468),
    [sym_octal_integer_literal] = ACTIONS(466),
    [sym_binary_integer_literal] = ACTIONS(466),
    [sym_decimal_floating_point_literal] = ACTIONS(466),
    [sym_hex_floating_point_literal] = ACTIONS(468),
    [sym_true] = ACTIONS(468),
    [sym_false] = ACTIONS(468),
    [sym_character_literal] = ACTIONS(466),
    [sym_string_literal] = ACTIONS(466),
    [sym_null_literal] = ACTIONS(468),
    [anon_sym_LPAREN] = ACTIONS(466),
    [anon_sym_LT] = ACTIONS(466),
    [anon_sym_PLUS] = ACTIONS(468),
    [anon_sym_DASH] = ACTIONS(468),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_PLUS_PLUS] = ACTIONS(466),
    [anon_sym_DASH_DASH] = ACTIONS(466),
    [anon_sym_new] = ACTIONS(468),
    [anon_sym_class] = ACTIONS(468),
    [anon_sym_switch] = ACTIONS(468),
    [anon_sym_LBRACE] = ACTIONS(466),
    [anon_sym_RBRACE] = ACTIONS(466),
    [anon_sym_case] = ACTIONS(468),
    [anon_sym_default] = ACTIONS(468),
    [anon_sym_SEMI] = ACTIONS(466),
    [anon_sym_assert] = ACTIONS(468),
    [anon_sym_do] = ACTIONS(468),
    [anon_sym_while] = ACTIONS(468),
    [anon_sym_break] = ACTIONS(468),
    [anon_sym_continue] = ACTIONS(468),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_yield] = ACTIONS(468),
    [anon_sym_synchronized] = ACTIONS(468),
    [anon_sym_throw] = ACTIONS(468),
    [anon_sym_try] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(468),
    [anon_sym_else] = ACTIONS(468),
    [anon_sym_for] = ACTIONS(468),
    [anon_sym_AT] = ACTIONS(468),
    [anon_sym_open] = ACTIONS(468),
    [anon_sym_module] = ACTIONS(468),
    [anon_sym_static] = ACTIONS(468),
    [anon_sym_package] = ACTIONS(468),
    [anon_sym_import] = ACTIONS(468),
    [anon_sym_enum] = ACTIONS(468),
    [anon_sym_public] = ACTIONS(468),
    [anon_sym_protected] = ACTIONS(468),
    [anon_sym_private] = ACTIONS(468),
    [anon_sym_abstract] = ACTIONS(468),
    [anon_sym_final] = ACTIONS(468),
    [anon_sym_strictfp] = ACTIONS(468),
    [anon_sym_native] = ACTIONS(468),
    [anon_sym_transient] = ACTIONS(468),
    [anon_sym_volatile] = ACTIONS(468),
    [anon_sym_record] = ACTIONS(468),
    [anon_sym_ATinterface] = ACTIONS(466),
    [anon_sym_interface] = ACTIONS(468),
    [anon_sym_byte] = ACTIONS(468),
    [anon_sym_short] = ACTIONS(468),
    [anon_sym_int] = ACTIONS(468),
    [anon_sym_long] = ACTIONS(468),
    [anon_sym_char] = ACTIONS(468),
    [anon_sym_float] = ACTIONS(468),
    [anon_sym_double] = ACTIONS(468),
    [sym_boolean_type] = ACTIONS(468),
    [sym_void_type] = ACTIONS(468),
    [sym_this] = ACTIONS(468),
    [sym_super] = ACTIONS(468),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(470),
    [sym_identifier] = ACTIONS(472),
    [sym_decimal_integer_literal] = ACTIONS(472),
    [sym_hex_integer_literal] = ACTIONS(472),
    [sym_octal_integer_literal] = ACTIONS(470),
    [sym_binary_integer_literal] = ACTIONS(470),
    [sym_decimal_floating_point_literal] = ACTIONS(470),
    [sym_hex_floating_point_literal] = ACTIONS(472),
    [sym_true] = ACTIONS(472),
    [sym_false] = ACTIONS(472),
    [sym_character_literal] = ACTIONS(470),
    [sym_string_literal] = ACTIONS(470),
    [sym_null_literal] = ACTIONS(472),
    [anon_sym_LPAREN] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_BANG] = ACTIONS(470),
    [anon_sym_TILDE] = ACTIONS(470),
    [anon_sym_PLUS_PLUS] = ACTIONS(470),
    [anon_sym_DASH_DASH] = ACTIONS(470),
    [anon_sym_new] = ACTIONS(472),
    [anon_sym_class] = ACTIONS(472),
    [anon_sym_switch] = ACTIONS(472),
    [anon_sym_LBRACE] = ACTIONS(470),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_case] = ACTIONS(472),
    [anon_sym_default] = ACTIONS(472),
    [anon_sym_SEMI] = ACTIONS(470),
    [anon_sym_assert] = ACTIONS(472),
    [anon_sym_do] = ACTIONS(472),
    [anon_sym_while] = ACTIONS(472),
    [anon_sym_break] = ACTIONS(472),
    [anon_sym_continue] = ACTIONS(472),
    [anon_sym_return] = ACTIONS(472),
    [anon_sym_yield] = ACTIONS(472),
    [anon_sym_synchronized] = ACTIONS(472),
    [anon_sym_throw] = ACTIONS(472),
    [anon_sym_try] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_else] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(472),
    [anon_sym_open] = ACTIONS(472),
    [anon_sym_module] = ACTIONS(472),
    [anon_sym_static] = ACTIONS(472),
    [anon_sym_package] = ACTIONS(472),
    [anon_sym_import] = ACTIONS(472),
    [anon_sym_enum] = ACTIONS(472),
    [anon_sym_public] = ACTIONS(472),
    [anon_sym_protected] = ACTIONS(472),
    [anon_sym_private] = ACTIONS(472),
    [anon_sym_abstract] = ACTIONS(472),
    [anon_sym_final] = ACTIONS(472),
    [anon_sym_strictfp] = ACTIONS(472),
    [anon_sym_native] = ACTIONS(472),
    [anon_sym_transient] = ACTIONS(472),
    [anon_sym_volatile] = ACTIONS(472),
    [anon_sym_record] = ACTIONS(472),
    [anon_sym_ATinterface] = ACTIONS(470),
    [anon_sym_interface] = ACTIONS(472),
    [anon_sym_byte] = ACTIONS(472),
    [anon_sym_short] = ACTIONS(472),
    [anon_sym_int] = ACTIONS(472),
    [anon_sym_long] = ACTIONS(472),
    [anon_sym_char] = ACTIONS(472),
    [anon_sym_float] = ACTIONS(472),
    [anon_sym_double] = ACTIONS(472),
    [sym_boolean_type] = ACTIONS(472),
    [sym_void_type] = ACTIONS(472),
    [sym_this] = ACTIONS(472),
    [sym_super] = ACTIONS(472),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(474),
    [sym_identifier] = ACTIONS(476),
    [sym_decimal_integer_literal] = ACTIONS(476),
    [sym_hex_integer_literal] = ACTIONS(476),
    [sym_octal_integer_literal] = ACTIONS(474),
    [sym_binary_integer_literal] = ACTIONS(474),
    [sym_decimal_floating_point_literal] = ACTIONS(474),
    [sym_hex_floating_point_literal] = ACTIONS(476),
    [sym_true] = ACTIONS(476),
    [sym_false] = ACTIONS(476),
    [sym_character_literal] = ACTIONS(474),
    [sym_string_literal] = ACTIONS(474),
    [sym_null_literal] = ACTIONS(476),
    [anon_sym_LPAREN] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(474),
    [anon_sym_PLUS] = ACTIONS(476),
    [anon_sym_DASH] = ACTIONS(476),
    [anon_sym_BANG] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(474),
    [anon_sym_PLUS_PLUS] = ACTIONS(474),
    [anon_sym_DASH_DASH] = ACTIONS(474),
    [anon_sym_new] = ACTIONS(476),
    [anon_sym_class] = ACTIONS(476),
    [anon_sym_switch] = ACTIONS(476),
    [anon_sym_LBRACE] = ACTIONS(474),
    [anon_sym_RBRACE] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(476),
    [anon_sym_default] = ACTIONS(476),
    [anon_sym_SEMI] = ACTIONS(474),
    [anon_sym_assert] = ACTIONS(476),
    [anon_sym_do] = ACTIONS(476),
    [anon_sym_while] = ACTIONS(476),
    [anon_sym_break] = ACTIONS(476),
    [anon_sym_continue] = ACTIONS(476),
    [anon_sym_return] = ACTIONS(476),
    [anon_sym_yield] = ACTIONS(476),
    [anon_sym_synchronized] = ACTIONS(476),
    [anon_sym_throw] = ACTIONS(476),
    [anon_sym_try] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_else] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_AT] = ACTIONS(476),
    [anon_sym_open] = ACTIONS(476),
    [anon_sym_module] = ACTIONS(476),
    [anon_sym_static] = ACTIONS(476),
    [anon_sym_package] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(476),
    [anon_sym_enum] = ACTIONS(476),
    [anon_sym_public] = ACTIONS(476),
    [anon_sym_protected] = ACTIONS(476),
    [anon_sym_private] = ACTIONS(476),
    [anon_sym_abstract] = ACTIONS(476),
    [anon_sym_final] = ACTIONS(476),
    [anon_sym_strictfp] = ACTIONS(476),
    [anon_sym_native] = ACTIONS(476),
    [anon_sym_transient] = ACTIONS(476),
    [anon_sym_volatile] = ACTIONS(476),
    [anon_sym_record] = ACTIONS(476),
    [anon_sym_ATinterface] = ACTIONS(474),
    [anon_sym_interface] = ACTIONS(476),
    [anon_sym_byte] = ACTIONS(476),
    [anon_sym_short] = ACTIONS(476),
    [anon_sym_int] = ACTIONS(476),
    [anon_sym_long] = ACTIONS(476),
    [anon_sym_char] = ACTIONS(476),
    [anon_sym_float] = ACTIONS(476),
    [anon_sym_double] = ACTIONS(476),
    [sym_boolean_type] = ACTIONS(476),
    [sym_void_type] = ACTIONS(476),
    [sym_this] = ACTIONS(476),
    [sym_super] = ACTIONS(476),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(478),
    [sym_identifier] = ACTIONS(480),
    [sym_decimal_integer_literal] = ACTIONS(480),
    [sym_hex_integer_literal] = ACTIONS(480),
    [sym_octal_integer_literal] = ACTIONS(478),
    [sym_binary_integer_literal] = ACTIONS(478),
    [sym_decimal_floating_point_literal] = ACTIONS(478),
    [sym_hex_floating_point_literal] = ACTIONS(480),
    [sym_true] = ACTIONS(480),
    [sym_false] = ACTIONS(480),
    [sym_character_literal] = ACTIONS(478),
    [sym_string_literal] = ACTIONS(478),
    [sym_null_literal] = ACTIONS(480),
    [anon_sym_LPAREN] = ACTIONS(478),
    [anon_sym_LT] = ACTIONS(478),
    [anon_sym_PLUS] = ACTIONS(480),
    [anon_sym_DASH] = ACTIONS(480),
    [anon_sym_BANG] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(478),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [anon_sym_new] = ACTIONS(480),
    [anon_sym_class] = ACTIONS(480),
    [anon_sym_switch] = ACTIONS(480),
    [anon_sym_LBRACE] = ACTIONS(478),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_case] = ACTIONS(480),
    [anon_sym_default] = ACTIONS(480),
    [anon_sym_SEMI] = ACTIONS(478),
    [anon_sym_assert] = ACTIONS(480),
    [anon_sym_do] = ACTIONS(480),
    [anon_sym_while] = ACTIONS(480),
    [anon_sym_break] = ACTIONS(480),
    [anon_sym_continue] = ACTIONS(480),
    [anon_sym_return] = ACTIONS(480),
    [anon_sym_yield] = ACTIONS(480),
    [anon_sym_synchronized] = ACTIONS(480),
    [anon_sym_throw] = ACTIONS(480),
    [anon_sym_try] = ACTIONS(480),
    [anon_sym_if] = ACTIONS(480),
    [anon_sym_else] = ACTIONS(480),
    [anon_sym_for] = ACTIONS(480),
    [anon_sym_AT] = ACTIONS(480),
    [anon_sym_open] = ACTIONS(480),
    [anon_sym_module] = ACTIONS(480),
    [anon_sym_static] = ACTIONS(480),
    [anon_sym_package] = ACTIONS(480),
    [anon_sym_import] = ACTIONS(480),
    [anon_sym_enum] = ACTIONS(480),
    [anon_sym_public] = ACTIONS(480),
    [anon_sym_protected] = ACTIONS(480),
    [anon_sym_private] = ACTIONS(480),
    [anon_sym_abstract] = ACTIONS(480),
    [anon_sym_final] = ACTIONS(480),
    [anon_sym_strictfp] = ACTIONS(480),
    [anon_sym_native] = ACTIONS(480),
    [anon_sym_transient] = ACTIONS(480),
    [anon_sym_volatile] = ACTIONS(480),
    [anon_sym_record] = ACTIONS(480),
    [anon_sym_ATinterface] = ACTIONS(478),
    [anon_sym_interface] = ACTIONS(480),
    [anon_sym_byte] = ACTIONS(480),
    [anon_sym_short] = ACTIONS(480),
    [anon_sym_int] = ACTIONS(480),
    [anon_sym_long] = ACTIONS(480),
    [anon_sym_char] = ACTIONS(480),
    [anon_sym_float] = ACTIONS(480),
    [anon_sym_double] = ACTIONS(480),
    [sym_boolean_type] = ACTIONS(480),
    [sym_void_type] = ACTIONS(480),
    [sym_this] = ACTIONS(480),
    [sym_super] = ACTIONS(480),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(482),
    [sym_identifier] = ACTIONS(484),
    [sym_decimal_integer_literal] = ACTIONS(484),
    [sym_hex_integer_literal] = ACTIONS(484),
    [sym_octal_integer_literal] = ACTIONS(482),
    [sym_binary_integer_literal] = ACTIONS(482),
    [sym_decimal_floating_point_literal] = ACTIONS(482),
    [sym_hex_floating_point_literal] = ACTIONS(484),
    [sym_true] = ACTIONS(484),
    [sym_false] = ACTIONS(484),
    [sym_character_literal] = ACTIONS(482),
    [sym_string_literal] = ACTIONS(482),
    [sym_null_literal] = ACTIONS(484),
    [anon_sym_LPAREN] = ACTIONS(482),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_PLUS] = ACTIONS(484),
    [anon_sym_DASH] = ACTIONS(484),
    [anon_sym_BANG] = ACTIONS(482),
    [anon_sym_TILDE] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(482),
    [anon_sym_DASH_DASH] = ACTIONS(482),
    [anon_sym_new] = ACTIONS(484),
    [anon_sym_class] = ACTIONS(484),
    [anon_sym_switch] = ACTIONS(484),
    [anon_sym_LBRACE] = ACTIONS(482),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_case] = ACTIONS(484),
    [anon_sym_default] = ACTIONS(484),
    [anon_sym_SEMI] = ACTIONS(482),
    [anon_sym_assert] = ACTIONS(484),
    [anon_sym_do] = ACTIONS(484),
    [anon_sym_while] = ACTIONS(484),
    [anon_sym_break] = ACTIONS(484),
    [anon_sym_continue] = ACTIONS(484),
    [anon_sym_return] = ACTIONS(484),
    [anon_sym_yield] = ACTIONS(484),
    [anon_sym_synchronized] = ACTIONS(484),
    [anon_sym_throw] = ACTIONS(484),
    [anon_sym_try] = ACTIONS(484),
    [anon_sym_if] = ACTIONS(484),
    [anon_sym_else] = ACTIONS(484),
    [anon_sym_for] = ACTIONS(484),
    [anon_sym_AT] = ACTIONS(484),
    [anon_sym_open] = ACTIONS(484),
    [anon_sym_module] = ACTIONS(484),
    [anon_sym_static] = ACTIONS(484),
    [anon_sym_package] = ACTIONS(484),
    [anon_sym_import] = ACTIONS(484),
    [anon_sym_enum] = ACTIONS(484),
    [anon_sym_public] = ACTIONS(484),
    [anon_sym_protected] = ACTIONS(484),
    [anon_sym_private] = ACTIONS(484),
    [anon_sym_abstract] = ACTIONS(484),
    [anon_sym_final] = ACTIONS(484),
    [anon_sym_strictfp] = ACTIONS(484),
    [anon_sym_native] = ACTIONS(484),
    [anon_sym_transient] = ACTIONS(484),
    [anon_sym_volatile] = ACTIONS(484),
    [anon_sym_record] = ACTIONS(484),
    [anon_sym_ATinterface] = ACTIONS(482),
    [anon_sym_interface] = ACTIONS(484),
    [anon_sym_byte] = ACTIONS(484),
    [anon_sym_short] = ACTIONS(484),
    [anon_sym_int] = ACTIONS(484),
    [anon_sym_long] = ACTIONS(484),
    [anon_sym_char] = ACTIONS(484),
    [anon_sym_float] = ACTIONS(484),
    [anon_sym_double] = ACTIONS(484),
    [sym_boolean_type] = ACTIONS(484),
    [sym_void_type] = ACTIONS(484),
    [sym_this] = ACTIONS(484),
    [sym_super] = ACTIONS(484),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(486),
    [sym_identifier] = ACTIONS(488),
    [sym_decimal_integer_literal] = ACTIONS(488),
    [sym_hex_integer_literal] = ACTIONS(488),
    [sym_octal_integer_literal] = ACTIONS(486),
    [sym_binary_integer_literal] = ACTIONS(486),
    [sym_decimal_floating_point_literal] = ACTIONS(486),
    [sym_hex_floating_point_literal] = ACTIONS(488),
    [sym_true] = ACTIONS(488),
    [sym_false] = ACTIONS(488),
    [sym_character_literal] = ACTIONS(486),
    [sym_string_literal] = ACTIONS(486),
    [sym_null_literal] = ACTIONS(488),
    [anon_sym_LPAREN] = ACTIONS(486),
    [anon_sym_LT] = ACTIONS(486),
    [anon_sym_PLUS] = ACTIONS(488),
    [anon_sym_DASH] = ACTIONS(488),
    [anon_sym_BANG] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(486),
    [anon_sym_PLUS_PLUS] = ACTIONS(486),
    [anon_sym_DASH_DASH] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(488),
    [anon_sym_class] = ACTIONS(488),
    [anon_sym_switch] = ACTIONS(488),
    [anon_sym_LBRACE] = ACTIONS(486),
    [anon_sym_RBRACE] = ACTIONS(486),
    [anon_sym_case] = ACTIONS(488),
    [anon_sym_default] = ACTIONS(488),
    [anon_sym_SEMI] = ACTIONS(486),
    [anon_sym_assert] = ACTIONS(488),
    [anon_sym_do] = ACTIONS(488),
    [anon_sym_while] = ACTIONS(488),
    [anon_sym_break] = ACTIONS(488),
    [anon_sym_continue] = ACTIONS(488),
    [anon_sym_return] = ACTIONS(488),
    [anon_sym_yield] = ACTIONS(488),
    [anon_sym_synchronized] = ACTIONS(488),
    [anon_sym_throw] = ACTIONS(488),
    [anon_sym_try] = ACTIONS(488),
    [anon_sym_if] = ACTIONS(488),
    [anon_sym_else] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(488),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_open] = ACTIONS(488),
    [anon_sym_module] = ACTIONS(488),
    [anon_sym_static] = ACTIONS(488),
    [anon_sym_package] = ACTIONS(488),
    [anon_sym_import] = ACTIONS(488),
    [anon_sym_enum] = ACTIONS(488),
    [anon_sym_public] = ACTIONS(488),
    [anon_sym_protected] = ACTIONS(488),
    [anon_sym_private] = ACTIONS(488),
    [anon_sym_abstract] = ACTIONS(488),
    [anon_sym_final] = ACTIONS(488),
    [anon_sym_strictfp] = ACTIONS(488),
    [anon_sym_native] = ACTIONS(488),
    [anon_sym_transient] = ACTIONS(488),
    [anon_sym_volatile] = ACTIONS(488),
    [anon_sym_record] = ACTIONS(488),
    [anon_sym_ATinterface] = ACTIONS(486),
    [anon_sym_interface] = ACTIONS(488),
    [anon_sym_byte] = ACTIONS(488),
    [anon_sym_short] = ACTIONS(488),
    [anon_sym_int] = ACTIONS(488),
    [anon_sym_long] = ACTIONS(488),
    [anon_sym_char] = ACTIONS(488),
    [anon_sym_float] = ACTIONS(488),
    [anon_sym_double] = ACTIONS(488),
    [sym_boolean_type] = ACTIONS(488),
    [sym_void_type] = ACTIONS(488),
    [sym_this] = ACTIONS(488),
    [sym_super] = ACTIONS(488),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(490),
    [sym_identifier] = ACTIONS(492),
    [sym_decimal_integer_literal] = ACTIONS(492),
    [sym_hex_integer_literal] = ACTIONS(492),
    [sym_octal_integer_literal] = ACTIONS(490),
    [sym_binary_integer_literal] = ACTIONS(490),
    [sym_decimal_floating_point_literal] = ACTIONS(490),
    [sym_hex_floating_point_literal] = ACTIONS(492),
    [sym_true] = ACTIONS(492),
    [sym_false] = ACTIONS(492),
    [sym_character_literal] = ACTIONS(490),
    [sym_string_literal] = ACTIONS(490),
    [sym_null_literal] = ACTIONS(492),
    [anon_sym_LPAREN] = ACTIONS(490),
    [anon_sym_LT] = ACTIONS(490),
    [anon_sym_PLUS] = ACTIONS(492),
    [anon_sym_DASH] = ACTIONS(492),
    [anon_sym_BANG] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(490),
    [anon_sym_PLUS_PLUS] = ACTIONS(490),
    [anon_sym_DASH_DASH] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(492),
    [anon_sym_class] = ACTIONS(492),
    [anon_sym_switch] = ACTIONS(492),
    [anon_sym_LBRACE] = ACTIONS(490),
    [anon_sym_RBRACE] = ACTIONS(490),
    [anon_sym_case] = ACTIONS(492),
    [anon_sym_default] = ACTIONS(492),
    [anon_sym_SEMI] = ACTIONS(490),
    [anon_sym_assert] = ACTIONS(492),
    [anon_sym_do] = ACTIONS(492),
    [anon_sym_while] = ACTIONS(492),
    [anon_sym_break] = ACTIONS(492),
    [anon_sym_continue] = ACTIONS(492),
    [anon_sym_return] = ACTIONS(492),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_synchronized] = ACTIONS(492),
    [anon_sym_throw] = ACTIONS(492),
    [anon_sym_try] = ACTIONS(492),
    [anon_sym_if] = ACTIONS(492),
    [anon_sym_else] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(492),
    [anon_sym_AT] = ACTIONS(492),
    [anon_sym_open] = ACTIONS(492),
    [anon_sym_module] = ACTIONS(492),
    [anon_sym_static] = ACTIONS(492),
    [anon_sym_package] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(492),
    [anon_sym_public] = ACTIONS(492),
    [anon_sym_protected] = ACTIONS(492),
    [anon_sym_private] = ACTIONS(492),
    [anon_sym_abstract] = ACTIONS(492),
    [anon_sym_final] = ACTIONS(492),
    [anon_sym_strictfp] = ACTIONS(492),
    [anon_sym_native] = ACTIONS(492),
    [anon_sym_transient] = ACTIONS(492),
    [anon_sym_volatile] = ACTIONS(492),
    [anon_sym_record] = ACTIONS(492),
    [anon_sym_ATinterface] = ACTIONS(490),
    [anon_sym_interface] = ACTIONS(492),
    [anon_sym_byte] = ACTIONS(492),
    [anon_sym_short] = ACTIONS(492),
    [anon_sym_int] = ACTIONS(492),
    [anon_sym_long] = ACTIONS(492),
    [anon_sym_char] = ACTIONS(492),
    [anon_sym_float] = ACTIONS(492),
    [anon_sym_double] = ACTIONS(492),
    [sym_boolean_type] = ACTIONS(492),
    [sym_void_type] = ACTIONS(492),
    [sym_this] = ACTIONS(492),
    [sym_super] = ACTIONS(492),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(494),
    [sym_identifier] = ACTIONS(496),
    [sym_decimal_integer_literal] = ACTIONS(496),
    [sym_hex_integer_literal] = ACTIONS(496),
    [sym_octal_integer_literal] = ACTIONS(494),
    [sym_binary_integer_literal] = ACTIONS(494),
    [sym_decimal_floating_point_literal] = ACTIONS(494),
    [sym_hex_floating_point_literal] = ACTIONS(496),
    [sym_true] = ACTIONS(496),
    [sym_false] = ACTIONS(496),
    [sym_character_literal] = ACTIONS(494),
    [sym_string_literal] = ACTIONS(494),
    [sym_null_literal] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(494),
    [anon_sym_LT] = ACTIONS(494),
    [anon_sym_PLUS] = ACTIONS(496),
    [anon_sym_DASH] = ACTIONS(496),
    [anon_sym_BANG] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(494),
    [anon_sym_PLUS_PLUS] = ACTIONS(494),
    [anon_sym_DASH_DASH] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_class] = ACTIONS(496),
    [anon_sym_switch] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(494),
    [anon_sym_RBRACE] = ACTIONS(494),
    [anon_sym_case] = ACTIONS(496),
    [anon_sym_default] = ACTIONS(496),
    [anon_sym_SEMI] = ACTIONS(494),
    [anon_sym_assert] = ACTIONS(496),
    [anon_sym_do] = ACTIONS(496),
    [anon_sym_while] = ACTIONS(496),
    [anon_sym_break] = ACTIONS(496),
    [anon_sym_continue] = ACTIONS(496),
    [anon_sym_return] = ACTIONS(496),
    [anon_sym_yield] = ACTIONS(496),
    [anon_sym_synchronized] = ACTIONS(496),
    [anon_sym_throw] = ACTIONS(496),
    [anon_sym_try] = ACTIONS(496),
    [anon_sym_if] = ACTIONS(496),
    [anon_sym_else] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(496),
    [anon_sym_AT] = ACTIONS(496),
    [anon_sym_open] = ACTIONS(496),
    [anon_sym_module] = ACTIONS(496),
    [anon_sym_static] = ACTIONS(496),
    [anon_sym_package] = ACTIONS(496),
    [anon_sym_import] = ACTIONS(496),
    [anon_sym_enum] = ACTIONS(496),
    [anon_sym_public] = ACTIONS(496),
    [anon_sym_protected] = ACTIONS(496),
    [anon_sym_private] = ACTIONS(496),
    [anon_sym_abstract] = ACTIONS(496),
    [anon_sym_final] = ACTIONS(496),
    [anon_sym_strictfp] = ACTIONS(496),
    [anon_sym_native] = ACTIONS(496),
    [anon_sym_transient] = ACTIONS(496),
    [anon_sym_volatile] = ACTIONS(496),
    [anon_sym_record] = ACTIONS(496),
    [anon_sym_ATinterface] = ACTIONS(494),
    [anon_sym_interface] = ACTIONS(496),
    [anon_sym_byte] = ACTIONS(496),
    [anon_sym_short] = ACTIONS(496),
    [anon_sym_int] = ACTIONS(496),
    [anon_sym_long] = ACTIONS(496),
    [anon_sym_char] = ACTIONS(496),
    [anon_sym_float] = ACTIONS(496),
    [anon_sym_double] = ACTIONS(496),
    [sym_boolean_type] = ACTIONS(496),
    [sym_void_type] = ACTIONS(496),
    [sym_this] = ACTIONS(496),
    [sym_super] = ACTIONS(496),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [116] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(487),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym_array_initializer] = STATE(917),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(498),
    [sym_identifier] = ACTIONS(500),
    [sym_decimal_integer_literal] = ACTIONS(500),
    [sym_hex_integer_literal] = ACTIONS(500),
    [sym_octal_integer_literal] = ACTIONS(498),
    [sym_binary_integer_literal] = ACTIONS(498),
    [sym_decimal_floating_point_literal] = ACTIONS(498),
    [sym_hex_floating_point_literal] = ACTIONS(500),
    [sym_true] = ACTIONS(500),
    [sym_false] = ACTIONS(500),
    [sym_character_literal] = ACTIONS(498),
    [sym_string_literal] = ACTIONS(498),
    [sym_null_literal] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(498),
    [anon_sym_LT] = ACTIONS(498),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(498),
    [anon_sym_DASH_DASH] = ACTIONS(498),
    [anon_sym_new] = ACTIONS(500),
    [anon_sym_class] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [anon_sym_LBRACE] = ACTIONS(498),
    [anon_sym_RBRACE] = ACTIONS(498),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_default] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(498),
    [anon_sym_assert] = ACTIONS(500),
    [anon_sym_do] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_break] = ACTIONS(500),
    [anon_sym_continue] = ACTIONS(500),
    [anon_sym_return] = ACTIONS(500),
    [anon_sym_yield] = ACTIONS(500),
    [anon_sym_synchronized] = ACTIONS(500),
    [anon_sym_throw] = ACTIONS(500),
    [anon_sym_try] = ACTIONS(500),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_else] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_AT] = ACTIONS(500),
    [anon_sym_open] = ACTIONS(500),
    [anon_sym_module] = ACTIONS(500),
    [anon_sym_static] = ACTIONS(500),
    [anon_sym_package] = ACTIONS(500),
    [anon_sym_import] = ACTIONS(500),
    [anon_sym_enum] = ACTIONS(500),
    [anon_sym_public] = ACTIONS(500),
    [anon_sym_protected] = ACTIONS(500),
    [anon_sym_private] = ACTIONS(500),
    [anon_sym_abstract] = ACTIONS(500),
    [anon_sym_final] = ACTIONS(500),
    [anon_sym_strictfp] = ACTIONS(500),
    [anon_sym_native] = ACTIONS(500),
    [anon_sym_transient] = ACTIONS(500),
    [anon_sym_volatile] = ACTIONS(500),
    [anon_sym_record] = ACTIONS(500),
    [anon_sym_ATinterface] = ACTIONS(498),
    [anon_sym_interface] = ACTIONS(500),
    [anon_sym_byte] = ACTIONS(500),
    [anon_sym_short] = ACTIONS(500),
    [anon_sym_int] = ACTIONS(500),
    [anon_sym_long] = ACTIONS(500),
    [anon_sym_char] = ACTIONS(500),
    [anon_sym_float] = ACTIONS(500),
    [anon_sym_double] = ACTIONS(500),
    [sym_boolean_type] = ACTIONS(500),
    [sym_void_type] = ACTIONS(500),
    [sym_this] = ACTIONS(500),
    [sym_super] = ACTIONS(500),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(502),
    [sym_identifier] = ACTIONS(504),
    [sym_decimal_integer_literal] = ACTIONS(504),
    [sym_hex_integer_literal] = ACTIONS(504),
    [sym_octal_integer_literal] = ACTIONS(502),
    [sym_binary_integer_literal] = ACTIONS(502),
    [sym_decimal_floating_point_literal] = ACTIONS(502),
    [sym_hex_floating_point_literal] = ACTIONS(504),
    [sym_true] = ACTIONS(504),
    [sym_false] = ACTIONS(504),
    [sym_character_literal] = ACTIONS(502),
    [sym_string_literal] = ACTIONS(502),
    [sym_null_literal] = ACTIONS(504),
    [anon_sym_LPAREN] = ACTIONS(502),
    [anon_sym_LT] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(504),
    [anon_sym_DASH] = ACTIONS(504),
    [anon_sym_BANG] = ACTIONS(502),
    [anon_sym_TILDE] = ACTIONS(502),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [anon_sym_new] = ACTIONS(504),
    [anon_sym_class] = ACTIONS(504),
    [anon_sym_switch] = ACTIONS(504),
    [anon_sym_LBRACE] = ACTIONS(502),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_case] = ACTIONS(504),
    [anon_sym_default] = ACTIONS(504),
    [anon_sym_SEMI] = ACTIONS(502),
    [anon_sym_assert] = ACTIONS(504),
    [anon_sym_do] = ACTIONS(504),
    [anon_sym_while] = ACTIONS(504),
    [anon_sym_break] = ACTIONS(504),
    [anon_sym_continue] = ACTIONS(504),
    [anon_sym_return] = ACTIONS(504),
    [anon_sym_yield] = ACTIONS(504),
    [anon_sym_synchronized] = ACTIONS(504),
    [anon_sym_throw] = ACTIONS(504),
    [anon_sym_try] = ACTIONS(504),
    [anon_sym_if] = ACTIONS(504),
    [anon_sym_else] = ACTIONS(504),
    [anon_sym_for] = ACTIONS(504),
    [anon_sym_AT] = ACTIONS(504),
    [anon_sym_open] = ACTIONS(504),
    [anon_sym_module] = ACTIONS(504),
    [anon_sym_static] = ACTIONS(504),
    [anon_sym_package] = ACTIONS(504),
    [anon_sym_import] = ACTIONS(504),
    [anon_sym_enum] = ACTIONS(504),
    [anon_sym_public] = ACTIONS(504),
    [anon_sym_protected] = ACTIONS(504),
    [anon_sym_private] = ACTIONS(504),
    [anon_sym_abstract] = ACTIONS(504),
    [anon_sym_final] = ACTIONS(504),
    [anon_sym_strictfp] = ACTIONS(504),
    [anon_sym_native] = ACTIONS(504),
    [anon_sym_transient] = ACTIONS(504),
    [anon_sym_volatile] = ACTIONS(504),
    [anon_sym_record] = ACTIONS(504),
    [anon_sym_ATinterface] = ACTIONS(502),
    [anon_sym_interface] = ACTIONS(504),
    [anon_sym_byte] = ACTIONS(504),
    [anon_sym_short] = ACTIONS(504),
    [anon_sym_int] = ACTIONS(504),
    [anon_sym_long] = ACTIONS(504),
    [anon_sym_char] = ACTIONS(504),
    [anon_sym_float] = ACTIONS(504),
    [anon_sym_double] = ACTIONS(504),
    [sym_boolean_type] = ACTIONS(504),
    [sym_void_type] = ACTIONS(504),
    [sym_this] = ACTIONS(504),
    [sym_super] = ACTIONS(504),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(243),
    [sym_identifier] = ACTIONS(245),
    [sym_decimal_integer_literal] = ACTIONS(245),
    [sym_hex_integer_literal] = ACTIONS(245),
    [sym_octal_integer_literal] = ACTIONS(243),
    [sym_binary_integer_literal] = ACTIONS(243),
    [sym_decimal_floating_point_literal] = ACTIONS(243),
    [sym_hex_floating_point_literal] = ACTIONS(245),
    [sym_true] = ACTIONS(245),
    [sym_false] = ACTIONS(245),
    [sym_character_literal] = ACTIONS(243),
    [sym_string_literal] = ACTIONS(243),
    [sym_null_literal] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(243),
    [anon_sym_PLUS] = ACTIONS(245),
    [anon_sym_DASH] = ACTIONS(245),
    [anon_sym_BANG] = ACTIONS(243),
    [anon_sym_TILDE] = ACTIONS(243),
    [anon_sym_PLUS_PLUS] = ACTIONS(243),
    [anon_sym_DASH_DASH] = ACTIONS(243),
    [anon_sym_new] = ACTIONS(245),
    [anon_sym_class] = ACTIONS(245),
    [anon_sym_switch] = ACTIONS(245),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_case] = ACTIONS(245),
    [anon_sym_default] = ACTIONS(245),
    [anon_sym_SEMI] = ACTIONS(243),
    [anon_sym_assert] = ACTIONS(245),
    [anon_sym_do] = ACTIONS(245),
    [anon_sym_while] = ACTIONS(245),
    [anon_sym_break] = ACTIONS(245),
    [anon_sym_continue] = ACTIONS(245),
    [anon_sym_return] = ACTIONS(245),
    [anon_sym_yield] = ACTIONS(245),
    [anon_sym_synchronized] = ACTIONS(245),
    [anon_sym_throw] = ACTIONS(245),
    [anon_sym_try] = ACTIONS(245),
    [anon_sym_catch] = ACTIONS(245),
    [anon_sym_finally] = ACTIONS(245),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_else] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(245),
    [anon_sym_AT] = ACTIONS(245),
    [anon_sym_open] = ACTIONS(245),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_static] = ACTIONS(245),
    [anon_sym_package] = ACTIONS(245),
    [anon_sym_import] = ACTIONS(245),
    [anon_sym_enum] = ACTIONS(245),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_abstract] = ACTIONS(245),
    [anon_sym_final] = ACTIONS(245),
    [anon_sym_strictfp] = ACTIONS(245),
    [anon_sym_native] = ACTIONS(245),
    [anon_sym_transient] = ACTIONS(245),
    [anon_sym_volatile] = ACTIONS(245),
    [anon_sym_ATinterface] = ACTIONS(243),
    [anon_sym_interface] = ACTIONS(245),
    [anon_sym_byte] = ACTIONS(245),
    [anon_sym_short] = ACTIONS(245),
    [anon_sym_int] = ACTIONS(245),
    [anon_sym_long] = ACTIONS(245),
    [anon_sym_char] = ACTIONS(245),
    [anon_sym_float] = ACTIONS(245),
    [anon_sym_double] = ACTIONS(245),
    [sym_boolean_type] = ACTIONS(245),
    [sym_void_type] = ACTIONS(245),
    [sym_this] = ACTIONS(245),
    [sym_super] = ACTIONS(245),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [120] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(484),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(506),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [121] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(502),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [122] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(473),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [123] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(514),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [124] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(514),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [125] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(486),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(516),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [126] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(512),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(518),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [127] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(520),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(520),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [128] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(497),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [129] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(472),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(524),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [130] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(526),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [131] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(468),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(528),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [132] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(504),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [133] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(479),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(532),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [134] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(455),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(534),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [135] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(481),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(536),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [136] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(512),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(538),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [137] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(459),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(540),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [sym_decimal_integer_literal] = ACTIONS(544),
    [sym_hex_integer_literal] = ACTIONS(544),
    [sym_octal_integer_literal] = ACTIONS(542),
    [sym_binary_integer_literal] = ACTIONS(542),
    [sym_decimal_floating_point_literal] = ACTIONS(542),
    [sym_hex_floating_point_literal] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_character_literal] = ACTIONS(542),
    [sym_string_literal] = ACTIONS(542),
    [sym_null_literal] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_BANG] = ACTIONS(542),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_assert] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_yield] = ACTIONS(544),
    [anon_sym_synchronized] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_open] = ACTIONS(544),
    [anon_sym_module] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_package] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_enum] = ACTIONS(544),
    [anon_sym_public] = ACTIONS(544),
    [anon_sym_protected] = ACTIONS(544),
    [anon_sym_private] = ACTIONS(544),
    [anon_sym_abstract] = ACTIONS(544),
    [anon_sym_final] = ACTIONS(544),
    [anon_sym_strictfp] = ACTIONS(544),
    [anon_sym_native] = ACTIONS(544),
    [anon_sym_transient] = ACTIONS(544),
    [anon_sym_volatile] = ACTIONS(544),
    [anon_sym_ATinterface] = ACTIONS(542),
    [anon_sym_interface] = ACTIONS(544),
    [anon_sym_byte] = ACTIONS(544),
    [anon_sym_short] = ACTIONS(544),
    [anon_sym_int] = ACTIONS(544),
    [anon_sym_long] = ACTIONS(544),
    [anon_sym_char] = ACTIONS(544),
    [anon_sym_float] = ACTIONS(544),
    [anon_sym_double] = ACTIONS(544),
    [sym_boolean_type] = ACTIONS(544),
    [sym_void_type] = ACTIONS(544),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(546),
    [sym_identifier] = ACTIONS(548),
    [sym_decimal_integer_literal] = ACTIONS(548),
    [sym_hex_integer_literal] = ACTIONS(548),
    [sym_octal_integer_literal] = ACTIONS(546),
    [sym_binary_integer_literal] = ACTIONS(546),
    [sym_decimal_floating_point_literal] = ACTIONS(546),
    [sym_hex_floating_point_literal] = ACTIONS(548),
    [sym_true] = ACTIONS(548),
    [sym_false] = ACTIONS(548),
    [sym_character_literal] = ACTIONS(546),
    [sym_string_literal] = ACTIONS(546),
    [sym_null_literal] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(548),
    [anon_sym_DASH] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(546),
    [anon_sym_DASH_DASH] = ACTIONS(546),
    [anon_sym_new] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(548),
    [anon_sym_switch] = ACTIONS(548),
    [anon_sym_LBRACE] = ACTIONS(546),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_case] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(548),
    [anon_sym_SEMI] = ACTIONS(546),
    [anon_sym_assert] = ACTIONS(548),
    [anon_sym_do] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(548),
    [anon_sym_break] = ACTIONS(548),
    [anon_sym_continue] = ACTIONS(548),
    [anon_sym_return] = ACTIONS(548),
    [anon_sym_yield] = ACTIONS(548),
    [anon_sym_synchronized] = ACTIONS(548),
    [anon_sym_throw] = ACTIONS(548),
    [anon_sym_try] = ACTIONS(548),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_else] = ACTIONS(548),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(548),
    [anon_sym_open] = ACTIONS(548),
    [anon_sym_module] = ACTIONS(548),
    [anon_sym_static] = ACTIONS(548),
    [anon_sym_package] = ACTIONS(548),
    [anon_sym_import] = ACTIONS(548),
    [anon_sym_enum] = ACTIONS(548),
    [anon_sym_public] = ACTIONS(548),
    [anon_sym_protected] = ACTIONS(548),
    [anon_sym_private] = ACTIONS(548),
    [anon_sym_abstract] = ACTIONS(548),
    [anon_sym_final] = ACTIONS(548),
    [anon_sym_strictfp] = ACTIONS(548),
    [anon_sym_native] = ACTIONS(548),
    [anon_sym_transient] = ACTIONS(548),
    [anon_sym_volatile] = ACTIONS(548),
    [anon_sym_ATinterface] = ACTIONS(546),
    [anon_sym_interface] = ACTIONS(548),
    [anon_sym_byte] = ACTIONS(548),
    [anon_sym_short] = ACTIONS(548),
    [anon_sym_int] = ACTIONS(548),
    [anon_sym_long] = ACTIONS(548),
    [anon_sym_char] = ACTIONS(548),
    [anon_sym_float] = ACTIONS(548),
    [anon_sym_double] = ACTIONS(548),
    [sym_boolean_type] = ACTIONS(548),
    [sym_void_type] = ACTIONS(548),
    [sym_this] = ACTIONS(548),
    [sym_super] = ACTIONS(548),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [140] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(437),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [141] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(425),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [142] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(427),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [143] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(436),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [144] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(417),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [145] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(424),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [146] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(440),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [147] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(428),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(550),
    [sym_identifier] = ACTIONS(552),
    [sym_decimal_integer_literal] = ACTIONS(552),
    [sym_hex_integer_literal] = ACTIONS(552),
    [sym_octal_integer_literal] = ACTIONS(550),
    [sym_binary_integer_literal] = ACTIONS(550),
    [sym_decimal_floating_point_literal] = ACTIONS(550),
    [sym_hex_floating_point_literal] = ACTIONS(552),
    [sym_true] = ACTIONS(552),
    [sym_false] = ACTIONS(552),
    [sym_character_literal] = ACTIONS(550),
    [sym_string_literal] = ACTIONS(550),
    [sym_null_literal] = ACTIONS(552),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_PLUS] = ACTIONS(552),
    [anon_sym_DASH] = ACTIONS(552),
    [anon_sym_BANG] = ACTIONS(550),
    [anon_sym_TILDE] = ACTIONS(550),
    [anon_sym_PLUS_PLUS] = ACTIONS(550),
    [anon_sym_DASH_DASH] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(552),
    [anon_sym_switch] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(550),
    [anon_sym_case] = ACTIONS(552),
    [anon_sym_default] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(550),
    [anon_sym_assert] = ACTIONS(552),
    [anon_sym_do] = ACTIONS(552),
    [anon_sym_while] = ACTIONS(552),
    [anon_sym_break] = ACTIONS(552),
    [anon_sym_continue] = ACTIONS(552),
    [anon_sym_return] = ACTIONS(552),
    [anon_sym_yield] = ACTIONS(552),
    [anon_sym_synchronized] = ACTIONS(552),
    [anon_sym_throw] = ACTIONS(552),
    [anon_sym_try] = ACTIONS(552),
    [anon_sym_if] = ACTIONS(552),
    [anon_sym_else] = ACTIONS(552),
    [anon_sym_for] = ACTIONS(552),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_open] = ACTIONS(552),
    [anon_sym_module] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(552),
    [anon_sym_package] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(552),
    [anon_sym_enum] = ACTIONS(552),
    [anon_sym_public] = ACTIONS(552),
    [anon_sym_protected] = ACTIONS(552),
    [anon_sym_private] = ACTIONS(552),
    [anon_sym_abstract] = ACTIONS(552),
    [anon_sym_final] = ACTIONS(552),
    [anon_sym_strictfp] = ACTIONS(552),
    [anon_sym_native] = ACTIONS(552),
    [anon_sym_transient] = ACTIONS(552),
    [anon_sym_volatile] = ACTIONS(552),
    [anon_sym_ATinterface] = ACTIONS(550),
    [anon_sym_interface] = ACTIONS(552),
    [anon_sym_byte] = ACTIONS(552),
    [anon_sym_short] = ACTIONS(552),
    [anon_sym_int] = ACTIONS(552),
    [anon_sym_long] = ACTIONS(552),
    [anon_sym_char] = ACTIONS(552),
    [anon_sym_float] = ACTIONS(552),
    [anon_sym_double] = ACTIONS(552),
    [sym_boolean_type] = ACTIONS(552),
    [sym_void_type] = ACTIONS(552),
    [sym_this] = ACTIONS(552),
    [sym_super] = ACTIONS(552),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [149] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(496),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(554),
    [sym_identifier] = ACTIONS(556),
    [sym_decimal_integer_literal] = ACTIONS(556),
    [sym_hex_integer_literal] = ACTIONS(556),
    [sym_octal_integer_literal] = ACTIONS(554),
    [sym_binary_integer_literal] = ACTIONS(554),
    [sym_decimal_floating_point_literal] = ACTIONS(554),
    [sym_hex_floating_point_literal] = ACTIONS(556),
    [sym_true] = ACTIONS(556),
    [sym_false] = ACTIONS(556),
    [sym_character_literal] = ACTIONS(554),
    [sym_string_literal] = ACTIONS(554),
    [sym_null_literal] = ACTIONS(556),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_TILDE] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(554),
    [anon_sym_DASH_DASH] = ACTIONS(554),
    [anon_sym_new] = ACTIONS(556),
    [anon_sym_class] = ACTIONS(556),
    [anon_sym_switch] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(556),
    [anon_sym_default] = ACTIONS(556),
    [anon_sym_SEMI] = ACTIONS(554),
    [anon_sym_assert] = ACTIONS(556),
    [anon_sym_do] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(556),
    [anon_sym_continue] = ACTIONS(556),
    [anon_sym_return] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(556),
    [anon_sym_synchronized] = ACTIONS(556),
    [anon_sym_throw] = ACTIONS(556),
    [anon_sym_try] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_else] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(556),
    [anon_sym_open] = ACTIONS(556),
    [anon_sym_module] = ACTIONS(556),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_package] = ACTIONS(556),
    [anon_sym_import] = ACTIONS(556),
    [anon_sym_enum] = ACTIONS(556),
    [anon_sym_public] = ACTIONS(556),
    [anon_sym_protected] = ACTIONS(556),
    [anon_sym_private] = ACTIONS(556),
    [anon_sym_abstract] = ACTIONS(556),
    [anon_sym_final] = ACTIONS(556),
    [anon_sym_strictfp] = ACTIONS(556),
    [anon_sym_native] = ACTIONS(556),
    [anon_sym_transient] = ACTIONS(556),
    [anon_sym_volatile] = ACTIONS(556),
    [anon_sym_ATinterface] = ACTIONS(554),
    [anon_sym_interface] = ACTIONS(556),
    [anon_sym_byte] = ACTIONS(556),
    [anon_sym_short] = ACTIONS(556),
    [anon_sym_int] = ACTIONS(556),
    [anon_sym_long] = ACTIONS(556),
    [anon_sym_char] = ACTIONS(556),
    [anon_sym_float] = ACTIONS(556),
    [anon_sym_double] = ACTIONS(556),
    [sym_boolean_type] = ACTIONS(556),
    [sym_void_type] = ACTIONS(556),
    [sym_this] = ACTIONS(556),
    [sym_super] = ACTIONS(556),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(558),
    [sym_identifier] = ACTIONS(560),
    [sym_decimal_integer_literal] = ACTIONS(560),
    [sym_hex_integer_literal] = ACTIONS(560),
    [sym_octal_integer_literal] = ACTIONS(558),
    [sym_binary_integer_literal] = ACTIONS(558),
    [sym_decimal_floating_point_literal] = ACTIONS(558),
    [sym_hex_floating_point_literal] = ACTIONS(560),
    [sym_true] = ACTIONS(560),
    [sym_false] = ACTIONS(560),
    [sym_character_literal] = ACTIONS(558),
    [sym_string_literal] = ACTIONS(558),
    [sym_null_literal] = ACTIONS(560),
    [anon_sym_LPAREN] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(560),
    [anon_sym_DASH] = ACTIONS(560),
    [anon_sym_BANG] = ACTIONS(558),
    [anon_sym_TILDE] = ACTIONS(558),
    [anon_sym_PLUS_PLUS] = ACTIONS(558),
    [anon_sym_DASH_DASH] = ACTIONS(558),
    [anon_sym_new] = ACTIONS(560),
    [anon_sym_class] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(560),
    [anon_sym_LBRACE] = ACTIONS(558),
    [anon_sym_RBRACE] = ACTIONS(558),
    [anon_sym_case] = ACTIONS(560),
    [anon_sym_default] = ACTIONS(560),
    [anon_sym_SEMI] = ACTIONS(558),
    [anon_sym_assert] = ACTIONS(560),
    [anon_sym_do] = ACTIONS(560),
    [anon_sym_while] = ACTIONS(560),
    [anon_sym_break] = ACTIONS(560),
    [anon_sym_continue] = ACTIONS(560),
    [anon_sym_return] = ACTIONS(560),
    [anon_sym_yield] = ACTIONS(560),
    [anon_sym_synchronized] = ACTIONS(560),
    [anon_sym_throw] = ACTIONS(560),
    [anon_sym_try] = ACTIONS(560),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_else] = ACTIONS(560),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(560),
    [anon_sym_open] = ACTIONS(560),
    [anon_sym_module] = ACTIONS(560),
    [anon_sym_static] = ACTIONS(560),
    [anon_sym_package] = ACTIONS(560),
    [anon_sym_import] = ACTIONS(560),
    [anon_sym_enum] = ACTIONS(560),
    [anon_sym_public] = ACTIONS(560),
    [anon_sym_protected] = ACTIONS(560),
    [anon_sym_private] = ACTIONS(560),
    [anon_sym_abstract] = ACTIONS(560),
    [anon_sym_final] = ACTIONS(560),
    [anon_sym_strictfp] = ACTIONS(560),
    [anon_sym_native] = ACTIONS(560),
    [anon_sym_transient] = ACTIONS(560),
    [anon_sym_volatile] = ACTIONS(560),
    [anon_sym_ATinterface] = ACTIONS(558),
    [anon_sym_interface] = ACTIONS(560),
    [anon_sym_byte] = ACTIONS(560),
    [anon_sym_short] = ACTIONS(560),
    [anon_sym_int] = ACTIONS(560),
    [anon_sym_long] = ACTIONS(560),
    [anon_sym_char] = ACTIONS(560),
    [anon_sym_float] = ACTIONS(560),
    [anon_sym_double] = ACTIONS(560),
    [sym_boolean_type] = ACTIONS(560),
    [sym_void_type] = ACTIONS(560),
    [sym_this] = ACTIONS(560),
    [sym_super] = ACTIONS(560),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [152] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(515),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(562),
    [sym_identifier] = ACTIONS(564),
    [sym_decimal_integer_literal] = ACTIONS(564),
    [sym_hex_integer_literal] = ACTIONS(564),
    [sym_octal_integer_literal] = ACTIONS(562),
    [sym_binary_integer_literal] = ACTIONS(562),
    [sym_decimal_floating_point_literal] = ACTIONS(562),
    [sym_hex_floating_point_literal] = ACTIONS(564),
    [sym_true] = ACTIONS(564),
    [sym_false] = ACTIONS(564),
    [sym_character_literal] = ACTIONS(562),
    [sym_string_literal] = ACTIONS(562),
    [sym_null_literal] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_PLUS] = ACTIONS(564),
    [anon_sym_DASH] = ACTIONS(564),
    [anon_sym_BANG] = ACTIONS(562),
    [anon_sym_TILDE] = ACTIONS(562),
    [anon_sym_PLUS_PLUS] = ACTIONS(562),
    [anon_sym_DASH_DASH] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(564),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_switch] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(562),
    [anon_sym_RBRACE] = ACTIONS(562),
    [anon_sym_case] = ACTIONS(564),
    [anon_sym_default] = ACTIONS(564),
    [anon_sym_SEMI] = ACTIONS(562),
    [anon_sym_assert] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(564),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [anon_sym_return] = ACTIONS(564),
    [anon_sym_yield] = ACTIONS(564),
    [anon_sym_synchronized] = ACTIONS(564),
    [anon_sym_throw] = ACTIONS(564),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_else] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_open] = ACTIONS(564),
    [anon_sym_module] = ACTIONS(564),
    [anon_sym_static] = ACTIONS(564),
    [anon_sym_package] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(564),
    [anon_sym_enum] = ACTIONS(564),
    [anon_sym_public] = ACTIONS(564),
    [anon_sym_protected] = ACTIONS(564),
    [anon_sym_private] = ACTIONS(564),
    [anon_sym_abstract] = ACTIONS(564),
    [anon_sym_final] = ACTIONS(564),
    [anon_sym_strictfp] = ACTIONS(564),
    [anon_sym_native] = ACTIONS(564),
    [anon_sym_transient] = ACTIONS(564),
    [anon_sym_volatile] = ACTIONS(564),
    [anon_sym_ATinterface] = ACTIONS(562),
    [anon_sym_interface] = ACTIONS(564),
    [anon_sym_byte] = ACTIONS(564),
    [anon_sym_short] = ACTIONS(564),
    [anon_sym_int] = ACTIONS(564),
    [anon_sym_long] = ACTIONS(564),
    [anon_sym_char] = ACTIONS(564),
    [anon_sym_float] = ACTIONS(564),
    [anon_sym_double] = ACTIONS(564),
    [sym_boolean_type] = ACTIONS(564),
    [sym_void_type] = ACTIONS(564),
    [sym_this] = ACTIONS(564),
    [sym_super] = ACTIONS(564),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(566),
    [sym_identifier] = ACTIONS(568),
    [sym_decimal_integer_literal] = ACTIONS(568),
    [sym_hex_integer_literal] = ACTIONS(568),
    [sym_octal_integer_literal] = ACTIONS(566),
    [sym_binary_integer_literal] = ACTIONS(566),
    [sym_decimal_floating_point_literal] = ACTIONS(566),
    [sym_hex_floating_point_literal] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_character_literal] = ACTIONS(566),
    [sym_string_literal] = ACTIONS(566),
    [sym_null_literal] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_TILDE] = ACTIONS(566),
    [anon_sym_PLUS_PLUS] = ACTIONS(566),
    [anon_sym_DASH_DASH] = ACTIONS(566),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_class] = ACTIONS(568),
    [anon_sym_switch] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(566),
    [anon_sym_RBRACE] = ACTIONS(566),
    [anon_sym_case] = ACTIONS(568),
    [anon_sym_default] = ACTIONS(568),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_assert] = ACTIONS(568),
    [anon_sym_do] = ACTIONS(568),
    [anon_sym_while] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(568),
    [anon_sym_continue] = ACTIONS(568),
    [anon_sym_return] = ACTIONS(568),
    [anon_sym_yield] = ACTIONS(568),
    [anon_sym_synchronized] = ACTIONS(568),
    [anon_sym_throw] = ACTIONS(568),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_if] = ACTIONS(568),
    [anon_sym_else] = ACTIONS(568),
    [anon_sym_for] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_open] = ACTIONS(568),
    [anon_sym_module] = ACTIONS(568),
    [anon_sym_static] = ACTIONS(568),
    [anon_sym_package] = ACTIONS(568),
    [anon_sym_import] = ACTIONS(568),
    [anon_sym_enum] = ACTIONS(568),
    [anon_sym_public] = ACTIONS(568),
    [anon_sym_protected] = ACTIONS(568),
    [anon_sym_private] = ACTIONS(568),
    [anon_sym_abstract] = ACTIONS(568),
    [anon_sym_final] = ACTIONS(568),
    [anon_sym_strictfp] = ACTIONS(568),
    [anon_sym_native] = ACTIONS(568),
    [anon_sym_transient] = ACTIONS(568),
    [anon_sym_volatile] = ACTIONS(568),
    [anon_sym_ATinterface] = ACTIONS(566),
    [anon_sym_interface] = ACTIONS(568),
    [anon_sym_byte] = ACTIONS(568),
    [anon_sym_short] = ACTIONS(568),
    [anon_sym_int] = ACTIONS(568),
    [anon_sym_long] = ACTIONS(568),
    [anon_sym_char] = ACTIONS(568),
    [anon_sym_float] = ACTIONS(568),
    [anon_sym_double] = ACTIONS(568),
    [sym_boolean_type] = ACTIONS(568),
    [sym_void_type] = ACTIONS(568),
    [sym_this] = ACTIONS(568),
    [sym_super] = ACTIONS(568),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [155] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(460),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [sym_decimal_integer_literal] = ACTIONS(572),
    [sym_hex_integer_literal] = ACTIONS(572),
    [sym_octal_integer_literal] = ACTIONS(570),
    [sym_binary_integer_literal] = ACTIONS(570),
    [sym_decimal_floating_point_literal] = ACTIONS(570),
    [sym_hex_floating_point_literal] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_character_literal] = ACTIONS(570),
    [sym_string_literal] = ACTIONS(570),
    [sym_null_literal] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_assert] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(572),
    [anon_sym_synchronized] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(572),
    [anon_sym_open] = ACTIONS(572),
    [anon_sym_module] = ACTIONS(572),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_package] = ACTIONS(572),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_enum] = ACTIONS(572),
    [anon_sym_public] = ACTIONS(572),
    [anon_sym_protected] = ACTIONS(572),
    [anon_sym_private] = ACTIONS(572),
    [anon_sym_abstract] = ACTIONS(572),
    [anon_sym_final] = ACTIONS(572),
    [anon_sym_strictfp] = ACTIONS(572),
    [anon_sym_native] = ACTIONS(572),
    [anon_sym_transient] = ACTIONS(572),
    [anon_sym_volatile] = ACTIONS(572),
    [anon_sym_ATinterface] = ACTIONS(570),
    [anon_sym_interface] = ACTIONS(572),
    [anon_sym_byte] = ACTIONS(572),
    [anon_sym_short] = ACTIONS(572),
    [anon_sym_int] = ACTIONS(572),
    [anon_sym_long] = ACTIONS(572),
    [anon_sym_char] = ACTIONS(572),
    [anon_sym_float] = ACTIONS(572),
    [anon_sym_double] = ACTIONS(572),
    [sym_boolean_type] = ACTIONS(572),
    [sym_void_type] = ACTIONS(572),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [157] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(457),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(574),
    [sym_identifier] = ACTIONS(576),
    [sym_decimal_integer_literal] = ACTIONS(576),
    [sym_hex_integer_literal] = ACTIONS(576),
    [sym_octal_integer_literal] = ACTIONS(574),
    [sym_binary_integer_literal] = ACTIONS(574),
    [sym_decimal_floating_point_literal] = ACTIONS(574),
    [sym_hex_floating_point_literal] = ACTIONS(576),
    [sym_true] = ACTIONS(576),
    [sym_false] = ACTIONS(576),
    [sym_character_literal] = ACTIONS(574),
    [sym_string_literal] = ACTIONS(574),
    [sym_null_literal] = ACTIONS(576),
    [anon_sym_LPAREN] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(576),
    [anon_sym_DASH] = ACTIONS(576),
    [anon_sym_BANG] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(574),
    [anon_sym_PLUS_PLUS] = ACTIONS(574),
    [anon_sym_DASH_DASH] = ACTIONS(574),
    [anon_sym_new] = ACTIONS(576),
    [anon_sym_class] = ACTIONS(576),
    [anon_sym_switch] = ACTIONS(576),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_RBRACE] = ACTIONS(574),
    [anon_sym_case] = ACTIONS(576),
    [anon_sym_default] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(574),
    [anon_sym_assert] = ACTIONS(576),
    [anon_sym_do] = ACTIONS(576),
    [anon_sym_while] = ACTIONS(576),
    [anon_sym_break] = ACTIONS(576),
    [anon_sym_continue] = ACTIONS(576),
    [anon_sym_return] = ACTIONS(576),
    [anon_sym_yield] = ACTIONS(576),
    [anon_sym_synchronized] = ACTIONS(576),
    [anon_sym_throw] = ACTIONS(576),
    [anon_sym_try] = ACTIONS(576),
    [anon_sym_if] = ACTIONS(576),
    [anon_sym_else] = ACTIONS(576),
    [anon_sym_for] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(576),
    [anon_sym_open] = ACTIONS(576),
    [anon_sym_module] = ACTIONS(576),
    [anon_sym_static] = ACTIONS(576),
    [anon_sym_package] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(576),
    [anon_sym_enum] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(576),
    [anon_sym_protected] = ACTIONS(576),
    [anon_sym_private] = ACTIONS(576),
    [anon_sym_abstract] = ACTIONS(576),
    [anon_sym_final] = ACTIONS(576),
    [anon_sym_strictfp] = ACTIONS(576),
    [anon_sym_native] = ACTIONS(576),
    [anon_sym_transient] = ACTIONS(576),
    [anon_sym_volatile] = ACTIONS(576),
    [anon_sym_ATinterface] = ACTIONS(574),
    [anon_sym_interface] = ACTIONS(576),
    [anon_sym_byte] = ACTIONS(576),
    [anon_sym_short] = ACTIONS(576),
    [anon_sym_int] = ACTIONS(576),
    [anon_sym_long] = ACTIONS(576),
    [anon_sym_char] = ACTIONS(576),
    [anon_sym_float] = ACTIONS(576),
    [anon_sym_double] = ACTIONS(576),
    [sym_boolean_type] = ACTIONS(576),
    [sym_void_type] = ACTIONS(576),
    [sym_this] = ACTIONS(576),
    [sym_super] = ACTIONS(576),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [159] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(415),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [160] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(450),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [161] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(414),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [162] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(505),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [163] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(507),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [164] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(469),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [sym_decimal_integer_literal] = ACTIONS(580),
    [sym_hex_integer_literal] = ACTIONS(580),
    [sym_octal_integer_literal] = ACTIONS(578),
    [sym_binary_integer_literal] = ACTIONS(578),
    [sym_decimal_floating_point_literal] = ACTIONS(578),
    [sym_hex_floating_point_literal] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_character_literal] = ACTIONS(578),
    [sym_string_literal] = ACTIONS(578),
    [sym_null_literal] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(578),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_assert] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_synchronized] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(580),
    [anon_sym_open] = ACTIONS(580),
    [anon_sym_module] = ACTIONS(580),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_package] = ACTIONS(580),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_enum] = ACTIONS(580),
    [anon_sym_public] = ACTIONS(580),
    [anon_sym_protected] = ACTIONS(580),
    [anon_sym_private] = ACTIONS(580),
    [anon_sym_abstract] = ACTIONS(580),
    [anon_sym_final] = ACTIONS(580),
    [anon_sym_strictfp] = ACTIONS(580),
    [anon_sym_native] = ACTIONS(580),
    [anon_sym_transient] = ACTIONS(580),
    [anon_sym_volatile] = ACTIONS(580),
    [anon_sym_ATinterface] = ACTIONS(578),
    [anon_sym_interface] = ACTIONS(580),
    [anon_sym_byte] = ACTIONS(580),
    [anon_sym_short] = ACTIONS(580),
    [anon_sym_int] = ACTIONS(580),
    [anon_sym_long] = ACTIONS(580),
    [anon_sym_char] = ACTIONS(580),
    [anon_sym_float] = ACTIONS(580),
    [anon_sym_double] = ACTIONS(580),
    [sym_boolean_type] = ACTIONS(580),
    [sym_void_type] = ACTIONS(580),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [166] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(519),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(582),
    [sym_identifier] = ACTIONS(584),
    [sym_decimal_integer_literal] = ACTIONS(584),
    [sym_hex_integer_literal] = ACTIONS(584),
    [sym_octal_integer_literal] = ACTIONS(582),
    [sym_binary_integer_literal] = ACTIONS(582),
    [sym_decimal_floating_point_literal] = ACTIONS(582),
    [sym_hex_floating_point_literal] = ACTIONS(584),
    [sym_true] = ACTIONS(584),
    [sym_false] = ACTIONS(584),
    [sym_character_literal] = ACTIONS(582),
    [sym_string_literal] = ACTIONS(582),
    [sym_null_literal] = ACTIONS(584),
    [anon_sym_LPAREN] = ACTIONS(582),
    [anon_sym_PLUS] = ACTIONS(584),
    [anon_sym_DASH] = ACTIONS(584),
    [anon_sym_BANG] = ACTIONS(582),
    [anon_sym_TILDE] = ACTIONS(582),
    [anon_sym_PLUS_PLUS] = ACTIONS(582),
    [anon_sym_DASH_DASH] = ACTIONS(582),
    [anon_sym_new] = ACTIONS(584),
    [anon_sym_class] = ACTIONS(584),
    [anon_sym_switch] = ACTIONS(584),
    [anon_sym_LBRACE] = ACTIONS(582),
    [anon_sym_RBRACE] = ACTIONS(582),
    [anon_sym_case] = ACTIONS(584),
    [anon_sym_default] = ACTIONS(584),
    [anon_sym_SEMI] = ACTIONS(582),
    [anon_sym_assert] = ACTIONS(584),
    [anon_sym_do] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(584),
    [anon_sym_break] = ACTIONS(584),
    [anon_sym_continue] = ACTIONS(584),
    [anon_sym_return] = ACTIONS(584),
    [anon_sym_yield] = ACTIONS(584),
    [anon_sym_synchronized] = ACTIONS(584),
    [anon_sym_throw] = ACTIONS(584),
    [anon_sym_try] = ACTIONS(584),
    [anon_sym_if] = ACTIONS(584),
    [anon_sym_else] = ACTIONS(584),
    [anon_sym_for] = ACTIONS(584),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_open] = ACTIONS(584),
    [anon_sym_module] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(584),
    [anon_sym_package] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(584),
    [anon_sym_enum] = ACTIONS(584),
    [anon_sym_public] = ACTIONS(584),
    [anon_sym_protected] = ACTIONS(584),
    [anon_sym_private] = ACTIONS(584),
    [anon_sym_abstract] = ACTIONS(584),
    [anon_sym_final] = ACTIONS(584),
    [anon_sym_strictfp] = ACTIONS(584),
    [anon_sym_native] = ACTIONS(584),
    [anon_sym_transient] = ACTIONS(584),
    [anon_sym_volatile] = ACTIONS(584),
    [anon_sym_ATinterface] = ACTIONS(582),
    [anon_sym_interface] = ACTIONS(584),
    [anon_sym_byte] = ACTIONS(584),
    [anon_sym_short] = ACTIONS(584),
    [anon_sym_int] = ACTIONS(584),
    [anon_sym_long] = ACTIONS(584),
    [anon_sym_char] = ACTIONS(584),
    [anon_sym_float] = ACTIONS(584),
    [anon_sym_double] = ACTIONS(584),
    [sym_boolean_type] = ACTIONS(584),
    [sym_void_type] = ACTIONS(584),
    [sym_this] = ACTIONS(584),
    [sym_super] = ACTIONS(584),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [168] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(422),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [169] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(422),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(586),
    [sym_identifier] = ACTIONS(588),
    [sym_decimal_integer_literal] = ACTIONS(588),
    [sym_hex_integer_literal] = ACTIONS(588),
    [sym_octal_integer_literal] = ACTIONS(586),
    [sym_binary_integer_literal] = ACTIONS(586),
    [sym_decimal_floating_point_literal] = ACTIONS(586),
    [sym_hex_floating_point_literal] = ACTIONS(588),
    [sym_true] = ACTIONS(588),
    [sym_false] = ACTIONS(588),
    [sym_character_literal] = ACTIONS(586),
    [sym_string_literal] = ACTIONS(586),
    [sym_null_literal] = ACTIONS(588),
    [anon_sym_LPAREN] = ACTIONS(586),
    [anon_sym_PLUS] = ACTIONS(588),
    [anon_sym_DASH] = ACTIONS(588),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(586),
    [anon_sym_DASH_DASH] = ACTIONS(586),
    [anon_sym_new] = ACTIONS(588),
    [anon_sym_class] = ACTIONS(588),
    [anon_sym_switch] = ACTIONS(588),
    [anon_sym_LBRACE] = ACTIONS(586),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(588),
    [anon_sym_default] = ACTIONS(588),
    [anon_sym_SEMI] = ACTIONS(586),
    [anon_sym_assert] = ACTIONS(588),
    [anon_sym_do] = ACTIONS(588),
    [anon_sym_while] = ACTIONS(588),
    [anon_sym_break] = ACTIONS(588),
    [anon_sym_continue] = ACTIONS(588),
    [anon_sym_return] = ACTIONS(588),
    [anon_sym_yield] = ACTIONS(588),
    [anon_sym_synchronized] = ACTIONS(588),
    [anon_sym_throw] = ACTIONS(588),
    [anon_sym_try] = ACTIONS(588),
    [anon_sym_if] = ACTIONS(588),
    [anon_sym_else] = ACTIONS(588),
    [anon_sym_for] = ACTIONS(588),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_open] = ACTIONS(588),
    [anon_sym_module] = ACTIONS(588),
    [anon_sym_static] = ACTIONS(588),
    [anon_sym_package] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(588),
    [anon_sym_enum] = ACTIONS(588),
    [anon_sym_public] = ACTIONS(588),
    [anon_sym_protected] = ACTIONS(588),
    [anon_sym_private] = ACTIONS(588),
    [anon_sym_abstract] = ACTIONS(588),
    [anon_sym_final] = ACTIONS(588),
    [anon_sym_strictfp] = ACTIONS(588),
    [anon_sym_native] = ACTIONS(588),
    [anon_sym_transient] = ACTIONS(588),
    [anon_sym_volatile] = ACTIONS(588),
    [anon_sym_ATinterface] = ACTIONS(586),
    [anon_sym_interface] = ACTIONS(588),
    [anon_sym_byte] = ACTIONS(588),
    [anon_sym_short] = ACTIONS(588),
    [anon_sym_int] = ACTIONS(588),
    [anon_sym_long] = ACTIONS(588),
    [anon_sym_char] = ACTIONS(588),
    [anon_sym_float] = ACTIONS(588),
    [anon_sym_double] = ACTIONS(588),
    [sym_boolean_type] = ACTIONS(588),
    [sym_void_type] = ACTIONS(588),
    [sym_this] = ACTIONS(588),
    [sym_super] = ACTIONS(588),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(590),
    [sym_identifier] = ACTIONS(592),
    [sym_decimal_integer_literal] = ACTIONS(592),
    [sym_hex_integer_literal] = ACTIONS(592),
    [sym_octal_integer_literal] = ACTIONS(590),
    [sym_binary_integer_literal] = ACTIONS(590),
    [sym_decimal_floating_point_literal] = ACTIONS(590),
    [sym_hex_floating_point_literal] = ACTIONS(592),
    [sym_true] = ACTIONS(592),
    [sym_false] = ACTIONS(592),
    [sym_character_literal] = ACTIONS(590),
    [sym_string_literal] = ACTIONS(590),
    [sym_null_literal] = ACTIONS(592),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_PLUS_PLUS] = ACTIONS(590),
    [anon_sym_DASH_DASH] = ACTIONS(590),
    [anon_sym_new] = ACTIONS(592),
    [anon_sym_class] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(592),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_case] = ACTIONS(592),
    [anon_sym_default] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_assert] = ACTIONS(592),
    [anon_sym_do] = ACTIONS(592),
    [anon_sym_while] = ACTIONS(592),
    [anon_sym_break] = ACTIONS(592),
    [anon_sym_continue] = ACTIONS(592),
    [anon_sym_return] = ACTIONS(592),
    [anon_sym_yield] = ACTIONS(592),
    [anon_sym_synchronized] = ACTIONS(592),
    [anon_sym_throw] = ACTIONS(592),
    [anon_sym_try] = ACTIONS(592),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_else] = ACTIONS(592),
    [anon_sym_for] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(592),
    [anon_sym_open] = ACTIONS(592),
    [anon_sym_module] = ACTIONS(592),
    [anon_sym_static] = ACTIONS(592),
    [anon_sym_package] = ACTIONS(592),
    [anon_sym_import] = ACTIONS(592),
    [anon_sym_enum] = ACTIONS(592),
    [anon_sym_public] = ACTIONS(592),
    [anon_sym_protected] = ACTIONS(592),
    [anon_sym_private] = ACTIONS(592),
    [anon_sym_abstract] = ACTIONS(592),
    [anon_sym_final] = ACTIONS(592),
    [anon_sym_strictfp] = ACTIONS(592),
    [anon_sym_native] = ACTIONS(592),
    [anon_sym_transient] = ACTIONS(592),
    [anon_sym_volatile] = ACTIONS(592),
    [anon_sym_ATinterface] = ACTIONS(590),
    [anon_sym_interface] = ACTIONS(592),
    [anon_sym_byte] = ACTIONS(592),
    [anon_sym_short] = ACTIONS(592),
    [anon_sym_int] = ACTIONS(592),
    [anon_sym_long] = ACTIONS(592),
    [anon_sym_char] = ACTIONS(592),
    [anon_sym_float] = ACTIONS(592),
    [anon_sym_double] = ACTIONS(592),
    [sym_boolean_type] = ACTIONS(592),
    [sym_void_type] = ACTIONS(592),
    [sym_this] = ACTIONS(592),
    [sym_super] = ACTIONS(592),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(594),
    [sym_identifier] = ACTIONS(596),
    [sym_decimal_integer_literal] = ACTIONS(596),
    [sym_hex_integer_literal] = ACTIONS(596),
    [sym_octal_integer_literal] = ACTIONS(594),
    [sym_binary_integer_literal] = ACTIONS(594),
    [sym_decimal_floating_point_literal] = ACTIONS(594),
    [sym_hex_floating_point_literal] = ACTIONS(596),
    [sym_true] = ACTIONS(596),
    [sym_false] = ACTIONS(596),
    [sym_character_literal] = ACTIONS(594),
    [sym_string_literal] = ACTIONS(594),
    [sym_null_literal] = ACTIONS(596),
    [anon_sym_LPAREN] = ACTIONS(594),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_BANG] = ACTIONS(594),
    [anon_sym_TILDE] = ACTIONS(594),
    [anon_sym_PLUS_PLUS] = ACTIONS(594),
    [anon_sym_DASH_DASH] = ACTIONS(594),
    [anon_sym_new] = ACTIONS(596),
    [anon_sym_class] = ACTIONS(596),
    [anon_sym_switch] = ACTIONS(596),
    [anon_sym_LBRACE] = ACTIONS(594),
    [anon_sym_RBRACE] = ACTIONS(594),
    [anon_sym_case] = ACTIONS(596),
    [anon_sym_default] = ACTIONS(596),
    [anon_sym_SEMI] = ACTIONS(594),
    [anon_sym_assert] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(596),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_break] = ACTIONS(596),
    [anon_sym_continue] = ACTIONS(596),
    [anon_sym_return] = ACTIONS(596),
    [anon_sym_yield] = ACTIONS(596),
    [anon_sym_synchronized] = ACTIONS(596),
    [anon_sym_throw] = ACTIONS(596),
    [anon_sym_try] = ACTIONS(596),
    [anon_sym_if] = ACTIONS(596),
    [anon_sym_else] = ACTIONS(596),
    [anon_sym_for] = ACTIONS(596),
    [anon_sym_AT] = ACTIONS(596),
    [anon_sym_open] = ACTIONS(596),
    [anon_sym_module] = ACTIONS(596),
    [anon_sym_static] = ACTIONS(596),
    [anon_sym_package] = ACTIONS(596),
    [anon_sym_import] = ACTIONS(596),
    [anon_sym_enum] = ACTIONS(596),
    [anon_sym_public] = ACTIONS(596),
    [anon_sym_protected] = ACTIONS(596),
    [anon_sym_private] = ACTIONS(596),
    [anon_sym_abstract] = ACTIONS(596),
    [anon_sym_final] = ACTIONS(596),
    [anon_sym_strictfp] = ACTIONS(596),
    [anon_sym_native] = ACTIONS(596),
    [anon_sym_transient] = ACTIONS(596),
    [anon_sym_volatile] = ACTIONS(596),
    [anon_sym_ATinterface] = ACTIONS(594),
    [anon_sym_interface] = ACTIONS(596),
    [anon_sym_byte] = ACTIONS(596),
    [anon_sym_short] = ACTIONS(596),
    [anon_sym_int] = ACTIONS(596),
    [anon_sym_long] = ACTIONS(596),
    [anon_sym_char] = ACTIONS(596),
    [anon_sym_float] = ACTIONS(596),
    [anon_sym_double] = ACTIONS(596),
    [sym_boolean_type] = ACTIONS(596),
    [sym_void_type] = ACTIONS(596),
    [sym_this] = ACTIONS(596),
    [sym_super] = ACTIONS(596),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [sym_decimal_integer_literal] = ACTIONS(600),
    [sym_hex_integer_literal] = ACTIONS(600),
    [sym_octal_integer_literal] = ACTIONS(598),
    [sym_binary_integer_literal] = ACTIONS(598),
    [sym_decimal_floating_point_literal] = ACTIONS(598),
    [sym_hex_floating_point_literal] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_character_literal] = ACTIONS(598),
    [sym_string_literal] = ACTIONS(598),
    [sym_null_literal] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_BANG] = ACTIONS(598),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_assert] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_yield] = ACTIONS(600),
    [anon_sym_synchronized] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(600),
    [anon_sym_open] = ACTIONS(600),
    [anon_sym_module] = ACTIONS(600),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_package] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_enum] = ACTIONS(600),
    [anon_sym_public] = ACTIONS(600),
    [anon_sym_protected] = ACTIONS(600),
    [anon_sym_private] = ACTIONS(600),
    [anon_sym_abstract] = ACTIONS(600),
    [anon_sym_final] = ACTIONS(600),
    [anon_sym_strictfp] = ACTIONS(600),
    [anon_sym_native] = ACTIONS(600),
    [anon_sym_transient] = ACTIONS(600),
    [anon_sym_volatile] = ACTIONS(600),
    [anon_sym_ATinterface] = ACTIONS(598),
    [anon_sym_interface] = ACTIONS(600),
    [anon_sym_byte] = ACTIONS(600),
    [anon_sym_short] = ACTIONS(600),
    [anon_sym_int] = ACTIONS(600),
    [anon_sym_long] = ACTIONS(600),
    [anon_sym_char] = ACTIONS(600),
    [anon_sym_float] = ACTIONS(600),
    [anon_sym_double] = ACTIONS(600),
    [sym_boolean_type] = ACTIONS(600),
    [sym_void_type] = ACTIONS(600),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [sym_decimal_integer_literal] = ACTIONS(604),
    [sym_hex_integer_literal] = ACTIONS(604),
    [sym_octal_integer_literal] = ACTIONS(602),
    [sym_binary_integer_literal] = ACTIONS(602),
    [sym_decimal_floating_point_literal] = ACTIONS(602),
    [sym_hex_floating_point_literal] = ACTIONS(604),
    [sym_true] = ACTIONS(604),
    [sym_false] = ACTIONS(604),
    [sym_character_literal] = ACTIONS(602),
    [sym_string_literal] = ACTIONS(602),
    [sym_null_literal] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_BANG] = ACTIONS(602),
    [anon_sym_TILDE] = ACTIONS(602),
    [anon_sym_PLUS_PLUS] = ACTIONS(602),
    [anon_sym_DASH_DASH] = ACTIONS(602),
    [anon_sym_new] = ACTIONS(604),
    [anon_sym_class] = ACTIONS(604),
    [anon_sym_switch] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_case] = ACTIONS(604),
    [anon_sym_default] = ACTIONS(604),
    [anon_sym_SEMI] = ACTIONS(602),
    [anon_sym_assert] = ACTIONS(604),
    [anon_sym_do] = ACTIONS(604),
    [anon_sym_while] = ACTIONS(604),
    [anon_sym_break] = ACTIONS(604),
    [anon_sym_continue] = ACTIONS(604),
    [anon_sym_return] = ACTIONS(604),
    [anon_sym_yield] = ACTIONS(604),
    [anon_sym_synchronized] = ACTIONS(604),
    [anon_sym_throw] = ACTIONS(604),
    [anon_sym_try] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_else] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(604),
    [anon_sym_open] = ACTIONS(604),
    [anon_sym_module] = ACTIONS(604),
    [anon_sym_static] = ACTIONS(604),
    [anon_sym_package] = ACTIONS(604),
    [anon_sym_import] = ACTIONS(604),
    [anon_sym_enum] = ACTIONS(604),
    [anon_sym_public] = ACTIONS(604),
    [anon_sym_protected] = ACTIONS(604),
    [anon_sym_private] = ACTIONS(604),
    [anon_sym_abstract] = ACTIONS(604),
    [anon_sym_final] = ACTIONS(604),
    [anon_sym_strictfp] = ACTIONS(604),
    [anon_sym_native] = ACTIONS(604),
    [anon_sym_transient] = ACTIONS(604),
    [anon_sym_volatile] = ACTIONS(604),
    [anon_sym_ATinterface] = ACTIONS(602),
    [anon_sym_interface] = ACTIONS(604),
    [anon_sym_byte] = ACTIONS(604),
    [anon_sym_short] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_long] = ACTIONS(604),
    [anon_sym_char] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_double] = ACTIONS(604),
    [sym_boolean_type] = ACTIONS(604),
    [sym_void_type] = ACTIONS(604),
    [sym_this] = ACTIONS(604),
    [sym_super] = ACTIONS(604),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(606),
    [sym_identifier] = ACTIONS(608),
    [sym_decimal_integer_literal] = ACTIONS(608),
    [sym_hex_integer_literal] = ACTIONS(608),
    [sym_octal_integer_literal] = ACTIONS(606),
    [sym_binary_integer_literal] = ACTIONS(606),
    [sym_decimal_floating_point_literal] = ACTIONS(606),
    [sym_hex_floating_point_literal] = ACTIONS(608),
    [sym_true] = ACTIONS(608),
    [sym_false] = ACTIONS(608),
    [sym_character_literal] = ACTIONS(606),
    [sym_string_literal] = ACTIONS(606),
    [sym_null_literal] = ACTIONS(608),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_PLUS] = ACTIONS(608),
    [anon_sym_DASH] = ACTIONS(608),
    [anon_sym_BANG] = ACTIONS(606),
    [anon_sym_TILDE] = ACTIONS(606),
    [anon_sym_PLUS_PLUS] = ACTIONS(606),
    [anon_sym_DASH_DASH] = ACTIONS(606),
    [anon_sym_new] = ACTIONS(608),
    [anon_sym_class] = ACTIONS(608),
    [anon_sym_switch] = ACTIONS(608),
    [anon_sym_LBRACE] = ACTIONS(606),
    [anon_sym_RBRACE] = ACTIONS(606),
    [anon_sym_case] = ACTIONS(608),
    [anon_sym_default] = ACTIONS(608),
    [anon_sym_SEMI] = ACTIONS(606),
    [anon_sym_assert] = ACTIONS(608),
    [anon_sym_do] = ACTIONS(608),
    [anon_sym_while] = ACTIONS(608),
    [anon_sym_break] = ACTIONS(608),
    [anon_sym_continue] = ACTIONS(608),
    [anon_sym_return] = ACTIONS(608),
    [anon_sym_yield] = ACTIONS(608),
    [anon_sym_synchronized] = ACTIONS(608),
    [anon_sym_throw] = ACTIONS(608),
    [anon_sym_try] = ACTIONS(608),
    [anon_sym_if] = ACTIONS(608),
    [anon_sym_else] = ACTIONS(608),
    [anon_sym_for] = ACTIONS(608),
    [anon_sym_AT] = ACTIONS(608),
    [anon_sym_open] = ACTIONS(608),
    [anon_sym_module] = ACTIONS(608),
    [anon_sym_static] = ACTIONS(608),
    [anon_sym_package] = ACTIONS(608),
    [anon_sym_import] = ACTIONS(608),
    [anon_sym_enum] = ACTIONS(608),
    [anon_sym_public] = ACTIONS(608),
    [anon_sym_protected] = ACTIONS(608),
    [anon_sym_private] = ACTIONS(608),
    [anon_sym_abstract] = ACTIONS(608),
    [anon_sym_final] = ACTIONS(608),
    [anon_sym_strictfp] = ACTIONS(608),
    [anon_sym_native] = ACTIONS(608),
    [anon_sym_transient] = ACTIONS(608),
    [anon_sym_volatile] = ACTIONS(608),
    [anon_sym_ATinterface] = ACTIONS(606),
    [anon_sym_interface] = ACTIONS(608),
    [anon_sym_byte] = ACTIONS(608),
    [anon_sym_short] = ACTIONS(608),
    [anon_sym_int] = ACTIONS(608),
    [anon_sym_long] = ACTIONS(608),
    [anon_sym_char] = ACTIONS(608),
    [anon_sym_float] = ACTIONS(608),
    [anon_sym_double] = ACTIONS(608),
    [sym_boolean_type] = ACTIONS(608),
    [sym_void_type] = ACTIONS(608),
    [sym_this] = ACTIONS(608),
    [sym_super] = ACTIONS(608),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [176] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(435),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [177] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [sym_identifier] = ACTIONS(612),
    [sym_decimal_integer_literal] = ACTIONS(612),
    [sym_hex_integer_literal] = ACTIONS(612),
    [sym_octal_integer_literal] = ACTIONS(610),
    [sym_binary_integer_literal] = ACTIONS(610),
    [sym_decimal_floating_point_literal] = ACTIONS(610),
    [sym_hex_floating_point_literal] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_character_literal] = ACTIONS(610),
    [sym_string_literal] = ACTIONS(610),
    [sym_null_literal] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_PLUS_PLUS] = ACTIONS(610),
    [anon_sym_DASH_DASH] = ACTIONS(610),
    [anon_sym_new] = ACTIONS(612),
    [anon_sym_class] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_RBRACE] = ACTIONS(610),
    [anon_sym_case] = ACTIONS(612),
    [anon_sym_default] = ACTIONS(612),
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_assert] = ACTIONS(612),
    [anon_sym_do] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(612),
    [anon_sym_return] = ACTIONS(612),
    [anon_sym_yield] = ACTIONS(612),
    [anon_sym_synchronized] = ACTIONS(612),
    [anon_sym_throw] = ACTIONS(612),
    [anon_sym_try] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(612),
    [anon_sym_open] = ACTIONS(612),
    [anon_sym_module] = ACTIONS(612),
    [anon_sym_static] = ACTIONS(612),
    [anon_sym_package] = ACTIONS(612),
    [anon_sym_import] = ACTIONS(612),
    [anon_sym_enum] = ACTIONS(612),
    [anon_sym_public] = ACTIONS(612),
    [anon_sym_protected] = ACTIONS(612),
    [anon_sym_private] = ACTIONS(612),
    [anon_sym_abstract] = ACTIONS(612),
    [anon_sym_final] = ACTIONS(612),
    [anon_sym_strictfp] = ACTIONS(612),
    [anon_sym_native] = ACTIONS(612),
    [anon_sym_transient] = ACTIONS(612),
    [anon_sym_volatile] = ACTIONS(612),
    [anon_sym_ATinterface] = ACTIONS(610),
    [anon_sym_interface] = ACTIONS(612),
    [anon_sym_byte] = ACTIONS(612),
    [anon_sym_short] = ACTIONS(612),
    [anon_sym_int] = ACTIONS(612),
    [anon_sym_long] = ACTIONS(612),
    [anon_sym_char] = ACTIONS(612),
    [anon_sym_float] = ACTIONS(612),
    [anon_sym_double] = ACTIONS(612),
    [sym_boolean_type] = ACTIONS(612),
    [sym_void_type] = ACTIONS(612),
    [sym_this] = ACTIONS(612),
    [sym_super] = ACTIONS(612),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [178] = {
    [ts_builtin_sym_end] = ACTIONS(614),
    [sym_identifier] = ACTIONS(616),
    [sym_decimal_integer_literal] = ACTIONS(616),
    [sym_hex_integer_literal] = ACTIONS(616),
    [sym_octal_integer_literal] = ACTIONS(614),
    [sym_binary_integer_literal] = ACTIONS(614),
    [sym_decimal_floating_point_literal] = ACTIONS(614),
    [sym_hex_floating_point_literal] = ACTIONS(616),
    [sym_true] = ACTIONS(616),
    [sym_false] = ACTIONS(616),
    [sym_character_literal] = ACTIONS(614),
    [sym_string_literal] = ACTIONS(614),
    [sym_null_literal] = ACTIONS(616),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_PLUS] = ACTIONS(616),
    [anon_sym_DASH] = ACTIONS(616),
    [anon_sym_BANG] = ACTIONS(614),
    [anon_sym_TILDE] = ACTIONS(614),
    [anon_sym_PLUS_PLUS] = ACTIONS(614),
    [anon_sym_DASH_DASH] = ACTIONS(614),
    [anon_sym_new] = ACTIONS(616),
    [anon_sym_class] = ACTIONS(616),
    [anon_sym_switch] = ACTIONS(616),
    [anon_sym_LBRACE] = ACTIONS(614),
    [anon_sym_RBRACE] = ACTIONS(614),
    [anon_sym_case] = ACTIONS(616),
    [anon_sym_default] = ACTIONS(616),
    [anon_sym_SEMI] = ACTIONS(614),
    [anon_sym_assert] = ACTIONS(616),
    [anon_sym_do] = ACTIONS(616),
    [anon_sym_while] = ACTIONS(616),
    [anon_sym_break] = ACTIONS(616),
    [anon_sym_continue] = ACTIONS(616),
    [anon_sym_return] = ACTIONS(616),
    [anon_sym_yield] = ACTIONS(616),
    [anon_sym_synchronized] = ACTIONS(616),
    [anon_sym_throw] = ACTIONS(616),
    [anon_sym_try] = ACTIONS(616),
    [anon_sym_if] = ACTIONS(616),
    [anon_sym_else] = ACTIONS(616),
    [anon_sym_for] = ACTIONS(616),
    [anon_sym_AT] = ACTIONS(616),
    [anon_sym_open] = ACTIONS(616),
    [anon_sym_module] = ACTIONS(616),
    [anon_sym_static] = ACTIONS(616),
    [anon_sym_package] = ACTIONS(616),
    [anon_sym_import] = ACTIONS(616),
    [anon_sym_enum] = ACTIONS(616),
    [anon_sym_public] = ACTIONS(616),
    [anon_sym_protected] = ACTIONS(616),
    [anon_sym_private] = ACTIONS(616),
    [anon_sym_abstract] = ACTIONS(616),
    [anon_sym_final] = ACTIONS(616),
    [anon_sym_strictfp] = ACTIONS(616),
    [anon_sym_native] = ACTIONS(616),
    [anon_sym_transient] = ACTIONS(616),
    [anon_sym_volatile] = ACTIONS(616),
    [anon_sym_ATinterface] = ACTIONS(614),
    [anon_sym_interface] = ACTIONS(616),
    [anon_sym_byte] = ACTIONS(616),
    [anon_sym_short] = ACTIONS(616),
    [anon_sym_int] = ACTIONS(616),
    [anon_sym_long] = ACTIONS(616),
    [anon_sym_char] = ACTIONS(616),
    [anon_sym_float] = ACTIONS(616),
    [anon_sym_double] = ACTIONS(616),
    [sym_boolean_type] = ACTIONS(616),
    [sym_void_type] = ACTIONS(616),
    [sym_this] = ACTIONS(616),
    [sym_super] = ACTIONS(616),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [179] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(423),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [180] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(466),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [sym_identifier] = ACTIONS(620),
    [sym_decimal_integer_literal] = ACTIONS(620),
    [sym_hex_integer_literal] = ACTIONS(620),
    [sym_octal_integer_literal] = ACTIONS(618),
    [sym_binary_integer_literal] = ACTIONS(618),
    [sym_decimal_floating_point_literal] = ACTIONS(618),
    [sym_hex_floating_point_literal] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_character_literal] = ACTIONS(618),
    [sym_string_literal] = ACTIONS(618),
    [sym_null_literal] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_BANG] = ACTIONS(618),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_PLUS_PLUS] = ACTIONS(618),
    [anon_sym_DASH_DASH] = ACTIONS(618),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_class] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_RBRACE] = ACTIONS(618),
    [anon_sym_case] = ACTIONS(620),
    [anon_sym_default] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_assert] = ACTIONS(620),
    [anon_sym_do] = ACTIONS(620),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_break] = ACTIONS(620),
    [anon_sym_continue] = ACTIONS(620),
    [anon_sym_return] = ACTIONS(620),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_synchronized] = ACTIONS(620),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_try] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_open] = ACTIONS(620),
    [anon_sym_module] = ACTIONS(620),
    [anon_sym_static] = ACTIONS(620),
    [anon_sym_package] = ACTIONS(620),
    [anon_sym_import] = ACTIONS(620),
    [anon_sym_enum] = ACTIONS(620),
    [anon_sym_public] = ACTIONS(620),
    [anon_sym_protected] = ACTIONS(620),
    [anon_sym_private] = ACTIONS(620),
    [anon_sym_abstract] = ACTIONS(620),
    [anon_sym_final] = ACTIONS(620),
    [anon_sym_strictfp] = ACTIONS(620),
    [anon_sym_native] = ACTIONS(620),
    [anon_sym_transient] = ACTIONS(620),
    [anon_sym_volatile] = ACTIONS(620),
    [anon_sym_ATinterface] = ACTIONS(618),
    [anon_sym_interface] = ACTIONS(620),
    [anon_sym_byte] = ACTIONS(620),
    [anon_sym_short] = ACTIONS(620),
    [anon_sym_int] = ACTIONS(620),
    [anon_sym_long] = ACTIONS(620),
    [anon_sym_char] = ACTIONS(620),
    [anon_sym_float] = ACTIONS(620),
    [anon_sym_double] = ACTIONS(620),
    [sym_boolean_type] = ACTIONS(620),
    [sym_void_type] = ACTIONS(620),
    [sym_this] = ACTIONS(620),
    [sym_super] = ACTIONS(620),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [182] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(495),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(622),
    [sym_identifier] = ACTIONS(624),
    [sym_decimal_integer_literal] = ACTIONS(624),
    [sym_hex_integer_literal] = ACTIONS(624),
    [sym_octal_integer_literal] = ACTIONS(622),
    [sym_binary_integer_literal] = ACTIONS(622),
    [sym_decimal_floating_point_literal] = ACTIONS(622),
    [sym_hex_floating_point_literal] = ACTIONS(624),
    [sym_true] = ACTIONS(624),
    [sym_false] = ACTIONS(624),
    [sym_character_literal] = ACTIONS(622),
    [sym_string_literal] = ACTIONS(622),
    [sym_null_literal] = ACTIONS(624),
    [anon_sym_LPAREN] = ACTIONS(622),
    [anon_sym_PLUS] = ACTIONS(624),
    [anon_sym_DASH] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(622),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_PLUS_PLUS] = ACTIONS(622),
    [anon_sym_DASH_DASH] = ACTIONS(622),
    [anon_sym_new] = ACTIONS(624),
    [anon_sym_class] = ACTIONS(624),
    [anon_sym_switch] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(622),
    [anon_sym_RBRACE] = ACTIONS(622),
    [anon_sym_case] = ACTIONS(624),
    [anon_sym_default] = ACTIONS(624),
    [anon_sym_SEMI] = ACTIONS(622),
    [anon_sym_assert] = ACTIONS(624),
    [anon_sym_do] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(624),
    [anon_sym_break] = ACTIONS(624),
    [anon_sym_continue] = ACTIONS(624),
    [anon_sym_return] = ACTIONS(624),
    [anon_sym_yield] = ACTIONS(624),
    [anon_sym_synchronized] = ACTIONS(624),
    [anon_sym_throw] = ACTIONS(624),
    [anon_sym_try] = ACTIONS(624),
    [anon_sym_if] = ACTIONS(624),
    [anon_sym_else] = ACTIONS(624),
    [anon_sym_for] = ACTIONS(624),
    [anon_sym_AT] = ACTIONS(624),
    [anon_sym_open] = ACTIONS(624),
    [anon_sym_module] = ACTIONS(624),
    [anon_sym_static] = ACTIONS(624),
    [anon_sym_package] = ACTIONS(624),
    [anon_sym_import] = ACTIONS(624),
    [anon_sym_enum] = ACTIONS(624),
    [anon_sym_public] = ACTIONS(624),
    [anon_sym_protected] = ACTIONS(624),
    [anon_sym_private] = ACTIONS(624),
    [anon_sym_abstract] = ACTIONS(624),
    [anon_sym_final] = ACTIONS(624),
    [anon_sym_strictfp] = ACTIONS(624),
    [anon_sym_native] = ACTIONS(624),
    [anon_sym_transient] = ACTIONS(624),
    [anon_sym_volatile] = ACTIONS(624),
    [anon_sym_ATinterface] = ACTIONS(622),
    [anon_sym_interface] = ACTIONS(624),
    [anon_sym_byte] = ACTIONS(624),
    [anon_sym_short] = ACTIONS(624),
    [anon_sym_int] = ACTIONS(624),
    [anon_sym_long] = ACTIONS(624),
    [anon_sym_char] = ACTIONS(624),
    [anon_sym_float] = ACTIONS(624),
    [anon_sym_double] = ACTIONS(624),
    [sym_boolean_type] = ACTIONS(624),
    [sym_void_type] = ACTIONS(624),
    [sym_this] = ACTIONS(624),
    [sym_super] = ACTIONS(624),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [184] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(463),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(626),
    [sym_identifier] = ACTIONS(628),
    [sym_decimal_integer_literal] = ACTIONS(628),
    [sym_hex_integer_literal] = ACTIONS(628),
    [sym_octal_integer_literal] = ACTIONS(626),
    [sym_binary_integer_literal] = ACTIONS(626),
    [sym_decimal_floating_point_literal] = ACTIONS(626),
    [sym_hex_floating_point_literal] = ACTIONS(628),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_character_literal] = ACTIONS(626),
    [sym_string_literal] = ACTIONS(626),
    [sym_null_literal] = ACTIONS(628),
    [anon_sym_LPAREN] = ACTIONS(626),
    [anon_sym_PLUS] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(626),
    [anon_sym_TILDE] = ACTIONS(626),
    [anon_sym_PLUS_PLUS] = ACTIONS(626),
    [anon_sym_DASH_DASH] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(628),
    [anon_sym_class] = ACTIONS(628),
    [anon_sym_switch] = ACTIONS(628),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_RBRACE] = ACTIONS(626),
    [anon_sym_case] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(628),
    [anon_sym_SEMI] = ACTIONS(626),
    [anon_sym_assert] = ACTIONS(628),
    [anon_sym_do] = ACTIONS(628),
    [anon_sym_while] = ACTIONS(628),
    [anon_sym_break] = ACTIONS(628),
    [anon_sym_continue] = ACTIONS(628),
    [anon_sym_return] = ACTIONS(628),
    [anon_sym_yield] = ACTIONS(628),
    [anon_sym_synchronized] = ACTIONS(628),
    [anon_sym_throw] = ACTIONS(628),
    [anon_sym_try] = ACTIONS(628),
    [anon_sym_if] = ACTIONS(628),
    [anon_sym_else] = ACTIONS(628),
    [anon_sym_for] = ACTIONS(628),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_open] = ACTIONS(628),
    [anon_sym_module] = ACTIONS(628),
    [anon_sym_static] = ACTIONS(628),
    [anon_sym_package] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(628),
    [anon_sym_enum] = ACTIONS(628),
    [anon_sym_public] = ACTIONS(628),
    [anon_sym_protected] = ACTIONS(628),
    [anon_sym_private] = ACTIONS(628),
    [anon_sym_abstract] = ACTIONS(628),
    [anon_sym_final] = ACTIONS(628),
    [anon_sym_strictfp] = ACTIONS(628),
    [anon_sym_native] = ACTIONS(628),
    [anon_sym_transient] = ACTIONS(628),
    [anon_sym_volatile] = ACTIONS(628),
    [anon_sym_ATinterface] = ACTIONS(626),
    [anon_sym_interface] = ACTIONS(628),
    [anon_sym_byte] = ACTIONS(628),
    [anon_sym_short] = ACTIONS(628),
    [anon_sym_int] = ACTIONS(628),
    [anon_sym_long] = ACTIONS(628),
    [anon_sym_char] = ACTIONS(628),
    [anon_sym_float] = ACTIONS(628),
    [anon_sym_double] = ACTIONS(628),
    [sym_boolean_type] = ACTIONS(628),
    [sym_void_type] = ACTIONS(628),
    [sym_this] = ACTIONS(628),
    [sym_super] = ACTIONS(628),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(630),
    [sym_identifier] = ACTIONS(632),
    [sym_decimal_integer_literal] = ACTIONS(632),
    [sym_hex_integer_literal] = ACTIONS(632),
    [sym_octal_integer_literal] = ACTIONS(630),
    [sym_binary_integer_literal] = ACTIONS(630),
    [sym_decimal_floating_point_literal] = ACTIONS(630),
    [sym_hex_floating_point_literal] = ACTIONS(632),
    [sym_true] = ACTIONS(632),
    [sym_false] = ACTIONS(632),
    [sym_character_literal] = ACTIONS(630),
    [sym_string_literal] = ACTIONS(630),
    [sym_null_literal] = ACTIONS(632),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_PLUS] = ACTIONS(632),
    [anon_sym_DASH] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_TILDE] = ACTIONS(630),
    [anon_sym_PLUS_PLUS] = ACTIONS(630),
    [anon_sym_DASH_DASH] = ACTIONS(630),
    [anon_sym_new] = ACTIONS(632),
    [anon_sym_class] = ACTIONS(632),
    [anon_sym_switch] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_RBRACE] = ACTIONS(630),
    [anon_sym_case] = ACTIONS(632),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_SEMI] = ACTIONS(630),
    [anon_sym_assert] = ACTIONS(632),
    [anon_sym_do] = ACTIONS(632),
    [anon_sym_while] = ACTIONS(632),
    [anon_sym_break] = ACTIONS(632),
    [anon_sym_continue] = ACTIONS(632),
    [anon_sym_return] = ACTIONS(632),
    [anon_sym_yield] = ACTIONS(632),
    [anon_sym_synchronized] = ACTIONS(632),
    [anon_sym_throw] = ACTIONS(632),
    [anon_sym_try] = ACTIONS(632),
    [anon_sym_if] = ACTIONS(632),
    [anon_sym_else] = ACTIONS(632),
    [anon_sym_for] = ACTIONS(632),
    [anon_sym_AT] = ACTIONS(632),
    [anon_sym_open] = ACTIONS(632),
    [anon_sym_module] = ACTIONS(632),
    [anon_sym_static] = ACTIONS(632),
    [anon_sym_package] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(632),
    [anon_sym_enum] = ACTIONS(632),
    [anon_sym_public] = ACTIONS(632),
    [anon_sym_protected] = ACTIONS(632),
    [anon_sym_private] = ACTIONS(632),
    [anon_sym_abstract] = ACTIONS(632),
    [anon_sym_final] = ACTIONS(632),
    [anon_sym_strictfp] = ACTIONS(632),
    [anon_sym_native] = ACTIONS(632),
    [anon_sym_transient] = ACTIONS(632),
    [anon_sym_volatile] = ACTIONS(632),
    [anon_sym_ATinterface] = ACTIONS(630),
    [anon_sym_interface] = ACTIONS(632),
    [anon_sym_byte] = ACTIONS(632),
    [anon_sym_short] = ACTIONS(632),
    [anon_sym_int] = ACTIONS(632),
    [anon_sym_long] = ACTIONS(632),
    [anon_sym_char] = ACTIONS(632),
    [anon_sym_float] = ACTIONS(632),
    [anon_sym_double] = ACTIONS(632),
    [sym_boolean_type] = ACTIONS(632),
    [sym_void_type] = ACTIONS(632),
    [sym_this] = ACTIONS(632),
    [sym_super] = ACTIONS(632),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(634),
    [sym_identifier] = ACTIONS(636),
    [sym_decimal_integer_literal] = ACTIONS(636),
    [sym_hex_integer_literal] = ACTIONS(636),
    [sym_octal_integer_literal] = ACTIONS(634),
    [sym_binary_integer_literal] = ACTIONS(634),
    [sym_decimal_floating_point_literal] = ACTIONS(634),
    [sym_hex_floating_point_literal] = ACTIONS(636),
    [sym_true] = ACTIONS(636),
    [sym_false] = ACTIONS(636),
    [sym_character_literal] = ACTIONS(634),
    [sym_string_literal] = ACTIONS(634),
    [sym_null_literal] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_new] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(636),
    [anon_sym_switch] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(634),
    [anon_sym_case] = ACTIONS(636),
    [anon_sym_default] = ACTIONS(636),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_assert] = ACTIONS(636),
    [anon_sym_do] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(636),
    [anon_sym_break] = ACTIONS(636),
    [anon_sym_continue] = ACTIONS(636),
    [anon_sym_return] = ACTIONS(636),
    [anon_sym_yield] = ACTIONS(636),
    [anon_sym_synchronized] = ACTIONS(636),
    [anon_sym_throw] = ACTIONS(636),
    [anon_sym_try] = ACTIONS(636),
    [anon_sym_if] = ACTIONS(636),
    [anon_sym_else] = ACTIONS(636),
    [anon_sym_for] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_open] = ACTIONS(636),
    [anon_sym_module] = ACTIONS(636),
    [anon_sym_static] = ACTIONS(636),
    [anon_sym_package] = ACTIONS(636),
    [anon_sym_import] = ACTIONS(636),
    [anon_sym_enum] = ACTIONS(636),
    [anon_sym_public] = ACTIONS(636),
    [anon_sym_protected] = ACTIONS(636),
    [anon_sym_private] = ACTIONS(636),
    [anon_sym_abstract] = ACTIONS(636),
    [anon_sym_final] = ACTIONS(636),
    [anon_sym_strictfp] = ACTIONS(636),
    [anon_sym_native] = ACTIONS(636),
    [anon_sym_transient] = ACTIONS(636),
    [anon_sym_volatile] = ACTIONS(636),
    [anon_sym_ATinterface] = ACTIONS(634),
    [anon_sym_interface] = ACTIONS(636),
    [anon_sym_byte] = ACTIONS(636),
    [anon_sym_short] = ACTIONS(636),
    [anon_sym_int] = ACTIONS(636),
    [anon_sym_long] = ACTIONS(636),
    [anon_sym_char] = ACTIONS(636),
    [anon_sym_float] = ACTIONS(636),
    [anon_sym_double] = ACTIONS(636),
    [sym_boolean_type] = ACTIONS(636),
    [sym_void_type] = ACTIONS(636),
    [sym_this] = ACTIONS(636),
    [sym_super] = ACTIONS(636),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [188] = {
    [sym_switch_label] = STATE(988),
    [aux_sym_switch_block_statement_group_repeat1] = STATE(188),
    [sym_identifier] = ACTIONS(638),
    [sym_decimal_integer_literal] = ACTIONS(638),
    [sym_hex_integer_literal] = ACTIONS(638),
    [sym_octal_integer_literal] = ACTIONS(640),
    [sym_binary_integer_literal] = ACTIONS(640),
    [sym_decimal_floating_point_literal] = ACTIONS(640),
    [sym_hex_floating_point_literal] = ACTIONS(638),
    [sym_true] = ACTIONS(638),
    [sym_false] = ACTIONS(638),
    [sym_character_literal] = ACTIONS(640),
    [sym_string_literal] = ACTIONS(640),
    [sym_null_literal] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_BANG] = ACTIONS(640),
    [anon_sym_TILDE] = ACTIONS(640),
    [anon_sym_PLUS_PLUS] = ACTIONS(640),
    [anon_sym_DASH_DASH] = ACTIONS(640),
    [anon_sym_new] = ACTIONS(638),
    [anon_sym_class] = ACTIONS(638),
    [anon_sym_switch] = ACTIONS(638),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_case] = ACTIONS(642),
    [anon_sym_default] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(640),
    [anon_sym_assert] = ACTIONS(638),
    [anon_sym_do] = ACTIONS(638),
    [anon_sym_while] = ACTIONS(638),
    [anon_sym_break] = ACTIONS(638),
    [anon_sym_continue] = ACTIONS(638),
    [anon_sym_return] = ACTIONS(638),
    [anon_sym_yield] = ACTIONS(638),
    [anon_sym_synchronized] = ACTIONS(638),
    [anon_sym_throw] = ACTIONS(638),
    [anon_sym_try] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(638),
    [anon_sym_open] = ACTIONS(638),
    [anon_sym_module] = ACTIONS(638),
    [anon_sym_static] = ACTIONS(638),
    [anon_sym_package] = ACTIONS(638),
    [anon_sym_import] = ACTIONS(638),
    [anon_sym_enum] = ACTIONS(638),
    [anon_sym_public] = ACTIONS(638),
    [anon_sym_protected] = ACTIONS(638),
    [anon_sym_private] = ACTIONS(638),
    [anon_sym_abstract] = ACTIONS(638),
    [anon_sym_final] = ACTIONS(638),
    [anon_sym_strictfp] = ACTIONS(638),
    [anon_sym_native] = ACTIONS(638),
    [anon_sym_transient] = ACTIONS(638),
    [anon_sym_volatile] = ACTIONS(638),
    [anon_sym_ATinterface] = ACTIONS(640),
    [anon_sym_interface] = ACTIONS(638),
    [anon_sym_byte] = ACTIONS(638),
    [anon_sym_short] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_long] = ACTIONS(638),
    [anon_sym_char] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_double] = ACTIONS(638),
    [sym_boolean_type] = ACTIONS(638),
    [sym_void_type] = ACTIONS(638),
    [sym_this] = ACTIONS(638),
    [sym_super] = ACTIONS(638),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(648),
    [sym_identifier] = ACTIONS(650),
    [sym_decimal_integer_literal] = ACTIONS(650),
    [sym_hex_integer_literal] = ACTIONS(650),
    [sym_octal_integer_literal] = ACTIONS(648),
    [sym_binary_integer_literal] = ACTIONS(648),
    [sym_decimal_floating_point_literal] = ACTIONS(648),
    [sym_hex_floating_point_literal] = ACTIONS(650),
    [sym_true] = ACTIONS(650),
    [sym_false] = ACTIONS(650),
    [sym_character_literal] = ACTIONS(648),
    [sym_string_literal] = ACTIONS(648),
    [sym_null_literal] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(648),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(648),
    [anon_sym_TILDE] = ACTIONS(648),
    [anon_sym_PLUS_PLUS] = ACTIONS(648),
    [anon_sym_DASH_DASH] = ACTIONS(648),
    [anon_sym_new] = ACTIONS(650),
    [anon_sym_class] = ACTIONS(650),
    [anon_sym_switch] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(648),
    [anon_sym_RBRACE] = ACTIONS(648),
    [anon_sym_case] = ACTIONS(650),
    [anon_sym_default] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(648),
    [anon_sym_assert] = ACTIONS(650),
    [anon_sym_do] = ACTIONS(650),
    [anon_sym_while] = ACTIONS(650),
    [anon_sym_break] = ACTIONS(650),
    [anon_sym_continue] = ACTIONS(650),
    [anon_sym_return] = ACTIONS(650),
    [anon_sym_yield] = ACTIONS(650),
    [anon_sym_synchronized] = ACTIONS(650),
    [anon_sym_throw] = ACTIONS(650),
    [anon_sym_try] = ACTIONS(650),
    [anon_sym_if] = ACTIONS(650),
    [anon_sym_else] = ACTIONS(650),
    [anon_sym_for] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_open] = ACTIONS(650),
    [anon_sym_module] = ACTIONS(650),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_package] = ACTIONS(650),
    [anon_sym_import] = ACTIONS(650),
    [anon_sym_enum] = ACTIONS(650),
    [anon_sym_public] = ACTIONS(650),
    [anon_sym_protected] = ACTIONS(650),
    [anon_sym_private] = ACTIONS(650),
    [anon_sym_abstract] = ACTIONS(650),
    [anon_sym_final] = ACTIONS(650),
    [anon_sym_strictfp] = ACTIONS(650),
    [anon_sym_native] = ACTIONS(650),
    [anon_sym_transient] = ACTIONS(650),
    [anon_sym_volatile] = ACTIONS(650),
    [anon_sym_ATinterface] = ACTIONS(648),
    [anon_sym_interface] = ACTIONS(650),
    [anon_sym_byte] = ACTIONS(650),
    [anon_sym_short] = ACTIONS(650),
    [anon_sym_int] = ACTIONS(650),
    [anon_sym_long] = ACTIONS(650),
    [anon_sym_char] = ACTIONS(650),
    [anon_sym_float] = ACTIONS(650),
    [anon_sym_double] = ACTIONS(650),
    [sym_boolean_type] = ACTIONS(650),
    [sym_void_type] = ACTIONS(650),
    [sym_this] = ACTIONS(650),
    [sym_super] = ACTIONS(650),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [190] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(491),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [191] = {
    [ts_builtin_sym_end] = ACTIONS(652),
    [sym_identifier] = ACTIONS(654),
    [sym_decimal_integer_literal] = ACTIONS(654),
    [sym_hex_integer_literal] = ACTIONS(654),
    [sym_octal_integer_literal] = ACTIONS(652),
    [sym_binary_integer_literal] = ACTIONS(652),
    [sym_decimal_floating_point_literal] = ACTIONS(652),
    [sym_hex_floating_point_literal] = ACTIONS(654),
    [sym_true] = ACTIONS(654),
    [sym_false] = ACTIONS(654),
    [sym_character_literal] = ACTIONS(652),
    [sym_string_literal] = ACTIONS(652),
    [sym_null_literal] = ACTIONS(654),
    [anon_sym_LPAREN] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_TILDE] = ACTIONS(652),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [anon_sym_new] = ACTIONS(654),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_switch] = ACTIONS(654),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_RBRACE] = ACTIONS(652),
    [anon_sym_case] = ACTIONS(654),
    [anon_sym_default] = ACTIONS(654),
    [anon_sym_SEMI] = ACTIONS(652),
    [anon_sym_assert] = ACTIONS(654),
    [anon_sym_do] = ACTIONS(654),
    [anon_sym_while] = ACTIONS(654),
    [anon_sym_break] = ACTIONS(654),
    [anon_sym_continue] = ACTIONS(654),
    [anon_sym_return] = ACTIONS(654),
    [anon_sym_yield] = ACTIONS(654),
    [anon_sym_synchronized] = ACTIONS(654),
    [anon_sym_throw] = ACTIONS(654),
    [anon_sym_try] = ACTIONS(654),
    [anon_sym_if] = ACTIONS(654),
    [anon_sym_else] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_open] = ACTIONS(654),
    [anon_sym_module] = ACTIONS(654),
    [anon_sym_static] = ACTIONS(654),
    [anon_sym_package] = ACTIONS(654),
    [anon_sym_import] = ACTIONS(654),
    [anon_sym_enum] = ACTIONS(654),
    [anon_sym_public] = ACTIONS(654),
    [anon_sym_protected] = ACTIONS(654),
    [anon_sym_private] = ACTIONS(654),
    [anon_sym_abstract] = ACTIONS(654),
    [anon_sym_final] = ACTIONS(654),
    [anon_sym_strictfp] = ACTIONS(654),
    [anon_sym_native] = ACTIONS(654),
    [anon_sym_transient] = ACTIONS(654),
    [anon_sym_volatile] = ACTIONS(654),
    [anon_sym_ATinterface] = ACTIONS(652),
    [anon_sym_interface] = ACTIONS(654),
    [anon_sym_byte] = ACTIONS(654),
    [anon_sym_short] = ACTIONS(654),
    [anon_sym_int] = ACTIONS(654),
    [anon_sym_long] = ACTIONS(654),
    [anon_sym_char] = ACTIONS(654),
    [anon_sym_float] = ACTIONS(654),
    [anon_sym_double] = ACTIONS(654),
    [sym_boolean_type] = ACTIONS(654),
    [sym_void_type] = ACTIONS(654),
    [sym_this] = ACTIONS(654),
    [sym_super] = ACTIONS(654),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [192] = {
    [ts_builtin_sym_end] = ACTIONS(656),
    [sym_identifier] = ACTIONS(658),
    [sym_decimal_integer_literal] = ACTIONS(658),
    [sym_hex_integer_literal] = ACTIONS(658),
    [sym_octal_integer_literal] = ACTIONS(656),
    [sym_binary_integer_literal] = ACTIONS(656),
    [sym_decimal_floating_point_literal] = ACTIONS(656),
    [sym_hex_floating_point_literal] = ACTIONS(658),
    [sym_true] = ACTIONS(658),
    [sym_false] = ACTIONS(658),
    [sym_character_literal] = ACTIONS(656),
    [sym_string_literal] = ACTIONS(656),
    [sym_null_literal] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_BANG] = ACTIONS(656),
    [anon_sym_TILDE] = ACTIONS(656),
    [anon_sym_PLUS_PLUS] = ACTIONS(656),
    [anon_sym_DASH_DASH] = ACTIONS(656),
    [anon_sym_new] = ACTIONS(658),
    [anon_sym_class] = ACTIONS(658),
    [anon_sym_switch] = ACTIONS(658),
    [anon_sym_LBRACE] = ACTIONS(656),
    [anon_sym_RBRACE] = ACTIONS(656),
    [anon_sym_case] = ACTIONS(658),
    [anon_sym_default] = ACTIONS(658),
    [anon_sym_SEMI] = ACTIONS(656),
    [anon_sym_assert] = ACTIONS(658),
    [anon_sym_do] = ACTIONS(658),
    [anon_sym_while] = ACTIONS(658),
    [anon_sym_break] = ACTIONS(658),
    [anon_sym_continue] = ACTIONS(658),
    [anon_sym_return] = ACTIONS(658),
    [anon_sym_yield] = ACTIONS(658),
    [anon_sym_synchronized] = ACTIONS(658),
    [anon_sym_throw] = ACTIONS(658),
    [anon_sym_try] = ACTIONS(658),
    [anon_sym_if] = ACTIONS(658),
    [anon_sym_else] = ACTIONS(658),
    [anon_sym_for] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(658),
    [anon_sym_open] = ACTIONS(658),
    [anon_sym_module] = ACTIONS(658),
    [anon_sym_static] = ACTIONS(658),
    [anon_sym_package] = ACTIONS(658),
    [anon_sym_import] = ACTIONS(658),
    [anon_sym_enum] = ACTIONS(658),
    [anon_sym_public] = ACTIONS(658),
    [anon_sym_protected] = ACTIONS(658),
    [anon_sym_private] = ACTIONS(658),
    [anon_sym_abstract] = ACTIONS(658),
    [anon_sym_final] = ACTIONS(658),
    [anon_sym_strictfp] = ACTIONS(658),
    [anon_sym_native] = ACTIONS(658),
    [anon_sym_transient] = ACTIONS(658),
    [anon_sym_volatile] = ACTIONS(658),
    [anon_sym_ATinterface] = ACTIONS(656),
    [anon_sym_interface] = ACTIONS(658),
    [anon_sym_byte] = ACTIONS(658),
    [anon_sym_short] = ACTIONS(658),
    [anon_sym_int] = ACTIONS(658),
    [anon_sym_long] = ACTIONS(658),
    [anon_sym_char] = ACTIONS(658),
    [anon_sym_float] = ACTIONS(658),
    [anon_sym_double] = ACTIONS(658),
    [sym_boolean_type] = ACTIONS(658),
    [sym_void_type] = ACTIONS(658),
    [sym_this] = ACTIONS(658),
    [sym_super] = ACTIONS(658),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [193] = {
    [ts_builtin_sym_end] = ACTIONS(660),
    [sym_identifier] = ACTIONS(662),
    [sym_decimal_integer_literal] = ACTIONS(662),
    [sym_hex_integer_literal] = ACTIONS(662),
    [sym_octal_integer_literal] = ACTIONS(660),
    [sym_binary_integer_literal] = ACTIONS(660),
    [sym_decimal_floating_point_literal] = ACTIONS(660),
    [sym_hex_floating_point_literal] = ACTIONS(662),
    [sym_true] = ACTIONS(662),
    [sym_false] = ACTIONS(662),
    [sym_character_literal] = ACTIONS(660),
    [sym_string_literal] = ACTIONS(660),
    [sym_null_literal] = ACTIONS(662),
    [anon_sym_LPAREN] = ACTIONS(660),
    [anon_sym_PLUS] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(660),
    [anon_sym_TILDE] = ACTIONS(660),
    [anon_sym_PLUS_PLUS] = ACTIONS(660),
    [anon_sym_DASH_DASH] = ACTIONS(660),
    [anon_sym_new] = ACTIONS(662),
    [anon_sym_class] = ACTIONS(662),
    [anon_sym_switch] = ACTIONS(662),
    [anon_sym_LBRACE] = ACTIONS(660),
    [anon_sym_RBRACE] = ACTIONS(660),
    [anon_sym_case] = ACTIONS(662),
    [anon_sym_default] = ACTIONS(662),
    [anon_sym_SEMI] = ACTIONS(660),
    [anon_sym_assert] = ACTIONS(662),
    [anon_sym_do] = ACTIONS(662),
    [anon_sym_while] = ACTIONS(662),
    [anon_sym_break] = ACTIONS(662),
    [anon_sym_continue] = ACTIONS(662),
    [anon_sym_return] = ACTIONS(662),
    [anon_sym_yield] = ACTIONS(662),
    [anon_sym_synchronized] = ACTIONS(662),
    [anon_sym_throw] = ACTIONS(662),
    [anon_sym_try] = ACTIONS(662),
    [anon_sym_if] = ACTIONS(662),
    [anon_sym_else] = ACTIONS(662),
    [anon_sym_for] = ACTIONS(662),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_open] = ACTIONS(662),
    [anon_sym_module] = ACTIONS(662),
    [anon_sym_static] = ACTIONS(662),
    [anon_sym_package] = ACTIONS(662),
    [anon_sym_import] = ACTIONS(662),
    [anon_sym_enum] = ACTIONS(662),
    [anon_sym_public] = ACTIONS(662),
    [anon_sym_protected] = ACTIONS(662),
    [anon_sym_private] = ACTIONS(662),
    [anon_sym_abstract] = ACTIONS(662),
    [anon_sym_final] = ACTIONS(662),
    [anon_sym_strictfp] = ACTIONS(662),
    [anon_sym_native] = ACTIONS(662),
    [anon_sym_transient] = ACTIONS(662),
    [anon_sym_volatile] = ACTIONS(662),
    [anon_sym_ATinterface] = ACTIONS(660),
    [anon_sym_interface] = ACTIONS(662),
    [anon_sym_byte] = ACTIONS(662),
    [anon_sym_short] = ACTIONS(662),
    [anon_sym_int] = ACTIONS(662),
    [anon_sym_long] = ACTIONS(662),
    [anon_sym_char] = ACTIONS(662),
    [anon_sym_float] = ACTIONS(662),
    [anon_sym_double] = ACTIONS(662),
    [sym_boolean_type] = ACTIONS(662),
    [sym_void_type] = ACTIONS(662),
    [sym_this] = ACTIONS(662),
    [sym_super] = ACTIONS(662),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [194] = {
    [ts_builtin_sym_end] = ACTIONS(664),
    [sym_identifier] = ACTIONS(666),
    [sym_decimal_integer_literal] = ACTIONS(666),
    [sym_hex_integer_literal] = ACTIONS(666),
    [sym_octal_integer_literal] = ACTIONS(664),
    [sym_binary_integer_literal] = ACTIONS(664),
    [sym_decimal_floating_point_literal] = ACTIONS(664),
    [sym_hex_floating_point_literal] = ACTIONS(666),
    [sym_true] = ACTIONS(666),
    [sym_false] = ACTIONS(666),
    [sym_character_literal] = ACTIONS(664),
    [sym_string_literal] = ACTIONS(664),
    [sym_null_literal] = ACTIONS(666),
    [anon_sym_LPAREN] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(666),
    [anon_sym_DASH] = ACTIONS(666),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_TILDE] = ACTIONS(664),
    [anon_sym_PLUS_PLUS] = ACTIONS(664),
    [anon_sym_DASH_DASH] = ACTIONS(664),
    [anon_sym_new] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(666),
    [anon_sym_switch] = ACTIONS(666),
    [anon_sym_LBRACE] = ACTIONS(664),
    [anon_sym_RBRACE] = ACTIONS(664),
    [anon_sym_case] = ACTIONS(666),
    [anon_sym_default] = ACTIONS(666),
    [anon_sym_SEMI] = ACTIONS(664),
    [anon_sym_assert] = ACTIONS(666),
    [anon_sym_do] = ACTIONS(666),
    [anon_sym_while] = ACTIONS(666),
    [anon_sym_break] = ACTIONS(666),
    [anon_sym_continue] = ACTIONS(666),
    [anon_sym_return] = ACTIONS(666),
    [anon_sym_yield] = ACTIONS(666),
    [anon_sym_synchronized] = ACTIONS(666),
    [anon_sym_throw] = ACTIONS(666),
    [anon_sym_try] = ACTIONS(666),
    [anon_sym_if] = ACTIONS(666),
    [anon_sym_else] = ACTIONS(666),
    [anon_sym_for] = ACTIONS(666),
    [anon_sym_AT] = ACTIONS(666),
    [anon_sym_open] = ACTIONS(666),
    [anon_sym_module] = ACTIONS(666),
    [anon_sym_static] = ACTIONS(666),
    [anon_sym_package] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(666),
    [anon_sym_enum] = ACTIONS(666),
    [anon_sym_public] = ACTIONS(666),
    [anon_sym_protected] = ACTIONS(666),
    [anon_sym_private] = ACTIONS(666),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_final] = ACTIONS(666),
    [anon_sym_strictfp] = ACTIONS(666),
    [anon_sym_native] = ACTIONS(666),
    [anon_sym_transient] = ACTIONS(666),
    [anon_sym_volatile] = ACTIONS(666),
    [anon_sym_ATinterface] = ACTIONS(664),
    [anon_sym_interface] = ACTIONS(666),
    [anon_sym_byte] = ACTIONS(666),
    [anon_sym_short] = ACTIONS(666),
    [anon_sym_int] = ACTIONS(666),
    [anon_sym_long] = ACTIONS(666),
    [anon_sym_char] = ACTIONS(666),
    [anon_sym_float] = ACTIONS(666),
    [anon_sym_double] = ACTIONS(666),
    [sym_boolean_type] = ACTIONS(666),
    [sym_void_type] = ACTIONS(666),
    [sym_this] = ACTIONS(666),
    [sym_super] = ACTIONS(666),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [195] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(458),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [196] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(477),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [197] = {
    [ts_builtin_sym_end] = ACTIONS(668),
    [sym_identifier] = ACTIONS(670),
    [sym_decimal_integer_literal] = ACTIONS(670),
    [sym_hex_integer_literal] = ACTIONS(670),
    [sym_octal_integer_literal] = ACTIONS(668),
    [sym_binary_integer_literal] = ACTIONS(668),
    [sym_decimal_floating_point_literal] = ACTIONS(668),
    [sym_hex_floating_point_literal] = ACTIONS(670),
    [sym_true] = ACTIONS(670),
    [sym_false] = ACTIONS(670),
    [sym_character_literal] = ACTIONS(668),
    [sym_string_literal] = ACTIONS(668),
    [sym_null_literal] = ACTIONS(670),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(670),
    [anon_sym_DASH] = ACTIONS(670),
    [anon_sym_BANG] = ACTIONS(668),
    [anon_sym_TILDE] = ACTIONS(668),
    [anon_sym_PLUS_PLUS] = ACTIONS(668),
    [anon_sym_DASH_DASH] = ACTIONS(668),
    [anon_sym_new] = ACTIONS(670),
    [anon_sym_class] = ACTIONS(670),
    [anon_sym_switch] = ACTIONS(670),
    [anon_sym_LBRACE] = ACTIONS(668),
    [anon_sym_RBRACE] = ACTIONS(668),
    [anon_sym_case] = ACTIONS(670),
    [anon_sym_default] = ACTIONS(670),
    [anon_sym_SEMI] = ACTIONS(668),
    [anon_sym_assert] = ACTIONS(670),
    [anon_sym_do] = ACTIONS(670),
    [anon_sym_while] = ACTIONS(670),
    [anon_sym_break] = ACTIONS(670),
    [anon_sym_continue] = ACTIONS(670),
    [anon_sym_return] = ACTIONS(670),
    [anon_sym_yield] = ACTIONS(670),
    [anon_sym_synchronized] = ACTIONS(670),
    [anon_sym_throw] = ACTIONS(670),
    [anon_sym_try] = ACTIONS(670),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_else] = ACTIONS(670),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_AT] = ACTIONS(670),
    [anon_sym_open] = ACTIONS(670),
    [anon_sym_module] = ACTIONS(670),
    [anon_sym_static] = ACTIONS(670),
    [anon_sym_package] = ACTIONS(670),
    [anon_sym_import] = ACTIONS(670),
    [anon_sym_enum] = ACTIONS(670),
    [anon_sym_public] = ACTIONS(670),
    [anon_sym_protected] = ACTIONS(670),
    [anon_sym_private] = ACTIONS(670),
    [anon_sym_abstract] = ACTIONS(670),
    [anon_sym_final] = ACTIONS(670),
    [anon_sym_strictfp] = ACTIONS(670),
    [anon_sym_native] = ACTIONS(670),
    [anon_sym_transient] = ACTIONS(670),
    [anon_sym_volatile] = ACTIONS(670),
    [anon_sym_ATinterface] = ACTIONS(668),
    [anon_sym_interface] = ACTIONS(670),
    [anon_sym_byte] = ACTIONS(670),
    [anon_sym_short] = ACTIONS(670),
    [anon_sym_int] = ACTIONS(670),
    [anon_sym_long] = ACTIONS(670),
    [anon_sym_char] = ACTIONS(670),
    [anon_sym_float] = ACTIONS(670),
    [anon_sym_double] = ACTIONS(670),
    [sym_boolean_type] = ACTIONS(670),
    [sym_void_type] = ACTIONS(670),
    [sym_this] = ACTIONS(670),
    [sym_super] = ACTIONS(670),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [198] = {
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_identifier] = ACTIONS(311),
    [sym_decimal_integer_literal] = ACTIONS(311),
    [sym_hex_integer_literal] = ACTIONS(311),
    [sym_octal_integer_literal] = ACTIONS(309),
    [sym_binary_integer_literal] = ACTIONS(309),
    [sym_decimal_floating_point_literal] = ACTIONS(309),
    [sym_hex_floating_point_literal] = ACTIONS(311),
    [sym_true] = ACTIONS(311),
    [sym_false] = ACTIONS(311),
    [sym_character_literal] = ACTIONS(309),
    [sym_string_literal] = ACTIONS(309),
    [sym_null_literal] = ACTIONS(311),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_PLUS] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(311),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_TILDE] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(309),
    [anon_sym_DASH_DASH] = ACTIONS(309),
    [anon_sym_new] = ACTIONS(311),
    [anon_sym_class] = ACTIONS(311),
    [anon_sym_switch] = ACTIONS(311),
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_case] = ACTIONS(311),
    [anon_sym_default] = ACTIONS(311),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_assert] = ACTIONS(311),
    [anon_sym_do] = ACTIONS(311),
    [anon_sym_while] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(311),
    [anon_sym_continue] = ACTIONS(311),
    [anon_sym_return] = ACTIONS(311),
    [anon_sym_yield] = ACTIONS(311),
    [anon_sym_synchronized] = ACTIONS(311),
    [anon_sym_throw] = ACTIONS(311),
    [anon_sym_try] = ACTIONS(311),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_else] = ACTIONS(311),
    [anon_sym_for] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(311),
    [anon_sym_open] = ACTIONS(311),
    [anon_sym_module] = ACTIONS(311),
    [anon_sym_static] = ACTIONS(311),
    [anon_sym_package] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(311),
    [anon_sym_enum] = ACTIONS(311),
    [anon_sym_public] = ACTIONS(311),
    [anon_sym_protected] = ACTIONS(311),
    [anon_sym_private] = ACTIONS(311),
    [anon_sym_abstract] = ACTIONS(311),
    [anon_sym_final] = ACTIONS(311),
    [anon_sym_strictfp] = ACTIONS(311),
    [anon_sym_native] = ACTIONS(311),
    [anon_sym_transient] = ACTIONS(311),
    [anon_sym_volatile] = ACTIONS(311),
    [anon_sym_ATinterface] = ACTIONS(309),
    [anon_sym_interface] = ACTIONS(311),
    [anon_sym_byte] = ACTIONS(311),
    [anon_sym_short] = ACTIONS(311),
    [anon_sym_int] = ACTIONS(311),
    [anon_sym_long] = ACTIONS(311),
    [anon_sym_char] = ACTIONS(311),
    [anon_sym_float] = ACTIONS(311),
    [anon_sym_double] = ACTIONS(311),
    [sym_boolean_type] = ACTIONS(311),
    [sym_void_type] = ACTIONS(311),
    [sym_this] = ACTIONS(311),
    [sym_super] = ACTIONS(311),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [199] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(414),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [200] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [sym_identifier] = ACTIONS(265),
    [sym_decimal_integer_literal] = ACTIONS(265),
    [sym_hex_integer_literal] = ACTIONS(265),
    [sym_octal_integer_literal] = ACTIONS(263),
    [sym_binary_integer_literal] = ACTIONS(263),
    [sym_decimal_floating_point_literal] = ACTIONS(263),
    [sym_hex_floating_point_literal] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_character_literal] = ACTIONS(263),
    [sym_string_literal] = ACTIONS(263),
    [sym_null_literal] = ACTIONS(265),
    [anon_sym_LPAREN] = ACTIONS(263),
    [anon_sym_PLUS] = ACTIONS(265),
    [anon_sym_DASH] = ACTIONS(265),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_PLUS_PLUS] = ACTIONS(263),
    [anon_sym_DASH_DASH] = ACTIONS(263),
    [anon_sym_new] = ACTIONS(265),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_switch] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(263),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_assert] = ACTIONS(265),
    [anon_sym_do] = ACTIONS(265),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(265),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(265),
    [anon_sym_synchronized] = ACTIONS(265),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_try] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(265),
    [anon_sym_else] = ACTIONS(265),
    [anon_sym_for] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(265),
    [anon_sym_open] = ACTIONS(265),
    [anon_sym_module] = ACTIONS(265),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_package] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(265),
    [anon_sym_enum] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(265),
    [anon_sym_protected] = ACTIONS(265),
    [anon_sym_private] = ACTIONS(265),
    [anon_sym_abstract] = ACTIONS(265),
    [anon_sym_final] = ACTIONS(265),
    [anon_sym_strictfp] = ACTIONS(265),
    [anon_sym_native] = ACTIONS(265),
    [anon_sym_transient] = ACTIONS(265),
    [anon_sym_volatile] = ACTIONS(265),
    [anon_sym_ATinterface] = ACTIONS(263),
    [anon_sym_interface] = ACTIONS(265),
    [anon_sym_byte] = ACTIONS(265),
    [anon_sym_short] = ACTIONS(265),
    [anon_sym_int] = ACTIONS(265),
    [anon_sym_long] = ACTIONS(265),
    [anon_sym_char] = ACTIONS(265),
    [anon_sym_float] = ACTIONS(265),
    [anon_sym_double] = ACTIONS(265),
    [sym_boolean_type] = ACTIONS(265),
    [sym_void_type] = ACTIONS(265),
    [sym_this] = ACTIONS(265),
    [sym_super] = ACTIONS(265),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [201] = {
    [ts_builtin_sym_end] = ACTIONS(672),
    [sym_identifier] = ACTIONS(674),
    [sym_decimal_integer_literal] = ACTIONS(674),
    [sym_hex_integer_literal] = ACTIONS(674),
    [sym_octal_integer_literal] = ACTIONS(672),
    [sym_binary_integer_literal] = ACTIONS(672),
    [sym_decimal_floating_point_literal] = ACTIONS(672),
    [sym_hex_floating_point_literal] = ACTIONS(674),
    [sym_true] = ACTIONS(674),
    [sym_false] = ACTIONS(674),
    [sym_character_literal] = ACTIONS(672),
    [sym_string_literal] = ACTIONS(672),
    [sym_null_literal] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(674),
    [anon_sym_BANG] = ACTIONS(672),
    [anon_sym_TILDE] = ACTIONS(672),
    [anon_sym_PLUS_PLUS] = ACTIONS(672),
    [anon_sym_DASH_DASH] = ACTIONS(672),
    [anon_sym_new] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(674),
    [anon_sym_switch] = ACTIONS(674),
    [anon_sym_LBRACE] = ACTIONS(672),
    [anon_sym_RBRACE] = ACTIONS(672),
    [anon_sym_case] = ACTIONS(674),
    [anon_sym_default] = ACTIONS(674),
    [anon_sym_SEMI] = ACTIONS(672),
    [anon_sym_assert] = ACTIONS(674),
    [anon_sym_do] = ACTIONS(674),
    [anon_sym_while] = ACTIONS(674),
    [anon_sym_break] = ACTIONS(674),
    [anon_sym_continue] = ACTIONS(674),
    [anon_sym_return] = ACTIONS(674),
    [anon_sym_yield] = ACTIONS(674),
    [anon_sym_synchronized] = ACTIONS(674),
    [anon_sym_throw] = ACTIONS(674),
    [anon_sym_try] = ACTIONS(674),
    [anon_sym_if] = ACTIONS(674),
    [anon_sym_else] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(674),
    [anon_sym_open] = ACTIONS(674),
    [anon_sym_module] = ACTIONS(674),
    [anon_sym_static] = ACTIONS(674),
    [anon_sym_package] = ACTIONS(674),
    [anon_sym_import] = ACTIONS(674),
    [anon_sym_enum] = ACTIONS(674),
    [anon_sym_public] = ACTIONS(674),
    [anon_sym_protected] = ACTIONS(674),
    [anon_sym_private] = ACTIONS(674),
    [anon_sym_abstract] = ACTIONS(674),
    [anon_sym_final] = ACTIONS(674),
    [anon_sym_strictfp] = ACTIONS(674),
    [anon_sym_native] = ACTIONS(674),
    [anon_sym_transient] = ACTIONS(674),
    [anon_sym_volatile] = ACTIONS(674),
    [anon_sym_ATinterface] = ACTIONS(672),
    [anon_sym_interface] = ACTIONS(674),
    [anon_sym_byte] = ACTIONS(674),
    [anon_sym_short] = ACTIONS(674),
    [anon_sym_int] = ACTIONS(674),
    [anon_sym_long] = ACTIONS(674),
    [anon_sym_char] = ACTIONS(674),
    [anon_sym_float] = ACTIONS(674),
    [anon_sym_double] = ACTIONS(674),
    [sym_boolean_type] = ACTIONS(674),
    [sym_void_type] = ACTIONS(674),
    [sym_this] = ACTIONS(674),
    [sym_super] = ACTIONS(674),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [202] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(465),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [203] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(501),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [204] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(488),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [205] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(471),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [206] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(456),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [207] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(489),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [208] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(492),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [209] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(439),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [210] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(500),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [211] = {
    [ts_builtin_sym_end] = ACTIONS(676),
    [sym_identifier] = ACTIONS(678),
    [sym_decimal_integer_literal] = ACTIONS(678),
    [sym_hex_integer_literal] = ACTIONS(678),
    [sym_octal_integer_literal] = ACTIONS(676),
    [sym_binary_integer_literal] = ACTIONS(676),
    [sym_decimal_floating_point_literal] = ACTIONS(676),
    [sym_hex_floating_point_literal] = ACTIONS(678),
    [sym_true] = ACTIONS(678),
    [sym_false] = ACTIONS(678),
    [sym_character_literal] = ACTIONS(676),
    [sym_string_literal] = ACTIONS(676),
    [sym_null_literal] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(676),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_BANG] = ACTIONS(676),
    [anon_sym_TILDE] = ACTIONS(676),
    [anon_sym_PLUS_PLUS] = ACTIONS(676),
    [anon_sym_DASH_DASH] = ACTIONS(676),
    [anon_sym_new] = ACTIONS(678),
    [anon_sym_class] = ACTIONS(678),
    [anon_sym_switch] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(676),
    [anon_sym_RBRACE] = ACTIONS(676),
    [anon_sym_case] = ACTIONS(678),
    [anon_sym_default] = ACTIONS(678),
    [anon_sym_SEMI] = ACTIONS(676),
    [anon_sym_assert] = ACTIONS(678),
    [anon_sym_do] = ACTIONS(678),
    [anon_sym_while] = ACTIONS(678),
    [anon_sym_break] = ACTIONS(678),
    [anon_sym_continue] = ACTIONS(678),
    [anon_sym_return] = ACTIONS(678),
    [anon_sym_yield] = ACTIONS(678),
    [anon_sym_synchronized] = ACTIONS(678),
    [anon_sym_throw] = ACTIONS(678),
    [anon_sym_try] = ACTIONS(678),
    [anon_sym_if] = ACTIONS(678),
    [anon_sym_else] = ACTIONS(678),
    [anon_sym_for] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(678),
    [anon_sym_open] = ACTIONS(678),
    [anon_sym_module] = ACTIONS(678),
    [anon_sym_static] = ACTIONS(678),
    [anon_sym_package] = ACTIONS(678),
    [anon_sym_import] = ACTIONS(678),
    [anon_sym_enum] = ACTIONS(678),
    [anon_sym_public] = ACTIONS(678),
    [anon_sym_protected] = ACTIONS(678),
    [anon_sym_private] = ACTIONS(678),
    [anon_sym_abstract] = ACTIONS(678),
    [anon_sym_final] = ACTIONS(678),
    [anon_sym_strictfp] = ACTIONS(678),
    [anon_sym_native] = ACTIONS(678),
    [anon_sym_transient] = ACTIONS(678),
    [anon_sym_volatile] = ACTIONS(678),
    [anon_sym_ATinterface] = ACTIONS(676),
    [anon_sym_interface] = ACTIONS(678),
    [anon_sym_byte] = ACTIONS(678),
    [anon_sym_short] = ACTIONS(678),
    [anon_sym_int] = ACTIONS(678),
    [anon_sym_long] = ACTIONS(678),
    [anon_sym_char] = ACTIONS(678),
    [anon_sym_float] = ACTIONS(678),
    [anon_sym_double] = ACTIONS(678),
    [sym_boolean_type] = ACTIONS(678),
    [sym_void_type] = ACTIONS(678),
    [sym_this] = ACTIONS(678),
    [sym_super] = ACTIONS(678),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [212] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(429),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [213] = {
    [ts_builtin_sym_end] = ACTIONS(680),
    [sym_identifier] = ACTIONS(682),
    [sym_decimal_integer_literal] = ACTIONS(682),
    [sym_hex_integer_literal] = ACTIONS(682),
    [sym_octal_integer_literal] = ACTIONS(680),
    [sym_binary_integer_literal] = ACTIONS(680),
    [sym_decimal_floating_point_literal] = ACTIONS(680),
    [sym_hex_floating_point_literal] = ACTIONS(682),
    [sym_true] = ACTIONS(682),
    [sym_false] = ACTIONS(682),
    [sym_character_literal] = ACTIONS(680),
    [sym_string_literal] = ACTIONS(680),
    [sym_null_literal] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(682),
    [anon_sym_DASH] = ACTIONS(682),
    [anon_sym_BANG] = ACTIONS(680),
    [anon_sym_TILDE] = ACTIONS(680),
    [anon_sym_PLUS_PLUS] = ACTIONS(680),
    [anon_sym_DASH_DASH] = ACTIONS(680),
    [anon_sym_new] = ACTIONS(682),
    [anon_sym_class] = ACTIONS(682),
    [anon_sym_switch] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_case] = ACTIONS(682),
    [anon_sym_default] = ACTIONS(682),
    [anon_sym_SEMI] = ACTIONS(680),
    [anon_sym_assert] = ACTIONS(682),
    [anon_sym_do] = ACTIONS(682),
    [anon_sym_while] = ACTIONS(682),
    [anon_sym_break] = ACTIONS(682),
    [anon_sym_continue] = ACTIONS(682),
    [anon_sym_return] = ACTIONS(682),
    [anon_sym_yield] = ACTIONS(682),
    [anon_sym_synchronized] = ACTIONS(682),
    [anon_sym_throw] = ACTIONS(682),
    [anon_sym_try] = ACTIONS(682),
    [anon_sym_if] = ACTIONS(682),
    [anon_sym_else] = ACTIONS(682),
    [anon_sym_for] = ACTIONS(682),
    [anon_sym_AT] = ACTIONS(682),
    [anon_sym_open] = ACTIONS(682),
    [anon_sym_module] = ACTIONS(682),
    [anon_sym_static] = ACTIONS(682),
    [anon_sym_package] = ACTIONS(682),
    [anon_sym_import] = ACTIONS(682),
    [anon_sym_enum] = ACTIONS(682),
    [anon_sym_public] = ACTIONS(682),
    [anon_sym_protected] = ACTIONS(682),
    [anon_sym_private] = ACTIONS(682),
    [anon_sym_abstract] = ACTIONS(682),
    [anon_sym_final] = ACTIONS(682),
    [anon_sym_strictfp] = ACTIONS(682),
    [anon_sym_native] = ACTIONS(682),
    [anon_sym_transient] = ACTIONS(682),
    [anon_sym_volatile] = ACTIONS(682),
    [anon_sym_ATinterface] = ACTIONS(680),
    [anon_sym_interface] = ACTIONS(682),
    [anon_sym_byte] = ACTIONS(682),
    [anon_sym_short] = ACTIONS(682),
    [anon_sym_int] = ACTIONS(682),
    [anon_sym_long] = ACTIONS(682),
    [anon_sym_char] = ACTIONS(682),
    [anon_sym_float] = ACTIONS(682),
    [anon_sym_double] = ACTIONS(682),
    [sym_boolean_type] = ACTIONS(682),
    [sym_void_type] = ACTIONS(682),
    [sym_this] = ACTIONS(682),
    [sym_super] = ACTIONS(682),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [214] = {
    [ts_builtin_sym_end] = ACTIONS(684),
    [sym_identifier] = ACTIONS(686),
    [sym_decimal_integer_literal] = ACTIONS(686),
    [sym_hex_integer_literal] = ACTIONS(686),
    [sym_octal_integer_literal] = ACTIONS(684),
    [sym_binary_integer_literal] = ACTIONS(684),
    [sym_decimal_floating_point_literal] = ACTIONS(684),
    [sym_hex_floating_point_literal] = ACTIONS(686),
    [sym_true] = ACTIONS(686),
    [sym_false] = ACTIONS(686),
    [sym_character_literal] = ACTIONS(684),
    [sym_string_literal] = ACTIONS(684),
    [sym_null_literal] = ACTIONS(686),
    [anon_sym_LPAREN] = ACTIONS(684),
    [anon_sym_PLUS] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(686),
    [anon_sym_BANG] = ACTIONS(684),
    [anon_sym_TILDE] = ACTIONS(684),
    [anon_sym_PLUS_PLUS] = ACTIONS(684),
    [anon_sym_DASH_DASH] = ACTIONS(684),
    [anon_sym_new] = ACTIONS(686),
    [anon_sym_class] = ACTIONS(686),
    [anon_sym_switch] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(684),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_case] = ACTIONS(686),
    [anon_sym_default] = ACTIONS(686),
    [anon_sym_SEMI] = ACTIONS(684),
    [anon_sym_assert] = ACTIONS(686),
    [anon_sym_do] = ACTIONS(686),
    [anon_sym_while] = ACTIONS(686),
    [anon_sym_break] = ACTIONS(686),
    [anon_sym_continue] = ACTIONS(686),
    [anon_sym_return] = ACTIONS(686),
    [anon_sym_yield] = ACTIONS(686),
    [anon_sym_synchronized] = ACTIONS(686),
    [anon_sym_throw] = ACTIONS(686),
    [anon_sym_try] = ACTIONS(686),
    [anon_sym_if] = ACTIONS(686),
    [anon_sym_else] = ACTIONS(686),
    [anon_sym_for] = ACTIONS(686),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_open] = ACTIONS(686),
    [anon_sym_module] = ACTIONS(686),
    [anon_sym_static] = ACTIONS(686),
    [anon_sym_package] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(686),
    [anon_sym_enum] = ACTIONS(686),
    [anon_sym_public] = ACTIONS(686),
    [anon_sym_protected] = ACTIONS(686),
    [anon_sym_private] = ACTIONS(686),
    [anon_sym_abstract] = ACTIONS(686),
    [anon_sym_final] = ACTIONS(686),
    [anon_sym_strictfp] = ACTIONS(686),
    [anon_sym_native] = ACTIONS(686),
    [anon_sym_transient] = ACTIONS(686),
    [anon_sym_volatile] = ACTIONS(686),
    [anon_sym_ATinterface] = ACTIONS(684),
    [anon_sym_interface] = ACTIONS(686),
    [anon_sym_byte] = ACTIONS(686),
    [anon_sym_short] = ACTIONS(686),
    [anon_sym_int] = ACTIONS(686),
    [anon_sym_long] = ACTIONS(686),
    [anon_sym_char] = ACTIONS(686),
    [anon_sym_float] = ACTIONS(686),
    [anon_sym_double] = ACTIONS(686),
    [sym_boolean_type] = ACTIONS(686),
    [sym_void_type] = ACTIONS(686),
    [sym_this] = ACTIONS(686),
    [sym_super] = ACTIONS(686),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [215] = {
    [ts_builtin_sym_end] = ACTIONS(688),
    [sym_identifier] = ACTIONS(690),
    [sym_decimal_integer_literal] = ACTIONS(690),
    [sym_hex_integer_literal] = ACTIONS(690),
    [sym_octal_integer_literal] = ACTIONS(688),
    [sym_binary_integer_literal] = ACTIONS(688),
    [sym_decimal_floating_point_literal] = ACTIONS(688),
    [sym_hex_floating_point_literal] = ACTIONS(690),
    [sym_true] = ACTIONS(690),
    [sym_false] = ACTIONS(690),
    [sym_character_literal] = ACTIONS(688),
    [sym_string_literal] = ACTIONS(688),
    [sym_null_literal] = ACTIONS(690),
    [anon_sym_LPAREN] = ACTIONS(688),
    [anon_sym_PLUS] = ACTIONS(690),
    [anon_sym_DASH] = ACTIONS(690),
    [anon_sym_BANG] = ACTIONS(688),
    [anon_sym_TILDE] = ACTIONS(688),
    [anon_sym_PLUS_PLUS] = ACTIONS(688),
    [anon_sym_DASH_DASH] = ACTIONS(688),
    [anon_sym_new] = ACTIONS(690),
    [anon_sym_class] = ACTIONS(690),
    [anon_sym_switch] = ACTIONS(690),
    [anon_sym_LBRACE] = ACTIONS(688),
    [anon_sym_RBRACE] = ACTIONS(688),
    [anon_sym_case] = ACTIONS(690),
    [anon_sym_default] = ACTIONS(690),
    [anon_sym_SEMI] = ACTIONS(688),
    [anon_sym_assert] = ACTIONS(690),
    [anon_sym_do] = ACTIONS(690),
    [anon_sym_while] = ACTIONS(690),
    [anon_sym_break] = ACTIONS(690),
    [anon_sym_continue] = ACTIONS(690),
    [anon_sym_return] = ACTIONS(690),
    [anon_sym_yield] = ACTIONS(690),
    [anon_sym_synchronized] = ACTIONS(690),
    [anon_sym_throw] = ACTIONS(690),
    [anon_sym_try] = ACTIONS(690),
    [anon_sym_if] = ACTIONS(690),
    [anon_sym_else] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(690),
    [anon_sym_AT] = ACTIONS(690),
    [anon_sym_open] = ACTIONS(690),
    [anon_sym_module] = ACTIONS(690),
    [anon_sym_static] = ACTIONS(690),
    [anon_sym_package] = ACTIONS(690),
    [anon_sym_import] = ACTIONS(690),
    [anon_sym_enum] = ACTIONS(690),
    [anon_sym_public] = ACTIONS(690),
    [anon_sym_protected] = ACTIONS(690),
    [anon_sym_private] = ACTIONS(690),
    [anon_sym_abstract] = ACTIONS(690),
    [anon_sym_final] = ACTIONS(690),
    [anon_sym_strictfp] = ACTIONS(690),
    [anon_sym_native] = ACTIONS(690),
    [anon_sym_transient] = ACTIONS(690),
    [anon_sym_volatile] = ACTIONS(690),
    [anon_sym_ATinterface] = ACTIONS(688),
    [anon_sym_interface] = ACTIONS(690),
    [anon_sym_byte] = ACTIONS(690),
    [anon_sym_short] = ACTIONS(690),
    [anon_sym_int] = ACTIONS(690),
    [anon_sym_long] = ACTIONS(690),
    [anon_sym_char] = ACTIONS(690),
    [anon_sym_float] = ACTIONS(690),
    [anon_sym_double] = ACTIONS(690),
    [sym_boolean_type] = ACTIONS(690),
    [sym_void_type] = ACTIONS(690),
    [sym_this] = ACTIONS(690),
    [sym_super] = ACTIONS(690),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [216] = {
    [ts_builtin_sym_end] = ACTIONS(692),
    [sym_identifier] = ACTIONS(694),
    [sym_decimal_integer_literal] = ACTIONS(694),
    [sym_hex_integer_literal] = ACTIONS(694),
    [sym_octal_integer_literal] = ACTIONS(692),
    [sym_binary_integer_literal] = ACTIONS(692),
    [sym_decimal_floating_point_literal] = ACTIONS(692),
    [sym_hex_floating_point_literal] = ACTIONS(694),
    [sym_true] = ACTIONS(694),
    [sym_false] = ACTIONS(694),
    [sym_character_literal] = ACTIONS(692),
    [sym_string_literal] = ACTIONS(692),
    [sym_null_literal] = ACTIONS(694),
    [anon_sym_LPAREN] = ACTIONS(692),
    [anon_sym_PLUS] = ACTIONS(694),
    [anon_sym_DASH] = ACTIONS(694),
    [anon_sym_BANG] = ACTIONS(692),
    [anon_sym_TILDE] = ACTIONS(692),
    [anon_sym_PLUS_PLUS] = ACTIONS(692),
    [anon_sym_DASH_DASH] = ACTIONS(692),
    [anon_sym_new] = ACTIONS(694),
    [anon_sym_class] = ACTIONS(694),
    [anon_sym_switch] = ACTIONS(694),
    [anon_sym_LBRACE] = ACTIONS(692),
    [anon_sym_RBRACE] = ACTIONS(692),
    [anon_sym_case] = ACTIONS(694),
    [anon_sym_default] = ACTIONS(694),
    [anon_sym_SEMI] = ACTIONS(692),
    [anon_sym_assert] = ACTIONS(694),
    [anon_sym_do] = ACTIONS(694),
    [anon_sym_while] = ACTIONS(694),
    [anon_sym_break] = ACTIONS(694),
    [anon_sym_continue] = ACTIONS(694),
    [anon_sym_return] = ACTIONS(694),
    [anon_sym_yield] = ACTIONS(694),
    [anon_sym_synchronized] = ACTIONS(694),
    [anon_sym_throw] = ACTIONS(694),
    [anon_sym_try] = ACTIONS(694),
    [anon_sym_if] = ACTIONS(694),
    [anon_sym_else] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(694),
    [anon_sym_open] = ACTIONS(694),
    [anon_sym_module] = ACTIONS(694),
    [anon_sym_static] = ACTIONS(694),
    [anon_sym_package] = ACTIONS(694),
    [anon_sym_import] = ACTIONS(694),
    [anon_sym_enum] = ACTIONS(694),
    [anon_sym_public] = ACTIONS(694),
    [anon_sym_protected] = ACTIONS(694),
    [anon_sym_private] = ACTIONS(694),
    [anon_sym_abstract] = ACTIONS(694),
    [anon_sym_final] = ACTIONS(694),
    [anon_sym_strictfp] = ACTIONS(694),
    [anon_sym_native] = ACTIONS(694),
    [anon_sym_transient] = ACTIONS(694),
    [anon_sym_volatile] = ACTIONS(694),
    [anon_sym_ATinterface] = ACTIONS(692),
    [anon_sym_interface] = ACTIONS(694),
    [anon_sym_byte] = ACTIONS(694),
    [anon_sym_short] = ACTIONS(694),
    [anon_sym_int] = ACTIONS(694),
    [anon_sym_long] = ACTIONS(694),
    [anon_sym_char] = ACTIONS(694),
    [anon_sym_float] = ACTIONS(694),
    [anon_sym_double] = ACTIONS(694),
    [sym_boolean_type] = ACTIONS(694),
    [sym_void_type] = ACTIONS(694),
    [sym_this] = ACTIONS(694),
    [sym_super] = ACTIONS(694),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [217] = {
    [ts_builtin_sym_end] = ACTIONS(696),
    [sym_identifier] = ACTIONS(698),
    [sym_decimal_integer_literal] = ACTIONS(698),
    [sym_hex_integer_literal] = ACTIONS(698),
    [sym_octal_integer_literal] = ACTIONS(696),
    [sym_binary_integer_literal] = ACTIONS(696),
    [sym_decimal_floating_point_literal] = ACTIONS(696),
    [sym_hex_floating_point_literal] = ACTIONS(698),
    [sym_true] = ACTIONS(698),
    [sym_false] = ACTIONS(698),
    [sym_character_literal] = ACTIONS(696),
    [sym_string_literal] = ACTIONS(696),
    [sym_null_literal] = ACTIONS(698),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_BANG] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_PLUS_PLUS] = ACTIONS(696),
    [anon_sym_DASH_DASH] = ACTIONS(696),
    [anon_sym_new] = ACTIONS(698),
    [anon_sym_class] = ACTIONS(698),
    [anon_sym_switch] = ACTIONS(698),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_case] = ACTIONS(698),
    [anon_sym_default] = ACTIONS(698),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_assert] = ACTIONS(698),
    [anon_sym_do] = ACTIONS(698),
    [anon_sym_while] = ACTIONS(698),
    [anon_sym_break] = ACTIONS(698),
    [anon_sym_continue] = ACTIONS(698),
    [anon_sym_return] = ACTIONS(698),
    [anon_sym_yield] = ACTIONS(698),
    [anon_sym_synchronized] = ACTIONS(698),
    [anon_sym_throw] = ACTIONS(698),
    [anon_sym_try] = ACTIONS(698),
    [anon_sym_if] = ACTIONS(698),
    [anon_sym_else] = ACTIONS(698),
    [anon_sym_for] = ACTIONS(698),
    [anon_sym_AT] = ACTIONS(698),
    [anon_sym_open] = ACTIONS(698),
    [anon_sym_module] = ACTIONS(698),
    [anon_sym_static] = ACTIONS(698),
    [anon_sym_package] = ACTIONS(698),
    [anon_sym_import] = ACTIONS(698),
    [anon_sym_enum] = ACTIONS(698),
    [anon_sym_public] = ACTIONS(698),
    [anon_sym_protected] = ACTIONS(698),
    [anon_sym_private] = ACTIONS(698),
    [anon_sym_abstract] = ACTIONS(698),
    [anon_sym_final] = ACTIONS(698),
    [anon_sym_strictfp] = ACTIONS(698),
    [anon_sym_native] = ACTIONS(698),
    [anon_sym_transient] = ACTIONS(698),
    [anon_sym_volatile] = ACTIONS(698),
    [anon_sym_ATinterface] = ACTIONS(696),
    [anon_sym_interface] = ACTIONS(698),
    [anon_sym_byte] = ACTIONS(698),
    [anon_sym_short] = ACTIONS(698),
    [anon_sym_int] = ACTIONS(698),
    [anon_sym_long] = ACTIONS(698),
    [anon_sym_char] = ACTIONS(698),
    [anon_sym_float] = ACTIONS(698),
    [anon_sym_double] = ACTIONS(698),
    [sym_boolean_type] = ACTIONS(698),
    [sym_void_type] = ACTIONS(698),
    [sym_this] = ACTIONS(698),
    [sym_super] = ACTIONS(698),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [218] = {
    [ts_builtin_sym_end] = ACTIONS(700),
    [sym_identifier] = ACTIONS(702),
    [sym_decimal_integer_literal] = ACTIONS(702),
    [sym_hex_integer_literal] = ACTIONS(702),
    [sym_octal_integer_literal] = ACTIONS(700),
    [sym_binary_integer_literal] = ACTIONS(700),
    [sym_decimal_floating_point_literal] = ACTIONS(700),
    [sym_hex_floating_point_literal] = ACTIONS(702),
    [sym_true] = ACTIONS(702),
    [sym_false] = ACTIONS(702),
    [sym_character_literal] = ACTIONS(700),
    [sym_string_literal] = ACTIONS(700),
    [sym_null_literal] = ACTIONS(702),
    [anon_sym_LPAREN] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(702),
    [anon_sym_BANG] = ACTIONS(700),
    [anon_sym_TILDE] = ACTIONS(700),
    [anon_sym_PLUS_PLUS] = ACTIONS(700),
    [anon_sym_DASH_DASH] = ACTIONS(700),
    [anon_sym_new] = ACTIONS(702),
    [anon_sym_class] = ACTIONS(702),
    [anon_sym_switch] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(700),
    [anon_sym_RBRACE] = ACTIONS(700),
    [anon_sym_case] = ACTIONS(702),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_SEMI] = ACTIONS(700),
    [anon_sym_assert] = ACTIONS(702),
    [anon_sym_do] = ACTIONS(702),
    [anon_sym_while] = ACTIONS(702),
    [anon_sym_break] = ACTIONS(702),
    [anon_sym_continue] = ACTIONS(702),
    [anon_sym_return] = ACTIONS(702),
    [anon_sym_yield] = ACTIONS(702),
    [anon_sym_synchronized] = ACTIONS(702),
    [anon_sym_throw] = ACTIONS(702),
    [anon_sym_try] = ACTIONS(702),
    [anon_sym_if] = ACTIONS(702),
    [anon_sym_else] = ACTIONS(702),
    [anon_sym_for] = ACTIONS(702),
    [anon_sym_AT] = ACTIONS(702),
    [anon_sym_open] = ACTIONS(702),
    [anon_sym_module] = ACTIONS(702),
    [anon_sym_static] = ACTIONS(702),
    [anon_sym_package] = ACTIONS(702),
    [anon_sym_import] = ACTIONS(702),
    [anon_sym_enum] = ACTIONS(702),
    [anon_sym_public] = ACTIONS(702),
    [anon_sym_protected] = ACTIONS(702),
    [anon_sym_private] = ACTIONS(702),
    [anon_sym_abstract] = ACTIONS(702),
    [anon_sym_final] = ACTIONS(702),
    [anon_sym_strictfp] = ACTIONS(702),
    [anon_sym_native] = ACTIONS(702),
    [anon_sym_transient] = ACTIONS(702),
    [anon_sym_volatile] = ACTIONS(702),
    [anon_sym_ATinterface] = ACTIONS(700),
    [anon_sym_interface] = ACTIONS(702),
    [anon_sym_byte] = ACTIONS(702),
    [anon_sym_short] = ACTIONS(702),
    [anon_sym_int] = ACTIONS(702),
    [anon_sym_long] = ACTIONS(702),
    [anon_sym_char] = ACTIONS(702),
    [anon_sym_float] = ACTIONS(702),
    [anon_sym_double] = ACTIONS(702),
    [sym_boolean_type] = ACTIONS(702),
    [sym_void_type] = ACTIONS(702),
    [sym_this] = ACTIONS(702),
    [sym_super] = ACTIONS(702),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [219] = {
    [ts_builtin_sym_end] = ACTIONS(704),
    [sym_identifier] = ACTIONS(706),
    [sym_decimal_integer_literal] = ACTIONS(706),
    [sym_hex_integer_literal] = ACTIONS(706),
    [sym_octal_integer_literal] = ACTIONS(704),
    [sym_binary_integer_literal] = ACTIONS(704),
    [sym_decimal_floating_point_literal] = ACTIONS(704),
    [sym_hex_floating_point_literal] = ACTIONS(706),
    [sym_true] = ACTIONS(706),
    [sym_false] = ACTIONS(706),
    [sym_character_literal] = ACTIONS(704),
    [sym_string_literal] = ACTIONS(704),
    [sym_null_literal] = ACTIONS(706),
    [anon_sym_LPAREN] = ACTIONS(704),
    [anon_sym_PLUS] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(706),
    [anon_sym_BANG] = ACTIONS(704),
    [anon_sym_TILDE] = ACTIONS(704),
    [anon_sym_PLUS_PLUS] = ACTIONS(704),
    [anon_sym_DASH_DASH] = ACTIONS(704),
    [anon_sym_new] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(706),
    [anon_sym_switch] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_RBRACE] = ACTIONS(704),
    [anon_sym_case] = ACTIONS(706),
    [anon_sym_default] = ACTIONS(706),
    [anon_sym_SEMI] = ACTIONS(704),
    [anon_sym_assert] = ACTIONS(706),
    [anon_sym_do] = ACTIONS(706),
    [anon_sym_while] = ACTIONS(706),
    [anon_sym_break] = ACTIONS(706),
    [anon_sym_continue] = ACTIONS(706),
    [anon_sym_return] = ACTIONS(706),
    [anon_sym_yield] = ACTIONS(706),
    [anon_sym_synchronized] = ACTIONS(706),
    [anon_sym_throw] = ACTIONS(706),
    [anon_sym_try] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(706),
    [anon_sym_else] = ACTIONS(706),
    [anon_sym_for] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_open] = ACTIONS(706),
    [anon_sym_module] = ACTIONS(706),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_package] = ACTIONS(706),
    [anon_sym_import] = ACTIONS(706),
    [anon_sym_enum] = ACTIONS(706),
    [anon_sym_public] = ACTIONS(706),
    [anon_sym_protected] = ACTIONS(706),
    [anon_sym_private] = ACTIONS(706),
    [anon_sym_abstract] = ACTIONS(706),
    [anon_sym_final] = ACTIONS(706),
    [anon_sym_strictfp] = ACTIONS(706),
    [anon_sym_native] = ACTIONS(706),
    [anon_sym_transient] = ACTIONS(706),
    [anon_sym_volatile] = ACTIONS(706),
    [anon_sym_ATinterface] = ACTIONS(704),
    [anon_sym_interface] = ACTIONS(706),
    [anon_sym_byte] = ACTIONS(706),
    [anon_sym_short] = ACTIONS(706),
    [anon_sym_int] = ACTIONS(706),
    [anon_sym_long] = ACTIONS(706),
    [anon_sym_char] = ACTIONS(706),
    [anon_sym_float] = ACTIONS(706),
    [anon_sym_double] = ACTIONS(706),
    [sym_boolean_type] = ACTIONS(706),
    [sym_void_type] = ACTIONS(706),
    [sym_this] = ACTIONS(706),
    [sym_super] = ACTIONS(706),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [220] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(415),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1002),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(304),
    [sym_array_access] = STATE(304),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1002),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(410),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(420),
    [anon_sym_module] = ACTIONS(420),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [221] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(433),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [222] = {
    [ts_builtin_sym_end] = ACTIONS(708),
    [sym_identifier] = ACTIONS(710),
    [sym_decimal_integer_literal] = ACTIONS(710),
    [sym_hex_integer_literal] = ACTIONS(710),
    [sym_octal_integer_literal] = ACTIONS(708),
    [sym_binary_integer_literal] = ACTIONS(708),
    [sym_decimal_floating_point_literal] = ACTIONS(708),
    [sym_hex_floating_point_literal] = ACTIONS(710),
    [sym_true] = ACTIONS(710),
    [sym_false] = ACTIONS(710),
    [sym_character_literal] = ACTIONS(708),
    [sym_string_literal] = ACTIONS(708),
    [sym_null_literal] = ACTIONS(710),
    [anon_sym_LPAREN] = ACTIONS(708),
    [anon_sym_PLUS] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(710),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_TILDE] = ACTIONS(708),
    [anon_sym_PLUS_PLUS] = ACTIONS(708),
    [anon_sym_DASH_DASH] = ACTIONS(708),
    [anon_sym_new] = ACTIONS(710),
    [anon_sym_class] = ACTIONS(710),
    [anon_sym_switch] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(708),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_case] = ACTIONS(710),
    [anon_sym_default] = ACTIONS(710),
    [anon_sym_SEMI] = ACTIONS(708),
    [anon_sym_assert] = ACTIONS(710),
    [anon_sym_do] = ACTIONS(710),
    [anon_sym_while] = ACTIONS(710),
    [anon_sym_break] = ACTIONS(710),
    [anon_sym_continue] = ACTIONS(710),
    [anon_sym_return] = ACTIONS(710),
    [anon_sym_yield] = ACTIONS(710),
    [anon_sym_synchronized] = ACTIONS(710),
    [anon_sym_throw] = ACTIONS(710),
    [anon_sym_try] = ACTIONS(710),
    [anon_sym_if] = ACTIONS(710),
    [anon_sym_else] = ACTIONS(710),
    [anon_sym_for] = ACTIONS(710),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_open] = ACTIONS(710),
    [anon_sym_module] = ACTIONS(710),
    [anon_sym_static] = ACTIONS(710),
    [anon_sym_package] = ACTIONS(710),
    [anon_sym_import] = ACTIONS(710),
    [anon_sym_enum] = ACTIONS(710),
    [anon_sym_public] = ACTIONS(710),
    [anon_sym_protected] = ACTIONS(710),
    [anon_sym_private] = ACTIONS(710),
    [anon_sym_abstract] = ACTIONS(710),
    [anon_sym_final] = ACTIONS(710),
    [anon_sym_strictfp] = ACTIONS(710),
    [anon_sym_native] = ACTIONS(710),
    [anon_sym_transient] = ACTIONS(710),
    [anon_sym_volatile] = ACTIONS(710),
    [anon_sym_ATinterface] = ACTIONS(708),
    [anon_sym_interface] = ACTIONS(710),
    [anon_sym_byte] = ACTIONS(710),
    [anon_sym_short] = ACTIONS(710),
    [anon_sym_int] = ACTIONS(710),
    [anon_sym_long] = ACTIONS(710),
    [anon_sym_char] = ACTIONS(710),
    [anon_sym_float] = ACTIONS(710),
    [anon_sym_double] = ACTIONS(710),
    [sym_boolean_type] = ACTIONS(710),
    [sym_void_type] = ACTIONS(710),
    [sym_this] = ACTIONS(710),
    [sym_super] = ACTIONS(710),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [223] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(512),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [224] = {
    [ts_builtin_sym_end] = ACTIONS(712),
    [sym_identifier] = ACTIONS(714),
    [sym_decimal_integer_literal] = ACTIONS(714),
    [sym_hex_integer_literal] = ACTIONS(714),
    [sym_octal_integer_literal] = ACTIONS(712),
    [sym_binary_integer_literal] = ACTIONS(712),
    [sym_decimal_floating_point_literal] = ACTIONS(712),
    [sym_hex_floating_point_literal] = ACTIONS(714),
    [sym_true] = ACTIONS(714),
    [sym_false] = ACTIONS(714),
    [sym_character_literal] = ACTIONS(712),
    [sym_string_literal] = ACTIONS(712),
    [sym_null_literal] = ACTIONS(714),
    [anon_sym_LPAREN] = ACTIONS(712),
    [anon_sym_PLUS] = ACTIONS(714),
    [anon_sym_DASH] = ACTIONS(714),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_TILDE] = ACTIONS(712),
    [anon_sym_PLUS_PLUS] = ACTIONS(712),
    [anon_sym_DASH_DASH] = ACTIONS(712),
    [anon_sym_new] = ACTIONS(714),
    [anon_sym_class] = ACTIONS(714),
    [anon_sym_switch] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(712),
    [anon_sym_RBRACE] = ACTIONS(712),
    [anon_sym_case] = ACTIONS(714),
    [anon_sym_default] = ACTIONS(714),
    [anon_sym_SEMI] = ACTIONS(712),
    [anon_sym_assert] = ACTIONS(714),
    [anon_sym_do] = ACTIONS(714),
    [anon_sym_while] = ACTIONS(714),
    [anon_sym_break] = ACTIONS(714),
    [anon_sym_continue] = ACTIONS(714),
    [anon_sym_return] = ACTIONS(714),
    [anon_sym_yield] = ACTIONS(714),
    [anon_sym_synchronized] = ACTIONS(714),
    [anon_sym_throw] = ACTIONS(714),
    [anon_sym_try] = ACTIONS(714),
    [anon_sym_if] = ACTIONS(714),
    [anon_sym_else] = ACTIONS(714),
    [anon_sym_for] = ACTIONS(714),
    [anon_sym_AT] = ACTIONS(714),
    [anon_sym_open] = ACTIONS(714),
    [anon_sym_module] = ACTIONS(714),
    [anon_sym_static] = ACTIONS(714),
    [anon_sym_package] = ACTIONS(714),
    [anon_sym_import] = ACTIONS(714),
    [anon_sym_enum] = ACTIONS(714),
    [anon_sym_public] = ACTIONS(714),
    [anon_sym_protected] = ACTIONS(714),
    [anon_sym_private] = ACTIONS(714),
    [anon_sym_abstract] = ACTIONS(714),
    [anon_sym_final] = ACTIONS(714),
    [anon_sym_strictfp] = ACTIONS(714),
    [anon_sym_native] = ACTIONS(714),
    [anon_sym_transient] = ACTIONS(714),
    [anon_sym_volatile] = ACTIONS(714),
    [anon_sym_ATinterface] = ACTIONS(712),
    [anon_sym_interface] = ACTIONS(714),
    [anon_sym_byte] = ACTIONS(714),
    [anon_sym_short] = ACTIONS(714),
    [anon_sym_int] = ACTIONS(714),
    [anon_sym_long] = ACTIONS(714),
    [anon_sym_char] = ACTIONS(714),
    [anon_sym_float] = ACTIONS(714),
    [anon_sym_double] = ACTIONS(714),
    [sym_boolean_type] = ACTIONS(714),
    [sym_void_type] = ACTIONS(714),
    [sym_this] = ACTIONS(714),
    [sym_super] = ACTIONS(714),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [225] = {
    [ts_builtin_sym_end] = ACTIONS(716),
    [sym_identifier] = ACTIONS(718),
    [sym_decimal_integer_literal] = ACTIONS(718),
    [sym_hex_integer_literal] = ACTIONS(718),
    [sym_octal_integer_literal] = ACTIONS(716),
    [sym_binary_integer_literal] = ACTIONS(716),
    [sym_decimal_floating_point_literal] = ACTIONS(716),
    [sym_hex_floating_point_literal] = ACTIONS(718),
    [sym_true] = ACTIONS(718),
    [sym_false] = ACTIONS(718),
    [sym_character_literal] = ACTIONS(716),
    [sym_string_literal] = ACTIONS(716),
    [sym_null_literal] = ACTIONS(718),
    [anon_sym_LPAREN] = ACTIONS(716),
    [anon_sym_PLUS] = ACTIONS(718),
    [anon_sym_DASH] = ACTIONS(718),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_TILDE] = ACTIONS(716),
    [anon_sym_PLUS_PLUS] = ACTIONS(716),
    [anon_sym_DASH_DASH] = ACTIONS(716),
    [anon_sym_new] = ACTIONS(718),
    [anon_sym_class] = ACTIONS(718),
    [anon_sym_switch] = ACTIONS(718),
    [anon_sym_LBRACE] = ACTIONS(716),
    [anon_sym_RBRACE] = ACTIONS(716),
    [anon_sym_case] = ACTIONS(718),
    [anon_sym_default] = ACTIONS(718),
    [anon_sym_SEMI] = ACTIONS(716),
    [anon_sym_assert] = ACTIONS(718),
    [anon_sym_do] = ACTIONS(718),
    [anon_sym_while] = ACTIONS(718),
    [anon_sym_break] = ACTIONS(718),
    [anon_sym_continue] = ACTIONS(718),
    [anon_sym_return] = ACTIONS(718),
    [anon_sym_yield] = ACTIONS(718),
    [anon_sym_synchronized] = ACTIONS(718),
    [anon_sym_throw] = ACTIONS(718),
    [anon_sym_try] = ACTIONS(718),
    [anon_sym_if] = ACTIONS(718),
    [anon_sym_else] = ACTIONS(718),
    [anon_sym_for] = ACTIONS(718),
    [anon_sym_AT] = ACTIONS(718),
    [anon_sym_open] = ACTIONS(718),
    [anon_sym_module] = ACTIONS(718),
    [anon_sym_static] = ACTIONS(718),
    [anon_sym_package] = ACTIONS(718),
    [anon_sym_import] = ACTIONS(718),
    [anon_sym_enum] = ACTIONS(718),
    [anon_sym_public] = ACTIONS(718),
    [anon_sym_protected] = ACTIONS(718),
    [anon_sym_private] = ACTIONS(718),
    [anon_sym_abstract] = ACTIONS(718),
    [anon_sym_final] = ACTIONS(718),
    [anon_sym_strictfp] = ACTIONS(718),
    [anon_sym_native] = ACTIONS(718),
    [anon_sym_transient] = ACTIONS(718),
    [anon_sym_volatile] = ACTIONS(718),
    [anon_sym_ATinterface] = ACTIONS(716),
    [anon_sym_interface] = ACTIONS(718),
    [anon_sym_byte] = ACTIONS(718),
    [anon_sym_short] = ACTIONS(718),
    [anon_sym_int] = ACTIONS(718),
    [anon_sym_long] = ACTIONS(718),
    [anon_sym_char] = ACTIONS(718),
    [anon_sym_float] = ACTIONS(718),
    [anon_sym_double] = ACTIONS(718),
    [sym_boolean_type] = ACTIONS(718),
    [sym_void_type] = ACTIONS(718),
    [sym_this] = ACTIONS(718),
    [sym_super] = ACTIONS(718),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [226] = {
    [ts_builtin_sym_end] = ACTIONS(720),
    [sym_identifier] = ACTIONS(722),
    [sym_decimal_integer_literal] = ACTIONS(722),
    [sym_hex_integer_literal] = ACTIONS(722),
    [sym_octal_integer_literal] = ACTIONS(720),
    [sym_binary_integer_literal] = ACTIONS(720),
    [sym_decimal_floating_point_literal] = ACTIONS(720),
    [sym_hex_floating_point_literal] = ACTIONS(722),
    [sym_true] = ACTIONS(722),
    [sym_false] = ACTIONS(722),
    [sym_character_literal] = ACTIONS(720),
    [sym_string_literal] = ACTIONS(720),
    [sym_null_literal] = ACTIONS(722),
    [anon_sym_LPAREN] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(722),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_TILDE] = ACTIONS(720),
    [anon_sym_PLUS_PLUS] = ACTIONS(720),
    [anon_sym_DASH_DASH] = ACTIONS(720),
    [anon_sym_new] = ACTIONS(722),
    [anon_sym_class] = ACTIONS(722),
    [anon_sym_switch] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(720),
    [anon_sym_RBRACE] = ACTIONS(720),
    [anon_sym_case] = ACTIONS(722),
    [anon_sym_default] = ACTIONS(722),
    [anon_sym_SEMI] = ACTIONS(720),
    [anon_sym_assert] = ACTIONS(722),
    [anon_sym_do] = ACTIONS(722),
    [anon_sym_while] = ACTIONS(722),
    [anon_sym_break] = ACTIONS(722),
    [anon_sym_continue] = ACTIONS(722),
    [anon_sym_return] = ACTIONS(722),
    [anon_sym_yield] = ACTIONS(722),
    [anon_sym_synchronized] = ACTIONS(722),
    [anon_sym_throw] = ACTIONS(722),
    [anon_sym_try] = ACTIONS(722),
    [anon_sym_if] = ACTIONS(722),
    [anon_sym_else] = ACTIONS(722),
    [anon_sym_for] = ACTIONS(722),
    [anon_sym_AT] = ACTIONS(722),
    [anon_sym_open] = ACTIONS(722),
    [anon_sym_module] = ACTIONS(722),
    [anon_sym_static] = ACTIONS(722),
    [anon_sym_package] = ACTIONS(722),
    [anon_sym_import] = ACTIONS(722),
    [anon_sym_enum] = ACTIONS(722),
    [anon_sym_public] = ACTIONS(722),
    [anon_sym_protected] = ACTIONS(722),
    [anon_sym_private] = ACTIONS(722),
    [anon_sym_abstract] = ACTIONS(722),
    [anon_sym_final] = ACTIONS(722),
    [anon_sym_strictfp] = ACTIONS(722),
    [anon_sym_native] = ACTIONS(722),
    [anon_sym_transient] = ACTIONS(722),
    [anon_sym_volatile] = ACTIONS(722),
    [anon_sym_ATinterface] = ACTIONS(720),
    [anon_sym_interface] = ACTIONS(722),
    [anon_sym_byte] = ACTIONS(722),
    [anon_sym_short] = ACTIONS(722),
    [anon_sym_int] = ACTIONS(722),
    [anon_sym_long] = ACTIONS(722),
    [anon_sym_char] = ACTIONS(722),
    [anon_sym_float] = ACTIONS(722),
    [anon_sym_double] = ACTIONS(722),
    [sym_boolean_type] = ACTIONS(722),
    [sym_void_type] = ACTIONS(722),
    [sym_this] = ACTIONS(722),
    [sym_super] = ACTIONS(722),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [227] = {
    [ts_builtin_sym_end] = ACTIONS(724),
    [sym_identifier] = ACTIONS(726),
    [sym_decimal_integer_literal] = ACTIONS(726),
    [sym_hex_integer_literal] = ACTIONS(726),
    [sym_octal_integer_literal] = ACTIONS(724),
    [sym_binary_integer_literal] = ACTIONS(724),
    [sym_decimal_floating_point_literal] = ACTIONS(724),
    [sym_hex_floating_point_literal] = ACTIONS(726),
    [sym_true] = ACTIONS(726),
    [sym_false] = ACTIONS(726),
    [sym_character_literal] = ACTIONS(724),
    [sym_string_literal] = ACTIONS(724),
    [sym_null_literal] = ACTIONS(726),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_PLUS] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(726),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_TILDE] = ACTIONS(724),
    [anon_sym_PLUS_PLUS] = ACTIONS(724),
    [anon_sym_DASH_DASH] = ACTIONS(724),
    [anon_sym_new] = ACTIONS(726),
    [anon_sym_class] = ACTIONS(726),
    [anon_sym_switch] = ACTIONS(726),
    [anon_sym_LBRACE] = ACTIONS(724),
    [anon_sym_RBRACE] = ACTIONS(724),
    [anon_sym_case] = ACTIONS(726),
    [anon_sym_default] = ACTIONS(726),
    [anon_sym_SEMI] = ACTIONS(724),
    [anon_sym_assert] = ACTIONS(726),
    [anon_sym_do] = ACTIONS(726),
    [anon_sym_while] = ACTIONS(726),
    [anon_sym_break] = ACTIONS(726),
    [anon_sym_continue] = ACTIONS(726),
    [anon_sym_return] = ACTIONS(726),
    [anon_sym_yield] = ACTIONS(726),
    [anon_sym_synchronized] = ACTIONS(726),
    [anon_sym_throw] = ACTIONS(726),
    [anon_sym_try] = ACTIONS(726),
    [anon_sym_if] = ACTIONS(726),
    [anon_sym_else] = ACTIONS(726),
    [anon_sym_for] = ACTIONS(726),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_open] = ACTIONS(726),
    [anon_sym_module] = ACTIONS(726),
    [anon_sym_static] = ACTIONS(726),
    [anon_sym_package] = ACTIONS(726),
    [anon_sym_import] = ACTIONS(726),
    [anon_sym_enum] = ACTIONS(726),
    [anon_sym_public] = ACTIONS(726),
    [anon_sym_protected] = ACTIONS(726),
    [anon_sym_private] = ACTIONS(726),
    [anon_sym_abstract] = ACTIONS(726),
    [anon_sym_final] = ACTIONS(726),
    [anon_sym_strictfp] = ACTIONS(726),
    [anon_sym_native] = ACTIONS(726),
    [anon_sym_transient] = ACTIONS(726),
    [anon_sym_volatile] = ACTIONS(726),
    [anon_sym_ATinterface] = ACTIONS(724),
    [anon_sym_interface] = ACTIONS(726),
    [anon_sym_byte] = ACTIONS(726),
    [anon_sym_short] = ACTIONS(726),
    [anon_sym_int] = ACTIONS(726),
    [anon_sym_long] = ACTIONS(726),
    [anon_sym_char] = ACTIONS(726),
    [anon_sym_float] = ACTIONS(726),
    [anon_sym_double] = ACTIONS(726),
    [sym_boolean_type] = ACTIONS(726),
    [sym_void_type] = ACTIONS(726),
    [sym_this] = ACTIONS(726),
    [sym_super] = ACTIONS(726),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [228] = {
    [sym__literal] = STATE(346),
    [sym_expression] = STATE(518),
    [sym_cast_expression] = STATE(421),
    [sym_assignment_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_instanceof_expression] = STATE(421),
    [sym_lambda_expression] = STATE(421),
    [sym_inferred_parameters] = STATE(1016),
    [sym_ternary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_primary_expression] = STATE(362),
    [sym_array_creation_expression] = STATE(346),
    [sym_parenthesized_expression] = STATE(346),
    [sym_class_literal] = STATE(346),
    [sym_object_creation_expression] = STATE(346),
    [sym__unqualified_object_creation_expression] = STATE(363),
    [sym_field_access] = STATE(295),
    [sym_array_access] = STATE(295),
    [sym_method_invocation] = STATE(346),
    [sym_method_reference] = STATE(346),
    [sym_switch_expression] = STATE(412),
    [sym__annotation] = STATE(537),
    [sym_marker_annotation] = STATE(537),
    [sym_annotation] = STATE(537),
    [sym__type] = STATE(1015),
    [sym__unannotated_type] = STATE(619),
    [sym_annotated_type] = STATE(634),
    [sym_scoped_type_identifier] = STATE(599),
    [sym_generic_type] = STATE(618),
    [sym_array_type] = STATE(561),
    [sym_integral_type] = STATE(561),
    [sym_floating_point_type] = STATE(561),
    [sym_formal_parameters] = STATE(1016),
    [aux_sym_dimensions_expr_repeat1] = STATE(537),
    [sym_identifier] = ACTIONS(281),
    [sym_decimal_integer_literal] = ACTIONS(9),
    [sym_hex_integer_literal] = ACTIONS(9),
    [sym_octal_integer_literal] = ACTIONS(11),
    [sym_binary_integer_literal] = ACTIONS(11),
    [sym_decimal_floating_point_literal] = ACTIONS(11),
    [sym_hex_floating_point_literal] = ACTIONS(9),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_character_literal] = ACTIONS(11),
    [sym_string_literal] = ACTIONS(11),
    [sym_null_literal] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(15),
    [anon_sym_DASH] = ACTIONS(15),
    [anon_sym_BANG] = ACTIONS(17),
    [anon_sym_TILDE] = ACTIONS(17),
    [anon_sym_PLUS_PLUS] = ACTIONS(19),
    [anon_sym_DASH_DASH] = ACTIONS(19),
    [anon_sym_new] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(25),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_open] = ACTIONS(279),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_byte] = ACTIONS(73),
    [anon_sym_short] = ACTIONS(73),
    [anon_sym_int] = ACTIONS(73),
    [anon_sym_long] = ACTIONS(73),
    [anon_sym_char] = ACTIONS(73),
    [anon_sym_float] = ACTIONS(75),
    [anon_sym_double] = ACTIONS(75),
    [sym_boolean_type] = ACTIONS(77),
    [sym_void_type] = ACTIONS(77),
    [sym_this] = ACTIONS(79),
    [sym_super] = ACTIONS(81),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [229] = {
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(301),
    [sym_decimal_integer_literal] = ACTIONS(301),
    [sym_hex_integer_literal] = ACTIONS(301),
    [sym_octal_integer_literal] = ACTIONS(299),
    [sym_binary_integer_literal] = ACTIONS(299),
    [sym_decimal_floating_point_literal] = ACTIONS(299),
    [sym_hex_floating_point_literal] = ACTIONS(301),
    [sym_true] = ACTIONS(301),
    [sym_false] = ACTIONS(301),
    [sym_character_literal] = ACTIONS(299),
    [sym_string_literal] = ACTIONS(299),
    [sym_null_literal] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_BANG] = ACTIONS(299),
    [anon_sym_TILDE] = ACTIONS(299),
    [anon_sym_PLUS_PLUS] = ACTIONS(299),
    [anon_sym_DASH_DASH] = ACTIONS(299),
    [anon_sym_new] = ACTIONS(301),
    [anon_sym_class] = ACTIONS(301),
    [anon_sym_switch] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_case] = ACTIONS(301),
    [anon_sym_default] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(299),
    [anon_sym_assert] = ACTIONS(301),
    [anon_sym_do] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_break] = ACTIONS(301),
    [anon_sym_continue] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_yield] = ACTIONS(301),
    [anon_sym_synchronized] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_else] = ACTIONS(301),
    [anon_sym_for] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_open] = ACTIONS(301),
    [anon_sym_module] = ACTIONS(301),
    [anon_sym_static] = ACTIONS(301),
    [anon_sym_package] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(301),
    [anon_sym_enum] = ACTIONS(301),
    [anon_sym_public] = ACTIONS(301),
    [anon_sym_protected] = ACTIONS(301),
    [anon_sym_private] = ACTIONS(301),
    [anon_sym_abstract] = ACTIONS(301),
    [anon_sym_final] = ACTIONS(301),
    [anon_sym_strictfp] = ACTIONS(301),
    [anon_sym_native] = ACTIONS(301),
    [anon_sym_transient] = ACTIONS(301),
    [anon_sym_volatile] = ACTIONS(301),
    [anon_sym_ATinterface] = ACTIONS(299),
    [anon_sym_interface] = ACTIONS(301),
    [anon_sym_byte] = ACTIONS(301),
    [anon_sym_short] = ACTIONS(301),
    [anon_sym_int] = ACTIONS(301),
    [anon_sym_long] = ACTIONS(301),
    [anon_sym_char] = ACTIONS(301),
    [anon_sym_float] = ACTIONS(301),
    [anon_sym_double] = ACTIONS(301),
    [sym_boolean_type] = ACTIONS(301),
    [sym_void_type] = ACTIONS(301),
    [sym_this] = ACTIONS(301),
    [sym_super] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_block_comment] = ACTIONS(3),
  },
  [230] = {
    [ts_builtin_sym_end] = ACTIONS(728),
    [sym_identifier] = ACTIONS(730),
    [sym_decimal_integer_literal] = ACTIONS(730),
    [sym_hex_integer_literal] = ACTIONS(730),
    [sym_octal_integer_literal] = ACTIONS(728),
    [sym_binary_integer_literal] = ACTIONS(728),
    [sym_decimal_floating_point_literal] = ACTIONS(728),
    [sym_hex_floating_point_literal] = ACTIONS(730),
    [sym_true] = ACTIONS(730),
    [sym_false] = ACTIONS(730),
    [sym_character_literal] = ACTIONS(728),
    [sym_string_literal] = ACTIONS(728),
    [sym_null_literal] = ACTIONS(730),
    [anon_sym_LPAREN] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(730),
    [anon_sym_BANG] = ACTIONS(72