#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 428
#define LARGE_STATE_COUNT 39
#define SYMBOL_COUNT 250
#define ALIAS_COUNT 0
#define TOKEN_COUNT 162
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_ident = 1,
  sym_decimal_float_literal = 2,
  sym_hex_float_literal = 3,
  sym_int_literal = 4,
  sym_uint_literal = 5,
  anon_sym_read = 6,
  anon_sym_write = 7,
  anon_sym_read_write = 8,
  anon_sym_rgba8unorm = 9,
  anon_sym_rgba8snorm = 10,
  anon_sym_rgba8uint = 11,
  anon_sym_rgba8sint = 12,
  anon_sym_rgba16uint = 13,
  anon_sym_rgba16sint = 14,
  anon_sym_rgba16float = 15,
  anon_sym_r32uint = 16,
  anon_sym_r32sint = 17,
  anon_sym_r32float = 18,
  anon_sym_rg32uint = 19,
  anon_sym_rg32sint = 20,
  anon_sym_rg32float = 21,
  anon_sym_rgba32uint = 22,
  anon_sym_rgba32sint = 23,
  anon_sym_rgba32float = 24,
  sym_array = 25,
  sym_atomic = 26,
  sym_bool = 27,
  sym_float32 = 28,
  sym_int32 = 29,
  sym_mat2x2 = 30,
  sym_mat2x3 = 31,
  sym_mat2x4 = 32,
  sym_mat3x2 = 33,
  sym_mat3x3 = 34,
  sym_mat3x4 = 35,
  sym_mat4x2 = 36,
  sym_mat4x3 = 37,
  sym_mat4x4 = 38,
  sym_pointer = 39,
  sym_sampler = 40,
  sym_sampler_comparison = 41,
  sym_struct = 42,
  sym_texture_1d = 43,
  sym_texture_2d = 44,
  sym_texture_2d_array = 45,
  sym_texture_3d = 46,
  sym_texture_cube = 47,
  sym_texture_cube_array = 48,
  sym_texture_multisampled_2d = 49,
  sym_texture_storage_1d = 50,
  sym_texture_storage_2d = 51,
  sym_texture_storage_2d_array = 52,
  sym_texture_storage_3d = 53,
  sym_texture_depth_2d = 54,
  sym_texture_depth_2d_array = 55,
  sym_texture_depth_cube = 56,
  sym_texture_depth_cube_array = 57,
  sym_texture_depth_multisampled_2d = 58,
  sym_uint32 = 59,
  sym_vec2 = 60,
  sym_vec3 = 61,
  sym_vec4 = 62,
  sym_bitcast = 63,
  sym_break = 64,
  sym_case = 65,
  sym_continue = 66,
  sym_continuing = 67,
  sym_default = 68,
  sym_discard = 69,
  sym_else = 70,
  sym_enable = 71,
  sym_fallthrough = 72,
  sym_false = 73,
  sym_fn = 74,
  sym_for = 75,
  sym_function = 76,
  sym_if = 77,
  sym_let = 78,
  sym_loop = 79,
  sym_private = 80,
  sym_return = 81,
  sym_storage = 82,
  sym_switch = 83,
  sym_true = 84,
  sym_type = 85,
  sym_uniform = 86,
  sym_var = 87,
  sym_workgroup = 88,
  sym_and = 89,
  sym_and_and = 90,
  sym_arrow = 91,
  sym_attr = 92,
  sym_forward_slash = 93,
  sym_bang = 94,
  sym_bracket_left = 95,
  sym_bracket_right = 96,
  sym_brace_left = 97,
  sym_brace_right = 98,
  sym_colon = 99,
  sym_comma = 100,
  sym_equal = 101,
  sym_equal_equal = 102,
  sym_not_equal = 103,
  sym_greater_than = 104,
  sym_greater_than_equal = 105,
  sym_shift_right = 106,
  sym_less_than = 107,
  sym_less_than_equal = 108,
  sym_shift_left = 109,
  sym_modulo = 110,
  sym_minus = 111,
  sym_minus_minus = 112,
  sym_period = 113,
  sym_plus = 114,
  sym_plus_plus = 115,
  sym_or = 116,
  sym_or_or = 117,
  sym_paren_left = 118,
  sym_paren_right = 119,
  sym_semicolon = 120,
  sym_star = 121,
  sym_tilde = 122,
  sym_underscore = 123,
  sym_xor = 124,
  sym_plus_equal = 125,
  sym_minus_equal = 126,
  sym_times_equal = 127,
  sym_division_equal = 128,
  sym_modulo_equal = 129,
  sym_and_equal = 130,
  sym_or_equal = 131,
  sym_xor_equal = 132,
  sym_shift_right_equal = 133,
  sym_shift_left_equal = 134,
  anon_sym_asm = 135,
  anon_sym_bf16 = 136,
  anon_sym_const = 137,
  anon_sym_do = 138,
  anon_sym_enum = 139,
  anon_sym_f16 = 140,
  anon_sym_f64 = 141,
  anon_sym_handle = 142,
  anon_sym_i8 = 143,
  anon_sym_i16 = 144,
  anon_sym_i64 = 145,
  anon_sym_mat = 146,
  anon_sym_premerge = 147,
  anon_sym_regardless = 148,
  anon_sym_typedef = 149,
  anon_sym_u8 = 150,
  anon_sym_u16 = 151,
  anon_sym_u64 = 152,
  anon_sym_unless = 153,
  anon_sym_using = 154,
  anon_sym_vec = 155,
  anon_sym_void = 156,
  anon_sym_while = 157,
  anon_sym_SLASH_SLASH = 158,
  aux_sym__comment_token1 = 159,
  sym__space = 160,
  sym__block_comment = 161,
  sym_translation_unit = 162,
  sym_global_directive = 163,
  sym_const_literal = 164,
  sym_float_literal = 165,
  sym_attribute = 166,
  sym_literal_or_ident = 167,
  sym_array_type_decl = 168,
  sym_element_count_expression = 169,
  sym_struct_decl = 170,
  sym_struct_body_decl = 171,
  sym_struct_member = 172,
  sym_storage_class = 173,
  sym_texture_sampler_types = 174,
  sym_sampler_type = 175,
  sym_sampled_texture_type = 176,
  sym_multisampled_texture_type = 177,
  sym_storage_texture_type = 178,
  sym_depth_texture_type = 179,
  sym_type_alias_decl = 180,
  sym_type_decl = 181,
  sym_variable_statement = 182,
  sym_variable_decl = 183,
  sym_variable_ident_decl = 184,
  sym_variable_qualifier = 185,
  sym_global_variable_decl = 186,
  sym_global_constant_decl = 187,
  sym_global_const_initializer = 188,
  sym_const_expression = 189,
  sym_primary_expression = 190,
  sym_paren_expression = 191,
  sym_argument_expression_list = 192,
  sym_postfix_expression = 193,
  sym_unary_expression = 194,
  sym_singular_expression = 195,
  sym_lhs_expression = 196,
  sym_core_lhs_expression = 197,
  sym_multiplicative_expression = 198,
  sym_additive_expression = 199,
  sym_shift_expression = 200,
  sym_relational_expression = 201,
  sym_short_circuit_and_expression = 202,
  sym_short_circuit_or_expression = 203,
  sym_binary_or_expression = 204,
  sym_binary_and_expression = 205,
  sym_binary_xor_expression = 206,
  sym_expression = 207,
  sym_compound_statement = 208,
  sym_assignment_statement = 209,
  sym_compound_assignment_operator = 210,
  sym_increment_statement = 211,
  sym_decrement_statement = 212,
  sym_if_statement = 213,
  sym_else_statement = 214,
  sym_switch_statement = 215,
  sym_switch_body = 216,
  sym_case_selectors = 217,
  sym_case_body = 218,
  sym_loop_statement = 219,
  sym_for_statement = 220,
  sym_for_header = 221,
  sym_for_init = 222,
  sym_for_update = 223,
  sym_break_statement = 224,
  sym_continue_statement = 225,
  sym_continuing_statement = 226,
  sym_return_statement = 227,
  sym_func_call_statement = 228,
  sym_statement = 229,
  sym_function_decl = 230,
  sym_function_header = 231,
  sym_param_list = 232,
  sym_param = 233,
  sym_enable_directive = 234,
  sym_access_mode = 235,
  sym_texel_format = 236,
  sym__comment = 237,
  aux_sym_translation_unit_repeat1 = 238,
  aux_sym_translation_unit_repeat2 = 239,
  aux_sym_attribute_repeat1 = 240,
  aux_sym_struct_body_decl_repeat1 = 241,
  aux_sym_struct_member_repeat1 = 242,
  aux_sym_const_expression_repeat1 = 243,
  aux_sym_argument_expression_list_repeat1 = 244,
  aux_sym_lhs_expression_repeat1 = 245,
  aux_sym_compound_statement_repeat1 = 246,
  aux_sym_switch_statement_repeat1 = 247,
  aux_sym_case_selectors_repeat1 = 248,
  aux_sym_param_list_repeat1 = 249,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_ident] = "ident",
  [sym_decimal_float_literal] = "decimal_float_literal",
  [sym_hex_float_literal] = "hex_float_literal",
  [sym_int_literal] = "int_literal",
  [sym_uint_literal] = "uint_literal",
  [anon_sym_read] = "read",
  [anon_sym_write] = "write",
  [anon_sym_read_write] = "read_write",
  [anon_sym_rgba8unorm] = "rgba8unorm",
  [anon_sym_rgba8snorm] = "rgba8snorm",
  [anon_sym_rgba8uint] = "rgba8uint",
  [anon_sym_rgba8sint] = "rgba8sint",
  [anon_sym_rgba16uint] = "rgba16uint",
  [anon_sym_rgba16sint] = "rgba16sint",
  [anon_sym_rgba16float] = "rgba16float",
  [anon_sym_r32uint] = "r32uint",
  [anon_sym_r32sint] = "r32sint",
  [anon_sym_r32float] = "r32float",
  [anon_sym_rg32uint] = "rg32uint",
  [anon_sym_rg32sint] = "rg32sint",
  [anon_sym_rg32float] = "rg32float",
  [anon_sym_rgba32uint] = "rgba32uint",
  [anon_sym_rgba32sint] = "rgba32sint",
  [anon_sym_rgba32float] = "rgba32float",
  [sym_array] = "array",
  [sym_atomic] = "atomic",
  [sym_bool] = "bool",
  [sym_float32] = "float32",
  [sym_int32] = "int32",
  [sym_mat2x2] = "mat2x2",
  [sym_mat2x3] = "mat2x3",
  [sym_mat2x4] = "mat2x4",
  [sym_mat3x2] = "mat3x2",
  [sym_mat3x3] = "mat3x3",
  [sym_mat3x4] = "mat3x4",
  [sym_mat4x2] = "mat4x2",
  [sym_mat4x3] = "mat4x3",
  [sym_mat4x4] = "mat4x4",
  [sym_pointer] = "pointer",
  [sym_sampler] = "sampler",
  [sym_sampler_comparison] = "sampler_comparison",
  [sym_struct] = "struct",
  [sym_texture_1d] = "texture_1d",
  [sym_texture_2d] = "texture_2d",
  [sym_texture_2d_array] = "texture_2d_array",
  [sym_texture_3d] = "texture_3d",
  [sym_texture_cube] = "texture_cube",
  [sym_texture_cube_array] = "texture_cube_array",
  [sym_texture_multisampled_2d] = "texture_multisampled_2d",
  [sym_texture_storage_1d] = "texture_storage_1d",
  [sym_texture_storage_2d] = "texture_storage_2d",
  [sym_texture_storage_2d_array] = "texture_storage_2d_array",
  [sym_texture_storage_3d] = "texture_storage_3d",
  [sym_texture_depth_2d] = "texture_depth_2d",
  [sym_texture_depth_2d_array] = "texture_depth_2d_array",
  [sym_texture_depth_cube] = "texture_depth_cube",
  [sym_texture_depth_cube_array] = "texture_depth_cube_array",
  [sym_texture_depth_multisampled_2d] = "texture_depth_multisampled_2d",
  [sym_uint32] = "uint32",
  [sym_vec2] = "vec2",
  [sym_vec3] = "vec3",
  [sym_vec4] = "vec4",
  [sym_bitcast] = "bitcast",
  [sym_break] = "break",
  [sym_case] = "case",
  [sym_continue] = "continue",
  [sym_continuing] = "continuing",
  [sym_default] = "default",
  [sym_discard] = "discard",
  [sym_else] = "else",
  [sym_enable] = "enable",
  [sym_fallthrough] = "fallthrough",
  [sym_false] = "false",
  [sym_fn] = "fn",
  [sym_for] = "for",
  [sym_function] = "function",
  [sym_if] = "if",
  [sym_let] = "let",
  [sym_loop] = "loop",
  [sym_private] = "private",
  [sym_return] = "return",
  [sym_storage] = "storage",
  [sym_switch] = "switch",
  [sym_true] = "true",
  [sym_type] = "type",
  [sym_uniform] = "uniform",
  [sym_var] = "var",
  [sym_workgroup] = "workgroup",
  [sym_and] = "and",
  [sym_and_and] = "and_and",
  [sym_arrow] = "arrow",
  [sym_attr] = "attr",
  [sym_forward_slash] = "forward_slash",
  [sym_bang] = "bang",
  [sym_bracket_left] = "bracket_left",
  [sym_bracket_right] = "bracket_right",
  [sym_brace_left] = "brace_left",
  [sym_brace_right] = "brace_right",
  [sym_colon] = "colon",
  [sym_comma] = "comma",
  [sym_equal] = "equal",
  [sym_equal_equal] = "equal_equal",
  [sym_not_equal] = "not_equal",
  [sym_greater_than] = "greater_than",
  [sym_greater_than_equal] = "greater_than_equal",
  [sym_shift_right] = "shift_right",
  [sym_less_than] = "less_than",
  [sym_less_than_equal] = "less_than_equal",
  [sym_shift_left] = "shift_left",
  [sym_modulo] = "modulo",
  [sym_minus] = "minus",
  [sym_minus_minus] = "minus_minus",
  [sym_period] = "period",
  [sym_plus] = "plus",
  [sym_plus_plus] = "plus_plus",
  [sym_or] = "or",
  [sym_or_or] = "or_or",
  [sym_paren_left] = "paren_left",
  [sym_paren_right] = "paren_right",
  [sym_semicolon] = "semicolon",
  [sym_star] = "star",
  [sym_tilde] = "tilde",
  [sym_underscore] = "underscore",
  [sym_xor] = "xor",
  [sym_plus_equal] = "plus_equal",
  [sym_minus_equal] = "minus_equal",
  [sym_times_equal] = "times_equal",
  [sym_division_equal] = "division_equal",
  [sym_modulo_equal] = "modulo_equal",
  [sym_and_equal] = "and_equal",
  [sym_or_equal] = "or_equal",
  [sym_xor_equal] = "xor_equal",
  [sym_shift_right_equal] = "shift_right_equal",
  [sym_shift_left_equal] = "shift_left_equal",
  [anon_sym_asm] = "asm",
  [anon_sym_bf16] = "bf16",
  [anon_sym_const] = "const",
  [anon_sym_do] = "do",
  [anon_sym_enum] = "enum",
  [anon_sym_f16] = "f16",
  [anon_sym_f64] = "f64",
  [anon_sym_handle] = "handle",
  [anon_sym_i8] = "i8",
  [anon_sym_i16] = "i16",
  [anon_sym_i64] = "i64",
  [anon_sym_mat] = "mat",
  [anon_sym_premerge] = "premerge",
  [anon_sym_regardless] = "regardless",
  [anon_sym_typedef] = "typedef",
  [anon_sym_u8] = "u8",
  [anon_sym_u16] = "u16",
  [anon_sym_u64] = "u64",
  [anon_sym_unless] = "unless",
  [anon_sym_using] = "using",
  [anon_sym_vec] = "vec",
  [anon_sym_void] = "void",
  [anon_sym_while] = "while",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym__comment_token1] = "_comment_token1",
  [sym__space] = "_space",
  [sym__block_comment] = "_block_comment",
  [sym_translation_unit] = "translation_unit",
  [sym_global_directive] = "global_directive",
  [sym_const_literal] = "const_literal",
  [sym_float_literal] = "float_literal",
  [sym_attribute] = "attribute",
  [sym_literal_or_ident] = "literal_or_ident",
  [sym_array_type_decl] = "array_type_decl",
  [sym_element_count_expression] = "element_count_expression",
  [sym_struct_decl] = "struct_decl",
  [sym_struct_body_decl] = "struct_body_decl",
  [sym_struct_member] = "struct_member",
  [sym_storage_class] = "storage_class",
  [sym_texture_sampler_types] = "texture_sampler_types",
  [sym_sampler_type] = "sampler_type",
  [sym_sampled_texture_type] = "sampled_texture_type",
  [sym_multisampled_texture_type] = "multisampled_texture_type",
  [sym_storage_texture_type] = "storage_texture_type",
  [sym_depth_texture_type] = "depth_texture_type",
  [sym_type_alias_decl] = "type_alias_decl",
  [sym_type_decl] = "type_decl",
  [sym_variable_statement] = "variable_statement",
  [sym_variable_decl] = "variable_decl",
  [sym_variable_ident_decl] = "variable_ident_decl",
  [sym_variable_qualifier] = "variable_qualifier",
  [sym_global_variable_decl] = "global_variable_decl",
  [sym_global_constant_decl] = "global_constant_decl",
  [sym_global_const_initializer] = "global_const_initializer",
  [sym_const_expression] = "const_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_paren_expression] = "paren_expression",
  [sym_argument_expression_list] = "argument_expression_list",
  [sym_postfix_expression] = "postfix_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_singular_expression] = "singular_expression",
  [sym_lhs_expression] = "lhs_expression",
  [sym_core_lhs_expression] = "core_lhs_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_short_circuit_and_expression] = "short_circuit_and_expression",
  [sym_short_circuit_or_expression] = "short_circuit_or_expression",
  [sym_binary_or_expression] = "binary_or_expression",
  [sym_binary_and_expression] = "binary_and_expression",
  [sym_binary_xor_expression] = "binary_xor_expression",
  [sym_expression] = "expression",
  [sym_compound_statement] = "compound_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_compound_assignment_operator] = "compound_assignment_operator",
  [sym_increment_statement] = "increment_statement",
  [sym_decrement_statement] = "decrement_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_statement] = "else_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_case_selectors] = "case_selectors",
  [sym_case_body] = "case_body",
  [sym_loop_statement] = "loop_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_header] = "for_header",
  [sym_for_init] = "for_init",
  [sym_for_update] = "for_update",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_continuing_statement] = "continuing_statement",
  [sym_return_statement] = "return_statement",
  [sym_func_call_statement] = "func_call_statement",
  [sym_statement] = "statement",
  [sym_function_decl] = "function_decl",
  [sym_function_header] = "function_header",
  [sym_param_list] = "param_list",
  [sym_param] = "param",
  [sym_enable_directive] = "enable_directive",
  [sym_access_mode] = "access_mode",
  [sym_texel_format] = "texel_format",
  [sym__comment] = "_comment",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_translation_unit_repeat2] = "translation_unit_repeat2",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_struct_body_decl_repeat1] = "struct_body_decl_repeat1",
  [aux_sym_struct_member_repeat1] = "struct_member_repeat1",
  [aux_sym_const_expression_repeat1] = "const_expression_repeat1",
  [aux_sym_argument_expression_list_repeat1] = "argument_expression_list_repeat1",
  [aux_sym_lhs_expression_repeat1] = "lhs_expression_repeat1",
  [aux_sym_compound_statement_repeat1] = "compound_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_selectors_repeat1] = "case_selectors_repeat1",
  [aux_sym_param_list_repeat1] = "param_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_ident] = sym_ident,
  [sym_decimal_float_literal] = sym_decimal_float_literal,
  [sym_hex_float_literal] = sym_hex_float_literal,
  [sym_int_literal] = sym_int_literal,
  [sym_uint_literal] = sym_uint_literal,
  [anon_sym_read] = anon_sym_read,
  [anon_sym_write] = anon_sym_write,
  [anon_sym_read_write] = anon_sym_read_write,
  [anon_sym_rgba8unorm] = anon_sym_rgba8unorm,
  [anon_sym_rgba8snorm] = anon_sym_rgba8snorm,
  [anon_sym_rgba8uint] = anon_sym_rgba8uint,
  [anon_sym_rgba8sint] = anon_sym_rgba8sint,
  [anon_sym_rgba16uint] = anon_sym_rgba16uint,
  [anon_sym_rgba16sint] = anon_sym_rgba16sint,
  [anon_sym_rgba16float] = anon_sym_rgba16float,
  [anon_sym_r32uint] = anon_sym_r32uint,
  [anon_sym_r32sint] = anon_sym_r32sint,
  [anon_sym_r32float] = anon_sym_r32float,
  [anon_sym_rg32uint] = anon_sym_rg32uint,
  [anon_sym_rg32sint] = anon_sym_rg32sint,
  [anon_sym_rg32float] = anon_sym_rg32float,
  [anon_sym_rgba32uint] = anon_sym_rgba32uint,
  [anon_sym_rgba32sint] = anon_sym_rgba32sint,
  [anon_sym_rgba32float] = anon_sym_rgba32float,
  [sym_array] = sym_array,
  [sym_atomic] = sym_atomic,
  [sym_bool] = sym_bool,
  [sym_float32] = sym_float32,
  [sym_int32] = sym_int32,
  [sym_mat2x2] = sym_mat2x2,
  [sym_mat2x3] = sym_mat2x3,
  [sym_mat2x4] = sym_mat2x4,
  [sym_mat3x2] = sym_mat3x2,
  [sym_mat3x3] = sym_mat3x3,
  [sym_mat3x4] = sym_mat3x4,
  [sym_mat4x2] = sym_mat4x2,
  [sym_mat4x3] = sym_mat4x3,
  [sym_mat4x4] = sym_mat4x4,
  [sym_pointer] = sym_pointer,
  [sym_sampler] = sym_sampler,
  [sym_sampler_comparison] = sym_sampler_comparison,
  [sym_struct] = sym_struct,
  [sym_texture_1d] = sym_texture_1d,
  [sym_texture_2d] = sym_texture_2d,
  [sym_texture_2d_array] = sym_texture_2d_array,
  [sym_texture_3d] = sym_texture_3d,
  [sym_texture_cube] = sym_texture_cube,
  [sym_texture_cube_array] = sym_texture_cube_array,
  [sym_texture_multisampled_2d] = sym_texture_multisampled_2d,
  [sym_texture_storage_1d] = sym_texture_storage_1d,
  [sym_texture_storage_2d] = sym_texture_storage_2d,
  [sym_texture_storage_2d_array] = sym_texture_storage_2d_array,
  [sym_texture_storage_3d] = sym_texture_storage_3d,
  [sym_texture_depth_2d] = sym_texture_depth_2d,
  [sym_texture_depth_2d_array] = sym_texture_depth_2d_array,
  [sym_texture_depth_cube] = sym_texture_depth_cube,
  [sym_texture_depth_cube_array] = sym_texture_depth_cube_array,
  [sym_texture_depth_multisampled_2d] = sym_texture_depth_multisampled_2d,
  [sym_uint32] = sym_uint32,
  [sym_vec2] = sym_vec2,
  [sym_vec3] = sym_vec3,
  [sym_vec4] = sym_vec4,
  [sym_bitcast] = sym_bitcast,
  [sym_break] = sym_break,
  [sym_case] = sym_case,
  [sym_continue] = sym_continue,
  [sym_continuing] = sym_continuing,
  [sym_default] = sym_default,
  [sym_discard] = sym_discard,
  [sym_else] = sym_else,
  [sym_enable] = sym_enable,
  [sym_fallthrough] = sym_fallthrough,
  [sym_false] = sym_false,
  [sym_fn] = sym_fn,
  [sym_for] = sym_for,
  [sym_function] = sym_function,
  [sym_if] = sym_if,
  [sym_let] = sym_let,
  [sym_loop] = sym_loop,
  [sym_private] = sym_private,
  [sym_return] = sym_return,
  [sym_storage] = sym_storage,
  [sym_switch] = sym_switch,
  [sym_true] = sym_true,
  [sym_type] = sym_type,
  [sym_uniform] = sym_uniform,
  [sym_var] = sym_var,
  [sym_workgroup] = sym_workgroup,
  [sym_and] = sym_and,
  [sym_and_and] = sym_and_and,
  [sym_arrow] = sym_arrow,
  [sym_attr] = sym_attr,
  [sym_forward_slash] = sym_forward_slash,
  [sym_bang] = sym_bang,
  [sym_bracket_left] = sym_bracket_left,
  [sym_bracket_right] = sym_bracket_right,
  [sym_brace_left] = sym_brace_left,
  [sym_brace_right] = sym_brace_right,
  [sym_colon] = sym_colon,
  [sym_comma] = sym_comma,
  [sym_equal] = sym_equal,
  [sym_equal_equal] = sym_equal_equal,
  [sym_not_equal] = sym_not_equal,
  [sym_greater_than] = sym_greater_than,
  [sym_greater_than_equal] = sym_greater_than_equal,
  [sym_shift_right] = sym_shift_right,
  [sym_less_than] = sym_less_than,
  [sym_less_than_equal] = sym_less_than_equal,
  [sym_shift_left] = sym_shift_left,
  [sym_modulo] = sym_modulo,
  [sym_minus] = sym_minus,
  [sym_minus_minus] = sym_minus_minus,
  [sym_period] = sym_period,
  [sym_plus] = sym_plus,
  [sym_plus_plus] = sym_plus_plus,
  [sym_or] = sym_or,
  [sym_or_or] = sym_or_or,
  [sym_paren_left] = sym_paren_left,
  [sym_paren_right] = sym_paren_right,
  [sym_semicolon] = sym_semicolon,
  [sym_star] = sym_star,
  [sym_tilde] = sym_tilde,
  [sym_underscore] = sym_underscore,
  [sym_xor] = sym_xor,
  [sym_plus_equal] = sym_plus_equal,
  [sym_minus_equal] = sym_minus_equal,
  [sym_times_equal] = sym_times_equal,
  [sym_division_equal] = sym_division_equal,
  [sym_modulo_equal] = sym_modulo_equal,
  [sym_and_equal] = sym_and_equal,
  [sym_or_equal] = sym_or_equal,
  [sym_xor_equal] = sym_xor_equal,
  [sym_shift_right_equal] = sym_shift_right_equal,
  [sym_shift_left_equal] = sym_shift_left_equal,
  [anon_sym_asm] = anon_sym_asm,
  [anon_sym_bf16] = anon_sym_bf16,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_f16] = anon_sym_f16,
  [anon_sym_f64] = anon_sym_f64,
  [anon_sym_handle] = anon_sym_handle,
  [anon_sym_i8] = anon_sym_i8,
  [anon_sym_i16] = anon_sym_i16,
  [anon_sym_i64] = anon_sym_i64,
  [anon_sym_mat] = anon_sym_mat,
  [anon_sym_premerge] = anon_sym_premerge,
  [anon_sym_regardless] = anon_sym_regardless,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_u8] = anon_sym_u8,
  [anon_sym_u16] = anon_sym_u16,
  [anon_sym_u64] = anon_sym_u64,
  [anon_sym_unless] = anon_sym_unless,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_vec] = anon_sym_vec,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym__comment_token1] = aux_sym__comment_token1,
  [sym__space] = sym__space,
  [sym__block_comment] = sym__block_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym_global_directive] = sym_global_directive,
  [sym_const_literal] = sym_const_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_attribute] = sym_attribute,
  [sym_literal_or_ident] = sym_literal_or_ident,
  [sym_array_type_decl] = sym_array_type_decl,
  [sym_element_count_expression] = sym_element_count_expression,
  [sym_struct_decl] = sym_struct_decl,
  [sym_struct_body_decl] = sym_struct_body_decl,
  [sym_struct_member] = sym_struct_member,
  [sym_storage_class] = sym_storage_class,
  [sym_texture_sampler_types] = sym_texture_sampler_types,
  [sym_sampler_type] = sym_sampler_type,
  [sym_sampled_texture_type] = sym_sampled_texture_type,
  [sym_multisampled_texture_type] = sym_multisampled_texture_type,
  [sym_storage_texture_type] = sym_storage_texture_type,
  [sym_depth_texture_type] = sym_depth_texture_type,
  [sym_type_alias_decl] = sym_type_alias_decl,
  [sym_type_decl] = sym_type_decl,
  [sym_variable_statement] = sym_variable_statement,
  [sym_variable_decl] = sym_variable_decl,
  [sym_variable_ident_decl] = sym_variable_ident_decl,
  [sym_variable_qualifier] = sym_variable_qualifier,
  [sym_global_variable_decl] = sym_global_variable_decl,
  [sym_global_constant_decl] = sym_global_constant_decl,
  [sym_global_const_initializer] = sym_global_const_initializer,
  [sym_const_expression] = sym_const_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_paren_expression] = sym_paren_expression,
  [sym_argument_expression_list] = sym_argument_expression_list,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_singular_expression] = sym_singular_expression,
  [sym_lhs_expression] = sym_lhs_expression,
  [sym_core_lhs_expression] = sym_core_lhs_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_short_circuit_and_expression] = sym_short_circuit_and_expression,
  [sym_short_circuit_or_expression] = sym_short_circuit_or_expression,
  [sym_binary_or_expression] = sym_binary_or_expression,
  [sym_binary_and_expression] = sym_binary_and_expression,
  [sym_binary_xor_expression] = sym_binary_xor_expression,
  [sym_expression] = sym_expression,
  [sym_compound_statement] = sym_compound_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_compound_assignment_operator] = sym_compound_assignment_operator,
  [sym_increment_statement] = sym_increment_statement,
  [sym_decrement_statement] = sym_decrement_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_case_selectors] = sym_case_selectors,
  [sym_case_body] = sym_case_body,
  [sym_loop_statement] = sym_loop_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_header] = sym_for_header,
  [sym_for_init] = sym_for_init,
  [sym_for_update] = sym_for_update,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_continuing_statement] = sym_continuing_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_func_call_statement] = sym_func_call_statement,
  [sym_statement] = sym_statement,
  [sym_function_decl] = sym_function_decl,
  [sym_function_header] = sym_function_header,
  [sym_param_list] = sym_param_list,
  [sym_param] = sym_param,
  [sym_enable_directive] = sym_enable_directive,
  [sym_access_mode] = sym_access_mode,
  [sym_texel_format] = sym_texel_format,
  [sym__comment] = sym__comment,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_translation_unit_repeat2] = aux_sym_translation_unit_repeat2,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_struct_body_decl_repeat1] = aux_sym_struct_body_decl_repeat1,
  [aux_sym_struct_member_repeat1] = aux_sym_struct_member_repeat1,
  [aux_sym_const_expression_repeat1] = aux_sym_const_expression_repeat1,
  [aux_sym_argument_expression_list_repeat1] = aux_sym_argument_expression_list_repeat1,
  [aux_sym_lhs_expression_repeat1] = aux_sym_lhs_expression_repeat1,
  [aux_sym_compound_statement_repeat1] = aux_sym_compound_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_selectors_repeat1] = aux_sym_case_selectors_repeat1,
  [aux_sym_param_list_repeat1] = aux_sym_param_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_uint_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_read] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_read_write] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8unorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8snorm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba8sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba16float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r32float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rg32float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32sint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgba32float] = {
    .visible = true,
    .named = false,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_float32] = {
    .visible = true,
    .named = true,
  },
  [sym_int32] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x4] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_comparison] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_uint32] = {
    .visible = true,
    .named = true,
  },
  [sym_vec2] = {
    .visible = true,
    .named = true,
  },
  [sym_vec3] = {
    .visible = true,
    .named = true,
  },
  [sym_vec4] = {
    .visible = true,
    .named = true,
  },
  [sym_bitcast] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing] = {
    .visible = true,
    .named = true,
  },
  [sym_default] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_enable] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_fn] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_private] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_storage] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_uniform] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [sym_workgroup] = {
    .visible = true,
    .named = true,
  },
  [sym_and] = {
    .visible = true,
    .named = true,
  },
  [sym_and_and] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_forward_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_left] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_right] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_left] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_right] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_equal_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left] = {
    .visible = true,
    .named = true,
  },
  [sym_modulo] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_minus_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_period] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_or] = {
    .visible = true,
    .named = true,
  },
  [sym_or_or] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_left] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_right] = {
    .visible = true,
    .named = true,
  },
  [sym_semicolon] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_tilde] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_xor] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_minus_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_times_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_division_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_modulo_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_and_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_xor_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left_equal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_asm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_handle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_premerge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_regardless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unless] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__space] = {
    .visible = false,
    .named = true,
  },
  [sym__block_comment] = {
    .visible = false,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_global_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_const_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_or_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_element_count_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_sampler_types] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_type] = {
    .visible = true,
    .named = true,
  },
  [sym_sampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_multisampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_depth_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ident_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_global_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_constant_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_const_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_const_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_singular_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lhs_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_core_lhs_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_xor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assignment_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_increment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decrement_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_case_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_case_body] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_header] = {
    .visible = true,
    .named = true,
  },
  [sym_for_init] = {
    .visible = true,
    .named = true,
  },
  [sym_for_update] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_func_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_param_list] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_enable_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_access_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_texel_format] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_translation_unit_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_member_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lhs_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_param_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(67);
      if (lookahead == '%') ADVANCE(91);
      if (lookahead == '&') ADVANCE(59);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(99);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(65);
      if (lookahead == '0') ADVANCE(46);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '<') ADVANCE(84);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '@') ADVANCE(63);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(113);
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(17);
      if (lookahead == '%') ADVANCE(90);
      if (lookahead == '&') ADVANCE(58);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(103);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(17);
      if (lookahead == '%') ADVANCE(90);
      if (lookahead == '&') ADVANCE(5);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '|') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      END_STATE();
    case 3:
      if (lookahead == '%') ADVANCE(18);
      if (lookahead == '&') ADVANCE(60);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '0') ADVANCE(51);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(26);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(113);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 4:
      if (lookahead == '%') ADVANCE(18);
      if (lookahead == '&') ADVANCE(19);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == '-') ADVANCE(9);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(26);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '^') ADVANCE(22);
      if (lookahead == '|') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(61);
      END_STATE();
    case 6:
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      END_STATE();
    case 7:
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 8:
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '0') ADVANCE(30);
      if (lookahead == '=') ADVANCE(115);
      if (lookahead == '>') ADVANCE(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 9:
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == '/') ADVANCE(126);
      END_STATE();
    case 15:
      if (lookahead == '/') ADVANCE(126);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 16:
      if (lookahead == '<') ADVANCE(24);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(25);
      END_STATE();
    case 27:
      if (lookahead == '|') ADVANCE(104);
      END_STATE();
    case 28:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 29:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 30:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(66);
      if (lookahead == '&') ADVANCE(57);
      if (lookahead == '(') ADVANCE(105);
      if (lookahead == ')') ADVANCE(106);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(31);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '0') ADVANCE(46);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(107);
      if (lookahead == '<') ADVANCE(83);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '@') ADVANCE(63);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(112);
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == '{') ADVANCE(70);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(71);
      if (lookahead == '~') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(131);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(47);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (lookahead == 'f') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'f') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_hex_float_literal);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_hex_float_literal);
      if (lookahead == 'f') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_hex_float_literal);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'u') ADVANCE(56);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(11);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'u') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(45);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(29);
      if (lookahead == 'u') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(45);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(56);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_uint_literal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_and);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_and);
      if (lookahead == '&') ADVANCE(61);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_and);
      if (lookahead == '&') ADVANCE(61);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_and);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_and_and);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_attr);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_forward_slash);
      if (lookahead == '/') ADVANCE(126);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_forward_slash);
      if (lookahead == '/') ADVANCE(126);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_bang);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_bang);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_bracket_left);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_bracket_right);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_brace_left);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_brace_right);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_equal);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_equal);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_equal_equal);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_not_equal);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_greater_than);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(82);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_greater_than_equal);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_shift_right);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_less_than);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '<') ADVANCE(89);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '<') ADVANCE(88);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_less_than_equal);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_shift_left);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_shift_left);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_modulo);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_modulo);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_minus);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(31);
      if (lookahead == '0') ADVANCE(10);
      if (lookahead == '=') ADVANCE(115);
      if (lookahead == '>') ADVANCE(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(31);
      if (lookahead == '0') ADVANCE(10);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_minus_minus);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_period);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_period);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(100);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_plus_plus);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_or);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_or);
      if (lookahead == '=') ADVANCE(120);
      if (lookahead == '|') ADVANCE(104);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_or);
      if (lookahead == '|') ADVANCE(104);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_or_or);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_paren_left);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_paren_right);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_semicolon);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_star);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_tilde);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_underscore);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_xor);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_xor);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_plus_equal);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_minus_equal);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_times_equal);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_division_equal);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_modulo_equal);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_and_equal);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_or_equal);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_xor_equal);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_shift_right_equal);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_shift_left_equal);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '_') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead == '\n') ADVANCE(131);
      if (lookahead == '/') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(130);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead == '/') ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym__space);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'i') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 6:
      if (lookahead == '1') ADVANCE(32);
      if (lookahead == '3') ADVANCE(33);
      if (lookahead == '6') ADVANCE(34);
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'n') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(40);
      if (lookahead == '3') ADVANCE(41);
      if (lookahead == '6') ADVANCE(42);
      if (lookahead == '8') ADVANCE(43);
      if (lookahead == 'f') ADVANCE(44);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(47);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(48);
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == '3') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'g') ADVANCE(52);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 't') ADVANCE(54);
      if (lookahead == 'w') ADVANCE(55);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(58);
      END_STATE();
    case 15:
      if (lookahead == '1') ADVANCE(59);
      if (lookahead == '3') ADVANCE(60);
      if (lookahead == '6') ADVANCE(61);
      if (lookahead == '8') ADVANCE(62);
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(65);
      if (lookahead == 'e') ADVANCE(66);
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'o') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 19:
      if (lookahead == 'm') ADVANCE(72);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 21:
      if (lookahead == '1') ADVANCE(74);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(80);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 32:
      if (lookahead == '6') ADVANCE(85);
      END_STATE();
    case 33:
      if (lookahead == '2') ADVANCE(86);
      END_STATE();
    case 34:
      if (lookahead == '4') ADVANCE(87);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_fn);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 39:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 40:
      if (lookahead == '6') ADVANCE(92);
      END_STATE();
    case 41:
      if (lookahead == '2') ADVANCE(93);
      END_STATE();
    case 42:
      if (lookahead == '4') ADVANCE(94);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_if);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(98);
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 50:
      if (lookahead == '2') ADVANCE(101);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'g') ADVANCE(103);
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 52:
      if (lookahead == '3') ADVANCE(105);
      if (lookahead == 'b') ADVANCE(106);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(108);
      if (lookahead == 'r') ADVANCE(109);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 56:
      if (lookahead == 'x') ADVANCE(111);
      END_STATE();
    case 57:
      if (lookahead == 'u') ADVANCE(112);
      END_STATE();
    case 58:
      if (lookahead == 'p') ADVANCE(113);
      END_STATE();
    case 59:
      if (lookahead == '6') ADVANCE(114);
      END_STATE();
    case 60:
      if (lookahead == '2') ADVANCE(115);
      END_STATE();
    case 61:
      if (lookahead == '4') ADVANCE(116);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(117);
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 66:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_asm);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(127);
      END_STATE();
    case 74:
      if (lookahead == '6') ADVANCE(128);
      END_STATE();
    case 75:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 79:
      if (lookahead == 's') ADVANCE(133);
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(135);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(136);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(138);
      END_STATE();
    case 84:
      if (lookahead == 'm') ADVANCE(139);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_f16);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_float32);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_f64);
      END_STATE();
    case 88:
      if (lookahead == 'l') ADVANCE(140);
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_for);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(143);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_i16);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_int32);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_i64);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_let);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(144);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_mat);
      if (lookahead == '2') ADVANCE(145);
      if (lookahead == '3') ADVANCE(146);
      if (lookahead == '4') ADVANCE(147);
      END_STATE();
    case 98:
      if (lookahead == 'm') ADVANCE(148);
      END_STATE();
    case 99:
      if (lookahead == 'v') ADVANCE(149);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_pointer);
      END_STATE();
    case 101:
      if (lookahead == 'f') ADVANCE(150);
      if (lookahead == 's') ADVANCE(151);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 102:
      if (lookahead == 'd') ADVANCE(153);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(155);
      END_STATE();
    case 105:
      if (lookahead == '2') ADVANCE(156);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(157);
      END_STATE();
    case 107:
      if (lookahead == 'p') ADVANCE(158);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 109:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_u16);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_uint32);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_u64);
      END_STATE();
    case 117:
      if (lookahead == 'f') ADVANCE(165);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_var);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_vec);
      if (lookahead == '2') ADVANCE(168);
      if (lookahead == '3') ADVANCE(169);
      if (lookahead == '4') ADVANCE(170);
      END_STATE();
    case 122:
      if (lookahead == 'd') ADVANCE(171);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 124:
      if (lookahead == 'k') ADVANCE(173);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 126:
      if (lookahead == 'y') ADVANCE(175);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(176);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_bf16);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(177);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_bool);
      END_STATE();
    case 131:
      if (lookahead == 'k') ADVANCE(178);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_case);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(179);
      END_STATE();
    case 134:
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 135:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_else);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 140:
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 143:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_loop);
      END_STATE();
    case 145:
      if (lookahead == 'x') ADVANCE(188);
      END_STATE();
    case 146:
      if (lookahead == 'x') ADVANCE(189);
      END_STATE();
    case 147:
      if (lookahead == 'x') ADVANCE(190);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(192);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(194);
      END_STATE();
    case 152:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_read);
      if (lookahead == '_') ADVANCE(196);
      END_STATE();
    case 154:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(198);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(199);
      if (lookahead == 's') ADVANCE(200);
      if (lookahead == 'u') ADVANCE(201);
      END_STATE();
    case 157:
      if (lookahead == '1') ADVANCE(202);
      if (lookahead == '3') ADVANCE(203);
      if (lookahead == '8') ADVANCE(204);
      END_STATE();
    case 158:
      if (lookahead == 'l') ADVANCE(205);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(206);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(207);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(208);
      END_STATE();
    case 162:
      if (lookahead == 'u') ADVANCE(209);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_type);
      if (lookahead == 'd') ADVANCE(210);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(212);
      END_STATE();
    case 167:
      if (lookahead == 'g') ADVANCE(213);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_vec2);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_vec3);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_vec4);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 173:
      if (lookahead == 'g') ADVANCE(215);
      END_STATE();
    case 174:
      if (lookahead == 'e') ADVANCE(216);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_array);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(217);
      END_STATE();
    case 177:
      if (lookahead == 's') ADVANCE(218);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 180:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 181:
      if (lookahead == 'l') ADVANCE(220);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 184:
      if (lookahead == 'h') ADVANCE(223);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 186:
      if (lookahead == 'i') ADVANCE(224);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 188:
      if (lookahead == '2') ADVANCE(226);
      if (lookahead == '3') ADVANCE(227);
      if (lookahead == '4') ADVANCE(228);
      END_STATE();
    case 189:
      if (lookahead == '2') ADVANCE(229);
      if (lookahead == '3') ADVANCE(230);
      if (lookahead == '4') ADVANCE(231);
      END_STATE();
    case 190:
      if (lookahead == '2') ADVANCE(232);
      if (lookahead == '3') ADVANCE(233);
      if (lookahead == '4') ADVANCE(234);
      END_STATE();
    case 191:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 193:
      if (lookahead == 'o') ADVANCE(237);
      END_STATE();
    case 194:
      if (lookahead == 'n') ADVANCE(238);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 196:
      if (lookahead == 'w') ADVANCE(240);
      END_STATE();
    case 197:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 198:
      if (lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 199:
      if (lookahead == 'l') ADVANCE(243);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(245);
      END_STATE();
    case 202:
      if (lookahead == '6') ADVANCE(246);
      END_STATE();
    case 203:
      if (lookahead == '2') ADVANCE(247);
      END_STATE();
    case 204:
      if (lookahead == 's') ADVANCE(248);
      if (lookahead == 'u') ADVANCE(249);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 206:
      if (lookahead == 'g') ADVANCE(251);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(252);
      END_STATE();
    case 208:
      if (lookahead == 'h') ADVANCE(253);
      END_STATE();
    case 209:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 211:
      if (lookahead == 'r') ADVANCE(256);
      END_STATE();
    case 212:
      if (lookahead == 's') ADVANCE(257);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 215:
      if (lookahead == 'r') ADVANCE(258);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_write);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_atomic);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 219:
      if (lookahead == 'u') ADVANCE(260);
      END_STATE();
    case 220:
      if (lookahead == 't') ADVANCE(261);
      END_STATE();
    case 221:
      if (lookahead == 'd') ADVANCE(262);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_enable);
      END_STATE();
    case 223:
      if (lookahead == 'r') ADVANCE(263);
      END_STATE();
    case 224:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_handle);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_mat2x2);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_mat2x3);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_mat2x4);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_mat3x2);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_mat3x3);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_mat3x4);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_mat4x2);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_mat4x3);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_mat4x4);
      END_STATE();
    case 235:
      if (lookahead == 'g') ADVANCE(265);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 237:
      if (lookahead == 'a') ADVANCE(267);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 239:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 240:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 241:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 243:
      if (lookahead == 'o') ADVANCE(272);
      END_STATE();
    case 244:
      if (lookahead == 'n') ADVANCE(273);
      END_STATE();
    case 245:
      if (lookahead == 'n') ADVANCE(274);
      END_STATE();
    case 246:
      if (lookahead == 'f') ADVANCE(275);
      if (lookahead == 's') ADVANCE(276);
      if (lookahead == 'u') ADVANCE(277);
      END_STATE();
    case 247:
      if (lookahead == 'f') ADVANCE(278);
      if (lookahead == 's') ADVANCE(279);
      if (lookahead == 'u') ADVANCE(280);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(281);
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 249:
      if (lookahead == 'i') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(284);
      END_STATE();
    case 250:
      if (lookahead == 'r') ADVANCE(285);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(286);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_struct);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_switch);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 255:
      if (lookahead == 'f') ADVANCE(288);
      END_STATE();
    case 256:
      if (lookahead == 'm') ADVANCE(289);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_unless);
      END_STATE();
    case 258:
      if (lookahead == 'o') ADVANCE(290);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_bitcast);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(291);
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_default);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_discard);
      END_STATE();
    case 263:
      if (lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 264:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_private);
      END_STATE();
    case 267:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_r32sint);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_r32uint);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(298);
      END_STATE();
    case 272:
      if (lookahead == 'a') ADVANCE(299);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 274:
      if (lookahead == 't') ADVANCE(301);
      END_STATE();
    case 275:
      if (lookahead == 'l') ADVANCE(302);
      END_STATE();
    case 276:
      if (lookahead == 'i') ADVANCE(303);
      END_STATE();
    case 277:
      if (lookahead == 'i') ADVANCE(304);
      END_STATE();
    case 278:
      if (lookahead == 'l') ADVANCE(305);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(306);
      END_STATE();
    case 280:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 281:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 282:
      if (lookahead == 'o') ADVANCE(309);
      END_STATE();
    case 283:
      if (lookahead == 'n') ADVANCE(310);
      END_STATE();
    case 284:
      if (lookahead == 'o') ADVANCE(311);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_sampler);
      if (lookahead == '_') ADVANCE(312);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_storage);
      END_STATE();
    case 287:
      if (lookahead == '_') ADVANCE(313);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_uniform);
      END_STATE();
    case 290:
      if (lookahead == 'u') ADVANCE(314);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 292:
      if (lookahead == 'n') ADVANCE(315);
      END_STATE();
    case 293:
      if (lookahead == 'u') ADVANCE(316);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_function);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_premerge);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_r32float);
      END_STATE();
    case 297:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 298:
      if (lookahead == 's') ADVANCE(318);
      END_STATE();
    case 299:
      if (lookahead == 't') ADVANCE(319);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_rg32sint);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_rg32uint);
      END_STATE();
    case 302:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(321);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(322);
      END_STATE();
    case 305:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 306:
      if (lookahead == 'n') ADVANCE(324);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 308:
      if (lookahead == 't') ADVANCE(326);
      END_STATE();
    case 309:
      if (lookahead == 'r') ADVANCE(327);
      END_STATE();
    case 310:
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 311:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 312:
      if (lookahead == 'c') ADVANCE(330);
      END_STATE();
    case 313:
      if (lookahead == '1') ADVANCE(331);
      if (lookahead == '2') ADVANCE(332);
      if (lookahead == '3') ADVANCE(333);
      if (lookahead == 'c') ADVANCE(334);
      if (lookahead == 'd') ADVANCE(335);
      if (lookahead == 'm') ADVANCE(336);
      if (lookahead == 's') ADVANCE(337);
      END_STATE();
    case 314:
      if (lookahead == 'p') ADVANCE(338);
      END_STATE();
    case 315:
      if (lookahead == 'g') ADVANCE(339);
      END_STATE();
    case 316:
      if (lookahead == 'g') ADVANCE(340);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 318:
      if (lookahead == 's') ADVANCE(342);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_rg32float);
      END_STATE();
    case 320:
      if (lookahead == 'a') ADVANCE(343);
      END_STATE();
    case 321:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 322:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 323:
      if (lookahead == 'a') ADVANCE(346);
      END_STATE();
    case 324:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 325:
      if (lookahead == 't') ADVANCE(348);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_rgba8sint);
      END_STATE();
    case 327:
      if (lookahead == 'm') ADVANCE(349);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_rgba8uint);
      END_STATE();
    case 329:
      if (lookahead == 'm') ADVANCE(350);
      END_STATE();
    case 330:
      if (lookahead == 'o') ADVANCE(351);
      END_STATE();
    case 331:
      if (lookahead == 'd') ADVANCE(352);
      END_STATE();
    case 332:
      if (lookahead == 'd') ADVANCE(353);
      END_STATE();
    case 333:
      if (lookahead == 'd') ADVANCE(354);
      END_STATE();
    case 334:
      if (lookahead == 'u') ADVANCE(355);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(356);
      END_STATE();
    case 336:
      if (lookahead == 'u') ADVANCE(357);
      END_STATE();
    case 337:
      if (lookahead == 't') ADVANCE(358);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_workgroup);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_continuing);
      END_STATE();
    case 340:
      if (lookahead == 'h') ADVANCE(359);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_read_write);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_regardless);
      END_STATE();
    case 343:
      if (lookahead == 't') ADVANCE(360);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_rgba16sint);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_rgba16uint);
      END_STATE();
    case 346:
      if (lookahead == 't') ADVANCE(361);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_rgba32sint);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_rgba32uint);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_rgba8snorm);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_rgba8unorm);
      END_STATE();
    case 351:
      if (lookahead == 'm') ADVANCE(362);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_texture_1d);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_texture_2d);
      if (lookahead == '_') ADVANCE(363);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_texture_3d);
      END_STATE();
    case 355:
      if (lookahead == 'b') ADVANCE(364);
      END_STATE();
    case 356:
      if (lookahead == 'p') ADVANCE(365);
      END_STATE();
    case 357:
      if (lookahead == 'l') ADVANCE(366);
      END_STATE();
    case 358:
      if (lookahead == 'o') ADVANCE(367);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_fallthrough);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_rgba16float);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_rgba32float);
      END_STATE();
    case 362:
      if (lookahead == 'p') ADVANCE(368);
      END_STATE();
    case 363:
      if (lookahead == 'a') ADVANCE(369);
      END_STATE();
    case 364:
      if (lookahead == 'e') ADVANCE(370);
      END_STATE();
    case 365:
      if (lookahead == 't') ADVANCE(371);
      END_STATE();
    case 366:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 367:
      if (lookahead == 'r') ADVANCE(373);
      END_STATE();
    case 368:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 369:
      if (lookahead == 'r') ADVANCE(375);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_texture_cube);
      if (lookahead == '_') ADVANCE(376);
      END_STATE();
    case 371:
      if (lookahead == 'h') ADVANCE(377);
      END_STATE();
    case 372:
      if (lookahead == 'i') ADVANCE(378);
      END_STATE();
    case 373:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 374:
      if (lookahead == 'r') ADVANCE(380);
      END_STATE();
    case 375:
      if (lookahead == 'r') ADVANCE(381);
      END_STATE();
    case 376:
      if (lookahead == 'a') ADVANCE(382);
      END_STATE();
    case 377:
      if (lookahead == '_') ADVANCE(383);
      END_STATE();
    case 378:
      if (lookahead == 's') ADVANCE(384);
      END_STATE();
    case 379:
      if (lookahead == 'g') ADVANCE(385);
      END_STATE();
    case 380:
      if (lookahead == 'i') ADVANCE(386);
      END_STATE();
    case 381:
      if (lookahead == 'a') ADVANCE(387);
      END_STATE();
    case 382:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 383:
      if (lookahead == '2') ADVANCE(389);
      if (lookahead == 'c') ADVANCE(390);
      if (lookahead == 'm') ADVANCE(391);
      END_STATE();
    case 384:
      if (lookahead == 'a') ADVANCE(392);
      END_STATE();
    case 385:
      if (lookahead == 'e') ADVANCE(393);
      END_STATE();
    case 386:
      if (lookahead == 's') ADVANCE(394);
      END_STATE();
    case 387:
      if (lookahead == 'y') ADVANCE(395);
      END_STATE();
    case 388:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 389:
      if (lookahead == 'd') ADVANCE(397);
      END_STATE();
    case 390:
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 391:
      if (lookahead == 'u') ADVANCE(399);
      END_STATE();
    case 392:
      if (lookahead == 'm') ADVANCE(400);
      END_STATE();
    case 393:
      if (lookahead == '_') ADVANCE(401);
      END_STATE();
    case 394:
      if (lookahead == 'o') ADVANCE(402);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_texture_2d_array);
      END_STATE();
    case 396:
      if (lookahead == 'a') ADVANCE(403);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_texture_depth_2d);
      if (lookahead == '_') ADVANCE(404);
      END_STATE();
    case 398:
      if (lookahead == 'b') ADVANCE(405);
      END_STATE();
    case 399:
      if (lookahead == 'l') ADVANCE(406);
      END_STATE();
    case 400:
      if (lookahead == 'p') ADVANCE(407);
      END_STATE();
    case 401:
      if (lookahead == '1') ADVANCE(408);
      if (lookahead == '2') ADVANCE(409);
      if (lookahead == '3') ADVANCE(410);
      END_STATE();
    case 402:
      if (lookahead == 'n') ADVANCE(411);
      END_STATE();
    case 403:
      if (lookahead == 'y') ADVANCE(412);
      END_STATE();
    case 404:
      if (lookahead == 'a') ADVANCE(413);
      END_STATE();
    case 405:
      if (lookahead == 'e') ADVANCE(414);
      END_STATE();
    case 406:
      if (lookahead == 't') ADVANCE(415);
      END_STATE();
    case 407:
      if (lookahead == 'l') ADVANCE(416);
      END_STATE();
    case 408:
      if (lookahead == 'd') ADVANCE(417);
      END_STATE();
    case 409:
      if (lookahead == 'd') ADVANCE(418);
      END_STATE();
    case 410:
      if (lookahead == 'd') ADVANCE(419);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_sampler_comparison);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_texture_cube_array);
      END_STATE();
    case 413:
      if (lookahead == 'r') ADVANCE(420);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_texture_depth_cube);
      if (lookahead == '_') ADVANCE(421);
      END_STATE();
    case 415:
      if (lookahead == 'i') ADVANCE(422);
      END_STATE();
    case 416:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_texture_storage_1d);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_texture_storage_2d);
      if (lookahead == '_') ADVANCE(424);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_texture_storage_3d);
      END_STATE();
    case 420:
      if (lookahead == 'r') ADVANCE(425);
      END_STATE();
    case 421:
      if (lookahead == 'a') ADVANCE(426);
      END_STATE();
    case 422:
      if (lookahead == 's') ADVANCE(427);
      END_STATE();
    case 423:
      if (lookahead == 'd') ADVANCE(428);
      END_STATE();
    case 424:
      if (lookahead == 'a') ADVANCE(429);
      END_STATE();
    case 425:
      if (lookahead == 'a') ADVANCE(430);
      END_STATE();
    case 426:
      if (lookahead == 'r') ADVANCE(431);
      END_STATE();
    case 427:
      if (lookahead == 'a') ADVANCE(432);
      END_STATE();
    case 428:
      if (lookahead == '_') ADVANCE(433);
      END_STATE();
    case 429:
      if (lookahead == 'r') ADVANCE(434);
      END_STATE();
    case 430:
      if (lookahead == 'y') ADVANCE(435);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(436);
      END_STATE();
    case 432:
      if (lookahead == 'm') ADVANCE(437);
      END_STATE();
    case 433:
      if (lookahead == '2') ADVANCE(438);
      END_STATE();
    case 434:
      if (lookahead == 'r') ADVANCE(439);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_texture_depth_2d_array);
      END_STATE();
    case 436:
      if (lookahead == 'a') ADVANCE(440);
      END_STATE();
    case 437:
      if (lookahead == 'p') ADVANCE(441);
      END_STATE();
    case 438:
      if (lookahead == 'd') ADVANCE(442);
      END_STATE();
    case 439:
      if (lookahead == 'a') ADVANCE(443);
      END_STATE();
    case 440:
      if (lookahead == 'y') ADVANCE(444);
      END_STATE();
    case 441:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_texture_multisampled_2d);
      END_STATE();
    case 443:
      if (lookahead == 'y') ADVANCE(446);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_texture_depth_cube_array);
      END_STATE();
    case 445:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_texture_storage_2d_array);
      END_STATE();
    case 447:
      if (lookahead == 'd') ADVANCE(448);
      END_STATE();
    case 448:
      if (lookahead == '_') ADVANCE(449);
      END_STATE();
    case 449:
      if (lookahead == '2') ADVANCE(450);
      END_STATE();
    case 450:
      if (lookahead == 'd') ADVANCE(451);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_texture_depth_multisampled_2d);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 1},
  [2] = {.lex_state = 38, .external_lex_state = 1},
  [3] = {.lex_state = 38, .external_lex_state = 1},
  [4] = {.lex_state = 38, .external_lex_state = 1},
  [5] = {.lex_state = 38, .external_lex_state = 1},
  [6] = {.lex_state = 38, .external_lex_state = 1},
  [7] = {.lex_state = 38, .external_lex_state = 1},
  [8] = {.lex_state = 38, .external_lex_state = 1},
  [9] = {.lex_state = 38, .external_lex_state = 1},
  [10] = {.lex_state = 38, .external_lex_state = 1},
  [11] = {.lex_state = 38, .external_lex_state = 1},
  [12] = {.lex_state = 38, .external_lex_state = 1},
  [13] = {.lex_state = 38, .external_lex_state = 1},
  [14] = {.lex_state = 38, .external_lex_state = 1},
  [15] = {.lex_state = 38, .external_lex_state = 1},
  [16] = {.lex_state = 38, .external_lex_state = 1},
  [17] = {.lex_state = 38, .external_lex_state = 1},
  [18] = {.lex_state = 38, .external_lex_state = 1},
  [19] = {.lex_state = 38, .external_lex_state = 1},
  [20] = {.lex_state = 38, .external_lex_state = 1},
  [21] = {.lex_state = 38, .external_lex_state = 1},
  [22] = {.lex_state = 38, .external_lex_state = 1},
  [23] = {.lex_state = 38, .external_lex_state = 1},
  [24] = {.lex_state = 38, .external_lex_state = 1},
  [25] = {.lex_state = 38, .external_lex_state = 1},
  [26] = {.lex_state = 38, .external_lex_state = 1},
  [27] = {.lex_state = 38, .external_lex_state = 1},
  [28] = {.lex_state = 38, .external_lex_state = 1},
  [29] = {.lex_state = 38, .external_lex_state = 1},
  [30] = {.lex_state = 38, .external_lex_state = 1},
  [31] = {.lex_state = 38, .external_lex_state = 1},
  [32] = {.lex_state = 38, .external_lex_state = 1},
  [33] = {.lex_state = 38, .external_lex_state = 1},
  [34] = {.lex_state = 38, .external_lex_state = 1},
  [35] = {.lex_state = 38, .external_lex_state = 1},
  [36] = {.lex_state = 38, .external_lex_state = 1},
  [37] = {.lex_state = 38, .external_lex_state = 1},
  [38] = {.lex_state = 38, .external_lex_state = 1},
  [39] = {.lex_state = 38, .external_lex_state = 1},
  [40] = {.lex_state = 38, .external_lex_state = 1},
  [41] = {.lex_state = 38, .external_lex_state = 1},
  [42] = {.lex_state = 38, .external_lex_state = 1},
  [43] = {.lex_state = 38, .external_lex_state = 1},
  [44] = {.lex_state = 38, .external_lex_state = 1},
  [45] = {.lex_state = 38, .external_lex_state = 1},
  [46] = {.lex_state = 38, .external_lex_state = 1},
  [47] = {.lex_state = 38, .external_lex_state = 1},
  [48] = {.lex_state = 38, .external_lex_state = 1},
  [49] = {.lex_state = 38, .external_lex_state = 1},
  [50] = {.lex_state = 38, .external_lex_state = 1},
  [51] = {.lex_state = 38, .external_lex_state = 1},
  [52] = {.lex_state = 38, .external_lex_state = 1},
  [53] = {.lex_state = 0, .external_lex_state = 1},
  [54] = {.lex_state = 0, .external_lex_state = 1},
  [55] = {.lex_state = 0, .external_lex_state = 1},
  [56] = {.lex_state = 0, .external_lex_state = 1},
  [57] = {.lex_state = 0, .external_lex_state = 1},
  [58] = {.lex_state = 0, .external_lex_state = 1},
  [59] = {.lex_state = 0, .external_lex_state = 1},
  [60] = {.lex_state = 0, .external_lex_state = 1},
  [61] = {.lex_state = 0, .external_lex_state = 1},
  [62] = {.lex_state = 0, .external_lex_state = 1},
  [63] = {.lex_state = 0, .external_lex_state = 1},
  [64] = {.lex_state = 0, .external_lex_state = 1},
  [65] = {.lex_state = 0, .external_lex_state = 1},
  [66] = {.lex_state = 38, .external_lex_state = 1},
  [67] = {.lex_state = 38, .external_lex_state = 1},
  [68] = {.lex_state = 0, .external_lex_state = 1},
  [69] = {.lex_state = 38, .external_lex_state = 1},
  [70] = {.lex_state = 0, .external_lex_state = 1},
  [71] = {.lex_state = 0, .external_lex_state = 1},
  [72] = {.lex_state = 0, .external_lex_state = 1},
  [73] = {.lex_state = 0, .external_lex_state = 1},
  [74] = {.lex_state = 38, .external_lex_state = 1},
  [75] = {.lex_state = 38, .external_lex_state = 1},
  [76] = {.lex_state = 38, .external_lex_state = 1},
  [77] = {.lex_state = 38, .external_lex_state = 1},
  [78] = {.lex_state = 38, .external_lex_state = 1},
  [79] = {.lex_state = 38, .external_lex_state = 1},
  [80] = {.lex_state = 38, .external_lex_state = 1},
  [81] = {.lex_state = 38, .external_lex_state = 1},
  [82] = {.lex_state = 38, .external_lex_state = 1},
  [83] = {.lex_state = 38, .external_lex_state = 1},
  [84] = {.lex_state = 1, .external_lex_state = 1},
  [85] = {.lex_state = 1, .external_lex_state = 1},
  [86] = {.lex_state = 1, .external_lex_state = 1},
  [87] = {.lex_state = 1, .external_lex_state = 1},
  [88] = {.lex_state = 1, .external_lex_state = 1},
  [89] = {.lex_state = 1, .external_lex_state = 1},
  [90] = {.lex_state = 1, .external_lex_state = 1},
  [91] = {.lex_state = 1, .external_lex_state = 1},
  [92] = {.lex_state = 1, .external_lex_state = 1},
  [93] = {.lex_state = 1, .external_lex_state = 1},
  [94] = {.lex_state = 3, .external_lex_state = 1},
  [95] = {.lex_state = 1, .external_lex_state = 1},
  [96] = {.lex_state = 3, .external_lex_state = 1},
  [97] = {.lex_state = 1, .external_lex_state = 1},
  [98] = {.lex_state = 1, .external_lex_state = 1},
  [99] = {.lex_state = 1, .external_lex_state = 1},
  [100] = {.lex_state = 1, .external_lex_state = 1},
  [101] = {.lex_state = 1, .external_lex_state = 1},
  [102] = {.lex_state = 0, .external_lex_state = 1},
  [103] = {.lex_state = 1, .external_lex_state = 1},
  [104] = {.lex_state = 1, .external_lex_state = 1},
  [105] = {.lex_state = 1, .external_lex_state = 1},
  [106] = {.lex_state = 1, .external_lex_state = 1},
  [107] = {.lex_state = 3, .external_lex_state = 1},
  [108] = {.lex_state = 2, .external_lex_state = 1},
  [109] = {.lex_state = 3, .external_lex_state = 1},
  [110] = {.lex_state = 38, .external_lex_state = 1},
  [111] = {.lex_state = 38, .external_lex_state = 1},
  [112] = {.lex_state = 38, .external_lex_state = 1},
  [113] = {.lex_state = 2, .external_lex_state = 1},
  [114] = {.lex_state = 38, .external_lex_state = 1},
  [115] = {.lex_state = 38, .external_lex_state = 1},
  [116] = {.lex_state = 2, .external_lex_state = 1},
  [117] = {.lex_state = 2, .external_lex_state = 1},
  [118] = {.lex_state = 38, .external_lex_state = 1},
  [119] = {.lex_state = 38, .external_lex_state = 1},
  [120] = {.lex_state = 38, .external_lex_state = 1},
  [121] = {.lex_state = 38, .external_lex_state = 1},
  [122] = {.lex_state = 38, .external_lex_state = 1},
  [123] = {.lex_state = 2, .external_lex_state = 1},
  [124] = {.lex_state = 2, .external_lex_state = 1},
  [125] = {.lex_state = 2, .external_lex_state = 1},
  [126] = {.lex_state = 1, .external_lex_state = 1},
  [127] = {.lex_state = 2, .external_lex_state = 1},
  [128] = {.lex_state = 2, .external_lex_state = 1},
  [129] = {.lex_state = 2, .external_lex_state = 1},
  [130] = {.lex_state = 2, .external_lex_state = 1},
  [131] = {.lex_state = 2, .external_lex_state = 1},
  [132] = {.lex_state = 38, .external_lex_state = 1},
  [133] = {.lex_state = 2, .external_lex_state = 1},
  [134] = {.lex_state = 2, .external_lex_state = 1},
  [135] = {.lex_state = 0, .external_lex_state = 1},
  [136] = {.lex_state = 0, .external_lex_state = 1},
  [137] = {.lex_state = 0, .external_lex_state = 1},
  [138] = {.lex_state = 0, .external_lex_state = 1},
  [139] = {.lex_state = 2, .external_lex_state = 1},
  [140] = {.lex_state = 2, .external_lex_state = 1},
  [141] = {.lex_state = 2, .external_lex_state = 1},
  [142] = {.lex_state = 2, .external_lex_state = 1},
  [143] = {.lex_state = 2, .external_lex_state = 1},
  [144] = {.lex_state = 2, .external_lex_state = 1},
  [145] = {.lex_state = 4, .external_lex_state = 1},
  [146] = {.lex_state = 2, .external_lex_state = 1},
  [147] = {.lex_state = 2, .external_lex_state = 1},
  [148] = {.lex_state = 2, .external_lex_state = 1},
  [149] = {.lex_state = 4, .external_lex_state = 1},
  [150] = {.lex_state = 38, .external_lex_state = 1},
  [151] = {.lex_state = 4, .external_lex_state = 1},
  [152] = {.lex_state = 4, .external_lex_state = 1},
  [153] = {.lex_state = 4, .external_lex_state = 1},
  [154] = {.lex_state = 38, .external_lex_state = 1},
  [155] = {.lex_state = 4, .external_lex_state = 1},
  [156] = {.lex_state = 4, .external_lex_state = 1},
  [157] = {.lex_state = 2, .external_lex_state = 1},
  [158] = {.lex_state = 38, .external_lex_state = 1},
  [159] = {.lex_state = 4, .external_lex_state = 1},
  [160] = {.lex_state = 38, .external_lex_state = 1},
  [161] = {.lex_state = 1, .external_lex_state = 1},
  [162] = {.lex_state = 4, .external_lex_state = 1},
  [163] = {.lex_state = 2, .external_lex_state = 1},
  [164] = {.lex_state = 0, .external_lex_state = 1},
  [165] = {.lex_state = 2, .external_lex_state = 1},
  [166] = {.lex_state = 1, .external_lex_state = 1},
  [167] = {.lex_state = 1, .external_lex_state = 1},
  [168] = {.lex_state = 1, .external_lex_state = 1},
  [169] = {.lex_state = 2, .external_lex_state = 1},
  [170] = {.lex_state = 1, .external_lex_state = 1},
  [171] = {.lex_state = 38, .external_lex_state = 1},
  [172] = {.lex_state = 0, .external_lex_state = 1},
  [173] = {.lex_state = 0, .external_lex_state = 1},
  [174] = {.lex_state = 6, .external_lex_state = 1},
  [175] = {.lex_state = 0, .external_lex_state = 1},
  [176] = {.lex_state = 38, .external_lex_state = 1},
  [177] = {.lex_state = 0, .external_lex_state = 1},
  [178] = {.lex_state = 38, .external_lex_state = 1},
  [179] = {.lex_state = 0, .external_lex_state = 1},
  [180] = {.lex_state = 38, .external_lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 1},
  [182] = {.lex_state = 0, .external_lex_state = 1},
  [183] = {.lex_state = 1, .external_lex_state = 1},
  [184] = {.lex_state = 0, .external_lex_state = 1},
  [185] = {.lex_state = 38, .external_lex_state = 1},
  [186] = {.lex_state = 38, .external_lex_state = 1},
  [187] = {.lex_state = 38, .external_lex_state = 1},
  [188] = {.lex_state = 0, .external_lex_state = 1},
  [189] = {.lex_state = 0, .external_lex_state = 1},
  [190] = {.lex_state = 0, .external_lex_state = 1},
  [191] = {.lex_state = 0, .external_lex_state = 1},
  [192] = {.lex_state = 6, .external_lex_state = 1},
  [193] = {.lex_state = 0, .external_lex_state = 1},
  [194] = {.lex_state = 0, .external_lex_state = 1},
  [195] = {.lex_state = 0, .external_lex_state = 1},
  [196] = {.lex_state = 38, .external_lex_state = 1},
  [197] = {.lex_state = 38, .external_lex_state = 1},
  [198] = {.lex_state = 6, .external_lex_state = 1},
  [199] = {.lex_state = 0, .external_lex_state = 1},
  [200] = {.lex_state = 0, .external_lex_state = 1},
  [201] = {.lex_state = 6, .external_lex_state = 1},
  [202] = {.lex_state = 6, .external_lex_state = 1},
  [203] = {.lex_state = 38, .external_lex_state = 1},
  [204] = {.lex_state = 6, .external_lex_state = 1},
  [205] = {.lex_state = 38, .external_lex_state = 1},
  [206] = {.lex_state = 6, .external_lex_state = 1},
  [207] = {.lex_state = 38, .external_lex_state = 1},
  [208] = {.lex_state = 38, .external_lex_state = 1},
  [209] = {.lex_state = 38, .external_lex_state = 1},
  [210] = {.lex_state = 6, .external_lex_state = 1},
  [211] = {.lex_state = 6, .external_lex_state = 1},
  [212] = {.lex_state = 6, .external_lex_state = 1},
  [213] = {.lex_state = 6, .external_lex_state = 1},
  [214] = {.lex_state = 38, .external_lex_state = 1},
  [215] = {.lex_state = 38, .external_lex_state = 1},
  [216] = {.lex_state = 38, .external_lex_state = 1},
  [217] = {.lex_state = 38, .external_lex_state = 1},
  [218] = {.lex_state = 6, .external_lex_state = 1},
  [219] = {.lex_state = 38, .external_lex_state = 1},
  [220] = {.lex_state = 0, .external_lex_state = 1},
  [221] = {.lex_state = 0, .external_lex_state = 1},
  [222] = {.lex_state = 0, .external_lex_state = 1},
  [223] = {.lex_state = 38, .external_lex_state = 1},
  [224] = {.lex_state = 0, .external_lex_state = 1},
  [225] = {.lex_state = 38, .external_lex_state = 1},
  [226] = {.lex_state = 38, .external_lex_state = 1},
  [227] = {.lex_state = 38, .external_lex_state = 1},
  [228] = {.lex_state = 38, .external_lex_state = 1},
  [229] = {.lex_state = 0, .external_lex_state = 1},
  [230] = {.lex_state = 0, .external_lex_state = 1},
  [231] = {.lex_state = 0, .external_lex_state = 1},
  [232] = {.lex_state = 38, .external_lex_state = 1},
  [233] = {.lex_state = 0, .external_lex_state = 1},
  [234] = {.lex_state = 38, .external_lex_state = 1},
  [235] = {.lex_state = 38, .external_lex_state = 1},
  [236] = {.lex_state = 0, .external_lex_state = 1},
  [237] = {.lex_state = 38, .external_lex_state = 1},
  [238] = {.lex_state = 0, .external_lex_state = 1},
  [239] = {.lex_state = 0, .external_lex_state = 1},
  [240] = {.lex_state = 38, .external_lex_state = 1},
  [241] = {.lex_state = 3, .external_lex_state = 1},
  [242] = {.lex_state = 0, .external_lex_state = 1},
  [243] = {.lex_state = 0, .external_lex_state = 1},
  [244] = {.lex_state = 0, .external_lex_state = 1},
  [245] = {.lex_state = 38, .external_lex_state = 1},
  [246] = {.lex_state = 0, .external_lex_state = 1},
  [247] = {.lex_state = 38, .external_lex_state = 1},
  [248] = {.lex_state = 38, .external_lex_state = 1},
  [249] = {.lex_state = 38, .external_lex_state = 1},
  [250] = {.lex_state = 0, .external_lex_state = 1},
  [251] = {.lex_state = 38, .external_lex_state = 1},
  [252] = {.lex_state = 0, .external_lex_state = 1},
  [253] = {.lex_state = 0, .external_lex_state = 1},
  [254] = {.lex_state = 0, .external_lex_state = 1},
  [255] = {.lex_state = 0, .external_lex_state = 1},
  [256] = {.lex_state = 0, .external_lex_state = 1},
  [257] = {.lex_state = 0, .external_lex_state = 1},
  [258] = {.lex_state = 0, .external_lex_state = 1},
  [259] = {.lex_state = 0, .external_lex_state = 1},
  [260] = {.lex_state = 0, .external_lex_state = 1},
  [261] = {.lex_state = 38, .external_lex_state = 1},
  [262] = {.lex_state = 0, .external_lex_state = 1},
  [263] = {.lex_state = 0, .external_lex_state = 1},
  [264] = {.lex_state = 38, .external_lex_state = 1},
  [265] = {.lex_state = 0, .external_lex_state = 1},
  [266] = {.lex_state = 38, .external_lex_state = 1},
  [267] = {.lex_state = 0, .external_lex_state = 1},
  [268] = {.lex_state = 0, .external_lex_state = 1},
  [269] = {.lex_state = 0, .external_lex_state = 1},
  [270] = {.lex_state = 0, .external_lex_state = 1},
  [271] = {.lex_state = 0, .external_lex_state = 1},
  [272] = {.lex_state = 0, .external_lex_state = 1},
  [273] = {.lex_state = 0, .external_lex_state = 1},
  [274] = {.lex_state = 0, .external_lex_state = 1},
  [275] = {.lex_state = 0, .external_lex_state = 1},
  [276] = {.lex_state = 0, .external_lex_state = 1},
  [277] = {.lex_state = 3, .external_lex_state = 1},
  [278] = {.lex_state = 0, .external_lex_state = 1},
  [279] = {.lex_state = 38, .external_lex_state = 1},
  [280] = {.lex_state = 0, .external_lex_state = 1},
  [281] = {.lex_state = 3, .external_lex_state = 1},
  [282] = {.lex_state = 0, .external_lex_state = 1},
  [283] = {.lex_state = 0, .external_lex_state = 1},
  [284] = {.lex_state = 0, .external_lex_state = 1},
  [285] = {.lex_state = 0, .external_lex_state = 1},
  [286] = {.lex_state = 0, .external_lex_state = 1},
  [287] = {.lex_state = 0, .external_lex_state = 1},
  [288] = {.lex_state = 0, .external_lex_state = 1},
  [289] = {.lex_state = 0, .external_lex_state = 1},
  [290] = {.lex_state = 38, .external_lex_state = 1},
  [291] = {.lex_state = 0, .external_lex_state = 1},
  [292] = {.lex_state = 0, .external_lex_state = 1},
  [293] = {.lex_state = 0, .external_lex_state = 1},
  [294] = {.lex_state = 0, .external_lex_state = 1},
  [295] = {.lex_state = 38, .external_lex_state = 1},
  [296] = {.lex_state = 0, .external_lex_state = 1},
  [297] = {.lex_state = 0, .external_lex_state = 1},
  [298] = {.lex_state = 38, .external_lex_state = 1},
  [299] = {.lex_state = 0, .external_lex_state = 1},
  [300] = {.lex_state = 0, .external_lex_state = 1},
  [301] = {.lex_state = 0, .external_lex_state = 1},
  [302] = {.lex_state = 38, .external_lex_state = 1},
  [303] = {.lex_state = 0, .external_lex_state = 1},
  [304] = {.lex_state = 0, .external_lex_state = 1},
  [305] = {.lex_state = 0, .external_lex_state = 1},
  [306] = {.lex_state = 0, .external_lex_state = 1},
  [307] = {.lex_state = 0, .external_lex_state = 1},
  [308] = {.lex_state = 0, .external_lex_state = 1},
  [309] = {.lex_state = 0, .external_lex_state = 1},
  [310] = {.lex_state = 0, .external_lex_state = 1},
  [311] = {.lex_state = 0, .external_lex_state = 1},
  [312] = {.lex_state = 38, .external_lex_state = 1},
  [313] = {.lex_state = 0, .external_lex_state = 1},
  [314] = {.lex_state = 38, .external_lex_state = 1},
  [315] = {.lex_state = 38, .external_lex_state = 1},
  [316] = {.lex_state = 38, .external_lex_state = 1},
  [317] = {.lex_state = 0, .external_lex_state = 1},
  [318] = {.lex_state = 0, .external_lex_state = 1},
  [319] = {.lex_state = 0, .external_lex_state = 1},
  [320] = {.lex_state = 0, .external_lex_state = 1},
  [321] = {.lex_state = 0, .external_lex_state = 1},
  [322] = {.lex_state = 0, .external_lex_state = 1},
  [323] = {.lex_state = 0, .external_lex_state = 1},
  [324] = {.lex_state = 38, .external_lex_state = 1},
  [325] = {.lex_state = 0, .external_lex_state = 1},
  [326] = {.lex_state = 0, .external_lex_state = 1},
  [327] = {.lex_state = 0, .external_lex_state = 1},
  [328] = {.lex_state = 0, .external_lex_state = 1},
  [329] = {.lex_state = 0, .external_lex_state = 1},
  [330] = {.lex_state = 0, .external_lex_state = 1},
  [331] = {.lex_state = 0, .external_lex_state = 1},
  [332] = {.lex_state = 0, .external_lex_state = 1},
  [333] = {.lex_state = 38, .external_lex_state = 1},
  [334] = {.lex_state = 38, .external_lex_state = 1},
  [335] = {.lex_state = 38, .external_lex_state = 1},
  [336] = {.lex_state = 0, .external_lex_state = 1},
  [337] = {.lex_state = 0, .external_lex_state = 1},
  [338] = {.lex_state = 0, .external_lex_state = 1},
  [339] = {.lex_state = 0, .external_lex_state = 1},
  [340] = {.lex_state = 0, .external_lex_state = 1},
  [341] = {.lex_state = 38, .external_lex_state = 1},
  [342] = {.lex_state = 0, .external_lex_state = 1},
  [343] = {.lex_state = 0, .external_lex_state = 1},
  [344] = {.lex_state = 38, .external_lex_state = 1},
  [345] = {.lex_state = 38, .external_lex_state = 1},
  [346] = {.lex_state = 38, .external_lex_state = 1},
  [347] = {.lex_state = 38, .external_lex_state = 1},
  [348] = {.lex_state = 0, .external_lex_state = 1},
  [349] = {.lex_state = 38, .external_lex_state = 1},
  [350] = {.lex_state = 0, .external_lex_state = 1},
  [351] = {.lex_state = 38, .external_lex_state = 1},
  [352] = {.lex_state = 38, .external_lex_state = 1},
  [353] = {.lex_state = 38, .external_lex_state = 1},
  [354] = {.lex_state = 0, .external_lex_state = 1},
  [355] = {.lex_state = 38, .external_lex_state = 1},
  [356] = {.lex_state = 0, .external_lex_state = 1},
  [357] = {.lex_state = 0, .external_lex_state = 1},
  [358] = {.lex_state = 0, .external_lex_state = 1},
  [359] = {.lex_state = 38, .external_lex_state = 1},
  [360] = {.lex_state = 0, .external_lex_state = 1},
  [361] = {.lex_state = 0, .external_lex_state = 1},
  [362] = {.lex_state = 0, .external_lex_state = 1},
  [363] = {.lex_state = 0, .external_lex_state = 1},
  [364] = {.lex_state = 0, .external_lex_state = 1},
  [365] = {.lex_state = 0, .external_lex_state = 1},
  [366] = {.lex_state = 0, .external_lex_state = 1},
  [367] = {.lex_state = 0, .external_lex_state = 1},
  [368] = {.lex_state = 0, .external_lex_state = 1},
  [369] = {.lex_state = 0, .external_lex_state = 1},
  [370] = {.lex_state = 0, .external_lex_state = 1},
  [371] = {.lex_state = 0, .external_lex_state = 1},
  [372] = {.lex_state = 0, .external_lex_state = 1},
  [373] = {.lex_state = 0, .external_lex_state = 1},
  [374] = {.lex_state = 0, .external_lex_state = 1},
  [375] = {.lex_state = 0, .external_lex_state = 1},
  [376] = {.lex_state = 0, .external_lex_state = 1},
  [377] = {.lex_state = 0, .external_lex_state = 1},
  [378] = {.lex_state = 0, .external_lex_state = 1},
  [379] = {.lex_state = 0, .external_lex_state = 1},
  [380] = {.lex_state = 0, .external_lex_state = 1},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 0, .external_lex_state = 1},
  [383] = {.lex_state = 38, .external_lex_state = 1},
  [384] = {.lex_state = 0, .external_lex_state = 1},
  [385] = {.lex_state = 38, .external_lex_state = 1},
  [386] = {.lex_state = 38, .external_lex_state = 1},
  [387] = {.lex_state = 128, .external_lex_state = 1},
  [388] = {.lex_state = 0, .external_lex_state = 1},
  [389] = {.lex_state = 0, .external_lex_state = 1},
  [390] = {.lex_state = 0, .external_lex_state = 1},
  [391] = {.lex_state = 38, .external_lex_state = 1},
  [392] = {.lex_state = 0, .external_lex_state = 1},
  [393] = {.lex_state = 0, .external_lex_state = 1},
  [394] = {.lex_state = 38, .external_lex_state = 1},
  [395] = {.lex_state = 0, .external_lex_state = 1},
  [396] = {.lex_state = 0, .external_lex_state = 1},
  [397] = {.lex_state = 0, .external_lex_state = 1},
  [398] = {.lex_state = 0, .external_lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 1},
  [400] = {.lex_state = 0, .external_lex_state = 1},
  [401] = {.lex_state = 38, .external_lex_state = 1},
  [402] = {.lex_state = 0, .external_lex_state = 1},
  [403] = {.lex_state = 0, .external_lex_state = 1},
  [404] = {.lex_state = 38, .external_lex_state = 1},
  [405] = {.lex_state = 0, .external_lex_state = 1},
  [406] = {.lex_state = 0, .external_lex_state = 1},
  [407] = {.lex_state = 38, .external_lex_state = 1},
  [408] = {.lex_state = 0, .external_lex_state = 1},
  [409] = {.lex_state = 38, .external_lex_state = 1},
  [410] = {.lex_state = 0, .external_lex_state = 1},
  [411] = {.lex_state = 0, .external_lex_state = 1},
  [412] = {.lex_state = 0, .external_lex_state = 1},
  [413] = {.lex_state = 0, .external_lex_state = 1},
  [414] = {.lex_state = 38, .external_lex_state = 1},
  [415] = {.lex_state = 38, .external_lex_state = 1},
  [416] = {.lex_state = 0, .external_lex_state = 1},
  [417] = {.lex_state = 0, .external_lex_state = 1},
  [418] = {.lex_state = 0, .external_lex_state = 1},
  [419] = {.lex_state = 38, .external_lex_state = 1},
  [420] = {.lex_state = 0, .external_lex_state = 1},
  [421] = {.lex_state = 0, .external_lex_state = 1},
  [422] = {.lex_state = 0, .external_lex_state = 1},
  [423] = {.lex_state = 0, .external_lex_state = 1},
  [424] = {.lex_state = 38, .external_lex_state = 1},
  [425] = {.lex_state = 0, .external_lex_state = 1},
  [426] = {.lex_state = 38, .external_lex_state = 1},
  [427] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__block_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__block_comment] = sym__block_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__block_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym__comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym_decimal_float_literal] = ACTIONS(1),
    [sym_hex_float_literal] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_uint_literal] = ACTIONS(1),
    [anon_sym_read] = ACTIONS(1),
    [anon_sym_write] = ACTIONS(1),
    [anon_sym_read_write] = ACTIONS(1),
    [anon_sym_rgba8unorm] = ACTIONS(1),
    [anon_sym_rgba8snorm] = ACTIONS(1),
    [anon_sym_rgba8uint] = ACTIONS(1),
    [anon_sym_rgba8sint] = ACTIONS(1),
    [anon_sym_rgba16uint] = ACTIONS(1),
    [anon_sym_rgba16sint] = ACTIONS(1),
    [anon_sym_rgba16float] = ACTIONS(1),
    [anon_sym_r32uint] = ACTIONS(1),
    [anon_sym_r32sint] = ACTIONS(1),
    [anon_sym_r32float] = ACTIONS(1),
    [anon_sym_rg32uint] = ACTIONS(1),
    [anon_sym_rg32sint] = ACTIONS(1),
    [anon_sym_rg32float] = ACTIONS(1),
    [anon_sym_rgba32uint] = ACTIONS(1),
    [anon_sym_rgba32sint] = ACTIONS(1),
    [anon_sym_rgba32float] = ACTIONS(1),
    [sym_array] = ACTIONS(1),
    [sym_atomic] = ACTIONS(1),
    [sym_bool] = ACTIONS(1),
    [sym_float32] = ACTIONS(1),
    [sym_int32] = ACTIONS(1),
    [sym_mat2x2] = ACTIONS(1),
    [sym_mat2x3] = ACTIONS(1),
    [sym_mat2x4] = ACTIONS(1),
    [sym_mat3x2] = ACTIONS(1),
    [sym_mat3x3] = ACTIONS(1),
    [sym_mat3x4] = ACTIONS(1),
    [sym_mat4x2] = ACTIONS(1),
    [sym_mat4x3] = ACTIONS(1),
    [sym_mat4x4] = ACTIONS(1),
    [sym_pointer] = ACTIONS(1),
    [sym_sampler] = ACTIONS(1),
    [sym_sampler_comparison] = ACTIONS(1),
    [sym_struct] = ACTIONS(1),
    [sym_texture_1d] = ACTIONS(1),
    [sym_texture_2d] = ACTIONS(1),
    [sym_texture_2d_array] = ACTIONS(1),
    [sym_texture_3d] = ACTIONS(1),
    [sym_texture_cube] = ACTIONS(1),
    [sym_texture_cube_array] = ACTIONS(1),
    [sym_texture_multisampled_2d] = ACTIONS(1),
    [sym_texture_storage_1d] = ACTIONS(1),
    [sym_texture_storage_2d] = ACTIONS(1),
    [sym_texture_storage_2d_array] = ACTIONS(1),
    [sym_texture_storage_3d] = ACTIONS(1),
    [sym_texture_depth_2d] = ACTIONS(1),
    [sym_texture_depth_2d_array] = ACTIONS(1),
    [sym_texture_depth_cube] = ACTIONS(1),
    [sym_texture_depth_cube_array] = ACTIONS(1),
    [sym_texture_depth_multisampled_2d] = ACTIONS(1),
    [sym_uint32] = ACTIONS(1),
    [sym_vec2] = ACTIONS(1),
    [sym_vec3] = ACTIONS(1),
    [sym_vec4] = ACTIONS(1),
    [sym_bitcast] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_case] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [sym_continuing] = ACTIONS(1),
    [sym_default] = ACTIONS(1),
    [sym_discard] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_enable] = ACTIONS(1),
    [sym_fallthrough] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_fn] = ACTIONS(1),
    [sym_for] = ACTIONS(1),
    [sym_function] = ACTIONS(1),
    [sym_if] = ACTIONS(1),
    [sym_let] = ACTIONS(1),
    [sym_loop] = ACTIONS(1),
    [sym_private] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_storage] = ACTIONS(1),
    [sym_switch] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_uniform] = ACTIONS(1),
    [sym_var] = ACTIONS(1),
    [sym_workgroup] = ACTIONS(1),
    [sym_and] = ACTIONS(1),
    [sym_and_and] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_attr] = ACTIONS(1),
    [sym_forward_slash] = ACTIONS(1),
    [sym_bang] = ACTIONS(1),
    [sym_bracket_left] = ACTIONS(1),
    [sym_bracket_right] = ACTIONS(1),
    [sym_brace_left] = ACTIONS(1),
    [sym_brace_right] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_comma] = ACTIONS(1),
    [sym_equal] = ACTIONS(1),
    [sym_equal_equal] = ACTIONS(1),
    [sym_not_equal] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [sym_greater_than_equal] = ACTIONS(1),
    [sym_shift_right] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_less_than_equal] = ACTIONS(1),
    [sym_shift_left] = ACTIONS(1),
    [sym_modulo] = ACTIONS(1),
    [sym_minus] = ACTIONS(1),
    [sym_period] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plus_plus] = ACTIONS(1),
    [sym_or] = ACTIONS(1),
    [sym_or_or] = ACTIONS(1),
    [sym_paren_left] = ACTIONS(1),
    [sym_paren_right] = ACTIONS(1),
    [sym_semicolon] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_tilde] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_xor] = ACTIONS(1),
    [sym_plus_equal] = ACTIONS(1),
    [sym_minus_equal] = ACTIONS(1),
    [sym_times_equal] = ACTIONS(1),
    [sym_division_equal] = ACTIONS(1),
    [sym_modulo_equal] = ACTIONS(1),
    [sym_and_equal] = ACTIONS(1),
    [sym_or_equal] = ACTIONS(1),
    [sym_xor_equal] = ACTIONS(1),
    [sym_shift_left_equal] = ACTIONS(1),
    [anon_sym_asm] = ACTIONS(1),
    [anon_sym_bf16] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_f16] = ACTIONS(1),
    [anon_sym_f64] = ACTIONS(1),
    [anon_sym_handle] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_mat] = ACTIONS(1),
    [anon_sym_premerge] = ACTIONS(1),
    [anon_sym_regardless] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_unless] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_vec] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [1] = {
    [sym_translation_unit] = STATE(416),
    [sym_global_directive] = STATE(177),
    [sym_attribute] = STATE(73),
    [sym_struct_decl] = STATE(193),
    [sym_type_alias_decl] = STATE(413),
    [sym_variable_decl] = STATE(279),
    [sym_global_variable_decl] = STATE(413),
    [sym_global_constant_decl] = STATE(413),
    [sym_function_decl] = STATE(193),
    [sym_function_header] = STATE(282),
    [sym_enable_directive] = STATE(172),
    [sym__comment] = STATE(1),
    [aux_sym_translation_unit_repeat1] = STATE(102),
    [aux_sym_translation_unit_repeat2] = STATE(135),
    [aux_sym_struct_member_repeat1] = STATE(181),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_struct] = ACTIONS(9),
    [sym_enable] = ACTIONS(11),
    [sym_fn] = ACTIONS(13),
    [sym_let] = ACTIONS(15),
    [sym_type] = ACTIONS(17),
    [sym_var] = ACTIONS(19),
    [sym_attr] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(317),
    [sym__comment] = STATE(2),
    [aux_sym_argument_expression_list_repeat1] = STATE(6),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(59),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(294),
    [sym__comment] = STATE(3),
    [aux_sym_argument_expression_list_repeat1] = STATE(5),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(61),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(288),
    [sym__comment] = STATE(4),
    [aux_sym_argument_expression_list_repeat1] = STATE(9),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(63),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(293),
    [sym__comment] = STATE(5),
    [aux_sym_argument_expression_list_repeat1] = STATE(7),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(285),
    [sym__comment] = STATE(6),
    [aux_sym_argument_expression_list_repeat1] = STATE(7),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(369),
    [sym__comment] = STATE(7),
    [aux_sym_argument_expression_list_repeat1] = STATE(7),
    [sym_ident] = ACTIONS(65),
    [sym_decimal_float_literal] = ACTIONS(68),
    [sym_hex_float_literal] = ACTIONS(68),
    [sym_int_literal] = ACTIONS(71),
    [sym_uint_literal] = ACTIONS(74),
    [sym_array] = ACTIONS(77),
    [sym_atomic] = ACTIONS(80),
    [sym_bool] = ACTIONS(83),
    [sym_float32] = ACTIONS(83),
    [sym_int32] = ACTIONS(83),
    [sym_mat2x2] = ACTIONS(80),
    [sym_mat2x3] = ACTIONS(80),
    [sym_mat2x4] = ACTIONS(80),
    [sym_mat3x2] = ACTIONS(80),
    [sym_mat3x3] = ACTIONS(80),
    [sym_mat3x4] = ACTIONS(80),
    [sym_mat4x2] = ACTIONS(80),
    [sym_mat4x3] = ACTIONS(80),
    [sym_mat4x4] = ACTIONS(80),
    [sym_pointer] = ACTIONS(86),
    [sym_sampler] = ACTIONS(89),
    [sym_sampler_comparison] = ACTIONS(89),
    [sym_texture_1d] = ACTIONS(92),
    [sym_texture_2d] = ACTIONS(92),
    [sym_texture_2d_array] = ACTIONS(92),
    [sym_texture_3d] = ACTIONS(92),
    [sym_texture_cube] = ACTIONS(92),
    [sym_texture_cube_array] = ACTIONS(92),
    [sym_texture_multisampled_2d] = ACTIONS(95),
    [sym_texture_storage_1d] = ACTIONS(98),
    [sym_texture_storage_2d] = ACTIONS(98),
    [sym_texture_storage_2d_array] = ACTIONS(98),
    [sym_texture_storage_3d] = ACTIONS(98),
    [sym_texture_depth_2d] = ACTIONS(101),
    [sym_texture_depth_2d_array] = ACTIONS(101),
    [sym_texture_depth_cube] = ACTIONS(101),
    [sym_texture_depth_cube_array] = ACTIONS(101),
    [sym_texture_depth_multisampled_2d] = ACTIONS(101),
    [sym_uint32] = ACTIONS(83),
    [sym_vec2] = ACTIONS(80),
    [sym_vec3] = ACTIONS(80),
    [sym_vec4] = ACTIONS(80),
    [sym_bitcast] = ACTIONS(104),
    [sym_false] = ACTIONS(71),
    [sym_true] = ACTIONS(71),
    [sym_and] = ACTIONS(107),
    [sym_bang] = ACTIONS(107),
    [sym_minus] = ACTIONS(110),
    [sym_paren_left] = ACTIONS(113),
    [sym_star] = ACTIONS(107),
    [sym_tilde] = ACTIONS(107),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(360),
    [sym__comment] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(116),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(286),
    [sym__comment] = STATE(9),
    [aux_sym_argument_expression_list_repeat1] = STATE(7),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(366),
    [sym__comment] = STATE(10),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(118),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(389),
    [sym__comment] = STATE(11),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(120),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(403),
    [sym__comment] = STATE(12),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(373),
    [sym__comment] = STATE(13),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(395),
    [sym__comment] = STATE(14),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(393),
    [sym__comment] = STATE(15),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(319),
    [sym__comment] = STATE(16),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(354),
    [sym__comment] = STATE(17),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(405),
    [sym__comment] = STATE(18),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(338),
    [sym__comment] = STATE(19),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(224),
    [sym_short_circuit_and_expression] = STATE(348),
    [sym_short_circuit_or_expression] = STATE(350),
    [sym_binary_or_expression] = STATE(353),
    [sym_binary_and_expression] = STATE(355),
    [sym_binary_xor_expression] = STATE(359),
    [sym_expression] = STATE(337),
    [sym__comment] = STATE(20),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(126),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(165),
    [sym_relational_expression] = STATE(230),
    [sym__comment] = STATE(21),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(126),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(142),
    [sym_additive_expression] = STATE(157),
    [sym_shift_expression] = STATE(169),
    [sym_relational_expression] = STATE(229),
    [sym__comment] = STATE(22),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(161),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(168),
    [sym_additive_expression] = STATE(183),
    [sym_shift_expression] = STATE(221),
    [sym__comment] = STATE(23),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(166),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(168),
    [sym_additive_expression] = STATE(183),
    [sym_shift_expression] = STATE(221),
    [sym__comment] = STATE(24),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_const_literal] = STATE(131),
    [sym_float_literal] = STATE(134),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(297),
    [sym_primary_expression] = STATE(113),
    [sym_paren_expression] = STATE(131),
    [sym_unary_expression] = STATE(148),
    [sym_singular_expression] = STATE(140),
    [sym_multiplicative_expression] = STATE(144),
    [sym__comment] = STATE(25),
    [sym_ident] = ACTIONS(122),
    [sym_decimal_float_literal] = ACTIONS(124),
    [sym_hex_float_literal] = ACTIONS(124),
    [sym_int_literal] = ACTIONS(126),
    [sym_uint_literal] = ACTIONS(128),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(130),
    [sym_false] = ACTIONS(126),
    [sym_true] = ACTIONS(126),
    [sym_and] = ACTIONS(132),
    [sym_bang] = ACTIONS(132),
    [sym_minus] = ACTIONS(134),
    [sym_paren_left] = ACTIONS(136),
    [sym_star] = ACTIONS(132),
    [sym_tilde] = ACTIONS(132),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(148),
    [sym_singular_expression] = STATE(101),
    [sym_multiplicative_expression] = STATE(167),
    [sym__comment] = STATE(26),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(170),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(228),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(27),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(138),
    [sym_bang] = ACTIONS(138),
    [sym_minus] = ACTIONS(140),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(138),
    [sym_tilde] = ACTIONS(138),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_const_literal] = STATE(131),
    [sym_float_literal] = STATE(134),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(297),
    [sym_primary_expression] = STATE(113),
    [sym_paren_expression] = STATE(131),
    [sym_unary_expression] = STATE(141),
    [sym_singular_expression] = STATE(140),
    [sym__comment] = STATE(28),
    [sym_ident] = ACTIONS(122),
    [sym_decimal_float_literal] = ACTIONS(124),
    [sym_hex_float_literal] = ACTIONS(124),
    [sym_int_literal] = ACTIONS(126),
    [sym_uint_literal] = ACTIONS(128),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(130),
    [sym_false] = ACTIONS(126),
    [sym_true] = ACTIONS(126),
    [sym_and] = ACTIONS(132),
    [sym_bang] = ACTIONS(132),
    [sym_minus] = ACTIONS(134),
    [sym_paren_left] = ACTIONS(136),
    [sym_star] = ACTIONS(132),
    [sym_tilde] = ACTIONS(132),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(170),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(227),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(29),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(138),
    [sym_bang] = ACTIONS(138),
    [sym_minus] = ACTIONS(140),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(138),
    [sym_tilde] = ACTIONS(138),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(163),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(30),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(139),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(31),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(170),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(163),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(32),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(138),
    [sym_bang] = ACTIONS(138),
    [sym_minus] = ACTIONS(140),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(138),
    [sym_tilde] = ACTIONS(138),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_const_literal] = STATE(131),
    [sym_float_literal] = STATE(134),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(297),
    [sym_primary_expression] = STATE(113),
    [sym_paren_expression] = STATE(131),
    [sym_unary_expression] = STATE(139),
    [sym_singular_expression] = STATE(140),
    [sym__comment] = STATE(33),
    [sym_ident] = ACTIONS(122),
    [sym_decimal_float_literal] = ACTIONS(124),
    [sym_hex_float_literal] = ACTIONS(124),
    [sym_int_literal] = ACTIONS(126),
    [sym_uint_literal] = ACTIONS(128),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(130),
    [sym_false] = ACTIONS(126),
    [sym_true] = ACTIONS(126),
    [sym_and] = ACTIONS(132),
    [sym_bang] = ACTIONS(132),
    [sym_minus] = ACTIONS(134),
    [sym_paren_left] = ACTIONS(136),
    [sym_star] = ACTIONS(132),
    [sym_tilde] = ACTIONS(132),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_const_literal] = STATE(131),
    [sym_float_literal] = STATE(134),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(297),
    [sym_primary_expression] = STATE(113),
    [sym_paren_expression] = STATE(131),
    [sym_unary_expression] = STATE(163),
    [sym_singular_expression] = STATE(140),
    [sym__comment] = STATE(34),
    [sym_ident] = ACTIONS(122),
    [sym_decimal_float_literal] = ACTIONS(124),
    [sym_hex_float_literal] = ACTIONS(124),
    [sym_int_literal] = ACTIONS(126),
    [sym_uint_literal] = ACTIONS(128),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(130),
    [sym_false] = ACTIONS(126),
    [sym_true] = ACTIONS(126),
    [sym_and] = ACTIONS(132),
    [sym_bang] = ACTIONS(132),
    [sym_minus] = ACTIONS(134),
    [sym_paren_left] = ACTIONS(136),
    [sym_star] = ACTIONS(132),
    [sym_tilde] = ACTIONS(132),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_const_literal] = STATE(210),
    [sym_float_literal] = STATE(211),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(291),
    [sym_primary_expression] = STATE(192),
    [sym_paren_expression] = STATE(210),
    [sym_unary_expression] = STATE(235),
    [sym_singular_expression] = STATE(237),
    [sym__comment] = STATE(35),
    [sym_ident] = ACTIONS(142),
    [sym_decimal_float_literal] = ACTIONS(144),
    [sym_hex_float_literal] = ACTIONS(144),
    [sym_int_literal] = ACTIONS(146),
    [sym_uint_literal] = ACTIONS(148),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(150),
    [sym_false] = ACTIONS(146),
    [sym_true] = ACTIONS(146),
    [sym_and] = ACTIONS(152),
    [sym_bang] = ACTIONS(152),
    [sym_minus] = ACTIONS(154),
    [sym_paren_left] = ACTIONS(156),
    [sym_star] = ACTIONS(152),
    [sym_tilde] = ACTIONS(152),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(170),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(105),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(36),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(138),
    [sym_bang] = ACTIONS(138),
    [sym_minus] = ACTIONS(140),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(138),
    [sym_tilde] = ACTIONS(138),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_const_literal] = STATE(92),
    [sym_float_literal] = STATE(89),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(318),
    [sym_primary_expression] = STATE(85),
    [sym_paren_expression] = STATE(92),
    [sym_unary_expression] = STATE(105),
    [sym_singular_expression] = STATE(101),
    [sym__comment] = STATE(37),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_const_literal] = STATE(210),
    [sym_float_literal] = STATE(211),
    [sym_array_type_decl] = STATE(214),
    [sym_texture_sampler_types] = STATE(214),
    [sym_sampler_type] = STATE(219),
    [sym_sampled_texture_type] = STATE(334),
    [sym_multisampled_texture_type] = STATE(334),
    [sym_storage_texture_type] = STATE(333),
    [sym_depth_texture_type] = STATE(219),
    [sym_type_decl] = STATE(291),
    [sym_primary_expression] = STATE(192),
    [sym_paren_expression] = STATE(210),
    [sym_unary_expression] = STATE(226),
    [sym_singular_expression] = STATE(237),
    [sym__comment] = STATE(38),
    [sym_ident] = ACTIONS(142),
    [sym_decimal_float_literal] = ACTIONS(144),
    [sym_hex_float_literal] = ACTIONS(144),
    [sym_int_literal] = ACTIONS(146),
    [sym_uint_literal] = ACTIONS(148),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(150),
    [sym_false] = ACTIONS(146),
    [sym_true] = ACTIONS(146),
    [sym_and] = ACTIONS(152),
    [sym_bang] = ACTIONS(152),
    [sym_minus] = ACTIONS(154),
    [sym_paren_left] = ACTIONS(156),
    [sym_star] = ACTIONS(152),
    [sym_tilde] = ACTIONS(152),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 25,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(158), 1,
      sym_paren_right,
    STATE(39), 1,
      sym__comment,
    STATE(40), 1,
      aux_sym_const_expression_repeat1,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(300), 1,
      sym_const_expression,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [112] = 24,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(40), 1,
      sym__comment,
    STATE(41), 1,
      aux_sym_const_expression_repeat1,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(299), 1,
      sym_const_expression,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [221] = 23,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(169), 1,
      sym_uint_literal,
    ACTIONS(172), 1,
      sym_array,
    ACTIONS(178), 1,
      sym_pointer,
    ACTIONS(187), 1,
      sym_texture_multisampled_2d,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(400), 1,
      sym_const_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(163), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(181), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(41), 2,
      sym__comment,
      aux_sym_const_expression_repeat1,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(166), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(190), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(160), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(193), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(184), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(175), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [328] = 24,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(196), 1,
      sym_ident,
    STATE(42), 1,
      sym__comment,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(330), 1,
      sym_const_expression,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(37), 4,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [436] = 24,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(198), 1,
      sym_ident,
    STATE(43), 1,
      sym__comment,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(390), 1,
      sym_const_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(37), 4,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [544] = 24,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(200), 1,
      sym_ident,
    STATE(44), 1,
      sym__comment,
    STATE(89), 1,
      sym_float_literal,
    STATE(254), 1,
      sym_const_literal,
    STATE(332), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(380), 1,
      sym_const_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(37), 4,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [652] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(206), 1,
      sym_paren_right,
    STATE(45), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [721] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(208), 1,
      sym_paren_right,
    STATE(46), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [790] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(210), 1,
      sym_paren_right,
    STATE(47), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [859] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(212), 1,
      sym_paren_right,
    STATE(48), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [928] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      sym_paren_right,
    STATE(49), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [997] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(216), 1,
      sym_paren_right,
    STATE(50), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1066] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(51), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(204), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(202), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1132] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(52), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(220), 8,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(218), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1198] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(53), 1,
      sym__comment,
    STATE(54), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(356), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1292] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(54), 1,
      sym__comment,
    STATE(68), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(408), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1386] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(55), 1,
      sym__comment,
    STATE(68), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(325), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1480] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(55), 1,
      aux_sym_struct_member_repeat1,
    STATE(56), 1,
      sym__comment,
    STATE(73), 1,
      sym_attribute,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(408), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1574] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(57), 1,
      sym__comment,
    STATE(290), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1659] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(58), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(365), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1744] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(59), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(414), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1829] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(60), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(419), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1914] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(61), 1,
      sym__comment,
    STATE(248), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1999] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(62), 1,
      sym__comment,
    STATE(298), 1,
      sym_type_decl,
    STATE(333), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2084] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(63), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(415), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2169] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(64), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(386), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2254] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(65), 1,
      sym__comment,
    STATE(333), 1,
      sym_storage_texture_type,
    STATE(383), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(214), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(219), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(334), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2339] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(226), 1,
      sym_paren_right,
    STATE(66), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(224), 3,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
    ACTIONS(222), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2401] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(228), 1,
      sym_paren_right,
    STATE(67), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(224), 3,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
    ACTIONS(222), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2463] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(232), 1,
      sym_attr,
    STATE(73), 1,
      sym_attribute,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(68), 2,
      sym__comment,
      aux_sym_struct_member_repeat1,
    ACTIONS(230), 41,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2524] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(69), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(224), 3,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
    ACTIONS(222), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2583] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(237), 1,
      sym_attr,
    ACTIONS(239), 1,
      sym_paren_left,
    STATE(70), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(235), 41,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2643] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(243), 1,
      sym_attr,
    STATE(71), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(241), 41,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2700] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(247), 1,
      sym_attr,
    STATE(72), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(245), 41,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2757] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(251), 1,
      sym_attr,
    STATE(73), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(249), 41,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2814] = 30,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(259), 1,
      sym_continuing,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(281), 1,
      sym_brace_right,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    STATE(74), 1,
      sym__comment,
    STATE(77), 1,
      aux_sym_compound_statement_repeat1,
    STATE(132), 1,
      sym_statement,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(417), 1,
      sym_continuing_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [2918] = 30,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(259), 1,
      sym_continuing,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(289), 1,
      sym_brace_right,
    STATE(74), 1,
      aux_sym_compound_statement_repeat1,
    STATE(75), 1,
      sym__comment,
    STATE(132), 1,
      sym_statement,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(367), 1,
      sym_continuing_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3022] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(291), 1,
      sym_fallthrough,
    ACTIONS(293), 1,
      sym_brace_right,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(343), 1,
      sym_case_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(76), 2,
      sym_statement,
      sym__comment,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3121] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(295), 1,
      sym_ident,
    ACTIONS(298), 1,
      sym_break,
    ACTIONS(301), 1,
      sym_continue,
    ACTIONS(304), 1,
      sym_continuing,
    ACTIONS(306), 1,
      sym_discard,
    ACTIONS(309), 1,
      sym_for,
    ACTIONS(312), 1,
      sym_if,
    ACTIONS(315), 1,
      sym_let,
    ACTIONS(318), 1,
      sym_loop,
    ACTIONS(321), 1,
      sym_return,
    ACTIONS(324), 1,
      sym_switch,
    ACTIONS(327), 1,
      sym_var,
    ACTIONS(333), 1,
      sym_brace_left,
    ACTIONS(336), 1,
      sym_brace_right,
    ACTIONS(338), 1,
      sym_paren_left,
    ACTIONS(341), 1,
      sym_semicolon,
    ACTIONS(344), 1,
      sym_underscore,
    STATE(132), 1,
      sym_statement,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(330), 2,
      sym_and,
      sym_star,
    STATE(77), 2,
      sym__comment,
      aux_sym_compound_statement_repeat1,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3220] = 29,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(291), 1,
      sym_fallthrough,
    ACTIONS(347), 1,
      sym_brace_right,
    STATE(76), 1,
      sym_statement,
    STATE(78), 1,
      sym__comment,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(340), 1,
      sym_case_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3321] = 29,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(291), 1,
      sym_fallthrough,
    ACTIONS(349), 1,
      sym_brace_right,
    STATE(76), 1,
      sym_statement,
    STATE(79), 1,
      sym__comment,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(342), 1,
      sym_case_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3422] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(351), 1,
      sym_brace_right,
    STATE(80), 1,
      sym__comment,
    STATE(81), 1,
      aux_sym_compound_statement_repeat1,
    STATE(132), 1,
      sym_statement,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3520] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(255), 1,
      sym_break,
    ACTIONS(257), 1,
      sym_continue,
    ACTIONS(261), 1,
      sym_discard,
    ACTIONS(263), 1,
      sym_for,
    ACTIONS(265), 1,
      sym_if,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(269), 1,
      sym_loop,
    ACTIONS(271), 1,
      sym_return,
    ACTIONS(273), 1,
      sym_switch,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(285), 1,
      sym_semicolon,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(353), 1,
      sym_brace_right,
    STATE(77), 1,
      aux_sym_compound_statement_repeat1,
    STATE(81), 1,
      sym__comment,
    STATE(132), 1,
      sym_statement,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(115), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(376), 8,
      sym_variable_statement,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3618] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(82), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(355), 8,
      ts_builtin_sym_end,
      sym_and,
      sym_attr,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(357), 18,
      sym_struct,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_else,
      sym_fallthrough,
      sym_fn,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_type,
      sym_var,
      sym_underscore,
      sym_ident,
  [3659] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(83), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(359), 8,
      ts_builtin_sym_end,
      sym_and,
      sym_attr,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(361), 18,
      sym_struct,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_else,
      sym_fallthrough,
      sym_fn,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_type,
      sym_var,
      sym_underscore,
      sym_ident,
  [3700] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(367), 1,
      sym_paren_left,
    STATE(84), 1,
      sym__comment,
    STATE(95), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(363), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(365), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3745] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      sym_bracket_left,
    ACTIONS(376), 1,
      sym_period,
    STATE(85), 1,
      sym__comment,
    STATE(103), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(370), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(372), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3791] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      sym_bracket_left,
    ACTIONS(376), 1,
      sym_period,
    STATE(86), 1,
      sym__comment,
    STATE(106), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(380), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3837] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      sym_bracket_left,
    ACTIONS(376), 1,
      sym_period,
    STATE(87), 1,
      sym__comment,
    STATE(104), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(382), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(384), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3883] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(88), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(386), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(388), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3923] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(89), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(390), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(392), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3963] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(394), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(396), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_brace_left,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4003] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(91), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(398), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(400), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4042] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(363), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(365), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4081] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(402), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(404), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4120] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(94), 1,
      sym__comment,
    STATE(107), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 3,
      sym_and,
      sym_or,
      sym_xor,
    ACTIONS(380), 18,
      sym_bracket_right,
      sym_comma,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [4165] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(95), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(410), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(412), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4204] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(96), 1,
      sym__comment,
    STATE(109), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(382), 3,
      sym_and,
      sym_or,
      sym_xor,
    ACTIONS(384), 18,
      sym_bracket_right,
      sym_comma,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [4249] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(414), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(416), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4288] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(418), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(420), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4327] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(422), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(424), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4366] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(426), 1,
      sym_and,
    ACTIONS(434), 1,
      sym_or,
    ACTIONS(436), 1,
      sym_xor,
    STATE(100), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(432), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(430), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(428), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [4411] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(101), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(438), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(440), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4448] = 22,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(11), 1,
      sym_enable,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(442), 1,
      ts_builtin_sym_end,
    STATE(73), 1,
      sym_attribute,
    STATE(102), 1,
      sym__comment,
    STATE(137), 1,
      aux_sym_translation_unit_repeat2,
    STATE(164), 1,
      aux_sym_translation_unit_repeat1,
    STATE(172), 1,
      sym_enable_directive,
    STATE(177), 1,
      sym_global_directive,
    STATE(181), 1,
      aux_sym_struct_member_repeat1,
    STATE(279), 1,
      sym_variable_decl,
    STATE(282), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(193), 2,
      sym_struct_decl,
      sym_function_decl,
    STATE(413), 3,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [4519] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(103), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(444), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(446), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4556] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(104), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(380), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4593] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(105), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(448), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(450), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4630] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(106), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(452), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(454), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4667] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(107), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(452), 3,
      sym_and,
      sym_or,
      sym_xor,
    ACTIONS(454), 18,
      sym_bracket_right,
      sym_comma,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [4703] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(456), 1,
      sym_paren_left,
    STATE(108), 1,
      sym__comment,
    STATE(129), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(363), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(365), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [4743] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(109), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 3,
      sym_and,
      sym_or,
      sym_xor,
    ACTIONS(380), 18,
      sym_bracket_right,
      sym_comma,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [4779] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(461), 1,
      sym_else,
    STATE(110), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(463), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(459), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [4817] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(111), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(467), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(465), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [4852] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(112), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(471), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(469), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [4887] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      sym_bracket_left,
    ACTIONS(475), 1,
      sym_period,
    STATE(113), 1,
      sym__comment,
    STATE(146), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(370), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(372), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [4928] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(114), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(479), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(477), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [4963] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(115), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(483), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(481), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [4998] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      sym_bracket_left,
    ACTIONS(475), 1,
      sym_period,
    STATE(116), 1,
      sym__comment,
    STATE(147), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(380), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5039] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(473), 1,
      sym_bracket_left,
    ACTIONS(475), 1,
      sym_period,
    STATE(117), 1,
      sym__comment,
    STATE(143), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(382), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(384), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5080] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(118), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(487), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(485), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5115] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(119), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(491), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(489), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5150] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(120), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(495), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(493), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5185] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(121), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(499), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(497), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5220] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(122), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(503), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(501), 14,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5255] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(123), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(414), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(416), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5289] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(124), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(402), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(404), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5323] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(125), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(398), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(400), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5357] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(126), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(432), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(430), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(428), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5393] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(127), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(394), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(396), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5427] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(128), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(418), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(420), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5461] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(129), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(410), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(412), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5495] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(130), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(422), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(424), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5529] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(131), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(363), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(365), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5563] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(132), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(507), 6,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
    ACTIONS(505), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_underscore,
      sym_ident,
  [5597] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(133), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(386), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(388), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5631] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(134), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(390), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(392), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5665] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(442), 1,
      ts_builtin_sym_end,
    STATE(73), 1,
      sym_attribute,
    STATE(135), 1,
      sym__comment,
    STATE(136), 1,
      aux_sym_translation_unit_repeat2,
    STATE(181), 1,
      aux_sym_struct_member_repeat1,
    STATE(279), 1,
      sym_variable_decl,
    STATE(282), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(193), 2,
      sym_struct_decl,
      sym_function_decl,
    STATE(413), 3,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5724] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(509), 1,
      ts_builtin_sym_end,
    ACTIONS(511), 1,
      sym_struct,
    ACTIONS(514), 1,
      sym_fn,
    ACTIONS(517), 1,
      sym_let,
    ACTIONS(520), 1,
      sym_type,
    ACTIONS(523), 1,
      sym_var,
    ACTIONS(526), 1,
      sym_attr,
    ACTIONS(529), 1,
      sym_semicolon,
    STATE(73), 1,
      sym_attribute,
    STATE(181), 1,
      aux_sym_struct_member_repeat1,
    STATE(279), 1,
      sym_variable_decl,
    STATE(282), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(136), 2,
      sym__comment,
      aux_sym_translation_unit_repeat2,
    STATE(193), 2,
      sym_struct_decl,
      sym_function_decl,
    STATE(413), 3,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5781] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(532), 1,
      ts_builtin_sym_end,
    STATE(73), 1,
      sym_attribute,
    STATE(136), 1,
      aux_sym_translation_unit_repeat2,
    STATE(137), 1,
      sym__comment,
    STATE(181), 1,
      aux_sym_struct_member_repeat1,
    STATE(279), 1,
      sym_variable_decl,
    STATE(282), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(193), 2,
      sym_struct_decl,
      sym_function_decl,
    STATE(413), 3,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5840] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(138), 1,
      sym__comment,
    STATE(381), 1,
      sym_texel_format,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(534), 16,
      anon_sym_rgba8unorm,
      anon_sym_rgba8snorm,
      anon_sym_rgba8uint,
      anon_sym_rgba8sint,
      anon_sym_rgba16uint,
      anon_sym_rgba16sint,
      anon_sym_rgba16float,
      anon_sym_r32uint,
      anon_sym_r32sint,
      anon_sym_r32float,
      anon_sym_rg32uint,
      anon_sym_rg32sint,
      anon_sym_rg32float,
      anon_sym_rgba32uint,
      anon_sym_rgba32sint,
      anon_sym_rgba32float,
  [5872] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(139), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(538), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(536), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5904] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(140), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(438), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(440), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5936] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(141), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(448), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(450), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5968] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(542), 1,
      sym_forward_slash,
    STATE(142), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(544), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(546), 2,
      sym_modulo,
      sym_star,
    ACTIONS(540), 12,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6004] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(143), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(378), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(380), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6036] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(542), 1,
      sym_forward_slash,
    STATE(144), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(546), 2,
      sym_modulo,
      sym_star,
    ACTIONS(550), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(548), 12,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6072] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(145), 1,
      sym__comment,
    STATE(156), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(552), 14,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6108] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(146), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(444), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(446), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6140] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(147), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(452), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(454), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6172] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(148), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(430), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(428), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6204] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(149), 1,
      sym__comment,
    STATE(159), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(554), 14,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6240] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(253), 1,
      sym_ident,
    ACTIONS(267), 1,
      sym_let,
    ACTIONS(275), 1,
      sym_var,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(556), 1,
      sym_semicolon,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(150), 1,
      sym__comment,
    STATE(162), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(295), 1,
      sym_variable_decl,
    STATE(374), 1,
      sym_for_init,
    STATE(375), 1,
      sym_for_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(326), 3,
      sym_variable_statement,
      sym_assignment_statement,
      sym_func_call_statement,
  [6296] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(560), 1,
      sym_paren_left,
    STATE(151), 1,
      sym__comment,
    STATE(310), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(558), 15,
      sym_bracket_left,
      sym_equal,
      sym_minus_minus,
      sym_period,
      sym_plus_plus,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6330] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(152), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(558), 16,
      sym_bracket_left,
      sym_equal,
      sym_minus_minus,
      sym_period,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6359] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(153), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(562), 16,
      sym_bracket_left,
      sym_equal,
      sym_minus_minus,
      sym_period,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6388] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(564), 1,
      sym_ident,
    ACTIONS(566), 1,
      sym_paren_right,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(154), 1,
      sym__comment,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(327), 1,
      sym_for_update,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(398), 4,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_func_call_statement,
  [6433] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(568), 1,
      sym_equal,
    ACTIONS(570), 1,
      sym_minus_minus,
    ACTIONS(572), 1,
      sym_plus_plus,
    STATE(16), 1,
      sym_compound_assignment_operator,
    STATE(155), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(574), 10,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6468] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(156), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(554), 14,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6495] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(157), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(578), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(580), 2,
      sym_minus,
      sym_plus,
    ACTIONS(576), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6526] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(564), 1,
      sym_ident,
    ACTIONS(582), 1,
      sym_paren_right,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(158), 1,
      sym__comment,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(397), 1,
      sym_for_update,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(398), 4,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_func_call_statement,
  [6571] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(159), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(584), 14,
      sym_equal,
      sym_minus_minus,
      sym_plus_plus,
      sym_paren_right,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6598] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(287), 1,
      sym_underscore,
    ACTIONS(564), 1,
      sym_ident,
    ACTIONS(586), 1,
      sym_paren_right,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(155), 1,
      sym_lhs_expression,
    STATE(160), 1,
      sym__comment,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(336), 1,
      sym_for_update,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
    STATE(398), 4,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
      sym_func_call_statement,
  [6643] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(430), 1,
      sym_forward_slash,
    STATE(161), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(588), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(428), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6673] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(568), 1,
      sym_equal,
    STATE(16), 1,
      sym_compound_assignment_operator,
    STATE(162), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(574), 10,
      sym_plus_equal,
      sym_minus_equal,
      sym_times_equal,
      sym_division_equal,
      sym_modulo_equal,
      sym_and_equal,
      sym_or_equal,
      sym_xor_equal,
      sym_shift_right_equal,
      sym_shift_left_equal,
  [6702] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(163), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(592), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(590), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6729] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(596), 1,
      sym_enable,
    STATE(172), 1,
      sym_enable_directive,
    STATE(177), 1,
      sym_global_directive,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(164), 2,
      sym__comment,
      aux_sym_translation_unit_repeat1,
    ACTIONS(594), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [6760] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(165), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(603), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(601), 4,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
    ACTIONS(599), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6789] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(430), 1,
      sym_forward_slash,
    STATE(166), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(605), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(428), 9,
      sym_bracket_right,
      sym_comma,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6818] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(607), 1,
      sym_forward_slash,
    STATE(167), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(609), 2,
      sym_modulo,
      sym_star,
    ACTIONS(548), 8,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6846] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(607), 1,
      sym_forward_slash,
    STATE(168), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(609), 2,
      sym_modulo,
      sym_star,
    ACTIONS(540), 8,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6874] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(169), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(613), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(611), 4,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
    ACTIONS(599), 5,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6902] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(370), 1,
      sym_or,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(103), 1,
      sym_postfix_expression,
    STATE(170), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(372), 6,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [6933] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(615), 1,
      sym_colon,
    STATE(89), 1,
      sym_float_literal,
    STATE(171), 1,
      sym__comment,
    STATE(320), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [6965] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(172), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(617), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [6987] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    ACTIONS(621), 1,
      sym_paren_right,
    STATE(73), 1,
      sym_attribute,
    STATE(173), 1,
      sym__comment,
    STATE(200), 1,
      aux_sym_param_list_repeat1,
    STATE(233), 1,
      aux_sym_struct_member_repeat1,
    STATE(274), 1,
      sym_param,
    STATE(280), 1,
      sym_variable_ident_decl,
    STATE(420), 1,
      sym_param_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7025] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(623), 1,
      sym_paren_left,
    STATE(174), 1,
      sym__comment,
    STATE(206), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(365), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7051] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(175), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(626), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7073] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(628), 1,
      sym_colon,
    STATE(89), 1,
      sym_float_literal,
    STATE(176), 1,
      sym__comment,
    STATE(320), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [7105] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(177), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7127] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(89), 1,
      sym_float_literal,
    STATE(178), 1,
      sym__comment,
    STATE(258), 1,
      sym_const_literal,
    STATE(379), 1,
      sym_case_selectors,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [7159] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(179), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(632), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7180] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(636), 1,
      sym_int_literal,
    STATE(180), 1,
      sym__comment,
    STATE(185), 1,
      aux_sym_attribute_repeat1,
    STATE(321), 1,
      sym_literal_or_ident,
    STATE(322), 1,
      sym_float_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(634), 2,
      sym_uint_literal,
      sym_ident,
  [7211] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(638), 1,
      sym_let,
    STATE(68), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(181), 1,
      sym__comment,
    STATE(312), 1,
      sym_variable_decl,
    STATE(313), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7246] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(182), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(640), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7267] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(183), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(642), 2,
      sym_minus,
      sym_plus,
    ACTIONS(576), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [7290] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(184), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(644), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7311] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(636), 1,
      sym_int_literal,
    STATE(185), 1,
      sym__comment,
    STATE(187), 1,
      aux_sym_attribute_repeat1,
    STATE(296), 1,
      sym_literal_or_ident,
    STATE(322), 1,
      sym_float_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(634), 2,
      sym_uint_literal,
      sym_ident,
  [7342] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(89), 1,
      sym_float_literal,
    STATE(186), 1,
      sym__comment,
    STATE(320), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [7371] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(652), 1,
      sym_int_literal,
    STATE(322), 1,
      sym_float_literal,
    STATE(370), 1,
      sym_literal_or_ident,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(646), 2,
      sym_uint_literal,
      sym_ident,
    ACTIONS(649), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    STATE(187), 2,
      sym__comment,
      aux_sym_attribute_repeat1,
  [7400] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(188), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(509), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7421] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(189), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(655), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7442] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    ACTIONS(657), 1,
      sym_brace_right,
    STATE(73), 1,
      sym_attribute,
    STATE(190), 1,
      sym__comment,
    STATE(194), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(231), 1,
      aux_sym_struct_member_repeat1,
    STATE(259), 1,
      sym_struct_member,
    STATE(412), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7477] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(191), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(659), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7498] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      sym_bracket_left,
    ACTIONS(408), 1,
      sym_period,
    STATE(192), 1,
      sym__comment,
    STATE(232), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(372), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [7525] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(193), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(661), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr,
      sym_semicolon,
  [7546] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    ACTIONS(663), 1,
      sym_brace_right,
    STATE(73), 1,
      sym_attribute,
    STATE(194), 1,
      sym__comment,
    STATE(195), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(231), 1,
      aux_sym_struct_member_repeat1,
    STATE(259), 1,
      sym_struct_member,
    STATE(412), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7581] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(665), 1,
      sym_ident,
    ACTIONS(668), 1,
      sym_attr,
    ACTIONS(671), 1,
      sym_brace_right,
    STATE(73), 1,
      sym_attribute,
    STATE(231), 1,
      aux_sym_struct_member_repeat1,
    STATE(259), 1,
      sym_struct_member,
    STATE(412), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(195), 2,
      sym__comment,
      aux_sym_struct_body_decl_repeat1,
  [7614] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(196), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(673), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7634] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(197), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(675), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7654] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(198), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(404), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7674] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(680), 1,
      sym_attr,
    STATE(73), 1,
      sym_attribute,
    STATE(233), 1,
      aux_sym_struct_member_repeat1,
    STATE(280), 1,
      sym_variable_ident_decl,
    STATE(363), 1,
      sym_param,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(199), 2,
      sym__comment,
      aux_sym_param_list_repeat1,
  [7704] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    STATE(73), 1,
      sym_attribute,
    STATE(199), 1,
      aux_sym_param_list_repeat1,
    STATE(200), 1,
      sym__comment,
    STATE(233), 1,
      aux_sym_struct_member_repeat1,
    STATE(280), 1,
      sym_variable_ident_decl,
    STATE(283), 1,
      sym_param,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7736] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(201), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(400), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7756] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(202), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(396), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7776] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(683), 1,
      sym_ident,
    STATE(145), 1,
      sym_core_lhs_expression,
    STATE(203), 1,
      sym__comment,
    STATE(223), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(362), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
  [7806] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(204), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(420), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7826] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(205), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(685), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7846] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(206), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(412), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7866] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(207), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(687), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7886] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(208), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(689), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7906] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(209), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(691), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7926] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(210), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(365), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7946] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(211), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(392), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7966] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(212), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(388), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7986] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(213), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(424), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [8006] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(214), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(693), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [8026] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(215), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(695), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [8046] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(216), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(697), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [8066] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(217), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(699), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [8086] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(218), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(416), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [8106] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(219), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(701), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [8126] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(220), 1,
      sym__comment,
    STATE(384), 1,
      sym_storage_class,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(703), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [8147] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(221), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(705), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [8166] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(222), 1,
      sym__comment,
    STATE(315), 1,
      sym_storage_class,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(703), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [8187] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(283), 1,
      sym_paren_left,
    ACTIONS(683), 1,
      sym_ident,
    STATE(149), 1,
      sym_core_lhs_expression,
    STATE(223), 1,
      sym__comment,
    STATE(225), 1,
      aux_sym_lhs_expression_repeat1,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(277), 2,
      sym_and,
      sym_star,
  [8214] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(707), 1,
      sym_and_and,
    ACTIONS(711), 1,
      sym_or_or,
    STATE(224), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(709), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8237] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 2,
      sym_paren_left,
      sym_ident,
    ACTIONS(715), 2,
      sym_and,
      sym_star,
    STATE(225), 2,
      sym__comment,
      aux_sym_lhs_expression_repeat1,
  [8257] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(718), 1,
      sym_and,
    STATE(226), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(720), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8277] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(722), 1,
      sym_xor,
    STATE(227), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(720), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8297] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(724), 1,
      sym_or,
    STATE(228), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(720), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8317] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(726), 1,
      sym_or_or,
    STATE(229), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(720), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8337] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(728), 1,
      sym_and_and,
    STATE(230), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(720), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8357] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    STATE(68), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(231), 1,
      sym__comment,
    STATE(388), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8383] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(232), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(446), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8401] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr,
    ACTIONS(619), 1,
      sym_ident,
    STATE(68), 1,
      aux_sym_struct_member_repeat1,
    STATE(73), 1,
      sym_attribute,
    STATE(233), 1,
      sym__comment,
    STATE(278), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8427] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(732), 1,
      sym_int_literal,
    STATE(234), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(730), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_ident,
  [8447] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(235), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(450), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8465] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(734), 1,
      sym_case,
    ACTIONS(736), 1,
      sym_default,
    ACTIONS(738), 1,
      sym_brace_right,
    STATE(236), 1,
      sym__comment,
    STATE(238), 1,
      aux_sym_switch_statement_repeat1,
    STATE(257), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8491] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(237), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(440), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8509] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(740), 1,
      sym_case,
    ACTIONS(743), 1,
      sym_default,
    ACTIONS(746), 1,
      sym_brace_right,
    STATE(257), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(238), 2,
      sym__comment,
      aux_sym_switch_statement_repeat1,
  [8533] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    ACTIONS(748), 1,
      sym_if,
    STATE(111), 1,
      sym_else_statement,
    STATE(239), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(119), 2,
      sym_compound_statement,
      sym_if_statement,
  [8557] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    ACTIONS(752), 1,
      sym_equal,
    ACTIONS(754), 1,
      sym_semicolon,
    STATE(240), 1,
      sym__comment,
    STATE(377), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8580] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(758), 1,
      sym_int_literal,
    STATE(241), 1,
      sym__comment,
    STATE(404), 1,
      sym_element_count_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(756), 2,
      sym_uint_literal,
      sym_ident,
  [8601] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(760), 1,
      anon_sym_read,
    STATE(242), 1,
      sym__comment,
    STATE(335), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(762), 2,
      anon_sym_write,
      anon_sym_read_write,
  [8622] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(734), 1,
      sym_case,
    ACTIONS(736), 1,
      sym_default,
    STATE(236), 1,
      aux_sym_switch_statement_repeat1,
    STATE(243), 1,
      sym__comment,
    STATE(257), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8645] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(760), 1,
      anon_sym_read,
    STATE(244), 1,
      sym__comment,
    STATE(391), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(762), 2,
      anon_sym_write,
      anon_sym_read_write,
  [8666] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(764), 1,
      sym_ident,
    ACTIONS(766), 1,
      sym_less_than,
    STATE(245), 1,
      sym__comment,
    STATE(302), 1,
      sym_variable_ident_decl,
    STATE(305), 1,
      sym_variable_qualifier,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8689] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(760), 1,
      anon_sym_read,
    STATE(246), 1,
      sym__comment,
    STATE(401), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(762), 2,
      anon_sym_write,
      anon_sym_read_write,
  [8710] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(247), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(768), 4,
      sym_and,
      sym_paren_left,
      sym_star,
      sym_ident,
  [8727] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(248), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(770), 4,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [8744] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    ACTIONS(752), 1,
      sym_equal,
    ACTIONS(772), 1,
      sym_semicolon,
    STATE(249), 1,
      sym__comment,
    STATE(358), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8767] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(250), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(774), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8783] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    STATE(251), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(776), 2,
      sym_equal,
      sym_semicolon,
  [8801] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(252), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(778), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8817] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(253), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(780), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8833] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(254), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(782), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8849] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(255), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(784), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8865] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(256), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(786), 3,
      sym_attr,
      sym_brace_right,
      sym_ident,
  [8881] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(257), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(788), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [8897] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(790), 1,
      sym_colon,
    ACTIONS(792), 1,
      sym_comma,
    STATE(258), 1,
      sym__comment,
    STATE(263), 1,
      aux_sym_case_selectors_repeat1,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8917] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(259), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(794), 3,
      sym_attr,
      sym_brace_right,
      sym_ident,
  [8933] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(798), 1,
      sym_paren_right,
    STATE(260), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(796), 2,
      sym_attr,
      sym_ident,
  [8951] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    STATE(261), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(800), 2,
      sym_equal,
      sym_semicolon,
  [8969] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(262), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(802), 3,
      sym_attr,
      sym_brace_right,
      sym_ident,
  [8985] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(615), 1,
      sym_colon,
    ACTIONS(804), 1,
      sym_comma,
    STATE(263), 1,
      sym__comment,
    STATE(267), 1,
      aux_sym_case_selectors_repeat1,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9005] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(752), 1,
      sym_equal,
    ACTIONS(772), 1,
      sym_semicolon,
    STATE(264), 1,
      sym__comment,
    STATE(358), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9025] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(806), 1,
      sym_paren_right,
    STATE(265), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(796), 2,
      sym_attr,
      sym_ident,
  [9043] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(752), 1,
      sym_equal,
    ACTIONS(754), 1,
      sym_semicolon,
    STATE(266), 1,
      sym__comment,
    STATE(377), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9063] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(808), 1,
      sym_colon,
    ACTIONS(810), 1,
      sym_comma,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(267), 2,
      sym__comment,
      aux_sym_case_selectors_repeat1,
  [9081] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(268), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(813), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9097] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(269), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(815), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9113] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(270), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(817), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9129] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(99), 1,
      sym_paren_expression,
    STATE(271), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9146] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(693), 1,
      sym_paren_left,
    ACTIONS(819), 1,
      sym_semicolon,
    STATE(272), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9163] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    STATE(121), 1,
      sym_compound_statement,
    STATE(273), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9180] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(821), 1,
      sym_comma,
    ACTIONS(823), 1,
      sym_paren_right,
    STATE(274), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9197] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(825), 1,
      sym_ident,
    STATE(264), 1,
      sym_variable_ident_decl,
    STATE(275), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9214] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    STATE(110), 1,
      sym_compound_statement,
    STATE(276), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9231] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(827), 1,
      sym_arrow,
    ACTIONS(829), 1,
      sym_brace_left,
    STATE(277), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9248] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(278), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(831), 2,
      sym_comma,
      sym_paren_right,
  [9263] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(833), 1,
      sym_equal,
    ACTIONS(835), 1,
      sym_semicolon,
    STATE(279), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9280] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(280), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(837), 2,
      sym_comma,
      sym_paren_right,
  [9295] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(839), 1,
      sym_arrow,
    ACTIONS(841), 1,
      sym_brace_left,
    STATE(281), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9312] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    STATE(189), 1,
      sym_compound_statement,
    STATE(282), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9329] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(806), 1,
      sym_paren_right,
    ACTIONS(843), 1,
      sym_comma,
    STATE(283), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9346] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(156), 1,
      sym_paren_left,
    STATE(213), 1,
      sym_paren_expression,
    STATE(284), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9363] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(216), 1,
      sym_paren_right,
    ACTIONS(845), 1,
      sym_comma,
    STATE(285), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9380] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(214), 1,
      sym_paren_right,
    ACTIONS(847), 1,
      sym_comma,
    STATE(286), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9397] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(287), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(796), 2,
      sym_attr,
      sym_ident,
  [9412] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(849), 1,
      sym_comma,
    ACTIONS(851), 1,
      sym_paren_right,
    STATE(288), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9429] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(853), 1,
      sym_brace_left,
    STATE(191), 1,
      sym_struct_body_decl,
    STATE(289), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9446] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(855), 1,
      sym_comma,
    ACTIONS(857), 1,
      sym_greater_than,
    STATE(290), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9463] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(859), 1,
      sym_paren_left,
    STATE(206), 1,
      sym_argument_expression_list,
    STATE(291), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9480] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(136), 1,
      sym_paren_left,
    STATE(130), 1,
      sym_paren_expression,
    STATE(292), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9497] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(210), 1,
      sym_paren_right,
    ACTIONS(861), 1,
      sym_comma,
    STATE(293), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9514] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(863), 1,
      sym_comma,
    ACTIONS(865), 1,
      sym_paren_right,
    STATE(294), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9531] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(867), 1,
      sym_equal,
    ACTIONS(869), 1,
      sym_semicolon,
    STATE(295), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9548] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(871), 1,
      sym_comma,
    ACTIONS(873), 1,
      sym_paren_right,
    STATE(296), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9565] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(875), 1,
      sym_paren_left,
    STATE(129), 1,
      sym_argument_expression_list,
    STATE(297), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9582] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(877), 1,
      sym_comma,
    ACTIONS(879), 1,
      sym_greater_than,
    STATE(298), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9599] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(226), 1,
      sym_paren_right,
    ACTIONS(881), 1,
      sym_comma,
    STATE(299), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9616] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(883), 1,
      sym_comma,
    ACTIONS(885), 1,
      sym_paren_right,
    STATE(300), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9633] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(693), 1,
      sym_paren_left,
    ACTIONS(887), 1,
      sym_semicolon,
    STATE(301), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9650] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(302), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(776), 2,
      sym_equal,
      sym_semicolon,
  [9665] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(693), 1,
      sym_paren_left,
    ACTIONS(889), 1,
      sym_semicolon,
    STATE(303), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9682] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(304), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(891), 2,
      sym_paren_right,
      sym_semicolon,
  [9697] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(893), 1,
      sym_ident,
    STATE(305), 1,
      sym__comment,
    STATE(316), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9714] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    STATE(306), 1,
      sym__comment,
    STATE(422), 1,
      sym_compound_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9731] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(895), 1,
      sym_ident,
    STATE(307), 1,
      sym__comment,
    STATE(341), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9748] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(276), 1,
      sym_paren_expression,
    STATE(308), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9765] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(309), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(897), 2,
      sym_paren_right,
      sym_semicolon,
  [9780] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(310), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(899), 2,
      sym_paren_right,
      sym_semicolon,
  [9795] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(901), 1,
      sym_ident,
    STATE(266), 1,
      sym_variable_ident_decl,
    STATE(311), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9812] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(903), 1,
      sym_equal,
    ACTIONS(905), 1,
      sym_semicolon,
    STATE(312), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9829] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(279), 1,
      sym_brace_left,
    STATE(179), 1,
      sym_compound_statement,
    STATE(313), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9846] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(314), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(907), 2,
      sym_comma,
      sym_greater_than,
  [9861] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(909), 1,
      sym_comma,
    ACTIONS(911), 1,
      sym_greater_than,
    STATE(315), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9878] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(316), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(800), 2,
      sym_equal,
      sym_semicolon,
  [9893] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(913), 1,
      sym_comma,
    ACTIONS(915), 1,
      sym_paren_right,
    STATE(317), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9910] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(560), 1,
      sym_paren_left,
    STATE(95), 1,
      sym_argument_expression_list,
    STATE(318), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9927] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(319), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(917), 2,
      sym_paren_right,
      sym_semicolon,
  [9942] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(320), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(808), 2,
      sym_colon,
      sym_comma,
  [9957] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(871), 1,
      sym_comma,
    ACTIONS(919), 1,
      sym_paren_right,
    STATE(321), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9974] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(322), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(921), 2,
      sym_comma,
      sym_paren_right,
  [9989] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(323), 1,
      sym__comment,
    STATE(361), 1,
      sym_paren_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10006] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    ACTIONS(923), 1,
      sym_equal,
    STATE(324), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10023] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(925), 1,
      sym_brace_left,
    STATE(325), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10037] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(927), 1,
      sym_semicolon,
    STATE(326), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10051] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(586), 1,
      sym_paren_right,
    STATE(327), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10065] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(929), 1,
      sym_semicolon,
    STATE(328), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10079] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(931), 1,
      sym_semicolon,
    STATE(329), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10093] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(819), 1,
      sym_semicolon,
    STATE(330), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10107] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(933), 1,
      sym_brace_left,
    STATE(331), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10121] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(935), 1,
      sym_paren_left,
    STATE(332), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10135] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(937), 1,
      sym_less_than,
    STATE(333), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10149] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(939), 1,
      sym_less_than,
    STATE(334), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10163] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(941), 1,
      sym_greater_than,
    STATE(335), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10177] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(943), 1,
      sym_paren_right,
    STATE(336), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10191] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(945), 1,
      sym_bracket_right,
    STATE(337), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10205] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(947), 1,
      sym_semicolon,
    STATE(338), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10219] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(949), 1,
      sym_semicolon,
    STATE(339), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10233] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(349), 1,
      sym_brace_right,
    STATE(340), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10247] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(923), 1,
      sym_equal,
    STATE(341), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10261] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(951), 1,
      sym_brace_right,
    STATE(342), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10275] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(953), 1,
      sym_brace_right,
    STATE(343), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10289] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(955), 1,
      sym_less_than,
    STATE(344), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10303] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(957), 1,
      sym_less_than,
    STATE(345), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10317] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(959), 1,
      sym_less_than,
    STATE(346), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10331] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(961), 1,
      sym_less_than,
    STATE(347), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10345] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(963), 1,
      sym_and_and,
    STATE(348), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10359] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(965), 1,
      sym_less_than,
    STATE(349), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10373] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(967), 1,
      sym_or_or,
    STATE(350), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10387] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(969), 1,
      sym_less_than,
    STATE(351), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10401] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(971), 1,
      sym_less_than,
    STATE(352), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10415] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(973), 1,
      sym_or,
    STATE(353), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10429] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(975), 1,
      sym_semicolon,
    STATE(354), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10443] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(977), 1,
      sym_and,
    STATE(355), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10457] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(979), 1,
      sym_brace_left,
    STATE(356), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10471] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(981), 1,
      sym_ident,
    STATE(357), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10485] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(754), 1,
      sym_semicolon,
    STATE(358), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10499] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(983), 1,
      sym_xor,
    STATE(359), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10513] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(985), 1,
      sym_semicolon,
    STATE(360), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10527] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(987), 1,
      sym_brace_left,
    STATE(361), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10541] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(989), 1,
      sym_paren_right,
    STATE(362), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10555] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(991), 1,
      sym_comma,
    STATE(363), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10569] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(993), 1,
      sym_ident,
    STATE(364), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10583] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(995), 1,
      sym_semicolon,
    STATE(365), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10597] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(120), 1,
      sym_semicolon,
    STATE(366), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10611] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(281), 1,
      sym_brace_right,
    STATE(367), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10625] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(997), 1,
      sym_paren_left,
    STATE(368), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10639] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(999), 1,
      sym_comma,
    STATE(369), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10653] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(871), 1,
      sym_comma,
    STATE(370), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10667] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1001), 1,
      sym_brace_left,
    STATE(371), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10681] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1003), 1,
      sym_ident,
    STATE(372), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10695] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1005), 1,
      sym_paren_right,
    STATE(373), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10709] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1007), 1,
      sym_semicolon,
    STATE(374), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10723] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1009), 1,
      sym_paren_right,
    STATE(375), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10737] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1011), 1,
      sym_semicolon,
    STATE(376), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10751] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1013), 1,
      sym_semicolon,
    STATE(377), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10765] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1015), 1,
      sym_brace_left,
    STATE(378), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10779] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1017), 1,
      sym_colon,
    STATE(379), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10793] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(887), 1,
      sym_semicolon,
    STATE(380), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10807] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1019), 1,
      sym_comma,
    STATE(381), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10821] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1021), 1,
      sym_comma,
    STATE(382), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10835] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1023), 1,
      sym_greater_than,
    STATE(383), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10849] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1025), 1,
      sym_comma,
    STATE(384), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10863] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1027), 1,
      sym_equal,
    STATE(385), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10877] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1029), 1,
      sym_greater_than,
    STATE(386), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10891] = 5,
    ACTIONS(5), 1,
      sym__block_comment,
    ACTIONS(1031), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1033), 1,
      aux_sym__comment_token1,
    ACTIONS(1035), 1,
      sym__space,
    STATE(387), 1,
      sym__comment,
  [10907] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1037), 1,
      sym_semicolon,
    STATE(388), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10921] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1039), 1,
      sym_semicolon,
    STATE(389), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10935] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(889), 1,
      sym_semicolon,
    STATE(390), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10949] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1041), 1,
      sym_greater_than,
    STATE(391), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10963] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1043), 1,
      sym_ident,
    STATE(392), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10977] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1045), 1,
      sym_paren_right,
    STATE(393), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10991] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(568), 1,
      sym_equal,
    STATE(394), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11005] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1047), 1,
      sym_bracket_right,
    STATE(395), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11019] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1049), 1,
      sym_paren_left,
    STATE(396), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11033] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(566), 1,
      sym_paren_right,
    STATE(397), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11047] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1051), 1,
      sym_paren_right,
    STATE(398), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11061] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1053), 1,
      sym_semicolon,
    STATE(399), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11075] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1055), 1,
      sym_comma,
    STATE(400), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11089] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1057), 1,
      sym_greater_than,
    STATE(401), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11103] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1059), 1,
      sym_ident,
    STATE(402), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11117] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1061), 1,
      sym_paren_right,
    STATE(403), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11131] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1063), 1,
      sym_greater_than,
    STATE(404), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11145] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1065), 1,
      sym_bracket_right,
    STATE(405), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11159] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1067), 1,
      sym_ident,
    STATE(406), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11173] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1069), 1,
      sym_greater_than,
    STATE(407), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11187] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1071), 1,
      sym_brace_left,
    STATE(408), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11201] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1073), 1,
      sym_greater_than,
    STATE(409), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11215] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(750), 1,
      sym_colon,
    STATE(410), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11229] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1075), 1,
      sym_colon,
    STATE(411), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11243] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1077), 1,
      sym_semicolon,
    STATE(412), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11257] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1079), 1,
      sym_semicolon,
    STATE(413), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11271] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1081), 1,
      sym_greater_than,
    STATE(414), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11285] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1083), 1,
      sym_greater_than,
    STATE(415), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11299] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1085), 1,
      ts_builtin_sym_end,
    STATE(416), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11313] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1087), 1,
      sym_brace_right,
    STATE(417), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11327] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1089), 1,
      sym_ident,
    STATE(418), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11341] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1091), 1,
      sym_greater_than,
    STATE(419), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11355] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1093), 1,
      sym_paren_right,
    STATE(420), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11369] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1095), 1,
      sym_ident,
    STATE(421), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11383] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1097), 1,
      sym_brace_right,
    STATE(422), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11397] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1099), 1,
      sym_ident,
    STATE(423), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11411] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1101), 1,
      sym_less_than,
    STATE(424), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11425] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1103), 1,
      sym_ident,
    STATE(425), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11439] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1105), 1,
      sym_less_than,
    STATE(426), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11453] = 1,
    ACTIONS(1107), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(39)] = 0,
  [SMALL_STATE(40)] = 112,
  [SMALL_STATE(41)] = 221,
  [SMALL_STATE(42)] = 328,
  [SMALL_STATE(43)] = 436,
  [SMALL_STATE(44)] = 544,
  [SMALL_STATE(45)] = 652,
  [SMALL_STATE(46)] = 721,
  [SMALL_STATE(47)] = 790,
  [SMALL_STATE(48)] = 859,
  [SMALL_STATE(49)] = 928,
  [SMALL_STATE(50)] = 997,
  [SMALL_STATE(51)] = 1066,
  [SMALL_STATE(52)] = 1132,
  [SMALL_STATE(53)] = 1198,
  [SMALL_STATE(54)] = 1292,
  [SMALL_STATE(55)] = 1386,
  [SMALL_STATE(56)] = 1480,
  [SMALL_STATE(57)] = 1574,
  [SMALL_STATE(58)] = 1659,
  [SMALL_STATE(59)] = 1744,
  [SMALL_STATE(60)] = 1829,
  [SMALL_STATE(61)] = 1914,
  [SMALL_STATE(62)] = 1999,
  [SMALL_STATE(63)] = 2084,
  [SMALL_STATE(64)] = 2169,
  [SMALL_STATE(65)] = 2254,
  [SMALL_STATE(66)] = 2339,
  [SMALL_STATE(67)] = 2401,
  [SMALL_STATE(68)] = 2463,
  [SMALL_STATE(69)] = 2524,
  [SMALL_STATE(70)] = 2583,
  [SMALL_STATE(71)] = 2643,
  [SMALL_STATE(72)] = 2700,
  [SMALL_STATE(73)] = 2757,
  [SMALL_STATE(74)] = 2814,
  [SMALL_STATE(75)] = 2918,
  [SMALL_STATE(76)] = 3022,
  [SMALL_STATE(77)] = 3121,
  [SMALL_STATE(78)] = 3220,
  [SMALL_STATE(79)] = 3321,
  [SMALL_STATE(80)] = 3422,
  [SMALL_STATE(81)] = 3520,
  [SMALL_STATE(82)] = 3618,
  [SMALL_STATE(83)] = 3659,
  [SMALL_STATE(84)] = 3700,
  [SMALL_STATE(85)] = 3745,
  [SMALL_STATE(86)] = 3791,
  [SMALL_STATE(87)] = 3837,
  [SMALL_STATE(88)] = 3883,
  [SMALL_STATE(89)] = 3923,
  [SMALL_STATE(90)] = 3963,
  [SMALL_STATE(91)] = 4003,
  [SMALL_STATE(92)] = 4042,
  [SMALL_STATE(93)] = 4081,
  [SMALL_STATE(94)] = 4120,
  [SMALL_STATE(95)] = 4165,
  [SMALL_STATE(96)] = 4204,
  [SMALL_STATE(97)] = 4249,
  [SMALL_STATE(98)] = 4288,
  [SMALL_STATE(99)] = 4327,
  [SMALL_STATE(100)] = 4366,
  [SMALL_STATE(101)] = 4411,
  [SMALL_STATE(102)] = 4448,
  [SMALL_STATE(103)] = 4519,
  [SMALL_STATE(104)] = 4556,
  [SMALL_STATE(105)] = 4593,
  [SMALL_STATE(106)] = 4630,
  [SMALL_STATE(107)] = 4667,
  [SMALL_STATE(108)] = 4703,
  [SMALL_STATE(109)] = 4743,
  [SMALL_STATE(110)] = 4779,
  [SMALL_STATE(111)] = 4817,
  [SMALL_STATE(112)] = 4852,
  [SMALL_STATE(113)] = 4887,
  [SMALL_STATE(114)] = 4928,
  [SMALL_STATE(115)] = 4963,
  [SMALL_STATE(116)] = 4998,
  [SMALL_STATE(117)] = 5039,
  [SMALL_STATE(118)] = 5080,
  [SMALL_STATE(119)] = 5115,
  [SMALL_STATE(120)] = 5150,
  [SMALL_STATE(121)] = 5185,
  [SMALL_STATE(122)] = 5220,
  [SMALL_STATE(123)] = 5255,
  [SMALL_STATE(124)] = 5289,
  [SMALL_STATE(125)] = 5323,
  [SMALL_STATE(126)] = 5357,
  [SMALL_STATE(127)] = 5393,
  [SMALL_STATE(128)] = 5427,
  [SMALL_STATE(129)] = 5461,
  [SMALL_STATE(130)] = 5495,
  [SMALL_STATE(131)] = 5529,
  [SMALL_STATE(132)] = 5563,
  [SMALL_STATE(133)] = 5597,
  [SMALL_STATE(134)] = 5631,
  [SMALL_STATE(135)] = 5665,
  [SMALL_STATE(136)] = 5724,
  [SMALL_STATE(137)] = 5781,
  [SMALL_STATE(138)] = 5840,
  [SMALL_STATE(139)] = 5872,
  [SMALL_STATE(140)] = 5904,
  [SMALL_STATE(141)] = 5936,
  [SMALL_STATE(142)] = 5968,
  [SMALL_STATE(143)] = 6004,
  [SMALL_STATE(144)] = 6036,
  [SMALL_STATE(145)] = 6072,
  [SMALL_STATE(146)] = 6108,
  [SMALL_STATE(147)] = 6140,
  [SMALL_STATE(148)] = 6172,
  [SMALL_STATE(149)] = 6204,
  [SMALL_STATE(150)] = 6240,
  [SMALL_STATE(151)] = 6296,
  [SMALL_STATE(152)] = 6330,
  [SMALL_STATE(153)] = 6359,
  [SMALL_STATE(154)] = 6388,
  [SMALL_STATE(155)] = 6433,
  [SMALL_STATE(156)] = 6468,
  [SMALL_STATE(157)] = 6495,
  [SMALL_STATE(158)] = 6526,
  [SMALL_STATE(159)] = 6571,
  [SMALL_STATE(160)] = 6598,
  [SMALL_STATE(161)] = 6643,
  [SMALL_STATE(162)] = 6673,
  [SMALL_STATE(163)] = 6702,
  [SMALL_STATE(164)] = 6729,
  [SMALL_STATE(165)] = 6760,
  [SMALL_STATE(166)] = 6789,
  [SMALL_STATE(167)] = 6818,
  [SMALL_STATE(168)] = 6846,
  [SMALL_STATE(169)] = 6874,
  [SMALL_STATE(170)] = 6902,
  [SMALL_STATE(171)] = 6933,
  [SMALL_STATE(172)] = 6965,
  [SMALL_STATE(173)] = 6987,
  [SMALL_STATE(174)] = 7025,
  [SMALL_STATE(175)] = 7051,
  [SMALL_STATE(176)] = 7073,
  [SMALL_STATE(177)] = 7105,
  [SMALL_STATE(178)] = 7127,
  [SMALL_STATE(179)] = 7159,
  [SMALL_STATE(180)] = 7180,
  [SMALL_STATE(181)] = 7211,
  [SMALL_STATE(182)] = 7246,
  [SMALL_STATE(183)] = 7267,
  [SMALL_STATE(184)] = 7290,
  [SMALL_STATE(185)] = 7311,
  [SMALL_STATE(186)] = 7342,
  [SMALL_STATE(187)] = 7371,
  [SMALL_STATE(188)] = 7400,
  [SMALL_STATE(189)] = 7421,
  [SMALL_STATE(190)] = 7442,
  [SMALL_STATE(191)] = 7477,
  [SMALL_STATE(192)] = 7498,
  [SMALL_STATE(193)] = 7525,
  [SMALL_STATE(194)] = 7546,
  [SMALL_STATE(195)] = 7581,
  [SMALL_STATE(196)] = 7614,
  [SMALL_STATE(197)] = 7634,
  [SMALL_STATE(198)] = 7654,
  [SMALL_STATE(199)] = 7674,
  [SMALL_STATE(200)] = 7704,
  [SMALL_STATE(201)] = 7736,
  [SMALL_STATE(202)] = 7756,
  [SMALL_STATE(203)] = 7776,
  [SMALL_STATE(204)] = 7806,
  [SMALL_STATE(205)] = 7826,
  [SMALL_STATE(206)] = 7846,
  [SMALL_STATE(207)] = 7866,
  [SMALL_STATE(208)] = 7886,
  [SMALL_STATE(209)] = 7906,
  [SMALL_STATE(210)] = 7926,
  [SMALL_STATE(211)] = 7946,
  [SMALL_STATE(212)] = 7966,
  [SMALL_STATE(213)] = 7986,
  [SMALL_STATE(214)] = 8006,
  [SMALL_STATE(215)] = 8026,
  [SMALL_STATE(216)] = 8046,
  [SMALL_STATE(217)] = 8066,
  [SMALL_STATE(218)] = 8086,
  [SMALL_STATE(219)] = 8106,
  [SMALL_STATE(220)] = 8126,
  [SMALL_STATE(221)] = 8147,
  [SMALL_STATE(222)] = 8166,
  [SMALL_STATE(223)] = 8187,
  [SMALL_STATE(224)] = 8214,
  [SMALL_STATE(225)] = 8237,
  [SMALL_STATE(226)] = 8257,
  [SMALL_STATE(227)] = 8277,
  [SMALL_STATE(228)] = 8297,
  [SMALL_STATE(229)] = 8317,
  [SMALL_STATE(230)] = 8337,
  [SMALL_STATE(231)] = 8357,
  [SMALL_STATE(232)] = 8383,
  [SMALL_STATE(233)] = 8401,
  [SMALL_STATE(234)] = 8427,
  [SMALL_STATE(235)] = 8447,
  [SMALL_STATE(236)] = 8465,
  [SMALL_STATE(237)] = 8491,
  [SMALL_STATE(238)] = 8509,
  [SMALL_STATE(239)] = 8533,
  [SMALL_STATE(240)] = 8557,
  [SMALL_STATE(241)] = 8580,
  [SMALL_STATE(242)] = 8601,
  [SMALL_STATE(243)] = 8622,
  [SMALL_STATE(244)] = 8645,
  [SMALL_STATE(245)] = 8666,
  [SMALL_STATE(246)] = 8689,
  [SMALL_STATE(247)] = 8710,
  [SMALL_STATE(248)] = 8727,
  [SMALL_STATE(249)] = 8744,
  [SMALL_STATE(250)] = 8767,
  [SMALL_STATE(251)] = 8783,
  [SMALL_STATE(252)] = 8801,
  [SMALL_STATE(253)] = 8817,
  [SMALL_STATE(254)] = 8833,
  [SMALL_STATE(255)] = 8849,
  [SMALL_STATE(256)] = 8865,
  [SMALL_STATE(257)] = 8881,
  [SMALL_STATE(258)] = 8897,
  [SMALL_STATE(259)] = 8917,
  [SMALL_STATE(260)] = 8933,
  [SMALL_STATE(261)] = 8951,
  [SMALL_STATE(262)] = 8969,
  [SMALL_STATE(263)] = 8985,
  [SMALL_STATE(264)] = 9005,
  [SMALL_STATE(265)] = 9025,
  [SMALL_STATE(266)] = 9043,
  [SMALL_STATE(267)] = 9063,
  [SMALL_STATE(268)] = 9081,
  [SMALL_STATE(269)] = 9097,
  [SMALL_STATE(270)] = 9113,
  [SMALL_STATE(271)] = 9129,
  [SMALL_STATE(272)] = 9146,
  [SMALL_STATE(273)] = 9163,
  [SMALL_STATE(274)] = 9180,
  [SMALL_STATE(275)] = 9197,
  [SMALL_STATE(276)] = 9214,
  [SMALL_STATE(277)] = 9231,
  [SMALL_STATE(278)] = 9248,
  [SMALL_STATE(279)] = 9263,
  [SMALL_STATE(280)] = 9280,
  [SMALL_STATE(281)] = 9295,
  [SMALL_STATE(282)] = 9312,
  [SMALL_STATE(283)] = 9329,
  [SMALL_STATE(284)] = 9346,
  [SMALL_STATE(285)] = 9363,
  [SMALL_STATE(286)] = 9380,
  [SMALL_STATE(287)] = 9397,
  [SMALL_STATE(288)] = 9412,
  [SMALL_STATE(289)] = 9429,
  [SMALL_STATE(290)] = 9446,
  [SMALL_STATE(291)] = 9463,
  [SMALL_STATE(292)] = 9480,
  [SMALL_STATE(293)] = 9497,
  [SMALL_STATE(294)] = 9514,
  [SMALL_STATE(295)] = 9531,
  [SMALL_STATE(296)] = 9548,
  [SMALL_STATE(297)] = 9565,
  [SMALL_STATE(298)] = 9582,
  [SMALL_STATE(299)] = 9599,
  [SMALL_STATE(300)] = 9616,
  [SMALL_STATE(301)] = 9633,
  [SMALL_STATE(302)] = 9650,
  [SMALL_STATE(303)] = 9665,
  [SMALL_STATE(304)] = 9682,
  [SMALL_STATE(305)] = 9697,
  [SMALL_STATE(306)] = 9714,
  [SMALL_STATE(307)] = 9731,
  [SMALL_STATE(308)] = 9748,
  [SMALL_STATE(309)] = 9765,
  [SMALL_STATE(310)] = 9780,
  [SMALL_STATE(311)] = 9795,
  [SMALL_STATE(312)] = 9812,
  [SMALL_STATE(313)] = 9829,
  [SMALL_STATE(314)] = 9846,
  [SMALL_STATE(315)] = 9861,
  [SMALL_STATE(316)] = 9878,
  [SMALL_STATE(317)] = 9893,
  [SMALL_STATE(318)] = 9910,
  [SMALL_STATE(319)] = 9927,
  [SMALL_STATE(320)] = 9942,
  [SMALL_STATE(321)] = 9957,
  [SMALL_STATE(322)] = 9974,
  [SMALL_STATE(323)] = 9989,
  [SMALL_STATE(324)] = 10006,
  [SMALL_STATE(325)] = 10023,
  [SMALL_STATE(326)] = 10037,
  [SMALL_STATE(327)] = 10051,
  [SMALL_STATE(328)] = 10065,
  [SMALL_STATE(329)] = 10079,
  [SMALL_STATE(330)] = 10093,
  [SMALL_STATE(331)] = 10107,
  [SMALL_STATE(332)] = 10121,
  [SMALL_STATE(333)] = 10135,
  [SMALL_STATE(334)] = 10149,
  [SMALL_STATE(335)] = 10163,
  [SMALL_STATE(336)] = 10177,
  [SMALL_STATE(337)] = 10191,
  [SMALL_STATE(338)] = 10205,
  [SMALL_STATE(339)] = 10219,
  [SMALL_STATE(340)] = 10233,
  [SMALL_STATE(341)] = 10247,
  [SMALL_STATE(342)] = 10261,
  [SMALL_STATE(343)] = 10275,
  [SMALL_STATE(344)] = 10289,
  [SMALL_STATE(345)] = 10303,
  [SMALL_STATE(346)] = 10317,
  [SMALL_STATE(347)] = 10331,
  [SMALL_STATE(348)] = 10345,
  [SMALL_STATE(349)] = 10359,
  [SMALL_STATE(350)] = 10373,
  [SMALL_STATE(351)] = 10387,
  [SMALL_STATE(352)] = 10401,
  [SMALL_STATE(353)] = 10415,
  [SMALL_STATE(354)] = 10429,
  [SMALL_STATE(355)] = 10443,
  [SMALL_STATE(356)] = 10457,
  [SMALL_STATE(357)] = 10471,
  [SMALL_STATE(358)] = 10485,
  [SMALL_STATE(359)] = 10499,
  [SMALL_STATE(360)] = 10513,
  [SMALL_STATE(361)] = 10527,
  [SMALL_STATE(362)] = 10541,
  [SMALL_STATE(363)] = 10555,
  [SMALL_STATE(364)] = 10569,
  [SMALL_STATE(365)] = 10583,
  [SMALL_STATE(366)] = 10597,
  [SMALL_STATE(367)] = 10611,
  [SMALL_STATE(368)] = 10625,
  [SMALL_STATE(369)] = 10639,
  [SMALL_STATE(370)] = 10653,
  [SMALL_STATE(371)] = 10667,
  [SMALL_STATE(372)] = 10681,
  [SMALL_STATE(373)] = 10695,
  [SMALL_STATE(374)] = 10709,
  [SMALL_STATE(375)] = 10723,
  [SMALL_STATE(376)] = 10737,
  [SMALL_STATE(377)] = 10751,
  [SMALL_STATE(378)] = 10765,
  [SMALL_STATE(379)] = 10779,
  [SMALL_STATE(380)] = 10793,
  [SMALL_STATE(381)] = 10807,
  [SMALL_STATE(382)] = 10821,
  [SMALL_STATE(383)] = 10835,
  [SMALL_STATE(384)] = 10849,
  [SMALL_STATE(385)] = 10863,
  [SMALL_STATE(386)] = 10877,
  [SMALL_STATE(387)] = 10891,
  [SMALL_STATE(388)] = 10907,
  [SMALL_STATE(389)] = 10921,
  [SMALL_STATE(390)] = 10935,
  [SMALL_STATE(391)] = 10949,
  [SMALL_STATE(392)] = 10963,
  [SMALL_STATE(393)] = 10977,
  [SMALL_STATE(394)] = 10991,
  [SMALL_STATE(395)] = 11005,
  [SMALL_STATE(396)] = 11019,
  [SMALL_STATE(397)] = 11033,
  [SMALL_STATE(398)] = 11047,
  [SMALL_STATE(399)] = 11061,
  [SMALL_STATE(400)] = 11075,
  [SMALL_STATE(401)] = 11089,
  [SMALL_STATE(402)] = 11103,
  [SMALL_STATE(403)] = 11117,
  [SMALL_STATE(404)] = 11131,
  [SMALL_STATE(405)] = 11145,
  [SMALL_STATE(406)] = 11159,
  [SMALL_STATE(407)] = 11173,
  [SMALL_STATE(408)] = 11187,
  [SMALL_STATE(409)] = 11201,
  [SMALL_STATE(410)] = 11215,
  [SMALL_STATE(411)] = 11229,
  [SMALL_STATE(412)] = 11243,
  [SMALL_STATE(413)] = 11257,
  [SMALL_STATE(414)] = 11271,
  [SMALL_STATE(415)] = 11285,
  [SMALL_STATE(416)] = 11299,
  [SMALL_STATE(417)] = 11313,
  [SMALL_STATE(418)] = 11327,
  [SMALL_STATE(419)] = 11341,
  [SMALL_STATE(420)] = 11355,
  [SMALL_STATE(421)] = 11369,
  [SMALL_STATE(422)] = 11383,
  [SMALL_STATE(423)] = 11397,
  [SMALL_STATE(424)] = 11411,
  [SMALL_STATE(425)] = 11425,
  [SMALL_STATE(426)] = 11439,
  [SMALL_STATE(427)] = 11453,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(84),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(88),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(89),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(89),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(352),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(351),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(214),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(349),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(215),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(347),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(346),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(345),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(216),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(344),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(37),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(37),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(13),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [126] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(424),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [142] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [146] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [150] = {.entry = {.count = 1, .reusable = false}}, SHIFT(426),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(214),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(88),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(89),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(89),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(352),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(351),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(349),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(215),
  [184] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(347),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(346),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(345),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(216),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_assignment_operator, 1),
  [220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_assignment_operator, 1),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_struct_member_repeat1, 2),
  [232] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_member_repeat1, 2), SHIFT_REPEAT(418),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 5),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 5),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 6),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 6),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_struct_member_repeat1, 1),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_member_repeat1, 1),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [255] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(376),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 1),
  [295] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(151),
  [298] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(329),
  [301] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(328),
  [304] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [306] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(376),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(368),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(308),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(307),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(371),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(8),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(323),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(245),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(247),
  [333] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(80),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(203),
  [341] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(115),
  [344] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(394),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 3),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 3),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 2),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 2),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 1),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 1),
  [367] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(2),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 1),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 1),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 3),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 3),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 2),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 2),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_literal, 1),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_literal, 1),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_literal, 1),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_literal, 1),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expression, 3),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expression, 3),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 3),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 3),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 4),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 4),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 2),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 2),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 5),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 5),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 2),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 2),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 5),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 5),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_and_expression, 1),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 1),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 1),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_or_expression, 1),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_xor_expression, 1),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 1),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 1),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 1),
  [444] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 2),
  [446] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 2),
  [448] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 4),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 4),
  [456] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(3),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [477] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_statement, 5),
  [481] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 5),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 5),
  [489] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 1),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 3),
  [495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 3),
  [497] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5),
  [501] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 4),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 4),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2),
  [511] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(406),
  [514] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(423),
  [517] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(275),
  [520] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(421),
  [523] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(245),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(418),
  [529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(193),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 2),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 3),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 3),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 1),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [544] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 1),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 3),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 3),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 1),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 2),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_core_lhs_expression, 1),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_core_lhs_expression, 3),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 1),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 1),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [582] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 2),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 3),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 3),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 3),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(425),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 1),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [613] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 2),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_directive, 1),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [623] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(4),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enable_directive, 3),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 3),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 1),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 3),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [636] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 2),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 3),
  [646] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(322),
  [649] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(88),
  [652] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(322),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 2),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 3),
  [661] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 1),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [665] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(410),
  [668] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(418),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 8),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 6),
  [677] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(410),
  [680] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(418),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 4),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 4),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 4),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 6),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 1),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampler_type, 1),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_depth_texture_type, 1),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 6),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 1),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 3),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 1),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 1),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 2),
  [715] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 2), SHIFT_REPEAT(247),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_and_expression, 3),
  [720] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_xor_expression, 3),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_or_expression, 3),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 3),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [732] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(178),
  [743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(411),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 3),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(407),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 1),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ident_decl, 3),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 2),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 6),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 2),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 3),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 4),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 1),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 5),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 2),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 1),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 1),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 1),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 3),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 3),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 2),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2),
  [810] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2), SHIFT_REPEAT(186),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 6),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 5),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 4),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 3),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 1),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 2),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 1),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 1),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 4),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 1),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_const_initializer, 2),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 4),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_increment_statement, 2),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decrement_statement, 2),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_call_statement, 2),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 2),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_class, 1),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal_or_ident, 1),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_init, 1),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continue_statement, 1),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_statement, 1),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 5),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 3),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 2),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_texture_type, 1),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multisampled_texture_type, 1),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampled_texture_type, 1),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 4),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 3),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 5),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_decl, 4),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 4),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texel_format, 1),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [1033] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [1035] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1051] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_update, 1),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1069] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_count_expression, 1),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access_mode, 1),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1085] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1097] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continuing_statement, 2),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_wgsl_external_scanner_create(void);
void tree_sitter_wgsl_external_scanner_destroy(void *);
bool tree_sitter_wgsl_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_wgsl_external_scanner_serialize(void *, char *);
void tree_sitter_wgsl_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wgsl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_ident,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_wgsl_external_scanner_create,
      tree_sitter_wgsl_external_scanner_destroy,
      tree_sitter_wgsl_external_scanner_scan,
      tree_sitter_wgsl_external_scanner_serialize,
      tree_sitter_wgsl_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
