#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 439
#define LARGE_STATE_COUNT 36
#define SYMBOL_COUNT 257
#define ALIAS_COUNT 0
#define TOKEN_COUNT 172
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_ident = 1,
  sym_decimal_float_literal = 2,
  sym_hex_float_literal = 3,
  sym_int_literal = 4,
  sym_uint_literal = 5,
  sym_array = 6,
  sym_atomic = 7,
  sym_bool = 8,
  sym_float32 = 9,
  sym_int32 = 10,
  sym_mat2x2 = 11,
  sym_mat2x3 = 12,
  sym_mat2x4 = 13,
  sym_mat3x2 = 14,
  sym_mat3x3 = 15,
  sym_mat3x4 = 16,
  sym_mat4x2 = 17,
  sym_mat4x3 = 18,
  sym_mat4x4 = 19,
  sym_pointer = 20,
  sym_sampler = 21,
  sym_sampler_comparison = 22,
  sym_struct = 23,
  sym_texture_1d = 24,
  sym_texture_2d = 25,
  sym_texture_2d_array = 26,
  sym_texture_3d = 27,
  sym_texture_cube = 28,
  sym_texture_cube_array = 29,
  sym_texture_multisampled_2d = 30,
  sym_texture_storage_1d = 31,
  sym_texture_storage_2d = 32,
  sym_texture_storage_2d_array = 33,
  sym_texture_storage_3d = 34,
  sym_texture_depth_2d = 35,
  sym_texture_depth_2d_array = 36,
  sym_texture_depth_cube = 37,
  sym_texture_depth_cube_array = 38,
  sym_texture_depth_multisampled_2d = 39,
  sym_uint32 = 40,
  sym_vec2 = 41,
  sym_vec3 = 42,
  sym_vec4 = 43,
  sym_bitcast = 44,
  sym_block = 45,
  sym_break = 46,
  sym_case = 47,
  sym_continue = 48,
  sym_continuing = 49,
  sym_default = 50,
  sym_discard = 51,
  sym_else = 52,
  sym_enable = 53,
  sym_fallthrough = 54,
  sym_false = 55,
  sym_fn = 56,
  sym_for = 57,
  sym_function = 58,
  sym_if = 59,
  sym_let = 60,
  sym_loop = 61,
  sym_private = 62,
  sym_read = 63,
  sym_read_write = 64,
  sym_return = 65,
  sym_storage = 66,
  sym_switch = 67,
  sym_true = 68,
  sym_type = 69,
  sym_uniform = 70,
  sym_var = 71,
  sym_workgroup = 72,
  sym_write = 73,
  sym_r8unorm = 74,
  sym_r8snorm = 75,
  sym_r8uint = 76,
  sym_r8sint = 77,
  sym_r16uint = 78,
  sym_r16sint = 79,
  sym_r16float = 80,
  sym_rg8unorm = 81,
  sym_rg8snorm = 82,
  sym_rg8uint = 83,
  sym_rg8sint = 84,
  sym_r32uint = 85,
  sym_r32sint = 86,
  sym_r32float = 87,
  sym_rg16uint = 88,
  sym_rg16sint = 89,
  sym_rg16float = 90,
  sym_rgba8unorm = 91,
  sym_rgba8unorm_srgb = 92,
  sym_rgba8snorm = 93,
  sym_rgba8uint = 94,
  sym_rgba8sint = 95,
  sym_bgra8unorm = 96,
  sym_bgra8unorm_srgb = 97,
  sym_rgb10a2unorm = 98,
  sym_rg11b10float = 99,
  sym_rg32uint = 100,
  sym_rg32sint = 101,
  sym_rg32float = 102,
  sym_rgba16uint = 103,
  sym_rgba16sint = 104,
  sym_rgba16float = 105,
  sym_rgba32uint = 106,
  sym_rgba32sint = 107,
  sym_rgba32float = 108,
  sym_and = 109,
  sym_and_and = 110,
  sym_arrow = 111,
  sym_attr_left = 112,
  sym_attr_right = 113,
  sym_forward_slash = 114,
  sym_bang = 115,
  sym_bracket_left = 116,
  sym_bracket_right = 117,
  sym_brace_left = 118,
  sym_brace_right = 119,
  sym_colon = 120,
  sym_comma = 121,
  sym_equal = 122,
  sym_equal_equal = 123,
  sym_not_equal = 124,
  sym_greater_than = 125,
  sym_greater_than_equal = 126,
  sym_shift_right = 127,
  sym_less_than = 128,
  sym_less_than_equal = 129,
  sym_shift_left = 130,
  sym_modulo = 131,
  sym_minus = 132,
  sym_period = 133,
  sym_plus = 134,
  sym_plus_plus = 135,
  sym_or = 136,
  sym_or_or = 137,
  sym_paren_left = 138,
  sym_paren_right = 139,
  sym_semicolon = 140,
  sym_star = 141,
  sym_tilde = 142,
  sym_underscore = 143,
  sym_xor = 144,
  aux_sym__reserved_token1 = 145,
  aux_sym__reserved_token2 = 146,
  aux_sym__reserved_token3 = 147,
  aux_sym__reserved_token4 = 148,
  aux_sym__reserved_token5 = 149,
  aux_sym__reserved_token6 = 150,
  aux_sym__reserved_token7 = 151,
  aux_sym__reserved_token8 = 152,
  aux_sym__reserved_token9 = 153,
  aux_sym__reserved_token10 = 154,
  aux_sym__reserved_token11 = 155,
  aux_sym__reserved_token12 = 156,
  aux_sym__reserved_token13 = 157,
  aux_sym__reserved_token14 = 158,
  aux_sym__reserved_token15 = 159,
  aux_sym__reserved_token16 = 160,
  aux_sym__reserved_token17 = 161,
  aux_sym__reserved_token18 = 162,
  aux_sym__reserved_token19 = 163,
  aux_sym__reserved_token20 = 164,
  aux_sym__reserved_token21 = 165,
  aux_sym__reserved_token22 = 166,
  aux_sym__reserved_token23 = 167,
  anon_sym_SLASH_SLASH = 168,
  aux_sym__comment_token1 = 169,
  sym__space = 170,
  sym__block_comment = 171,
  sym_translation_unit = 172,
  sym_global_directive = 173,
  sym_const_literal = 174,
  sym_float_literal = 175,
  sym_attribute_list = 176,
  sym_attribute = 177,
  sym_literal_or_ident = 178,
  sym_array_type_decl = 179,
  sym_element_count_expression = 180,
  sym_struct_decl = 181,
  sym_struct_body_decl = 182,
  sym_struct_member = 183,
  sym_access_mode = 184,
  sym_storage_class = 185,
  sym_texture_sampler_types = 186,
  sym_sampler_type = 187,
  sym_sampled_texture_type = 188,
  sym_multisampled_texture_type = 189,
  sym_storage_texture_type = 190,
  sym_depth_texture_type = 191,
  sym_texel_format = 192,
  sym_type_alias_decl = 193,
  sym_type_decl = 194,
  sym_variable_statement = 195,
  sym_variable_decl = 196,
  sym_variable_ident_decl = 197,
  sym_variable_qualifier = 198,
  sym_global_variable_decl = 199,
  sym_global_constant_decl = 200,
  sym_global_const_initializer = 201,
  sym_const_expression = 202,
  sym_primary_expression = 203,
  sym_paren_expression = 204,
  sym_argument_expression_list = 205,
  sym_postfix_expression = 206,
  sym_unary_expression = 207,
  sym_singular_expression = 208,
  sym_lhs_expression = 209,
  sym_core_lhs_expression = 210,
  sym_multiplicative_expression = 211,
  sym_additive_expression = 212,
  sym_shift_expression = 213,
  sym_relational_expression = 214,
  sym_short_circuit_and_expression = 215,
  sym_short_circuit_or_expression = 216,
  sym_binary_or_expression = 217,
  sym_binary_and_expression = 218,
  sym_binary_xor_expression = 219,
  sym_expression = 220,
  sym_compound_statement = 221,
  sym_assignment_statement = 222,
  sym_if_statement = 223,
  sym_else_statement = 224,
  sym_switch_statement = 225,
  sym_switch_body = 226,
  sym_case_selectors = 227,
  sym_case_body = 228,
  sym_loop_statement = 229,
  sym_for_statement = 230,
  sym_for_header = 231,
  sym_break_statement = 232,
  sym_continue_statement = 233,
  sym_continuing_statement = 234,
  sym_return_statement = 235,
  sym_func_call_statement = 236,
  sym_statement = 237,
  sym_function_decl = 238,
  sym_function_header = 239,
  sym_param_list = 240,
  sym_param = 241,
  sym_enable_directive = 242,
  sym__comment = 243,
  aux_sym_translation_unit_repeat1 = 244,
  aux_sym_translation_unit_repeat2 = 245,
  aux_sym_attribute_list_repeat1 = 246,
  aux_sym_attribute_repeat1 = 247,
  aux_sym_array_type_decl_repeat1 = 248,
  aux_sym_struct_body_decl_repeat1 = 249,
  aux_sym_const_expression_repeat1 = 250,
  aux_sym_argument_expression_list_repeat1 = 251,
  aux_sym_lhs_expression_repeat1 = 252,
  aux_sym_compound_statement_repeat1 = 253,
  aux_sym_switch_statement_repeat1 = 254,
  aux_sym_case_selectors_repeat1 = 255,
  aux_sym_param_list_repeat1 = 256,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_ident] = "ident",
  [sym_decimal_float_literal] = "decimal_float_literal",
  [sym_hex_float_literal] = "hex_float_literal",
  [sym_int_literal] = "int_literal",
  [sym_uint_literal] = "uint_literal",
  [sym_array] = "array",
  [sym_atomic] = "atomic",
  [sym_bool] = "bool",
  [sym_float32] = "float32",
  [sym_int32] = "int32",
  [sym_mat2x2] = "mat2x2",
  [sym_mat2x3] = "mat2x3",
  [sym_mat2x4] = "mat2x4",
  [sym_mat3x2] = "mat3x2",
  [sym_mat3x3] = "mat3x3",
  [sym_mat3x4] = "mat3x4",
  [sym_mat4x2] = "mat4x2",
  [sym_mat4x3] = "mat4x3",
  [sym_mat4x4] = "mat4x4",
  [sym_pointer] = "pointer",
  [sym_sampler] = "sampler",
  [sym_sampler_comparison] = "sampler_comparison",
  [sym_struct] = "struct",
  [sym_texture_1d] = "texture_1d",
  [sym_texture_2d] = "texture_2d",
  [sym_texture_2d_array] = "texture_2d_array",
  [sym_texture_3d] = "texture_3d",
  [sym_texture_cube] = "texture_cube",
  [sym_texture_cube_array] = "texture_cube_array",
  [sym_texture_multisampled_2d] = "texture_multisampled_2d",
  [sym_texture_storage_1d] = "texture_storage_1d",
  [sym_texture_storage_2d] = "texture_storage_2d",
  [sym_texture_storage_2d_array] = "texture_storage_2d_array",
  [sym_texture_storage_3d] = "texture_storage_3d",
  [sym_texture_depth_2d] = "texture_depth_2d",
  [sym_texture_depth_2d_array] = "texture_depth_2d_array",
  [sym_texture_depth_cube] = "texture_depth_cube",
  [sym_texture_depth_cube_array] = "texture_depth_cube_array",
  [sym_texture_depth_multisampled_2d] = "texture_depth_multisampled_2d",
  [sym_uint32] = "uint32",
  [sym_vec2] = "vec2",
  [sym_vec3] = "vec3",
  [sym_vec4] = "vec4",
  [sym_bitcast] = "bitcast",
  [sym_block] = "block",
  [sym_break] = "break",
  [sym_case] = "case",
  [sym_continue] = "continue",
  [sym_continuing] = "continuing",
  [sym_default] = "default",
  [sym_discard] = "discard",
  [sym_else] = "else",
  [sym_enable] = "enable",
  [sym_fallthrough] = "fallthrough",
  [sym_false] = "false",
  [sym_fn] = "fn",
  [sym_for] = "for",
  [sym_function] = "function",
  [sym_if] = "if",
  [sym_let] = "let",
  [sym_loop] = "loop",
  [sym_private] = "private",
  [sym_read] = "read",
  [sym_read_write] = "read_write",
  [sym_return] = "return",
  [sym_storage] = "storage",
  [sym_switch] = "switch",
  [sym_true] = "true",
  [sym_type] = "type",
  [sym_uniform] = "uniform",
  [sym_var] = "var",
  [sym_workgroup] = "workgroup",
  [sym_write] = "write",
  [sym_r8unorm] = "r8unorm",
  [sym_r8snorm] = "r8snorm",
  [sym_r8uint] = "r8uint",
  [sym_r8sint] = "r8sint",
  [sym_r16uint] = "r16uint",
  [sym_r16sint] = "r16sint",
  [sym_r16float] = "r16float",
  [sym_rg8unorm] = "rg8unorm",
  [sym_rg8snorm] = "rg8snorm",
  [sym_rg8uint] = "rg8uint",
  [sym_rg8sint] = "rg8sint",
  [sym_r32uint] = "r32uint",
  [sym_r32sint] = "r32sint",
  [sym_r32float] = "r32float",
  [sym_rg16uint] = "rg16uint",
  [sym_rg16sint] = "rg16sint",
  [sym_rg16float] = "rg16float",
  [sym_rgba8unorm] = "rgba8unorm",
  [sym_rgba8unorm_srgb] = "rgba8unorm_srgb",
  [sym_rgba8snorm] = "rgba8snorm",
  [sym_rgba8uint] = "rgba8uint",
  [sym_rgba8sint] = "rgba8sint",
  [sym_bgra8unorm] = "bgra8unorm",
  [sym_bgra8unorm_srgb] = "bgra8unorm_srgb",
  [sym_rgb10a2unorm] = "rgb10a2unorm",
  [sym_rg11b10float] = "rg11b10float",
  [sym_rg32uint] = "rg32uint",
  [sym_rg32sint] = "rg32sint",
  [sym_rg32float] = "rg32float",
  [sym_rgba16uint] = "rgba16uint",
  [sym_rgba16sint] = "rgba16sint",
  [sym_rgba16float] = "rgba16float",
  [sym_rgba32uint] = "rgba32uint",
  [sym_rgba32sint] = "rgba32sint",
  [sym_rgba32float] = "rgba32float",
  [sym_and] = "and",
  [sym_and_and] = "and_and",
  [sym_arrow] = "arrow",
  [sym_attr_left] = "attr_left",
  [sym_attr_right] = "attr_right",
  [sym_forward_slash] = "forward_slash",
  [sym_bang] = "bang",
  [sym_bracket_left] = "bracket_left",
  [sym_bracket_right] = "bracket_right",
  [sym_brace_left] = "brace_left",
  [sym_brace_right] = "brace_right",
  [sym_colon] = "colon",
  [sym_comma] = "comma",
  [sym_equal] = "equal",
  [sym_equal_equal] = "equal_equal",
  [sym_not_equal] = "not_equal",
  [sym_greater_than] = "greater_than",
  [sym_greater_than_equal] = "greater_than_equal",
  [sym_shift_right] = "shift_right",
  [sym_less_than] = "less_than",
  [sym_less_than_equal] = "less_than_equal",
  [sym_shift_left] = "shift_left",
  [sym_modulo] = "modulo",
  [sym_minus] = "minus",
  [sym_period] = "period",
  [sym_plus] = "plus",
  [sym_plus_plus] = "plus_plus",
  [sym_or] = "or",
  [sym_or_or] = "or_or",
  [sym_paren_left] = "paren_left",
  [sym_paren_right] = "paren_right",
  [sym_semicolon] = "semicolon",
  [sym_star] = "star",
  [sym_tilde] = "tilde",
  [sym_underscore] = "underscore",
  [sym_xor] = "xor",
  [aux_sym__reserved_token1] = "_reserved_token1",
  [aux_sym__reserved_token2] = "_reserved_token2",
  [aux_sym__reserved_token3] = "_reserved_token3",
  [aux_sym__reserved_token4] = "_reserved_token4",
  [aux_sym__reserved_token5] = "_reserved_token5",
  [aux_sym__reserved_token6] = "_reserved_token6",
  [aux_sym__reserved_token7] = "_reserved_token7",
  [aux_sym__reserved_token8] = "_reserved_token8",
  [aux_sym__reserved_token9] = "_reserved_token9",
  [aux_sym__reserved_token10] = "_reserved_token10",
  [aux_sym__reserved_token11] = "_reserved_token11",
  [aux_sym__reserved_token12] = "_reserved_token12",
  [aux_sym__reserved_token13] = "_reserved_token13",
  [aux_sym__reserved_token14] = "_reserved_token14",
  [aux_sym__reserved_token15] = "_reserved_token15",
  [aux_sym__reserved_token16] = "_reserved_token16",
  [aux_sym__reserved_token17] = "_reserved_token17",
  [aux_sym__reserved_token18] = "_reserved_token18",
  [aux_sym__reserved_token19] = "_reserved_token19",
  [aux_sym__reserved_token20] = "_reserved_token20",
  [aux_sym__reserved_token21] = "_reserved_token21",
  [aux_sym__reserved_token22] = "_reserved_token22",
  [aux_sym__reserved_token23] = "_reserved_token23",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym__comment_token1] = "_comment_token1",
  [sym__space] = "_space",
  [sym__block_comment] = "_block_comment",
  [sym_translation_unit] = "translation_unit",
  [sym_global_directive] = "global_directive",
  [sym_const_literal] = "const_literal",
  [sym_float_literal] = "float_literal",
  [sym_attribute_list] = "attribute_list",
  [sym_attribute] = "attribute",
  [sym_literal_or_ident] = "literal_or_ident",
  [sym_array_type_decl] = "array_type_decl",
  [sym_element_count_expression] = "element_count_expression",
  [sym_struct_decl] = "struct_decl",
  [sym_struct_body_decl] = "struct_body_decl",
  [sym_struct_member] = "struct_member",
  [sym_access_mode] = "access_mode",
  [sym_storage_class] = "storage_class",
  [sym_texture_sampler_types] = "texture_sampler_types",
  [sym_sampler_type] = "sampler_type",
  [sym_sampled_texture_type] = "sampled_texture_type",
  [sym_multisampled_texture_type] = "multisampled_texture_type",
  [sym_storage_texture_type] = "storage_texture_type",
  [sym_depth_texture_type] = "depth_texture_type",
  [sym_texel_format] = "texel_format",
  [sym_type_alias_decl] = "type_alias_decl",
  [sym_type_decl] = "type_decl",
  [sym_variable_statement] = "variable_statement",
  [sym_variable_decl] = "variable_decl",
  [sym_variable_ident_decl] = "variable_ident_decl",
  [sym_variable_qualifier] = "variable_qualifier",
  [sym_global_variable_decl] = "global_variable_decl",
  [sym_global_constant_decl] = "global_constant_decl",
  [sym_global_const_initializer] = "global_const_initializer",
  [sym_const_expression] = "const_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_paren_expression] = "paren_expression",
  [sym_argument_expression_list] = "argument_expression_list",
  [sym_postfix_expression] = "postfix_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_singular_expression] = "singular_expression",
  [sym_lhs_expression] = "lhs_expression",
  [sym_core_lhs_expression] = "core_lhs_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_short_circuit_and_expression] = "short_circuit_and_expression",
  [sym_short_circuit_or_expression] = "short_circuit_or_expression",
  [sym_binary_or_expression] = "binary_or_expression",
  [sym_binary_and_expression] = "binary_and_expression",
  [sym_binary_xor_expression] = "binary_xor_expression",
  [sym_expression] = "expression",
  [sym_compound_statement] = "compound_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_if_statement] = "if_statement",
  [sym_else_statement] = "else_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_case_selectors] = "case_selectors",
  [sym_case_body] = "case_body",
  [sym_loop_statement] = "loop_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_header] = "for_header",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_continuing_statement] = "continuing_statement",
  [sym_return_statement] = "return_statement",
  [sym_func_call_statement] = "func_call_statement",
  [sym_statement] = "statement",
  [sym_function_decl] = "function_decl",
  [sym_function_header] = "function_header",
  [sym_param_list] = "param_list",
  [sym_param] = "param",
  [sym_enable_directive] = "enable_directive",
  [sym__comment] = "_comment",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_translation_unit_repeat2] = "translation_unit_repeat2",
  [aux_sym_attribute_list_repeat1] = "attribute_list_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_array_type_decl_repeat1] = "array_type_decl_repeat1",
  [aux_sym_struct_body_decl_repeat1] = "struct_body_decl_repeat1",
  [aux_sym_const_expression_repeat1] = "const_expression_repeat1",
  [aux_sym_argument_expression_list_repeat1] = "argument_expression_list_repeat1",
  [aux_sym_lhs_expression_repeat1] = "lhs_expression_repeat1",
  [aux_sym_compound_statement_repeat1] = "compound_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_selectors_repeat1] = "case_selectors_repeat1",
  [aux_sym_param_list_repeat1] = "param_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_ident] = sym_ident,
  [sym_decimal_float_literal] = sym_decimal_float_literal,
  [sym_hex_float_literal] = sym_hex_float_literal,
  [sym_int_literal] = sym_int_literal,
  [sym_uint_literal] = sym_uint_literal,
  [sym_array] = sym_array,
  [sym_atomic] = sym_atomic,
  [sym_bool] = sym_bool,
  [sym_float32] = sym_float32,
  [sym_int32] = sym_int32,
  [sym_mat2x2] = sym_mat2x2,
  [sym_mat2x3] = sym_mat2x3,
  [sym_mat2x4] = sym_mat2x4,
  [sym_mat3x2] = sym_mat3x2,
  [sym_mat3x3] = sym_mat3x3,
  [sym_mat3x4] = sym_mat3x4,
  [sym_mat4x2] = sym_mat4x2,
  [sym_mat4x3] = sym_mat4x3,
  [sym_mat4x4] = sym_mat4x4,
  [sym_pointer] = sym_pointer,
  [sym_sampler] = sym_sampler,
  [sym_sampler_comparison] = sym_sampler_comparison,
  [sym_struct] = sym_struct,
  [sym_texture_1d] = sym_texture_1d,
  [sym_texture_2d] = sym_texture_2d,
  [sym_texture_2d_array] = sym_texture_2d_array,
  [sym_texture_3d] = sym_texture_3d,
  [sym_texture_cube] = sym_texture_cube,
  [sym_texture_cube_array] = sym_texture_cube_array,
  [sym_texture_multisampled_2d] = sym_texture_multisampled_2d,
  [sym_texture_storage_1d] = sym_texture_storage_1d,
  [sym_texture_storage_2d] = sym_texture_storage_2d,
  [sym_texture_storage_2d_array] = sym_texture_storage_2d_array,
  [sym_texture_storage_3d] = sym_texture_storage_3d,
  [sym_texture_depth_2d] = sym_texture_depth_2d,
  [sym_texture_depth_2d_array] = sym_texture_depth_2d_array,
  [sym_texture_depth_cube] = sym_texture_depth_cube,
  [sym_texture_depth_cube_array] = sym_texture_depth_cube_array,
  [sym_texture_depth_multisampled_2d] = sym_texture_depth_multisampled_2d,
  [sym_uint32] = sym_uint32,
  [sym_vec2] = sym_vec2,
  [sym_vec3] = sym_vec3,
  [sym_vec4] = sym_vec4,
  [sym_bitcast] = sym_bitcast,
  [sym_block] = sym_block,
  [sym_break] = sym_break,
  [sym_case] = sym_case,
  [sym_continue] = sym_continue,
  [sym_continuing] = sym_continuing,
  [sym_default] = sym_default,
  [sym_discard] = sym_discard,
  [sym_else] = sym_else,
  [sym_enable] = sym_enable,
  [sym_fallthrough] = sym_fallthrough,
  [sym_false] = sym_false,
  [sym_fn] = sym_fn,
  [sym_for] = sym_for,
  [sym_function] = sym_function,
  [sym_if] = sym_if,
  [sym_let] = sym_let,
  [sym_loop] = sym_loop,
  [sym_private] = sym_private,
  [sym_read] = sym_read,
  [sym_read_write] = sym_read_write,
  [sym_return] = sym_return,
  [sym_storage] = sym_storage,
  [sym_switch] = sym_switch,
  [sym_true] = sym_true,
  [sym_type] = sym_type,
  [sym_uniform] = sym_uniform,
  [sym_var] = sym_var,
  [sym_workgroup] = sym_workgroup,
  [sym_write] = sym_write,
  [sym_r8unorm] = sym_r8unorm,
  [sym_r8snorm] = sym_r8snorm,
  [sym_r8uint] = sym_r8uint,
  [sym_r8sint] = sym_r8sint,
  [sym_r16uint] = sym_r16uint,
  [sym_r16sint] = sym_r16sint,
  [sym_r16float] = sym_r16float,
  [sym_rg8unorm] = sym_rg8unorm,
  [sym_rg8snorm] = sym_rg8snorm,
  [sym_rg8uint] = sym_rg8uint,
  [sym_rg8sint] = sym_rg8sint,
  [sym_r32uint] = sym_r32uint,
  [sym_r32sint] = sym_r32sint,
  [sym_r32float] = sym_r32float,
  [sym_rg16uint] = sym_rg16uint,
  [sym_rg16sint] = sym_rg16sint,
  [sym_rg16float] = sym_rg16float,
  [sym_rgba8unorm] = sym_rgba8unorm,
  [sym_rgba8unorm_srgb] = sym_rgba8unorm_srgb,
  [sym_rgba8snorm] = sym_rgba8snorm,
  [sym_rgba8uint] = sym_rgba8uint,
  [sym_rgba8sint] = sym_rgba8sint,
  [sym_bgra8unorm] = sym_bgra8unorm,
  [sym_bgra8unorm_srgb] = sym_bgra8unorm_srgb,
  [sym_rgb10a2unorm] = sym_rgb10a2unorm,
  [sym_rg11b10float] = sym_rg11b10float,
  [sym_rg32uint] = sym_rg32uint,
  [sym_rg32sint] = sym_rg32sint,
  [sym_rg32float] = sym_rg32float,
  [sym_rgba16uint] = sym_rgba16uint,
  [sym_rgba16sint] = sym_rgba16sint,
  [sym_rgba16float] = sym_rgba16float,
  [sym_rgba32uint] = sym_rgba32uint,
  [sym_rgba32sint] = sym_rgba32sint,
  [sym_rgba32float] = sym_rgba32float,
  [sym_and] = sym_and,
  [sym_and_and] = sym_and_and,
  [sym_arrow] = sym_arrow,
  [sym_attr_left] = sym_attr_left,
  [sym_attr_right] = sym_attr_right,
  [sym_forward_slash] = sym_forward_slash,
  [sym_bang] = sym_bang,
  [sym_bracket_left] = sym_bracket_left,
  [sym_bracket_right] = sym_bracket_right,
  [sym_brace_left] = sym_brace_left,
  [sym_brace_right] = sym_brace_right,
  [sym_colon] = sym_colon,
  [sym_comma] = sym_comma,
  [sym_equal] = sym_equal,
  [sym_equal_equal] = sym_equal_equal,
  [sym_not_equal] = sym_not_equal,
  [sym_greater_than] = sym_greater_than,
  [sym_greater_than_equal] = sym_greater_than_equal,
  [sym_shift_right] = sym_shift_right,
  [sym_less_than] = sym_less_than,
  [sym_less_than_equal] = sym_less_than_equal,
  [sym_shift_left] = sym_shift_left,
  [sym_modulo] = sym_modulo,
  [sym_minus] = sym_minus,
  [sym_period] = sym_period,
  [sym_plus] = sym_plus,
  [sym_plus_plus] = sym_plus_plus,
  [sym_or] = sym_or,
  [sym_or_or] = sym_or_or,
  [sym_paren_left] = sym_paren_left,
  [sym_paren_right] = sym_paren_right,
  [sym_semicolon] = sym_semicolon,
  [sym_star] = sym_star,
  [sym_tilde] = sym_tilde,
  [sym_underscore] = sym_underscore,
  [sym_xor] = sym_xor,
  [aux_sym__reserved_token1] = aux_sym__reserved_token1,
  [aux_sym__reserved_token2] = aux_sym__reserved_token2,
  [aux_sym__reserved_token3] = aux_sym__reserved_token3,
  [aux_sym__reserved_token4] = aux_sym__reserved_token4,
  [aux_sym__reserved_token5] = aux_sym__reserved_token5,
  [aux_sym__reserved_token6] = aux_sym__reserved_token6,
  [aux_sym__reserved_token7] = aux_sym__reserved_token7,
  [aux_sym__reserved_token8] = aux_sym__reserved_token8,
  [aux_sym__reserved_token9] = aux_sym__reserved_token9,
  [aux_sym__reserved_token10] = aux_sym__reserved_token10,
  [aux_sym__reserved_token11] = aux_sym__reserved_token11,
  [aux_sym__reserved_token12] = aux_sym__reserved_token12,
  [aux_sym__reserved_token13] = aux_sym__reserved_token13,
  [aux_sym__reserved_token14] = aux_sym__reserved_token14,
  [aux_sym__reserved_token15] = aux_sym__reserved_token15,
  [aux_sym__reserved_token16] = aux_sym__reserved_token16,
  [aux_sym__reserved_token17] = aux_sym__reserved_token17,
  [aux_sym__reserved_token18] = aux_sym__reserved_token18,
  [aux_sym__reserved_token19] = aux_sym__reserved_token19,
  [aux_sym__reserved_token20] = aux_sym__reserved_token20,
  [aux_sym__reserved_token21] = aux_sym__reserved_token21,
  [aux_sym__reserved_token22] = aux_sym__reserved_token22,
  [aux_sym__reserved_token23] = aux_sym__reserved_token23,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym__comment_token1] = aux_sym__comment_token1,
  [sym__space] = sym__space,
  [sym__block_comment] = sym__block_comment,
  [sym_translation_unit] = sym_translation_unit,
  [sym_global_directive] = sym_global_directive,
  [sym_const_literal] = sym_const_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_attribute_list] = sym_attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_literal_or_ident] = sym_literal_or_ident,
  [sym_array_type_decl] = sym_array_type_decl,
  [sym_element_count_expression] = sym_element_count_expression,
  [sym_struct_decl] = sym_struct_decl,
  [sym_struct_body_decl] = sym_struct_body_decl,
  [sym_struct_member] = sym_struct_member,
  [sym_access_mode] = sym_access_mode,
  [sym_storage_class] = sym_storage_class,
  [sym_texture_sampler_types] = sym_texture_sampler_types,
  [sym_sampler_type] = sym_sampler_type,
  [sym_sampled_texture_type] = sym_sampled_texture_type,
  [sym_multisampled_texture_type] = sym_multisampled_texture_type,
  [sym_storage_texture_type] = sym_storage_texture_type,
  [sym_depth_texture_type] = sym_depth_texture_type,
  [sym_texel_format] = sym_texel_format,
  [sym_type_alias_decl] = sym_type_alias_decl,
  [sym_type_decl] = sym_type_decl,
  [sym_variable_statement] = sym_variable_statement,
  [sym_variable_decl] = sym_variable_decl,
  [sym_variable_ident_decl] = sym_variable_ident_decl,
  [sym_variable_qualifier] = sym_variable_qualifier,
  [sym_global_variable_decl] = sym_global_variable_decl,
  [sym_global_constant_decl] = sym_global_constant_decl,
  [sym_global_const_initializer] = sym_global_const_initializer,
  [sym_const_expression] = sym_const_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_paren_expression] = sym_paren_expression,
  [sym_argument_expression_list] = sym_argument_expression_list,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_singular_expression] = sym_singular_expression,
  [sym_lhs_expression] = sym_lhs_expression,
  [sym_core_lhs_expression] = sym_core_lhs_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_short_circuit_and_expression] = sym_short_circuit_and_expression,
  [sym_short_circuit_or_expression] = sym_short_circuit_or_expression,
  [sym_binary_or_expression] = sym_binary_or_expression,
  [sym_binary_and_expression] = sym_binary_and_expression,
  [sym_binary_xor_expression] = sym_binary_xor_expression,
  [sym_expression] = sym_expression,
  [sym_compound_statement] = sym_compound_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_case_selectors] = sym_case_selectors,
  [sym_case_body] = sym_case_body,
  [sym_loop_statement] = sym_loop_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_header] = sym_for_header,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_continuing_statement] = sym_continuing_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_func_call_statement] = sym_func_call_statement,
  [sym_statement] = sym_statement,
  [sym_function_decl] = sym_function_decl,
  [sym_function_header] = sym_function_header,
  [sym_param_list] = sym_param_list,
  [sym_param] = sym_param,
  [sym_enable_directive] = sym_enable_directive,
  [sym__comment] = sym__comment,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_translation_unit_repeat2] = aux_sym_translation_unit_repeat2,
  [aux_sym_attribute_list_repeat1] = aux_sym_attribute_list_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_array_type_decl_repeat1] = aux_sym_array_type_decl_repeat1,
  [aux_sym_struct_body_decl_repeat1] = aux_sym_struct_body_decl_repeat1,
  [aux_sym_const_expression_repeat1] = aux_sym_const_expression_repeat1,
  [aux_sym_argument_expression_list_repeat1] = aux_sym_argument_expression_list_repeat1,
  [aux_sym_lhs_expression_repeat1] = aux_sym_lhs_expression_repeat1,
  [aux_sym_compound_statement_repeat1] = aux_sym_compound_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_selectors_repeat1] = aux_sym_case_selectors_repeat1,
  [aux_sym_param_list_repeat1] = aux_sym_param_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_uint_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_float32] = {
    .visible = true,
    .named = true,
  },
  [sym_int32] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x4] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_comparison] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_uint32] = {
    .visible = true,
    .named = true,
  },
  [sym_vec2] = {
    .visible = true,
    .named = true,
  },
  [sym_vec3] = {
    .visible = true,
    .named = true,
  },
  [sym_vec4] = {
    .visible = true,
    .named = true,
  },
  [sym_bitcast] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing] = {
    .visible = true,
    .named = true,
  },
  [sym_default] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_enable] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_fn] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_private] = {
    .visible = true,
    .named = true,
  },
  [sym_read] = {
    .visible = true,
    .named = true,
  },
  [sym_read_write] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_storage] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_uniform] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [sym_workgroup] = {
    .visible = true,
    .named = true,
  },
  [sym_write] = {
    .visible = true,
    .named = true,
  },
  [sym_r8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_r8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_r8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8unorm_srgb] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_bgra8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_bgra8unorm_srgb] = {
    .visible = true,
    .named = true,
  },
  [sym_rgb10a2unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg11b10float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32float] = {
    .visible = true,
    .named = true,
  },
  [sym_and] = {
    .visible = true,
    .named = true,
  },
  [sym_and_and] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_attr_left] = {
    .visible = true,
    .named = true,
  },
  [sym_attr_right] = {
    .visible = true,
    .named = true,
  },
  [sym_forward_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_left] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_right] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_left] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_right] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_equal_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left] = {
    .visible = true,
    .named = true,
  },
  [sym_modulo] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_period] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_or] = {
    .visible = true,
    .named = true,
  },
  [sym_or_or] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_left] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_right] = {
    .visible = true,
    .named = true,
  },
  [sym_semicolon] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_tilde] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_xor] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__reserved_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token9] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token10] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token11] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token12] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token13] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token14] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token15] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token16] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token17] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token18] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token19] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token20] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token21] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token22] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token23] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__space] = {
    .visible = false,
    .named = true,
  },
  [sym__block_comment] = {
    .visible = false,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_global_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_const_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_or_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_element_count_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_access_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_sampler_types] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_type] = {
    .visible = true,
    .named = true,
  },
  [sym_sampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_multisampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_depth_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_texel_format] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ident_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_global_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_constant_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_const_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_const_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_singular_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_lhs_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_core_lhs_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_xor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_case_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_case_body] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_header] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_func_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_param_list] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_enable_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_translation_unit_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lhs_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_param_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(28);
      if (lookahead == '!') ADVANCE(52);
      if (lookahead == '%') ADVANCE(72);
      if (lookahead == '&') ADVANCE(45);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(77);
      if (lookahead == '/') ADVANCE(50);
      if (lookahead == '0') ADVANCE(33);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(65);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(89);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(55);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '}') ADVANCE(56);
      if (lookahead == '~') ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '%') ADVANCE(72);
      if (lookahead == '&') ADVANCE(45);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '+') ADVANCE(78);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == '/') ADVANCE(50);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(65);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(89);
      if (lookahead == '{') ADVANCE(55);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '%') ADVANCE(72);
      if (lookahead == '&') ADVANCE(45);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '+') ADVANCE(78);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == '/') ADVANCE(50);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(60);
      if (lookahead == '>') ADVANCE(65);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '^') ADVANCE(89);
      if (lookahead == '|') ADVANCE(81);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(13);
      if (lookahead == '%') ADVANCE(72);
      if (lookahead == '&') ADVANCE(4);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '+') ADVANCE(78);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == '/') ADVANCE(50);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '<') ADVANCE(69);
      if (lookahead == '=') ADVANCE(14);
      if (lookahead == '>') ADVANCE(64);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '|') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      END_STATE();
    case 4:
      if (lookahead == '&') ADVANCE(46);
      END_STATE();
    case 5:
      if (lookahead == '&') ADVANCE(44);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(12);
      if (lookahead == '.') ADVANCE(76);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '0') ADVANCE(38);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '[') ADVANCE(53);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '{') ADVANCE(55);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(39);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 6:
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == ']') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      END_STATE();
    case 7:
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'x') ADVANCE(10);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == '/') ADVANCE(91);
      END_STATE();
    case 12:
      if (lookahead == '0') ADVANCE(17);
      if (lookahead == '>') ADVANCE(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(62);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(61);
      END_STATE();
    case 15:
      if (lookahead == '[') ADVANCE(48);
      END_STATE();
    case 16:
      if (lookahead == ']') ADVANCE(49);
      END_STATE();
    case 17:
      if (lookahead == 'x') ADVANCE(26);
      END_STATE();
    case 18:
      if (lookahead == '|') ADVANCE(82);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(30);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 27:
      if (eof) ADVANCE(28);
      if (lookahead == '!') ADVANCE(51);
      if (lookahead == '&') ADVANCE(44);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == ',') ADVANCE(58);
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '0') ADVANCE(33);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(85);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(63);
      if (lookahead == '[') ADVANCE(15);
      if (lookahead == ']') ADVANCE(54);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(55);
      if (lookahead == '}') ADVANCE(56);
      if (lookahead == '~') ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(30);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_hex_float_literal);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_hex_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(9);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(8);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (lookahead == 'u') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(31);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(25);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_uint_literal);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_and);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_and);
      if (lookahead == '&') ADVANCE(46);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_and_and);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_attr_left);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_attr_right);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_forward_slash);
      if (lookahead == '/') ADVANCE(91);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_bang);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_bang);
      if (lookahead == '=') ADVANCE(62);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_bracket_left);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_bracket_right);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_brace_left);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_brace_right);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_equal);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_equal);
      if (lookahead == '=') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_equal_equal);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_not_equal);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_greater_than);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(66);
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_greater_than_equal);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_shift_right);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '<') ADVANCE(71);
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_less_than_equal);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_shift_left);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_modulo);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_minus);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '0') ADVANCE(7);
      if (lookahead == '>') ADVANCE(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '0') ADVANCE(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_period);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_period);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(80);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_plus_plus);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_or);
      if (lookahead == '|') ADVANCE(82);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_or_or);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_paren_left);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_paren_right);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_semicolon);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_tilde);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_underscore);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_xor);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead == '\n') ADVANCE(96);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(95);
      if (lookahead != 0) ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym__space);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'g') ADVANCE(22);
      if (lookahead == 'i') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == '1') ADVANCE(34);
      if (lookahead == '3') ADVANCE(35);
      if (lookahead == '6') ADVANCE(36);
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(42);
      if (lookahead == '3') ADVANCE(43);
      if (lookahead == '6') ADVANCE(44);
      if (lookahead == '8') ADVANCE(45);
      if (lookahead == 'f') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == '1') ADVANCE(52);
      if (lookahead == '3') ADVANCE(53);
      if (lookahead == '8') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'g') ADVANCE(56);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(57);
      if (lookahead == 't') ADVANCE(58);
      if (lookahead == 'w') ADVANCE(59);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(61);
      if (lookahead == 'y') ADVANCE(62);
      END_STATE();
    case 15:
      if (lookahead == '1') ADVANCE(63);
      if (lookahead == '3') ADVANCE(64);
      if (lookahead == '6') ADVANCE(65);
      if (lookahead == '8') ADVANCE(66);
      if (lookahead == 'n') ADVANCE(67);
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(69);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 19:
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 21:
      if (lookahead == '1') ADVANCE(78);
      END_STATE();
    case 22:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym__reserved_token4);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(89);
      if (lookahead == 'u') ADVANCE(90);
      END_STATE();
    case 34:
      if (lookahead == '6') ADVANCE(91);
      END_STATE();
    case 35:
      if (lookahead == '2') ADVANCE(92);
      END_STATE();
    case 36:
      if (lookahead == '4') ADVANCE(93);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_fn);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 42:
      if (lookahead == '6') ADVANCE(98);
      END_STATE();
    case 43:
      if (lookahead == '2') ADVANCE(99);
      END_STATE();
    case 44:
      if (lookahead == '4') ADVANCE(100);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__reserved_token9);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_if);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 52:
      if (lookahead == '6') ADVANCE(107);
      END_STATE();
    case 53:
      if (lookahead == '2') ADVANCE(108);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(111);
      if (lookahead == 'g') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 56:
      if (lookahead == '1') ADVANCE(114);
      if (lookahead == '3') ADVANCE(115);
      if (lookahead == '8') ADVANCE(116);
      if (lookahead == 'b') ADVANCE(117);
      END_STATE();
    case 57:
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(119);
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 60:
      if (lookahead == 'x') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(124);
      END_STATE();
    case 63:
      if (lookahead == '6') ADVANCE(125);
      END_STATE();
    case 64:
      if (lookahead == '2') ADVANCE(126);
      END_STATE();
    case 65:
      if (lookahead == '4') ADVANCE(127);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym__reserved_token16);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__reserved_token1);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(138);
      END_STATE();
    case 78:
      if (lookahead == '6') ADVANCE(139);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(146);
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(148);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(149);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 89:
      if (lookahead == 'b') ADVANCE(151);
      END_STATE();
    case 90:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__reserved_token6);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_float32);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__reserved_token7);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(153);
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_for);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(156);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__reserved_token10);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_int32);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__reserved_token11);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_let);
      END_STATE();
    case 102:
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym__reserved_token12);
      if (lookahead == '2') ADVANCE(158);
      if (lookahead == '3') ADVANCE(159);
      if (lookahead == '4') ADVANCE(160);
      END_STATE();
    case 104:
      if (lookahead == 'm') ADVANCE(161);
      END_STATE();
    case 105:
      if (lookahead == 'v') ADVANCE(162);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_pointer);
      END_STATE();
    case 107:
      if (lookahead == 'f') ADVANCE(163);
      if (lookahead == 's') ADVANCE(164);
      if (lookahead == 'u') ADVANCE(165);
      END_STATE();
    case 108:
      if (lookahead == 'f') ADVANCE(166);
      if (lookahead == 's') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(171);
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 111:
      if (lookahead == 'd') ADVANCE(173);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(175);
      END_STATE();
    case 114:
      if (lookahead == '1') ADVANCE(176);
      if (lookahead == '6') ADVANCE(177);
      END_STATE();
    case 115:
      if (lookahead == '2') ADVANCE(178);
      END_STATE();
    case 116:
      if (lookahead == 's') ADVANCE(179);
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 117:
      if (lookahead == '1') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 118:
      if (lookahead == 'p') ADVANCE(183);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__reserved_token17);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_uint32);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__reserved_token18);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(190);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(192);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_var);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__reserved_token21);
      if (lookahead == '2') ADVANCE(193);
      if (lookahead == '3') ADVANCE(194);
      if (lookahead == '4') ADVANCE(195);
      END_STATE();
    case 133:
      if (lookahead == 'd') ADVANCE(196);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 135:
      if (lookahead == 'k') ADVANCE(198);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 137:
      if (lookahead == 'y') ADVANCE(200);
      END_STATE();
    case 138:
      if (lookahead == 'i') ADVANCE(201);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym__reserved_token2);
      END_STATE();
    case 140:
      if (lookahead == '8') ADVANCE(202);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 142:
      if (lookahead == 'k') ADVANCE(204);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_bool);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(205);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_case);
      END_STATE();
    case 146:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 148:
      if (lookahead == 'u') ADVANCE(208);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_else);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__reserved_token5);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_loop);
      END_STATE();
    case 158:
      if (lookahead == 'x') ADVANCE(215);
      END_STATE();
    case 159:
      if (lookahead == 'x') ADVANCE(216);
      END_STATE();
    case 160:
      if (lookahead == 'x') ADVANCE(217);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(219);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(220);
      END_STATE();
    case 164:
      if (lookahead == 'i') ADVANCE(221);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 166:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(224);
      END_STATE();
    case 168:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(227);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 172:
      if (lookahead == 'o') ADVANCE(229);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_read);
      if (lookahead == '_') ADVANCE(230);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 176:
      if (lookahead == 'b') ADVANCE(233);
      END_STATE();
    case 177:
      if (lookahead == 'f') ADVANCE(234);
      if (lookahead == 's') ADVANCE(235);
      if (lookahead == 'u') ADVANCE(236);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(237);
      if (lookahead == 's') ADVANCE(238);
      if (lookahead == 'u') ADVANCE(239);
      END_STATE();
    case 179:
      if (lookahead == 'i') ADVANCE(240);
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(243);
      END_STATE();
    case 181:
      if (lookahead == '0') ADVANCE(244);
      END_STATE();
    case 182:
      if (lookahead == '1') ADVANCE(245);
      if (lookahead == '3') ADVANCE(246);
      if (lookahead == '8') ADVANCE(247);
      END_STATE();
    case 183:
      if (lookahead == 'l') ADVANCE(248);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(249);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(250);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(251);
      END_STATE();
    case 187:
      if (lookahead == 'u') ADVANCE(252);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_type);
      if (lookahead == 'd') ADVANCE(253);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(254);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(255);
      END_STATE();
    case 192:
      if (lookahead == 'g') ADVANCE(256);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_vec2);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_vec3);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_vec4);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__reserved_token22);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 198:
      if (lookahead == 'g') ADVANCE(258);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(259);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_array);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 202:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 203:
      if (lookahead == 's') ADVANCE(262);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_block);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym__reserved_token3);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 208:
      if (lookahead == 'l') ADVANCE(264);
      END_STATE();
    case 209:
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 211:
      if (lookahead == 'h') ADVANCE(267);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 213:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 215:
      if (lookahead == '2') ADVANCE(270);
      if (lookahead == '3') ADVANCE(271);
      if (lookahead == '4') ADVANCE(272);
      END_STATE();
    case 216:
      if (lookahead == '2') ADVANCE(273);
      if (lookahead == '3') ADVANCE(274);
      if (lookahead == '4') ADVANCE(275);
      END_STATE();
    case 217:
      if (lookahead == '2') ADVANCE(276);
      if (lookahead == '3') ADVANCE(277);
      if (lookahead == '4') ADVANCE(278);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(279);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(280);
      END_STATE();
    case 220:
      if (lookahead == 'o') ADVANCE(281);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 223:
      if (lookahead == 'o') ADVANCE(284);
      END_STATE();
    case 224:
      if (lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 225:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 227:
      if (lookahead == 'r') ADVANCE(288);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 229:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 230:
      if (lookahead == 'w') ADVANCE(291);
      END_STATE();
    case 231:
      if (lookahead == 'd') ADVANCE(292);
      END_STATE();
    case 232:
      if (lookahead == 'n') ADVANCE(293);
      END_STATE();
    case 233:
      if (lookahead == '1') ADVANCE(294);
      END_STATE();
    case 234:
      if (lookahead == 'l') ADVANCE(295);
      END_STATE();
    case 235:
      if (lookahead == 'i') ADVANCE(296);
      END_STATE();
    case 236:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 237:
      if (lookahead == 'l') ADVANCE(298);
      END_STATE();
    case 238:
      if (lookahead == 'i') ADVANCE(299);
      END_STATE();
    case 239:
      if (lookahead == 'i') ADVANCE(300);
      END_STATE();
    case 240:
      if (lookahead == 'n') ADVANCE(301);
      END_STATE();
    case 241:
      if (lookahead == 'o') ADVANCE(302);
      END_STATE();
    case 242:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 243:
      if (lookahead == 'o') ADVANCE(304);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 245:
      if (lookahead == '6') ADVANCE(306);
      END_STATE();
    case 246:
      if (lookahead == '2') ADVANCE(307);
      END_STATE();
    case 247:
      if (lookahead == 's') ADVANCE(308);
      if (lookahead == 'u') ADVANCE(309);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 249:
      if (lookahead == 'g') ADVANCE(311);
      END_STATE();
    case 250:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 251:
      if (lookahead == 'h') ADVANCE(313);
      END_STATE();
    case 252:
      if (lookahead == 'r') ADVANCE(314);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 254:
      if (lookahead == 'r') ADVANCE(316);
      END_STATE();
    case 255:
      if (lookahead == 's') ADVANCE(317);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(aux_sym__reserved_token20);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(aux_sym__reserved_token23);
      END_STATE();
    case 258:
      if (lookahead == 'r') ADVANCE(318);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_write);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_atomic);
      END_STATE();
    case 261:
      if (lookahead == 'n') ADVANCE(319);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 263:
      if (lookahead == 'u') ADVANCE(321);
      END_STATE();
    case 264:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 265:
      if (lookahead == 'd') ADVANCE(323);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_enable);
      END_STATE();
    case 267:
      if (lookahead == 'r') ADVANCE(324);
      END_STATE();
    case 268:
      if (lookahead == 'o') ADVANCE(325);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(aux_sym__reserved_token8);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_mat2x2);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_mat2x3);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_mat2x4);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_mat3x2);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_mat3x3);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_mat3x4);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_mat4x2);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_mat4x3);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_mat4x4);
      END_STATE();
    case 279:
      if (lookahead == 'g') ADVANCE(326);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(327);
      END_STATE();
    case 281:
      if (lookahead == 'a') ADVANCE(328);
      END_STATE();
    case 282:
      if (lookahead == 't') ADVANCE(329);
      END_STATE();
    case 283:
      if (lookahead == 't') ADVANCE(330);
      END_STATE();
    case 284:
      if (lookahead == 'a') ADVANCE(331);
      END_STATE();
    case 285:
      if (lookahead == 't') ADVANCE(332);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(333);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_r8sint);
      END_STATE();
    case 288:
      if (lookahead == 'm') ADVANCE(334);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_r8uint);
      END_STATE();
    case 290:
      if (lookahead == 'm') ADVANCE(335);
      END_STATE();
    case 291:
      if (lookahead == 'r') ADVANCE(336);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(337);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 294:
      if (lookahead == '0') ADVANCE(338);
      END_STATE();
    case 295:
      if (lookahead == 'o') ADVANCE(339);
      END_STATE();
    case 296:
      if (lookahead == 'n') ADVANCE(340);
      END_STATE();
    case 297:
      if (lookahead == 'n') ADVANCE(341);
      END_STATE();
    case 298:
      if (lookahead == 'o') ADVANCE(342);
      END_STATE();
    case 299:
      if (lookahead == 'n') ADVANCE(343);
      END_STATE();
    case 300:
      if (lookahead == 'n') ADVANCE(344);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 302:
      if (lookahead == 'r') ADVANCE(346);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 304:
      if (lookahead == 'r') ADVANCE(348);
      END_STATE();
    case 305:
      if (lookahead == '2') ADVANCE(349);
      END_STATE();
    case 306:
      if (lookahead == 'f') ADVANCE(350);
      if (lookahead == 's') ADVANCE(351);
      if (lookahead == 'u') ADVANCE(352);
      END_STATE();
    case 307:
      if (lookahead == 'f') ADVANCE(353);
      if (lookahead == 's') ADVANCE(354);
      if (lookahead == 'u') ADVANCE(355);
      END_STATE();
    case 308:
      if (lookahead == 'i') ADVANCE(356);
      if (lookahead == 'n') ADVANCE(357);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == 'n') ADVANCE(359);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(360);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(361);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_struct);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_switch);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(362);
      END_STATE();
    case 315:
      if (lookahead == 'f') ADVANCE(363);
      END_STATE();
    case 316:
      if (lookahead == 'm') ADVANCE(364);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(aux_sym__reserved_token19);
      END_STATE();
    case 318:
      if (lookahead == 'o') ADVANCE(365);
      END_STATE();
    case 319:
      if (lookahead == 'o') ADVANCE(366);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_bitcast);
      END_STATE();
    case 321:
      if (lookahead == 'e') ADVANCE(367);
      if (lookahead == 'i') ADVANCE(368);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_default);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_discard);
      END_STATE();
    case 324:
      if (lookahead == 'o') ADVANCE(369);
      END_STATE();
    case 325:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(371);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_private);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_r16sint);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_r16uint);
      END_STATE();
    case 331:
      if (lookahead == 't') ADVANCE(373);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_r32sint);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_r32uint);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_r8snorm);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_r8unorm);
      END_STATE();
    case 336:
      if (lookahead == 'i') ADVANCE(374);
      END_STATE();
    case 337:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 338:
      if (lookahead == 'f') ADVANCE(376);
      END_STATE();
    case 339:
      if (lookahead == 'a') ADVANCE(377);
      END_STATE();
    case 340:
      if (lookahead == 't') ADVANCE(378);
      END_STATE();
    case 341:
      if (lookahead == 't') ADVANCE(379);
      END_STATE();
    case 342:
      if (lookahead == 'a') ADVANCE(380);
      END_STATE();
    case 343:
      if (lookahead == 't') ADVANCE(381);
      END_STATE();
    case 344:
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_rg8sint);
      END_STATE();
    case 346:
      if (lookahead == 'm') ADVANCE(383);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_rg8uint);
      END_STATE();
    case 348:
      if (lookahead == 'm') ADVANCE(384);
      END_STATE();
    case 349:
      if (lookahead == 'u') ADVANCE(385);
      END_STATE();
    case 350:
      if (lookahead == 'l') ADVANCE(386);
      END_STATE();
    case 351:
      if (lookahead == 'i') ADVANCE(387);
      END_STATE();
    case 352:
      if (lookahead == 'i') ADVANCE(388);
      END_STATE();
    case 353:
      if (lookahead == 'l') ADVANCE(389);
      END_STATE();
    case 354:
      if (lookahead == 'i') ADVANCE(390);
      END_STATE();
    case 355:
      if (lookahead == 'i') ADVANCE(391);
      END_STATE();
    case 356:
      if (lookahead == 'n') ADVANCE(392);
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(393);
      END_STATE();
    case 358:
      if (lookahead == 'n') ADVANCE(394);
      END_STATE();
    case 359:
      if (lookahead == 'o') ADVANCE(395);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_sampler);
      if (lookahead == '_') ADVANCE(396);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_storage);
      END_STATE();
    case 362:
      if (lookahead == '_') ADVANCE(397);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(aux_sym__reserved_token15);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_uniform);
      END_STATE();
    case 365:
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 366:
      if (lookahead == 'r') ADVANCE(399);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 368:
      if (lookahead == 'n') ADVANCE(400);
      END_STATE();
    case 369:
      if (lookahead == 'u') ADVANCE(401);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_function);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(aux_sym__reserved_token13);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_r16float);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_r32float);
      END_STATE();
    case 374:
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 375:
      if (lookahead == 's') ADVANCE(403);
      END_STATE();
    case 376:
      if (lookahead == 'l') ADVANCE(404);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(405);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_rg16sint);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_rg16uint);
      END_STATE();
    case 380:
      if (lookahead == 't') ADVANCE(406);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_rg32sint);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_rg32uint);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_rg8snorm);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_rg8unorm);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(407);
      END_STATE();
    case 386:
      if (lookahead == 'o') ADVANCE(408);
      END_STATE();
    case 387:
      if (lookahead == 'n') ADVANCE(409);
      END_STATE();
    case 388:
      if (lookahead == 'n') ADVANCE(410);
      END_STATE();
    case 389:
      if (lookahead == 'o') ADVANCE(411);
      END_STATE();
    case 390:
      if (lookahead == 'n') ADVANCE(412);
      END_STATE();
    case 391:
      if (lookahead == 'n') ADVANCE(413);
      END_STATE();
    case 392:
      if (lookahead == 't') ADVANCE(414);
      END_STATE();
    case 393:
      if (lookahead == 'r') ADVANCE(415);
      END_STATE();
    case 394:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 395:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 396:
      if (lookahead == 'c') ADVANCE(418);
      END_STATE();
    case 397:
      if (lookahead == '1') ADVANCE(419);
      if (lookahead == '2') ADVANCE(420);
      if (lookahead == '3') ADVANCE(421);
      if (lookahead == 'c') ADVANCE(422);
      if (lookahead == 'd') ADVANCE(423);
      if (lookahead == 'm') ADVANCE(424);
      if (lookahead == 's') ADVANCE(425);
      END_STATE();
    case 398:
      if (lookahead == 'p') ADVANCE(426);
      END_STATE();
    case 399:
      if (lookahead == 'm') ADVANCE(427);
      END_STATE();
    case 400:
      if (lookahead == 'g') ADVANCE(428);
      END_STATE();
    case 401:
      if (lookahead == 'g') ADVANCE(429);
      END_STATE();
    case 402:
      if (lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 403:
      if (lookahead == 's') ADVANCE(431);
      END_STATE();
    case 404:
      if (lookahead == 'o') ADVANCE(432);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_rg16float);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_rg32float);
      END_STATE();
    case 407:
      if (lookahead == 'o') ADVANCE(433);
      END_STATE();
    case 408:
      if (lookahead == 'a') ADVANCE(434);
      END_STATE();
    case 409:
      if (lookahead == 't') ADVANCE(435);
      END_STATE();
    case 410:
      if (lookahead == 't') ADVANCE(436);
      END_STATE();
    case 411:
      if (lookahead == 'a') ADVANCE(437);
      END_STATE();
    case 412:
      if (lookahead == 't') ADVANCE(438);
      END_STATE();
    case 413:
      if (lookahead == 't') ADVANCE(439);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_rgba8sint);
      END_STATE();
    case 415:
      if (lookahead == 'm') ADVANCE(440);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_rgba8uint);
      END_STATE();
    case 417:
      if (lookahead == 'm') ADVANCE(441);
      END_STATE();
    case 418:
      if (lookahead == 'o') ADVANCE(442);
      END_STATE();
    case 419:
      if (lookahead == 'd') ADVANCE(443);
      END_STATE();
    case 420:
      if (lookahead == 'd') ADVANCE(444);
      END_STATE();
    case 421:
      if (lookahead == 'd') ADVANCE(445);
      END_STATE();
    case 422:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 423:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 424:
      if (lookahead == 'u') ADVANCE(448);
      END_STATE();
    case 425:
      if (lookahead == 't') ADVANCE(449);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_workgroup);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_bgra8unorm);
      if (lookahead == '_') ADVANCE(450);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_continuing);
      END_STATE();
    case 429:
      if (lookahead == 'h') ADVANCE(451);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_read_write);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(aux_sym__reserved_token14);
      END_STATE();
    case 432:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 433:
      if (lookahead == 'r') ADVANCE(453);
      END_STATE();
    case 434:
      if (lookahead == 't') ADVANCE(454);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_rgba16sint);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_rgba16uint);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(455);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_rgba32sint);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_rgba32uint);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_rgba8snorm);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_rgba8unorm);
      if (lookahead == '_') ADVANCE(456);
      END_STATE();
    case 442:
      if (lookahead == 'm') ADVANCE(457);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_texture_1d);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_texture_2d);
      if (lookahead == '_') ADVANCE(458);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_texture_3d);
      END_STATE();
    case 446:
      if (lookahead == 'b') ADVANCE(459);
      END_STATE();
    case 447:
      if (lookahead == 'p') ADVANCE(460);
      END_STATE();
    case 448:
      if (lookahead == 'l') ADVANCE(461);
      END_STATE();
    case 449:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 450:
      if (lookahead == 's') ADVANCE(463);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_fallthrough);
      END_STATE();
    case 452:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 453:
      if (lookahead == 'm') ADVANCE(465);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_rgba16float);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_rgba32float);
      END_STATE();
    case 456:
      if (lookahead == 's') ADVANCE(466);
      END_STATE();
    case 457:
      if (lookahead == 'p') ADVANCE(467);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(468);
      END_STATE();
    case 459:
      if (lookahead == 'e') ADVANCE(469);
      END_STATE();
    case 460:
      if (lookahead == 't') ADVANCE(470);
      END_STATE();
    case 461:
      if (lookahead == 't') ADVANCE(471);
      END_STATE();
    case 462:
      if (lookahead == 'r') ADVANCE(472);
      END_STATE();
    case 463:
      if (lookahead == 'r') ADVANCE(473);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_rg11b10float);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_rgb10a2unorm);
      END_STATE();
    case 466:
      if (lookahead == 'r') ADVANCE(474);
      END_STATE();
    case 467:
      if (lookahead == 'a') ADVANCE(475);
      END_STATE();
    case 468:
      if (lookahead == 'r') ADVANCE(476);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_texture_cube);
      if (lookahead == '_') ADVANCE(477);
      END_STATE();
    case 470:
      if (lookahead == 'h') ADVANCE(478);
      END_STATE();
    case 471:
      if (lookahead == 'i') ADVANCE(479);
      END_STATE();
    case 472:
      if (lookahead == 'a') ADVANCE(480);
      END_STATE();
    case 473:
      if (lookahead == 'g') ADVANCE(481);
      END_STATE();
    case 474:
      if (lookahead == 'g') ADVANCE(482);
      END_STATE();
    case 475:
      if (lookahead == 'r') ADVANCE(483);
      END_STATE();
    case 476:
      if (lookahead == 'r') ADVANCE(484);
      END_STATE();
    case 477:
      if (lookahead == 'a') ADVANCE(485);
      END_STATE();
    case 478:
      if (lookahead == '_') ADVANCE(486);
      END_STATE();
    case 479:
      if (lookahead == 's') ADVANCE(487);
      END_STATE();
    case 480:
      if (lookahead == 'g') ADVANCE(488);
      END_STATE();
    case 481:
      if (lookahead == 'b') ADVANCE(489);
      END_STATE();
    case 482:
      if (lookahead == 'b') ADVANCE(490);
      END_STATE();
    case 483:
      if (lookahead == 'i') ADVANCE(491);
      END_STATE();
    case 484:
      if (lookahead == 'a') ADVANCE(492);
      END_STATE();
    case 485:
      if (lookahead == 'r') ADVANCE(493);
      END_STATE();
    case 486:
      if (lookahead == '2') ADVANCE(494);
      if (lookahead == 'c') ADVANCE(495);
      if (lookahead == 'm') ADVANCE(496);
      END_STATE();
    case 487:
      if (lookahead == 'a') ADVANCE(497);
      END_STATE();
    case 488:
      if (lookahead == 'e') ADVANCE(498);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_bgra8unorm_srgb);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_rgba8unorm_srgb);
      END_STATE();
    case 491:
      if (lookahead == 's') ADVANCE(499);
      END_STATE();
    case 492:
      if (lookahead == 'y') ADVANCE(500);
      END_STATE();
    case 493:
      if (lookahead == 'r') ADVANCE(501);
      END_STATE();
    case 494:
      if (lookahead == 'd') ADVANCE(502);
      END_STATE();
    case 495:
      if (lookahead == 'u') ADVANCE(503);
      END_STATE();
    case 496:
      if (lookahead == 'u') ADVANCE(504);
      END_STATE();
    case 497:
      if (lookahead == 'm') ADVANCE(505);
      END_STATE();
    case 498:
      if (lookahead == '_') ADVANCE(506);
      END_STATE();
    case 499:
      if (lookahead == 'o') ADVANCE(507);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_texture_2d_array);
      END_STATE();
    case 501:
      if (lookahead == 'a') ADVANCE(508);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_texture_depth_2d);
      if (lookahead == '_') ADVANCE(509);
      END_STATE();
    case 503:
      if (lookahead == 'b') ADVANCE(510);
      END_STATE();
    case 504:
      if (lookahead == 'l') ADVANCE(511);
      END_STATE();
    case 505:
      if (lookahead == 'p') ADVANCE(512);
      END_STATE();
    case 506:
      if (lookahead == '1') ADVANCE(513);
      if (lookahead == '2') ADVANCE(514);
      if (lookahead == '3') ADVANCE(515);
      END_STATE();
    case 507:
      if (lookahead == 'n') ADVANCE(516);
      END_STATE();
    case 508:
      if (lookahead == 'y') ADVANCE(517);
      END_STATE();
    case 509:
      if (lookahead == 'a') ADVANCE(518);
      END_STATE();
    case 510:
      if (lookahead == 'e') ADVANCE(519);
      END_STATE();
    case 511:
      if (lookahead == 't') ADVANCE(520);
      END_STATE();
    case 512:
      if (lookahead == 'l') ADVANCE(521);
      END_STATE();
    case 513:
      if (lookahead == 'd') ADVANCE(522);
      END_STATE();
    case 514:
      if (lookahead == 'd') ADVANCE(523);
      END_STATE();
    case 515:
      if (lookahead == 'd') ADVANCE(524);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_sampler_comparison);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_texture_cube_array);
      END_STATE();
    case 518:
      if (lookahead == 'r') ADVANCE(525);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_texture_depth_cube);
      if (lookahead == '_') ADVANCE(526);
      END_STATE();
    case 520:
      if (lookahead == 'i') ADVANCE(527);
      END_STATE();
    case 521:
      if (lookahead == 'e') ADVANCE(528);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_texture_storage_1d);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_texture_storage_2d);
      if (lookahead == '_') ADVANCE(529);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_texture_storage_3d);
      END_STATE();
    case 525:
      if (lookahead == 'r') ADVANCE(530);
      END_STATE();
    case 526:
      if (lookahead == 'a') ADVANCE(531);
      END_STATE();
    case 527:
      if (lookahead == 's') ADVANCE(532);
      END_STATE();
    case 528:
      if (lookahead == 'd') ADVANCE(533);
      END_STATE();
    case 529:
      if (lookahead == 'a') ADVANCE(534);
      END_STATE();
    case 530:
      if (lookahead == 'a') ADVANCE(535);
      END_STATE();
    case 531:
      if (lookahead == 'r') ADVANCE(536);
      END_STATE();
    case 532:
      if (lookahead == 'a') ADVANCE(537);
      END_STATE();
    case 533:
      if (lookahead == '_') ADVANCE(538);
      END_STATE();
    case 534:
      if (lookahead == 'r') ADVANCE(539);
      END_STATE();
    case 535:
      if (lookahead == 'y') ADVANCE(540);
      END_STATE();
    case 536:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 537:
      if (lookahead == 'm') ADVANCE(542);
      END_STATE();
    case 538:
      if (lookahead == '2') ADVANCE(543);
      END_STATE();
    case 539:
      if (lookahead == 'r') ADVANCE(544);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_texture_depth_2d_array);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(545);
      END_STATE();
    case 542:
      if (lookahead == 'p') ADVANCE(546);
      END_STATE();
    case 543:
      if (lookahead == 'd') ADVANCE(547);
      END_STATE();
    case 544:
      if (lookahead == 'a') ADVANCE(548);
      END_STATE();
    case 545:
      if (lookahead == 'y') ADVANCE(549);
      END_STATE();
    case 546:
      if (lookahead == 'l') ADVANCE(550);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_texture_multisampled_2d);
      END_STATE();
    case 548:
      if (lookahead == 'y') ADVANCE(551);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_texture_depth_cube_array);
      END_STATE();
    case 550:
      if (lookahead == 'e') ADVANCE(552);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_texture_storage_2d_array);
      END_STATE();
    case 552:
      if (lookahead == 'd') ADVANCE(553);
      END_STATE();
    case 553:
      if (lookahead == '_') ADVANCE(554);
      END_STATE();
    case 554:
      if (lookahead == '2') ADVANCE(555);
      END_STATE();
    case 555:
      if (lookahead == 'd') ADVANCE(556);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_texture_depth_multisampled_2d);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 27, .external_lex_state = 1},
  [2] = {.lex_state = 27, .external_lex_state = 1},
  [3] = {.lex_state = 27, .external_lex_state = 1},
  [4] = {.lex_state = 27, .external_lex_state = 1},
  [5] = {.lex_state = 27, .external_lex_state = 1},
  [6] = {.lex_state = 27, .external_lex_state = 1},
  [7] = {.lex_state = 27, .external_lex_state = 1},
  [8] = {.lex_state = 27, .external_lex_state = 1},
  [9] = {.lex_state = 27, .external_lex_state = 1},
  [10] = {.lex_state = 27, .external_lex_state = 1},
  [11] = {.lex_state = 27, .external_lex_state = 1},
  [12] = {.lex_state = 27, .external_lex_state = 1},
  [13] = {.lex_state = 27, .external_lex_state = 1},
  [14] = {.lex_state = 27, .external_lex_state = 1},
  [15] = {.lex_state = 27, .external_lex_state = 1},
  [16] = {.lex_state = 27, .external_lex_state = 1},
  [17] = {.lex_state = 27, .external_lex_state = 1},
  [18] = {.lex_state = 27, .external_lex_state = 1},
  [19] = {.lex_state = 27, .external_lex_state = 1},
  [20] = {.lex_state = 27, .external_lex_state = 1},
  [21] = {.lex_state = 27, .external_lex_state = 1},
  [22] = {.lex_state = 27, .external_lex_state = 1},
  [23] = {.lex_state = 27, .external_lex_state = 1},
  [24] = {.lex_state = 27, .external_lex_state = 1},
  [25] = {.lex_state = 27, .external_lex_state = 1},
  [26] = {.lex_state = 27, .external_lex_state = 1},
  [27] = {.lex_state = 27, .external_lex_state = 1},
  [28] = {.lex_state = 27, .external_lex_state = 1},
  [29] = {.lex_state = 27, .external_lex_state = 1},
  [30] = {.lex_state = 27, .external_lex_state = 1},
  [31] = {.lex_state = 27, .external_lex_state = 1},
  [32] = {.lex_state = 27, .external_lex_state = 1},
  [33] = {.lex_state = 27, .external_lex_state = 1},
  [34] = {.lex_state = 27, .external_lex_state = 1},
  [35] = {.lex_state = 27, .external_lex_state = 1},
  [36] = {.lex_state = 27, .external_lex_state = 1},
  [37] = {.lex_state = 27, .external_lex_state = 1},
  [38] = {.lex_state = 27, .external_lex_state = 1},
  [39] = {.lex_state = 27, .external_lex_state = 1},
  [40] = {.lex_state = 27, .external_lex_state = 1},
  [41] = {.lex_state = 27, .external_lex_state = 1},
  [42] = {.lex_state = 27, .external_lex_state = 1},
  [43] = {.lex_state = 27, .external_lex_state = 1},
  [44] = {.lex_state = 27, .external_lex_state = 1},
  [45] = {.lex_state = 27, .external_lex_state = 1},
  [46] = {.lex_state = 27, .external_lex_state = 1},
  [47] = {.lex_state = 27, .external_lex_state = 1},
  [48] = {.lex_state = 27, .external_lex_state = 1},
  [49] = {.lex_state = 27, .external_lex_state = 1},
  [50] = {.lex_state = 27, .external_lex_state = 1},
  [51] = {.lex_state = 27, .external_lex_state = 1},
  [52] = {.lex_state = 27, .external_lex_state = 1},
  [53] = {.lex_state = 27, .external_lex_state = 1},
  [54] = {.lex_state = 27, .external_lex_state = 1},
  [55] = {.lex_state = 27, .external_lex_state = 1},
  [56] = {.lex_state = 27, .external_lex_state = 1},
  [57] = {.lex_state = 27, .external_lex_state = 1},
  [58] = {.lex_state = 27, .external_lex_state = 1},
  [59] = {.lex_state = 27, .external_lex_state = 1},
  [60] = {.lex_state = 27, .external_lex_state = 1},
  [61] = {.lex_state = 27, .external_lex_state = 1},
  [62] = {.lex_state = 27, .external_lex_state = 1},
  [63] = {.lex_state = 27, .external_lex_state = 1},
  [64] = {.lex_state = 27, .external_lex_state = 1},
  [65] = {.lex_state = 27, .external_lex_state = 1},
  [66] = {.lex_state = 27, .external_lex_state = 1},
  [67] = {.lex_state = 27, .external_lex_state = 1},
  [68] = {.lex_state = 27, .external_lex_state = 1},
  [69] = {.lex_state = 27, .external_lex_state = 1},
  [70] = {.lex_state = 27, .external_lex_state = 1},
  [71] = {.lex_state = 27, .external_lex_state = 1},
  [72] = {.lex_state = 27, .external_lex_state = 1},
  [73] = {.lex_state = 27, .external_lex_state = 1},
  [74] = {.lex_state = 27, .external_lex_state = 1},
  [75] = {.lex_state = 27, .external_lex_state = 1},
  [76] = {.lex_state = 27, .external_lex_state = 1},
  [77] = {.lex_state = 27, .external_lex_state = 1},
  [78] = {.lex_state = 0, .external_lex_state = 1},
  [79] = {.lex_state = 27, .external_lex_state = 1},
  [80] = {.lex_state = 27, .external_lex_state = 1},
  [81] = {.lex_state = 1, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 27, .external_lex_state = 1},
  [84] = {.lex_state = 27, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 1, .external_lex_state = 1},
  [87] = {.lex_state = 1, .external_lex_state = 1},
  [88] = {.lex_state = 1, .external_lex_state = 1},
  [89] = {.lex_state = 1, .external_lex_state = 1},
  [90] = {.lex_state = 1, .external_lex_state = 1},
  [91] = {.lex_state = 1, .external_lex_state = 1},
  [92] = {.lex_state = 1, .external_lex_state = 1},
  [93] = {.lex_state = 1, .external_lex_state = 1},
  [94] = {.lex_state = 1, .external_lex_state = 1},
  [95] = {.lex_state = 1, .external_lex_state = 1},
  [96] = {.lex_state = 1, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 1, .external_lex_state = 1},
  [100] = {.lex_state = 1, .external_lex_state = 1},
  [101] = {.lex_state = 1, .external_lex_state = 1},
  [102] = {.lex_state = 27, .external_lex_state = 1},
  [103] = {.lex_state = 1, .external_lex_state = 1},
  [104] = {.lex_state = 27, .external_lex_state = 1},
  [105] = {.lex_state = 3, .external_lex_state = 1},
  [106] = {.lex_state = 3, .external_lex_state = 1},
  [107] = {.lex_state = 27, .external_lex_state = 1},
  [108] = {.lex_state = 3, .external_lex_state = 1},
  [109] = {.lex_state = 27, .external_lex_state = 1},
  [110] = {.lex_state = 3, .external_lex_state = 1},
  [111] = {.lex_state = 27, .external_lex_state = 1},
  [112] = {.lex_state = 27, .external_lex_state = 1},
  [113] = {.lex_state = 27, .external_lex_state = 1},
  [114] = {.lex_state = 27, .external_lex_state = 1},
  [115] = {.lex_state = 27, .external_lex_state = 1},
  [116] = {.lex_state = 27, .external_lex_state = 1},
  [117] = {.lex_state = 27, .external_lex_state = 1},
  [118] = {.lex_state = 27, .external_lex_state = 1},
  [119] = {.lex_state = 3, .external_lex_state = 1},
  [120] = {.lex_state = 3, .external_lex_state = 1},
  [121] = {.lex_state = 3, .external_lex_state = 1},
  [122] = {.lex_state = 3, .external_lex_state = 1},
  [123] = {.lex_state = 1, .external_lex_state = 1},
  [124] = {.lex_state = 3, .external_lex_state = 1},
  [125] = {.lex_state = 3, .external_lex_state = 1},
  [126] = {.lex_state = 3, .external_lex_state = 1},
  [127] = {.lex_state = 3, .external_lex_state = 1},
  [128] = {.lex_state = 3, .external_lex_state = 1},
  [129] = {.lex_state = 3, .external_lex_state = 1},
  [130] = {.lex_state = 27, .external_lex_state = 1},
  [131] = {.lex_state = 27, .external_lex_state = 1},
  [132] = {.lex_state = 27, .external_lex_state = 1},
  [133] = {.lex_state = 3, .external_lex_state = 1},
  [134] = {.lex_state = 3, .external_lex_state = 1},
  [135] = {.lex_state = 3, .external_lex_state = 1},
  [136] = {.lex_state = 3, .external_lex_state = 1},
  [137] = {.lex_state = 3, .external_lex_state = 1},
  [138] = {.lex_state = 3, .external_lex_state = 1},
  [139] = {.lex_state = 3, .external_lex_state = 1},
  [140] = {.lex_state = 3, .external_lex_state = 1},
  [141] = {.lex_state = 3, .external_lex_state = 1},
  [142] = {.lex_state = 27, .external_lex_state = 1},
  [143] = {.lex_state = 3, .external_lex_state = 1},
  [144] = {.lex_state = 1, .external_lex_state = 1},
  [145] = {.lex_state = 27, .external_lex_state = 1},
  [146] = {.lex_state = 3, .external_lex_state = 1},
  [147] = {.lex_state = 3, .external_lex_state = 1},
  [148] = {.lex_state = 1, .external_lex_state = 1},
  [149] = {.lex_state = 1, .external_lex_state = 1},
  [150] = {.lex_state = 27, .external_lex_state = 1},
  [151] = {.lex_state = 27, .external_lex_state = 1},
  [152] = {.lex_state = 27, .external_lex_state = 1},
  [153] = {.lex_state = 27, .external_lex_state = 1},
  [154] = {.lex_state = 5, .external_lex_state = 1},
  [155] = {.lex_state = 27, .external_lex_state = 1},
  [156] = {.lex_state = 27, .external_lex_state = 1},
  [157] = {.lex_state = 27, .external_lex_state = 1},
  [158] = {.lex_state = 27, .external_lex_state = 1},
  [159] = {.lex_state = 27, .external_lex_state = 1},
  [160] = {.lex_state = 27, .external_lex_state = 1},
  [161] = {.lex_state = 27, .external_lex_state = 1},
  [162] = {.lex_state = 27, .external_lex_state = 1},
  [163] = {.lex_state = 27, .external_lex_state = 1},
  [164] = {.lex_state = 27, .external_lex_state = 1},
  [165] = {.lex_state = 5, .external_lex_state = 1},
  [166] = {.lex_state = 27, .external_lex_state = 1},
  [167] = {.lex_state = 27, .external_lex_state = 1},
  [168] = {.lex_state = 27, .external_lex_state = 1},
  [169] = {.lex_state = 27, .external_lex_state = 1},
  [170] = {.lex_state = 5, .external_lex_state = 1},
  [171] = {.lex_state = 27, .external_lex_state = 1},
  [172] = {.lex_state = 27, .external_lex_state = 1},
  [173] = {.lex_state = 27, .external_lex_state = 1},
  [174] = {.lex_state = 27, .external_lex_state = 1},
  [175] = {.lex_state = 5, .external_lex_state = 1},
  [176] = {.lex_state = 1, .external_lex_state = 1},
  [177] = {.lex_state = 27, .external_lex_state = 1},
  [178] = {.lex_state = 27, .external_lex_state = 1},
  [179] = {.lex_state = 5, .external_lex_state = 1},
  [180] = {.lex_state = 5, .external_lex_state = 1},
  [181] = {.lex_state = 27, .external_lex_state = 1},
  [182] = {.lex_state = 27, .external_lex_state = 1},
  [183] = {.lex_state = 27, .external_lex_state = 1},
  [184] = {.lex_state = 27, .external_lex_state = 1},
  [185] = {.lex_state = 27, .external_lex_state = 1},
  [186] = {.lex_state = 27, .external_lex_state = 1},
  [187] = {.lex_state = 27, .external_lex_state = 1},
  [188] = {.lex_state = 27, .external_lex_state = 1},
  [189] = {.lex_state = 27, .external_lex_state = 1},
  [190] = {.lex_state = 5, .external_lex_state = 1},
  [191] = {.lex_state = 27, .external_lex_state = 1},
  [192] = {.lex_state = 5, .external_lex_state = 1},
  [193] = {.lex_state = 5, .external_lex_state = 1},
  [194] = {.lex_state = 5, .external_lex_state = 1},
  [195] = {.lex_state = 5, .external_lex_state = 1},
  [196] = {.lex_state = 5, .external_lex_state = 1},
  [197] = {.lex_state = 27, .external_lex_state = 1},
  [198] = {.lex_state = 5, .external_lex_state = 1},
  [199] = {.lex_state = 27, .external_lex_state = 1},
  [200] = {.lex_state = 27, .external_lex_state = 1},
  [201] = {.lex_state = 5, .external_lex_state = 1},
  [202] = {.lex_state = 27, .external_lex_state = 1},
  [203] = {.lex_state = 0, .external_lex_state = 1},
  [204] = {.lex_state = 0, .external_lex_state = 1},
  [205] = {.lex_state = 0, .external_lex_state = 1},
  [206] = {.lex_state = 0, .external_lex_state = 1},
  [207] = {.lex_state = 27, .external_lex_state = 1},
  [208] = {.lex_state = 0, .external_lex_state = 1},
  [209] = {.lex_state = 5, .external_lex_state = 1},
  [210] = {.lex_state = 5, .external_lex_state = 1},
  [211] = {.lex_state = 27, .external_lex_state = 1},
  [212] = {.lex_state = 0, .external_lex_state = 1},
  [213] = {.lex_state = 27, .external_lex_state = 1},
  [214] = {.lex_state = 0, .external_lex_state = 1},
  [215] = {.lex_state = 27, .external_lex_state = 1},
  [216] = {.lex_state = 27, .external_lex_state = 1},
  [217] = {.lex_state = 27, .external_lex_state = 1},
  [218] = {.lex_state = 27, .external_lex_state = 1},
  [219] = {.lex_state = 0, .external_lex_state = 1},
  [220] = {.lex_state = 27, .external_lex_state = 1},
  [221] = {.lex_state = 0, .external_lex_state = 1},
  [222] = {.lex_state = 0, .external_lex_state = 1},
  [223] = {.lex_state = 27, .external_lex_state = 1},
  [224] = {.lex_state = 27, .external_lex_state = 1},
  [225] = {.lex_state = 27, .external_lex_state = 1},
  [226] = {.lex_state = 0, .external_lex_state = 1},
  [227] = {.lex_state = 5, .external_lex_state = 1},
  [228] = {.lex_state = 27, .external_lex_state = 1},
  [229] = {.lex_state = 27, .external_lex_state = 1},
  [230] = {.lex_state = 0, .external_lex_state = 1},
  [231] = {.lex_state = 5, .external_lex_state = 1},
  [232] = {.lex_state = 0, .external_lex_state = 1},
  [233] = {.lex_state = 27, .external_lex_state = 1},
  [234] = {.lex_state = 5, .external_lex_state = 1},
  [235] = {.lex_state = 27, .external_lex_state = 1},
  [236] = {.lex_state = 5, .external_lex_state = 1},
  [237] = {.lex_state = 5, .external_lex_state = 1},
  [238] = {.lex_state = 5, .external_lex_state = 1},
  [239] = {.lex_state = 0, .external_lex_state = 1},
  [240] = {.lex_state = 27, .external_lex_state = 1},
  [241] = {.lex_state = 0, .external_lex_state = 1},
  [242] = {.lex_state = 0, .external_lex_state = 1},
  [243] = {.lex_state = 0, .external_lex_state = 1},
  [244] = {.lex_state = 0, .external_lex_state = 1},
  [245] = {.lex_state = 0, .external_lex_state = 1},
  [246] = {.lex_state = 27, .external_lex_state = 1},
  [247] = {.lex_state = 27, .external_lex_state = 1},
  [248] = {.lex_state = 27, .external_lex_state = 1},
  [249] = {.lex_state = 6, .external_lex_state = 1},
  [250] = {.lex_state = 27, .external_lex_state = 1},
  [251] = {.lex_state = 0, .external_lex_state = 1},
  [252] = {.lex_state = 27, .external_lex_state = 1},
  [253] = {.lex_state = 0, .external_lex_state = 1},
  [254] = {.lex_state = 0, .external_lex_state = 1},
  [255] = {.lex_state = 0, .external_lex_state = 1},
  [256] = {.lex_state = 27, .external_lex_state = 1},
  [257] = {.lex_state = 27, .external_lex_state = 1},
  [258] = {.lex_state = 0, .external_lex_state = 1},
  [259] = {.lex_state = 0, .external_lex_state = 1},
  [260] = {.lex_state = 0, .external_lex_state = 1},
  [261] = {.lex_state = 0, .external_lex_state = 1},
  [262] = {.lex_state = 0, .external_lex_state = 1},
  [263] = {.lex_state = 27, .external_lex_state = 1},
  [264] = {.lex_state = 27, .external_lex_state = 1},
  [265] = {.lex_state = 0, .external_lex_state = 1},
  [266] = {.lex_state = 0, .external_lex_state = 1},
  [267] = {.lex_state = 0, .external_lex_state = 1},
  [268] = {.lex_state = 27, .external_lex_state = 1},
  [269] = {.lex_state = 27, .external_lex_state = 1},
  [270] = {.lex_state = 0, .external_lex_state = 1},
  [271] = {.lex_state = 27, .external_lex_state = 1},
  [272] = {.lex_state = 0, .external_lex_state = 1},
  [273] = {.lex_state = 0, .external_lex_state = 1},
  [274] = {.lex_state = 0, .external_lex_state = 1},
  [275] = {.lex_state = 0, .external_lex_state = 1},
  [276] = {.lex_state = 0, .external_lex_state = 1},
  [277] = {.lex_state = 0, .external_lex_state = 1},
  [278] = {.lex_state = 0, .external_lex_state = 1},
  [279] = {.lex_state = 0, .external_lex_state = 1},
  [280] = {.lex_state = 0, .external_lex_state = 1},
  [281] = {.lex_state = 0, .external_lex_state = 1},
  [282] = {.lex_state = 0, .external_lex_state = 1},
  [283] = {.lex_state = 27, .external_lex_state = 1},
  [284] = {.lex_state = 27, .external_lex_state = 1},
  [285] = {.lex_state = 0, .external_lex_state = 1},
  [286] = {.lex_state = 0, .external_lex_state = 1},
  [287] = {.lex_state = 6, .external_lex_state = 1},
  [288] = {.lex_state = 27, .external_lex_state = 1},
  [289] = {.lex_state = 0, .external_lex_state = 1},
  [290] = {.lex_state = 0, .external_lex_state = 1},
  [291] = {.lex_state = 0, .external_lex_state = 1},
  [292] = {.lex_state = 0, .external_lex_state = 1},
  [293] = {.lex_state = 6, .external_lex_state = 1},
  [294] = {.lex_state = 0, .external_lex_state = 1},
  [295] = {.lex_state = 5, .external_lex_state = 1},
  [296] = {.lex_state = 0, .external_lex_state = 1},
  [297] = {.lex_state = 27, .external_lex_state = 1},
  [298] = {.lex_state = 27, .external_lex_state = 1},
  [299] = {.lex_state = 27, .external_lex_state = 1},
  [300] = {.lex_state = 27, .external_lex_state = 1},
  [301] = {.lex_state = 6, .external_lex_state = 1},
  [302] = {.lex_state = 0, .external_lex_state = 1},
  [303] = {.lex_state = 6, .external_lex_state = 1},
  [304] = {.lex_state = 0, .external_lex_state = 1},
  [305] = {.lex_state = 0, .external_lex_state = 1},
  [306] = {.lex_state = 0, .external_lex_state = 1},
  [307] = {.lex_state = 0, .external_lex_state = 1},
  [308] = {.lex_state = 27, .external_lex_state = 1},
  [309] = {.lex_state = 27, .external_lex_state = 1},
  [310] = {.lex_state = 0, .external_lex_state = 1},
  [311] = {.lex_state = 27, .external_lex_state = 1},
  [312] = {.lex_state = 0, .external_lex_state = 1},
  [313] = {.lex_state = 0, .external_lex_state = 1},
  [314] = {.lex_state = 0, .external_lex_state = 1},
  [315] = {.lex_state = 5, .external_lex_state = 1},
  [316] = {.lex_state = 0, .external_lex_state = 1},
  [317] = {.lex_state = 0, .external_lex_state = 1},
  [318] = {.lex_state = 0, .external_lex_state = 1},
  [319] = {.lex_state = 0, .external_lex_state = 1},
  [320] = {.lex_state = 27, .external_lex_state = 1},
  [321] = {.lex_state = 0, .external_lex_state = 1},
  [322] = {.lex_state = 0, .external_lex_state = 1},
  [323] = {.lex_state = 0, .external_lex_state = 1},
  [324] = {.lex_state = 27, .external_lex_state = 1},
  [325] = {.lex_state = 0, .external_lex_state = 1},
  [326] = {.lex_state = 0, .external_lex_state = 1},
  [327] = {.lex_state = 0, .external_lex_state = 1},
  [328] = {.lex_state = 0, .external_lex_state = 1},
  [329] = {.lex_state = 27, .external_lex_state = 1},
  [330] = {.lex_state = 0, .external_lex_state = 1},
  [331] = {.lex_state = 0, .external_lex_state = 1},
  [332] = {.lex_state = 93, .external_lex_state = 1},
  [333] = {.lex_state = 0, .external_lex_state = 1},
  [334] = {.lex_state = 0, .external_lex_state = 1},
  [335] = {.lex_state = 0, .external_lex_state = 1},
  [336] = {.lex_state = 0, .external_lex_state = 1},
  [337] = {.lex_state = 0, .external_lex_state = 1},
  [338] = {.lex_state = 27, .external_lex_state = 1},
  [339] = {.lex_state = 27, .external_lex_state = 1},
  [340] = {.lex_state = 0, .external_lex_state = 1},
  [341] = {.lex_state = 0, .external_lex_state = 1},
  [342] = {.lex_state = 0, .external_lex_state = 1},
  [343] = {.lex_state = 0, .external_lex_state = 1},
  [344] = {.lex_state = 0, .external_lex_state = 1},
  [345] = {.lex_state = 0, .external_lex_state = 1},
  [346] = {.lex_state = 0, .external_lex_state = 1},
  [347] = {.lex_state = 0, .external_lex_state = 1},
  [348] = {.lex_state = 0, .external_lex_state = 1},
  [349] = {.lex_state = 0, .external_lex_state = 1},
  [350] = {.lex_state = 0, .external_lex_state = 1},
  [351] = {.lex_state = 0, .external_lex_state = 1},
  [352] = {.lex_state = 0, .external_lex_state = 1},
  [353] = {.lex_state = 0, .external_lex_state = 1},
  [354] = {.lex_state = 0, .external_lex_state = 1},
  [355] = {.lex_state = 0, .external_lex_state = 1},
  [356] = {.lex_state = 0, .external_lex_state = 1},
  [357] = {.lex_state = 27, .external_lex_state = 1},
  [358] = {.lex_state = 0, .external_lex_state = 1},
  [359] = {.lex_state = 0, .external_lex_state = 1},
  [360] = {.lex_state = 0, .external_lex_state = 1},
  [361] = {.lex_state = 0, .external_lex_state = 1},
  [362] = {.lex_state = 0, .external_lex_state = 1},
  [363] = {.lex_state = 0, .external_lex_state = 1},
  [364] = {.lex_state = 0, .external_lex_state = 1},
  [365] = {.lex_state = 0, .external_lex_state = 1},
  [366] = {.lex_state = 27, .external_lex_state = 1},
  [367] = {.lex_state = 0, .external_lex_state = 1},
  [368] = {.lex_state = 0, .external_lex_state = 1},
  [369] = {.lex_state = 0, .external_lex_state = 1},
  [370] = {.lex_state = 0, .external_lex_state = 1},
  [371] = {.lex_state = 0, .external_lex_state = 1},
  [372] = {.lex_state = 0, .external_lex_state = 1},
  [373] = {.lex_state = 0, .external_lex_state = 1},
  [374] = {.lex_state = 0, .external_lex_state = 1},
  [375] = {.lex_state = 0, .external_lex_state = 1},
  [376] = {.lex_state = 0, .external_lex_state = 1},
  [377] = {.lex_state = 0, .external_lex_state = 1},
  [378] = {.lex_state = 0, .external_lex_state = 1},
  [379] = {.lex_state = 0, .external_lex_state = 1},
  [380] = {.lex_state = 0, .external_lex_state = 1},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 0, .external_lex_state = 1},
  [383] = {.lex_state = 27, .external_lex_state = 1},
  [384] = {.lex_state = 0, .external_lex_state = 1},
  [385] = {.lex_state = 0, .external_lex_state = 1},
  [386] = {.lex_state = 0, .external_lex_state = 1},
  [387] = {.lex_state = 0, .external_lex_state = 1},
  [388] = {.lex_state = 0, .external_lex_state = 1},
  [389] = {.lex_state = 0, .external_lex_state = 1},
  [390] = {.lex_state = 27, .external_lex_state = 1},
  [391] = {.lex_state = 27, .external_lex_state = 1},
  [392] = {.lex_state = 27, .external_lex_state = 1},
  [393] = {.lex_state = 0, .external_lex_state = 1},
  [394] = {.lex_state = 0, .external_lex_state = 1},
  [395] = {.lex_state = 0, .external_lex_state = 1},
  [396] = {.lex_state = 0, .external_lex_state = 1},
  [397] = {.lex_state = 0, .external_lex_state = 1},
  [398] = {.lex_state = 0, .external_lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 1},
  [400] = {.lex_state = 0, .external_lex_state = 1},
  [401] = {.lex_state = 0, .external_lex_state = 1},
  [402] = {.lex_state = 27, .external_lex_state = 1},
  [403] = {.lex_state = 27, .external_lex_state = 1},
  [404] = {.lex_state = 0, .external_lex_state = 1},
  [405] = {.lex_state = 0, .external_lex_state = 1},
  [406] = {.lex_state = 27, .external_lex_state = 1},
  [407] = {.lex_state = 27, .external_lex_state = 1},
  [408] = {.lex_state = 0, .external_lex_state = 1},
  [409] = {.lex_state = 0, .external_lex_state = 1},
  [410] = {.lex_state = 0, .external_lex_state = 1},
  [411] = {.lex_state = 0, .external_lex_state = 1},
  [412] = {.lex_state = 0, .external_lex_state = 1},
  [413] = {.lex_state = 0, .external_lex_state = 1},
  [414] = {.lex_state = 27, .external_lex_state = 1},
  [415] = {.lex_state = 0, .external_lex_state = 1},
  [416] = {.lex_state = 0, .external_lex_state = 1},
  [417] = {.lex_state = 0, .external_lex_state = 1},
  [418] = {.lex_state = 0, .external_lex_state = 1},
  [419] = {.lex_state = 0, .external_lex_state = 1},
  [420] = {.lex_state = 0, .external_lex_state = 1},
  [421] = {.lex_state = 0, .external_lex_state = 1},
  [422] = {.lex_state = 0, .external_lex_state = 1},
  [423] = {.lex_state = 0, .external_lex_state = 1},
  [424] = {.lex_state = 27, .external_lex_state = 1},
  [425] = {.lex_state = 0, .external_lex_state = 1},
  [426] = {.lex_state = 0, .external_lex_state = 1},
  [427] = {.lex_state = 0, .external_lex_state = 1},
  [428] = {.lex_state = 0, .external_lex_state = 1},
  [429] = {.lex_state = 0, .external_lex_state = 1},
  [430] = {.lex_state = 27, .external_lex_state = 1},
  [431] = {.lex_state = 0, .external_lex_state = 1},
  [432] = {.lex_state = 0, .external_lex_state = 1},
  [433] = {.lex_state = 0, .external_lex_state = 1},
  [434] = {.lex_state = 27, .external_lex_state = 1},
  [435] = {.lex_state = 0, .external_lex_state = 1},
  [436] = {.lex_state = 0, .external_lex_state = 1},
  [437] = {.lex_state = 0, .external_lex_state = 1},
  [438] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__block_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__block_comment] = sym__block_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__block_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym__comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym_decimal_float_literal] = ACTIONS(1),
    [sym_hex_float_literal] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_uint_literal] = ACTIONS(1),
    [sym_array] = ACTIONS(1),
    [sym_atomic] = ACTIONS(1),
    [sym_bool] = ACTIONS(1),
    [sym_float32] = ACTIONS(1),
    [sym_int32] = ACTIONS(1),
    [sym_mat2x2] = ACTIONS(1),
    [sym_mat2x3] = ACTIONS(1),
    [sym_mat2x4] = ACTIONS(1),
    [sym_mat3x2] = ACTIONS(1),
    [sym_mat3x3] = ACTIONS(1),
    [sym_mat3x4] = ACTIONS(1),
    [sym_mat4x2] = ACTIONS(1),
    [sym_mat4x3] = ACTIONS(1),
    [sym_mat4x4] = ACTIONS(1),
    [sym_pointer] = ACTIONS(1),
    [sym_sampler] = ACTIONS(1),
    [sym_sampler_comparison] = ACTIONS(1),
    [sym_struct] = ACTIONS(1),
    [sym_texture_1d] = ACTIONS(1),
    [sym_texture_2d] = ACTIONS(1),
    [sym_texture_2d_array] = ACTIONS(1),
    [sym_texture_3d] = ACTIONS(1),
    [sym_texture_cube] = ACTIONS(1),
    [sym_texture_cube_array] = ACTIONS(1),
    [sym_texture_multisampled_2d] = ACTIONS(1),
    [sym_texture_storage_1d] = ACTIONS(1),
    [sym_texture_storage_2d] = ACTIONS(1),
    [sym_texture_storage_2d_array] = ACTIONS(1),
    [sym_texture_storage_3d] = ACTIONS(1),
    [sym_texture_depth_2d] = ACTIONS(1),
    [sym_texture_depth_2d_array] = ACTIONS(1),
    [sym_texture_depth_cube] = ACTIONS(1),
    [sym_texture_depth_cube_array] = ACTIONS(1),
    [sym_texture_depth_multisampled_2d] = ACTIONS(1),
    [sym_uint32] = ACTIONS(1),
    [sym_vec2] = ACTIONS(1),
    [sym_vec3] = ACTIONS(1),
    [sym_vec4] = ACTIONS(1),
    [sym_bitcast] = ACTIONS(1),
    [sym_block] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_case] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [sym_continuing] = ACTIONS(1),
    [sym_default] = ACTIONS(1),
    [sym_discard] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_enable] = ACTIONS(1),
    [sym_fallthrough] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_fn] = ACTIONS(1),
    [sym_for] = ACTIONS(1),
    [sym_function] = ACTIONS(1),
    [sym_if] = ACTIONS(1),
    [sym_let] = ACTIONS(1),
    [sym_loop] = ACTIONS(1),
    [sym_private] = ACTIONS(1),
    [sym_read] = ACTIONS(1),
    [sym_read_write] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_storage] = ACTIONS(1),
    [sym_switch] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_uniform] = ACTIONS(1),
    [sym_var] = ACTIONS(1),
    [sym_workgroup] = ACTIONS(1),
    [sym_write] = ACTIONS(1),
    [sym_r8unorm] = ACTIONS(1),
    [sym_r8snorm] = ACTIONS(1),
    [sym_r8uint] = ACTIONS(1),
    [sym_r8sint] = ACTIONS(1),
    [sym_r16uint] = ACTIONS(1),
    [sym_r16sint] = ACTIONS(1),
    [sym_r16float] = ACTIONS(1),
    [sym_rg8unorm] = ACTIONS(1),
    [sym_rg8snorm] = ACTIONS(1),
    [sym_rg8uint] = ACTIONS(1),
    [sym_rg8sint] = ACTIONS(1),
    [sym_r32uint] = ACTIONS(1),
    [sym_r32sint] = ACTIONS(1),
    [sym_r32float] = ACTIONS(1),
    [sym_rg16uint] = ACTIONS(1),
    [sym_rg16sint] = ACTIONS(1),
    [sym_rg16float] = ACTIONS(1),
    [sym_rgba8unorm] = ACTIONS(1),
    [sym_rgba8unorm_srgb] = ACTIONS(1),
    [sym_rgba8snorm] = ACTIONS(1),
    [sym_rgba8uint] = ACTIONS(1),
    [sym_rgba8sint] = ACTIONS(1),
    [sym_bgra8unorm] = ACTIONS(1),
    [sym_bgra8unorm_srgb] = ACTIONS(1),
    [sym_rgb10a2unorm] = ACTIONS(1),
    [sym_rg11b10float] = ACTIONS(1),
    [sym_rg32uint] = ACTIONS(1),
    [sym_rg32sint] = ACTIONS(1),
    [sym_rg32float] = ACTIONS(1),
    [sym_rgba16uint] = ACTIONS(1),
    [sym_rgba16sint] = ACTIONS(1),
    [sym_rgba16float] = ACTIONS(1),
    [sym_rgba32uint] = ACTIONS(1),
    [sym_rgba32sint] = ACTIONS(1),
    [sym_rgba32float] = ACTIONS(1),
    [sym_and] = ACTIONS(1),
    [sym_and_and] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_forward_slash] = ACTIONS(1),
    [sym_bang] = ACTIONS(1),
    [sym_bracket_left] = ACTIONS(1),
    [sym_bracket_right] = ACTIONS(1),
    [sym_brace_left] = ACTIONS(1),
    [sym_brace_right] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_comma] = ACTIONS(1),
    [sym_equal] = ACTIONS(1),
    [sym_equal_equal] = ACTIONS(1),
    [sym_not_equal] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [sym_greater_than_equal] = ACTIONS(1),
    [sym_shift_right] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_less_than_equal] = ACTIONS(1),
    [sym_shift_left] = ACTIONS(1),
    [sym_modulo] = ACTIONS(1),
    [sym_minus] = ACTIONS(1),
    [sym_period] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plus_plus] = ACTIONS(1),
    [sym_or] = ACTIONS(1),
    [sym_or_or] = ACTIONS(1),
    [sym_paren_left] = ACTIONS(1),
    [sym_paren_right] = ACTIONS(1),
    [sym_semicolon] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_tilde] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_xor] = ACTIONS(1),
    [aux_sym__reserved_token1] = ACTIONS(1),
    [aux_sym__reserved_token2] = ACTIONS(1),
    [aux_sym__reserved_token3] = ACTIONS(1),
    [aux_sym__reserved_token4] = ACTIONS(1),
    [aux_sym__reserved_token5] = ACTIONS(1),
    [aux_sym__reserved_token6] = ACTIONS(1),
    [aux_sym__reserved_token7] = ACTIONS(1),
    [aux_sym__reserved_token8] = ACTIONS(1),
    [aux_sym__reserved_token9] = ACTIONS(1),
    [aux_sym__reserved_token10] = ACTIONS(1),
    [aux_sym__reserved_token11] = ACTIONS(1),
    [aux_sym__reserved_token12] = ACTIONS(1),
    [aux_sym__reserved_token13] = ACTIONS(1),
    [aux_sym__reserved_token14] = ACTIONS(1),
    [aux_sym__reserved_token15] = ACTIONS(1),
    [aux_sym__reserved_token16] = ACTIONS(1),
    [aux_sym__reserved_token17] = ACTIONS(1),
    [aux_sym__reserved_token18] = ACTIONS(1),
    [aux_sym__reserved_token19] = ACTIONS(1),
    [aux_sym__reserved_token20] = ACTIONS(1),
    [aux_sym__reserved_token21] = ACTIONS(1),
    [aux_sym__reserved_token22] = ACTIONS(1),
    [aux_sym__reserved_token23] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [1] = {
    [sym_translation_unit] = STATE(428),
    [sym_global_directive] = STATE(155),
    [sym_attribute_list] = STATE(70),
    [sym_struct_decl] = STATE(427),
    [sym_type_alias_decl] = STATE(427),
    [sym_variable_decl] = STATE(271),
    [sym_global_variable_decl] = STATE(427),
    [sym_global_constant_decl] = STATE(427),
    [sym_function_decl] = STATE(174),
    [sym_function_header] = STATE(275),
    [sym_enable_directive] = STATE(157),
    [sym__comment] = STATE(1),
    [aux_sym_translation_unit_repeat1] = STATE(102),
    [aux_sym_translation_unit_repeat2] = STATE(130),
    [aux_sym_array_type_decl_repeat1] = STATE(160),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_struct] = ACTIONS(9),
    [sym_enable] = ACTIONS(11),
    [sym_fn] = ACTIONS(13),
    [sym_let] = ACTIONS(15),
    [sym_type] = ACTIONS(17),
    [sym_var] = ACTIONS(19),
    [sym_attr_left] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(23),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(302),
    [sym__comment] = STATE(2),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(5),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(59),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(282),
    [sym__comment] = STATE(3),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(9),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(61),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(276),
    [sym__comment] = STATE(4),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(7),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_paren_right] = ACTIONS(63),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(290),
    [sym__comment] = STATE(5),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(347),
    [sym__comment] = STATE(6),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(65),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(274),
    [sym__comment] = STATE(7),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(342),
    [sym__comment] = STATE(8),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(67),
    [sym_decimal_float_literal] = ACTIONS(70),
    [sym_hex_float_literal] = ACTIONS(70),
    [sym_int_literal] = ACTIONS(73),
    [sym_uint_literal] = ACTIONS(76),
    [sym_array] = ACTIONS(79),
    [sym_atomic] = ACTIONS(82),
    [sym_bool] = ACTIONS(85),
    [sym_float32] = ACTIONS(85),
    [sym_int32] = ACTIONS(85),
    [sym_mat2x2] = ACTIONS(82),
    [sym_mat2x3] = ACTIONS(82),
    [sym_mat2x4] = ACTIONS(82),
    [sym_mat3x2] = ACTIONS(82),
    [sym_mat3x3] = ACTIONS(82),
    [sym_mat3x4] = ACTIONS(82),
    [sym_mat4x2] = ACTIONS(82),
    [sym_mat4x3] = ACTIONS(82),
    [sym_mat4x4] = ACTIONS(82),
    [sym_pointer] = ACTIONS(88),
    [sym_sampler] = ACTIONS(91),
    [sym_sampler_comparison] = ACTIONS(91),
    [sym_texture_1d] = ACTIONS(94),
    [sym_texture_2d] = ACTIONS(94),
    [sym_texture_2d_array] = ACTIONS(94),
    [sym_texture_3d] = ACTIONS(94),
    [sym_texture_cube] = ACTIONS(94),
    [sym_texture_cube_array] = ACTIONS(94),
    [sym_texture_multisampled_2d] = ACTIONS(97),
    [sym_texture_storage_1d] = ACTIONS(100),
    [sym_texture_storage_2d] = ACTIONS(100),
    [sym_texture_storage_2d_array] = ACTIONS(100),
    [sym_texture_storage_3d] = ACTIONS(100),
    [sym_texture_depth_2d] = ACTIONS(103),
    [sym_texture_depth_2d_array] = ACTIONS(103),
    [sym_texture_depth_cube] = ACTIONS(103),
    [sym_texture_depth_cube_array] = ACTIONS(103),
    [sym_texture_depth_multisampled_2d] = ACTIONS(103),
    [sym_uint32] = ACTIONS(85),
    [sym_vec2] = ACTIONS(82),
    [sym_vec3] = ACTIONS(82),
    [sym_vec4] = ACTIONS(82),
    [sym_bitcast] = ACTIONS(106),
    [sym_false] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_and] = ACTIONS(109),
    [sym_attr_left] = ACTIONS(112),
    [sym_bang] = ACTIONS(109),
    [sym_minus] = ACTIONS(115),
    [sym_paren_left] = ACTIONS(118),
    [sym_star] = ACTIONS(109),
    [sym_tilde] = ACTIONS(109),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(281),
    [sym__comment] = STATE(9),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [aux_sym_argument_expression_list_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(367),
    [sym__comment] = STATE(10),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(121),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(360),
    [sym__comment] = STATE(11),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_semicolon] = ACTIONS(123),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(432),
    [sym__comment] = STATE(12),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(412),
    [sym__comment] = STATE(13),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(317),
    [sym__comment] = STATE(14),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(410),
    [sym__comment] = STATE(15),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(420),
    [sym__comment] = STATE(16),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(344),
    [sym__comment] = STATE(17),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(429),
    [sym__comment] = STATE(18),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(422),
    [sym__comment] = STATE(19),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(101),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(203),
    [sym_short_circuit_and_expression] = STATE(328),
    [sym_short_circuit_or_expression] = STATE(331),
    [sym_binary_or_expression] = STATE(336),
    [sym_binary_and_expression] = STATE(338),
    [sym_binary_xor_expression] = STATE(345),
    [sym_expression] = STATE(423),
    [sym__comment] = STATE(20),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(123),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(221),
    [sym__comment] = STATE(21),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(123),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(134),
    [sym_additive_expression] = STATE(143),
    [sym_shift_expression] = STATE(146),
    [sym_relational_expression] = STATE(219),
    [sym__comment] = STATE(22),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(144),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(148),
    [sym_additive_expression] = STATE(176),
    [sym_shift_expression] = STATE(204),
    [sym__comment] = STATE(23),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_const_literal] = STATE(119),
    [sym_float_literal] = STATE(122),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(286),
    [sym_primary_expression] = STATE(110),
    [sym_paren_expression] = STATE(119),
    [sym_unary_expression] = STATE(141),
    [sym_singular_expression] = STATE(136),
    [sym_multiplicative_expression] = STATE(140),
    [sym__comment] = STATE(24),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(125),
    [sym_decimal_float_literal] = ACTIONS(127),
    [sym_hex_float_literal] = ACTIONS(127),
    [sym_int_literal] = ACTIONS(129),
    [sym_uint_literal] = ACTIONS(131),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(133),
    [sym_false] = ACTIONS(129),
    [sym_true] = ACTIONS(129),
    [sym_and] = ACTIONS(135),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(135),
    [sym_minus] = ACTIONS(137),
    [sym_paren_left] = ACTIONS(139),
    [sym_star] = ACTIONS(135),
    [sym_tilde] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(141),
    [sym_singular_expression] = STATE(99),
    [sym_multiplicative_expression] = STATE(149),
    [sym__comment] = STATE(25),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_const_literal] = STATE(119),
    [sym_float_literal] = STATE(122),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(286),
    [sym_primary_expression] = STATE(110),
    [sym_paren_expression] = STATE(119),
    [sym_unary_expression] = STATE(133),
    [sym_singular_expression] = STATE(136),
    [sym__comment] = STATE(26),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(125),
    [sym_decimal_float_literal] = ACTIONS(127),
    [sym_hex_float_literal] = ACTIONS(127),
    [sym_int_literal] = ACTIONS(129),
    [sym_uint_literal] = ACTIONS(131),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(133),
    [sym_false] = ACTIONS(129),
    [sym_true] = ACTIONS(129),
    [sym_and] = ACTIONS(135),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(135),
    [sym_minus] = ACTIONS(137),
    [sym_paren_left] = ACTIONS(139),
    [sym_star] = ACTIONS(135),
    [sym_tilde] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(226),
    [sym_singular_expression] = STATE(99),
    [sym__comment] = STATE(27),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_const_literal] = STATE(119),
    [sym_float_literal] = STATE(122),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(286),
    [sym_primary_expression] = STATE(110),
    [sym_paren_expression] = STATE(119),
    [sym_unary_expression] = STATE(139),
    [sym_singular_expression] = STATE(136),
    [sym__comment] = STATE(28),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(125),
    [sym_decimal_float_literal] = ACTIONS(127),
    [sym_hex_float_literal] = ACTIONS(127),
    [sym_int_literal] = ACTIONS(129),
    [sym_uint_literal] = ACTIONS(131),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(133),
    [sym_false] = ACTIONS(129),
    [sym_true] = ACTIONS(129),
    [sym_and] = ACTIONS(135),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(135),
    [sym_minus] = ACTIONS(137),
    [sym_paren_left] = ACTIONS(139),
    [sym_star] = ACTIONS(135),
    [sym_tilde] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_const_literal] = STATE(198),
    [sym_float_literal] = STATE(194),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(277),
    [sym_primary_expression] = STATE(175),
    [sym_paren_expression] = STATE(198),
    [sym_unary_expression] = STATE(223),
    [sym_singular_expression] = STATE(225),
    [sym__comment] = STATE(29),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(141),
    [sym_decimal_float_literal] = ACTIONS(143),
    [sym_hex_float_literal] = ACTIONS(143),
    [sym_int_literal] = ACTIONS(145),
    [sym_uint_literal] = ACTIONS(147),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(149),
    [sym_false] = ACTIONS(145),
    [sym_true] = ACTIONS(145),
    [sym_and] = ACTIONS(151),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(151),
    [sym_minus] = ACTIONS(153),
    [sym_paren_left] = ACTIONS(155),
    [sym_star] = ACTIONS(151),
    [sym_tilde] = ACTIONS(151),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(222),
    [sym_singular_expression] = STATE(99),
    [sym__comment] = STATE(30),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(103),
    [sym_singular_expression] = STATE(99),
    [sym__comment] = STATE(31),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_const_literal] = STATE(119),
    [sym_float_literal] = STATE(122),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(286),
    [sym_primary_expression] = STATE(110),
    [sym_paren_expression] = STATE(119),
    [sym_unary_expression] = STATE(147),
    [sym_singular_expression] = STATE(136),
    [sym__comment] = STATE(32),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(125),
    [sym_decimal_float_literal] = ACTIONS(127),
    [sym_hex_float_literal] = ACTIONS(127),
    [sym_int_literal] = ACTIONS(129),
    [sym_uint_literal] = ACTIONS(131),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(133),
    [sym_false] = ACTIONS(129),
    [sym_true] = ACTIONS(129),
    [sym_and] = ACTIONS(135),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(135),
    [sym_minus] = ACTIONS(137),
    [sym_paren_left] = ACTIONS(139),
    [sym_star] = ACTIONS(135),
    [sym_tilde] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(133),
    [sym_singular_expression] = STATE(99),
    [sym__comment] = STATE(33),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_const_literal] = STATE(90),
    [sym_float_literal] = STATE(87),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(325),
    [sym_primary_expression] = STATE(86),
    [sym_paren_expression] = STATE(90),
    [sym_unary_expression] = STATE(147),
    [sym_singular_expression] = STATE(99),
    [sym__comment] = STATE(34),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(53),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(53),
    [sym_minus] = ACTIONS(55),
    [sym_paren_left] = ACTIONS(57),
    [sym_star] = ACTIONS(53),
    [sym_tilde] = ACTIONS(53),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_const_literal] = STATE(198),
    [sym_float_literal] = STATE(194),
    [sym_attribute_list] = STATE(70),
    [sym_array_type_decl] = STATE(191),
    [sym_texture_sampler_types] = STATE(191),
    [sym_sampler_type] = STATE(186),
    [sym_sampled_texture_type] = STATE(378),
    [sym_multisampled_texture_type] = STATE(378),
    [sym_storage_texture_type] = STATE(377),
    [sym_depth_texture_type] = STATE(186),
    [sym_type_decl] = STATE(277),
    [sym_primary_expression] = STATE(175),
    [sym_paren_expression] = STATE(198),
    [sym_unary_expression] = STATE(224),
    [sym_singular_expression] = STATE(225),
    [sym__comment] = STATE(35),
    [aux_sym_array_type_decl_repeat1] = STATE(235),
    [sym_ident] = ACTIONS(141),
    [sym_decimal_float_literal] = ACTIONS(143),
    [sym_hex_float_literal] = ACTIONS(143),
    [sym_int_literal] = ACTIONS(145),
    [sym_uint_literal] = ACTIONS(147),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(149),
    [sym_false] = ACTIONS(145),
    [sym_true] = ACTIONS(145),
    [sym_and] = ACTIONS(151),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(151),
    [sym_minus] = ACTIONS(153),
    [sym_paren_left] = ACTIONS(155),
    [sym_star] = ACTIONS(151),
    [sym_tilde] = ACTIONS(151),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
    [sym__block_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(157), 1,
      sym_paren_right,
    STATE(36), 1,
      sym__comment,
    STATE(37), 1,
      aux_sym_const_expression_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(278), 1,
      sym_const_expression,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [121] = 27,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(37), 1,
      sym__comment,
    STATE(38), 1,
      aux_sym_const_expression_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(304), 1,
      sym_const_expression,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [239] = 26,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(168), 1,
      sym_uint_literal,
    ACTIONS(171), 1,
      sym_array,
    ACTIONS(177), 1,
      sym_pointer,
    ACTIONS(186), 1,
      sym_texture_multisampled_2d,
    ACTIONS(195), 1,
      sym_attr_left,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(387), 1,
      sym_const_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(162), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(180), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(38), 2,
      sym__comment,
      aux_sym_const_expression_repeat1,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(165), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(189), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(159), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(192), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(183), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(174), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [355] = 26,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(39), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(375), 1,
      sym_const_expression,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [470] = 26,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(40), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(379), 1,
      sym_const_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [585] = 26,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(41), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(87), 1,
      sym_float_literal,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(254), 1,
      sym_const_literal,
    STATE(343), 1,
      sym_const_expression,
    STATE(376), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [700] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(202), 1,
      sym_paren_right,
    STATE(42), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [770] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(204), 1,
      sym_paren_right,
    STATE(43), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [840] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(206), 1,
      sym_paren_right,
    STATE(44), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [910] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(208), 1,
      sym_paren_right,
    STATE(45), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [980] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(210), 1,
      sym_paren_right,
    STATE(46), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1050] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(212), 1,
      sym_paren_right,
    STATE(47), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1120] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(48), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(200), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(198), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [1187] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(214), 1,
      sym_array,
    STATE(49), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(71), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(335), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1281] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(50), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(434), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1375] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(51), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(240), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1469] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(52), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(300), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1563] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(53), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(430), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1657] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(54), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(340), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1751] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(214), 1,
      sym_array,
    STATE(55), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(71), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(397), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1845] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(56), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(424), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1939] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(49), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(57), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(397), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2033] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(58), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(311), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2127] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(59), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(414), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2221] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(60), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(320), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2315] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(55), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(61), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(404), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2409] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(62), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(377), 1,
      sym_storage_texture_type,
    STATE(407), 1,
      sym_type_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2503] = 20,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(63), 1,
      sym__comment,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(284), 1,
      sym_type_decl,
    STATE(377), 1,
      sym_storage_texture_type,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(186), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(191), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(378), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2597] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(220), 1,
      sym_paren_right,
    STATE(64), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(218), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(216), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2660] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(222), 1,
      sym_paren_right,
    STATE(65), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(218), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(216), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2723] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(66), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(218), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(216), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2783] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(226), 1,
      sym_attr_left,
    STATE(70), 1,
      sym_attribute_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(67), 2,
      sym__comment,
      aux_sym_array_type_decl_repeat1,
    ACTIONS(224), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2845] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(231), 1,
      sym_attr_left,
    STATE(68), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(229), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2903] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(235), 1,
      sym_attr_left,
    STATE(69), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(233), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2961] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(239), 1,
      sym_attr_left,
    STATE(70), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(237), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [3019] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(226), 1,
      sym_attr_left,
    ACTIONS(241), 1,
      sym_array,
    STATE(67), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(71), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(224), 37,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_ident,
  [3081] = 30,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(250), 1,
      sym_continuing,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(272), 1,
      sym_brace_right,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    STATE(72), 1,
      sym__comment,
    STATE(73), 1,
      aux_sym_compound_statement_repeat1,
    STATE(118), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    STATE(396), 1,
      sym_continuing_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3183] = 30,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(250), 1,
      sym_continuing,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(280), 1,
      sym_brace_right,
    STATE(73), 1,
      sym__comment,
    STATE(75), 1,
      aux_sym_compound_statement_repeat1,
    STATE(118), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    STATE(425), 1,
      sym_continuing_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3285] = 29,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(282), 1,
      sym_fallthrough,
    ACTIONS(284), 1,
      sym_brace_right,
    STATE(74), 1,
      sym__comment,
    STATE(77), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(348), 1,
      sym_case_body,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3384] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(286), 1,
      sym_ident,
    ACTIONS(289), 1,
      sym_break,
    ACTIONS(292), 1,
      sym_continue,
    ACTIONS(295), 1,
      sym_continuing,
    ACTIONS(297), 1,
      sym_discard,
    ACTIONS(300), 1,
      sym_for,
    ACTIONS(303), 1,
      sym_if,
    ACTIONS(306), 1,
      sym_let,
    ACTIONS(309), 1,
      sym_loop,
    ACTIONS(312), 1,
      sym_return,
    ACTIONS(315), 1,
      sym_switch,
    ACTIONS(318), 1,
      sym_var,
    ACTIONS(324), 1,
      sym_brace_left,
    ACTIONS(327), 1,
      sym_brace_right,
    ACTIONS(329), 1,
      sym_paren_left,
    ACTIONS(332), 1,
      sym_semicolon,
    ACTIONS(335), 1,
      sym_underscore,
    STATE(118), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(321), 2,
      sym_and,
      sym_star,
    STATE(75), 2,
      sym__comment,
      aux_sym_compound_statement_repeat1,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3481] = 29,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(282), 1,
      sym_fallthrough,
    ACTIONS(338), 1,
      sym_brace_right,
    STATE(76), 1,
      sym__comment,
    STATE(77), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(355), 1,
      sym_case_body,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3580] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(282), 1,
      sym_fallthrough,
    ACTIONS(340), 1,
      sym_brace_right,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(356), 1,
      sym_case_body,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(77), 2,
      sym_statement,
      sym__comment,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3677] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(78), 1,
      sym__comment,
    STATE(384), 1,
      sym_texel_format,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(344), 2,
      sym_rgba8unorm,
      sym_bgra8unorm,
    ACTIONS(342), 33,
      sym_r8unorm,
      sym_r8snorm,
      sym_r8uint,
      sym_r8sint,
      sym_r16uint,
      sym_r16sint,
      sym_r16float,
      sym_rg8unorm,
      sym_rg8snorm,
      sym_rg8uint,
      sym_rg8sint,
      sym_r32uint,
      sym_r32sint,
      sym_r32float,
      sym_rg16uint,
      sym_rg16sint,
      sym_rg16float,
      sym_rgba8unorm_srgb,
      sym_rgba8snorm,
      sym_rgba8uint,
      sym_rgba8sint,
      sym_bgra8unorm_srgb,
      sym_rgb10a2unorm,
      sym_rg11b10float,
      sym_rg32uint,
      sym_rg32sint,
      sym_rg32float,
      sym_rgba16uint,
      sym_rgba16sint,
      sym_rgba16float,
      sym_rgba32uint,
      sym_rgba32sint,
      sym_rgba32float,
  [3730] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(346), 1,
      sym_brace_right,
    STATE(75), 1,
      aux_sym_compound_statement_repeat1,
    STATE(79), 1,
      sym__comment,
    STATE(118), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3826] = 28,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(246), 1,
      sym_break,
    ACTIONS(248), 1,
      sym_continue,
    ACTIONS(252), 1,
      sym_discard,
    ACTIONS(254), 1,
      sym_for,
    ACTIONS(256), 1,
      sym_if,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(260), 1,
      sym_loop,
    ACTIONS(262), 1,
      sym_return,
    ACTIONS(264), 1,
      sym_switch,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(276), 1,
      sym_semicolon,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(348), 1,
      sym_brace_right,
    STATE(79), 1,
      aux_sym_compound_statement_repeat1,
    STATE(80), 1,
      sym__comment,
    STATE(118), 1,
      sym_statement,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(109), 5,
      sym_compound_statement,
      sym_if_statement,
      sym_switch_statement,
      sym_loop_statement,
      sym_for_statement,
    STATE(372), 6,
      sym_variable_statement,
      sym_assignment_statement,
      sym_break_statement,
      sym_continue_statement,
      sym_return_statement,
      sym_func_call_statement,
  [3922] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(354), 1,
      sym_paren_left,
    STATE(81), 1,
      sym__comment,
    STATE(96), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(350), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(352), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3967] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(361), 1,
      sym_bracket_left,
    ACTIONS(363), 1,
      sym_period,
    STATE(82), 1,
      sym__comment,
    STATE(98), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(357), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(359), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4014] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(83), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(365), 9,
      ts_builtin_sym_end,
      sym_and,
      sym_attr_left,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(367), 17,
      sym_struct,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_else,
      sym_fallthrough,
      sym_fn,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_type,
      sym_var,
      sym_ident,
  [4055] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(84), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(369), 9,
      ts_builtin_sym_end,
      sym_and,
      sym_attr_left,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(371), 17,
      sym_struct,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_else,
      sym_fallthrough,
      sym_fn,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_type,
      sym_var,
      sym_ident,
  [4096] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(361), 1,
      sym_bracket_left,
    ACTIONS(363), 1,
      sym_period,
    STATE(85), 1,
      sym__comment,
    STATE(97), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(373), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(375), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4143] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(361), 1,
      sym_bracket_left,
    ACTIONS(363), 1,
      sym_period,
    STATE(86), 1,
      sym__comment,
    STATE(100), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(377), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(379), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4189] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(87), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(381), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(383), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4229] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(88), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(385), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(387), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4269] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(89), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(389), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(391), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_brace_left,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4309] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(350), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(352), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4348] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(91), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(393), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(395), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4387] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(397), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(399), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4426] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(401), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(403), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4465] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(94), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(405), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(407), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4504] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(95), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(409), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(411), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4543] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(96), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(413), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(415), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4582] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(417), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(419), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4620] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(373), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(375), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4658] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(421), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(423), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4695] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(425), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(427), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4732] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(429), 1,
      sym_and,
    ACTIONS(437), 1,
      sym_or,
    ACTIONS(439), 1,
      sym_xor,
    STATE(101), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(435), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(433), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(431), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [4777] = 22,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(11), 1,
      sym_enable,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(441), 1,
      ts_builtin_sym_end,
    STATE(70), 1,
      sym_attribute_list,
    STATE(102), 1,
      sym__comment,
    STATE(132), 1,
      aux_sym_translation_unit_repeat2,
    STATE(145), 1,
      aux_sym_translation_unit_repeat1,
    STATE(155), 1,
      sym_global_directive,
    STATE(157), 1,
      sym_enable_directive,
    STATE(160), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(174), 1,
      sym_function_decl,
    STATE(271), 1,
      sym_variable_decl,
    STATE(275), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(427), 4,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [4848] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(103), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(443), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(445), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [4885] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(449), 1,
      sym_else,
    STATE(104), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(451), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(447), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [4923] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(453), 1,
      sym_paren_left,
    STATE(105), 1,
      sym__comment,
    STATE(120), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(350), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(352), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [4963] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(456), 1,
      sym_bracket_left,
    ACTIONS(458), 1,
      sym_period,
    STATE(106), 1,
      sym__comment,
    STATE(135), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(357), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(359), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5004] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(107), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(462), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(460), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5039] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(456), 1,
      sym_bracket_left,
    ACTIONS(458), 1,
      sym_period,
    STATE(108), 1,
      sym__comment,
    STATE(138), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(373), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(375), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5080] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(109), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(466), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(464), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5115] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(456), 1,
      sym_bracket_left,
    ACTIONS(458), 1,
      sym_period,
    STATE(110), 1,
      sym__comment,
    STATE(137), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(377), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(379), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5156] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(111), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(470), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(468), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5191] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(112), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(474), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(472), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5226] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(113), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(478), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(476), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5261] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(114), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(482), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(480), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5296] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(115), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(486), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(484), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5331] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(116), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(490), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(488), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5366] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(117), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(494), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(492), 13,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_fallthrough,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5401] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(118), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(498), 7,
      sym_and,
      sym_brace_left,
      sym_brace_right,
      sym_paren_left,
      sym_semicolon,
      sym_star,
      sym_underscore,
    ACTIONS(496), 12,
      sym_break,
      sym_continue,
      sym_continuing,
      sym_discard,
      sym_for,
      sym_if,
      sym_let,
      sym_loop,
      sym_return,
      sym_switch,
      sym_var,
      sym_ident,
  [5435] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(119), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(350), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(352), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5469] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(120), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(413), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(415), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5503] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(121), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(385), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(387), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5537] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(122), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(381), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(383), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5571] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(123), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(435), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(433), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(431), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5607] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(124), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(397), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(399), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5641] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(125), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(405), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(407), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5675] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(126), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(389), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(391), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5709] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(127), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(401), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(403), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5743] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(128), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(409), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(411), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5777] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(129), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(393), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(395), 16,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [5811] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(441), 1,
      ts_builtin_sym_end,
    STATE(70), 1,
      sym_attribute_list,
    STATE(130), 1,
      sym__comment,
    STATE(131), 1,
      aux_sym_translation_unit_repeat2,
    STATE(160), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(174), 1,
      sym_function_decl,
    STATE(271), 1,
      sym_variable_decl,
    STATE(275), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(427), 4,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5870] = 17,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(500), 1,
      ts_builtin_sym_end,
    ACTIONS(502), 1,
      sym_struct,
    ACTIONS(505), 1,
      sym_fn,
    ACTIONS(508), 1,
      sym_let,
    ACTIONS(511), 1,
      sym_type,
    ACTIONS(514), 1,
      sym_var,
    ACTIONS(517), 1,
      sym_attr_left,
    ACTIONS(520), 1,
      sym_semicolon,
    STATE(70), 1,
      sym_attribute_list,
    STATE(160), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(174), 1,
      sym_function_decl,
    STATE(271), 1,
      sym_variable_decl,
    STATE(275), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(131), 2,
      sym__comment,
      aux_sym_translation_unit_repeat2,
    STATE(427), 4,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5927] = 18,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(523), 1,
      ts_builtin_sym_end,
    STATE(70), 1,
      sym_attribute_list,
    STATE(131), 1,
      aux_sym_translation_unit_repeat2,
    STATE(132), 1,
      sym__comment,
    STATE(160), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(174), 1,
      sym_function_decl,
    STATE(271), 1,
      sym_variable_decl,
    STATE(275), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(427), 4,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [5986] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(133), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(527), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(525), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6018] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(531), 1,
      sym_forward_slash,
    STATE(134), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(533), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(535), 2,
      sym_modulo,
      sym_star,
    ACTIONS(529), 12,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6054] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(135), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(373), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(375), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6086] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(136), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(421), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(423), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6118] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(137), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(425), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(427), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6150] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(138), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(417), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(419), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6182] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(139), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(443), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(445), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6214] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(531), 1,
      sym_forward_slash,
    STATE(140), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(535), 2,
      sym_modulo,
      sym_star,
    ACTIONS(539), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(537), 12,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6250] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(141), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(433), 3,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
    ACTIONS(431), 14,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6282] = 16,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(244), 1,
      sym_ident,
    ACTIONS(258), 1,
      sym_let,
    ACTIONS(266), 1,
      sym_var,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(541), 1,
      sym_semicolon,
    STATE(142), 1,
      sym__comment,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(308), 1,
      sym_variable_decl,
    STATE(366), 1,
      sym_lhs_expression,
    STATE(421), 1,
      sym_for_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(417), 3,
      sym_variable_statement,
      sym_assignment_statement,
      sym_func_call_statement,
  [6335] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(143), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(545), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(547), 2,
      sym_minus,
      sym_plus,
    ACTIONS(543), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6366] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(433), 1,
      sym_forward_slash,
    STATE(144), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(549), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(431), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
  [6396] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(553), 1,
      sym_enable,
    STATE(155), 1,
      sym_global_directive,
    STATE(157), 1,
      sym_enable_directive,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(145), 2,
      sym__comment,
      aux_sym_translation_unit_repeat1,
    ACTIONS(551), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [6427] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(146), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(560), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(558), 4,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
    ACTIONS(556), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6456] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(147), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(564), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(562), 10,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6483] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(566), 1,
      sym_forward_slash,
    STATE(148), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(568), 2,
      sym_modulo,
      sym_star,
    ACTIONS(529), 8,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6511] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(566), 1,
      sym_forward_slash,
    STATE(149), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(568), 2,
      sym_modulo,
      sym_star,
    ACTIONS(537), 8,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [6539] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(570), 1,
      sym_ident,
    ACTIONS(572), 1,
      sym_paren_right,
    STATE(150), 1,
      sym__comment,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(330), 2,
      sym_assignment_statement,
      sym_func_call_statement,
  [6579] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(570), 1,
      sym_ident,
    ACTIONS(574), 1,
      sym_paren_right,
    STATE(151), 1,
      sym__comment,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(341), 2,
      sym_assignment_statement,
      sym_func_call_statement,
  [6619] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(278), 1,
      sym_underscore,
    ACTIONS(570), 1,
      sym_ident,
    ACTIONS(576), 1,
      sym_paren_right,
    STATE(152), 1,
      sym__comment,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(366), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
    STATE(370), 2,
      sym_assignment_statement,
      sym_func_call_statement,
  [6659] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(578), 1,
      sym_colon,
    STATE(87), 1,
      sym_float_literal,
    STATE(153), 1,
      sym__comment,
    STATE(319), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [6691] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(580), 1,
      sym_paren_left,
    STATE(154), 1,
      sym__comment,
    STATE(180), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(352), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [6717] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(155), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(583), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [6739] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(585), 1,
      sym_colon,
    STATE(87), 1,
      sym_float_literal,
    STATE(156), 1,
      sym__comment,
    STATE(319), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [6771] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(157), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(587), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [6793] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(87), 1,
      sym_float_literal,
    STATE(158), 1,
      sym__comment,
    STATE(262), 1,
      sym_const_literal,
    STATE(358), 1,
      sym_case_selectors,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [6825] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    ACTIONS(591), 1,
      sym_paren_right,
    STATE(70), 1,
      sym_attribute_list,
    STATE(159), 1,
      sym__comment,
    STATE(197), 1,
      aux_sym_param_list_repeat1,
    STATE(215), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(316), 1,
      sym_variable_ident_decl,
    STATE(318), 1,
      sym_param,
    STATE(349), 1,
      sym_param_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [6863] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(593), 1,
      sym_struct,
    ACTIONS(595), 1,
      sym_let,
    STATE(67), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(160), 1,
      sym__comment,
    STATE(269), 1,
      sym_variable_decl,
    STATE(296), 1,
      sym_function_header,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [6901] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(161), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(597), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [6923] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(162), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(500), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [6944] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(601), 1,
      sym_int_literal,
    STATE(163), 1,
      sym__comment,
    STATE(168), 1,
      aux_sym_attribute_repeat1,
    STATE(285), 1,
      sym_literal_or_ident,
    STATE(321), 1,
      sym_float_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(599), 2,
      sym_uint_literal,
      sym_ident,
  [6975] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    ACTIONS(603), 1,
      sym_brace_right,
    STATE(70), 1,
      sym_attribute_list,
    STATE(164), 1,
      sym__comment,
    STATE(167), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(217), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(257), 1,
      sym_struct_member,
    STATE(353), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7010] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(605), 1,
      sym_bracket_left,
    ACTIONS(607), 1,
      sym_period,
    STATE(165), 1,
      sym__comment,
    STATE(220), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(375), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [7037] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(166), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(609), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [7058] = 11,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    ACTIONS(611), 1,
      sym_brace_right,
    STATE(70), 1,
      sym_attribute_list,
    STATE(167), 1,
      sym__comment,
    STATE(171), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(217), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(257), 1,
      sym_struct_member,
    STATE(353), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7093] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(619), 1,
      sym_int_literal,
    STATE(321), 1,
      sym_float_literal,
    STATE(386), 1,
      sym_literal_or_ident,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(613), 2,
      sym_uint_literal,
      sym_ident,
    ACTIONS(616), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    STATE(168), 2,
      sym__comment,
      aux_sym_attribute_repeat1,
  [7122] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(601), 1,
      sym_int_literal,
    STATE(163), 1,
      aux_sym_attribute_repeat1,
    STATE(169), 1,
      sym__comment,
    STATE(321), 1,
      sym_float_literal,
    STATE(322), 1,
      sym_literal_or_ident,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(599), 2,
      sym_uint_literal,
      sym_ident,
  [7153] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(605), 1,
      sym_bracket_left,
    ACTIONS(607), 1,
      sym_period,
    STATE(170), 1,
      sym__comment,
    STATE(218), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(359), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [7180] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(622), 1,
      sym_ident,
    ACTIONS(625), 1,
      sym_attr_left,
    ACTIONS(628), 1,
      sym_brace_right,
    STATE(70), 1,
      sym_attribute_list,
    STATE(217), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(257), 1,
      sym_struct_member,
    STATE(353), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(171), 2,
      sym__comment,
      aux_sym_struct_body_decl_repeat1,
  [7213] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(87), 1,
      sym_float_literal,
    STATE(172), 1,
      sym__comment,
    STATE(319), 1,
      sym_const_literal,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [7242] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(173), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(630), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [7263] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(174), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(632), 8,
      ts_builtin_sym_end,
      sym_struct,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [7284] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(605), 1,
      sym_bracket_left,
    ACTIONS(607), 1,
      sym_period,
    STATE(175), 1,
      sym__comment,
    STATE(213), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(379), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [7311] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(176), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(634), 2,
      sym_minus,
      sym_plus,
    ACTIONS(543), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [7334] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(177), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(636), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7354] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(178), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(638), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7374] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(179), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(391), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7394] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(180), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(415), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7414] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(181), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(640), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7434] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(642), 1,
      sym_ident,
    ACTIONS(645), 1,
      sym_attr_left,
    STATE(70), 1,
      sym_attribute_list,
    STATE(215), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(316), 1,
      sym_variable_ident_decl,
    STATE(401), 1,
      sym_param,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(182), 2,
      sym__comment,
      aux_sym_param_list_repeat1,
  [7464] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(183), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(648), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7484] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(184), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(650), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7504] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(185), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(652), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7524] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(186), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(654), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7544] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(187), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(656), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7564] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(188), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(658), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7584] = 9,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(660), 1,
      sym_ident,
    STATE(189), 1,
      sym__comment,
    STATE(207), 1,
      aux_sym_lhs_expression_repeat1,
    STATE(227), 1,
      sym_core_lhs_expression,
    STATE(352), 1,
      sym_lhs_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
  [7614] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(190), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(387), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7634] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(191), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(662), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7654] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(192), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(395), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7674] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(193), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(411), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7694] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(194), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(383), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7714] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(195), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(403), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7734] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(196), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(407), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7754] = 10,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    STATE(70), 1,
      sym_attribute_list,
    STATE(182), 1,
      aux_sym_param_list_repeat1,
    STATE(197), 1,
      sym__comment,
    STATE(215), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(291), 1,
      sym_param,
    STATE(316), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [7786] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(198), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(352), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7806] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(199), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(664), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7826] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(200), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(666), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7846] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(201), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(399), 7,
      sym_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_period,
      sym_paren_right,
      sym_semicolon,
  [7866] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(202), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(668), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [7886] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(670), 1,
      sym_and_and,
    ACTIONS(674), 1,
      sym_or_or,
    STATE(203), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(672), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [7909] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(204), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(676), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [7928] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(205), 1,
      sym__comment,
    STATE(299), 1,
      sym_storage_class,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(678), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [7949] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(206), 1,
      sym__comment,
    STATE(411), 1,
      sym_storage_class,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(678), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [7970] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      sym_paren_left,
    ACTIONS(660), 1,
      sym_ident,
    STATE(207), 1,
      sym__comment,
    STATE(210), 1,
      sym_core_lhs_expression,
    STATE(211), 1,
      aux_sym_lhs_expression_repeat1,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(268), 2,
      sym_and,
      sym_star,
  [7997] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    ACTIONS(680), 1,
      sym_if,
    STATE(115), 1,
      sym_else_statement,
    STATE(208), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(116), 2,
      sym_compound_statement,
      sym_if_statement,
  [8021] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(684), 1,
      sym_paren_left,
    STATE(209), 1,
      sym__comment,
    STATE(313), 1,
      sym_argument_expression_list,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(682), 3,
      sym_bracket_left,
      sym_equal,
      sym_period,
  [8043] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(361), 1,
      sym_bracket_left,
    ACTIONS(363), 1,
      sym_period,
    STATE(210), 1,
      sym__comment,
    STATE(283), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(686), 2,
      sym_equal,
      sym_paren_right,
  [8067] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(688), 2,
      sym_paren_left,
      sym_ident,
    ACTIONS(690), 2,
      sym_and,
      sym_star,
    STATE(211), 2,
      sym__comment,
      aux_sym_lhs_expression_repeat1,
  [8087] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(693), 1,
      sym_case,
    ACTIONS(696), 1,
      sym_default,
    ACTIONS(699), 1,
      sym_brace_right,
    STATE(244), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(212), 2,
      sym__comment,
      aux_sym_switch_statement_repeat1,
  [8111] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(213), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(427), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8129] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(701), 1,
      sym_case,
    ACTIONS(703), 1,
      sym_default,
    ACTIONS(705), 1,
      sym_brace_right,
    STATE(212), 1,
      aux_sym_switch_statement_repeat1,
    STATE(214), 1,
      sym__comment,
    STATE(244), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8155] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    STATE(67), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(215), 1,
      sym__comment,
    STATE(292), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8181] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(709), 1,
      sym_int_literal,
    STATE(216), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(707), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_ident,
  [8201] = 8,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(589), 1,
      sym_ident,
    STATE(67), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(217), 1,
      sym__comment,
    STATE(389), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8227] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(218), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(375), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8245] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(711), 1,
      sym_and_and,
    STATE(219), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8265] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(220), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(419), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8283] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(715), 1,
      sym_or_or,
    STATE(221), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8303] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(717), 1,
      sym_or,
    STATE(222), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8323] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(719), 1,
      sym_and,
    STATE(223), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8343] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(224), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(445), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8361] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(225), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(423), 5,
      sym_and,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8379] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(721), 1,
      sym_xor,
    STATE(226), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(713), 4,
      sym_bracket_right,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8399] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(361), 1,
      sym_bracket_left,
    ACTIONS(363), 1,
      sym_period,
    STATE(227), 1,
      sym__comment,
    STATE(309), 1,
      sym_postfix_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(723), 2,
      sym_equal,
      sym_paren_right,
  [8423] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    ACTIONS(727), 1,
      sym_equal,
    ACTIONS(729), 1,
      sym_semicolon,
    STATE(228), 1,
      sym__comment,
    STATE(393), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8446] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    ACTIONS(727), 1,
      sym_equal,
    ACTIONS(731), 1,
      sym_semicolon,
    STATE(229), 1,
      sym__comment,
    STATE(369), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8469] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(701), 1,
      sym_case,
    ACTIONS(703), 1,
      sym_default,
    STATE(214), 1,
      aux_sym_switch_statement_repeat1,
    STATE(230), 1,
      sym__comment,
    STATE(244), 1,
      sym_switch_body,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8492] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(231), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(733), 4,
      sym_bracket_left,
      sym_equal,
      sym_period,
      sym_paren_right,
  [8509] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(735), 1,
      sym_ident,
    ACTIONS(737), 1,
      sym_less_than,
    STATE(232), 1,
      sym__comment,
    STATE(288), 1,
      sym_variable_ident_decl,
    STATE(289), 1,
      sym_variable_qualifier,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8532] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(233), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(739), 4,
      sym_and,
      sym_paren_left,
      sym_star,
      sym_ident,
  [8549] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(743), 1,
      sym_int_literal,
    STATE(234), 1,
      sym__comment,
    STATE(391), 1,
      sym_element_count_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(741), 2,
      sym_uint_literal,
      sym_ident,
  [8570] = 7,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(745), 1,
      sym_array,
    STATE(67), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym_attribute_list,
    STATE(235), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8593] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(743), 1,
      sym_int_literal,
    STATE(236), 1,
      sym__comment,
    STATE(357), 1,
      sym_element_count_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(741), 2,
      sym_uint_literal,
      sym_ident,
  [8614] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(743), 1,
      sym_int_literal,
    STATE(237), 1,
      sym__comment,
    STATE(329), 1,
      sym_element_count_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(741), 2,
      sym_uint_literal,
      sym_ident,
  [8635] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(238), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(682), 4,
      sym_bracket_left,
      sym_equal,
      sym_period,
      sym_paren_right,
  [8652] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(747), 1,
      sym_read,
    STATE(239), 1,
      sym__comment,
    STATE(339), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(749), 2,
      sym_read_write,
      sym_write,
  [8673] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(240), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(751), 4,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [8690] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(747), 1,
      sym_read,
    STATE(241), 1,
      sym__comment,
    STATE(403), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(749), 2,
      sym_read_write,
      sym_write,
  [8711] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(747), 1,
      sym_read,
    STATE(242), 1,
      sym__comment,
    STATE(390), 1,
      sym_access_mode,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(749), 2,
      sym_read_write,
      sym_write,
  [8732] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(243), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(753), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8748] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(244), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(755), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [8764] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(757), 1,
      sym_ident,
    STATE(245), 1,
      sym__comment,
    STATE(251), 1,
      aux_sym_attribute_list_repeat1,
    STATE(293), 1,
      sym_attribute,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8784] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(727), 1,
      sym_equal,
    ACTIONS(729), 1,
      sym_semicolon,
    STATE(246), 1,
      sym__comment,
    STATE(393), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8804] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    STATE(247), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(759), 2,
      sym_equal,
      sym_semicolon,
  [8822] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(248), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(761), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [8838] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(765), 1,
      sym_paren_left,
    STATE(249), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(763), 2,
      sym_attr_right,
      sym_comma,
  [8856] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(769), 1,
      sym_paren_right,
    STATE(250), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(767), 2,
      sym_attr_left,
      sym_ident,
  [8874] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(757), 1,
      sym_ident,
    STATE(251), 1,
      sym__comment,
    STATE(253), 1,
      aux_sym_attribute_list_repeat1,
    STATE(303), 1,
      sym_attribute,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8894] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    STATE(252), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(771), 2,
      sym_equal,
      sym_semicolon,
  [8912] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(773), 1,
      sym_ident,
    STATE(333), 1,
      sym_attribute,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(253), 2,
      sym__comment,
      aux_sym_attribute_list_repeat1,
  [8930] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(254), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(776), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8946] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(255), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(778), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [8962] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(727), 1,
      sym_equal,
    ACTIONS(731), 1,
      sym_semicolon,
    STATE(256), 1,
      sym__comment,
    STATE(369), 1,
      sym_global_const_initializer,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [8982] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(257), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(780), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [8998] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(258), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(782), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9014] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(259), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(784), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9030] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(260), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(786), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [9046] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(788), 1,
      sym_colon,
    ACTIONS(790), 1,
      sym_comma,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    STATE(261), 2,
      sym__comment,
      aux_sym_case_selectors_repeat1,
  [9064] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(793), 1,
      sym_colon,
    ACTIONS(795), 1,
      sym_comma,
    STATE(262), 1,
      sym__comment,
    STATE(267), 1,
      aux_sym_case_selectors_repeat1,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9084] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(797), 1,
      sym_paren_right,
    STATE(263), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(767), 2,
      sym_attr_left,
      sym_ident,
  [9102] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(264), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(799), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [9118] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(265), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(801), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [9134] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(266), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(803), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [9150] = 6,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(578), 1,
      sym_colon,
    ACTIONS(805), 1,
      sym_comma,
    STATE(261), 1,
      aux_sym_case_selectors_repeat1,
    STATE(267), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9170] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(268), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(771), 2,
      sym_equal,
      sym_semicolon,
  [9185] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(807), 1,
      sym_equal,
    ACTIONS(809), 1,
      sym_semicolon,
    STATE(269), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9202] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(811), 1,
      sym_ident,
    STATE(246), 1,
      sym_variable_ident_decl,
    STATE(270), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9219] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(813), 1,
      sym_equal,
    ACTIONS(815), 1,
      sym_semicolon,
    STATE(271), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9236] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    STATE(272), 1,
      sym__comment,
    STATE(426), 1,
      sym_compound_statement,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9253] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(155), 1,
      sym_paren_left,
    STATE(195), 1,
      sym_paren_expression,
    STATE(273), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9270] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(206), 1,
      sym_paren_right,
    ACTIONS(817), 1,
      sym_comma,
    STATE(274), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9287] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    STATE(166), 1,
      sym_compound_statement,
    STATE(275), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9304] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(819), 1,
      sym_comma,
    ACTIONS(821), 1,
      sym_paren_right,
    STATE(276), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9321] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(823), 1,
      sym_paren_left,
    STATE(180), 1,
      sym_argument_expression_list,
    STATE(277), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9338] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(825), 1,
      sym_comma,
    ACTIONS(827), 1,
      sym_paren_right,
    STATE(278), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9355] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(829), 1,
      sym_brace_left,
    STATE(279), 1,
      sym__comment,
    STATE(394), 1,
      sym_struct_body_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9372] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(139), 1,
      sym_paren_left,
    STATE(127), 1,
      sym_paren_expression,
    STATE(280), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9389] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(210), 1,
      sym_paren_right,
    ACTIONS(831), 1,
      sym_comma,
    STATE(281), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9406] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(833), 1,
      sym_comma,
    ACTIONS(835), 1,
      sym_paren_right,
    STATE(282), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9423] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(283), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(837), 2,
      sym_equal,
      sym_paren_right,
  [9438] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(839), 1,
      sym_comma,
    ACTIONS(841), 1,
      sym_greater_than,
    STATE(284), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9455] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(843), 1,
      sym_comma,
    ACTIONS(845), 1,
      sym_paren_right,
    STATE(285), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9472] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(847), 1,
      sym_paren_left,
    STATE(120), 1,
      sym_argument_expression_list,
    STATE(286), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9489] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(287), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(849), 2,
      sym_attr_right,
      sym_comma,
  [9504] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(288), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(759), 2,
      sym_equal,
      sym_semicolon,
  [9519] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(851), 1,
      sym_ident,
    STATE(268), 1,
      sym_variable_ident_decl,
    STATE(289), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9536] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(202), 1,
      sym_paren_right,
    ACTIONS(853), 1,
      sym_comma,
    STATE(290), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9553] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(797), 1,
      sym_paren_right,
    ACTIONS(855), 1,
      sym_comma,
    STATE(291), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9570] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(292), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(857), 2,
      sym_comma,
      sym_paren_right,
  [9585] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(859), 1,
      sym_attr_right,
    ACTIONS(861), 1,
      sym_comma,
    STATE(293), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9602] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(863), 1,
      sym_ident,
    STATE(256), 1,
      sym_variable_ident_decl,
    STATE(294), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9619] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(865), 1,
      sym_arrow,
    ACTIONS(867), 1,
      sym_brace_left,
    STATE(295), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9636] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    STATE(173), 1,
      sym_compound_statement,
    STATE(296), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9653] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(297), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(767), 2,
      sym_attr_left,
      sym_ident,
  [9668] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(298), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(869), 2,
      sym_comma,
      sym_greater_than,
  [9683] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(871), 1,
      sym_comma,
    ACTIONS(873), 1,
      sym_greater_than,
    STATE(299), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9700] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(875), 1,
      sym_comma,
    ACTIONS(877), 1,
      sym_greater_than,
    STATE(300), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9717] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(301), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(879), 2,
      sym_attr_right,
      sym_comma,
  [9732] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(881), 1,
      sym_comma,
    ACTIONS(883), 1,
      sym_paren_right,
    STATE(302), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9749] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(861), 1,
      sym_comma,
    ACTIONS(885), 1,
      sym_attr_right,
    STATE(303), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9766] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(220), 1,
      sym_paren_right,
    ACTIONS(887), 1,
      sym_comma,
    STATE(304), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9783] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(305), 1,
      sym__comment,
    STATE(323), 1,
      sym_paren_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9800] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(889), 1,
      sym_ident,
    STATE(306), 1,
      sym__comment,
    STATE(383), 1,
      sym_variable_ident_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9817] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(307), 1,
      sym__comment,
    STATE(350), 1,
      sym_paren_expression,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9834] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(891), 1,
      sym_equal,
    ACTIONS(893), 1,
      sym_semicolon,
    STATE(308), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9851] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(309), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(686), 2,
      sym_equal,
      sym_paren_right,
  [9866] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(829), 1,
      sym_brace_left,
    STATE(310), 1,
      sym__comment,
    STATE(365), 1,
      sym_struct_body_decl,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9883] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(895), 1,
      sym_comma,
    ACTIONS(897), 1,
      sym_greater_than,
    STATE(311), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9900] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      sym_paren_left,
    STATE(93), 1,
      sym_paren_expression,
    STATE(312), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9917] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(313), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(899), 2,
      sym_paren_right,
      sym_semicolon,
  [9932] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    STATE(117), 1,
      sym_compound_statement,
    STATE(314), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9949] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(901), 1,
      sym_arrow,
    ACTIONS(903), 1,
      sym_brace_left,
    STATE(315), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [9966] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(316), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(905), 2,
      sym_comma,
      sym_paren_right,
  [9981] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(317), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(907), 2,
      sym_paren_right,
      sym_semicolon,
  [9996] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(909), 1,
      sym_comma,
    ACTIONS(911), 1,
      sym_paren_right,
    STATE(318), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10013] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(319), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(788), 2,
      sym_colon,
      sym_comma,
  [10028] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(913), 1,
      sym_comma,
    ACTIONS(915), 1,
      sym_greater_than,
    STATE(320), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10045] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(321), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
    ACTIONS(917), 2,
      sym_comma,
      sym_paren_right,
  [10060] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(843), 1,
      sym_comma,
    ACTIONS(919), 1,
      sym_paren_right,
    STATE(322), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10077] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(270), 1,
      sym_brace_left,
    STATE(104), 1,
      sym_compound_statement,
    STATE(323), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10094] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    ACTIONS(921), 1,
      sym_equal,
    STATE(324), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10111] = 5,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(684), 1,
      sym_paren_left,
    STATE(96), 1,
      sym_argument_expression_list,
    STATE(325), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10128] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(923), 1,
      sym_less_than,
    STATE(326), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10142] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(925), 1,
      sym_semicolon,
    STATE(327), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10156] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(927), 1,
      sym_and_and,
    STATE(328), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10170] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(929), 1,
      sym_greater_than,
    STATE(329), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10184] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(574), 1,
      sym_paren_right,
    STATE(330), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10198] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(931), 1,
      sym_or_or,
    STATE(331), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10212] = 5,
    ACTIONS(5), 1,
      sym__block_comment,
    ACTIONS(933), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(935), 1,
      aux_sym__comment_token1,
    ACTIONS(937), 1,
      sym__space,
    STATE(332), 1,
      sym__comment,
  [10228] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(861), 1,
      sym_comma,
    STATE(333), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10242] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(939), 1,
      sym_brace_left,
    STATE(334), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10256] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(941), 1,
      sym_brace_left,
    STATE(335), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10270] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(943), 1,
      sym_or,
    STATE(336), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10284] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(945), 1,
      sym_ident,
    STATE(337), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10298] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(947), 1,
      sym_and,
    STATE(338), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10312] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(949), 1,
      sym_greater_than,
    STATE(339), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10326] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(951), 1,
      sym_semicolon,
    STATE(340), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10340] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(953), 1,
      sym_paren_right,
    STATE(341), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10354] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(955), 1,
      sym_comma,
    STATE(342), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10368] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(957), 1,
      sym_semicolon,
    STATE(343), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10382] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(959), 1,
      sym_semicolon,
    STATE(344), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10396] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(961), 1,
      sym_xor,
    STATE(345), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10410] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(963), 1,
      sym_semicolon,
    STATE(346), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10424] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(965), 1,
      sym_semicolon,
    STATE(347), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10438] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(338), 1,
      sym_brace_right,
    STATE(348), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10452] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(967), 1,
      sym_paren_right,
    STATE(349), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10466] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(969), 1,
      sym_brace_left,
    STATE(350), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10480] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(971), 1,
      sym_brace_left,
    STATE(351), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10494] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(974), 1,
      sym_paren_right,
    STATE(352), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10508] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(976), 1,
      sym_semicolon,
    STATE(353), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10522] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(978), 1,
      sym_brace_left,
    STATE(354), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10536] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(980), 1,
      sym_brace_right,
    STATE(355), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10550] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(982), 1,
      sym_brace_right,
    STATE(356), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10564] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(984), 1,
      sym_greater_than,
    STATE(357), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10578] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(986), 1,
      sym_colon,
    STATE(358), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10592] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(988), 1,
      sym_brace_left,
    STATE(359), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10606] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(121), 1,
      sym_semicolon,
    STATE(360), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10620] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(725), 1,
      sym_colon,
    STATE(361), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10634] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(991), 1,
      sym_semicolon,
    STATE(362), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10648] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(993), 1,
      sym_less_than,
    STATE(363), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10662] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(995), 1,
      sym_ident,
    STATE(364), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10676] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(997), 1,
      sym_semicolon,
    STATE(365), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10690] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(999), 1,
      sym_equal,
    STATE(366), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10704] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1001), 1,
      sym_semicolon,
    STATE(367), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10718] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1003), 1,
      sym_brace_left,
    STATE(368), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10732] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1005), 1,
      sym_semicolon,
    STATE(369), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10746] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(572), 1,
      sym_paren_right,
    STATE(370), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10760] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1007), 1,
      sym_paren_left,
    STATE(371), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10774] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1009), 1,
      sym_semicolon,
    STATE(372), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10788] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1011), 1,
      sym_semicolon,
    STATE(373), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10802] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1013), 1,
      sym_less_than,
    STATE(374), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10816] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1015), 1,
      sym_semicolon,
    STATE(375), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10830] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1017), 1,
      sym_paren_left,
    STATE(376), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10844] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1019), 1,
      sym_less_than,
    STATE(377), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10858] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1021), 1,
      sym_less_than,
    STATE(378), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10872] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1023), 1,
      sym_semicolon,
    STATE(379), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10886] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1025), 1,
      sym_less_than,
    STATE(380), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10900] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1027), 1,
      sym_less_than,
    STATE(381), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10914] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1029), 1,
      sym_less_than,
    STATE(382), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10928] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(921), 1,
      sym_equal,
    STATE(383), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10942] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1031), 1,
      sym_comma,
    STATE(384), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10956] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1033), 1,
      sym_less_than,
    STATE(385), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10970] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(843), 1,
      sym_comma,
    STATE(386), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10984] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1035), 1,
      sym_comma,
    STATE(387), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [10998] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1037), 1,
      sym_ident,
    STATE(388), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11012] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1039), 1,
      sym_semicolon,
    STATE(389), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11026] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1041), 1,
      sym_greater_than,
    STATE(390), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11040] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1043), 1,
      sym_greater_than,
    STATE(391), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11054] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1045), 1,
      sym_greater_than,
    STATE(392), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11068] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(731), 1,
      sym_semicolon,
    STATE(393), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11082] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1047), 1,
      sym_semicolon,
    STATE(394), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11096] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1049), 1,
      sym_semicolon,
    STATE(395), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11110] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(280), 1,
      sym_brace_right,
    STATE(396), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11124] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1051), 1,
      sym_brace_left,
    STATE(397), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11138] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1053), 1,
      sym_ident,
    STATE(398), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11152] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1055), 1,
      sym_ident,
    STATE(399), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11166] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1057), 1,
      sym_less_than,
    STATE(400), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11180] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1059), 1,
      sym_comma,
    STATE(401), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11194] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1061), 1,
      sym_greater_than,
    STATE(402), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11208] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1063), 1,
      sym_greater_than,
    STATE(403), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11222] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1065), 1,
      sym_brace_left,
    STATE(404), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11236] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1067), 1,
      sym_colon,
    STATE(405), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11250] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1069), 1,
      sym_equal,
    STATE(406), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11264] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1071), 1,
      sym_greater_than,
    STATE(407), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11278] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1073), 1,
      sym_paren_left,
    STATE(408), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11292] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1075), 1,
      sym_ident,
    STATE(409), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11306] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1077), 1,
      sym_paren_right,
    STATE(410), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11320] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1079), 1,
      sym_comma,
    STATE(411), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11334] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1081), 1,
      sym_bracket_right,
    STATE(412), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11348] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1083), 1,
      sym_semicolon,
    STATE(413), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11362] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1085), 1,
      sym_greater_than,
    STATE(414), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11376] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1087), 1,
      sym_comma,
    STATE(415), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11390] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1089), 1,
      sym_less_than,
    STATE(416), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11404] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1091), 1,
      sym_semicolon,
    STATE(417), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11418] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1093), 1,
      sym_less_than,
    STATE(418), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11432] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1095), 1,
      sym_ident,
    STATE(419), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11446] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1097), 1,
      sym_paren_right,
    STATE(420), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11460] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1099), 1,
      sym_paren_right,
    STATE(421), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11474] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1101), 1,
      sym_bracket_right,
    STATE(422), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11488] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1103), 1,
      sym_paren_right,
    STATE(423), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11502] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1105), 1,
      sym_greater_than,
    STATE(424), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11516] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1107), 1,
      sym_brace_right,
    STATE(425), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11530] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1109), 1,
      sym_brace_right,
    STATE(426), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11544] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1111), 1,
      sym_semicolon,
    STATE(427), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11558] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1113), 1,
      ts_builtin_sym_end,
    STATE(428), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11572] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1115), 1,
      sym_bracket_right,
    STATE(429), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11586] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1117), 1,
      sym_greater_than,
    STATE(430), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11600] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1119), 1,
      sym_ident,
    STATE(431), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11614] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1121), 1,
      sym_semicolon,
    STATE(432), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11628] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1123), 1,
      sym_ident,
    STATE(433), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11642] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1125), 1,
      sym_greater_than,
    STATE(434), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11656] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1127), 1,
      sym_ident,
    STATE(435), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11670] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1129), 1,
      sym_ident,
    STATE(436), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11684] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 1,
      sym_less_than,
    STATE(437), 1,
      sym__comment,
    ACTIONS(5), 2,
      sym__block_comment,
      sym__space,
  [11698] = 1,
    ACTIONS(1133), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(36)] = 0,
  [SMALL_STATE(37)] = 121,
  [SMALL_STATE(38)] = 239,
  [SMALL_STATE(39)] = 355,
  [SMALL_STATE(40)] = 470,
  [SMALL_STATE(41)] = 585,
  [SMALL_STATE(42)] = 700,
  [SMALL_STATE(43)] = 770,
  [SMALL_STATE(44)] = 840,
  [SMALL_STATE(45)] = 910,
  [SMALL_STATE(46)] = 980,
  [SMALL_STATE(47)] = 1050,
  [SMALL_STATE(48)] = 1120,
  [SMALL_STATE(49)] = 1187,
  [SMALL_STATE(50)] = 1281,
  [SMALL_STATE(51)] = 1375,
  [SMALL_STATE(52)] = 1469,
  [SMALL_STATE(53)] = 1563,
  [SMALL_STATE(54)] = 1657,
  [SMALL_STATE(55)] = 1751,
  [SMALL_STATE(56)] = 1845,
  [SMALL_STATE(57)] = 1939,
  [SMALL_STATE(58)] = 2033,
  [SMALL_STATE(59)] = 2127,
  [SMALL_STATE(60)] = 2221,
  [SMALL_STATE(61)] = 2315,
  [SMALL_STATE(62)] = 2409,
  [SMALL_STATE(63)] = 2503,
  [SMALL_STATE(64)] = 2597,
  [SMALL_STATE(65)] = 2660,
  [SMALL_STATE(66)] = 2723,
  [SMALL_STATE(67)] = 2783,
  [SMALL_STATE(68)] = 2845,
  [SMALL_STATE(69)] = 2903,
  [SMALL_STATE(70)] = 2961,
  [SMALL_STATE(71)] = 3019,
  [SMALL_STATE(72)] = 3081,
  [SMALL_STATE(73)] = 3183,
  [SMALL_STATE(74)] = 3285,
  [SMALL_STATE(75)] = 3384,
  [SMALL_STATE(76)] = 3481,
  [SMALL_STATE(77)] = 3580,
  [SMALL_STATE(78)] = 3677,
  [SMALL_STATE(79)] = 3730,
  [SMALL_STATE(80)] = 3826,
  [SMALL_STATE(81)] = 3922,
  [SMALL_STATE(82)] = 3967,
  [SMALL_STATE(83)] = 4014,
  [SMALL_STATE(84)] = 4055,
  [SMALL_STATE(85)] = 4096,
  [SMALL_STATE(86)] = 4143,
  [SMALL_STATE(87)] = 4189,
  [SMALL_STATE(88)] = 4229,
  [SMALL_STATE(89)] = 4269,
  [SMALL_STATE(90)] = 4309,
  [SMALL_STATE(91)] = 4348,
  [SMALL_STATE(92)] = 4387,
  [SMALL_STATE(93)] = 4426,
  [SMALL_STATE(94)] = 4465,
  [SMALL_STATE(95)] = 4504,
  [SMALL_STATE(96)] = 4543,
  [SMALL_STATE(97)] = 4582,
  [SMALL_STATE(98)] = 4620,
  [SMALL_STATE(99)] = 4658,
  [SMALL_STATE(100)] = 4695,
  [SMALL_STATE(101)] = 4732,
  [SMALL_STATE(102)] = 4777,
  [SMALL_STATE(103)] = 4848,
  [SMALL_STATE(104)] = 4885,
  [SMALL_STATE(105)] = 4923,
  [SMALL_STATE(106)] = 4963,
  [SMALL_STATE(107)] = 5004,
  [SMALL_STATE(108)] = 5039,
  [SMALL_STATE(109)] = 5080,
  [SMALL_STATE(110)] = 5115,
  [SMALL_STATE(111)] = 5156,
  [SMALL_STATE(112)] = 5191,
  [SMALL_STATE(113)] = 5226,
  [SMALL_STATE(114)] = 5261,
  [SMALL_STATE(115)] = 5296,
  [SMALL_STATE(116)] = 5331,
  [SMALL_STATE(117)] = 5366,
  [SMALL_STATE(118)] = 5401,
  [SMALL_STATE(119)] = 5435,
  [SMALL_STATE(120)] = 5469,
  [SMALL_STATE(121)] = 5503,
  [SMALL_STATE(122)] = 5537,
  [SMALL_STATE(123)] = 5571,
  [SMALL_STATE(124)] = 5607,
  [SMALL_STATE(125)] = 5641,
  [SMALL_STATE(126)] = 5675,
  [SMALL_STATE(127)] = 5709,
  [SMALL_STATE(128)] = 5743,
  [SMALL_STATE(129)] = 5777,
  [SMALL_STATE(130)] = 5811,
  [SMALL_STATE(131)] = 5870,
  [SMALL_STATE(132)] = 5927,
  [SMALL_STATE(133)] = 5986,
  [SMALL_STATE(134)] = 6018,
  [SMALL_STATE(135)] = 6054,
  [SMALL_STATE(136)] = 6086,
  [SMALL_STATE(137)] = 6118,
  [SMALL_STATE(138)] = 6150,
  [SMALL_STATE(139)] = 6182,
  [SMALL_STATE(140)] = 6214,
  [SMALL_STATE(141)] = 6250,
  [SMALL_STATE(142)] = 6282,
  [SMALL_STATE(143)] = 6335,
  [SMALL_STATE(144)] = 6366,
  [SMALL_STATE(145)] = 6396,
  [SMALL_STATE(146)] = 6427,
  [SMALL_STATE(147)] = 6456,
  [SMALL_STATE(148)] = 6483,
  [SMALL_STATE(149)] = 6511,
  [SMALL_STATE(150)] = 6539,
  [SMALL_STATE(151)] = 6579,
  [SMALL_STATE(152)] = 6619,
  [SMALL_STATE(153)] = 6659,
  [SMALL_STATE(154)] = 6691,
  [SMALL_STATE(155)] = 6717,
  [SMALL_STATE(156)] = 6739,
  [SMALL_STATE(157)] = 6771,
  [SMALL_STATE(158)] = 6793,
  [SMALL_STATE(159)] = 6825,
  [SMALL_STATE(160)] = 6863,
  [SMALL_STATE(161)] = 6901,
  [SMALL_STATE(162)] = 6923,
  [SMALL_STATE(163)] = 6944,
  [SMALL_STATE(164)] = 6975,
  [SMALL_STATE(165)] = 7010,
  [SMALL_STATE(166)] = 7037,
  [SMALL_STATE(167)] = 7058,
  [SMALL_STATE(168)] = 7093,
  [SMALL_STATE(169)] = 7122,
  [SMALL_STATE(170)] = 7153,
  [SMALL_STATE(171)] = 7180,
  [SMALL_STATE(172)] = 7213,
  [SMALL_STATE(173)] = 7242,
  [SMALL_STATE(174)] = 7263,
  [SMALL_STATE(175)] = 7284,
  [SMALL_STATE(176)] = 7311,
  [SMALL_STATE(177)] = 7334,
  [SMALL_STATE(178)] = 7354,
  [SMALL_STATE(179)] = 7374,
  [SMALL_STATE(180)] = 7394,
  [SMALL_STATE(181)] = 7414,
  [SMALL_STATE(182)] = 7434,
  [SMALL_STATE(183)] = 7464,
  [SMALL_STATE(184)] = 7484,
  [SMALL_STATE(185)] = 7504,
  [SMALL_STATE(186)] = 7524,
  [SMALL_STATE(187)] = 7544,
  [SMALL_STATE(188)] = 7564,
  [SMALL_STATE(189)] = 7584,
  [SMALL_STATE(190)] = 7614,
  [SMALL_STATE(191)] = 7634,
  [SMALL_STATE(192)] = 7654,
  [SMALL_STATE(193)] = 7674,
  [SMALL_STATE(194)] = 7694,
  [SMALL_STATE(195)] = 7714,
  [SMALL_STATE(196)] = 7734,
  [SMALL_STATE(197)] = 7754,
  [SMALL_STATE(198)] = 7786,
  [SMALL_STATE(199)] = 7806,
  [SMALL_STATE(200)] = 7826,
  [SMALL_STATE(201)] = 7846,
  [SMALL_STATE(202)] = 7866,
  [SMALL_STATE(203)] = 7886,
  [SMALL_STATE(204)] = 7909,
  [SMALL_STATE(205)] = 7928,
  [SMALL_STATE(206)] = 7949,
  [SMALL_STATE(207)] = 7970,
  [SMALL_STATE(208)] = 7997,
  [SMALL_STATE(209)] = 8021,
  [SMALL_STATE(210)] = 8043,
  [SMALL_STATE(211)] = 8067,
  [SMALL_STATE(212)] = 8087,
  [SMALL_STATE(213)] = 8111,
  [SMALL_STATE(214)] = 8129,
  [SMALL_STATE(215)] = 8155,
  [SMALL_STATE(216)] = 8181,
  [SMALL_STATE(217)] = 8201,
  [SMALL_STATE(218)] = 8227,
  [SMALL_STATE(219)] = 8245,
  [SMALL_STATE(220)] = 8265,
  [SMALL_STATE(221)] = 8283,
  [SMALL_STATE(222)] = 8303,
  [SMALL_STATE(223)] = 8323,
  [SMALL_STATE(224)] = 8343,
  [SMALL_STATE(225)] = 8361,
  [SMALL_STATE(226)] = 8379,
  [SMALL_STATE(227)] = 8399,
  [SMALL_STATE(228)] = 8423,
  [SMALL_STATE(229)] = 8446,
  [SMALL_STATE(230)] = 8469,
  [SMALL_STATE(231)] = 8492,
  [SMALL_STATE(232)] = 8509,
  [SMALL_STATE(233)] = 8532,
  [SMALL_STATE(234)] = 8549,
  [SMALL_STATE(235)] = 8570,
  [SMALL_STATE(236)] = 8593,
  [SMALL_STATE(237)] = 8614,
  [SMALL_STATE(238)] = 8635,
  [SMALL_STATE(239)] = 8652,
  [SMALL_STATE(240)] = 8673,
  [SMALL_STATE(241)] = 8690,
  [SMALL_STATE(242)] = 8711,
  [SMALL_STATE(243)] = 8732,
  [SMALL_STATE(244)] = 8748,
  [SMALL_STATE(245)] = 8764,
  [SMALL_STATE(246)] = 8784,
  [SMALL_STATE(247)] = 8804,
  [SMALL_STATE(248)] = 8822,
  [SMALL_STATE(249)] = 8838,
  [SMALL_STATE(250)] = 8856,
  [SMALL_STATE(251)] = 8874,
  [SMALL_STATE(252)] = 8894,
  [SMALL_STATE(253)] = 8912,
  [SMALL_STATE(254)] = 8930,
  [SMALL_STATE(255)] = 8946,
  [SMALL_STATE(256)] = 8962,
  [SMALL_STATE(257)] = 8982,
  [SMALL_STATE(258)] = 8998,
  [SMALL_STATE(259)] = 9014,
  [SMALL_STATE(260)] = 9030,
  [SMALL_STATE(261)] = 9046,
  [SMALL_STATE(262)] = 9064,
  [SMALL_STATE(263)] = 9084,
  [SMALL_STATE(264)] = 9102,
  [SMALL_STATE(265)] = 9118,
  [SMALL_STATE(266)] = 9134,
  [SMALL_STATE(267)] = 9150,
  [SMALL_STATE(268)] = 9170,
  [SMALL_STATE(269)] = 9185,
  [SMALL_STATE(270)] = 9202,
  [SMALL_STATE(271)] = 9219,
  [SMALL_STATE(272)] = 9236,
  [SMALL_STATE(273)] = 9253,
  [SMALL_STATE(274)] = 9270,
  [SMALL_STATE(275)] = 9287,
  [SMALL_STATE(276)] = 9304,
  [SMALL_STATE(277)] = 9321,
  [SMALL_STATE(278)] = 9338,
  [SMALL_STATE(279)] = 9355,
  [SMALL_STATE(280)] = 9372,
  [SMALL_STATE(281)] = 9389,
  [SMALL_STATE(282)] = 9406,
  [SMALL_STATE(283)] = 9423,
  [SMALL_STATE(284)] = 9438,
  [SMALL_STATE(285)] = 9455,
  [SMALL_STATE(286)] = 9472,
  [SMALL_STATE(287)] = 9489,
  [SMALL_STATE(288)] = 9504,
  [SMALL_STATE(289)] = 9519,
  [SMALL_STATE(290)] = 9536,
  [SMALL_STATE(291)] = 9553,
  [SMALL_STATE(292)] = 9570,
  [SMALL_STATE(293)] = 9585,
  [SMALL_STATE(294)] = 9602,
  [SMALL_STATE(295)] = 9619,
  [SMALL_STATE(296)] = 9636,
  [SMALL_STATE(297)] = 9653,
  [SMALL_STATE(298)] = 9668,
  [SMALL_STATE(299)] = 9683,
  [SMALL_STATE(300)] = 9700,
  [SMALL_STATE(301)] = 9717,
  [SMALL_STATE(302)] = 9732,
  [SMALL_STATE(303)] = 9749,
  [SMALL_STATE(304)] = 9766,
  [SMALL_STATE(305)] = 9783,
  [SMALL_STATE(306)] = 9800,
  [SMALL_STATE(307)] = 9817,
  [SMALL_STATE(308)] = 9834,
  [SMALL_STATE(309)] = 9851,
  [SMALL_STATE(310)] = 9866,
  [SMALL_STATE(311)] = 9883,
  [SMALL_STATE(312)] = 9900,
  [SMALL_STATE(313)] = 9917,
  [SMALL_STATE(314)] = 9932,
  [SMALL_STATE(315)] = 9949,
  [SMALL_STATE(316)] = 9966,
  [SMALL_STATE(317)] = 9981,
  [SMALL_STATE(318)] = 9996,
  [SMALL_STATE(319)] = 10013,
  [SMALL_STATE(320)] = 10028,
  [SMALL_STATE(321)] = 10045,
  [SMALL_STATE(322)] = 10060,
  [SMALL_STATE(323)] = 10077,
  [SMALL_STATE(324)] = 10094,
  [SMALL_STATE(325)] = 10111,
  [SMALL_STATE(326)] = 10128,
  [SMALL_STATE(327)] = 10142,
  [SMALL_STATE(328)] = 10156,
  [SMALL_STATE(329)] = 10170,
  [SMALL_STATE(330)] = 10184,
  [SMALL_STATE(331)] = 10198,
  [SMALL_STATE(332)] = 10212,
  [SMALL_STATE(333)] = 10228,
  [SMALL_STATE(334)] = 10242,
  [SMALL_STATE(335)] = 10256,
  [SMALL_STATE(336)] = 10270,
  [SMALL_STATE(337)] = 10284,
  [SMALL_STATE(338)] = 10298,
  [SMALL_STATE(339)] = 10312,
  [SMALL_STATE(340)] = 10326,
  [SMALL_STATE(341)] = 10340,
  [SMALL_STATE(342)] = 10354,
  [SMALL_STATE(343)] = 10368,
  [SMALL_STATE(344)] = 10382,
  [SMALL_STATE(345)] = 10396,
  [SMALL_STATE(346)] = 10410,
  [SMALL_STATE(347)] = 10424,
  [SMALL_STATE(348)] = 10438,
  [SMALL_STATE(349)] = 10452,
  [SMALL_STATE(350)] = 10466,
  [SMALL_STATE(351)] = 10480,
  [SMALL_STATE(352)] = 10494,
  [SMALL_STATE(353)] = 10508,
  [SMALL_STATE(354)] = 10522,
  [SMALL_STATE(355)] = 10536,
  [SMALL_STATE(356)] = 10550,
  [SMALL_STATE(357)] = 10564,
  [SMALL_STATE(358)] = 10578,
  [SMALL_STATE(359)] = 10592,
  [SMALL_STATE(360)] = 10606,
  [SMALL_STATE(361)] = 10620,
  [SMALL_STATE(362)] = 10634,
  [SMALL_STATE(363)] = 10648,
  [SMALL_STATE(364)] = 10662,
  [SMALL_STATE(365)] = 10676,
  [SMALL_STATE(366)] = 10690,
  [SMALL_STATE(367)] = 10704,
  [SMALL_STATE(368)] = 10718,
  [SMALL_STATE(369)] = 10732,
  [SMALL_STATE(370)] = 10746,
  [SMALL_STATE(371)] = 10760,
  [SMALL_STATE(372)] = 10774,
  [SMALL_STATE(373)] = 10788,
  [SMALL_STATE(374)] = 10802,
  [SMALL_STATE(375)] = 10816,
  [SMALL_STATE(376)] = 10830,
  [SMALL_STATE(377)] = 10844,
  [SMALL_STATE(378)] = 10858,
  [SMALL_STATE(379)] = 10872,
  [SMALL_STATE(380)] = 10886,
  [SMALL_STATE(381)] = 10900,
  [SMALL_STATE(382)] = 10914,
  [SMALL_STATE(383)] = 10928,
  [SMALL_STATE(384)] = 10942,
  [SMALL_STATE(385)] = 10956,
  [SMALL_STATE(386)] = 10970,
  [SMALL_STATE(387)] = 10984,
  [SMALL_STATE(388)] = 10998,
  [SMALL_STATE(389)] = 11012,
  [SMALL_STATE(390)] = 11026,
  [SMALL_STATE(391)] = 11040,
  [SMALL_STATE(392)] = 11054,
  [SMALL_STATE(393)] = 11068,
  [SMALL_STATE(394)] = 11082,
  [SMALL_STATE(395)] = 11096,
  [SMALL_STATE(396)] = 11110,
  [SMALL_STATE(397)] = 11124,
  [SMALL_STATE(398)] = 11138,
  [SMALL_STATE(399)] = 11152,
  [SMALL_STATE(400)] = 11166,
  [SMALL_STATE(401)] = 11180,
  [SMALL_STATE(402)] = 11194,
  [SMALL_STATE(403)] = 11208,
  [SMALL_STATE(404)] = 11222,
  [SMALL_STATE(405)] = 11236,
  [SMALL_STATE(406)] = 11250,
  [SMALL_STATE(407)] = 11264,
  [SMALL_STATE(408)] = 11278,
  [SMALL_STATE(409)] = 11292,
  [SMALL_STATE(410)] = 11306,
  [SMALL_STATE(411)] = 11320,
  [SMALL_STATE(412)] = 11334,
  [SMALL_STATE(413)] = 11348,
  [SMALL_STATE(414)] = 11362,
  [SMALL_STATE(415)] = 11376,
  [SMALL_STATE(416)] = 11390,
  [SMALL_STATE(417)] = 11404,
  [SMALL_STATE(418)] = 11418,
  [SMALL_STATE(419)] = 11432,
  [SMALL_STATE(420)] = 11446,
  [SMALL_STATE(421)] = 11460,
  [SMALL_STATE(422)] = 11474,
  [SMALL_STATE(423)] = 11488,
  [SMALL_STATE(424)] = 11502,
  [SMALL_STATE(425)] = 11516,
  [SMALL_STATE(426)] = 11530,
  [SMALL_STATE(427)] = 11544,
  [SMALL_STATE(428)] = 11558,
  [SMALL_STATE(429)] = 11572,
  [SMALL_STATE(430)] = 11586,
  [SMALL_STATE(431)] = 11600,
  [SMALL_STATE(432)] = 11614,
  [SMALL_STATE(433)] = 11628,
  [SMALL_STATE(434)] = 11642,
  [SMALL_STATE(435)] = 11656,
  [SMALL_STATE(436)] = 11670,
  [SMALL_STATE(437)] = 11684,
  [SMALL_STATE(438)] = 11698,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(382),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(374),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [67] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(81),
  [70] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(88),
  [73] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(87),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(87),
  [79] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(385),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(382),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(191),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(374),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(184),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(326),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(381),
  [100] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(380),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(185),
  [106] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(416),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(31),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(245),
  [115] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(31),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(20),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(191),
  [162] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(88),
  [165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(87),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(87),
  [171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(385),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(382),
  [177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(374),
  [180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(184),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(326),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(381),
  [189] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(380),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(185),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(245),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 2),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_type_decl_repeat1, 2), SHIFT_REPEAT(245),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 4),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 4),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 3),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 1),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_type_decl_repeat1, 1),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 2), SHIFT(363),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [264] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [282] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(209),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(327),
  [292] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(373),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [297] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(372),
  [300] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(371),
  [303] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(305),
  [306] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(306),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(368),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(6),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(307),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(232),
  [321] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(233),
  [324] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(80),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2),
  [329] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(189),
  [332] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(109),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2), SHIFT_REPEAT(366),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 1),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 1),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 1),
  [354] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(2),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 2),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 2),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 3),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 3),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 2),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 2),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 3),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 3),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 1),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 1),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_literal, 1),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_literal, 1),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_literal, 1),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_literal, 1),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expression, 3),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expression, 3),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 2),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 2),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 3),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 3),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 5),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 5),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 4),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 4),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 5),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 5),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 2),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 2),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 4),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 4),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 1),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 1),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 2),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 2),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_and_expression, 1),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 1),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 1),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_or_expression, 1),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_xor_expression, 1),
  [441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 1),
  [443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [449] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [453] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(3),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 4),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 4),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_statement, 5),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 5),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 5),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 3),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 3),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 1),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 1),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2),
  [502] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(436),
  [505] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(433),
  [508] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(270),
  [511] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(431),
  [514] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(232),
  [517] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(245),
  [520] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2), SHIFT_REPEAT(174),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 2),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 3),
  [527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 3),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 1),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 1),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 3),
  [539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 3),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 1),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 1),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2),
  [553] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(435),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 1),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 3),
  [564] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 3),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 2),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 2),
  [580] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(4),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 1),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 3),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_directive, 1),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enable_directive, 3),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 2),
  [611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [613] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(321),
  [616] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(88),
  [619] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(321),
  [622] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(361),
  [625] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(245),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 3),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 1),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 6),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 8),
  [640] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 5),
  [642] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(361),
  [645] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(245),
  [648] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 4),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampler_type, 1),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_depth_texture_type, 1),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 1),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 4),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 4),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 1),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 6),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 7),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 6),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 1),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 1),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 3),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_core_lhs_expression, 1),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 2),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 2),
  [690] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 2), SHIFT_REPEAT(233),
  [693] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(158),
  [696] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(405),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 3),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 3),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_or_expression, 3),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_and_expression, 3),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_xor_expression, 3),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 1),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 2),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 3),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_core_lhs_expression, 3),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lhs_expression_repeat1, 1),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [747] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ident_decl, 3),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 6),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 1),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 2),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 3),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 3),
  [773] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2), SHIFT_REPEAT(249),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 1),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 4),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 1),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 6),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 5),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 4),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2),
  [790] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2), SHIFT_REPEAT(172),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 2),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 2),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 3),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 5),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 2),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 1),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lhs_expression, 3),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 2),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_class, 1),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 5),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 1),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_call_statement, 2),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 4),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 1),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 1),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal_or_ident, 1),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampled_texture_type, 1),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_statement, 1),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [933] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [935] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [937] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 3),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_decl, 4),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 5),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_const_initializer, 2),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 3),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [971] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_array_type_decl, 4), REDUCE(sym_array_type_decl, 5),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 2),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [988] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_array_type_decl, 6), REDUCE(sym_array_type_decl, 7),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 2),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 4),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 4),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continue_statement, 1),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 3),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 4),
  [1025] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_texture_type, 1),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multisampled_texture_type, 1),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1037] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_count_expression, 1),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 3),
  [1049] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 3),
  [1051] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 5),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access_mode, 1),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1065] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texel_format, 1),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [1109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continuing_statement, 2),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1113] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 4),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_wgsl_external_scanner_create(void);
void tree_sitter_wgsl_external_scanner_destroy(void *);
bool tree_sitter_wgsl_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_wgsl_external_scanner_serialize(void *, char *);
void tree_sitter_wgsl_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wgsl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_ident,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_wgsl_external_scanner_create,
      tree_sitter_wgsl_external_scanner_destroy,
      tree_sitter_wgsl_external_scanner_scan,
      tree_sitter_wgsl_external_scanner_serialize,
      tree_sitter_wgsl_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
