#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 354
#define LARGE_STATE_COUNT 53
#define SYMBOL_COUNT 254
#define ALIAS_COUNT 0
#define TOKEN_COUNT 171
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  sym_ident = 1,
  sym_decimal_float_literal = 2,
  sym_hex_float_literal = 3,
  sym_int_literal = 4,
  sym_uint_literal = 5,
  sym_array = 6,
  sym_atomic = 7,
  sym_bool = 8,
  sym_float32 = 9,
  sym_int32 = 10,
  sym_mat2x2 = 11,
  sym_mat2x3 = 12,
  sym_mat2x4 = 13,
  sym_mat3x2 = 14,
  sym_mat3x3 = 15,
  sym_mat3x4 = 16,
  sym_mat4x2 = 17,
  sym_mat4x3 = 18,
  sym_mat4x4 = 19,
  sym_pointer = 20,
  sym_sampler = 21,
  sym_sampler_comparison = 22,
  sym_struct = 23,
  sym_texture_1d = 24,
  sym_texture_2d = 25,
  sym_texture_2d_array = 26,
  sym_texture_3d = 27,
  sym_texture_cube = 28,
  sym_texture_cube_array = 29,
  sym_texture_multisampled_2d = 30,
  sym_texture_storage_1d = 31,
  sym_texture_storage_2d = 32,
  sym_texture_storage_2d_array = 33,
  sym_texture_storage_3d = 34,
  sym_texture_depth_2d = 35,
  sym_texture_depth_2d_array = 36,
  sym_texture_depth_cube = 37,
  sym_texture_depth_cube_array = 38,
  sym_texture_depth_multisampled_2d = 39,
  sym_uint32 = 40,
  sym_vec2 = 41,
  sym_vec3 = 42,
  sym_vec4 = 43,
  sym_bitcast = 44,
  sym_block = 45,
  sym_break = 46,
  sym_case = 47,
  sym_continue = 48,
  sym_continuing = 49,
  sym_default = 50,
  sym_discard = 51,
  sym_else = 52,
  sym_else_if = 53,
  sym_enable = 54,
  sym_fallthrough = 55,
  sym_false = 56,
  sym_fn = 57,
  sym_for = 58,
  sym_function = 59,
  sym_if = 60,
  sym_let = 61,
  sym_loop = 62,
  sym_private = 63,
  sym_read = 64,
  sym_read_write = 65,
  sym_return = 66,
  sym_storage = 67,
  sym_switch = 68,
  sym_true = 69,
  sym_type = 70,
  sym_uniform = 71,
  sym_var = 72,
  sym_workgroup = 73,
  sym_write = 74,
  sym_r8unorm = 75,
  sym_r8snorm = 76,
  sym_r8uint = 77,
  sym_r8sint = 78,
  sym_r16uint = 79,
  sym_r16sint = 80,
  sym_r16float = 81,
  sym_rg8unorm = 82,
  sym_rg8snorm = 83,
  sym_rg8uint = 84,
  sym_rg8sint = 85,
  sym_r32uint = 86,
  sym_r32sint = 87,
  sym_r32float = 88,
  sym_rg16uint = 89,
  sym_rg16sint = 90,
  sym_rg16float = 91,
  sym_rgba8unorm = 92,
  sym_rgba8unorm_srgb = 93,
  sym_rgba8snorm = 94,
  sym_rgba8uint = 95,
  sym_rgba8sint = 96,
  sym_bgra8unorm = 97,
  sym_bgra8unorm_srgb = 98,
  sym_rgb10a2unorm = 99,
  sym_rg11b10float = 100,
  sym_rg32uint = 101,
  sym_rg32sint = 102,
  sym_rg32float = 103,
  sym_rgba16uint = 104,
  sym_rgba16sint = 105,
  sym_rgba16float = 106,
  sym_rgba32uint = 107,
  sym_rgba32sint = 108,
  sym_rgba32float = 109,
  sym_and = 110,
  sym_and_and = 111,
  sym_arrow = 112,
  sym_attr_left = 113,
  sym_attr_right = 114,
  sym_forward_slash = 115,
  sym_bang = 116,
  sym_bracket_left = 117,
  sym_bracket_right = 118,
  sym_brace_left = 119,
  sym_brace_right = 120,
  sym_colon = 121,
  sym_comma = 122,
  sym_equal = 123,
  sym_equal_equal = 124,
  sym_not_equal = 125,
  sym_greater_than = 126,
  sym_greater_than_equal = 127,
  sym_shift_right = 128,
  sym_less_than = 129,
  sym_less_than_equal = 130,
  sym_shift_left = 131,
  sym_modulo = 132,
  sym_minus = 133,
  sym_period = 134,
  sym_plus = 135,
  sym_plus_plus = 136,
  sym_or = 137,
  sym_or_or = 138,
  sym_paren_left = 139,
  sym_paren_right = 140,
  sym_semicolon = 141,
  sym_star = 142,
  sym_tilde = 143,
  sym_xor = 144,
  aux_sym__reserved_token1 = 145,
  aux_sym__reserved_token2 = 146,
  aux_sym__reserved_token3 = 147,
  aux_sym__reserved_token4 = 148,
  aux_sym__reserved_token5 = 149,
  aux_sym__reserved_token6 = 150,
  aux_sym__reserved_token7 = 151,
  aux_sym__reserved_token8 = 152,
  aux_sym__reserved_token9 = 153,
  aux_sym__reserved_token10 = 154,
  aux_sym__reserved_token11 = 155,
  aux_sym__reserved_token12 = 156,
  aux_sym__reserved_token13 = 157,
  aux_sym__reserved_token14 = 158,
  aux_sym__reserved_token15 = 159,
  aux_sym__reserved_token16 = 160,
  aux_sym__reserved_token17 = 161,
  aux_sym__reserved_token18 = 162,
  aux_sym__reserved_token19 = 163,
  aux_sym__reserved_token20 = 164,
  aux_sym__reserved_token21 = 165,
  aux_sym__reserved_token22 = 166,
  aux_sym__reserved_token23 = 167,
  aux_sym__comment_token1 = 168,
  aux_sym__comment_token2 = 169,
  sym__space = 170,
  sym_translation_unit = 171,
  sym_const_literal = 172,
  sym_float_literal = 173,
  sym_attribute_list = 174,
  sym_attribute = 175,
  sym_literal_or_ident = 176,
  sym_array_type_decl = 177,
  sym_element_count_expression = 178,
  sym_struct_decl = 179,
  sym_struct_body_decl = 180,
  sym_struct_member = 181,
  sym_access_mode = 182,
  sym_storage_class = 183,
  sym_texture_sampler_types = 184,
  sym_sampler_type = 185,
  sym_sampled_texture_type = 186,
  sym_multisampled_texture_type = 187,
  sym_storage_texture_type = 188,
  sym_depth_texture_type = 189,
  sym_texel_format = 190,
  sym_type_alias = 191,
  sym_type_decl = 192,
  sym_variable_statement = 193,
  sym_variable_decl = 194,
  sym_variable_ident_decl = 195,
  sym_variable_qualifier = 196,
  sym_global_variable_decl = 197,
  sym_global_constant_decl = 198,
  sym_global_const_initializer = 199,
  sym_const_expression = 200,
  sym_primary_expression = 201,
  sym_paren_expression = 202,
  sym_argument_expression_list = 203,
  sym_postfix_expression = 204,
  sym_unary_expression = 205,
  sym_singular_expression = 206,
  sym_multiplicative_expression = 207,
  sym_additive_expression = 208,
  sym_shift_expression = 209,
  sym_relational_expression = 210,
  sym_equality_expression = 211,
  sym_and_expression = 212,
  sym_exclusive_or_expression = 213,
  sym_inclusive_or_expression = 214,
  sym_short_circuit_and_expression = 215,
  sym_short_circuit_or_expression = 216,
  sym_compound_statement = 217,
  sym_assignment_statement = 218,
  sym_if_statement = 219,
  sym_elseif_statement = 220,
  sym_else_statement = 221,
  sym_switch_statement = 222,
  sym_switch_body = 223,
  sym_case_selectors = 224,
  sym_case_body = 225,
  sym_loop_statement = 226,
  sym_for_statement = 227,
  sym_for_header = 228,
  sym_break_statement = 229,
  sym_continue_statement = 230,
  sym_continuing_statement = 231,
  sym_return_statement = 232,
  sym_func_call_statement = 233,
  sym_statements = 234,
  sym_statement = 235,
  sym_function_decl = 236,
  sym_function_header = 237,
  sym_function_return_type_decl_optional = 238,
  sym_param_list = 239,
  sym_param = 240,
  sym_enable_directive = 241,
  sym__comment = 242,
  aux_sym_translation_unit_repeat1 = 243,
  aux_sym_attribute_list_repeat1 = 244,
  aux_sym_attribute_repeat1 = 245,
  aux_sym_array_type_decl_repeat1 = 246,
  aux_sym_struct_body_decl_repeat1 = 247,
  aux_sym_const_expression_repeat1 = 248,
  aux_sym_argument_expression_list_repeat1 = 249,
  aux_sym_switch_statement_repeat1 = 250,
  aux_sym_case_selectors_repeat1 = 251,
  aux_sym_statements_repeat1 = 252,
  aux_sym_param_list_repeat1 = 253,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_ident] = "ident",
  [sym_decimal_float_literal] = "decimal_float_literal",
  [sym_hex_float_literal] = "hex_float_literal",
  [sym_int_literal] = "int_literal",
  [sym_uint_literal] = "uint_literal",
  [sym_array] = "array",
  [sym_atomic] = "atomic",
  [sym_bool] = "bool",
  [sym_float32] = "float32",
  [sym_int32] = "int32",
  [sym_mat2x2] = "mat2x2",
  [sym_mat2x3] = "mat2x3",
  [sym_mat2x4] = "mat2x4",
  [sym_mat3x2] = "mat3x2",
  [sym_mat3x3] = "mat3x3",
  [sym_mat3x4] = "mat3x4",
  [sym_mat4x2] = "mat4x2",
  [sym_mat4x3] = "mat4x3",
  [sym_mat4x4] = "mat4x4",
  [sym_pointer] = "pointer",
  [sym_sampler] = "sampler",
  [sym_sampler_comparison] = "sampler_comparison",
  [sym_struct] = "struct",
  [sym_texture_1d] = "texture_1d",
  [sym_texture_2d] = "texture_2d",
  [sym_texture_2d_array] = "texture_2d_array",
  [sym_texture_3d] = "texture_3d",
  [sym_texture_cube] = "texture_cube",
  [sym_texture_cube_array] = "texture_cube_array",
  [sym_texture_multisampled_2d] = "texture_multisampled_2d",
  [sym_texture_storage_1d] = "texture_storage_1d",
  [sym_texture_storage_2d] = "texture_storage_2d",
  [sym_texture_storage_2d_array] = "texture_storage_2d_array",
  [sym_texture_storage_3d] = "texture_storage_3d",
  [sym_texture_depth_2d] = "texture_depth_2d",
  [sym_texture_depth_2d_array] = "texture_depth_2d_array",
  [sym_texture_depth_cube] = "texture_depth_cube",
  [sym_texture_depth_cube_array] = "texture_depth_cube_array",
  [sym_texture_depth_multisampled_2d] = "texture_depth_multisampled_2d",
  [sym_uint32] = "uint32",
  [sym_vec2] = "vec2",
  [sym_vec3] = "vec3",
  [sym_vec4] = "vec4",
  [sym_bitcast] = "bitcast",
  [sym_block] = "block",
  [sym_break] = "break",
  [sym_case] = "case",
  [sym_continue] = "continue",
  [sym_continuing] = "continuing",
  [sym_default] = "default",
  [sym_discard] = "discard",
  [sym_else] = "else",
  [sym_else_if] = "else_if",
  [sym_enable] = "enable",
  [sym_fallthrough] = "fallthrough",
  [sym_false] = "false",
  [sym_fn] = "fn",
  [sym_for] = "for",
  [sym_function] = "function",
  [sym_if] = "if",
  [sym_let] = "let",
  [sym_loop] = "loop",
  [sym_private] = "private",
  [sym_read] = "read",
  [sym_read_write] = "read_write",
  [sym_return] = "return",
  [sym_storage] = "storage",
  [sym_switch] = "switch",
  [sym_true] = "true",
  [sym_type] = "type",
  [sym_uniform] = "uniform",
  [sym_var] = "var",
  [sym_workgroup] = "workgroup",
  [sym_write] = "write",
  [sym_r8unorm] = "r8unorm",
  [sym_r8snorm] = "r8snorm",
  [sym_r8uint] = "r8uint",
  [sym_r8sint] = "r8sint",
  [sym_r16uint] = "r16uint",
  [sym_r16sint] = "r16sint",
  [sym_r16float] = "r16float",
  [sym_rg8unorm] = "rg8unorm",
  [sym_rg8snorm] = "rg8snorm",
  [sym_rg8uint] = "rg8uint",
  [sym_rg8sint] = "rg8sint",
  [sym_r32uint] = "r32uint",
  [sym_r32sint] = "r32sint",
  [sym_r32float] = "r32float",
  [sym_rg16uint] = "rg16uint",
  [sym_rg16sint] = "rg16sint",
  [sym_rg16float] = "rg16float",
  [sym_rgba8unorm] = "rgba8unorm",
  [sym_rgba8unorm_srgb] = "rgba8unorm_srgb",
  [sym_rgba8snorm] = "rgba8snorm",
  [sym_rgba8uint] = "rgba8uint",
  [sym_rgba8sint] = "rgba8sint",
  [sym_bgra8unorm] = "bgra8unorm",
  [sym_bgra8unorm_srgb] = "bgra8unorm_srgb",
  [sym_rgb10a2unorm] = "rgb10a2unorm",
  [sym_rg11b10float] = "rg11b10float",
  [sym_rg32uint] = "rg32uint",
  [sym_rg32sint] = "rg32sint",
  [sym_rg32float] = "rg32float",
  [sym_rgba16uint] = "rgba16uint",
  [sym_rgba16sint] = "rgba16sint",
  [sym_rgba16float] = "rgba16float",
  [sym_rgba32uint] = "rgba32uint",
  [sym_rgba32sint] = "rgba32sint",
  [sym_rgba32float] = "rgba32float",
  [sym_and] = "and",
  [sym_and_and] = "and_and",
  [sym_arrow] = "arrow",
  [sym_attr_left] = "attr_left",
  [sym_attr_right] = "attr_right",
  [sym_forward_slash] = "forward_slash",
  [sym_bang] = "bang",
  [sym_bracket_left] = "bracket_left",
  [sym_bracket_right] = "bracket_right",
  [sym_brace_left] = "brace_left",
  [sym_brace_right] = "brace_right",
  [sym_colon] = "colon",
  [sym_comma] = "comma",
  [sym_equal] = "equal",
  [sym_equal_equal] = "equal_equal",
  [sym_not_equal] = "not_equal",
  [sym_greater_than] = "greater_than",
  [sym_greater_than_equal] = "greater_than_equal",
  [sym_shift_right] = "shift_right",
  [sym_less_than] = "less_than",
  [sym_less_than_equal] = "less_than_equal",
  [sym_shift_left] = "shift_left",
  [sym_modulo] = "modulo",
  [sym_minus] = "minus",
  [sym_period] = "period",
  [sym_plus] = "plus",
  [sym_plus_plus] = "plus_plus",
  [sym_or] = "or",
  [sym_or_or] = "or_or",
  [sym_paren_left] = "paren_left",
  [sym_paren_right] = "paren_right",
  [sym_semicolon] = "semicolon",
  [sym_star] = "star",
  [sym_tilde] = "tilde",
  [sym_xor] = "xor",
  [aux_sym__reserved_token1] = "_reserved_token1",
  [aux_sym__reserved_token2] = "_reserved_token2",
  [aux_sym__reserved_token3] = "_reserved_token3",
  [aux_sym__reserved_token4] = "_reserved_token4",
  [aux_sym__reserved_token5] = "_reserved_token5",
  [aux_sym__reserved_token6] = "_reserved_token6",
  [aux_sym__reserved_token7] = "_reserved_token7",
  [aux_sym__reserved_token8] = "_reserved_token8",
  [aux_sym__reserved_token9] = "_reserved_token9",
  [aux_sym__reserved_token10] = "_reserved_token10",
  [aux_sym__reserved_token11] = "_reserved_token11",
  [aux_sym__reserved_token12] = "_reserved_token12",
  [aux_sym__reserved_token13] = "_reserved_token13",
  [aux_sym__reserved_token14] = "_reserved_token14",
  [aux_sym__reserved_token15] = "_reserved_token15",
  [aux_sym__reserved_token16] = "_reserved_token16",
  [aux_sym__reserved_token17] = "_reserved_token17",
  [aux_sym__reserved_token18] = "_reserved_token18",
  [aux_sym__reserved_token19] = "_reserved_token19",
  [aux_sym__reserved_token20] = "_reserved_token20",
  [aux_sym__reserved_token21] = "_reserved_token21",
  [aux_sym__reserved_token22] = "_reserved_token22",
  [aux_sym__reserved_token23] = "_reserved_token23",
  [aux_sym__comment_token1] = "_comment_token1",
  [aux_sym__comment_token2] = "_comment_token2",
  [sym__space] = "_space",
  [sym_translation_unit] = "translation_unit",
  [sym_const_literal] = "const_literal",
  [sym_float_literal] = "float_literal",
  [sym_attribute_list] = "attribute_list",
  [sym_attribute] = "attribute",
  [sym_literal_or_ident] = "literal_or_ident",
  [sym_array_type_decl] = "array_type_decl",
  [sym_element_count_expression] = "element_count_expression",
  [sym_struct_decl] = "struct_decl",
  [sym_struct_body_decl] = "struct_body_decl",
  [sym_struct_member] = "struct_member",
  [sym_access_mode] = "access_mode",
  [sym_storage_class] = "storage_class",
  [sym_texture_sampler_types] = "texture_sampler_types",
  [sym_sampler_type] = "sampler_type",
  [sym_sampled_texture_type] = "sampled_texture_type",
  [sym_multisampled_texture_type] = "multisampled_texture_type",
  [sym_storage_texture_type] = "storage_texture_type",
  [sym_depth_texture_type] = "depth_texture_type",
  [sym_texel_format] = "texel_format",
  [sym_type_alias] = "type_alias",
  [sym_type_decl] = "type_decl",
  [sym_variable_statement] = "variable_statement",
  [sym_variable_decl] = "variable_decl",
  [sym_variable_ident_decl] = "variable_ident_decl",
  [sym_variable_qualifier] = "variable_qualifier",
  [sym_global_variable_decl] = "global_variable_decl",
  [sym_global_constant_decl] = "global_constant_decl",
  [sym_global_const_initializer] = "global_const_initializer",
  [sym_const_expression] = "const_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_paren_expression] = "paren_expression",
  [sym_argument_expression_list] = "argument_expression_list",
  [sym_postfix_expression] = "postfix_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_singular_expression] = "singular_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_and_expression] = "and_expression",
  [sym_exclusive_or_expression] = "exclusive_or_expression",
  [sym_inclusive_or_expression] = "inclusive_or_expression",
  [sym_short_circuit_and_expression] = "short_circuit_and_expression",
  [sym_short_circuit_or_expression] = "short_circuit_or_expression",
  [sym_compound_statement] = "compound_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_case_selectors] = "case_selectors",
  [sym_case_body] = "case_body",
  [sym_loop_statement] = "loop_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_header] = "for_header",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_continuing_statement] = "continuing_statement",
  [sym_return_statement] = "return_statement",
  [sym_func_call_statement] = "func_call_statement",
  [sym_statements] = "statements",
  [sym_statement] = "statement",
  [sym_function_decl] = "function_decl",
  [sym_function_header] = "function_header",
  [sym_function_return_type_decl_optional] = "function_return_type_decl_optional",
  [sym_param_list] = "param_list",
  [sym_param] = "param",
  [sym_enable_directive] = "enable_directive",
  [sym__comment] = "_comment",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_attribute_list_repeat1] = "attribute_list_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_array_type_decl_repeat1] = "array_type_decl_repeat1",
  [aux_sym_struct_body_decl_repeat1] = "struct_body_decl_repeat1",
  [aux_sym_const_expression_repeat1] = "const_expression_repeat1",
  [aux_sym_argument_expression_list_repeat1] = "argument_expression_list_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym_case_selectors_repeat1] = "case_selectors_repeat1",
  [aux_sym_statements_repeat1] = "statements_repeat1",
  [aux_sym_param_list_repeat1] = "param_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_ident] = sym_ident,
  [sym_decimal_float_literal] = sym_decimal_float_literal,
  [sym_hex_float_literal] = sym_hex_float_literal,
  [sym_int_literal] = sym_int_literal,
  [sym_uint_literal] = sym_uint_literal,
  [sym_array] = sym_array,
  [sym_atomic] = sym_atomic,
  [sym_bool] = sym_bool,
  [sym_float32] = sym_float32,
  [sym_int32] = sym_int32,
  [sym_mat2x2] = sym_mat2x2,
  [sym_mat2x3] = sym_mat2x3,
  [sym_mat2x4] = sym_mat2x4,
  [sym_mat3x2] = sym_mat3x2,
  [sym_mat3x3] = sym_mat3x3,
  [sym_mat3x4] = sym_mat3x4,
  [sym_mat4x2] = sym_mat4x2,
  [sym_mat4x3] = sym_mat4x3,
  [sym_mat4x4] = sym_mat4x4,
  [sym_pointer] = sym_pointer,
  [sym_sampler] = sym_sampler,
  [sym_sampler_comparison] = sym_sampler_comparison,
  [sym_struct] = sym_struct,
  [sym_texture_1d] = sym_texture_1d,
  [sym_texture_2d] = sym_texture_2d,
  [sym_texture_2d_array] = sym_texture_2d_array,
  [sym_texture_3d] = sym_texture_3d,
  [sym_texture_cube] = sym_texture_cube,
  [sym_texture_cube_array] = sym_texture_cube_array,
  [sym_texture_multisampled_2d] = sym_texture_multisampled_2d,
  [sym_texture_storage_1d] = sym_texture_storage_1d,
  [sym_texture_storage_2d] = sym_texture_storage_2d,
  [sym_texture_storage_2d_array] = sym_texture_storage_2d_array,
  [sym_texture_storage_3d] = sym_texture_storage_3d,
  [sym_texture_depth_2d] = sym_texture_depth_2d,
  [sym_texture_depth_2d_array] = sym_texture_depth_2d_array,
  [sym_texture_depth_cube] = sym_texture_depth_cube,
  [sym_texture_depth_cube_array] = sym_texture_depth_cube_array,
  [sym_texture_depth_multisampled_2d] = sym_texture_depth_multisampled_2d,
  [sym_uint32] = sym_uint32,
  [sym_vec2] = sym_vec2,
  [sym_vec3] = sym_vec3,
  [sym_vec4] = sym_vec4,
  [sym_bitcast] = sym_bitcast,
  [sym_block] = sym_block,
  [sym_break] = sym_break,
  [sym_case] = sym_case,
  [sym_continue] = sym_continue,
  [sym_continuing] = sym_continuing,
  [sym_default] = sym_default,
  [sym_discard] = sym_discard,
  [sym_else] = sym_else,
  [sym_else_if] = sym_else_if,
  [sym_enable] = sym_enable,
  [sym_fallthrough] = sym_fallthrough,
  [sym_false] = sym_false,
  [sym_fn] = sym_fn,
  [sym_for] = sym_for,
  [sym_function] = sym_function,
  [sym_if] = sym_if,
  [sym_let] = sym_let,
  [sym_loop] = sym_loop,
  [sym_private] = sym_private,
  [sym_read] = sym_read,
  [sym_read_write] = sym_read_write,
  [sym_return] = sym_return,
  [sym_storage] = sym_storage,
  [sym_switch] = sym_switch,
  [sym_true] = sym_true,
  [sym_type] = sym_type,
  [sym_uniform] = sym_uniform,
  [sym_var] = sym_var,
  [sym_workgroup] = sym_workgroup,
  [sym_write] = sym_write,
  [sym_r8unorm] = sym_r8unorm,
  [sym_r8snorm] = sym_r8snorm,
  [sym_r8uint] = sym_r8uint,
  [sym_r8sint] = sym_r8sint,
  [sym_r16uint] = sym_r16uint,
  [sym_r16sint] = sym_r16sint,
  [sym_r16float] = sym_r16float,
  [sym_rg8unorm] = sym_rg8unorm,
  [sym_rg8snorm] = sym_rg8snorm,
  [sym_rg8uint] = sym_rg8uint,
  [sym_rg8sint] = sym_rg8sint,
  [sym_r32uint] = sym_r32uint,
  [sym_r32sint] = sym_r32sint,
  [sym_r32float] = sym_r32float,
  [sym_rg16uint] = sym_rg16uint,
  [sym_rg16sint] = sym_rg16sint,
  [sym_rg16float] = sym_rg16float,
  [sym_rgba8unorm] = sym_rgba8unorm,
  [sym_rgba8unorm_srgb] = sym_rgba8unorm_srgb,
  [sym_rgba8snorm] = sym_rgba8snorm,
  [sym_rgba8uint] = sym_rgba8uint,
  [sym_rgba8sint] = sym_rgba8sint,
  [sym_bgra8unorm] = sym_bgra8unorm,
  [sym_bgra8unorm_srgb] = sym_bgra8unorm_srgb,
  [sym_rgb10a2unorm] = sym_rgb10a2unorm,
  [sym_rg11b10float] = sym_rg11b10float,
  [sym_rg32uint] = sym_rg32uint,
  [sym_rg32sint] = sym_rg32sint,
  [sym_rg32float] = sym_rg32float,
  [sym_rgba16uint] = sym_rgba16uint,
  [sym_rgba16sint] = sym_rgba16sint,
  [sym_rgba16float] = sym_rgba16float,
  [sym_rgba32uint] = sym_rgba32uint,
  [sym_rgba32sint] = sym_rgba32sint,
  [sym_rgba32float] = sym_rgba32float,
  [sym_and] = sym_and,
  [sym_and_and] = sym_and_and,
  [sym_arrow] = sym_arrow,
  [sym_attr_left] = sym_attr_left,
  [sym_attr_right] = sym_attr_right,
  [sym_forward_slash] = sym_forward_slash,
  [sym_bang] = sym_bang,
  [sym_bracket_left] = sym_bracket_left,
  [sym_bracket_right] = sym_bracket_right,
  [sym_brace_left] = sym_brace_left,
  [sym_brace_right] = sym_brace_right,
  [sym_colon] = sym_colon,
  [sym_comma] = sym_comma,
  [sym_equal] = sym_equal,
  [sym_equal_equal] = sym_equal_equal,
  [sym_not_equal] = sym_not_equal,
  [sym_greater_than] = sym_greater_than,
  [sym_greater_than_equal] = sym_greater_than_equal,
  [sym_shift_right] = sym_shift_right,
  [sym_less_than] = sym_less_than,
  [sym_less_than_equal] = sym_less_than_equal,
  [sym_shift_left] = sym_shift_left,
  [sym_modulo] = sym_modulo,
  [sym_minus] = sym_minus,
  [sym_period] = sym_period,
  [sym_plus] = sym_plus,
  [sym_plus_plus] = sym_plus_plus,
  [sym_or] = sym_or,
  [sym_or_or] = sym_or_or,
  [sym_paren_left] = sym_paren_left,
  [sym_paren_right] = sym_paren_right,
  [sym_semicolon] = sym_semicolon,
  [sym_star] = sym_star,
  [sym_tilde] = sym_tilde,
  [sym_xor] = sym_xor,
  [aux_sym__reserved_token1] = aux_sym__reserved_token1,
  [aux_sym__reserved_token2] = aux_sym__reserved_token2,
  [aux_sym__reserved_token3] = aux_sym__reserved_token3,
  [aux_sym__reserved_token4] = aux_sym__reserved_token4,
  [aux_sym__reserved_token5] = aux_sym__reserved_token5,
  [aux_sym__reserved_token6] = aux_sym__reserved_token6,
  [aux_sym__reserved_token7] = aux_sym__reserved_token7,
  [aux_sym__reserved_token8] = aux_sym__reserved_token8,
  [aux_sym__reserved_token9] = aux_sym__reserved_token9,
  [aux_sym__reserved_token10] = aux_sym__reserved_token10,
  [aux_sym__reserved_token11] = aux_sym__reserved_token11,
  [aux_sym__reserved_token12] = aux_sym__reserved_token12,
  [aux_sym__reserved_token13] = aux_sym__reserved_token13,
  [aux_sym__reserved_token14] = aux_sym__reserved_token14,
  [aux_sym__reserved_token15] = aux_sym__reserved_token15,
  [aux_sym__reserved_token16] = aux_sym__reserved_token16,
  [aux_sym__reserved_token17] = aux_sym__reserved_token17,
  [aux_sym__reserved_token18] = aux_sym__reserved_token18,
  [aux_sym__reserved_token19] = aux_sym__reserved_token19,
  [aux_sym__reserved_token20] = aux_sym__reserved_token20,
  [aux_sym__reserved_token21] = aux_sym__reserved_token21,
  [aux_sym__reserved_token22] = aux_sym__reserved_token22,
  [aux_sym__reserved_token23] = aux_sym__reserved_token23,
  [aux_sym__comment_token1] = aux_sym__comment_token1,
  [aux_sym__comment_token2] = aux_sym__comment_token2,
  [sym__space] = sym__space,
  [sym_translation_unit] = sym_translation_unit,
  [sym_const_literal] = sym_const_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_attribute_list] = sym_attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_literal_or_ident] = sym_literal_or_ident,
  [sym_array_type_decl] = sym_array_type_decl,
  [sym_element_count_expression] = sym_element_count_expression,
  [sym_struct_decl] = sym_struct_decl,
  [sym_struct_body_decl] = sym_struct_body_decl,
  [sym_struct_member] = sym_struct_member,
  [sym_access_mode] = sym_access_mode,
  [sym_storage_class] = sym_storage_class,
  [sym_texture_sampler_types] = sym_texture_sampler_types,
  [sym_sampler_type] = sym_sampler_type,
  [sym_sampled_texture_type] = sym_sampled_texture_type,
  [sym_multisampled_texture_type] = sym_multisampled_texture_type,
  [sym_storage_texture_type] = sym_storage_texture_type,
  [sym_depth_texture_type] = sym_depth_texture_type,
  [sym_texel_format] = sym_texel_format,
  [sym_type_alias] = sym_type_alias,
  [sym_type_decl] = sym_type_decl,
  [sym_variable_statement] = sym_variable_statement,
  [sym_variable_decl] = sym_variable_decl,
  [sym_variable_ident_decl] = sym_variable_ident_decl,
  [sym_variable_qualifier] = sym_variable_qualifier,
  [sym_global_variable_decl] = sym_global_variable_decl,
  [sym_global_constant_decl] = sym_global_constant_decl,
  [sym_global_const_initializer] = sym_global_const_initializer,
  [sym_const_expression] = sym_const_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_paren_expression] = sym_paren_expression,
  [sym_argument_expression_list] = sym_argument_expression_list,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_singular_expression] = sym_singular_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_and_expression] = sym_and_expression,
  [sym_exclusive_or_expression] = sym_exclusive_or_expression,
  [sym_inclusive_or_expression] = sym_inclusive_or_expression,
  [sym_short_circuit_and_expression] = sym_short_circuit_and_expression,
  [sym_short_circuit_or_expression] = sym_short_circuit_or_expression,
  [sym_compound_statement] = sym_compound_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_case_selectors] = sym_case_selectors,
  [sym_case_body] = sym_case_body,
  [sym_loop_statement] = sym_loop_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_header] = sym_for_header,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_continuing_statement] = sym_continuing_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_func_call_statement] = sym_func_call_statement,
  [sym_statements] = sym_statements,
  [sym_statement] = sym_statement,
  [sym_function_decl] = sym_function_decl,
  [sym_function_header] = sym_function_header,
  [sym_function_return_type_decl_optional] = sym_function_return_type_decl_optional,
  [sym_param_list] = sym_param_list,
  [sym_param] = sym_param,
  [sym_enable_directive] = sym_enable_directive,
  [sym__comment] = sym__comment,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_attribute_list_repeat1] = aux_sym_attribute_list_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_array_type_decl_repeat1] = aux_sym_array_type_decl_repeat1,
  [aux_sym_struct_body_decl_repeat1] = aux_sym_struct_body_decl_repeat1,
  [aux_sym_const_expression_repeat1] = aux_sym_const_expression_repeat1,
  [aux_sym_argument_expression_list_repeat1] = aux_sym_argument_expression_list_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym_case_selectors_repeat1] = aux_sym_case_selectors_repeat1,
  [aux_sym_statements_repeat1] = aux_sym_statements_repeat1,
  [aux_sym_param_list_repeat1] = aux_sym_param_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_uint_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_float32] = {
    .visible = true,
    .named = true,
  },
  [sym_int32] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat2x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat3x4] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x2] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x3] = {
    .visible = true,
    .named = true,
  },
  [sym_mat4x4] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_comparison] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_1d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_storage_3d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_2d_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_cube_array] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_depth_multisampled_2d] = {
    .visible = true,
    .named = true,
  },
  [sym_uint32] = {
    .visible = true,
    .named = true,
  },
  [sym_vec2] = {
    .visible = true,
    .named = true,
  },
  [sym_vec3] = {
    .visible = true,
    .named = true,
  },
  [sym_vec4] = {
    .visible = true,
    .named = true,
  },
  [sym_bitcast] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing] = {
    .visible = true,
    .named = true,
  },
  [sym_default] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if] = {
    .visible = true,
    .named = true,
  },
  [sym_enable] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_fn] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_private] = {
    .visible = true,
    .named = true,
  },
  [sym_read] = {
    .visible = true,
    .named = true,
  },
  [sym_read_write] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_storage] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_uniform] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [sym_workgroup] = {
    .visible = true,
    .named = true,
  },
  [sym_write] = {
    .visible = true,
    .named = true,
  },
  [sym_r8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_r8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_r8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_r32float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8unorm_srgb] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8snorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba8sint] = {
    .visible = true,
    .named = true,
  },
  [sym_bgra8unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_bgra8unorm_srgb] = {
    .visible = true,
    .named = true,
  },
  [sym_rgb10a2unorm] = {
    .visible = true,
    .named = true,
  },
  [sym_rg11b10float] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rg32float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba16float] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32uint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32sint] = {
    .visible = true,
    .named = true,
  },
  [sym_rgba32float] = {
    .visible = true,
    .named = true,
  },
  [sym_and] = {
    .visible = true,
    .named = true,
  },
  [sym_and_and] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_attr_left] = {
    .visible = true,
    .named = true,
  },
  [sym_attr_right] = {
    .visible = true,
    .named = true,
  },
  [sym_forward_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_bang] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_left] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_right] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_left] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_right] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_equal_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left] = {
    .visible = true,
    .named = true,
  },
  [sym_modulo] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_period] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_or] = {
    .visible = true,
    .named = true,
  },
  [sym_or_or] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_left] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_right] = {
    .visible = true,
    .named = true,
  },
  [sym_semicolon] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_tilde] = {
    .visible = true,
    .named = true,
  },
  [sym_xor] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__reserved_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token9] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token10] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token11] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token12] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token13] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token14] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token15] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token16] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token17] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token18] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token19] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token20] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token21] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token22] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__reserved_token23] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comment_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__space] = {
    .visible = false,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_const_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_or_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_element_count_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_access_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_class] = {
    .visible = true,
    .named = true,
  },
  [sym_texture_sampler_types] = {
    .visible = true,
    .named = true,
  },
  [sym_sampler_type] = {
    .visible = true,
    .named = true,
  },
  [sym_sampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_multisampled_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_storage_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_depth_texture_type] = {
    .visible = true,
    .named = true,
  },
  [sym_texel_format] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_type_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ident_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_qualifier] = {
    .visible = true,
    .named = true,
  },
  [sym_global_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_constant_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_const_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_const_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_singular_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_exclusive_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inclusive_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_short_circuit_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_case_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_case_body] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_header] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_func_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statements] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_function_return_type_decl_optional] = {
    .visible = true,
    .named = true,
  },
  [sym_param_list] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_enable_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_param_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(26);
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '%') ADVANCE(69);
      if (lookahead == '&') ADVANCE(42);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(83);
      if (lookahead == '+') ADVANCE(76);
      if (lookahead == ',') ADVANCE(55);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == '0') ADVANCE(30);
      if (lookahead == ':') ADVANCE(54);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(62);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == ']') ADVANCE(51);
      if (lookahead == '^') ADVANCE(85);
      if (lookahead == '{') ADVANCE(52);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '}') ADVANCE(53);
      if (lookahead == '~') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(31);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '%') ADVANCE(69);
      if (lookahead == '&') ADVANCE(42);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(83);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(55);
      if (lookahead == '-') ADVANCE(70);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == ':') ADVANCE(54);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(57);
      if (lookahead == '>') ADVANCE(62);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == ']') ADVANCE(51);
      if (lookahead == '^') ADVANCE(85);
      if (lookahead == '{') ADVANCE(52);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '%') ADVANCE(69);
      if (lookahead == '&') ADVANCE(42);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(83);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(55);
      if (lookahead == '-') ADVANCE(70);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(12);
      if (lookahead == '>') ADVANCE(62);
      if (lookahead == ']') ADVANCE(51);
      if (lookahead == '^') ADVANCE(85);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(11);
      if (lookahead == '&') ADVANCE(42);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == ',') ADVANCE(55);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '0') ADVANCE(35);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '<') ADVANCE(66);
      if (lookahead == '=') ADVANCE(12);
      if (lookahead == '>') ADVANCE(61);
      if (lookahead == ']') ADVANCE(51);
      if (lookahead == '^') ADVANCE(85);
      if (lookahead == '{') ADVANCE(52);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(36);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 4:
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '[') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(8);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 8:
      if (lookahead == '.') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(87);
      END_STATE();
    case 10:
      if (lookahead == '0') ADVANCE(15);
      if (lookahead == '>') ADVANCE(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(58);
      END_STATE();
    case 13:
      if (lookahead == '[') ADVANCE(45);
      END_STATE();
    case 14:
      if (lookahead == ']') ADVANCE(46);
      END_STATE();
    case 15:
      if (lookahead == 'x') ADVANCE(24);
      END_STATE();
    case 16:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 17:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 18:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 25:
      if (eof) ADVANCE(26);
      if (lookahead == '!') ADVANCE(48);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(80);
      if (lookahead == ')') ADVANCE(81);
      if (lookahead == '*') ADVANCE(83);
      if (lookahead == ',') ADVANCE(55);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '0') ADVANCE(30);
      if (lookahead == ':') ADVANCE(54);
      if (lookahead == ';') ADVANCE(82);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(60);
      if (lookahead == '[') ADVANCE(13);
      if (lookahead == ']') ADVANCE(14);
      if (lookahead == '{') ADVANCE(52);
      if (lookahead == '}') ADVANCE(53);
      if (lookahead == '~') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(92);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(31);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_decimal_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_hex_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(40);
      if (lookahead == 'x') ADVANCE(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(6);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(40);
      if (lookahead == 'x') ADVANCE(23);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'u') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_uint_literal);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_and);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_and);
      if (lookahead == '&') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_and_and);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_arrow);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_attr_left);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_attr_right);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_forward_slash);
      if (lookahead == '/') ADVANCE(87);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_bang);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_bang);
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_bracket_left);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_bracket_right);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_brace_left);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_brace_right);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_colon);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_equal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_equal);
      if (lookahead == '=') ADVANCE(58);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_equal_equal);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_not_equal);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_greater_than);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(63);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(63);
      if (lookahead == '>') ADVANCE(64);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_greater_than_equal);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_shift_right);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '<') ADVANCE(68);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_less_than_equal);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_shift_left);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_modulo);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_minus);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '0') ADVANCE(5);
      if (lookahead == '>') ADVANCE(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_minus);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '0') ADVANCE(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(32);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_period);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_period);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(27);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_plus_plus);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_or);
      if (lookahead == '|') ADVANCE(79);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_or_or);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_paren_left);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_paren_right);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_semicolon);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_star);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_tilde);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_xor);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym__comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(91);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead == '\n') ADVANCE(92);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0) ADVANCE(91);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(91);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__comment_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym__space);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'g') ADVANCE(22);
      if (lookahead == 'i') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == '1') ADVANCE(34);
      if (lookahead == '3') ADVANCE(35);
      if (lookahead == '6') ADVANCE(36);
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(42);
      if (lookahead == '3') ADVANCE(43);
      if (lookahead == '6') ADVANCE(44);
      if (lookahead == '8') ADVANCE(45);
      if (lookahead == 'f') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(50);
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == '1') ADVANCE(52);
      if (lookahead == '3') ADVANCE(53);
      if (lookahead == '8') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'g') ADVANCE(56);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(57);
      if (lookahead == 't') ADVANCE(58);
      if (lookahead == 'w') ADVANCE(59);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(61);
      if (lookahead == 'y') ADVANCE(62);
      END_STATE();
    case 15:
      if (lookahead == '1') ADVANCE(63);
      if (lookahead == '3') ADVANCE(64);
      if (lookahead == '6') ADVANCE(65);
      if (lookahead == '8') ADVANCE(66);
      if (lookahead == 'n') ADVANCE(67);
      if (lookahead == 's') ADVANCE(68);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(69);
      if (lookahead == 'e') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(71);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 18:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 19:
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 20:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 21:
      if (lookahead == '1') ADVANCE(78);
      END_STATE();
    case 22:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(86);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym__reserved_token4);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(89);
      if (lookahead == 'u') ADVANCE(90);
      END_STATE();
    case 34:
      if (lookahead == '6') ADVANCE(91);
      END_STATE();
    case 35:
      if (lookahead == '2') ADVANCE(92);
      END_STATE();
    case 36:
      if (lookahead == '4') ADVANCE(93);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_fn);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 42:
      if (lookahead == '6') ADVANCE(98);
      END_STATE();
    case 43:
      if (lookahead == '2') ADVANCE(99);
      END_STATE();
    case 44:
      if (lookahead == '4') ADVANCE(100);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__reserved_token9);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_if);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 52:
      if (lookahead == '6') ADVANCE(107);
      END_STATE();
    case 53:
      if (lookahead == '2') ADVANCE(108);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(111);
      if (lookahead == 'g') ADVANCE(112);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 56:
      if (lookahead == '1') ADVANCE(114);
      if (lookahead == '3') ADVANCE(115);
      if (lookahead == '8') ADVANCE(116);
      if (lookahead == 'b') ADVANCE(117);
      END_STATE();
    case 57:
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(119);
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(121);
      END_STATE();
    case 60:
      if (lookahead == 'x') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(124);
      END_STATE();
    case 63:
      if (lookahead == '6') ADVANCE(125);
      END_STATE();
    case 64:
      if (lookahead == '2') ADVANCE(126);
      END_STATE();
    case 65:
      if (lookahead == '4') ADVANCE(127);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym__reserved_token16);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(128);
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__reserved_token1);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(138);
      END_STATE();
    case 78:
      if (lookahead == '6') ADVANCE(139);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(146);
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(148);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(149);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 89:
      if (lookahead == 'b') ADVANCE(151);
      END_STATE();
    case 90:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__reserved_token6);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_float32);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__reserved_token7);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(153);
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_for);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(155);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(156);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__reserved_token10);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_int32);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__reserved_token11);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_let);
      END_STATE();
    case 102:
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym__reserved_token12);
      if (lookahead == '2') ADVANCE(158);
      if (lookahead == '3') ADVANCE(159);
      if (lookahead == '4') ADVANCE(160);
      END_STATE();
    case 104:
      if (lookahead == 'm') ADVANCE(161);
      END_STATE();
    case 105:
      if (lookahead == 'v') ADVANCE(162);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_pointer);
      END_STATE();
    case 107:
      if (lookahead == 'f') ADVANCE(163);
      if (lookahead == 's') ADVANCE(164);
      if (lookahead == 'u') ADVANCE(165);
      END_STATE();
    case 108:
      if (lookahead == 'f') ADVANCE(166);
      if (lookahead == 's') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(171);
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 111:
      if (lookahead == 'd') ADVANCE(173);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(175);
      END_STATE();
    case 114:
      if (lookahead == '1') ADVANCE(176);
      if (lookahead == '6') ADVANCE(177);
      END_STATE();
    case 115:
      if (lookahead == '2') ADVANCE(178);
      END_STATE();
    case 116:
      if (lookahead == 's') ADVANCE(179);
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 117:
      if (lookahead == '1') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 118:
      if (lookahead == 'p') ADVANCE(183);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(185);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__reserved_token17);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_uint32);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__reserved_token18);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(190);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(192);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_var);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__reserved_token21);
      if (lookahead == '2') ADVANCE(193);
      if (lookahead == '3') ADVANCE(194);
      if (lookahead == '4') ADVANCE(195);
      END_STATE();
    case 133:
      if (lookahead == 'd') ADVANCE(196);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 135:
      if (lookahead == 'k') ADVANCE(198);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 137:
      if (lookahead == 'y') ADVANCE(200);
      END_STATE();
    case 138:
      if (lookahead == 'i') ADVANCE(201);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym__reserved_token2);
      END_STATE();
    case 140:
      if (lookahead == '8') ADVANCE(202);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(203);
      END_STATE();
    case 142:
      if (lookahead == 'k') ADVANCE(204);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_bool);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(205);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_case);
      END_STATE();
    case 146:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 148:
      if (lookahead == 'u') ADVANCE(208);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__reserved_token5);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 156:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_loop);
      END_STATE();
    case 158:
      if (lookahead == 'x') ADVANCE(216);
      END_STATE();
    case 159:
      if (lookahead == 'x') ADVANCE(217);
      END_STATE();
    case 160:
      if (lookahead == 'x') ADVANCE(218);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(220);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(221);
      END_STATE();
    case 164:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(223);
      END_STATE();
    case 166:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 168:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 169:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(228);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(229);
      END_STATE();
    case 172:
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_read);
      if (lookahead == '_') ADVANCE(231);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 176:
      if (lookahead == 'b') ADVANCE(234);
      END_STATE();
    case 177:
      if (lookahead == 'f') ADVANCE(235);
      if (lookahead == 's') ADVANCE(236);
      if (lookahead == 'u') ADVANCE(237);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(238);
      if (lookahead == 's') ADVANCE(239);
      if (lookahead == 'u') ADVANCE(240);
      END_STATE();
    case 179:
      if (lookahead == 'i') ADVANCE(241);
      if (lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(244);
      END_STATE();
    case 181:
      if (lookahead == '0') ADVANCE(245);
      END_STATE();
    case 182:
      if (lookahead == '1') ADVANCE(246);
      if (lookahead == '3') ADVANCE(247);
      if (lookahead == '8') ADVANCE(248);
      END_STATE();
    case 183:
      if (lookahead == 'l') ADVANCE(249);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(251);
      END_STATE();
    case 186:
      if (lookahead == 'c') ADVANCE(252);
      END_STATE();
    case 187:
      if (lookahead == 'u') ADVANCE(253);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_type);
      if (lookahead == 'd') ADVANCE(254);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 192:
      if (lookahead == 'g') ADVANCE(257);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_vec2);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_vec3);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_vec4);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__reserved_token22);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 198:
      if (lookahead == 'g') ADVANCE(259);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_array);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(261);
      END_STATE();
    case 202:
      if (lookahead == 'u') ADVANCE(262);
      END_STATE();
    case 203:
      if (lookahead == 's') ADVANCE(263);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_block);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym__reserved_token3);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(264);
      END_STATE();
    case 208:
      if (lookahead == 'l') ADVANCE(265);
      END_STATE();
    case 209:
      if (lookahead == 'r') ADVANCE(266);
      END_STATE();
    case 210:
      if (lookahead == 'f') ADVANCE(267);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 212:
      if (lookahead == 'h') ADVANCE(269);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 214:
      if (lookahead == 'i') ADVANCE(270);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 216:
      if (lookahead == '2') ADVANCE(272);
      if (lookahead == '3') ADVANCE(273);
      if (lookahead == '4') ADVANCE(274);
      END_STATE();
    case 217:
      if (lookahead == '2') ADVANCE(275);
      if (lookahead == '3') ADVANCE(276);
      if (lookahead == '4') ADVANCE(277);
      END_STATE();
    case 218:
      if (lookahead == '2') ADVANCE(278);
      if (lookahead == '3') ADVANCE(279);
      if (lookahead == '4') ADVANCE(280);
      END_STATE();
    case 219:
      if (lookahead == 'r') ADVANCE(281);
      END_STATE();
    case 220:
      if (lookahead == 't') ADVANCE(282);
      END_STATE();
    case 221:
      if (lookahead == 'o') ADVANCE(283);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(284);
      END_STATE();
    case 223:
      if (lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 224:
      if (lookahead == 'o') ADVANCE(286);
      END_STATE();
    case 225:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(288);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 228:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 229:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 230:
      if (lookahead == 'r') ADVANCE(292);
      END_STATE();
    case 231:
      if (lookahead == 'w') ADVANCE(293);
      END_STATE();
    case 232:
      if (lookahead == 'd') ADVANCE(294);
      END_STATE();
    case 233:
      if (lookahead == 'n') ADVANCE(295);
      END_STATE();
    case 234:
      if (lookahead == '1') ADVANCE(296);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(297);
      END_STATE();
    case 236:
      if (lookahead == 'i') ADVANCE(298);
      END_STATE();
    case 237:
      if (lookahead == 'i') ADVANCE(299);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(300);
      END_STATE();
    case 239:
      if (lookahead == 'i') ADVANCE(301);
      END_STATE();
    case 240:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 241:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 242:
      if (lookahead == 'o') ADVANCE(304);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(305);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(307);
      END_STATE();
    case 246:
      if (lookahead == '6') ADVANCE(308);
      END_STATE();
    case 247:
      if (lookahead == '2') ADVANCE(309);
      END_STATE();
    case 248:
      if (lookahead == 's') ADVANCE(310);
      if (lookahead == 'u') ADVANCE(311);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(312);
      END_STATE();
    case 250:
      if (lookahead == 'g') ADVANCE(313);
      END_STATE();
    case 251:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 252:
      if (lookahead == 'h') ADVANCE(315);
      END_STATE();
    case 253:
      if (lookahead == 'r') ADVANCE(316);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(317);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(318);
      END_STATE();
    case 256:
      if (lookahead == 's') ADVANCE(319);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(aux_sym__reserved_token20);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym__reserved_token23);
      END_STATE();
    case 259:
      if (lookahead == 'r') ADVANCE(320);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_write);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_atomic);
      END_STATE();
    case 262:
      if (lookahead == 'n') ADVANCE(321);
      END_STATE();
    case 263:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 264:
      if (lookahead == 'u') ADVANCE(323);
      END_STATE();
    case 265:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 266:
      if (lookahead == 'd') ADVANCE(325);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_else_if);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_enable);
      END_STATE();
    case 269:
      if (lookahead == 'r') ADVANCE(326);
      END_STATE();
    case 270:
      if (lookahead == 'o') ADVANCE(327);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(aux_sym__reserved_token8);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_mat2x2);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_mat2x3);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_mat2x4);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_mat3x2);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_mat3x3);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_mat3x4);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_mat4x2);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_mat4x3);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_mat4x4);
      END_STATE();
    case 281:
      if (lookahead == 'g') ADVANCE(328);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(330);
      END_STATE();
    case 284:
      if (lookahead == 't') ADVANCE(331);
      END_STATE();
    case 285:
      if (lookahead == 't') ADVANCE(332);
      END_STATE();
    case 286:
      if (lookahead == 'a') ADVANCE(333);
      END_STATE();
    case 287:
      if (lookahead == 't') ADVANCE(334);
      END_STATE();
    case 288:
      if (lookahead == 't') ADVANCE(335);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_r8sint);
      END_STATE();
    case 290:
      if (lookahead == 'm') ADVANCE(336);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_r8uint);
      END_STATE();
    case 292:
      if (lookahead == 'm') ADVANCE(337);
      END_STATE();
    case 293:
      if (lookahead == 'r') ADVANCE(338);
      END_STATE();
    case 294:
      if (lookahead == 'l') ADVANCE(339);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 296:
      if (lookahead == '0') ADVANCE(340);
      END_STATE();
    case 297:
      if (lookahead == 'o') ADVANCE(341);
      END_STATE();
    case 298:
      if (lookahead == 'n') ADVANCE(342);
      END_STATE();
    case 299:
      if (lookahead == 'n') ADVANCE(343);
      END_STATE();
    case 300:
      if (lookahead == 'o') ADVANCE(344);
      END_STATE();
    case 301:
      if (lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 304:
      if (lookahead == 'r') ADVANCE(348);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(349);
      END_STATE();
    case 306:
      if (lookahead == 'r') ADVANCE(350);
      END_STATE();
    case 307:
      if (lookahead == '2') ADVANCE(351);
      END_STATE();
    case 308:
      if (lookahead == 'f') ADVANCE(352);
      if (lookahead == 's') ADVANCE(353);
      if (lookahead == 'u') ADVANCE(354);
      END_STATE();
    case 309:
      if (lookahead == 'f') ADVANCE(355);
      if (lookahead == 's') ADVANCE(356);
      if (lookahead == 'u') ADVANCE(357);
      END_STATE();
    case 310:
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == 'n') ADVANCE(359);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(360);
      if (lookahead == 'n') ADVANCE(361);
      END_STATE();
    case 312:
      if (lookahead == 'r') ADVANCE(362);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(363);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_struct);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_switch);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(364);
      END_STATE();
    case 317:
      if (lookahead == 'f') ADVANCE(365);
      END_STATE();
    case 318:
      if (lookahead == 'm') ADVANCE(366);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym__reserved_token19);
      END_STATE();
    case 320:
      if (lookahead == 'o') ADVANCE(367);
      END_STATE();
    case 321:
      if (lookahead == 'o') ADVANCE(368);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_bitcast);
      END_STATE();
    case 323:
      if (lookahead == 'e') ADVANCE(369);
      if (lookahead == 'i') ADVANCE(370);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_default);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_discard);
      END_STATE();
    case 326:
      if (lookahead == 'o') ADVANCE(371);
      END_STATE();
    case 327:
      if (lookahead == 'n') ADVANCE(372);
      END_STATE();
    case 328:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_private);
      END_STATE();
    case 330:
      if (lookahead == 't') ADVANCE(374);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_r16sint);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_r16uint);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(375);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_r32sint);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_r32uint);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_r8snorm);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_r8unorm);
      END_STATE();
    case 338:
      if (lookahead == 'i') ADVANCE(376);
      END_STATE();
    case 339:
      if (lookahead == 'e') ADVANCE(377);
      END_STATE();
    case 340:
      if (lookahead == 'f') ADVANCE(378);
      END_STATE();
    case 341:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 342:
      if (lookahead == 't') ADVANCE(380);
      END_STATE();
    case 343:
      if (lookahead == 't') ADVANCE(381);
      END_STATE();
    case 344:
      if (lookahead == 'a') ADVANCE(382);
      END_STATE();
    case 345:
      if (lookahead == 't') ADVANCE(383);
      END_STATE();
    case 346:
      if (lookahead == 't') ADVANCE(384);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_rg8sint);
      END_STATE();
    case 348:
      if (lookahead == 'm') ADVANCE(385);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_rg8uint);
      END_STATE();
    case 350:
      if (lookahead == 'm') ADVANCE(386);
      END_STATE();
    case 351:
      if (lookahead == 'u') ADVANCE(387);
      END_STATE();
    case 352:
      if (lookahead == 'l') ADVANCE(388);
      END_STATE();
    case 353:
      if (lookahead == 'i') ADVANCE(389);
      END_STATE();
    case 354:
      if (lookahead == 'i') ADVANCE(390);
      END_STATE();
    case 355:
      if (lookahead == 'l') ADVANCE(391);
      END_STATE();
    case 356:
      if (lookahead == 'i') ADVANCE(392);
      END_STATE();
    case 357:
      if (lookahead == 'i') ADVANCE(393);
      END_STATE();
    case 358:
      if (lookahead == 'n') ADVANCE(394);
      END_STATE();
    case 359:
      if (lookahead == 'o') ADVANCE(395);
      END_STATE();
    case 360:
      if (lookahead == 'n') ADVANCE(396);
      END_STATE();
    case 361:
      if (lookahead == 'o') ADVANCE(397);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_sampler);
      if (lookahead == '_') ADVANCE(398);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_storage);
      END_STATE();
    case 364:
      if (lookahead == '_') ADVANCE(399);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(aux_sym__reserved_token15);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_uniform);
      END_STATE();
    case 367:
      if (lookahead == 'u') ADVANCE(400);
      END_STATE();
    case 368:
      if (lookahead == 'r') ADVANCE(401);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 370:
      if (lookahead == 'n') ADVANCE(402);
      END_STATE();
    case 371:
      if (lookahead == 'u') ADVANCE(403);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_function);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(aux_sym__reserved_token13);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_r16float);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_r32float);
      END_STATE();
    case 376:
      if (lookahead == 't') ADVANCE(404);
      END_STATE();
    case 377:
      if (lookahead == 's') ADVANCE(405);
      END_STATE();
    case 378:
      if (lookahead == 'l') ADVANCE(406);
      END_STATE();
    case 379:
      if (lookahead == 't') ADVANCE(407);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_rg16sint);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_rg16uint);
      END_STATE();
    case 382:
      if (lookahead == 't') ADVANCE(408);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_rg32sint);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_rg32uint);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_rg8snorm);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_rg8unorm);
      END_STATE();
    case 387:
      if (lookahead == 'n') ADVANCE(409);
      END_STATE();
    case 388:
      if (lookahead == 'o') ADVANCE(410);
      END_STATE();
    case 389:
      if (lookahead == 'n') ADVANCE(411);
      END_STATE();
    case 390:
      if (lookahead == 'n') ADVANCE(412);
      END_STATE();
    case 391:
      if (lookahead == 'o') ADVANCE(413);
      END_STATE();
    case 392:
      if (lookahead == 'n') ADVANCE(414);
      END_STATE();
    case 393:
      if (lookahead == 'n') ADVANCE(415);
      END_STATE();
    case 394:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 395:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(418);
      END_STATE();
    case 397:
      if (lookahead == 'r') ADVANCE(419);
      END_STATE();
    case 398:
      if (lookahead == 'c') ADVANCE(420);
      END_STATE();
    case 399:
      if (lookahead == '1') ADVANCE(421);
      if (lookahead == '2') ADVANCE(422);
      if (lookahead == '3') ADVANCE(423);
      if (lookahead == 'c') ADVANCE(424);
      if (lookahead == 'd') ADVANCE(425);
      if (lookahead == 'm') ADVANCE(426);
      if (lookahead == 's') ADVANCE(427);
      END_STATE();
    case 400:
      if (lookahead == 'p') ADVANCE(428);
      END_STATE();
    case 401:
      if (lookahead == 'm') ADVANCE(429);
      END_STATE();
    case 402:
      if (lookahead == 'g') ADVANCE(430);
      END_STATE();
    case 403:
      if (lookahead == 'g') ADVANCE(431);
      END_STATE();
    case 404:
      if (lookahead == 'e') ADVANCE(432);
      END_STATE();
    case 405:
      if (lookahead == 's') ADVANCE(433);
      END_STATE();
    case 406:
      if (lookahead == 'o') ADVANCE(434);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_rg16float);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_rg32float);
      END_STATE();
    case 409:
      if (lookahead == 'o') ADVANCE(435);
      END_STATE();
    case 410:
      if (lookahead == 'a') ADVANCE(436);
      END_STATE();
    case 411:
      if (lookahead == 't') ADVANCE(437);
      END_STATE();
    case 412:
      if (lookahead == 't') ADVANCE(438);
      END_STATE();
    case 413:
      if (lookahead == 'a') ADVANCE(439);
      END_STATE();
    case 414:
      if (lookahead == 't') ADVANCE(440);
      END_STATE();
    case 415:
      if (lookahead == 't') ADVANCE(441);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_rgba8sint);
      END_STATE();
    case 417:
      if (lookahead == 'm') ADVANCE(442);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_rgba8uint);
      END_STATE();
    case 419:
      if (lookahead == 'm') ADVANCE(443);
      END_STATE();
    case 420:
      if (lookahead == 'o') ADVANCE(444);
      END_STATE();
    case 421:
      if (lookahead == 'd') ADVANCE(445);
      END_STATE();
    case 422:
      if (lookahead == 'd') ADVANCE(446);
      END_STATE();
    case 423:
      if (lookahead == 'd') ADVANCE(447);
      END_STATE();
    case 424:
      if (lookahead == 'u') ADVANCE(448);
      END_STATE();
    case 425:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 426:
      if (lookahead == 'u') ADVANCE(450);
      END_STATE();
    case 427:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_workgroup);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_bgra8unorm);
      if (lookahead == '_') ADVANCE(452);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_continuing);
      END_STATE();
    case 431:
      if (lookahead == 'h') ADVANCE(453);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_read_write);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym__reserved_token14);
      END_STATE();
    case 434:
      if (lookahead == 'a') ADVANCE(454);
      END_STATE();
    case 435:
      if (lookahead == 'r') ADVANCE(455);
      END_STATE();
    case 436:
      if (lookahead == 't') ADVANCE(456);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_rgba16sint);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_rgba16uint);
      END_STATE();
    case 439:
      if (lookahead == 't') ADVANCE(457);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_rgba32sint);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_rgba32uint);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_rgba8snorm);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_rgba8unorm);
      if (lookahead == '_') ADVANCE(458);
      END_STATE();
    case 444:
      if (lookahead == 'm') ADVANCE(459);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_texture_1d);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_texture_2d);
      if (lookahead == '_') ADVANCE(460);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_texture_3d);
      END_STATE();
    case 448:
      if (lookahead == 'b') ADVANCE(461);
      END_STATE();
    case 449:
      if (lookahead == 'p') ADVANCE(462);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(463);
      END_STATE();
    case 451:
      if (lookahead == 'o') ADVANCE(464);
      END_STATE();
    case 452:
      if (lookahead == 's') ADVANCE(465);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_fallthrough);
      END_STATE();
    case 454:
      if (lookahead == 't') ADVANCE(466);
      END_STATE();
    case 455:
      if (lookahead == 'm') ADVANCE(467);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_rgba16float);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_rgba32float);
      END_STATE();
    case 458:
      if (lookahead == 's') ADVANCE(468);
      END_STATE();
    case 459:
      if (lookahead == 'p') ADVANCE(469);
      END_STATE();
    case 460:
      if (lookahead == 'a') ADVANCE(470);
      END_STATE();
    case 461:
      if (lookahead == 'e') ADVANCE(471);
      END_STATE();
    case 462:
      if (lookahead == 't') ADVANCE(472);
      END_STATE();
    case 463:
      if (lookahead == 't') ADVANCE(473);
      END_STATE();
    case 464:
      if (lookahead == 'r') ADVANCE(474);
      END_STATE();
    case 465:
      if (lookahead == 'r') ADVANCE(475);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_rg11b10float);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_rgb10a2unorm);
      END_STATE();
    case 468:
      if (lookahead == 'r') ADVANCE(476);
      END_STATE();
    case 469:
      if (lookahead == 'a') ADVANCE(477);
      END_STATE();
    case 470:
      if (lookahead == 'r') ADVANCE(478);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_texture_cube);
      if (lookahead == '_') ADVANCE(479);
      END_STATE();
    case 472:
      if (lookahead == 'h') ADVANCE(480);
      END_STATE();
    case 473:
      if (lookahead == 'i') ADVANCE(481);
      END_STATE();
    case 474:
      if (lookahead == 'a') ADVANCE(482);
      END_STATE();
    case 475:
      if (lookahead == 'g') ADVANCE(483);
      END_STATE();
    case 476:
      if (lookahead == 'g') ADVANCE(484);
      END_STATE();
    case 477:
      if (lookahead == 'r') ADVANCE(485);
      END_STATE();
    case 478:
      if (lookahead == 'r') ADVANCE(486);
      END_STATE();
    case 479:
      if (lookahead == 'a') ADVANCE(487);
      END_STATE();
    case 480:
      if (lookahead == '_') ADVANCE(488);
      END_STATE();
    case 481:
      if (lookahead == 's') ADVANCE(489);
      END_STATE();
    case 482:
      if (lookahead == 'g') ADVANCE(490);
      END_STATE();
    case 483:
      if (lookahead == 'b') ADVANCE(491);
      END_STATE();
    case 484:
      if (lookahead == 'b') ADVANCE(492);
      END_STATE();
    case 485:
      if (lookahead == 'i') ADVANCE(493);
      END_STATE();
    case 486:
      if (lookahead == 'a') ADVANCE(494);
      END_STATE();
    case 487:
      if (lookahead == 'r') ADVANCE(495);
      END_STATE();
    case 488:
      if (lookahead == '2') ADVANCE(496);
      if (lookahead == 'c') ADVANCE(497);
      if (lookahead == 'm') ADVANCE(498);
      END_STATE();
    case 489:
      if (lookahead == 'a') ADVANCE(499);
      END_STATE();
    case 490:
      if (lookahead == 'e') ADVANCE(500);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_bgra8unorm_srgb);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_rgba8unorm_srgb);
      END_STATE();
    case 493:
      if (lookahead == 's') ADVANCE(501);
      END_STATE();
    case 494:
      if (lookahead == 'y') ADVANCE(502);
      END_STATE();
    case 495:
      if (lookahead == 'r') ADVANCE(503);
      END_STATE();
    case 496:
      if (lookahead == 'd') ADVANCE(504);
      END_STATE();
    case 497:
      if (lookahead == 'u') ADVANCE(505);
      END_STATE();
    case 498:
      if (lookahead == 'u') ADVANCE(506);
      END_STATE();
    case 499:
      if (lookahead == 'm') ADVANCE(507);
      END_STATE();
    case 500:
      if (lookahead == '_') ADVANCE(508);
      END_STATE();
    case 501:
      if (lookahead == 'o') ADVANCE(509);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_texture_2d_array);
      END_STATE();
    case 503:
      if (lookahead == 'a') ADVANCE(510);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_texture_depth_2d);
      if (lookahead == '_') ADVANCE(511);
      END_STATE();
    case 505:
      if (lookahead == 'b') ADVANCE(512);
      END_STATE();
    case 506:
      if (lookahead == 'l') ADVANCE(513);
      END_STATE();
    case 507:
      if (lookahead == 'p') ADVANCE(514);
      END_STATE();
    case 508:
      if (lookahead == '1') ADVANCE(515);
      if (lookahead == '2') ADVANCE(516);
      if (lookahead == '3') ADVANCE(517);
      END_STATE();
    case 509:
      if (lookahead == 'n') ADVANCE(518);
      END_STATE();
    case 510:
      if (lookahead == 'y') ADVANCE(519);
      END_STATE();
    case 511:
      if (lookahead == 'a') ADVANCE(520);
      END_STATE();
    case 512:
      if (lookahead == 'e') ADVANCE(521);
      END_STATE();
    case 513:
      if (lookahead == 't') ADVANCE(522);
      END_STATE();
    case 514:
      if (lookahead == 'l') ADVANCE(523);
      END_STATE();
    case 515:
      if (lookahead == 'd') ADVANCE(524);
      END_STATE();
    case 516:
      if (lookahead == 'd') ADVANCE(525);
      END_STATE();
    case 517:
      if (lookahead == 'd') ADVANCE(526);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_sampler_comparison);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_texture_cube_array);
      END_STATE();
    case 520:
      if (lookahead == 'r') ADVANCE(527);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_texture_depth_cube);
      if (lookahead == '_') ADVANCE(528);
      END_STATE();
    case 522:
      if (lookahead == 'i') ADVANCE(529);
      END_STATE();
    case 523:
      if (lookahead == 'e') ADVANCE(530);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_texture_storage_1d);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_texture_storage_2d);
      if (lookahead == '_') ADVANCE(531);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_texture_storage_3d);
      END_STATE();
    case 527:
      if (lookahead == 'r') ADVANCE(532);
      END_STATE();
    case 528:
      if (lookahead == 'a') ADVANCE(533);
      END_STATE();
    case 529:
      if (lookahead == 's') ADVANCE(534);
      END_STATE();
    case 530:
      if (lookahead == 'd') ADVANCE(535);
      END_STATE();
    case 531:
      if (lookahead == 'a') ADVANCE(536);
      END_STATE();
    case 532:
      if (lookahead == 'a') ADVANCE(537);
      END_STATE();
    case 533:
      if (lookahead == 'r') ADVANCE(538);
      END_STATE();
    case 534:
      if (lookahead == 'a') ADVANCE(539);
      END_STATE();
    case 535:
      if (lookahead == '_') ADVANCE(540);
      END_STATE();
    case 536:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 537:
      if (lookahead == 'y') ADVANCE(542);
      END_STATE();
    case 538:
      if (lookahead == 'r') ADVANCE(543);
      END_STATE();
    case 539:
      if (lookahead == 'm') ADVANCE(544);
      END_STATE();
    case 540:
      if (lookahead == '2') ADVANCE(545);
      END_STATE();
    case 541:
      if (lookahead == 'r') ADVANCE(546);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_texture_depth_2d_array);
      END_STATE();
    case 543:
      if (lookahead == 'a') ADVANCE(547);
      END_STATE();
    case 544:
      if (lookahead == 'p') ADVANCE(548);
      END_STATE();
    case 545:
      if (lookahead == 'd') ADVANCE(549);
      END_STATE();
    case 546:
      if (lookahead == 'a') ADVANCE(550);
      END_STATE();
    case 547:
      if (lookahead == 'y') ADVANCE(551);
      END_STATE();
    case 548:
      if (lookahead == 'l') ADVANCE(552);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_texture_multisampled_2d);
      END_STATE();
    case 550:
      if (lookahead == 'y') ADVANCE(553);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_texture_depth_cube_array);
      END_STATE();
    case 552:
      if (lookahead == 'e') ADVANCE(554);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_texture_storage_2d_array);
      END_STATE();
    case 554:
      if (lookahead == 'd') ADVANCE(555);
      END_STATE();
    case 555:
      if (lookahead == '_') ADVANCE(556);
      END_STATE();
    case 556:
      if (lookahead == '2') ADVANCE(557);
      END_STATE();
    case 557:
      if (lookahead == 'd') ADVANCE(558);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_texture_depth_multisampled_2d);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 25},
  [2] = {.lex_state = 25},
  [3] = {.lex_state = 25},
  [4] = {.lex_state = 25},
  [5] = {.lex_state = 25},
  [6] = {.lex_state = 25},
  [7] = {.lex_state = 25},
  [8] = {.lex_state = 25},
  [9] = {.lex_state = 25},
  [10] = {.lex_state = 25},
  [11] = {.lex_state = 25},
  [12] = {.lex_state = 25},
  [13] = {.lex_state = 25},
  [14] = {.lex_state = 25},
  [15] = {.lex_state = 25},
  [16] = {.lex_state = 25},
  [17] = {.lex_state = 25},
  [18] = {.lex_state = 25},
  [19] = {.lex_state = 25},
  [20] = {.lex_state = 25},
  [21] = {.lex_state = 25},
  [22] = {.lex_state = 25},
  [23] = {.lex_state = 25},
  [24] = {.lex_state = 25},
  [25] = {.lex_state = 25},
  [26] = {.lex_state = 25},
  [27] = {.lex_state = 25},
  [28] = {.lex_state = 25},
  [29] = {.lex_state = 25},
  [30] = {.lex_state = 25},
  [31] = {.lex_state = 25},
  [32] = {.lex_state = 25},
  [33] = {.lex_state = 25},
  [34] = {.lex_state = 25},
  [35] = {.lex_state = 25},
  [36] = {.lex_state = 25},
  [37] = {.lex_state = 25},
  [38] = {.lex_state = 25},
  [39] = {.lex_state = 25},
  [40] = {.lex_state = 25},
  [41] = {.lex_state = 25},
  [42] = {.lex_state = 25},
  [43] = {.lex_state = 25},
  [44] = {.lex_state = 25},
  [45] = {.lex_state = 25},
  [46] = {.lex_state = 25},
  [47] = {.lex_state = 25},
  [48] = {.lex_state = 25},
  [49] = {.lex_state = 25},
  [50] = {.lex_state = 25},
  [51] = {.lex_state = 25},
  [52] = {.lex_state = 25},
  [53] = {.lex_state = 25},
  [54] = {.lex_state = 25},
  [55] = {.lex_state = 25},
  [56] = {.lex_state = 25},
  [57] = {.lex_state = 25},
  [58] = {.lex_state = 25},
  [59] = {.lex_state = 25},
  [60] = {.lex_state = 25},
  [61] = {.lex_state = 25},
  [62] = {.lex_state = 25},
  [63] = {.lex_state = 25},
  [64] = {.lex_state = 25},
  [65] = {.lex_state = 25},
  [66] = {.lex_state = 25},
  [67] = {.lex_state = 25},
  [68] = {.lex_state = 25},
  [69] = {.lex_state = 25},
  [70] = {.lex_state = 25},
  [71] = {.lex_state = 25},
  [72] = {.lex_state = 25},
  [73] = {.lex_state = 25},
  [74] = {.lex_state = 25},
  [75] = {.lex_state = 25},
  [76] = {.lex_state = 25},
  [77] = {.lex_state = 25},
  [78] = {.lex_state = 25},
  [79] = {.lex_state = 25},
  [80] = {.lex_state = 25},
  [81] = {.lex_state = 25},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 25},
  [107] = {.lex_state = 25},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 25},
  [115] = {.lex_state = 25},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 25},
  [118] = {.lex_state = 25},
  [119] = {.lex_state = 25},
  [120] = {.lex_state = 25},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 25},
  [124] = {.lex_state = 25},
  [125] = {.lex_state = 25},
  [126] = {.lex_state = 25},
  [127] = {.lex_state = 25},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 25},
  [130] = {.lex_state = 25},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 25},
  [133] = {.lex_state = 25},
  [134] = {.lex_state = 25},
  [135] = {.lex_state = 25},
  [136] = {.lex_state = 25},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 25},
  [139] = {.lex_state = 25},
  [140] = {.lex_state = 25},
  [141] = {.lex_state = 25},
  [142] = {.lex_state = 25},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 25},
  [145] = {.lex_state = 25},
  [146] = {.lex_state = 25},
  [147] = {.lex_state = 25},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 25},
  [150] = {.lex_state = 25},
  [151] = {.lex_state = 25},
  [152] = {.lex_state = 25},
  [153] = {.lex_state = 25},
  [154] = {.lex_state = 25},
  [155] = {.lex_state = 25},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 25},
  [161] = {.lex_state = 4},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 25},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 4},
  [166] = {.lex_state = 25},
  [167] = {.lex_state = 25},
  [168] = {.lex_state = 25},
  [169] = {.lex_state = 25},
  [170] = {.lex_state = 25},
  [171] = {.lex_state = 25},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 25},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 25},
  [182] = {.lex_state = 25},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 25},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 25},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 25},
  [197] = {.lex_state = 25},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 25},
  [200] = {.lex_state = 25},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 25},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 3},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 25},
  [212] = {.lex_state = 25},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 25},
  [223] = {.lex_state = 25},
  [224] = {.lex_state = 25},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 25},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 25},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 25},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 25},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 25},
  [244] = {.lex_state = 25},
  [245] = {.lex_state = 25},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 25},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 25},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 0},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 0},
  [257] = {.lex_state = 0},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 25},
  [260] = {.lex_state = 25},
  [261] = {.lex_state = 0},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 25},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 25},
  [268] = {.lex_state = 25},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 0},
  [271] = {.lex_state = 25},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 25},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 25},
  [286] = {.lex_state = 25},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 25},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 25},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 25},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 89},
  [317] = {.lex_state = 25},
  [318] = {.lex_state = 25},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 25},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 25},
  [331] = {.lex_state = 25},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym__comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym_decimal_float_literal] = ACTIONS(1),
    [sym_hex_float_literal] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_uint_literal] = ACTIONS(1),
    [sym_array] = ACTIONS(1),
    [sym_atomic] = ACTIONS(1),
    [sym_bool] = ACTIONS(1),
    [sym_float32] = ACTIONS(1),
    [sym_int32] = ACTIONS(1),
    [sym_mat2x2] = ACTIONS(1),
    [sym_mat2x3] = ACTIONS(1),
    [sym_mat2x4] = ACTIONS(1),
    [sym_mat3x2] = ACTIONS(1),
    [sym_mat3x3] = ACTIONS(1),
    [sym_mat3x4] = ACTIONS(1),
    [sym_mat4x2] = ACTIONS(1),
    [sym_mat4x3] = ACTIONS(1),
    [sym_mat4x4] = ACTIONS(1),
    [sym_pointer] = ACTIONS(1),
    [sym_sampler] = ACTIONS(1),
    [sym_sampler_comparison] = ACTIONS(1),
    [sym_struct] = ACTIONS(1),
    [sym_texture_1d] = ACTIONS(1),
    [sym_texture_2d] = ACTIONS(1),
    [sym_texture_2d_array] = ACTIONS(1),
    [sym_texture_3d] = ACTIONS(1),
    [sym_texture_cube] = ACTIONS(1),
    [sym_texture_cube_array] = ACTIONS(1),
    [sym_texture_multisampled_2d] = ACTIONS(1),
    [sym_texture_storage_1d] = ACTIONS(1),
    [sym_texture_storage_2d] = ACTIONS(1),
    [sym_texture_storage_2d_array] = ACTIONS(1),
    [sym_texture_storage_3d] = ACTIONS(1),
    [sym_texture_depth_2d] = ACTIONS(1),
    [sym_texture_depth_2d_array] = ACTIONS(1),
    [sym_texture_depth_cube] = ACTIONS(1),
    [sym_texture_depth_cube_array] = ACTIONS(1),
    [sym_texture_depth_multisampled_2d] = ACTIONS(1),
    [sym_uint32] = ACTIONS(1),
    [sym_vec2] = ACTIONS(1),
    [sym_vec3] = ACTIONS(1),
    [sym_vec4] = ACTIONS(1),
    [sym_bitcast] = ACTIONS(1),
    [sym_block] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_case] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [sym_continuing] = ACTIONS(1),
    [sym_default] = ACTIONS(1),
    [sym_discard] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_else_if] = ACTIONS(1),
    [sym_enable] = ACTIONS(1),
    [sym_fallthrough] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_fn] = ACTIONS(1),
    [sym_for] = ACTIONS(1),
    [sym_function] = ACTIONS(1),
    [sym_if] = ACTIONS(1),
    [sym_let] = ACTIONS(1),
    [sym_loop] = ACTIONS(1),
    [sym_private] = ACTIONS(1),
    [sym_read] = ACTIONS(1),
    [sym_read_write] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_storage] = ACTIONS(1),
    [sym_switch] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_type] = ACTIONS(1),
    [sym_uniform] = ACTIONS(1),
    [sym_var] = ACTIONS(1),
    [sym_workgroup] = ACTIONS(1),
    [sym_write] = ACTIONS(1),
    [sym_r8unorm] = ACTIONS(1),
    [sym_r8snorm] = ACTIONS(1),
    [sym_r8uint] = ACTIONS(1),
    [sym_r8sint] = ACTIONS(1),
    [sym_r16uint] = ACTIONS(1),
    [sym_r16sint] = ACTIONS(1),
    [sym_r16float] = ACTIONS(1),
    [sym_rg8unorm] = ACTIONS(1),
    [sym_rg8snorm] = ACTIONS(1),
    [sym_rg8uint] = ACTIONS(1),
    [sym_rg8sint] = ACTIONS(1),
    [sym_r32uint] = ACTIONS(1),
    [sym_r32sint] = ACTIONS(1),
    [sym_r32float] = ACTIONS(1),
    [sym_rg16uint] = ACTIONS(1),
    [sym_rg16sint] = ACTIONS(1),
    [sym_rg16float] = ACTIONS(1),
    [sym_rgba8unorm] = ACTIONS(1),
    [sym_rgba8unorm_srgb] = ACTIONS(1),
    [sym_rgba8snorm] = ACTIONS(1),
    [sym_rgba8uint] = ACTIONS(1),
    [sym_rgba8sint] = ACTIONS(1),
    [sym_bgra8unorm] = ACTIONS(1),
    [sym_bgra8unorm_srgb] = ACTIONS(1),
    [sym_rgb10a2unorm] = ACTIONS(1),
    [sym_rg11b10float] = ACTIONS(1),
    [sym_rg32uint] = ACTIONS(1),
    [sym_rg32sint] = ACTIONS(1),
    [sym_rg32float] = ACTIONS(1),
    [sym_rgba16uint] = ACTIONS(1),
    [sym_rgba16sint] = ACTIONS(1),
    [sym_rgba16float] = ACTIONS(1),
    [sym_rgba32uint] = ACTIONS(1),
    [sym_rgba32sint] = ACTIONS(1),
    [sym_rgba32float] = ACTIONS(1),
    [sym_and] = ACTIONS(1),
    [sym_and_and] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_forward_slash] = ACTIONS(1),
    [sym_bang] = ACTIONS(1),
    [sym_bracket_left] = ACTIONS(1),
    [sym_bracket_right] = ACTIONS(1),
    [sym_brace_left] = ACTIONS(1),
    [sym_brace_right] = ACTIONS(1),
    [sym_colon] = ACTIONS(1),
    [sym_comma] = ACTIONS(1),
    [sym_equal] = ACTIONS(1),
    [sym_equal_equal] = ACTIONS(1),
    [sym_not_equal] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [sym_greater_than_equal] = ACTIONS(1),
    [sym_shift_right] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_less_than_equal] = ACTIONS(1),
    [sym_shift_left] = ACTIONS(1),
    [sym_modulo] = ACTIONS(1),
    [sym_minus] = ACTIONS(1),
    [sym_period] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plus_plus] = ACTIONS(1),
    [sym_or] = ACTIONS(1),
    [sym_or_or] = ACTIONS(1),
    [sym_paren_left] = ACTIONS(1),
    [sym_paren_right] = ACTIONS(1),
    [sym_semicolon] = ACTIONS(1),
    [sym_star] = ACTIONS(1),
    [sym_tilde] = ACTIONS(1),
    [sym_xor] = ACTIONS(1),
    [aux_sym__reserved_token1] = ACTIONS(1),
    [aux_sym__reserved_token2] = ACTIONS(1),
    [aux_sym__reserved_token3] = ACTIONS(1),
    [aux_sym__reserved_token4] = ACTIONS(1),
    [aux_sym__reserved_token5] = ACTIONS(1),
    [aux_sym__reserved_token6] = ACTIONS(1),
    [aux_sym__reserved_token7] = ACTIONS(1),
    [aux_sym__reserved_token8] = ACTIONS(1),
    [aux_sym__reserved_token9] = ACTIONS(1),
    [aux_sym__reserved_token10] = ACTIONS(1),
    [aux_sym__reserved_token11] = ACTIONS(1),
    [aux_sym__reserved_token12] = ACTIONS(1),
    [aux_sym__reserved_token13] = ACTIONS(1),
    [aux_sym__reserved_token14] = ACTIONS(1),
    [aux_sym__reserved_token15] = ACTIONS(1),
    [aux_sym__reserved_token16] = ACTIONS(1),
    [aux_sym__reserved_token17] = ACTIONS(1),
    [aux_sym__reserved_token18] = ACTIONS(1),
    [aux_sym__reserved_token19] = ACTIONS(1),
    [aux_sym__reserved_token20] = ACTIONS(1),
    [aux_sym__reserved_token21] = ACTIONS(1),
    [aux_sym__reserved_token22] = ACTIONS(1),
    [aux_sym__reserved_token23] = ACTIONS(1),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [1] = {
    [sym_translation_unit] = STATE(327),
    [sym_attribute_list] = STATE(80),
    [sym_struct_decl] = STATE(323),
    [sym_type_alias] = STATE(323),
    [sym_variable_decl] = STATE(223),
    [sym_global_variable_decl] = STATE(323),
    [sym_global_constant_decl] = STATE(323),
    [sym_function_decl] = STATE(127),
    [sym_function_header] = STATE(225),
    [sym_enable_directive] = STATE(127),
    [sym__comment] = STATE(1),
    [aux_sym_translation_unit_repeat1] = STATE(107),
    [aux_sym_array_type_decl_repeat1] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_struct] = ACTIONS(9),
    [sym_enable] = ACTIONS(11),
    [sym_fn] = ACTIONS(13),
    [sym_let] = ACTIONS(15),
    [sym_type] = ACTIONS(17),
    [sym_var] = ACTIONS(19),
    [sym_attr_left] = ACTIONS(21),
    [sym_semicolon] = ACTIONS(23),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [2] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_continuing_statement] = STATE(337),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statements] = STATE(208),
    [sym_statement] = STATE(52),
    [sym__comment] = STATE(2),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_statements_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_continuing] = ACTIONS(57),
    [sym_discard] = ACTIONS(59),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(79),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [3] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_case_body] = STATE(341),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statement] = STATE(6),
    [sym__comment] = STATE(3),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_discard] = ACTIONS(59),
    [sym_fallthrough] = ACTIONS(87),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(89),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [4] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statements] = STATE(303),
    [sym_statement] = STATE(52),
    [sym__comment] = STATE(4),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_statements_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_discard] = ACTIONS(59),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(91),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [5] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statements] = STATE(328),
    [sym_statement] = STATE(52),
    [sym__comment] = STATE(5),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_statements_repeat1] = STATE(8),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_discard] = ACTIONS(59),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(93),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [6] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_case_body] = STATE(348),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statement] = STATE(6),
    [sym__comment] = STATE(6),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_discard] = ACTIONS(59),
    [sym_fallthrough] = ACTIONS(87),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(95),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [7] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_case_body] = STATE(347),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statement] = STATE(6),
    [sym__comment] = STATE(7),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_discard] = ACTIONS(59),
    [sym_fallthrough] = ACTIONS(87),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(97),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [8] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statement] = STATE(52),
    [sym__comment] = STATE(8),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_statements_repeat1] = STATE(9),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_break] = ACTIONS(53),
    [sym_continue] = ACTIONS(55),
    [sym_continuing] = ACTIONS(99),
    [sym_discard] = ACTIONS(59),
    [sym_false] = ACTIONS(29),
    [sym_for] = ACTIONS(61),
    [sym_if] = ACTIONS(63),
    [sym_let] = ACTIONS(65),
    [sym_loop] = ACTIONS(67),
    [sym_return] = ACTIONS(69),
    [sym_switch] = ACTIONS(71),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_brace_left] = ACTIONS(77),
    [sym_brace_right] = ACTIONS(101),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(85),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [9] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(310),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_compound_statement] = STATE(49),
    [sym_assignment_statement] = STATE(310),
    [sym_if_statement] = STATE(49),
    [sym_switch_statement] = STATE(49),
    [sym_loop_statement] = STATE(49),
    [sym_for_statement] = STATE(49),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_func_call_statement] = STATE(310),
    [sym_statement] = STATE(52),
    [sym__comment] = STATE(9),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_statements_repeat1] = STATE(9),
    [sym_ident] = ACTIONS(103),
    [sym_decimal_float_literal] = ACTIONS(106),
    [sym_hex_float_literal] = ACTIONS(106),
    [sym_int_literal] = ACTIONS(109),
    [sym_uint_literal] = ACTIONS(112),
    [sym_array] = ACTIONS(115),
    [sym_atomic] = ACTIONS(118),
    [sym_bool] = ACTIONS(121),
    [sym_float32] = ACTIONS(121),
    [sym_int32] = ACTIONS(121),
    [sym_mat2x2] = ACTIONS(118),
    [sym_mat2x3] = ACTIONS(118),
    [sym_mat2x4] = ACTIONS(118),
    [sym_mat3x2] = ACTIONS(118),
    [sym_mat3x3] = ACTIONS(118),
    [sym_mat3x4] = ACTIONS(118),
    [sym_mat4x2] = ACTIONS(118),
    [sym_mat4x3] = ACTIONS(118),
    [sym_mat4x4] = ACTIONS(118),
    [sym_pointer] = ACTIONS(124),
    [sym_sampler] = ACTIONS(127),
    [sym_sampler_comparison] = ACTIONS(127),
    [sym_texture_1d] = ACTIONS(130),
    [sym_texture_2d] = ACTIONS(130),
    [sym_texture_2d_array] = ACTIONS(130),
    [sym_texture_3d] = ACTIONS(130),
    [sym_texture_cube] = ACTIONS(130),
    [sym_texture_cube_array] = ACTIONS(130),
    [sym_texture_multisampled_2d] = ACTIONS(133),
    [sym_texture_storage_1d] = ACTIONS(136),
    [sym_texture_storage_2d] = ACTIONS(136),
    [sym_texture_storage_2d_array] = ACTIONS(136),
    [sym_texture_storage_3d] = ACTIONS(136),
    [sym_texture_depth_2d] = ACTIONS(139),
    [sym_texture_depth_2d_array] = ACTIONS(139),
    [sym_texture_depth_cube] = ACTIONS(139),
    [sym_texture_depth_cube_array] = ACTIONS(139),
    [sym_texture_depth_multisampled_2d] = ACTIONS(139),
    [sym_uint32] = ACTIONS(121),
    [sym_vec2] = ACTIONS(118),
    [sym_vec3] = ACTIONS(118),
    [sym_vec4] = ACTIONS(118),
    [sym_bitcast] = ACTIONS(142),
    [sym_break] = ACTIONS(145),
    [sym_continue] = ACTIONS(148),
    [sym_continuing] = ACTIONS(151),
    [sym_discard] = ACTIONS(153),
    [sym_false] = ACTIONS(109),
    [sym_for] = ACTIONS(156),
    [sym_if] = ACTIONS(159),
    [sym_let] = ACTIONS(162),
    [sym_loop] = ACTIONS(165),
    [sym_return] = ACTIONS(168),
    [sym_switch] = ACTIONS(171),
    [sym_true] = ACTIONS(109),
    [sym_var] = ACTIONS(174),
    [sym_and] = ACTIONS(177),
    [sym_attr_left] = ACTIONS(180),
    [sym_bang] = ACTIONS(177),
    [sym_brace_left] = ACTIONS(183),
    [sym_brace_right] = ACTIONS(186),
    [sym_minus] = ACTIONS(188),
    [sym_paren_left] = ACTIONS(191),
    [sym_semicolon] = ACTIONS(194),
    [sym_star] = ACTIONS(177),
    [sym_tilde] = ACTIONS(177),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [10] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(207),
    [sym__comment] = STATE(10),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_argument_expression_list_repeat1] = STATE(11),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_paren_right] = ACTIONS(199),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [11] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(193),
    [sym__comment] = STATE(11),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_argument_expression_list_repeat1] = STATE(15),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [12] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(251),
    [sym__comment] = STATE(12),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(201),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [13] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(230),
    [sym__comment] = STATE(13),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(203),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [14] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(240),
    [sym__comment] = STATE(14),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(205),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [15] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(233),
    [sym__comment] = STATE(15),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [aux_sym_argument_expression_list_repeat1] = STATE(15),
    [sym_ident] = ACTIONS(207),
    [sym_decimal_float_literal] = ACTIONS(210),
    [sym_hex_float_literal] = ACTIONS(210),
    [sym_int_literal] = ACTIONS(213),
    [sym_uint_literal] = ACTIONS(216),
    [sym_array] = ACTIONS(219),
    [sym_atomic] = ACTIONS(222),
    [sym_bool] = ACTIONS(225),
    [sym_float32] = ACTIONS(225),
    [sym_int32] = ACTIONS(225),
    [sym_mat2x2] = ACTIONS(222),
    [sym_mat2x3] = ACTIONS(222),
    [sym_mat2x4] = ACTIONS(222),
    [sym_mat3x2] = ACTIONS(222),
    [sym_mat3x3] = ACTIONS(222),
    [sym_mat3x4] = ACTIONS(222),
    [sym_mat4x2] = ACTIONS(222),
    [sym_mat4x3] = ACTIONS(222),
    [sym_mat4x4] = ACTIONS(222),
    [sym_pointer] = ACTIONS(228),
    [sym_sampler] = ACTIONS(231),
    [sym_sampler_comparison] = ACTIONS(231),
    [sym_texture_1d] = ACTIONS(234),
    [sym_texture_2d] = ACTIONS(234),
    [sym_texture_2d_array] = ACTIONS(234),
    [sym_texture_3d] = ACTIONS(234),
    [sym_texture_cube] = ACTIONS(234),
    [sym_texture_cube_array] = ACTIONS(234),
    [sym_texture_multisampled_2d] = ACTIONS(237),
    [sym_texture_storage_1d] = ACTIONS(240),
    [sym_texture_storage_2d] = ACTIONS(240),
    [sym_texture_storage_2d_array] = ACTIONS(240),
    [sym_texture_storage_3d] = ACTIONS(240),
    [sym_texture_depth_2d] = ACTIONS(243),
    [sym_texture_depth_2d_array] = ACTIONS(243),
    [sym_texture_depth_cube] = ACTIONS(243),
    [sym_texture_depth_cube_array] = ACTIONS(243),
    [sym_texture_depth_multisampled_2d] = ACTIONS(243),
    [sym_uint32] = ACTIONS(225),
    [sym_vec2] = ACTIONS(222),
    [sym_vec3] = ACTIONS(222),
    [sym_vec4] = ACTIONS(222),
    [sym_bitcast] = ACTIONS(246),
    [sym_false] = ACTIONS(213),
    [sym_true] = ACTIONS(213),
    [sym_and] = ACTIONS(249),
    [sym_attr_left] = ACTIONS(252),
    [sym_bang] = ACTIONS(249),
    [sym_minus] = ACTIONS(255),
    [sym_paren_left] = ACTIONS(258),
    [sym_star] = ACTIONS(249),
    [sym_tilde] = ACTIONS(249),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [16] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(231),
    [sym__comment] = STATE(16),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [17] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(188),
    [sym__comment] = STATE(17),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [18] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(258),
    [sym__comment] = STATE(18),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [19] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(226),
    [sym__comment] = STATE(19),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [20] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(158),
    [sym_short_circuit_or_expression] = STATE(227),
    [sym__comment] = STATE(20),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [21] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(148),
    [sym_short_circuit_and_expression] = STATE(156),
    [sym__comment] = STATE(21),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [22] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_variable_statement] = STATE(283),
    [sym_variable_decl] = STATE(228),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_assignment_statement] = STATE(283),
    [sym_for_header] = STATE(349),
    [sym_func_call_statement] = STATE(283),
    [sym__comment] = STATE(22),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_let] = ACTIONS(65),
    [sym_true] = ACTIONS(29),
    [sym_var] = ACTIONS(73),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_semicolon] = ACTIONS(261),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [23] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(131),
    [sym_inclusive_or_expression] = STATE(143),
    [sym__comment] = STATE(23),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [24] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(128),
    [sym_exclusive_or_expression] = STATE(137),
    [sym__comment] = STATE(24),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [25] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(121),
    [sym_and_expression] = STATE(122),
    [sym__comment] = STATE(25),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [26] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(112),
    [sym_equality_expression] = STATE(116),
    [sym__comment] = STATE(26),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [27] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(110),
    [sym_relational_expression] = STATE(113),
    [sym__comment] = STATE(27),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [28] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_assignment_statement] = STATE(321),
    [sym_func_call_statement] = STATE(321),
    [sym__comment] = STATE(28),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_paren_right] = ACTIONS(263),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [29] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(109),
    [sym_shift_expression] = STATE(111),
    [sym__comment] = STATE(29),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [30] = {
    [sym_elseif_statement] = STATE(38),
    [sym_else_statement] = STATE(51),
    [sym__comment] = STATE(30),
    [sym_ident] = ACTIONS(265),
    [sym_decimal_float_literal] = ACTIONS(267),
    [sym_hex_float_literal] = ACTIONS(267),
    [sym_int_literal] = ACTIONS(265),
    [sym_uint_literal] = ACTIONS(267),
    [sym_array] = ACTIONS(265),
    [sym_atomic] = ACTIONS(265),
    [sym_bool] = ACTIONS(265),
    [sym_float32] = ACTIONS(265),
    [sym_int32] = ACTIONS(265),
    [sym_mat2x2] = ACTIONS(265),
    [sym_mat2x3] = ACTIONS(265),
    [sym_mat2x4] = ACTIONS(265),
    [sym_mat3x2] = ACTIONS(265),
    [sym_mat3x3] = ACTIONS(265),
    [sym_mat3x4] = ACTIONS(265),
    [sym_mat4x2] = ACTIONS(265),
    [sym_mat4x3] = ACTIONS(265),
    [sym_mat4x4] = ACTIONS(265),
    [sym_pointer] = ACTIONS(265),
    [sym_sampler] = ACTIONS(265),
    [sym_sampler_comparison] = ACTIONS(265),
    [sym_texture_1d] = ACTIONS(265),
    [sym_texture_2d] = ACTIONS(265),
    [sym_texture_2d_array] = ACTIONS(265),
    [sym_texture_3d] = ACTIONS(265),
    [sym_texture_cube] = ACTIONS(265),
    [sym_texture_cube_array] = ACTIONS(265),
    [sym_texture_multisampled_2d] = ACTIONS(265),
    [sym_texture_storage_1d] = ACTIONS(265),
    [sym_texture_storage_2d] = ACTIONS(265),
    [sym_texture_storage_2d_array] = ACTIONS(265),
    [sym_texture_storage_3d] = ACTIONS(265),
    [sym_texture_depth_2d] = ACTIONS(265),
    [sym_texture_depth_2d_array] = ACTIONS(265),
    [sym_texture_depth_cube] = ACTIONS(265),
    [sym_texture_depth_cube_array] = ACTIONS(265),
    [sym_texture_depth_multisampled_2d] = ACTIONS(265),
    [sym_uint32] = ACTIONS(265),
    [sym_vec2] = ACTIONS(265),
    [sym_vec3] = ACTIONS(265),
    [sym_vec4] = ACTIONS(265),
    [sym_bitcast] = ACTIONS(265),
    [sym_break] = ACTIONS(265),
    [sym_continue] = ACTIONS(265),
    [sym_continuing] = ACTIONS(265),
    [sym_discard] = ACTIONS(265),
    [sym_else] = ACTIONS(269),
    [sym_else_if] = ACTIONS(271),
    [sym_fallthrough] = ACTIONS(265),
    [sym_false] = ACTIONS(265),
    [sym_for] = ACTIONS(265),
    [sym_if] = ACTIONS(265),
    [sym_let] = ACTIONS(265),
    [sym_loop] = ACTIONS(265),
    [sym_return] = ACTIONS(265),
    [sym_switch] = ACTIONS(265),
    [sym_true] = ACTIONS(265),
    [sym_var] = ACTIONS(265),
    [sym_and] = ACTIONS(267),
    [sym_attr_left] = ACTIONS(267),
    [sym_bang] = ACTIONS(267),
    [sym_brace_left] = ACTIONS(267),
    [sym_brace_right] = ACTIONS(267),
    [sym_minus] = ACTIONS(265),
    [sym_paren_left] = ACTIONS(267),
    [sym_semicolon] = ACTIONS(267),
    [sym_star] = ACTIONS(267),
    [sym_tilde] = ACTIONS(267),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [31] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_assignment_statement] = STATE(333),
    [sym_func_call_statement] = STATE(333),
    [sym__comment] = STATE(31),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_paren_right] = ACTIONS(273),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [32] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(317),
    [sym_singular_expression] = STATE(98),
    [sym_assignment_statement] = STATE(295),
    [sym_func_call_statement] = STATE(295),
    [sym__comment] = STATE(32),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(25),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_paren_right] = ACTIONS(275),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [33] = {
    [sym_elseif_statement] = STATE(39),
    [sym__comment] = STATE(33),
    [sym_ident] = ACTIONS(277),
    [sym_decimal_float_literal] = ACTIONS(279),
    [sym_hex_float_literal] = ACTIONS(279),
    [sym_int_literal] = ACTIONS(277),
    [sym_uint_literal] = ACTIONS(279),
    [sym_array] = ACTIONS(277),
    [sym_atomic] = ACTIONS(277),
    [sym_bool] = ACTIONS(277),
    [sym_float32] = ACTIONS(277),
    [sym_int32] = ACTIONS(277),
    [sym_mat2x2] = ACTIONS(277),
    [sym_mat2x3] = ACTIONS(277),
    [sym_mat2x4] = ACTIONS(277),
    [sym_mat3x2] = ACTIONS(277),
    [sym_mat3x3] = ACTIONS(277),
    [sym_mat3x4] = ACTIONS(277),
    [sym_mat4x2] = ACTIONS(277),
    [sym_mat4x3] = ACTIONS(277),
    [sym_mat4x4] = ACTIONS(277),
    [sym_pointer] = ACTIONS(277),
    [sym_sampler] = ACTIONS(277),
    [sym_sampler_comparison] = ACTIONS(277),
    [sym_texture_1d] = ACTIONS(277),
    [sym_texture_2d] = ACTIONS(277),
    [sym_texture_2d_array] = ACTIONS(277),
    [sym_texture_3d] = ACTIONS(277),
    [sym_texture_cube] = ACTIONS(277),
    [sym_texture_cube_array] = ACTIONS(277),
    [sym_texture_multisampled_2d] = ACTIONS(277),
    [sym_texture_storage_1d] = ACTIONS(277),
    [sym_texture_storage_2d] = ACTIONS(277),
    [sym_texture_storage_2d_array] = ACTIONS(277),
    [sym_texture_storage_3d] = ACTIONS(277),
    [sym_texture_depth_2d] = ACTIONS(277),
    [sym_texture_depth_2d_array] = ACTIONS(277),
    [sym_texture_depth_cube] = ACTIONS(277),
    [sym_texture_depth_cube_array] = ACTIONS(277),
    [sym_texture_depth_multisampled_2d] = ACTIONS(277),
    [sym_uint32] = ACTIONS(277),
    [sym_vec2] = ACTIONS(277),
    [sym_vec3] = ACTIONS(277),
    [sym_vec4] = ACTIONS(277),
    [sym_bitcast] = ACTIONS(277),
    [sym_break] = ACTIONS(277),
    [sym_continue] = ACTIONS(277),
    [sym_continuing] = ACTIONS(277),
    [sym_discard] = ACTIONS(277),
    [sym_else] = ACTIONS(277),
    [sym_else_if] = ACTIONS(271),
    [sym_fallthrough] = ACTIONS(277),
    [sym_false] = ACTIONS(277),
    [sym_for] = ACTIONS(277),
    [sym_if] = ACTIONS(277),
    [sym_let] = ACTIONS(277),
    [sym_loop] = ACTIONS(277),
    [sym_return] = ACTIONS(277),
    [sym_switch] = ACTIONS(277),
    [sym_true] = ACTIONS(277),
    [sym_var] = ACTIONS(277),
    [sym_and] = ACTIONS(279),
    [sym_attr_left] = ACTIONS(279),
    [sym_bang] = ACTIONS(279),
    [sym_brace_left] = ACTIONS(279),
    [sym_brace_right] = ACTIONS(279),
    [sym_minus] = ACTIONS(277),
    [sym_paren_left] = ACTIONS(279),
    [sym_semicolon] = ACTIONS(279),
    [sym_star] = ACTIONS(279),
    [sym_tilde] = ACTIONS(279),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [34] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(105),
    [sym_additive_expression] = STATE(108),
    [sym__comment] = STATE(34),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [35] = {
    [sym__comment] = STATE(35),
    [sym_ident] = ACTIONS(281),
    [sym_decimal_float_literal] = ACTIONS(283),
    [sym_hex_float_literal] = ACTIONS(283),
    [sym_int_literal] = ACTIONS(281),
    [sym_uint_literal] = ACTIONS(283),
    [sym_array] = ACTIONS(281),
    [sym_atomic] = ACTIONS(281),
    [sym_bool] = ACTIONS(281),
    [sym_float32] = ACTIONS(281),
    [sym_int32] = ACTIONS(281),
    [sym_mat2x2] = ACTIONS(281),
    [sym_mat2x3] = ACTIONS(281),
    [sym_mat2x4] = ACTIONS(281),
    [sym_mat3x2] = ACTIONS(281),
    [sym_mat3x3] = ACTIONS(281),
    [sym_mat3x4] = ACTIONS(281),
    [sym_mat4x2] = ACTIONS(281),
    [sym_mat4x3] = ACTIONS(281),
    [sym_mat4x4] = ACTIONS(281),
    [sym_pointer] = ACTIONS(281),
    [sym_sampler] = ACTIONS(281),
    [sym_sampler_comparison] = ACTIONS(281),
    [sym_texture_1d] = ACTIONS(281),
    [sym_texture_2d] = ACTIONS(281),
    [sym_texture_2d_array] = ACTIONS(281),
    [sym_texture_3d] = ACTIONS(281),
    [sym_texture_cube] = ACTIONS(281),
    [sym_texture_cube_array] = ACTIONS(281),
    [sym_texture_multisampled_2d] = ACTIONS(281),
    [sym_texture_storage_1d] = ACTIONS(281),
    [sym_texture_storage_2d] = ACTIONS(281),
    [sym_texture_storage_2d_array] = ACTIONS(281),
    [sym_texture_storage_3d] = ACTIONS(281),
    [sym_texture_depth_2d] = ACTIONS(281),
    [sym_texture_depth_2d_array] = ACTIONS(281),
    [sym_texture_depth_cube] = ACTIONS(281),
    [sym_texture_depth_cube_array] = ACTIONS(281),
    [sym_texture_depth_multisampled_2d] = ACTIONS(281),
    [sym_uint32] = ACTIONS(281),
    [sym_vec2] = ACTIONS(281),
    [sym_vec3] = ACTIONS(281),
    [sym_vec4] = ACTIONS(281),
    [sym_bitcast] = ACTIONS(281),
    [sym_break] = ACTIONS(281),
    [sym_continue] = ACTIONS(281),
    [sym_continuing] = ACTIONS(281),
    [sym_discard] = ACTIONS(281),
    [sym_else] = ACTIONS(281),
    [sym_else_if] = ACTIONS(281),
    [sym_fallthrough] = ACTIONS(281),
    [sym_false] = ACTIONS(281),
    [sym_for] = ACTIONS(281),
    [sym_if] = ACTIONS(281),
    [sym_let] = ACTIONS(281),
    [sym_loop] = ACTIONS(281),
    [sym_return] = ACTIONS(281),
    [sym_switch] = ACTIONS(281),
    [sym_true] = ACTIONS(281),
    [sym_var] = ACTIONS(281),
    [sym_and] = ACTIONS(283),
    [sym_attr_left] = ACTIONS(283),
    [sym_bang] = ACTIONS(283),
    [sym_brace_left] = ACTIONS(283),
    [sym_brace_right] = ACTIONS(283),
    [sym_minus] = ACTIONS(281),
    [sym_paren_left] = ACTIONS(283),
    [sym_semicolon] = ACTIONS(283),
    [sym_star] = ACTIONS(283),
    [sym_tilde] = ACTIONS(283),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [36] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(104),
    [sym_singular_expression] = STATE(98),
    [sym_multiplicative_expression] = STATE(102),
    [sym__comment] = STATE(36),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [37] = {
    [sym__comment] = STATE(37),
    [sym_ident] = ACTIONS(285),
    [sym_decimal_float_literal] = ACTIONS(287),
    [sym_hex_float_literal] = ACTIONS(287),
    [sym_int_literal] = ACTIONS(285),
    [sym_uint_literal] = ACTIONS(287),
    [sym_array] = ACTIONS(285),
    [sym_atomic] = ACTIONS(285),
    [sym_bool] = ACTIONS(285),
    [sym_float32] = ACTIONS(285),
    [sym_int32] = ACTIONS(285),
    [sym_mat2x2] = ACTIONS(285),
    [sym_mat2x3] = ACTIONS(285),
    [sym_mat2x4] = ACTIONS(285),
    [sym_mat3x2] = ACTIONS(285),
    [sym_mat3x3] = ACTIONS(285),
    [sym_mat3x4] = ACTIONS(285),
    [sym_mat4x2] = ACTIONS(285),
    [sym_mat4x3] = ACTIONS(285),
    [sym_mat4x4] = ACTIONS(285),
    [sym_pointer] = ACTIONS(285),
    [sym_sampler] = ACTIONS(285),
    [sym_sampler_comparison] = ACTIONS(285),
    [sym_texture_1d] = ACTIONS(285),
    [sym_texture_2d] = ACTIONS(285),
    [sym_texture_2d_array] = ACTIONS(285),
    [sym_texture_3d] = ACTIONS(285),
    [sym_texture_cube] = ACTIONS(285),
    [sym_texture_cube_array] = ACTIONS(285),
    [sym_texture_multisampled_2d] = ACTIONS(285),
    [sym_texture_storage_1d] = ACTIONS(285),
    [sym_texture_storage_2d] = ACTIONS(285),
    [sym_texture_storage_2d_array] = ACTIONS(285),
    [sym_texture_storage_3d] = ACTIONS(285),
    [sym_texture_depth_2d] = ACTIONS(285),
    [sym_texture_depth_2d_array] = ACTIONS(285),
    [sym_texture_depth_cube] = ACTIONS(285),
    [sym_texture_depth_cube_array] = ACTIONS(285),
    [sym_texture_depth_multisampled_2d] = ACTIONS(285),
    [sym_uint32] = ACTIONS(285),
    [sym_vec2] = ACTIONS(285),
    [sym_vec3] = ACTIONS(285),
    [sym_vec4] = ACTIONS(285),
    [sym_bitcast] = ACTIONS(285),
    [sym_break] = ACTIONS(285),
    [sym_continue] = ACTIONS(285),
    [sym_continuing] = ACTIONS(285),
    [sym_discard] = ACTIONS(285),
    [sym_else] = ACTIONS(285),
    [sym_else_if] = ACTIONS(285),
    [sym_fallthrough] = ACTIONS(285),
    [sym_false] = ACTIONS(285),
    [sym_for] = ACTIONS(285),
    [sym_if] = ACTIONS(285),
    [sym_let] = ACTIONS(285),
    [sym_loop] = ACTIONS(285),
    [sym_return] = ACTIONS(285),
    [sym_switch] = ACTIONS(285),
    [sym_true] = ACTIONS(285),
    [sym_var] = ACTIONS(285),
    [sym_and] = ACTIONS(287),
    [sym_attr_left] = ACTIONS(287),
    [sym_bang] = ACTIONS(287),
    [sym_brace_left] = ACTIONS(287),
    [sym_brace_right] = ACTIONS(287),
    [sym_minus] = ACTIONS(285),
    [sym_paren_left] = ACTIONS(287),
    [sym_semicolon] = ACTIONS(287),
    [sym_star] = ACTIONS(287),
    [sym_tilde] = ACTIONS(287),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [38] = {
    [sym_else_statement] = STATE(45),
    [sym__comment] = STATE(38),
    [sym_ident] = ACTIONS(289),
    [sym_decimal_float_literal] = ACTIONS(291),
    [sym_hex_float_literal] = ACTIONS(291),
    [sym_int_literal] = ACTIONS(289),
    [sym_uint_literal] = ACTIONS(291),
    [sym_array] = ACTIONS(289),
    [sym_atomic] = ACTIONS(289),
    [sym_bool] = ACTIONS(289),
    [sym_float32] = ACTIONS(289),
    [sym_int32] = ACTIONS(289),
    [sym_mat2x2] = ACTIONS(289),
    [sym_mat2x3] = ACTIONS(289),
    [sym_mat2x4] = ACTIONS(289),
    [sym_mat3x2] = ACTIONS(289),
    [sym_mat3x3] = ACTIONS(289),
    [sym_mat3x4] = ACTIONS(289),
    [sym_mat4x2] = ACTIONS(289),
    [sym_mat4x3] = ACTIONS(289),
    [sym_mat4x4] = ACTIONS(289),
    [sym_pointer] = ACTIONS(289),
    [sym_sampler] = ACTIONS(289),
    [sym_sampler_comparison] = ACTIONS(289),
    [sym_texture_1d] = ACTIONS(289),
    [sym_texture_2d] = ACTIONS(289),
    [sym_texture_2d_array] = ACTIONS(289),
    [sym_texture_3d] = ACTIONS(289),
    [sym_texture_cube] = ACTIONS(289),
    [sym_texture_cube_array] = ACTIONS(289),
    [sym_texture_multisampled_2d] = ACTIONS(289),
    [sym_texture_storage_1d] = ACTIONS(289),
    [sym_texture_storage_2d] = ACTIONS(289),
    [sym_texture_storage_2d_array] = ACTIONS(289),
    [sym_texture_storage_3d] = ACTIONS(289),
    [sym_texture_depth_2d] = ACTIONS(289),
    [sym_texture_depth_2d_array] = ACTIONS(289),
    [sym_texture_depth_cube] = ACTIONS(289),
    [sym_texture_depth_cube_array] = ACTIONS(289),
    [sym_texture_depth_multisampled_2d] = ACTIONS(289),
    [sym_uint32] = ACTIONS(289),
    [sym_vec2] = ACTIONS(289),
    [sym_vec3] = ACTIONS(289),
    [sym_vec4] = ACTIONS(289),
    [sym_bitcast] = ACTIONS(289),
    [sym_break] = ACTIONS(289),
    [sym_continue] = ACTIONS(289),
    [sym_continuing] = ACTIONS(289),
    [sym_discard] = ACTIONS(289),
    [sym_else] = ACTIONS(269),
    [sym_fallthrough] = ACTIONS(289),
    [sym_false] = ACTIONS(289),
    [sym_for] = ACTIONS(289),
    [sym_if] = ACTIONS(289),
    [sym_let] = ACTIONS(289),
    [sym_loop] = ACTIONS(289),
    [sym_return] = ACTIONS(289),
    [sym_switch] = ACTIONS(289),
    [sym_true] = ACTIONS(289),
    [sym_var] = ACTIONS(289),
    [sym_and] = ACTIONS(291),
    [sym_attr_left] = ACTIONS(291),
    [sym_bang] = ACTIONS(291),
    [sym_brace_left] = ACTIONS(291),
    [sym_brace_right] = ACTIONS(291),
    [sym_minus] = ACTIONS(289),
    [sym_paren_left] = ACTIONS(291),
    [sym_semicolon] = ACTIONS(291),
    [sym_star] = ACTIONS(291),
    [sym_tilde] = ACTIONS(291),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [39] = {
    [sym__comment] = STATE(39),
    [sym_ident] = ACTIONS(293),
    [sym_decimal_float_literal] = ACTIONS(295),
    [sym_hex_float_literal] = ACTIONS(295),
    [sym_int_literal] = ACTIONS(293),
    [sym_uint_literal] = ACTIONS(295),
    [sym_array] = ACTIONS(293),
    [sym_atomic] = ACTIONS(293),
    [sym_bool] = ACTIONS(293),
    [sym_float32] = ACTIONS(293),
    [sym_int32] = ACTIONS(293),
    [sym_mat2x2] = ACTIONS(293),
    [sym_mat2x3] = ACTIONS(293),
    [sym_mat2x4] = ACTIONS(293),
    [sym_mat3x2] = ACTIONS(293),
    [sym_mat3x3] = ACTIONS(293),
    [sym_mat3x4] = ACTIONS(293),
    [sym_mat4x2] = ACTIONS(293),
    [sym_mat4x3] = ACTIONS(293),
    [sym_mat4x4] = ACTIONS(293),
    [sym_pointer] = ACTIONS(293),
    [sym_sampler] = ACTIONS(293),
    [sym_sampler_comparison] = ACTIONS(293),
    [sym_texture_1d] = ACTIONS(293),
    [sym_texture_2d] = ACTIONS(293),
    [sym_texture_2d_array] = ACTIONS(293),
    [sym_texture_3d] = ACTIONS(293),
    [sym_texture_cube] = ACTIONS(293),
    [sym_texture_cube_array] = ACTIONS(293),
    [sym_texture_multisampled_2d] = ACTIONS(293),
    [sym_texture_storage_1d] = ACTIONS(293),
    [sym_texture_storage_2d] = ACTIONS(293),
    [sym_texture_storage_2d_array] = ACTIONS(293),
    [sym_texture_storage_3d] = ACTIONS(293),
    [sym_texture_depth_2d] = ACTIONS(293),
    [sym_texture_depth_2d_array] = ACTIONS(293),
    [sym_texture_depth_cube] = ACTIONS(293),
    [sym_texture_depth_cube_array] = ACTIONS(293),
    [sym_texture_depth_multisampled_2d] = ACTIONS(293),
    [sym_uint32] = ACTIONS(293),
    [sym_vec2] = ACTIONS(293),
    [sym_vec3] = ACTIONS(293),
    [sym_vec4] = ACTIONS(293),
    [sym_bitcast] = ACTIONS(293),
    [sym_break] = ACTIONS(293),
    [sym_continue] = ACTIONS(293),
    [sym_continuing] = ACTIONS(293),
    [sym_discard] = ACTIONS(293),
    [sym_else] = ACTIONS(293),
    [sym_fallthrough] = ACTIONS(293),
    [sym_false] = ACTIONS(293),
    [sym_for] = ACTIONS(293),
    [sym_if] = ACTIONS(293),
    [sym_let] = ACTIONS(293),
    [sym_loop] = ACTIONS(293),
    [sym_return] = ACTIONS(293),
    [sym_switch] = ACTIONS(293),
    [sym_true] = ACTIONS(293),
    [sym_var] = ACTIONS(293),
    [sym_and] = ACTIONS(295),
    [sym_attr_left] = ACTIONS(295),
    [sym_bang] = ACTIONS(295),
    [sym_brace_left] = ACTIONS(295),
    [sym_brace_right] = ACTIONS(295),
    [sym_minus] = ACTIONS(293),
    [sym_paren_left] = ACTIONS(295),
    [sym_semicolon] = ACTIONS(295),
    [sym_star] = ACTIONS(295),
    [sym_tilde] = ACTIONS(295),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [40] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(103),
    [sym_singular_expression] = STATE(98),
    [sym__comment] = STATE(40),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [41] = {
    [sym_const_literal] = STATE(94),
    [sym_float_literal] = STATE(85),
    [sym_attribute_list] = STATE(80),
    [sym_array_type_decl] = STATE(145),
    [sym_texture_sampler_types] = STATE(145),
    [sym_sampler_type] = STATE(140),
    [sym_sampled_texture_type] = STATE(342),
    [sym_multisampled_texture_type] = STATE(342),
    [sym_storage_texture_type] = STATE(345),
    [sym_depth_texture_type] = STATE(140),
    [sym_type_decl] = STATE(229),
    [sym_primary_expression] = STATE(89),
    [sym_paren_expression] = STATE(94),
    [sym_unary_expression] = STATE(100),
    [sym_singular_expression] = STATE(98),
    [sym__comment] = STATE(41),
    [aux_sym_array_type_decl_repeat1] = STATE(174),
    [sym_ident] = ACTIONS(197),
    [sym_decimal_float_literal] = ACTIONS(27),
    [sym_hex_float_literal] = ACTIONS(27),
    [sym_int_literal] = ACTIONS(29),
    [sym_uint_literal] = ACTIONS(31),
    [sym_array] = ACTIONS(33),
    [sym_atomic] = ACTIONS(35),
    [sym_bool] = ACTIONS(37),
    [sym_float32] = ACTIONS(37),
    [sym_int32] = ACTIONS(37),
    [sym_mat2x2] = ACTIONS(35),
    [sym_mat2x3] = ACTIONS(35),
    [sym_mat2x4] = ACTIONS(35),
    [sym_mat3x2] = ACTIONS(35),
    [sym_mat3x3] = ACTIONS(35),
    [sym_mat3x4] = ACTIONS(35),
    [sym_mat4x2] = ACTIONS(35),
    [sym_mat4x3] = ACTIONS(35),
    [sym_mat4x4] = ACTIONS(35),
    [sym_pointer] = ACTIONS(39),
    [sym_sampler] = ACTIONS(41),
    [sym_sampler_comparison] = ACTIONS(41),
    [sym_texture_1d] = ACTIONS(43),
    [sym_texture_2d] = ACTIONS(43),
    [sym_texture_2d_array] = ACTIONS(43),
    [sym_texture_3d] = ACTIONS(43),
    [sym_texture_cube] = ACTIONS(43),
    [sym_texture_cube_array] = ACTIONS(43),
    [sym_texture_multisampled_2d] = ACTIONS(45),
    [sym_texture_storage_1d] = ACTIONS(47),
    [sym_texture_storage_2d] = ACTIONS(47),
    [sym_texture_storage_2d_array] = ACTIONS(47),
    [sym_texture_storage_3d] = ACTIONS(47),
    [sym_texture_depth_2d] = ACTIONS(49),
    [sym_texture_depth_2d_array] = ACTIONS(49),
    [sym_texture_depth_cube] = ACTIONS(49),
    [sym_texture_depth_cube_array] = ACTIONS(49),
    [sym_texture_depth_multisampled_2d] = ACTIONS(49),
    [sym_uint32] = ACTIONS(37),
    [sym_vec2] = ACTIONS(35),
    [sym_vec3] = ACTIONS(35),
    [sym_vec4] = ACTIONS(35),
    [sym_bitcast] = ACTIONS(51),
    [sym_false] = ACTIONS(29),
    [sym_true] = ACTIONS(29),
    [sym_and] = ACTIONS(75),
    [sym_attr_left] = ACTIONS(21),
    [sym_bang] = ACTIONS(75),
    [sym_minus] = ACTIONS(81),
    [sym_paren_left] = ACTIONS(83),
    [sym_star] = ACTIONS(75),
    [sym_tilde] = ACTIONS(75),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [42] = {
    [sym__comment] = STATE(42),
    [sym_ident] = ACTIONS(297),
    [sym_decimal_float_literal] = ACTIONS(299),
    [sym_hex_float_literal] = ACTIONS(299),
    [sym_int_literal] = ACTIONS(297),
    [sym_uint_literal] = ACTIONS(299),
    [sym_array] = ACTIONS(297),
    [sym_atomic] = ACTIONS(297),
    [sym_bool] = ACTIONS(297),
    [sym_float32] = ACTIONS(297),
    [sym_int32] = ACTIONS(297),
    [sym_mat2x2] = ACTIONS(297),
    [sym_mat2x3] = ACTIONS(297),
    [sym_mat2x4] = ACTIONS(297),
    [sym_mat3x2] = ACTIONS(297),
    [sym_mat3x3] = ACTIONS(297),
    [sym_mat3x4] = ACTIONS(297),
    [sym_mat4x2] = ACTIONS(297),
    [sym_mat4x3] = ACTIONS(297),
    [sym_mat4x4] = ACTIONS(297),
    [sym_pointer] = ACTIONS(297),
    [sym_sampler] = ACTIONS(297),
    [sym_sampler_comparison] = ACTIONS(297),
    [sym_texture_1d] = ACTIONS(297),
    [sym_texture_2d] = ACTIONS(297),
    [sym_texture_2d_array] = ACTIONS(297),
    [sym_texture_3d] = ACTIONS(297),
    [sym_texture_cube] = ACTIONS(297),
    [sym_texture_cube_array] = ACTIONS(297),
    [sym_texture_multisampled_2d] = ACTIONS(297),
    [sym_texture_storage_1d] = ACTIONS(297),
    [sym_texture_storage_2d] = ACTIONS(297),
    [sym_texture_storage_2d_array] = ACTIONS(297),
    [sym_texture_storage_3d] = ACTIONS(297),
    [sym_texture_depth_2d] = ACTIONS(297),
    [sym_texture_depth_2d_array] = ACTIONS(297),
    [sym_texture_depth_cube] = ACTIONS(297),
    [sym_texture_depth_cube_array] = ACTIONS(297),
    [sym_texture_depth_multisampled_2d] = ACTIONS(297),
    [sym_uint32] = ACTIONS(297),
    [sym_vec2] = ACTIONS(297),
    [sym_vec3] = ACTIONS(297),
    [sym_vec4] = ACTIONS(297),
    [sym_bitcast] = ACTIONS(297),
    [sym_break] = ACTIONS(297),
    [sym_continue] = ACTIONS(297),
    [sym_continuing] = ACTIONS(297),
    [sym_discard] = ACTIONS(297),
    [sym_fallthrough] = ACTIONS(297),
    [sym_false] = ACTIONS(297),
    [sym_for] = ACTIONS(297),
    [sym_if] = ACTIONS(297),
    [sym_let] = ACTIONS(297),
    [sym_loop] = ACTIONS(297),
    [sym_return] = ACTIONS(297),
    [sym_switch] = ACTIONS(297),
    [sym_true] = ACTIONS(297),
    [sym_var] = ACTIONS(297),
    [sym_and] = ACTIONS(299),
    [sym_attr_left] = ACTIONS(299),
    [sym_bang] = ACTIONS(299),
    [sym_brace_left] = ACTIONS(299),
    [sym_brace_right] = ACTIONS(299),
    [sym_minus] = ACTIONS(297),
    [sym_paren_left] = ACTIONS(299),
    [sym_semicolon] = ACTIONS(299),
    [sym_star] = ACTIONS(299),
    [sym_tilde] = ACTIONS(299),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [43] = {
    [sym__comment] = STATE(43),
    [sym_ident] = ACTIONS(301),
    [sym_decimal_float_literal] = ACTIONS(303),
    [sym_hex_float_literal] = ACTIONS(303),
    [sym_int_literal] = ACTIONS(301),
    [sym_uint_literal] = ACTIONS(303),
    [sym_array] = ACTIONS(301),
    [sym_atomic] = ACTIONS(301),
    [sym_bool] = ACTIONS(301),
    [sym_float32] = ACTIONS(301),
    [sym_int32] = ACTIONS(301),
    [sym_mat2x2] = ACTIONS(301),
    [sym_mat2x3] = ACTIONS(301),
    [sym_mat2x4] = ACTIONS(301),
    [sym_mat3x2] = ACTIONS(301),
    [sym_mat3x3] = ACTIONS(301),
    [sym_mat3x4] = ACTIONS(301),
    [sym_mat4x2] = ACTIONS(301),
    [sym_mat4x3] = ACTIONS(301),
    [sym_mat4x4] = ACTIONS(301),
    [sym_pointer] = ACTIONS(301),
    [sym_sampler] = ACTIONS(301),
    [sym_sampler_comparison] = ACTIONS(301),
    [sym_texture_1d] = ACTIONS(301),
    [sym_texture_2d] = ACTIONS(301),
    [sym_texture_2d_array] = ACTIONS(301),
    [sym_texture_3d] = ACTIONS(301),
    [sym_texture_cube] = ACTIONS(301),
    [sym_texture_cube_array] = ACTIONS(301),
    [sym_texture_multisampled_2d] = ACTIONS(301),
    [sym_texture_storage_1d] = ACTIONS(301),
    [sym_texture_storage_2d] = ACTIONS(301),
    [sym_texture_storage_2d_array] = ACTIONS(301),
    [sym_texture_storage_3d] = ACTIONS(301),
    [sym_texture_depth_2d] = ACTIONS(301),
    [sym_texture_depth_2d_array] = ACTIONS(301),
    [sym_texture_depth_cube] = ACTIONS(301),
    [sym_texture_depth_cube_array] = ACTIONS(301),
    [sym_texture_depth_multisampled_2d] = ACTIONS(301),
    [sym_uint32] = ACTIONS(301),
    [sym_vec2] = ACTIONS(301),
    [sym_vec3] = ACTIONS(301),
    [sym_vec4] = ACTIONS(301),
    [sym_bitcast] = ACTIONS(301),
    [sym_break] = ACTIONS(301),
    [sym_continue] = ACTIONS(301),
    [sym_continuing] = ACTIONS(301),
    [sym_discard] = ACTIONS(301),
    [sym_fallthrough] = ACTIONS(301),
    [sym_false] = ACTIONS(301),
    [sym_for] = ACTIONS(301),
    [sym_if] = ACTIONS(301),
    [sym_let] = ACTIONS(301),
    [sym_loop] = ACTIONS(301),
    [sym_return] = ACTIONS(301),
    [sym_switch] = ACTIONS(301),
    [sym_true] = ACTIONS(301),
    [sym_var] = ACTIONS(301),
    [sym_and] = ACTIONS(303),
    [sym_attr_left] = ACTIONS(303),
    [sym_bang] = ACTIONS(303),
    [sym_brace_left] = ACTIONS(303),
    [sym_brace_right] = ACTIONS(303),
    [sym_minus] = ACTIONS(301),
    [sym_paren_left] = ACTIONS(303),
    [sym_semicolon] = ACTIONS(303),
    [sym_star] = ACTIONS(303),
    [sym_tilde] = ACTIONS(303),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [44] = {
    [sym__comment] = STATE(44),
    [sym_ident] = ACTIONS(305),
    [sym_decimal_float_literal] = ACTIONS(307),
    [sym_hex_float_literal] = ACTIONS(307),
    [sym_int_literal] = ACTIONS(305),
    [sym_uint_literal] = ACTIONS(307),
    [sym_array] = ACTIONS(305),
    [sym_atomic] = ACTIONS(305),
    [sym_bool] = ACTIONS(305),
    [sym_float32] = ACTIONS(305),
    [sym_int32] = ACTIONS(305),
    [sym_mat2x2] = ACTIONS(305),
    [sym_mat2x3] = ACTIONS(305),
    [sym_mat2x4] = ACTIONS(305),
    [sym_mat3x2] = ACTIONS(305),
    [sym_mat3x3] = ACTIONS(305),
    [sym_mat3x4] = ACTIONS(305),
    [sym_mat4x2] = ACTIONS(305),
    [sym_mat4x3] = ACTIONS(305),
    [sym_mat4x4] = ACTIONS(305),
    [sym_pointer] = ACTIONS(305),
    [sym_sampler] = ACTIONS(305),
    [sym_sampler_comparison] = ACTIONS(305),
    [sym_texture_1d] = ACTIONS(305),
    [sym_texture_2d] = ACTIONS(305),
    [sym_texture_2d_array] = ACTIONS(305),
    [sym_texture_3d] = ACTIONS(305),
    [sym_texture_cube] = ACTIONS(305),
    [sym_texture_cube_array] = ACTIONS(305),
    [sym_texture_multisampled_2d] = ACTIONS(305),
    [sym_texture_storage_1d] = ACTIONS(305),
    [sym_texture_storage_2d] = ACTIONS(305),
    [sym_texture_storage_2d_array] = ACTIONS(305),
    [sym_texture_storage_3d] = ACTIONS(305),
    [sym_texture_depth_2d] = ACTIONS(305),
    [sym_texture_depth_2d_array] = ACTIONS(305),
    [sym_texture_depth_cube] = ACTIONS(305),
    [sym_texture_depth_cube_array] = ACTIONS(305),
    [sym_texture_depth_multisampled_2d] = ACTIONS(305),
    [sym_uint32] = ACTIONS(305),
    [sym_vec2] = ACTIONS(305),
    [sym_vec3] = ACTIONS(305),
    [sym_vec4] = ACTIONS(305),
    [sym_bitcast] = ACTIONS(305),
    [sym_break] = ACTIONS(305),
    [sym_continue] = ACTIONS(305),
    [sym_continuing] = ACTIONS(305),
    [sym_discard] = ACTIONS(305),
    [sym_fallthrough] = ACTIONS(305),
    [sym_false] = ACTIONS(305),
    [sym_for] = ACTIONS(305),
    [sym_if] = ACTIONS(305),
    [sym_let] = ACTIONS(305),
    [sym_loop] = ACTIONS(305),
    [sym_return] = ACTIONS(305),
    [sym_switch] = ACTIONS(305),
    [sym_true] = ACTIONS(305),
    [sym_var] = ACTIONS(305),
    [sym_and] = ACTIONS(307),
    [sym_attr_left] = ACTIONS(307),
    [sym_bang] = ACTIONS(307),
    [sym_brace_left] = ACTIONS(307),
    [sym_brace_right] = ACTIONS(307),
    [sym_minus] = ACTIONS(305),
    [sym_paren_left] = ACTIONS(307),
    [sym_semicolon] = ACTIONS(307),
    [sym_star] = ACTIONS(307),
    [sym_tilde] = ACTIONS(307),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [45] = {
    [sym__comment] = STATE(45),
    [sym_ident] = ACTIONS(309),
    [sym_decimal_float_literal] = ACTIONS(311),
    [sym_hex_float_literal] = ACTIONS(311),
    [sym_int_literal] = ACTIONS(309),
    [sym_uint_literal] = ACTIONS(311),
    [sym_array] = ACTIONS(309),
    [sym_atomic] = ACTIONS(309),
    [sym_bool] = ACTIONS(309),
    [sym_float32] = ACTIONS(309),
    [sym_int32] = ACTIONS(309),
    [sym_mat2x2] = ACTIONS(309),
    [sym_mat2x3] = ACTIONS(309),
    [sym_mat2x4] = ACTIONS(309),
    [sym_mat3x2] = ACTIONS(309),
    [sym_mat3x3] = ACTIONS(309),
    [sym_mat3x4] = ACTIONS(309),
    [sym_mat4x2] = ACTIONS(309),
    [sym_mat4x3] = ACTIONS(309),
    [sym_mat4x4] = ACTIONS(309),
    [sym_pointer] = ACTIONS(309),
    [sym_sampler] = ACTIONS(309),
    [sym_sampler_comparison] = ACTIONS(309),
    [sym_texture_1d] = ACTIONS(309),
    [sym_texture_2d] = ACTIONS(309),
    [sym_texture_2d_array] = ACTIONS(309),
    [sym_texture_3d] = ACTIONS(309),
    [sym_texture_cube] = ACTIONS(309),
    [sym_texture_cube_array] = ACTIONS(309),
    [sym_texture_multisampled_2d] = ACTIONS(309),
    [sym_texture_storage_1d] = ACTIONS(309),
    [sym_texture_storage_2d] = ACTIONS(309),
    [sym_texture_storage_2d_array] = ACTIONS(309),
    [sym_texture_storage_3d] = ACTIONS(309),
    [sym_texture_depth_2d] = ACTIONS(309),
    [sym_texture_depth_2d_array] = ACTIONS(309),
    [sym_texture_depth_cube] = ACTIONS(309),
    [sym_texture_depth_cube_array] = ACTIONS(309),
    [sym_texture_depth_multisampled_2d] = ACTIONS(309),
    [sym_uint32] = ACTIONS(309),
    [sym_vec2] = ACTIONS(309),
    [sym_vec3] = ACTIONS(309),
    [sym_vec4] = ACTIONS(309),
    [sym_bitcast] = ACTIONS(309),
    [sym_break] = ACTIONS(309),
    [sym_continue] = ACTIONS(309),
    [sym_continuing] = ACTIONS(309),
    [sym_discard] = ACTIONS(309),
    [sym_fallthrough] = ACTIONS(309),
    [sym_false] = ACTIONS(309),
    [sym_for] = ACTIONS(309),
    [sym_if] = ACTIONS(309),
    [sym_let] = ACTIONS(309),
    [sym_loop] = ACTIONS(309),
    [sym_return] = ACTIONS(309),
    [sym_switch] = ACTIONS(309),
    [sym_true] = ACTIONS(309),
    [sym_var] = ACTIONS(309),
    [sym_and] = ACTIONS(311),
    [sym_attr_left] = ACTIONS(311),
    [sym_bang] = ACTIONS(311),
    [sym_brace_left] = ACTIONS(311),
    [sym_brace_right] = ACTIONS(311),
    [sym_minus] = ACTIONS(309),
    [sym_paren_left] = ACTIONS(311),
    [sym_semicolon] = ACTIONS(311),
    [sym_star] = ACTIONS(311),
    [sym_tilde] = ACTIONS(311),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [46] = {
    [sym__comment] = STATE(46),
    [sym_ident] = ACTIONS(313),
    [sym_decimal_float_literal] = ACTIONS(315),
    [sym_hex_float_literal] = ACTIONS(315),
    [sym_int_literal] = ACTIONS(313),
    [sym_uint_literal] = ACTIONS(315),
    [sym_array] = ACTIONS(313),
    [sym_atomic] = ACTIONS(313),
    [sym_bool] = ACTIONS(313),
    [sym_float32] = ACTIONS(313),
    [sym_int32] = ACTIONS(313),
    [sym_mat2x2] = ACTIONS(313),
    [sym_mat2x3] = ACTIONS(313),
    [sym_mat2x4] = ACTIONS(313),
    [sym_mat3x2] = ACTIONS(313),
    [sym_mat3x3] = ACTIONS(313),
    [sym_mat3x4] = ACTIONS(313),
    [sym_mat4x2] = ACTIONS(313),
    [sym_mat4x3] = ACTIONS(313),
    [sym_mat4x4] = ACTIONS(313),
    [sym_pointer] = ACTIONS(313),
    [sym_sampler] = ACTIONS(313),
    [sym_sampler_comparison] = ACTIONS(313),
    [sym_texture_1d] = ACTIONS(313),
    [sym_texture_2d] = ACTIONS(313),
    [sym_texture_2d_array] = ACTIONS(313),
    [sym_texture_3d] = ACTIONS(313),
    [sym_texture_cube] = ACTIONS(313),
    [sym_texture_cube_array] = ACTIONS(313),
    [sym_texture_multisampled_2d] = ACTIONS(313),
    [sym_texture_storage_1d] = ACTIONS(313),
    [sym_texture_storage_2d] = ACTIONS(313),
    [sym_texture_storage_2d_array] = ACTIONS(313),
    [sym_texture_storage_3d] = ACTIONS(313),
    [sym_texture_depth_2d] = ACTIONS(313),
    [sym_texture_depth_2d_array] = ACTIONS(313),
    [sym_texture_depth_cube] = ACTIONS(313),
    [sym_texture_depth_cube_array] = ACTIONS(313),
    [sym_texture_depth_multisampled_2d] = ACTIONS(313),
    [sym_uint32] = ACTIONS(313),
    [sym_vec2] = ACTIONS(313),
    [sym_vec3] = ACTIONS(313),
    [sym_vec4] = ACTIONS(313),
    [sym_bitcast] = ACTIONS(313),
    [sym_break] = ACTIONS(313),
    [sym_continue] = ACTIONS(313),
    [sym_continuing] = ACTIONS(313),
    [sym_discard] = ACTIONS(313),
    [sym_fallthrough] = ACTIONS(313),
    [sym_false] = ACTIONS(313),
    [sym_for] = ACTIONS(313),
    [sym_if] = ACTIONS(313),
    [sym_let] = ACTIONS(313),
    [sym_loop] = ACTIONS(313),
    [sym_return] = ACTIONS(313),
    [sym_switch] = ACTIONS(313),
    [sym_true] = ACTIONS(313),
    [sym_var] = ACTIONS(313),
    [sym_and] = ACTIONS(315),
    [sym_attr_left] = ACTIONS(315),
    [sym_bang] = ACTIONS(315),
    [sym_brace_left] = ACTIONS(315),
    [sym_brace_right] = ACTIONS(315),
    [sym_minus] = ACTIONS(313),
    [sym_paren_left] = ACTIONS(315),
    [sym_semicolon] = ACTIONS(315),
    [sym_star] = ACTIONS(315),
    [sym_tilde] = ACTIONS(315),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [47] = {
    [sym__comment] = STATE(47),
    [sym_ident] = ACTIONS(317),
    [sym_decimal_float_literal] = ACTIONS(319),
    [sym_hex_float_literal] = ACTIONS(319),
    [sym_int_literal] = ACTIONS(317),
    [sym_uint_literal] = ACTIONS(319),
    [sym_array] = ACTIONS(317),
    [sym_atomic] = ACTIONS(317),
    [sym_bool] = ACTIONS(317),
    [sym_float32] = ACTIONS(317),
    [sym_int32] = ACTIONS(317),
    [sym_mat2x2] = ACTIONS(317),
    [sym_mat2x3] = ACTIONS(317),
    [sym_mat2x4] = ACTIONS(317),
    [sym_mat3x2] = ACTIONS(317),
    [sym_mat3x3] = ACTIONS(317),
    [sym_mat3x4] = ACTIONS(317),
    [sym_mat4x2] = ACTIONS(317),
    [sym_mat4x3] = ACTIONS(317),
    [sym_mat4x4] = ACTIONS(317),
    [sym_pointer] = ACTIONS(317),
    [sym_sampler] = ACTIONS(317),
    [sym_sampler_comparison] = ACTIONS(317),
    [sym_texture_1d] = ACTIONS(317),
    [sym_texture_2d] = ACTIONS(317),
    [sym_texture_2d_array] = ACTIONS(317),
    [sym_texture_3d] = ACTIONS(317),
    [sym_texture_cube] = ACTIONS(317),
    [sym_texture_cube_array] = ACTIONS(317),
    [sym_texture_multisampled_2d] = ACTIONS(317),
    [sym_texture_storage_1d] = ACTIONS(317),
    [sym_texture_storage_2d] = ACTIONS(317),
    [sym_texture_storage_2d_array] = ACTIONS(317),
    [sym_texture_storage_3d] = ACTIONS(317),
    [sym_texture_depth_2d] = ACTIONS(317),
    [sym_texture_depth_2d_array] = ACTIONS(317),
    [sym_texture_depth_cube] = ACTIONS(317),
    [sym_texture_depth_cube_array] = ACTIONS(317),
    [sym_texture_depth_multisampled_2d] = ACTIONS(317),
    [sym_uint32] = ACTIONS(317),
    [sym_vec2] = ACTIONS(317),
    [sym_vec3] = ACTIONS(317),
    [sym_vec4] = ACTIONS(317),
    [sym_bitcast] = ACTIONS(317),
    [sym_break] = ACTIONS(317),
    [sym_continue] = ACTIONS(317),
    [sym_continuing] = ACTIONS(317),
    [sym_discard] = ACTIONS(317),
    [sym_fallthrough] = ACTIONS(317),
    [sym_false] = ACTIONS(317),
    [sym_for] = ACTIONS(317),
    [sym_if] = ACTIONS(317),
    [sym_let] = ACTIONS(317),
    [sym_loop] = ACTIONS(317),
    [sym_return] = ACTIONS(317),
    [sym_switch] = ACTIONS(317),
    [sym_true] = ACTIONS(317),
    [sym_var] = ACTIONS(317),
    [sym_and] = ACTIONS(319),
    [sym_attr_left] = ACTIONS(319),
    [sym_bang] = ACTIONS(319),
    [sym_brace_left] = ACTIONS(319),
    [sym_brace_right] = ACTIONS(319),
    [sym_minus] = ACTIONS(317),
    [sym_paren_left] = ACTIONS(319),
    [sym_semicolon] = ACTIONS(319),
    [sym_star] = ACTIONS(319),
    [sym_tilde] = ACTIONS(319),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [48] = {
    [sym__comment] = STATE(48),
    [sym_ident] = ACTIONS(321),
    [sym_decimal_float_literal] = ACTIONS(323),
    [sym_hex_float_literal] = ACTIONS(323),
    [sym_int_literal] = ACTIONS(321),
    [sym_uint_literal] = ACTIONS(323),
    [sym_array] = ACTIONS(321),
    [sym_atomic] = ACTIONS(321),
    [sym_bool] = ACTIONS(321),
    [sym_float32] = ACTIONS(321),
    [sym_int32] = ACTIONS(321),
    [sym_mat2x2] = ACTIONS(321),
    [sym_mat2x3] = ACTIONS(321),
    [sym_mat2x4] = ACTIONS(321),
    [sym_mat3x2] = ACTIONS(321),
    [sym_mat3x3] = ACTIONS(321),
    [sym_mat3x4] = ACTIONS(321),
    [sym_mat4x2] = ACTIONS(321),
    [sym_mat4x3] = ACTIONS(321),
    [sym_mat4x4] = ACTIONS(321),
    [sym_pointer] = ACTIONS(321),
    [sym_sampler] = ACTIONS(321),
    [sym_sampler_comparison] = ACTIONS(321),
    [sym_texture_1d] = ACTIONS(321),
    [sym_texture_2d] = ACTIONS(321),
    [sym_texture_2d_array] = ACTIONS(321),
    [sym_texture_3d] = ACTIONS(321),
    [sym_texture_cube] = ACTIONS(321),
    [sym_texture_cube_array] = ACTIONS(321),
    [sym_texture_multisampled_2d] = ACTIONS(321),
    [sym_texture_storage_1d] = ACTIONS(321),
    [sym_texture_storage_2d] = ACTIONS(321),
    [sym_texture_storage_2d_array] = ACTIONS(321),
    [sym_texture_storage_3d] = ACTIONS(321),
    [sym_texture_depth_2d] = ACTIONS(321),
    [sym_texture_depth_2d_array] = ACTIONS(321),
    [sym_texture_depth_cube] = ACTIONS(321),
    [sym_texture_depth_cube_array] = ACTIONS(321),
    [sym_texture_depth_multisampled_2d] = ACTIONS(321),
    [sym_uint32] = ACTIONS(321),
    [sym_vec2] = ACTIONS(321),
    [sym_vec3] = ACTIONS(321),
    [sym_vec4] = ACTIONS(321),
    [sym_bitcast] = ACTIONS(321),
    [sym_break] = ACTIONS(321),
    [sym_continue] = ACTIONS(321),
    [sym_continuing] = ACTIONS(321),
    [sym_discard] = ACTIONS(321),
    [sym_fallthrough] = ACTIONS(321),
    [sym_false] = ACTIONS(321),
    [sym_for] = ACTIONS(321),
    [sym_if] = ACTIONS(321),
    [sym_let] = ACTIONS(321),
    [sym_loop] = ACTIONS(321),
    [sym_return] = ACTIONS(321),
    [sym_switch] = ACTIONS(321),
    [sym_true] = ACTIONS(321),
    [sym_var] = ACTIONS(321),
    [sym_and] = ACTIONS(323),
    [sym_attr_left] = ACTIONS(323),
    [sym_bang] = ACTIONS(323),
    [sym_brace_left] = ACTIONS(323),
    [sym_brace_right] = ACTIONS(323),
    [sym_minus] = ACTIONS(321),
    [sym_paren_left] = ACTIONS(323),
    [sym_semicolon] = ACTIONS(323),
    [sym_star] = ACTIONS(323),
    [sym_tilde] = ACTIONS(323),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [49] = {
    [sym__comment] = STATE(49),
    [sym_ident] = ACTIONS(325),
    [sym_decimal_float_literal] = ACTIONS(327),
    [sym_hex_float_literal] = ACTIONS(327),
    [sym_int_literal] = ACTIONS(325),
    [sym_uint_literal] = ACTIONS(327),
    [sym_array] = ACTIONS(325),
    [sym_atomic] = ACTIONS(325),
    [sym_bool] = ACTIONS(325),
    [sym_float32] = ACTIONS(325),
    [sym_int32] = ACTIONS(325),
    [sym_mat2x2] = ACTIONS(325),
    [sym_mat2x3] = ACTIONS(325),
    [sym_mat2x4] = ACTIONS(325),
    [sym_mat3x2] = ACTIONS(325),
    [sym_mat3x3] = ACTIONS(325),
    [sym_mat3x4] = ACTIONS(325),
    [sym_mat4x2] = ACTIONS(325),
    [sym_mat4x3] = ACTIONS(325),
    [sym_mat4x4] = ACTIONS(325),
    [sym_pointer] = ACTIONS(325),
    [sym_sampler] = ACTIONS(325),
    [sym_sampler_comparison] = ACTIONS(325),
    [sym_texture_1d] = ACTIONS(325),
    [sym_texture_2d] = ACTIONS(325),
    [sym_texture_2d_array] = ACTIONS(325),
    [sym_texture_3d] = ACTIONS(325),
    [sym_texture_cube] = ACTIONS(325),
    [sym_texture_cube_array] = ACTIONS(325),
    [sym_texture_multisampled_2d] = ACTIONS(325),
    [sym_texture_storage_1d] = ACTIONS(325),
    [sym_texture_storage_2d] = ACTIONS(325),
    [sym_texture_storage_2d_array] = ACTIONS(325),
    [sym_texture_storage_3d] = ACTIONS(325),
    [sym_texture_depth_2d] = ACTIONS(325),
    [sym_texture_depth_2d_array] = ACTIONS(325),
    [sym_texture_depth_cube] = ACTIONS(325),
    [sym_texture_depth_cube_array] = ACTIONS(325),
    [sym_texture_depth_multisampled_2d] = ACTIONS(325),
    [sym_uint32] = ACTIONS(325),
    [sym_vec2] = ACTIONS(325),
    [sym_vec3] = ACTIONS(325),
    [sym_vec4] = ACTIONS(325),
    [sym_bitcast] = ACTIONS(325),
    [sym_break] = ACTIONS(325),
    [sym_continue] = ACTIONS(325),
    [sym_continuing] = ACTIONS(325),
    [sym_discard] = ACTIONS(325),
    [sym_fallthrough] = ACTIONS(325),
    [sym_false] = ACTIONS(325),
    [sym_for] = ACTIONS(325),
    [sym_if] = ACTIONS(325),
    [sym_let] = ACTIONS(325),
    [sym_loop] = ACTIONS(325),
    [sym_return] = ACTIONS(325),
    [sym_switch] = ACTIONS(325),
    [sym_true] = ACTIONS(325),
    [sym_var] = ACTIONS(325),
    [sym_and] = ACTIONS(327),
    [sym_attr_left] = ACTIONS(327),
    [sym_bang] = ACTIONS(327),
    [sym_brace_left] = ACTIONS(327),
    [sym_brace_right] = ACTIONS(327),
    [sym_minus] = ACTIONS(325),
    [sym_paren_left] = ACTIONS(327),
    [sym_semicolon] = ACTIONS(327),
    [sym_star] = ACTIONS(327),
    [sym_tilde] = ACTIONS(327),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [50] = {
    [sym__comment] = STATE(50),
    [sym_ident] = ACTIONS(329),
    [sym_decimal_float_literal] = ACTIONS(331),
    [sym_hex_float_literal] = ACTIONS(331),
    [sym_int_literal] = ACTIONS(329),
    [sym_uint_literal] = ACTIONS(331),
    [sym_array] = ACTIONS(329),
    [sym_atomic] = ACTIONS(329),
    [sym_bool] = ACTIONS(329),
    [sym_float32] = ACTIONS(329),
    [sym_int32] = ACTIONS(329),
    [sym_mat2x2] = ACTIONS(329),
    [sym_mat2x3] = ACTIONS(329),
    [sym_mat2x4] = ACTIONS(329),
    [sym_mat3x2] = ACTIONS(329),
    [sym_mat3x3] = ACTIONS(329),
    [sym_mat3x4] = ACTIONS(329),
    [sym_mat4x2] = ACTIONS(329),
    [sym_mat4x3] = ACTIONS(329),
    [sym_mat4x4] = ACTIONS(329),
    [sym_pointer] = ACTIONS(329),
    [sym_sampler] = ACTIONS(329),
    [sym_sampler_comparison] = ACTIONS(329),
    [sym_texture_1d] = ACTIONS(329),
    [sym_texture_2d] = ACTIONS(329),
    [sym_texture_2d_array] = ACTIONS(329),
    [sym_texture_3d] = ACTIONS(329),
    [sym_texture_cube] = ACTIONS(329),
    [sym_texture_cube_array] = ACTIONS(329),
    [sym_texture_multisampled_2d] = ACTIONS(329),
    [sym_texture_storage_1d] = ACTIONS(329),
    [sym_texture_storage_2d] = ACTIONS(329),
    [sym_texture_storage_2d_array] = ACTIONS(329),
    [sym_texture_storage_3d] = ACTIONS(329),
    [sym_texture_depth_2d] = ACTIONS(329),
    [sym_texture_depth_2d_array] = ACTIONS(329),
    [sym_texture_depth_cube] = ACTIONS(329),
    [sym_texture_depth_cube_array] = ACTIONS(329),
    [sym_texture_depth_multisampled_2d] = ACTIONS(329),
    [sym_uint32] = ACTIONS(329),
    [sym_vec2] = ACTIONS(329),
    [sym_vec3] = ACTIONS(329),
    [sym_vec4] = ACTIONS(329),
    [sym_bitcast] = ACTIONS(329),
    [sym_break] = ACTIONS(329),
    [sym_continue] = ACTIONS(329),
    [sym_continuing] = ACTIONS(329),
    [sym_discard] = ACTIONS(329),
    [sym_fallthrough] = ACTIONS(329),
    [sym_false] = ACTIONS(329),
    [sym_for] = ACTIONS(329),
    [sym_if] = ACTIONS(329),
    [sym_let] = ACTIONS(329),
    [sym_loop] = ACTIONS(329),
    [sym_return] = ACTIONS(329),
    [sym_switch] = ACTIONS(329),
    [sym_true] = ACTIONS(329),
    [sym_var] = ACTIONS(329),
    [sym_and] = ACTIONS(331),
    [sym_attr_left] = ACTIONS(331),
    [sym_bang] = ACTIONS(331),
    [sym_brace_left] = ACTIONS(331),
    [sym_brace_right] = ACTIONS(331),
    [sym_minus] = ACTIONS(329),
    [sym_paren_left] = ACTIONS(331),
    [sym_semicolon] = ACTIONS(331),
    [sym_star] = ACTIONS(331),
    [sym_tilde] = ACTIONS(331),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [51] = {
    [sym__comment] = STATE(51),
    [sym_ident] = ACTIONS(289),
    [sym_decimal_float_literal] = ACTIONS(291),
    [sym_hex_float_literal] = ACTIONS(291),
    [sym_int_literal] = ACTIONS(289),
    [sym_uint_literal] = ACTIONS(291),
    [sym_array] = ACTIONS(289),
    [sym_atomic] = ACTIONS(289),
    [sym_bool] = ACTIONS(289),
    [sym_float32] = ACTIONS(289),
    [sym_int32] = ACTIONS(289),
    [sym_mat2x2] = ACTIONS(289),
    [sym_mat2x3] = ACTIONS(289),
    [sym_mat2x4] = ACTIONS(289),
    [sym_mat3x2] = ACTIONS(289),
    [sym_mat3x3] = ACTIONS(289),
    [sym_mat3x4] = ACTIONS(289),
    [sym_mat4x2] = ACTIONS(289),
    [sym_mat4x3] = ACTIONS(289),
    [sym_mat4x4] = ACTIONS(289),
    [sym_pointer] = ACTIONS(289),
    [sym_sampler] = ACTIONS(289),
    [sym_sampler_comparison] = ACTIONS(289),
    [sym_texture_1d] = ACTIONS(289),
    [sym_texture_2d] = ACTIONS(289),
    [sym_texture_2d_array] = ACTIONS(289),
    [sym_texture_3d] = ACTIONS(289),
    [sym_texture_cube] = ACTIONS(289),
    [sym_texture_cube_array] = ACTIONS(289),
    [sym_texture_multisampled_2d] = ACTIONS(289),
    [sym_texture_storage_1d] = ACTIONS(289),
    [sym_texture_storage_2d] = ACTIONS(289),
    [sym_texture_storage_2d_array] = ACTIONS(289),
    [sym_texture_storage_3d] = ACTIONS(289),
    [sym_texture_depth_2d] = ACTIONS(289),
    [sym_texture_depth_2d_array] = ACTIONS(289),
    [sym_texture_depth_cube] = ACTIONS(289),
    [sym_texture_depth_cube_array] = ACTIONS(289),
    [sym_texture_depth_multisampled_2d] = ACTIONS(289),
    [sym_uint32] = ACTIONS(289),
    [sym_vec2] = ACTIONS(289),
    [sym_vec3] = ACTIONS(289),
    [sym_vec4] = ACTIONS(289),
    [sym_bitcast] = ACTIONS(289),
    [sym_break] = ACTIONS(289),
    [sym_continue] = ACTIONS(289),
    [sym_continuing] = ACTIONS(289),
    [sym_discard] = ACTIONS(289),
    [sym_fallthrough] = ACTIONS(289),
    [sym_false] = ACTIONS(289),
    [sym_for] = ACTIONS(289),
    [sym_if] = ACTIONS(289),
    [sym_let] = ACTIONS(289),
    [sym_loop] = ACTIONS(289),
    [sym_return] = ACTIONS(289),
    [sym_switch] = ACTIONS(289),
    [sym_true] = ACTIONS(289),
    [sym_var] = ACTIONS(289),
    [sym_and] = ACTIONS(291),
    [sym_attr_left] = ACTIONS(291),
    [sym_bang] = ACTIONS(291),
    [sym_brace_left] = ACTIONS(291),
    [sym_brace_right] = ACTIONS(291),
    [sym_minus] = ACTIONS(289),
    [sym_paren_left] = ACTIONS(291),
    [sym_semicolon] = ACTIONS(291),
    [sym_star] = ACTIONS(291),
    [sym_tilde] = ACTIONS(291),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
  [52] = {
    [sym__comment] = STATE(52),
    [sym_ident] = ACTIONS(333),
    [sym_decimal_float_literal] = ACTIONS(335),
    [sym_hex_float_literal] = ACTIONS(335),
    [sym_int_literal] = ACTIONS(333),
    [sym_uint_literal] = ACTIONS(335),
    [sym_array] = ACTIONS(333),
    [sym_atomic] = ACTIONS(333),
    [sym_bool] = ACTIONS(333),
    [sym_float32] = ACTIONS(333),
    [sym_int32] = ACTIONS(333),
    [sym_mat2x2] = ACTIONS(333),
    [sym_mat2x3] = ACTIONS(333),
    [sym_mat2x4] = ACTIONS(333),
    [sym_mat3x2] = ACTIONS(333),
    [sym_mat3x3] = ACTIONS(333),
    [sym_mat3x4] = ACTIONS(333),
    [sym_mat4x2] = ACTIONS(333),
    [sym_mat4x3] = ACTIONS(333),
    [sym_mat4x4] = ACTIONS(333),
    [sym_pointer] = ACTIONS(333),
    [sym_sampler] = ACTIONS(333),
    [sym_sampler_comparison] = ACTIONS(333),
    [sym_texture_1d] = ACTIONS(333),
    [sym_texture_2d] = ACTIONS(333),
    [sym_texture_2d_array] = ACTIONS(333),
    [sym_texture_3d] = ACTIONS(333),
    [sym_texture_cube] = ACTIONS(333),
    [sym_texture_cube_array] = ACTIONS(333),
    [sym_texture_multisampled_2d] = ACTIONS(333),
    [sym_texture_storage_1d] = ACTIONS(333),
    [sym_texture_storage_2d] = ACTIONS(333),
    [sym_texture_storage_2d_array] = ACTIONS(333),
    [sym_texture_storage_3d] = ACTIONS(333),
    [sym_texture_depth_2d] = ACTIONS(333),
    [sym_texture_depth_2d_array] = ACTIONS(333),
    [sym_texture_depth_cube] = ACTIONS(333),
    [sym_texture_depth_cube_array] = ACTIONS(333),
    [sym_texture_depth_multisampled_2d] = ACTIONS(333),
    [sym_uint32] = ACTIONS(333),
    [sym_vec2] = ACTIONS(333),
    [sym_vec3] = ACTIONS(333),
    [sym_vec4] = ACTIONS(333),
    [sym_bitcast] = ACTIONS(333),
    [sym_break] = ACTIONS(333),
    [sym_continue] = ACTIONS(333),
    [sym_continuing] = ACTIONS(333),
    [sym_discard] = ACTIONS(333),
    [sym_false] = ACTIONS(333),
    [sym_for] = ACTIONS(333),
    [sym_if] = ACTIONS(333),
    [sym_let] = ACTIONS(333),
    [sym_loop] = ACTIONS(333),
    [sym_return] = ACTIONS(333),
    [sym_switch] = ACTIONS(333),
    [sym_true] = ACTIONS(333),
    [sym_var] = ACTIONS(333),
    [sym_and] = ACTIONS(335),
    [sym_attr_left] = ACTIONS(335),
    [sym_bang] = ACTIONS(335),
    [sym_brace_left] = ACTIONS(335),
    [sym_brace_right] = ACTIONS(335),
    [sym_minus] = ACTIONS(333),
    [sym_paren_left] = ACTIONS(335),
    [sym_semicolon] = ACTIONS(335),
    [sym_star] = ACTIONS(335),
    [sym_tilde] = ACTIONS(335),
    [aux_sym__comment_token1] = ACTIONS(3),
    [sym__space] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 28,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(337), 1,
      sym_paren_right,
    STATE(53), 1,
      sym__comment,
    STATE(54), 1,
      aux_sym_const_expression_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(242), 1,
      sym_const_expression,
    STATE(301), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [120] = 27,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(54), 1,
      sym__comment,
    STATE(55), 1,
      aux_sym_const_expression_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(246), 1,
      sym_const_expression,
    STATE(301), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [237] = 26,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(348), 1,
      sym_uint_literal,
    ACTIONS(351), 1,
      sym_array,
    ACTIONS(357), 1,
      sym_pointer,
    ACTIONS(366), 1,
      sym_texture_multisampled_2d,
    ACTIONS(375), 1,
      sym_attr_left,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(291), 1,
      sym_const_expression,
    STATE(301), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(342), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(360), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(55), 2,
      sym__comment,
      aux_sym_const_expression_repeat1,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(345), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(369), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(339), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(372), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(363), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(354), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [352] = 26,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(56), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(278), 1,
      sym_const_expression,
    STATE(301), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [466] = 26,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(57), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(297), 1,
      sym_const_expression,
    STATE(301), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [580] = 26,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(31), 1,
      sym_uint_literal,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(58), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(85), 1,
      sym_float_literal,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(209), 1,
      sym_const_literal,
    STATE(301), 1,
      sym_type_decl,
    STATE(344), 1,
      sym_const_expression,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(29), 3,
      sym_int_literal,
      sym_false,
      sym_true,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [694] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(382), 1,
      sym_paren_right,
    STATE(59), 1,
      sym__comment,
    ACTIONS(380), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(378), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [763] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(384), 1,
      sym_paren_right,
    STATE(60), 1,
      sym__comment,
    ACTIONS(380), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(378), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [832] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(61), 1,
      sym__comment,
    ACTIONS(380), 9,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_and,
      sym_attr_left,
      sym_bang,
      sym_paren_left,
      sym_star,
      sym_tilde,
    ACTIONS(378), 43,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_bitcast,
      sym_false,
      sym_true,
      sym_minus,
      sym_ident,
  [898] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(62), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(244), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [991] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(63), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(300), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1084] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(386), 1,
      sym_array,
    STATE(64), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(81), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(282), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1177] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(65), 1,
      sym__comment,
    STATE(72), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(171), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1270] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(66), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(343), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1363] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(67), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(245), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1456] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(68), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(248), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1549] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(69), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(271), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1642] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(64), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(70), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(315), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1735] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(71), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(281), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1828] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    ACTIONS(386), 1,
      sym_array,
    STATE(72), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(81), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(181), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [1921] = 20,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(33), 1,
      sym_array,
    ACTIONS(39), 1,
      sym_pointer,
    ACTIONS(45), 1,
      sym_texture_multisampled_2d,
    STATE(73), 1,
      sym__comment,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(263), 1,
      sym_type_decl,
    STATE(345), 1,
      sym_storage_texture_type,
    ACTIONS(41), 2,
      sym_sampler,
      sym_sampler_comparison,
    STATE(140), 2,
      sym_sampler_type,
      sym_depth_texture_type,
    STATE(145), 2,
      sym_array_type_decl,
      sym_texture_sampler_types,
    STATE(342), 2,
      sym_sampled_texture_type,
      sym_multisampled_texture_type,
    ACTIONS(47), 4,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
    ACTIONS(37), 5,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_uint32,
      sym_ident,
    ACTIONS(49), 5,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
    ACTIONS(43), 6,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
    ACTIONS(35), 13,
      sym_atomic,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_vec2,
      sym_vec3,
      sym_vec4,
  [2014] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(392), 1,
      sym_paren_right,
    STATE(74), 1,
      sym__comment,
    ACTIONS(390), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(388), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2076] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(394), 1,
      sym_paren_right,
    STATE(75), 1,
      sym__comment,
    ACTIONS(390), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(388), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2138] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(398), 1,
      sym_attr_left,
    STATE(80), 1,
      sym_attribute_list,
    STATE(76), 2,
      sym__comment,
      aux_sym_array_type_decl_repeat1,
    ACTIONS(396), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2199] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(77), 1,
      sym__comment,
    ACTIONS(390), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_attr_left,
    ACTIONS(388), 41,
      sym_int_literal,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_false,
      sym_true,
      sym_ident,
  [2258] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(403), 1,
      sym_attr_left,
    STATE(78), 1,
      sym__comment,
    ACTIONS(401), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2315] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(407), 1,
      sym_attr_left,
    STATE(79), 1,
      sym__comment,
    ACTIONS(405), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2372] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(411), 1,
      sym_attr_left,
    STATE(80), 1,
      sym__comment,
    ACTIONS(409), 42,
      sym_array,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_struct,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_fn,
      sym_let,
      sym_var,
      sym_ident,
  [2429] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(398), 1,
      sym_attr_left,
    ACTIONS(413), 1,
      sym_array,
    STATE(76), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(81), 1,
      sym__comment,
    ACTIONS(396), 37,
      sym_atomic,
      sym_bool,
      sym_float32,
      sym_int32,
      sym_mat2x2,
      sym_mat2x3,
      sym_mat2x4,
      sym_mat3x2,
      sym_mat3x3,
      sym_mat3x4,
      sym_mat4x2,
      sym_mat4x3,
      sym_mat4x4,
      sym_pointer,
      sym_sampler,
      sym_sampler_comparison,
      sym_texture_1d,
      sym_texture_2d,
      sym_texture_2d_array,
      sym_texture_3d,
      sym_texture_cube,
      sym_texture_cube_array,
      sym_texture_multisampled_2d,
      sym_texture_storage_1d,
      sym_texture_storage_2d,
      sym_texture_storage_2d_array,
      sym_texture_storage_3d,
      sym_texture_depth_2d,
      sym_texture_depth_2d_array,
      sym_texture_depth_cube,
      sym_texture_depth_cube_array,
      sym_texture_depth_multisampled_2d,
      sym_uint32,
      sym_vec2,
      sym_vec3,
      sym_vec4,
      sym_ident,
  [2490] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(82), 1,
      sym__comment,
    STATE(290), 1,
      sym_texel_format,
    ACTIONS(418), 2,
      sym_rgba8unorm,
      sym_bgra8unorm,
    ACTIONS(416), 33,
      sym_r8unorm,
      sym_r8snorm,
      sym_r8uint,
      sym_r8sint,
      sym_r16uint,
      sym_r16sint,
      sym_r16float,
      sym_rg8unorm,
      sym_rg8snorm,
      sym_rg8uint,
      sym_rg8sint,
      sym_r32uint,
      sym_r32sint,
      sym_r32float,
      sym_rg16uint,
      sym_rg16sint,
      sym_rg16float,
      sym_rgba8unorm_srgb,
      sym_rgba8snorm,
      sym_rgba8uint,
      sym_rgba8sint,
      sym_bgra8unorm_srgb,
      sym_rgb10a2unorm,
      sym_rg11b10float,
      sym_rg32uint,
      sym_rg32sint,
      sym_rg32float,
      sym_rgba16uint,
      sym_rgba16sint,
      sym_rgba16float,
      sym_rgba32uint,
      sym_rgba32sint,
      sym_rgba32float,
  [2542] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(424), 1,
      sym_paren_left,
    STATE(83), 1,
      sym__comment,
    STATE(90), 1,
      sym_argument_expression_list,
    ACTIONS(420), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(422), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2587] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(431), 1,
      sym_bracket_left,
    ACTIONS(433), 1,
      sym_period,
    STATE(84), 1,
      sym__comment,
    STATE(101), 1,
      sym_postfix_expression,
    ACTIONS(427), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(429), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2633] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(85), 1,
      sym__comment,
    ACTIONS(435), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(437), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2673] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(86), 1,
      sym__comment,
    ACTIONS(439), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(441), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_colon,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2713] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(87), 1,
      sym__comment,
    ACTIONS(443), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(445), 20,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_brace_left,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2753] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(431), 1,
      sym_bracket_left,
    ACTIONS(433), 1,
      sym_period,
    STATE(88), 1,
      sym__comment,
    STATE(97), 1,
      sym_postfix_expression,
    ACTIONS(447), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(449), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2799] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(431), 1,
      sym_bracket_left,
    ACTIONS(433), 1,
      sym_period,
    STATE(89), 1,
      sym__comment,
    STATE(99), 1,
      sym_postfix_expression,
    ACTIONS(451), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(453), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2845] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(90), 1,
      sym__comment,
    ACTIONS(455), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(457), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2884] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(91), 1,
      sym__comment,
    ACTIONS(459), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(461), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2923] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(92), 1,
      sym__comment,
    ACTIONS(463), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(465), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [2962] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(93), 1,
      sym__comment,
    ACTIONS(467), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(469), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3001] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(94), 1,
      sym__comment,
    ACTIONS(420), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(422), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3040] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(95), 1,
      sym__comment,
    ACTIONS(471), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(473), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3079] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(96), 1,
      sym__comment,
    ACTIONS(475), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(477), 19,
      sym_and_and,
      sym_bracket_left,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_period,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3118] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(97), 1,
      sym__comment,
    ACTIONS(427), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(429), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3155] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(98), 1,
      sym__comment,
    ACTIONS(479), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(481), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3192] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(99), 1,
      sym__comment,
    ACTIONS(483), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(485), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3229] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(100), 1,
      sym__comment,
    ACTIONS(487), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(489), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3266] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(101), 1,
      sym__comment,
    ACTIONS(491), 6,
      sym_and,
      sym_forward_slash,
      sym_equal,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(493), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3303] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(499), 1,
      sym_forward_slash,
    STATE(102), 1,
      sym__comment,
    ACTIONS(501), 2,
      sym_modulo,
      sym_star,
    ACTIONS(495), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(497), 15,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3343] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(103), 1,
      sym__comment,
    ACTIONS(503), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(505), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3379] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(104), 1,
      sym__comment,
    ACTIONS(507), 5,
      sym_and,
      sym_forward_slash,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(509), 17,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_modulo,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_star,
      sym_xor,
  [3415] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(499), 1,
      sym_forward_slash,
    STATE(105), 1,
      sym__comment,
    ACTIONS(501), 2,
      sym_modulo,
      sym_star,
    ACTIONS(511), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(513), 15,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_minus,
      sym_plus,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3455] = 18,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(515), 1,
      ts_builtin_sym_end,
    ACTIONS(517), 1,
      sym_struct,
    ACTIONS(520), 1,
      sym_enable,
    ACTIONS(523), 1,
      sym_fn,
    ACTIONS(526), 1,
      sym_let,
    ACTIONS(529), 1,
      sym_type,
    ACTIONS(532), 1,
      sym_var,
    ACTIONS(535), 1,
      sym_attr_left,
    ACTIONS(538), 1,
      sym_semicolon,
    STATE(80), 1,
      sym_attribute_list,
    STATE(123), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(223), 1,
      sym_variable_decl,
    STATE(225), 1,
      sym_function_header,
    STATE(106), 2,
      sym__comment,
      aux_sym_translation_unit_repeat1,
    STATE(127), 2,
      sym_function_decl,
      sym_enable_directive,
    STATE(323), 4,
      sym_struct_decl,
      sym_type_alias,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [3515] = 19,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(9), 1,
      sym_struct,
    ACTIONS(11), 1,
      sym_enable,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(15), 1,
      sym_let,
    ACTIONS(17), 1,
      sym_type,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(23), 1,
      sym_semicolon,
    ACTIONS(541), 1,
      ts_builtin_sym_end,
    STATE(80), 1,
      sym_attribute_list,
    STATE(106), 1,
      aux_sym_translation_unit_repeat1,
    STATE(107), 1,
      sym__comment,
    STATE(123), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(223), 1,
      sym_variable_decl,
    STATE(225), 1,
      sym_function_header,
    STATE(127), 2,
      sym_function_decl,
      sym_enable_directive,
    STATE(323), 4,
      sym_struct_decl,
      sym_type_alias,
      sym_global_variable_decl,
      sym_global_constant_decl,
  [3577] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(108), 1,
      sym__comment,
    ACTIONS(547), 2,
      sym_minus,
      sym_plus,
    ACTIONS(543), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(545), 13,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3612] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(109), 1,
      sym__comment,
    ACTIONS(547), 2,
      sym_minus,
      sym_plus,
    ACTIONS(549), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(551), 13,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_shift_right,
      sym_less_than_equal,
      sym_shift_left,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3647] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(110), 1,
      sym__comment,
    ACTIONS(557), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(553), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(555), 11,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3680] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(111), 1,
      sym__comment,
    ACTIONS(557), 2,
      sym_shift_right,
      sym_shift_left,
    ACTIONS(559), 4,
      sym_and,
      sym_greater_than,
      sym_less_than,
      sym_or,
    ACTIONS(561), 11,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_equal_equal,
      sym_not_equal,
      sym_greater_than_equal,
      sym_less_than_equal,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3713] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(112), 1,
      sym__comment,
    ACTIONS(563), 2,
      sym_and,
      sym_or,
    ACTIONS(567), 2,
      sym_equal_equal,
      sym_not_equal,
    ACTIONS(569), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(571), 2,
      sym_greater_than_equal,
      sym_less_than_equal,
    ACTIONS(565), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3748] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(113), 1,
      sym__comment,
    ACTIONS(569), 2,
      sym_greater_than,
      sym_less_than,
    ACTIONS(571), 2,
      sym_greater_than_equal,
      sym_less_than_equal,
    ACTIONS(573), 2,
      sym_and,
      sym_or,
    ACTIONS(575), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3779] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(114), 1,
      sym__comment,
    ACTIONS(283), 10,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_brace_right,
      sym_semicolon,
  [3801] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(115), 1,
      sym__comment,
    ACTIONS(287), 10,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_brace_right,
      sym_semicolon,
  [3823] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(116), 1,
      sym__comment,
    ACTIONS(577), 2,
      sym_and,
      sym_or,
    ACTIONS(579), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3846] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(117), 1,
      sym__comment,
    ACTIONS(581), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [3867] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(85), 1,
      sym_float_literal,
    STATE(118), 1,
      sym__comment,
    STATE(185), 1,
      sym_const_literal,
    STATE(304), 1,
      sym_case_selectors,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [3898] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(583), 1,
      sym_colon,
    STATE(85), 1,
      sym_float_literal,
    STATE(119), 1,
      sym__comment,
    STATE(219), 1,
      sym_const_literal,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [3929] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(120), 1,
      sym__comment,
    ACTIONS(515), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [3950] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(121), 1,
      sym__comment,
    ACTIONS(585), 2,
      sym_and,
      sym_or,
    ACTIONS(587), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3973] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(589), 1,
      sym_and,
    ACTIONS(593), 1,
      sym_or,
    STATE(122), 1,
      sym__comment,
    ACTIONS(591), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [3998] = 12,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(13), 1,
      sym_fn,
    ACTIONS(19), 1,
      sym_var,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(595), 1,
      sym_struct,
    ACTIONS(597), 1,
      sym_let,
    STATE(76), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(123), 1,
      sym__comment,
    STATE(257), 1,
      sym_function_header,
    STATE(260), 1,
      sym_variable_decl,
  [4035] = 12,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    ACTIONS(601), 1,
      sym_paren_right,
    STATE(80), 1,
      sym_attribute_list,
    STATE(124), 1,
      sym__comment,
    STATE(149), 1,
      aux_sym_param_list_repeat1,
    STATE(168), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(213), 1,
      sym_variable_ident_decl,
    STATE(214), 1,
      sym_param,
    STATE(346), 1,
      sym_param_list,
  [4072] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(29), 1,
      sym_int_literal,
    ACTIONS(603), 1,
      sym_colon,
    STATE(85), 1,
      sym_float_literal,
    STATE(125), 1,
      sym__comment,
    STATE(219), 1,
      sym_const_literal,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [4103] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(126), 1,
      sym__comment,
    ACTIONS(605), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [4124] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(127), 1,
      sym__comment,
    ACTIONS(607), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [4145] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(589), 1,
      sym_and,
    ACTIONS(611), 1,
      sym_or,
    STATE(128), 1,
      sym__comment,
    ACTIONS(609), 7,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
      sym_xor,
  [4170] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(129), 1,
      sym__comment,
    ACTIONS(613), 9,
      ts_builtin_sym_end,
      sym_struct,
      sym_enable,
      sym_fn,
      sym_let,
      sym_type,
      sym_var,
      sym_attr_left,
      sym_semicolon,
  [4191] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(617), 1,
      sym_int_literal,
    STATE(130), 1,
      sym__comment,
    STATE(133), 1,
      aux_sym_attribute_repeat1,
    STATE(217), 1,
      sym_float_literal,
    STATE(261), 1,
      sym_literal_or_ident,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(615), 2,
      sym_uint_literal,
      sym_ident,
  [4221] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(621), 1,
      sym_or,
    ACTIONS(623), 1,
      sym_xor,
    STATE(131), 1,
      sym__comment,
    ACTIONS(619), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4245] = 11,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    ACTIONS(625), 1,
      sym_brace_right,
    STATE(80), 1,
      sym_attribute_list,
    STATE(132), 1,
      sym__comment,
    STATE(138), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(166), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(184), 1,
      sym_struct_member,
    STATE(311), 1,
      sym_variable_ident_decl,
  [4279] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(633), 1,
      sym_int_literal,
    STATE(217), 1,
      sym_float_literal,
    STATE(265), 1,
      sym_literal_or_ident,
    ACTIONS(627), 2,
      sym_uint_literal,
      sym_ident,
    ACTIONS(630), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    STATE(133), 2,
      sym__comment,
      aux_sym_attribute_repeat1,
  [4307] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(617), 1,
      sym_int_literal,
    STATE(130), 1,
      aux_sym_attribute_repeat1,
    STATE(134), 1,
      sym__comment,
    STATE(217), 1,
      sym_float_literal,
    STATE(218), 1,
      sym_literal_or_ident,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(615), 2,
      sym_uint_literal,
      sym_ident,
  [4337] = 10,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(636), 1,
      sym_ident,
    ACTIONS(639), 1,
      sym_attr_left,
    ACTIONS(642), 1,
      sym_brace_right,
    STATE(80), 1,
      sym_attribute_list,
    STATE(166), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(184), 1,
      sym_struct_member,
    STATE(311), 1,
      sym_variable_ident_decl,
    STATE(135), 2,
      sym__comment,
      aux_sym_struct_body_decl_repeat1,
  [4369] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(29), 1,
      sym_int_literal,
    STATE(85), 1,
      sym_float_literal,
    STATE(136), 1,
      sym__comment,
    STATE(219), 1,
      sym_const_literal,
    ACTIONS(27), 2,
      sym_decimal_float_literal,
      sym_hex_float_literal,
    ACTIONS(31), 3,
      sym_uint_literal,
      sym_false,
      sym_true,
  [4397] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(623), 1,
      sym_xor,
    ACTIONS(646), 1,
      sym_or,
    STATE(137), 1,
      sym__comment,
    ACTIONS(644), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4421] = 11,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    ACTIONS(648), 1,
      sym_brace_right,
    STATE(80), 1,
      sym_attribute_list,
    STATE(135), 1,
      aux_sym_struct_body_decl_repeat1,
    STATE(138), 1,
      sym__comment,
    STATE(166), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(184), 1,
      sym_struct_member,
    STATE(311), 1,
      sym_variable_ident_decl,
  [4455] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(139), 1,
      sym__comment,
    ACTIONS(650), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4474] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(140), 1,
      sym__comment,
    ACTIONS(652), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4493] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(141), 1,
      sym__comment,
    ACTIONS(654), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4512] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(142), 1,
      sym__comment,
    ACTIONS(656), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4531] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(660), 1,
      sym_or,
    STATE(143), 1,
      sym__comment,
    ACTIONS(658), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4552] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(144), 1,
      sym__comment,
    ACTIONS(662), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4571] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(145), 1,
      sym__comment,
    ACTIONS(664), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4590] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(146), 1,
      sym__comment,
    ACTIONS(666), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4609] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(147), 1,
      sym__comment,
    ACTIONS(668), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4628] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(660), 1,
      sym_or,
    STATE(148), 1,
      sym__comment,
    ACTIONS(670), 6,
      sym_and_and,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4649] = 10,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    STATE(80), 1,
      sym_attribute_list,
    STATE(149), 1,
      sym__comment,
    STATE(150), 1,
      aux_sym_param_list_repeat1,
    STATE(168), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(213), 1,
      sym_variable_ident_decl,
    STATE(256), 1,
      sym_param,
  [4680] = 9,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(672), 1,
      sym_ident,
    ACTIONS(675), 1,
      sym_attr_left,
    STATE(80), 1,
      sym_attribute_list,
    STATE(168), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(213), 1,
      sym_variable_ident_decl,
    STATE(293), 1,
      sym_param,
    STATE(150), 2,
      sym__comment,
      aux_sym_param_list_repeat1,
  [4709] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(151), 1,
      sym__comment,
    ACTIONS(678), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4728] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(152), 1,
      sym__comment,
    ACTIONS(680), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4747] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(153), 1,
      sym__comment,
    ACTIONS(682), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4766] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(154), 1,
      sym__comment,
    ACTIONS(684), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4785] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(155), 1,
      sym__comment,
    ACTIONS(686), 7,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_greater_than,
      sym_paren_left,
      sym_paren_right,
      sym_semicolon,
  [4804] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(688), 1,
      sym_and_and,
    STATE(156), 1,
      sym__comment,
    ACTIONS(690), 5,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4824] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(157), 1,
      sym__comment,
    STATE(279), 1,
      sym_storage_class,
    ACTIONS(692), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [4844] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(688), 1,
      sym_and_and,
    STATE(158), 1,
      sym__comment,
    ACTIONS(694), 5,
      sym_bracket_right,
      sym_comma,
      sym_or_or,
      sym_paren_right,
      sym_semicolon,
  [4864] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(159), 1,
      sym__comment,
    STATE(234), 1,
      sym_storage_class,
    ACTIONS(692), 5,
      sym_function,
      sym_private,
      sym_storage,
      sym_uniform,
      sym_workgroup,
  [4884] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(698), 1,
      sym_int_literal,
    STATE(160), 1,
      sym__comment,
    ACTIONS(696), 4,
      sym_decimal_float_literal,
      sym_hex_float_literal,
      sym_uint_literal,
      sym_ident,
  [4903] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(161), 1,
      sym__comment,
    ACTIONS(700), 2,
      sym_paren_right,
      sym_semicolon,
    ACTIONS(457), 3,
      sym_bracket_left,
      sym_equal,
      sym_period,
  [4922] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(702), 1,
      sym_case,
    ACTIONS(705), 1,
      sym_default,
    ACTIONS(708), 1,
      sym_brace_right,
    STATE(201), 1,
      sym_switch_body,
    STATE(162), 2,
      sym__comment,
      aux_sym_switch_statement_repeat1,
  [4945] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(163), 1,
      sym__comment,
    ACTIONS(710), 5,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [4962] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(713), 1,
      sym_case,
    ACTIONS(715), 1,
      sym_default,
    ACTIONS(717), 1,
      sym_brace_right,
    STATE(162), 1,
      aux_sym_switch_statement_repeat1,
    STATE(164), 1,
      sym__comment,
    STATE(201), 1,
      sym_switch_body,
  [4987] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(424), 1,
      sym_paren_left,
    STATE(161), 1,
      sym_argument_expression_list,
    STATE(165), 1,
      sym__comment,
    ACTIONS(422), 3,
      sym_bracket_left,
      sym_equal,
      sym_period,
  [5008] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    STATE(76), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(166), 1,
      sym__comment,
    STATE(277), 1,
      sym_variable_ident_decl,
  [5033] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(167), 1,
      sym__comment,
    ACTIONS(719), 5,
      sym_brace_left,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [5050] = 8,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(599), 1,
      sym_ident,
    STATE(76), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(168), 1,
      sym__comment,
    STATE(252), 1,
      sym_variable_ident_decl,
  [5075] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(722), 1,
      sym_colon,
    ACTIONS(724), 1,
      sym_equal,
    ACTIONS(726), 1,
      sym_semicolon,
    STATE(169), 1,
      sym__comment,
    STATE(280), 1,
      sym_global_const_initializer,
  [5097] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(722), 1,
      sym_colon,
    ACTIONS(724), 1,
      sym_equal,
    ACTIONS(728), 1,
      sym_semicolon,
    STATE(170), 1,
      sym__comment,
    STATE(308), 1,
      sym_global_const_initializer,
  [5119] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(171), 1,
      sym__comment,
    ACTIONS(730), 4,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [5135] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(713), 1,
      sym_case,
    ACTIONS(715), 1,
      sym_default,
    STATE(164), 1,
      aux_sym_switch_statement_repeat1,
    STATE(172), 1,
      sym__comment,
    STATE(201), 1,
      sym_switch_body,
  [5157] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(734), 1,
      sym_int_literal,
    STATE(173), 1,
      sym__comment,
    STATE(286), 1,
      sym_element_count_expression,
    ACTIONS(732), 2,
      sym_uint_literal,
      sym_ident,
  [5177] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(21), 1,
      sym_attr_left,
    ACTIONS(736), 1,
      sym_array,
    STATE(76), 1,
      aux_sym_array_type_decl_repeat1,
    STATE(80), 1,
      sym_attribute_list,
    STATE(174), 1,
      sym__comment,
  [5199] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(738), 1,
      sym_read,
    STATE(175), 1,
      sym__comment,
    STATE(267), 1,
      sym_access_mode,
    ACTIONS(740), 2,
      sym_read_write,
      sym_write,
  [5219] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(738), 1,
      sym_read,
    STATE(176), 1,
      sym__comment,
    STATE(288), 1,
      sym_access_mode,
    ACTIONS(740), 2,
      sym_read_write,
      sym_write,
  [5239] = 7,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(599), 1,
      sym_ident,
    ACTIONS(742), 1,
      sym_less_than,
    STATE(177), 1,
      sym__comment,
    STATE(243), 1,
      sym_variable_ident_decl,
    STATE(247), 1,
      sym_variable_qualifier,
  [5261] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(734), 1,
      sym_int_literal,
    STATE(178), 1,
      sym__comment,
    STATE(320), 1,
      sym_element_count_expression,
    ACTIONS(732), 2,
      sym_uint_literal,
      sym_ident,
  [5281] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(738), 1,
      sym_read,
    STATE(179), 1,
      sym__comment,
    STATE(331), 1,
      sym_access_mode,
    ACTIONS(740), 2,
      sym_read_write,
      sym_write,
  [5301] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(734), 1,
      sym_int_literal,
    STATE(180), 1,
      sym__comment,
    STATE(330), 1,
      sym_element_count_expression,
    ACTIONS(732), 2,
      sym_uint_literal,
      sym_ident,
  [5321] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(181), 1,
      sym__comment,
    ACTIONS(744), 4,
      sym_comma,
      sym_equal,
      sym_paren_right,
      sym_semicolon,
  [5337] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(724), 1,
      sym_equal,
    ACTIONS(726), 1,
      sym_semicolon,
    STATE(182), 1,
      sym__comment,
    STATE(280), 1,
      sym_global_const_initializer,
  [5356] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(746), 1,
      sym_arrow,
    ACTIONS(748), 1,
      sym_brace_left,
    STATE(183), 1,
      sym__comment,
    STATE(312), 1,
      sym_function_return_type_decl_optional,
  [5375] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(184), 1,
      sym__comment,
    ACTIONS(750), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [5390] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(752), 1,
      sym_colon,
    ACTIONS(754), 1,
      sym_comma,
    STATE(185), 1,
      sym__comment,
    STATE(187), 1,
      aux_sym_case_selectors_repeat1,
  [5409] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(186), 1,
      sym__comment,
    ACTIONS(756), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [5424] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(583), 1,
      sym_colon,
    ACTIONS(758), 1,
      sym_comma,
    STATE(187), 1,
      sym__comment,
    STATE(194), 1,
      aux_sym_case_selectors_repeat1,
  [5443] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    STATE(188), 1,
      sym__comment,
    ACTIONS(762), 2,
      sym_paren_right,
      sym_semicolon,
  [5460] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(764), 1,
      sym_ident,
    STATE(189), 1,
      sym__comment,
    STATE(191), 1,
      aux_sym_attribute_list_repeat1,
    STATE(250), 1,
      sym_attribute,
  [5479] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(724), 1,
      sym_equal,
    ACTIONS(728), 1,
      sym_semicolon,
    STATE(190), 1,
      sym__comment,
    STATE(308), 1,
      sym_global_const_initializer,
  [5498] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(764), 1,
      sym_ident,
    STATE(191), 1,
      sym__comment,
    STATE(202), 1,
      aux_sym_attribute_list_repeat1,
    STATE(224), 1,
      sym_attribute,
  [5517] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(192), 1,
      sym__comment,
    ACTIONS(766), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [5532] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(382), 1,
      sym_paren_right,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(768), 1,
      sym_comma,
    STATE(193), 1,
      sym__comment,
  [5551] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(770), 1,
      sym_colon,
    ACTIONS(772), 1,
      sym_comma,
    STATE(194), 2,
      sym__comment,
      aux_sym_case_selectors_repeat1,
  [5568] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(195), 1,
      sym__comment,
    ACTIONS(775), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [5583] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(779), 1,
      sym_paren_right,
    STATE(196), 1,
      sym__comment,
    ACTIONS(777), 2,
      sym_attr_left,
      sym_ident,
  [5600] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(197), 1,
      sym__comment,
    ACTIONS(781), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [5615] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(198), 1,
      sym__comment,
    ACTIONS(783), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [5630] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(787), 1,
      sym_paren_left,
    STATE(199), 1,
      sym__comment,
    ACTIONS(785), 2,
      sym_attr_right,
      sym_comma,
  [5647] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(789), 1,
      sym_paren_right,
    STATE(200), 1,
      sym__comment,
    ACTIONS(777), 2,
      sym_attr_left,
      sym_ident,
  [5664] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(201), 1,
      sym__comment,
    ACTIONS(791), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [5679] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(793), 1,
      sym_ident,
    STATE(334), 1,
      sym_attribute,
    STATE(202), 2,
      sym__comment,
      aux_sym_attribute_list_repeat1,
  [5696] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(203), 1,
      sym__comment,
    ACTIONS(796), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [5711] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(204), 1,
      sym__comment,
    ACTIONS(798), 3,
      sym_attr_left,
      sym_brace_right,
      sym_ident,
  [5726] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(205), 1,
      sym__comment,
    ACTIONS(800), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [5741] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(746), 1,
      sym_arrow,
    ACTIONS(802), 1,
      sym_brace_left,
    STATE(206), 1,
      sym__comment,
    STATE(274), 1,
      sym_function_return_type_decl_optional,
  [5760] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(804), 1,
      sym_comma,
    ACTIONS(806), 1,
      sym_paren_right,
    STATE(207), 1,
      sym__comment,
  [5779] = 6,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(808), 1,
      sym_continuing,
    ACTIONS(810), 1,
      sym_brace_right,
    STATE(208), 1,
      sym__comment,
    STATE(309), 1,
      sym_continuing_statement,
  [5798] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(209), 1,
      sym__comment,
    ACTIONS(812), 3,
      sym_comma,
      sym_paren_right,
      sym_semicolon,
  [5813] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(210), 1,
      sym__comment,
    ACTIONS(814), 3,
      sym_case,
      sym_default,
      sym_brace_right,
  [5828] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(211), 1,
      sym__comment,
    ACTIONS(816), 2,
      sym_equal,
      sym_semicolon,
  [5842] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(212), 1,
      sym__comment,
    ACTIONS(777), 2,
      sym_attr_left,
      sym_ident,
  [5856] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(213), 1,
      sym__comment,
    ACTIONS(818), 2,
      sym_comma,
      sym_paren_right,
  [5870] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(820), 1,
      sym_comma,
    ACTIONS(822), 1,
      sym_paren_right,
    STATE(214), 1,
      sym__comment,
  [5886] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(824), 1,
      sym_ident,
    STATE(190), 1,
      sym_variable_ident_decl,
    STATE(215), 1,
      sym__comment,
  [5902] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(826), 1,
      sym_brace_left,
    STATE(216), 1,
      sym__comment,
    STATE(266), 1,
      sym_compound_statement,
  [5918] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(217), 1,
      sym__comment,
    ACTIONS(828), 2,
      sym_comma,
      sym_paren_right,
  [5932] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(830), 1,
      sym_comma,
    ACTIONS(832), 1,
      sym_paren_right,
    STATE(218), 1,
      sym__comment,
  [5948] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(219), 1,
      sym__comment,
    ACTIONS(770), 2,
      sym_colon,
      sym_comma,
  [5962] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(834), 1,
      sym_brace_left,
    STATE(220), 1,
      sym__comment,
    STATE(289), 1,
      sym_struct_body_decl,
  [5978] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(77), 1,
      sym_brace_left,
    STATE(30), 1,
      sym_compound_statement,
    STATE(221), 1,
      sym__comment,
  [5994] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(722), 1,
      sym_colon,
    ACTIONS(836), 1,
      sym_equal,
    STATE(222), 1,
      sym__comment,
  [6010] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(838), 1,
      sym_equal,
    ACTIONS(840), 1,
      sym_semicolon,
    STATE(223), 1,
      sym__comment,
  [6026] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(842), 1,
      sym_attr_right,
    ACTIONS(844), 1,
      sym_comma,
    STATE(224), 1,
      sym__comment,
  [6042] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(826), 1,
      sym_brace_left,
    STATE(117), 1,
      sym_compound_statement,
    STATE(225), 1,
      sym__comment,
  [6058] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(846), 1,
      sym_semicolon,
    STATE(226), 1,
      sym__comment,
  [6074] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(848), 1,
      sym_bracket_right,
    STATE(227), 1,
      sym__comment,
  [6090] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(850), 1,
      sym_equal,
    ACTIONS(852), 1,
      sym_semicolon,
    STATE(228), 1,
      sym__comment,
  [6106] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(854), 1,
      sym_paren_left,
    STATE(90), 1,
      sym_argument_expression_list,
    STATE(229), 1,
      sym__comment,
  [6122] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(856), 1,
      sym_semicolon,
    STATE(230), 1,
      sym__comment,
  [6138] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(858), 1,
      sym_paren_right,
    STATE(231), 1,
      sym__comment,
  [6154] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(83), 1,
      sym_paren_left,
    STATE(232), 1,
      sym__comment,
    STATE(313), 1,
      sym_paren_expression,
  [6170] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(860), 1,
      sym_comma,
    STATE(233), 1,
      sym__comment,
  [6186] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(862), 1,
      sym_comma,
    ACTIONS(864), 1,
      sym_greater_than,
    STATE(234), 1,
      sym__comment,
  [6202] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(834), 1,
      sym_brace_left,
    STATE(235), 1,
      sym__comment,
    STATE(272), 1,
      sym_struct_body_decl,
  [6218] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(236), 1,
      sym__comment,
    ACTIONS(866), 2,
      sym_attr_right,
      sym_comma,
  [6232] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(868), 1,
      sym_ident,
    STATE(237), 1,
      sym__comment,
    STATE(318), 1,
      sym_variable_ident_decl,
  [6248] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(83), 1,
      sym_paren_left,
    STATE(221), 1,
      sym_paren_expression,
    STATE(238), 1,
      sym__comment,
  [6264] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(77), 1,
      sym_brace_left,
    STATE(33), 1,
      sym_compound_statement,
    STATE(239), 1,
      sym__comment,
  [6280] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(870), 1,
      sym_semicolon,
    STATE(240), 1,
      sym__comment,
  [6296] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(241), 1,
      sym__comment,
    ACTIONS(872), 2,
      sym_comma,
      sym_greater_than,
  [6310] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(874), 1,
      sym_comma,
    ACTIONS(876), 1,
      sym_paren_right,
    STATE(242), 1,
      sym__comment,
  [6326] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(243), 1,
      sym__comment,
    ACTIONS(878), 2,
      sym_equal,
      sym_semicolon,
  [6340] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(880), 1,
      sym_comma,
    ACTIONS(882), 1,
      sym_greater_than,
    STATE(244), 1,
      sym__comment,
  [6356] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(884), 1,
      sym_comma,
    ACTIONS(886), 1,
      sym_greater_than,
    STATE(245), 1,
      sym__comment,
  [6372] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(394), 1,
      sym_paren_right,
    ACTIONS(888), 1,
      sym_comma,
    STATE(246), 1,
      sym__comment,
  [6388] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(599), 1,
      sym_ident,
    STATE(211), 1,
      sym_variable_ident_decl,
    STATE(247), 1,
      sym__comment,
  [6404] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(890), 1,
      sym_comma,
    ACTIONS(892), 1,
      sym_greater_than,
    STATE(248), 1,
      sym__comment,
  [6420] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(83), 1,
      sym_paren_left,
    STATE(95), 1,
      sym_paren_expression,
    STATE(249), 1,
      sym__comment,
  [6436] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(844), 1,
      sym_comma,
    ACTIONS(894), 1,
      sym_attr_right,
    STATE(250), 1,
      sym__comment,
  [6452] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(205), 1,
      sym_semicolon,
    ACTIONS(760), 1,
      sym_or_or,
    STATE(251), 1,
      sym__comment,
  [6468] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(252), 1,
      sym__comment,
    ACTIONS(896), 2,
      sym_comma,
      sym_paren_right,
  [6482] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(77), 1,
      sym_brace_left,
    STATE(47), 1,
      sym_compound_statement,
    STATE(253), 1,
      sym__comment,
  [6498] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(77), 1,
      sym_brace_left,
    STATE(46), 1,
      sym_compound_statement,
    STATE(254), 1,
      sym__comment,
  [6514] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(83), 1,
      sym_paren_left,
    STATE(239), 1,
      sym_paren_expression,
    STATE(255), 1,
      sym__comment,
  [6530] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(779), 1,
      sym_paren_right,
    ACTIONS(898), 1,
      sym_comma,
    STATE(256), 1,
      sym__comment,
  [6546] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(826), 1,
      sym_brace_left,
    STATE(129), 1,
      sym_compound_statement,
    STATE(257), 1,
      sym__comment,
  [6562] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(760), 1,
      sym_or_or,
    ACTIONS(900), 1,
      sym_semicolon,
    STATE(258), 1,
      sym__comment,
  [6578] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    STATE(259), 1,
      sym__comment,
    ACTIONS(902), 2,
      sym_attr_right,
      sym_comma,
  [6592] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(904), 1,
      sym_equal,
    ACTIONS(906), 1,
      sym_semicolon,
    STATE(260), 1,
      sym__comment,
  [6608] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(830), 1,
      sym_comma,
    ACTIONS(908), 1,
      sym_paren_right,
    STATE(261), 1,
      sym__comment,
  [6624] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(910), 1,
      sym_ident,
    STATE(182), 1,
      sym_variable_ident_decl,
    STATE(262), 1,
      sym__comment,
  [6640] = 5,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(912), 1,
      sym_comma,
    ACTIONS(914), 1,
      sym_greater_than,
    STATE(263), 1,
      sym__comment,
  [6656] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(916), 1,
      sym_ident,
    STATE(264), 1,
      sym__comment,
  [6669] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(830), 1,
      sym_comma,
    STATE(265), 1,
      sym__comment,
  [6682] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(918), 1,
      sym_brace_right,
    STATE(266), 1,
      sym__comment,
  [6695] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(920), 1,
      sym_greater_than,
    STATE(267), 1,
      sym__comment,
  [6708] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(922), 1,
      sym_greater_than,
    STATE(268), 1,
      sym__comment,
  [6721] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(924), 1,
      sym_less_than,
    STATE(269), 1,
      sym__comment,
  [6734] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(926), 1,
      sym_less_than,
    STATE(270), 1,
      sym__comment,
  [6747] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(928), 1,
      sym_greater_than,
    STATE(271), 1,
      sym__comment,
  [6760] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(930), 1,
      sym_semicolon,
    STATE(272), 1,
      sym__comment,
  [6773] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(932), 1,
      sym_colon,
    STATE(273), 1,
      sym__comment,
  [6786] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(748), 1,
      sym_brace_left,
    STATE(274), 1,
      sym__comment,
  [6799] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(934), 1,
      sym_semicolon,
    STATE(275), 1,
      sym__comment,
  [6812] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(936), 1,
      sym_semicolon,
    STATE(276), 1,
      sym__comment,
  [6825] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(938), 1,
      sym_semicolon,
    STATE(277), 1,
      sym__comment,
  [6838] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(940), 1,
      sym_semicolon,
    STATE(278), 1,
      sym__comment,
  [6851] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(942), 1,
      sym_comma,
    STATE(279), 1,
      sym__comment,
  [6864] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(944), 1,
      sym_semicolon,
    STATE(280), 1,
      sym__comment,
  [6877] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(946), 1,
      sym_greater_than,
    STATE(281), 1,
      sym__comment,
  [6890] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(948), 1,
      sym_brace_left,
    STATE(282), 1,
      sym__comment,
  [6903] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(950), 1,
      sym_semicolon,
    STATE(283), 1,
      sym__comment,
  [6916] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(952), 1,
      sym_comma,
    STATE(284), 1,
      sym__comment,
  [6929] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(954), 1,
      sym_greater_than,
    STATE(285), 1,
      sym__comment,
  [6942] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(956), 1,
      sym_greater_than,
    STATE(286), 1,
      sym__comment,
  [6955] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(958), 1,
      sym_ident,
    STATE(287), 1,
      sym__comment,
  [6968] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(960), 1,
      sym_greater_than,
    STATE(288), 1,
      sym__comment,
  [6981] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(962), 1,
      sym_semicolon,
    STATE(289), 1,
      sym__comment,
  [6994] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(964), 1,
      sym_comma,
    STATE(290), 1,
      sym__comment,
  [7007] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(966), 1,
      sym_comma,
    STATE(291), 1,
      sym__comment,
  [7020] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(968), 1,
      sym_semicolon,
    STATE(292), 1,
      sym__comment,
  [7033] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(970), 1,
      sym_comma,
    STATE(293), 1,
      sym__comment,
  [7046] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(722), 1,
      sym_colon,
    STATE(294), 1,
      sym__comment,
  [7059] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(263), 1,
      sym_paren_right,
    STATE(295), 1,
      sym__comment,
  [7072] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(972), 1,
      sym_paren_left,
    STATE(296), 1,
      sym__comment,
  [7085] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(974), 1,
      sym_semicolon,
    STATE(297), 1,
      sym__comment,
  [7098] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(976), 1,
      sym_equal,
    STATE(298), 1,
      sym__comment,
  [7111] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(978), 1,
      sym_ident,
    STATE(299), 1,
      sym__comment,
  [7124] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(980), 1,
      sym_greater_than,
    STATE(300), 1,
      sym__comment,
  [7137] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(982), 1,
      sym_paren_left,
    STATE(301), 1,
      sym__comment,
  [7150] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(984), 1,
      sym_paren_left,
    STATE(302), 1,
      sym__comment,
  [7163] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(986), 1,
      sym_brace_right,
    STATE(303), 1,
      sym__comment,
  [7176] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(988), 1,
      sym_colon,
    STATE(304), 1,
      sym__comment,
  [7189] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(990), 1,
      sym_brace_left,
    STATE(305), 1,
      sym__comment,
  [7202] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(992), 1,
      sym_semicolon,
    STATE(306), 1,
      sym__comment,
  [7215] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(994), 1,
      sym_brace_left,
    STATE(307), 1,
      sym__comment,
  [7228] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(726), 1,
      sym_semicolon,
    STATE(308), 1,
      sym__comment,
  [7241] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(996), 1,
      sym_brace_right,
    STATE(309), 1,
      sym__comment,
  [7254] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(998), 1,
      sym_semicolon,
    STATE(310), 1,
      sym__comment,
  [7267] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1000), 1,
      sym_semicolon,
    STATE(311), 1,
      sym__comment,
  [7280] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1002), 1,
      sym_brace_left,
    STATE(312), 1,
      sym__comment,
  [7293] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1004), 1,
      sym_brace_left,
    STATE(313), 1,
      sym__comment,
  [7306] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1006), 1,
      sym_semicolon,
    STATE(314), 1,
      sym__comment,
  [7319] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1008), 1,
      sym_brace_left,
    STATE(315), 1,
      sym__comment,
  [7332] = 4,
    ACTIONS(1010), 1,
      aux_sym__comment_token1,
    ACTIONS(1012), 1,
      aux_sym__comment_token2,
    ACTIONS(1014), 1,
      sym__space,
    STATE(316), 1,
      sym__comment,
  [7345] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1016), 1,
      sym_equal,
    STATE(317), 1,
      sym__comment,
  [7358] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(836), 1,
      sym_equal,
    STATE(318), 1,
      sym__comment,
  [7371] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1018), 1,
      sym_ident,
    STATE(319), 1,
      sym__comment,
  [7384] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1020), 1,
      sym_greater_than,
    STATE(320), 1,
      sym__comment,
  [7397] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(273), 1,
      sym_paren_right,
    STATE(321), 1,
      sym__comment,
  [7410] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1022), 1,
      sym_less_than,
    STATE(322), 1,
      sym__comment,
  [7423] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1024), 1,
      sym_semicolon,
    STATE(323), 1,
      sym__comment,
  [7436] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1026), 1,
      sym_less_than,
    STATE(324), 1,
      sym__comment,
  [7449] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1028), 1,
      sym_less_than,
    STATE(325), 1,
      sym__comment,
  [7462] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1030), 1,
      sym_brace_left,
    STATE(326), 1,
      sym__comment,
  [7475] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1032), 1,
      ts_builtin_sym_end,
    STATE(327), 1,
      sym__comment,
  [7488] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1034), 1,
      sym_brace_right,
    STATE(328), 1,
      sym__comment,
  [7501] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1036), 1,
      sym_less_than,
    STATE(329), 1,
      sym__comment,
  [7514] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1038), 1,
      sym_greater_than,
    STATE(330), 1,
      sym__comment,
  [7527] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1040), 1,
      sym_greater_than,
    STATE(331), 1,
      sym__comment,
  [7540] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1042), 1,
      sym_less_than,
    STATE(332), 1,
      sym__comment,
  [7553] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1044), 1,
      sym_paren_right,
    STATE(333), 1,
      sym__comment,
  [7566] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(844), 1,
      sym_comma,
    STATE(334), 1,
      sym__comment,
  [7579] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1046), 1,
      sym_less_than,
    STATE(335), 1,
      sym__comment,
  [7592] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1048), 1,
      sym_less_than,
    STATE(336), 1,
      sym__comment,
  [7605] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(810), 1,
      sym_brace_right,
    STATE(337), 1,
      sym__comment,
  [7618] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1050), 1,
      sym_ident,
    STATE(338), 1,
      sym__comment,
  [7631] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1052), 1,
      sym_semicolon,
    STATE(339), 1,
      sym__comment,
  [7644] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1054), 1,
      sym_ident,
    STATE(340), 1,
      sym__comment,
  [7657] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(97), 1,
      sym_brace_right,
    STATE(341), 1,
      sym__comment,
  [7670] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1056), 1,
      sym_less_than,
    STATE(342), 1,
      sym__comment,
  [7683] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1058), 1,
      sym_semicolon,
    STATE(343), 1,
      sym__comment,
  [7696] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1060), 1,
      sym_semicolon,
    STATE(344), 1,
      sym__comment,
  [7709] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1062), 1,
      sym_less_than,
    STATE(345), 1,
      sym__comment,
  [7722] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1064), 1,
      sym_paren_right,
    STATE(346), 1,
      sym__comment,
  [7735] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1066), 1,
      sym_brace_right,
    STATE(347), 1,
      sym__comment,
  [7748] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1068), 1,
      sym_brace_right,
    STATE(348), 1,
      sym__comment,
  [7761] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1070), 1,
      sym_paren_right,
    STATE(349), 1,
      sym__comment,
  [7774] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1072), 1,
      sym_ident,
    STATE(350), 1,
      sym__comment,
  [7787] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1074), 1,
      sym_ident,
    STATE(351), 1,
      sym__comment,
  [7800] = 4,
    ACTIONS(3), 1,
      aux_sym__comment_token1,
    ACTIONS(5), 1,
      sym__space,
    ACTIONS(1076), 1,
      sym_ident,
    STATE(352), 1,
      sym__comment,
  [7813] = 1,
    ACTIONS(1078), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(53)] = 0,
  [SMALL_STATE(54)] = 120,
  [SMALL_STATE(55)] = 237,
  [SMALL_STATE(56)] = 352,
  [SMALL_STATE(57)] = 466,
  [SMALL_STATE(58)] = 580,
  [SMALL_STATE(59)] = 694,
  [SMALL_STATE(60)] = 763,
  [SMALL_STATE(61)] = 832,
  [SMALL_STATE(62)] = 898,
  [SMALL_STATE(63)] = 991,
  [SMALL_STATE(64)] = 1084,
  [SMALL_STATE(65)] = 1177,
  [SMALL_STATE(66)] = 1270,
  [SMALL_STATE(67)] = 1363,
  [SMALL_STATE(68)] = 1456,
  [SMALL_STATE(69)] = 1549,
  [SMALL_STATE(70)] = 1642,
  [SMALL_STATE(71)] = 1735,
  [SMALL_STATE(72)] = 1828,
  [SMALL_STATE(73)] = 1921,
  [SMALL_STATE(74)] = 2014,
  [SMALL_STATE(75)] = 2076,
  [SMALL_STATE(76)] = 2138,
  [SMALL_STATE(77)] = 2199,
  [SMALL_STATE(78)] = 2258,
  [SMALL_STATE(79)] = 2315,
  [SMALL_STATE(80)] = 2372,
  [SMALL_STATE(81)] = 2429,
  [SMALL_STATE(82)] = 2490,
  [SMALL_STATE(83)] = 2542,
  [SMALL_STATE(84)] = 2587,
  [SMALL_STATE(85)] = 2633,
  [SMALL_STATE(86)] = 2673,
  [SMALL_STATE(87)] = 2713,
  [SMALL_STATE(88)] = 2753,
  [SMALL_STATE(89)] = 2799,
  [SMALL_STATE(90)] = 2845,
  [SMALL_STATE(91)] = 2884,
  [SMALL_STATE(92)] = 2923,
  [SMALL_STATE(93)] = 2962,
  [SMALL_STATE(94)] = 3001,
  [SMALL_STATE(95)] = 3040,
  [SMALL_STATE(96)] = 3079,
  [SMALL_STATE(97)] = 3118,
  [SMALL_STATE(98)] = 3155,
  [SMALL_STATE(99)] = 3192,
  [SMALL_STATE(100)] = 3229,
  [SMALL_STATE(101)] = 3266,
  [SMALL_STATE(102)] = 3303,
  [SMALL_STATE(103)] = 3343,
  [SMALL_STATE(104)] = 3379,
  [SMALL_STATE(105)] = 3415,
  [SMALL_STATE(106)] = 3455,
  [SMALL_STATE(107)] = 3515,
  [SMALL_STATE(108)] = 3577,
  [SMALL_STATE(109)] = 3612,
  [SMALL_STATE(110)] = 3647,
  [SMALL_STATE(111)] = 3680,
  [SMALL_STATE(112)] = 3713,
  [SMALL_STATE(113)] = 3748,
  [SMALL_STATE(114)] = 3779,
  [SMALL_STATE(115)] = 3801,
  [SMALL_STATE(116)] = 3823,
  [SMALL_STATE(117)] = 3846,
  [SMALL_STATE(118)] = 3867,
  [SMALL_STATE(119)] = 3898,
  [SMALL_STATE(120)] = 3929,
  [SMALL_STATE(121)] = 3950,
  [SMALL_STATE(122)] = 3973,
  [SMALL_STATE(123)] = 3998,
  [SMALL_STATE(124)] = 4035,
  [SMALL_STATE(125)] = 4072,
  [SMALL_STATE(126)] = 4103,
  [SMALL_STATE(127)] = 4124,
  [SMALL_STATE(128)] = 4145,
  [SMALL_STATE(129)] = 4170,
  [SMALL_STATE(130)] = 4191,
  [SMALL_STATE(131)] = 4221,
  [SMALL_STATE(132)] = 4245,
  [SMALL_STATE(133)] = 4279,
  [SMALL_STATE(134)] = 4307,
  [SMALL_STATE(135)] = 4337,
  [SMALL_STATE(136)] = 4369,
  [SMALL_STATE(137)] = 4397,
  [SMALL_STATE(138)] = 4421,
  [SMALL_STATE(139)] = 4455,
  [SMALL_STATE(140)] = 4474,
  [SMALL_STATE(141)] = 4493,
  [SMALL_STATE(142)] = 4512,
  [SMALL_STATE(143)] = 4531,
  [SMALL_STATE(144)] = 4552,
  [SMALL_STATE(145)] = 4571,
  [SMALL_STATE(146)] = 4590,
  [SMALL_STATE(147)] = 4609,
  [SMALL_STATE(148)] = 4628,
  [SMALL_STATE(149)] = 4649,
  [SMALL_STATE(150)] = 4680,
  [SMALL_STATE(151)] = 4709,
  [SMALL_STATE(152)] = 4728,
  [SMALL_STATE(153)] = 4747,
  [SMALL_STATE(154)] = 4766,
  [SMALL_STATE(155)] = 4785,
  [SMALL_STATE(156)] = 4804,
  [SMALL_STATE(157)] = 4824,
  [SMALL_STATE(158)] = 4844,
  [SMALL_STATE(159)] = 4864,
  [SMALL_STATE(160)] = 4884,
  [SMALL_STATE(161)] = 4903,
  [SMALL_STATE(162)] = 4922,
  [SMALL_STATE(163)] = 4945,
  [SMALL_STATE(164)] = 4962,
  [SMALL_STATE(165)] = 4987,
  [SMALL_STATE(166)] = 5008,
  [SMALL_STATE(167)] = 5033,
  [SMALL_STATE(168)] = 5050,
  [SMALL_STATE(169)] = 5075,
  [SMALL_STATE(170)] = 5097,
  [SMALL_STATE(171)] = 5119,
  [SMALL_STATE(172)] = 5135,
  [SMALL_STATE(173)] = 5157,
  [SMALL_STATE(174)] = 5177,
  [SMALL_STATE(175)] = 5199,
  [SMALL_STATE(176)] = 5219,
  [SMALL_STATE(177)] = 5239,
  [SMALL_STATE(178)] = 5261,
  [SMALL_STATE(179)] = 5281,
  [SMALL_STATE(180)] = 5301,
  [SMALL_STATE(181)] = 5321,
  [SMALL_STATE(182)] = 5337,
  [SMALL_STATE(183)] = 5356,
  [SMALL_STATE(184)] = 5375,
  [SMALL_STATE(185)] = 5390,
  [SMALL_STATE(186)] = 5409,
  [SMALL_STATE(187)] = 5424,
  [SMALL_STATE(188)] = 5443,
  [SMALL_STATE(189)] = 5460,
  [SMALL_STATE(190)] = 5479,
  [SMALL_STATE(191)] = 5498,
  [SMALL_STATE(192)] = 5517,
  [SMALL_STATE(193)] = 5532,
  [SMALL_STATE(194)] = 5551,
  [SMALL_STATE(195)] = 5568,
  [SMALL_STATE(196)] = 5583,
  [SMALL_STATE(197)] = 5600,
  [SMALL_STATE(198)] = 5615,
  [SMALL_STATE(199)] = 5630,
  [SMALL_STATE(200)] = 5647,
  [SMALL_STATE(201)] = 5664,
  [SMALL_STATE(202)] = 5679,
  [SMALL_STATE(203)] = 5696,
  [SMALL_STATE(204)] = 5711,
  [SMALL_STATE(205)] = 5726,
  [SMALL_STATE(206)] = 5741,
  [SMALL_STATE(207)] = 5760,
  [SMALL_STATE(208)] = 5779,
  [SMALL_STATE(209)] = 5798,
  [SMALL_STATE(210)] = 5813,
  [SMALL_STATE(211)] = 5828,
  [SMALL_STATE(212)] = 5842,
  [SMALL_STATE(213)] = 5856,
  [SMALL_STATE(214)] = 5870,
  [SMALL_STATE(215)] = 5886,
  [SMALL_STATE(216)] = 5902,
  [SMALL_STATE(217)] = 5918,
  [SMALL_STATE(218)] = 5932,
  [SMALL_STATE(219)] = 5948,
  [SMALL_STATE(220)] = 5962,
  [SMALL_STATE(221)] = 5978,
  [SMALL_STATE(222)] = 5994,
  [SMALL_STATE(223)] = 6010,
  [SMALL_STATE(224)] = 6026,
  [SMALL_STATE(225)] = 6042,
  [SMALL_STATE(226)] = 6058,
  [SMALL_STATE(227)] = 6074,
  [SMALL_STATE(228)] = 6090,
  [SMALL_STATE(229)] = 6106,
  [SMALL_STATE(230)] = 6122,
  [SMALL_STATE(231)] = 6138,
  [SMALL_STATE(232)] = 6154,
  [SMALL_STATE(233)] = 6170,
  [SMALL_STATE(234)] = 6186,
  [SMALL_STATE(235)] = 6202,
  [SMALL_STATE(236)] = 6218,
  [SMALL_STATE(237)] = 6232,
  [SMALL_STATE(238)] = 6248,
  [SMALL_STATE(239)] = 6264,
  [SMALL_STATE(240)] = 6280,
  [SMALL_STATE(241)] = 6296,
  [SMALL_STATE(242)] = 6310,
  [SMALL_STATE(243)] = 6326,
  [SMALL_STATE(244)] = 6340,
  [SMALL_STATE(245)] = 6356,
  [SMALL_STATE(246)] = 6372,
  [SMALL_STATE(247)] = 6388,
  [SMALL_STATE(248)] = 6404,
  [SMALL_STATE(249)] = 6420,
  [SMALL_STATE(250)] = 6436,
  [SMALL_STATE(251)] = 6452,
  [SMALL_STATE(252)] = 6468,
  [SMALL_STATE(253)] = 6482,
  [SMALL_STATE(254)] = 6498,
  [SMALL_STATE(255)] = 6514,
  [SMALL_STATE(256)] = 6530,
  [SMALL_STATE(257)] = 6546,
  [SMALL_STATE(258)] = 6562,
  [SMALL_STATE(259)] = 6578,
  [SMALL_STATE(260)] = 6592,
  [SMALL_STATE(261)] = 6608,
  [SMALL_STATE(262)] = 6624,
  [SMALL_STATE(263)] = 6640,
  [SMALL_STATE(264)] = 6656,
  [SMALL_STATE(265)] = 6669,
  [SMALL_STATE(266)] = 6682,
  [SMALL_STATE(267)] = 6695,
  [SMALL_STATE(268)] = 6708,
  [SMALL_STATE(269)] = 6721,
  [SMALL_STATE(270)] = 6734,
  [SMALL_STATE(271)] = 6747,
  [SMALL_STATE(272)] = 6760,
  [SMALL_STATE(273)] = 6773,
  [SMALL_STATE(274)] = 6786,
  [SMALL_STATE(275)] = 6799,
  [SMALL_STATE(276)] = 6812,
  [SMALL_STATE(277)] = 6825,
  [SMALL_STATE(278)] = 6838,
  [SMALL_STATE(279)] = 6851,
  [SMALL_STATE(280)] = 6864,
  [SMALL_STATE(281)] = 6877,
  [SMALL_STATE(282)] = 6890,
  [SMALL_STATE(283)] = 6903,
  [SMALL_STATE(284)] = 6916,
  [SMALL_STATE(285)] = 6929,
  [SMALL_STATE(286)] = 6942,
  [SMALL_STATE(287)] = 6955,
  [SMALL_STATE(288)] = 6968,
  [SMALL_STATE(289)] = 6981,
  [SMALL_STATE(290)] = 6994,
  [SMALL_STATE(291)] = 7007,
  [SMALL_STATE(292)] = 7020,
  [SMALL_STATE(293)] = 7033,
  [SMALL_STATE(294)] = 7046,
  [SMALL_STATE(295)] = 7059,
  [SMALL_STATE(296)] = 7072,
  [SMALL_STATE(297)] = 7085,
  [SMALL_STATE(298)] = 7098,
  [SMALL_STATE(299)] = 7111,
  [SMALL_STATE(300)] = 7124,
  [SMALL_STATE(301)] = 7137,
  [SMALL_STATE(302)] = 7150,
  [SMALL_STATE(303)] = 7163,
  [SMALL_STATE(304)] = 7176,
  [SMALL_STATE(305)] = 7189,
  [SMALL_STATE(306)] = 7202,
  [SMALL_STATE(307)] = 7215,
  [SMALL_STATE(308)] = 7228,
  [SMALL_STATE(309)] = 7241,
  [SMALL_STATE(310)] = 7254,
  [SMALL_STATE(311)] = 7267,
  [SMALL_STATE(312)] = 7280,
  [SMALL_STATE(313)] = 7293,
  [SMALL_STATE(314)] = 7306,
  [SMALL_STATE(315)] = 7319,
  [SMALL_STATE(316)] = 7332,
  [SMALL_STATE(317)] = 7345,
  [SMALL_STATE(318)] = 7358,
  [SMALL_STATE(319)] = 7371,
  [SMALL_STATE(320)] = 7384,
  [SMALL_STATE(321)] = 7397,
  [SMALL_STATE(322)] = 7410,
  [SMALL_STATE(323)] = 7423,
  [SMALL_STATE(324)] = 7436,
  [SMALL_STATE(325)] = 7449,
  [SMALL_STATE(326)] = 7462,
  [SMALL_STATE(327)] = 7475,
  [SMALL_STATE(328)] = 7488,
  [SMALL_STATE(329)] = 7501,
  [SMALL_STATE(330)] = 7514,
  [SMALL_STATE(331)] = 7527,
  [SMALL_STATE(332)] = 7540,
  [SMALL_STATE(333)] = 7553,
  [SMALL_STATE(334)] = 7566,
  [SMALL_STATE(335)] = 7579,
  [SMALL_STATE(336)] = 7592,
  [SMALL_STATE(337)] = 7605,
  [SMALL_STATE(338)] = 7618,
  [SMALL_STATE(339)] = 7631,
  [SMALL_STATE(340)] = 7644,
  [SMALL_STATE(341)] = 7657,
  [SMALL_STATE(342)] = 7670,
  [SMALL_STATE(343)] = 7683,
  [SMALL_STATE(344)] = 7696,
  [SMALL_STATE(345)] = 7709,
  [SMALL_STATE(346)] = 7722,
  [SMALL_STATE(347)] = 7735,
  [SMALL_STATE(348)] = 7748,
  [SMALL_STATE(349)] = 7761,
  [SMALL_STATE(350)] = 7774,
  [SMALL_STATE(351)] = 7787,
  [SMALL_STATE(352)] = 7800,
  [SMALL_STATE(353)] = 7813,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 1),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statements, 1),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statements, 1),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(165),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(86),
  [109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(85),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(85),
  [115] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(322),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(324),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(145),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(325),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(139),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(329),
  [133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(335),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(336),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(147),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(269),
  [145] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(275),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(292),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2),
  [153] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(310),
  [156] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(296),
  [159] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(238),
  [162] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(237),
  [165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(307),
  [168] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(13),
  [171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(232),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(177),
  [177] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(41),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(189),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(4),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2),
  [188] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(41),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(16),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 2), SHIFT_REPEAT(49),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [207] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(83),
  [210] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(86),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(85),
  [216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(85),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(322),
  [222] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(324),
  [225] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(145),
  [228] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(325),
  [231] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(139),
  [234] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(329),
  [237] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(335),
  [240] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(336),
  [243] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(147),
  [246] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(269),
  [249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(41),
  [252] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(189),
  [255] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(41),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2), SHIFT_REPEAT(16),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 2),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 3),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 3),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 3),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 2),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 2),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 4),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 4),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 5),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 5),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 3),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 3),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 5),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_statement, 5),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 2),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 4),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 4),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statements_repeat1, 1),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statements_repeat1, 1),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [339] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(145),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(86),
  [345] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(85),
  [348] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(85),
  [351] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(322),
  [354] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(324),
  [357] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(325),
  [360] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(139),
  [363] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(329),
  [366] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(335),
  [369] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(336),
  [372] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(147),
  [375] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2), SHIFT_REPEAT(189),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_expression_list_repeat1, 2),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_const_expression_repeat1, 2),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 2),
  [398] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_type_decl_repeat1, 2), SHIFT_REPEAT(189),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 3),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 3),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_list, 4),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_list, 4),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 1),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_type_decl_repeat1, 1),
  [413] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_type_decl_repeat1, 2), SHIFT(332),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [420] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 1),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 1),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_type_decl, 1), SHIFT(10),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 3),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 3),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_literal, 1),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_literal, 1),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_literal, 1),
  [441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_literal, 1),
  [443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expression, 3),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expression, 3),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 2),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 2),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 1),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 1),
  [455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 2),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 2),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 5),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 5),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 2),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 2),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 4),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 4),
  [471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 5),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 5),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_expression_list, 3),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_expression_list, 3),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 1),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 1),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_singular_expression, 2),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_singular_expression, 2),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_postfix_expression, 4),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_postfix_expression, 4),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 3),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 3),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 3),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 3),
  [507] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 1),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 1),
  [511] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 1),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 1),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2),
  [517] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(352),
  [520] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(351),
  [523] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(350),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(215),
  [529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(338),
  [532] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(177),
  [535] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(189),
  [538] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2), SHIFT_REPEAT(127),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 1),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 3),
  [545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 3),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shift_expression, 1),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shift_expression, 1),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_relational_expression, 1),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 1),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [559] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_relational_expression, 3),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 3),
  [563] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_expression, 1),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_expression, 1),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_expression, 3),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_expression, 3),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_and_expression, 3),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_and_expression, 3),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 2),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 2),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_and_expression, 1),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_and_expression, 1),
  [589] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclusive_or_expression, 3),
  [593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclusive_or_expression, 3),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 3),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enable_directive, 3),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 1),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclusive_or_expression, 1),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclusive_or_expression, 1),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 3),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [617] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inclusive_or_expression, 1),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inclusive_or_expression, 1),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [627] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(217),
  [630] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(86),
  [633] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(217),
  [636] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(294),
  [639] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2), SHIFT_REPEAT(189),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 2),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inclusive_or_expression, 3),
  [646] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inclusive_or_expression, 3),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampler_type, 1),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 1),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 6),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 6),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 3),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 8),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 1),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 6),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_depth_texture_type, 1),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_and_expression, 1),
  [672] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(294),
  [675] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2), SHIFT_REPEAT(189),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 4),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 7),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texture_sampler_types, 4),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_decl, 4),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_type_decl, 5),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 3),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_short_circuit_or_expression, 1),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_call_statement, 2),
  [702] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(118),
  [705] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2), SHIFT_REPEAT(273),
  [708] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 2),
  [710] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_array_type_decl, 6), REDUCE(sym_array_type_decl, 7),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [719] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_array_type_decl, 4), REDUCE(sym_array_type_decl, 5),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 3),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 2),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ident_decl, 3),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [734] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [738] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ident_decl, 4),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_decl_repeat1, 1),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selectors, 1),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 6),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 4),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_selectors_repeat1, 2), SHIFT_REPEAT(136),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 3),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 2),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 2),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 4),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 3),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_statement_repeat1, 1),
  [793] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2), SHIFT_REPEAT(199),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 5),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 5),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 4),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_expression, 1),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 6),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 3),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 1),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 1),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal_or_ident, 1),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 1),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 3),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 1),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 5),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_class, 1),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 2),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [882] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [884] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [886] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [888] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [890] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [892] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [894] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 2),
  [898] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_statement, 4),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 2),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 5),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continuing_statement, 2),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_access_mode, 1),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 3),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_statement, 1),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 3),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [940] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 4),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_constant_decl, 4),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_return_type_decl_optional, 3),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [952] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_texel_format, 1),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_count_expression, 1),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 4),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continue_statement, 1),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 3),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body_decl, 2),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_return_type_decl_optional, 2),
  [1010] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [1012] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [1014] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_list_repeat1, 2),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1032] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sampled_texture_type, 1),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 5),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multisampled_texture_type, 1),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_storage_texture_type, 1),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_qualifier, 3),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 4),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_const_initializer, 2),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_body, 2),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wgsl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_ident,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
