#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5139
#define LARGE_STATE_COUNT 3226
#define SYMBOL_COUNT 653
#define ALIAS_COUNT 6
#define TOKEN_COUNT 361
#define EXTERNAL_TOKEN_COUNT 17
#define FIELD_COUNT 24
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 61

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_LPAREN_STAR = 3,
  anon_sym_STAR_RPAREN = 4,
  aux_sym_block_comment_text_token1 = 5,
  aux_sym_block_comment_text_token2 = 6,
  aux_sym_block_comment_text_token3 = 7,
  aux_sym_block_comment_text_token4 = 8,
  anon_sym_MODULE = 9,
  sym_single_line = 10,
  sym_double_line = 11,
  anon_sym_EQ_EQ = 12,
  anon_sym_ = 13,
  anon_sym_BSLASHin = 14,
  anon_sym_2 = 15,
  anon_sym_LT_DASH = 16,
  anon_sym_3 = 17,
  anon_sym_4 = 18,
  anon_sym_BSLASHA = 19,
  anon_sym_BSLASHforall = 20,
  anon_sym_5 = 21,
  anon_sym_BSLASHE = 22,
  anon_sym_BSLASHexists = 23,
  anon_sym_6 = 24,
  anon_sym_BSLASHAA = 25,
  anon_sym_BSLASHEE = 26,
  anon_sym_PIPE_DASH_GT = 27,
  anon_sym_7 = 28,
  anon_sym_8 = 29,
  anon_sym_DASH_GT = 30,
  anon_sym_9 = 31,
  anon_sym_10 = 32,
  anon_sym_LT_LT = 33,
  anon_sym_11 = 34,
  anon_sym_12 = 35,
  anon_sym_GT_GT = 36,
  anon_sym_13 = 37,
  anon_sym_14 = 38,
  anon_sym_GT_GT_ = 39,
  anon_sym__ = 40,
  anon_sym__2 = 41,
  anon_sym_LBRACK_RBRACK = 42,
  anon_sym_15 = 43,
  anon_sym_COLON = 44,
  anon_sym_AT = 45,
  anon_sym_COLON_COLON = 46,
  anon_sym_16 = 47,
  sym_placeholder = 48,
  anon_sym_ASSUME = 49,
  anon_sym_ELSE = 50,
  anon_sym_LOCAL = 51,
  anon_sym_UNION = 52,
  anon_sym_ASSUMPTION = 53,
  anon_sym_ENABLED = 54,
  anon_sym_VARIABLE = 55,
  anon_sym_AXIOM = 56,
  anon_sym_EXCEPT = 57,
  anon_sym_OTHER = 58,
  anon_sym_VARIABLES = 59,
  anon_sym_CASE = 60,
  anon_sym_EXTENDS = 61,
  anon_sym_SF_ = 62,
  anon_sym_WF_ = 63,
  anon_sym_CHOOSE = 64,
  anon_sym_IF = 65,
  anon_sym_SUBSET = 66,
  anon_sym_WITH = 67,
  anon_sym_CONSTANT = 68,
  anon_sym_IN = 69,
  anon_sym_THEN = 70,
  anon_sym_CONSTANTS = 71,
  anon_sym_INSTANCE = 72,
  anon_sym_THEOREM = 73,
  anon_sym_COROLLARY = 74,
  anon_sym_DOMAIN = 75,
  anon_sym_LET = 76,
  anon_sym_UNCHANGED = 77,
  anon_sym_BY = 78,
  anon_sym_HAVE = 79,
  anon_sym_QED = 80,
  anon_sym_TAKE = 81,
  anon_sym_DEF = 82,
  anon_sym_HIDE = 83,
  anon_sym_RECURSIVE = 84,
  anon_sym_USE = 85,
  anon_sym_DEFINE = 86,
  anon_sym_PROOF = 87,
  anon_sym_WITNESS = 88,
  anon_sym_PICK = 89,
  anon_sym_DEFS = 90,
  anon_sym_PROVE = 91,
  anon_sym_SUFFICES = 92,
  anon_sym_NEW = 93,
  anon_sym_LAMBDA = 94,
  anon_sym_STATE = 95,
  anon_sym_ACTION = 96,
  anon_sym_TEMPORAL = 97,
  anon_sym_OBVIOUS = 98,
  anon_sym_OMITTED = 99,
  anon_sym_LEMMA = 100,
  anon_sym_PROPOSITION = 101,
  anon_sym_ONLY = 102,
  anon_sym_COMMA = 103,
  anon_sym_LPAREN = 104,
  anon_sym_RPAREN = 105,
  anon_sym_LBRACK = 106,
  anon_sym_RBRACK = 107,
  anon_sym_BANG = 108,
  aux_sym_child_id_token1 = 109,
  sym_real_number = 110,
  anon_sym_BSLASHb = 111,
  anon_sym_BSLASHB = 112,
  aux_sym_binary_number_token1 = 113,
  anon_sym_BSLASHo = 114,
  anon_sym_BSLASHO = 115,
  aux_sym_octal_number_token1 = 116,
  anon_sym_BSLASHh = 117,
  anon_sym_BSLASHH = 118,
  aux_sym_hex_number_token1 = 119,
  anon_sym_DQUOTE = 120,
  aux_sym_string_token1 = 121,
  anon_sym_DQUOTE2 = 122,
  anon_sym_BSLASH = 123,
  aux_sym_escape_char_token1 = 124,
  anon_sym_TRUE = 125,
  anon_sym_FALSE = 126,
  sym_string_set = 127,
  sym_boolean_set = 128,
  anon_sym_Nat = 129,
  anon_sym_17 = 130,
  anon_sym_Int = 131,
  anon_sym_18 = 132,
  anon_sym_Real = 133,
  anon_sym_19 = 134,
  anon_sym_LBRACE = 135,
  anon_sym_RBRACE = 136,
  anon_sym_DOT = 137,
  anon_sym_EQ = 138,
  anon_sym_RBRACK_ = 139,
  anon_sym_BSLASHlnot = 140,
  anon_sym_BSLASHneg = 141,
  anon_sym_TILDE = 142,
  anon_sym_20 = 143,
  anon_sym_DASH = 144,
  sym_negative_dot = 145,
  anon_sym_LT_GT = 146,
  anon_sym_21 = 147,
  anon_sym_EQ_GT = 148,
  anon_sym_22 = 149,
  anon_sym_23 = 150,
  anon_sym_DASH_PLUS_DASH_GT = 151,
  anon_sym_24 = 152,
  anon_sym_25 = 153,
  anon_sym_BSLASHequiv = 154,
  anon_sym_26 = 155,
  anon_sym_LT_EQ_GT = 156,
  anon_sym_27 = 157,
  anon_sym_28 = 158,
  anon_sym_TILDE_GT = 159,
  anon_sym_29 = 160,
  anon_sym_30 = 161,
  anon_sym_SLASH_BSLASH = 162,
  anon_sym_BSLASHland = 163,
  anon_sym_31 = 164,
  anon_sym_BSLASH_SLASH = 165,
  anon_sym_BSLASHlor = 166,
  anon_sym_32 = 167,
  anon_sym_COLON_EQ = 168,
  anon_sym_33 = 169,
  anon_sym_COLON_COLON_EQ = 170,
  anon_sym_34 = 171,
  anon_sym_SLASH_EQ = 172,
  anon_sym_POUND = 173,
  anon_sym_35 = 174,
  anon_sym_LT = 175,
  sym_gt = 176,
  anon_sym_LT_EQ = 177,
  anon_sym_EQ_LT = 178,
  anon_sym_BSLASHleq = 179,
  anon_sym_36 = 180,
  anon_sym_GT_EQ = 181,
  anon_sym_BSLASHgeq = 182,
  anon_sym_37 = 183,
  anon_sym_BSLASHapprox = 184,
  anon_sym_38 = 185,
  anon_sym_PIPE_DASH = 186,
  anon_sym_39 = 187,
  anon_sym_PIPE_EQ = 188,
  anon_sym_40 = 189,
  anon_sym_DASH_PIPE = 190,
  anon_sym_41 = 191,
  anon_sym_EQ_PIPE = 192,
  anon_sym_42 = 193,
  anon_sym_BSLASHasymp = 194,
  anon_sym_43 = 195,
  anon_sym_BSLASHcong = 196,
  anon_sym_44 = 197,
  anon_sym_BSLASHdoteq = 198,
  anon_sym_45 = 199,
  anon_sym_BSLASHgg = 200,
  anon_sym_46 = 201,
  anon_sym_BSLASHll = 202,
  anon_sym_47 = 203,
  anon_sym_BSLASHnotin = 204,
  anon_sym_48 = 205,
  anon_sym_BSLASHprec = 206,
  anon_sym_49 = 207,
  anon_sym_BSLASHsucc = 208,
  anon_sym_50 = 209,
  anon_sym_BSLASHpreceq = 210,
  anon_sym_51 = 211,
  anon_sym_BSLASHsucceq = 212,
  anon_sym_52 = 213,
  anon_sym_BSLASHpropto = 214,
  anon_sym_53 = 215,
  anon_sym_BSLASHsim = 216,
  anon_sym_54 = 217,
  anon_sym_BSLASHsimeq = 218,
  anon_sym_55 = 219,
  anon_sym_BSLASHsqsubset = 220,
  anon_sym_56 = 221,
  anon_sym_BSLASHsqsupset = 222,
  anon_sym_57 = 223,
  anon_sym_BSLASHsqsubseteq = 224,
  anon_sym_58 = 225,
  anon_sym_BSLASHsqsupseteq = 226,
  anon_sym_59 = 227,
  anon_sym_BSLASHsubset = 228,
  anon_sym_60 = 229,
  anon_sym_BSLASHsupset = 230,
  anon_sym_61 = 231,
  anon_sym_BSLASHsubseteq = 232,
  anon_sym_62 = 233,
  anon_sym_BSLASHsupseteq = 234,
  anon_sym_63 = 235,
  sym_compose = 236,
  sym_map_to = 237,
  sym_map_from = 238,
  sym_setminus = 239,
  anon_sym_BSLASHcap = 240,
  anon_sym_BSLASHintersect = 241,
  anon_sym_64 = 242,
  anon_sym_BSLASHcup = 243,
  anon_sym_BSLASHunion = 244,
  anon_sym_65 = 245,
  anon_sym_DOT_DOT = 246,
  anon_sym_66 = 247,
  anon_sym_DOT_DOT_DOT = 248,
  anon_sym_67 = 249,
  anon_sym_PLUS = 250,
  sym_plusplus = 251,
  anon_sym_BSLASHoplus = 252,
  anon_sym_LPAREN_PLUS_RPAREN = 253,
  anon_sym_68 = 254,
  anon_sym_BSLASHominus = 255,
  anon_sym_LPAREN_DASH_RPAREN = 256,
  anon_sym_69 = 257,
  sym_mod = 258,
  sym_modmod = 259,
  sym_vert = 260,
  anon_sym_PIPE_PIPE = 261,
  anon_sym_70 = 262,
  sym_minusminus = 263,
  sym_amp = 264,
  sym_ampamp = 265,
  anon_sym_BSLASHodot = 266,
  anon_sym_LPAREN_DOT_RPAREN = 267,
  anon_sym_71 = 268,
  anon_sym_BSLASHoslash = 269,
  anon_sym_LPAREN_SLASH_RPAREN = 270,
  anon_sym_72 = 271,
  anon_sym_BSLASHotimes = 272,
  anon_sym_LPAREN_BSLASHX_RPAREN = 273,
  anon_sym_73 = 274,
  sym_mul = 275,
  sym_mulmul = 276,
  sym_slash = 277,
  sym_slashslash = 278,
  anon_sym_BSLASHbigcirc = 279,
  anon_sym_74 = 280,
  anon_sym_BSLASHbullet = 281,
  anon_sym_75 = 282,
  anon_sym_BSLASHdiv = 283,
  anon_sym_76 = 284,
  anon_sym_BSLASHcirc = 285,
  anon_sym_77 = 286,
  anon_sym_BSLASHstar = 287,
  anon_sym_78 = 288,
  anon_sym_BANG_BANG = 289,
  anon_sym_79 = 290,
  anon_sym_QMARK_QMARK = 291,
  anon_sym_80 = 292,
  sym_hashhash = 293,
  sym_dol = 294,
  sym_doldol = 295,
  anon_sym_BSLASHsqcap = 296,
  anon_sym_81 = 297,
  anon_sym_BSLASHsqcup = 298,
  anon_sym_82 = 299,
  anon_sym_BSLASHuplus = 300,
  anon_sym_83 = 301,
  anon_sym_BSLASHX = 302,
  anon_sym_BSLASHtimes = 303,
  anon_sym_84 = 304,
  anon_sym_BSLASHwr = 305,
  anon_sym_85 = 306,
  anon_sym_BSLASHcdot = 307,
  anon_sym_86 = 308,
  sym_pow = 309,
  sym_powpow = 310,
  anon_sym_CARET_PLUS = 311,
  anon_sym_87 = 312,
  sym_asterisk = 313,
  sym_sup_hash = 314,
  sym_prime = 315,
  aux_sym_proof_step_id_token1 = 316,
  anon_sym_GT = 317,
  aux_sym_proof_step_id_token2 = 318,
  aux_sym_proof_step_id_token3 = 319,
  aux_sym_proof_step_ref_token1 = 320,
  aux_sym_proof_step_ref_token2 = 321,
  anon_sym_end = 322,
  anon_sym_algorithm = 323,
  anon_sym_SEMI = 324,
  aux_sym_pcal_algorithm_start_token1 = 325,
  anon_sym_define = 326,
  anon_sym_macro = 327,
  anon_sym_procedure = 328,
  anon_sym_fair = 329,
  anon_sym_process = 330,
  anon_sym_variable = 331,
  anon_sym_variables = 332,
  anon_sym_begin = 333,
  anon_sym_if = 334,
  anon_sym_then = 335,
  anon_sym_elsif = 336,
  anon_sym_else = 337,
  anon_sym_while = 338,
  anon_sym_do = 339,
  anon_sym_either = 340,
  anon_sym_or = 341,
  anon_sym_with = 342,
  anon_sym_await = 343,
  anon_sym_when = 344,
  anon_sym_print = 345,
  anon_sym_assert = 346,
  anon_sym_skip = 347,
  anon_sym_return = 348,
  anon_sym_goto = 349,
  anon_sym_call = 350,
  sym_extramodular_text = 351,
  sym__indent = 352,
  sym_bullet_conj = 353,
  sym_bullet_disj = 354,
  sym__dedent = 355,
  sym__begin_proof = 356,
  sym__begin_proof_step = 357,
  sym__notify_pcal_algorithm_start = 358,
  sym__notify_pcal_algorithm_end = 359,
  sym__error_sentinel = 360,
  sym_source_file = 361,
  sym_block_comment = 362,
  sym_block_comment_text = 363,
  sym_module = 364,
  sym_def_eq = 365,
  sym_set_in = 366,
  sym_gets = 367,
  sym_forall = 368,
  sym_exists = 369,
  sym_temporal_forall = 370,
  sym_temporal_exists = 371,
  sym_all_map_to = 372,
  sym_maps_to = 373,
  sym_langle_bracket = 374,
  sym_rangle_bracket = 375,
  sym_rangle_bracket_sub = 376,
  sym_case_box = 377,
  sym_case_arrow = 378,
  sym_colon = 379,
  sym_address = 380,
  sym_label_as = 381,
  sym_extends = 382,
  sym__unit = 383,
  sym_local_definition = 384,
  sym__definition = 385,
  sym_variable_declaration = 386,
  sym_constant_declaration = 387,
  sym_recursive_declaration = 388,
  sym_operator_declaration = 389,
  sym__id_or_op_declaration = 390,
  sym_operator_definition = 391,
  sym_function_definition = 392,
  sym_quantifier_bound = 393,
  sym_single_quantifier_bound = 394,
  sym_tuple_of_identifiers = 395,
  sym_instance = 396,
  sym_substitution = 397,
  sym__op_or_expr = 398,
  sym__op = 399,
  sym_subexpr_prefix = 400,
  sym_subexpr_component = 401,
  sym_bound_op = 402,
  sym_bound_nonfix_op = 403,
  sym_subexpr_tree_nav = 404,
  sym_child_id = 405,
  sym_operator_args = 406,
  sym_lambda = 407,
  sym_module_definition = 408,
  sym__expr = 409,
  sym__subscript_expr = 410,
  sym_prefixed_op = 411,
  sym__number = 412,
  sym_nat_number = 413,
  sym_binary_number = 414,
  sym_octal_number = 415,
  sym_hex_number = 416,
  sym_string = 417,
  sym_escape_char = 418,
  sym_boolean = 419,
  sym__primitive_value_set = 420,
  sym_nat_number_set = 421,
  sym_int_number_set = 422,
  sym_real_number_set = 423,
  sym_label = 424,
  sym_subexpression = 425,
  sym_parentheses = 426,
  sym_bounded_quantification = 427,
  sym_unbounded_quantification = 428,
  sym_choose = 429,
  sym_finite_set_literal = 430,
  sym_set_filter = 431,
  sym_set_map = 432,
  sym_function_evaluation = 433,
  sym_function_literal = 434,
  sym_set_of_functions = 435,
  sym_record_literal = 436,
  sym_set_of_records = 437,
  sym_record_value = 438,
  sym_except = 439,
  aux_sym__except_val = 440,
  sym_prev_func_val = 441,
  sym_tuple_literal = 442,
  sym_step_expr_or_stutter = 443,
  sym_step_expr_no_stutter = 444,
  sym_fairness = 445,
  sym_if_then_else = 446,
  sym_case = 447,
  sym_case_arm = 448,
  sym_other_arm = 449,
  sym_let_in = 450,
  sym_conj_list = 451,
  sym_conj_item = 452,
  sym_disj_list = 453,
  sym_disj_item = 454,
  sym_lnot = 455,
  sym_union = 456,
  sym_powerset = 457,
  sym_domain = 458,
  sym_negative = 459,
  sym_enabled = 460,
  sym_unchanged = 461,
  sym_always = 462,
  sym_eventually = 463,
  sym_prefix_op_symbol = 464,
  sym_bound_prefix_op = 465,
  sym_implies = 466,
  sym_plus_arrow = 467,
  sym_equiv = 468,
  sym_iff = 469,
  sym_leads_to = 470,
  sym_land = 471,
  sym_lor = 472,
  sym_assign = 473,
  sym_bnf_rule = 474,
  sym_eq = 475,
  sym_neq = 476,
  sym_lt = 477,
  sym_leq = 478,
  sym_geq = 479,
  sym_approx = 480,
  sym_rs_ttile = 481,
  sym_rd_ttile = 482,
  sym_ls_ttile = 483,
  sym_ld_ttile = 484,
  sym_asymp = 485,
  sym_cong = 486,
  sym_doteq = 487,
  sym_gg = 488,
  sym_ll = 489,
  sym_in = 490,
  sym_notin = 491,
  sym_prec = 492,
  sym_succ = 493,
  sym_preceq = 494,
  sym_succeq = 495,
  sym_propto = 496,
  sym_sim = 497,
  sym_simeq = 498,
  sym_sqsubset = 499,
  sym_sqsupset = 500,
  sym_sqsubseteq = 501,
  sym_sqsupseteq = 502,
  sym_subset = 503,
  sym_supset = 504,
  sym_subseteq = 505,
  sym_supseteq = 506,
  sym_cap = 507,
  sym_cup = 508,
  sym_dots_2 = 509,
  sym_dots_3 = 510,
  sym_plus = 511,
  sym_oplus = 512,
  sym_ominus = 513,
  sym_vertvert = 514,
  sym_minus = 515,
  sym_odot = 516,
  sym_oslash = 517,
  sym_otimes = 518,
  sym_bigcirc = 519,
  sym_bullet = 520,
  sym_div = 521,
  sym_circ = 522,
  sym_star = 523,
  sym_excl = 524,
  sym_qq = 525,
  sym_sqcap = 526,
  sym_sqcup = 527,
  sym_uplus = 528,
  sym_times = 529,
  sym_wr = 530,
  sym_cdot = 531,
  sym_infix_op_symbol = 532,
  sym_bound_infix_op = 533,
  sym_sup_plus = 534,
  sym_postfix_op_symbol = 535,
  sym_bound_postfix_op = 536,
  sym_assumption = 537,
  sym_theorem = 538,
  sym_assume_prove = 539,
  sym_inner_assume_prove = 540,
  sym_new = 541,
  sym_level = 542,
  sym__proof = 543,
  sym_terminal_proof = 544,
  sym_non_terminal_proof = 545,
  sym_proof_step = 546,
  sym_definition_proof_step = 547,
  sym_have_proof_step = 548,
  sym_witness_proof_step = 549,
  sym_take_proof_step = 550,
  sym_suffices_proof_step = 551,
  sym_case_proof_step = 552,
  sym_pick_proof_step = 553,
  sym__bound_or_identifier_list = 554,
  sym_qed_step = 555,
  sym_use_or_hide = 556,
  sym_use_body = 557,
  sym_use_body_expr = 558,
  sym_use_body_def = 559,
  sym_module_ref = 560,
  sym_proof_step_id = 561,
  sym_proof_step_ref = 562,
  sym_pcal_algorithm = 563,
  sym__pcal_p_algorithm = 564,
  sym__pcal_c_algorithm = 565,
  sym_pcal_algorithm_start = 566,
  sym_pcal_p_definitions = 567,
  sym_pcal_c_definitions = 568,
  sym_pcal_p_macro = 569,
  sym_pcal_c_macro = 570,
  sym_pcal_macro_decl = 571,
  sym_pcal_p_procedure = 572,
  sym_pcal_c_procedure = 573,
  sym_pcal_proc_decl = 574,
  sym_pcal_p_process = 575,
  sym_pcal_c_process = 576,
  sym_pcal_var_decls = 577,
  sym_pcal_var_decl = 578,
  sym_pcal_proc_var_decls = 579,
  sym_pcal_proc_var_decl = 580,
  sym_pcal_p_algorithm_body = 581,
  sym__pcal_p_stmts = 582,
  sym_pcal_c_algorithm_body = 583,
  sym__pcal_p_stmt = 584,
  sym__pcal_c_stmt = 585,
  sym__pcal_label = 586,
  sym__pcal_p_unlabeled_stmt = 587,
  sym__pcal_c_unlabeled_stmt = 588,
  sym_pcal_assign = 589,
  sym_pcal_lhs = 590,
  sym_pcal_p_if = 591,
  sym_pcal_c_if = 592,
  sym_pcal_p_while = 593,
  sym_pcal_c_while = 594,
  sym_pcal_p_either = 595,
  sym_pcal_c_either = 596,
  sym_pcal_p_with = 597,
  sym_pcal_c_with = 598,
  sym__pcal_with_vars = 599,
  sym_pcal_await = 600,
  sym_pcal_print = 601,
  sym_pcal_assert = 602,
  sym_pcal_skip = 603,
  sym_pcal_return = 604,
  sym_pcal_goto = 605,
  sym_pcal_proc_call = 606,
  sym_pcal_macro_call = 607,
  aux_sym_source_file_repeat1 = 608,
  aux_sym_block_comment_repeat1 = 609,
  aux_sym_block_comment_text_repeat1 = 610,
  aux_sym_module_repeat1 = 611,
  aux_sym_extends_repeat1 = 612,
  aux_sym_variable_declaration_repeat1 = 613,
  aux_sym_constant_declaration_repeat1 = 614,
  aux_sym_operator_declaration_repeat1 = 615,
  aux_sym_function_definition_repeat1 = 616,
  aux_sym_instance_repeat1 = 617,
  aux_sym_subexpr_prefix_repeat1 = 618,
  aux_sym_bound_op_repeat1 = 619,
  aux_sym_string_repeat1 = 620,
  aux_sym_finite_set_literal_repeat1 = 621,
  aux_sym_record_literal_repeat1 = 622,
  aux_sym_set_of_records_repeat1 = 623,
  aux_sym_except_repeat1 = 624,
  aux_sym_case_repeat1 = 625,
  aux_sym_let_in_repeat1 = 626,
  aux_sym_conj_list_repeat1 = 627,
  aux_sym_disj_list_repeat1 = 628,
  aux_sym_assume_prove_repeat1 = 629,
  aux_sym_non_terminal_proof_repeat1 = 630,
  aux_sym_definition_proof_step_repeat1 = 631,
  aux_sym_use_body_expr_repeat1 = 632,
  aux_sym_use_body_def_repeat1 = 633,
  aux_sym__pcal_p_algorithm_repeat1 = 634,
  aux_sym__pcal_p_algorithm_repeat2 = 635,
  aux_sym__pcal_p_algorithm_repeat3 = 636,
  aux_sym__pcal_c_algorithm_repeat1 = 637,
  aux_sym__pcal_c_algorithm_repeat2 = 638,
  aux_sym__pcal_c_algorithm_repeat3 = 639,
  aux_sym_pcal_p_definitions_repeat1 = 640,
  aux_sym_pcal_macro_decl_repeat1 = 641,
  aux_sym_pcal_proc_decl_repeat1 = 642,
  aux_sym_pcal_var_decls_repeat1 = 643,
  aux_sym_pcal_proc_var_decls_repeat1 = 644,
  aux_sym__pcal_p_stmts_repeat1 = 645,
  aux_sym_pcal_c_algorithm_body_repeat1 = 646,
  aux_sym_pcal_assign_repeat1 = 647,
  aux_sym_pcal_lhs_repeat1 = 648,
  aux_sym_pcal_p_if_repeat1 = 649,
  aux_sym_pcal_p_either_repeat1 = 650,
  aux_sym_pcal_c_either_repeat1 = 651,
  aux_sym__pcal_with_vars_repeat1 = 652,
  alias_sym_header_line = 653,
  alias_sym_identifier_ref = 654,
  alias_sym_pcal_end_either = 655,
  alias_sym_pcal_end_if = 656,
  alias_sym_pcal_end_while = 657,
  alias_sym_pcal_end_with = 658,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_STAR_RPAREN] = "*)",
  [aux_sym_block_comment_text_token1] = "block_comment_text_token1",
  [aux_sym_block_comment_text_token2] = "block_comment_text_token2",
  [aux_sym_block_comment_text_token3] = "block_comment_text_token3",
  [aux_sym_block_comment_text_token4] = "block_comment_text_token4",
  [anon_sym_MODULE] = "MODULE",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_] = "≜",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_2] = "∈",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_3] = "⟵",
  [anon_sym_4] = "←",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_5] = "∀",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_6] = "∃",
  [anon_sym_BSLASHAA] = "\\AA",
  [anon_sym_BSLASHEE] = "\\EE",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_7] = "⟼",
  [anon_sym_8] = "↦",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_9] = "⟶",
  [anon_sym_10] = "→",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_11] = "〈",
  [anon_sym_12] = "⟨",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_13] = "〉",
  [anon_sym_14] = "⟩",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym__] = "〉_",
  [anon_sym__2] = "⟩_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_15] = "□",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_16] = "∷",
  [sym_placeholder] = "placeholder",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_ENABLED] = "ENABLED",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CASE] = "CASE",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_SF_] = "SF_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_IF] = "IF",
  [anon_sym_SUBSET] = "SUBSET",
  [anon_sym_WITH] = "WITH",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_IN] = "IN",
  [anon_sym_THEN] = "THEN",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_DOMAIN] = "DOMAIN",
  [anon_sym_LET] = "LET",
  [anon_sym_UNCHANGED] = "UNCHANGED",
  [anon_sym_BY] = "BY",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_QED] = "QED",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_USE] = "USE",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_PICK] = "PICK",
  [anon_sym_DEFS] = "DEFS",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_NEW] = "NEW",
  [anon_sym_LAMBDA] = "LAMBDA",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_ONLY] = "ONLY",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [sym_real_number] = "real_number",
  [anon_sym_BSLASHb] = "format",
  [anon_sym_BSLASHB] = "format",
  [aux_sym_binary_number_token1] = "value",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHO] = "format",
  [aux_sym_octal_number_token1] = "value",
  [anon_sym_BSLASHh] = "format",
  [anon_sym_BSLASHH] = "format",
  [aux_sym_hex_number_token1] = "value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_char_token1] = "escape_char_token1",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [sym_string_set] = "string_set",
  [sym_boolean_set] = "boolean_set",
  [anon_sym_Nat] = "Nat",
  [anon_sym_17] = "ℕ",
  [anon_sym_Int] = "Int",
  [anon_sym_18] = "ℤ",
  [anon_sym_Real] = "Real",
  [anon_sym_19] = "ℝ",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_20] = "¬",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_21] = "⋄",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_22] = "⟹",
  [anon_sym_23] = "⇒",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_24] = "⇸",
  [anon_sym_25] = "⥅",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_26] = "≡",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_27] = "⟺",
  [anon_sym_28] = "⇔",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_29] = "⇝",
  [anon_sym_30] = "↝",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_31] = "∧",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_32] = "∨",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_33] = "≔",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_34] = "⩴",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_35] = "≠",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_36] = "≤",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_37] = "≥",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_38] = "≈",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_39] = "⊢",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_40] = "⊨",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_41] = "⊣",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_42] = "⫤",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_43] = "≍",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_44] = "≅",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_45] = "≐",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_46] = "≫",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_47] = "≪",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_48] = "∉",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_49] = "≺",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_50] = "≻",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_51] = "⪯",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_52] = "⪰",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_53] = "∝",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_54] = "∼",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_55] = "≃",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_56] = "⊏",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_57] = "⊐",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_58] = "⊑",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_59] = "⊒",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_60] = "⊂",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_61] = "⊃",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_62] = "⊆",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_63] = "⊇",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_64] = "∩",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_65] = "∪",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_66] = "‥",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_67] = "…",
  [anon_sym_PLUS] = "+",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_68] = "⊕",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_69] = "⊖",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_70] = "‖",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_71] = "⊙",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_72] = "⊘",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_73] = "⊗",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_74] = "◯",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_75] = "●",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_76] = "÷",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_77] = "∘",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_78] = "⋆",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_79] = "‼",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_80] = "⁇",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_81] = "⊓",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_82] = "⊔",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_83] = "⊎",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_84] = "×",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_85] = "≀",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_86] = "⋅",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_87] = "⁺",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [anon_sym_end] = "end",
  [anon_sym_algorithm] = "algorithm",
  [anon_sym_SEMI] = ";",
  [aux_sym_pcal_algorithm_start_token1] = "pcal_algorithm_start_token1",
  [anon_sym_define] = "define",
  [anon_sym_macro] = "macro",
  [anon_sym_procedure] = "procedure",
  [anon_sym_fair] = "fair",
  [anon_sym_process] = "process",
  [anon_sym_variable] = "variable",
  [anon_sym_variables] = "variables",
  [anon_sym_begin] = "begin",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elsif] = "elsif",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_either] = "either",
  [anon_sym_or] = "or",
  [anon_sym_with] = "with",
  [anon_sym_await] = "await",
  [anon_sym_when] = "when",
  [anon_sym_print] = "print",
  [anon_sym_assert] = "assert",
  [anon_sym_skip] = "skip",
  [anon_sym_return] = "return",
  [anon_sym_goto] = "goto",
  [anon_sym_call] = "call",
  [sym_extramodular_text] = "extramodular_text",
  [sym__indent] = "_indent",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym__notify_pcal_algorithm_start] = "_notify_pcal_algorithm_start",
  [sym__notify_pcal_algorithm_end] = "_notify_pcal_algorithm_end",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_block_comment_text] = "block_comment_text",
  [sym_module] = "module",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_extends] = "extends",
  [sym__unit] = "_unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_single_quantifier_bound] = "single_quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym__op] = "_op",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym__number] = "_number",
  [sym_nat_number] = "nat_number",
  [sym_binary_number] = "binary_number",
  [sym_octal_number] = "octal_number",
  [sym_hex_number] = "hex_number",
  [sym_string] = "string",
  [sym_escape_char] = "escape_char",
  [sym_boolean] = "boolean",
  [sym__primitive_value_set] = "_primitive_value_set",
  [sym_nat_number_set] = "nat_number_set",
  [sym_int_number_set] = "int_number_set",
  [sym_real_number_set] = "real_number_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [aux_sym__except_val] = "_except_val",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [sym_negative] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_prefix_op_symbol] = "prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_plus] = "plus",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_level] = "level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [sym_pcal_algorithm] = "pcal_algorithm",
  [sym__pcal_p_algorithm] = "_pcal_p_algorithm",
  [sym__pcal_c_algorithm] = "_pcal_c_algorithm",
  [sym_pcal_algorithm_start] = "pcal_algorithm_start",
  [sym_pcal_p_definitions] = "pcal_definitions",
  [sym_pcal_c_definitions] = "pcal_definitions",
  [sym_pcal_p_macro] = "pcal_macro",
  [sym_pcal_c_macro] = "pcal_macro",
  [sym_pcal_macro_decl] = "pcal_macro_decl",
  [sym_pcal_p_procedure] = "pcal_procedure",
  [sym_pcal_c_procedure] = "pcal_procedure",
  [sym_pcal_proc_decl] = "pcal_proc_decl",
  [sym_pcal_p_process] = "pcal_process",
  [sym_pcal_c_process] = "pcal_process",
  [sym_pcal_var_decls] = "pcal_var_decls",
  [sym_pcal_var_decl] = "pcal_var_decl",
  [sym_pcal_proc_var_decls] = "pcal_proc_var_decls",
  [sym_pcal_proc_var_decl] = "pcal_proc_var_decl",
  [sym_pcal_p_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmts] = "_pcal_p_stmts",
  [sym_pcal_c_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmt] = "_pcal_p_stmt",
  [sym__pcal_c_stmt] = "_pcal_c_stmt",
  [sym__pcal_label] = "_pcal_label",
  [sym__pcal_p_unlabeled_stmt] = "_pcal_p_unlabeled_stmt",
  [sym__pcal_c_unlabeled_stmt] = "_pcal_c_unlabeled_stmt",
  [sym_pcal_assign] = "pcal_assign",
  [sym_pcal_lhs] = "pcal_lhs",
  [sym_pcal_p_if] = "pcal_if",
  [sym_pcal_c_if] = "pcal_if",
  [sym_pcal_p_while] = "pcal_while",
  [sym_pcal_c_while] = "pcal_while",
  [sym_pcal_p_either] = "pcal_either",
  [sym_pcal_c_either] = "pcal_either",
  [sym_pcal_p_with] = "pcal_with",
  [sym_pcal_c_with] = "pcal_with",
  [sym__pcal_with_vars] = "_pcal_with_vars",
  [sym_pcal_await] = "pcal_await",
  [sym_pcal_print] = "pcal_print",
  [sym_pcal_assert] = "pcal_assert",
  [sym_pcal_skip] = "pcal_skip",
  [sym_pcal_return] = "pcal_return",
  [sym_pcal_goto] = "pcal_goto",
  [sym_pcal_proc_call] = "pcal_proc_call",
  [sym_pcal_macro_call] = "pcal_macro_call",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_block_comment_text_repeat1] = "block_comment_text_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [aux_sym__pcal_p_algorithm_repeat1] = "_pcal_p_algorithm_repeat1",
  [aux_sym__pcal_p_algorithm_repeat2] = "_pcal_p_algorithm_repeat2",
  [aux_sym__pcal_p_algorithm_repeat3] = "_pcal_p_algorithm_repeat3",
  [aux_sym__pcal_c_algorithm_repeat1] = "_pcal_c_algorithm_repeat1",
  [aux_sym__pcal_c_algorithm_repeat2] = "_pcal_c_algorithm_repeat2",
  [aux_sym__pcal_c_algorithm_repeat3] = "_pcal_c_algorithm_repeat3",
  [aux_sym_pcal_p_definitions_repeat1] = "pcal_p_definitions_repeat1",
  [aux_sym_pcal_macro_decl_repeat1] = "pcal_macro_decl_repeat1",
  [aux_sym_pcal_proc_decl_repeat1] = "pcal_proc_decl_repeat1",
  [aux_sym_pcal_var_decls_repeat1] = "pcal_var_decls_repeat1",
  [aux_sym_pcal_proc_var_decls_repeat1] = "pcal_proc_var_decls_repeat1",
  [aux_sym__pcal_p_stmts_repeat1] = "_pcal_p_stmts_repeat1",
  [aux_sym_pcal_c_algorithm_body_repeat1] = "pcal_c_algorithm_body_repeat1",
  [aux_sym_pcal_assign_repeat1] = "pcal_assign_repeat1",
  [aux_sym_pcal_lhs_repeat1] = "pcal_lhs_repeat1",
  [aux_sym_pcal_p_if_repeat1] = "pcal_p_if_repeat1",
  [aux_sym_pcal_p_either_repeat1] = "pcal_p_either_repeat1",
  [aux_sym_pcal_c_either_repeat1] = "pcal_c_either_repeat1",
  [aux_sym__pcal_with_vars_repeat1] = "_pcal_with_vars_repeat1",
  [alias_sym_header_line] = "header_line",
  [alias_sym_identifier_ref] = "identifier_ref",
  [alias_sym_pcal_end_either] = "pcal_end_either",
  [alias_sym_pcal_end_if] = "pcal_end_if",
  [alias_sym_pcal_end_while] = "pcal_end_while",
  [alias_sym_pcal_end_with] = "pcal_end_with",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_STAR_RPAREN] = anon_sym_STAR_RPAREN,
  [aux_sym_block_comment_text_token1] = aux_sym_block_comment_text_token1,
  [aux_sym_block_comment_text_token2] = aux_sym_block_comment_text_token2,
  [aux_sym_block_comment_text_token3] = aux_sym_block_comment_text_token3,
  [aux_sym_block_comment_text_token4] = aux_sym_block_comment_text_token4,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_] = anon_sym_,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_6] = anon_sym_6,
  [anon_sym_BSLASHAA] = anon_sym_BSLASHAA,
  [anon_sym_BSLASHEE] = anon_sym_BSLASHEE,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_7] = anon_sym_7,
  [anon_sym_8] = anon_sym_8,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_9] = anon_sym_9,
  [anon_sym_10] = anon_sym_10,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_11] = anon_sym_11,
  [anon_sym_12] = anon_sym_12,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_13] = anon_sym_13,
  [anon_sym_14] = anon_sym_14,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym__] = anon_sym__,
  [anon_sym__2] = anon_sym__2,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_15] = anon_sym_15,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_16] = anon_sym_16,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_ENABLED] = anon_sym_ENABLED,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_SUBSET] = anon_sym_SUBSET,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_DOMAIN] = anon_sym_DOMAIN,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_UNCHANGED] = anon_sym_UNCHANGED,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [sym_real_number] = sym_real_number,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHB] = anon_sym_BSLASHb,
  [aux_sym_binary_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHO] = anon_sym_BSLASHb,
  [aux_sym_octal_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHh] = anon_sym_BSLASHb,
  [anon_sym_BSLASHH] = anon_sym_BSLASHb,
  [aux_sym_hex_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_char_token1] = aux_sym_escape_char_token1,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [sym_string_set] = sym_string_set,
  [sym_boolean_set] = sym_boolean_set,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_17] = anon_sym_17,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_18] = anon_sym_18,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_19] = anon_sym_19,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_20] = anon_sym_20,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_21] = anon_sym_21,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_22] = anon_sym_22,
  [anon_sym_23] = anon_sym_23,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_24] = anon_sym_24,
  [anon_sym_25] = anon_sym_25,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_26] = anon_sym_26,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_27] = anon_sym_27,
  [anon_sym_28] = anon_sym_28,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_29] = anon_sym_29,
  [anon_sym_30] = anon_sym_30,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_31] = anon_sym_31,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_32] = anon_sym_32,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_33] = anon_sym_33,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_34] = anon_sym_34,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_35] = anon_sym_35,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_36] = anon_sym_36,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_37] = anon_sym_37,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_38] = anon_sym_38,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_39] = anon_sym_39,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_40] = anon_sym_40,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_41] = anon_sym_41,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_42] = anon_sym_42,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_43] = anon_sym_43,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_44] = anon_sym_44,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_45] = anon_sym_45,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_46] = anon_sym_46,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_47] = anon_sym_47,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_48] = anon_sym_48,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_49] = anon_sym_49,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_50] = anon_sym_50,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_51] = anon_sym_51,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_52] = anon_sym_52,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_53] = anon_sym_53,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_54] = anon_sym_54,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_55] = anon_sym_55,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_56] = anon_sym_56,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_57] = anon_sym_57,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_58] = anon_sym_58,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_59] = anon_sym_59,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_60] = anon_sym_60,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_61] = anon_sym_61,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_62] = anon_sym_62,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_63] = anon_sym_63,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_64] = anon_sym_64,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_65] = anon_sym_65,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_66] = anon_sym_66,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_67] = anon_sym_67,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_68] = anon_sym_68,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_69] = anon_sym_69,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_70] = anon_sym_70,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_71] = anon_sym_71,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_72] = anon_sym_72,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_73] = anon_sym_73,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_74] = anon_sym_74,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_75] = anon_sym_75,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_76] = anon_sym_76,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_77] = anon_sym_77,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_78] = anon_sym_78,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_79] = anon_sym_79,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_80] = anon_sym_80,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_81] = anon_sym_81,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_82] = anon_sym_82,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_83] = anon_sym_83,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_84] = anon_sym_84,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_85] = anon_sym_85,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_86] = anon_sym_86,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_87] = anon_sym_87,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [aux_sym_proof_step_id_token1] = sym_level,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = sym_level,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_algorithm] = anon_sym_algorithm,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym_pcal_algorithm_start_token1] = aux_sym_pcal_algorithm_start_token1,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_procedure] = anon_sym_procedure,
  [anon_sym_fair] = anon_sym_fair,
  [anon_sym_process] = anon_sym_process,
  [anon_sym_variable] = anon_sym_variable,
  [anon_sym_variables] = anon_sym_variables,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_either] = anon_sym_either,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_skip] = anon_sym_skip,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_call] = anon_sym_call,
  [sym_extramodular_text] = sym_extramodular_text,
  [sym__indent] = sym__indent,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym__notify_pcal_algorithm_start] = sym__notify_pcal_algorithm_start,
  [sym__notify_pcal_algorithm_end] = sym__notify_pcal_algorithm_end,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_block_comment_text] = sym_block_comment_text,
  [sym_module] = sym_module,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_extends] = sym_extends,
  [sym__unit] = sym__unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_single_quantifier_bound] = sym_single_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym__op] = sym__op,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym__number] = sym__number,
  [sym_nat_number] = sym_nat_number,
  [sym_binary_number] = sym_binary_number,
  [sym_octal_number] = sym_octal_number,
  [sym_hex_number] = sym_hex_number,
  [sym_string] = sym_string,
  [sym_escape_char] = sym_escape_char,
  [sym_boolean] = sym_boolean,
  [sym__primitive_value_set] = sym__primitive_value_set,
  [sym_nat_number_set] = sym_nat_number_set,
  [sym_int_number_set] = sym_int_number_set,
  [sym_real_number_set] = sym_real_number_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [aux_sym__except_val] = aux_sym__except_val,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [sym_negative] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_prefix_op_symbol] = sym_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_plus] = sym_plus,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_level] = sym_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [sym_pcal_algorithm] = sym_pcal_algorithm,
  [sym__pcal_p_algorithm] = sym__pcal_p_algorithm,
  [sym__pcal_c_algorithm] = sym__pcal_c_algorithm,
  [sym_pcal_algorithm_start] = sym_pcal_algorithm_start,
  [sym_pcal_p_definitions] = sym_pcal_p_definitions,
  [sym_pcal_c_definitions] = sym_pcal_p_definitions,
  [sym_pcal_p_macro] = sym_pcal_p_macro,
  [sym_pcal_c_macro] = sym_pcal_p_macro,
  [sym_pcal_macro_decl] = sym_pcal_macro_decl,
  [sym_pcal_p_procedure] = sym_pcal_p_procedure,
  [sym_pcal_c_procedure] = sym_pcal_p_procedure,
  [sym_pcal_proc_decl] = sym_pcal_proc_decl,
  [sym_pcal_p_process] = sym_pcal_p_process,
  [sym_pcal_c_process] = sym_pcal_p_process,
  [sym_pcal_var_decls] = sym_pcal_var_decls,
  [sym_pcal_var_decl] = sym_pcal_var_decl,
  [sym_pcal_proc_var_decls] = sym_pcal_proc_var_decls,
  [sym_pcal_proc_var_decl] = sym_pcal_proc_var_decl,
  [sym_pcal_p_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmts] = sym__pcal_p_stmts,
  [sym_pcal_c_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmt] = sym__pcal_p_stmt,
  [sym__pcal_c_stmt] = sym__pcal_c_stmt,
  [sym__pcal_label] = sym__pcal_label,
  [sym__pcal_p_unlabeled_stmt] = sym__pcal_p_unlabeled_stmt,
  [sym__pcal_c_unlabeled_stmt] = sym__pcal_c_unlabeled_stmt,
  [sym_pcal_assign] = sym_pcal_assign,
  [sym_pcal_lhs] = sym_pcal_lhs,
  [sym_pcal_p_if] = sym_pcal_p_if,
  [sym_pcal_c_if] = sym_pcal_p_if,
  [sym_pcal_p_while] = sym_pcal_p_while,
  [sym_pcal_c_while] = sym_pcal_p_while,
  [sym_pcal_p_either] = sym_pcal_p_either,
  [sym_pcal_c_either] = sym_pcal_p_either,
  [sym_pcal_p_with] = sym_pcal_p_with,
  [sym_pcal_c_with] = sym_pcal_p_with,
  [sym__pcal_with_vars] = sym__pcal_with_vars,
  [sym_pcal_await] = sym_pcal_await,
  [sym_pcal_print] = sym_pcal_print,
  [sym_pcal_assert] = sym_pcal_assert,
  [sym_pcal_skip] = sym_pcal_skip,
  [sym_pcal_return] = sym_pcal_return,
  [sym_pcal_goto] = sym_pcal_goto,
  [sym_pcal_proc_call] = sym_pcal_proc_call,
  [sym_pcal_macro_call] = sym_pcal_macro_call,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_block_comment_text_repeat1] = aux_sym_block_comment_text_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [aux_sym__pcal_p_algorithm_repeat1] = aux_sym__pcal_p_algorithm_repeat1,
  [aux_sym__pcal_p_algorithm_repeat2] = aux_sym__pcal_p_algorithm_repeat2,
  [aux_sym__pcal_p_algorithm_repeat3] = aux_sym__pcal_p_algorithm_repeat3,
  [aux_sym__pcal_c_algorithm_repeat1] = aux_sym__pcal_c_algorithm_repeat1,
  [aux_sym__pcal_c_algorithm_repeat2] = aux_sym__pcal_c_algorithm_repeat2,
  [aux_sym__pcal_c_algorithm_repeat3] = aux_sym__pcal_c_algorithm_repeat3,
  [aux_sym_pcal_p_definitions_repeat1] = aux_sym_pcal_p_definitions_repeat1,
  [aux_sym_pcal_macro_decl_repeat1] = aux_sym_pcal_macro_decl_repeat1,
  [aux_sym_pcal_proc_decl_repeat1] = aux_sym_pcal_proc_decl_repeat1,
  [aux_sym_pcal_var_decls_repeat1] = aux_sym_pcal_var_decls_repeat1,
  [aux_sym_pcal_proc_var_decls_repeat1] = aux_sym_pcal_proc_var_decls_repeat1,
  [aux_sym__pcal_p_stmts_repeat1] = aux_sym__pcal_p_stmts_repeat1,
  [aux_sym_pcal_c_algorithm_body_repeat1] = aux_sym_pcal_c_algorithm_body_repeat1,
  [aux_sym_pcal_assign_repeat1] = aux_sym_pcal_assign_repeat1,
  [aux_sym_pcal_lhs_repeat1] = aux_sym_pcal_lhs_repeat1,
  [aux_sym_pcal_p_if_repeat1] = aux_sym_pcal_p_if_repeat1,
  [aux_sym_pcal_p_either_repeat1] = aux_sym_pcal_p_either_repeat1,
  [aux_sym_pcal_c_either_repeat1] = aux_sym_pcal_c_either_repeat1,
  [aux_sym__pcal_with_vars_repeat1] = aux_sym__pcal_with_vars_repeat1,
  [alias_sym_header_line] = alias_sym_header_line,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
  [alias_sym_pcal_end_either] = alias_sym_pcal_end_either,
  [alias_sym_pcal_end_if] = alias_sym_pcal_end_if,
  [alias_sym_pcal_end_while] = alias_sym_pcal_end_while,
  [alias_sym_pcal_end_with] = alias_sym_pcal_end_with,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_comment_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHEE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_11] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_16] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENABLED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOMAIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNCHANGED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_real_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHB] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_binary_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHO] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_octal_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHh] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHH] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_hex_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_set] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_set] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_33] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_34] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_35] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_36] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_37] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_38] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_39] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_41] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_42] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_43] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_44] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_45] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_46] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_47] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_49] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_50] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_51] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_52] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_53] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_54] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_55] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_57] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_58] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_59] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_60] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_61] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_62] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_63] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_65] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_66] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_67] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_68] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_69] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_70] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_71] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_73] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_74] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_75] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_76] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_77] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_78] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_79] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_80] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_81] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_82] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_83] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_84] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_85] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_86] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_87] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_algorithm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pcal_algorithm_start_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_procedure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fair] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_process] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variables] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_either] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_skip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [sym_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym__notify_pcal_algorithm_start] = {
    .visible = false,
    .named = true,
  },
  [sym__notify_pcal_algorithm_end] = {
    .visible = false,
    .named = true,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_text] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym__unit] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__op] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_number] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__primitive_value_set] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_int_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_real_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__except_val] = {
    .visible = false,
    .named = false,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_algorithm] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_algorithm_start] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmts] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_c_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_label] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_p_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_lhs] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_with] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_with] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_with_vars] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_await] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_print] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_skip] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_return] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_goto] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_macro_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_stmts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_algorithm_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_assign_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_lhs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_with_vars_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_header_line] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_either] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_if] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_while] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_with] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expression = 7,
  field_filter = 8,
  field_generator = 9,
  field_identifier = 10,
  field_if = 11,
  field_label = 12,
  field_lhs = 13,
  field_map = 14,
  field_name = 15,
  field_op = 16,
  field_parameter = 17,
  field_prefix = 18,
  field_quantifier = 19,
  field_rhs = 20,
  field_set = 21,
  field_statement = 22,
  field_symbol = 23,
  field_then = 24,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_identifier] = "identifier",
  [field_if] = "if",
  [field_label] = "label",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_statement] = "statement",
  [field_symbol] = "symbol",
  [field_then] = "then",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 1},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 1},
  [11] = {.index = 10, .length = 2},
  [12] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 13, .length = 2},
  [16] = {.index = 15, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 3},
  [20] = {.index = 24, .length = 3},
  [21] = {.index = 27, .length = 2},
  [22] = {.index = 29, .length = 2},
  [23] = {.index = 31, .length = 3},
  [24] = {.index = 34, .length = 1},
  [25] = {.index = 35, .length = 4},
  [26] = {.index = 39, .length = 1},
  [27] = {.index = 40, .length = 3},
  [28] = {.index = 43, .length = 2},
  [29] = {.index = 45, .length = 2},
  [30] = {.index = 12, .length = 1},
  [31] = {.index = 47, .length = 3},
  [32] = {.index = 50, .length = 3},
  [33] = {.index = 19, .length = 2},
  [34] = {.index = 53, .length = 2},
  [35] = {.index = 55, .length = 1},
  [36] = {.index = 56, .length = 5},
  [37] = {.index = 61, .length = 1},
  [38] = {.index = 62, .length = 2},
  [39] = {.index = 64, .length = 2},
  [40] = {.index = 66, .length = 2},
  [41] = {.index = 68, .length = 4},
  [42] = {.index = 72, .length = 4},
  [43] = {.index = 76, .length = 1},
  [44] = {.index = 76, .length = 1},
  [45] = {.index = 76, .length = 1},
  [46] = {.index = 77, .length = 3},
  [47] = {.index = 3, .length = 1},
  [48] = {.index = 80, .length = 6},
  [49] = {.index = 86, .length = 2},
  [50] = {.index = 88, .length = 3},
  [51] = {.index = 91, .length = 5},
  [52] = {.index = 96, .length = 3},
  [53] = {.index = 99, .length = 2},
  [54] = {.index = 101, .length = 2},
  [55] = {.index = 103, .length = 1},
  [56] = {.index = 104, .length = 6},
  [57] = {.index = 76, .length = 1},
  [58] = {.index = 110, .length = 2},
  [59] = {.index = 112, .length = 1},
  [60] = {.index = 113, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_label, 1, .inherited = true},
  [2] =
    {field_label, 0, .inherited = true},
  [3] =
    {field_name, 2},
  [4] =
    {field_label, 0},
    {field_label, 1},
  [6] =
    {field_statement, 1},
  [7] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [9] =
    {field_name, 1},
  [10] =
    {field_definition, 2},
    {field_name, 0},
  [12] =
    {field_name, 0},
  [13] =
    {field_op, 1},
    {field_prefix, 0},
  [15] =
    {field_lhs, 0},
    {field_symbol, 1},
  [17] =
    {field_rhs, 1},
    {field_symbol, 0},
  [19] =
    {field_label, 1, .inherited = true},
    {field_label, 2, .inherited = true},
  [21] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [24] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [27] =
    {field_name, 1},
    {field_parameter, 3},
  [29] =
    {field_expression, 2},
    {field_name, 0},
  [31] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [34] =
    {field_set, 2},
  [35] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [39] =
    {field_parameter, 1},
  [40] =
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [43] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [45] =
    {field_definitions, 1},
    {field_expression, 3},
  [47] =
    {field_expression, 3},
    {field_identifier, 1},
    {field_quantifier, 0},
  [50] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [53] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [55] =
    {field_label, 4, .inherited = true},
  [56] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [61] =
    {field_set, 3},
  [62] =
    {field_definition, 5},
    {field_name, 0},
  [64] =
    {field_filter, 3},
    {field_generator, 1},
  [66] =
    {field_generator, 3},
    {field_map, 1},
  [68] =
    {field_expression, 4},
    {field_identifier, 1},
    {field_identifier, 2},
    {field_quantifier, 0},
  [72] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [76] =
    {field_label, 3, .inherited = true},
  [77] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [80] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [86] =
    {field_definition, 6},
    {field_name, 0},
  [88] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [91] =
    {field_expression, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [96] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [99] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
  [101] =
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
  [103] =
    {field_name, 3},
  [104] =
    {field_expression, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [110] =
    {field_label, 3, .inherited = true},
    {field_label, 5, .inherited = true},
  [112] =
    {field_name, 4},
  [113] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_identifier_ref,
  },
  [5] = {
    [0] = alias_sym_header_line,
    [3] = alias_sym_header_line,
  },
  [6] = {
    [1] = alias_sym_identifier_ref,
  },
  [13] = {
    [0] = anon_sym_BSLASHb,
  },
  [14] = {
    [1] = alias_sym_identifier_ref,
  },
  [30] = {
    [0] = alias_sym_identifier_ref,
  },
  [33] = {
    [3] = alias_sym_pcal_end_either,
  },
  [43] = {
    [4] = alias_sym_pcal_end_if,
  },
  [44] = {
    [4] = alias_sym_pcal_end_while,
  },
  [45] = {
    [4] = alias_sym_pcal_end_with,
  },
  [53] = {
    [5] = alias_sym_pcal_end_if,
  },
  [58] = {
    [6] = alias_sym_pcal_end_if,
  },
  [60] = {
    [7] = alias_sym_pcal_end_if,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 9,
  [11] = 11,
  [12] = 9,
  [13] = 13,
  [14] = 13,
  [15] = 15,
  [16] = 16,
  [17] = 15,
  [18] = 16,
  [19] = 19,
  [20] = 19,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 22,
  [26] = 21,
  [27] = 23,
  [28] = 28,
  [29] = 29,
  [30] = 28,
  [31] = 29,
  [32] = 8,
  [33] = 6,
  [34] = 34,
  [35] = 5,
  [36] = 7,
  [37] = 37,
  [38] = 37,
  [39] = 39,
  [40] = 40,
  [41] = 40,
  [42] = 39,
  [43] = 43,
  [44] = 43,
  [45] = 43,
  [46] = 40,
  [47] = 47,
  [48] = 40,
  [49] = 43,
  [50] = 47,
  [51] = 47,
  [52] = 37,
  [53] = 47,
  [54] = 37,
  [55] = 40,
  [56] = 47,
  [57] = 40,
  [58] = 43,
  [59] = 43,
  [60] = 60,
  [61] = 40,
  [62] = 6,
  [63] = 47,
  [64] = 7,
  [65] = 8,
  [66] = 5,
  [67] = 5,
  [68] = 6,
  [69] = 43,
  [70] = 43,
  [71] = 8,
  [72] = 72,
  [73] = 40,
  [74] = 7,
  [75] = 40,
  [76] = 43,
  [77] = 47,
  [78] = 72,
  [79] = 47,
  [80] = 37,
  [81] = 60,
  [82] = 40,
  [83] = 43,
  [84] = 37,
  [85] = 39,
  [86] = 37,
  [87] = 72,
  [88] = 47,
  [89] = 47,
  [90] = 40,
  [91] = 43,
  [92] = 37,
  [93] = 37,
  [94] = 43,
  [95] = 37,
  [96] = 40,
  [97] = 37,
  [98] = 47,
  [99] = 72,
  [100] = 39,
  [101] = 43,
  [102] = 37,
  [103] = 72,
  [104] = 104,
  [105] = 47,
  [106] = 40,
  [107] = 40,
  [108] = 47,
  [109] = 47,
  [110] = 43,
  [111] = 37,
  [112] = 37,
  [113] = 37,
  [114] = 43,
  [115] = 40,
  [116] = 37,
  [117] = 47,
  [118] = 47,
  [119] = 40,
  [120] = 39,
  [121] = 121,
  [122] = 122,
  [123] = 122,
  [124] = 121,
  [125] = 122,
  [126] = 126,
  [127] = 121,
  [128] = 122,
  [129] = 126,
  [130] = 7,
  [131] = 121,
  [132] = 121,
  [133] = 126,
  [134] = 126,
  [135] = 126,
  [136] = 126,
  [137] = 122,
  [138] = 121,
  [139] = 126,
  [140] = 122,
  [141] = 121,
  [142] = 122,
  [143] = 121,
  [144] = 122,
  [145] = 122,
  [146] = 126,
  [147] = 126,
  [148] = 121,
  [149] = 121,
  [150] = 121,
  [151] = 126,
  [152] = 122,
  [153] = 122,
  [154] = 126,
  [155] = 126,
  [156] = 121,
  [157] = 121,
  [158] = 121,
  [159] = 122,
  [160] = 122,
  [161] = 126,
  [162] = 121,
  [163] = 6,
  [164] = 5,
  [165] = 8,
  [166] = 7,
  [167] = 126,
  [168] = 121,
  [169] = 6,
  [170] = 122,
  [171] = 126,
  [172] = 5,
  [173] = 122,
  [174] = 8,
  [175] = 175,
  [176] = 176,
  [177] = 175,
  [178] = 175,
  [179] = 179,
  [180] = 175,
  [181] = 175,
  [182] = 182,
  [183] = 175,
  [184] = 175,
  [185] = 185,
  [186] = 186,
  [187] = 175,
  [188] = 188,
  [189] = 189,
  [190] = 175,
  [191] = 185,
  [192] = 179,
  [193] = 175,
  [194] = 175,
  [195] = 182,
  [196] = 175,
  [197] = 175,
  [198] = 189,
  [199] = 179,
  [200] = 179,
  [201] = 175,
  [202] = 182,
  [203] = 175,
  [204] = 175,
  [205] = 205,
  [206] = 189,
  [207] = 189,
  [208] = 182,
  [209] = 7,
  [210] = 210,
  [211] = 210,
  [212] = 8,
  [213] = 5,
  [214] = 6,
  [215] = 210,
  [216] = 7,
  [217] = 8,
  [218] = 218,
  [219] = 7,
  [220] = 5,
  [221] = 8,
  [222] = 6,
  [223] = 5,
  [224] = 6,
  [225] = 6,
  [226] = 210,
  [227] = 218,
  [228] = 5,
  [229] = 8,
  [230] = 230,
  [231] = 210,
  [232] = 7,
  [233] = 6,
  [234] = 7,
  [235] = 210,
  [236] = 236,
  [237] = 8,
  [238] = 5,
  [239] = 6,
  [240] = 218,
  [241] = 5,
  [242] = 218,
  [243] = 218,
  [244] = 210,
  [245] = 5,
  [246] = 6,
  [247] = 218,
  [248] = 210,
  [249] = 8,
  [250] = 7,
  [251] = 7,
  [252] = 8,
  [253] = 6,
  [254] = 210,
  [255] = 218,
  [256] = 8,
  [257] = 218,
  [258] = 210,
  [259] = 218,
  [260] = 5,
  [261] = 210,
  [262] = 6,
  [263] = 218,
  [264] = 210,
  [265] = 8,
  [266] = 7,
  [267] = 5,
  [268] = 210,
  [269] = 7,
  [270] = 7,
  [271] = 218,
  [272] = 218,
  [273] = 218,
  [274] = 274,
  [275] = 210,
  [276] = 276,
  [277] = 8,
  [278] = 210,
  [279] = 6,
  [280] = 218,
  [281] = 6,
  [282] = 218,
  [283] = 5,
  [284] = 6,
  [285] = 8,
  [286] = 5,
  [287] = 7,
  [288] = 8,
  [289] = 7,
  [290] = 6,
  [291] = 5,
  [292] = 8,
  [293] = 5,
  [294] = 7,
  [295] = 6,
  [296] = 5,
  [297] = 8,
  [298] = 6,
  [299] = 7,
  [300] = 7,
  [301] = 8,
  [302] = 5,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 303,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 307,
  [328] = 308,
  [329] = 329,
  [330] = 320,
  [331] = 331,
  [332] = 304,
  [333] = 311,
  [334] = 312,
  [335] = 313,
  [336] = 314,
  [337] = 315,
  [338] = 316,
  [339] = 317,
  [340] = 318,
  [341] = 341,
  [342] = 342,
  [343] = 319,
  [344] = 304,
  [345] = 323,
  [346] = 324,
  [347] = 325,
  [348] = 307,
  [349] = 308,
  [350] = 350,
  [351] = 311,
  [352] = 312,
  [353] = 313,
  [354] = 314,
  [355] = 315,
  [356] = 316,
  [357] = 317,
  [358] = 318,
  [359] = 359,
  [360] = 319,
  [361] = 361,
  [362] = 323,
  [363] = 324,
  [364] = 325,
  [365] = 365,
  [366] = 307,
  [367] = 367,
  [368] = 368,
  [369] = 308,
  [370] = 350,
  [371] = 311,
  [372] = 312,
  [373] = 313,
  [374] = 374,
  [375] = 331,
  [376] = 376,
  [377] = 314,
  [378] = 315,
  [379] = 316,
  [380] = 317,
  [381] = 318,
  [382] = 382,
  [383] = 320,
  [384] = 319,
  [385] = 304,
  [386] = 386,
  [387] = 387,
  [388] = 323,
  [389] = 324,
  [390] = 325,
  [391] = 319,
  [392] = 361,
  [393] = 320,
  [394] = 307,
  [395] = 304,
  [396] = 308,
  [397] = 325,
  [398] = 321,
  [399] = 324,
  [400] = 400,
  [401] = 311,
  [402] = 312,
  [403] = 322,
  [404] = 361,
  [405] = 405,
  [406] = 309,
  [407] = 309,
  [408] = 303,
  [409] = 313,
  [410] = 326,
  [411] = 329,
  [412] = 400,
  [413] = 326,
  [414] = 314,
  [415] = 329,
  [416] = 315,
  [417] = 316,
  [418] = 400,
  [419] = 322,
  [420] = 317,
  [421] = 318,
  [422] = 322,
  [423] = 319,
  [424] = 424,
  [425] = 323,
  [426] = 324,
  [427] = 427,
  [428] = 428,
  [429] = 305,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 323,
  [434] = 434,
  [435] = 435,
  [436] = 424,
  [437] = 405,
  [438] = 325,
  [439] = 382,
  [440] = 427,
  [441] = 308,
  [442] = 307,
  [443] = 435,
  [444] = 424,
  [445] = 427,
  [446] = 428,
  [447] = 430,
  [448] = 431,
  [449] = 434,
  [450] = 432,
  [451] = 431,
  [452] = 430,
  [453] = 428,
  [454] = 427,
  [455] = 432,
  [456] = 424,
  [457] = 457,
  [458] = 308,
  [459] = 322,
  [460] = 400,
  [461] = 329,
  [462] = 326,
  [463] = 428,
  [464] = 430,
  [465] = 431,
  [466] = 432,
  [467] = 434,
  [468] = 307,
  [469] = 359,
  [470] = 376,
  [471] = 435,
  [472] = 326,
  [473] = 473,
  [474] = 311,
  [475] = 329,
  [476] = 400,
  [477] = 434,
  [478] = 312,
  [479] = 313,
  [480] = 314,
  [481] = 315,
  [482] = 316,
  [483] = 317,
  [484] = 318,
  [485] = 319,
  [486] = 457,
  [487] = 487,
  [488] = 323,
  [489] = 324,
  [490] = 325,
  [491] = 312,
  [492] = 307,
  [493] = 308,
  [494] = 405,
  [495] = 495,
  [496] = 318,
  [497] = 311,
  [498] = 435,
  [499] = 322,
  [500] = 317,
  [501] = 382,
  [502] = 312,
  [503] = 313,
  [504] = 314,
  [505] = 316,
  [506] = 424,
  [507] = 427,
  [508] = 315,
  [509] = 316,
  [510] = 317,
  [511] = 318,
  [512] = 319,
  [513] = 457,
  [514] = 323,
  [515] = 324,
  [516] = 325,
  [517] = 424,
  [518] = 359,
  [519] = 365,
  [520] = 428,
  [521] = 307,
  [522] = 308,
  [523] = 376,
  [524] = 430,
  [525] = 431,
  [526] = 303,
  [527] = 305,
  [528] = 315,
  [529] = 314,
  [530] = 311,
  [531] = 359,
  [532] = 365,
  [533] = 321,
  [534] = 457,
  [535] = 359,
  [536] = 432,
  [537] = 405,
  [538] = 434,
  [539] = 539,
  [540] = 435,
  [541] = 350,
  [542] = 331,
  [543] = 435,
  [544] = 434,
  [545] = 313,
  [546] = 318,
  [547] = 432,
  [548] = 431,
  [549] = 495,
  [550] = 550,
  [551] = 311,
  [552] = 321,
  [553] = 430,
  [554] = 428,
  [555] = 309,
  [556] = 556,
  [557] = 303,
  [558] = 305,
  [559] = 427,
  [560] = 495,
  [561] = 405,
  [562] = 424,
  [563] = 563,
  [564] = 322,
  [565] = 400,
  [566] = 329,
  [567] = 326,
  [568] = 495,
  [569] = 569,
  [570] = 361,
  [571] = 311,
  [572] = 304,
  [573] = 573,
  [574] = 320,
  [575] = 382,
  [576] = 376,
  [577] = 365,
  [578] = 359,
  [579] = 365,
  [580] = 365,
  [581] = 376,
  [582] = 382,
  [583] = 350,
  [584] = 361,
  [585] = 361,
  [586] = 457,
  [587] = 331,
  [588] = 495,
  [589] = 308,
  [590] = 325,
  [591] = 304,
  [592] = 324,
  [593] = 323,
  [594] = 320,
  [595] = 307,
  [596] = 321,
  [597] = 309,
  [598] = 303,
  [599] = 495,
  [600] = 325,
  [601] = 319,
  [602] = 318,
  [603] = 427,
  [604] = 317,
  [605] = 457,
  [606] = 324,
  [607] = 323,
  [608] = 428,
  [609] = 316,
  [610] = 610,
  [611] = 326,
  [612] = 329,
  [613] = 613,
  [614] = 315,
  [615] = 319,
  [616] = 305,
  [617] = 405,
  [618] = 405,
  [619] = 382,
  [620] = 400,
  [621] = 376,
  [622] = 322,
  [623] = 495,
  [624] = 305,
  [625] = 305,
  [626] = 303,
  [627] = 309,
  [628] = 457,
  [629] = 359,
  [630] = 321,
  [631] = 365,
  [632] = 359,
  [633] = 365,
  [634] = 303,
  [635] = 359,
  [636] = 457,
  [637] = 365,
  [638] = 405,
  [639] = 331,
  [640] = 430,
  [641] = 350,
  [642] = 424,
  [643] = 435,
  [644] = 434,
  [645] = 432,
  [646] = 427,
  [647] = 428,
  [648] = 431,
  [649] = 430,
  [650] = 317,
  [651] = 430,
  [652] = 435,
  [653] = 428,
  [654] = 427,
  [655] = 359,
  [656] = 424,
  [657] = 431,
  [658] = 658,
  [659] = 659,
  [660] = 432,
  [661] = 316,
  [662] = 434,
  [663] = 434,
  [664] = 432,
  [665] = 315,
  [666] = 431,
  [667] = 430,
  [668] = 428,
  [669] = 435,
  [670] = 431,
  [671] = 432,
  [672] = 434,
  [673] = 435,
  [674] = 427,
  [675] = 314,
  [676] = 424,
  [677] = 677,
  [678] = 405,
  [679] = 313,
  [680] = 313,
  [681] = 312,
  [682] = 682,
  [683] = 311,
  [684] = 457,
  [685] = 314,
  [686] = 322,
  [687] = 312,
  [688] = 322,
  [689] = 400,
  [690] = 329,
  [691] = 308,
  [692] = 307,
  [693] = 325,
  [694] = 324,
  [695] = 376,
  [696] = 323,
  [697] = 400,
  [698] = 316,
  [699] = 329,
  [700] = 382,
  [701] = 495,
  [702] = 326,
  [703] = 317,
  [704] = 320,
  [705] = 400,
  [706] = 361,
  [707] = 361,
  [708] = 304,
  [709] = 319,
  [710] = 710,
  [711] = 326,
  [712] = 320,
  [713] = 382,
  [714] = 318,
  [715] = 457,
  [716] = 319,
  [717] = 318,
  [718] = 382,
  [719] = 317,
  [720] = 316,
  [721] = 315,
  [722] = 323,
  [723] = 326,
  [724] = 724,
  [725] = 329,
  [726] = 400,
  [727] = 322,
  [728] = 677,
  [729] = 376,
  [730] = 314,
  [731] = 424,
  [732] = 313,
  [733] = 312,
  [734] = 427,
  [735] = 428,
  [736] = 430,
  [737] = 431,
  [738] = 311,
  [739] = 432,
  [740] = 434,
  [741] = 361,
  [742] = 435,
  [743] = 405,
  [744] = 350,
  [745] = 304,
  [746] = 320,
  [747] = 331,
  [748] = 305,
  [749] = 319,
  [750] = 303,
  [751] = 365,
  [752] = 457,
  [753] = 309,
  [754] = 321,
  [755] = 308,
  [756] = 331,
  [757] = 309,
  [758] = 359,
  [759] = 365,
  [760] = 382,
  [761] = 321,
  [762] = 309,
  [763] = 303,
  [764] = 307,
  [765] = 305,
  [766] = 325,
  [767] = 495,
  [768] = 359,
  [769] = 321,
  [770] = 314,
  [771] = 365,
  [772] = 350,
  [773] = 376,
  [774] = 305,
  [775] = 457,
  [776] = 405,
  [777] = 435,
  [778] = 359,
  [779] = 365,
  [780] = 350,
  [781] = 359,
  [782] = 331,
  [783] = 434,
  [784] = 365,
  [785] = 359,
  [786] = 365,
  [787] = 495,
  [788] = 331,
  [789] = 350,
  [790] = 457,
  [791] = 367,
  [792] = 792,
  [793] = 324,
  [794] = 323,
  [795] = 368,
  [796] = 313,
  [797] = 556,
  [798] = 495,
  [799] = 682,
  [800] = 331,
  [801] = 319,
  [802] = 359,
  [803] = 350,
  [804] = 677,
  [805] = 320,
  [806] = 304,
  [807] = 361,
  [808] = 808,
  [809] = 303,
  [810] = 810,
  [811] = 318,
  [812] = 812,
  [813] = 432,
  [814] = 431,
  [815] = 815,
  [816] = 816,
  [817] = 317,
  [818] = 376,
  [819] = 350,
  [820] = 550,
  [821] = 430,
  [822] = 808,
  [823] = 428,
  [824] = 427,
  [825] = 424,
  [826] = 316,
  [827] = 315,
  [828] = 314,
  [829] = 313,
  [830] = 322,
  [831] = 312,
  [832] = 810,
  [833] = 495,
  [834] = 329,
  [835] = 311,
  [836] = 331,
  [837] = 405,
  [838] = 326,
  [839] = 839,
  [840] = 495,
  [841] = 329,
  [842] = 573,
  [843] = 816,
  [844] = 724,
  [845] = 845,
  [846] = 846,
  [847] = 309,
  [848] = 400,
  [849] = 329,
  [850] = 308,
  [851] = 382,
  [852] = 852,
  [853] = 326,
  [854] = 812,
  [855] = 361,
  [856] = 307,
  [857] = 305,
  [858] = 303,
  [859] = 309,
  [860] = 304,
  [861] = 320,
  [862] = 325,
  [863] = 324,
  [864] = 321,
  [865] = 321,
  [866] = 323,
  [867] = 400,
  [868] = 309,
  [869] = 303,
  [870] = 305,
  [871] = 322,
  [872] = 367,
  [873] = 368,
  [874] = 810,
  [875] = 875,
  [876] = 808,
  [877] = 314,
  [878] = 556,
  [879] = 382,
  [880] = 376,
  [881] = 331,
  [882] = 424,
  [883] = 883,
  [884] = 350,
  [885] = 427,
  [886] = 326,
  [887] = 376,
  [888] = 382,
  [889] = 428,
  [890] = 430,
  [891] = 891,
  [892] = 810,
  [893] = 320,
  [894] = 724,
  [895] = 895,
  [896] = 321,
  [897] = 376,
  [898] = 318,
  [899] = 382,
  [900] = 376,
  [901] = 677,
  [902] = 331,
  [903] = 305,
  [904] = 317,
  [905] = 682,
  [906] = 309,
  [907] = 907,
  [908] = 324,
  [909] = 812,
  [910] = 325,
  [911] = 316,
  [912] = 315,
  [913] = 314,
  [914] = 431,
  [915] = 432,
  [916] = 916,
  [917] = 307,
  [918] = 434,
  [919] = 313,
  [920] = 920,
  [921] = 435,
  [922] = 312,
  [923] = 320,
  [924] = 924,
  [925] = 304,
  [926] = 311,
  [927] = 305,
  [928] = 816,
  [929] = 311,
  [930] = 307,
  [931] = 319,
  [932] = 361,
  [933] = 376,
  [934] = 350,
  [935] = 382,
  [936] = 308,
  [937] = 457,
  [938] = 816,
  [939] = 320,
  [940] = 304,
  [941] = 361,
  [942] = 350,
  [943] = 308,
  [944] = 573,
  [945] = 311,
  [946] = 318,
  [947] = 550,
  [948] = 810,
  [949] = 405,
  [950] = 812,
  [951] = 307,
  [952] = 325,
  [953] = 324,
  [954] = 816,
  [955] = 320,
  [956] = 350,
  [957] = 304,
  [958] = 495,
  [959] = 367,
  [960] = 304,
  [961] = 368,
  [962] = 405,
  [963] = 361,
  [964] = 323,
  [965] = 317,
  [966] = 303,
  [967] = 967,
  [968] = 312,
  [969] = 326,
  [970] = 556,
  [971] = 329,
  [972] = 326,
  [973] = 329,
  [974] = 400,
  [975] = 400,
  [976] = 976,
  [977] = 322,
  [978] = 322,
  [979] = 424,
  [980] = 427,
  [981] = 428,
  [982] = 424,
  [983] = 430,
  [984] = 427,
  [985] = 431,
  [986] = 432,
  [987] = 434,
  [988] = 319,
  [989] = 435,
  [990] = 331,
  [991] = 428,
  [992] = 321,
  [993] = 309,
  [994] = 361,
  [995] = 303,
  [996] = 305,
  [997] = 318,
  [998] = 312,
  [999] = 317,
  [1000] = 316,
  [1001] = 315,
  [1002] = 495,
  [1003] = 816,
  [1004] = 430,
  [1005] = 431,
  [1006] = 315,
  [1007] = 810,
  [1008] = 432,
  [1009] = 434,
  [1010] = 312,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 435,
  [1014] = 405,
  [1015] = 313,
  [1016] = 314,
  [1017] = 331,
  [1018] = 321,
  [1019] = 457,
  [1020] = 321,
  [1021] = 313,
  [1022] = 309,
  [1023] = 315,
  [1024] = 1024,
  [1025] = 316,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1054,
  [1062] = 1052,
  [1063] = 1032,
  [1064] = 1031,
  [1065] = 1030,
  [1066] = 1053,
  [1067] = 1045,
  [1068] = 1059,
  [1069] = 1058,
  [1070] = 1034,
  [1071] = 1044,
  [1072] = 1029,
  [1073] = 1056,
  [1074] = 1074,
  [1075] = 1036,
  [1076] = 1037,
  [1077] = 1038,
  [1078] = 1039,
  [1079] = 1040,
  [1080] = 1055,
  [1081] = 1041,
  [1082] = 1028,
  [1083] = 1043,
  [1084] = 1057,
  [1085] = 1046,
  [1086] = 1033,
  [1087] = 1047,
  [1088] = 1048,
  [1089] = 1049,
  [1090] = 1050,
  [1091] = 1051,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1105,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1108,
  [1110] = 1105,
  [1111] = 1108,
  [1112] = 1105,
  [1113] = 1108,
  [1114] = 1108,
  [1115] = 1107,
  [1116] = 1105,
  [1117] = 1107,
  [1118] = 1107,
  [1119] = 1107,
  [1120] = 1108,
  [1121] = 1108,
  [1122] = 1107,
  [1123] = 1107,
  [1124] = 1107,
  [1125] = 1105,
  [1126] = 1107,
  [1127] = 1108,
  [1128] = 1105,
  [1129] = 1107,
  [1130] = 1108,
  [1131] = 1107,
  [1132] = 1108,
  [1133] = 1105,
  [1134] = 1107,
  [1135] = 1105,
  [1136] = 1105,
  [1137] = 1108,
  [1138] = 1107,
  [1139] = 1105,
  [1140] = 1107,
  [1141] = 1108,
  [1142] = 1105,
  [1143] = 1108,
  [1144] = 1105,
  [1145] = 1105,
  [1146] = 1107,
  [1147] = 1108,
  [1148] = 1105,
  [1149] = 1108,
  [1150] = 1108,
  [1151] = 1107,
  [1152] = 1048,
  [1153] = 1032,
  [1154] = 1043,
  [1155] = 1055,
  [1156] = 1028,
  [1157] = 1034,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1159,
  [1161] = 1046,
  [1162] = 1041,
  [1163] = 1052,
  [1164] = 1054,
  [1165] = 1044,
  [1166] = 1051,
  [1167] = 1167,
  [1168] = 1050,
  [1169] = 1040,
  [1170] = 1056,
  [1171] = 1029,
  [1172] = 1033,
  [1173] = 1039,
  [1174] = 1049,
  [1175] = 1038,
  [1176] = 1058,
  [1177] = 1059,
  [1178] = 1047,
  [1179] = 1031,
  [1180] = 1030,
  [1181] = 1057,
  [1182] = 1053,
  [1183] = 1158,
  [1184] = 1037,
  [1185] = 1036,
  [1186] = 1045,
  [1187] = 1187,
  [1188] = 1187,
  [1189] = 1187,
  [1190] = 1187,
  [1191] = 1187,
  [1192] = 1187,
  [1193] = 1187,
  [1194] = 1187,
  [1195] = 1187,
  [1196] = 1187,
  [1197] = 1187,
  [1198] = 1187,
  [1199] = 1187,
  [1200] = 1187,
  [1201] = 1187,
  [1202] = 1053,
  [1203] = 1043,
  [1204] = 1059,
  [1205] = 1048,
  [1206] = 1031,
  [1207] = 1049,
  [1208] = 1034,
  [1209] = 1044,
  [1210] = 1050,
  [1211] = 1036,
  [1212] = 1037,
  [1213] = 1047,
  [1214] = 1029,
  [1215] = 1056,
  [1216] = 1094,
  [1217] = 1038,
  [1218] = 1030,
  [1219] = 1045,
  [1220] = 1039,
  [1221] = 1058,
  [1222] = 1040,
  [1223] = 1051,
  [1224] = 1055,
  [1225] = 1093,
  [1226] = 1052,
  [1227] = 1032,
  [1228] = 1046,
  [1229] = 1041,
  [1230] = 1033,
  [1231] = 1028,
  [1232] = 1092,
  [1233] = 1057,
  [1234] = 1054,
  [1235] = 1041,
  [1236] = 1053,
  [1237] = 1044,
  [1238] = 1049,
  [1239] = 1036,
  [1240] = 1093,
  [1241] = 1100,
  [1242] = 1045,
  [1243] = 1039,
  [1244] = 1102,
  [1245] = 1092,
  [1246] = 1103,
  [1247] = 1047,
  [1248] = 1099,
  [1249] = 1095,
  [1250] = 1030,
  [1251] = 1098,
  [1252] = 1031,
  [1253] = 1040,
  [1254] = 1032,
  [1255] = 1101,
  [1256] = 1048,
  [1257] = 1033,
  [1258] = 1059,
  [1259] = 1094,
  [1260] = 1058,
  [1261] = 1054,
  [1262] = 1038,
  [1263] = 1029,
  [1264] = 1056,
  [1265] = 1037,
  [1266] = 1097,
  [1267] = 1034,
  [1268] = 1057,
  [1269] = 1055,
  [1270] = 1043,
  [1271] = 1028,
  [1272] = 1046,
  [1273] = 1052,
  [1274] = 1051,
  [1275] = 1050,
  [1276] = 1046,
  [1277] = 1097,
  [1278] = 1101,
  [1279] = 1044,
  [1280] = 1034,
  [1281] = 1094,
  [1282] = 1099,
  [1283] = 1056,
  [1284] = 1045,
  [1285] = 1037,
  [1286] = 1055,
  [1287] = 1036,
  [1288] = 1040,
  [1289] = 1098,
  [1290] = 1029,
  [1291] = 1033,
  [1292] = 1032,
  [1293] = 1031,
  [1294] = 1039,
  [1295] = 1100,
  [1296] = 1050,
  [1297] = 1052,
  [1298] = 1051,
  [1299] = 1102,
  [1300] = 1103,
  [1301] = 1092,
  [1302] = 1041,
  [1303] = 1058,
  [1304] = 1028,
  [1305] = 1043,
  [1306] = 1057,
  [1307] = 1059,
  [1308] = 1049,
  [1309] = 1038,
  [1310] = 1048,
  [1311] = 1095,
  [1312] = 1047,
  [1313] = 1030,
  [1314] = 1093,
  [1315] = 1053,
  [1316] = 1054,
  [1317] = 1099,
  [1318] = 1098,
  [1319] = 1102,
  [1320] = 1103,
  [1321] = 1101,
  [1322] = 1095,
  [1323] = 1097,
  [1324] = 1100,
  [1325] = 1325,
  [1326] = 1052,
  [1327] = 1048,
  [1328] = 1040,
  [1329] = 1057,
  [1330] = 1036,
  [1331] = 1037,
  [1332] = 1044,
  [1333] = 1047,
  [1334] = 1041,
  [1335] = 1056,
  [1336] = 1039,
  [1337] = 1029,
  [1338] = 1058,
  [1339] = 1055,
  [1340] = 1059,
  [1341] = 1053,
  [1342] = 1043,
  [1343] = 1054,
  [1344] = 1034,
  [1345] = 1046,
  [1346] = 1033,
  [1347] = 1038,
  [1348] = 1032,
  [1349] = 1049,
  [1350] = 1051,
  [1351] = 1050,
  [1352] = 1045,
  [1353] = 1030,
  [1354] = 1031,
  [1355] = 1028,
  [1356] = 1356,
  [1357] = 1356,
  [1358] = 1356,
  [1359] = 1356,
  [1360] = 1356,
  [1361] = 1356,
  [1362] = 1356,
  [1363] = 1356,
  [1364] = 1356,
  [1365] = 1356,
  [1366] = 1356,
  [1367] = 1356,
  [1368] = 1356,
  [1369] = 1369,
  [1370] = 1356,
  [1371] = 1356,
  [1372] = 1356,
  [1373] = 1044,
  [1374] = 1038,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1051,
  [1378] = 1059,
  [1379] = 1052,
  [1380] = 1050,
  [1381] = 1046,
  [1382] = 1049,
  [1383] = 1056,
  [1384] = 1058,
  [1385] = 1385,
  [1386] = 1045,
  [1387] = 1387,
  [1388] = 1030,
  [1389] = 1048,
  [1390] = 1029,
  [1391] = 1047,
  [1392] = 1055,
  [1393] = 1028,
  [1394] = 1054,
  [1395] = 1041,
  [1396] = 1031,
  [1397] = 1032,
  [1398] = 1057,
  [1399] = 1053,
  [1400] = 1033,
  [1401] = 1037,
  [1402] = 1034,
  [1403] = 1043,
  [1404] = 1040,
  [1405] = 1039,
  [1406] = 1036,
  [1407] = 1032,
  [1408] = 1053,
  [1409] = 1050,
  [1410] = 1046,
  [1411] = 1055,
  [1412] = 1049,
  [1413] = 1054,
  [1414] = 1057,
  [1415] = 1051,
  [1416] = 1052,
  [1417] = 1048,
  [1418] = 1047,
  [1419] = 1034,
  [1420] = 1045,
  [1421] = 1059,
  [1422] = 1036,
  [1423] = 1043,
  [1424] = 1044,
  [1425] = 1033,
  [1426] = 1056,
  [1427] = 1028,
  [1428] = 1030,
  [1429] = 1031,
  [1430] = 1041,
  [1431] = 1040,
  [1432] = 1039,
  [1433] = 1058,
  [1434] = 1029,
  [1435] = 1037,
  [1436] = 1038,
  [1437] = 1437,
  [1438] = 1057,
  [1439] = 1053,
  [1440] = 1052,
  [1441] = 1046,
  [1442] = 1028,
  [1443] = 1443,
  [1444] = 1043,
  [1445] = 1437,
  [1446] = 1037,
  [1447] = 1437,
  [1448] = 1437,
  [1449] = 1055,
  [1450] = 1056,
  [1451] = 1054,
  [1452] = 1045,
  [1453] = 1059,
  [1454] = 1039,
  [1455] = 1437,
  [1456] = 1437,
  [1457] = 1058,
  [1458] = 1029,
  [1459] = 1437,
  [1460] = 1040,
  [1461] = 1047,
  [1462] = 1437,
  [1463] = 1437,
  [1464] = 1038,
  [1465] = 1051,
  [1466] = 1437,
  [1467] = 1437,
  [1468] = 1030,
  [1469] = 1031,
  [1470] = 1032,
  [1471] = 1437,
  [1472] = 1033,
  [1473] = 1437,
  [1474] = 1048,
  [1475] = 1036,
  [1476] = 1437,
  [1477] = 1049,
  [1478] = 1041,
  [1479] = 1437,
  [1480] = 1034,
  [1481] = 1044,
  [1482] = 1437,
  [1483] = 1050,
  [1484] = 1044,
  [1485] = 1032,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1028,
  [1489] = 1487,
  [1490] = 1038,
  [1491] = 1043,
  [1492] = 1034,
  [1493] = 1046,
  [1494] = 1487,
  [1495] = 1052,
  [1496] = 1051,
  [1497] = 1057,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1050,
  [1501] = 1049,
  [1502] = 1048,
  [1503] = 1055,
  [1504] = 1054,
  [1505] = 1047,
  [1506] = 1047,
  [1507] = 1054,
  [1508] = 1056,
  [1509] = 1057,
  [1510] = 1043,
  [1511] = 1029,
  [1512] = 1058,
  [1513] = 1028,
  [1514] = 1041,
  [1515] = 1040,
  [1516] = 1049,
  [1517] = 1055,
  [1518] = 1059,
  [1519] = 1053,
  [1520] = 1039,
  [1521] = 1048,
  [1522] = 1038,
  [1523] = 1039,
  [1524] = 1487,
  [1525] = 1037,
  [1526] = 1037,
  [1527] = 1487,
  [1528] = 1036,
  [1529] = 1036,
  [1530] = 1499,
  [1531] = 1487,
  [1532] = 1487,
  [1533] = 1052,
  [1534] = 1046,
  [1535] = 1059,
  [1536] = 1487,
  [1537] = 1487,
  [1538] = 1045,
  [1539] = 1030,
  [1540] = 1040,
  [1541] = 1031,
  [1542] = 1542,
  [1543] = 1032,
  [1544] = 1033,
  [1545] = 1033,
  [1546] = 1030,
  [1547] = 1053,
  [1548] = 1034,
  [1549] = 1044,
  [1550] = 1031,
  [1551] = 1034,
  [1552] = 1030,
  [1553] = 1044,
  [1554] = 1045,
  [1555] = 1487,
  [1556] = 1056,
  [1557] = 1029,
  [1558] = 1558,
  [1559] = 1058,
  [1560] = 1498,
  [1561] = 1059,
  [1562] = 1487,
  [1563] = 1053,
  [1564] = 1036,
  [1565] = 1487,
  [1566] = 1042,
  [1567] = 1498,
  [1568] = 1499,
  [1569] = 1569,
  [1570] = 1499,
  [1571] = 1498,
  [1572] = 1487,
  [1573] = 1037,
  [1574] = 1038,
  [1575] = 1041,
  [1576] = 1039,
  [1577] = 1040,
  [1578] = 1487,
  [1579] = 1033,
  [1580] = 1041,
  [1581] = 1051,
  [1582] = 1487,
  [1583] = 1028,
  [1584] = 1043,
  [1585] = 1045,
  [1586] = 1499,
  [1587] = 1050,
  [1588] = 1032,
  [1589] = 1031,
  [1590] = 1058,
  [1591] = 1057,
  [1592] = 1035,
  [1593] = 1054,
  [1594] = 1047,
  [1595] = 1487,
  [1596] = 1048,
  [1597] = 1049,
  [1598] = 1050,
  [1599] = 1051,
  [1600] = 1052,
  [1601] = 1046,
  [1602] = 1055,
  [1603] = 1498,
  [1604] = 1056,
  [1605] = 1029,
  [1606] = 1606,
  [1607] = 1060,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1031,
  [1613] = 1613,
  [1614] = 1052,
  [1615] = 1047,
  [1616] = 1051,
  [1617] = 1029,
  [1618] = 1058,
  [1619] = 1619,
  [1620] = 1611,
  [1621] = 1613,
  [1622] = 1059,
  [1623] = 1050,
  [1624] = 1611,
  [1625] = 1619,
  [1626] = 1049,
  [1627] = 1611,
  [1628] = 1043,
  [1629] = 1057,
  [1630] = 1048,
  [1631] = 1054,
  [1632] = 1047,
  [1633] = 1611,
  [1634] = 1029,
  [1635] = 1054,
  [1636] = 1057,
  [1637] = 1043,
  [1638] = 1638,
  [1639] = 1619,
  [1640] = 1611,
  [1641] = 1619,
  [1642] = 1053,
  [1643] = 1038,
  [1644] = 1644,
  [1645] = 1028,
  [1646] = 1619,
  [1647] = 1041,
  [1648] = 1638,
  [1649] = 1028,
  [1650] = 1040,
  [1651] = 1041,
  [1652] = 1056,
  [1653] = 1074,
  [1654] = 1046,
  [1655] = 1040,
  [1656] = 1619,
  [1657] = 1058,
  [1658] = 1059,
  [1659] = 1053,
  [1660] = 1039,
  [1661] = 1038,
  [1662] = 1037,
  [1663] = 1611,
  [1664] = 1611,
  [1665] = 1619,
  [1666] = 1644,
  [1667] = 1039,
  [1668] = 1045,
  [1669] = 1030,
  [1670] = 1031,
  [1671] = 1032,
  [1672] = 1033,
  [1673] = 1034,
  [1674] = 1037,
  [1675] = 1056,
  [1676] = 1048,
  [1677] = 1049,
  [1678] = 1619,
  [1679] = 1044,
  [1680] = 1050,
  [1681] = 1055,
  [1682] = 1036,
  [1683] = 1611,
  [1684] = 1611,
  [1685] = 1619,
  [1686] = 1619,
  [1687] = 1619,
  [1688] = 1611,
  [1689] = 1611,
  [1690] = 1690,
  [1691] = 1611,
  [1692] = 1619,
  [1693] = 1045,
  [1694] = 1619,
  [1695] = 1619,
  [1696] = 1046,
  [1697] = 1052,
  [1698] = 1611,
  [1699] = 1611,
  [1700] = 1055,
  [1701] = 1036,
  [1702] = 1051,
  [1703] = 1619,
  [1704] = 1619,
  [1705] = 1044,
  [1706] = 1030,
  [1707] = 1034,
  [1708] = 1032,
  [1709] = 1033,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1712,
  [1714] = 1712,
  [1715] = 1712,
  [1716] = 1716,
  [1717] = 1716,
  [1718] = 1711,
  [1719] = 1710,
  [1720] = 1720,
  [1721] = 1721,
  [1722] = 1716,
  [1723] = 1710,
  [1724] = 1724,
  [1725] = 1710,
  [1726] = 1710,
  [1727] = 1724,
  [1728] = 1711,
  [1729] = 1724,
  [1730] = 1724,
  [1731] = 1724,
  [1732] = 1711,
  [1733] = 1733,
  [1734] = 1710,
  [1735] = 1724,
  [1736] = 1711,
  [1737] = 1737,
  [1738] = 1712,
  [1739] = 1724,
  [1740] = 1724,
  [1741] = 1711,
  [1742] = 1711,
  [1743] = 1711,
  [1744] = 1724,
  [1745] = 1712,
  [1746] = 1710,
  [1747] = 1712,
  [1748] = 1711,
  [1749] = 1724,
  [1750] = 1710,
  [1751] = 1710,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1710,
  [1755] = 1724,
  [1756] = 1724,
  [1757] = 1724,
  [1758] = 1724,
  [1759] = 1711,
  [1760] = 1710,
  [1761] = 1712,
  [1762] = 1710,
  [1763] = 1711,
  [1764] = 1712,
  [1765] = 1711,
  [1766] = 1712,
  [1767] = 1710,
  [1768] = 1712,
  [1769] = 1712,
  [1770] = 1711,
  [1771] = 1724,
  [1772] = 1724,
  [1773] = 1710,
  [1774] = 1711,
  [1775] = 1712,
  [1776] = 1710,
  [1777] = 1710,
  [1778] = 1711,
  [1779] = 1712,
  [1780] = 1712,
  [1781] = 1711,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1094,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1094,
  [1789] = 1789,
  [1790] = 1613,
  [1791] = 1791,
  [1792] = 1093,
  [1793] = 1093,
  [1794] = 1042,
  [1795] = 1795,
  [1796] = 1638,
  [1797] = 1644,
  [1798] = 1092,
  [1799] = 1035,
  [1800] = 1092,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1802,
  [1804] = 1804,
  [1805] = 1802,
  [1806] = 1804,
  [1807] = 1802,
  [1808] = 1804,
  [1809] = 1802,
  [1810] = 1804,
  [1811] = 1802,
  [1812] = 1804,
  [1813] = 1802,
  [1814] = 1804,
  [1815] = 1802,
  [1816] = 1804,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1802,
  [1827] = 1804,
  [1828] = 1802,
  [1829] = 1804,
  [1830] = 1802,
  [1831] = 1804,
  [1832] = 1802,
  [1833] = 1804,
  [1834] = 1802,
  [1835] = 1801,
  [1836] = 1801,
  [1837] = 1817,
  [1838] = 1818,
  [1839] = 1819,
  [1840] = 1820,
  [1841] = 1821,
  [1842] = 1822,
  [1843] = 1823,
  [1844] = 1824,
  [1845] = 1825,
  [1846] = 1804,
  [1847] = 1817,
  [1848] = 1802,
  [1849] = 1818,
  [1850] = 1804,
  [1851] = 1802,
  [1852] = 1804,
  [1853] = 1802,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 1804,
  [1857] = 1817,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1825,
  [1861] = 1824,
  [1862] = 1823,
  [1863] = 1822,
  [1864] = 1818,
  [1865] = 1817,
  [1866] = 1801,
  [1867] = 1825,
  [1868] = 1824,
  [1869] = 1823,
  [1870] = 1822,
  [1871] = 1820,
  [1872] = 1819,
  [1873] = 1819,
  [1874] = 1818,
  [1875] = 1817,
  [1876] = 1801,
  [1877] = 1825,
  [1878] = 1824,
  [1879] = 1823,
  [1880] = 1822,
  [1881] = 1821,
  [1882] = 1820,
  [1883] = 1819,
  [1884] = 1818,
  [1885] = 1818,
  [1886] = 1817,
  [1887] = 1801,
  [1888] = 1825,
  [1889] = 1824,
  [1890] = 1823,
  [1891] = 1822,
  [1892] = 1821,
  [1893] = 1820,
  [1894] = 1819,
  [1895] = 1818,
  [1896] = 1821,
  [1897] = 1801,
  [1898] = 1825,
  [1899] = 1824,
  [1900] = 1823,
  [1901] = 1822,
  [1902] = 1821,
  [1903] = 1820,
  [1904] = 1819,
  [1905] = 1905,
  [1906] = 1818,
  [1907] = 1817,
  [1908] = 1801,
  [1909] = 1825,
  [1910] = 1824,
  [1911] = 1823,
  [1912] = 1822,
  [1913] = 1817,
  [1914] = 1821,
  [1915] = 1820,
  [1916] = 1820,
  [1917] = 1819,
  [1918] = 1818,
  [1919] = 1819,
  [1920] = 1820,
  [1921] = 1817,
  [1922] = 1822,
  [1923] = 1821,
  [1924] = 1822,
  [1925] = 1823,
  [1926] = 1824,
  [1927] = 1823,
  [1928] = 1825,
  [1929] = 1801,
  [1930] = 1817,
  [1931] = 1818,
  [1932] = 1819,
  [1933] = 1820,
  [1934] = 1821,
  [1935] = 1822,
  [1936] = 1823,
  [1937] = 1824,
  [1938] = 1825,
  [1939] = 1801,
  [1940] = 1817,
  [1941] = 1941,
  [1942] = 1818,
  [1943] = 1819,
  [1944] = 1820,
  [1945] = 1821,
  [1946] = 1822,
  [1947] = 1823,
  [1948] = 1824,
  [1949] = 1825,
  [1950] = 1801,
  [1951] = 1817,
  [1952] = 1952,
  [1953] = 1818,
  [1954] = 1819,
  [1955] = 1820,
  [1956] = 1821,
  [1957] = 1822,
  [1958] = 1823,
  [1959] = 1824,
  [1960] = 1825,
  [1961] = 1801,
  [1962] = 1817,
  [1963] = 1801,
  [1964] = 1818,
  [1965] = 1819,
  [1966] = 1820,
  [1967] = 1967,
  [1968] = 1821,
  [1969] = 1822,
  [1970] = 1825,
  [1971] = 1823,
  [1972] = 1824,
  [1973] = 1825,
  [1974] = 1801,
  [1975] = 1817,
  [1976] = 1818,
  [1977] = 1819,
  [1978] = 1820,
  [1979] = 1821,
  [1980] = 1980,
  [1981] = 1822,
  [1982] = 1823,
  [1983] = 1824,
  [1984] = 1825,
  [1985] = 1801,
  [1986] = 1821,
  [1987] = 1818,
  [1988] = 1819,
  [1989] = 1820,
  [1990] = 1821,
  [1991] = 1822,
  [1992] = 1823,
  [1993] = 1824,
  [1994] = 1825,
  [1995] = 1801,
  [1996] = 1817,
  [1997] = 1824,
  [1998] = 1998,
  [1999] = 1999,
  [2000] = 2000,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 2007,
  [2008] = 2008,
  [2009] = 2008,
  [2010] = 2008,
  [2011] = 2008,
  [2012] = 2012,
  [2013] = 2012,
  [2014] = 2014,
  [2015] = 2014,
  [2016] = 2014,
  [2017] = 2004,
  [2018] = 1999,
  [2019] = 2007,
  [2020] = 2005,
  [2021] = 2000,
  [2022] = 2003,
  [2023] = 2006,
  [2024] = 2001,
  [2025] = 2025,
  [2026] = 2002,
  [2027] = 2005,
  [2028] = 2004,
  [2029] = 2002,
  [2030] = 2007,
  [2031] = 2006,
  [2032] = 1999,
  [2033] = 2001,
  [2034] = 2003,
  [2035] = 2000,
  [2036] = 2005,
  [2037] = 2002,
  [2038] = 2007,
  [2039] = 2006,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2002,
  [2043] = 2000,
  [2044] = 2004,
  [2045] = 2002,
  [2046] = 2003,
  [2047] = 2001,
  [2048] = 1999,
  [2049] = 2049,
  [2050] = 2040,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 2090,
  [2091] = 2091,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2098,
  [2099] = 2099,
  [2100] = 2100,
  [2101] = 2101,
  [2102] = 2102,
  [2103] = 2103,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2134,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2137,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 2144,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2149,
  [2150] = 2150,
  [2151] = 2116,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2157,
  [2158] = 2158,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2164,
  [2165] = 2165,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2168,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2128,
  [2175] = 2175,
  [2176] = 2176,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2118,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2191,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2115,
  [2197] = 2197,
  [2198] = 2041,
  [2199] = 2136,
  [2200] = 2137,
  [2201] = 2133,
  [2202] = 2130,
  [2203] = 2129,
  [2204] = 2134,
  [2205] = 2135,
  [2206] = 2132,
  [2207] = 2131,
  [2208] = 2192,
  [2209] = 2161,
  [2210] = 2195,
  [2211] = 2194,
  [2212] = 2193,
  [2213] = 2185,
  [2214] = 2191,
  [2215] = 2190,
  [2216] = 2189,
  [2217] = 2187,
  [2218] = 2197,
  [2219] = 2041,
  [2220] = 2142,
  [2221] = 2183,
  [2222] = 2186,
  [2223] = 2181,
  [2224] = 2180,
  [2225] = 2173,
  [2226] = 2179,
  [2227] = 2178,
  [2228] = 2177,
  [2229] = 2176,
  [2230] = 2175,
  [2231] = 2149,
  [2232] = 2143,
  [2233] = 2171,
  [2234] = 2170,
  [2235] = 2182,
  [2236] = 2168,
  [2237] = 2167,
  [2238] = 2166,
  [2239] = 2165,
  [2240] = 2164,
  [2241] = 2163,
  [2242] = 2162,
  [2243] = 2140,
  [2244] = 2160,
  [2245] = 2159,
  [2246] = 2158,
  [2247] = 2157,
  [2248] = 2156,
  [2249] = 2152,
  [2250] = 2155,
  [2251] = 2154,
  [2252] = 2153,
  [2253] = 2169,
  [2254] = 2188,
  [2255] = 2138,
  [2256] = 2150,
  [2257] = 2139,
  [2258] = 2148,
  [2259] = 2147,
  [2260] = 2146,
  [2261] = 2145,
  [2262] = 2144,
  [2263] = 2172,
  [2264] = 2141,
  [2265] = 2040,
  [2266] = 2115,
  [2267] = 2116,
  [2268] = 2128,
  [2269] = 2118,
  [2270] = 2129,
  [2271] = 2134,
  [2272] = 2133,
  [2273] = 2041,
  [2274] = 2132,
  [2275] = 2137,
  [2276] = 2136,
  [2277] = 2131,
  [2278] = 2130,
  [2279] = 2135,
  [2280] = 2195,
  [2281] = 2167,
  [2282] = 2193,
  [2283] = 2185,
  [2284] = 2146,
  [2285] = 2147,
  [2286] = 2148,
  [2287] = 2192,
  [2288] = 2139,
  [2289] = 2150,
  [2290] = 2140,
  [2291] = 2191,
  [2292] = 2190,
  [2293] = 2138,
  [2294] = 2188,
  [2295] = 2141,
  [2296] = 2153,
  [2297] = 2161,
  [2298] = 2172,
  [2299] = 2155,
  [2300] = 2152,
  [2301] = 2156,
  [2302] = 2157,
  [2303] = 2154,
  [2304] = 2158,
  [2305] = 2159,
  [2306] = 2197,
  [2307] = 2194,
  [2308] = 2187,
  [2309] = 2160,
  [2310] = 2145,
  [2311] = 2162,
  [2312] = 2163,
  [2313] = 2164,
  [2314] = 2165,
  [2315] = 2189,
  [2316] = 2166,
  [2317] = 2142,
  [2318] = 2168,
  [2319] = 2176,
  [2320] = 2169,
  [2321] = 2170,
  [2322] = 2171,
  [2323] = 2143,
  [2324] = 2149,
  [2325] = 2186,
  [2326] = 2144,
  [2327] = 2175,
  [2328] = 2177,
  [2329] = 2178,
  [2330] = 2179,
  [2331] = 2180,
  [2332] = 2181,
  [2333] = 2182,
  [2334] = 2183,
  [2335] = 2173,
  [2336] = 2040,
  [2337] = 2040,
  [2338] = 2040,
  [2339] = 2128,
  [2340] = 2116,
  [2341] = 2118,
  [2342] = 2115,
  [2343] = 2136,
  [2344] = 2128,
  [2345] = 2118,
  [2346] = 2116,
  [2347] = 2115,
  [2348] = 2134,
  [2349] = 2137,
  [2350] = 2133,
  [2351] = 2129,
  [2352] = 2135,
  [2353] = 2130,
  [2354] = 2132,
  [2355] = 2131,
  [2356] = 2138,
  [2357] = 2157,
  [2358] = 2197,
  [2359] = 2195,
  [2360] = 2116,
  [2361] = 2136,
  [2362] = 2133,
  [2363] = 2193,
  [2364] = 2192,
  [2365] = 2191,
  [2366] = 2190,
  [2367] = 2179,
  [2368] = 2131,
  [2369] = 2186,
  [2370] = 2173,
  [2371] = 2115,
  [2372] = 2140,
  [2373] = 2141,
  [2374] = 2172,
  [2375] = 2144,
  [2376] = 2145,
  [2377] = 2189,
  [2378] = 2146,
  [2379] = 2147,
  [2380] = 2148,
  [2381] = 2139,
  [2382] = 2150,
  [2383] = 2188,
  [2384] = 2185,
  [2385] = 2153,
  [2386] = 2154,
  [2387] = 2130,
  [2388] = 2155,
  [2389] = 2152,
  [2390] = 2156,
  [2391] = 2128,
  [2392] = 2135,
  [2393] = 2158,
  [2394] = 2187,
  [2395] = 2129,
  [2396] = 2137,
  [2397] = 2159,
  [2398] = 2177,
  [2399] = 2041,
  [2400] = 2142,
  [2401] = 2134,
  [2402] = 2183,
  [2403] = 2160,
  [2404] = 2161,
  [2405] = 2162,
  [2406] = 2182,
  [2407] = 2163,
  [2408] = 2164,
  [2409] = 2181,
  [2410] = 2165,
  [2411] = 2180,
  [2412] = 2166,
  [2413] = 2194,
  [2414] = 2178,
  [2415] = 2118,
  [2416] = 2167,
  [2417] = 2168,
  [2418] = 2169,
  [2419] = 2170,
  [2420] = 2171,
  [2421] = 2143,
  [2422] = 2149,
  [2423] = 2132,
  [2424] = 2175,
  [2425] = 2176,
  [2426] = 2135,
  [2427] = 2132,
  [2428] = 2156,
  [2429] = 2157,
  [2430] = 2188,
  [2431] = 2158,
  [2432] = 2159,
  [2433] = 2163,
  [2434] = 2434,
  [2435] = 2164,
  [2436] = 2138,
  [2437] = 2166,
  [2438] = 2150,
  [2439] = 2139,
  [2440] = 2148,
  [2441] = 2434,
  [2442] = 2147,
  [2443] = 2130,
  [2444] = 2197,
  [2445] = 2434,
  [2446] = 2195,
  [2447] = 2194,
  [2448] = 2193,
  [2449] = 2192,
  [2450] = 2191,
  [2451] = 2190,
  [2452] = 2189,
  [2453] = 2434,
  [2454] = 2187,
  [2455] = 2434,
  [2456] = 2146,
  [2457] = 2171,
  [2458] = 2143,
  [2459] = 2434,
  [2460] = 2149,
  [2461] = 2175,
  [2462] = 2434,
  [2463] = 2434,
  [2464] = 2176,
  [2465] = 2177,
  [2466] = 2183,
  [2467] = 2182,
  [2468] = 2181,
  [2469] = 2180,
  [2470] = 2178,
  [2471] = 2179,
  [2472] = 2185,
  [2473] = 2131,
  [2474] = 2144,
  [2475] = 2172,
  [2476] = 2141,
  [2477] = 2140,
  [2478] = 2173,
  [2479] = 2186,
  [2480] = 2170,
  [2481] = 2434,
  [2482] = 2142,
  [2483] = 2129,
  [2484] = 2152,
  [2485] = 2434,
  [2486] = 2145,
  [2487] = 2137,
  [2488] = 2434,
  [2489] = 2169,
  [2490] = 2434,
  [2491] = 2136,
  [2492] = 2041,
  [2493] = 2434,
  [2494] = 2153,
  [2495] = 2154,
  [2496] = 2134,
  [2497] = 2155,
  [2498] = 2133,
  [2499] = 2168,
  [2500] = 2167,
  [2501] = 2434,
  [2502] = 2162,
  [2503] = 2434,
  [2504] = 2434,
  [2505] = 2161,
  [2506] = 2160,
  [2507] = 2165,
  [2508] = 2155,
  [2509] = 2188,
  [2510] = 2145,
  [2511] = 2157,
  [2512] = 2156,
  [2513] = 2168,
  [2514] = 2187,
  [2515] = 2144,
  [2516] = 2172,
  [2517] = 2189,
  [2518] = 2190,
  [2519] = 2146,
  [2520] = 2147,
  [2521] = 2142,
  [2522] = 2169,
  [2523] = 2185,
  [2524] = 2179,
  [2525] = 2178,
  [2526] = 2177,
  [2527] = 2176,
  [2528] = 2175,
  [2529] = 2149,
  [2530] = 2143,
  [2531] = 2171,
  [2532] = 2170,
  [2533] = 2166,
  [2534] = 2164,
  [2535] = 2186,
  [2536] = 2148,
  [2537] = 2139,
  [2538] = 2163,
  [2539] = 2191,
  [2540] = 2150,
  [2541] = 2138,
  [2542] = 2041,
  [2543] = 2192,
  [2544] = 2173,
  [2545] = 2154,
  [2546] = 2158,
  [2547] = 2167,
  [2548] = 2160,
  [2549] = 2161,
  [2550] = 2152,
  [2551] = 2183,
  [2552] = 2162,
  [2553] = 2159,
  [2554] = 2141,
  [2555] = 2182,
  [2556] = 2197,
  [2557] = 2195,
  [2558] = 2194,
  [2559] = 2181,
  [2560] = 2140,
  [2561] = 2153,
  [2562] = 2193,
  [2563] = 2165,
  [2564] = 2180,
  [2565] = 2040,
  [2566] = 2040,
  [2567] = 2567,
  [2568] = 2128,
  [2569] = 2118,
  [2570] = 2116,
  [2571] = 2115,
  [2572] = 2040,
  [2573] = 2132,
  [2574] = 2040,
  [2575] = 2130,
  [2576] = 2129,
  [2577] = 2134,
  [2578] = 2135,
  [2579] = 2131,
  [2580] = 2137,
  [2581] = 2133,
  [2582] = 2582,
  [2583] = 2136,
  [2584] = 2155,
  [2585] = 2144,
  [2586] = 2193,
  [2587] = 2141,
  [2588] = 2140,
  [2589] = 2115,
  [2590] = 2149,
  [2591] = 2138,
  [2592] = 2168,
  [2593] = 2176,
  [2594] = 2143,
  [2595] = 2169,
  [2596] = 2171,
  [2597] = 2128,
  [2598] = 2167,
  [2599] = 2192,
  [2600] = 2194,
  [2601] = 2040,
  [2602] = 2040,
  [2603] = 2183,
  [2604] = 2195,
  [2605] = 2040,
  [2606] = 2197,
  [2607] = 2182,
  [2608] = 2165,
  [2609] = 2162,
  [2610] = 2118,
  [2611] = 2145,
  [2612] = 2185,
  [2613] = 2153,
  [2614] = 2170,
  [2615] = 2181,
  [2616] = 2191,
  [2617] = 2159,
  [2618] = 2190,
  [2619] = 2158,
  [2620] = 2154,
  [2621] = 2189,
  [2622] = 2116,
  [2623] = 2175,
  [2624] = 2142,
  [2625] = 2172,
  [2626] = 2164,
  [2627] = 2157,
  [2628] = 2139,
  [2629] = 2156,
  [2630] = 2186,
  [2631] = 2180,
  [2632] = 2163,
  [2633] = 2188,
  [2634] = 2173,
  [2635] = 2146,
  [2636] = 2161,
  [2637] = 2160,
  [2638] = 2187,
  [2639] = 2148,
  [2640] = 2041,
  [2641] = 2166,
  [2642] = 2179,
  [2643] = 2178,
  [2644] = 2150,
  [2645] = 2152,
  [2646] = 2147,
  [2647] = 2177,
  [2648] = 2128,
  [2649] = 2115,
  [2650] = 2136,
  [2651] = 2129,
  [2652] = 2130,
  [2653] = 2134,
  [2654] = 2654,
  [2655] = 2118,
  [2656] = 2135,
  [2657] = 2131,
  [2658] = 2132,
  [2659] = 2137,
  [2660] = 2116,
  [2661] = 2133,
  [2662] = 2040,
  [2663] = 2190,
  [2664] = 2131,
  [2665] = 2186,
  [2666] = 2173,
  [2667] = 2197,
  [2668] = 2140,
  [2669] = 2141,
  [2670] = 2172,
  [2671] = 2144,
  [2672] = 2146,
  [2673] = 2195,
  [2674] = 2132,
  [2675] = 2194,
  [2676] = 2147,
  [2677] = 2148,
  [2678] = 2139,
  [2679] = 2171,
  [2680] = 2133,
  [2681] = 2138,
  [2682] = 2145,
  [2683] = 2149,
  [2684] = 2188,
  [2685] = 2136,
  [2686] = 2193,
  [2687] = 2143,
  [2688] = 2191,
  [2689] = 2177,
  [2690] = 2178,
  [2691] = 2142,
  [2692] = 2134,
  [2693] = 2152,
  [2694] = 2179,
  [2695] = 2166,
  [2696] = 2164,
  [2697] = 2115,
  [2698] = 2189,
  [2699] = 2163,
  [2700] = 2187,
  [2701] = 2185,
  [2702] = 2130,
  [2703] = 2703,
  [2704] = 2170,
  [2705] = 2156,
  [2706] = 2169,
  [2707] = 2192,
  [2708] = 2153,
  [2709] = 2157,
  [2710] = 2154,
  [2711] = 2128,
  [2712] = 2118,
  [2713] = 2183,
  [2714] = 2182,
  [2715] = 2041,
  [2716] = 2135,
  [2717] = 2129,
  [2718] = 2175,
  [2719] = 2159,
  [2720] = 2176,
  [2721] = 2158,
  [2722] = 2137,
  [2723] = 2181,
  [2724] = 2040,
  [2725] = 2116,
  [2726] = 2155,
  [2727] = 2162,
  [2728] = 2167,
  [2729] = 2150,
  [2730] = 2160,
  [2731] = 2165,
  [2732] = 2168,
  [2733] = 2180,
  [2734] = 2161,
  [2735] = 2155,
  [2736] = 2154,
  [2737] = 2153,
  [2738] = 2115,
  [2739] = 2142,
  [2740] = 2128,
  [2741] = 2115,
  [2742] = 2160,
  [2743] = 2161,
  [2744] = 2744,
  [2745] = 2744,
  [2746] = 2163,
  [2747] = 2744,
  [2748] = 2744,
  [2749] = 2145,
  [2750] = 2159,
  [2751] = 2118,
  [2752] = 2164,
  [2753] = 2158,
  [2754] = 2744,
  [2755] = 2744,
  [2756] = 2744,
  [2757] = 2157,
  [2758] = 2156,
  [2759] = 2152,
  [2760] = 2166,
  [2761] = 2744,
  [2762] = 2744,
  [2763] = 2162,
  [2764] = 2744,
  [2765] = 2132,
  [2766] = 2165,
  [2767] = 2137,
  [2768] = 2116,
  [2769] = 2744,
  [2770] = 2744,
  [2771] = 2129,
  [2772] = 2188,
  [2773] = 2138,
  [2774] = 2167,
  [2775] = 2168,
  [2776] = 2150,
  [2777] = 2777,
  [2778] = 2139,
  [2779] = 2115,
  [2780] = 2744,
  [2781] = 2148,
  [2782] = 2135,
  [2783] = 2147,
  [2784] = 2131,
  [2785] = 2133,
  [2786] = 2177,
  [2787] = 2171,
  [2788] = 2146,
  [2789] = 2128,
  [2790] = 2130,
  [2791] = 2169,
  [2792] = 2143,
  [2793] = 2175,
  [2794] = 2176,
  [2795] = 2118,
  [2796] = 2116,
  [2797] = 2144,
  [2798] = 2172,
  [2799] = 2170,
  [2800] = 2149,
  [2801] = 2180,
  [2802] = 2141,
  [2803] = 2140,
  [2804] = 2181,
  [2805] = 2182,
  [2806] = 2183,
  [2807] = 2134,
  [2808] = 2128,
  [2809] = 2173,
  [2810] = 2744,
  [2811] = 2744,
  [2812] = 2116,
  [2813] = 2118,
  [2814] = 2185,
  [2815] = 2179,
  [2816] = 2187,
  [2817] = 2136,
  [2818] = 2178,
  [2819] = 2197,
  [2820] = 2186,
  [2821] = 2195,
  [2822] = 2194,
  [2823] = 2193,
  [2824] = 2192,
  [2825] = 2041,
  [2826] = 2191,
  [2827] = 2190,
  [2828] = 2189,
  [2829] = 2159,
  [2830] = 2134,
  [2831] = 2134,
  [2832] = 2137,
  [2833] = 2129,
  [2834] = 2135,
  [2835] = 2130,
  [2836] = 2136,
  [2837] = 2172,
  [2838] = 2141,
  [2839] = 2197,
  [2840] = 2195,
  [2841] = 2140,
  [2842] = 2173,
  [2843] = 2186,
  [2844] = 2194,
  [2845] = 2192,
  [2846] = 2132,
  [2847] = 2191,
  [2848] = 2136,
  [2849] = 2190,
  [2850] = 2131,
  [2851] = 2131,
  [2852] = 2041,
  [2853] = 2133,
  [2854] = 2144,
  [2855] = 2145,
  [2856] = 2146,
  [2857] = 2189,
  [2858] = 2187,
  [2859] = 2147,
  [2860] = 2135,
  [2861] = 2183,
  [2862] = 2132,
  [2863] = 2182,
  [2864] = 2181,
  [2865] = 2180,
  [2866] = 2179,
  [2867] = 2148,
  [2868] = 2139,
  [2869] = 2178,
  [2870] = 2177,
  [2871] = 2176,
  [2872] = 2129,
  [2873] = 2175,
  [2874] = 2193,
  [2875] = 2134,
  [2876] = 2876,
  [2877] = 2149,
  [2878] = 2133,
  [2879] = 2171,
  [2880] = 2170,
  [2881] = 2143,
  [2882] = 2137,
  [2883] = 2150,
  [2884] = 2136,
  [2885] = 2131,
  [2886] = 2169,
  [2887] = 2168,
  [2888] = 2138,
  [2889] = 2188,
  [2890] = 2153,
  [2891] = 2154,
  [2892] = 2155,
  [2893] = 2152,
  [2894] = 2167,
  [2895] = 2161,
  [2896] = 2162,
  [2897] = 2163,
  [2898] = 2156,
  [2899] = 2157,
  [2900] = 2164,
  [2901] = 2130,
  [2902] = 2130,
  [2903] = 2165,
  [2904] = 2158,
  [2905] = 2142,
  [2906] = 2166,
  [2907] = 2137,
  [2908] = 2133,
  [2909] = 2185,
  [2910] = 2132,
  [2911] = 2129,
  [2912] = 2135,
  [2913] = 2160,
  [2914] = 2164,
  [2915] = 2170,
  [2916] = 2163,
  [2917] = 2115,
  [2918] = 2193,
  [2919] = 2165,
  [2920] = 2166,
  [2921] = 2166,
  [2922] = 2194,
  [2923] = 2164,
  [2924] = 2167,
  [2925] = 2163,
  [2926] = 2191,
  [2927] = 2168,
  [2928] = 2195,
  [2929] = 2118,
  [2930] = 2169,
  [2931] = 2041,
  [2932] = 2170,
  [2933] = 2171,
  [2934] = 2143,
  [2935] = 2149,
  [2936] = 2175,
  [2937] = 2159,
  [2938] = 2158,
  [2939] = 2176,
  [2940] = 2177,
  [2941] = 2178,
  [2942] = 2179,
  [2943] = 2157,
  [2944] = 2156,
  [2945] = 2152,
  [2946] = 2179,
  [2947] = 2180,
  [2948] = 2181,
  [2949] = 2182,
  [2950] = 2183,
  [2951] = 2185,
  [2952] = 2188,
  [2953] = 2138,
  [2954] = 2150,
  [2955] = 2139,
  [2956] = 2148,
  [2957] = 2147,
  [2958] = 2958,
  [2959] = 2146,
  [2960] = 2116,
  [2961] = 2162,
  [2962] = 2145,
  [2963] = 2187,
  [2964] = 2161,
  [2965] = 2189,
  [2966] = 2144,
  [2967] = 2172,
  [2968] = 2141,
  [2969] = 2140,
  [2970] = 2160,
  [2971] = 2190,
  [2972] = 2173,
  [2973] = 2186,
  [2974] = 2142,
  [2975] = 2191,
  [2976] = 2192,
  [2977] = 2193,
  [2978] = 2194,
  [2979] = 2195,
  [2980] = 2197,
  [2981] = 2188,
  [2982] = 2154,
  [2983] = 2178,
  [2984] = 2159,
  [2985] = 2145,
  [2986] = 2158,
  [2987] = 2171,
  [2988] = 2153,
  [2989] = 2154,
  [2990] = 2143,
  [2991] = 2149,
  [2992] = 2155,
  [2993] = 2175,
  [2994] = 2176,
  [2995] = 2155,
  [2996] = 2160,
  [2997] = 2161,
  [2998] = 2177,
  [2999] = 2178,
  [3000] = 2179,
  [3001] = 2157,
  [3002] = 2156,
  [3003] = 2152,
  [3004] = 2162,
  [3005] = 2189,
  [3006] = 2165,
  [3007] = 2167,
  [3008] = 2168,
  [3009] = 2041,
  [3010] = 2185,
  [3011] = 2169,
  [3012] = 2167,
  [3013] = 2192,
  [3014] = 2190,
  [3015] = 2155,
  [3016] = 2180,
  [3017] = 2181,
  [3018] = 2182,
  [3019] = 2183,
  [3020] = 2154,
  [3021] = 2197,
  [3022] = 2115,
  [3023] = 2153,
  [3024] = 2128,
  [3025] = 2159,
  [3026] = 2187,
  [3027] = 2153,
  [3028] = 2189,
  [3029] = 2190,
  [3030] = 2191,
  [3031] = 2192,
  [3032] = 2193,
  [3033] = 2194,
  [3034] = 2195,
  [3035] = 2197,
  [3036] = 2142,
  [3037] = 2187,
  [3038] = 2169,
  [3039] = 2186,
  [3040] = 2173,
  [3041] = 2140,
  [3042] = 2141,
  [3043] = 2160,
  [3044] = 2161,
  [3045] = 2177,
  [3046] = 2172,
  [3047] = 2144,
  [3048] = 2118,
  [3049] = 2168,
  [3050] = 2165,
  [3051] = 2145,
  [3052] = 2185,
  [3053] = 2176,
  [3054] = 2175,
  [3055] = 2138,
  [3056] = 2183,
  [3057] = 2182,
  [3058] = 2181,
  [3059] = 2149,
  [3060] = 2143,
  [3061] = 2171,
  [3062] = 2162,
  [3063] = 2180,
  [3064] = 2116,
  [3065] = 2041,
  [3066] = 2142,
  [3067] = 2186,
  [3068] = 2173,
  [3069] = 2146,
  [3070] = 2140,
  [3071] = 2141,
  [3072] = 2172,
  [3073] = 2144,
  [3074] = 2146,
  [3075] = 2147,
  [3076] = 2148,
  [3077] = 2139,
  [3078] = 2150,
  [3079] = 2138,
  [3080] = 2188,
  [3081] = 2147,
  [3082] = 2148,
  [3083] = 2152,
  [3084] = 2156,
  [3085] = 2157,
  [3086] = 2150,
  [3087] = 2139,
  [3088] = 2170,
  [3089] = 2166,
  [3090] = 2158,
  [3091] = 2128,
  [3092] = 2164,
  [3093] = 2163,
  [3094] = 2132,
  [3095] = 2134,
  [3096] = 2137,
  [3097] = 2129,
  [3098] = 2135,
  [3099] = 2130,
  [3100] = 2134,
  [3101] = 2136,
  [3102] = 2137,
  [3103] = 2136,
  [3104] = 2129,
  [3105] = 2132,
  [3106] = 2135,
  [3107] = 2133,
  [3108] = 2131,
  [3109] = 2131,
  [3110] = 2130,
  [3111] = 2133,
  [3112] = 2172,
  [3113] = 2162,
  [3114] = 2041,
  [3115] = 2144,
  [3116] = 2142,
  [3117] = 2186,
  [3118] = 2173,
  [3119] = 2140,
  [3120] = 2141,
  [3121] = 2144,
  [3122] = 2146,
  [3123] = 2147,
  [3124] = 2148,
  [3125] = 2139,
  [3126] = 2150,
  [3127] = 2138,
  [3128] = 2188,
  [3129] = 2152,
  [3130] = 2156,
  [3131] = 2157,
  [3132] = 2158,
  [3133] = 2159,
  [3134] = 2163,
  [3135] = 2164,
  [3136] = 2191,
  [3137] = 2190,
  [3138] = 2166,
  [3139] = 2171,
  [3140] = 2143,
  [3141] = 2149,
  [3142] = 2175,
  [3143] = 2176,
  [3144] = 2177,
  [3145] = 2178,
  [3146] = 2179,
  [3147] = 2185,
  [3148] = 2142,
  [3149] = 2186,
  [3150] = 2173,
  [3151] = 2140,
  [3152] = 2141,
  [3153] = 2172,
  [3154] = 2157,
  [3155] = 2145,
  [3156] = 2146,
  [3157] = 2147,
  [3158] = 2148,
  [3159] = 2139,
  [3160] = 2150,
  [3161] = 2138,
  [3162] = 2188,
  [3163] = 2153,
  [3164] = 2154,
  [3165] = 2155,
  [3166] = 2152,
  [3167] = 2156,
  [3168] = 2197,
  [3169] = 2158,
  [3170] = 2159,
  [3171] = 2160,
  [3172] = 2161,
  [3173] = 2192,
  [3174] = 2189,
  [3175] = 2187,
  [3176] = 2183,
  [3177] = 2182,
  [3178] = 2163,
  [3179] = 2164,
  [3180] = 2165,
  [3181] = 2166,
  [3182] = 2167,
  [3183] = 2168,
  [3184] = 2169,
  [3185] = 2170,
  [3186] = 2171,
  [3187] = 2143,
  [3188] = 2149,
  [3189] = 2175,
  [3190] = 2176,
  [3191] = 2177,
  [3192] = 2178,
  [3193] = 2179,
  [3194] = 2180,
  [3195] = 2181,
  [3196] = 2182,
  [3197] = 2183,
  [3198] = 2185,
  [3199] = 2187,
  [3200] = 2189,
  [3201] = 2190,
  [3202] = 2191,
  [3203] = 2192,
  [3204] = 2193,
  [3205] = 2194,
  [3206] = 2195,
  [3207] = 2197,
  [3208] = 2145,
  [3209] = 2181,
  [3210] = 2153,
  [3211] = 2154,
  [3212] = 2155,
  [3213] = 2180,
  [3214] = 2160,
  [3215] = 2161,
  [3216] = 2162,
  [3217] = 2041,
  [3218] = 2165,
  [3219] = 2167,
  [3220] = 2168,
  [3221] = 2169,
  [3222] = 2170,
  [3223] = 2195,
  [3224] = 2193,
  [3225] = 2194,
  [3226] = 3226,
  [3227] = 3226,
  [3228] = 3228,
  [3229] = 3229,
  [3230] = 3230,
  [3231] = 3229,
  [3232] = 3230,
  [3233] = 3233,
  [3234] = 3228,
  [3235] = 2069,
  [3236] = 2079,
  [3237] = 2126,
  [3238] = 2071,
  [3239] = 2070,
  [3240] = 2127,
  [3241] = 2068,
  [3242] = 2067,
  [3243] = 2066,
  [3244] = 2055,
  [3245] = 2073,
  [3246] = 2104,
  [3247] = 2122,
  [3248] = 3248,
  [3249] = 3249,
  [3250] = 2121,
  [3251] = 2120,
  [3252] = 2119,
  [3253] = 2117,
  [3254] = 2114,
  [3255] = 2113,
  [3256] = 2074,
  [3257] = 2112,
  [3258] = 2077,
  [3259] = 3259,
  [3260] = 2064,
  [3261] = 2123,
  [3262] = 2110,
  [3263] = 2100,
  [3264] = 2098,
  [3265] = 2124,
  [3266] = 2109,
  [3267] = 2095,
  [3268] = 2094,
  [3269] = 2090,
  [3270] = 2088,
  [3271] = 2108,
  [3272] = 2072,
  [3273] = 2107,
  [3274] = 2106,
  [3275] = 2105,
  [3276] = 2103,
  [3277] = 2102,
  [3278] = 2101,
  [3279] = 2099,
  [3280] = 2097,
  [3281] = 2096,
  [3282] = 2056,
  [3283] = 2091,
  [3284] = 2078,
  [3285] = 2089,
  [3286] = 2087,
  [3287] = 2081,
  [3288] = 2076,
  [3289] = 2080,
  [3290] = 2092,
  [3291] = 2057,
  [3292] = 2075,
  [3293] = 2059,
  [3294] = 2062,
  [3295] = 2063,
  [3296] = 3296,
  [3297] = 3297,
  [3298] = 3298,
  [3299] = 3299,
  [3300] = 3300,
  [3301] = 2142,
  [3302] = 3302,
  [3303] = 3303,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 3306,
  [3307] = 3307,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3311,
  [3312] = 3312,
  [3313] = 3313,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3316,
  [3317] = 3317,
  [3318] = 3318,
  [3319] = 3319,
  [3320] = 3320,
  [3321] = 3321,
  [3322] = 3322,
  [3323] = 3323,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 3326,
  [3327] = 3327,
  [3328] = 3328,
  [3329] = 3329,
  [3330] = 3330,
  [3331] = 3331,
  [3332] = 3332,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 3335,
  [3336] = 3336,
  [3337] = 3337,
  [3338] = 3338,
  [3339] = 3339,
  [3340] = 3340,
  [3341] = 3341,
  [3342] = 3342,
  [3343] = 3343,
  [3344] = 3344,
  [3345] = 3345,
  [3346] = 3346,
  [3347] = 3347,
  [3348] = 3348,
  [3349] = 3349,
  [3350] = 3350,
  [3351] = 3351,
  [3352] = 3352,
  [3353] = 3353,
  [3354] = 3354,
  [3355] = 3355,
  [3356] = 3356,
  [3357] = 3357,
  [3358] = 3358,
  [3359] = 3359,
  [3360] = 3360,
  [3361] = 3361,
  [3362] = 3362,
  [3363] = 3363,
  [3364] = 3364,
  [3365] = 3365,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3368,
  [3369] = 3369,
  [3370] = 3370,
  [3371] = 3371,
  [3372] = 3372,
  [3373] = 3373,
  [3374] = 3374,
  [3375] = 3375,
  [3376] = 3376,
  [3377] = 3377,
  [3378] = 3378,
  [3379] = 3379,
  [3380] = 3380,
  [3381] = 3381,
  [3382] = 3382,
  [3383] = 3383,
  [3384] = 3384,
  [3385] = 3385,
  [3386] = 3386,
  [3387] = 3387,
  [3388] = 3388,
  [3389] = 3389,
  [3390] = 3390,
  [3391] = 3391,
  [3392] = 3392,
  [3393] = 3393,
  [3394] = 3393,
  [3395] = 3393,
  [3396] = 3393,
  [3397] = 3393,
  [3398] = 3393,
  [3399] = 3399,
  [3400] = 3393,
  [3401] = 3401,
  [3402] = 3402,
  [3403] = 3403,
  [3404] = 3393,
  [3405] = 3393,
  [3406] = 3393,
  [3407] = 3393,
  [3408] = 3408,
  [3409] = 3393,
  [3410] = 3393,
  [3411] = 3393,
  [3412] = 3393,
  [3413] = 3413,
  [3414] = 3414,
  [3415] = 3413,
  [3416] = 3413,
  [3417] = 3413,
  [3418] = 3413,
  [3419] = 3413,
  [3420] = 3413,
  [3421] = 3413,
  [3422] = 3413,
  [3423] = 3413,
  [3424] = 3413,
  [3425] = 3413,
  [3426] = 3413,
  [3427] = 3413,
  [3428] = 3428,
  [3429] = 3413,
  [3430] = 3430,
  [3431] = 3431,
  [3432] = 3432,
  [3433] = 3433,
  [3434] = 3434,
  [3435] = 3435,
  [3436] = 3435,
  [3437] = 3437,
  [3438] = 3435,
  [3439] = 3439,
  [3440] = 3439,
  [3441] = 3441,
  [3442] = 3442,
  [3443] = 3435,
  [3444] = 3441,
  [3445] = 3445,
  [3446] = 2142,
  [3447] = 3300,
  [3448] = 3439,
  [3449] = 3307,
  [3450] = 3302,
  [3451] = 3302,
  [3452] = 3318,
  [3453] = 3307,
  [3454] = 3319,
  [3455] = 2081,
  [3456] = 2104,
  [3457] = 2055,
  [3458] = 2092,
  [3459] = 2064,
  [3460] = 2066,
  [3461] = 2067,
  [3462] = 2068,
  [3463] = 2069,
  [3464] = 2070,
  [3465] = 2071,
  [3466] = 2072,
  [3467] = 2077,
  [3468] = 2059,
  [3469] = 2062,
  [3470] = 2073,
  [3471] = 2074,
  [3472] = 2075,
  [3473] = 2063,
  [3474] = 2076,
  [3475] = 2078,
  [3476] = 3259,
  [3477] = 2079,
  [3478] = 2088,
  [3479] = 2090,
  [3480] = 2094,
  [3481] = 2095,
  [3482] = 2098,
  [3483] = 2100,
  [3484] = 3302,
  [3485] = 2057,
  [3486] = 3343,
  [3487] = 2080,
  [3488] = 2087,
  [3489] = 2089,
  [3490] = 2091,
  [3491] = 2056,
  [3492] = 2096,
  [3493] = 2097,
  [3494] = 2099,
  [3495] = 2101,
  [3496] = 2102,
  [3497] = 2103,
  [3498] = 2105,
  [3499] = 2106,
  [3500] = 3307,
  [3501] = 2107,
  [3502] = 2108,
  [3503] = 2109,
  [3504] = 2110,
  [3505] = 2112,
  [3506] = 2113,
  [3507] = 2114,
  [3508] = 2117,
  [3509] = 2119,
  [3510] = 2120,
  [3511] = 2121,
  [3512] = 2122,
  [3513] = 2123,
  [3514] = 3318,
  [3515] = 3319,
  [3516] = 2124,
  [3517] = 2126,
  [3518] = 2127,
  [3519] = 3340,
  [3520] = 3249,
  [3521] = 3521,
  [3522] = 3342,
  [3523] = 2091,
  [3524] = 3343,
  [3525] = 2102,
  [3526] = 2105,
  [3527] = 2076,
  [3528] = 2103,
  [3529] = 2070,
  [3530] = 2078,
  [3531] = 2079,
  [3532] = 3318,
  [3533] = 2088,
  [3534] = 2090,
  [3535] = 3249,
  [3536] = 2094,
  [3537] = 2097,
  [3538] = 2095,
  [3539] = 2106,
  [3540] = 2098,
  [3541] = 2073,
  [3542] = 2100,
  [3543] = 3300,
  [3544] = 2074,
  [3545] = 2142,
  [3546] = 2072,
  [3547] = 2075,
  [3548] = 2069,
  [3549] = 2071,
  [3550] = 2107,
  [3551] = 2068,
  [3552] = 2108,
  [3553] = 2109,
  [3554] = 2110,
  [3555] = 2067,
  [3556] = 2066,
  [3557] = 2064,
  [3558] = 2055,
  [3559] = 2104,
  [3560] = 2063,
  [3561] = 2062,
  [3562] = 3345,
  [3563] = 2099,
  [3564] = 2112,
  [3565] = 2059,
  [3566] = 2057,
  [3567] = 3331,
  [3568] = 2092,
  [3569] = 2077,
  [3570] = 2080,
  [3571] = 2127,
  [3572] = 3340,
  [3573] = 3327,
  [3574] = 2113,
  [3575] = 2126,
  [3576] = 2124,
  [3577] = 2114,
  [3578] = 2081,
  [3579] = 2117,
  [3580] = 2087,
  [3581] = 2122,
  [3582] = 2096,
  [3583] = 2056,
  [3584] = 3259,
  [3585] = 2123,
  [3586] = 2089,
  [3587] = 3320,
  [3588] = 3319,
  [3589] = 2119,
  [3590] = 2121,
  [3591] = 3591,
  [3592] = 3342,
  [3593] = 3341,
  [3594] = 2120,
  [3595] = 2101,
  [3596] = 3322,
  [3597] = 3309,
  [3598] = 3343,
  [3599] = 3345,
  [3600] = 3600,
  [3601] = 3342,
  [3602] = 3321,
  [3603] = 3310,
  [3604] = 3315,
  [3605] = 3340,
  [3606] = 3312,
  [3607] = 3323,
  [3608] = 3306,
  [3609] = 3330,
  [3610] = 3305,
  [3611] = 3311,
  [3612] = 3314,
  [3613] = 3613,
  [3614] = 3321,
  [3615] = 3328,
  [3616] = 3345,
  [3617] = 3339,
  [3618] = 3322,
  [3619] = 3619,
  [3620] = 3309,
  [3621] = 3621,
  [3622] = 3329,
  [3623] = 3305,
  [3624] = 3306,
  [3625] = 3329,
  [3626] = 3328,
  [3627] = 3627,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3339,
  [3632] = 3632,
  [3633] = 3633,
  [3634] = 3634,
  [3635] = 3635,
  [3636] = 3636,
  [3637] = 3637,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3642,
  [3643] = 3643,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3651,
  [3652] = 3652,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3298,
  [3663] = 3663,
  [3664] = 3664,
  [3665] = 3665,
  [3666] = 3666,
  [3667] = 3667,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3675,
  [3676] = 3676,
  [3677] = 3677,
  [3678] = 3676,
  [3679] = 3676,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3680,
  [3684] = 3680,
  [3685] = 3676,
  [3686] = 3686,
  [3687] = 3680,
  [3688] = 3676,
  [3689] = 3676,
  [3690] = 3680,
  [3691] = 3676,
  [3692] = 3680,
  [3693] = 3693,
  [3694] = 3680,
  [3695] = 3676,
  [3696] = 3680,
  [3697] = 3697,
  [3698] = 3676,
  [3699] = 3699,
  [3700] = 3680,
  [3701] = 3680,
  [3702] = 3686,
  [3703] = 3676,
  [3704] = 3704,
  [3705] = 3705,
  [3706] = 3676,
  [3707] = 3680,
  [3708] = 3708,
  [3709] = 3686,
  [3710] = 3680,
  [3711] = 3680,
  [3712] = 3712,
  [3713] = 3686,
  [3714] = 3676,
  [3715] = 3680,
  [3716] = 3677,
  [3717] = 3676,
  [3718] = 3718,
  [3719] = 3676,
  [3720] = 3680,
  [3721] = 3677,
  [3722] = 3722,
  [3723] = 3676,
  [3724] = 3680,
  [3725] = 2111,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 3728,
  [3729] = 3729,
  [3730] = 2001,
  [3731] = 1999,
  [3732] = 3732,
  [3733] = 3726,
  [3734] = 3734,
  [3735] = 3732,
  [3736] = 3726,
  [3737] = 3737,
  [3738] = 3732,
  [3739] = 3739,
  [3740] = 3726,
  [3741] = 3727,
  [3742] = 3728,
  [3743] = 3737,
  [3744] = 3728,
  [3745] = 3739,
  [3746] = 3746,
  [3747] = 3727,
  [3748] = 3748,
  [3749] = 3727,
  [3750] = 3728,
  [3751] = 3732,
  [3752] = 3732,
  [3753] = 2004,
  [3754] = 2000,
  [3755] = 3727,
  [3756] = 2005,
  [3757] = 3757,
  [3758] = 3726,
  [3759] = 3759,
  [3760] = 3728,
  [3761] = 3732,
  [3762] = 2006,
  [3763] = 2007,
  [3764] = 3734,
  [3765] = 3726,
  [3766] = 3766,
  [3767] = 3734,
  [3768] = 3727,
  [3769] = 3728,
  [3770] = 3732,
  [3771] = 3728,
  [3772] = 3772,
  [3773] = 3727,
  [3774] = 3726,
  [3775] = 3732,
  [3776] = 3737,
  [3777] = 3732,
  [3778] = 3778,
  [3779] = 3734,
  [3780] = 3726,
  [3781] = 3728,
  [3782] = 3727,
  [3783] = 3739,
  [3784] = 3739,
  [3785] = 3739,
  [3786] = 3734,
  [3787] = 3732,
  [3788] = 3726,
  [3789] = 3789,
  [3790] = 3737,
  [3791] = 3739,
  [3792] = 3792,
  [3793] = 3737,
  [3794] = 3737,
  [3795] = 3795,
  [3796] = 3726,
  [3797] = 3734,
  [3798] = 3798,
  [3799] = 3799,
  [3800] = 3726,
  [3801] = 3727,
  [3802] = 3739,
  [3803] = 3803,
  [3804] = 3728,
  [3805] = 3737,
  [3806] = 3732,
  [3807] = 3807,
  [3808] = 3808,
  [3809] = 3734,
  [3810] = 3726,
  [3811] = 3732,
  [3812] = 3737,
  [3813] = 3739,
  [3814] = 3734,
  [3815] = 3734,
  [3816] = 3816,
  [3817] = 3817,
  [3818] = 3818,
  [3819] = 3728,
  [3820] = 3820,
  [3821] = 3727,
  [3822] = 3728,
  [3823] = 3727,
  [3824] = 3728,
  [3825] = 3727,
  [3826] = 3739,
  [3827] = 3737,
  [3828] = 3737,
  [3829] = 3726,
  [3830] = 3732,
  [3831] = 3831,
  [3832] = 3739,
  [3833] = 3737,
  [3834] = 3739,
  [3835] = 2125,
  [3836] = 3836,
  [3837] = 3739,
  [3838] = 3737,
  [3839] = 3839,
  [3840] = 3726,
  [3841] = 3732,
  [3842] = 3739,
  [3843] = 3739,
  [3844] = 3844,
  [3845] = 3845,
  [3846] = 3846,
  [3847] = 3847,
  [3848] = 3739,
  [3849] = 3849,
  [3850] = 3850,
  [3851] = 3737,
  [3852] = 3727,
  [3853] = 3728,
  [3854] = 3854,
  [3855] = 3734,
  [3856] = 3856,
  [3857] = 3798,
  [3858] = 3732,
  [3859] = 3728,
  [3860] = 3734,
  [3861] = 3727,
  [3862] = 3726,
  [3863] = 3746,
  [3864] = 3734,
  [3865] = 3865,
  [3866] = 3734,
  [3867] = 3867,
  [3868] = 2003,
  [3869] = 3734,
  [3870] = 3728,
  [3871] = 3727,
  [3872] = 3872,
  [3873] = 3737,
  [3874] = 3737,
  [3875] = 3734,
  [3876] = 3734,
  [3877] = 3732,
  [3878] = 3726,
  [3879] = 3307,
  [3880] = 3880,
  [3881] = 3881,
  [3882] = 3882,
  [3883] = 3881,
  [3884] = 3884,
  [3885] = 3885,
  [3886] = 3886,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3881,
  [3890] = 3887,
  [3891] = 3891,
  [3892] = 3892,
  [3893] = 3893,
  [3894] = 3894,
  [3895] = 3895,
  [3896] = 3896,
  [3897] = 3897,
  [3898] = 3881,
  [3899] = 3881,
  [3900] = 3900,
  [3901] = 3901,
  [3902] = 3902,
  [3903] = 3885,
  [3904] = 3904,
  [3905] = 3887,
  [3906] = 3906,
  [3907] = 3887,
  [3908] = 3908,
  [3909] = 3887,
  [3910] = 3910,
  [3911] = 3911,
  [3912] = 3900,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3915,
  [3916] = 3881,
  [3917] = 3881,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3921,
  [3922] = 3302,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 3914,
  [3926] = 3926,
  [3927] = 3921,
  [3928] = 3304,
  [3929] = 3929,
  [3930] = 3881,
  [3931] = 3931,
  [3932] = 3932,
  [3933] = 3887,
  [3934] = 3934,
  [3935] = 3935,
  [3936] = 3887,
  [3937] = 3887,
  [3938] = 3302,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3248,
  [3944] = 3881,
  [3945] = 3887,
  [3946] = 3946,
  [3947] = 3303,
  [3948] = 3881,
  [3949] = 3949,
  [3950] = 3887,
  [3951] = 3307,
  [3952] = 3887,
  [3953] = 3887,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3881,
  [3957] = 3881,
  [3958] = 3958,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3961,
  [3962] = 3881,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3308,
  [3966] = 3966,
  [3967] = 3881,
  [3968] = 3968,
  [3969] = 3887,
  [3970] = 3970,
  [3971] = 3881,
  [3972] = 3972,
  [3973] = 3887,
  [3974] = 3249,
  [3975] = 2178,
  [3976] = 3976,
  [3977] = 3900,
  [3978] = 3887,
  [3979] = 3921,
  [3980] = 3980,
  [3981] = 3981,
  [3982] = 3982,
  [3983] = 3983,
  [3984] = 3984,
  [3985] = 3985,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3988,
  [3989] = 3989,
  [3990] = 3988,
  [3991] = 3988,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3994,
  [3995] = 3988,
  [3996] = 3996,
  [3997] = 3997,
  [3998] = 3988,
  [3999] = 3986,
  [4000] = 4000,
  [4001] = 3988,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 3988,
  [4005] = 4005,
  [4006] = 3988,
  [4007] = 3987,
  [4008] = 3985,
  [4009] = 4009,
  [4010] = 3985,
  [4011] = 3983,
  [4012] = 4005,
  [4013] = 3318,
  [4014] = 4003,
  [4015] = 4005,
  [4016] = 4003,
  [4017] = 3986,
  [4018] = 4018,
  [4019] = 4019,
  [4020] = 3987,
  [4021] = 3983,
  [4022] = 3986,
  [4023] = 3985,
  [4024] = 3983,
  [4025] = 3987,
  [4026] = 4026,
  [4027] = 3985,
  [4028] = 3985,
  [4029] = 3987,
  [4030] = 4030,
  [4031] = 3317,
  [4032] = 3986,
  [4033] = 4033,
  [4034] = 3319,
  [4035] = 4035,
  [4036] = 3983,
  [4037] = 3983,
  [4038] = 3985,
  [4039] = 3988,
  [4040] = 3987,
  [4041] = 3318,
  [4042] = 3319,
  [4043] = 4043,
  [4044] = 3986,
  [4045] = 3988,
  [4046] = 4046,
  [4047] = 3988,
  [4048] = 4048,
  [4049] = 3296,
  [4050] = 3983,
  [4051] = 3981,
  [4052] = 3985,
  [4053] = 4053,
  [4054] = 3987,
  [4055] = 4055,
  [4056] = 3987,
  [4057] = 3988,
  [4058] = 4003,
  [4059] = 4059,
  [4060] = 4060,
  [4061] = 4061,
  [4062] = 4062,
  [4063] = 4063,
  [4064] = 3986,
  [4065] = 3987,
  [4066] = 3985,
  [4067] = 3987,
  [4068] = 4005,
  [4069] = 3983,
  [4070] = 3313,
  [4071] = 4071,
  [4072] = 3985,
  [4073] = 3983,
  [4074] = 3316,
  [4075] = 3988,
  [4076] = 3986,
  [4077] = 3988,
  [4078] = 4078,
  [4079] = 3986,
  [4080] = 4080,
  [4081] = 4005,
  [4082] = 4003,
  [4083] = 3980,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 3983,
  [4087] = 3986,
  [4088] = 4088,
  [4089] = 3986,
  [4090] = 3986,
  [4091] = 4091,
  [4092] = 3986,
  [4093] = 3985,
  [4094] = 3987,
  [4095] = 3983,
  [4096] = 4096,
  [4097] = 3985,
  [4098] = 3987,
  [4099] = 4099,
  [4100] = 4100,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 4104,
  [4105] = 4105,
  [4106] = 3987,
  [4107] = 3985,
  [4108] = 3988,
  [4109] = 4109,
  [4110] = 3983,
  [4111] = 4111,
  [4112] = 3983,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 3985,
  [4116] = 4116,
  [4117] = 3988,
  [4118] = 3986,
  [4119] = 3987,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 3986,
  [4123] = 3987,
  [4124] = 3985,
  [4125] = 4002,
  [4126] = 4126,
  [4127] = 3983,
  [4128] = 4102,
  [4129] = 4099,
  [4130] = 3983,
  [4131] = 4131,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 4136,
  [4137] = 4137,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4142,
  [4143] = 4141,
  [4144] = 4141,
  [4145] = 4145,
  [4146] = 4141,
  [4147] = 4141,
  [4148] = 4141,
  [4149] = 4149,
  [4150] = 4150,
  [4151] = 3302,
  [4152] = 4141,
  [4153] = 4153,
  [4154] = 4154,
  [4155] = 4155,
  [4156] = 4156,
  [4157] = 4141,
  [4158] = 4158,
  [4159] = 4141,
  [4160] = 4131,
  [4161] = 4132,
  [4162] = 4162,
  [4163] = 4163,
  [4164] = 4164,
  [4165] = 4165,
  [4166] = 4163,
  [4167] = 4165,
  [4168] = 4158,
  [4169] = 4164,
  [4170] = 4141,
  [4171] = 4156,
  [4172] = 4172,
  [4173] = 4141,
  [4174] = 3302,
  [4175] = 4141,
  [4176] = 4141,
  [4177] = 4162,
  [4178] = 4132,
  [4179] = 4131,
  [4180] = 4180,
  [4181] = 4141,
  [4182] = 4182,
  [4183] = 4141,
  [4184] = 3914,
  [4185] = 4154,
  [4186] = 4153,
  [4187] = 3307,
  [4188] = 3342,
  [4189] = 4153,
  [4190] = 4142,
  [4191] = 4133,
  [4192] = 4134,
  [4193] = 3343,
  [4194] = 4194,
  [4195] = 4136,
  [4196] = 4140,
  [4197] = 4137,
  [4198] = 3307,
  [4199] = 4139,
  [4200] = 4139,
  [4201] = 4140,
  [4202] = 3307,
  [4203] = 4142,
  [4204] = 4204,
  [4205] = 4137,
  [4206] = 4154,
  [4207] = 4136,
  [4208] = 4208,
  [4209] = 4209,
  [4210] = 3307,
  [4211] = 4153,
  [4212] = 4154,
  [4213] = 4134,
  [4214] = 4133,
  [4215] = 4131,
  [4216] = 4132,
  [4217] = 4162,
  [4218] = 4131,
  [4219] = 4132,
  [4220] = 4162,
  [4221] = 3340,
  [4222] = 4164,
  [4223] = 4165,
  [4224] = 4163,
  [4225] = 4141,
  [4226] = 4158,
  [4227] = 3307,
  [4228] = 3307,
  [4229] = 4156,
  [4230] = 3307,
  [4231] = 3302,
  [4232] = 3302,
  [4233] = 4233,
  [4234] = 3307,
  [4235] = 3307,
  [4236] = 4236,
  [4237] = 3302,
  [4238] = 3307,
  [4239] = 4156,
  [4240] = 4240,
  [4241] = 4158,
  [4242] = 4133,
  [4243] = 4134,
  [4244] = 4163,
  [4245] = 4245,
  [4246] = 4165,
  [4247] = 3307,
  [4248] = 4164,
  [4249] = 4133,
  [4250] = 4134,
  [4251] = 4251,
  [4252] = 3307,
  [4253] = 4136,
  [4254] = 4136,
  [4255] = 4137,
  [4256] = 4256,
  [4257] = 4162,
  [4258] = 4139,
  [4259] = 4140,
  [4260] = 4260,
  [4261] = 4142,
  [4262] = 4262,
  [4263] = 4263,
  [4264] = 4132,
  [4265] = 4139,
  [4266] = 4142,
  [4267] = 4131,
  [4268] = 4140,
  [4269] = 4153,
  [4270] = 4154,
  [4271] = 4139,
  [4272] = 4272,
  [4273] = 4273,
  [4274] = 4137,
  [4275] = 4275,
  [4276] = 4131,
  [4277] = 4132,
  [4278] = 4162,
  [4279] = 4140,
  [4280] = 4164,
  [4281] = 4165,
  [4282] = 4163,
  [4283] = 4283,
  [4284] = 4158,
  [4285] = 4142,
  [4286] = 4154,
  [4287] = 4156,
  [4288] = 4136,
  [4289] = 4256,
  [4290] = 3302,
  [4291] = 4260,
  [4292] = 4208,
  [4293] = 4153,
  [4294] = 4262,
  [4295] = 4263,
  [4296] = 3307,
  [4297] = 4297,
  [4298] = 4142,
  [4299] = 4299,
  [4300] = 4140,
  [4301] = 4139,
  [4302] = 4209,
  [4303] = 4303,
  [4304] = 4137,
  [4305] = 4137,
  [4306] = 4136,
  [4307] = 4133,
  [4308] = 4134,
  [4309] = 4256,
  [4310] = 4260,
  [4311] = 4136,
  [4312] = 4262,
  [4313] = 4137,
  [4314] = 4263,
  [4315] = 4153,
  [4316] = 4139,
  [4317] = 4140,
  [4318] = 4318,
  [4319] = 4142,
  [4320] = 4154,
  [4321] = 3364,
  [4322] = 4134,
  [4323] = 4133,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4131,
  [4327] = 4153,
  [4328] = 4154,
  [4329] = 4132,
  [4330] = 4330,
  [4331] = 4256,
  [4332] = 4332,
  [4333] = 4142,
  [4334] = 4131,
  [4335] = 4132,
  [4336] = 4162,
  [4337] = 4162,
  [4338] = 4164,
  [4339] = 4165,
  [4340] = 4163,
  [4341] = 4341,
  [4342] = 4158,
  [4343] = 4260,
  [4344] = 4344,
  [4345] = 4156,
  [4346] = 4297,
  [4347] = 4194,
  [4348] = 3302,
  [4349] = 4349,
  [4350] = 4156,
  [4351] = 4136,
  [4352] = 4137,
  [4353] = 4353,
  [4354] = 4142,
  [4355] = 4164,
  [4356] = 4154,
  [4357] = 4165,
  [4358] = 4349,
  [4359] = 4158,
  [4360] = 4163,
  [4361] = 4163,
  [4362] = 4131,
  [4363] = 4132,
  [4364] = 4165,
  [4365] = 4163,
  [4366] = 4366,
  [4367] = 4158,
  [4368] = 4165,
  [4369] = 4164,
  [4370] = 4156,
  [4371] = 4158,
  [4372] = 4372,
  [4373] = 4373,
  [4374] = 4374,
  [4375] = 4162,
  [4376] = 4132,
  [4377] = 4131,
  [4378] = 4156,
  [4379] = 3885,
  [4380] = 4154,
  [4381] = 4194,
  [4382] = 4153,
  [4383] = 4383,
  [4384] = 4384,
  [4385] = 3352,
  [4386] = 3302,
  [4387] = 4142,
  [4388] = 4388,
  [4389] = 4140,
  [4390] = 4236,
  [4391] = 4139,
  [4392] = 4251,
  [4393] = 3326,
  [4394] = 4133,
  [4395] = 4137,
  [4396] = 4136,
  [4397] = 4344,
  [4398] = 4332,
  [4399] = 4134,
  [4400] = 4136,
  [4401] = 4134,
  [4402] = 4133,
  [4403] = 4137,
  [4404] = 4139,
  [4405] = 4140,
  [4406] = 4142,
  [4407] = 3338,
  [4408] = 3327,
  [4409] = 4194,
  [4410] = 4209,
  [4411] = 4153,
  [4412] = 4172,
  [4413] = 4164,
  [4414] = 4154,
  [4415] = 4135,
  [4416] = 4138,
  [4417] = 4194,
  [4418] = 4132,
  [4419] = 3302,
  [4420] = 4349,
  [4421] = 4162,
  [4422] = 4251,
  [4423] = 4172,
  [4424] = 4165,
  [4425] = 4156,
  [4426] = 4163,
  [4427] = 4158,
  [4428] = 4156,
  [4429] = 4373,
  [4430] = 4374,
  [4431] = 4158,
  [4432] = 4165,
  [4433] = 4163,
  [4434] = 4165,
  [4435] = 4164,
  [4436] = 3336,
  [4437] = 4383,
  [4438] = 3302,
  [4439] = 4162,
  [4440] = 4133,
  [4441] = 4132,
  [4442] = 4134,
  [4443] = 4131,
  [4444] = 4344,
  [4445] = 4332,
  [4446] = 4136,
  [4447] = 4163,
  [4448] = 4137,
  [4449] = 4194,
  [4450] = 4139,
  [4451] = 4158,
  [4452] = 4154,
  [4453] = 4153,
  [4454] = 4164,
  [4455] = 4142,
  [4456] = 4456,
  [4457] = 4172,
  [4458] = 4135,
  [4459] = 4138,
  [4460] = 4194,
  [4461] = 4153,
  [4462] = 4154,
  [4463] = 4349,
  [4464] = 4464,
  [4465] = 4465,
  [4466] = 4373,
  [4467] = 4374,
  [4468] = 4468,
  [4469] = 4469,
  [4470] = 4140,
  [4471] = 4139,
  [4472] = 4472,
  [4473] = 4131,
  [4474] = 4383,
  [4475] = 4137,
  [4476] = 4476,
  [4477] = 4132,
  [4478] = 4136,
  [4479] = 4162,
  [4480] = 4134,
  [4481] = 4344,
  [4482] = 4332,
  [4483] = 4483,
  [4484] = 4484,
  [4485] = 4485,
  [4486] = 4134,
  [4487] = 4133,
  [4488] = 4133,
  [4489] = 4164,
  [4490] = 4490,
  [4491] = 4165,
  [4492] = 4163,
  [4493] = 4158,
  [4494] = 4172,
  [4495] = 4135,
  [4496] = 4138,
  [4497] = 4194,
  [4498] = 4194,
  [4499] = 4499,
  [4500] = 4349,
  [4501] = 4156,
  [4502] = 4502,
  [4503] = 3302,
  [4504] = 4156,
  [4505] = 4153,
  [4506] = 4156,
  [4507] = 4507,
  [4508] = 3302,
  [4509] = 4158,
  [4510] = 4510,
  [4511] = 4511,
  [4512] = 4512,
  [4513] = 4373,
  [4514] = 4374,
  [4515] = 4163,
  [4516] = 4165,
  [4517] = 4133,
  [4518] = 4164,
  [4519] = 4162,
  [4520] = 4132,
  [4521] = 4131,
  [4522] = 4134,
  [4523] = 4523,
  [4524] = 4154,
  [4525] = 4172,
  [4526] = 4194,
  [4527] = 4153,
  [4528] = 4136,
  [4529] = 4349,
  [4530] = 4142,
  [4531] = 4531,
  [4532] = 4140,
  [4533] = 4139,
  [4534] = 4534,
  [4535] = 4194,
  [4536] = 4137,
  [4537] = 4137,
  [4538] = 4136,
  [4539] = 4139,
  [4540] = 4140,
  [4541] = 4541,
  [4542] = 4542,
  [4543] = 4383,
  [4544] = 4134,
  [4545] = 4236,
  [4546] = 4262,
  [4547] = 4142,
  [4548] = 4133,
  [4549] = 4263,
  [4550] = 4372,
  [4551] = 4153,
  [4552] = 4154,
  [4553] = 4553,
  [4554] = 4194,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 3302,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 4156,
  [4561] = 4131,
  [4562] = 4562,
  [4563] = 4194,
  [4564] = 4564,
  [4565] = 4158,
  [4566] = 4140,
  [4567] = 4567,
  [4568] = 4164,
  [4569] = 4569,
  [4570] = 4163,
  [4571] = 4165,
  [4572] = 4572,
  [4573] = 4164,
  [4574] = 4574,
  [4575] = 4165,
  [4576] = 4163,
  [4577] = 4162,
  [4578] = 4132,
  [4579] = 3354,
  [4580] = 4131,
  [4581] = 4194,
  [4582] = 4158,
  [4583] = 4583,
  [4584] = 4154,
  [4585] = 4162,
  [4586] = 4156,
  [4587] = 3302,
  [4588] = 4142,
  [4589] = 4233,
  [4590] = 4194,
  [4591] = 4140,
  [4592] = 4133,
  [4593] = 4134,
  [4594] = 4139,
  [4595] = 4136,
  [4596] = 4137,
  [4597] = 4597,
  [4598] = 4598,
  [4599] = 4598,
  [4600] = 4598,
  [4601] = 4598,
  [4602] = 4598,
  [4603] = 4598,
  [4604] = 4598,
  [4605] = 4598,
  [4606] = 4598,
  [4607] = 4598,
  [4608] = 4598,
  [4609] = 4609,
  [4610] = 4598,
  [4611] = 4598,
  [4612] = 4598,
  [4613] = 4598,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4621,
  [4622] = 4622,
  [4623] = 4623,
  [4624] = 4624,
  [4625] = 4625,
  [4626] = 2130,
  [4627] = 4627,
  [4628] = 4598,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 2135,
  [4632] = 2137,
  [4633] = 2136,
  [4634] = 4629,
  [4635] = 4635,
  [4636] = 4636,
  [4637] = 4629,
  [4638] = 4638,
  [4639] = 4629,
  [4640] = 4640,
  [4641] = 4641,
  [4642] = 4642,
  [4643] = 4629,
  [4644] = 4629,
  [4645] = 4629,
  [4646] = 4629,
  [4647] = 4629,
  [4648] = 4629,
  [4649] = 4629,
  [4650] = 4650,
  [4651] = 4629,
  [4652] = 4629,
  [4653] = 4653,
  [4654] = 4654,
  [4655] = 4629,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4629,
  [4661] = 4661,
  [4662] = 4662,
  [4663] = 4629,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4668,
  [4669] = 4669,
  [4670] = 4670,
  [4671] = 3345,
  [4672] = 4672,
  [4673] = 2128,
  [4674] = 4674,
  [4675] = 2132,
  [4676] = 3348,
  [4677] = 4677,
  [4678] = 4678,
  [4679] = 3718,
  [4680] = 4635,
  [4681] = 4681,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 2101,
  [4686] = 4684,
  [4687] = 4687,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4692,
  [4693] = 4693,
  [4694] = 4694,
  [4695] = 4695,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4697,
  [4699] = 4684,
  [4700] = 4694,
  [4701] = 4684,
  [4702] = 4694,
  [4703] = 4703,
  [4704] = 4704,
  [4705] = 4705,
  [4706] = 4706,
  [4707] = 4707,
  [4708] = 4708,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 3259,
  [4712] = 4712,
  [4713] = 3371,
  [4714] = 4714,
  [4715] = 4703,
  [4716] = 4716,
  [4717] = 4717,
  [4718] = 4718,
  [4719] = 3360,
  [4720] = 4697,
  [4721] = 4721,
  [4722] = 4694,
  [4723] = 3349,
  [4724] = 3362,
  [4725] = 4684,
  [4726] = 4690,
  [4727] = 4688,
  [4728] = 4694,
  [4729] = 4729,
  [4730] = 4687,
  [4731] = 4703,
  [4732] = 4732,
  [4733] = 2185,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 3353,
  [4738] = 3355,
  [4739] = 4687,
  [4740] = 4688,
  [4741] = 4690,
  [4742] = 4688,
  [4743] = 4743,
  [4744] = 4744,
  [4745] = 3358,
  [4746] = 3372,
  [4747] = 4747,
  [4748] = 4690,
  [4749] = 4749,
  [4750] = 4694,
  [4751] = 4751,
  [4752] = 4684,
  [4753] = 4703,
  [4754] = 4754,
  [4755] = 4694,
  [4756] = 4697,
  [4757] = 3365,
  [4758] = 4697,
  [4759] = 4759,
  [4760] = 4703,
  [4761] = 3369,
  [4762] = 4762,
  [4763] = 4751,
  [4764] = 4721,
  [4765] = 4690,
  [4766] = 4688,
  [4767] = 4694,
  [4768] = 4687,
  [4769] = 3373,
  [4770] = 4684,
  [4771] = 3359,
  [4772] = 4772,
  [4773] = 4773,
  [4774] = 3357,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4684,
  [4780] = 1999,
  [4781] = 4781,
  [4782] = 4694,
  [4783] = 2001,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4788,
  [4789] = 4789,
  [4790] = 4790,
  [4791] = 2003,
  [4792] = 4703,
  [4793] = 2004,
  [4794] = 4794,
  [4795] = 2000,
  [4796] = 4687,
  [4797] = 4688,
  [4798] = 2005,
  [4799] = 4799,
  [4800] = 2006,
  [4801] = 4690,
  [4802] = 4694,
  [4803] = 4803,
  [4804] = 4804,
  [4805] = 4694,
  [4806] = 2007,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 4809,
  [4810] = 4684,
  [4811] = 2077,
  [4812] = 2127,
  [4813] = 2126,
  [4814] = 4697,
  [4815] = 4815,
  [4816] = 4816,
  [4817] = 4778,
  [4818] = 4818,
  [4819] = 2125,
  [4820] = 4697,
  [4821] = 4821,
  [4822] = 2124,
  [4823] = 4703,
  [4824] = 4824,
  [4825] = 4762,
  [4826] = 4826,
  [4827] = 4827,
  [4828] = 2123,
  [4829] = 4693,
  [4830] = 4695,
  [4831] = 4751,
  [4832] = 2122,
  [4833] = 2121,
  [4834] = 4834,
  [4835] = 4697,
  [4836] = 2120,
  [4837] = 2119,
  [4838] = 2117,
  [4839] = 4735,
  [4840] = 2114,
  [4841] = 4703,
  [4842] = 4703,
  [4843] = 4773,
  [4844] = 4816,
  [4845] = 4778,
  [4846] = 2113,
  [4847] = 4847,
  [4848] = 4684,
  [4849] = 4849,
  [4850] = 4850,
  [4851] = 4762,
  [4852] = 4690,
  [4853] = 4853,
  [4854] = 2112,
  [4855] = 4693,
  [4856] = 4695,
  [4857] = 4751,
  [4858] = 4688,
  [4859] = 4687,
  [4860] = 2111,
  [4861] = 4861,
  [4862] = 4703,
  [4863] = 4816,
  [4864] = 4778,
  [4865] = 4703,
  [4866] = 4694,
  [4867] = 4697,
  [4868] = 4868,
  [4869] = 4869,
  [4870] = 4762,
  [4871] = 4703,
  [4872] = 2068,
  [4873] = 2110,
  [4874] = 4693,
  [4875] = 4695,
  [4876] = 4751,
  [4877] = 4877,
  [4878] = 4703,
  [4879] = 4879,
  [4880] = 2109,
  [4881] = 2108,
  [4882] = 2107,
  [4883] = 4883,
  [4884] = 4884,
  [4885] = 4762,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4697,
  [4889] = 4693,
  [4890] = 4695,
  [4891] = 4751,
  [4892] = 2106,
  [4893] = 4893,
  [4894] = 4718,
  [4895] = 4754,
  [4896] = 4896,
  [4897] = 4897,
  [4898] = 4762,
  [4899] = 4697,
  [4900] = 4777,
  [4901] = 4901,
  [4902] = 4693,
  [4903] = 4695,
  [4904] = 4904,
  [4905] = 2105,
  [4906] = 2103,
  [4907] = 2102,
  [4908] = 4687,
  [4909] = 4909,
  [4910] = 4762,
  [4911] = 4687,
  [4912] = 2099,
  [4913] = 2097,
  [4914] = 4693,
  [4915] = 4695,
  [4916] = 2096,
  [4917] = 2056,
  [4918] = 4688,
  [4919] = 4919,
  [4920] = 4690,
  [4921] = 4921,
  [4922] = 4762,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 2091,
  [4926] = 4693,
  [4927] = 4695,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4930,
  [4931] = 4931,
  [4932] = 4690,
  [4933] = 4933,
  [4934] = 4762,
  [4935] = 4816,
  [4936] = 2089,
  [4937] = 4688,
  [4938] = 4693,
  [4939] = 4695,
  [4940] = 2081,
  [4941] = 4690,
  [4942] = 4688,
  [4943] = 4687,
  [4944] = 4944,
  [4945] = 4694,
  [4946] = 4762,
  [4947] = 4687,
  [4948] = 2080,
  [4949] = 2092,
  [4950] = 4693,
  [4951] = 4695,
  [4952] = 2057,
  [4953] = 2059,
  [4954] = 4773,
  [4955] = 2062,
  [4956] = 4956,
  [4957] = 4957,
  [4958] = 4762,
  [4959] = 4773,
  [4960] = 2063,
  [4961] = 2104,
  [4962] = 4693,
  [4963] = 4695,
  [4964] = 2055,
  [4965] = 2064,
  [4966] = 2066,
  [4967] = 2067,
  [4968] = 4968,
  [4969] = 4687,
  [4970] = 4762,
  [4971] = 4971,
  [4972] = 2069,
  [4973] = 2070,
  [4974] = 4693,
  [4975] = 4695,
  [4976] = 2071,
  [4977] = 2072,
  [4978] = 2073,
  [4979] = 2074,
  [4980] = 4697,
  [4981] = 4684,
  [4982] = 4762,
  [4983] = 4983,
  [4984] = 2075,
  [4985] = 2087,
  [4986] = 4693,
  [4987] = 4695,
  [4988] = 2078,
  [4989] = 4989,
  [4990] = 2079,
  [4991] = 4690,
  [4992] = 4688,
  [4993] = 4687,
  [4994] = 4762,
  [4995] = 2088,
  [4996] = 4996,
  [4997] = 2090,
  [4998] = 4693,
  [4999] = 4695,
  [5000] = 2094,
  [5001] = 2095,
  [5002] = 2098,
  [5003] = 2100,
  [5004] = 4703,
  [5005] = 4688,
  [5006] = 4762,
  [5007] = 5007,
  [5008] = 4690,
  [5009] = 4697,
  [5010] = 4693,
  [5011] = 4695,
  [5012] = 2076,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 4684,
  [5017] = 5017,
  [5018] = 5018,
  [5019] = 4693,
  [5020] = 4695,
  [5021] = 2177,
  [5022] = 2134,
  [5023] = 2171,
  [5024] = 2166,
  [5025] = 2164,
  [5026] = 2163,
  [5027] = 4694,
  [5028] = 2159,
  [5029] = 2158,
  [5030] = 2129,
  [5031] = 5031,
  [5032] = 4803,
  [5033] = 2157,
  [5034] = 2156,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 4684,
  [5039] = 4931,
  [5040] = 2188,
  [5041] = 5041,
  [5042] = 2138,
  [5043] = 5043,
  [5044] = 4690,
  [5045] = 2150,
  [5046] = 2139,
  [5047] = 2148,
  [5048] = 4688,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 4687,
  [5053] = 5053,
  [5054] = 5054,
  [5055] = 2147,
  [5056] = 4694,
  [5057] = 2144,
  [5058] = 4781,
  [5059] = 2172,
  [5060] = 5060,
  [5061] = 2141,
  [5062] = 4861,
  [5063] = 4696,
  [5064] = 5064,
  [5065] = 2140,
  [5066] = 5066,
  [5067] = 2041,
  [5068] = 4687,
  [5069] = 4688,
  [5070] = 4815,
  [5071] = 4690,
  [5072] = 4684,
  [5073] = 2173,
  [5074] = 2186,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 5077,
  [5078] = 5078,
  [5079] = 2179,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 4703,
  [5084] = 4703,
  [5085] = 2176,
  [5086] = 2175,
  [5087] = 2149,
  [5088] = 4697,
  [5089] = 2143,
  [5090] = 4687,
  [5091] = 4773,
  [5092] = 4736,
  [5093] = 4696,
  [5094] = 2152,
  [5095] = 4861,
  [5096] = 2146,
  [5097] = 4688,
  [5098] = 4696,
  [5099] = 4861,
  [5100] = 4690,
  [5101] = 4696,
  [5102] = 4861,
  [5103] = 5103,
  [5104] = 4696,
  [5105] = 4861,
  [5106] = 5106,
  [5107] = 4696,
  [5108] = 4861,
  [5109] = 4684,
  [5110] = 4696,
  [5111] = 4861,
  [5112] = 5112,
  [5113] = 4696,
  [5114] = 4861,
  [5115] = 5115,
  [5116] = 4696,
  [5117] = 4861,
  [5118] = 5118,
  [5119] = 4696,
  [5120] = 4861,
  [5121] = 5121,
  [5122] = 4696,
  [5123] = 4861,
  [5124] = 4928,
  [5125] = 4696,
  [5126] = 4861,
  [5127] = 5127,
  [5128] = 4696,
  [5129] = 4861,
  [5130] = 4694,
  [5131] = 4696,
  [5132] = 4861,
  [5133] = 4697,
  [5134] = 4696,
  [5135] = 4861,
  [5136] = 4930,
  [5137] = 5137,
  [5138] = 5138,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(237)
      if (lookahead == '\r') SKIP(237)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(248);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(246);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(283);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(316);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(6);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(230)
      if (lookahead == '\r') ADVANCE(328);
      if (lookahead == '"') ADVANCE(330);
      if (lookahead == '(') ADVANCE(329);
      if (lookahead == '\\') ADVANCE(331);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(328);
      if (lookahead != 0) ADVANCE(327);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(230)
      if (lookahead == '\r') ADVANCE(333);
      if (lookahead == '(') ADVANCE(334);
      if (lookahead == '\\') ADVANCE(335);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(333);
      if (lookahead != 0) ADVANCE(332);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(518);
      END_STATE();
    case 6:
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(480);
      END_STATE();
    case 8:
      if (lookahead == ')') ADVANCE(483);
      END_STATE();
    case 9:
      if (lookahead == ')') ADVANCE(496);
      END_STATE();
    case 10:
      if (lookahead == ')') ADVANCE(499);
      END_STATE();
    case 11:
      if (lookahead == ')') ADVANCE(502);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(240);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(119);
      if (lookahead == 'l') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'l') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(242);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(39);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(252);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(20);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(38);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(472);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(297);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(296);
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(31);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 31:
      if (lookahead == '=') ADVANCE(385);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 34:
      if (lookahead == '=') ADVANCE(254);
      END_STATE();
    case 35:
      if (lookahead == '=') ADVANCE(32);
      END_STATE();
    case 36:
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 37:
      if (lookahead == '>') ADVANCE(374);
      END_STATE();
    case 38:
      if (lookahead == '>') ADVANCE(271);
      END_STATE();
    case 39:
      if (lookahead == '>') ADVANCE(366);
      END_STATE();
    case 40:
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 41:
      if (lookahead == '?') ADVANCE(520);
      END_STATE();
    case 42:
      if (lookahead == '@') ADVANCE(457);
      END_STATE();
    case 43:
      if (lookahead == 'X') ADVANCE(11);
      END_STATE();
    case 44:
      if (lookahead == ']') ADVANCE(289);
      END_STATE();
    case 45:
      if (lookahead == '_') ADVANCE(348);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(134);
      if (lookahead == 'd') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'o') ADVANCE(120);
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'l') ADVANCE(423);
      if (lookahead == 'n') ADVANCE(129);
      if (lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'l') ADVANCE(423);
      if (lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(166);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(137);
      if (lookahead == 'u') ADVANCE(138);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'f') ADVANCE(55);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(155);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 56:
      if (lookahead == 'b') ADVANCE(174);
      if (lookahead == 'c') ADVANCE(61);
      if (lookahead == 'p') ADVANCE(175);
      END_STATE();
    case 57:
      if (lookahead == 'b') ADVANCE(176);
      if (lookahead == 'p') ADVANCE(177);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(50);
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(514);
      END_STATE();
    case 60:
      if (lookahead == 'c') ADVANCE(427);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(429);
      END_STATE();
    case 62:
      if (lookahead == 'c') ADVANCE(508);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(61);
      END_STATE();
    case 64:
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(187);
      END_STATE();
    case 66:
      if (lookahead == 'd') ADVANCE(378);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(143);
      if (lookahead == 'g') ADVANCE(421);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(60);
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 82:
      if (lookahead == 'g') ADVANCE(64);
      END_STATE();
    case 83:
      if (lookahead == 'g') ADVANCE(350);
      END_STATE();
    case 84:
      if (lookahead == 'g') ADVANCE(417);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(132);
      END_STATE();
    case 86:
      if (lookahead == 'h') ADVANCE(498);
      END_STATE();
    case 87:
      if (lookahead == 'h') ADVANCE(111);
      END_STATE();
    case 88:
      if (lookahead == 'i') ADVANCE(82);
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'q') ADVANCE(58);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'q') ADVANCE(58);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(63);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(173);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 94:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(264);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 110:
      if (lookahead == 'm') ADVANCE(437);
      END_STATE();
    case 111:
      if (lookahead == 'm') ADVANCE(557);
      END_STATE();
    case 112:
      if (lookahead == 'm') ADVANCE(73);
      END_STATE();
    case 113:
      if (lookahead == 'm') ADVANCE(136);
      END_STATE();
    case 114:
      if (lookahead == 'm') ADVANCE(78);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 116:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(425);
      END_STATE();
    case 118:
      if (lookahead == 'n') ADVANCE(470);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(95);
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 124:
      if (lookahead == 'o') ADVANCE(199);
      END_STATE();
    case 125:
      if (lookahead == 'o') ADVANCE(435);
      END_STATE();
    case 126:
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(157);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(180);
      END_STATE();
    case 130:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(118);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 133:
      if (lookahead == 'p') ADVANCE(139);
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 134:
      if (lookahead == 'p') ADVANCE(466);
      END_STATE();
    case 135:
      if (lookahead == 'p') ADVANCE(469);
      END_STATE();
    case 136:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 137:
      if (lookahead == 'p') ADVANCE(525);
      END_STATE();
    case 138:
      if (lookahead == 'p') ADVANCE(527);
      END_STATE();
    case 139:
      if (lookahead == 'p') ADVANCE(159);
      END_STATE();
    case 140:
      if (lookahead == 'p') ADVANCE(189);
      END_STATE();
    case 141:
      if (lookahead == 'q') ADVANCE(194);
      END_STATE();
    case 142:
      if (lookahead == 'q') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(92);
      END_STATE();
    case 143:
      if (lookahead == 'q') ADVANCE(402);
      END_STATE();
    case 144:
      if (lookahead == 'q') ADVANCE(399);
      END_STATE();
    case 145:
      if (lookahead == 'q') ADVANCE(419);
      END_STATE();
    case 146:
      if (lookahead == 'q') ADVANCE(439);
      END_STATE();
    case 147:
      if (lookahead == 'q') ADVANCE(431);
      END_STATE();
    case 148:
      if (lookahead == 'q') ADVANCE(433);
      END_STATE();
    case 149:
      if (lookahead == 'q') ADVANCE(453);
      END_STATE();
    case 150:
      if (lookahead == 'q') ADVANCE(455);
      END_STATE();
    case 151:
      if (lookahead == 'q') ADVANCE(445);
      END_STATE();
    case 152:
      if (lookahead == 'q') ADVANCE(447);
      END_STATE();
    case 153:
      if (lookahead == 'r') ADVANCE(534);
      END_STATE();
    case 154:
      if (lookahead == 'r') ADVANCE(381);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(516);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(479);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(532);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(529);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 171:
      if (lookahead == 's') ADVANCE(501);
      END_STATE();
    case 172:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 173:
      if (lookahead == 's') ADVANCE(190);
      END_STATE();
    case 174:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 175:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 176:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 177:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(536);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(349);
      END_STATE();
    case 181:
      if (lookahead == 't') ADVANCE(495);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(510);
      END_STATE();
    case 183:
      if (lookahead == 't') ADVANCE(449);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(441);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(467);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 190:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 192:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 193:
      if (lookahead == 'u') ADVANCE(165);
      END_STATE();
    case 194:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 195:
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 196:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 197:
      if (lookahead == 'v') ADVANCE(512);
      END_STATE();
    case 198:
      if (lookahead == 'v') ADVANCE(369);
      END_STATE();
    case 199:
      if (lookahead == 'x') ADVANCE(404);
      END_STATE();
    case 200:
      if (lookahead == 'y') ADVANCE(113);
      END_STATE();
    case 201:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(201)
      if (lookahead == '\r') SKIP(201)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 202:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(202)
      if (lookahead == '\r') SKIP(202)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(346);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 203:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(203)
      if (lookahead == '\r') SKIP(203)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 204:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(204)
      if (lookahead == '\r') SKIP(204)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(346);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 205:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(205)
      if (lookahead == '\r') SKIP(205)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 206:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(206)
      if (lookahead == '\r') SKIP(206)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 207:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(207)
      if (lookahead == '\r') SKIP(207)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 208:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(208)
      if (lookahead == '\r') SKIP(208)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 209:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(209)
      if (lookahead == '\r') SKIP(209)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(358);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(45);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 210:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(210)
      if (lookahead == '\r') SKIP(210)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(283);
      END_STATE();
    case 211:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(210)
      if (lookahead == '\r') SKIP(210)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(283);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(317);
      END_STATE();
    case 212:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(212)
      if (lookahead == '\r') SKIP(212)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(345);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 213:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(213)
      if (lookahead == '\r') SKIP(213)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(13);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 214:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(214)
      if (lookahead == '\r') SKIP(214)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 215:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(214)
      if (lookahead == '\r') SKIP(214)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 216:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(216)
      if (lookahead == '\r') SKIP(216)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(282);
      END_STATE();
    case 217:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(216)
      if (lookahead == '\r') SKIP(216)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(325);
      END_STATE();
    case 218:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(218)
      if (lookahead == '\r') SKIP(218)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(345);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(465);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 219:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(219)
      if (lookahead == '\r') SKIP(219)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(13);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(465);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 220:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(220)
      if (lookahead == '\r') SKIP(220)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 221:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(221)
      if (lookahead == '\r') SKIP(221)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 222:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(222)
      if (lookahead == '\r') SKIP(222)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(358);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(45);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 223:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(224)
      if (lookahead == '\r') SKIP(224)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(40);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 12297) ADVANCE(282);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(321);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 224:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(224)
      if (lookahead == '\r') SKIP(224)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(40);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 225:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(226)
      if (lookahead == '\r') SKIP(226)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(553);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ':') ADVANCE(294);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(548);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(554);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 226:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(226)
      if (lookahead == '\r') SKIP(226)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ':') ADVANCE(294);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(227)
      if (lookahead == '\r') SKIP(227)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == ':') ADVANCE(29);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(34);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10229) ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 228:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(228)
      if (lookahead == '\r') SKIP(228)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(390);
      if (lookahead == '=') ADVANCE(343);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == 8712) ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 229:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') ADVANCE(245);
      if (lookahead == '\r') ADVANCE(245);
      if (lookahead == '(') ADVANCE(249);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(247);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == ';') ADVANCE(243);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(243);
      END_STATE();
    case 230:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(230)
      if (lookahead == '\r') SKIP(230)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '\\') ADVANCE(14);
      END_STATE();
    case 231:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(230)
      if (lookahead == '\r') SKIP(230)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '\\') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(555);
      END_STATE();
    case 232:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(230)
      if (lookahead == '\r') SKIP(230)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(545);
      if (lookahead == '\\') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(547);
      END_STATE();
    case 233:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(233)
      if (lookahead == '\r') SKIP(233)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(299);
      END_STATE();
    case 234:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(233)
      if (lookahead == '\r') SKIP(233)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 235:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 236:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 237:
      if (eof) ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(237)
      if (lookahead == '\r') SKIP(237)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(248);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(246);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(239);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_STAR_RPAREN);
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(242);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(242);
      if (lookahead == '-') ADVANCE(52);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') ADVANCE(245);
      if (lookahead == '\r') ADVANCE(245);
      if (lookahead == '(') ADVANCE(249);
      if (lookahead == ')') ADVANCE(243);
      if (lookahead == '*') ADVANCE(247);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == ';') ADVANCE(243);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(243);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      if (lookahead == ')') ADVANCE(241);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != '*') ADVANCE(242);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      if (lookahead == ')') ADVANCE(242);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_single_line);
      if (lookahead == '-') ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_double_line);
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(269);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(270);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_BSLASHAA);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_BSLASHEE);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_8);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_9);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_10);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_11);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_12);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(286);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_13);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_13);
      if (lookahead == '_') ADVANCE(287);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_14);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_14);
      if (lookahead == '_') ADVANCE(288);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym__2);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_15);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(297);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(31);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(383);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(457);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(385);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_16);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(240);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(43);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(289);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '!') ADVANCE(518);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(235);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      if (lookahead == 'i') ADVANCE(82);
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_BSLASHB);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(316);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(317);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(130);
      if (lookahead == 'm') ADVANCE(96);
      if (lookahead == 'p') ADVANCE(103);
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_BSLASHO);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '8' ||
          lookahead == '9' ||
          lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(321);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_BSLASHh);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_BSLASHH);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(aux_sym_hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '(') ADVANCE(12);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '(') ADVANCE(12);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_17);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_18);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_19);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(472);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(255);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(32);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(374);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_20);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(492);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '>') ADVANCE(274);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(492);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '>') ADVANCE(274);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_21);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_22);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_23);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_24);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_25);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_26);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_27);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_28);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_29);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_30);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_31);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_32);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_33);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_34);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(522);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_35);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '<') ADVANCE(277);
      if (lookahead == '=') ADVANCE(397);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '=') ADVANCE(397);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '=') ADVANCE(397);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      if (lookahead == '>') ADVANCE(281);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(371);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_36);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_37);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_38);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(271);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_39);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_40);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_41);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_42);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_43);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_44);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_45);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_46);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_47);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_48);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_49);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_50);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_51);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_52);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_53);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_54);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_55);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_56);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_57);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_58);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_59);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_60);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_61);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_62);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_63);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'A') ADVANCE(263);
      if (lookahead == 'B') ADVANCE(315);
      if (lookahead == 'E') ADVANCE(266);
      if (lookahead == 'H') ADVANCE(324);
      if (lookahead == 'O') ADVANCE(319);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(314);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(142);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'A') ADVANCE(263);
      if (lookahead == 'B') ADVANCE(315);
      if (lookahead == 'E') ADVANCE(266);
      if (lookahead == 'H') ADVANCE(324);
      if (lookahead == 'O') ADVANCE(319);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(314);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(142);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_64);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_65);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(474);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_66);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_67);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(478);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_68);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_69);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(486);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(407);
      if (lookahead == '=') ADVANCE(409);
      if (lookahead == '|') ADVANCE(489);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(406);
      if (lookahead == '=') ADVANCE(409);
      if (lookahead == '|') ADVANCE(489);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_70);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(20);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(494);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_71);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_72);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_73);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(505);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(507);
      if (lookahead == '=') ADVANCE(387);
      if (lookahead == '\\') ADVANCE(377);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_74);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_75);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_76);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_77);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_78);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_79);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_80);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(524);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_81);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_82);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_83);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_84);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_85);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_86);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(543);
      if (lookahead == '*') ADVANCE(542);
      if (lookahead == '+') ADVANCE(540);
      if (lookahead == '^') ADVANCE(539);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_87);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(546);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(547);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (lookahead == '(') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(550);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(550);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '.') ADVANCE(552);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(552);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(554);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(555);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(aux_sym_pcal_algorithm_start_token1);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'C') ADVANCE(3);
      if (lookahead == 'D') ADVANCE(4);
      if (lookahead == 'E') ADVANCE(5);
      if (lookahead == 'F') ADVANCE(6);
      if (lookahead == 'H') ADVANCE(7);
      if (lookahead == 'I') ADVANCE(8);
      if (lookahead == 'L') ADVANCE(9);
      if (lookahead == 'M') ADVANCE(10);
      if (lookahead == 'N') ADVANCE(11);
      if (lookahead == 'O') ADVANCE(12);
      if (lookahead == 'P') ADVANCE(13);
      if (lookahead == 'Q') ADVANCE(14);
      if (lookahead == 'R') ADVANCE(15);
      if (lookahead == 'S') ADVANCE(16);
      if (lookahead == 'T') ADVANCE(17);
      if (lookahead == 'U') ADVANCE(18);
      if (lookahead == 'V') ADVANCE(19);
      if (lookahead == 'W') ADVANCE(20);
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'd') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'g') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'p') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 's') ADVANCE(33);
      if (lookahead == 't') ADVANCE(34);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(36);
      END_STATE();
    case 1:
      if (lookahead == 'C') ADVANCE(37);
      if (lookahead == 'S') ADVANCE(38);
      if (lookahead == 'X') ADVANCE(39);
      END_STATE();
    case 2:
      if (lookahead == 'O') ADVANCE(40);
      if (lookahead == 'Y') ADVANCE(41);
      END_STATE();
    case 3:
      if (lookahead == 'A') ADVANCE(42);
      if (lookahead == 'H') ADVANCE(43);
      if (lookahead == 'O') ADVANCE(44);
      END_STATE();
    case 4:
      if (lookahead == 'E') ADVANCE(45);
      if (lookahead == 'O') ADVANCE(46);
      END_STATE();
    case 5:
      if (lookahead == 'L') ADVANCE(47);
      if (lookahead == 'N') ADVANCE(48);
      if (lookahead == 'X') ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == 'A') ADVANCE(50);
      END_STATE();
    case 7:
      if (lookahead == 'A') ADVANCE(51);
      if (lookahead == 'I') ADVANCE(52);
      END_STATE();
    case 8:
      if (lookahead == 'F') ADVANCE(53);
      if (lookahead == 'N') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 9:
      if (lookahead == 'A') ADVANCE(56);
      if (lookahead == 'E') ADVANCE(57);
      if (lookahead == 'O') ADVANCE(58);
      END_STATE();
    case 10:
      if (lookahead == 'O') ADVANCE(59);
      END_STATE();
    case 11:
      if (lookahead == 'E') ADVANCE(60);
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 12:
      if (lookahead == 'B') ADVANCE(62);
      if (lookahead == 'M') ADVANCE(63);
      if (lookahead == 'N') ADVANCE(64);
      if (lookahead == 'T') ADVANCE(65);
      END_STATE();
    case 13:
      if (lookahead == 'I') ADVANCE(66);
      if (lookahead == 'R') ADVANCE(67);
      END_STATE();
    case 14:
      if (lookahead == 'E') ADVANCE(68);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(69);
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 16:
      if (lookahead == 'F') ADVANCE(71);
      if (lookahead == 'T') ADVANCE(72);
      if (lookahead == 'U') ADVANCE(73);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(74);
      if (lookahead == 'E') ADVANCE(75);
      if (lookahead == 'H') ADVANCE(76);
      if (lookahead == 'R') ADVANCE(77);
      END_STATE();
    case 18:
      if (lookahead == 'N') ADVANCE(78);
      if (lookahead == 'S') ADVANCE(79);
      END_STATE();
    case 19:
      if (lookahead == 'A') ADVANCE(80);
      END_STATE();
    case 20:
      if (lookahead == 'F') ADVANCE(81);
      if (lookahead == 'I') ADVANCE(82);
      END_STATE();
    case 21:
      if (lookahead == 'l') ADVANCE(83);
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 'w') ADVANCE(85);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(95);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 33:
      if (lookahead == 'k') ADVANCE(100);
      END_STATE();
    case 34:
      if (lookahead == 'h') ADVANCE(101);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 36:
      if (lookahead == 'h') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 37:
      if (lookahead == 'T') ADVANCE(105);
      END_STATE();
    case 38:
      if (lookahead == 'S') ADVANCE(106);
      END_STATE();
    case 39:
      if (lookahead == 'I') ADVANCE(107);
      END_STATE();
    case 40:
      if (lookahead == 'O') ADVANCE(108);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 42:
      if (lookahead == 'S') ADVANCE(109);
      END_STATE();
    case 43:
      if (lookahead == 'O') ADVANCE(110);
      END_STATE();
    case 44:
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == 'R') ADVANCE(112);
      END_STATE();
    case 45:
      if (lookahead == 'F') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'M') ADVANCE(114);
      END_STATE();
    case 47:
      if (lookahead == 'S') ADVANCE(115);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(116);
      END_STATE();
    case 49:
      if (lookahead == 'C') ADVANCE(117);
      if (lookahead == 'T') ADVANCE(118);
      END_STATE();
    case 50:
      if (lookahead == 'L') ADVANCE(119);
      END_STATE();
    case 51:
      if (lookahead == 'V') ADVANCE(120);
      END_STATE();
    case 52:
      if (lookahead == 'D') ADVANCE(121);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_IN);
      if (lookahead == 'S') ADVANCE(122);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 56:
      if (lookahead == 'M') ADVANCE(124);
      END_STATE();
    case 57:
      if (lookahead == 'M') ADVANCE(125);
      if (lookahead == 'T') ADVANCE(126);
      END_STATE();
    case 58:
      if (lookahead == 'C') ADVANCE(127);
      END_STATE();
    case 59:
      if (lookahead == 'D') ADVANCE(128);
      END_STATE();
    case 60:
      if (lookahead == 'W') ADVANCE(129);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 62:
      if (lookahead == 'V') ADVANCE(131);
      END_STATE();
    case 63:
      if (lookahead == 'I') ADVANCE(132);
      END_STATE();
    case 64:
      if (lookahead == 'L') ADVANCE(133);
      END_STATE();
    case 65:
      if (lookahead == 'H') ADVANCE(134);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(135);
      END_STATE();
    case 67:
      if (lookahead == 'O') ADVANCE(136);
      END_STATE();
    case 68:
      if (lookahead == 'D') ADVANCE(137);
      END_STATE();
    case 69:
      if (lookahead == 'C') ADVANCE(138);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'A') ADVANCE(141);
      if (lookahead == 'R') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'B') ADVANCE(143);
      if (lookahead == 'F') ADVANCE(144);
      END_STATE();
    case 74:
      if (lookahead == 'K') ADVANCE(145);
      END_STATE();
    case 75:
      if (lookahead == 'M') ADVANCE(146);
      END_STATE();
    case 76:
      if (lookahead == 'E') ADVANCE(147);
      END_STATE();
    case 77:
      if (lookahead == 'U') ADVANCE(148);
      END_STATE();
    case 78:
      if (lookahead == 'C') ADVANCE(149);
      if (lookahead == 'I') ADVANCE(150);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(151);
      END_STATE();
    case 80:
      if (lookahead == 'R') ADVANCE(152);
      END_STATE();
    case 81:
      if (lookahead == '_') ADVANCE(153);
      END_STATE();
    case 82:
      if (lookahead == 'T') ADVANCE(154);
      END_STATE();
    case 83:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(156);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(157);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(158);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(160);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 105:
      if (lookahead == 'I') ADVANCE(176);
      END_STATE();
    case 106:
      if (lookahead == 'U') ADVANCE(177);
      END_STATE();
    case 107:
      if (lookahead == 'O') ADVANCE(178);
      END_STATE();
    case 108:
      if (lookahead == 'L') ADVANCE(179);
      END_STATE();
    case 109:
      if (lookahead == 'E') ADVANCE(180);
      END_STATE();
    case 110:
      if (lookahead == 'O') ADVANCE(181);
      END_STATE();
    case 111:
      if (lookahead == 'S') ADVANCE(182);
      END_STATE();
    case 112:
      if (lookahead == 'O') ADVANCE(183);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'I') ADVANCE(184);
      if (lookahead == 'S') ADVANCE(185);
      END_STATE();
    case 114:
      if (lookahead == 'A') ADVANCE(186);
      END_STATE();
    case 115:
      if (lookahead == 'E') ADVANCE(187);
      END_STATE();
    case 116:
      if (lookahead == 'B') ADVANCE(188);
      END_STATE();
    case 117:
      if (lookahead == 'E') ADVANCE(189);
      END_STATE();
    case 118:
      if (lookahead == 'E') ADVANCE(190);
      END_STATE();
    case 119:
      if (lookahead == 'S') ADVANCE(191);
      END_STATE();
    case 120:
      if (lookahead == 'E') ADVANCE(192);
      END_STATE();
    case 121:
      if (lookahead == 'E') ADVANCE(193);
      END_STATE();
    case 122:
      if (lookahead == 'T') ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 124:
      if (lookahead == 'B') ADVANCE(195);
      END_STATE();
    case 125:
      if (lookahead == 'M') ADVANCE(196);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 127:
      if (lookahead == 'A') ADVANCE(197);
      END_STATE();
    case 128:
      if (lookahead == 'U') ADVANCE(198);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 131:
      if (lookahead == 'I') ADVANCE(199);
      END_STATE();
    case 132:
      if (lookahead == 'T') ADVANCE(200);
      END_STATE();
    case 133:
      if (lookahead == 'Y') ADVANCE(201);
      END_STATE();
    case 134:
      if (lookahead == 'E') ADVANCE(202);
      END_STATE();
    case 135:
      if (lookahead == 'K') ADVANCE(203);
      END_STATE();
    case 136:
      if (lookahead == 'O') ADVANCE(204);
      if (lookahead == 'P') ADVANCE(205);
      if (lookahead == 'V') ADVANCE(206);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 138:
      if (lookahead == 'U') ADVANCE(207);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(208);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 141:
      if (lookahead == 'T') ADVANCE(209);
      END_STATE();
    case 142:
      if (lookahead == 'I') ADVANCE(210);
      END_STATE();
    case 143:
      if (lookahead == 'S') ADVANCE(211);
      END_STATE();
    case 144:
      if (lookahead == 'F') ADVANCE(212);
      END_STATE();
    case 145:
      if (lookahead == 'E') ADVANCE(213);
      END_STATE();
    case 146:
      if (lookahead == 'P') ADVANCE(214);
      END_STATE();
    case 147:
      if (lookahead == 'N') ADVANCE(215);
      if (lookahead == 'O') ADVANCE(216);
      END_STATE();
    case 148:
      if (lookahead == 'E') ADVANCE(217);
      END_STATE();
    case 149:
      if (lookahead == 'H') ADVANCE(218);
      END_STATE();
    case 150:
      if (lookahead == 'O') ADVANCE(219);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 152:
      if (lookahead == 'I') ADVANCE(220);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 154:
      if (lookahead == 'H') ADVANCE(221);
      if (lookahead == 'N') ADVANCE(222);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(227);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 161:
      if (lookahead == 'h') ADVANCE(229);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == 'i') ADVANCE(231);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 169:
      if (lookahead == 'u') ADVANCE(237);
      END_STATE();
    case 170:
      if (lookahead == 'p') ADVANCE(238);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 172:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 173:
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 174:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 175:
      if (lookahead == 'h') ADVANCE(243);
      END_STATE();
    case 176:
      if (lookahead == 'O') ADVANCE(244);
      END_STATE();
    case 177:
      if (lookahead == 'M') ADVANCE(245);
      END_STATE();
    case 178:
      if (lookahead == 'M') ADVANCE(246);
      END_STATE();
    case 179:
      if (lookahead == 'E') ADVANCE(247);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 181:
      if (lookahead == 'S') ADVANCE(248);
      END_STATE();
    case 182:
      if (lookahead == 'T') ADVANCE(249);
      END_STATE();
    case 183:
      if (lookahead == 'L') ADVANCE(250);
      END_STATE();
    case 184:
      if (lookahead == 'N') ADVANCE(251);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 186:
      if (lookahead == 'I') ADVANCE(252);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 188:
      if (lookahead == 'L') ADVANCE(253);
      END_STATE();
    case 189:
      if (lookahead == 'P') ADVANCE(254);
      END_STATE();
    case 190:
      if (lookahead == 'N') ADVANCE(255);
      END_STATE();
    case 191:
      if (lookahead == 'E') ADVANCE(256);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 194:
      if (lookahead == 'A') ADVANCE(257);
      END_STATE();
    case 195:
      if (lookahead == 'D') ADVANCE(258);
      END_STATE();
    case 196:
      if (lookahead == 'A') ADVANCE(259);
      END_STATE();
    case 197:
      if (lookahead == 'L') ADVANCE(260);
      END_STATE();
    case 198:
      if (lookahead == 'L') ADVANCE(261);
      END_STATE();
    case 199:
      if (lookahead == 'O') ADVANCE(262);
      END_STATE();
    case 200:
      if (lookahead == 'T') ADVANCE(263);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 202:
      if (lookahead == 'R') ADVANCE(264);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 204:
      if (lookahead == 'F') ADVANCE(265);
      END_STATE();
    case 205:
      if (lookahead == 'O') ADVANCE(266);
      END_STATE();
    case 206:
      if (lookahead == 'E') ADVANCE(267);
      END_STATE();
    case 207:
      if (lookahead == 'R') ADVANCE(268);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 209:
      if (lookahead == 'E') ADVANCE(269);
      END_STATE();
    case 210:
      if (lookahead == 'N') ADVANCE(270);
      END_STATE();
    case 211:
      if (lookahead == 'E') ADVANCE(271);
      END_STATE();
    case 212:
      if (lookahead == 'I') ADVANCE(272);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 214:
      if (lookahead == 'O') ADVANCE(273);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 216:
      if (lookahead == 'R') ADVANCE(274);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 218:
      if (lookahead == 'A') ADVANCE(275);
      END_STATE();
    case 219:
      if (lookahead == 'N') ADVANCE(276);
      END_STATE();
    case 220:
      if (lookahead == 'A') ADVANCE(277);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 222:
      if (lookahead == 'E') ADVANCE(278);
      END_STATE();
    case 223:
      if (lookahead == 'r') ADVANCE(279);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(280);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_call);
      END_STATE();
    case 228:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 231:
      if (lookahead == 'f') ADVANCE(285);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_fair);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 234:
      if (lookahead == 'o') ADVANCE(286);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_skip);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(290);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 244:
      if (lookahead == 'N') ADVANCE(292);
      END_STATE();
    case 245:
      if (lookahead == 'E') ADVANCE(293);
      if (lookahead == 'P') ADVANCE(294);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 247:
      if (lookahead == 'A') ADVANCE(295);
      END_STATE();
    case 248:
      if (lookahead == 'E') ADVANCE(296);
      END_STATE();
    case 249:
      if (lookahead == 'A') ADVANCE(297);
      END_STATE();
    case 250:
      if (lookahead == 'L') ADVANCE(298);
      END_STATE();
    case 251:
      if (lookahead == 'E') ADVANCE(299);
      END_STATE();
    case 252:
      if (lookahead == 'N') ADVANCE(300);
      END_STATE();
    case 253:
      if (lookahead == 'E') ADVANCE(301);
      END_STATE();
    case 254:
      if (lookahead == 'T') ADVANCE(302);
      END_STATE();
    case 255:
      if (lookahead == 'D') ADVANCE(303);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 257:
      if (lookahead == 'N') ADVANCE(304);
      END_STATE();
    case 258:
      if (lookahead == 'A') ADVANCE(305);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 261:
      if (lookahead == 'E') ADVANCE(306);
      END_STATE();
    case 262:
      if (lookahead == 'U') ADVANCE(307);
      END_STATE();
    case 263:
      if (lookahead == 'E') ADVANCE(308);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 266:
      if (lookahead == 'S') ADVANCE(309);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 268:
      if (lookahead == 'S') ADVANCE(310);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 270:
      if (lookahead == 'G') ADVANCE(311);
      END_STATE();
    case 271:
      if (lookahead == 'T') ADVANCE(312);
      END_STATE();
    case 272:
      if (lookahead == 'C') ADVANCE(313);
      END_STATE();
    case 273:
      if (lookahead == 'R') ADVANCE(314);
      END_STATE();
    case 274:
      if (lookahead == 'E') ADVANCE(315);
      END_STATE();
    case 275:
      if (lookahead == 'N') ADVANCE(316);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 277:
      if (lookahead == 'B') ADVANCE(317);
      END_STATE();
    case 278:
      if (lookahead == 'S') ADVANCE(318);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 284:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(323);
      if (lookahead == 's') ADVANCE(324);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 290:
      if (lookahead == 'b') ADVANCE(326);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 294:
      if (lookahead == 'T') ADVANCE(327);
      END_STATE();
    case 295:
      if (lookahead == 'N') ADVANCE(328);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 297:
      if (lookahead == 'N') ADVANCE(329);
      END_STATE();
    case 298:
      if (lookahead == 'A') ADVANCE(330);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      END_STATE();
    case 301:
      if (lookahead == 'D') ADVANCE(331);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 303:
      if (lookahead == 'S') ADVANCE(332);
      END_STATE();
    case 304:
      if (lookahead == 'C') ADVANCE(333);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 307:
      if (lookahead == 'S') ADVANCE(334);
      END_STATE();
    case 308:
      if (lookahead == 'D') ADVANCE(335);
      END_STATE();
    case 309:
      if (lookahead == 'I') ADVANCE(336);
      END_STATE();
    case 310:
      if (lookahead == 'I') ADVANCE(337);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_string_set);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      END_STATE();
    case 313:
      if (lookahead == 'E') ADVANCE(338);
      END_STATE();
    case 314:
      if (lookahead == 'A') ADVANCE(339);
      END_STATE();
    case 315:
      if (lookahead == 'M') ADVANCE(340);
      END_STATE();
    case 316:
      if (lookahead == 'G') ADVANCE(341);
      END_STATE();
    case 317:
      if (lookahead == 'L') ADVANCE(342);
      END_STATE();
    case 318:
      if (lookahead == 'S') ADVANCE(343);
      END_STATE();
    case 319:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_define);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_either);
      END_STATE();
    case 323:
      if (lookahead == 'u') ADVANCE(345);
      END_STATE();
    case 324:
      if (lookahead == 's') ADVANCE(346);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 326:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 327:
      if (lookahead == 'I') ADVANCE(348);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_boolean_set);
      END_STATE();
    case 329:
      if (lookahead == 'T') ADVANCE(349);
      END_STATE();
    case 330:
      if (lookahead == 'R') ADVANCE(350);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 333:
      if (lookahead == 'E') ADVANCE(351);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 336:
      if (lookahead == 'T') ADVANCE(352);
      END_STATE();
    case 337:
      if (lookahead == 'V') ADVANCE(353);
      END_STATE();
    case 338:
      if (lookahead == 'S') ADVANCE(354);
      END_STATE();
    case 339:
      if (lookahead == 'L') ADVANCE(355);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 341:
      if (lookahead == 'E') ADVANCE(356);
      END_STATE();
    case 342:
      if (lookahead == 'E') ADVANCE(357);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 344:
      if (lookahead == 'h') ADVANCE(358);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(359);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_process);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(360);
      END_STATE();
    case 348:
      if (lookahead == 'O') ADVANCE(361);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(362);
      END_STATE();
    case 350:
      if (lookahead == 'Y') ADVANCE(363);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      END_STATE();
    case 352:
      if (lookahead == 'I') ADVANCE(364);
      END_STATE();
    case 353:
      if (lookahead == 'E') ADVANCE(365);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 356:
      if (lookahead == 'D') ADVANCE(366);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(367);
      END_STATE();
    case 358:
      if (lookahead == 'm') ADVANCE(368);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(369);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_variable);
      if (lookahead == 's') ADVANCE(370);
      END_STATE();
    case 361:
      if (lookahead == 'N') ADVANCE(371);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 364:
      if (lookahead == 'O') ADVANCE(372);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_algorithm);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_procedure);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_variables);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 372:
      if (lookahead == 'N') ADVANCE(373);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 201, .external_lex_state = 3},
  [3] = {.lex_state = 201, .external_lex_state = 3},
  [4] = {.lex_state = 201, .external_lex_state = 4},
  [5] = {.lex_state = 202, .external_lex_state = 4},
  [6] = {.lex_state = 202, .external_lex_state = 4},
  [7] = {.lex_state = 202, .external_lex_state = 4},
  [8] = {.lex_state = 202, .external_lex_state = 4},
  [9] = {.lex_state = 201, .external_lex_state = 4},
  [10] = {.lex_state = 201, .external_lex_state = 4},
  [11] = {.lex_state = 201, .external_lex_state = 4},
  [12] = {.lex_state = 201, .external_lex_state = 4},
  [13] = {.lex_state = 201, .external_lex_state = 4},
  [14] = {.lex_state = 201, .external_lex_state = 4},
  [15] = {.lex_state = 201, .external_lex_state = 4},
  [16] = {.lex_state = 201, .external_lex_state = 4},
  [17] = {.lex_state = 201, .external_lex_state = 4},
  [18] = {.lex_state = 201, .external_lex_state = 4},
  [19] = {.lex_state = 201, .external_lex_state = 4},
  [20] = {.lex_state = 201, .external_lex_state = 4},
  [21] = {.lex_state = 201, .external_lex_state = 4},
  [22] = {.lex_state = 201, .external_lex_state = 4},
  [23] = {.lex_state = 201, .external_lex_state = 4},
  [24] = {.lex_state = 201, .external_lex_state = 4},
  [25] = {.lex_state = 201, .external_lex_state = 4},
  [26] = {.lex_state = 201, .external_lex_state = 4},
  [27] = {.lex_state = 201, .external_lex_state = 4},
  [28] = {.lex_state = 201, .external_lex_state = 4},
  [29] = {.lex_state = 201, .external_lex_state = 4},
  [30] = {.lex_state = 201, .external_lex_state = 4},
  [31] = {.lex_state = 201, .external_lex_state = 4},
  [32] = {.lex_state = 201, .external_lex_state = 4},
  [33] = {.lex_state = 201, .external_lex_state = 4},
  [34] = {.lex_state = 201, .external_lex_state = 4},
  [35] = {.lex_state = 201, .external_lex_state = 4},
  [36] = {.lex_state = 201, .external_lex_state = 4},
  [37] = {.lex_state = 203, .external_lex_state = 4},
  [38] = {.lex_state = 203, .external_lex_state = 4},
  [39] = {.lex_state = 201, .external_lex_state = 4},
  [40] = {.lex_state = 201, .external_lex_state = 4},
  [41] = {.lex_state = 201, .external_lex_state = 4},
  [42] = {.lex_state = 201, .external_lex_state = 4},
  [43] = {.lex_state = 201, .external_lex_state = 4},
  [44] = {.lex_state = 201, .external_lex_state = 4},
  [45] = {.lex_state = 201, .external_lex_state = 4},
  [46] = {.lex_state = 201, .external_lex_state = 4},
  [47] = {.lex_state = 201, .external_lex_state = 4},
  [48] = {.lex_state = 201, .external_lex_state = 4},
  [49] = {.lex_state = 201, .external_lex_state = 4},
  [50] = {.lex_state = 201, .external_lex_state = 4},
  [51] = {.lex_state = 201, .external_lex_state = 4},
  [52] = {.lex_state = 203, .external_lex_state = 4},
  [53] = {.lex_state = 201, .external_lex_state = 4},
  [54] = {.lex_state = 203, .external_lex_state = 4},
  [55] = {.lex_state = 201, .external_lex_state = 4},
  [56] = {.lex_state = 201, .external_lex_state = 4},
  [57] = {.lex_state = 201, .external_lex_state = 4},
  [58] = {.lex_state = 201, .external_lex_state = 4},
  [59] = {.lex_state = 201, .external_lex_state = 4},
  [60] = {.lex_state = 203, .external_lex_state = 4},
  [61] = {.lex_state = 201, .external_lex_state = 4},
  [62] = {.lex_state = 201, .external_lex_state = 4},
  [63] = {.lex_state = 201, .external_lex_state = 4},
  [64] = {.lex_state = 201, .external_lex_state = 4},
  [65] = {.lex_state = 201, .external_lex_state = 4},
  [66] = {.lex_state = 201, .external_lex_state = 4},
  [67] = {.lex_state = 201, .external_lex_state = 4},
  [68] = {.lex_state = 201, .external_lex_state = 4},
  [69] = {.lex_state = 201, .external_lex_state = 4},
  [70] = {.lex_state = 201, .external_lex_state = 4},
  [71] = {.lex_state = 201, .external_lex_state = 4},
  [72] = {.lex_state = 201, .external_lex_state = 4},
  [73] = {.lex_state = 201, .external_lex_state = 4},
  [74] = {.lex_state = 201, .external_lex_state = 4},
  [75] = {.lex_state = 201, .external_lex_state = 4},
  [76] = {.lex_state = 201, .external_lex_state = 4},
  [77] = {.lex_state = 201, .external_lex_state = 4},
  [78] = {.lex_state = 201, .external_lex_state = 4},
  [79] = {.lex_state = 201, .external_lex_state = 4},
  [80] = {.lex_state = 203, .external_lex_state = 4},
  [81] = {.lex_state = 203, .external_lex_state = 4},
  [82] = {.lex_state = 201, .external_lex_state = 4},
  [83] = {.lex_state = 201, .external_lex_state = 4},
  [84] = {.lex_state = 203, .external_lex_state = 4},
  [85] = {.lex_state = 201, .external_lex_state = 4},
  [86] = {.lex_state = 203, .external_lex_state = 4},
  [87] = {.lex_state = 201, .external_lex_state = 4},
  [88] = {.lex_state = 201, .external_lex_state = 4},
  [89] = {.lex_state = 201, .external_lex_state = 4},
  [90] = {.lex_state = 201, .external_lex_state = 4},
  [91] = {.lex_state = 201, .external_lex_state = 4},
  [92] = {.lex_state = 203, .external_lex_state = 4},
  [93] = {.lex_state = 203, .external_lex_state = 4},
  [94] = {.lex_state = 201, .external_lex_state = 4},
  [95] = {.lex_state = 203, .external_lex_state = 4},
  [96] = {.lex_state = 201, .external_lex_state = 4},
  [97] = {.lex_state = 203, .external_lex_state = 4},
  [98] = {.lex_state = 201, .external_lex_state = 4},
  [99] = {.lex_state = 201, .external_lex_state = 4},
  [100] = {.lex_state = 201, .external_lex_state = 4},
  [101] = {.lex_state = 201, .external_lex_state = 4},
  [102] = {.lex_state = 203, .external_lex_state = 4},
  [103] = {.lex_state = 201, .external_lex_state = 4},
  [104] = {.lex_state = 201, .external_lex_state = 4},
  [105] = {.lex_state = 201, .external_lex_state = 4},
  [106] = {.lex_state = 201, .external_lex_state = 4},
  [107] = {.lex_state = 201, .external_lex_state = 4},
  [108] = {.lex_state = 201, .external_lex_state = 4},
  [109] = {.lex_state = 201, .external_lex_state = 4},
  [110] = {.lex_state = 201, .external_lex_state = 4},
  [111] = {.lex_state = 203, .external_lex_state = 4},
  [112] = {.lex_state = 203, .external_lex_state = 4},
  [113] = {.lex_state = 203, .external_lex_state = 4},
  [114] = {.lex_state = 201, .external_lex_state = 4},
  [115] = {.lex_state = 201, .external_lex_state = 4},
  [116] = {.lex_state = 203, .external_lex_state = 4},
  [117] = {.lex_state = 201, .external_lex_state = 4},
  [118] = {.lex_state = 201, .external_lex_state = 4},
  [119] = {.lex_state = 201, .external_lex_state = 4},
  [120] = {.lex_state = 201, .external_lex_state = 4},
  [121] = {.lex_state = 201, .external_lex_state = 4},
  [122] = {.lex_state = 201, .external_lex_state = 4},
  [123] = {.lex_state = 201, .external_lex_state = 4},
  [124] = {.lex_state = 201, .external_lex_state = 4},
  [125] = {.lex_state = 201, .external_lex_state = 4},
  [126] = {.lex_state = 201, .external_lex_state = 4},
  [127] = {.lex_state = 201, .external_lex_state = 4},
  [128] = {.lex_state = 201, .external_lex_state = 4},
  [129] = {.lex_state = 201, .external_lex_state = 4},
  [130] = {.lex_state = 201, .external_lex_state = 5},
  [131] = {.lex_state = 201, .external_lex_state = 4},
  [132] = {.lex_state = 201, .external_lex_state = 4},
  [133] = {.lex_state = 201, .external_lex_state = 4},
  [134] = {.lex_state = 201, .external_lex_state = 4},
  [135] = {.lex_state = 201, .external_lex_state = 4},
  [136] = {.lex_state = 201, .external_lex_state = 4},
  [137] = {.lex_state = 201, .external_lex_state = 4},
  [138] = {.lex_state = 201, .external_lex_state = 4},
  [139] = {.lex_state = 201, .external_lex_state = 4},
  [140] = {.lex_state = 201, .external_lex_state = 4},
  [141] = {.lex_state = 201, .external_lex_state = 4},
  [142] = {.lex_state = 201, .external_lex_state = 4},
  [143] = {.lex_state = 201, .external_lex_state = 4},
  [144] = {.lex_state = 201, .external_lex_state = 4},
  [145] = {.lex_state = 201, .external_lex_state = 4},
  [146] = {.lex_state = 201, .external_lex_state = 4},
  [147] = {.lex_state = 201, .external_lex_state = 4},
  [148] = {.lex_state = 201, .external_lex_state = 4},
  [149] = {.lex_state = 201, .external_lex_state = 4},
  [150] = {.lex_state = 201, .external_lex_state = 4},
  [151] = {.lex_state = 201, .external_lex_state = 4},
  [152] = {.lex_state = 201, .external_lex_state = 4},
  [153] = {.lex_state = 201, .external_lex_state = 4},
  [154] = {.lex_state = 201, .external_lex_state = 4},
  [155] = {.lex_state = 201, .external_lex_state = 4},
  [156] = {.lex_state = 201, .external_lex_state = 4},
  [157] = {.lex_state = 201, .external_lex_state = 4},
  [158] = {.lex_state = 201, .external_lex_state = 4},
  [159] = {.lex_state = 201, .external_lex_state = 4},
  [160] = {.lex_state = 201, .external_lex_state = 4},
  [161] = {.lex_state = 201, .external_lex_state = 4},
  [162] = {.lex_state = 201, .external_lex_state = 4},
  [163] = {.lex_state = 201, .external_lex_state = 5},
  [164] = {.lex_state = 201, .external_lex_state = 5},
  [165] = {.lex_state = 201, .external_lex_state = 5},
  [166] = {.lex_state = 201, .external_lex_state = 5},
  [167] = {.lex_state = 201, .external_lex_state = 4},
  [168] = {.lex_state = 201, .external_lex_state = 4},
  [169] = {.lex_state = 201, .external_lex_state = 5},
  [170] = {.lex_state = 201, .external_lex_state = 4},
  [171] = {.lex_state = 201, .external_lex_state = 4},
  [172] = {.lex_state = 201, .external_lex_state = 5},
  [173] = {.lex_state = 201, .external_lex_state = 4},
  [174] = {.lex_state = 201, .external_lex_state = 5},
  [175] = {.lex_state = 201, .external_lex_state = 4},
  [176] = {.lex_state = 201, .external_lex_state = 4},
  [177] = {.lex_state = 201, .external_lex_state = 4},
  [178] = {.lex_state = 201, .external_lex_state = 4},
  [179] = {.lex_state = 201, .external_lex_state = 4},
  [180] = {.lex_state = 201, .external_lex_state = 4},
  [181] = {.lex_state = 201, .external_lex_state = 4},
  [182] = {.lex_state = 201, .external_lex_state = 4},
  [183] = {.lex_state = 201, .external_lex_state = 4},
  [184] = {.lex_state = 201, .external_lex_state = 4},
  [185] = {.lex_state = 201, .external_lex_state = 4},
  [186] = {.lex_state = 201, .external_lex_state = 4},
  [187] = {.lex_state = 201, .external_lex_state = 4},
  [188] = {.lex_state = 201, .external_lex_state = 4},
  [189] = {.lex_state = 201, .external_lex_state = 4},
  [190] = {.lex_state = 201, .external_lex_state = 4},
  [191] = {.lex_state = 201, .external_lex_state = 4},
  [192] = {.lex_state = 201, .external_lex_state = 4},
  [193] = {.lex_state = 201, .external_lex_state = 4},
  [194] = {.lex_state = 201, .external_lex_state = 4},
  [195] = {.lex_state = 201, .external_lex_state = 4},
  [196] = {.lex_state = 201, .external_lex_state = 4},
  [197] = {.lex_state = 201, .external_lex_state = 4},
  [198] = {.lex_state = 201, .external_lex_state = 4},
  [199] = {.lex_state = 201, .external_lex_state = 4},
  [200] = {.lex_state = 201, .external_lex_state = 4},
  [201] = {.lex_state = 201, .external_lex_state = 4},
  [202] = {.lex_state = 201, .external_lex_state = 4},
  [203] = {.lex_state = 201, .external_lex_state = 4},
  [204] = {.lex_state = 201, .external_lex_state = 4},
  [205] = {.lex_state = 201, .external_lex_state = 4},
  [206] = {.lex_state = 201, .external_lex_state = 4},
  [207] = {.lex_state = 201, .external_lex_state = 4},
  [208] = {.lex_state = 201, .external_lex_state = 4},
  [209] = {.lex_state = 201, .external_lex_state = 4},
  [210] = {.lex_state = 201, .external_lex_state = 4},
  [211] = {.lex_state = 201, .external_lex_state = 4},
  [212] = {.lex_state = 201, .external_lex_state = 4},
  [213] = {.lex_state = 201, .external_lex_state = 4},
  [214] = {.lex_state = 201, .external_lex_state = 4},
  [215] = {.lex_state = 201, .external_lex_state = 4},
  [216] = {.lex_state = 201, .external_lex_state = 4},
  [217] = {.lex_state = 201, .external_lex_state = 4},
  [218] = {.lex_state = 201, .external_lex_state = 4},
  [219] = {.lex_state = 201, .external_lex_state = 4},
  [220] = {.lex_state = 201, .external_lex_state = 4},
  [221] = {.lex_state = 201, .external_lex_state = 4},
  [222] = {.lex_state = 201, .external_lex_state = 4},
  [223] = {.lex_state = 201, .external_lex_state = 4},
  [224] = {.lex_state = 201, .external_lex_state = 4},
  [225] = {.lex_state = 201, .external_lex_state = 4},
  [226] = {.lex_state = 201, .external_lex_state = 4},
  [227] = {.lex_state = 201, .external_lex_state = 4},
  [228] = {.lex_state = 201, .external_lex_state = 4},
  [229] = {.lex_state = 201, .external_lex_state = 4},
  [230] = {.lex_state = 201, .external_lex_state = 4},
  [231] = {.lex_state = 201, .external_lex_state = 4},
  [232] = {.lex_state = 201, .external_lex_state = 4},
  [233] = {.lex_state = 201, .external_lex_state = 4},
  [234] = {.lex_state = 201, .external_lex_state = 4},
  [235] = {.lex_state = 201, .external_lex_state = 4},
  [236] = {.lex_state = 201, .external_lex_state = 4},
  [237] = {.lex_state = 201, .external_lex_state = 4},
  [238] = {.lex_state = 201, .external_lex_state = 4},
  [239] = {.lex_state = 201, .external_lex_state = 4},
  [240] = {.lex_state = 201, .external_lex_state = 4},
  [241] = {.lex_state = 201, .external_lex_state = 4},
  [242] = {.lex_state = 201, .external_lex_state = 4},
  [243] = {.lex_state = 201, .external_lex_state = 4},
  [244] = {.lex_state = 201, .external_lex_state = 4},
  [245] = {.lex_state = 201, .external_lex_state = 4},
  [246] = {.lex_state = 201, .external_lex_state = 4},
  [247] = {.lex_state = 201, .external_lex_state = 4},
  [248] = {.lex_state = 201, .external_lex_state = 4},
  [249] = {.lex_state = 201, .external_lex_state = 4},
  [250] = {.lex_state = 201, .external_lex_state = 4},
  [251] = {.lex_state = 201, .external_lex_state = 4},
  [252] = {.lex_state = 201, .external_lex_state = 4},
  [253] = {.lex_state = 201, .external_lex_state = 4},
  [254] = {.lex_state = 201, .external_lex_state = 4},
  [255] = {.lex_state = 201, .external_lex_state = 4},
  [256] = {.lex_state = 201, .external_lex_state = 4},
  [257] = {.lex_state = 201, .external_lex_state = 4},
  [258] = {.lex_state = 201, .external_lex_state = 4},
  [259] = {.lex_state = 201, .external_lex_state = 4},
  [260] = {.lex_state = 201, .external_lex_state = 4},
  [261] = {.lex_state = 201, .external_lex_state = 4},
  [262] = {.lex_state = 201, .external_lex_state = 4},
  [263] = {.lex_state = 201, .external_lex_state = 4},
  [264] = {.lex_state = 201, .external_lex_state = 4},
  [265] = {.lex_state = 201, .external_lex_state = 4},
  [266] = {.lex_state = 201, .external_lex_state = 4},
  [267] = {.lex_state = 201, .external_lex_state = 4},
  [268] = {.lex_state = 201, .external_lex_state = 4},
  [269] = {.lex_state = 201, .external_lex_state = 4},
  [270] = {.lex_state = 201, .external_lex_state = 4},
  [271] = {.lex_state = 201, .external_lex_state = 4},
  [272] = {.lex_state = 201, .external_lex_state = 4},
  [273] = {.lex_state = 201, .external_lex_state = 4},
  [274] = {.lex_state = 201, .external_lex_state = 4},
  [275] = {.lex_state = 201, .external_lex_state = 4},
  [276] = {.lex_state = 201, .external_lex_state = 4},
  [277] = {.lex_state = 201, .external_lex_state = 4},
  [278] = {.lex_state = 201, .external_lex_state = 4},
  [279] = {.lex_state = 201, .external_lex_state = 4},
  [280] = {.lex_state = 201, .external_lex_state = 4},
  [281] = {.lex_state = 201, .external_lex_state = 4},
  [282] = {.lex_state = 201, .external_lex_state = 4},
  [283] = {.lex_state = 201, .external_lex_state = 4},
  [284] = {.lex_state = 201, .external_lex_state = 4},
  [285] = {.lex_state = 201, .external_lex_state = 4},
  [286] = {.lex_state = 201, .external_lex_state = 4},
  [287] = {.lex_state = 201, .external_lex_state = 4},
  [288] = {.lex_state = 201, .external_lex_state = 4},
  [289] = {.lex_state = 201, .external_lex_state = 4},
  [290] = {.lex_state = 201, .external_lex_state = 4},
  [291] = {.lex_state = 201, .external_lex_state = 4},
  [292] = {.lex_state = 201, .external_lex_state = 4},
  [293] = {.lex_state = 201, .external_lex_state = 4},
  [294] = {.lex_state = 201, .external_lex_state = 4},
  [295] = {.lex_state = 201, .external_lex_state = 4},
  [296] = {.lex_state = 201, .external_lex_state = 4},
  [297] = {.lex_state = 201, .external_lex_state = 4},
  [298] = {.lex_state = 201, .external_lex_state = 4},
  [299] = {.lex_state = 201, .external_lex_state = 4},
  [300] = {.lex_state = 201, .external_lex_state = 4},
  [301] = {.lex_state = 201, .external_lex_state = 4},
  [302] = {.lex_state = 201, .external_lex_state = 4},
  [303] = {.lex_state = 201, .external_lex_state = 4},
  [304] = {.lex_state = 201, .external_lex_state = 4},
  [305] = {.lex_state = 201, .external_lex_state = 4},
  [306] = {.lex_state = 201, .external_lex_state = 4},
  [307] = {.lex_state = 201, .external_lex_state = 4},
  [308] = {.lex_state = 201, .external_lex_state = 4},
  [309] = {.lex_state = 201, .external_lex_state = 4},
  [310] = {.lex_state = 201, .external_lex_state = 4},
  [311] = {.lex_state = 201, .external_lex_state = 4},
  [312] = {.lex_state = 201, .external_lex_state = 4},
  [313] = {.lex_state = 201, .external_lex_state = 4},
  [314] = {.lex_state = 201, .external_lex_state = 4},
  [315] = {.lex_state = 201, .external_lex_state = 4},
  [316] = {.lex_state = 201, .external_lex_state = 4},
  [317] = {.lex_state = 201, .external_lex_state = 4},
  [318] = {.lex_state = 201, .external_lex_state = 4},
  [319] = {.lex_state = 201, .external_lex_state = 4},
  [320] = {.lex_state = 201, .external_lex_state = 4},
  [321] = {.lex_state = 201, .external_lex_state = 4},
  [322] = {.lex_state = 201, .external_lex_state = 4},
  [323] = {.lex_state = 201, .external_lex_state = 4},
  [324] = {.lex_state = 201, .external_lex_state = 4},
  [325] = {.lex_state = 201, .external_lex_state = 4},
  [326] = {.lex_state = 201, .external_lex_state = 4},
  [327] = {.lex_state = 201, .external_lex_state = 4},
  [328] = {.lex_state = 201, .external_lex_state = 4},
  [329] = {.lex_state = 201, .external_lex_state = 4},
  [330] = {.lex_state = 201, .external_lex_state = 4},
  [331] = {.lex_state = 201, .external_lex_state = 4},
  [332] = {.lex_state = 201, .external_lex_state = 4},
  [333] = {.lex_state = 201, .external_lex_state = 4},
  [334] = {.lex_state = 201, .external_lex_state = 4},
  [335] = {.lex_state = 201, .external_lex_state = 4},
  [336] = {.lex_state = 201, .external_lex_state = 4},
  [337] = {.lex_state = 201, .external_lex_state = 4},
  [338] = {.lex_state = 201, .external_lex_state = 4},
  [339] = {.lex_state = 201, .external_lex_state = 4},
  [340] = {.lex_state = 201, .external_lex_state = 4},
  [341] = {.lex_state = 201, .external_lex_state = 4},
  [342] = {.lex_state = 201, .external_lex_state = 4},
  [343] = {.lex_state = 201, .external_lex_state = 4},
  [344] = {.lex_state = 201, .external_lex_state = 4},
  [345] = {.lex_state = 201, .external_lex_state = 4},
  [346] = {.lex_state = 201, .external_lex_state = 4},
  [347] = {.lex_state = 201, .external_lex_state = 4},
  [348] = {.lex_state = 201, .external_lex_state = 4},
  [349] = {.lex_state = 201, .external_lex_state = 4},
  [350] = {.lex_state = 201, .external_lex_state = 4},
  [351] = {.lex_state = 201, .external_lex_state = 4},
  [352] = {.lex_state = 201, .external_lex_state = 4},
  [353] = {.lex_state = 201, .external_lex_state = 4},
  [354] = {.lex_state = 201, .external_lex_state = 4},
  [355] = {.lex_state = 201, .external_lex_state = 4},
  [356] = {.lex_state = 201, .external_lex_state = 4},
  [357] = {.lex_state = 201, .external_lex_state = 4},
  [358] = {.lex_state = 201, .external_lex_state = 4},
  [359] = {.lex_state = 201, .external_lex_state = 4},
  [360] = {.lex_state = 201, .external_lex_state = 4},
  [361] = {.lex_state = 201, .external_lex_state = 4},
  [362] = {.lex_state = 201, .external_lex_state = 4},
  [363] = {.lex_state = 201, .external_lex_state = 4},
  [364] = {.lex_state = 201, .external_lex_state = 4},
  [365] = {.lex_state = 201, .external_lex_state = 4},
  [366] = {.lex_state = 201, .external_lex_state = 4},
  [367] = {.lex_state = 201, .external_lex_state = 4},
  [368] = {.lex_state = 201, .external_lex_state = 4},
  [369] = {.lex_state = 201, .external_lex_state = 4},
  [370] = {.lex_state = 201, .external_lex_state = 4},
  [371] = {.lex_state = 201, .external_lex_state = 4},
  [372] = {.lex_state = 201, .external_lex_state = 4},
  [373] = {.lex_state = 201, .external_lex_state = 4},
  [374] = {.lex_state = 201, .external_lex_state = 4},
  [375] = {.lex_state = 201, .external_lex_state = 4},
  [376] = {.lex_state = 201, .external_lex_state = 4},
  [377] = {.lex_state = 201, .external_lex_state = 4},
  [378] = {.lex_state = 201, .external_lex_state = 4},
  [379] = {.lex_state = 201, .external_lex_state = 4},
  [380] = {.lex_state = 201, .external_lex_state = 4},
  [381] = {.lex_state = 201, .external_lex_state = 4},
  [382] = {.lex_state = 201, .external_lex_state = 4},
  [383] = {.lex_state = 201, .external_lex_state = 4},
  [384] = {.lex_state = 201, .external_lex_state = 4},
  [385] = {.lex_state = 201, .external_lex_state = 4},
  [386] = {.lex_state = 201, .external_lex_state = 4},
  [387] = {.lex_state = 201, .external_lex_state = 4},
  [388] = {.lex_state = 201, .external_lex_state = 4},
  [389] = {.lex_state = 201, .external_lex_state = 4},
  [390] = {.lex_state = 201, .external_lex_state = 4},
  [391] = {.lex_state = 201, .external_lex_state = 4},
  [392] = {.lex_state = 201, .external_lex_state = 4},
  [393] = {.lex_state = 201, .external_lex_state = 4},
  [394] = {.lex_state = 201, .external_lex_state = 4},
  [395] = {.lex_state = 201, .external_lex_state = 4},
  [396] = {.lex_state = 201, .external_lex_state = 4},
  [397] = {.lex_state = 201, .external_lex_state = 4},
  [398] = {.lex_state = 201, .external_lex_state = 4},
  [399] = {.lex_state = 201, .external_lex_state = 4},
  [400] = {.lex_state = 201, .external_lex_state = 4},
  [401] = {.lex_state = 201, .external_lex_state = 4},
  [402] = {.lex_state = 201, .external_lex_state = 4},
  [403] = {.lex_state = 201, .external_lex_state = 4},
  [404] = {.lex_state = 201, .external_lex_state = 4},
  [405] = {.lex_state = 201, .external_lex_state = 4},
  [406] = {.lex_state = 201, .external_lex_state = 4},
  [407] = {.lex_state = 201, .external_lex_state = 4},
  [408] = {.lex_state = 201, .external_lex_state = 4},
  [409] = {.lex_state = 201, .external_lex_state = 4},
  [410] = {.lex_state = 201, .external_lex_state = 4},
  [411] = {.lex_state = 201, .external_lex_state = 4},
  [412] = {.lex_state = 201, .external_lex_state = 4},
  [413] = {.lex_state = 201, .external_lex_state = 4},
  [414] = {.lex_state = 201, .external_lex_state = 4},
  [415] = {.lex_state = 201, .external_lex_state = 4},
  [416] = {.lex_state = 201, .external_lex_state = 4},
  [417] = {.lex_state = 201, .external_lex_state = 4},
  [418] = {.lex_state = 201, .external_lex_state = 4},
  [419] = {.lex_state = 201, .external_lex_state = 4},
  [420] = {.lex_state = 201, .external_lex_state = 4},
  [421] = {.lex_state = 201, .external_lex_state = 4},
  [422] = {.lex_state = 201, .external_lex_state = 4},
  [423] = {.lex_state = 201, .external_lex_state = 4},
  [424] = {.lex_state = 201, .external_lex_state = 4},
  [425] = {.lex_state = 201, .external_lex_state = 4},
  [426] = {.lex_state = 201, .external_lex_state = 4},
  [427] = {.lex_state = 201, .external_lex_state = 4},
  [428] = {.lex_state = 201, .external_lex_state = 4},
  [429] = {.lex_state = 201, .external_lex_state = 4},
  [430] = {.lex_state = 201, .external_lex_state = 4},
  [431] = {.lex_state = 201, .external_lex_state = 4},
  [432] = {.lex_state = 201, .external_lex_state = 4},
  [433] = {.lex_state = 201, .external_lex_state = 4},
  [434] = {.lex_state = 201, .external_lex_state = 4},
  [435] = {.lex_state = 201, .external_lex_state = 4},
  [436] = {.lex_state = 201, .external_lex_state = 4},
  [437] = {.lex_state = 201, .external_lex_state = 4},
  [438] = {.lex_state = 201, .external_lex_state = 4},
  [439] = {.lex_state = 201, .external_lex_state = 4},
  [440] = {.lex_state = 201, .external_lex_state = 4},
  [441] = {.lex_state = 201, .external_lex_state = 4},
  [442] = {.lex_state = 201, .external_lex_state = 4},
  [443] = {.lex_state = 201, .external_lex_state = 4},
  [444] = {.lex_state = 201, .external_lex_state = 4},
  [445] = {.lex_state = 201, .external_lex_state = 4},
  [446] = {.lex_state = 201, .external_lex_state = 4},
  [447] = {.lex_state = 201, .external_lex_state = 4},
  [448] = {.lex_state = 201, .external_lex_state = 4},
  [449] = {.lex_state = 201, .external_lex_state = 4},
  [450] = {.lex_state = 201, .external_lex_state = 4},
  [451] = {.lex_state = 201, .external_lex_state = 4},
  [452] = {.lex_state = 201, .external_lex_state = 4},
  [453] = {.lex_state = 201, .external_lex_state = 4},
  [454] = {.lex_state = 201, .external_lex_state = 4},
  [455] = {.lex_state = 201, .external_lex_state = 4},
  [456] = {.lex_state = 201, .external_lex_state = 4},
  [457] = {.lex_state = 201, .external_lex_state = 4},
  [458] = {.lex_state = 201, .external_lex_state = 4},
  [459] = {.lex_state = 201, .external_lex_state = 4},
  [460] = {.lex_state = 201, .external_lex_state = 4},
  [461] = {.lex_state = 201, .external_lex_state = 4},
  [462] = {.lex_state = 201, .external_lex_state = 4},
  [463] = {.lex_state = 201, .external_lex_state = 4},
  [464] = {.lex_state = 201, .external_lex_state = 4},
  [465] = {.lex_state = 201, .external_lex_state = 4},
  [466] = {.lex_state = 201, .external_lex_state = 4},
  [467] = {.lex_state = 201, .external_lex_state = 4},
  [468] = {.lex_state = 201, .external_lex_state = 4},
  [469] = {.lex_state = 201, .external_lex_state = 4},
  [470] = {.lex_state = 201, .external_lex_state = 4},
  [471] = {.lex_state = 201, .external_lex_state = 4},
  [472] = {.lex_state = 201, .external_lex_state = 4},
  [473] = {.lex_state = 201, .external_lex_state = 4},
  [474] = {.lex_state = 201, .external_lex_state = 4},
  [475] = {.lex_state = 201, .external_lex_state = 4},
  [476] = {.lex_state = 201, .external_lex_state = 4},
  [477] = {.lex_state = 201, .external_lex_state = 4},
  [478] = {.lex_state = 201, .external_lex_state = 4},
  [479] = {.lex_state = 201, .external_lex_state = 4},
  [480] = {.lex_state = 201, .external_lex_state = 4},
  [481] = {.lex_state = 201, .external_lex_state = 4},
  [482] = {.lex_state = 201, .external_lex_state = 4},
  [483] = {.lex_state = 201, .external_lex_state = 4},
  [484] = {.lex_state = 201, .external_lex_state = 4},
  [485] = {.lex_state = 201, .external_lex_state = 4},
  [486] = {.lex_state = 201, .external_lex_state = 4},
  [487] = {.lex_state = 201, .external_lex_state = 4},
  [488] = {.lex_state = 201, .external_lex_state = 4},
  [489] = {.lex_state = 201, .external_lex_state = 4},
  [490] = {.lex_state = 201, .external_lex_state = 4},
  [491] = {.lex_state = 201, .external_lex_state = 4},
  [492] = {.lex_state = 201, .external_lex_state = 4},
  [493] = {.lex_state = 201, .external_lex_state = 4},
  [494] = {.lex_state = 201, .external_lex_state = 4},
  [495] = {.lex_state = 201, .external_lex_state = 4},
  [496] = {.lex_state = 201, .external_lex_state = 4},
  [497] = {.lex_state = 201, .external_lex_state = 4},
  [498] = {.lex_state = 201, .external_lex_state = 4},
  [499] = {.lex_state = 201, .external_lex_state = 4},
  [500] = {.lex_state = 201, .external_lex_state = 4},
  [501] = {.lex_state = 201, .external_lex_state = 4},
  [502] = {.lex_state = 201, .external_lex_state = 4},
  [503] = {.lex_state = 201, .external_lex_state = 4},
  [504] = {.lex_state = 201, .external_lex_state = 4},
  [505] = {.lex_state = 201, .external_lex_state = 4},
  [506] = {.lex_state = 201, .external_lex_state = 4},
  [507] = {.lex_state = 201, .external_lex_state = 4},
  [508] = {.lex_state = 201, .external_lex_state = 4},
  [509] = {.lex_state = 201, .external_lex_state = 4},
  [510] = {.lex_state = 201, .external_lex_state = 4},
  [511] = {.lex_state = 201, .external_lex_state = 4},
  [512] = {.lex_state = 201, .external_lex_state = 4},
  [513] = {.lex_state = 201, .external_lex_state = 4},
  [514] = {.lex_state = 201, .external_lex_state = 4},
  [515] = {.lex_state = 201, .external_lex_state = 4},
  [516] = {.lex_state = 201, .external_lex_state = 4},
  [517] = {.lex_state = 201, .external_lex_state = 4},
  [518] = {.lex_state = 201, .external_lex_state = 4},
  [519] = {.lex_state = 201, .external_lex_state = 4},
  [520] = {.lex_state = 201, .external_lex_state = 4},
  [521] = {.lex_state = 201, .external_lex_state = 4},
  [522] = {.lex_state = 201, .external_lex_state = 4},
  [523] = {.lex_state = 201, .external_lex_state = 4},
  [524] = {.lex_state = 201, .external_lex_state = 4},
  [525] = {.lex_state = 201, .external_lex_state = 4},
  [526] = {.lex_state = 201, .external_lex_state = 4},
  [527] = {.lex_state = 201, .external_lex_state = 4},
  [528] = {.lex_state = 201, .external_lex_state = 4},
  [529] = {.lex_state = 201, .external_lex_state = 4},
  [530] = {.lex_state = 201, .external_lex_state = 4},
  [531] = {.lex_state = 201, .external_lex_state = 4},
  [532] = {.lex_state = 201, .external_lex_state = 4},
  [533] = {.lex_state = 201, .external_lex_state = 4},
  [534] = {.lex_state = 201, .external_lex_state = 4},
  [535] = {.lex_state = 201, .external_lex_state = 4},
  [536] = {.lex_state = 201, .external_lex_state = 4},
  [537] = {.lex_state = 201, .external_lex_state = 4},
  [538] = {.lex_state = 201, .external_lex_state = 4},
  [539] = {.lex_state = 201, .external_lex_state = 4},
  [540] = {.lex_state = 201, .external_lex_state = 4},
  [541] = {.lex_state = 201, .external_lex_state = 4},
  [542] = {.lex_state = 201, .external_lex_state = 4},
  [543] = {.lex_state = 201, .external_lex_state = 4},
  [544] = {.lex_state = 201, .external_lex_state = 4},
  [545] = {.lex_state = 201, .external_lex_state = 4},
  [546] = {.lex_state = 201, .external_lex_state = 4},
  [547] = {.lex_state = 201, .external_lex_state = 4},
  [548] = {.lex_state = 201, .external_lex_state = 4},
  [549] = {.lex_state = 201, .external_lex_state = 4},
  [550] = {.lex_state = 201, .external_lex_state = 4},
  [551] = {.lex_state = 201, .external_lex_state = 4},
  [552] = {.lex_state = 201, .external_lex_state = 4},
  [553] = {.lex_state = 201, .external_lex_state = 4},
  [554] = {.lex_state = 201, .external_lex_state = 4},
  [555] = {.lex_state = 201, .external_lex_state = 4},
  [556] = {.lex_state = 201, .external_lex_state = 4},
  [557] = {.lex_state = 201, .external_lex_state = 4},
  [558] = {.lex_state = 201, .external_lex_state = 4},
  [559] = {.lex_state = 201, .external_lex_state = 4},
  [560] = {.lex_state = 201, .external_lex_state = 4},
  [561] = {.lex_state = 201, .external_lex_state = 4},
  [562] = {.lex_state = 201, .external_lex_state = 4},
  [563] = {.lex_state = 201, .external_lex_state = 4},
  [564] = {.lex_state = 201, .external_lex_state = 4},
  [565] = {.lex_state = 201, .external_lex_state = 4},
  [566] = {.lex_state = 201, .external_lex_state = 4},
  [567] = {.lex_state = 201, .external_lex_state = 4},
  [568] = {.lex_state = 201, .external_lex_state = 4},
  [569] = {.lex_state = 201, .external_lex_state = 4},
  [570] = {.lex_state = 201, .external_lex_state = 4},
  [571] = {.lex_state = 201, .external_lex_state = 4},
  [572] = {.lex_state = 201, .external_lex_state = 4},
  [573] = {.lex_state = 201, .external_lex_state = 4},
  [574] = {.lex_state = 201, .external_lex_state = 4},
  [575] = {.lex_state = 201, .external_lex_state = 4},
  [576] = {.lex_state = 201, .external_lex_state = 4},
  [577] = {.lex_state = 201, .external_lex_state = 4},
  [578] = {.lex_state = 201, .external_lex_state = 4},
  [579] = {.lex_state = 201, .external_lex_state = 4},
  [580] = {.lex_state = 201, .external_lex_state = 4},
  [581] = {.lex_state = 201, .external_lex_state = 4},
  [582] = {.lex_state = 201, .external_lex_state = 4},
  [583] = {.lex_state = 201, .external_lex_state = 4},
  [584] = {.lex_state = 201, .external_lex_state = 4},
  [585] = {.lex_state = 201, .external_lex_state = 4},
  [586] = {.lex_state = 201, .external_lex_state = 4},
  [587] = {.lex_state = 201, .external_lex_state = 4},
  [588] = {.lex_state = 201, .external_lex_state = 4},
  [589] = {.lex_state = 201, .external_lex_state = 4},
  [590] = {.lex_state = 201, .external_lex_state = 4},
  [591] = {.lex_state = 201, .external_lex_state = 4},
  [592] = {.lex_state = 201, .external_lex_state = 4},
  [593] = {.lex_state = 201, .external_lex_state = 4},
  [594] = {.lex_state = 201, .external_lex_state = 4},
  [595] = {.lex_state = 201, .external_lex_state = 4},
  [596] = {.lex_state = 201, .external_lex_state = 4},
  [597] = {.lex_state = 201, .external_lex_state = 4},
  [598] = {.lex_state = 201, .external_lex_state = 4},
  [599] = {.lex_state = 201, .external_lex_state = 4},
  [600] = {.lex_state = 201, .external_lex_state = 4},
  [601] = {.lex_state = 201, .external_lex_state = 4},
  [602] = {.lex_state = 201, .external_lex_state = 4},
  [603] = {.lex_state = 201, .external_lex_state = 4},
  [604] = {.lex_state = 201, .external_lex_state = 4},
  [605] = {.lex_state = 201, .external_lex_state = 4},
  [606] = {.lex_state = 201, .external_lex_state = 4},
  [607] = {.lex_state = 201, .external_lex_state = 4},
  [608] = {.lex_state = 201, .external_lex_state = 4},
  [609] = {.lex_state = 201, .external_lex_state = 4},
  [610] = {.lex_state = 201, .external_lex_state = 4},
  [611] = {.lex_state = 201, .external_lex_state = 4},
  [612] = {.lex_state = 201, .external_lex_state = 4},
  [613] = {.lex_state = 201, .external_lex_state = 4},
  [614] = {.lex_state = 201, .external_lex_state = 4},
  [615] = {.lex_state = 201, .external_lex_state = 4},
  [616] = {.lex_state = 201, .external_lex_state = 4},
  [617] = {.lex_state = 201, .external_lex_state = 4},
  [618] = {.lex_state = 201, .external_lex_state = 4},
  [619] = {.lex_state = 201, .external_lex_state = 4},
  [620] = {.lex_state = 201, .external_lex_state = 4},
  [621] = {.lex_state = 201, .external_lex_state = 4},
  [622] = {.lex_state = 201, .external_lex_state = 4},
  [623] = {.lex_state = 201, .external_lex_state = 4},
  [624] = {.lex_state = 201, .external_lex_state = 4},
  [625] = {.lex_state = 201, .external_lex_state = 4},
  [626] = {.lex_state = 201, .external_lex_state = 4},
  [627] = {.lex_state = 201, .external_lex_state = 4},
  [628] = {.lex_state = 201, .external_lex_state = 4},
  [629] = {.lex_state = 201, .external_lex_state = 4},
  [630] = {.lex_state = 201, .external_lex_state = 4},
  [631] = {.lex_state = 201, .external_lex_state = 4},
  [632] = {.lex_state = 201, .external_lex_state = 4},
  [633] = {.lex_state = 201, .external_lex_state = 4},
  [634] = {.lex_state = 201, .external_lex_state = 4},
  [635] = {.lex_state = 201, .external_lex_state = 4},
  [636] = {.lex_state = 201, .external_lex_state = 4},
  [637] = {.lex_state = 201, .external_lex_state = 4},
  [638] = {.lex_state = 201, .external_lex_state = 4},
  [639] = {.lex_state = 201, .external_lex_state = 4},
  [640] = {.lex_state = 201, .external_lex_state = 4},
  [641] = {.lex_state = 201, .external_lex_state = 4},
  [642] = {.lex_state = 201, .external_lex_state = 4},
  [643] = {.lex_state = 201, .external_lex_state = 4},
  [644] = {.lex_state = 201, .external_lex_state = 4},
  [645] = {.lex_state = 201, .external_lex_state = 4},
  [646] = {.lex_state = 201, .external_lex_state = 4},
  [647] = {.lex_state = 201, .external_lex_state = 4},
  [648] = {.lex_state = 201, .external_lex_state = 4},
  [649] = {.lex_state = 201, .external_lex_state = 4},
  [650] = {.lex_state = 201, .external_lex_state = 4},
  [651] = {.lex_state = 201, .external_lex_state = 4},
  [652] = {.lex_state = 201, .external_lex_state = 4},
  [653] = {.lex_state = 201, .external_lex_state = 4},
  [654] = {.lex_state = 201, .external_lex_state = 4},
  [655] = {.lex_state = 201, .external_lex_state = 4},
  [656] = {.lex_state = 201, .external_lex_state = 4},
  [657] = {.lex_state = 201, .external_lex_state = 4},
  [658] = {.lex_state = 201, .external_lex_state = 4},
  [659] = {.lex_state = 201, .external_lex_state = 4},
  [660] = {.lex_state = 201, .external_lex_state = 4},
  [661] = {.lex_state = 201, .external_lex_state = 4},
  [662] = {.lex_state = 201, .external_lex_state = 4},
  [663] = {.lex_state = 201, .external_lex_state = 4},
  [664] = {.lex_state = 201, .external_lex_state = 4},
  [665] = {.lex_state = 201, .external_lex_state = 4},
  [666] = {.lex_state = 201, .external_lex_state = 4},
  [667] = {.lex_state = 201, .external_lex_state = 4},
  [668] = {.lex_state = 201, .external_lex_state = 4},
  [669] = {.lex_state = 201, .external_lex_state = 4},
  [670] = {.lex_state = 201, .external_lex_state = 4},
  [671] = {.lex_state = 201, .external_lex_state = 4},
  [672] = {.lex_state = 201, .external_lex_state = 4},
  [673] = {.lex_state = 201, .external_lex_state = 4},
  [674] = {.lex_state = 201, .external_lex_state = 4},
  [675] = {.lex_state = 201, .external_lex_state = 4},
  [676] = {.lex_state = 201, .external_lex_state = 4},
  [677] = {.lex_state = 201, .external_lex_state = 4},
  [678] = {.lex_state = 201, .external_lex_state = 4},
  [679] = {.lex_state = 201, .external_lex_state = 4},
  [680] = {.lex_state = 201, .external_lex_state = 4},
  [681] = {.lex_state = 201, .external_lex_state = 4},
  [682] = {.lex_state = 201, .external_lex_state = 4},
  [683] = {.lex_state = 201, .external_lex_state = 4},
  [684] = {.lex_state = 201, .external_lex_state = 4},
  [685] = {.lex_state = 201, .external_lex_state = 4},
  [686] = {.lex_state = 201, .external_lex_state = 4},
  [687] = {.lex_state = 201, .external_lex_state = 4},
  [688] = {.lex_state = 201, .external_lex_state = 4},
  [689] = {.lex_state = 201, .external_lex_state = 4},
  [690] = {.lex_state = 201, .external_lex_state = 4},
  [691] = {.lex_state = 201, .external_lex_state = 4},
  [692] = {.lex_state = 201, .external_lex_state = 4},
  [693] = {.lex_state = 201, .external_lex_state = 4},
  [694] = {.lex_state = 201, .external_lex_state = 4},
  [695] = {.lex_state = 201, .external_lex_state = 4},
  [696] = {.lex_state = 201, .external_lex_state = 4},
  [697] = {.lex_state = 201, .external_lex_state = 4},
  [698] = {.lex_state = 201, .external_lex_state = 4},
  [699] = {.lex_state = 201, .external_lex_state = 4},
  [700] = {.lex_state = 201, .external_lex_state = 4},
  [701] = {.lex_state = 201, .external_lex_state = 4},
  [702] = {.lex_state = 201, .external_lex_state = 4},
  [703] = {.lex_state = 201, .external_lex_state = 4},
  [704] = {.lex_state = 201, .external_lex_state = 4},
  [705] = {.lex_state = 201, .external_lex_state = 4},
  [706] = {.lex_state = 201, .external_lex_state = 4},
  [707] = {.lex_state = 201, .external_lex_state = 4},
  [708] = {.lex_state = 201, .external_lex_state = 4},
  [709] = {.lex_state = 201, .external_lex_state = 4},
  [710] = {.lex_state = 201, .external_lex_state = 4},
  [711] = {.lex_state = 201, .external_lex_state = 4},
  [712] = {.lex_state = 201, .external_lex_state = 4},
  [713] = {.lex_state = 201, .external_lex_state = 4},
  [714] = {.lex_state = 201, .external_lex_state = 4},
  [715] = {.lex_state = 201, .external_lex_state = 4},
  [716] = {.lex_state = 201, .external_lex_state = 4},
  [717] = {.lex_state = 201, .external_lex_state = 4},
  [718] = {.lex_state = 201, .external_lex_state = 4},
  [719] = {.lex_state = 201, .external_lex_state = 4},
  [720] = {.lex_state = 201, .external_lex_state = 4},
  [721] = {.lex_state = 201, .external_lex_state = 4},
  [722] = {.lex_state = 201, .external_lex_state = 4},
  [723] = {.lex_state = 201, .external_lex_state = 4},
  [724] = {.lex_state = 201, .external_lex_state = 4},
  [725] = {.lex_state = 201, .external_lex_state = 4},
  [726] = {.lex_state = 201, .external_lex_state = 4},
  [727] = {.lex_state = 201, .external_lex_state = 4},
  [728] = {.lex_state = 201, .external_lex_state = 4},
  [729] = {.lex_state = 201, .external_lex_state = 4},
  [730] = {.lex_state = 201, .external_lex_state = 4},
  [731] = {.lex_state = 201, .external_lex_state = 4},
  [732] = {.lex_state = 201, .external_lex_state = 4},
  [733] = {.lex_state = 201, .external_lex_state = 4},
  [734] = {.lex_state = 201, .external_lex_state = 4},
  [735] = {.lex_state = 201, .external_lex_state = 4},
  [736] = {.lex_state = 201, .external_lex_state = 4},
  [737] = {.lex_state = 201, .external_lex_state = 4},
  [738] = {.lex_state = 201, .external_lex_state = 4},
  [739] = {.lex_state = 201, .external_lex_state = 4},
  [740] = {.lex_state = 201, .external_lex_state = 4},
  [741] = {.lex_state = 201, .external_lex_state = 4},
  [742] = {.lex_state = 201, .external_lex_state = 4},
  [743] = {.lex_state = 201, .external_lex_state = 4},
  [744] = {.lex_state = 201, .external_lex_state = 4},
  [745] = {.lex_state = 201, .external_lex_state = 4},
  [746] = {.lex_state = 201, .external_lex_state = 4},
  [747] = {.lex_state = 201, .external_lex_state = 4},
  [748] = {.lex_state = 201, .external_lex_state = 4},
  [749] = {.lex_state = 201, .external_lex_state = 4},
  [750] = {.lex_state = 201, .external_lex_state = 4},
  [751] = {.lex_state = 201, .external_lex_state = 4},
  [752] = {.lex_state = 201, .external_lex_state = 4},
  [753] = {.lex_state = 201, .external_lex_state = 4},
  [754] = {.lex_state = 201, .external_lex_state = 4},
  [755] = {.lex_state = 201, .external_lex_state = 4},
  [756] = {.lex_state = 201, .external_lex_state = 4},
  [757] = {.lex_state = 201, .external_lex_state = 4},
  [758] = {.lex_state = 201, .external_lex_state = 4},
  [759] = {.lex_state = 201, .external_lex_state = 4},
  [760] = {.lex_state = 201, .external_lex_state = 4},
  [761] = {.lex_state = 201, .external_lex_state = 4},
  [762] = {.lex_state = 201, .external_lex_state = 4},
  [763] = {.lex_state = 201, .external_lex_state = 4},
  [764] = {.lex_state = 201, .external_lex_state = 4},
  [765] = {.lex_state = 201, .external_lex_state = 4},
  [766] = {.lex_state = 201, .external_lex_state = 4},
  [767] = {.lex_state = 201, .external_lex_state = 4},
  [768] = {.lex_state = 201, .external_lex_state = 4},
  [769] = {.lex_state = 201, .external_lex_state = 4},
  [770] = {.lex_state = 201, .external_lex_state = 4},
  [771] = {.lex_state = 201, .external_lex_state = 4},
  [772] = {.lex_state = 201, .external_lex_state = 4},
  [773] = {.lex_state = 201, .external_lex_state = 4},
  [774] = {.lex_state = 201, .external_lex_state = 4},
  [775] = {.lex_state = 201, .external_lex_state = 4},
  [776] = {.lex_state = 201, .external_lex_state = 4},
  [777] = {.lex_state = 201, .external_lex_state = 4},
  [778] = {.lex_state = 201, .external_lex_state = 4},
  [779] = {.lex_state = 201, .external_lex_state = 4},
  [780] = {.lex_state = 201, .external_lex_state = 4},
  [781] = {.lex_state = 201, .external_lex_state = 4},
  [782] = {.lex_state = 201, .external_lex_state = 4},
  [783] = {.lex_state = 201, .external_lex_state = 4},
  [784] = {.lex_state = 201, .external_lex_state = 4},
  [785] = {.lex_state = 201, .external_lex_state = 4},
  [786] = {.lex_state = 201, .external_lex_state = 4},
  [787] = {.lex_state = 201, .external_lex_state = 4},
  [788] = {.lex_state = 201, .external_lex_state = 4},
  [789] = {.lex_state = 201, .external_lex_state = 4},
  [790] = {.lex_state = 201, .external_lex_state = 4},
  [791] = {.lex_state = 201, .external_lex_state = 4},
  [792] = {.lex_state = 201, .external_lex_state = 4},
  [793] = {.lex_state = 201, .external_lex_state = 4},
  [794] = {.lex_state = 201, .external_lex_state = 4},
  [795] = {.lex_state = 201, .external_lex_state = 4},
  [796] = {.lex_state = 201, .external_lex_state = 4},
  [797] = {.lex_state = 201, .external_lex_state = 4},
  [798] = {.lex_state = 201, .external_lex_state = 4},
  [799] = {.lex_state = 201, .external_lex_state = 4},
  [800] = {.lex_state = 201, .external_lex_state = 4},
  [801] = {.lex_state = 201, .external_lex_state = 4},
  [802] = {.lex_state = 201, .external_lex_state = 4},
  [803] = {.lex_state = 201, .external_lex_state = 4},
  [804] = {.lex_state = 201, .external_lex_state = 4},
  [805] = {.lex_state = 201, .external_lex_state = 4},
  [806] = {.lex_state = 201, .external_lex_state = 4},
  [807] = {.lex_state = 201, .external_lex_state = 4},
  [808] = {.lex_state = 201, .external_lex_state = 4},
  [809] = {.lex_state = 201, .external_lex_state = 4},
  [810] = {.lex_state = 201, .external_lex_state = 4},
  [811] = {.lex_state = 201, .external_lex_state = 4},
  [812] = {.lex_state = 201, .external_lex_state = 4},
  [813] = {.lex_state = 201, .external_lex_state = 4},
  [814] = {.lex_state = 201, .external_lex_state = 4},
  [815] = {.lex_state = 201, .external_lex_state = 4},
  [816] = {.lex_state = 201, .external_lex_state = 4},
  [817] = {.lex_state = 201, .external_lex_state = 4},
  [818] = {.lex_state = 201, .external_lex_state = 4},
  [819] = {.lex_state = 201, .external_lex_state = 4},
  [820] = {.lex_state = 201, .external_lex_state = 4},
  [821] = {.lex_state = 201, .external_lex_state = 4},
  [822] = {.lex_state = 201, .external_lex_state = 4},
  [823] = {.lex_state = 201, .external_lex_state = 4},
  [824] = {.lex_state = 201, .external_lex_state = 4},
  [825] = {.lex_state = 201, .external_lex_state = 4},
  [826] = {.lex_state = 201, .external_lex_state = 4},
  [827] = {.lex_state = 201, .external_lex_state = 4},
  [828] = {.lex_state = 201, .external_lex_state = 4},
  [829] = {.lex_state = 201, .external_lex_state = 4},
  [830] = {.lex_state = 201, .external_lex_state = 4},
  [831] = {.lex_state = 201, .external_lex_state = 4},
  [832] = {.lex_state = 201, .external_lex_state = 4},
  [833] = {.lex_state = 201, .external_lex_state = 4},
  [834] = {.lex_state = 201, .external_lex_state = 4},
  [835] = {.lex_state = 201, .external_lex_state = 4},
  [836] = {.lex_state = 201, .external_lex_state = 4},
  [837] = {.lex_state = 201, .external_lex_state = 4},
  [838] = {.lex_state = 201, .external_lex_state = 4},
  [839] = {.lex_state = 201, .external_lex_state = 4},
  [840] = {.lex_state = 201, .external_lex_state = 4},
  [841] = {.lex_state = 201, .external_lex_state = 4},
  [842] = {.lex_state = 201, .external_lex_state = 4},
  [843] = {.lex_state = 201, .external_lex_state = 4},
  [844] = {.lex_state = 201, .external_lex_state = 4},
  [845] = {.lex_state = 201, .external_lex_state = 4},
  [846] = {.lex_state = 201, .external_lex_state = 4},
  [847] = {.lex_state = 201, .external_lex_state = 4},
  [848] = {.lex_state = 201, .external_lex_state = 4},
  [849] = {.lex_state = 201, .external_lex_state = 4},
  [850] = {.lex_state = 201, .external_lex_state = 4},
  [851] = {.lex_state = 201, .external_lex_state = 4},
  [852] = {.lex_state = 201, .external_lex_state = 4},
  [853] = {.lex_state = 201, .external_lex_state = 4},
  [854] = {.lex_state = 201, .external_lex_state = 4},
  [855] = {.lex_state = 201, .external_lex_state = 4},
  [856] = {.lex_state = 201, .external_lex_state = 4},
  [857] = {.lex_state = 201, .external_lex_state = 4},
  [858] = {.lex_state = 201, .external_lex_state = 4},
  [859] = {.lex_state = 201, .external_lex_state = 4},
  [860] = {.lex_state = 201, .external_lex_state = 4},
  [861] = {.lex_state = 201, .external_lex_state = 4},
  [862] = {.lex_state = 201, .external_lex_state = 4},
  [863] = {.lex_state = 201, .external_lex_state = 4},
  [864] = {.lex_state = 201, .external_lex_state = 4},
  [865] = {.lex_state = 201, .external_lex_state = 4},
  [866] = {.lex_state = 201, .external_lex_state = 4},
  [867] = {.lex_state = 201, .external_lex_state = 4},
  [868] = {.lex_state = 201, .external_lex_state = 4},
  [869] = {.lex_state = 201, .external_lex_state = 4},
  [870] = {.lex_state = 201, .external_lex_state = 4},
  [871] = {.lex_state = 201, .external_lex_state = 4},
  [872] = {.lex_state = 201, .external_lex_state = 4},
  [873] = {.lex_state = 201, .external_lex_state = 4},
  [874] = {.lex_state = 201, .external_lex_state = 4},
  [875] = {.lex_state = 201, .external_lex_state = 4},
  [876] = {.lex_state = 201, .external_lex_state = 4},
  [877] = {.lex_state = 201, .external_lex_state = 4},
  [878] = {.lex_state = 201, .external_lex_state = 4},
  [879] = {.lex_state = 201, .external_lex_state = 4},
  [880] = {.lex_state = 201, .external_lex_state = 4},
  [881] = {.lex_state = 201, .external_lex_state = 4},
  [882] = {.lex_state = 201, .external_lex_state = 4},
  [883] = {.lex_state = 201, .external_lex_state = 4},
  [884] = {.lex_state = 201, .external_lex_state = 4},
  [885] = {.lex_state = 201, .external_lex_state = 4},
  [886] = {.lex_state = 201, .external_lex_state = 4},
  [887] = {.lex_state = 201, .external_lex_state = 4},
  [888] = {.lex_state = 201, .external_lex_state = 4},
  [889] = {.lex_state = 201, .external_lex_state = 4},
  [890] = {.lex_state = 201, .external_lex_state = 4},
  [891] = {.lex_state = 201, .external_lex_state = 4},
  [892] = {.lex_state = 201, .external_lex_state = 4},
  [893] = {.lex_state = 201, .external_lex_state = 4},
  [894] = {.lex_state = 201, .external_lex_state = 4},
  [895] = {.lex_state = 201, .external_lex_state = 4},
  [896] = {.lex_state = 201, .external_lex_state = 4},
  [897] = {.lex_state = 201, .external_lex_state = 4},
  [898] = {.lex_state = 201, .external_lex_state = 4},
  [899] = {.lex_state = 201, .external_lex_state = 4},
  [900] = {.lex_state = 201, .external_lex_state = 4},
  [901] = {.lex_state = 201, .external_lex_state = 4},
  [902] = {.lex_state = 201, .external_lex_state = 4},
  [903] = {.lex_state = 201, .external_lex_state = 4},
  [904] = {.lex_state = 201, .external_lex_state = 4},
  [905] = {.lex_state = 201, .external_lex_state = 4},
  [906] = {.lex_state = 201, .external_lex_state = 4},
  [907] = {.lex_state = 201, .external_lex_state = 4},
  [908] = {.lex_state = 201, .external_lex_state = 4},
  [909] = {.lex_state = 201, .external_lex_state = 4},
  [910] = {.lex_state = 201, .external_lex_state = 4},
  [911] = {.lex_state = 201, .external_lex_state = 4},
  [912] = {.lex_state = 201, .external_lex_state = 4},
  [913] = {.lex_state = 201, .external_lex_state = 4},
  [914] = {.lex_state = 201, .external_lex_state = 4},
  [915] = {.lex_state = 201, .external_lex_state = 4},
  [916] = {.lex_state = 201, .external_lex_state = 4},
  [917] = {.lex_state = 201, .external_lex_state = 4},
  [918] = {.lex_state = 201, .external_lex_state = 4},
  [919] = {.lex_state = 201, .external_lex_state = 4},
  [920] = {.lex_state = 201, .external_lex_state = 4},
  [921] = {.lex_state = 201, .external_lex_state = 4},
  [922] = {.lex_state = 201, .external_lex_state = 4},
  [923] = {.lex_state = 201, .external_lex_state = 4},
  [924] = {.lex_state = 201, .external_lex_state = 4},
  [925] = {.lex_state = 201, .external_lex_state = 4},
  [926] = {.lex_state = 201, .external_lex_state = 4},
  [927] = {.lex_state = 201, .external_lex_state = 4},
  [928] = {.lex_state = 201, .external_lex_state = 4},
  [929] = {.lex_state = 201, .external_lex_state = 4},
  [930] = {.lex_state = 201, .external_lex_state = 4},
  [931] = {.lex_state = 201, .external_lex_state = 4},
  [932] = {.lex_state = 201, .external_lex_state = 4},
  [933] = {.lex_state = 201, .external_lex_state = 4},
  [934] = {.lex_state = 201, .external_lex_state = 4},
  [935] = {.lex_state = 201, .external_lex_state = 4},
  [936] = {.lex_state = 201, .external_lex_state = 4},
  [937] = {.lex_state = 201, .external_lex_state = 4},
  [938] = {.lex_state = 201, .external_lex_state = 4},
  [939] = {.lex_state = 201, .external_lex_state = 4},
  [940] = {.lex_state = 201, .external_lex_state = 4},
  [941] = {.lex_state = 201, .external_lex_state = 4},
  [942] = {.lex_state = 201, .external_lex_state = 4},
  [943] = {.lex_state = 201, .external_lex_state = 4},
  [944] = {.lex_state = 201, .external_lex_state = 4},
  [945] = {.lex_state = 201, .external_lex_state = 4},
  [946] = {.lex_state = 201, .external_lex_state = 4},
  [947] = {.lex_state = 201, .external_lex_state = 4},
  [948] = {.lex_state = 201, .external_lex_state = 4},
  [949] = {.lex_state = 201, .external_lex_state = 4},
  [950] = {.lex_state = 201, .external_lex_state = 4},
  [951] = {.lex_state = 201, .external_lex_state = 4},
  [952] = {.lex_state = 201, .external_lex_state = 4},
  [953] = {.lex_state = 201, .external_lex_state = 4},
  [954] = {.lex_state = 201, .external_lex_state = 4},
  [955] = {.lex_state = 201, .external_lex_state = 4},
  [956] = {.lex_state = 201, .external_lex_state = 4},
  [957] = {.lex_state = 201, .external_lex_state = 4},
  [958] = {.lex_state = 201, .external_lex_state = 4},
  [959] = {.lex_state = 201, .external_lex_state = 4},
  [960] = {.lex_state = 201, .external_lex_state = 4},
  [961] = {.lex_state = 201, .external_lex_state = 4},
  [962] = {.lex_state = 201, .external_lex_state = 4},
  [963] = {.lex_state = 201, .external_lex_state = 4},
  [964] = {.lex_state = 201, .external_lex_state = 4},
  [965] = {.lex_state = 201, .external_lex_state = 4},
  [966] = {.lex_state = 201, .external_lex_state = 4},
  [967] = {.lex_state = 201, .external_lex_state = 4},
  [968] = {.lex_state = 201, .external_lex_state = 4},
  [969] = {.lex_state = 201, .external_lex_state = 4},
  [970] = {.lex_state = 201, .external_lex_state = 4},
  [971] = {.lex_state = 201, .external_lex_state = 4},
  [972] = {.lex_state = 201, .external_lex_state = 4},
  [973] = {.lex_state = 201, .external_lex_state = 4},
  [974] = {.lex_state = 201, .external_lex_state = 4},
  [975] = {.lex_state = 201, .external_lex_state = 4},
  [976] = {.lex_state = 201, .external_lex_state = 4},
  [977] = {.lex_state = 201, .external_lex_state = 4},
  [978] = {.lex_state = 201, .external_lex_state = 4},
  [979] = {.lex_state = 201, .external_lex_state = 4},
  [980] = {.lex_state = 201, .external_lex_state = 4},
  [981] = {.lex_state = 201, .external_lex_state = 4},
  [982] = {.lex_state = 201, .external_lex_state = 4},
  [983] = {.lex_state = 201, .external_lex_state = 4},
  [984] = {.lex_state = 201, .external_lex_state = 4},
  [985] = {.lex_state = 201, .external_lex_state = 4},
  [986] = {.lex_state = 201, .external_lex_state = 4},
  [987] = {.lex_state = 201, .external_lex_state = 4},
  [988] = {.lex_state = 201, .external_lex_state = 4},
  [989] = {.lex_state = 201, .external_lex_state = 4},
  [990] = {.lex_state = 201, .external_lex_state = 4},
  [991] = {.lex_state = 201, .external_lex_state = 4},
  [992] = {.lex_state = 201, .external_lex_state = 4},
  [993] = {.lex_state = 201, .external_lex_state = 4},
  [994] = {.lex_state = 201, .external_lex_state = 4},
  [995] = {.lex_state = 201, .external_lex_state = 4},
  [996] = {.lex_state = 201, .external_lex_state = 4},
  [997] = {.lex_state = 201, .external_lex_state = 4},
  [998] = {.lex_state = 201, .external_lex_state = 4},
  [999] = {.lex_state = 201, .external_lex_state = 4},
  [1000] = {.lex_state = 201, .external_lex_state = 4},
  [1001] = {.lex_state = 201, .external_lex_state = 4},
  [1002] = {.lex_state = 201, .external_lex_state = 4},
  [1003] = {.lex_state = 201, .external_lex_state = 4},
  [1004] = {.lex_state = 201, .external_lex_state = 4},
  [1005] = {.lex_state = 201, .external_lex_state = 4},
  [1006] = {.lex_state = 201, .external_lex_state = 4},
  [1007] = {.lex_state = 201, .external_lex_state = 4},
  [1008] = {.lex_state = 201, .external_lex_state = 4},
  [1009] = {.lex_state = 201, .external_lex_state = 4},
  [1010] = {.lex_state = 201, .external_lex_state = 4},
  [1011] = {.lex_state = 201, .external_lex_state = 4},
  [1012] = {.lex_state = 201, .external_lex_state = 4},
  [1013] = {.lex_state = 201, .external_lex_state = 4},
  [1014] = {.lex_state = 201, .external_lex_state = 4},
  [1015] = {.lex_state = 201, .external_lex_state = 4},
  [1016] = {.lex_state = 201, .external_lex_state = 4},
  [1017] = {.lex_state = 201, .external_lex_state = 4},
  [1018] = {.lex_state = 201, .external_lex_state = 4},
  [1019] = {.lex_state = 201, .external_lex_state = 4},
  [1020] = {.lex_state = 201, .external_lex_state = 4},
  [1021] = {.lex_state = 201, .external_lex_state = 4},
  [1022] = {.lex_state = 201, .external_lex_state = 4},
  [1023] = {.lex_state = 201, .external_lex_state = 4},
  [1024] = {.lex_state = 201, .external_lex_state = 4},
  [1025] = {.lex_state = 201, .external_lex_state = 4},
  [1026] = {.lex_state = 204, .external_lex_state = 6},
  [1027] = {.lex_state = 204, .external_lex_state = 6},
  [1028] = {.lex_state = 204, .external_lex_state = 6},
  [1029] = {.lex_state = 204, .external_lex_state = 6},
  [1030] = {.lex_state = 204, .external_lex_state = 6},
  [1031] = {.lex_state = 204, .external_lex_state = 6},
  [1032] = {.lex_state = 204, .external_lex_state = 6},
  [1033] = {.lex_state = 204, .external_lex_state = 6},
  [1034] = {.lex_state = 204, .external_lex_state = 6},
  [1035] = {.lex_state = 204, .external_lex_state = 6},
  [1036] = {.lex_state = 204, .external_lex_state = 6},
  [1037] = {.lex_state = 204, .external_lex_state = 6},
  [1038] = {.lex_state = 204, .external_lex_state = 6},
  [1039] = {.lex_state = 204, .external_lex_state = 6},
  [1040] = {.lex_state = 204, .external_lex_state = 6},
  [1041] = {.lex_state = 204, .external_lex_state = 6},
  [1042] = {.lex_state = 204, .external_lex_state = 6},
  [1043] = {.lex_state = 204, .external_lex_state = 6},
  [1044] = {.lex_state = 204, .external_lex_state = 6},
  [1045] = {.lex_state = 204, .external_lex_state = 6},
  [1046] = {.lex_state = 204, .external_lex_state = 6},
  [1047] = {.lex_state = 204, .external_lex_state = 6},
  [1048] = {.lex_state = 204, .external_lex_state = 6},
  [1049] = {.lex_state = 204, .external_lex_state = 6},
  [1050] = {.lex_state = 204, .external_lex_state = 6},
  [1051] = {.lex_state = 204, .external_lex_state = 6},
  [1052] = {.lex_state = 204, .external_lex_state = 6},
  [1053] = {.lex_state = 204, .external_lex_state = 6},
  [1054] = {.lex_state = 204, .external_lex_state = 6},
  [1055] = {.lex_state = 204, .external_lex_state = 6},
  [1056] = {.lex_state = 204, .external_lex_state = 6},
  [1057] = {.lex_state = 204, .external_lex_state = 6},
  [1058] = {.lex_state = 204, .external_lex_state = 6},
  [1059] = {.lex_state = 204, .external_lex_state = 6},
  [1060] = {.lex_state = 204},
  [1061] = {.lex_state = 204},
  [1062] = {.lex_state = 204},
  [1063] = {.lex_state = 204},
  [1064] = {.lex_state = 204},
  [1065] = {.lex_state = 204},
  [1066] = {.lex_state = 204},
  [1067] = {.lex_state = 204},
  [1068] = {.lex_state = 204},
  [1069] = {.lex_state = 204},
  [1070] = {.lex_state = 204},
  [1071] = {.lex_state = 204},
  [1072] = {.lex_state = 204},
  [1073] = {.lex_state = 204},
  [1074] = {.lex_state = 204},
  [1075] = {.lex_state = 204},
  [1076] = {.lex_state = 204},
  [1077] = {.lex_state = 204},
  [1078] = {.lex_state = 204},
  [1079] = {.lex_state = 204},
  [1080] = {.lex_state = 204},
  [1081] = {.lex_state = 204},
  [1082] = {.lex_state = 204},
  [1083] = {.lex_state = 204},
  [1084] = {.lex_state = 204},
  [1085] = {.lex_state = 204},
  [1086] = {.lex_state = 204},
  [1087] = {.lex_state = 204},
  [1088] = {.lex_state = 204},
  [1089] = {.lex_state = 204},
  [1090] = {.lex_state = 204},
  [1091] = {.lex_state = 204},
  [1092] = {.lex_state = 204},
  [1093] = {.lex_state = 204},
  [1094] = {.lex_state = 204},
  [1095] = {.lex_state = 204},
  [1096] = {.lex_state = 204},
  [1097] = {.lex_state = 204},
  [1098] = {.lex_state = 204},
  [1099] = {.lex_state = 204},
  [1100] = {.lex_state = 204},
  [1101] = {.lex_state = 204},
  [1102] = {.lex_state = 204},
  [1103] = {.lex_state = 204},
  [1104] = {.lex_state = 204},
  [1105] = {.lex_state = 205},
  [1106] = {.lex_state = 205},
  [1107] = {.lex_state = 205},
  [1108] = {.lex_state = 205},
  [1109] = {.lex_state = 205},
  [1110] = {.lex_state = 205},
  [1111] = {.lex_state = 205},
  [1112] = {.lex_state = 205},
  [1113] = {.lex_state = 205},
  [1114] = {.lex_state = 205},
  [1115] = {.lex_state = 205},
  [1116] = {.lex_state = 205},
  [1117] = {.lex_state = 205},
  [1118] = {.lex_state = 205},
  [1119] = {.lex_state = 205},
  [1120] = {.lex_state = 205},
  [1121] = {.lex_state = 205},
  [1122] = {.lex_state = 205},
  [1123] = {.lex_state = 205},
  [1124] = {.lex_state = 205},
  [1125] = {.lex_state = 205},
  [1126] = {.lex_state = 205},
  [1127] = {.lex_state = 205},
  [1128] = {.lex_state = 205},
  [1129] = {.lex_state = 205},
  [1130] = {.lex_state = 205},
  [1131] = {.lex_state = 205},
  [1132] = {.lex_state = 205},
  [1133] = {.lex_state = 205},
  [1134] = {.lex_state = 205},
  [1135] = {.lex_state = 205},
  [1136] = {.lex_state = 205},
  [1137] = {.lex_state = 205},
  [1138] = {.lex_state = 205},
  [1139] = {.lex_state = 205},
  [1140] = {.lex_state = 205},
  [1141] = {.lex_state = 205},
  [1142] = {.lex_state = 205},
  [1143] = {.lex_state = 205},
  [1144] = {.lex_state = 205},
  [1145] = {.lex_state = 205},
  [1146] = {.lex_state = 205},
  [1147] = {.lex_state = 205},
  [1148] = {.lex_state = 205},
  [1149] = {.lex_state = 205},
  [1150] = {.lex_state = 205},
  [1151] = {.lex_state = 205},
  [1152] = {.lex_state = 206},
  [1153] = {.lex_state = 206},
  [1154] = {.lex_state = 206},
  [1155] = {.lex_state = 206},
  [1156] = {.lex_state = 206},
  [1157] = {.lex_state = 206},
  [1158] = {.lex_state = 207},
  [1159] = {.lex_state = 207},
  [1160] = {.lex_state = 207},
  [1161] = {.lex_state = 206},
  [1162] = {.lex_state = 206},
  [1163] = {.lex_state = 206},
  [1164] = {.lex_state = 206},
  [1165] = {.lex_state = 206},
  [1166] = {.lex_state = 206},
  [1167] = {.lex_state = 207},
  [1168] = {.lex_state = 206},
  [1169] = {.lex_state = 206},
  [1170] = {.lex_state = 206},
  [1171] = {.lex_state = 206},
  [1172] = {.lex_state = 206},
  [1173] = {.lex_state = 206},
  [1174] = {.lex_state = 206},
  [1175] = {.lex_state = 206},
  [1176] = {.lex_state = 206},
  [1177] = {.lex_state = 206},
  [1178] = {.lex_state = 206},
  [1179] = {.lex_state = 206},
  [1180] = {.lex_state = 206},
  [1181] = {.lex_state = 206},
  [1182] = {.lex_state = 206},
  [1183] = {.lex_state = 207},
  [1184] = {.lex_state = 206},
  [1185] = {.lex_state = 206},
  [1186] = {.lex_state = 206},
  [1187] = {.lex_state = 207},
  [1188] = {.lex_state = 207},
  [1189] = {.lex_state = 207},
  [1190] = {.lex_state = 207},
  [1191] = {.lex_state = 207},
  [1192] = {.lex_state = 207},
  [1193] = {.lex_state = 207},
  [1194] = {.lex_state = 207},
  [1195] = {.lex_state = 207},
  [1196] = {.lex_state = 207},
  [1197] = {.lex_state = 207},
  [1198] = {.lex_state = 207},
  [1199] = {.lex_state = 207},
  [1200] = {.lex_state = 207},
  [1201] = {.lex_state = 207},
  [1202] = {.lex_state = 208},
  [1203] = {.lex_state = 208},
  [1204] = {.lex_state = 208},
  [1205] = {.lex_state = 208},
  [1206] = {.lex_state = 208},
  [1207] = {.lex_state = 208},
  [1208] = {.lex_state = 208},
  [1209] = {.lex_state = 208},
  [1210] = {.lex_state = 208},
  [1211] = {.lex_state = 208},
  [1212] = {.lex_state = 208},
  [1213] = {.lex_state = 208},
  [1214] = {.lex_state = 208},
  [1215] = {.lex_state = 208},
  [1216] = {.lex_state = 208},
  [1217] = {.lex_state = 208},
  [1218] = {.lex_state = 208},
  [1219] = {.lex_state = 208},
  [1220] = {.lex_state = 208},
  [1221] = {.lex_state = 208},
  [1222] = {.lex_state = 208},
  [1223] = {.lex_state = 208},
  [1224] = {.lex_state = 208},
  [1225] = {.lex_state = 208},
  [1226] = {.lex_state = 208},
  [1227] = {.lex_state = 208},
  [1228] = {.lex_state = 208},
  [1229] = {.lex_state = 208},
  [1230] = {.lex_state = 208},
  [1231] = {.lex_state = 208},
  [1232] = {.lex_state = 208},
  [1233] = {.lex_state = 208},
  [1234] = {.lex_state = 208},
  [1235] = {.lex_state = 208},
  [1236] = {.lex_state = 208},
  [1237] = {.lex_state = 208},
  [1238] = {.lex_state = 208},
  [1239] = {.lex_state = 208},
  [1240] = {.lex_state = 208},
  [1241] = {.lex_state = 208},
  [1242] = {.lex_state = 208},
  [1243] = {.lex_state = 208},
  [1244] = {.lex_state = 208},
  [1245] = {.lex_state = 208},
  [1246] = {.lex_state = 208},
  [1247] = {.lex_state = 208},
  [1248] = {.lex_state = 208},
  [1249] = {.lex_state = 208},
  [1250] = {.lex_state = 208},
  [1251] = {.lex_state = 208},
  [1252] = {.lex_state = 208},
  [1253] = {.lex_state = 208},
  [1254] = {.lex_state = 208},
  [1255] = {.lex_state = 208},
  [1256] = {.lex_state = 208},
  [1257] = {.lex_state = 208},
  [1258] = {.lex_state = 208},
  [1259] = {.lex_state = 208},
  [1260] = {.lex_state = 208},
  [1261] = {.lex_state = 208},
  [1262] = {.lex_state = 208},
  [1263] = {.lex_state = 208},
  [1264] = {.lex_state = 208},
  [1265] = {.lex_state = 208},
  [1266] = {.lex_state = 208},
  [1267] = {.lex_state = 208},
  [1268] = {.lex_state = 208},
  [1269] = {.lex_state = 208},
  [1270] = {.lex_state = 208},
  [1271] = {.lex_state = 208},
  [1272] = {.lex_state = 208},
  [1273] = {.lex_state = 208},
  [1274] = {.lex_state = 208},
  [1275] = {.lex_state = 208},
  [1276] = {.lex_state = 208, .external_lex_state = 7},
  [1277] = {.lex_state = 208},
  [1278] = {.lex_state = 208},
  [1279] = {.lex_state = 208, .external_lex_state = 7},
  [1280] = {.lex_state = 208, .external_lex_state = 7},
  [1281] = {.lex_state = 208, .external_lex_state = 7},
  [1282] = {.lex_state = 208},
  [1283] = {.lex_state = 208, .external_lex_state = 7},
  [1284] = {.lex_state = 208, .external_lex_state = 7},
  [1285] = {.lex_state = 208, .external_lex_state = 7},
  [1286] = {.lex_state = 208, .external_lex_state = 7},
  [1287] = {.lex_state = 208, .external_lex_state = 7},
  [1288] = {.lex_state = 208, .external_lex_state = 7},
  [1289] = {.lex_state = 208},
  [1290] = {.lex_state = 208, .external_lex_state = 7},
  [1291] = {.lex_state = 208, .external_lex_state = 7},
  [1292] = {.lex_state = 208, .external_lex_state = 7},
  [1293] = {.lex_state = 208, .external_lex_state = 7},
  [1294] = {.lex_state = 208, .external_lex_state = 7},
  [1295] = {.lex_state = 208},
  [1296] = {.lex_state = 208, .external_lex_state = 7},
  [1297] = {.lex_state = 208, .external_lex_state = 7},
  [1298] = {.lex_state = 208, .external_lex_state = 7},
  [1299] = {.lex_state = 208},
  [1300] = {.lex_state = 208},
  [1301] = {.lex_state = 208, .external_lex_state = 7},
  [1302] = {.lex_state = 208, .external_lex_state = 7},
  [1303] = {.lex_state = 208, .external_lex_state = 7},
  [1304] = {.lex_state = 208, .external_lex_state = 7},
  [1305] = {.lex_state = 208, .external_lex_state = 7},
  [1306] = {.lex_state = 208, .external_lex_state = 7},
  [1307] = {.lex_state = 208, .external_lex_state = 7},
  [1308] = {.lex_state = 208, .external_lex_state = 7},
  [1309] = {.lex_state = 208, .external_lex_state = 7},
  [1310] = {.lex_state = 208, .external_lex_state = 7},
  [1311] = {.lex_state = 208},
  [1312] = {.lex_state = 208, .external_lex_state = 7},
  [1313] = {.lex_state = 208, .external_lex_state = 7},
  [1314] = {.lex_state = 208, .external_lex_state = 7},
  [1315] = {.lex_state = 208, .external_lex_state = 7},
  [1316] = {.lex_state = 208, .external_lex_state = 7},
  [1317] = {.lex_state = 208, .external_lex_state = 7},
  [1318] = {.lex_state = 208, .external_lex_state = 7},
  [1319] = {.lex_state = 208, .external_lex_state = 7},
  [1320] = {.lex_state = 208, .external_lex_state = 7},
  [1321] = {.lex_state = 208, .external_lex_state = 7},
  [1322] = {.lex_state = 208, .external_lex_state = 7},
  [1323] = {.lex_state = 208, .external_lex_state = 7},
  [1324] = {.lex_state = 208, .external_lex_state = 7},
  [1325] = {.lex_state = 209, .external_lex_state = 8},
  [1326] = {.lex_state = 209, .external_lex_state = 8},
  [1327] = {.lex_state = 209, .external_lex_state = 8},
  [1328] = {.lex_state = 209, .external_lex_state = 8},
  [1329] = {.lex_state = 209, .external_lex_state = 8},
  [1330] = {.lex_state = 209, .external_lex_state = 8},
  [1331] = {.lex_state = 209, .external_lex_state = 8},
  [1332] = {.lex_state = 209, .external_lex_state = 8},
  [1333] = {.lex_state = 209, .external_lex_state = 8},
  [1334] = {.lex_state = 209, .external_lex_state = 8},
  [1335] = {.lex_state = 209, .external_lex_state = 8},
  [1336] = {.lex_state = 209, .external_lex_state = 8},
  [1337] = {.lex_state = 209, .external_lex_state = 8},
  [1338] = {.lex_state = 209, .external_lex_state = 8},
  [1339] = {.lex_state = 209, .external_lex_state = 8},
  [1340] = {.lex_state = 209, .external_lex_state = 8},
  [1341] = {.lex_state = 209, .external_lex_state = 8},
  [1342] = {.lex_state = 209, .external_lex_state = 8},
  [1343] = {.lex_state = 209, .external_lex_state = 8},
  [1344] = {.lex_state = 209, .external_lex_state = 8},
  [1345] = {.lex_state = 209, .external_lex_state = 8},
  [1346] = {.lex_state = 209, .external_lex_state = 8},
  [1347] = {.lex_state = 209, .external_lex_state = 8},
  [1348] = {.lex_state = 209, .external_lex_state = 8},
  [1349] = {.lex_state = 209, .external_lex_state = 8},
  [1350] = {.lex_state = 209, .external_lex_state = 8},
  [1351] = {.lex_state = 209, .external_lex_state = 8},
  [1352] = {.lex_state = 209, .external_lex_state = 8},
  [1353] = {.lex_state = 209, .external_lex_state = 8},
  [1354] = {.lex_state = 209, .external_lex_state = 8},
  [1355] = {.lex_state = 209, .external_lex_state = 8},
  [1356] = {.lex_state = 211},
  [1357] = {.lex_state = 211},
  [1358] = {.lex_state = 211},
  [1359] = {.lex_state = 211},
  [1360] = {.lex_state = 211},
  [1361] = {.lex_state = 211},
  [1362] = {.lex_state = 211},
  [1363] = {.lex_state = 211},
  [1364] = {.lex_state = 211},
  [1365] = {.lex_state = 211},
  [1366] = {.lex_state = 211},
  [1367] = {.lex_state = 211},
  [1368] = {.lex_state = 211},
  [1369] = {.lex_state = 212, .external_lex_state = 8},
  [1370] = {.lex_state = 211},
  [1371] = {.lex_state = 211},
  [1372] = {.lex_state = 211},
  [1373] = {.lex_state = 211},
  [1374] = {.lex_state = 211},
  [1375] = {.lex_state = 206, .external_lex_state = 8},
  [1376] = {.lex_state = 206},
  [1377] = {.lex_state = 211},
  [1378] = {.lex_state = 211},
  [1379] = {.lex_state = 211},
  [1380] = {.lex_state = 211},
  [1381] = {.lex_state = 211},
  [1382] = {.lex_state = 211},
  [1383] = {.lex_state = 211},
  [1384] = {.lex_state = 211},
  [1385] = {.lex_state = 206, .external_lex_state = 8},
  [1386] = {.lex_state = 211},
  [1387] = {.lex_state = 206, .external_lex_state = 8},
  [1388] = {.lex_state = 211},
  [1389] = {.lex_state = 211},
  [1390] = {.lex_state = 211},
  [1391] = {.lex_state = 211},
  [1392] = {.lex_state = 211},
  [1393] = {.lex_state = 211},
  [1394] = {.lex_state = 211},
  [1395] = {.lex_state = 211},
  [1396] = {.lex_state = 211},
  [1397] = {.lex_state = 211},
  [1398] = {.lex_state = 211},
  [1399] = {.lex_state = 211},
  [1400] = {.lex_state = 211},
  [1401] = {.lex_state = 211},
  [1402] = {.lex_state = 211},
  [1403] = {.lex_state = 211},
  [1404] = {.lex_state = 211},
  [1405] = {.lex_state = 211},
  [1406] = {.lex_state = 211},
  [1407] = {.lex_state = 206, .external_lex_state = 8},
  [1408] = {.lex_state = 206, .external_lex_state = 8},
  [1409] = {.lex_state = 206, .external_lex_state = 8},
  [1410] = {.lex_state = 206, .external_lex_state = 8},
  [1411] = {.lex_state = 206, .external_lex_state = 8},
  [1412] = {.lex_state = 206, .external_lex_state = 8},
  [1413] = {.lex_state = 206, .external_lex_state = 8},
  [1414] = {.lex_state = 206, .external_lex_state = 8},
  [1415] = {.lex_state = 206, .external_lex_state = 8},
  [1416] = {.lex_state = 206, .external_lex_state = 8},
  [1417] = {.lex_state = 206, .external_lex_state = 8},
  [1418] = {.lex_state = 206, .external_lex_state = 8},
  [1419] = {.lex_state = 206, .external_lex_state = 8},
  [1420] = {.lex_state = 206, .external_lex_state = 8},
  [1421] = {.lex_state = 206, .external_lex_state = 8},
  [1422] = {.lex_state = 206, .external_lex_state = 8},
  [1423] = {.lex_state = 206, .external_lex_state = 8},
  [1424] = {.lex_state = 206, .external_lex_state = 8},
  [1425] = {.lex_state = 206, .external_lex_state = 8},
  [1426] = {.lex_state = 206, .external_lex_state = 8},
  [1427] = {.lex_state = 206, .external_lex_state = 8},
  [1428] = {.lex_state = 206, .external_lex_state = 8},
  [1429] = {.lex_state = 206, .external_lex_state = 8},
  [1430] = {.lex_state = 206, .external_lex_state = 8},
  [1431] = {.lex_state = 206, .external_lex_state = 8},
  [1432] = {.lex_state = 206, .external_lex_state = 8},
  [1433] = {.lex_state = 206, .external_lex_state = 8},
  [1434] = {.lex_state = 206, .external_lex_state = 8},
  [1435] = {.lex_state = 206, .external_lex_state = 8},
  [1436] = {.lex_state = 206, .external_lex_state = 8},
  [1437] = {.lex_state = 213},
  [1438] = {.lex_state = 209},
  [1439] = {.lex_state = 209},
  [1440] = {.lex_state = 209},
  [1441] = {.lex_state = 209},
  [1442] = {.lex_state = 209},
  [1443] = {.lex_state = 206},
  [1444] = {.lex_state = 209},
  [1445] = {.lex_state = 213},
  [1446] = {.lex_state = 209},
  [1447] = {.lex_state = 213},
  [1448] = {.lex_state = 213},
  [1449] = {.lex_state = 209},
  [1450] = {.lex_state = 209},
  [1451] = {.lex_state = 209},
  [1452] = {.lex_state = 209},
  [1453] = {.lex_state = 209},
  [1454] = {.lex_state = 209},
  [1455] = {.lex_state = 213},
  [1456] = {.lex_state = 213},
  [1457] = {.lex_state = 209},
  [1458] = {.lex_state = 209},
  [1459] = {.lex_state = 213},
  [1460] = {.lex_state = 209},
  [1461] = {.lex_state = 209},
  [1462] = {.lex_state = 213},
  [1463] = {.lex_state = 213},
  [1464] = {.lex_state = 209},
  [1465] = {.lex_state = 209},
  [1466] = {.lex_state = 213},
  [1467] = {.lex_state = 213},
  [1468] = {.lex_state = 209},
  [1469] = {.lex_state = 209},
  [1470] = {.lex_state = 209},
  [1471] = {.lex_state = 213},
  [1472] = {.lex_state = 209},
  [1473] = {.lex_state = 213},
  [1474] = {.lex_state = 209},
  [1475] = {.lex_state = 209},
  [1476] = {.lex_state = 213},
  [1477] = {.lex_state = 209},
  [1478] = {.lex_state = 209},
  [1479] = {.lex_state = 213},
  [1480] = {.lex_state = 209},
  [1481] = {.lex_state = 209},
  [1482] = {.lex_state = 213},
  [1483] = {.lex_state = 209},
  [1484] = {.lex_state = 215},
  [1485] = {.lex_state = 215},
  [1486] = {.lex_state = 206},
  [1487] = {.lex_state = 209},
  [1488] = {.lex_state = 206, .external_lex_state = 7},
  [1489] = {.lex_state = 209},
  [1490] = {.lex_state = 206, .external_lex_state = 7},
  [1491] = {.lex_state = 206, .external_lex_state = 7},
  [1492] = {.lex_state = 215},
  [1493] = {.lex_state = 215},
  [1494] = {.lex_state = 209},
  [1495] = {.lex_state = 215},
  [1496] = {.lex_state = 215},
  [1497] = {.lex_state = 206, .external_lex_state = 7},
  [1498] = {.lex_state = 213},
  [1499] = {.lex_state = 213},
  [1500] = {.lex_state = 215},
  [1501] = {.lex_state = 215},
  [1502] = {.lex_state = 215},
  [1503] = {.lex_state = 215},
  [1504] = {.lex_state = 206, .external_lex_state = 7},
  [1505] = {.lex_state = 215},
  [1506] = {.lex_state = 206, .external_lex_state = 7},
  [1507] = {.lex_state = 215},
  [1508] = {.lex_state = 215},
  [1509] = {.lex_state = 215},
  [1510] = {.lex_state = 215},
  [1511] = {.lex_state = 215},
  [1512] = {.lex_state = 215},
  [1513] = {.lex_state = 215},
  [1514] = {.lex_state = 215},
  [1515] = {.lex_state = 215},
  [1516] = {.lex_state = 206, .external_lex_state = 7},
  [1517] = {.lex_state = 206, .external_lex_state = 7},
  [1518] = {.lex_state = 215},
  [1519] = {.lex_state = 215},
  [1520] = {.lex_state = 215},
  [1521] = {.lex_state = 206, .external_lex_state = 7},
  [1522] = {.lex_state = 215},
  [1523] = {.lex_state = 206, .external_lex_state = 7},
  [1524] = {.lex_state = 209},
  [1525] = {.lex_state = 206, .external_lex_state = 7},
  [1526] = {.lex_state = 215},
  [1527] = {.lex_state = 209},
  [1528] = {.lex_state = 206, .external_lex_state = 7},
  [1529] = {.lex_state = 215},
  [1530] = {.lex_state = 213},
  [1531] = {.lex_state = 209},
  [1532] = {.lex_state = 209},
  [1533] = {.lex_state = 206, .external_lex_state = 7},
  [1534] = {.lex_state = 206, .external_lex_state = 7},
  [1535] = {.lex_state = 217},
  [1536] = {.lex_state = 209},
  [1537] = {.lex_state = 209},
  [1538] = {.lex_state = 217},
  [1539] = {.lex_state = 217},
  [1540] = {.lex_state = 206, .external_lex_state = 7},
  [1541] = {.lex_state = 217},
  [1542] = {.lex_state = 206},
  [1543] = {.lex_state = 217},
  [1544] = {.lex_state = 215},
  [1545] = {.lex_state = 217},
  [1546] = {.lex_state = 206, .external_lex_state = 7},
  [1547] = {.lex_state = 217},
  [1548] = {.lex_state = 217},
  [1549] = {.lex_state = 206, .external_lex_state = 7},
  [1550] = {.lex_state = 215},
  [1551] = {.lex_state = 206, .external_lex_state = 7},
  [1552] = {.lex_state = 215},
  [1553] = {.lex_state = 217},
  [1554] = {.lex_state = 215},
  [1555] = {.lex_state = 209},
  [1556] = {.lex_state = 206, .external_lex_state = 7},
  [1557] = {.lex_state = 206, .external_lex_state = 7},
  [1558] = {.lex_state = 206},
  [1559] = {.lex_state = 206, .external_lex_state = 7},
  [1560] = {.lex_state = 213},
  [1561] = {.lex_state = 206, .external_lex_state = 7},
  [1562] = {.lex_state = 209},
  [1563] = {.lex_state = 206, .external_lex_state = 7},
  [1564] = {.lex_state = 217},
  [1565] = {.lex_state = 209},
  [1566] = {.lex_state = 206, .external_lex_state = 8},
  [1567] = {.lex_state = 213},
  [1568] = {.lex_state = 213},
  [1569] = {.lex_state = 206},
  [1570] = {.lex_state = 213},
  [1571] = {.lex_state = 213},
  [1572] = {.lex_state = 209},
  [1573] = {.lex_state = 217},
  [1574] = {.lex_state = 217},
  [1575] = {.lex_state = 206, .external_lex_state = 7},
  [1576] = {.lex_state = 217},
  [1577] = {.lex_state = 217},
  [1578] = {.lex_state = 209},
  [1579] = {.lex_state = 206, .external_lex_state = 7},
  [1580] = {.lex_state = 217},
  [1581] = {.lex_state = 206, .external_lex_state = 7},
  [1582] = {.lex_state = 209},
  [1583] = {.lex_state = 217},
  [1584] = {.lex_state = 217},
  [1585] = {.lex_state = 206, .external_lex_state = 7},
  [1586] = {.lex_state = 213},
  [1587] = {.lex_state = 206, .external_lex_state = 7},
  [1588] = {.lex_state = 206, .external_lex_state = 7},
  [1589] = {.lex_state = 206, .external_lex_state = 7},
  [1590] = {.lex_state = 217},
  [1591] = {.lex_state = 217},
  [1592] = {.lex_state = 206, .external_lex_state = 8},
  [1593] = {.lex_state = 217},
  [1594] = {.lex_state = 217},
  [1595] = {.lex_state = 209},
  [1596] = {.lex_state = 217},
  [1597] = {.lex_state = 217},
  [1598] = {.lex_state = 217},
  [1599] = {.lex_state = 217},
  [1600] = {.lex_state = 217},
  [1601] = {.lex_state = 217},
  [1602] = {.lex_state = 217},
  [1603] = {.lex_state = 213},
  [1604] = {.lex_state = 217},
  [1605] = {.lex_state = 217},
  [1606] = {.lex_state = 206},
  [1607] = {.lex_state = 206, .external_lex_state = 7},
  [1608] = {.lex_state = 206},
  [1609] = {.lex_state = 206},
  [1610] = {.lex_state = 206},
  [1611] = {.lex_state = 209},
  [1612] = {.lex_state = 206, .external_lex_state = 9},
  [1613] = {.lex_state = 206},
  [1614] = {.lex_state = 206, .external_lex_state = 9},
  [1615] = {.lex_state = 206, .external_lex_state = 10},
  [1616] = {.lex_state = 206, .external_lex_state = 9},
  [1617] = {.lex_state = 206, .external_lex_state = 10},
  [1618] = {.lex_state = 206, .external_lex_state = 10},
  [1619] = {.lex_state = 206},
  [1620] = {.lex_state = 209},
  [1621] = {.lex_state = 215},
  [1622] = {.lex_state = 206, .external_lex_state = 10},
  [1623] = {.lex_state = 206, .external_lex_state = 9},
  [1624] = {.lex_state = 209},
  [1625] = {.lex_state = 206},
  [1626] = {.lex_state = 206, .external_lex_state = 9},
  [1627] = {.lex_state = 209},
  [1628] = {.lex_state = 206, .external_lex_state = 10},
  [1629] = {.lex_state = 206, .external_lex_state = 10},
  [1630] = {.lex_state = 206, .external_lex_state = 9},
  [1631] = {.lex_state = 206, .external_lex_state = 10},
  [1632] = {.lex_state = 206, .external_lex_state = 9},
  [1633] = {.lex_state = 209},
  [1634] = {.lex_state = 206, .external_lex_state = 9},
  [1635] = {.lex_state = 206, .external_lex_state = 9},
  [1636] = {.lex_state = 206, .external_lex_state = 9},
  [1637] = {.lex_state = 206, .external_lex_state = 9},
  [1638] = {.lex_state = 206},
  [1639] = {.lex_state = 206},
  [1640] = {.lex_state = 209},
  [1641] = {.lex_state = 206},
  [1642] = {.lex_state = 206, .external_lex_state = 10},
  [1643] = {.lex_state = 206, .external_lex_state = 10},
  [1644] = {.lex_state = 217},
  [1645] = {.lex_state = 206, .external_lex_state = 10},
  [1646] = {.lex_state = 206},
  [1647] = {.lex_state = 206, .external_lex_state = 10},
  [1648] = {.lex_state = 215},
  [1649] = {.lex_state = 206, .external_lex_state = 9},
  [1650] = {.lex_state = 206, .external_lex_state = 10},
  [1651] = {.lex_state = 206, .external_lex_state = 9},
  [1652] = {.lex_state = 206, .external_lex_state = 9},
  [1653] = {.lex_state = 206, .external_lex_state = 7},
  [1654] = {.lex_state = 206, .external_lex_state = 9},
  [1655] = {.lex_state = 206, .external_lex_state = 9},
  [1656] = {.lex_state = 206},
  [1657] = {.lex_state = 206, .external_lex_state = 9},
  [1658] = {.lex_state = 206, .external_lex_state = 9},
  [1659] = {.lex_state = 206, .external_lex_state = 9},
  [1660] = {.lex_state = 206, .external_lex_state = 9},
  [1661] = {.lex_state = 206, .external_lex_state = 9},
  [1662] = {.lex_state = 206, .external_lex_state = 9},
  [1663] = {.lex_state = 209},
  [1664] = {.lex_state = 209},
  [1665] = {.lex_state = 206},
  [1666] = {.lex_state = 206},
  [1667] = {.lex_state = 206, .external_lex_state = 10},
  [1668] = {.lex_state = 206, .external_lex_state = 10},
  [1669] = {.lex_state = 206, .external_lex_state = 10},
  [1670] = {.lex_state = 206, .external_lex_state = 10},
  [1671] = {.lex_state = 206, .external_lex_state = 10},
  [1672] = {.lex_state = 206, .external_lex_state = 10},
  [1673] = {.lex_state = 206, .external_lex_state = 10},
  [1674] = {.lex_state = 206, .external_lex_state = 10},
  [1675] = {.lex_state = 206, .external_lex_state = 10},
  [1676] = {.lex_state = 206, .external_lex_state = 10},
  [1677] = {.lex_state = 206, .external_lex_state = 10},
  [1678] = {.lex_state = 206},
  [1679] = {.lex_state = 206, .external_lex_state = 10},
  [1680] = {.lex_state = 206, .external_lex_state = 10},
  [1681] = {.lex_state = 206, .external_lex_state = 10},
  [1682] = {.lex_state = 206, .external_lex_state = 9},
  [1683] = {.lex_state = 209},
  [1684] = {.lex_state = 209},
  [1685] = {.lex_state = 206},
  [1686] = {.lex_state = 206},
  [1687] = {.lex_state = 206},
  [1688] = {.lex_state = 209},
  [1689] = {.lex_state = 209},
  [1690] = {.lex_state = 206},
  [1691] = {.lex_state = 209},
  [1692] = {.lex_state = 206},
  [1693] = {.lex_state = 206, .external_lex_state = 9},
  [1694] = {.lex_state = 206},
  [1695] = {.lex_state = 206},
  [1696] = {.lex_state = 206, .external_lex_state = 10},
  [1697] = {.lex_state = 206, .external_lex_state = 10},
  [1698] = {.lex_state = 209},
  [1699] = {.lex_state = 209},
  [1700] = {.lex_state = 206, .external_lex_state = 9},
  [1701] = {.lex_state = 206, .external_lex_state = 10},
  [1702] = {.lex_state = 206, .external_lex_state = 10},
  [1703] = {.lex_state = 206},
  [1704] = {.lex_state = 206},
  [1705] = {.lex_state = 206, .external_lex_state = 9},
  [1706] = {.lex_state = 206, .external_lex_state = 9},
  [1707] = {.lex_state = 206, .external_lex_state = 9},
  [1708] = {.lex_state = 206, .external_lex_state = 9},
  [1709] = {.lex_state = 206, .external_lex_state = 9},
  [1710] = {.lex_state = 206},
  [1711] = {.lex_state = 206},
  [1712] = {.lex_state = 206},
  [1713] = {.lex_state = 206},
  [1714] = {.lex_state = 206},
  [1715] = {.lex_state = 206},
  [1716] = {.lex_state = 206},
  [1717] = {.lex_state = 206},
  [1718] = {.lex_state = 206},
  [1719] = {.lex_state = 206},
  [1720] = {.lex_state = 206},
  [1721] = {.lex_state = 206, .external_lex_state = 7},
  [1722] = {.lex_state = 206},
  [1723] = {.lex_state = 206},
  [1724] = {.lex_state = 206},
  [1725] = {.lex_state = 206},
  [1726] = {.lex_state = 206},
  [1727] = {.lex_state = 206},
  [1728] = {.lex_state = 206},
  [1729] = {.lex_state = 206},
  [1730] = {.lex_state = 206},
  [1731] = {.lex_state = 206},
  [1732] = {.lex_state = 206},
  [1733] = {.lex_state = 206},
  [1734] = {.lex_state = 206},
  [1735] = {.lex_state = 206},
  [1736] = {.lex_state = 206},
  [1737] = {.lex_state = 206},
  [1738] = {.lex_state = 206},
  [1739] = {.lex_state = 206},
  [1740] = {.lex_state = 206},
  [1741] = {.lex_state = 206},
  [1742] = {.lex_state = 206},
  [1743] = {.lex_state = 206},
  [1744] = {.lex_state = 206},
  [1745] = {.lex_state = 206},
  [1746] = {.lex_state = 206},
  [1747] = {.lex_state = 206},
  [1748] = {.lex_state = 206},
  [1749] = {.lex_state = 206},
  [1750] = {.lex_state = 206},
  [1751] = {.lex_state = 206},
  [1752] = {.lex_state = 206},
  [1753] = {.lex_state = 206},
  [1754] = {.lex_state = 206},
  [1755] = {.lex_state = 206},
  [1756] = {.lex_state = 206},
  [1757] = {.lex_state = 206},
  [1758] = {.lex_state = 206},
  [1759] = {.lex_state = 206},
  [1760] = {.lex_state = 206},
  [1761] = {.lex_state = 206},
  [1762] = {.lex_state = 206},
  [1763] = {.lex_state = 206},
  [1764] = {.lex_state = 206},
  [1765] = {.lex_state = 206},
  [1766] = {.lex_state = 206},
  [1767] = {.lex_state = 206},
  [1768] = {.lex_state = 206},
  [1769] = {.lex_state = 206},
  [1770] = {.lex_state = 206},
  [1771] = {.lex_state = 206},
  [1772] = {.lex_state = 206},
  [1773] = {.lex_state = 206},
  [1774] = {.lex_state = 206},
  [1775] = {.lex_state = 206},
  [1776] = {.lex_state = 206},
  [1777] = {.lex_state = 206},
  [1778] = {.lex_state = 206},
  [1779] = {.lex_state = 206},
  [1780] = {.lex_state = 206},
  [1781] = {.lex_state = 206},
  [1782] = {.lex_state = 206},
  [1783] = {.lex_state = 206},
  [1784] = {.lex_state = 206},
  [1785] = {.lex_state = 206, .external_lex_state = 10},
  [1786] = {.lex_state = 206},
  [1787] = {.lex_state = 206, .external_lex_state = 9},
  [1788] = {.lex_state = 206, .external_lex_state = 7},
  [1789] = {.lex_state = 206},
  [1790] = {.lex_state = 206, .external_lex_state = 7},
  [1791] = {.lex_state = 206},
  [1792] = {.lex_state = 206, .external_lex_state = 7},
  [1793] = {.lex_state = 206},
  [1794] = {.lex_state = 206},
  [1795] = {.lex_state = 206},
  [1796] = {.lex_state = 206, .external_lex_state = 7},
  [1797] = {.lex_state = 206, .external_lex_state = 7},
  [1798] = {.lex_state = 206},
  [1799] = {.lex_state = 206},
  [1800] = {.lex_state = 206, .external_lex_state = 7},
  [1801] = {.lex_state = 206},
  [1802] = {.lex_state = 206},
  [1803] = {.lex_state = 206},
  [1804] = {.lex_state = 206},
  [1805] = {.lex_state = 206},
  [1806] = {.lex_state = 206},
  [1807] = {.lex_state = 206},
  [1808] = {.lex_state = 206},
  [1809] = {.lex_state = 206},
  [1810] = {.lex_state = 206},
  [1811] = {.lex_state = 206},
  [1812] = {.lex_state = 206},
  [1813] = {.lex_state = 206},
  [1814] = {.lex_state = 206},
  [1815] = {.lex_state = 206},
  [1816] = {.lex_state = 206},
  [1817] = {.lex_state = 206},
  [1818] = {.lex_state = 206},
  [1819] = {.lex_state = 206},
  [1820] = {.lex_state = 206},
  [1821] = {.lex_state = 206},
  [1822] = {.lex_state = 206},
  [1823] = {.lex_state = 206},
  [1824] = {.lex_state = 206},
  [1825] = {.lex_state = 206},
  [1826] = {.lex_state = 206},
  [1827] = {.lex_state = 206},
  [1828] = {.lex_state = 206},
  [1829] = {.lex_state = 206},
  [1830] = {.lex_state = 206},
  [1831] = {.lex_state = 206},
  [1832] = {.lex_state = 206},
  [1833] = {.lex_state = 206},
  [1834] = {.lex_state = 206},
  [1835] = {.lex_state = 206},
  [1836] = {.lex_state = 206},
  [1837] = {.lex_state = 206},
  [1838] = {.lex_state = 206},
  [1839] = {.lex_state = 206},
  [1840] = {.lex_state = 206},
  [1841] = {.lex_state = 206},
  [1842] = {.lex_state = 206},
  [1843] = {.lex_state = 206},
  [1844] = {.lex_state = 206},
  [1845] = {.lex_state = 206},
  [1846] = {.lex_state = 206},
  [1847] = {.lex_state = 206},
  [1848] = {.lex_state = 206},
  [1849] = {.lex_state = 206},
  [1850] = {.lex_state = 206},
  [1851] = {.lex_state = 206},
  [1852] = {.lex_state = 206},
  [1853] = {.lex_state = 206},
  [1854] = {.lex_state = 206},
  [1855] = {.lex_state = 206},
  [1856] = {.lex_state = 206},
  [1857] = {.lex_state = 206},
  [1858] = {.lex_state = 206},
  [1859] = {.lex_state = 206},
  [1860] = {.lex_state = 206},
  [1861] = {.lex_state = 206},
  [1862] = {.lex_state = 206},
  [1863] = {.lex_state = 206},
  [1864] = {.lex_state = 206},
  [1865] = {.lex_state = 206},
  [1866] = {.lex_state = 206},
  [1867] = {.lex_state = 206},
  [1868] = {.lex_state = 206},
  [1869] = {.lex_state = 206},
  [1870] = {.lex_state = 206},
  [1871] = {.lex_state = 206},
  [1872] = {.lex_state = 206},
  [1873] = {.lex_state = 206},
  [1874] = {.lex_state = 206},
  [1875] = {.lex_state = 206},
  [1876] = {.lex_state = 206},
  [1877] = {.lex_state = 206},
  [1878] = {.lex_state = 206},
  [1879] = {.lex_state = 206},
  [1880] = {.lex_state = 206},
  [1881] = {.lex_state = 206},
  [1882] = {.lex_state = 206},
  [1883] = {.lex_state = 206},
  [1884] = {.lex_state = 206},
  [1885] = {.lex_state = 206},
  [1886] = {.lex_state = 206},
  [1887] = {.lex_state = 206},
  [1888] = {.lex_state = 206},
  [1889] = {.lex_state = 206},
  [1890] = {.lex_state = 206},
  [1891] = {.lex_state = 206},
  [1892] = {.lex_state = 206},
  [1893] = {.lex_state = 206},
  [1894] = {.lex_state = 206},
  [1895] = {.lex_state = 206},
  [1896] = {.lex_state = 206},
  [1897] = {.lex_state = 206},
  [1898] = {.lex_state = 206},
  [1899] = {.lex_state = 206},
  [1900] = {.lex_state = 206},
  [1901] = {.lex_state = 206},
  [1902] = {.lex_state = 206},
  [1903] = {.lex_state = 206},
  [1904] = {.lex_state = 206},
  [1905] = {.lex_state = 206},
  [1906] = {.lex_state = 206},
  [1907] = {.lex_state = 206},
  [1908] = {.lex_state = 206},
  [1909] = {.lex_state = 206},
  [1910] = {.lex_state = 206},
  [1911] = {.lex_state = 206},
  [1912] = {.lex_state = 206},
  [1913] = {.lex_state = 206},
  [1914] = {.lex_state = 206},
  [1915] = {.lex_state = 206},
  [1916] = {.lex_state = 206},
  [1917] = {.lex_state = 206},
  [1918] = {.lex_state = 206},
  [1919] = {.lex_state = 206},
  [1920] = {.lex_state = 206},
  [1921] = {.lex_state = 206},
  [1922] = {.lex_state = 206},
  [1923] = {.lex_state = 206},
  [1924] = {.lex_state = 206},
  [1925] = {.lex_state = 206},
  [1926] = {.lex_state = 206},
  [1927] = {.lex_state = 206},
  [1928] = {.lex_state = 206},
  [1929] = {.lex_state = 206},
  [1930] = {.lex_state = 206},
  [1931] = {.lex_state = 206},
  [1932] = {.lex_state = 206},
  [1933] = {.lex_state = 206},
  [1934] = {.lex_state = 206},
  [1935] = {.lex_state = 206},
  [1936] = {.lex_state = 206},
  [1937] = {.lex_state = 206},
  [1938] = {.lex_state = 206},
  [1939] = {.lex_state = 206},
  [1940] = {.lex_state = 206},
  [1941] = {.lex_state = 206, .external_lex_state = 7},
  [1942] = {.lex_state = 206},
  [1943] = {.lex_state = 206},
  [1944] = {.lex_state = 206},
  [1945] = {.lex_state = 206},
  [1946] = {.lex_state = 206},
  [1947] = {.lex_state = 206},
  [1948] = {.lex_state = 206},
  [1949] = {.lex_state = 206},
  [1950] = {.lex_state = 206},
  [1951] = {.lex_state = 206},
  [1952] = {.lex_state = 206},
  [1953] = {.lex_state = 206},
  [1954] = {.lex_state = 206},
  [1955] = {.lex_state = 206},
  [1956] = {.lex_state = 206},
  [1957] = {.lex_state = 206},
  [1958] = {.lex_state = 206},
  [1959] = {.lex_state = 206},
  [1960] = {.lex_state = 206},
  [1961] = {.lex_state = 206},
  [1962] = {.lex_state = 206},
  [1963] = {.lex_state = 206},
  [1964] = {.lex_state = 206},
  [1965] = {.lex_state = 206},
  [1966] = {.lex_state = 206},
  [1967] = {.lex_state = 206},
  [1968] = {.lex_state = 206},
  [1969] = {.lex_state = 206},
  [1970] = {.lex_state = 206},
  [1971] = {.lex_state = 206},
  [1972] = {.lex_state = 206},
  [1973] = {.lex_state = 206},
  [1974] = {.lex_state = 206},
  [1975] = {.lex_state = 206},
  [1976] = {.lex_state = 206},
  [1977] = {.lex_state = 206},
  [1978] = {.lex_state = 206},
  [1979] = {.lex_state = 206},
  [1980] = {.lex_state = 206},
  [1981] = {.lex_state = 206},
  [1982] = {.lex_state = 206},
  [1983] = {.lex_state = 206},
  [1984] = {.lex_state = 206},
  [1985] = {.lex_state = 206},
  [1986] = {.lex_state = 206},
  [1987] = {.lex_state = 206},
  [1988] = {.lex_state = 206},
  [1989] = {.lex_state = 206},
  [1990] = {.lex_state = 206},
  [1991] = {.lex_state = 206},
  [1992] = {.lex_state = 206},
  [1993] = {.lex_state = 206},
  [1994] = {.lex_state = 206},
  [1995] = {.lex_state = 206},
  [1996] = {.lex_state = 206},
  [1997] = {.lex_state = 206},
  [1998] = {.lex_state = 206},
  [1999] = {.lex_state = 202, .external_lex_state = 4},
  [2000] = {.lex_state = 202, .external_lex_state = 4},
  [2001] = {.lex_state = 202, .external_lex_state = 4},
  [2002] = {.lex_state = 202, .external_lex_state = 4},
  [2003] = {.lex_state = 202, .external_lex_state = 4},
  [2004] = {.lex_state = 202, .external_lex_state = 4},
  [2005] = {.lex_state = 202, .external_lex_state = 4},
  [2006] = {.lex_state = 202, .external_lex_state = 4},
  [2007] = {.lex_state = 202, .external_lex_state = 4},
  [2008] = {.lex_state = 218},
  [2009] = {.lex_state = 218},
  [2010] = {.lex_state = 218},
  [2011] = {.lex_state = 218},
  [2012] = {.lex_state = 201, .external_lex_state = 3},
  [2013] = {.lex_state = 201, .external_lex_state = 4},
  [2014] = {.lex_state = 219},
  [2015] = {.lex_state = 219},
  [2016] = {.lex_state = 219},
  [2017] = {.lex_state = 201, .external_lex_state = 4},
  [2018] = {.lex_state = 201, .external_lex_state = 4},
  [2019] = {.lex_state = 201, .external_lex_state = 4},
  [2020] = {.lex_state = 201, .external_lex_state = 4},
  [2021] = {.lex_state = 201, .external_lex_state = 4},
  [2022] = {.lex_state = 201, .external_lex_state = 4},
  [2023] = {.lex_state = 201, .external_lex_state = 4},
  [2024] = {.lex_state = 201, .external_lex_state = 4},
  [2025] = {.lex_state = 220, .external_lex_state = 6},
  [2026] = {.lex_state = 201, .external_lex_state = 4},
  [2027] = {.lex_state = 201, .external_lex_state = 4},
  [2028] = {.lex_state = 201, .external_lex_state = 4},
  [2029] = {.lex_state = 201, .external_lex_state = 4},
  [2030] = {.lex_state = 201, .external_lex_state = 4},
  [2031] = {.lex_state = 201, .external_lex_state = 4},
  [2032] = {.lex_state = 201, .external_lex_state = 4},
  [2033] = {.lex_state = 201, .external_lex_state = 4},
  [2034] = {.lex_state = 201, .external_lex_state = 4},
  [2035] = {.lex_state = 201, .external_lex_state = 4},
  [2036] = {.lex_state = 201, .external_lex_state = 5},
  [2037] = {.lex_state = 201, .external_lex_state = 5},
  [2038] = {.lex_state = 201, .external_lex_state = 5},
  [2039] = {.lex_state = 201, .external_lex_state = 5},
  [2040] = {.lex_state = 204, .external_lex_state = 6},
  [2041] = {.lex_state = 203, .external_lex_state = 4},
  [2042] = {.lex_state = 201, .external_lex_state = 4},
  [2043] = {.lex_state = 201, .external_lex_state = 5},
  [2044] = {.lex_state = 201, .external_lex_state = 5},
  [2045] = {.lex_state = 201, .external_lex_state = 5},
  [2046] = {.lex_state = 201, .external_lex_state = 5},
  [2047] = {.lex_state = 201, .external_lex_state = 5},
  [2048] = {.lex_state = 201, .external_lex_state = 5},
  [2049] = {.lex_state = 201, .external_lex_state = 4},
  [2050] = {.lex_state = 204},
  [2051] = {.lex_state = 201, .external_lex_state = 4},
  [2052] = {.lex_state = 201, .external_lex_state = 4},
  [2053] = {.lex_state = 220},
  [2054] = {.lex_state = 201, .external_lex_state = 4},
  [2055] = {.lex_state = 201, .external_lex_state = 4},
  [2056] = {.lex_state = 201, .external_lex_state = 4},
  [2057] = {.lex_state = 201, .external_lex_state = 4},
  [2058] = {.lex_state = 201, .external_lex_state = 4},
  [2059] = {.lex_state = 201, .external_lex_state = 4},
  [2060] = {.lex_state = 201, .external_lex_state = 4},
  [2061] = {.lex_state = 201, .external_lex_state = 4},
  [2062] = {.lex_state = 201, .external_lex_state = 4},
  [2063] = {.lex_state = 201, .external_lex_state = 4},
  [2064] = {.lex_state = 201, .external_lex_state = 4},
  [2065] = {.lex_state = 201, .external_lex_state = 4},
  [2066] = {.lex_state = 201, .external_lex_state = 4},
  [2067] = {.lex_state = 201, .external_lex_state = 4},
  [2068] = {.lex_state = 201, .external_lex_state = 4},
  [2069] = {.lex_state = 201, .external_lex_state = 4},
  [2070] = {.lex_state = 201, .external_lex_state = 4},
  [2071] = {.lex_state = 201, .external_lex_state = 4},
  [2072] = {.lex_state = 201, .external_lex_state = 4},
  [2073] = {.lex_state = 201, .external_lex_state = 4},
  [2074] = {.lex_state = 201, .external_lex_state = 4},
  [2075] = {.lex_state = 201, .external_lex_state = 4},
  [2076] = {.lex_state = 201, .external_lex_state = 4},
  [2077] = {.lex_state = 201, .external_lex_state = 4},
  [2078] = {.lex_state = 201, .external_lex_state = 4},
  [2079] = {.lex_state = 201, .external_lex_state = 4},
  [2080] = {.lex_state = 201, .external_lex_state = 4},
  [2081] = {.lex_state = 201, .external_lex_state = 4},
  [2082] = {.lex_state = 201, .external_lex_state = 4},
  [2083] = {.lex_state = 201, .external_lex_state = 4},
  [2084] = {.lex_state = 201, .external_lex_state = 4},
  [2085] = {.lex_state = 201, .external_lex_state = 4},
  [2086] = {.lex_state = 201, .external_lex_state = 4},
  [2087] = {.lex_state = 201, .external_lex_state = 4},
  [2088] = {.lex_state = 201, .external_lex_state = 4},
  [2089] = {.lex_state = 201, .external_lex_state = 4},
  [2090] = {.lex_state = 201, .external_lex_state = 4},
  [2091] = {.lex_state = 201, .external_lex_state = 4},
  [2092] = {.lex_state = 201, .external_lex_state = 4},
  [2093] = {.lex_state = 201, .external_lex_state = 4},
  [2094] = {.lex_state = 201, .external_lex_state = 4},
  [2095] = {.lex_state = 201, .external_lex_state = 4},
  [2096] = {.lex_state = 201, .external_lex_state = 4},
  [2097] = {.lex_state = 201, .external_lex_state = 4},
  [2098] = {.lex_state = 201, .external_lex_state = 4},
  [2099] = {.lex_state = 201, .external_lex_state = 4},
  [2100] = {.lex_state = 201, .external_lex_state = 4},
  [2101] = {.lex_state = 201, .external_lex_state = 4},
  [2102] = {.lex_state = 201, .external_lex_state = 4},
  [2103] = {.lex_state = 201, .external_lex_state = 4},
  [2104] = {.lex_state = 201, .external_lex_state = 4},
  [2105] = {.lex_state = 201, .external_lex_state = 4},
  [2106] = {.lex_state = 201, .external_lex_state = 4},
  [2107] = {.lex_state = 201, .external_lex_state = 4},
  [2108] = {.lex_state = 201, .external_lex_state = 4},
  [2109] = {.lex_state = 201, .external_lex_state = 4},
  [2110] = {.lex_state = 201, .external_lex_state = 4},
  [2111] = {.lex_state = 201, .external_lex_state = 4},
  [2112] = {.lex_state = 201, .external_lex_state = 4},
  [2113] = {.lex_state = 201, .external_lex_state = 4},
  [2114] = {.lex_state = 201, .external_lex_state = 4},
  [2115] = {.lex_state = 204, .external_lex_state = 6},
  [2116] = {.lex_state = 204, .external_lex_state = 6},
  [2117] = {.lex_state = 201, .external_lex_state = 4},
  [2118] = {.lex_state = 204, .external_lex_state = 6},
  [2119] = {.lex_state = 201, .external_lex_state = 4},
  [2120] = {.lex_state = 201, .external_lex_state = 4},
  [2121] = {.lex_state = 201, .external_lex_state = 4},
  [2122] = {.lex_state = 201, .external_lex_state = 4},
  [2123] = {.lex_state = 201, .external_lex_state = 4},
  [2124] = {.lex_state = 201, .external_lex_state = 4},
  [2125] = {.lex_state = 201, .external_lex_state = 4},
  [2126] = {.lex_state = 201, .external_lex_state = 4},
  [2127] = {.lex_state = 201, .external_lex_state = 4},
  [2128] = {.lex_state = 204, .external_lex_state = 6},
  [2129] = {.lex_state = 204, .external_lex_state = 6},
  [2130] = {.lex_state = 204, .external_lex_state = 6},
  [2131] = {.lex_state = 204, .external_lex_state = 6},
  [2132] = {.lex_state = 204, .external_lex_state = 6},
  [2133] = {.lex_state = 204, .external_lex_state = 6},
  [2134] = {.lex_state = 204, .external_lex_state = 6},
  [2135] = {.lex_state = 204, .external_lex_state = 6},
  [2136] = {.lex_state = 204, .external_lex_state = 6},
  [2137] = {.lex_state = 204, .external_lex_state = 6},
  [2138] = {.lex_state = 204, .external_lex_state = 6},
  [2139] = {.lex_state = 204, .external_lex_state = 6},
  [2140] = {.lex_state = 204, .external_lex_state = 6},
  [2141] = {.lex_state = 204, .external_lex_state = 6},
  [2142] = {.lex_state = 204, .external_lex_state = 6},
  [2143] = {.lex_state = 204, .external_lex_state = 6},
  [2144] = {.lex_state = 204, .external_lex_state = 6},
  [2145] = {.lex_state = 204, .external_lex_state = 6},
  [2146] = {.lex_state = 204, .external_lex_state = 6},
  [2147] = {.lex_state = 204, .external_lex_state = 6},
  [2148] = {.lex_state = 204, .external_lex_state = 6},
  [2149] = {.lex_state = 204, .external_lex_state = 6},
  [2150] = {.lex_state = 204, .external_lex_state = 6},
  [2151] = {.lex_state = 204},
  [2152] = {.lex_state = 204, .external_lex_state = 6},
  [2153] = {.lex_state = 204, .external_lex_state = 6},
  [2154] = {.lex_state = 204, .external_lex_state = 6},
  [2155] = {.lex_state = 204, .external_lex_state = 6},
  [2156] = {.lex_state = 204, .external_lex_state = 6},
  [2157] = {.lex_state = 204, .external_lex_state = 6},
  [2158] = {.lex_state = 204, .external_lex_state = 6},
  [2159] = {.lex_state = 204, .external_lex_state = 6},
  [2160] = {.lex_state = 204, .external_lex_state = 6},
  [2161] = {.lex_state = 204, .external_lex_state = 6},
  [2162] = {.lex_state = 204, .external_lex_state = 6},
  [2163] = {.lex_state = 204, .external_lex_state = 6},
  [2164] = {.lex_state = 204, .external_lex_state = 6},
  [2165] = {.lex_state = 204, .external_lex_state = 6},
  [2166] = {.lex_state = 204, .external_lex_state = 6},
  [2167] = {.lex_state = 204, .external_lex_state = 6},
  [2168] = {.lex_state = 204, .external_lex_state = 6},
  [2169] = {.lex_state = 204, .external_lex_state = 6},
  [2170] = {.lex_state = 204, .external_lex_state = 6},
  [2171] = {.lex_state = 204, .external_lex_state = 6},
  [2172] = {.lex_state = 204, .external_lex_state = 6},
  [2173] = {.lex_state = 204, .external_lex_state = 6},
  [2174] = {.lex_state = 204},
  [2175] = {.lex_state = 204, .external_lex_state = 6},
  [2176] = {.lex_state = 204, .external_lex_state = 6},
  [2177] = {.lex_state = 204, .external_lex_state = 6},
  [2178] = {.lex_state = 204, .external_lex_state = 6},
  [2179] = {.lex_state = 204, .external_lex_state = 6},
  [2180] = {.lex_state = 204, .external_lex_state = 6},
  [2181] = {.lex_state = 204, .external_lex_state = 6},
  [2182] = {.lex_state = 204, .external_lex_state = 6},
  [2183] = {.lex_state = 204, .external_lex_state = 6},
  [2184] = {.lex_state = 204},
  [2185] = {.lex_state = 204, .external_lex_state = 6},
  [2186] = {.lex_state = 204, .external_lex_state = 6},
  [2187] = {.lex_state = 204, .external_lex_state = 6},
  [2188] = {.lex_state = 204, .external_lex_state = 6},
  [2189] = {.lex_state = 204, .external_lex_state = 6},
  [2190] = {.lex_state = 204, .external_lex_state = 6},
  [2191] = {.lex_state = 204, .external_lex_state = 6},
  [2192] = {.lex_state = 204, .external_lex_state = 6},
  [2193] = {.lex_state = 204, .external_lex_state = 6},
  [2194] = {.lex_state = 204, .external_lex_state = 6},
  [2195] = {.lex_state = 204, .external_lex_state = 6},
  [2196] = {.lex_state = 204},
  [2197] = {.lex_state = 204, .external_lex_state = 6},
  [2198] = {.lex_state = 204, .external_lex_state = 6},
  [2199] = {.lex_state = 204},
  [2200] = {.lex_state = 204},
  [2201] = {.lex_state = 204},
  [2202] = {.lex_state = 204},
  [2203] = {.lex_state = 204},
  [2204] = {.lex_state = 204},
  [2205] = {.lex_state = 204},
  [2206] = {.lex_state = 204},
  [2207] = {.lex_state = 204},
  [2208] = {.lex_state = 204},
  [2209] = {.lex_state = 204},
  [2210] = {.lex_state = 204},
  [2211] = {.lex_state = 204},
  [2212] = {.lex_state = 204},
  [2213] = {.lex_state = 204},
  [2214] = {.lex_state = 204},
  [2215] = {.lex_state = 204},
  [2216] = {.lex_state = 204},
  [2217] = {.lex_state = 204},
  [2218] = {.lex_state = 204},
  [2219] = {.lex_state = 204},
  [2220] = {.lex_state = 204},
  [2221] = {.lex_state = 204},
  [2222] = {.lex_state = 204},
  [2223] = {.lex_state = 204},
  [2224] = {.lex_state = 204},
  [2225] = {.lex_state = 204},
  [2226] = {.lex_state = 204},
  [2227] = {.lex_state = 204},
  [2228] = {.lex_state = 204},
  [2229] = {.lex_state = 204},
  [2230] = {.lex_state = 204},
  [2231] = {.lex_state = 204},
  [2232] = {.lex_state = 204},
  [2233] = {.lex_state = 204},
  [2234] = {.lex_state = 204},
  [2235] = {.lex_state = 204},
  [2236] = {.lex_state = 204},
  [2237] = {.lex_state = 204},
  [2238] = {.lex_state = 204},
  [2239] = {.lex_state = 204},
  [2240] = {.lex_state = 204},
  [2241] = {.lex_state = 204},
  [2242] = {.lex_state = 204},
  [2243] = {.lex_state = 204},
  [2244] = {.lex_state = 204},
  [2245] = {.lex_state = 204},
  [2246] = {.lex_state = 204},
  [2247] = {.lex_state = 204},
  [2248] = {.lex_state = 204},
  [2249] = {.lex_state = 204},
  [2250] = {.lex_state = 204},
  [2251] = {.lex_state = 204},
  [2252] = {.lex_state = 204},
  [2253] = {.lex_state = 204},
  [2254] = {.lex_state = 204},
  [2255] = {.lex_state = 204},
  [2256] = {.lex_state = 204},
  [2257] = {.lex_state = 204},
  [2258] = {.lex_state = 204},
  [2259] = {.lex_state = 204},
  [2260] = {.lex_state = 204},
  [2261] = {.lex_state = 204},
  [2262] = {.lex_state = 204},
  [2263] = {.lex_state = 204},
  [2264] = {.lex_state = 204},
  [2265] = {.lex_state = 221},
  [2266] = {.lex_state = 206},
  [2267] = {.lex_state = 206},
  [2268] = {.lex_state = 206},
  [2269] = {.lex_state = 206},
  [2270] = {.lex_state = 206},
  [2271] = {.lex_state = 206},
  [2272] = {.lex_state = 206},
  [2273] = {.lex_state = 206},
  [2274] = {.lex_state = 206},
  [2275] = {.lex_state = 206},
  [2276] = {.lex_state = 206},
  [2277] = {.lex_state = 206},
  [2278] = {.lex_state = 206},
  [2279] = {.lex_state = 206},
  [2280] = {.lex_state = 206},
  [2281] = {.lex_state = 206},
  [2282] = {.lex_state = 206},
  [2283] = {.lex_state = 206},
  [2284] = {.lex_state = 206},
  [2285] = {.lex_state = 206},
  [2286] = {.lex_state = 206},
  [2287] = {.lex_state = 206},
  [2288] = {.lex_state = 206},
  [2289] = {.lex_state = 206},
  [2290] = {.lex_state = 206},
  [2291] = {.lex_state = 206},
  [2292] = {.lex_state = 206},
  [2293] = {.lex_state = 206},
  [2294] = {.lex_state = 206},
  [2295] = {.lex_state = 206},
  [2296] = {.lex_state = 206},
  [2297] = {.lex_state = 206},
  [2298] = {.lex_state = 206},
  [2299] = {.lex_state = 206},
  [2300] = {.lex_state = 206},
  [2301] = {.lex_state = 206},
  [2302] = {.lex_state = 206},
  [2303] = {.lex_state = 206},
  [2304] = {.lex_state = 206},
  [2305] = {.lex_state = 206},
  [2306] = {.lex_state = 206},
  [2307] = {.lex_state = 206},
  [2308] = {.lex_state = 206},
  [2309] = {.lex_state = 206},
  [2310] = {.lex_state = 206},
  [2311] = {.lex_state = 206},
  [2312] = {.lex_state = 206},
  [2313] = {.lex_state = 206},
  [2314] = {.lex_state = 206},
  [2315] = {.lex_state = 206},
  [2316] = {.lex_state = 206},
  [2317] = {.lex_state = 206},
  [2318] = {.lex_state = 206},
  [2319] = {.lex_state = 206},
  [2320] = {.lex_state = 206},
  [2321] = {.lex_state = 206},
  [2322] = {.lex_state = 206},
  [2323] = {.lex_state = 206},
  [2324] = {.lex_state = 206},
  [2325] = {.lex_state = 206},
  [2326] = {.lex_state = 206},
  [2327] = {.lex_state = 206},
  [2328] = {.lex_state = 206},
  [2329] = {.lex_state = 206},
  [2330] = {.lex_state = 206},
  [2331] = {.lex_state = 206},
  [2332] = {.lex_state = 206},
  [2333] = {.lex_state = 206},
  [2334] = {.lex_state = 206},
  [2335] = {.lex_state = 206},
  [2336] = {.lex_state = 208},
  [2337] = {.lex_state = 208},
  [2338] = {.lex_state = 208, .external_lex_state = 7},
  [2339] = {.lex_state = 208},
  [2340] = {.lex_state = 208},
  [2341] = {.lex_state = 208},
  [2342] = {.lex_state = 208},
  [2343] = {.lex_state = 208},
  [2344] = {.lex_state = 208},
  [2345] = {.lex_state = 208},
  [2346] = {.lex_state = 208},
  [2347] = {.lex_state = 208},
  [2348] = {.lex_state = 208},
  [2349] = {.lex_state = 208},
  [2350] = {.lex_state = 208},
  [2351] = {.lex_state = 208},
  [2352] = {.lex_state = 208},
  [2353] = {.lex_state = 208},
  [2354] = {.lex_state = 208},
  [2355] = {.lex_state = 208},
  [2356] = {.lex_state = 208},
  [2357] = {.lex_state = 208},
  [2358] = {.lex_state = 208},
  [2359] = {.lex_state = 208},
  [2360] = {.lex_state = 208, .external_lex_state = 7},
  [2361] = {.lex_state = 208},
  [2362] = {.lex_state = 208},
  [2363] = {.lex_state = 208},
  [2364] = {.lex_state = 208},
  [2365] = {.lex_state = 208},
  [2366] = {.lex_state = 208},
  [2367] = {.lex_state = 208},
  [2368] = {.lex_state = 208},
  [2369] = {.lex_state = 208},
  [2370] = {.lex_state = 208},
  [2371] = {.lex_state = 208, .external_lex_state = 7},
  [2372] = {.lex_state = 208},
  [2373] = {.lex_state = 208},
  [2374] = {.lex_state = 208},
  [2375] = {.lex_state = 208},
  [2376] = {.lex_state = 208},
  [2377] = {.lex_state = 208},
  [2378] = {.lex_state = 208},
  [2379] = {.lex_state = 208},
  [2380] = {.lex_state = 208},
  [2381] = {.lex_state = 208},
  [2382] = {.lex_state = 208},
  [2383] = {.lex_state = 208},
  [2384] = {.lex_state = 208},
  [2385] = {.lex_state = 208},
  [2386] = {.lex_state = 208},
  [2387] = {.lex_state = 208},
  [2388] = {.lex_state = 208},
  [2389] = {.lex_state = 208},
  [2390] = {.lex_state = 208},
  [2391] = {.lex_state = 208, .external_lex_state = 7},
  [2392] = {.lex_state = 208},
  [2393] = {.lex_state = 208},
  [2394] = {.lex_state = 208},
  [2395] = {.lex_state = 208},
  [2396] = {.lex_state = 208},
  [2397] = {.lex_state = 208},
  [2398] = {.lex_state = 208},
  [2399] = {.lex_state = 208},
  [2400] = {.lex_state = 208},
  [2401] = {.lex_state = 208},
  [2402] = {.lex_state = 208},
  [2403] = {.lex_state = 208},
  [2404] = {.lex_state = 208},
  [2405] = {.lex_state = 208},
  [2406] = {.lex_state = 208},
  [2407] = {.lex_state = 208},
  [2408] = {.lex_state = 208},
  [2409] = {.lex_state = 208},
  [2410] = {.lex_state = 208},
  [2411] = {.lex_state = 208},
  [2412] = {.lex_state = 208},
  [2413] = {.lex_state = 208},
  [2414] = {.lex_state = 208},
  [2415] = {.lex_state = 208, .external_lex_state = 7},
  [2416] = {.lex_state = 208},
  [2417] = {.lex_state = 208},
  [2418] = {.lex_state = 208},
  [2419] = {.lex_state = 208},
  [2420] = {.lex_state = 208},
  [2421] = {.lex_state = 208},
  [2422] = {.lex_state = 208},
  [2423] = {.lex_state = 208},
  [2424] = {.lex_state = 208},
  [2425] = {.lex_state = 208},
  [2426] = {.lex_state = 208, .external_lex_state = 7},
  [2427] = {.lex_state = 208, .external_lex_state = 7},
  [2428] = {.lex_state = 208},
  [2429] = {.lex_state = 208},
  [2430] = {.lex_state = 208},
  [2431] = {.lex_state = 208},
  [2432] = {.lex_state = 208},
  [2433] = {.lex_state = 208},
  [2434] = {.lex_state = 222},
  [2435] = {.lex_state = 208},
  [2436] = {.lex_state = 208},
  [2437] = {.lex_state = 208},
  [2438] = {.lex_state = 208},
  [2439] = {.lex_state = 208},
  [2440] = {.lex_state = 208},
  [2441] = {.lex_state = 222},
  [2442] = {.lex_state = 208},
  [2443] = {.lex_state = 208, .external_lex_state = 7},
  [2444] = {.lex_state = 208},
  [2445] = {.lex_state = 222},
  [2446] = {.lex_state = 208},
  [2447] = {.lex_state = 208},
  [2448] = {.lex_state = 208},
  [2449] = {.lex_state = 208},
  [2450] = {.lex_state = 208},
  [2451] = {.lex_state = 208},
  [2452] = {.lex_state = 208},
  [2453] = {.lex_state = 222},
  [2454] = {.lex_state = 208},
  [2455] = {.lex_state = 222},
  [2456] = {.lex_state = 208},
  [2457] = {.lex_state = 208},
  [2458] = {.lex_state = 208},
  [2459] = {.lex_state = 222},
  [2460] = {.lex_state = 208},
  [2461] = {.lex_state = 208},
  [2462] = {.lex_state = 222},
  [2463] = {.lex_state = 222},
  [2464] = {.lex_state = 208},
  [2465] = {.lex_state = 208},
  [2466] = {.lex_state = 208},
  [2467] = {.lex_state = 208},
  [2468] = {.lex_state = 208},
  [2469] = {.lex_state = 208},
  [2470] = {.lex_state = 208},
  [2471] = {.lex_state = 208},
  [2472] = {.lex_state = 208},
  [2473] = {.lex_state = 208, .external_lex_state = 7},
  [2474] = {.lex_state = 208},
  [2475] = {.lex_state = 208},
  [2476] = {.lex_state = 208},
  [2477] = {.lex_state = 208},
  [2478] = {.lex_state = 208},
  [2479] = {.lex_state = 208},
  [2480] = {.lex_state = 208},
  [2481] = {.lex_state = 222},
  [2482] = {.lex_state = 208},
  [2483] = {.lex_state = 208, .external_lex_state = 7},
  [2484] = {.lex_state = 208},
  [2485] = {.lex_state = 222},
  [2486] = {.lex_state = 208},
  [2487] = {.lex_state = 208, .external_lex_state = 7},
  [2488] = {.lex_state = 222},
  [2489] = {.lex_state = 208},
  [2490] = {.lex_state = 222},
  [2491] = {.lex_state = 208, .external_lex_state = 7},
  [2492] = {.lex_state = 208},
  [2493] = {.lex_state = 222},
  [2494] = {.lex_state = 208},
  [2495] = {.lex_state = 208},
  [2496] = {.lex_state = 208, .external_lex_state = 7},
  [2497] = {.lex_state = 208},
  [2498] = {.lex_state = 208, .external_lex_state = 7},
  [2499] = {.lex_state = 208},
  [2500] = {.lex_state = 208},
  [2501] = {.lex_state = 222},
  [2502] = {.lex_state = 208},
  [2503] = {.lex_state = 222},
  [2504] = {.lex_state = 222},
  [2505] = {.lex_state = 208},
  [2506] = {.lex_state = 208},
  [2507] = {.lex_state = 208},
  [2508] = {.lex_state = 208, .external_lex_state = 7},
  [2509] = {.lex_state = 208, .external_lex_state = 7},
  [2510] = {.lex_state = 208, .external_lex_state = 7},
  [2511] = {.lex_state = 208, .external_lex_state = 7},
  [2512] = {.lex_state = 208, .external_lex_state = 7},
  [2513] = {.lex_state = 208, .external_lex_state = 7},
  [2514] = {.lex_state = 208, .external_lex_state = 7},
  [2515] = {.lex_state = 208, .external_lex_state = 7},
  [2516] = {.lex_state = 208, .external_lex_state = 7},
  [2517] = {.lex_state = 208, .external_lex_state = 7},
  [2518] = {.lex_state = 208, .external_lex_state = 7},
  [2519] = {.lex_state = 208, .external_lex_state = 7},
  [2520] = {.lex_state = 208, .external_lex_state = 7},
  [2521] = {.lex_state = 208, .external_lex_state = 7},
  [2522] = {.lex_state = 208, .external_lex_state = 7},
  [2523] = {.lex_state = 208, .external_lex_state = 7},
  [2524] = {.lex_state = 208, .external_lex_state = 7},
  [2525] = {.lex_state = 208, .external_lex_state = 7},
  [2526] = {.lex_state = 208, .external_lex_state = 7},
  [2527] = {.lex_state = 208, .external_lex_state = 7},
  [2528] = {.lex_state = 208, .external_lex_state = 7},
  [2529] = {.lex_state = 208, .external_lex_state = 7},
  [2530] = {.lex_state = 208, .external_lex_state = 7},
  [2531] = {.lex_state = 208, .external_lex_state = 7},
  [2532] = {.lex_state = 208, .external_lex_state = 7},
  [2533] = {.lex_state = 208, .external_lex_state = 7},
  [2534] = {.lex_state = 208, .external_lex_state = 7},
  [2535] = {.lex_state = 208, .external_lex_state = 7},
  [2536] = {.lex_state = 208, .external_lex_state = 7},
  [2537] = {.lex_state = 208, .external_lex_state = 7},
  [2538] = {.lex_state = 208, .external_lex_state = 7},
  [2539] = {.lex_state = 208, .external_lex_state = 7},
  [2540] = {.lex_state = 208, .external_lex_state = 7},
  [2541] = {.lex_state = 208, .external_lex_state = 7},
  [2542] = {.lex_state = 208, .external_lex_state = 7},
  [2543] = {.lex_state = 208, .external_lex_state = 7},
  [2544] = {.lex_state = 208, .external_lex_state = 7},
  [2545] = {.lex_state = 208, .external_lex_state = 7},
  [2546] = {.lex_state = 208, .external_lex_state = 7},
  [2547] = {.lex_state = 208, .external_lex_state = 7},
  [2548] = {.lex_state = 208, .external_lex_state = 7},
  [2549] = {.lex_state = 208, .external_lex_state = 7},
  [2550] = {.lex_state = 208, .external_lex_state = 7},
  [2551] = {.lex_state = 208, .external_lex_state = 7},
  [2552] = {.lex_state = 208, .external_lex_state = 7},
  [2553] = {.lex_state = 208, .external_lex_state = 7},
  [2554] = {.lex_state = 208, .external_lex_state = 7},
  [2555] = {.lex_state = 208, .external_lex_state = 7},
  [2556] = {.lex_state = 208, .external_lex_state = 7},
  [2557] = {.lex_state = 208, .external_lex_state = 7},
  [2558] = {.lex_state = 208, .external_lex_state = 7},
  [2559] = {.lex_state = 208, .external_lex_state = 7},
  [2560] = {.lex_state = 208, .external_lex_state = 7},
  [2561] = {.lex_state = 208, .external_lex_state = 7},
  [2562] = {.lex_state = 208, .external_lex_state = 7},
  [2563] = {.lex_state = 208, .external_lex_state = 7},
  [2564] = {.lex_state = 208, .external_lex_state = 7},
  [2565] = {.lex_state = 209, .external_lex_state = 8},
  [2566] = {.lex_state = 211},
  [2567] = {.lex_state = 211},
  [2568] = {.lex_state = 209, .external_lex_state = 8},
  [2569] = {.lex_state = 209, .external_lex_state = 8},
  [2570] = {.lex_state = 209, .external_lex_state = 8},
  [2571] = {.lex_state = 209, .external_lex_state = 8},
  [2572] = {.lex_state = 221, .external_lex_state = 8},
  [2573] = {.lex_state = 209, .external_lex_state = 8},
  [2574] = {.lex_state = 209},
  [2575] = {.lex_state = 209, .external_lex_state = 8},
  [2576] = {.lex_state = 209, .external_lex_state = 8},
  [2577] = {.lex_state = 209, .external_lex_state = 8},
  [2578] = {.lex_state = 209, .external_lex_state = 8},
  [2579] = {.lex_state = 209, .external_lex_state = 8},
  [2580] = {.lex_state = 209, .external_lex_state = 8},
  [2581] = {.lex_state = 209, .external_lex_state = 8},
  [2582] = {.lex_state = 221},
  [2583] = {.lex_state = 209, .external_lex_state = 8},
  [2584] = {.lex_state = 209, .external_lex_state = 8},
  [2585] = {.lex_state = 209, .external_lex_state = 8},
  [2586] = {.lex_state = 209, .external_lex_state = 8},
  [2587] = {.lex_state = 209, .external_lex_state = 8},
  [2588] = {.lex_state = 209, .external_lex_state = 8},
  [2589] = {.lex_state = 211},
  [2590] = {.lex_state = 209, .external_lex_state = 8},
  [2591] = {.lex_state = 209, .external_lex_state = 8},
  [2592] = {.lex_state = 209, .external_lex_state = 8},
  [2593] = {.lex_state = 209, .external_lex_state = 8},
  [2594] = {.lex_state = 209, .external_lex_state = 8},
  [2595] = {.lex_state = 209, .external_lex_state = 8},
  [2596] = {.lex_state = 209, .external_lex_state = 8},
  [2597] = {.lex_state = 211},
  [2598] = {.lex_state = 209, .external_lex_state = 8},
  [2599] = {.lex_state = 209, .external_lex_state = 8},
  [2600] = {.lex_state = 209, .external_lex_state = 8},
  [2601] = {.lex_state = 215},
  [2602] = {.lex_state = 217},
  [2603] = {.lex_state = 209, .external_lex_state = 8},
  [2604] = {.lex_state = 209, .external_lex_state = 8},
  [2605] = {.lex_state = 221, .external_lex_state = 7},
  [2606] = {.lex_state = 209, .external_lex_state = 8},
  [2607] = {.lex_state = 209, .external_lex_state = 8},
  [2608] = {.lex_state = 209, .external_lex_state = 8},
  [2609] = {.lex_state = 209, .external_lex_state = 8},
  [2610] = {.lex_state = 211},
  [2611] = {.lex_state = 209, .external_lex_state = 8},
  [2612] = {.lex_state = 209, .external_lex_state = 8},
  [2613] = {.lex_state = 209, .external_lex_state = 8},
  [2614] = {.lex_state = 209, .external_lex_state = 8},
  [2615] = {.lex_state = 209, .external_lex_state = 8},
  [2616] = {.lex_state = 209, .external_lex_state = 8},
  [2617] = {.lex_state = 209, .external_lex_state = 8},
  [2618] = {.lex_state = 209, .external_lex_state = 8},
  [2619] = {.lex_state = 209, .external_lex_state = 8},
  [2620] = {.lex_state = 209, .external_lex_state = 8},
  [2621] = {.lex_state = 209, .external_lex_state = 8},
  [2622] = {.lex_state = 211},
  [2623] = {.lex_state = 209, .external_lex_state = 8},
  [2624] = {.lex_state = 209, .external_lex_state = 8},
  [2625] = {.lex_state = 209, .external_lex_state = 8},
  [2626] = {.lex_state = 209, .external_lex_state = 8},
  [2627] = {.lex_state = 209, .external_lex_state = 8},
  [2628] = {.lex_state = 209, .external_lex_state = 8},
  [2629] = {.lex_state = 209, .external_lex_state = 8},
  [2630] = {.lex_state = 209, .external_lex_state = 8},
  [2631] = {.lex_state = 209, .external_lex_state = 8},
  [2632] = {.lex_state = 209, .external_lex_state = 8},
  [2633] = {.lex_state = 209, .external_lex_state = 8},
  [2634] = {.lex_state = 209, .external_lex_state = 8},
  [2635] = {.lex_state = 209, .external_lex_state = 8},
  [2636] = {.lex_state = 209, .external_lex_state = 8},
  [2637] = {.lex_state = 209, .external_lex_state = 8},
  [2638] = {.lex_state = 209, .external_lex_state = 8},
  [2639] = {.lex_state = 209, .external_lex_state = 8},
  [2640] = {.lex_state = 209, .external_lex_state = 8},
  [2641] = {.lex_state = 209, .external_lex_state = 8},
  [2642] = {.lex_state = 209, .external_lex_state = 8},
  [2643] = {.lex_state = 209, .external_lex_state = 8},
  [2644] = {.lex_state = 209, .external_lex_state = 8},
  [2645] = {.lex_state = 209, .external_lex_state = 8},
  [2646] = {.lex_state = 209, .external_lex_state = 8},
  [2647] = {.lex_state = 209, .external_lex_state = 8},
  [2648] = {.lex_state = 206, .external_lex_state = 8},
  [2649] = {.lex_state = 206, .external_lex_state = 8},
  [2650] = {.lex_state = 211},
  [2651] = {.lex_state = 211},
  [2652] = {.lex_state = 211},
  [2653] = {.lex_state = 211},
  [2654] = {.lex_state = 207},
  [2655] = {.lex_state = 206, .external_lex_state = 8},
  [2656] = {.lex_state = 211},
  [2657] = {.lex_state = 211},
  [2658] = {.lex_state = 211},
  [2659] = {.lex_state = 211},
  [2660] = {.lex_state = 206, .external_lex_state = 8},
  [2661] = {.lex_state = 211},
  [2662] = {.lex_state = 221, .external_lex_state = 9},
  [2663] = {.lex_state = 211},
  [2664] = {.lex_state = 206, .external_lex_state = 8},
  [2665] = {.lex_state = 211},
  [2666] = {.lex_state = 211},
  [2667] = {.lex_state = 211},
  [2668] = {.lex_state = 211},
  [2669] = {.lex_state = 211},
  [2670] = {.lex_state = 211},
  [2671] = {.lex_state = 211},
  [2672] = {.lex_state = 211},
  [2673] = {.lex_state = 211},
  [2674] = {.lex_state = 206, .external_lex_state = 8},
  [2675] = {.lex_state = 211},
  [2676] = {.lex_state = 211},
  [2677] = {.lex_state = 211},
  [2678] = {.lex_state = 211},
  [2679] = {.lex_state = 211},
  [2680] = {.lex_state = 206, .external_lex_state = 8},
  [2681] = {.lex_state = 211},
  [2682] = {.lex_state = 211},
  [2683] = {.lex_state = 211},
  [2684] = {.lex_state = 211},
  [2685] = {.lex_state = 206, .external_lex_state = 8},
  [2686] = {.lex_state = 211},
  [2687] = {.lex_state = 211},
  [2688] = {.lex_state = 211},
  [2689] = {.lex_state = 211},
  [2690] = {.lex_state = 211},
  [2691] = {.lex_state = 211},
  [2692] = {.lex_state = 206, .external_lex_state = 8},
  [2693] = {.lex_state = 211},
  [2694] = {.lex_state = 211},
  [2695] = {.lex_state = 211},
  [2696] = {.lex_state = 211},
  [2697] = {.lex_state = 209},
  [2698] = {.lex_state = 211},
  [2699] = {.lex_state = 211},
  [2700] = {.lex_state = 211},
  [2701] = {.lex_state = 211},
  [2702] = {.lex_state = 206, .external_lex_state = 8},
  [2703] = {.lex_state = 221},
  [2704] = {.lex_state = 211},
  [2705] = {.lex_state = 211},
  [2706] = {.lex_state = 211},
  [2707] = {.lex_state = 211},
  [2708] = {.lex_state = 211},
  [2709] = {.lex_state = 211},
  [2710] = {.lex_state = 211},
  [2711] = {.lex_state = 209},
  [2712] = {.lex_state = 209},
  [2713] = {.lex_state = 211},
  [2714] = {.lex_state = 211},
  [2715] = {.lex_state = 211},
  [2716] = {.lex_state = 206, .external_lex_state = 8},
  [2717] = {.lex_state = 206, .external_lex_state = 8},
  [2718] = {.lex_state = 211},
  [2719] = {.lex_state = 211},
  [2720] = {.lex_state = 211},
  [2721] = {.lex_state = 211},
  [2722] = {.lex_state = 206, .external_lex_state = 8},
  [2723] = {.lex_state = 211},
  [2724] = {.lex_state = 221, .external_lex_state = 10},
  [2725] = {.lex_state = 209},
  [2726] = {.lex_state = 211},
  [2727] = {.lex_state = 211},
  [2728] = {.lex_state = 211},
  [2729] = {.lex_state = 211},
  [2730] = {.lex_state = 211},
  [2731] = {.lex_state = 211},
  [2732] = {.lex_state = 211},
  [2733] = {.lex_state = 211},
  [2734] = {.lex_state = 211},
  [2735] = {.lex_state = 206, .external_lex_state = 8},
  [2736] = {.lex_state = 206, .external_lex_state = 8},
  [2737] = {.lex_state = 206, .external_lex_state = 8},
  [2738] = {.lex_state = 206, .external_lex_state = 7},
  [2739] = {.lex_state = 206, .external_lex_state = 8},
  [2740] = {.lex_state = 215},
  [2741] = {.lex_state = 217},
  [2742] = {.lex_state = 206, .external_lex_state = 8},
  [2743] = {.lex_state = 206, .external_lex_state = 8},
  [2744] = {.lex_state = 221},
  [2745] = {.lex_state = 221},
  [2746] = {.lex_state = 206, .external_lex_state = 8},
  [2747] = {.lex_state = 221},
  [2748] = {.lex_state = 221},
  [2749] = {.lex_state = 206, .external_lex_state = 8},
  [2750] = {.lex_state = 206, .external_lex_state = 8},
  [2751] = {.lex_state = 206, .external_lex_state = 7},
  [2752] = {.lex_state = 206, .external_lex_state = 8},
  [2753] = {.lex_state = 206, .external_lex_state = 8},
  [2754] = {.lex_state = 221},
  [2755] = {.lex_state = 221},
  [2756] = {.lex_state = 221},
  [2757] = {.lex_state = 206, .external_lex_state = 8},
  [2758] = {.lex_state = 206, .external_lex_state = 8},
  [2759] = {.lex_state = 206, .external_lex_state = 8},
  [2760] = {.lex_state = 206, .external_lex_state = 8},
  [2761] = {.lex_state = 221},
  [2762] = {.lex_state = 221},
  [2763] = {.lex_state = 206, .external_lex_state = 8},
  [2764] = {.lex_state = 221},
  [2765] = {.lex_state = 209},
  [2766] = {.lex_state = 206, .external_lex_state = 8},
  [2767] = {.lex_state = 209},
  [2768] = {.lex_state = 217},
  [2769] = {.lex_state = 221},
  [2770] = {.lex_state = 221},
  [2771] = {.lex_state = 209},
  [2772] = {.lex_state = 206, .external_lex_state = 8},
  [2773] = {.lex_state = 206, .external_lex_state = 8},
  [2774] = {.lex_state = 206, .external_lex_state = 8},
  [2775] = {.lex_state = 206, .external_lex_state = 8},
  [2776] = {.lex_state = 206, .external_lex_state = 8},
  [2777] = {.lex_state = 221},
  [2778] = {.lex_state = 206, .external_lex_state = 8},
  [2779] = {.lex_state = 215},
  [2780] = {.lex_state = 221},
  [2781] = {.lex_state = 206, .external_lex_state = 8},
  [2782] = {.lex_state = 209},
  [2783] = {.lex_state = 206, .external_lex_state = 8},
  [2784] = {.lex_state = 209},
  [2785] = {.lex_state = 209},
  [2786] = {.lex_state = 206, .external_lex_state = 8},
  [2787] = {.lex_state = 206, .external_lex_state = 8},
  [2788] = {.lex_state = 206, .external_lex_state = 8},
  [2789] = {.lex_state = 206, .external_lex_state = 7},
  [2790] = {.lex_state = 209},
  [2791] = {.lex_state = 206, .external_lex_state = 8},
  [2792] = {.lex_state = 206, .external_lex_state = 8},
  [2793] = {.lex_state = 206, .external_lex_state = 8},
  [2794] = {.lex_state = 206, .external_lex_state = 8},
  [2795] = {.lex_state = 217},
  [2796] = {.lex_state = 215},
  [2797] = {.lex_state = 206, .external_lex_state = 8},
  [2798] = {.lex_state = 206, .external_lex_state = 8},
  [2799] = {.lex_state = 206, .external_lex_state = 8},
  [2800] = {.lex_state = 206, .external_lex_state = 8},
  [2801] = {.lex_state = 206, .external_lex_state = 8},
  [2802] = {.lex_state = 206, .external_lex_state = 8},
  [2803] = {.lex_state = 206, .external_lex_state = 8},
  [2804] = {.lex_state = 206, .external_lex_state = 8},
  [2805] = {.lex_state = 206, .external_lex_state = 8},
  [2806] = {.lex_state = 206, .external_lex_state = 8},
  [2807] = {.lex_state = 209},
  [2808] = {.lex_state = 217},
  [2809] = {.lex_state = 206, .external_lex_state = 8},
  [2810] = {.lex_state = 221},
  [2811] = {.lex_state = 221},
  [2812] = {.lex_state = 206, .external_lex_state = 7},
  [2813] = {.lex_state = 215},
  [2814] = {.lex_state = 206, .external_lex_state = 8},
  [2815] = {.lex_state = 206, .external_lex_state = 8},
  [2816] = {.lex_state = 206, .external_lex_state = 8},
  [2817] = {.lex_state = 209},
  [2818] = {.lex_state = 206, .external_lex_state = 8},
  [2819] = {.lex_state = 206, .external_lex_state = 8},
  [2820] = {.lex_state = 206, .external_lex_state = 8},
  [2821] = {.lex_state = 206, .external_lex_state = 8},
  [2822] = {.lex_state = 206, .external_lex_state = 8},
  [2823] = {.lex_state = 206, .external_lex_state = 8},
  [2824] = {.lex_state = 206, .external_lex_state = 8},
  [2825] = {.lex_state = 206, .external_lex_state = 8},
  [2826] = {.lex_state = 206, .external_lex_state = 8},
  [2827] = {.lex_state = 206, .external_lex_state = 8},
  [2828] = {.lex_state = 206, .external_lex_state = 8},
  [2829] = {.lex_state = 209},
  [2830] = {.lex_state = 215},
  [2831] = {.lex_state = 206, .external_lex_state = 7},
  [2832] = {.lex_state = 206, .external_lex_state = 7},
  [2833] = {.lex_state = 206, .external_lex_state = 7},
  [2834] = {.lex_state = 206, .external_lex_state = 7},
  [2835] = {.lex_state = 206, .external_lex_state = 7},
  [2836] = {.lex_state = 206, .external_lex_state = 7},
  [2837] = {.lex_state = 209},
  [2838] = {.lex_state = 209},
  [2839] = {.lex_state = 209},
  [2840] = {.lex_state = 209},
  [2841] = {.lex_state = 209},
  [2842] = {.lex_state = 209},
  [2843] = {.lex_state = 209},
  [2844] = {.lex_state = 209},
  [2845] = {.lex_state = 209},
  [2846] = {.lex_state = 206, .external_lex_state = 7},
  [2847] = {.lex_state = 209},
  [2848] = {.lex_state = 215},
  [2849] = {.lex_state = 209},
  [2850] = {.lex_state = 206, .external_lex_state = 7},
  [2851] = {.lex_state = 215},
  [2852] = {.lex_state = 209},
  [2853] = {.lex_state = 215},
  [2854] = {.lex_state = 209},
  [2855] = {.lex_state = 209},
  [2856] = {.lex_state = 209},
  [2857] = {.lex_state = 209},
  [2858] = {.lex_state = 209},
  [2859] = {.lex_state = 209},
  [2860] = {.lex_state = 215},
  [2861] = {.lex_state = 209},
  [2862] = {.lex_state = 217},
  [2863] = {.lex_state = 209},
  [2864] = {.lex_state = 209},
  [2865] = {.lex_state = 209},
  [2866] = {.lex_state = 209},
  [2867] = {.lex_state = 209},
  [2868] = {.lex_state = 209},
  [2869] = {.lex_state = 209},
  [2870] = {.lex_state = 209},
  [2871] = {.lex_state = 209},
  [2872] = {.lex_state = 215},
  [2873] = {.lex_state = 209},
  [2874] = {.lex_state = 209},
  [2875] = {.lex_state = 217},
  [2876] = {.lex_state = 221},
  [2877] = {.lex_state = 209},
  [2878] = {.lex_state = 206, .external_lex_state = 7},
  [2879] = {.lex_state = 209},
  [2880] = {.lex_state = 209},
  [2881] = {.lex_state = 209},
  [2882] = {.lex_state = 215},
  [2883] = {.lex_state = 209},
  [2884] = {.lex_state = 217},
  [2885] = {.lex_state = 217},
  [2886] = {.lex_state = 209},
  [2887] = {.lex_state = 209},
  [2888] = {.lex_state = 209},
  [2889] = {.lex_state = 209},
  [2890] = {.lex_state = 209},
  [2891] = {.lex_state = 209},
  [2892] = {.lex_state = 209},
  [2893] = {.lex_state = 209},
  [2894] = {.lex_state = 209},
  [2895] = {.lex_state = 209},
  [2896] = {.lex_state = 209},
  [2897] = {.lex_state = 209},
  [2898] = {.lex_state = 209},
  [2899] = {.lex_state = 209},
  [2900] = {.lex_state = 209},
  [2901] = {.lex_state = 215},
  [2902] = {.lex_state = 217},
  [2903] = {.lex_state = 209},
  [2904] = {.lex_state = 209},
  [2905] = {.lex_state = 209},
  [2906] = {.lex_state = 209},
  [2907] = {.lex_state = 217},
  [2908] = {.lex_state = 217},
  [2909] = {.lex_state = 209},
  [2910] = {.lex_state = 215},
  [2911] = {.lex_state = 217},
  [2912] = {.lex_state = 217},
  [2913] = {.lex_state = 209},
  [2914] = {.lex_state = 215},
  [2915] = {.lex_state = 215},
  [2916] = {.lex_state = 215},
  [2917] = {.lex_state = 206, .external_lex_state = 10},
  [2918] = {.lex_state = 206, .external_lex_state = 7},
  [2919] = {.lex_state = 217},
  [2920] = {.lex_state = 215},
  [2921] = {.lex_state = 217},
  [2922] = {.lex_state = 206, .external_lex_state = 7},
  [2923] = {.lex_state = 217},
  [2924] = {.lex_state = 217},
  [2925] = {.lex_state = 217},
  [2926] = {.lex_state = 206, .external_lex_state = 7},
  [2927] = {.lex_state = 217},
  [2928] = {.lex_state = 206, .external_lex_state = 7},
  [2929] = {.lex_state = 206, .external_lex_state = 10},
  [2930] = {.lex_state = 217},
  [2931] = {.lex_state = 217},
  [2932] = {.lex_state = 217},
  [2933] = {.lex_state = 215},
  [2934] = {.lex_state = 215},
  [2935] = {.lex_state = 215},
  [2936] = {.lex_state = 215},
  [2937] = {.lex_state = 217},
  [2938] = {.lex_state = 217},
  [2939] = {.lex_state = 215},
  [2940] = {.lex_state = 215},
  [2941] = {.lex_state = 215},
  [2942] = {.lex_state = 206, .external_lex_state = 7},
  [2943] = {.lex_state = 217},
  [2944] = {.lex_state = 217},
  [2945] = {.lex_state = 217},
  [2946] = {.lex_state = 215},
  [2947] = {.lex_state = 217},
  [2948] = {.lex_state = 217},
  [2949] = {.lex_state = 217},
  [2950] = {.lex_state = 217},
  [2951] = {.lex_state = 215},
  [2952] = {.lex_state = 217},
  [2953] = {.lex_state = 217},
  [2954] = {.lex_state = 217},
  [2955] = {.lex_state = 217},
  [2956] = {.lex_state = 217},
  [2957] = {.lex_state = 217},
  [2958] = {.lex_state = 205},
  [2959] = {.lex_state = 217},
  [2960] = {.lex_state = 206, .external_lex_state = 10},
  [2961] = {.lex_state = 217},
  [2962] = {.lex_state = 206, .external_lex_state = 7},
  [2963] = {.lex_state = 217},
  [2964] = {.lex_state = 217},
  [2965] = {.lex_state = 217},
  [2966] = {.lex_state = 217},
  [2967] = {.lex_state = 217},
  [2968] = {.lex_state = 217},
  [2969] = {.lex_state = 217},
  [2970] = {.lex_state = 217},
  [2971] = {.lex_state = 217},
  [2972] = {.lex_state = 217},
  [2973] = {.lex_state = 217},
  [2974] = {.lex_state = 217},
  [2975] = {.lex_state = 217},
  [2976] = {.lex_state = 217},
  [2977] = {.lex_state = 217},
  [2978] = {.lex_state = 217},
  [2979] = {.lex_state = 217},
  [2980] = {.lex_state = 217},
  [2981] = {.lex_state = 215},
  [2982] = {.lex_state = 206, .external_lex_state = 7},
  [2983] = {.lex_state = 206, .external_lex_state = 7},
  [2984] = {.lex_state = 215},
  [2985] = {.lex_state = 215},
  [2986] = {.lex_state = 215},
  [2987] = {.lex_state = 217},
  [2988] = {.lex_state = 215},
  [2989] = {.lex_state = 215},
  [2990] = {.lex_state = 217},
  [2991] = {.lex_state = 217},
  [2992] = {.lex_state = 215},
  [2993] = {.lex_state = 217},
  [2994] = {.lex_state = 217},
  [2995] = {.lex_state = 206, .external_lex_state = 7},
  [2996] = {.lex_state = 215},
  [2997] = {.lex_state = 215},
  [2998] = {.lex_state = 217},
  [2999] = {.lex_state = 217},
  [3000] = {.lex_state = 217},
  [3001] = {.lex_state = 215},
  [3002] = {.lex_state = 215},
  [3003] = {.lex_state = 215},
  [3004] = {.lex_state = 215},
  [3005] = {.lex_state = 206, .external_lex_state = 7},
  [3006] = {.lex_state = 215},
  [3007] = {.lex_state = 215},
  [3008] = {.lex_state = 215},
  [3009] = {.lex_state = 206, .external_lex_state = 7},
  [3010] = {.lex_state = 217},
  [3011] = {.lex_state = 215},
  [3012] = {.lex_state = 206, .external_lex_state = 7},
  [3013] = {.lex_state = 206, .external_lex_state = 7},
  [3014] = {.lex_state = 206, .external_lex_state = 7},
  [3015] = {.lex_state = 217},
  [3016] = {.lex_state = 215},
  [3017] = {.lex_state = 215},
  [3018] = {.lex_state = 215},
  [3019] = {.lex_state = 215},
  [3020] = {.lex_state = 217},
  [3021] = {.lex_state = 206, .external_lex_state = 7},
  [3022] = {.lex_state = 206, .external_lex_state = 9},
  [3023] = {.lex_state = 206, .external_lex_state = 7},
  [3024] = {.lex_state = 206, .external_lex_state = 10},
  [3025] = {.lex_state = 206, .external_lex_state = 7},
  [3026] = {.lex_state = 215},
  [3027] = {.lex_state = 217},
  [3028] = {.lex_state = 215},
  [3029] = {.lex_state = 215},
  [3030] = {.lex_state = 215},
  [3031] = {.lex_state = 215},
  [3032] = {.lex_state = 215},
  [3033] = {.lex_state = 215},
  [3034] = {.lex_state = 215},
  [3035] = {.lex_state = 215},
  [3036] = {.lex_state = 215},
  [3037] = {.lex_state = 206, .external_lex_state = 7},
  [3038] = {.lex_state = 206, .external_lex_state = 7},
  [3039] = {.lex_state = 215},
  [3040] = {.lex_state = 215},
  [3041] = {.lex_state = 215},
  [3042] = {.lex_state = 215},
  [3043] = {.lex_state = 206, .external_lex_state = 7},
  [3044] = {.lex_state = 206, .external_lex_state = 7},
  [3045] = {.lex_state = 206, .external_lex_state = 7},
  [3046] = {.lex_state = 215},
  [3047] = {.lex_state = 215},
  [3048] = {.lex_state = 206, .external_lex_state = 9},
  [3049] = {.lex_state = 206, .external_lex_state = 7},
  [3050] = {.lex_state = 206, .external_lex_state = 7},
  [3051] = {.lex_state = 217},
  [3052] = {.lex_state = 206, .external_lex_state = 7},
  [3053] = {.lex_state = 206, .external_lex_state = 7},
  [3054] = {.lex_state = 206, .external_lex_state = 7},
  [3055] = {.lex_state = 215},
  [3056] = {.lex_state = 206, .external_lex_state = 7},
  [3057] = {.lex_state = 206, .external_lex_state = 7},
  [3058] = {.lex_state = 206, .external_lex_state = 7},
  [3059] = {.lex_state = 206, .external_lex_state = 7},
  [3060] = {.lex_state = 206, .external_lex_state = 7},
  [3061] = {.lex_state = 206, .external_lex_state = 7},
  [3062] = {.lex_state = 206, .external_lex_state = 7},
  [3063] = {.lex_state = 206, .external_lex_state = 7},
  [3064] = {.lex_state = 206, .external_lex_state = 9},
  [3065] = {.lex_state = 215},
  [3066] = {.lex_state = 206, .external_lex_state = 7},
  [3067] = {.lex_state = 206, .external_lex_state = 7},
  [3068] = {.lex_state = 206, .external_lex_state = 7},
  [3069] = {.lex_state = 215},
  [3070] = {.lex_state = 206, .external_lex_state = 7},
  [3071] = {.lex_state = 206, .external_lex_state = 7},
  [3072] = {.lex_state = 206, .external_lex_state = 7},
  [3073] = {.lex_state = 206, .external_lex_state = 7},
  [3074] = {.lex_state = 206, .external_lex_state = 7},
  [3075] = {.lex_state = 206, .external_lex_state = 7},
  [3076] = {.lex_state = 206, .external_lex_state = 7},
  [3077] = {.lex_state = 206, .external_lex_state = 7},
  [3078] = {.lex_state = 206, .external_lex_state = 7},
  [3079] = {.lex_state = 206, .external_lex_state = 7},
  [3080] = {.lex_state = 206, .external_lex_state = 7},
  [3081] = {.lex_state = 215},
  [3082] = {.lex_state = 215},
  [3083] = {.lex_state = 206, .external_lex_state = 7},
  [3084] = {.lex_state = 206, .external_lex_state = 7},
  [3085] = {.lex_state = 206, .external_lex_state = 7},
  [3086] = {.lex_state = 215},
  [3087] = {.lex_state = 215},
  [3088] = {.lex_state = 206, .external_lex_state = 7},
  [3089] = {.lex_state = 206, .external_lex_state = 7},
  [3090] = {.lex_state = 206, .external_lex_state = 7},
  [3091] = {.lex_state = 206, .external_lex_state = 9},
  [3092] = {.lex_state = 206, .external_lex_state = 7},
  [3093] = {.lex_state = 206, .external_lex_state = 7},
  [3094] = {.lex_state = 206, .external_lex_state = 9},
  [3095] = {.lex_state = 206, .external_lex_state = 9},
  [3096] = {.lex_state = 206, .external_lex_state = 9},
  [3097] = {.lex_state = 206, .external_lex_state = 9},
  [3098] = {.lex_state = 206, .external_lex_state = 9},
  [3099] = {.lex_state = 206, .external_lex_state = 9},
  [3100] = {.lex_state = 206, .external_lex_state = 10},
  [3101] = {.lex_state = 206, .external_lex_state = 10},
  [3102] = {.lex_state = 206, .external_lex_state = 10},
  [3103] = {.lex_state = 206, .external_lex_state = 9},
  [3104] = {.lex_state = 206, .external_lex_state = 10},
  [3105] = {.lex_state = 206, .external_lex_state = 10},
  [3106] = {.lex_state = 206, .external_lex_state = 10},
  [3107] = {.lex_state = 206, .external_lex_state = 9},
  [3108] = {.lex_state = 206, .external_lex_state = 9},
  [3109] = {.lex_state = 206, .external_lex_state = 10},
  [3110] = {.lex_state = 206, .external_lex_state = 10},
  [3111] = {.lex_state = 206, .external_lex_state = 10},
  [3112] = {.lex_state = 206, .external_lex_state = 9},
  [3113] = {.lex_state = 206, .external_lex_state = 9},
  [3114] = {.lex_state = 206, .external_lex_state = 10},
  [3115] = {.lex_state = 206, .external_lex_state = 9},
  [3116] = {.lex_state = 206, .external_lex_state = 9},
  [3117] = {.lex_state = 206, .external_lex_state = 9},
  [3118] = {.lex_state = 206, .external_lex_state = 9},
  [3119] = {.lex_state = 206, .external_lex_state = 9},
  [3120] = {.lex_state = 206, .external_lex_state = 9},
  [3121] = {.lex_state = 206, .external_lex_state = 10},
  [3122] = {.lex_state = 206, .external_lex_state = 9},
  [3123] = {.lex_state = 206, .external_lex_state = 9},
  [3124] = {.lex_state = 206, .external_lex_state = 9},
  [3125] = {.lex_state = 206, .external_lex_state = 9},
  [3126] = {.lex_state = 206, .external_lex_state = 9},
  [3127] = {.lex_state = 206, .external_lex_state = 9},
  [3128] = {.lex_state = 206, .external_lex_state = 9},
  [3129] = {.lex_state = 206, .external_lex_state = 9},
  [3130] = {.lex_state = 206, .external_lex_state = 9},
  [3131] = {.lex_state = 206, .external_lex_state = 9},
  [3132] = {.lex_state = 206, .external_lex_state = 9},
  [3133] = {.lex_state = 206, .external_lex_state = 9},
  [3134] = {.lex_state = 206, .external_lex_state = 9},
  [3135] = {.lex_state = 206, .external_lex_state = 9},
  [3136] = {.lex_state = 206, .external_lex_state = 10},
  [3137] = {.lex_state = 206, .external_lex_state = 10},
  [3138] = {.lex_state = 206, .external_lex_state = 9},
  [3139] = {.lex_state = 206, .external_lex_state = 9},
  [3140] = {.lex_state = 206, .external_lex_state = 9},
  [3141] = {.lex_state = 206, .external_lex_state = 9},
  [3142] = {.lex_state = 206, .external_lex_state = 9},
  [3143] = {.lex_state = 206, .external_lex_state = 9},
  [3144] = {.lex_state = 206, .external_lex_state = 9},
  [3145] = {.lex_state = 206, .external_lex_state = 9},
  [3146] = {.lex_state = 206, .external_lex_state = 9},
  [3147] = {.lex_state = 206, .external_lex_state = 9},
  [3148] = {.lex_state = 206, .external_lex_state = 10},
  [3149] = {.lex_state = 206, .external_lex_state = 10},
  [3150] = {.lex_state = 206, .external_lex_state = 10},
  [3151] = {.lex_state = 206, .external_lex_state = 10},
  [3152] = {.lex_state = 206, .external_lex_state = 10},
  [3153] = {.lex_state = 206, .external_lex_state = 10},
  [3154] = {.lex_state = 206, .external_lex_state = 10},
  [3155] = {.lex_state = 206, .external_lex_state = 9},
  [3156] = {.lex_state = 206, .external_lex_state = 10},
  [3157] = {.lex_state = 206, .external_lex_state = 10},
  [3158] = {.lex_state = 206, .external_lex_state = 10},
  [3159] = {.lex_state = 206, .external_lex_state = 10},
  [3160] = {.lex_state = 206, .external_lex_state = 10},
  [3161] = {.lex_state = 206, .external_lex_state = 10},
  [3162] = {.lex_state = 206, .external_lex_state = 10},
  [3163] = {.lex_state = 206, .external_lex_state = 9},
  [3164] = {.lex_state = 206, .external_lex_state = 9},
  [3165] = {.lex_state = 206, .external_lex_state = 9},
  [3166] = {.lex_state = 206, .external_lex_state = 10},
  [3167] = {.lex_state = 206, .external_lex_state = 10},
  [3168] = {.lex_state = 206, .external_lex_state = 9},
  [3169] = {.lex_state = 206, .external_lex_state = 10},
  [3170] = {.lex_state = 206, .external_lex_state = 10},
  [3171] = {.lex_state = 206, .external_lex_state = 9},
  [3172] = {.lex_state = 206, .external_lex_state = 9},
  [3173] = {.lex_state = 206, .external_lex_state = 10},
  [3174] = {.lex_state = 206, .external_lex_state = 10},
  [3175] = {.lex_state = 206, .external_lex_state = 10},
  [3176] = {.lex_state = 206, .external_lex_state = 10},
  [3177] = {.lex_state = 206, .external_lex_state = 10},
  [3178] = {.lex_state = 206, .external_lex_state = 10},
  [3179] = {.lex_state = 206, .external_lex_state = 10},
  [3180] = {.lex_state = 206, .external_lex_state = 9},
  [3181] = {.lex_state = 206, .external_lex_state = 10},
  [3182] = {.lex_state = 206, .external_lex_state = 9},
  [3183] = {.lex_state = 206, .external_lex_state = 9},
  [3184] = {.lex_state = 206, .external_lex_state = 9},
  [3185] = {.lex_state = 206, .external_lex_state = 9},
  [3186] = {.lex_state = 206, .external_lex_state = 10},
  [3187] = {.lex_state = 206, .external_lex_state = 10},
  [3188] = {.lex_state = 206, .external_lex_state = 10},
  [3189] = {.lex_state = 206, .external_lex_state = 10},
  [3190] = {.lex_state = 206, .external_lex_state = 10},
  [3191] = {.lex_state = 206, .external_lex_state = 10},
  [3192] = {.lex_state = 206, .external_lex_state = 10},
  [3193] = {.lex_state = 206, .external_lex_state = 10},
  [3194] = {.lex_state = 206, .external_lex_state = 9},
  [3195] = {.lex_state = 206, .external_lex_state = 9},
  [3196] = {.lex_state = 206, .external_lex_state = 9},
  [3197] = {.lex_state = 206, .external_lex_state = 9},
  [3198] = {.lex_state = 206, .external_lex_state = 10},
  [3199] = {.lex_state = 206, .external_lex_state = 9},
  [3200] = {.lex_state = 206, .external_lex_state = 9},
  [3201] = {.lex_state = 206, .external_lex_state = 9},
  [3202] = {.lex_state = 206, .external_lex_state = 9},
  [3203] = {.lex_state = 206, .external_lex_state = 9},
  [3204] = {.lex_state = 206, .external_lex_state = 9},
  [3205] = {.lex_state = 206, .external_lex_state = 9},
  [3206] = {.lex_state = 206, .external_lex_state = 9},
  [3207] = {.lex_state = 206, .external_lex_state = 10},
  [3208] = {.lex_state = 206, .external_lex_state = 10},
  [3209] = {.lex_state = 206, .external_lex_state = 10},
  [3210] = {.lex_state = 206, .external_lex_state = 10},
  [3211] = {.lex_state = 206, .external_lex_state = 10},
  [3212] = {.lex_state = 206, .external_lex_state = 10},
  [3213] = {.lex_state = 206, .external_lex_state = 10},
  [3214] = {.lex_state = 206, .external_lex_state = 10},
  [3215] = {.lex_state = 206, .external_lex_state = 10},
  [3216] = {.lex_state = 206, .external_lex_state = 10},
  [3217] = {.lex_state = 206, .external_lex_state = 9},
  [3218] = {.lex_state = 206, .external_lex_state = 10},
  [3219] = {.lex_state = 206, .external_lex_state = 10},
  [3220] = {.lex_state = 206, .external_lex_state = 10},
  [3221] = {.lex_state = 206, .external_lex_state = 10},
  [3222] = {.lex_state = 206, .external_lex_state = 10},
  [3223] = {.lex_state = 206, .external_lex_state = 10},
  [3224] = {.lex_state = 206, .external_lex_state = 10},
  [3225] = {.lex_state = 206, .external_lex_state = 10},
  [3226] = {.lex_state = 223},
  [3227] = {.lex_state = 223},
  [3228] = {.lex_state = 223},
  [3229] = {.lex_state = 223},
  [3230] = {.lex_state = 223},
  [3231] = {.lex_state = 223},
  [3232] = {.lex_state = 223},
  [3233] = {.lex_state = 223},
  [3234] = {.lex_state = 223},
  [3235] = {.lex_state = 223},
  [3236] = {.lex_state = 223},
  [3237] = {.lex_state = 223},
  [3238] = {.lex_state = 223},
  [3239] = {.lex_state = 223},
  [3240] = {.lex_state = 223},
  [3241] = {.lex_state = 223},
  [3242] = {.lex_state = 223},
  [3243] = {.lex_state = 223},
  [3244] = {.lex_state = 223},
  [3245] = {.lex_state = 223},
  [3246] = {.lex_state = 223},
  [3247] = {.lex_state = 223},
  [3248] = {.lex_state = 223},
  [3249] = {.lex_state = 223},
  [3250] = {.lex_state = 223},
  [3251] = {.lex_state = 223},
  [3252] = {.lex_state = 223},
  [3253] = {.lex_state = 223},
  [3254] = {.lex_state = 223},
  [3255] = {.lex_state = 223},
  [3256] = {.lex_state = 223},
  [3257] = {.lex_state = 223},
  [3258] = {.lex_state = 223},
  [3259] = {.lex_state = 223},
  [3260] = {.lex_state = 223},
  [3261] = {.lex_state = 223},
  [3262] = {.lex_state = 223},
  [3263] = {.lex_state = 223},
  [3264] = {.lex_state = 223},
  [3265] = {.lex_state = 223},
  [3266] = {.lex_state = 223},
  [3267] = {.lex_state = 223},
  [3268] = {.lex_state = 223},
  [3269] = {.lex_state = 223},
  [3270] = {.lex_state = 223},
  [3271] = {.lex_state = 223},
  [3272] = {.lex_state = 223},
  [3273] = {.lex_state = 223},
  [3274] = {.lex_state = 223},
  [3275] = {.lex_state = 223},
  [3276] = {.lex_state = 223},
  [3277] = {.lex_state = 223},
  [3278] = {.lex_state = 223},
  [3279] = {.lex_state = 223},
  [3280] = {.lex_state = 223},
  [3281] = {.lex_state = 223},
  [3282] = {.lex_state = 223},
  [3283] = {.lex_state = 223},
  [3284] = {.lex_state = 223},
  [3285] = {.lex_state = 223},
  [3286] = {.lex_state = 223},
  [3287] = {.lex_state = 223},
  [3288] = {.lex_state = 223},
  [3289] = {.lex_state = 223},
  [3290] = {.lex_state = 223},
  [3291] = {.lex_state = 223},
  [3292] = {.lex_state = 223},
  [3293] = {.lex_state = 223},
  [3294] = {.lex_state = 223},
  [3295] = {.lex_state = 223},
  [3296] = {.lex_state = 223},
  [3297] = {.lex_state = 223, .external_lex_state = 6},
  [3298] = {.lex_state = 223, .external_lex_state = 6},
  [3299] = {.lex_state = 223, .external_lex_state = 6},
  [3300] = {.lex_state = 223},
  [3301] = {.lex_state = 223},
  [3302] = {.lex_state = 223},
  [3303] = {.lex_state = 223},
  [3304] = {.lex_state = 223},
  [3305] = {.lex_state = 223},
  [3306] = {.lex_state = 223},
  [3307] = {.lex_state = 225},
  [3308] = {.lex_state = 223},
  [3309] = {.lex_state = 223},
  [3310] = {.lex_state = 223},
  [3311] = {.lex_state = 223},
  [3312] = {.lex_state = 223},
  [3313] = {.lex_state = 223},
  [3314] = {.lex_state = 223},
  [3315] = {.lex_state = 223},
  [3316] = {.lex_state = 223},
  [3317] = {.lex_state = 223},
  [3318] = {.lex_state = 223},
  [3319] = {.lex_state = 223},
  [3320] = {.lex_state = 223},
  [3321] = {.lex_state = 223},
  [3322] = {.lex_state = 223},
  [3323] = {.lex_state = 223},
  [3324] = {.lex_state = 223},
  [3325] = {.lex_state = 223},
  [3326] = {.lex_state = 223},
  [3327] = {.lex_state = 223},
  [3328] = {.lex_state = 223},
  [3329] = {.lex_state = 223},
  [3330] = {.lex_state = 223},
  [3331] = {.lex_state = 223},
  [3332] = {.lex_state = 223},
  [3333] = {.lex_state = 223},
  [3334] = {.lex_state = 223},
  [3335] = {.lex_state = 223},
  [3336] = {.lex_state = 223},
  [3337] = {.lex_state = 223},
  [3338] = {.lex_state = 223},
  [3339] = {.lex_state = 223},
  [3340] = {.lex_state = 223},
  [3341] = {.lex_state = 223},
  [3342] = {.lex_state = 223},
  [3343] = {.lex_state = 223},
  [3344] = {.lex_state = 223},
  [3345] = {.lex_state = 223},
  [3346] = {.lex_state = 223},
  [3347] = {.lex_state = 223},
  [3348] = {.lex_state = 223},
  [3349] = {.lex_state = 223},
  [3350] = {.lex_state = 223},
  [3351] = {.lex_state = 223},
  [3352] = {.lex_state = 223},
  [3353] = {.lex_state = 223},
  [3354] = {.lex_state = 223},
  [3355] = {.lex_state = 223},
  [3356] = {.lex_state = 223},
  [3357] = {.lex_state = 223},
  [3358] = {.lex_state = 223},
  [3359] = {.lex_state = 223},
  [3360] = {.lex_state = 223},
  [3361] = {.lex_state = 201},
  [3362] = {.lex_state = 223},
  [3363] = {.lex_state = 223},
  [3364] = {.lex_state = 223},
  [3365] = {.lex_state = 223},
  [3366] = {.lex_state = 223},
  [3367] = {.lex_state = 201},
  [3368] = {.lex_state = 223},
  [3369] = {.lex_state = 223},
  [3370] = {.lex_state = 223},
  [3371] = {.lex_state = 223},
  [3372] = {.lex_state = 223},
  [3373] = {.lex_state = 223},
  [3374] = {.lex_state = 201},
  [3375] = {.lex_state = 201},
  [3376] = {.lex_state = 201},
  [3377] = {.lex_state = 223},
  [3378] = {.lex_state = 201},
  [3379] = {.lex_state = 201},
  [3380] = {.lex_state = 201},
  [3381] = {.lex_state = 201},
  [3382] = {.lex_state = 201},
  [3383] = {.lex_state = 201},
  [3384] = {.lex_state = 201},
  [3385] = {.lex_state = 201},
  [3386] = {.lex_state = 223},
  [3387] = {.lex_state = 201},
  [3388] = {.lex_state = 201},
  [3389] = {.lex_state = 201},
  [3390] = {.lex_state = 201},
  [3391] = {.lex_state = 201},
  [3392] = {.lex_state = 201},
  [3393] = {.lex_state = 223},
  [3394] = {.lex_state = 223},
  [3395] = {.lex_state = 223},
  [3396] = {.lex_state = 223},
  [3397] = {.lex_state = 223},
  [3398] = {.lex_state = 223},
  [3399] = {.lex_state = 223},
  [3400] = {.lex_state = 223},
  [3401] = {.lex_state = 201},
  [3402] = {.lex_state = 201},
  [3403] = {.lex_state = 223},
  [3404] = {.lex_state = 223},
  [3405] = {.lex_state = 223},
  [3406] = {.lex_state = 223},
  [3407] = {.lex_state = 223},
  [3408] = {.lex_state = 223},
  [3409] = {.lex_state = 223},
  [3410] = {.lex_state = 223},
  [3411] = {.lex_state = 223},
  [3412] = {.lex_state = 223},
  [3413] = {.lex_state = 223},
  [3414] = {.lex_state = 201},
  [3415] = {.lex_state = 223},
  [3416] = {.lex_state = 223},
  [3417] = {.lex_state = 223},
  [3418] = {.lex_state = 223},
  [3419] = {.lex_state = 223},
  [3420] = {.lex_state = 223},
  [3421] = {.lex_state = 223},
  [3422] = {.lex_state = 223},
  [3423] = {.lex_state = 223},
  [3424] = {.lex_state = 223},
  [3425] = {.lex_state = 223},
  [3426] = {.lex_state = 223},
  [3427] = {.lex_state = 223},
  [3428] = {.lex_state = 223},
  [3429] = {.lex_state = 223},
  [3430] = {.lex_state = 223, .external_lex_state = 7},
  [3431] = {.lex_state = 223, .external_lex_state = 7},
  [3432] = {.lex_state = 223, .external_lex_state = 7},
  [3433] = {.lex_state = 223},
  [3434] = {.lex_state = 201},
  [3435] = {.lex_state = 223},
  [3436] = {.lex_state = 223},
  [3437] = {.lex_state = 223},
  [3438] = {.lex_state = 223},
  [3439] = {.lex_state = 223},
  [3440] = {.lex_state = 223},
  [3441] = {.lex_state = 223},
  [3442] = {.lex_state = 223},
  [3443] = {.lex_state = 223},
  [3444] = {.lex_state = 223},
  [3445] = {.lex_state = 223},
  [3446] = {.lex_state = 227},
  [3447] = {.lex_state = 227},
  [3448] = {.lex_state = 223},
  [3449] = {.lex_state = 225},
  [3450] = {.lex_state = 223},
  [3451] = {.lex_state = 223},
  [3452] = {.lex_state = 223},
  [3453] = {.lex_state = 225},
  [3454] = {.lex_state = 223},
  [3455] = {.lex_state = 223},
  [3456] = {.lex_state = 223},
  [3457] = {.lex_state = 223},
  [3458] = {.lex_state = 223},
  [3459] = {.lex_state = 223},
  [3460] = {.lex_state = 223},
  [3461] = {.lex_state = 223},
  [3462] = {.lex_state = 223},
  [3463] = {.lex_state = 223},
  [3464] = {.lex_state = 223},
  [3465] = {.lex_state = 223},
  [3466] = {.lex_state = 223},
  [3467] = {.lex_state = 223},
  [3468] = {.lex_state = 223},
  [3469] = {.lex_state = 223},
  [3470] = {.lex_state = 223},
  [3471] = {.lex_state = 223},
  [3472] = {.lex_state = 223},
  [3473] = {.lex_state = 223},
  [3474] = {.lex_state = 223},
  [3475] = {.lex_state = 223},
  [3476] = {.lex_state = 223},
  [3477] = {.lex_state = 223},
  [3478] = {.lex_state = 223},
  [3479] = {.lex_state = 223},
  [3480] = {.lex_state = 223},
  [3481] = {.lex_state = 223},
  [3482] = {.lex_state = 223},
  [3483] = {.lex_state = 223},
  [3484] = {.lex_state = 223, .external_lex_state = 7},
  [3485] = {.lex_state = 223},
  [3486] = {.lex_state = 223},
  [3487] = {.lex_state = 223},
  [3488] = {.lex_state = 223},
  [3489] = {.lex_state = 223},
  [3490] = {.lex_state = 223},
  [3491] = {.lex_state = 223},
  [3492] = {.lex_state = 223},
  [3493] = {.lex_state = 223},
  [3494] = {.lex_state = 223},
  [3495] = {.lex_state = 223},
  [3496] = {.lex_state = 223},
  [3497] = {.lex_state = 223},
  [3498] = {.lex_state = 223},
  [3499] = {.lex_state = 223},
  [3500] = {.lex_state = 225, .external_lex_state = 7},
  [3501] = {.lex_state = 223},
  [3502] = {.lex_state = 223},
  [3503] = {.lex_state = 223},
  [3504] = {.lex_state = 223},
  [3505] = {.lex_state = 223},
  [3506] = {.lex_state = 223},
  [3507] = {.lex_state = 223},
  [3508] = {.lex_state = 223},
  [3509] = {.lex_state = 223},
  [3510] = {.lex_state = 223},
  [3511] = {.lex_state = 223},
  [3512] = {.lex_state = 223},
  [3513] = {.lex_state = 223},
  [3514] = {.lex_state = 223},
  [3515] = {.lex_state = 223},
  [3516] = {.lex_state = 223},
  [3517] = {.lex_state = 223},
  [3518] = {.lex_state = 223},
  [3519] = {.lex_state = 223},
  [3520] = {.lex_state = 223},
  [3521] = {.lex_state = 201},
  [3522] = {.lex_state = 223},
  [3523] = {.lex_state = 223, .external_lex_state = 7},
  [3524] = {.lex_state = 223},
  [3525] = {.lex_state = 223, .external_lex_state = 7},
  [3526] = {.lex_state = 223, .external_lex_state = 7},
  [3527] = {.lex_state = 223, .external_lex_state = 7},
  [3528] = {.lex_state = 223, .external_lex_state = 7},
  [3529] = {.lex_state = 223, .external_lex_state = 7},
  [3530] = {.lex_state = 223, .external_lex_state = 7},
  [3531] = {.lex_state = 223, .external_lex_state = 7},
  [3532] = {.lex_state = 223, .external_lex_state = 7},
  [3533] = {.lex_state = 223, .external_lex_state = 7},
  [3534] = {.lex_state = 223, .external_lex_state = 7},
  [3535] = {.lex_state = 223, .external_lex_state = 7},
  [3536] = {.lex_state = 223, .external_lex_state = 7},
  [3537] = {.lex_state = 223, .external_lex_state = 7},
  [3538] = {.lex_state = 223, .external_lex_state = 7},
  [3539] = {.lex_state = 223, .external_lex_state = 7},
  [3540] = {.lex_state = 223, .external_lex_state = 7},
  [3541] = {.lex_state = 223, .external_lex_state = 7},
  [3542] = {.lex_state = 223, .external_lex_state = 7},
  [3543] = {.lex_state = 223, .external_lex_state = 7},
  [3544] = {.lex_state = 223, .external_lex_state = 7},
  [3545] = {.lex_state = 223, .external_lex_state = 7},
  [3546] = {.lex_state = 223, .external_lex_state = 7},
  [3547] = {.lex_state = 223, .external_lex_state = 7},
  [3548] = {.lex_state = 223, .external_lex_state = 7},
  [3549] = {.lex_state = 223, .external_lex_state = 7},
  [3550] = {.lex_state = 223, .external_lex_state = 7},
  [3551] = {.lex_state = 223, .external_lex_state = 7},
  [3552] = {.lex_state = 223, .external_lex_state = 7},
  [3553] = {.lex_state = 223, .external_lex_state = 7},
  [3554] = {.lex_state = 223, .external_lex_state = 7},
  [3555] = {.lex_state = 223, .external_lex_state = 7},
  [3556] = {.lex_state = 223, .external_lex_state = 7},
  [3557] = {.lex_state = 223, .external_lex_state = 7},
  [3558] = {.lex_state = 223, .external_lex_state = 7},
  [3559] = {.lex_state = 223, .external_lex_state = 7},
  [3560] = {.lex_state = 223, .external_lex_state = 7},
  [3561] = {.lex_state = 223, .external_lex_state = 7},
  [3562] = {.lex_state = 223},
  [3563] = {.lex_state = 223, .external_lex_state = 7},
  [3564] = {.lex_state = 223, .external_lex_state = 7},
  [3565] = {.lex_state = 223, .external_lex_state = 7},
  [3566] = {.lex_state = 223, .external_lex_state = 7},
  [3567] = {.lex_state = 223},
  [3568] = {.lex_state = 223, .external_lex_state = 7},
  [3569] = {.lex_state = 223, .external_lex_state = 7},
  [3570] = {.lex_state = 223, .external_lex_state = 7},
  [3571] = {.lex_state = 223, .external_lex_state = 7},
  [3572] = {.lex_state = 223},
  [3573] = {.lex_state = 223},
  [3574] = {.lex_state = 223, .external_lex_state = 7},
  [3575] = {.lex_state = 223, .external_lex_state = 7},
  [3576] = {.lex_state = 223, .external_lex_state = 7},
  [3577] = {.lex_state = 223, .external_lex_state = 7},
  [3578] = {.lex_state = 223, .external_lex_state = 7},
  [3579] = {.lex_state = 223, .external_lex_state = 7},
  [3580] = {.lex_state = 223, .external_lex_state = 7},
  [3581] = {.lex_state = 223, .external_lex_state = 7},
  [3582] = {.lex_state = 223, .external_lex_state = 7},
  [3583] = {.lex_state = 223, .external_lex_state = 7},
  [3584] = {.lex_state = 223, .external_lex_state = 7},
  [3585] = {.lex_state = 223, .external_lex_state = 7},
  [3586] = {.lex_state = 223, .external_lex_state = 7},
  [3587] = {.lex_state = 223},
  [3588] = {.lex_state = 223, .external_lex_state = 7},
  [3589] = {.lex_state = 223, .external_lex_state = 7},
  [3590] = {.lex_state = 223, .external_lex_state = 7},
  [3591] = {.lex_state = 201},
  [3592] = {.lex_state = 223},
  [3593] = {.lex_state = 223},
  [3594] = {.lex_state = 223, .external_lex_state = 7},
  [3595] = {.lex_state = 223, .external_lex_state = 7},
  [3596] = {.lex_state = 223},
  [3597] = {.lex_state = 223},
  [3598] = {.lex_state = 223, .external_lex_state = 7},
  [3599] = {.lex_state = 223},
  [3600] = {.lex_state = 223},
  [3601] = {.lex_state = 223, .external_lex_state = 7},
  [3602] = {.lex_state = 223},
  [3603] = {.lex_state = 223},
  [3604] = {.lex_state = 223},
  [3605] = {.lex_state = 223, .external_lex_state = 7},
  [3606] = {.lex_state = 223},
  [3607] = {.lex_state = 223},
  [3608] = {.lex_state = 223},
  [3609] = {.lex_state = 223},
  [3610] = {.lex_state = 223},
  [3611] = {.lex_state = 223},
  [3612] = {.lex_state = 223},
  [3613] = {.lex_state = 201},
  [3614] = {.lex_state = 223, .external_lex_state = 7},
  [3615] = {.lex_state = 223},
  [3616] = {.lex_state = 223, .external_lex_state = 7},
  [3617] = {.lex_state = 223},
  [3618] = {.lex_state = 223, .external_lex_state = 7},
  [3619] = {.lex_state = 201},
  [3620] = {.lex_state = 223, .external_lex_state = 7},
  [3621] = {.lex_state = 223},
  [3622] = {.lex_state = 223},
  [3623] = {.lex_state = 223, .external_lex_state = 7},
  [3624] = {.lex_state = 223, .external_lex_state = 7},
  [3625] = {.lex_state = 223, .external_lex_state = 7},
  [3626] = {.lex_state = 223, .external_lex_state = 7},
  [3627] = {.lex_state = 223},
  [3628] = {.lex_state = 223, .external_lex_state = 7},
  [3629] = {.lex_state = 201},
  [3630] = {.lex_state = 228},
  [3631] = {.lex_state = 223, .external_lex_state = 7},
  [3632] = {.lex_state = 201},
  [3633] = {.lex_state = 201},
  [3634] = {.lex_state = 201},
  [3635] = {.lex_state = 201},
  [3636] = {.lex_state = 201},
  [3637] = {.lex_state = 201},
  [3638] = {.lex_state = 201},
  [3639] = {.lex_state = 201},
  [3640] = {.lex_state = 201},
  [3641] = {.lex_state = 201},
  [3642] = {.lex_state = 201},
  [3643] = {.lex_state = 201},
  [3644] = {.lex_state = 229},
  [3645] = {.lex_state = 229},
  [3646] = {.lex_state = 228},
  [3647] = {.lex_state = 201},
  [3648] = {.lex_state = 229},
  [3649] = {.lex_state = 201},
  [3650] = {.lex_state = 201},
  [3651] = {.lex_state = 201},
  [3652] = {.lex_state = 201},
  [3653] = {.lex_state = 201},
  [3654] = {.lex_state = 201},
  [3655] = {.lex_state = 201},
  [3656] = {.lex_state = 201},
  [3657] = {.lex_state = 201},
  [3658] = {.lex_state = 201},
  [3659] = {.lex_state = 201},
  [3660] = {.lex_state = 201},
  [3661] = {.lex_state = 201},
  [3662] = {.lex_state = 201, .external_lex_state = 8},
  [3663] = {.lex_state = 201, .external_lex_state = 8},
  [3664] = {.lex_state = 201},
  [3665] = {.lex_state = 201},
  [3666] = {.lex_state = 201},
  [3667] = {.lex_state = 201},
  [3668] = {.lex_state = 201, .external_lex_state = 8},
  [3669] = {.lex_state = 201},
  [3670] = {.lex_state = 201},
  [3671] = {.lex_state = 201},
  [3672] = {.lex_state = 201},
  [3673] = {.lex_state = 201},
  [3674] = {.lex_state = 201},
  [3675] = {.lex_state = 201},
  [3676] = {.lex_state = 201},
  [3677] = {.lex_state = 201},
  [3678] = {.lex_state = 201},
  [3679] = {.lex_state = 201},
  [3680] = {.lex_state = 201},
  [3681] = {.lex_state = 201},
  [3682] = {.lex_state = 201},
  [3683] = {.lex_state = 201},
  [3684] = {.lex_state = 201},
  [3685] = {.lex_state = 201},
  [3686] = {.lex_state = 201},
  [3687] = {.lex_state = 201},
  [3688] = {.lex_state = 201},
  [3689] = {.lex_state = 201},
  [3690] = {.lex_state = 201},
  [3691] = {.lex_state = 201},
  [3692] = {.lex_state = 201},
  [3693] = {.lex_state = 229},
  [3694] = {.lex_state = 201},
  [3695] = {.lex_state = 201},
  [3696] = {.lex_state = 201},
  [3697] = {.lex_state = 225},
  [3698] = {.lex_state = 201},
  [3699] = {.lex_state = 229},
  [3700] = {.lex_state = 201},
  [3701] = {.lex_state = 201},
  [3702] = {.lex_state = 201},
  [3703] = {.lex_state = 201},
  [3704] = {.lex_state = 229},
  [3705] = {.lex_state = 229},
  [3706] = {.lex_state = 201},
  [3707] = {.lex_state = 201},
  [3708] = {.lex_state = 229},
  [3709] = {.lex_state = 201},
  [3710] = {.lex_state = 201},
  [3711] = {.lex_state = 201},
  [3712] = {.lex_state = 229},
  [3713] = {.lex_state = 201},
  [3714] = {.lex_state = 201},
  [3715] = {.lex_state = 201},
  [3716] = {.lex_state = 201},
  [3717] = {.lex_state = 201},
  [3718] = {.lex_state = 223},
  [3719] = {.lex_state = 201},
  [3720] = {.lex_state = 201},
  [3721] = {.lex_state = 201},
  [3722] = {.lex_state = 229},
  [3723] = {.lex_state = 201},
  [3724] = {.lex_state = 201},
  [3725] = {.lex_state = 223},
  [3726] = {.lex_state = 0},
  [3727] = {.lex_state = 201},
  [3728] = {.lex_state = 0, .external_lex_state = 11},
  [3729] = {.lex_state = 229},
  [3730] = {.lex_state = 223},
  [3731] = {.lex_state = 223},
  [3732] = {.lex_state = 0},
  [3733] = {.lex_state = 0},
  [3734] = {.lex_state = 203},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 223},
  [3738] = {.lex_state = 0},
  [3739] = {.lex_state = 223},
  [3740] = {.lex_state = 0},
  [3741] = {.lex_state = 201},
  [3742] = {.lex_state = 0, .external_lex_state = 11},
  [3743] = {.lex_state = 223},
  [3744] = {.lex_state = 0, .external_lex_state = 11},
  [3745] = {.lex_state = 223},
  [3746] = {.lex_state = 223, .external_lex_state = 7},
  [3747] = {.lex_state = 201},
  [3748] = {.lex_state = 229},
  [3749] = {.lex_state = 201},
  [3750] = {.lex_state = 0, .external_lex_state = 11},
  [3751] = {.lex_state = 0},
  [3752] = {.lex_state = 0},
  [3753] = {.lex_state = 223},
  [3754] = {.lex_state = 223},
  [3755] = {.lex_state = 201},
  [3756] = {.lex_state = 223},
  [3757] = {.lex_state = 201},
  [3758] = {.lex_state = 0},
  [3759] = {.lex_state = 225},
  [3760] = {.lex_state = 0, .external_lex_state = 11},
  [3761] = {.lex_state = 0},
  [3762] = {.lex_state = 223},
  [3763] = {.lex_state = 223},
  [3764] = {.lex_state = 203},
  [3765] = {.lex_state = 0},
  [3766] = {.lex_state = 201},
  [3767] = {.lex_state = 203},
  [3768] = {.lex_state = 201},
  [3769] = {.lex_state = 0, .external_lex_state = 11},
  [3770] = {.lex_state = 0},
  [3771] = {.lex_state = 0, .external_lex_state = 11},
  [3772] = {.lex_state = 229},
  [3773] = {.lex_state = 201},
  [3774] = {.lex_state = 0},
  [3775] = {.lex_state = 0},
  [3776] = {.lex_state = 223},
  [3777] = {.lex_state = 0},
  [3778] = {.lex_state = 203},
  [3779] = {.lex_state = 203},
  [3780] = {.lex_state = 0},
  [3781] = {.lex_state = 0, .external_lex_state = 11},
  [3782] = {.lex_state = 201},
  [3783] = {.lex_state = 223},
  [3784] = {.lex_state = 223},
  [3785] = {.lex_state = 223},
  [3786] = {.lex_state = 203},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 0},
  [3789] = {.lex_state = 203},
  [3790] = {.lex_state = 223},
  [3791] = {.lex_state = 223},
  [3792] = {.lex_state = 201},
  [3793] = {.lex_state = 223},
  [3794] = {.lex_state = 223},
  [3795] = {.lex_state = 223},
  [3796] = {.lex_state = 0},
  [3797] = {.lex_state = 203},
  [3798] = {.lex_state = 223, .external_lex_state = 7},
  [3799] = {.lex_state = 229},
  [3800] = {.lex_state = 0},
  [3801] = {.lex_state = 201},
  [3802] = {.lex_state = 223},
  [3803] = {.lex_state = 229},
  [3804] = {.lex_state = 0, .external_lex_state = 11},
  [3805] = {.lex_state = 223},
  [3806] = {.lex_state = 0},
  [3807] = {.lex_state = 201},
  [3808] = {.lex_state = 201},
  [3809] = {.lex_state = 203},
  [3810] = {.lex_state = 0},
  [3811] = {.lex_state = 0},
  [3812] = {.lex_state = 223},
  [3813] = {.lex_state = 223},
  [3814] = {.lex_state = 203},
  [3815] = {.lex_state = 203},
  [3816] = {.lex_state = 201},
  [3817] = {.lex_state = 201},
  [3818] = {.lex_state = 201},
  [3819] = {.lex_state = 0, .external_lex_state = 11},
  [3820] = {.lex_state = 229},
  [3821] = {.lex_state = 201},
  [3822] = {.lex_state = 0, .external_lex_state = 11},
  [3823] = {.lex_state = 201},
  [3824] = {.lex_state = 0, .external_lex_state = 11},
  [3825] = {.lex_state = 201},
  [3826] = {.lex_state = 223},
  [3827] = {.lex_state = 223},
  [3828] = {.lex_state = 223},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 223},
  [3832] = {.lex_state = 223},
  [3833] = {.lex_state = 223},
  [3834] = {.lex_state = 223},
  [3835] = {.lex_state = 223},
  [3836] = {.lex_state = 229},
  [3837] = {.lex_state = 223},
  [3838] = {.lex_state = 223},
  [3839] = {.lex_state = 201},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 0},
  [3842] = {.lex_state = 223},
  [3843] = {.lex_state = 223},
  [3844] = {.lex_state = 201},
  [3845] = {.lex_state = 229},
  [3846] = {.lex_state = 229},
  [3847] = {.lex_state = 201},
  [3848] = {.lex_state = 223},
  [3849] = {.lex_state = 229},
  [3850] = {.lex_state = 229},
  [3851] = {.lex_state = 223},
  [3852] = {.lex_state = 201},
  [3853] = {.lex_state = 0, .external_lex_state = 11},
  [3854] = {.lex_state = 229},
  [3855] = {.lex_state = 203},
  [3856] = {.lex_state = 229},
  [3857] = {.lex_state = 223},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0, .external_lex_state = 11},
  [3860] = {.lex_state = 203},
  [3861] = {.lex_state = 201},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 223},
  [3864] = {.lex_state = 203},
  [3865] = {.lex_state = 201},
  [3866] = {.lex_state = 203},
  [3867] = {.lex_state = 201},
  [3868] = {.lex_state = 223},
  [3869] = {.lex_state = 203},
  [3870] = {.lex_state = 0, .external_lex_state = 11},
  [3871] = {.lex_state = 201},
  [3872] = {.lex_state = 229},
  [3873] = {.lex_state = 223},
  [3874] = {.lex_state = 223},
  [3875] = {.lex_state = 203},
  [3876] = {.lex_state = 203},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 0},
  [3879] = {.lex_state = 225, .external_lex_state = 7},
  [3880] = {.lex_state = 201},
  [3881] = {.lex_state = 3},
  [3882] = {.lex_state = 201},
  [3883] = {.lex_state = 3},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 223},
  [3886] = {.lex_state = 201},
  [3887] = {.lex_state = 3},
  [3888] = {.lex_state = 201},
  [3889] = {.lex_state = 3},
  [3890] = {.lex_state = 3},
  [3891] = {.lex_state = 201},
  [3892] = {.lex_state = 201},
  [3893] = {.lex_state = 201},
  [3894] = {.lex_state = 201},
  [3895] = {.lex_state = 201},
  [3896] = {.lex_state = 201},
  [3897] = {.lex_state = 0},
  [3898] = {.lex_state = 3},
  [3899] = {.lex_state = 3},
  [3900] = {.lex_state = 223},
  [3901] = {.lex_state = 201},
  [3902] = {.lex_state = 201},
  [3903] = {.lex_state = 0},
  [3904] = {.lex_state = 201},
  [3905] = {.lex_state = 3},
  [3906] = {.lex_state = 201},
  [3907] = {.lex_state = 3},
  [3908] = {.lex_state = 201},
  [3909] = {.lex_state = 3},
  [3910] = {.lex_state = 201},
  [3911] = {.lex_state = 201},
  [3912] = {.lex_state = 223},
  [3913] = {.lex_state = 0, .external_lex_state = 2},
  [3914] = {.lex_state = 201},
  [3915] = {.lex_state = 201},
  [3916] = {.lex_state = 3},
  [3917] = {.lex_state = 3},
  [3918] = {.lex_state = 201},
  [3919] = {.lex_state = 0, .external_lex_state = 2},
  [3920] = {.lex_state = 201},
  [3921] = {.lex_state = 223},
  [3922] = {.lex_state = 234},
  [3923] = {.lex_state = 201},
  [3924] = {.lex_state = 201},
  [3925] = {.lex_state = 203},
  [3926] = {.lex_state = 201},
  [3927] = {.lex_state = 223},
  [3928] = {.lex_state = 201, .external_lex_state = 7},
  [3929] = {.lex_state = 201},
  [3930] = {.lex_state = 3},
  [3931] = {.lex_state = 201},
  [3932] = {.lex_state = 201},
  [3933] = {.lex_state = 3},
  [3934] = {.lex_state = 201},
  [3935] = {.lex_state = 201},
  [3936] = {.lex_state = 3},
  [3937] = {.lex_state = 3},
  [3938] = {.lex_state = 234, .external_lex_state = 7},
  [3939] = {.lex_state = 201},
  [3940] = {.lex_state = 201},
  [3941] = {.lex_state = 201},
  [3942] = {.lex_state = 201},
  [3943] = {.lex_state = 223, .external_lex_state = 7},
  [3944] = {.lex_state = 3},
  [3945] = {.lex_state = 3},
  [3946] = {.lex_state = 201},
  [3947] = {.lex_state = 201, .external_lex_state = 7},
  [3948] = {.lex_state = 3},
  [3949] = {.lex_state = 3},
  [3950] = {.lex_state = 3},
  [3951] = {.lex_state = 225},
  [3952] = {.lex_state = 3},
  [3953] = {.lex_state = 3},
  [3954] = {.lex_state = 201},
  [3955] = {.lex_state = 201},
  [3956] = {.lex_state = 3},
  [3957] = {.lex_state = 3},
  [3958] = {.lex_state = 201},
  [3959] = {.lex_state = 201},
  [3960] = {.lex_state = 0},
  [3961] = {.lex_state = 201},
  [3962] = {.lex_state = 3},
  [3963] = {.lex_state = 201},
  [3964] = {.lex_state = 201},
  [3965] = {.lex_state = 201, .external_lex_state = 7},
  [3966] = {.lex_state = 234},
  [3967] = {.lex_state = 3},
  [3968] = {.lex_state = 201},
  [3969] = {.lex_state = 3},
  [3970] = {.lex_state = 201},
  [3971] = {.lex_state = 3},
  [3972] = {.lex_state = 201},
  [3973] = {.lex_state = 3},
  [3974] = {.lex_state = 234},
  [3975] = {.lex_state = 223},
  [3976] = {.lex_state = 201},
  [3977] = {.lex_state = 223},
  [3978] = {.lex_state = 3},
  [3979] = {.lex_state = 223},
  [3980] = {.lex_state = 0, .external_lex_state = 7},
  [3981] = {.lex_state = 201, .external_lex_state = 12},
  [3982] = {.lex_state = 201},
  [3983] = {.lex_state = 223},
  [3984] = {.lex_state = 201},
  [3985] = {.lex_state = 0, .external_lex_state = 9},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0, .external_lex_state = 10},
  [3988] = {.lex_state = 228},
  [3989] = {.lex_state = 201},
  [3990] = {.lex_state = 228},
  [3991] = {.lex_state = 228},
  [3992] = {.lex_state = 201},
  [3993] = {.lex_state = 201},
  [3994] = {.lex_state = 201},
  [3995] = {.lex_state = 228},
  [3996] = {.lex_state = 228},
  [3997] = {.lex_state = 201},
  [3998] = {.lex_state = 228},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 228},
  [4001] = {.lex_state = 228},
  [4002] = {.lex_state = 0, .external_lex_state = 7},
  [4003] = {.lex_state = 223},
  [4004] = {.lex_state = 228},
  [4005] = {.lex_state = 223},
  [4006] = {.lex_state = 228},
  [4007] = {.lex_state = 0, .external_lex_state = 10},
  [4008] = {.lex_state = 0, .external_lex_state = 9},
  [4009] = {.lex_state = 228},
  [4010] = {.lex_state = 0, .external_lex_state = 9},
  [4011] = {.lex_state = 223},
  [4012] = {.lex_state = 223},
  [4013] = {.lex_state = 223},
  [4014] = {.lex_state = 223},
  [4015] = {.lex_state = 223},
  [4016] = {.lex_state = 223},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 228},
  [4019] = {.lex_state = 201},
  [4020] = {.lex_state = 0, .external_lex_state = 10},
  [4021] = {.lex_state = 223},
  [4022] = {.lex_state = 0},
  [4023] = {.lex_state = 0, .external_lex_state = 9},
  [4024] = {.lex_state = 223},
  [4025] = {.lex_state = 0, .external_lex_state = 10},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0, .external_lex_state = 9},
  [4028] = {.lex_state = 0, .external_lex_state = 9},
  [4029] = {.lex_state = 0, .external_lex_state = 10},
  [4030] = {.lex_state = 0, .external_lex_state = 10},
  [4031] = {.lex_state = 201, .external_lex_state = 7},
  [4032] = {.lex_state = 0},
  [4033] = {.lex_state = 0, .external_lex_state = 9},
  [4034] = {.lex_state = 223},
  [4035] = {.lex_state = 201},
  [4036] = {.lex_state = 223},
  [4037] = {.lex_state = 223},
  [4038] = {.lex_state = 0, .external_lex_state = 9},
  [4039] = {.lex_state = 228},
  [4040] = {.lex_state = 0, .external_lex_state = 10},
  [4041] = {.lex_state = 223, .external_lex_state = 7},
  [4042] = {.lex_state = 223, .external_lex_state = 7},
  [4043] = {.lex_state = 228},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 228},
  [4046] = {.lex_state = 201},
  [4047] = {.lex_state = 228},
  [4048] = {.lex_state = 201},
  [4049] = {.lex_state = 223, .external_lex_state = 7},
  [4050] = {.lex_state = 223},
  [4051] = {.lex_state = 201, .external_lex_state = 12},
  [4052] = {.lex_state = 0, .external_lex_state = 9},
  [4053] = {.lex_state = 201},
  [4054] = {.lex_state = 0, .external_lex_state = 10},
  [4055] = {.lex_state = 201},
  [4056] = {.lex_state = 0, .external_lex_state = 10},
  [4057] = {.lex_state = 228},
  [4058] = {.lex_state = 223},
  [4059] = {.lex_state = 201},
  [4060] = {.lex_state = 201},
  [4061] = {.lex_state = 201},
  [4062] = {.lex_state = 201},
  [4063] = {.lex_state = 201},
  [4064] = {.lex_state = 0},
  [4065] = {.lex_state = 0, .external_lex_state = 10},
  [4066] = {.lex_state = 0, .external_lex_state = 9},
  [4067] = {.lex_state = 0, .external_lex_state = 10},
  [4068] = {.lex_state = 223},
  [4069] = {.lex_state = 223},
  [4070] = {.lex_state = 201, .external_lex_state = 7},
  [4071] = {.lex_state = 201},
  [4072] = {.lex_state = 0, .external_lex_state = 9},
  [4073] = {.lex_state = 223},
  [4074] = {.lex_state = 201, .external_lex_state = 7},
  [4075] = {.lex_state = 228},
  [4076] = {.lex_state = 0},
  [4077] = {.lex_state = 228},
  [4078] = {.lex_state = 228},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 201},
  [4081] = {.lex_state = 223},
  [4082] = {.lex_state = 223},
  [4083] = {.lex_state = 0, .external_lex_state = 7},
  [4084] = {.lex_state = 201},
  [4085] = {.lex_state = 201},
  [4086] = {.lex_state = 223},
  [4087] = {.lex_state = 0},
  [4088] = {.lex_state = 201},
  [4089] = {.lex_state = 0},
  [4090] = {.lex_state = 0},
  [4091] = {.lex_state = 0},
  [4092] = {.lex_state = 0},
  [4093] = {.lex_state = 0, .external_lex_state = 9},
  [4094] = {.lex_state = 0, .external_lex_state = 10},
  [4095] = {.lex_state = 223},
  [4096] = {.lex_state = 228},
  [4097] = {.lex_state = 0, .external_lex_state = 9},
  [4098] = {.lex_state = 0, .external_lex_state = 10},
  [4099] = {.lex_state = 0, .external_lex_state = 7},
  [4100] = {.lex_state = 228},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0, .external_lex_state = 7},
  [4103] = {.lex_state = 201},
  [4104] = {.lex_state = 201},
  [4105] = {.lex_state = 201},
  [4106] = {.lex_state = 0, .external_lex_state = 10},
  [4107] = {.lex_state = 0, .external_lex_state = 9},
  [4108] = {.lex_state = 228},
  [4109] = {.lex_state = 201},
  [4110] = {.lex_state = 223},
  [4111] = {.lex_state = 228},
  [4112] = {.lex_state = 223},
  [4113] = {.lex_state = 201},
  [4114] = {.lex_state = 201},
  [4115] = {.lex_state = 0, .external_lex_state = 9},
  [4116] = {.lex_state = 228},
  [4117] = {.lex_state = 228},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 0, .external_lex_state = 10},
  [4120] = {.lex_state = 228},
  [4121] = {.lex_state = 201},
  [4122] = {.lex_state = 0},
  [4123] = {.lex_state = 0, .external_lex_state = 10},
  [4124] = {.lex_state = 0, .external_lex_state = 9},
  [4125] = {.lex_state = 0, .external_lex_state = 7},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 223},
  [4128] = {.lex_state = 0, .external_lex_state = 7},
  [4129] = {.lex_state = 0, .external_lex_state = 7},
  [4130] = {.lex_state = 223},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 201},
  [4133] = {.lex_state = 223},
  [4134] = {.lex_state = 223},
  [4135] = {.lex_state = 212},
  [4136] = {.lex_state = 201},
  [4137] = {.lex_state = 0},
  [4138] = {.lex_state = 212},
  [4139] = {.lex_state = 223},
  [4140] = {.lex_state = 223},
  [4141] = {.lex_state = 0},
  [4142] = {.lex_state = 201},
  [4143] = {.lex_state = 0},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 0, .external_lex_state = 2},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 0},
  [4148] = {.lex_state = 0},
  [4149] = {.lex_state = 0, .external_lex_state = 2},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 234},
  [4152] = {.lex_state = 0},
  [4153] = {.lex_state = 227},
  [4154] = {.lex_state = 201},
  [4155] = {.lex_state = 201},
  [4156] = {.lex_state = 0},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 201},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 227},
  [4165] = {.lex_state = 0},
  [4166] = {.lex_state = 0},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 227},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 223},
  [4173] = {.lex_state = 0},
  [4174] = {.lex_state = 234},
  [4175] = {.lex_state = 0},
  [4176] = {.lex_state = 0},
  [4177] = {.lex_state = 0},
  [4178] = {.lex_state = 201},
  [4179] = {.lex_state = 0},
  [4180] = {.lex_state = 201},
  [4181] = {.lex_state = 0},
  [4182] = {.lex_state = 201},
  [4183] = {.lex_state = 0},
  [4184] = {.lex_state = 0, .external_lex_state = 7},
  [4185] = {.lex_state = 201},
  [4186] = {.lex_state = 227},
  [4187] = {.lex_state = 225},
  [4188] = {.lex_state = 0, .external_lex_state = 7},
  [4189] = {.lex_state = 227},
  [4190] = {.lex_state = 201},
  [4191] = {.lex_state = 223},
  [4192] = {.lex_state = 223},
  [4193] = {.lex_state = 0, .external_lex_state = 7},
  [4194] = {.lex_state = 201},
  [4195] = {.lex_state = 201},
  [4196] = {.lex_state = 223},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 225},
  [4199] = {.lex_state = 223},
  [4200] = {.lex_state = 223},
  [4201] = {.lex_state = 223},
  [4202] = {.lex_state = 225},
  [4203] = {.lex_state = 201},
  [4204] = {.lex_state = 201},
  [4205] = {.lex_state = 0},
  [4206] = {.lex_state = 201},
  [4207] = {.lex_state = 201},
  [4208] = {.lex_state = 201},
  [4209] = {.lex_state = 201},
  [4210] = {.lex_state = 225},
  [4211] = {.lex_state = 227},
  [4212] = {.lex_state = 201},
  [4213] = {.lex_state = 223},
  [4214] = {.lex_state = 223},
  [4215] = {.lex_state = 0},
  [4216] = {.lex_state = 201},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 0},
  [4219] = {.lex_state = 201},
  [4220] = {.lex_state = 0},
  [4221] = {.lex_state = 0, .external_lex_state = 7},
  [4222] = {.lex_state = 227},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 0},
  [4225] = {.lex_state = 0},
  [4226] = {.lex_state = 0},
  [4227] = {.lex_state = 225},
  [4228] = {.lex_state = 225},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 225},
  [4231] = {.lex_state = 234},
  [4232] = {.lex_state = 234},
  [4233] = {.lex_state = 223},
  [4234] = {.lex_state = 225},
  [4235] = {.lex_state = 225},
  [4236] = {.lex_state = 223},
  [4237] = {.lex_state = 234},
  [4238] = {.lex_state = 225},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 201},
  [4241] = {.lex_state = 0},
  [4242] = {.lex_state = 223},
  [4243] = {.lex_state = 223},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 201},
  [4246] = {.lex_state = 0},
  [4247] = {.lex_state = 225},
  [4248] = {.lex_state = 227},
  [4249] = {.lex_state = 223},
  [4250] = {.lex_state = 223},
  [4251] = {.lex_state = 201},
  [4252] = {.lex_state = 225},
  [4253] = {.lex_state = 201},
  [4254] = {.lex_state = 201},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 0},
  [4257] = {.lex_state = 0},
  [4258] = {.lex_state = 223},
  [4259] = {.lex_state = 223},
  [4260] = {.lex_state = 201},
  [4261] = {.lex_state = 201},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 201},
  [4264] = {.lex_state = 201},
  [4265] = {.lex_state = 223},
  [4266] = {.lex_state = 201},
  [4267] = {.lex_state = 0},
  [4268] = {.lex_state = 223},
  [4269] = {.lex_state = 227},
  [4270] = {.lex_state = 201},
  [4271] = {.lex_state = 223},
  [4272] = {.lex_state = 201},
  [4273] = {.lex_state = 0},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 0},
  [4276] = {.lex_state = 0},
  [4277] = {.lex_state = 201},
  [4278] = {.lex_state = 0},
  [4279] = {.lex_state = 223},
  [4280] = {.lex_state = 227},
  [4281] = {.lex_state = 0},
  [4282] = {.lex_state = 0},
  [4283] = {.lex_state = 3},
  [4284] = {.lex_state = 0},
  [4285] = {.lex_state = 201},
  [4286] = {.lex_state = 201},
  [4287] = {.lex_state = 0},
  [4288] = {.lex_state = 201},
  [4289] = {.lex_state = 0},
  [4290] = {.lex_state = 234},
  [4291] = {.lex_state = 201},
  [4292] = {.lex_state = 201},
  [4293] = {.lex_state = 227},
  [4294] = {.lex_state = 0},
  [4295] = {.lex_state = 201},
  [4296] = {.lex_state = 225},
  [4297] = {.lex_state = 201},
  [4298] = {.lex_state = 201},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 223},
  [4301] = {.lex_state = 223},
  [4302] = {.lex_state = 201},
  [4303] = {.lex_state = 201},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 0},
  [4306] = {.lex_state = 201},
  [4307] = {.lex_state = 223},
  [4308] = {.lex_state = 223},
  [4309] = {.lex_state = 0},
  [4310] = {.lex_state = 201},
  [4311] = {.lex_state = 201},
  [4312] = {.lex_state = 0},
  [4313] = {.lex_state = 0},
  [4314] = {.lex_state = 201},
  [4315] = {.lex_state = 227},
  [4316] = {.lex_state = 223},
  [4317] = {.lex_state = 223},
  [4318] = {.lex_state = 201},
  [4319] = {.lex_state = 201},
  [4320] = {.lex_state = 201},
  [4321] = {.lex_state = 0, .external_lex_state = 2},
  [4322] = {.lex_state = 223},
  [4323] = {.lex_state = 223},
  [4324] = {.lex_state = 201},
  [4325] = {.lex_state = 201},
  [4326] = {.lex_state = 0},
  [4327] = {.lex_state = 227},
  [4328] = {.lex_state = 201},
  [4329] = {.lex_state = 201},
  [4330] = {.lex_state = 201},
  [4331] = {.lex_state = 0},
  [4332] = {.lex_state = 212},
  [4333] = {.lex_state = 201},
  [4334] = {.lex_state = 0},
  [4335] = {.lex_state = 201},
  [4336] = {.lex_state = 0},
  [4337] = {.lex_state = 0},
  [4338] = {.lex_state = 227},
  [4339] = {.lex_state = 0},
  [4340] = {.lex_state = 0},
  [4341] = {.lex_state = 0, .external_lex_state = 7},
  [4342] = {.lex_state = 0},
  [4343] = {.lex_state = 201},
  [4344] = {.lex_state = 212},
  [4345] = {.lex_state = 0},
  [4346] = {.lex_state = 201},
  [4347] = {.lex_state = 201},
  [4348] = {.lex_state = 234},
  [4349] = {.lex_state = 223},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 201},
  [4352] = {.lex_state = 0},
  [4353] = {.lex_state = 0},
  [4354] = {.lex_state = 201},
  [4355] = {.lex_state = 227},
  [4356] = {.lex_state = 201},
  [4357] = {.lex_state = 0},
  [4358] = {.lex_state = 223},
  [4359] = {.lex_state = 0},
  [4360] = {.lex_state = 0},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 0},
  [4363] = {.lex_state = 201},
  [4364] = {.lex_state = 0},
  [4365] = {.lex_state = 0},
  [4366] = {.lex_state = 0},
  [4367] = {.lex_state = 0},
  [4368] = {.lex_state = 0},
  [4369] = {.lex_state = 227},
  [4370] = {.lex_state = 0},
  [4371] = {.lex_state = 0},
  [4372] = {.lex_state = 223},
  [4373] = {.lex_state = 212},
  [4374] = {.lex_state = 212},
  [4375] = {.lex_state = 0},
  [4376] = {.lex_state = 201},
  [4377] = {.lex_state = 0},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 0, .external_lex_state = 7},
  [4380] = {.lex_state = 201},
  [4381] = {.lex_state = 201},
  [4382] = {.lex_state = 227},
  [4383] = {.lex_state = 212},
  [4384] = {.lex_state = 223},
  [4385] = {.lex_state = 0, .external_lex_state = 2},
  [4386] = {.lex_state = 234},
  [4387] = {.lex_state = 201},
  [4388] = {.lex_state = 201},
  [4389] = {.lex_state = 223},
  [4390] = {.lex_state = 223},
  [4391] = {.lex_state = 223},
  [4392] = {.lex_state = 201},
  [4393] = {.lex_state = 0, .external_lex_state = 7},
  [4394] = {.lex_state = 223},
  [4395] = {.lex_state = 0},
  [4396] = {.lex_state = 201},
  [4397] = {.lex_state = 212},
  [4398] = {.lex_state = 212},
  [4399] = {.lex_state = 223},
  [4400] = {.lex_state = 201},
  [4401] = {.lex_state = 223},
  [4402] = {.lex_state = 223},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 223},
  [4405] = {.lex_state = 223},
  [4406] = {.lex_state = 201},
  [4407] = {.lex_state = 0, .external_lex_state = 7},
  [4408] = {.lex_state = 201},
  [4409] = {.lex_state = 201},
  [4410] = {.lex_state = 201},
  [4411] = {.lex_state = 227},
  [4412] = {.lex_state = 223},
  [4413] = {.lex_state = 227},
  [4414] = {.lex_state = 201},
  [4415] = {.lex_state = 212},
  [4416] = {.lex_state = 212},
  [4417] = {.lex_state = 201},
  [4418] = {.lex_state = 201},
  [4419] = {.lex_state = 234},
  [4420] = {.lex_state = 223},
  [4421] = {.lex_state = 0},
  [4422] = {.lex_state = 201},
  [4423] = {.lex_state = 223},
  [4424] = {.lex_state = 0},
  [4425] = {.lex_state = 0},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 0},
  [4428] = {.lex_state = 0},
  [4429] = {.lex_state = 212},
  [4430] = {.lex_state = 212},
  [4431] = {.lex_state = 0},
  [4432] = {.lex_state = 0},
  [4433] = {.lex_state = 0},
  [4434] = {.lex_state = 0},
  [4435] = {.lex_state = 227},
  [4436] = {.lex_state = 0, .external_lex_state = 7},
  [4437] = {.lex_state = 212},
  [4438] = {.lex_state = 234},
  [4439] = {.lex_state = 0},
  [4440] = {.lex_state = 223},
  [4441] = {.lex_state = 201},
  [4442] = {.lex_state = 223},
  [4443] = {.lex_state = 0},
  [4444] = {.lex_state = 212},
  [4445] = {.lex_state = 212},
  [4446] = {.lex_state = 201},
  [4447] = {.lex_state = 0},
  [4448] = {.lex_state = 0},
  [4449] = {.lex_state = 201},
  [4450] = {.lex_state = 223},
  [4451] = {.lex_state = 0},
  [4452] = {.lex_state = 201},
  [4453] = {.lex_state = 227},
  [4454] = {.lex_state = 227},
  [4455] = {.lex_state = 201},
  [4456] = {.lex_state = 201},
  [4457] = {.lex_state = 223},
  [4458] = {.lex_state = 212},
  [4459] = {.lex_state = 212},
  [4460] = {.lex_state = 201},
  [4461] = {.lex_state = 227},
  [4462] = {.lex_state = 201},
  [4463] = {.lex_state = 223},
  [4464] = {.lex_state = 201},
  [4465] = {.lex_state = 0},
  [4466] = {.lex_state = 212},
  [4467] = {.lex_state = 212},
  [4468] = {.lex_state = 201},
  [4469] = {.lex_state = 201},
  [4470] = {.lex_state = 223},
  [4471] = {.lex_state = 223},
  [4472] = {.lex_state = 0},
  [4473] = {.lex_state = 0},
  [4474] = {.lex_state = 212},
  [4475] = {.lex_state = 0},
  [4476] = {.lex_state = 201},
  [4477] = {.lex_state = 201},
  [4478] = {.lex_state = 201},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 223},
  [4481] = {.lex_state = 212},
  [4482] = {.lex_state = 212},
  [4483] = {.lex_state = 201},
  [4484] = {.lex_state = 201},
  [4485] = {.lex_state = 201},
  [4486] = {.lex_state = 223},
  [4487] = {.lex_state = 223},
  [4488] = {.lex_state = 223},
  [4489] = {.lex_state = 227},
  [4490] = {.lex_state = 223},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 0},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 223},
  [4495] = {.lex_state = 212},
  [4496] = {.lex_state = 212},
  [4497] = {.lex_state = 201},
  [4498] = {.lex_state = 201},
  [4499] = {.lex_state = 3},
  [4500] = {.lex_state = 223},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 228},
  [4503] = {.lex_state = 234},
  [4504] = {.lex_state = 0},
  [4505] = {.lex_state = 227},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 201},
  [4508] = {.lex_state = 234},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 201},
  [4511] = {.lex_state = 201},
  [4512] = {.lex_state = 201},
  [4513] = {.lex_state = 212},
  [4514] = {.lex_state = 212},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 0},
  [4517] = {.lex_state = 223},
  [4518] = {.lex_state = 227},
  [4519] = {.lex_state = 0},
  [4520] = {.lex_state = 201},
  [4521] = {.lex_state = 0},
  [4522] = {.lex_state = 223},
  [4523] = {.lex_state = 223},
  [4524] = {.lex_state = 201},
  [4525] = {.lex_state = 223},
  [4526] = {.lex_state = 201},
  [4527] = {.lex_state = 227},
  [4528] = {.lex_state = 201},
  [4529] = {.lex_state = 223},
  [4530] = {.lex_state = 201},
  [4531] = {.lex_state = 201},
  [4532] = {.lex_state = 223},
  [4533] = {.lex_state = 223},
  [4534] = {.lex_state = 201},
  [4535] = {.lex_state = 201},
  [4536] = {.lex_state = 0},
  [4537] = {.lex_state = 0},
  [4538] = {.lex_state = 201},
  [4539] = {.lex_state = 223},
  [4540] = {.lex_state = 223},
  [4541] = {.lex_state = 201},
  [4542] = {.lex_state = 0, .external_lex_state = 7},
  [4543] = {.lex_state = 212},
  [4544] = {.lex_state = 223},
  [4545] = {.lex_state = 223},
  [4546] = {.lex_state = 0},
  [4547] = {.lex_state = 201},
  [4548] = {.lex_state = 223},
  [4549] = {.lex_state = 201},
  [4550] = {.lex_state = 0, .external_lex_state = 7},
  [4551] = {.lex_state = 227},
  [4552] = {.lex_state = 201},
  [4553] = {.lex_state = 201},
  [4554] = {.lex_state = 201},
  [4555] = {.lex_state = 201},
  [4556] = {.lex_state = 0},
  [4557] = {.lex_state = 234},
  [4558] = {.lex_state = 228},
  [4559] = {.lex_state = 201},
  [4560] = {.lex_state = 0},
  [4561] = {.lex_state = 0},
  [4562] = {.lex_state = 0},
  [4563] = {.lex_state = 201},
  [4564] = {.lex_state = 223},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 223},
  [4567] = {.lex_state = 201},
  [4568] = {.lex_state = 227},
  [4569] = {.lex_state = 0},
  [4570] = {.lex_state = 0},
  [4571] = {.lex_state = 0},
  [4572] = {.lex_state = 0},
  [4573] = {.lex_state = 227},
  [4574] = {.lex_state = 228},
  [4575] = {.lex_state = 0},
  [4576] = {.lex_state = 0},
  [4577] = {.lex_state = 0},
  [4578] = {.lex_state = 201},
  [4579] = {.lex_state = 0, .external_lex_state = 2},
  [4580] = {.lex_state = 0},
  [4581] = {.lex_state = 201},
  [4582] = {.lex_state = 0},
  [4583] = {.lex_state = 201},
  [4584] = {.lex_state = 201},
  [4585] = {.lex_state = 0},
  [4586] = {.lex_state = 0},
  [4587] = {.lex_state = 234},
  [4588] = {.lex_state = 201},
  [4589] = {.lex_state = 0, .external_lex_state = 7},
  [4590] = {.lex_state = 201},
  [4591] = {.lex_state = 223},
  [4592] = {.lex_state = 223},
  [4593] = {.lex_state = 223},
  [4594] = {.lex_state = 223},
  [4595] = {.lex_state = 201},
  [4596] = {.lex_state = 0},
  [4597] = {.lex_state = 201},
  [4598] = {.lex_state = 223},
  [4599] = {.lex_state = 223},
  [4600] = {.lex_state = 223},
  [4601] = {.lex_state = 223},
  [4602] = {.lex_state = 223},
  [4603] = {.lex_state = 223},
  [4604] = {.lex_state = 223},
  [4605] = {.lex_state = 223},
  [4606] = {.lex_state = 223},
  [4607] = {.lex_state = 223},
  [4608] = {.lex_state = 223},
  [4609] = {.lex_state = 0},
  [4610] = {.lex_state = 223},
  [4611] = {.lex_state = 223},
  [4612] = {.lex_state = 223},
  [4613] = {.lex_state = 223},
  [4614] = {.lex_state = 201},
  [4615] = {.lex_state = 0},
  [4616] = {.lex_state = 201},
  [4617] = {.lex_state = 0},
  [4618] = {.lex_state = 201},
  [4619] = {.lex_state = 201},
  [4620] = {.lex_state = 223},
  [4621] = {.lex_state = 201},
  [4622] = {.lex_state = 201},
  [4623] = {.lex_state = 201},
  [4624] = {.lex_state = 201},
  [4625] = {.lex_state = 201},
  [4626] = {.lex_state = 223},
  [4627] = {.lex_state = 201},
  [4628] = {.lex_state = 223},
  [4629] = {.lex_state = 223},
  [4630] = {.lex_state = 201},
  [4631] = {.lex_state = 223},
  [4632] = {.lex_state = 223},
  [4633] = {.lex_state = 223},
  [4634] = {.lex_state = 223},
  [4635] = {.lex_state = 228},
  [4636] = {.lex_state = 223},
  [4637] = {.lex_state = 223},
  [4638] = {.lex_state = 0},
  [4639] = {.lex_state = 223},
  [4640] = {.lex_state = 201},
  [4641] = {.lex_state = 0},
  [4642] = {.lex_state = 201},
  [4643] = {.lex_state = 223},
  [4644] = {.lex_state = 223},
  [4645] = {.lex_state = 223},
  [4646] = {.lex_state = 223},
  [4647] = {.lex_state = 223},
  [4648] = {.lex_state = 223},
  [4649] = {.lex_state = 223},
  [4650] = {.lex_state = 201},
  [4651] = {.lex_state = 223},
  [4652] = {.lex_state = 223},
  [4653] = {.lex_state = 201},
  [4654] = {.lex_state = 201},
  [4655] = {.lex_state = 223},
  [4656] = {.lex_state = 223},
  [4657] = {.lex_state = 201},
  [4658] = {.lex_state = 201},
  [4659] = {.lex_state = 201},
  [4660] = {.lex_state = 223},
  [4661] = {.lex_state = 201},
  [4662] = {.lex_state = 201},
  [4663] = {.lex_state = 223},
  [4664] = {.lex_state = 0},
  [4665] = {.lex_state = 201},
  [4666] = {.lex_state = 228},
  [4667] = {.lex_state = 201},
  [4668] = {.lex_state = 201},
  [4669] = {.lex_state = 0, .external_lex_state = 9},
  [4670] = {.lex_state = 0},
  [4671] = {.lex_state = 201, .external_lex_state = 7},
  [4672] = {.lex_state = 201},
  [4673] = {.lex_state = 223},
  [4674] = {.lex_state = 0},
  [4675] = {.lex_state = 223},
  [4676] = {.lex_state = 0, .external_lex_state = 7},
  [4677] = {.lex_state = 201},
  [4678] = {.lex_state = 201},
  [4679] = {.lex_state = 0, .external_lex_state = 7},
  [4680] = {.lex_state = 228},
  [4681] = {.lex_state = 201},
  [4682] = {.lex_state = 201},
  [4683] = {.lex_state = 0, .external_lex_state = 10},
  [4684] = {.lex_state = 201},
  [4685] = {.lex_state = 211},
  [4686] = {.lex_state = 201},
  [4687] = {.lex_state = 211},
  [4688] = {.lex_state = 215},
  [4689] = {.lex_state = 223},
  [4690] = {.lex_state = 217},
  [4691] = {.lex_state = 4},
  [4692] = {.lex_state = 0, .external_lex_state = 13},
  [4693] = {.lex_state = 223},
  [4694] = {.lex_state = 225},
  [4695] = {.lex_state = 223},
  [4696] = {.lex_state = 223},
  [4697] = {.lex_state = 201},
  [4698] = {.lex_state = 201},
  [4699] = {.lex_state = 201},
  [4700] = {.lex_state = 225},
  [4701] = {.lex_state = 201},
  [4702] = {.lex_state = 225},
  [4703] = {.lex_state = 231},
  [4704] = {.lex_state = 0},
  [4705] = {.lex_state = 0, .external_lex_state = 7},
  [4706] = {.lex_state = 0, .external_lex_state = 13},
  [4707] = {.lex_state = 223},
  [4708] = {.lex_state = 201},
  [4709] = {.lex_state = 201},
  [4710] = {.lex_state = 0, .external_lex_state = 7},
  [4711] = {.lex_state = 211},
  [4712] = {.lex_state = 201},
  [4713] = {.lex_state = 0, .external_lex_state = 7},
  [4714] = {.lex_state = 201},
  [4715] = {.lex_state = 231},
  [4716] = {.lex_state = 201},
  [4717] = {.lex_state = 201},
  [4718] = {.lex_state = 211},
  [4719] = {.lex_state = 0, .external_lex_state = 7},
  [4720] = {.lex_state = 201},
  [4721] = {.lex_state = 211},
  [4722] = {.lex_state = 225},
  [4723] = {.lex_state = 0, .external_lex_state = 7},
  [4724] = {.lex_state = 0, .external_lex_state = 7},
  [4725] = {.lex_state = 201},
  [4726] = {.lex_state = 217},
  [4727] = {.lex_state = 215},
  [4728] = {.lex_state = 225},
  [4729] = {.lex_state = 201},
  [4730] = {.lex_state = 211},
  [4731] = {.lex_state = 231},
  [4732] = {.lex_state = 201},
  [4733] = {.lex_state = 223},
  [4734] = {.lex_state = 201},
  [4735] = {.lex_state = 225},
  [4736] = {.lex_state = 549},
  [4737] = {.lex_state = 0, .external_lex_state = 7},
  [4738] = {.lex_state = 0, .external_lex_state = 7},
  [4739] = {.lex_state = 211},
  [4740] = {.lex_state = 215},
  [4741] = {.lex_state = 217},
  [4742] = {.lex_state = 215},
  [4743] = {.lex_state = 201},
  [4744] = {.lex_state = 201},
  [4745] = {.lex_state = 0, .external_lex_state = 7},
  [4746] = {.lex_state = 0, .external_lex_state = 7},
  [4747] = {.lex_state = 201},
  [4748] = {.lex_state = 217},
  [4749] = {.lex_state = 201},
  [4750] = {.lex_state = 225},
  [4751] = {.lex_state = 201},
  [4752] = {.lex_state = 201},
  [4753] = {.lex_state = 231},
  [4754] = {.lex_state = 201},
  [4755] = {.lex_state = 225},
  [4756] = {.lex_state = 201},
  [4757] = {.lex_state = 0, .external_lex_state = 7},
  [4758] = {.lex_state = 201},
  [4759] = {.lex_state = 201},
  [4760] = {.lex_state = 231},
  [4761] = {.lex_state = 0, .external_lex_state = 7},
  [4762] = {.lex_state = 223},
  [4763] = {.lex_state = 201},
  [4764] = {.lex_state = 211},
  [4765] = {.lex_state = 217},
  [4766] = {.lex_state = 215},
  [4767] = {.lex_state = 225},
  [4768] = {.lex_state = 211},
  [4769] = {.lex_state = 0, .external_lex_state = 7},
  [4770] = {.lex_state = 201},
  [4771] = {.lex_state = 0, .external_lex_state = 7},
  [4772] = {.lex_state = 0, .external_lex_state = 13},
  [4773] = {.lex_state = 201},
  [4774] = {.lex_state = 0, .external_lex_state = 7},
  [4775] = {.lex_state = 201},
  [4776] = {.lex_state = 0, .external_lex_state = 13},
  [4777] = {.lex_state = 551},
  [4778] = {.lex_state = 201},
  [4779] = {.lex_state = 201},
  [4780] = {.lex_state = 211},
  [4781] = {.lex_state = 0},
  [4782] = {.lex_state = 225},
  [4783] = {.lex_state = 211},
  [4784] = {.lex_state = 201},
  [4785] = {.lex_state = 0},
  [4786] = {.lex_state = 201},
  [4787] = {.lex_state = 223},
  [4788] = {.lex_state = 201},
  [4789] = {.lex_state = 0, .external_lex_state = 13},
  [4790] = {.lex_state = 0},
  [4791] = {.lex_state = 211},
  [4792] = {.lex_state = 231},
  [4793] = {.lex_state = 211},
  [4794] = {.lex_state = 223},
  [4795] = {.lex_state = 211},
  [4796] = {.lex_state = 211},
  [4797] = {.lex_state = 215},
  [4798] = {.lex_state = 211},
  [4799] = {.lex_state = 223},
  [4800] = {.lex_state = 211},
  [4801] = {.lex_state = 217},
  [4802] = {.lex_state = 225},
  [4803] = {.lex_state = 232},
  [4804] = {.lex_state = 201},
  [4805] = {.lex_state = 225},
  [4806] = {.lex_state = 211},
  [4807] = {.lex_state = 201},
  [4808] = {.lex_state = 201},
  [4809] = {.lex_state = 201},
  [4810] = {.lex_state = 201},
  [4811] = {.lex_state = 211},
  [4812] = {.lex_state = 211},
  [4813] = {.lex_state = 211},
  [4814] = {.lex_state = 201},
  [4815] = {.lex_state = 201},
  [4816] = {.lex_state = 201},
  [4817] = {.lex_state = 201},
  [4818] = {.lex_state = 0, .external_lex_state = 7},
  [4819] = {.lex_state = 211},
  [4820] = {.lex_state = 201},
  [4821] = {.lex_state = 201},
  [4822] = {.lex_state = 211},
  [4823] = {.lex_state = 231},
  [4824] = {.lex_state = 201},
  [4825] = {.lex_state = 223},
  [4826] = {.lex_state = 201},
  [4827] = {.lex_state = 201},
  [4828] = {.lex_state = 211},
  [4829] = {.lex_state = 223},
  [4830] = {.lex_state = 223},
  [4831] = {.lex_state = 201},
  [4832] = {.lex_state = 211},
  [4833] = {.lex_state = 211},
  [4834] = {.lex_state = 201},
  [4835] = {.lex_state = 201},
  [4836] = {.lex_state = 211},
  [4837] = {.lex_state = 211},
  [4838] = {.lex_state = 211},
  [4839] = {.lex_state = 225},
  [4840] = {.lex_state = 211},
  [4841] = {.lex_state = 231},
  [4842] = {.lex_state = 231},
  [4843] = {.lex_state = 201},
  [4844] = {.lex_state = 201},
  [4845] = {.lex_state = 201},
  [4846] = {.lex_state = 211},
  [4847] = {.lex_state = 211},
  [4848] = {.lex_state = 201},
  [4849] = {.lex_state = 201},
  [4850] = {.lex_state = 0, .external_lex_state = 13},
  [4851] = {.lex_state = 223},
  [4852] = {.lex_state = 217},
  [4853] = {.lex_state = 201},
  [4854] = {.lex_state = 211},
  [4855] = {.lex_state = 223},
  [4856] = {.lex_state = 223},
  [4857] = {.lex_state = 201},
  [4858] = {.lex_state = 215},
  [4859] = {.lex_state = 211},
  [4860] = {.lex_state = 211},
  [4861] = {.lex_state = 223},
  [4862] = {.lex_state = 231},
  [4863] = {.lex_state = 201},
  [4864] = {.lex_state = 201},
  [4865] = {.lex_state = 231},
  [4866] = {.lex_state = 225},
  [4867] = {.lex_state = 201},
  [4868] = {.lex_state = 223},
  [4869] = {.lex_state = 223},
  [4870] = {.lex_state = 223},
  [4871] = {.lex_state = 231},
  [4872] = {.lex_state = 211},
  [4873] = {.lex_state = 211},
  [4874] = {.lex_state = 223},
  [4875] = {.lex_state = 223},
  [4876] = {.lex_state = 201},
  [4877] = {.lex_state = 201},
  [4878] = {.lex_state = 231},
  [4879] = {.lex_state = 201},
  [4880] = {.lex_state = 211},
  [4881] = {.lex_state = 211},
  [4882] = {.lex_state = 211},
  [4883] = {.lex_state = 0},
  [4884] = {.lex_state = 201},
  [4885] = {.lex_state = 223},
  [4886] = {.lex_state = 201},
  [4887] = {.lex_state = 201},
  [4888] = {.lex_state = 201},
  [4889] = {.lex_state = 223},
  [4890] = {.lex_state = 223},
  [4891] = {.lex_state = 201},
  [4892] = {.lex_state = 211},
  [4893] = {.lex_state = 201},
  [4894] = {.lex_state = 211},
  [4895] = {.lex_state = 201},
  [4896] = {.lex_state = 201},
  [4897] = {.lex_state = 0, .external_lex_state = 7},
  [4898] = {.lex_state = 223},
  [4899] = {.lex_state = 201},
  [4900] = {.lex_state = 551},
  [4901] = {.lex_state = 201},
  [4902] = {.lex_state = 223},
  [4903] = {.lex_state = 223},
  [4904] = {.lex_state = 201},
  [4905] = {.lex_state = 211},
  [4906] = {.lex_state = 211},
  [4907] = {.lex_state = 211},
  [4908] = {.lex_state = 211},
  [4909] = {.lex_state = 201},
  [4910] = {.lex_state = 223},
  [4911] = {.lex_state = 211},
  [4912] = {.lex_state = 211},
  [4913] = {.lex_state = 211},
  [4914] = {.lex_state = 223},
  [4915] = {.lex_state = 223},
  [4916] = {.lex_state = 211},
  [4917] = {.lex_state = 211},
  [4918] = {.lex_state = 215},
  [4919] = {.lex_state = 201},
  [4920] = {.lex_state = 217},
  [4921] = {.lex_state = 201},
  [4922] = {.lex_state = 223},
  [4923] = {.lex_state = 201},
  [4924] = {.lex_state = 223},
  [4925] = {.lex_state = 211},
  [4926] = {.lex_state = 223},
  [4927] = {.lex_state = 223},
  [4928] = {.lex_state = 201},
  [4929] = {.lex_state = 223},
  [4930] = {.lex_state = 211},
  [4931] = {.lex_state = 223},
  [4932] = {.lex_state = 217},
  [4933] = {.lex_state = 201},
  [4934] = {.lex_state = 223},
  [4935] = {.lex_state = 201},
  [4936] = {.lex_state = 211},
  [4937] = {.lex_state = 215},
  [4938] = {.lex_state = 223},
  [4939] = {.lex_state = 223},
  [4940] = {.lex_state = 211},
  [4941] = {.lex_state = 217},
  [4942] = {.lex_state = 215},
  [4943] = {.lex_state = 211},
  [4944] = {.lex_state = 0, .external_lex_state = 13},
  [4945] = {.lex_state = 225},
  [4946] = {.lex_state = 223},
  [4947] = {.lex_state = 211},
  [4948] = {.lex_state = 211},
  [4949] = {.lex_state = 211},
  [4950] = {.lex_state = 223},
  [4951] = {.lex_state = 223},
  [4952] = {.lex_state = 211},
  [4953] = {.lex_state = 211},
  [4954] = {.lex_state = 201},
  [4955] = {.lex_state = 211},
  [4956] = {.lex_state = 201},
  [4957] = {.lex_state = 201},
  [4958] = {.lex_state = 223},
  [4959] = {.lex_state = 201},
  [4960] = {.lex_state = 211},
  [4961] = {.lex_state = 211},
  [4962] = {.lex_state = 223},
  [4963] = {.lex_state = 223},
  [4964] = {.lex_state = 211},
  [4965] = {.lex_state = 211},
  [4966] = {.lex_state = 211},
  [4967] = {.lex_state = 211},
  [4968] = {.lex_state = 201},
  [4969] = {.lex_state = 211},
  [4970] = {.lex_state = 223},
  [4971] = {.lex_state = 201},
  [4972] = {.lex_state = 211},
  [4973] = {.lex_state = 211},
  [4974] = {.lex_state = 223},
  [4975] = {.lex_state = 223},
  [4976] = {.lex_state = 211},
  [4977] = {.lex_state = 211},
  [4978] = {.lex_state = 211},
  [4979] = {.lex_state = 211},
  [4980] = {.lex_state = 201},
  [4981] = {.lex_state = 201},
  [4982] = {.lex_state = 223},
  [4983] = {.lex_state = 0},
  [4984] = {.lex_state = 211},
  [4985] = {.lex_state = 211},
  [4986] = {.lex_state = 223},
  [4987] = {.lex_state = 223},
  [4988] = {.lex_state = 211},
  [4989] = {.lex_state = 201},
  [4990] = {.lex_state = 211},
  [4991] = {.lex_state = 217},
  [4992] = {.lex_state = 215},
  [4993] = {.lex_state = 211},
  [4994] = {.lex_state = 223},
  [4995] = {.lex_state = 211},
  [4996] = {.lex_state = 223},
  [4997] = {.lex_state = 211},
  [4998] = {.lex_state = 223},
  [4999] = {.lex_state = 223},
  [5000] = {.lex_state = 211},
  [5001] = {.lex_state = 211},
  [5002] = {.lex_state = 211},
  [5003] = {.lex_state = 211},
  [5004] = {.lex_state = 231},
  [5005] = {.lex_state = 215},
  [5006] = {.lex_state = 223},
  [5007] = {.lex_state = 223},
  [5008] = {.lex_state = 217},
  [5009] = {.lex_state = 201},
  [5010] = {.lex_state = 223},
  [5011] = {.lex_state = 223},
  [5012] = {.lex_state = 211},
  [5013] = {.lex_state = 0},
  [5014] = {.lex_state = 201},
  [5015] = {.lex_state = 0, .external_lex_state = 7},
  [5016] = {.lex_state = 201},
  [5017] = {.lex_state = 0, .external_lex_state = 7},
  [5018] = {.lex_state = 0, .external_lex_state = 13},
  [5019] = {.lex_state = 223},
  [5020] = {.lex_state = 223},
  [5021] = {.lex_state = 223},
  [5022] = {.lex_state = 223},
  [5023] = {.lex_state = 223},
  [5024] = {.lex_state = 223},
  [5025] = {.lex_state = 223},
  [5026] = {.lex_state = 223},
  [5027] = {.lex_state = 225},
  [5028] = {.lex_state = 223},
  [5029] = {.lex_state = 223},
  [5030] = {.lex_state = 223},
  [5031] = {.lex_state = 201},
  [5032] = {.lex_state = 232},
  [5033] = {.lex_state = 223},
  [5034] = {.lex_state = 223},
  [5035] = {.lex_state = 201},
  [5036] = {.lex_state = 201},
  [5037] = {.lex_state = 201},
  [5038] = {.lex_state = 201},
  [5039] = {.lex_state = 223},
  [5040] = {.lex_state = 223},
  [5041] = {.lex_state = 223},
  [5042] = {.lex_state = 223},
  [5043] = {.lex_state = 201},
  [5044] = {.lex_state = 217},
  [5045] = {.lex_state = 223},
  [5046] = {.lex_state = 223},
  [5047] = {.lex_state = 223},
  [5048] = {.lex_state = 215},
  [5049] = {.lex_state = 223},
  [5050] = {.lex_state = 201},
  [5051] = {.lex_state = 201},
  [5052] = {.lex_state = 211},
  [5053] = {.lex_state = 201},
  [5054] = {.lex_state = 201},
  [5055] = {.lex_state = 223},
  [5056] = {.lex_state = 225},
  [5057] = {.lex_state = 223},
  [5058] = {.lex_state = 0},
  [5059] = {.lex_state = 223},
  [5060] = {.lex_state = 201},
  [5061] = {.lex_state = 223},
  [5062] = {.lex_state = 223},
  [5063] = {.lex_state = 223},
  [5064] = {.lex_state = 201},
  [5065] = {.lex_state = 223},
  [5066] = {.lex_state = 201},
  [5067] = {.lex_state = 223},
  [5068] = {.lex_state = 211},
  [5069] = {.lex_state = 215},
  [5070] = {.lex_state = 201},
  [5071] = {.lex_state = 217},
  [5072] = {.lex_state = 201},
  [5073] = {.lex_state = 223},
  [5074] = {.lex_state = 223},
  [5075] = {.lex_state = 201},
  [5076] = {.lex_state = 0, .external_lex_state = 13},
  [5077] = {.lex_state = 0, .external_lex_state = 14},
  [5078] = {.lex_state = 0},
  [5079] = {.lex_state = 223},
  [5080] = {.lex_state = 0},
  [5081] = {.lex_state = 201},
  [5082] = {.lex_state = 201},
  [5083] = {.lex_state = 231},
  [5084] = {.lex_state = 231},
  [5085] = {.lex_state = 223},
  [5086] = {.lex_state = 223},
  [5087] = {.lex_state = 223},
  [5088] = {.lex_state = 201},
  [5089] = {.lex_state = 223},
  [5090] = {.lex_state = 211},
  [5091] = {.lex_state = 201},
  [5092] = {.lex_state = 549},
  [5093] = {.lex_state = 223},
  [5094] = {.lex_state = 223},
  [5095] = {.lex_state = 223},
  [5096] = {.lex_state = 223},
  [5097] = {.lex_state = 215},
  [5098] = {.lex_state = 223},
  [5099] = {.lex_state = 223},
  [5100] = {.lex_state = 217},
  [5101] = {.lex_state = 223},
  [5102] = {.lex_state = 223},
  [5103] = {.lex_state = 201},
  [5104] = {.lex_state = 223},
  [5105] = {.lex_state = 223},
  [5106] = {.lex_state = 201},
  [5107] = {.lex_state = 223},
  [5108] = {.lex_state = 223},
  [5109] = {.lex_state = 201},
  [5110] = {.lex_state = 223},
  [5111] = {.lex_state = 223},
  [5112] = {.lex_state = 0, .external_lex_state = 7},
  [5113] = {.lex_state = 223},
  [5114] = {.lex_state = 223},
  [5115] = {.lex_state = 223},
  [5116] = {.lex_state = 223},
  [5117] = {.lex_state = 223},
  [5118] = {.lex_state = 201},
  [5119] = {.lex_state = 223},
  [5120] = {.lex_state = 223},
  [5121] = {.lex_state = 201},
  [5122] = {.lex_state = 223},
  [5123] = {.lex_state = 223},
  [5124] = {.lex_state = 201},
  [5125] = {.lex_state = 223},
  [5126] = {.lex_state = 223},
  [5127] = {.lex_state = 0, .external_lex_state = 13},
  [5128] = {.lex_state = 223},
  [5129] = {.lex_state = 223},
  [5130] = {.lex_state = 225},
  [5131] = {.lex_state = 223},
  [5132] = {.lex_state = 223},
  [5133] = {.lex_state = 201},
  [5134] = {.lex_state = 223},
  [5135] = {.lex_state = 223},
  [5136] = {.lex_state = 211},
  [5137] = {(TSStateId)(-1)},
  [5138] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_extramodular_text = 0,
  ts_external_token__indent = 1,
  ts_external_token_bullet_conj = 2,
  ts_external_token_bullet_disj = 3,
  ts_external_token__dedent = 4,
  ts_external_token__begin_proof = 5,
  ts_external_token__begin_proof_step = 6,
  ts_external_token_PROOF = 7,
  ts_external_token_BY = 8,
  ts_external_token_OBVIOUS = 9,
  ts_external_token_OMITTED = 10,
  ts_external_token_QED = 11,
  ts_external_token_WF_ = 12,
  ts_external_token_SF_ = 13,
  ts_external_token__notify_pcal_algorithm_start = 14,
  ts_external_token__notify_pcal_algorithm_end = 15,
  ts_external_token__error_sentinel = 16,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_extramodular_text] = sym_extramodular_text,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token_bullet_conj] = sym_bullet_conj,
  [ts_external_token_bullet_disj] = sym_bullet_disj,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__begin_proof] = sym__begin_proof,
  [ts_external_token__begin_proof_step] = sym__begin_proof_step,
  [ts_external_token_PROOF] = anon_sym_PROOF,
  [ts_external_token_BY] = anon_sym_BY,
  [ts_external_token_OBVIOUS] = anon_sym_OBVIOUS,
  [ts_external_token_OMITTED] = anon_sym_OMITTED,
  [ts_external_token_QED] = anon_sym_QED,
  [ts_external_token_WF_] = anon_sym_WF_,
  [ts_external_token_SF_] = anon_sym_SF_,
  [ts_external_token__notify_pcal_algorithm_start] = sym__notify_pcal_algorithm_start,
  [ts_external_token__notify_pcal_algorithm_end] = sym__notify_pcal_algorithm_end,
  [ts_external_token__error_sentinel] = sym__error_sentinel,
};

static const bool ts_external_scanner_states[15][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_extramodular_text] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_PROOF] = true,
    [ts_external_token_BY] = true,
    [ts_external_token_OBVIOUS] = true,
    [ts_external_token_OMITTED] = true,
    [ts_external_token_QED] = true,
    [ts_external_token_WF_] = true,
    [ts_external_token_SF_] = true,
    [ts_external_token__notify_pcal_algorithm_start] = true,
    [ts_external_token__notify_pcal_algorithm_end] = true,
    [ts_external_token__error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_extramodular_text] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token_QED] = true,
    [ts_external_token_WF_] = true,
    [ts_external_token_SF_] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
    [ts_external_token_WF_] = true,
    [ts_external_token_SF_] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_WF_] = true,
    [ts_external_token_SF_] = true,
  },
  [6] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_PROOF] = true,
    [ts_external_token_BY] = true,
    [ts_external_token_OBVIOUS] = true,
    [ts_external_token_OMITTED] = true,
  },
  [7] = {
    [ts_external_token__begin_proof_step] = true,
  },
  [8] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_PROOF] = true,
    [ts_external_token_BY] = true,
    [ts_external_token_OBVIOUS] = true,
    [ts_external_token_OMITTED] = true,
  },
  [9] = {
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
  },
  [10] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token__dedent] = true,
  },
  [11] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
  },
  [12] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_BY] = true,
    [ts_external_token_OBVIOUS] = true,
    [ts_external_token_OMITTED] = true,
  },
  [13] = {
    [ts_external_token__notify_pcal_algorithm_end] = true,
  },
  [14] = {
    [ts_external_token__notify_pcal_algorithm_start] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [aux_sym_block_comment_text_token2] = ACTIONS(1),
    [aux_sym_block_comment_text_token3] = ACTIONS(1),
    [aux_sym_block_comment_text_token4] = ACTIONS(1),
    [anon_sym_MODULE] = ACTIONS(1),
    [sym_single_line] = ACTIONS(1),
    [sym_double_line] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_BSLASHAA] = ACTIONS(1),
    [anon_sym_BSLASHEE] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_8] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_9] = ACTIONS(1),
    [anon_sym_10] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_11] = ACTIONS(1),
    [anon_sym_12] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_13] = ACTIONS(1),
    [anon_sym_14] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym__2] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_15] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_16] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_ENABLED] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_SUBSET] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_INSTANCE] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_DOMAIN] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_UNCHANGED] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_DEFINE] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHB] = ACTIONS(1),
    [aux_sym_binary_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHO] = ACTIONS(1),
    [aux_sym_octal_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHh] = ACTIONS(1),
    [anon_sym_BSLASHH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [sym_string_set] = ACTIONS(1),
    [sym_boolean_set] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_17] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_18] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_19] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_20] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_21] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_22] = ACTIONS(1),
    [anon_sym_23] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_24] = ACTIONS(1),
    [anon_sym_25] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_26] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_27] = ACTIONS(1),
    [anon_sym_28] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_29] = ACTIONS(1),
    [anon_sym_30] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_31] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_32] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_33] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_34] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_35] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_36] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_37] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_38] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_39] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_40] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_41] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_42] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_43] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_44] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_45] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_46] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_47] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_48] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_49] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_50] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_51] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_52] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_53] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_54] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_55] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_56] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_57] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_58] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_59] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_60] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_61] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_62] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_63] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_64] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_65] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_66] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_67] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_68] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_69] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_70] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_71] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_72] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_73] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_74] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_75] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_76] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_77] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_78] = ACTIONS(1),
    [anon_sym_BANG_BANG] = ACTIONS(1),
    [anon_sym_79] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_80] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_81] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_82] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_83] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_84] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_85] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_86] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_87] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [aux_sym_proof_step_id_token1] = ACTIONS(1),
    [aux_sym_proof_step_ref_token1] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_algorithm] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_procedure] = ACTIONS(1),
    [anon_sym_fair] = ACTIONS(1),
    [anon_sym_process] = ACTIONS(1),
    [anon_sym_variable] = ACTIONS(1),
    [anon_sym_variables] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_either] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_skip] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [sym_extramodular_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym_bullet_conj] = ACTIONS(1),
    [sym_bullet_disj] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym__notify_pcal_algorithm_start] = ACTIONS(1),
    [sym__notify_pcal_algorithm_end] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(5078),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(4145),
    [aux_sym_source_file_repeat1] = STATE(3913),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(7),
    [sym_extramodular_text] = ACTIONS(9),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(3691),
    [sym_exists] = STATE(3691),
    [sym_temporal_forall] = STATE(4699),
    [sym_temporal_exists] = STATE(4699),
    [sym_langle_bracket] = STATE(116),
    [sym_operator_definition] = STATE(3628),
    [sym_function_definition] = STATE(3628),
    [sym_instance] = STATE(4818),
    [sym_subexpr_prefix] = STATE(1196),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2664),
    [sym_bound_nonfix_op] = STATE(2664),
    [sym_module_definition] = STATE(3628),
    [sym__expr] = STATE(1387),
    [sym_prefixed_op] = STATE(2816),
    [sym__number] = STATE(2816),
    [sym_nat_number] = STATE(2822),
    [sym_binary_number] = STATE(2822),
    [sym_octal_number] = STATE(2822),
    [sym_hex_number] = STATE(2822),
    [sym_string] = STATE(2816),
    [sym_boolean] = STATE(2816),
    [sym__primitive_value_set] = STATE(2816),
    [sym_nat_number_set] = STATE(2824),
    [sym_int_number_set] = STATE(2824),
    [sym_real_number_set] = STATE(2824),
    [sym_label] = STATE(2816),
    [sym_subexpression] = STATE(2816),
    [sym_parentheses] = STATE(2816),
    [sym_bounded_quantification] = STATE(2816),
    [sym_unbounded_quantification] = STATE(2816),
    [sym_choose] = STATE(2816),
    [sym_finite_set_literal] = STATE(2816),
    [sym_set_filter] = STATE(2816),
    [sym_set_map] = STATE(2816),
    [sym_function_evaluation] = STATE(2816),
    [sym_function_literal] = STATE(2816),
    [sym_set_of_functions] = STATE(2816),
    [sym_record_literal] = STATE(2816),
    [sym_set_of_records] = STATE(2816),
    [sym_record_value] = STATE(2816),
    [sym_except] = STATE(2816),
    [sym_prev_func_val] = STATE(2816),
    [sym_tuple_literal] = STATE(2816),
    [sym_step_expr_or_stutter] = STATE(2816),
    [sym_step_expr_no_stutter] = STATE(2816),
    [sym_fairness] = STATE(2816),
    [sym_if_then_else] = STATE(2816),
    [sym_case] = STATE(2816),
    [sym_let_in] = STATE(2816),
    [sym_conj_list] = STATE(2816),
    [sym_disj_list] = STATE(2816),
    [sym_lnot] = STATE(216),
    [sym_union] = STATE(217),
    [sym_powerset] = STATE(217),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(1019),
    [sym_enabled] = STATE(222),
    [sym_unchanged] = STATE(222),
    [sym_always] = STATE(222),
    [sym_eventually] = STATE(222),
    [sym_prefix_op_symbol] = STATE(4523),
    [sym_bound_prefix_op] = STATE(2816),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2816),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4643),
    [sym_bound_postfix_op] = STATE(2816),
    [sym_assume_prove] = STATE(3663),
    [sym_definition_proof_step] = STATE(4818),
    [sym_have_proof_step] = STATE(4818),
    [sym_witness_proof_step] = STATE(4818),
    [sym_take_proof_step] = STATE(4818),
    [sym_suffices_proof_step] = STATE(4818),
    [sym_case_proof_step] = STATE(4818),
    [sym_pick_proof_step] = STATE(4818),
    [sym_use_or_hide] = STATE(4818),
    [sym_proof_step_ref] = STATE(2680),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_QED] = ACTIONS(61),
    [anon_sym_TAKE] = ACTIONS(63),
    [anon_sym_HIDE] = ACTIONS(65),
    [anon_sym_USE] = ACTIONS(67),
    [anon_sym_DEFINE] = ACTIONS(69),
    [anon_sym_WITNESS] = ACTIONS(71),
    [anon_sym_PICK] = ACTIONS(73),
    [anon_sym_SUFFICES] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(77),
    [anon_sym_LBRACK] = ACTIONS(79),
    [aux_sym_child_id_token1] = ACTIONS(81),
    [sym_real_number] = ACTIONS(83),
    [anon_sym_BSLASHb] = ACTIONS(85),
    [anon_sym_BSLASHB] = ACTIONS(87),
    [anon_sym_BSLASHo] = ACTIONS(89),
    [anon_sym_BSLASHO] = ACTIONS(91),
    [anon_sym_BSLASHh] = ACTIONS(93),
    [anon_sym_BSLASHH] = ACTIONS(93),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_TRUE] = ACTIONS(97),
    [anon_sym_FALSE] = ACTIONS(97),
    [sym_string_set] = ACTIONS(99),
    [sym_boolean_set] = ACTIONS(99),
    [anon_sym_Nat] = ACTIONS(101),
    [anon_sym_17] = ACTIONS(103),
    [anon_sym_Int] = ACTIONS(105),
    [anon_sym_18] = ACTIONS(107),
    [anon_sym_Real] = ACTIONS(109),
    [anon_sym_19] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(149),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(265),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(3691),
    [sym_exists] = STATE(3691),
    [sym_temporal_forall] = STATE(4699),
    [sym_temporal_exists] = STATE(4699),
    [sym_langle_bracket] = STATE(116),
    [sym_operator_definition] = STATE(3628),
    [sym_function_definition] = STATE(3628),
    [sym_instance] = STATE(4818),
    [sym_subexpr_prefix] = STATE(1196),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2664),
    [sym_bound_nonfix_op] = STATE(2664),
    [sym_module_definition] = STATE(3628),
    [sym__expr] = STATE(1387),
    [sym_prefixed_op] = STATE(2816),
    [sym__number] = STATE(2816),
    [sym_nat_number] = STATE(2822),
    [sym_binary_number] = STATE(2822),
    [sym_octal_number] = STATE(2822),
    [sym_hex_number] = STATE(2822),
    [sym_string] = STATE(2816),
    [sym_boolean] = STATE(2816),
    [sym__primitive_value_set] = STATE(2816),
    [sym_nat_number_set] = STATE(2824),
    [sym_int_number_set] = STATE(2824),
    [sym_real_number_set] = STATE(2824),
    [sym_label] = STATE(2816),
    [sym_subexpression] = STATE(2816),
    [sym_parentheses] = STATE(2816),
    [sym_bounded_quantification] = STATE(2816),
    [sym_unbounded_quantification] = STATE(2816),
    [sym_choose] = STATE(2816),
    [sym_finite_set_literal] = STATE(2816),
    [sym_set_filter] = STATE(2816),
    [sym_set_map] = STATE(2816),
    [sym_function_evaluation] = STATE(2816),
    [sym_function_literal] = STATE(2816),
    [sym_set_of_functions] = STATE(2816),
    [sym_record_literal] = STATE(2816),
    [sym_set_of_records] = STATE(2816),
    [sym_record_value] = STATE(2816),
    [sym_except] = STATE(2816),
    [sym_prev_func_val] = STATE(2816),
    [sym_tuple_literal] = STATE(2816),
    [sym_step_expr_or_stutter] = STATE(2816),
    [sym_step_expr_no_stutter] = STATE(2816),
    [sym_fairness] = STATE(2816),
    [sym_if_then_else] = STATE(2816),
    [sym_case] = STATE(2816),
    [sym_let_in] = STATE(2816),
    [sym_conj_list] = STATE(2816),
    [sym_disj_list] = STATE(2816),
    [sym_lnot] = STATE(216),
    [sym_union] = STATE(217),
    [sym_powerset] = STATE(217),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(1019),
    [sym_enabled] = STATE(222),
    [sym_unchanged] = STATE(222),
    [sym_always] = STATE(222),
    [sym_eventually] = STATE(222),
    [sym_prefix_op_symbol] = STATE(4523),
    [sym_bound_prefix_op] = STATE(2816),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2816),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4643),
    [sym_bound_postfix_op] = STATE(2816),
    [sym_assume_prove] = STATE(3663),
    [sym_definition_proof_step] = STATE(4818),
    [sym_have_proof_step] = STATE(4818),
    [sym_witness_proof_step] = STATE(4818),
    [sym_take_proof_step] = STATE(4818),
    [sym_suffices_proof_step] = STATE(4818),
    [sym_case_proof_step] = STATE(4818),
    [sym_pick_proof_step] = STATE(4818),
    [sym_use_or_hide] = STATE(4818),
    [sym_proof_step_ref] = STATE(2680),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_QED] = ACTIONS(267),
    [anon_sym_TAKE] = ACTIONS(63),
    [anon_sym_HIDE] = ACTIONS(65),
    [anon_sym_USE] = ACTIONS(67),
    [anon_sym_DEFINE] = ACTIONS(69),
    [anon_sym_WITNESS] = ACTIONS(71),
    [anon_sym_PICK] = ACTIONS(73),
    [anon_sym_SUFFICES] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(77),
    [anon_sym_LBRACK] = ACTIONS(79),
    [aux_sym_child_id_token1] = ACTIONS(81),
    [sym_real_number] = ACTIONS(83),
    [anon_sym_BSLASHb] = ACTIONS(85),
    [anon_sym_BSLASHB] = ACTIONS(87),
    [anon_sym_BSLASHo] = ACTIONS(89),
    [anon_sym_BSLASHO] = ACTIONS(91),
    [anon_sym_BSLASHh] = ACTIONS(93),
    [anon_sym_BSLASHH] = ACTIONS(93),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_TRUE] = ACTIONS(97),
    [anon_sym_FALSE] = ACTIONS(97),
    [sym_string_set] = ACTIONS(99),
    [sym_boolean_set] = ACTIONS(99),
    [anon_sym_Nat] = ACTIONS(101),
    [anon_sym_17] = ACTIONS(103),
    [anon_sym_Int] = ACTIONS(105),
    [anon_sym_18] = ACTIONS(107),
    [anon_sym_Real] = ACTIONS(109),
    [anon_sym_19] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(149),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(265),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(3691),
    [sym_exists] = STATE(3691),
    [sym_temporal_forall] = STATE(4699),
    [sym_temporal_exists] = STATE(4699),
    [sym_langle_bracket] = STATE(116),
    [sym_operator_definition] = STATE(3628),
    [sym_function_definition] = STATE(3628),
    [sym_instance] = STATE(4818),
    [sym_subexpr_prefix] = STATE(1196),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2664),
    [sym_bound_nonfix_op] = STATE(2664),
    [sym_module_definition] = STATE(3628),
    [sym__expr] = STATE(1387),
    [sym_prefixed_op] = STATE(2816),
    [sym__number] = STATE(2816),
    [sym_nat_number] = STATE(2822),
    [sym_binary_number] = STATE(2822),
    [sym_octal_number] = STATE(2822),
    [sym_hex_number] = STATE(2822),
    [sym_string] = STATE(2816),
    [sym_boolean] = STATE(2816),
    [sym__primitive_value_set] = STATE(2816),
    [sym_nat_number_set] = STATE(2824),
    [sym_int_number_set] = STATE(2824),
    [sym_real_number_set] = STATE(2824),
    [sym_label] = STATE(2816),
    [sym_subexpression] = STATE(2816),
    [sym_parentheses] = STATE(2816),
    [sym_bounded_quantification] = STATE(2816),
    [sym_unbounded_quantification] = STATE(2816),
    [sym_choose] = STATE(2816),
    [sym_finite_set_literal] = STATE(2816),
    [sym_set_filter] = STATE(2816),
    [sym_set_map] = STATE(2816),
    [sym_function_evaluation] = STATE(2816),
    [sym_function_literal] = STATE(2816),
    [sym_set_of_functions] = STATE(2816),
    [sym_record_literal] = STATE(2816),
    [sym_set_of_records] = STATE(2816),
    [sym_record_value] = STATE(2816),
    [sym_except] = STATE(2816),
    [sym_prev_func_val] = STATE(2816),
    [sym_tuple_literal] = STATE(2816),
    [sym_step_expr_or_stutter] = STATE(2816),
    [sym_step_expr_no_stutter] = STATE(2816),
    [sym_fairness] = STATE(2816),
    [sym_if_then_else] = STATE(2816),
    [sym_case] = STATE(2816),
    [sym_let_in] = STATE(2816),
    [sym_conj_list] = STATE(2816),
    [sym_disj_list] = STATE(2816),
    [sym_lnot] = STATE(216),
    [sym_union] = STATE(217),
    [sym_powerset] = STATE(217),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(1019),
    [sym_enabled] = STATE(222),
    [sym_unchanged] = STATE(222),
    [sym_always] = STATE(222),
    [sym_eventually] = STATE(222),
    [sym_prefix_op_symbol] = STATE(4523),
    [sym_bound_prefix_op] = STATE(2816),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2816),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4643),
    [sym_bound_postfix_op] = STATE(2816),
    [sym_assume_prove] = STATE(3663),
    [sym_definition_proof_step] = STATE(4818),
    [sym_have_proof_step] = STATE(4818),
    [sym_witness_proof_step] = STATE(4818),
    [sym_take_proof_step] = STATE(4818),
    [sym_suffices_proof_step] = STATE(4818),
    [sym_case_proof_step] = STATE(4818),
    [sym_pick_proof_step] = STATE(4818),
    [sym_use_or_hide] = STATE(4818),
    [sym_proof_step_ref] = STATE(2680),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(63),
    [anon_sym_HIDE] = ACTIONS(65),
    [anon_sym_USE] = ACTIONS(67),
    [anon_sym_DEFINE] = ACTIONS(69),
    [anon_sym_WITNESS] = ACTIONS(71),
    [anon_sym_PICK] = ACTIONS(73),
    [anon_sym_SUFFICES] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(77),
    [anon_sym_LBRACK] = ACTIONS(79),
    [aux_sym_child_id_token1] = ACTIONS(81),
    [sym_real_number] = ACTIONS(83),
    [anon_sym_BSLASHb] = ACTIONS(85),
    [anon_sym_BSLASHB] = ACTIONS(87),
    [anon_sym_BSLASHo] = ACTIONS(89),
    [anon_sym_BSLASHO] = ACTIONS(91),
    [anon_sym_BSLASHh] = ACTIONS(93),
    [anon_sym_BSLASHH] = ACTIONS(93),
    [anon_sym_DQUOTE] = ACTIONS(95),
    [anon_sym_TRUE] = ACTIONS(97),
    [anon_sym_FALSE] = ACTIONS(97),
    [sym_string_set] = ACTIONS(99),
    [sym_boolean_set] = ACTIONS(99),
    [anon_sym_Nat] = ACTIONS(101),
    [anon_sym_17] = ACTIONS(103),
    [anon_sym_Int] = ACTIONS(105),
    [anon_sym_18] = ACTIONS(107),
    [anon_sym_Real] = ACTIONS(109),
    [anon_sym_19] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(149),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(265),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1069),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(151),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1073),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(151),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1066),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(151),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1068),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(151),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3688),
    [sym_exists] = STATE(3688),
    [sym_temporal_forall] = STATE(5038),
    [sym_temporal_exists] = STATE(5038),
    [sym_langle_bracket] = STATE(38),
    [sym_subexpr_prefix] = STATE(1190),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2277),
    [sym_bound_nonfix_op] = STATE(2277),
    [sym__expr] = STATE(1722),
    [sym_prefixed_op] = STATE(2308),
    [sym__number] = STATE(2308),
    [sym_nat_number] = STATE(2307),
    [sym_binary_number] = STATE(2307),
    [sym_octal_number] = STATE(2307),
    [sym_hex_number] = STATE(2307),
    [sym_string] = STATE(2308),
    [sym_boolean] = STATE(2308),
    [sym__primitive_value_set] = STATE(2308),
    [sym_nat_number_set] = STATE(2287),
    [sym_int_number_set] = STATE(2287),
    [sym_real_number_set] = STATE(2287),
    [sym_label] = STATE(2308),
    [sym_subexpression] = STATE(2308),
    [sym_parentheses] = STATE(2308),
    [sym_bounded_quantification] = STATE(2308),
    [sym_unbounded_quantification] = STATE(2308),
    [sym_choose] = STATE(2308),
    [sym_finite_set_literal] = STATE(2308),
    [sym_set_filter] = STATE(2308),
    [sym_set_map] = STATE(2308),
    [sym_function_evaluation] = STATE(2308),
    [sym_function_literal] = STATE(2308),
    [sym_set_of_functions] = STATE(2308),
    [sym_record_literal] = STATE(2308),
    [sym_set_of_records] = STATE(2308),
    [sym_record_value] = STATE(2308),
    [sym_except] = STATE(2308),
    [sym_prev_func_val] = STATE(2308),
    [sym_tuple_literal] = STATE(2308),
    [sym_step_expr_or_stutter] = STATE(2308),
    [sym_step_expr_no_stutter] = STATE(2308),
    [sym_fairness] = STATE(2308),
    [sym_if_then_else] = STATE(2308),
    [sym_case] = STATE(2308),
    [sym_let_in] = STATE(2308),
    [sym_conj_list] = STATE(2308),
    [sym_disj_list] = STATE(2308),
    [sym_lnot] = STATE(74),
    [sym_union] = STATE(71),
    [sym_powerset] = STATE(71),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(457),
    [sym_enabled] = STATE(62),
    [sym_unchanged] = STATE(62),
    [sym_always] = STATE(62),
    [sym_eventually] = STATE(62),
    [sym_prefix_op_symbol] = STATE(4629),
    [sym_bound_prefix_op] = STATE(2308),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4628),
    [sym_bound_infix_op] = STATE(2308),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4629),
    [sym_bound_postfix_op] = STATE(2308),
    [sym_assume_prove] = STATE(4682),
    [sym_inner_assume_prove] = STATE(4392),
    [sym_new] = STATE(4392),
    [sym_level] = STATE(3437),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(421),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(3688),
    [sym_exists] = STATE(3688),
    [sym_temporal_forall] = STATE(5038),
    [sym_temporal_exists] = STATE(5038),
    [sym_langle_bracket] = STATE(38),
    [sym_subexpr_prefix] = STATE(1190),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2277),
    [sym_bound_nonfix_op] = STATE(2277),
    [sym__expr] = STATE(1717),
    [sym_prefixed_op] = STATE(2308),
    [sym__number] = STATE(2308),
    [sym_nat_number] = STATE(2307),
    [sym_binary_number] = STATE(2307),
    [sym_octal_number] = STATE(2307),
    [sym_hex_number] = STATE(2307),
    [sym_string] = STATE(2308),
    [sym_boolean] = STATE(2308),
    [sym__primitive_value_set] = STATE(2308),
    [sym_nat_number_set] = STATE(2287),
    [sym_int_number_set] = STATE(2287),
    [sym_real_number_set] = STATE(2287),
    [sym_label] = STATE(2308),
    [sym_subexpression] = STATE(2308),
    [sym_parentheses] = STATE(2308),
    [sym_bounded_quantification] = STATE(2308),
    [sym_unbounded_quantification] = STATE(2308),
    [sym_choose] = STATE(2308),
    [sym_finite_set_literal] = STATE(2308),
    [sym_set_filter] = STATE(2308),
    [sym_set_map] = STATE(2308),
    [sym_function_evaluation] = STATE(2308),
    [sym_function_literal] = STATE(2308),
    [sym_set_of_functions] = STATE(2308),
    [sym_record_literal] = STATE(2308),
    [sym_set_of_records] = STATE(2308),
    [sym_record_value] = STATE(2308),
    [sym_except] = STATE(2308),
    [sym_prev_func_val] = STATE(2308),
    [sym_tuple_literal] = STATE(2308),
    [sym_step_expr_or_stutter] = STATE(2308),
    [sym_step_expr_no_stutter] = STATE(2308),
    [sym_fairness] = STATE(2308),
    [sym_if_then_else] = STATE(2308),
    [sym_case] = STATE(2308),
    [sym_let_in] = STATE(2308),
    [sym_conj_list] = STATE(2308),
    [sym_disj_list] = STATE(2308),
    [sym_lnot] = STATE(74),
    [sym_union] = STATE(71),
    [sym_powerset] = STATE(71),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(457),
    [sym_enabled] = STATE(62),
    [sym_unchanged] = STATE(62),
    [sym_always] = STATE(62),
    [sym_eventually] = STATE(62),
    [sym_prefix_op_symbol] = STATE(4629),
    [sym_bound_prefix_op] = STATE(2308),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4628),
    [sym_bound_infix_op] = STATE(2308),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4629),
    [sym_bound_postfix_op] = STATE(2308),
    [sym_assume_prove] = STATE(4682),
    [sym_inner_assume_prove] = STATE(4422),
    [sym_new] = STATE(4422),
    [sym_level] = STATE(3437),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(421),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(3688),
    [sym_exists] = STATE(3688),
    [sym_temporal_forall] = STATE(5038),
    [sym_temporal_exists] = STATE(5038),
    [sym_langle_bracket] = STATE(38),
    [sym_subexpr_prefix] = STATE(1190),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2277),
    [sym_bound_nonfix_op] = STATE(2277),
    [sym__expr] = STATE(1795),
    [sym_prefixed_op] = STATE(2308),
    [sym__number] = STATE(2308),
    [sym_nat_number] = STATE(2307),
    [sym_binary_number] = STATE(2307),
    [sym_octal_number] = STATE(2307),
    [sym_hex_number] = STATE(2307),
    [sym_string] = STATE(2308),
    [sym_boolean] = STATE(2308),
    [sym__primitive_value_set] = STATE(2308),
    [sym_nat_number_set] = STATE(2287),
    [sym_int_number_set] = STATE(2287),
    [sym_real_number_set] = STATE(2287),
    [sym_label] = STATE(2308),
    [sym_subexpression] = STATE(2308),
    [sym_parentheses] = STATE(2308),
    [sym_bounded_quantification] = STATE(2308),
    [sym_unbounded_quantification] = STATE(2308),
    [sym_choose] = STATE(2308),
    [sym_finite_set_literal] = STATE(2308),
    [sym_set_filter] = STATE(2308),
    [sym_set_map] = STATE(2308),
    [sym_function_evaluation] = STATE(2308),
    [sym_function_literal] = STATE(2308),
    [sym_set_of_functions] = STATE(2308),
    [sym_record_literal] = STATE(2308),
    [sym_set_of_records] = STATE(2308),
    [sym_record_value] = STATE(2308),
    [sym_except] = STATE(2308),
    [sym_prev_func_val] = STATE(2308),
    [sym_tuple_literal] = STATE(2308),
    [sym_step_expr_or_stutter] = STATE(2308),
    [sym_step_expr_no_stutter] = STATE(2308),
    [sym_fairness] = STATE(2308),
    [sym_if_then_else] = STATE(2308),
    [sym_case] = STATE(2308),
    [sym_let_in] = STATE(2308),
    [sym_conj_list] = STATE(2308),
    [sym_disj_list] = STATE(2308),
    [sym_lnot] = STATE(74),
    [sym_union] = STATE(71),
    [sym_powerset] = STATE(71),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(457),
    [sym_enabled] = STATE(62),
    [sym_unchanged] = STATE(62),
    [sym_always] = STATE(62),
    [sym_eventually] = STATE(62),
    [sym_prefix_op_symbol] = STATE(4629),
    [sym_bound_prefix_op] = STATE(2308),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4628),
    [sym_bound_infix_op] = STATE(2308),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4629),
    [sym_bound_postfix_op] = STATE(2308),
    [sym_assume_prove] = STATE(4682),
    [sym_inner_assume_prove] = STATE(4642),
    [sym_new] = STATE(4642),
    [sym_level] = STATE(3437),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(421),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3688),
    [sym_exists] = STATE(3688),
    [sym_temporal_forall] = STATE(5038),
    [sym_temporal_exists] = STATE(5038),
    [sym_langle_bracket] = STATE(38),
    [sym_subexpr_prefix] = STATE(1190),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2277),
    [sym_bound_nonfix_op] = STATE(2277),
    [sym__expr] = STATE(1716),
    [sym_prefixed_op] = STATE(2308),
    [sym__number] = STATE(2308),
    [sym_nat_number] = STATE(2307),
    [sym_binary_number] = STATE(2307),
    [sym_octal_number] = STATE(2307),
    [sym_hex_number] = STATE(2307),
    [sym_string] = STATE(2308),
    [sym_boolean] = STATE(2308),
    [sym__primitive_value_set] = STATE(2308),
    [sym_nat_number_set] = STATE(2287),
    [sym_int_number_set] = STATE(2287),
    [sym_real_number_set] = STATE(2287),
    [sym_label] = STATE(2308),
    [sym_subexpression] = STATE(2308),
    [sym_parentheses] = STATE(2308),
    [sym_bounded_quantification] = STATE(2308),
    [sym_unbounded_quantification] = STATE(2308),
    [sym_choose] = STATE(2308),
    [sym_finite_set_literal] = STATE(2308),
    [sym_set_filter] = STATE(2308),
    [sym_set_map] = STATE(2308),
    [sym_function_evaluation] = STATE(2308),
    [sym_function_literal] = STATE(2308),
    [sym_set_of_functions] = STATE(2308),
    [sym_record_literal] = STATE(2308),
    [sym_set_of_records] = STATE(2308),
    [sym_record_value] = STATE(2308),
    [sym_except] = STATE(2308),
    [sym_prev_func_val] = STATE(2308),
    [sym_tuple_literal] = STATE(2308),
    [sym_step_expr_or_stutter] = STATE(2308),
    [sym_step_expr_no_stutter] = STATE(2308),
    [sym_fairness] = STATE(2308),
    [sym_if_then_else] = STATE(2308),
    [sym_case] = STATE(2308),
    [sym_let_in] = STATE(2308),
    [sym_conj_list] = STATE(2308),
    [sym_disj_list] = STATE(2308),
    [sym_lnot] = STATE(74),
    [sym_union] = STATE(71),
    [sym_powerset] = STATE(71),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(457),
    [sym_enabled] = STATE(62),
    [sym_unchanged] = STATE(62),
    [sym_always] = STATE(62),
    [sym_eventually] = STATE(62),
    [sym_prefix_op_symbol] = STATE(4629),
    [sym_bound_prefix_op] = STATE(2308),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4628),
    [sym_bound_infix_op] = STATE(2308),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4629),
    [sym_bound_postfix_op] = STATE(2308),
    [sym_assume_prove] = STATE(4682),
    [sym_inner_assume_prove] = STATE(4251),
    [sym_new] = STATE(4251),
    [sym_level] = STATE(3437),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(421),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3369),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_ONLY] = ACTIONS(429),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4761),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_ONLY] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3372),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_ONLY] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3371),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_ONLY] = ACTIONS(497),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4746),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_ONLY] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4713),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_ONLY] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4738),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3355),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3369),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4713),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3359),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [24] = {
    [sym_block_comment] = STATE(24),
    [sym_forall] = STATE(3688),
    [sym_exists] = STATE(3688),
    [sym_temporal_forall] = STATE(5038),
    [sym_temporal_exists] = STATE(5038),
    [sym_langle_bracket] = STATE(38),
    [sym_operator_declaration] = STATE(3323),
    [sym__id_or_op_declaration] = STATE(4263),
    [sym__op_or_expr] = STATE(4195),
    [sym__op] = STATE(3306),
    [sym_subexpr_prefix] = STATE(1190),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2277),
    [sym_bound_nonfix_op] = STATE(2277),
    [sym_lambda] = STATE(3305),
    [sym__expr] = STATE(1793),
    [sym_prefixed_op] = STATE(2308),
    [sym__number] = STATE(2308),
    [sym_nat_number] = STATE(2307),
    [sym_binary_number] = STATE(2307),
    [sym_octal_number] = STATE(2307),
    [sym_hex_number] = STATE(2307),
    [sym_string] = STATE(2308),
    [sym_boolean] = STATE(2308),
    [sym__primitive_value_set] = STATE(2308),
    [sym_nat_number_set] = STATE(2287),
    [sym_int_number_set] = STATE(2287),
    [sym_real_number_set] = STATE(2287),
    [sym_label] = STATE(2308),
    [sym_subexpression] = STATE(2308),
    [sym_parentheses] = STATE(2308),
    [sym_bounded_quantification] = STATE(2308),
    [sym_unbounded_quantification] = STATE(2308),
    [sym_choose] = STATE(2308),
    [sym_finite_set_literal] = STATE(2308),
    [sym_set_filter] = STATE(2308),
    [sym_set_map] = STATE(2308),
    [sym_function_evaluation] = STATE(2308),
    [sym_function_literal] = STATE(2308),
    [sym_set_of_functions] = STATE(2308),
    [sym_record_literal] = STATE(2308),
    [sym_set_of_records] = STATE(2308),
    [sym_record_value] = STATE(2308),
    [sym_except] = STATE(2308),
    [sym_prev_func_val] = STATE(2308),
    [sym_tuple_literal] = STATE(2308),
    [sym_step_expr_or_stutter] = STATE(2308),
    [sym_step_expr_no_stutter] = STATE(2308),
    [sym_fairness] = STATE(2308),
    [sym_if_then_else] = STATE(2308),
    [sym_case] = STATE(2308),
    [sym_let_in] = STATE(2308),
    [sym_conj_list] = STATE(2308),
    [sym_disj_list] = STATE(2308),
    [sym_lnot] = STATE(74),
    [sym_union] = STATE(71),
    [sym_powerset] = STATE(71),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(457),
    [sym_enabled] = STATE(62),
    [sym_unchanged] = STATE(62),
    [sym_always] = STATE(62),
    [sym_eventually] = STATE(62),
    [sym_prefix_op_symbol] = STATE(3966),
    [sym_bound_prefix_op] = STATE(2308),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4034),
    [sym_bound_infix_op] = STATE(2308),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4013),
    [sym_bound_postfix_op] = STATE(2308),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [sym_placeholder] = ACTIONS(505),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(509),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(421),
  },
  [25] = {
    [sym_block_comment] = STATE(25),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(219),
    [sym_union] = STATE(221),
    [sym_powerset] = STATE(221),
    [sym_domain] = STATE(223),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(224),
    [sym_unchanged] = STATE(224),
    [sym_always] = STATE(224),
    [sym_eventually] = STATE(224),
    [sym_prefix_op_symbol] = STATE(4663),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4613),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4663),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_use_body] = STATE(3371),
    [sym_use_body_expr] = STATE(3316),
    [sym_use_body_def] = STATE(3360),
    [sym_module_ref] = STATE(3308),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(427),
    [anon_sym_DEFS] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(359),
  },
  [26] = {
    [sym_block_comment] = STATE(26),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4761),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [27] = {
    [sym_block_comment] = STATE(27),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(250),
    [sym_union] = STATE(249),
    [sym_powerset] = STATE(249),
    [sym_domain] = STATE(245),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(233),
    [sym_unchanged] = STATE(233),
    [sym_always] = STATE(233),
    [sym_eventually] = STATE(233),
    [sym_prefix_op_symbol] = STATE(4637),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3447),
    [sym_postfix_op_symbol] = STATE(4637),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_use_body] = STATE(4771),
    [sym_use_body_expr] = STATE(4074),
    [sym_use_body_def] = STATE(4719),
    [sym_module_ref] = STATE(3965),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(449),
    [anon_sym_DEFS] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(465),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(117),
    [anon_sym_BSLASHneg] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_20] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(121),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(125),
    [anon_sym_21] = ACTIONS(125),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(491),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(261),
    [anon_sym_87] = ACTIONS(261),
    [sym_asterisk] = ACTIONS(263),
    [sym_sup_hash] = ACTIONS(263),
    [sym_prime] = ACTIONS(263),
    [sym__indent] = ACTIONS(493),
  },
  [28] = {
    [sym_block_comment] = STATE(28),
    [sym_forall] = STATE(3703),
    [sym_exists] = STATE(3703),
    [sym_temporal_forall] = STATE(4770),
    [sym_temporal_exists] = STATE(4770),
    [sym_langle_bracket] = STATE(80),
    [sym__op_or_expr] = STATE(3348),
    [sym__op] = STATE(3306),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2207),
    [sym_bound_nonfix_op] = STATE(2207),
    [sym_lambda] = STATE(3305),
    [sym__expr] = STATE(1093),
    [sym_prefixed_op] = STATE(2217),
    [sym__number] = STATE(2217),
    [sym_nat_number] = STATE(2211),
    [sym_binary_number] = STATE(2211),
    [sym_octal_number] = STATE(2211),
    [sym_hex_number] = STATE(2211),
    [sym_string] = STATE(2217),
    [sym_boolean] = STATE(2217),
    [sym__primitive_value_set] = STATE(2217),
    [sym_nat_number_set] = STATE(2208),
    [sym_int_number_set] = STATE(2208),
    [sym_real_number_set] = STATE(2208),
    [sym_label] = STATE(2217),
    [sym_subexpression] = STATE(2217),
    [sym_parentheses] = STATE(2217),
    [sym_bounded_quantification] = STATE(2217),
    [sym_unbounded_quantification] = STATE(2217),
    [sym_choose] = STATE(2217),
    [sym_finite_set_literal] = STATE(2217),
    [sym_set_filter] = STATE(2217),
    [sym_set_map] = STATE(2217),
    [sym_function_evaluation] = STATE(2217),
    [sym_function_literal] = STATE(2217),
    [sym_set_of_functions] = STATE(2217),
    [sym_record_literal] = STATE(2217),
    [sym_set_of_records] = STATE(2217),
    [sym_record_value] = STATE(2217),
    [sym_except] = STATE(2217),
    [sym_prev_func_val] = STATE(2217),
    [sym_tuple_literal] = STATE(2217),
    [sym_step_expr_or_stutter] = STATE(2217),
    [sym_step_expr_no_stutter] = STATE(2217),
    [sym_fairness] = STATE(2217),
    [sym_if_then_else] = STATE(2217),
    [sym_case] = STATE(2217),
    [sym_let_in] = STATE(2217),
    [sym_conj_list] = STATE(2217),
    [sym_disj_list] = STATE(2217),
    [sym_lnot] = STATE(7),
    [sym_union] = STATE(8),
    [sym_powerset] = STATE(8),
    [sym_domain] = STATE(5),
    [sym_negative] = STATE(937),
    [sym_enabled] = STATE(6),
    [sym_unchanged] = STATE(6),
    [sym_always] = STATE(6),
    [sym_eventually] = STATE(6),
    [sym_prefix_op_symbol] = STATE(3318),
    [sym_bound_prefix_op] = STATE(2217),
    [sym_implies] = STATE(3259),
    [sym_plus_arrow] = STATE(3259),
    [sym_equiv] = STATE(3259),
    [sym_iff] = STATE(3259),
    [sym_leads_to] = STATE(3259),
    [sym_land] = STATE(3259),
    [sym_lor] = STATE(3259),
    [sym_assign] = STATE(3259),
    [sym_bnf_rule] = STATE(3259),
    [sym_eq] = STATE(3259),
    [sym_neq] = STATE(3259),
    [sym_lt] = STATE(3259),
    [sym_leq] = STATE(3259),
    [sym_geq] = STATE(3259),
    [sym_approx] = STATE(3259),
    [sym_rs_ttile] = STATE(3259),
    [sym_rd_ttile] = STATE(3259),
    [sym_ls_ttile] = STATE(3259),
    [sym_ld_ttile] = STATE(3259),
    [sym_asymp] = STATE(3259),
    [sym_cong] = STATE(3259),
    [sym_doteq] = STATE(3259),
    [sym_gg] = STATE(3259),
    [sym_ll] = STATE(3259),
    [sym_in] = STATE(3259),
    [sym_notin] = STATE(3259),
    [sym_prec] = STATE(3259),
    [sym_succ] = STATE(3259),
    [sym_preceq] = STATE(3259),
    [sym_succeq] = STATE(3259),
    [sym_sim] = STATE(3259),
    [sym_simeq] = STATE(3259),
    [sym_sqsubset] = STATE(3259),
    [sym_sqsupset] = STATE(3259),
    [sym_sqsubseteq] = STATE(3259),
    [sym_sqsupseteq] = STATE(3259),
    [sym_cap] = STATE(3259),
    [sym_cup] = STATE(3259),
    [sym_dots_2] = STATE(3259),
    [sym_dots_3] = STATE(3259),
    [sym_plus] = STATE(3259),
    [sym_oplus] = STATE(3259),
    [sym_ominus] = STATE(3259),
    [sym_vertvert] = STATE(3259),
    [sym_minus] = STATE(3259),
    [sym_odot] = STATE(3259),
    [sym_oslash] = STATE(3259),
    [sym_otimes] = STATE(3259),
    [sym_bigcirc] = STATE(3259),
    [sym_bullet] = STATE(3259),
    [sym_div] = STATE(3259),
    [sym_circ] = STATE(3259),
    [sym_star] = STATE(3259),
    [sym_excl] = STATE(3259),
    [sym_qq] = STATE(3259),
    [sym_sqcap] = STATE(3259),
    [sym_sqcup] = STATE(3259),
    [sym_uplus] = STATE(3259),
    [sym_wr] = STATE(3259),
    [sym_cdot] = STATE(3259),
    [sym_infix_op_symbol] = STATE(3319),
    [sym_bound_infix_op] = STATE(2217),
    [sym_sup_plus] = STATE(3300),
    [sym_postfix_op_symbol] = STATE(3318),
    [sym_bound_postfix_op] = STATE(2217),
    [sym_module_ref] = STATE(3348),
    [sym_proof_step_ref] = STATE(2201),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(511),
    [anon_sym_15] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(513),
    [anon_sym_ENABLED] = ACTIONS(515),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(517),
    [anon_sym_DOMAIN] = ACTIONS(519),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(521),
    [anon_sym_LAMBDA] = ACTIONS(523),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(525),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(115),
    [anon_sym_BSLASHlnot] = ACTIONS(527),
    [anon_sym_BSLASHneg] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(529),
    [anon_sym_20] = ACTIONS(527),
    [anon_sym_DASH] = ACTIONS(531),
    [sym_negative_dot] = ACTIONS(123),
    [anon_sym_LT_GT] = ACTIONS(533),
    [anon_sym_21] = ACTIONS(533),
    [anon_sym_EQ_GT] = ACTIONS(127),
    [anon_sym_22] = ACTIONS(127),
    [anon_sym_23] = ACTIONS(127),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(129),
    [anon_sym_24] = ACTIONS(129),
    [anon_sym_25] = ACTIONS(129),
    [anon_sym_BSLASHequiv] = ACTIONS(131),
    [anon_sym_26] = ACTIONS(131),
    [anon_sym_LT_EQ_GT] = ACTIONS(133),
    [anon_sym_27] = ACTIONS(133),
    [anon_sym_28] = ACTIONS(133),
    [anon_sym_TILDE_GT] = ACTIONS(135),
    [anon_sym_29] = ACTIONS(135),
    [anon_sym_30] = ACTIONS(135),
    [anon_sym_SLASH_BSLASH] = ACTIONS(137),
    [anon_sym_BSLASHland] = ACTIONS(137),
    [anon_sym_31] = ACTIONS(137),
    [anon_sym_BSLASH_SLASH] = ACTIONS(139),
    [anon_sym_BSLASHlor] = ACTIONS(139),
    [anon_sym_32] = ACTIONS(139),
    [anon_sym_COLON_EQ] = ACTIONS(141),
    [anon_sym_33] = ACTIONS(141),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(143),
    [anon_sym_34] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(145),
    [anon_sym_POUND] = ACTIONS(147),
    [anon_sym_35] = ACTIONS(145),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(151),
    [anon_sym_LT_EQ] = ACTIONS(153),
    [anon_sym_EQ_LT] = ACTIONS(155),
    [anon_sym_BSLASHleq] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_GT_EQ] = ACTIONS(157),
    [anon_sym_BSLASHgeq] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(157),
    [anon_sym_BSLASHapprox] = ACTIONS(159),
    [anon_sym_38] = ACTIONS(159),
    [anon_sym_PIPE_DASH] = ACTIONS(161),
    [anon_sym_39] = ACTIONS(161),
    [anon_sym_PIPE_EQ] = ACTIONS(163),
    [anon_sym_40] = ACTIONS(163),
    [anon_sym_DASH_PIPE] = ACTIONS(165),
    [anon_sym_41] = ACTIONS(165),
    [anon_sym_EQ_PIPE] = ACTIONS(167),
    [anon_sym_42] = ACTIONS(167),
    [anon_sym_BSLASHasymp] = ACTIONS(169),
    [anon_sym_43] = ACTIONS(169),
    [anon_sym_BSLASHcong] = ACTIONS(171),
    [anon_sym_44] = ACTIONS(171),
    [anon_sym_BSLASHdoteq] = ACTIONS(173),
    [anon_sym_45] = ACTIONS(173),
    [anon_sym_BSLASHgg] = ACTIONS(175),
    [anon_sym_46] = ACTIONS(175),
    [anon_sym_BSLASHll] = ACTIONS(177),
    [anon_sym_47] = ACTIONS(177),
    [anon_sym_BSLASHnotin] = ACTIONS(179),
    [anon_sym_48] = ACTIONS(179),
    [anon_sym_BSLASHprec] = ACTIONS(181),
    [anon_sym_49] = ACTIONS(183),
    [anon_sym_BSLASHsucc] = ACTIONS(185),
    [anon_sym_50] = ACTIONS(187),
    [anon_sym_BSLASHpreceq] = ACTIONS(189),
    [anon_sym_51] = ACTIONS(189),
    [anon_sym_BSLASHsucceq] = ACTIONS(191),
    [anon_sym_52] = ACTIONS(191),
    [anon_sym_BSLASHsim] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_BSLASHsimeq] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [anon_sym_BSLASHsqsubset] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(201),
    [anon_sym_BSLASHsqsupset] = ACTIONS(203),
    [anon_sym_57] = ACTIONS(205),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(207),
    [anon_sym_58] = ACTIONS(207),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(209),
    [anon_sym_59] = ACTIONS(209),
    [sym_compose] = ACTIONS(211),
    [sym_map_to] = ACTIONS(211),
    [sym_map_from] = ACTIONS(211),
    [sym_setminus] = ACTIONS(151),
    [anon_sym_BSLASHcap] = ACTIONS(213),
    [anon_sym_BSLASHintersect] = ACTIONS(213),
    [anon_sym_64] = ACTIONS(213),
    [anon_sym_BSLASHcup] = ACTIONS(215),
    [anon_sym_BSLASHunion] = ACTIONS(215),
    [anon_sym_65] = ACTIONS(215),
    [anon_sym_DOT_DOT] = ACTIONS(217),
    [anon_sym_66] = ACTIONS(219),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(221),
    [anon_sym_67] = ACTIONS(221),
    [anon_sym_PLUS] = ACTIONS(223),
    [sym_plusplus] = ACTIONS(211),
    [anon_sym_BSLASHoplus] = ACTIONS(225),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [anon_sym_BSLASHominus] = ACTIONS(227),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [sym_mod] = ACTIONS(151),
    [sym_modmod] = ACTIONS(211),
    [sym_vert] = ACTIONS(151),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [sym_minusminus] = ACTIONS(211),
    [sym_amp] = ACTIONS(151),
    [sym_ampamp] = ACTIONS(211),
    [anon_sym_BSLASHodot] = ACTIONS(231),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHoslash] = ACTIONS(233),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(233),
    [anon_sym_72] = ACTIONS(233),
    [anon_sym_BSLASHotimes] = ACTIONS(235),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(235),
    [anon_sym_73] = ACTIONS(235),
    [sym_mul] = ACTIONS(151),
    [sym_mulmul] = ACTIONS(211),
    [sym_slash] = ACTIONS(151),
    [sym_slashslash] = ACTIONS(211),
    [anon_sym_BSLASHbigcirc] = ACTIONS(237),
    [anon_sym_74] = ACTIONS(237),
    [anon_sym_BSLASHbullet] = ACTIONS(239),
    [anon_sym_75] = ACTIONS(239),
    [anon_sym_BSLASHdiv] = ACTIONS(241),
    [anon_sym_76] = ACTIONS(241),
    [anon_sym_BSLASHcirc] = ACTIONS(243),
    [anon_sym_77] = ACTIONS(243),
    [anon_sym_BSLASHstar] = ACTIONS(245),
    [anon_sym_78] = ACTIONS(245),
    [anon_sym_BANG_BANG] = ACTIONS(247),
    [anon_sym_79] = ACTIONS(247),
    [anon_sym_QMARK_QMARK] = ACTIONS(249),
    [anon_sym_80] = ACTIONS(249),
    [sym_hashhash] = ACTIONS(211),
    [sym_dol] = ACTIONS(151),
    [sym_doldol] = ACTIONS(211),
    [anon_sym_BSLASHsqcap] = ACTIONS(251),
    [anon_sym_81] = ACTIONS(251),
    [anon_sym_BSLASHsqcup] = ACTIONS(253),
    [anon_sym_82] = ACTIONS(253),
    [anon_sym_BSLASHuplus] = ACTIONS(255),
    [anon_sym_83] = ACTIONS(255),
    [anon_sym_BSLASHwr] = ACTIONS(257),
    [anon_sym_85] = ACTIONS(257),
    [anon_sym_BSLASHcdot] = ACTIONS(259),
    [anon_sym_86] = ACTIONS(259),
    [sym_pow] = ACTIONS(151),
    [sym_powpow] = ACTIONS(211),
    [anon_sym_CARET_PLUS] = ACTIONS(535),
    [anon_sym_87] = ACTIONS(535),
    [sym_asterisk] = ACTIONS(537),
    [sym_sup_hash] = ACTIONS(537),
    [sym_prime] = ACTIONS(537),
    [sym__indent] = ACTIONS(359),
  },
  [29] = {
    [sym_block_comment] = STATE(29),
    [sym_forall] = STATE(3719),
    [sym_exists] = STATE(3719),
    [sym_temporal_forall] = STATE(4752),
    [sym_temporal_exists] = STATE(4752),
    [sym_langle_bracket] = STATE(102),
    [sym__op_or_expr] = STATE(4436),
    [sym__op] = STATE(3624),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5039),
    [sym_bound_op] = STATE(2850),
    [sym_bound_nonfix_op] = STATE(2850),
    [sym_lambda] = STATE(3623),
    [sym__expr] = STATE(1792),
    [sym_prefixed_op] = STATE(3037),
    [sym__number] = STATE(3037),
    [sym_nat_number] = STATE(2922),
    [sym_binary_number] = STATE(2922),
    [sym_octal_number] = STATE(2922),
    [sym_hex_number] = STATE(2922),
    [sym_string] = STATE(3037),
    [sym_boolean] = STATE(3037),
    [sym__primitive_value_set] = STATE(3037),
    [sym_nat_number_set] = STATE(3013),
    [sym_int_number_set] = STATE(3013),
    [sym_real_number_set] = STATE(3013),
    [sym_label] = STATE(3037),
    [sym_subexpression] = STATE(3037),
    [sym_parentheses] = STATE(3037),
    [sym_bounded_quantification] = STATE(3037),
    [sym_unbounded_quantification] = STATE(3037),
    [sym_choose] = STATE(3037),
    [sym_finite_set_literal] = STATE(3037),
    [sym_set_filter] = STATE(3037),
    [sym_set_map] = STATE(3037),
    [sym_function_evaluation] = STATE(3037),
    [sym_function_literal] = STATE(3037),
    [sym_set_of_functions] = STATE(3037),
    [sym_record_literal] = STATE(3037),
    [sym_set_of_records] = STATE(3037),
    [sym_record_value] = STATE(3037),
    [sym_except] = STATE(3037),
    [sym_prev_func_val] = STATE(3037),
    [sym_tuple_literal] = STATE(3037),
    [sym_step_expr_or_stutter] = STATE(3037),
    [sym_step_expr_no_stutter] = STATE(3037),
    [sym_fairness] = STATE(3037),
    [sym_if_then_else] = STATE(3037),
    [sym_case] = STATE(3037),
    [sym_let_in] = STATE(3037),
    [sym_conj_list] = STATE(3037),
    [sym_disj_list] = STATE(3037),
    [sym_lnot] = STATE(130),
    [sym_union] = STATE(174),
    [sym_powerset] = STATE(174),
    [sym_domain] = STATE(172),
    [sym_negative] = STATE(628),
    [sym_enabled] = STATE(169),
    [sym_unchanged] = STATE(169),
    [sym_always] = STATE(169),
    [sym_eventually] = STATE(169),
    [sym_prefix_op_symbol] = STATE(4041),
    [sym_bound_prefix_op] = STATE(3037),
    [sym_implies] = STATE(3584),
    [sym_plus_arrow] = STATE(3584),
    [sym_equiv] = STATE(3584),
    [sym_iff] = STATE(3584),
    [sym_leads_to] = STATE(3584),
    [sym_land] = STATE(3584),
    [sym_lor] = STATE(3584),
    [sym_assign] = STATE(3584),
    [sym_bnf_rule] = STATE(3584),
    [sym_eq] = STATE(3584),
    [sym_neq] = STATE(3584),
    [sym_lt] = STATE(3584),
    [sym_leq] = STATE(3584),
    [sym_geq] = STATE(3584),
    [sym_approx] = STATE(3584),
    [sym_rs_ttile] = STATE(3584),
    [sym_rd_ttile] = STATE(3584),
    [sym_ls_ttile] = STATE(3584),
    [sym_ld_ttile] = STATE(3584),
    [sym_asymp] = STATE(3584),
    [sym_cong] = STATE(3584),
    [sym_doteq] = STATE(3584),
    [sym_gg] = STATE(3584),
    [sym_ll] = STATE(3584),
    [sym_in] = STATE(3584),
    [sym_notin] = STATE(3584),
    [sym_prec] = STATE(3584),
    [sym_succ] = STATE(3584),
    [sym_preceq] = STATE(3584),
    [sym_succeq] = STATE(3584),
    [sym_sim] = STATE(3584),
    [sym_simeq] = STATE(3584),
    [sym_sqsubset] = STATE(3584),
    [sym_sqsupset] = STATE(3584),
    [sym_sqsubseteq] = STATE(3584),
    [sym_sqsupseteq] = STATE(3584),
    [sym_cap] = STATE(3584),
    [sym_cup] = STATE(3584),
    [sym_dots_2] = STATE(3584),
    [sym_dots_3] = STATE(3584),
    [sym_plus] = STATE(3584),
    [sym_oplus] = STATE(3584),
    [sym_ominus] = STATE(3584),
    [sym_vertvert] = STATE(3584),
    [sym_minus] = STATE(3584),
    [sym_odot] = STATE(3584),
    [sym_oslash] = STATE(3584),
    [sym_otimes] = STATE(3584),
    [sym_bigcirc] = STATE(3584),
    [sym_bullet] = STATE(3584),
    [sym_div] = STATE(3584),
    [sym_circ] = STATE(3584),
    [sym_star] = STATE(3584),
    [sym_excl] = STATE(3584),
    [sym_qq] = STATE(3584),
    [sym_sqcap] = STATE(3584),
    [sym_sqcup] = STATE(3584),
    [sym_uplus] = STATE(3584),
    [sym_wr] = STATE(3584),
    [sym_cdot] = STATE(3584),
    [sym_infix_op_symbol] = STATE(4042),
    [sym_bound_infix_op] = STATE(3037),
    [sym_sup_plus] = STATE(3543),
    [sym_postfix_op_symbol] = STATE(4041),
    [sym_bound_postfix_op] = STATE(3037),
    [sym_module_ref] = STATE(4436),
    [sym_proof_step_ref] = STATE(2878),
    [sym_identifier] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(435),
    [anon_sym_BSLASHin] = ACTIONS(539),
    [anon_sym_2] = ACTIONS(541),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(543),
    [anon_sym_15] = ACTIONS(543),
    [anon_sym_AT] = ACTIONS(437),
    [anon_sym_UNION] = ACTIONS(545),
    [anon_sym_ENABLED] = ACTIONS(547),
    [anon_sym_CASE] = ACTIONS(439),
    [anon_sym_SF_] = ACTIONS(441),
    [anon_sym_WF_] = ACTIONS(441),
    [anon_sym_CHOOSE] = ACTIONS(443),
    [anon_sym_IF] = ACTIONS(445),
    [anon_sym_SUBSET] = ACTIONS(549),
    [anon_sym_DOMAIN] = ACTIONS(551),
    [anon_sym_LET] = ACTIONS(447),
    [anon_sym_UNCHANGED] = ACTIONS(553),
    [anon_sym_LAMBDA] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACK] = ACTIONS(455),
    [aux_sym_child_id_token1] = ACTIONS(457),
    [sym_real_number] = ACTIONS(459),
    [anon_sym_BSLASHb] = ACTIONS(461),
    [anon_sym_BSLASHB] = ACTIONS(463),
    [anon_sym_BSLASHo] = ACTIONS(557),
    [anon_sym_BSLASHO] = ACTIONS(467),
    [anon_sym_BSLASHh] = ACTIONS(469),
    [anon_sym_BSLASHH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_TRUE] = ACTIONS(473),
    [anon_sym_FALSE] = ACTIONS(473),
    [sym_string_set] = ACTIONS(475),
    [sym_boolean_set] = ACTIONS(475),
    [anon_sym_Nat] = ACTIONS(477),
    [anon_sym_17] = ACTIONS(479),
    [anon_sym_Int] = ACTIONS(481),
    [anon_sym_18] = ACTIONS(483),
    [anon_sym_Real] = ACTIONS(485),
    [anon_sym_19] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(559),
    [anon_sym_BSLASHlnot] = ACTIONS(561),
    [anon_sym_BSLASHneg] = ACTIONS(561),
    [anon_sym_TILDE] = ACTIONS(563),
    [anon_sym_20] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(565),
    [sym_negative_dot] = ACTIONS(567),
    [anon_sym_LT_GT] = ACTIONS(569),
    [anon_sym_21] = ACTIONS(569),
    [anon_sym_EQ_GT] = ACTIONS(571),
    [anon_sym_22] = ACTIONS(571),
    [anon_sym_23] = ACTIONS(571),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(573),
    [anon_sym_24] = ACTIONS(573),
    [anon_sym_25] = ACTIONS(573),
    [anon_sym_BSLASHequiv] = ACTIONS(575),
    [anon_sym_26] = ACTIONS(575),
    [anon_sym_LT_EQ_GT] = ACTIONS(577),
    [anon_sym_27] = ACTIONS(577),
    [anon_sym_28] = ACTIONS(577),
    [anon_sym_TILDE_GT] = ACTIONS(579),
    [anon_sym_29] = ACTIONS(579),
    [anon_sym_30] = ACTIONS(579),
    [anon_sym_SLASH_BSLASH] = ACTIONS(581),
    [anon_sym_BSLASHland] = ACTIONS(581),
    [anon_sym_31] = ACTIONS(581),
    [anon_sym_BSLASH_SLASH] = ACTIONS(583),
    [anon_sym_BSLASHlor] = ACTIONS(583),
    [anon_sym_32] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(585),
    [anon_sym_33] = ACTIONS(585),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(587),
    [anon_sym_34] = ACTIONS(587),
    [anon_sym_SLASH_EQ] = ACTIONS(589),
    [anon_sym_POUND] = ACTIONS(591),
    [anon_sym_35] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(593),
    [sym_gt] = ACTIONS(595),
    [anon_sym_LT_EQ] = ACTIONS(597),
    [anon_sym_EQ_LT] = ACTIONS(599),
    [anon_sym_BSLASHleq] = ACTIONS(599),
    [anon_sym_36] = ACTIONS(599),
    [anon_sym_GT_EQ] = ACTIONS(601),
    [anon_sym_BSLASHgeq] = ACTIONS(601),
    [anon_sym_37] = ACTIONS(601),
    [anon_sym_BSLASHapprox] = ACTIONS(603),
    [anon_sym_38] = ACTIONS(603),
    [anon_sym_PIPE_DASH] = ACTIONS(605),
    [anon_sym_39] = ACTIONS(605),
    [anon_sym_PIPE_EQ] = ACTIONS(607),
    [anon_sym_40] = ACTIONS(607),
    [anon_sym_DASH_PIPE] = ACTIONS(609),
    [anon_sym_41] = ACTIONS(609),
    [anon_sym_EQ_PIPE] = ACTIONS(611),
    [anon_sym_42] = ACTIONS(611),
    [anon_sym_BSLASHasymp] = ACTIONS(613),
    [anon_sym_43] = ACTIONS(613),
    [anon_sym_BSLASHcong] = ACTIONS(615),
    [anon_sym_44] = ACTIONS(615),
    [anon_sym_BSLASHdoteq] = ACTIONS(617),
    [anon_sym_45] = ACTIONS(617),
    [anon_sym_BSLASHgg] = ACTIONS(619),
    [anon_sym_46] = ACTIONS(619),
    [anon_sym_BSLASHll] = ACTIONS(621),
    [anon_sym_47] = ACTIONS(621),
    [anon_sym_BSLASHnotin] = ACTIONS(623),
    [anon_sym_48] = ACTIONS(623),
    [anon_sym_BSLASHprec] = ACTIONS(625),
    [anon_sym_49] = ACTIONS(627),
    [anon_sym_BSLASHsucc] = ACTIONS(629),
    [anon_sym_50] = ACTIONS(631),
    [anon_sym_BSLASHpreceq] = ACTIONS(633),
    [anon_sym_51] = ACTIONS(633),
    [anon_sym_BSLASHsucceq] = ACTIONS(635),
    [anon_sym_52] = ACTIONS(635),
    [anon_sym_BSLASHsim] = ACTIONS(637),
    [anon_sym_54] = ACTIONS(639),
    [anon_sym_BSLASHsimeq] = ACTIONS(641),
    [anon_sym_55] = ACTIONS(641),
    [anon_sym_BSLASHsqsubset] = ACTIONS(643),
    [anon_sym_56] = ACTIONS(645),
    [anon_sym_BSLASHsqsupset] = ACTIONS(647),
    [anon_sym_57] = ACTIONS(649),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(651),
    [anon_sym_58] = ACTIONS(651),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(653),
    [anon_sym_59] = ACTIONS(653),
    [sym_compose] = ACTIONS(655),
    [sym_map_to] = ACTIONS(655),
    [sym_map_from] = ACTIONS(655),
    [sym_setminus] = ACTIONS(595),
    [anon_sym_BSLASHcap] = ACTIONS(657),
    [anon_sym_BSLASHintersect] = ACTIONS(657),
    [anon_sym_64] = ACTIONS(657),
    [anon_sym_BSLASHcup] = ACTIONS(659),
    [anon_sym_BSLASHunion] = ACTIONS(659),
    [anon_sym_65] = ACTIONS(659),
    [anon_sym_DOT_DOT] = ACTIONS(661),
    [anon_sym_66] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_67] = ACTIONS(665),
    [anon_sym_PLUS] = ACTIONS(667),
    [sym_plusplus] = ACTIONS(655),
    [anon_sym_BSLASHoplus] = ACTIONS(669),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(669),
    [anon_sym_68] = ACTIONS(669),
    [anon_sym_BSLASHominus] = ACTIONS(671),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(671),
    [anon_sym_69] = ACTIONS(671),
    [sym_mod] = ACTIONS(595),
    [sym_modmod] = ACTIONS(655),
    [sym_vert] = ACTIONS(595),
    [anon_sym_PIPE_PIPE] = ACTIONS(673),
    [anon_sym_70] = ACTIONS(673),
    [sym_minusminus] = ACTIONS(655),
    [sym_amp] = ACTIONS(595),
    [sym_ampamp] = ACTIONS(655),
    [anon_sym_BSLASHodot] = ACTIONS(675),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(675),
    [anon_sym_71] = ACTIONS(675),
    [anon_sym_BSLASHoslash] = ACTIONS(677),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(677),
    [anon_sym_72] = ACTIONS(677),
    [anon_sym_BSLASHotimes] = ACTIONS(679),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(679),
    [anon_sym_73] = ACTIONS(679),
    [sym_mul] = ACTIONS(595),
    [sym_mulmul] = ACTIONS(655),
    [sym_slash] = ACTIONS(595),
    [sym_slashslash] = ACTIONS(655),
    [anon_sym_BSLASHbigcirc] = ACTIONS(681),
    [anon_sym_74] = ACTIONS(681),
    [anon_sym_BSLASHbullet] = ACTIONS(683),
    [anon_sym_75] = ACTIONS(683),
    [anon_sym_BSLASHdiv] = ACTIONS(685),
    [anon_sym_76] = ACTIONS(685),
    [anon_sym_BSLASHcirc] = ACTIONS(687),
    [anon_sym_77] = ACTIONS(687),
    [anon_sym_BSLASHstar] = ACTIONS(689),
    [anon_sym_78] = ACTIONS(689),
    [anon_sym_BANG_BANG] = ACTIONS(691),
    [anon_sym_79] = ACTIONS(691),
    [anon_sym_QMARK_QMARK] = ACTIONS(693),
    [anon_sym_80] = ACTIONS(693),
    [sym_hashhash] = ACTIONS(655),
    [sym_dol] = ACTIONS(595),
    [sym_doldol] = ACTIONS(655),
    [anon_sym_BSLASHsqcap] = ACTIONS(695),
    [anon_sym_81] = ACTIONS(695),
    [anon_sym_BSLASHsqcup] = ACTIONS(697),
    [anon_sym_82]