#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 5127
#define LARGE_STATE_COUNT 3226
#define SYMBOL_COUNT 655
#define ALIAS_COUNT 6
#define TOKEN_COUNT 364
#define EXTERNAL_TOKEN_COUNT 13
#define FIELD_COUNT 24
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 60

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_LPAREN_STAR = 3,
  anon_sym_STAR_RPAREN = 4,
  aux_sym_block_comment_text_token1 = 5,
  aux_sym_block_comment_text_token2 = 6,
  aux_sym_block_comment_text_token3 = 7,
  aux_sym_block_comment_text_token4 = 8,
  anon_sym_MODULE = 9,
  sym_single_line = 10,
  sym_double_line = 11,
  anon_sym_EQ_EQ = 12,
  anon_sym_ = 13,
  anon_sym_BSLASHin = 14,
  anon_sym_2 = 15,
  anon_sym_LT_DASH = 16,
  anon_sym_3 = 17,
  anon_sym_4 = 18,
  anon_sym_BSLASHA = 19,
  anon_sym_BSLASHforall = 20,
  anon_sym_5 = 21,
  anon_sym_BSLASHE = 22,
  anon_sym_BSLASHexists = 23,
  anon_sym_6 = 24,
  anon_sym_BSLASHAA = 25,
  anon_sym_BSLASHEE = 26,
  anon_sym_PIPE_DASH_GT = 27,
  anon_sym_7 = 28,
  anon_sym_8 = 29,
  anon_sym_DASH_GT = 30,
  anon_sym_9 = 31,
  anon_sym_10 = 32,
  anon_sym_LT_LT = 33,
  anon_sym_11 = 34,
  anon_sym_12 = 35,
  anon_sym_GT_GT = 36,
  anon_sym_13 = 37,
  anon_sym_14 = 38,
  anon_sym_GT_GT_ = 39,
  anon_sym__ = 40,
  anon_sym__2 = 41,
  anon_sym_LBRACK_RBRACK = 42,
  anon_sym_15 = 43,
  anon_sym_COLON = 44,
  anon_sym_AT = 45,
  anon_sym_COLON_COLON = 46,
  anon_sym_16 = 47,
  sym_placeholder = 48,
  anon_sym_ASSUME = 49,
  anon_sym_ELSE = 50,
  anon_sym_LOCAL = 51,
  anon_sym_UNION = 52,
  anon_sym_ASSUMPTION = 53,
  anon_sym_ENABLED = 54,
  anon_sym_VARIABLE = 55,
  anon_sym_AXIOM = 56,
  anon_sym_EXCEPT = 57,
  anon_sym_OTHER = 58,
  anon_sym_VARIABLES = 59,
  anon_sym_CASE = 60,
  anon_sym_EXTENDS = 61,
  anon_sym_SF_ = 62,
  anon_sym_WF_ = 63,
  anon_sym_CHOOSE = 64,
  anon_sym_IF = 65,
  anon_sym_SUBSET = 66,
  anon_sym_WITH = 67,
  anon_sym_CONSTANT = 68,
  anon_sym_IN = 69,
  anon_sym_THEN = 70,
  anon_sym_CONSTANTS = 71,
  anon_sym_INSTANCE = 72,
  anon_sym_THEOREM = 73,
  anon_sym_COROLLARY = 74,
  anon_sym_DOMAIN = 75,
  anon_sym_LET = 76,
  anon_sym_UNCHANGED = 77,
  anon_sym_BY = 78,
  anon_sym_HAVE = 79,
  anon_sym_QED = 80,
  anon_sym_TAKE = 81,
  anon_sym_DEF = 82,
  anon_sym_HIDE = 83,
  anon_sym_RECURSIVE = 84,
  anon_sym_USE = 85,
  anon_sym_DEFINE = 86,
  anon_sym_PROOF = 87,
  anon_sym_WITNESS = 88,
  anon_sym_PICK = 89,
  anon_sym_DEFS = 90,
  anon_sym_PROVE = 91,
  anon_sym_SUFFICES = 92,
  anon_sym_NEW = 93,
  anon_sym_LAMBDA = 94,
  anon_sym_STATE = 95,
  anon_sym_ACTION = 96,
  anon_sym_TEMPORAL = 97,
  anon_sym_OBVIOUS = 98,
  anon_sym_OMITTED = 99,
  anon_sym_LEMMA = 100,
  anon_sym_PROPOSITION = 101,
  anon_sym_ONLY = 102,
  anon_sym_COMMA = 103,
  anon_sym_LPAREN = 104,
  anon_sym_RPAREN = 105,
  anon_sym_LBRACK = 106,
  anon_sym_RBRACK = 107,
  anon_sym_BANG = 108,
  aux_sym_child_id_token1 = 109,
  sym_real_number = 110,
  anon_sym_BSLASHb = 111,
  anon_sym_BSLASHB = 112,
  aux_sym_binary_number_token1 = 113,
  anon_sym_BSLASHo = 114,
  anon_sym_BSLASHO = 115,
  aux_sym_octal_number_token1 = 116,
  anon_sym_BSLASHh = 117,
  anon_sym_BSLASHH = 118,
  aux_sym_hex_number_token1 = 119,
  anon_sym_DQUOTE = 120,
  aux_sym_string_token1 = 121,
  anon_sym_DQUOTE2 = 122,
  anon_sym_BSLASH = 123,
  aux_sym_escape_char_token1 = 124,
  anon_sym_TRUE = 125,
  anon_sym_FALSE = 126,
  sym_string_set = 127,
  sym_boolean_set = 128,
  anon_sym_Nat = 129,
  anon_sym_17 = 130,
  anon_sym_Int = 131,
  anon_sym_18 = 132,
  anon_sym_Real = 133,
  anon_sym_19 = 134,
  anon_sym_LBRACE = 135,
  anon_sym_RBRACE = 136,
  anon_sym_DOT = 137,
  anon_sym_EQ = 138,
  anon_sym_RBRACK_ = 139,
  anon_sym_BSLASHlnot = 140,
  anon_sym_BSLASHneg = 141,
  anon_sym_TILDE = 142,
  anon_sym_20 = 143,
  anon_sym_DASH = 144,
  sym_negative_dot = 145,
  anon_sym_LT_GT = 146,
  anon_sym_21 = 147,
  anon_sym_EQ_GT = 148,
  anon_sym_22 = 149,
  anon_sym_23 = 150,
  anon_sym_DASH_PLUS_DASH_GT = 151,
  anon_sym_24 = 152,
  anon_sym_25 = 153,
  anon_sym_BSLASHequiv = 154,
  anon_sym_26 = 155,
  anon_sym_LT_EQ_GT = 156,
  anon_sym_27 = 157,
  anon_sym_28 = 158,
  anon_sym_TILDE_GT = 159,
  anon_sym_29 = 160,
  anon_sym_30 = 161,
  anon_sym_SLASH_BSLASH = 162,
  anon_sym_BSLASHland = 163,
  anon_sym_31 = 164,
  anon_sym_BSLASH_SLASH = 165,
  anon_sym_BSLASHlor = 166,
  anon_sym_32 = 167,
  anon_sym_COLON_EQ = 168,
  anon_sym_33 = 169,
  anon_sym_COLON_COLON_EQ = 170,
  anon_sym_34 = 171,
  anon_sym_SLASH_EQ = 172,
  anon_sym_POUND = 173,
  anon_sym_35 = 174,
  anon_sym_LT = 175,
  sym_gt = 176,
  anon_sym_LT_EQ = 177,
  anon_sym_EQ_LT = 178,
  anon_sym_BSLASHleq = 179,
  anon_sym_36 = 180,
  anon_sym_GT_EQ = 181,
  anon_sym_BSLASHgeq = 182,
  anon_sym_37 = 183,
  anon_sym_BSLASHapprox = 184,
  anon_sym_38 = 185,
  anon_sym_PIPE_DASH = 186,
  anon_sym_39 = 187,
  anon_sym_PIPE_EQ = 188,
  anon_sym_40 = 189,
  anon_sym_DASH_PIPE = 190,
  anon_sym_41 = 191,
  anon_sym_EQ_PIPE = 192,
  anon_sym_42 = 193,
  anon_sym_BSLASHasymp = 194,
  anon_sym_43 = 195,
  anon_sym_BSLASHcong = 196,
  anon_sym_44 = 197,
  anon_sym_BSLASHdoteq = 198,
  anon_sym_45 = 199,
  anon_sym_BSLASHgg = 200,
  anon_sym_46 = 201,
  anon_sym_BSLASHll = 202,
  anon_sym_47 = 203,
  anon_sym_BSLASHnotin = 204,
  anon_sym_48 = 205,
  anon_sym_BSLASHprec = 206,
  anon_sym_49 = 207,
  anon_sym_BSLASHsucc = 208,
  anon_sym_50 = 209,
  anon_sym_BSLASHpreceq = 210,
  anon_sym_51 = 211,
  anon_sym_BSLASHsucceq = 212,
  anon_sym_52 = 213,
  anon_sym_BSLASHpropto = 214,
  anon_sym_53 = 215,
  anon_sym_BSLASHsim = 216,
  anon_sym_54 = 217,
  anon_sym_BSLASHsimeq = 218,
  anon_sym_55 = 219,
  anon_sym_BSLASHsqsubset = 220,
  anon_sym_56 = 221,
  anon_sym_BSLASHsqsupset = 222,
  anon_sym_57 = 223,
  anon_sym_BSLASHsqsubseteq = 224,
  anon_sym_58 = 225,
  anon_sym_BSLASHsqsupseteq = 226,
  anon_sym_59 = 227,
  anon_sym_BSLASHsubset = 228,
  anon_sym_60 = 229,
  anon_sym_BSLASHsupset = 230,
  anon_sym_61 = 231,
  anon_sym_BSLASHsubseteq = 232,
  anon_sym_62 = 233,
  anon_sym_BSLASHsupseteq = 234,
  anon_sym_63 = 235,
  sym_compose = 236,
  sym_map_to = 237,
  sym_map_from = 238,
  sym_setminus = 239,
  anon_sym_BSLASHcap = 240,
  anon_sym_BSLASHintersect = 241,
  anon_sym_64 = 242,
  anon_sym_BSLASHcup = 243,
  anon_sym_BSLASHunion = 244,
  anon_sym_65 = 245,
  anon_sym_DOT_DOT = 246,
  anon_sym_66 = 247,
  anon_sym_DOT_DOT_DOT = 248,
  anon_sym_67 = 249,
  anon_sym_PLUS = 250,
  sym_plusplus = 251,
  anon_sym_BSLASHoplus = 252,
  anon_sym_LPAREN_PLUS_RPAREN = 253,
  anon_sym_68 = 254,
  anon_sym_BSLASHominus = 255,
  anon_sym_LPAREN_DASH_RPAREN = 256,
  anon_sym_69 = 257,
  sym_mod = 258,
  sym_modmod = 259,
  sym_vert = 260,
  anon_sym_PIPE_PIPE = 261,
  anon_sym_70 = 262,
  sym_minusminus = 263,
  sym_amp = 264,
  sym_ampamp = 265,
  anon_sym_BSLASHodot = 266,
  anon_sym_LPAREN_DOT_RPAREN = 267,
  anon_sym_71 = 268,
  anon_sym_BSLASHoslash = 269,
  anon_sym_LPAREN_SLASH_RPAREN = 270,
  anon_sym_72 = 271,
  anon_sym_BSLASHotimes = 272,
  anon_sym_LPAREN_BSLASHX_RPAREN = 273,
  anon_sym_73 = 274,
  sym_mul = 275,
  sym_mulmul = 276,
  sym_slash = 277,
  sym_slashslash = 278,
  anon_sym_BSLASHbigcirc = 279,
  anon_sym_74 = 280,
  anon_sym_BSLASHbullet = 281,
  anon_sym_75 = 282,
  anon_sym_BSLASHdiv = 283,
  anon_sym_76 = 284,
  anon_sym_BSLASHcirc = 285,
  anon_sym_77 = 286,
  anon_sym_BSLASHstar = 287,
  anon_sym_78 = 288,
  anon_sym_BANG_BANG = 289,
  anon_sym_79 = 290,
  anon_sym_QMARK_QMARK = 291,
  anon_sym_80 = 292,
  sym_hashhash = 293,
  sym_dol = 294,
  sym_doldol = 295,
  anon_sym_BSLASHsqcap = 296,
  anon_sym_81 = 297,
  anon_sym_BSLASHsqcup = 298,
  anon_sym_82 = 299,
  anon_sym_BSLASHuplus = 300,
  anon_sym_83 = 301,
  anon_sym_BSLASHX = 302,
  anon_sym_BSLASHtimes = 303,
  anon_sym_84 = 304,
  anon_sym_BSLASHwr = 305,
  anon_sym_85 = 306,
  anon_sym_BSLASHcdot = 307,
  anon_sym_86 = 308,
  sym_pow = 309,
  sym_powpow = 310,
  anon_sym_CARET_PLUS = 311,
  anon_sym_87 = 312,
  sym_asterisk = 313,
  sym_sup_hash = 314,
  sym_prime = 315,
  aux_sym_proof_step_id_token1 = 316,
  anon_sym_GT = 317,
  aux_sym_proof_step_id_token2 = 318,
  aux_sym_proof_step_id_token3 = 319,
  aux_sym_proof_step_ref_token1 = 320,
  aux_sym_proof_step_ref_token2 = 321,
  anon_sym_end = 322,
  anon_sym_algorithm = 323,
  anon_sym_SEMI = 324,
  sym_pcal_algorithm_start = 325,
  anon_sym_define = 326,
  anon_sym_macro = 327,
  anon_sym_procedure = 328,
  anon_sym_fair = 329,
  anon_sym_process = 330,
  anon_sym_variable = 331,
  anon_sym_variables = 332,
  anon_sym_begin = 333,
  anon_sym_if = 334,
  anon_sym_then = 335,
  anon_sym_elsif = 336,
  anon_sym_else = 337,
  anon_sym_while = 338,
  anon_sym_do = 339,
  anon_sym_either = 340,
  anon_sym_or = 341,
  anon_sym_with = 342,
  anon_sym_await = 343,
  anon_sym_when = 344,
  anon_sym_print = 345,
  anon_sym_assert = 346,
  anon_sym_skip = 347,
  anon_sym_return = 348,
  anon_sym_goto = 349,
  anon_sym_call = 350,
  sym_extramodular_text = 351,
  sym__indent = 352,
  sym_bullet_conj = 353,
  sym_bullet_disj = 354,
  sym__dedent = 355,
  sym__begin_proof = 356,
  sym__begin_proof_step = 357,
  sym_proof_keyword = 358,
  sym_by_keyword = 359,
  sym_obvious_keyword = 360,
  sym_omitted_keyword = 361,
  sym_qed_keyword = 362,
  sym__error_sentinel = 363,
  sym_source_file = 364,
  sym_block_comment = 365,
  sym_block_comment_text = 366,
  sym_module = 367,
  sym_def_eq = 368,
  sym_set_in = 369,
  sym_gets = 370,
  sym_forall = 371,
  sym_exists = 372,
  sym_temporal_forall = 373,
  sym_temporal_exists = 374,
  sym_all_map_to = 375,
  sym_maps_to = 376,
  sym_langle_bracket = 377,
  sym_rangle_bracket = 378,
  sym_rangle_bracket_sub = 379,
  sym_case_box = 380,
  sym_case_arrow = 381,
  sym_colon = 382,
  sym_address = 383,
  sym_label_as = 384,
  sym_extends = 385,
  sym__unit = 386,
  sym_local_definition = 387,
  sym__definition = 388,
  sym_variable_declaration = 389,
  sym_constant_declaration = 390,
  sym_recursive_declaration = 391,
  sym_operator_declaration = 392,
  sym__id_or_op_declaration = 393,
  sym_operator_definition = 394,
  sym_function_definition = 395,
  sym_quantifier_bound = 396,
  sym_single_quantifier_bound = 397,
  sym_tuple_of_identifiers = 398,
  sym_instance = 399,
  sym_substitution = 400,
  sym__op_or_expr = 401,
  sym__op = 402,
  sym_subexpr_prefix = 403,
  sym_subexpr_component = 404,
  sym_bound_op = 405,
  sym_bound_nonfix_op = 406,
  sym_subexpr_tree_nav = 407,
  sym_child_id = 408,
  sym_operator_args = 409,
  sym_lambda = 410,
  sym_module_definition = 411,
  sym__expr = 412,
  sym__subscript_expr = 413,
  sym_prefixed_op = 414,
  sym__number = 415,
  sym_nat_number = 416,
  sym_binary_number = 417,
  sym_octal_number = 418,
  sym_hex_number = 419,
  sym_string = 420,
  sym_escape_char = 421,
  sym_boolean = 422,
  sym__primitive_value_set = 423,
  sym_nat_number_set = 424,
  sym_int_number_set = 425,
  sym_real_number_set = 426,
  sym_label = 427,
  sym_subexpression = 428,
  sym_parentheses = 429,
  sym_bounded_quantification = 430,
  sym_unbounded_quantification = 431,
  sym_choose = 432,
  sym_finite_set_literal = 433,
  sym_set_filter = 434,
  sym_set_map = 435,
  sym_function_evaluation = 436,
  sym_function_literal = 437,
  sym_set_of_functions = 438,
  sym_record_literal = 439,
  sym_set_of_records = 440,
  sym_record_value = 441,
  sym_except = 442,
  aux_sym__except_val = 443,
  sym_prev_func_val = 444,
  sym_tuple_literal = 445,
  sym_step_expr_or_stutter = 446,
  sym_step_expr_no_stutter = 447,
  sym_fairness = 448,
  sym_if_then_else = 449,
  sym_case = 450,
  sym_case_arm = 451,
  sym_other_arm = 452,
  sym_let_in = 453,
  sym_conj_list = 454,
  sym_conj_item = 455,
  sym_disj_list = 456,
  sym_disj_item = 457,
  sym_lnot = 458,
  sym_union = 459,
  sym_powerset = 460,
  sym_domain = 461,
  sym_negative = 462,
  sym_enabled = 463,
  sym_unchanged = 464,
  sym_always = 465,
  sym_eventually = 466,
  sym_prefix_op_symbol = 467,
  sym_bound_prefix_op = 468,
  sym_implies = 469,
  sym_plus_arrow = 470,
  sym_equiv = 471,
  sym_iff = 472,
  sym_leads_to = 473,
  sym_land = 474,
  sym_lor = 475,
  sym_assign = 476,
  sym_bnf_rule = 477,
  sym_eq = 478,
  sym_neq = 479,
  sym_lt = 480,
  sym_leq = 481,
  sym_geq = 482,
  sym_approx = 483,
  sym_rs_ttile = 484,
  sym_rd_ttile = 485,
  sym_ls_ttile = 486,
  sym_ld_ttile = 487,
  sym_asymp = 488,
  sym_cong = 489,
  sym_doteq = 490,
  sym_gg = 491,
  sym_ll = 492,
  sym_in = 493,
  sym_notin = 494,
  sym_prec = 495,
  sym_succ = 496,
  sym_preceq = 497,
  sym_succeq = 498,
  sym_propto = 499,
  sym_sim = 500,
  sym_simeq = 501,
  sym_sqsubset = 502,
  sym_sqsupset = 503,
  sym_sqsubseteq = 504,
  sym_sqsupseteq = 505,
  sym_subset = 506,
  sym_supset = 507,
  sym_subseteq = 508,
  sym_supseteq = 509,
  sym_cap = 510,
  sym_cup = 511,
  sym_dots_2 = 512,
  sym_dots_3 = 513,
  sym_plus = 514,
  sym_oplus = 515,
  sym_ominus = 516,
  sym_vertvert = 517,
  sym_minus = 518,
  sym_odot = 519,
  sym_oslash = 520,
  sym_otimes = 521,
  sym_bigcirc = 522,
  sym_bullet = 523,
  sym_div = 524,
  sym_circ = 525,
  sym_star = 526,
  sym_excl = 527,
  sym_qq = 528,
  sym_sqcap = 529,
  sym_sqcup = 530,
  sym_uplus = 531,
  sym_times = 532,
  sym_wr = 533,
  sym_cdot = 534,
  sym_infix_op_symbol = 535,
  sym_bound_infix_op = 536,
  sym_sup_plus = 537,
  sym_postfix_op_symbol = 538,
  sym_bound_postfix_op = 539,
  sym_assumption = 540,
  sym_theorem = 541,
  sym_assume_prove = 542,
  sym_inner_assume_prove = 543,
  sym_new = 544,
  sym_level = 545,
  sym__proof = 546,
  sym_terminal_proof = 547,
  sym_non_terminal_proof = 548,
  sym_proof_step = 549,
  sym_definition_proof_step = 550,
  sym_have_proof_step = 551,
  sym_witness_proof_step = 552,
  sym_take_proof_step = 553,
  sym_suffices_proof_step = 554,
  sym_case_proof_step = 555,
  sym_pick_proof_step = 556,
  sym__bound_or_identifier_list = 557,
  sym_qed_step = 558,
  sym_use_or_hide = 559,
  sym_use_body = 560,
  sym_use_body_expr = 561,
  sym_use_body_def = 562,
  sym_module_ref = 563,
  sym_proof_step_id = 564,
  sym_proof_step_ref = 565,
  sym_pcal_algorithm = 566,
  sym__pcal_p_algorithm = 567,
  sym__pcal_c_algorithm = 568,
  sym_pcal_p_definitions = 569,
  sym_pcal_c_definitions = 570,
  sym_pcal_p_macro = 571,
  sym_pcal_c_macro = 572,
  sym_pcal_macro_decl = 573,
  sym_pcal_p_procedure = 574,
  sym_pcal_c_procedure = 575,
  sym_pcal_proc_decl = 576,
  sym_pcal_p_process = 577,
  sym_pcal_c_process = 578,
  sym_pcal_var_decls = 579,
  sym_pcal_var_decl = 580,
  sym_pcal_proc_var_decls = 581,
  sym_pcal_proc_var_decl = 582,
  sym_pcal_p_algorithm_body = 583,
  sym__pcal_p_stmts = 584,
  sym_pcal_c_algorithm_body = 585,
  sym__pcal_p_stmt = 586,
  sym__pcal_c_stmt = 587,
  sym__pcal_label = 588,
  sym__pcal_p_unlabeled_stmt = 589,
  sym__pcal_c_unlabeled_stmt = 590,
  sym_pcal_assign = 591,
  sym_pcal_lhs = 592,
  sym_pcal_p_if = 593,
  sym_pcal_c_if = 594,
  sym_pcal_p_while = 595,
  sym_pcal_c_while = 596,
  sym_pcal_p_either = 597,
  sym_pcal_c_either = 598,
  sym_pcal_p_with = 599,
  sym_pcal_c_with = 600,
  sym__pcal_with_vars = 601,
  sym_pcal_await = 602,
  sym_pcal_print = 603,
  sym_pcal_assert = 604,
  sym_pcal_skip = 605,
  sym_pcal_return = 606,
  sym_pcal_goto = 607,
  sym_pcal_proc_call = 608,
  sym_pcal_macro_call = 609,
  aux_sym_source_file_repeat1 = 610,
  aux_sym_block_comment_repeat1 = 611,
  aux_sym_block_comment_text_repeat1 = 612,
  aux_sym_module_repeat1 = 613,
  aux_sym_extends_repeat1 = 614,
  aux_sym_variable_declaration_repeat1 = 615,
  aux_sym_constant_declaration_repeat1 = 616,
  aux_sym_operator_declaration_repeat1 = 617,
  aux_sym_function_definition_repeat1 = 618,
  aux_sym_instance_repeat1 = 619,
  aux_sym_subexpr_prefix_repeat1 = 620,
  aux_sym_bound_op_repeat1 = 621,
  aux_sym_string_repeat1 = 622,
  aux_sym_finite_set_literal_repeat1 = 623,
  aux_sym_record_literal_repeat1 = 624,
  aux_sym_set_of_records_repeat1 = 625,
  aux_sym_except_repeat1 = 626,
  aux_sym_case_repeat1 = 627,
  aux_sym_let_in_repeat1 = 628,
  aux_sym_conj_list_repeat1 = 629,
  aux_sym_disj_list_repeat1 = 630,
  aux_sym_assume_prove_repeat1 = 631,
  aux_sym_non_terminal_proof_repeat1 = 632,
  aux_sym_definition_proof_step_repeat1 = 633,
  aux_sym_use_body_expr_repeat1 = 634,
  aux_sym_use_body_def_repeat1 = 635,
  aux_sym__pcal_p_algorithm_repeat1 = 636,
  aux_sym__pcal_p_algorithm_repeat2 = 637,
  aux_sym__pcal_p_algorithm_repeat3 = 638,
  aux_sym__pcal_c_algorithm_repeat1 = 639,
  aux_sym__pcal_c_algorithm_repeat2 = 640,
  aux_sym__pcal_c_algorithm_repeat3 = 641,
  aux_sym_pcal_p_definitions_repeat1 = 642,
  aux_sym_pcal_macro_decl_repeat1 = 643,
  aux_sym_pcal_proc_decl_repeat1 = 644,
  aux_sym_pcal_var_decls_repeat1 = 645,
  aux_sym_pcal_proc_var_decls_repeat1 = 646,
  aux_sym__pcal_p_stmts_repeat1 = 647,
  aux_sym_pcal_c_algorithm_body_repeat1 = 648,
  aux_sym_pcal_assign_repeat1 = 649,
  aux_sym_pcal_lhs_repeat1 = 650,
  aux_sym_pcal_p_if_repeat1 = 651,
  aux_sym_pcal_p_either_repeat1 = 652,
  aux_sym_pcal_c_either_repeat1 = 653,
  aux_sym__pcal_with_vars_repeat1 = 654,
  alias_sym_header_line = 655,
  alias_sym_identifier_ref = 656,
  alias_sym_pcal_end_either = 657,
  alias_sym_pcal_end_if = 658,
  alias_sym_pcal_end_while = 659,
  alias_sym_pcal_end_with = 660,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_STAR_RPAREN] = "*)",
  [aux_sym_block_comment_text_token1] = "block_comment_text_token1",
  [aux_sym_block_comment_text_token2] = "block_comment_text_token2",
  [aux_sym_block_comment_text_token3] = "block_comment_text_token3",
  [aux_sym_block_comment_text_token4] = "block_comment_text_token4",
  [anon_sym_MODULE] = "MODULE",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_] = "≜",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_2] = "∈",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_3] = "⟵",
  [anon_sym_4] = "←",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_5] = "∀",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_6] = "∃",
  [anon_sym_BSLASHAA] = "\\AA",
  [anon_sym_BSLASHEE] = "\\EE",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_7] = "⟼",
  [anon_sym_8] = "↦",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_9] = "⟶",
  [anon_sym_10] = "→",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_11] = "〈",
  [anon_sym_12] = "⟨",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_13] = "〉",
  [anon_sym_14] = "⟩",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym__] = "〉_",
  [anon_sym__2] = "⟩_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_15] = "□",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_16] = "∷",
  [sym_placeholder] = "placeholder",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_ENABLED] = "ENABLED",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CASE] = "CASE",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_SF_] = "SF_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_IF] = "IF",
  [anon_sym_SUBSET] = "SUBSET",
  [anon_sym_WITH] = "WITH",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_IN] = "IN",
  [anon_sym_THEN] = "THEN",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_DOMAIN] = "DOMAIN",
  [anon_sym_LET] = "LET",
  [anon_sym_UNCHANGED] = "UNCHANGED",
  [anon_sym_BY] = "BY",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_QED] = "QED",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_USE] = "USE",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_PICK] = "PICK",
  [anon_sym_DEFS] = "DEFS",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_NEW] = "NEW",
  [anon_sym_LAMBDA] = "LAMBDA",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_ONLY] = "ONLY",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [sym_real_number] = "real_number",
  [anon_sym_BSLASHb] = "format",
  [anon_sym_BSLASHB] = "format",
  [aux_sym_binary_number_token1] = "value",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHO] = "format",
  [aux_sym_octal_number_token1] = "value",
  [anon_sym_BSLASHh] = "format",
  [anon_sym_BSLASHH] = "format",
  [aux_sym_hex_number_token1] = "value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_char_token1] = "escape_char_token1",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [sym_string_set] = "string_set",
  [sym_boolean_set] = "boolean_set",
  [anon_sym_Nat] = "Nat",
  [anon_sym_17] = "ℕ",
  [anon_sym_Int] = "Int",
  [anon_sym_18] = "ℤ",
  [anon_sym_Real] = "Real",
  [anon_sym_19] = "ℝ",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_20] = "¬",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_21] = "⋄",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_22] = "⟹",
  [anon_sym_23] = "⇒",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_24] = "⇸",
  [anon_sym_25] = "⥅",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_26] = "≡",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_27] = "⟺",
  [anon_sym_28] = "⇔",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_29] = "⇝",
  [anon_sym_30] = "↝",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_31] = "∧",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_32] = "∨",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_33] = "≔",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_34] = "⩴",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_35] = "≠",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_36] = "≤",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_37] = "≥",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_38] = "≈",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_39] = "⊢",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_40] = "⊨",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_41] = "⊣",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_42] = "⫤",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_43] = "≍",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_44] = "≅",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_45] = "≐",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_46] = "≫",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_47] = "≪",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_48] = "∉",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_49] = "≺",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_50] = "≻",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_51] = "⪯",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_52] = "⪰",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_53] = "∝",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_54] = "∼",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_55] = "≃",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_56] = "⊏",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_57] = "⊐",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_58] = "⊑",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_59] = "⊒",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_60] = "⊂",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_61] = "⊃",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_62] = "⊆",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_63] = "⊇",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_64] = "∩",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_65] = "∪",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_66] = "‥",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_67] = "…",
  [anon_sym_PLUS] = "+",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_68] = "⊕",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_69] = "⊖",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_70] = "‖",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_71] = "⊙",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_72] = "⊘",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_73] = "⊗",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_74] = "◯",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_75] = "●",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_76] = "÷",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_77] = "∘",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_78] = "⋆",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_79] = "‼",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_80] = "⁇",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_81] = "⊓",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_82] = "⊔",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_83] = "⊎",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_84] = "×",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_85] = "≀",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_86] = "⋅",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_87] = "⁺",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [anon_sym_end] = "end",
  [anon_sym_algorithm] = "algorithm",
  [anon_sym_SEMI] = ";",
  [sym_pcal_algorithm_start] = "pcal_algorithm_start",
  [anon_sym_define] = "define",
  [anon_sym_macro] = "macro",
  [anon_sym_procedure] = "procedure",
  [anon_sym_fair] = "fair",
  [anon_sym_process] = "process",
  [anon_sym_variable] = "variable",
  [anon_sym_variables] = "variables",
  [anon_sym_begin] = "begin",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elsif] = "elsif",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_either] = "either",
  [anon_sym_or] = "or",
  [anon_sym_with] = "with",
  [anon_sym_await] = "await",
  [anon_sym_when] = "when",
  [anon_sym_print] = "print",
  [anon_sym_assert] = "assert",
  [anon_sym_skip] = "skip",
  [anon_sym_return] = "return",
  [anon_sym_goto] = "goto",
  [anon_sym_call] = "call",
  [sym_extramodular_text] = "extramodular_text",
  [sym__indent] = "_indent",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym_proof_keyword] = "PROOF",
  [sym_by_keyword] = "BY",
  [sym_obvious_keyword] = "OBVIOUS",
  [sym_omitted_keyword] = "OMITTED",
  [sym_qed_keyword] = "QED",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_block_comment_text] = "block_comment_text",
  [sym_module] = "module",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_extends] = "extends",
  [sym__unit] = "_unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_single_quantifier_bound] = "single_quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym__op] = "_op",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym__number] = "_number",
  [sym_nat_number] = "nat_number",
  [sym_binary_number] = "binary_number",
  [sym_octal_number] = "octal_number",
  [sym_hex_number] = "hex_number",
  [sym_string] = "string",
  [sym_escape_char] = "escape_char",
  [sym_boolean] = "boolean",
  [sym__primitive_value_set] = "_primitive_value_set",
  [sym_nat_number_set] = "nat_number_set",
  [sym_int_number_set] = "int_number_set",
  [sym_real_number_set] = "real_number_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [aux_sym__except_val] = "_except_val",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [sym_negative] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_prefix_op_symbol] = "prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_plus] = "plus",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_level] = "level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [sym_pcal_algorithm] = "pcal_algorithm",
  [sym__pcal_p_algorithm] = "_pcal_p_algorithm",
  [sym__pcal_c_algorithm] = "_pcal_c_algorithm",
  [sym_pcal_p_definitions] = "pcal_definitions",
  [sym_pcal_c_definitions] = "pcal_definitions",
  [sym_pcal_p_macro] = "pcal_macro",
  [sym_pcal_c_macro] = "pcal_macro",
  [sym_pcal_macro_decl] = "pcal_macro_decl",
  [sym_pcal_p_procedure] = "pcal_procedure",
  [sym_pcal_c_procedure] = "pcal_procedure",
  [sym_pcal_proc_decl] = "pcal_proc_decl",
  [sym_pcal_p_process] = "pcal_process",
  [sym_pcal_c_process] = "pcal_process",
  [sym_pcal_var_decls] = "pcal_var_decls",
  [sym_pcal_var_decl] = "pcal_var_decl",
  [sym_pcal_proc_var_decls] = "pcal_proc_var_decls",
  [sym_pcal_proc_var_decl] = "pcal_proc_var_decl",
  [sym_pcal_p_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmts] = "_pcal_p_stmts",
  [sym_pcal_c_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmt] = "_pcal_p_stmt",
  [sym__pcal_c_stmt] = "_pcal_c_stmt",
  [sym__pcal_label] = "_pcal_label",
  [sym__pcal_p_unlabeled_stmt] = "_pcal_p_unlabeled_stmt",
  [sym__pcal_c_unlabeled_stmt] = "_pcal_c_unlabeled_stmt",
  [sym_pcal_assign] = "pcal_assign",
  [sym_pcal_lhs] = "pcal_lhs",
  [sym_pcal_p_if] = "pcal_if",
  [sym_pcal_c_if] = "pcal_if",
  [sym_pcal_p_while] = "pcal_while",
  [sym_pcal_c_while] = "pcal_while",
  [sym_pcal_p_either] = "pcal_either",
  [sym_pcal_c_either] = "pcal_either",
  [sym_pcal_p_with] = "pcal_with",
  [sym_pcal_c_with] = "pcal_with",
  [sym__pcal_with_vars] = "_pcal_with_vars",
  [sym_pcal_await] = "pcal_await",
  [sym_pcal_print] = "pcal_print",
  [sym_pcal_assert] = "pcal_assert",
  [sym_pcal_skip] = "pcal_skip",
  [sym_pcal_return] = "pcal_return",
  [sym_pcal_goto] = "pcal_goto",
  [sym_pcal_proc_call] = "pcal_proc_call",
  [sym_pcal_macro_call] = "pcal_macro_call",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_block_comment_text_repeat1] = "block_comment_text_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [aux_sym__pcal_p_algorithm_repeat1] = "_pcal_p_algorithm_repeat1",
  [aux_sym__pcal_p_algorithm_repeat2] = "_pcal_p_algorithm_repeat2",
  [aux_sym__pcal_p_algorithm_repeat3] = "_pcal_p_algorithm_repeat3",
  [aux_sym__pcal_c_algorithm_repeat1] = "_pcal_c_algorithm_repeat1",
  [aux_sym__pcal_c_algorithm_repeat2] = "_pcal_c_algorithm_repeat2",
  [aux_sym__pcal_c_algorithm_repeat3] = "_pcal_c_algorithm_repeat3",
  [aux_sym_pcal_p_definitions_repeat1] = "pcal_p_definitions_repeat1",
  [aux_sym_pcal_macro_decl_repeat1] = "pcal_macro_decl_repeat1",
  [aux_sym_pcal_proc_decl_repeat1] = "pcal_proc_decl_repeat1",
  [aux_sym_pcal_var_decls_repeat1] = "pcal_var_decls_repeat1",
  [aux_sym_pcal_proc_var_decls_repeat1] = "pcal_proc_var_decls_repeat1",
  [aux_sym__pcal_p_stmts_repeat1] = "_pcal_p_stmts_repeat1",
  [aux_sym_pcal_c_algorithm_body_repeat1] = "pcal_c_algorithm_body_repeat1",
  [aux_sym_pcal_assign_repeat1] = "pcal_assign_repeat1",
  [aux_sym_pcal_lhs_repeat1] = "pcal_lhs_repeat1",
  [aux_sym_pcal_p_if_repeat1] = "pcal_p_if_repeat1",
  [aux_sym_pcal_p_either_repeat1] = "pcal_p_either_repeat1",
  [aux_sym_pcal_c_either_repeat1] = "pcal_c_either_repeat1",
  [aux_sym__pcal_with_vars_repeat1] = "_pcal_with_vars_repeat1",
  [alias_sym_header_line] = "header_line",
  [alias_sym_identifier_ref] = "identifier_ref",
  [alias_sym_pcal_end_either] = "pcal_end_either",
  [alias_sym_pcal_end_if] = "pcal_end_if",
  [alias_sym_pcal_end_while] = "pcal_end_while",
  [alias_sym_pcal_end_with] = "pcal_end_with",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_STAR_RPAREN] = anon_sym_STAR_RPAREN,
  [aux_sym_block_comment_text_token1] = aux_sym_block_comment_text_token1,
  [aux_sym_block_comment_text_token2] = aux_sym_block_comment_text_token2,
  [aux_sym_block_comment_text_token3] = aux_sym_block_comment_text_token3,
  [aux_sym_block_comment_text_token4] = aux_sym_block_comment_text_token4,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_] = anon_sym_,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_6] = anon_sym_6,
  [anon_sym_BSLASHAA] = anon_sym_BSLASHAA,
  [anon_sym_BSLASHEE] = anon_sym_BSLASHEE,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_7] = anon_sym_7,
  [anon_sym_8] = anon_sym_8,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_9] = anon_sym_9,
  [anon_sym_10] = anon_sym_10,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_11] = anon_sym_11,
  [anon_sym_12] = anon_sym_12,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_13] = anon_sym_13,
  [anon_sym_14] = anon_sym_14,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym__] = anon_sym__,
  [anon_sym__2] = anon_sym__2,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_15] = anon_sym_15,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_16] = anon_sym_16,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_ENABLED] = anon_sym_ENABLED,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_SUBSET] = anon_sym_SUBSET,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_DOMAIN] = anon_sym_DOMAIN,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_UNCHANGED] = anon_sym_UNCHANGED,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [sym_real_number] = sym_real_number,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHB] = anon_sym_BSLASHb,
  [aux_sym_binary_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHO] = anon_sym_BSLASHb,
  [aux_sym_octal_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHh] = anon_sym_BSLASHb,
  [anon_sym_BSLASHH] = anon_sym_BSLASHb,
  [aux_sym_hex_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_char_token1] = aux_sym_escape_char_token1,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [sym_string_set] = sym_string_set,
  [sym_boolean_set] = sym_boolean_set,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_17] = anon_sym_17,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_18] = anon_sym_18,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_19] = anon_sym_19,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_20] = anon_sym_20,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_21] = anon_sym_21,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_22] = anon_sym_22,
  [anon_sym_23] = anon_sym_23,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_24] = anon_sym_24,
  [anon_sym_25] = anon_sym_25,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_26] = anon_sym_26,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_27] = anon_sym_27,
  [anon_sym_28] = anon_sym_28,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_29] = anon_sym_29,
  [anon_sym_30] = anon_sym_30,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_31] = anon_sym_31,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_32] = anon_sym_32,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_33] = anon_sym_33,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_34] = anon_sym_34,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_35] = anon_sym_35,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_36] = anon_sym_36,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_37] = anon_sym_37,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_38] = anon_sym_38,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_39] = anon_sym_39,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_40] = anon_sym_40,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_41] = anon_sym_41,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_42] = anon_sym_42,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_43] = anon_sym_43,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_44] = anon_sym_44,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_45] = anon_sym_45,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_46] = anon_sym_46,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_47] = anon_sym_47,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_48] = anon_sym_48,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_49] = anon_sym_49,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_50] = anon_sym_50,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_51] = anon_sym_51,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_52] = anon_sym_52,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_53] = anon_sym_53,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_54] = anon_sym_54,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_55] = anon_sym_55,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_56] = anon_sym_56,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_57] = anon_sym_57,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_58] = anon_sym_58,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_59] = anon_sym_59,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_60] = anon_sym_60,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_61] = anon_sym_61,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_62] = anon_sym_62,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_63] = anon_sym_63,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_64] = anon_sym_64,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_65] = anon_sym_65,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_66] = anon_sym_66,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_67] = anon_sym_67,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_68] = anon_sym_68,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_69] = anon_sym_69,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_70] = anon_sym_70,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_71] = anon_sym_71,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_72] = anon_sym_72,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_73] = anon_sym_73,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_74] = anon_sym_74,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_75] = anon_sym_75,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_76] = anon_sym_76,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_77] = anon_sym_77,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_78] = anon_sym_78,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_79] = anon_sym_79,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_80] = anon_sym_80,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_81] = anon_sym_81,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_82] = anon_sym_82,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_83] = anon_sym_83,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_84] = anon_sym_84,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_85] = anon_sym_85,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_86] = anon_sym_86,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_87] = anon_sym_87,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [aux_sym_proof_step_id_token1] = sym_level,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = sym_level,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_algorithm] = anon_sym_algorithm,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym_pcal_algorithm_start] = sym_pcal_algorithm_start,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_procedure] = anon_sym_procedure,
  [anon_sym_fair] = anon_sym_fair,
  [anon_sym_process] = anon_sym_process,
  [anon_sym_variable] = anon_sym_variable,
  [anon_sym_variables] = anon_sym_variables,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_either] = anon_sym_either,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_skip] = anon_sym_skip,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_call] = anon_sym_call,
  [sym_extramodular_text] = sym_extramodular_text,
  [sym__indent] = sym__indent,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym_proof_keyword] = anon_sym_PROOF,
  [sym_by_keyword] = anon_sym_BY,
  [sym_obvious_keyword] = anon_sym_OBVIOUS,
  [sym_omitted_keyword] = anon_sym_OMITTED,
  [sym_qed_keyword] = anon_sym_QED,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_block_comment_text] = sym_block_comment_text,
  [sym_module] = sym_module,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_extends] = sym_extends,
  [sym__unit] = sym__unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_single_quantifier_bound] = sym_single_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym__op] = sym__op,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym__number] = sym__number,
  [sym_nat_number] = sym_nat_number,
  [sym_binary_number] = sym_binary_number,
  [sym_octal_number] = sym_octal_number,
  [sym_hex_number] = sym_hex_number,
  [sym_string] = sym_string,
  [sym_escape_char] = sym_escape_char,
  [sym_boolean] = sym_boolean,
  [sym__primitive_value_set] = sym__primitive_value_set,
  [sym_nat_number_set] = sym_nat_number_set,
  [sym_int_number_set] = sym_int_number_set,
  [sym_real_number_set] = sym_real_number_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [aux_sym__except_val] = aux_sym__except_val,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [sym_negative] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_prefix_op_symbol] = sym_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_plus] = sym_plus,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_level] = sym_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [sym_pcal_algorithm] = sym_pcal_algorithm,
  [sym__pcal_p_algorithm] = sym__pcal_p_algorithm,
  [sym__pcal_c_algorithm] = sym__pcal_c_algorithm,
  [sym_pcal_p_definitions] = sym_pcal_p_definitions,
  [sym_pcal_c_definitions] = sym_pcal_p_definitions,
  [sym_pcal_p_macro] = sym_pcal_p_macro,
  [sym_pcal_c_macro] = sym_pcal_p_macro,
  [sym_pcal_macro_decl] = sym_pcal_macro_decl,
  [sym_pcal_p_procedure] = sym_pcal_p_procedure,
  [sym_pcal_c_procedure] = sym_pcal_p_procedure,
  [sym_pcal_proc_decl] = sym_pcal_proc_decl,
  [sym_pcal_p_process] = sym_pcal_p_process,
  [sym_pcal_c_process] = sym_pcal_p_process,
  [sym_pcal_var_decls] = sym_pcal_var_decls,
  [sym_pcal_var_decl] = sym_pcal_var_decl,
  [sym_pcal_proc_var_decls] = sym_pcal_proc_var_decls,
  [sym_pcal_proc_var_decl] = sym_pcal_proc_var_decl,
  [sym_pcal_p_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmts] = sym__pcal_p_stmts,
  [sym_pcal_c_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmt] = sym__pcal_p_stmt,
  [sym__pcal_c_stmt] = sym__pcal_c_stmt,
  [sym__pcal_label] = sym__pcal_label,
  [sym__pcal_p_unlabeled_stmt] = sym__pcal_p_unlabeled_stmt,
  [sym__pcal_c_unlabeled_stmt] = sym__pcal_c_unlabeled_stmt,
  [sym_pcal_assign] = sym_pcal_assign,
  [sym_pcal_lhs] = sym_pcal_lhs,
  [sym_pcal_p_if] = sym_pcal_p_if,
  [sym_pcal_c_if] = sym_pcal_p_if,
  [sym_pcal_p_while] = sym_pcal_p_while,
  [sym_pcal_c_while] = sym_pcal_p_while,
  [sym_pcal_p_either] = sym_pcal_p_either,
  [sym_pcal_c_either] = sym_pcal_p_either,
  [sym_pcal_p_with] = sym_pcal_p_with,
  [sym_pcal_c_with] = sym_pcal_p_with,
  [sym__pcal_with_vars] = sym__pcal_with_vars,
  [sym_pcal_await] = sym_pcal_await,
  [sym_pcal_print] = sym_pcal_print,
  [sym_pcal_assert] = sym_pcal_assert,
  [sym_pcal_skip] = sym_pcal_skip,
  [sym_pcal_return] = sym_pcal_return,
  [sym_pcal_goto] = sym_pcal_goto,
  [sym_pcal_proc_call] = sym_pcal_proc_call,
  [sym_pcal_macro_call] = sym_pcal_macro_call,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_block_comment_text_repeat1] = aux_sym_block_comment_text_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [aux_sym__pcal_p_algorithm_repeat1] = aux_sym__pcal_p_algorithm_repeat1,
  [aux_sym__pcal_p_algorithm_repeat2] = aux_sym__pcal_p_algorithm_repeat2,
  [aux_sym__pcal_p_algorithm_repeat3] = aux_sym__pcal_p_algorithm_repeat3,
  [aux_sym__pcal_c_algorithm_repeat1] = aux_sym__pcal_c_algorithm_repeat1,
  [aux_sym__pcal_c_algorithm_repeat2] = aux_sym__pcal_c_algorithm_repeat2,
  [aux_sym__pcal_c_algorithm_repeat3] = aux_sym__pcal_c_algorithm_repeat3,
  [aux_sym_pcal_p_definitions_repeat1] = aux_sym_pcal_p_definitions_repeat1,
  [aux_sym_pcal_macro_decl_repeat1] = aux_sym_pcal_macro_decl_repeat1,
  [aux_sym_pcal_proc_decl_repeat1] = aux_sym_pcal_proc_decl_repeat1,
  [aux_sym_pcal_var_decls_repeat1] = aux_sym_pcal_var_decls_repeat1,
  [aux_sym_pcal_proc_var_decls_repeat1] = aux_sym_pcal_proc_var_decls_repeat1,
  [aux_sym__pcal_p_stmts_repeat1] = aux_sym__pcal_p_stmts_repeat1,
  [aux_sym_pcal_c_algorithm_body_repeat1] = aux_sym_pcal_c_algorithm_body_repeat1,
  [aux_sym_pcal_assign_repeat1] = aux_sym_pcal_assign_repeat1,
  [aux_sym_pcal_lhs_repeat1] = aux_sym_pcal_lhs_repeat1,
  [aux_sym_pcal_p_if_repeat1] = aux_sym_pcal_p_if_repeat1,
  [aux_sym_pcal_p_either_repeat1] = aux_sym_pcal_p_either_repeat1,
  [aux_sym_pcal_c_either_repeat1] = aux_sym_pcal_c_either_repeat1,
  [aux_sym__pcal_with_vars_repeat1] = aux_sym__pcal_with_vars_repeat1,
  [alias_sym_header_line] = alias_sym_header_line,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
  [alias_sym_pcal_end_either] = alias_sym_pcal_end_either,
  [alias_sym_pcal_end_if] = alias_sym_pcal_end_if,
  [alias_sym_pcal_end_while] = alias_sym_pcal_end_while,
  [alias_sym_pcal_end_with] = alias_sym_pcal_end_with,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_comment_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHEE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_11] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_16] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENABLED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOMAIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNCHANGED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_real_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHB] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_binary_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHO] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_octal_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHh] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHH] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_hex_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_set] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_set] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_33] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_34] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_35] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_36] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_37] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_38] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_39] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_41] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_42] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_43] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_44] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_45] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_46] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_47] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_49] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_50] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_51] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_52] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_53] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_54] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_55] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_57] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_58] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_59] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_60] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_61] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_62] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_63] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_65] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_66] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_67] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_68] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_69] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_70] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_71] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_73] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_74] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_75] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_76] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_77] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_78] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_79] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_80] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_81] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_82] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_83] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_84] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_85] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_86] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_87] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_algorithm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym_pcal_algorithm_start] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_procedure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fair] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_process] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variables] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_either] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_skip] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [sym_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym_proof_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_by_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_obvious_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_omitted_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_qed_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_text] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym__unit] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__op] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_number] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__primitive_value_set] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_int_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_real_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__except_val] = {
    .visible = false,
    .named = false,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_algorithm] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_p_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmts] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_c_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_label] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_p_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_lhs] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_with] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_with] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_with_vars] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_await] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_print] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_skip] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_return] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_goto] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_macro_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_stmts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_algorithm_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_assign_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_lhs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_with_vars_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_header_line] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_either] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_if] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_while] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_with] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expression = 7,
  field_filter = 8,
  field_generator = 9,
  field_identifier = 10,
  field_if = 11,
  field_label = 12,
  field_lhs = 13,
  field_map = 14,
  field_name = 15,
  field_op = 16,
  field_parameter = 17,
  field_prefix = 18,
  field_quantifier = 19,
  field_rhs = 20,
  field_set = 21,
  field_statement = 22,
  field_symbol = 23,
  field_then = 24,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_identifier] = "identifier",
  [field_if] = "if",
  [field_label] = "label",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_statement] = "statement",
  [field_symbol] = "symbol",
  [field_then] = "then",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 2},
  [11] = {.index = 10, .length = 2},
  [12] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 13, .length = 2},
  [16] = {.index = 15, .length = 2},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 3},
  [20] = {.index = 24, .length = 3},
  [21] = {.index = 27, .length = 2},
  [22] = {.index = 29, .length = 3},
  [23] = {.index = 32, .length = 1},
  [24] = {.index = 33, .length = 4},
  [25] = {.index = 37, .length = 1},
  [26] = {.index = 38, .length = 3},
  [27] = {.index = 41, .length = 2},
  [28] = {.index = 43, .length = 2},
  [29] = {.index = 12, .length = 1},
  [30] = {.index = 45, .length = 3},
  [31] = {.index = 48, .length = 3},
  [32] = {.index = 19, .length = 2},
  [33] = {.index = 51, .length = 2},
  [34] = {.index = 53, .length = 1},
  [35] = {.index = 54, .length = 5},
  [36] = {.index = 59, .length = 1},
  [37] = {.index = 60, .length = 2},
  [38] = {.index = 62, .length = 2},
  [39] = {.index = 64, .length = 2},
  [40] = {.index = 66, .length = 4},
  [41] = {.index = 70, .length = 4},
  [42] = {.index = 74, .length = 1},
  [43] = {.index = 74, .length = 1},
  [44] = {.index = 74, .length = 1},
  [45] = {.index = 75, .length = 3},
  [46] = {.index = 3, .length = 1},
  [47] = {.index = 78, .length = 6},
  [48] = {.index = 84, .length = 2},
  [49] = {.index = 86, .length = 3},
  [50] = {.index = 89, .length = 4},
  [51] = {.index = 93, .length = 3},
  [52] = {.index = 96, .length = 2},
  [53] = {.index = 98, .length = 2},
  [54] = {.index = 100, .length = 1},
  [55] = {.index = 101, .length = 5},
  [56] = {.index = 74, .length = 1},
  [57] = {.index = 106, .length = 2},
  [58] = {.index = 108, .length = 1},
  [59] = {.index = 109, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_label, 1, .inherited = true},
  [2] =
    {field_label, 0, .inherited = true},
  [3] =
    {field_name, 2},
  [4] =
    {field_name, 1},
  [5] =
    {field_label, 0},
    {field_label, 1},
  [7] =
    {field_statement, 1},
  [8] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [10] =
    {field_definition, 2},
    {field_name, 0},
  [12] =
    {field_name, 0},
  [13] =
    {field_op, 1},
    {field_prefix, 0},
  [15] =
    {field_lhs, 0},
    {field_symbol, 1},
  [17] =
    {field_rhs, 1},
    {field_symbol, 0},
  [19] =
    {field_label, 1, .inherited = true},
    {field_label, 2, .inherited = true},
  [21] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [24] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [27] =
    {field_name, 1},
    {field_parameter, 3},
  [29] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [32] =
    {field_set, 2},
  [33] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [37] =
    {field_parameter, 1},
  [38] =
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [41] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [43] =
    {field_definitions, 1},
    {field_expression, 3},
  [45] =
    {field_expression, 3},
    {field_identifier, 1},
    {field_quantifier, 0},
  [48] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [51] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [53] =
    {field_label, 4, .inherited = true},
  [54] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [59] =
    {field_set, 3},
  [60] =
    {field_definition, 5},
    {field_name, 0},
  [62] =
    {field_filter, 3},
    {field_generator, 1},
  [64] =
    {field_generator, 3},
    {field_map, 1},
  [66] =
    {field_expression, 4},
    {field_identifier, 1},
    {field_identifier, 2},
    {field_quantifier, 0},
  [70] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [74] =
    {field_label, 3, .inherited = true},
  [75] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [78] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [84] =
    {field_definition, 6},
    {field_name, 0},
  [86] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [89] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [93] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [96] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
  [98] =
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
  [100] =
    {field_name, 3},
  [101] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [106] =
    {field_label, 3, .inherited = true},
    {field_label, 5, .inherited = true},
  [108] =
    {field_name, 4},
  [109] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_identifier_ref,
  },
  [5] = {
    [0] = alias_sym_header_line,
    [3] = alias_sym_header_line,
  },
  [7] = {
    [1] = alias_sym_identifier_ref,
  },
  [13] = {
    [0] = anon_sym_BSLASHb,
  },
  [14] = {
    [1] = alias_sym_identifier_ref,
  },
  [29] = {
    [0] = alias_sym_identifier_ref,
  },
  [32] = {
    [3] = alias_sym_pcal_end_either,
  },
  [42] = {
    [4] = alias_sym_pcal_end_if,
  },
  [43] = {
    [4] = alias_sym_pcal_end_while,
  },
  [44] = {
    [4] = alias_sym_pcal_end_with,
  },
  [52] = {
    [5] = alias_sym_pcal_end_if,
  },
  [57] = {
    [6] = alias_sym_pcal_end_if,
  },
  [59] = {
    [7] = alias_sym_pcal_end_if,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(237)
      if (lookahead == '\r') SKIP(237)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(248);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(246);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(283);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(316);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(6);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(232)
      if (lookahead == '\r') ADVANCE(328);
      if (lookahead == '"') ADVANCE(330);
      if (lookahead == '(') ADVANCE(329);
      if (lookahead == '\\') ADVANCE(331);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(328);
      if (lookahead != 0) ADVANCE(327);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(232)
      if (lookahead == '\r') ADVANCE(333);
      if (lookahead == '(') ADVANCE(334);
      if (lookahead == '\\') ADVANCE(335);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(333);
      if (lookahead != 0) ADVANCE(332);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(518);
      END_STATE();
    case 6:
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(480);
      END_STATE();
    case 8:
      if (lookahead == ')') ADVANCE(483);
      END_STATE();
    case 9:
      if (lookahead == ')') ADVANCE(496);
      END_STATE();
    case 10:
      if (lookahead == ')') ADVANCE(499);
      END_STATE();
    case 11:
      if (lookahead == ')') ADVANCE(502);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(240);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'i') ADVANCE(119);
      if (lookahead == 'l') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == 'l') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(242);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(39);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(252);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(260);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(20);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(38);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(360);
      END_STATE();
    case 26:
      if (lookahead == '.') ADVANCE(472);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(297);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(296);
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(31);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 31:
      if (lookahead == '=') ADVANCE(385);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 34:
      if (lookahead == '=') ADVANCE(254);
      END_STATE();
    case 35:
      if (lookahead == '=') ADVANCE(32);
      END_STATE();
    case 36:
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 37:
      if (lookahead == '>') ADVANCE(374);
      END_STATE();
    case 38:
      if (lookahead == '>') ADVANCE(271);
      END_STATE();
    case 39:
      if (lookahead == '>') ADVANCE(366);
      END_STATE();
    case 40:
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 41:
      if (lookahead == '?') ADVANCE(520);
      END_STATE();
    case 42:
      if (lookahead == '@') ADVANCE(457);
      END_STATE();
    case 43:
      if (lookahead == 'X') ADVANCE(11);
      END_STATE();
    case 44:
      if (lookahead == ']') ADVANCE(289);
      END_STATE();
    case 45:
      if (lookahead == '_') ADVANCE(348);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(134);
      if (lookahead == 'd') ADVANCE(127);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'o') ADVANCE(120);
      if (lookahead == 'u') ADVANCE(135);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'l') ADVANCE(423);
      if (lookahead == 'n') ADVANCE(129);
      if (lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(116);
      if (lookahead == 'e') ADVANCE(144);
      if (lookahead == 'l') ADVANCE(423);
      if (lookahead == 'o') ADVANCE(154);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(166);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(137);
      if (lookahead == 'u') ADVANCE(138);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'f') ADVANCE(55);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(155);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 56:
      if (lookahead == 'b') ADVANCE(174);
      if (lookahead == 'c') ADVANCE(61);
      if (lookahead == 'p') ADVANCE(175);
      END_STATE();
    case 57:
      if (lookahead == 'b') ADVANCE(176);
      if (lookahead == 'p') ADVANCE(177);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(50);
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 59:
      if (lookahead == 'c') ADVANCE(514);
      END_STATE();
    case 60:
      if (lookahead == 'c') ADVANCE(427);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(429);
      END_STATE();
    case 62:
      if (lookahead == 'c') ADVANCE(508);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(61);
      END_STATE();
    case 64:
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(187);
      END_STATE();
    case 66:
      if (lookahead == 'd') ADVANCE(378);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(143);
      if (lookahead == 'g') ADVANCE(421);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(83);
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(60);
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 82:
      if (lookahead == 'g') ADVANCE(64);
      END_STATE();
    case 83:
      if (lookahead == 'g') ADVANCE(350);
      END_STATE();
    case 84:
      if (lookahead == 'g') ADVANCE(417);
      END_STATE();
    case 85:
      if (lookahead == 'g') ADVANCE(132);
      END_STATE();
    case 86:
      if (lookahead == 'h') ADVANCE(498);
      END_STATE();
    case 87:
      if (lookahead == 'h') ADVANCE(111);
      END_STATE();
    case 88:
      if (lookahead == 'i') ADVANCE(82);
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(197);
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'q') ADVANCE(58);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(110);
      if (lookahead == 'q') ADVANCE(58);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(63);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(173);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 94:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(188);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(264);
      END_STATE();
    case 103:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 110:
      if (lookahead == 'm') ADVANCE(437);
      END_STATE();
    case 111:
      if (lookahead == 'm') ADVANCE(557);
      END_STATE();
    case 112:
      if (lookahead == 'm') ADVANCE(73);
      END_STATE();
    case 113:
      if (lookahead == 'm') ADVANCE(136);
      END_STATE();
    case 114:
      if (lookahead == 'm') ADVANCE(78);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 116:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(425);
      END_STATE();
    case 118:
      if (lookahead == 'n') ADVANCE(470);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(95);
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 124:
      if (lookahead == 'o') ADVANCE(199);
      END_STATE();
    case 125:
      if (lookahead == 'o') ADVANCE(435);
      END_STATE();
    case 126:
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(157);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(180);
      END_STATE();
    case 130:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(118);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 133:
      if (lookahead == 'p') ADVANCE(139);
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 134:
      if (lookahead == 'p') ADVANCE(466);
      END_STATE();
    case 135:
      if (lookahead == 'p') ADVANCE(469);
      END_STATE();
    case 136:
      if (lookahead == 'p') ADVANCE(415);
      END_STATE();
    case 137:
      if (lookahead == 'p') ADVANCE(525);
      END_STATE();
    case 138:
      if (lookahead == 'p') ADVANCE(527);
      END_STATE();
    case 139:
      if (lookahead == 'p') ADVANCE(159);
      END_STATE();
    case 140:
      if (lookahead == 'p') ADVANCE(189);
      END_STATE();
    case 141:
      if (lookahead == 'q') ADVANCE(194);
      END_STATE();
    case 142:
      if (lookahead == 'q') ADVANCE(194);
      if (lookahead == 'x') ADVANCE(92);
      END_STATE();
    case 143:
      if (lookahead == 'q') ADVANCE(402);
      END_STATE();
    case 144:
      if (lookahead == 'q') ADVANCE(399);
      END_STATE();
    case 145:
      if (lookahead == 'q') ADVANCE(419);
      END_STATE();
    case 146:
      if (lookahead == 'q') ADVANCE(439);
      END_STATE();
    case 147:
      if (lookahead == 'q') ADVANCE(431);
      END_STATE();
    case 148:
      if (lookahead == 'q') ADVANCE(433);
      END_STATE();
    case 149:
      if (lookahead == 'q') ADVANCE(453);
      END_STATE();
    case 150:
      if (lookahead == 'q') ADVANCE(455);
      END_STATE();
    case 151:
      if (lookahead == 'q') ADVANCE(445);
      END_STATE();
    case 152:
      if (lookahead == 'q') ADVANCE(447);
      END_STATE();
    case 153:
      if (lookahead == 'r') ADVANCE(534);
      END_STATE();
    case 154:
      if (lookahead == 'r') ADVANCE(381);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(516);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 162:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(479);
      END_STATE();
    case 166:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 167:
      if (lookahead == 's') ADVANCE(532);
      END_STATE();
    case 168:
      if (lookahead == 's') ADVANCE(529);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 171:
      if (lookahead == 's') ADVANCE(501);
      END_STATE();
    case 172:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 173:
      if (lookahead == 's') ADVANCE(190);
      END_STATE();
    case 174:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 175:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 176:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 177:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(536);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(349);
      END_STATE();
    case 181:
      if (lookahead == 't') ADVANCE(495);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(510);
      END_STATE();
    case 183:
      if (lookahead == 't') ADVANCE(449);
      END_STATE();
    case 184:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(441);
      END_STATE();
    case 186:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(467);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 190:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 191:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 192:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 193:
      if (lookahead == 'u') ADVANCE(165);
      END_STATE();
    case 194:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 195:
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 196:
      if (lookahead == 'u') ADVANCE(170);
      END_STATE();
    case 197:
      if (lookahead == 'v') ADVANCE(512);
      END_STATE();
    case 198:
      if (lookahead == 'v') ADVANCE(369);
      END_STATE();
    case 199:
      if (lookahead == 'x') ADVANCE(404);
      END_STATE();
    case 200:
      if (lookahead == 'y') ADVANCE(113);
      END_STATE();
    case 201:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(201)
      if (lookahead == '\r') SKIP(201)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 202:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(202)
      if (lookahead == '\r') SKIP(202)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(346);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 203:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(203)
      if (lookahead == '\r') SKIP(203)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(27);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(461);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 204:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(204)
      if (lookahead == '\r') SKIP(204)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(346);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 205:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(205)
      if (lookahead == '\r') SKIP(205)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 206:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(206)
      if (lookahead == '\r') SKIP(206)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 207:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(207)
      if (lookahead == '\r') SKIP(207)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 208:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(208)
      if (lookahead == '\r') SKIP(208)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 209:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(209)
      if (lookahead == '\r') SKIP(209)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(358);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(45);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 210:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(210)
      if (lookahead == '\r') SKIP(210)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(283);
      END_STATE();
    case 211:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(210)
      if (lookahead == '\r') SKIP(210)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(325);
      END_STATE();
    case 212:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(212)
      if (lookahead == '\r') SKIP(212)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(345);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 213:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(212)
      if (lookahead == '\r') SKIP(212)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(345);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 214:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(214)
      if (lookahead == '\r') SKIP(214)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(13);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 215:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(215)
      if (lookahead == '\r') SKIP(215)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(282);
      END_STATE();
    case 216:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(215)
      if (lookahead == '\r') SKIP(215)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(396);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12297) ADVANCE(282);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(317);
      END_STATE();
    case 217:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(217)
      if (lookahead == '\r') SKIP(217)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 218:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(218)
      if (lookahead == '\r') SKIP(218)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(345);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(465);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 219:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(219)
      if (lookahead == '\r') SKIP(219)
      if (lookahead == '!') ADVANCE(5);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(13);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(30);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(465);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      END_STATE();
    case 220:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(220)
      if (lookahead == '\r') SKIP(220)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(28);
      if (lookahead == '<') ADVANCE(393);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 221:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(221)
      if (lookahead == '\r') SKIP(221)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(488);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 222:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(222)
      if (lookahead == '\r') SKIP(222)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(304);
      if (lookahead == '*') ADVANCE(504);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(358);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(347);
      if (lookahead == '>') ADVANCE(394);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(42);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(463);
      if (lookahead == ']') ADVANCE(45);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '~') ADVANCE(37);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 223:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(224)
      if (lookahead == '\r') SKIP(224)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(40);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 12297) ADVANCE(282);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(321);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 224:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(224)
      if (lookahead == '\r') SKIP(224)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(40);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10217) ADVANCE(284);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 12297) ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 225:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(226)
      if (lookahead == '\r') SKIP(226)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '*') ADVANCE(553);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ':') ADVANCE(294);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(548);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(554);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 226:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(226)
      if (lookahead == '\r') SKIP(226)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ':') ADVANCE(294);
      if (lookahead == '<') ADVANCE(36);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(227)
      if (lookahead == '\r') SKIP(227)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == ':') ADVANCE(29);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(34);
      if (lookahead == '[') ADVANCE(44);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '~') ADVANCE(351);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 10229) ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 228:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(228)
      if (lookahead == '\r') SKIP(228)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == '+') ADVANCE(476);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(341);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(390);
      if (lookahead == '=') ADVANCE(343);
      if (lookahead == '[') ADVANCE(306);
      if (lookahead == '\\') ADVANCE(15);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == 8712) ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 229:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') ADVANCE(245);
      if (lookahead == '\r') ADVANCE(245);
      if (lookahead == '(') ADVANCE(249);
      if (lookahead == ')') ADVANCE(251);
      if (lookahead == '*') ADVANCE(247);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == ';') ADVANCE(243);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(243);
      END_STATE();
    case 230:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(230)
      if (lookahead == '\r') SKIP(230)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(299);
      END_STATE();
    case 231:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(230)
      if (lookahead == '\r') SKIP(230)
      if (lookahead == '!') ADVANCE(309);
      if (lookahead == '(') ADVANCE(303);
      if (lookahead == ')') ADVANCE(305);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 232:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(232)
      if (lookahead == '\r') SKIP(232)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '\\') ADVANCE(14);
      END_STATE();
    case 233:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(232)
      if (lookahead == '\r') SKIP(232)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '\\') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(555);
      END_STATE();
    case 234:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(232)
      if (lookahead == '\r') SKIP(232)
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(545);
      if (lookahead == '\\') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(547);
      END_STATE();
    case 235:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 236:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 237:
      if (eof) ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(237)
      if (lookahead == '\r') SKIP(237)
      if (lookahead == '!') ADVANCE(310);
      if (lookahead == '"') ADVANCE(326);
      if (lookahead == '#') ADVANCE(388);
      if (lookahead == '$') ADVANCE(523);
      if (lookahead == '%') ADVANCE(485);
      if (lookahead == '&') ADVANCE(493);
      if (lookahead == '\'') ADVANCE(544);
      if (lookahead == '(') ADVANCE(248);
      if (lookahead == ')') ADVANCE(250);
      if (lookahead == '*') ADVANCE(246);
      if (lookahead == '+') ADVANCE(477);
      if (lookahead == ',') ADVANCE(302);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(342);
      if (lookahead == '/') ADVANCE(506);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(556);
      if (lookahead == '<') ADVANCE(391);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(395);
      if (lookahead == '?') ADVANCE(41);
      if (lookahead == '@') ADVANCE(295);
      if (lookahead == '[') ADVANCE(307);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == ']') ADVANCE(308);
      if (lookahead == '^') ADVANCE(538);
      if (lookahead == '_') ADVANCE(300);
      if (lookahead == '{') ADVANCE(339);
      if (lookahead == '|') ADVANCE(487);
      if (lookahead == '}') ADVANCE(340);
      if (lookahead == '~') ADVANCE(352);
      if (lookahead == 172) ADVANCE(353);
      if (lookahead == 215) ADVANCE(533);
      if (lookahead == 247) ADVANCE(513);
      if (lookahead == 8214) ADVANCE(490);
      if (lookahead == 8229) ADVANCE(473);
      if (lookahead == 8230) ADVANCE(475);
      if (lookahead == 8252) ADVANCE(519);
      if (lookahead == 8263) ADVANCE(521);
      if (lookahead == 8314) ADVANCE(541);
      if (lookahead == 8469) ADVANCE(336);
      if (lookahead == 8477) ADVANCE(338);
      if (lookahead == 8484) ADVANCE(337);
      if (lookahead == 8592) ADVANCE(262);
      if (lookahead == 8594) ADVANCE(276);
      if (lookahead == 8605) ADVANCE(376);
      if (lookahead == 8614) ADVANCE(273);
      if (lookahead == 8658) ADVANCE(365);
      if (lookahead == 8660) ADVANCE(373);
      if (lookahead == 8669) ADVANCE(375);
      if (lookahead == 8696) ADVANCE(367);
      if (lookahead == 8704) ADVANCE(265);
      if (lookahead == 8707) ADVANCE(268);
      if (lookahead == 8712) ADVANCE(259);
      if (lookahead == 8713) ADVANCE(426);
      if (lookahead == 8728) ADVANCE(515);
      if (lookahead == 8733) ADVANCE(436);
      if (lookahead == 8743) ADVANCE(379);
      if (lookahead == 8744) ADVANCE(382);
      if (lookahead == 8745) ADVANCE(468);
      if (lookahead == 8746) ADVANCE(471);
      if (lookahead == 8759) ADVANCE(298);
      if (lookahead == 8764) ADVANCE(438);
      if (lookahead == 8768) ADVANCE(535);
      if (lookahead == 8771) ADVANCE(440);
      if (lookahead == 8773) ADVANCE(418);
      if (lookahead == 8776) ADVANCE(405);
      if (lookahead == 8781) ADVANCE(416);
      if (lookahead == 8784) ADVANCE(420);
      if (lookahead == 8788) ADVANCE(384);
      if (lookahead == 8796) ADVANCE(256);
      if (lookahead == 8800) ADVANCE(389);
      if (lookahead == 8801) ADVANCE(370);
      if (lookahead == 8804) ADVANCE(400);
      if (lookahead == 8805) ADVANCE(403);
      if (lookahead == 8810) ADVANCE(424);
      if (lookahead == 8811) ADVANCE(422);
      if (lookahead == 8826) ADVANCE(428);
      if (lookahead == 8827) ADVANCE(430);
      if (lookahead == 8834) ADVANCE(450);
      if (lookahead == 8835) ADVANCE(452);
      if (lookahead == 8838) ADVANCE(454);
      if (lookahead == 8839) ADVANCE(456);
      if (lookahead == 8846) ADVANCE(530);
      if (lookahead == 8847) ADVANCE(442);
      if (lookahead == 8848) ADVANCE(444);
      if (lookahead == 8849) ADVANCE(446);
      if (lookahead == 8850) ADVANCE(448);
      if (lookahead == 8851) ADVANCE(526);
      if (lookahead == 8852) ADVANCE(528);
      if (lookahead == 8853) ADVANCE(481);
      if (lookahead == 8854) ADVANCE(484);
      if (lookahead == 8855) ADVANCE(503);
      if (lookahead == 8856) ADVANCE(500);
      if (lookahead == 8857) ADVANCE(497);
      if (lookahead == 8866) ADVANCE(408);
      if (lookahead == 8867) ADVANCE(412);
      if (lookahead == 8872) ADVANCE(410);
      if (lookahead == 8900) ADVANCE(362);
      if (lookahead == 8901) ADVANCE(537);
      if (lookahead == 8902) ADVANCE(517);
      if (lookahead == 9633) ADVANCE(290);
      if (lookahead == 9679) ADVANCE(511);
      if (lookahead == 9711) ADVANCE(509);
      if (lookahead == 10216) ADVANCE(279);
      if (lookahead == 10217) ADVANCE(285);
      if (lookahead == 10229) ADVANCE(261);
      if (lookahead == 10230) ADVANCE(275);
      if (lookahead == 10233) ADVANCE(364);
      if (lookahead == 10234) ADVANCE(372);
      if (lookahead == 10236) ADVANCE(272);
      if (lookahead == 10565) ADVANCE(368);
      if (lookahead == 10868) ADVANCE(386);
      if (lookahead == 10927) ADVANCE(432);
      if (lookahead == 10928) ADVANCE(434);
      if (lookahead == 10980) ADVANCE(414);
      if (lookahead == 12296) ADVANCE(278);
      if (lookahead == 12297) ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(239);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_STAR_RPAREN);
      if (lookahead == '\n') ADVANCE(6);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(242);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(242);
      if (lookahead == '-') ADVANCE(52);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') ADVANCE(245);
      if (lookahead == '\r') ADVANCE(245);
      if (lookahead == '(') ADVANCE(249);
      if (lookahead == ')') ADVANCE(243);
      if (lookahead == '*') ADVANCE(247);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == ';') ADVANCE(243);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead != 0) ADVANCE(243);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      if (lookahead == ')') ADVANCE(241);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead != 0 &&
          lookahead != '(' &&
          lookahead != '*') ADVANCE(242);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      if (lookahead == ')') ADVANCE(242);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_single_line);
      if (lookahead == '-') ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_double_line);
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(269);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(270);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_BSLASHAA);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_BSLASHEE);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_8);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_9);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_10);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_11);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_12);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(286);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_13);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_13);
      if (lookahead == '_') ADVANCE(287);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_14);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_14);
      if (lookahead == '_') ADVANCE(288);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym__2);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_15);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(297);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(31);
      if (lookahead == '=') ADVANCE(383);
      if (lookahead == '>') ADVANCE(458);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(383);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(457);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(385);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_16);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(236);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(301);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(240);
      if (lookahead == '+') ADVANCE(7);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == '.') ADVANCE(9);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\\') ADVANCE(43);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(289);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '!') ADVANCE(518);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(235);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(311);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(312);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      if (lookahead == 'i') ADVANCE(82);
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_BSLASHB);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(316);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(317);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(130);
      if (lookahead == 'm') ADVANCE(96);
      if (lookahead == 'p') ADVANCE(103);
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_BSLASHO);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '_') ADVANCE(236);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(320);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '8' ||
          lookahead == '9' ||
          lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(321);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_BSLASHh);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_BSLASHH);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(aux_sym_hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(325);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '(') ADVANCE(12);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '(') ADVANCE(12);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(240);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(239);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_17);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_18);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_19);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(472);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(255);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(32);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '>') ADVANCE(363);
      if (lookahead == '|') ADVANCE(413);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(374);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_20);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(492);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '>') ADVANCE(274);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(492);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '.') ADVANCE(360);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '>') ADVANCE(274);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(19);
      if (lookahead == '-') ADVANCE(491);
      if (lookahead == '|') ADVANCE(411);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_21);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_22);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_23);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_24);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_25);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_26);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_27);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_28);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_29);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_30);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_31);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_32);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_33);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_34);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(522);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_35);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '<') ADVANCE(277);
      if (lookahead == '=') ADVANCE(397);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '=') ADVANCE(397);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(459);
      if (lookahead == '=') ADVANCE(397);
      if (lookahead == '>') ADVANCE(361);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      if (lookahead == '>') ADVANCE(281);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(401);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(371);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_36);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_37);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_38);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(271);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_39);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_40);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_41);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_42);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_43);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_44);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_45);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_46);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_47);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_48);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_49);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_50);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_51);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_52);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_53);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(146);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_54);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_55);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_56);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_57);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_58);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_59);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_60);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_61);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_62);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_63);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'A') ADVANCE(263);
      if (lookahead == 'B') ADVANCE(315);
      if (lookahead == 'E') ADVANCE(266);
      if (lookahead == 'H') ADVANCE(324);
      if (lookahead == 'O') ADVANCE(319);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(314);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(142);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'A') ADVANCE(263);
      if (lookahead == 'B') ADVANCE(315);
      if (lookahead == 'E') ADVANCE(266);
      if (lookahead == 'H') ADVANCE(324);
      if (lookahead == 'O') ADVANCE(319);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(314);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(142);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(323);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'X') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(156);
      if (lookahead == 's') ADVANCE(90);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(47);
      if (lookahead == 'n') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(239);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == 'a') ADVANCE(133);
      if (lookahead == 'b') ADVANCE(88);
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'g') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(115);
      if (lookahead == 'l') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(91);
      if (lookahead == 'u') ADVANCE(121);
      if (lookahead == 'w') ADVANCE(153);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_64);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_65);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(474);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_66);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_67);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(478);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_68);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_69);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(486);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(407);
      if (lookahead == '=') ADVANCE(409);
      if (lookahead == '|') ADVANCE(489);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(406);
      if (lookahead == '=') ADVANCE(409);
      if (lookahead == '|') ADVANCE(489);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_70);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(20);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(494);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_71);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_72);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_73);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(505);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(507);
      if (lookahead == '=') ADVANCE(387);
      if (lookahead == '\\') ADVANCE(377);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_74);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_75);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_76);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_77);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_78);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_79);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_80);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(524);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_81);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_82);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_83);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_84);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_85);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_86);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(543);
      if (lookahead == '*') ADVANCE(542);
      if (lookahead == '+') ADVANCE(540);
      if (lookahead == '^') ADVANCE(539);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_87);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(546);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(547);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (lookahead == '(') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(550);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(550);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '(') ADVANCE(12);
      if (lookahead == '.') ADVANCE(552);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(552);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(554);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(301);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(555);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_pcal_algorithm_start);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'C') ADVANCE(3);
      if (lookahead == 'D') ADVANCE(4);
      if (lookahead == 'E') ADVANCE(5);
      if (lookahead == 'F') ADVANCE(6);
      if (lookahead == 'H') ADVANCE(7);
      if (lookahead == 'I') ADVANCE(8);
      if (lookahead == 'L') ADVANCE(9);
      if (lookahead == 'M') ADVANCE(10);
      if (lookahead == 'N') ADVANCE(11);
      if (lookahead == 'O') ADVANCE(12);
      if (lookahead == 'P') ADVANCE(13);
      if (lookahead == 'Q') ADVANCE(14);
      if (lookahead == 'R') ADVANCE(15);
      if (lookahead == 'S') ADVANCE(16);
      if (lookahead == 'T') ADVANCE(17);
      if (lookahead == 'U') ADVANCE(18);
      if (lookahead == 'V') ADVANCE(19);
      if (lookahead == 'W') ADVANCE(20);
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'd') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'g') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'p') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 's') ADVANCE(33);
      if (lookahead == 't') ADVANCE(34);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(36);
      END_STATE();
    case 1:
      if (lookahead == 'C') ADVANCE(37);
      if (lookahead == 'S') ADVANCE(38);
      if (lookahead == 'X') ADVANCE(39);
      END_STATE();
    case 2:
      if (lookahead == 'O') ADVANCE(40);
      if (lookahead == 'Y') ADVANCE(41);
      END_STATE();
    case 3:
      if (lookahead == 'A') ADVANCE(42);
      if (lookahead == 'H') ADVANCE(43);
      if (lookahead == 'O') ADVANCE(44);
      END_STATE();
    case 4:
      if (lookahead == 'E') ADVANCE(45);
      if (lookahead == 'O') ADVANCE(46);
      END_STATE();
    case 5:
      if (lookahead == 'L') ADVANCE(47);
      if (lookahead == 'N') ADVANCE(48);
      if (lookahead == 'X') ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == 'A') ADVANCE(50);
      END_STATE();
    case 7:
      if (lookahead == 'A') ADVANCE(51);
      if (lookahead == 'I') ADVANCE(52);
      END_STATE();
    case 8:
      if (lookahead == 'F') ADVANCE(53);
      if (lookahead == 'N') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 9:
      if (lookahead == 'A') ADVANCE(56);
      if (lookahead == 'E') ADVANCE(57);
      if (lookahead == 'O') ADVANCE(58);
      END_STATE();
    case 10:
      if (lookahead == 'O') ADVANCE(59);
      END_STATE();
    case 11:
      if (lookahead == 'E') ADVANCE(60);
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 12:
      if (lookahead == 'B') ADVANCE(62);
      if (lookahead == 'M') ADVANCE(63);
      if (lookahead == 'N') ADVANCE(64);
      if (lookahead == 'T') ADVANCE(65);
      END_STATE();
    case 13:
      if (lookahead == 'I') ADVANCE(66);
      if (lookahead == 'R') ADVANCE(67);
      END_STATE();
    case 14:
      if (lookahead == 'E') ADVANCE(68);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(69);
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 16:
      if (lookahead == 'F') ADVANCE(71);
      if (lookahead == 'T') ADVANCE(72);
      if (lookahead == 'U') ADVANCE(73);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(74);
      if (lookahead == 'E') ADVANCE(75);
      if (lookahead == 'H') ADVANCE(76);
      if (lookahead == 'R') ADVANCE(77);
      END_STATE();
    case 18:
      if (lookahead == 'N') ADVANCE(78);
      if (lookahead == 'S') ADVANCE(79);
      END_STATE();
    case 19:
      if (lookahead == 'A') ADVANCE(80);
      END_STATE();
    case 20:
      if (lookahead == 'F') ADVANCE(81);
      if (lookahead == 'I') ADVANCE(82);
      END_STATE();
    case 21:
      if (lookahead == 'l') ADVANCE(83);
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 'w') ADVANCE(85);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(95);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 33:
      if (lookahead == 'k') ADVANCE(100);
      END_STATE();
    case 34:
      if (lookahead == 'h') ADVANCE(101);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 36:
      if (lookahead == 'h') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 37:
      if (lookahead == 'T') ADVANCE(105);
      END_STATE();
    case 38:
      if (lookahead == 'S') ADVANCE(106);
      END_STATE();
    case 39:
      if (lookahead == 'I') ADVANCE(107);
      END_STATE();
    case 40:
      if (lookahead == 'O') ADVANCE(108);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 42:
      if (lookahead == 'S') ADVANCE(109);
      END_STATE();
    case 43:
      if (lookahead == 'O') ADVANCE(110);
      END_STATE();
    case 44:
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == 'R') ADVANCE(112);
      END_STATE();
    case 45:
      if (lookahead == 'F') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'M') ADVANCE(114);
      END_STATE();
    case 47:
      if (lookahead == 'S') ADVANCE(115);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(116);
      END_STATE();
    case 49:
      if (lookahead == 'C') ADVANCE(117);
      if (lookahead == 'T') ADVANCE(118);
      END_STATE();
    case 50:
      if (lookahead == 'L') ADVANCE(119);
      END_STATE();
    case 51:
      if (lookahead == 'V') ADVANCE(120);
      END_STATE();
    case 52:
      if (lookahead == 'D') ADVANCE(121);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_IN);
      if (lookahead == 'S') ADVANCE(122);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 56:
      if (lookahead == 'M') ADVANCE(124);
      END_STATE();
    case 57:
      if (lookahead == 'M') ADVANCE(125);
      if (lookahead == 'T') ADVANCE(126);
      END_STATE();
    case 58:
      if (lookahead == 'C') ADVANCE(127);
      END_STATE();
    case 59:
      if (lookahead == 'D') ADVANCE(128);
      END_STATE();
    case 60:
      if (lookahead == 'W') ADVANCE(129);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 62:
      if (lookahead == 'V') ADVANCE(131);
      END_STATE();
    case 63:
      if (lookahead == 'I') ADVANCE(132);
      END_STATE();
    case 64:
      if (lookahead == 'L') ADVANCE(133);
      END_STATE();
    case 65:
      if (lookahead == 'H') ADVANCE(134);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(135);
      END_STATE();
    case 67:
      if (lookahead == 'O') ADVANCE(136);
      END_STATE();
    case 68:
      if (lookahead == 'D') ADVANCE(137);
      END_STATE();
    case 69:
      if (lookahead == 'C') ADVANCE(138);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'A') ADVANCE(141);
      if (lookahead == 'R') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'B') ADVANCE(143);
      if (lookahead == 'F') ADVANCE(144);
      END_STATE();
    case 74:
      if (lookahead == 'K') ADVANCE(145);
      END_STATE();
    case 75:
      if (lookahead == 'M') ADVANCE(146);
      END_STATE();
    case 76:
      if (lookahead == 'E') ADVANCE(147);
      END_STATE();
    case 77:
      if (lookahead == 'U') ADVANCE(148);
      END_STATE();
    case 78:
      if (lookahead == 'C') ADVANCE(149);
      if (lookahead == 'I') ADVANCE(150);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(151);
      END_STATE();
    case 80:
      if (lookahead == 'R') ADVANCE(152);
      END_STATE();
    case 81:
      if (lookahead == '_') ADVANCE(153);
      END_STATE();
    case 82:
      if (lookahead == 'T') ADVANCE(154);
      END_STATE();
    case 83:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(156);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(157);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(158);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(160);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 105:
      if (lookahead == 'I') ADVANCE(176);
      END_STATE();
    case 106:
      if (lookahead == 'U') ADVANCE(177);
      END_STATE();
    case 107:
      if (lookahead == 'O') ADVANCE(178);
      END_STATE();
    case 108:
      if (lookahead == 'L') ADVANCE(179);
      END_STATE();
    case 109:
      if (lookahead == 'E') ADVANCE(180);
      END_STATE();
    case 110:
      if (lookahead == 'O') ADVANCE(181);
      END_STATE();
    case 111:
      if (lookahead == 'S') ADVANCE(182);
      END_STATE();
    case 112:
      if (lookahead == 'O') ADVANCE(183);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'I') ADVANCE(184);
      if (lookahead == 'S') ADVANCE(185);
      END_STATE();
    case 114:
      if (lookahead == 'A') ADVANCE(186);
      END_STATE();
    case 115:
      if (lookahead == 'E') ADVANCE(187);
      END_STATE();
    case 116:
      if (lookahead == 'B') ADVANCE(188);
      END_STATE();
    case 117:
      if (lookahead == 'E') ADVANCE(189);
      END_STATE();
    case 118:
      if (lookahead == 'E') ADVANCE(190);
      END_STATE();
    case 119:
      if (lookahead == 'S') ADVANCE(191);
      END_STATE();
    case 120:
      if (lookahead == 'E') ADVANCE(192);
      END_STATE();
    case 121:
      if (lookahead == 'E') ADVANCE(193);
      END_STATE();
    case 122:
      if (lookahead == 'T') ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 124:
      if (lookahead == 'B') ADVANCE(195);
      END_STATE();
    case 125:
      if (lookahead == 'M') ADVANCE(196);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 127:
      if (lookahead == 'A') ADVANCE(197);
      END_STATE();
    case 128:
      if (lookahead == 'U') ADVANCE(198);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 131:
      if (lookahead == 'I') ADVANCE(199);
      END_STATE();
    case 132:
      if (lookahead == 'T') ADVANCE(200);
      END_STATE();
    case 133:
      if (lookahead == 'Y') ADVANCE(201);
      END_STATE();
    case 134:
      if (lookahead == 'E') ADVANCE(202);
      END_STATE();
    case 135:
      if (lookahead == 'K') ADVANCE(203);
      END_STATE();
    case 136:
      if (lookahead == 'O') ADVANCE(204);
      if (lookahead == 'P') ADVANCE(205);
      if (lookahead == 'V') ADVANCE(206);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 138:
      if (lookahead == 'U') ADVANCE(207);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(208);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 141:
      if (lookahead == 'T') ADVANCE(209);
      END_STATE();
    case 142:
      if (lookahead == 'I') ADVANCE(210);
      END_STATE();
    case 143:
      if (lookahead == 'S') ADVANCE(211);
      END_STATE();
    case 144:
      if (lookahead == 'F') ADVANCE(212);
      END_STATE();
    case 145:
      if (lookahead == 'E') ADVANCE(213);
      END_STATE();
    case 146:
      if (lookahead == 'P') ADVANCE(214);
      END_STATE();
    case 147:
      if (lookahead == 'N') ADVANCE(215);
      if (lookahead == 'O') ADVANCE(216);
      END_STATE();
    case 148:
      if (lookahead == 'E') ADVANCE(217);
      END_STATE();
    case 149:
      if (lookahead == 'H') ADVANCE(218);
      END_STATE();
    case 150:
      if (lookahead == 'O') ADVANCE(219);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 152:
      if (lookahead == 'I') ADVANCE(220);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 154:
      if (lookahead == 'H') ADVANCE(221);
      if (lookahead == 'N') ADVANCE(222);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(227);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 161:
      if (lookahead == 'h') ADVANCE(229);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == 'i') ADVANCE(231);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 169:
      if (lookahead == 'u') ADVANCE(237);
      END_STATE();
    case 170:
      if (lookahead == 'p') ADVANCE(238);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 172:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 173:
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 174:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 175:
      if (lookahead == 'h') ADVANCE(243);
      END_STATE();
    case 176:
      if (lookahead == 'O') ADVANCE(244);
      END_STATE();
    case 177:
      if (lookahead == 'M') ADVANCE(245);
      END_STATE();
    case 178:
      if (lookahead == 'M') ADVANCE(246);
      END_STATE();
    case 179:
      if (lookahead == 'E') ADVANCE(247);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 181:
      if (lookahead == 'S') ADVANCE(248);
      END_STATE();
    case 182:
      if (lookahead == 'T') ADVANCE(249);
      END_STATE();
    case 183:
      if (lookahead == 'L') ADVANCE(250);
      END_STATE();
    case 184:
      if (lookahead == 'N') ADVANCE(251);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 186:
      if (lookahead == 'I') ADVANCE(252);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 188:
      if (lookahead == 'L') ADVANCE(253);
      END_STATE();
    case 189:
      if (lookahead == 'P') ADVANCE(254);
      END_STATE();
    case 190:
      if (lookahead == 'N') ADVANCE(255);
      END_STATE();
    case 191:
      if (lookahead == 'E') ADVANCE(256);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 194:
      if (lookahead == 'A') ADVANCE(257);
      END_STATE();
    case 195:
      if (lookahead == 'D') ADVANCE(258);
      END_STATE();
    case 196:
      if (lookahead == 'A') ADVANCE(259);
      END_STATE();
    case 197:
      if (lookahead == 'L') ADVANCE(260);
      END_STATE();
    case 198:
      if (lookahead == 'L') ADVANCE(261);
      END_STATE();
    case 199:
      if (lookahead == 'O') ADVANCE(262);
      END_STATE();
    case 200:
      if (lookahead == 'T') ADVANCE(263);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 202:
      if (lookahead == 'R') ADVANCE(264);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 204:
      if (lookahead == 'F') ADVANCE(265);
      END_STATE();
    case 205:
      if (lookahead == 'O') ADVANCE(266);
      END_STATE();
    case 206:
      if (lookahead == 'E') ADVANCE(267);
      END_STATE();
    case 207:
      if (lookahead == 'R') ADVANCE(268);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 209:
      if (lookahead == 'E') ADVANCE(269);
      END_STATE();
    case 210:
      if (lookahead == 'N') ADVANCE(270);
      END_STATE();
    case 211:
      if (lookahead == 'E') ADVANCE(271);
      END_STATE();
    case 212:
      if (lookahead == 'I') ADVANCE(272);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 214:
      if (lookahead == 'O') ADVANCE(273);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 216:
      if (lookahead == 'R') ADVANCE(274);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 218:
      if (lookahead == 'A') ADVANCE(275);
      END_STATE();
    case 219:
      if (lookahead == 'N') ADVANCE(276);
      END_STATE();
    case 220:
      if (lookahead == 'A') ADVANCE(277);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 222:
      if (lookahead == 'E') ADVANCE(278);
      END_STATE();
    case 223:
      if (lookahead == 'r') ADVANCE(279);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(280);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_call);
      END_STATE();
    case 228:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 231:
      if (lookahead == 'f') ADVANCE(285);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_fair);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 234:
      if (lookahead == 'o') ADVANCE(286);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_skip);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(290);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 244:
      if (lookahead == 'N') ADVANCE(292);
      END_STATE();
    case 245:
      if (lookahead == 'E') ADVANCE(293);
      if (lookahead == 'P') ADVANCE(294);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 247:
      if (lookahead == 'A') ADVANCE(295);
      END_STATE();
    case 248:
      if (lookahead == 'E') ADVANCE(296);
      END_STATE();
    case 249:
      if (lookahead == 'A') ADVANCE(297);
      END_STATE();
    case 250:
      if (lookahead == 'L') ADVANCE(298);
      END_STATE();
    case 251:
      if (lookahead == 'E') ADVANCE(299);
      END_STATE();
    case 252:
      if (lookahead == 'N') ADVANCE(300);
      END_STATE();
    case 253:
      if (lookahead == 'E') ADVANCE(301);
      END_STATE();
    case 254:
      if (lookahead == 'T') ADVANCE(302);
      END_STATE();
    case 255:
      if (lookahead == 'D') ADVANCE(303);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 257:
      if (lookahead == 'N') ADVANCE(304);
      END_STATE();
    case 258:
      if (lookahead == 'A') ADVANCE(305);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 261:
      if (lookahead == 'E') ADVANCE(306);
      END_STATE();
    case 262:
      if (lookahead == 'U') ADVANCE(307);
      END_STATE();
    case 263:
      if (lookahead == 'E') ADVANCE(308);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 266:
      if (lookahead == 'S') ADVANCE(309);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 268:
      if (lookahead == 'S') ADVANCE(310);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 270:
      if (lookahead == 'G') ADVANCE(311);
      END_STATE();
    case 271:
      if (lookahead == 'T') ADVANCE(312);
      END_STATE();
    case 272:
      if (lookahead == 'C') ADVANCE(313);
      END_STATE();
    case 273:
      if (lookahead == 'R') ADVANCE(314);
      END_STATE();
    case 274:
      if (lookahead == 'E') ADVANCE(315);
      END_STATE();
    case 275:
      if (lookahead == 'N') ADVANCE(316);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 277:
      if (lookahead == 'B') ADVANCE(317);
      END_STATE();
    case 278:
      if (lookahead == 'S') ADVANCE(318);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 284:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(323);
      if (lookahead == 's') ADVANCE(324);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 290:
      if (lookahead == 'b') ADVANCE(326);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 294:
      if (lookahead == 'T') ADVANCE(327);
      END_STATE();
    case 295:
      if (lookahead == 'N') ADVANCE(328);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 297:
      if (lookahead == 'N') ADVANCE(329);
      END_STATE();
    case 298:
      if (lookahead == 'A') ADVANCE(330);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      END_STATE();
    case 301:
      if (lookahead == 'D') ADVANCE(331);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 303:
      if (lookahead == 'S') ADVANCE(332);
      END_STATE();
    case 304:
      if (lookahead == 'C') ADVANCE(333);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 307:
      if (lookahead == 'S') ADVANCE(334);
      END_STATE();
    case 308:
      if (lookahead == 'D') ADVANCE(335);
      END_STATE();
    case 309:
      if (lookahead == 'I') ADVANCE(336);
      END_STATE();
    case 310:
      if (lookahead == 'I') ADVANCE(337);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_string_set);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      END_STATE();
    case 313:
      if (lookahead == 'E') ADVANCE(338);
      END_STATE();
    case 314:
      if (lookahead == 'A') ADVANCE(339);
      END_STATE();
    case 315:
      if (lookahead == 'M') ADVANCE(340);
      END_STATE();
    case 316:
      if (lookahead == 'G') ADVANCE(341);
      END_STATE();
    case 317:
      if (lookahead == 'L') ADVANCE(342);
      END_STATE();
    case 318:
      if (lookahead == 'S') ADVANCE(343);
      END_STATE();
    case 319:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_define);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_either);
      END_STATE();
    case 323:
      if (lookahead == 'u') ADVANCE(345);
      END_STATE();
    case 324:
      if (lookahead == 's') ADVANCE(346);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 326:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 327:
      if (lookahead == 'I') ADVANCE(348);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_boolean_set);
      END_STATE();
    case 329:
      if (lookahead == 'T') ADVANCE(349);
      END_STATE();
    case 330:
      if (lookahead == 'R') ADVANCE(350);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 333:
      if (lookahead == 'E') ADVANCE(351);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 336:
      if (lookahead == 'T') ADVANCE(352);
      END_STATE();
    case 337:
      if (lookahead == 'V') ADVANCE(353);
      END_STATE();
    case 338:
      if (lookahead == 'S') ADVANCE(354);
      END_STATE();
    case 339:
      if (lookahead == 'L') ADVANCE(355);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 341:
      if (lookahead == 'E') ADVANCE(356);
      END_STATE();
    case 342:
      if (lookahead == 'E') ADVANCE(357);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 344:
      if (lookahead == 'h') ADVANCE(358);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(359);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_process);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(360);
      END_STATE();
    case 348:
      if (lookahead == 'O') ADVANCE(361);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(362);
      END_STATE();
    case 350:
      if (lookahead == 'Y') ADVANCE(363);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      END_STATE();
    case 352:
      if (lookahead == 'I') ADVANCE(364);
      END_STATE();
    case 353:
      if (lookahead == 'E') ADVANCE(365);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 356:
      if (lookahead == 'D') ADVANCE(366);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(367);
      END_STATE();
    case 358:
      if (lookahead == 'm') ADVANCE(368);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(369);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_variable);
      if (lookahead == 's') ADVANCE(370);
      END_STATE();
    case 361:
      if (lookahead == 'N') ADVANCE(371);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 364:
      if (lookahead == 'O') ADVANCE(372);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_algorithm);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_procedure);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_variables);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 372:
      if (lookahead == 'N') ADVANCE(373);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 201, .external_lex_state = 3},
  [3] = {.lex_state = 201, .external_lex_state = 3},
  [4] = {.lex_state = 201, .external_lex_state = 4},
  [5] = {.lex_state = 202, .external_lex_state = 4},
  [6] = {.lex_state = 202, .external_lex_state = 4},
  [7] = {.lex_state = 202, .external_lex_state = 4},
  [8] = {.lex_state = 202, .external_lex_state = 4},
  [9] = {.lex_state = 201, .external_lex_state = 4},
  [10] = {.lex_state = 201, .external_lex_state = 4},
  [11] = {.lex_state = 201, .external_lex_state = 4},
  [12] = {.lex_state = 201, .external_lex_state = 4},
  [13] = {.lex_state = 201, .external_lex_state = 4},
  [14] = {.lex_state = 201, .external_lex_state = 4},
  [15] = {.lex_state = 201, .external_lex_state = 4},
  [16] = {.lex_state = 201, .external_lex_state = 4},
  [17] = {.lex_state = 201, .external_lex_state = 4},
  [18] = {.lex_state = 201, .external_lex_state = 4},
  [19] = {.lex_state = 201, .external_lex_state = 4},
  [20] = {.lex_state = 201, .external_lex_state = 4},
  [21] = {.lex_state = 201, .external_lex_state = 4},
  [22] = {.lex_state = 201, .external_lex_state = 4},
  [23] = {.lex_state = 201, .external_lex_state = 4},
  [24] = {.lex_state = 201, .external_lex_state = 4},
  [25] = {.lex_state = 201, .external_lex_state = 4},
  [26] = {.lex_state = 201, .external_lex_state = 4},
  [27] = {.lex_state = 201, .external_lex_state = 4},
  [28] = {.lex_state = 201, .external_lex_state = 4},
  [29] = {.lex_state = 201, .external_lex_state = 4},
  [30] = {.lex_state = 201, .external_lex_state = 4},
  [31] = {.lex_state = 201, .external_lex_state = 4},
  [32] = {.lex_state = 201, .external_lex_state = 4},
  [33] = {.lex_state = 201, .external_lex_state = 4},
  [34] = {.lex_state = 201, .external_lex_state = 4},
  [35] = {.lex_state = 201, .external_lex_state = 4},
  [36] = {.lex_state = 201, .external_lex_state = 4},
  [37] = {.lex_state = 201, .external_lex_state = 4},
  [38] = {.lex_state = 203, .external_lex_state = 4},
  [39] = {.lex_state = 201, .external_lex_state = 4},
  [40] = {.lex_state = 203, .external_lex_state = 4},
  [41] = {.lex_state = 203, .external_lex_state = 4},
  [42] = {.lex_state = 203, .external_lex_state = 4},
  [43] = {.lex_state = 201, .external_lex_state = 4},
  [44] = {.lex_state = 201, .external_lex_state = 4},
  [45] = {.lex_state = 203, .external_lex_state = 4},
  [46] = {.lex_state = 203, .external_lex_state = 4},
  [47] = {.lex_state = 203, .external_lex_state = 4},
  [48] = {.lex_state = 201, .external_lex_state = 4},
  [49] = {.lex_state = 203, .external_lex_state = 4},
  [50] = {.lex_state = 201, .external_lex_state = 4},
  [51] = {.lex_state = 201, .external_lex_state = 4},
  [52] = {.lex_state = 203, .external_lex_state = 4},
  [53] = {.lex_state = 203, .external_lex_state = 4},
  [54] = {.lex_state = 203, .external_lex_state = 4},
  [55] = {.lex_state = 201, .external_lex_state = 4},
  [56] = {.lex_state = 203, .external_lex_state = 4},
  [57] = {.lex_state = 203, .external_lex_state = 4},
  [58] = {.lex_state = 203, .external_lex_state = 4},
  [59] = {.lex_state = 203, .external_lex_state = 4},
  [60] = {.lex_state = 201, .external_lex_state = 4},
  [61] = {.lex_state = 201, .external_lex_state = 4},
  [62] = {.lex_state = 201, .external_lex_state = 4},
  [63] = {.lex_state = 201, .external_lex_state = 4},
  [64] = {.lex_state = 203, .external_lex_state = 4},
  [65] = {.lex_state = 201, .external_lex_state = 4},
  [66] = {.lex_state = 201, .external_lex_state = 4},
  [67] = {.lex_state = 201, .external_lex_state = 4},
  [68] = {.lex_state = 201, .external_lex_state = 4},
  [69] = {.lex_state = 201, .external_lex_state = 4},
  [70] = {.lex_state = 201, .external_lex_state = 4},
  [71] = {.lex_state = 201, .external_lex_state = 4},
  [72] = {.lex_state = 201, .external_lex_state = 4},
  [73] = {.lex_state = 201, .external_lex_state = 4},
  [74] = {.lex_state = 201, .external_lex_state = 4},
  [75] = {.lex_state = 201, .external_lex_state = 4},
  [76] = {.lex_state = 201, .external_lex_state = 4},
  [77] = {.lex_state = 201, .external_lex_state = 4},
  [78] = {.lex_state = 201, .external_lex_state = 4},
  [79] = {.lex_state = 203, .external_lex_state = 4},
  [80] = {.lex_state = 201, .external_lex_state = 4},
  [81] = {.lex_state = 201, .external_lex_state = 4},
  [82] = {.lex_state = 201, .external_lex_state = 4},
  [83] = {.lex_state = 201, .external_lex_state = 4},
  [84] = {.lex_state = 201, .external_lex_state = 4},
  [85] = {.lex_state = 201, .external_lex_state = 4},
  [86] = {.lex_state = 201, .external_lex_state = 4},
  [87] = {.lex_state = 201, .external_lex_state = 4},
  [88] = {.lex_state = 201, .external_lex_state = 4},
  [89] = {.lex_state = 201, .external_lex_state = 4},
  [90] = {.lex_state = 201, .external_lex_state = 4},
  [91] = {.lex_state = 201, .external_lex_state = 4},
  [92] = {.lex_state = 203, .external_lex_state = 4},
  [93] = {.lex_state = 201, .external_lex_state = 4},
  [94] = {.lex_state = 201, .external_lex_state = 4},
  [95] = {.lex_state = 201, .external_lex_state = 4},
  [96] = {.lex_state = 201, .external_lex_state = 4},
  [97] = {.lex_state = 201, .external_lex_state = 4},
  [98] = {.lex_state = 201, .external_lex_state = 4},
  [99] = {.lex_state = 201, .external_lex_state = 4},
  [100] = {.lex_state = 201, .external_lex_state = 4},
  [101] = {.lex_state = 201, .external_lex_state = 4},
  [102] = {.lex_state = 201, .external_lex_state = 4},
  [103] = {.lex_state = 201, .external_lex_state = 4},
  [104] = {.lex_state = 201, .external_lex_state = 4},
  [105] = {.lex_state = 201, .external_lex_state = 4},
  [106] = {.lex_state = 201, .external_lex_state = 4},
  [107] = {.lex_state = 201, .external_lex_state = 4},
  [108] = {.lex_state = 201, .external_lex_state = 4},
  [109] = {.lex_state = 201, .external_lex_state = 4},
  [110] = {.lex_state = 201, .external_lex_state = 4},
  [111] = {.lex_state = 201, .external_lex_state = 4},
  [112] = {.lex_state = 201, .external_lex_state = 4},
  [113] = {.lex_state = 201, .external_lex_state = 4},
  [114] = {.lex_state = 201, .external_lex_state = 4},
  [115] = {.lex_state = 201, .external_lex_state = 4},
  [116] = {.lex_state = 201, .external_lex_state = 4},
  [117] = {.lex_state = 201, .external_lex_state = 4},
  [118] = {.lex_state = 201, .external_lex_state = 4},
  [119] = {.lex_state = 201, .external_lex_state = 4},
  [120] = {.lex_state = 201, .external_lex_state = 4},
  [121] = {.lex_state = 201, .external_lex_state = 4},
  [122] = {.lex_state = 201, .external_lex_state = 4},
  [123] = {.lex_state = 201, .external_lex_state = 4},
  [124] = {.lex_state = 201, .external_lex_state = 4},
  [125] = {.lex_state = 201, .external_lex_state = 4},
  [126] = {.lex_state = 201, .external_lex_state = 4},
  [127] = {.lex_state = 201, .external_lex_state = 4},
  [128] = {.lex_state = 201, .external_lex_state = 4},
  [129] = {.lex_state = 201, .external_lex_state = 4},
  [130] = {.lex_state = 201, .external_lex_state = 4},
  [131] = {.lex_state = 201, .external_lex_state = 4},
  [132] = {.lex_state = 201, .external_lex_state = 4},
  [133] = {.lex_state = 201, .external_lex_state = 4},
  [134] = {.lex_state = 201, .external_lex_state = 4},
  [135] = {.lex_state = 201, .external_lex_state = 4},
  [136] = {.lex_state = 201, .external_lex_state = 4},
  [137] = {.lex_state = 201, .external_lex_state = 4},
  [138] = {.lex_state = 201, .external_lex_state = 4},
  [139] = {.lex_state = 201, .external_lex_state = 4},
  [140] = {.lex_state = 201, .external_lex_state = 4},
  [141] = {.lex_state = 201, .external_lex_state = 4},
  [142] = {.lex_state = 201, .external_lex_state = 4},
  [143] = {.lex_state = 201, .external_lex_state = 4},
  [144] = {.lex_state = 201, .external_lex_state = 5},
  [145] = {.lex_state = 201, .external_lex_state = 5},
  [146] = {.lex_state = 201, .external_lex_state = 5},
  [147] = {.lex_state = 201, .external_lex_state = 5},
  [148] = {.lex_state = 201, .external_lex_state = 4},
  [149] = {.lex_state = 201, .external_lex_state = 4},
  [150] = {.lex_state = 201, .external_lex_state = 4},
  [151] = {.lex_state = 201, .external_lex_state = 4},
  [152] = {.lex_state = 201, .external_lex_state = 5},
  [153] = {.lex_state = 201, .external_lex_state = 5},
  [154] = {.lex_state = 201, .external_lex_state = 5},
  [155] = {.lex_state = 201, .external_lex_state = 5},
  [156] = {.lex_state = 201, .external_lex_state = 4},
  [157] = {.lex_state = 201, .external_lex_state = 4},
  [158] = {.lex_state = 201, .external_lex_state = 4},
  [159] = {.lex_state = 201, .external_lex_state = 4},
  [160] = {.lex_state = 201, .external_lex_state = 4},
  [161] = {.lex_state = 201, .external_lex_state = 4},
  [162] = {.lex_state = 201, .external_lex_state = 4},
  [163] = {.lex_state = 201, .external_lex_state = 4},
  [164] = {.lex_state = 201, .external_lex_state = 4},
  [165] = {.lex_state = 201, .external_lex_state = 4},
  [166] = {.lex_state = 201, .external_lex_state = 4},
  [167] = {.lex_state = 201, .external_lex_state = 4},
  [168] = {.lex_state = 201, .external_lex_state = 4},
  [169] = {.lex_state = 201, .external_lex_state = 4},
  [170] = {.lex_state = 201, .external_lex_state = 4},
  [171] = {.lex_state = 201, .external_lex_state = 4},
  [172] = {.lex_state = 201, .external_lex_state = 4},
  [173] = {.lex_state = 201, .external_lex_state = 4},
  [174] = {.lex_state = 201, .external_lex_state = 4},
  [175] = {.lex_state = 201, .external_lex_state = 4},
  [176] = {.lex_state = 201, .external_lex_state = 4},
  [177] = {.lex_state = 201, .external_lex_state = 4},
  [178] = {.lex_state = 201, .external_lex_state = 4},
  [179] = {.lex_state = 201, .external_lex_state = 4},
  [180] = {.lex_state = 201, .external_lex_state = 4},
  [181] = {.lex_state = 201, .external_lex_state = 4},
  [182] = {.lex_state = 201, .external_lex_state = 4},
  [183] = {.lex_state = 201, .external_lex_state = 4},
  [184] = {.lex_state = 201, .external_lex_state = 4},
  [185] = {.lex_state = 201, .external_lex_state = 4},
  [186] = {.lex_state = 201, .external_lex_state = 4},
  [187] = {.lex_state = 201, .external_lex_state = 4},
  [188] = {.lex_state = 201, .external_lex_state = 4},
  [189] = {.lex_state = 201, .external_lex_state = 4},
  [190] = {.lex_state = 201, .external_lex_state = 4},
  [191] = {.lex_state = 201, .external_lex_state = 4},
  [192] = {.lex_state = 201, .external_lex_state = 4},
  [193] = {.lex_state = 201, .external_lex_state = 4},
  [194] = {.lex_state = 201, .external_lex_state = 4},
  [195] = {.lex_state = 201, .external_lex_state = 4},
  [196] = {.lex_state = 201, .external_lex_state = 4},
  [197] = {.lex_state = 201, .external_lex_state = 4},
  [198] = {.lex_state = 201, .external_lex_state = 4},
  [199] = {.lex_state = 201, .external_lex_state = 4},
  [200] = {.lex_state = 201, .external_lex_state = 4},
  [201] = {.lex_state = 201, .external_lex_state = 4},
  [202] = {.lex_state = 201, .external_lex_state = 4},
  [203] = {.lex_state = 201, .external_lex_state = 4},
  [204] = {.lex_state = 201, .external_lex_state = 4},
  [205] = {.lex_state = 201, .external_lex_state = 4},
  [206] = {.lex_state = 201, .external_lex_state = 4},
  [207] = {.lex_state = 201, .external_lex_state = 4},
  [208] = {.lex_state = 201, .external_lex_state = 4},
  [209] = {.lex_state = 201, .external_lex_state = 4},
  [210] = {.lex_state = 201, .external_lex_state = 4},
  [211] = {.lex_state = 201, .external_lex_state = 4},
  [212] = {.lex_state = 201, .external_lex_state = 4},
  [213] = {.lex_state = 201, .external_lex_state = 4},
  [214] = {.lex_state = 201, .external_lex_state = 4},
  [215] = {.lex_state = 201, .external_lex_state = 4},
  [216] = {.lex_state = 201, .external_lex_state = 4},
  [217] = {.lex_state = 201, .external_lex_state = 4},
  [218] = {.lex_state = 201, .external_lex_state = 4},
  [219] = {.lex_state = 201, .external_lex_state = 4},
  [220] = {.lex_state = 201, .external_lex_state = 4},
  [221] = {.lex_state = 201, .external_lex_state = 4},
  [222] = {.lex_state = 201, .external_lex_state = 4},
  [223] = {.lex_state = 201, .external_lex_state = 4},
  [224] = {.lex_state = 201, .external_lex_state = 4},
  [225] = {.lex_state = 201, .external_lex_state = 4},
  [226] = {.lex_state = 201, .external_lex_state = 4},
  [227] = {.lex_state = 201, .external_lex_state = 4},
  [228] = {.lex_state = 201, .external_lex_state = 4},
  [229] = {.lex_state = 201, .external_lex_state = 4},
  [230] = {.lex_state = 201, .external_lex_state = 4},
  [231] = {.lex_state = 201, .external_lex_state = 4},
  [232] = {.lex_state = 201, .external_lex_state = 4},
  [233] = {.lex_state = 201, .external_lex_state = 4},
  [234] = {.lex_state = 201, .external_lex_state = 4},
  [235] = {.lex_state = 201, .external_lex_state = 4},
  [236] = {.lex_state = 201, .external_lex_state = 4},
  [237] = {.lex_state = 201, .external_lex_state = 4},
  [238] = {.lex_state = 201, .external_lex_state = 4},
  [239] = {.lex_state = 201, .external_lex_state = 4},
  [240] = {.lex_state = 201, .external_lex_state = 4},
  [241] = {.lex_state = 201, .external_lex_state = 4},
  [242] = {.lex_state = 201, .external_lex_state = 4},
  [243] = {.lex_state = 201, .external_lex_state = 4},
  [244] = {.lex_state = 201, .external_lex_state = 4},
  [245] = {.lex_state = 201, .external_lex_state = 4},
  [246] = {.lex_state = 201, .external_lex_state = 4},
  [247] = {.lex_state = 201, .external_lex_state = 4},
  [248] = {.lex_state = 201, .external_lex_state = 4},
  [249] = {.lex_state = 201, .external_lex_state = 4},
  [250] = {.lex_state = 201, .external_lex_state = 4},
  [251] = {.lex_state = 201, .external_lex_state = 4},
  [252] = {.lex_state = 201, .external_lex_state = 4},
  [253] = {.lex_state = 201, .external_lex_state = 4},
  [254] = {.lex_state = 201, .external_lex_state = 4},
  [255] = {.lex_state = 201, .external_lex_state = 4},
  [256] = {.lex_state = 201, .external_lex_state = 4},
  [257] = {.lex_state = 201, .external_lex_state = 4},
  [258] = {.lex_state = 201, .external_lex_state = 4},
  [259] = {.lex_state = 201, .external_lex_state = 4},
  [260] = {.lex_state = 201, .external_lex_state = 4},
  [261] = {.lex_state = 201, .external_lex_state = 4},
  [262] = {.lex_state = 201, .external_lex_state = 4},
  [263] = {.lex_state = 201, .external_lex_state = 4},
  [264] = {.lex_state = 201, .external_lex_state = 4},
  [265] = {.lex_state = 201, .external_lex_state = 4},
  [266] = {.lex_state = 201, .external_lex_state = 4},
  [267] = {.lex_state = 201, .external_lex_state = 4},
  [268] = {.lex_state = 201, .external_lex_state = 4},
  [269] = {.lex_state = 201, .external_lex_state = 4},
  [270] = {.lex_state = 201, .external_lex_state = 4},
  [271] = {.lex_state = 201, .external_lex_state = 4},
  [272] = {.lex_state = 201, .external_lex_state = 4},
  [273] = {.lex_state = 201, .external_lex_state = 4},
  [274] = {.lex_state = 201, .external_lex_state = 4},
  [275] = {.lex_state = 201, .external_lex_state = 4},
  [276] = {.lex_state = 201, .external_lex_state = 4},
  [277] = {.lex_state = 201, .external_lex_state = 4},
  [278] = {.lex_state = 201, .external_lex_state = 4},
  [279] = {.lex_state = 201, .external_lex_state = 4},
  [280] = {.lex_state = 201, .external_lex_state = 4},
  [281] = {.lex_state = 201, .external_lex_state = 4},
  [282] = {.lex_state = 201, .external_lex_state = 4},
  [283] = {.lex_state = 201, .external_lex_state = 4},
  [284] = {.lex_state = 201, .external_lex_state = 4},
  [285] = {.lex_state = 201, .external_lex_state = 4},
  [286] = {.lex_state = 201, .external_lex_state = 4},
  [287] = {.lex_state = 201, .external_lex_state = 4},
  [288] = {.lex_state = 201, .external_lex_state = 4},
  [289] = {.lex_state = 201, .external_lex_state = 4},
  [290] = {.lex_state = 201, .external_lex_state = 4},
  [291] = {.lex_state = 201, .external_lex_state = 4},
  [292] = {.lex_state = 201, .external_lex_state = 4},
  [293] = {.lex_state = 201, .external_lex_state = 4},
  [294] = {.lex_state = 201, .external_lex_state = 4},
  [295] = {.lex_state = 201, .external_lex_state = 4},
  [296] = {.lex_state = 201, .external_lex_state = 4},
  [297] = {.lex_state = 201, .external_lex_state = 4},
  [298] = {.lex_state = 201, .external_lex_state = 4},
  [299] = {.lex_state = 201, .external_lex_state = 4},
  [300] = {.lex_state = 201, .external_lex_state = 4},
  [301] = {.lex_state = 201, .external_lex_state = 4},
  [302] = {.lex_state = 201, .external_lex_state = 4},
  [303] = {.lex_state = 201, .external_lex_state = 4},
  [304] = {.lex_state = 201, .external_lex_state = 4},
  [305] = {.lex_state = 201, .external_lex_state = 4},
  [306] = {.lex_state = 201, .external_lex_state = 4},
  [307] = {.lex_state = 201, .external_lex_state = 4},
  [308] = {.lex_state = 201, .external_lex_state = 4},
  [309] = {.lex_state = 201, .external_lex_state = 4},
  [310] = {.lex_state = 201, .external_lex_state = 4},
  [311] = {.lex_state = 201, .external_lex_state = 4},
  [312] = {.lex_state = 201, .external_lex_state = 4},
  [313] = {.lex_state = 201, .external_lex_state = 4},
  [314] = {.lex_state = 201, .external_lex_state = 4},
  [315] = {.lex_state = 201, .external_lex_state = 4},
  [316] = {.lex_state = 201, .external_lex_state = 4},
  [317] = {.lex_state = 201, .external_lex_state = 4},
  [318] = {.lex_state = 201, .external_lex_state = 4},
  [319] = {.lex_state = 201, .external_lex_state = 4},
  [320] = {.lex_state = 201, .external_lex_state = 4},
  [321] = {.lex_state = 201, .external_lex_state = 4},
  [322] = {.lex_state = 201, .external_lex_state = 4},
  [323] = {.lex_state = 201, .external_lex_state = 4},
  [324] = {.lex_state = 201, .external_lex_state = 4},
  [325] = {.lex_state = 201, .external_lex_state = 4},
  [326] = {.lex_state = 201, .external_lex_state = 4},
  [327] = {.lex_state = 201, .external_lex_state = 4},
  [328] = {.lex_state = 201, .external_lex_state = 4},
  [329] = {.lex_state = 201, .external_lex_state = 4},
  [330] = {.lex_state = 201, .external_lex_state = 4},
  [331] = {.lex_state = 201, .external_lex_state = 4},
  [332] = {.lex_state = 201, .external_lex_state = 4},
  [333] = {.lex_state = 201, .external_lex_state = 4},
  [334] = {.lex_state = 201, .external_lex_state = 4},
  [335] = {.lex_state = 201, .external_lex_state = 4},
  [336] = {.lex_state = 201, .external_lex_state = 4},
  [337] = {.lex_state = 201, .external_lex_state = 4},
  [338] = {.lex_state = 201, .external_lex_state = 4},
  [339] = {.lex_state = 201, .external_lex_state = 4},
  [340] = {.lex_state = 201, .external_lex_state = 4},
  [341] = {.lex_state = 201, .external_lex_state = 4},
  [342] = {.lex_state = 201, .external_lex_state = 4},
  [343] = {.lex_state = 201, .external_lex_state = 4},
  [344] = {.lex_state = 201, .external_lex_state = 4},
  [345] = {.lex_state = 201, .external_lex_state = 4},
  [346] = {.lex_state = 201, .external_lex_state = 4},
  [347] = {.lex_state = 201, .external_lex_state = 4},
  [348] = {.lex_state = 201, .external_lex_state = 4},
  [349] = {.lex_state = 201, .external_lex_state = 4},
  [350] = {.lex_state = 201, .external_lex_state = 4},
  [351] = {.lex_state = 201, .external_lex_state = 4},
  [352] = {.lex_state = 201, .external_lex_state = 4},
  [353] = {.lex_state = 201, .external_lex_state = 4},
  [354] = {.lex_state = 201, .external_lex_state = 4},
  [355] = {.lex_state = 201, .external_lex_state = 4},
  [356] = {.lex_state = 201, .external_lex_state = 4},
  [357] = {.lex_state = 201, .external_lex_state = 4},
  [358] = {.lex_state = 201, .external_lex_state = 4},
  [359] = {.lex_state = 201, .external_lex_state = 4},
  [360] = {.lex_state = 201, .external_lex_state = 4},
  [361] = {.lex_state = 201, .external_lex_state = 4},
  [362] = {.lex_state = 201, .external_lex_state = 4},
  [363] = {.lex_state = 201, .external_lex_state = 4},
  [364] = {.lex_state = 201, .external_lex_state = 4},
  [365] = {.lex_state = 201, .external_lex_state = 4},
  [366] = {.lex_state = 201, .external_lex_state = 4},
  [367] = {.lex_state = 201, .external_lex_state = 4},
  [368] = {.lex_state = 201, .external_lex_state = 4},
  [369] = {.lex_state = 201, .external_lex_state = 4},
  [370] = {.lex_state = 201, .external_lex_state = 4},
  [371] = {.lex_state = 201, .external_lex_state = 4},
  [372] = {.lex_state = 201, .external_lex_state = 4},
  [373] = {.lex_state = 201, .external_lex_state = 4},
  [374] = {.lex_state = 201, .external_lex_state = 4},
  [375] = {.lex_state = 201, .external_lex_state = 4},
  [376] = {.lex_state = 201, .external_lex_state = 4},
  [377] = {.lex_state = 201, .external_lex_state = 4},
  [378] = {.lex_state = 201, .external_lex_state = 4},
  [379] = {.lex_state = 201, .external_lex_state = 4},
  [380] = {.lex_state = 201, .external_lex_state = 4},
  [381] = {.lex_state = 201, .external_lex_state = 4},
  [382] = {.lex_state = 201, .external_lex_state = 4},
  [383] = {.lex_state = 201, .external_lex_state = 4},
  [384] = {.lex_state = 201, .external_lex_state = 4},
  [385] = {.lex_state = 201, .external_lex_state = 4},
  [386] = {.lex_state = 201, .external_lex_state = 4},
  [387] = {.lex_state = 201, .external_lex_state = 4},
  [388] = {.lex_state = 201, .external_lex_state = 4},
  [389] = {.lex_state = 201, .external_lex_state = 4},
  [390] = {.lex_state = 201, .external_lex_state = 4},
  [391] = {.lex_state = 201, .external_lex_state = 4},
  [392] = {.lex_state = 201, .external_lex_state = 4},
  [393] = {.lex_state = 201, .external_lex_state = 4},
  [394] = {.lex_state = 201, .external_lex_state = 4},
  [395] = {.lex_state = 201, .external_lex_state = 4},
  [396] = {.lex_state = 201, .external_lex_state = 4},
  [397] = {.lex_state = 201, .external_lex_state = 4},
  [398] = {.lex_state = 201, .external_lex_state = 4},
  [399] = {.lex_state = 201, .external_lex_state = 4},
  [400] = {.lex_state = 201, .external_lex_state = 4},
  [401] = {.lex_state = 201, .external_lex_state = 4},
  [402] = {.lex_state = 201, .external_lex_state = 4},
  [403] = {.lex_state = 201, .external_lex_state = 4},
  [404] = {.lex_state = 201, .external_lex_state = 4},
  [405] = {.lex_state = 201, .external_lex_state = 4},
  [406] = {.lex_state = 201, .external_lex_state = 4},
  [407] = {.lex_state = 201, .external_lex_state = 4},
  [408] = {.lex_state = 201, .external_lex_state = 4},
  [409] = {.lex_state = 201, .external_lex_state = 4},
  [410] = {.lex_state = 201, .external_lex_state = 4},
  [411] = {.lex_state = 201, .external_lex_state = 4},
  [412] = {.lex_state = 201, .external_lex_state = 4},
  [413] = {.lex_state = 201, .external_lex_state = 4},
  [414] = {.lex_state = 201, .external_lex_state = 4},
  [415] = {.lex_state = 201, .external_lex_state = 4},
  [416] = {.lex_state = 201, .external_lex_state = 4},
  [417] = {.lex_state = 201, .external_lex_state = 4},
  [418] = {.lex_state = 201, .external_lex_state = 4},
  [419] = {.lex_state = 201, .external_lex_state = 4},
  [420] = {.lex_state = 201, .external_lex_state = 4},
  [421] = {.lex_state = 201, .external_lex_state = 4},
  [422] = {.lex_state = 201, .external_lex_state = 4},
  [423] = {.lex_state = 201, .external_lex_state = 4},
  [424] = {.lex_state = 201, .external_lex_state = 4},
  [425] = {.lex_state = 201, .external_lex_state = 4},
  [426] = {.lex_state = 201, .external_lex_state = 4},
  [427] = {.lex_state = 201, .external_lex_state = 4},
  [428] = {.lex_state = 201, .external_lex_state = 4},
  [429] = {.lex_state = 201, .external_lex_state = 4},
  [430] = {.lex_state = 201, .external_lex_state = 4},
  [431] = {.lex_state = 201, .external_lex_state = 4},
  [432] = {.lex_state = 201, .external_lex_state = 4},
  [433] = {.lex_state = 201, .external_lex_state = 4},
  [434] = {.lex_state = 201, .external_lex_state = 4},
  [435] = {.lex_state = 201, .external_lex_state = 4},
  [436] = {.lex_state = 201, .external_lex_state = 4},
  [437] = {.lex_state = 201, .external_lex_state = 4},
  [438] = {.lex_state = 201, .external_lex_state = 4},
  [439] = {.lex_state = 201, .external_lex_state = 4},
  [440] = {.lex_state = 201, .external_lex_state = 4},
  [441] = {.lex_state = 201, .external_lex_state = 4},
  [442] = {.lex_state = 201, .external_lex_state = 4},
  [443] = {.lex_state = 201, .external_lex_state = 4},
  [444] = {.lex_state = 201, .external_lex_state = 4},
  [445] = {.lex_state = 201, .external_lex_state = 4},
  [446] = {.lex_state = 201, .external_lex_state = 4},
  [447] = {.lex_state = 201, .external_lex_state = 4},
  [448] = {.lex_state = 201, .external_lex_state = 4},
  [449] = {.lex_state = 201, .external_lex_state = 4},
  [450] = {.lex_state = 201, .external_lex_state = 4},
  [451] = {.lex_state = 201, .external_lex_state = 4},
  [452] = {.lex_state = 201, .external_lex_state = 4},
  [453] = {.lex_state = 201, .external_lex_state = 4},
  [454] = {.lex_state = 201, .external_lex_state = 4},
  [455] = {.lex_state = 201, .external_lex_state = 4},
  [456] = {.lex_state = 201, .external_lex_state = 4},
  [457] = {.lex_state = 201, .external_lex_state = 4},
  [458] = {.lex_state = 201, .external_lex_state = 4},
  [459] = {.lex_state = 201, .external_lex_state = 4},
  [460] = {.lex_state = 201, .external_lex_state = 4},
  [461] = {.lex_state = 201, .external_lex_state = 4},
  [462] = {.lex_state = 201, .external_lex_state = 4},
  [463] = {.lex_state = 201, .external_lex_state = 4},
  [464] = {.lex_state = 201, .external_lex_state = 4},
  [465] = {.lex_state = 201, .external_lex_state = 4},
  [466] = {.lex_state = 201, .external_lex_state = 4},
  [467] = {.lex_state = 201, .external_lex_state = 4},
  [468] = {.lex_state = 201, .external_lex_state = 4},
  [469] = {.lex_state = 201, .external_lex_state = 4},
  [470] = {.lex_state = 201, .external_lex_state = 4},
  [471] = {.lex_state = 201, .external_lex_state = 4},
  [472] = {.lex_state = 201, .external_lex_state = 4},
  [473] = {.lex_state = 201, .external_lex_state = 4},
  [474] = {.lex_state = 201, .external_lex_state = 4},
  [475] = {.lex_state = 201, .external_lex_state = 4},
  [476] = {.lex_state = 201, .external_lex_state = 4},
  [477] = {.lex_state = 201, .external_lex_state = 4},
  [478] = {.lex_state = 201, .external_lex_state = 4},
  [479] = {.lex_state = 201, .external_lex_state = 4},
  [480] = {.lex_state = 201, .external_lex_state = 4},
  [481] = {.lex_state = 201, .external_lex_state = 4},
  [482] = {.lex_state = 201, .external_lex_state = 4},
  [483] = {.lex_state = 201, .external_lex_state = 4},
  [484] = {.lex_state = 201, .external_lex_state = 4},
  [485] = {.lex_state = 201, .external_lex_state = 4},
  [486] = {.lex_state = 201, .external_lex_state = 4},
  [487] = {.lex_state = 201, .external_lex_state = 4},
  [488] = {.lex_state = 201, .external_lex_state = 4},
  [489] = {.lex_state = 201, .external_lex_state = 4},
  [490] = {.lex_state = 201, .external_lex_state = 4},
  [491] = {.lex_state = 201, .external_lex_state = 4},
  [492] = {.lex_state = 201, .external_lex_state = 4},
  [493] = {.lex_state = 201, .external_lex_state = 4},
  [494] = {.lex_state = 201, .external_lex_state = 4},
  [495] = {.lex_state = 201, .external_lex_state = 4},
  [496] = {.lex_state = 201, .external_lex_state = 4},
  [497] = {.lex_state = 201, .external_lex_state = 4},
  [498] = {.lex_state = 201, .external_lex_state = 4},
  [499] = {.lex_state = 201, .external_lex_state = 4},
  [500] = {.lex_state = 201, .external_lex_state = 4},
  [501] = {.lex_state = 201, .external_lex_state = 4},
  [502] = {.lex_state = 201, .external_lex_state = 4},
  [503] = {.lex_state = 201, .external_lex_state = 4},
  [504] = {.lex_state = 201, .external_lex_state = 4},
  [505] = {.lex_state = 201, .external_lex_state = 4},
  [506] = {.lex_state = 201, .external_lex_state = 4},
  [507] = {.lex_state = 201, .external_lex_state = 4},
  [508] = {.lex_state = 201, .external_lex_state = 4},
  [509] = {.lex_state = 201, .external_lex_state = 4},
  [510] = {.lex_state = 201, .external_lex_state = 4},
  [511] = {.lex_state = 201, .external_lex_state = 4},
  [512] = {.lex_state = 201, .external_lex_state = 4},
  [513] = {.lex_state = 201, .external_lex_state = 4},
  [514] = {.lex_state = 201, .external_lex_state = 4},
  [515] = {.lex_state = 201, .external_lex_state = 4},
  [516] = {.lex_state = 201, .external_lex_state = 4},
  [517] = {.lex_state = 201, .external_lex_state = 4},
  [518] = {.lex_state = 201, .external_lex_state = 4},
  [519] = {.lex_state = 201, .external_lex_state = 4},
  [520] = {.lex_state = 201, .external_lex_state = 4},
  [521] = {.lex_state = 201, .external_lex_state = 4},
  [522] = {.lex_state = 201, .external_lex_state = 4},
  [523] = {.lex_state = 201, .external_lex_state = 4},
  [524] = {.lex_state = 201, .external_lex_state = 4},
  [525] = {.lex_state = 201, .external_lex_state = 4},
  [526] = {.lex_state = 201, .external_lex_state = 4},
  [527] = {.lex_state = 201, .external_lex_state = 4},
  [528] = {.lex_state = 201, .external_lex_state = 4},
  [529] = {.lex_state = 201, .external_lex_state = 4},
  [530] = {.lex_state = 201, .external_lex_state = 4},
  [531] = {.lex_state = 201, .external_lex_state = 4},
  [532] = {.lex_state = 201, .external_lex_state = 4},
  [533] = {.lex_state = 201, .external_lex_state = 4},
  [534] = {.lex_state = 201, .external_lex_state = 4},
  [535] = {.lex_state = 201, .external_lex_state = 4},
  [536] = {.lex_state = 201, .external_lex_state = 4},
  [537] = {.lex_state = 201, .external_lex_state = 4},
  [538] = {.lex_state = 201, .external_lex_state = 4},
  [539] = {.lex_state = 201, .external_lex_state = 4},
  [540] = {.lex_state = 201, .external_lex_state = 4},
  [541] = {.lex_state = 201, .external_lex_state = 4},
  [542] = {.lex_state = 201, .external_lex_state = 4},
  [543] = {.lex_state = 201, .external_lex_state = 4},
  [544] = {.lex_state = 201, .external_lex_state = 4},
  [545] = {.lex_state = 201, .external_lex_state = 4},
  [546] = {.lex_state = 201, .external_lex_state = 4},
  [547] = {.lex_state = 201, .external_lex_state = 4},
  [548] = {.lex_state = 201, .external_lex_state = 4},
  [549] = {.lex_state = 201, .external_lex_state = 4},
  [550] = {.lex_state = 201, .external_lex_state = 4},
  [551] = {.lex_state = 201, .external_lex_state = 4},
  [552] = {.lex_state = 201, .external_lex_state = 4},
  [553] = {.lex_state = 201, .external_lex_state = 4},
  [554] = {.lex_state = 201, .external_lex_state = 4},
  [555] = {.lex_state = 201, .external_lex_state = 4},
  [556] = {.lex_state = 201, .external_lex_state = 4},
  [557] = {.lex_state = 201, .external_lex_state = 4},
  [558] = {.lex_state = 201, .external_lex_state = 4},
  [559] = {.lex_state = 201, .external_lex_state = 4},
  [560] = {.lex_state = 201, .external_lex_state = 4},
  [561] = {.lex_state = 201, .external_lex_state = 4},
  [562] = {.lex_state = 201, .external_lex_state = 4},
  [563] = {.lex_state = 201, .external_lex_state = 4},
  [564] = {.lex_state = 201, .external_lex_state = 4},
  [565] = {.lex_state = 201, .external_lex_state = 4},
  [566] = {.lex_state = 201, .external_lex_state = 4},
  [567] = {.lex_state = 201, .external_lex_state = 4},
  [568] = {.lex_state = 201, .external_lex_state = 4},
  [569] = {.lex_state = 201, .external_lex_state = 4},
  [570] = {.lex_state = 201, .external_lex_state = 4},
  [571] = {.lex_state = 201, .external_lex_state = 4},
  [572] = {.lex_state = 201, .external_lex_state = 4},
  [573] = {.lex_state = 201, .external_lex_state = 4},
  [574] = {.lex_state = 201, .external_lex_state = 4},
  [575] = {.lex_state = 201, .external_lex_state = 4},
  [576] = {.lex_state = 201, .external_lex_state = 4},
  [577] = {.lex_state = 201, .external_lex_state = 4},
  [578] = {.lex_state = 201, .external_lex_state = 4},
  [579] = {.lex_state = 201, .external_lex_state = 4},
  [580] = {.lex_state = 201, .external_lex_state = 4},
  [581] = {.lex_state = 201, .external_lex_state = 4},
  [582] = {.lex_state = 201, .external_lex_state = 4},
  [583] = {.lex_state = 201, .external_lex_state = 4},
  [584] = {.lex_state = 201, .external_lex_state = 4},
  [585] = {.lex_state = 201, .external_lex_state = 4},
  [586] = {.lex_state = 201, .external_lex_state = 4},
  [587] = {.lex_state = 201, .external_lex_state = 4},
  [588] = {.lex_state = 201, .external_lex_state = 4},
  [589] = {.lex_state = 201, .external_lex_state = 4},
  [590] = {.lex_state = 201, .external_lex_state = 4},
  [591] = {.lex_state = 201, .external_lex_state = 4},
  [592] = {.lex_state = 201, .external_lex_state = 4},
  [593] = {.lex_state = 201, .external_lex_state = 4},
  [594] = {.lex_state = 201, .external_lex_state = 4},
  [595] = {.lex_state = 201, .external_lex_state = 4},
  [596] = {.lex_state = 201, .external_lex_state = 4},
  [597] = {.lex_state = 201, .external_lex_state = 4},
  [598] = {.lex_state = 201, .external_lex_state = 4},
  [599] = {.lex_state = 201, .external_lex_state = 4},
  [600] = {.lex_state = 201, .external_lex_state = 4},
  [601] = {.lex_state = 201, .external_lex_state = 4},
  [602] = {.lex_state = 201, .external_lex_state = 4},
  [603] = {.lex_state = 201, .external_lex_state = 4},
  [604] = {.lex_state = 201, .external_lex_state = 4},
  [605] = {.lex_state = 201, .external_lex_state = 4},
  [606] = {.lex_state = 201, .external_lex_state = 4},
  [607] = {.lex_state = 201, .external_lex_state = 4},
  [608] = {.lex_state = 201, .external_lex_state = 4},
  [609] = {.lex_state = 201, .external_lex_state = 4},
  [610] = {.lex_state = 201, .external_lex_state = 4},
  [611] = {.lex_state = 201, .external_lex_state = 4},
  [612] = {.lex_state = 201, .external_lex_state = 4},
  [613] = {.lex_state = 201, .external_lex_state = 4},
  [614] = {.lex_state = 201, .external_lex_state = 4},
  [615] = {.lex_state = 201, .external_lex_state = 4},
  [616] = {.lex_state = 201, .external_lex_state = 4},
  [617] = {.lex_state = 201, .external_lex_state = 4},
  [618] = {.lex_state = 201, .external_lex_state = 4},
  [619] = {.lex_state = 201, .external_lex_state = 4},
  [620] = {.lex_state = 201, .external_lex_state = 4},
  [621] = {.lex_state = 201, .external_lex_state = 4},
  [622] = {.lex_state = 201, .external_lex_state = 4},
  [623] = {.lex_state = 201, .external_lex_state = 4},
  [624] = {.lex_state = 201, .external_lex_state = 4},
  [625] = {.lex_state = 201, .external_lex_state = 4},
  [626] = {.lex_state = 201, .external_lex_state = 4},
  [627] = {.lex_state = 201, .external_lex_state = 4},
  [628] = {.lex_state = 201, .external_lex_state = 4},
  [629] = {.lex_state = 201, .external_lex_state = 4},
  [630] = {.lex_state = 201, .external_lex_state = 4},
  [631] = {.lex_state = 201, .external_lex_state = 4},
  [632] = {.lex_state = 201, .external_lex_state = 4},
  [633] = {.lex_state = 201, .external_lex_state = 4},
  [634] = {.lex_state = 201, .external_lex_state = 4},
  [635] = {.lex_state = 201, .external_lex_state = 4},
  [636] = {.lex_state = 201, .external_lex_state = 4},
  [637] = {.lex_state = 201, .external_lex_state = 4},
  [638] = {.lex_state = 201, .external_lex_state = 4},
  [639] = {.lex_state = 201, .external_lex_state = 4},
  [640] = {.lex_state = 201, .external_lex_state = 4},
  [641] = {.lex_state = 201, .external_lex_state = 4},
  [642] = {.lex_state = 201, .external_lex_state = 4},
  [643] = {.lex_state = 201, .external_lex_state = 4},
  [644] = {.lex_state = 201, .external_lex_state = 4},
  [645] = {.lex_state = 201, .external_lex_state = 4},
  [646] = {.lex_state = 201, .external_lex_state = 4},
  [647] = {.lex_state = 201, .external_lex_state = 4},
  [648] = {.lex_state = 201, .external_lex_state = 4},
  [649] = {.lex_state = 201, .external_lex_state = 4},
  [650] = {.lex_state = 201, .external_lex_state = 4},
  [651] = {.lex_state = 201, .external_lex_state = 4},
  [652] = {.lex_state = 201, .external_lex_state = 4},
  [653] = {.lex_state = 201, .external_lex_state = 4},
  [654] = {.lex_state = 201, .external_lex_state = 4},
  [655] = {.lex_state = 201, .external_lex_state = 4},
  [656] = {.lex_state = 201, .external_lex_state = 4},
  [657] = {.lex_state = 201, .external_lex_state = 4},
  [658] = {.lex_state = 201, .external_lex_state = 4},
  [659] = {.lex_state = 201, .external_lex_state = 4},
  [660] = {.lex_state = 201, .external_lex_state = 4},
  [661] = {.lex_state = 201, .external_lex_state = 4},
  [662] = {.lex_state = 201, .external_lex_state = 4},
  [663] = {.lex_state = 201, .external_lex_state = 4},
  [664] = {.lex_state = 201, .external_lex_state = 4},
  [665] = {.lex_state = 201, .external_lex_state = 4},
  [666] = {.lex_state = 201, .external_lex_state = 4},
  [667] = {.lex_state = 201, .external_lex_state = 4},
  [668] = {.lex_state = 201, .external_lex_state = 4},
  [669] = {.lex_state = 201, .external_lex_state = 4},
  [670] = {.lex_state = 201, .external_lex_state = 4},
  [671] = {.lex_state = 201, .external_lex_state = 4},
  [672] = {.lex_state = 201, .external_lex_state = 4},
  [673] = {.lex_state = 201, .external_lex_state = 4},
  [674] = {.lex_state = 201, .external_lex_state = 4},
  [675] = {.lex_state = 201, .external_lex_state = 4},
  [676] = {.lex_state = 201, .external_lex_state = 4},
  [677] = {.lex_state = 201, .external_lex_state = 4},
  [678] = {.lex_state = 201, .external_lex_state = 4},
  [679] = {.lex_state = 201, .external_lex_state = 4},
  [680] = {.lex_state = 201, .external_lex_state = 4},
  [681] = {.lex_state = 201, .external_lex_state = 4},
  [682] = {.lex_state = 201, .external_lex_state = 4},
  [683] = {.lex_state = 201, .external_lex_state = 4},
  [684] = {.lex_state = 201, .external_lex_state = 4},
  [685] = {.lex_state = 201, .external_lex_state = 4},
  [686] = {.lex_state = 201, .external_lex_state = 4},
  [687] = {.lex_state = 201, .external_lex_state = 4},
  [688] = {.lex_state = 201, .external_lex_state = 4},
  [689] = {.lex_state = 201, .external_lex_state = 4},
  [690] = {.lex_state = 201, .external_lex_state = 4},
  [691] = {.lex_state = 201, .external_lex_state = 4},
  [692] = {.lex_state = 201, .external_lex_state = 4},
  [693] = {.lex_state = 201, .external_lex_state = 4},
  [694] = {.lex_state = 201, .external_lex_state = 4},
  [695] = {.lex_state = 201, .external_lex_state = 4},
  [696] = {.lex_state = 201, .external_lex_state = 4},
  [697] = {.lex_state = 201, .external_lex_state = 4},
  [698] = {.lex_state = 201, .external_lex_state = 4},
  [699] = {.lex_state = 201, .external_lex_state = 4},
  [700] = {.lex_state = 201, .external_lex_state = 4},
  [701] = {.lex_state = 201, .external_lex_state = 4},
  [702] = {.lex_state = 201, .external_lex_state = 4},
  [703] = {.lex_state = 201, .external_lex_state = 4},
  [704] = {.lex_state = 201, .external_lex_state = 4},
  [705] = {.lex_state = 201, .external_lex_state = 4},
  [706] = {.lex_state = 201, .external_lex_state = 4},
  [707] = {.lex_state = 201, .external_lex_state = 4},
  [708] = {.lex_state = 201, .external_lex_state = 4},
  [709] = {.lex_state = 201, .external_lex_state = 4},
  [710] = {.lex_state = 201, .external_lex_state = 4},
  [711] = {.lex_state = 201, .external_lex_state = 4},
  [712] = {.lex_state = 201, .external_lex_state = 4},
  [713] = {.lex_state = 201, .external_lex_state = 4},
  [714] = {.lex_state = 201, .external_lex_state = 4},
  [715] = {.lex_state = 201, .external_lex_state = 4},
  [716] = {.lex_state = 201, .external_lex_state = 4},
  [717] = {.lex_state = 201, .external_lex_state = 4},
  [718] = {.lex_state = 201, .external_lex_state = 4},
  [719] = {.lex_state = 201, .external_lex_state = 4},
  [720] = {.lex_state = 201, .external_lex_state = 4},
  [721] = {.lex_state = 201, .external_lex_state = 4},
  [722] = {.lex_state = 201, .external_lex_state = 4},
  [723] = {.lex_state = 201, .external_lex_state = 4},
  [724] = {.lex_state = 201, .external_lex_state = 4},
  [725] = {.lex_state = 201, .external_lex_state = 4},
  [726] = {.lex_state = 201, .external_lex_state = 4},
  [727] = {.lex_state = 201, .external_lex_state = 4},
  [728] = {.lex_state = 201, .external_lex_state = 4},
  [729] = {.lex_state = 201, .external_lex_state = 4},
  [730] = {.lex_state = 201, .external_lex_state = 4},
  [731] = {.lex_state = 201, .external_lex_state = 4},
  [732] = {.lex_state = 201, .external_lex_state = 4},
  [733] = {.lex_state = 201, .external_lex_state = 4},
  [734] = {.lex_state = 201, .external_lex_state = 4},
  [735] = {.lex_state = 201, .external_lex_state = 4},
  [736] = {.lex_state = 201, .external_lex_state = 4},
  [737] = {.lex_state = 201, .external_lex_state = 4},
  [738] = {.lex_state = 201, .external_lex_state = 4},
  [739] = {.lex_state = 201, .external_lex_state = 4},
  [740] = {.lex_state = 201, .external_lex_state = 4},
  [741] = {.lex_state = 201, .external_lex_state = 4},
  [742] = {.lex_state = 201, .external_lex_state = 4},
  [743] = {.lex_state = 201, .external_lex_state = 4},
  [744] = {.lex_state = 201, .external_lex_state = 4},
  [745] = {.lex_state = 201, .external_lex_state = 4},
  [746] = {.lex_state = 201, .external_lex_state = 4},
  [747] = {.lex_state = 201, .external_lex_state = 4},
  [748] = {.lex_state = 201, .external_lex_state = 4},
  [749] = {.lex_state = 201, .external_lex_state = 4},
  [750] = {.lex_state = 201, .external_lex_state = 4},
  [751] = {.lex_state = 201, .external_lex_state = 4},
  [752] = {.lex_state = 201, .external_lex_state = 4},
  [753] = {.lex_state = 201, .external_lex_state = 4},
  [754] = {.lex_state = 201, .external_lex_state = 4},
  [755] = {.lex_state = 201, .external_lex_state = 4},
  [756] = {.lex_state = 201, .external_lex_state = 4},
  [757] = {.lex_state = 201, .external_lex_state = 4},
  [758] = {.lex_state = 201, .external_lex_state = 4},
  [759] = {.lex_state = 201, .external_lex_state = 4},
  [760] = {.lex_state = 201, .external_lex_state = 4},
  [761] = {.lex_state = 201, .external_lex_state = 4},
  [762] = {.lex_state = 201, .external_lex_state = 4},
  [763] = {.lex_state = 201, .external_lex_state = 4},
  [764] = {.lex_state = 201, .external_lex_state = 4},
  [765] = {.lex_state = 201, .external_lex_state = 4},
  [766] = {.lex_state = 201, .external_lex_state = 4},
  [767] = {.lex_state = 201, .external_lex_state = 4},
  [768] = {.lex_state = 201, .external_lex_state = 4},
  [769] = {.lex_state = 201, .external_lex_state = 4},
  [770] = {.lex_state = 201, .external_lex_state = 4},
  [771] = {.lex_state = 201, .external_lex_state = 4},
  [772] = {.lex_state = 201, .external_lex_state = 4},
  [773] = {.lex_state = 201, .external_lex_state = 4},
  [774] = {.lex_state = 201, .external_lex_state = 4},
  [775] = {.lex_state = 201, .external_lex_state = 4},
  [776] = {.lex_state = 201, .external_lex_state = 4},
  [777] = {.lex_state = 201, .external_lex_state = 4},
  [778] = {.lex_state = 201, .external_lex_state = 4},
  [779] = {.lex_state = 201, .external_lex_state = 4},
  [780] = {.lex_state = 201, .external_lex_state = 4},
  [781] = {.lex_state = 201, .external_lex_state = 4},
  [782] = {.lex_state = 201, .external_lex_state = 4},
  [783] = {.lex_state = 201, .external_lex_state = 4},
  [784] = {.lex_state = 201, .external_lex_state = 4},
  [785] = {.lex_state = 201, .external_lex_state = 4},
  [786] = {.lex_state = 201, .external_lex_state = 4},
  [787] = {.lex_state = 201, .external_lex_state = 4},
  [788] = {.lex_state = 201, .external_lex_state = 4},
  [789] = {.lex_state = 201, .external_lex_state = 4},
  [790] = {.lex_state = 201, .external_lex_state = 4},
  [791] = {.lex_state = 201, .external_lex_state = 4},
  [792] = {.lex_state = 201, .external_lex_state = 4},
  [793] = {.lex_state = 201, .external_lex_state = 4},
  [794] = {.lex_state = 201, .external_lex_state = 4},
  [795] = {.lex_state = 201, .external_lex_state = 4},
  [796] = {.lex_state = 201, .external_lex_state = 4},
  [797] = {.lex_state = 201, .external_lex_state = 4},
  [798] = {.lex_state = 201, .external_lex_state = 4},
  [799] = {.lex_state = 201, .external_lex_state = 4},
  [800] = {.lex_state = 201, .external_lex_state = 4},
  [801] = {.lex_state = 201, .external_lex_state = 4},
  [802] = {.lex_state = 201, .external_lex_state = 4},
  [803] = {.lex_state = 201, .external_lex_state = 4},
  [804] = {.lex_state = 201, .external_lex_state = 4},
  [805] = {.lex_state = 201, .external_lex_state = 4},
  [806] = {.lex_state = 201, .external_lex_state = 4},
  [807] = {.lex_state = 201, .external_lex_state = 4},
  [808] = {.lex_state = 201, .external_lex_state = 4},
  [809] = {.lex_state = 201, .external_lex_state = 4},
  [810] = {.lex_state = 201, .external_lex_state = 4},
  [811] = {.lex_state = 201, .external_lex_state = 4},
  [812] = {.lex_state = 201, .external_lex_state = 4},
  [813] = {.lex_state = 201, .external_lex_state = 4},
  [814] = {.lex_state = 201, .external_lex_state = 4},
  [815] = {.lex_state = 201, .external_lex_state = 4},
  [816] = {.lex_state = 201, .external_lex_state = 4},
  [817] = {.lex_state = 201, .external_lex_state = 4},
  [818] = {.lex_state = 201, .external_lex_state = 4},
  [819] = {.lex_state = 201, .external_lex_state = 4},
  [820] = {.lex_state = 201, .external_lex_state = 4},
  [821] = {.lex_state = 201, .external_lex_state = 4},
  [822] = {.lex_state = 201, .external_lex_state = 4},
  [823] = {.lex_state = 201, .external_lex_state = 4},
  [824] = {.lex_state = 201, .external_lex_state = 4},
  [825] = {.lex_state = 201, .external_lex_state = 4},
  [826] = {.lex_state = 201, .external_lex_state = 4},
  [827] = {.lex_state = 201, .external_lex_state = 4},
  [828] = {.lex_state = 201, .external_lex_state = 4},
  [829] = {.lex_state = 201, .external_lex_state = 4},
  [830] = {.lex_state = 201, .external_lex_state = 4},
  [831] = {.lex_state = 201, .external_lex_state = 4},
  [832] = {.lex_state = 201, .external_lex_state = 4},
  [833] = {.lex_state = 201, .external_lex_state = 4},
  [834] = {.lex_state = 201, .external_lex_state = 4},
  [835] = {.lex_state = 201, .external_lex_state = 4},
  [836] = {.lex_state = 201, .external_lex_state = 4},
  [837] = {.lex_state = 201, .external_lex_state = 4},
  [838] = {.lex_state = 201, .external_lex_state = 4},
  [839] = {.lex_state = 201, .external_lex_state = 4},
  [840] = {.lex_state = 201, .external_lex_state = 4},
  [841] = {.lex_state = 201, .external_lex_state = 4},
  [842] = {.lex_state = 201, .external_lex_state = 4},
  [843] = {.lex_state = 201, .external_lex_state = 4},
  [844] = {.lex_state = 201, .external_lex_state = 4},
  [845] = {.lex_state = 201, .external_lex_state = 4},
  [846] = {.lex_state = 201, .external_lex_state = 4},
  [847] = {.lex_state = 201, .external_lex_state = 4},
  [848] = {.lex_state = 201, .external_lex_state = 4},
  [849] = {.lex_state = 201, .external_lex_state = 4},
  [850] = {.lex_state = 201, .external_lex_state = 4},
  [851] = {.lex_state = 201, .external_lex_state = 4},
  [852] = {.lex_state = 201, .external_lex_state = 4},
  [853] = {.lex_state = 201, .external_lex_state = 4},
  [854] = {.lex_state = 201, .external_lex_state = 4},
  [855] = {.lex_state = 201, .external_lex_state = 4},
  [856] = {.lex_state = 201, .external_lex_state = 4},
  [857] = {.lex_state = 201, .external_lex_state = 4},
  [858] = {.lex_state = 201, .external_lex_state = 4},
  [859] = {.lex_state = 201, .external_lex_state = 4},
  [860] = {.lex_state = 201, .external_lex_state = 4},
  [861] = {.lex_state = 201, .external_lex_state = 4},
  [862] = {.lex_state = 201, .external_lex_state = 4},
  [863] = {.lex_state = 201, .external_lex_state = 4},
  [864] = {.lex_state = 201, .external_lex_state = 4},
  [865] = {.lex_state = 201, .external_lex_state = 4},
  [866] = {.lex_state = 201, .external_lex_state = 4},
  [867] = {.lex_state = 201, .external_lex_state = 4},
  [868] = {.lex_state = 201, .external_lex_state = 4},
  [869] = {.lex_state = 201, .external_lex_state = 4},
  [870] = {.lex_state = 201, .external_lex_state = 4},
  [871] = {.lex_state = 201, .external_lex_state = 4},
  [872] = {.lex_state = 201, .external_lex_state = 4},
  [873] = {.lex_state = 201, .external_lex_state = 4},
  [874] = {.lex_state = 201, .external_lex_state = 4},
  [875] = {.lex_state = 201, .external_lex_state = 4},
  [876] = {.lex_state = 201, .external_lex_state = 4},
  [877] = {.lex_state = 201, .external_lex_state = 4},
  [878] = {.lex_state = 201, .external_lex_state = 4},
  [879] = {.lex_state = 201, .external_lex_state = 4},
  [880] = {.lex_state = 201, .external_lex_state = 4},
  [881] = {.lex_state = 201, .external_lex_state = 4},
  [882] = {.lex_state = 201, .external_lex_state = 4},
  [883] = {.lex_state = 201, .external_lex_state = 4},
  [884] = {.lex_state = 201, .external_lex_state = 4},
  [885] = {.lex_state = 201, .external_lex_state = 4},
  [886] = {.lex_state = 201, .external_lex_state = 4},
  [887] = {.lex_state = 201, .external_lex_state = 4},
  [888] = {.lex_state = 201, .external_lex_state = 4},
  [889] = {.lex_state = 201, .external_lex_state = 4},
  [890] = {.lex_state = 201, .external_lex_state = 4},
  [891] = {.lex_state = 201, .external_lex_state = 4},
  [892] = {.lex_state = 201, .external_lex_state = 4},
  [893] = {.lex_state = 201, .external_lex_state = 4},
  [894] = {.lex_state = 201, .external_lex_state = 4},
  [895] = {.lex_state = 201, .external_lex_state = 4},
  [896] = {.lex_state = 201, .external_lex_state = 4},
  [897] = {.lex_state = 201, .external_lex_state = 4},
  [898] = {.lex_state = 201, .external_lex_state = 4},
  [899] = {.lex_state = 201, .external_lex_state = 4},
  [900] = {.lex_state = 201, .external_lex_state = 4},
  [901] = {.lex_state = 201, .external_lex_state = 4},
  [902] = {.lex_state = 201, .external_lex_state = 4},
  [903] = {.lex_state = 201, .external_lex_state = 4},
  [904] = {.lex_state = 201, .external_lex_state = 4},
  [905] = {.lex_state = 201, .external_lex_state = 4},
  [906] = {.lex_state = 201, .external_lex_state = 4},
  [907] = {.lex_state = 201, .external_lex_state = 4},
  [908] = {.lex_state = 201, .external_lex_state = 4},
  [909] = {.lex_state = 201, .external_lex_state = 4},
  [910] = {.lex_state = 201, .external_lex_state = 4},
  [911] = {.lex_state = 201, .external_lex_state = 4},
  [912] = {.lex_state = 201, .external_lex_state = 4},
  [913] = {.lex_state = 201, .external_lex_state = 4},
  [914] = {.lex_state = 201, .external_lex_state = 4},
  [915] = {.lex_state = 201, .external_lex_state = 4},
  [916] = {.lex_state = 201, .external_lex_state = 4},
  [917] = {.lex_state = 201, .external_lex_state = 4},
  [918] = {.lex_state = 201, .external_lex_state = 4},
  [919] = {.lex_state = 201, .external_lex_state = 4},
  [920] = {.lex_state = 201, .external_lex_state = 4},
  [921] = {.lex_state = 201, .external_lex_state = 4},
  [922] = {.lex_state = 201, .external_lex_state = 4},
  [923] = {.lex_state = 201, .external_lex_state = 4},
  [924] = {.lex_state = 201, .external_lex_state = 4},
  [925] = {.lex_state = 201, .external_lex_state = 4},
  [926] = {.lex_state = 201, .external_lex_state = 4},
  [927] = {.lex_state = 201, .external_lex_state = 4},
  [928] = {.lex_state = 201, .external_lex_state = 4},
  [929] = {.lex_state = 201, .external_lex_state = 4},
  [930] = {.lex_state = 201, .external_lex_state = 4},
  [931] = {.lex_state = 201, .external_lex_state = 4},
  [932] = {.lex_state = 201, .external_lex_state = 4},
  [933] = {.lex_state = 201, .external_lex_state = 4},
  [934] = {.lex_state = 201, .external_lex_state = 4},
  [935] = {.lex_state = 201, .external_lex_state = 4},
  [936] = {.lex_state = 201, .external_lex_state = 4},
  [937] = {.lex_state = 201, .external_lex_state = 4},
  [938] = {.lex_state = 201, .external_lex_state = 4},
  [939] = {.lex_state = 201, .external_lex_state = 4},
  [940] = {.lex_state = 201, .external_lex_state = 4},
  [941] = {.lex_state = 201, .external_lex_state = 4},
  [942] = {.lex_state = 201, .external_lex_state = 4},
  [943] = {.lex_state = 201, .external_lex_state = 4},
  [944] = {.lex_state = 201, .external_lex_state = 4},
  [945] = {.lex_state = 201, .external_lex_state = 4},
  [946] = {.lex_state = 201, .external_lex_state = 4},
  [947] = {.lex_state = 201, .external_lex_state = 4},
  [948] = {.lex_state = 201, .external_lex_state = 4},
  [949] = {.lex_state = 201, .external_lex_state = 4},
  [950] = {.lex_state = 201, .external_lex_state = 4},
  [951] = {.lex_state = 201, .external_lex_state = 4},
  [952] = {.lex_state = 201, .external_lex_state = 4},
  [953] = {.lex_state = 201, .external_lex_state = 4},
  [954] = {.lex_state = 201, .external_lex_state = 4},
  [955] = {.lex_state = 201, .external_lex_state = 4},
  [956] = {.lex_state = 201, .external_lex_state = 4},
  [957] = {.lex_state = 201, .external_lex_state = 4},
  [958] = {.lex_state = 201, .external_lex_state = 4},
  [959] = {.lex_state = 201, .external_lex_state = 4},
  [960] = {.lex_state = 201, .external_lex_state = 4},
  [961] = {.lex_state = 201, .external_lex_state = 4},
  [962] = {.lex_state = 201, .external_lex_state = 4},
  [963] = {.lex_state = 201, .external_lex_state = 4},
  [964] = {.lex_state = 201, .external_lex_state = 4},
  [965] = {.lex_state = 201, .external_lex_state = 4},
  [966] = {.lex_state = 201, .external_lex_state = 4},
  [967] = {.lex_state = 201, .external_lex_state = 4},
  [968] = {.lex_state = 201, .external_lex_state = 4},
  [969] = {.lex_state = 201, .external_lex_state = 4},
  [970] = {.lex_state = 201, .external_lex_state = 4},
  [971] = {.lex_state = 201, .external_lex_state = 4},
  [972] = {.lex_state = 201, .external_lex_state = 4},
  [973] = {.lex_state = 201, .external_lex_state = 4},
  [974] = {.lex_state = 201, .external_lex_state = 4},
  [975] = {.lex_state = 201, .external_lex_state = 4},
  [976] = {.lex_state = 201, .external_lex_state = 4},
  [977] = {.lex_state = 201, .external_lex_state = 4},
  [978] = {.lex_state = 201, .external_lex_state = 4},
  [979] = {.lex_state = 201, .external_lex_state = 4},
  [980] = {.lex_state = 201, .external_lex_state = 4},
  [981] = {.lex_state = 201, .external_lex_state = 4},
  [982] = {.lex_state = 201, .external_lex_state = 4},
  [983] = {.lex_state = 201, .external_lex_state = 4},
  [984] = {.lex_state = 201, .external_lex_state = 4},
  [985] = {.lex_state = 201, .external_lex_state = 4},
  [986] = {.lex_state = 201, .external_lex_state = 4},
  [987] = {.lex_state = 201, .external_lex_state = 4},
  [988] = {.lex_state = 201, .external_lex_state = 4},
  [989] = {.lex_state = 201, .external_lex_state = 4},
  [990] = {.lex_state = 201, .external_lex_state = 4},
  [991] = {.lex_state = 201, .external_lex_state = 4},
  [992] = {.lex_state = 201, .external_lex_state = 4},
  [993] = {.lex_state = 201, .external_lex_state = 4},
  [994] = {.lex_state = 201, .external_lex_state = 4},
  [995] = {.lex_state = 201, .external_lex_state = 4},
  [996] = {.lex_state = 201, .external_lex_state = 4},
  [997] = {.lex_state = 201, .external_lex_state = 4},
  [998] = {.lex_state = 201, .external_lex_state = 4},
  [999] = {.lex_state = 201, .external_lex_state = 4},
  [1000] = {.lex_state = 201, .external_lex_state = 4},
  [1001] = {.lex_state = 201, .external_lex_state = 4},
  [1002] = {.lex_state = 201, .external_lex_state = 4},
  [1003] = {.lex_state = 201, .external_lex_state = 4},
  [1004] = {.lex_state = 201, .external_lex_state = 4},
  [1005] = {.lex_state = 201, .external_lex_state = 4},
  [1006] = {.lex_state = 201, .external_lex_state = 4},
  [1007] = {.lex_state = 201, .external_lex_state = 4},
  [1008] = {.lex_state = 201, .external_lex_state = 4},
  [1009] = {.lex_state = 201, .external_lex_state = 4},
  [1010] = {.lex_state = 201, .external_lex_state = 4},
  [1011] = {.lex_state = 201, .external_lex_state = 4},
  [1012] = {.lex_state = 201, .external_lex_state = 4},
  [1013] = {.lex_state = 201, .external_lex_state = 4},
  [1014] = {.lex_state = 201, .external_lex_state = 4},
  [1015] = {.lex_state = 201, .external_lex_state = 4},
  [1016] = {.lex_state = 201, .external_lex_state = 4},
  [1017] = {.lex_state = 201, .external_lex_state = 4},
  [1018] = {.lex_state = 201, .external_lex_state = 4},
  [1019] = {.lex_state = 201, .external_lex_state = 4},
  [1020] = {.lex_state = 201, .external_lex_state = 4},
  [1021] = {.lex_state = 201, .external_lex_state = 4},
  [1022] = {.lex_state = 201, .external_lex_state = 4},
  [1023] = {.lex_state = 201, .external_lex_state = 4},
  [1024] = {.lex_state = 201, .external_lex_state = 4},
  [1025] = {.lex_state = 201, .external_lex_state = 4},
  [1026] = {.lex_state = 204, .external_lex_state = 6},
  [1027] = {.lex_state = 204, .external_lex_state = 6},
  [1028] = {.lex_state = 204, .external_lex_state = 6},
  [1029] = {.lex_state = 204, .external_lex_state = 6},
  [1030] = {.lex_state = 204, .external_lex_state = 6},
  [1031] = {.lex_state = 204, .external_lex_state = 6},
  [1032] = {.lex_state = 204, .external_lex_state = 6},
  [1033] = {.lex_state = 204, .external_lex_state = 6},
  [1034] = {.lex_state = 204, .external_lex_state = 6},
  [1035] = {.lex_state = 204, .external_lex_state = 6},
  [1036] = {.lex_state = 204, .external_lex_state = 6},
  [1037] = {.lex_state = 204, .external_lex_state = 6},
  [1038] = {.lex_state = 204, .external_lex_state = 6},
  [1039] = {.lex_state = 204, .external_lex_state = 6},
  [1040] = {.lex_state = 204, .external_lex_state = 6},
  [1041] = {.lex_state = 204, .external_lex_state = 6},
  [1042] = {.lex_state = 204, .external_lex_state = 6},
  [1043] = {.lex_state = 204, .external_lex_state = 6},
  [1044] = {.lex_state = 204, .external_lex_state = 6},
  [1045] = {.lex_state = 204, .external_lex_state = 6},
  [1046] = {.lex_state = 204, .external_lex_state = 6},
  [1047] = {.lex_state = 204, .external_lex_state = 6},
  [1048] = {.lex_state = 204, .external_lex_state = 6},
  [1049] = {.lex_state = 204, .external_lex_state = 6},
  [1050] = {.lex_state = 204, .external_lex_state = 6},
  [1051] = {.lex_state = 204, .external_lex_state = 6},
  [1052] = {.lex_state = 204, .external_lex_state = 6},
  [1053] = {.lex_state = 204, .external_lex_state = 6},
  [1054] = {.lex_state = 204, .external_lex_state = 6},
  [1055] = {.lex_state = 204, .external_lex_state = 6},
  [1056] = {.lex_state = 204, .external_lex_state = 6},
  [1057] = {.lex_state = 204, .external_lex_state = 6},
  [1058] = {.lex_state = 204, .external_lex_state = 6},
  [1059] = {.lex_state = 204, .external_lex_state = 6},
  [1060] = {.lex_state = 204},
  [1061] = {.lex_state = 204},
  [1062] = {.lex_state = 204},
  [1063] = {.lex_state = 204},
  [1064] = {.lex_state = 204},
  [1065] = {.lex_state = 204},
  [1066] = {.lex_state = 204},
  [1067] = {.lex_state = 204},
  [1068] = {.lex_state = 204},
  [1069] = {.lex_state = 204},
  [1070] = {.lex_state = 204},
  [1071] = {.lex_state = 204},
  [1072] = {.lex_state = 204},
  [1073] = {.lex_state = 204},
  [1074] = {.lex_state = 204},
  [1075] = {.lex_state = 204},
  [1076] = {.lex_state = 204},
  [1077] = {.lex_state = 204},
  [1078] = {.lex_state = 204},
  [1079] = {.lex_state = 204},
  [1080] = {.lex_state = 204},
  [1081] = {.lex_state = 204},
  [1082] = {.lex_state = 204},
  [1083] = {.lex_state = 204},
  [1084] = {.lex_state = 204},
  [1085] = {.lex_state = 204},
  [1086] = {.lex_state = 204},
  [1087] = {.lex_state = 204},
  [1088] = {.lex_state = 204},
  [1089] = {.lex_state = 204},
  [1090] = {.lex_state = 204},
  [1091] = {.lex_state = 204},
  [1092] = {.lex_state = 204},
  [1093] = {.lex_state = 204},
  [1094] = {.lex_state = 204},
  [1095] = {.lex_state = 204},
  [1096] = {.lex_state = 204},
  [1097] = {.lex_state = 204},
  [1098] = {.lex_state = 204},
  [1099] = {.lex_state = 204},
  [1100] = {.lex_state = 204},
  [1101] = {.lex_state = 204},
  [1102] = {.lex_state = 204},
  [1103] = {.lex_state = 204},
  [1104] = {.lex_state = 204},
  [1105] = {.lex_state = 205},
  [1106] = {.lex_state = 205},
  [1107] = {.lex_state = 205},
  [1108] = {.lex_state = 205},
  [1109] = {.lex_state = 205},
  [1110] = {.lex_state = 205},
  [1111] = {.lex_state = 205},
  [1112] = {.lex_state = 205},
  [1113] = {.lex_state = 205},
  [1114] = {.lex_state = 205},
  [1115] = {.lex_state = 205},
  [1116] = {.lex_state = 205},
  [1117] = {.lex_state = 205},
  [1118] = {.lex_state = 205},
  [1119] = {.lex_state = 205},
  [1120] = {.lex_state = 205},
  [1121] = {.lex_state = 205},
  [1122] = {.lex_state = 205},
  [1123] = {.lex_state = 205},
  [1124] = {.lex_state = 205},
  [1125] = {.lex_state = 205},
  [1126] = {.lex_state = 205},
  [1127] = {.lex_state = 205},
  [1128] = {.lex_state = 205},
  [1129] = {.lex_state = 205},
  [1130] = {.lex_state = 205},
  [1131] = {.lex_state = 205},
  [1132] = {.lex_state = 205},
  [1133] = {.lex_state = 205},
  [1134] = {.lex_state = 205},
  [1135] = {.lex_state = 205},
  [1136] = {.lex_state = 205},
  [1137] = {.lex_state = 205},
  [1138] = {.lex_state = 205},
  [1139] = {.lex_state = 205},
  [1140] = {.lex_state = 205},
  [1141] = {.lex_state = 205},
  [1142] = {.lex_state = 205},
  [1143] = {.lex_state = 205},
  [1144] = {.lex_state = 205},
  [1145] = {.lex_state = 205},
  [1146] = {.lex_state = 205},
  [1147] = {.lex_state = 205},
  [1148] = {.lex_state = 205},
  [1149] = {.lex_state = 205},
  [1150] = {.lex_state = 205},
  [1151] = {.lex_state = 205},
  [1152] = {.lex_state = 206},
  [1153] = {.lex_state = 206},
  [1154] = {.lex_state = 206},
  [1155] = {.lex_state = 207},
  [1156] = {.lex_state = 206},
  [1157] = {.lex_state = 206},
  [1158] = {.lex_state = 206},
  [1159] = {.lex_state = 207},
  [1160] = {.lex_state = 206},
  [1161] = {.lex_state = 206},
  [1162] = {.lex_state = 206},
  [1163] = {.lex_state = 207},
  [1164] = {.lex_state = 206},
  [1165] = {.lex_state = 206},
  [1166] = {.lex_state = 206},
  [1167] = {.lex_state = 206},
  [1168] = {.lex_state = 206},
  [1169] = {.lex_state = 207},
  [1170] = {.lex_state = 206},
  [1171] = {.lex_state = 206},
  [1172] = {.lex_state = 207},
  [1173] = {.lex_state = 206},
  [1174] = {.lex_state = 206},
  [1175] = {.lex_state = 206},
  [1176] = {.lex_state = 206},
  [1177] = {.lex_state = 206},
  [1178] = {.lex_state = 206},
  [1179] = {.lex_state = 206},
  [1180] = {.lex_state = 206},
  [1181] = {.lex_state = 206},
  [1182] = {.lex_state = 206},
  [1183] = {.lex_state = 206},
  [1184] = {.lex_state = 206},
  [1185] = {.lex_state = 206},
  [1186] = {.lex_state = 206},
  [1187] = {.lex_state = 207},
  [1188] = {.lex_state = 207},
  [1189] = {.lex_state = 207},
  [1190] = {.lex_state = 207},
  [1191] = {.lex_state = 207},
  [1192] = {.lex_state = 207},
  [1193] = {.lex_state = 207},
  [1194] = {.lex_state = 207},
  [1195] = {.lex_state = 207},
  [1196] = {.lex_state = 207},
  [1197] = {.lex_state = 207},
  [1198] = {.lex_state = 207},
  [1199] = {.lex_state = 207},
  [1200] = {.lex_state = 207},
  [1201] = {.lex_state = 207},
  [1202] = {.lex_state = 208},
  [1203] = {.lex_state = 208},
  [1204] = {.lex_state = 208},
  [1205] = {.lex_state = 208},
  [1206] = {.lex_state = 208},
  [1207] = {.lex_state = 208},
  [1208] = {.lex_state = 208},
  [1209] = {.lex_state = 208},
  [1210] = {.lex_state = 208},
  [1211] = {.lex_state = 208},
  [1212] = {.lex_state = 208},
  [1213] = {.lex_state = 208},
  [1214] = {.lex_state = 208},
  [1215] = {.lex_state = 208},
  [1216] = {.lex_state = 208},
  [1217] = {.lex_state = 208},
  [1218] = {.lex_state = 208},
  [1219] = {.lex_state = 208},
  [1220] = {.lex_state = 208},
  [1221] = {.lex_state = 208},
  [1222] = {.lex_state = 208},
  [1223] = {.lex_state = 208},
  [1224] = {.lex_state = 208},
  [1225] = {.lex_state = 208},
  [1226] = {.lex_state = 208},
  [1227] = {.lex_state = 208},
  [1228] = {.lex_state = 208},
  [1229] = {.lex_state = 208},
  [1230] = {.lex_state = 208},
  [1231] = {.lex_state = 208},
  [1232] = {.lex_state = 208},
  [1233] = {.lex_state = 208},
  [1234] = {.lex_state = 208},
  [1235] = {.lex_state = 208},
  [1236] = {.lex_state = 208},
  [1237] = {.lex_state = 208},
  [1238] = {.lex_state = 208},
  [1239] = {.lex_state = 208},
  [1240] = {.lex_state = 208},
  [1241] = {.lex_state = 208},
  [1242] = {.lex_state = 208},
  [1243] = {.lex_state = 208},
  [1244] = {.lex_state = 208},
  [1245] = {.lex_state = 208},
  [1246] = {.lex_state = 208},
  [1247] = {.lex_state = 208},
  [1248] = {.lex_state = 208},
  [1249] = {.lex_state = 208},
  [1250] = {.lex_state = 208},
  [1251] = {.lex_state = 208},
  [1252] = {.lex_state = 208},
  [1253] = {.lex_state = 208},
  [1254] = {.lex_state = 208},
  [1255] = {.lex_state = 208},
  [1256] = {.lex_state = 208},
  [1257] = {.lex_state = 208},
  [1258] = {.lex_state = 208},
  [1259] = {.lex_state = 208},
  [1260] = {.lex_state = 208},
  [1261] = {.lex_state = 208},
  [1262] = {.lex_state = 208},
  [1263] = {.lex_state = 208},
  [1264] = {.lex_state = 208},
  [1265] = {.lex_state = 208},
  [1266] = {.lex_state = 208},
  [1267] = {.lex_state = 208},
  [1268] = {.lex_state = 208},
  [1269] = {.lex_state = 208},
  [1270] = {.lex_state = 208},
  [1271] = {.lex_state = 208},
  [1272] = {.lex_state = 208},
  [1273] = {.lex_state = 208},
  [1274] = {.lex_state = 208},
  [1275] = {.lex_state = 208},
  [1276] = {.lex_state = 208, .external_lex_state = 7},
  [1277] = {.lex_state = 208},
  [1278] = {.lex_state = 208, .external_lex_state = 7},
  [1279] = {.lex_state = 208, .external_lex_state = 7},
  [1280] = {.lex_state = 208, .external_lex_state = 7},
  [1281] = {.lex_state = 208, .external_lex_state = 7},
  [1282] = {.lex_state = 208, .external_lex_state = 7},
  [1283] = {.lex_state = 208, .external_lex_state = 7},
  [1284] = {.lex_state = 208},
  [1285] = {.lex_state = 208, .external_lex_state = 7},
  [1286] = {.lex_state = 208, .external_lex_state = 7},
  [1287] = {.lex_state = 208, .external_lex_state = 7},
  [1288] = {.lex_state = 208, .external_lex_state = 7},
  [1289] = {.lex_state = 208, .external_lex_state = 7},
  [1290] = {.lex_state = 208, .external_lex_state = 7},
  [1291] = {.lex_state = 208, .external_lex_state = 7},
  [1292] = {.lex_state = 208, .external_lex_state = 7},
  [1293] = {.lex_state = 208, .external_lex_state = 7},
  [1294] = {.lex_state = 208, .external_lex_state = 7},
  [1295] = {.lex_state = 208, .external_lex_state = 7},
  [1296] = {.lex_state = 208, .external_lex_state = 7},
  [1297] = {.lex_state = 208},
  [1298] = {.lex_state = 208},
  [1299] = {.lex_state = 208, .external_lex_state = 7},
  [1300] = {.lex_state = 208, .external_lex_state = 7},
  [1301] = {.lex_state = 208, .external_lex_state = 7},
  [1302] = {.lex_state = 208},
  [1303] = {.lex_state = 208, .external_lex_state = 7},
  [1304] = {.lex_state = 208, .external_lex_state = 7},
  [1305] = {.lex_state = 208, .external_lex_state = 7},
  [1306] = {.lex_state = 208, .external_lex_state = 7},
  [1307] = {.lex_state = 208, .external_lex_state = 7},
  [1308] = {.lex_state = 208, .external_lex_state = 7},
  [1309] = {.lex_state = 208, .external_lex_state = 7},
  [1310] = {.lex_state = 208, .external_lex_state = 7},
  [1311] = {.lex_state = 208, .external_lex_state = 7},
  [1312] = {.lex_state = 208},
  [1313] = {.lex_state = 208, .external_lex_state = 7},
  [1314] = {.lex_state = 208, .external_lex_state = 7},
  [1315] = {.lex_state = 208},
  [1316] = {.lex_state = 208},
  [1317] = {.lex_state = 208, .external_lex_state = 7},
  [1318] = {.lex_state = 208, .external_lex_state = 7},
  [1319] = {.lex_state = 208, .external_lex_state = 7},
  [1320] = {.lex_state = 208, .external_lex_state = 7},
  [1321] = {.lex_state = 208, .external_lex_state = 7},
  [1322] = {.lex_state = 208, .external_lex_state = 7},
  [1323] = {.lex_state = 208, .external_lex_state = 7},
  [1324] = {.lex_state = 208, .external_lex_state = 7},
  [1325] = {.lex_state = 209, .external_lex_state = 8},
  [1326] = {.lex_state = 209, .external_lex_state = 8},
  [1327] = {.lex_state = 209, .external_lex_state = 8},
  [1328] = {.lex_state = 209, .external_lex_state = 8},
  [1329] = {.lex_state = 209, .external_lex_state = 8},
  [1330] = {.lex_state = 209, .external_lex_state = 8},
  [1331] = {.lex_state = 209, .external_lex_state = 8},
  [1332] = {.lex_state = 209, .external_lex_state = 8},
  [1333] = {.lex_state = 209, .external_lex_state = 8},
  [1334] = {.lex_state = 209, .external_lex_state = 8},
  [1335] = {.lex_state = 209, .external_lex_state = 8},
  [1336] = {.lex_state = 209, .external_lex_state = 8},
  [1337] = {.lex_state = 209, .external_lex_state = 8},
  [1338] = {.lex_state = 209, .external_lex_state = 8},
  [1339] = {.lex_state = 209, .external_lex_state = 8},
  [1340] = {.lex_state = 209, .external_lex_state = 8},
  [1341] = {.lex_state = 209, .external_lex_state = 8},
  [1342] = {.lex_state = 209, .external_lex_state = 8},
  [1343] = {.lex_state = 209, .external_lex_state = 8},
  [1344] = {.lex_state = 209, .external_lex_state = 8},
  [1345] = {.lex_state = 209, .external_lex_state = 8},
  [1346] = {.lex_state = 209, .external_lex_state = 8},
  [1347] = {.lex_state = 209, .external_lex_state = 8},
  [1348] = {.lex_state = 209, .external_lex_state = 8},
  [1349] = {.lex_state = 209, .external_lex_state = 8},
  [1350] = {.lex_state = 209, .external_lex_state = 8},
  [1351] = {.lex_state = 209, .external_lex_state = 8},
  [1352] = {.lex_state = 209, .external_lex_state = 8},
  [1353] = {.lex_state = 209, .external_lex_state = 8},
  [1354] = {.lex_state = 209, .external_lex_state = 8},
  [1355] = {.lex_state = 209, .external_lex_state = 8},
  [1356] = {.lex_state = 211},
  [1357] = {.lex_state = 211},
  [1358] = {.lex_state = 211},
  [1359] = {.lex_state = 211},
  [1360] = {.lex_state = 211},
  [1361] = {.lex_state = 211},
  [1362] = {.lex_state = 211},
  [1363] = {.lex_state = 211},
  [1364] = {.lex_state = 213, .external_lex_state = 8},
  [1365] = {.lex_state = 211},
  [1366] = {.lex_state = 211},
  [1367] = {.lex_state = 211},
  [1368] = {.lex_state = 211},
  [1369] = {.lex_state = 211},
  [1370] = {.lex_state = 211},
  [1371] = {.lex_state = 211},
  [1372] = {.lex_state = 211},
  [1373] = {.lex_state = 211},
  [1374] = {.lex_state = 211},
  [1375] = {.lex_state = 211},
  [1376] = {.lex_state = 211},
  [1377] = {.lex_state = 211},
  [1378] = {.lex_state = 211},
  [1379] = {.lex_state = 211},
  [1380] = {.lex_state = 211},
  [1381] = {.lex_state = 211},
  [1382] = {.lex_state = 211},
  [1383] = {.lex_state = 211},
  [1384] = {.lex_state = 211},
  [1385] = {.lex_state = 211},
  [1386] = {.lex_state = 211},
  [1387] = {.lex_state = 211},
  [1388] = {.lex_state = 211},
  [1389] = {.lex_state = 211},
  [1390] = {.lex_state = 206},
  [1391] = {.lex_state = 211},
  [1392] = {.lex_state = 211},
  [1393] = {.lex_state = 211},
  [1394] = {.lex_state = 211},
  [1395] = {.lex_state = 211},
  [1396] = {.lex_state = 211},
  [1397] = {.lex_state = 206, .external_lex_state = 8},
  [1398] = {.lex_state = 211},
  [1399] = {.lex_state = 206, .external_lex_state = 8},
  [1400] = {.lex_state = 211},
  [1401] = {.lex_state = 206, .external_lex_state = 8},
  [1402] = {.lex_state = 211},
  [1403] = {.lex_state = 211},
  [1404] = {.lex_state = 211},
  [1405] = {.lex_state = 211},
  [1406] = {.lex_state = 211},
  [1407] = {.lex_state = 206, .external_lex_state = 8},
  [1408] = {.lex_state = 206, .external_lex_state = 8},
  [1409] = {.lex_state = 206, .external_lex_state = 8},
  [1410] = {.lex_state = 206, .external_lex_state = 8},
  [1411] = {.lex_state = 206, .external_lex_state = 8},
  [1412] = {.lex_state = 206, .external_lex_state = 8},
  [1413] = {.lex_state = 206, .external_lex_state = 8},
  [1414] = {.lex_state = 206, .external_lex_state = 8},
  [1415] = {.lex_state = 206, .external_lex_state = 8},
  [1416] = {.lex_state = 206, .external_lex_state = 8},
  [1417] = {.lex_state = 206, .external_lex_state = 8},
  [1418] = {.lex_state = 206, .external_lex_state = 8},
  [1419] = {.lex_state = 206, .external_lex_state = 8},
  [1420] = {.lex_state = 206, .external_lex_state = 8},
  [1421] = {.lex_state = 206, .external_lex_state = 8},
  [1422] = {.lex_state = 206, .external_lex_state = 8},
  [1423] = {.lex_state = 206, .external_lex_state = 8},
  [1424] = {.lex_state = 206, .external_lex_state = 8},
  [1425] = {.lex_state = 206, .external_lex_state = 8},
  [1426] = {.lex_state = 206, .external_lex_state = 8},
  [1427] = {.lex_state = 206, .external_lex_state = 8},
  [1428] = {.lex_state = 206, .external_lex_state = 8},
  [1429] = {.lex_state = 206, .external_lex_state = 8},
  [1430] = {.lex_state = 206, .external_lex_state = 8},
  [1431] = {.lex_state = 206, .external_lex_state = 8},
  [1432] = {.lex_state = 206, .external_lex_state = 8},
  [1433] = {.lex_state = 206, .external_lex_state = 8},
  [1434] = {.lex_state = 206, .external_lex_state = 8},
  [1435] = {.lex_state = 206, .external_lex_state = 8},
  [1436] = {.lex_state = 206, .external_lex_state = 8},
  [1437] = {.lex_state = 209},
  [1438] = {.lex_state = 209},
  [1439] = {.lex_state = 214},
  [1440] = {.lex_state = 214},
  [1441] = {.lex_state = 214},
  [1442] = {.lex_state = 214},
  [1443] = {.lex_state = 214},
  [1444] = {.lex_state = 214},
  [1445] = {.lex_state = 214},
  [1446] = {.lex_state = 214},
  [1447] = {.lex_state = 214},
  [1448] = {.lex_state = 209},
  [1449] = {.lex_state = 209},
  [1450] = {.lex_state = 209},
  [1451] = {.lex_state = 209},
  [1452] = {.lex_state = 209},
  [1453] = {.lex_state = 209},
  [1454] = {.lex_state = 209},
  [1455] = {.lex_state = 209},
  [1456] = {.lex_state = 209},
  [1457] = {.lex_state = 209},
  [1458] = {.lex_state = 209},
  [1459] = {.lex_state = 214},
  [1460] = {.lex_state = 209},
  [1461] = {.lex_state = 209},
  [1462] = {.lex_state = 209},
  [1463] = {.lex_state = 209},
  [1464] = {.lex_state = 209},
  [1465] = {.lex_state = 214},
  [1466] = {.lex_state = 209},
  [1467] = {.lex_state = 209},
  [1468] = {.lex_state = 209},
  [1469] = {.lex_state = 214},
  [1470] = {.lex_state = 214},
  [1471] = {.lex_state = 209},
  [1472] = {.lex_state = 209},
  [1473] = {.lex_state = 209},
  [1474] = {.lex_state = 209},
  [1475] = {.lex_state = 209},
  [1476] = {.lex_state = 214},
  [1477] = {.lex_state = 209},
  [1478] = {.lex_state = 209},
  [1479] = {.lex_state = 209},
  [1480] = {.lex_state = 214},
  [1481] = {.lex_state = 209},
  [1482] = {.lex_state = 206},
  [1483] = {.lex_state = 214},
  [1484] = {.lex_state = 206, .external_lex_state = 7},
  [1485] = {.lex_state = 206, .external_lex_state = 7},
  [1486] = {.lex_state = 216},
  [1487] = {.lex_state = 214},
  [1488] = {.lex_state = 209},
  [1489] = {.lex_state = 209},
  [1490] = {.lex_state = 209},
  [1491] = {.lex_state = 209},
  [1492] = {.lex_state = 206, .external_lex_state = 7},
  [1493] = {.lex_state = 209},
  [1494] = {.lex_state = 216},
  [1495] = {.lex_state = 209},
  [1496] = {.lex_state = 214},
  [1497] = {.lex_state = 216},
  [1498] = {.lex_state = 216},
  [1499] = {.lex_state = 216},
  [1500] = {.lex_state = 216},
  [1501] = {.lex_state = 216},
  [1502] = {.lex_state = 216},
  [1503] = {.lex_state = 209},
  [1504] = {.lex_state = 206},
  [1505] = {.lex_state = 206},
  [1506] = {.lex_state = 206},
  [1507] = {.lex_state = 209},
  [1508] = {.lex_state = 209},
  [1509] = {.lex_state = 206},
  [1510] = {.lex_state = 216},
  [1511] = {.lex_state = 216},
  [1512] = {.lex_state = 209},
  [1513] = {.lex_state = 209},
  [1514] = {.lex_state = 214},
  [1515] = {.lex_state = 216},
  [1516] = {.lex_state = 216},
  [1517] = {.lex_state = 216},
  [1518] = {.lex_state = 209},
  [1519] = {.lex_state = 214},
  [1520] = {.lex_state = 216},
  [1521] = {.lex_state = 214},
  [1522] = {.lex_state = 209},
  [1523] = {.lex_state = 209},
  [1524] = {.lex_state = 214},
  [1525] = {.lex_state = 216},
  [1526] = {.lex_state = 216},
  [1527] = {.lex_state = 209},
  [1528] = {.lex_state = 216},
  [1529] = {.lex_state = 216},
  [1530] = {.lex_state = 216},
  [1531] = {.lex_state = 214},
  [1532] = {.lex_state = 216},
  [1533] = {.lex_state = 216},
  [1534] = {.lex_state = 216},
  [1535] = {.lex_state = 216},
  [1536] = {.lex_state = 206, .external_lex_state = 7},
  [1537] = {.lex_state = 214},
  [1538] = {.lex_state = 216},
  [1539] = {.lex_state = 216},
  [1540] = {.lex_state = 216},
  [1541] = {.lex_state = 216},
  [1542] = {.lex_state = 216},
  [1543] = {.lex_state = 216},
  [1544] = {.lex_state = 206, .external_lex_state = 7},
  [1545] = {.lex_state = 206, .external_lex_state = 7},
  [1546] = {.lex_state = 206, .external_lex_state = 7},
  [1547] = {.lex_state = 217},
  [1548] = {.lex_state = 206, .external_lex_state = 7},
  [1549] = {.lex_state = 217},
  [1550] = {.lex_state = 214},
  [1551] = {.lex_state = 206, .external_lex_state = 7},
  [1552] = {.lex_state = 206, .external_lex_state = 7},
  [1553] = {.lex_state = 206, .external_lex_state = 7},
  [1554] = {.lex_state = 206, .external_lex_state = 7},
  [1555] = {.lex_state = 206, .external_lex_state = 7},
  [1556] = {.lex_state = 206, .external_lex_state = 7},
  [1557] = {.lex_state = 206, .external_lex_state = 7},
  [1558] = {.lex_state = 206, .external_lex_state = 7},
  [1559] = {.lex_state = 206, .external_lex_state = 7},
  [1560] = {.lex_state = 206, .external_lex_state = 7},
  [1561] = {.lex_state = 206, .external_lex_state = 7},
  [1562] = {.lex_state = 206, .external_lex_state = 7},
  [1563] = {.lex_state = 206, .external_lex_state = 7},
  [1564] = {.lex_state = 206, .external_lex_state = 7},
  [1565] = {.lex_state = 206, .external_lex_state = 8},
  [1566] = {.lex_state = 216},
  [1567] = {.lex_state = 206, .external_lex_state = 7},
  [1568] = {.lex_state = 206, .external_lex_state = 7},
  [1569] = {.lex_state = 206, .external_lex_state = 7},
  [1570] = {.lex_state = 217},
  [1571] = {.lex_state = 206, .external_lex_state = 7},
  [1572] = {.lex_state = 217},
  [1573] = {.lex_state = 209},
  [1574] = {.lex_state = 217},
  [1575] = {.lex_state = 217},
  [1576] = {.lex_state = 217},
  [1577] = {.lex_state = 217},
  [1578] = {.lex_state = 206, .external_lex_state = 7},
  [1579] = {.lex_state = 217},
  [1580] = {.lex_state = 206, .external_lex_state = 8},
  [1581] = {.lex_state = 206, .external_lex_state = 7},
  [1582] = {.lex_state = 217},
  [1583] = {.lex_state = 217},
  [1584] = {.lex_state = 206, .external_lex_state = 7},
  [1585] = {.lex_state = 217},
  [1586] = {.lex_state = 217},
  [1587] = {.lex_state = 206, .external_lex_state = 7},
  [1588] = {.lex_state = 217},
  [1589] = {.lex_state = 214},
  [1590] = {.lex_state = 217},
  [1591] = {.lex_state = 217},
  [1592] = {.lex_state = 217},
  [1593] = {.lex_state = 217},
  [1594] = {.lex_state = 217},
  [1595] = {.lex_state = 217},
  [1596] = {.lex_state = 217},
  [1597] = {.lex_state = 217},
  [1598] = {.lex_state = 217},
  [1599] = {.lex_state = 217},
  [1600] = {.lex_state = 217},
  [1601] = {.lex_state = 217},
  [1602] = {.lex_state = 217},
  [1603] = {.lex_state = 217},
  [1604] = {.lex_state = 217},
  [1605] = {.lex_state = 217},
  [1606] = {.lex_state = 206},
  [1607] = {.lex_state = 206, .external_lex_state = 7},
  [1608] = {.lex_state = 206},
  [1609] = {.lex_state = 206},
  [1610] = {.lex_state = 206},
  [1611] = {.lex_state = 206, .external_lex_state = 9},
  [1612] = {.lex_state = 206, .external_lex_state = 9},
  [1613] = {.lex_state = 206},
  [1614] = {.lex_state = 209},
  [1615] = {.lex_state = 206},
  [1616] = {.lex_state = 209},
  [1617] = {.lex_state = 206},
  [1618] = {.lex_state = 209},
  [1619] = {.lex_state = 206, .external_lex_state = 10},
  [1620] = {.lex_state = 206, .external_lex_state = 10},
  [1621] = {.lex_state = 206, .external_lex_state = 10},
  [1622] = {.lex_state = 206, .external_lex_state = 10},
  [1623] = {.lex_state = 206, .external_lex_state = 10},
  [1624] = {.lex_state = 206, .external_lex_state = 10},
  [1625] = {.lex_state = 206, .external_lex_state = 10},
  [1626] = {.lex_state = 206, .external_lex_state = 10},
  [1627] = {.lex_state = 206, .external_lex_state = 10},
  [1628] = {.lex_state = 209},
  [1629] = {.lex_state = 206},
  [1630] = {.lex_state = 206},
  [1631] = {.lex_state = 206, .external_lex_state = 10},
  [1632] = {.lex_state = 206, .external_lex_state = 10},
  [1633] = {.lex_state = 206, .external_lex_state = 10},
  [1634] = {.lex_state = 209},
  [1635] = {.lex_state = 206},
  [1636] = {.lex_state = 209},
  [1637] = {.lex_state = 206, .external_lex_state = 9},
  [1638] = {.lex_state = 206, .external_lex_state = 9},
  [1639] = {.lex_state = 206, .external_lex_state = 9},
  [1640] = {.lex_state = 206, .external_lex_state = 10},
  [1641] = {.lex_state = 206, .external_lex_state = 9},
  [1642] = {.lex_state = 206, .external_lex_state = 10},
  [1643] = {.lex_state = 206, .external_lex_state = 9},
  [1644] = {.lex_state = 206, .external_lex_state = 9},
  [1645] = {.lex_state = 206, .external_lex_state = 9},
  [1646] = {.lex_state = 206, .external_lex_state = 9},
  [1647] = {.lex_state = 206, .external_lex_state = 9},
  [1648] = {.lex_state = 206, .external_lex_state = 9},
  [1649] = {.lex_state = 206, .external_lex_state = 9},
  [1650] = {.lex_state = 206, .external_lex_state = 9},
  [1651] = {.lex_state = 206, .external_lex_state = 9},
  [1652] = {.lex_state = 206},
  [1653] = {.lex_state = 206, .external_lex_state = 9},
  [1654] = {.lex_state = 206, .external_lex_state = 10},
  [1655] = {.lex_state = 206, .external_lex_state = 9},
  [1656] = {.lex_state = 206, .external_lex_state = 10},
  [1657] = {.lex_state = 206, .external_lex_state = 10},
  [1658] = {.lex_state = 206},
  [1659] = {.lex_state = 206, .external_lex_state = 10},
  [1660] = {.lex_state = 206},
  [1661] = {.lex_state = 206},
  [1662] = {.lex_state = 209},
  [1663] = {.lex_state = 206, .external_lex_state = 9},
  [1664] = {.lex_state = 206, .external_lex_state = 9},
  [1665] = {.lex_state = 206, .external_lex_state = 9},
  [1666] = {.lex_state = 206, .external_lex_state = 9},
  [1667] = {.lex_state = 206, .external_lex_state = 9},
  [1668] = {.lex_state = 206},
  [1669] = {.lex_state = 206},
  [1670] = {.lex_state = 206},
  [1671] = {.lex_state = 206, .external_lex_state = 9},
  [1672] = {.lex_state = 206, .external_lex_state = 9},
  [1673] = {.lex_state = 209},
  [1674] = {.lex_state = 206, .external_lex_state = 10},
  [1675] = {.lex_state = 206, .external_lex_state = 9},
  [1676] = {.lex_state = 206},
  [1677] = {.lex_state = 209},
  [1678] = {.lex_state = 209},
  [1679] = {.lex_state = 206},
  [1680] = {.lex_state = 206, .external_lex_state = 9},
  [1681] = {.lex_state = 206, .external_lex_state = 9},
  [1682] = {.lex_state = 206, .external_lex_state = 9},
  [1683] = {.lex_state = 206},
  [1684] = {.lex_state = 206, .external_lex_state = 10},
  [1685] = {.lex_state = 206},
  [1686] = {.lex_state = 206, .external_lex_state = 9},
  [1687] = {.lex_state = 206, .external_lex_state = 9},
  [1688] = {.lex_state = 206},
  [1689] = {.lex_state = 206},
  [1690] = {.lex_state = 209},
  [1691] = {.lex_state = 209},
  [1692] = {.lex_state = 209},
  [1693] = {.lex_state = 209},
  [1694] = {.lex_state = 206, .external_lex_state = 10},
  [1695] = {.lex_state = 206, .external_lex_state = 7},
  [1696] = {.lex_state = 217},
  [1697] = {.lex_state = 209},
  [1698] = {.lex_state = 216},
  [1699] = {.lex_state = 217},
  [1700] = {.lex_state = 206, .external_lex_state = 10},
  [1701] = {.lex_state = 206, .external_lex_state = 10},
  [1702] = {.lex_state = 206, .external_lex_state = 10},
  [1703] = {.lex_state = 206, .external_lex_state = 10},
  [1704] = {.lex_state = 206, .external_lex_state = 10},
  [1705] = {.lex_state = 206},
  [1706] = {.lex_state = 206, .external_lex_state = 10},
  [1707] = {.lex_state = 206, .external_lex_state = 10},
  [1708] = {.lex_state = 206, .external_lex_state = 10},
  [1709] = {.lex_state = 206, .external_lex_state = 10},
  [1710] = {.lex_state = 206},
  [1711] = {.lex_state = 206},
  [1712] = {.lex_state = 206},
  [1713] = {.lex_state = 206},
  [1714] = {.lex_state = 206},
  [1715] = {.lex_state = 206},
  [1716] = {.lex_state = 206},
  [1717] = {.lex_state = 206},
  [1718] = {.lex_state = 206},
  [1719] = {.lex_state = 206},
  [1720] = {.lex_state = 206},
  [1721] = {.lex_state = 206},
  [1722] = {.lex_state = 206},
  [1723] = {.lex_state = 206},
  [1724] = {.lex_state = 206},
  [1725] = {.lex_state = 206},
  [1726] = {.lex_state = 206},
  [1727] = {.lex_state = 206},
  [1728] = {.lex_state = 206},
  [1729] = {.lex_state = 206},
  [1730] = {.lex_state = 206},
  [1731] = {.lex_state = 206},
  [1732] = {.lex_state = 206},
  [1733] = {.lex_state = 206},
  [1734] = {.lex_state = 206},
  [1735] = {.lex_state = 206},
  [1736] = {.lex_state = 206},
  [1737] = {.lex_state = 206},
  [1738] = {.lex_state = 206},
  [1739] = {.lex_state = 206},
  [1740] = {.lex_state = 206},
  [1741] = {.lex_state = 206},
  [1742] = {.lex_state = 206},
  [1743] = {.lex_state = 206},
  [1744] = {.lex_state = 206},
  [1745] = {.lex_state = 206},
  [1746] = {.lex_state = 206},
  [1747] = {.lex_state = 206},
  [1748] = {.lex_state = 206},
  [1749] = {.lex_state = 206},
  [1750] = {.lex_state = 206},
  [1751] = {.lex_state = 206},
  [1752] = {.lex_state = 206},
  [1753] = {.lex_state = 206},
  [1754] = {.lex_state = 206},
  [1755] = {.lex_state = 206},
  [1756] = {.lex_state = 206},
  [1757] = {.lex_state = 206},
  [1758] = {.lex_state = 206},
  [1759] = {.lex_state = 206},
  [1760] = {.lex_state = 206},
  [1761] = {.lex_state = 206, .external_lex_state = 7},
  [1762] = {.lex_state = 206},
  [1763] = {.lex_state = 206},
  [1764] = {.lex_state = 206},
  [1765] = {.lex_state = 206},
  [1766] = {.lex_state = 206},
  [1767] = {.lex_state = 206},
  [1768] = {.lex_state = 206},
  [1769] = {.lex_state = 206},
  [1770] = {.lex_state = 206},
  [1771] = {.lex_state = 206},
  [1772] = {.lex_state = 206},
  [1773] = {.lex_state = 206},
  [1774] = {.lex_state = 206},
  [1775] = {.lex_state = 206},
  [1776] = {.lex_state = 206},
  [1777] = {.lex_state = 206},
  [1778] = {.lex_state = 206},
  [1779] = {.lex_state = 206},
  [1780] = {.lex_state = 206},
  [1781] = {.lex_state = 206},
  [1782] = {.lex_state = 206},
  [1783] = {.lex_state = 206, .external_lex_state = 7},
  [1784] = {.lex_state = 206, .external_lex_state = 9},
  [1785] = {.lex_state = 206, .external_lex_state = 10},
  [1786] = {.lex_state = 206, .external_lex_state = 7},
  [1787] = {.lex_state = 206, .external_lex_state = 7},
  [1788] = {.lex_state = 206, .external_lex_state = 7},
  [1789] = {.lex_state = 206},
  [1790] = {.lex_state = 206},
  [1791] = {.lex_state = 206},
  [1792] = {.lex_state = 206},
  [1793] = {.lex_state = 206, .external_lex_state = 7},
  [1794] = {.lex_state = 206},
  [1795] = {.lex_state = 206},
  [1796] = {.lex_state = 206},
  [1797] = {.lex_state = 206},
  [1798] = {.lex_state = 206, .external_lex_state = 7},
  [1799] = {.lex_state = 206},
  [1800] = {.lex_state = 206},
  [1801] = {.lex_state = 206},
  [1802] = {.lex_state = 206},
  [1803] = {.lex_state = 206},
  [1804] = {.lex_state = 206},
  [1805] = {.lex_state = 206},
  [1806] = {.lex_state = 206},
  [1807] = {.lex_state = 206},
  [1808] = {.lex_state = 206},
  [1809] = {.lex_state = 206},
  [1810] = {.lex_state = 206},
  [1811] = {.lex_state = 206},
  [1812] = {.lex_state = 206},
  [1813] = {.lex_state = 206},
  [1814] = {.lex_state = 206},
  [1815] = {.lex_state = 206},
  [1816] = {.lex_state = 206},
  [1817] = {.lex_state = 206},
  [1818] = {.lex_state = 206},
  [1819] = {.lex_state = 206},
  [1820] = {.lex_state = 206},
  [1821] = {.lex_state = 206},
  [1822] = {.lex_state = 206},
  [1823] = {.lex_state = 206},
  [1824] = {.lex_state = 206},
  [1825] = {.lex_state = 206},
  [1826] = {.lex_state = 206},
  [1827] = {.lex_state = 206},
  [1828] = {.lex_state = 206},
  [1829] = {.lex_state = 206},
  [1830] = {.lex_state = 206},
  [1831] = {.lex_state = 206},
  [1832] = {.lex_state = 206},
  [1833] = {.lex_state = 206},
  [1834] = {.lex_state = 206},
  [1835] = {.lex_state = 206},
  [1836] = {.lex_state = 206},
  [1837] = {.lex_state = 206},
  [1838] = {.lex_state = 206},
  [1839] = {.lex_state = 206},
  [1840] = {.lex_state = 206},
  [1841] = {.lex_state = 206},
  [1842] = {.lex_state = 206},
  [1843] = {.lex_state = 206},
  [1844] = {.lex_state = 206},
  [1845] = {.lex_state = 206},
  [1846] = {.lex_state = 206},
  [1847] = {.lex_state = 206},
  [1848] = {.lex_state = 206},
  [1849] = {.lex_state = 206},
  [1850] = {.lex_state = 206},
  [1851] = {.lex_state = 206},
  [1852] = {.lex_state = 206},
  [1853] = {.lex_state = 206},
  [1854] = {.lex_state = 206},
  [1855] = {.lex_state = 206},
  [1856] = {.lex_state = 206},
  [1857] = {.lex_state = 206},
  [1858] = {.lex_state = 206},
  [1859] = {.lex_state = 206},
  [1860] = {.lex_state = 206},
  [1861] = {.lex_state = 206},
  [1862] = {.lex_state = 206},
  [1863] = {.lex_state = 206},
  [1864] = {.lex_state = 206},
  [1865] = {.lex_state = 206},
  [1866] = {.lex_state = 206},
  [1867] = {.lex_state = 206},
  [1868] = {.lex_state = 206},
  [1869] = {.lex_state = 206},
  [1870] = {.lex_state = 206},
  [1871] = {.lex_state = 206},
  [1872] = {.lex_state = 206},
  [1873] = {.lex_state = 206},
  [1874] = {.lex_state = 206},
  [1875] = {.lex_state = 206},
  [1876] = {.lex_state = 206},
  [1877] = {.lex_state = 206},
  [1878] = {.lex_state = 206},
  [1879] = {.lex_state = 206},
  [1880] = {.lex_state = 206},
  [1881] = {.lex_state = 206},
  [1882] = {.lex_state = 206},
  [1883] = {.lex_state = 206},
  [1884] = {.lex_state = 206},
  [1885] = {.lex_state = 206},
  [1886] = {.lex_state = 206},
  [1887] = {.lex_state = 206},
  [1888] = {.lex_state = 206},
  [1889] = {.lex_state = 206},
  [1890] = {.lex_state = 206},
  [1891] = {.lex_state = 206},
  [1892] = {.lex_state = 206},
  [1893] = {.lex_state = 206},
  [1894] = {.lex_state = 206},
  [1895] = {.lex_state = 206},
  [1896] = {.lex_state = 206},
  [1897] = {.lex_state = 206},
  [1898] = {.lex_state = 206},
  [1899] = {.lex_state = 206},
  [1900] = {.lex_state = 206},
  [1901] = {.lex_state = 206},
  [1902] = {.lex_state = 206},
  [1903] = {.lex_state = 206},
  [1904] = {.lex_state = 206},
  [1905] = {.lex_state = 206},
  [1906] = {.lex_state = 206},
  [1907] = {.lex_state = 206},
  [1908] = {.lex_state = 206},
  [1909] = {.lex_state = 206},
  [1910] = {.lex_state = 206},
  [1911] = {.lex_state = 206},
  [1912] = {.lex_state = 206},
  [1913] = {.lex_state = 206},
  [1914] = {.lex_state = 206},
  [1915] = {.lex_state = 206},
  [1916] = {.lex_state = 206},
  [1917] = {.lex_state = 206},
  [1918] = {.lex_state = 206},
  [1919] = {.lex_state = 206},
  [1920] = {.lex_state = 206},
  [1921] = {.lex_state = 206},
  [1922] = {.lex_state = 206},
  [1923] = {.lex_state = 206},
  [1924] = {.lex_state = 206},
  [1925] = {.lex_state = 206},
  [1926] = {.lex_state = 206},
  [1927] = {.lex_state = 206},
  [1928] = {.lex_state = 206},
  [1929] = {.lex_state = 206},
  [1930] = {.lex_state = 206},
  [1931] = {.lex_state = 206},
  [1932] = {.lex_state = 206},
  [1933] = {.lex_state = 206},
  [1934] = {.lex_state = 206},
  [1935] = {.lex_state = 206},
  [1936] = {.lex_state = 206},
  [1937] = {.lex_state = 206},
  [1938] = {.lex_state = 206},
  [1939] = {.lex_state = 206},
  [1940] = {.lex_state = 206},
  [1941] = {.lex_state = 206},
  [1942] = {.lex_state = 206},
  [1943] = {.lex_state = 206},
  [1944] = {.lex_state = 206},
  [1945] = {.lex_state = 206},
  [1946] = {.lex_state = 206},
  [1947] = {.lex_state = 206},
  [1948] = {.lex_state = 206},
  [1949] = {.lex_state = 206},
  [1950] = {.lex_state = 206},
  [1951] = {.lex_state = 206},
  [1952] = {.lex_state = 206},
  [1953] = {.lex_state = 206},
  [1954] = {.lex_state = 206},
  [1955] = {.lex_state = 206},
  [1956] = {.lex_state = 206},
  [1957] = {.lex_state = 206},
  [1958] = {.lex_state = 206},
  [1959] = {.lex_state = 206},
  [1960] = {.lex_state = 206},
  [1961] = {.lex_state = 206},
  [1962] = {.lex_state = 206},
  [1963] = {.lex_state = 206},
  [1964] = {.lex_state = 206},
  [1965] = {.lex_state = 206},
  [1966] = {.lex_state = 206},
  [1967] = {.lex_state = 206},
  [1968] = {.lex_state = 206, .external_lex_state = 7},
  [1969] = {.lex_state = 206},
  [1970] = {.lex_state = 206},
  [1971] = {.lex_state = 206},
  [1972] = {.lex_state = 206},
  [1973] = {.lex_state = 206},
  [1974] = {.lex_state = 206},
  [1975] = {.lex_state = 206},
  [1976] = {.lex_state = 206},
  [1977] = {.lex_state = 206},
  [1978] = {.lex_state = 206},
  [1979] = {.lex_state = 206},
  [1980] = {.lex_state = 206},
  [1981] = {.lex_state = 206},
  [1982] = {.lex_state = 206},
  [1983] = {.lex_state = 206},
  [1984] = {.lex_state = 206},
  [1985] = {.lex_state = 206},
  [1986] = {.lex_state = 206},
  [1987] = {.lex_state = 206},
  [1988] = {.lex_state = 206},
  [1989] = {.lex_state = 206},
  [1990] = {.lex_state = 206},
  [1991] = {.lex_state = 206},
  [1992] = {.lex_state = 206},
  [1993] = {.lex_state = 206},
  [1994] = {.lex_state = 206},
  [1995] = {.lex_state = 206},
  [1996] = {.lex_state = 206},
  [1997] = {.lex_state = 206},
  [1998] = {.lex_state = 206},
  [1999] = {.lex_state = 202, .external_lex_state = 4},
  [2000] = {.lex_state = 202, .external_lex_state = 4},
  [2001] = {.lex_state = 202, .external_lex_state = 4},
  [2002] = {.lex_state = 202, .external_lex_state = 4},
  [2003] = {.lex_state = 202, .external_lex_state = 4},
  [2004] = {.lex_state = 202, .external_lex_state = 4},
  [2005] = {.lex_state = 202, .external_lex_state = 4},
  [2006] = {.lex_state = 202, .external_lex_state = 4},
  [2007] = {.lex_state = 202, .external_lex_state = 4},
  [2008] = {.lex_state = 218},
  [2009] = {.lex_state = 218},
  [2010] = {.lex_state = 218},
  [2011] = {.lex_state = 218},
  [2012] = {.lex_state = 201, .external_lex_state = 3},
  [2013] = {.lex_state = 201, .external_lex_state = 4},
  [2014] = {.lex_state = 219},
  [2015] = {.lex_state = 219},
  [2016] = {.lex_state = 219},
  [2017] = {.lex_state = 201, .external_lex_state = 4},
  [2018] = {.lex_state = 201, .external_lex_state = 4},
  [2019] = {.lex_state = 201, .external_lex_state = 4},
  [2020] = {.lex_state = 201, .external_lex_state = 4},
  [2021] = {.lex_state = 201, .external_lex_state = 4},
  [2022] = {.lex_state = 201, .external_lex_state = 4},
  [2023] = {.lex_state = 201, .external_lex_state = 4},
  [2024] = {.lex_state = 201, .external_lex_state = 4},
  [2025] = {.lex_state = 220, .external_lex_state = 6},
  [2026] = {.lex_state = 201, .external_lex_state = 4},
  [2027] = {.lex_state = 201, .external_lex_state = 4},
  [2028] = {.lex_state = 201, .external_lex_state = 4},
  [2029] = {.lex_state = 201, .external_lex_state = 4},
  [2030] = {.lex_state = 201, .external_lex_state = 4},
  [2031] = {.lex_state = 201, .external_lex_state = 4},
  [2032] = {.lex_state = 201, .external_lex_state = 4},
  [2033] = {.lex_state = 201, .external_lex_state = 4},
  [2034] = {.lex_state = 201, .external_lex_state = 4},
  [2035] = {.lex_state = 201, .external_lex_state = 4},
  [2036] = {.lex_state = 201, .external_lex_state = 5},
  [2037] = {.lex_state = 203, .external_lex_state = 4},
  [2038] = {.lex_state = 201, .external_lex_state = 5},
  [2039] = {.lex_state = 201, .external_lex_state = 5},
  [2040] = {.lex_state = 201, .external_lex_state = 4},
  [2041] = {.lex_state = 201, .external_lex_state = 5},
  [2042] = {.lex_state = 201, .external_lex_state = 5},
  [2043] = {.lex_state = 201, .external_lex_state = 5},
  [2044] = {.lex_state = 201, .external_lex_state = 5},
  [2045] = {.lex_state = 201, .external_lex_state = 5},
  [2046] = {.lex_state = 204, .external_lex_state = 6},
  [2047] = {.lex_state = 201, .external_lex_state = 5},
  [2048] = {.lex_state = 201, .external_lex_state = 5},
  [2049] = {.lex_state = 201, .external_lex_state = 4},
  [2050] = {.lex_state = 201, .external_lex_state = 4},
  [2051] = {.lex_state = 201, .external_lex_state = 4},
  [2052] = {.lex_state = 204},
  [2053] = {.lex_state = 220},
  [2054] = {.lex_state = 201, .external_lex_state = 4},
  [2055] = {.lex_state = 201, .external_lex_state = 4},
  [2056] = {.lex_state = 204, .external_lex_state = 6},
  [2057] = {.lex_state = 201, .external_lex_state = 4},
  [2058] = {.lex_state = 201, .external_lex_state = 4},
  [2059] = {.lex_state = 201, .external_lex_state = 4},
  [2060] = {.lex_state = 201, .external_lex_state = 4},
  [2061] = {.lex_state = 201, .external_lex_state = 4},
  [2062] = {.lex_state = 201, .external_lex_state = 4},
  [2063] = {.lex_state = 201, .external_lex_state = 4},
  [2064] = {.lex_state = 201, .external_lex_state = 4},
  [2065] = {.lex_state = 201, .external_lex_state = 4},
  [2066] = {.lex_state = 201, .external_lex_state = 4},
  [2067] = {.lex_state = 201, .external_lex_state = 4},
  [2068] = {.lex_state = 201, .external_lex_state = 4},
  [2069] = {.lex_state = 201, .external_lex_state = 4},
  [2070] = {.lex_state = 201, .external_lex_state = 4},
  [2071] = {.lex_state = 201, .external_lex_state = 4},
  [2072] = {.lex_state = 201, .external_lex_state = 4},
  [2073] = {.lex_state = 201, .external_lex_state = 4},
  [2074] = {.lex_state = 201, .external_lex_state = 4},
  [2075] = {.lex_state = 201, .external_lex_state = 4},
  [2076] = {.lex_state = 201, .external_lex_state = 4},
  [2077] = {.lex_state = 201, .external_lex_state = 4},
  [2078] = {.lex_state = 204, .external_lex_state = 6},
  [2079] = {.lex_state = 201, .external_lex_state = 4},
  [2080] = {.lex_state = 201, .external_lex_state = 4},
  [2081] = {.lex_state = 201, .external_lex_state = 4},
  [2082] = {.lex_state = 201, .external_lex_state = 4},
  [2083] = {.lex_state = 201, .external_lex_state = 4},
  [2084] = {.lex_state = 201, .external_lex_state = 4},
  [2085] = {.lex_state = 201, .external_lex_state = 4},
  [2086] = {.lex_state = 201, .external_lex_state = 4},
  [2087] = {.lex_state = 201, .external_lex_state = 4},
  [2088] = {.lex_state = 201, .external_lex_state = 4},
  [2089] = {.lex_state = 201, .external_lex_state = 4},
  [2090] = {.lex_state = 201, .external_lex_state = 4},
  [2091] = {.lex_state = 201, .external_lex_state = 4},
  [2092] = {.lex_state = 201, .external_lex_state = 4},
  [2093] = {.lex_state = 201, .external_lex_state = 4},
  [2094] = {.lex_state = 201, .external_lex_state = 4},
  [2095] = {.lex_state = 201, .external_lex_state = 4},
  [2096] = {.lex_state = 201, .external_lex_state = 4},
  [2097] = {.lex_state = 201, .external_lex_state = 4},
  [2098] = {.lex_state = 201, .external_lex_state = 4},
  [2099] = {.lex_state = 201, .external_lex_state = 4},
  [2100] = {.lex_state = 201, .external_lex_state = 4},
  [2101] = {.lex_state = 201, .external_lex_state = 4},
  [2102] = {.lex_state = 201, .external_lex_state = 4},
  [2103] = {.lex_state = 201, .external_lex_state = 4},
  [2104] = {.lex_state = 204, .external_lex_state = 6},
  [2105] = {.lex_state = 201, .external_lex_state = 4},
  [2106] = {.lex_state = 201, .external_lex_state = 4},
  [2107] = {.lex_state = 201, .external_lex_state = 4},
  [2108] = {.lex_state = 201, .external_lex_state = 4},
  [2109] = {.lex_state = 204, .external_lex_state = 6},
  [2110] = {.lex_state = 201, .external_lex_state = 4},
  [2111] = {.lex_state = 201, .external_lex_state = 4},
  [2112] = {.lex_state = 201, .external_lex_state = 4},
  [2113] = {.lex_state = 201, .external_lex_state = 4},
  [2114] = {.lex_state = 201, .external_lex_state = 4},
  [2115] = {.lex_state = 201, .external_lex_state = 4},
  [2116] = {.lex_state = 201, .external_lex_state = 4},
  [2117] = {.lex_state = 201, .external_lex_state = 4},
  [2118] = {.lex_state = 201, .external_lex_state = 4},
  [2119] = {.lex_state = 201, .external_lex_state = 4},
  [2120] = {.lex_state = 201, .external_lex_state = 4},
  [2121] = {.lex_state = 201, .external_lex_state = 4},
  [2122] = {.lex_state = 201, .external_lex_state = 4},
  [2123] = {.lex_state = 201, .external_lex_state = 4},
  [2124] = {.lex_state = 201, .external_lex_state = 4},
  [2125] = {.lex_state = 201, .external_lex_state = 4},
  [2126] = {.lex_state = 201, .external_lex_state = 4},
  [2127] = {.lex_state = 201, .external_lex_state = 4},
  [2128] = {.lex_state = 201, .external_lex_state = 4},
  [2129] = {.lex_state = 204, .external_lex_state = 6},
  [2130] = {.lex_state = 204, .external_lex_state = 6},
  [2131] = {.lex_state = 204, .external_lex_state = 6},
  [2132] = {.lex_state = 204, .external_lex_state = 6},
  [2133] = {.lex_state = 204, .external_lex_state = 6},
  [2134] = {.lex_state = 204, .external_lex_state = 6},
  [2135] = {.lex_state = 204, .external_lex_state = 6},
  [2136] = {.lex_state = 204, .external_lex_state = 6},
  [2137] = {.lex_state = 204, .external_lex_state = 6},
  [2138] = {.lex_state = 204, .external_lex_state = 6},
  [2139] = {.lex_state = 204},
  [2140] = {.lex_state = 204, .external_lex_state = 6},
  [2141] = {.lex_state = 204, .external_lex_state = 6},
  [2142] = {.lex_state = 204, .external_lex_state = 6},
  [2143] = {.lex_state = 204, .external_lex_state = 6},
  [2144] = {.lex_state = 204, .external_lex_state = 6},
  [2145] = {.lex_state = 204, .external_lex_state = 6},
  [2146] = {.lex_state = 204, .external_lex_state = 6},
  [2147] = {.lex_state = 204, .external_lex_state = 6},
  [2148] = {.lex_state = 204, .external_lex_state = 6},
  [2149] = {.lex_state = 204, .external_lex_state = 6},
  [2150] = {.lex_state = 204, .external_lex_state = 6},
  [2151] = {.lex_state = 204, .external_lex_state = 6},
  [2152] = {.lex_state = 204, .external_lex_state = 6},
  [2153] = {.lex_state = 204, .external_lex_state = 6},
  [2154] = {.lex_state = 204},
  [2155] = {.lex_state = 204, .external_lex_state = 6},
  [2156] = {.lex_state = 204, .external_lex_state = 6},
  [2157] = {.lex_state = 204, .external_lex_state = 6},
  [2158] = {.lex_state = 204, .external_lex_state = 6},
  [2159] = {.lex_state = 204, .external_lex_state = 6},
  [2160] = {.lex_state = 204, .external_lex_state = 6},
  [2161] = {.lex_state = 204, .external_lex_state = 6},
  [2162] = {.lex_state = 204, .external_lex_state = 6},
  [2163] = {.lex_state = 204, .external_lex_state = 6},
  [2164] = {.lex_state = 204, .external_lex_state = 6},
  [2165] = {.lex_state = 204, .external_lex_state = 6},
  [2166] = {.lex_state = 204, .external_lex_state = 6},
  [2167] = {.lex_state = 204},
  [2168] = {.lex_state = 204},
  [2169] = {.lex_state = 204, .external_lex_state = 6},
  [2170] = {.lex_state = 204, .external_lex_state = 6},
  [2171] = {.lex_state = 204, .external_lex_state = 6},
  [2172] = {.lex_state = 204, .external_lex_state = 6},
  [2173] = {.lex_state = 204, .external_lex_state = 6},
  [2174] = {.lex_state = 204, .external_lex_state = 6},
  [2175] = {.lex_state = 204, .external_lex_state = 6},
  [2176] = {.lex_state = 204, .external_lex_state = 6},
  [2177] = {.lex_state = 204, .external_lex_state = 6},
  [2178] = {.lex_state = 204, .external_lex_state = 6},
  [2179] = {.lex_state = 204, .external_lex_state = 6},
  [2180] = {.lex_state = 204, .external_lex_state = 6},
  [2181] = {.lex_state = 204, .external_lex_state = 6},
  [2182] = {.lex_state = 204, .external_lex_state = 6},
  [2183] = {.lex_state = 204, .external_lex_state = 6},
  [2184] = {.lex_state = 204, .external_lex_state = 6},
  [2185] = {.lex_state = 204, .external_lex_state = 6},
  [2186] = {.lex_state = 204, .external_lex_state = 6},
  [2187] = {.lex_state = 204, .external_lex_state = 6},
  [2188] = {.lex_state = 204, .external_lex_state = 6},
  [2189] = {.lex_state = 204, .external_lex_state = 6},
  [2190] = {.lex_state = 204, .external_lex_state = 6},
  [2191] = {.lex_state = 204, .external_lex_state = 6},
  [2192] = {.lex_state = 204, .external_lex_state = 6},
  [2193] = {.lex_state = 204, .external_lex_state = 6},
  [2194] = {.lex_state = 204, .external_lex_state = 6},
  [2195] = {.lex_state = 204, .external_lex_state = 6},
  [2196] = {.lex_state = 204, .external_lex_state = 6},
  [2197] = {.lex_state = 204, .external_lex_state = 6},
  [2198] = {.lex_state = 204, .external_lex_state = 6},
  [2199] = {.lex_state = 204},
  [2200] = {.lex_state = 204},
  [2201] = {.lex_state = 204},
  [2202] = {.lex_state = 204},
  [2203] = {.lex_state = 204},
  [2204] = {.lex_state = 204},
  [2205] = {.lex_state = 204},
  [2206] = {.lex_state = 204},
  [2207] = {.lex_state = 204},
  [2208] = {.lex_state = 204},
  [2209] = {.lex_state = 204},
  [2210] = {.lex_state = 204},
  [2211] = {.lex_state = 204},
  [2212] = {.lex_state = 204},
  [2213] = {.lex_state = 204},
  [2214] = {.lex_state = 204},
  [2215] = {.lex_state = 204},
  [2216] = {.lex_state = 204},
  [2217] = {.lex_state = 204},
  [2218] = {.lex_state = 204},
  [2219] = {.lex_state = 204},
  [2220] = {.lex_state = 204},
  [2221] = {.lex_state = 204},
  [2222] = {.lex_state = 204},
  [2223] = {.lex_state = 204},
  [2224] = {.lex_state = 204},
  [2225] = {.lex_state = 204},
  [2226] = {.lex_state = 204},
  [2227] = {.lex_state = 204},
  [2228] = {.lex_state = 204},
  [2229] = {.lex_state = 204},
  [2230] = {.lex_state = 204},
  [2231] = {.lex_state = 204},
  [2232] = {.lex_state = 204},
  [2233] = {.lex_state = 204},
  [2234] = {.lex_state = 204},
  [2235] = {.lex_state = 204},
  [2236] = {.lex_state = 204},
  [2237] = {.lex_state = 204},
  [2238] = {.lex_state = 204},
  [2239] = {.lex_state = 204},
  [2240] = {.lex_state = 204},
  [2241] = {.lex_state = 204},
  [2242] = {.lex_state = 204},
  [2243] = {.lex_state = 204},
  [2244] = {.lex_state = 204},
  [2245] = {.lex_state = 204},
  [2246] = {.lex_state = 204},
  [2247] = {.lex_state = 204},
  [2248] = {.lex_state = 204},
  [2249] = {.lex_state = 204},
  [2250] = {.lex_state = 204},
  [2251] = {.lex_state = 204},
  [2252] = {.lex_state = 204},
  [2253] = {.lex_state = 204},
  [2254] = {.lex_state = 204},
  [2255] = {.lex_state = 204},
  [2256] = {.lex_state = 204},
  [2257] = {.lex_state = 204},
  [2258] = {.lex_state = 204},
  [2259] = {.lex_state = 204},
  [2260] = {.lex_state = 204},
  [2261] = {.lex_state = 204},
  [2262] = {.lex_state = 204},
  [2263] = {.lex_state = 204},
  [2264] = {.lex_state = 204},
  [2265] = {.lex_state = 221},
  [2266] = {.lex_state = 206},
  [2267] = {.lex_state = 206},
  [2268] = {.lex_state = 206},
  [2269] = {.lex_state = 206},
  [2270] = {.lex_state = 206},
  [2271] = {.lex_state = 206},
  [2272] = {.lex_state = 206},
  [2273] = {.lex_state = 206},
  [2274] = {.lex_state = 206},
  [2275] = {.lex_state = 206},
  [2276] = {.lex_state = 206},
  [2277] = {.lex_state = 206},
  [2278] = {.lex_state = 206},
  [2279] = {.lex_state = 206},
  [2280] = {.lex_state = 206},
  [2281] = {.lex_state = 206},
  [2282] = {.lex_state = 206},
  [2283] = {.lex_state = 206},
  [2284] = {.lex_state = 206},
  [2285] = {.lex_state = 206},
  [2286] = {.lex_state = 206},
  [2287] = {.lex_state = 206},
  [2288] = {.lex_state = 206},
  [2289] = {.lex_state = 206},
  [2290] = {.lex_state = 206},
  [2291] = {.lex_state = 206},
  [2292] = {.lex_state = 206},
  [2293] = {.lex_state = 206},
  [2294] = {.lex_state = 206},
  [2295] = {.lex_state = 206},
  [2296] = {.lex_state = 206},
  [2297] = {.lex_state = 206},
  [2298] = {.lex_state = 206},
  [2299] = {.lex_state = 206},
  [2300] = {.lex_state = 206},
  [2301] = {.lex_state = 206},
  [2302] = {.lex_state = 206},
  [2303] = {.lex_state = 206},
  [2304] = {.lex_state = 206},
  [2305] = {.lex_state = 206},
  [2306] = {.lex_state = 206},
  [2307] = {.lex_state = 206},
  [2308] = {.lex_state = 206},
  [2309] = {.lex_state = 206},
  [2310] = {.lex_state = 206},
  [2311] = {.lex_state = 206},
  [2312] = {.lex_state = 206},
  [2313] = {.lex_state = 206},
  [2314] = {.lex_state = 206},
  [2315] = {.lex_state = 206},
  [2316] = {.lex_state = 206},
  [2317] = {.lex_state = 206},
  [2318] = {.lex_state = 206},
  [2319] = {.lex_state = 206},
  [2320] = {.lex_state = 206},
  [2321] = {.lex_state = 206},
  [2322] = {.lex_state = 206},
  [2323] = {.lex_state = 206},
  [2324] = {.lex_state = 206},
  [2325] = {.lex_state = 206},
  [2326] = {.lex_state = 206},
  [2327] = {.lex_state = 206},
  [2328] = {.lex_state = 206},
  [2329] = {.lex_state = 206},
  [2330] = {.lex_state = 206},
  [2331] = {.lex_state = 206},
  [2332] = {.lex_state = 206},
  [2333] = {.lex_state = 206},
  [2334] = {.lex_state = 206},
  [2335] = {.lex_state = 206},
  [2336] = {.lex_state = 208},
  [2337] = {.lex_state = 208},
  [2338] = {.lex_state = 208, .external_lex_state = 7},
  [2339] = {.lex_state = 208},
  [2340] = {.lex_state = 208},
  [2341] = {.lex_state = 208},
  [2342] = {.lex_state = 208},
  [2343] = {.lex_state = 208},
  [2344] = {.lex_state = 208},
  [2345] = {.lex_state = 208},
  [2346] = {.lex_state = 208},
  [2347] = {.lex_state = 208},
  [2348] = {.lex_state = 208},
  [2349] = {.lex_state = 208},
  [2350] = {.lex_state = 208},
  [2351] = {.lex_state = 208},
  [2352] = {.lex_state = 208},
  [2353] = {.lex_state = 208},
  [2354] = {.lex_state = 208},
  [2355] = {.lex_state = 208},
  [2356] = {.lex_state = 208},
  [2357] = {.lex_state = 208},
  [2358] = {.lex_state = 208},
  [2359] = {.lex_state = 208},
  [2360] = {.lex_state = 208},
  [2361] = {.lex_state = 208},
  [2362] = {.lex_state = 208},
  [2363] = {.lex_state = 208},
  [2364] = {.lex_state = 208},
  [2365] = {.lex_state = 208},
  [2366] = {.lex_state = 208},
  [2367] = {.lex_state = 208},
  [2368] = {.lex_state = 208},
  [2369] = {.lex_state = 208},
  [2370] = {.lex_state = 208},
  [2371] = {.lex_state = 208},
  [2372] = {.lex_state = 208},
  [2373] = {.lex_state = 208},
  [2374] = {.lex_state = 208, .external_lex_state = 7},
  [2375] = {.lex_state = 208},
  [2376] = {.lex_state = 208},
  [2377] = {.lex_state = 208},
  [2378] = {.lex_state = 208},
  [2379] = {.lex_state = 208},
  [2380] = {.lex_state = 208},
  [2381] = {.lex_state = 208},
  [2382] = {.lex_state = 208},
  [2383] = {.lex_state = 208, .external_lex_state = 7},
  [2384] = {.lex_state = 208},
  [2385] = {.lex_state = 208},
  [2386] = {.lex_state = 208},
  [2387] = {.lex_state = 208},
  [2388] = {.lex_state = 208},
  [2389] = {.lex_state = 208},
  [2390] = {.lex_state = 208},
  [2391] = {.lex_state = 208},
  [2392] = {.lex_state = 208, .external_lex_state = 7},
  [2393] = {.lex_state = 208},
  [2394] = {.lex_state = 208},
  [2395] = {.lex_state = 208},
  [2396] = {.lex_state = 208},
  [2397] = {.lex_state = 208},
  [2398] = {.lex_state = 208},
  [2399] = {.lex_state = 208},
  [2400] = {.lex_state = 208},
  [2401] = {.lex_state = 208},
  [2402] = {.lex_state = 208},
  [2403] = {.lex_state = 208},
  [2404] = {.lex_state = 208},
  [2405] = {.lex_state = 208},
  [2406] = {.lex_state = 208},
  [2407] = {.lex_state = 208},
  [2408] = {.lex_state = 208},
  [2409] = {.lex_state = 208},
  [2410] = {.lex_state = 208},
  [2411] = {.lex_state = 208},
  [2412] = {.lex_state = 208},
  [2413] = {.lex_state = 208},
  [2414] = {.lex_state = 208},
  [2415] = {.lex_state = 208},
  [2416] = {.lex_state = 208},
  [2417] = {.lex_state = 208},
  [2418] = {.lex_state = 208},
  [2419] = {.lex_state = 208},
  [2420] = {.lex_state = 208, .external_lex_state = 7},
  [2421] = {.lex_state = 208},
  [2422] = {.lex_state = 208},
  [2423] = {.lex_state = 208},
  [2424] = {.lex_state = 208},
  [2425] = {.lex_state = 208},
  [2426] = {.lex_state = 208, .external_lex_state = 7},
  [2427] = {.lex_state = 208},
  [2428] = {.lex_state = 222},
  [2429] = {.lex_state = 222},
  [2430] = {.lex_state = 208, .external_lex_state = 7},
  [2431] = {.lex_state = 208, .external_lex_state = 7},
  [2432] = {.lex_state = 208},
  [2433] = {.lex_state = 222},
  [2434] = {.lex_state = 208},
  [2435] = {.lex_state = 208},
  [2436] = {.lex_state = 208},
  [2437] = {.lex_state = 208},
  [2438] = {.lex_state = 208},
  [2439] = {.lex_state = 208},
  [2440] = {.lex_state = 208},
  [2441] = {.lex_state = 208, .external_lex_state = 7},
  [2442] = {.lex_state = 208},
  [2443] = {.lex_state = 208},
  [2444] = {.lex_state = 222},
  [2445] = {.lex_state = 208},
  [2446] = {.lex_state = 208},
  [2447] = {.lex_state = 208},
  [2448] = {.lex_state = 208},
  [2449] = {.lex_state = 208, .external_lex_state = 7},
  [2450] = {.lex_state = 208},
  [2451] = {.lex_state = 208},
  [2452] = {.lex_state = 208},
  [2453] = {.lex_state = 208},
  [2454] = {.lex_state = 208},
  [2455] = {.lex_state = 208},
  [2456] = {.lex_state = 208},
  [2457] = {.lex_state = 208},
  [2458] = {.lex_state = 208},
  [2459] = {.lex_state = 208},
  [2460] = {.lex_state = 208},
  [2461] = {.lex_state = 208},
  [2462] = {.lex_state = 208},
  [2463] = {.lex_state = 208, .external_lex_state = 7},
  [2464] = {.lex_state = 222},
  [2465] = {.lex_state = 208},
  [2466] = {.lex_state = 208},
  [2467] = {.lex_state = 208, .external_lex_state = 7},
  [2468] = {.lex_state = 208},
  [2469] = {.lex_state = 208},
  [2470] = {.lex_state = 208, .external_lex_state = 7},
  [2471] = {.lex_state = 208},
  [2472] = {.lex_state = 208},
  [2473] = {.lex_state = 222},
  [2474] = {.lex_state = 208},
  [2475] = {.lex_state = 208},
  [2476] = {.lex_state = 208},
  [2477] = {.lex_state = 208},
  [2478] = {.lex_state = 208},
  [2479] = {.lex_state = 222},
  [2480] = {.lex_state = 208},
  [2481] = {.lex_state = 208},
  [2482] = {.lex_state = 222},
  [2483] = {.lex_state = 208},
  [2484] = {.lex_state = 208},
  [2485] = {.lex_state = 208},
  [2486] = {.lex_state = 222},
  [2487] = {.lex_state = 208},
  [2488] = {.lex_state = 208},
  [2489] = {.lex_state = 208},
  [2490] = {.lex_state = 222},
  [2491] = {.lex_state = 208},
  [2492] = {.lex_state = 208, .external_lex_state = 7},
  [2493] = {.lex_state = 208},
  [2494] = {.lex_state = 208},
  [2495] = {.lex_state = 208},
  [2496] = {.lex_state = 208},
  [2497] = {.lex_state = 208},
  [2498] = {.lex_state = 208},
  [2499] = {.lex_state = 222},
  [2500] = {.lex_state = 222},
  [2501] = {.lex_state = 222},
  [2502] = {.lex_state = 208},
  [2503] = {.lex_state = 222},
  [2504] = {.lex_state = 208},
  [2505] = {.lex_state = 208},
  [2506] = {.lex_state = 222},
  [2507] = {.lex_state = 222},
  [2508] = {.lex_state = 208, .external_lex_state = 7},
  [2509] = {.lex_state = 208, .external_lex_state = 7},
  [2510] = {.lex_state = 208, .external_lex_state = 7},
  [2511] = {.lex_state = 208, .external_lex_state = 7},
  [2512] = {.lex_state = 208, .external_lex_state = 7},
  [2513] = {.lex_state = 208, .external_lex_state = 7},
  [2514] = {.lex_state = 208, .external_lex_state = 7},
  [2515] = {.lex_state = 208, .external_lex_state = 7},
  [2516] = {.lex_state = 208, .external_lex_state = 7},
  [2517] = {.lex_state = 208, .external_lex_state = 7},
  [2518] = {.lex_state = 208, .external_lex_state = 7},
  [2519] = {.lex_state = 208, .external_lex_state = 7},
  [2520] = {.lex_state = 208, .external_lex_state = 7},
  [2521] = {.lex_state = 208, .external_lex_state = 7},
  [2522] = {.lex_state = 208, .external_lex_state = 7},
  [2523] = {.lex_state = 208, .external_lex_state = 7},
  [2524] = {.lex_state = 208, .external_lex_state = 7},
  [2525] = {.lex_state = 208, .external_lex_state = 7},
  [2526] = {.lex_state = 208, .external_lex_state = 7},
  [2527] = {.lex_state = 208, .external_lex_state = 7},
  [2528] = {.lex_state = 208, .external_lex_state = 7},
  [2529] = {.lex_state = 208, .external_lex_state = 7},
  [2530] = {.lex_state = 208, .external_lex_state = 7},
  [2531] = {.lex_state = 208, .external_lex_state = 7},
  [2532] = {.lex_state = 208, .external_lex_state = 7},
  [2533] = {.lex_state = 208, .external_lex_state = 7},
  [2534] = {.lex_state = 208, .external_lex_state = 7},
  [2535] = {.lex_state = 208, .external_lex_state = 7},
  [2536] = {.lex_state = 208, .external_lex_state = 7},
  [2537] = {.lex_state = 208, .external_lex_state = 7},
  [2538] = {.lex_state = 208, .external_lex_state = 7},
  [2539] = {.lex_state = 208, .external_lex_state = 7},
  [2540] = {.lex_state = 208, .external_lex_state = 7},
  [2541] = {.lex_state = 208, .external_lex_state = 7},
  [2542] = {.lex_state = 208, .external_lex_state = 7},
  [2543] = {.lex_state = 208, .external_lex_state = 7},
  [2544] = {.lex_state = 208, .external_lex_state = 7},
  [2545] = {.lex_state = 208, .external_lex_state = 7},
  [2546] = {.lex_state = 208, .external_lex_state = 7},
  [2547] = {.lex_state = 208, .external_lex_state = 7},
  [2548] = {.lex_state = 208, .external_lex_state = 7},
  [2549] = {.lex_state = 208, .external_lex_state = 7},
  [2550] = {.lex_state = 208, .external_lex_state = 7},
  [2551] = {.lex_state = 208, .external_lex_state = 7},
  [2552] = {.lex_state = 208, .external_lex_state = 7},
  [2553] = {.lex_state = 208, .external_lex_state = 7},
  [2554] = {.lex_state = 208, .external_lex_state = 7},
  [2555] = {.lex_state = 208, .external_lex_state = 7},
  [2556] = {.lex_state = 208, .external_lex_state = 7},
  [2557] = {.lex_state = 208, .external_lex_state = 7},
  [2558] = {.lex_state = 208, .external_lex_state = 7},
  [2559] = {.lex_state = 208, .external_lex_state = 7},
  [2560] = {.lex_state = 208, .external_lex_state = 7},
  [2561] = {.lex_state = 208, .external_lex_state = 7},
  [2562] = {.lex_state = 208, .external_lex_state = 7},
  [2563] = {.lex_state = 208, .external_lex_state = 7},
  [2564] = {.lex_state = 208, .external_lex_state = 7},
  [2565] = {.lex_state = 209, .external_lex_state = 8},
  [2566] = {.lex_state = 211},
  [2567] = {.lex_state = 211},
  [2568] = {.lex_state = 221, .external_lex_state = 8},
  [2569] = {.lex_state = 209, .external_lex_state = 8},
  [2570] = {.lex_state = 209, .external_lex_state = 8},
  [2571] = {.lex_state = 209, .external_lex_state = 8},
  [2572] = {.lex_state = 209, .external_lex_state = 8},
  [2573] = {.lex_state = 209, .external_lex_state = 8},
  [2574] = {.lex_state = 221},
  [2575] = {.lex_state = 209, .external_lex_state = 8},
  [2576] = {.lex_state = 209, .external_lex_state = 8},
  [2577] = {.lex_state = 209, .external_lex_state = 8},
  [2578] = {.lex_state = 209, .external_lex_state = 8},
  [2579] = {.lex_state = 209, .external_lex_state = 8},
  [2580] = {.lex_state = 209, .external_lex_state = 8},
  [2581] = {.lex_state = 209, .external_lex_state = 8},
  [2582] = {.lex_state = 209},
  [2583] = {.lex_state = 209, .external_lex_state = 8},
  [2584] = {.lex_state = 209, .external_lex_state = 8},
  [2585] = {.lex_state = 209, .external_lex_state = 8},
  [2586] = {.lex_state = 209, .external_lex_state = 8},
  [2587] = {.lex_state = 209, .external_lex_state = 8},
  [2588] = {.lex_state = 221, .external_lex_state = 7},
  [2589] = {.lex_state = 211},
  [2590] = {.lex_state = 209, .external_lex_state = 8},
  [2591] = {.lex_state = 209, .external_lex_state = 8},
  [2592] = {.lex_state = 209, .external_lex_state = 8},
  [2593] = {.lex_state = 209, .external_lex_state = 8},
  [2594] = {.lex_state = 209, .external_lex_state = 8},
  [2595] = {.lex_state = 209, .external_lex_state = 8},
  [2596] = {.lex_state = 209, .external_lex_state = 8},
  [2597] = {.lex_state = 209, .external_lex_state = 8},
  [2598] = {.lex_state = 209, .external_lex_state = 8},
  [2599] = {.lex_state = 211},
  [2600] = {.lex_state = 209, .external_lex_state = 8},
  [2601] = {.lex_state = 216},
  [2602] = {.lex_state = 209, .external_lex_state = 8},
  [2603] = {.lex_state = 209, .external_lex_state = 8},
  [2604] = {.lex_state = 211},
  [2605] = {.lex_state = 209, .external_lex_state = 8},
  [2606] = {.lex_state = 209, .external_lex_state = 8},
  [2607] = {.lex_state = 209, .external_lex_state = 8},
  [2608] = {.lex_state = 209, .external_lex_state = 8},
  [2609] = {.lex_state = 209, .external_lex_state = 8},
  [2610] = {.lex_state = 209, .external_lex_state = 8},
  [2611] = {.lex_state = 209, .external_lex_state = 8},
  [2612] = {.lex_state = 209, .external_lex_state = 8},
  [2613] = {.lex_state = 211},
  [2614] = {.lex_state = 209, .external_lex_state = 8},
  [2615] = {.lex_state = 209, .external_lex_state = 8},
  [2616] = {.lex_state = 209, .external_lex_state = 8},
  [2617] = {.lex_state = 209, .external_lex_state = 8},
  [2618] = {.lex_state = 217},
  [2619] = {.lex_state = 209, .external_lex_state = 8},
  [2620] = {.lex_state = 209, .external_lex_state = 8},
  [2621] = {.lex_state = 209, .external_lex_state = 8},
  [2622] = {.lex_state = 209, .external_lex_state = 8},
  [2623] = {.lex_state = 209, .external_lex_state = 8},
  [2624] = {.lex_state = 209, .external_lex_state = 8},
  [2625] = {.lex_state = 209, .external_lex_state = 8},
  [2626] = {.lex_state = 209, .external_lex_state = 8},
  [2627] = {.lex_state = 209, .external_lex_state = 8},
  [2628] = {.lex_state = 209, .external_lex_state = 8},
  [2629] = {.lex_state = 209, .external_lex_state = 8},
  [2630] = {.lex_state = 209, .external_lex_state = 8},
  [2631] = {.lex_state = 209, .external_lex_state = 8},
  [2632] = {.lex_state = 209, .external_lex_state = 8},
  [2633] = {.lex_state = 209, .external_lex_state = 8},
  [2634] = {.lex_state = 209, .external_lex_state = 8},
  [2635] = {.lex_state = 209, .external_lex_state = 8},
  [2636] = {.lex_state = 209, .external_lex_state = 8},
  [2637] = {.lex_state = 209, .external_lex_state = 8},
  [2638] = {.lex_state = 209, .external_lex_state = 8},
  [2639] = {.lex_state = 209, .external_lex_state = 8},
  [2640] = {.lex_state = 209, .external_lex_state = 8},
  [2641] = {.lex_state = 209, .external_lex_state = 8},
  [2642] = {.lex_state = 209, .external_lex_state = 8},
  [2643] = {.lex_state = 209, .external_lex_state = 8},
  [2644] = {.lex_state = 209, .external_lex_state = 8},
  [2645] = {.lex_state = 209, .external_lex_state = 8},
  [2646] = {.lex_state = 209, .external_lex_state = 8},
  [2647] = {.lex_state = 209, .external_lex_state = 8},
  [2648] = {.lex_state = 206, .external_lex_state = 8},
  [2649] = {.lex_state = 206, .external_lex_state = 8},
  [2650] = {.lex_state = 206, .external_lex_state = 8},
  [2651] = {.lex_state = 211},
  [2652] = {.lex_state = 206, .external_lex_state = 8},
  [2653] = {.lex_state = 211},
  [2654] = {.lex_state = 207},
  [2655] = {.lex_state = 211},
  [2656] = {.lex_state = 211},
  [2657] = {.lex_state = 211},
  [2658] = {.lex_state = 211},
  [2659] = {.lex_state = 211},
  [2660] = {.lex_state = 211},
  [2661] = {.lex_state = 211},
  [2662] = {.lex_state = 211},
  [2663] = {.lex_state = 211},
  [2664] = {.lex_state = 211},
  [2665] = {.lex_state = 211},
  [2666] = {.lex_state = 206, .external_lex_state = 8},
  [2667] = {.lex_state = 211},
  [2668] = {.lex_state = 211},
  [2669] = {.lex_state = 211},
  [2670] = {.lex_state = 211},
  [2671] = {.lex_state = 211},
  [2672] = {.lex_state = 211},
  [2673] = {.lex_state = 206, .external_lex_state = 8},
  [2674] = {.lex_state = 211},
  [2675] = {.lex_state = 209},
  [2676] = {.lex_state = 211},
  [2677] = {.lex_state = 211},
  [2678] = {.lex_state = 211},
  [2679] = {.lex_state = 221, .external_lex_state = 10},
  [2680] = {.lex_state = 211},
  [2681] = {.lex_state = 211},
  [2682] = {.lex_state = 211},
  [2683] = {.lex_state = 211},
  [2684] = {.lex_state = 206, .external_lex_state = 8},
  [2685] = {.lex_state = 206, .external_lex_state = 8},
  [2686] = {.lex_state = 211},
  [2687] = {.lex_state = 211},
  [2688] = {.lex_state = 211},
  [2689] = {.lex_state = 206, .external_lex_state = 8},
  [2690] = {.lex_state = 211},
  [2691] = {.lex_state = 209},
  [2692] = {.lex_state = 211},
  [2693] = {.lex_state = 206, .external_lex_state = 8},
  [2694] = {.lex_state = 211},
  [2695] = {.lex_state = 211},
  [2696] = {.lex_state = 211},
  [2697] = {.lex_state = 211},
  [2698] = {.lex_state = 211},
  [2699] = {.lex_state = 211},
  [2700] = {.lex_state = 211},
  [2701] = {.lex_state = 211},
  [2702] = {.lex_state = 211},
  [2703] = {.lex_state = 209},
  [2704] = {.lex_state = 211},
  [2705] = {.lex_state = 206, .external_lex_state = 8},
  [2706] = {.lex_state = 211},
  [2707] = {.lex_state = 211},
  [2708] = {.lex_state = 211},
  [2709] = {.lex_state = 211},
  [2710] = {.lex_state = 211},
  [2711] = {.lex_state = 211},
  [2712] = {.lex_state = 211},
  [2713] = {.lex_state = 211},
  [2714] = {.lex_state = 211},
  [2715] = {.lex_state = 221, .external_lex_state = 9},
  [2716] = {.lex_state = 221},
  [2717] = {.lex_state = 211},
  [2718] = {.lex_state = 211},
  [2719] = {.lex_state = 211},
  [2720] = {.lex_state = 206, .external_lex_state = 8},
  [2721] = {.lex_state = 211},
  [2722] = {.lex_state = 211},
  [2723] = {.lex_state = 211},
  [2724] = {.lex_state = 211},
  [2725] = {.lex_state = 211},
  [2726] = {.lex_state = 211},
  [2727] = {.lex_state = 211},
  [2728] = {.lex_state = 209},
  [2729] = {.lex_state = 211},
  [2730] = {.lex_state = 211},
  [2731] = {.lex_state = 206, .external_lex_state = 8},
  [2732] = {.lex_state = 211},
  [2733] = {.lex_state = 211},
  [2734] = {.lex_state = 211},
  [2735] = {.lex_state = 206, .external_lex_state = 8},
  [2736] = {.lex_state = 221},
  [2737] = {.lex_state = 206, .external_lex_state = 8},
  [2738] = {.lex_state = 206, .external_lex_state = 8},
  [2739] = {.lex_state = 206, .external_lex_state = 8},
  [2740] = {.lex_state = 206, .external_lex_state = 8},
  [2741] = {.lex_state = 206, .external_lex_state = 8},
  [2742] = {.lex_state = 206, .external_lex_state = 8},
  [2743] = {.lex_state = 206, .external_lex_state = 8},
  [2744] = {.lex_state = 206, .external_lex_state = 8},
  [2745] = {.lex_state = 209},
  [2746] = {.lex_state = 221},
  [2747] = {.lex_state = 221},
  [2748] = {.lex_state = 221},
  [2749] = {.lex_state = 221},
  [2750] = {.lex_state = 206, .external_lex_state = 8},
  [2751] = {.lex_state = 221},
  [2752] = {.lex_state = 221},
  [2753] = {.lex_state = 206, .external_lex_state = 8},
  [2754] = {.lex_state = 206, .external_lex_state = 8},
  [2755] = {.lex_state = 206, .external_lex_state = 8},
  [2756] = {.lex_state = 216},
  [2757] = {.lex_state = 206, .external_lex_state = 7},
  [2758] = {.lex_state = 206, .external_lex_state = 8},
  [2759] = {.lex_state = 221},
  [2760] = {.lex_state = 206, .external_lex_state = 8},
  [2761] = {.lex_state = 206, .external_lex_state = 8},
  [2762] = {.lex_state = 206, .external_lex_state = 8},
  [2763] = {.lex_state = 217},
  [2764] = {.lex_state = 216},
  [2765] = {.lex_state = 206, .external_lex_state = 8},
  [2766] = {.lex_state = 206, .external_lex_state = 8},
  [2767] = {.lex_state = 206, .external_lex_state = 8},
  [2768] = {.lex_state = 206, .external_lex_state = 8},
  [2769] = {.lex_state = 206, .external_lex_state = 8},
  [2770] = {.lex_state = 206, .external_lex_state = 8},
  [2771] = {.lex_state = 217},
  [2772] = {.lex_state = 206, .external_lex_state = 8},
  [2773] = {.lex_state = 206, .external_lex_state = 8},
  [2774] = {.lex_state = 209},
  [2775] = {.lex_state = 206, .external_lex_state = 8},
  [2776] = {.lex_state = 221},
  [2777] = {.lex_state = 216},
  [2778] = {.lex_state = 221},
  [2779] = {.lex_state = 221},
  [2780] = {.lex_state = 221},
  [2781] = {.lex_state = 221},
  [2782] = {.lex_state = 206, .external_lex_state = 8},
  [2783] = {.lex_state = 216},
  [2784] = {.lex_state = 206, .external_lex_state = 8},
  [2785] = {.lex_state = 206, .external_lex_state = 7},
  [2786] = {.lex_state = 209},
  [2787] = {.lex_state = 206, .external_lex_state = 8},
  [2788] = {.lex_state = 206, .external_lex_state = 8},
  [2789] = {.lex_state = 206, .external_lex_state = 8},
  [2790] = {.lex_state = 206, .external_lex_state = 8},
  [2791] = {.lex_state = 206, .external_lex_state = 8},
  [2792] = {.lex_state = 209},
  [2793] = {.lex_state = 206, .external_lex_state = 8},
  [2794] = {.lex_state = 206, .external_lex_state = 8},
  [2795] = {.lex_state = 206, .external_lex_state = 8},
  [2796] = {.lex_state = 221},
  [2797] = {.lex_state = 206, .external_lex_state = 7},
  [2798] = {.lex_state = 206, .external_lex_state = 8},
  [2799] = {.lex_state = 206, .external_lex_state = 8},
  [2800] = {.lex_state = 206, .external_lex_state = 8},
  [2801] = {.lex_state = 206, .external_lex_state = 8},
  [2802] = {.lex_state = 209},
  [2803] = {.lex_state = 221},
  [2804] = {.lex_state = 221},
  [2805] = {.lex_state = 206, .external_lex_state = 7},
  [2806] = {.lex_state = 206, .external_lex_state = 8},
  [2807] = {.lex_state = 206, .external_lex_state = 8},
  [2808] = {.lex_state = 206, .external_lex_state = 8},
  [2809] = {.lex_state = 206, .external_lex_state = 8},
  [2810] = {.lex_state = 209},
  [2811] = {.lex_state = 206, .external_lex_state = 8},
  [2812] = {.lex_state = 206, .external_lex_state = 8},
  [2813] = {.lex_state = 217},
  [2814] = {.lex_state = 206, .external_lex_state = 8},
  [2815] = {.lex_state = 206, .external_lex_state = 8},
  [2816] = {.lex_state = 206, .external_lex_state = 8},
  [2817] = {.lex_state = 206, .external_lex_state = 8},
  [2818] = {.lex_state = 206, .external_lex_state = 8},
  [2819] = {.lex_state = 206, .external_lex_state = 8},
  [2820] = {.lex_state = 206, .external_lex_state = 8},
  [2821] = {.lex_state = 206, .external_lex_state = 8},
  [2822] = {.lex_state = 206, .external_lex_state = 8},
  [2823] = {.lex_state = 206, .external_lex_state = 8},
  [2824] = {.lex_state = 209},
  [2825] = {.lex_state = 206, .external_lex_state = 8},
  [2826] = {.lex_state = 209},
  [2827] = {.lex_state = 209},
  [2828] = {.lex_state = 217},
  [2829] = {.lex_state = 217},
  [2830] = {.lex_state = 209},
  [2831] = {.lex_state = 209},
  [2832] = {.lex_state = 206, .external_lex_state = 7},
  [2833] = {.lex_state = 206, .external_lex_state = 7},
  [2834] = {.lex_state = 217},
  [2835] = {.lex_state = 221},
  [2836] = {.lex_state = 209},
  [2837] = {.lex_state = 209},
  [2838] = {.lex_state = 217},
  [2839] = {.lex_state = 209},
  [2840] = {.lex_state = 209},
  [2841] = {.lex_state = 209},
  [2842] = {.lex_state = 209},
  [2843] = {.lex_state = 217},
  [2844] = {.lex_state = 209},
  [2845] = {.lex_state = 209},
  [2846] = {.lex_state = 209},
  [2847] = {.lex_state = 209},
  [2848] = {.lex_state = 209},
  [2849] = {.lex_state = 209},
  [2850] = {.lex_state = 216},
  [2851] = {.lex_state = 209},
  [2852] = {.lex_state = 209},
  [2853] = {.lex_state = 209},
  [2854] = {.lex_state = 217},
  [2855] = {.lex_state = 209},
  [2856] = {.lex_state = 209},
  [2857] = {.lex_state = 206, .external_lex_state = 7},
  [2858] = {.lex_state = 209},
  [2859] = {.lex_state = 217},
  [2860] = {.lex_state = 209},
  [2861] = {.lex_state = 209},
  [2862] = {.lex_state = 217},
  [2863] = {.lex_state = 216},
  [2864] = {.lex_state = 209},
  [2865] = {.lex_state = 206, .external_lex_state = 7},
  [2866] = {.lex_state = 206, .external_lex_state = 7},
  [2867] = {.lex_state = 209},
  [2868] = {.lex_state = 209},
  [2869] = {.lex_state = 209},
  [2870] = {.lex_state = 217},
  [2871] = {.lex_state = 216},
  [2872] = {.lex_state = 209},
  [2873] = {.lex_state = 209},
  [2874] = {.lex_state = 217},
  [2875] = {.lex_state = 216},
  [2876] = {.lex_state = 209},
  [2877] = {.lex_state = 209},
  [2878] = {.lex_state = 209},
  [2879] = {.lex_state = 209},
  [2880] = {.lex_state = 209},
  [2881] = {.lex_state = 209},
  [2882] = {.lex_state = 209},
  [2883] = {.lex_state = 206, .external_lex_state = 7},
  [2884] = {.lex_state = 209},
  [2885] = {.lex_state = 209},
  [2886] = {.lex_state = 206, .external_lex_state = 7},
  [2887] = {.lex_state = 209},
  [2888] = {.lex_state = 209},
  [2889] = {.lex_state = 209},
  [2890] = {.lex_state = 209},
  [2891] = {.lex_state = 216},
  [2892] = {.lex_state = 209},
  [2893] = {.lex_state = 216},
  [2894] = {.lex_state = 206, .external_lex_state = 7},
  [2895] = {.lex_state = 209},
  [2896] = {.lex_state = 206, .external_lex_state = 7},
  [2897] = {.lex_state = 216},
  [2898] = {.lex_state = 209},
  [2899] = {.lex_state = 209},
  [2900] = {.lex_state = 209},
  [2901] = {.lex_state = 216},
  [2902] = {.lex_state = 209},
  [2903] = {.lex_state = 209},
  [2904] = {.lex_state = 209},
  [2905] = {.lex_state = 209},
  [2906] = {.lex_state = 209},
  [2907] = {.lex_state = 216},
  [2908] = {.lex_state = 209},
  [2909] = {.lex_state = 209},
  [2910] = {.lex_state = 209},
  [2911] = {.lex_state = 209},
  [2912] = {.lex_state = 209},
  [2913] = {.lex_state = 209},
  [2914] = {.lex_state = 206, .external_lex_state = 7},
  [2915] = {.lex_state = 217},
  [2916] = {.lex_state = 206, .external_lex_state = 10},
  [2917] = {.lex_state = 206, .external_lex_state = 10},
  [2918] = {.lex_state = 206, .external_lex_state = 10},
  [2919] = {.lex_state = 216},
  [2920] = {.lex_state = 216},
  [2921] = {.lex_state = 205},
  [2922] = {.lex_state = 206, .external_lex_state = 7},
  [2923] = {.lex_state = 216},
  [2924] = {.lex_state = 206, .external_lex_state = 9},
  [2925] = {.lex_state = 206, .external_lex_state = 10},
  [2926] = {.lex_state = 206, .external_lex_state = 9},
  [2927] = {.lex_state = 206, .external_lex_state = 9},
  [2928] = {.lex_state = 216},
  [2929] = {.lex_state = 206, .external_lex_state = 9},
  [2930] = {.lex_state = 217},
  [2931] = {.lex_state = 206, .external_lex_state = 7},
  [2932] = {.lex_state = 206, .external_lex_state = 7},
  [2933] = {.lex_state = 206, .external_lex_state = 7},
  [2934] = {.lex_state = 206, .external_lex_state = 7},
  [2935] = {.lex_state = 206, .external_lex_state = 7},
  [2936] = {.lex_state = 206, .external_lex_state = 7},
  [2937] = {.lex_state = 206, .external_lex_state = 7},
  [2938] = {.lex_state = 206, .external_lex_state = 7},
  [2939] = {.lex_state = 206, .external_lex_state = 7},
  [2940] = {.lex_state = 216},
  [2941] = {.lex_state = 216},
  [2942] = {.lex_state = 206, .external_lex_state = 7},
  [2943] = {.lex_state = 206, .external_lex_state = 7},
  [2944] = {.lex_state = 206, .external_lex_state = 7},
  [2945] = {.lex_state = 206, .external_lex_state = 7},
  [2946] = {.lex_state = 216},
  [2947] = {.lex_state = 216},
  [2948] = {.lex_state = 216},
  [2949] = {.lex_state = 206, .external_lex_state = 7},
  [2950] = {.lex_state = 206, .external_lex_state = 7},
  [2951] = {.lex_state = 206, .external_lex_state = 7},
  [2952] = {.lex_state = 206, .external_lex_state = 7},
  [2953] = {.lex_state = 216},
  [2954] = {.lex_state = 216},
  [2955] = {.lex_state = 216},
  [2956] = {.lex_state = 216},
  [2957] = {.lex_state = 216},
  [2958] = {.lex_state = 216},
  [2959] = {.lex_state = 206, .external_lex_state = 7},
  [2960] = {.lex_state = 206, .external_lex_state = 7},
  [2961] = {.lex_state = 216},
  [2962] = {.lex_state = 217},
  [2963] = {.lex_state = 217},
  [2964] = {.lex_state = 217},
  [2965] = {.lex_state = 206, .external_lex_state = 7},
  [2966] = {.lex_state = 217},
  [2967] = {.lex_state = 216},
  [2968] = {.lex_state = 216},
  [2969] = {.lex_state = 216},
  [2970] = {.lex_state = 216},
  [2971] = {.lex_state = 206, .external_lex_state = 7},
  [2972] = {.lex_state = 216},
  [2973] = {.lex_state = 216},
  [2974] = {.lex_state = 216},
  [2975] = {.lex_state = 217},
  [2976] = {.lex_state = 217},
  [2977] = {.lex_state = 217},
  [2978] = {.lex_state = 217},
  [2979] = {.lex_state = 217},
  [2980] = {.lex_state = 217},
  [2981] = {.lex_state = 217},
  [2982] = {.lex_state = 217},
  [2983] = {.lex_state = 217},
  [2984] = {.lex_state = 206, .external_lex_state = 7},
  [2985] = {.lex_state = 206, .external_lex_state = 7},
  [2986] = {.lex_state = 206, .external_lex_state = 7},
  [2987] = {.lex_state = 206, .external_lex_state = 7},
  [2988] = {.lex_state = 206, .external_lex_state = 7},
  [2989] = {.lex_state = 206, .external_lex_state = 7},
  [2990] = {.lex_state = 206, .external_lex_state = 7},
  [2991] = {.lex_state = 206, .external_lex_state = 7},
  [2992] = {.lex_state = 206, .external_lex_state = 7},
  [2993] = {.lex_state = 217},
  [2994] = {.lex_state = 217},
  [2995] = {.lex_state = 217},
  [2996] = {.lex_state = 217},
  [2997] = {.lex_state = 216},
  [2998] = {.lex_state = 216},
  [2999] = {.lex_state = 216},
  [3000] = {.lex_state = 216},
  [3001] = {.lex_state = 217},
  [3002] = {.lex_state = 206, .external_lex_state = 7},
  [3003] = {.lex_state = 217},
  [3004] = {.lex_state = 217},
  [3005] = {.lex_state = 217},
  [3006] = {.lex_state = 206, .external_lex_state = 7},
  [3007] = {.lex_state = 206, .external_lex_state = 7},
  [3008] = {.lex_state = 216},
  [3009] = {.lex_state = 216},
  [3010] = {.lex_state = 206, .external_lex_state = 7},
  [3011] = {.lex_state = 217},
  [3012] = {.lex_state = 217},
  [3013] = {.lex_state = 217},
  [3014] = {.lex_state = 206, .external_lex_state = 7},
  [3015] = {.lex_state = 206, .external_lex_state = 7},
  [3016] = {.lex_state = 206, .external_lex_state = 7},
  [3017] = {.lex_state = 206, .external_lex_state = 7},
  [3018] = {.lex_state = 216},
  [3019] = {.lex_state = 216},
  [3020] = {.lex_state = 216},
  [3021] = {.lex_state = 206, .external_lex_state = 7},
  [3022] = {.lex_state = 216},
  [3023] = {.lex_state = 206, .external_lex_state = 7},
  [3024] = {.lex_state = 216},
  [3025] = {.lex_state = 216},
  [3026] = {.lex_state = 217},
  [3027] = {.lex_state = 217},
  [3028] = {.lex_state = 217},
  [3029] = {.lex_state = 206, .external_lex_state = 7},
  [3030] = {.lex_state = 206, .external_lex_state = 7},
  [3031] = {.lex_state = 217},
  [3032] = {.lex_state = 217},
  [3033] = {.lex_state = 217},
  [3034] = {.lex_state = 216},
  [3035] = {.lex_state = 217},
  [3036] = {.lex_state = 216},
  [3037] = {.lex_state = 216},
  [3038] = {.lex_state = 216},
  [3039] = {.lex_state = 216},
  [3040] = {.lex_state = 216},
  [3041] = {.lex_state = 216},
  [3042] = {.lex_state = 206, .external_lex_state = 7},
  [3043] = {.lex_state = 206, .external_lex_state = 7},
  [3044] = {.lex_state = 206, .external_lex_state = 7},
  [3045] = {.lex_state = 217},
  [3046] = {.lex_state = 206, .external_lex_state = 7},
  [3047] = {.lex_state = 217},
  [3048] = {.lex_state = 217},
  [3049] = {.lex_state = 217},
  [3050] = {.lex_state = 217},
  [3051] = {.lex_state = 216},
  [3052] = {.lex_state = 217},
  [3053] = {.lex_state = 217},
  [3054] = {.lex_state = 217},
  [3055] = {.lex_state = 216},
  [3056] = {.lex_state = 216},
  [3057] = {.lex_state = 216},
  [3058] = {.lex_state = 216},
  [3059] = {.lex_state = 217},
  [3060] = {.lex_state = 216},
  [3061] = {.lex_state = 216},
  [3062] = {.lex_state = 217},
  [3063] = {.lex_state = 217},
  [3064] = {.lex_state = 217},
  [3065] = {.lex_state = 206, .external_lex_state = 7},
  [3066] = {.lex_state = 217},
  [3067] = {.lex_state = 217},
  [3068] = {.lex_state = 217},
  [3069] = {.lex_state = 206, .external_lex_state = 7},
  [3070] = {.lex_state = 216},
  [3071] = {.lex_state = 216},
  [3072] = {.lex_state = 206, .external_lex_state = 7},
  [3073] = {.lex_state = 206, .external_lex_state = 7},
  [3074] = {.lex_state = 216},
  [3075] = {.lex_state = 217},
  [3076] = {.lex_state = 217},
  [3077] = {.lex_state = 216},
  [3078] = {.lex_state = 206, .external_lex_state = 7},
  [3079] = {.lex_state = 206, .external_lex_state = 7},
  [3080] = {.lex_state = 217},
  [3081] = {.lex_state = 216},
  [3082] = {.lex_state = 206, .external_lex_state = 7},
  [3083] = {.lex_state = 206, .external_lex_state = 7},
  [3084] = {.lex_state = 217},
  [3085] = {.lex_state = 206, .external_lex_state = 7},
  [3086] = {.lex_state = 217},
  [3087] = {.lex_state = 216},
  [3088] = {.lex_state = 216},
  [3089] = {.lex_state = 216},
  [3090] = {.lex_state = 217},
  [3091] = {.lex_state = 217},
  [3092] = {.lex_state = 217},
  [3093] = {.lex_state = 217},
  [3094] = {.lex_state = 206, .external_lex_state = 10},
  [3095] = {.lex_state = 206, .external_lex_state = 9},
  [3096] = {.lex_state = 206, .external_lex_state = 10},
  [3097] = {.lex_state = 206, .external_lex_state = 10},
  [3098] = {.lex_state = 206, .external_lex_state = 9},
  [3099] = {.lex_state = 206, .external_lex_state = 10},
  [3100] = {.lex_state = 206, .external_lex_state = 10},
  [3101] = {.lex_state = 206, .external_lex_state = 9},
  [3102] = {.lex_state = 206, .external_lex_state = 9},
  [3103] = {.lex_state = 206, .external_lex_state = 10},
  [3104] = {.lex_state = 206, .external_lex_state = 9},
  [3105] = {.lex_state = 206, .external_lex_state = 9},
  [3106] = {.lex_state = 206, .external_lex_state = 10},
  [3107] = {.lex_state = 206, .external_lex_state = 10},
  [3108] = {.lex_state = 206, .external_lex_state = 9},
  [3109] = {.lex_state = 206, .external_lex_state = 10},
  [3110] = {.lex_state = 206, .external_lex_state = 9},
  [3111] = {.lex_state = 206, .external_lex_state = 9},
  [3112] = {.lex_state = 206, .external_lex_state = 10},
  [3113] = {.lex_state = 206, .external_lex_state = 10},
  [3114] = {.lex_state = 206, .external_lex_state = 9},
  [3115] = {.lex_state = 206, .external_lex_state = 9},
  [3116] = {.lex_state = 206, .external_lex_state = 10},
  [3117] = {.lex_state = 206, .external_lex_state = 10},
  [3118] = {.lex_state = 206, .external_lex_state = 10},
  [3119] = {.lex_state = 206, .external_lex_state = 9},
  [3120] = {.lex_state = 206, .external_lex_state = 10},
  [3121] = {.lex_state = 206, .external_lex_state = 9},
  [3122] = {.lex_state = 206, .external_lex_state = 10},
  [3123] = {.lex_state = 206, .external_lex_state = 10},
  [3124] = {.lex_state = 206, .external_lex_state = 10},
  [3125] = {.lex_state = 206, .external_lex_state = 10},
  [3126] = {.lex_state = 206, .external_lex_state = 9},
  [3127] = {.lex_state = 206, .external_lex_state = 10},
  [3128] = {.lex_state = 206, .external_lex_state = 10},
  [3129] = {.lex_state = 206, .external_lex_state = 10},
  [3130] = {.lex_state = 206, .external_lex_state = 10},
  [3131] = {.lex_state = 206, .external_lex_state = 10},
  [3132] = {.lex_state = 206, .external_lex_state = 10},
  [3133] = {.lex_state = 206, .external_lex_state = 10},
  [3134] = {.lex_state = 206, .external_lex_state = 9},
  [3135] = {.lex_state = 206, .external_lex_state = 9},
  [3136] = {.lex_state = 206, .external_lex_state = 9},
  [3137] = {.lex_state = 206, .external_lex_state = 9},
  [3138] = {.lex_state = 206, .external_lex_state = 9},
  [3139] = {.lex_state = 206, .external_lex_state = 9},
  [3140] = {.lex_state = 206, .external_lex_state = 9},
  [3141] = {.lex_state = 206, .external_lex_state = 9},
  [3142] = {.lex_state = 206, .external_lex_state = 10},
  [3143] = {.lex_state = 206, .external_lex_state = 9},
  [3144] = {.lex_state = 206, .external_lex_state = 9},
  [3145] = {.lex_state = 206, .external_lex_state = 9},
  [3146] = {.lex_state = 206, .external_lex_state = 9},
  [3147] = {.lex_state = 206, .external_lex_state = 9},
  [3148] = {.lex_state = 206, .external_lex_state = 10},
  [3149] = {.lex_state = 206, .external_lex_state = 10},
  [3150] = {.lex_state = 206, .external_lex_state = 9},
  [3151] = {.lex_state = 206, .external_lex_state = 10},
  [3152] = {.lex_state = 206, .external_lex_state = 9},
  [3153] = {.lex_state = 206, .external_lex_state = 10},
  [3154] = {.lex_state = 206, .external_lex_state = 9},
  [3155] = {.lex_state = 206, .external_lex_state = 10},
  [3156] = {.lex_state = 206, .external_lex_state = 9},
  [3157] = {.lex_state = 206, .external_lex_state = 9},
  [3158] = {.lex_state = 206, .external_lex_state = 10},
  [3159] = {.lex_state = 206, .external_lex_state = 9},
  [3160] = {.lex_state = 206, .external_lex_state = 9},
  [3161] = {.lex_state = 206, .external_lex_state = 10},
  [3162] = {.lex_state = 206, .external_lex_state = 9},
  [3163] = {.lex_state = 206, .external_lex_state = 10},
  [3164] = {.lex_state = 206, .external_lex_state = 10},
  [3165] = {.lex_state = 206, .external_lex_state = 9},
  [3166] = {.lex_state = 206, .external_lex_state = 9},
  [3167] = {.lex_state = 206, .external_lex_state = 10},
  [3168] = {.lex_state = 206, .external_lex_state = 10},
  [3169] = {.lex_state = 206, .external_lex_state = 9},
  [3170] = {.lex_state = 206, .external_lex_state = 9},
  [3171] = {.lex_state = 206, .external_lex_state = 9},
  [3172] = {.lex_state = 206, .external_lex_state = 9},
  [3173] = {.lex_state = 206, .external_lex_state = 9},
  [3174] = {.lex_state = 206, .external_lex_state = 9},
  [3175] = {.lex_state = 206, .external_lex_state = 10},
  [3176] = {.lex_state = 206, .external_lex_state = 10},
  [3177] = {.lex_state = 206, .external_lex_state = 10},
  [3178] = {.lex_state = 206, .external_lex_state = 10},
  [3179] = {.lex_state = 206, .external_lex_state = 10},
  [3180] = {.lex_state = 206, .external_lex_state = 10},
  [3181] = {.lex_state = 206, .external_lex_state = 10},
  [3182] = {.lex_state = 206, .external_lex_state = 10},
  [3183] = {.lex_state = 206, .external_lex_state = 10},
  [3184] = {.lex_state = 206, .external_lex_state = 10},
  [3185] = {.lex_state = 206, .external_lex_state = 10},
  [3186] = {.lex_state = 206, .external_lex_state = 10},
  [3187] = {.lex_state = 206, .external_lex_state = 10},
  [3188] = {.lex_state = 206, .external_lex_state = 10},
  [3189] = {.lex_state = 206, .external_lex_state = 9},
  [3190] = {.lex_state = 206, .external_lex_state = 9},
  [3191] = {.lex_state = 206, .external_lex_state = 9},
  [3192] = {.lex_state = 206, .external_lex_state = 9},
  [3193] = {.lex_state = 206, .external_lex_state = 10},
  [3194] = {.lex_state = 206, .external_lex_state = 10},
  [3195] = {.lex_state = 206, .external_lex_state = 9},
  [3196] = {.lex_state = 206, .external_lex_state = 9},
  [3197] = {.lex_state = 206, .external_lex_state = 9},
  [3198] = {.lex_state = 206, .external_lex_state = 9},
  [3199] = {.lex_state = 206, .external_lex_state = 10},
  [3200] = {.lex_state = 206, .external_lex_state = 9},
  [3201] = {.lex_state = 206, .external_lex_state = 9},
  [3202] = {.lex_state = 206, .external_lex_state = 9},
  [3203] = {.lex_state = 206, .external_lex_state = 10},
  [3204] = {.lex_state = 206, .external_lex_state = 9},
  [3205] = {.lex_state = 206, .external_lex_state = 9},
  [3206] = {.lex_state = 206, .external_lex_state = 9},
  [3207] = {.lex_state = 206, .external_lex_state = 10},
  [3208] = {.lex_state = 206, .external_lex_state = 10},
  [3209] = {.lex_state = 206, .external_lex_state = 9},
  [3210] = {.lex_state = 206, .external_lex_state = 9},
  [3211] = {.lex_state = 206, .external_lex_state = 9},
  [3212] = {.lex_state = 206, .external_lex_state = 9},
  [3213] = {.lex_state = 206, .external_lex_state = 9},
  [3214] = {.lex_state = 206, .external_lex_state = 9},
  [3215] = {.lex_state = 206, .external_lex_state = 9},
  [3216] = {.lex_state = 206, .external_lex_state = 10},
  [3217] = {.lex_state = 206, .external_lex_state = 9},
  [3218] = {.lex_state = 206, .external_lex_state = 10},
  [3219] = {.lex_state = 206, .external_lex_state = 10},
  [3220] = {.lex_state = 206, .external_lex_state = 10},
  [3221] = {.lex_state = 206, .external_lex_state = 10},
  [3222] = {.lex_state = 206, .external_lex_state = 9},
  [3223] = {.lex_state = 206, .external_lex_state = 10},
  [3224] = {.lex_state = 206, .external_lex_state = 10},
  [3225] = {.lex_state = 206, .external_lex_state = 10},
  [3226] = {.lex_state = 223},
  [3227] = {.lex_state = 223},
  [3228] = {.lex_state = 223},
  [3229] = {.lex_state = 223},
  [3230] = {.lex_state = 223},
  [3231] = {.lex_state = 223},
  [3232] = {.lex_state = 223},
  [3233] = {.lex_state = 223},
  [3234] = {.lex_state = 223},
  [3235] = {.lex_state = 223},
  [3236] = {.lex_state = 223},
  [3237] = {.lex_state = 223},
  [3238] = {.lex_state = 223},
  [3239] = {.lex_state = 223},
  [3240] = {.lex_state = 223},
  [3241] = {.lex_state = 223},
  [3242] = {.lex_state = 223},
  [3243] = {.lex_state = 223},
  [3244] = {.lex_state = 223},
  [3245] = {.lex_state = 223},
  [3246] = {.lex_state = 223},
  [3247] = {.lex_state = 223},
  [3248] = {.lex_state = 223},
  [3249] = {.lex_state = 223},
  [3250] = {.lex_state = 223},
  [3251] = {.lex_state = 223},
  [3252] = {.lex_state = 223},
  [3253] = {.lex_state = 223},
  [3254] = {.lex_state = 223},
  [3255] = {.lex_state = 223},
  [3256] = {.lex_state = 223},
  [3257] = {.lex_state = 223},
  [3258] = {.lex_state = 223},
  [3259] = {.lex_state = 223},
  [3260] = {.lex_state = 223},
  [3261] = {.lex_state = 223},
  [3262] = {.lex_state = 223},
  [3263] = {.lex_state = 223},
  [3264] = {.lex_state = 223},
  [3265] = {.lex_state = 223},
  [3266] = {.lex_state = 223},
  [3267] = {.lex_state = 223},
  [3268] = {.lex_state = 223},
  [3269] = {.lex_state = 223},
  [3270] = {.lex_state = 223},
  [3271] = {.lex_state = 223},
  [3272] = {.lex_state = 223},
  [3273] = {.lex_state = 223},
  [3274] = {.lex_state = 223},
  [3275] = {.lex_state = 223},
  [3276] = {.lex_state = 223},
  [3277] = {.lex_state = 223},
  [3278] = {.lex_state = 223},
  [3279] = {.lex_state = 223},
  [3280] = {.lex_state = 223},
  [3281] = {.lex_state = 223},
  [3282] = {.lex_state = 223},
  [3283] = {.lex_state = 223},
  [3284] = {.lex_state = 223},
  [3285] = {.lex_state = 223},
  [3286] = {.lex_state = 223},
  [3287] = {.lex_state = 223},
  [3288] = {.lex_state = 223},
  [3289] = {.lex_state = 223},
  [3290] = {.lex_state = 223},
  [3291] = {.lex_state = 223},
  [3292] = {.lex_state = 223},
  [3293] = {.lex_state = 223},
  [3294] = {.lex_state = 223},
  [3295] = {.lex_state = 223},
  [3296] = {.lex_state = 223},
  [3297] = {.lex_state = 223, .external_lex_state = 6},
  [3298] = {.lex_state = 223, .external_lex_state = 6},
  [3299] = {.lex_state = 223, .external_lex_state = 6},
  [3300] = {.lex_state = 223},
  [3301] = {.lex_state = 223},
  [3302] = {.lex_state = 223},
  [3303] = {.lex_state = 223},
  [3304] = {.lex_state = 225},
  [3305] = {.lex_state = 223},
  [3306] = {.lex_state = 223},
  [3307] = {.lex_state = 223},
  [3308] = {.lex_state = 223},
  [3309] = {.lex_state = 223},
  [3310] = {.lex_state = 223},
  [3311] = {.lex_state = 223},
  [3312] = {.lex_state = 223},
  [3313] = {.lex_state = 223},
  [3314] = {.lex_state = 223},
  [3315] = {.lex_state = 223},
  [3316] = {.lex_state = 223},
  [3317] = {.lex_state = 223},
  [3318] = {.lex_state = 223},
  [3319] = {.lex_state = 223},
  [3320] = {.lex_state = 223},
  [3321] = {.lex_state = 223},
  [3322] = {.lex_state = 223},
  [3323] = {.lex_state = 223},
  [3324] = {.lex_state = 223},
  [3325] = {.lex_state = 223},
  [3326] = {.lex_state = 223},
  [3327] = {.lex_state = 223},
  [3328] = {.lex_state = 223},
  [3329] = {.lex_state = 223},
  [3330] = {.lex_state = 223},
  [3331] = {.lex_state = 223},
  [3332] = {.lex_state = 223},
  [3333] = {.lex_state = 223},
  [3334] = {.lex_state = 223},
  [3335] = {.lex_state = 223},
  [3336] = {.lex_state = 223},
  [3337] = {.lex_state = 223},
  [3338] = {.lex_state = 223},
  [3339] = {.lex_state = 223},
  [3340] = {.lex_state = 223},
  [3341] = {.lex_state = 223},
  [3342] = {.lex_state = 223},
  [3343] = {.lex_state = 223},
  [3344] = {.lex_state = 223},
  [3345] = {.lex_state = 223},
  [3346] = {.lex_state = 223},
  [3347] = {.lex_state = 223},
  [3348] = {.lex_state = 223},
  [3349] = {.lex_state = 201},
  [3350] = {.lex_state = 223},
  [3351] = {.lex_state = 223},
  [3352] = {.lex_state = 223},
  [3353] = {.lex_state = 201},
  [3354] = {.lex_state = 223},
  [3355] = {.lex_state = 223},
  [3356] = {.lex_state = 223},
  [3357] = {.lex_state = 223},
  [3358] = {.lex_state = 223},
  [3359] = {.lex_state = 223},
  [3360] = {.lex_state = 223},
  [3361] = {.lex_state = 223},
  [3362] = {.lex_state = 223},
  [3363] = {.lex_state = 223},
  [3364] = {.lex_state = 223},
  [3365] = {.lex_state = 223},
  [3366] = {.lex_state = 223},
  [3367] = {.lex_state = 223},
  [3368] = {.lex_state = 223},
  [3369] = {.lex_state = 223},
  [3370] = {.lex_state = 223},
  [3371] = {.lex_state = 223},
  [3372] = {.lex_state = 223},
  [3373] = {.lex_state = 223},
  [3374] = {.lex_state = 201},
  [3375] = {.lex_state = 201},
  [3376] = {.lex_state = 223},
  [3377] = {.lex_state = 201},
  [3378] = {.lex_state = 201},
  [3379] = {.lex_state = 201},
  [3380] = {.lex_state = 201},
  [3381] = {.lex_state = 201},
  [3382] = {.lex_state = 201},
  [3383] = {.lex_state = 201},
  [3384] = {.lex_state = 201},
  [3385] = {.lex_state = 201},
  [3386] = {.lex_state = 201},
  [3387] = {.lex_state = 201},
  [3388] = {.lex_state = 201},
  [3389] = {.lex_state = 201},
  [3390] = {.lex_state = 223},
  [3391] = {.lex_state = 201},
  [3392] = {.lex_state = 201},
  [3393] = {.lex_state = 223},
  [3394] = {.lex_state = 223},
  [3395] = {.lex_state = 223},
  [3396] = {.lex_state = 223},
  [3397] = {.lex_state = 223},
  [3398] = {.lex_state = 223},
  [3399] = {.lex_state = 223},
  [3400] = {.lex_state = 223},
  [3401] = {.lex_state = 201},
  [3402] = {.lex_state = 223},
  [3403] = {.lex_state = 223},
  [3404] = {.lex_state = 223},
  [3405] = {.lex_state = 223},
  [3406] = {.lex_state = 223},
  [3407] = {.lex_state = 223},
  [3408] = {.lex_state = 223},
  [3409] = {.lex_state = 223},
  [3410] = {.lex_state = 201},
  [3411] = {.lex_state = 223},
  [3412] = {.lex_state = 223},
  [3413] = {.lex_state = 223},
  [3414] = {.lex_state = 223},
  [3415] = {.lex_state = 223},
  [3416] = {.lex_state = 223},
  [3417] = {.lex_state = 223},
  [3418] = {.lex_state = 223},
  [3419] = {.lex_state = 201},
  [3420] = {.lex_state = 223},
  [3421] = {.lex_state = 223},
  [3422] = {.lex_state = 223},
  [3423] = {.lex_state = 223},
  [3424] = {.lex_state = 223},
  [3425] = {.lex_state = 223},
  [3426] = {.lex_state = 223},
  [3427] = {.lex_state = 223},
  [3428] = {.lex_state = 223},
  [3429] = {.lex_state = 223},
  [3430] = {.lex_state = 223, .external_lex_state = 7},
  [3431] = {.lex_state = 223, .external_lex_state = 7},
  [3432] = {.lex_state = 223, .external_lex_state = 7},
  [3433] = {.lex_state = 201},
  [3434] = {.lex_state = 223},
  [3435] = {.lex_state = 223},
  [3436] = {.lex_state = 223},
  [3437] = {.lex_state = 223},
  [3438] = {.lex_state = 223},
  [3439] = {.lex_state = 223},
  [3440] = {.lex_state = 223},
  [3441] = {.lex_state = 223},
  [3442] = {.lex_state = 223},
  [3443] = {.lex_state = 223},
  [3444] = {.lex_state = 223},
  [3445] = {.lex_state = 223},
  [3446] = {.lex_state = 223},
  [3447] = {.lex_state = 227},
  [3448] = {.lex_state = 227},
  [3449] = {.lex_state = 223},
  [3450] = {.lex_state = 225},
  [3451] = {.lex_state = 223},
  [3452] = {.lex_state = 225},
  [3453] = {.lex_state = 223},
  [3454] = {.lex_state = 223},
  [3455] = {.lex_state = 223},
  [3456] = {.lex_state = 223},
  [3457] = {.lex_state = 201},
  [3458] = {.lex_state = 223},
  [3459] = {.lex_state = 223},
  [3460] = {.lex_state = 223},
  [3461] = {.lex_state = 223},
  [3462] = {.lex_state = 223},
  [3463] = {.lex_state = 223},
  [3464] = {.lex_state = 223},
  [3465] = {.lex_state = 223},
  [3466] = {.lex_state = 223},
  [3467] = {.lex_state = 223},
  [3468] = {.lex_state = 223},
  [3469] = {.lex_state = 223},
  [3470] = {.lex_state = 225, .external_lex_state = 7},
  [3471] = {.lex_state = 223},
  [3472] = {.lex_state = 223},
  [3473] = {.lex_state = 223},
  [3474] = {.lex_state = 223},
  [3475] = {.lex_state = 223},
  [3476] = {.lex_state = 223},
  [3477] = {.lex_state = 223},
  [3478] = {.lex_state = 223},
  [3479] = {.lex_state = 223},
  [3480] = {.lex_state = 223},
  [3481] = {.lex_state = 223},
  [3482] = {.lex_state = 223},
  [3483] = {.lex_state = 223},
  [3484] = {.lex_state = 223},
  [3485] = {.lex_state = 223},
  [3486] = {.lex_state = 223},
  [3487] = {.lex_state = 223},
  [3488] = {.lex_state = 223},
  [3489] = {.lex_state = 223},
  [3490] = {.lex_state = 223},
  [3491] = {.lex_state = 223},
  [3492] = {.lex_state = 223},
  [3493] = {.lex_state = 223},
  [3494] = {.lex_state = 223},
  [3495] = {.lex_state = 223},
  [3496] = {.lex_state = 223, .external_lex_state = 7},
  [3497] = {.lex_state = 223},
  [3498] = {.lex_state = 223},
  [3499] = {.lex_state = 223},
  [3500] = {.lex_state = 223},
  [3501] = {.lex_state = 223},
  [3502] = {.lex_state = 223},
  [3503] = {.lex_state = 223},
  [3504] = {.lex_state = 223},
  [3505] = {.lex_state = 223},
  [3506] = {.lex_state = 223},
  [3507] = {.lex_state = 223},
  [3508] = {.lex_state = 223},
  [3509] = {.lex_state = 223},
  [3510] = {.lex_state = 223},
  [3511] = {.lex_state = 223},
  [3512] = {.lex_state = 223},
  [3513] = {.lex_state = 223},
  [3514] = {.lex_state = 223},
  [3515] = {.lex_state = 223},
  [3516] = {.lex_state = 223},
  [3517] = {.lex_state = 223},
  [3518] = {.lex_state = 223},
  [3519] = {.lex_state = 223},
  [3520] = {.lex_state = 223},
  [3521] = {.lex_state = 223},
  [3522] = {.lex_state = 223},
  [3523] = {.lex_state = 223, .external_lex_state = 7},
  [3524] = {.lex_state = 223, .external_lex_state = 7},
  [3525] = {.lex_state = 223, .external_lex_state = 7},
  [3526] = {.lex_state = 223, .external_lex_state = 7},
  [3527] = {.lex_state = 223, .external_lex_state = 7},
  [3528] = {.lex_state = 223},
  [3529] = {.lex_state = 223, .external_lex_state = 7},
  [3530] = {.lex_state = 223, .external_lex_state = 7},
  [3531] = {.lex_state = 223, .external_lex_state = 7},
  [3532] = {.lex_state = 223, .external_lex_state = 7},
  [3533] = {.lex_state = 223, .external_lex_state = 7},
  [3534] = {.lex_state = 223, .external_lex_state = 7},
  [3535] = {.lex_state = 223, .external_lex_state = 7},
  [3536] = {.lex_state = 223, .external_lex_state = 7},
  [3537] = {.lex_state = 223, .external_lex_state = 7},
  [3538] = {.lex_state = 223, .external_lex_state = 7},
  [3539] = {.lex_state = 223, .external_lex_state = 7},
  [3540] = {.lex_state = 223, .external_lex_state = 7},
  [3541] = {.lex_state = 223, .external_lex_state = 7},
  [3542] = {.lex_state = 223, .external_lex_state = 7},
  [3543] = {.lex_state = 223, .external_lex_state = 7},
  [3544] = {.lex_state = 223, .external_lex_state = 7},
  [3545] = {.lex_state = 223},
  [3546] = {.lex_state = 223, .external_lex_state = 7},
  [3547] = {.lex_state = 223, .external_lex_state = 7},
  [3548] = {.lex_state = 223, .external_lex_state = 7},
  [3549] = {.lex_state = 223, .external_lex_state = 7},
  [3550] = {.lex_state = 223, .external_lex_state = 7},
  [3551] = {.lex_state = 223, .external_lex_state = 7},
  [3552] = {.lex_state = 223, .external_lex_state = 7},
  [3553] = {.lex_state = 223},
  [3554] = {.lex_state = 223, .external_lex_state = 7},
  [3555] = {.lex_state = 223, .external_lex_state = 7},
  [3556] = {.lex_state = 223, .external_lex_state = 7},
  [3557] = {.lex_state = 223, .external_lex_state = 7},
  [3558] = {.lex_state = 223, .external_lex_state = 7},
  [3559] = {.lex_state = 223, .external_lex_state = 7},
  [3560] = {.lex_state = 223, .external_lex_state = 7},
  [3561] = {.lex_state = 223, .external_lex_state = 7},
  [3562] = {.lex_state = 223, .external_lex_state = 7},
  [3563] = {.lex_state = 223, .external_lex_state = 7},
  [3564] = {.lex_state = 223, .external_lex_state = 7},
  [3565] = {.lex_state = 201},
  [3566] = {.lex_state = 223, .external_lex_state = 7},
  [3567] = {.lex_state = 223},
  [3568] = {.lex_state = 223, .external_lex_state = 7},
  [3569] = {.lex_state = 223, .external_lex_state = 7},
  [3570] = {.lex_state = 223, .external_lex_state = 7},
  [3571] = {.lex_state = 223, .external_lex_state = 7},
  [3572] = {.lex_state = 223, .external_lex_state = 7},
  [3573] = {.lex_state = 223, .external_lex_state = 7},
  [3574] = {.lex_state = 223},
  [3575] = {.lex_state = 223},
  [3576] = {.lex_state = 223, .external_lex_state = 7},
  [3577] = {.lex_state = 223, .external_lex_state = 7},
  [3578] = {.lex_state = 223, .external_lex_state = 7},
  [3579] = {.lex_state = 223, .external_lex_state = 7},
  [3580] = {.lex_state = 223},
  [3581] = {.lex_state = 223, .external_lex_state = 7},
  [3582] = {.lex_state = 223, .external_lex_state = 7},
  [3583] = {.lex_state = 223, .external_lex_state = 7},
  [3584] = {.lex_state = 223, .external_lex_state = 7},
  [3585] = {.lex_state = 223, .external_lex_state = 7},
  [3586] = {.lex_state = 223, .external_lex_state = 7},
  [3587] = {.lex_state = 223, .external_lex_state = 7},
  [3588] = {.lex_state = 223, .external_lex_state = 7},
  [3589] = {.lex_state = 223},
  [3590] = {.lex_state = 223, .external_lex_state = 7},
  [3591] = {.lex_state = 223, .external_lex_state = 7},
  [3592] = {.lex_state = 223, .external_lex_state = 7},
  [3593] = {.lex_state = 223, .external_lex_state = 7},
  [3594] = {.lex_state = 223, .external_lex_state = 7},
  [3595] = {.lex_state = 223, .external_lex_state = 7},
  [3596] = {.lex_state = 223},
  [3597] = {.lex_state = 223, .external_lex_state = 7},
  [3598] = {.lex_state = 223},
  [3599] = {.lex_state = 223},
  [3600] = {.lex_state = 223, .external_lex_state = 7},
  [3601] = {.lex_state = 223, .external_lex_state = 7},
  [3602] = {.lex_state = 223},
  [3603] = {.lex_state = 223},
  [3604] = {.lex_state = 223},
  [3605] = {.lex_state = 223},
  [3606] = {.lex_state = 223},
  [3607] = {.lex_state = 223},
  [3608] = {.lex_state = 223},
  [3609] = {.lex_state = 223},
  [3610] = {.lex_state = 223},
  [3611] = {.lex_state = 223},
  [3612] = {.lex_state = 223},
  [3613] = {.lex_state = 223},
  [3614] = {.lex_state = 223, .external_lex_state = 7},
  [3615] = {.lex_state = 223},
  [3616] = {.lex_state = 201},
  [3617] = {.lex_state = 223},
  [3618] = {.lex_state = 223, .external_lex_state = 7},
  [3619] = {.lex_state = 223, .external_lex_state = 7},
  [3620] = {.lex_state = 201},
  [3621] = {.lex_state = 223, .external_lex_state = 7},
  [3622] = {.lex_state = 223},
  [3623] = {.lex_state = 223, .external_lex_state = 7},
  [3624] = {.lex_state = 223, .external_lex_state = 7},
  [3625] = {.lex_state = 228},
  [3626] = {.lex_state = 201},
  [3627] = {.lex_state = 223},
  [3628] = {.lex_state = 223, .external_lex_state = 7},
  [3629] = {.lex_state = 223, .external_lex_state = 7},
  [3630] = {.lex_state = 223, .external_lex_state = 7},
  [3631] = {.lex_state = 201},
  [3632] = {.lex_state = 223, .external_lex_state = 7},
  [3633] = {.lex_state = 201},
  [3634] = {.lex_state = 201},
  [3635] = {.lex_state = 201},
  [3636] = {.lex_state = 201},
  [3637] = {.lex_state = 201},
  [3638] = {.lex_state = 201},
  [3639] = {.lex_state = 201},
  [3640] = {.lex_state = 201},
  [3641] = {.lex_state = 201},
  [3642] = {.lex_state = 201},
  [3643] = {.lex_state = 201},
  [3644] = {.lex_state = 201},
  [3645] = {.lex_state = 228},
  [3646] = {.lex_state = 229},
  [3647] = {.lex_state = 229},
  [3648] = {.lex_state = 229},
  [3649] = {.lex_state = 201},
  [3650] = {.lex_state = 201},
  [3651] = {.lex_state = 201},
  [3652] = {.lex_state = 201},
  [3653] = {.lex_state = 201},
  [3654] = {.lex_state = 201},
  [3655] = {.lex_state = 201},
  [3656] = {.lex_state = 201},
  [3657] = {.lex_state = 201},
  [3658] = {.lex_state = 201},
  [3659] = {.lex_state = 201},
  [3660] = {.lex_state = 201},
  [3661] = {.lex_state = 201},
  [3662] = {.lex_state = 0, .external_lex_state = 8},
  [3663] = {.lex_state = 201},
  [3664] = {.lex_state = 0, .external_lex_state = 8},
  [3665] = {.lex_state = 201},
  [3666] = {.lex_state = 201},
  [3667] = {.lex_state = 201},
  [3668] = {.lex_state = 201},
  [3669] = {.lex_state = 201},
  [3670] = {.lex_state = 201},
  [3671] = {.lex_state = 0, .external_lex_state = 8},
  [3672] = {.lex_state = 201},
  [3673] = {.lex_state = 201},
  [3674] = {.lex_state = 201},
  [3675] = {.lex_state = 201},
  [3676] = {.lex_state = 201},
  [3677] = {.lex_state = 201},
  [3678] = {.lex_state = 201},
  [3679] = {.lex_state = 201},
  [3680] = {.lex_state = 201},
  [3681] = {.lex_state = 201},
  [3682] = {.lex_state = 201},
  [3683] = {.lex_state = 201},
  [3684] = {.lex_state = 223},
  [3685] = {.lex_state = 229},
  [3686] = {.lex_state = 201},
  [3687] = {.lex_state = 229},
  [3688] = {.lex_state = 201},
  [3689] = {.lex_state = 201},
  [3690] = {.lex_state = 229},
  [3691] = {.lex_state = 201},
  [3692] = {.lex_state = 201},
  [3693] = {.lex_state = 201},
  [3694] = {.lex_state = 201},
  [3695] = {.lex_state = 201},
  [3696] = {.lex_state = 201},
  [3697] = {.lex_state = 201},
  [3698] = {.lex_state = 201},
  [3699] = {.lex_state = 229},
  [3700] = {.lex_state = 229},
  [3701] = {.lex_state = 229},
  [3702] = {.lex_state = 201},
  [3703] = {.lex_state = 201},
  [3704] = {.lex_state = 201},
  [3705] = {.lex_state = 201},
  [3706] = {.lex_state = 201},
  [3707] = {.lex_state = 201},
  [3708] = {.lex_state = 201},
  [3709] = {.lex_state = 201},
  [3710] = {.lex_state = 201},
  [3711] = {.lex_state = 201},
  [3712] = {.lex_state = 201},
  [3713] = {.lex_state = 201},
  [3714] = {.lex_state = 225},
  [3715] = {.lex_state = 201},
  [3716] = {.lex_state = 201},
  [3717] = {.lex_state = 201},
  [3718] = {.lex_state = 201},
  [3719] = {.lex_state = 229},
  [3720] = {.lex_state = 201},
  [3721] = {.lex_state = 201},
  [3722] = {.lex_state = 201},
  [3723] = {.lex_state = 201},
  [3724] = {.lex_state = 201},
  [3725] = {.lex_state = 223},
  [3726] = {.lex_state = 203},
  [3727] = {.lex_state = 0},
  [3728] = {.lex_state = 223},
  [3729] = {.lex_state = 223},
  [3730] = {.lex_state = 203},
  [3731] = {.lex_state = 0},
  [3732] = {.lex_state = 223},
  [3733] = {.lex_state = 0},
  [3734] = {.lex_state = 223},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 203},
  [3738] = {.lex_state = 229},
  [3739] = {.lex_state = 0},
  [3740] = {.lex_state = 0},
  [3741] = {.lex_state = 223},
  [3742] = {.lex_state = 203},
  [3743] = {.lex_state = 203},
  [3744] = {.lex_state = 203},
  [3745] = {.lex_state = 0},
  [3746] = {.lex_state = 0},
  [3747] = {.lex_state = 203},
  [3748] = {.lex_state = 203},
  [3749] = {.lex_state = 203},
  [3750] = {.lex_state = 0},
  [3751] = {.lex_state = 0},
  [3752] = {.lex_state = 201},
  [3753] = {.lex_state = 201},
  [3754] = {.lex_state = 201},
  [3755] = {.lex_state = 0},
  [3756] = {.lex_state = 203},
  [3757] = {.lex_state = 0},
  [3758] = {.lex_state = 203},
  [3759] = {.lex_state = 223},
  [3760] = {.lex_state = 223},
  [3761] = {.lex_state = 223},
  [3762] = {.lex_state = 223},
  [3763] = {.lex_state = 201},
  [3764] = {.lex_state = 0, .external_lex_state = 11},
  [3765] = {.lex_state = 223},
  [3766] = {.lex_state = 0},
  [3767] = {.lex_state = 201},
  [3768] = {.lex_state = 201},
  [3769] = {.lex_state = 229},
  [3770] = {.lex_state = 201},
  [3771] = {.lex_state = 223, .external_lex_state = 7},
  [3772] = {.lex_state = 223},
  [3773] = {.lex_state = 201},
  [3774] = {.lex_state = 0, .external_lex_state = 11},
  [3775] = {.lex_state = 223},
  [3776] = {.lex_state = 223},
  [3777] = {.lex_state = 223},
  [3778] = {.lex_state = 223},
  [3779] = {.lex_state = 203},
  [3780] = {.lex_state = 223},
  [3781] = {.lex_state = 223},
  [3782] = {.lex_state = 201},
  [3783] = {.lex_state = 0, .external_lex_state = 11},
  [3784] = {.lex_state = 223},
  [3785] = {.lex_state = 223},
  [3786] = {.lex_state = 223},
  [3787] = {.lex_state = 203},
  [3788] = {.lex_state = 0},
  [3789] = {.lex_state = 201},
  [3790] = {.lex_state = 0, .external_lex_state = 11},
  [3791] = {.lex_state = 0},
  [3792] = {.lex_state = 223},
  [3793] = {.lex_state = 223},
  [3794] = {.lex_state = 223},
  [3795] = {.lex_state = 223},
  [3796] = {.lex_state = 229},
  [3797] = {.lex_state = 223},
  [3798] = {.lex_state = 201},
  [3799] = {.lex_state = 0, .external_lex_state = 11},
  [3800] = {.lex_state = 0},
  [3801] = {.lex_state = 229},
  [3802] = {.lex_state = 0},
  [3803] = {.lex_state = 203},
  [3804] = {.lex_state = 229},
  [3805] = {.lex_state = 0},
  [3806] = {.lex_state = 203},
  [3807] = {.lex_state = 201},
  [3808] = {.lex_state = 0, .external_lex_state = 11},
  [3809] = {.lex_state = 229},
  [3810] = {.lex_state = 229},
  [3811] = {.lex_state = 201},
  [3812] = {.lex_state = 223},
  [3813] = {.lex_state = 0, .external_lex_state = 11},
  [3814] = {.lex_state = 201},
  [3815] = {.lex_state = 223},
  [3816] = {.lex_state = 201},
  [3817] = {.lex_state = 223},
  [3818] = {.lex_state = 0, .external_lex_state = 11},
  [3819] = {.lex_state = 223},
  [3820] = {.lex_state = 223},
  [3821] = {.lex_state = 0},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 223, .external_lex_state = 7},
  [3824] = {.lex_state = 223},
  [3825] = {.lex_state = 0},
  [3826] = {.lex_state = 0},
  [3827] = {.lex_state = 203},
  [3828] = {.lex_state = 223},
  [3829] = {.lex_state = 201},
  [3830] = {.lex_state = 223},
  [3831] = {.lex_state = 0, .external_lex_state = 11},
  [3832] = {.lex_state = 0},
  [3833] = {.lex_state = 201},
  [3834] = {.lex_state = 229},
  [3835] = {.lex_state = 201},
  [3836] = {.lex_state = 225},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 223},
  [3839] = {.lex_state = 223},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 0, .external_lex_state = 11},
  [3842] = {.lex_state = 223},
  [3843] = {.lex_state = 201},
  [3844] = {.lex_state = 0, .external_lex_state = 11},
  [3845] = {.lex_state = 201},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 201},
  [3848] = {.lex_state = 0},
  [3849] = {.lex_state = 0},
  [3850] = {.lex_state = 229},
  [3851] = {.lex_state = 223},
  [3852] = {.lex_state = 0},
  [3853] = {.lex_state = 201},
  [3854] = {.lex_state = 0, .external_lex_state = 11},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 203},
  [3857] = {.lex_state = 223},
  [3858] = {.lex_state = 229},
  [3859] = {.lex_state = 223},
  [3860] = {.lex_state = 201},
  [3861] = {.lex_state = 201},
  [3862] = {.lex_state = 0, .external_lex_state = 11},
  [3863] = {.lex_state = 203},
  [3864] = {.lex_state = 223},
  [3865] = {.lex_state = 201},
  [3866] = {.lex_state = 223},
  [3867] = {.lex_state = 229},
  [3868] = {.lex_state = 201},
  [3869] = {.lex_state = 0, .external_lex_state = 11},
  [3870] = {.lex_state = 229},
  [3871] = {.lex_state = 201},
  [3872] = {.lex_state = 229},
  [3873] = {.lex_state = 229},
  [3874] = {.lex_state = 201},
  [3875] = {.lex_state = 0, .external_lex_state = 11},
  [3876] = {.lex_state = 0},
  [3877] = {.lex_state = 223},
  [3878] = {.lex_state = 223},
  [3879] = {.lex_state = 231},
  [3880] = {.lex_state = 201},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 231},
  [3883] = {.lex_state = 223},
  [3884] = {.lex_state = 201},
  [3885] = {.lex_state = 3},
  [3886] = {.lex_state = 3},
  [3887] = {.lex_state = 223},
  [3888] = {.lex_state = 201},
  [3889] = {.lex_state = 0},
  [3890] = {.lex_state = 201},
  [3891] = {.lex_state = 3},
  [3892] = {.lex_state = 201},
  [3893] = {.lex_state = 201},
  [3894] = {.lex_state = 201},
  [3895] = {.lex_state = 3},
  [3896] = {.lex_state = 223},
  [3897] = {.lex_state = 201},
  [3898] = {.lex_state = 201},
  [3899] = {.lex_state = 201},
  [3900] = {.lex_state = 201},
  [3901] = {.lex_state = 201},
  [3902] = {.lex_state = 225, .external_lex_state = 7},
  [3903] = {.lex_state = 231},
  [3904] = {.lex_state = 3},
  [3905] = {.lex_state = 201},
  [3906] = {.lex_state = 3},
  [3907] = {.lex_state = 3},
  [3908] = {.lex_state = 225},
  [3909] = {.lex_state = 3},
  [3910] = {.lex_state = 3},
  [3911] = {.lex_state = 201},
  [3912] = {.lex_state = 201},
  [3913] = {.lex_state = 201, .external_lex_state = 7},
  [3914] = {.lex_state = 3},
  [3915] = {.lex_state = 3},
  [3916] = {.lex_state = 3},
  [3917] = {.lex_state = 3},
  [3918] = {.lex_state = 223},
  [3919] = {.lex_state = 0},
  [3920] = {.lex_state = 201, .external_lex_state = 7},
  [3921] = {.lex_state = 3},
  [3922] = {.lex_state = 201},
  [3923] = {.lex_state = 223},
  [3924] = {.lex_state = 223, .external_lex_state = 7},
  [3925] = {.lex_state = 201, .external_lex_state = 7},
  [3926] = {.lex_state = 203},
  [3927] = {.lex_state = 201},
  [3928] = {.lex_state = 0, .external_lex_state = 2},
  [3929] = {.lex_state = 201},
  [3930] = {.lex_state = 201},
  [3931] = {.lex_state = 3},
  [3932] = {.lex_state = 201},
  [3933] = {.lex_state = 3},
  [3934] = {.lex_state = 201},
  [3935] = {.lex_state = 3},
  [3936] = {.lex_state = 3},
  [3937] = {.lex_state = 3},
  [3938] = {.lex_state = 201},
  [3939] = {.lex_state = 201},
  [3940] = {.lex_state = 3},
  [3941] = {.lex_state = 3},
  [3942] = {.lex_state = 3},
  [3943] = {.lex_state = 201},
  [3944] = {.lex_state = 3},
  [3945] = {.lex_state = 201},
  [3946] = {.lex_state = 201},
  [3947] = {.lex_state = 3},
  [3948] = {.lex_state = 201},
  [3949] = {.lex_state = 201},
  [3950] = {.lex_state = 201},
  [3951] = {.lex_state = 3},
  [3952] = {.lex_state = 231, .external_lex_state = 7},
  [3953] = {.lex_state = 223},
  [3954] = {.lex_state = 201},
  [3955] = {.lex_state = 201},
  [3956] = {.lex_state = 223},
  [3957] = {.lex_state = 3},
  [3958] = {.lex_state = 201},
  [3959] = {.lex_state = 201},
  [3960] = {.lex_state = 201},
  [3961] = {.lex_state = 3},
  [3962] = {.lex_state = 201},
  [3963] = {.lex_state = 3},
  [3964] = {.lex_state = 201},
  [3965] = {.lex_state = 201},
  [3966] = {.lex_state = 223},
  [3967] = {.lex_state = 3},
  [3968] = {.lex_state = 201},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 201},
  [3971] = {.lex_state = 201},
  [3972] = {.lex_state = 201},
  [3973] = {.lex_state = 201},
  [3974] = {.lex_state = 201},
  [3975] = {.lex_state = 201},
  [3976] = {.lex_state = 3},
  [3977] = {.lex_state = 3},
  [3978] = {.lex_state = 201},
  [3979] = {.lex_state = 0, .external_lex_state = 2},
  [3980] = {.lex_state = 201},
  [3981] = {.lex_state = 0, .external_lex_state = 9},
  [3982] = {.lex_state = 223},
  [3983] = {.lex_state = 223},
  [3984] = {.lex_state = 201},
  [3985] = {.lex_state = 201},
  [3986] = {.lex_state = 223},
  [3987] = {.lex_state = 228},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 228},
  [3990] = {.lex_state = 228},
  [3991] = {.lex_state = 201},
  [3992] = {.lex_state = 228},
  [3993] = {.lex_state = 228},
  [3994] = {.lex_state = 228},
  [3995] = {.lex_state = 228},
  [3996] = {.lex_state = 201},
  [3997] = {.lex_state = 228},
  [3998] = {.lex_state = 228},
  [3999] = {.lex_state = 228},
  [4000] = {.lex_state = 0, .external_lex_state = 10},
  [4001] = {.lex_state = 228},
  [4002] = {.lex_state = 0, .external_lex_state = 9},
  [4003] = {.lex_state = 0, .external_lex_state = 10},
  [4004] = {.lex_state = 0, .external_lex_state = 9},
  [4005] = {.lex_state = 201},
  [4006] = {.lex_state = 223},
  [4007] = {.lex_state = 223},
  [4008] = {.lex_state = 201},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 228},
  [4011] = {.lex_state = 228},
  [4012] = {.lex_state = 228},
  [4013] = {.lex_state = 228},
  [4014] = {.lex_state = 228},
  [4015] = {.lex_state = 0},
  [4016] = {.lex_state = 228},
  [4017] = {.lex_state = 228},
  [4018] = {.lex_state = 228},
  [4019] = {.lex_state = 201},
  [4020] = {.lex_state = 0, .external_lex_state = 10},
  [4021] = {.lex_state = 201},
  [4022] = {.lex_state = 0, .external_lex_state = 9},
  [4023] = {.lex_state = 0},
  [4024] = {.lex_state = 201},
  [4025] = {.lex_state = 0, .external_lex_state = 7},
  [4026] = {.lex_state = 0, .external_lex_state = 7},
  [4027] = {.lex_state = 223},
  [4028] = {.lex_state = 223},
  [4029] = {.lex_state = 0},
  [4030] = {.lex_state = 201},
  [4031] = {.lex_state = 201},
  [4032] = {.lex_state = 0, .external_lex_state = 9},
  [4033] = {.lex_state = 201},
  [4034] = {.lex_state = 201},
  [4035] = {.lex_state = 201, .external_lex_state = 7},
  [4036] = {.lex_state = 223, .external_lex_state = 7},
  [4037] = {.lex_state = 228},
  [4038] = {.lex_state = 0},
  [4039] = {.lex_state = 201},
  [4040] = {.lex_state = 201},
  [4041] = {.lex_state = 223, .external_lex_state = 7},
  [4042] = {.lex_state = 223, .external_lex_state = 7},
  [4043] = {.lex_state = 0, .external_lex_state = 7},
  [4044] = {.lex_state = 201, .external_lex_state = 7},
  [4045] = {.lex_state = 0, .external_lex_state = 10},
  [4046] = {.lex_state = 0, .external_lex_state = 9},
  [4047] = {.lex_state = 201, .external_lex_state = 7},
  [4048] = {.lex_state = 223},
  [4049] = {.lex_state = 228},
  [4050] = {.lex_state = 0, .external_lex_state = 10},
  [4051] = {.lex_state = 0},
  [4052] = {.lex_state = 0, .external_lex_state = 10},
  [4053] = {.lex_state = 0, .external_lex_state = 10},
  [4054] = {.lex_state = 0, .external_lex_state = 9},
  [4055] = {.lex_state = 0, .external_lex_state = 9},
  [4056] = {.lex_state = 201},
  [4057] = {.lex_state = 223},
  [4058] = {.lex_state = 201},
  [4059] = {.lex_state = 223},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 0, .external_lex_state = 7},
  [4062] = {.lex_state = 0, .external_lex_state = 12},
  [4063] = {.lex_state = 223},
  [4064] = {.lex_state = 223},
  [4065] = {.lex_state = 201},
  [4066] = {.lex_state = 201},
  [4067] = {.lex_state = 201},
  [4068] = {.lex_state = 228},
  [4069] = {.lex_state = 201},
  [4070] = {.lex_state = 228},
  [4071] = {.lex_state = 228},
  [4072] = {.lex_state = 201},
  [4073] = {.lex_state = 0, .external_lex_state = 10},
  [4074] = {.lex_state = 0, .external_lex_state = 9},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 228},
  [4077] = {.lex_state = 0, .external_lex_state = 9},
  [4078] = {.lex_state = 0},
  [4079] = {.lex_state = 223},
  [4080] = {.lex_state = 223},
  [4081] = {.lex_state = 228},
  [4082] = {.lex_state = 0, .external_lex_state = 7},
  [4083] = {.lex_state = 0, .external_lex_state = 7},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 201},
  [4086] = {.lex_state = 223},
  [4087] = {.lex_state = 223},
  [4088] = {.lex_state = 223},
  [4089] = {.lex_state = 201},
  [4090] = {.lex_state = 201},
  [4091] = {.lex_state = 0, .external_lex_state = 7},
  [4092] = {.lex_state = 201},
  [4093] = {.lex_state = 223},
  [4094] = {.lex_state = 201},
  [4095] = {.lex_state = 0, .external_lex_state = 10},
  [4096] = {.lex_state = 0},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 223},
  [4099] = {.lex_state = 0, .external_lex_state = 7},
  [4100] = {.lex_state = 0, .external_lex_state = 9},
  [4101] = {.lex_state = 0, .external_lex_state = 10},
  [4102] = {.lex_state = 0, .external_lex_state = 12},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 223},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 0, .external_lex_state = 9},
  [4107] = {.lex_state = 0, .external_lex_state = 10},
  [4108] = {.lex_state = 228},
  [4109] = {.lex_state = 223},
  [4110] = {.lex_state = 223},
  [4111] = {.lex_state = 0, .external_lex_state = 10},
  [4112] = {.lex_state = 0, .external_lex_state = 9},
  [4113] = {.lex_state = 223},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 223},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0, .external_lex_state = 10},
  [4118] = {.lex_state = 223},
  [4119] = {.lex_state = 0, .external_lex_state = 9},
  [4120] = {.lex_state = 0, .external_lex_state = 10},
  [4121] = {.lex_state = 0},
  [4122] = {.lex_state = 223},
  [4123] = {.lex_state = 223},
  [4124] = {.lex_state = 0},
  [4125] = {.lex_state = 201},
  [4126] = {.lex_state = 201},
  [4127] = {.lex_state = 0, .external_lex_state = 10},
  [4128] = {.lex_state = 0, .external_lex_state = 10},
  [4129] = {.lex_state = 0, .external_lex_state = 9},
  [4130] = {.lex_state = 0, .external_lex_state = 9},
  [4131] = {.lex_state = 201},
  [4132] = {.lex_state = 0},
  [4133] = {.lex_state = 223},
  [4134] = {.lex_state = 223},
  [4135] = {.lex_state = 0},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 201},
  [4138] = {.lex_state = 223},
  [4139] = {.lex_state = 0},
  [4140] = {.lex_state = 0},
  [4141] = {.lex_state = 201},
  [4142] = {.lex_state = 223},
  [4143] = {.lex_state = 223},
  [4144] = {.lex_state = 0, .external_lex_state = 2},
  [4145] = {.lex_state = 201},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 3},
  [4148] = {.lex_state = 223},
  [4149] = {.lex_state = 223},
  [4150] = {.lex_state = 201},
  [4151] = {.lex_state = 227},
  [4152] = {.lex_state = 201},
  [4153] = {.lex_state = 201},
  [4154] = {.lex_state = 0},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 201},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 227},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 0},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 227},
  [4165] = {.lex_state = 231},
  [4166] = {.lex_state = 0},
  [4167] = {.lex_state = 201},
  [4168] = {.lex_state = 201},
  [4169] = {.lex_state = 0},
  [4170] = {.lex_state = 0, .external_lex_state = 2},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 0},
  [4173] = {.lex_state = 201},
  [4174] = {.lex_state = 223},
  [4175] = {.lex_state = 201},
  [4176] = {.lex_state = 227},
  [4177] = {.lex_state = 213},
  [4178] = {.lex_state = 231},
  [4179] = {.lex_state = 223},
  [4180] = {.lex_state = 223},
  [4181] = {.lex_state = 0},
  [4182] = {.lex_state = 201},
  [4183] = {.lex_state = 201},
  [4184] = {.lex_state = 0},
  [4185] = {.lex_state = 0},
  [4186] = {.lex_state = 0},
  [4187] = {.lex_state = 0},
  [4188] = {.lex_state = 223},
  [4189] = {.lex_state = 223},
  [4190] = {.lex_state = 201},
  [4191] = {.lex_state = 201},
  [4192] = {.lex_state = 201},
  [4193] = {.lex_state = 0},
  [4194] = {.lex_state = 0},
  [4195] = {.lex_state = 223},
  [4196] = {.lex_state = 223},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 213},
  [4199] = {.lex_state = 227},
  [4200] = {.lex_state = 201},
  [4201] = {.lex_state = 0},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 0},
  [4204] = {.lex_state = 201},
  [4205] = {.lex_state = 213},
  [4206] = {.lex_state = 0},
  [4207] = {.lex_state = 201},
  [4208] = {.lex_state = 0},
  [4209] = {.lex_state = 223},
  [4210] = {.lex_state = 227},
  [4211] = {.lex_state = 0},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 0},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 223},
  [4216] = {.lex_state = 223},
  [4217] = {.lex_state = 0},
  [4218] = {.lex_state = 201},
  [4219] = {.lex_state = 223},
  [4220] = {.lex_state = 231},
  [4221] = {.lex_state = 0},
  [4222] = {.lex_state = 223},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 0},
  [4225] = {.lex_state = 0},
  [4226] = {.lex_state = 213},
  [4227] = {.lex_state = 201},
  [4228] = {.lex_state = 201},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 201},
  [4231] = {.lex_state = 225},
  [4232] = {.lex_state = 0},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 228},
  [4236] = {.lex_state = 201},
  [4237] = {.lex_state = 223},
  [4238] = {.lex_state = 223},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 0},
  [4241] = {.lex_state = 201},
  [4242] = {.lex_state = 223},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 227},
  [4245] = {.lex_state = 227},
  [4246] = {.lex_state = 223},
  [4247] = {.lex_state = 223},
  [4248] = {.lex_state = 201},
  [4249] = {.lex_state = 201},
  [4250] = {.lex_state = 225},
  [4251] = {.lex_state = 201},
  [4252] = {.lex_state = 231},
  [4253] = {.lex_state = 0},
  [4254] = {.lex_state = 0, .external_lex_state = 2},
  [4255] = {.lex_state = 201},
  [4256] = {.lex_state = 201},
  [4257] = {.lex_state = 227},
  [4258] = {.lex_state = 201},
  [4259] = {.lex_state = 0},
  [4260] = {.lex_state = 227},
  [4261] = {.lex_state = 201},
  [4262] = {.lex_state = 231},
  [4263] = {.lex_state = 0},
  [4264] = {.lex_state = 0},
  [4265] = {.lex_state = 201},
  [4266] = {.lex_state = 0},
  [4267] = {.lex_state = 201},
  [4268] = {.lex_state = 227},
  [4269] = {.lex_state = 0},
  [4270] = {.lex_state = 0},
  [4271] = {.lex_state = 225},
  [4272] = {.lex_state = 0},
  [4273] = {.lex_state = 227},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 0},
  [4276] = {.lex_state = 0},
  [4277] = {.lex_state = 201},
  [4278] = {.lex_state = 231},
  [4279] = {.lex_state = 225},
  [4280] = {.lex_state = 0},
  [4281] = {.lex_state = 201},
  [4282] = {.lex_state = 227},
  [4283] = {.lex_state = 0, .external_lex_state = 7},
  [4284] = {.lex_state = 201},
  [4285] = {.lex_state = 201},
  [4286] = {.lex_state = 0},
  [4287] = {.lex_state = 225},
  [4288] = {.lex_state = 0},
  [4289] = {.lex_state = 227},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 201},
  [4292] = {.lex_state = 0},
  [4293] = {.lex_state = 0},
  [4294] = {.lex_state = 0},
  [4295] = {.lex_state = 223},
  [4296] = {.lex_state = 223},
  [4297] = {.lex_state = 225},
  [4298] = {.lex_state = 0},
  [4299] = {.lex_state = 201},
  [4300] = {.lex_state = 0},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 231},
  [4303] = {.lex_state = 225},
  [4304] = {.lex_state = 223},
  [4305] = {.lex_state = 223},
  [4306] = {.lex_state = 201},
  [4307] = {.lex_state = 201},
  [4308] = {.lex_state = 0},
  [4309] = {.lex_state = 231},
  [4310] = {.lex_state = 0},
  [4311] = {.lex_state = 0},
  [4312] = {.lex_state = 225},
  [4313] = {.lex_state = 0},
  [4314] = {.lex_state = 0, .external_lex_state = 7},
  [4315] = {.lex_state = 227},
  [4316] = {.lex_state = 201},
  [4317] = {.lex_state = 201},
  [4318] = {.lex_state = 223},
  [4319] = {.lex_state = 227},
  [4320] = {.lex_state = 225},
  [4321] = {.lex_state = 223},
  [4322] = {.lex_state = 0},
  [4323] = {.lex_state = 201},
  [4324] = {.lex_state = 0},
  [4325] = {.lex_state = 0},
  [4326] = {.lex_state = 227},
  [4327] = {.lex_state = 0},
  [4328] = {.lex_state = 0},
  [4329] = {.lex_state = 227},
  [4330] = {.lex_state = 0},
  [4331] = {.lex_state = 201},
  [4332] = {.lex_state = 0},
  [4333] = {.lex_state = 0},
  [4334] = {.lex_state = 223},
  [4335] = {.lex_state = 223},
  [4336] = {.lex_state = 223},
  [4337] = {.lex_state = 225},
  [4338] = {.lex_state = 227},
  [4339] = {.lex_state = 201},
  [4340] = {.lex_state = 0},
  [4341] = {.lex_state = 201},
  [4342] = {.lex_state = 201},
  [4343] = {.lex_state = 201},
  [4344] = {.lex_state = 201},
  [4345] = {.lex_state = 201},
  [4346] = {.lex_state = 223},
  [4347] = {.lex_state = 201},
  [4348] = {.lex_state = 0},
  [4349] = {.lex_state = 201},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 201},
  [4352] = {.lex_state = 0},
  [4353] = {.lex_state = 0},
  [4354] = {.lex_state = 0},
  [4355] = {.lex_state = 0},
  [4356] = {.lex_state = 225},
  [4357] = {.lex_state = 223},
  [4358] = {.lex_state = 0},
  [4359] = {.lex_state = 223},
  [4360] = {.lex_state = 201},
  [4361] = {.lex_state = 213},
  [4362] = {.lex_state = 213},
  [4363] = {.lex_state = 223},
  [4364] = {.lex_state = 201},
  [4365] = {.lex_state = 201},
  [4366] = {.lex_state = 0},
  [4367] = {.lex_state = 201},
  [4368] = {.lex_state = 0},
  [4369] = {.lex_state = 225},
  [4370] = {.lex_state = 0},
  [4371] = {.lex_state = 213},
  [4372] = {.lex_state = 201},
  [4373] = {.lex_state = 0, .external_lex_state = 7},
  [4374] = {.lex_state = 201},
  [4375] = {.lex_state = 0},
  [4376] = {.lex_state = 0},
  [4377] = {.lex_state = 201},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 223},
  [4380] = {.lex_state = 201},
  [4381] = {.lex_state = 0},
  [4382] = {.lex_state = 0},
  [4383] = {.lex_state = 201},
  [4384] = {.lex_state = 223},
  [4385] = {.lex_state = 213},
  [4386] = {.lex_state = 213},
  [4387] = {.lex_state = 223},
  [4388] = {.lex_state = 201},
  [4389] = {.lex_state = 227},
  [4390] = {.lex_state = 223},
  [4391] = {.lex_state = 227},
  [4392] = {.lex_state = 201},
  [4393] = {.lex_state = 201},
  [4394] = {.lex_state = 0},
  [4395] = {.lex_state = 0},
  [4396] = {.lex_state = 201},
  [4397] = {.lex_state = 0},
  [4398] = {.lex_state = 201},
  [4399] = {.lex_state = 223},
  [4400] = {.lex_state = 223},
  [4401] = {.lex_state = 201},
  [4402] = {.lex_state = 201},
  [4403] = {.lex_state = 213},
  [4404] = {.lex_state = 213},
  [4405] = {.lex_state = 201},
  [4406] = {.lex_state = 3},
  [4407] = {.lex_state = 201},
  [4408] = {.lex_state = 223},
  [4409] = {.lex_state = 223},
  [4410] = {.lex_state = 201},
  [4411] = {.lex_state = 0},
  [4412] = {.lex_state = 0},
  [4413] = {.lex_state = 0},
  [4414] = {.lex_state = 201},
  [4415] = {.lex_state = 223},
  [4416] = {.lex_state = 223},
  [4417] = {.lex_state = 213},
  [4418] = {.lex_state = 213},
  [4419] = {.lex_state = 0},
  [4420] = {.lex_state = 0},
  [4421] = {.lex_state = 201},
  [4422] = {.lex_state = 227},
  [4423] = {.lex_state = 0},
  [4424] = {.lex_state = 0, .external_lex_state = 7},
  [4425] = {.lex_state = 213},
  [4426] = {.lex_state = 201},
  [4427] = {.lex_state = 0},
  [4428] = {.lex_state = 201},
  [4429] = {.lex_state = 225},
  [4430] = {.lex_state = 0},
  [4431] = {.lex_state = 0, .external_lex_state = 7},
  [4432] = {.lex_state = 213},
  [4433] = {.lex_state = 213},
  [4434] = {.lex_state = 0, .external_lex_state = 7},
  [4435] = {.lex_state = 0, .external_lex_state = 7},
  [4436] = {.lex_state = 201},
  [4437] = {.lex_state = 201},
  [4438] = {.lex_state = 223},
  [4439] = {.lex_state = 0},
  [4440] = {.lex_state = 0},
  [4441] = {.lex_state = 227},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 223},
  [4444] = {.lex_state = 228},
  [4445] = {.lex_state = 223},
  [4446] = {.lex_state = 213},
  [4447] = {.lex_state = 213},
  [4448] = {.lex_state = 201},
  [4449] = {.lex_state = 201},
  [4450] = {.lex_state = 231},
  [4451] = {.lex_state = 223},
  [4452] = {.lex_state = 201},
  [4453] = {.lex_state = 201},
  [4454] = {.lex_state = 213},
  [4455] = {.lex_state = 213},
  [4456] = {.lex_state = 223},
  [4457] = {.lex_state = 0},
  [4458] = {.lex_state = 223},
  [4459] = {.lex_state = 0},
  [4460] = {.lex_state = 0},
  [4461] = {.lex_state = 0},
  [4462] = {.lex_state = 213},
  [4463] = {.lex_state = 223},
  [4464] = {.lex_state = 201},
  [4465] = {.lex_state = 201},
  [4466] = {.lex_state = 0},
  [4467] = {.lex_state = 201},
  [4468] = {.lex_state = 0},
  [4469] = {.lex_state = 213},
  [4470] = {.lex_state = 213},
  [4471] = {.lex_state = 201},
  [4472] = {.lex_state = 231},
  [4473] = {.lex_state = 213},
  [4474] = {.lex_state = 223},
  [4475] = {.lex_state = 0},
  [4476] = {.lex_state = 223},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 227},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 201},
  [4481] = {.lex_state = 201},
  [4482] = {.lex_state = 223},
  [4483] = {.lex_state = 213},
  [4484] = {.lex_state = 213},
  [4485] = {.lex_state = 201},
  [4486] = {.lex_state = 231},
  [4487] = {.lex_state = 201},
  [4488] = {.lex_state = 223},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0, .external_lex_state = 2},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 0},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 227},
  [4495] = {.lex_state = 201},
  [4496] = {.lex_state = 201},
  [4497] = {.lex_state = 223},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 0},
  [4501] = {.lex_state = 201},
  [4502] = {.lex_state = 201},
  [4503] = {.lex_state = 227},
  [4504] = {.lex_state = 201},
  [4505] = {.lex_state = 201},
  [4506] = {.lex_state = 201},
  [4507] = {.lex_state = 0},
  [4508] = {.lex_state = 0},
  [4509] = {.lex_state = 201},
  [4510] = {.lex_state = 201},
  [4511] = {.lex_state = 223},
  [4512] = {.lex_state = 0},
  [4513] = {.lex_state = 223},
  [4514] = {.lex_state = 201},
  [4515] = {.lex_state = 223},
  [4516] = {.lex_state = 223},
  [4517] = {.lex_state = 223},
  [4518] = {.lex_state = 0, .external_lex_state = 2},
  [4519] = {.lex_state = 0},
  [4520] = {.lex_state = 201},
  [4521] = {.lex_state = 223},
  [4522] = {.lex_state = 201},
  [4523] = {.lex_state = 201},
  [4524] = {.lex_state = 0},
  [4525] = {.lex_state = 201},
  [4526] = {.lex_state = 223},
  [4527] = {.lex_state = 223},
  [4528] = {.lex_state = 201},
  [4529] = {.lex_state = 201},
  [4530] = {.lex_state = 201},
  [4531] = {.lex_state = 223},
  [4532] = {.lex_state = 0},
  [4533] = {.lex_state = 223},
  [4534] = {.lex_state = 201},
  [4535] = {.lex_state = 227},
  [4536] = {.lex_state = 223},
  [4537] = {.lex_state = 201},
  [4538] = {.lex_state = 223},
  [4539] = {.lex_state = 223},
  [4540] = {.lex_state = 201},
  [4541] = {.lex_state = 223},
  [4542] = {.lex_state = 201},
  [4543] = {.lex_state = 201},
  [4544] = {.lex_state = 223},
  [4545] = {.lex_state = 227},
  [4546] = {.lex_state = 231},
  [4547] = {.lex_state = 201},
  [4548] = {.lex_state = 223},
  [4549] = {.lex_state = 201},
  [4550] = {.lex_state = 223},
  [4551] = {.lex_state = 201},
  [4552] = {.lex_state = 201},
  [4553] = {.lex_state = 0},
  [4554] = {.lex_state = 0},
  [4555] = {.lex_state = 0},
  [4556] = {.lex_state = 201},
  [4557] = {.lex_state = 223},
  [4558] = {.lex_state = 201},
  [4559] = {.lex_state = 0},
  [4560] = {.lex_state = 201},
  [4561] = {.lex_state = 0},
  [4562] = {.lex_state = 201},
  [4563] = {.lex_state = 0, .external_lex_state = 7},
  [4564] = {.lex_state = 201},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 227},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 0, .external_lex_state = 7},
  [4569] = {.lex_state = 201},
  [4570] = {.lex_state = 201},
  [4571] = {.lex_state = 0},
  [4572] = {.lex_state = 213},
  [4573] = {.lex_state = 223},
  [4574] = {.lex_state = 223},
  [4575] = {.lex_state = 213},
  [4576] = {.lex_state = 0},
  [4577] = {.lex_state = 201},
  [4578] = {.lex_state = 223},
  [4579] = {.lex_state = 0},
  [4580] = {.lex_state = 201},
  [4581] = {.lex_state = 201},
  [4582] = {.lex_state = 223},
  [4583] = {.lex_state = 227},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 0},
  [4586] = {.lex_state = 231},
  [4587] = {.lex_state = 0},
  [4588] = {.lex_state = 0},
  [4589] = {.lex_state = 228},
  [4590] = {.lex_state = 0},
  [4591] = {.lex_state = 0, .external_lex_state = 7},
  [4592] = {.lex_state = 0, .external_lex_state = 7},
  [4593] = {.lex_state = 201},
  [4594] = {.lex_state = 0, .external_lex_state = 7},
  [4595] = {.lex_state = 231},
  [4596] = {.lex_state = 201},
  [4597] = {.lex_state = 228},
  [4598] = {.lex_state = 223},
  [4599] = {.lex_state = 223},
  [4600] = {.lex_state = 223},
  [4601] = {.lex_state = 223},
  [4602] = {.lex_state = 223},
  [4603] = {.lex_state = 223},
  [4604] = {.lex_state = 223},
  [4605] = {.lex_state = 223},
  [4606] = {.lex_state = 223},
  [4607] = {.lex_state = 223},
  [4608] = {.lex_state = 223},
  [4609] = {.lex_state = 223},
  [4610] = {.lex_state = 223},
  [4611] = {.lex_state = 223},
  [4612] = {.lex_state = 223},
  [4613] = {.lex_state = 0},
  [4614] = {.lex_state = 201},
  [4615] = {.lex_state = 201},
  [4616] = {.lex_state = 201},
  [4617] = {.lex_state = 223},
  [4618] = {.lex_state = 201},
  [4619] = {.lex_state = 201},
  [4620] = {.lex_state = 201},
  [4621] = {.lex_state = 223},
  [4622] = {.lex_state = 201},
  [4623] = {.lex_state = 201},
  [4624] = {.lex_state = 0},
  [4625] = {.lex_state = 201},
  [4626] = {.lex_state = 201},
  [4627] = {.lex_state = 228},
  [4628] = {.lex_state = 223},
  [4629] = {.lex_state = 223},
  [4630] = {.lex_state = 201},
  [4631] = {.lex_state = 0},
  [4632] = {.lex_state = 223},
  [4633] = {.lex_state = 223},
  [4634] = {.lex_state = 201},
  [4635] = {.lex_state = 223},
  [4636] = {.lex_state = 0},
  [4637] = {.lex_state = 223},
  [4638] = {.lex_state = 223},
  [4639] = {.lex_state = 223},
  [4640] = {.lex_state = 0},
  [4641] = {.lex_state = 223},
  [4642] = {.lex_state = 201},
  [4643] = {.lex_state = 223},
  [4644] = {.lex_state = 223},
  [4645] = {.lex_state = 223},
  [4646] = {.lex_state = 0, .external_lex_state = 7},
  [4647] = {.lex_state = 201},
  [4648] = {.lex_state = 201},
  [4649] = {.lex_state = 223},
  [4650] = {.lex_state = 201},
  [4651] = {.lex_state = 223},
  [4652] = {.lex_state = 0},
  [4653] = {.lex_state = 0, .external_lex_state = 7},
  [4654] = {.lex_state = 223},
  [4655] = {.lex_state = 223},
  [4656] = {.lex_state = 223},
  [4657] = {.lex_state = 223},
  [4658] = {.lex_state = 223},
  [4659] = {.lex_state = 201},
  [4660] = {.lex_state = 201},
  [4661] = {.lex_state = 223},
  [4662] = {.lex_state = 228},
  [4663] = {.lex_state = 201},
  [4664] = {.lex_state = 201},
  [4665] = {.lex_state = 0},
  [4666] = {.lex_state = 223},
  [4667] = {.lex_state = 223},
  [4668] = {.lex_state = 223},
  [4669] = {.lex_state = 0, .external_lex_state = 9},
  [4670] = {.lex_state = 201},
  [4671] = {.lex_state = 0, .external_lex_state = 10},
  [4672] = {.lex_state = 201},
  [4673] = {.lex_state = 223},
  [4674] = {.lex_state = 201},
  [4675] = {.lex_state = 201},
  [4676] = {.lex_state = 201},
  [4677] = {.lex_state = 201},
  [4678] = {.lex_state = 201, .external_lex_state = 7},
  [4679] = {.lex_state = 201},
  [4680] = {.lex_state = 201},
  [4681] = {.lex_state = 201},
  [4682] = {.lex_state = 0},
  [4683] = {.lex_state = 201},
  [4684] = {.lex_state = 225},
  [4685] = {.lex_state = 223},
  [4686] = {.lex_state = 201},
  [4687] = {.lex_state = 201},
  [4688] = {.lex_state = 211},
  [4689] = {.lex_state = 225},
  [4690] = {.lex_state = 211},
  [4691] = {.lex_state = 211},
  [4692] = {.lex_state = 211},
  [4693] = {.lex_state = 211},
  [4694] = {.lex_state = 223},
  [4695] = {.lex_state = 211},
  [4696] = {.lex_state = 211},
  [4697] = {.lex_state = 211},
  [4698] = {.lex_state = 211},
  [4699] = {.lex_state = 211},
  [4700] = {.lex_state = 211},
  [4701] = {.lex_state = 211},
  [4702] = {.lex_state = 211},
  [4703] = {.lex_state = 211},
  [4704] = {.lex_state = 201},
  [4705] = {.lex_state = 211},
  [4706] = {.lex_state = 211},
  [4707] = {.lex_state = 201},
  [4708] = {.lex_state = 201},
  [4709] = {.lex_state = 225},
  [4710] = {.lex_state = 211},
  [4711] = {.lex_state = 211},
  [4712] = {.lex_state = 211},
  [4713] = {.lex_state = 201},
  [4714] = {.lex_state = 211},
  [4715] = {.lex_state = 211},
  [4716] = {.lex_state = 225},
  [4717] = {.lex_state = 211},
  [4718] = {.lex_state = 211},
  [4719] = {.lex_state = 211},
  [4720] = {.lex_state = 211},
  [4721] = {.lex_state = 233},
  [4722] = {.lex_state = 211},
  [4723] = {.lex_state = 211},
  [4724] = {.lex_state = 211},
  [4725] = {.lex_state = 201},
  [4726] = {.lex_state = 211},
  [4727] = {.lex_state = 223},
  [4728] = {.lex_state = 211},
  [4729] = {.lex_state = 211},
  [4730] = {.lex_state = 211},
  [4731] = {.lex_state = 0, .external_lex_state = 7},
  [4732] = {.lex_state = 211},
  [4733] = {.lex_state = 211},
  [4734] = {.lex_state = 201},
  [4735] = {.lex_state = 201},
  [4736] = {.lex_state = 201},
  [4737] = {.lex_state = 211},
  [4738] = {.lex_state = 211},
  [4739] = {.lex_state = 201},
  [4740] = {.lex_state = 201},
  [4741] = {.lex_state = 201},
  [4742] = {.lex_state = 0, .external_lex_state = 7},
  [4743] = {.lex_state = 225},
  [4744] = {.lex_state = 211},
  [4745] = {.lex_state = 201},
  [4746] = {.lex_state = 201},
  [4747] = {.lex_state = 201},
  [4748] = {.lex_state = 211},
  [4749] = {.lex_state = 211},
  [4750] = {.lex_state = 0},
  [4751] = {.lex_state = 211},
  [4752] = {.lex_state = 201},
  [4753] = {.lex_state = 223},
  [4754] = {.lex_state = 201},
  [4755] = {.lex_state = 211},
  [4756] = {.lex_state = 211},
  [4757] = {.lex_state = 223},
  [4758] = {.lex_state = 201},
  [4759] = {.lex_state = 211},
  [4760] = {.lex_state = 225},
  [4761] = {.lex_state = 0},
  [4762] = {.lex_state = 201},
  [4763] = {.lex_state = 201},
  [4764] = {.lex_state = 211},
  [4765] = {.lex_state = 201},
  [4766] = {.lex_state = 223},
  [4767] = {.lex_state = 201},
  [4768] = {.lex_state = 211},
  [4769] = {.lex_state = 223},
  [4770] = {.lex_state = 225},
  [4771] = {.lex_state = 223},
  [4772] = {.lex_state = 211},
  [4773] = {.lex_state = 211},
  [4774] = {.lex_state = 211},
  [4775] = {.lex_state = 211},
  [4776] = {.lex_state = 211},
  [4777] = {.lex_state = 211},
  [4778] = {.lex_state = 211},
  [4779] = {.lex_state = 201},
  [4780] = {.lex_state = 201},
  [4781] = {.lex_state = 211},
  [4782] = {.lex_state = 201},
  [4783] = {.lex_state = 211},
  [4784] = {.lex_state = 211},
  [4785] = {.lex_state = 233},
  [4786] = {.lex_state = 213},
  [4787] = {.lex_state = 233},
  [4788] = {.lex_state = 216},
  [4789] = {.lex_state = 201},
  [4790] = {.lex_state = 225},
  [4791] = {.lex_state = 211},
  [4792] = {.lex_state = 201},
  [4793] = {.lex_state = 201},
  [4794] = {.lex_state = 201},
  [4795] = {.lex_state = 211},
  [4796] = {.lex_state = 211},
  [4797] = {.lex_state = 201},
  [4798] = {.lex_state = 211},
  [4799] = {.lex_state = 216},
  [4800] = {.lex_state = 201},
  [4801] = {.lex_state = 211},
  [4802] = {.lex_state = 211},
  [4803] = {.lex_state = 201},
  [4804] = {.lex_state = 201},
  [4805] = {.lex_state = 201},
  [4806] = {.lex_state = 211},
  [4807] = {.lex_state = 211},
  [4808] = {.lex_state = 211},
  [4809] = {.lex_state = 213},
  [4810] = {.lex_state = 201},
  [4811] = {.lex_state = 225},
  [4812] = {.lex_state = 201},
  [4813] = {.lex_state = 223},
  [4814] = {.lex_state = 201},
  [4815] = {.lex_state = 201},
  [4816] = {.lex_state = 211},
  [4817] = {.lex_state = 223},
  [4818] = {.lex_state = 223},
  [4819] = {.lex_state = 201},
  [4820] = {.lex_state = 201},
  [4821] = {.lex_state = 211},
  [4822] = {.lex_state = 201},
  [4823] = {.lex_state = 211},
  [4824] = {.lex_state = 211},
  [4825] = {.lex_state = 211},
  [4826] = {.lex_state = 211},
  [4827] = {.lex_state = 225},
  [4828] = {.lex_state = 211},
  [4829] = {.lex_state = 211},
  [4830] = {.lex_state = 223},
  [4831] = {.lex_state = 201},
  [4832] = {.lex_state = 201},
  [4833] = {.lex_state = 201},
  [4834] = {.lex_state = 223},
  [4835] = {.lex_state = 233},
  [4836] = {.lex_state = 201},
  [4837] = {.lex_state = 225},
  [4838] = {.lex_state = 201},
  [4839] = {.lex_state = 223},
  [4840] = {.lex_state = 201},
  [4841] = {.lex_state = 201},
  [4842] = {.lex_state = 201},
  [4843] = {.lex_state = 223},
  [4844] = {.lex_state = 223},
  [4845] = {.lex_state = 201},
  [4846] = {.lex_state = 0, .external_lex_state = 7},
  [4847] = {.lex_state = 549},
  [4848] = {.lex_state = 201},
  [4849] = {.lex_state = 201},
  [4850] = {.lex_state = 0, .external_lex_state = 7},
  [4851] = {.lex_state = 201},
  [4852] = {.lex_state = 201},
  [4853] = {.lex_state = 201},
  [4854] = {.lex_state = 201},
  [4855] = {.lex_state = 225},
  [4856] = {.lex_state = 4},
  [4857] = {.lex_state = 201},
  [4858] = {.lex_state = 223},
  [4859] = {.lex_state = 223},
  [4860] = {.lex_state = 0, .external_lex_state = 7},
  [4861] = {.lex_state = 0, .external_lex_state = 7},
  [4862] = {.lex_state = 223},
  [4863] = {.lex_state = 223},
  [4864] = {.lex_state = 201},
  [4865] = {.lex_state = 0, .external_lex_state = 7},
  [4866] = {.lex_state = 201},
  [4867] = {.lex_state = 233},
  [4868] = {.lex_state = 211},
  [4869] = {.lex_state = 223},
  [4870] = {.lex_state = 225},
  [4871] = {.lex_state = 201},
  [4872] = {.lex_state = 201},
  [4873] = {.lex_state = 223},
  [4874] = {.lex_state = 233},
  [4875] = {.lex_state = 0},
  [4876] = {.lex_state = 223},
  [4877] = {.lex_state = 223},
  [4878] = {.lex_state = 223},
  [4879] = {.lex_state = 201},
  [4880] = {.lex_state = 233},
  [4881] = {.lex_state = 201},
  [4882] = {.lex_state = 223},
  [4883] = {.lex_state = 201},
  [4884] = {.lex_state = 223},
  [4885] = {.lex_state = 211},
  [4886] = {.lex_state = 223},
  [4887] = {.lex_state = 223},
  [4888] = {.lex_state = 201},
  [4889] = {.lex_state = 233},
  [4890] = {.lex_state = 223},
  [4891] = {.lex_state = 223},
  [4892] = {.lex_state = 201},
  [4893] = {.lex_state = 223},
  [4894] = {.lex_state = 201},
  [4895] = {.lex_state = 223},
  [4896] = {.lex_state = 0},
  [4897] = {.lex_state = 201},
  [4898] = {.lex_state = 223},
  [4899] = {.lex_state = 201},
  [4900] = {.lex_state = 201},
  [4901] = {.lex_state = 201},
  [4902] = {.lex_state = 223},
  [4903] = {.lex_state = 223},
  [4904] = {.lex_state = 201},
  [4905] = {.lex_state = 211},
  [4906] = {.lex_state = 201},
  [4907] = {.lex_state = 201},
  [4908] = {.lex_state = 201},
  [4909] = {.lex_state = 211},
  [4910] = {.lex_state = 223},
  [4911] = {.lex_state = 201},
  [4912] = {.lex_state = 223},
  [4913] = {.lex_state = 0, .external_lex_state = 7},
  [4914] = {.lex_state = 223},
  [4915] = {.lex_state = 223},
  [4916] = {.lex_state = 211},
  [4917] = {.lex_state = 223},
  [4918] = {.lex_state = 211},
  [4919] = {.lex_state = 213},
  [4920] = {.lex_state = 211},
  [4921] = {.lex_state = 225},
  [4922] = {.lex_state = 223},
  [4923] = {.lex_state = 201},
  [4924] = {.lex_state = 223},
  [4925] = {.lex_state = 201},
  [4926] = {.lex_state = 223},
  [4927] = {.lex_state = 223},
  [4928] = {.lex_state = 211},
  [4929] = {.lex_state = 213},
  [4930] = {.lex_state = 216},
  [4931] = {.lex_state = 201},
  [4932] = {.lex_state = 201},
  [4933] = {.lex_state = 0, .external_lex_state = 7},
  [4934] = {.lex_state = 223},
  [4935] = {.lex_state = 233},
  [4936] = {.lex_state = 223},
  [4937] = {.lex_state = 216},
  [4938] = {.lex_state = 223},
  [4939] = {.lex_state = 223},
  [4940] = {.lex_state = 0, .external_lex_state = 7},
  [4941] = {.lex_state = 0, .external_lex_state = 7},
  [4942] = {.lex_state = 0},
  [4943] = {.lex_state = 551},
  [4944] = {.lex_state = 201},
  [4945] = {.lex_state = 223},
  [4946] = {.lex_state = 223},
  [4947] = {.lex_state = 201},
  [4948] = {.lex_state = 223},
  [4949] = {.lex_state = 233},
  [4950] = {.lex_state = 223},
  [4951] = {.lex_state = 223},
  [4952] = {.lex_state = 223},
  [4953] = {.lex_state = 223},
  [4954] = {.lex_state = 0, .external_lex_state = 7},
  [4955] = {.lex_state = 223},
  [4956] = {.lex_state = 201},
  [4957] = {.lex_state = 211},
  [4958] = {.lex_state = 223},
  [4959] = {.lex_state = 223},
  [4960] = {.lex_state = 223},
  [4961] = {.lex_state = 211},
  [4962] = {.lex_state = 223},
  [4963] = {.lex_state = 223},
  [4964] = {.lex_state = 216},
  [4965] = {.lex_state = 0},
  [4966] = {.lex_state = 211},
  [4967] = {.lex_state = 223},
  [4968] = {.lex_state = 213},
  [4969] = {.lex_state = 201},
  [4970] = {.lex_state = 223},
  [4971] = {.lex_state = 216},
  [4972] = {.lex_state = 223},
  [4973] = {.lex_state = 225},
  [4974] = {.lex_state = 223},
  [4975] = {.lex_state = 223},
  [4976] = {.lex_state = 0, .external_lex_state = 7},
  [4977] = {.lex_state = 0, .external_lex_state = 7},
  [4978] = {.lex_state = 201},
  [4979] = {.lex_state = 201},
  [4980] = {.lex_state = 551},
  [4981] = {.lex_state = 0, .external_lex_state = 7},
  [4982] = {.lex_state = 223},
  [4983] = {.lex_state = 201},
  [4984] = {.lex_state = 223},
  [4985] = {.lex_state = 201},
  [4986] = {.lex_state = 223},
  [4987] = {.lex_state = 223},
  [4988] = {.lex_state = 216},
  [4989] = {.lex_state = 213},
  [4990] = {.lex_state = 211},
  [4991] = {.lex_state = 213},
  [4992] = {.lex_state = 201},
  [4993] = {.lex_state = 225},
  [4994] = {.lex_state = 223},
  [4995] = {.lex_state = 223},
  [4996] = {.lex_state = 201},
  [4997] = {.lex_state = 233},
  [4998] = {.lex_state = 223},
  [4999] = {.lex_state = 223},
  [5000] = {.lex_state = 0, .external_lex_state = 7},
  [5001] = {.lex_state = 216},
  [5002] = {.lex_state = 201},
  [5003] = {.lex_state = 213},
  [5004] = {.lex_state = 216},
  [5005] = {.lex_state = 223},
  [5006] = {.lex_state = 211},
  [5007] = {.lex_state = 223},
  [5008] = {.lex_state = 223},
  [5009] = {.lex_state = 201},
  [5010] = {.lex_state = 0},
  [5011] = {.lex_state = 201},
  [5012] = {.lex_state = 223},
  [5013] = {.lex_state = 223},
  [5014] = {.lex_state = 223},
  [5015] = {.lex_state = 223},
  [5016] = {.lex_state = 223},
  [5017] = {.lex_state = 201},
  [5018] = {.lex_state = 223},
  [5019] = {.lex_state = 0},
  [5020] = {.lex_state = 234},
  [5021] = {.lex_state = 223},
  [5022] = {.lex_state = 211},
  [5023] = {.lex_state = 223},
  [5024] = {.lex_state = 223},
  [5025] = {.lex_state = 201},
  [5026] = {.lex_state = 213},
  [5027] = {.lex_state = 223},
  [5028] = {.lex_state = 216},
  [5029] = {.lex_state = 223},
  [5030] = {.lex_state = 201},
  [5031] = {.lex_state = 201},
  [5032] = {.lex_state = 549},
  [5033] = {.lex_state = 201},
  [5034] = {.lex_state = 225},
  [5035] = {.lex_state = 233},
  [5036] = {.lex_state = 201},
  [5037] = {.lex_state = 223},
  [5038] = {.lex_state = 213},
  [5039] = {.lex_state = 211},
  [5040] = {.lex_state = 0, .external_lex_state = 7},
  [5041] = {.lex_state = 201},
  [5042] = {.lex_state = 0, .external_lex_state = 7},
  [5043] = {.lex_state = 201},
  [5044] = {.lex_state = 216},
  [5045] = {.lex_state = 201},
  [5046] = {.lex_state = 223},
  [5047] = {.lex_state = 223},
  [5048] = {.lex_state = 233},
  [5049] = {.lex_state = 0},
  [5050] = {.lex_state = 0, .external_lex_state = 7},
  [5051] = {.lex_state = 223},
  [5052] = {.lex_state = 201},
  [5053] = {.lex_state = 223},
  [5054] = {.lex_state = 213},
  [5055] = {.lex_state = 233},
  [5056] = {.lex_state = 211},
  [5057] = {.lex_state = 201},
  [5058] = {.lex_state = 201},
  [5059] = {.lex_state = 201},
  [5060] = {.lex_state = 201},
  [5061] = {.lex_state = 201},
  [5062] = {.lex_state = 223},
  [5063] = {.lex_state = 211},
  [5064] = {.lex_state = 213},
  [5065] = {.lex_state = 216},
  [5066] = {.lex_state = 201},
  [5067] = {.lex_state = 201},
  [5068] = {.lex_state = 201},
  [5069] = {.lex_state = 201},
  [5070] = {.lex_state = 223},
  [5071] = {.lex_state = 223},
  [5072] = {.lex_state = 201},
  [5073] = {.lex_state = 201},
  [5074] = {.lex_state = 0},
  [5075] = {.lex_state = 201},
  [5076] = {.lex_state = 233},
  [5077] = {.lex_state = 216},
  [5078] = {.lex_state = 201},
  [5079] = {.lex_state = 201},
  [5080] = {.lex_state = 0, .external_lex_state = 7},
  [5081] = {.lex_state = 223},
  [5082] = {.lex_state = 223},
  [5083] = {.lex_state = 223},
  [5084] = {.lex_state = 223},
  [5085] = {.lex_state = 201},
  [5086] = {.lex_state = 223},
  [5087] = {.lex_state = 223},
  [5088] = {.lex_state = 211},
  [5089] = {.lex_state = 223},
  [5090] = {.lex_state = 223},
  [5091] = {.lex_state = 201},
  [5092] = {.lex_state = 223},
  [5093] = {.lex_state = 223},
  [5094] = {.lex_state = 201},
  [5095] = {.lex_state = 223},
  [5096] = {.lex_state = 223},
  [5097] = {.lex_state = 225},
  [5098] = {.lex_state = 223},
  [5099] = {.lex_state = 223},
  [5100] = {.lex_state = 233},
  [5101] = {.lex_state = 223},
  [5102] = {.lex_state = 223},
  [5103] = {.lex_state = 213},
  [5104] = {.lex_state = 223},
  [5105] = {.lex_state = 223},
  [5106] = {.lex_state = 201},
  [5107] = {.lex_state = 223},
  [5108] = {.lex_state = 223},
  [5109] = {.lex_state = 211},
  [5110] = {.lex_state = 223},
  [5111] = {.lex_state = 223},
  [5112] = {.lex_state = 234},
  [5113] = {.lex_state = 223},
  [5114] = {.lex_state = 223},
  [5115] = {.lex_state = 213},
  [5116] = {.lex_state = 223},
  [5117] = {.lex_state = 223},
  [5118] = {.lex_state = 213},
  [5119] = {.lex_state = 223},
  [5120] = {.lex_state = 223},
  [5121] = {.lex_state = 216},
  [5122] = {.lex_state = 223},
  [5123] = {.lex_state = 223},
  [5124] = {.lex_state = 216},
  [5125] = {(TSStateId)(-1)},
  [5126] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_extramodular_text = 0,
  ts_external_token__indent = 1,
  ts_external_token_bullet_conj = 2,
  ts_external_token_bullet_disj = 3,
  ts_external_token__dedent = 4,
  ts_external_token__begin_proof = 5,
  ts_external_token__begin_proof_step = 6,
  ts_external_token_proof_keyword = 7,
  ts_external_token_by_keyword = 8,
  ts_external_token_obvious_keyword = 9,
  ts_external_token_omitted_keyword = 10,
  ts_external_token_qed_keyword = 11,
  ts_external_token__error_sentinel = 12,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_extramodular_text] = sym_extramodular_text,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token_bullet_conj] = sym_bullet_conj,
  [ts_external_token_bullet_disj] = sym_bullet_disj,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__begin_proof] = sym__begin_proof,
  [ts_external_token__begin_proof_step] = sym__begin_proof_step,
  [ts_external_token_proof_keyword] = sym_proof_keyword,
  [ts_external_token_by_keyword] = sym_by_keyword,
  [ts_external_token_obvious_keyword] = sym_obvious_keyword,
  [ts_external_token_omitted_keyword] = sym_omitted_keyword,
  [ts_external_token_qed_keyword] = sym_qed_keyword,
  [ts_external_token__error_sentinel] = sym__error_sentinel,
};

static const bool ts_external_scanner_states[13][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_extramodular_text] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
    [ts_external_token_qed_keyword] = true,
    [ts_external_token__error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_extramodular_text] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token_qed_keyword] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__begin_proof_step] = true,
  },
  [6] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [7] = {
    [ts_external_token__begin_proof_step] = true,
  },
  [8] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [9] = {
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
  },
  [10] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token__dedent] = true,
  },
  [11] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
  },
  [12] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [aux_sym_block_comment_text_token2] = ACTIONS(1),
    [aux_sym_block_comment_text_token3] = ACTIONS(1),
    [aux_sym_block_comment_text_token4] = ACTIONS(1),
    [anon_sym_MODULE] = ACTIONS(1),
    [sym_single_line] = ACTIONS(1),
    [sym_double_line] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_BSLASHAA] = ACTIONS(1),
    [anon_sym_BSLASHEE] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_8] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_9] = ACTIONS(1),
    [anon_sym_10] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_11] = ACTIONS(1),
    [anon_sym_12] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_13] = ACTIONS(1),
    [anon_sym_14] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym__2] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_15] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_16] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_ENABLED] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_SUBSET] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_INSTANCE] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_DOMAIN] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_UNCHANGED] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_DEFINE] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHB] = ACTIONS(1),
    [aux_sym_binary_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHO] = ACTIONS(1),
    [aux_sym_octal_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHh] = ACTIONS(1),
    [anon_sym_BSLASHH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [sym_string_set] = ACTIONS(1),
    [sym_boolean_set] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_17] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_18] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_19] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_20] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_21] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_22] = ACTIONS(1),
    [anon_sym_23] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_24] = ACTIONS(1),
    [anon_sym_25] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_26] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_27] = ACTIONS(1),
    [anon_sym_28] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_29] = ACTIONS(1),
    [anon_sym_30] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_31] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_32] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_33] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_34] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_35] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_36] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_37] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_38] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_39] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_40] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_41] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_42] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_43] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_44] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_45] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_46] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_47] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_48] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_49] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_50] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_51] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_52] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_53] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_54] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_55] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_56] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_57] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_58] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_59] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_60] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_61] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_62] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_63] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_64] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_65] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_66] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_67] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_68] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_69] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_70] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_71] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_72] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_73] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_74] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_75] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_76] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_77] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_78] = ACTIONS(1),
    [anon_sym_BANG_BANG] = ACTIONS(1),
    [anon_sym_79] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_80] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_81] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_82] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_83] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_84] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_85] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_86] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_87] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [aux_sym_proof_step_id_token1] = ACTIONS(1),
    [aux_sym_proof_step_ref_token1] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_algorithm] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_procedure] = ACTIONS(1),
    [anon_sym_fair] = ACTIONS(1),
    [anon_sym_process] = ACTIONS(1),
    [anon_sym_variable] = ACTIONS(1),
    [anon_sym_variables] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_either] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_skip] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [sym_extramodular_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym_bullet_conj] = ACTIONS(1),
    [sym_bullet_disj] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym_proof_keyword] = ACTIONS(1),
    [sym_by_keyword] = ACTIONS(1),
    [sym_obvious_keyword] = ACTIONS(1),
    [sym_omitted_keyword] = ACTIONS(1),
    [sym_qed_keyword] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(5074),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(4144),
    [aux_sym_source_file_repeat1] = STATE(3928),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(7),
    [sym_extramodular_text] = ACTIONS(9),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(3708),
    [sym_exists] = STATE(3708),
    [sym_temporal_forall] = STATE(4687),
    [sym_temporal_exists] = STATE(4687),
    [sym_langle_bracket] = STATE(56),
    [sym_operator_definition] = STATE(3632),
    [sym_function_definition] = STATE(3632),
    [sym_instance] = STATE(4954),
    [sym_subexpr_prefix] = STATE(1195),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2673),
    [sym_bound_nonfix_op] = STATE(2673),
    [sym_module_definition] = STATE(3632),
    [sym__expr] = STATE(1399),
    [sym_prefixed_op] = STATE(2823),
    [sym__number] = STATE(2823),
    [sym_nat_number] = STATE(2816),
    [sym_binary_number] = STATE(2816),
    [sym_octal_number] = STATE(2816),
    [sym_hex_number] = STATE(2816),
    [sym_string] = STATE(2823),
    [sym_boolean] = STATE(2823),
    [sym__primitive_value_set] = STATE(2823),
    [sym_nat_number_set] = STATE(2818),
    [sym_int_number_set] = STATE(2818),
    [sym_real_number_set] = STATE(2818),
    [sym_label] = STATE(2823),
    [sym_subexpression] = STATE(2823),
    [sym_parentheses] = STATE(2823),
    [sym_bounded_quantification] = STATE(2823),
    [sym_unbounded_quantification] = STATE(2823),
    [sym_choose] = STATE(2823),
    [sym_finite_set_literal] = STATE(2823),
    [sym_set_filter] = STATE(2823),
    [sym_set_map] = STATE(2823),
    [sym_function_evaluation] = STATE(2823),
    [sym_function_literal] = STATE(2823),
    [sym_set_of_functions] = STATE(2823),
    [sym_record_literal] = STATE(2823),
    [sym_set_of_records] = STATE(2823),
    [sym_record_value] = STATE(2823),
    [sym_except] = STATE(2823),
    [sym_prev_func_val] = STATE(2823),
    [sym_tuple_literal] = STATE(2823),
    [sym_step_expr_or_stutter] = STATE(2823),
    [sym_step_expr_no_stutter] = STATE(2823),
    [sym_fairness] = STATE(2823),
    [sym_if_then_else] = STATE(2823),
    [sym_case] = STATE(2823),
    [sym_let_in] = STATE(2823),
    [sym_conj_list] = STATE(2823),
    [sym_disj_list] = STATE(2823),
    [sym_lnot] = STATE(212),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(287),
    [sym_negative] = STATE(993),
    [sym_enabled] = STATE(283),
    [sym_unchanged] = STATE(283),
    [sym_always] = STATE(283),
    [sym_eventually] = STATE(283),
    [sym_prefix_op_symbol] = STATE(4242),
    [sym_bound_prefix_op] = STATE(2823),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2823),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4641),
    [sym_bound_postfix_op] = STATE(2823),
    [sym_assume_prove] = STATE(3662),
    [sym_definition_proof_step] = STATE(4954),
    [sym_have_proof_step] = STATE(4954),
    [sym_witness_proof_step] = STATE(4954),
    [sym_take_proof_step] = STATE(4954),
    [sym_suffices_proof_step] = STATE(4954),
    [sym_case_proof_step] = STATE(4954),
    [sym_pick_proof_step] = STATE(4954),
    [sym_use_or_hide] = STATE(4954),
    [sym_proof_step_ref] = STATE(2666),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [sym_string_set] = ACTIONS(97),
    [sym_boolean_set] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(99),
    [anon_sym_17] = ACTIONS(101),
    [anon_sym_Int] = ACTIONS(103),
    [anon_sym_18] = ACTIONS(105),
    [anon_sym_Real] = ACTIONS(107),
    [anon_sym_19] = ACTIONS(109),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(147),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(263),
    [sym_qed_keyword] = ACTIONS(265),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(3708),
    [sym_exists] = STATE(3708),
    [sym_temporal_forall] = STATE(4687),
    [sym_temporal_exists] = STATE(4687),
    [sym_langle_bracket] = STATE(56),
    [sym_operator_definition] = STATE(3632),
    [sym_function_definition] = STATE(3632),
    [sym_instance] = STATE(4954),
    [sym_subexpr_prefix] = STATE(1195),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2673),
    [sym_bound_nonfix_op] = STATE(2673),
    [sym_module_definition] = STATE(3632),
    [sym__expr] = STATE(1399),
    [sym_prefixed_op] = STATE(2823),
    [sym__number] = STATE(2823),
    [sym_nat_number] = STATE(2816),
    [sym_binary_number] = STATE(2816),
    [sym_octal_number] = STATE(2816),
    [sym_hex_number] = STATE(2816),
    [sym_string] = STATE(2823),
    [sym_boolean] = STATE(2823),
    [sym__primitive_value_set] = STATE(2823),
    [sym_nat_number_set] = STATE(2818),
    [sym_int_number_set] = STATE(2818),
    [sym_real_number_set] = STATE(2818),
    [sym_label] = STATE(2823),
    [sym_subexpression] = STATE(2823),
    [sym_parentheses] = STATE(2823),
    [sym_bounded_quantification] = STATE(2823),
    [sym_unbounded_quantification] = STATE(2823),
    [sym_choose] = STATE(2823),
    [sym_finite_set_literal] = STATE(2823),
    [sym_set_filter] = STATE(2823),
    [sym_set_map] = STATE(2823),
    [sym_function_evaluation] = STATE(2823),
    [sym_function_literal] = STATE(2823),
    [sym_set_of_functions] = STATE(2823),
    [sym_record_literal] = STATE(2823),
    [sym_set_of_records] = STATE(2823),
    [sym_record_value] = STATE(2823),
    [sym_except] = STATE(2823),
    [sym_prev_func_val] = STATE(2823),
    [sym_tuple_literal] = STATE(2823),
    [sym_step_expr_or_stutter] = STATE(2823),
    [sym_step_expr_no_stutter] = STATE(2823),
    [sym_fairness] = STATE(2823),
    [sym_if_then_else] = STATE(2823),
    [sym_case] = STATE(2823),
    [sym_let_in] = STATE(2823),
    [sym_conj_list] = STATE(2823),
    [sym_disj_list] = STATE(2823),
    [sym_lnot] = STATE(212),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(287),
    [sym_negative] = STATE(993),
    [sym_enabled] = STATE(283),
    [sym_unchanged] = STATE(283),
    [sym_always] = STATE(283),
    [sym_eventually] = STATE(283),
    [sym_prefix_op_symbol] = STATE(4242),
    [sym_bound_prefix_op] = STATE(2823),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2823),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4641),
    [sym_bound_postfix_op] = STATE(2823),
    [sym_assume_prove] = STATE(3662),
    [sym_definition_proof_step] = STATE(4954),
    [sym_have_proof_step] = STATE(4954),
    [sym_witness_proof_step] = STATE(4954),
    [sym_take_proof_step] = STATE(4954),
    [sym_suffices_proof_step] = STATE(4954),
    [sym_case_proof_step] = STATE(4954),
    [sym_pick_proof_step] = STATE(4954),
    [sym_use_or_hide] = STATE(4954),
    [sym_proof_step_ref] = STATE(2666),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [sym_string_set] = ACTIONS(97),
    [sym_boolean_set] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(99),
    [anon_sym_17] = ACTIONS(101),
    [anon_sym_Int] = ACTIONS(103),
    [anon_sym_18] = ACTIONS(105),
    [anon_sym_Real] = ACTIONS(107),
    [anon_sym_19] = ACTIONS(109),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(147),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(263),
    [sym_qed_keyword] = ACTIONS(267),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(3708),
    [sym_exists] = STATE(3708),
    [sym_temporal_forall] = STATE(4687),
    [sym_temporal_exists] = STATE(4687),
    [sym_langle_bracket] = STATE(56),
    [sym_operator_definition] = STATE(3632),
    [sym_function_definition] = STATE(3632),
    [sym_instance] = STATE(4954),
    [sym_subexpr_prefix] = STATE(1195),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2673),
    [sym_bound_nonfix_op] = STATE(2673),
    [sym_module_definition] = STATE(3632),
    [sym__expr] = STATE(1399),
    [sym_prefixed_op] = STATE(2823),
    [sym__number] = STATE(2823),
    [sym_nat_number] = STATE(2816),
    [sym_binary_number] = STATE(2816),
    [sym_octal_number] = STATE(2816),
    [sym_hex_number] = STATE(2816),
    [sym_string] = STATE(2823),
    [sym_boolean] = STATE(2823),
    [sym__primitive_value_set] = STATE(2823),
    [sym_nat_number_set] = STATE(2818),
    [sym_int_number_set] = STATE(2818),
    [sym_real_number_set] = STATE(2818),
    [sym_label] = STATE(2823),
    [sym_subexpression] = STATE(2823),
    [sym_parentheses] = STATE(2823),
    [sym_bounded_quantification] = STATE(2823),
    [sym_unbounded_quantification] = STATE(2823),
    [sym_choose] = STATE(2823),
    [sym_finite_set_literal] = STATE(2823),
    [sym_set_filter] = STATE(2823),
    [sym_set_map] = STATE(2823),
    [sym_function_evaluation] = STATE(2823),
    [sym_function_literal] = STATE(2823),
    [sym_set_of_functions] = STATE(2823),
    [sym_record_literal] = STATE(2823),
    [sym_set_of_records] = STATE(2823),
    [sym_record_value] = STATE(2823),
    [sym_except] = STATE(2823),
    [sym_prev_func_val] = STATE(2823),
    [sym_tuple_literal] = STATE(2823),
    [sym_step_expr_or_stutter] = STATE(2823),
    [sym_step_expr_no_stutter] = STATE(2823),
    [sym_fairness] = STATE(2823),
    [sym_if_then_else] = STATE(2823),
    [sym_case] = STATE(2823),
    [sym_let_in] = STATE(2823),
    [sym_conj_list] = STATE(2823),
    [sym_disj_list] = STATE(2823),
    [sym_lnot] = STATE(212),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(287),
    [sym_negative] = STATE(993),
    [sym_enabled] = STATE(283),
    [sym_unchanged] = STATE(283),
    [sym_always] = STATE(283),
    [sym_eventually] = STATE(283),
    [sym_prefix_op_symbol] = STATE(4242),
    [sym_bound_prefix_op] = STATE(2823),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4601),
    [sym_bound_infix_op] = STATE(2823),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4641),
    [sym_bound_postfix_op] = STATE(2823),
    [sym_assume_prove] = STATE(3662),
    [sym_definition_proof_step] = STATE(4954),
    [sym_have_proof_step] = STATE(4954),
    [sym_witness_proof_step] = STATE(4954),
    [sym_take_proof_step] = STATE(4954),
    [sym_suffices_proof_step] = STATE(4954),
    [sym_case_proof_step] = STATE(4954),
    [sym_pick_proof_step] = STATE(4954),
    [sym_use_or_hide] = STATE(4954),
    [sym_proof_step_ref] = STATE(2666),
    [aux_sym_definition_proof_step_repeat1] = STATE(3432),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [sym_string_set] = ACTIONS(97),
    [sym_boolean_set] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(99),
    [anon_sym_17] = ACTIONS(101),
    [anon_sym_Int] = ACTIONS(103),
    [anon_sym_18] = ACTIONS(105),
    [anon_sym_Real] = ACTIONS(107),
    [anon_sym_19] = ACTIONS(109),
    [anon_sym_LBRACE] = ACTIONS(111),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(147),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(263),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1078),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(149),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1084),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(149),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1082),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(149),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1079),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(269),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(272),
    [sym_double_line] = ACTIONS(272),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_ASSUME] = ACTIONS(279),
    [anon_sym_LOCAL] = ACTIONS(279),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ASSUMPTION] = ACTIONS(279),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_VARIABLE] = ACTIONS(279),
    [anon_sym_AXIOM] = ACTIONS(279),
    [anon_sym_VARIABLES] = ACTIONS(279),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_CONSTANT] = ACTIONS(279),
    [anon_sym_CONSTANTS] = ACTIONS(279),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_THEOREM] = ACTIONS(279),
    [anon_sym_COROLLARY] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_HIDE] = ACTIONS(279),
    [anon_sym_RECURSIVE] = ACTIONS(279),
    [anon_sym_USE] = ACTIONS(279),
    [anon_sym_LEMMA] = ACTIONS(279),
    [anon_sym_PROPOSITION] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(306),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(149),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym__expr] = STATE(1800),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(4638),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4639),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4638),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_assume_prove] = STATE(4648),
    [sym_inner_assume_prove] = STATE(4634),
    [sym_new] = STATE(4634),
    [sym_level] = STATE(3440),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(421),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym__expr] = STATE(1721),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(4638),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4639),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4638),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_assume_prove] = STATE(4648),
    [sym_inner_assume_prove] = STATE(4525),
    [sym_new] = STATE(4525),
    [sym_level] = STATE(3440),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(421),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym__expr] = STATE(1720),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(4638),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4639),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4638),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_assume_prove] = STATE(4648),
    [sym_inner_assume_prove] = STATE(4380),
    [sym_new] = STATE(4380),
    [sym_level] = STATE(3440),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(421),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym__expr] = STATE(1737),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(4638),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4639),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4638),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_assume_prove] = STATE(4648),
    [sym_inner_assume_prove] = STATE(4291),
    [sym_new] = STATE(4291),
    [sym_level] = STATE(3440),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_ASSUME] = ACTIONS(365),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(367),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(367),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(379),
    [anon_sym_STATE] = ACTIONS(367),
    [anon_sym_ACTION] = ACTIONS(367),
    [anon_sym_TEMPORAL] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(421),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(4977),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_ONLY] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(4933),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_ONLY] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3371),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_ONLY] = ACTIONS(493),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3373),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_ONLY] = ACTIONS(497),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(5040),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_ONLY] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3350),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_ONLY] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(4933),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(4861),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3362),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(5042),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3352),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [24] = {
    [sym_block_comment] = STATE(24),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym_operator_declaration] = STATE(3319),
    [sym__id_or_op_declaration] = STATE(4396),
    [sym__op_or_expr] = STATE(4183),
    [sym__op] = STATE(3307),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym_lambda] = STATE(3303),
    [sym__expr] = STATE(1795),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(3903),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(3986),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4088),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [sym_placeholder] = ACTIONS(505),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(509),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(421),
  },
  [25] = {
    [sym_block_comment] = STATE(25),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3371),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [26] = {
    [sym_block_comment] = STATE(26),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym__expr] = STATE(1607),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(210),
    [sym_union] = STATE(255),
    [sym_powerset] = STATE(255),
    [sym_domain] = STATE(254),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(249),
    [sym_unchanged] = STATE(249),
    [sym_always] = STATE(249),
    [sym_eventually] = STATE(249),
    [sym_prefix_op_symbol] = STATE(4633),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4599),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4633),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_use_body] = STATE(5040),
    [sym_use_body_expr] = STATE(4047),
    [sym_use_body_def] = STATE(5080),
    [sym_module_ref] = STATE(3913),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(439),
    [anon_sym_DEFS] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(455),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(481),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(483),
  },
  [27] = {
    [sym_block_comment] = STATE(27),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym__expr] = STATE(1060),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(239),
    [sym_union] = STATE(213),
    [sym_powerset] = STATE(213),
    [sym_domain] = STATE(214),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(217),
    [sym_unchanged] = STATE(217),
    [sym_always] = STATE(217),
    [sym_eventually] = STATE(217),
    [sym_prefix_op_symbol] = STATE(4673),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4612),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4673),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_use_body] = STATE(3373),
    [sym_use_body_expr] = STATE(3318),
    [sym_use_body_def] = STATE(3364),
    [sym_module_ref] = STATE(3306),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(491),
    [anon_sym_DEFS] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(319),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [sym__indent] = ACTIONS(359),
  },
  [28] = {
    [sym_block_comment] = STATE(28),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym__op_or_expr] = STATE(3327),
    [sym__op] = STATE(3307),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym_lambda] = STATE(3303),
    [sym__expr] = STATE(1092),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(5),
    [sym_union] = STATE(8),
    [sym_powerset] = STATE(8),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(6),
    [sym_unchanged] = STATE(6),
    [sym_always] = STATE(6),
    [sym_eventually] = STATE(6),
    [sym_prefix_op_symbol] = STATE(3317),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(3321),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3300),
    [sym_postfix_op_symbol] = STATE(3317),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_module_ref] = STATE(3327),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(511),
    [anon_sym_15] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(513),
    [anon_sym_ENABLED] = ACTIONS(515),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(517),
    [anon_sym_DOMAIN] = ACTIONS(519),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(521),
    [anon_sym_LAMBDA] = ACTIONS(523),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(525),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(527),
    [anon_sym_BSLASHneg] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(529),
    [anon_sym_20] = ACTIONS(527),
    [anon_sym_DASH] = ACTIONS(531),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(533),
    [anon_sym_21] = ACTIONS(533),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(535),
    [anon_sym_87] = ACTIONS(535),
    [sym_asterisk] = ACTIONS(537),
    [sym_sup_hash] = ACTIONS(537),
    [sym_prime] = ACTIONS(537),
    [sym__indent] = ACTIONS(359),
  },
  [29] = {
    [sym_block_comment] = STATE(29),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym__op_or_expr] = STATE(4653),
    [sym__op] = STATE(3618),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym_lambda] = STATE(3614),
    [sym__expr] = STATE(1793),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(144),
    [sym_union] = STATE(145),
    [sym_powerset] = STATE(145),
    [sym_domain] = STATE(146),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(147),
    [sym_unchanged] = STATE(147),
    [sym_always] = STATE(147),
    [sym_eventually] = STATE(147),
    [sym_prefix_op_symbol] = STATE(4042),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3554),
    [sym_plus_arrow] = STATE(3554),
    [sym_equiv] = STATE(3554),
    [sym_iff] = STATE(3554),
    [sym_leads_to] = STATE(3554),
    [sym_land] = STATE(3554),
    [sym_lor] = STATE(3554),
    [sym_assign] = STATE(3554),
    [sym_bnf_rule] = STATE(3554),
    [sym_eq] = STATE(3554),
    [sym_neq] = STATE(3554),
    [sym_lt] = STATE(3554),
    [sym_leq] = STATE(3554),
    [sym_geq] = STATE(3554),
    [sym_approx] = STATE(3554),
    [sym_rs_ttile] = STATE(3554),
    [sym_rd_ttile] = STATE(3554),
    [sym_ls_ttile] = STATE(3554),
    [sym_ld_ttile] = STATE(3554),
    [sym_asymp] = STATE(3554),
    [sym_cong] = STATE(3554),
    [sym_doteq] = STATE(3554),
    [sym_gg] = STATE(3554),
    [sym_ll] = STATE(3554),
    [sym_in] = STATE(3554),
    [sym_notin] = STATE(3554),
    [sym_prec] = STATE(3554),
    [sym_succ] = STATE(3554),
    [sym_preceq] = STATE(3554),
    [sym_succeq] = STATE(3554),
    [sym_sim] = STATE(3554),
    [sym_simeq] = STATE(3554),
    [sym_sqsubset] = STATE(3554),
    [sym_sqsupset] = STATE(3554),
    [sym_sqsubseteq] = STATE(3554),
    [sym_sqsupseteq] = STATE(3554),
    [sym_cap] = STATE(3554),
    [sym_cup] = STATE(3554),
    [sym_dots_2] = STATE(3554),
    [sym_dots_3] = STATE(3554),
    [sym_plus] = STATE(3554),
    [sym_oplus] = STATE(3554),
    [sym_ominus] = STATE(3554),
    [sym_vertvert] = STATE(3554),
    [sym_minus] = STATE(3554),
    [sym_odot] = STATE(3554),
    [sym_oslash] = STATE(3554),
    [sym_otimes] = STATE(3554),
    [sym_bigcirc] = STATE(3554),
    [sym_bullet] = STATE(3554),
    [sym_div] = STATE(3554),
    [sym_circ] = STATE(3554),
    [sym_star] = STATE(3554),
    [sym_excl] = STATE(3554),
    [sym_qq] = STATE(3554),
    [sym_sqcap] = STATE(3554),
    [sym_sqcup] = STATE(3554),
    [sym_uplus] = STATE(3554),
    [sym_wr] = STATE(3554),
    [sym_cdot] = STATE(3554),
    [sym_infix_op_symbol] = STATE(4041),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3552),
    [sym_postfix_op_symbol] = STATE(4042),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_module_ref] = STATE(4653),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(539),
    [anon_sym_2] = ACTIONS(541),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(543),
    [anon_sym_15] = ACTIONS(543),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(545),
    [anon_sym_ENABLED] = ACTIONS(547),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(549),
    [anon_sym_DOMAIN] = ACTIONS(551),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(553),
    [anon_sym_LAMBDA] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(557),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(559),
    [anon_sym_BSLASHlnot] = ACTIONS(561),
    [anon_sym_BSLASHneg] = ACTIONS(561),
    [anon_sym_TILDE] = ACTIONS(563),
    [anon_sym_20] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(565),
    [sym_negative_dot] = ACTIONS(567),
    [anon_sym_LT_GT] = ACTIONS(569),
    [anon_sym_21] = ACTIONS(569),
    [anon_sym_EQ_GT] = ACTIONS(571),
    [anon_sym_22] = ACTIONS(571),
    [anon_sym_23] = ACTIONS(571),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(573),
    [anon_sym_24] = ACTIONS(573),
    [anon_sym_25] = ACTIONS(573),
    [anon_sym_BSLASHequiv] = ACTIONS(575),
    [anon_sym_26] = ACTIONS(575),
    [anon_sym_LT_EQ_GT] = ACTIONS(577),
    [anon_sym_27] = ACTIONS(577),
    [anon_sym_28] = ACTIONS(577),
    [anon_sym_TILDE_GT] = ACTIONS(579),
    [anon_sym_29] = ACTIONS(579),
    [anon_sym_30] = ACTIONS(579),
    [anon_sym_SLASH_BSLASH] = ACTIONS(581),
    [anon_sym_BSLASHland] = ACTIONS(581),
    [anon_sym_31] = ACTIONS(581),
    [anon_sym_BSLASH_SLASH] = ACTIONS(583),
    [anon_sym_BSLASHlor] = ACTIONS(583),
    [anon_sym_32] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(585),
    [anon_sym_33] = ACTIONS(585),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(587),
    [anon_sym_34] = ACTIONS(587),
    [anon_sym_SLASH_EQ] = ACTIONS(589),
    [anon_sym_POUND] = ACTIONS(591),
    [anon_sym_35] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(593),
    [sym_gt] = ACTIONS(595),
    [anon_sym_LT_EQ] = ACTIONS(597),
    [anon_sym_EQ_LT] = ACTIONS(599),
    [anon_sym_BSLASHleq] = ACTIONS(599),
    [anon_sym_36] = ACTIONS(599),
    [anon_sym_GT_EQ] = ACTIONS(601),
    [anon_sym_BSLASHgeq] = ACTIONS(601),
    [anon_sym_37] = ACTIONS(601),
    [anon_sym_BSLASHapprox] = ACTIONS(603),
    [anon_sym_38] = ACTIONS(603),
    [anon_sym_PIPE_DASH] = ACTIONS(605),
    [anon_sym_39] = ACTIONS(605),
    [anon_sym_PIPE_EQ] = ACTIONS(607),
    [anon_sym_40] = ACTIONS(607),
    [anon_sym_DASH_PIPE] = ACTIONS(609),
    [anon_sym_41] = ACTIONS(609),
    [anon_sym_EQ_PIPE] = ACTIONS(611),
    [anon_sym_42] = ACTIONS(611),
    [anon_sym_BSLASHasymp] = ACTIONS(613),
    [anon_sym_43] = ACTIONS(613),
    [anon_sym_BSLASHcong] = ACTIONS(615),
    [anon_sym_44] = ACTIONS(615),
    [anon_sym_BSLASHdoteq] = ACTIONS(617),
    [anon_sym_45] = ACTIONS(617),
    [anon_sym_BSLASHgg] = ACTIONS(619),
    [anon_sym_46] = ACTIONS(619),
    [anon_sym_BSLASHll] = ACTIONS(621),
    [anon_sym_47] = ACTIONS(621),
    [anon_sym_BSLASHnotin] = ACTIONS(623),
    [anon_sym_48] = ACTIONS(623),
    [anon_sym_BSLASHprec] = ACTIONS(625),
    [anon_sym_49] = ACTIONS(627),
    [anon_sym_BSLASHsucc] = ACTIONS(629),
    [anon_sym_50] = ACTIONS(631),
    [anon_sym_BSLASHpreceq] = ACTIONS(633),
    [anon_sym_51] = ACTIONS(633),
    [anon_sym_BSLASHsucceq] = ACTIONS(635),
    [anon_sym_52] = ACTIONS(635),
    [anon_sym_BSLASHsim] = ACTIONS(637),
    [anon_sym_54] = ACTIONS(639),
    [anon_sym_BSLASHsimeq] = ACTIONS(641),
    [anon_sym_55] = ACTIONS(641),
    [anon_sym_BSLASHsqsubset] = ACTIONS(643),
    [anon_sym_56] = ACTIONS(645),
    [anon_sym_BSLASHsqsupset] = ACTIONS(647),
    [anon_sym_57] = ACTIONS(649),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(651),
    [anon_sym_58] = ACTIONS(651),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(653),
    [anon_sym_59] = ACTIONS(653),
    [sym_compose] = ACTIONS(655),
    [sym_map_to] = ACTIONS(655),
    [sym_map_from] = ACTIONS(655),
    [sym_setminus] = ACTIONS(595),
    [anon_sym_BSLASHcap] = ACTIONS(657),
    [anon_sym_BSLASHintersect] = ACTIONS(657),
    [anon_sym_64] = ACTIONS(657),
    [anon_sym_BSLASHcup] = ACTIONS(659),
    [anon_sym_BSLASHunion] = ACTIONS(659),
    [anon_sym_65] = ACTIONS(659),
    [anon_sym_DOT_DOT] = ACTIONS(661),
    [anon_sym_66] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_67] = ACTIONS(665),
    [anon_sym_PLUS] = ACTIONS(667),
    [sym_plusplus] = ACTIONS(655),
    [anon_sym_BSLASHoplus] = ACTIONS(669),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(669),
    [anon_sym_68] = ACTIONS(669),
    [anon_sym_BSLASHominus] = ACTIONS(671),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(671),
    [anon_sym_69] = ACTIONS(671),
    [sym_mod] = ACTIONS(595),
    [sym_modmod] = ACTIONS(655),
    [sym_vert] = ACTIONS(595),
    [anon_sym_PIPE_PIPE] = ACTIONS(673),
    [anon_sym_70] = ACTIONS(673),
    [sym_minusminus] = ACTIONS(655),
    [sym_amp] = ACTIONS(595),
    [sym_ampamp] = ACTIONS(655),
    [anon_sym_BSLASHodot] = ACTIONS(675),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(675),
    [anon_sym_71] = ACTIONS(675),
    [anon_sym_BSLASHoslash] = ACTIONS(677),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(677),
    [anon_sym_72] = ACTIONS(677),
    [anon_sym_BSLASHotimes] = ACTIONS(679),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(679),
    [anon_sym_73] = ACTIONS(679),
    [sym_mul] = ACTIONS(595),
    [sym_mulmul] = ACTIONS(655),
    [sym_slash] = ACTIONS(595),
    [sym_slashslash] = ACTIONS(655),
    [anon_sym_BSLASHbigcirc] = ACTIONS(681),
    [anon_sym_74] = ACTIONS(681),
    [anon_sym_BSLASHbullet] = ACTIONS(683),
    [anon_sym_75] = ACTIONS(683),
    [anon_sym_BSLASHdiv] = ACTIONS(685),
    [anon_sym_76] = ACTIONS(685),
    [anon_sym_BSLASHcirc] = ACTIONS(687),
    [anon_sym_77] = ACTIONS(687),
    [anon_sym_BSLASHstar] = ACTIONS(689),
    [anon_sym_78] = ACTIONS(689),
    [anon_sym_BANG_BANG] = ACTIONS(691),
    [anon_sym_79] = ACTIONS(691),
    [anon_sym_QMARK_QMARK] = ACTIONS(693),
    [anon_sym_80] = ACTIONS(693),
    [sym_hashhash] = ACTIONS(655),
    [sym_dol] = ACTIONS(595),
    [sym_doldol] = ACTIONS(655),
    [anon_sym_BSLASHsqcap] = ACTIONS(695),
    [anon_sym_81] = ACTIONS(695),
    [anon_sym_BSLASHsqcup] = ACTIONS(697),
    [anon_sym_82] = ACTIONS(697),
    [anon_sym_BSLASHuplus] = ACTIONS(699),
    [anon_sym_83] = ACTIONS(699),
    [anon_sym_BSLASHwr] = ACTIONS(701),
    [anon_sym_85] = ACTIONS(701),
    [anon_sym_BSLASHcdot] = ACTIONS(703),
    [anon_sym_86] = ACTIONS(703),
    [sym_pow] = ACTIONS(595),
    [sym_powpow] = ACTIONS(655),
    [anon_sym_CARET_PLUS] = ACTIONS(705),
    [anon_sym_87] = ACTIONS(705),
    [sym_asterisk] = ACTIONS(707),
    [sym_sup_hash] = ACTIONS(707),
    [sym_prime] = ACTIONS(707),
    [sym__indent] = ACTIONS(483),
  },
  [30] = {
    [sym_block_comment] = STATE(30),
    [sym_forall] = STATE(3721),
    [sym_exists] = STATE(3721),
    [sym_temporal_forall] = STATE(4740),
    [sym_temporal_exists] = STATE(4740),
    [sym_langle_bracket] = STATE(58),
    [sym__op_or_expr] = STATE(4592),
    [sym__op] = STATE(3618),
    [sym_subexpr_prefix] = STATE(1201),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2865),
    [sym_bound_nonfix_op] = STATE(2865),
    [sym_lambda] = STATE(3614),
    [sym__expr] = STATE(1793),
    [sym_prefixed_op] = STATE(3065),
    [sym__number] = STATE(3065),
    [sym_nat_number] = STATE(3082),
    [sym_binary_number] = STATE(3082),
    [sym_octal_number] = STATE(3082),
    [sym_hex_number] = STATE(3082),
    [sym_string] = STATE(3065),
    [sym_boolean] = STATE(3065),
    [sym__primitive_value_set] = STATE(3065),
    [sym_nat_number_set] = STATE(3078),
    [sym_int_number_set] = STATE(3078),
    [sym_real_number_set] = STATE(3078),
    [sym_label] = STATE(3065),
    [sym_subexpression] = STATE(3065),
    [sym_parentheses] = STATE(3065),
    [sym_bounded_quantification] = STATE(3065),
    [sym_unbounded_quantification] = STATE(3065),
    [sym_choose] = STATE(3065),
    [sym_finite_set_literal] = STATE(3065),
    [sym_set_filter] = STATE(3065),
    [sym_set_map] = STATE(3065),
    [sym_function_evaluation] = STATE(3065),
    [sym_function_literal] = STATE(3065),
    [sym_set_of_functions] = STATE(3065),
    [sym_record_literal] = STATE(3065),
    [sym_set_of_records] = STATE(3065),
    [sym_record_value] = STATE(3065),
    [sym_except] = STATE(3065),
    [sym_prev_func_val] = STATE(3065),
    [sym_tuple_literal] = STATE(3065),
    [sym_step_expr_or_stutter] = STATE(3065),
    [sym_step_expr_no_stutter] = STATE(3065),
    [sym_fairness] = STATE(3065),
    [sym_if_then_else] = STATE(3065),
    [sym_case] = STATE(3065),
    [sym_let_in] = STATE(3065),
    [sym_conj_list] = STATE(3065),
    [sym_disj_list] = STATE(3065),
    [sym_lnot] = STATE(144),
    [sym_union] = STATE(145),
    [sym_powerset] = STATE(145),
    [sym_domain] = STATE(146),
    [sym_negative] = STATE(328),
    [sym_enabled] = STATE(147),
    [sym_unchanged] = STATE(147),
    [sym_always] = STATE(147),
    [sym_eventually] = STATE(147),
    [sym_prefix_op_symbol] = STATE(4042),
    [sym_bound_prefix_op] = STATE(3065),
    [sym_implies] = STATE(3554),
    [sym_plus_arrow] = STATE(3554),
    [sym_equiv] = STATE(3554),
    [sym_iff] = STATE(3554),
    [sym_leads_to] = STATE(3554),
    [sym_land] = STATE(3554),
    [sym_lor] = STATE(3554),
    [sym_assign] = STATE(3554),
    [sym_bnf_rule] = STATE(3554),
    [sym_eq] = STATE(3554),
    [sym_neq] = STATE(3554),
    [sym_lt] = STATE(3554),
    [sym_leq] = STATE(3554),
    [sym_geq] = STATE(3554),
    [sym_approx] = STATE(3554),
    [sym_rs_ttile] = STATE(3554),
    [sym_rd_ttile] = STATE(3554),
    [sym_ls_ttile] = STATE(3554),
    [sym_ld_ttile] = STATE(3554),
    [sym_asymp] = STATE(3554),
    [sym_cong] = STATE(3554),
    [sym_doteq] = STATE(3554),
    [sym_gg] = STATE(3554),
    [sym_ll] = STATE(3554),
    [sym_in] = STATE(3554),
    [sym_notin] = STATE(3554),
    [sym_prec] = STATE(3554),
    [sym_succ] = STATE(3554),
    [sym_preceq] = STATE(3554),
    [sym_succeq] = STATE(3554),
    [sym_sim] = STATE(3554),
    [sym_simeq] = STATE(3554),
    [sym_sqsubset] = STATE(3554),
    [sym_sqsupset] = STATE(3554),
    [sym_sqsubseteq] = STATE(3554),
    [sym_sqsupseteq] = STATE(3554),
    [sym_cap] = STATE(3554),
    [sym_cup] = STATE(3554),
    [sym_dots_2] = STATE(3554),
    [sym_dots_3] = STATE(3554),
    [sym_plus] = STATE(3554),
    [sym_oplus] = STATE(3554),
    [sym_ominus] = STATE(3554),
    [sym_vertvert] = STATE(3554),
    [sym_minus] = STATE(3554),
    [sym_odot] = STATE(3554),
    [sym_oslash] = STATE(3554),
    [sym_otimes] = STATE(3554),
    [sym_bigcirc] = STATE(3554),
    [sym_bullet] = STATE(3554),
    [sym_div] = STATE(3554),
    [sym_circ] = STATE(3554),
    [sym_star] = STATE(3554),
    [sym_excl] = STATE(3554),
    [sym_qq] = STATE(3554),
    [sym_sqcap] = STATE(3554),
    [sym_sqcup] = STATE(3554),
    [sym_uplus] = STATE(3554),
    [sym_wr] = STATE(3554),
    [sym_cdot] = STATE(3554),
    [sym_infix_op_symbol] = STATE(4041),
    [sym_bound_infix_op] = STATE(3065),
    [sym_sup_plus] = STATE(3552),
    [sym_postfix_op_symbol] = STATE(4042),
    [sym_bound_postfix_op] = STATE(3065),
    [sym_module_ref] = STATE(4592),
    [sym_proof_step_ref] = STATE(2866),
    [sym_identifier] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(425),
    [anon_sym_BSLASHin] = ACTIONS(539),
    [anon_sym_2] = ACTIONS(541),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(543),
    [anon_sym_15] = ACTIONS(543),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_UNION] = ACTIONS(545),
    [anon_sym_ENABLED] = ACTIONS(547),
    [anon_sym_CASE] = ACTIONS(429),
    [anon_sym_SF_] = ACTIONS(431),
    [anon_sym_WF_] = ACTIONS(431),
    [anon_sym_CHOOSE] = ACTIONS(433),
    [anon_sym_IF] = ACTIONS(435),
    [anon_sym_SUBSET] = ACTIONS(549),
    [anon_sym_DOMAIN] = ACTIONS(551),
    [anon_sym_LET] = ACTIONS(437),
    [anon_sym_UNCHANGED] = ACTIONS(553),
    [anon_sym_LAMBDA] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(445),
    [aux_sym_child_id_token1] = ACTIONS(447),
    [sym_real_number] = ACTIONS(449),
    [anon_sym_BSLASHb] = ACTIONS(451),
    [anon_sym_BSLASHB] = ACTIONS(453),
    [anon_sym_BSLASHo] = ACTIONS(557),
    [anon_sym_BSLASHO] = ACTIONS(457),
    [anon_sym_BSLASHh] = ACTIONS(459),
    [anon_sym_BSLASHH] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [anon_sym_TRUE] = ACTIONS(463),
    [anon_sym_FALSE] = ACTIONS(463),
    [sym_string_set] = ACTIONS(465),
    [sym_boolean_set] = ACTIONS(465),
    [anon_sym_Nat] = ACTIONS(467),
    [anon_sym_17] = ACTIONS(469),
    [anon_sym_Int] = ACTIONS(471),
    [anon_sym_18] = ACTIONS(473),
    [anon_sym_Real] = ACTIONS(475),
    [anon_sym_19] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_EQ] = ACTIONS(559),
    [anon_sym_BSLASHlnot] = ACTIONS(561),
    [anon_sym_BSLASHneg] = ACTIONS(561),
    [anon_sym_TILDE] = ACTIONS(563),
    [anon_sym_20] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(565),
    [sym_negative_dot] = ACTIONS(567),
    [anon_sym_LT_GT] = ACTIONS(569),
    [anon_sym_21] = ACTIONS(569),
    [anon_sym_EQ_GT] = ACTIONS(571),
    [anon_sym_22] = ACTIONS(571),
    [anon_sym_23] = ACTIONS(571),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(573),
    [anon_sym_24] = ACTIONS(573),
    [anon_sym_25] = ACTIONS(573),
    [anon_sym_BSLASHequiv] = ACTIONS(575),
    [anon_sym_26] = ACTIONS(575),
    [anon_sym_LT_EQ_GT] = ACTIONS(577),
    [anon_sym_27] = ACTIONS(577),
    [anon_sym_28] = ACTIONS(577),
    [anon_sym_TILDE_GT] = ACTIONS(579),
    [anon_sym_29] = ACTIONS(579),
    [anon_sym_30] = ACTIONS(579),
    [anon_sym_SLASH_BSLASH] = ACTIONS(581),
    [anon_sym_BSLASHland] = ACTIONS(581),
    [anon_sym_31] = ACTIONS(581),
    [anon_sym_BSLASH_SLASH] = ACTIONS(583),
    [anon_sym_BSLASHlor] = ACTIONS(583),
    [anon_sym_32] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(585),
    [anon_sym_33] = ACTIONS(585),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(587),
    [anon_sym_34] = ACTIONS(587),
    [anon_sym_SLASH_EQ] = ACTIONS(589),
    [anon_sym_POUND] = ACTIONS(591),
    [anon_sym_35] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(593),
    [sym_gt] = ACTIONS(595),
    [anon_sym_LT_EQ] = ACTIONS(597),
    [anon_sym_EQ_LT] = ACTIONS(599),
    [anon_sym_BSLASHleq] = ACTIONS(599),
    [anon_sym_36] = ACTIONS(599),
    [anon_sym_GT_EQ] = ACTIONS(601),
    [anon_sym_BSLASHgeq] = ACTIONS(601),
    [anon_sym_37] = ACTIONS(601),
    [anon_sym_BSLASHapprox] = ACTIONS(603),
    [anon_sym_38] = ACTIONS(603),
    [anon_sym_PIPE_DASH] = ACTIONS(605),
    [anon_sym_39] = ACTIONS(605),
    [anon_sym_PIPE_EQ] = ACTIONS(607),
    [anon_sym_40] = ACTIONS(607),
    [anon_sym_DASH_PIPE] = ACTIONS(609),
    [anon_sym_41] = ACTIONS(609),
    [anon_sym_EQ_PIPE] = ACTIONS(611),
    [anon_sym_42] = ACTIONS(611),
    [anon_sym_BSLASHasymp] = ACTIONS(613),
    [anon_sym_43] = ACTIONS(613),
    [anon_sym_BSLASHcong] = ACTIONS(615),
    [anon_sym_44] = ACTIONS(615),
    [anon_sym_BSLASHdoteq] = ACTIONS(617),
    [anon_sym_45] = ACTIONS(617),
    [anon_sym_BSLASHgg] = ACTIONS(619),
    [anon_sym_46] = ACTIONS(619),
    [anon_sym_BSLASHll] = ACTIONS(621),
    [anon_sym_47] = ACTIONS(621),
    [anon_sym_BSLASHnotin] = ACTIONS(623),
    [anon_sym_48] = ACTIONS(623),
    [anon_sym_BSLASHprec] = ACTIONS(625),
    [anon_sym_49] = ACTIONS(627),
    [anon_sym_BSLASHsucc] = ACTIONS(629),
    [anon_sym_50] = ACTIONS(631),
    [anon_sym_BSLASHpreceq] = ACTIONS(633),
    [anon_sym_51] = ACTIONS(633),
    [anon_sym_BSLASHsucceq] = ACTIONS(635),
    [anon_sym_52] = ACTIONS(635),
    [anon_sym_BSLASHsim] = ACTIONS(637),
    [anon_sym_54] = ACTIONS(639),
    [anon_sym_BSLASHsimeq] = ACTIONS(641),
    [anon_sym_55] = ACTIONS(641),
    [anon_sym_BSLASHsqsubset] = ACTIONS(643),
    [anon_sym_56] = ACTIONS(645),
    [anon_sym_BSLASHsqsupset] = ACTIONS(647),
    [anon_sym_57] = ACTIONS(649),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(651),
    [anon_sym_58] = ACTIONS(651),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(653),
    [anon_sym_59] = ACTIONS(653),
    [sym_compose] = ACTIONS(655),
    [sym_map_to] = ACTIONS(655),
    [sym_map_from] = ACTIONS(655),
    [sym_setminus] = ACTIONS(595),
    [anon_sym_BSLASHcap] = ACTIONS(657),
    [anon_sym_BSLASHintersect] = ACTIONS(657),
    [anon_sym_64] = ACTIONS(657),
    [anon_sym_BSLASHcup] = ACTIONS(659),
    [anon_sym_BSLASHunion] = ACTIONS(659),
    [anon_sym_65] = ACTIONS(659),
    [anon_sym_DOT_DOT] = ACTIONS(661),
    [anon_sym_66] = ACTIONS(663),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(665),
    [anon_sym_67] = ACTIONS(665),
    [anon_sym_PLUS] = ACTIONS(667),
    [sym_plusplus] = ACTIONS(655),
    [anon_sym_BSLASHoplus] = ACTIONS(669),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(669),
    [anon_sym_68] = ACTIONS(669),
    [anon_sym_BSLASHominus] = ACTIONS(671),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(671),
    [anon_sym_69] = ACTIONS(671),
    [sym_mod] = ACTIONS(595),
    [sym_modmod] = ACTIONS(655),
    [sym_vert] = ACTIONS(595),
    [anon_sym_PIPE_PIPE] = ACTIONS(673),
    [anon_sym_70] = ACTIONS(673),
    [sym_minusminus] = ACTIONS(655),
    [sym_amp] = ACTIONS(595),
    [sym_ampamp] = ACTIONS(655),
    [anon_sym_BSLASHodot] = ACTIONS(675),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(675),
    [anon_sym_71] = ACTIONS(675),
    [anon_sym_BSLASHoslash] = ACTIONS(677),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(677),
    [anon_sym_72] = ACTIONS(677),
    [anon_sym_BSLASHotimes] = ACTIONS(679),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(679),
    [anon_sym_73] = ACTIONS(679),
    [sym_mul] = ACTIONS(595),
    [sym_mulmul] = ACTIONS(655),
    [sym_slash] = ACTIONS(595),
    [sym_slashslash] = ACTIONS(655),
    [anon_sym_BSLASHbigcirc] = ACTIONS(681),
    [anon_sym_74] = ACTIONS(681),
    [anon_sym_BSLASHbullet] = ACTIONS(683),
    [anon_sym_75] = ACTIONS(683),
    [anon_sym_BSLASHdiv] = ACTIONS(685),
    [anon_sym_76] = ACTIONS(685),
    [anon_sym_BSLASHcirc] = ACTIONS(687),
    [anon_sym_77] = ACTIONS(687),
    [anon_sym_BSLASHstar] = ACTIONS(689),
    [anon_sym_78] = ACTIONS(689),
    [anon_sym_BANG_BANG] = ACTIONS(691),
    [anon_sym_79] = ACTIONS(691),
    [anon_sym_QMARK_QMARK] = ACTIONS(693),
    [anon_sym_80] = ACTIONS(693),
    [sym_hashhash] = ACTIONS(655),
    [sym_dol] = ACTIONS(595),
    [sym_doldol] = ACTIONS(655),
    [anon_sym_BSLASHsqcap] = ACTIONS(695),
    [anon_sym_81] = ACTIONS(695),
    [anon_sym_BSLASHsqcup] = ACTIONS(697),
    [anon_sym_82] = ACTIONS(697),
    [anon_sym_BSLASHuplus] = ACTIONS(699),
    [anon_sym_83] = ACTIONS(699),
    [anon_sym_BSLASHwr] = ACTIONS(701),
    [anon_sym_85] = ACTIONS(701),
    [anon_sym_BSLASHcdot] = ACTIONS(703),
    [anon_sym_86] = ACTIONS(703),
    [sym_pow] = ACTIONS(595),
    [sym_powpow] = ACTIONS(655),
    [anon_sym_CARET_PLUS] = ACTIONS(705),
    [anon_sym_87] = ACTIONS(705),
    [sym_asterisk] = ACTIONS(707),
    [sym_sup_hash] = ACTIONS(707),
    [sym_prime] = ACTIONS(707),
    [sym__indent] = ACTIONS(483),
  },
  [31] = {
    [sym_block_comment] = STATE(31),
    [sym_forall] = STATE(3686),
    [sym_exists] = STATE(3686),
    [sym_temporal_forall] = STATE(4871),
    [sym_temporal_exists] = STATE(4871),
    [sym_langle_bracket] = STATE(79),
    [sym__op_or_expr] = STATE(3346),
    [sym__op] = STATE(3307),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2203),
    [sym_bound_nonfix_op] = STATE(2203),
    [sym_lambda] = STATE(3303),
    [sym__expr] = STATE(1092),
    [sym_prefixed_op] = STATE(2218),
    [sym__number] = STATE(2218),
    [sym_nat_number] = STATE(2226),
    [sym_binary_number] = STATE(2226),
    [sym_octal_number] = STATE(2226),
    [sym_hex_number] = STATE(2226),
    [sym_string] = STATE(2218),
    [sym_boolean] = STATE(2218),
    [sym__primitive_value_set] = STATE(2218),
    [sym_nat_number_set] = STATE(2222),
    [sym_int_number_set] = STATE(2222),
    [sym_real_number_set] = STATE(2222),
    [sym_label] = STATE(2218),
    [sym_subexpression] = STATE(2218),
    [sym_parentheses] = STATE(2218),
    [sym_bounded_quantification] = STATE(2218),
    [sym_unbounded_quantification] = STATE(2218),
    [sym_choose] = STATE(2218),
    [sym_finite_set_literal] = STATE(2218),
    [sym_set_filter] = STATE(2218),
    [sym_set_map] = STATE(2218),
    [sym_function_evaluation] = STATE(2218),
    [sym_function_literal] = STATE(2218),
    [sym_set_of_functions] = STATE(2218),
    [sym_record_literal] = STATE(2218),
    [sym_set_of_records] = STATE(2218),
    [sym_record_value] = STATE(2218),
    [sym_except] = STATE(2218),
    [sym_prev_func_val] = STATE(2218),
    [sym_tuple_literal] = STATE(2218),
    [sym_step_expr_or_stutter] = STATE(2218),
    [sym_step_expr_no_stutter] = STATE(2218),
    [sym_fairness] = STATE(2218),
    [sym_if_then_else] = STATE(2218),
    [sym_case] = STATE(2218),
    [sym_let_in] = STATE(2218),
    [sym_conj_list] = STATE(2218),
    [sym_disj_list] = STATE(2218),
    [sym_lnot] = STATE(5),
    [sym_union] = STATE(8),
    [sym_powerset] = STATE(8),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(834),
    [sym_enabled] = STATE(6),
    [sym_unchanged] = STATE(6),
    [sym_always] = STATE(6),
    [sym_eventually] = STATE(6),
    [sym_prefix_op_symbol] = STATE(3317),
    [sym_bound_prefix_op] = STATE(2218),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(3321),
    [sym_bound_infix_op] = STATE(2218),
    [sym_sup_plus] = STATE(3300),
    [sym_postfix_op_symbol] = STATE(3317),
    [sym_bound_postfix_op] = STATE(2218),
    [sym_module_ref] = STATE(3346),
    [sym_proof_step_ref] = STATE(2204),
    [sym_identifier] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(489),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(511),
    [anon_sym_15] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_UNION] = ACTIONS(513),
    [anon_sym_ENABLED] = ACTIONS(515),
    [anon_sym_CASE] = ACTIONS(287),
    [anon_sym_SF_] = ACTIONS(289),
    [anon_sym_WF_] = ACTIONS(289),
    [anon_sym_CHOOSE] = ACTIONS(291),
    [anon_sym_IF] = ACTIONS(293),
    [anon_sym_SUBSET] = ACTIONS(517),
    [anon_sym_DOMAIN] = ACTIONS(519),
    [anon_sym_LET] = ACTIONS(301),
    [anon_sym_UNCHANGED] = ACTIONS(521),
    [anon_sym_LAMBDA] = ACTIONS(523),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(309),
    [aux_sym_child_id_token1] = ACTIONS(311),
    [sym_real_number] = ACTIONS(313),
    [anon_sym_BSLASHb] = ACTIONS(315),
    [anon_sym_BSLASHB] = ACTIONS(317),
    [anon_sym_BSLASHo] = ACTIONS(525),
    [anon_sym_BSLASHO] = ACTIONS(321),
    [anon_sym_BSLASHh] = ACTIONS(323),
    [anon_sym_BSLASHH] = ACTIONS(323),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_TRUE] = ACTIONS(327),
    [anon_sym_FALSE] = ACTIONS(327),
    [sym_string_set] = ACTIONS(329),
    [sym_boolean_set] = ACTIONS(329),
    [anon_sym_Nat] = ACTIONS(331),
    [anon_sym_17] = ACTIONS(333),
    [anon_sym_Int] = ACTIONS(335),
    [anon_sym_18] = ACTIONS(337),
    [anon_sym_Real] = ACTIONS(339),
    [anon_sym_19] = ACTIONS(341),
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(527),
    [anon_sym_BSLASHneg] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(529),
    [anon_sym_20] = ACTIONS(527),
    [anon_sym_DASH] = ACTIONS(531),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(533),
    [anon_sym_21] = ACTIONS(533),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(357),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(535),
    [anon_sym_87] = ACTIONS(535),
    [sym_asterisk] = ACTIONS(537),
    [sym_sup_hash] = ACTIONS(537),
    [sym_prime] = ACTIONS(537),
    [sym__indent] = ACTIONS(359),
  },
  [32] = {
    [sym_block_comment] = STATE(32),
    [sym_forall] = STATE(3705),
    [sym_exists] = STATE(3705),
    [sym_temporal_forall] = STATE(4812),
    [sym_temporal_exists] = STATE(4812),
    [sym_langle_bracket] = STATE(41),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2347),
    [sym_bound_nonfix_op] = STATE(2347),
    [sym__expr] = STATE(1231),
    [sym_prefixed_op] = STATE(2379),
    [sym__number] = STATE(2379),
    [sym_nat_number] = STATE(2365),
    [sym_binary_number] = STATE(2365),
    [sym_octal_number] = STATE(2365),
    [sym_hex_number] = STATE(2365),
    [sym_string] = STATE(2379),
    [sym_boolean] = STATE(2379),
    [sym__primitive_value_set] = STATE(2379),
    [sym_nat_number_set] = STATE(2371),
    [sym_int_number_set] = STATE(2371),
    [sym_real_number_set] = STATE(2371),
    [sym_label] = STATE(2379),
    [sym_subexpression] = STATE(2379),
    [sym_parentheses] = STATE(2379),
    [sym_bounded_quantification] = STATE(2379),
    [sym_unbounded_quantification] = STATE(2379),
    [sym_choose] = STATE(2379),
    [sym_finite_set_literal] = STATE(2379),
    [sym_set_filter] = STATE(2379),
    [sym_set_map] = STATE(2379),
    [sym_function_evaluation] = STATE(2379),
    [sym_function_literal] = STATE(2379),
    [sym_set_of_functions] = STATE(2379),
    [sym_record_literal] = STATE(2379),
    [sym_set_of_records] = STATE(2379),
    [sym_record_value] = STATE(2379),
    [sym_except] = STATE(2379),
    [sym_prev_func_val] = STATE(2379),
    [sym_tuple_literal] = STATE(2379),
    [sym_step_expr_or_stutter] = STATE(2379),
    [sym_step_expr_no_stutter] = STATE(2379),
    [sym_fairness] = STATE(2379),
    [sym_if_then_else] = STATE(2379),
    [sym_case] = STATE(2379),
    [sym_let_in] = STATE(2379),
    [sym_conj_list] = STATE(2379),
    [sym_disj_list] = STATE(2379),
    [sym_lnot] = STATE(296),
    [sym_union] = STATE(295),
    [sym_powerset] = STATE(295),
    [sym_domain] = STATE(294),
    [sym_negative] = STATE(974),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_prefix_op_symbol] = STATE(4661),
    [sym_bound_prefix_op] = STATE(2379),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4610),
    [sym_bound_infix_op] = STATE(2379),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4661),
    [sym_bound_postfix_op] = STATE(2379),
    [sym_proof_step_ref] = STATE(2352),
    [sym_identifier] = ACTIONS(709),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_CASE] = ACTIONS(714),
    [anon_sym_SF_] = ACTIONS(716),
    [anon_sym_WF_] = ACTIONS(716),
    [anon_sym_CHOOSE] = ACTIONS(718),
    [anon_sym_IF] = ACTIONS(720),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(722),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_LBRACK] = ACTIONS(727),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(729),
    [sym_real_number] = ACTIONS(731),
    [anon_sym_BSLASHb] = ACTIONS(733),
    [anon_sym_BSLASHB] = ACTIONS(735),
    [anon_sym_BSLASHo] = ACTIONS(737),
    [anon_sym_BSLASHO] = ACTIONS(739),
    [anon_sym_BSLASHh] = ACTIONS(741),
    [anon_sym_BSLASHH] = ACTIONS(741),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_TRUE] = ACTIONS(745),
    [anon_sym_FALSE] = ACTIONS(745),
    [sym_string_set] = ACTIONS(747),
    [sym_boolean_set] = ACTIONS(747),
    [anon_sym_Nat] = ACTIONS(749),
    [anon_sym_17] = ACTIONS(751),
    [anon_sym_Int] = ACTIONS(753),
    [anon_sym_18] = ACTIONS(755),
    [anon_sym_Real] = ACTIONS(757),
    [anon_sym_19] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(761),
    [anon_sym_RBRACE] = ACTIONS(272),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(763),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [anon_sym_end] = ACTIONS(279),
    [sym__indent] = ACTIONS(765),
  },
  [33] = {
    [sym_block_comment] = STATE(33),
    [sym_forall] = STATE(3705),
    [sym_exists] = STATE(3705),
    [sym_temporal_forall] = STATE(4812),
    [sym_temporal_exists] = STATE(4812),
    [sym_langle_bracket] = STATE(41),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2347),
    [sym_bound_nonfix_op] = STATE(2347),
    [sym__expr] = STATE(1233),
    [sym_prefixed_op] = STATE(2379),
    [sym__number] = STATE(2379),
    [sym_nat_number] = STATE(2365),
    [sym_binary_number] = STATE(2365),
    [sym_octal_number] = STATE(2365),
    [sym_hex_number] = STATE(2365),
    [sym_string] = STATE(2379),
    [sym_boolean] = STATE(2379),
    [sym__primitive_value_set] = STATE(2379),
    [sym_nat_number_set] = STATE(2371),
    [sym_int_number_set] = STATE(2371),
    [sym_real_number_set] = STATE(2371),
    [sym_label] = STATE(2379),
    [sym_subexpression] = STATE(2379),
    [sym_parentheses] = STATE(2379),
    [sym_bounded_quantification] = STATE(2379),
    [sym_unbounded_quantification] = STATE(2379),
    [sym_choose] = STATE(2379),
    [sym_finite_set_literal] = STATE(2379),
    [sym_set_filter] = STATE(2379),
    [sym_set_map] = STATE(2379),
    [sym_function_evaluation] = STATE(2379),
    [sym_function_literal] = STATE(2379),
    [sym_set_of_functions] = STATE(2379),
    [sym_record_literal] = STATE(2379),
    [sym_set_of_records] = STATE(2379),
    [sym_record_value] = STATE(2379),
    [sym_except] = STATE(2379),
    [sym_prev_func_val] = STATE(2379),
    [sym_tuple_literal] = STATE(2379),
    [sym_step_expr_or_stutter] = STATE(2379),
    [sym_step_expr_no_stutter] = STATE(2379),
    [sym_fairness] = STATE(2379),
    [sym_if_then_else] = STATE(2379),
    [sym_case] = STATE(2379),
    [sym_let_in] = STATE(2379),
    [sym_conj_list] = STATE(2379),
    [sym_disj_list] = STATE(2379),
    [sym_lnot] = STATE(296),
    [sym_union] = STATE(295),
    [sym_powerset] = STATE(295),
    [sym_domain] = STATE(294),
    [sym_negative] = STATE(974),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_prefix_op_symbol] = STATE(4661),
    [sym_bound_prefix_op] = STATE(2379),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4610),
    [sym_bound_infix_op] = STATE(2379),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4661),
    [sym_bound_postfix_op] = STATE(2379),
    [sym_proof_step_ref] = STATE(2352),
    [sym_identifier] = ACTIONS(709),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_CASE] = ACTIONS(714),
    [anon_sym_SF_] = ACTIONS(716),
    [anon_sym_WF_] = ACTIONS(716),
    [anon_sym_CHOOSE] = ACTIONS(718),
    [anon_sym_IF] = ACTIONS(720),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(722),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_LBRACK] = ACTIONS(727),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(729),
    [sym_real_number] = ACTIONS(731),
    [anon_sym_BSLASHb] = ACTIONS(733),
    [anon_sym_BSLASHB] = ACTIONS(735),
    [anon_sym_BSLASHo] = ACTIONS(737),
    [anon_sym_BSLASHO] = ACTIONS(739),
    [anon_sym_BSLASHh] = ACTIONS(741),
    [anon_sym_BSLASHH] = ACTIONS(741),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_TRUE] = ACTIONS(745),
    [anon_sym_FALSE] = ACTIONS(745),
    [sym_string_set] = ACTIONS(747),
    [sym_boolean_set] = ACTIONS(747),
    [anon_sym_Nat] = ACTIONS(749),
    [anon_sym_17] = ACTIONS(751),
    [anon_sym_Int] = ACTIONS(753),
    [anon_sym_18] = ACTIONS(755),
    [anon_sym_Real] = ACTIONS(757),
    [anon_sym_19] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(761),
    [anon_sym_RBRACE] = ACTIONS(272),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(763),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [anon_sym_end] = ACTIONS(279),
    [sym__indent] = ACTIONS(765),
  },
  [34] = {
    [sym_block_comment] = STATE(34),
    [sym_forall] = STATE(3705),
    [sym_exists] = STATE(3705),
    [sym_temporal_forall] = STATE(4812),
    [sym_temporal_exists] = STATE(4812),
    [sym_langle_bracket] = STATE(41),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2347),
    [sym_bound_nonfix_op] = STATE(2347),
    [sym__expr] = STATE(1234),
    [sym_prefixed_op] = STATE(2379),
    [sym__number] = STATE(2379),
    [sym_nat_number] = STATE(2365),
    [sym_binary_number] = STATE(2365),
    [sym_octal_number] = STATE(2365),
    [sym_hex_number] = STATE(2365),
    [sym_string] = STATE(2379),
    [sym_boolean] = STATE(2379),
    [sym__primitive_value_set] = STATE(2379),
    [sym_nat_number_set] = STATE(2371),
    [sym_int_number_set] = STATE(2371),
    [sym_real_number_set] = STATE(2371),
    [sym_label] = STATE(2379),
    [sym_subexpression] = STATE(2379),
    [sym_parentheses] = STATE(2379),
    [sym_bounded_quantification] = STATE(2379),
    [sym_unbounded_quantification] = STATE(2379),
    [sym_choose] = STATE(2379),
    [sym_finite_set_literal] = STATE(2379),
    [sym_set_filter] = STATE(2379),
    [sym_set_map] = STATE(2379),
    [sym_function_evaluation] = STATE(2379),
    [sym_function_literal] = STATE(2379),
    [sym_set_of_functions] = STATE(2379),
    [sym_record_literal] = STATE(2379),
    [sym_set_of_records] = STATE(2379),
    [sym_record_value] = STATE(2379),
    [sym_except] = STATE(2379),
    [sym_prev_func_val] = STATE(2379),
    [sym_tuple_literal] = STATE(2379),
    [sym_step_expr_or_stutter] = STATE(2379),
    [sym_step_expr_no_stutter] = STATE(2379),
    [sym_fairness] = STATE(2379),
    [sym_if_then_else] = STATE(2379),
    [sym_case] = STATE(2379),
    [sym_let_in] = STATE(2379),
    [sym_conj_list] = STATE(2379),
    [sym_disj_list] = STATE(2379),
    [sym_lnot] = STATE(296),
    [sym_union] = STATE(295),
    [sym_powerset] = STATE(295),
    [sym_domain] = STATE(294),
    [sym_negative] = STATE(974),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_prefix_op_symbol] = STATE(4661),
    [sym_bound_prefix_op] = STATE(2379),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4610),
    [sym_bound_infix_op] = STATE(2379),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4661),
    [sym_bound_postfix_op] = STATE(2379),
    [sym_proof_step_ref] = STATE(2352),
    [sym_identifier] = ACTIONS(709),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_CASE] = ACTIONS(714),
    [anon_sym_SF_] = ACTIONS(716),
    [anon_sym_WF_] = ACTIONS(716),
    [anon_sym_CHOOSE] = ACTIONS(718),
    [anon_sym_IF] = ACTIONS(720),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(722),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_LBRACK] = ACTIONS(727),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(729),
    [sym_real_number] = ACTIONS(731),
    [anon_sym_BSLASHb] = ACTIONS(733),
    [anon_sym_BSLASHB] = ACTIONS(735),
    [anon_sym_BSLASHo] = ACTIONS(737),
    [anon_sym_BSLASHO] = ACTIONS(739),
    [anon_sym_BSLASHh] = ACTIONS(741),
    [anon_sym_BSLASHH] = ACTIONS(741),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_TRUE] = ACTIONS(745),
    [anon_sym_FALSE] = ACTIONS(745),
    [sym_string_set] = ACTIONS(747),
    [sym_boolean_set] = ACTIONS(747),
    [anon_sym_Nat] = ACTIONS(749),
    [anon_sym_17] = ACTIONS(751),
    [anon_sym_Int] = ACTIONS(753),
    [anon_sym_18] = ACTIONS(755),
    [anon_sym_Real] = ACTIONS(757),
    [anon_sym_19] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(761),
    [anon_sym_RBRACE] = ACTIONS(272),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(763),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [anon_sym_end] = ACTIONS(279),
    [sym__indent] = ACTIONS(765),
  },
  [35] = {
    [sym_block_comment] = STATE(35),
    [sym_forall] = STATE(3705),
    [sym_exists] = STATE(3705),
    [sym_temporal_forall] = STATE(4812),
    [sym_temporal_exists] = STATE(4812),
    [sym_langle_bracket] = STATE(41),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2347),
    [sym_bound_nonfix_op] = STATE(2347),
    [sym__expr] = STATE(1211),
    [sym_prefixed_op] = STATE(2379),
    [sym__number] = STATE(2379),
    [sym_nat_number] = STATE(2365),
    [sym_binary_number] = STATE(2365),
    [sym_octal_number] = STATE(2365),
    [sym_hex_number] = STATE(2365),
    [sym_string] = STATE(2379),
    [sym_boolean] = STATE(2379),
    [sym__primitive_value_set] = STATE(2379),
    [sym_nat_number_set] = STATE(2371),
    [sym_int_number_set] = STATE(2371),
    [sym_real_number_set] = STATE(2371),
    [sym_label] = STATE(2379),
    [sym_subexpression] = STATE(2379),
    [sym_parentheses] = STATE(2379),
    [sym_bounded_quantification] = STATE(2379),
    [sym_unbounded_quantification] = STATE(2379),
    [sym_choose] = STATE(2379),
    [sym_finite_set_literal] = STATE(2379),
    [sym_set_filter] = STATE(2379),
    [sym_set_map] = STATE(2379),
    [sym_function_evaluation] = STATE(2379),
    [sym_function_literal] = STATE(2379),
    [sym_set_of_functions] = STATE(2379),
    [sym_record_literal] = STATE(2379),
    [sym_set_of_records] = STATE(2379),
    [sym_record_value] = STATE(2379),
    [sym_except] = STATE(2379),
    [sym_prev_func_val] = STATE(2379),
    [sym_tuple_literal] = STATE(2379),
    [sym_step_expr_or_stutter] = STATE(2379),
    [sym_step_expr_no_stutter] = STATE(2379),
    [sym_fairness] = STATE(2379),
    [sym_if_then_else] = STATE(2379),
    [sym_case] = STATE(2379),
    [sym_let_in] = STATE(2379),
    [sym_conj_list] = STATE(2379),
    [sym_disj_list] = STATE(2379),
    [sym_lnot] = STATE(296),
    [sym_union] = STATE(295),
    [sym_powerset] = STATE(295),
    [sym_domain] = STATE(294),
    [sym_negative] = STATE(974),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_prefix_op_symbol] = STATE(4661),
    [sym_bound_prefix_op] = STATE(2379),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(4610),
    [sym_bound_infix_op] = STATE(2379),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4661),
    [sym_bound_postfix_op] = STATE(2379),
    [sym_proof_step_ref] = STATE(2352),
    [sym_identifier] = ACTIONS(709),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(274),
    [anon_sym_15] = ACTIONS(274),
    [anon_sym_AT] = ACTIONS(712),
    [anon_sym_UNION] = ACTIONS(281),
    [anon_sym_ENABLED] = ACTIONS(284),
    [anon_sym_CASE] = ACTIONS(714),
    [anon_sym_SF_] = ACTIONS(716),
    [anon_sym_WF_] = ACTIONS(716),
    [anon_sym_CHOOSE] = ACTIONS(718),
    [anon_sym_IF] = ACTIONS(720),
    [anon_sym_SUBSET] = ACTIONS(295),
    [anon_sym_INSTANCE] = ACTIONS(279),
    [anon_sym_DOMAIN] = ACTIONS(298),
    [anon_sym_LET] = ACTIONS(722),
    [anon_sym_UNCHANGED] = ACTIONS(303),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(724),
    [anon_sym_LBRACK] = ACTIONS(727),
    [anon_sym_BANG] = ACTIONS(279),
    [aux_sym_child_id_token1] = ACTIONS(729),
    [sym_real_number] = ACTIONS(731),
    [anon_sym_BSLASHb] = ACTIONS(733),
    [anon_sym_BSLASHB] = ACTIONS(735),
    [anon_sym_BSLASHo] = ACTIONS(737),
    [anon_sym_BSLASHO] = ACTIONS(739),
    [anon_sym_BSLASHh] = ACTIONS(741),
    [anon_sym_BSLASHH] = ACTIONS(741),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_TRUE] = ACTIONS(745),
    [anon_sym_FALSE] = ACTIONS(745),
    [sym_string_set] = ACTIONS(747),
    [sym_boolean_set] = ACTIONS(747),
    [anon_sym_Nat] = ACTIONS(749),
    [anon_sym_17] = ACTIONS(751),
    [anon_sym_Int] = ACTIONS(753),
    [anon_sym_18] = ACTIONS(755),
    [anon_sym_Real] = ACTIONS(757),
    [anon_sym_19] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(761),
    [anon_sym_RBRACE] = ACTIONS(272),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(345),
    [anon_sym_BSLASHneg] = ACTIONS(345),
    [anon_sym_TILDE] = ACTIONS(348),
    [anon_sym_20] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(351),
    [anon_sym_LT_GT] = ACTIONS(354),
    [anon_sym_21] = ACTIONS(354),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(763),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = ACTIONS(213),
    [anon_sym_65] = ACTIONS(213),
    [anon_sym_DOT_DOT] = ACTIONS(215),
    [anon_sym_66] = ACTIONS(217),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(219),
    [anon_sym_67] = ACTIONS(219),
    [anon_sym_PLUS] = ACTIONS(221),
    [sym_plusplus] = ACTIONS(209),
    [anon_sym_BSLASHoplus] = ACTIONS(223),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(223),
    [anon_sym_68] = ACTIONS(223),
    [anon_sym_BSLASHominus] = ACTIONS(225),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(225),
    [anon_sym_69] = ACTIONS(225),
    [sym_mod] = ACTIONS(149),
    [sym_modmod] = ACTIONS(209),
    [sym_vert] = ACTIONS(149),
    [anon_sym_PIPE_PIPE] = ACTIONS(227),
    [anon_sym_70] = ACTIONS(227),
    [sym_minusminus] = ACTIONS(209),
    [sym_amp] = ACTIONS(149),
    [sym_ampamp] = ACTIONS(209),
    [anon_sym_BSLASHodot] = ACTIONS(229),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(229),
    [anon_sym_71] = ACTIONS(229),
    [anon_sym_BSLASHoslash] = ACTIONS(231),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(231),
    [anon_sym_72] = ACTIONS(231),
    [anon_sym_BSLASHotimes] = ACTIONS(233),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [sym_mul] = ACTIONS(149),
    [sym_mulmul] = ACTIONS(209),
    [sym_slash] = ACTIONS(149),
    [sym_slashslash] = ACTIONS(209),
    [anon_sym_BSLASHbigcirc] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [anon_sym_BSLASHbullet] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [anon_sym_BSLASHdiv] = ACTIONS(239),
    [anon_sym_76] = ACTIONS(239),
    [anon_sym_BSLASHcirc] = ACTIONS(241),
    [anon_sym_77] = ACTIONS(241),
    [anon_sym_BSLASHstar] = ACTIONS(243),
    [anon_sym_78] = ACTIONS(243),
    [anon_sym_BANG_BANG] = ACTIONS(245),
    [anon_sym_79] = ACTIONS(245),
    [anon_sym_QMARK_QMARK] = ACTIONS(247),
    [anon_sym_80] = ACTIONS(247),
    [sym_hashhash] = ACTIONS(209),
    [sym_dol] = ACTIONS(149),
    [sym_doldol] = ACTIONS(209),
    [anon_sym_BSLASHsqcap] = ACTIONS(249),
    [anon_sym_81] = ACTIONS(249),
    [anon_sym_BSLASHsqcup] = ACTIONS(251),
    [anon_sym_82] = ACTIONS(251),
    [anon_sym_BSLASHuplus] = ACTIONS(253),
    [anon_sym_83] = ACTIONS(253),
    [anon_sym_BSLASHwr] = ACTIONS(255),
    [anon_sym_85] = ACTIONS(255),
    [anon_sym_BSLASHcdot] = ACTIONS(257),
    [anon_sym_86] = ACTIONS(257),
    [sym_pow] = ACTIONS(149),
    [sym_powpow] = ACTIONS(209),
    [anon_sym_CARET_PLUS] = ACTIONS(259),
    [anon_sym_87] = ACTIONS(259),
    [sym_asterisk] = ACTIONS(261),
    [sym_sup_hash] = ACTIONS(261),
    [sym_prime] = ACTIONS(261),
    [anon_sym_end] = ACTIONS(279),
    [sym__indent] = ACTIONS(765),
  },
  [36] = {
    [sym_block_comment] = STATE(36),
    [sym_forall] = STATE(3693),
    [sym_exists] = STATE(3693),
    [sym_temporal_forall] = STATE(5017),
    [sym_temporal_exists] = STATE(5017),
    [sym_langle_bracket] = STATE(92),
    [sym__op_or_expr] = STATE(4153),
    [sym__op] = STATE(3307),
    [sym_subexpr_prefix] = STATE(1198),
    [sym_subexpr_component] = STATE(5014),
    [sym_bound_op] = STATE(2271),
    [sym_bound_nonfix_op] = STATE(2271),
    [sym_lambda] = STATE(3303),
    [sym__expr] = STATE(1795),
    [sym_prefixed_op] = STATE(2323),
    [sym__number] = STATE(2323),
    [sym_nat_number] = STATE(2329),
    [sym_binary_number] = STATE(2329),
    [sym_octal_number] = STATE(2329),
    [sym_hex_number] = STATE(2329),
    [sym_string] = STATE(2323),
    [sym_boolean] = STATE(2323),
    [sym__primitive_value_set] = STATE(2323),
    [sym_nat_number_set] = STATE(2283),
    [sym_int_number_set] = STATE(2283),
    [sym_real_number_set] = STATE(2283),
    [sym_label] = STATE(2323),
    [sym_subexpression] = STATE(2323),
    [sym_parentheses] = STATE(2323),
    [sym_bounded_quantification] = STATE(2323),
    [sym_unbounded_quantification] = STATE(2323),
    [sym_choose] = STATE(2323),
    [sym_finite_set_literal] = STATE(2323),
    [sym_set_filter] = STATE(2323),
    [sym_set_map] = STATE(2323),
    [sym_function_evaluation] = STATE(2323),
    [sym_function_literal] = STATE(2323),
    [sym_set_of_functions] = STATE(2323),
    [sym_record_literal] = STATE(2323),
    [sym_set_of_records] = STATE(2323),
    [sym_record_value] = STATE(2323),
    [sym_except] = STATE(2323),
    [sym_prev_func_val] = STATE(2323),
    [sym_tuple_literal] = STATE(2323),
    [sym_step_expr_or_stutter] = STATE(2323),
    [sym_step_expr_no_stutter] = STATE(2323),
    [sym_fairness] = STATE(2323),
    [sym_if_then_else] = STATE(2323),
    [sym_case] = STATE(2323),
    [sym_let_in] = STATE(2323),
    [sym_conj_list] = STATE(2323),
    [sym_disj_list] = STATE(2323),
    [sym_lnot] = STATE(91),
    [sym_union] = STATE(90),
    [sym_powerset] = STATE(90),
    [sym_domain] = STATE(89),
    [sym_negative] = STATE(516),
    [sym_enabled] = STATE(88),
    [sym_unchanged] = STATE(88),
    [sym_always] = STATE(88),
    [sym_eventually] = STATE(88),
    [sym_prefix_op_symbol] = STATE(4088),
    [sym_bound_prefix_op] = STATE(2323),
    [sym_implies] = STATE(3241),
    [sym_plus_arrow] = STATE(3241),
    [sym_equiv] = STATE(3241),
    [sym_iff] = STATE(3241),
    [sym_leads_to] = STATE(3241),
    [sym_land] = STATE(3241),
    [sym_lor] = STATE(3241),
    [sym_assign] = STATE(3241),
    [sym_bnf_rule] = STATE(3241),
    [sym_eq] = STATE(3241),
    [sym_neq] = STATE(3241),
    [sym_lt] = STATE(3241),
    [sym_leq] = STATE(3241),
    [sym_geq] = STATE(3241),
    [sym_approx] = STATE(3241),
    [sym_rs_ttile] = STATE(3241),
    [sym_rd_ttile] = STATE(3241),
    [sym_ls_ttile] = STATE(3241),
    [sym_ld_ttile] = STATE(3241),
    [sym_asymp] = STATE(3241),
    [sym_cong] = STATE(3241),
    [sym_doteq] = STATE(3241),
    [sym_gg] = STATE(3241),
    [sym_ll] = STATE(3241),
    [sym_in] = STATE(3241),
    [sym_notin] = STATE(3241),
    [sym_prec] = STATE(3241),
    [sym_succ] = STATE(3241),
    [sym_preceq] = STATE(3241),
    [sym_succeq] = STATE(3241),
    [sym_sim] = STATE(3241),
    [sym_simeq] = STATE(3241),
    [sym_sqsubset] = STATE(3241),
    [sym_sqsupset] = STATE(3241),
    [sym_sqsubseteq] = STATE(3241),
    [sym_sqsupseteq] = STATE(3241),
    [sym_cap] = STATE(3241),
    [sym_cup] = STATE(3241),
    [sym_dots_2] = STATE(3241),
    [sym_dots_3] = STATE(3241),
    [sym_plus] = STATE(3241),
    [sym_oplus] = STATE(3241),
    [sym_ominus] = STATE(3241),
    [sym_vertvert] = STATE(3241),
    [sym_minus] = STATE(3241),
    [sym_odot] = STATE(3241),
    [sym_oslash] = STATE(3241),
    [sym_otimes] = STATE(3241),
    [sym_bigcirc] = STATE(3241),
    [sym_bullet] = STATE(3241),
    [sym_div] = STATE(3241),
    [sym_circ] = STATE(3241),
    [sym_star] = STATE(3241),
    [sym_excl] = STATE(3241),
    [sym_qq] = STATE(3241),
    [sym_sqcap] = STATE(3241),
    [sym_sqcup] = STATE(3241),
    [sym_uplus] = STATE(3241),
    [sym_wr] = STATE(3241),
    [sym_cdot] = STATE(3241),
    [sym_infix_op_symbol] = STATE(3986),
    [sym_bound_infix_op] = STATE(2323),
    [sym_sup_plus] = STATE(3448),
    [sym_postfix_op_symbol] = STATE(4088),
    [sym_bound_postfix_op] = STATE(2323),
    [sym_proof_step_ref] = STATE(2272),
    [sym_identifier] = ACTIONS(767),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_5] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_6] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_11] = ACTIONS(29),
    [anon_sym_12] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_15] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(363),
    [sym_placeholder] = ACTIONS(769),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(369),
    [anon_sym_SF_] = ACTIONS(371),
    [anon_sym_WF_] = ACTIONS(371),
    [anon_sym_CHOOSE] = ACTIONS(373),
    [anon_sym_IF] = ACTIONS(375),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(377),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_LBRACK] = ACTIONS(383),
    [aux_sym_child_id_token1] = ACTIONS(385),
    [sym_real_number] = ACTIONS(387),
    [anon_sym_BSLASHb] = ACTIONS(389),
    [anon_sym_BSLASHB] = ACTIONS(391),
    [anon_sym_BSLASHo] = ACTIONS(393),
    [anon_sym_BSLASHO] = ACTIONS(395),
    [anon_sym_BSLASHh] = ACTIONS(397),
    [anon_sym_BSLASHH] = ACTIONS(397),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_TRUE] = ACTIONS(401),
    [anon_sym_FALSE] = ACTIONS(401),
    [sym_string_set] = ACTIONS(403),
    [sym_boolean_set] = ACTIONS(403),
    [anon_sym_Nat] = ACTIONS(405),
    [anon_sym_17] = ACTIONS(407),
    [anon_sym_Int] = ACTIONS(409),
    [anon_sym_18] = ACTIONS(411),
    [anon_sym_Real] = ACTIONS(413),
    [anon_sym_19] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(113),
    [anon_sym_BSLASHlnot] = ACTIONS(115),
    [anon_sym_BSLASHneg] = ACTIONS(115),
    [anon_sym_TILDE] = ACTIONS(117),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(119),
    [sym_negative_dot] = ACTIONS(121),
    [anon_sym_LT_GT] = ACTIONS(123),
    [anon_sym_21] = ACTIONS(123),
    [anon_sym_EQ_GT] = ACTIONS(125),
    [anon_sym_22] = ACTIONS(125),
    [anon_sym_23] = ACTIONS(125),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(127),
    [anon_sym_24] = ACTIONS(127),
    [anon_sym_25] = ACTIONS(127),
    [anon_sym_BSLASHequiv] = ACTIONS(129),
    [anon_sym_26] = ACTIONS(129),
    [anon_sym_LT_EQ_GT] = ACTIONS(131),
    [anon_sym_27] = ACTIONS(131),
    [anon_sym_28] = ACTIONS(131),
    [anon_sym_TILDE_GT] = ACTIONS(133),
    [anon_sym_29] = ACTIONS(133),
    [anon_sym_30] = ACTIONS(133),
    [anon_sym_SLASH_BSLASH] = ACTIONS(135),
    [anon_sym_BSLASHland] = ACTIONS(135),
    [anon_sym_31] = ACTIONS(135),
    [anon_sym_BSLASH_SLASH] = ACTIONS(137),
    [anon_sym_BSLASHlor] = ACTIONS(137),
    [anon_sym_32] = ACTIONS(137),
    [anon_sym_COLON_EQ] = ACTIONS(139),
    [anon_sym_33] = ACTIONS(139),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(141),
    [anon_sym_34] = ACTIONS(141),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(145),
    [anon_sym_35] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(419),
    [sym_gt] = ACTIONS(149),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_LT] = ACTIONS(153),
    [anon_sym_BSLASHleq] = ACTIONS(153),
    [anon_sym_36] = ACTIONS(153),
    [anon_sym_GT_EQ] = ACTIONS(155),
    [anon_sym_BSLASHgeq] = ACTIONS(155),
    [anon_sym_37] = ACTIONS(155),
    [anon_sym_BSLASHapprox] = ACTIONS(157),
    [anon_sym_38] = ACTIONS(157),
    [anon_sym_PIPE_DASH] = ACTIONS(159),
    [anon_sym_39] = ACTIONS(159),
    [anon_sym_PIPE_EQ] = ACTIONS(161),
    [anon_sym_40] = ACTIONS(161),
    [anon_sym_DASH_PIPE] = ACTIONS(163),
    [anon_sym_41] = ACTIONS(163),
    [anon_sym_EQ_PIPE] = ACTIONS(165),
    [anon_sym_42] = ACTIONS(165),
    [anon_sym_BSLASHasymp] = ACTIONS(167),
    [anon_sym_43] = ACTIONS(167),
    [anon_sym_BSLASHcong] = ACTIONS(169),
    [anon_sym_44] = ACTIONS(169),
    [anon_sym_BSLASHdoteq] = ACTIONS(171),
    [anon_sym_45] = ACTIONS(171),
    [anon_sym_BSLASHgg] = ACTIONS(173),
    [anon_sym_46] = ACTIONS(173),
    [anon_sym_BSLASHll] = ACTIONS(175),
    [anon_sym_47] = ACTIONS(175),
    [anon_sym_BSLASHnotin] = ACTIONS(177),
    [anon_sym_48] = ACTIONS(177),
    [anon_sym_BSLASHprec] = ACTIONS(179),
    [anon_sym_49] = ACTIONS(181),
    [anon_sym_BSLASHsucc] = ACTIONS(183),
    [anon_sym_50] = ACTIONS(185),
    [anon_sym_BSLASHpreceq] = ACTIONS(187),
    [anon_sym_51] = ACTIONS(187),
    [anon_sym_BSLASHsucceq] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHsim] = ACTIONS(191),
    [anon_sym_54] = ACTIONS(193),
    [anon_sym_BSLASHsimeq] = ACTIONS(195),
    [anon_sym_55] = ACTIONS(195),
    [anon_sym_BSLASHsqsubset] = ACTIONS(197),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHsqsupset] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(203),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(205),
    [anon_sym_58] = ACTIONS(205),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(207),
    [anon_sym_59] = ACTIONS(207),
    [sym_compose] = ACTIONS(209),
    [sym_map_to] = ACTIONS(209),
    [sym_map_from] = ACTIONS(209),
    [sym_setminus] = ACTIONS(149),
    [anon_sym_BSLASHcap] = ACTIONS(211),
    [anon_sym_BSLASHintersect] = ACTIONS(211),
    [anon_sym_64] = ACTIONS(211),
    [anon_sym_BSLASHcup] = ACTIONS(213),
    [anon_sym_BSLASHunion] = AC