#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4402
#define LARGE_STATE_COUNT 2926
#define SYMBOL_COUNT 539
#define ALIAS_COUNT 2
#define TOKEN_COUNT 318
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 36

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_LPAREN_STAR = 3,
  anon_sym_MODULE = 4,
  sym_single_line = 5,
  sym_double_line = 6,
  anon_sym_EQ_EQ = 7,
  anon_sym_ = 8,
  anon_sym_BSLASHin = 9,
  anon_sym_2 = 10,
  anon_sym_LT_DASH = 11,
  anon_sym_3 = 12,
  anon_sym_BSLASHA = 13,
  anon_sym_BSLASHforall = 14,
  anon_sym_4 = 15,
  anon_sym_BSLASHE = 16,
  anon_sym_BSLASHexists = 17,
  anon_sym_5 = 18,
  anon_sym_BSLASHAA = 19,
  anon_sym_BSLASHEE = 20,
  anon_sym_PIPE_DASH_GT = 21,
  anon_sym_6 = 22,
  anon_sym_DASH_GT = 23,
  anon_sym_7 = 24,
  anon_sym_LT_LT = 25,
  anon_sym_8 = 26,
  anon_sym_GT_GT = 27,
  anon_sym_9 = 28,
  anon_sym_GT_GT_ = 29,
  anon_sym__ = 30,
  anon_sym_LBRACK_RBRACK = 31,
  anon_sym_10 = 32,
  anon_sym_COLON = 33,
  anon_sym_AT = 34,
  anon_sym_COLON_COLON = 35,
  anon_sym_11 = 36,
  sym_placeholder = 37,
  anon_sym_ASSUME = 38,
  anon_sym_ELSE = 39,
  anon_sym_LOCAL = 40,
  anon_sym_UNION = 41,
  anon_sym_ASSUMPTION = 42,
  anon_sym_ENABLED = 43,
  anon_sym_VARIABLE = 44,
  anon_sym_AXIOM = 45,
  anon_sym_EXCEPT = 46,
  anon_sym_OTHER = 47,
  anon_sym_VARIABLES = 48,
  anon_sym_CASE = 49,
  anon_sym_EXTENDS = 50,
  anon_sym_SF_ = 51,
  anon_sym_WF_ = 52,
  anon_sym_CHOOSE = 53,
  anon_sym_IF = 54,
  anon_sym_SUBSET = 55,
  anon_sym_WITH = 56,
  anon_sym_CONSTANT = 57,
  anon_sym_IN = 58,
  anon_sym_THEN = 59,
  anon_sym_CONSTANTS = 60,
  anon_sym_INSTANCE = 61,
  anon_sym_THEOREM = 62,
  anon_sym_COROLLARY = 63,
  anon_sym_DOMAIN = 64,
  anon_sym_LET = 65,
  anon_sym_UNCHANGED = 66,
  anon_sym_BY = 67,
  anon_sym_HAVE = 68,
  anon_sym_QED = 69,
  anon_sym_TAKE = 70,
  anon_sym_DEF = 71,
  anon_sym_HIDE = 72,
  anon_sym_RECURSIVE = 73,
  anon_sym_USE = 74,
  anon_sym_DEFINE = 75,
  anon_sym_PROOF = 76,
  anon_sym_WITNESS = 77,
  anon_sym_PICK = 78,
  anon_sym_DEFS = 79,
  anon_sym_PROVE = 80,
  anon_sym_SUFFICES = 81,
  anon_sym_NEW = 82,
  anon_sym_LAMBDA = 83,
  anon_sym_STATE = 84,
  anon_sym_ACTION = 85,
  anon_sym_TEMPORAL = 86,
  anon_sym_OBVIOUS = 87,
  anon_sym_OMITTED = 88,
  anon_sym_LEMMA = 89,
  anon_sym_PROPOSITION = 90,
  anon_sym_ONLY = 91,
  anon_sym_COMMA = 92,
  anon_sym_LPAREN = 93,
  anon_sym_RPAREN = 94,
  anon_sym_LBRACK = 95,
  anon_sym_RBRACK = 96,
  anon_sym_BANG = 97,
  aux_sym_child_id_token1 = 98,
  sym_real_number = 99,
  anon_sym_BSLASHb = 100,
  anon_sym_BSLASHB = 101,
  aux_sym_binary_number_token1 = 102,
  anon_sym_BSLASHo = 103,
  anon_sym_BSLASHO = 104,
  aux_sym_octal_number_token1 = 105,
  anon_sym_BSLASHh = 106,
  anon_sym_BSLASHH = 107,
  aux_sym_hex_number_token1 = 108,
  anon_sym_DQUOTE = 109,
  aux_sym_string_token1 = 110,
  anon_sym_DQUOTE2 = 111,
  anon_sym_BSLASH = 112,
  aux_sym_escape_char_token1 = 113,
  anon_sym_TRUE = 114,
  anon_sym_FALSE = 115,
  anon_sym_STRING = 116,
  anon_sym_BOOLEAN = 117,
  anon_sym_Nat = 118,
  anon_sym_Int = 119,
  anon_sym_Real = 120,
  anon_sym_LBRACE = 121,
  anon_sym_RBRACE = 122,
  anon_sym_DOT = 123,
  anon_sym_EQ = 124,
  anon_sym_RBRACK_ = 125,
  anon_sym_BSLASHlnot = 126,
  anon_sym_BSLASHneg = 127,
  anon_sym_TILDE = 128,
  anon_sym_12 = 129,
  anon_sym_DASH = 130,
  sym_negative_dot = 131,
  anon_sym_LT_GT = 132,
  anon_sym_13 = 133,
  anon_sym_EQ_GT = 134,
  anon_sym_14 = 135,
  anon_sym_DASH_PLUS_DASH_GT = 136,
  anon_sym_15 = 137,
  anon_sym_BSLASHequiv = 138,
  anon_sym_16 = 139,
  anon_sym_LT_EQ_GT = 140,
  anon_sym_17 = 141,
  anon_sym_TILDE_GT = 142,
  anon_sym_18 = 143,
  anon_sym_SLASH_BSLASH = 144,
  anon_sym_BSLASHland = 145,
  anon_sym_19 = 146,
  anon_sym_BSLASH_SLASH = 147,
  anon_sym_BSLASHlor = 148,
  anon_sym_20 = 149,
  anon_sym_COLON_EQ = 150,
  anon_sym_21 = 151,
  anon_sym_COLON_COLON_EQ = 152,
  anon_sym_22 = 153,
  anon_sym_SLASH_EQ = 154,
  anon_sym_POUND = 155,
  anon_sym_23 = 156,
  anon_sym_LT = 157,
  sym_gt = 158,
  anon_sym_LT_EQ = 159,
  anon_sym_EQ_LT = 160,
  anon_sym_BSLASHleq = 161,
  anon_sym_24 = 162,
  anon_sym_GT_EQ = 163,
  anon_sym_BSLASHgeq = 164,
  anon_sym_25 = 165,
  anon_sym_BSLASHapprox = 166,
  anon_sym_26 = 167,
  anon_sym_PIPE_DASH = 168,
  anon_sym_27 = 169,
  anon_sym_PIPE_EQ = 170,
  anon_sym_28 = 171,
  anon_sym_DASH_PIPE = 172,
  anon_sym_29 = 173,
  anon_sym_EQ_PIPE = 174,
  anon_sym_30 = 175,
  anon_sym_BSLASHasymp = 176,
  anon_sym_31 = 177,
  anon_sym_BSLASHcong = 178,
  anon_sym_32 = 179,
  anon_sym_BSLASHdoteq = 180,
  anon_sym_33 = 181,
  anon_sym_BSLASHgg = 182,
  anon_sym_34 = 183,
  anon_sym_BSLASHll = 184,
  anon_sym_35 = 185,
  anon_sym_BSLASHnotin = 186,
  anon_sym_36 = 187,
  anon_sym_BSLASHprec = 188,
  anon_sym_37 = 189,
  anon_sym_BSLASHsucc = 190,
  anon_sym_38 = 191,
  anon_sym_BSLASHpreceq = 192,
  anon_sym_39 = 193,
  anon_sym_BSLASHsucceq = 194,
  anon_sym_40 = 195,
  anon_sym_BSLASHpropto = 196,
  anon_sym_41 = 197,
  anon_sym_BSLASHsim = 198,
  anon_sym_42 = 199,
  anon_sym_BSLASHsimeq = 200,
  anon_sym_43 = 201,
  anon_sym_BSLASHsqsubset = 202,
  anon_sym_44 = 203,
  anon_sym_BSLASHsqsupset = 204,
  anon_sym_45 = 205,
  anon_sym_BSLASHsqsubseteq = 206,
  anon_sym_46 = 207,
  anon_sym_BSLASHsqsupseteq = 208,
  anon_sym_47 = 209,
  anon_sym_BSLASHsubset = 210,
  anon_sym_48 = 211,
  anon_sym_BSLASHsupset = 212,
  anon_sym_49 = 213,
  anon_sym_BSLASHsubseteq = 214,
  anon_sym_50 = 215,
  anon_sym_BSLASHsupseteq = 216,
  anon_sym_51 = 217,
  sym_compose = 218,
  sym_map_to = 219,
  sym_map_from = 220,
  sym_setminus = 221,
  anon_sym_BSLASHcap = 222,
  anon_sym_BSLASHintersect = 223,
  anon_sym_52 = 224,
  anon_sym_BSLASHcup = 225,
  anon_sym_BSLASHunion = 226,
  anon_sym_53 = 227,
  anon_sym_DOT_DOT = 228,
  anon_sym_54 = 229,
  anon_sym_DOT_DOT_DOT = 230,
  anon_sym_55 = 231,
  sym_plus = 232,
  sym_plusplus = 233,
  anon_sym_BSLASHoplus = 234,
  anon_sym_LPAREN_PLUS_RPAREN = 235,
  anon_sym_56 = 236,
  anon_sym_BSLASHominus = 237,
  anon_sym_LPAREN_DASH_RPAREN = 238,
  anon_sym_57 = 239,
  sym_mod = 240,
  sym_modmod = 241,
  sym_vert = 242,
  anon_sym_PIPE_PIPE = 243,
  anon_sym_58 = 244,
  sym_minusminus = 245,
  sym_amp = 246,
  sym_ampamp = 247,
  anon_sym_BSLASHodot = 248,
  anon_sym_LPAREN_DOT_RPAREN = 249,
  anon_sym_59 = 250,
  anon_sym_BSLASHoslash = 251,
  anon_sym_LPAREN_SLASH_RPAREN = 252,
  anon_sym_60 = 253,
  anon_sym_BSLASHotimes = 254,
  anon_sym_LPAREN_BSLASHX_RPAREN = 255,
  anon_sym_61 = 256,
  sym_mul = 257,
  sym_mulmul = 258,
  sym_slash = 259,
  sym_slashslash = 260,
  anon_sym_BSLASHbigcirc = 261,
  anon_sym_62 = 262,
  anon_sym_BSLASHbullet = 263,
  anon_sym_63 = 264,
  anon_sym_BSLASHdiv = 265,
  anon_sym_64 = 266,
  anon_sym_BSLASHcirc = 267,
  anon_sym_65 = 268,
  anon_sym_BSLASHstar = 269,
  anon_sym_66 = 270,
  anon_sym_BANG_BANG = 271,
  anon_sym_67 = 272,
  anon_sym_QMARK_QMARK = 273,
  anon_sym_68 = 274,
  sym_hashhash = 275,
  sym_dol = 276,
  sym_doldol = 277,
  anon_sym_BSLASHsqcap = 278,
  anon_sym_69 = 279,
  anon_sym_BSLASHsqcup = 280,
  anon_sym_70 = 281,
  anon_sym_BSLASHuplus = 282,
  anon_sym_71 = 283,
  anon_sym_BSLASHX = 284,
  anon_sym_BSLASHtimes = 285,
  anon_sym_72 = 286,
  anon_sym_BSLASHwr = 287,
  anon_sym_73 = 288,
  anon_sym_BSLASHcdot = 289,
  anon_sym_74 = 290,
  sym_pow = 291,
  sym_powpow = 292,
  anon_sym_CARET_PLUS = 293,
  anon_sym_75 = 294,
  sym_asterisk = 295,
  sym_sup_hash = 296,
  sym_prime = 297,
  aux_sym_proof_step_id_token1 = 298,
  anon_sym_GT = 299,
  aux_sym_proof_step_id_token2 = 300,
  aux_sym_proof_step_id_token3 = 301,
  aux_sym_proof_step_ref_token1 = 302,
  aux_sym_proof_step_ref_token2 = 303,
  sym_extramodular_text = 304,
  sym__block_comment_text = 305,
  sym__indent = 306,
  sym_bullet_conj = 307,
  sym_bullet_disj = 308,
  sym__dedent = 309,
  sym__begin_proof = 310,
  sym__begin_proof_step = 311,
  sym_proof_keyword = 312,
  sym_by_keyword = 313,
  sym_obvious_keyword = 314,
  sym_omitted_keyword = 315,
  sym_qed_keyword = 316,
  sym__error_sentinel = 317,
  sym_source_file = 318,
  sym_block_comment = 319,
  sym_module = 320,
  sym_def_eq = 321,
  sym_set_in = 322,
  sym_gets = 323,
  sym_forall = 324,
  sym_exists = 325,
  sym_temporal_forall = 326,
  sym_temporal_exists = 327,
  sym_all_map_to = 328,
  sym_maps_to = 329,
  sym_langle_bracket = 330,
  sym_rangle_bracket = 331,
  sym_rangle_bracket_sub = 332,
  sym_case_box = 333,
  sym_case_arrow = 334,
  sym_colon = 335,
  sym_address = 336,
  sym_label_as = 337,
  sym_extends = 338,
  sym__unit = 339,
  sym_local_definition = 340,
  sym__definition = 341,
  sym_variable_declaration = 342,
  sym_constant_declaration = 343,
  sym_recursive_declaration = 344,
  sym_operator_declaration = 345,
  sym__id_or_op_declaration = 346,
  sym_operator_definition = 347,
  sym_function_definition = 348,
  sym_quantifier_bound = 349,
  sym_single_quantifier_bound = 350,
  sym_tuple_of_identifiers = 351,
  sym_instance = 352,
  sym_substitution = 353,
  sym__op_or_expr = 354,
  sym__op = 355,
  sym_subexpr_prefix = 356,
  sym_subexpr_component = 357,
  sym_bound_op = 358,
  sym_bound_nonfix_op = 359,
  sym_subexpr_tree_nav = 360,
  sym_child_id = 361,
  sym_operator_args = 362,
  sym_lambda = 363,
  sym_module_definition = 364,
  sym__expr = 365,
  sym__subscript_expr = 366,
  sym_prefixed_op = 367,
  sym__number = 368,
  sym_nat_number = 369,
  sym_binary_number = 370,
  sym_octal_number = 371,
  sym_hex_number = 372,
  sym_string = 373,
  sym_escape_char = 374,
  sym_boolean = 375,
  sym_primitive_value_set = 376,
  sym_label = 377,
  sym_subexpression = 378,
  sym_parentheses = 379,
  sym_bounded_quantification = 380,
  sym_unbounded_quantification = 381,
  sym_choose = 382,
  sym_finite_set_literal = 383,
  sym_set_filter = 384,
  sym_set_map = 385,
  sym_function_evaluation = 386,
  sym_function_literal = 387,
  sym_set_of_functions = 388,
  sym_record_literal = 389,
  sym_set_of_records = 390,
  sym_record_value = 391,
  sym_except = 392,
  aux_sym__except_val = 393,
  sym_prev_func_val = 394,
  sym_tuple_literal = 395,
  sym_step_expr_or_stutter = 396,
  sym_step_expr_no_stutter = 397,
  sym_fairness = 398,
  sym_if_then_else = 399,
  sym_case = 400,
  sym_case_arm = 401,
  sym_other_arm = 402,
  sym_let_in = 403,
  sym_conj_list = 404,
  sym_conj_item = 405,
  sym_disj_list = 406,
  sym_disj_item = 407,
  sym_lnot = 408,
  sym_union = 409,
  sym_powerset = 410,
  sym_domain = 411,
  sym_negative = 412,
  sym_enabled = 413,
  sym_unchanged = 414,
  sym_always = 415,
  sym_eventually = 416,
  sym_prefix_op_symbol = 417,
  sym_bound_prefix_op = 418,
  sym_implies = 419,
  sym_plus_arrow = 420,
  sym_equiv = 421,
  sym_iff = 422,
  sym_leads_to = 423,
  sym_land = 424,
  sym_lor = 425,
  sym_assign = 426,
  sym_bnf_rule = 427,
  sym_eq = 428,
  sym_neq = 429,
  sym_lt = 430,
  sym_leq = 431,
  sym_geq = 432,
  sym_approx = 433,
  sym_rs_ttile = 434,
  sym_rd_ttile = 435,
  sym_ls_ttile = 436,
  sym_ld_ttile = 437,
  sym_asymp = 438,
  sym_cong = 439,
  sym_doteq = 440,
  sym_gg = 441,
  sym_ll = 442,
  sym_in = 443,
  sym_notin = 444,
  sym_prec = 445,
  sym_succ = 446,
  sym_preceq = 447,
  sym_succeq = 448,
  sym_propto = 449,
  sym_sim = 450,
  sym_simeq = 451,
  sym_sqsubset = 452,
  sym_sqsupset = 453,
  sym_sqsubseteq = 454,
  sym_sqsupseteq = 455,
  sym_subset = 456,
  sym_supset = 457,
  sym_subseteq = 458,
  sym_supseteq = 459,
  sym_cap = 460,
  sym_cup = 461,
  sym_dots_2 = 462,
  sym_dots_3 = 463,
  sym_oplus = 464,
  sym_ominus = 465,
  sym_vertvert = 466,
  sym_minus = 467,
  sym_odot = 468,
  sym_oslash = 469,
  sym_otimes = 470,
  sym_bigcirc = 471,
  sym_bullet = 472,
  sym_div = 473,
  sym_circ = 474,
  sym_star = 475,
  sym_excl = 476,
  sym_qq = 477,
  sym_sqcap = 478,
  sym_sqcup = 479,
  sym_uplus = 480,
  sym_times = 481,
  sym_wr = 482,
  sym_cdot = 483,
  sym_infix_op_symbol = 484,
  sym_bound_infix_op = 485,
  sym_sup_plus = 486,
  sym_postfix_op_symbol = 487,
  sym_bound_postfix_op = 488,
  sym_assumption = 489,
  sym_theorem = 490,
  sym_assume_prove = 491,
  sym_inner_assume_prove = 492,
  sym_new = 493,
  sym_level = 494,
  sym__proof = 495,
  sym_terminal_proof = 496,
  sym_non_terminal_proof = 497,
  sym_proof_step = 498,
  sym_definition_proof_step = 499,
  sym_have_proof_step = 500,
  sym_witness_proof_step = 501,
  sym_take_proof_step = 502,
  sym_suffices_proof_step = 503,
  sym_case_proof_step = 504,
  sym_pick_proof_step = 505,
  sym__bound_or_identifier_list = 506,
  sym_qed_step = 507,
  sym_use_or_hide = 508,
  sym_use_body = 509,
  sym_use_body_expr = 510,
  sym_use_body_def = 511,
  sym_module_ref = 512,
  sym_proof_step_id = 513,
  sym_proof_step_ref = 514,
  aux_sym_source_file_repeat1 = 515,
  aux_sym_module_repeat1 = 516,
  aux_sym_extends_repeat1 = 517,
  aux_sym_variable_declaration_repeat1 = 518,
  aux_sym_constant_declaration_repeat1 = 519,
  aux_sym_operator_declaration_repeat1 = 520,
  aux_sym_function_definition_repeat1 = 521,
  aux_sym_instance_repeat1 = 522,
  aux_sym_subexpr_prefix_repeat1 = 523,
  aux_sym_bound_op_repeat1 = 524,
  aux_sym_string_repeat1 = 525,
  aux_sym_finite_set_literal_repeat1 = 526,
  aux_sym_record_literal_repeat1 = 527,
  aux_sym_set_of_records_repeat1 = 528,
  aux_sym_except_repeat1 = 529,
  aux_sym_case_repeat1 = 530,
  aux_sym_let_in_repeat1 = 531,
  aux_sym_conj_list_repeat1 = 532,
  aux_sym_disj_list_repeat1 = 533,
  aux_sym_assume_prove_repeat1 = 534,
  aux_sym_non_terminal_proof_repeat1 = 535,
  aux_sym_definition_proof_step_repeat1 = 536,
  aux_sym_use_body_expr_repeat1 = 537,
  aux_sym_use_body_def_repeat1 = 538,
  alias_sym_header_line = 539,
  alias_sym_identifier_ref = 540,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_MODULE] = "MODULE",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_] = "≜",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_2] = "∈",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_3] = "⟵",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_4] = "∀",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_5] = "∃",
  [anon_sym_BSLASHAA] = "\\AA",
  [anon_sym_BSLASHEE] = "\\EE",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_6] = "⟼",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_7] = "⟶",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_8] = "〈",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_9] = "〉",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym__] = "〉_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_10] = "□",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_11] = "∷",
  [sym_placeholder] = "placeholder",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_ENABLED] = "ENABLED",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CASE] = "CASE",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_SF_] = "SF_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_IF] = "IF",
  [anon_sym_SUBSET] = "SUBSET",
  [anon_sym_WITH] = "WITH",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_IN] = "IN",
  [anon_sym_THEN] = "THEN",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_DOMAIN] = "DOMAIN",
  [anon_sym_LET] = "LET",
  [anon_sym_UNCHANGED] = "UNCHANGED",
  [anon_sym_BY] = "BY",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_QED] = "QED",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_USE] = "USE",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_PICK] = "PICK",
  [anon_sym_DEFS] = "DEFS",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_NEW] = "NEW",
  [anon_sym_LAMBDA] = "LAMBDA",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_ONLY] = "ONLY",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [sym_real_number] = "real_number",
  [anon_sym_BSLASHb] = "format",
  [anon_sym_BSLASHB] = "format",
  [aux_sym_binary_number_token1] = "value",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHO] = "format",
  [aux_sym_octal_number_token1] = "value",
  [anon_sym_BSLASHh] = "format",
  [anon_sym_BSLASHH] = "format",
  [aux_sym_hex_number_token1] = "value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_char_token1] = "escape_char_token1",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [anon_sym_STRING] = "STRING",
  [anon_sym_BOOLEAN] = "BOOLEAN",
  [anon_sym_Nat] = "Nat",
  [anon_sym_Int] = "Int",
  [anon_sym_Real] = "Real",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_12] = "¬",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_13] = "⋄",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_14] = "⟹",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_15] = "⇸",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_16] = "≡",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_17] = "⟺",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_18] = "⇝",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_19] = "∧",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_20] = "∨",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_21] = "≔",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_22] = "⩴",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_23] = "≠",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_24] = "≤",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_25] = "≥",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_26] = "≈",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_27] = "⊢",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_28] = "⊨",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_29] = "⊣",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_30] = "⫤",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_31] = "≍",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_32] = "≅",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_33] = "≐",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_34] = "≫",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_35] = "≪",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_36] = "∉",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_37] = "≺",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_38] = "≻",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_39] = "⪯",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_40] = "⪰",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_41] = "∝",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_42] = "∼",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_43] = "≃",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_44] = "⊏",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_45] = "⊐",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_46] = "⊑",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_47] = "⊒",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_48] = "⊂",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_49] = "⊃",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_50] = "⊆",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_51] = "⊇",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_52] = "∩",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_53] = "∪",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_54] = "‥",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_55] = "…",
  [sym_plus] = "plus",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_56] = "⊕",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_57] = "⊖",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_58] = "‖",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_59] = "⊙",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_60] = "⊘",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_61] = "⊗",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_62] = "◯",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_63] = "●",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_64] = "÷",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_65] = "∘",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_66] = "⋆",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_67] = "‼",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_68] = "⁇",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_69] = "⊓",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_70] = "⊔",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_71] = "⊎",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_72] = "×",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_73] = "≀",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_74] = "⋅",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_75] = "⁺",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [sym_extramodular_text] = "extramodular_text",
  [sym__block_comment_text] = "_block_comment_text",
  [sym__indent] = "_indent",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym_proof_keyword] = "PROOF",
  [sym_by_keyword] = "BY",
  [sym_obvious_keyword] = "OBVIOUS",
  [sym_omitted_keyword] = "OMITTED",
  [sym_qed_keyword] = "QED",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_module] = "module",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_extends] = "extends",
  [sym__unit] = "_unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_single_quantifier_bound] = "single_quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym__op] = "_op",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym__number] = "_number",
  [sym_nat_number] = "nat_number",
  [sym_binary_number] = "binary_number",
  [sym_octal_number] = "octal_number",
  [sym_hex_number] = "hex_number",
  [sym_string] = "string",
  [sym_escape_char] = "escape_char",
  [sym_boolean] = "boolean",
  [sym_primitive_value_set] = "primitive_value_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [aux_sym__except_val] = "_except_val",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [sym_negative] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_prefix_op_symbol] = "prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_level] = "level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [alias_sym_header_line] = "header_line",
  [alias_sym_identifier_ref] = "identifier_ref",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_] = anon_sym_,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_BSLASHAA] = anon_sym_BSLASHAA,
  [anon_sym_BSLASHEE] = anon_sym_BSLASHEE,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_6] = anon_sym_6,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_7] = anon_sym_7,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_8] = anon_sym_8,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_9] = anon_sym_9,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym__] = anon_sym__,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_10] = anon_sym_10,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_11] = anon_sym_11,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_ENABLED] = anon_sym_ENABLED,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_SUBSET] = anon_sym_SUBSET,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_DOMAIN] = anon_sym_DOMAIN,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_UNCHANGED] = anon_sym_UNCHANGED,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [sym_real_number] = sym_real_number,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHB] = anon_sym_BSLASHb,
  [aux_sym_binary_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHO] = anon_sym_BSLASHb,
  [aux_sym_octal_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHh] = anon_sym_BSLASHb,
  [anon_sym_BSLASHH] = anon_sym_BSLASHb,
  [aux_sym_hex_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_char_token1] = aux_sym_escape_char_token1,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [anon_sym_STRING] = anon_sym_STRING,
  [anon_sym_BOOLEAN] = anon_sym_BOOLEAN,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_12] = anon_sym_12,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_13] = anon_sym_13,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_14] = anon_sym_14,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_15] = anon_sym_15,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_16] = anon_sym_16,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_17] = anon_sym_17,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_18] = anon_sym_18,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_19] = anon_sym_19,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_20] = anon_sym_20,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_21] = anon_sym_21,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_22] = anon_sym_22,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_23] = anon_sym_23,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_24] = anon_sym_24,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_25] = anon_sym_25,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_26] = anon_sym_26,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_27] = anon_sym_27,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_28] = anon_sym_28,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_29] = anon_sym_29,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_30] = anon_sym_30,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_31] = anon_sym_31,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_32] = anon_sym_32,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_33] = anon_sym_33,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_34] = anon_sym_34,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_35] = anon_sym_35,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_36] = anon_sym_36,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_37] = anon_sym_37,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_38] = anon_sym_38,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_39] = anon_sym_39,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_40] = anon_sym_40,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_41] = anon_sym_41,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_42] = anon_sym_42,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_43] = anon_sym_43,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_44] = anon_sym_44,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_45] = anon_sym_45,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_46] = anon_sym_46,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_47] = anon_sym_47,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_48] = anon_sym_48,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_49] = anon_sym_49,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_50] = anon_sym_50,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_51] = anon_sym_51,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_52] = anon_sym_52,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_53] = anon_sym_53,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_54] = anon_sym_54,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_55] = anon_sym_55,
  [sym_plus] = sym_plus,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_56] = anon_sym_56,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_57] = anon_sym_57,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_58] = anon_sym_58,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_59] = anon_sym_59,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_60] = anon_sym_60,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_61] = anon_sym_61,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_62] = anon_sym_62,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_63] = anon_sym_63,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_64] = anon_sym_64,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_65] = anon_sym_65,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_66] = anon_sym_66,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_67] = anon_sym_67,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_68] = anon_sym_68,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_69] = anon_sym_69,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_70] = anon_sym_70,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_71] = anon_sym_71,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_72] = anon_sym_72,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_73] = anon_sym_73,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_74] = anon_sym_74,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_75] = anon_sym_75,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [aux_sym_proof_step_id_token1] = sym_level,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = sym_level,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [sym_extramodular_text] = sym_extramodular_text,
  [sym__block_comment_text] = sym__block_comment_text,
  [sym__indent] = sym__indent,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym_proof_keyword] = anon_sym_PROOF,
  [sym_by_keyword] = anon_sym_BY,
  [sym_obvious_keyword] = anon_sym_OBVIOUS,
  [sym_omitted_keyword] = anon_sym_OMITTED,
  [sym_qed_keyword] = anon_sym_QED,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_module] = sym_module,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_extends] = sym_extends,
  [sym__unit] = sym__unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_single_quantifier_bound] = sym_single_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym__op] = sym__op,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym__number] = sym__number,
  [sym_nat_number] = sym_nat_number,
  [sym_binary_number] = sym_binary_number,
  [sym_octal_number] = sym_octal_number,
  [sym_hex_number] = sym_hex_number,
  [sym_string] = sym_string,
  [sym_escape_char] = sym_escape_char,
  [sym_boolean] = sym_boolean,
  [sym_primitive_value_set] = sym_primitive_value_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [aux_sym__except_val] = aux_sym__except_val,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [sym_negative] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_prefix_op_symbol] = sym_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_level] = sym_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [alias_sym_header_line] = alias_sym_header_line,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHEE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_11] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENABLED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOMAIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNCHANGED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_real_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHB] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_binary_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHO] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_octal_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHh] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHH] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_hex_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STRING] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BOOLEAN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_33] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_34] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_35] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_36] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_37] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_38] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_39] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_41] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_42] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_43] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_44] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_45] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_46] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_47] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_49] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_50] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_51] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_52] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_53] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_54] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_55] = {
    .visible = true,
    .named = false,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_57] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_58] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_59] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_60] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_61] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_62] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_63] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_65] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_66] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_67] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_68] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_69] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_70] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_71] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_73] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_74] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_75] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__block_comment_text] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym_proof_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_by_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_obvious_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_omitted_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_qed_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym__unit] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__op] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_number] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_value_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__except_val] = {
    .visible = false,
    .named = false,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_header_line] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expression = 7,
  field_filter = 8,
  field_generator = 9,
  field_identifier = 10,
  field_if = 11,
  field_lhs = 12,
  field_map = 13,
  field_name = 14,
  field_op = 15,
  field_parameter = 16,
  field_prefix = 17,
  field_quantifier = 18,
  field_rhs = 19,
  field_set = 20,
  field_symbol = 21,
  field_then = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_identifier] = "identifier",
  [field_if] = "if",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_symbol] = "symbol",
  [field_then] = "then",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 2},
  [6] = {.index = 1, .length = 2},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 3},
  [13] = {.index = 14, .length = 3},
  [14] = {.index = 17, .length = 3},
  [15] = {.index = 20, .length = 2},
  [16] = {.index = 8, .length = 1},
  [17] = {.index = 22, .length = 1},
  [18] = {.index = 23, .length = 3},
  [19] = {.index = 26, .length = 3},
  [20] = {.index = 29, .length = 2},
  [21] = {.index = 31, .length = 4},
  [22] = {.index = 35, .length = 1},
  [23] = {.index = 36, .length = 2},
  [24] = {.index = 38, .length = 2},
  [25] = {.index = 40, .length = 4},
  [26] = {.index = 44, .length = 4},
  [27] = {.index = 48, .length = 3},
  [28] = {.index = 51, .length = 5},
  [29] = {.index = 56, .length = 2},
  [30] = {.index = 58, .length = 3},
  [31] = {.index = 61, .length = 4},
  [32] = {.index = 65, .length = 3},
  [33] = {.index = 68, .length = 6},
  [34] = {.index = 74, .length = 2},
  [35] = {.index = 76, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 2},
  [1] =
    {field_op, 1},
    {field_prefix, 0},
  [3] =
    {field_lhs, 0},
    {field_symbol, 1},
  [5] =
    {field_rhs, 1},
    {field_symbol, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_name, 0},
  [9] =
    {field_definition, 2},
    {field_name, 0},
  [11] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [14] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [17] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [20] =
    {field_definitions, 1},
    {field_expression, 3},
  [22] =
    {field_set, 2},
  [23] =
    {field_expression, 3},
    {field_identifier, 1},
    {field_quantifier, 0},
  [26] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [29] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [31] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [35] =
    {field_set, 3},
  [36] =
    {field_filter, 3},
    {field_generator, 1},
  [38] =
    {field_generator, 3},
    {field_map, 1},
  [40] =
    {field_expression, 4},
    {field_identifier, 1},
    {field_identifier, 2},
    {field_quantifier, 0},
  [44] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [48] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [51] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [56] =
    {field_definition, 5},
    {field_name, 0},
  [58] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [61] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [65] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [68] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [74] =
    {field_definition, 6},
    {field_name, 0},
  [76] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_header_line,
    [3] = alias_sym_header_line,
  },
  [2] = {
    [0] = alias_sym_identifier_ref,
  },
  [3] = {
    [1] = alias_sym_identifier_ref,
  },
  [4] = {
    [0] = anon_sym_BSLASHb,
  },
  [5] = {
    [1] = alias_sym_identifier_ref,
  },
  [16] = {
    [0] = alias_sym_identifier_ref,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(218);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(217)
      if (lookahead == '\r') SKIP(217)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(310);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(254);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(300);
      if (lookahead == '>') ADVANCE(346);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(411);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(437);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8704) ADVANCE(233);
      if (lookahead == 8707) ADVANCE(236);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10229) ADVANCE(230);
      if (lookahead == 10230) ADVANCE(242);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (lookahead == 12297) ADVANCE(248);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(277);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(496);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(281);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(208)
      if (lookahead == '\r') ADVANCE(288);
      if (lookahead == '"') ADVANCE(290);
      if (lookahead == '(') ADVANCE(289);
      if (lookahead == '\\') ADVANCE(291);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(288);
      if (lookahead != 0) ADVANCE(288);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(208)
      if (lookahead == '\r') ADVANCE(292);
      if (lookahead == '(') ADVANCE(293);
      if (lookahead == '\\') ADVANCE(294);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(292);
      if (lookahead != 0) ADVANCE(292);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(468);
      END_STATE();
    case 4:
      if (lookahead == ')') ADVANCE(430);
      END_STATE();
    case 5:
      if (lookahead == ')') ADVANCE(433);
      END_STATE();
    case 6:
      if (lookahead == ')') ADVANCE(446);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(449);
      END_STATE();
    case 8:
      if (lookahead == ')') ADVANCE(452);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(220);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(220);
      if (lookahead == '+') ADVANCE(4);
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == '.') ADVANCE(6);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '\\') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(219);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == 'i') ADVANCE(105);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == 'l') ADVANCE(108);
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 14:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(221);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(229);
      if (lookahead == '>') ADVANCE(316);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(15);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == '.') ADVANCE(315);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(315);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(423);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(274);
      END_STATE();
    case 23:
      if (lookahead == ':') ADVANCE(258);
      if (lookahead == '=') ADVANCE(334);
      if (lookahead == '>') ADVANCE(409);
      END_STATE();
    case 24:
      if (lookahead == ':') ADVANCE(257);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '=') ADVANCE(334);
      if (lookahead == '>') ADVANCE(409);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(336);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(222);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(223);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(27);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(316);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(326);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(239);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(320);
      END_STATE();
    case 35:
      if (lookahead == '>') ADVANCE(245);
      END_STATE();
    case 36:
      if (lookahead == '?') ADVANCE(470);
      END_STATE();
    case 37:
      if (lookahead == '@') ADVANCE(408);
      END_STATE();
    case 38:
      if (lookahead == 'X') ADVANCE(8);
      END_STATE();
    case 39:
      if (lookahead == ']') ADVANCE(251);
      END_STATE();
    case 40:
      if (lookahead == '_') ADVANCE(304);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'd') ADVANCE(113);
      if (lookahead == 'i') ADVANCE(143);
      if (lookahead == 'o') ADVANCE(106);
      if (lookahead == 'u') ADVANCE(120);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == 'l') ADVANCE(374);
      if (lookahead == 'n') ADVANCE(115);
      if (lookahead == 'o') ADVANCE(139);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'e') ADVANCE(129);
      if (lookahead == 'l') ADVANCE(374);
      if (lookahead == 'o') ADVANCE(139);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(122);
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(157);
      if (lookahead == 'c') ADVANCE(53);
      if (lookahead == 'p') ADVANCE(158);
      END_STATE();
    case 49:
      if (lookahead == 'b') ADVANCE(159);
      if (lookahead == 'p') ADVANCE(160);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(45);
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(464);
      END_STATE();
    case 52:
      if (lookahead == 'c') ADVANCE(378);
      END_STATE();
    case 53:
      if (lookahead == 'c') ADVANCE(380);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(458);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(53);
      END_STATE();
    case 56:
      if (lookahead == 'c') ADVANCE(88);
      END_STATE();
    case 57:
      if (lookahead == 'c') ADVANCE(170);
      END_STATE();
    case 58:
      if (lookahead == 'd') ADVANCE(329);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(128);
      if (lookahead == 'g') ADVANCE(372);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(75);
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 74:
      if (lookahead == 'g') ADVANCE(56);
      END_STATE();
    case 75:
      if (lookahead == 'g') ADVANCE(306);
      END_STATE();
    case 76:
      if (lookahead == 'g') ADVANCE(368);
      END_STATE();
    case 77:
      if (lookahead == 'h') ADVANCE(448);
      END_STATE();
    case 78:
      if (lookahead == 'i') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 79:
      if (lookahead == 'i') ADVANCE(179);
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 80:
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == 'q') ADVANCE(50);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == 'q') ADVANCE(50);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 82:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 84:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 85:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 86:
      if (lookahead == 'i') ADVANCE(109);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 88:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(232);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 92:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 96:
      if (lookahead == 'l') ADVANCE(177);
      END_STATE();
    case 97:
      if (lookahead == 'm') ADVANCE(388);
      END_STATE();
    case 98:
      if (lookahead == 'm') ADVANCE(65);
      END_STATE();
    case 99:
      if (lookahead == 'm') ADVANCE(121);
      END_STATE();
    case 100:
      if (lookahead == 'm') ADVANCE(70);
      END_STATE();
    case 101:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 102:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 103:
      if (lookahead == 'n') ADVANCE(376);
      END_STATE();
    case 104:
      if (lookahead == 'n') ADVANCE(421);
      END_STATE();
    case 105:
      if (lookahead == 'n') ADVANCE(226);
      END_STATE();
    case 106:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 108:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 109:
      if (lookahead == 'n') ADVANCE(178);
      END_STATE();
    case 110:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 111:
      if (lookahead == 'o') ADVANCE(386);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(173);
      END_STATE();
    case 113:
      if (lookahead == 'o') ADVANCE(162);
      END_STATE();
    case 114:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 115:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 117:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 118:
      if (lookahead == 'p') ADVANCE(124);
      if (lookahead == 's') ADVANCE(182);
      END_STATE();
    case 119:
      if (lookahead == 'p') ADVANCE(417);
      END_STATE();
    case 120:
      if (lookahead == 'p') ADVANCE(420);
      END_STATE();
    case 121:
      if (lookahead == 'p') ADVANCE(366);
      END_STATE();
    case 122:
      if (lookahead == 'p') ADVANCE(475);
      END_STATE();
    case 123:
      if (lookahead == 'p') ADVANCE(477);
      END_STATE();
    case 124:
      if (lookahead == 'p') ADVANCE(144);
      END_STATE();
    case 125:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 126:
      if (lookahead == 'q') ADVANCE(176);
      END_STATE();
    case 127:
      if (lookahead == 'q') ADVANCE(176);
      if (lookahead == 'x') ADVANCE(82);
      END_STATE();
    case 128:
      if (lookahead == 'q') ADVANCE(353);
      END_STATE();
    case 129:
      if (lookahead == 'q') ADVANCE(350);
      END_STATE();
    case 130:
      if (lookahead == 'q') ADVANCE(370);
      END_STATE();
    case 131:
      if (lookahead == 'q') ADVANCE(390);
      END_STATE();
    case 132:
      if (lookahead == 'q') ADVANCE(382);
      END_STATE();
    case 133:
      if (lookahead == 'q') ADVANCE(384);
      END_STATE();
    case 134:
      if (lookahead == 'q') ADVANCE(404);
      END_STATE();
    case 135:
      if (lookahead == 'q') ADVANCE(406);
      END_STATE();
    case 136:
      if (lookahead == 'q') ADVANCE(396);
      END_STATE();
    case 137:
      if (lookahead == 'q') ADVANCE(398);
      END_STATE();
    case 138:
      if (lookahead == 'r') ADVANCE(484);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(332);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(466);
      END_STATE();
    case 141:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 142:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 144:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 145:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 146:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(155);
      END_STATE();
    case 148:
      if (lookahead == 's') ADVANCE(429);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 150:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 151:
      if (lookahead == 's') ADVANCE(479);
      END_STATE();
    case 152:
      if (lookahead == 's') ADVANCE(235);
      END_STATE();
    case 153:
      if (lookahead == 's') ADVANCE(432);
      END_STATE();
    case 154:
      if (lookahead == 's') ADVANCE(451);
      END_STATE();
    case 155:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 157:
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 158:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(486);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 164:
      if (lookahead == 't') ADVANCE(445);
      END_STATE();
    case 165:
      if (lookahead == 't') ADVANCE(460);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(400);
      END_STATE();
    case 167:
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 168:
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(418);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 174:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 175:
      if (lookahead == 'u') ADVANCE(148);
      END_STATE();
    case 176:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 177:
      if (lookahead == 'u') ADVANCE(151);
      END_STATE();
    case 178:
      if (lookahead == 'u') ADVANCE(153);
      END_STATE();
    case 179:
      if (lookahead == 'v') ADVANCE(462);
      END_STATE();
    case 180:
      if (lookahead == 'v') ADVANCE(322);
      END_STATE();
    case 181:
      if (lookahead == 'x') ADVANCE(355);
      END_STATE();
    case 182:
      if (lookahead == 'y') ADVANCE(99);
      END_STATE();
    case 183:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(183)
      if (lookahead == '\r') SKIP(183)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8704) ADVANCE(233);
      if (lookahead == 8707) ADVANCE(236);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 184:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(184)
      if (lookahead == '\r') SKIP(184)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(311);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(302);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8704) ADVANCE(233);
      if (lookahead == 8707) ADVANCE(236);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 185:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(185)
      if (lookahead == '\r') SKIP(185)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(347);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8704) ADVANCE(233);
      if (lookahead == 8707) ADVANCE(236);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (lookahead == 12297) ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 186:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(186)
      if (lookahead == '\r') SKIP(186)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(311);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(344);
      if (lookahead == '=') ADVANCE(302);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(413);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 187:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(187)
      if (lookahead == '\r') SKIP(187)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(415);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 188:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(188)
      if (lookahead == '\r') SKIP(188)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(255);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(347);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(415);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (lookahead == 12297) ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 189:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(189)
      if (lookahead == '\r') SKIP(189)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(313);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == ']') ADVANCE(40);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10230) ADVANCE(242);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 190:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(190)
      if (lookahead == '\r') SKIP(190)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(255);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 191:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(191)
      if (lookahead == '\r') SKIP(191)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(260);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      END_STATE();
    case 192:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(191)
      if (lookahead == '\r') SKIP(191)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(260);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(278);
      END_STATE();
    case 193:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(193)
      if (lookahead == '\r') SKIP(193)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(346);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12297) ADVANCE(248);
      END_STATE();
    case 194:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(193)
      if (lookahead == '\r') SKIP(193)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(346);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12297) ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(286);
      END_STATE();
    case 195:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(195)
      if (lookahead == '\r') SKIP(195)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(10);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(344);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(415);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 196:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(196)
      if (lookahead == '\r') SKIP(196)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(437);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      END_STATE();
    case 197:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(196)
      if (lookahead == '\r') SKIP(196)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(437);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(283);
      END_STATE();
    case 198:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(198)
      if (lookahead == '\r') SKIP(198)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(416);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      END_STATE();
    case 199:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(199)
      if (lookahead == '\r') SKIP(199)
      if (lookahead == '!') ADVANCE(3);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(10);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(21);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(416);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      END_STATE();
    case 200:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(200)
      if (lookahead == '\r') SKIP(200)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == '-') ADVANCE(311);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(344);
      if (lookahead == '=') ADVANCE(300);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(413);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 201:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(201)
      if (lookahead == '\r') SKIP(201)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(313);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(254);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == ']') ADVANCE(40);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(437);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10230) ADVANCE(242);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 202:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(202)
      if (lookahead == '\r') SKIP(202)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(254);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 203:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(204)
      if (lookahead == '\r') SKIP(204)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(253);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 10229) ADVANCE(230);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 12297) ADVANCE(247);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(282);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 204:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(204)
      if (lookahead == '\r') SKIP(204)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(253);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 10229) ADVANCE(230);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 12297) ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 205:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(206)
      if (lookahead == '\r') SKIP(206)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(501);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(498);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 9633) ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 206:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(206)
      if (lookahead == '\r') SKIP(206)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 9633) ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 207:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(207)
      if (lookahead == '\r') SKIP(207)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == '[') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(307);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 10229) ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 208:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(208)
      if (lookahead == '\r') SKIP(208)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '\\') ADVANCE(11);
      END_STATE();
    case 209:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(208)
      if (lookahead == '\r') SKIP(208)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '\\') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(503);
      END_STATE();
    case 210:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(208)
      if (lookahead == '\r') SKIP(208)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(495);
      if (lookahead == '\\') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(497);
      END_STATE();
    case 211:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(211)
      if (lookahead == '\r') SKIP(211)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '.') ADVANCE(297);
      if (lookahead == '<') ADVANCE(341);
      if (lookahead == '=') ADVANCE(299);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '_') ADVANCE(260);
      END_STATE();
    case 212:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(211)
      if (lookahead == '\r') SKIP(211)
      if (lookahead == '!') ADVANCE(270);
      if (lookahead == '(') ADVANCE(264);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '.') ADVANCE(297);
      if (lookahead == '<') ADVANCE(341);
      if (lookahead == '=') ADVANCE(299);
      if (lookahead == '[') ADVANCE(267);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '_') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(283);
      END_STATE();
    case 213:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(213)
      if (lookahead == '\r') SKIP(213)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(312);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(344);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(345);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(413);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 214:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(214)
      if (lookahead == '\r') SKIP(214)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(314);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(343);
      if (lookahead == '=') ADVANCE(303);
      if (lookahead == '>') ADVANCE(347);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '|') ADVANCE(438);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12297) ADVANCE(247);
      END_STATE();
    case 215:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(274);
      END_STATE();
    case 216:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 217:
      if (eof) ADVANCE(218);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(217)
      if (lookahead == '\r') SKIP(217)
      if (lookahead == '!') ADVANCE(271);
      if (lookahead == '"') ADVANCE(287);
      if (lookahead == '#') ADVANCE(339);
      if (lookahead == '$') ADVANCE(473);
      if (lookahead == '%') ADVANCE(435);
      if (lookahead == '&') ADVANCE(443);
      if (lookahead == '\'') ADVANCE(494);
      if (lookahead == '(') ADVANCE(265);
      if (lookahead == ')') ADVANCE(266);
      if (lookahead == '*') ADVANCE(454);
      if (lookahead == '+') ADVANCE(427);
      if (lookahead == ',') ADVANCE(263);
      if (lookahead == '-') ADVANCE(310);
      if (lookahead == '.') ADVANCE(298);
      if (lookahead == '/') ADVANCE(456);
      if (lookahead == ':') ADVANCE(254);
      if (lookahead == '<') ADVANCE(342);
      if (lookahead == '=') ADVANCE(300);
      if (lookahead == '>') ADVANCE(346);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(256);
      if (lookahead == '[') ADVANCE(268);
      if (lookahead == '\\') ADVANCE(411);
      if (lookahead == ']') ADVANCE(269);
      if (lookahead == '^') ADVANCE(488);
      if (lookahead == '_') ADVANCE(261);
      if (lookahead == '{') ADVANCE(295);
      if (lookahead == '|') ADVANCE(437);
      if (lookahead == '}') ADVANCE(296);
      if (lookahead == '~') ADVANCE(308);
      if (lookahead == 172) ADVANCE(309);
      if (lookahead == 215) ADVANCE(483);
      if (lookahead == 247) ADVANCE(463);
      if (lookahead == 8214) ADVANCE(440);
      if (lookahead == 8229) ADVANCE(424);
      if (lookahead == 8230) ADVANCE(426);
      if (lookahead == 8252) ADVANCE(469);
      if (lookahead == 8263) ADVANCE(471);
      if (lookahead == 8314) ADVANCE(491);
      if (lookahead == 8669) ADVANCE(327);
      if (lookahead == 8696) ADVANCE(321);
      if (lookahead == 8704) ADVANCE(233);
      if (lookahead == 8707) ADVANCE(236);
      if (lookahead == 8712) ADVANCE(228);
      if (lookahead == 8713) ADVANCE(377);
      if (lookahead == 8728) ADVANCE(465);
      if (lookahead == 8733) ADVANCE(387);
      if (lookahead == 8743) ADVANCE(330);
      if (lookahead == 8744) ADVANCE(333);
      if (lookahead == 8745) ADVANCE(419);
      if (lookahead == 8746) ADVANCE(422);
      if (lookahead == 8759) ADVANCE(259);
      if (lookahead == 8764) ADVANCE(389);
      if (lookahead == 8768) ADVANCE(485);
      if (lookahead == 8771) ADVANCE(391);
      if (lookahead == 8773) ADVANCE(369);
      if (lookahead == 8776) ADVANCE(356);
      if (lookahead == 8781) ADVANCE(367);
      if (lookahead == 8784) ADVANCE(371);
      if (lookahead == 8788) ADVANCE(335);
      if (lookahead == 8796) ADVANCE(225);
      if (lookahead == 8800) ADVANCE(340);
      if (lookahead == 8801) ADVANCE(323);
      if (lookahead == 8804) ADVANCE(351);
      if (lookahead == 8805) ADVANCE(354);
      if (lookahead == 8810) ADVANCE(375);
      if (lookahead == 8811) ADVANCE(373);
      if (lookahead == 8826) ADVANCE(379);
      if (lookahead == 8827) ADVANCE(381);
      if (lookahead == 8834) ADVANCE(401);
      if (lookahead == 8835) ADVANCE(403);
      if (lookahead == 8838) ADVANCE(405);
      if (lookahead == 8839) ADVANCE(407);
      if (lookahead == 8846) ADVANCE(480);
      if (lookahead == 8847) ADVANCE(393);
      if (lookahead == 8848) ADVANCE(395);
      if (lookahead == 8849) ADVANCE(397);
      if (lookahead == 8850) ADVANCE(399);
      if (lookahead == 8851) ADVANCE(476);
      if (lookahead == 8852) ADVANCE(478);
      if (lookahead == 8853) ADVANCE(431);
      if (lookahead == 8854) ADVANCE(434);
      if (lookahead == 8855) ADVANCE(453);
      if (lookahead == 8856) ADVANCE(450);
      if (lookahead == 8857) ADVANCE(447);
      if (lookahead == 8866) ADVANCE(359);
      if (lookahead == 8867) ADVANCE(363);
      if (lookahead == 8872) ADVANCE(361);
      if (lookahead == 8900) ADVANCE(317);
      if (lookahead == 8901) ADVANCE(487);
      if (lookahead == 8902) ADVANCE(467);
      if (lookahead == 9633) ADVANCE(252);
      if (lookahead == 9679) ADVANCE(461);
      if (lookahead == 9711) ADVANCE(459);
      if (lookahead == 10229) ADVANCE(230);
      if (lookahead == 10230) ADVANCE(242);
      if (lookahead == 10233) ADVANCE(319);
      if (lookahead == 10234) ADVANCE(325);
      if (lookahead == 10236) ADVANCE(240);
      if (lookahead == 10868) ADVANCE(337);
      if (lookahead == 10927) ADVANCE(383);
      if (lookahead == 10928) ADVANCE(385);
      if (lookahead == 10980) ADVANCE(365);
      if (lookahead == 12296) ADVANCE(244);
      if (lookahead == 12297) ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_single_line);
      if (lookahead == '-') ADVANCE(221);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_double_line);
      if (lookahead == '=') ADVANCE(222);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(237);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(238);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_BSLASHAA);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_BSLASHEE);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_8);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(249);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_9);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_9);
      if (lookahead == '_') ADVANCE(250);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_10);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(258);
      if (lookahead == '=') ADVANCE(334);
      if (lookahead == '>') ADVANCE(409);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '=') ADVANCE(334);
      if (lookahead == '>') ADVANCE(409);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(408);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(336);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_11);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(216);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(262);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(220);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(220);
      if (lookahead == '+') ADVANCE(4);
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == '.') ADVANCE(6);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '\\') ADVANCE(38);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(251);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '!') ADVANCE(468);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(215);
      if (lookahead == '_') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      if (lookahead == 'i') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_BSLASHB);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(277);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(496);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(281);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(278);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(116);
      if (lookahead == 'm') ADVANCE(86);
      if (lookahead == 'p') ADVANCE(91);
      if (lookahead == 's') ADVANCE(92);
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_BSLASHO);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(281);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '8' ||
          lookahead == '9' ||
          lookahead == '_') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(282);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(283);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_BSLASHh);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_BSLASHH);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym_hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(286);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(220);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '*') ADVANCE(219);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(220);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym_escape_char_token1);
      if (lookahead == '*') ADVANCE(219);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(423);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(349);
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(318);
      if (lookahead == '|') ADVANCE(364);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(349);
      if (lookahead == '=') ADVANCE(223);
      if (lookahead == '>') ADVANCE(318);
      if (lookahead == '|') ADVANCE(364);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(349);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(318);
      if (lookahead == '|') ADVANCE(364);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(349);
      if (lookahead == '>') ADVANCE(318);
      if (lookahead == '|') ADVANCE(364);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(326);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_12);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(442);
      if (lookahead == '.') ADVANCE(315);
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(362);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(442);
      if (lookahead == '.') ADVANCE(315);
      if (lookahead == '|') ADVANCE(362);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(441);
      if (lookahead == '.') ADVANCE(315);
      if (lookahead == '|') ADVANCE(362);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(441);
      if (lookahead == '>') ADVANCE(241);
      if (lookahead == '|') ADVANCE(362);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(441);
      if (lookahead == '|') ADVANCE(362);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_13);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_14);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_15);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_16);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_17);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_18);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_19);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_20);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_21);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_22);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(472);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_23);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(410);
      if (lookahead == '<') ADVANCE(243);
      if (lookahead == '=') ADVANCE(348);
      if (lookahead == '>') ADVANCE(316);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(410);
      if (lookahead == '=') ADVANCE(348);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(410);
      if (lookahead == '=') ADVANCE(348);
      if (lookahead == '>') ADVANCE(316);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(352);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(352);
      if (lookahead == '>') ADVANCE(246);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(352);
      if (lookahead == '>') ADVANCE(245);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(324);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_24);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_25);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_26);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(239);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_27);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_28);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_29);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_30);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_31);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_32);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_33);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_34);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_35);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_36);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_37);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_38);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_39);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_40);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_41);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_42);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_43);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_44);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_45);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_46);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_47);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_48);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_49);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_50);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_51);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'A') ADVANCE(231);
      if (lookahead == 'B') ADVANCE(276);
      if (lookahead == 'E') ADVANCE(234);
      if (lookahead == 'H') ADVANCE(285);
      if (lookahead == 'O') ADVANCE(280);
      if (lookahead == 'X') ADVANCE(481);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(275);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(114);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'h') ADVANCE(284);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(141);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 't') ADVANCE(84);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'A') ADVANCE(231);
      if (lookahead == 'B') ADVANCE(276);
      if (lookahead == 'E') ADVANCE(234);
      if (lookahead == 'H') ADVANCE(285);
      if (lookahead == 'O') ADVANCE(280);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(275);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(114);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'h') ADVANCE(284);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(146);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'X') ADVANCE(481);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(78);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(141);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 't') ADVANCE(84);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'X') ADVANCE(481);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(78);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(112);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(141);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == 't') ADVANCE(84);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(78);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(42);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(146);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == 'a') ADVANCE(118);
      if (lookahead == 'b') ADVANCE(78);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'd') ADVANCE(79);
      if (lookahead == 'e') ADVANCE(126);
      if (lookahead == 'g') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'l') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(112);
      if (lookahead == 'o') ADVANCE(279);
      if (lookahead == 'p') ADVANCE(146);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'w') ADVANCE(138);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_52);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_53);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(425);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_54);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_55);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(428);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_56);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_57);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(436);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(358);
      if (lookahead == '=') ADVANCE(360);
      if (lookahead == '|') ADVANCE(439);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(357);
      if (lookahead == '=') ADVANCE(360);
      if (lookahead == '|') ADVANCE(439);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_58);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(15);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(444);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_59);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_60);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_61);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(455);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(457);
      if (lookahead == '=') ADVANCE(338);
      if (lookahead == '\\') ADVANCE(328);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_62);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_63);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_64);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_65);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_66);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_67);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_68);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(474);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_69);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_70);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_71);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_72);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_73);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_74);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(493);
      if (lookahead == '*') ADVANCE(492);
      if (lookahead == '+') ADVANCE(490);
      if (lookahead == '^') ADVANCE(489);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_75);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (lookahead == '_') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(496);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(497);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(499);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(500);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(502);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(262);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(503);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'C') ADVANCE(3);
      if (lookahead == 'D') ADVANCE(4);
      if (lookahead == 'E') ADVANCE(5);
      if (lookahead == 'F') ADVANCE(6);
      if (lookahead == 'H') ADVANCE(7);
      if (lookahead == 'I') ADVANCE(8);
      if (lookahead == 'L') ADVANCE(9);
      if (lookahead == 'M') ADVANCE(10);
      if (lookahead == 'N') ADVANCE(11);
      if (lookahead == 'O') ADVANCE(12);
      if (lookahead == 'P') ADVANCE(13);
      if (lookahead == 'Q') ADVANCE(14);
      if (lookahead == 'R') ADVANCE(15);
      if (lookahead == 'S') ADVANCE(16);
      if (lookahead == 'T') ADVANCE(17);
      if (lookahead == 'U') ADVANCE(18);
      if (lookahead == 'V') ADVANCE(19);
      if (lookahead == 'W') ADVANCE(20);
      END_STATE();
    case 1:
      if (lookahead == 'C') ADVANCE(21);
      if (lookahead == 'S') ADVANCE(22);
      if (lookahead == 'X') ADVANCE(23);
      END_STATE();
    case 2:
      if (lookahead == 'O') ADVANCE(24);
      if (lookahead == 'Y') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == 'A') ADVANCE(26);
      if (lookahead == 'H') ADVANCE(27);
      if (lookahead == 'O') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'E') ADVANCE(29);
      if (lookahead == 'O') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'L') ADVANCE(31);
      if (lookahead == 'N') ADVANCE(32);
      if (lookahead == 'X') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'A') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'A') ADVANCE(35);
      if (lookahead == 'I') ADVANCE(36);
      END_STATE();
    case 8:
      if (lookahead == 'F') ADVANCE(37);
      if (lookahead == 'N') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 9:
      if (lookahead == 'A') ADVANCE(40);
      if (lookahead == 'E') ADVANCE(41);
      if (lookahead == 'O') ADVANCE(42);
      END_STATE();
    case 10:
      if (lookahead == 'O') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'E') ADVANCE(44);
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'B') ADVANCE(46);
      if (lookahead == 'M') ADVANCE(47);
      if (lookahead == 'N') ADVANCE(48);
      if (lookahead == 'T') ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == 'I') ADVANCE(50);
      if (lookahead == 'R') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'E') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(53);
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 16:
      if (lookahead == 'F') ADVANCE(55);
      if (lookahead == 'T') ADVANCE(56);
      if (lookahead == 'U') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(58);
      if (lookahead == 'E') ADVANCE(59);
      if (lookahead == 'H') ADVANCE(60);
      if (lookahead == 'R') ADVANCE(61);
      END_STATE();
    case 18:
      if (lookahead == 'N') ADVANCE(62);
      if (lookahead == 'S') ADVANCE(63);
      END_STATE();
    case 19:
      if (lookahead == 'A') ADVANCE(64);
      END_STATE();
    case 20:
      if (lookahead == 'F') ADVANCE(65);
      if (lookahead == 'I') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 'T') ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == 'S') ADVANCE(68);
      END_STATE();
    case 23:
      if (lookahead == 'I') ADVANCE(69);
      END_STATE();
    case 24:
      if (lookahead == 'O') ADVANCE(70);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 26:
      if (lookahead == 'S') ADVANCE(71);
      END_STATE();
    case 27:
      if (lookahead == 'O') ADVANCE(72);
      END_STATE();
    case 28:
      if (lookahead == 'N') ADVANCE(73);
      if (lookahead == 'R') ADVANCE(74);
      END_STATE();
    case 29:
      if (lookahead == 'F') ADVANCE(75);
      END_STATE();
    case 30:
      if (lookahead == 'M') ADVANCE(76);
      END_STATE();
    case 31:
      if (lookahead == 'S') ADVANCE(77);
      END_STATE();
    case 32:
      if (lookahead == 'A') ADVANCE(78);
      END_STATE();
    case 33:
      if (lookahead == 'C') ADVANCE(79);
      if (lookahead == 'T') ADVANCE(80);
      END_STATE();
    case 34:
      if (lookahead == 'L') ADVANCE(81);
      END_STATE();
    case 35:
      if (lookahead == 'V') ADVANCE(82);
      END_STATE();
    case 36:
      if (lookahead == 'D') ADVANCE(83);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_IN);
      if (lookahead == 'S') ADVANCE(84);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 40:
      if (lookahead == 'M') ADVANCE(86);
      END_STATE();
    case 41:
      if (lookahead == 'M') ADVANCE(87);
      if (lookahead == 'T') ADVANCE(88);
      END_STATE();
    case 42:
      if (lookahead == 'C') ADVANCE(89);
      END_STATE();
    case 43:
      if (lookahead == 'D') ADVANCE(90);
      END_STATE();
    case 44:
      if (lookahead == 'W') ADVANCE(91);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 46:
      if (lookahead == 'V') ADVANCE(93);
      END_STATE();
    case 47:
      if (lookahead == 'I') ADVANCE(94);
      END_STATE();
    case 48:
      if (lookahead == 'L') ADVANCE(95);
      END_STATE();
    case 49:
      if (lookahead == 'H') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'C') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'O') ADVANCE(98);
      END_STATE();
    case 52:
      if (lookahead == 'D') ADVANCE(99);
      END_STATE();
    case 53:
      if (lookahead == 'C') ADVANCE(100);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 55:
      if (lookahead == '_') ADVANCE(102);
      END_STATE();
    case 56:
      if (lookahead == 'A') ADVANCE(103);
      if (lookahead == 'R') ADVANCE(104);
      END_STATE();
    case 57:
      if (lookahead == 'B') ADVANCE(105);
      if (lookahead == 'F') ADVANCE(106);
      END_STATE();
    case 58:
      if (lookahead == 'K') ADVANCE(107);
      END_STATE();
    case 59:
      if (lookahead == 'M') ADVANCE(108);
      END_STATE();
    case 60:
      if (lookahead == 'E') ADVANCE(109);
      END_STATE();
    case 61:
      if (lookahead == 'U') ADVANCE(110);
      END_STATE();
    case 62:
      if (lookahead == 'C') ADVANCE(111);
      if (lookahead == 'I') ADVANCE(112);
      END_STATE();
    case 63:
      if (lookahead == 'E') ADVANCE(113);
      END_STATE();
    case 64:
      if (lookahead == 'R') ADVANCE(114);
      END_STATE();
    case 65:
      if (lookahead == '_') ADVANCE(115);
      END_STATE();
    case 66:
      if (lookahead == 'T') ADVANCE(116);
      END_STATE();
    case 67:
      if (lookahead == 'I') ADVANCE(117);
      END_STATE();
    case 68:
      if (lookahead == 'U') ADVANCE(118);
      END_STATE();
    case 69:
      if (lookahead == 'O') ADVANCE(119);
      END_STATE();
    case 70:
      if (lookahead == 'L') ADVANCE(120);
      END_STATE();
    case 71:
      if (lookahead == 'E') ADVANCE(121);
      END_STATE();
    case 72:
      if (lookahead == 'O') ADVANCE(122);
      END_STATE();
    case 73:
      if (lookahead == 'S') ADVANCE(123);
      END_STATE();
    case 74:
      if (lookahead == 'O') ADVANCE(124);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'I') ADVANCE(125);
      if (lookahead == 'S') ADVANCE(126);
      END_STATE();
    case 76:
      if (lookahead == 'A') ADVANCE(127);
      END_STATE();
    case 77:
      if (lookahead == 'E') ADVANCE(128);
      END_STATE();
    case 78:
      if (lookahead == 'B') ADVANCE(129);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(130);
      END_STATE();
    case 80:
      if (lookahead == 'E') ADVANCE(131);
      END_STATE();
    case 81:
      if (lookahead == 'S') ADVANCE(132);
      END_STATE();
    case 82:
      if (lookahead == 'E') ADVANCE(133);
      END_STATE();
    case 83:
      if (lookahead == 'E') ADVANCE(134);
      END_STATE();
    case 84:
      if (lookahead == 'T') ADVANCE(135);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 86:
      if (lookahead == 'B') ADVANCE(136);
      END_STATE();
    case 87:
      if (lookahead == 'M') ADVANCE(137);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 89:
      if (lookahead == 'A') ADVANCE(138);
      END_STATE();
    case 90:
      if (lookahead == 'U') ADVANCE(139);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 93:
      if (lookahead == 'I') ADVANCE(140);
      END_STATE();
    case 94:
      if (lookahead == 'T') ADVANCE(141);
      END_STATE();
    case 95:
      if (lookahead == 'Y') ADVANCE(142);
      END_STATE();
    case 96:
      if (lookahead == 'E') ADVANCE(143);
      END_STATE();
    case 97:
      if (lookahead == 'K') ADVANCE(144);
      END_STATE();
    case 98:
      if (lookahead == 'O') ADVANCE(145);
      if (lookahead == 'P') ADVANCE(146);
      if (lookahead == 'V') ADVANCE(147);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 100:
      if (lookahead == 'U') ADVANCE(148);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 103:
      if (lookahead == 'T') ADVANCE(150);
      END_STATE();
    case 104:
      if (lookahead == 'I') ADVANCE(151);
      END_STATE();
    case 105:
      if (lookahead == 'S') ADVANCE(152);
      END_STATE();
    case 106:
      if (lookahead == 'F') ADVANCE(153);
      END_STATE();
    case 107:
      if (lookahead == 'E') ADVANCE(154);
      END_STATE();
    case 108:
      if (lookahead == 'P') ADVANCE(155);
      END_STATE();
    case 109:
      if (lookahead == 'N') ADVANCE(156);
      if (lookahead == 'O') ADVANCE(157);
      END_STATE();
    case 110:
      if (lookahead == 'E') ADVANCE(158);
      END_STATE();
    case 111:
      if (lookahead == 'H') ADVANCE(159);
      END_STATE();
    case 112:
      if (lookahead == 'O') ADVANCE(160);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 114:
      if (lookahead == 'I') ADVANCE(161);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 116:
      if (lookahead == 'H') ADVANCE(162);
      if (lookahead == 'N') ADVANCE(163);
      END_STATE();
    case 117:
      if (lookahead == 'O') ADVANCE(164);
      END_STATE();
    case 118:
      if (lookahead == 'M') ADVANCE(165);
      END_STATE();
    case 119:
      if (lookahead == 'M') ADVANCE(166);
      END_STATE();
    case 120:
      if (lookahead == 'E') ADVANCE(167);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 122:
      if (lookahead == 'S') ADVANCE(168);
      END_STATE();
    case 123:
      if (lookahead == 'T') ADVANCE(169);
      END_STATE();
    case 124:
      if (lookahead == 'L') ADVANCE(170);
      END_STATE();
    case 125:
      if (lookahead == 'N') ADVANCE(171);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 127:
      if (lookahead == 'I') ADVANCE(172);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 129:
      if (lookahead == 'L') ADVANCE(173);
      END_STATE();
    case 130:
      if (lookahead == 'P') ADVANCE(174);
      END_STATE();
    case 131:
      if (lookahead == 'N') ADVANCE(175);
      END_STATE();
    case 132:
      if (lookahead == 'E') ADVANCE(176);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 135:
      if (lookahead == 'A') ADVANCE(177);
      END_STATE();
    case 136:
      if (lookahead == 'D') ADVANCE(178);
      END_STATE();
    case 137:
      if (lookahead == 'A') ADVANCE(179);
      END_STATE();
    case 138:
      if (lookahead == 'L') ADVANCE(180);
      END_STATE();
    case 139:
      if (lookahead == 'L') ADVANCE(181);
      END_STATE();
    case 140:
      if (lookahead == 'O') ADVANCE(182);
      END_STATE();
    case 141:
      if (lookahead == 'T') ADVANCE(183);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 143:
      if (lookahead == 'R') ADVANCE(184);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 145:
      if (lookahead == 'F') ADVANCE(185);
      END_STATE();
    case 146:
      if (lookahead == 'O') ADVANCE(186);
      END_STATE();
    case 147:
      if (lookahead == 'E') ADVANCE(187);
      END_STATE();
    case 148:
      if (lookahead == 'R') ADVANCE(188);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 150:
      if (lookahead == 'E') ADVANCE(189);
      END_STATE();
    case 151:
      if (lookahead == 'N') ADVANCE(190);
      END_STATE();
    case 152:
      if (lookahead == 'E') ADVANCE(191);
      END_STATE();
    case 153:
      if (lookahead == 'I') ADVANCE(192);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 155:
      if (lookahead == 'O') ADVANCE(193);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 157:
      if (lookahead == 'R') ADVANCE(194);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 159:
      if (lookahead == 'A') ADVANCE(195);
      END_STATE();
    case 160:
      if (lookahead == 'N') ADVANCE(196);
      END_STATE();
    case 161:
      if (lookahead == 'A') ADVANCE(197);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 163:
      if (lookahead == 'E') ADVANCE(198);
      END_STATE();
    case 164:
      if (lookahead == 'N') ADVANCE(199);
      END_STATE();
    case 165:
      if (lookahead == 'E') ADVANCE(200);
      if (lookahead == 'P') ADVANCE(201);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 167:
      if (lookahead == 'A') ADVANCE(202);
      END_STATE();
    case 168:
      if (lookahead == 'E') ADVANCE(203);
      END_STATE();
    case 169:
      if (lookahead == 'A') ADVANCE(204);
      END_STATE();
    case 170:
      if (lookahead == 'L') ADVANCE(205);
      END_STATE();
    case 171:
      if (lookahead == 'E') ADVANCE(206);
      END_STATE();
    case 172:
      if (lookahead == 'N') ADVANCE(207);
      END_STATE();
    case 173:
      if (lookahead == 'E') ADVANCE(208);
      END_STATE();
    case 174:
      if (lookahead == 'T') ADVANCE(209);
      END_STATE();
    case 175:
      if (lookahead == 'D') ADVANCE(210);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 177:
      if (lookahead == 'N') ADVANCE(211);
      END_STATE();
    case 178:
      if (lookahead == 'A') ADVANCE(212);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 181:
      if (lookahead == 'E') ADVANCE(213);
      END_STATE();
    case 182:
      if (lookahead == 'U') ADVANCE(214);
      END_STATE();
    case 183:
      if (lookahead == 'E') ADVANCE(215);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 186:
      if (lookahead == 'S') ADVANCE(216);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 188:
      if (lookahead == 'S') ADVANCE(217);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 190:
      if (lookahead == 'G') ADVANCE(218);
      END_STATE();
    case 191:
      if (lookahead == 'T') ADVANCE(219);
      END_STATE();
    case 192:
      if (lookahead == 'C') ADVANCE(220);
      END_STATE();
    case 193:
      if (lookahead == 'R') ADVANCE(221);
      END_STATE();
    case 194:
      if (lookahead == 'E') ADVANCE(222);
      END_STATE();
    case 195:
      if (lookahead == 'N') ADVANCE(223);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 197:
      if (lookahead == 'B') ADVANCE(224);
      END_STATE();
    case 198:
      if (lookahead == 'S') ADVANCE(225);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 201:
      if (lookahead == 'T') ADVANCE(226);
      END_STATE();
    case 202:
      if (lookahead == 'N') ADVANCE(227);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 204:
      if (lookahead == 'N') ADVANCE(228);
      END_STATE();
    case 205:
      if (lookahead == 'A') ADVANCE(229);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      END_STATE();
    case 208:
      if (lookahead == 'D') ADVANCE(230);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 210:
      if (lookahead == 'S') ADVANCE(231);
      END_STATE();
    case 211:
      if (lookahead == 'C') ADVANCE(232);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 214:
      if (lookahead == 'S') ADVANCE(233);
      END_STATE();
    case 215:
      if (lookahead == 'D') ADVANCE(234);
      END_STATE();
    case 216:
      if (lookahead == 'I') ADVANCE(235);
      END_STATE();
    case 217:
      if (lookahead == 'I') ADVANCE(236);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_STRING);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      END_STATE();
    case 220:
      if (lookahead == 'E') ADVANCE(237);
      END_STATE();
    case 221:
      if (lookahead == 'A') ADVANCE(238);
      END_STATE();
    case 222:
      if (lookahead == 'M') ADVANCE(239);
      END_STATE();
    case 223:
      if (lookahead == 'G') ADVANCE(240);
      END_STATE();
    case 224:
      if (lookahead == 'L') ADVANCE(241);
      END_STATE();
    case 225:
      if (lookahead == 'S') ADVANCE(242);
      END_STATE();
    case 226:
      if (lookahead == 'I') ADVANCE(243);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_BOOLEAN);
      END_STATE();
    case 228:
      if (lookahead == 'T') ADVANCE(244);
      END_STATE();
    case 229:
      if (lookahead == 'R') ADVANCE(245);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 232:
      if (lookahead == 'E') ADVANCE(246);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 235:
      if (lookahead == 'T') ADVANCE(247);
      END_STATE();
    case 236:
      if (lookahead == 'V') ADVANCE(248);
      END_STATE();
    case 237:
      if (lookahead == 'S') ADVANCE(249);
      END_STATE();
    case 238:
      if (lookahead == 'L') ADVANCE(250);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 240:
      if (lookahead == 'E') ADVANCE(251);
      END_STATE();
    case 241:
      if (lookahead == 'E') ADVANCE(252);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 243:
      if (lookahead == 'O') ADVANCE(253);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(254);
      END_STATE();
    case 245:
      if (lookahead == 'Y') ADVANCE(255);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      END_STATE();
    case 247:
      if (lookahead == 'I') ADVANCE(256);
      END_STATE();
    case 248:
      if (lookahead == 'E') ADVANCE(257);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 251:
      if (lookahead == 'D') ADVANCE(258);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(259);
      END_STATE();
    case 253:
      if (lookahead == 'N') ADVANCE(260);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 256:
      if (lookahead == 'O') ADVANCE(261);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 261:
      if (lookahead == 'N') ADVANCE(262);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 183, .external_lex_state = 3},
  [3] = {.lex_state = 183, .external_lex_state = 3},
  [4] = {.lex_state = 183, .external_lex_state = 4},
  [5] = {.lex_state = 184, .external_lex_state = 4},
  [6] = {.lex_state = 184, .external_lex_state = 4},
  [7] = {.lex_state = 184, .external_lex_state = 4},
  [8] = {.lex_state = 184, .external_lex_state = 4},
  [9] = {.lex_state = 183, .external_lex_state = 4},
  [10] = {.lex_state = 183, .external_lex_state = 4},
  [11] = {.lex_state = 183, .external_lex_state = 4},
  [12] = {.lex_state = 183, .external_lex_state = 4},
  [13] = {.lex_state = 183, .external_lex_state = 4},
  [14] = {.lex_state = 183, .external_lex_state = 4},
  [15] = {.lex_state = 183, .external_lex_state = 4},
  [16] = {.lex_state = 183, .external_lex_state = 4},
  [17] = {.lex_state = 183, .external_lex_state = 4},
  [18] = {.lex_state = 183, .external_lex_state = 4},
  [19] = {.lex_state = 183, .external_lex_state = 4},
  [20] = {.lex_state = 183, .external_lex_state = 4},
  [21] = {.lex_state = 183, .external_lex_state = 4},
  [22] = {.lex_state = 183, .external_lex_state = 4},
  [23] = {.lex_state = 183, .external_lex_state = 4},
  [24] = {.lex_state = 183, .external_lex_state = 4},
  [25] = {.lex_state = 183, .external_lex_state = 4},
  [26] = {.lex_state = 183, .external_lex_state = 4},
  [27] = {.lex_state = 183, .external_lex_state = 4},
  [28] = {.lex_state = 183, .external_lex_state = 4},
  [29] = {.lex_state = 183, .external_lex_state = 4},
  [30] = {.lex_state = 183, .external_lex_state = 4},
  [31] = {.lex_state = 183, .external_lex_state = 4},
  [32] = {.lex_state = 183, .external_lex_state = 4},
  [33] = {.lex_state = 183, .external_lex_state = 4},
  [34] = {.lex_state = 183, .external_lex_state = 4},
  [35] = {.lex_state = 183, .external_lex_state = 4},
  [36] = {.lex_state = 183, .external_lex_state = 4},
  [37] = {.lex_state = 183, .external_lex_state = 4},
  [38] = {.lex_state = 183, .external_lex_state = 4},
  [39] = {.lex_state = 183, .external_lex_state = 4},
  [40] = {.lex_state = 183, .external_lex_state = 4},
  [41] = {.lex_state = 183, .external_lex_state = 4},
  [42] = {.lex_state = 183, .external_lex_state = 4},
  [43] = {.lex_state = 183, .external_lex_state = 4},
  [44] = {.lex_state = 183, .external_lex_state = 4},
  [45] = {.lex_state = 183, .external_lex_state = 4},
  [46] = {.lex_state = 183, .external_lex_state = 4},
  [47] = {.lex_state = 183, .external_lex_state = 4},
  [48] = {.lex_state = 183, .external_lex_state = 4},
  [49] = {.lex_state = 183, .external_lex_state = 4},
  [50] = {.lex_state = 183, .external_lex_state = 4},
  [51] = {.lex_state = 183, .external_lex_state = 4},
  [52] = {.lex_state = 183, .external_lex_state = 4},
  [53] = {.lex_state = 183, .external_lex_state = 4},
  [54] = {.lex_state = 183, .external_lex_state = 4},
  [55] = {.lex_state = 183, .external_lex_state = 4},
  [56] = {.lex_state = 183, .external_lex_state = 4},
  [57] = {.lex_state = 183, .external_lex_state = 4},
  [58] = {.lex_state = 183, .external_lex_state = 4},
  [59] = {.lex_state = 183, .external_lex_state = 4},
  [60] = {.lex_state = 183, .external_lex_state = 4},
  [61] = {.lex_state = 183, .external_lex_state = 4},
  [62] = {.lex_state = 183, .external_lex_state = 4},
  [63] = {.lex_state = 183, .external_lex_state = 4},
  [64] = {.lex_state = 183, .external_lex_state = 4},
  [65] = {.lex_state = 183, .external_lex_state = 4},
  [66] = {.lex_state = 183, .external_lex_state = 4},
  [67] = {.lex_state = 183, .external_lex_state = 4},
  [68] = {.lex_state = 183, .external_lex_state = 4},
  [69] = {.lex_state = 183, .external_lex_state = 4},
  [70] = {.lex_state = 183, .external_lex_state = 4},
  [71] = {.lex_state = 183, .external_lex_state = 4},
  [72] = {.lex_state = 183, .external_lex_state = 4},
  [73] = {.lex_state = 183, .external_lex_state = 4},
  [74] = {.lex_state = 183, .external_lex_state = 4},
  [75] = {.lex_state = 183, .external_lex_state = 4},
  [76] = {.lex_state = 183, .external_lex_state = 4},
  [77] = {.lex_state = 183, .external_lex_state = 4},
  [78] = {.lex_state = 183, .external_lex_state = 4},
  [79] = {.lex_state = 183, .external_lex_state = 4},
  [80] = {.lex_state = 183, .external_lex_state = 4},
  [81] = {.lex_state = 183, .external_lex_state = 4},
  [82] = {.lex_state = 183, .external_lex_state = 4},
  [83] = {.lex_state = 183, .external_lex_state = 4},
  [84] = {.lex_state = 183, .external_lex_state = 4},
  [85] = {.lex_state = 183, .external_lex_state = 4},
  [86] = {.lex_state = 183, .external_lex_state = 4},
  [87] = {.lex_state = 183, .external_lex_state = 4},
  [88] = {.lex_state = 183, .external_lex_state = 4},
  [89] = {.lex_state = 183, .external_lex_state = 4},
  [90] = {.lex_state = 183, .external_lex_state = 4},
  [91] = {.lex_state = 183, .external_lex_state = 4},
  [92] = {.lex_state = 183, .external_lex_state = 4},
  [93] = {.lex_state = 183, .external_lex_state = 4},
  [94] = {.lex_state = 185, .external_lex_state = 4},
  [95] = {.lex_state = 183, .external_lex_state = 4},
  [96] = {.lex_state = 183, .external_lex_state = 4},
  [97] = {.lex_state = 183, .external_lex_state = 4},
  [98] = {.lex_state = 183, .external_lex_state = 4},
  [99] = {.lex_state = 183, .external_lex_state = 4},
  [100] = {.lex_state = 185, .external_lex_state = 4},
  [101] = {.lex_state = 183, .external_lex_state = 5},
  [102] = {.lex_state = 185, .external_lex_state = 4},
  [103] = {.lex_state = 183, .external_lex_state = 5},
  [104] = {.lex_state = 183, .external_lex_state = 5},
  [105] = {.lex_state = 183, .external_lex_state = 5},
  [106] = {.lex_state = 183, .external_lex_state = 4},
  [107] = {.lex_state = 185, .external_lex_state = 4},
  [108] = {.lex_state = 183, .external_lex_state = 4},
  [109] = {.lex_state = 185, .external_lex_state = 4},
  [110] = {.lex_state = 183, .external_lex_state = 4},
  [111] = {.lex_state = 183, .external_lex_state = 4},
  [112] = {.lex_state = 185, .external_lex_state = 4},
  [113] = {.lex_state = 185, .external_lex_state = 4},
  [114] = {.lex_state = 183, .external_lex_state = 5},
  [115] = {.lex_state = 183, .external_lex_state = 4},
  [116] = {.lex_state = 183, .external_lex_state = 4},
  [117] = {.lex_state = 183, .external_lex_state = 5},
  [118] = {.lex_state = 183, .external_lex_state = 5},
  [119] = {.lex_state = 183, .external_lex_state = 5},
  [120] = {.lex_state = 185, .external_lex_state = 4},
  [121] = {.lex_state = 183, .external_lex_state = 4},
  [122] = {.lex_state = 183, .external_lex_state = 4},
  [123] = {.lex_state = 183, .external_lex_state = 4},
  [124] = {.lex_state = 183, .external_lex_state = 4},
  [125] = {.lex_state = 183, .external_lex_state = 4},
  [126] = {.lex_state = 185, .external_lex_state = 4},
  [127] = {.lex_state = 183, .external_lex_state = 4},
  [128] = {.lex_state = 183, .external_lex_state = 4},
  [129] = {.lex_state = 183, .external_lex_state = 4},
  [130] = {.lex_state = 185, .external_lex_state = 4},
  [131] = {.lex_state = 183, .external_lex_state = 4},
  [132] = {.lex_state = 185, .external_lex_state = 4},
  [133] = {.lex_state = 183, .external_lex_state = 4},
  [134] = {.lex_state = 183, .external_lex_state = 4},
  [135] = {.lex_state = 183, .external_lex_state = 4},
  [136] = {.lex_state = 183, .external_lex_state = 4},
  [137] = {.lex_state = 183, .external_lex_state = 4},
  [138] = {.lex_state = 185, .external_lex_state = 4},
  [139] = {.lex_state = 183, .external_lex_state = 4},
  [140] = {.lex_state = 185, .external_lex_state = 4},
  [141] = {.lex_state = 183, .external_lex_state = 4},
  [142] = {.lex_state = 183, .external_lex_state = 4},
  [143] = {.lex_state = 185, .external_lex_state = 4},
  [144] = {.lex_state = 183, .external_lex_state = 4},
  [145] = {.lex_state = 183, .external_lex_state = 4},
  [146] = {.lex_state = 183, .external_lex_state = 4},
  [147] = {.lex_state = 183, .external_lex_state = 4},
  [148] = {.lex_state = 183, .external_lex_state = 4},
  [149] = {.lex_state = 185, .external_lex_state = 4},
  [150] = {.lex_state = 183, .external_lex_state = 4},
  [151] = {.lex_state = 183, .external_lex_state = 4},
  [152] = {.lex_state = 183, .external_lex_state = 4},
  [153] = {.lex_state = 185, .external_lex_state = 4},
  [154] = {.lex_state = 183, .external_lex_state = 4},
  [155] = {.lex_state = 183, .external_lex_state = 4},
  [156] = {.lex_state = 183, .external_lex_state = 4},
  [157] = {.lex_state = 183, .external_lex_state = 4},
  [158] = {.lex_state = 183, .external_lex_state = 4},
  [159] = {.lex_state = 183, .external_lex_state = 4},
  [160] = {.lex_state = 183, .external_lex_state = 4},
  [161] = {.lex_state = 185, .external_lex_state = 4},
  [162] = {.lex_state = 183, .external_lex_state = 4},
  [163] = {.lex_state = 183, .external_lex_state = 4},
  [164] = {.lex_state = 183, .external_lex_state = 4},
  [165] = {.lex_state = 183, .external_lex_state = 4},
  [166] = {.lex_state = 183, .external_lex_state = 4},
  [167] = {.lex_state = 183, .external_lex_state = 4},
  [168] = {.lex_state = 183, .external_lex_state = 4},
  [169] = {.lex_state = 183, .external_lex_state = 4},
  [170] = {.lex_state = 183, .external_lex_state = 4},
  [171] = {.lex_state = 183, .external_lex_state = 4},
  [172] = {.lex_state = 183, .external_lex_state = 4},
  [173] = {.lex_state = 183, .external_lex_state = 4},
  [174] = {.lex_state = 183, .external_lex_state = 4},
  [175] = {.lex_state = 183, .external_lex_state = 4},
  [176] = {.lex_state = 183, .external_lex_state = 4},
  [177] = {.lex_state = 183, .external_lex_state = 4},
  [178] = {.lex_state = 183, .external_lex_state = 4},
  [179] = {.lex_state = 183, .external_lex_state = 4},
  [180] = {.lex_state = 183, .external_lex_state = 4},
  [181] = {.lex_state = 183, .external_lex_state = 4},
  [182] = {.lex_state = 183, .external_lex_state = 4},
  [183] = {.lex_state = 183, .external_lex_state = 4},
  [184] = {.lex_state = 183, .external_lex_state = 4},
  [185] = {.lex_state = 183, .external_lex_state = 4},
  [186] = {.lex_state = 183, .external_lex_state = 4},
  [187] = {.lex_state = 183, .external_lex_state = 4},
  [188] = {.lex_state = 183, .external_lex_state = 4},
  [189] = {.lex_state = 183, .external_lex_state = 4},
  [190] = {.lex_state = 183, .external_lex_state = 4},
  [191] = {.lex_state = 183, .external_lex_state = 4},
  [192] = {.lex_state = 183, .external_lex_state = 4},
  [193] = {.lex_state = 183, .external_lex_state = 4},
  [194] = {.lex_state = 183, .external_lex_state = 4},
  [195] = {.lex_state = 183, .external_lex_state = 4},
  [196] = {.lex_state = 183, .external_lex_state = 4},
  [197] = {.lex_state = 183, .external_lex_state = 4},
  [198] = {.lex_state = 183, .external_lex_state = 4},
  [199] = {.lex_state = 183, .external_lex_state = 4},
  [200] = {.lex_state = 183, .external_lex_state = 4},
  [201] = {.lex_state = 183, .external_lex_state = 4},
  [202] = {.lex_state = 183, .external_lex_state = 4},
  [203] = {.lex_state = 183, .external_lex_state = 4},
  [204] = {.lex_state = 183, .external_lex_state = 4},
  [205] = {.lex_state = 183, .external_lex_state = 4},
  [206] = {.lex_state = 183, .external_lex_state = 4},
  [207] = {.lex_state = 183, .external_lex_state = 4},
  [208] = {.lex_state = 183, .external_lex_state = 4},
  [209] = {.lex_state = 183, .external_lex_state = 4},
  [210] = {.lex_state = 183, .external_lex_state = 4},
  [211] = {.lex_state = 183, .external_lex_state = 4},
  [212] = {.lex_state = 183, .external_lex_state = 4},
  [213] = {.lex_state = 183, .external_lex_state = 4},
  [214] = {.lex_state = 183, .external_lex_state = 4},
  [215] = {.lex_state = 183, .external_lex_state = 4},
  [216] = {.lex_state = 183, .external_lex_state = 4},
  [217] = {.lex_state = 183, .external_lex_state = 4},
  [218] = {.lex_state = 183, .external_lex_state = 4},
  [219] = {.lex_state = 183, .external_lex_state = 4},
  [220] = {.lex_state = 183, .external_lex_state = 4},
  [221] = {.lex_state = 183, .external_lex_state = 4},
  [222] = {.lex_state = 183, .external_lex_state = 4},
  [223] = {.lex_state = 183, .external_lex_state = 4},
  [224] = {.lex_state = 183, .external_lex_state = 4},
  [225] = {.lex_state = 183, .external_lex_state = 4},
  [226] = {.lex_state = 183, .external_lex_state = 4},
  [227] = {.lex_state = 183, .external_lex_state = 4},
  [228] = {.lex_state = 183, .external_lex_state = 4},
  [229] = {.lex_state = 183, .external_lex_state = 4},
  [230] = {.lex_state = 183, .external_lex_state = 4},
  [231] = {.lex_state = 183, .external_lex_state = 4},
  [232] = {.lex_state = 183, .external_lex_state = 4},
  [233] = {.lex_state = 183, .external_lex_state = 4},
  [234] = {.lex_state = 183, .external_lex_state = 4},
  [235] = {.lex_state = 183, .external_lex_state = 4},
  [236] = {.lex_state = 183, .external_lex_state = 4},
  [237] = {.lex_state = 183, .external_lex_state = 4},
  [238] = {.lex_state = 183, .external_lex_state = 4},
  [239] = {.lex_state = 183, .external_lex_state = 4},
  [240] = {.lex_state = 183, .external_lex_state = 4},
  [241] = {.lex_state = 183, .external_lex_state = 4},
  [242] = {.lex_state = 183, .external_lex_state = 4},
  [243] = {.lex_state = 183, .external_lex_state = 4},
  [244] = {.lex_state = 183, .external_lex_state = 4},
  [245] = {.lex_state = 183, .external_lex_state = 4},
  [246] = {.lex_state = 183, .external_lex_state = 4},
  [247] = {.lex_state = 183, .external_lex_state = 4},
  [248] = {.lex_state = 183, .external_lex_state = 4},
  [249] = {.lex_state = 183, .external_lex_state = 4},
  [250] = {.lex_state = 183, .external_lex_state = 4},
  [251] = {.lex_state = 183, .external_lex_state = 4},
  [252] = {.lex_state = 183, .external_lex_state = 4},
  [253] = {.lex_state = 183, .external_lex_state = 4},
  [254] = {.lex_state = 183, .external_lex_state = 4},
  [255] = {.lex_state = 183, .external_lex_state = 4},
  [256] = {.lex_state = 183, .external_lex_state = 4},
  [257] = {.lex_state = 183, .external_lex_state = 4},
  [258] = {.lex_state = 183, .external_lex_state = 4},
  [259] = {.lex_state = 183, .external_lex_state = 4},
  [260] = {.lex_state = 183, .external_lex_state = 4},
  [261] = {.lex_state = 183, .external_lex_state = 4},
  [262] = {.lex_state = 183, .external_lex_state = 4},
  [263] = {.lex_state = 183, .external_lex_state = 4},
  [264] = {.lex_state = 183, .external_lex_state = 4},
  [265] = {.lex_state = 183, .external_lex_state = 4},
  [266] = {.lex_state = 183, .external_lex_state = 4},
  [267] = {.lex_state = 183, .external_lex_state = 4},
  [268] = {.lex_state = 183, .external_lex_state = 4},
  [269] = {.lex_state = 183, .external_lex_state = 4},
  [270] = {.lex_state = 183, .external_lex_state = 4},
  [271] = {.lex_state = 183, .external_lex_state = 4},
  [272] = {.lex_state = 183, .external_lex_state = 4},
  [273] = {.lex_state = 183, .external_lex_state = 4},
  [274] = {.lex_state = 183, .external_lex_state = 4},
  [275] = {.lex_state = 183, .external_lex_state = 4},
  [276] = {.lex_state = 183, .external_lex_state = 4},
  [277] = {.lex_state = 183, .external_lex_state = 4},
  [278] = {.lex_state = 183, .external_lex_state = 4},
  [279] = {.lex_state = 183, .external_lex_state = 4},
  [280] = {.lex_state = 183, .external_lex_state = 4},
  [281] = {.lex_state = 183, .external_lex_state = 4},
  [282] = {.lex_state = 183, .external_lex_state = 4},
  [283] = {.lex_state = 183, .external_lex_state = 4},
  [284] = {.lex_state = 183, .external_lex_state = 4},
  [285] = {.lex_state = 183, .external_lex_state = 4},
  [286] = {.lex_state = 183, .external_lex_state = 4},
  [287] = {.lex_state = 183, .external_lex_state = 4},
  [288] = {.lex_state = 183, .external_lex_state = 4},
  [289] = {.lex_state = 183, .external_lex_state = 4},
  [290] = {.lex_state = 183, .external_lex_state = 4},
  [291] = {.lex_state = 183, .external_lex_state = 4},
  [292] = {.lex_state = 183, .external_lex_state = 4},
  [293] = {.lex_state = 183, .external_lex_state = 4},
  [294] = {.lex_state = 183, .external_lex_state = 4},
  [295] = {.lex_state = 183, .external_lex_state = 4},
  [296] = {.lex_state = 183, .external_lex_state = 4},
  [297] = {.lex_state = 183, .external_lex_state = 4},
  [298] = {.lex_state = 183, .external_lex_state = 4},
  [299] = {.lex_state = 183, .external_lex_state = 4},
  [300] = {.lex_state = 183, .external_lex_state = 4},
  [301] = {.lex_state = 183, .external_lex_state = 4},
  [302] = {.lex_state = 183, .external_lex_state = 4},
  [303] = {.lex_state = 183, .external_lex_state = 4},
  [304] = {.lex_state = 183, .external_lex_state = 4},
  [305] = {.lex_state = 183, .external_lex_state = 4},
  [306] = {.lex_state = 183, .external_lex_state = 4},
  [307] = {.lex_state = 183, .external_lex_state = 4},
  [308] = {.lex_state = 183, .external_lex_state = 4},
  [309] = {.lex_state = 183, .external_lex_state = 4},
  [310] = {.lex_state = 183, .external_lex_state = 4},
  [311] = {.lex_state = 183, .external_lex_state = 4},
  [312] = {.lex_state = 183, .external_lex_state = 4},
  [313] = {.lex_state = 183, .external_lex_state = 4},
  [314] = {.lex_state = 183, .external_lex_state = 4},
  [315] = {.lex_state = 183, .external_lex_state = 4},
  [316] = {.lex_state = 183, .external_lex_state = 4},
  [317] = {.lex_state = 183, .external_lex_state = 4},
  [318] = {.lex_state = 183, .external_lex_state = 4},
  [319] = {.lex_state = 183, .external_lex_state = 4},
  [320] = {.lex_state = 183, .external_lex_state = 4},
  [321] = {.lex_state = 183, .external_lex_state = 4},
  [322] = {.lex_state = 183, .external_lex_state = 4},
  [323] = {.lex_state = 183, .external_lex_state = 4},
  [324] = {.lex_state = 183, .external_lex_state = 4},
  [325] = {.lex_state = 183, .external_lex_state = 4},
  [326] = {.lex_state = 183, .external_lex_state = 4},
  [327] = {.lex_state = 183, .external_lex_state = 4},
  [328] = {.lex_state = 183, .external_lex_state = 4},
  [329] = {.lex_state = 183, .external_lex_state = 4},
  [330] = {.lex_state = 183, .external_lex_state = 4},
  [331] = {.lex_state = 183, .external_lex_state = 4},
  [332] = {.lex_state = 183, .external_lex_state = 4},
  [333] = {.lex_state = 183, .external_lex_state = 4},
  [334] = {.lex_state = 183, .external_lex_state = 4},
  [335] = {.lex_state = 183, .external_lex_state = 4},
  [336] = {.lex_state = 183, .external_lex_state = 4},
  [337] = {.lex_state = 183, .external_lex_state = 4},
  [338] = {.lex_state = 183, .external_lex_state = 4},
  [339] = {.lex_state = 183, .external_lex_state = 4},
  [340] = {.lex_state = 183, .external_lex_state = 4},
  [341] = {.lex_state = 183, .external_lex_state = 4},
  [342] = {.lex_state = 183, .external_lex_state = 4},
  [343] = {.lex_state = 183, .external_lex_state = 4},
  [344] = {.lex_state = 183, .external_lex_state = 4},
  [345] = {.lex_state = 183, .external_lex_state = 4},
  [346] = {.lex_state = 183, .external_lex_state = 4},
  [347] = {.lex_state = 183, .external_lex_state = 4},
  [348] = {.lex_state = 183, .external_lex_state = 4},
  [349] = {.lex_state = 183, .external_lex_state = 4},
  [350] = {.lex_state = 183, .external_lex_state = 4},
  [351] = {.lex_state = 183, .external_lex_state = 4},
  [352] = {.lex_state = 183, .external_lex_state = 4},
  [353] = {.lex_state = 183, .external_lex_state = 4},
  [354] = {.lex_state = 183, .external_lex_state = 4},
  [355] = {.lex_state = 183, .external_lex_state = 4},
  [356] = {.lex_state = 183, .external_lex_state = 4},
  [357] = {.lex_state = 183, .external_lex_state = 4},
  [358] = {.lex_state = 183, .external_lex_state = 4},
  [359] = {.lex_state = 183, .external_lex_state = 4},
  [360] = {.lex_state = 183, .external_lex_state = 4},
  [361] = {.lex_state = 183, .external_lex_state = 4},
  [362] = {.lex_state = 183, .external_lex_state = 4},
  [363] = {.lex_state = 183, .external_lex_state = 4},
  [364] = {.lex_state = 183, .external_lex_state = 4},
  [365] = {.lex_state = 183, .external_lex_state = 4},
  [366] = {.lex_state = 183, .external_lex_state = 4},
  [367] = {.lex_state = 183, .external_lex_state = 4},
  [368] = {.lex_state = 183, .external_lex_state = 4},
  [369] = {.lex_state = 183, .external_lex_state = 4},
  [370] = {.lex_state = 183, .external_lex_state = 4},
  [371] = {.lex_state = 183, .external_lex_state = 4},
  [372] = {.lex_state = 183, .external_lex_state = 4},
  [373] = {.lex_state = 183, .external_lex_state = 4},
  [374] = {.lex_state = 183, .external_lex_state = 4},
  [375] = {.lex_state = 183, .external_lex_state = 4},
  [376] = {.lex_state = 183, .external_lex_state = 4},
  [377] = {.lex_state = 183, .external_lex_state = 4},
  [378] = {.lex_state = 183, .external_lex_state = 4},
  [379] = {.lex_state = 183, .external_lex_state = 4},
  [380] = {.lex_state = 183, .external_lex_state = 4},
  [381] = {.lex_state = 183, .external_lex_state = 4},
  [382] = {.lex_state = 183, .external_lex_state = 4},
  [383] = {.lex_state = 183, .external_lex_state = 4},
  [384] = {.lex_state = 183, .external_lex_state = 4},
  [385] = {.lex_state = 183, .external_lex_state = 4},
  [386] = {.lex_state = 183, .external_lex_state = 4},
  [387] = {.lex_state = 183, .external_lex_state = 4},
  [388] = {.lex_state = 183, .external_lex_state = 4},
  [389] = {.lex_state = 183, .external_lex_state = 4},
  [390] = {.lex_state = 183, .external_lex_state = 4},
  [391] = {.lex_state = 183, .external_lex_state = 4},
  [392] = {.lex_state = 183, .external_lex_state = 4},
  [393] = {.lex_state = 183, .external_lex_state = 4},
  [394] = {.lex_state = 183, .external_lex_state = 4},
  [395] = {.lex_state = 183, .external_lex_state = 4},
  [396] = {.lex_state = 183, .external_lex_state = 4},
  [397] = {.lex_state = 183, .external_lex_state = 4},
  [398] = {.lex_state = 183, .external_lex_state = 4},
  [399] = {.lex_state = 183, .external_lex_state = 4},
  [400] = {.lex_state = 183, .external_lex_state = 4},
  [401] = {.lex_state = 183, .external_lex_state = 4},
  [402] = {.lex_state = 183, .external_lex_state = 4},
  [403] = {.lex_state = 183, .external_lex_state = 4},
  [404] = {.lex_state = 183, .external_lex_state = 4},
  [405] = {.lex_state = 183, .external_lex_state = 4},
  [406] = {.lex_state = 183, .external_lex_state = 4},
  [407] = {.lex_state = 183, .external_lex_state = 4},
  [408] = {.lex_state = 183, .external_lex_state = 4},
  [409] = {.lex_state = 183, .external_lex_state = 4},
  [410] = {.lex_state = 183, .external_lex_state = 4},
  [411] = {.lex_state = 183, .external_lex_state = 4},
  [412] = {.lex_state = 183, .external_lex_state = 4},
  [413] = {.lex_state = 183, .external_lex_state = 4},
  [414] = {.lex_state = 183, .external_lex_state = 4},
  [415] = {.lex_state = 183, .external_lex_state = 4},
  [416] = {.lex_state = 183, .external_lex_state = 4},
  [417] = {.lex_state = 183, .external_lex_state = 4},
  [418] = {.lex_state = 183, .external_lex_state = 4},
  [419] = {.lex_state = 183, .external_lex_state = 4},
  [420] = {.lex_state = 183, .external_lex_state = 4},
  [421] = {.lex_state = 183, .external_lex_state = 4},
  [422] = {.lex_state = 183, .external_lex_state = 4},
  [423] = {.lex_state = 183, .external_lex_state = 4},
  [424] = {.lex_state = 183, .external_lex_state = 4},
  [425] = {.lex_state = 183, .external_lex_state = 4},
  [426] = {.lex_state = 183, .external_lex_state = 4},
  [427] = {.lex_state = 183, .external_lex_state = 4},
  [428] = {.lex_state = 183, .external_lex_state = 4},
  [429] = {.lex_state = 183, .external_lex_state = 4},
  [430] = {.lex_state = 183, .external_lex_state = 4},
  [431] = {.lex_state = 183, .external_lex_state = 4},
  [432] = {.lex_state = 183, .external_lex_state = 4},
  [433] = {.lex_state = 183, .external_lex_state = 4},
  [434] = {.lex_state = 183, .external_lex_state = 4},
  [435] = {.lex_state = 183, .external_lex_state = 4},
  [436] = {.lex_state = 183, .external_lex_state = 4},
  [437] = {.lex_state = 183, .external_lex_state = 4},
  [438] = {.lex_state = 183, .external_lex_state = 4},
  [439] = {.lex_state = 183, .external_lex_state = 4},
  [440] = {.lex_state = 183, .external_lex_state = 4},
  [441] = {.lex_state = 183, .external_lex_state = 4},
  [442] = {.lex_state = 183, .external_lex_state = 4},
  [443] = {.lex_state = 183, .external_lex_state = 4},
  [444] = {.lex_state = 183, .external_lex_state = 4},
  [445] = {.lex_state = 183, .external_lex_state = 4},
  [446] = {.lex_state = 183, .external_lex_state = 4},
  [447] = {.lex_state = 183, .external_lex_state = 4},
  [448] = {.lex_state = 183, .external_lex_state = 4},
  [449] = {.lex_state = 183, .external_lex_state = 4},
  [450] = {.lex_state = 183, .external_lex_state = 4},
  [451] = {.lex_state = 183, .external_lex_state = 4},
  [452] = {.lex_state = 183, .external_lex_state = 4},
  [453] = {.lex_state = 183, .external_lex_state = 4},
  [454] = {.lex_state = 183, .external_lex_state = 4},
  [455] = {.lex_state = 183, .external_lex_state = 4},
  [456] = {.lex_state = 183, .external_lex_state = 4},
  [457] = {.lex_state = 183, .external_lex_state = 4},
  [458] = {.lex_state = 183, .external_lex_state = 4},
  [459] = {.lex_state = 183, .external_lex_state = 4},
  [460] = {.lex_state = 183, .external_lex_state = 4},
  [461] = {.lex_state = 183, .external_lex_state = 4},
  [462] = {.lex_state = 183, .external_lex_state = 4},
  [463] = {.lex_state = 183, .external_lex_state = 4},
  [464] = {.lex_state = 183, .external_lex_state = 4},
  [465] = {.lex_state = 183, .external_lex_state = 4},
  [466] = {.lex_state = 183, .external_lex_state = 4},
  [467] = {.lex_state = 183, .external_lex_state = 4},
  [468] = {.lex_state = 183, .external_lex_state = 4},
  [469] = {.lex_state = 183, .external_lex_state = 4},
  [470] = {.lex_state = 183, .external_lex_state = 4},
  [471] = {.lex_state = 183, .external_lex_state = 4},
  [472] = {.lex_state = 183, .external_lex_state = 4},
  [473] = {.lex_state = 183, .external_lex_state = 4},
  [474] = {.lex_state = 183, .external_lex_state = 4},
  [475] = {.lex_state = 183, .external_lex_state = 4},
  [476] = {.lex_state = 183, .external_lex_state = 4},
  [477] = {.lex_state = 183, .external_lex_state = 4},
  [478] = {.lex_state = 183, .external_lex_state = 4},
  [479] = {.lex_state = 183, .external_lex_state = 4},
  [480] = {.lex_state = 183, .external_lex_state = 4},
  [481] = {.lex_state = 183, .external_lex_state = 4},
  [482] = {.lex_state = 183, .external_lex_state = 4},
  [483] = {.lex_state = 183, .external_lex_state = 4},
  [484] = {.lex_state = 183, .external_lex_state = 4},
  [485] = {.lex_state = 183, .external_lex_state = 4},
  [486] = {.lex_state = 183, .external_lex_state = 4},
  [487] = {.lex_state = 183, .external_lex_state = 4},
  [488] = {.lex_state = 183, .external_lex_state = 4},
  [489] = {.lex_state = 183, .external_lex_state = 4},
  [490] = {.lex_state = 183, .external_lex_state = 4},
  [491] = {.lex_state = 183, .external_lex_state = 4},
  [492] = {.lex_state = 183, .external_lex_state = 4},
  [493] = {.lex_state = 183, .external_lex_state = 4},
  [494] = {.lex_state = 183, .external_lex_state = 4},
  [495] = {.lex_state = 183, .external_lex_state = 4},
  [496] = {.lex_state = 183, .external_lex_state = 4},
  [497] = {.lex_state = 183, .external_lex_state = 4},
  [498] = {.lex_state = 183, .external_lex_state = 4},
  [499] = {.lex_state = 183, .external_lex_state = 4},
  [500] = {.lex_state = 183, .external_lex_state = 4},
  [501] = {.lex_state = 183, .external_lex_state = 4},
  [502] = {.lex_state = 183, .external_lex_state = 4},
  [503] = {.lex_state = 183, .external_lex_state = 4},
  [504] = {.lex_state = 183, .external_lex_state = 4},
  [505] = {.lex_state = 183, .external_lex_state = 4},
  [506] = {.lex_state = 183, .external_lex_state = 4},
  [507] = {.lex_state = 183, .external_lex_state = 4},
  [508] = {.lex_state = 183, .external_lex_state = 4},
  [509] = {.lex_state = 183, .external_lex_state = 4},
  [510] = {.lex_state = 183, .external_lex_state = 4},
  [511] = {.lex_state = 183, .external_lex_state = 4},
  [512] = {.lex_state = 183, .external_lex_state = 4},
  [513] = {.lex_state = 183, .external_lex_state = 4},
  [514] = {.lex_state = 183, .external_lex_state = 4},
  [515] = {.lex_state = 183, .external_lex_state = 4},
  [516] = {.lex_state = 183, .external_lex_state = 4},
  [517] = {.lex_state = 183, .external_lex_state = 4},
  [518] = {.lex_state = 183, .external_lex_state = 4},
  [519] = {.lex_state = 183, .external_lex_state = 4},
  [520] = {.lex_state = 183, .external_lex_state = 4},
  [521] = {.lex_state = 183, .external_lex_state = 4},
  [522] = {.lex_state = 183, .external_lex_state = 4},
  [523] = {.lex_state = 183, .external_lex_state = 4},
  [524] = {.lex_state = 183, .external_lex_state = 4},
  [525] = {.lex_state = 183, .external_lex_state = 4},
  [526] = {.lex_state = 183, .external_lex_state = 4},
  [527] = {.lex_state = 183, .external_lex_state = 4},
  [528] = {.lex_state = 183, .external_lex_state = 4},
  [529] = {.lex_state = 183, .external_lex_state = 4},
  [530] = {.lex_state = 183, .external_lex_state = 4},
  [531] = {.lex_state = 183, .external_lex_state = 4},
  [532] = {.lex_state = 183, .external_lex_state = 4},
  [533] = {.lex_state = 183, .external_lex_state = 4},
  [534] = {.lex_state = 183, .external_lex_state = 4},
  [535] = {.lex_state = 183, .external_lex_state = 4},
  [536] = {.lex_state = 183, .external_lex_state = 4},
  [537] = {.lex_state = 183, .external_lex_state = 4},
  [538] = {.lex_state = 183, .external_lex_state = 4},
  [539] = {.lex_state = 183, .external_lex_state = 4},
  [540] = {.lex_state = 183, .external_lex_state = 4},
  [541] = {.lex_state = 183, .external_lex_state = 4},
  [542] = {.lex_state = 183, .external_lex_state = 4},
  [543] = {.lex_state = 183, .external_lex_state = 4},
  [544] = {.lex_state = 183, .external_lex_state = 4},
  [545] = {.lex_state = 183, .external_lex_state = 4},
  [546] = {.lex_state = 183, .external_lex_state = 4},
  [547] = {.lex_state = 183, .external_lex_state = 4},
  [548] = {.lex_state = 183, .external_lex_state = 4},
  [549] = {.lex_state = 183, .external_lex_state = 4},
  [550] = {.lex_state = 183, .external_lex_state = 4},
  [551] = {.lex_state = 183, .external_lex_state = 4},
  [552] = {.lex_state = 183, .external_lex_state = 4},
  [553] = {.lex_state = 183, .external_lex_state = 4},
  [554] = {.lex_state = 183, .external_lex_state = 4},
  [555] = {.lex_state = 183, .external_lex_state = 4},
  [556] = {.lex_state = 183, .external_lex_state = 4},
  [557] = {.lex_state = 183, .external_lex_state = 4},
  [558] = {.lex_state = 183, .external_lex_state = 4},
  [559] = {.lex_state = 183, .external_lex_state = 4},
  [560] = {.lex_state = 183, .external_lex_state = 4},
  [561] = {.lex_state = 183, .external_lex_state = 4},
  [562] = {.lex_state = 183, .external_lex_state = 4},
  [563] = {.lex_state = 183, .external_lex_state = 4},
  [564] = {.lex_state = 183, .external_lex_state = 4},
  [565] = {.lex_state = 183, .external_lex_state = 4},
  [566] = {.lex_state = 183, .external_lex_state = 4},
  [567] = {.lex_state = 183, .external_lex_state = 4},
  [568] = {.lex_state = 183, .external_lex_state = 4},
  [569] = {.lex_state = 183, .external_lex_state = 4},
  [570] = {.lex_state = 183, .external_lex_state = 4},
  [571] = {.lex_state = 183, .external_lex_state = 4},
  [572] = {.lex_state = 183, .external_lex_state = 4},
  [573] = {.lex_state = 183, .external_lex_state = 4},
  [574] = {.lex_state = 183, .external_lex_state = 4},
  [575] = {.lex_state = 183, .external_lex_state = 4},
  [576] = {.lex_state = 183, .external_lex_state = 4},
  [577] = {.lex_state = 183, .external_lex_state = 4},
  [578] = {.lex_state = 183, .external_lex_state = 4},
  [579] = {.lex_state = 183, .external_lex_state = 4},
  [580] = {.lex_state = 183, .external_lex_state = 4},
  [581] = {.lex_state = 183, .external_lex_state = 4},
  [582] = {.lex_state = 183, .external_lex_state = 4},
  [583] = {.lex_state = 183, .external_lex_state = 4},
  [584] = {.lex_state = 183, .external_lex_state = 4},
  [585] = {.lex_state = 183, .external_lex_state = 4},
  [586] = {.lex_state = 183, .external_lex_state = 4},
  [587] = {.lex_state = 183, .external_lex_state = 4},
  [588] = {.lex_state = 183, .external_lex_state = 4},
  [589] = {.lex_state = 183, .external_lex_state = 4},
  [590] = {.lex_state = 183, .external_lex_state = 4},
  [591] = {.lex_state = 183, .external_lex_state = 4},
  [592] = {.lex_state = 183, .external_lex_state = 4},
  [593] = {.lex_state = 183, .external_lex_state = 4},
  [594] = {.lex_state = 183, .external_lex_state = 4},
  [595] = {.lex_state = 183, .external_lex_state = 4},
  [596] = {.lex_state = 183, .external_lex_state = 4},
  [597] = {.lex_state = 183, .external_lex_state = 4},
  [598] = {.lex_state = 183, .external_lex_state = 4},
  [599] = {.lex_state = 183, .external_lex_state = 4},
  [600] = {.lex_state = 183, .external_lex_state = 4},
  [601] = {.lex_state = 183, .external_lex_state = 4},
  [602] = {.lex_state = 183, .external_lex_state = 4},
  [603] = {.lex_state = 183, .external_lex_state = 4},
  [604] = {.lex_state = 183, .external_lex_state = 4},
  [605] = {.lex_state = 183, .external_lex_state = 4},
  [606] = {.lex_state = 183, .external_lex_state = 4},
  [607] = {.lex_state = 183, .external_lex_state = 4},
  [608] = {.lex_state = 183, .external_lex_state = 4},
  [609] = {.lex_state = 183, .external_lex_state = 4},
  [610] = {.lex_state = 183, .external_lex_state = 4},
  [611] = {.lex_state = 183, .external_lex_state = 4},
  [612] = {.lex_state = 183, .external_lex_state = 4},
  [613] = {.lex_state = 183, .external_lex_state = 4},
  [614] = {.lex_state = 183, .external_lex_state = 4},
  [615] = {.lex_state = 183, .external_lex_state = 4},
  [616] = {.lex_state = 183, .external_lex_state = 4},
  [617] = {.lex_state = 183, .external_lex_state = 4},
  [618] = {.lex_state = 183, .external_lex_state = 4},
  [619] = {.lex_state = 183, .external_lex_state = 4},
  [620] = {.lex_state = 183, .external_lex_state = 4},
  [621] = {.lex_state = 183, .external_lex_state = 4},
  [622] = {.lex_state = 183, .external_lex_state = 4},
  [623] = {.lex_state = 183, .external_lex_state = 4},
  [624] = {.lex_state = 183, .external_lex_state = 4},
  [625] = {.lex_state = 183, .external_lex_state = 4},
  [626] = {.lex_state = 183, .external_lex_state = 4},
  [627] = {.lex_state = 183, .external_lex_state = 4},
  [628] = {.lex_state = 183, .external_lex_state = 4},
  [629] = {.lex_state = 183, .external_lex_state = 4},
  [630] = {.lex_state = 183, .external_lex_state = 4},
  [631] = {.lex_state = 183, .external_lex_state = 4},
  [632] = {.lex_state = 183, .external_lex_state = 4},
  [633] = {.lex_state = 183, .external_lex_state = 4},
  [634] = {.lex_state = 183, .external_lex_state = 4},
  [635] = {.lex_state = 183, .external_lex_state = 4},
  [636] = {.lex_state = 183, .external_lex_state = 4},
  [637] = {.lex_state = 183, .external_lex_state = 4},
  [638] = {.lex_state = 183, .external_lex_state = 4},
  [639] = {.lex_state = 183, .external_lex_state = 4},
  [640] = {.lex_state = 183, .external_lex_state = 4},
  [641] = {.lex_state = 183, .external_lex_state = 4},
  [642] = {.lex_state = 183, .external_lex_state = 4},
  [643] = {.lex_state = 183, .external_lex_state = 4},
  [644] = {.lex_state = 183, .external_lex_state = 4},
  [645] = {.lex_state = 183, .external_lex_state = 4},
  [646] = {.lex_state = 183, .external_lex_state = 4},
  [647] = {.lex_state = 183, .external_lex_state = 4},
  [648] = {.lex_state = 183, .external_lex_state = 4},
  [649] = {.lex_state = 183, .external_lex_state = 4},
  [650] = {.lex_state = 183, .external_lex_state = 4},
  [651] = {.lex_state = 183, .external_lex_state = 4},
  [652] = {.lex_state = 183, .external_lex_state = 4},
  [653] = {.lex_state = 183, .external_lex_state = 4},
  [654] = {.lex_state = 183, .external_lex_state = 4},
  [655] = {.lex_state = 183, .external_lex_state = 4},
  [656] = {.lex_state = 183, .external_lex_state = 4},
  [657] = {.lex_state = 183, .external_lex_state = 4},
  [658] = {.lex_state = 183, .external_lex_state = 4},
  [659] = {.lex_state = 183, .external_lex_state = 4},
  [660] = {.lex_state = 183, .external_lex_state = 4},
  [661] = {.lex_state = 183, .external_lex_state = 4},
  [662] = {.lex_state = 183, .external_lex_state = 4},
  [663] = {.lex_state = 183, .external_lex_state = 4},
  [664] = {.lex_state = 183, .external_lex_state = 4},
  [665] = {.lex_state = 183, .external_lex_state = 4},
  [666] = {.lex_state = 183, .external_lex_state = 4},
  [667] = {.lex_state = 183, .external_lex_state = 4},
  [668] = {.lex_state = 183, .external_lex_state = 4},
  [669] = {.lex_state = 183, .external_lex_state = 4},
  [670] = {.lex_state = 183, .external_lex_state = 4},
  [671] = {.lex_state = 183, .external_lex_state = 4},
  [672] = {.lex_state = 183, .external_lex_state = 4},
  [673] = {.lex_state = 183, .external_lex_state = 4},
  [674] = {.lex_state = 183, .external_lex_state = 4},
  [675] = {.lex_state = 183, .external_lex_state = 4},
  [676] = {.lex_state = 183, .external_lex_state = 4},
  [677] = {.lex_state = 183, .external_lex_state = 4},
  [678] = {.lex_state = 183, .external_lex_state = 4},
  [679] = {.lex_state = 183, .external_lex_state = 4},
  [680] = {.lex_state = 183, .external_lex_state = 4},
  [681] = {.lex_state = 183, .external_lex_state = 4},
  [682] = {.lex_state = 183, .external_lex_state = 4},
  [683] = {.lex_state = 183, .external_lex_state = 4},
  [684] = {.lex_state = 183, .external_lex_state = 4},
  [685] = {.lex_state = 183, .external_lex_state = 4},
  [686] = {.lex_state = 183, .external_lex_state = 4},
  [687] = {.lex_state = 183, .external_lex_state = 4},
  [688] = {.lex_state = 183, .external_lex_state = 4},
  [689] = {.lex_state = 183, .external_lex_state = 4},
  [690] = {.lex_state = 183, .external_lex_state = 4},
  [691] = {.lex_state = 183, .external_lex_state = 4},
  [692] = {.lex_state = 183, .external_lex_state = 4},
  [693] = {.lex_state = 183, .external_lex_state = 4},
  [694] = {.lex_state = 183, .external_lex_state = 4},
  [695] = {.lex_state = 183, .external_lex_state = 4},
  [696] = {.lex_state = 183, .external_lex_state = 4},
  [697] = {.lex_state = 183, .external_lex_state = 4},
  [698] = {.lex_state = 183, .external_lex_state = 4},
  [699] = {.lex_state = 183, .external_lex_state = 4},
  [700] = {.lex_state = 183, .external_lex_state = 4},
  [701] = {.lex_state = 183, .external_lex_state = 4},
  [702] = {.lex_state = 183, .external_lex_state = 4},
  [703] = {.lex_state = 183, .external_lex_state = 4},
  [704] = {.lex_state = 183, .external_lex_state = 4},
  [705] = {.lex_state = 183, .external_lex_state = 4},
  [706] = {.lex_state = 183, .external_lex_state = 4},
  [707] = {.lex_state = 183, .external_lex_state = 4},
  [708] = {.lex_state = 183, .external_lex_state = 4},
  [709] = {.lex_state = 183, .external_lex_state = 4},
  [710] = {.lex_state = 183, .external_lex_state = 4},
  [711] = {.lex_state = 183, .external_lex_state = 4},
  [712] = {.lex_state = 183, .external_lex_state = 4},
  [713] = {.lex_state = 183, .external_lex_state = 4},
  [714] = {.lex_state = 183, .external_lex_state = 4},
  [715] = {.lex_state = 183, .external_lex_state = 4},
  [716] = {.lex_state = 183, .external_lex_state = 4},
  [717] = {.lex_state = 183, .external_lex_state = 4},
  [718] = {.lex_state = 183, .external_lex_state = 4},
  [719] = {.lex_state = 183, .external_lex_state = 4},
  [720] = {.lex_state = 183, .external_lex_state = 4},
  [721] = {.lex_state = 183, .external_lex_state = 4},
  [722] = {.lex_state = 183, .external_lex_state = 4},
  [723] = {.lex_state = 183, .external_lex_state = 4},
  [724] = {.lex_state = 183, .external_lex_state = 4},
  [725] = {.lex_state = 183, .external_lex_state = 4},
  [726] = {.lex_state = 183, .external_lex_state = 4},
  [727] = {.lex_state = 183, .external_lex_state = 4},
  [728] = {.lex_state = 183, .external_lex_state = 4},
  [729] = {.lex_state = 183, .external_lex_state = 4},
  [730] = {.lex_state = 183, .external_lex_state = 4},
  [731] = {.lex_state = 183, .external_lex_state = 4},
  [732] = {.lex_state = 183, .external_lex_state = 4},
  [733] = {.lex_state = 183, .external_lex_state = 4},
  [734] = {.lex_state = 183, .external_lex_state = 4},
  [735] = {.lex_state = 183, .external_lex_state = 4},
  [736] = {.lex_state = 183, .external_lex_state = 4},
  [737] = {.lex_state = 183, .external_lex_state = 4},
  [738] = {.lex_state = 183, .external_lex_state = 4},
  [739] = {.lex_state = 183, .external_lex_state = 4},
  [740] = {.lex_state = 183, .external_lex_state = 4},
  [741] = {.lex_state = 183, .external_lex_state = 4},
  [742] = {.lex_state = 183, .external_lex_state = 4},
  [743] = {.lex_state = 183, .external_lex_state = 4},
  [744] = {.lex_state = 183, .external_lex_state = 4},
  [745] = {.lex_state = 183, .external_lex_state = 4},
  [746] = {.lex_state = 183, .external_lex_state = 4},
  [747] = {.lex_state = 183, .external_lex_state = 4},
  [748] = {.lex_state = 183, .external_lex_state = 4},
  [749] = {.lex_state = 183, .external_lex_state = 4},
  [750] = {.lex_state = 183, .external_lex_state = 4},
  [751] = {.lex_state = 183, .external_lex_state = 4},
  [752] = {.lex_state = 183, .external_lex_state = 4},
  [753] = {.lex_state = 183, .external_lex_state = 4},
  [754] = {.lex_state = 183, .external_lex_state = 4},
  [755] = {.lex_state = 183, .external_lex_state = 4},
  [756] = {.lex_state = 183, .external_lex_state = 4},
  [757] = {.lex_state = 183, .external_lex_state = 4},
  [758] = {.lex_state = 183, .external_lex_state = 4},
  [759] = {.lex_state = 183, .external_lex_state = 4},
  [760] = {.lex_state = 183, .external_lex_state = 4},
  [761] = {.lex_state = 183, .external_lex_state = 4},
  [762] = {.lex_state = 183, .external_lex_state = 4},
  [763] = {.lex_state = 183, .external_lex_state = 4},
  [764] = {.lex_state = 183, .external_lex_state = 4},
  [765] = {.lex_state = 183, .external_lex_state = 4},
  [766] = {.lex_state = 183, .external_lex_state = 4},
  [767] = {.lex_state = 183, .external_lex_state = 4},
  [768] = {.lex_state = 183, .external_lex_state = 4},
  [769] = {.lex_state = 183, .external_lex_state = 4},
  [770] = {.lex_state = 183, .external_lex_state = 4},
  [771] = {.lex_state = 183, .external_lex_state = 4},
  [772] = {.lex_state = 183, .external_lex_state = 4},
  [773] = {.lex_state = 183, .external_lex_state = 4},
  [774] = {.lex_state = 183, .external_lex_state = 4},
  [775] = {.lex_state = 183, .external_lex_state = 4},
  [776] = {.lex_state = 183, .external_lex_state = 4},
  [777] = {.lex_state = 183, .external_lex_state = 4},
  [778] = {.lex_state = 183, .external_lex_state = 4},
  [779] = {.lex_state = 183, .external_lex_state = 4},
  [780] = {.lex_state = 183, .external_lex_state = 4},
  [781] = {.lex_state = 183, .external_lex_state = 4},
  [782] = {.lex_state = 183, .external_lex_state = 4},
  [783] = {.lex_state = 183, .external_lex_state = 4},
  [784] = {.lex_state = 183, .external_lex_state = 4},
  [785] = {.lex_state = 183, .external_lex_state = 4},
  [786] = {.lex_state = 183, .external_lex_state = 4},
  [787] = {.lex_state = 183, .external_lex_state = 4},
  [788] = {.lex_state = 183, .external_lex_state = 4},
  [789] = {.lex_state = 183, .external_lex_state = 4},
  [790] = {.lex_state = 183, .external_lex_state = 4},
  [791] = {.lex_state = 183, .external_lex_state = 4},
  [792] = {.lex_state = 183, .external_lex_state = 4},
  [793] = {.lex_state = 183, .external_lex_state = 4},
  [794] = {.lex_state = 183, .external_lex_state = 4},
  [795] = {.lex_state = 183, .external_lex_state = 4},
  [796] = {.lex_state = 183, .external_lex_state = 4},
  [797] = {.lex_state = 183, .external_lex_state = 4},
  [798] = {.lex_state = 183, .external_lex_state = 4},
  [799] = {.lex_state = 183, .external_lex_state = 4},
  [800] = {.lex_state = 183, .external_lex_state = 4},
  [801] = {.lex_state = 183, .external_lex_state = 4},
  [802] = {.lex_state = 183, .external_lex_state = 4},
  [803] = {.lex_state = 183, .external_lex_state = 4},
  [804] = {.lex_state = 183, .external_lex_state = 4},
  [805] = {.lex_state = 183, .external_lex_state = 4},
  [806] = {.lex_state = 183, .external_lex_state = 4},
  [807] = {.lex_state = 183, .external_lex_state = 4},
  [808] = {.lex_state = 183, .external_lex_state = 4},
  [809] = {.lex_state = 183, .external_lex_state = 4},
  [810] = {.lex_state = 183, .external_lex_state = 4},
  [811] = {.lex_state = 183, .external_lex_state = 4},
  [812] = {.lex_state = 183, .external_lex_state = 4},
  [813] = {.lex_state = 183, .external_lex_state = 4},
  [814] = {.lex_state = 183, .external_lex_state = 4},
  [815] = {.lex_state = 183, .external_lex_state = 4},
  [816] = {.lex_state = 183, .external_lex_state = 4},
  [817] = {.lex_state = 183, .external_lex_state = 4},
  [818] = {.lex_state = 183, .external_lex_state = 4},
  [819] = {.lex_state = 183, .external_lex_state = 4},
  [820] = {.lex_state = 183, .external_lex_state = 4},
  [821] = {.lex_state = 183, .external_lex_state = 4},
  [822] = {.lex_state = 183, .external_lex_state = 4},
  [823] = {.lex_state = 183, .external_lex_state = 4},
  [824] = {.lex_state = 183, .external_lex_state = 4},
  [825] = {.lex_state = 183, .external_lex_state = 4},
  [826] = {.lex_state = 183, .external_lex_state = 4},
  [827] = {.lex_state = 183, .external_lex_state = 4},
  [828] = {.lex_state = 183, .external_lex_state = 4},
  [829] = {.lex_state = 183, .external_lex_state = 4},
  [830] = {.lex_state = 183, .external_lex_state = 4},
  [831] = {.lex_state = 183, .external_lex_state = 4},
  [832] = {.lex_state = 183, .external_lex_state = 4},
  [833] = {.lex_state = 183, .external_lex_state = 4},
  [834] = {.lex_state = 183, .external_lex_state = 4},
  [835] = {.lex_state = 183, .external_lex_state = 4},
  [836] = {.lex_state = 183, .external_lex_state = 4},
  [837] = {.lex_state = 183, .external_lex_state = 4},
  [838] = {.lex_state = 183, .external_lex_state = 4},
  [839] = {.lex_state = 183, .external_lex_state = 4},
  [840] = {.lex_state = 183, .external_lex_state = 4},
  [841] = {.lex_state = 183, .external_lex_state = 4},
  [842] = {.lex_state = 183, .external_lex_state = 4},
  [843] = {.lex_state = 183, .external_lex_state = 4},
  [844] = {.lex_state = 183, .external_lex_state = 4},
  [845] = {.lex_state = 183, .external_lex_state = 4},
  [846] = {.lex_state = 183, .external_lex_state = 4},
  [847] = {.lex_state = 183, .external_lex_state = 4},
  [848] = {.lex_state = 183, .external_lex_state = 4},
  [849] = {.lex_state = 183, .external_lex_state = 4},
  [850] = {.lex_state = 183, .external_lex_state = 4},
  [851] = {.lex_state = 183, .external_lex_state = 4},
  [852] = {.lex_state = 183, .external_lex_state = 4},
  [853] = {.lex_state = 183, .external_lex_state = 4},
  [854] = {.lex_state = 183, .external_lex_state = 4},
  [855] = {.lex_state = 183, .external_lex_state = 4},
  [856] = {.lex_state = 183, .external_lex_state = 4},
  [857] = {.lex_state = 183, .external_lex_state = 4},
  [858] = {.lex_state = 183, .external_lex_state = 4},
  [859] = {.lex_state = 183, .external_lex_state = 4},
  [860] = {.lex_state = 183, .external_lex_state = 4},
  [861] = {.lex_state = 183, .external_lex_state = 4},
  [862] = {.lex_state = 183, .external_lex_state = 4},
  [863] = {.lex_state = 183, .external_lex_state = 4},
  [864] = {.lex_state = 183, .external_lex_state = 4},
  [865] = {.lex_state = 183, .external_lex_state = 4},
  [866] = {.lex_state = 183, .external_lex_state = 4},
  [867] = {.lex_state = 183, .external_lex_state = 4},
  [868] = {.lex_state = 183, .external_lex_state = 4},
  [869] = {.lex_state = 183, .external_lex_state = 4},
  [870] = {.lex_state = 183, .external_lex_state = 4},
  [871] = {.lex_state = 183, .external_lex_state = 4},
  [872] = {.lex_state = 183, .external_lex_state = 4},
  [873] = {.lex_state = 183, .external_lex_state = 4},
  [874] = {.lex_state = 183, .external_lex_state = 4},
  [875] = {.lex_state = 183, .external_lex_state = 4},
  [876] = {.lex_state = 183, .external_lex_state = 4},
  [877] = {.lex_state = 183, .external_lex_state = 4},
  [878] = {.lex_state = 183, .external_lex_state = 4},
  [879] = {.lex_state = 183, .external_lex_state = 4},
  [880] = {.lex_state = 183, .external_lex_state = 4},
  [881] = {.lex_state = 183, .external_lex_state = 4},
  [882] = {.lex_state = 183, .external_lex_state = 4},
  [883] = {.lex_state = 183, .external_lex_state = 4},
  [884] = {.lex_state = 183, .external_lex_state = 4},
  [885] = {.lex_state = 183, .external_lex_state = 4},
  [886] = {.lex_state = 183, .external_lex_state = 4},
  [887] = {.lex_state = 183, .external_lex_state = 4},
  [888] = {.lex_state = 183, .external_lex_state = 4},
  [889] = {.lex_state = 183, .external_lex_state = 4},
  [890] = {.lex_state = 183, .external_lex_state = 4},
  [891] = {.lex_state = 183, .external_lex_state = 4},
  [892] = {.lex_state = 183, .external_lex_state = 4},
  [893] = {.lex_state = 183, .external_lex_state = 4},
  [894] = {.lex_state = 183, .external_lex_state = 4},
  [895] = {.lex_state = 183, .external_lex_state = 4},
  [896] = {.lex_state = 183, .external_lex_state = 4},
  [897] = {.lex_state = 183, .external_lex_state = 4},
  [898] = {.lex_state = 183, .external_lex_state = 4},
  [899] = {.lex_state = 183, .external_lex_state = 4},
  [900] = {.lex_state = 183, .external_lex_state = 4},
  [901] = {.lex_state = 183, .external_lex_state = 4},
  [902] = {.lex_state = 183, .external_lex_state = 4},
  [903] = {.lex_state = 183, .external_lex_state = 4},
  [904] = {.lex_state = 183, .external_lex_state = 4},
  [905] = {.lex_state = 183, .external_lex_state = 4},
  [906] = {.lex_state = 183, .external_lex_state = 4},
  [907] = {.lex_state = 183, .external_lex_state = 4},
  [908] = {.lex_state = 183, .external_lex_state = 4},
  [909] = {.lex_state = 183, .external_lex_state = 4},
  [910] = {.lex_state = 183, .external_lex_state = 4},
  [911] = {.lex_state = 183, .external_lex_state = 4},
  [912] = {.lex_state = 183, .external_lex_state = 4},
  [913] = {.lex_state = 183, .external_lex_state = 4},
  [914] = {.lex_state = 183, .external_lex_state = 4},
  [915] = {.lex_state = 183, .external_lex_state = 4},
  [916] = {.lex_state = 183, .external_lex_state = 4},
  [917] = {.lex_state = 183, .external_lex_state = 4},
  [918] = {.lex_state = 183, .external_lex_state = 4},
  [919] = {.lex_state = 183, .external_lex_state = 4},
  [920] = {.lex_state = 183, .external_lex_state = 4},
  [921] = {.lex_state = 183, .external_lex_state = 4},
  [922] = {.lex_state = 183, .external_lex_state = 4},
  [923] = {.lex_state = 183, .external_lex_state = 4},
  [924] = {.lex_state = 183, .external_lex_state = 4},
  [925] = {.lex_state = 183, .external_lex_state = 4},
  [926] = {.lex_state = 183, .external_lex_state = 4},
  [927] = {.lex_state = 183, .external_lex_state = 4},
  [928] = {.lex_state = 183, .external_lex_state = 4},
  [929] = {.lex_state = 183, .external_lex_state = 4},
  [930] = {.lex_state = 186, .external_lex_state = 6},
  [931] = {.lex_state = 186, .external_lex_state = 6},
  [932] = {.lex_state = 186, .external_lex_state = 6},
  [933] = {.lex_state = 186, .external_lex_state = 6},
  [934] = {.lex_state = 186, .external_lex_state = 6},
  [935] = {.lex_state = 186, .external_lex_state = 6},
  [936] = {.lex_state = 186, .external_lex_state = 6},
  [937] = {.lex_state = 186, .external_lex_state = 6},
  [938] = {.lex_state = 186, .external_lex_state = 6},
  [939] = {.lex_state = 186, .external_lex_state = 6},
  [940] = {.lex_state = 186, .external_lex_state = 6},
  [941] = {.lex_state = 186, .external_lex_state = 6},
  [942] = {.lex_state = 186, .external_lex_state = 6},
  [943] = {.lex_state = 186, .external_lex_state = 6},
  [944] = {.lex_state = 186, .external_lex_state = 6},
  [945] = {.lex_state = 186, .external_lex_state = 6},
  [946] = {.lex_state = 186, .external_lex_state = 6},
  [947] = {.lex_state = 186, .external_lex_state = 6},
  [948] = {.lex_state = 186, .external_lex_state = 6},
  [949] = {.lex_state = 186, .external_lex_state = 6},
  [950] = {.lex_state = 186, .external_lex_state = 6},
  [951] = {.lex_state = 186, .external_lex_state = 6},
  [952] = {.lex_state = 186, .external_lex_state = 6},
  [953] = {.lex_state = 186, .external_lex_state = 6},
  [954] = {.lex_state = 186, .external_lex_state = 6},
  [955] = {.lex_state = 186, .external_lex_state = 6},
  [956] = {.lex_state = 186, .external_lex_state = 6},
  [957] = {.lex_state = 186, .external_lex_state = 6},
  [958] = {.lex_state = 186, .external_lex_state = 6},
  [959] = {.lex_state = 186, .external_lex_state = 6},
  [960] = {.lex_state = 186, .external_lex_state = 6},
  [961] = {.lex_state = 186, .external_lex_state = 6},
  [962] = {.lex_state = 186, .external_lex_state = 6},
  [963] = {.lex_state = 186, .external_lex_state = 6},
  [964] = {.lex_state = 186},
  [965] = {.lex_state = 186},
  [966] = {.lex_state = 186},
  [967] = {.lex_state = 186},
  [968] = {.lex_state = 186},
  [969] = {.lex_state = 186},
  [970] = {.lex_state = 186},
  [971] = {.lex_state = 186},
  [972] = {.lex_state = 186},
  [973] = {.lex_state = 186},
  [974] = {.lex_state = 186},
  [975] = {.lex_state = 186},
  [976] = {.lex_state = 186},
  [977] = {.lex_state = 186},
  [978] = {.lex_state = 186},
  [979] = {.lex_state = 186},
  [980] = {.lex_state = 186},
  [981] = {.lex_state = 186},
  [982] = {.lex_state = 186},
  [983] = {.lex_state = 186},
  [984] = {.lex_state = 186},
  [985] = {.lex_state = 186},
  [986] = {.lex_state = 186},
  [987] = {.lex_state = 186},
  [988] = {.lex_state = 186},
  [989] = {.lex_state = 186},
  [990] = {.lex_state = 186},
  [991] = {.lex_state = 186},
  [992] = {.lex_state = 186},
  [993] = {.lex_state = 186},
  [994] = {.lex_state = 186},
  [995] = {.lex_state = 186},
  [996] = {.lex_state = 186},
  [997] = {.lex_state = 186},
  [998] = {.lex_state = 186},
  [999] = {.lex_state = 186},
  [1000] = {.lex_state = 186},
  [1001] = {.lex_state = 186},
  [1002] = {.lex_state = 186},
  [1003] = {.lex_state = 186},
  [1004] = {.lex_state = 186},
  [1005] = {.lex_state = 186},
  [1006] = {.lex_state = 186},
  [1007] = {.lex_state = 186},
  [1008] = {.lex_state = 186},
  [1009] = {.lex_state = 187},
  [1010] = {.lex_state = 187},
  [1011] = {.lex_state = 187},
  [1012] = {.lex_state = 187},
  [1013] = {.lex_state = 187},
  [1014] = {.lex_state = 187},
  [1015] = {.lex_state = 187},
  [1016] = {.lex_state = 187},
  [1017] = {.lex_state = 187},
  [1018] = {.lex_state = 187},
  [1019] = {.lex_state = 187},
  [1020] = {.lex_state = 187},
  [1021] = {.lex_state = 187},
  [1022] = {.lex_state = 187},
  [1023] = {.lex_state = 187},
  [1024] = {.lex_state = 187},
  [1025] = {.lex_state = 187},
  [1026] = {.lex_state = 187},
  [1027] = {.lex_state = 187},
  [1028] = {.lex_state = 187},
  [1029] = {.lex_state = 187},
  [1030] = {.lex_state = 187},
  [1031] = {.lex_state = 187},
  [1032] = {.lex_state = 187},
  [1033] = {.lex_state = 187},
  [1034] = {.lex_state = 187},
  [1035] = {.lex_state = 187},
  [1036] = {.lex_state = 187},
  [1037] = {.lex_state = 187},
  [1038] = {.lex_state = 187},
  [1039] = {.lex_state = 187},
  [1040] = {.lex_state = 187},
  [1041] = {.lex_state = 187},
  [1042] = {.lex_state = 187},
  [1043] = {.lex_state = 187},
  [1044] = {.lex_state = 187},
  [1045] = {.lex_state = 187},
  [1046] = {.lex_state = 187},
  [1047] = {.lex_state = 187},
  [1048] = {.lex_state = 187},
  [1049] = {.lex_state = 187},
  [1050] = {.lex_state = 187},
  [1051] = {.lex_state = 187},
  [1052] = {.lex_state = 187},
  [1053] = {.lex_state = 188},
  [1054] = {.lex_state = 188},
  [1055] = {.lex_state = 188},
  [1056] = {.lex_state = 188},
  [1057] = {.lex_state = 188},
  [1058] = {.lex_state = 188},
  [1059] = {.lex_state = 188},
  [1060] = {.lex_state = 188},
  [1061] = {.lex_state = 188},
  [1062] = {.lex_state = 188},
  [1063] = {.lex_state = 188},
  [1064] = {.lex_state = 188},
  [1065] = {.lex_state = 188},
  [1066] = {.lex_state = 188},
  [1067] = {.lex_state = 188},
  [1068] = {.lex_state = 188},
  [1069] = {.lex_state = 188},
  [1070] = {.lex_state = 188},
  [1071] = {.lex_state = 188},
  [1072] = {.lex_state = 213},
  [1073] = {.lex_state = 213},
  [1074] = {.lex_state = 213},
  [1075] = {.lex_state = 213},
  [1076] = {.lex_state = 213},
  [1077] = {.lex_state = 213},
  [1078] = {.lex_state = 213},
  [1079] = {.lex_state = 213},
  [1080] = {.lex_state = 213},
  [1081] = {.lex_state = 213},
  [1082] = {.lex_state = 213},
  [1083] = {.lex_state = 213},
  [1084] = {.lex_state = 213},
  [1085] = {.lex_state = 213},
  [1086] = {.lex_state = 213},
  [1087] = {.lex_state = 213},
  [1088] = {.lex_state = 213},
  [1089] = {.lex_state = 213},
  [1090] = {.lex_state = 213},
  [1091] = {.lex_state = 213},
  [1092] = {.lex_state = 213},
  [1093] = {.lex_state = 213},
  [1094] = {.lex_state = 213},
  [1095] = {.lex_state = 213},
  [1096] = {.lex_state = 213},
  [1097] = {.lex_state = 213},
  [1098] = {.lex_state = 213},
  [1099] = {.lex_state = 213},
  [1100] = {.lex_state = 213},
  [1101] = {.lex_state = 213},
  [1102] = {.lex_state = 213},
  [1103] = {.lex_state = 213},
  [1104] = {.lex_state = 213},
  [1105] = {.lex_state = 213, .external_lex_state = 7},
  [1106] = {.lex_state = 213},
  [1107] = {.lex_state = 213},
  [1108] = {.lex_state = 213, .external_lex_state = 7},
  [1109] = {.lex_state = 213, .external_lex_state = 7},
  [1110] = {.lex_state = 213},
  [1111] = {.lex_state = 213, .external_lex_state = 7},
  [1112] = {.lex_state = 213, .external_lex_state = 7},
  [1113] = {.lex_state = 213, .external_lex_state = 7},
  [1114] = {.lex_state = 213, .external_lex_state = 7},
  [1115] = {.lex_state = 213, .external_lex_state = 7},
  [1116] = {.lex_state = 213, .external_lex_state = 7},
  [1117] = {.lex_state = 213, .external_lex_state = 7},
  [1118] = {.lex_state = 213, .external_lex_state = 7},
  [1119] = {.lex_state = 213, .external_lex_state = 7},
  [1120] = {.lex_state = 213},
  [1121] = {.lex_state = 213, .external_lex_state = 7},
  [1122] = {.lex_state = 213, .external_lex_state = 7},
  [1123] = {.lex_state = 213, .external_lex_state = 7},
  [1124] = {.lex_state = 213, .external_lex_state = 7},
  [1125] = {.lex_state = 213, .external_lex_state = 7},
  [1126] = {.lex_state = 213, .external_lex_state = 7},
  [1127] = {.lex_state = 213, .external_lex_state = 7},
  [1128] = {.lex_state = 213, .external_lex_state = 7},
  [1129] = {.lex_state = 213, .external_lex_state = 7},
  [1130] = {.lex_state = 213},
  [1131] = {.lex_state = 213, .external_lex_state = 7},
  [1132] = {.lex_state = 213, .external_lex_state = 7},
  [1133] = {.lex_state = 213, .external_lex_state = 7},
  [1134] = {.lex_state = 213, .external_lex_state = 7},
  [1135] = {.lex_state = 213, .external_lex_state = 7},
  [1136] = {.lex_state = 213, .external_lex_state = 7},
  [1137] = {.lex_state = 213, .external_lex_state = 7},
  [1138] = {.lex_state = 213, .external_lex_state = 7},
  [1139] = {.lex_state = 213, .external_lex_state = 7},
  [1140] = {.lex_state = 213, .external_lex_state = 7},
  [1141] = {.lex_state = 213, .external_lex_state = 7},
  [1142] = {.lex_state = 213},
  [1143] = {.lex_state = 213},
  [1144] = {.lex_state = 213},
  [1145] = {.lex_state = 213, .external_lex_state = 7},
  [1146] = {.lex_state = 213, .external_lex_state = 7},
  [1147] = {.lex_state = 213, .external_lex_state = 7},
  [1148] = {.lex_state = 213, .external_lex_state = 7},
  [1149] = {.lex_state = 213, .external_lex_state = 7},
  [1150] = {.lex_state = 213, .external_lex_state = 7},
  [1151] = {.lex_state = 213, .external_lex_state = 7},
  [1152] = {.lex_state = 213, .external_lex_state = 7},
  [1153] = {.lex_state = 213, .external_lex_state = 7},
  [1154] = {.lex_state = 189, .external_lex_state = 8},
  [1155] = {.lex_state = 190},
  [1156] = {.lex_state = 190},
  [1157] = {.lex_state = 189, .external_lex_state = 8},
  [1158] = {.lex_state = 189, .external_lex_state = 8},
  [1159] = {.lex_state = 189, .external_lex_state = 8},
  [1160] = {.lex_state = 189, .external_lex_state = 8},
  [1161] = {.lex_state = 189, .external_lex_state = 8},
  [1162] = {.lex_state = 189, .external_lex_state = 8},
  [1163] = {.lex_state = 189, .external_lex_state = 8},
  [1164] = {.lex_state = 190},
  [1165] = {.lex_state = 190},
  [1166] = {.lex_state = 190},
  [1167] = {.lex_state = 190},
  [1168] = {.lex_state = 190},
  [1169] = {.lex_state = 189, .external_lex_state = 8},
  [1170] = {.lex_state = 189, .external_lex_state = 8},
  [1171] = {.lex_state = 189, .external_lex_state = 8},
  [1172] = {.lex_state = 189, .external_lex_state = 8},
  [1173] = {.lex_state = 190},
  [1174] = {.lex_state = 189, .external_lex_state = 8},
  [1175] = {.lex_state = 189, .external_lex_state = 8},
  [1176] = {.lex_state = 189, .external_lex_state = 8},
  [1177] = {.lex_state = 189, .external_lex_state = 8},
  [1178] = {.lex_state = 189, .external_lex_state = 8},
  [1179] = {.lex_state = 190},
  [1180] = {.lex_state = 189, .external_lex_state = 8},
  [1181] = {.lex_state = 190},
  [1182] = {.lex_state = 190},
  [1183] = {.lex_state = 190},
  [1184] = {.lex_state = 190},
  [1185] = {.lex_state = 190},
  [1186] = {.lex_state = 190},
  [1187] = {.lex_state = 190},
  [1188] = {.lex_state = 190},
  [1189] = {.lex_state = 190},
  [1190] = {.lex_state = 190},
  [1191] = {.lex_state = 189, .external_lex_state = 8},
  [1192] = {.lex_state = 189, .external_lex_state = 8},
  [1193] = {.lex_state = 189, .external_lex_state = 8},
  [1194] = {.lex_state = 190},
  [1195] = {.lex_state = 190},
  [1196] = {.lex_state = 189, .external_lex_state = 8},
  [1197] = {.lex_state = 189, .external_lex_state = 8},
  [1198] = {.lex_state = 190},
  [1199] = {.lex_state = 189, .external_lex_state = 8},
  [1200] = {.lex_state = 190},
  [1201] = {.lex_state = 189, .external_lex_state = 8},
  [1202] = {.lex_state = 189, .external_lex_state = 8},
  [1203] = {.lex_state = 190},
  [1204] = {.lex_state = 190},
  [1205] = {.lex_state = 190},
  [1206] = {.lex_state = 190},
  [1207] = {.lex_state = 190},
  [1208] = {.lex_state = 189, .external_lex_state = 8},
  [1209] = {.lex_state = 190},
  [1210] = {.lex_state = 190},
  [1211] = {.lex_state = 189, .external_lex_state = 8},
  [1212] = {.lex_state = 189, .external_lex_state = 8},
  [1213] = {.lex_state = 189, .external_lex_state = 8},
  [1214] = {.lex_state = 189, .external_lex_state = 8},
  [1215] = {.lex_state = 192, .external_lex_state = 8},
  [1216] = {.lex_state = 190, .external_lex_state = 8},
  [1217] = {.lex_state = 190, .external_lex_state = 8},
  [1218] = {.lex_state = 190, .external_lex_state = 8},
  [1219] = {.lex_state = 190, .external_lex_state = 8},
  [1220] = {.lex_state = 190, .external_lex_state = 8},
  [1221] = {.lex_state = 190, .external_lex_state = 8},
  [1222] = {.lex_state = 194},
  [1223] = {.lex_state = 190, .external_lex_state = 8},
  [1224] = {.lex_state = 194},
  [1225] = {.lex_state = 194},
  [1226] = {.lex_state = 190, .external_lex_state = 8},
  [1227] = {.lex_state = 190, .external_lex_state = 8},
  [1228] = {.lex_state = 190, .external_lex_state = 8},
  [1229] = {.lex_state = 190, .external_lex_state = 8},
  [1230] = {.lex_state = 190, .external_lex_state = 8},
  [1231] = {.lex_state = 190, .external_lex_state = 8},
  [1232] = {.lex_state = 190, .external_lex_state = 8},
  [1233] = {.lex_state = 190, .external_lex_state = 8},
  [1234] = {.lex_state = 190, .external_lex_state = 8},
  [1235] = {.lex_state = 190, .external_lex_state = 8},
  [1236] = {.lex_state = 190, .external_lex_state = 8},
  [1237] = {.lex_state = 194},
  [1238] = {.lex_state = 190, .external_lex_state = 8},
  [1239] = {.lex_state = 194},
  [1240] = {.lex_state = 190, .external_lex_state = 8},
  [1241] = {.lex_state = 194},
  [1242] = {.lex_state = 190, .external_lex_state = 8},
  [1243] = {.lex_state = 190, .external_lex_state = 8},
  [1244] = {.lex_state = 190, .external_lex_state = 8},
  [1245] = {.lex_state = 190, .external_lex_state = 8},
  [1246] = {.lex_state = 190, .external_lex_state = 8},
  [1247] = {.lex_state = 190, .external_lex_state = 8},
  [1248] = {.lex_state = 190, .external_lex_state = 8},
  [1249] = {.lex_state = 190, .external_lex_state = 8},
  [1250] = {.lex_state = 194},
  [1251] = {.lex_state = 194},
  [1252] = {.lex_state = 194},
  [1253] = {.lex_state = 194},
  [1254] = {.lex_state = 190, .external_lex_state = 8},
  [1255] = {.lex_state = 194},
  [1256] = {.lex_state = 190, .external_lex_state = 8},
  [1257] = {.lex_state = 194},
  [1258] = {.lex_state = 190, .external_lex_state = 8},
  [1259] = {.lex_state = 190, .external_lex_state = 8},
  [1260] = {.lex_state = 194},
  [1261] = {.lex_state = 194},
  [1262] = {.lex_state = 190, .external_lex_state = 8},
  [1263] = {.lex_state = 194},
  [1264] = {.lex_state = 194},
  [1265] = {.lex_state = 194},
  [1266] = {.lex_state = 194},
  [1267] = {.lex_state = 194},
  [1268] = {.lex_state = 194},
  [1269] = {.lex_state = 194},
  [1270] = {.lex_state = 194},
  [1271] = {.lex_state = 194},
  [1272] = {.lex_state = 194},
  [1273] = {.lex_state = 194},
  [1274] = {.lex_state = 194},
  [1275] = {.lex_state = 194},
  [1276] = {.lex_state = 194},
  [1277] = {.lex_state = 194},
  [1278] = {.lex_state = 194},
  [1279] = {.lex_state = 194},
  [1280] = {.lex_state = 194},
  [1281] = {.lex_state = 194},
  [1282] = {.lex_state = 194},
  [1283] = {.lex_state = 194},
  [1284] = {.lex_state = 194},
  [1285] = {.lex_state = 194},
  [1286] = {.lex_state = 194},
  [1287] = {.lex_state = 194},
  [1288] = {.lex_state = 194},
  [1289] = {.lex_state = 194},
  [1290] = {.lex_state = 194},
  [1291] = {.lex_state = 194},
  [1292] = {.lex_state = 194},
  [1293] = {.lex_state = 194},
  [1294] = {.lex_state = 189},
  [1295] = {.lex_state = 189},
  [1296] = {.lex_state = 190, .external_lex_state = 7},
  [1297] = {.lex_state = 195},
  [1298] = {.lex_state = 190, .external_lex_state = 7},
  [1299] = {.lex_state = 195},
  [1300] = {.lex_state = 190, .external_lex_state = 7},
  [1301] = {.lex_state = 195},
  [1302] = {.lex_state = 189},
  [1303] = {.lex_state = 189},
  [1304] = {.lex_state = 195},
  [1305] = {.lex_state = 189},
  [1306] = {.lex_state = 189},
  [1307] = {.lex_state = 190, .external_lex_state = 7},
  [1308] = {.lex_state = 189},
  [1309] = {.lex_state = 189},
  [1310] = {.lex_state = 189},
  [1311] = {.lex_state = 189},
  [1312] = {.lex_state = 195},
  [1313] = {.lex_state = 195},
  [1314] = {.lex_state = 189},
  [1315] = {.lex_state = 189},
  [1316] = {.lex_state = 189},
  [1317] = {.lex_state = 190, .external_lex_state = 7},
  [1318] = {.lex_state = 189},
  [1319] = {.lex_state = 195},
  [1320] = {.lex_state = 189},
  [1321] = {.lex_state = 189},
  [1322] = {.lex_state = 189},
  [1323] = {.lex_state = 189},
  [1324] = {.lex_state = 189},
  [1325] = {.lex_state = 189},
  [1326] = {.lex_state = 190, .external_lex_state = 7},
  [1327] = {.lex_state = 195},
  [1328] = {.lex_state = 195},
  [1329] = {.lex_state = 190, .external_lex_state = 8},
  [1330] = {.lex_state = 190, .external_lex_state = 7},
  [1331] = {.lex_state = 189},
  [1332] = {.lex_state = 189},
  [1333] = {.lex_state = 190, .external_lex_state = 7},
  [1334] = {.lex_state = 190, .external_lex_state = 7},
  [1335] = {.lex_state = 190, .external_lex_state = 7},
  [1336] = {.lex_state = 195},
  [1337] = {.lex_state = 190, .external_lex_state = 7},
  [1338] = {.lex_state = 189},
  [1339] = {.lex_state = 190, .external_lex_state = 7},
  [1340] = {.lex_state = 190, .external_lex_state = 7},
  [1341] = {.lex_state = 190, .external_lex_state = 7},
  [1342] = {.lex_state = 190, .external_lex_state = 7},
  [1343] = {.lex_state = 189},
  [1344] = {.lex_state = 190, .external_lex_state = 8},
  [1345] = {.lex_state = 189},
  [1346] = {.lex_state = 190, .external_lex_state = 7},
  [1347] = {.lex_state = 189},
  [1348] = {.lex_state = 190, .external_lex_state = 7},
  [1349] = {.lex_state = 190, .external_lex_state = 7},
  [1350] = {.lex_state = 190, .external_lex_state = 7},
  [1351] = {.lex_state = 195},
  [1352] = {.lex_state = 195},
  [1353] = {.lex_state = 189},
  [1354] = {.lex_state = 190, .external_lex_state = 7},
  [1355] = {.lex_state = 189},
  [1356] = {.lex_state = 189},
  [1357] = {.lex_state = 190, .external_lex_state = 7},
  [1358] = {.lex_state = 195},
  [1359] = {.lex_state = 190, .external_lex_state = 7},
  [1360] = {.lex_state = 190, .external_lex_state = 7},
  [1361] = {.lex_state = 190, .external_lex_state = 7},
  [1362] = {.lex_state = 195},
  [1363] = {.lex_state = 190, .external_lex_state = 7},
  [1364] = {.lex_state = 190, .external_lex_state = 7},
  [1365] = {.lex_state = 195},
  [1366] = {.lex_state = 190, .external_lex_state = 7},
  [1367] = {.lex_state = 190, .external_lex_state = 7},
  [1368] = {.lex_state = 189},
  [1369] = {.lex_state = 190, .external_lex_state = 7},
  [1370] = {.lex_state = 190, .external_lex_state = 7},
  [1371] = {.lex_state = 197},
  [1372] = {.lex_state = 189},
  [1373] = {.lex_state = 189},
  [1374] = {.lex_state = 197},
  [1375] = {.lex_state = 195},
  [1376] = {.lex_state = 189},
  [1377] = {.lex_state = 189},
  [1378] = {.lex_state = 189},
  [1379] = {.lex_state = 197},
  [1380] = {.lex_state = 214},
  [1381] = {.lex_state = 214},
  [1382] = {.lex_state = 197},
  [1383] = {.lex_state = 189},
  [1384] = {.lex_state = 189},
  [1385] = {.lex_state = 197},
  [1386] = {.lex_state = 214},
  [1387] = {.lex_state = 195},
  [1388] = {.lex_state = 197},
  [1389] = {.lex_state = 197},
  [1390] = {.lex_state = 190, .external_lex_state = 7},
  [1391] = {.lex_state = 197},
  [1392] = {.lex_state = 214},
  [1393] = {.lex_state = 214},
  [1394] = {.lex_state = 214},
  [1395] = {.lex_state = 197},
  [1396] = {.lex_state = 214},
  [1397] = {.lex_state = 214},
  [1398] = {.lex_state = 197},
  [1399] = {.lex_state = 197},
  [1400] = {.lex_state = 197},
  [1401] = {.lex_state = 214},
  [1402] = {.lex_state = 197},
  [1403] = {.lex_state = 197},
  [1404] = {.lex_state = 197},
  [1405] = {.lex_state = 214},
  [1406] = {.lex_state = 214},
  [1407] = {.lex_state = 214},
  [1408] = {.lex_state = 197},
  [1409] = {.lex_state = 197},
  [1410] = {.lex_state = 214},
  [1411] = {.lex_state = 214},
  [1412] = {.lex_state = 214},
  [1413] = {.lex_state = 214},
  [1414] = {.lex_state = 197},
  [1415] = {.lex_state = 189},
  [1416] = {.lex_state = 197},
  [1417] = {.lex_state = 189},
  [1418] = {.lex_state = 197},
  [1419] = {.lex_state = 197},
  [1420] = {.lex_state = 197},
  [1421] = {.lex_state = 197},
  [1422] = {.lex_state = 189},
  [1423] = {.lex_state = 189},
  [1424] = {.lex_state = 197},
  [1425] = {.lex_state = 214},
  [1426] = {.lex_state = 214},
  [1427] = {.lex_state = 214},
  [1428] = {.lex_state = 195},
  [1429] = {.lex_state = 195},
  [1430] = {.lex_state = 195},
  [1431] = {.lex_state = 214},
  [1432] = {.lex_state = 214},
  [1433] = {.lex_state = 189},
  [1434] = {.lex_state = 195},
  [1435] = {.lex_state = 214},
  [1436] = {.lex_state = 214},
  [1437] = {.lex_state = 197},
  [1438] = {.lex_state = 214},
  [1439] = {.lex_state = 214},
  [1440] = {.lex_state = 214},
  [1441] = {.lex_state = 214},
  [1442] = {.lex_state = 197},
  [1443] = {.lex_state = 189},
  [1444] = {.lex_state = 197},
  [1445] = {.lex_state = 195},
  [1446] = {.lex_state = 197},
  [1447] = {.lex_state = 214},
  [1448] = {.lex_state = 197},
  [1449] = {.lex_state = 197},
  [1450] = {.lex_state = 214},
  [1451] = {.lex_state = 195},
  [1452] = {.lex_state = 189},
  [1453] = {.lex_state = 214},
  [1454] = {.lex_state = 189},
  [1455] = {.lex_state = 190, .external_lex_state = 9},
  [1456] = {.lex_state = 190, .external_lex_state = 9},
  [1457] = {.lex_state = 190, .external_lex_state = 10},
  [1458] = {.lex_state = 190, .external_lex_state = 10},
  [1459] = {.lex_state = 190, .external_lex_state = 10},
  [1460] = {.lex_state = 190},
  [1461] = {.lex_state = 190, .external_lex_state = 9},
  [1462] = {.lex_state = 190, .external_lex_state = 9},
  [1463] = {.lex_state = 190, .external_lex_state = 9},
  [1464] = {.lex_state = 190, .external_lex_state = 9},
  [1465] = {.lex_state = 190, .external_lex_state = 9},
  [1466] = {.lex_state = 190},
  [1467] = {.lex_state = 190},
  [1468] = {.lex_state = 190},
  [1469] = {.lex_state = 190, .external_lex_state = 9},
  [1470] = {.lex_state = 190},
  [1471] = {.lex_state = 190, .external_lex_state = 7},
  [1472] = {.lex_state = 190},
  [1473] = {.lex_state = 190},
  [1474] = {.lex_state = 190},
  [1475] = {.lex_state = 190, .external_lex_state = 9},
  [1476] = {.lex_state = 190},
  [1477] = {.lex_state = 190, .external_lex_state = 9},
  [1478] = {.lex_state = 190, .external_lex_state = 9},
  [1479] = {.lex_state = 190, .external_lex_state = 9},
  [1480] = {.lex_state = 190, .external_lex_state = 10},
  [1481] = {.lex_state = 190, .external_lex_state = 9},
  [1482] = {.lex_state = 190, .external_lex_state = 9},
  [1483] = {.lex_state = 190, .external_lex_state = 9},
  [1484] = {.lex_state = 190},
  [1485] = {.lex_state = 190, .external_lex_state = 10},
  [1486] = {.lex_state = 190, .external_lex_state = 10},
  [1487] = {.lex_state = 190, .external_lex_state = 9},
  [1488] = {.lex_state = 190, .external_lex_state = 9},
  [1489] = {.lex_state = 190, .external_lex_state = 9},
  [1490] = {.lex_state = 190, .external_lex_state = 9},
  [1491] = {.lex_state = 190, .external_lex_state = 9},
  [1492] = {.lex_state = 190, .external_lex_state = 10},
  [1493] = {.lex_state = 190},
  [1494] = {.lex_state = 190, .external_lex_state = 9},
  [1495] = {.lex_state = 190},
  [1496] = {.lex_state = 190, .external_lex_state = 9},
  [1497] = {.lex_state = 190, .external_lex_state = 10},
  [1498] = {.lex_state = 190, .external_lex_state = 9},
  [1499] = {.lex_state = 190, .external_lex_state = 10},
  [1500] = {.lex_state = 190, .external_lex_state = 10},
  [1501] = {.lex_state = 190},
  [1502] = {.lex_state = 190, .external_lex_state = 10},
  [1503] = {.lex_state = 190, .external_lex_state = 10},
  [1504] = {.lex_state = 190},
  [1505] = {.lex_state = 190, .external_lex_state = 10},
  [1506] = {.lex_state = 190, .external_lex_state = 10},
  [1507] = {.lex_state = 190, .external_lex_state = 10},
  [1508] = {.lex_state = 190, .external_lex_state = 10},
  [1509] = {.lex_state = 190, .external_lex_state = 9},
  [1510] = {.lex_state = 190, .external_lex_state = 10},
  [1511] = {.lex_state = 190, .external_lex_state = 9},
  [1512] = {.lex_state = 190, .external_lex_state = 9},
  [1513] = {.lex_state = 190, .external_lex_state = 9},
  [1514] = {.lex_state = 190, .external_lex_state = 10},
  [1515] = {.lex_state = 190},
  [1516] = {.lex_state = 190, .external_lex_state = 10},
  [1517] = {.lex_state = 190},
  [1518] = {.lex_state = 190, .external_lex_state = 10},
  [1519] = {.lex_state = 190},
  [1520] = {.lex_state = 190, .external_lex_state = 9},
  [1521] = {.lex_state = 190, .external_lex_state = 10},
  [1522] = {.lex_state = 190, .external_lex_state = 9},
  [1523] = {.lex_state = 190, .external_lex_state = 10},
  [1524] = {.lex_state = 190, .external_lex_state = 10},
  [1525] = {.lex_state = 190, .external_lex_state = 10},
  [1526] = {.lex_state = 190, .external_lex_state = 10},
  [1527] = {.lex_state = 190, .external_lex_state = 10},
  [1528] = {.lex_state = 190, .external_lex_state = 10},
  [1529] = {.lex_state = 190, .external_lex_state = 9},
  [1530] = {.lex_state = 190, .external_lex_state = 10},
  [1531] = {.lex_state = 190, .external_lex_state = 10},
  [1532] = {.lex_state = 190, .external_lex_state = 10},
  [1533] = {.lex_state = 190},
  [1534] = {.lex_state = 190},
  [1535] = {.lex_state = 190},
  [1536] = {.lex_state = 190},
  [1537] = {.lex_state = 190},
  [1538] = {.lex_state = 190},
  [1539] = {.lex_state = 190},
  [1540] = {.lex_state = 190},
  [1541] = {.lex_state = 190},
  [1542] = {.lex_state = 190},
  [1543] = {.lex_state = 189},
  [1544] = {.lex_state = 190},
  [1545] = {.lex_state = 190},
  [1546] = {.lex_state = 190},
  [1547] = {.lex_state = 190},
  [1548] = {.lex_state = 190},
  [1549] = {.lex_state = 190},
  [1550] = {.lex_state = 190},
  [1551] = {.lex_state = 190},
  [1552] = {.lex_state = 190},
  [1553] = {.lex_state = 190},
  [1554] = {.lex_state = 190},
  [1555] = {.lex_state = 190},
  [1556] = {.lex_state = 189},
  [1557] = {.lex_state = 190},
  [1558] = {.lex_state = 190},
  [1559] = {.lex_state = 189},
  [1560] = {.lex_state = 190},
  [1561] = {.lex_state = 190},
  [1562] = {.lex_state = 189},
  [1563] = {.lex_state = 190},
  [1564] = {.lex_state = 190},
  [1565] = {.lex_state = 190},
  [1566] = {.lex_state = 190},
  [1567] = {.lex_state = 190},
  [1568] = {.lex_state = 190},
  [1569] = {.lex_state = 190},
  [1570] = {.lex_state = 190},
  [1571] = {.lex_state = 189},
  [1572] = {.lex_state = 190},
  [1573] = {.lex_state = 189},
  [1574] = {.lex_state = 190},
  [1575] = {.lex_state = 190},
  [1576] = {.lex_state = 190},
  [1577] = {.lex_state = 190},
  [1578] = {.lex_state = 190},
  [1579] = {.lex_state = 189},
  [1580] = {.lex_state = 190},
  [1581] = {.lex_state = 189},
  [1582] = {.lex_state = 190},
  [1583] = {.lex_state = 190},
  [1584] = {.lex_state = 189},
  [1585] = {.lex_state = 190},
  [1586] = {.lex_state = 214},
  [1587] = {.lex_state = 189},
  [1588] = {.lex_state = 190},
  [1589] = {.lex_state = 190},
  [1590] = {.lex_state = 189},
  [1591] = {.lex_state = 190},
  [1592] = {.lex_state = 190},
  [1593] = {.lex_state = 190},
  [1594] = {.lex_state = 190},
  [1595] = {.lex_state = 190},
  [1596] = {.lex_state = 190, .external_lex_state = 7},
  [1597] = {.lex_state = 189},
  [1598] = {.lex_state = 190},
  [1599] = {.lex_state = 197},
  [1600] = {.lex_state = 190},
  [1601] = {.lex_state = 189},
  [1602] = {.lex_state = 190},
  [1603] = {.lex_state = 197},
  [1604] = {.lex_state = 189},
  [1605] = {.lex_state = 190},
  [1606] = {.lex_state = 190},
  [1607] = {.lex_state = 190},
  [1608] = {.lex_state = 190},
  [1609] = {.lex_state = 190},
  [1610] = {.lex_state = 190},
  [1611] = {.lex_state = 190},
  [1612] = {.lex_state = 190},
  [1613] = {.lex_state = 190},
  [1614] = {.lex_state = 190},
  [1615] = {.lex_state = 190, .external_lex_state = 7},
  [1616] = {.lex_state = 190},
  [1617] = {.lex_state = 190, .external_lex_state = 7},
  [1618] = {.lex_state = 190},
  [1619] = {.lex_state = 190},
  [1620] = {.lex_state = 190, .external_lex_state = 10},
  [1621] = {.lex_state = 190},
  [1622] = {.lex_state = 190},
  [1623] = {.lex_state = 190, .external_lex_state = 9},
  [1624] = {.lex_state = 190, .external_lex_state = 7},
  [1625] = {.lex_state = 190},
  [1626] = {.lex_state = 190},
  [1627] = {.lex_state = 190, .external_lex_state = 7},
  [1628] = {.lex_state = 190, .external_lex_state = 7},
  [1629] = {.lex_state = 190},
  [1630] = {.lex_state = 190},
  [1631] = {.lex_state = 190},
  [1632] = {.lex_state = 190},
  [1633] = {.lex_state = 190, .external_lex_state = 7},
  [1634] = {.lex_state = 190},
  [1635] = {.lex_state = 190},
  [1636] = {.lex_state = 190},
  [1637] = {.lex_state = 190},
  [1638] = {.lex_state = 190},
  [1639] = {.lex_state = 190},
  [1640] = {.lex_state = 190},
  [1641] = {.lex_state = 190},
  [1642] = {.lex_state = 190},
  [1643] = {.lex_state = 190},
  [1644] = {.lex_state = 190},
  [1645] = {.lex_state = 190},
  [1646] = {.lex_state = 190},
  [1647] = {.lex_state = 190},
  [1648] = {.lex_state = 190},
  [1649] = {.lex_state = 190},
  [1650] = {.lex_state = 190},
  [1651] = {.lex_state = 190},
  [1652] = {.lex_state = 190},
  [1653] = {.lex_state = 190},
  [1654] = {.lex_state = 190},
  [1655] = {.lex_state = 190},
  [1656] = {.lex_state = 190},
  [1657] = {.lex_state = 190},
  [1658] = {.lex_state = 190},
  [1659] = {.lex_state = 190},
  [1660] = {.lex_state = 190},
  [1661] = {.lex_state = 190},
  [1662] = {.lex_state = 190},
  [1663] = {.lex_state = 190},
  [1664] = {.lex_state = 190},
  [1665] = {.lex_state = 190},
  [1666] = {.lex_state = 190},
  [1667] = {.lex_state = 190},
  [1668] = {.lex_state = 190},
  [1669] = {.lex_state = 190},
  [1670] = {.lex_state = 190},
  [1671] = {.lex_state = 190},
  [1672] = {.lex_state = 190},
  [1673] = {.lex_state = 190},
  [1674] = {.lex_state = 190},
  [1675] = {.lex_state = 190},
  [1676] = {.lex_state = 190},
  [1677] = {.lex_state = 190},
  [1678] = {.lex_state = 190},
  [1679] = {.lex_state = 190},
  [1680] = {.lex_state = 190},
  [1681] = {.lex_state = 190},
  [1682] = {.lex_state = 190},
  [1683] = {.lex_state = 190},
  [1684] = {.lex_state = 190},
  [1685] = {.lex_state = 190},
  [1686] = {.lex_state = 190},
  [1687] = {.lex_state = 190},
  [1688] = {.lex_state = 190},
  [1689] = {.lex_state = 190},
  [1690] = {.lex_state = 190},
  [1691] = {.lex_state = 190},
  [1692] = {.lex_state = 190},
  [1693] = {.lex_state = 190},
  [1694] = {.lex_state = 190},
  [1695] = {.lex_state = 190},
  [1696] = {.lex_state = 190},
  [1697] = {.lex_state = 190},
  [1698] = {.lex_state = 190},
  [1699] = {.lex_state = 190},
  [1700] = {.lex_state = 190},
  [1701] = {.lex_state = 190},
  [1702] = {.lex_state = 190},
  [1703] = {.lex_state = 190},
  [1704] = {.lex_state = 190},
  [1705] = {.lex_state = 190},
  [1706] = {.lex_state = 190},
  [1707] = {.lex_state = 190},
  [1708] = {.lex_state = 190},
  [1709] = {.lex_state = 190},
  [1710] = {.lex_state = 190},
  [1711] = {.lex_state = 190},
  [1712] = {.lex_state = 190},
  [1713] = {.lex_state = 190},
  [1714] = {.lex_state = 190},
  [1715] = {.lex_state = 190},
  [1716] = {.lex_state = 190},
  [1717] = {.lex_state = 190},
  [1718] = {.lex_state = 190},
  [1719] = {.lex_state = 190},
  [1720] = {.lex_state = 190},
  [1721] = {.lex_state = 190, .external_lex_state = 7},
  [1722] = {.lex_state = 190},
  [1723] = {.lex_state = 190},
  [1724] = {.lex_state = 190},
  [1725] = {.lex_state = 190},
  [1726] = {.lex_state = 190},
  [1727] = {.lex_state = 190},
  [1728] = {.lex_state = 190},
  [1729] = {.lex_state = 190},
  [1730] = {.lex_state = 190},
  [1731] = {.lex_state = 190},
  [1732] = {.lex_state = 190},
  [1733] = {.lex_state = 190},
  [1734] = {.lex_state = 190},
  [1735] = {.lex_state = 190},
  [1736] = {.lex_state = 190},
  [1737] = {.lex_state = 190},
  [1738] = {.lex_state = 190},
  [1739] = {.lex_state = 190},
  [1740] = {.lex_state = 190},
  [1741] = {.lex_state = 190},
  [1742] = {.lex_state = 190},
  [1743] = {.lex_state = 190},
  [1744] = {.lex_state = 190},
  [1745] = {.lex_state = 190},
  [1746] = {.lex_state = 190},
  [1747] = {.lex_state = 190},
  [1748] = {.lex_state = 190},
  [1749] = {.lex_state = 190},
  [1750] = {.lex_state = 190},
  [1751] = {.lex_state = 190},
  [1752] = {.lex_state = 190},
  [1753] = {.lex_state = 190},
  [1754] = {.lex_state = 190},
  [1755] = {.lex_state = 190},
  [1756] = {.lex_state = 190},
  [1757] = {.lex_state = 190},
  [1758] = {.lex_state = 190},
  [1759] = {.lex_state = 190},
  [1760] = {.lex_state = 190},
  [1761] = {.lex_state = 190},
  [1762] = {.lex_state = 190},
  [1763] = {.lex_state = 190},
  [1764] = {.lex_state = 190},
  [1765] = {.lex_state = 190},
  [1766] = {.lex_state = 190},
  [1767] = {.lex_state = 190},
  [1768] = {.lex_state = 190},
  [1769] = {.lex_state = 190},
  [1770] = {.lex_state = 190},
  [1771] = {.lex_state = 190},
  [1772] = {.lex_state = 190},
  [1773] = {.lex_state = 190},
  [1774] = {.lex_state = 190},
  [1775] = {.lex_state = 190},
  [1776] = {.lex_state = 190},
  [1777] = {.lex_state = 190},
  [1778] = {.lex_state = 190},
  [1779] = {.lex_state = 190},
  [1780] = {.lex_state = 190},
  [1781] = {.lex_state = 190},
  [1782] = {.lex_state = 190},
  [1783] = {.lex_state = 190},
  [1784] = {.lex_state = 190},
  [1785] = {.lex_state = 190},
  [1786] = {.lex_state = 190},
  [1787] = {.lex_state = 190},
  [1788] = {.lex_state = 190},
  [1789] = {.lex_state = 190},
  [1790] = {.lex_state = 190},
  [1791] = {.lex_state = 190},
  [1792] = {.lex_state = 190},
  [1793] = {.lex_state = 190},
  [1794] = {.lex_state = 190},
  [1795] = {.lex_state = 190},
  [1796] = {.lex_state = 190},
  [1797] = {.lex_state = 190},
  [1798] = {.lex_state = 190},
  [1799] = {.lex_state = 190},
  [1800] = {.lex_state = 190},
  [1801] = {.lex_state = 190},
  [1802] = {.lex_state = 190},
  [1803] = {.lex_state = 190},
  [1804] = {.lex_state = 190},
  [1805] = {.lex_state = 190},
  [1806] = {.lex_state = 190},
  [1807] = {.lex_state = 190},
  [1808] = {.lex_state = 190},
  [1809] = {.lex_state = 190},
  [1810] = {.lex_state = 190},
  [1811] = {.lex_state = 190},
  [1812] = {.lex_state = 184, .external_lex_state = 4},
  [1813] = {.lex_state = 184, .external_lex_state = 4},
  [1814] = {.lex_state = 184, .external_lex_state = 4},
  [1815] = {.lex_state = 184, .external_lex_state = 4},
  [1816] = {.lex_state = 184, .external_lex_state = 4},
  [1817] = {.lex_state = 184, .external_lex_state = 4},
  [1818] = {.lex_state = 184, .external_lex_state = 4},
  [1819] = {.lex_state = 184, .external_lex_state = 4},
  [1820] = {.lex_state = 184, .external_lex_state = 4},
  [1821] = {.lex_state = 198},
  [1822] = {.lex_state = 198},
  [1823] = {.lex_state = 198},
  [1824] = {.lex_state = 199},
  [1825] = {.lex_state = 199},
  [1826] = {.lex_state = 199},
  [1827] = {.lex_state = 183, .external_lex_state = 3},
  [1828] = {.lex_state = 183, .external_lex_state = 4},
  [1829] = {.lex_state = 200, .external_lex_state = 6},
  [1830] = {.lex_state = 186, .external_lex_state = 6},
  [1831] = {.lex_state = 183, .external_lex_state = 4},
  [1832] = {.lex_state = 183, .external_lex_state = 4},
  [1833] = {.lex_state = 183, .external_lex_state = 4},
  [1834] = {.lex_state = 183, .external_lex_state = 4},
  [1835] = {.lex_state = 183, .external_lex_state = 4},
  [1836] = {.lex_state = 183, .external_lex_state = 4},
  [1837] = {.lex_state = 183, .external_lex_state = 4},
  [1838] = {.lex_state = 183, .external_lex_state = 4},
  [1839] = {.lex_state = 200},
  [1840] = {.lex_state = 186},
  [1841] = {.lex_state = 186, .external_lex_state = 6},
  [1842] = {.lex_state = 186, .external_lex_state = 6},
  [1843] = {.lex_state = 183, .external_lex_state = 4},
  [1844] = {.lex_state = 186, .external_lex_state = 6},
  [1845] = {.lex_state = 186, .external_lex_state = 6},
  [1846] = {.lex_state = 186, .external_lex_state = 6},
  [1847] = {.lex_state = 186, .external_lex_state = 6},
  [1848] = {.lex_state = 183, .external_lex_state = 5},
  [1849] = {.lex_state = 183, .external_lex_state = 5},
  [1850] = {.lex_state = 183, .external_lex_state = 5},
  [1851] = {.lex_state = 186, .external_lex_state = 6},
  [1852] = {.lex_state = 186, .external_lex_state = 6},
  [1853] = {.lex_state = 183, .external_lex_state = 5},
  [1854] = {.lex_state = 183, .external_lex_state = 5},
  [1855] = {.lex_state = 186, .external_lex_state = 6},
  [1856] = {.lex_state = 183, .external_lex_state = 5},
  [1857] = {.lex_state = 183, .external_lex_state = 5},
  [1858] = {.lex_state = 183, .external_lex_state = 5},
  [1859] = {.lex_state = 183, .external_lex_state = 5},
  [1860] = {.lex_state = 186, .external_lex_state = 6},
  [1861] = {.lex_state = 186, .external_lex_state = 6},
  [1862] = {.lex_state = 183, .external_lex_state = 4},
  [1863] = {.lex_state = 183, .external_lex_state = 5},
  [1864] = {.lex_state = 186, .external_lex_state = 6},
  [1865] = {.lex_state = 186, .external_lex_state = 6},
  [1866] = {.lex_state = 186, .external_lex_state = 6},
  [1867] = {.lex_state = 186, .external_lex_state = 6},
  [1868] = {.lex_state = 186, .external_lex_state = 6},
  [1869] = {.lex_state = 186, .external_lex_state = 6},
  [1870] = {.lex_state = 186, .external_lex_state = 6},
  [1871] = {.lex_state = 186, .external_lex_state = 6},
  [1872] = {.lex_state = 186, .external_lex_state = 6},
  [1873] = {.lex_state = 186, .external_lex_state = 6},
  [1874] = {.lex_state = 186, .external_lex_state = 6},
  [1875] = {.lex_state = 186, .external_lex_state = 6},
  [1876] = {.lex_state = 186, .external_lex_state = 6},
  [1877] = {.lex_state = 186, .external_lex_state = 6},
  [1878] = {.lex_state = 186, .external_lex_state = 6},
  [1879] = {.lex_state = 186, .external_lex_state = 6},
  [1880] = {.lex_state = 186, .external_lex_state = 6},
  [1881] = {.lex_state = 186, .external_lex_state = 6},
  [1882] = {.lex_state = 183, .external_lex_state = 4},
  [1883] = {.lex_state = 186, .external_lex_state = 6},
  [1884] = {.lex_state = 186, .external_lex_state = 6},
  [1885] = {.lex_state = 186, .external_lex_state = 6},
  [1886] = {.lex_state = 186, .external_lex_state = 6},
  [1887] = {.lex_state = 186, .external_lex_state = 6},
  [1888] = {.lex_state = 186, .external_lex_state = 6},
  [1889] = {.lex_state = 186, .external_lex_state = 6},
  [1890] = {.lex_state = 186, .external_lex_state = 6},
  [1891] = {.lex_state = 186, .external_lex_state = 6},
  [1892] = {.lex_state = 186, .external_lex_state = 6},
  [1893] = {.lex_state = 186, .external_lex_state = 6},
  [1894] = {.lex_state = 186, .external_lex_state = 6},
  [1895] = {.lex_state = 186},
  [1896] = {.lex_state = 186, .external_lex_state = 6},
  [1897] = {.lex_state = 186, .external_lex_state = 6},
  [1898] = {.lex_state = 186, .external_lex_state = 6},
  [1899] = {.lex_state = 186, .external_lex_state = 6},
  [1900] = {.lex_state = 186},
  [1901] = {.lex_state = 186},
  [1902] = {.lex_state = 186, .external_lex_state = 6},
  [1903] = {.lex_state = 186, .external_lex_state = 6},
  [1904] = {.lex_state = 186, .external_lex_state = 6},
  [1905] = {.lex_state = 186, .external_lex_state = 6},
  [1906] = {.lex_state = 186, .external_lex_state = 6},
  [1907] = {.lex_state = 186},
  [1908] = {.lex_state = 186, .external_lex_state = 6},
  [1909] = {.lex_state = 186, .external_lex_state = 6},
  [1910] = {.lex_state = 186, .external_lex_state = 6},
  [1911] = {.lex_state = 186, .external_lex_state = 6},
  [1912] = {.lex_state = 186, .external_lex_state = 6},
  [1913] = {.lex_state = 186, .external_lex_state = 6},
  [1914] = {.lex_state = 186, .external_lex_state = 6},
  [1915] = {.lex_state = 186, .external_lex_state = 6},
  [1916] = {.lex_state = 186, .external_lex_state = 6},
  [1917] = {.lex_state = 186, .external_lex_state = 6},
  [1918] = {.lex_state = 186, .external_lex_state = 6},
  [1919] = {.lex_state = 186, .external_lex_state = 6},
  [1920] = {.lex_state = 186, .external_lex_state = 6},
  [1921] = {.lex_state = 185, .external_lex_state = 4},
  [1922] = {.lex_state = 186, .external_lex_state = 6},
  [1923] = {.lex_state = 186, .external_lex_state = 6},
  [1924] = {.lex_state = 186, .external_lex_state = 6},
  [1925] = {.lex_state = 186, .external_lex_state = 6},
  [1926] = {.lex_state = 186, .external_lex_state = 6},
  [1927] = {.lex_state = 186},
  [1928] = {.lex_state = 183, .external_lex_state = 4},
  [1929] = {.lex_state = 186},
  [1930] = {.lex_state = 186},
  [1931] = {.lex_state = 186},
  [1932] = {.lex_state = 186},
  [1933] = {.lex_state = 183, .external_lex_state = 4},
  [1934] = {.lex_state = 183, .external_lex_state = 4},
  [1935] = {.lex_state = 186},
  [1936] = {.lex_state = 186},
  [1937] = {.lex_state = 186},
  [1938] = {.lex_state = 186},
  [1939] = {.lex_state = 186},
  [1940] = {.lex_state = 186},
  [1941] = {.lex_state = 183, .external_lex_state = 4},
  [1942] = {.lex_state = 183, .external_lex_state = 4},
  [1943] = {.lex_state = 183, .external_lex_state = 4},
  [1944] = {.lex_state = 183, .external_lex_state = 4},
  [1945] = {.lex_state = 183, .external_lex_state = 4},
  [1946] = {.lex_state = 183, .external_lex_state = 4},
  [1947] = {.lex_state = 183, .external_lex_state = 4},
  [1948] = {.lex_state = 183, .external_lex_state = 4},
  [1949] = {.lex_state = 183, .external_lex_state = 4},
  [1950] = {.lex_state = 183, .external_lex_state = 4},
  [1951] = {.lex_state = 183, .external_lex_state = 4},
  [1952] = {.lex_state = 183, .external_lex_state = 4},
  [1953] = {.lex_state = 186},
  [1954] = {.lex_state = 186},
  [1955] = {.lex_state = 186},
  [1956] = {.lex_state = 183, .external_lex_state = 4},
  [1957] = {.lex_state = 183, .external_lex_state = 4},
  [1958] = {.lex_state = 186},
  [1959] = {.lex_state = 186},
  [1960] = {.lex_state = 186},
  [1961] = {.lex_state = 183, .external_lex_state = 4},
  [1962] = {.lex_state = 183, .external_lex_state = 4},
  [1963] = {.lex_state = 183, .external_lex_state = 4},
  [1964] = {.lex_state = 183, .external_lex_state = 4},
  [1965] = {.lex_state = 183, .external_lex_state = 4},
  [1966] = {.lex_state = 183, .external_lex_state = 4},
  [1967] = {.lex_state = 183, .external_lex_state = 4},
  [1968] = {.lex_state = 186},
  [1969] = {.lex_state = 183, .external_lex_state = 4},
  [1970] = {.lex_state = 186},
  [1971] = {.lex_state = 183, .external_lex_state = 4},
  [1972] = {.lex_state = 186},
  [1973] = {.lex_state = 183, .external_lex_state = 4},
  [1974] = {.lex_state = 183, .external_lex_state = 4},
  [1975] = {.lex_state = 183, .external_lex_state = 4},
  [1976] = {.lex_state = 183, .external_lex_state = 4},
  [1977] = {.lex_state = 183, .external_lex_state = 4},
  [1978] = {.lex_state = 183, .external_lex_state = 4},
  [1979] = {.lex_state = 183, .external_lex_state = 4},
  [1980] = {.lex_state = 183, .external_lex_state = 4},
  [1981] = {.lex_state = 183, .external_lex_state = 4},
  [1982] = {.lex_state = 186},
  [1983] = {.lex_state = 186},
  [1984] = {.lex_state = 183, .external_lex_state = 4},
  [1985] = {.lex_state = 183, .external_lex_state = 4},
  [1986] = {.lex_state = 186},
  [1987] = {.lex_state = 186},
  [1988] = {.lex_state = 183, .external_lex_state = 4},
  [1989] = {.lex_state = 186},
  [1990] = {.lex_state = 183, .external_lex_state = 4},
  [1991] = {.lex_state = 186},
  [1992] = {.lex_state = 183, .external_lex_state = 4},
  [1993] = {.lex_state = 186},
  [1994] = {.lex_state = 186},
  [1995] = {.lex_state = 186},
  [1996] = {.lex_state = 186},
  [1997] = {.lex_state = 186},
  [1998] = {.lex_state = 186},
  [1999] = {.lex_state = 186},
  [2000] = {.lex_state = 186},
  [2001] = {.lex_state = 186},
  [2002] = {.lex_state = 183, .external_lex_state = 4},
  [2003] = {.lex_state = 186},
  [2004] = {.lex_state = 186},
  [2005] = {.lex_state = 186},
  [2006] = {.lex_state = 183, .external_lex_state = 4},
  [2007] = {.lex_state = 183, .external_lex_state = 4},
  [2008] = {.lex_state = 186},
  [2009] = {.lex_state = 186},
  [2010] = {.lex_state = 186},
  [2011] = {.lex_state = 183, .external_lex_state = 4},
  [2012] = {.lex_state = 183, .external_lex_state = 4},
  [2013] = {.lex_state = 186},
  [2014] = {.lex_state = 186},
  [2015] = {.lex_state = 183, .external_lex_state = 4},
  [2016] = {.lex_state = 186},
  [2017] = {.lex_state = 186},
  [2018] = {.lex_state = 186},
  [2019] = {.lex_state = 186},
  [2020] = {.lex_state = 186},
  [2021] = {.lex_state = 186},
  [2022] = {.lex_state = 186},
  [2023] = {.lex_state = 183, .external_lex_state = 4},
  [2024] = {.lex_state = 186},
  [2025] = {.lex_state = 186},
  [2026] = {.lex_state = 186},
  [2027] = {.lex_state = 183, .external_lex_state = 4},
  [2028] = {.lex_state = 183, .external_lex_state = 4},
  [2029] = {.lex_state = 186},
  [2030] = {.lex_state = 186},
  [2031] = {.lex_state = 186},
  [2032] = {.lex_state = 186},
  [2033] = {.lex_state = 183, .external_lex_state = 4},
  [2034] = {.lex_state = 186},
  [2035] = {.lex_state = 186},
  [2036] = {.lex_state = 186},
  [2037] = {.lex_state = 183, .external_lex_state = 4},
  [2038] = {.lex_state = 186},
  [2039] = {.lex_state = 183, .external_lex_state = 4},
  [2040] = {.lex_state = 183, .external_lex_state = 4},
  [2041] = {.lex_state = 183, .external_lex_state = 4},
  [2042] = {.lex_state = 183, .external_lex_state = 4},
  [2043] = {.lex_state = 183, .external_lex_state = 4},
  [2044] = {.lex_state = 183, .external_lex_state = 4},
  [2045] = {.lex_state = 186},
  [2046] = {.lex_state = 183, .external_lex_state = 4},
  [2047] = {.lex_state = 186},
  [2048] = {.lex_state = 183, .external_lex_state = 4},
  [2049] = {.lex_state = 183, .external_lex_state = 4},
  [2050] = {.lex_state = 186},
  [2051] = {.lex_state = 183, .external_lex_state = 4},
  [2052] = {.lex_state = 183, .external_lex_state = 4},
  [2053] = {.lex_state = 183, .external_lex_state = 4},
  [2054] = {.lex_state = 183, .external_lex_state = 4},
  [2055] = {.lex_state = 183, .external_lex_state = 4},
  [2056] = {.lex_state = 183, .external_lex_state = 4},
  [2057] = {.lex_state = 183, .external_lex_state = 4},
  [2058] = {.lex_state = 183, .external_lex_state = 4},
  [2059] = {.lex_state = 183, .external_lex_state = 4},
  [2060] = {.lex_state = 183, .external_lex_state = 4},
  [2061] = {.lex_state = 183, .external_lex_state = 4},
  [2062] = {.lex_state = 183, .external_lex_state = 4},
  [2063] = {.lex_state = 213},
  [2064] = {.lex_state = 213, .external_lex_state = 7},
  [2065] = {.lex_state = 213},
  [2066] = {.lex_state = 213},
  [2067] = {.lex_state = 213},
  [2068] = {.lex_state = 213},
  [2069] = {.lex_state = 213},
  [2070] = {.lex_state = 213},
  [2071] = {.lex_state = 213, .external_lex_state = 7},
  [2072] = {.lex_state = 213},
  [2073] = {.lex_state = 213},
  [2074] = {.lex_state = 213},
  [2075] = {.lex_state = 213},
  [2076] = {.lex_state = 213, .external_lex_state = 7},
  [2077] = {.lex_state = 213, .external_lex_state = 7},
  [2078] = {.lex_state = 213, .external_lex_state = 7},
  [2079] = {.lex_state = 213},
  [2080] = {.lex_state = 213},
  [2081] = {.lex_state = 213},
  [2082] = {.lex_state = 213},
  [2083] = {.lex_state = 213},
  [2084] = {.lex_state = 213},
  [2085] = {.lex_state = 213},
  [2086] = {.lex_state = 213},
  [2087] = {.lex_state = 213},
  [2088] = {.lex_state = 213},
  [2089] = {.lex_state = 213},
  [2090] = {.lex_state = 213},
  [2091] = {.lex_state = 213, .external_lex_state = 7},
  [2092] = {.lex_state = 213},
  [2093] = {.lex_state = 213},
  [2094] = {.lex_state = 213},
  [2095] = {.lex_state = 213},
  [2096] = {.lex_state = 213, .external_lex_state = 7},
  [2097] = {.lex_state = 213},
  [2098] = {.lex_state = 213},
  [2099] = {.lex_state = 213},
  [2100] = {.lex_state = 213},
  [2101] = {.lex_state = 213},
  [2102] = {.lex_state = 213, .external_lex_state = 7},
  [2103] = {.lex_state = 213, .external_lex_state = 7},
  [2104] = {.lex_state = 213},
  [2105] = {.lex_state = 213},
  [2106] = {.lex_state = 213},
  [2107] = {.lex_state = 213},
  [2108] = {.lex_state = 213},
  [2109] = {.lex_state = 213},
  [2110] = {.lex_state = 213},
  [2111] = {.lex_state = 213},
  [2112] = {.lex_state = 213},
  [2113] = {.lex_state = 213},
  [2114] = {.lex_state = 213},
  [2115] = {.lex_state = 213},
  [2116] = {.lex_state = 213},
  [2117] = {.lex_state = 213},
  [2118] = {.lex_state = 213},
  [2119] = {.lex_state = 213},
  [2120] = {.lex_state = 213},
  [2121] = {.lex_state = 213},
  [2122] = {.lex_state = 213},
  [2123] = {.lex_state = 213},
  [2124] = {.lex_state = 213},
  [2125] = {.lex_state = 213},
  [2126] = {.lex_state = 213},
  [2127] = {.lex_state = 213},
  [2128] = {.lex_state = 213},
  [2129] = {.lex_state = 213, .external_lex_state = 7},
  [2130] = {.lex_state = 213},
  [2131] = {.lex_state = 213},
  [2132] = {.lex_state = 213, .external_lex_state = 7},
  [2133] = {.lex_state = 213},
  [2134] = {.lex_state = 213},
  [2135] = {.lex_state = 213, .external_lex_state = 7},
  [2136] = {.lex_state = 213},
  [2137] = {.lex_state = 213},
  [2138] = {.lex_state = 213, .external_lex_state = 7},
  [2139] = {.lex_state = 213},
  [2140] = {.lex_state = 213, .external_lex_state = 7},
  [2141] = {.lex_state = 213},
  [2142] = {.lex_state = 213},
  [2143] = {.lex_state = 213},
  [2144] = {.lex_state = 213},
  [2145] = {.lex_state = 213},
  [2146] = {.lex_state = 213, .external_lex_state = 7},
  [2147] = {.lex_state = 213, .external_lex_state = 7},
  [2148] = {.lex_state = 213, .external_lex_state = 7},
  [2149] = {.lex_state = 213, .external_lex_state = 7},
  [2150] = {.lex_state = 213, .external_lex_state = 7},
  [2151] = {.lex_state = 213, .external_lex_state = 7},
  [2152] = {.lex_state = 213, .external_lex_state = 7},
  [2153] = {.lex_state = 213, .external_lex_state = 7},
  [2154] = {.lex_state = 213, .external_lex_state = 7},
  [2155] = {.lex_state = 213, .external_lex_state = 7},
  [2156] = {.lex_state = 213, .external_lex_state = 7},
  [2157] = {.lex_state = 213, .external_lex_state = 7},
  [2158] = {.lex_state = 213, .external_lex_state = 7},
  [2159] = {.lex_state = 213, .external_lex_state = 7},
  [2160] = {.lex_state = 213, .external_lex_state = 7},
  [2161] = {.lex_state = 213, .external_lex_state = 7},
  [2162] = {.lex_state = 213, .external_lex_state = 7},
  [2163] = {.lex_state = 213, .external_lex_state = 7},
  [2164] = {.lex_state = 213, .external_lex_state = 7},
  [2165] = {.lex_state = 213, .external_lex_state = 7},
  [2166] = {.lex_state = 213, .external_lex_state = 7},
  [2167] = {.lex_state = 213, .external_lex_state = 7},
  [2168] = {.lex_state = 213, .external_lex_state = 7},
  [2169] = {.lex_state = 213, .external_lex_state = 7},
  [2170] = {.lex_state = 213, .external_lex_state = 7},
  [2171] = {.lex_state = 213, .external_lex_state = 7},
  [2172] = {.lex_state = 213, .external_lex_state = 7},
  [2173] = {.lex_state = 213, .external_lex_state = 7},
  [2174] = {.lex_state = 213, .external_lex_state = 7},
  [2175] = {.lex_state = 213, .external_lex_state = 7},
  [2176] = {.lex_state = 213, .external_lex_state = 7},
  [2177] = {.lex_state = 213, .external_lex_state = 7},
  [2178] = {.lex_state = 213, .external_lex_state = 7},
  [2179] = {.lex_state = 213, .external_lex_state = 7},
  [2180] = {.lex_state = 213, .external_lex_state = 7},
  [2181] = {.lex_state = 213, .external_lex_state = 7},
  [2182] = {.lex_state = 213, .external_lex_state = 7},
  [2183] = {.lex_state = 213, .external_lex_state = 7},
  [2184] = {.lex_state = 213, .external_lex_state = 7},
  [2185] = {.lex_state = 213, .external_lex_state = 7},
  [2186] = {.lex_state = 213, .external_lex_state = 7},
  [2187] = {.lex_state = 213, .external_lex_state = 7},
  [2188] = {.lex_state = 213, .external_lex_state = 7},
  [2189] = {.lex_state = 213, .external_lex_state = 7},
  [2190] = {.lex_state = 213, .external_lex_state = 7},
  [2191] = {.lex_state = 213, .external_lex_state = 7},
  [2192] = {.lex_state = 213, .external_lex_state = 7},
  [2193] = {.lex_state = 213, .external_lex_state = 7},
  [2194] = {.lex_state = 213, .external_lex_state = 7},
  [2195] = {.lex_state = 213, .external_lex_state = 7},
  [2196] = {.lex_state = 213, .external_lex_state = 7},
  [2197] = {.lex_state = 213, .external_lex_state = 7},
  [2198] = {.lex_state = 213, .external_lex_state = 7},
  [2199] = {.lex_state = 213, .external_lex_state = 7},
  [2200] = {.lex_state = 213, .external_lex_state = 7},
  [2201] = {.lex_state = 201},
  [2202] = {.lex_state = 201},
  [2203] = {.lex_state = 201},
  [2204] = {.lex_state = 201},
  [2205] = {.lex_state = 201},
  [2206] = {.lex_state = 201},
  [2207] = {.lex_state = 201},
  [2208] = {.lex_state = 201},
  [2209] = {.lex_state = 201},
  [2210] = {.lex_state = 201},
  [2211] = {.lex_state = 201},
  [2212] = {.lex_state = 201},
  [2213] = {.lex_state = 201},
  [2214] = {.lex_state = 201},
  [2215] = {.lex_state = 201},
  [2216] = {.lex_state = 189, .external_lex_state = 8},
  [2217] = {.lex_state = 202},
  [2218] = {.lex_state = 202, .external_lex_state = 8},
  [2219] = {.lex_state = 189, .external_lex_state = 8},
  [2220] = {.lex_state = 190},
  [2221] = {.lex_state = 190},
  [2222] = {.lex_state = 189, .external_lex_state = 8},
  [2223] = {.lex_state = 190},
  [2224] = {.lex_state = 190},
  [2225] = {.lex_state = 189, .external_lex_state = 8},
  [2226] = {.lex_state = 194},
  [2227] = {.lex_state = 194},
  [2228] = {.lex_state = 189, .external_lex_state = 8},
  [2229] = {.lex_state = 190},
  [2230] = {.lex_state = 190},
  [2231] = {.lex_state = 189, .external_lex_state = 8},
  [2232] = {.lex_state = 189, .external_lex_state = 8},
  [2233] = {.lex_state = 190},
  [2234] = {.lex_state = 190},
  [2235] = {.lex_state = 190},
  [2236] = {.lex_state = 189, .external_lex_state = 8},
  [2237] = {.lex_state = 202, .external_lex_state = 7},
  [2238] = {.lex_state = 189},
  [2239] = {.lex_state = 189, .external_lex_state = 8},
  [2240] = {.lex_state = 190},
  [2241] = {.lex_state = 190},
  [2242] = {.lex_state = 190},
  [2243] = {.lex_state = 190},
  [2244] = {.lex_state = 189, .external_lex_state = 8},
  [2245] = {.lex_state = 189, .external_lex_state = 8},
  [2246] = {.lex_state = 189, .external_lex_state = 8},
  [2247] = {.lex_state = 189, .external_lex_state = 8},
  [2248] = {.lex_state = 189, .external_lex_state = 8},
  [2249] = {.lex_state = 189, .external_lex_state = 8},
  [2250] = {.lex_state = 190},
  [2251] = {.lex_state = 190},
  [2252] = {.lex_state = 190},
  [2253] = {.lex_state = 189, .external_lex_state = 8},
  [2254] = {.lex_state = 189, .external_lex_state = 8},
  [2255] = {.lex_state = 190},
  [2256] = {.lex_state = 190},
  [2257] = {.lex_state = 190},
  [2258] = {.lex_state = 190},
  [2259] = {.lex_state = 190},
  [2260] = {.lex_state = 197},
  [2261] = {.lex_state = 190},
  [2262] = {.lex_state = 190},
  [2263] = {.lex_state = 190},
  [2264] = {.lex_state = 189, .external_lex_state = 8},
  [2265] = {.lex_state = 190},
  [2266] = {.lex_state = 189, .external_lex_state = 8},
  [2267] = {.lex_state = 189, .external_lex_state = 8},
  [2268] = {.lex_state = 189, .external_lex_state = 8},
  [2269] = {.lex_state = 189, .external_lex_state = 8},
  [2270] = {.lex_state = 190},
  [2271] = {.lex_state = 190},
  [2272] = {.lex_state = 190},
  [2273] = {.lex_state = 190},
  [2274] = {.lex_state = 190},
  [2275] = {.lex_state = 189, .external_lex_state = 8},
  [2276] = {.lex_state = 189, .external_lex_state = 8},
  [2277] = {.lex_state = 190, .external_lex_state = 8},
  [2278] = {.lex_state = 189, .external_lex_state = 8},
  [2279] = {.lex_state = 189, .external_lex_state = 8},
  [2280] = {.lex_state = 190},
  [2281] = {.lex_state = 189, .external_lex_state = 8},
  [2282] = {.lex_state = 189, .external_lex_state = 8},
  [2283] = {.lex_state = 189, .external_lex_state = 8},
  [2284] = {.lex_state = 190},
  [2285] = {.lex_state = 190},
  [2286] = {.lex_state = 190},
  [2287] = {.lex_state = 190},
  [2288] = {.lex_state = 190},
  [2289] = {.lex_state = 189, .external_lex_state = 8},
  [2290] = {.lex_state = 189, .external_lex_state = 8},
  [2291] = {.lex_state = 189, .external_lex_state = 8},
  [2292] = {.lex_state = 190},
  [2293] = {.lex_state = 189, .external_lex_state = 8},
  [2294] = {.lex_state = 189, .external_lex_state = 8},
  [2295] = {.lex_state = 190},
  [2296] = {.lex_state = 189, .external_lex_state = 8},
  [2297] = {.lex_state = 190},
  [2298] = {.lex_state = 190},
  [2299] = {.lex_state = 189, .external_lex_state = 8},
  [2300] = {.lex_state = 189, .external_lex_state = 8},
  [2301] = {.lex_state = 189, .external_lex_state = 8},
  [2302] = {.lex_state = 189, .external_lex_state = 8},
  [2303] = {.lex_state = 189, .external_lex_state = 8},
  [2304] = {.lex_state = 189, .external_lex_state = 8},
  [2305] = {.lex_state = 189, .external_lex_state = 8},
  [2306] = {.lex_state = 190},
  [2307] = {.lex_state = 190},
  [2308] = {.lex_state = 190},
  [2309] = {.lex_state = 189, .external_lex_state = 8},
  [2310] = {.lex_state = 189, .external_lex_state = 8},
  [2311] = {.lex_state = 189, .external_lex_state = 8},
  [2312] = {.lex_state = 190},
  [2313] = {.lex_state = 190},
  [2314] = {.lex_state = 190},
  [2315] = {.lex_state = 190},
  [2316] = {.lex_state = 190},
  [2317] = {.lex_state = 190},
  [2318] = {.lex_state = 190},
  [2319] = {.lex_state = 190},
  [2320] = {.lex_state = 190},
  [2321] = {.lex_state = 190, .external_lex_state = 8},
  [2322] = {.lex_state = 190},
  [2323] = {.lex_state = 190},
  [2324] = {.lex_state = 190},
  [2325] = {.lex_state = 189, .external_lex_state = 8},
  [2326] = {.lex_state = 189, .external_lex_state = 8},
  [2327] = {.lex_state = 189, .external_lex_state = 8},
  [2328] = {.lex_state = 189, .external_lex_state = 8},
  [2329] = {.lex_state = 190},
  [2330] = {.lex_state = 190},
  [2331] = {.lex_state = 189, .external_lex_state = 8},
  [2332] = {.lex_state = 189, .external_lex_state = 8},
  [2333] = {.lex_state = 189, .external_lex_state = 8},
  [2334] = {.lex_state = 190},
  [2335] = {.lex_state = 190},
  [2336] = {.lex_state = 190},
  [2337] = {.lex_state = 189, .external_lex_state = 8},
  [2338] = {.lex_state = 190},
  [2339] = {.lex_state = 190},
  [2340] = {.lex_state = 190},
  [2341] = {.lex_state = 189, .external_lex_state = 8},
  [2342] = {.lex_state = 190},
  [2343] = {.lex_state = 189, .external_lex_state = 8},
  [2344] = {.lex_state = 189, .external_lex_state = 8},
  [2345] = {.lex_state = 190},
  [2346] = {.lex_state = 189, .external_lex_state = 8},
  [2347] = {.lex_state = 189, .external_lex_state = 8},
  [2348] = {.lex_state = 190, .external_lex_state = 8},
  [2349] = {.lex_state = 190},
  [2350] = {.lex_state = 189, .external_lex_state = 8},
  [2351] = {.lex_state = 189, .external_lex_state = 8},
  [2352] = {.lex_state = 189, .external_lex_state = 8},
  [2353] = {.lex_state = 189, .external_lex_state = 8},
  [2354] = {.lex_state = 189, .external_lex_state = 8},
  [2355] = {.lex_state = 189, .external_lex_state = 8},
  [2356] = {.lex_state = 189, .external_lex_state = 8},
  [2357] = {.lex_state = 190},
  [2358] = {.lex_state = 189, .external_lex_state = 8},
  [2359] = {.lex_state = 189, .external_lex_state = 8},
  [2360] = {.lex_state = 190, .external_lex_state = 8},
  [2361] = {.lex_state = 189, .external_lex_state = 8},
  [2362] = {.lex_state = 214},
  [2363] = {.lex_state = 189, .external_lex_state = 8},
  [2364] = {.lex_state = 190},
  [2365] = {.lex_state = 194},
  [2366] = {.lex_state = 190, .external_lex_state = 8},
  [2367] = {.lex_state = 190, .external_lex_state = 8},
  [2368] = {.lex_state = 194},
  [2369] = {.lex_state = 194},
  [2370] = {.lex_state = 190, .external_lex_state = 8},
  [2371] = {.lex_state = 190, .external_lex_state = 8},
  [2372] = {.lex_state = 194},
  [2373] = {.lex_state = 190, .external_lex_state = 8},
  [2374] = {.lex_state = 190, .external_lex_state = 8},
  [2375] = {.lex_state = 202},
  [2376] = {.lex_state = 202, .external_lex_state = 9},
  [2377] = {.lex_state = 190, .external_lex_state = 8},
  [2378] = {.lex_state = 190, .external_lex_state = 8},
  [2379] = {.lex_state = 190, .external_lex_state = 8},
  [2380] = {.lex_state = 202, .external_lex_state = 10},
  [2381] = {.lex_state = 190, .external_lex_state = 8},
  [2382] = {.lex_state = 202},
  [2383] = {.lex_state = 202},
  [2384] = {.lex_state = 190, .external_lex_state = 8},
  [2385] = {.lex_state = 194},
  [2386] = {.lex_state = 194},
  [2387] = {.lex_state = 190, .external_lex_state = 8},
  [2388] = {.lex_state = 190, .external_lex_state = 8},
  [2389] = {.lex_state = 202},
  [2390] = {.lex_state = 190, .external_lex_state = 8},
  [2391] = {.lex_state = 190, .external_lex_state = 8},
  [2392] = {.lex_state = 190, .external_lex_state = 8},
  [2393] = {.lex_state = 202},
  [2394] = {.lex_state = 190, .external_lex_state = 7},
  [2395] = {.lex_state = 190, .external_lex_state = 8},
  [2396] = {.lex_state = 202},
  [2397] = {.lex_state = 202},
  [2398] = {.lex_state = 194},
  [2399] = {.lex_state = 190, .external_lex_state = 8},
  [2400] = {.lex_state = 190, .external_lex_state = 7},
  [2401] = {.lex_state = 190, .external_lex_state = 8},
  [2402] = {.lex_state = 188},
  [2403] = {.lex_state = 194},
  [2404] = {.lex_state = 190, .external_lex_state = 8},
  [2405] = {.lex_state = 194},
  [2406] = {.lex_state = 202},
  [2407] = {.lex_state = 194},
  [2408] = {.lex_state = 190, .external_lex_state = 8},
  [2409] = {.lex_state = 189},
  [2410] = {.lex_state = 190, .external_lex_state = 8},
  [2411] = {.lex_state = 190, .external_lex_state = 8},
  [2412] = {.lex_state = 190, .external_lex_state = 8},
  [2413] = {.lex_state = 189},
  [2414] = {.lex_state = 190, .external_lex_state = 8},
  [2415] = {.lex_state = 190, .external_lex_state = 8},
  [2416] = {.lex_state = 190, .external_lex_state = 8},
  [2417] = {.lex_state = 190, .external_lex_state = 8},
  [2418] = {.lex_state = 190, .external_lex_state = 8},
  [2419] = {.lex_state = 190, .external_lex_state = 8},
  [2420] = {.lex_state = 190, .external_lex_state = 8},
  [2421] = {.lex_state = 190, .external_lex_state = 8},
  [2422] = {.lex_state = 190, .external_lex_state = 8},
  [2423] = {.lex_state = 190, .external_lex_state = 8},
  [2424] = {.lex_state = 190, .external_lex_state = 8},
  [2425] = {.lex_state = 190, .external_lex_state = 8},
  [2426] = {.lex_state = 190, .external_lex_state = 8},
  [2427] = {.lex_state = 190, .external_lex_state = 8},
  [2428] = {.lex_state = 190, .external_lex_state = 8},
  [2429] = {.lex_state = 190, .external_lex_state = 8},
  [2430] = {.lex_state = 190, .external_lex_state = 8},
  [2431] = {.lex_state = 190, .external_lex_state = 7},
  [2432] = {.lex_state = 202},
  [2433] = {.lex_state = 202},
  [2434] = {.lex_state = 190, .external_lex_state = 8},
  [2435] = {.lex_state = 190, .external_lex_state = 8},
  [2436] = {.lex_state = 190, .external_lex_state = 8},
  [2437] = {.lex_state = 190, .external_lex_state = 8},
  [2438] = {.lex_state = 202},
  [2439] = {.lex_state = 190, .external_lex_state = 8},
  [2440] = {.lex_state = 190, .external_lex_state = 8},
  [2441] = {.lex_state = 190, .external_lex_state = 8},
  [2442] = {.lex_state = 190, .external_lex_state = 8},
  [2443] = {.lex_state = 190, .external_lex_state = 8},
  [2444] = {.lex_state = 202},
  [2445] = {.lex_state = 202},
  [2446] = {.lex_state = 189},
  [2447] = {.lex_state = 190, .external_lex_state = 8},
  [2448] = {.lex_state = 202},
  [2449] = {.lex_state = 190, .external_lex_state = 8},
  [2450] = {.lex_state = 190, .external_lex_state = 8},
  [2451] = {.lex_state = 190, .external_lex_state = 8},
  [2452] = {.lex_state = 194},
  [2453] = {.lex_state = 190, .external_lex_state = 8},
  [2454] = {.lex_state = 190, .external_lex_state = 7},
  [2455] = {.lex_state = 190, .external_lex_state = 8},
  [2456] = {.lex_state = 190, .external_lex_state = 8},
  [2457] = {.lex_state = 190, .external_lex_state = 8},
  [2458] = {.lex_state = 190, .external_lex_state = 8},
  [2459] = {.lex_state = 189},
  [2460] = {.lex_state = 194},
  [2461] = {.lex_state = 190, .external_lex_state = 8},
  [2462] = {.lex_state = 190, .external_lex_state = 8},
  [2463] = {.lex_state = 194},
  [2464] = {.lex_state = 190, .external_lex_state = 8},
  [2465] = {.lex_state = 190, .external_lex_state = 8},
  [2466] = {.lex_state = 190, .external_lex_state = 8},
  [2467] = {.lex_state = 202},
  [2468] = {.lex_state = 202},
  [2469] = {.lex_state = 194},
  [2470] = {.lex_state = 190, .external_lex_state = 7},
  [2471] = {.lex_state = 194},
  [2472] = {.lex_state = 190, .external_lex_state = 7},
  [2473] = {.lex_state = 194},
  [2474] = {.lex_state = 189},
  [2475] = {.lex_state = 189},
  [2476] = {.lex_state = 189},
  [2477] = {.lex_state = 194},
  [2478] = {.lex_state = 202},
  [2479] = {.lex_state = 194},
  [2480] = {.lex_state = 189},
  [2481] = {.lex_state = 194},
  [2482] = {.lex_state = 194},
  [2483] = {.lex_state = 189},
  [2484] = {.lex_state = 214},
  [2485] = {.lex_state = 194},
  [2486] = {.lex_state = 194},
  [2487] = {.lex_state = 194},
  [2488] = {.lex_state = 197},
  [2489] = {.lex_state = 194},
  [2490] = {.lex_state = 194},
  [2491] = {.lex_state = 194},
  [2492] = {.lex_state = 194},
  [2493] = {.lex_state = 194},
  [2494] = {.lex_state = 194},
  [2495] = {.lex_state = 194},
  [2496] = {.lex_state = 194},
  [2497] = {.lex_state = 194},
  [2498] = {.lex_state = 197},
  [2499] = {.lex_state = 194},
  [2500] = {.lex_state = 194},
  [2501] = {.lex_state = 194},
  [2502] = {.lex_state = 194},
  [2503] = {.lex_state = 194},
  [2504] = {.lex_state = 189},
  [2505] = {.lex_state = 194},
  [2506] = {.lex_state = 194},
  [2507] = {.lex_state = 189},
  [2508] = {.lex_state = 194},
  [2509] = {.lex_state = 190, .external_lex_state = 7},
  [2510] = {.lex_state = 194},
  [2511] = {.lex_state = 190, .external_lex_state = 7},
  [2512] = {.lex_state = 194},
  [2513] = {.lex_state = 197},
  [2514] = {.lex_state = 194},
  [2515] = {.lex_state = 194},
  [2516] = {.lex_state = 194},
  [2517] = {.lex_state = 194},
  [2518] = {.lex_state = 190, .external_lex_state = 7},
  [2519] = {.lex_state = 194},
  [2520] = {.lex_state = 194},
  [2521] = {.lex_state = 194},
  [2522] = {.lex_state = 194},
  [2523] = {.lex_state = 194},
  [2524] = {.lex_state = 194},
  [2525] = {.lex_state = 189},
  [2526] = {.lex_state = 214},
  [2527] = {.lex_state = 190, .external_lex_state = 7},
  [2528] = {.lex_state = 189},
  [2529] = {.lex_state = 194},
  [2530] = {.lex_state = 194},
  [2531] = {.lex_state = 194},
  [2532] = {.lex_state = 194},
  [2533] = {.lex_state = 190, .external_lex_state = 7},
  [2534] = {.lex_state = 214},
  [2535] = {.lex_state = 194},
  [2536] = {.lex_state = 194},
  [2537] = {.lex_state = 194},
  [2538] = {.lex_state = 194},
  [2539] = {.lex_state = 190, .external_lex_state = 7},
  [2540] = {.lex_state = 190, .external_lex_state = 7},
  [2541] = {.lex_state = 197},
  [2542] = {.lex_state = 194},
  [2543] = {.lex_state = 194},
  [2544] = {.lex_state = 194},
  [2545] = {.lex_state = 214},
  [2546] = {.lex_state = 194},
  [2547] = {.lex_state = 194},
  [2548] = {.lex_state = 194},
  [2549] = {.lex_state = 194},
  [2550] = {.lex_state = 194},
  [2551] = {.lex_state = 189},
  [2552] = {.lex_state = 190, .external_lex_state = 7},
  [2553] = {.lex_state = 190, .external_lex_state = 7},
  [2554] = {.lex_state = 190, .external_lex_state = 7},
  [2555] = {.lex_state = 190, .external_lex_state = 7},
  [2556] = {.lex_state = 190, .external_lex_state = 7},
  [2557] = {.lex_state = 190, .external_lex_state = 7},
  [2558] = {.lex_state = 197},
  [2559] = {.lex_state = 190, .external_lex_state = 10},
  [2560] = {.lex_state = 189},
  [2561] = {.lex_state = 190, .external_lex_state = 7},
  [2562] = {.lex_state = 189},
  [2563] = {.lex_state = 190, .external_lex_state = 7},
  [2564] = {.lex_state = 189},
  [2565] = {.lex_state = 190, .external_lex_state = 7},
  [2566] = {.lex_state = 189},
  [2567] = {.lex_state = 190, .external_lex_state = 7},
  [2568] = {.lex_state = 190, .external_lex_state = 7},
  [2569] = {.lex_state = 190, .external_lex_state = 7},
  [2570] = {.lex_state = 190, .external_lex_state = 7},
  [2571] = {.lex_state = 190, .external_lex_state = 7},
  [2572] = {.lex_state = 190, .external_lex_state = 7},
  [2573] = {.lex_state = 190, .external_lex_state = 7},
  [2574] = {.lex_state = 190, .external_lex_state = 7},
  [2575] = {.lex_state = 190, .external_lex_state = 7},
  [2576] = {.lex_state = 189},
  [2577] = {.lex_state = 189},
  [2578] = {.lex_state = 190, .external_lex_state = 7},
  [2579] = {.lex_state = 190, .external_lex_state = 7},
  [2580] = {.lex_state = 190, .external_lex_state = 7},
  [2581] = {.lex_state = 190, .external_lex_state = 7},
  [2582] = {.lex_state = 190, .external_lex_state = 7},
  [2583] = {.lex_state = 189},
  [2584] = {.lex_state = 189},
  [2585] = {.lex_state = 189},
  [2586] = {.lex_state = 189},
  [2587] = {.lex_state = 189},
  [2588] = {.lex_state = 190, .external_lex_state = 7},
  [2589] = {.lex_state = 189},
  [2590] = {.lex_state = 197},
  [2591] = {.lex_state = 189},
  [2592] = {.lex_state = 189},
  [2593] = {.lex_state = 190, .external_lex_state = 7},
  [2594] = {.lex_state = 189},
  [2595] = {.lex_state = 189},
  [2596] = {.lex_state = 189},
  [2597] = {.lex_state = 189},
  [2598] = {.lex_state = 189},
  [2599] = {.lex_state = 189},
  [2600] = {.lex_state = 189},
  [2601] = {.lex_state = 189},
  [2602] = {.lex_state = 189},
  [2603] = {.lex_state = 189},
  [2604] = {.lex_state = 189},
  [2605] = {.lex_state = 190, .external_lex_state = 7},
  [2606] = {.lex_state = 189},
  [2607] = {.lex_state = 190, .external_lex_state = 7},
  [2608] = {.lex_state = 190, .external_lex_state = 7},
  [2609] = {.lex_state = 189},
  [2610] = {.lex_state = 189},
  [2611] = {.lex_state = 189},
  [2612] = {.lex_state = 189},
  [2613] = {.lex_state = 189},
  [2614] = {.lex_state = 189},
  [2615] = {.lex_state = 190, .external_lex_state = 9},
  [2616] = {.lex_state = 189},
  [2617] = {.lex_state = 189},
  [2618] = {.lex_state = 189},
  [2619] = {.lex_state = 214},
  [2620] = {.lex_state = 190, .external_lex_state = 7},
  [2621] = {.lex_state = 190, .external_lex_state = 7},
  [2622] = {.lex_state = 190, .external_lex_state = 7},
  [2623] = {.lex_state = 190, .external_lex_state = 7},
  [2624] = {.lex_state = 190, .external_lex_state = 10},
  [2625] = {.lex_state = 189},
  [2626] = {.lex_state = 190, .external_lex_state = 7},
  [2627] = {.lex_state = 190, .external_lex_state = 7},
  [2628] = {.lex_state = 189},
  [2629] = {.lex_state = 214},
  [2630] = {.lex_state = 214},
  [2631] = {.lex_state = 197},
  [2632] = {.lex_state = 197},
  [2633] = {.lex_state = 214},
  [2634] = {.lex_state = 214},
  [2635] = {.lex_state = 190, .external_lex_state = 9},
  [2636] = {.lex_state = 190, .external_lex_state = 9},
  [2637] = {.lex_state = 214},
  [2638] = {.lex_state = 189},
  [2639] = {.lex_state = 189},
  [2640] = {.lex_state = 214},
  [2641] = {.lex_state = 190, .external_lex_state = 7},
  [2642] = {.lex_state = 189},
  [2643] = {.lex_state = 189},
  [2644] = {.lex_state = 189},
  [2645] = {.lex_state = 189},
  [2646] = {.lex_state = 189},
  [2647] = {.lex_state = 197},
  [2648] = {.lex_state = 190, .external_lex_state = 7},
  [2649] = {.lex_state = 190, .external_lex_state = 7},
  [2650] = {.lex_state = 197},
  [2651] = {.lex_state = 189},
  [2652] = {.lex_state = 189},
  [2653] = {.lex_state = 189},
  [2654] = {.lex_state = 189},
  [2655] = {.lex_state = 190, .external_lex_state = 7},
  [2656] = {.lex_state = 190, .external_lex_state = 7},
  [2657] = {.lex_state = 189},
  [2658] = {.lex_state = 190, .external_lex_state = 7},
  [2659] = {.lex_state = 190, .external_lex_state = 7},
  [2660] = {.lex_state = 190, .external_lex_state = 7},
  [2661] = {.lex_state = 190, .external_lex_state = 7},
  [2662] = {.lex_state = 190, .external_lex_state = 7},
  [2663] = {.lex_state = 190, .external_lex_state = 10},
  [2664] = {.lex_state = 189},
  [2665] = {.lex_state = 190, .external_lex_state = 9},
  [2666] = {.lex_state = 189},
  [2667] = {.lex_state = 190, .external_lex_state = 7},
  [2668] = {.lex_state = 189},
  [2669] = {.lex_state = 190, .external_lex_state = 7},
  [2670] = {.lex_state = 214},
  [2671] = {.lex_state = 190, .external_lex_state = 7},
  [2672] = {.lex_state = 190, .external_lex_state = 7},
  [2673] = {.lex_state = 214},
  [2674] = {.lex_state = 197},
  [2675] = {.lex_state = 190, .external_lex_state = 7},
  [2676] = {.lex_state = 189},
  [2677] = {.lex_state = 190, .external_lex_state = 10},
  [2678] = {.lex_state = 197},
  [2679] = {.lex_state = 190, .external_lex_state = 7},
  [2680] = {.lex_state = 197},
  [2681] = {.lex_state = 190, .external_lex_state = 7},
  [2682] = {.lex_state = 190, .external_lex_state = 7},
  [2683] = {.lex_state = 190, .external_lex_state = 7},
  [2684] = {.lex_state = 189},
  [2685] = {.lex_state = 190, .external_lex_state = 7},
  [2686] = {.lex_state = 190, .external_lex_state = 7},
  [2687] = {.lex_state = 214},
  [2688] = {.lex_state = 214},
  [2689] = {.lex_state = 214},
  [2690] = {.lex_state = 214},
  [2691] = {.lex_state = 214},
  [2692] = {.lex_state = 214},
  [2693] = {.lex_state = 214},
  [2694] = {.lex_state = 214},
  [2695] = {.lex_state = 214},
  [2696] = {.lex_state = 214},
  [2697] = {.lex_state = 214},
  [2698] = {.lex_state = 214},
  [2699] = {.lex_state = 214},
  [2700] = {.lex_state = 214},
  [2701] = {.lex_state = 214},
  [2702] = {.lex_state = 214},
  [2703] = {.lex_state = 214},
  [2704] = {.lex_state = 214},
  [2705] = {.lex_state = 214},
  [2706] = {.lex_state = 214},
  [2707] = {.lex_state = 214},
  [2708] = {.lex_state = 214},
  [2709] = {.lex_state = 214},
  [2710] = {.lex_state = 214},
  [2711] = {.lex_state = 214},
  [2712] = {.lex_state = 214},
  [2713] = {.lex_state = 214},
  [2714] = {.lex_state = 214},
  [2715] = {.lex_state = 214},
  [2716] = {.lex_state = 214},
  [2717] = {.lex_state = 214},
  [2718] = {.lex_state = 214},
  [2719] = {.lex_state = 214},
  [2720] = {.lex_state = 190, .external_lex_state = 9},
  [2721] = {.lex_state = 190, .external_lex_state = 9},
  [2722] = {.lex_state = 187},
  [2723] = {.lex_state = 214},
  [2724] = {.lex_state = 197},
  [2725] = {.lex_state = 197},
  [2726] = {.lex_state = 197},
  [2727] = {.lex_state = 197},
  [2728] = {.lex_state = 197},
  [2729] = {.lex_state = 197},
  [2730] = {.lex_state = 214},
  [2731] = {.lex_state = 197},
  [2732] = {.lex_state = 197},
  [2733] = {.lex_state = 197},
  [2734] = {.lex_state = 197},
  [2735] = {.lex_state = 197},
  [2736] = {.lex_state = 197},
  [2737] = {.lex_state = 197},
  [2738] = {.lex_state = 214},
  [2739] = {.lex_state = 214},
  [2740] = {.lex_state = 214},
  [2741] = {.lex_state = 197},
  [2742] = {.lex_state = 197},
  [2743] = {.lex_state = 197},
  [2744] = {.lex_state = 197},
  [2745] = {.lex_state = 197},
  [2746] = {.lex_state = 214},
  [2747] = {.lex_state = 214},
  [2748] = {.lex_state = 190, .external_lex_state = 10},
  [2749] = {.lex_state = 197},
  [2750] = {.lex_state = 197},
  [2751] = {.lex_state = 214},
  [2752] = {.lex_state = 197},
  [2753] = {.lex_state = 214},
  [2754] = {.lex_state = 214},
  [2755] = {.lex_state = 197},
  [2756] = {.lex_state = 214},
  [2757] = {.lex_state = 197},
  [2758] = {.lex_state = 197},
  [2759] = {.lex_state = 197},
  [2760] = {.lex_state = 197},
  [2761] = {.lex_state = 197},
  [2762] = {.lex_state = 197},
  [2763] = {.lex_state = 197},
  [2764] = {.lex_state = 197},
  [2765] = {.lex_state = 214},
  [2766] = {.lex_state = 214},
  [2767] = {.lex_state = 214},
  [2768] = {.lex_state = 214},
  [2769] = {.lex_state = 197},
  [2770] = {.lex_state = 214},
  [2771] = {.lex_state = 197},
  [2772] = {.lex_state = 197},
  [2773] = {.lex_state = 214},
  [2774] = {.lex_state = 214},
  [2775] = {.lex_state = 214},
  [2776] = {.lex_state = 214},
  [2777] = {.lex_state = 214},
  [2778] = {.lex_state = 197},
  [2779] = {.lex_state = 197},
  [2780] = {.lex_state = 197},
  [2781] = {.lex_state = 197},
  [2782] = {.lex_state = 197},
  [2783] = {.lex_state = 197},
  [2784] = {.lex_state = 197},
  [2785] = {.lex_state = 197},
  [2786] = {.lex_state = 190, .external_lex_state = 10},
  [2787] = {.lex_state = 190, .external_lex_state = 9},
  [2788] = {.lex_state = 190, .external_lex_state = 9},
  [2789] = {.lex_state = 190, .external_lex_state = 9},
  [2790] = {.lex_state = 190, .external_lex_state = 9},
  [2791] = {.lex_state = 197},
  [2792] = {.lex_state = 197},
  [2793] = {.lex_state = 197},
  [2794] = {.lex_state = 190, .external_lex_state = 10},
  [2795] = {.lex_state = 197},
  [2796] = {.lex_state = 197},
  [2797] = {.lex_state = 197},
  [2798] = {.lex_state = 197},
  [2799] = {.lex_state = 197},
  [2800] = {.lex_state = 197},
  [2801] = {.lex_state = 197},
  [2802] = {.lex_state = 197},
  [2803] = {.lex_state = 197},
  [2804] = {.lex_state = 197},
  [2805] = {.lex_state = 197},
  [2806] = {.lex_state = 190, .external_lex_state = 9},
  [2807] = {.lex_state = 214},
  [2808] = {.lex_state = 190, .external_lex_state = 10},
  [2809] = {.lex_state = 190, .external_lex_state = 9},
  [2810] = {.lex_state = 190, .external_lex_state = 9},
  [2811] = {.lex_state = 190, .external_lex_state = 10},
  [2812] = {.lex_state = 190, .external_lex_state = 10},
  [2813] = {.lex_state = 190, .external_lex_state = 10},
  [2814] = {.lex_state = 190, .external_lex_state = 10},
  [2815] = {.lex_state = 190, .external_lex_state = 10},
  [2816] = {.lex_state = 190, .external_lex_state = 10},
  [2817] = {.lex_state = 190, .external_lex_state = 9},
  [2818] = {.lex_state = 190, .external_lex_state = 10},
  [2819] = {.lex_state = 190, .external_lex_state = 10},
  [2820] = {.lex_state = 190, .external_lex_state = 10},
  [2821] = {.lex_state = 190, .external_lex_state = 10},
  [2822] = {.lex_state = 190, .external_lex_state = 10},
  [2823] = {.lex_state = 190, .external_lex_state = 10},
  [2824] = {.lex_state = 190, .external_lex_state = 10},
  [2825] = {.lex_state = 190, .external_lex_state = 10},
  [2826] = {.lex_state = 190, .external_lex_state = 10},
  [2827] = {.lex_state = 190, .external_lex_state = 10},
  [2828] = {.lex_state = 190, .external_lex_state = 10},
  [2829] = {.lex_state = 190, .external_lex_state = 10},
  [2830] = {.lex_state = 190, .external_lex_state = 10},
  [2831] = {.lex_state = 190, .external_lex_state = 10},
  [2832] = {.lex_state = 190, .external_lex_state = 10},
  [2833] = {.lex_state = 190, .external_lex_state = 9},
  [2834] = {.lex_state = 190, .external_lex_state = 10},
  [2835] = {.lex_state = 190, .external_lex_state = 10},
  [2836] = {.lex_state = 190, .external_lex_state = 10},
  [2837] = {.lex_state = 190, .external_lex_state = 10},
  [2838] = {.lex_state = 190, .external_lex_state = 10},
  [2839] = {.lex_state = 190, .external_lex_state = 10},
  [2840] = {.lex_state = 190, .external_lex_state = 10},
  [2841] = {.lex_state = 190, .external_lex_state = 10},
  [2842] = {.lex_state = 190, .external_lex_state = 9},
  [2843] = {.lex_state = 190, .external_lex_state = 9},
  [2844] = {.lex_state = 190, .external_lex_state = 10},
  [2845] = {.lex_state = 190, .external_lex_state = 10},
  [2846] = {.lex_state = 190, .external_lex_state = 10},
  [2847] = {.lex_state = 190, .external_lex_state = 10},
  [2848] = {.lex_state = 190, .external_lex_state = 10},
  [2849] = {.lex_state = 190, .external_lex_state = 10},
  [2850] = {.lex_state = 190, .external_lex_state = 9},
  [2851] = {.lex_state = 190, .external_lex_state = 9},
  [2852] = {.lex_state = 190, .external_lex_state = 9},
  [2853] = {.lex_state = 190, .external_lex_state = 9},
  [2854] = {.lex_state = 190, .external_lex_state = 9},
  [2855] = {.lex_state = 190, .external_lex_state = 10},
  [2856] = {.lex_state = 190, .external_lex_state = 9},
  [2857] = {.lex_state = 190, .external_lex_state = 9},
  [2858] = {.lex_state = 190, .external_lex_state = 9},
  [2859] = {.lex_state = 190, .external_lex_state = 9},
  [2860] = {.lex_state = 190, .external_lex_state = 10},
  [2861] = {.lex_state = 190, .external_lex_state = 9},
  [2862] = {.lex_state = 190, .external_lex_state = 10},
  [2863] = {.lex_state = 190, .external_lex_state = 9},
  [2864] = {.lex_state = 190, .external_lex_state = 10},
  [2865] = {.lex_state = 190, .external_lex_state = 10},
  [2866] = {.lex_state = 190, .external_lex_state = 10},
  [2867] = {.lex_state = 190, .external_lex_state = 10},
  [2868] = {.lex_state = 190, .external_lex_state = 9},
  [2869] = {.lex_state = 190, .external_lex_state = 9},
  [2870] = {.lex_state = 190, .external_lex_state = 9},
  [2871] = {.lex_state = 190, .external_lex_state = 9},
  [2872] = {.lex_state = 190, .external_lex_state = 10},
  [2873] = {.lex_state = 190, .external_lex_state = 9},
  [2874] = {.lex_state = 190, .external_lex_state = 10},
  [2875] = {.lex_state = 190, .external_lex_state = 9},
  [2876] = {.lex_state = 190, .external_lex_state = 10},
  [2877] = {.lex_state = 190, .external_lex_state = 10},
  [2878] = {.lex_state = 190, .external_lex_state = 9},
  [2879] = {.lex_state = 190, .external_lex_state = 9},
  [2880] = {.lex_state = 190, .external_lex_state = 9},
  [2881] = {.lex_state = 190, .external_lex_state = 9},
  [2882] = {.lex_state = 190, .external_lex_state = 10},
  [2883] = {.lex_state = 190, .external_lex_state = 9},
  [2884] = {.lex_state = 190, .external_lex_state = 9},
  [2885] = {.lex_state = 190, .external_lex_state = 10},
  [2886] = {.lex_state = 190, .external_lex_state = 10},
  [2887] = {.lex_state = 190, .external_lex_state = 9},
  [2888] = {.lex_state = 190, .external_lex_state = 10},
  [2889] = {.lex_state = 190, .external_lex_state = 9},
  [2890] = {.lex_state = 190, .external_lex_state = 9},
  [2891] = {.lex_state = 190, .external_lex_state = 9},
  [2892] = {.lex_state = 190, .external_lex_state = 9},
  [2893] = {.lex_state = 190, .external_lex_state = 9},
  [2894] = {.lex_state = 190, .external_lex_state = 9},
  [2895] = {.lex_state = 190, .external_lex_state = 10},
  [2896] = {.lex_state = 190, .external_lex_state = 9},
  [2897] = {.lex_state = 190, .external_lex_state = 9},
  [2898] = {.lex_state = 190, .external_lex_state = 9},
  [2899] = {.lex_state = 190, .external_lex_state = 10},
  [2900] = {.lex_state = 190, .external_lex_state = 9},
  [2901] = {.lex_state = 190, .external_lex_state = 9},
  [2902] = {.lex_state = 190, .external_lex_state = 10},
  [2903] = {.lex_state = 190, .external_lex_state = 9},
  [2904] = {.lex_state = 190, .external_lex_state = 9},
  [2905] = {.lex_state = 190, .external_lex_state = 9},
  [2906] = {.lex_state = 190, .external_lex_state = 9},
  [2907] = {.lex_state = 190, .external_lex_state = 9},
  [2908] = {.lex_state = 190, .external_lex_state = 9},
  [2909] = {.lex_state = 190, .external_lex_state = 9},
  [2910] = {.lex_state = 190, .external_lex_state = 10},
  [2911] = {.lex_state = 190, .external_lex_state = 10},
  [2912] = {.lex_state = 190, .external_lex_state = 9},
  [2913] = {.lex_state = 190, .external_lex_state = 9},
  [2914] = {.lex_state = 190, .external_lex_state = 9},
  [2915] = {.lex_state = 190, .external_lex_state = 10},
  [2916] = {.lex_state = 190, .external_lex_state = 9},
  [2917] = {.lex_state = 190, .external_lex_state = 9},
  [2918] = {.lex_state = 190, .external_lex_state = 9},
  [2919] = {.lex_state = 190, .external_lex_state = 9},
  [2920] = {.lex_state = 190, .external_lex_state = 10},
  [2921] = {.lex_state = 190, .external_lex_state = 10},
  [2922] = {.lex_state = 190, .external_lex_state = 10},
  [2923] = {.lex_state = 190, .external_lex_state = 9},
  [2924] = {.lex_state = 190, .external_lex_state = 9},
  [2925] = {.lex_state = 190, .external_lex_state = 10},
  [2926] = {.lex_state = 203},
  [2927] = {.lex_state = 203},
  [2928] = {.lex_state = 203},
  [2929] = {.lex_state = 203},
  [2930] = {.lex_state = 203},
  [2931] = {.lex_state = 203},
  [2932] = {.lex_state = 203},
  [2933] = {.lex_state = 203},
  [2934] = {.lex_state = 203},
  [2935] = {.lex_state = 203, .external_lex_state = 6},
  [2936] = {.lex_state = 203, .external_lex_state = 6},
  [2937] = {.lex_state = 203},
  [2938] = {.lex_state = 203, .external_lex_state = 6},
  [2939] = {.lex_state = 203},
  [2940] = {.lex_state = 203},
  [2941] = {.lex_state = 203},
  [2942] = {.lex_state = 203},
  [2943] = {.lex_state = 203},
  [2944] = {.lex_state = 203},
  [2945] = {.lex_state = 203},
  [2946] = {.lex_state = 203},
  [2947] = {.lex_state = 203},
  [2948] = {.lex_state = 203},
  [2949] = {.lex_state = 203},
  [2950] = {.lex_state = 203},
  [2951] = {.lex_state = 203},
  [2952] = {.lex_state = 203},
  [2953] = {.lex_state = 203},
  [2954] = {.lex_state = 203},
  [2955] = {.lex_state = 203},
  [2956] = {.lex_state = 203},
  [2957] = {.lex_state = 203},
  [2958] = {.lex_state = 203},
  [2959] = {.lex_state = 203},
  [2960] = {.lex_state = 203},
  [2961] = {.lex_state = 203},
  [2962] = {.lex_state = 203},
  [2963] = {.lex_state = 203},
  [2964] = {.lex_state = 203},
  [2965] = {.lex_state = 203},
  [2966] = {.lex_state = 203},
  [2967] = {.lex_state = 203},
  [2968] = {.lex_state = 203},
  [2969] = {.lex_state = 203},
  [2970] = {.lex_state = 203},
  [2971] = {.lex_state = 203},
  [2972] = {.lex_state = 203},
  [2973] = {.lex_state = 203},
  [2974] = {.lex_state = 203},
  [2975] = {.lex_state = 203},
  [2976] = {.lex_state = 203},
  [2977] = {.lex_state = 203},
  [2978] = {.lex_state = 203},
  [2979] = {.lex_state = 203},
  [2980] = {.lex_state = 203},
  [2981] = {.lex_state = 203},
  [2982] = {.lex_state = 203},
  [2983] = {.lex_state = 203},
  [2984] = {.lex_state = 203},
  [2985] = {.lex_state = 203},
  [2986] = {.lex_state = 203},
  [2987] = {.lex_state = 203},
  [2988] = {.lex_state = 203},
  [2989] = {.lex_state = 203},
  [2990] = {.lex_state = 203},
  [2991] = {.lex_state = 203},
  [2992] = {.lex_state = 203},
  [2993] = {.lex_state = 203},
  [2994] = {.lex_state = 203},
  [2995] = {.lex_state = 203},
  [2996] = {.lex_state = 203},
  [2997] = {.lex_state = 203},
  [2998] = {.lex_state = 203},
  [2999] = {.lex_state = 203},
  [3000] = {.lex_state = 203},
  [3001] = {.lex_state = 203},
  [3002] = {.lex_state = 205},
  [3003] = {.lex_state = 203},
  [3004] = {.lex_state = 203},
  [3005] = {.lex_state = 203},
  [3006] = {.lex_state = 203},
  [3007] = {.lex_state = 203},
  [3008] = {.lex_state = 203},
  [3009] = {.lex_state = 203},
  [3010] = {.lex_state = 203},
  [3011] = {.lex_state = 203},
  [3012] = {.lex_state = 203},
  [3013] = {.lex_state = 203},
  [3014] = {.lex_state = 203},
  [3015] = {.lex_state = 203},
  [3016] = {.lex_state = 203},
  [3017] = {.lex_state = 203},
  [3018] = {.lex_state = 203},
  [3019] = {.lex_state = 203},
  [3020] = {.lex_state = 203},
  [3021] = {.lex_state = 203},
  [3022] = {.lex_state = 203},
  [3023] = {.lex_state = 203},
  [3024] = {.lex_state = 203},
  [3025] = {.lex_state = 203},
  [3026] = {.lex_state = 203},
  [3027] = {.lex_state = 203},
  [3028] = {.lex_state = 203},
  [3029] = {.lex_state = 203},
  [3030] = {.lex_state = 203},
  [3031] = {.lex_state = 203},
  [3032] = {.lex_state = 203},
  [3033] = {.lex_state = 203},
  [3034] = {.lex_state = 203},
  [3035] = {.lex_state = 203},
  [3036] = {.lex_state = 203},
  [3037] = {.lex_state = 203},
  [3038] = {.lex_state = 203},
  [3039] = {.lex_state = 203},
  [3040] = {.lex_state = 203},
  [3041] = {.lex_state = 203},
  [3042] = {.lex_state = 203},
  [3043] = {.lex_state = 203},
  [3044] = {.lex_state = 203},
  [3045] = {.lex_state = 203},
  [3046] = {.lex_state = 203},
  [3047] = {.lex_state = 203},
  [3048] = {.lex_state = 203},
  [3049] = {.lex_state = 203},
  [3050] = {.lex_state = 203},
  [3051] = {.lex_state = 203},
  [3052] = {.lex_state = 203},
  [3053] = {.lex_state = 203},
  [3054] = {.lex_state = 203},
  [3055] = {.lex_state = 203},
  [3056] = {.lex_state = 203},
  [3057] = {.lex_state = 203},
  [3058] = {.lex_state = 203},
  [3059] = {.lex_state = 203},
  [3060] = {.lex_state = 203},
  [3061] = {.lex_state = 203},
  [3062] = {.lex_state = 203},
  [3063] = {.lex_state = 203},
  [3064] = {.lex_state = 203},
  [3065] = {.lex_state = 203},
  [3066] = {.lex_state = 203},
  [3067] = {.lex_state = 203},
  [3068] = {.lex_state = 203},
  [3069] = {.lex_state = 203},
  [3070] = {.lex_state = 203},
  [3071] = {.lex_state = 203},
  [3072] = {.lex_state = 203},
  [3073] = {.lex_state = 203},
  [3074] = {.lex_state = 203},
  [3075] = {.lex_state = 203},
  [3076] = {.lex_state = 203},
  [3077] = {.lex_state = 203},
  [3078] = {.lex_state = 203},
  [3079] = {.lex_state = 203},
  [3080] = {.lex_state = 203},
  [3081] = {.lex_state = 203},
  [3082] = {.lex_state = 203},
  [3083] = {.lex_state = 203},
  [3084] = {.lex_state = 203},
  [3085] = {.lex_state = 203},
  [3086] = {.lex_state = 203},
  [3087] = {.lex_state = 203},
  [3088] = {.lex_state = 203},
  [3089] = {.lex_state = 203},
  [3090] = {.lex_state = 203},
  [3091] = {.lex_state = 203},
  [3092] = {.lex_state = 203},
  [3093] = {.lex_state = 203},
  [3094] = {.lex_state = 203},
  [3095] = {.lex_state = 203},
  [3096] = {.lex_state = 203},
  [3097] = {.lex_state = 203},
  [3098] = {.lex_state = 203},
  [3099] = {.lex_state = 203},
  [3100] = {.lex_state = 203, .external_lex_state = 7},
  [3101] = {.lex_state = 203, .external_lex_state = 7},
  [3102] = {.lex_state = 203, .external_lex_state = 7},
  [3103] = {.lex_state = 203},
  [3104] = {.lex_state = 203},
  [3105] = {.lex_state = 203},
  [3106] = {.lex_state = 203},
  [3107] = {.lex_state = 203},
  [3108] = {.lex_state = 203},
  [3109] = {.lex_state = 203},
  [3110] = {.lex_state = 203},
  [3111] = {.lex_state = 203},
  [3112] = {.lex_state = 203},
  [3113] = {.lex_state = 203},
  [3114] = {.lex_state = 203},
  [3115] = {.lex_state = 207},
  [3116] = {.lex_state = 207},
  [3117] = {.lex_state = 203},
  [3118] = {.lex_state = 205},
  [3119] = {.lex_state = 203},
  [3120] = {.lex_state = 203},
  [3121] = {.lex_state = 203},
  [3122] = {.lex_state = 203},
  [3123] = {.lex_state = 203},
  [3124] = {.lex_state = 203},
  [3125] = {.lex_state = 203},
  [3126] = {.lex_state = 203},
  [3127] = {.lex_state = 203},
  [3128] = {.lex_state = 205, .external_lex_state = 7},
  [3129] = {.lex_state = 203},
  [3130] = {.lex_state = 203},
  [3131] = {.lex_state = 203},
  [3132] = {.lex_state = 203},
  [3133] = {.lex_state = 203},
  [3134] = {.lex_state = 203},
  [3135] = {.lex_state = 203},
  [3136] = {.lex_state = 203},
  [3137] = {.lex_state = 203},
  [3138] = {.lex_state = 203},
  [3139] = {.lex_state = 203},
  [3140] = {.lex_state = 203},
  [3141] = {.lex_state = 203},
  [3142] = {.lex_state = 203},
  [3143] = {.lex_state = 203},
  [3144] = {.lex_state = 203},
  [3145] = {.lex_state = 203},
  [3146] = {.lex_state = 203},
  [3147] = {.lex_state = 203},
  [3148] = {.lex_state = 203},
  [3149] = {.lex_state = 203},
  [3150] = {.lex_state = 203},
  [3151] = {.lex_state = 203},
  [3152] = {.lex_state = 203},
  [3153] = {.lex_state = 203},
  [3154] = {.lex_state = 203},
  [3155] = {.lex_state = 203},
  [3156] = {.lex_state = 203},
  [3157] = {.lex_state = 203},
  [3158] = {.lex_state = 203},
  [3159] = {.lex_state = 203},
  [3160] = {.lex_state = 203},
  [3161] = {.lex_state = 203},
  [3162] = {.lex_state = 203},
  [3163] = {.lex_state = 203},
  [3164] = {.lex_state = 203},
  [3165] = {.lex_state = 203},
  [3166] = {.lex_state = 203, .external_lex_state = 7},
  [3167] = {.lex_state = 203},
  [3168] = {.lex_state = 203},
  [3169] = {.lex_state = 203},
  [3170] = {.lex_state = 203},
  [3171] = {.lex_state = 203},
  [3172] = {.lex_state = 203},
  [3173] = {.lex_state = 203},
  [3174] = {.lex_state = 203},
  [3175] = {.lex_state = 203},
  [3176] = {.lex_state = 203},
  [3177] = {.lex_state = 203},
  [3178] = {.lex_state = 203},
  [3179] = {.lex_state = 203},
  [3180] = {.lex_state = 203},
  [3181] = {.lex_state = 203},
  [3182] = {.lex_state = 203, .external_lex_state = 7},
  [3183] = {.lex_state = 203, .external_lex_state = 7},
  [3184] = {.lex_state = 203, .external_lex_state = 7},
  [3185] = {.lex_state = 203, .external_lex_state = 7},
  [3186] = {.lex_state = 203, .external_lex_state = 7},
  [3187] = {.lex_state = 203, .external_lex_state = 7},
  [3188] = {.lex_state = 203, .external_lex_state = 7},
  [3189] = {.lex_state = 203, .external_lex_state = 7},
  [3190] = {.lex_state = 203},
  [3191] = {.lex_state = 203, .external_lex_state = 7},
  [3192] = {.lex_state = 203, .external_lex_state = 7},
  [3193] = {.lex_state = 203, .external_lex_state = 7},
  [3194] = {.lex_state = 203, .external_lex_state = 7},
  [3195] = {.lex_state = 203, .external_lex_state = 7},
  [3196] = {.lex_state = 203, .external_lex_state = 7},
  [3197] = {.lex_state = 203, .external_lex_state = 7},
  [3198] = {.lex_state = 203, .external_lex_state = 7},
  [3199] = {.lex_state = 203, .external_lex_state = 7},
  [3200] = {.lex_state = 203, .external_lex_state = 7},
  [3201] = {.lex_state = 203, .external_lex_state = 7},
  [3202] = {.lex_state = 203, .external_lex_state = 7},
  [3203] = {.lex_state = 203},
  [3204] = {.lex_state = 203, .external_lex_state = 7},
  [3205] = {.lex_state = 203, .external_lex_state = 7},
  [3206] = {.lex_state = 203, .external_lex_state = 7},
  [3207] = {.lex_state = 203, .external_lex_state = 7},
  [3208] = {.lex_state = 203, .external_lex_state = 7},
  [3209] = {.lex_state = 203, .external_lex_state = 7},
  [3210] = {.lex_state = 203, .external_lex_state = 7},
  [3211] = {.lex_state = 203, .external_lex_state = 7},
  [3212] = {.lex_state = 203, .external_lex_state = 7},
  [3213] = {.lex_state = 203, .external_lex_state = 7},
  [3214] = {.lex_state = 203},
  [3215] = {.lex_state = 203, .external_lex_state = 7},
  [3216] = {.lex_state = 203, .external_lex_state = 7},
  [3217] = {.lex_state = 203, .external_lex_state = 7},
  [3218] = {.lex_state = 203, .external_lex_state = 7},
  [3219] = {.lex_state = 203},
  [3220] = {.lex_state = 203, .external_lex_state = 7},
  [3221] = {.lex_state = 203, .external_lex_state = 7},
  [3222] = {.lex_state = 203, .external_lex_state = 7},
  [3223] = {.lex_state = 203, .external_lex_state = 7},
  [3224] = {.lex_state = 203},
  [3225] = {.lex_state = 203, .external_lex_state = 7},
  [3226] = {.lex_state = 203, .external_lex_state = 7},
  [3227] = {.lex_state = 203, .external_lex_state = 7},
  [3228] = {.lex_state = 203, .external_lex_state = 7},
  [3229] = {.lex_state = 203, .external_lex_state = 7},
  [3230] = {.lex_state = 203, .external_lex_state = 7},
  [3231] = {.lex_state = 203, .external_lex_state = 7},
  [3232] = {.lex_state = 203, .external_lex_state = 7},
  [3233] = {.lex_state = 203, .external_lex_state = 7},
  [3234] = {.lex_state = 203, .external_lex_state = 7},
  [3235] = {.lex_state = 203, .external_lex_state = 7},
  [3236] = {.lex_state = 203, .external_lex_state = 7},
  [3237] = {.lex_state = 203, .external_lex_state = 7},
  [3238] = {.lex_state = 203, .external_lex_state = 7},
  [3239] = {.lex_state = 203, .external_lex_state = 7},
  [3240] = {.lex_state = 203, .external_lex_state = 7},
  [3241] = {.lex_state = 203, .external_lex_state = 7},
  [3242] = {.lex_state = 203, .external_lex_state = 7},
  [3243] = {.lex_state = 203, .external_lex_state = 7},
  [3244] = {.lex_state = 203, .external_lex_state = 7},
  [3245] = {.lex_state = 203, .external_lex_state = 7},
  [3246] = {.lex_state = 203, .external_lex_state = 7},
  [3247] = {.lex_state = 203, .external_lex_state = 7},
  [3248] = {.lex_state = 203, .external_lex_state = 7},
  [3249] = {.lex_state = 203},
  [3250] = {.lex_state = 203, .external_lex_state = 7},
  [3251] = {.lex_state = 203},
  [3252] = {.lex_state = 203},
  [3253] = {.lex_state = 203},
  [3254] = {.lex_state = 203},
  [3255] = {.lex_state = 203},
  [3256] = {.lex_state = 203},
  [3257] = {.lex_state = 203},
  [3258] = {.lex_state = 203},
  [3259] = {.lex_state = 203},
  [3260] = {.lex_state = 203},
  [3261] = {.lex_state = 203},
  [3262] = {.lex_state = 203, .external_lex_state = 7},
  [3263] = {.lex_state = 203, .external_lex_state = 7},
  [3264] = {.lex_state = 203},
  [3265] = {.lex_state = 203, .external_lex_state = 7},
  [3266] = {.lex_state = 203},
  [3267] = {.lex_state = 203},
  [3268] = {.lex_state = 203, .external_lex_state = 7},
  [3269] = {.lex_state = 203, .external_lex_state = 7},
  [3270] = {.lex_state = 203},
  [3271] = {.lex_state = 203, .external_lex_state = 7},
  [3272] = {.lex_state = 203},
  [3273] = {.lex_state = 203},
  [3274] = {.lex_state = 203, .external_lex_state = 7},
  [3275] = {.lex_state = 203},
  [3276] = {.lex_state = 203, .external_lex_state = 7},
  [3277] = {.lex_state = 203, .external_lex_state = 7},
  [3278] = {.lex_state = 203, .external_lex_state = 7},
  [3279] = {.lex_state = 203, .external_lex_state = 7},
  [3280] = {.lex_state = 203, .external_lex_state = 7},
  [3281] = {.lex_state = 203},
  [3282] = {.lex_state = 203, .external_lex_state = 7},
  [3283] = {.lex_state = 0, .external_lex_state = 8},
  [3284] = {.lex_state = 0, .external_lex_state = 8},
  [3285] = {.lex_state = 0, .external_lex_state = 8},
  [3286] = {.lex_state = 183},
  [3287] = {.lex_state = 183},
  [3288] = {.lex_state = 183},
  [3289] = {.lex_state = 183},
  [3290] = {.lex_state = 183},
  [3291] = {.lex_state = 183},
  [3292] = {.lex_state = 0, .external_lex_state = 11},
  [3293] = {.lex_state = 0, .external_lex_state = 11},
  [3294] = {.lex_state = 203},
  [3295] = {.lex_state = 203},
  [3296] = {.lex_state = 203},
  [3297] = {.lex_state = 183},
  [3298] = {.lex_state = 183},
  [3299] = {.lex_state = 203},
  [3300] = {.lex_state = 203},
  [3301] = {.lex_state = 203},
  [3302] = {.lex_state = 183},
  [3303] = {.lex_state = 0, .external_lex_state = 11},
  [3304] = {.lex_state = 183},
  [3305] = {.lex_state = 203, .external_lex_state = 7},
  [3306] = {.lex_state = 203},
  [3307] = {.lex_state = 203},
  [3308] = {.lex_state = 203},
  [3309] = {.lex_state = 203, .external_lex_state = 7},
  [3310] = {.lex_state = 183},
  [3311] = {.lex_state = 203},
  [3312] = {.lex_state = 183},
  [3313] = {.lex_state = 183},
  [3314] = {.lex_state = 183},
  [3315] = {.lex_state = 183},
  [3316] = {.lex_state = 203},
  [3317] = {.lex_state = 203},
  [3318] = {.lex_state = 203},
  [3319] = {.lex_state = 203},
  [3320] = {.lex_state = 183},
  [3321] = {.lex_state = 203},
  [3322] = {.lex_state = 0, .external_lex_state = 11},
  [3323] = {.lex_state = 203},
  [3324] = {.lex_state = 183},
  [3325] = {.lex_state = 0, .external_lex_state = 11},
  [3326] = {.lex_state = 203},
  [3327] = {.lex_state = 183},
  [3328] = {.lex_state = 0, .external_lex_state = 11},
  [3329] = {.lex_state = 203},
  [3330] = {.lex_state = 183},
  [3331] = {.lex_state = 203},
  [3332] = {.lex_state = 183},
  [3333] = {.lex_state = 183},
  [3334] = {.lex_state = 183},
  [3335] = {.lex_state = 0, .external_lex_state = 11},
  [3336] = {.lex_state = 0, .external_lex_state = 11},
  [3337] = {.lex_state = 183},
  [3338] = {.lex_state = 203},
  [3339] = {.lex_state = 183},
  [3340] = {.lex_state = 203},
  [3341] = {.lex_state = 203},
  [3342] = {.lex_state = 183},
  [3343] = {.lex_state = 203},
  [3344] = {.lex_state = 0, .external_lex_state = 11},
  [3345] = {.lex_state = 203},
  [3346] = {.lex_state = 183},
  [3347] = {.lex_state = 183},
  [3348] = {.lex_state = 183},
  [3349] = {.lex_state = 203},
  [3350] = {.lex_state = 203},
  [3351] = {.lex_state = 203},
  [3352] = {.lex_state = 183},
  [3353] = {.lex_state = 203},
  [3354] = {.lex_state = 0, .external_lex_state = 11},
  [3355] = {.lex_state = 183},
  [3356] = {.lex_state = 203},
  [3357] = {.lex_state = 183},
  [3358] = {.lex_state = 203},
  [3359] = {.lex_state = 203},
  [3360] = {.lex_state = 183},
  [3361] = {.lex_state = 183},
  [3362] = {.lex_state = 183},
  [3363] = {.lex_state = 203},
  [3364] = {.lex_state = 183},
  [3365] = {.lex_state = 0, .external_lex_state = 11},
  [3366] = {.lex_state = 0, .external_lex_state = 11},
  [3367] = {.lex_state = 0, .external_lex_state = 11},
  [3368] = {.lex_state = 183},
  [3369] = {.lex_state = 203},
  [3370] = {.lex_state = 183},
  [3371] = {.lex_state = 0, .external_lex_state = 11},
  [3372] = {.lex_state = 1},
  [3373] = {.lex_state = 0},
  [3374] = {.lex_state = 183},
  [3375] = {.lex_state = 0},
  [3376] = {.lex_state = 0},
  [3377] = {.lex_state = 0},
  [3378] = {.lex_state = 185},
  [3379] = {.lex_state = 185},
  [3380] = {.lex_state = 0},
  [3381] = {.lex_state = 0},
  [3382] = {.lex_state = 1},
  [3383] = {.lex_state = 1},
  [3384] = {.lex_state = 185},
  [3385] = {.lex_state = 1},
  [3386] = {.lex_state = 0},
  [3387] = {.lex_state = 1},
  [3388] = {.lex_state = 183},
  [3389] = {.lex_state = 183},
  [3390] = {.lex_state = 185},
  [3391] = {.lex_state = 0},
  [3392] = {.lex_state = 212, .external_lex_state = 7},
  [3393] = {.lex_state = 203},
  [3394] = {.lex_state = 1},
  [3395] = {.lex_state = 0},
  [3396] = {.lex_state = 1},
  [3397] = {.lex_state = 203},
  [3398] = {.lex_state = 183},
  [3399] = {.lex_state = 183},
  [3400] = {.lex_state = 183, .external_lex_state = 7},
  [3401] = {.lex_state = 0},
  [3402] = {.lex_state = 0},
  [3403] = {.lex_state = 185},
  [3404] = {.lex_state = 0},
  [3405] = {.lex_state = 0},
  [3406] = {.lex_state = 205, .external_lex_state = 7},
  [3407] = {.lex_state = 1},
  [3408] = {.lex_state = 183},
  [3409] = {.lex_state = 0},
  [3410] = {.lex_state = 0},
  [3411] = {.lex_state = 1},
  [3412] = {.lex_state = 183},
  [3413] = {.lex_state = 203},
  [3414] = {.lex_state = 185},
  [3415] = {.lex_state = 203},
  [3416] = {.lex_state = 1},
  [3417] = {.lex_state = 212},
  [3418] = {.lex_state = 185},
  [3419] = {.lex_state = 1},
  [3420] = {.lex_state = 185},
  [3421] = {.lex_state = 1},
  [3422] = {.lex_state = 1},
  [3423] = {.lex_state = 183, .external_lex_state = 7},
  [3424] = {.lex_state = 1},
  [3425] = {.lex_state = 185},
  [3426] = {.lex_state = 1},
  [3427] = {.lex_state = 205},
  [3428] = {.lex_state = 183},
  [3429] = {.lex_state = 203, .external_lex_state = 7},
  [3430] = {.lex_state = 0},
  [3431] = {.lex_state = 0},
  [3432] = {.lex_state = 203},
  [3433] = {.lex_state = 203},
  [3434] = {.lex_state = 203},
  [3435] = {.lex_state = 185},
  [3436] = {.lex_state = 1},
  [3437] = {.lex_state = 183},
  [3438] = {.lex_state = 212},
  [3439] = {.lex_state = 203},
  [3440] = {.lex_state = 203},
  [3441] = {.lex_state = 203},
  [3442] = {.lex_state = 1},
  [3443] = {.lex_state = 0},
  [3444] = {.lex_state = 0},
  [3445] = {.lex_state = 1},
  [3446] = {.lex_state = 1},
  [3447] = {.lex_state = 0, .external_lex_state = 2},
  [3448] = {.lex_state = 1},
  [3449] = {.lex_state = 203},
  [3450] = {.lex_state = 212},
  [3451] = {.lex_state = 203},
  [3452] = {.lex_state = 185},
  [3453] = {.lex_state = 203},
  [3454] = {.lex_state = 185},
  [3455] = {.lex_state = 183},
  [3456] = {.lex_state = 183, .external_lex_state = 7},
  [3457] = {.lex_state = 183},
  [3458] = {.lex_state = 1},
  [3459] = {.lex_state = 203},
  [3460] = {.lex_state = 1},
  [3461] = {.lex_state = 185},
  [3462] = {.lex_state = 1},
  [3463] = {.lex_state = 183},
  [3464] = {.lex_state = 0},
  [3465] = {.lex_state = 0},
  [3466] = {.lex_state = 1},
  [3467] = {.lex_state = 185},
  [3468] = {.lex_state = 0},
  [3469] = {.lex_state = 1},
  [3470] = {.lex_state = 185},
  [3471] = {.lex_state = 185},
  [3472] = {.lex_state = 0},
  [3473] = {.lex_state = 185},
  [3474] = {.lex_state = 203},
  [3475] = {.lex_state = 183},
  [3476] = {.lex_state = 1},
  [3477] = {.lex_state = 0},
  [3478] = {.lex_state = 1},
  [3479] = {.lex_state = 0},
  [3480] = {.lex_state = 0},
  [3481] = {.lex_state = 0, .external_lex_state = 2},
  [3482] = {.lex_state = 0},
  [3483] = {.lex_state = 0},
  [3484] = {.lex_state = 0},
  [3485] = {.lex_state = 203},
  [3486] = {.lex_state = 203},
  [3487] = {.lex_state = 1},
  [3488] = {.lex_state = 203},
  [3489] = {.lex_state = 183},
  [3490] = {.lex_state = 0},
  [3491] = {.lex_state = 1},
  [3492] = {.lex_state = 0, .external_lex_state = 7},
  [3493] = {.lex_state = 212},
  [3494] = {.lex_state = 212},
  [3495] = {.lex_state = 0, .external_lex_state = 10},
  [3496] = {.lex_state = 203},
  [3497] = {.lex_state = 212},
  [3498] = {.lex_state = 203},
  [3499] = {.lex_state = 212},
  [3500] = {.lex_state = 203},
  [3501] = {.lex_state = 212},
  [3502] = {.lex_state = 0, .external_lex_state = 9},
  [3503] = {.lex_state = 0, .external_lex_state = 10},
  [3504] = {.lex_state = 0, .external_lex_state = 9},
  [3505] = {.lex_state = 212},
  [3506] = {.lex_state = 212},
  [3507] = {.lex_state = 0, .external_lex_state = 10},
  [3508] = {.lex_state = 203},
  [3509] = {.lex_state = 0, .external_lex_state = 9},
  [3510] = {.lex_state = 0, .external_lex_state = 10},
  [3511] = {.lex_state = 0, .external_lex_state = 9},
  [3512] = {.lex_state = 183, .external_lex_state = 7},
  [3513] = {.lex_state = 203},
  [3514] = {.lex_state = 0, .external_lex_state = 10},
  [3515] = {.lex_state = 212},
  [3516] = {.lex_state = 203},
  [3517] = {.lex_state = 0, .external_lex_state = 9},
  [3518] = {.lex_state = 0, .external_lex_state = 10},
  [3519] = {.lex_state = 0, .external_lex_state = 10},
  [3520] = {.lex_state = 0, .external_lex_state = 9},
  [3521] = {.lex_state = 212},
  [3522] = {.lex_state = 203},
  [3523] = {.lex_state = 212},
  [3524] = {.lex_state = 0, .external_lex_state = 9},
  [3525] = {.lex_state = 212},
  [3526] = {.lex_state = 203},
  [3527] = {.lex_state = 0, .external_lex_state = 9},
  [3528] = {.lex_state = 203, .external_lex_state = 7},
  [3529] = {.lex_state = 0, .external_lex_state = 9},
  [3530] = {.lex_state = 212},
  [3531] = {.lex_state = 0, .external_lex_state = 9},
  [3532] = {.lex_state = 0, .external_lex_state = 10},
  [3533] = {.lex_state = 203},
  [3534] = {.lex_state = 0, .external_lex_state = 10},
  [3535] = {.lex_state = 203},
  [3536] = {.lex_state = 0, .external_lex_state = 10},
  [3537] = {.lex_state = 0, .external_lex_state = 9},
  [3538] = {.lex_state = 0, .external_lex_state = 10},
  [3539] = {.lex_state = 203},
  [3540] = {.lex_state = 0, .external_lex_state = 10},
  [3541] = {.lex_state = 0, .external_lex_state = 9},
  [3542] = {.lex_state = 212},
  [3543] = {.lex_state = 203},
  [3544] = {.lex_state = 185},
  [3545] = {.lex_state = 0, .external_lex_state = 7},
  [3546] = {.lex_state = 212},
  [3547] = {.lex_state = 0, .external_lex_state = 7},
  [3548] = {.lex_state = 203, .external_lex_state = 7},
  [3549] = {.lex_state = 203, .external_lex_state = 7},
  [3550] = {.lex_state = 203},
  [3551] = {.lex_state = 0, .external_lex_state = 7},
  [3552] = {.lex_state = 203},
  [3553] = {.lex_state = 0, .external_lex_state = 10},
  [3554] = {.lex_state = 0, .external_lex_state = 9},
  [3555] = {.lex_state = 0, .external_lex_state = 9},
  [3556] = {.lex_state = 183, .external_lex_state = 7},
  [3557] = {.lex_state = 183, .external_lex_state = 7},
  [3558] = {.lex_state = 0},
  [3559] = {.lex_state = 212},
  [3560] = {.lex_state = 0, .external_lex_state = 7},
  [3561] = {.lex_state = 212},
  [3562] = {.lex_state = 0},
  [3563] = {.lex_state = 0, .external_lex_state = 7},
  [3564] = {.lex_state = 0, .external_lex_state = 7},
  [3565] = {.lex_state = 0, .external_lex_state = 12},
  [3566] = {.lex_state = 212},
  [3567] = {.lex_state = 0, .external_lex_state = 12},
  [3568] = {.lex_state = 0, .external_lex_state = 9},
  [3569] = {.lex_state = 0, .external_lex_state = 10},
  [3570] = {.lex_state = 203},
  [3571] = {.lex_state = 0, .external_lex_state = 7},
  [3572] = {.lex_state = 203},
  [3573] = {.lex_state = 0, .external_lex_state = 10},
  [3574] = {.lex_state = 0},
  [3575] = {.lex_state = 203},
  [3576] = {.lex_state = 0},
  [3577] = {.lex_state = 203},
  [3578] = {.lex_state = 205},
  [3579] = {.lex_state = 0},
  [3580] = {.lex_state = 0},
  [3581] = {.lex_state = 0},
  [3582] = {.lex_state = 212},
  [3583] = {.lex_state = 205},
  [3584] = {.lex_state = 0},
  [3585] = {.lex_state = 203},
  [3586] = {.lex_state = 0},
  [3587] = {.lex_state = 0},
  [3588] = {.lex_state = 0},
  [3589] = {.lex_state = 0},
  [3590] = {.lex_state = 0},
  [3591] = {.lex_state = 203},
  [3592] = {.lex_state = 205},
  [3593] = {.lex_state = 0},
  [3594] = {.lex_state = 203},
  [3595] = {.lex_state = 0},
  [3596] = {.lex_state = 0},
  [3597] = {.lex_state = 203},
  [3598] = {.lex_state = 203},
  [3599] = {.lex_state = 212},
  [3600] = {.lex_state = 0},
  [3601] = {.lex_state = 0},
  [3602] = {.lex_state = 203},
  [3603] = {.lex_state = 0},
  [3604] = {.lex_state = 0},
  [3605] = {.lex_state = 0},
  [3606] = {.lex_state = 203},
  [3607] = {.lex_state = 203},
  [3608] = {.lex_state = 0},
  [3609] = {.lex_state = 0},
  [3610] = {.lex_state = 205},
  [3611] = {.lex_state = 0},
  [3612] = {.lex_state = 0},
  [3613] = {.lex_state = 0},
  [3614] = {.lex_state = 0},
  [3615] = {.lex_state = 0},
  [3616] = {.lex_state = 205},
  [3617] = {.lex_state = 205},
  [3618] = {.lex_state = 0},
  [3619] = {.lex_state = 0},
  [3620] = {.lex_state = 0},
  [3621] = {.lex_state = 203},
  [3622] = {.lex_state = 203},
  [3623] = {.lex_state = 0, .external_lex_state = 7},
  [3624] = {.lex_state = 0},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 0},
  [3627] = {.lex_state = 205},
  [3628] = {.lex_state = 0},
  [3629] = {.lex_state = 212},
  [3630] = {.lex_state = 0},
  [3631] = {.lex_state = 0},
  [3632] = {.lex_state = 203},
  [3633] = {.lex_state = 1},
  [3634] = {.lex_state = 0},
  [3635] = {.lex_state = 0},
  [3636] = {.lex_state = 0},
  [3637] = {.lex_state = 0},
  [3638] = {.lex_state = 203},
  [3639] = {.lex_state = 205},
  [3640] = {.lex_state = 212},
  [3641] = {.lex_state = 203},
  [3642] = {.lex_state = 212},
  [3643] = {.lex_state = 0},
  [3644] = {.lex_state = 0, .external_lex_state = 7},
  [3645] = {.lex_state = 0, .external_lex_state = 7},
  [3646] = {.lex_state = 192},
  [3647] = {.lex_state = 0},
  [3648] = {.lex_state = 0},
  [3649] = {.lex_state = 0},
  [3650] = {.lex_state = 205},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 0},
  [3653] = {.lex_state = 0, .external_lex_state = 7},
  [3654] = {.lex_state = 0},
  [3655] = {.lex_state = 0},
  [3656] = {.lex_state = 205},
  [3657] = {.lex_state = 203},
  [3658] = {.lex_state = 203},
  [3659] = {.lex_state = 203},
  [3660] = {.lex_state = 205},
  [3661] = {.lex_state = 0},
  [3662] = {.lex_state = 0},
  [3663] = {.lex_state = 0},
  [3664] = {.lex_state = 192},
  [3665] = {.lex_state = 0},
  [3666] = {.lex_state = 203},
  [3667] = {.lex_state = 203},
  [3668] = {.lex_state = 0},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 203},
  [3671] = {.lex_state = 203},
  [3672] = {.lex_state = 0},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 0},
  [3675] = {.lex_state = 203},
  [3676] = {.lex_state = 203},
  [3677] = {.lex_state = 205},
  [3678] = {.lex_state = 0},
  [3679] = {.lex_state = 0, .external_lex_state = 7},
  [3680] = {.lex_state = 212},
  [3681] = {.lex_state = 0},
  [3682] = {.lex_state = 0, .external_lex_state = 7},
  [3683] = {.lex_state = 0},
  [3684] = {.lex_state = 0},
  [3685] = {.lex_state = 0},
  [3686] = {.lex_state = 0},
  [3687] = {.lex_state = 0},
  [3688] = {.lex_state = 205},
  [3689] = {.lex_state = 0},
  [3690] = {.lex_state = 0},
  [3691] = {.lex_state = 0},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 205},
  [3694] = {.lex_state = 0},
  [3695] = {.lex_state = 0},
  [3696] = {.lex_state = 0, .external_lex_state = 7},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 0},
  [3699] = {.lex_state = 0},
  [3700] = {.lex_state = 205},
  [3701] = {.lex_state = 0},
  [3702] = {.lex_state = 0},
  [3703] = {.lex_state = 205},
  [3704] = {.lex_state = 0},
  [3705] = {.lex_state = 203},
  [3706] = {.lex_state = 0},
  [3707] = {.lex_state = 0},
  [3708] = {.lex_state = 0},
  [3709] = {.lex_state = 203},
  [3710] = {.lex_state = 203},
  [3711] = {.lex_state = 0},
  [3712] = {.lex_state = 0},
  [3713] = {.lex_state = 0},
  [3714] = {.lex_state = 0},
  [3715] = {.lex_state = 0},
  [3716] = {.lex_state = 0},
  [3717] = {.lex_state = 0},
  [3718] = {.lex_state = 212},
  [3719] = {.lex_state = 205},
  [3720] = {.lex_state = 0},
  [3721] = {.lex_state = 203},
  [3722] = {.lex_state = 205},
  [3723] = {.lex_state = 203},
  [3724] = {.lex_state = 203},
  [3725] = {.lex_state = 203},
  [3726] = {.lex_state = 205},
  [3727] = {.lex_state = 212},
  [3728] = {.lex_state = 203},
  [3729] = {.lex_state = 0},
  [3730] = {.lex_state = 0},
  [3731] = {.lex_state = 0},
  [3732] = {.lex_state = 203},
  [3733] = {.lex_state = 0},
  [3734] = {.lex_state = 205},
  [3735] = {.lex_state = 0},
  [3736] = {.lex_state = 0},
  [3737] = {.lex_state = 0},
  [3738] = {.lex_state = 0, .external_lex_state = 7},
  [3739] = {.lex_state = 205},
  [3740] = {.lex_state = 183},
  [3741] = {.lex_state = 192},
  [3742] = {.lex_state = 203},
  [3743] = {.lex_state = 0},
  [3744] = {.lex_state = 205},
  [3745] = {.lex_state = 0},
  [3746] = {.lex_state = 0},
  [3747] = {.lex_state = 0},
  [3748] = {.lex_state = 0},
  [3749] = {.lex_state = 0},
  [3750] = {.lex_state = 0},
  [3751] = {.lex_state = 205},
  [3752] = {.lex_state = 203},
  [3753] = {.lex_state = 203},
  [3754] = {.lex_state = 0},
  [3755] = {.lex_state = 0},
  [3756] = {.lex_state = 0, .external_lex_state = 7},
  [3757] = {.lex_state = 0, .external_lex_state = 7},
  [3758] = {.lex_state = 0},
  [3759] = {.lex_state = 183},
  [3760] = {.lex_state = 0},
  [3761] = {.lex_state = 0},
  [3762] = {.lex_state = 0},
  [3763] = {.lex_state = 0},
  [3764] = {.lex_state = 203},
  [3765] = {.lex_state = 203},
  [3766] = {.lex_state = 205},
  [3767] = {.lex_state = 0},
  [3768] = {.lex_state = 212},
  [3769] = {.lex_state = 0},
  [3770] = {.lex_state = 0},
  [3771] = {.lex_state = 205},
  [3772] = {.lex_state = 0},
  [3773] = {.lex_state = 0},
  [3774] = {.lex_state = 0},
  [3775] = {.lex_state = 205},
  [3776] = {.lex_state = 203},
  [3777] = {.lex_state = 212},
  [3778] = {.lex_state = 0},
  [3779] = {.lex_state = 0},
  [3780] = {.lex_state = 0},
  [3781] = {.lex_state = 0},
  [3782] = {.lex_state = 203},
  [3783] = {.lex_state = 205},
  [3784] = {.lex_state = 205},
  [3785] = {.lex_state = 0},
  [3786] = {.lex_state = 203},
  [3787] = {.lex_state = 212},
  [3788] = {.lex_state = 0},
  [3789] = {.lex_state = 183},
  [3790] = {.lex_state = 0},
  [3791] = {.lex_state = 0},
  [3792] = {.lex_state = 0},
  [3793] = {.lex_state = 0},
  [3794] = {.lex_state = 0},
  [3795] = {.lex_state = 0, .external_lex_state = 7},
  [3796] = {.lex_state = 203},
  [3797] = {.lex_state = 203},
  [3798] = {.lex_state = 0},
  [3799] = {.lex_state = 205},
  [3800] = {.lex_state = 212},
  [3801] = {.lex_state = 0},
  [3802] = {.lex_state = 0},
  [3803] = {.lex_state = 0},
  [3804] = {.lex_state = 0},
  [3805] = {.lex_state = 203},
  [3806] = {.lex_state = 183},
  [3807] = {.lex_state = 0},
  [3808] = {.lex_state = 0},
  [3809] = {.lex_state = 0},
  [3810] = {.lex_state = 203},
  [3811] = {.lex_state = 203},
  [3812] = {.lex_state = 183},
  [3813] = {.lex_state = 183},
  [3814] = {.lex_state = 183},
  [3815] = {.lex_state = 0},
  [3816] = {.lex_state = 212},
  [3817] = {.lex_state = 0},
  [3818] = {.lex_state = 0},
  [3819] = {.lex_state = 203},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 203},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 203},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 205},
  [3826] = {.lex_state = 192},
  [3827] = {.lex_state = 0},
  [3828] = {.lex_state = 0},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 205},
  [3833] = {.lex_state = 0},
  [3834] = {.lex_state = 0},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 0},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 0},
  [3839] = {.lex_state = 203},
  [3840] = {.lex_state = 192},
  [3841] = {.lex_state = 203},
  [3842] = {.lex_state = 0},
  [3843] = {.lex_state = 0},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 0},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 192},
  [3848] = {.lex_state = 203},
  [3849] = {.lex_state = 203},
  [3850] = {.lex_state = 0},
  [3851] = {.lex_state = 0},
  [3852] = {.lex_state = 0},
  [3853] = {.lex_state = 212},
  [3854] = {.lex_state = 0},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 205},
  [3857] = {.lex_state = 205},
  [3858] = {.lex_state = 203},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 192},
  [3861] = {.lex_state = 0},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 203},
  [3864] = {.lex_state = 205},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 203},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 0, .external_lex_state = 7},
  [3869] = {.lex_state = 0},
  [3870] = {.lex_state = 0},
  [3871] = {.lex_state = 0},
  [3872] = {.lex_state = 205},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 203},
  [3875] = {.lex_state = 0},
  [3876] = {.lex_state = 203},
  [3877] = {.lex_state = 203},
  [3878] = {.lex_state = 183},
  [3879] = {.lex_state = 0},
  [3880] = {.lex_state = 0},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 203},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 203},
  [3890] = {.lex_state = 0},
  [3891] = {.lex_state = 212},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 0},
  [3894] = {.lex_state = 0},
  [3895] = {.lex_state = 0},
  [3896] = {.lex_state = 0},
  [3897] = {.lex_state = 0},
  [3898] = {.lex_state = 205},
  [3899] = {.lex_state = 0},
  [3900] = {.lex_state = 203},
  [3901] = {.lex_state = 0},
  [3902] = {.lex_state = 0},
  [3903] = {.lex_state = 205},
  [3904] = {.lex_state = 0},
  [3905] = {.lex_state = 0},
  [3906] = {.lex_state = 203},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 0},
  [3909] = {.lex_state = 192},
  [3910] = {.lex_state = 0},
  [3911] = {.lex_state = 192},
  [3912] = {.lex_state = 0},
  [3913] = {.lex_state = 205},
  [3914] = {.lex_state = 0},
  [3915] = {.lex_state = 203},
  [3916] = {.lex_state = 203},
  [3917] = {.lex_state = 203},
  [3918] = {.lex_state = 203},
  [3919] = {.lex_state = 0},
  [3920] = {.lex_state = 0},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 0},
  [3923] = {.lex_state = 203},
  [3924] = {.lex_state = 0, .external_lex_state = 2},
  [3925] = {.lex_state = 192},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 203},
  [3930] = {.lex_state = 183},
  [3931] = {.lex_state = 203},
  [3932] = {.lex_state = 0},
  [3933] = {.lex_state = 0},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 203},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 203},
  [3938] = {.lex_state = 0},
  [3939] = {.lex_state = 0},
  [3940] = {.lex_state = 0},
  [3941] = {.lex_state = 205},
  [3942] = {.lex_state = 192},
  [3943] = {.lex_state = 192},
  [3944] = {.lex_state = 203},
  [3945] = {.lex_state = 0},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 0},
  [3948] = {.lex_state = 0},
  [3949] = {.lex_state = 192},
  [3950] = {.lex_state = 0},
  [3951] = {.lex_state = 0},
  [3952] = {.lex_state = 0, .external_lex_state = 2},
  [3953] = {.lex_state = 203},
  [3954] = {.lex_state = 0},
  [3955] = {.lex_state = 0, .external_lex_state = 2},
  [3956] = {.lex_state = 0},
  [3957] = {.lex_state = 205},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 192},
  [3960] = {.lex_state = 203},
  [3961] = {.lex_state = 203},
  [3962] = {.lex_state = 192},
  [3963] = {.lex_state = 192},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 203},
  [3966] = {.lex_state = 203},
  [3967] = {.lex_state = 1},
  [3968] = {.lex_state = 203},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 203},
  [3971] = {.lex_state = 203},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 0},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 0, .external_lex_state = 2},
  [3978] = {.lex_state = 192},
  [3979] = {.lex_state = 0},
  [3980] = {.lex_state = 203},
  [3981] = {.lex_state = 203},
  [3982] = {.lex_state = 192},
  [3983] = {.lex_state = 192},
  [3984] = {.lex_state = 0, .external_lex_state = 2},
  [3985] = {.lex_state = 192},
  [3986] = {.lex_state = 192},
  [3987] = {.lex_state = 205},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 0},
  [3991] = {.lex_state = 212},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 0},
  [3995] = {.lex_state = 0},
  [3996] = {.lex_state = 203},
  [3997] = {.lex_state = 203},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0, .external_lex_state = 10},
  [4000] = {.lex_state = 0, .external_lex_state = 9},
  [4001] = {.lex_state = 203},
  [4002] = {.lex_state = 203},
  [4003] = {.lex_state = 183},
  [4004] = {.lex_state = 212},
  [4005] = {.lex_state = 183},
  [4006] = {.lex_state = 183},
  [4007] = {.lex_state = 183},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 203},
  [4010] = {.lex_state = 203},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 203},
  [4013] = {.lex_state = 203},
  [4014] = {.lex_state = 203},
  [4015] = {.lex_state = 212},
  [4016] = {.lex_state = 203},
  [4017] = {.lex_state = 183},
  [4018] = {.lex_state = 203},
  [4019] = {.lex_state = 203},
  [4020] = {.lex_state = 203},
  [4021] = {.lex_state = 203},
  [4022] = {.lex_state = 203},
  [4023] = {.lex_state = 203},
  [4024] = {.lex_state = 203},
  [4025] = {.lex_state = 212},
  [4026] = {.lex_state = 203},
  [4027] = {.lex_state = 203},
  [4028] = {.lex_state = 203},
  [4029] = {.lex_state = 203},
  [4030] = {.lex_state = 203},
  [4031] = {.lex_state = 203},
  [4032] = {.lex_state = 203},
  [4033] = {.lex_state = 203},
  [4034] = {.lex_state = 203},
  [4035] = {.lex_state = 203},
  [4036] = {.lex_state = 183, .external_lex_state = 7},
  [4037] = {.lex_state = 0, .external_lex_state = 7},
  [4038] = {.lex_state = 203},
  [4039] = {.lex_state = 0, .external_lex_state = 7},
  [4040] = {.lex_state = 203},
  [4041] = {.lex_state = 203},
  [4042] = {.lex_state = 203},
  [4043] = {.lex_state = 203},
  [4044] = {.lex_state = 203},
  [4045] = {.lex_state = 203},
  [4046] = {.lex_state = 203},
  [4047] = {.lex_state = 203},
  [4048] = {.lex_state = 203},
  [4049] = {.lex_state = 192},
  [4050] = {.lex_state = 205},
  [4051] = {.lex_state = 203},
  [4052] = {.lex_state = 192},
  [4053] = {.lex_state = 192},
  [4054] = {.lex_state = 183},
  [4055] = {.lex_state = 205},
  [4056] = {.lex_state = 183},
  [4057] = {.lex_state = 183},
  [4058] = {.lex_state = 203},
  [4059] = {.lex_state = 183},
  [4060] = {.lex_state = 2},
  [4061] = {.lex_state = 203},
  [4062] = {.lex_state = 203},
  [4063] = {.lex_state = 183},
  [4064] = {.lex_state = 203},
  [4065] = {.lex_state = 183},
  [4066] = {.lex_state = 205},
  [4067] = {.lex_state = 205},
  [4068] = {.lex_state = 183},
  [4069] = {.lex_state = 183},
  [4070] = {.lex_state = 205},
  [4071] = {.lex_state = 183},
  [4072] = {.lex_state = 183},
  [4073] = {.lex_state = 203},
  [4074] = {.lex_state = 209},
  [4075] = {.lex_state = 205},
  [4076] = {.lex_state = 183},
  [4077] = {.lex_state = 183},
  [4078] = {.lex_state = 203},
  [4079] = {.lex_state = 203},
  [4080] = {.lex_state = 205},
  [4081] = {.lex_state = 183},
  [4082] = {.lex_state = 0, .external_lex_state = 7},
  [4083] = {.lex_state = 205},
  [4084] = {.lex_state = 183},
  [4085] = {.lex_state = 192},
  [4086] = {.lex_state = 205},
  [4087] = {.lex_state = 210},
  [4088] = {.lex_state = 183},
  [4089] = {.lex_state = 183},
  [4090] = {.lex_state = 183},
  [4091] = {.lex_state = 183},
  [4092] = {.lex_state = 183},
  [4093] = {.lex_state = 205},
  [4094] = {.lex_state = 205},
  [4095] = {.lex_state = 183},
  [4096] = {.lex_state = 183},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 192},
  [4099] = {.lex_state = 205},
  [4100] = {.lex_state = 183},
  [4101] = {.lex_state = 0, .external_lex_state = 7},
  [4102] = {.lex_state = 205},
  [4103] = {.lex_state = 183},
  [4104] = {.lex_state = 203},
  [4105] = {.lex_state = 499},
  [4106] = {.lex_state = 0, .external_lex_state = 7},
  [4107] = {.lex_state = 183},
  [4108] = {.lex_state = 203},
  [4109] = {.lex_state = 203},
  [4110] = {.lex_state = 183},
  [4111] = {.lex_state = 0, .external_lex_state = 7},
  [4112] = {.lex_state = 205},
  [4113] = {.lex_state = 205},
  [4114] = {.lex_state = 183},
  [4115] = {.lex_state = 183},
  [4116] = {.lex_state = 183},
  [4117] = {.lex_state = 499},
  [4118] = {.lex_state = 500},
  [4119] = {.lex_state = 0, .external_lex_state = 7},
  [4120] = {.lex_state = 0, .external_lex_state = 7},
  [4121] = {.lex_state = 203},
  [4122] = {.lex_state = 0, .external_lex_state = 7},
  [4123] = {.lex_state = 183},
  [4124] = {.lex_state = 192},
  [4125] = {.lex_state = 205},
  [4126] = {.lex_state = 183},
  [4127] = {.lex_state = 183},
  [4128] = {.lex_state = 183},
  [4129] = {.lex_state = 183},
  [4130] = {.lex_state = 183},
  [4131] = {.lex_state = 0, .external_lex_state = 7},
  [4132] = {.lex_state = 0, .external_lex_state = 7},
  [4133] = {.lex_state = 203},
  [4134] = {.lex_state = 209},
  [4135] = {.lex_state = 0, .external_lex_state = 7},
  [4136] = {.lex_state = 0, .external_lex_state = 7},
  [4137] = {.lex_state = 203},
  [4138] = {.lex_state = 203},
  [4139] = {.lex_state = 0, .external_lex_state = 7},
  [4140] = {.lex_state = 0, .external_lex_state = 7},
  [4141] = {.lex_state = 209},
  [4142] = {.lex_state = 205},
  [4143] = {.lex_state = 0, .external_lex_state = 7},
  [4144] = {.lex_state = 192},
  [4145] = {.lex_state = 0, .external_lex_state = 7},
  [4146] = {.lex_state = 183},
  [4147] = {.lex_state = 194},
  [4148] = {.lex_state = 197},
  [4149] = {.lex_state = 192},
  [4150] = {.lex_state = 0, .external_lex_state = 7},
  [4151] = {.lex_state = 0, .external_lex_state = 7},
  [4152] = {.lex_state = 0, .external_lex_state = 7},
  [4153] = {.lex_state = 203},
  [4154] = {.lex_state = 0, .external_lex_state = 7},
  [4155] = {.lex_state = 209},
  [4156] = {.lex_state = 183},
  [4157] = {.lex_state = 203},
  [4158] = {.lex_state = 203},
  [4159] = {.lex_state = 192},
  [4160] = {.lex_state = 0, .external_lex_state = 7},
  [4161] = {.lex_state = 192},
  [4162] = {.lex_state = 192},
  [4163] = {.lex_state = 192},
  [4164] = {.lex_state = 194},
  [4165] = {.lex_state = 203},
  [4166] = {.lex_state = 197},
  [4167] = {.lex_state = 192},
  [4168] = {.lex_state = 192},
  [4169] = {.lex_state = 203},
  [4170] = {.lex_state = 203},
  [4171] = {.lex_state = 192},
  [4172] = {.lex_state = 192},
  [4173] = {.lex_state = 209},
  [4174] = {.lex_state = 192},
  [4175] = {.lex_state = 183},
  [4176] = {.lex_state = 194},
  [4177] = {.lex_state = 203},
  [4178] = {.lex_state = 197},
  [4179] = {.lex_state = 192},
  [4180] = {.lex_state = 209},
  [4181] = {.lex_state = 203},
  [4182] = {.lex_state = 203},
  [4183] = {.lex_state = 183},
  [4184] = {.lex_state = 192},
  [4185] = {.lex_state = 194},
  [4186] = {.lex_state = 197},
  [4187] = {.lex_state = 192},
  [4188] = {.lex_state = 192},
  [4189] = {.lex_state = 203},
  [4190] = {.lex_state = 192},
  [4191] = {.lex_state = 209},
  [4192] = {.lex_state = 183},
  [4193] = {.lex_state = 203},
  [4194] = {.lex_state = 203},
  [4195] = {.lex_state = 194},
  [4196] = {.lex_state = 197},
  [4197] = {.lex_state = 192},
  [4198] = {.lex_state = 192},
  [4199] = {.lex_state = 192},
  [4200] = {.lex_state = 192},
  [4201] = {.lex_state = 203},
  [4202] = {.lex_state = 192},
  [4203] = {.lex_state = 192},
  [4204] = {.lex_state = 192},
  [4205] = {.lex_state = 203},
  [4206] = {.lex_state = 203},
  [4207] = {.lex_state = 192},
  [4208] = {.lex_state = 192},
  [4209] = {.lex_state = 192},
  [4210] = {.lex_state = 209},
  [4211] = {.lex_state = 192},
  [4212] = {.lex_state = 192},
  [4213] = {.lex_state = 203},
  [4214] = {.lex_state = 183},
  [4215] = {.lex_state = 192},
  [4216] = {.lex_state = 192},
  [4217] = {.lex_state = 203},
  [4218] = {.lex_state = 203},
  [4219] = {.lex_state = 192},
  [4220] = {.lex_state = 192},
  [4221] = {.lex_state = 192},
  [4222] = {.lex_state = 192},
  [4223] = {.lex_state = 194},
  [4224] = {.lex_state = 197},
  [4225] = {.lex_state = 203},
  [4226] = {.lex_state = 192},
  [4227] = {.lex_state = 192},
  [4228] = {.lex_state = 192},
  [4229] = {.lex_state = 203},
  [4230] = {.lex_state = 203},
  [4231] = {.lex_state = 192},
  [4232] = {.lex_state = 0, .external_lex_state = 13},
  [4233] = {.lex_state = 192},
  [4234] = {.lex_state = 192},
  [4235] = {.lex_state = 192},
  [4236] = {.lex_state = 192},
  [4237] = {.lex_state = 203},
  [4238] = {.lex_state = 192},
  [4239] = {.lex_state = 192},
  [4240] = {.lex_state = 192},
  [4241] = {.lex_state = 203},
  [4242] = {.lex_state = 203},
  [4243] = {.lex_state = 192},
  [4244] = {.lex_state = 192},
  [4245] = {.lex_state = 192},
  [4246] = {.lex_state = 192},
  [4247] = {.lex_state = 192},
  [4248] = {.lex_state = 192},
  [4249] = {.lex_state = 203},
  [4250] = {.lex_state = 209},
  [4251] = {.lex_state = 192},
  [4252] = {.lex_state = 192},
  [4253] = {.lex_state = 203},
  [4254] = {.lex_state = 203},
  [4255] = {.lex_state = 183},
  [4256] = {.lex_state = 192},
  [4257] = {.lex_state = 192},
  [4258] = {.lex_state = 192},
  [4259] = {.lex_state = 192},
  [4260] = {.lex_state = 192},
  [4261] = {.lex_state = 203},
  [4262] = {.lex_state = 192},
  [4263] = {.lex_state = 192},
  [4264] = {.lex_state = 194},
  [4265] = {.lex_state = 203},
  [4266] = {.lex_state = 203},
  [4267] = {.lex_state = 197},
  [4268] = {.lex_state = 192},
  [4269] = {.lex_state = 192},
  [4270] = {.lex_state = 192},
  [4271] = {.lex_state = 192},
  [4272] = {.lex_state = 203},
  [4273] = {.lex_state = 203},
  [4274] = {.lex_state = 192},
  [4275] = {.lex_state = 192},
  [4276] = {.lex_state = 192},
  [4277] = {.lex_state = 203},
  [4278] = {.lex_state = 203},
  [4279] = {.lex_state = 192},
  [4280] = {.lex_state = 194},
  [4281] = {.lex_state = 192},
  [4282] = {.lex_state = 197},
  [4283] = {.lex_state = 192},
  [4284] = {.lex_state = 192},
  [4285] = {.lex_state = 203},
  [4286] = {.lex_state = 192},
  [4287] = {.lex_state = 192},
  [4288] = {.lex_state = 192},
  [4289] = {.lex_state = 203},
  [4290] = {.lex_state = 203},
  [4291] = {.lex_state = 192},
  [4292] = {.lex_state = 192},
  [4293] = {.lex_state = 203},
  [4294] = {.lex_state = 209},
  [4295] = {.lex_state = 203},
  [4296] = {.lex_state = 203},
  [4297] = {.lex_state = 183},
  [4298] = {.lex_state = 203},
  [4299] = {.lex_state = 203},
  [4300] = {.lex_state = 203},
  [4301] = {.lex_state = 183},
  [4302] = {.lex_state = 203},
  [4303] = {.lex_state = 183},
  [4304] = {.lex_state = 203},
  [4305] = {.lex_state = 203},
  [4306] = {.lex_state = 203},
  [4307] = {.lex_state = 194},
  [4308] = {.lex_state = 210},
  [4309] = {.lex_state = 197},
  [4310] = {.lex_state = 192},
  [4311] = {.lex_state = 203},
  [4312] = {.lex_state = 203},
  [4313] = {.lex_state = 183},
  [4314] = {.lex_state = 203},
  [4315] = {.lex_state = 203},
  [4316] = {.lex_state = 203},
  [4317] = {.lex_state = 203},
  [4318] = {.lex_state = 203},
  [4319] = {.lex_state = 203},
  [4320] = {.lex_state = 203},
  [4321] = {.lex_state = 203},
  [4322] = {.lex_state = 203},
  [4323] = {.lex_state = 203},
  [4324] = {.lex_state = 203},
  [4325] = {.lex_state = 203},
  [4326] = {.lex_state = 209},
  [4327] = {.lex_state = 183},
  [4328] = {.lex_state = 209},
  [4329] = {.lex_state = 203},
  [4330] = {.lex_state = 183},
  [4331] = {.lex_state = 183},
  [4332] = {.lex_state = 194},
  [4333] = {.lex_state = 183},
  [4334] = {.lex_state = 197},
  [4335] = {.lex_state = 192},
  [4336] = {.lex_state = 209},
  [4337] = {.lex_state = 183},
  [4338] = {.lex_state = 194},
  [4339] = {.lex_state = 197},
  [4340] = {.lex_state = 500},
  [4341] = {.lex_state = 183},
  [4342] = {.lex_state = 194},
  [4343] = {.lex_state = 0},
  [4344] = {.lex_state = 197},
  [4345] = {.lex_state = 192},
  [4346] = {.lex_state = 203},
  [4347] = {.lex_state = 183},
  [4348] = {.lex_state = 203},
  [4349] = {.lex_state = 203},
  [4350] = {.lex_state = 203},
  [4351] = {.lex_state = 203},
  [4352] = {.lex_state = 209},
  [4353] = {.lex_state = 0},
  [4354] = {.lex_state = 183},
  [4355] = {.lex_state = 203},
  [4356] = {.lex_state = 183},
  [4357] = {.lex_state = 194},
  [4358] = {.lex_state = 197},
  [4359] = {.lex_state = 203},
  [4360] = {.lex_state = 203},
  [4361] = {.lex_state = 192},
  [4362] = {.lex_state = 183},
  [4363] = {.lex_state = 203},
  [4364] = {.lex_state = 203},
  [4365] = {.lex_state = 183},
  [4366] = {.lex_state = 203},
  [4367] = {.lex_state = 203},
  [4368] = {.lex_state = 209},
  [4369] = {.lex_state = 203},
  [4370] = {.lex_state = 203},
  [4371] = {.lex_state = 192},
  [4372] = {.lex_state = 203},
  [4373] = {.lex_state = 203},
  [4374] = {.lex_state = 183},
  [4375] = {.lex_state = 203},
  [4376] = {.lex_state = 203},
  [4377] = {.lex_state = 183},
  [4378] = {.lex_state = 203},
  [4379] = {.lex_state = 203},
  [4380] = {.lex_state = 183},
  [4381] = {.lex_state = 203},
  [4382] = {.lex_state = 203},
  [4383] = {.lex_state = 192},
  [4384] = {.lex_state = 203},
  [4385] = {.lex_state = 203},
  [4386] = {.lex_state = 203},
  [4387] = {.lex_state = 203},
  [4388] = {.lex_state = 203},
  [4389] = {.lex_state = 194},
  [4390] = {.lex_state = 203},
  [4391] = {.lex_state = 203},
  [4392] = {.lex_state = 197},
  [4393] = {.lex_state = 203},
  [4394] = {.lex_state = 203},
  [4395] = {.lex_state = 192},
  [4396] = {.lex_state = 203},
  [4397] = {.lex_state = 203},
  [4398] = {.lex_state = 203},
  [4399] = {.lex_state = 203},
  [4400] = {.lex_state = 203},
  [4401] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_extramodular_text = 0,
  ts_external_token__block_comment_text = 1,
  ts_external_token__indent = 2,
  ts_external_token_bullet_conj = 3,
  ts_external_token_bullet_disj = 4,
  ts_external_token__dedent = 5,
  ts_external_token__begin_proof = 6,
  ts_external_token__begin_proof_step = 7,
  ts_external_token_proof_keyword = 8,
  ts_external_token_by_keyword = 9,
  ts_external_token_obvious_keyword = 10,
  ts_external_token_omitted_keyword = 11,
  ts_external_token_qed_keyword = 12,
  ts_external_token__error_sentinel = 13,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_extramodular_text] = sym_extramodular_text,
  [ts_external_token__block_comment_text] = sym__block_comment_text,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token_bullet_conj] = sym_bullet_conj,
  [ts_external_token_bullet_disj] = sym_bullet_disj,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__begin_proof] = sym__begin_proof,
  [ts_external_token__begin_proof_step] = sym__begin_proof_step,
  [ts_external_token_proof_keyword] = sym_proof_keyword,
  [ts_external_token_by_keyword] = sym_by_keyword,
  [ts_external_token_obvious_keyword] = sym_obvious_keyword,
  [ts_external_token_omitted_keyword] = sym_omitted_keyword,
  [ts_external_token_qed_keyword] = sym_qed_keyword,
  [ts_external_token__error_sentinel] = sym__error_sentinel,
};

static const bool ts_external_scanner_states[14][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_extramodular_text] = true,
    [ts_external_token__block_comment_text] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
    [ts_external_token_qed_keyword] = true,
    [ts_external_token__error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_extramodular_text] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token_qed_keyword] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__begin_proof_step] = true,
  },
  [6] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [7] = {
    [ts_external_token__begin_proof_step] = true,
  },
  [8] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [9] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token__dedent] = true,
  },
  [10] = {
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
  },
  [11] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
  },
  [12] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [13] = {
    [ts_external_token__block_comment_text] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(1),
    [sym_single_line] = ACTIONS(1),
    [sym_double_line] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_BSLASHAA] = ACTIONS(1),
    [anon_sym_BSLASHEE] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_8] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_9] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_10] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_11] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_ENABLED] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_SUBSET] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_INSTANCE] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_DOMAIN] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_UNCHANGED] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_DEFINE] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHB] = ACTIONS(1),
    [aux_sym_binary_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHO] = ACTIONS(1),
    [aux_sym_octal_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHh] = ACTIONS(1),
    [anon_sym_BSLASHH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [anon_sym_STRING] = ACTIONS(1),
    [anon_sym_BOOLEAN] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_12] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_13] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_14] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_15] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_16] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_17] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_18] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_19] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_20] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_21] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_22] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_23] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_24] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_25] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_26] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_27] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_28] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_29] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_30] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_31] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_32] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_33] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_34] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_35] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_36] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_37] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_38] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_39] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_40] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_41] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_42] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_43] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_44] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_45] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_46] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_47] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_48] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_49] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_50] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_51] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_52] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_53] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_54] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_55] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_56] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_57] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_58] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_59] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_60] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_61] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_62] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_63] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_64] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_65] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_66] = ACTIONS(1),
    [anon_sym_BANG_BANG] = ACTIONS(1),
    [anon_sym_67] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_68] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_69] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_70] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_71] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_72] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_73] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_74] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_75] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [aux_sym_proof_step_id_token1] = ACTIONS(1),
    [aux_sym_proof_step_ref_token1] = ACTIONS(1),
    [sym_extramodular_text] = ACTIONS(1),
    [sym__block_comment_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym_bullet_conj] = ACTIONS(1),
    [sym_bullet_disj] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym_proof_keyword] = ACTIONS(1),
    [sym_by_keyword] = ACTIONS(1),
    [sym_obvious_keyword] = ACTIONS(1),
    [sym_omitted_keyword] = ACTIONS(1),
    [sym_qed_keyword] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4353),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(3977),
    [aux_sym_source_file_repeat1] = STATE(3481),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(7),
    [sym_extramodular_text] = ACTIONS(9),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(3346),
    [sym_exists] = STATE(3346),
    [sym_temporal_forall] = STATE(4068),
    [sym_temporal_exists] = STATE(4068),
    [sym_langle_bracket] = STATE(153),
    [sym_operator_definition] = STATE(3280),
    [sym_function_definition] = STATE(3280),
    [sym_instance] = STATE(4101),
    [sym_subexpr_prefix] = STATE(1069),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2379),
    [sym_bound_nonfix_op] = STATE(2379),
    [sym_module_definition] = STATE(3280),
    [sym__expr] = STATE(1218),
    [sym_prefixed_op] = STATE(2395),
    [sym__number] = STATE(2395),
    [sym_nat_number] = STATE(2388),
    [sym_binary_number] = STATE(2388),
    [sym_octal_number] = STATE(2388),
    [sym_hex_number] = STATE(2388),
    [sym_string] = STATE(2395),
    [sym_boolean] = STATE(2395),
    [sym_primitive_value_set] = STATE(2395),
    [sym_label] = STATE(2395),
    [sym_subexpression] = STATE(2395),
    [sym_parentheses] = STATE(2395),
    [sym_bounded_quantification] = STATE(2395),
    [sym_unbounded_quantification] = STATE(2395),
    [sym_choose] = STATE(2395),
    [sym_finite_set_literal] = STATE(2395),
    [sym_set_filter] = STATE(2395),
    [sym_set_map] = STATE(2395),
    [sym_function_evaluation] = STATE(2395),
    [sym_function_literal] = STATE(2395),
    [sym_set_of_functions] = STATE(2395),
    [sym_record_literal] = STATE(2395),
    [sym_set_of_records] = STATE(2395),
    [sym_record_value] = STATE(2395),
    [sym_except] = STATE(2395),
    [sym_prev_func_val] = STATE(2395),
    [sym_tuple_literal] = STATE(2395),
    [sym_step_expr_or_stutter] = STATE(2395),
    [sym_step_expr_no_stutter] = STATE(2395),
    [sym_fairness] = STATE(2395),
    [sym_if_then_else] = STATE(2395),
    [sym_case] = STATE(2395),
    [sym_let_in] = STATE(2395),
    [sym_conj_list] = STATE(2395),
    [sym_disj_list] = STATE(2395),
    [sym_lnot] = STATE(205),
    [sym_union] = STATE(202),
    [sym_powerset] = STATE(202),
    [sym_domain] = STATE(197),
    [sym_negative] = STATE(348),
    [sym_enabled] = STATE(195),
    [sym_unchanged] = STATE(195),
    [sym_always] = STATE(195),
    [sym_eventually] = STATE(195),
    [sym_prefix_op_symbol] = STATE(3823),
    [sym_bound_prefix_op] = STATE(2395),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4045),
    [sym_bound_infix_op] = STATE(2395),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4024),
    [sym_bound_postfix_op] = STATE(2395),
    [sym_assume_prove] = STATE(3285),
    [sym_definition_proof_step] = STATE(4101),
    [sym_have_proof_step] = STATE(4101),
    [sym_witness_proof_step] = STATE(4101),
    [sym_take_proof_step] = STATE(4101),
    [sym_suffices_proof_step] = STATE(4101),
    [sym_case_proof_step] = STATE(4101),
    [sym_pick_proof_step] = STATE(4101),
    [sym_use_or_hide] = STATE(4101),
    [sym_proof_step_ref] = STATE(2378),
    [aux_sym_definition_proof_step_repeat1] = STATE(3101),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [anon_sym_STRING] = ACTIONS(97),
    [anon_sym_BOOLEAN] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(97),
    [anon_sym_Int] = ACTIONS(97),
    [anon_sym_Real] = ACTIONS(97),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(135),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(249),
    [sym_qed_keyword] = ACTIONS(251),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(3346),
    [sym_exists] = STATE(3346),
    [sym_temporal_forall] = STATE(4068),
    [sym_temporal_exists] = STATE(4068),
    [sym_langle_bracket] = STATE(153),
    [sym_operator_definition] = STATE(3280),
    [sym_function_definition] = STATE(3280),
    [sym_instance] = STATE(4101),
    [sym_subexpr_prefix] = STATE(1069),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2379),
    [sym_bound_nonfix_op] = STATE(2379),
    [sym_module_definition] = STATE(3280),
    [sym__expr] = STATE(1218),
    [sym_prefixed_op] = STATE(2395),
    [sym__number] = STATE(2395),
    [sym_nat_number] = STATE(2388),
    [sym_binary_number] = STATE(2388),
    [sym_octal_number] = STATE(2388),
    [sym_hex_number] = STATE(2388),
    [sym_string] = STATE(2395),
    [sym_boolean] = STATE(2395),
    [sym_primitive_value_set] = STATE(2395),
    [sym_label] = STATE(2395),
    [sym_subexpression] = STATE(2395),
    [sym_parentheses] = STATE(2395),
    [sym_bounded_quantification] = STATE(2395),
    [sym_unbounded_quantification] = STATE(2395),
    [sym_choose] = STATE(2395),
    [sym_finite_set_literal] = STATE(2395),
    [sym_set_filter] = STATE(2395),
    [sym_set_map] = STATE(2395),
    [sym_function_evaluation] = STATE(2395),
    [sym_function_literal] = STATE(2395),
    [sym_set_of_functions] = STATE(2395),
    [sym_record_literal] = STATE(2395),
    [sym_set_of_records] = STATE(2395),
    [sym_record_value] = STATE(2395),
    [sym_except] = STATE(2395),
    [sym_prev_func_val] = STATE(2395),
    [sym_tuple_literal] = STATE(2395),
    [sym_step_expr_or_stutter] = STATE(2395),
    [sym_step_expr_no_stutter] = STATE(2395),
    [sym_fairness] = STATE(2395),
    [sym_if_then_else] = STATE(2395),
    [sym_case] = STATE(2395),
    [sym_let_in] = STATE(2395),
    [sym_conj_list] = STATE(2395),
    [sym_disj_list] = STATE(2395),
    [sym_lnot] = STATE(205),
    [sym_union] = STATE(202),
    [sym_powerset] = STATE(202),
    [sym_domain] = STATE(197),
    [sym_negative] = STATE(348),
    [sym_enabled] = STATE(195),
    [sym_unchanged] = STATE(195),
    [sym_always] = STATE(195),
    [sym_eventually] = STATE(195),
    [sym_prefix_op_symbol] = STATE(3823),
    [sym_bound_prefix_op] = STATE(2395),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4045),
    [sym_bound_infix_op] = STATE(2395),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4024),
    [sym_bound_postfix_op] = STATE(2395),
    [sym_assume_prove] = STATE(3285),
    [sym_definition_proof_step] = STATE(4101),
    [sym_have_proof_step] = STATE(4101),
    [sym_witness_proof_step] = STATE(4101),
    [sym_take_proof_step] = STATE(4101),
    [sym_suffices_proof_step] = STATE(4101),
    [sym_case_proof_step] = STATE(4101),
    [sym_pick_proof_step] = STATE(4101),
    [sym_use_or_hide] = STATE(4101),
    [sym_proof_step_ref] = STATE(2378),
    [aux_sym_definition_proof_step_repeat1] = STATE(3101),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [anon_sym_STRING] = ACTIONS(97),
    [anon_sym_BOOLEAN] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(97),
    [anon_sym_Int] = ACTIONS(97),
    [anon_sym_Real] = ACTIONS(97),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(135),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(249),
    [sym_qed_keyword] = ACTIONS(253),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(3346),
    [sym_exists] = STATE(3346),
    [sym_temporal_forall] = STATE(4068),
    [sym_temporal_exists] = STATE(4068),
    [sym_langle_bracket] = STATE(153),
    [sym_operator_definition] = STATE(3280),
    [sym_function_definition] = STATE(3280),
    [sym_instance] = STATE(4101),
    [sym_subexpr_prefix] = STATE(1069),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2379),
    [sym_bound_nonfix_op] = STATE(2379),
    [sym_module_definition] = STATE(3280),
    [sym__expr] = STATE(1218),
    [sym_prefixed_op] = STATE(2395),
    [sym__number] = STATE(2395),
    [sym_nat_number] = STATE(2388),
    [sym_binary_number] = STATE(2388),
    [sym_octal_number] = STATE(2388),
    [sym_hex_number] = STATE(2388),
    [sym_string] = STATE(2395),
    [sym_boolean] = STATE(2395),
    [sym_primitive_value_set] = STATE(2395),
    [sym_label] = STATE(2395),
    [sym_subexpression] = STATE(2395),
    [sym_parentheses] = STATE(2395),
    [sym_bounded_quantification] = STATE(2395),
    [sym_unbounded_quantification] = STATE(2395),
    [sym_choose] = STATE(2395),
    [sym_finite_set_literal] = STATE(2395),
    [sym_set_filter] = STATE(2395),
    [sym_set_map] = STATE(2395),
    [sym_function_evaluation] = STATE(2395),
    [sym_function_literal] = STATE(2395),
    [sym_set_of_functions] = STATE(2395),
    [sym_record_literal] = STATE(2395),
    [sym_set_of_records] = STATE(2395),
    [sym_record_value] = STATE(2395),
    [sym_except] = STATE(2395),
    [sym_prev_func_val] = STATE(2395),
    [sym_tuple_literal] = STATE(2395),
    [sym_step_expr_or_stutter] = STATE(2395),
    [sym_step_expr_no_stutter] = STATE(2395),
    [sym_fairness] = STATE(2395),
    [sym_if_then_else] = STATE(2395),
    [sym_case] = STATE(2395),
    [sym_let_in] = STATE(2395),
    [sym_conj_list] = STATE(2395),
    [sym_disj_list] = STATE(2395),
    [sym_lnot] = STATE(205),
    [sym_union] = STATE(202),
    [sym_powerset] = STATE(202),
    [sym_domain] = STATE(197),
    [sym_negative] = STATE(348),
    [sym_enabled] = STATE(195),
    [sym_unchanged] = STATE(195),
    [sym_always] = STATE(195),
    [sym_eventually] = STATE(195),
    [sym_prefix_op_symbol] = STATE(3823),
    [sym_bound_prefix_op] = STATE(2395),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4045),
    [sym_bound_infix_op] = STATE(2395),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4024),
    [sym_bound_postfix_op] = STATE(2395),
    [sym_assume_prove] = STATE(3285),
    [sym_definition_proof_step] = STATE(4101),
    [sym_have_proof_step] = STATE(4101),
    [sym_witness_proof_step] = STATE(4101),
    [sym_take_proof_step] = STATE(4101),
    [sym_suffices_proof_step] = STATE(4101),
    [sym_case_proof_step] = STATE(4101),
    [sym_pick_proof_step] = STATE(4101),
    [sym_use_or_hide] = STATE(4101),
    [sym_proof_step_ref] = STATE(2378),
    [aux_sym_definition_proof_step_repeat1] = STATE(3101),
    [sym_identifier] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_ASSUME] = ACTIONS(35),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(41),
    [anon_sym_SF_] = ACTIONS(43),
    [anon_sym_WF_] = ACTIONS(43),
    [anon_sym_CHOOSE] = ACTIONS(45),
    [anon_sym_IF] = ACTIONS(47),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_INSTANCE] = ACTIONS(51),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(55),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_HAVE] = ACTIONS(59),
    [anon_sym_TAKE] = ACTIONS(61),
    [anon_sym_HIDE] = ACTIONS(63),
    [anon_sym_USE] = ACTIONS(65),
    [anon_sym_DEFINE] = ACTIONS(67),
    [anon_sym_WITNESS] = ACTIONS(69),
    [anon_sym_PICK] = ACTIONS(71),
    [anon_sym_SUFFICES] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym_real_number] = ACTIONS(81),
    [anon_sym_BSLASHb] = ACTIONS(83),
    [anon_sym_BSLASHB] = ACTIONS(85),
    [anon_sym_BSLASHo] = ACTIONS(87),
    [anon_sym_BSLASHO] = ACTIONS(89),
    [anon_sym_BSLASHh] = ACTIONS(91),
    [anon_sym_BSLASHH] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_TRUE] = ACTIONS(95),
    [anon_sym_FALSE] = ACTIONS(95),
    [anon_sym_STRING] = ACTIONS(97),
    [anon_sym_BOOLEAN] = ACTIONS(97),
    [anon_sym_Nat] = ACTIONS(97),
    [anon_sym_Int] = ACTIONS(97),
    [anon_sym_Real] = ACTIONS(97),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(135),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(249),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(967),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(255),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(258),
    [sym_double_line] = ACTIONS(258),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(260),
    [anon_sym_10] = ACTIONS(260),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_ASSUME] = ACTIONS(265),
    [anon_sym_LOCAL] = ACTIONS(265),
    [anon_sym_UNION] = ACTIONS(267),
    [anon_sym_ASSUMPTION] = ACTIONS(265),
    [anon_sym_ENABLED] = ACTIONS(270),
    [anon_sym_VARIABLE] = ACTIONS(265),
    [anon_sym_AXIOM] = ACTIONS(265),
    [anon_sym_VARIABLES] = ACTIONS(265),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(281),
    [anon_sym_CONSTANT] = ACTIONS(265),
    [anon_sym_CONSTANTS] = ACTIONS(265),
    [anon_sym_INSTANCE] = ACTIONS(265),
    [anon_sym_THEOREM] = ACTIONS(265),
    [anon_sym_COROLLARY] = ACTIONS(265),
    [anon_sym_DOMAIN] = ACTIONS(284),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(289),
    [anon_sym_HIDE] = ACTIONS(265),
    [anon_sym_RECURSIVE] = ACTIONS(265),
    [anon_sym_USE] = ACTIONS(265),
    [anon_sym_LEMMA] = ACTIONS(265),
    [anon_sym_PROPOSITION] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(265),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(319),
    [anon_sym_BSLASHneg] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(322),
    [anon_sym_12] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(328),
    [anon_sym_13] = ACTIONS(328),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(137),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(968),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(255),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(258),
    [sym_double_line] = ACTIONS(258),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(260),
    [anon_sym_10] = ACTIONS(260),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_ASSUME] = ACTIONS(265),
    [anon_sym_LOCAL] = ACTIONS(265),
    [anon_sym_UNION] = ACTIONS(267),
    [anon_sym_ASSUMPTION] = ACTIONS(265),
    [anon_sym_ENABLED] = ACTIONS(270),
    [anon_sym_VARIABLE] = ACTIONS(265),
    [anon_sym_AXIOM] = ACTIONS(265),
    [anon_sym_VARIABLES] = ACTIONS(265),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(281),
    [anon_sym_CONSTANT] = ACTIONS(265),
    [anon_sym_CONSTANTS] = ACTIONS(265),
    [anon_sym_INSTANCE] = ACTIONS(265),
    [anon_sym_THEOREM] = ACTIONS(265),
    [anon_sym_COROLLARY] = ACTIONS(265),
    [anon_sym_DOMAIN] = ACTIONS(284),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(289),
    [anon_sym_HIDE] = ACTIONS(265),
    [anon_sym_RECURSIVE] = ACTIONS(265),
    [anon_sym_USE] = ACTIONS(265),
    [anon_sym_LEMMA] = ACTIONS(265),
    [anon_sym_PROPOSITION] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(265),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(319),
    [anon_sym_BSLASHneg] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(322),
    [anon_sym_12] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(328),
    [anon_sym_13] = ACTIONS(328),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(137),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(969),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(255),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(258),
    [sym_double_line] = ACTIONS(258),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(260),
    [anon_sym_10] = ACTIONS(260),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_ASSUME] = ACTIONS(265),
    [anon_sym_LOCAL] = ACTIONS(265),
    [anon_sym_UNION] = ACTIONS(267),
    [anon_sym_ASSUMPTION] = ACTIONS(265),
    [anon_sym_ENABLED] = ACTIONS(270),
    [anon_sym_VARIABLE] = ACTIONS(265),
    [anon_sym_AXIOM] = ACTIONS(265),
    [anon_sym_VARIABLES] = ACTIONS(265),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(281),
    [anon_sym_CONSTANT] = ACTIONS(265),
    [anon_sym_CONSTANTS] = ACTIONS(265),
    [anon_sym_INSTANCE] = ACTIONS(265),
    [anon_sym_THEOREM] = ACTIONS(265),
    [anon_sym_COROLLARY] = ACTIONS(265),
    [anon_sym_DOMAIN] = ACTIONS(284),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(289),
    [anon_sym_HIDE] = ACTIONS(265),
    [anon_sym_RECURSIVE] = ACTIONS(265),
    [anon_sym_USE] = ACTIONS(265),
    [anon_sym_LEMMA] = ACTIONS(265),
    [anon_sym_PROPOSITION] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(265),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(319),
    [anon_sym_BSLASHneg] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(322),
    [anon_sym_12] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(328),
    [anon_sym_13] = ACTIONS(328),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(137),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(971),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(255),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(258),
    [sym_double_line] = ACTIONS(258),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(260),
    [anon_sym_10] = ACTIONS(260),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_ASSUME] = ACTIONS(265),
    [anon_sym_LOCAL] = ACTIONS(265),
    [anon_sym_UNION] = ACTIONS(267),
    [anon_sym_ASSUMPTION] = ACTIONS(265),
    [anon_sym_ENABLED] = ACTIONS(270),
    [anon_sym_VARIABLE] = ACTIONS(265),
    [anon_sym_AXIOM] = ACTIONS(265),
    [anon_sym_VARIABLES] = ACTIONS(265),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(281),
    [anon_sym_CONSTANT] = ACTIONS(265),
    [anon_sym_CONSTANTS] = ACTIONS(265),
    [anon_sym_INSTANCE] = ACTIONS(265),
    [anon_sym_THEOREM] = ACTIONS(265),
    [anon_sym_COROLLARY] = ACTIONS(265),
    [anon_sym_DOMAIN] = ACTIONS(284),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(289),
    [anon_sym_HIDE] = ACTIONS(265),
    [anon_sym_RECURSIVE] = ACTIONS(265),
    [anon_sym_USE] = ACTIONS(265),
    [anon_sym_LEMMA] = ACTIONS(265),
    [anon_sym_PROPOSITION] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(292),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_BANG] = ACTIONS(265),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(319),
    [anon_sym_BSLASHneg] = ACTIONS(319),
    [anon_sym_TILDE] = ACTIONS(322),
    [anon_sym_12] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(325),
    [anon_sym_LT_GT] = ACTIONS(328),
    [anon_sym_13] = ACTIONS(328),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(137),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym__expr] = STATE(1618),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(4043),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4028),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4043),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_assume_prove] = STATE(4017),
    [sym_inner_assume_prove] = STATE(4007),
    [sym_new] = STATE(4007),
    [sym_level] = STATE(3112),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_ASSUME] = ACTIONS(339),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(341),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(341),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(353),
    [anon_sym_STATE] = ACTIONS(341),
    [anon_sym_ACTION] = ACTIONS(341),
    [anon_sym_TEMPORAL] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym__expr] = STATE(1568),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(4043),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4028),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4043),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_assume_prove] = STATE(4017),
    [sym_inner_assume_prove] = STATE(3812),
    [sym_new] = STATE(3812),
    [sym_level] = STATE(3112),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_ASSUME] = ACTIONS(339),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(341),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(341),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(353),
    [anon_sym_STATE] = ACTIONS(341),
    [anon_sym_ACTION] = ACTIONS(341),
    [anon_sym_TEMPORAL] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym__expr] = STATE(1594),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(4043),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4028),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4043),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_assume_prove] = STATE(4017),
    [sym_inner_assume_prove] = STATE(3789),
    [sym_new] = STATE(3789),
    [sym_level] = STATE(3112),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_ASSUME] = ACTIONS(339),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(341),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(341),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(353),
    [anon_sym_STATE] = ACTIONS(341),
    [anon_sym_ACTION] = ACTIONS(341),
    [anon_sym_TEMPORAL] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym__expr] = STATE(1552),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(4043),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4028),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4043),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_assume_prove] = STATE(4017),
    [sym_inner_assume_prove] = STATE(3740),
    [sym_new] = STATE(3740),
    [sym_level] = STATE(3112),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_ASSUME] = ACTIONS(339),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_VARIABLE] = ACTIONS(341),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_CONSTANT] = ACTIONS(341),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_NEW] = ACTIONS(353),
    [anon_sym_STATE] = ACTIONS(341),
    [anon_sym_ACTION] = ACTIONS(341),
    [anon_sym_TEMPORAL] = ACTIONS(341),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3050),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_ONLY] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3057),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_ONLY] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4150),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4145),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4132),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3064),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_ONLY] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym_operator_declaration] = STATE(3012),
    [sym__id_or_op_declaration] = STATE(3791),
    [sym__op_or_expr] = STATE(3587),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3438),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [sym_placeholder] = ACTIONS(455),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(459),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4152),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3061),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4132),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4150),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [24] = {
    [sym_block_comment] = STATE(24),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym__expr] = STATE(1390),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(204),
    [sym_union] = STATE(200),
    [sym_powerset] = STATE(200),
    [sym_domain] = STATE(199),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(198),
    [sym_unchanged] = STATE(198),
    [sym_always] = STATE(198),
    [sym_eventually] = STATE(198),
    [sym_prefix_op_symbol] = STATE(4021),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4001),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4021),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_use_body] = STATE(4140),
    [sym_use_body_expr] = STATE(3557),
    [sym_use_body_def] = STATE(4131),
    [sym_module_ref] = STATE(3423),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(429),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(443),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(445),
  },
  [25] = {
    [sym_block_comment] = STATE(25),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3065),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [26] = {
    [sym_block_comment] = STATE(26),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3050),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [27] = {
    [sym_block_comment] = STATE(27),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym__expr] = STATE(964),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(259),
    [sym_union] = STATE(266),
    [sym_powerset] = STATE(266),
    [sym_domain] = STATE(267),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(269),
    [sym_unchanged] = STATE(269),
    [sym_always] = STATE(269),
    [sym_eventually] = STATE(269),
    [sym_prefix_op_symbol] = STATE(4020),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(4019),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(4020),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_use_body] = STATE(3064),
    [sym_use_body_expr] = STATE(3015),
    [sym_use_body_def] = STATE(3068),
    [sym_module_ref] = STATE(3001),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_DEF] = ACTIONS(389),
    [anon_sym_DEFS] = ACTIONS(389),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(305),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(333),
  },
  [28] = {
    [sym_block_comment] = STATE(28),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym__op_or_expr] = STATE(4039),
    [sym__op] = STATE(3277),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym_lambda] = STATE(3268),
    [sym__expr] = STATE(1615),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(119),
    [sym_union] = STATE(118),
    [sym_powerset] = STATE(118),
    [sym_domain] = STATE(117),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(114),
    [sym_unchanged] = STATE(114),
    [sym_always] = STATE(114),
    [sym_eventually] = STATE(114),
    [sym_prefix_op_symbol] = STATE(3549),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(3210),
    [sym_plus_arrow] = STATE(3210),
    [sym_equiv] = STATE(3210),
    [sym_iff] = STATE(3210),
    [sym_leads_to] = STATE(3210),
    [sym_land] = STATE(3210),
    [sym_lor] = STATE(3210),
    [sym_assign] = STATE(3210),
    [sym_bnf_rule] = STATE(3210),
    [sym_eq] = STATE(3210),
    [sym_neq] = STATE(3210),
    [sym_lt] = STATE(3210),
    [sym_leq] = STATE(3210),
    [sym_geq] = STATE(3210),
    [sym_approx] = STATE(3210),
    [sym_rs_ttile] = STATE(3210),
    [sym_rd_ttile] = STATE(3210),
    [sym_ls_ttile] = STATE(3210),
    [sym_ld_ttile] = STATE(3210),
    [sym_asymp] = STATE(3210),
    [sym_cong] = STATE(3210),
    [sym_doteq] = STATE(3210),
    [sym_gg] = STATE(3210),
    [sym_ll] = STATE(3210),
    [sym_in] = STATE(3210),
    [sym_notin] = STATE(3210),
    [sym_prec] = STATE(3210),
    [sym_succ] = STATE(3210),
    [sym_preceq] = STATE(3210),
    [sym_succeq] = STATE(3210),
    [sym_sim] = STATE(3210),
    [sym_simeq] = STATE(3210),
    [sym_sqsubset] = STATE(3210),
    [sym_sqsupset] = STATE(3210),
    [sym_sqsubseteq] = STATE(3210),
    [sym_sqsupseteq] = STATE(3210),
    [sym_cap] = STATE(3210),
    [sym_cup] = STATE(3210),
    [sym_dots_2] = STATE(3210),
    [sym_dots_3] = STATE(3210),
    [sym_oplus] = STATE(3210),
    [sym_ominus] = STATE(3210),
    [sym_vertvert] = STATE(3210),
    [sym_minus] = STATE(3210),
    [sym_odot] = STATE(3210),
    [sym_oslash] = STATE(3210),
    [sym_otimes] = STATE(3210),
    [sym_bigcirc] = STATE(3210),
    [sym_bullet] = STATE(3210),
    [sym_div] = STATE(3210),
    [sym_circ] = STATE(3210),
    [sym_star] = STATE(3210),
    [sym_excl] = STATE(3210),
    [sym_qq] = STATE(3210),
    [sym_sqcap] = STATE(3210),
    [sym_sqcup] = STATE(3210),
    [sym_uplus] = STATE(3210),
    [sym_wr] = STATE(3210),
    [sym_cdot] = STATE(3210),
    [sym_infix_op_symbol] = STATE(3548),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3187),
    [sym_postfix_op_symbol] = STATE(3549),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_module_ref] = STATE(4039),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(461),
    [anon_sym_2] = ACTIONS(463),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(465),
    [anon_sym_10] = ACTIONS(465),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(467),
    [anon_sym_ENABLED] = ACTIONS(469),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(471),
    [anon_sym_DOMAIN] = ACTIONS(473),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(475),
    [anon_sym_LAMBDA] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(479),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(481),
    [anon_sym_BSLASHlnot] = ACTIONS(483),
    [anon_sym_BSLASHneg] = ACTIONS(483),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_12] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(487),
    [sym_negative_dot] = ACTIONS(489),
    [anon_sym_LT_GT] = ACTIONS(491),
    [anon_sym_13] = ACTIONS(491),
    [anon_sym_EQ_GT] = ACTIONS(493),
    [anon_sym_14] = ACTIONS(493),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(495),
    [anon_sym_15] = ACTIONS(495),
    [anon_sym_BSLASHequiv] = ACTIONS(497),
    [anon_sym_16] = ACTIONS(497),
    [anon_sym_LT_EQ_GT] = ACTIONS(499),
    [anon_sym_17] = ACTIONS(499),
    [anon_sym_TILDE_GT] = ACTIONS(501),
    [anon_sym_18] = ACTIONS(501),
    [anon_sym_SLASH_BSLASH] = ACTIONS(503),
    [anon_sym_BSLASHland] = ACTIONS(503),
    [anon_sym_19] = ACTIONS(503),
    [anon_sym_BSLASH_SLASH] = ACTIONS(505),
    [anon_sym_BSLASHlor] = ACTIONS(505),
    [anon_sym_20] = ACTIONS(505),
    [anon_sym_COLON_EQ] = ACTIONS(507),
    [anon_sym_21] = ACTIONS(507),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(509),
    [anon_sym_22] = ACTIONS(509),
    [anon_sym_SLASH_EQ] = ACTIONS(511),
    [anon_sym_POUND] = ACTIONS(513),
    [anon_sym_23] = ACTIONS(511),
    [anon_sym_LT] = ACTIONS(515),
    [sym_gt] = ACTIONS(517),
    [anon_sym_LT_EQ] = ACTIONS(519),
    [anon_sym_EQ_LT] = ACTIONS(521),
    [anon_sym_BSLASHleq] = ACTIONS(521),
    [anon_sym_24] = ACTIONS(521),
    [anon_sym_GT_EQ] = ACTIONS(523),
    [anon_sym_BSLASHgeq] = ACTIONS(523),
    [anon_sym_25] = ACTIONS(523),
    [anon_sym_BSLASHapprox] = ACTIONS(525),
    [anon_sym_26] = ACTIONS(525),
    [anon_sym_PIPE_DASH] = ACTIONS(527),
    [anon_sym_27] = ACTIONS(527),
    [anon_sym_PIPE_EQ] = ACTIONS(529),
    [anon_sym_28] = ACTIONS(529),
    [anon_sym_DASH_PIPE] = ACTIONS(531),
    [anon_sym_29] = ACTIONS(531),
    [anon_sym_EQ_PIPE] = ACTIONS(533),
    [anon_sym_30] = ACTIONS(533),
    [anon_sym_BSLASHasymp] = ACTIONS(535),
    [anon_sym_31] = ACTIONS(535),
    [anon_sym_BSLASHcong] = ACTIONS(537),
    [anon_sym_32] = ACTIONS(537),
    [anon_sym_BSLASHdoteq] = ACTIONS(539),
    [anon_sym_33] = ACTIONS(539),
    [anon_sym_BSLASHgg] = ACTIONS(541),
    [anon_sym_34] = ACTIONS(541),
    [anon_sym_BSLASHll] = ACTIONS(543),
    [anon_sym_35] = ACTIONS(543),
    [anon_sym_BSLASHnotin] = ACTIONS(545),
    [anon_sym_36] = ACTIONS(545),
    [anon_sym_BSLASHprec] = ACTIONS(547),
    [anon_sym_37] = ACTIONS(549),
    [anon_sym_BSLASHsucc] = ACTIONS(551),
    [anon_sym_38] = ACTIONS(553),
    [anon_sym_BSLASHpreceq] = ACTIONS(555),
    [anon_sym_39] = ACTIONS(555),
    [anon_sym_BSLASHsucceq] = ACTIONS(557),
    [anon_sym_40] = ACTIONS(557),
    [anon_sym_BSLASHsim] = ACTIONS(559),
    [anon_sym_42] = ACTIONS(561),
    [anon_sym_BSLASHsimeq] = ACTIONS(563),
    [anon_sym_43] = ACTIONS(563),
    [anon_sym_BSLASHsqsubset] = ACTIONS(565),
    [anon_sym_44] = ACTIONS(567),
    [anon_sym_BSLASHsqsupset] = ACTIONS(569),
    [anon_sym_45] = ACTIONS(571),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(573),
    [anon_sym_46] = ACTIONS(573),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(575),
    [anon_sym_47] = ACTIONS(575),
    [sym_compose] = ACTIONS(577),
    [sym_map_to] = ACTIONS(577),
    [sym_map_from] = ACTIONS(577),
    [sym_setminus] = ACTIONS(517),
    [anon_sym_BSLASHcap] = ACTIONS(579),
    [anon_sym_BSLASHintersect] = ACTIONS(579),
    [anon_sym_52] = ACTIONS(579),
    [anon_sym_BSLASHcup] = ACTIONS(581),
    [anon_sym_BSLASHunion] = ACTIONS(581),
    [anon_sym_53] = ACTIONS(581),
    [anon_sym_DOT_DOT] = ACTIONS(583),
    [anon_sym_54] = ACTIONS(585),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(587),
    [anon_sym_55] = ACTIONS(587),
    [sym_plus] = ACTIONS(517),
    [sym_plusplus] = ACTIONS(577),
    [anon_sym_BSLASHoplus] = ACTIONS(589),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(589),
    [anon_sym_56] = ACTIONS(589),
    [anon_sym_BSLASHominus] = ACTIONS(591),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(591),
    [anon_sym_57] = ACTIONS(591),
    [sym_mod] = ACTIONS(517),
    [sym_modmod] = ACTIONS(577),
    [sym_vert] = ACTIONS(517),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_58] = ACTIONS(593),
    [sym_minusminus] = ACTIONS(577),
    [sym_amp] = ACTIONS(517),
    [sym_ampamp] = ACTIONS(577),
    [anon_sym_BSLASHodot] = ACTIONS(595),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(595),
    [anon_sym_59] = ACTIONS(595),
    [anon_sym_BSLASHoslash] = ACTIONS(597),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(597),
    [anon_sym_60] = ACTIONS(597),
    [anon_sym_BSLASHotimes] = ACTIONS(599),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(599),
    [anon_sym_61] = ACTIONS(599),
    [sym_mul] = ACTIONS(517),
    [sym_mulmul] = ACTIONS(577),
    [sym_slash] = ACTIONS(517),
    [sym_slashslash] = ACTIONS(577),
    [anon_sym_BSLASHbigcirc] = ACTIONS(601),
    [anon_sym_62] = ACTIONS(601),
    [anon_sym_BSLASHbullet] = ACTIONS(603),
    [anon_sym_63] = ACTIONS(603),
    [anon_sym_BSLASHdiv] = ACTIONS(605),
    [anon_sym_64] = ACTIONS(605),
    [anon_sym_BSLASHcirc] = ACTIONS(607),
    [anon_sym_65] = ACTIONS(607),
    [anon_sym_BSLASHstar] = ACTIONS(609),
    [anon_sym_66] = ACTIONS(609),
    [anon_sym_BANG_BANG] = ACTIONS(611),
    [anon_sym_67] = ACTIONS(611),
    [anon_sym_QMARK_QMARK] = ACTIONS(613),
    [anon_sym_68] = ACTIONS(613),
    [sym_hashhash] = ACTIONS(577),
    [sym_dol] = ACTIONS(517),
    [sym_doldol] = ACTIONS(577),
    [anon_sym_BSLASHsqcap] = ACTIONS(615),
    [anon_sym_69] = ACTIONS(615),
    [anon_sym_BSLASHsqcup] = ACTIONS(617),
    [anon_sym_70] = ACTIONS(617),
    [anon_sym_BSLASHuplus] = ACTIONS(619),
    [anon_sym_71] = ACTIONS(619),
    [anon_sym_BSLASHwr] = ACTIONS(621),
    [anon_sym_73] = ACTIONS(621),
    [anon_sym_BSLASHcdot] = ACTIONS(623),
    [anon_sym_74] = ACTIONS(623),
    [sym_pow] = ACTIONS(517),
    [sym_powpow] = ACTIONS(577),
    [anon_sym_CARET_PLUS] = ACTIONS(625),
    [anon_sym_75] = ACTIONS(625),
    [sym_asterisk] = ACTIONS(627),
    [sym_sup_hash] = ACTIONS(627),
    [sym_prime] = ACTIONS(627),
    [sym__indent] = ACTIONS(445),
  },
  [29] = {
    [sym_block_comment] = STATE(29),
    [sym_forall] = STATE(3334),
    [sym_exists] = STATE(3334),
    [sym_temporal_forall] = STATE(4063),
    [sym_temporal_exists] = STATE(4063),
    [sym_langle_bracket] = STATE(130),
    [sym__op_or_expr] = STATE(3696),
    [sym__op] = STATE(3277),
    [sym_subexpr_prefix] = STATE(1065),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2533),
    [sym_bound_nonfix_op] = STATE(2533),
    [sym_lambda] = STATE(3268),
    [sym__expr] = STATE(1615),
    [sym_prefixed_op] = STATE(2563),
    [sym__number] = STATE(2563),
    [sym_nat_number] = STATE(2568),
    [sym_binary_number] = STATE(2568),
    [sym_octal_number] = STATE(2568),
    [sym_hex_number] = STATE(2568),
    [sym_string] = STATE(2563),
    [sym_boolean] = STATE(2563),
    [sym_primitive_value_set] = STATE(2563),
    [sym_label] = STATE(2563),
    [sym_subexpression] = STATE(2563),
    [sym_parentheses] = STATE(2563),
    [sym_bounded_quantification] = STATE(2563),
    [sym_unbounded_quantification] = STATE(2563),
    [sym_choose] = STATE(2563),
    [sym_finite_set_literal] = STATE(2563),
    [sym_set_filter] = STATE(2563),
    [sym_set_map] = STATE(2563),
    [sym_function_evaluation] = STATE(2563),
    [sym_function_literal] = STATE(2563),
    [sym_set_of_functions] = STATE(2563),
    [sym_record_literal] = STATE(2563),
    [sym_set_of_records] = STATE(2563),
    [sym_record_value] = STATE(2563),
    [sym_except] = STATE(2563),
    [sym_prev_func_val] = STATE(2563),
    [sym_tuple_literal] = STATE(2563),
    [sym_step_expr_or_stutter] = STATE(2563),
    [sym_step_expr_no_stutter] = STATE(2563),
    [sym_fairness] = STATE(2563),
    [sym_if_then_else] = STATE(2563),
    [sym_case] = STATE(2563),
    [sym_let_in] = STATE(2563),
    [sym_conj_list] = STATE(2563),
    [sym_disj_list] = STATE(2563),
    [sym_lnot] = STATE(119),
    [sym_union] = STATE(118),
    [sym_powerset] = STATE(118),
    [sym_domain] = STATE(117),
    [sym_negative] = STATE(648),
    [sym_enabled] = STATE(114),
    [sym_unchanged] = STATE(114),
    [sym_always] = STATE(114),
    [sym_eventually] = STATE(114),
    [sym_prefix_op_symbol] = STATE(3549),
    [sym_bound_prefix_op] = STATE(2563),
    [sym_implies] = STATE(3210),
    [sym_plus_arrow] = STATE(3210),
    [sym_equiv] = STATE(3210),
    [sym_iff] = STATE(3210),
    [sym_leads_to] = STATE(3210),
    [sym_land] = STATE(3210),
    [sym_lor] = STATE(3210),
    [sym_assign] = STATE(3210),
    [sym_bnf_rule] = STATE(3210),
    [sym_eq] = STATE(3210),
    [sym_neq] = STATE(3210),
    [sym_lt] = STATE(3210),
    [sym_leq] = STATE(3210),
    [sym_geq] = STATE(3210),
    [sym_approx] = STATE(3210),
    [sym_rs_ttile] = STATE(3210),
    [sym_rd_ttile] = STATE(3210),
    [sym_ls_ttile] = STATE(3210),
    [sym_ld_ttile] = STATE(3210),
    [sym_asymp] = STATE(3210),
    [sym_cong] = STATE(3210),
    [sym_doteq] = STATE(3210),
    [sym_gg] = STATE(3210),
    [sym_ll] = STATE(3210),
    [sym_in] = STATE(3210),
    [sym_notin] = STATE(3210),
    [sym_prec] = STATE(3210),
    [sym_succ] = STATE(3210),
    [sym_preceq] = STATE(3210),
    [sym_succeq] = STATE(3210),
    [sym_sim] = STATE(3210),
    [sym_simeq] = STATE(3210),
    [sym_sqsubset] = STATE(3210),
    [sym_sqsupset] = STATE(3210),
    [sym_sqsubseteq] = STATE(3210),
    [sym_sqsupseteq] = STATE(3210),
    [sym_cap] = STATE(3210),
    [sym_cup] = STATE(3210),
    [sym_dots_2] = STATE(3210),
    [sym_dots_3] = STATE(3210),
    [sym_oplus] = STATE(3210),
    [sym_ominus] = STATE(3210),
    [sym_vertvert] = STATE(3210),
    [sym_minus] = STATE(3210),
    [sym_odot] = STATE(3210),
    [sym_oslash] = STATE(3210),
    [sym_otimes] = STATE(3210),
    [sym_bigcirc] = STATE(3210),
    [sym_bullet] = STATE(3210),
    [sym_div] = STATE(3210),
    [sym_circ] = STATE(3210),
    [sym_star] = STATE(3210),
    [sym_excl] = STATE(3210),
    [sym_qq] = STATE(3210),
    [sym_sqcap] = STATE(3210),
    [sym_sqcup] = STATE(3210),
    [sym_uplus] = STATE(3210),
    [sym_wr] = STATE(3210),
    [sym_cdot] = STATE(3210),
    [sym_infix_op_symbol] = STATE(3548),
    [sym_bound_infix_op] = STATE(2563),
    [sym_sup_plus] = STATE(3187),
    [sym_postfix_op_symbol] = STATE(3549),
    [sym_bound_postfix_op] = STATE(2563),
    [sym_module_ref] = STATE(3696),
    [sym_proof_step_ref] = STATE(2540),
    [sym_identifier] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(461),
    [anon_sym_2] = ACTIONS(463),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(465),
    [anon_sym_10] = ACTIONS(465),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(467),
    [anon_sym_ENABLED] = ACTIONS(469),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(471),
    [anon_sym_DOMAIN] = ACTIONS(473),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(475),
    [anon_sym_LAMBDA] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym_real_number] = ACTIONS(423),
    [anon_sym_BSLASHb] = ACTIONS(425),
    [anon_sym_BSLASHB] = ACTIONS(427),
    [anon_sym_BSLASHo] = ACTIONS(479),
    [anon_sym_BSLASHO] = ACTIONS(431),
    [anon_sym_BSLASHh] = ACTIONS(433),
    [anon_sym_BSLASHH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_TRUE] = ACTIONS(437),
    [anon_sym_FALSE] = ACTIONS(437),
    [anon_sym_STRING] = ACTIONS(439),
    [anon_sym_BOOLEAN] = ACTIONS(439),
    [anon_sym_Nat] = ACTIONS(439),
    [anon_sym_Int] = ACTIONS(439),
    [anon_sym_Real] = ACTIONS(439),
    [anon_sym_LBRACE] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(481),
    [anon_sym_BSLASHlnot] = ACTIONS(483),
    [anon_sym_BSLASHneg] = ACTIONS(483),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_12] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(487),
    [sym_negative_dot] = ACTIONS(489),
    [anon_sym_LT_GT] = ACTIONS(491),
    [anon_sym_13] = ACTIONS(491),
    [anon_sym_EQ_GT] = ACTIONS(493),
    [anon_sym_14] = ACTIONS(493),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(495),
    [anon_sym_15] = ACTIONS(495),
    [anon_sym_BSLASHequiv] = ACTIONS(497),
    [anon_sym_16] = ACTIONS(497),
    [anon_sym_LT_EQ_GT] = ACTIONS(499),
    [anon_sym_17] = ACTIONS(499),
    [anon_sym_TILDE_GT] = ACTIONS(501),
    [anon_sym_18] = ACTIONS(501),
    [anon_sym_SLASH_BSLASH] = ACTIONS(503),
    [anon_sym_BSLASHland] = ACTIONS(503),
    [anon_sym_19] = ACTIONS(503),
    [anon_sym_BSLASH_SLASH] = ACTIONS(505),
    [anon_sym_BSLASHlor] = ACTIONS(505),
    [anon_sym_20] = ACTIONS(505),
    [anon_sym_COLON_EQ] = ACTIONS(507),
    [anon_sym_21] = ACTIONS(507),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(509),
    [anon_sym_22] = ACTIONS(509),
    [anon_sym_SLASH_EQ] = ACTIONS(511),
    [anon_sym_POUND] = ACTIONS(513),
    [anon_sym_23] = ACTIONS(511),
    [anon_sym_LT] = ACTIONS(515),
    [sym_gt] = ACTIONS(517),
    [anon_sym_LT_EQ] = ACTIONS(519),
    [anon_sym_EQ_LT] = ACTIONS(521),
    [anon_sym_BSLASHleq] = ACTIONS(521),
    [anon_sym_24] = ACTIONS(521),
    [anon_sym_GT_EQ] = ACTIONS(523),
    [anon_sym_BSLASHgeq] = ACTIONS(523),
    [anon_sym_25] = ACTIONS(523),
    [anon_sym_BSLASHapprox] = ACTIONS(525),
    [anon_sym_26] = ACTIONS(525),
    [anon_sym_PIPE_DASH] = ACTIONS(527),
    [anon_sym_27] = ACTIONS(527),
    [anon_sym_PIPE_EQ] = ACTIONS(529),
    [anon_sym_28] = ACTIONS(529),
    [anon_sym_DASH_PIPE] = ACTIONS(531),
    [anon_sym_29] = ACTIONS(531),
    [anon_sym_EQ_PIPE] = ACTIONS(533),
    [anon_sym_30] = ACTIONS(533),
    [anon_sym_BSLASHasymp] = ACTIONS(535),
    [anon_sym_31] = ACTIONS(535),
    [anon_sym_BSLASHcong] = ACTIONS(537),
    [anon_sym_32] = ACTIONS(537),
    [anon_sym_BSLASHdoteq] = ACTIONS(539),
    [anon_sym_33] = ACTIONS(539),
    [anon_sym_BSLASHgg] = ACTIONS(541),
    [anon_sym_34] = ACTIONS(541),
    [anon_sym_BSLASHll] = ACTIONS(543),
    [anon_sym_35] = ACTIONS(543),
    [anon_sym_BSLASHnotin] = ACTIONS(545),
    [anon_sym_36] = ACTIONS(545),
    [anon_sym_BSLASHprec] = ACTIONS(547),
    [anon_sym_37] = ACTIONS(549),
    [anon_sym_BSLASHsucc] = ACTIONS(551),
    [anon_sym_38] = ACTIONS(553),
    [anon_sym_BSLASHpreceq] = ACTIONS(555),
    [anon_sym_39] = ACTIONS(555),
    [anon_sym_BSLASHsucceq] = ACTIONS(557),
    [anon_sym_40] = ACTIONS(557),
    [anon_sym_BSLASHsim] = ACTIONS(559),
    [anon_sym_42] = ACTIONS(561),
    [anon_sym_BSLASHsimeq] = ACTIONS(563),
    [anon_sym_43] = ACTIONS(563),
    [anon_sym_BSLASHsqsubset] = ACTIONS(565),
    [anon_sym_44] = ACTIONS(567),
    [anon_sym_BSLASHsqsupset] = ACTIONS(569),
    [anon_sym_45] = ACTIONS(571),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(573),
    [anon_sym_46] = ACTIONS(573),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(575),
    [anon_sym_47] = ACTIONS(575),
    [sym_compose] = ACTIONS(577),
    [sym_map_to] = ACTIONS(577),
    [sym_map_from] = ACTIONS(577),
    [sym_setminus] = ACTIONS(517),
    [anon_sym_BSLASHcap] = ACTIONS(579),
    [anon_sym_BSLASHintersect] = ACTIONS(579),
    [anon_sym_52] = ACTIONS(579),
    [anon_sym_BSLASHcup] = ACTIONS(581),
    [anon_sym_BSLASHunion] = ACTIONS(581),
    [anon_sym_53] = ACTIONS(581),
    [anon_sym_DOT_DOT] = ACTIONS(583),
    [anon_sym_54] = ACTIONS(585),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(587),
    [anon_sym_55] = ACTIONS(587),
    [sym_plus] = ACTIONS(517),
    [sym_plusplus] = ACTIONS(577),
    [anon_sym_BSLASHoplus] = ACTIONS(589),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(589),
    [anon_sym_56] = ACTIONS(589),
    [anon_sym_BSLASHominus] = ACTIONS(591),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(591),
    [anon_sym_57] = ACTIONS(591),
    [sym_mod] = ACTIONS(517),
    [sym_modmod] = ACTIONS(577),
    [sym_vert] = ACTIONS(517),
    [anon_sym_PIPE_PIPE] = ACTIONS(593),
    [anon_sym_58] = ACTIONS(593),
    [sym_minusminus] = ACTIONS(577),
    [sym_amp] = ACTIONS(517),
    [sym_ampamp] = ACTIONS(577),
    [anon_sym_BSLASHodot] = ACTIONS(595),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(595),
    [anon_sym_59] = ACTIONS(595),
    [anon_sym_BSLASHoslash] = ACTIONS(597),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(597),
    [anon_sym_60] = ACTIONS(597),
    [anon_sym_BSLASHotimes] = ACTIONS(599),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(599),
    [anon_sym_61] = ACTIONS(599),
    [sym_mul] = ACTIONS(517),
    [sym_mulmul] = ACTIONS(577),
    [sym_slash] = ACTIONS(517),
    [sym_slashslash] = ACTIONS(577),
    [anon_sym_BSLASHbigcirc] = ACTIONS(601),
    [anon_sym_62] = ACTIONS(601),
    [anon_sym_BSLASHbullet] = ACTIONS(603),
    [anon_sym_63] = ACTIONS(603),
    [anon_sym_BSLASHdiv] = ACTIONS(605),
    [anon_sym_64] = ACTIONS(605),
    [anon_sym_BSLASHcirc] = ACTIONS(607),
    [anon_sym_65] = ACTIONS(607),
    [anon_sym_BSLASHstar] = ACTIONS(609),
    [anon_sym_66] = ACTIONS(609),
    [anon_sym_BANG_BANG] = ACTIONS(611),
    [anon_sym_67] = ACTIONS(611),
    [anon_sym_QMARK_QMARK] = ACTIONS(613),
    [anon_sym_68] = ACTIONS(613),
    [sym_hashhash] = ACTIONS(577),
    [sym_dol] = ACTIONS(517),
    [sym_doldol] = ACTIONS(577),
    [anon_sym_BSLASHsqcap] = ACTIONS(615),
    [anon_sym_69] = ACTIONS(615),
    [anon_sym_BSLASHsqcup] = ACTIONS(617),
    [anon_sym_70] = ACTIONS(617),
    [anon_sym_BSLASHuplus] = ACTIONS(619),
    [anon_sym_71] = ACTIONS(619),
    [anon_sym_BSLASHwr] = ACTIONS(621),
    [anon_sym_73] = ACTIONS(621),
    [anon_sym_BSLASHcdot] = ACTIONS(623),
    [anon_sym_74] = ACTIONS(623),
    [sym_pow] = ACTIONS(517),
    [sym_powpow] = ACTIONS(577),
    [anon_sym_CARET_PLUS] = ACTIONS(625),
    [anon_sym_75] = ACTIONS(625),
    [sym_asterisk] = ACTIONS(627),
    [sym_sup_hash] = ACTIONS(627),
    [sym_prime] = ACTIONS(627),
    [sym__indent] = ACTIONS(445),
  },
  [30] = {
    [sym_block_comment] = STATE(30),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym__op_or_expr] = STATE(3025),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(998),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(5),
    [sym_union] = STATE(6),
    [sym_powerset] = STATE(6),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(8),
    [sym_unchanged] = STATE(8),
    [sym_always] = STATE(8),
    [sym_eventually] = STATE(8),
    [sym_prefix_op_symbol] = STATE(3004),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3014),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3010),
    [sym_postfix_op_symbol] = STATE(3004),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_module_ref] = STATE(3025),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(629),
    [anon_sym_10] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(631),
    [anon_sym_ENABLED] = ACTIONS(633),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(635),
    [anon_sym_DOMAIN] = ACTIONS(637),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(639),
    [anon_sym_LAMBDA] = ACTIONS(641),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(643),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(645),
    [anon_sym_BSLASHneg] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_12] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(649),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(651),
    [anon_sym_13] = ACTIONS(651),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(653),
    [anon_sym_75] = ACTIONS(653),
    [sym_asterisk] = ACTIONS(655),
    [sym_sup_hash] = ACTIONS(655),
    [sym_prime] = ACTIONS(655),
    [sym__indent] = ACTIONS(333),
  },
  [31] = {
    [sym_block_comment] = STATE(31),
    [sym_forall] = STATE(3333),
    [sym_exists] = STATE(3333),
    [sym_temporal_forall] = STATE(4110),
    [sym_temporal_exists] = STATE(4110),
    [sym_langle_bracket] = STATE(132),
    [sym__op_or_expr] = STATE(3037),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1058),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(1935),
    [sym_bound_nonfix_op] = STATE(1935),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(998),
    [sym_prefixed_op] = STATE(2005),
    [sym__number] = STATE(2005),
    [sym_nat_number] = STATE(2025),
    [sym_binary_number] = STATE(2025),
    [sym_octal_number] = STATE(2025),
    [sym_hex_number] = STATE(2025),
    [sym_string] = STATE(2005),
    [sym_boolean] = STATE(2005),
    [sym_primitive_value_set] = STATE(2005),
    [sym_label] = STATE(2005),
    [sym_subexpression] = STATE(2005),
    [sym_parentheses] = STATE(2005),
    [sym_bounded_quantification] = STATE(2005),
    [sym_unbounded_quantification] = STATE(2005),
    [sym_choose] = STATE(2005),
    [sym_finite_set_literal] = STATE(2005),
    [sym_set_filter] = STATE(2005),
    [sym_set_map] = STATE(2005),
    [sym_function_evaluation] = STATE(2005),
    [sym_function_literal] = STATE(2005),
    [sym_set_of_functions] = STATE(2005),
    [sym_record_literal] = STATE(2005),
    [sym_set_of_records] = STATE(2005),
    [sym_record_value] = STATE(2005),
    [sym_except] = STATE(2005),
    [sym_prev_func_val] = STATE(2005),
    [sym_tuple_literal] = STATE(2005),
    [sym_step_expr_or_stutter] = STATE(2005),
    [sym_step_expr_no_stutter] = STATE(2005),
    [sym_fairness] = STATE(2005),
    [sym_if_then_else] = STATE(2005),
    [sym_case] = STATE(2005),
    [sym_let_in] = STATE(2005),
    [sym_conj_list] = STATE(2005),
    [sym_disj_list] = STATE(2005),
    [sym_lnot] = STATE(5),
    [sym_union] = STATE(6),
    [sym_powerset] = STATE(6),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(401),
    [sym_enabled] = STATE(8),
    [sym_unchanged] = STATE(8),
    [sym_always] = STATE(8),
    [sym_eventually] = STATE(8),
    [sym_prefix_op_symbol] = STATE(3004),
    [sym_bound_prefix_op] = STATE(2005),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3014),
    [sym_bound_infix_op] = STATE(2005),
    [sym_sup_plus] = STATE(3010),
    [sym_postfix_op_symbol] = STATE(3004),
    [sym_bound_postfix_op] = STATE(2005),
    [sym_module_ref] = STATE(3037),
    [sym_proof_step_ref] = STATE(1937),
    [sym_identifier] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(387),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(629),
    [anon_sym_10] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(263),
    [anon_sym_UNION] = ACTIONS(631),
    [anon_sym_ENABLED] = ACTIONS(633),
    [anon_sym_CASE] = ACTIONS(273),
    [anon_sym_SF_] = ACTIONS(275),
    [anon_sym_WF_] = ACTIONS(275),
    [anon_sym_CHOOSE] = ACTIONS(277),
    [anon_sym_IF] = ACTIONS(279),
    [anon_sym_SUBSET] = ACTIONS(635),
    [anon_sym_DOMAIN] = ACTIONS(637),
    [anon_sym_LET] = ACTIONS(287),
    [anon_sym_UNCHANGED] = ACTIONS(639),
    [anon_sym_LAMBDA] = ACTIONS(641),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(295),
    [aux_sym_child_id_token1] = ACTIONS(297),
    [sym_real_number] = ACTIONS(299),
    [anon_sym_BSLASHb] = ACTIONS(301),
    [anon_sym_BSLASHB] = ACTIONS(303),
    [anon_sym_BSLASHo] = ACTIONS(643),
    [anon_sym_BSLASHO] = ACTIONS(307),
    [anon_sym_BSLASHh] = ACTIONS(309),
    [anon_sym_BSLASHH] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_TRUE] = ACTIONS(313),
    [anon_sym_FALSE] = ACTIONS(313),
    [anon_sym_STRING] = ACTIONS(315),
    [anon_sym_BOOLEAN] = ACTIONS(315),
    [anon_sym_Nat] = ACTIONS(315),
    [anon_sym_Int] = ACTIONS(315),
    [anon_sym_Real] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(645),
    [anon_sym_BSLASHneg] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_12] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(649),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(651),
    [anon_sym_13] = ACTIONS(651),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(331),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(653),
    [anon_sym_75] = ACTIONS(653),
    [sym_asterisk] = ACTIONS(655),
    [sym_sup_hash] = ACTIONS(655),
    [sym_prime] = ACTIONS(655),
    [sym__indent] = ACTIONS(333),
  },
  [32] = {
    [sym_block_comment] = STATE(32),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3883),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(657),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [sym_placeholder] = ACTIONS(659),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [33] = {
    [sym_block_comment] = STATE(33),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(4008),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [34] = {
    [sym_block_comment] = STATE(34),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3845),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(663),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [35] = {
    [sym_block_comment] = STATE(35),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3716),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [36] = {
    [sym_block_comment] = STATE(36),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3708),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [37] = {
    [sym_block_comment] = STATE(37),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3674),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(665),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [38] = {
    [sym_block_comment] = STATE(38),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3758),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [39] = {
    [sym_block_comment] = STATE(39),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3750),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [40] = {
    [sym_block_comment] = STATE(40),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3701),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(667),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [41] = {
    [sym_block_comment] = STATE(41),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3716),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(669),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [42] = {
    [sym_block_comment] = STATE(42),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3669),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [43] = {
    [sym_block_comment] = STATE(43),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3801),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [sym_ll] = STATE(2947),
    [sym_in] = STATE(2947),
    [sym_notin] = STATE(2947),
    [sym_prec] = STATE(2947),
    [sym_succ] = STATE(2947),
    [sym_preceq] = STATE(2947),
    [sym_succeq] = STATE(2947),
    [sym_sim] = STATE(2947),
    [sym_simeq] = STATE(2947),
    [sym_sqsubset] = STATE(2947),
    [sym_sqsupset] = STATE(2947),
    [sym_sqsubseteq] = STATE(2947),
    [sym_sqsupseteq] = STATE(2947),
    [sym_cap] = STATE(2947),
    [sym_cup] = STATE(2947),
    [sym_dots_2] = STATE(2947),
    [sym_dots_3] = STATE(2947),
    [sym_oplus] = STATE(2947),
    [sym_ominus] = STATE(2947),
    [sym_vertvert] = STATE(2947),
    [sym_minus] = STATE(2947),
    [sym_odot] = STATE(2947),
    [sym_oslash] = STATE(2947),
    [sym_otimes] = STATE(2947),
    [sym_bigcirc] = STATE(2947),
    [sym_bullet] = STATE(2947),
    [sym_div] = STATE(2947),
    [sym_circ] = STATE(2947),
    [sym_star] = STATE(2947),
    [sym_excl] = STATE(2947),
    [sym_qq] = STATE(2947),
    [sym_sqcap] = STATE(2947),
    [sym_sqcup] = STATE(2947),
    [sym_uplus] = STATE(2947),
    [sym_wr] = STATE(2947),
    [sym_cdot] = STATE(2947),
    [sym_infix_op_symbol] = STATE(3508),
    [sym_bound_infix_op] = STATE(2288),
    [sym_sup_plus] = STATE(3115),
    [sym_postfix_op_symbol] = STATE(3526),
    [sym_bound_postfix_op] = STATE(2288),
    [sym_proof_step_ref] = STATE(2240),
    [sym_identifier] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(13),
    [anon_sym_2] = ACTIONS(15),
    [anon_sym_BSLASHA] = ACTIONS(17),
    [anon_sym_BSLASHforall] = ACTIONS(19),
    [anon_sym_4] = ACTIONS(19),
    [anon_sym_BSLASHE] = ACTIONS(21),
    [anon_sym_BSLASHexists] = ACTIONS(23),
    [anon_sym_5] = ACTIONS(23),
    [anon_sym_BSLASHAA] = ACTIONS(25),
    [anon_sym_BSLASHEE] = ACTIONS(27),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_8] = ACTIONS(29),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(31),
    [anon_sym_10] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(337),
    [anon_sym_UNION] = ACTIONS(37),
    [anon_sym_ENABLED] = ACTIONS(39),
    [anon_sym_CASE] = ACTIONS(343),
    [anon_sym_SF_] = ACTIONS(345),
    [anon_sym_WF_] = ACTIONS(345),
    [anon_sym_CHOOSE] = ACTIONS(347),
    [anon_sym_IF] = ACTIONS(349),
    [anon_sym_SUBSET] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(53),
    [anon_sym_LET] = ACTIONS(351),
    [anon_sym_UNCHANGED] = ACTIONS(57),
    [anon_sym_LAMBDA] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(357),
    [aux_sym_child_id_token1] = ACTIONS(359),
    [sym_real_number] = ACTIONS(361),
    [anon_sym_BSLASHb] = ACTIONS(363),
    [anon_sym_BSLASHB] = ACTIONS(365),
    [anon_sym_BSLASHo] = ACTIONS(367),
    [anon_sym_BSLASHO] = ACTIONS(369),
    [anon_sym_BSLASHh] = ACTIONS(371),
    [anon_sym_BSLASHH] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_TRUE] = ACTIONS(375),
    [anon_sym_FALSE] = ACTIONS(375),
    [anon_sym_STRING] = ACTIONS(377),
    [anon_sym_BOOLEAN] = ACTIONS(377),
    [anon_sym_Nat] = ACTIONS(377),
    [anon_sym_Int] = ACTIONS(377),
    [anon_sym_Real] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_EQ] = ACTIONS(101),
    [anon_sym_BSLASHlnot] = ACTIONS(103),
    [anon_sym_BSLASHneg] = ACTIONS(103),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_12] = ACTIONS(103),
    [anon_sym_DASH] = ACTIONS(107),
    [sym_negative_dot] = ACTIONS(109),
    [anon_sym_LT_GT] = ACTIONS(111),
    [anon_sym_13] = ACTIONS(111),
    [anon_sym_EQ_GT] = ACTIONS(113),
    [anon_sym_14] = ACTIONS(113),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(115),
    [anon_sym_15] = ACTIONS(115),
    [anon_sym_BSLASHequiv] = ACTIONS(117),
    [anon_sym_16] = ACTIONS(117),
    [anon_sym_LT_EQ_GT] = ACTIONS(119),
    [anon_sym_17] = ACTIONS(119),
    [anon_sym_TILDE_GT] = ACTIONS(121),
    [anon_sym_18] = ACTIONS(121),
    [anon_sym_SLASH_BSLASH] = ACTIONS(123),
    [anon_sym_BSLASHland] = ACTIONS(123),
    [anon_sym_19] = ACTIONS(123),
    [anon_sym_BSLASH_SLASH] = ACTIONS(125),
    [anon_sym_BSLASHlor] = ACTIONS(125),
    [anon_sym_20] = ACTIONS(125),
    [anon_sym_COLON_EQ] = ACTIONS(127),
    [anon_sym_21] = ACTIONS(127),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(129),
    [anon_sym_22] = ACTIONS(129),
    [anon_sym_SLASH_EQ] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(133),
    [anon_sym_23] = ACTIONS(131),
    [anon_sym_LT] = ACTIONS(381),
    [sym_gt] = ACTIONS(137),
    [anon_sym_LT_EQ] = ACTIONS(139),
    [anon_sym_EQ_LT] = ACTIONS(141),
    [anon_sym_BSLASHleq] = ACTIONS(141),
    [anon_sym_24] = ACTIONS(141),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_BSLASHgeq] = ACTIONS(143),
    [anon_sym_25] = ACTIONS(143),
    [anon_sym_BSLASHapprox] = ACTIONS(145),
    [anon_sym_26] = ACTIONS(145),
    [anon_sym_PIPE_DASH] = ACTIONS(147),
    [anon_sym_27] = ACTIONS(147),
    [anon_sym_PIPE_EQ] = ACTIONS(149),
    [anon_sym_28] = ACTIONS(149),
    [anon_sym_DASH_PIPE] = ACTIONS(151),
    [anon_sym_29] = ACTIONS(151),
    [anon_sym_EQ_PIPE] = ACTIONS(153),
    [anon_sym_30] = ACTIONS(153),
    [anon_sym_BSLASHasymp] = ACTIONS(155),
    [anon_sym_31] = ACTIONS(155),
    [anon_sym_BSLASHcong] = ACTIONS(157),
    [anon_sym_32] = ACTIONS(157),
    [anon_sym_BSLASHdoteq] = ACTIONS(159),
    [anon_sym_33] = ACTIONS(159),
    [anon_sym_BSLASHgg] = ACTIONS(161),
    [anon_sym_34] = ACTIONS(161),
    [anon_sym_BSLASHll] = ACTIONS(163),
    [anon_sym_35] = ACTIONS(163),
    [anon_sym_BSLASHnotin] = ACTIONS(165),
    [anon_sym_36] = ACTIONS(165),
    [anon_sym_BSLASHprec] = ACTIONS(167),
    [anon_sym_37] = ACTIONS(169),
    [anon_sym_BSLASHsucc] = ACTIONS(171),
    [anon_sym_38] = ACTIONS(173),
    [anon_sym_BSLASHpreceq] = ACTIONS(175),
    [anon_sym_39] = ACTIONS(175),
    [anon_sym_BSLASHsucceq] = ACTIONS(177),
    [anon_sym_40] = ACTIONS(177),
    [anon_sym_BSLASHsim] = ACTIONS(179),
    [anon_sym_42] = ACTIONS(181),
    [anon_sym_BSLASHsimeq] = ACTIONS(183),
    [anon_sym_43] = ACTIONS(183),
    [anon_sym_BSLASHsqsubset] = ACTIONS(185),
    [anon_sym_44] = ACTIONS(187),
    [anon_sym_BSLASHsqsupset] = ACTIONS(189),
    [anon_sym_45] = ACTIONS(191),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(193),
    [anon_sym_46] = ACTIONS(193),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(195),
    [anon_sym_47] = ACTIONS(195),
    [sym_compose] = ACTIONS(197),
    [sym_map_to] = ACTIONS(197),
    [sym_map_from] = ACTIONS(197),
    [sym_setminus] = ACTIONS(137),
    [anon_sym_BSLASHcap] = ACTIONS(199),
    [anon_sym_BSLASHintersect] = ACTIONS(199),
    [anon_sym_52] = ACTIONS(199),
    [anon_sym_BSLASHcup] = ACTIONS(201),
    [anon_sym_BSLASHunion] = ACTIONS(201),
    [anon_sym_53] = ACTIONS(201),
    [anon_sym_DOT_DOT] = ACTIONS(203),
    [anon_sym_54] = ACTIONS(205),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(207),
    [anon_sym_55] = ACTIONS(207),
    [sym_plus] = ACTIONS(137),
    [sym_plusplus] = ACTIONS(197),
    [anon_sym_BSLASHoplus] = ACTIONS(209),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(209),
    [anon_sym_56] = ACTIONS(209),
    [anon_sym_BSLASHominus] = ACTIONS(211),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(211),
    [anon_sym_57] = ACTIONS(211),
    [sym_mod] = ACTIONS(137),
    [sym_modmod] = ACTIONS(197),
    [sym_vert] = ACTIONS(137),
    [anon_sym_PIPE_PIPE] = ACTIONS(213),
    [anon_sym_58] = ACTIONS(213),
    [sym_minusminus] = ACTIONS(197),
    [sym_amp] = ACTIONS(137),
    [sym_ampamp] = ACTIONS(197),
    [anon_sym_BSLASHodot] = ACTIONS(215),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(215),
    [anon_sym_59] = ACTIONS(215),
    [anon_sym_BSLASHoslash] = ACTIONS(217),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(217),
    [anon_sym_60] = ACTIONS(217),
    [anon_sym_BSLASHotimes] = ACTIONS(219),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(219),
    [anon_sym_61] = ACTIONS(219),
    [sym_mul] = ACTIONS(137),
    [sym_mulmul] = ACTIONS(197),
    [sym_slash] = ACTIONS(137),
    [sym_slashslash] = ACTIONS(197),
    [anon_sym_BSLASHbigcirc] = ACTIONS(221),
    [anon_sym_62] = ACTIONS(221),
    [anon_sym_BSLASHbullet] = ACTIONS(223),
    [anon_sym_63] = ACTIONS(223),
    [anon_sym_BSLASHdiv] = ACTIONS(225),
    [anon_sym_64] = ACTIONS(225),
    [anon_sym_BSLASHcirc] = ACTIONS(227),
    [anon_sym_65] = ACTIONS(227),
    [anon_sym_BSLASHstar] = ACTIONS(229),
    [anon_sym_66] = ACTIONS(229),
    [anon_sym_BANG_BANG] = ACTIONS(231),
    [anon_sym_67] = ACTIONS(231),
    [anon_sym_QMARK_QMARK] = ACTIONS(233),
    [anon_sym_68] = ACTIONS(233),
    [sym_hashhash] = ACTIONS(197),
    [sym_dol] = ACTIONS(137),
    [sym_doldol] = ACTIONS(197),
    [anon_sym_BSLASHsqcap] = ACTIONS(235),
    [anon_sym_69] = ACTIONS(235),
    [anon_sym_BSLASHsqcup] = ACTIONS(237),
    [anon_sym_70] = ACTIONS(237),
    [anon_sym_BSLASHuplus] = ACTIONS(239),
    [anon_sym_71] = ACTIONS(239),
    [anon_sym_BSLASHwr] = ACTIONS(241),
    [anon_sym_73] = ACTIONS(241),
    [anon_sym_BSLASHcdot] = ACTIONS(243),
    [anon_sym_74] = ACTIONS(243),
    [sym_pow] = ACTIONS(137),
    [sym_powpow] = ACTIONS(197),
    [anon_sym_CARET_PLUS] = ACTIONS(245),
    [anon_sym_75] = ACTIONS(245),
    [sym_asterisk] = ACTIONS(247),
    [sym_sup_hash] = ACTIONS(247),
    [sym_prime] = ACTIONS(247),
    [sym__indent] = ACTIONS(383),
  },
  [44] = {
    [sym_block_comment] = STATE(44),
    [sym_forall] = STATE(3332),
    [sym_exists] = STATE(3332),
    [sym_temporal_forall] = STATE(4103),
    [sym_temporal_exists] = STATE(4103),
    [sym_langle_bracket] = STATE(143),
    [sym__op_or_expr] = STATE(3661),
    [sym__op] = STATE(3024),
    [sym_subexpr_prefix] = STATE(1066),
    [sym_subexpr_component] = STATE(4109),
    [sym_bound_op] = STATE(2241),
    [sym_bound_nonfix_op] = STATE(2241),
    [sym_lambda] = STATE(3018),
    [sym__expr] = STATE(1632),
    [sym_prefixed_op] = STATE(2288),
    [sym__number] = STATE(2288),
    [sym_nat_number] = STATE(2322),
    [sym_binary_number] = STATE(2322),
    [sym_octal_number] = STATE(2322),
    [sym_hex_number] = STATE(2322),
    [sym_string] = STATE(2288),
    [sym_boolean] = STATE(2288),
    [sym_primitive_value_set] = STATE(2288),
    [sym_label] = STATE(2288),
    [sym_subexpression] = STATE(2288),
    [sym_parentheses] = STATE(2288),
    [sym_bounded_quantification] = STATE(2288),
    [sym_unbounded_quantification] = STATE(2288),
    [sym_choose] = STATE(2288),
    [sym_finite_set_literal] = STATE(2288),
    [sym_set_filter] = STATE(2288),
    [sym_set_map] = STATE(2288),
    [sym_function_evaluation] = STATE(2288),
    [sym_function_literal] = STATE(2288),
    [sym_set_of_functions] = STATE(2288),
    [sym_record_literal] = STATE(2288),
    [sym_set_of_records] = STATE(2288),
    [sym_record_value] = STATE(2288),
    [sym_except] = STATE(2288),
    [sym_prev_func_val] = STATE(2288),
    [sym_tuple_literal] = STATE(2288),
    [sym_step_expr_or_stutter] = STATE(2288),
    [sym_step_expr_no_stutter] = STATE(2288),
    [sym_fairness] = STATE(2288),
    [sym_if_then_else] = STATE(2288),
    [sym_case] = STATE(2288),
    [sym_let_in] = STATE(2288),
    [sym_conj_list] = STATE(2288),
    [sym_disj_list] = STATE(2288),
    [sym_lnot] = STATE(75),
    [sym_union] = STATE(73),
    [sym_powerset] = STATE(73),
    [sym_domain] = STATE(70),
    [sym_negative] = STATE(381),
    [sym_enabled] = STATE(60),
    [sym_unchanged] = STATE(60),
    [sym_always] = STATE(60),
    [sym_eventually] = STATE(60),
    [sym_prefix_op_symbol] = STATE(3526),
    [sym_bound_prefix_op] = STATE(2288),
    [sym_implies] = STATE(2947),
    [sym_plus_arrow] = STATE(2947),
    [sym_equiv] = STATE(2947),
    [sym_iff] = STATE(2947),
    [sym_leads_to] = STATE(2947),
    [sym_land] = STATE(2947),
    [sym_lor] = STATE(2947),
    [sym_assign] = STATE(2947),
    [sym_bnf_rule] = STATE(2947),
    [sym_eq] = STATE(2947),
    [sym_neq] = STATE(2947),
    [sym_lt] = STATE(2947),
    [sym_leq] = STATE(2947),
    [sym_geq] = STATE(2947),
    [sym_approx] = STATE(2947),
    [sym_rs_ttile] = STATE(2947),
    [sym_rd_ttile] = STATE(2947),
    [sym_ls_ttile] = STATE(2947),
    [sym_ld_ttile] = STATE(2947),
    [sym_asymp] = STATE(2947),
    [sym_cong] = STATE(2947),
    [sym_doteq] = STATE(2947),
    [sym_gg] = STATE(2947),
    [