#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4641
#define LARGE_STATE_COUNT 3125
#define SYMBOL_COUNT 523
#define ALIAS_COUNT 1
#define TOKEN_COUNT 309
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 35

enum {
  sym_comment = 1,
  anon_sym_LPAREN_STAR = 2,
  anon_sym_MODULE = 3,
  sym_single_line = 4,
  sym_double_line = 5,
  anon_sym_EQ_EQ = 6,
  anon_sym_ = 7,
  anon_sym_BSLASHin = 8,
  anon_sym_2 = 9,
  anon_sym_LT_DASH = 10,
  anon_sym_3 = 11,
  anon_sym_BSLASHA = 12,
  anon_sym_BSLASHforall = 13,
  anon_sym_4 = 14,
  anon_sym_BSLASHE = 15,
  anon_sym_BSLASHexists = 16,
  anon_sym_5 = 17,
  anon_sym_BSLASHAA = 18,
  anon_sym_BSLASHEE = 19,
  anon_sym_PIPE_DASH_GT = 20,
  anon_sym_6 = 21,
  anon_sym_DASH_GT = 22,
  anon_sym_7 = 23,
  anon_sym_LT_LT = 24,
  anon_sym_8 = 25,
  anon_sym_GT_GT = 26,
  anon_sym_9 = 27,
  anon_sym_GT_GT_ = 28,
  anon_sym__ = 29,
  anon_sym_LBRACK_RBRACK = 30,
  anon_sym_10 = 31,
  anon_sym_COLON = 32,
  anon_sym_AT = 33,
  anon_sym_COLON_COLON = 34,
  anon_sym_11 = 35,
  sym_placeholder = 36,
  anon_sym_ASSUME = 37,
  anon_sym_ELSE = 38,
  anon_sym_LOCAL = 39,
  anon_sym_UNION = 40,
  anon_sym_ASSUMPTION = 41,
  anon_sym_ENABLED = 42,
  anon_sym_VARIABLE = 43,
  anon_sym_AXIOM = 44,
  anon_sym_EXCEPT = 45,
  anon_sym_OTHER = 46,
  anon_sym_VARIABLES = 47,
  anon_sym_CASE = 48,
  anon_sym_EXTENDS = 49,
  anon_sym_SF_ = 50,
  anon_sym_WF_ = 51,
  anon_sym_CHOOSE = 52,
  anon_sym_IF = 53,
  anon_sym_SUBSET = 54,
  anon_sym_WITH = 55,
  anon_sym_CONSTANT = 56,
  anon_sym_IN = 57,
  anon_sym_THEN = 58,
  anon_sym_CONSTANTS = 59,
  anon_sym_INSTANCE = 60,
  anon_sym_THEOREM = 61,
  anon_sym_COROLLARY = 62,
  anon_sym_DOMAIN = 63,
  anon_sym_LET = 64,
  anon_sym_UNCHANGED = 65,
  anon_sym_BY = 66,
  anon_sym_HAVE = 67,
  anon_sym_QED = 68,
  anon_sym_TAKE = 69,
  anon_sym_DEF = 70,
  anon_sym_HIDE = 71,
  anon_sym_RECURSIVE = 72,
  anon_sym_USE = 73,
  anon_sym_DEFINE = 74,
  anon_sym_PROOF = 75,
  anon_sym_WITNESS = 76,
  anon_sym_PICK = 77,
  anon_sym_DEFS = 78,
  anon_sym_PROVE = 79,
  anon_sym_SUFFICES = 80,
  anon_sym_NEW = 81,
  anon_sym_LAMBDA = 82,
  anon_sym_STATE = 83,
  anon_sym_ACTION = 84,
  anon_sym_TEMPORAL = 85,
  anon_sym_OBVIOUS = 86,
  anon_sym_OMITTED = 87,
  anon_sym_LEMMA = 88,
  anon_sym_PROPOSITION = 89,
  anon_sym_ONLY = 90,
  sym_identifier = 91,
  anon_sym_COMMA = 92,
  anon_sym_LPAREN = 93,
  anon_sym_RPAREN = 94,
  anon_sym_LBRACK = 95,
  anon_sym_RBRACK = 96,
  anon_sym_BANG = 97,
  aux_sym_child_id_token1 = 98,
  sym__real_number = 99,
  sym__binary_number = 100,
  sym__octal_number = 101,
  sym__hex_number = 102,
  sym_string = 103,
  anon_sym_TRUE = 104,
  anon_sym_FALSE = 105,
  anon_sym_STRING = 106,
  anon_sym_BOOLEAN = 107,
  anon_sym_Nat = 108,
  anon_sym_Int = 109,
  anon_sym_Real = 110,
  anon_sym_LBRACE = 111,
  anon_sym_RBRACE = 112,
  anon_sym_DOT = 113,
  anon_sym_EQ = 114,
  anon_sym_RBRACK_ = 115,
  anon_sym_BSLASHlnot = 116,
  anon_sym_BSLASHneg = 117,
  anon_sym_TILDE = 118,
  anon_sym_12 = 119,
  anon_sym_DASH = 120,
  sym_negative_dot = 121,
  anon_sym_LT_GT = 122,
  anon_sym_13 = 123,
  anon_sym_EQ_GT = 124,
  anon_sym_14 = 125,
  anon_sym_DASH_PLUS_DASH_GT = 126,
  anon_sym_15 = 127,
  anon_sym_BSLASHequiv = 128,
  anon_sym_16 = 129,
  anon_sym_LT_EQ_GT = 130,
  anon_sym_17 = 131,
  anon_sym_TILDE_GT = 132,
  anon_sym_18 = 133,
  anon_sym_SLASH_BSLASH = 134,
  anon_sym_BSLASHland = 135,
  anon_sym_19 = 136,
  anon_sym_BSLASH_SLASH = 137,
  anon_sym_BSLASHlor = 138,
  anon_sym_20 = 139,
  anon_sym_COLON_EQ = 140,
  anon_sym_21 = 141,
  anon_sym_COLON_COLON_EQ = 142,
  anon_sym_22 = 143,
  anon_sym_SLASH_EQ = 144,
  anon_sym_POUND = 145,
  anon_sym_23 = 146,
  anon_sym_LT = 147,
  sym_gt = 148,
  anon_sym_LT_EQ = 149,
  anon_sym_EQ_LT = 150,
  anon_sym_BSLASHleq = 151,
  anon_sym_24 = 152,
  anon_sym_GT_EQ = 153,
  anon_sym_BSLASHgeq = 154,
  anon_sym_25 = 155,
  anon_sym_BSLASHapprox = 156,
  anon_sym_26 = 157,
  anon_sym_PIPE_DASH = 158,
  anon_sym_27 = 159,
  anon_sym_PIPE_EQ = 160,
  anon_sym_28 = 161,
  anon_sym_DASH_PIPE = 162,
  anon_sym_29 = 163,
  anon_sym_EQ_PIPE = 164,
  anon_sym_30 = 165,
  anon_sym_BSLASHasymp = 166,
  anon_sym_31 = 167,
  anon_sym_BSLASHcong = 168,
  anon_sym_32 = 169,
  anon_sym_BSLASHdoteq = 170,
  anon_sym_33 = 171,
  anon_sym_BSLASHgg = 172,
  anon_sym_34 = 173,
  anon_sym_BSLASHll = 174,
  anon_sym_35 = 175,
  anon_sym_BSLASHnotin = 176,
  anon_sym_36 = 177,
  anon_sym_BSLASHprec = 178,
  anon_sym_37 = 179,
  anon_sym_BSLASHsucc = 180,
  anon_sym_38 = 181,
  anon_sym_BSLASHpreceq = 182,
  anon_sym_39 = 183,
  anon_sym_BSLASHsucceq = 184,
  anon_sym_40 = 185,
  anon_sym_BSLASHpropto = 186,
  anon_sym_41 = 187,
  anon_sym_BSLASHsim = 188,
  anon_sym_42 = 189,
  anon_sym_BSLASHsimeq = 190,
  anon_sym_43 = 191,
  anon_sym_BSLASHsqsubset = 192,
  anon_sym_44 = 193,
  anon_sym_BSLASHsqsupset = 194,
  anon_sym_45 = 195,
  anon_sym_BSLASHsqsubseteq = 196,
  anon_sym_46 = 197,
  anon_sym_BSLASHsqsupseteq = 198,
  anon_sym_47 = 199,
  anon_sym_BSLASHsubset = 200,
  anon_sym_48 = 201,
  anon_sym_BSLASHsupset = 202,
  anon_sym_49 = 203,
  anon_sym_BSLASHsubseteq = 204,
  anon_sym_50 = 205,
  anon_sym_BSLASHsupseteq = 206,
  anon_sym_51 = 207,
  sym_compose = 208,
  sym_map_to = 209,
  sym_map_from = 210,
  sym_setminus = 211,
  anon_sym_BSLASHcap = 212,
  anon_sym_BSLASHintersect = 213,
  anon_sym_52 = 214,
  anon_sym_BSLASHcup = 215,
  anon_sym_BSLASHunion = 216,
  anon_sym_53 = 217,
  anon_sym_DOT_DOT = 218,
  anon_sym_54 = 219,
  anon_sym_DOT_DOT_DOT = 220,
  anon_sym_55 = 221,
  sym_plus = 222,
  sym_plusplus = 223,
  anon_sym_BSLASHoplus = 224,
  anon_sym_LPAREN_PLUS_RPAREN = 225,
  anon_sym_56 = 226,
  anon_sym_BSLASHominus = 227,
  anon_sym_LPAREN_DASH_RPAREN = 228,
  anon_sym_57 = 229,
  sym_mod = 230,
  sym_modmod = 231,
  sym_vert = 232,
  anon_sym_PIPE_PIPE = 233,
  anon_sym_58 = 234,
  sym_minusminus = 235,
  sym_amp = 236,
  sym_ampamp = 237,
  anon_sym_BSLASHodot = 238,
  anon_sym_LPAREN_DOT_RPAREN = 239,
  anon_sym_59 = 240,
  anon_sym_BSLASHoslash = 241,
  anon_sym_LPAREN_SLASH_RPAREN = 242,
  anon_sym_60 = 243,
  anon_sym_BSLASHotimes = 244,
  anon_sym_LPAREN_BSLASHX_RPAREN = 245,
  anon_sym_61 = 246,
  sym_mul = 247,
  sym_mulmul = 248,
  sym_slash = 249,
  sym_slashslash = 250,
  anon_sym_BSLASHbigcirc = 251,
  anon_sym_62 = 252,
  anon_sym_BSLASHbullet = 253,
  anon_sym_63 = 254,
  anon_sym_BSLASHdiv = 255,
  anon_sym_64 = 256,
  anon_sym_BSLASHo = 257,
  anon_sym_BSLASHcirc = 258,
  anon_sym_65 = 259,
  anon_sym_BSLASHstar = 260,
  anon_sym_66 = 261,
  anon_sym_BANG_BANG = 262,
  anon_sym_67 = 263,
  anon_sym_QMARK_QMARK = 264,
  anon_sym_68 = 265,
  sym_hashhash = 266,
  sym_dol = 267,
  sym_doldol = 268,
  anon_sym_BSLASHsqcap = 269,
  anon_sym_69 = 270,
  anon_sym_BSLASHsqcup = 271,
  anon_sym_70 = 272,
  anon_sym_BSLASHuplus = 273,
  anon_sym_71 = 274,
  anon_sym_BSLASHX = 275,
  anon_sym_BSLASHtimes = 276,
  anon_sym_72 = 277,
  anon_sym_BSLASHwr = 278,
  anon_sym_73 = 279,
  anon_sym_BSLASHcdot = 280,
  anon_sym_74 = 281,
  sym_pow = 282,
  sym_powpow = 283,
  anon_sym_CARET_PLUS = 284,
  anon_sym_75 = 285,
  sym_asterisk = 286,
  sym_sup_hash = 287,
  sym_prime = 288,
  aux_sym_proof_step_id_token1 = 289,
  anon_sym_GT = 290,
  aux_sym_proof_step_id_token2 = 291,
  aux_sym_proof_step_id_token3 = 292,
  aux_sym_proof_step_ref_token1 = 293,
  aux_sym_proof_step_ref_token2 = 294,
  sym_extramodular_text = 295,
  sym__block_comment_text = 296,
  sym__indent = 297,
  sym_bullet_conj = 298,
  sym_bullet_disj = 299,
  sym__dedent = 300,
  sym__begin_proof = 301,
  sym__begin_proof_step = 302,
  sym_proof_keyword = 303,
  sym_by_keyword = 304,
  sym_obvious_keyword = 305,
  sym_omitted_keyword = 306,
  sym_qed_keyword = 307,
  sym_error_sentinel = 308,
  sym_source_file = 309,
  sym_block_comment = 310,
  sym_module = 311,
  sym_def_eq = 312,
  sym_set_in = 313,
  sym_gets = 314,
  sym_forall = 315,
  sym_exists = 316,
  sym_temporal_forall = 317,
  sym_temporal_exists = 318,
  sym_all_map_to = 319,
  sym_maps_to = 320,
  sym_langle_bracket = 321,
  sym_rangle_bracket = 322,
  sym_rangle_bracket_sub = 323,
  sym_case_box = 324,
  sym_case_arrow = 325,
  sym_colon = 326,
  sym_address = 327,
  sym_label_as = 328,
  sym_extends = 329,
  sym_unit = 330,
  sym_local_definition = 331,
  sym__definition = 332,
  sym_variable_declaration = 333,
  sym_constant_declaration = 334,
  sym_recursive_declaration = 335,
  sym_operator_declaration = 336,
  sym__id_or_op_declaration = 337,
  sym_operator_definition = 338,
  sym_function_definition = 339,
  sym_quantifier_bound = 340,
  sym_single_quantifier_bound = 341,
  sym_tuple_of_identifiers = 342,
  sym_instance = 343,
  sym_substitution = 344,
  sym__op_or_expr = 345,
  sym_subexpr_prefix = 346,
  sym_subexpr_component = 347,
  sym_bound_op = 348,
  sym_bound_nonfix_op = 349,
  sym_subexpr_tree_nav = 350,
  sym_child_id = 351,
  sym_operator_args = 352,
  sym_lambda = 353,
  sym_module_definition = 354,
  sym__expr = 355,
  sym__subscript_expr = 356,
  sym_prefixed_op = 357,
  sym_number = 358,
  sym__nat_number = 359,
  sym_boolean = 360,
  sym_primitive_value_set = 361,
  sym_label = 362,
  sym_subexpression = 363,
  sym_parentheses = 364,
  sym_bounded_quantification = 365,
  sym_unbounded_quantification = 366,
  sym_choose = 367,
  sym_finite_set_literal = 368,
  sym_set_filter = 369,
  sym_set_map = 370,
  sym_function_evaluation = 371,
  sym_function_literal = 372,
  sym_set_of_functions = 373,
  sym_record_literal = 374,
  sym_set_of_records = 375,
  sym_record_value = 376,
  sym_except = 377,
  aux_sym__except_val = 378,
  sym_prev_func_val = 379,
  sym_tuple_literal = 380,
  sym_step_expr_or_stutter = 381,
  sym_step_expr_no_stutter = 382,
  sym_fairness = 383,
  sym_if_then_else = 384,
  sym_case = 385,
  sym_case_arm = 386,
  sym_other_arm = 387,
  sym_let_in = 388,
  sym_conj_list = 389,
  sym_conj_item = 390,
  sym_disj_list = 391,
  sym_disj_item = 392,
  sym_lnot = 393,
  sym_union = 394,
  sym_powerset = 395,
  sym_domain = 396,
  sym_negative = 397,
  sym_enabled = 398,
  sym_unchanged = 399,
  sym_always = 400,
  sym_eventually = 401,
  sym_standalone_prefix_op_symbol = 402,
  sym_bound_prefix_op = 403,
  sym_implies = 404,
  sym_plus_arrow = 405,
  sym_equiv = 406,
  sym_iff = 407,
  sym_leads_to = 408,
  sym_land = 409,
  sym_lor = 410,
  sym_assign = 411,
  sym_bnf_rule = 412,
  sym_eq = 413,
  sym_neq = 414,
  sym_lt = 415,
  sym_leq = 416,
  sym_geq = 417,
  sym_approx = 418,
  sym_rs_ttile = 419,
  sym_rd_ttile = 420,
  sym_ls_ttile = 421,
  sym_ld_ttile = 422,
  sym_asymp = 423,
  sym_cong = 424,
  sym_doteq = 425,
  sym_gg = 426,
  sym_ll = 427,
  sym_in = 428,
  sym_notin = 429,
  sym_prec = 430,
  sym_succ = 431,
  sym_preceq = 432,
  sym_succeq = 433,
  sym_propto = 434,
  sym_sim = 435,
  sym_simeq = 436,
  sym_sqsubset = 437,
  sym_sqsupset = 438,
  sym_sqsubseteq = 439,
  sym_sqsupseteq = 440,
  sym_subset = 441,
  sym_supset = 442,
  sym_subseteq = 443,
  sym_supseteq = 444,
  sym_cap = 445,
  sym_cup = 446,
  sym_dots_2 = 447,
  sym_dots_3 = 448,
  sym_oplus = 449,
  sym_ominus = 450,
  sym_vertvert = 451,
  sym_minus = 452,
  sym_odot = 453,
  sym_oslash = 454,
  sym_otimes = 455,
  sym_bigcirc = 456,
  sym_bullet = 457,
  sym_div = 458,
  sym_circ = 459,
  sym_star = 460,
  sym_excl = 461,
  sym_qq = 462,
  sym_sqcap = 463,
  sym_sqcup = 464,
  sym_uplus = 465,
  sym_times = 466,
  sym_wr = 467,
  sym_cdot = 468,
  sym_infix_op_symbol = 469,
  sym_bound_infix_op = 470,
  sym_sup_plus = 471,
  sym_postfix_op_symbol = 472,
  sym_bound_postfix_op = 473,
  sym_assumption = 474,
  sym_theorem = 475,
  sym_assume_prove = 476,
  sym_inner_assume_prove = 477,
  sym_new = 478,
  sym_level = 479,
  sym__proof = 480,
  sym_terminal_proof = 481,
  sym_non_terminal_proof = 482,
  sym_proof_step = 483,
  sym_definition_proof_step = 484,
  sym_have_proof_step = 485,
  sym_witness_proof_step = 486,
  sym_take_proof_step = 487,
  sym_suffices_proof_step = 488,
  sym_case_proof_step = 489,
  sym_pick_proof_step = 490,
  sym__bound_or_identifier_list = 491,
  sym_qed_step = 492,
  sym_use_or_hide = 493,
  sym_use_body = 494,
  sym_use_body_expr = 495,
  sym_use_body_def = 496,
  sym_module_ref = 497,
  sym_proof_step_id = 498,
  sym_proof_step_ref = 499,
  aux_sym_source_file_repeat1 = 500,
  aux_sym_module_repeat1 = 501,
  aux_sym_extends_repeat1 = 502,
  aux_sym_variable_declaration_repeat1 = 503,
  aux_sym_constant_declaration_repeat1 = 504,
  aux_sym_operator_declaration_repeat1 = 505,
  aux_sym_function_definition_repeat1 = 506,
  aux_sym_instance_repeat1 = 507,
  aux_sym_subexpr_prefix_repeat1 = 508,
  aux_sym_bound_op_repeat1 = 509,
  aux_sym_finite_set_literal_repeat1 = 510,
  aux_sym_record_literal_repeat1 = 511,
  aux_sym_set_of_records_repeat1 = 512,
  aux_sym_except_repeat1 = 513,
  aux_sym_case_repeat1 = 514,
  aux_sym_let_in_repeat1 = 515,
  aux_sym_conj_list_repeat1 = 516,
  aux_sym_disj_list_repeat1 = 517,
  aux_sym_assume_prove_repeat1 = 518,
  aux_sym_non_terminal_proof_repeat1 = 519,
  aux_sym_definition_proof_step_repeat1 = 520,
  aux_sym_use_body_expr_repeat1 = 521,
  aux_sym_use_body_def_repeat1 = 522,
  alias_sym_identifier_ref = 523,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_MODULE] = "MODULE",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_] = "≜",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_2] = "∈",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_3] = "⟵",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_4] = "∀",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_5] = "∃",
  [anon_sym_BSLASHAA] = "\\AA",
  [anon_sym_BSLASHEE] = "\\EE",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_6] = "⟼",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_7] = "⟶",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_8] = "〈",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_9] = "〉",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym__] = "〉_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_10] = "□",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_11] = "∷",
  [sym_placeholder] = "placeholder",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_ENABLED] = "ENABLED",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CASE] = "CASE",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_SF_] = "SF_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_IF] = "IF",
  [anon_sym_SUBSET] = "SUBSET",
  [anon_sym_WITH] = "WITH",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_IN] = "IN",
  [anon_sym_THEN] = "THEN",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_DOMAIN] = "DOMAIN",
  [anon_sym_LET] = "LET",
  [anon_sym_UNCHANGED] = "UNCHANGED",
  [anon_sym_BY] = "BY",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_QED] = "QED",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_USE] = "USE",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_PICK] = "PICK",
  [anon_sym_DEFS] = "DEFS",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_NEW] = "NEW",
  [anon_sym_LAMBDA] = "LAMBDA",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_ONLY] = "ONLY",
  [sym_identifier] = "identifier",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [sym__real_number] = "_real_number",
  [sym__binary_number] = "_binary_number",
  [sym__octal_number] = "_octal_number",
  [sym__hex_number] = "_hex_number",
  [sym_string] = "string",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [anon_sym_STRING] = "STRING",
  [anon_sym_BOOLEAN] = "BOOLEAN",
  [anon_sym_Nat] = "Nat",
  [anon_sym_Int] = "Int",
  [anon_sym_Real] = "Real",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_12] = "¬",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative_dot",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_13] = "⋄",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_14] = "⟹",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_15] = "⇸",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_16] = "≡",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_17] = "⟺",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_18] = "⇝",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_19] = "∧",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_20] = "∨",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_21] = "≔",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_22] = "⩴",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_23] = "≠",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_24] = "≤",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_25] = "≥",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_26] = "≈",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_27] = "⊢",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_28] = "⊨",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_29] = "⊣",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_30] = "⫤",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_31] = "≍",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_32] = "≅",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_33] = "≐",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_34] = "≫",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_35] = "≪",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_36] = "∉",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_37] = "≺",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_38] = "≻",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_39] = "⪯",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_40] = "⪰",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_41] = "∝",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_42] = "∼",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_43] = "≃",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_44] = "⊏",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_45] = "⊐",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_46] = "⊑",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_47] = "⊒",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_48] = "⊂",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_49] = "⊃",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_50] = "⊆",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_51] = "⊇",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_52] = "∩",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_53] = "∪",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_54] = "‥",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_55] = "…",
  [sym_plus] = "plus",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_56] = "⊕",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_57] = "⊖",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_58] = "‖",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_59] = "⊙",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_60] = "⊘",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_61] = "⊗",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_62] = "◯",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_63] = "●",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_64] = "÷",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_65] = "∘",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_66] = "⋆",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_67] = "‼",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_68] = "⁇",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_69] = "⊓",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_70] = "⊔",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_71] = "⊎",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_72] = "×",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_73] = "≀",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_74] = "⋅",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_75] = "⁺",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [sym_extramodular_text] = "extramodular_text",
  [sym__block_comment_text] = "_block_comment_text",
  [sym__indent] = "_indent",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym_proof_keyword] = "PROOF",
  [sym_by_keyword] = "BY",
  [sym_obvious_keyword] = "OBVIOUS",
  [sym_omitted_keyword] = "OMITTED",
  [sym_qed_keyword] = "QED",
  [sym_error_sentinel] = "error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_module] = "module",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_extends] = "extends",
  [sym_unit] = "unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_single_quantifier_bound] = "single_quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym_number] = "number",
  [sym__nat_number] = "_nat_number",
  [sym_boolean] = "boolean",
  [sym_primitive_value_set] = "primitive_value_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [aux_sym__except_val] = "_except_val",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [sym_negative] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_standalone_prefix_op_symbol] = "standalone_prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_level] = "level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [alias_sym_identifier_ref] = "identifier_ref",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_] = anon_sym_,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_BSLASHAA] = anon_sym_BSLASHAA,
  [anon_sym_BSLASHEE] = anon_sym_BSLASHEE,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_6] = anon_sym_6,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_7] = anon_sym_7,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_8] = anon_sym_8,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_9] = anon_sym_9,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym__] = anon_sym__,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_10] = anon_sym_10,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_11] = anon_sym_11,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_ENABLED] = anon_sym_ENABLED,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_SUBSET] = anon_sym_SUBSET,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_DOMAIN] = anon_sym_DOMAIN,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_UNCHANGED] = anon_sym_UNCHANGED,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [sym_identifier] = sym_identifier,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [sym__real_number] = sym__real_number,
  [sym__binary_number] = sym__binary_number,
  [sym__octal_number] = sym__octal_number,
  [sym__hex_number] = sym__hex_number,
  [sym_string] = sym_string,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [anon_sym_STRING] = anon_sym_STRING,
  [anon_sym_BOOLEAN] = anon_sym_BOOLEAN,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_12] = anon_sym_12,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative_dot,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_13] = anon_sym_13,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_14] = anon_sym_14,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_15] = anon_sym_15,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_16] = anon_sym_16,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_17] = anon_sym_17,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_18] = anon_sym_18,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_19] = anon_sym_19,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_20] = anon_sym_20,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_21] = anon_sym_21,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_22] = anon_sym_22,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_23] = anon_sym_23,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_24] = anon_sym_24,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_25] = anon_sym_25,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_26] = anon_sym_26,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_27] = anon_sym_27,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_28] = anon_sym_28,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_29] = anon_sym_29,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_30] = anon_sym_30,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_31] = anon_sym_31,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_32] = anon_sym_32,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_33] = anon_sym_33,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_34] = anon_sym_34,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_35] = anon_sym_35,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_36] = anon_sym_36,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_37] = anon_sym_37,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_38] = anon_sym_38,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_39] = anon_sym_39,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_40] = anon_sym_40,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_41] = anon_sym_41,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_42] = anon_sym_42,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_43] = anon_sym_43,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_44] = anon_sym_44,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_45] = anon_sym_45,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_46] = anon_sym_46,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_47] = anon_sym_47,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_48] = anon_sym_48,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_49] = anon_sym_49,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_50] = anon_sym_50,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_51] = anon_sym_51,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_52] = anon_sym_52,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_53] = anon_sym_53,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_54] = anon_sym_54,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_55] = anon_sym_55,
  [sym_plus] = sym_plus,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_56] = anon_sym_56,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_57] = anon_sym_57,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_58] = anon_sym_58,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_59] = anon_sym_59,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_60] = anon_sym_60,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_61] = anon_sym_61,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_62] = anon_sym_62,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_63] = anon_sym_63,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_64] = anon_sym_64,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_65] = anon_sym_65,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_66] = anon_sym_66,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_67] = anon_sym_67,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_68] = anon_sym_68,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_69] = anon_sym_69,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_70] = anon_sym_70,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_71] = anon_sym_71,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_72] = anon_sym_72,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_73] = anon_sym_73,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_74] = anon_sym_74,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_75] = anon_sym_75,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [aux_sym_proof_step_id_token1] = sym_level,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = sym_level,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [sym_extramodular_text] = sym_extramodular_text,
  [sym__block_comment_text] = sym__block_comment_text,
  [sym__indent] = sym__indent,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym_proof_keyword] = anon_sym_PROOF,
  [sym_by_keyword] = anon_sym_BY,
  [sym_obvious_keyword] = anon_sym_OBVIOUS,
  [sym_omitted_keyword] = anon_sym_OMITTED,
  [sym_qed_keyword] = anon_sym_QED,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_module] = sym_module,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_extends] = sym_extends,
  [sym_unit] = sym_unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_single_quantifier_bound] = sym_single_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym_number] = sym_number,
  [sym__nat_number] = sym__nat_number,
  [sym_boolean] = sym_boolean,
  [sym_primitive_value_set] = sym_primitive_value_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [aux_sym__except_val] = aux_sym__except_val,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [sym_negative] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_standalone_prefix_op_symbol] = sym_standalone_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_level] = sym_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHEE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_11] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENABLED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOMAIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNCHANGED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__real_number] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_number] = {
    .visible = false,
    .named = true,
  },
  [sym__octal_number] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_number] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STRING] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BOOLEAN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_33] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_34] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_35] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_36] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_37] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_38] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_39] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_41] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_42] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_43] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_44] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_45] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_46] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_47] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_49] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_50] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_51] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_52] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_53] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_54] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_55] = {
    .visible = true,
    .named = false,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_57] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_58] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_59] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_60] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_61] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_62] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_63] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_65] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_66] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_67] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_68] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_69] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_70] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_71] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_73] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_74] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_75] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__block_comment_text] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym_proof_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_by_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_obvious_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_omitted_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_qed_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__nat_number] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_value_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__except_val] = {
    .visible = false,
    .named = false,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_standalone_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expression = 7,
  field_filter = 8,
  field_generator = 9,
  field_identifier = 10,
  field_if = 11,
  field_lhs = 12,
  field_map = 13,
  field_name = 14,
  field_op = 15,
  field_parameter = 16,
  field_prefix = 17,
  field_quantifier = 18,
  field_rhs = 19,
  field_set = 20,
  field_symbol = 21,
  field_then = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_identifier] = "identifier",
  [field_if] = "if",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_symbol] = "symbol",
  [field_then] = "then",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 2},
  [5] = {.index = 1, .length = 2},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 2},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 3},
  [12] = {.index = 14, .length = 3},
  [13] = {.index = 17, .length = 3},
  [14] = {.index = 20, .length = 2},
  [15] = {.index = 8, .length = 1},
  [16] = {.index = 22, .length = 1},
  [17] = {.index = 23, .length = 3},
  [18] = {.index = 26, .length = 3},
  [19] = {.index = 29, .length = 2},
  [20] = {.index = 31, .length = 4},
  [21] = {.index = 35, .length = 1},
  [22] = {.index = 36, .length = 2},
  [23] = {.index = 38, .length = 2},
  [24] = {.index = 40, .length = 4},
  [25] = {.index = 44, .length = 4},
  [26] = {.index = 48, .length = 3},
  [27] = {.index = 51, .length = 5},
  [28] = {.index = 56, .length = 2},
  [29] = {.index = 58, .length = 3},
  [30] = {.index = 61, .length = 4},
  [31] = {.index = 65, .length = 3},
  [32] = {.index = 68, .length = 6},
  [33] = {.index = 74, .length = 2},
  [34] = {.index = 76, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 2},
  [1] =
    {field_op, 1},
    {field_prefix, 0},
  [3] =
    {field_lhs, 0},
    {field_symbol, 1},
  [5] =
    {field_rhs, 1},
    {field_symbol, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_name, 0},
  [9] =
    {field_definition, 2},
    {field_name, 0},
  [11] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [14] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [17] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [20] =
    {field_definitions, 1},
    {field_expression, 3},
  [22] =
    {field_set, 2},
  [23] =
    {field_expression, 3},
    {field_identifier, 1},
    {field_quantifier, 0},
  [26] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [29] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [31] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [35] =
    {field_set, 3},
  [36] =
    {field_filter, 3},
    {field_generator, 1},
  [38] =
    {field_generator, 3},
    {field_map, 1},
  [40] =
    {field_expression, 4},
    {field_identifier, 1},
    {field_identifier, 2},
    {field_quantifier, 0},
  [44] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [48] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [51] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [56] =
    {field_definition, 5},
    {field_name, 0},
  [58] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [61] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [65] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [68] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [74] =
    {field_definition, 6},
    {field_name, 0},
  [76] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_identifier_ref,
  },
  [3] = {
    [1] = alias_sym_identifier_ref,
  },
  [4] = {
    [1] = alias_sym_identifier_ref,
  },
  [15] = {
    [0] = alias_sym_identifier_ref,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(447);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(882);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(485);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(872);
      if (lookahead == '>') ADVANCE(918);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'A') ADVANCE(61);
      if (lookahead == 'B') ADVANCE(172);
      if (lookahead == 'C') ADVANCE(45);
      if (lookahead == 'D') ADVANCE(78);
      if (lookahead == 'E') ADVANCE(147);
      if (lookahead == 'F') ADVANCE(38);
      if (lookahead == 'H') ADVANCE(39);
      if (lookahead == 'I') ADVANCE(110);
      if (lookahead == 'L') ADVANCE(46);
      if (lookahead == 'M') ADVANCE(173);
      if (lookahead == 'N') ADVANCE(79);
      if (lookahead == 'O') ADVANCE(56);
      if (lookahead == 'P') ADVANCE(122);
      if (lookahead == 'Q') ADVANCE(99);
      if (lookahead == 'R') ADVANCE(100);
      if (lookahead == 'S') ADVANCE(111);
      if (lookahead == 'T') ADVANCE(40);
      if (lookahead == 'U') ADVANCE(157);
      if (lookahead == 'V') ADVANCE(41);
      if (lookahead == 'W') ADVANCE(114);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(983);
      if (lookahead == ']') ADVANCE(842);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(491);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1009);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10229) ADVANCE(461);
      if (lookahead == 10230) ADVANCE(473);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10236) ADVANCE(471);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (lookahead == 12297) ADVANCE(479);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(846);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(1042);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(852);
      if (lookahead == '\\') ADVANCE(387);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == ')') ADVANCE(1002);
      END_STATE();
    case 4:
      if (lookahead == ')') ADVANCE(1005);
      END_STATE();
    case 5:
      if (lookahead == ')') ADVANCE(1018);
      END_STATE();
    case 6:
      if (lookahead == ')') ADVANCE(1021);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(1024);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(449);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '+') ADVANCE(3);
      if (lookahead == '-') ADVANCE(4);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '\\') ADVANCE(232);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(448);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == 'i') ADVANCE(307);
      if (lookahead == 'l') ADVANCE(310);
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == 'l') ADVANCE(310);
      if (lookahead == 'n') ADVANCE(260);
      END_STATE();
    case 14:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(452);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(460);
      if (lookahead == '<') ADVANCE(474);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(460);
      if (lookahead == '>') ADVANCE(888);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(15);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == '.') ADVANCE(887);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(33);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(887);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(995);
      END_STATE();
    case 23:
      if (lookahead == ':') ADVANCE(489);
      if (lookahead == '=') ADVANCE(906);
      if (lookahead == '>') ADVANCE(981);
      END_STATE();
    case 24:
      if (lookahead == ':') ADVANCE(488);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '=') ADVANCE(906);
      if (lookahead == '>') ADVANCE(981);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(908);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(453);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(454);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(27);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(888);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(898);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(470);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(892);
      END_STATE();
    case 35:
      if (lookahead == '>') ADVANCE(476);
      END_STATE();
    case 36:
      if (lookahead == '?') ADVANCE(1044);
      END_STATE();
    case 37:
      if (lookahead == '@') ADVANCE(980);
      END_STATE();
    case 38:
      if (lookahead == 'A') ADVANCE(148);
      END_STATE();
    case 39:
      if (lookahead == 'A') ADVANCE(227);
      if (lookahead == 'I') ADVANCE(76);
      END_STATE();
    case 40:
      if (lookahead == 'A') ADVANCE(136);
      if (lookahead == 'E') ADVANCE(149);
      if (lookahead == 'H') ADVANCE(80);
      if (lookahead == 'R') ADVANCE(225);
      END_STATE();
    case 41:
      if (lookahead == 'A') ADVANCE(192);
      END_STATE();
    case 42:
      if (lookahead == 'A') ADVANCE(58);
      END_STATE();
    case 43:
      if (lookahead == 'A') ADVANCE(586);
      END_STATE();
    case 44:
      if (lookahead == 'A') ADVANCE(576);
      END_STATE();
    case 45:
      if (lookahead == 'A') ADVANCE(202);
      if (lookahead == 'H') ADVANCE(183);
      if (lookahead == 'O') ADVANCE(168);
      END_STATE();
    case 46:
      if (lookahead == 'A') ADVANCE(153);
      if (lookahead == 'E') ADVANCE(156);
      if (lookahead == 'O') ADVANCE(68);
      END_STATE();
    case 47:
      if (lookahead == 'A') ADVANCE(216);
      if (lookahead == 'R') ADVANCE(123);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(127);
      END_STATE();
    case 49:
      if (lookahead == 'A') ADVANCE(138);
      END_STATE();
    case 50:
      if (lookahead == 'A') ADVANCE(191);
      END_STATE();
    case 51:
      if (lookahead == 'A') ADVANCE(167);
      END_STATE();
    case 52:
      if (lookahead == 'A') ADVANCE(164);
      END_STATE();
    case 53:
      if (lookahead == 'A') ADVANCE(139);
      END_STATE();
    case 54:
      if (lookahead == 'A') ADVANCE(170);
      END_STATE();
    case 55:
      if (lookahead == 'A') ADVANCE(59);
      END_STATE();
    case 56:
      if (lookahead == 'B') ADVANCE(230);
      if (lookahead == 'M') ADVANCE(124);
      if (lookahead == 'N') ADVANCE(137);
      if (lookahead == 'T') ADVANCE(120);
      END_STATE();
    case 57:
      if (lookahead == 'B') ADVANCE(75);
      END_STATE();
    case 58:
      if (lookahead == 'B') ADVANCE(145);
      END_STATE();
    case 59:
      if (lookahead == 'B') ADVANCE(144);
      END_STATE();
    case 60:
      if (lookahead == 'B') ADVANCE(209);
      if (lookahead == 'F') ADVANCE(115);
      END_STATE();
    case 61:
      if (lookahead == 'C') ADVANCE(217);
      if (lookahead == 'S') ADVANCE(201);
      if (lookahead == 'X') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 'C') ADVANCE(119);
      if (lookahead == 'I') ADVANCE(176);
      END_STATE();
    case 63:
      if (lookahead == 'C') ADVANCE(135);
      END_STATE();
    case 64:
      if (lookahead == 'C') ADVANCE(222);
      END_STATE();
    case 65:
      if (lookahead == 'C') ADVANCE(98);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(98);
      if (lookahead == 'T') ADVANCE(84);
      END_STATE();
    case 67:
      if (lookahead == 'C') ADVANCE(107);
      END_STATE();
    case 68:
      if (lookahead == 'C') ADVANCE(49);
      END_STATE();
    case 69:
      if (lookahead == 'D') ADVANCE(552);
      END_STATE();
    case 70:
      if (lookahead == 'D') ADVANCE(502);
      END_STATE();
    case 71:
      if (lookahead == 'D') ADVANCE(585);
      END_STATE();
    case 72:
      if (lookahead == 'D') ADVANCE(547);
      END_STATE();
    case 73:
      if (lookahead == 'D') ADVANCE(226);
      END_STATE();
    case 74:
      if (lookahead == 'D') ADVANCE(197);
      END_STATE();
    case 75:
      if (lookahead == 'D') ADVANCE(44);
      END_STATE();
    case 76:
      if (lookahead == 'D') ADVANCE(86);
      END_STATE();
    case 77:
      if (lookahead == 'E') ADVANCE(112);
      END_STATE();
    case 78:
      if (lookahead == 'E') ADVANCE(112);
      if (lookahead == 'O') ADVANCE(154);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(231);
      if (lookahead == 'a') ADVANCE(364);
      END_STATE();
    case 80:
      if (lookahead == 'E') ADVANCE(159);
      END_STATE();
    case 81:
      if (lookahead == 'E') ADVANCE(561);
      END_STATE();
    case 82:
      if (lookahead == 'E') ADVANCE(514);
      END_STATE();
    case 83:
      if (lookahead == 'E') ADVANCE(495);
      END_STATE();
    case 84:
      if (lookahead == 'E') ADVANCE(169);
      END_STATE();
    case 85:
      if (lookahead == 'E') ADVANCE(550);
      END_STATE();
    case 86:
      if (lookahead == 'E') ADVANCE(557);
      END_STATE();
    case 87:
      if (lookahead == 'E') ADVANCE(553);
      END_STATE();
    case 88:
      if (lookahead == 'E') ADVANCE(853);
      END_STATE();
    case 89:
      if (lookahead == 'E') ADVANCE(855);
      END_STATE();
    case 90:
      if (lookahead == 'E') ADVANCE(571);
      END_STATE();
    case 91:
      if (lookahead == 'E') ADVANCE(578);
      END_STATE();
    case 92:
      if (lookahead == 'E') ADVANCE(493);
      if (lookahead == 'P') ADVANCE(220);
      END_STATE();
    case 93:
      if (lookahead == 'E') ADVANCE(522);
      END_STATE();
    case 94:
      if (lookahead == 'E') ADVANCE(450);
      END_STATE();
    case 95:
      if (lookahead == 'E') ADVANCE(504);
      END_STATE();
    case 96:
      if (lookahead == 'E') ADVANCE(559);
      END_STATE();
    case 97:
      if (lookahead == 'E') ADVANCE(190);
      END_STATE();
    case 98:
      if (lookahead == 'E') ADVANCE(188);
      END_STATE();
    case 99:
      if (lookahead == 'E') ADVANCE(69);
      END_STATE();
    case 100:
      if (lookahead == 'E') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 101:
      if (lookahead == 'E') ADVANCE(206);
      END_STATE();
    case 102:
      if (lookahead == 'E') ADVANCE(152);
      END_STATE();
    case 103:
      if (lookahead == 'E') ADVANCE(70);
      END_STATE();
    case 104:
      if (lookahead == 'E') ADVANCE(71);
      END_STATE();
    case 105:
      if (lookahead == 'E') ADVANCE(213);
      END_STATE();
    case 106:
      if (lookahead == 'E') ADVANCE(72);
      END_STATE();
    case 107:
      if (lookahead == 'E') ADVANCE(200);
      END_STATE();
    case 108:
      if (lookahead == 'E') ADVANCE(158);
      END_STATE();
    case 109:
      if (lookahead == 'E') ADVANCE(52);
      END_STATE();
    case 110:
      if (lookahead == 'F') ADVANCE(524);
      if (lookahead == 'N') ADVANCE(533);
      if (lookahead == 'n') ADVANCE(363);
      END_STATE();
    case 111:
      if (lookahead == 'F') ADVANCE(237);
      if (lookahead == 'T') ADVANCE(47);
      if (lookahead == 'U') ADVANCE(60);
      END_STATE();
    case 112:
      if (lookahead == 'F') ADVANCE(555);
      END_STATE();
    case 113:
      if (lookahead == 'F') ADVANCE(564);
      END_STATE();
    case 114:
      if (lookahead == 'F') ADVANCE(238);
      if (lookahead == 'I') ADVANCE(211);
      END_STATE();
    case 115:
      if (lookahead == 'F') ADVANCE(125);
      END_STATE();
    case 116:
      if (lookahead == 'G') ADVANCE(857);
      END_STATE();
    case 117:
      if (lookahead == 'G') ADVANCE(106);
      END_STATE();
    case 118:
      if (lookahead == 'H') ADVANCE(528);
      if (lookahead == 'N') ADVANCE(101);
      END_STATE();
    case 119:
      if (lookahead == 'H') ADVANCE(51);
      END_STATE();
    case 120:
      if (lookahead == 'H') ADVANCE(97);
      END_STATE();
    case 121:
      if (lookahead == 'H') ADVANCE(108);
      END_STATE();
    case 122:
      if (lookahead == 'I') ADVANCE(63);
      if (lookahead == 'R') ADVANCE(171);
      END_STATE();
    case 123:
      if (lookahead == 'I') ADVANCE(160);
      END_STATE();
    case 124:
      if (lookahead == 'I') ADVANCE(215);
      END_STATE();
    case 125:
      if (lookahead == 'I') ADVANCE(67);
      END_STATE();
    case 126:
      if (lookahead == 'I') ADVANCE(180);
      END_STATE();
    case 127:
      if (lookahead == 'I') ADVANCE(163);
      END_STATE();
    case 128:
      if (lookahead == 'I') ADVANCE(179);
      END_STATE();
    case 129:
      if (lookahead == 'I') ADVANCE(181);
      END_STATE();
    case 130:
      if (lookahead == 'I') ADVANCE(184);
      END_STATE();
    case 131:
      if (lookahead == 'I') ADVANCE(185);
      END_STATE();
    case 132:
      if (lookahead == 'I') ADVANCE(229);
      END_STATE();
    case 133:
      if (lookahead == 'I') ADVANCE(55);
      END_STATE();
    case 134:
      if (lookahead == 'I') ADVANCE(221);
      END_STATE();
    case 135:
      if (lookahead == 'K') ADVANCE(567);
      END_STATE();
    case 136:
      if (lookahead == 'K') ADVANCE(87);
      END_STATE();
    case 137:
      if (lookahead == 'L') ADVANCE(234);
      END_STATE();
    case 138:
      if (lookahead == 'L') ADVANCE(496);
      END_STATE();
    case 139:
      if (lookahead == 'L') ADVANCE(582);
      END_STATE();
    case 140:
      if (lookahead == 'L') ADVANCE(141);
      END_STATE();
    case 141:
      if (lookahead == 'L') ADVANCE(50);
      END_STATE();
    case 142:
      if (lookahead == 'L') ADVANCE(109);
      END_STATE();
    case 143:
      if (lookahead == 'L') ADVANCE(94);
      END_STATE();
    case 144:
      if (lookahead == 'L') ADVANCE(95);
      END_STATE();
    case 145:
      if (lookahead == 'L') ADVANCE(103);
      END_STATE();
    case 146:
      if (lookahead == 'L') ADVANCE(203);
      END_STATE();
    case 147:
      if (lookahead == 'L') ADVANCE(203);
      if (lookahead == 'N') ADVANCE(42);
      if (lookahead == 'X') ADVANCE(66);
      END_STATE();
    case 148:
      if (lookahead == 'L') ADVANCE(208);
      END_STATE();
    case 149:
      if (lookahead == 'M') ADVANCE(189);
      END_STATE();
    case 150:
      if (lookahead == 'M') ADVANCE(92);
      END_STATE();
    case 151:
      if (lookahead == 'M') ADVANCE(507);
      END_STATE();
    case 152:
      if (lookahead == 'M') ADVANCE(539);
      END_STATE();
    case 153:
      if (lookahead == 'M') ADVANCE(57);
      END_STATE();
    case 154:
      if (lookahead == 'M') ADVANCE(48);
      END_STATE();
    case 155:
      if (lookahead == 'M') ADVANCE(43);
      END_STATE();
    case 156:
      if (lookahead == 'M') ADVANCE(155);
      if (lookahead == 'T') ADVANCE(545);
      END_STATE();
    case 157:
      if (lookahead == 'N') ADVANCE(62);
      if (lookahead == 'S') ADVANCE(81);
      END_STATE();
    case 158:
      if (lookahead == 'N') ADVANCE(535);
      END_STATE();
    case 159:
      if (lookahead == 'N') ADVANCE(535);
      if (lookahead == 'O') ADVANCE(194);
      END_STATE();
    case 160:
      if (lookahead == 'N') ADVANCE(116);
      END_STATE();
    case 161:
      if (lookahead == 'N') ADVANCE(498);
      END_STATE();
    case 162:
      if (lookahead == 'N') ADVANCE(580);
      END_STATE();
    case 163:
      if (lookahead == 'N') ADVANCE(543);
      END_STATE();
    case 164:
      if (lookahead == 'N') ADVANCE(859);
      END_STATE();
    case 165:
      if (lookahead == 'N') ADVANCE(500);
      END_STATE();
    case 166:
      if (lookahead == 'N') ADVANCE(588);
      END_STATE();
    case 167:
      if (lookahead == 'N') ADVANCE(117);
      END_STATE();
    case 168:
      if (lookahead == 'N') ADVANCE(204);
      if (lookahead == 'R') ADVANCE(178);
      END_STATE();
    case 169:
      if (lookahead == 'N') ADVANCE(74);
      END_STATE();
    case 170:
      if (lookahead == 'N') ADVANCE(214);
      END_STATE();
    case 171:
      if (lookahead == 'O') ADVANCE(174);
      END_STATE();
    case 172:
      if (lookahead == 'O') ADVANCE(175);
      if (lookahead == 'Y') ADVANCE(549);
      END_STATE();
    case 173:
      if (lookahead == 'O') ADVANCE(73);
      END_STATE();
    case 174:
      if (lookahead == 'O') ADVANCE(113);
      if (lookahead == 'P') ADVANCE(177);
      if (lookahead == 'V') ADVANCE(90);
      END_STATE();
    case 175:
      if (lookahead == 'O') ADVANCE(142);
      END_STATE();
    case 176:
      if (lookahead == 'O') ADVANCE(161);
      END_STATE();
    case 177:
      if (lookahead == 'O') ADVANCE(205);
      END_STATE();
    case 178:
      if (lookahead == 'O') ADVANCE(140);
      END_STATE();
    case 179:
      if (lookahead == 'O') ADVANCE(162);
      END_STATE();
    case 180:
      if (lookahead == 'O') ADVANCE(151);
      END_STATE();
    case 181:
      if (lookahead == 'O') ADVANCE(224);
      END_STATE();
    case 182:
      if (lookahead == 'O') ADVANCE(196);
      END_STATE();
    case 183:
      if (lookahead == 'O') ADVANCE(187);
      END_STATE();
    case 184:
      if (lookahead == 'O') ADVANCE(165);
      END_STATE();
    case 185:
      if (lookahead == 'O') ADVANCE(166);
      END_STATE();
    case 186:
      if (lookahead == 'O') ADVANCE(228);
      END_STATE();
    case 187:
      if (lookahead == 'O') ADVANCE(210);
      END_STATE();
    case 188:
      if (lookahead == 'P') ADVANCE(212);
      END_STATE();
    case 189:
      if (lookahead == 'P') ADVANCE(182);
      END_STATE();
    case 190:
      if (lookahead == 'R') ADVANCE(510);
      END_STATE();
    case 191:
      if (lookahead == 'R') ADVANCE(235);
      END_STATE();
    case 192:
      if (lookahead == 'R') ADVANCE(133);
      END_STATE();
    case 193:
      if (lookahead == 'R') ADVANCE(186);
      END_STATE();
    case 194:
      if (lookahead == 'R') ADVANCE(102);
      END_STATE();
    case 195:
      if (lookahead == 'R') ADVANCE(207);
      END_STATE();
    case 196:
      if (lookahead == 'R') ADVANCE(53);
      END_STATE();
    case 197:
      if (lookahead == 'S') ADVANCE(516);
      END_STATE();
    case 198:
      if (lookahead == 'S') ADVANCE(584);
      END_STATE();
    case 199:
      if (lookahead == 'S') ADVANCE(565);
      END_STATE();
    case 200:
      if (lookahead == 'S') ADVANCE(572);
      END_STATE();
    case 201:
      if (lookahead == 'S') ADVANCE(223);
      END_STATE();
    case 202:
      if (lookahead == 'S') ADVANCE(82);
      END_STATE();
    case 203:
      if (lookahead == 'S') ADVANCE(83);
      END_STATE();
    case 204:
      if (lookahead == 'S') ADVANCE(219);
      END_STATE();
    case 205:
      if (lookahead == 'S') ADVANCE(134);
      END_STATE();
    case 206:
      if (lookahead == 'S') ADVANCE(199);
      END_STATE();
    case 207:
      if (lookahead == 'S') ADVANCE(132);
      END_STATE();
    case 208:
      if (lookahead == 'S') ADVANCE(89);
      END_STATE();
    case 209:
      if (lookahead == 'S') ADVANCE(105);
      END_STATE();
    case 210:
      if (lookahead == 'S') ADVANCE(93);
      END_STATE();
    case 211:
      if (lookahead == 'T') ADVANCE(118);
      END_STATE();
    case 212:
      if (lookahead == 'T') ADVANCE(509);
      END_STATE();
    case 213:
      if (lookahead == 'T') ADVANCE(526);
      END_STATE();
    case 214:
      if (lookahead == 'T') ADVANCE(530);
      END_STATE();
    case 215:
      if (lookahead == 'T') ADVANCE(218);
      END_STATE();
    case 216:
      if (lookahead == 'T') ADVANCE(91);
      END_STATE();
    case 217:
      if (lookahead == 'T') ADVANCE(128);
      END_STATE();
    case 218:
      if (lookahead == 'T') ADVANCE(104);
      END_STATE();
    case 219:
      if (lookahead == 'T') ADVANCE(54);
      END_STATE();
    case 220:
      if (lookahead == 'T') ADVANCE(130);
      END_STATE();
    case 221:
      if (lookahead == 'T') ADVANCE(131);
      END_STATE();
    case 222:
      if (lookahead == 'U') ADVANCE(195);
      END_STATE();
    case 223:
      if (lookahead == 'U') ADVANCE(150);
      END_STATE();
    case 224:
      if (lookahead == 'U') ADVANCE(198);
      END_STATE();
    case 225:
      if (lookahead == 'U') ADVANCE(88);
      END_STATE();
    case 226:
      if (lookahead == 'U') ADVANCE(143);
      END_STATE();
    case 227:
      if (lookahead == 'V') ADVANCE(85);
      END_STATE();
    case 228:
      if (lookahead == 'V') ADVANCE(90);
      END_STATE();
    case 229:
      if (lookahead == 'V') ADVANCE(96);
      END_STATE();
    case 230:
      if (lookahead == 'V') ADVANCE(129);
      END_STATE();
    case 231:
      if (lookahead == 'W') ADVANCE(574);
      END_STATE();
    case 232:
      if (lookahead == 'X') ADVANCE(7);
      END_STATE();
    case 233:
      if (lookahead == 'X') ADVANCE(65);
      END_STATE();
    case 234:
      if (lookahead == 'Y') ADVANCE(590);
      END_STATE();
    case 235:
      if (lookahead == 'Y') ADVANCE(541);
      END_STATE();
    case 236:
      if (lookahead == ']') ADVANCE(482);
      END_STATE();
    case 237:
      if (lookahead == '_') ADVANCE(518);
      END_STATE();
    case 238:
      if (lookahead == '_') ADVANCE(520);
      END_STATE();
    case 239:
      if (lookahead == '_') ADVANCE(876);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(291);
      END_STATE();
    case 241:
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'd') ADVANCE(316);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'o') ADVANCE(308);
      if (lookahead == 'u') ADVANCE(322);
      END_STATE();
    case 242:
      if (lookahead == 'a') ADVANCE(304);
      if (lookahead == 'e') ADVANCE(331);
      if (lookahead == 'l') ADVANCE(946);
      if (lookahead == 'n') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(341);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(304);
      if (lookahead == 'e') ADVANCE(331);
      if (lookahead == 'l') ADVANCE(946);
      if (lookahead == 'o') ADVANCE(341);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(351);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(324);
      if (lookahead == 'u') ADVANCE(325);
      END_STATE();
    case 246:
      if (lookahead == 'a') ADVANCE(342);
      END_STATE();
    case 247:
      if (lookahead == 'a') ADVANCE(297);
      END_STATE();
    case 248:
      if (lookahead == 'b') ADVANCE(359);
      if (lookahead == 'c') ADVANCE(253);
      if (lookahead == 'p') ADVANCE(360);
      END_STATE();
    case 249:
      if (lookahead == 'b') ADVANCE(361);
      if (lookahead == 'p') ADVANCE(362);
      END_STATE();
    case 250:
      if (lookahead == 'c') ADVANCE(245);
      if (lookahead == 's') ADVANCE(378);
      END_STATE();
    case 251:
      if (lookahead == 'c') ADVANCE(1038);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(950);
      END_STATE();
    case 253:
      if (lookahead == 'c') ADVANCE(952);
      END_STATE();
    case 254:
      if (lookahead == 'c') ADVANCE(1030);
      END_STATE();
    case 255:
      if (lookahead == 'c') ADVANCE(253);
      END_STATE();
    case 256:
      if (lookahead == 'c') ADVANCE(289);
      END_STATE();
    case 257:
      if (lookahead == 'c') ADVANCE(374);
      END_STATE();
    case 258:
      if (lookahead == 'd') ADVANCE(901);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'g') ADVANCE(944);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(275);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(275);
      if (lookahead == 'o') ADVANCE(377);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(332);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 264:
      if (lookahead == 'e') ADVANCE(252);
      if (lookahead == 'o') ADVANCE(327);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(352);
      END_STATE();
    case 266:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(349);
      END_STATE();
    case 268:
      if (lookahead == 'e') ADVANCE(356);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(369);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(370);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(371);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(372);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 274:
      if (lookahead == 'g') ADVANCE(256);
      END_STATE();
    case 275:
      if (lookahead == 'g') ADVANCE(878);
      END_STATE();
    case 276:
      if (lookahead == 'g') ADVANCE(940);
      END_STATE();
    case 277:
      if (lookahead == 'h') ADVANCE(1020);
      END_STATE();
    case 278:
      if (lookahead == 'i') ADVANCE(274);
      if (lookahead == 'u') ADVANCE(296);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(274);
      if (lookahead == 'u') ADVANCE(296);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(849);
      END_STATE();
    case 280:
      if (lookahead == 'i') ADVANCE(383);
      if (lookahead == 'o') ADVANCE(365);
      END_STATE();
    case 281:
      if (lookahead == 'i') ADVANCE(299);
      if (lookahead == 'q') ADVANCE(250);
      if (lookahead == 't') ADVANCE(246);
      if (lookahead == 'u') ADVANCE(248);
      END_STATE();
    case 282:
      if (lookahead == 'i') ADVANCE(299);
      if (lookahead == 'q') ADVANCE(250);
      if (lookahead == 't') ADVANCE(246);
      if (lookahead == 'u') ADVANCE(255);
      END_STATE();
    case 283:
      if (lookahead == 'i') ADVANCE(358);
      END_STATE();
    case 284:
      if (lookahead == 'i') ADVANCE(384);
      END_STATE();
    case 285:
      if (lookahead == 'i') ADVANCE(300);
      END_STATE();
    case 286:
      if (lookahead == 'i') ADVANCE(318);
      END_STATE();
    case 287:
      if (lookahead == 'i') ADVANCE(311);
      END_STATE();
    case 288:
      if (lookahead == 'i') ADVANCE(305);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 290:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 291:
      if (lookahead == 'l') ADVANCE(865);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(463);
      END_STATE();
    case 293:
      if (lookahead == 'l') ADVANCE(379);
      END_STATE();
    case 294:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 295:
      if (lookahead == 'l') ADVANCE(269);
      END_STATE();
    case 296:
      if (lookahead == 'l') ADVANCE(295);
      END_STATE();
    case 297:
      if (lookahead == 'l') ADVANCE(292);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(381);
      END_STATE();
    case 299:
      if (lookahead == 'm') ADVANCE(960);
      END_STATE();
    case 300:
      if (lookahead == 'm') ADVANCE(265);
      END_STATE();
    case 301:
      if (lookahead == 'm') ADVANCE(323);
      END_STATE();
    case 302:
      if (lookahead == 'm') ADVANCE(268);
      END_STATE();
    case 303:
      if (lookahead == 'n') ADVANCE(458);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 305:
      if (lookahead == 'n') ADVANCE(948);
      END_STATE();
    case 306:
      if (lookahead == 'n') ADVANCE(993);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(457);
      END_STATE();
    case 308:
      if (lookahead == 'n') ADVANCE(276);
      END_STATE();
    case 309:
      if (lookahead == 'n') ADVANCE(286);
      if (lookahead == 'p') ADVANCE(298);
      END_STATE();
    case 310:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 311:
      if (lookahead == 'n') ADVANCE(382);
      END_STATE();
    case 312:
      if (lookahead == 'o') ADVANCE(385);
      END_STATE();
    case 313:
      if (lookahead == 'o') ADVANCE(958);
      END_STATE();
    case 314:
      if (lookahead == 'o') ADVANCE(377);
      END_STATE();
    case 315:
      if (lookahead == 'o') ADVANCE(348);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(366);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(367);
      END_STATE();
    case 318:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 319:
      if (lookahead == 'o') ADVANCE(368);
      END_STATE();
    case 320:
      if (lookahead == 'p') ADVANCE(326);
      if (lookahead == 's') ADVANCE(386);
      END_STATE();
    case 321:
      if (lookahead == 'p') ADVANCE(989);
      END_STATE();
    case 322:
      if (lookahead == 'p') ADVANCE(992);
      END_STATE();
    case 323:
      if (lookahead == 'p') ADVANCE(938);
      END_STATE();
    case 324:
      if (lookahead == 'p') ADVANCE(1049);
      END_STATE();
    case 325:
      if (lookahead == 'p') ADVANCE(1051);
      END_STATE();
    case 326:
      if (lookahead == 'p') ADVANCE(345);
      END_STATE();
    case 327:
      if (lookahead == 'p') ADVANCE(375);
      END_STATE();
    case 328:
      if (lookahead == 'q') ADVANCE(380);
      END_STATE();
    case 329:
      if (lookahead == 'q') ADVANCE(380);
      if (lookahead == 'x') ADVANCE(283);
      END_STATE();
    case 330:
      if (lookahead == 'q') ADVANCE(925);
      END_STATE();
    case 331:
      if (lookahead == 'q') ADVANCE(922);
      END_STATE();
    case 332:
      if (lookahead == 'q') ADVANCE(942);
      END_STATE();
    case 333:
      if (lookahead == 'q') ADVANCE(962);
      END_STATE();
    case 334:
      if (lookahead == 'q') ADVANCE(954);
      END_STATE();
    case 335:
      if (lookahead == 'q') ADVANCE(956);
      END_STATE();
    case 336:
      if (lookahead == 'q') ADVANCE(976);
      END_STATE();
    case 337:
      if (lookahead == 'q') ADVANCE(978);
      END_STATE();
    case 338:
      if (lookahead == 'q') ADVANCE(968);
      END_STATE();
    case 339:
      if (lookahead == 'q') ADVANCE(970);
      END_STATE();
    case 340:
      if (lookahead == 'r') ADVANCE(1058);
      END_STATE();
    case 341:
      if (lookahead == 'r') ADVANCE(904);
      END_STATE();
    case 342:
      if (lookahead == 'r') ADVANCE(1040);
      END_STATE();
    case 343:
      if (lookahead == 'r') ADVANCE(264);
      END_STATE();
    case 344:
      if (lookahead == 'r') ADVANCE(251);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(312);
      END_STATE();
    case 346:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 347:
      if (lookahead == 'r') ADVANCE(263);
      END_STATE();
    case 348:
      if (lookahead == 'r') ADVANCE(247);
      END_STATE();
    case 349:
      if (lookahead == 'r') ADVANCE(357);
      END_STATE();
    case 350:
      if (lookahead == 's') ADVANCE(1001);
      END_STATE();
    case 351:
      if (lookahead == 's') ADVANCE(277);
      END_STATE();
    case 352:
      if (lookahead == 's') ADVANCE(1056);
      END_STATE();
    case 353:
      if (lookahead == 's') ADVANCE(1053);
      END_STATE();
    case 354:
      if (lookahead == 's') ADVANCE(466);
      END_STATE();
    case 355:
      if (lookahead == 's') ADVANCE(1004);
      END_STATE();
    case 356:
      if (lookahead == 's') ADVANCE(1023);
      END_STATE();
    case 357:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 358:
      if (lookahead == 's') ADVANCE(376);
      END_STATE();
    case 359:
      if (lookahead == 's') ADVANCE(270);
      END_STATE();
    case 360:
      if (lookahead == 's') ADVANCE(271);
      END_STATE();
    case 361:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 362:
      if (lookahead == 's') ADVANCE(273);
      END_STATE();
    case 363:
      if (lookahead == 't') ADVANCE(863);
      END_STATE();
    case 364:
      if (lookahead == 't') ADVANCE(861);
      END_STATE();
    case 365:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 366:
      if (lookahead == 't') ADVANCE(1060);
      END_STATE();
    case 367:
      if (lookahead == 't') ADVANCE(877);
      END_STATE();
    case 368:
      if (lookahead == 't') ADVANCE(1017);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(1032);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(972);
      END_STATE();
    case 371:
      if (lookahead == 't') ADVANCE(974);
      END_STATE();
    case 372:
      if (lookahead == 't') ADVANCE(964);
      END_STATE();
    case 373:
      if (lookahead == 't') ADVANCE(966);
      END_STATE();
    case 374:
      if (lookahead == 't') ADVANCE(990);
      END_STATE();
    case 375:
      if (lookahead == 't') ADVANCE(313);
      END_STATE();
    case 376:
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 378:
      if (lookahead == 'u') ADVANCE(249);
      END_STATE();
    case 379:
      if (lookahead == 'u') ADVANCE(350);
      END_STATE();
    case 380:
      if (lookahead == 'u') ADVANCE(284);
      END_STATE();
    case 381:
      if (lookahead == 'u') ADVANCE(353);
      END_STATE();
    case 382:
      if (lookahead == 'u') ADVANCE(355);
      END_STATE();
    case 383:
      if (lookahead == 'v') ADVANCE(1034);
      END_STATE();
    case 384:
      if (lookahead == 'v') ADVANCE(894);
      END_STATE();
    case 385:
      if (lookahead == 'x') ADVANCE(927);
      END_STATE();
    case 386:
      if (lookahead == 'y') ADVANCE(301);
      END_STATE();
    case 387:
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(2);
      END_STATE();
    case 388:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(849);
      END_STATE();
    case 389:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(389)
      if (lookahead == '\r') SKIP(389)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'A') ADVANCE(786);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(637);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'H') ADVANCE(593);
      if (lookahead == 'I') ADVANCE(675);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'P') ADVANCE(693);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(677);
      if (lookahead == 'T') ADVANCE(594);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'W') ADVANCE(682);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 390:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(390)
      if (lookahead == '\r') SKIP(390)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(883);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(874);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(598);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(675);
      if (lookahead == 'L') ADVANCE(651);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(662);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(688);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 391:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(391)
      if (lookahead == '\r') SKIP(391)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'A') ADVANCE(629);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(599);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(654);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(679);
      if (lookahead == 'T') ADVANCE(665);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'V') ADVANCE(616);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 392:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(392)
      if (lookahead == '\r') SKIP(392)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(660);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'M') ADVANCE(762);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'O') ADVANCE(746);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 393:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(393)
      if (lookahead == '\r') SKIP(393)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(660);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'M') ADVANCE(762);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 394:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(394)
      if (lookahead == '\r') SKIP(394)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(607);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(492);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 395:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(395)
      if (lookahead == '\r') SKIP(395)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(492);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 396:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(396)
      if (lookahead == '\r') SKIP(396)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(674);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(662);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 397:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(397)
      if (lookahead == '\r') SKIP(397)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (lookahead == 12297) ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 398:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(398)
      if (lookahead == '\r') SKIP(398)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'O') ADVANCE(805);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 399:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(399)
      if (lookahead == '\r') SKIP(399)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'A') ADVANCE(786);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 400:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(400)
      if (lookahead == '\r') SKIP(400)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(883);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(874);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 401:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(401)
      if (lookahead == '\r') SKIP(401)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 402:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(402)
      if (lookahead == '\r') SKIP(402)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (lookahead == 12297) ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 403:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(403)
      if (lookahead == '\r') SKIP(403)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'I') ADVANCE(739);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 404:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(404)
      if (lookahead == '\r') SKIP(404)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 405:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(405)
      if (lookahead == '\r') SKIP(405)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'E') ADVANCE(233);
      if (lookahead == 'P') ADVANCE(193);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == ']') ADVANCE(239);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10230) ADVANCE(473);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 406:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(406)
      if (lookahead == '\r') SKIP(406)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(77);
      if (lookahead == 'E') ADVANCE(146);
      if (lookahead == 'P') ADVANCE(193);
      if (lookahead == 'T') ADVANCE(121);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == ']') ADVANCE(842);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 407:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(407)
      if (lookahead == '\r') SKIP(407)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(873);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(840);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 408:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(408)
      if (lookahead == '\r') SKIP(408)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(918);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12297) ADVANCE(479);
      END_STATE();
    case 409:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(409)
      if (lookahead == '\r') SKIP(409)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 410:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(410)
      if (lookahead == '\r') SKIP(410)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1009);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10236) ADVANCE(471);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 411:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(411)
      if (lookahead == '\r') SKIP(411)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(873);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(840);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 412:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(412)
      if (lookahead == '\r') SKIP(412)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 413:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(413)
      if (lookahead == '\r') SKIP(413)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(883);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(872);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 414:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(414)
      if (lookahead == '\r') SKIP(414)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(485);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'E') ADVANCE(233);
      if (lookahead == '[') ADVANCE(840);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == ']') ADVANCE(239);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1009);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10230) ADVANCE(473);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10236) ADVANCE(471);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 415:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(415)
      if (lookahead == '\r') SKIP(415)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(485);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'D') ADVANCE(77);
      if (lookahead == 'E') ADVANCE(146);
      if (lookahead == 'P') ADVANCE(193);
      if (lookahead == 'T') ADVANCE(121);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == ']') ADVANCE(842);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      END_STATE();
    case 416:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(416)
      if (lookahead == '\r') SKIP(416)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10230) ADVANCE(473);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 417:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(418)
      if (lookahead == '\r') SKIP(418)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1074);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(484);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(1071);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(740);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(842);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '|') ADVANCE(20);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 10229) ADVANCE(461);
      if (lookahead == 10236) ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1075);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 418:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(418)
      if (lookahead == '\r') SKIP(418)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(484);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(740);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == ']') ADVANCE(842);
      if (lookahead == '|') ADVANCE(20);
      if (lookahead == '}') ADVANCE(868);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 10229) ADVANCE(461);
      if (lookahead == 10236) ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 419:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(420)
      if (lookahead == '\r') SKIP(420)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1074);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(484);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 12297) ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1075);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 420:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(420)
      if (lookahead == '\r') SKIP(420)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(484);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(35);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 12297) ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 421:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(421)
      if (lookahead == '\r') SKIP(421)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(660);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 422:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(422)
      if (lookahead == '\r') SKIP(422)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == 'W') ADVANCE(698);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 423:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(423)
      if (lookahead == '\r') SKIP(423)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'M') ADVANCE(762);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 424:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(424)
      if (lookahead == '\r') SKIP(424)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '.') ADVANCE(869);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(871);
      if (lookahead == 'A') ADVANCE(630);
      if (lookahead == 'C') ADVANCE(768);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(808);
      if (lookahead == 'T') ADVANCE(666);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'V') ADVANCE(616);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(492);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 425:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(426)
      if (lookahead == '\r') SKIP(426)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1074);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'I') ADVANCE(739);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 10229) ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1075);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 426:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(426)
      if (lookahead == '\r') SKIP(426)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '=') ADVANCE(29);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'I') ADVANCE(739);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8796) ADVANCE(456);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 10229) ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 427:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(427)
      if (lookahead == '\r') SKIP(427)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 428:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(428)
      if (lookahead == '\r') SKIP(428)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 429:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(430)
      if (lookahead == '\r') SKIP(430)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == '*') ADVANCE(1074);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(492);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1075);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 430:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(430)
      if (lookahead == '\r') SKIP(430)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(492);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 431:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(431)
      if (lookahead == '\r') SKIP(431)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'I') ADVANCE(739);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(698);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 432:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(432)
      if (lookahead == '\r') SKIP(432)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(698);
      if (lookahead == '[') ADVANCE(236);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(879);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 9633) ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 433:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(433)
      if (lookahead == '\r') SKIP(433)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 10229) ADVANCE(461);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 434:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(434)
      if (lookahead == '\r') SKIP(434)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '<') ADVANCE(913);
      if (lookahead == 'P') ADVANCE(193);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '_') ADVANCE(491);
      if (lookahead == 8712) ADVANCE(459);
      END_STATE();
    case 435:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(434)
      if (lookahead == '\r') SKIP(434)
      if (lookahead == '!') ADVANCE(843);
      if (lookahead == '(') ADVANCE(837);
      if (lookahead == ')') ADVANCE(839);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(1069);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '<') ADVANCE(913);
      if (lookahead == 'P') ADVANCE(193);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '_') ADVANCE(491);
      if (lookahead == 8712) ADVANCE(459);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1070);
      END_STATE();
    case 436:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(436)
      if (lookahead == '\r') SKIP(436)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '\\') ADVANCE(10);
      END_STATE();
    case 437:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(436)
      if (lookahead == '\r') SKIP(436)
      if (lookahead == '(') ADVANCE(8);
      if (lookahead == '\\') ADVANCE(10);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1076);
      END_STATE();
    case 438:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(438)
      if (lookahead == '\r') SKIP(438)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(607);
      if (lookahead == 'M') ADVANCE(762);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 439:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(439)
      if (lookahead == '\r') SKIP(439)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(675);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 440:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(440)
      if (lookahead == '\r') SKIP(440)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(883);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(874);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == 'A') ADVANCE(797);
      if (lookahead == 'C') ADVANCE(754);
      if (lookahead == 'D') ADVANCE(660);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'H') ADVANCE(692);
      if (lookahead == 'I') ADVANCE(743);
      if (lookahead == 'L') ADVANCE(669);
      if (lookahead == 'P') ADVANCE(777);
      if (lookahead == 'R') ADVANCE(663);
      if (lookahead == 'S') ADVANCE(817);
      if (lookahead == 'T') ADVANCE(689);
      if (lookahead == 'U') ADVANCE(730);
      if (lookahead == 'V') ADVANCE(613);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 441:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(441)
      if (lookahead == '\r') SKIP(441)
      if (lookahead == '!') ADVANCE(844);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == ',') ADVANCE(836);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(870);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(37);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(32);
      if (lookahead == 215) ADVANCE(1057);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8733) ADVANCE(959);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8759) ADVANCE(490);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8834) ADVANCE(973);
      if (lookahead == 8835) ADVANCE(975);
      if (lookahead == 8838) ADVANCE(977);
      if (lookahead == 8839) ADVANCE(979);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12297) ADVANCE(478);
      END_STATE();
    case 442:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(442)
      if (lookahead == '\r') SKIP(442)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(911);
      if (lookahead == '$') ADVANCE(1047);
      if (lookahead == '%') ADVANCE(1007);
      if (lookahead == '&') ADVANCE(1015);
      if (lookahead == '\'') ADVANCE(1068);
      if (lookahead == '(') ADVANCE(838);
      if (lookahead == '*') ADVANCE(1026);
      if (lookahead == '+') ADVANCE(999);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(1028);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(914);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(917);
      if (lookahead == '?') ADVANCE(36);
      if (lookahead == '@') ADVANCE(487);
      if (lookahead == 'B') ADVANCE(756);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(753);
      if (lookahead == 'E') ADVANCE(741);
      if (lookahead == 'F') ADVANCE(592);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(638);
      if (lookahead == 'M') ADVANCE(762);
      if (lookahead == 'N') ADVANCE(830);
      if (lookahead == 'R') ADVANCE(831);
      if (lookahead == 'S') ADVANCE(678);
      if (lookahead == 'T') ADVANCE(773);
      if (lookahead == 'U') ADVANCE(731);
      if (lookahead == 'W') ADVANCE(683);
      if (lookahead == '[') ADVANCE(841);
      if (lookahead == '\\') ADVANCE(984);
      if (lookahead == '^') ADVANCE(1062);
      if (lookahead == '_') ADVANCE(445);
      if (lookahead == '{') ADVANCE(867);
      if (lookahead == '|') ADVANCE(1010);
      if (lookahead == '~') ADVANCE(880);
      if (lookahead == 172) ADVANCE(881);
      if (lookahead == 247) ADVANCE(1035);
      if (lookahead == 8214) ADVANCE(1012);
      if (lookahead == 8229) ADVANCE(996);
      if (lookahead == 8230) ADVANCE(998);
      if (lookahead == 8252) ADVANCE(1043);
      if (lookahead == 8263) ADVANCE(1045);
      if (lookahead == 8314) ADVANCE(1065);
      if (lookahead == 8669) ADVANCE(899);
      if (lookahead == 8696) ADVANCE(893);
      if (lookahead == 8704) ADVANCE(464);
      if (lookahead == 8707) ADVANCE(467);
      if (lookahead == 8712) ADVANCE(459);
      if (lookahead == 8713) ADVANCE(949);
      if (lookahead == 8728) ADVANCE(1039);
      if (lookahead == 8743) ADVANCE(902);
      if (lookahead == 8744) ADVANCE(905);
      if (lookahead == 8745) ADVANCE(991);
      if (lookahead == 8746) ADVANCE(994);
      if (lookahead == 8764) ADVANCE(961);
      if (lookahead == 8768) ADVANCE(1059);
      if (lookahead == 8771) ADVANCE(963);
      if (lookahead == 8773) ADVANCE(941);
      if (lookahead == 8776) ADVANCE(928);
      if (lookahead == 8781) ADVANCE(939);
      if (lookahead == 8784) ADVANCE(943);
      if (lookahead == 8788) ADVANCE(907);
      if (lookahead == 8800) ADVANCE(912);
      if (lookahead == 8801) ADVANCE(895);
      if (lookahead == 8804) ADVANCE(923);
      if (lookahead == 8805) ADVANCE(926);
      if (lookahead == 8810) ADVANCE(947);
      if (lookahead == 8811) ADVANCE(945);
      if (lookahead == 8826) ADVANCE(951);
      if (lookahead == 8827) ADVANCE(953);
      if (lookahead == 8846) ADVANCE(1054);
      if (lookahead == 8847) ADVANCE(965);
      if (lookahead == 8848) ADVANCE(967);
      if (lookahead == 8849) ADVANCE(969);
      if (lookahead == 8850) ADVANCE(971);
      if (lookahead == 8851) ADVANCE(1050);
      if (lookahead == 8852) ADVANCE(1052);
      if (lookahead == 8853) ADVANCE(1003);
      if (lookahead == 8854) ADVANCE(1006);
      if (lookahead == 8855) ADVANCE(1025);
      if (lookahead == 8856) ADVANCE(1022);
      if (lookahead == 8857) ADVANCE(1019);
      if (lookahead == 8866) ADVANCE(931);
      if (lookahead == 8867) ADVANCE(935);
      if (lookahead == 8872) ADVANCE(933);
      if (lookahead == 8900) ADVANCE(889);
      if (lookahead == 8901) ADVANCE(1061);
      if (lookahead == 8902) ADVANCE(1041);
      if (lookahead == 9633) ADVANCE(483);
      if (lookahead == 9679) ADVANCE(1033);
      if (lookahead == 9711) ADVANCE(1031);
      if (lookahead == 10233) ADVANCE(891);
      if (lookahead == 10234) ADVANCE(897);
      if (lookahead == 10868) ADVANCE(909);
      if (lookahead == 10927) ADVANCE(955);
      if (lookahead == 10928) ADVANCE(957);
      if (lookahead == 10980) ADVANCE(937);
      if (lookahead == 12296) ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 443:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(850);
      END_STATE();
    case 444:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(848);
      END_STATE();
    case 445:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 446:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(851);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(448);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_MODULE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_single_line);
      if (lookahead == '-') ADVANCE(452);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_double_line);
      if (lookahead == '=') ADVANCE(453);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(468);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(469);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_BSLASHAA);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_BSLASHEE);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_8);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(480);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_9);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_9);
      if (lookahead == '_') ADVANCE(481);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_10);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(489);
      if (lookahead == '=') ADVANCE(906);
      if (lookahead == '>') ADVANCE(981);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '=') ADVANCE(906);
      if (lookahead == '>') ADVANCE(981);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(980);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(908);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_11);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(445);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_UNION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(512);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(513);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_OTHER);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_CASE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_SF_);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_WF_);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_IF);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_WITH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(536);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(537);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_IN);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_IN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_LET);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_HAVE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_TAKE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'S') ADVANCE(569);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'S') ADVANCE(570);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_HIDE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_USE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_PICK);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_DEFS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_NEW);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_STATE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_ACTION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_ONLY);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(719);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(822);
      if (lookahead == 'I') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(708);
      if (lookahead == 'R') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(620);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(587);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(577);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(788);
      if (lookahead == 'H') ADVANCE(758);
      if (lookahead == 'O') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(788);
      if (lookahead == 'H') ADVANCE(758);
      if (lookahead == 'O') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(788);
      if (lookahead == 'H') ADVANCE(758);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(696);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(709);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(774);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(750);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(710);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(742);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(724);
      if (lookahead == 'E') ADVANCE(800);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(810);
      if (lookahead == 'R') ADVANCE(695);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(810);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(735);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(745);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(778);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(621);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(622);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(782);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(796);
      if (lookahead == 'F') ADVANCE(684);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(796);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(635);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(715);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(717);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(691);
      if (lookahead == 'I') ADVANCE(760);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(707);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(819);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(667);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(650);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(602);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(815);
      if (lookahead == 'S') ADVANCE(787);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(815);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(503);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(548);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(642);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(821);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(597);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(785);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(681);
      if (lookahead == 'O') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(800);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(562);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(551);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(558);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(854);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(856);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(494);
      if (lookahead == 'P') ADVANCE(809);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(494);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(563);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(727);
      if (lookahead == 'O') ADVANCE(628);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(505);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(824);
      if (lookahead == 'a') ADVANCE(834);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(631);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(632);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(680);
      if (lookahead == 'O') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(801);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(625);
      if (lookahead == 'e') ADVANCE(829);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(625);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(729);
      if (lookahead == 'R') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(729);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(784);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(763);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(728);
      if (lookahead == 'O') ADVANCE(628);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(775);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(744);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(791);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(610);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(525);
      if (lookahead == 'N') ADVANCE(534);
      if (lookahead == 'n') ADVANCE(833);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(525);
      if (lookahead == 'N') ADVANCE(789);
      if (lookahead == 'n') ADVANCE(833);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(525);
      if (lookahead == 'n') ADVANCE(833);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(827);
      if (lookahead == 'T') ADVANCE(776);
      if (lookahead == 'U') ADVANCE(617);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(827);
      if (lookahead == 'T') ADVANCE(776);
      if (lookahead == 'U') ADVANCE(618);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(827);
      if (lookahead == 'T') ADVANCE(608);
      if (lookahead == 'U') ADVANCE(618);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(700);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(828);
      if (lookahead == 'I') ADVANCE(804);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(828);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(694);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(858);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(659);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(668);
      if (lookahead == 'R') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(668);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(670);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(606);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(624);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(626);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(732);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(734);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(761);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(806);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(823);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(749);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(766);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(767);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(769);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(615);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(814);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K') ADVANCE(643);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(583);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(826);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(713);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(603);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(673);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(658);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(652);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(656);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(657);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(793);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(646);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(508);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(540);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(619);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(596);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(647);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(725);
      if (lookahead == 'T') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(772);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(623);
      if (lookahead == 'S') ADVANCE(639);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(623);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(685);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(860);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(589);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(581);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(595);
      if (lookahead == 'X') ADVANCE(811);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(595);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(686);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(789);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(636);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(711);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(803);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(672);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(627);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(798);
      if (lookahead == 'R') ADVANCE(759);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(799);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(771);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(757);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(714);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(770);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(712);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(733);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(721);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(634);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(779);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(781);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(792);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(736);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(737);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(738);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(795);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'P') ADVANCE(765);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'P') ADVANCE(764);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(825);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(511);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(695);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(755);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(664);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(605);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(705);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(566);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(573);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(787);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(816);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(640);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(807);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(818);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(783);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(706);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(645);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(699);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(790);
      if (lookahead == 'X') ADVANCE(697);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(812);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(813);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(527);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(531);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(532);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(748);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(690);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(687);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(604);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(609);
      if (lookahead == 'U') ADVANCE(618);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(701);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(655);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(671);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(611);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(612);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(702);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(703);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(726);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(618);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(720);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(780);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(644);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(718);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'V') ADVANCE(641);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'V') ADVANCE(653);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W') ADVANCE(575);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'Y') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'Y') ADVANCE(591);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(521);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(832);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(834);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(829);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(866);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(864);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(862);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(449);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '+') ADVANCE(3);
      if (lookahead == '-') ADVANCE(4);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '\\') ADVANCE(232);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(482);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '!') ADVANCE(1042);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(444);
      if (lookahead == '_') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(845);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(846);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym__real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(848);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym__binary_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(849);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym__octal_number);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(850);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym__hex_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(851);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(anon_sym_TRUE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(anon_sym_FALSE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(anon_sym_STRING);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(anon_sym_STRING);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(anon_sym_BOOLEAN);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(anon_sym_BOOLEAN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(anon_sym_Nat);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(anon_sym_Int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(anon_sym_Real);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(835);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(995);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(921);
      if (lookahead == '=') ADVANCE(455);
      if (lookahead == '>') ADVANCE(890);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(921);
      if (lookahead == '=') ADVANCE(454);
      if (lookahead == '>') ADVANCE(890);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(921);
      if (lookahead == '=') ADVANCE(27);
      if (lookahead == '>') ADVANCE(890);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(921);
      if (lookahead == '>') ADVANCE(890);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(898);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(anon_sym_12);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(1014);
      if (lookahead == '.') ADVANCE(887);
      if (lookahead == '>') ADVANCE(472);
      if (lookahead == '|') ADVANCE(934);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(1014);
      if (lookahead == '.') ADVANCE(887);
      if (lookahead == '|') ADVANCE(934);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(1013);
      if (lookahead == '.') ADVANCE(887);
      if (lookahead == '|') ADVANCE(934);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(1013);
      if (lookahead == '>') ADVANCE(472);
      if (lookahead == '|') ADVANCE(934);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(14);
      if (lookahead == '-') ADVANCE(1013);
      if (lookahead == '|') ADVANCE(934);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(anon_sym_13);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(anon_sym_14);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(anon_sym_15);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_16);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_17);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_18);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_19);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_20);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_21);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_22);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(1046);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(anon_sym_23);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(982);
      if (lookahead == '<') ADVANCE(474);
      if (lookahead == '=') ADVANCE(920);
      if (lookahead == '>') ADVANCE(888);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(982);
      if (lookahead == '=') ADVANCE(920);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(982);
      if (lookahead == '=') ADVANCE(920);
      if (lookahead == '>') ADVANCE(888);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(924);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(924);
      if (lookahead == '>') ADVANCE(477);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(924);
      if (lookahead == '>') ADVANCE(476);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(896);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_24);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_25);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_26);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(470);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(anon_sym_27);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(anon_sym_28);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_29);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_30);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_31);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_32);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_33);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_34);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_35);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_36);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_37);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(335);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_38);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_39);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_40);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_41);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_42);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_43);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_44);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_45);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_46);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_47);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_48);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_49);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(anon_sym_50);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(anon_sym_51);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'A') ADVANCE(462);
      if (lookahead == 'B') ADVANCE(388);
      if (lookahead == 'E') ADVANCE(465);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(446);
      if (lookahead == 'O') ADVANCE(443);
      if (lookahead == 'X') ADVANCE(1055);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'f') ADVANCE(315);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(1037);
      if (lookahead == 'p') ADVANCE(343);
      if (lookahead == 's') ADVANCE(281);
      if (lookahead == 't') ADVANCE(285);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'A') ADVANCE(462);
      if (lookahead == 'B') ADVANCE(388);
      if (lookahead == 'E') ADVANCE(465);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(446);
      if (lookahead == 'O') ADVANCE(443);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'f') ADVANCE(315);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(1037);
      if (lookahead == 'p') ADVANCE(347);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'X') ADVANCE(1055);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(278);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(1036);
      if (lookahead == 'p') ADVANCE(343);
      if (lookahead == 's') ADVANCE(281);
      if (lookahead == 't') ADVANCE(285);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'X') ADVANCE(1055);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(278);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(314);
      if (lookahead == 'o') ADVANCE(1036);
      if (lookahead == 'p') ADVANCE(343);
      if (lookahead == 's') ADVANCE(281);
      if (lookahead == 't') ADVANCE(285);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(278);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(242);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == 'o') ADVANCE(1036);
      if (lookahead == 'p') ADVANCE(347);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(903);
      if (lookahead == 'a') ADVANCE(320);
      if (lookahead == 'b') ADVANCE(278);
      if (lookahead == 'c') ADVANCE(241);
      if (lookahead == 'd') ADVANCE(280);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == 'g') ADVANCE(259);
      if (lookahead == 'i') ADVANCE(303);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(314);
      if (lookahead == 'o') ADVANCE(1036);
      if (lookahead == 'p') ADVANCE(347);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 'u') ADVANCE(309);
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(anon_sym_52);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_53);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(997);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(anon_sym_54);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(anon_sym_55);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(1000);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(anon_sym_56);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(anon_sym_57);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(1008);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(930);
      if (lookahead == '=') ADVANCE(932);
      if (lookahead == '|') ADVANCE(1011);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(929);
      if (lookahead == '=') ADVANCE(932);
      if (lookahead == '|') ADVANCE(1011);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(anon_sym_58);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(15);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(1016);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(anon_sym_59);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(anon_sym_60);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(anon_sym_61);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(1027);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(1029);
      if (lookahead == '=') ADVANCE(910);
      if (lookahead == '\\') ADVANCE(900);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(anon_sym_62);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(anon_sym_63);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(anon_sym_64);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(319);
      if (lookahead == 'm') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(293);
      if (lookahead == 's') ADVANCE(294);
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(319);
      if (lookahead == 'm') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(293);
      if (lookahead == 's') ADVANCE(294);
      if (lookahead == 't') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(850);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(anon_sym_65);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(anon_sym_66);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(anon_sym_67);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(anon_sym_68);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(1048);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(anon_sym_69);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(anon_sym_70);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(anon_sym_71);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(anon_sym_72);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(anon_sym_73);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(anon_sym_74);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(1067);
      if (lookahead == '*') ADVANCE(1066);
      if (lookahead == '+') ADVANCE(1064);
      if (lookahead == '^') ADVANCE(1063);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(anon_sym_75);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1070);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1072);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(1073);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1075);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(835);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1076);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 389, .external_lex_state = 3},
  [3] = {.lex_state = 389, .external_lex_state = 3},
  [4] = {.lex_state = 389, .external_lex_state = 4},
  [5] = {.lex_state = 390, .external_lex_state = 4},
  [6] = {.lex_state = 390, .external_lex_state = 4},
  [7] = {.lex_state = 390, .external_lex_state = 4},
  [8] = {.lex_state = 390, .external_lex_state = 4},
  [9] = {.lex_state = 391, .external_lex_state = 4},
  [10] = {.lex_state = 391, .external_lex_state = 4},
  [11] = {.lex_state = 391, .external_lex_state = 4},
  [12] = {.lex_state = 391, .external_lex_state = 4},
  [13] = {.lex_state = 392, .external_lex_state = 4},
  [14] = {.lex_state = 392, .external_lex_state = 4},
  [15] = {.lex_state = 392, .external_lex_state = 4},
  [16] = {.lex_state = 392, .external_lex_state = 4},
  [17] = {.lex_state = 392, .external_lex_state = 4},
  [18] = {.lex_state = 392, .external_lex_state = 4},
  [19] = {.lex_state = 393, .external_lex_state = 4},
  [20] = {.lex_state = 393, .external_lex_state = 4},
  [21] = {.lex_state = 393, .external_lex_state = 4},
  [22] = {.lex_state = 393, .external_lex_state = 4},
  [23] = {.lex_state = 393, .external_lex_state = 4},
  [24] = {.lex_state = 393, .external_lex_state = 4},
  [25] = {.lex_state = 393, .external_lex_state = 4},
  [26] = {.lex_state = 393, .external_lex_state = 4},
  [27] = {.lex_state = 394, .external_lex_state = 4},
  [28] = {.lex_state = 438, .external_lex_state = 4},
  [29] = {.lex_state = 438, .external_lex_state = 4},
  [30] = {.lex_state = 438, .external_lex_state = 4},
  [31] = {.lex_state = 438, .external_lex_state = 4},
  [32] = {.lex_state = 395, .external_lex_state = 4},
  [33] = {.lex_state = 395, .external_lex_state = 4},
  [34] = {.lex_state = 395, .external_lex_state = 4},
  [35] = {.lex_state = 395, .external_lex_state = 4},
  [36] = {.lex_state = 396, .external_lex_state = 4},
  [37] = {.lex_state = 394, .external_lex_state = 4},
  [38] = {.lex_state = 396, .external_lex_state = 4},
  [39] = {.lex_state = 396, .external_lex_state = 4},
  [40] = {.lex_state = 396, .external_lex_state = 4},
  [41] = {.lex_state = 397, .external_lex_state = 4},
  [42] = {.lex_state = 394, .external_lex_state = 4},
  [43] = {.lex_state = 394, .external_lex_state = 4},
  [44] = {.lex_state = 394, .external_lex_state = 4},
  [45] = {.lex_state = 394, .external_lex_state = 4},
  [46] = {.lex_state = 394, .external_lex_state = 4},
  [47] = {.lex_state = 394, .external_lex_state = 4},
  [48] = {.lex_state = 398, .external_lex_state = 4},
  [49] = {.lex_state = 394, .external_lex_state = 4},
  [50] = {.lex_state = 394, .external_lex_state = 4},
  [51] = {.lex_state = 394, .external_lex_state = 4},
  [52] = {.lex_state = 394, .external_lex_state = 4},
  [53] = {.lex_state = 394, .external_lex_state = 4},
  [54] = {.lex_state = 394, .external_lex_state = 4},
  [55] = {.lex_state = 394, .external_lex_state = 4},
  [56] = {.lex_state = 394, .external_lex_state = 4},
  [57] = {.lex_state = 394, .external_lex_state = 4},
  [58] = {.lex_state = 394, .external_lex_state = 4},
  [59] = {.lex_state = 394, .external_lex_state = 4},
  [60] = {.lex_state = 394, .external_lex_state = 4},
  [61] = {.lex_state = 394, .external_lex_state = 4},
  [62] = {.lex_state = 395, .external_lex_state = 5},
  [63] = {.lex_state = 394, .external_lex_state = 4},
  [64] = {.lex_state = 398, .external_lex_state = 4},
  [65] = {.lex_state = 395, .external_lex_state = 5},
  [66] = {.lex_state = 394, .external_lex_state = 4},
  [67] = {.lex_state = 395, .external_lex_state = 5},
  [68] = {.lex_state = 394, .external_lex_state = 4},
  [69] = {.lex_state = 394, .external_lex_state = 4},
  [70] = {.lex_state = 395, .external_lex_state = 5},
  [71] = {.lex_state = 394, .external_lex_state = 4},
  [72] = {.lex_state = 398, .external_lex_state = 4},
  [73] = {.lex_state = 398, .external_lex_state = 4},
  [74] = {.lex_state = 394, .external_lex_state = 4},
  [75] = {.lex_state = 394, .external_lex_state = 4},
  [76] = {.lex_state = 394, .external_lex_state = 4},
  [77] = {.lex_state = 395, .external_lex_state = 4},
  [78] = {.lex_state = 394, .external_lex_state = 4},
  [79] = {.lex_state = 394, .external_lex_state = 4},
  [80] = {.lex_state = 394, .external_lex_state = 4},
  [81] = {.lex_state = 394, .external_lex_state = 4},
  [82] = {.lex_state = 394, .external_lex_state = 4},
  [83] = {.lex_state = 394, .external_lex_state = 4},
  [84] = {.lex_state = 397, .external_lex_state = 4},
  [85] = {.lex_state = 395, .external_lex_state = 4},
  [86] = {.lex_state = 398, .external_lex_state = 4},
  [87] = {.lex_state = 398, .external_lex_state = 4},
  [88] = {.lex_state = 397, .external_lex_state = 4},
  [89] = {.lex_state = 395, .external_lex_state = 5},
  [90] = {.lex_state = 395, .external_lex_state = 5},
  [91] = {.lex_state = 394, .external_lex_state = 4},
  [92] = {.lex_state = 395, .external_lex_state = 5},
  [93] = {.lex_state = 394, .external_lex_state = 4},
  [94] = {.lex_state = 395, .external_lex_state = 5},
  [95] = {.lex_state = 395, .external_lex_state = 4},
  [96] = {.lex_state = 395, .external_lex_state = 4},
  [97] = {.lex_state = 397, .external_lex_state = 4},
  [98] = {.lex_state = 397, .external_lex_state = 4},
  [99] = {.lex_state = 398, .external_lex_state = 4},
  [100] = {.lex_state = 398, .external_lex_state = 4},
  [101] = {.lex_state = 398, .external_lex_state = 4},
  [102] = {.lex_state = 398, .external_lex_state = 4},
  [103] = {.lex_state = 394, .external_lex_state = 4},
  [104] = {.lex_state = 394, .external_lex_state = 4},
  [105] = {.lex_state = 395, .external_lex_state = 4},
  [106] = {.lex_state = 394, .external_lex_state = 4},
  [107] = {.lex_state = 398, .external_lex_state = 4},
  [108] = {.lex_state = 394, .external_lex_state = 4},
  [109] = {.lex_state = 394, .external_lex_state = 4},
  [110] = {.lex_state = 395, .external_lex_state = 4},
  [111] = {.lex_state = 397, .external_lex_state = 4},
  [112] = {.lex_state = 398, .external_lex_state = 4},
  [113] = {.lex_state = 394, .external_lex_state = 4},
  [114] = {.lex_state = 398, .external_lex_state = 4},
  [115] = {.lex_state = 394, .external_lex_state = 4},
  [116] = {.lex_state = 394, .external_lex_state = 4},
  [117] = {.lex_state = 398, .external_lex_state = 4},
  [118] = {.lex_state = 394, .external_lex_state = 4},
  [119] = {.lex_state = 395, .external_lex_state = 4},
  [120] = {.lex_state = 394, .external_lex_state = 4},
  [121] = {.lex_state = 397, .external_lex_state = 4},
  [122] = {.lex_state = 398, .external_lex_state = 4},
  [123] = {.lex_state = 394, .external_lex_state = 4},
  [124] = {.lex_state = 398, .external_lex_state = 4},
  [125] = {.lex_state = 394, .external_lex_state = 4},
  [126] = {.lex_state = 397, .external_lex_state = 4},
  [127] = {.lex_state = 395, .external_lex_state = 4},
  [128] = {.lex_state = 397, .external_lex_state = 4},
  [129] = {.lex_state = 395, .external_lex_state = 4},
  [130] = {.lex_state = 397, .external_lex_state = 4},
  [131] = {.lex_state = 398, .external_lex_state = 4},
  [132] = {.lex_state = 398, .external_lex_state = 4},
  [133] = {.lex_state = 394, .external_lex_state = 4},
  [134] = {.lex_state = 398, .external_lex_state = 4},
  [135] = {.lex_state = 398, .external_lex_state = 4},
  [136] = {.lex_state = 397, .external_lex_state = 4},
  [137] = {.lex_state = 395, .external_lex_state = 4},
  [138] = {.lex_state = 398, .external_lex_state = 4},
  [139] = {.lex_state = 395, .external_lex_state = 4},
  [140] = {.lex_state = 398, .external_lex_state = 4},
  [141] = {.lex_state = 397, .external_lex_state = 4},
  [142] = {.lex_state = 398, .external_lex_state = 4},
  [143] = {.lex_state = 394, .external_lex_state = 4},
  [144] = {.lex_state = 397, .external_lex_state = 4},
  [145] = {.lex_state = 398, .external_lex_state = 4},
  [146] = {.lex_state = 394, .external_lex_state = 4},
  [147] = {.lex_state = 397, .external_lex_state = 4},
  [148] = {.lex_state = 394, .external_lex_state = 4},
  [149] = {.lex_state = 395, .external_lex_state = 4},
  [150] = {.lex_state = 394, .external_lex_state = 4},
  [151] = {.lex_state = 395, .external_lex_state = 4},
  [152] = {.lex_state = 397, .external_lex_state = 4},
  [153] = {.lex_state = 398, .external_lex_state = 4},
  [154] = {.lex_state = 398, .external_lex_state = 4},
  [155] = {.lex_state = 394, .external_lex_state = 4},
  [156] = {.lex_state = 394, .external_lex_state = 4},
  [157] = {.lex_state = 398, .external_lex_state = 4},
  [158] = {.lex_state = 398, .external_lex_state = 4},
  [159] = {.lex_state = 394, .external_lex_state = 4},
  [160] = {.lex_state = 395, .external_lex_state = 4},
  [161] = {.lex_state = 397, .external_lex_state = 4},
  [162] = {.lex_state = 397, .external_lex_state = 4},
  [163] = {.lex_state = 395, .external_lex_state = 4},
  [164] = {.lex_state = 398, .external_lex_state = 4},
  [165] = {.lex_state = 398, .external_lex_state = 4},
  [166] = {.lex_state = 394, .external_lex_state = 4},
  [167] = {.lex_state = 398, .external_lex_state = 4},
  [168] = {.lex_state = 397, .external_lex_state = 4},
  [169] = {.lex_state = 395, .external_lex_state = 4},
  [170] = {.lex_state = 394, .external_lex_state = 4},
  [171] = {.lex_state = 398, .external_lex_state = 4},
  [172] = {.lex_state = 439, .external_lex_state = 4},
  [173] = {.lex_state = 439, .external_lex_state = 4},
  [174] = {.lex_state = 442, .external_lex_state = 4},
  [175] = {.lex_state = 399, .external_lex_state = 4},
  [176] = {.lex_state = 395, .external_lex_state = 4},
  [177] = {.lex_state = 399, .external_lex_state = 4},
  [178] = {.lex_state = 439, .external_lex_state = 4},
  [179] = {.lex_state = 395, .external_lex_state = 4},
  [180] = {.lex_state = 395, .external_lex_state = 4},
  [181] = {.lex_state = 395, .external_lex_state = 4},
  [182] = {.lex_state = 395, .external_lex_state = 4},
  [183] = {.lex_state = 395, .external_lex_state = 4},
  [184] = {.lex_state = 395, .external_lex_state = 4},
  [185] = {.lex_state = 395, .external_lex_state = 4},
  [186] = {.lex_state = 395, .external_lex_state = 4},
  [187] = {.lex_state = 395, .external_lex_state = 4},
  [188] = {.lex_state = 395, .external_lex_state = 4},
  [189] = {.lex_state = 395, .external_lex_state = 4},
  [190] = {.lex_state = 439, .external_lex_state = 4},
  [191] = {.lex_state = 395, .external_lex_state = 4},
  [192] = {.lex_state = 395, .external_lex_state = 4},
  [193] = {.lex_state = 399, .external_lex_state = 4},
  [194] = {.lex_state = 439, .external_lex_state = 4},
  [195] = {.lex_state = 395, .external_lex_state = 4},
  [196] = {.lex_state = 395, .external_lex_state = 4},
  [197] = {.lex_state = 439, .external_lex_state = 4},
  [198] = {.lex_state = 439, .external_lex_state = 4},
  [199] = {.lex_state = 442, .external_lex_state = 4},
  [200] = {.lex_state = 439, .external_lex_state = 4},
  [201] = {.lex_state = 399, .external_lex_state = 4},
  [202] = {.lex_state = 439, .external_lex_state = 4},
  [203] = {.lex_state = 395, .external_lex_state = 4},
  [204] = {.lex_state = 395, .external_lex_state = 4},
  [205] = {.lex_state = 395, .external_lex_state = 4},
  [206] = {.lex_state = 395, .external_lex_state = 4},
  [207] = {.lex_state = 395, .external_lex_state = 4},
  [208] = {.lex_state = 395, .external_lex_state = 4},
  [209] = {.lex_state = 395, .external_lex_state = 4},
  [210] = {.lex_state = 395, .external_lex_state = 4},
  [211] = {.lex_state = 395, .external_lex_state = 4},
  [212] = {.lex_state = 395, .external_lex_state = 4},
  [213] = {.lex_state = 395, .external_lex_state = 4},
  [214] = {.lex_state = 395, .external_lex_state = 4},
  [215] = {.lex_state = 395, .external_lex_state = 4},
  [216] = {.lex_state = 395, .external_lex_state = 4},
  [217] = {.lex_state = 395, .external_lex_state = 4},
  [218] = {.lex_state = 395, .external_lex_state = 4},
  [219] = {.lex_state = 395, .external_lex_state = 4},
  [220] = {.lex_state = 395, .external_lex_state = 4},
  [221] = {.lex_state = 395, .external_lex_state = 4},
  [222] = {.lex_state = 395, .external_lex_state = 4},
  [223] = {.lex_state = 395, .external_lex_state = 4},
  [224] = {.lex_state = 395, .external_lex_state = 4},
  [225] = {.lex_state = 395, .external_lex_state = 4},
  [226] = {.lex_state = 395, .external_lex_state = 4},
  [227] = {.lex_state = 395, .external_lex_state = 4},
  [228] = {.lex_state = 395, .external_lex_state = 4},
  [229] = {.lex_state = 395, .external_lex_state = 4},
  [230] = {.lex_state = 395, .external_lex_state = 4},
  [231] = {.lex_state = 395, .external_lex_state = 4},
  [232] = {.lex_state = 395, .external_lex_state = 4},
  [233] = {.lex_state = 395, .external_lex_state = 4},
  [234] = {.lex_state = 395, .external_lex_state = 4},
  [235] = {.lex_state = 395, .external_lex_state = 4},
  [236] = {.lex_state = 395, .external_lex_state = 4},
  [237] = {.lex_state = 395, .external_lex_state = 4},
  [238] = {.lex_state = 395, .external_lex_state = 4},
  [239] = {.lex_state = 395, .external_lex_state = 4},
  [240] = {.lex_state = 395, .external_lex_state = 4},
  [241] = {.lex_state = 395, .external_lex_state = 4},
  [242] = {.lex_state = 395, .external_lex_state = 4},
  [243] = {.lex_state = 395, .external_lex_state = 4},
  [244] = {.lex_state = 395, .external_lex_state = 4},
  [245] = {.lex_state = 395, .external_lex_state = 4},
  [246] = {.lex_state = 395, .external_lex_state = 4},
  [247] = {.lex_state = 395, .external_lex_state = 4},
  [248] = {.lex_state = 395, .external_lex_state = 4},
  [249] = {.lex_state = 395, .external_lex_state = 4},
  [250] = {.lex_state = 395, .external_lex_state = 4},
  [251] = {.lex_state = 395, .external_lex_state = 4},
  [252] = {.lex_state = 395, .external_lex_state = 4},
  [253] = {.lex_state = 395, .external_lex_state = 4},
  [254] = {.lex_state = 395, .external_lex_state = 4},
  [255] = {.lex_state = 395, .external_lex_state = 4},
  [256] = {.lex_state = 395, .external_lex_state = 4},
  [257] = {.lex_state = 395, .external_lex_state = 4},
  [258] = {.lex_state = 395, .external_lex_state = 4},
  [259] = {.lex_state = 395, .external_lex_state = 4},
  [260] = {.lex_state = 395, .external_lex_state = 4},
  [261] = {.lex_state = 395, .external_lex_state = 4},
  [262] = {.lex_state = 395, .external_lex_state = 4},
  [263] = {.lex_state = 395, .external_lex_state = 4},
  [264] = {.lex_state = 395, .external_lex_state = 4},
  [265] = {.lex_state = 395, .external_lex_state = 4},
  [266] = {.lex_state = 395, .external_lex_state = 4},
  [267] = {.lex_state = 395, .external_lex_state = 4},
  [268] = {.lex_state = 395, .external_lex_state = 4},
  [269] = {.lex_state = 395, .external_lex_state = 4},
  [270] = {.lex_state = 395, .external_lex_state = 4},
  [271] = {.lex_state = 395, .external_lex_state = 4},
  [272] = {.lex_state = 395, .external_lex_state = 4},
  [273] = {.lex_state = 395, .external_lex_state = 4},
  [274] = {.lex_state = 395, .external_lex_state = 4},
  [275] = {.lex_state = 395, .external_lex_state = 4},
  [276] = {.lex_state = 395, .external_lex_state = 4},
  [277] = {.lex_state = 395, .external_lex_state = 4},
  [278] = {.lex_state = 395, .external_lex_state = 4},
  [279] = {.lex_state = 395, .external_lex_state = 4},
  [280] = {.lex_state = 395, .external_lex_state = 4},
  [281] = {.lex_state = 395, .external_lex_state = 4},
  [282] = {.lex_state = 395, .external_lex_state = 4},
  [283] = {.lex_state = 395, .external_lex_state = 4},
  [284] = {.lex_state = 395, .external_lex_state = 4},
  [285] = {.lex_state = 395, .external_lex_state = 4},
  [286] = {.lex_state = 395, .external_lex_state = 4},
  [287] = {.lex_state = 395, .external_lex_state = 4},
  [288] = {.lex_state = 395, .external_lex_state = 4},
  [289] = {.lex_state = 395, .external_lex_state = 4},
  [290] = {.lex_state = 395, .external_lex_state = 4},
  [291] = {.lex_state = 395, .external_lex_state = 4},
  [292] = {.lex_state = 395, .external_lex_state = 4},
  [293] = {.lex_state = 395, .external_lex_state = 4},
  [294] = {.lex_state = 395, .external_lex_state = 4},
  [295] = {.lex_state = 395, .external_lex_state = 4},
  [296] = {.lex_state = 395, .external_lex_state = 4},
  [297] = {.lex_state = 395, .external_lex_state = 4},
  [298] = {.lex_state = 395, .external_lex_state = 4},
  [299] = {.lex_state = 395, .external_lex_state = 4},
  [300] = {.lex_state = 395, .external_lex_state = 4},
  [301] = {.lex_state = 395, .external_lex_state = 4},
  [302] = {.lex_state = 395, .external_lex_state = 4},
  [303] = {.lex_state = 395, .external_lex_state = 4},
  [304] = {.lex_state = 395, .external_lex_state = 4},
  [305] = {.lex_state = 395, .external_lex_state = 4},
  [306] = {.lex_state = 395, .external_lex_state = 4},
  [307] = {.lex_state = 395, .external_lex_state = 4},
  [308] = {.lex_state = 395, .external_lex_state = 4},
  [309] = {.lex_state = 395, .external_lex_state = 4},
  [310] = {.lex_state = 395, .external_lex_state = 4},
  [311] = {.lex_state = 395, .external_lex_state = 4},
  [312] = {.lex_state = 395, .external_lex_state = 4},
  [313] = {.lex_state = 395, .external_lex_state = 4},
  [314] = {.lex_state = 395, .external_lex_state = 4},
  [315] = {.lex_state = 395, .external_lex_state = 4},
  [316] = {.lex_state = 395, .external_lex_state = 4},
  [317] = {.lex_state = 395, .external_lex_state = 4},
  [318] = {.lex_state = 395, .external_lex_state = 4},
  [319] = {.lex_state = 395, .external_lex_state = 4},
  [320] = {.lex_state = 395, .external_lex_state = 4},
  [321] = {.lex_state = 395, .external_lex_state = 4},
  [322] = {.lex_state = 395, .external_lex_state = 4},
  [323] = {.lex_state = 395, .external_lex_state = 4},
  [324] = {.lex_state = 395, .external_lex_state = 4},
  [325] = {.lex_state = 395, .external_lex_state = 4},
  [326] = {.lex_state = 395, .external_lex_state = 4},
  [327] = {.lex_state = 395, .external_lex_state = 4},
  [328] = {.lex_state = 395, .external_lex_state = 4},
  [329] = {.lex_state = 395, .external_lex_state = 4},
  [330] = {.lex_state = 395, .external_lex_state = 4},
  [331] = {.lex_state = 395, .external_lex_state = 4},
  [332] = {.lex_state = 395, .external_lex_state = 4},
  [333] = {.lex_state = 395, .external_lex_state = 4},
  [334] = {.lex_state = 395, .external_lex_state = 4},
  [335] = {.lex_state = 395, .external_lex_state = 4},
  [336] = {.lex_state = 395, .external_lex_state = 4},
  [337] = {.lex_state = 395, .external_lex_state = 4},
  [338] = {.lex_state = 395, .external_lex_state = 4},
  [339] = {.lex_state = 395, .external_lex_state = 4},
  [340] = {.lex_state = 395, .external_lex_state = 4},
  [341] = {.lex_state = 395, .external_lex_state = 4},
  [342] = {.lex_state = 395, .external_lex_state = 4},
  [343] = {.lex_state = 395, .external_lex_state = 4},
  [344] = {.lex_state = 395, .external_lex_state = 4},
  [345] = {.lex_state = 395, .external_lex_state = 4},
  [346] = {.lex_state = 395, .external_lex_state = 4},
  [347] = {.lex_state = 395, .external_lex_state = 4},
  [348] = {.lex_state = 395, .external_lex_state = 4},
  [349] = {.lex_state = 395, .external_lex_state = 4},
  [350] = {.lex_state = 395, .external_lex_state = 4},
  [351] = {.lex_state = 395, .external_lex_state = 4},
  [352] = {.lex_state = 395, .external_lex_state = 4},
  [353] = {.lex_state = 395, .external_lex_state = 4},
  [354] = {.lex_state = 395, .external_lex_state = 4},
  [355] = {.lex_state = 395, .external_lex_state = 4},
  [356] = {.lex_state = 395, .external_lex_state = 4},
  [357] = {.lex_state = 395, .external_lex_state = 4},
  [358] = {.lex_state = 395, .external_lex_state = 4},
  [359] = {.lex_state = 395, .external_lex_state = 4},
  [360] = {.lex_state = 395, .external_lex_state = 4},
  [361] = {.lex_state = 395, .external_lex_state = 4},
  [362] = {.lex_state = 395, .external_lex_state = 4},
  [363] = {.lex_state = 395, .external_lex_state = 4},
  [364] = {.lex_state = 395, .external_lex_state = 4},
  [365] = {.lex_state = 395, .external_lex_state = 4},
  [366] = {.lex_state = 395, .external_lex_state = 4},
  [367] = {.lex_state = 395, .external_lex_state = 4},
  [368] = {.lex_state = 395, .external_lex_state = 4},
  [369] = {.lex_state = 395, .external_lex_state = 4},
  [370] = {.lex_state = 395, .external_lex_state = 4},
  [371] = {.lex_state = 395, .external_lex_state = 4},
  [372] = {.lex_state = 395, .external_lex_state = 4},
  [373] = {.lex_state = 395, .external_lex_state = 4},
  [374] = {.lex_state = 395, .external_lex_state = 4},
  [375] = {.lex_state = 395, .external_lex_state = 4},
  [376] = {.lex_state = 395, .external_lex_state = 4},
  [377] = {.lex_state = 395, .external_lex_state = 4},
  [378] = {.lex_state = 395, .external_lex_state = 4},
  [379] = {.lex_state = 395, .external_lex_state = 4},
  [380] = {.lex_state = 395, .external_lex_state = 4},
  [381] = {.lex_state = 395, .external_lex_state = 4},
  [382] = {.lex_state = 395, .external_lex_state = 4},
  [383] = {.lex_state = 395, .external_lex_state = 4},
  [384] = {.lex_state = 395, .external_lex_state = 4},
  [385] = {.lex_state = 395, .external_lex_state = 4},
  [386] = {.lex_state = 395, .external_lex_state = 4},
  [387] = {.lex_state = 395, .external_lex_state = 4},
  [388] = {.lex_state = 395, .external_lex_state = 4},
  [389] = {.lex_state = 395, .external_lex_state = 4},
  [390] = {.lex_state = 395, .external_lex_state = 4},
  [391] = {.lex_state = 395, .external_lex_state = 4},
  [392] = {.lex_state = 395, .external_lex_state = 4},
  [393] = {.lex_state = 395, .external_lex_state = 4},
  [394] = {.lex_state = 395, .external_lex_state = 4},
  [395] = {.lex_state = 395, .external_lex_state = 4},
  [396] = {.lex_state = 395, .external_lex_state = 4},
  [397] = {.lex_state = 395, .external_lex_state = 4},
  [398] = {.lex_state = 395, .external_lex_state = 4},
  [399] = {.lex_state = 395, .external_lex_state = 4},
  [400] = {.lex_state = 395, .external_lex_state = 4},
  [401] = {.lex_state = 395, .external_lex_state = 4},
  [402] = {.lex_state = 395, .external_lex_state = 4},
  [403] = {.lex_state = 395, .external_lex_state = 4},
  [404] = {.lex_state = 395, .external_lex_state = 4},
  [405] = {.lex_state = 395, .external_lex_state = 4},
  [406] = {.lex_state = 395, .external_lex_state = 4},
  [407] = {.lex_state = 395, .external_lex_state = 4},
  [408] = {.lex_state = 395, .external_lex_state = 4},
  [409] = {.lex_state = 395, .external_lex_state = 4},
  [410] = {.lex_state = 395, .external_lex_state = 4},
  [411] = {.lex_state = 395, .external_lex_state = 4},
  [412] = {.lex_state = 395, .external_lex_state = 4},
  [413] = {.lex_state = 395, .external_lex_state = 4},
  [414] = {.lex_state = 395, .external_lex_state = 4},
  [415] = {.lex_state = 395, .external_lex_state = 4},
  [416] = {.lex_state = 395, .external_lex_state = 4},
  [417] = {.lex_state = 395, .external_lex_state = 4},
  [418] = {.lex_state = 395, .external_lex_state = 4},
  [419] = {.lex_state = 395, .external_lex_state = 4},
  [420] = {.lex_state = 395, .external_lex_state = 4},
  [421] = {.lex_state = 395, .external_lex_state = 4},
  [422] = {.lex_state = 395, .external_lex_state = 4},
  [423] = {.lex_state = 395, .external_lex_state = 4},
  [424] = {.lex_state = 395, .external_lex_state = 4},
  [425] = {.lex_state = 395, .external_lex_state = 4},
  [426] = {.lex_state = 395, .external_lex_state = 4},
  [427] = {.lex_state = 395, .external_lex_state = 4},
  [428] = {.lex_state = 395, .external_lex_state = 4},
  [429] = {.lex_state = 395, .external_lex_state = 4},
  [430] = {.lex_state = 395, .external_lex_state = 4},
  [431] = {.lex_state = 395, .external_lex_state = 4},
  [432] = {.lex_state = 395, .external_lex_state = 4},
  [433] = {.lex_state = 395, .external_lex_state = 4},
  [434] = {.lex_state = 395, .external_lex_state = 4},
  [435] = {.lex_state = 395, .external_lex_state = 4},
  [436] = {.lex_state = 395, .external_lex_state = 4},
  [437] = {.lex_state = 395, .external_lex_state = 4},
  [438] = {.lex_state = 395, .external_lex_state = 4},
  [439] = {.lex_state = 395, .external_lex_state = 4},
  [440] = {.lex_state = 395, .external_lex_state = 4},
  [441] = {.lex_state = 395, .external_lex_state = 4},
  [442] = {.lex_state = 395, .external_lex_state = 4},
  [443] = {.lex_state = 395, .external_lex_state = 4},
  [444] = {.lex_state = 395, .external_lex_state = 4},
  [445] = {.lex_state = 395, .external_lex_state = 4},
  [446] = {.lex_state = 395, .external_lex_state = 4},
  [447] = {.lex_state = 395, .external_lex_state = 4},
  [448] = {.lex_state = 395, .external_lex_state = 4},
  [449] = {.lex_state = 395, .external_lex_state = 4},
  [450] = {.lex_state = 395, .external_lex_state = 4},
  [451] = {.lex_state = 395, .external_lex_state = 4},
  [452] = {.lex_state = 395, .external_lex_state = 4},
  [453] = {.lex_state = 395, .external_lex_state = 4},
  [454] = {.lex_state = 395, .external_lex_state = 4},
  [455] = {.lex_state = 395, .external_lex_state = 4},
  [456] = {.lex_state = 395, .external_lex_state = 4},
  [457] = {.lex_state = 395, .external_lex_state = 4},
  [458] = {.lex_state = 395, .external_lex_state = 4},
  [459] = {.lex_state = 395, .external_lex_state = 4},
  [460] = {.lex_state = 395, .external_lex_state = 4},
  [461] = {.lex_state = 395, .external_lex_state = 4},
  [462] = {.lex_state = 395, .external_lex_state = 4},
  [463] = {.lex_state = 395, .external_lex_state = 4},
  [464] = {.lex_state = 395, .external_lex_state = 4},
  [465] = {.lex_state = 395, .external_lex_state = 4},
  [466] = {.lex_state = 395, .external_lex_state = 4},
  [467] = {.lex_state = 395, .external_lex_state = 4},
  [468] = {.lex_state = 395, .external_lex_state = 4},
  [469] = {.lex_state = 395, .external_lex_state = 4},
  [470] = {.lex_state = 395, .external_lex_state = 4},
  [471] = {.lex_state = 395, .external_lex_state = 4},
  [472] = {.lex_state = 395, .external_lex_state = 4},
  [473] = {.lex_state = 395, .external_lex_state = 4},
  [474] = {.lex_state = 395, .external_lex_state = 4},
  [475] = {.lex_state = 395, .external_lex_state = 4},
  [476] = {.lex_state = 395, .external_lex_state = 4},
  [477] = {.lex_state = 395, .external_lex_state = 4},
  [478] = {.lex_state = 395, .external_lex_state = 4},
  [479] = {.lex_state = 395, .external_lex_state = 4},
  [480] = {.lex_state = 395, .external_lex_state = 4},
  [481] = {.lex_state = 395, .external_lex_state = 4},
  [482] = {.lex_state = 395, .external_lex_state = 4},
  [483] = {.lex_state = 395, .external_lex_state = 4},
  [484] = {.lex_state = 395, .external_lex_state = 4},
  [485] = {.lex_state = 395, .external_lex_state = 4},
  [486] = {.lex_state = 395, .external_lex_state = 4},
  [487] = {.lex_state = 395, .external_lex_state = 4},
  [488] = {.lex_state = 395, .external_lex_state = 4},
  [489] = {.lex_state = 395, .external_lex_state = 4},
  [490] = {.lex_state = 395, .external_lex_state = 4},
  [491] = {.lex_state = 395, .external_lex_state = 4},
  [492] = {.lex_state = 395, .external_lex_state = 4},
  [493] = {.lex_state = 395, .external_lex_state = 4},
  [494] = {.lex_state = 395, .external_lex_state = 4},
  [495] = {.lex_state = 395, .external_lex_state = 4},
  [496] = {.lex_state = 395, .external_lex_state = 4},
  [497] = {.lex_state = 395, .external_lex_state = 4},
  [498] = {.lex_state = 395, .external_lex_state = 4},
  [499] = {.lex_state = 395, .external_lex_state = 4},
  [500] = {.lex_state = 395, .external_lex_state = 4},
  [501] = {.lex_state = 395, .external_lex_state = 4},
  [502] = {.lex_state = 395, .external_lex_state = 4},
  [503] = {.lex_state = 395, .external_lex_state = 4},
  [504] = {.lex_state = 395, .external_lex_state = 4},
  [505] = {.lex_state = 395, .external_lex_state = 4},
  [506] = {.lex_state = 395, .external_lex_state = 4},
  [507] = {.lex_state = 395, .external_lex_state = 4},
  [508] = {.lex_state = 395, .external_lex_state = 4},
  [509] = {.lex_state = 395, .external_lex_state = 4},
  [510] = {.lex_state = 395, .external_lex_state = 4},
  [511] = {.lex_state = 395, .external_lex_state = 4},
  [512] = {.lex_state = 395, .external_lex_state = 4},
  [513] = {.lex_state = 395, .external_lex_state = 4},
  [514] = {.lex_state = 395, .external_lex_state = 4},
  [515] = {.lex_state = 395, .external_lex_state = 4},
  [516] = {.lex_state = 395, .external_lex_state = 4},
  [517] = {.lex_state = 395, .external_lex_state = 4},
  [518] = {.lex_state = 395, .external_lex_state = 4},
  [519] = {.lex_state = 395, .external_lex_state = 4},
  [520] = {.lex_state = 395, .external_lex_state = 4},
  [521] = {.lex_state = 395, .external_lex_state = 4},
  [522] = {.lex_state = 395, .external_lex_state = 4},
  [523] = {.lex_state = 395, .external_lex_state = 4},
  [524] = {.lex_state = 395, .external_lex_state = 4},
  [525] = {.lex_state = 395, .external_lex_state = 4},
  [526] = {.lex_state = 395, .external_lex_state = 4},
  [527] = {.lex_state = 395, .external_lex_state = 4},
  [528] = {.lex_state = 395, .external_lex_state = 4},
  [529] = {.lex_state = 395, .external_lex_state = 4},
  [530] = {.lex_state = 395, .external_lex_state = 4},
  [531] = {.lex_state = 395, .external_lex_state = 4},
  [532] = {.lex_state = 395, .external_lex_state = 4},
  [533] = {.lex_state = 395, .external_lex_state = 4},
  [534] = {.lex_state = 395, .external_lex_state = 4},
  [535] = {.lex_state = 395, .external_lex_state = 4},
  [536] = {.lex_state = 395, .external_lex_state = 4},
  [537] = {.lex_state = 395, .external_lex_state = 4},
  [538] = {.lex_state = 395, .external_lex_state = 4},
  [539] = {.lex_state = 395, .external_lex_state = 4},
  [540] = {.lex_state = 395, .external_lex_state = 4},
  [541] = {.lex_state = 395, .external_lex_state = 4},
  [542] = {.lex_state = 395, .external_lex_state = 4},
  [543] = {.lex_state = 395, .external_lex_state = 4},
  [544] = {.lex_state = 395, .external_lex_state = 4},
  [545] = {.lex_state = 395, .external_lex_state = 4},
  [546] = {.lex_state = 395, .external_lex_state = 4},
  [547] = {.lex_state = 395, .external_lex_state = 4},
  [548] = {.lex_state = 395, .external_lex_state = 4},
  [549] = {.lex_state = 395, .external_lex_state = 4},
  [550] = {.lex_state = 395, .external_lex_state = 4},
  [551] = {.lex_state = 395, .external_lex_state = 4},
  [552] = {.lex_state = 395, .external_lex_state = 4},
  [553] = {.lex_state = 395, .external_lex_state = 4},
  [554] = {.lex_state = 395, .external_lex_state = 4},
  [555] = {.lex_state = 395, .external_lex_state = 4},
  [556] = {.lex_state = 395, .external_lex_state = 4},
  [557] = {.lex_state = 395, .external_lex_state = 4},
  [558] = {.lex_state = 395, .external_lex_state = 4},
  [559] = {.lex_state = 395, .external_lex_state = 4},
  [560] = {.lex_state = 395, .external_lex_state = 4},
  [561] = {.lex_state = 395, .external_lex_state = 4},
  [562] = {.lex_state = 395, .external_lex_state = 4},
  [563] = {.lex_state = 395, .external_lex_state = 4},
  [564] = {.lex_state = 395, .external_lex_state = 4},
  [565] = {.lex_state = 395, .external_lex_state = 4},
  [566] = {.lex_state = 395, .external_lex_state = 4},
  [567] = {.lex_state = 395, .external_lex_state = 4},
  [568] = {.lex_state = 395, .external_lex_state = 4},
  [569] = {.lex_state = 395, .external_lex_state = 4},
  [570] = {.lex_state = 395, .external_lex_state = 4},
  [571] = {.lex_state = 395, .external_lex_state = 4},
  [572] = {.lex_state = 395, .external_lex_state = 4},
  [573] = {.lex_state = 395, .external_lex_state = 4},
  [574] = {.lex_state = 395, .external_lex_state = 4},
  [575] = {.lex_state = 395, .external_lex_state = 4},
  [576] = {.lex_state = 395, .external_lex_state = 4},
  [577] = {.lex_state = 395, .external_lex_state = 4},
  [578] = {.lex_state = 395, .external_lex_state = 4},
  [579] = {.lex_state = 395, .external_lex_state = 4},
  [580] = {.lex_state = 395, .external_lex_state = 4},
  [581] = {.lex_state = 395, .external_lex_state = 4},
  [582] = {.lex_state = 395, .external_lex_state = 4},
  [583] = {.lex_state = 395, .external_lex_state = 4},
  [584] = {.lex_state = 395, .external_lex_state = 4},
  [585] = {.lex_state = 395, .external_lex_state = 4},
  [586] = {.lex_state = 395, .external_lex_state = 4},
  [587] = {.lex_state = 395, .external_lex_state = 4},
  [588] = {.lex_state = 395, .external_lex_state = 4},
  [589] = {.lex_state = 395, .external_lex_state = 4},
  [590] = {.lex_state = 395, .external_lex_state = 4},
  [591] = {.lex_state = 395, .external_lex_state = 4},
  [592] = {.lex_state = 395, .external_lex_state = 4},
  [593] = {.lex_state = 395, .external_lex_state = 4},
  [594] = {.lex_state = 395, .external_lex_state = 4},
  [595] = {.lex_state = 395, .external_lex_state = 4},
  [596] = {.lex_state = 395, .external_lex_state = 4},
  [597] = {.lex_state = 395, .external_lex_state = 4},
  [598] = {.lex_state = 395, .external_lex_state = 4},
  [599] = {.lex_state = 395, .external_lex_state = 4},
  [600] = {.lex_state = 395, .external_lex_state = 4},
  [601] = {.lex_state = 395, .external_lex_state = 4},
  [602] = {.lex_state = 395, .external_lex_state = 4},
  [603] = {.lex_state = 395, .external_lex_state = 4},
  [604] = {.lex_state = 395, .external_lex_state = 4},
  [605] = {.lex_state = 395, .external_lex_state = 4},
  [606] = {.lex_state = 395, .external_lex_state = 4},
  [607] = {.lex_state = 395, .external_lex_state = 4},
  [608] = {.lex_state = 395, .external_lex_state = 4},
  [609] = {.lex_state = 395, .external_lex_state = 4},
  [610] = {.lex_state = 395, .external_lex_state = 4},
  [611] = {.lex_state = 395, .external_lex_state = 4},
  [612] = {.lex_state = 395, .external_lex_state = 4},
  [613] = {.lex_state = 395, .external_lex_state = 4},
  [614] = {.lex_state = 395, .external_lex_state = 4},
  [615] = {.lex_state = 395, .external_lex_state = 4},
  [616] = {.lex_state = 395, .external_lex_state = 4},
  [617] = {.lex_state = 395, .external_lex_state = 4},
  [618] = {.lex_state = 395, .external_lex_state = 4},
  [619] = {.lex_state = 395, .external_lex_state = 4},
  [620] = {.lex_state = 395, .external_lex_state = 4},
  [621] = {.lex_state = 395, .external_lex_state = 4},
  [622] = {.lex_state = 395, .external_lex_state = 4},
  [623] = {.lex_state = 395, .external_lex_state = 4},
  [624] = {.lex_state = 395, .external_lex_state = 4},
  [625] = {.lex_state = 395, .external_lex_state = 4},
  [626] = {.lex_state = 395, .external_lex_state = 4},
  [627] = {.lex_state = 395, .external_lex_state = 4},
  [628] = {.lex_state = 395, .external_lex_state = 4},
  [629] = {.lex_state = 395, .external_lex_state = 4},
  [630] = {.lex_state = 395, .external_lex_state = 4},
  [631] = {.lex_state = 395, .external_lex_state = 4},
  [632] = {.lex_state = 395, .external_lex_state = 4},
  [633] = {.lex_state = 395, .external_lex_state = 4},
  [634] = {.lex_state = 395, .external_lex_state = 4},
  [635] = {.lex_state = 395, .external_lex_state = 4},
  [636] = {.lex_state = 395, .external_lex_state = 4},
  [637] = {.lex_state = 395, .external_lex_state = 4},
  [638] = {.lex_state = 395, .external_lex_state = 4},
  [639] = {.lex_state = 395, .external_lex_state = 4},
  [640] = {.lex_state = 395, .external_lex_state = 4},
  [641] = {.lex_state = 395, .external_lex_state = 4},
  [642] = {.lex_state = 395, .external_lex_state = 4},
  [643] = {.lex_state = 395, .external_lex_state = 4},
  [644] = {.lex_state = 395, .external_lex_state = 4},
  [645] = {.lex_state = 395, .external_lex_state = 4},
  [646] = {.lex_state = 395, .external_lex_state = 4},
  [647] = {.lex_state = 395, .external_lex_state = 4},
  [648] = {.lex_state = 395, .external_lex_state = 4},
  [649] = {.lex_state = 395, .external_lex_state = 4},
  [650] = {.lex_state = 395, .external_lex_state = 4},
  [651] = {.lex_state = 395, .external_lex_state = 4},
  [652] = {.lex_state = 395, .external_lex_state = 4},
  [653] = {.lex_state = 395, .external_lex_state = 4},
  [654] = {.lex_state = 395, .external_lex_state = 4},
  [655] = {.lex_state = 395, .external_lex_state = 4},
  [656] = {.lex_state = 395, .external_lex_state = 4},
  [657] = {.lex_state = 395, .external_lex_state = 4},
  [658] = {.lex_state = 395, .external_lex_state = 4},
  [659] = {.lex_state = 395, .external_lex_state = 4},
  [660] = {.lex_state = 395, .external_lex_state = 4},
  [661] = {.lex_state = 395, .external_lex_state = 4},
  [662] = {.lex_state = 395, .external_lex_state = 4},
  [663] = {.lex_state = 395, .external_lex_state = 4},
  [664] = {.lex_state = 395, .external_lex_state = 4},
  [665] = {.lex_state = 395, .external_lex_state = 4},
  [666] = {.lex_state = 395, .external_lex_state = 4},
  [667] = {.lex_state = 395, .external_lex_state = 4},
  [668] = {.lex_state = 395, .external_lex_state = 4},
  [669] = {.lex_state = 395, .external_lex_state = 4},
  [670] = {.lex_state = 395, .external_lex_state = 4},
  [671] = {.lex_state = 395, .external_lex_state = 4},
  [672] = {.lex_state = 395, .external_lex_state = 4},
  [673] = {.lex_state = 395, .external_lex_state = 4},
  [674] = {.lex_state = 395, .external_lex_state = 4},
  [675] = {.lex_state = 395, .external_lex_state = 4},
  [676] = {.lex_state = 395, .external_lex_state = 4},
  [677] = {.lex_state = 395, .external_lex_state = 4},
  [678] = {.lex_state = 395, .external_lex_state = 4},
  [679] = {.lex_state = 395, .external_lex_state = 4},
  [680] = {.lex_state = 395, .external_lex_state = 4},
  [681] = {.lex_state = 395, .external_lex_state = 4},
  [682] = {.lex_state = 395, .external_lex_state = 4},
  [683] = {.lex_state = 395, .external_lex_state = 4},
  [684] = {.lex_state = 395, .external_lex_state = 4},
  [685] = {.lex_state = 395, .external_lex_state = 4},
  [686] = {.lex_state = 395, .external_lex_state = 4},
  [687] = {.lex_state = 395, .external_lex_state = 4},
  [688] = {.lex_state = 395, .external_lex_state = 4},
  [689] = {.lex_state = 395, .external_lex_state = 4},
  [690] = {.lex_state = 395, .external_lex_state = 4},
  [691] = {.lex_state = 395, .external_lex_state = 4},
  [692] = {.lex_state = 395, .external_lex_state = 4},
  [693] = {.lex_state = 395, .external_lex_state = 4},
  [694] = {.lex_state = 395, .external_lex_state = 4},
  [695] = {.lex_state = 395, .external_lex_state = 4},
  [696] = {.lex_state = 395, .external_lex_state = 4},
  [697] = {.lex_state = 395, .external_lex_state = 4},
  [698] = {.lex_state = 395, .external_lex_state = 4},
  [699] = {.lex_state = 395, .external_lex_state = 4},
  [700] = {.lex_state = 395, .external_lex_state = 4},
  [701] = {.lex_state = 395, .external_lex_state = 4},
  [702] = {.lex_state = 395, .external_lex_state = 4},
  [703] = {.lex_state = 395, .external_lex_state = 4},
  [704] = {.lex_state = 395, .external_lex_state = 4},
  [705] = {.lex_state = 395, .external_lex_state = 4},
  [706] = {.lex_state = 395, .external_lex_state = 4},
  [707] = {.lex_state = 395, .external_lex_state = 4},
  [708] = {.lex_state = 395, .external_lex_state = 4},
  [709] = {.lex_state = 395, .external_lex_state = 4},
  [710] = {.lex_state = 395, .external_lex_state = 4},
  [711] = {.lex_state = 395, .external_lex_state = 4},
  [712] = {.lex_state = 395, .external_lex_state = 4},
  [713] = {.lex_state = 395, .external_lex_state = 4},
  [714] = {.lex_state = 395, .external_lex_state = 4},
  [715] = {.lex_state = 395, .external_lex_state = 4},
  [716] = {.lex_state = 395, .external_lex_state = 4},
  [717] = {.lex_state = 395, .external_lex_state = 4},
  [718] = {.lex_state = 395, .external_lex_state = 4},
  [719] = {.lex_state = 395, .external_lex_state = 4},
  [720] = {.lex_state = 395, .external_lex_state = 4},
  [721] = {.lex_state = 395, .external_lex_state = 4},
  [722] = {.lex_state = 395, .external_lex_state = 4},
  [723] = {.lex_state = 395, .external_lex_state = 4},
  [724] = {.lex_state = 395, .external_lex_state = 4},
  [725] = {.lex_state = 395, .external_lex_state = 4},
  [726] = {.lex_state = 395, .external_lex_state = 4},
  [727] = {.lex_state = 395, .external_lex_state = 4},
  [728] = {.lex_state = 395, .external_lex_state = 4},
  [729] = {.lex_state = 395, .external_lex_state = 4},
  [730] = {.lex_state = 395, .external_lex_state = 4},
  [731] = {.lex_state = 395, .external_lex_state = 4},
  [732] = {.lex_state = 395, .external_lex_state = 4},
  [733] = {.lex_state = 395, .external_lex_state = 4},
  [734] = {.lex_state = 395, .external_lex_state = 4},
  [735] = {.lex_state = 395, .external_lex_state = 4},
  [736] = {.lex_state = 395, .external_lex_state = 4},
  [737] = {.lex_state = 395, .external_lex_state = 4},
  [738] = {.lex_state = 395, .external_lex_state = 4},
  [739] = {.lex_state = 395, .external_lex_state = 4},
  [740] = {.lex_state = 395, .external_lex_state = 4},
  [741] = {.lex_state = 395, .external_lex_state = 4},
  [742] = {.lex_state = 395, .external_lex_state = 4},
  [743] = {.lex_state = 395, .external_lex_state = 4},
  [744] = {.lex_state = 395, .external_lex_state = 4},
  [745] = {.lex_state = 395, .external_lex_state = 4},
  [746] = {.lex_state = 395, .external_lex_state = 4},
  [747] = {.lex_state = 395, .external_lex_state = 4},
  [748] = {.lex_state = 395, .external_lex_state = 4},
  [749] = {.lex_state = 395, .external_lex_state = 4},
  [750] = {.lex_state = 395, .external_lex_state = 4},
  [751] = {.lex_state = 395, .external_lex_state = 4},
  [752] = {.lex_state = 395, .external_lex_state = 4},
  [753] = {.lex_state = 395, .external_lex_state = 4},
  [754] = {.lex_state = 395, .external_lex_state = 4},
  [755] = {.lex_state = 395, .external_lex_state = 4},
  [756] = {.lex_state = 395, .external_lex_state = 4},
  [757] = {.lex_state = 395, .external_lex_state = 4},
  [758] = {.lex_state = 395, .external_lex_state = 4},
  [759] = {.lex_state = 395, .external_lex_state = 4},
  [760] = {.lex_state = 395, .external_lex_state = 4},
  [761] = {.lex_state = 395, .external_lex_state = 4},
  [762] = {.lex_state = 395, .external_lex_state = 4},
  [763] = {.lex_state = 395, .external_lex_state = 4},
  [764] = {.lex_state = 395, .external_lex_state = 4},
  [765] = {.lex_state = 395, .external_lex_state = 4},
  [766] = {.lex_state = 395, .external_lex_state = 4},
  [767] = {.lex_state = 395, .external_lex_state = 4},
  [768] = {.lex_state = 395, .external_lex_state = 4},
  [769] = {.lex_state = 395, .external_lex_state = 4},
  [770] = {.lex_state = 395, .external_lex_state = 4},
  [771] = {.lex_state = 395, .external_lex_state = 4},
  [772] = {.lex_state = 395, .external_lex_state = 4},
  [773] = {.lex_state = 395, .external_lex_state = 4},
  [774] = {.lex_state = 395, .external_lex_state = 4},
  [775] = {.lex_state = 395, .external_lex_state = 4},
  [776] = {.lex_state = 395, .external_lex_state = 4},
  [777] = {.lex_state = 395, .external_lex_state = 4},
  [778] = {.lex_state = 395, .external_lex_state = 4},
  [779] = {.lex_state = 395, .external_lex_state = 4},
  [780] = {.lex_state = 395, .external_lex_state = 4},
  [781] = {.lex_state = 395, .external_lex_state = 4},
  [782] = {.lex_state = 395, .external_lex_state = 4},
  [783] = {.lex_state = 395, .external_lex_state = 4},
  [784] = {.lex_state = 395, .external_lex_state = 4},
  [785] = {.lex_state = 395, .external_lex_state = 4},
  [786] = {.lex_state = 395, .external_lex_state = 4},
  [787] = {.lex_state = 395, .external_lex_state = 4},
  [788] = {.lex_state = 395, .external_lex_state = 4},
  [789] = {.lex_state = 395, .external_lex_state = 4},
  [790] = {.lex_state = 395, .external_lex_state = 4},
  [791] = {.lex_state = 395, .external_lex_state = 4},
  [792] = {.lex_state = 395, .external_lex_state = 4},
  [793] = {.lex_state = 395, .external_lex_state = 4},
  [794] = {.lex_state = 395, .external_lex_state = 4},
  [795] = {.lex_state = 395, .external_lex_state = 4},
  [796] = {.lex_state = 395, .external_lex_state = 4},
  [797] = {.lex_state = 395, .external_lex_state = 4},
  [798] = {.lex_state = 395, .external_lex_state = 4},
  [799] = {.lex_state = 395, .external_lex_state = 4},
  [800] = {.lex_state = 395, .external_lex_state = 4},
  [801] = {.lex_state = 395, .external_lex_state = 4},
  [802] = {.lex_state = 395, .external_lex_state = 4},
  [803] = {.lex_state = 395, .external_lex_state = 4},
  [804] = {.lex_state = 395, .external_lex_state = 4},
  [805] = {.lex_state = 395, .external_lex_state = 4},
  [806] = {.lex_state = 395, .external_lex_state = 4},
  [807] = {.lex_state = 395, .external_lex_state = 4},
  [808] = {.lex_state = 395, .external_lex_state = 4},
  [809] = {.lex_state = 395, .external_lex_state = 4},
  [810] = {.lex_state = 395, .external_lex_state = 4},
  [811] = {.lex_state = 395, .external_lex_state = 4},
  [812] = {.lex_state = 395, .external_lex_state = 4},
  [813] = {.lex_state = 395, .external_lex_state = 4},
  [814] = {.lex_state = 395, .external_lex_state = 4},
  [815] = {.lex_state = 395, .external_lex_state = 4},
  [816] = {.lex_state = 395, .external_lex_state = 4},
  [817] = {.lex_state = 395, .external_lex_state = 4},
  [818] = {.lex_state = 395, .external_lex_state = 4},
  [819] = {.lex_state = 395, .external_lex_state = 4},
  [820] = {.lex_state = 395, .external_lex_state = 4},
  [821] = {.lex_state = 395, .external_lex_state = 4},
  [822] = {.lex_state = 395, .external_lex_state = 4},
  [823] = {.lex_state = 395, .external_lex_state = 4},
  [824] = {.lex_state = 395, .external_lex_state = 4},
  [825] = {.lex_state = 395, .external_lex_state = 4},
  [826] = {.lex_state = 395, .external_lex_state = 4},
  [827] = {.lex_state = 395, .external_lex_state = 4},
  [828] = {.lex_state = 395, .external_lex_state = 4},
  [829] = {.lex_state = 395, .external_lex_state = 4},
  [830] = {.lex_state = 395, .external_lex_state = 4},
  [831] = {.lex_state = 395, .external_lex_state = 4},
  [832] = {.lex_state = 395, .external_lex_state = 4},
  [833] = {.lex_state = 395, .external_lex_state = 4},
  [834] = {.lex_state = 395, .external_lex_state = 4},
  [835] = {.lex_state = 395, .external_lex_state = 4},
  [836] = {.lex_state = 395, .external_lex_state = 4},
  [837] = {.lex_state = 395, .external_lex_state = 4},
  [838] = {.lex_state = 395, .external_lex_state = 4},
  [839] = {.lex_state = 395, .external_lex_state = 4},
  [840] = {.lex_state = 395, .external_lex_state = 4},
  [841] = {.lex_state = 395, .external_lex_state = 4},
  [842] = {.lex_state = 395, .external_lex_state = 4},
  [843] = {.lex_state = 395, .external_lex_state = 4},
  [844] = {.lex_state = 395, .external_lex_state = 4},
  [845] = {.lex_state = 395, .external_lex_state = 4},
  [846] = {.lex_state = 395, .external_lex_state = 4},
  [847] = {.lex_state = 395, .external_lex_state = 4},
  [848] = {.lex_state = 395, .external_lex_state = 4},
  [849] = {.lex_state = 395, .external_lex_state = 4},
  [850] = {.lex_state = 395, .external_lex_state = 4},
  [851] = {.lex_state = 395, .external_lex_state = 4},
  [852] = {.lex_state = 395, .external_lex_state = 4},
  [853] = {.lex_state = 395, .external_lex_state = 4},
  [854] = {.lex_state = 395, .external_lex_state = 4},
  [855] = {.lex_state = 395, .external_lex_state = 4},
  [856] = {.lex_state = 395, .external_lex_state = 4},
  [857] = {.lex_state = 395, .external_lex_state = 4},
  [858] = {.lex_state = 395, .external_lex_state = 4},
  [859] = {.lex_state = 395, .external_lex_state = 4},
  [860] = {.lex_state = 395, .external_lex_state = 4},
  [861] = {.lex_state = 395, .external_lex_state = 4},
  [862] = {.lex_state = 395, .external_lex_state = 4},
  [863] = {.lex_state = 395, .external_lex_state = 4},
  [864] = {.lex_state = 395, .external_lex_state = 4},
  [865] = {.lex_state = 395, .external_lex_state = 4},
  [866] = {.lex_state = 395, .external_lex_state = 4},
  [867] = {.lex_state = 395, .external_lex_state = 4},
  [868] = {.lex_state = 395, .external_lex_state = 4},
  [869] = {.lex_state = 395, .external_lex_state = 4},
  [870] = {.lex_state = 395, .external_lex_state = 4},
  [871] = {.lex_state = 395, .external_lex_state = 4},
  [872] = {.lex_state = 395, .external_lex_state = 4},
  [873] = {.lex_state = 395, .external_lex_state = 4},
  [874] = {.lex_state = 395, .external_lex_state = 4},
  [875] = {.lex_state = 395, .external_lex_state = 4},
  [876] = {.lex_state = 395, .external_lex_state = 4},
  [877] = {.lex_state = 395, .external_lex_state = 4},
  [878] = {.lex_state = 395, .external_lex_state = 4},
  [879] = {.lex_state = 395, .external_lex_state = 4},
  [880] = {.lex_state = 395, .external_lex_state = 4},
  [881] = {.lex_state = 395, .external_lex_state = 4},
  [882] = {.lex_state = 395, .external_lex_state = 4},
  [883] = {.lex_state = 395, .external_lex_state = 4},
  [884] = {.lex_state = 395, .external_lex_state = 4},
  [885] = {.lex_state = 395, .external_lex_state = 4},
  [886] = {.lex_state = 395, .external_lex_state = 4},
  [887] = {.lex_state = 395, .external_lex_state = 4},
  [888] = {.lex_state = 395, .external_lex_state = 4},
  [889] = {.lex_state = 395, .external_lex_state = 4},
  [890] = {.lex_state = 395, .external_lex_state = 4},
  [891] = {.lex_state = 395, .external_lex_state = 4},
  [892] = {.lex_state = 395, .external_lex_state = 4},
  [893] = {.lex_state = 395, .external_lex_state = 4},
  [894] = {.lex_state = 395, .external_lex_state = 4},
  [895] = {.lex_state = 395, .external_lex_state = 4},
  [896] = {.lex_state = 395, .external_lex_state = 4},
  [897] = {.lex_state = 395, .external_lex_state = 4},
  [898] = {.lex_state = 395, .external_lex_state = 4},
  [899] = {.lex_state = 395, .external_lex_state = 4},
  [900] = {.lex_state = 395, .external_lex_state = 4},
  [901] = {.lex_state = 395, .external_lex_state = 4},
  [902] = {.lex_state = 395, .external_lex_state = 4},
  [903] = {.lex_state = 395, .external_lex_state = 4},
  [904] = {.lex_state = 395, .external_lex_state = 4},
  [905] = {.lex_state = 395, .external_lex_state = 4},
  [906] = {.lex_state = 395, .external_lex_state = 4},
  [907] = {.lex_state = 395, .external_lex_state = 4},
  [908] = {.lex_state = 395, .external_lex_state = 4},
  [909] = {.lex_state = 395, .external_lex_state = 4},
  [910] = {.lex_state = 395, .external_lex_state = 4},
  [911] = {.lex_state = 395, .external_lex_state = 4},
  [912] = {.lex_state = 395, .external_lex_state = 4},
  [913] = {.lex_state = 395, .external_lex_state = 4},
  [914] = {.lex_state = 395, .external_lex_state = 4},
  [915] = {.lex_state = 395, .external_lex_state = 4},
  [916] = {.lex_state = 395, .external_lex_state = 4},
  [917] = {.lex_state = 395, .external_lex_state = 4},
  [918] = {.lex_state = 395, .external_lex_state = 4},
  [919] = {.lex_state = 395, .external_lex_state = 4},
  [920] = {.lex_state = 395, .external_lex_state = 4},
  [921] = {.lex_state = 395, .external_lex_state = 4},
  [922] = {.lex_state = 395, .external_lex_state = 4},
  [923] = {.lex_state = 395, .external_lex_state = 4},
  [924] = {.lex_state = 395, .external_lex_state = 4},
  [925] = {.lex_state = 395, .external_lex_state = 4},
  [926] = {.lex_state = 395, .external_lex_state = 4},
  [927] = {.lex_state = 395, .external_lex_state = 4},
  [928] = {.lex_state = 395, .external_lex_state = 4},
  [929] = {.lex_state = 395, .external_lex_state = 4},
  [930] = {.lex_state = 395, .external_lex_state = 4},
  [931] = {.lex_state = 395, .external_lex_state = 4},
  [932] = {.lex_state = 395, .external_lex_state = 4},
  [933] = {.lex_state = 395, .external_lex_state = 4},
  [934] = {.lex_state = 395, .external_lex_state = 4},
  [935] = {.lex_state = 395, .external_lex_state = 4},
  [936] = {.lex_state = 395, .external_lex_state = 4},
  [937] = {.lex_state = 395, .external_lex_state = 4},
  [938] = {.lex_state = 395, .external_lex_state = 4},
  [939] = {.lex_state = 395, .external_lex_state = 4},
  [940] = {.lex_state = 395, .external_lex_state = 4},
  [941] = {.lex_state = 395, .external_lex_state = 4},
  [942] = {.lex_state = 395, .external_lex_state = 4},
  [943] = {.lex_state = 395, .external_lex_state = 4},
  [944] = {.lex_state = 395, .external_lex_state = 4},
  [945] = {.lex_state = 395, .external_lex_state = 4},
  [946] = {.lex_state = 395, .external_lex_state = 4},
  [947] = {.lex_state = 395, .external_lex_state = 4},
  [948] = {.lex_state = 395, .external_lex_state = 4},
  [949] = {.lex_state = 395, .external_lex_state = 4},
  [950] = {.lex_state = 395, .external_lex_state = 4},
  [951] = {.lex_state = 395, .external_lex_state = 4},
  [952] = {.lex_state = 395, .external_lex_state = 4},
  [953] = {.lex_state = 395, .external_lex_state = 4},
  [954] = {.lex_state = 395, .external_lex_state = 4},
  [955] = {.lex_state = 395, .external_lex_state = 4},
  [956] = {.lex_state = 395, .external_lex_state = 4},
  [957] = {.lex_state = 395, .external_lex_state = 4},
  [958] = {.lex_state = 395, .external_lex_state = 4},
  [959] = {.lex_state = 395, .external_lex_state = 4},
  [960] = {.lex_state = 395, .external_lex_state = 4},
  [961] = {.lex_state = 395, .external_lex_state = 4},
  [962] = {.lex_state = 395, .external_lex_state = 4},
  [963] = {.lex_state = 395, .external_lex_state = 4},
  [964] = {.lex_state = 395, .external_lex_state = 4},
  [965] = {.lex_state = 395, .external_lex_state = 4},
  [966] = {.lex_state = 395, .external_lex_state = 4},
  [967] = {.lex_state = 395, .external_lex_state = 4},
  [968] = {.lex_state = 395, .external_lex_state = 4},
  [969] = {.lex_state = 395, .external_lex_state = 4},
  [970] = {.lex_state = 395, .external_lex_state = 4},
  [971] = {.lex_state = 395, .external_lex_state = 4},
  [972] = {.lex_state = 395, .external_lex_state = 4},
  [973] = {.lex_state = 395, .external_lex_state = 4},
  [974] = {.lex_state = 395, .external_lex_state = 4},
  [975] = {.lex_state = 395, .external_lex_state = 4},
  [976] = {.lex_state = 395, .external_lex_state = 4},
  [977] = {.lex_state = 395, .external_lex_state = 4},
  [978] = {.lex_state = 395, .external_lex_state = 4},
  [979] = {.lex_state = 395, .external_lex_state = 4},
  [980] = {.lex_state = 395, .external_lex_state = 4},
  [981] = {.lex_state = 395, .external_lex_state = 4},
  [982] = {.lex_state = 395, .external_lex_state = 4},
  [983] = {.lex_state = 395, .external_lex_state = 4},
  [984] = {.lex_state = 395, .external_lex_state = 4},
  [985] = {.lex_state = 395, .external_lex_state = 4},
  [986] = {.lex_state = 395, .external_lex_state = 4},
  [987] = {.lex_state = 395, .external_lex_state = 4},
  [988] = {.lex_state = 395, .external_lex_state = 4},
  [989] = {.lex_state = 395, .external_lex_state = 4},
  [990] = {.lex_state = 395, .external_lex_state = 4},
  [991] = {.lex_state = 395, .external_lex_state = 4},
  [992] = {.lex_state = 395, .external_lex_state = 4},
  [993] = {.lex_state = 395, .external_lex_state = 4},
  [994] = {.lex_state = 395, .external_lex_state = 4},
  [995] = {.lex_state = 395, .external_lex_state = 4},
  [996] = {.lex_state = 395, .external_lex_state = 4},
  [997] = {.lex_state = 395, .external_lex_state = 4},
  [998] = {.lex_state = 395, .external_lex_state = 4},
  [999] = {.lex_state = 395, .external_lex_state = 4},
  [1000] = {.lex_state = 395, .external_lex_state = 4},
  [1001] = {.lex_state = 395, .external_lex_state = 4},
  [1002] = {.lex_state = 395, .external_lex_state = 4},
  [1003] = {.lex_state = 395, .external_lex_state = 4},
  [1004] = {.lex_state = 395, .external_lex_state = 4},
  [1005] = {.lex_state = 395, .external_lex_state = 4},
  [1006] = {.lex_state = 395, .external_lex_state = 4},
  [1007] = {.lex_state = 395, .external_lex_state = 4},
  [1008] = {.lex_state = 395, .external_lex_state = 4},
  [1009] = {.lex_state = 395, .external_lex_state = 4},
  [1010] = {.lex_state = 395, .external_lex_state = 4},
  [1011] = {.lex_state = 395, .external_lex_state = 4},
  [1012] = {.lex_state = 395, .external_lex_state = 4},
  [1013] = {.lex_state = 395, .external_lex_state = 4},
  [1014] = {.lex_state = 395, .external_lex_state = 4},
  [1015] = {.lex_state = 395, .external_lex_state = 4},
  [1016] = {.lex_state = 395, .external_lex_state = 4},
  [1017] = {.lex_state = 395, .external_lex_state = 4},
  [1018] = {.lex_state = 395, .external_lex_state = 4},
  [1019] = {.lex_state = 395, .external_lex_state = 4},
  [1020] = {.lex_state = 395, .external_lex_state = 4},
  [1021] = {.lex_state = 395, .external_lex_state = 4},
  [1022] = {.lex_state = 395, .external_lex_state = 4},
  [1023] = {.lex_state = 395, .external_lex_state = 4},
  [1024] = {.lex_state = 400, .external_lex_state = 6},
  [1025] = {.lex_state = 400, .external_lex_state = 6},
  [1026] = {.lex_state = 400, .external_lex_state = 6},
  [1027] = {.lex_state = 400, .external_lex_state = 6},
  [1028] = {.lex_state = 400, .external_lex_state = 6},
  [1029] = {.lex_state = 400, .external_lex_state = 6},
  [1030] = {.lex_state = 400, .external_lex_state = 6},
  [1031] = {.lex_state = 400, .external_lex_state = 6},
  [1032] = {.lex_state = 400, .external_lex_state = 6},
  [1033] = {.lex_state = 400, .external_lex_state = 6},
  [1034] = {.lex_state = 400, .external_lex_state = 6},
  [1035] = {.lex_state = 400, .external_lex_state = 6},
  [1036] = {.lex_state = 400, .external_lex_state = 6},
  [1037] = {.lex_state = 400, .external_lex_state = 6},
  [1038] = {.lex_state = 400, .external_lex_state = 6},
  [1039] = {.lex_state = 400, .external_lex_state = 6},
  [1040] = {.lex_state = 400, .external_lex_state = 6},
  [1041] = {.lex_state = 400, .external_lex_state = 6},
  [1042] = {.lex_state = 400, .external_lex_state = 6},
  [1043] = {.lex_state = 400, .external_lex_state = 6},
  [1044] = {.lex_state = 400, .external_lex_state = 6},
  [1045] = {.lex_state = 400, .external_lex_state = 6},
  [1046] = {.lex_state = 400, .external_lex_state = 6},
  [1047] = {.lex_state = 400, .external_lex_state = 6},
  [1048] = {.lex_state = 400, .external_lex_state = 6},
  [1049] = {.lex_state = 400, .external_lex_state = 6},
  [1050] = {.lex_state = 400, .external_lex_state = 6},
  [1051] = {.lex_state = 400, .external_lex_state = 6},
  [1052] = {.lex_state = 400, .external_lex_state = 6},
  [1053] = {.lex_state = 400, .external_lex_state = 6},
  [1054] = {.lex_state = 400, .external_lex_state = 6},
  [1055] = {.lex_state = 400, .external_lex_state = 6},
  [1056] = {.lex_state = 400, .external_lex_state = 6},
  [1057] = {.lex_state = 400, .external_lex_state = 6},
  [1058] = {.lex_state = 440},
  [1059] = {.lex_state = 440},
  [1060] = {.lex_state = 440},
  [1061] = {.lex_state = 440},
  [1062] = {.lex_state = 440},
  [1063] = {.lex_state = 440},
  [1064] = {.lex_state = 440},
  [1065] = {.lex_state = 440},
  [1066] = {.lex_state = 440},
  [1067] = {.lex_state = 440},
  [1068] = {.lex_state = 440},
  [1069] = {.lex_state = 440},
  [1070] = {.lex_state = 440},
  [1071] = {.lex_state = 440},
  [1072] = {.lex_state = 440},
  [1073] = {.lex_state = 440},
  [1074] = {.lex_state = 440},
  [1075] = {.lex_state = 440},
  [1076] = {.lex_state = 440},
  [1077] = {.lex_state = 440},
  [1078] = {.lex_state = 440},
  [1079] = {.lex_state = 440},
  [1080] = {.lex_state = 440},
  [1081] = {.lex_state = 440},
  [1082] = {.lex_state = 440},
  [1083] = {.lex_state = 440},
  [1084] = {.lex_state = 440},
  [1085] = {.lex_state = 440},
  [1086] = {.lex_state = 440},
  [1087] = {.lex_state = 440},
  [1088] = {.lex_state = 440},
  [1089] = {.lex_state = 440},
  [1090] = {.lex_state = 400},
  [1091] = {.lex_state = 400},
  [1092] = {.lex_state = 400},
  [1093] = {.lex_state = 400},
  [1094] = {.lex_state = 400},
  [1095] = {.lex_state = 400},
  [1096] = {.lex_state = 400},
  [1097] = {.lex_state = 400},
  [1098] = {.lex_state = 400},
  [1099] = {.lex_state = 400},
  [1100] = {.lex_state = 400},
  [1101] = {.lex_state = 400},
  [1102] = {.lex_state = 400},
  [1103] = {.lex_state = 400},
  [1104] = {.lex_state = 400},
  [1105] = {.lex_state = 400},
  [1106] = {.lex_state = 400},
  [1107] = {.lex_state = 400},
  [1108] = {.lex_state = 400},
  [1109] = {.lex_state = 400},
  [1110] = {.lex_state = 400},
  [1111] = {.lex_state = 400},
  [1112] = {.lex_state = 400},
  [1113] = {.lex_state = 400},
  [1114] = {.lex_state = 400},
  [1115] = {.lex_state = 400},
  [1116] = {.lex_state = 400},
  [1117] = {.lex_state = 400},
  [1118] = {.lex_state = 400},
  [1119] = {.lex_state = 400},
  [1120] = {.lex_state = 400},
  [1121] = {.lex_state = 400},
  [1122] = {.lex_state = 400},
  [1123] = {.lex_state = 400},
  [1124] = {.lex_state = 400},
  [1125] = {.lex_state = 400},
  [1126] = {.lex_state = 400},
  [1127] = {.lex_state = 400},
  [1128] = {.lex_state = 400},
  [1129] = {.lex_state = 400},
  [1130] = {.lex_state = 400},
  [1131] = {.lex_state = 400},
  [1132] = {.lex_state = 400},
  [1133] = {.lex_state = 401},
  [1134] = {.lex_state = 401},
  [1135] = {.lex_state = 401},
  [1136] = {.lex_state = 401},
  [1137] = {.lex_state = 401},
  [1138] = {.lex_state = 401},
  [1139] = {.lex_state = 401},
  [1140] = {.lex_state = 401},
  [1141] = {.lex_state = 401},
  [1142] = {.lex_state = 401},
  [1143] = {.lex_state = 401},
  [1144] = {.lex_state = 401},
  [1145] = {.lex_state = 401},
  [1146] = {.lex_state = 401},
  [1147] = {.lex_state = 401},
  [1148] = {.lex_state = 401},
  [1149] = {.lex_state = 401},
  [1150] = {.lex_state = 401},
  [1151] = {.lex_state = 401},
  [1152] = {.lex_state = 401},
  [1153] = {.lex_state = 401},
  [1154] = {.lex_state = 401},
  [1155] = {.lex_state = 401},
  [1156] = {.lex_state = 401},
  [1157] = {.lex_state = 401},
  [1158] = {.lex_state = 401},
  [1159] = {.lex_state = 401},
  [1160] = {.lex_state = 401},
  [1161] = {.lex_state = 401},
  [1162] = {.lex_state = 401},
  [1163] = {.lex_state = 401},
  [1164] = {.lex_state = 401},
  [1165] = {.lex_state = 401},
  [1166] = {.lex_state = 401},
  [1167] = {.lex_state = 401},
  [1168] = {.lex_state = 401},
  [1169] = {.lex_state = 401},
  [1170] = {.lex_state = 401},
  [1171] = {.lex_state = 401},
  [1172] = {.lex_state = 401},
  [1173] = {.lex_state = 401},
  [1174] = {.lex_state = 401},
  [1175] = {.lex_state = 401},
  [1176] = {.lex_state = 401},
  [1177] = {.lex_state = 401},
  [1178] = {.lex_state = 401},
  [1179] = {.lex_state = 401},
  [1180] = {.lex_state = 402},
  [1181] = {.lex_state = 402},
  [1182] = {.lex_state = 402},
  [1183] = {.lex_state = 402},
  [1184] = {.lex_state = 402},
  [1185] = {.lex_state = 402},
  [1186] = {.lex_state = 402},
  [1187] = {.lex_state = 402},
  [1188] = {.lex_state = 402},
  [1189] = {.lex_state = 402},
  [1190] = {.lex_state = 402},
  [1191] = {.lex_state = 402},
  [1192] = {.lex_state = 402},
  [1193] = {.lex_state = 402},
  [1194] = {.lex_state = 402},
  [1195] = {.lex_state = 402},
  [1196] = {.lex_state = 402},
  [1197] = {.lex_state = 402},
  [1198] = {.lex_state = 402},
  [1199] = {.lex_state = 402},
  [1200] = {.lex_state = 402},
  [1201] = {.lex_state = 403},
  [1202] = {.lex_state = 403},
  [1203] = {.lex_state = 403},
  [1204] = {.lex_state = 403},
  [1205] = {.lex_state = 403},
  [1206] = {.lex_state = 403},
  [1207] = {.lex_state = 403},
  [1208] = {.lex_state = 403},
  [1209] = {.lex_state = 403},
  [1210] = {.lex_state = 403},
  [1211] = {.lex_state = 403},
  [1212] = {.lex_state = 403},
  [1213] = {.lex_state = 403},
  [1214] = {.lex_state = 403},
  [1215] = {.lex_state = 403},
  [1216] = {.lex_state = 403},
  [1217] = {.lex_state = 403},
  [1218] = {.lex_state = 403},
  [1219] = {.lex_state = 403},
  [1220] = {.lex_state = 403},
  [1221] = {.lex_state = 403},
  [1222] = {.lex_state = 403},
  [1223] = {.lex_state = 403},
  [1224] = {.lex_state = 403},
  [1225] = {.lex_state = 403},
  [1226] = {.lex_state = 403},
  [1227] = {.lex_state = 403},
  [1228] = {.lex_state = 403},
  [1229] = {.lex_state = 403},
  [1230] = {.lex_state = 403},
  [1231] = {.lex_state = 403},
  [1232] = {.lex_state = 403},
  [1233] = {.lex_state = 403},
  [1234] = {.lex_state = 404, .external_lex_state = 7},
  [1235] = {.lex_state = 404, .external_lex_state = 7},
  [1236] = {.lex_state = 404, .external_lex_state = 7},
  [1237] = {.lex_state = 403},
  [1238] = {.lex_state = 404, .external_lex_state = 7},
  [1239] = {.lex_state = 404, .external_lex_state = 7},
  [1240] = {.lex_state = 403},
  [1241] = {.lex_state = 403},
  [1242] = {.lex_state = 404, .external_lex_state = 7},
  [1243] = {.lex_state = 404, .external_lex_state = 7},
  [1244] = {.lex_state = 403},
  [1245] = {.lex_state = 404, .external_lex_state = 7},
  [1246] = {.lex_state = 403},
  [1247] = {.lex_state = 403},
  [1248] = {.lex_state = 403},
  [1249] = {.lex_state = 403},
  [1250] = {.lex_state = 404, .external_lex_state = 7},
  [1251] = {.lex_state = 404, .external_lex_state = 7},
  [1252] = {.lex_state = 404, .external_lex_state = 7},
  [1253] = {.lex_state = 404, .external_lex_state = 7},
  [1254] = {.lex_state = 404, .external_lex_state = 7},
  [1255] = {.lex_state = 404, .external_lex_state = 7},
  [1256] = {.lex_state = 404, .external_lex_state = 7},
  [1257] = {.lex_state = 404, .external_lex_state = 7},
  [1258] = {.lex_state = 404, .external_lex_state = 7},
  [1259] = {.lex_state = 404, .external_lex_state = 7},
  [1260] = {.lex_state = 404, .external_lex_state = 7},
  [1261] = {.lex_state = 404, .external_lex_state = 7},
  [1262] = {.lex_state = 404, .external_lex_state = 7},
  [1263] = {.lex_state = 404, .external_lex_state = 7},
  [1264] = {.lex_state = 404, .external_lex_state = 7},
  [1265] = {.lex_state = 404, .external_lex_state = 7},
  [1266] = {.lex_state = 404, .external_lex_state = 7},
  [1267] = {.lex_state = 404, .external_lex_state = 7},
  [1268] = {.lex_state = 404, .external_lex_state = 7},
  [1269] = {.lex_state = 404, .external_lex_state = 7},
  [1270] = {.lex_state = 404, .external_lex_state = 7},
  [1271] = {.lex_state = 404, .external_lex_state = 7},
  [1272] = {.lex_state = 404, .external_lex_state = 7},
  [1273] = {.lex_state = 404, .external_lex_state = 7},
  [1274] = {.lex_state = 404, .external_lex_state = 7},
  [1275] = {.lex_state = 404, .external_lex_state = 7},
  [1276] = {.lex_state = 404, .external_lex_state = 7},
  [1277] = {.lex_state = 404, .external_lex_state = 7},
  [1278] = {.lex_state = 404, .external_lex_state = 7},
  [1279] = {.lex_state = 404, .external_lex_state = 7},
  [1280] = {.lex_state = 404, .external_lex_state = 7},
  [1281] = {.lex_state = 404, .external_lex_state = 7},
  [1282] = {.lex_state = 404, .external_lex_state = 7},
  [1283] = {.lex_state = 405, .external_lex_state = 8},
  [1284] = {.lex_state = 405, .external_lex_state = 8},
  [1285] = {.lex_state = 405, .external_lex_state = 8},
  [1286] = {.lex_state = 406},
  [1287] = {.lex_state = 406},
  [1288] = {.lex_state = 405, .external_lex_state = 8},
  [1289] = {.lex_state = 406},
  [1290] = {.lex_state = 405, .external_lex_state = 8},
  [1291] = {.lex_state = 405, .external_lex_state = 8},
  [1292] = {.lex_state = 405, .external_lex_state = 8},
  [1293] = {.lex_state = 405, .external_lex_state = 8},
  [1294] = {.lex_state = 405, .external_lex_state = 8},
  [1295] = {.lex_state = 405, .external_lex_state = 8},
  [1296] = {.lex_state = 406},
  [1297] = {.lex_state = 405, .external_lex_state = 8},
  [1298] = {.lex_state = 406},
  [1299] = {.lex_state = 405, .external_lex_state = 8},
  [1300] = {.lex_state = 405, .external_lex_state = 8},
  [1301] = {.lex_state = 405, .external_lex_state = 8},
  [1302] = {.lex_state = 405, .external_lex_state = 8},
  [1303] = {.lex_state = 405, .external_lex_state = 8},
  [1304] = {.lex_state = 405, .external_lex_state = 8},
  [1305] = {.lex_state = 405, .external_lex_state = 8},
  [1306] = {.lex_state = 405, .external_lex_state = 8},
  [1307] = {.lex_state = 406},
  [1308] = {.lex_state = 405, .external_lex_state = 8},
  [1309] = {.lex_state = 405, .external_lex_state = 8},
  [1310] = {.lex_state = 405, .external_lex_state = 8},
  [1311] = {.lex_state = 405, .external_lex_state = 8},
  [1312] = {.lex_state = 405, .external_lex_state = 8},
  [1313] = {.lex_state = 406},
  [1314] = {.lex_state = 405, .external_lex_state = 8},
  [1315] = {.lex_state = 406},
  [1316] = {.lex_state = 406},
  [1317] = {.lex_state = 406},
  [1318] = {.lex_state = 405, .external_lex_state = 8},
  [1319] = {.lex_state = 406},
  [1320] = {.lex_state = 406},
  [1321] = {.lex_state = 406},
  [1322] = {.lex_state = 406},
  [1323] = {.lex_state = 406},
  [1324] = {.lex_state = 405, .external_lex_state = 8},
  [1325] = {.lex_state = 406},
  [1326] = {.lex_state = 406},
  [1327] = {.lex_state = 406},
  [1328] = {.lex_state = 406},
  [1329] = {.lex_state = 406},
  [1330] = {.lex_state = 405, .external_lex_state = 8},
  [1331] = {.lex_state = 406},
  [1332] = {.lex_state = 405, .external_lex_state = 8},
  [1333] = {.lex_state = 406},
  [1334] = {.lex_state = 406},
  [1335] = {.lex_state = 406},
  [1336] = {.lex_state = 406},
  [1337] = {.lex_state = 405, .external_lex_state = 8},
  [1338] = {.lex_state = 406},
  [1339] = {.lex_state = 405, .external_lex_state = 8},
  [1340] = {.lex_state = 406},
  [1341] = {.lex_state = 406},
  [1342] = {.lex_state = 406},
  [1343] = {.lex_state = 406},
  [1344] = {.lex_state = 406, .external_lex_state = 8},
  [1345] = {.lex_state = 407, .external_lex_state = 8},
  [1346] = {.lex_state = 406, .external_lex_state = 8},
  [1347] = {.lex_state = 406, .external_lex_state = 8},
  [1348] = {.lex_state = 408},
  [1349] = {.lex_state = 406, .external_lex_state = 8},
  [1350] = {.lex_state = 406, .external_lex_state = 8},
  [1351] = {.lex_state = 406, .external_lex_state = 8},
  [1352] = {.lex_state = 406, .external_lex_state = 8},
  [1353] = {.lex_state = 406, .external_lex_state = 8},
  [1354] = {.lex_state = 406, .external_lex_state = 8},
  [1355] = {.lex_state = 406, .external_lex_state = 8},
  [1356] = {.lex_state = 406, .external_lex_state = 8},
  [1357] = {.lex_state = 408},
  [1358] = {.lex_state = 406, .external_lex_state = 8},
  [1359] = {.lex_state = 406, .external_lex_state = 8},
  [1360] = {.lex_state = 406, .external_lex_state = 8},
  [1361] = {.lex_state = 408},
  [1362] = {.lex_state = 408},
  [1363] = {.lex_state = 408},
  [1364] = {.lex_state = 406, .external_lex_state = 8},
  [1365] = {.lex_state = 406, .external_lex_state = 8},
  [1366] = {.lex_state = 406, .external_lex_state = 8},
  [1367] = {.lex_state = 406, .external_lex_state = 8},
  [1368] = {.lex_state = 406, .external_lex_state = 8},
  [1369] = {.lex_state = 406, .external_lex_state = 8},
  [1370] = {.lex_state = 408},
  [1371] = {.lex_state = 408},
  [1372] = {.lex_state = 408},
  [1373] = {.lex_state = 406, .external_lex_state = 8},
  [1374] = {.lex_state = 406, .external_lex_state = 8},
  [1375] = {.lex_state = 406, .external_lex_state = 8},
  [1376] = {.lex_state = 406, .external_lex_state = 8},
  [1377] = {.lex_state = 408},
  [1378] = {.lex_state = 406, .external_lex_state = 8},
  [1379] = {.lex_state = 406, .external_lex_state = 8},
  [1380] = {.lex_state = 406, .external_lex_state = 8},
  [1381] = {.lex_state = 406, .external_lex_state = 8},
  [1382] = {.lex_state = 406, .external_lex_state = 8},
  [1383] = {.lex_state = 408},
  [1384] = {.lex_state = 406, .external_lex_state = 8},
  [1385] = {.lex_state = 406, .external_lex_state = 8},
  [1386] = {.lex_state = 408},
  [1387] = {.lex_state = 408},
  [1388] = {.lex_state = 406, .external_lex_state = 8},
  [1389] = {.lex_state = 408},
  [1390] = {.lex_state = 408},
  [1391] = {.lex_state = 408},
  [1392] = {.lex_state = 408},
  [1393] = {.lex_state = 406, .external_lex_state = 8},
  [1394] = {.lex_state = 408},
  [1395] = {.lex_state = 408},
  [1396] = {.lex_state = 408},
  [1397] = {.lex_state = 408},
  [1398] = {.lex_state = 408},
  [1399] = {.lex_state = 408},
  [1400] = {.lex_state = 408},
  [1401] = {.lex_state = 408},
  [1402] = {.lex_state = 408},
  [1403] = {.lex_state = 408},
  [1404] = {.lex_state = 408},
  [1405] = {.lex_state = 408},
  [1406] = {.lex_state = 408},
  [1407] = {.lex_state = 408},
  [1408] = {.lex_state = 408},
  [1409] = {.lex_state = 408},
  [1410] = {.lex_state = 408},
  [1411] = {.lex_state = 408},
  [1412] = {.lex_state = 408},
  [1413] = {.lex_state = 408},
  [1414] = {.lex_state = 408},
  [1415] = {.lex_state = 408},
  [1416] = {.lex_state = 408},
  [1417] = {.lex_state = 408},
  [1418] = {.lex_state = 408},
  [1419] = {.lex_state = 408},
  [1420] = {.lex_state = 408},
  [1421] = {.lex_state = 408},
  [1422] = {.lex_state = 408},
  [1423] = {.lex_state = 408},
  [1424] = {.lex_state = 405},
  [1425] = {.lex_state = 406, .external_lex_state = 7},
  [1426] = {.lex_state = 409},
  [1427] = {.lex_state = 405},
  [1428] = {.lex_state = 405},
  [1429] = {.lex_state = 405},
  [1430] = {.lex_state = 405},
  [1431] = {.lex_state = 405},
  [1432] = {.lex_state = 405},
  [1433] = {.lex_state = 405},
  [1434] = {.lex_state = 405},
  [1435] = {.lex_state = 405},
  [1436] = {.lex_state = 405},
  [1437] = {.lex_state = 405},
  [1438] = {.lex_state = 405},
  [1439] = {.lex_state = 405},
  [1440] = {.lex_state = 405},
  [1441] = {.lex_state = 405},
  [1442] = {.lex_state = 405},
  [1443] = {.lex_state = 405},
  [1444] = {.lex_state = 405},
  [1445] = {.lex_state = 405},
  [1446] = {.lex_state = 405},
  [1447] = {.lex_state = 405},
  [1448] = {.lex_state = 405},
  [1449] = {.lex_state = 405},
  [1450] = {.lex_state = 405},
  [1451] = {.lex_state = 405},
  [1452] = {.lex_state = 405},
  [1453] = {.lex_state = 405},
  [1454] = {.lex_state = 405},
  [1455] = {.lex_state = 409},
  [1456] = {.lex_state = 409},
  [1457] = {.lex_state = 405},
  [1458] = {.lex_state = 409},
  [1459] = {.lex_state = 409},
  [1460] = {.lex_state = 409},
  [1461] = {.lex_state = 409},
  [1462] = {.lex_state = 409},
  [1463] = {.lex_state = 409},
  [1464] = {.lex_state = 409},
  [1465] = {.lex_state = 409},
  [1466] = {.lex_state = 409},
  [1467] = {.lex_state = 409},
  [1468] = {.lex_state = 409},
  [1469] = {.lex_state = 409},
  [1470] = {.lex_state = 409},
  [1471] = {.lex_state = 406, .external_lex_state = 7},
  [1472] = {.lex_state = 406, .external_lex_state = 7},
  [1473] = {.lex_state = 406, .external_lex_state = 7},
  [1474] = {.lex_state = 406, .external_lex_state = 7},
  [1475] = {.lex_state = 406, .external_lex_state = 7},
  [1476] = {.lex_state = 406, .external_lex_state = 7},
  [1477] = {.lex_state = 406, .external_lex_state = 7},
  [1478] = {.lex_state = 406, .external_lex_state = 7},
  [1479] = {.lex_state = 406, .external_lex_state = 7},
  [1480] = {.lex_state = 406, .external_lex_state = 7},
  [1481] = {.lex_state = 406, .external_lex_state = 7},
  [1482] = {.lex_state = 406, .external_lex_state = 7},
  [1483] = {.lex_state = 406, .external_lex_state = 7},
  [1484] = {.lex_state = 406, .external_lex_state = 7},
  [1485] = {.lex_state = 406, .external_lex_state = 7},
  [1486] = {.lex_state = 406, .external_lex_state = 8},
  [1487] = {.lex_state = 406, .external_lex_state = 7},
  [1488] = {.lex_state = 406, .external_lex_state = 7},
  [1489] = {.lex_state = 406, .external_lex_state = 7},
  [1490] = {.lex_state = 406, .external_lex_state = 7},
  [1491] = {.lex_state = 406, .external_lex_state = 7},
  [1492] = {.lex_state = 406, .external_lex_state = 7},
  [1493] = {.lex_state = 406, .external_lex_state = 7},
  [1494] = {.lex_state = 406, .external_lex_state = 8},
  [1495] = {.lex_state = 406, .external_lex_state = 7},
  [1496] = {.lex_state = 406, .external_lex_state = 7},
  [1497] = {.lex_state = 406, .external_lex_state = 7},
  [1498] = {.lex_state = 406, .external_lex_state = 7},
  [1499] = {.lex_state = 406, .external_lex_state = 7},
  [1500] = {.lex_state = 406, .external_lex_state = 7},
  [1501] = {.lex_state = 406, .external_lex_state = 7},
  [1502] = {.lex_state = 406, .external_lex_state = 7},
  [1503] = {.lex_state = 409},
  [1504] = {.lex_state = 405},
  [1505] = {.lex_state = 441},
  [1506] = {.lex_state = 410},
  [1507] = {.lex_state = 405},
  [1508] = {.lex_state = 441},
  [1509] = {.lex_state = 441},
  [1510] = {.lex_state = 441},
  [1511] = {.lex_state = 410},
  [1512] = {.lex_state = 410},
  [1513] = {.lex_state = 410},
  [1514] = {.lex_state = 410},
  [1515] = {.lex_state = 410},
  [1516] = {.lex_state = 441},
  [1517] = {.lex_state = 441},
  [1518] = {.lex_state = 405},
  [1519] = {.lex_state = 441},
  [1520] = {.lex_state = 405},
  [1521] = {.lex_state = 405},
  [1522] = {.lex_state = 441},
  [1523] = {.lex_state = 405},
  [1524] = {.lex_state = 405},
  [1525] = {.lex_state = 409},
  [1526] = {.lex_state = 405},
  [1527] = {.lex_state = 405},
  [1528] = {.lex_state = 405},
  [1529] = {.lex_state = 405},
  [1530] = {.lex_state = 405},
  [1531] = {.lex_state = 405},
  [1532] = {.lex_state = 405},
  [1533] = {.lex_state = 409},
  [1534] = {.lex_state = 441},
  [1535] = {.lex_state = 441},
  [1536] = {.lex_state = 441},
  [1537] = {.lex_state = 441},
  [1538] = {.lex_state = 441},
  [1539] = {.lex_state = 441},
  [1540] = {.lex_state = 441},
  [1541] = {.lex_state = 410},
  [1542] = {.lex_state = 441},
  [1543] = {.lex_state = 410},
  [1544] = {.lex_state = 410},
  [1545] = {.lex_state = 410},
  [1546] = {.lex_state = 410},
  [1547] = {.lex_state = 409},
  [1548] = {.lex_state = 410},
  [1549] = {.lex_state = 410},
  [1550] = {.lex_state = 441},
  [1551] = {.lex_state = 441},
  [1552] = {.lex_state = 441},
  [1553] = {.lex_state = 441},
  [1554] = {.lex_state = 441},
  [1555] = {.lex_state = 441},
  [1556] = {.lex_state = 405},
  [1557] = {.lex_state = 441},
  [1558] = {.lex_state = 409},
  [1559] = {.lex_state = 410},
  [1560] = {.lex_state = 441},
  [1561] = {.lex_state = 410},
  [1562] = {.lex_state = 409},
  [1563] = {.lex_state = 410},
  [1564] = {.lex_state = 410},
  [1565] = {.lex_state = 410},
  [1566] = {.lex_state = 410},
  [1567] = {.lex_state = 410},
  [1568] = {.lex_state = 410},
  [1569] = {.lex_state = 405},
  [1570] = {.lex_state = 409},
  [1571] = {.lex_state = 410},
  [1572] = {.lex_state = 410},
  [1573] = {.lex_state = 410},
  [1574] = {.lex_state = 410},
  [1575] = {.lex_state = 410},
  [1576] = {.lex_state = 409},
  [1577] = {.lex_state = 441},
  [1578] = {.lex_state = 441},
  [1579] = {.lex_state = 441},
  [1580] = {.lex_state = 410},
  [1581] = {.lex_state = 441},
  [1582] = {.lex_state = 441},
  [1583] = {.lex_state = 410},
  [1584] = {.lex_state = 410},
  [1585] = {.lex_state = 441},
  [1586] = {.lex_state = 410},
  [1587] = {.lex_state = 406, .external_lex_state = 9},
  [1588] = {.lex_state = 406, .external_lex_state = 9},
  [1589] = {.lex_state = 406},
  [1590] = {.lex_state = 405},
  [1591] = {.lex_state = 405},
  [1592] = {.lex_state = 406, .external_lex_state = 7},
  [1593] = {.lex_state = 405},
  [1594] = {.lex_state = 405},
  [1595] = {.lex_state = 405},
  [1596] = {.lex_state = 406},
  [1597] = {.lex_state = 405},
  [1598] = {.lex_state = 406},
  [1599] = {.lex_state = 405},
  [1600] = {.lex_state = 405},
  [1601] = {.lex_state = 405},
  [1602] = {.lex_state = 405},
  [1603] = {.lex_state = 406},
  [1604] = {.lex_state = 406, .external_lex_state = 9},
  [1605] = {.lex_state = 406, .external_lex_state = 9},
  [1606] = {.lex_state = 406, .external_lex_state = 9},
  [1607] = {.lex_state = 406, .external_lex_state = 9},
  [1608] = {.lex_state = 405},
  [1609] = {.lex_state = 406},
  [1610] = {.lex_state = 405},
  [1611] = {.lex_state = 405},
  [1612] = {.lex_state = 406, .external_lex_state = 9},
  [1613] = {.lex_state = 405},
  [1614] = {.lex_state = 405},
  [1615] = {.lex_state = 406},
  [1616] = {.lex_state = 406, .external_lex_state = 9},
  [1617] = {.lex_state = 405},
  [1618] = {.lex_state = 406, .external_lex_state = 9},
  [1619] = {.lex_state = 406, .external_lex_state = 9},
  [1620] = {.lex_state = 406, .external_lex_state = 9},
  [1621] = {.lex_state = 406, .external_lex_state = 10},
  [1622] = {.lex_state = 406},
  [1623] = {.lex_state = 406, .external_lex_state = 10},
  [1624] = {.lex_state = 406, .external_lex_state = 10},
  [1625] = {.lex_state = 406, .external_lex_state = 10},
  [1626] = {.lex_state = 406, .external_lex_state = 10},
  [1627] = {.lex_state = 406, .external_lex_state = 10},
  [1628] = {.lex_state = 406, .external_lex_state = 10},
  [1629] = {.lex_state = 406, .external_lex_state = 9},
  [1630] = {.lex_state = 406, .external_lex_state = 9},
  [1631] = {.lex_state = 406, .external_lex_state = 9},
  [1632] = {.lex_state = 406, .external_lex_state = 9},
  [1633] = {.lex_state = 406, .external_lex_state = 9},
  [1634] = {.lex_state = 406, .external_lex_state = 10},
  [1635] = {.lex_state = 406, .external_lex_state = 9},
  [1636] = {.lex_state = 406, .external_lex_state = 10},
  [1637] = {.lex_state = 406, .external_lex_state = 10},
  [1638] = {.lex_state = 406, .external_lex_state = 10},
  [1639] = {.lex_state = 406, .external_lex_state = 10},
  [1640] = {.lex_state = 406, .external_lex_state = 10},
  [1641] = {.lex_state = 406, .external_lex_state = 10},
  [1642] = {.lex_state = 406, .external_lex_state = 10},
  [1643] = {.lex_state = 406, .external_lex_state = 10},
  [1644] = {.lex_state = 406, .external_lex_state = 10},
  [1645] = {.lex_state = 406, .external_lex_state = 10},
  [1646] = {.lex_state = 406, .external_lex_state = 10},
  [1647] = {.lex_state = 406, .external_lex_state = 10},
  [1648] = {.lex_state = 406, .external_lex_state = 10},
  [1649] = {.lex_state = 406, .external_lex_state = 10},
  [1650] = {.lex_state = 406, .external_lex_state = 10},
  [1651] = {.lex_state = 406, .external_lex_state = 10},
  [1652] = {.lex_state = 406},
  [1653] = {.lex_state = 406, .external_lex_state = 9},
  [1654] = {.lex_state = 406, .external_lex_state = 10},
  [1655] = {.lex_state = 405},
  [1656] = {.lex_state = 405},
  [1657] = {.lex_state = 405},
  [1658] = {.lex_state = 406, .external_lex_state = 9},
  [1659] = {.lex_state = 406, .external_lex_state = 9},
  [1660] = {.lex_state = 406},
  [1661] = {.lex_state = 405},
  [1662] = {.lex_state = 405},
  [1663] = {.lex_state = 406, .external_lex_state = 10},
  [1664] = {.lex_state = 406, .external_lex_state = 10},
  [1665] = {.lex_state = 406, .external_lex_state = 10},
  [1666] = {.lex_state = 406, .external_lex_state = 9},
  [1667] = {.lex_state = 406, .external_lex_state = 10},
  [1668] = {.lex_state = 406, .external_lex_state = 10},
  [1669] = {.lex_state = 406, .external_lex_state = 9},
  [1670] = {.lex_state = 406, .external_lex_state = 9},
  [1671] = {.lex_state = 406, .external_lex_state = 9},
  [1672] = {.lex_state = 406},
  [1673] = {.lex_state = 405},
  [1674] = {.lex_state = 406},
  [1675] = {.lex_state = 405},
  [1676] = {.lex_state = 405},
  [1677] = {.lex_state = 405},
  [1678] = {.lex_state = 405},
  [1679] = {.lex_state = 406},
  [1680] = {.lex_state = 405},
  [1681] = {.lex_state = 405},
  [1682] = {.lex_state = 405},
  [1683] = {.lex_state = 405},
  [1684] = {.lex_state = 406, .external_lex_state = 9},
  [1685] = {.lex_state = 406, .external_lex_state = 9},
  [1686] = {.lex_state = 406, .external_lex_state = 9},
  [1687] = {.lex_state = 406, .external_lex_state = 9},
  [1688] = {.lex_state = 406, .external_lex_state = 9},
  [1689] = {.lex_state = 406},
  [1690] = {.lex_state = 406, .external_lex_state = 9},
  [1691] = {.lex_state = 406},
  [1692] = {.lex_state = 406},
  [1693] = {.lex_state = 406},
  [1694] = {.lex_state = 406},
  [1695] = {.lex_state = 406},
  [1696] = {.lex_state = 406},
  [1697] = {.lex_state = 406},
  [1698] = {.lex_state = 406, .external_lex_state = 7},
  [1699] = {.lex_state = 406},
  [1700] = {.lex_state = 406},
  [1701] = {.lex_state = 406},
  [1702] = {.lex_state = 406},
  [1703] = {.lex_state = 406},
  [1704] = {.lex_state = 406},
  [1705] = {.lex_state = 441},
  [1706] = {.lex_state = 406},
  [1707] = {.lex_state = 406},
  [1708] = {.lex_state = 406},
  [1709] = {.lex_state = 406},
  [1710] = {.lex_state = 406},
  [1711] = {.lex_state = 406},
  [1712] = {.lex_state = 406},
  [1713] = {.lex_state = 410},
  [1714] = {.lex_state = 406},
  [1715] = {.lex_state = 405},
  [1716] = {.lex_state = 406},
  [1717] = {.lex_state = 405},
  [1718] = {.lex_state = 406},
  [1719] = {.lex_state = 406},
  [1720] = {.lex_state = 406},
  [1721] = {.lex_state = 406},
  [1722] = {.lex_state = 406},
  [1723] = {.lex_state = 406},
  [1724] = {.lex_state = 406},
  [1725] = {.lex_state = 406},
  [1726] = {.lex_state = 405},
  [1727] = {.lex_state = 405},
  [1728] = {.lex_state = 406},
  [1729] = {.lex_state = 406},
  [1730] = {.lex_state = 406},
  [1731] = {.lex_state = 405},
  [1732] = {.lex_state = 406},
  [1733] = {.lex_state = 405},
  [1734] = {.lex_state = 406},
  [1735] = {.lex_state = 405},
  [1736] = {.lex_state = 406},
  [1737] = {.lex_state = 406},
  [1738] = {.lex_state = 406},
  [1739] = {.lex_state = 406},
  [1740] = {.lex_state = 406},
  [1741] = {.lex_state = 406},
  [1742] = {.lex_state = 406},
  [1743] = {.lex_state = 406},
  [1744] = {.lex_state = 405},
  [1745] = {.lex_state = 406},
  [1746] = {.lex_state = 406},
  [1747] = {.lex_state = 406},
  [1748] = {.lex_state = 406},
  [1749] = {.lex_state = 406},
  [1750] = {.lex_state = 406},
  [1751] = {.lex_state = 405},
  [1752] = {.lex_state = 406},
  [1753] = {.lex_state = 406},
  [1754] = {.lex_state = 406},
  [1755] = {.lex_state = 406},
  [1756] = {.lex_state = 405},
  [1757] = {.lex_state = 405},
  [1758] = {.lex_state = 406},
  [1759] = {.lex_state = 406},
  [1760] = {.lex_state = 406},
  [1761] = {.lex_state = 405},
  [1762] = {.lex_state = 406},
  [1763] = {.lex_state = 406},
  [1764] = {.lex_state = 406},
  [1765] = {.lex_state = 405},
  [1766] = {.lex_state = 406},
  [1767] = {.lex_state = 406},
  [1768] = {.lex_state = 410},
  [1769] = {.lex_state = 406},
  [1770] = {.lex_state = 406},
  [1771] = {.lex_state = 405},
  [1772] = {.lex_state = 406},
  [1773] = {.lex_state = 406},
  [1774] = {.lex_state = 406},
  [1775] = {.lex_state = 406},
  [1776] = {.lex_state = 406},
  [1777] = {.lex_state = 406},
  [1778] = {.lex_state = 405},
  [1779] = {.lex_state = 406},
  [1780] = {.lex_state = 406},
  [1781] = {.lex_state = 406},
  [1782] = {.lex_state = 406},
  [1783] = {.lex_state = 405},
  [1784] = {.lex_state = 406, .external_lex_state = 10},
  [1785] = {.lex_state = 406, .external_lex_state = 9},
  [1786] = {.lex_state = 406},
  [1787] = {.lex_state = 406, .external_lex_state = 7},
  [1788] = {.lex_state = 406},
  [1789] = {.lex_state = 406},
  [1790] = {.lex_state = 406, .external_lex_state = 7},
  [1791] = {.lex_state = 406, .external_lex_state = 7},
  [1792] = {.lex_state = 406},
  [1793] = {.lex_state = 406, .external_lex_state = 7},
  [1794] = {.lex_state = 406, .external_lex_state = 7},
  [1795] = {.lex_state = 406},
  [1796] = {.lex_state = 406, .external_lex_state = 7},
  [1797] = {.lex_state = 406},
  [1798] = {.lex_state = 406},
  [1799] = {.lex_state = 406},
  [1800] = {.lex_state = 406},
  [1801] = {.lex_state = 406},
  [1802] = {.lex_state = 406},
  [1803] = {.lex_state = 406},
  [1804] = {.lex_state = 406},
  [1805] = {.lex_state = 406},
  [1806] = {.lex_state = 406},
  [1807] = {.lex_state = 406},
  [1808] = {.lex_state = 406},
  [1809] = {.lex_state = 406},
  [1810] = {.lex_state = 406},
  [1811] = {.lex_state = 406},
  [1812] = {.lex_state = 406},
  [1813] = {.lex_state = 406},
  [1814] = {.lex_state = 406},
  [1815] = {.lex_state = 406},
  [1816] = {.lex_state = 406},
  [1817] = {.lex_state = 406},
  [1818] = {.lex_state = 406},
  [1819] = {.lex_state = 406},
  [1820] = {.lex_state = 406},
  [1821] = {.lex_state = 406},
  [1822] = {.lex_state = 406},
  [1823] = {.lex_state = 406},
  [1824] = {.lex_state = 406},
  [1825] = {.lex_state = 406},
  [1826] = {.lex_state = 406},
  [1827] = {.lex_state = 406},
  [1828] = {.lex_state = 406},
  [1829] = {.lex_state = 406},
  [1830] = {.lex_state = 406},
  [1831] = {.lex_state = 406},
  [1832] = {.lex_state = 406},
  [1833] = {.lex_state = 406},
  [1834] = {.lex_state = 406},
  [1835] = {.lex_state = 406},
  [1836] = {.lex_state = 406},
  [1837] = {.lex_state = 406},
  [1838] = {.lex_state = 406},
  [1839] = {.lex_state = 406},
  [1840] = {.lex_state = 406},
  [1841] = {.lex_state = 406},
  [1842] = {.lex_state = 406},
  [1843] = {.lex_state = 406},
  [1844] = {.lex_state = 406},
  [1845] = {.lex_state = 406},
  [1846] = {.lex_state = 406},
  [1847] = {.lex_state = 406},
  [1848] = {.lex_state = 406},
  [1849] = {.lex_state = 406},
  [1850] = {.lex_state = 406},
  [1851] = {.lex_state = 406},
  [1852] = {.lex_state = 406},
  [1853] = {.lex_state = 406},
  [1854] = {.lex_state = 406},
  [1855] = {.lex_state = 406},
  [1856] = {.lex_state = 406},
  [1857] = {.lex_state = 406},
  [1858] = {.lex_state = 406},
  [1859] = {.lex_state = 406},
  [1860] = {.lex_state = 406},
  [1861] = {.lex_state = 406},
  [1862] = {.lex_state = 406},
  [1863] = {.lex_state = 406},
  [1864] = {.lex_state = 406},
  [1865] = {.lex_state = 406},
  [1866] = {.lex_state = 406},
  [1867] = {.lex_state = 406},
  [1868] = {.lex_state = 406},
  [1869] = {.lex_state = 406},
  [1870] = {.lex_state = 406},
  [1871] = {.lex_state = 406},
  [1872] = {.lex_state = 406},
  [1873] = {.lex_state = 406},
  [1874] = {.lex_state = 406},
  [1875] = {.lex_state = 406},
  [1876] = {.lex_state = 406},
  [1877] = {.lex_state = 406},
  [1878] = {.lex_state = 406},
  [1879] = {.lex_state = 406},
  [1880] = {.lex_state = 406},
  [1881] = {.lex_state = 406},
  [1882] = {.lex_state = 406},
  [1883] = {.lex_state = 406},
  [1884] = {.lex_state = 406},
  [1885] = {.lex_state = 406},
  [1886] = {.lex_state = 406},
  [1887] = {.lex_state = 406},
  [1888] = {.lex_state = 406},
  [1889] = {.lex_state = 406},
  [1890] = {.lex_state = 406},
  [1891] = {.lex_state = 406},
  [1892] = {.lex_state = 406},
  [1893] = {.lex_state = 406},
  [1894] = {.lex_state = 406},
  [1895] = {.lex_state = 406},
  [1896] = {.lex_state = 406},
  [1897] = {.lex_state = 406},
  [1898] = {.lex_state = 406},
  [1899] = {.lex_state = 406},
  [1900] = {.lex_state = 406},
  [1901] = {.lex_state = 406},
  [1902] = {.lex_state = 406},
  [1903] = {.lex_state = 406},
  [1904] = {.lex_state = 406},
  [1905] = {.lex_state = 406},
  [1906] = {.lex_state = 406},
  [1907] = {.lex_state = 406},
  [1908] = {.lex_state = 406},
  [1909] = {.lex_state = 406},
  [1910] = {.lex_state = 406},
  [1911] = {.lex_state = 406},
  [1912] = {.lex_state = 406},
  [1913] = {.lex_state = 406},
  [1914] = {.lex_state = 406},
  [1915] = {.lex_state = 406},
  [1916] = {.lex_state = 406},
  [1917] = {.lex_state = 406},
  [1918] = {.lex_state = 406},
  [1919] = {.lex_state = 406},
  [1920] = {.lex_state = 406},
  [1921] = {.lex_state = 406},
  [1922] = {.lex_state = 406},
  [1923] = {.lex_state = 406},
  [1924] = {.lex_state = 406},
  [1925] = {.lex_state = 406},
  [1926] = {.lex_state = 406},
  [1927] = {.lex_state = 406},
  [1928] = {.lex_state = 406},
  [1929] = {.lex_state = 406},
  [1930] = {.lex_state = 406},
  [1931] = {.lex_state = 406},
  [1932] = {.lex_state = 406},
  [1933] = {.lex_state = 406},
  [1934] = {.lex_state = 406},
  [1935] = {.lex_state = 406},
  [1936] = {.lex_state = 406},
  [1937] = {.lex_state = 406},
  [1938] = {.lex_state = 406},
  [1939] = {.lex_state = 406},
  [1940] = {.lex_state = 406},
  [1941] = {.lex_state = 406},
  [1942] = {.lex_state = 406},
  [1943] = {.lex_state = 406},
  [1944] = {.lex_state = 406},
  [1945] = {.lex_state = 406},
  [1946] = {.lex_state = 406},
  [1947] = {.lex_state = 406},
  [1948] = {.lex_state = 406, .external_lex_state = 7},
  [1949] = {.lex_state = 406},
  [1950] = {.lex_state = 406},
  [1951] = {.lex_state = 406},
  [1952] = {.lex_state = 406},
  [1953] = {.lex_state = 406},
  [1954] = {.lex_state = 406},
  [1955] = {.lex_state = 406},
  [1956] = {.lex_state = 406},
  [1957] = {.lex_state = 406},
  [1958] = {.lex_state = 406},
  [1959] = {.lex_state = 406},
  [1960] = {.lex_state = 406},
  [1961] = {.lex_state = 406},
  [1962] = {.lex_state = 406},
  [1963] = {.lex_state = 406},
  [1964] = {.lex_state = 406},
  [1965] = {.lex_state = 406},
  [1966] = {.lex_state = 406},
  [1967] = {.lex_state = 406},
  [1968] = {.lex_state = 406},
  [1969] = {.lex_state = 406},
  [1970] = {.lex_state = 406},
  [1971] = {.lex_state = 406},
  [1972] = {.lex_state = 406},
  [1973] = {.lex_state = 406},
  [1974] = {.lex_state = 406},
  [1975] = {.lex_state = 406},
  [1976] = {.lex_state = 406},
  [1977] = {.lex_state = 406},
  [1978] = {.lex_state = 406},
  [1979] = {.lex_state = 406},
  [1980] = {.lex_state = 406},
  [1981] = {.lex_state = 406},
  [1982] = {.lex_state = 406},
  [1983] = {.lex_state = 406},
  [1984] = {.lex_state = 406},
  [1985] = {.lex_state = 406},
  [1986] = {.lex_state = 406},
  [1987] = {.lex_state = 406},
  [1988] = {.lex_state = 406},
  [1989] = {.lex_state = 406},
  [1990] = {.lex_state = 406},
  [1991] = {.lex_state = 406},
  [1992] = {.lex_state = 406},
  [1993] = {.lex_state = 406},
  [1994] = {.lex_state = 406},
  [1995] = {.lex_state = 406},
  [1996] = {.lex_state = 390, .external_lex_state = 4},
  [1997] = {.lex_state = 390, .external_lex_state = 4},
  [1998] = {.lex_state = 390, .external_lex_state = 4},
  [1999] = {.lex_state = 390, .external_lex_state = 4},
  [2000] = {.lex_state = 390, .external_lex_state = 4},
  [2001] = {.lex_state = 390, .external_lex_state = 4},
  [2002] = {.lex_state = 390, .external_lex_state = 4},
  [2003] = {.lex_state = 390, .external_lex_state = 4},
  [2004] = {.lex_state = 390, .external_lex_state = 4},
  [2005] = {.lex_state = 411},
  [2006] = {.lex_state = 411},
  [2007] = {.lex_state = 411},
  [2008] = {.lex_state = 412},
  [2009] = {.lex_state = 412},
  [2010] = {.lex_state = 412},
  [2011] = {.lex_state = 412},
  [2012] = {.lex_state = 413, .external_lex_state = 6},
  [2013] = {.lex_state = 389, .external_lex_state = 3},
  [2014] = {.lex_state = 389, .external_lex_state = 4},
  [2015] = {.lex_state = 400, .external_lex_state = 6},
  [2016] = {.lex_state = 413},
  [2017] = {.lex_state = 440},
  [2018] = {.lex_state = 400, .external_lex_state = 6},
  [2019] = {.lex_state = 400, .external_lex_state = 6},
  [2020] = {.lex_state = 400, .external_lex_state = 6},
  [2021] = {.lex_state = 400, .external_lex_state = 6},
  [2022] = {.lex_state = 400, .external_lex_state = 6},
  [2023] = {.lex_state = 400, .external_lex_state = 6},
  [2024] = {.lex_state = 400, .external_lex_state = 6},
  [2025] = {.lex_state = 400, .external_lex_state = 6},
  [2026] = {.lex_state = 400, .external_lex_state = 6},
  [2027] = {.lex_state = 400, .external_lex_state = 6},
  [2028] = {.lex_state = 400},
  [2029] = {.lex_state = 400, .external_lex_state = 6},
  [2030] = {.lex_state = 400, .external_lex_state = 6},
  [2031] = {.lex_state = 400, .external_lex_state = 6},
  [2032] = {.lex_state = 396, .external_lex_state = 4},
  [2033] = {.lex_state = 395, .external_lex_state = 4},
  [2034] = {.lex_state = 400, .external_lex_state = 6},
  [2035] = {.lex_state = 400, .external_lex_state = 6},
  [2036] = {.lex_state = 396, .external_lex_state = 4},
  [2037] = {.lex_state = 400, .external_lex_state = 6},
  [2038] = {.lex_state = 400, .external_lex_state = 6},
  [2039] = {.lex_state = 440},
  [2040] = {.lex_state = 400, .external_lex_state = 6},
  [2041] = {.lex_state = 400, .external_lex_state = 6},
  [2042] = {.lex_state = 400, .external_lex_state = 6},
  [2043] = {.lex_state = 400, .external_lex_state = 6},
  [2044] = {.lex_state = 400, .external_lex_state = 6},
  [2045] = {.lex_state = 400, .external_lex_state = 6},
  [2046] = {.lex_state = 400, .external_lex_state = 6},
  [2047] = {.lex_state = 400, .external_lex_state = 6},
  [2048] = {.lex_state = 400, .external_lex_state = 6},
  [2049] = {.lex_state = 400, .external_lex_state = 6},
  [2050] = {.lex_state = 400, .external_lex_state = 6},
  [2051] = {.lex_state = 400, .external_lex_state = 6},
  [2052] = {.lex_state = 400, .external_lex_state = 6},
  [2053] = {.lex_state = 400, .external_lex_state = 6},
  [2054] = {.lex_state = 400, .external_lex_state = 6},
  [2055] = {.lex_state = 400, .external_lex_state = 6},
  [2056] = {.lex_state = 400, .external_lex_state = 6},
  [2057] = {.lex_state = 400, .external_lex_state = 6},
  [2058] = {.lex_state = 395, .external_lex_state = 4},
  [2059] = {.lex_state = 395, .external_lex_state = 4},
  [2060] = {.lex_state = 395, .external_lex_state = 4},
  [2061] = {.lex_state = 395, .external_lex_state = 4},
  [2062] = {.lex_state = 400, .external_lex_state = 6},
  [2063] = {.lex_state = 400, .external_lex_state = 6},
  [2064] = {.lex_state = 400, .external_lex_state = 6},
  [2065] = {.lex_state = 400, .external_lex_state = 6},
  [2066] = {.lex_state = 400, .external_lex_state = 6},
  [2067] = {.lex_state = 395, .external_lex_state = 4},
  [2068] = {.lex_state = 400, .external_lex_state = 6},
  [2069] = {.lex_state = 395, .external_lex_state = 4},
  [2070] = {.lex_state = 440},
  [2071] = {.lex_state = 400, .external_lex_state = 6},
  [2072] = {.lex_state = 400, .external_lex_state = 6},
  [2073] = {.lex_state = 395, .external_lex_state = 4},
  [2074] = {.lex_state = 400, .external_lex_state = 6},
  [2075] = {.lex_state = 400, .external_lex_state = 6},
  [2076] = {.lex_state = 400, .external_lex_state = 6},
  [2077] = {.lex_state = 400, .external_lex_state = 6},
  [2078] = {.lex_state = 400, .external_lex_state = 6},
  [2079] = {.lex_state = 400, .external_lex_state = 6},
  [2080] = {.lex_state = 400, .external_lex_state = 6},
  [2081] = {.lex_state = 400, .external_lex_state = 6},
  [2082] = {.lex_state = 400, .external_lex_state = 6},
  [2083] = {.lex_state = 400, .external_lex_state = 6},
  [2084] = {.lex_state = 400, .external_lex_state = 6},
  [2085] = {.lex_state = 400, .external_lex_state = 6},
  [2086] = {.lex_state = 400, .external_lex_state = 6},
  [2087] = {.lex_state = 440},
  [2088] = {.lex_state = 400, .external_lex_state = 6},
  [2089] = {.lex_state = 400, .external_lex_state = 6},
  [2090] = {.lex_state = 400, .external_lex_state = 6},
  [2091] = {.lex_state = 400, .external_lex_state = 6},
  [2092] = {.lex_state = 396, .external_lex_state = 4},
  [2093] = {.lex_state = 396, .external_lex_state = 4},
  [2094] = {.lex_state = 396, .external_lex_state = 4},
  [2095] = {.lex_state = 440},
  [2096] = {.lex_state = 396, .external_lex_state = 4},
  [2097] = {.lex_state = 396, .external_lex_state = 4},
  [2098] = {.lex_state = 396, .external_lex_state = 4},
  [2099] = {.lex_state = 396, .external_lex_state = 4},
  [2100] = {.lex_state = 400, .external_lex_state = 6},
  [2101] = {.lex_state = 400, .external_lex_state = 6},
  [2102] = {.lex_state = 400, .external_lex_state = 6},
  [2103] = {.lex_state = 440},
  [2104] = {.lex_state = 440},
  [2105] = {.lex_state = 395, .external_lex_state = 5},
  [2106] = {.lex_state = 395, .external_lex_state = 5},
  [2107] = {.lex_state = 395, .external_lex_state = 5},
  [2108] = {.lex_state = 395, .external_lex_state = 5},
  [2109] = {.lex_state = 440},
  [2110] = {.lex_state = 440},
  [2111] = {.lex_state = 395, .external_lex_state = 5},
  [2112] = {.lex_state = 395, .external_lex_state = 5},
  [2113] = {.lex_state = 440},
  [2114] = {.lex_state = 395, .external_lex_state = 5},
  [2115] = {.lex_state = 395, .external_lex_state = 5},
  [2116] = {.lex_state = 440},
  [2117] = {.lex_state = 440},
  [2118] = {.lex_state = 440},
  [2119] = {.lex_state = 395, .external_lex_state = 5},
  [2120] = {.lex_state = 395, .external_lex_state = 4},
  [2121] = {.lex_state = 395, .external_lex_state = 5},
  [2122] = {.lex_state = 440},
  [2123] = {.lex_state = 440},
  [2124] = {.lex_state = 440},
  [2125] = {.lex_state = 440},
  [2126] = {.lex_state = 440},
  [2127] = {.lex_state = 440},
  [2128] = {.lex_state = 400},
  [2129] = {.lex_state = 440},
  [2130] = {.lex_state = 440},
  [2131] = {.lex_state = 400},
  [2132] = {.lex_state = 440},
  [2133] = {.lex_state = 440},
  [2134] = {.lex_state = 440},
  [2135] = {.lex_state = 440},
  [2136] = {.lex_state = 440},
  [2137] = {.lex_state = 440},
  [2138] = {.lex_state = 440},
  [2139] = {.lex_state = 440},
  [2140] = {.lex_state = 397, .external_lex_state = 4},
  [2141] = {.lex_state = 440},
  [2142] = {.lex_state = 440},
  [2143] = {.lex_state = 440},
  [2144] = {.lex_state = 440},
  [2145] = {.lex_state = 440},
  [2146] = {.lex_state = 440},
  [2147] = {.lex_state = 440},
  [2148] = {.lex_state = 440},
  [2149] = {.lex_state = 440},
  [2150] = {.lex_state = 440},
  [2151] = {.lex_state = 440},
  [2152] = {.lex_state = 440},
  [2153] = {.lex_state = 440},
  [2154] = {.lex_state = 440},
  [2155] = {.lex_state = 440},
  [2156] = {.lex_state = 440},
  [2157] = {.lex_state = 440},
  [2158] = {.lex_state = 440},
  [2159] = {.lex_state = 440},
  [2160] = {.lex_state = 440},
  [2161] = {.lex_state = 440},
  [2162] = {.lex_state = 440},
  [2163] = {.lex_state = 440},
  [2164] = {.lex_state = 440},
  [2165] = {.lex_state = 440},
  [2166] = {.lex_state = 440},
  [2167] = {.lex_state = 440},
  [2168] = {.lex_state = 440},
  [2169] = {.lex_state = 440},
  [2170] = {.lex_state = 440},
  [2171] = {.lex_state = 400},
  [2172] = {.lex_state = 440},
  [2173] = {.lex_state = 440},
  [2174] = {.lex_state = 440},
  [2175] = {.lex_state = 400},
  [2176] = {.lex_state = 440},
  [2177] = {.lex_state = 440},
  [2178] = {.lex_state = 400},
  [2179] = {.lex_state = 400},
  [2180] = {.lex_state = 400},
  [2181] = {.lex_state = 400},
  [2182] = {.lex_state = 394, .external_lex_state = 4},
  [2183] = {.lex_state = 400},
  [2184] = {.lex_state = 400},
  [2185] = {.lex_state = 400},
  [2186] = {.lex_state = 400},
  [2187] = {.lex_state = 399, .external_lex_state = 4},
  [2188] = {.lex_state = 439, .external_lex_state = 4},
  [2189] = {.lex_state = 400},
  [2190] = {.lex_state = 399, .external_lex_state = 4},
  [2191] = {.lex_state = 398, .external_lex_state = 4},
  [2192] = {.lex_state = 400},
  [2193] = {.lex_state = 395, .external_lex_state = 4},
  [2194] = {.lex_state = 400},
  [2195] = {.lex_state = 400},
  [2196] = {.lex_state = 400},
  [2197] = {.lex_state = 400},
  [2198] = {.lex_state = 395, .external_lex_state = 4},
  [2199] = {.lex_state = 400},
  [2200] = {.lex_state = 400},
  [2201] = {.lex_state = 395, .external_lex_state = 4},
  [2202] = {.lex_state = 400},
  [2203] = {.lex_state = 395, .external_lex_state = 4},
  [2204] = {.lex_state = 400},
  [2205] = {.lex_state = 395, .external_lex_state = 4},
  [2206] = {.lex_state = 400},
  [2207] = {.lex_state = 400},
  [2208] = {.lex_state = 400},
  [2209] = {.lex_state = 400},
  [2210] = {.lex_state = 400},
  [2211] = {.lex_state = 400},
  [2212] = {.lex_state = 395, .external_lex_state = 4},
  [2213] = {.lex_state = 400},
  [2214] = {.lex_state = 400},
  [2215] = {.lex_state = 400},
  [2216] = {.lex_state = 400},
  [2217] = {.lex_state = 400},
  [2218] = {.lex_state = 400},
  [2219] = {.lex_state = 400},
  [2220] = {.lex_state = 395, .external_lex_state = 4},
  [2221] = {.lex_state = 400},
  [2222] = {.lex_state = 400},
  [2223] = {.lex_state = 395, .external_lex_state = 4},
  [2224] = {.lex_state = 400},
  [2225] = {.lex_state = 395, .external_lex_state = 4},
  [2226] = {.lex_state = 395, .external_lex_state = 4},
  [2227] = {.lex_state = 395, .external_lex_state = 4},
  [2228] = {.lex_state = 395, .external_lex_state = 4},
  [2229] = {.lex_state = 400},
  [2230] = {.lex_state = 395, .external_lex_state = 4},
  [2231] = {.lex_state = 395, .external_lex_state = 4},
  [2232] = {.lex_state = 400},
  [2233] = {.lex_state = 400},
  [2234] = {.lex_state = 400},
  [2235] = {.lex_state = 395, .external_lex_state = 4},
  [2236] = {.lex_state = 395, .external_lex_state = 4},
  [2237] = {.lex_state = 395, .external_lex_state = 4},
  [2238] = {.lex_state = 395, .external_lex_state = 4},
  [2239] = {.lex_state = 395, .external_lex_state = 4},
  [2240] = {.lex_state = 400},
  [2241] = {.lex_state = 395, .external_lex_state = 4},
  [2242] = {.lex_state = 395, .external_lex_state = 4},
  [2243] = {.lex_state = 400},
  [2244] = {.lex_state = 400},
  [2245] = {.lex_state = 400},
  [2246] = {.lex_state = 400},
  [2247] = {.lex_state = 395, .external_lex_state = 4},
  [2248] = {.lex_state = 395, .external_lex_state = 4},
  [2249] = {.lex_state = 400},
  [2250] = {.lex_state = 400},
  [2251] = {.lex_state = 395, .external_lex_state = 4},
  [2252] = {.lex_state = 395, .external_lex_state = 4},
  [2253] = {.lex_state = 395, .external_lex_state = 4},
  [2254] = {.lex_state = 395, .external_lex_state = 4},
  [2255] = {.lex_state = 395, .external_lex_state = 4},
  [2256] = {.lex_state = 395, .external_lex_state = 4},
  [2257] = {.lex_state = 395, .external_lex_state = 4},
  [2258] = {.lex_state = 400},
  [2259] = {.lex_state = 400},
  [2260] = {.lex_state = 395, .external_lex_state = 4},
  [2261] = {.lex_state = 395, .external_lex_state = 4},
  [2262] = {.lex_state = 395, .external_lex_state = 4},
  [2263] = {.lex_state = 395, .external_lex_state = 4},
  [2264] = {.lex_state = 395, .external_lex_state = 4},
  [2265] = {.lex_state = 395, .external_lex_state = 4},
  [2266] = {.lex_state = 395, .external_lex_state = 4},
  [2267] = {.lex_state = 400},
  [2268] = {.lex_state = 395, .external_lex_state = 4},
  [2269] = {.lex_state = 395, .external_lex_state = 4},
  [2270] = {.lex_state = 395, .external_lex_state = 4},
  [2271] = {.lex_state = 400},
  [2272] = {.lex_state = 395, .external_lex_state = 4},
  [2273] = {.lex_state = 395, .external_lex_state = 4},
  [2274] = {.lex_state = 395, .external_lex_state = 4},
  [2275] = {.lex_state = 400},
  [2276] = {.lex_state = 395, .external_lex_state = 4},
  [2277] = {.lex_state = 395, .external_lex_state = 4},
  [2278] = {.lex_state = 395, .external_lex_state = 4},
  [2279] = {.lex_state = 395, .external_lex_state = 4},
  [2280] = {.lex_state = 395, .external_lex_state = 4},
  [2281] = {.lex_state = 395, .external_lex_state = 4},
  [2282] = {.lex_state = 400},
  [2283] = {.lex_state = 400},
  [2284] = {.lex_state = 400},
  [2285] = {.lex_state = 395, .external_lex_state = 4},
  [2286] = {.lex_state = 400},
  [2287] = {.lex_state = 400},
  [2288] = {.lex_state = 400},
  [2289] = {.lex_state = 395, .external_lex_state = 4},
  [2290] = {.lex_state = 395, .external_lex_state = 4},
  [2291] = {.lex_state = 400},
  [2292] = {.lex_state = 400},
  [2293] = {.lex_state = 395, .external_lex_state = 4},
  [2294] = {.lex_state = 395, .external_lex_state = 4},
  [2295] = {.lex_state = 395, .external_lex_state = 4},
  [2296] = {.lex_state = 395, .external_lex_state = 4},
  [2297] = {.lex_state = 400},
  [2298] = {.lex_state = 395, .external_lex_state = 4},
  [2299] = {.lex_state = 395, .external_lex_state = 4},
  [2300] = {.lex_state = 395, .external_lex_state = 4},
  [2301] = {.lex_state = 395, .external_lex_state = 4},
  [2302] = {.lex_state = 395, .external_lex_state = 4},
  [2303] = {.lex_state = 395, .external_lex_state = 4},
  [2304] = {.lex_state = 395, .external_lex_state = 4},
  [2305] = {.lex_state = 395, .external_lex_state = 4},
  [2306] = {.lex_state = 395, .external_lex_state = 4},
  [2307] = {.lex_state = 395, .external_lex_state = 4},
  [2308] = {.lex_state = 395, .external_lex_state = 4},
  [2309] = {.lex_state = 395, .external_lex_state = 4},
  [2310] = {.lex_state = 395, .external_lex_state = 4},
  [2311] = {.lex_state = 395, .external_lex_state = 4},
  [2312] = {.lex_state = 395, .external_lex_state = 4},
  [2313] = {.lex_state = 395, .external_lex_state = 4},
  [2314] = {.lex_state = 403},
  [2315] = {.lex_state = 404, .external_lex_state = 7},
  [2316] = {.lex_state = 403},
  [2317] = {.lex_state = 403},
  [2318] = {.lex_state = 403},
  [2319] = {.lex_state = 403},
  [2320] = {.lex_state = 403},
  [2321] = {.lex_state = 404, .external_lex_state = 7},
  [2322] = {.lex_state = 403},
  [2323] = {.lex_state = 403},
  [2324] = {.lex_state = 404, .external_lex_state = 7},
  [2325] = {.lex_state = 403},
  [2326] = {.lex_state = 404, .external_lex_state = 7},
  [2327] = {.lex_state = 403},
  [2328] = {.lex_state = 403},
  [2329] = {.lex_state = 403},
  [2330] = {.lex_state = 403},
  [2331] = {.lex_state = 404, .external_lex_state = 7},
  [2332] = {.lex_state = 403},
  [2333] = {.lex_state = 403},
  [2334] = {.lex_state = 403},
  [2335] = {.lex_state = 403},
  [2336] = {.lex_state = 403},
  [2337] = {.lex_state = 403},
  [2338] = {.lex_state = 403},
  [2339] = {.lex_state = 403},
  [2340] = {.lex_state = 403},
  [2341] = {.lex_state = 403},
  [2342] = {.lex_state = 403},
  [2343] = {.lex_state = 403},
  [2344] = {.lex_state = 403},
  [2345] = {.lex_state = 404, .external_lex_state = 7},
  [2346] = {.lex_state = 403},
  [2347] = {.lex_state = 403},
  [2348] = {.lex_state = 403},
  [2349] = {.lex_state = 403},
  [2350] = {.lex_state = 403},
  [2351] = {.lex_state = 403},
  [2352] = {.lex_state = 403},
  [2353] = {.lex_state = 403},
  [2354] = {.lex_state = 403},
  [2355] = {.lex_state = 403},
  [2356] = {.lex_state = 403},
  [2357] = {.lex_state = 403},
  [2358] = {.lex_state = 403},
  [2359] = {.lex_state = 403},
  [2360] = {.lex_state = 403},
  [2361] = {.lex_state = 403},
  [2362] = {.lex_state = 403},
  [2363] = {.lex_state = 403},
  [2364] = {.lex_state = 403},
  [2365] = {.lex_state = 404, .external_lex_state = 7},
  [2366] = {.lex_state = 403},
  [2367] = {.lex_state = 403},
  [2368] = {.lex_state = 403},
  [2369] = {.lex_state = 403},
  [2370] = {.lex_state = 403},
  [2371] = {.lex_state = 403},
  [2372] = {.lex_state = 403},
  [2373] = {.lex_state = 403},
  [2374] = {.lex_state = 404, .external_lex_state = 7},
  [2375] = {.lex_state = 404, .external_lex_state = 7},
  [2376] = {.lex_state = 403},
  [2377] = {.lex_state = 403},
  [2378] = {.lex_state = 404, .external_lex_state = 7},
  [2379] = {.lex_state = 404, .external_lex_state = 7},
  [2380] = {.lex_state = 404, .external_lex_state = 7},
  [2381] = {.lex_state = 403},
  [2382] = {.lex_state = 403},
  [2383] = {.lex_state = 404, .external_lex_state = 7},
  [2384] = {.lex_state = 403},
  [2385] = {.lex_state = 403},
  [2386] = {.lex_state = 403},
  [2387] = {.lex_state = 404, .external_lex_state = 7},
  [2388] = {.lex_state = 403},
  [2389] = {.lex_state = 403},
  [2390] = {.lex_state = 403},
  [2391] = {.lex_state = 403},
  [2392] = {.lex_state = 404, .external_lex_state = 7},
  [2393] = {.lex_state = 404, .external_lex_state = 7},
  [2394] = {.lex_state = 404, .external_lex_state = 7},
  [2395] = {.lex_state = 404, .external_lex_state = 7},
  [2396] = {.lex_state = 404, .external_lex_state = 7},
  [2397] = {.lex_state = 404, .external_lex_state = 7},
  [2398] = {.lex_state = 404, .external_lex_state = 7},
  [2399] = {.lex_state = 404, .external_lex_state = 7},
  [2400] = {.lex_state = 404, .external_lex_state = 7},
  [2401] = {.lex_state = 404, .external_lex_state = 7},
  [2402] = {.lex_state = 404, .external_lex_state = 7},
  [2403] = {.lex_state = 404, .external_lex_state = 7},
  [2404] = {.lex_state = 404, .external_lex_state = 7},
  [2405] = {.lex_state = 404, .external_lex_state = 7},
  [2406] = {.lex_state = 404, .external_lex_state = 7},
  [2407] = {.lex_state = 404, .external_lex_state = 7},
  [2408] = {.lex_state = 404, .external_lex_state = 7},
  [2409] = {.lex_state = 404, .external_lex_state = 7},
  [2410] = {.lex_state = 404, .external_lex_state = 7},
  [2411] = {.lex_state = 404, .external_lex_state = 7},
  [2412] = {.lex_state = 404, .external_lex_state = 7},
  [2413] = {.lex_state = 404, .external_lex_state = 7},
  [2414] = {.lex_state = 404, .external_lex_state = 7},
  [2415] = {.lex_state = 404, .external_lex_state = 7},
  [2416] = {.lex_state = 404, .external_lex_state = 7},
  [2417] = {.lex_state = 404, .external_lex_state = 7},
  [2418] = {.lex_state = 404, .external_lex_state = 7},
  [2419] = {.lex_state = 404, .external_lex_state = 7},
  [2420] = {.lex_state = 404, .external_lex_state = 7},
  [2421] = {.lex_state = 404, .external_lex_state = 7},
  [2422] = {.lex_state = 404, .external_lex_state = 7},
  [2423] = {.lex_state = 404, .external_lex_state = 7},
  [2424] = {.lex_state = 404, .external_lex_state = 7},
  [2425] = {.lex_state = 404, .external_lex_state = 7},
  [2426] = {.lex_state = 404, .external_lex_state = 7},
  [2427] = {.lex_state = 404, .external_lex_state = 7},
  [2428] = {.lex_state = 404, .external_lex_state = 7},
  [2429] = {.lex_state = 404, .external_lex_state = 7},
  [2430] = {.lex_state = 404, .external_lex_state = 7},
  [2431] = {.lex_state = 404, .external_lex_state = 7},
  [2432] = {.lex_state = 404, .external_lex_state = 7},
  [2433] = {.lex_state = 404, .external_lex_state = 7},
  [2434] = {.lex_state = 404, .external_lex_state = 7},
  [2435] = {.lex_state = 404, .external_lex_state = 7},
  [2436] = {.lex_state = 404, .external_lex_state = 7},
  [2437] = {.lex_state = 404, .external_lex_state = 7},
  [2438] = {.lex_state = 404, .external_lex_state = 7},
  [2439] = {.lex_state = 404, .external_lex_state = 7},
  [2440] = {.lex_state = 404, .external_lex_state = 7},
  [2441] = {.lex_state = 404, .external_lex_state = 7},
  [2442] = {.lex_state = 414},
  [2443] = {.lex_state = 414},
  [2444] = {.lex_state = 414},
  [2445] = {.lex_state = 414},
  [2446] = {.lex_state = 414},
  [2447] = {.lex_state = 414},
  [2448] = {.lex_state = 414},
  [2449] = {.lex_state = 414},
  [2450] = {.lex_state = 414},
  [2451] = {.lex_state = 414},
  [2452] = {.lex_state = 414},
  [2453] = {.lex_state = 414},
  [2454] = {.lex_state = 414},
  [2455] = {.lex_state = 414},
  [2456] = {.lex_state = 414},
  [2457] = {.lex_state = 414},
  [2458] = {.lex_state = 415},
  [2459] = {.lex_state = 405, .external_lex_state = 8},
  [2460] = {.lex_state = 415, .external_lex_state = 8},
  [2461] = {.lex_state = 406},
  [2462] = {.lex_state = 406},
  [2463] = {.lex_state = 405, .external_lex_state = 8},
  [2464] = {.lex_state = 408},
  [2465] = {.lex_state = 405, .external_lex_state = 8},
  [2466] = {.lex_state = 405, .external_lex_state = 8},
  [2467] = {.lex_state = 406},
  [2468] = {.lex_state = 408},
  [2469] = {.lex_state = 405, .external_lex_state = 8},
  [2470] = {.lex_state = 406},
  [2471] = {.lex_state = 406},
  [2472] = {.lex_state = 405, .external_lex_state = 8},
  [2473] = {.lex_state = 406},
  [2474] = {.lex_state = 405, .external_lex_state = 8},
  [2475] = {.lex_state = 405, .external_lex_state = 8},
  [2476] = {.lex_state = 405, .external_lex_state = 8},
  [2477] = {.lex_state = 405, .external_lex_state = 8},
  [2478] = {.lex_state = 405, .external_lex_state = 8},
  [2479] = {.lex_state = 406},
  [2480] = {.lex_state = 405},
  [2481] = {.lex_state = 406},
  [2482] = {.lex_state = 405, .external_lex_state = 8},
  [2483] = {.lex_state = 406},
  [2484] = {.lex_state = 406},
  [2485] = {.lex_state = 406},
  [2486] = {.lex_state = 415, .external_lex_state = 7},
  [2487] = {.lex_state = 405, .external_lex_state = 8},
  [2488] = {.lex_state = 406},
  [2489] = {.lex_state = 405, .external_lex_state = 8},
  [2490] = {.lex_state = 406},
  [2491] = {.lex_state = 405, .external_lex_state = 8},
  [2492] = {.lex_state = 406},
  [2493] = {.lex_state = 405, .external_lex_state = 8},
  [2494] = {.lex_state = 406, .external_lex_state = 8},
  [2495] = {.lex_state = 406},
  [2496] = {.lex_state = 405, .external_lex_state = 8},
  [2497] = {.lex_state = 406},
  [2498] = {.lex_state = 406},
  [2499] = {.lex_state = 405, .external_lex_state = 8},
  [2500] = {.lex_state = 406},
  [2501] = {.lex_state = 406},
  [2502] = {.lex_state = 405, .external_lex_state = 8},
  [2503] = {.lex_state = 406},
  [2504] = {.lex_state = 405, .external_lex_state = 8},
  [2505] = {.lex_state = 405, .external_lex_state = 8},
  [2506] = {.lex_state = 405, .external_lex_state = 8},
  [2507] = {.lex_state = 405, .external_lex_state = 8},
  [2508] = {.lex_state = 405, .external_lex_state = 8},
  [2509] = {.lex_state = 406},
  [2510] = {.lex_state = 405, .external_lex_state = 8},
  [2511] = {.lex_state = 405, .external_lex_state = 8},
  [2512] = {.lex_state = 405, .external_lex_state = 8},
  [2513] = {.lex_state = 405, .external_lex_state = 8},
  [2514] = {.lex_state = 406},
  [2515] = {.lex_state = 406},
  [2516] = {.lex_state = 406},
  [2517] = {.lex_state = 406},
  [2518] = {.lex_state = 406},
  [2519] = {.lex_state = 406},
  [2520] = {.lex_state = 406},
  [2521] = {.lex_state = 406},
  [2522] = {.lex_state = 406},
  [2523] = {.lex_state = 406, .external_lex_state = 8},
  [2524] = {.lex_state = 406},
  [2525] = {.lex_state = 406},
  [2526] = {.lex_state = 410},
  [2527] = {.lex_state = 406},
  [2528] = {.lex_state = 405, .external_lex_state = 8},
  [2529] = {.lex_state = 405, .external_lex_state = 8},
  [2530] = {.lex_state = 405, .external_lex_state = 8},
  [2531] = {.lex_state = 405, .external_lex_state = 8},
  [2532] = {.lex_state = 405, .external_lex_state = 8},
  [2533] = {.lex_state = 405, .external_lex_state = 8},
  [2534] = {.lex_state = 405, .external_lex_state = 8},
  [2535] = {.lex_state = 406},
  [2536] = {.lex_state = 405, .external_lex_state = 8},
  [2537] = {.lex_state = 406},
  [2538] = {.lex_state = 405, .external_lex_state = 8},
  [2539] = {.lex_state = 406},
  [2540] = {.lex_state = 406},
  [2541] = {.lex_state = 405, .external_lex_state = 8},
  [2542] = {.lex_state = 405, .external_lex_state = 8},
  [2543] = {.lex_state = 405, .external_lex_state = 8},
  [2544] = {.lex_state = 406},
  [2545] = {.lex_state = 406, .external_lex_state = 8},
  [2546] = {.lex_state = 405, .external_lex_state = 8},
  [2547] = {.lex_state = 406},
  [2548] = {.lex_state = 405, .external_lex_state = 8},
  [2549] = {.lex_state = 405, .external_lex_state = 8},
  [2550] = {.lex_state = 441},
  [2551] = {.lex_state = 405, .external_lex_state = 8},
  [2552] = {.lex_state = 405, .external_lex_state = 8},
  [2553] = {.lex_state = 405, .external_lex_state = 8},
  [2554] = {.lex_state = 406},
  [2555] = {.lex_state = 405, .external_lex_state = 8},
  [2556] = {.lex_state = 405, .external_lex_state = 8},
  [2557] = {.lex_state = 405, .external_lex_state = 8},
  [2558] = {.lex_state = 405, .external_lex_state = 8},
  [2559] = {.lex_state = 405, .external_lex_state = 8},
  [2560] = {.lex_state = 406},
  [2561] = {.lex_state = 406},
  [2562] = {.lex_state = 406},
  [2563] = {.lex_state = 406},
  [2564] = {.lex_state = 405, .external_lex_state = 8},
  [2565] = {.lex_state = 406},
  [2566] = {.lex_state = 406},
  [2567] = {.lex_state = 406},
  [2568] = {.lex_state = 406},
  [2569] = {.lex_state = 406},
  [2570] = {.lex_state = 405, .external_lex_state = 8},
  [2571] = {.lex_state = 405, .external_lex_state = 8},
  [2572] = {.lex_state = 405, .external_lex_state = 8},
  [2573] = {.lex_state = 405, .external_lex_state = 8},
  [2574] = {.lex_state = 406},
  [2575] = {.lex_state = 406},
  [2576] = {.lex_state = 406},
  [2577] = {.lex_state = 406},
  [2578] = {.lex_state = 405, .external_lex_state = 8},
  [2579] = {.lex_state = 405, .external_lex_state = 8},
  [2580] = {.lex_state = 405, .external_lex_state = 8},
  [2581] = {.lex_state = 405, .external_lex_state = 8},
  [2582] = {.lex_state = 406},
  [2583] = {.lex_state = 406},
  [2584] = {.lex_state = 406},
  [2585] = {.lex_state = 406},
  [2586] = {.lex_state = 405, .external_lex_state = 8},
  [2587] = {.lex_state = 406},
  [2588] = {.lex_state = 405, .external_lex_state = 8},
  [2589] = {.lex_state = 406, .external_lex_state = 8},
  [2590] = {.lex_state = 405, .external_lex_state = 8},
  [2591] = {.lex_state = 406},
  [2592] = {.lex_state = 406},
  [2593] = {.lex_state = 406},
  [2594] = {.lex_state = 406},
  [2595] = {.lex_state = 405, .external_lex_state = 8},
  [2596] = {.lex_state = 406},
  [2597] = {.lex_state = 415, .external_lex_state = 9},
  [2598] = {.lex_state = 408},
  [2599] = {.lex_state = 406, .external_lex_state = 8},
  [2600] = {.lex_state = 406, .external_lex_state = 8},
  [2601] = {.lex_state = 406, .external_lex_state = 8},
  [2602] = {.lex_state = 406, .external_lex_state = 8},
  [2603] = {.lex_state = 406, .external_lex_state = 8},
  [2604] = {.lex_state = 415},
  [2605] = {.lex_state = 408},
  [2606] = {.lex_state = 406, .external_lex_state = 8},
  [2607] = {.lex_state = 406, .external_lex_state = 8},
  [2608] = {.lex_state = 406, .external_lex_state = 8},
  [2609] = {.lex_state = 408},
  [2610] = {.lex_state = 408},
  [2611] = {.lex_state = 405},
  [2612] = {.lex_state = 415, .external_lex_state = 10},
  [2613] = {.lex_state = 406, .external_lex_state = 8},
  [2614] = {.lex_state = 406, .external_lex_state = 8},
  [2615] = {.lex_state = 415},
  [2616] = {.lex_state = 406, .external_lex_state = 8},
  [2617] = {.lex_state = 408},
  [2618] = {.lex_state = 406, .external_lex_state = 8},
  [2619] = {.lex_state = 406, .external_lex_state = 8},
  [2620] = {.lex_state = 406, .external_lex_state = 8},
  [2621] = {.lex_state = 406, .external_lex_state = 8},
  [2622] = {.lex_state = 406, .external_lex_state = 8},
  [2623] = {.lex_state = 415},
  [2624] = {.lex_state = 406, .external_lex_state = 8},
  [2625] = {.lex_state = 406, .external_lex_state = 8},
  [2626] = {.lex_state = 415},
  [2627] = {.lex_state = 405},
  [2628] = {.lex_state = 405},
  [2629] = {.lex_state = 406, .external_lex_state = 8},
  [2630] = {.lex_state = 406, .external_lex_state = 8},
  [2631] = {.lex_state = 406, .external_lex_state = 8},
  [2632] = {.lex_state = 406, .external_lex_state = 8},
  [2633] = {.lex_state = 406, .external_lex_state = 8},
  [2634] = {.lex_state = 406, .external_lex_state = 8},
  [2635] = {.lex_state = 406, .external_lex_state = 8},
  [2636] = {.lex_state = 408},
  [2637] = {.lex_state = 406, .external_lex_state = 8},
  [2638] = {.lex_state = 406, .external_lex_state = 8},
  [2639] = {.lex_state = 406, .external_lex_state = 8},
  [2640] = {.lex_state = 406, .external_lex_state = 8},
  [2641] = {.lex_state = 406, .external_lex_state = 8},
  [2642] = {.lex_state = 406, .external_lex_state = 8},
  [2643] = {.lex_state = 406, .external_lex_state = 8},
  [2644] = {.lex_state = 406, .external_lex_state = 8},
  [2645] = {.lex_state = 406, .external_lex_state = 8},
  [2646] = {.lex_state = 406, .external_lex_state = 8},
  [2647] = {.lex_state = 406, .external_lex_state = 8},
  [2648] = {.lex_state = 406, .external_lex_state = 8},
  [2649] = {.lex_state = 405},
  [2650] = {.lex_state = 406, .external_lex_state = 8},
  [2651] = {.lex_state = 406, .external_lex_state = 8},
  [2652] = {.lex_state = 406, .external_lex_state = 8},
  [2653] = {.lex_state = 406, .external_lex_state = 8},
  [2654] = {.lex_state = 402},
  [2655] = {.lex_state = 415},
  [2656] = {.lex_state = 415},
  [2657] = {.lex_state = 408},
  [2658] = {.lex_state = 415},
  [2659] = {.lex_state = 415},
  [2660] = {.lex_state = 415},
  [2661] = {.lex_state = 406, .external_lex_state = 8},
  [2662] = {.lex_state = 415},
  [2663] = {.lex_state = 406, .external_lex_state = 7},
  [2664] = {.lex_state = 415},
  [2665] = {.lex_state = 406, .external_lex_state = 8},
  [2666] = {.lex_state = 406, .external_lex_state = 8},
  [2667] = {.lex_state = 408},
  [2668] = {.lex_state = 415},
  [2669] = {.lex_state = 406, .external_lex_state = 8},
  [2670] = {.lex_state = 406, .external_lex_state = 7},
  [2671] = {.lex_state = 415},
  [2672] = {.lex_state = 415},
  [2673] = {.lex_state = 415},
  [2674] = {.lex_state = 406, .external_lex_state = 8},
  [2675] = {.lex_state = 408},
  [2676] = {.lex_state = 406, .external_lex_state = 8},
  [2677] = {.lex_state = 406, .external_lex_state = 8},
  [2678] = {.lex_state = 406, .external_lex_state = 8},
  [2679] = {.lex_state = 406, .external_lex_state = 8},
  [2680] = {.lex_state = 406, .external_lex_state = 8},
  [2681] = {.lex_state = 406, .external_lex_state = 8},
  [2682] = {.lex_state = 408},
  [2683] = {.lex_state = 406, .external_lex_state = 8},
  [2684] = {.lex_state = 406, .external_lex_state = 7},
  [2685] = {.lex_state = 415},
  [2686] = {.lex_state = 408},
  [2687] = {.lex_state = 406, .external_lex_state = 8},
  [2688] = {.lex_state = 415},
  [2689] = {.lex_state = 406, .external_lex_state = 8},
  [2690] = {.lex_state = 415},
  [2691] = {.lex_state = 408},
  [2692] = {.lex_state = 408},
  [2693] = {.lex_state = 405},
  [2694] = {.lex_state = 405},
  [2695] = {.lex_state = 405},
  [2696] = {.lex_state = 406, .external_lex_state = 8},
  [2697] = {.lex_state = 406, .external_lex_state = 8},
  [2698] = {.lex_state = 406, .external_lex_state = 8},
  [2699] = {.lex_state = 406, .external_lex_state = 7},
  [2700] = {.lex_state = 406, .external_lex_state = 8},
  [2701] = {.lex_state = 406, .external_lex_state = 7},
  [2702] = {.lex_state = 408},
  [2703] = {.lex_state = 408},
  [2704] = {.lex_state = 408},
  [2705] = {.lex_state = 408},
  [2706] = {.lex_state = 441},
  [2707] = {.lex_state = 408},
  [2708] = {.lex_state = 408},
  [2709] = {.lex_state = 408},
  [2710] = {.lex_state = 405},
  [2711] = {.lex_state = 408},
  [2712] = {.lex_state = 408},
  [2713] = {.lex_state = 408},
  [2714] = {.lex_state = 408},
  [2715] = {.lex_state = 405},
  [2716] = {.lex_state = 408},
  [2717] = {.lex_state = 408},
  [2718] = {.lex_state = 408},
  [2719] = {.lex_state = 405},
  [2720] = {.lex_state = 408},
  [2721] = {.lex_state = 408},
  [2722] = {.lex_state = 408},
  [2723] = {.lex_state = 408},
  [2724] = {.lex_state = 408},
  [2725] = {.lex_state = 441},
  [2726] = {.lex_state = 408},
  [2727] = {.lex_state = 408},
  [2728] = {.lex_state = 408},
  [2729] = {.lex_state = 408},
  [2730] = {.lex_state = 408},
  [2731] = {.lex_state = 408},
  [2732] = {.lex_state = 408},
  [2733] = {.lex_state = 408},
  [2734] = {.lex_state = 408},
  [2735] = {.lex_state = 405},
  [2736] = {.lex_state = 408},
  [2737] = {.lex_state = 408},
  [2738] = {.lex_state = 406, .external_lex_state = 7},
  [2739] = {.lex_state = 406, .external_lex_state = 7},
  [2740] = {.lex_state = 408},
  [2741] = {.lex_state = 408},
  [2742] = {.lex_state = 405},
  [2743] = {.lex_state = 405},
  [2744] = {.lex_state = 406, .external_lex_state = 7},
  [2745] = {.lex_state = 406, .external_lex_state = 7},
  [2746] = {.lex_state = 405},
  [2747] = {.lex_state = 415},
  [2748] = {.lex_state = 406, .external_lex_state = 7},
  [2749] = {.lex_state = 406, .external_lex_state = 7},
  [2750] = {.lex_state = 408},
  [2751] = {.lex_state = 406, .external_lex_state = 7},
  [2752] = {.lex_state = 408},
  [2753] = {.lex_state = 408},
  [2754] = {.lex_state = 408},
  [2755] = {.lex_state = 408},
  [2756] = {.lex_state = 441},
  [2757] = {.lex_state = 408},
  [2758] = {.lex_state = 410},
  [2759] = {.lex_state = 408},
  [2760] = {.lex_state = 408},
  [2761] = {.lex_state = 410},
  [2762] = {.lex_state = 441},
  [2763] = {.lex_state = 408},
  [2764] = {.lex_state = 408},
  [2765] = {.lex_state = 408},
  [2766] = {.lex_state = 408},
  [2767] = {.lex_state = 410},
  [2768] = {.lex_state = 408},
  [2769] = {.lex_state = 405},
  [2770] = {.lex_state = 408},
  [2771] = {.lex_state = 405},
  [2772] = {.lex_state = 408},
  [2773] = {.lex_state = 406, .external_lex_state = 7},
  [2774] = {.lex_state = 410},
  [2775] = {.lex_state = 408},
  [2776] = {.lex_state = 408},
  [2777] = {.lex_state = 408},
  [2778] = {.lex_state = 405},
  [2779] = {.lex_state = 405},
  [2780] = {.lex_state = 410},
  [2781] = {.lex_state = 410},
  [2782] = {.lex_state = 405},
  [2783] = {.lex_state = 406, .external_lex_state = 7},
  [2784] = {.lex_state = 441},
  [2785] = {.lex_state = 441},
  [2786] = {.lex_state = 406, .external_lex_state = 7},
  [2787] = {.lex_state = 406, .external_lex_state = 7},
  [2788] = {.lex_state = 410},
  [2789] = {.lex_state = 406, .external_lex_state = 10},
  [2790] = {.lex_state = 410},
  [2791] = {.lex_state = 405},
  [2792] = {.lex_state = 410},
  [2793] = {.lex_state = 410},
  [2794] = {.lex_state = 410},
  [2795] = {.lex_state = 410},
  [2796] = {.lex_state = 406, .external_lex_state = 7},
  [2797] = {.lex_state = 406, .external_lex_state = 7},
  [2798] = {.lex_state = 405},
  [2799] = {.lex_state = 406, .external_lex_state = 7},
  [2800] = {.lex_state = 405},
  [2801] = {.lex_state = 406, .external_lex_state = 7},
  [2802] = {.lex_state = 406, .external_lex_state = 7},
  [2803] = {.lex_state = 406, .external_lex_state = 7},
  [2804] = {.lex_state = 406, .external_lex_state = 7},
  [2805] = {.lex_state = 406, .external_lex_state = 7},
  [2806] = {.lex_state = 406, .external_lex_state = 7},
  [2807] = {.lex_state = 405},
  [2808] = {.lex_state = 406, .external_lex_state = 7},
  [2809] = {.lex_state = 406, .external_lex_state = 7},
  [2810] = {.lex_state = 406, .external_lex_state = 7},
  [2811] = {.lex_state = 405},
  [2812] = {.lex_state = 406, .external_lex_state = 10},
  [2813] = {.lex_state = 405},
  [2814] = {.lex_state = 405},
  [2815] = {.lex_state = 410},
  [2816] = {.lex_state = 405},
  [2817] = {.lex_state = 406, .external_lex_state = 7},
  [2818] = {.lex_state = 406, .external_lex_state = 7},
  [2819] = {.lex_state = 405},
  [2820] = {.lex_state = 405},
  [2821] = {.lex_state = 406, .external_lex_state = 10},
  [2822] = {.lex_state = 405},
  [2823] = {.lex_state = 405},
  [2824] = {.lex_state = 405},
  [2825] = {.lex_state = 441},
  [2826] = {.lex_state = 405},
  [2827] = {.lex_state = 405},
  [2828] = {.lex_state = 441},
  [2829] = {.lex_state = 405},
  [2830] = {.lex_state = 406, .external_lex_state = 7},
  [2831] = {.lex_state = 405},
  [2832] = {.lex_state = 405},
  [2833] = {.lex_state = 406, .external_lex_state = 9},
  [2834] = {.lex_state = 406, .external_lex_state = 10},
  [2835] = {.lex_state = 405},
  [2836] = {.lex_state = 405},
  [2837] = {.lex_state = 406, .external_lex_state = 7},
  [2838] = {.lex_state = 406, .external_lex_state = 7},
  [2839] = {.lex_state = 405},
  [2840] = {.lex_state = 405},
  [2841] = {.lex_state = 406, .external_lex_state = 7},
  [2842] = {.lex_state = 405},
  [2843] = {.lex_state = 406, .external_lex_state = 7},
  [2844] = {.lex_state = 406, .external_lex_state = 7},
  [2845] = {.lex_state = 405},
  [2846] = {.lex_state = 405},
  [2847] = {.lex_state = 405},
  [2848] = {.lex_state = 405},
  [2849] = {.lex_state = 406, .external_lex_state = 7},
  [2850] = {.lex_state = 405},
  [2851] = {.lex_state = 405},
  [2852] = {.lex_state = 405},
  [2853] = {.lex_state = 405},
  [2854] = {.lex_state = 405},
  [2855] = {.lex_state = 405},
  [2856] = {.lex_state = 405},
  [2857] = {.lex_state = 405},
  [2858] = {.lex_state = 406, .external_lex_state = 7},
  [2859] = {.lex_state = 405},
  [2860] = {.lex_state = 405},
  [2861] = {.lex_state = 405},
  [2862] = {.lex_state = 405},
  [2863] = {.lex_state = 406, .external_lex_state = 7},
  [2864] = {.lex_state = 406, .external_lex_state = 7},
  [2865] = {.lex_state = 405},
  [2866] = {.lex_state = 405},
  [2867] = {.lex_state = 405},
  [2868] = {.lex_state = 441},
  [2869] = {.lex_state = 441},
  [2870] = {.lex_state = 406, .external_lex_state = 7},
  [2871] = {.lex_state = 406, .external_lex_state = 7},
  [2872] = {.lex_state = 406, .external_lex_state = 7},
  [2873] = {.lex_state = 406, .external_lex_state = 9},
  [2874] = {.lex_state = 441},
  [2875] = {.lex_state = 441},
  [2876] = {.lex_state = 441},
  [2877] = {.lex_state = 405},
  [2878] = {.lex_state = 406, .external_lex_state = 7},
  [2879] = {.lex_state = 406, .external_lex_state = 7},
  [2880] = {.lex_state = 406, .external_lex_state = 7},
  [2881] = {.lex_state = 406, .external_lex_state = 7},
  [2882] = {.lex_state = 406, .external_lex_state = 7},
  [2883] = {.lex_state = 406, .external_lex_state = 7},
  [2884] = {.lex_state = 406, .external_lex_state = 7},
  [2885] = {.lex_state = 406, .external_lex_state = 7},
  [2886] = {.lex_state = 406, .external_lex_state = 7},
  [2887] = {.lex_state = 406, .external_lex_state = 7},
  [2888] = {.lex_state = 406, .external_lex_state = 7},
  [2889] = {.lex_state = 406, .external_lex_state = 7},
  [2890] = {.lex_state = 406, .external_lex_state = 7},
  [2891] = {.lex_state = 406, .external_lex_state = 9},
  [2892] = {.lex_state = 406, .external_lex_state = 9},
  [2893] = {.lex_state = 406, .external_lex_state = 7},
  [2894] = {.lex_state = 405},
  [2895] = {.lex_state = 406, .external_lex_state = 7},
  [2896] = {.lex_state = 406, .external_lex_state = 7},
  [2897] = {.lex_state = 406, .external_lex_state = 7},
  [2898] = {.lex_state = 406, .external_lex_state = 7},
  [2899] = {.lex_state = 405},
  [2900] = {.lex_state = 406, .external_lex_state = 7},
  [2901] = {.lex_state = 406, .external_lex_state = 7},
  [2902] = {.lex_state = 405},
  [2903] = {.lex_state = 405},
  [2904] = {.lex_state = 405},
  [2905] = {.lex_state = 441},
  [2906] = {.lex_state = 441},
  [2907] = {.lex_state = 406, .external_lex_state = 9},
  [2908] = {.lex_state = 406, .external_lex_state = 9},
  [2909] = {.lex_state = 406, .external_lex_state = 10},
  [2910] = {.lex_state = 406, .external_lex_state = 10},
  [2911] = {.lex_state = 406, .external_lex_state = 9},
  [2912] = {.lex_state = 406, .external_lex_state = 9},
  [2913] = {.lex_state = 406, .external_lex_state = 9},
  [2914] = {.lex_state = 406, .external_lex_state = 9},
  [2915] = {.lex_state = 406, .external_lex_state = 9},
  [2916] = {.lex_state = 406, .external_lex_state = 9},
  [2917] = {.lex_state = 401},
  [2918] = {.lex_state = 406, .external_lex_state = 9},
  [2919] = {.lex_state = 406, .external_lex_state = 10},
  [2920] = {.lex_state = 406, .external_lex_state = 10},
  [2921] = {.lex_state = 406, .external_lex_state = 10},
  [2922] = {.lex_state = 406, .external_lex_state = 10},
  [2923] = {.lex_state = 406, .external_lex_state = 10},
  [2924] = {.lex_state = 406, .external_lex_state = 10},
  [2925] = {.lex_state = 406, .external_lex_state = 10},
  [2926] = {.lex_state = 410},
  [2927] = {.lex_state = 410},
  [2928] = {.lex_state = 410},
  [2929] = {.lex_state = 410},
  [2930] = {.lex_state = 410},
  [2931] = {.lex_state = 416},
  [2932] = {.lex_state = 410},
  [2933] = {.lex_state = 410},
  [2934] = {.lex_state = 410},
  [2935] = {.lex_state = 410},
  [2936] = {.lex_state = 410},
  [2937] = {.lex_state = 410},
  [2938] = {.lex_state = 410},
  [2939] = {.lex_state = 410},
  [2940] = {.lex_state = 410},
  [2941] = {.lex_state = 410},
  [2942] = {.lex_state = 410},
  [2943] = {.lex_state = 410},
  [2944] = {.lex_state = 441},
  [2945] = {.lex_state = 441},
  [2946] = {.lex_state = 441},
  [2947] = {.lex_state = 441},
  [2948] = {.lex_state = 441},
  [2949] = {.lex_state = 410},
  [2950] = {.lex_state = 410},
  [2951] = {.lex_state = 410},
  [2952] = {.lex_state = 410},
  [2953] = {.lex_state = 410},
  [2954] = {.lex_state = 410},
  [2955] = {.lex_state = 410},
  [2956] = {.lex_state = 410},
  [2957] = {.lex_state = 410},
  [2958] = {.lex_state = 410},
  [2959] = {.lex_state = 441},
  [2960] = {.lex_state = 410},
  [2961] = {.lex_state = 410},
  [2962] = {.lex_state = 441},
  [2963] = {.lex_state = 441},
  [2964] = {.lex_state = 441},
  [2965] = {.lex_state = 441},
  [2966] = {.lex_state = 441},
  [2967] = {.lex_state = 410},
  [2968] = {.lex_state = 410},
  [2969] = {.lex_state = 410},
  [2970] = {.lex_state = 441},
  [2971] = {.lex_state = 441},
  [2972] = {.lex_state = 441},
  [2973] = {.lex_state = 410},
  [2974] = {.lex_state = 410},
  [2975] = {.lex_state = 410},
  [2976] = {.lex_state = 410},
  [2977] = {.lex_state = 410},
  [2978] = {.lex_state = 441},
  [2979] = {.lex_state = 441},
  [2980] = {.lex_state = 410},
  [2981] = {.lex_state = 410},
  [2982] = {.lex_state = 410},
  [2983] = {.lex_state = 410},
  [2984] = {.lex_state = 410},
  [2985] = {.lex_state = 410},
  [2986] = {.lex_state = 410},
  [2987] = {.lex_state = 441},
  [2988] = {.lex_state = 410},
  [2989] = {.lex_state = 410},
  [2990] = {.lex_state = 410},
  [2991] = {.lex_state = 410},
  [2992] = {.lex_state = 410},
  [2993] = {.lex_state = 410},
  [2994] = {.lex_state = 441},
  [2995] = {.lex_state = 441},
  [2996] = {.lex_state = 441},
  [2997] = {.lex_state = 441},
  [2998] = {.lex_state = 441},
  [2999] = {.lex_state = 441},
  [3000] = {.lex_state = 441},
  [3001] = {.lex_state = 441},
  [3002] = {.lex_state = 441},
  [3003] = {.lex_state = 441},
  [3004] = {.lex_state = 441},
  [3005] = {.lex_state = 441},
  [3006] = {.lex_state = 441},
  [3007] = {.lex_state = 441},
  [3008] = {.lex_state = 441},
  [3009] = {.lex_state = 441},
  [3010] = {.lex_state = 441},
  [3011] = {.lex_state = 441},
  [3012] = {.lex_state = 441},
  [3013] = {.lex_state = 441},
  [3014] = {.lex_state = 441},
  [3015] = {.lex_state = 441},
  [3016] = {.lex_state = 441},
  [3017] = {.lex_state = 441},
  [3018] = {.lex_state = 441},
  [3019] = {.lex_state = 441},
  [3020] = {.lex_state = 441},
  [3021] = {.lex_state = 441},
  [3022] = {.lex_state = 441},
  [3023] = {.lex_state = 441},
  [3024] = {.lex_state = 441},
  [3025] = {.lex_state = 406, .external_lex_state = 10},
  [3026] = {.lex_state = 406, .external_lex_state = 10},
  [3027] = {.lex_state = 406, .external_lex_state = 10},
  [3028] = {.lex_state = 406, .external_lex_state = 10},
  [3029] = {.lex_state = 406, .external_lex_state = 10},
  [3030] = {.lex_state = 406, .external_lex_state = 10},
  [3031] = {.lex_state = 406, .external_lex_state = 10},
  [3032] = {.lex_state = 406, .external_lex_state = 10},
  [3033] = {.lex_state = 406, .external_lex_state = 10},
  [3034] = {.lex_state = 406, .external_lex_state = 10},
  [3035] = {.lex_state = 406, .external_lex_state = 10},
  [3036] = {.lex_state = 406, .external_lex_state = 10},
  [3037] = {.lex_state = 406, .external_lex_state = 9},
  [3038] = {.lex_state = 406, .external_lex_state = 9},
  [3039] = {.lex_state = 406, .external_lex_state = 9},
  [3040] = {.lex_state = 406, .external_lex_state = 9},
  [3041] = {.lex_state = 406, .external_lex_state = 9},
  [3042] = {.lex_state = 406, .external_lex_state = 9},
  [3043] = {.lex_state = 406, .external_lex_state = 9},
  [3044] = {.lex_state = 406, .external_lex_state = 10},
  [3045] = {.lex_state = 406, .external_lex_state = 9},
  [3046] = {.lex_state = 406, .external_lex_state = 9},
  [3047] = {.lex_state = 406, .external_lex_state = 9},
  [3048] = {.lex_state = 406, .external_lex_state = 9},
  [3049] = {.lex_state = 406, .external_lex_state = 9},
  [3050] = {.lex_state = 406, .external_lex_state = 9},
  [3051] = {.lex_state = 406, .external_lex_state = 9},
  [3052] = {.lex_state = 406, .external_lex_state = 9},
  [3053] = {.lex_state = 406, .external_lex_state = 9},
  [3054] = {.lex_state = 406, .external_lex_state = 9},
  [3055] = {.lex_state = 406, .external_lex_state = 9},
  [3056] = {.lex_state = 406, .external_lex_state = 10},
  [3057] = {.lex_state = 406, .external_lex_state = 10},
  [3058] = {.lex_state = 406, .external_lex_state = 10},
  [3059] = {.lex_state = 406, .external_lex_state = 10},
  [3060] = {.lex_state = 406, .external_lex_state = 10},
  [3061] = {.lex_state = 406, .external_lex_state = 10},
  [3062] = {.lex_state = 406, .external_lex_state = 9},
  [3063] = {.lex_state = 406, .external_lex_state = 9},
  [3064] = {.lex_state = 406, .external_lex_state = 9},
  [3065] = {.lex_state = 406, .external_lex_state = 9},
  [3066] = {.lex_state = 406, .external_lex_state = 9},
  [3067] = {.lex_state = 406, .external_lex_state = 9},
  [3068] = {.lex_state = 406, .external_lex_state = 9},
  [3069] = {.lex_state = 406, .external_lex_state = 9},
  [3070] = {.lex_state = 406, .external_lex_state = 9},
  [3071] = {.lex_state = 406, .external_lex_state = 9},
  [3072] = {.lex_state = 406, .external_lex_state = 10},
  [3073] = {.lex_state = 406, .external_lex_state = 9},
  [3074] = {.lex_state = 406, .external_lex_state = 10},
  [3075] = {.lex_state = 406, .external_lex_state = 10},
  [3076] = {.lex_state = 406, .external_lex_state = 10},
  [3077] = {.lex_state = 406, .external_lex_state = 9},
  [3078] = {.lex_state = 406, .external_lex_state = 9},
  [3079] = {.lex_state = 406, .external_lex_state = 9},
  [3080] = {.lex_state = 406, .external_lex_state = 10},
  [3081] = {.lex_state = 406, .external_lex_state = 10},
  [3082] = {.lex_state = 406, .external_lex_state = 10},
  [3083] = {.lex_state = 406, .external_lex_state = 10},
  [3084] = {.lex_state = 406, .external_lex_state = 10},
  [3085] = {.lex_state = 406, .external_lex_state = 10},
  [3086] = {.lex_state = 406, .external_lex_state = 10},
  [3087] = {.lex_state = 406, .external_lex_state = 10},
  [3088] = {.lex_state = 406, .external_lex_state = 10},
  [3089] = {.lex_state = 406, .external_lex_state = 10},
  [3090] = {.lex_state = 406, .external_lex_state = 9},
  [3091] = {.lex_state = 406, .external_lex_state = 10},
  [3092] = {.lex_state = 406, .external_lex_state = 10},
  [3093] = {.lex_state = 406, .external_lex_state = 10},
  [3094] = {.lex_state = 406, .external_lex_state = 10},
  [3095] = {.lex_state = 406, .external_lex_state = 10},
  [3096] = {.lex_state = 406, .external_lex_state = 10},
  [3097] = {.lex_state = 406, .external_lex_state = 10},
  [3098] = {.lex_state = 406, .external_lex_state = 10},
  [3099] = {.lex_state = 406, .external_lex_state = 10},
  [3100] = {.lex_state = 406, .external_lex_state = 10},
  [3101] = {.lex_state = 406, .external_lex_state = 10},
  [3102] = {.lex_state = 406, .external_lex_state = 9},
  [3103] = {.lex_state = 406, .external_lex_state = 9},
  [3104] = {.lex_state = 406, .external_lex_state = 9},
  [3105] = {.lex_state = 406, .external_lex_state = 9},
  [3106] = {.lex_state = 406, .external_lex_state = 9},
  [3107] = {.lex_state = 406, .external_lex_state = 10},
  [3108] = {.lex_state = 406, .external_lex_state = 10},
  [3109] = {.lex_state = 406, .external_lex_state = 10},
  [3110] = {.lex_state = 406, .external_lex_state = 9},
  [3111] = {.lex_state = 406, .external_lex_state = 9},
  [3112] = {.lex_state = 406, .external_lex_state = 9},
  [3113] = {.lex_state = 406, .external_lex_state = 9},
  [3114] = {.lex_state = 406, .external_lex_state = 9},
  [3115] = {.lex_state = 406, .external_lex_state = 9},
  [3116] = {.lex_state = 406, .external_lex_state = 9},
  [3117] = {.lex_state = 406, .external_lex_state = 9},
  [3118] = {.lex_state = 406, .external_lex_state = 10},
  [3119] = {.lex_state = 406, .external_lex_state = 9},
  [3120] = {.lex_state = 406, .external_lex_state = 10},
  [3121] = {.lex_state = 406, .external_lex_state = 10},
  [3122] = {.lex_state = 406, .external_lex_state = 9},
  [3123] = {.lex_state = 406, .external_lex_state = 9},
  [3124] = {.lex_state = 406, .external_lex_state = 9},
  [3125] = {.lex_state = 417},
  [3126] = {.lex_state = 417},
  [3127] = {.lex_state = 419},
  [3128] = {.lex_state = 419},
  [3129] = {.lex_state = 419},
  [3130] = {.lex_state = 419},
  [3131] = {.lex_state = 419},
  [3132] = {.lex_state = 419},
  [3133] = {.lex_state = 419},
  [3134] = {.lex_state = 419, .external_lex_state = 6},
  [3135] = {.lex_state = 419, .external_lex_state = 6},
  [3136] = {.lex_state = 419},
  [3137] = {.lex_state = 419, .external_lex_state = 6},
  [3138] = {.lex_state = 419},
  [3139] = {.lex_state = 421},
  [3140] = {.lex_state = 419},
  [3141] = {.lex_state = 421},
  [3142] = {.lex_state = 421},
  [3143] = {.lex_state = 419},
  [3144] = {.lex_state = 419},
  [3145] = {.lex_state = 419},
  [3146] = {.lex_state = 419},
  [3147] = {.lex_state = 419},
  [3148] = {.lex_state = 419},
  [3149] = {.lex_state = 419},
  [3150] = {.lex_state = 419},
  [3151] = {.lex_state = 419},
  [3152] = {.lex_state = 419},
  [3153] = {.lex_state = 419},
  [3154] = {.lex_state = 419},
  [3155] = {.lex_state = 419},
  [3156] = {.lex_state = 419},
  [3157] = {.lex_state = 419},
  [3158] = {.lex_state = 419},
  [3159] = {.lex_state = 419},
  [3160] = {.lex_state = 419},
  [3161] = {.lex_state = 419},
  [3162] = {.lex_state = 419},
  [3163] = {.lex_state = 419},
  [3164] = {.lex_state = 419},
  [3165] = {.lex_state = 419},
  [3166] = {.lex_state = 419},
  [3167] = {.lex_state = 419},
  [3168] = {.lex_state = 421},
  [3169] = {.lex_state = 419},
  [3170] = {.lex_state = 419},
  [3171] = {.lex_state = 419},
  [3172] = {.lex_state = 419},
  [3173] = {.lex_state = 419},
  [3174] = {.lex_state = 419},
  [3175] = {.lex_state = 419},
  [3176] = {.lex_state = 419},
  [3177] = {.lex_state = 419},
  [3178] = {.lex_state = 421},
  [3179] = {.lex_state = 419},
  [3180] = {.lex_state = 421},
  [3181] = {.lex_state = 419},
  [3182] = {.lex_state = 419},
  [3183] = {.lex_state = 419},
  [3184] = {.lex_state = 419},
  [3185] = {.lex_state = 419},
  [3186] = {.lex_state = 419},
  [3187] = {.lex_state = 419},
  [3188] = {.lex_state = 419},
  [3189] = {.lex_state = 419},
  [3190] = {.lex_state = 419},
  [3191] = {.lex_state = 419},
  [3192] = {.lex_state = 419},
  [3193] = {.lex_state = 419},
  [3194] = {.lex_state = 419},
  [3195] = {.lex_state = 419},
  [3196] = {.lex_state = 419},
  [3197] = {.lex_state = 419},
  [3198] = {.lex_state = 419},
  [3199] = {.lex_state = 419},
  [3200] = {.lex_state = 419},
  [3201] = {.lex_state = 419},
  [3202] = {.lex_state = 419},
  [3203] = {.lex_state = 419},
  [3204] = {.lex_state = 419},
  [3205] = {.lex_state = 419},
  [3206] = {.lex_state = 419},
  [3207] = {.lex_state = 419},
  [3208] = {.lex_state = 419},
  [3209] = {.lex_state = 419},
  [3210] = {.lex_state = 419},
  [3211] = {.lex_state = 419},
  [3212] = {.lex_state = 419},
  [3213] = {.lex_state = 419},
  [3214] = {.lex_state = 419},
  [3215] = {.lex_state = 419},
  [3216] = {.lex_state = 419},
  [3217] = {.lex_state = 419},
  [3218] = {.lex_state = 419},
  [3219] = {.lex_state = 419},
  [3220] = {.lex_state = 419},
  [3221] = {.lex_state = 419},
  [3222] = {.lex_state = 419},
  [3223] = {.lex_state = 419},
  [3224] = {.lex_state = 419},
  [3225] = {.lex_state = 419},
  [3226] = {.lex_state = 419},
  [3227] = {.lex_state = 419},
  [3228] = {.lex_state = 419},
  [3229] = {.lex_state = 419},
  [3230] = {.lex_state = 419},
  [3231] = {.lex_state = 419},
  [3232] = {.lex_state = 419},
  [3233] = {.lex_state = 419},
  [3234] = {.lex_state = 422},
  [3235] = {.lex_state = 419},
  [3236] = {.lex_state = 419},
  [3237] = {.lex_state = 419},
  [3238] = {.lex_state = 419},
  [3239] = {.lex_state = 423},
  [3240] = {.lex_state = 419},
  [3241] = {.lex_state = 419},
  [3242] = {.lex_state = 419},
  [3243] = {.lex_state = 419},
  [3244] = {.lex_state = 419},
  [3245] = {.lex_state = 419},
  [3246] = {.lex_state = 419},
  [3247] = {.lex_state = 419},
  [3248] = {.lex_state = 419},
  [3249] = {.lex_state = 419},
  [3250] = {.lex_state = 419},
  [3251] = {.lex_state = 419},
  [3252] = {.lex_state = 419},
  [3253] = {.lex_state = 419},
  [3254] = {.lex_state = 424},
  [3255] = {.lex_state = 419},
  [3256] = {.lex_state = 419},
  [3257] = {.lex_state = 419},
  [3258] = {.lex_state = 419},
  [3259] = {.lex_state = 419},
  [3260] = {.lex_state = 419},
  [3261] = {.lex_state = 419},
  [3262] = {.lex_state = 419},
  [3263] = {.lex_state = 419},
  [3264] = {.lex_state = 419},
  [3265] = {.lex_state = 419},
  [3266] = {.lex_state = 419},
  [3267] = {.lex_state = 419},
  [3268] = {.lex_state = 425},
  [3269] = {.lex_state = 425},
  [3270] = {.lex_state = 425},
  [3271] = {.lex_state = 425},
  [3272] = {.lex_state = 425},
  [3273] = {.lex_state = 425},
  [3274] = {.lex_state = 425},
  [3275] = {.lex_state = 425},
  [3276] = {.lex_state = 425},
  [3277] = {.lex_state = 425},
  [3278] = {.lex_state = 425},
  [3279] = {.lex_state = 425},
  [3280] = {.lex_state = 425},
  [3281] = {.lex_state = 425},
  [3282] = {.lex_state = 425},
  [3283] = {.lex_state = 425},
  [3284] = {.lex_state = 425},
  [3285] = {.lex_state = 427},
  [3286] = {.lex_state = 427},
  [3287] = {.lex_state = 427},
  [3288] = {.lex_state = 427},
  [3289] = {.lex_state = 427},
  [3290] = {.lex_state = 427},
  [3291] = {.lex_state = 427},
  [3292] = {.lex_state = 427},
  [3293] = {.lex_state = 428},
  [3294] = {.lex_state = 427},
  [3295] = {.lex_state = 427},
  [3296] = {.lex_state = 427},
  [3297] = {.lex_state = 427},
  [3298] = {.lex_state = 427},
  [3299] = {.lex_state = 427},
  [3300] = {.lex_state = 427},
  [3301] = {.lex_state = 427},
  [3302] = {.lex_state = 429, .external_lex_state = 7},
  [3303] = {.lex_state = 429, .external_lex_state = 7},
  [3304] = {.lex_state = 429, .external_lex_state = 7},
  [3305] = {.lex_state = 429},
  [3306] = {.lex_state = 429},
  [3307] = {.lex_state = 429},
  [3308] = {.lex_state = 429},
  [3309] = {.lex_state = 429},
  [3310] = {.lex_state = 429},
  [3311] = {.lex_state = 429},
  [3312] = {.lex_state = 429},
  [3313] = {.lex_state = 429},
  [3314] = {.lex_state = 429},
  [3315] = {.lex_state = 429},
  [3316] = {.lex_state = 429},
  [3317] = {.lex_state = 425},
  [3318] = {.lex_state = 425},
  [3319] = {.lex_state = 425},
  [3320] = {.lex_state = 425},
  [3321] = {.lex_state = 425},
  [3322] = {.lex_state = 425},
  [3323] = {.lex_state = 425},
  [3324] = {.lex_state = 425},
  [3325] = {.lex_state = 425},
  [3326] = {.lex_state = 425},
  [3327] = {.lex_state = 425},
  [3328] = {.lex_state = 425},
  [3329] = {.lex_state = 425},
  [3330] = {.lex_state = 425},
  [3331] = {.lex_state = 425},
  [3332] = {.lex_state = 425},
  [3333] = {.lex_state = 425},
  [3334] = {.lex_state = 425},
  [3335] = {.lex_state = 425},
  [3336] = {.lex_state = 425},
  [3337] = {.lex_state = 425},
  [3338] = {.lex_state = 425},
  [3339] = {.lex_state = 425},
  [3340] = {.lex_state = 425},
  [3341] = {.lex_state = 429, .external_lex_state = 7},
  [3342] = {.lex_state = 425},
  [3343] = {.lex_state = 425},
  [3344] = {.lex_state = 425},
  [3345] = {.lex_state = 425},
  [3346] = {.lex_state = 425},
  [3347] = {.lex_state = 425},
  [3348] = {.lex_state = 425},
  [3349] = {.lex_state = 425},
  [3350] = {.lex_state = 425},
  [3351] = {.lex_state = 425},
  [3352] = {.lex_state = 425},
  [3353] = {.lex_state = 425},
  [3354] = {.lex_state = 425},
  [3355] = {.lex_state = 425},
  [3356] = {.lex_state = 425},
  [3357] = {.lex_state = 425},
  [3358] = {.lex_state = 425},
  [3359] = {.lex_state = 425},
  [3360] = {.lex_state = 425},
  [3361] = {.lex_state = 425},
  [3362] = {.lex_state = 425},
  [3363] = {.lex_state = 425},
  [3364] = {.lex_state = 425},
  [3365] = {.lex_state = 425},
  [3366] = {.lex_state = 425},
  [3367] = {.lex_state = 425},
  [3368] = {.lex_state = 425},
  [3369] = {.lex_state = 425},
  [3370] = {.lex_state = 425},
  [3371] = {.lex_state = 425},
  [3372] = {.lex_state = 425},
  [3373] = {.lex_state = 425},
  [3374] = {.lex_state = 425},
  [3375] = {.lex_state = 425},
  [3376] = {.lex_state = 425},
  [3377] = {.lex_state = 425},
  [3378] = {.lex_state = 425},
  [3379] = {.lex_state = 425},
  [3380] = {.lex_state = 425},
  [3381] = {.lex_state = 425},
  [3382] = {.lex_state = 429, .external_lex_state = 7},
  [3383] = {.lex_state = 429, .external_lex_state = 7},
  [3384] = {.lex_state = 429, .external_lex_state = 7},
  [3385] = {.lex_state = 425},
  [3386] = {.lex_state = 429, .external_lex_state = 7},
  [3387] = {.lex_state = 429, .external_lex_state = 7},
  [3388] = {.lex_state = 429, .external_lex_state = 7},
  [3389] = {.lex_state = 429, .external_lex_state = 7},
  [3390] = {.lex_state = 429, .external_lex_state = 7},
  [3391] = {.lex_state = 429, .external_lex_state = 7},
  [3392] = {.lex_state = 429, .external_lex_state = 7},
  [3393] = {.lex_state = 429, .external_lex_state = 7},
  [3394] = {.lex_state = 429, .external_lex_state = 7},
  [3395] = {.lex_state = 429, .external_lex_state = 7},
  [3396] = {.lex_state = 429, .external_lex_state = 7},
  [3397] = {.lex_state = 425},
  [3398] = {.lex_state = 429, .external_lex_state = 7},
  [3399] = {.lex_state = 429, .external_lex_state = 7},
  [3400] = {.lex_state = 429, .external_lex_state = 7},
  [3401] = {.lex_state = 429, .external_lex_state = 7},
  [3402] = {.lex_state = 429, .external_lex_state = 7},
  [3403] = {.lex_state = 429, .external_lex_state = 7},
  [3404] = {.lex_state = 429, .external_lex_state = 7},
  [3405] = {.lex_state = 429, .external_lex_state = 7},
  [3406] = {.lex_state = 425},
  [3407] = {.lex_state = 429, .external_lex_state = 7},
  [3408] = {.lex_state = 429, .external_lex_state = 7},
  [3409] = {.lex_state = 429, .external_lex_state = 7},
  [3410] = {.lex_state = 429, .external_lex_state = 7},
  [3411] = {.lex_state = 429, .external_lex_state = 7},
  [3412] = {.lex_state = 429, .external_lex_state = 7},
  [3413] = {.lex_state = 429, .external_lex_state = 7},
  [3414] = {.lex_state = 429, .external_lex_state = 7},
  [3415] = {.lex_state = 429, .external_lex_state = 7},
  [3416] = {.lex_state = 429, .external_lex_state = 7},
  [3417] = {.lex_state = 429, .external_lex_state = 7},
  [3418] = {.lex_state = 429, .external_lex_state = 7},
  [3419] = {.lex_state = 429, .external_lex_state = 7},
  [3420] = {.lex_state = 429, .external_lex_state = 7},
  [3421] = {.lex_state = 425},
  [3422] = {.lex_state = 429, .external_lex_state = 7},
  [3423] = {.lex_state = 429, .external_lex_state = 7},
  [3424] = {.lex_state = 429, .external_lex_state = 7},
  [3425] = {.lex_state = 429, .external_lex_state = 7},
  [3426] = {.lex_state = 429, .external_lex_state = 7},
  [3427] = {.lex_state = 429, .external_lex_state = 7},
  [3428] = {.lex_state = 429, .external_lex_state = 7},
  [3429] = {.lex_state = 429, .external_lex_state = 7},
  [3430] = {.lex_state = 425},
  [3431] = {.lex_state = 425},
  [3432] = {.lex_state = 429, .external_lex_state = 7},
  [3433] = {.lex_state = 429, .external_lex_state = 7},
  [3434] = {.lex_state = 429, .external_lex_state = 7},
  [3435] = {.lex_state = 429, .external_lex_state = 7},
  [3436] = {.lex_state = 429, .external_lex_state = 7},
  [3437] = {.lex_state = 429, .external_lex_state = 7},
  [3438] = {.lex_state = 429, .external_lex_state = 7},
  [3439] = {.lex_state = 429, .external_lex_state = 7},
  [3440] = {.lex_state = 429, .external_lex_state = 7},
  [3441] = {.lex_state = 429, .external_lex_state = 7},
  [3442] = {.lex_state = 425},
  [3443] = {.lex_state = 429, .external_lex_state = 7},
  [3444] = {.lex_state = 429, .external_lex_state = 7},
  [3445] = {.lex_state = 429, .external_lex_state = 7},
  [3446] = {.lex_state = 429, .external_lex_state = 7},
  [3447] = {.lex_state = 429, .external_lex_state = 7},
  [3448] = {.lex_state = 429, .external_lex_state = 7},
  [3449] = {.lex_state = 429, .external_lex_state = 7},
  [3450] = {.lex_state = 429, .external_lex_state = 7},
  [3451] = {.lex_state = 429, .external_lex_state = 7},
  [3452] = {.lex_state = 425},
  [3453] = {.lex_state = 425},
  [3454] = {.lex_state = 425},
  [3455] = {.lex_state = 425},
  [3456] = {.lex_state = 425},
  [3457] = {.lex_state = 425},
  [3458] = {.lex_state = 431},
  [3459] = {.lex_state = 425},
  [3460] = {.lex_state = 425},
  [3461] = {.lex_state = 425},
  [3462] = {.lex_state = 425},
  [3463] = {.lex_state = 425},
  [3464] = {.lex_state = 429, .external_lex_state = 7},
  [3465] = {.lex_state = 429, .external_lex_state = 7},
  [3466] = {.lex_state = 429, .external_lex_state = 7},
  [3467] = {.lex_state = 429, .external_lex_state = 7},
  [3468] = {.lex_state = 425},
  [3469] = {.lex_state = 432, .external_lex_state = 7},
  [3470] = {.lex_state = 425},
  [3471] = {.lex_state = 425},
  [3472] = {.lex_state = 429, .external_lex_state = 7},
  [3473] = {.lex_state = 429, .external_lex_state = 7},
  [3474] = {.lex_state = 429, .external_lex_state = 7},
  [3475] = {.lex_state = 425},
  [3476] = {.lex_state = 429, .external_lex_state = 7},
  [3477] = {.lex_state = 429, .external_lex_state = 7},
  [3478] = {.lex_state = 429, .external_lex_state = 7},
  [3479] = {.lex_state = 429, .external_lex_state = 7},
  [3480] = {.lex_state = 429},
  [3481] = {.lex_state = 0, .external_lex_state = 8},
  [3482] = {.lex_state = 0, .external_lex_state = 8},
  [3483] = {.lex_state = 0, .external_lex_state = 8},
  [3484] = {.lex_state = 433},
  [3485] = {.lex_state = 433},
  [3486] = {.lex_state = 433},
  [3487] = {.lex_state = 433},
  [3488] = {.lex_state = 433},
  [3489] = {.lex_state = 433},
  [3490] = {.lex_state = 433},
  [3491] = {.lex_state = 433},
  [3492] = {.lex_state = 433},
  [3493] = {.lex_state = 433},
  [3494] = {.lex_state = 433},
  [3495] = {.lex_state = 433},
  [3496] = {.lex_state = 433},
  [3497] = {.lex_state = 433},
  [3498] = {.lex_state = 433},
  [3499] = {.lex_state = 433},
  [3500] = {.lex_state = 433},
  [3501] = {.lex_state = 433},
  [3502] = {.lex_state = 433},
  [3503] = {.lex_state = 433},
  [3504] = {.lex_state = 433},
  [3505] = {.lex_state = 433},
  [3506] = {.lex_state = 433},
  [3507] = {.lex_state = 433},
  [3508] = {.lex_state = 433},
  [3509] = {.lex_state = 433},
  [3510] = {.lex_state = 433},
  [3511] = {.lex_state = 433},
  [3512] = {.lex_state = 433},
  [3513] = {.lex_state = 433},
  [3514] = {.lex_state = 433},
  [3515] = {.lex_state = 433},
  [3516] = {.lex_state = 433},
  [3517] = {.lex_state = 433},
  [3518] = {.lex_state = 433},
  [3519] = {.lex_state = 433},
  [3520] = {.lex_state = 433},
  [3521] = {.lex_state = 433},
  [3522] = {.lex_state = 433},
  [3523] = {.lex_state = 433},
  [3524] = {.lex_state = 433},
  [3525] = {.lex_state = 433},
  [3526] = {.lex_state = 433},
  [3527] = {.lex_state = 433},
  [3528] = {.lex_state = 433},
  [3529] = {.lex_state = 433},
  [3530] = {.lex_state = 433},
  [3531] = {.lex_state = 433},
  [3532] = {.lex_state = 433},
  [3533] = {.lex_state = 433},
  [3534] = {.lex_state = 433},
  [3535] = {.lex_state = 433},
  [3536] = {.lex_state = 433},
  [3537] = {.lex_state = 433},
  [3538] = {.lex_state = 433},
  [3539] = {.lex_state = 433},
  [3540] = {.lex_state = 433},
  [3541] = {.lex_state = 433},
  [3542] = {.lex_state = 433},
  [3543] = {.lex_state = 433},
  [3544] = {.lex_state = 433},
  [3545] = {.lex_state = 417},
  [3546] = {.lex_state = 433},
  [3547] = {.lex_state = 433},
  [3548] = {.lex_state = 433},
  [3549] = {.lex_state = 417},
  [3550] = {.lex_state = 433},
  [3551] = {.lex_state = 417},
  [3552] = {.lex_state = 417},
  [3553] = {.lex_state = 417},
  [3554] = {.lex_state = 433},
  [3555] = {.lex_state = 0, .external_lex_state = 11},
  [3556] = {.lex_state = 0, .external_lex_state = 11},
  [3557] = {.lex_state = 433},
  [3558] = {.lex_state = 433},
  [3559] = {.lex_state = 433},
  [3560] = {.lex_state = 417},
  [3561] = {.lex_state = 435},
  [3562] = {.lex_state = 417},
  [3563] = {.lex_state = 417},
  [3564] = {.lex_state = 433},
  [3565] = {.lex_state = 417},
  [3566] = {.lex_state = 417},
  [3567] = {.lex_state = 0, .external_lex_state = 11},
  [3568] = {.lex_state = 433},
  [3569] = {.lex_state = 433},
  [3570] = {.lex_state = 417},
  [3571] = {.lex_state = 417},
  [3572] = {.lex_state = 417},
  [3573] = {.lex_state = 417},
  [3574] = {.lex_state = 0, .external_lex_state = 11},
  [3575] = {.lex_state = 433},
  [3576] = {.lex_state = 0, .external_lex_state = 11},
  [3577] = {.lex_state = 417, .external_lex_state = 7},
  [3578] = {.lex_state = 0, .external_lex_state = 11},
  [3579] = {.lex_state = 433},
  [3580] = {.lex_state = 433},
  [3581] = {.lex_state = 417},
  [3582] = {.lex_state = 417},
  [3583] = {.lex_state = 433},
  [3584] = {.lex_state = 417},
  [3585] = {.lex_state = 433},
  [3586] = {.lex_state = 417},
  [3587] = {.lex_state = 433},
  [3588] = {.lex_state = 0, .external_lex_state = 11},
  [3589] = {.lex_state = 433},
  [3590] = {.lex_state = 433},
  [3591] = {.lex_state = 433},
  [3592] = {.lex_state = 0, .external_lex_state = 11},
  [3593] = {.lex_state = 417},
  [3594] = {.lex_state = 433},
  [3595] = {.lex_state = 417},
  [3596] = {.lex_state = 435},
  [3597] = {.lex_state = 433},
  [3598] = {.lex_state = 0, .external_lex_state = 11},
  [3599] = {.lex_state = 433},
  [3600] = {.lex_state = 417, .external_lex_state = 7},
  [3601] = {.lex_state = 417},
  [3602] = {.lex_state = 417},
  [3603] = {.lex_state = 417},
  [3604] = {.lex_state = 433},
  [3605] = {.lex_state = 417},
  [3606] = {.lex_state = 433},
  [3607] = {.lex_state = 417},
  [3608] = {.lex_state = 417},
  [3609] = {.lex_state = 0, .external_lex_state = 11},
  [3610] = {.lex_state = 433},
  [3611] = {.lex_state = 417},
  [3612] = {.lex_state = 433},
  [3613] = {.lex_state = 417},
  [3614] = {.lex_state = 433},
  [3615] = {.lex_state = 433},
  [3616] = {.lex_state = 0, .external_lex_state = 11},
  [3617] = {.lex_state = 433},
  [3618] = {.lex_state = 0, .external_lex_state = 11},
  [3619] = {.lex_state = 417},
  [3620] = {.lex_state = 433},
  [3621] = {.lex_state = 417},
  [3622] = {.lex_state = 417},
  [3623] = {.lex_state = 433},
  [3624] = {.lex_state = 417},
  [3625] = {.lex_state = 417},
  [3626] = {.lex_state = 433},
  [3627] = {.lex_state = 433},
  [3628] = {.lex_state = 433},
  [3629] = {.lex_state = 433},
  [3630] = {.lex_state = 417},
  [3631] = {.lex_state = 417},
  [3632] = {.lex_state = 0, .external_lex_state = 11},
  [3633] = {.lex_state = 0, .external_lex_state = 11},
  [3634] = {.lex_state = 433},
  [3635] = {.lex_state = 0, .external_lex_state = 11},
  [3636] = {.lex_state = 433},
  [3637] = {.lex_state = 0},
  [3638] = {.lex_state = 0},
  [3639] = {.lex_state = 0},
  [3640] = {.lex_state = 0, .external_lex_state = 2},
  [3641] = {.lex_state = 0},
  [3642] = {.lex_state = 417},
  [3643] = {.lex_state = 433},
  [3644] = {.lex_state = 397},
  [3645] = {.lex_state = 433},
  [3646] = {.lex_state = 0},
  [3647] = {.lex_state = 0},
  [3648] = {.lex_state = 433},
  [3649] = {.lex_state = 417},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 435},
  [3652] = {.lex_state = 0, .external_lex_state = 7},
  [3653] = {.lex_state = 397},
  [3654] = {.lex_state = 0},
  [3655] = {.lex_state = 417},
  [3656] = {.lex_state = 433},
  [3657] = {.lex_state = 0},
  [3658] = {.lex_state = 397},
  [3659] = {.lex_state = 397},
  [3660] = {.lex_state = 0},
  [3661] = {.lex_state = 417},
  [3662] = {.lex_state = 433},
  [3663] = {.lex_state = 433},
  [3664] = {.lex_state = 417},
  [3665] = {.lex_state = 433},
  [3666] = {.lex_state = 0},
  [3667] = {.lex_state = 0},
  [3668] = {.lex_state = 433},
  [3669] = {.lex_state = 397},
  [3670] = {.lex_state = 397},
  [3671] = {.lex_state = 417},
  [3672] = {.lex_state = 0},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 397},
  [3675] = {.lex_state = 433},
  [3676] = {.lex_state = 433},
  [3677] = {.lex_state = 433},
  [3678] = {.lex_state = 397},
  [3679] = {.lex_state = 433},
  [3680] = {.lex_state = 0, .external_lex_state = 7},
  [3681] = {.lex_state = 397},
  [3682] = {.lex_state = 0},
  [3683] = {.lex_state = 397},
  [3684] = {.lex_state = 0},
  [3685] = {.lex_state = 0},
  [3686] = {.lex_state = 397},
  [3687] = {.lex_state = 397},
  [3688] = {.lex_state = 417},
  [3689] = {.lex_state = 0},
  [3690] = {.lex_state = 0},
  [3691] = {.lex_state = 397},
  [3692] = {.lex_state = 433},
  [3693] = {.lex_state = 0, .external_lex_state = 2},
  [3694] = {.lex_state = 433},
  [3695] = {.lex_state = 0, .external_lex_state = 7},
  [3696] = {.lex_state = 0},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 433},
  [3699] = {.lex_state = 435},
  [3700] = {.lex_state = 0},
  [3701] = {.lex_state = 433},
  [3702] = {.lex_state = 0},
  [3703] = {.lex_state = 433},
  [3704] = {.lex_state = 397},
  [3705] = {.lex_state = 433},
  [3706] = {.lex_state = 0},
  [3707] = {.lex_state = 397},
  [3708] = {.lex_state = 433},
  [3709] = {.lex_state = 433},
  [3710] = {.lex_state = 0},
  [3711] = {.lex_state = 0},
  [3712] = {.lex_state = 433},
  [3713] = {.lex_state = 0},
  [3714] = {.lex_state = 397},
  [3715] = {.lex_state = 0},
  [3716] = {.lex_state = 0},
  [3717] = {.lex_state = 417},
  [3718] = {.lex_state = 0},
  [3719] = {.lex_state = 0},
  [3720] = {.lex_state = 417, .external_lex_state = 7},
  [3721] = {.lex_state = 433},
  [3722] = {.lex_state = 417},
  [3723] = {.lex_state = 397},
  [3724] = {.lex_state = 433},
  [3725] = {.lex_state = 433},
  [3726] = {.lex_state = 0},
  [3727] = {.lex_state = 433},
  [3728] = {.lex_state = 433},
  [3729] = {.lex_state = 397},
  [3730] = {.lex_state = 417, .external_lex_state = 7},
  [3731] = {.lex_state = 0, .external_lex_state = 10},
  [3732] = {.lex_state = 0, .external_lex_state = 10},
  [3733] = {.lex_state = 0, .external_lex_state = 9},
  [3734] = {.lex_state = 417},
  [3735] = {.lex_state = 0, .external_lex_state = 10},
  [3736] = {.lex_state = 0, .external_lex_state = 9},
  [3737] = {.lex_state = 0, .external_lex_state = 7},
  [3738] = {.lex_state = 0, .external_lex_state = 7},
  [3739] = {.lex_state = 0, .external_lex_state = 9},
  [3740] = {.lex_state = 417, .external_lex_state = 7},
  [3741] = {.lex_state = 424},
  [3742] = {.lex_state = 0, .external_lex_state = 10},
  [3743] = {.lex_state = 417},
  [3744] = {.lex_state = 424},
  [3745] = {.lex_state = 0, .external_lex_state = 12},
  [3746] = {.lex_state = 0, .external_lex_state = 10},
  [3747] = {.lex_state = 417},
  [3748] = {.lex_state = 0, .external_lex_state = 9},
  [3749] = {.lex_state = 0, .external_lex_state = 10},
  [3750] = {.lex_state = 0, .external_lex_state = 7},
  [3751] = {.lex_state = 424},
  [3752] = {.lex_state = 417},
  [3753] = {.lex_state = 0, .external_lex_state = 9},
  [3754] = {.lex_state = 0, .external_lex_state = 7},
  [3755] = {.lex_state = 424},
  [3756] = {.lex_state = 424},
  [3757] = {.lex_state = 417},
  [3758] = {.lex_state = 0, .external_lex_state = 10},
  [3759] = {.lex_state = 424},
  [3760] = {.lex_state = 417},
  [3761] = {.lex_state = 0, .external_lex_state = 9},
  [3762] = {.lex_state = 417},
  [3763] = {.lex_state = 417},
  [3764] = {.lex_state = 0, .external_lex_state = 7},
  [3765] = {.lex_state = 0, .external_lex_state = 10},
  [3766] = {.lex_state = 0, .external_lex_state = 9},
  [3767] = {.lex_state = 417},
  [3768] = {.lex_state = 397},
  [3769] = {.lex_state = 0, .external_lex_state = 10},
  [3770] = {.lex_state = 417},
  [3771] = {.lex_state = 0},
  [3772] = {.lex_state = 417},
  [3773] = {.lex_state = 417},
  [3774] = {.lex_state = 0},
  [3775] = {.lex_state = 0, .external_lex_state = 7},
  [3776] = {.lex_state = 417},
  [3777] = {.lex_state = 424},
  [3778] = {.lex_state = 0, .external_lex_state = 7},
  [3779] = {.lex_state = 424},
  [3780] = {.lex_state = 424},
  [3781] = {.lex_state = 417},
  [3782] = {.lex_state = 0, .external_lex_state = 10},
  [3783] = {.lex_state = 417},
  [3784] = {.lex_state = 0, .external_lex_state = 10},
  [3785] = {.lex_state = 0, .external_lex_state = 7},
  [3786] = {.lex_state = 0, .external_lex_state = 9},
  [3787] = {.lex_state = 0, .external_lex_state = 9},
  [3788] = {.lex_state = 0, .external_lex_state = 9},
  [3789] = {.lex_state = 0, .external_lex_state = 7},
  [3790] = {.lex_state = 0, .external_lex_state = 9},
  [3791] = {.lex_state = 424},
  [3792] = {.lex_state = 424},
  [3793] = {.lex_state = 424},
  [3794] = {.lex_state = 0, .external_lex_state = 10},
  [3795] = {.lex_state = 0, .external_lex_state = 10},
  [3796] = {.lex_state = 0, .external_lex_state = 9},
  [3797] = {.lex_state = 0, .external_lex_state = 10},
  [3798] = {.lex_state = 417, .external_lex_state = 7},
  [3799] = {.lex_state = 424},
  [3800] = {.lex_state = 0, .external_lex_state = 9},
  [3801] = {.lex_state = 424},
  [3802] = {.lex_state = 0, .external_lex_state = 7},
  [3803] = {.lex_state = 424},
  [3804] = {.lex_state = 417},
  [3805] = {.lex_state = 0, .external_lex_state = 12},
  [3806] = {.lex_state = 0, .external_lex_state = 9},
  [3807] = {.lex_state = 0, .external_lex_state = 7},
  [3808] = {.lex_state = 424},
  [3809] = {.lex_state = 424},
  [3810] = {.lex_state = 417},
  [3811] = {.lex_state = 0, .external_lex_state = 10},
  [3812] = {.lex_state = 0, .external_lex_state = 9},
  [3813] = {.lex_state = 0, .external_lex_state = 10},
  [3814] = {.lex_state = 417},
  [3815] = {.lex_state = 424},
  [3816] = {.lex_state = 417, .external_lex_state = 7},
  [3817] = {.lex_state = 0, .external_lex_state = 9},
  [3818] = {.lex_state = 417},
  [3819] = {.lex_state = 0},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 417},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 0},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 0},
  [3826] = {.lex_state = 0},
  [3827] = {.lex_state = 0},
  [3828] = {.lex_state = 417},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 421},
  [3833] = {.lex_state = 0},
  [3834] = {.lex_state = 0},
  [3835] = {.lex_state = 0},
  [3836] = {.lex_state = 0},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 0},
  [3839] = {.lex_state = 417},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 0, .external_lex_state = 7},
  [3842] = {.lex_state = 0, .external_lex_state = 7},
  [3843] = {.lex_state = 0},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 0},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 0},
  [3848] = {.lex_state = 417},
  [3849] = {.lex_state = 433},
  [3850] = {.lex_state = 417},
  [3851] = {.lex_state = 0},
  [3852] = {.lex_state = 0},
  [3853] = {.lex_state = 0},
  [3854] = {.lex_state = 0},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 0},
  [3857] = {.lex_state = 421},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 421},
  [3861] = {.lex_state = 0},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 0},
  [3864] = {.lex_state = 0},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 0},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 0},
  [3869] = {.lex_state = 0},
  [3870] = {.lex_state = 0},
  [3871] = {.lex_state = 0},
  [3872] = {.lex_state = 421},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 0},
  [3875] = {.lex_state = 0},
  [3876] = {.lex_state = 0},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 421},
  [3879] = {.lex_state = 0},
  [3880] = {.lex_state = 417},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 0},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 421},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 0},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 0},
  [3890] = {.lex_state = 0, .external_lex_state = 7},
  [3891] = {.lex_state = 0},
  [3892] = {.lex_state = 421},
  [3893] = {.lex_state = 417},
  [3894] = {.lex_state = 0},
  [3895] = {.lex_state = 0},
  [3896] = {.lex_state = 407},
  [3897] = {.lex_state = 407},
  [3898] = {.lex_state = 421},
  [3899] = {.lex_state = 0},
  [3900] = {.lex_state = 424},
  [3901] = {.lex_state = 421},
  [3902] = {.lex_state = 0},
  [3903] = {.lex_state = 0, .external_lex_state = 7},
  [3904] = {.lex_state = 0},
  [3905] = {.lex_state = 0},
  [3906] = {.lex_state = 417},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 417},
  [3909] = {.lex_state = 417},
  [3910] = {.lex_state = 0},
  [3911] = {.lex_state = 0},
  [3912] = {.lex_state = 0},
  [3913] = {.lex_state = 0},
  [3914] = {.lex_state = 0},
  [3915] = {.lex_state = 0},
  [3916] = {.lex_state = 407},
  [3917] = {.lex_state = 417},
  [3918] = {.lex_state = 0},
  [3919] = {.lex_state = 0},
  [3920] = {.lex_state = 417},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 417},
  [3923] = {.lex_state = 417},
  [3924] = {.lex_state = 417},
  [3925] = {.lex_state = 421},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 433},
  [3930] = {.lex_state = 0},
  [3931] = {.lex_state = 0},
  [3932] = {.lex_state = 417},
  [3933] = {.lex_state = 0},
  [3934] = {.lex_state = 417},
  [3935] = {.lex_state = 417},
  [3936] = {.lex_state = 417},
  [3937] = {.lex_state = 433},
  [3938] = {.lex_state = 417},
  [3939] = {.lex_state = 417},
  [3940] = {.lex_state = 0},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 417},
  [3943] = {.lex_state = 417},
  [3944] = {.lex_state = 0},
  [3945] = {.lex_state = 417},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 0},
  [3948] = {.lex_state = 421},
  [3949] = {.lex_state = 0},
  [3950] = {.lex_state = 421},
  [3951] = {.lex_state = 417},
  [3952] = {.lex_state = 417},
  [3953] = {.lex_state = 0},
  [3954] = {.lex_state = 0},
  [3955] = {.lex_state = 417},
  [3956] = {.lex_state = 0},
  [3957] = {.lex_state = 417},
  [3958] = {.lex_state = 417},
  [3959] = {.lex_state = 0},
  [3960] = {.lex_state = 417},
  [3961] = {.lex_state = 421},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 0},
  [3964] = {.lex_state = 0, .external_lex_state = 7},
  [3965] = {.lex_state = 417},
  [3966] = {.lex_state = 0},
  [3967] = {.lex_state = 417},
  [3968] = {.lex_state = 0},
  [3969] = {.lex_state = 417},
  [3970] = {.lex_state = 0},
  [3971] = {.lex_state = 0},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 417},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 417},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 0},
  [3978] = {.lex_state = 0},
  [3979] = {.lex_state = 0},
  [3980] = {.lex_state = 407},
  [3981] = {.lex_state = 407},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 407},
  [3984] = {.lex_state = 407},
  [3985] = {.lex_state = 0},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 417},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 417},
  [3994] = {.lex_state = 417},
  [3995] = {.lex_state = 417},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 0},
  [3998] = {.lex_state = 417},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 417},
  [4001] = {.lex_state = 0},
  [4002] = {.lex_state = 0},
  [4003] = {.lex_state = 421},
  [4004] = {.lex_state = 0},
  [4005] = {.lex_state = 0},
  [4006] = {.lex_state = 0, .external_lex_state = 7},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 417},
  [4009] = {.lex_state = 424},
  [4010] = {.lex_state = 0},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 0},
  [4013] = {.lex_state = 0, .external_lex_state = 7},
  [4014] = {.lex_state = 417},
  [4015] = {.lex_state = 0},
  [4016] = {.lex_state = 0},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 417},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 421},
  [4022] = {.lex_state = 0},
  [4023] = {.lex_state = 0, .external_lex_state = 7},
  [4024] = {.lex_state = 0},
  [4025] = {.lex_state = 0},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0, .external_lex_state = 7},
  [4028] = {.lex_state = 417},
  [4029] = {.lex_state = 407},
  [4030] = {.lex_state = 417},
  [4031] = {.lex_state = 417},
  [4032] = {.lex_state = 407},
  [4033] = {.lex_state = 417},
  [4034] = {.lex_state = 417},
  [4035] = {.lex_state = 0, .external_lex_state = 7},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 0, .external_lex_state = 7},
  [4038] = {.lex_state = 417},
  [4039] = {.lex_state = 0},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 0},
  [4043] = {.lex_state = 417},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 417},
  [4046] = {.lex_state = 417},
  [4047] = {.lex_state = 417},
  [4048] = {.lex_state = 0},
  [4049] = {.lex_state = 0},
  [4050] = {.lex_state = 421},
  [4051] = {.lex_state = 421},
  [4052] = {.lex_state = 0},
  [4053] = {.lex_state = 417},
  [4054] = {.lex_state = 0},
  [4055] = {.lex_state = 0},
  [4056] = {.lex_state = 0},
  [4057] = {.lex_state = 0},
  [4058] = {.lex_state = 0},
  [4059] = {.lex_state = 417},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 0},
  [4062] = {.lex_state = 0},
  [4063] = {.lex_state = 421},
  [4064] = {.lex_state = 0},
  [4065] = {.lex_state = 0},
  [4066] = {.lex_state = 0},
  [4067] = {.lex_state = 0},
  [4068] = {.lex_state = 0},
  [4069] = {.lex_state = 0},
  [4070] = {.lex_state = 0},
  [4071] = {.lex_state = 0},
  [4072] = {.lex_state = 0},
  [4073] = {.lex_state = 417},
  [4074] = {.lex_state = 0},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 0},
  [4077] = {.lex_state = 0},
  [4078] = {.lex_state = 421},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 0},
  [4081] = {.lex_state = 0},
  [4082] = {.lex_state = 0},
  [4083] = {.lex_state = 421},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 417},
  [4086] = {.lex_state = 407},
  [4087] = {.lex_state = 0, .external_lex_state = 2},
  [4088] = {.lex_state = 407},
  [4089] = {.lex_state = 407},
  [4090] = {.lex_state = 0},
  [4091] = {.lex_state = 417},
  [4092] = {.lex_state = 0},
  [4093] = {.lex_state = 0},
  [4094] = {.lex_state = 0},
  [4095] = {.lex_state = 0},
  [4096] = {.lex_state = 0},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 0},
  [4099] = {.lex_state = 0},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 417},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 417},
  [4107] = {.lex_state = 0},
  [4108] = {.lex_state = 0},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 417},
  [4111] = {.lex_state = 0},
  [4112] = {.lex_state = 0},
  [4113] = {.lex_state = 0, .external_lex_state = 7},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 424},
  [4117] = {.lex_state = 421},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 0},
  [4120] = {.lex_state = 0},
  [4121] = {.lex_state = 417},
  [4122] = {.lex_state = 417},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 417},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 417},
  [4127] = {.lex_state = 0},
  [4128] = {.lex_state = 407},
  [4129] = {.lex_state = 0},
  [4130] = {.lex_state = 417},
  [4131] = {.lex_state = 407},
  [4132] = {.lex_state = 0, .external_lex_state = 2},
  [4133] = {.lex_state = 417},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 417},
  [4136] = {.lex_state = 417},
  [4137] = {.lex_state = 417},
  [4138] = {.lex_state = 407},
  [4139] = {.lex_state = 0},
  [4140] = {.lex_state = 417},
  [4141] = {.lex_state = 417},
  [4142] = {.lex_state = 417},
  [4143] = {.lex_state = 417},
  [4144] = {.lex_state = 421},
  [4145] = {.lex_state = 421},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 0},
  [4148] = {.lex_state = 0},
  [4149] = {.lex_state = 0},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 0},
  [4153] = {.lex_state = 0},
  [4154] = {.lex_state = 0},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 0},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 417},
  [4159] = {.lex_state = 421},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 0},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 0},
  [4165] = {.lex_state = 417},
  [4166] = {.lex_state = 417},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 407},
  [4170] = {.lex_state = 417},
  [4171] = {.lex_state = 417},
  [4172] = {.lex_state = 0},
  [4173] = {.lex_state = 0},
  [4174] = {.lex_state = 0},
  [4175] = {.lex_state = 417},
  [4176] = {.lex_state = 417},
  [4177] = {.lex_state = 421},
  [4178] = {.lex_state = 421},
  [4179] = {.lex_state = 0},
  [4180] = {.lex_state = 0},
  [4181] = {.lex_state = 417},
  [4182] = {.lex_state = 0},
  [4183] = {.lex_state = 0, .external_lex_state = 2},
  [4184] = {.lex_state = 0},
  [4185] = {.lex_state = 417},
  [4186] = {.lex_state = 0},
  [4187] = {.lex_state = 0},
  [4188] = {.lex_state = 417},
  [4189] = {.lex_state = 407},
  [4190] = {.lex_state = 0},
  [4191] = {.lex_state = 0},
  [4192] = {.lex_state = 417},
  [4193] = {.lex_state = 0},
  [4194] = {.lex_state = 0},
  [4195] = {.lex_state = 417},
  [4196] = {.lex_state = 0, .external_lex_state = 2},
  [4197] = {.lex_state = 417},
  [4198] = {.lex_state = 417},
  [4199] = {.lex_state = 417},
  [4200] = {.lex_state = 0},
  [4201] = {.lex_state = 0},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 0},
  [4204] = {.lex_state = 0},
  [4205] = {.lex_state = 421},
  [4206] = {.lex_state = 0},
  [4207] = {.lex_state = 421},
  [4208] = {.lex_state = 417},
  [4209] = {.lex_state = 0},
  [4210] = {.lex_state = 417},
  [4211] = {.lex_state = 417},
  [4212] = {.lex_state = 407},
  [4213] = {.lex_state = 0},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 421},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 0, .external_lex_state = 2},
  [4218] = {.lex_state = 417},
  [4219] = {.lex_state = 407},
  [4220] = {.lex_state = 0},
  [4221] = {.lex_state = 0},
  [4222] = {.lex_state = 0},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 421},
  [4225] = {.lex_state = 0},
  [4226] = {.lex_state = 0},
  [4227] = {.lex_state = 417},
  [4228] = {.lex_state = 417},
  [4229] = {.lex_state = 417},
  [4230] = {.lex_state = 0},
  [4231] = {.lex_state = 0},
  [4232] = {.lex_state = 417},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 421},
  [4236] = {.lex_state = 0},
  [4237] = {.lex_state = 0},
  [4238] = {.lex_state = 421},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 0},
  [4241] = {.lex_state = 0},
  [4242] = {.lex_state = 0},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 0},
  [4246] = {.lex_state = 417},
  [4247] = {.lex_state = 417},
  [4248] = {.lex_state = 417},
  [4249] = {.lex_state = 417},
  [4250] = {.lex_state = 407},
  [4251] = {.lex_state = 407},
  [4252] = {.lex_state = 417},
  [4253] = {.lex_state = 0},
  [4254] = {.lex_state = 0},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 0},
  [4257] = {.lex_state = 417},
  [4258] = {.lex_state = 417},
  [4259] = {.lex_state = 417},
  [4260] = {.lex_state = 417},
  [4261] = {.lex_state = 417},
  [4262] = {.lex_state = 417},
  [4263] = {.lex_state = 417},
  [4264] = {.lex_state = 417},
  [4265] = {.lex_state = 0},
  [4266] = {.lex_state = 0, .external_lex_state = 9},
  [4267] = {.lex_state = 0, .external_lex_state = 10},
  [4268] = {.lex_state = 417},
  [4269] = {.lex_state = 417},
  [4270] = {.lex_state = 417},
  [4271] = {.lex_state = 417},
  [4272] = {.lex_state = 417},
  [4273] = {.lex_state = 417},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 417},
  [4276] = {.lex_state = 0},
  [4277] = {.lex_state = 0, .external_lex_state = 7},
  [4278] = {.lex_state = 417},
  [4279] = {.lex_state = 0},
  [4280] = {.lex_state = 417},
  [4281] = {.lex_state = 417},
  [4282] = {.lex_state = 417},
  [4283] = {.lex_state = 417},
  [4284] = {.lex_state = 417},
  [4285] = {.lex_state = 417},
  [4286] = {.lex_state = 417},
  [4287] = {.lex_state = 417},
  [4288] = {.lex_state = 417},
  [4289] = {.lex_state = 0},
  [4290] = {.lex_state = 435},
  [4291] = {.lex_state = 417},
  [4292] = {.lex_state = 0, .external_lex_state = 7},
  [4293] = {.lex_state = 417},
  [4294] = {.lex_state = 417},
  [4295] = {.lex_state = 417},
  [4296] = {.lex_state = 0},
  [4297] = {.lex_state = 417},
  [4298] = {.lex_state = 0},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 417},
  [4301] = {.lex_state = 417},
  [4302] = {.lex_state = 417},
  [4303] = {.lex_state = 0},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 0, .external_lex_state = 7},
  [4306] = {.lex_state = 0},
  [4307] = {.lex_state = 417},
  [4308] = {.lex_state = 0},
  [4309] = {.lex_state = 435},
  [4310] = {.lex_state = 0},
  [4311] = {.lex_state = 417},
  [4312] = {.lex_state = 417},
  [4313] = {.lex_state = 435},
  [4314] = {.lex_state = 417},
  [4315] = {.lex_state = 417},
  [4316] = {.lex_state = 417},
  [4317] = {.lex_state = 437},
  [4318] = {.lex_state = 407},
  [4319] = {.lex_state = 0},
  [4320] = {.lex_state = 417},
  [4321] = {.lex_state = 417},
  [4322] = {.lex_state = 407},
  [4323] = {.lex_state = 417},
  [4324] = {.lex_state = 0},
  [4325] = {.lex_state = 407},
  [4326] = {.lex_state = 407},
  [4327] = {.lex_state = 407},
  [4328] = {.lex_state = 417},
  [4329] = {.lex_state = 437},
  [4330] = {.lex_state = 407},
  [4331] = {.lex_state = 417},
  [4332] = {.lex_state = 0},
  [4333] = {.lex_state = 0},
  [4334] = {.lex_state = 407},
  [4335] = {.lex_state = 0},
  [4336] = {.lex_state = 407},
  [4337] = {.lex_state = 0},
  [4338] = {.lex_state = 0},
  [4339] = {.lex_state = 407},
  [4340] = {.lex_state = 407},
  [4341] = {.lex_state = 0},
  [4342] = {.lex_state = 407},
  [4343] = {.lex_state = 407},
  [4344] = {.lex_state = 417},
  [4345] = {.lex_state = 0},
  [4346] = {.lex_state = 407},
  [4347] = {.lex_state = 417},
  [4348] = {.lex_state = 0, .external_lex_state = 7},
  [4349] = {.lex_state = 417},
  [4350] = {.lex_state = 0},
  [4351] = {.lex_state = 417},
  [4352] = {.lex_state = 417},
  [4353] = {.lex_state = 407},
  [4354] = {.lex_state = 0, .external_lex_state = 7},
  [4355] = {.lex_state = 417},
  [4356] = {.lex_state = 417},
  [4357] = {.lex_state = 417},
  [4358] = {.lex_state = 407},
  [4359] = {.lex_state = 407},
  [4360] = {.lex_state = 0},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 0},
  [4363] = {.lex_state = 0},
  [4364] = {.lex_state = 417},
  [4365] = {.lex_state = 407},
  [4366] = {.lex_state = 437},
  [4367] = {.lex_state = 417},
  [4368] = {.lex_state = 417},
  [4369] = {.lex_state = 0},
  [4370] = {.lex_state = 407},
  [4371] = {.lex_state = 417},
  [4372] = {.lex_state = 407},
  [4373] = {.lex_state = 0},
  [4374] = {.lex_state = 0},
  [4375] = {.lex_state = 417},
  [4376] = {.lex_state = 417},
  [4377] = {.lex_state = 417},
  [4378] = {.lex_state = 0, .external_lex_state = 7},
  [4379] = {.lex_state = 0},
  [4380] = {.lex_state = 407},
  [4381] = {.lex_state = 417},
  [4382] = {.lex_state = 0},
  [4383] = {.lex_state = 417},
  [4384] = {.lex_state = 0},
  [4385] = {.lex_state = 417},
  [4386] = {.lex_state = 407},
  [4387] = {.lex_state = 417},
  [4388] = {.lex_state = 417},
  [4389] = {.lex_state = 0},
  [4390] = {.lex_state = 1073},
  [4391] = {.lex_state = 407},
  [4392] = {.lex_state = 0},
  [4393] = {.lex_state = 407},
  [4394] = {.lex_state = 417},
  [4395] = {.lex_state = 417},
  [4396] = {.lex_state = 0},
  [4397] = {.lex_state = 0},
  [4398] = {.lex_state = 407},
  [4399] = {.lex_state = 417},
  [4400] = {.lex_state = 417},
  [4401] = {.lex_state = 417},
  [4402] = {.lex_state = 0},
  [4403] = {.lex_state = 0},
  [4404] = {.lex_state = 0},
  [4405] = {.lex_state = 0, .external_lex_state = 7},
  [4406] = {.lex_state = 417},
  [4407] = {.lex_state = 417},
  [4408] = {.lex_state = 407},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 407},
  [4411] = {.lex_state = 417},
  [4412] = {.lex_state = 417},
  [4413] = {.lex_state = 0},
  [4414] = {.lex_state = 0},
  [4415] = {.lex_state = 0, .external_lex_state = 7},
  [4416] = {.lex_state = 417},
  [4417] = {.lex_state = 407},
  [4418] = {.lex_state = 0},
  [4419] = {.lex_state = 417},
  [4420] = {.lex_state = 0},
  [4421] = {.lex_state = 0},
  [4422] = {.lex_state = 0, .external_lex_state = 7},
  [4423] = {.lex_state = 417},
  [4424] = {.lex_state = 417},
  [4425] = {.lex_state = 407},
  [4426] = {.lex_state = 0, .external_lex_state = 7},
  [4427] = {.lex_state = 0},
  [4428] = {.lex_state = 417},
  [4429] = {.lex_state = 417},
  [4430] = {.lex_state = 407},
  [4431] = {.lex_state = 417},
  [4432] = {.lex_state = 417},
  [4433] = {.lex_state = 437},
  [4434] = {.lex_state = 0},
  [4435] = {.lex_state = 417},
  [4436] = {.lex_state = 417},
  [4437] = {.lex_state = 0, .external_lex_state = 7},
  [4438] = {.lex_state = 417},
  [4439] = {.lex_state = 417},
  [4440] = {.lex_state = 0},
  [4441] = {.lex_state = 407},
  [4442] = {.lex_state = 437},
  [4443] = {.lex_state = 417},
  [4444] = {.lex_state = 407},
  [4445] = {.lex_state = 0},
  [4446] = {.lex_state = 417},
  [4447] = {.lex_state = 417},
  [4448] = {.lex_state = 417},
  [4449] = {.lex_state = 0},
  [4450] = {.lex_state = 0},
  [4451] = {.lex_state = 407},
  [4452] = {.lex_state = 0},
  [4453] = {.lex_state = 0},
  [4454] = {.lex_state = 0},
  [4455] = {.lex_state = 417},
  [4456] = {.lex_state = 407},
  [4457] = {.lex_state = 0, .external_lex_state = 7},
  [4458] = {.lex_state = 407},
  [4459] = {.lex_state = 417},
  [4460] = {.lex_state = 417},
  [4461] = {.lex_state = 407},
  [4462] = {.lex_state = 417},
  [4463] = {.lex_state = 407},
  [4464] = {.lex_state = 0},
  [4465] = {.lex_state = 417},
  [4466] = {.lex_state = 407},
  [4467] = {.lex_state = 417},
  [4468] = {.lex_state = 407},
  [4469] = {.lex_state = 0},
  [4470] = {.lex_state = 417},
  [4471] = {.lex_state = 417},
  [4472] = {.lex_state = 417},
  [4473] = {.lex_state = 407},
  [4474] = {.lex_state = 417},
  [4475] = {.lex_state = 407},
  [4476] = {.lex_state = 0, .external_lex_state = 13},
  [4477] = {.lex_state = 437},
  [4478] = {.lex_state = 407},
  [4479] = {.lex_state = 417},
  [4480] = {.lex_state = 0},
  [4481] = {.lex_state = 437},
  [4482] = {.lex_state = 0},
  [4483] = {.lex_state = 417},
  [4484] = {.lex_state = 417},
  [4485] = {.lex_state = 0},
  [4486] = {.lex_state = 0},
  [4487] = {.lex_state = 0},
  [4488] = {.lex_state = 0},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 417},
  [4492] = {.lex_state = 435},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 0},
  [4495] = {.lex_state = 417},
  [4496] = {.lex_state = 417},
  [4497] = {.lex_state = 0},
  [4498] = {.lex_state = 407},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 407},
  [4501] = {.lex_state = 407},
  [4502] = {.lex_state = 417},
  [4503] = {.lex_state = 417},
  [4504] = {.lex_state = 1072},
  [4505] = {.lex_state = 0},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 417},
  [4508] = {.lex_state = 417},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 0},
  [4511] = {.lex_state = 0, .external_lex_state = 7},
  [4512] = {.lex_state = 407},
  [4513] = {.lex_state = 0},
  [4514] = {.lex_state = 0, .external_lex_state = 7},
  [4515] = {.lex_state = 417},
  [4516] = {.lex_state = 417},
  [4517] = {.lex_state = 407},
  [4518] = {.lex_state = 0},
  [4519] = {.lex_state = 417},
  [4520] = {.lex_state = 417},
  [4521] = {.lex_state = 407},
  [4522] = {.lex_state = 0},
  [4523] = {.lex_state = 0, .external_lex_state = 7},
  [4524] = {.lex_state = 417},
  [4525] = {.lex_state = 437},
  [4526] = {.lex_state = 417},
  [4527] = {.lex_state = 417},
  [4528] = {.lex_state = 0},
  [4529] = {.lex_state = 417},
  [4530] = {.lex_state = 417},
  [4531] = {.lex_state = 417},
  [4532] = {.lex_state = 0},
  [4533] = {.lex_state = 417},
  [4534] = {.lex_state = 417},
  [4535] = {.lex_state = 417},
  [4536] = {.lex_state = 407},
  [4537] = {.lex_state = 417},
  [4538] = {.lex_state = 417},
  [4539] = {.lex_state = 435},
  [4540] = {.lex_state = 407},
  [4541] = {.lex_state = 0},
  [4542] = {.lex_state = 0, .external_lex_state = 7},
  [4543] = {.lex_state = 1072},
  [4544] = {.lex_state = 0, .external_lex_state = 7},
  [4545] = {.lex_state = 437},
  [4546] = {.lex_state = 417},
  [4547] = {.lex_state = 407},
  [4548] = {.lex_state = 407},
  [4549] = {.lex_state = 417},
  [4550] = {.lex_state = 0, .external_lex_state = 7},
  [4551] = {.lex_state = 417},
  [4552] = {.lex_state = 417},
  [4553] = {.lex_state = 1073},
  [4554] = {.lex_state = 417},
  [4555] = {.lex_state = 0, .external_lex_state = 7},
  [4556] = {.lex_state = 417},
  [4557] = {.lex_state = 437},
  [4558] = {.lex_state = 417},
  [4559] = {.lex_state = 0, .external_lex_state = 7},
  [4560] = {.lex_state = 407},
  [4561] = {.lex_state = 417},
  [4562] = {.lex_state = 0},
  [4563] = {.lex_state = 0},
  [4564] = {.lex_state = 407},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 417},
  [4567] = {.lex_state = 417},
  [4568] = {.lex_state = 407},
  [4569] = {.lex_state = 407},
  [4570] = {.lex_state = 407},
  [4571] = {.lex_state = 0, .external_lex_state = 7},
  [4572] = {.lex_state = 407},
  [4573] = {.lex_state = 437},
  [4574] = {.lex_state = 407},
  [4575] = {.lex_state = 437},
  [4576] = {.lex_state = 417},
  [4577] = {.lex_state = 417},
  [4578] = {.lex_state = 417},
  [4579] = {.lex_state = 417},
  [4580] = {.lex_state = 0},
  [4581] = {.lex_state = 417},
  [4582] = {.lex_state = 417},
  [4583] = {.lex_state = 417},
  [4584] = {.lex_state = 437},
  [4585] = {.lex_state = 417},
  [4586] = {.lex_state = 407},
  [4587] = {.lex_state = 417},
  [4588] = {.lex_state = 437},
  [4589] = {.lex_state = 0},
  [4590] = {.lex_state = 407},
  [4591] = {.lex_state = 0},
  [4592] = {.lex_state = 417},
  [4593] = {.lex_state = 0},
  [4594] = {.lex_state = 0},
  [4595] = {.lex_state = 417},
  [4596] = {.lex_state = 417},
  [4597] = {.lex_state = 0},
  [4598] = {.lex_state = 0},
  [4599] = {.lex_state = 417},
  [4600] = {.lex_state = 417},
  [4601] = {.lex_state = 0},
  [4602] = {.lex_state = 417},
  [4603] = {.lex_state = 417},
  [4604] = {.lex_state = 0},
  [4605] = {.lex_state = 417},
  [4606] = {.lex_state = 417},
  [4607] = {.lex_state = 0},
  [4608] = {.lex_state = 417},
  [4609] = {.lex_state = 417},
  [4610] = {.lex_state = 0},
  [4611] = {.lex_state = 417},
  [4612] = {.lex_state = 417},
  [4613] = {.lex_state = 437},
  [4614] = {.lex_state = 417},
  [4615] = {.lex_state = 417},
  [4616] = {.lex_state = 407},
  [4617] = {.lex_state = 417},
  [4618] = {.lex_state = 417},
  [4619] = {.lex_state = 417},
  [4620] = {.lex_state = 417},
  [4621] = {.lex_state = 417},
  [4622] = {.lex_state = 0},
  [4623] = {.lex_state = 417},
  [4624] = {.lex_state = 417},
  [4625] = {.lex_state = 0, .external_lex_state = 7},
  [4626] = {.lex_state = 417},
  [4627] = {.lex_state = 417},
  [4628] = {.lex_state = 437},
  [4629] = {.lex_state = 417},
  [4630] = {.lex_state = 417},
  [4631] = {.lex_state = 407},
  [4632] = {.lex_state = 417},
  [4633] = {.lex_state = 417},
  [4634] = {.lex_state = 0},
  [4635] = {.lex_state = 417},
  [4636] = {.lex_state = 417},
  [4637] = {.lex_state = 0, .external_lex_state = 7},
  [4638] = {.lex_state = 417},
  [4639] = {.lex_state = 417},
  [4640] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_extramodular_text = 0,
  ts_external_token__block_comment_text = 1,
  ts_external_token__indent = 2,
  ts_external_token_bullet_conj = 3,
  ts_external_token_bullet_disj = 4,
  ts_external_token__dedent = 5,
  ts_external_token__begin_proof = 6,
  ts_external_token__begin_proof_step = 7,
  ts_external_token_proof_keyword = 8,
  ts_external_token_by_keyword = 9,
  ts_external_token_obvious_keyword = 10,
  ts_external_token_omitted_keyword = 11,
  ts_external_token_qed_keyword = 12,
  ts_external_token_error_sentinel = 13,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_extramodular_text] = sym_extramodular_text,
  [ts_external_token__block_comment_text] = sym__block_comment_text,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token_bullet_conj] = sym_bullet_conj,
  [ts_external_token_bullet_disj] = sym_bullet_disj,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__begin_proof] = sym__begin_proof,
  [ts_external_token__begin_proof_step] = sym__begin_proof_step,
  [ts_external_token_proof_keyword] = sym_proof_keyword,
  [ts_external_token_by_keyword] = sym_by_keyword,
  [ts_external_token_obvious_keyword] = sym_obvious_keyword,
  [ts_external_token_omitted_keyword] = sym_omitted_keyword,
  [ts_external_token_qed_keyword] = sym_qed_keyword,
  [ts_external_token_error_sentinel] = sym_error_sentinel,
};

static const bool ts_external_scanner_states[14][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_extramodular_text] = true,
    [ts_external_token__block_comment_text] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
    [ts_external_token_qed_keyword] = true,
    [ts_external_token_error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_extramodular_text] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token_qed_keyword] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__begin_proof_step] = true,
  },
  [6] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [7] = {
    [ts_external_token__begin_proof_step] = true,
  },
  [8] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [9] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token__dedent] = true,
  },
  [10] = {
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
  },
  [11] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
  },
  [12] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [13] = {
    [ts_external_token__block_comment_text] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(1),
    [sym_single_line] = ACTIONS(1),
    [sym_double_line] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_BSLASHAA] = ACTIONS(1),
    [anon_sym_BSLASHEE] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_8] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_9] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_10] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_11] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_ENABLED] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_SUBSET] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_DOMAIN] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_UNCHANGED] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [sym__real_number] = ACTIONS(1),
    [sym__binary_number] = ACTIONS(1),
    [sym__octal_number] = ACTIONS(1),
    [sym__hex_number] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [anon_sym_STRING] = ACTIONS(1),
    [anon_sym_BOOLEAN] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_12] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_13] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_14] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_15] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_16] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_17] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_18] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_19] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_20] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_21] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_22] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_23] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_24] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_25] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_26] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_27] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_28] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_29] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_30] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_31] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_32] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_33] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_34] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_35] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_36] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_37] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_38] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_39] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_40] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_41] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_42] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_43] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_44] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_45] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_46] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_47] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_48] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_49] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_50] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_51] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_52] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_53] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_54] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_55] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_56] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_57] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_58] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_59] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_60] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_61] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_62] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_63] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_64] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_65] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_66] = ACTIONS(1),
    [anon_sym_BANG_BANG] = ACTIONS(1),
    [anon_sym_67] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_68] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_69] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_70] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_71] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_72] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_73] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_74] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_75] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [sym_extramodular_text] = ACTIONS(1),
    [sym__block_comment_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym_bullet_conj] = ACTIONS(1),
    [sym_bullet_disj] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym_proof_keyword] = ACTIONS(1),
    [sym_by_keyword] = ACTIONS(1),
    [sym_obvious_keyword] = ACTIONS(1),
    [sym_omitted_keyword] = ACTIONS(1),
    [sym_qed_keyword] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4589),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(4196),
    [aux_sym_source_file_repeat1] = STATE(3693),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(7),
    [sym_extramodular_text] = ACTIONS(9),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(3575),
    [sym_exists] = STATE(3575),
    [sym_temporal_forall] = STATE(4334),
    [sym_temporal_exists] = STATE(4334),
    [sym_langle_bracket] = STATE(126),
    [sym_operator_definition] = STATE(3476),
    [sym_function_definition] = STATE(3476),
    [sym_instance] = STATE(4514),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2599),
    [sym_bound_nonfix_op] = STATE(2599),
    [sym_module_definition] = STATE(3476),
    [sym__expr] = STATE(1346),
    [sym_prefixed_op] = STATE(2680),
    [sym_number] = STATE(2680),
    [sym__nat_number] = STATE(2679),
    [sym_boolean] = STATE(2680),
    [sym_primitive_value_set] = STATE(2680),
    [sym_label] = STATE(2680),
    [sym_subexpression] = STATE(2680),
    [sym_parentheses] = STATE(2680),
    [sym_bounded_quantification] = STATE(2680),
    [sym_unbounded_quantification] = STATE(2680),
    [sym_choose] = STATE(2680),
    [sym_finite_set_literal] = STATE(2680),
    [sym_set_filter] = STATE(2680),
    [sym_set_map] = STATE(2680),
    [sym_function_evaluation] = STATE(2680),
    [sym_function_literal] = STATE(2680),
    [sym_set_of_functions] = STATE(2680),
    [sym_record_literal] = STATE(2680),
    [sym_set_of_records] = STATE(2680),
    [sym_record_value] = STATE(2680),
    [sym_except] = STATE(2680),
    [sym_prev_func_val] = STATE(2680),
    [sym_tuple_literal] = STATE(2680),
    [sym_step_expr_or_stutter] = STATE(2680),
    [sym_step_expr_no_stutter] = STATE(2680),
    [sym_fairness] = STATE(2680),
    [sym_if_then_else] = STATE(2680),
    [sym_case] = STATE(2680),
    [sym_let_in] = STATE(2680),
    [sym_conj_list] = STATE(2680),
    [sym_disj_list] = STATE(2680),
    [sym_lnot] = STATE(227),
    [sym_union] = STATE(210),
    [sym_powerset] = STATE(210),
    [sym_domain] = STATE(262),
    [sym_negative] = STATE(857),
    [sym_enabled] = STATE(259),
    [sym_unchanged] = STATE(259),
    [sym_always] = STATE(259),
    [sym_eventually] = STATE(259),
    [sym_standalone_prefix_op_symbol] = STATE(3849),
    [sym_bound_prefix_op] = STATE(2680),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4297),
    [sym_bound_infix_op] = STATE(2680),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4302),
    [sym_bound_postfix_op] = STATE(2680),
    [sym_assume_prove] = STATE(3483),
    [sym_definition_proof_step] = STATE(4514),
    [sym_have_proof_step] = STATE(4514),
    [sym_witness_proof_step] = STATE(4514),
    [sym_take_proof_step] = STATE(4514),
    [sym_suffices_proof_step] = STATE(4514),
    [sym_case_proof_step] = STATE(4514),
    [sym_pick_proof_step] = STATE(4514),
    [sym_use_or_hide] = STATE(4514),
    [sym_proof_step_ref] = STATE(2600),
    [aux_sym_definition_proof_step_repeat1] = STATE(3304),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
    [sym_qed_keyword] = ACTIONS(243),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(3575),
    [sym_exists] = STATE(3575),
    [sym_temporal_forall] = STATE(4334),
    [sym_temporal_exists] = STATE(4334),
    [sym_langle_bracket] = STATE(126),
    [sym_operator_definition] = STATE(3476),
    [sym_function_definition] = STATE(3476),
    [sym_instance] = STATE(4514),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2599),
    [sym_bound_nonfix_op] = STATE(2599),
    [sym_module_definition] = STATE(3476),
    [sym__expr] = STATE(1346),
    [sym_prefixed_op] = STATE(2680),
    [sym_number] = STATE(2680),
    [sym__nat_number] = STATE(2679),
    [sym_boolean] = STATE(2680),
    [sym_primitive_value_set] = STATE(2680),
    [sym_label] = STATE(2680),
    [sym_subexpression] = STATE(2680),
    [sym_parentheses] = STATE(2680),
    [sym_bounded_quantification] = STATE(2680),
    [sym_unbounded_quantification] = STATE(2680),
    [sym_choose] = STATE(2680),
    [sym_finite_set_literal] = STATE(2680),
    [sym_set_filter] = STATE(2680),
    [sym_set_map] = STATE(2680),
    [sym_function_evaluation] = STATE(2680),
    [sym_function_literal] = STATE(2680),
    [sym_set_of_functions] = STATE(2680),
    [sym_record_literal] = STATE(2680),
    [sym_set_of_records] = STATE(2680),
    [sym_record_value] = STATE(2680),
    [sym_except] = STATE(2680),
    [sym_prev_func_val] = STATE(2680),
    [sym_tuple_literal] = STATE(2680),
    [sym_step_expr_or_stutter] = STATE(2680),
    [sym_step_expr_no_stutter] = STATE(2680),
    [sym_fairness] = STATE(2680),
    [sym_if_then_else] = STATE(2680),
    [sym_case] = STATE(2680),
    [sym_let_in] = STATE(2680),
    [sym_conj_list] = STATE(2680),
    [sym_disj_list] = STATE(2680),
    [sym_lnot] = STATE(227),
    [sym_union] = STATE(210),
    [sym_powerset] = STATE(210),
    [sym_domain] = STATE(262),
    [sym_negative] = STATE(857),
    [sym_enabled] = STATE(259),
    [sym_unchanged] = STATE(259),
    [sym_always] = STATE(259),
    [sym_eventually] = STATE(259),
    [sym_standalone_prefix_op_symbol] = STATE(3849),
    [sym_bound_prefix_op] = STATE(2680),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4297),
    [sym_bound_infix_op] = STATE(2680),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4302),
    [sym_bound_postfix_op] = STATE(2680),
    [sym_assume_prove] = STATE(3483),
    [sym_definition_proof_step] = STATE(4514),
    [sym_have_proof_step] = STATE(4514),
    [sym_witness_proof_step] = STATE(4514),
    [sym_take_proof_step] = STATE(4514),
    [sym_suffices_proof_step] = STATE(4514),
    [sym_case_proof_step] = STATE(4514),
    [sym_pick_proof_step] = STATE(4514),
    [sym_use_or_hide] = STATE(4514),
    [sym_proof_step_ref] = STATE(2600),
    [aux_sym_definition_proof_step_repeat1] = STATE(3304),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
    [sym_qed_keyword] = ACTIONS(245),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(3575),
    [sym_exists] = STATE(3575),
    [sym_temporal_forall] = STATE(4334),
    [sym_temporal_exists] = STATE(4334),
    [sym_langle_bracket] = STATE(126),
    [sym_operator_definition] = STATE(3476),
    [sym_function_definition] = STATE(3476),
    [sym_instance] = STATE(4514),
    [sym_subexpr_prefix] = STATE(1187),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2599),
    [sym_bound_nonfix_op] = STATE(2599),
    [sym_module_definition] = STATE(3476),
    [sym__expr] = STATE(1346),
    [sym_prefixed_op] = STATE(2680),
    [sym_number] = STATE(2680),
    [sym__nat_number] = STATE(2679),
    [sym_boolean] = STATE(2680),
    [sym_primitive_value_set] = STATE(2680),
    [sym_label] = STATE(2680),
    [sym_subexpression] = STATE(2680),
    [sym_parentheses] = STATE(2680),
    [sym_bounded_quantification] = STATE(2680),
    [sym_unbounded_quantification] = STATE(2680),
    [sym_choose] = STATE(2680),
    [sym_finite_set_literal] = STATE(2680),
    [sym_set_filter] = STATE(2680),
    [sym_set_map] = STATE(2680),
    [sym_function_evaluation] = STATE(2680),
    [sym_function_literal] = STATE(2680),
    [sym_set_of_functions] = STATE(2680),
    [sym_record_literal] = STATE(2680),
    [sym_set_of_records] = STATE(2680),
    [sym_record_value] = STATE(2680),
    [sym_except] = STATE(2680),
    [sym_prev_func_val] = STATE(2680),
    [sym_tuple_literal] = STATE(2680),
    [sym_step_expr_or_stutter] = STATE(2680),
    [sym_step_expr_no_stutter] = STATE(2680),
    [sym_fairness] = STATE(2680),
    [sym_if_then_else] = STATE(2680),
    [sym_case] = STATE(2680),
    [sym_let_in] = STATE(2680),
    [sym_conj_list] = STATE(2680),
    [sym_disj_list] = STATE(2680),
    [sym_lnot] = STATE(227),
    [sym_union] = STATE(210),
    [sym_powerset] = STATE(210),
    [sym_domain] = STATE(262),
    [sym_negative] = STATE(857),
    [sym_enabled] = STATE(259),
    [sym_unchanged] = STATE(259),
    [sym_always] = STATE(259),
    [sym_eventually] = STATE(259),
    [sym_standalone_prefix_op_symbol] = STATE(3849),
    [sym_bound_prefix_op] = STATE(2680),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4297),
    [sym_bound_infix_op] = STATE(2680),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4302),
    [sym_bound_postfix_op] = STATE(2680),
    [sym_assume_prove] = STATE(3483),
    [sym_definition_proof_step] = STATE(4514),
    [sym_have_proof_step] = STATE(4514),
    [sym_witness_proof_step] = STATE(4514),
    [sym_take_proof_step] = STATE(4514),
    [sym_suffices_proof_step] = STATE(4514),
    [sym_case_proof_step] = STATE(4514),
    [sym_pick_proof_step] = STATE(4514),
    [sym_use_or_hide] = STATE(4514),
    [sym_proof_step_ref] = STATE(2600),
    [aux_sym_definition_proof_step_repeat1] = STATE(3304),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym__expr] = STATE(1117),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STATE(2206),
    [sym_fairness] = STATE(2206),
    [sym_if_then_else] = STATE(2206),
    [sym_case] = STATE(2206),
    [sym_let_in] = STATE(2206),
    [sym_conj_list] = STATE(2206),
    [sym_disj_list] = STATE(2206),
    [sym_lnot] = STATE(220),
    [sym_union] = STATE(218),
    [sym_powerset] = STATE(218),
    [sym_domain] = STATE(216),
    [sym_negative] = STATE(802),
    [sym_enabled] = STATE(214),
    [sym_unchanged] = STATE(214),
    [sym_always] = STATE(214),
    [sym_eventually] = STATE(214),
    [sym_standalone_prefix_op_symbol] = STATE(4314),
    [sym_bound_prefix_op] = STATE(2206),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2206),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4314),
    [sym_bound_postfix_op] = STATE(2206),
    [sym_proof_step_ref] = STATE(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym__expr] = STATE(1122),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STATE(2206),
    [sym_fairness] = STATE(2206),
    [sym_if_then_else] = STATE(2206),
    [sym_case] = STATE(2206),
    [sym_let_in] = STATE(2206),
    [sym_conj_list] = STATE(2206),
    [sym_disj_list] = STATE(2206),
    [sym_lnot] = STATE(220),
    [sym_union] = STATE(218),
    [sym_powerset] = STATE(218),
    [sym_domain] = STATE(216),
    [sym_negative] = STATE(802),
    [sym_enabled] = STATE(214),
    [sym_unchanged] = STATE(214),
    [sym_always] = STATE(214),
    [sym_eventually] = STATE(214),
    [sym_standalone_prefix_op_symbol] = STATE(4314),
    [sym_bound_prefix_op] = STATE(2206),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2206),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4314),
    [sym_bound_postfix_op] = STATE(2206),
    [sym_proof_step_ref] = STATE(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym__expr] = STATE(1121),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STATE(2206),
    [sym_fairness] = STATE(2206),
    [sym_if_then_else] = STATE(2206),
    [sym_case] = STATE(2206),
    [sym_let_in] = STATE(2206),
    [sym_conj_list] = STATE(2206),
    [sym_disj_list] = STATE(2206),
    [sym_lnot] = STATE(220),
    [sym_union] = STATE(218),
    [sym_powerset] = STATE(218),
    [sym_domain] = STATE(216),
    [sym_negative] = STATE(802),
    [sym_enabled] = STATE(214),
    [sym_unchanged] = STATE(214),
    [sym_always] = STATE(214),
    [sym_eventually] = STATE(214),
    [sym_standalone_prefix_op_symbol] = STATE(4314),
    [sym_bound_prefix_op] = STATE(2206),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2206),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4314),
    [sym_bound_postfix_op] = STATE(2206),
    [sym_proof_step_ref] = STATE(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym__expr] = STATE(1090),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STATE(2206),
    [sym_fairness] = STATE(2206),
    [sym_if_then_else] = STATE(2206),
    [sym_case] = STATE(2206),
    [sym_let_in] = STATE(2206),
    [sym_conj_list] = STATE(2206),
    [sym_disj_list] = STATE(2206),
    [sym_lnot] = STATE(220),
    [sym_union] = STATE(218),
    [sym_powerset] = STATE(218),
    [sym_domain] = STATE(216),
    [sym_negative] = STATE(802),
    [sym_enabled] = STATE(214),
    [sym_unchanged] = STATE(214),
    [sym_always] = STATE(214),
    [sym_eventually] = STATE(214),
    [sym_standalone_prefix_op_symbol] = STATE(4314),
    [sym_bound_prefix_op] = STATE(2206),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2206),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4314),
    [sym_bound_postfix_op] = STATE(2206),
    [sym_proof_step_ref] = STATE(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3599),
    [sym_exists] = STATE(3599),
    [sym_temporal_forall] = STATE(4451),
    [sym_temporal_exists] = STATE(4451),
    [sym_langle_bracket] = STATE(141),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2483),
    [sym_bound_nonfix_op] = STATE(2483),
    [sym__expr] = STATE(1711),
    [sym_prefixed_op] = STATE(2587),
    [sym_number] = STATE(2587),
    [sym__nat_number] = STATE(2591),
    [sym_boolean] = STATE(2587),
    [sym_primitive_value_set] = STATE(2587),
    [sym_label] = STATE(2587),
    [sym_subexpression] = STATE(2587),
    [sym_parentheses] = STATE(2587),
    [sym_bounded_quantification] = STATE(2587),
    [sym_unbounded_quantification] = STATE(2587),
    [sym_choose] = STATE(2587),
    [sym_finite_set_literal] = STATE(2587),
    [sym_set_filter] = STATE(2587),
    [sym_set_map] = STATE(2587),
    [sym_function_evaluation] = STATE(2587),
    [sym_function_literal] = STATE(2587),
    [sym_set_of_functions] = STATE(2587),
    [sym_record_literal] = STATE(2587),
    [sym_set_of_records] = STATE(2587),
    [sym_record_value] = STATE(2587),
    [sym_except] = STATE(2587),
    [sym_prev_func_val] = STATE(2587),
    [sym_tuple_literal] = STATE(2587),
    [sym_step_expr_or_stutter] = STATE(2587),
    [sym_step_expr_no_stutter] = STATE(2587),
    [sym_fairness] = STATE(2587),
    [sym_if_then_else] = STATE(2587),
    [sym_case] = STATE(2587),
    [sym_let_in] = STATE(2587),
    [sym_conj_list] = STATE(2587),
    [sym_disj_list] = STATE(2587),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(35),
    [sym_powerset] = STATE(35),
    [sym_domain] = STATE(34),
    [sym_negative] = STATE(603),
    [sym_enabled] = STATE(33),
    [sym_unchanged] = STATE(33),
    [sym_always] = STATE(33),
    [sym_eventually] = STATE(33),
    [sym_standalone_prefix_op_symbol] = STATE(4278),
    [sym_bound_prefix_op] = STATE(2587),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4259),
    [sym_bound_infix_op] = STATE(2587),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4278),
    [sym_bound_postfix_op] = STATE(2587),
    [sym_assume_prove] = STATE(4276),
    [sym_inner_assume_prove] = STATE(3852),
    [sym_new] = STATE(3852),
    [sym_level] = STATE(3313),
    [sym_proof_step_ref] = STATE(2479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(3599),
    [sym_exists] = STATE(3599),
    [sym_temporal_forall] = STATE(4451),
    [sym_temporal_exists] = STATE(4451),
    [sym_langle_bracket] = STATE(141),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2483),
    [sym_bound_nonfix_op] = STATE(2483),
    [sym__expr] = STATE(1797),
    [sym_prefixed_op] = STATE(2587),
    [sym_number] = STATE(2587),
    [sym__nat_number] = STATE(2591),
    [sym_boolean] = STATE(2587),
    [sym_primitive_value_set] = STATE(2587),
    [sym_label] = STATE(2587),
    [sym_subexpression] = STATE(2587),
    [sym_parentheses] = STATE(2587),
    [sym_bounded_quantification] = STATE(2587),
    [sym_unbounded_quantification] = STATE(2587),
    [sym_choose] = STATE(2587),
    [sym_finite_set_literal] = STATE(2587),
    [sym_set_filter] = STATE(2587),
    [sym_set_map] = STATE(2587),
    [sym_function_evaluation] = STATE(2587),
    [sym_function_literal] = STATE(2587),
    [sym_set_of_functions] = STATE(2587),
    [sym_record_literal] = STATE(2587),
    [sym_set_of_records] = STATE(2587),
    [sym_record_value] = STATE(2587),
    [sym_except] = STATE(2587),
    [sym_prev_func_val] = STATE(2587),
    [sym_tuple_literal] = STATE(2587),
    [sym_step_expr_or_stutter] = STATE(2587),
    [sym_step_expr_no_stutter] = STATE(2587),
    [sym_fairness] = STATE(2587),
    [sym_if_then_else] = STATE(2587),
    [sym_case] = STATE(2587),
    [sym_let_in] = STATE(2587),
    [sym_conj_list] = STATE(2587),
    [sym_disj_list] = STATE(2587),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(35),
    [sym_powerset] = STATE(35),
    [sym_domain] = STATE(34),
    [sym_negative] = STATE(603),
    [sym_enabled] = STATE(33),
    [sym_unchanged] = STATE(33),
    [sym_always] = STATE(33),
    [sym_eventually] = STATE(33),
    [sym_standalone_prefix_op_symbol] = STATE(4278),
    [sym_bound_prefix_op] = STATE(2587),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4259),
    [sym_bound_infix_op] = STATE(2587),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4278),
    [sym_bound_postfix_op] = STATE(2587),
    [sym_assume_prove] = STATE(4276),
    [sym_inner_assume_prove] = STATE(4299),
    [sym_new] = STATE(4299),
    [sym_level] = STATE(3313),
    [sym_proof_step_ref] = STATE(2479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(3599),
    [sym_exists] = STATE(3599),
    [sym_temporal_forall] = STATE(4451),
    [sym_temporal_exists] = STATE(4451),
    [sym_langle_bracket] = STATE(141),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2483),
    [sym_bound_nonfix_op] = STATE(2483),
    [sym__expr] = STATE(1777),
    [sym_prefixed_op] = STATE(2587),
    [sym_number] = STATE(2587),
    [sym__nat_number] = STATE(2591),
    [sym_boolean] = STATE(2587),
    [sym_primitive_value_set] = STATE(2587),
    [sym_label] = STATE(2587),
    [sym_subexpression] = STATE(2587),
    [sym_parentheses] = STATE(2587),
    [sym_bounded_quantification] = STATE(2587),
    [sym_unbounded_quantification] = STATE(2587),
    [sym_choose] = STATE(2587),
    [sym_finite_set_literal] = STATE(2587),
    [sym_set_filter] = STATE(2587),
    [sym_set_map] = STATE(2587),
    [sym_function_evaluation] = STATE(2587),
    [sym_function_literal] = STATE(2587),
    [sym_set_of_functions] = STATE(2587),
    [sym_record_literal] = STATE(2587),
    [sym_set_of_records] = STATE(2587),
    [sym_record_value] = STATE(2587),
    [sym_except] = STATE(2587),
    [sym_prev_func_val] = STATE(2587),
    [sym_tuple_literal] = STATE(2587),
    [sym_step_expr_or_stutter] = STATE(2587),
    [sym_step_expr_no_stutter] = STATE(2587),
    [sym_fairness] = STATE(2587),
    [sym_if_then_else] = STATE(2587),
    [sym_case] = STATE(2587),
    [sym_let_in] = STATE(2587),
    [sym_conj_list] = STATE(2587),
    [sym_disj_list] = STATE(2587),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(35),
    [sym_powerset] = STATE(35),
    [sym_domain] = STATE(34),
    [sym_negative] = STATE(603),
    [sym_enabled] = STATE(33),
    [sym_unchanged] = STATE(33),
    [sym_always] = STATE(33),
    [sym_eventually] = STATE(33),
    [sym_standalone_prefix_op_symbol] = STATE(4278),
    [sym_bound_prefix_op] = STATE(2587),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4259),
    [sym_bound_infix_op] = STATE(2587),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4278),
    [sym_bound_postfix_op] = STATE(2587),
    [sym_assume_prove] = STATE(4276),
    [sym_inner_assume_prove] = STATE(3968),
    [sym_new] = STATE(3968),
    [sym_level] = STATE(3313),
    [sym_proof_step_ref] = STATE(2479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3599),
    [sym_exists] = STATE(3599),
    [sym_temporal_forall] = STATE(4451),
    [sym_temporal_exists] = STATE(4451),
    [sym_langle_bracket] = STATE(141),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2483),
    [sym_bound_nonfix_op] = STATE(2483),
    [sym__expr] = STATE(1734),
    [sym_prefixed_op] = STATE(2587),
    [sym_number] = STATE(2587),
    [sym__nat_number] = STATE(2591),
    [sym_boolean] = STATE(2587),
    [sym_primitive_value_set] = STATE(2587),
    [sym_label] = STATE(2587),
    [sym_subexpression] = STATE(2587),
    [sym_parentheses] = STATE(2587),
    [sym_bounded_quantification] = STATE(2587),
    [sym_unbounded_quantification] = STATE(2587),
    [sym_choose] = STATE(2587),
    [sym_finite_set_literal] = STATE(2587),
    [sym_set_filter] = STATE(2587),
    [sym_set_map] = STATE(2587),
    [sym_function_evaluation] = STATE(2587),
    [sym_function_literal] = STATE(2587),
    [sym_set_of_functions] = STATE(2587),
    [sym_record_literal] = STATE(2587),
    [sym_set_of_records] = STATE(2587),
    [sym_record_value] = STATE(2587),
    [sym_except] = STATE(2587),
    [sym_prev_func_val] = STATE(2587),
    [sym_tuple_literal] = STATE(2587),
    [sym_step_expr_or_stutter] = STATE(2587),
    [sym_step_expr_no_stutter] = STATE(2587),
    [sym_fairness] = STATE(2587),
    [sym_if_then_else] = STATE(2587),
    [sym_case] = STATE(2587),
    [sym_let_in] = STATE(2587),
    [sym_conj_list] = STATE(2587),
    [sym_disj_list] = STATE(2587),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(35),
    [sym_powerset] = STATE(35),
    [sym_domain] = STATE(34),
    [sym_negative] = STATE(603),
    [sym_enabled] = STATE(33),
    [sym_unchanged] = STATE(33),
    [sym_always] = STATE(33),
    [sym_eventually] = STATE(33),
    [sym_standalone_prefix_op_symbol] = STATE(4278),
    [sym_bound_prefix_op] = STATE(2587),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4259),
    [sym_bound_infix_op] = STATE(2587),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4278),
    [sym_bound_postfix_op] = STATE(2587),
    [sym_assume_prove] = STATE(4276),
    [sym_inner_assume_prove] = STATE(4119),
    [sym_new] = STATE(4119),
    [sym_level] = STATE(3313),
    [sym_proof_step_ref] = STATE(2479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4405),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(373),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3242),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [anon_sym_ONLY] = ACTIONS(413),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3260),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [anon_sym_ONLY] = ACTIONS(437),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3243),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [anon_sym_ONLY] = ACTIONS(439),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4437),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(441),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4523),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(443),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3242),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3264),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4625),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4437),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3248),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [24] = {
    [sym_block_comment] = STATE(24),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4354),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [25] = {
    [sym_block_comment] = STATE(25),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4475),
    [sym_temporal_exists] = STATE(4475),
    [sym_langle_bracket] = STATE(111),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2122),
    [sym_bound_nonfix_op] = STATE(2122),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2177),
    [sym_number] = STATE(2177),
    [sym__nat_number] = STATE(2173),
    [sym_boolean] = STATE(2177),
    [sym_primitive_value_set] = STATE(2177),
    [sym_label] = STATE(2177),
    [sym_subexpression] = STATE(2177),
    [sym_parentheses] = STATE(2177),
    [sym_bounded_quantification] = STATE(2177),
    [sym_unbounded_quantification] = STATE(2177),
    [sym_choose] = STATE(2177),
    [sym_finite_set_literal] = STATE(2177),
    [sym_set_filter] = STATE(2177),
    [sym_set_map] = STATE(2177),
    [sym_function_evaluation] = STATE(2177),
    [sym_function_literal] = STATE(2177),
    [sym_set_of_functions] = STATE(2177),
    [sym_record_literal] = STATE(2177),
    [sym_set_of_records] = STATE(2177),
    [sym_record_value] = STATE(2177),
    [sym_except] = STATE(2177),
    [sym_prev_func_val] = STATE(2177),
    [sym_tuple_literal] = STATE(2177),
    [sym_step_expr_or_stutter] = STATE(2177),
    [sym_step_expr_no_stutter] = STATE(2177),
    [sym_fairness] = STATE(2177),
    [sym_if_then_else] = STATE(2177),
    [sym_case] = STATE(2177),
    [sym_let_in] = STATE(2177),
    [sym_conj_list] = STATE(2177),
    [sym_disj_list] = STATE(2177),
    [sym_lnot] = STATE(282),
    [sym_union] = STATE(283),
    [sym_powerset] = STATE(283),
    [sym_domain] = STATE(289),
    [sym_negative] = STATE(981),
    [sym_enabled] = STATE(290),
    [sym_unchanged] = STATE(290),
    [sym_always] = STATE(290),
    [sym_eventually] = STATE(290),
    [sym_standalone_prefix_op_symbol] = STATE(4271),
    [sym_bound_prefix_op] = STATE(2177),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4263),
    [sym_bound_infix_op] = STATE(2177),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4271),
    [sym_bound_postfix_op] = STATE(2177),
    [sym_use_body] = STATE(3260),
    [sym_use_body_expr] = STATE(3180),
    [sym_use_body_def] = STATE(3253),
    [sym_module_ref] = STATE(3142),
    [sym_proof_step_ref] = STATE(2116),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(397),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(401),
    [anon_sym_SF_] = ACTIONS(403),
    [anon_sym_WF_] = ACTIONS(403),
    [anon_sym_CHOOSE] = ACTIONS(405),
    [anon_sym_IF] = ACTIONS(407),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(409),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(411),
    [anon_sym_DEFS] = ACTIONS(411),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_LBRACK] = ACTIONS(419),
    [aux_sym_child_id_token1] = ACTIONS(421),
    [sym__real_number] = ACTIONS(423),
    [sym__binary_number] = ACTIONS(423),
    [sym__octal_number] = ACTIONS(423),
    [sym__hex_number] = ACTIONS(423),
    [sym_string] = ACTIONS(425),
    [anon_sym_TRUE] = ACTIONS(427),
    [anon_sym_FALSE] = ACTIONS(427),
    [anon_sym_STRING] = ACTIONS(429),
    [anon_sym_BOOLEAN] = ACTIONS(429),
    [anon_sym_Nat] = ACTIONS(429),
    [anon_sym_Int] = ACTIONS(429),
    [anon_sym_Real] = ACTIONS(429),
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(433),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(435),
  },
  [26] = {
    [sym_block_comment] = STATE(26),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym__expr] = STATE(1502),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(295),
    [sym_union] = STATE(294),
    [sym_powerset] = STATE(294),
    [sym_domain] = STATE(293),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(292),
    [sym_unchanged] = STATE(292),
    [sym_always] = STATE(292),
    [sym_eventually] = STATE(292),
    [sym_standalone_prefix_op_symbol] = STATE(4288),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(4301),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(4288),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_use_body] = STATE(4405),
    [sym_use_body_expr] = STATE(3789),
    [sym_use_body_def] = STATE(4422),
    [sym_module_ref] = STATE(3680),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [27] = {
    [sym_block_comment] = STATE(27),
    [sym_forall] = STATE(3599),
    [sym_exists] = STATE(3599),
    [sym_temporal_forall] = STATE(4451),
    [sym_temporal_exists] = STATE(4451),
    [sym_langle_bracket] = STATE(141),
    [sym_operator_declaration] = STATE(3227),
    [sym__id_or_op_declaration] = STATE(3970),
    [sym__op_or_expr] = STATE(4118),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2483),
    [sym_bound_nonfix_op] = STATE(2483),
    [sym_lambda] = STATE(3212),
    [sym__expr] = STATE(1792),
    [sym_prefixed_op] = STATE(2587),
    [sym_number] = STATE(2587),
    [sym__nat_number] = STATE(2591),
    [sym_boolean] = STATE(2587),
    [sym_primitive_value_set] = STATE(2587),
    [sym_label] = STATE(2587),
    [sym_subexpression] = STATE(2587),
    [sym_parentheses] = STATE(2587),
    [sym_bounded_quantification] = STATE(2587),
    [sym_unbounded_quantification] = STATE(2587),
    [sym_choose] = STATE(2587),
    [sym_finite_set_literal] = STATE(2587),
    [sym_set_filter] = STATE(2587),
    [sym_set_map] = STATE(2587),
    [sym_function_evaluation] = STATE(2587),
    [sym_function_literal] = STATE(2587),
    [sym_set_of_functions] = STATE(2587),
    [sym_record_literal] = STATE(2587),
    [sym_set_of_records] = STATE(2587),
    [sym_record_value] = STATE(2587),
    [sym_except] = STATE(2587),
    [sym_prev_func_val] = STATE(2587),
    [sym_tuple_literal] = STATE(2587),
    [sym_step_expr_or_stutter] = STATE(2587),
    [sym_step_expr_no_stutter] = STATE(2587),
    [sym_fairness] = STATE(2587),
    [sym_if_then_else] = STATE(2587),
    [sym_case] = STATE(2587),
    [sym_let_in] = STATE(2587),
    [sym_conj_list] = STATE(2587),
    [sym_disj_list] = STATE(2587),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(35),
    [sym_powerset] = STATE(35),
    [sym_domain] = STATE(34),
    [sym_negative] = STATE(603),
    [sym_enabled] = STATE(33),
    [sym_unchanged] = STATE(33),
    [sym_always] = STATE(33),
    [sym_eventually] = STATE(33),
    [sym_standalone_prefix_op_symbol] = STATE(3699),
    [sym_bound_prefix_op] = STATE(2587),
    [sym_implies] = STATE(3507),
    [sym_plus_arrow] = STATE(3507),
    [sym_equiv] = STATE(3507),
    [sym_iff] = STATE(3507),
    [sym_leads_to] = STATE(3507),
    [sym_land] = STATE(3507),
    [sym_lor] = STATE(3507),
    [sym_assign] = STATE(3507),
    [sym_bnf_rule] = STATE(3507),
    [sym_eq] = STATE(3507),
    [sym_neq] = STATE(3507),
    [sym_lt] = STATE(3507),
    [sym_leq] = STATE(3507),
    [sym_geq] = STATE(3507),
    [sym_approx] = STATE(3507),
    [sym_rs_ttile] = STATE(3507),
    [sym_rd_ttile] = STATE(3507),
    [sym_ls_ttile] = STATE(3507),
    [sym_ld_ttile] = STATE(3507),
    [sym_asymp] = STATE(3507),
    [sym_cong] = STATE(3507),
    [sym_doteq] = STATE(3507),
    [sym_gg] = STATE(3507),
    [sym_ll] = STATE(3507),
    [sym_in] = STATE(3507),
    [sym_notin] = STATE(3507),
    [sym_prec] = STATE(3507),
    [sym_succ] = STATE(3507),
    [sym_preceq] = STATE(3507),
    [sym_succeq] = STATE(3507),
    [sym_sim] = STATE(3507),
    [sym_simeq] = STATE(3507),
    [sym_sqsubset] = STATE(3507),
    [sym_sqsupset] = STATE(3507),
    [sym_sqsubseteq] = STATE(3507),
    [sym_sqsupseteq] = STATE(3507),
    [sym_cap] = STATE(3507),
    [sym_cup] = STATE(3507),
    [sym_dots_2] = STATE(3507),
    [sym_dots_3] = STATE(3507),
    [sym_oplus] = STATE(3507),
    [sym_ominus] = STATE(3507),
    [sym_vertvert] = STATE(3507),
    [sym_minus] = STATE(3507),
    [sym_odot] = STATE(3507),
    [sym_oslash] = STATE(3507),
    [sym_otimes] = STATE(3507),
    [sym_bigcirc] = STATE(3507),
    [sym_bullet] = STATE(3507),
    [sym_div] = STATE(3507),
    [sym_circ] = STATE(3507),
    [sym_star] = STATE(3507),
    [sym_excl] = STATE(3507),
    [sym_qq] = STATE(3507),
    [sym_sqcap] = STATE(3507),
    [sym_sqcup] = STATE(3507),
    [sym_uplus] = STATE(3507),
    [sym_wr] = STATE(3507),
    [sym_cdot] = STATE(3507),
    [sym_infix_op_symbol] = STATE(3776),
    [sym_bound_infix_op] = STATE(2587),
    [sym_sup_plus] = STATE(3318),
    [sym_postfix_op_symbol] = STATE(3804),
    [sym_bound_postfix_op] = STATE(2587),
    [sym_proof_step_ref] = STATE(2479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [sym_placeholder] = ACTIONS(445),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_LAMBDA] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(451),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [28] = {
    [sym_block_comment] = STATE(28),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym__op_or_expr] = STATE(4277),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym_lambda] = STATE(3474),
    [sym__expr] = STATE(1796),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(62),
    [sym_union] = STATE(65),
    [sym_powerset] = STATE(65),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(70),
    [sym_unchanged] = STATE(70),
    [sym_always] = STATE(70),
    [sym_eventually] = STATE(70),
    [sym_standalone_prefix_op_symbol] = STATE(3798),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3396),
    [sym_plus_arrow] = STATE(3396),
    [sym_equiv] = STATE(3396),
    [sym_iff] = STATE(3396),
    [sym_leads_to] = STATE(3396),
    [sym_land] = STATE(3396),
    [sym_lor] = STATE(3396),
    [sym_assign] = STATE(3396),
    [sym_bnf_rule] = STATE(3396),
    [sym_eq] = STATE(3396),
    [sym_neq] = STATE(3396),
    [sym_lt] = STATE(3396),
    [sym_leq] = STATE(3396),
    [sym_geq] = STATE(3396),
    [sym_approx] = STATE(3396),
    [sym_rs_ttile] = STATE(3396),
    [sym_rd_ttile] = STATE(3396),
    [sym_ls_ttile] = STATE(3396),
    [sym_ld_ttile] = STATE(3396),
    [sym_asymp] = STATE(3396),
    [sym_cong] = STATE(3396),
    [sym_doteq] = STATE(3396),
    [sym_gg] = STATE(3396),
    [sym_ll] = STATE(3396),
    [sym_in] = STATE(3396),
    [sym_notin] = STATE(3396),
    [sym_prec] = STATE(3396),
    [sym_succ] = STATE(3396),
    [sym_preceq] = STATE(3396),
    [sym_succeq] = STATE(3396),
    [sym_sim] = STATE(3396),
    [sym_simeq] = STATE(3396),
    [sym_sqsubset] = STATE(3396),
    [sym_sqsupset] = STATE(3396),
    [sym_sqsubseteq] = STATE(3396),
    [sym_sqsupseteq] = STATE(3396),
    [sym_cap] = STATE(3396),
    [sym_cup] = STATE(3396),
    [sym_dots_2] = STATE(3396),
    [sym_dots_3] = STATE(3396),
    [sym_oplus] = STATE(3396),
    [sym_ominus] = STATE(3396),
    [sym_vertvert] = STATE(3396),
    [sym_minus] = STATE(3396),
    [sym_odot] = STATE(3396),
    [sym_oslash] = STATE(3396),
    [sym_otimes] = STATE(3396),
    [sym_bigcirc] = STATE(3396),
    [sym_bullet] = STATE(3396),
    [sym_div] = STATE(3396),
    [sym_circ] = STATE(3396),
    [sym_star] = STATE(3396),
    [sym_excl] = STATE(3396),
    [sym_qq] = STATE(3396),
    [sym_sqcap] = STATE(3396),
    [sym_sqcup] = STATE(3396),
    [sym_uplus] = STATE(3396),
    [sym_wr] = STATE(3396),
    [sym_cdot] = STATE(3396),
    [sym_infix_op_symbol] = STATE(3816),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3417),
    [sym_postfix_op_symbol] = STATE(3798),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_module_ref] = STATE(4277),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(453),
    [anon_sym_2] = ACTIONS(455),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(457),
    [anon_sym_10] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(459),
    [anon_sym_ENABLED] = ACTIONS(461),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(463),
    [anon_sym_DOMAIN] = ACTIONS(465),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(467),
    [anon_sym_LAMBDA] = ACTIONS(469),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(471),
    [anon_sym_BSLASHlnot] = ACTIONS(473),
    [anon_sym_BSLASHneg] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(475),
    [anon_sym_12] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(477),
    [sym_negative_dot] = ACTIONS(479),
    [anon_sym_LT_GT] = ACTIONS(481),
    [anon_sym_13] = ACTIONS(481),
    [anon_sym_EQ_GT] = ACTIONS(483),
    [anon_sym_14] = ACTIONS(483),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(485),
    [anon_sym_15] = ACTIONS(485),
    [anon_sym_BSLASHequiv] = ACTIONS(487),
    [anon_sym_16] = ACTIONS(487),
    [anon_sym_LT_EQ_GT] = ACTIONS(489),
    [anon_sym_17] = ACTIONS(489),
    [anon_sym_TILDE_GT] = ACTIONS(491),
    [anon_sym_18] = ACTIONS(491),
    [anon_sym_SLASH_BSLASH] = ACTIONS(493),
    [anon_sym_BSLASHland] = ACTIONS(493),
    [anon_sym_19] = ACTIONS(493),
    [anon_sym_BSLASH_SLASH] = ACTIONS(495),
    [anon_sym_BSLASHlor] = ACTIONS(495),
    [anon_sym_20] = ACTIONS(495),
    [anon_sym_COLON_EQ] = ACTIONS(497),
    [anon_sym_21] = ACTIONS(497),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(499),
    [anon_sym_22] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(501),
    [anon_sym_POUND] = ACTIONS(503),
    [anon_sym_23] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(505),
    [sym_gt] = ACTIONS(507),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_LT] = ACTIONS(511),
    [anon_sym_BSLASHleq] = ACTIONS(511),
    [anon_sym_24] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_BSLASHgeq] = ACTIONS(513),
    [anon_sym_25] = ACTIONS(513),
    [anon_sym_BSLASHapprox] = ACTIONS(515),
    [anon_sym_26] = ACTIONS(515),
    [anon_sym_PIPE_DASH] = ACTIONS(517),
    [anon_sym_27] = ACTIONS(517),
    [anon_sym_PIPE_EQ] = ACTIONS(519),
    [anon_sym_28] = ACTIONS(519),
    [anon_sym_DASH_PIPE] = ACTIONS(521),
    [anon_sym_29] = ACTIONS(521),
    [anon_sym_EQ_PIPE] = ACTIONS(523),
    [anon_sym_30] = ACTIONS(523),
    [anon_sym_BSLASHasymp] = ACTIONS(525),
    [anon_sym_31] = ACTIONS(525),
    [anon_sym_BSLASHcong] = ACTIONS(527),
    [anon_sym_32] = ACTIONS(527),
    [anon_sym_BSLASHdoteq] = ACTIONS(529),
    [anon_sym_33] = ACTIONS(529),
    [anon_sym_BSLASHgg] = ACTIONS(531),
    [anon_sym_34] = ACTIONS(531),
    [anon_sym_BSLASHll] = ACTIONS(533),
    [anon_sym_35] = ACTIONS(533),
    [anon_sym_BSLASHnotin] = ACTIONS(535),
    [anon_sym_36] = ACTIONS(535),
    [anon_sym_BSLASHprec] = ACTIONS(537),
    [anon_sym_37] = ACTIONS(539),
    [anon_sym_BSLASHsucc] = ACTIONS(541),
    [anon_sym_38] = ACTIONS(543),
    [anon_sym_BSLASHpreceq] = ACTIONS(545),
    [anon_sym_39] = ACTIONS(545),
    [anon_sym_BSLASHsucceq] = ACTIONS(547),
    [anon_sym_40] = ACTIONS(547),
    [anon_sym_BSLASHsim] = ACTIONS(549),
    [anon_sym_42] = ACTIONS(551),
    [anon_sym_BSLASHsimeq] = ACTIONS(553),
    [anon_sym_43] = ACTIONS(553),
    [anon_sym_BSLASHsqsubset] = ACTIONS(555),
    [anon_sym_44] = ACTIONS(557),
    [anon_sym_BSLASHsqsupset] = ACTIONS(559),
    [anon_sym_45] = ACTIONS(561),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(563),
    [anon_sym_46] = ACTIONS(563),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(565),
    [anon_sym_47] = ACTIONS(565),
    [sym_compose] = ACTIONS(567),
    [sym_map_to] = ACTIONS(567),
    [sym_map_from] = ACTIONS(567),
    [sym_setminus] = ACTIONS(507),
    [anon_sym_BSLASHcap] = ACTIONS(569),
    [anon_sym_BSLASHintersect] = ACTIONS(569),
    [anon_sym_52] = ACTIONS(569),
    [anon_sym_BSLASHcup] = ACTIONS(571),
    [anon_sym_BSLASHunion] = ACTIONS(571),
    [anon_sym_53] = ACTIONS(571),
    [anon_sym_DOT_DOT] = ACTIONS(573),
    [anon_sym_54] = ACTIONS(575),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(577),
    [anon_sym_55] = ACTIONS(577),
    [sym_plus] = ACTIONS(507),
    [sym_plusplus] = ACTIONS(567),
    [anon_sym_BSLASHoplus] = ACTIONS(579),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(579),
    [anon_sym_56] = ACTIONS(579),
    [anon_sym_BSLASHominus] = ACTIONS(581),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(581),
    [anon_sym_57] = ACTIONS(581),
    [sym_mod] = ACTIONS(507),
    [sym_modmod] = ACTIONS(567),
    [sym_vert] = ACTIONS(507),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_58] = ACTIONS(583),
    [sym_minusminus] = ACTIONS(567),
    [sym_amp] = ACTIONS(507),
    [sym_ampamp] = ACTIONS(567),
    [anon_sym_BSLASHodot] = ACTIONS(585),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(585),
    [anon_sym_59] = ACTIONS(585),
    [anon_sym_BSLASHoslash] = ACTIONS(587),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(587),
    [anon_sym_60] = ACTIONS(587),
    [anon_sym_BSLASHotimes] = ACTIONS(589),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(589),
    [anon_sym_61] = ACTIONS(589),
    [sym_mul] = ACTIONS(507),
    [sym_mulmul] = ACTIONS(567),
    [sym_slash] = ACTIONS(507),
    [sym_slashslash] = ACTIONS(567),
    [anon_sym_BSLASHbigcirc] = ACTIONS(591),
    [anon_sym_62] = ACTIONS(591),
    [anon_sym_BSLASHbullet] = ACTIONS(593),
    [anon_sym_63] = ACTIONS(593),
    [anon_sym_BSLASHdiv] = ACTIONS(595),
    [anon_sym_64] = ACTIONS(595),
    [anon_sym_BSLASHo] = ACTIONS(597),
    [anon_sym_BSLASHcirc] = ACTIONS(599),
    [anon_sym_65] = ACTIONS(599),
    [anon_sym_BSLASHstar] = ACTIONS(601),
    [anon_sym_66] = ACTIONS(601),
    [anon_sym_BANG_BANG] = ACTIONS(603),
    [anon_sym_67] = ACTIONS(603),
    [anon_sym_QMARK_QMARK] = ACTIONS(605),
    [anon_sym_68] = ACTIONS(605),
    [sym_hashhash] = ACTIONS(567),
    [sym_dol] = ACTIONS(507),
    [sym_doldol] = ACTIONS(567),
    [anon_sym_BSLASHsqcap] = ACTIONS(607),
    [anon_sym_69] = ACTIONS(607),
    [anon_sym_BSLASHsqcup] = ACTIONS(609),
    [anon_sym_70] = ACTIONS(609),
    [anon_sym_BSLASHuplus] = ACTIONS(611),
    [anon_sym_71] = ACTIONS(611),
    [anon_sym_BSLASHwr] = ACTIONS(613),
    [anon_sym_73] = ACTIONS(613),
    [anon_sym_BSLASHcdot] = ACTIONS(615),
    [anon_sym_74] = ACTIONS(615),
    [sym_pow] = ACTIONS(507),
    [sym_powpow] = ACTIONS(567),
    [anon_sym_CARET_PLUS] = ACTIONS(617),
    [anon_sym_75] = ACTIONS(617),
    [sym_asterisk] = ACTIONS(619),
    [sym_sup_hash] = ACTIONS(619),
    [sym_prime] = ACTIONS(619),
    [sym__indent] = ACTIONS(395),
  },
  [29] = {
    [sym_block_comment] = STATE(29),
    [sym_forall] = STATE(3554),
    [sym_exists] = STATE(3554),
    [sym_temporal_forall] = STATE(4327),
    [sym_temporal_exists] = STATE(4327),
    [sym_langle_bracket] = STATE(88),
    [sym__op_or_expr] = STATE(3890),
    [sym_subexpr_prefix] = STATE(1197),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2751),
    [sym_bound_nonfix_op] = STATE(2751),
    [sym_lambda] = STATE(3474),
    [sym__expr] = STATE(1796),
    [sym_prefixed_op] = STATE(2880),
    [sym_number] = STATE(2880),
    [sym__nat_number] = STATE(2881),
    [sym_boolean] = STATE(2880),
    [sym_primitive_value_set] = STATE(2880),
    [sym_label] = STATE(2880),
    [sym_subexpression] = STATE(2880),
    [sym_parentheses] = STATE(2880),
    [sym_bounded_quantification] = STATE(2880),
    [sym_unbounded_quantification] = STATE(2880),
    [sym_choose] = STATE(2880),
    [sym_finite_set_literal] = STATE(2880),
    [sym_set_filter] = STATE(2880),
    [sym_set_map] = STATE(2880),
    [sym_function_evaluation] = STATE(2880),
    [sym_function_literal] = STATE(2880),
    [sym_set_of_functions] = STATE(2880),
    [sym_record_literal] = STATE(2880),
    [sym_set_of_records] = STATE(2880),
    [sym_record_value] = STATE(2880),
    [sym_except] = STATE(2880),
    [sym_prev_func_val] = STATE(2880),
    [sym_tuple_literal] = STATE(2880),
    [sym_step_expr_or_stutter] = STATE(2880),
    [sym_step_expr_no_stutter] = STATE(2880),
    [sym_fairness] = STATE(2880),
    [sym_if_then_else] = STATE(2880),
    [sym_case] = STATE(2880),
    [sym_let_in] = STATE(2880),
    [sym_conj_list] = STATE(2880),
    [sym_disj_list] = STATE(2880),
    [sym_lnot] = STATE(62),
    [sym_union] = STATE(65),
    [sym_powerset] = STATE(65),
    [sym_domain] = STATE(67),
    [sym_negative] = STATE(407),
    [sym_enabled] = STATE(70),
    [sym_unchanged] = STATE(70),
    [sym_always] = STATE(70),
    [sym_eventually] = STATE(70),
    [sym_standalone_prefix_op_symbol] = STATE(3798),
    [sym_bound_prefix_op] = STATE(2880),
    [sym_implies] = STATE(3396),
    [sym_plus_arrow] = STATE(3396),
    [sym_equiv] = STATE(3396),
    [sym_iff] = STATE(3396),
    [sym_leads_to] = STATE(3396),
    [sym_land] = STATE(3396),
    [sym_lor] = STATE(3396),
    [sym_assign] = STATE(3396),
    [sym_bnf_rule] = STATE(3396),
    [sym_eq] = STATE(3396),
    [sym_neq] = STATE(3396),
    [sym_lt] = STATE(3396),
    [sym_leq] = STATE(3396),
    [sym_geq] = STATE(3396),
    [sym_approx] = STATE(3396),
    [sym_rs_ttile] = STATE(3396),
    [sym_rd_ttile] = STATE(3396),
    [sym_ls_ttile] = STATE(3396),
    [sym_ld_ttile] = STATE(3396),
    [sym_asymp] = STATE(3396),
    [sym_cong] = STATE(3396),
    [sym_doteq] = STATE(3396),
    [sym_gg] = STATE(3396),
    [sym_ll] = STATE(3396),
    [sym_in] = STATE(3396),
    [sym_notin] = STATE(3396),
    [sym_prec] = STATE(3396),
    [sym_succ] = STATE(3396),
    [sym_preceq] = STATE(3396),
    [sym_succeq] = STATE(3396),
    [sym_sim] = STATE(3396),
    [sym_simeq] = STATE(3396),
    [sym_sqsubset] = STATE(3396),
    [sym_sqsupset] = STATE(3396),
    [sym_sqsubseteq] = STATE(3396),
    [sym_sqsupseteq] = STATE(3396),
    [sym_cap] = STATE(3396),
    [sym_cup] = STATE(3396),
    [sym_dots_2] = STATE(3396),
    [sym_dots_3] = STATE(3396),
    [sym_oplus] = STATE(3396),
    [sym_ominus] = STATE(3396),
    [sym_vertvert] = STATE(3396),
    [sym_minus] = STATE(3396),
    [sym_odot] = STATE(3396),
    [sym_oslash] = STATE(3396),
    [sym_otimes] = STATE(3396),
    [sym_bigcirc] = STATE(3396),
    [sym_bullet] = STATE(3396),
    [sym_div] = STATE(3396),
    [sym_circ] = STATE(3396),
    [sym_star] = STATE(3396),
    [sym_excl] = STATE(3396),
    [sym_qq] = STATE(3396),
    [sym_sqcap] = STATE(3396),
    [sym_sqcup] = STATE(3396),
    [sym_uplus] = STATE(3396),
    [sym_wr] = STATE(3396),
    [sym_cdot] = STATE(3396),
    [sym_infix_op_symbol] = STATE(3816),
    [sym_bound_infix_op] = STATE(2880),
    [sym_sup_plus] = STATE(3417),
    [sym_postfix_op_symbol] = STATE(3798),
    [sym_bound_postfix_op] = STATE(2880),
    [sym_module_ref] = STATE(3890),
    [sym_proof_step_ref] = STATE(2745),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(453),
    [anon_sym_2] = ACTIONS(455),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(457),
    [anon_sym_10] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(459),
    [anon_sym_ENABLED] = ACTIONS(461),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(463),
    [anon_sym_DOMAIN] = ACTIONS(465),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(467),
    [anon_sym_LAMBDA] = ACTIONS(469),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(471),
    [anon_sym_BSLASHlnot] = ACTIONS(473),
    [anon_sym_BSLASHneg] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(475),
    [anon_sym_12] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(477),
    [sym_negative_dot] = ACTIONS(479),
    [anon_sym_LT_GT] = ACTIONS(481),
    [anon_sym_13] = ACTIONS(481),
    [anon_sym_EQ_GT] = ACTIONS(483),
    [anon_sym_14] = ACTIONS(483),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(485),
    [anon_sym_15] = ACTIONS(485),
    [anon_sym_BSLASHequiv] = ACTIONS(487),
    [anon_sym_16] = ACTIONS(487),
    [anon_sym_LT_EQ_GT] = ACTIONS(489),
    [anon_sym_17] = ACTIONS(489),
    [anon_sym_TILDE_GT] = ACTIONS(491),
    [anon_sym_18] = ACTIONS(491),
    [anon_sym_SLASH_BSLASH] = ACTIONS(493),
    [anon_sym_BSLASHland] = ACTIONS(493),
    [anon_sym_19] = ACTIONS(493),
    [anon_sym_BSLASH_SLASH] = ACTIONS(495),
    [anon_sym_BSLASHlor] = ACTIONS(495),
    [anon_sym_20] = ACTIONS(495),
    [anon_sym_COLON_EQ] = ACTIONS(497),
    [anon_sym_21] = ACTIONS(497),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(499),
    [anon_sym_22] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(501),
    [anon_sym_POUND] = ACTIONS(503),
    [anon_sym_23] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(505),
    [sym_gt] = ACTIONS(507),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_LT] = ACTIONS(511),
    [anon_sym_BSLASHleq] = ACTIONS(511),
    [anon_sym_24] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_BSLASHgeq] = ACTIONS(513),
    [anon_sym_25] = ACTIONS(513),
    [anon_sym_BSLASHapprox] = ACTIONS(515),
    [anon_sym_26] = ACTIONS(515),
    [anon_sym_PIPE_DASH] = ACTIONS(517),
    [anon_sym_27] = ACTIONS(517),
    [anon_sym_PIPE_EQ] = ACTIONS(519),
    [anon_sym_28] = ACTIONS(519),
    [anon_sym_DASH_PIPE] = ACTIONS(521),
    [anon_sym_29] = ACTIONS(521),
    [anon_sym_EQ_PIPE] = ACTIONS(523),
    [anon_sym_30] = ACTIONS(523),
    [anon_sym_BSLASHasymp] = ACTIONS(525),
    [anon_sym_31] = ACTIONS(525),
    [anon_sym_BSLASHcong] = ACTIONS(527),
    [anon_sym_32] = ACTIONS(527),
    [anon_sym_BSLASHdoteq] = ACTIONS(529),
    [anon_sym_33] = ACTIONS(529),
    [anon_sym_BSLASHgg] = ACTIONS(531),
    [anon_sym_34] = ACTIONS(531),
    [anon_sym_BSLASHll] = ACTIONS(533),
    [anon_sym_35] = ACTIONS(533),
    [anon_sym_BSLASHnotin] = ACTIONS(535),
    [anon_sym_36] = ACTIONS(535),
    [anon_sym_BSLASHprec] = ACTIONS(537),
    [anon_sym_37] = ACTIONS(539),
    [anon_sym_BSLASHsucc] = ACTIONS(541),
    [anon_sym_38] = ACTIONS(543),
    [anon_sym_BSLASHpreceq] = ACTIONS(545),
    [anon_sym_39] = ACTIONS(545),
    [anon_sym_BSLASHsucceq] = ACTIONS(547),
    [anon_sym_40] = ACTIONS(547),
    [anon_sym_BSLASHsim] = ACTIONS(549),
    [anon_sym_42] = ACTIONS(551),
    [anon_sym_BSLASHsimeq] = ACTIONS(553),
    [anon_sym_43] = ACTIONS(553),
    [anon_sym_BSLASHsqsubset] = ACTIONS(555),
    [anon_sym_44] = ACTIONS(557),
    [anon_sym_BSLASHsqsupset] = ACTIONS(559),
    [anon_sym_45] = ACTIONS(561),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(563),
    [anon_sym_46] = ACTIONS(563),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(565),
    [anon_sym_47] = ACTIONS(565),
    [sym_compose] = ACTIONS(567),
    [sym_map_to] = ACTIONS(567),
    [sym_map_from] = ACTIONS(567),
    [sym_setminus] = ACTIONS(507),
    [anon_sym_BSLASHcap] = ACTIONS(569),
    [anon_sym_BSLASHintersect] = ACTIONS(569),
    [anon_sym_52] = ACTIONS(569),
    [anon_sym_BSLASHcup] = ACTIONS(571),
    [anon_sym_BSLASHunion] = ACTIONS(571),
    [anon_sym_53] = ACTIONS(571),
    [anon_sym_DOT_DOT] = ACTIONS(573),
    [anon_sym_54] = ACTIONS(575),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(577),
    [anon_sym_55] = ACTIONS(577),
    [sym_plus] = ACTIONS(507),
    [sym_plusplus] = ACTIONS(567),
    [anon_sym_BSLASHoplus] = ACTIONS(579),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(579),
    [anon_sym_56] = ACTIONS(579),
    [anon_sym_BSLASHominus] = ACTIONS(581),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(581),
    [anon_sym_57] = ACTIONS(581),
    [sym_mod] = ACTIONS(507),
    [sym_modmod] = ACTIONS(567),
    [sym_vert] = ACTIONS(507),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_58] = ACTIONS(583),
    [sym_minusminus] = ACTIONS(567),
    [sym_amp] = ACTIONS(507),
    [sym_ampamp] = ACTIONS(567),
    [anon_sym_BSLASHodot] = ACTIONS(585),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(585),
    [anon_sym_59] = ACTIONS(585),
    [anon_sym_BSLASHoslash] = ACTIONS(587),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(587),
    [anon_sym_60] = ACTIONS(587),
    [anon_sym_BSLASHotimes] = ACTIONS(589),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(589),
    [anon_sym_61] = ACTIONS(589),
    [sym_mul] = ACTIONS(507),
    [sym_mulmul] = ACTIONS(567),
    [sym_slash] = ACTIONS(507),
    [sym_slashslash] = ACTIONS(567),
    [anon_sym_BSLASHbigcirc] = ACTIONS(591),
    [anon_sym_62] = ACTIONS(591),
    [anon_sym_BSLASHbullet] = ACTIONS(593),
    [anon_sym_63] = ACTIONS(593),
    [anon_sym_BSLASHdiv] = ACTIONS(595),
    [anon_sym_64] = ACTIONS(595),
    [anon_sym_BSLASHo] = ACTIONS(597),
    [anon_sym_BSLASHcirc] = ACTIONS(599),
    [anon_sym_65] = ACTIONS(599),
    [anon_sym_BSLASHstar] = ACTIONS(601),
    [anon_sym_66] = ACTIONS(601),
    [anon_sym_BANG_BANG] = ACTIONS(603),
    [anon_sym_67] = ACTIONS(603),
    [anon_sym_QMARK_QMARK] = ACTIONS(605),
    [anon_sym_68] = ACTIONS(605),
    [sym_hashhash] = ACTIONS(567),
    [sym_dol] = ACTIONS(507),
    [sym_doldol] = ACTIONS(567),
    [anon_sym_BSLASHsqcap] = ACTIONS(607),
    [anon_sym_69] = ACTIONS(607),
    [anon_sym_BSLASHsqcup] = ACTIONS(609),
    [anon_sym_70] = ACTIONS(609),
    [anon_sym_BSLASHuplus] = ACTIONS(611),
    [anon_sym_71] = ACTIONS(611),
    [anon_sym_BSLASHwr] = ACTIONS(613),
    [anon_sym_73] = ACTIONS(613),
    [anon_sym_BSLASHcdot] = ACTIONS(615),
    [anon_sym_74] = ACTIONS(615),
    [sym_pow] = ACTIONS(507),
    [sym_powpow] = ACTIONS(567),
    [anon_sym_CARET_PLUS] = ACTIONS(617),
    [anon_sym_75] = ACTIONS(617),
    [sym_asterisk] = ACTIONS(619),
    [sym_sup_hash] = ACTIONS(619),
    [sym_prime] = ACTIONS(619),
    [sym__indent] = ACTIONS(395),
  },
  [30] = {
    [sym_block_comment] = STATE(30),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym__op_or_expr] = STATE(3211),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym_lambda] = STATE(3212),
    [sym__expr] = STATE(1108),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STATE(2206),
    [sym_fairness] = STATE(2206),
    [sym_if_then_else] = STATE(2206),
    [sym_case] = STATE(2206),
    [sym_let_in] = STATE(2206),
    [sym_conj_list] = STATE(2206),
    [sym_disj_list] = STATE(2206),
    [sym_lnot] = STATE(6),
    [sym_union] = STATE(8),
    [sym_powerset] = STATE(8),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(802),
    [sym_enabled] = STATE(5),
    [sym_unchanged] = STATE(5),
    [sym_always] = STATE(5),
    [sym_eventually] = STATE(5),
    [sym_standalone_prefix_op_symbol] = STATE(3148),
    [sym_bound_prefix_op] = STATE(2206),
    [sym_implies] = STATE(3155),
    [sym_plus_arrow] = STATE(3155),
    [sym_equiv] = STATE(3155),
    [sym_iff] = STATE(3155),
    [sym_leads_to] = STATE(3155),
    [sym_land] = STATE(3155),
    [sym_lor] = STATE(3155),
    [sym_assign] = STATE(3155),
    [sym_bnf_rule] = STATE(3155),
    [sym_eq] = STATE(3155),
    [sym_neq] = STATE(3155),
    [sym_lt] = STATE(3155),
    [sym_leq] = STATE(3155),
    [sym_geq] = STATE(3155),
    [sym_approx] = STATE(3155),
    [sym_rs_ttile] = STATE(3155),
    [sym_rd_ttile] = STATE(3155),
    [sym_ls_ttile] = STATE(3155),
    [sym_ld_ttile] = STATE(3155),
    [sym_asymp] = STATE(3155),
    [sym_cong] = STATE(3155),
    [sym_doteq] = STATE(3155),
    [sym_gg] = STATE(3155),
    [sym_ll] = STATE(3155),
    [sym_in] = STATE(3155),
    [sym_notin] = STATE(3155),
    [sym_prec] = STATE(3155),
    [sym_succ] = STATE(3155),
    [sym_preceq] = STATE(3155),
    [sym_succeq] = STATE(3155),
    [sym_sim] = STATE(3155),
    [sym_simeq] = STATE(3155),
    [sym_sqsubset] = STATE(3155),
    [sym_sqsupset] = STATE(3155),
    [sym_sqsubseteq] = STATE(3155),
    [sym_sqsupseteq] = STATE(3155),
    [sym_cap] = STATE(3155),
    [sym_cup] = STATE(3155),
    [sym_dots_2] = STATE(3155),
    [sym_dots_3] = STATE(3155),
    [sym_oplus] = STATE(3155),
    [sym_ominus] = STATE(3155),
    [sym_vertvert] = STATE(3155),
    [sym_minus] = STATE(3155),
    [sym_odot] = STATE(3155),
    [sym_oslash] = STATE(3155),
    [sym_otimes] = STATE(3155),
    [sym_bigcirc] = STATE(3155),
    [sym_bullet] = STATE(3155),
    [sym_div] = STATE(3155),
    [sym_circ] = STATE(3155),
    [sym_star] = STATE(3155),
    [sym_excl] = STATE(3155),
    [sym_qq] = STATE(3155),
    [sym_sqcap] = STATE(3155),
    [sym_sqcup] = STATE(3155),
    [sym_uplus] = STATE(3155),
    [sym_wr] = STATE(3155),
    [sym_cdot] = STATE(3155),
    [sym_infix_op_symbol] = STATE(3149),
    [sym_bound_infix_op] = STATE(2206),
    [sym_sup_plus] = STATE(3154),
    [sym_postfix_op_symbol] = STATE(3148),
    [sym_bound_postfix_op] = STATE(2206),
    [sym_module_ref] = STATE(3211),
    [sym_proof_step_ref] = STATE(2179),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(621),
    [anon_sym_BSLASHin] = ACTIONS(623),
    [anon_sym_2] = ACTIONS(625),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(627),
    [anon_sym_10] = ACTIONS(627),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_UNION] = ACTIONS(629),
    [anon_sym_ENABLED] = ACTIONS(631),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(633),
    [anon_sym_DOMAIN] = ACTIONS(635),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(637),
    [anon_sym_LAMBDA] = ACTIONS(639),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(287),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_BSLASHlnot] = ACTIONS(647),
    [anon_sym_BSLASHneg] = ACTIONS(647),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_12] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(651),
    [sym_negative_dot] = ACTIONS(653),
    [anon_sym_LT_GT] = ACTIONS(655),
    [anon_sym_13] = ACTIONS(655),
    [anon_sym_EQ_GT] = ACTIONS(657),
    [anon_sym_14] = ACTIONS(657),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(659),
    [anon_sym_15] = ACTIONS(659),
    [anon_sym_BSLASHequiv] = ACTIONS(661),
    [anon_sym_16] = ACTIONS(661),
    [anon_sym_LT_EQ_GT] = ACTIONS(663),
    [anon_sym_17] = ACTIONS(663),
    [anon_sym_TILDE_GT] = ACTIONS(665),
    [anon_sym_18] = ACTIONS(665),
    [anon_sym_SLASH_BSLASH] = ACTIONS(667),
    [anon_sym_BSLASHland] = ACTIONS(667),
    [anon_sym_19] = ACTIONS(667),
    [anon_sym_BSLASH_SLASH] = ACTIONS(669),
    [anon_sym_BSLASHlor] = ACTIONS(669),
    [anon_sym_20] = ACTIONS(669),
    [anon_sym_COLON_EQ] = ACTIONS(671),
    [anon_sym_21] = ACTIONS(671),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(673),
    [anon_sym_22] = ACTIONS(673),
    [anon_sym_SLASH_EQ] = ACTIONS(675),
    [anon_sym_POUND] = ACTIONS(677),
    [anon_sym_23] = ACTIONS(675),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(679),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_EQ_LT] = ACTIONS(683),
    [anon_sym_BSLASHleq] = ACTIONS(683),
    [anon_sym_24] = ACTIONS(683),
    [anon_sym_GT_EQ] = ACTIONS(685),
    [anon_sym_BSLASHgeq] = ACTIONS(685),
    [anon_sym_25] = ACTIONS(685),
    [anon_sym_BSLASHapprox] = ACTIONS(687),
    [anon_sym_26] = ACTIONS(687),
    [anon_sym_PIPE_DASH] = ACTIONS(689),
    [anon_sym_27] = ACTIONS(689),
    [anon_sym_PIPE_EQ] = ACTIONS(691),
    [anon_sym_28] = ACTIONS(691),
    [anon_sym_DASH_PIPE] = ACTIONS(693),
    [anon_sym_29] = ACTIONS(693),
    [anon_sym_EQ_PIPE] = ACTIONS(695),
    [anon_sym_30] = ACTIONS(695),
    [anon_sym_BSLASHasymp] = ACTIONS(697),
    [anon_sym_31] = ACTIONS(697),
    [anon_sym_BSLASHcong] = ACTIONS(699),
    [anon_sym_32] = ACTIONS(699),
    [anon_sym_BSLASHdoteq] = ACTIONS(701),
    [anon_sym_33] = ACTIONS(701),
    [anon_sym_BSLASHgg] = ACTIONS(703),
    [anon_sym_34] = ACTIONS(703),
    [anon_sym_BSLASHll] = ACTIONS(705),
    [anon_sym_35] = ACTIONS(705),
    [anon_sym_BSLASHnotin] = ACTIONS(707),
    [anon_sym_36] = ACTIONS(707),
    [anon_sym_BSLASHprec] = ACTIONS(709),
    [anon_sym_37] = ACTIONS(711),
    [anon_sym_BSLASHsucc] = ACTIONS(713),
    [anon_sym_38] = ACTIONS(715),
    [anon_sym_BSLASHpreceq] = ACTIONS(717),
    [anon_sym_39] = ACTIONS(717),
    [anon_sym_BSLASHsucceq] = ACTIONS(719),
    [anon_sym_40] = ACTIONS(719),
    [anon_sym_BSLASHsim] = ACTIONS(721),
    [anon_sym_42] = ACTIONS(723),
    [anon_sym_BSLASHsimeq] = ACTIONS(725),
    [anon_sym_43] = ACTIONS(725),
    [anon_sym_BSLASHsqsubset] = ACTIONS(727),
    [anon_sym_44] = ACTIONS(729),
    [anon_sym_BSLASHsqsupset] = ACTIONS(731),
    [anon_sym_45] = ACTIONS(733),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(735),
    [anon_sym_46] = ACTIONS(735),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(737),
    [anon_sym_47] = ACTIONS(737),
    [sym_compose] = ACTIONS(739),
    [sym_map_to] = ACTIONS(739),
    [sym_map_from] = ACTIONS(739),
    [sym_setminus] = ACTIONS(679),
    [anon_sym_BSLASHcap] = ACTIONS(741),
    [anon_sym_BSLASHintersect] = ACTIONS(741),
    [anon_sym_52] = ACTIONS(741),
    [anon_sym_BSLASHcup] = ACTIONS(743),
    [anon_sym_BSLASHunion] = ACTIONS(743),
    [anon_sym_53] = ACTIONS(743),
    [anon_sym_DOT_DOT] = ACTIONS(745),
    [anon_sym_54] = ACTIONS(747),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(749),
    [anon_sym_55] = ACTIONS(749),
    [sym_plus] = ACTIONS(679),
    [sym_plusplus] = ACTIONS(739),
    [anon_sym_BSLASHoplus] = ACTIONS(751),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(751),
    [anon_sym_56] = ACTIONS(751),
    [anon_sym_BSLASHominus] = ACTIONS(753),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(753),
    [anon_sym_57] = ACTIONS(753),
    [sym_mod] = ACTIONS(679),
    [sym_modmod] = ACTIONS(739),
    [sym_vert] = ACTIONS(679),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_58] = ACTIONS(755),
    [sym_minusminus] = ACTIONS(739),
    [sym_amp] = ACTIONS(679),
    [sym_ampamp] = ACTIONS(739),
    [anon_sym_BSLASHodot] = ACTIONS(757),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(757),
    [anon_sym_59] = ACTIONS(757),
    [anon_sym_BSLASHoslash] = ACTIONS(759),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(759),
    [anon_sym_60] = ACTIONS(759),
    [anon_sym_BSLASHotimes] = ACTIONS(761),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(761),
    [anon_sym_61] = ACTIONS(761),
    [sym_mul] = ACTIONS(679),
    [sym_mulmul] = ACTIONS(739),
    [sym_slash] = ACTIONS(679),
    [sym_slashslash] = ACTIONS(739),
    [anon_sym_BSLASHbigcirc] = ACTIONS(763),
    [anon_sym_62] = ACTIONS(763),
    [anon_sym_BSLASHbullet] = ACTIONS(765),
    [anon_sym_63] = ACTIONS(765),
    [anon_sym_BSLASHdiv] = ACTIONS(767),
    [anon_sym_64] = ACTIONS(767),
    [anon_sym_BSLASHo] = ACTIONS(769),
    [anon_sym_BSLASHcirc] = ACTIONS(771),
    [anon_sym_65] = ACTIONS(771),
    [anon_sym_BSLASHstar] = ACTIONS(773),
    [anon_sym_66] = ACTIONS(773),
    [anon_sym_BANG_BANG] = ACTIONS(775),
    [anon_sym_67] = ACTIONS(775),
    [anon_sym_QMARK_QMARK] = ACTIONS(777),
    [anon_sym_68] = ACTIONS(777),
    [sym_hashhash] = ACTIONS(739),
    [sym_dol] = ACTIONS(679),
    [sym_doldol] = ACTIONS(739),
    [anon_sym_BSLASHsqcap] = ACTIONS(779),
    [anon_sym_69] = ACTIONS(779),
    [anon_sym_BSLASHsqcup] = ACTIONS(781),
    [anon_sym_70] = ACTIONS(781),
    [anon_sym_BSLASHuplus] = ACTIONS(783),
    [anon_sym_71] = ACTIONS(783),
    [anon_sym_BSLASHwr] = ACTIONS(785),
    [anon_sym_73] = ACTIONS(785),
    [anon_sym_BSLASHcdot] = ACTIONS(787),
    [anon_sym_74] = ACTIONS(787),
    [sym_pow] = ACTIONS(679),
    [sym_powpow] = ACTIONS(739),
    [anon_sym_CARET_PLUS] = ACTIONS(789),
    [anon_sym_75] = ACTIONS(789),
    [sym_asterisk] = ACTIONS(791),
    [sym_sup_hash] = ACTIONS(791),
    [sym_prime] = ACTIONS(791),
    [sym__indent] = ACTIONS(315),
  },
  [31] = {
    [sym_block_comment] = STATE(31),
    [sym_forall] = STATE(3568),
    [sym_exists] = STATE(3568),
    [sym_temporal_forall] = STATE(4326),
    [sym_temporal_exists] = STATE(4326),
    [sym_langle_bracket] = STATE(128),
    [sym__op_or_expr] = STATE(3240),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4349),
    [sym_bound_op] = STATE(2180),
    [sym_bound_nonfix_op] = STATE(2180),
    [sym_lambda] = STATE(3212),
    [sym__expr] = STATE(1108),
    [sym_prefixed_op] = STATE(2206),
    [sym_number] = STATE(2206),
    [sym__nat_number] = STATE(2202),
    [sym_boolean] = STATE(2206),
    [sym_primitive_value_set] = STATE(2206),
    [sym_label] = STATE(2206),
    [sym_subexpression] = STATE(2206),
    [sym_parentheses] = STATE(2206),
    [sym_bounded_quantification] = STATE(2206),
    [sym_unbounded_quantification] = STATE(2206),
    [sym_choose] = STATE(2206),
    [sym_finite_set_literal] = STATE(2206),
    [sym_set_filter] = STATE(2206),
    [sym_set_map] = STATE(2206),
    [sym_function_evaluation] = STATE(2206),
    [sym_function_literal] = STATE(2206),
    [sym_set_of_functions] = STATE(2206),
    [sym_record_literal] = STATE(2206),
    [sym_set_of_records] = STATE(2206),
    [sym_record_value] = STATE(2206),
    [sym_except] = STATE(2206),
    [sym_prev_func_val] = STATE(2206),
    [sym_tuple_literal] = STATE(2206),
    [sym_step_expr_or_stutter] = STATE(2206),
    [sym_step_expr_no_stutter] = STA