#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4645
#define LARGE_STATE_COUNT 3125
#define SYMBOL_COUNT 525
#define ALIAS_COUNT 1
#define TOKEN_COUNT 310
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 35

enum {
  sym_comment = 1,
  anon_sym_LPAREN_STAR = 2,
  anon_sym_STAR_RPAREN = 3,
  anon_sym_MODULE = 4,
  sym_single_line = 5,
  sym_double_line = 6,
  anon_sym_EQ_EQ = 7,
  anon_sym_ = 8,
  anon_sym_BSLASHin = 9,
  anon_sym_2 = 10,
  anon_sym_LT_DASH = 11,
  anon_sym_3 = 12,
  anon_sym_BSLASHA = 13,
  anon_sym_BSLASHforall = 14,
  anon_sym_4 = 15,
  anon_sym_BSLASHE = 16,
  anon_sym_BSLASHexists = 17,
  anon_sym_5 = 18,
  anon_sym_BSLASHAA = 19,
  anon_sym_BSLASHEE = 20,
  anon_sym_PIPE_DASH_GT = 21,
  anon_sym_6 = 22,
  anon_sym_DASH_GT = 23,
  anon_sym_7 = 24,
  anon_sym_LT_LT = 25,
  anon_sym_8 = 26,
  anon_sym_GT_GT = 27,
  anon_sym_9 = 28,
  anon_sym_GT_GT_ = 29,
  anon_sym__ = 30,
  anon_sym_LBRACK_RBRACK = 31,
  anon_sym_10 = 32,
  anon_sym_COLON = 33,
  anon_sym_AT = 34,
  anon_sym_COLON_COLON = 35,
  anon_sym_11 = 36,
  sym_placeholder = 37,
  anon_sym_ASSUME = 38,
  anon_sym_ELSE = 39,
  anon_sym_LOCAL = 40,
  anon_sym_UNION = 41,
  anon_sym_ASSUMPTION = 42,
  anon_sym_ENABLED = 43,
  anon_sym_VARIABLE = 44,
  anon_sym_AXIOM = 45,
  anon_sym_EXCEPT = 46,
  anon_sym_OTHER = 47,
  anon_sym_VARIABLES = 48,
  anon_sym_CASE = 49,
  anon_sym_EXTENDS = 50,
  anon_sym_SF_ = 51,
  anon_sym_WF_ = 52,
  anon_sym_CHOOSE = 53,
  anon_sym_IF = 54,
  anon_sym_SUBSET = 55,
  anon_sym_WITH = 56,
  anon_sym_CONSTANT = 57,
  anon_sym_IN = 58,
  anon_sym_THEN = 59,
  anon_sym_CONSTANTS = 60,
  anon_sym_INSTANCE = 61,
  anon_sym_THEOREM = 62,
  anon_sym_COROLLARY = 63,
  anon_sym_DOMAIN = 64,
  anon_sym_LET = 65,
  anon_sym_UNCHANGED = 66,
  anon_sym_BY = 67,
  anon_sym_HAVE = 68,
  anon_sym_QED = 69,
  anon_sym_TAKE = 70,
  anon_sym_DEF = 71,
  anon_sym_HIDE = 72,
  anon_sym_RECURSIVE = 73,
  anon_sym_USE = 74,
  anon_sym_DEFINE = 75,
  anon_sym_PROOF = 76,
  anon_sym_WITNESS = 77,
  anon_sym_PICK = 78,
  anon_sym_DEFS = 79,
  anon_sym_PROVE = 80,
  anon_sym_SUFFICES = 81,
  anon_sym_NEW = 82,
  anon_sym_LAMBDA = 83,
  anon_sym_STATE = 84,
  anon_sym_ACTION = 85,
  anon_sym_TEMPORAL = 86,
  anon_sym_OBVIOUS = 87,
  anon_sym_OMITTED = 88,
  anon_sym_LEMMA = 89,
  anon_sym_PROPOSITION = 90,
  anon_sym_ONLY = 91,
  sym_identifier = 92,
  anon_sym_COMMA = 93,
  anon_sym_LPAREN = 94,
  anon_sym_RPAREN = 95,
  anon_sym_LBRACK = 96,
  anon_sym_RBRACK = 97,
  anon_sym_BANG = 98,
  aux_sym_child_id_token1 = 99,
  sym__real_number = 100,
  sym__binary_number = 101,
  sym__octal_number = 102,
  sym__hex_number = 103,
  sym_string = 104,
  anon_sym_TRUE = 105,
  anon_sym_FALSE = 106,
  anon_sym_STRING = 107,
  anon_sym_BOOLEAN = 108,
  anon_sym_Nat = 109,
  anon_sym_Int = 110,
  anon_sym_Real = 111,
  anon_sym_LBRACE = 112,
  anon_sym_RBRACE = 113,
  anon_sym_DOT = 114,
  anon_sym_EQ = 115,
  anon_sym_RBRACK_ = 116,
  anon_sym_BSLASHlnot = 117,
  anon_sym_BSLASHneg = 118,
  anon_sym_TILDE = 119,
  anon_sym_12 = 120,
  anon_sym_DASH = 121,
  sym_negative_dot = 122,
  anon_sym_LT_GT = 123,
  anon_sym_13 = 124,
  anon_sym_EQ_GT = 125,
  anon_sym_14 = 126,
  anon_sym_DASH_PLUS_DASH_GT = 127,
  anon_sym_15 = 128,
  anon_sym_BSLASHequiv = 129,
  anon_sym_16 = 130,
  anon_sym_LT_EQ_GT = 131,
  anon_sym_17 = 132,
  anon_sym_TILDE_GT = 133,
  anon_sym_18 = 134,
  anon_sym_SLASH_BSLASH = 135,
  anon_sym_BSLASHland = 136,
  anon_sym_19 = 137,
  anon_sym_BSLASH_SLASH = 138,
  anon_sym_BSLASHlor = 139,
  anon_sym_20 = 140,
  anon_sym_COLON_EQ = 141,
  anon_sym_21 = 142,
  anon_sym_COLON_COLON_EQ = 143,
  anon_sym_22 = 144,
  anon_sym_SLASH_EQ = 145,
  anon_sym_POUND = 146,
  anon_sym_23 = 147,
  anon_sym_LT = 148,
  sym_gt = 149,
  anon_sym_LT_EQ = 150,
  anon_sym_EQ_LT = 151,
  anon_sym_BSLASHleq = 152,
  anon_sym_24 = 153,
  anon_sym_GT_EQ = 154,
  anon_sym_BSLASHgeq = 155,
  anon_sym_25 = 156,
  anon_sym_BSLASHapprox = 157,
  anon_sym_26 = 158,
  anon_sym_PIPE_DASH = 159,
  anon_sym_27 = 160,
  anon_sym_PIPE_EQ = 161,
  anon_sym_28 = 162,
  anon_sym_DASH_PIPE = 163,
  anon_sym_29 = 164,
  anon_sym_EQ_PIPE = 165,
  anon_sym_30 = 166,
  anon_sym_BSLASHasymp = 167,
  anon_sym_31 = 168,
  anon_sym_BSLASHcong = 169,
  anon_sym_32 = 170,
  anon_sym_BSLASHdoteq = 171,
  anon_sym_33 = 172,
  anon_sym_BSLASHgg = 173,
  anon_sym_34 = 174,
  anon_sym_BSLASHll = 175,
  anon_sym_35 = 176,
  anon_sym_BSLASHnotin = 177,
  anon_sym_36 = 178,
  anon_sym_BSLASHprec = 179,
  anon_sym_37 = 180,
  anon_sym_BSLASHsucc = 181,
  anon_sym_38 = 182,
  anon_sym_BSLASHpreceq = 183,
  anon_sym_39 = 184,
  anon_sym_BSLASHsucceq = 185,
  anon_sym_40 = 186,
  anon_sym_BSLASHpropto = 187,
  anon_sym_41 = 188,
  anon_sym_BSLASHsim = 189,
  anon_sym_42 = 190,
  anon_sym_BSLASHsimeq = 191,
  anon_sym_43 = 192,
  anon_sym_BSLASHsqsubset = 193,
  anon_sym_44 = 194,
  anon_sym_BSLASHsqsupset = 195,
  anon_sym_45 = 196,
  anon_sym_BSLASHsqsubseteq = 197,
  anon_sym_46 = 198,
  anon_sym_BSLASHsqsupseteq = 199,
  anon_sym_47 = 200,
  anon_sym_BSLASHsubset = 201,
  anon_sym_48 = 202,
  anon_sym_BSLASHsupset = 203,
  anon_sym_49 = 204,
  anon_sym_BSLASHsubseteq = 205,
  anon_sym_50 = 206,
  anon_sym_BSLASHsupseteq = 207,
  anon_sym_51 = 208,
  sym_compose = 209,
  sym_map_to = 210,
  sym_map_from = 211,
  sym_setminus = 212,
  anon_sym_BSLASHcap = 213,
  anon_sym_BSLASHintersect = 214,
  anon_sym_52 = 215,
  anon_sym_BSLASHcup = 216,
  anon_sym_BSLASHunion = 217,
  anon_sym_53 = 218,
  anon_sym_DOT_DOT = 219,
  anon_sym_54 = 220,
  anon_sym_DOT_DOT_DOT = 221,
  anon_sym_55 = 222,
  sym_plus = 223,
  sym_plusplus = 224,
  anon_sym_BSLASHoplus = 225,
  anon_sym_LPAREN_PLUS_RPAREN = 226,
  anon_sym_56 = 227,
  anon_sym_BSLASHominus = 228,
  anon_sym_LPAREN_DASH_RPAREN = 229,
  anon_sym_57 = 230,
  sym_mod = 231,
  sym_modmod = 232,
  sym_vert = 233,
  anon_sym_PIPE_PIPE = 234,
  anon_sym_58 = 235,
  sym_minusminus = 236,
  sym_amp = 237,
  sym_ampamp = 238,
  anon_sym_BSLASHodot = 239,
  anon_sym_LPAREN_DOT_RPAREN = 240,
  anon_sym_59 = 241,
  anon_sym_BSLASHoslash = 242,
  anon_sym_LPAREN_SLASH_RPAREN = 243,
  anon_sym_60 = 244,
  anon_sym_BSLASHotimes = 245,
  anon_sym_LPAREN_BSLASHX_RPAREN = 246,
  anon_sym_61 = 247,
  sym_mul = 248,
  sym_mulmul = 249,
  sym_slash = 250,
  sym_slashslash = 251,
  anon_sym_BSLASHbigcirc = 252,
  anon_sym_62 = 253,
  anon_sym_BSLASHbullet = 254,
  anon_sym_63 = 255,
  anon_sym_BSLASHdiv = 256,
  anon_sym_64 = 257,
  anon_sym_BSLASHo = 258,
  anon_sym_BSLASHcirc = 259,
  anon_sym_65 = 260,
  anon_sym_BSLASHstar = 261,
  anon_sym_66 = 262,
  anon_sym_BANG_BANG = 263,
  anon_sym_67 = 264,
  anon_sym_QMARK_QMARK = 265,
  anon_sym_68 = 266,
  sym_hashhash = 267,
  sym_dol = 268,
  sym_doldol = 269,
  anon_sym_BSLASHsqcap = 270,
  anon_sym_69 = 271,
  anon_sym_BSLASHsqcup = 272,
  anon_sym_70 = 273,
  anon_sym_BSLASHuplus = 274,
  anon_sym_71 = 275,
  anon_sym_BSLASHX = 276,
  anon_sym_BSLASHtimes = 277,
  anon_sym_72 = 278,
  anon_sym_BSLASHwr = 279,
  anon_sym_73 = 280,
  anon_sym_BSLASHcdot = 281,
  anon_sym_74 = 282,
  sym_pow = 283,
  sym_powpow = 284,
  anon_sym_CARET_PLUS = 285,
  anon_sym_75 = 286,
  sym_asterisk = 287,
  sym_sup_hash = 288,
  sym_prime = 289,
  aux_sym_proof_step_id_token1 = 290,
  anon_sym_GT = 291,
  aux_sym_proof_step_id_token2 = 292,
  aux_sym_proof_step_id_token3 = 293,
  aux_sym_proof_step_ref_token1 = 294,
  aux_sym_proof_step_ref_token2 = 295,
  sym_extramodular_text = 296,
  sym__block_comment_text = 297,
  sym__indent = 298,
  sym_bullet_conj = 299,
  sym_bullet_disj = 300,
  sym__dedent = 301,
  sym__begin_proof = 302,
  sym__begin_proof_step = 303,
  sym_proof_keyword = 304,
  sym_by_keyword = 305,
  sym_obvious_keyword = 306,
  sym_omitted_keyword = 307,
  sym_qed_keyword = 308,
  sym_error_sentinel = 309,
  sym_source_file = 310,
  sym_block_comment = 311,
  sym_module = 312,
  sym_def_eq = 313,
  sym_set_in = 314,
  sym_gets = 315,
  sym_forall = 316,
  sym_exists = 317,
  sym_temporal_forall = 318,
  sym_temporal_exists = 319,
  sym_all_map_to = 320,
  sym_maps_to = 321,
  sym_langle_bracket = 322,
  sym_rangle_bracket = 323,
  sym_rangle_bracket_sub = 324,
  sym_case_box = 325,
  sym_case_arrow = 326,
  sym_colon = 327,
  sym_address = 328,
  sym_label_as = 329,
  sym_extends = 330,
  sym_unit = 331,
  sym_local_definition = 332,
  sym__definition = 333,
  sym_variable_declaration = 334,
  sym_constant_declaration = 335,
  sym_recursive_declaration = 336,
  sym_operator_declaration = 337,
  sym__id_or_op_declaration = 338,
  sym_operator_definition = 339,
  sym_function_definition = 340,
  sym_quantifier_bound = 341,
  sym_single_quantifier_bound = 342,
  sym_tuple_of_identifiers = 343,
  sym_instance = 344,
  sym_substitution = 345,
  sym__op_or_expr = 346,
  sym_subexpr_prefix = 347,
  sym_subexpr_component = 348,
  sym_bound_op = 349,
  sym_bound_nonfix_op = 350,
  sym_subexpr_tree_nav = 351,
  sym_child_id = 352,
  sym_operator_args = 353,
  sym_lambda = 354,
  sym_module_definition = 355,
  sym__expr = 356,
  sym__subscript_expr = 357,
  sym_prefixed_op = 358,
  sym_number = 359,
  sym__nat_number = 360,
  sym_boolean = 361,
  sym_primitive_value_set = 362,
  sym_label = 363,
  sym_subexpression = 364,
  sym_parentheses = 365,
  sym_bounded_quantification = 366,
  sym_unbounded_quantification = 367,
  sym_choose = 368,
  sym_finite_set_literal = 369,
  sym_set_filter = 370,
  sym_set_map = 371,
  sym_function_evaluation = 372,
  sym_function_literal = 373,
  sym_set_of_functions = 374,
  sym_record_literal = 375,
  sym_set_of_records = 376,
  sym_record_value = 377,
  sym_except = 378,
  aux_sym__except_val = 379,
  sym_prev_func_val = 380,
  sym_tuple_literal = 381,
  sym_step_expr_or_stutter = 382,
  sym_step_expr_no_stutter = 383,
  sym_fairness = 384,
  sym_if_then_else = 385,
  sym_case = 386,
  sym_case_arm = 387,
  sym_other_arm = 388,
  sym_let_in = 389,
  sym_conj_list = 390,
  sym_conj_item = 391,
  sym_disj_list = 392,
  sym_disj_item = 393,
  sym_lnot = 394,
  sym_union = 395,
  sym_powerset = 396,
  sym_domain = 397,
  sym_negative = 398,
  sym_enabled = 399,
  sym_unchanged = 400,
  sym_always = 401,
  sym_eventually = 402,
  sym_standalone_prefix_op_symbol = 403,
  sym_bound_prefix_op = 404,
  sym_implies = 405,
  sym_plus_arrow = 406,
  sym_equiv = 407,
  sym_iff = 408,
  sym_leads_to = 409,
  sym_land = 410,
  sym_lor = 411,
  sym_assign = 412,
  sym_bnf_rule = 413,
  sym_eq = 414,
  sym_neq = 415,
  sym_lt = 416,
  sym_leq = 417,
  sym_geq = 418,
  sym_approx = 419,
  sym_rs_ttile = 420,
  sym_rd_ttile = 421,
  sym_ls_ttile = 422,
  sym_ld_ttile = 423,
  sym_asymp = 424,
  sym_cong = 425,
  sym_doteq = 426,
  sym_gg = 427,
  sym_ll = 428,
  sym_in = 429,
  sym_notin = 430,
  sym_prec = 431,
  sym_succ = 432,
  sym_preceq = 433,
  sym_succeq = 434,
  sym_propto = 435,
  sym_sim = 436,
  sym_simeq = 437,
  sym_sqsubset = 438,
  sym_sqsupset = 439,
  sym_sqsubseteq = 440,
  sym_sqsupseteq = 441,
  sym_subset = 442,
  sym_supset = 443,
  sym_subseteq = 444,
  sym_supseteq = 445,
  sym_cap = 446,
  sym_cup = 447,
  sym_dots_2 = 448,
  sym_dots_3 = 449,
  sym_oplus = 450,
  sym_ominus = 451,
  sym_vertvert = 452,
  sym_minus = 453,
  sym_odot = 454,
  sym_oslash = 455,
  sym_otimes = 456,
  sym_bigcirc = 457,
  sym_bullet = 458,
  sym_div = 459,
  sym_circ = 460,
  sym_star = 461,
  sym_excl = 462,
  sym_qq = 463,
  sym_sqcap = 464,
  sym_sqcup = 465,
  sym_uplus = 466,
  sym_times = 467,
  sym_wr = 468,
  sym_cdot = 469,
  sym_infix_op_symbol = 470,
  sym_bound_infix_op = 471,
  sym_sup_plus = 472,
  sym_postfix_op_symbol = 473,
  sym_bound_postfix_op = 474,
  sym_assumption = 475,
  sym_theorem = 476,
  sym_assume_prove = 477,
  sym_inner_assume_prove = 478,
  sym_new = 479,
  sym_level = 480,
  sym__proof = 481,
  sym_terminal_proof = 482,
  sym_non_terminal_proof = 483,
  sym_proof_step = 484,
  sym_definition_proof_step = 485,
  sym_have_proof_step = 486,
  sym_witness_proof_step = 487,
  sym_take_proof_step = 488,
  sym_suffices_proof_step = 489,
  sym_case_proof_step = 490,
  sym_pick_proof_step = 491,
  sym__bound_or_identifier_list = 492,
  sym_qed_step = 493,
  sym_use_or_hide = 494,
  sym_use_body = 495,
  sym_use_body_expr = 496,
  sym_use_body_def = 497,
  sym_module_ref = 498,
  sym_proof_step_id = 499,
  sym_proof_step_ref = 500,
  aux_sym_source_file_repeat1 = 501,
  aux_sym_block_comment_repeat1 = 502,
  aux_sym_module_repeat1 = 503,
  aux_sym_extends_repeat1 = 504,
  aux_sym_variable_declaration_repeat1 = 505,
  aux_sym_constant_declaration_repeat1 = 506,
  aux_sym_operator_declaration_repeat1 = 507,
  aux_sym_function_definition_repeat1 = 508,
  aux_sym_instance_repeat1 = 509,
  aux_sym_subexpr_prefix_repeat1 = 510,
  aux_sym_bound_op_repeat1 = 511,
  aux_sym_finite_set_literal_repeat1 = 512,
  aux_sym_record_literal_repeat1 = 513,
  aux_sym_set_of_records_repeat1 = 514,
  aux_sym_except_repeat1 = 515,
  aux_sym_case_repeat1 = 516,
  aux_sym_let_in_repeat1 = 517,
  aux_sym_conj_list_repeat1 = 518,
  aux_sym_disj_list_repeat1 = 519,
  aux_sym_assume_prove_repeat1 = 520,
  aux_sym_non_terminal_proof_repeat1 = 521,
  aux_sym_definition_proof_step_repeat1 = 522,
  aux_sym_use_body_expr_repeat1 = 523,
  aux_sym_use_body_def_repeat1 = 524,
  alias_sym_identifier_ref = 525,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_STAR_RPAREN] = "*)",
  [anon_sym_MODULE] = "MODULE",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_] = "≜",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_2] = "∈",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_3] = "⟵",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_4] = "∀",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_5] = "∃",
  [anon_sym_BSLASHAA] = "\\AA",
  [anon_sym_BSLASHEE] = "\\EE",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_6] = "⟼",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_7] = "⟶",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_8] = "〈",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_9] = "〉",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym__] = "〉_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_10] = "□",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_11] = "∷",
  [sym_placeholder] = "placeholder",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_UNION] = "UNION",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_ENABLED] = "ENABLED",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CASE] = "CASE",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_SF_] = "SF_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_IF] = "IF",
  [anon_sym_SUBSET] = "SUBSET",
  [anon_sym_WITH] = "WITH",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_IN] = "IN",
  [anon_sym_THEN] = "THEN",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_DOMAIN] = "DOMAIN",
  [anon_sym_LET] = "LET",
  [anon_sym_UNCHANGED] = "UNCHANGED",
  [anon_sym_BY] = "BY",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_QED] = "QED",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_USE] = "USE",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_PICK] = "PICK",
  [anon_sym_DEFS] = "DEFS",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_NEW] = "NEW",
  [anon_sym_LAMBDA] = "LAMBDA",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_ONLY] = "ONLY",
  [sym_identifier] = "identifier",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [sym__real_number] = "_real_number",
  [sym__binary_number] = "_binary_number",
  [sym__octal_number] = "_octal_number",
  [sym__hex_number] = "_hex_number",
  [sym_string] = "string",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [anon_sym_STRING] = "STRING",
  [anon_sym_BOOLEAN] = "BOOLEAN",
  [anon_sym_Nat] = "Nat",
  [anon_sym_Int] = "Int",
  [anon_sym_Real] = "Real",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_12] = "¬",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative_dot",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_13] = "⋄",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_14] = "⟹",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_15] = "⇸",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_16] = "≡",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_17] = "⟺",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_18] = "⇝",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_19] = "∧",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_20] = "∨",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_21] = "≔",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_22] = "⩴",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_23] = "≠",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_24] = "≤",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_25] = "≥",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_26] = "≈",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_27] = "⊢",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_28] = "⊨",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_29] = "⊣",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_30] = "⫤",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_31] = "≍",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_32] = "≅",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_33] = "≐",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_34] = "≫",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_35] = "≪",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_36] = "∉",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_37] = "≺",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_38] = "≻",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_39] = "⪯",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_40] = "⪰",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_41] = "∝",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_42] = "∼",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_43] = "≃",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_44] = "⊏",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_45] = "⊐",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_46] = "⊑",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_47] = "⊒",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_48] = "⊂",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_49] = "⊃",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_50] = "⊆",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_51] = "⊇",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_52] = "∩",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_53] = "∪",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_54] = "‥",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_55] = "…",
  [sym_plus] = "plus",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_56] = "⊕",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_57] = "⊖",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_58] = "‖",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_59] = "⊙",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_60] = "⊘",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_61] = "⊗",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_62] = "◯",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_63] = "●",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_64] = "÷",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_65] = "∘",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_66] = "⋆",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_67] = "‼",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_68] = "⁇",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_69] = "⊓",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_70] = "⊔",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_71] = "⊎",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_72] = "×",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_73] = "≀",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_74] = "⋅",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_75] = "⁺",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [sym_extramodular_text] = "extramodular_text",
  [sym__block_comment_text] = "_block_comment_text",
  [sym__indent] = "_indent",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym_proof_keyword] = "PROOF",
  [sym_by_keyword] = "BY",
  [sym_obvious_keyword] = "OBVIOUS",
  [sym_omitted_keyword] = "OMITTED",
  [sym_qed_keyword] = "QED",
  [sym_error_sentinel] = "error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_module] = "module",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_extends] = "extends",
  [sym_unit] = "unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_single_quantifier_bound] = "single_quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym_number] = "number",
  [sym__nat_number] = "_nat_number",
  [sym_boolean] = "boolean",
  [sym_primitive_value_set] = "primitive_value_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [aux_sym__except_val] = "_except_val",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [sym_negative] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_standalone_prefix_op_symbol] = "standalone_prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_level] = "level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [alias_sym_identifier_ref] = "identifier_ref",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_STAR_RPAREN] = anon_sym_STAR_RPAREN,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_] = anon_sym_,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_4] = anon_sym_4,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_5] = anon_sym_5,
  [anon_sym_BSLASHAA] = anon_sym_BSLASHAA,
  [anon_sym_BSLASHEE] = anon_sym_BSLASHEE,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_6] = anon_sym_6,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_7] = anon_sym_7,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_8] = anon_sym_8,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_9] = anon_sym_9,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym__] = anon_sym__,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_10] = anon_sym_10,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_11] = anon_sym_11,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_UNION] = anon_sym_UNION,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_ENABLED] = anon_sym_ENABLED,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_SUBSET] = anon_sym_SUBSET,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_DOMAIN] = anon_sym_DOMAIN,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_UNCHANGED] = anon_sym_UNCHANGED,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [sym_identifier] = sym_identifier,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [sym__real_number] = sym__real_number,
  [sym__binary_number] = sym__binary_number,
  [sym__octal_number] = sym__octal_number,
  [sym__hex_number] = sym__hex_number,
  [sym_string] = sym_string,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [anon_sym_STRING] = anon_sym_STRING,
  [anon_sym_BOOLEAN] = anon_sym_BOOLEAN,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_12] = anon_sym_12,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative_dot,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_13] = anon_sym_13,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_14] = anon_sym_14,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_15] = anon_sym_15,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_16] = anon_sym_16,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_17] = anon_sym_17,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_18] = anon_sym_18,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_19] = anon_sym_19,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_20] = anon_sym_20,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_21] = anon_sym_21,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_22] = anon_sym_22,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_23] = anon_sym_23,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_24] = anon_sym_24,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_25] = anon_sym_25,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_26] = anon_sym_26,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_27] = anon_sym_27,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_28] = anon_sym_28,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_29] = anon_sym_29,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_30] = anon_sym_30,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_31] = anon_sym_31,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_32] = anon_sym_32,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_33] = anon_sym_33,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_34] = anon_sym_34,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_35] = anon_sym_35,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_36] = anon_sym_36,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_37] = anon_sym_37,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_38] = anon_sym_38,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_39] = anon_sym_39,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_40] = anon_sym_40,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_41] = anon_sym_41,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_42] = anon_sym_42,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_43] = anon_sym_43,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_44] = anon_sym_44,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_45] = anon_sym_45,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_46] = anon_sym_46,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_47] = anon_sym_47,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_48] = anon_sym_48,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_49] = anon_sym_49,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_50] = anon_sym_50,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_51] = anon_sym_51,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_52] = anon_sym_52,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_53] = anon_sym_53,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_54] = anon_sym_54,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_55] = anon_sym_55,
  [sym_plus] = sym_plus,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_56] = anon_sym_56,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_57] = anon_sym_57,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_58] = anon_sym_58,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_59] = anon_sym_59,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_60] = anon_sym_60,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_61] = anon_sym_61,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_62] = anon_sym_62,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_63] = anon_sym_63,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_64] = anon_sym_64,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_65] = anon_sym_65,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_66] = anon_sym_66,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_67] = anon_sym_67,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_68] = anon_sym_68,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_69] = anon_sym_69,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_70] = anon_sym_70,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_71] = anon_sym_71,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_72] = anon_sym_72,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_73] = anon_sym_73,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_74] = anon_sym_74,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_75] = anon_sym_75,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [aux_sym_proof_step_id_token1] = sym_level,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = sym_level,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [sym_extramodular_text] = sym_extramodular_text,
  [sym__block_comment_text] = sym__block_comment_text,
  [sym__indent] = sym__indent,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym_proof_keyword] = anon_sym_PROOF,
  [sym_by_keyword] = anon_sym_BY,
  [sym_obvious_keyword] = anon_sym_OBVIOUS,
  [sym_omitted_keyword] = anon_sym_OMITTED,
  [sym_qed_keyword] = anon_sym_QED,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_module] = sym_module,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_extends] = sym_extends,
  [sym_unit] = sym_unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_single_quantifier_bound] = sym_single_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym_number] = sym_number,
  [sym__nat_number] = sym__nat_number,
  [sym_boolean] = sym_boolean,
  [sym_primitive_value_set] = sym_primitive_value_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [aux_sym__except_val] = aux_sym__except_val,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [sym_negative] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_standalone_prefix_op_symbol] = sym_standalone_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_level] = sym_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHEE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_11] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENABLED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUBSET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOMAIN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UNCHANGED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__real_number] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_number] = {
    .visible = false,
    .named = true,
  },
  [sym__octal_number] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_number] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STRING] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BOOLEAN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_33] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_34] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_35] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_36] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_37] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_38] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_39] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_41] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_42] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_43] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_44] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_45] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_46] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_47] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_49] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_50] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_51] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_52] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_53] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_54] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_55] = {
    .visible = true,
    .named = false,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_57] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_58] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_59] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_60] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_61] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_62] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_63] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_65] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_66] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_67] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_68] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_69] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_70] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_71] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_73] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_74] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_75] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__block_comment_text] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym_proof_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_by_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_obvious_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_omitted_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_qed_keyword] = {
    .visible = true,
    .named = false,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_single_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__nat_number] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_value_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__except_val] = {
    .visible = false,
    .named = false,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_standalone_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expression = 7,
  field_filter = 8,
  field_generator = 9,
  field_identifier = 10,
  field_if = 11,
  field_lhs = 12,
  field_map = 13,
  field_name = 14,
  field_op = 15,
  field_parameter = 16,
  field_prefix = 17,
  field_quantifier = 18,
  field_rhs = 19,
  field_set = 20,
  field_symbol = 21,
  field_then = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_identifier] = "identifier",
  [field_if] = "if",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_symbol] = "symbol",
  [field_then] = "then",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 2},
  [5] = {.index = 1, .length = 2},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 2},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 3},
  [12] = {.index = 14, .length = 3},
  [13] = {.index = 17, .length = 3},
  [14] = {.index = 20, .length = 2},
  [15] = {.index = 8, .length = 1},
  [16] = {.index = 22, .length = 1},
  [17] = {.index = 23, .length = 3},
  [18] = {.index = 26, .length = 3},
  [19] = {.index = 29, .length = 2},
  [20] = {.index = 31, .length = 4},
  [21] = {.index = 35, .length = 1},
  [22] = {.index = 36, .length = 2},
  [23] = {.index = 38, .length = 2},
  [24] = {.index = 40, .length = 4},
  [25] = {.index = 44, .length = 4},
  [26] = {.index = 48, .length = 3},
  [27] = {.index = 51, .length = 5},
  [28] = {.index = 56, .length = 2},
  [29] = {.index = 58, .length = 3},
  [30] = {.index = 61, .length = 4},
  [31] = {.index = 65, .length = 3},
  [32] = {.index = 68, .length = 6},
  [33] = {.index = 74, .length = 2},
  [34] = {.index = 76, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 2},
  [1] =
    {field_op, 1},
    {field_prefix, 0},
  [3] =
    {field_lhs, 0},
    {field_symbol, 1},
  [5] =
    {field_rhs, 1},
    {field_symbol, 0},
  [7] =
    {field_name, 1},
  [8] =
    {field_name, 0},
  [9] =
    {field_definition, 2},
    {field_name, 0},
  [11] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [14] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [17] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [20] =
    {field_definitions, 1},
    {field_expression, 3},
  [22] =
    {field_set, 2},
  [23] =
    {field_expression, 3},
    {field_identifier, 1},
    {field_quantifier, 0},
  [26] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [29] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [31] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [35] =
    {field_set, 3},
  [36] =
    {field_filter, 3},
    {field_generator, 1},
  [38] =
    {field_generator, 3},
    {field_map, 1},
  [40] =
    {field_expression, 4},
    {field_identifier, 1},
    {field_identifier, 2},
    {field_quantifier, 0},
  [44] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [48] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [51] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [56] =
    {field_definition, 5},
    {field_name, 0},
  [58] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [61] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [65] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [68] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [74] =
    {field_definition, 6},
    {field_name, 0},
  [76] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_identifier_ref,
  },
  [3] = {
    [1] = alias_sym_identifier_ref,
  },
  [4] = {
    [1] = alias_sym_identifier_ref,
  },
  [15] = {
    [0] = alias_sym_identifier_ref,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(448);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(884);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(487);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(874);
      if (lookahead == '>') ADVANCE(920);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'A') ADVANCE(62);
      if (lookahead == 'B') ADVANCE(173);
      if (lookahead == 'C') ADVANCE(46);
      if (lookahead == 'D') ADVANCE(79);
      if (lookahead == 'E') ADVANCE(148);
      if (lookahead == 'F') ADVANCE(39);
      if (lookahead == 'H') ADVANCE(40);
      if (lookahead == 'I') ADVANCE(111);
      if (lookahead == 'L') ADVANCE(47);
      if (lookahead == 'M') ADVANCE(174);
      if (lookahead == 'N') ADVANCE(80);
      if (lookahead == 'O') ADVANCE(57);
      if (lookahead == 'P') ADVANCE(123);
      if (lookahead == 'Q') ADVANCE(100);
      if (lookahead == 'R') ADVANCE(101);
      if (lookahead == 'S') ADVANCE(112);
      if (lookahead == 'T') ADVANCE(41);
      if (lookahead == 'U') ADVANCE(158);
      if (lookahead == 'V') ADVANCE(42);
      if (lookahead == 'W') ADVANCE(115);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(985);
      if (lookahead == ']') ADVANCE(844);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(493);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1011);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10229) ADVANCE(463);
      if (lookahead == 10230) ADVANCE(475);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10236) ADVANCE(473);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (lookahead == 12297) ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(848);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(1044);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(854);
      if (lookahead == '\\') ADVANCE(388);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == ')') ADVANCE(1004);
      END_STATE();
    case 4:
      if (lookahead == ')') ADVANCE(1007);
      END_STATE();
    case 5:
      if (lookahead == ')') ADVANCE(1020);
      END_STATE();
    case 6:
      if (lookahead == ')') ADVANCE(1023);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(1026);
      END_STATE();
    case 8:
      if (lookahead == ')') ADVANCE(451);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(450);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(450);
      if (lookahead == '+') ADVANCE(3);
      if (lookahead == '-') ADVANCE(4);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '\\') ADVANCE(233);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(449);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == 'i') ADVANCE(308);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == 'i') ADVANCE(308);
      if (lookahead == 'l') ADVANCE(311);
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == 'l') ADVANCE(311);
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(454);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(462);
      if (lookahead == '<') ADVANCE(476);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(462);
      if (lookahead == '>') ADVANCE(890);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(16);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == '.') ADVANCE(889);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(889);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(997);
      END_STATE();
    case 24:
      if (lookahead == ':') ADVANCE(491);
      if (lookahead == '=') ADVANCE(908);
      if (lookahead == '>') ADVANCE(983);
      END_STATE();
    case 25:
      if (lookahead == ':') ADVANCE(490);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(27);
      if (lookahead == '=') ADVANCE(908);
      if (lookahead == '>') ADVANCE(983);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(910);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(29);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(455);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(456);
      END_STATE();
    case 31:
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(890);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(900);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(472);
      END_STATE();
    case 35:
      if (lookahead == '>') ADVANCE(894);
      END_STATE();
    case 36:
      if (lookahead == '>') ADVANCE(478);
      END_STATE();
    case 37:
      if (lookahead == '?') ADVANCE(1046);
      END_STATE();
    case 38:
      if (lookahead == '@') ADVANCE(982);
      END_STATE();
    case 39:
      if (lookahead == 'A') ADVANCE(149);
      END_STATE();
    case 40:
      if (lookahead == 'A') ADVANCE(228);
      if (lookahead == 'I') ADVANCE(77);
      END_STATE();
    case 41:
      if (lookahead == 'A') ADVANCE(137);
      if (lookahead == 'E') ADVANCE(150);
      if (lookahead == 'H') ADVANCE(81);
      if (lookahead == 'R') ADVANCE(226);
      END_STATE();
    case 42:
      if (lookahead == 'A') ADVANCE(193);
      END_STATE();
    case 43:
      if (lookahead == 'A') ADVANCE(59);
      END_STATE();
    case 44:
      if (lookahead == 'A') ADVANCE(588);
      END_STATE();
    case 45:
      if (lookahead == 'A') ADVANCE(578);
      END_STATE();
    case 46:
      if (lookahead == 'A') ADVANCE(203);
      if (lookahead == 'H') ADVANCE(184);
      if (lookahead == 'O') ADVANCE(169);
      END_STATE();
    case 47:
      if (lookahead == 'A') ADVANCE(154);
      if (lookahead == 'E') ADVANCE(157);
      if (lookahead == 'O') ADVANCE(69);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(217);
      if (lookahead == 'R') ADVANCE(124);
      END_STATE();
    case 49:
      if (lookahead == 'A') ADVANCE(128);
      END_STATE();
    case 50:
      if (lookahead == 'A') ADVANCE(139);
      END_STATE();
    case 51:
      if (lookahead == 'A') ADVANCE(192);
      END_STATE();
    case 52:
      if (lookahead == 'A') ADVANCE(168);
      END_STATE();
    case 53:
      if (lookahead == 'A') ADVANCE(165);
      END_STATE();
    case 54:
      if (lookahead == 'A') ADVANCE(140);
      END_STATE();
    case 55:
      if (lookahead == 'A') ADVANCE(171);
      END_STATE();
    case 56:
      if (lookahead == 'A') ADVANCE(60);
      END_STATE();
    case 57:
      if (lookahead == 'B') ADVANCE(231);
      if (lookahead == 'M') ADVANCE(125);
      if (lookahead == 'N') ADVANCE(138);
      if (lookahead == 'T') ADVANCE(121);
      END_STATE();
    case 58:
      if (lookahead == 'B') ADVANCE(76);
      END_STATE();
    case 59:
      if (lookahead == 'B') ADVANCE(146);
      END_STATE();
    case 60:
      if (lookahead == 'B') ADVANCE(145);
      END_STATE();
    case 61:
      if (lookahead == 'B') ADVANCE(210);
      if (lookahead == 'F') ADVANCE(116);
      END_STATE();
    case 62:
      if (lookahead == 'C') ADVANCE(218);
      if (lookahead == 'S') ADVANCE(202);
      if (lookahead == 'X') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'C') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(177);
      END_STATE();
    case 64:
      if (lookahead == 'C') ADVANCE(136);
      END_STATE();
    case 65:
      if (lookahead == 'C') ADVANCE(223);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(99);
      END_STATE();
    case 67:
      if (lookahead == 'C') ADVANCE(99);
      if (lookahead == 'T') ADVANCE(85);
      END_STATE();
    case 68:
      if (lookahead == 'C') ADVANCE(108);
      END_STATE();
    case 69:
      if (lookahead == 'C') ADVANCE(50);
      END_STATE();
    case 70:
      if (lookahead == 'D') ADVANCE(554);
      END_STATE();
    case 71:
      if (lookahead == 'D') ADVANCE(504);
      END_STATE();
    case 72:
      if (lookahead == 'D') ADVANCE(587);
      END_STATE();
    case 73:
      if (lookahead == 'D') ADVANCE(549);
      END_STATE();
    case 74:
      if (lookahead == 'D') ADVANCE(227);
      END_STATE();
    case 75:
      if (lookahead == 'D') ADVANCE(198);
      END_STATE();
    case 76:
      if (lookahead == 'D') ADVANCE(45);
      END_STATE();
    case 77:
      if (lookahead == 'D') ADVANCE(87);
      END_STATE();
    case 78:
      if (lookahead == 'E') ADVANCE(113);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(113);
      if (lookahead == 'O') ADVANCE(155);
      END_STATE();
    case 80:
      if (lookahead == 'E') ADVANCE(232);
      if (lookahead == 'a') ADVANCE(365);
      END_STATE();
    case 81:
      if (lookahead == 'E') ADVANCE(160);
      END_STATE();
    case 82:
      if (lookahead == 'E') ADVANCE(563);
      END_STATE();
    case 83:
      if (lookahead == 'E') ADVANCE(516);
      END_STATE();
    case 84:
      if (lookahead == 'E') ADVANCE(497);
      END_STATE();
    case 85:
      if (lookahead == 'E') ADVANCE(170);
      END_STATE();
    case 86:
      if (lookahead == 'E') ADVANCE(552);
      END_STATE();
    case 87:
      if (lookahead == 'E') ADVANCE(559);
      END_STATE();
    case 88:
      if (lookahead == 'E') ADVANCE(555);
      END_STATE();
    case 89:
      if (lookahead == 'E') ADVANCE(855);
      END_STATE();
    case 90:
      if (lookahead == 'E') ADVANCE(857);
      END_STATE();
    case 91:
      if (lookahead == 'E') ADVANCE(573);
      END_STATE();
    case 92:
      if (lookahead == 'E') ADVANCE(580);
      END_STATE();
    case 93:
      if (lookahead == 'E') ADVANCE(495);
      if (lookahead == 'P') ADVANCE(221);
      END_STATE();
    case 94:
      if (lookahead == 'E') ADVANCE(524);
      END_STATE();
    case 95:
      if (lookahead == 'E') ADVANCE(452);
      END_STATE();
    case 96:
      if (lookahead == 'E') ADVANCE(506);
      END_STATE();
    case 97:
      if (lookahead == 'E') ADVANCE(561);
      END_STATE();
    case 98:
      if (lookahead == 'E') ADVANCE(191);
      END_STATE();
    case 99:
      if (lookahead == 'E') ADVANCE(189);
      END_STATE();
    case 100:
      if (lookahead == 'E') ADVANCE(70);
      END_STATE();
    case 101:
      if (lookahead == 'E') ADVANCE(65);
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 102:
      if (lookahead == 'E') ADVANCE(207);
      END_STATE();
    case 103:
      if (lookahead == 'E') ADVANCE(153);
      END_STATE();
    case 104:
      if (lookahead == 'E') ADVANCE(71);
      END_STATE();
    case 105:
      if (lookahead == 'E') ADVANCE(72);
      END_STATE();
    case 106:
      if (lookahead == 'E') ADVANCE(214);
      END_STATE();
    case 107:
      if (lookahead == 'E') ADVANCE(73);
      END_STATE();
    case 108:
      if (lookahead == 'E') ADVANCE(201);
      END_STATE();
    case 109:
      if (lookahead == 'E') ADVANCE(159);
      END_STATE();
    case 110:
      if (lookahead == 'E') ADVANCE(53);
      END_STATE();
    case 111:
      if (lookahead == 'F') ADVANCE(526);
      if (lookahead == 'N') ADVANCE(535);
      if (lookahead == 'n') ADVANCE(364);
      END_STATE();
    case 112:
      if (lookahead == 'F') ADVANCE(238);
      if (lookahead == 'T') ADVANCE(48);
      if (lookahead == 'U') ADVANCE(61);
      END_STATE();
    case 113:
      if (lookahead == 'F') ADVANCE(557);
      END_STATE();
    case 114:
      if (lookahead == 'F') ADVANCE(566);
      END_STATE();
    case 115:
      if (lookahead == 'F') ADVANCE(239);
      if (lookahead == 'I') ADVANCE(212);
      END_STATE();
    case 116:
      if (lookahead == 'F') ADVANCE(126);
      END_STATE();
    case 117:
      if (lookahead == 'G') ADVANCE(859);
      END_STATE();
    case 118:
      if (lookahead == 'G') ADVANCE(107);
      END_STATE();
    case 119:
      if (lookahead == 'H') ADVANCE(530);
      if (lookahead == 'N') ADVANCE(102);
      END_STATE();
    case 120:
      if (lookahead == 'H') ADVANCE(52);
      END_STATE();
    case 121:
      if (lookahead == 'H') ADVANCE(98);
      END_STATE();
    case 122:
      if (lookahead == 'H') ADVANCE(109);
      END_STATE();
    case 123:
      if (lookahead == 'I') ADVANCE(64);
      if (lookahead == 'R') ADVANCE(172);
      END_STATE();
    case 124:
      if (lookahead == 'I') ADVANCE(161);
      END_STATE();
    case 125:
      if (lookahead == 'I') ADVANCE(216);
      END_STATE();
    case 126:
      if (lookahead == 'I') ADVANCE(68);
      END_STATE();
    case 127:
      if (lookahead == 'I') ADVANCE(181);
      END_STATE();
    case 128:
      if (lookahead == 'I') ADVANCE(164);
      END_STATE();
    case 129:
      if (lookahead == 'I') ADVANCE(180);
      END_STATE();
    case 130:
      if (lookahead == 'I') ADVANCE(182);
      END_STATE();
    case 131:
      if (lookahead == 'I') ADVANCE(185);
      END_STATE();
    case 132:
      if (lookahead == 'I') ADVANCE(186);
      END_STATE();
    case 133:
      if (lookahead == 'I') ADVANCE(230);
      END_STATE();
    case 134:
      if (lookahead == 'I') ADVANCE(56);
      END_STATE();
    case 135:
      if (lookahead == 'I') ADVANCE(222);
      END_STATE();
    case 136:
      if (lookahead == 'K') ADVANCE(569);
      END_STATE();
    case 137:
      if (lookahead == 'K') ADVANCE(88);
      END_STATE();
    case 138:
      if (lookahead == 'L') ADVANCE(235);
      END_STATE();
    case 139:
      if (lookahead == 'L') ADVANCE(498);
      END_STATE();
    case 140:
      if (lookahead == 'L') ADVANCE(584);
      END_STATE();
    case 141:
      if (lookahead == 'L') ADVANCE(142);
      END_STATE();
    case 142:
      if (lookahead == 'L') ADVANCE(51);
      END_STATE();
    case 143:
      if (lookahead == 'L') ADVANCE(110);
      END_STATE();
    case 144:
      if (lookahead == 'L') ADVANCE(95);
      END_STATE();
    case 145:
      if (lookahead == 'L') ADVANCE(96);
      END_STATE();
    case 146:
      if (lookahead == 'L') ADVANCE(104);
      END_STATE();
    case 147:
      if (lookahead == 'L') ADVANCE(204);
      END_STATE();
    case 148:
      if (lookahead == 'L') ADVANCE(204);
      if (lookahead == 'N') ADVANCE(43);
      if (lookahead == 'X') ADVANCE(67);
      END_STATE();
    case 149:
      if (lookahead == 'L') ADVANCE(209);
      END_STATE();
    case 150:
      if (lookahead == 'M') ADVANCE(190);
      END_STATE();
    case 151:
      if (lookahead == 'M') ADVANCE(93);
      END_STATE();
    case 152:
      if (lookahead == 'M') ADVANCE(509);
      END_STATE();
    case 153:
      if (lookahead == 'M') ADVANCE(541);
      END_STATE();
    case 154:
      if (lookahead == 'M') ADVANCE(58);
      END_STATE();
    case 155:
      if (lookahead == 'M') ADVANCE(49);
      END_STATE();
    case 156:
      if (lookahead == 'M') ADVANCE(44);
      END_STATE();
    case 157:
      if (lookahead == 'M') ADVANCE(156);
      if (lookahead == 'T') ADVANCE(547);
      END_STATE();
    case 158:
      if (lookahead == 'N') ADVANCE(63);
      if (lookahead == 'S') ADVANCE(82);
      END_STATE();
    case 159:
      if (lookahead == 'N') ADVANCE(537);
      END_STATE();
    case 160:
      if (lookahead == 'N') ADVANCE(537);
      if (lookahead == 'O') ADVANCE(195);
      END_STATE();
    case 161:
      if (lookahead == 'N') ADVANCE(117);
      END_STATE();
    case 162:
      if (lookahead == 'N') ADVANCE(500);
      END_STATE();
    case 163:
      if (lookahead == 'N') ADVANCE(582);
      END_STATE();
    case 164:
      if (lookahead == 'N') ADVANCE(545);
      END_STATE();
    case 165:
      if (lookahead == 'N') ADVANCE(861);
      END_STATE();
    case 166:
      if (lookahead == 'N') ADVANCE(502);
      END_STATE();
    case 167:
      if (lookahead == 'N') ADVANCE(590);
      END_STATE();
    case 168:
      if (lookahead == 'N') ADVANCE(118);
      END_STATE();
    case 169:
      if (lookahead == 'N') ADVANCE(205);
      if (lookahead == 'R') ADVANCE(179);
      END_STATE();
    case 170:
      if (lookahead == 'N') ADVANCE(75);
      END_STATE();
    case 171:
      if (lookahead == 'N') ADVANCE(215);
      END_STATE();
    case 172:
      if (lookahead == 'O') ADVANCE(175);
      END_STATE();
    case 173:
      if (lookahead == 'O') ADVANCE(176);
      if (lookahead == 'Y') ADVANCE(551);
      END_STATE();
    case 174:
      if (lookahead == 'O') ADVANCE(74);
      END_STATE();
    case 175:
      if (lookahead == 'O') ADVANCE(114);
      if (lookahead == 'P') ADVANCE(178);
      if (lookahead == 'V') ADVANCE(91);
      END_STATE();
    case 176:
      if (lookahead == 'O') ADVANCE(143);
      END_STATE();
    case 177:
      if (lookahead == 'O') ADVANCE(162);
      END_STATE();
    case 178:
      if (lookahead == 'O') ADVANCE(206);
      END_STATE();
    case 179:
      if (lookahead == 'O') ADVANCE(141);
      END_STATE();
    case 180:
      if (lookahead == 'O') ADVANCE(163);
      END_STATE();
    case 181:
      if (lookahead == 'O') ADVANCE(152);
      END_STATE();
    case 182:
      if (lookahead == 'O') ADVANCE(225);
      END_STATE();
    case 183:
      if (lookahead == 'O') ADVANCE(197);
      END_STATE();
    case 184:
      if (lookahead == 'O') ADVANCE(188);
      END_STATE();
    case 185:
      if (lookahead == 'O') ADVANCE(166);
      END_STATE();
    case 186:
      if (lookahead == 'O') ADVANCE(167);
      END_STATE();
    case 187:
      if (lookahead == 'O') ADVANCE(229);
      END_STATE();
    case 188:
      if (lookahead == 'O') ADVANCE(211);
      END_STATE();
    case 189:
      if (lookahead == 'P') ADVANCE(213);
      END_STATE();
    case 190:
      if (lookahead == 'P') ADVANCE(183);
      END_STATE();
    case 191:
      if (lookahead == 'R') ADVANCE(512);
      END_STATE();
    case 192:
      if (lookahead == 'R') ADVANCE(236);
      END_STATE();
    case 193:
      if (lookahead == 'R') ADVANCE(134);
      END_STATE();
    case 194:
      if (lookahead == 'R') ADVANCE(187);
      END_STATE();
    case 195:
      if (lookahead == 'R') ADVANCE(103);
      END_STATE();
    case 196:
      if (lookahead == 'R') ADVANCE(208);
      END_STATE();
    case 197:
      if (lookahead == 'R') ADVANCE(54);
      END_STATE();
    case 198:
      if (lookahead == 'S') ADVANCE(518);
      END_STATE();
    case 199:
      if (lookahead == 'S') ADVANCE(586);
      END_STATE();
    case 200:
      if (lookahead == 'S') ADVANCE(567);
      END_STATE();
    case 201:
      if (lookahead == 'S') ADVANCE(574);
      END_STATE();
    case 202:
      if (lookahead == 'S') ADVANCE(224);
      END_STATE();
    case 203:
      if (lookahead == 'S') ADVANCE(83);
      END_STATE();
    case 204:
      if (lookahead == 'S') ADVANCE(84);
      END_STATE();
    case 205:
      if (lookahead == 'S') ADVANCE(220);
      END_STATE();
    case 206:
      if (lookahead == 'S') ADVANCE(135);
      END_STATE();
    case 207:
      if (lookahead == 'S') ADVANCE(200);
      END_STATE();
    case 208:
      if (lookahead == 'S') ADVANCE(133);
      END_STATE();
    case 209:
      if (lookahead == 'S') ADVANCE(90);
      END_STATE();
    case 210:
      if (lookahead == 'S') ADVANCE(106);
      END_STATE();
    case 211:
      if (lookahead == 'S') ADVANCE(94);
      END_STATE();
    case 212:
      if (lookahead == 'T') ADVANCE(119);
      END_STATE();
    case 213:
      if (lookahead == 'T') ADVANCE(511);
      END_STATE();
    case 214:
      if (lookahead == 'T') ADVANCE(528);
      END_STATE();
    case 215:
      if (lookahead == 'T') ADVANCE(532);
      END_STATE();
    case 216:
      if (lookahead == 'T') ADVANCE(219);
      END_STATE();
    case 217:
      if (lookahead == 'T') ADVANCE(92);
      END_STATE();
    case 218:
      if (lookahead == 'T') ADVANCE(129);
      END_STATE();
    case 219:
      if (lookahead == 'T') ADVANCE(105);
      END_STATE();
    case 220:
      if (lookahead == 'T') ADVANCE(55);
      END_STATE();
    case 221:
      if (lookahead == 'T') ADVANCE(131);
      END_STATE();
    case 222:
      if (lookahead == 'T') ADVANCE(132);
      END_STATE();
    case 223:
      if (lookahead == 'U') ADVANCE(196);
      END_STATE();
    case 224:
      if (lookahead == 'U') ADVANCE(151);
      END_STATE();
    case 225:
      if (lookahead == 'U') ADVANCE(199);
      END_STATE();
    case 226:
      if (lookahead == 'U') ADVANCE(89);
      END_STATE();
    case 227:
      if (lookahead == 'U') ADVANCE(144);
      END_STATE();
    case 228:
      if (lookahead == 'V') ADVANCE(86);
      END_STATE();
    case 229:
      if (lookahead == 'V') ADVANCE(91);
      END_STATE();
    case 230:
      if (lookahead == 'V') ADVANCE(97);
      END_STATE();
    case 231:
      if (lookahead == 'V') ADVANCE(130);
      END_STATE();
    case 232:
      if (lookahead == 'W') ADVANCE(576);
      END_STATE();
    case 233:
      if (lookahead == 'X') ADVANCE(7);
      END_STATE();
    case 234:
      if (lookahead == 'X') ADVANCE(66);
      END_STATE();
    case 235:
      if (lookahead == 'Y') ADVANCE(592);
      END_STATE();
    case 236:
      if (lookahead == 'Y') ADVANCE(543);
      END_STATE();
    case 237:
      if (lookahead == ']') ADVANCE(484);
      END_STATE();
    case 238:
      if (lookahead == '_') ADVANCE(520);
      END_STATE();
    case 239:
      if (lookahead == '_') ADVANCE(522);
      END_STATE();
    case 240:
      if (lookahead == '_') ADVANCE(878);
      END_STATE();
    case 241:
      if (lookahead == 'a') ADVANCE(292);
      END_STATE();
    case 242:
      if (lookahead == 'a') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(317);
      if (lookahead == 'i') ADVANCE(345);
      if (lookahead == 'o') ADVANCE(309);
      if (lookahead == 'u') ADVANCE(323);
      END_STATE();
    case 243:
      if (lookahead == 'a') ADVANCE(305);
      if (lookahead == 'e') ADVANCE(332);
      if (lookahead == 'l') ADVANCE(948);
      if (lookahead == 'n') ADVANCE(318);
      if (lookahead == 'o') ADVANCE(342);
      END_STATE();
    case 244:
      if (lookahead == 'a') ADVANCE(305);
      if (lookahead == 'e') ADVANCE(332);
      if (lookahead == 'l') ADVANCE(948);
      if (lookahead == 'o') ADVANCE(342);
      END_STATE();
    case 245:
      if (lookahead == 'a') ADVANCE(352);
      END_STATE();
    case 246:
      if (lookahead == 'a') ADVANCE(325);
      if (lookahead == 'u') ADVANCE(326);
      END_STATE();
    case 247:
      if (lookahead == 'a') ADVANCE(343);
      END_STATE();
    case 248:
      if (lookahead == 'a') ADVANCE(298);
      END_STATE();
    case 249:
      if (lookahead == 'b') ADVANCE(360);
      if (lookahead == 'c') ADVANCE(254);
      if (lookahead == 'p') ADVANCE(361);
      END_STATE();
    case 250:
      if (lookahead == 'b') ADVANCE(362);
      if (lookahead == 'p') ADVANCE(363);
      END_STATE();
    case 251:
      if (lookahead == 'c') ADVANCE(246);
      if (lookahead == 's') ADVANCE(379);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(1040);
      END_STATE();
    case 253:
      if (lookahead == 'c') ADVANCE(952);
      END_STATE();
    case 254:
      if (lookahead == 'c') ADVANCE(954);
      END_STATE();
    case 255:
      if (lookahead == 'c') ADVANCE(1032);
      END_STATE();
    case 256:
      if (lookahead == 'c') ADVANCE(254);
      END_STATE();
    case 257:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 258:
      if (lookahead == 'c') ADVANCE(375);
      END_STATE();
    case 259:
      if (lookahead == 'd') ADVANCE(903);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(331);
      if (lookahead == 'g') ADVANCE(946);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(276);
      if (lookahead == 'o') ADVANCE(378);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 264:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'o') ADVANCE(328);
      END_STATE();
    case 266:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 268:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(357);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(370);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(371);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(372);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(374);
      END_STATE();
    case 275:
      if (lookahead == 'g') ADVANCE(257);
      END_STATE();
    case 276:
      if (lookahead == 'g') ADVANCE(880);
      END_STATE();
    case 277:
      if (lookahead == 'g') ADVANCE(942);
      END_STATE();
    case 278:
      if (lookahead == 'h') ADVANCE(1022);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(275);
      if (lookahead == 'u') ADVANCE(297);
      END_STATE();
    case 280:
      if (lookahead == 'i') ADVANCE(275);
      if (lookahead == 'u') ADVANCE(297);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(851);
      END_STATE();
    case 281:
      if (lookahead == 'i') ADVANCE(384);
      if (lookahead == 'o') ADVANCE(366);
      END_STATE();
    case 282:
      if (lookahead == 'i') ADVANCE(300);
      if (lookahead == 'q') ADVANCE(251);
      if (lookahead == 't') ADVANCE(247);
      if (lookahead == 'u') ADVANCE(249);
      END_STATE();
    case 283:
      if (lookahead == 'i') ADVANCE(300);
      if (lookahead == 'q') ADVANCE(251);
      if (lookahead == 't') ADVANCE(247);
      if (lookahead == 'u') ADVANCE(256);
      END_STATE();
    case 284:
      if (lookahead == 'i') ADVANCE(359);
      END_STATE();
    case 285:
      if (lookahead == 'i') ADVANCE(385);
      END_STATE();
    case 286:
      if (lookahead == 'i') ADVANCE(301);
      END_STATE();
    case 287:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 288:
      if (lookahead == 'i') ADVANCE(312);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(306);
      END_STATE();
    case 290:
      if (lookahead == 'i') ADVANCE(347);
      END_STATE();
    case 291:
      if (lookahead == 'i') ADVANCE(303);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(867);
      END_STATE();
    case 293:
      if (lookahead == 'l') ADVANCE(465);
      END_STATE();
    case 294:
      if (lookahead == 'l') ADVANCE(380);
      END_STATE();
    case 295:
      if (lookahead == 'l') ADVANCE(245);
      END_STATE();
    case 296:
      if (lookahead == 'l') ADVANCE(270);
      END_STATE();
    case 297:
      if (lookahead == 'l') ADVANCE(296);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(293);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(382);
      END_STATE();
    case 300:
      if (lookahead == 'm') ADVANCE(962);
      END_STATE();
    case 301:
      if (lookahead == 'm') ADVANCE(266);
      END_STATE();
    case 302:
      if (lookahead == 'm') ADVANCE(324);
      END_STATE();
    case 303:
      if (lookahead == 'm') ADVANCE(269);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(460);
      END_STATE();
    case 305:
      if (lookahead == 'n') ADVANCE(259);
      END_STATE();
    case 306:
      if (lookahead == 'n') ADVANCE(950);
      END_STATE();
    case 307:
      if (lookahead == 'n') ADVANCE(995);
      END_STATE();
    case 308:
      if (lookahead == 'n') ADVANCE(459);
      END_STATE();
    case 309:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 310:
      if (lookahead == 'n') ADVANCE(287);
      if (lookahead == 'p') ADVANCE(299);
      END_STATE();
    case 311:
      if (lookahead == 'n') ADVANCE(318);
      END_STATE();
    case 312:
      if (lookahead == 'n') ADVANCE(383);
      END_STATE();
    case 313:
      if (lookahead == 'o') ADVANCE(386);
      END_STATE();
    case 314:
      if (lookahead == 'o') ADVANCE(960);
      END_STATE();
    case 315:
      if (lookahead == 'o') ADVANCE(378);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(349);
      END_STATE();
    case 317:
      if (lookahead == 'o') ADVANCE(367);
      END_STATE();
    case 318:
      if (lookahead == 'o') ADVANCE(368);
      END_STATE();
    case 319:
      if (lookahead == 'o') ADVANCE(307);
      END_STATE();
    case 320:
      if (lookahead == 'o') ADVANCE(369);
      END_STATE();
    case 321:
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == 's') ADVANCE(387);
      END_STATE();
    case 322:
      if (lookahead == 'p') ADVANCE(991);
      END_STATE();
    case 323:
      if (lookahead == 'p') ADVANCE(994);
      END_STATE();
    case 324:
      if (lookahead == 'p') ADVANCE(940);
      END_STATE();
    case 325:
      if (lookahead == 'p') ADVANCE(1051);
      END_STATE();
    case 326:
      if (lookahead == 'p') ADVANCE(1053);
      END_STATE();
    case 327:
      if (lookahead == 'p') ADVANCE(346);
      END_STATE();
    case 328:
      if (lookahead == 'p') ADVANCE(376);
      END_STATE();
    case 329:
      if (lookahead == 'q') ADVANCE(381);
      END_STATE();
    case 330:
      if (lookahead == 'q') ADVANCE(381);
      if (lookahead == 'x') ADVANCE(284);
      END_STATE();
    case 331:
      if (lookahead == 'q') ADVANCE(927);
      END_STATE();
    case 332:
      if (lookahead == 'q') ADVANCE(924);
      END_STATE();
    case 333:
      if (lookahead == 'q') ADVANCE(944);
      END_STATE();
    case 334:
      if (lookahead == 'q') ADVANCE(964);
      END_STATE();
    case 335:
      if (lookahead == 'q') ADVANCE(956);
      END_STATE();
    case 336:
      if (lookahead == 'q') ADVANCE(958);
      END_STATE();
    case 337:
      if (lookahead == 'q') ADVANCE(978);
      END_STATE();
    case 338:
      if (lookahead == 'q') ADVANCE(980);
      END_STATE();
    case 339:
      if (lookahead == 'q') ADVANCE(970);
      END_STATE();
    case 340:
      if (lookahead == 'q') ADVANCE(972);
      END_STATE();
    case 341:
      if (lookahead == 'r') ADVANCE(1060);
      END_STATE();
    case 342:
      if (lookahead == 'r') ADVANCE(906);
      END_STATE();
    case 343:
      if (lookahead == 'r') ADVANCE(1042);
      END_STATE();
    case 344:
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(252);
      END_STATE();
    case 346:
      if (lookahead == 'r') ADVANCE(313);
      END_STATE();
    case 347:
      if (lookahead == 'r') ADVANCE(255);
      END_STATE();
    case 348:
      if (lookahead == 'r') ADVANCE(264);
      END_STATE();
    case 349:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 350:
      if (lookahead == 'r') ADVANCE(358);
      END_STATE();
    case 351:
      if (lookahead == 's') ADVANCE(1003);
      END_STATE();
    case 352:
      if (lookahead == 's') ADVANCE(278);
      END_STATE();
    case 353:
      if (lookahead == 's') ADVANCE(1058);
      END_STATE();
    case 354:
      if (lookahead == 's') ADVANCE(1055);
      END_STATE();
    case 355:
      if (lookahead == 's') ADVANCE(468);
      END_STATE();
    case 356:
      if (lookahead == 's') ADVANCE(1006);
      END_STATE();
    case 357:
      if (lookahead == 's') ADVANCE(1025);
      END_STATE();
    case 358:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 359:
      if (lookahead == 's') ADVANCE(377);
      END_STATE();
    case 360:
      if (lookahead == 's') ADVANCE(271);
      END_STATE();
    case 361:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 362:
      if (lookahead == 's') ADVANCE(273);
      END_STATE();
    case 363:
      if (lookahead == 's') ADVANCE(274);
      END_STATE();
    case 364:
      if (lookahead == 't') ADVANCE(865);
      END_STATE();
    case 365:
      if (lookahead == 't') ADVANCE(863);
      END_STATE();
    case 366:
      if (lookahead == 't') ADVANCE(263);
      END_STATE();
    case 367:
      if (lookahead == 't') ADVANCE(1062);
      END_STATE();
    case 368:
      if (lookahead == 't') ADVANCE(879);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(1019);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(1034);
      END_STATE();
    case 371:
      if (lookahead == 't') ADVANCE(974);
      END_STATE();
    case 372:
      if (lookahead == 't') ADVANCE(976);
      END_STATE();
    case 373:
      if (lookahead == 't') ADVANCE(966);
      END_STATE();
    case 374:
      if (lookahead == 't') ADVANCE(968);
      END_STATE();
    case 375:
      if (lookahead == 't') ADVANCE(992);
      END_STATE();
    case 376:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(355);
      END_STATE();
    case 378:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 379:
      if (lookahead == 'u') ADVANCE(250);
      END_STATE();
    case 380:
      if (lookahead == 'u') ADVANCE(351);
      END_STATE();
    case 381:
      if (lookahead == 'u') ADVANCE(285);
      END_STATE();
    case 382:
      if (lookahead == 'u') ADVANCE(354);
      END_STATE();
    case 383:
      if (lookahead == 'u') ADVANCE(356);
      END_STATE();
    case 384:
      if (lookahead == 'v') ADVANCE(1036);
      END_STATE();
    case 385:
      if (lookahead == 'v') ADVANCE(896);
      END_STATE();
    case 386:
      if (lookahead == 'x') ADVANCE(929);
      END_STATE();
    case 387:
      if (lookahead == 'y') ADVANCE(302);
      END_STATE();
    case 388:
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(2);
      END_STATE();
    case 389:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(851);
      END_STATE();
    case 390:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(390)
      if (lookahead == '\r') SKIP(390)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'A') ADVANCE(788);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(639);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'H') ADVANCE(595);
      if (lookahead == 'I') ADVANCE(677);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'P') ADVANCE(695);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(679);
      if (lookahead == 'T') ADVANCE(596);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'W') ADVANCE(684);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 391:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(391)
      if (lookahead == '\r') SKIP(391)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(876);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(600);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(677);
      if (lookahead == 'L') ADVANCE(653);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(664);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(690);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 392:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(392)
      if (lookahead == '\r') SKIP(392)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'A') ADVANCE(631);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(601);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(656);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(681);
      if (lookahead == 'T') ADVANCE(667);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'V') ADVANCE(618);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 393:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(393)
      if (lookahead == '\r') SKIP(393)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(662);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'M') ADVANCE(764);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'O') ADVANCE(748);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 394:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(394)
      if (lookahead == '\r') SKIP(394)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(662);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'M') ADVANCE(764);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 395:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(395)
      if (lookahead == '\r') SKIP(395)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(609);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(494);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 396:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(396)
      if (lookahead == '\r') SKIP(396)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(494);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 397:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(397)
      if (lookahead == '\r') SKIP(397)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(676);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(664);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 398:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(398)
      if (lookahead == '\r') SKIP(398)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'O') ADVANCE(807);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 399:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(399)
      if (lookahead == '\r') SKIP(399)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(921);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (lookahead == 12297) ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 400:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(400)
      if (lookahead == '\r') SKIP(400)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'A') ADVANCE(788);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 401:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(401)
      if (lookahead == '\r') SKIP(401)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(876);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 402:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(402)
      if (lookahead == '\r') SKIP(402)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(989);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 403:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(403)
      if (lookahead == '\r') SKIP(403)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(488);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(921);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(989);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (lookahead == 12297) ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(849);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 404:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(404)
      if (lookahead == '\r') SKIP(404)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'I') ADVANCE(741);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 405:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(405)
      if (lookahead == '\r') SKIP(405)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 406:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(406)
      if (lookahead == '\r') SKIP(406)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(887);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'E') ADVANCE(234);
      if (lookahead == 'P') ADVANCE(194);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == ']') ADVANCE(240);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10230) ADVANCE(475);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 407:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(407)
      if (lookahead == '\r') SKIP(407)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(488);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(78);
      if (lookahead == 'E') ADVANCE(147);
      if (lookahead == 'P') ADVANCE(194);
      if (lookahead == 'T') ADVANCE(122);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == ']') ADVANCE(844);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 408:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(408)
      if (lookahead == '\r') SKIP(408)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(842);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 409:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(409)
      if (lookahead == '\r') SKIP(409)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(920);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12297) ADVANCE(481);
      END_STATE();
    case 410:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(410)
      if (lookahead == '\r') SKIP(410)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(10);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(989);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 411:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(411)
      if (lookahead == '\r') SKIP(411)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1011);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10236) ADVANCE(473);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 412:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(412)
      if (lookahead == '\r') SKIP(412)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(875);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(842);
      if (lookahead == '\\') ADVANCE(990);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 413:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(413)
      if (lookahead == '\r') SKIP(413)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(10);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(990);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 414:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(414)
      if (lookahead == '\r') SKIP(414)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(874);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 415:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(415)
      if (lookahead == '\r') SKIP(415)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(887);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(487);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'E') ADVANCE(234);
      if (lookahead == '[') ADVANCE(842);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == ']') ADVANCE(240);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1011);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10230) ADVANCE(475);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10236) ADVANCE(473);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 416:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(416)
      if (lookahead == '\r') SKIP(416)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(487);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'D') ADVANCE(78);
      if (lookahead == 'E') ADVANCE(147);
      if (lookahead == 'P') ADVANCE(194);
      if (lookahead == 'T') ADVANCE(122);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == ']') ADVANCE(844);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      END_STATE();
    case 417:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(417)
      if (lookahead == '\r') SKIP(417)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(10);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(887);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10230) ADVANCE(475);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 418:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(419)
      if (lookahead == '\r') SKIP(419)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1076);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == '>') ADVANCE(1073);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(742);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == ']') ADVANCE(844);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '|') ADVANCE(21);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 10229) ADVANCE(463);
      if (lookahead == 10236) ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1077);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 419:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(419)
      if (lookahead == '\r') SKIP(419)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(742);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == ']') ADVANCE(844);
      if (lookahead == '|') ADVANCE(21);
      if (lookahead == '}') ADVANCE(870);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 10229) ADVANCE(463);
      if (lookahead == 10236) ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 420:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(421)
      if (lookahead == '\r') SKIP(421)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1076);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == '>') ADVANCE(36);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 12297) ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1077);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 421:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(421)
      if (lookahead == '\r') SKIP(421)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == '>') ADVANCE(36);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 12297) ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 422:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(422)
      if (lookahead == '\r') SKIP(422)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(25);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(662);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 423:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(423)
      if (lookahead == '\r') SKIP(423)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == 'W') ADVANCE(700);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 424:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(424)
      if (lookahead == '\r') SKIP(424)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(31);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'M') ADVANCE(764);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 425:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(425)
      if (lookahead == '\r') SKIP(425)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '.') ADVANCE(871);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(873);
      if (lookahead == 'A') ADVANCE(632);
      if (lookahead == 'C') ADVANCE(770);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(810);
      if (lookahead == 'T') ADVANCE(668);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'V') ADVANCE(618);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(494);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 426:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(427)
      if (lookahead == '\r') SKIP(427)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*') ADVANCE(1076);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'I') ADVANCE(741);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 10229) ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1077);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 427:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(427)
      if (lookahead == '\r') SKIP(427)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'I') ADVANCE(741);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8796) ADVANCE(458);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 10229) ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 428:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(428)
      if (lookahead == '\r') SKIP(428)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 429:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(429)
      if (lookahead == '\r') SKIP(429)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 430:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(431)
      if (lookahead == '\r') SKIP(431)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == '*') ADVANCE(1076);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(494);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1077);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 431:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(431)
      if (lookahead == '\r') SKIP(431)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '_') ADVANCE(494);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 432:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(432)
      if (lookahead == '\r') SKIP(432)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'I') ADVANCE(741);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(700);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 433:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(433)
      if (lookahead == '\r') SKIP(433)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(700);
      if (lookahead == '[') ADVANCE(237);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '~') ADVANCE(881);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 9633) ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 434:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(434)
      if (lookahead == '\r') SKIP(434)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '<') ADVANCE(17);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == 10229) ADVANCE(463);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 435:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(435)
      if (lookahead == '\r') SKIP(435)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == 'P') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '_') ADVANCE(493);
      if (lookahead == 8712) ADVANCE(461);
      END_STATE();
    case 436:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(435)
      if (lookahead == '\r') SKIP(435)
      if (lookahead == '!') ADVANCE(845);
      if (lookahead == '(') ADVANCE(839);
      if (lookahead == ')') ADVANCE(841);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(1071);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '<') ADVANCE(915);
      if (lookahead == 'P') ADVANCE(194);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '_') ADVANCE(493);
      if (lookahead == 8712) ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1072);
      END_STATE();
    case 437:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(437)
      if (lookahead == '\r') SKIP(437)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '\\') ADVANCE(11);
      END_STATE();
    case 438:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(437)
      if (lookahead == '\r') SKIP(437)
      if (lookahead == '(') ADVANCE(9);
      if (lookahead == '\\') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1078);
      END_STATE();
    case 439:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(439)
      if (lookahead == '\r') SKIP(439)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(609);
      if (lookahead == 'M') ADVANCE(764);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 440:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(440)
      if (lookahead == '\r') SKIP(440)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(677);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 441:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(441)
      if (lookahead == '\r') SKIP(441)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(918);
      if (lookahead == '=') ADVANCE(876);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == 'A') ADVANCE(799);
      if (lookahead == 'C') ADVANCE(756);
      if (lookahead == 'D') ADVANCE(662);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'H') ADVANCE(694);
      if (lookahead == 'I') ADVANCE(745);
      if (lookahead == 'L') ADVANCE(671);
      if (lookahead == 'P') ADVANCE(779);
      if (lookahead == 'R') ADVANCE(665);
      if (lookahead == 'S') ADVANCE(819);
      if (lookahead == 'T') ADVANCE(691);
      if (lookahead == 'U') ADVANCE(732);
      if (lookahead == 'V') ADVANCE(615);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(987);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 442:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(442)
      if (lookahead == '\r') SKIP(442)
      if (lookahead == '!') ADVANCE(846);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == ',') ADVANCE(838);
      if (lookahead == '-') ADVANCE(888);
      if (lookahead == '.') ADVANCE(872);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == '<') ADVANCE(917);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(921);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(38);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(988);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(33);
      if (lookahead == 215) ADVANCE(1059);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8733) ADVANCE(961);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8759) ADVANCE(492);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8834) ADVANCE(975);
      if (lookahead == 8835) ADVANCE(977);
      if (lookahead == 8838) ADVANCE(979);
      if (lookahead == 8839) ADVANCE(981);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12297) ADVANCE(480);
      END_STATE();
    case 443:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(443)
      if (lookahead == '\r') SKIP(443)
      if (lookahead == '!') ADVANCE(1);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(913);
      if (lookahead == '$') ADVANCE(1049);
      if (lookahead == '%') ADVANCE(1009);
      if (lookahead == '&') ADVANCE(1017);
      if (lookahead == '\'') ADVANCE(1070);
      if (lookahead == '(') ADVANCE(840);
      if (lookahead == '*') ADVANCE(1028);
      if (lookahead == '+') ADVANCE(1001);
      if (lookahead == '-') ADVANCE(886);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(916);
      if (lookahead == '=') ADVANCE(877);
      if (lookahead == '>') ADVANCE(919);
      if (lookahead == '?') ADVANCE(37);
      if (lookahead == '@') ADVANCE(489);
      if (lookahead == 'B') ADVANCE(758);
      if (lookahead == 'C') ADVANCE(602);
      if (lookahead == 'D') ADVANCE(755);
      if (lookahead == 'E') ADVANCE(743);
      if (lookahead == 'F') ADVANCE(594);
      if (lookahead == 'I') ADVANCE(678);
      if (lookahead == 'L') ADVANCE(640);
      if (lookahead == 'M') ADVANCE(764);
      if (lookahead == 'N') ADVANCE(832);
      if (lookahead == 'R') ADVANCE(833);
      if (lookahead == 'S') ADVANCE(680);
      if (lookahead == 'T') ADVANCE(775);
      if (lookahead == 'U') ADVANCE(733);
      if (lookahead == 'W') ADVANCE(685);
      if (lookahead == '[') ADVANCE(843);
      if (lookahead == '\\') ADVANCE(986);
      if (lookahead == '^') ADVANCE(1064);
      if (lookahead == '_') ADVANCE(446);
      if (lookahead == '{') ADVANCE(869);
      if (lookahead == '|') ADVANCE(1012);
      if (lookahead == '~') ADVANCE(882);
      if (lookahead == 172) ADVANCE(883);
      if (lookahead == 247) ADVANCE(1037);
      if (lookahead == 8214) ADVANCE(1014);
      if (lookahead == 8229) ADVANCE(998);
      if (lookahead == 8230) ADVANCE(1000);
      if (lookahead == 8252) ADVANCE(1045);
      if (lookahead == 8263) ADVANCE(1047);
      if (lookahead == 8314) ADVANCE(1067);
      if (lookahead == 8669) ADVANCE(901);
      if (lookahead == 8696) ADVANCE(895);
      if (lookahead == 8704) ADVANCE(466);
      if (lookahead == 8707) ADVANCE(469);
      if (lookahead == 8712) ADVANCE(461);
      if (lookahead == 8713) ADVANCE(951);
      if (lookahead == 8728) ADVANCE(1041);
      if (lookahead == 8743) ADVANCE(904);
      if (lookahead == 8744) ADVANCE(907);
      if (lookahead == 8745) ADVANCE(993);
      if (lookahead == 8746) ADVANCE(996);
      if (lookahead == 8764) ADVANCE(963);
      if (lookahead == 8768) ADVANCE(1061);
      if (lookahead == 8771) ADVANCE(965);
      if (lookahead == 8773) ADVANCE(943);
      if (lookahead == 8776) ADVANCE(930);
      if (lookahead == 8781) ADVANCE(941);
      if (lookahead == 8784) ADVANCE(945);
      if (lookahead == 8788) ADVANCE(909);
      if (lookahead == 8800) ADVANCE(914);
      if (lookahead == 8801) ADVANCE(897);
      if (lookahead == 8804) ADVANCE(925);
      if (lookahead == 8805) ADVANCE(928);
      if (lookahead == 8810) ADVANCE(949);
      if (lookahead == 8811) ADVANCE(947);
      if (lookahead == 8826) ADVANCE(953);
      if (lookahead == 8827) ADVANCE(955);
      if (lookahead == 8846) ADVANCE(1056);
      if (lookahead == 8847) ADVANCE(967);
      if (lookahead == 8848) ADVANCE(969);
      if (lookahead == 8849) ADVANCE(971);
      if (lookahead == 8850) ADVANCE(973);
      if (lookahead == 8851) ADVANCE(1052);
      if (lookahead == 8852) ADVANCE(1054);
      if (lookahead == 8853) ADVANCE(1005);
      if (lookahead == 8854) ADVANCE(1008);
      if (lookahead == 8855) ADVANCE(1027);
      if (lookahead == 8856) ADVANCE(1024);
      if (lookahead == 8857) ADVANCE(1021);
      if (lookahead == 8866) ADVANCE(933);
      if (lookahead == 8867) ADVANCE(937);
      if (lookahead == 8872) ADVANCE(935);
      if (lookahead == 8900) ADVANCE(891);
      if (lookahead == 8901) ADVANCE(1063);
      if (lookahead == 8902) ADVANCE(1043);
      if (lookahead == 9633) ADVANCE(485);
      if (lookahead == 9679) ADVANCE(1035);
      if (lookahead == 9711) ADVANCE(1033);
      if (lookahead == 10233) ADVANCE(893);
      if (lookahead == 10234) ADVANCE(899);
      if (lookahead == 10868) ADVANCE(911);
      if (lookahead == 10927) ADVANCE(957);
      if (lookahead == 10928) ADVANCE(959);
      if (lookahead == 10980) ADVANCE(939);
      if (lookahead == 12296) ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 444:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(852);
      END_STATE();
    case 445:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(850);
      END_STATE();
    case 446:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 447:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(853);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(449);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_STAR_RPAREN);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_MODULE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_single_line);
      if (lookahead == '-') ADVANCE(454);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_double_line);
      if (lookahead == '=') ADVANCE(455);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(29);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_2);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_3);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(470);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_4);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(471);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_5);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_BSLASHAA);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_BSLASHEE);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_6);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_7);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_8);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(482);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_9);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_9);
      if (lookahead == '_') ADVANCE(483);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_10);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(491);
      if (lookahead == '=') ADVANCE(908);
      if (lookahead == '>') ADVANCE(983);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(27);
      if (lookahead == '=') ADVANCE(908);
      if (lookahead == '>') ADVANCE(983);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(982);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(910);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_11);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(446);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_UNION);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_UNION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_ENABLED);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(514);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_OTHER);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_CASE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_SF_);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_WF_);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_IF);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_SUBSET);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_WITH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(538);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(539);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_IN);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_IN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_DOMAIN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_LET);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_UNCHANGED);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_HAVE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_TAKE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'S') ADVANCE(571);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'S') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_HIDE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_USE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_PICK);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_DEFS);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_NEW);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_STATE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_ACTION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_ONLY);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(721);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(824);
      if (lookahead == 'I') ADVANCE(635);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(710);
      if (lookahead == 'R') ADVANCE(822);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(622);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(589);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(790);
      if (lookahead == 'H') ADVANCE(760);
      if (lookahead == 'O') ADVANCE(753);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(790);
      if (lookahead == 'H') ADVANCE(760);
      if (lookahead == 'O') ADVANCE(754);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(790);
      if (lookahead == 'H') ADVANCE(760);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(698);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(711);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(776);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(752);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(712);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(744);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(726);
      if (lookahead == 'E') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(812);
      if (lookahead == 'R') ADVANCE(697);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(812);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(737);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(747);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(749);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(780);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(623);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(624);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A') ADVANCE(784);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(798);
      if (lookahead == 'F') ADVANCE(686);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(798);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(637);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(717);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(718);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B') ADVANCE(719);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(693);
      if (lookahead == 'I') ADVANCE(762);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(709);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(821);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(669);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(652);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(604);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(817);
      if (lookahead == 'S') ADVANCE(789);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C') ADVANCE(817);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(505);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(550);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(644);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(823);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(599);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D') ADVANCE(787);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(683);
      if (lookahead == 'O') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(553);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(856);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(858);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(496);
      if (lookahead == 'P') ADVANCE(811);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(525);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(565);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(540);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(729);
      if (lookahead == 'O') ADVANCE(630);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(507);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(562);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(826);
      if (lookahead == 'a') ADVANCE(836);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(581);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(508);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(633);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(634);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(682);
      if (lookahead == 'O') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(803);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(627);
      if (lookahead == 'e') ADVANCE(831);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(627);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(724);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(731);
      if (lookahead == 'R') ADVANCE(822);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(731);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(786);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(765);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(730);
      if (lookahead == 'O') ADVANCE(630);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(777);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(746);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(793);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E') ADVANCE(612);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(527);
      if (lookahead == 'N') ADVANCE(536);
      if (lookahead == 'n') ADVANCE(835);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(527);
      if (lookahead == 'N') ADVANCE(791);
      if (lookahead == 'n') ADVANCE(835);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(527);
      if (lookahead == 'n') ADVANCE(835);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(829);
      if (lookahead == 'T') ADVANCE(778);
      if (lookahead == 'U') ADVANCE(619);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(829);
      if (lookahead == 'T') ADVANCE(778);
      if (lookahead == 'U') ADVANCE(620);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(829);
      if (lookahead == 'T') ADVANCE(610);
      if (lookahead == 'U') ADVANCE(620);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(558);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(702);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(830);
      if (lookahead == 'I') ADVANCE(806);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(830);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F') ADVANCE(696);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(860);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'G') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(531);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(670);
      if (lookahead == 'R') ADVANCE(822);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(670);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(672);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H') ADVANCE(608);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(635);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(626);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(628);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(734);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(736);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(763);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(808);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(825);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(751);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(768);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(769);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(771);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(616);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(617);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I') ADVANCE(816);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K') ADVANCE(570);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K') ADVANCE(645);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(585);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(828);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(715);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(605);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(675);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(660);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(654);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(658);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(659);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L') ADVANCE(795);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(648);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(510);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(603);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(621);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(598);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(649);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(727);
      if (lookahead == 'T') ADVANCE(548);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(727);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M') ADVANCE(774);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(625);
      if (lookahead == 'S') ADVANCE(641);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(625);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(687);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(862);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(503);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(591);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(583);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(536);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(597);
      if (lookahead == 'X') ADVANCE(813);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(597);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(688);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(791);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(638);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(804);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(713);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(805);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(674);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(651);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(629);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(800);
      if (lookahead == 'R') ADVANCE(761);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N') ADVANCE(801);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(725);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(753);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(773);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(759);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(716);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(772);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(714);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(735);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(723);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(636);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(781);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(783);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(794);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(738);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(739);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(754);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(740);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O') ADVANCE(797);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'P') ADVANCE(767);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'P') ADVANCE(766);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(822);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(827);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(513);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(697);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(757);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(706);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(666);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(796);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(607);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R') ADVANCE(707);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(575);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(789);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(818);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(642);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(809);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(820);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(785);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(708);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(647);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(701);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(650);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(663);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(792);
      if (lookahead == 'X') ADVANCE(699);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(814);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S') ADVANCE(815);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(548);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(533);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(750);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(692);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(689);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(606);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(611);
      if (lookahead == 'U') ADVANCE(620);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(703);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(657);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(673);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(613);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(614);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(704);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T') ADVANCE(705);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(728);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(620);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(722);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(782);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(646);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U') ADVANCE(720);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'V') ADVANCE(643);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'V') ADVANCE(655);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W') ADVANCE(577);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'Y') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'Y') ADVANCE(593);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(521);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(834);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(836);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(831);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(868);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(866);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(864);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(450);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(450);
      if (lookahead == '+') ADVANCE(3);
      if (lookahead == '-') ADVANCE(4);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '\\') ADVANCE(233);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(484);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '!') ADVANCE(1044);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(445);
      if (lookahead == '_') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(847);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(848);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(849);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym__real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(850);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym__binary_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(851);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym__octal_number);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(852);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym__hex_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(853);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(anon_sym_TRUE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(anon_sym_FALSE);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(anon_sym_STRING);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(anon_sym_STRING);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(anon_sym_BOOLEAN);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(anon_sym_BOOLEAN);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(anon_sym_Nat);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(anon_sym_Int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(anon_sym_Real);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(837);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(997);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(923);
      if (lookahead == '=') ADVANCE(457);
      if (lookahead == '>') ADVANCE(892);
      if (lookahead == '|') ADVANCE(938);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(923);
      if (lookahead == '=') ADVANCE(456);
      if (lookahead == '>') ADVANCE(892);
      if (lookahead == '|') ADVANCE(938);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(923);
      if (lookahead == '=') ADVANCE(28);
      if (lookahead == '>') ADVANCE(892);
      if (lookahead == '|') ADVANCE(938);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(923);
      if (lookahead == '>') ADVANCE(892);
      if (lookahead == '|') ADVANCE(938);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(900);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(anon_sym_12);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(15);
      if (lookahead == '-') ADVANCE(1016);
      if (lookahead == '.') ADVANCE(889);
      if (lookahead == '>') ADVANCE(474);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(15);
      if (lookahead == '-') ADVANCE(1016);
      if (lookahead == '.') ADVANCE(889);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(15);
      if (lookahead == '-') ADVANCE(1015);
      if (lookahead == '.') ADVANCE(889);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(15);
      if (lookahead == '-') ADVANCE(1015);
      if (lookahead == '>') ADVANCE(474);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(15);
      if (lookahead == '-') ADVANCE(1015);
      if (lookahead == '|') ADVANCE(936);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(anon_sym_13);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(anon_sym_14);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_15);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_16);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_17);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_18);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_19);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_20);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_21);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(anon_sym_22);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(1048);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_23);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(984);
      if (lookahead == '<') ADVANCE(476);
      if (lookahead == '=') ADVANCE(922);
      if (lookahead == '>') ADVANCE(890);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(984);
      if (lookahead == '=') ADVANCE(922);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(984);
      if (lookahead == '=') ADVANCE(922);
      if (lookahead == '>') ADVANCE(890);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(926);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(926);
      if (lookahead == '>') ADVANCE(479);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(926);
      if (lookahead == '>') ADVANCE(478);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(898);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_24);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_25);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_26);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(472);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(anon_sym_27);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_28);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_29);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_30);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_31);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_32);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_33);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_34);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_35);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_36);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(335);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_37);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_38);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_39);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_40);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_41);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_42);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_43);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(339);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_44);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_45);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_46);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_47);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_48);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(anon_sym_49);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(anon_sym_50);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(anon_sym_51);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'A') ADVANCE(464);
      if (lookahead == 'B') ADVANCE(389);
      if (lookahead == 'E') ADVANCE(467);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(447);
      if (lookahead == 'O') ADVANCE(444);
      if (lookahead == 'X') ADVANCE(1057);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(280);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'f') ADVANCE(316);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(262);
      if (lookahead == 'o') ADVANCE(1039);
      if (lookahead == 'p') ADVANCE(344);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'A') ADVANCE(464);
      if (lookahead == 'B') ADVANCE(389);
      if (lookahead == 'E') ADVANCE(467);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(447);
      if (lookahead == 'O') ADVANCE(444);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(280);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(330);
      if (lookahead == 'f') ADVANCE(316);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(262);
      if (lookahead == 'o') ADVANCE(1039);
      if (lookahead == 'p') ADVANCE(348);
      if (lookahead == 's') ADVANCE(283);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'X') ADVANCE(1057);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(262);
      if (lookahead == 'o') ADVANCE(1038);
      if (lookahead == 'p') ADVANCE(344);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'X') ADVANCE(1057);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(244);
      if (lookahead == 'n') ADVANCE(315);
      if (lookahead == 'o') ADVANCE(1038);
      if (lookahead == 'p') ADVANCE(344);
      if (lookahead == 's') ADVANCE(282);
      if (lookahead == 't') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(262);
      if (lookahead == 'o') ADVANCE(1038);
      if (lookahead == 'p') ADVANCE(348);
      if (lookahead == 's') ADVANCE(283);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_setminus);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(905);
      if (lookahead == 'a') ADVANCE(321);
      if (lookahead == 'b') ADVANCE(279);
      if (lookahead == 'c') ADVANCE(242);
      if (lookahead == 'd') ADVANCE(281);
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'g') ADVANCE(260);
      if (lookahead == 'i') ADVANCE(304);
      if (lookahead == 'l') ADVANCE(244);
      if (lookahead == 'n') ADVANCE(315);
      if (lookahead == 'o') ADVANCE(1038);
      if (lookahead == 'p') ADVANCE(348);
      if (lookahead == 's') ADVANCE(283);
      if (lookahead == 'u') ADVANCE(310);
      if (lookahead == 'w') ADVANCE(341);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_52);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(anon_sym_53);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(999);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(anon_sym_54);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(anon_sym_55);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_plus);
      if (lookahead == '+') ADVANCE(1002);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(anon_sym_56);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(anon_sym_57);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(1010);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(932);
      if (lookahead == '=') ADVANCE(934);
      if (lookahead == '|') ADVANCE(1013);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(931);
      if (lookahead == '=') ADVANCE(934);
      if (lookahead == '|') ADVANCE(1013);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(anon_sym_58);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(16);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(1018);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(anon_sym_59);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(anon_sym_60);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(anon_sym_61);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(1029);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(1031);
      if (lookahead == '=') ADVANCE(912);
      if (lookahead == '\\') ADVANCE(902);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(anon_sym_62);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(anon_sym_63);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(anon_sym_64);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(320);
      if (lookahead == 'm') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(294);
      if (lookahead == 's') ADVANCE(295);
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(320);
      if (lookahead == 'm') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(294);
      if (lookahead == 's') ADVANCE(295);
      if (lookahead == 't') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(852);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(anon_sym_65);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(anon_sym_66);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_BANG_BANG);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(anon_sym_67);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(anon_sym_68);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(1050);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(anon_sym_69);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(anon_sym_70);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(anon_sym_71);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(anon_sym_72);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(anon_sym_73);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(anon_sym_74);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(1069);
      if (lookahead == '*') ADVANCE(1068);
      if (lookahead == '+') ADVANCE(1066);
      if (lookahead == '^') ADVANCE(1065);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(anon_sym_75);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1072);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1074);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(1075);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1077);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(837);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(1078);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 390, .external_lex_state = 3},
  [3] = {.lex_state = 390, .external_lex_state = 3},
  [4] = {.lex_state = 390, .external_lex_state = 4},
  [5] = {.lex_state = 391, .external_lex_state = 4},
  [6] = {.lex_state = 391, .external_lex_state = 4},
  [7] = {.lex_state = 391, .external_lex_state = 4},
  [8] = {.lex_state = 391, .external_lex_state = 4},
  [9] = {.lex_state = 392, .external_lex_state = 4},
  [10] = {.lex_state = 392, .external_lex_state = 4},
  [11] = {.lex_state = 392, .external_lex_state = 4},
  [12] = {.lex_state = 392, .external_lex_state = 4},
  [13] = {.lex_state = 393, .external_lex_state = 4},
  [14] = {.lex_state = 393, .external_lex_state = 4},
  [15] = {.lex_state = 393, .external_lex_state = 4},
  [16] = {.lex_state = 393, .external_lex_state = 4},
  [17] = {.lex_state = 393, .external_lex_state = 4},
  [18] = {.lex_state = 393, .external_lex_state = 4},
  [19] = {.lex_state = 394, .external_lex_state = 4},
  [20] = {.lex_state = 394, .external_lex_state = 4},
  [21] = {.lex_state = 394, .external_lex_state = 4},
  [22] = {.lex_state = 394, .external_lex_state = 4},
  [23] = {.lex_state = 394, .external_lex_state = 4},
  [24] = {.lex_state = 394, .external_lex_state = 4},
  [25] = {.lex_state = 394, .external_lex_state = 4},
  [26] = {.lex_state = 394, .external_lex_state = 4},
  [27] = {.lex_state = 395, .external_lex_state = 4},
  [28] = {.lex_state = 439, .external_lex_state = 4},
  [29] = {.lex_state = 439, .external_lex_state = 4},
  [30] = {.lex_state = 439, .external_lex_state = 4},
  [31] = {.lex_state = 439, .external_lex_state = 4},
  [32] = {.lex_state = 396, .external_lex_state = 4},
  [33] = {.lex_state = 397, .external_lex_state = 4},
  [34] = {.lex_state = 397, .external_lex_state = 4},
  [35] = {.lex_state = 397, .external_lex_state = 4},
  [36] = {.lex_state = 396, .external_lex_state = 4},
  [37] = {.lex_state = 395, .external_lex_state = 4},
  [38] = {.lex_state = 397, .external_lex_state = 4},
  [39] = {.lex_state = 396, .external_lex_state = 4},
  [40] = {.lex_state = 396, .external_lex_state = 4},
  [41] = {.lex_state = 398, .external_lex_state = 4},
  [42] = {.lex_state = 398, .external_lex_state = 4},
  [43] = {.lex_state = 398, .external_lex_state = 4},
  [44] = {.lex_state = 398, .external_lex_state = 4},
  [45] = {.lex_state = 399, .external_lex_state = 4},
  [46] = {.lex_state = 395, .external_lex_state = 4},
  [47] = {.lex_state = 395, .external_lex_state = 4},
  [48] = {.lex_state = 399, .external_lex_state = 4},
  [49] = {.lex_state = 396, .external_lex_state = 4},
  [50] = {.lex_state = 395, .external_lex_state = 4},
  [51] = {.lex_state = 395, .external_lex_state = 4},
  [52] = {.lex_state = 395, .external_lex_state = 4},
  [53] = {.lex_state = 395, .external_lex_state = 4},
  [54] = {.lex_state = 395, .external_lex_state = 4},
  [55] = {.lex_state = 395, .external_lex_state = 4},
  [56] = {.lex_state = 399, .external_lex_state = 4},
  [57] = {.lex_state = 396, .external_lex_state = 4},
  [58] = {.lex_state = 395, .external_lex_state = 4},
  [59] = {.lex_state = 395, .external_lex_state = 4},
  [60] = {.lex_state = 395, .external_lex_state = 4},
  [61] = {.lex_state = 395, .external_lex_state = 4},
  [62] = {.lex_state = 395, .external_lex_state = 4},
  [63] = {.lex_state = 398, .external_lex_state = 4},
  [64] = {.lex_state = 398, .external_lex_state = 4},
  [65] = {.lex_state = 396, .external_lex_state = 4},
  [66] = {.lex_state = 398, .external_lex_state = 4},
  [67] = {.lex_state = 395, .external_lex_state = 4},
  [68] = {.lex_state = 395, .external_lex_state = 4},
  [69] = {.lex_state = 395, .external_lex_state = 4},
  [70] = {.lex_state = 396, .external_lex_state = 4},
  [71] = {.lex_state = 395, .external_lex_state = 4},
  [72] = {.lex_state = 398, .external_lex_state = 4},
  [73] = {.lex_state = 395, .external_lex_state = 4},
  [74] = {.lex_state = 395, .external_lex_state = 4},
  [75] = {.lex_state = 395, .external_lex_state = 4},
  [76] = {.lex_state = 395, .external_lex_state = 4},
  [77] = {.lex_state = 395, .external_lex_state = 4},
  [78] = {.lex_state = 398, .external_lex_state = 4},
  [79] = {.lex_state = 395, .external_lex_state = 4},
  [80] = {.lex_state = 398, .external_lex_state = 4},
  [81] = {.lex_state = 398, .external_lex_state = 4},
  [82] = {.lex_state = 398, .external_lex_state = 4},
  [83] = {.lex_state = 398, .external_lex_state = 4},
  [84] = {.lex_state = 398, .external_lex_state = 4},
  [85] = {.lex_state = 398, .external_lex_state = 4},
  [86] = {.lex_state = 399, .external_lex_state = 4},
  [87] = {.lex_state = 395, .external_lex_state = 4},
  [88] = {.lex_state = 395, .external_lex_state = 4},
  [89] = {.lex_state = 396, .external_lex_state = 4},
  [90] = {.lex_state = 399, .external_lex_state = 4},
  [91] = {.lex_state = 395, .external_lex_state = 4},
  [92] = {.lex_state = 395, .external_lex_state = 4},
  [93] = {.lex_state = 399, .external_lex_state = 4},
  [94] = {.lex_state = 396, .external_lex_state = 4},
  [95] = {.lex_state = 395, .external_lex_state = 4},
  [96] = {.lex_state = 398, .external_lex_state = 4},
  [97] = {.lex_state = 395, .external_lex_state = 4},
  [98] = {.lex_state = 396, .external_lex_state = 4},
  [99] = {.lex_state = 395, .external_lex_state = 4},
  [100] = {.lex_state = 395, .external_lex_state = 4},
  [101] = {.lex_state = 399, .external_lex_state = 4},
  [102] = {.lex_state = 398, .external_lex_state = 4},
  [103] = {.lex_state = 395, .external_lex_state = 4},
  [104] = {.lex_state = 395, .external_lex_state = 4},
  [105] = {.lex_state = 395, .external_lex_state = 4},
  [106] = {.lex_state = 398, .external_lex_state = 4},
  [107] = {.lex_state = 399, .external_lex_state = 4},
  [108] = {.lex_state = 398, .external_lex_state = 4},
  [109] = {.lex_state = 395, .external_lex_state = 4},
  [110] = {.lex_state = 395, .external_lex_state = 4},
  [111] = {.lex_state = 396, .external_lex_state = 4},
  [112] = {.lex_state = 398, .external_lex_state = 4},
  [113] = {.lex_state = 396, .external_lex_state = 4},
  [114] = {.lex_state = 399, .external_lex_state = 4},
  [115] = {.lex_state = 395, .external_lex_state = 4},
  [116] = {.lex_state = 395, .external_lex_state = 4},
  [117] = {.lex_state = 396, .external_lex_state = 5},
  [118] = {.lex_state = 396, .external_lex_state = 5},
  [119] = {.lex_state = 399, .external_lex_state = 4},
  [120] = {.lex_state = 396, .external_lex_state = 4},
  [121] = {.lex_state = 396, .external_lex_state = 5},
  [122] = {.lex_state = 395, .external_lex_state = 4},
  [123] = {.lex_state = 396, .external_lex_state = 4},
  [124] = {.lex_state = 399, .external_lex_state = 4},
  [125] = {.lex_state = 395, .external_lex_state = 4},
  [126] = {.lex_state = 396, .external_lex_state = 5},
  [127] = {.lex_state = 395, .external_lex_state = 4},
  [128] = {.lex_state = 399, .external_lex_state = 4},
  [129] = {.lex_state = 398, .external_lex_state = 4},
  [130] = {.lex_state = 395, .external_lex_state = 4},
  [131] = {.lex_state = 395, .external_lex_state = 4},
  [132] = {.lex_state = 399, .external_lex_state = 4},
  [133] = {.lex_state = 398, .external_lex_state = 4},
  [134] = {.lex_state = 398, .external_lex_state = 4},
  [135] = {.lex_state = 395, .external_lex_state = 4},
  [136] = {.lex_state = 395, .external_lex_state = 4},
  [137] = {.lex_state = 398, .external_lex_state = 4},
  [138] = {.lex_state = 398, .external_lex_state = 4},
  [139] = {.lex_state = 395, .external_lex_state = 4},
  [140] = {.lex_state = 396, .external_lex_state = 5},
  [141] = {.lex_state = 396, .external_lex_state = 5},
  [142] = {.lex_state = 395, .external_lex_state = 4},
  [143] = {.lex_state = 398, .external_lex_state = 4},
  [144] = {.lex_state = 395, .external_lex_state = 4},
  [145] = {.lex_state = 398, .external_lex_state = 4},
  [146] = {.lex_state = 396, .external_lex_state = 4},
  [147] = {.lex_state = 396, .external_lex_state = 5},
  [148] = {.lex_state = 399, .external_lex_state = 4},
  [149] = {.lex_state = 395, .external_lex_state = 4},
  [150] = {.lex_state = 399, .external_lex_state = 4},
  [151] = {.lex_state = 396, .external_lex_state = 4},
  [152] = {.lex_state = 396, .external_lex_state = 5},
  [153] = {.lex_state = 395, .external_lex_state = 4},
  [154] = {.lex_state = 398, .external_lex_state = 4},
  [155] = {.lex_state = 396, .external_lex_state = 4},
  [156] = {.lex_state = 399, .external_lex_state = 4},
  [157] = {.lex_state = 399, .external_lex_state = 4},
  [158] = {.lex_state = 395, .external_lex_state = 4},
  [159] = {.lex_state = 395, .external_lex_state = 4},
  [160] = {.lex_state = 396, .external_lex_state = 4},
  [161] = {.lex_state = 395, .external_lex_state = 4},
  [162] = {.lex_state = 395, .external_lex_state = 4},
  [163] = {.lex_state = 395, .external_lex_state = 4},
  [164] = {.lex_state = 396, .external_lex_state = 4},
  [165] = {.lex_state = 398, .external_lex_state = 4},
  [166] = {.lex_state = 398, .external_lex_state = 4},
  [167] = {.lex_state = 398, .external_lex_state = 4},
  [168] = {.lex_state = 399, .external_lex_state = 4},
  [169] = {.lex_state = 395, .external_lex_state = 4},
  [170] = {.lex_state = 398, .external_lex_state = 4},
  [171] = {.lex_state = 395, .external_lex_state = 4},
  [172] = {.lex_state = 396, .external_lex_state = 4},
  [173] = {.lex_state = 400, .external_lex_state = 4},
  [174] = {.lex_state = 396, .external_lex_state = 4},
  [175] = {.lex_state = 400, .external_lex_state = 4},
  [176] = {.lex_state = 440, .external_lex_state = 4},
  [177] = {.lex_state = 440, .external_lex_state = 4},
  [178] = {.lex_state = 443, .external_lex_state = 4},
  [179] = {.lex_state = 396, .external_lex_state = 4},
  [180] = {.lex_state = 440, .external_lex_state = 4},
  [181] = {.lex_state = 443, .external_lex_state = 4},
  [182] = {.lex_state = 440, .external_lex_state = 4},
  [183] = {.lex_state = 440, .external_lex_state = 4},
  [184] = {.lex_state = 396, .external_lex_state = 4},
  [185] = {.lex_state = 400, .external_lex_state = 4},
  [186] = {.lex_state = 400, .external_lex_state = 4},
  [187] = {.lex_state = 396, .external_lex_state = 4},
  [188] = {.lex_state = 396, .external_lex_state = 4},
  [189] = {.lex_state = 396, .external_lex_state = 4},
  [190] = {.lex_state = 396, .external_lex_state = 4},
  [191] = {.lex_state = 396, .external_lex_state = 4},
  [192] = {.lex_state = 440, .external_lex_state = 4},
  [193] = {.lex_state = 440, .external_lex_state = 4},
  [194] = {.lex_state = 396, .external_lex_state = 4},
  [195] = {.lex_state = 396, .external_lex_state = 4},
  [196] = {.lex_state = 440, .external_lex_state = 4},
  [197] = {.lex_state = 396, .external_lex_state = 4},
  [198] = {.lex_state = 440, .external_lex_state = 4},
  [199] = {.lex_state = 396, .external_lex_state = 4},
  [200] = {.lex_state = 396, .external_lex_state = 4},
  [201] = {.lex_state = 396, .external_lex_state = 4},
  [202] = {.lex_state = 396, .external_lex_state = 4},
  [203] = {.lex_state = 396, .external_lex_state = 4},
  [204] = {.lex_state = 396, .external_lex_state = 4},
  [205] = {.lex_state = 396, .external_lex_state = 4},
  [206] = {.lex_state = 396, .external_lex_state = 4},
  [207] = {.lex_state = 396, .external_lex_state = 4},
  [208] = {.lex_state = 396, .external_lex_state = 4},
  [209] = {.lex_state = 396, .external_lex_state = 4},
  [210] = {.lex_state = 396, .external_lex_state = 4},
  [211] = {.lex_state = 396, .external_lex_state = 4},
  [212] = {.lex_state = 396, .external_lex_state = 4},
  [213] = {.lex_state = 396, .external_lex_state = 4},
  [214] = {.lex_state = 396, .external_lex_state = 4},
  [215] = {.lex_state = 396, .external_lex_state = 4},
  [216] = {.lex_state = 396, .external_lex_state = 4},
  [217] = {.lex_state = 396, .external_lex_state = 4},
  [218] = {.lex_state = 396, .external_lex_state = 4},
  [219] = {.lex_state = 396, .external_lex_state = 4},
  [220] = {.lex_state = 396, .external_lex_state = 4},
  [221] = {.lex_state = 396, .external_lex_state = 4},
  [222] = {.lex_state = 396, .external_lex_state = 4},
  [223] = {.lex_state = 396, .external_lex_state = 4},
  [224] = {.lex_state = 396, .external_lex_state = 4},
  [225] = {.lex_state = 396, .external_lex_state = 4},
  [226] = {.lex_state = 396, .external_lex_state = 4},
  [227] = {.lex_state = 396, .external_lex_state = 4},
  [228] = {.lex_state = 396, .external_lex_state = 4},
  [229] = {.lex_state = 396, .external_lex_state = 4},
  [230] = {.lex_state = 396, .external_lex_state = 4},
  [231] = {.lex_state = 396, .external_lex_state = 4},
  [232] = {.lex_state = 396, .external_lex_state = 4},
  [233] = {.lex_state = 396, .external_lex_state = 4},
  [234] = {.lex_state = 396, .external_lex_state = 4},
  [235] = {.lex_state = 396, .external_lex_state = 4},
  [236] = {.lex_state = 396, .external_lex_state = 4},
  [237] = {.lex_state = 396, .external_lex_state = 4},
  [238] = {.lex_state = 396, .external_lex_state = 4},
  [239] = {.lex_state = 396, .external_lex_state = 4},
  [240] = {.lex_state = 396, .external_lex_state = 4},
  [241] = {.lex_state = 396, .external_lex_state = 4},
  [242] = {.lex_state = 396, .external_lex_state = 4},
  [243] = {.lex_state = 396, .external_lex_state = 4},
  [244] = {.lex_state = 396, .external_lex_state = 4},
  [245] = {.lex_state = 396, .external_lex_state = 4},
  [246] = {.lex_state = 396, .external_lex_state = 4},
  [247] = {.lex_state = 396, .external_lex_state = 4},
  [248] = {.lex_state = 396, .external_lex_state = 4},
  [249] = {.lex_state = 396, .external_lex_state = 4},
  [250] = {.lex_state = 396, .external_lex_state = 4},
  [251] = {.lex_state = 396, .external_lex_state = 4},
  [252] = {.lex_state = 396, .external_lex_state = 4},
  [253] = {.lex_state = 396, .external_lex_state = 4},
  [254] = {.lex_state = 396, .external_lex_state = 4},
  [255] = {.lex_state = 396, .external_lex_state = 4},
  [256] = {.lex_state = 396, .external_lex_state = 4},
  [257] = {.lex_state = 396, .external_lex_state = 4},
  [258] = {.lex_state = 396, .external_lex_state = 4},
  [259] = {.lex_state = 396, .external_lex_state = 4},
  [260] = {.lex_state = 396, .external_lex_state = 4},
  [261] = {.lex_state = 396, .external_lex_state = 4},
  [262] = {.lex_state = 396, .external_lex_state = 4},
  [263] = {.lex_state = 396, .external_lex_state = 4},
  [264] = {.lex_state = 396, .external_lex_state = 4},
  [265] = {.lex_state = 396, .external_lex_state = 4},
  [266] = {.lex_state = 396, .external_lex_state = 4},
  [267] = {.lex_state = 396, .external_lex_state = 4},
  [268] = {.lex_state = 396, .external_lex_state = 4},
  [269] = {.lex_state = 396, .external_lex_state = 4},
  [270] = {.lex_state = 396, .external_lex_state = 4},
  [271] = {.lex_state = 396, .external_lex_state = 4},
  [272] = {.lex_state = 396, .external_lex_state = 4},
  [273] = {.lex_state = 396, .external_lex_state = 4},
  [274] = {.lex_state = 396, .external_lex_state = 4},
  [275] = {.lex_state = 396, .external_lex_state = 4},
  [276] = {.lex_state = 396, .external_lex_state = 4},
  [277] = {.lex_state = 396, .external_lex_state = 4},
  [278] = {.lex_state = 396, .external_lex_state = 4},
  [279] = {.lex_state = 396, .external_lex_state = 4},
  [280] = {.lex_state = 396, .external_lex_state = 4},
  [281] = {.lex_state = 396, .external_lex_state = 4},
  [282] = {.lex_state = 396, .external_lex_state = 4},
  [283] = {.lex_state = 396, .external_lex_state = 4},
  [284] = {.lex_state = 396, .external_lex_state = 4},
  [285] = {.lex_state = 396, .external_lex_state = 4},
  [286] = {.lex_state = 396, .external_lex_state = 4},
  [287] = {.lex_state = 396, .external_lex_state = 4},
  [288] = {.lex_state = 396, .external_lex_state = 4},
  [289] = {.lex_state = 396, .external_lex_state = 4},
  [290] = {.lex_state = 396, .external_lex_state = 4},
  [291] = {.lex_state = 396, .external_lex_state = 4},
  [292] = {.lex_state = 396, .external_lex_state = 4},
  [293] = {.lex_state = 396, .external_lex_state = 4},
  [294] = {.lex_state = 396, .external_lex_state = 4},
  [295] = {.lex_state = 396, .external_lex_state = 4},
  [296] = {.lex_state = 396, .external_lex_state = 4},
  [297] = {.lex_state = 396, .external_lex_state = 4},
  [298] = {.lex_state = 396, .external_lex_state = 4},
  [299] = {.lex_state = 396, .external_lex_state = 4},
  [300] = {.lex_state = 396, .external_lex_state = 4},
  [301] = {.lex_state = 396, .external_lex_state = 4},
  [302] = {.lex_state = 396, .external_lex_state = 4},
  [303] = {.lex_state = 396, .external_lex_state = 4},
  [304] = {.lex_state = 396, .external_lex_state = 4},
  [305] = {.lex_state = 396, .external_lex_state = 4},
  [306] = {.lex_state = 396, .external_lex_state = 4},
  [307] = {.lex_state = 396, .external_lex_state = 4},
  [308] = {.lex_state = 396, .external_lex_state = 4},
  [309] = {.lex_state = 396, .external_lex_state = 4},
  [310] = {.lex_state = 396, .external_lex_state = 4},
  [311] = {.lex_state = 396, .external_lex_state = 4},
  [312] = {.lex_state = 396, .external_lex_state = 4},
  [313] = {.lex_state = 396, .external_lex_state = 4},
  [314] = {.lex_state = 396, .external_lex_state = 4},
  [315] = {.lex_state = 396, .external_lex_state = 4},
  [316] = {.lex_state = 396, .external_lex_state = 4},
  [317] = {.lex_state = 396, .external_lex_state = 4},
  [318] = {.lex_state = 396, .external_lex_state = 4},
  [319] = {.lex_state = 396, .external_lex_state = 4},
  [320] = {.lex_state = 396, .external_lex_state = 4},
  [321] = {.lex_state = 396, .external_lex_state = 4},
  [322] = {.lex_state = 396, .external_lex_state = 4},
  [323] = {.lex_state = 396, .external_lex_state = 4},
  [324] = {.lex_state = 396, .external_lex_state = 4},
  [325] = {.lex_state = 396, .external_lex_state = 4},
  [326] = {.lex_state = 396, .external_lex_state = 4},
  [327] = {.lex_state = 396, .external_lex_state = 4},
  [328] = {.lex_state = 396, .external_lex_state = 4},
  [329] = {.lex_state = 396, .external_lex_state = 4},
  [330] = {.lex_state = 396, .external_lex_state = 4},
  [331] = {.lex_state = 396, .external_lex_state = 4},
  [332] = {.lex_state = 396, .external_lex_state = 4},
  [333] = {.lex_state = 396, .external_lex_state = 4},
  [334] = {.lex_state = 396, .external_lex_state = 4},
  [335] = {.lex_state = 396, .external_lex_state = 4},
  [336] = {.lex_state = 396, .external_lex_state = 4},
  [337] = {.lex_state = 396, .external_lex_state = 4},
  [338] = {.lex_state = 396, .external_lex_state = 4},
  [339] = {.lex_state = 396, .external_lex_state = 4},
  [340] = {.lex_state = 396, .external_lex_state = 4},
  [341] = {.lex_state = 396, .external_lex_state = 4},
  [342] = {.lex_state = 396, .external_lex_state = 4},
  [343] = {.lex_state = 396, .external_lex_state = 4},
  [344] = {.lex_state = 396, .external_lex_state = 4},
  [345] = {.lex_state = 396, .external_lex_state = 4},
  [346] = {.lex_state = 396, .external_lex_state = 4},
  [347] = {.lex_state = 396, .external_lex_state = 4},
  [348] = {.lex_state = 396, .external_lex_state = 4},
  [349] = {.lex_state = 396, .external_lex_state = 4},
  [350] = {.lex_state = 396, .external_lex_state = 4},
  [351] = {.lex_state = 396, .external_lex_state = 4},
  [352] = {.lex_state = 396, .external_lex_state = 4},
  [353] = {.lex_state = 396, .external_lex_state = 4},
  [354] = {.lex_state = 396, .external_lex_state = 4},
  [355] = {.lex_state = 396, .external_lex_state = 4},
  [356] = {.lex_state = 396, .external_lex_state = 4},
  [357] = {.lex_state = 396, .external_lex_state = 4},
  [358] = {.lex_state = 396, .external_lex_state = 4},
  [359] = {.lex_state = 396, .external_lex_state = 4},
  [360] = {.lex_state = 396, .external_lex_state = 4},
  [361] = {.lex_state = 396, .external_lex_state = 4},
  [362] = {.lex_state = 396, .external_lex_state = 4},
  [363] = {.lex_state = 396, .external_lex_state = 4},
  [364] = {.lex_state = 396, .external_lex_state = 4},
  [365] = {.lex_state = 396, .external_lex_state = 4},
  [366] = {.lex_state = 396, .external_lex_state = 4},
  [367] = {.lex_state = 396, .external_lex_state = 4},
  [368] = {.lex_state = 396, .external_lex_state = 4},
  [369] = {.lex_state = 396, .external_lex_state = 4},
  [370] = {.lex_state = 396, .external_lex_state = 4},
  [371] = {.lex_state = 396, .external_lex_state = 4},
  [372] = {.lex_state = 396, .external_lex_state = 4},
  [373] = {.lex_state = 396, .external_lex_state = 4},
  [374] = {.lex_state = 396, .external_lex_state = 4},
  [375] = {.lex_state = 396, .external_lex_state = 4},
  [376] = {.lex_state = 396, .external_lex_state = 4},
  [377] = {.lex_state = 396, .external_lex_state = 4},
  [378] = {.lex_state = 396, .external_lex_state = 4},
  [379] = {.lex_state = 396, .external_lex_state = 4},
  [380] = {.lex_state = 396, .external_lex_state = 4},
  [381] = {.lex_state = 396, .external_lex_state = 4},
  [382] = {.lex_state = 396, .external_lex_state = 4},
  [383] = {.lex_state = 396, .external_lex_state = 4},
  [384] = {.lex_state = 396, .external_lex_state = 4},
  [385] = {.lex_state = 396, .external_lex_state = 4},
  [386] = {.lex_state = 396, .external_lex_state = 4},
  [387] = {.lex_state = 396, .external_lex_state = 4},
  [388] = {.lex_state = 396, .external_lex_state = 4},
  [389] = {.lex_state = 396, .external_lex_state = 4},
  [390] = {.lex_state = 396, .external_lex_state = 4},
  [391] = {.lex_state = 396, .external_lex_state = 4},
  [392] = {.lex_state = 396, .external_lex_state = 4},
  [393] = {.lex_state = 396, .external_lex_state = 4},
  [394] = {.lex_state = 396, .external_lex_state = 4},
  [395] = {.lex_state = 396, .external_lex_state = 4},
  [396] = {.lex_state = 396, .external_lex_state = 4},
  [397] = {.lex_state = 396, .external_lex_state = 4},
  [398] = {.lex_state = 396, .external_lex_state = 4},
  [399] = {.lex_state = 396, .external_lex_state = 4},
  [400] = {.lex_state = 396, .external_lex_state = 4},
  [401] = {.lex_state = 396, .external_lex_state = 4},
  [402] = {.lex_state = 396, .external_lex_state = 4},
  [403] = {.lex_state = 396, .external_lex_state = 4},
  [404] = {.lex_state = 396, .external_lex_state = 4},
  [405] = {.lex_state = 396, .external_lex_state = 4},
  [406] = {.lex_state = 396, .external_lex_state = 4},
  [407] = {.lex_state = 396, .external_lex_state = 4},
  [408] = {.lex_state = 396, .external_lex_state = 4},
  [409] = {.lex_state = 396, .external_lex_state = 4},
  [410] = {.lex_state = 396, .external_lex_state = 4},
  [411] = {.lex_state = 396, .external_lex_state = 4},
  [412] = {.lex_state = 396, .external_lex_state = 4},
  [413] = {.lex_state = 396, .external_lex_state = 4},
  [414] = {.lex_state = 396, .external_lex_state = 4},
  [415] = {.lex_state = 396, .external_lex_state = 4},
  [416] = {.lex_state = 396, .external_lex_state = 4},
  [417] = {.lex_state = 396, .external_lex_state = 4},
  [418] = {.lex_state = 396, .external_lex_state = 4},
  [419] = {.lex_state = 396, .external_lex_state = 4},
  [420] = {.lex_state = 396, .external_lex_state = 4},
  [421] = {.lex_state = 396, .external_lex_state = 4},
  [422] = {.lex_state = 396, .external_lex_state = 4},
  [423] = {.lex_state = 396, .external_lex_state = 4},
  [424] = {.lex_state = 396, .external_lex_state = 4},
  [425] = {.lex_state = 396, .external_lex_state = 4},
  [426] = {.lex_state = 396, .external_lex_state = 4},
  [427] = {.lex_state = 396, .external_lex_state = 4},
  [428] = {.lex_state = 396, .external_lex_state = 4},
  [429] = {.lex_state = 396, .external_lex_state = 4},
  [430] = {.lex_state = 396, .external_lex_state = 4},
  [431] = {.lex_state = 396, .external_lex_state = 4},
  [432] = {.lex_state = 396, .external_lex_state = 4},
  [433] = {.lex_state = 396, .external_lex_state = 4},
  [434] = {.lex_state = 396, .external_lex_state = 4},
  [435] = {.lex_state = 396, .external_lex_state = 4},
  [436] = {.lex_state = 396, .external_lex_state = 4},
  [437] = {.lex_state = 396, .external_lex_state = 4},
  [438] = {.lex_state = 396, .external_lex_state = 4},
  [439] = {.lex_state = 396, .external_lex_state = 4},
  [440] = {.lex_state = 396, .external_lex_state = 4},
  [441] = {.lex_state = 396, .external_lex_state = 4},
  [442] = {.lex_state = 396, .external_lex_state = 4},
  [443] = {.lex_state = 396, .external_lex_state = 4},
  [444] = {.lex_state = 396, .external_lex_state = 4},
  [445] = {.lex_state = 396, .external_lex_state = 4},
  [446] = {.lex_state = 396, .external_lex_state = 4},
  [447] = {.lex_state = 396, .external_lex_state = 4},
  [448] = {.lex_state = 396, .external_lex_state = 4},
  [449] = {.lex_state = 396, .external_lex_state = 4},
  [450] = {.lex_state = 396, .external_lex_state = 4},
  [451] = {.lex_state = 396, .external_lex_state = 4},
  [452] = {.lex_state = 396, .external_lex_state = 4},
  [453] = {.lex_state = 396, .external_lex_state = 4},
  [454] = {.lex_state = 396, .external_lex_state = 4},
  [455] = {.lex_state = 396, .external_lex_state = 4},
  [456] = {.lex_state = 396, .external_lex_state = 4},
  [457] = {.lex_state = 396, .external_lex_state = 4},
  [458] = {.lex_state = 396, .external_lex_state = 4},
  [459] = {.lex_state = 396, .external_lex_state = 4},
  [460] = {.lex_state = 396, .external_lex_state = 4},
  [461] = {.lex_state = 396, .external_lex_state = 4},
  [462] = {.lex_state = 396, .external_lex_state = 4},
  [463] = {.lex_state = 396, .external_lex_state = 4},
  [464] = {.lex_state = 396, .external_lex_state = 4},
  [465] = {.lex_state = 396, .external_lex_state = 4},
  [466] = {.lex_state = 396, .external_lex_state = 4},
  [467] = {.lex_state = 396, .external_lex_state = 4},
  [468] = {.lex_state = 396, .external_lex_state = 4},
  [469] = {.lex_state = 396, .external_lex_state = 4},
  [470] = {.lex_state = 396, .external_lex_state = 4},
  [471] = {.lex_state = 396, .external_lex_state = 4},
  [472] = {.lex_state = 396, .external_lex_state = 4},
  [473] = {.lex_state = 396, .external_lex_state = 4},
  [474] = {.lex_state = 396, .external_lex_state = 4},
  [475] = {.lex_state = 396, .external_lex_state = 4},
  [476] = {.lex_state = 396, .external_lex_state = 4},
  [477] = {.lex_state = 396, .external_lex_state = 4},
  [478] = {.lex_state = 396, .external_lex_state = 4},
  [479] = {.lex_state = 396, .external_lex_state = 4},
  [480] = {.lex_state = 396, .external_lex_state = 4},
  [481] = {.lex_state = 396, .external_lex_state = 4},
  [482] = {.lex_state = 396, .external_lex_state = 4},
  [483] = {.lex_state = 396, .external_lex_state = 4},
  [484] = {.lex_state = 396, .external_lex_state = 4},
  [485] = {.lex_state = 396, .external_lex_state = 4},
  [486] = {.lex_state = 396, .external_lex_state = 4},
  [487] = {.lex_state = 396, .external_lex_state = 4},
  [488] = {.lex_state = 396, .external_lex_state = 4},
  [489] = {.lex_state = 396, .external_lex_state = 4},
  [490] = {.lex_state = 396, .external_lex_state = 4},
  [491] = {.lex_state = 396, .external_lex_state = 4},
  [492] = {.lex_state = 396, .external_lex_state = 4},
  [493] = {.lex_state = 396, .external_lex_state = 4},
  [494] = {.lex_state = 396, .external_lex_state = 4},
  [495] = {.lex_state = 396, .external_lex_state = 4},
  [496] = {.lex_state = 396, .external_lex_state = 4},
  [497] = {.lex_state = 396, .external_lex_state = 4},
  [498] = {.lex_state = 396, .external_lex_state = 4},
  [499] = {.lex_state = 396, .external_lex_state = 4},
  [500] = {.lex_state = 396, .external_lex_state = 4},
  [501] = {.lex_state = 396, .external_lex_state = 4},
  [502] = {.lex_state = 396, .external_lex_state = 4},
  [503] = {.lex_state = 396, .external_lex_state = 4},
  [504] = {.lex_state = 396, .external_lex_state = 4},
  [505] = {.lex_state = 396, .external_lex_state = 4},
  [506] = {.lex_state = 396, .external_lex_state = 4},
  [507] = {.lex_state = 396, .external_lex_state = 4},
  [508] = {.lex_state = 396, .external_lex_state = 4},
  [509] = {.lex_state = 396, .external_lex_state = 4},
  [510] = {.lex_state = 396, .external_lex_state = 4},
  [511] = {.lex_state = 396, .external_lex_state = 4},
  [512] = {.lex_state = 396, .external_lex_state = 4},
  [513] = {.lex_state = 396, .external_lex_state = 4},
  [514] = {.lex_state = 396, .external_lex_state = 4},
  [515] = {.lex_state = 396, .external_lex_state = 4},
  [516] = {.lex_state = 396, .external_lex_state = 4},
  [517] = {.lex_state = 396, .external_lex_state = 4},
  [518] = {.lex_state = 396, .external_lex_state = 4},
  [519] = {.lex_state = 396, .external_lex_state = 4},
  [520] = {.lex_state = 396, .external_lex_state = 4},
  [521] = {.lex_state = 396, .external_lex_state = 4},
  [522] = {.lex_state = 396, .external_lex_state = 4},
  [523] = {.lex_state = 396, .external_lex_state = 4},
  [524] = {.lex_state = 396, .external_lex_state = 4},
  [525] = {.lex_state = 396, .external_lex_state = 4},
  [526] = {.lex_state = 396, .external_lex_state = 4},
  [527] = {.lex_state = 396, .external_lex_state = 4},
  [528] = {.lex_state = 396, .external_lex_state = 4},
  [529] = {.lex_state = 396, .external_lex_state = 4},
  [530] = {.lex_state = 396, .external_lex_state = 4},
  [531] = {.lex_state = 396, .external_lex_state = 4},
  [532] = {.lex_state = 396, .external_lex_state = 4},
  [533] = {.lex_state = 396, .external_lex_state = 4},
  [534] = {.lex_state = 396, .external_lex_state = 4},
  [535] = {.lex_state = 396, .external_lex_state = 4},
  [536] = {.lex_state = 396, .external_lex_state = 4},
  [537] = {.lex_state = 396, .external_lex_state = 4},
  [538] = {.lex_state = 396, .external_lex_state = 4},
  [539] = {.lex_state = 396, .external_lex_state = 4},
  [540] = {.lex_state = 396, .external_lex_state = 4},
  [541] = {.lex_state = 396, .external_lex_state = 4},
  [542] = {.lex_state = 396, .external_lex_state = 4},
  [543] = {.lex_state = 396, .external_lex_state = 4},
  [544] = {.lex_state = 396, .external_lex_state = 4},
  [545] = {.lex_state = 396, .external_lex_state = 4},
  [546] = {.lex_state = 396, .external_lex_state = 4},
  [547] = {.lex_state = 396, .external_lex_state = 4},
  [548] = {.lex_state = 396, .external_lex_state = 4},
  [549] = {.lex_state = 396, .external_lex_state = 4},
  [550] = {.lex_state = 396, .external_lex_state = 4},
  [551] = {.lex_state = 396, .external_lex_state = 4},
  [552] = {.lex_state = 396, .external_lex_state = 4},
  [553] = {.lex_state = 396, .external_lex_state = 4},
  [554] = {.lex_state = 396, .external_lex_state = 4},
  [555] = {.lex_state = 396, .external_lex_state = 4},
  [556] = {.lex_state = 396, .external_lex_state = 4},
  [557] = {.lex_state = 396, .external_lex_state = 4},
  [558] = {.lex_state = 396, .external_lex_state = 4},
  [559] = {.lex_state = 396, .external_lex_state = 4},
  [560] = {.lex_state = 396, .external_lex_state = 4},
  [561] = {.lex_state = 396, .external_lex_state = 4},
  [562] = {.lex_state = 396, .external_lex_state = 4},
  [563] = {.lex_state = 396, .external_lex_state = 4},
  [564] = {.lex_state = 396, .external_lex_state = 4},
  [565] = {.lex_state = 396, .external_lex_state = 4},
  [566] = {.lex_state = 396, .external_lex_state = 4},
  [567] = {.lex_state = 396, .external_lex_state = 4},
  [568] = {.lex_state = 396, .external_lex_state = 4},
  [569] = {.lex_state = 396, .external_lex_state = 4},
  [570] = {.lex_state = 396, .external_lex_state = 4},
  [571] = {.lex_state = 396, .external_lex_state = 4},
  [572] = {.lex_state = 396, .external_lex_state = 4},
  [573] = {.lex_state = 396, .external_lex_state = 4},
  [574] = {.lex_state = 396, .external_lex_state = 4},
  [575] = {.lex_state = 396, .external_lex_state = 4},
  [576] = {.lex_state = 396, .external_lex_state = 4},
  [577] = {.lex_state = 396, .external_lex_state = 4},
  [578] = {.lex_state = 396, .external_lex_state = 4},
  [579] = {.lex_state = 396, .external_lex_state = 4},
  [580] = {.lex_state = 396, .external_lex_state = 4},
  [581] = {.lex_state = 396, .external_lex_state = 4},
  [582] = {.lex_state = 396, .external_lex_state = 4},
  [583] = {.lex_state = 396, .external_lex_state = 4},
  [584] = {.lex_state = 396, .external_lex_state = 4},
  [585] = {.lex_state = 396, .external_lex_state = 4},
  [586] = {.lex_state = 396, .external_lex_state = 4},
  [587] = {.lex_state = 396, .external_lex_state = 4},
  [588] = {.lex_state = 396, .external_lex_state = 4},
  [589] = {.lex_state = 396, .external_lex_state = 4},
  [590] = {.lex_state = 396, .external_lex_state = 4},
  [591] = {.lex_state = 396, .external_lex_state = 4},
  [592] = {.lex_state = 396, .external_lex_state = 4},
  [593] = {.lex_state = 396, .external_lex_state = 4},
  [594] = {.lex_state = 396, .external_lex_state = 4},
  [595] = {.lex_state = 396, .external_lex_state = 4},
  [596] = {.lex_state = 396, .external_lex_state = 4},
  [597] = {.lex_state = 396, .external_lex_state = 4},
  [598] = {.lex_state = 396, .external_lex_state = 4},
  [599] = {.lex_state = 396, .external_lex_state = 4},
  [600] = {.lex_state = 396, .external_lex_state = 4},
  [601] = {.lex_state = 396, .external_lex_state = 4},
  [602] = {.lex_state = 396, .external_lex_state = 4},
  [603] = {.lex_state = 396, .external_lex_state = 4},
  [604] = {.lex_state = 396, .external_lex_state = 4},
  [605] = {.lex_state = 396, .external_lex_state = 4},
  [606] = {.lex_state = 396, .external_lex_state = 4},
  [607] = {.lex_state = 396, .external_lex_state = 4},
  [608] = {.lex_state = 396, .external_lex_state = 4},
  [609] = {.lex_state = 396, .external_lex_state = 4},
  [610] = {.lex_state = 396, .external_lex_state = 4},
  [611] = {.lex_state = 396, .external_lex_state = 4},
  [612] = {.lex_state = 396, .external_lex_state = 4},
  [613] = {.lex_state = 396, .external_lex_state = 4},
  [614] = {.lex_state = 396, .external_lex_state = 4},
  [615] = {.lex_state = 396, .external_lex_state = 4},
  [616] = {.lex_state = 396, .external_lex_state = 4},
  [617] = {.lex_state = 396, .external_lex_state = 4},
  [618] = {.lex_state = 396, .external_lex_state = 4},
  [619] = {.lex_state = 396, .external_lex_state = 4},
  [620] = {.lex_state = 396, .external_lex_state = 4},
  [621] = {.lex_state = 396, .external_lex_state = 4},
  [622] = {.lex_state = 396, .external_lex_state = 4},
  [623] = {.lex_state = 396, .external_lex_state = 4},
  [624] = {.lex_state = 396, .external_lex_state = 4},
  [625] = {.lex_state = 396, .external_lex_state = 4},
  [626] = {.lex_state = 396, .external_lex_state = 4},
  [627] = {.lex_state = 396, .external_lex_state = 4},
  [628] = {.lex_state = 396, .external_lex_state = 4},
  [629] = {.lex_state = 396, .external_lex_state = 4},
  [630] = {.lex_state = 396, .external_lex_state = 4},
  [631] = {.lex_state = 396, .external_lex_state = 4},
  [632] = {.lex_state = 396, .external_lex_state = 4},
  [633] = {.lex_state = 396, .external_lex_state = 4},
  [634] = {.lex_state = 396, .external_lex_state = 4},
  [635] = {.lex_state = 396, .external_lex_state = 4},
  [636] = {.lex_state = 396, .external_lex_state = 4},
  [637] = {.lex_state = 396, .external_lex_state = 4},
  [638] = {.lex_state = 396, .external_lex_state = 4},
  [639] = {.lex_state = 396, .external_lex_state = 4},
  [640] = {.lex_state = 396, .external_lex_state = 4},
  [641] = {.lex_state = 396, .external_lex_state = 4},
  [642] = {.lex_state = 396, .external_lex_state = 4},
  [643] = {.lex_state = 396, .external_lex_state = 4},
  [644] = {.lex_state = 396, .external_lex_state = 4},
  [645] = {.lex_state = 396, .external_lex_state = 4},
  [646] = {.lex_state = 396, .external_lex_state = 4},
  [647] = {.lex_state = 396, .external_lex_state = 4},
  [648] = {.lex_state = 396, .external_lex_state = 4},
  [649] = {.lex_state = 396, .external_lex_state = 4},
  [650] = {.lex_state = 396, .external_lex_state = 4},
  [651] = {.lex_state = 396, .external_lex_state = 4},
  [652] = {.lex_state = 396, .external_lex_state = 4},
  [653] = {.lex_state = 396, .external_lex_state = 4},
  [654] = {.lex_state = 396, .external_lex_state = 4},
  [655] = {.lex_state = 396, .external_lex_state = 4},
  [656] = {.lex_state = 396, .external_lex_state = 4},
  [657] = {.lex_state = 396, .external_lex_state = 4},
  [658] = {.lex_state = 396, .external_lex_state = 4},
  [659] = {.lex_state = 396, .external_lex_state = 4},
  [660] = {.lex_state = 396, .external_lex_state = 4},
  [661] = {.lex_state = 396, .external_lex_state = 4},
  [662] = {.lex_state = 396, .external_lex_state = 4},
  [663] = {.lex_state = 396, .external_lex_state = 4},
  [664] = {.lex_state = 396, .external_lex_state = 4},
  [665] = {.lex_state = 396, .external_lex_state = 4},
  [666] = {.lex_state = 396, .external_lex_state = 4},
  [667] = {.lex_state = 396, .external_lex_state = 4},
  [668] = {.lex_state = 396, .external_lex_state = 4},
  [669] = {.lex_state = 396, .external_lex_state = 4},
  [670] = {.lex_state = 396, .external_lex_state = 4},
  [671] = {.lex_state = 396, .external_lex_state = 4},
  [672] = {.lex_state = 396, .external_lex_state = 4},
  [673] = {.lex_state = 396, .external_lex_state = 4},
  [674] = {.lex_state = 396, .external_lex_state = 4},
  [675] = {.lex_state = 396, .external_lex_state = 4},
  [676] = {.lex_state = 396, .external_lex_state = 4},
  [677] = {.lex_state = 396, .external_lex_state = 4},
  [678] = {.lex_state = 396, .external_lex_state = 4},
  [679] = {.lex_state = 396, .external_lex_state = 4},
  [680] = {.lex_state = 396, .external_lex_state = 4},
  [681] = {.lex_state = 396, .external_lex_state = 4},
  [682] = {.lex_state = 396, .external_lex_state = 4},
  [683] = {.lex_state = 396, .external_lex_state = 4},
  [684] = {.lex_state = 396, .external_lex_state = 4},
  [685] = {.lex_state = 396, .external_lex_state = 4},
  [686] = {.lex_state = 396, .external_lex_state = 4},
  [687] = {.lex_state = 396, .external_lex_state = 4},
  [688] = {.lex_state = 396, .external_lex_state = 4},
  [689] = {.lex_state = 396, .external_lex_state = 4},
  [690] = {.lex_state = 396, .external_lex_state = 4},
  [691] = {.lex_state = 396, .external_lex_state = 4},
  [692] = {.lex_state = 396, .external_lex_state = 4},
  [693] = {.lex_state = 396, .external_lex_state = 4},
  [694] = {.lex_state = 396, .external_lex_state = 4},
  [695] = {.lex_state = 396, .external_lex_state = 4},
  [696] = {.lex_state = 396, .external_lex_state = 4},
  [697] = {.lex_state = 396, .external_lex_state = 4},
  [698] = {.lex_state = 396, .external_lex_state = 4},
  [699] = {.lex_state = 396, .external_lex_state = 4},
  [700] = {.lex_state = 396, .external_lex_state = 4},
  [701] = {.lex_state = 396, .external_lex_state = 4},
  [702] = {.lex_state = 396, .external_lex_state = 4},
  [703] = {.lex_state = 396, .external_lex_state = 4},
  [704] = {.lex_state = 396, .external_lex_state = 4},
  [705] = {.lex_state = 396, .external_lex_state = 4},
  [706] = {.lex_state = 396, .external_lex_state = 4},
  [707] = {.lex_state = 396, .external_lex_state = 4},
  [708] = {.lex_state = 396, .external_lex_state = 4},
  [709] = {.lex_state = 396, .external_lex_state = 4},
  [710] = {.lex_state = 396, .external_lex_state = 4},
  [711] = {.lex_state = 396, .external_lex_state = 4},
  [712] = {.lex_state = 396, .external_lex_state = 4},
  [713] = {.lex_state = 396, .external_lex_state = 4},
  [714] = {.lex_state = 396, .external_lex_state = 4},
  [715] = {.lex_state = 396, .external_lex_state = 4},
  [716] = {.lex_state = 396, .external_lex_state = 4},
  [717] = {.lex_state = 396, .external_lex_state = 4},
  [718] = {.lex_state = 396, .external_lex_state = 4},
  [719] = {.lex_state = 396, .external_lex_state = 4},
  [720] = {.lex_state = 396, .external_lex_state = 4},
  [721] = {.lex_state = 396, .external_lex_state = 4},
  [722] = {.lex_state = 396, .external_lex_state = 4},
  [723] = {.lex_state = 396, .external_lex_state = 4},
  [724] = {.lex_state = 396, .external_lex_state = 4},
  [725] = {.lex_state = 396, .external_lex_state = 4},
  [726] = {.lex_state = 396, .external_lex_state = 4},
  [727] = {.lex_state = 396, .external_lex_state = 4},
  [728] = {.lex_state = 396, .external_lex_state = 4},
  [729] = {.lex_state = 396, .external_lex_state = 4},
  [730] = {.lex_state = 396, .external_lex_state = 4},
  [731] = {.lex_state = 396, .external_lex_state = 4},
  [732] = {.lex_state = 396, .external_lex_state = 4},
  [733] = {.lex_state = 396, .external_lex_state = 4},
  [734] = {.lex_state = 396, .external_lex_state = 4},
  [735] = {.lex_state = 396, .external_lex_state = 4},
  [736] = {.lex_state = 396, .external_lex_state = 4},
  [737] = {.lex_state = 396, .external_lex_state = 4},
  [738] = {.lex_state = 396, .external_lex_state = 4},
  [739] = {.lex_state = 396, .external_lex_state = 4},
  [740] = {.lex_state = 396, .external_lex_state = 4},
  [741] = {.lex_state = 396, .external_lex_state = 4},
  [742] = {.lex_state = 396, .external_lex_state = 4},
  [743] = {.lex_state = 396, .external_lex_state = 4},
  [744] = {.lex_state = 396, .external_lex_state = 4},
  [745] = {.lex_state = 396, .external_lex_state = 4},
  [746] = {.lex_state = 396, .external_lex_state = 4},
  [747] = {.lex_state = 396, .external_lex_state = 4},
  [748] = {.lex_state = 396, .external_lex_state = 4},
  [749] = {.lex_state = 396, .external_lex_state = 4},
  [750] = {.lex_state = 396, .external_lex_state = 4},
  [751] = {.lex_state = 396, .external_lex_state = 4},
  [752] = {.lex_state = 396, .external_lex_state = 4},
  [753] = {.lex_state = 396, .external_lex_state = 4},
  [754] = {.lex_state = 396, .external_lex_state = 4},
  [755] = {.lex_state = 396, .external_lex_state = 4},
  [756] = {.lex_state = 396, .external_lex_state = 4},
  [757] = {.lex_state = 396, .external_lex_state = 4},
  [758] = {.lex_state = 396, .external_lex_state = 4},
  [759] = {.lex_state = 396, .external_lex_state = 4},
  [760] = {.lex_state = 396, .external_lex_state = 4},
  [761] = {.lex_state = 396, .external_lex_state = 4},
  [762] = {.lex_state = 396, .external_lex_state = 4},
  [763] = {.lex_state = 396, .external_lex_state = 4},
  [764] = {.lex_state = 396, .external_lex_state = 4},
  [765] = {.lex_state = 396, .external_lex_state = 4},
  [766] = {.lex_state = 396, .external_lex_state = 4},
  [767] = {.lex_state = 396, .external_lex_state = 4},
  [768] = {.lex_state = 396, .external_lex_state = 4},
  [769] = {.lex_state = 396, .external_lex_state = 4},
  [770] = {.lex_state = 396, .external_lex_state = 4},
  [771] = {.lex_state = 396, .external_lex_state = 4},
  [772] = {.lex_state = 396, .external_lex_state = 4},
  [773] = {.lex_state = 396, .external_lex_state = 4},
  [774] = {.lex_state = 396, .external_lex_state = 4},
  [775] = {.lex_state = 396, .external_lex_state = 4},
  [776] = {.lex_state = 396, .external_lex_state = 4},
  [777] = {.lex_state = 396, .external_lex_state = 4},
  [778] = {.lex_state = 396, .external_lex_state = 4},
  [779] = {.lex_state = 396, .external_lex_state = 4},
  [780] = {.lex_state = 396, .external_lex_state = 4},
  [781] = {.lex_state = 396, .external_lex_state = 4},
  [782] = {.lex_state = 396, .external_lex_state = 4},
  [783] = {.lex_state = 396, .external_lex_state = 4},
  [784] = {.lex_state = 396, .external_lex_state = 4},
  [785] = {.lex_state = 396, .external_lex_state = 4},
  [786] = {.lex_state = 396, .external_lex_state = 4},
  [787] = {.lex_state = 396, .external_lex_state = 4},
  [788] = {.lex_state = 396, .external_lex_state = 4},
  [789] = {.lex_state = 396, .external_lex_state = 4},
  [790] = {.lex_state = 396, .external_lex_state = 4},
  [791] = {.lex_state = 396, .external_lex_state = 4},
  [792] = {.lex_state = 396, .external_lex_state = 4},
  [793] = {.lex_state = 396, .external_lex_state = 4},
  [794] = {.lex_state = 396, .external_lex_state = 4},
  [795] = {.lex_state = 396, .external_lex_state = 4},
  [796] = {.lex_state = 396, .external_lex_state = 4},
  [797] = {.lex_state = 396, .external_lex_state = 4},
  [798] = {.lex_state = 396, .external_lex_state = 4},
  [799] = {.lex_state = 396, .external_lex_state = 4},
  [800] = {.lex_state = 396, .external_lex_state = 4},
  [801] = {.lex_state = 396, .external_lex_state = 4},
  [802] = {.lex_state = 396, .external_lex_state = 4},
  [803] = {.lex_state = 396, .external_lex_state = 4},
  [804] = {.lex_state = 396, .external_lex_state = 4},
  [805] = {.lex_state = 396, .external_lex_state = 4},
  [806] = {.lex_state = 396, .external_lex_state = 4},
  [807] = {.lex_state = 396, .external_lex_state = 4},
  [808] = {.lex_state = 396, .external_lex_state = 4},
  [809] = {.lex_state = 396, .external_lex_state = 4},
  [810] = {.lex_state = 396, .external_lex_state = 4},
  [811] = {.lex_state = 396, .external_lex_state = 4},
  [812] = {.lex_state = 396, .external_lex_state = 4},
  [813] = {.lex_state = 396, .external_lex_state = 4},
  [814] = {.lex_state = 396, .external_lex_state = 4},
  [815] = {.lex_state = 396, .external_lex_state = 4},
  [816] = {.lex_state = 396, .external_lex_state = 4},
  [817] = {.lex_state = 396, .external_lex_state = 4},
  [818] = {.lex_state = 396, .external_lex_state = 4},
  [819] = {.lex_state = 396, .external_lex_state = 4},
  [820] = {.lex_state = 396, .external_lex_state = 4},
  [821] = {.lex_state = 396, .external_lex_state = 4},
  [822] = {.lex_state = 396, .external_lex_state = 4},
  [823] = {.lex_state = 396, .external_lex_state = 4},
  [824] = {.lex_state = 396, .external_lex_state = 4},
  [825] = {.lex_state = 396, .external_lex_state = 4},
  [826] = {.lex_state = 396, .external_lex_state = 4},
  [827] = {.lex_state = 396, .external_lex_state = 4},
  [828] = {.lex_state = 396, .external_lex_state = 4},
  [829] = {.lex_state = 396, .external_lex_state = 4},
  [830] = {.lex_state = 396, .external_lex_state = 4},
  [831] = {.lex_state = 396, .external_lex_state = 4},
  [832] = {.lex_state = 396, .external_lex_state = 4},
  [833] = {.lex_state = 396, .external_lex_state = 4},
  [834] = {.lex_state = 396, .external_lex_state = 4},
  [835] = {.lex_state = 396, .external_lex_state = 4},
  [836] = {.lex_state = 396, .external_lex_state = 4},
  [837] = {.lex_state = 396, .external_lex_state = 4},
  [838] = {.lex_state = 396, .external_lex_state = 4},
  [839] = {.lex_state = 396, .external_lex_state = 4},
  [840] = {.lex_state = 396, .external_lex_state = 4},
  [841] = {.lex_state = 396, .external_lex_state = 4},
  [842] = {.lex_state = 396, .external_lex_state = 4},
  [843] = {.lex_state = 396, .external_lex_state = 4},
  [844] = {.lex_state = 396, .external_lex_state = 4},
  [845] = {.lex_state = 396, .external_lex_state = 4},
  [846] = {.lex_state = 396, .external_lex_state = 4},
  [847] = {.lex_state = 396, .external_lex_state = 4},
  [848] = {.lex_state = 396, .external_lex_state = 4},
  [849] = {.lex_state = 396, .external_lex_state = 4},
  [850] = {.lex_state = 396, .external_lex_state = 4},
  [851] = {.lex_state = 396, .external_lex_state = 4},
  [852] = {.lex_state = 396, .external_lex_state = 4},
  [853] = {.lex_state = 396, .external_lex_state = 4},
  [854] = {.lex_state = 396, .external_lex_state = 4},
  [855] = {.lex_state = 396, .external_lex_state = 4},
  [856] = {.lex_state = 396, .external_lex_state = 4},
  [857] = {.lex_state = 396, .external_lex_state = 4},
  [858] = {.lex_state = 396, .external_lex_state = 4},
  [859] = {.lex_state = 396, .external_lex_state = 4},
  [860] = {.lex_state = 396, .external_lex_state = 4},
  [861] = {.lex_state = 396, .external_lex_state = 4},
  [862] = {.lex_state = 396, .external_lex_state = 4},
  [863] = {.lex_state = 396, .external_lex_state = 4},
  [864] = {.lex_state = 396, .external_lex_state = 4},
  [865] = {.lex_state = 396, .external_lex_state = 4},
  [866] = {.lex_state = 396, .external_lex_state = 4},
  [867] = {.lex_state = 396, .external_lex_state = 4},
  [868] = {.lex_state = 396, .external_lex_state = 4},
  [869] = {.lex_state = 396, .external_lex_state = 4},
  [870] = {.lex_state = 396, .external_lex_state = 4},
  [871] = {.lex_state = 396, .external_lex_state = 4},
  [872] = {.lex_state = 396, .external_lex_state = 4},
  [873] = {.lex_state = 396, .external_lex_state = 4},
  [874] = {.lex_state = 396, .external_lex_state = 4},
  [875] = {.lex_state = 396, .external_lex_state = 4},
  [876] = {.lex_state = 396, .external_lex_state = 4},
  [877] = {.lex_state = 396, .external_lex_state = 4},
  [878] = {.lex_state = 396, .external_lex_state = 4},
  [879] = {.lex_state = 396, .external_lex_state = 4},
  [880] = {.lex_state = 396, .external_lex_state = 4},
  [881] = {.lex_state = 396, .external_lex_state = 4},
  [882] = {.lex_state = 396, .external_lex_state = 4},
  [883] = {.lex_state = 396, .external_lex_state = 4},
  [884] = {.lex_state = 396, .external_lex_state = 4},
  [885] = {.lex_state = 396, .external_lex_state = 4},
  [886] = {.lex_state = 396, .external_lex_state = 4},
  [887] = {.lex_state = 396, .external_lex_state = 4},
  [888] = {.lex_state = 396, .external_lex_state = 4},
  [889] = {.lex_state = 396, .external_lex_state = 4},
  [890] = {.lex_state = 396, .external_lex_state = 4},
  [891] = {.lex_state = 396, .external_lex_state = 4},
  [892] = {.lex_state = 396, .external_lex_state = 4},
  [893] = {.lex_state = 396, .external_lex_state = 4},
  [894] = {.lex_state = 396, .external_lex_state = 4},
  [895] = {.lex_state = 396, .external_lex_state = 4},
  [896] = {.lex_state = 396, .external_lex_state = 4},
  [897] = {.lex_state = 396, .external_lex_state = 4},
  [898] = {.lex_state = 396, .external_lex_state = 4},
  [899] = {.lex_state = 396, .external_lex_state = 4},
  [900] = {.lex_state = 396, .external_lex_state = 4},
  [901] = {.lex_state = 396, .external_lex_state = 4},
  [902] = {.lex_state = 396, .external_lex_state = 4},
  [903] = {.lex_state = 396, .external_lex_state = 4},
  [904] = {.lex_state = 396, .external_lex_state = 4},
  [905] = {.lex_state = 396, .external_lex_state = 4},
  [906] = {.lex_state = 396, .external_lex_state = 4},
  [907] = {.lex_state = 396, .external_lex_state = 4},
  [908] = {.lex_state = 396, .external_lex_state = 4},
  [909] = {.lex_state = 396, .external_lex_state = 4},
  [910] = {.lex_state = 396, .external_lex_state = 4},
  [911] = {.lex_state = 396, .external_lex_state = 4},
  [912] = {.lex_state = 396, .external_lex_state = 4},
  [913] = {.lex_state = 396, .external_lex_state = 4},
  [914] = {.lex_state = 396, .external_lex_state = 4},
  [915] = {.lex_state = 396, .external_lex_state = 4},
  [916] = {.lex_state = 396, .external_lex_state = 4},
  [917] = {.lex_state = 396, .external_lex_state = 4},
  [918] = {.lex_state = 396, .external_lex_state = 4},
  [919] = {.lex_state = 396, .external_lex_state = 4},
  [920] = {.lex_state = 396, .external_lex_state = 4},
  [921] = {.lex_state = 396, .external_lex_state = 4},
  [922] = {.lex_state = 396, .external_lex_state = 4},
  [923] = {.lex_state = 396, .external_lex_state = 4},
  [924] = {.lex_state = 396, .external_lex_state = 4},
  [925] = {.lex_state = 396, .external_lex_state = 4},
  [926] = {.lex_state = 396, .external_lex_state = 4},
  [927] = {.lex_state = 396, .external_lex_state = 4},
  [928] = {.lex_state = 396, .external_lex_state = 4},
  [929] = {.lex_state = 396, .external_lex_state = 4},
  [930] = {.lex_state = 396, .external_lex_state = 4},
  [931] = {.lex_state = 396, .external_lex_state = 4},
  [932] = {.lex_state = 396, .external_lex_state = 4},
  [933] = {.lex_state = 396, .external_lex_state = 4},
  [934] = {.lex_state = 396, .external_lex_state = 4},
  [935] = {.lex_state = 396, .external_lex_state = 4},
  [936] = {.lex_state = 396, .external_lex_state = 4},
  [937] = {.lex_state = 396, .external_lex_state = 4},
  [938] = {.lex_state = 396, .external_lex_state = 4},
  [939] = {.lex_state = 396, .external_lex_state = 4},
  [940] = {.lex_state = 396, .external_lex_state = 4},
  [941] = {.lex_state = 396, .external_lex_state = 4},
  [942] = {.lex_state = 396, .external_lex_state = 4},
  [943] = {.lex_state = 396, .external_lex_state = 4},
  [944] = {.lex_state = 396, .external_lex_state = 4},
  [945] = {.lex_state = 396, .external_lex_state = 4},
  [946] = {.lex_state = 396, .external_lex_state = 4},
  [947] = {.lex_state = 396, .external_lex_state = 4},
  [948] = {.lex_state = 396, .external_lex_state = 4},
  [949] = {.lex_state = 396, .external_lex_state = 4},
  [950] = {.lex_state = 396, .external_lex_state = 4},
  [951] = {.lex_state = 396, .external_lex_state = 4},
  [952] = {.lex_state = 396, .external_lex_state = 4},
  [953] = {.lex_state = 396, .external_lex_state = 4},
  [954] = {.lex_state = 396, .external_lex_state = 4},
  [955] = {.lex_state = 396, .external_lex_state = 4},
  [956] = {.lex_state = 396, .external_lex_state = 4},
  [957] = {.lex_state = 396, .external_lex_state = 4},
  [958] = {.lex_state = 396, .external_lex_state = 4},
  [959] = {.lex_state = 396, .external_lex_state = 4},
  [960] = {.lex_state = 396, .external_lex_state = 4},
  [961] = {.lex_state = 396, .external_lex_state = 4},
  [962] = {.lex_state = 396, .external_lex_state = 4},
  [963] = {.lex_state = 396, .external_lex_state = 4},
  [964] = {.lex_state = 396, .external_lex_state = 4},
  [965] = {.lex_state = 396, .external_lex_state = 4},
  [966] = {.lex_state = 396, .external_lex_state = 4},
  [967] = {.lex_state = 396, .external_lex_state = 4},
  [968] = {.lex_state = 396, .external_lex_state = 4},
  [969] = {.lex_state = 396, .external_lex_state = 4},
  [970] = {.lex_state = 396, .external_lex_state = 4},
  [971] = {.lex_state = 396, .external_lex_state = 4},
  [972] = {.lex_state = 396, .external_lex_state = 4},
  [973] = {.lex_state = 396, .external_lex_state = 4},
  [974] = {.lex_state = 396, .external_lex_state = 4},
  [975] = {.lex_state = 396, .external_lex_state = 4},
  [976] = {.lex_state = 396, .external_lex_state = 4},
  [977] = {.lex_state = 396, .external_lex_state = 4},
  [978] = {.lex_state = 396, .external_lex_state = 4},
  [979] = {.lex_state = 396, .external_lex_state = 4},
  [980] = {.lex_state = 396, .external_lex_state = 4},
  [981] = {.lex_state = 396, .external_lex_state = 4},
  [982] = {.lex_state = 396, .external_lex_state = 4},
  [983] = {.lex_state = 396, .external_lex_state = 4},
  [984] = {.lex_state = 396, .external_lex_state = 4},
  [985] = {.lex_state = 396, .external_lex_state = 4},
  [986] = {.lex_state = 396, .external_lex_state = 4},
  [987] = {.lex_state = 396, .external_lex_state = 4},
  [988] = {.lex_state = 396, .external_lex_state = 4},
  [989] = {.lex_state = 396, .external_lex_state = 4},
  [990] = {.lex_state = 396, .external_lex_state = 4},
  [991] = {.lex_state = 396, .external_lex_state = 4},
  [992] = {.lex_state = 396, .external_lex_state = 4},
  [993] = {.lex_state = 396, .external_lex_state = 4},
  [994] = {.lex_state = 396, .external_lex_state = 4},
  [995] = {.lex_state = 396, .external_lex_state = 4},
  [996] = {.lex_state = 396, .external_lex_state = 4},
  [997] = {.lex_state = 396, .external_lex_state = 4},
  [998] = {.lex_state = 396, .external_lex_state = 4},
  [999] = {.lex_state = 396, .external_lex_state = 4},
  [1000] = {.lex_state = 396, .external_lex_state = 4},
  [1001] = {.lex_state = 396, .external_lex_state = 4},
  [1002] = {.lex_state = 396, .external_lex_state = 4},
  [1003] = {.lex_state = 396, .external_lex_state = 4},
  [1004] = {.lex_state = 396, .external_lex_state = 4},
  [1005] = {.lex_state = 396, .external_lex_state = 4},
  [1006] = {.lex_state = 396, .external_lex_state = 4},
  [1007] = {.lex_state = 396, .external_lex_state = 4},
  [1008] = {.lex_state = 396, .external_lex_state = 4},
  [1009] = {.lex_state = 396, .external_lex_state = 4},
  [1010] = {.lex_state = 396, .external_lex_state = 4},
  [1011] = {.lex_state = 396, .external_lex_state = 4},
  [1012] = {.lex_state = 396, .external_lex_state = 4},
  [1013] = {.lex_state = 396, .external_lex_state = 4},
  [1014] = {.lex_state = 396, .external_lex_state = 4},
  [1015] = {.lex_state = 396, .external_lex_state = 4},
  [1016] = {.lex_state = 396, .external_lex_state = 4},
  [1017] = {.lex_state = 396, .external_lex_state = 4},
  [1018] = {.lex_state = 396, .external_lex_state = 4},
  [1019] = {.lex_state = 396, .external_lex_state = 4},
  [1020] = {.lex_state = 396, .external_lex_state = 4},
  [1021] = {.lex_state = 396, .external_lex_state = 4},
  [1022] = {.lex_state = 396, .external_lex_state = 4},
  [1023] = {.lex_state = 396, .external_lex_state = 4},
  [1024] = {.lex_state = 401, .external_lex_state = 6},
  [1025] = {.lex_state = 401, .external_lex_state = 6},
  [1026] = {.lex_state = 401, .external_lex_state = 6},
  [1027] = {.lex_state = 401, .external_lex_state = 6},
  [1028] = {.lex_state = 401, .external_lex_state = 6},
  [1029] = {.lex_state = 401, .external_lex_state = 6},
  [1030] = {.lex_state = 401, .external_lex_state = 6},
  [1031] = {.lex_state = 401, .external_lex_state = 6},
  [1032] = {.lex_state = 401, .external_lex_state = 6},
  [1033] = {.lex_state = 401, .external_lex_state = 6},
  [1034] = {.lex_state = 401, .external_lex_state = 6},
  [1035] = {.lex_state = 401, .external_lex_state = 6},
  [1036] = {.lex_state = 401, .external_lex_state = 6},
  [1037] = {.lex_state = 401, .external_lex_state = 6},
  [1038] = {.lex_state = 401, .external_lex_state = 6},
  [1039] = {.lex_state = 401, .external_lex_state = 6},
  [1040] = {.lex_state = 401, .external_lex_state = 6},
  [1041] = {.lex_state = 401, .external_lex_state = 6},
  [1042] = {.lex_state = 401, .external_lex_state = 6},
  [1043] = {.lex_state = 401, .external_lex_state = 6},
  [1044] = {.lex_state = 401, .external_lex_state = 6},
  [1045] = {.lex_state = 401, .external_lex_state = 6},
  [1046] = {.lex_state = 401, .external_lex_state = 6},
  [1047] = {.lex_state = 401, .external_lex_state = 6},
  [1048] = {.lex_state = 401, .external_lex_state = 6},
  [1049] = {.lex_state = 401, .external_lex_state = 6},
  [1050] = {.lex_state = 401, .external_lex_state = 6},
  [1051] = {.lex_state = 401, .external_lex_state = 6},
  [1052] = {.lex_state = 401, .external_lex_state = 6},
  [1053] = {.lex_state = 401, .external_lex_state = 6},
  [1054] = {.lex_state = 401, .external_lex_state = 6},
  [1055] = {.lex_state = 401, .external_lex_state = 6},
  [1056] = {.lex_state = 401, .external_lex_state = 6},
  [1057] = {.lex_state = 401, .external_lex_state = 6},
  [1058] = {.lex_state = 441},
  [1059] = {.lex_state = 441},
  [1060] = {.lex_state = 441},
  [1061] = {.lex_state = 441},
  [1062] = {.lex_state = 441},
  [1063] = {.lex_state = 441},
  [1064] = {.lex_state = 441},
  [1065] = {.lex_state = 441},
  [1066] = {.lex_state = 441},
  [1067] = {.lex_state = 441},
  [1068] = {.lex_state = 441},
  [1069] = {.lex_state = 441},
  [1070] = {.lex_state = 441},
  [1071] = {.lex_state = 441},
  [1072] = {.lex_state = 441},
  [1073] = {.lex_state = 441},
  [1074] = {.lex_state = 441},
  [1075] = {.lex_state = 441},
  [1076] = {.lex_state = 441},
  [1077] = {.lex_state = 441},
  [1078] = {.lex_state = 441},
  [1079] = {.lex_state = 441},
  [1080] = {.lex_state = 441},
  [1081] = {.lex_state = 441},
  [1082] = {.lex_state = 441},
  [1083] = {.lex_state = 441},
  [1084] = {.lex_state = 441},
  [1085] = {.lex_state = 441},
  [1086] = {.lex_state = 441},
  [1087] = {.lex_state = 441},
  [1088] = {.lex_state = 441},
  [1089] = {.lex_state = 441},
  [1090] = {.lex_state = 401},
  [1091] = {.lex_state = 401},
  [1092] = {.lex_state = 401},
  [1093] = {.lex_state = 401},
  [1094] = {.lex_state = 401},
  [1095] = {.lex_state = 401},
  [1096] = {.lex_state = 401},
  [1097] = {.lex_state = 401},
  [1098] = {.lex_state = 401},
  [1099] = {.lex_state = 401},
  [1100] = {.lex_state = 401},
  [1101] = {.lex_state = 401},
  [1102] = {.lex_state = 401},
  [1103] = {.lex_state = 401},
  [1104] = {.lex_state = 401},
  [1105] = {.lex_state = 401},
  [1106] = {.lex_state = 401},
  [1107] = {.lex_state = 401},
  [1108] = {.lex_state = 401},
  [1109] = {.lex_state = 401},
  [1110] = {.lex_state = 401},
  [1111] = {.lex_state = 401},
  [1112] = {.lex_state = 401},
  [1113] = {.lex_state = 401},
  [1114] = {.lex_state = 401},
  [1115] = {.lex_state = 401},
  [1116] = {.lex_state = 401},
  [1117] = {.lex_state = 401},
  [1118] = {.lex_state = 401},
  [1119] = {.lex_state = 401},
  [1120] = {.lex_state = 401},
  [1121] = {.lex_state = 401},
  [1122] = {.lex_state = 401},
  [1123] = {.lex_state = 401},
  [1124] = {.lex_state = 401},
  [1125] = {.lex_state = 401},
  [1126] = {.lex_state = 401},
  [1127] = {.lex_state = 401},
  [1128] = {.lex_state = 401},
  [1129] = {.lex_state = 401},
  [1130] = {.lex_state = 401},
  [1131] = {.lex_state = 401},
  [1132] = {.lex_state = 401},
  [1133] = {.lex_state = 402},
  [1134] = {.lex_state = 402},
  [1135] = {.lex_state = 402},
  [1136] = {.lex_state = 402},
  [1137] = {.lex_state = 402},
  [1138] = {.lex_state = 402},
  [1139] = {.lex_state = 402},
  [1140] = {.lex_state = 402},
  [1141] = {.lex_state = 402},
  [1142] = {.lex_state = 402},
  [1143] = {.lex_state = 402},
  [1144] = {.lex_state = 402},
  [1145] = {.lex_state = 402},
  [1146] = {.lex_state = 402},
  [1147] = {.lex_state = 402},
  [1148] = {.lex_state = 402},
  [1149] = {.lex_state = 402},
  [1150] = {.lex_state = 402},
  [1151] = {.lex_state = 402},
  [1152] = {.lex_state = 402},
  [1153] = {.lex_state = 402},
  [1154] = {.lex_state = 402},
  [1155] = {.lex_state = 402},
  [1156] = {.lex_state = 402},
  [1157] = {.lex_state = 402},
  [1158] = {.lex_state = 402},
  [1159] = {.lex_state = 402},
  [1160] = {.lex_state = 402},
  [1161] = {.lex_state = 402},
  [1162] = {.lex_state = 402},
  [1163] = {.lex_state = 402},
  [1164] = {.lex_state = 402},
  [1165] = {.lex_state = 402},
  [1166] = {.lex_state = 402},
  [1167] = {.lex_state = 402},
  [1168] = {.lex_state = 402},
  [1169] = {.lex_state = 402},
  [1170] = {.lex_state = 402},
  [1171] = {.lex_state = 402},
  [1172] = {.lex_state = 402},
  [1173] = {.lex_state = 402},
  [1174] = {.lex_state = 402},
  [1175] = {.lex_state = 402},
  [1176] = {.lex_state = 402},
  [1177] = {.lex_state = 402},
  [1178] = {.lex_state = 402},
  [1179] = {.lex_state = 402},
  [1180] = {.lex_state = 403},
  [1181] = {.lex_state = 403},
  [1182] = {.lex_state = 403},
  [1183] = {.lex_state = 403},
  [1184] = {.lex_state = 403},
  [1185] = {.lex_state = 403},
  [1186] = {.lex_state = 403},
  [1187] = {.lex_state = 403},
  [1188] = {.lex_state = 403},
  [1189] = {.lex_state = 403},
  [1190] = {.lex_state = 403},
  [1191] = {.lex_state = 403},
  [1192] = {.lex_state = 403},
  [1193] = {.lex_state = 403},
  [1194] = {.lex_state = 403},
  [1195] = {.lex_state = 403},
  [1196] = {.lex_state = 403},
  [1197] = {.lex_state = 403},
  [1198] = {.lex_state = 403},
  [1199] = {.lex_state = 403},
  [1200] = {.lex_state = 403},
  [1201] = {.lex_state = 404},
  [1202] = {.lex_state = 404},
  [1203] = {.lex_state = 404},
  [1204] = {.lex_state = 404},
  [1205] = {.lex_state = 404},
  [1206] = {.lex_state = 404},
  [1207] = {.lex_state = 404},
  [1208] = {.lex_state = 404},
  [1209] = {.lex_state = 404},
  [1210] = {.lex_state = 404},
  [1211] = {.lex_state = 404},
  [1212] = {.lex_state = 404},
  [1213] = {.lex_state = 404},
  [1214] = {.lex_state = 404},
  [1215] = {.lex_state = 404},
  [1216] = {.lex_state = 404},
  [1217] = {.lex_state = 404},
  [1218] = {.lex_state = 404},
  [1219] = {.lex_state = 404},
  [1220] = {.lex_state = 404},
  [1221] = {.lex_state = 404},
  [1222] = {.lex_state = 404},
  [1223] = {.lex_state = 404},
  [1224] = {.lex_state = 404},
  [1225] = {.lex_state = 404},
  [1226] = {.lex_state = 404},
  [1227] = {.lex_state = 404},
  [1228] = {.lex_state = 404},
  [1229] = {.lex_state = 404},
  [1230] = {.lex_state = 404},
  [1231] = {.lex_state = 404},
  [1232] = {.lex_state = 404},
  [1233] = {.lex_state = 404},
  [1234] = {.lex_state = 405, .external_lex_state = 7},
  [1235] = {.lex_state = 405, .external_lex_state = 7},
  [1236] = {.lex_state = 405, .external_lex_state = 7},
  [1237] = {.lex_state = 405, .external_lex_state = 7},
  [1238] = {.lex_state = 405, .external_lex_state = 7},
  [1239] = {.lex_state = 405, .external_lex_state = 7},
  [1240] = {.lex_state = 405, .external_lex_state = 7},
  [1241] = {.lex_state = 405, .external_lex_state = 7},
  [1242] = {.lex_state = 405, .external_lex_state = 7},
  [1243] = {.lex_state = 405, .external_lex_state = 7},
  [1244] = {.lex_state = 405, .external_lex_state = 7},
  [1245] = {.lex_state = 405, .external_lex_state = 7},
  [1246] = {.lex_state = 405, .external_lex_state = 7},
  [1247] = {.lex_state = 405, .external_lex_state = 7},
  [1248] = {.lex_state = 404},
  [1249] = {.lex_state = 405, .external_lex_state = 7},
  [1250] = {.lex_state = 404},
  [1251] = {.lex_state = 405, .external_lex_state = 7},
  [1252] = {.lex_state = 405, .external_lex_state = 7},
  [1253] = {.lex_state = 405, .external_lex_state = 7},
  [1254] = {.lex_state = 405, .external_lex_state = 7},
  [1255] = {.lex_state = 405, .external_lex_state = 7},
  [1256] = {.lex_state = 405, .external_lex_state = 7},
  [1257] = {.lex_state = 404},
  [1258] = {.lex_state = 405, .external_lex_state = 7},
  [1259] = {.lex_state = 404},
  [1260] = {.lex_state = 404},
  [1261] = {.lex_state = 404},
  [1262] = {.lex_state = 405, .external_lex_state = 7},
  [1263] = {.lex_state = 405, .external_lex_state = 7},
  [1264] = {.lex_state = 405, .external_lex_state = 7},
  [1265] = {.lex_state = 405, .external_lex_state = 7},
  [1266] = {.lex_state = 405, .external_lex_state = 7},
  [1267] = {.lex_state = 405, .external_lex_state = 7},
  [1268] = {.lex_state = 405, .external_lex_state = 7},
  [1269] = {.lex_state = 405, .external_lex_state = 7},
  [1270] = {.lex_state = 405, .external_lex_state = 7},
  [1271] = {.lex_state = 404},
  [1272] = {.lex_state = 405, .external_lex_state = 7},
  [1273] = {.lex_state = 405, .external_lex_state = 7},
  [1274] = {.lex_state = 404},
  [1275] = {.lex_state = 405, .external_lex_state = 7},
  [1276] = {.lex_state = 405, .external_lex_state = 7},
  [1277] = {.lex_state = 405, .external_lex_state = 7},
  [1278] = {.lex_state = 405, .external_lex_state = 7},
  [1279] = {.lex_state = 405, .external_lex_state = 7},
  [1280] = {.lex_state = 405, .external_lex_state = 7},
  [1281] = {.lex_state = 405, .external_lex_state = 7},
  [1282] = {.lex_state = 405, .external_lex_state = 7},
  [1283] = {.lex_state = 406, .external_lex_state = 8},
  [1284] = {.lex_state = 407},
  [1285] = {.lex_state = 406, .external_lex_state = 8},
  [1286] = {.lex_state = 407},
  [1287] = {.lex_state = 407},
  [1288] = {.lex_state = 407},
  [1289] = {.lex_state = 407},
  [1290] = {.lex_state = 406, .external_lex_state = 8},
  [1291] = {.lex_state = 407},
  [1292] = {.lex_state = 406, .external_lex_state = 8},
  [1293] = {.lex_state = 406, .external_lex_state = 8},
  [1294] = {.lex_state = 406, .external_lex_state = 8},
  [1295] = {.lex_state = 406, .external_lex_state = 8},
  [1296] = {.lex_state = 406, .external_lex_state = 8},
  [1297] = {.lex_state = 406, .external_lex_state = 8},
  [1298] = {.lex_state = 407},
  [1299] = {.lex_state = 406, .external_lex_state = 8},
  [1300] = {.lex_state = 407},
  [1301] = {.lex_state = 407},
  [1302] = {.lex_state = 407},
  [1303] = {.lex_state = 406, .external_lex_state = 8},
  [1304] = {.lex_state = 406, .external_lex_state = 8},
  [1305] = {.lex_state = 406, .external_lex_state = 8},
  [1306] = {.lex_state = 406, .external_lex_state = 8},
  [1307] = {.lex_state = 406, .external_lex_state = 8},
  [1308] = {.lex_state = 406, .external_lex_state = 8},
  [1309] = {.lex_state = 406, .external_lex_state = 8},
  [1310] = {.lex_state = 407},
  [1311] = {.lex_state = 407},
  [1312] = {.lex_state = 406, .external_lex_state = 8},
  [1313] = {.lex_state = 406, .external_lex_state = 8},
  [1314] = {.lex_state = 406, .external_lex_state = 8},
  [1315] = {.lex_state = 407},
  [1316] = {.lex_state = 406, .external_lex_state = 8},
  [1317] = {.lex_state = 406, .external_lex_state = 8},
  [1318] = {.lex_state = 406, .external_lex_state = 8},
  [1319] = {.lex_state = 406, .external_lex_state = 8},
  [1320] = {.lex_state = 407},
  [1321] = {.lex_state = 406, .external_lex_state = 8},
  [1322] = {.lex_state = 407},
  [1323] = {.lex_state = 407},
  [1324] = {.lex_state = 407},
  [1325] = {.lex_state = 407},
  [1326] = {.lex_state = 407},
  [1327] = {.lex_state = 406, .external_lex_state = 8},
  [1328] = {.lex_state = 407},
  [1329] = {.lex_state = 406, .external_lex_state = 8},
  [1330] = {.lex_state = 406, .external_lex_state = 8},
  [1331] = {.lex_state = 406, .external_lex_state = 8},
  [1332] = {.lex_state = 406, .external_lex_state = 8},
  [1333] = {.lex_state = 406, .external_lex_state = 8},
  [1334] = {.lex_state = 407},
  [1335] = {.lex_state = 407},
  [1336] = {.lex_state = 407},
  [1337] = {.lex_state = 407},
  [1338] = {.lex_state = 407},
  [1339] = {.lex_state = 407},
  [1340] = {.lex_state = 407},
  [1341] = {.lex_state = 407},
  [1342] = {.lex_state = 407},
  [1343] = {.lex_state = 407},
  [1344] = {.lex_state = 407, .external_lex_state = 8},
  [1345] = {.lex_state = 408, .external_lex_state = 8},
  [1346] = {.lex_state = 407, .external_lex_state = 8},
  [1347] = {.lex_state = 407, .external_lex_state = 8},
  [1348] = {.lex_state = 407, .external_lex_state = 8},
  [1349] = {.lex_state = 407, .external_lex_state = 8},
  [1350] = {.lex_state = 407, .external_lex_state = 8},
  [1351] = {.lex_state = 407, .external_lex_state = 8},
  [1352] = {.lex_state = 407, .external_lex_state = 8},
  [1353] = {.lex_state = 407, .external_lex_state = 8},
  [1354] = {.lex_state = 407, .external_lex_state = 8},
  [1355] = {.lex_state = 409},
  [1356] = {.lex_state = 409},
  [1357] = {.lex_state = 409},
  [1358] = {.lex_state = 409},
  [1359] = {.lex_state = 409},
  [1360] = {.lex_state = 407, .external_lex_state = 8},
  [1361] = {.lex_state = 407, .external_lex_state = 8},
  [1362] = {.lex_state = 407, .external_lex_state = 8},
  [1363] = {.lex_state = 407, .external_lex_state = 8},
  [1364] = {.lex_state = 407, .external_lex_state = 8},
  [1365] = {.lex_state = 407, .external_lex_state = 8},
  [1366] = {.lex_state = 407, .external_lex_state = 8},
  [1367] = {.lex_state = 407, .external_lex_state = 8},
  [1368] = {.lex_state = 407, .external_lex_state = 8},
  [1369] = {.lex_state = 407, .external_lex_state = 8},
  [1370] = {.lex_state = 409},
  [1371] = {.lex_state = 409},
  [1372] = {.lex_state = 409},
  [1373] = {.lex_state = 409},
  [1374] = {.lex_state = 407, .external_lex_state = 8},
  [1375] = {.lex_state = 407, .external_lex_state = 8},
  [1376] = {.lex_state = 407, .external_lex_state = 8},
  [1377] = {.lex_state = 407, .external_lex_state = 8},
  [1378] = {.lex_state = 407, .external_lex_state = 8},
  [1379] = {.lex_state = 407, .external_lex_state = 8},
  [1380] = {.lex_state = 409},
  [1381] = {.lex_state = 409},
  [1382] = {.lex_state = 407, .external_lex_state = 8},
  [1383] = {.lex_state = 407, .external_lex_state = 8},
  [1384] = {.lex_state = 407, .external_lex_state = 8},
  [1385] = {.lex_state = 407, .external_lex_state = 8},
  [1386] = {.lex_state = 407, .external_lex_state = 8},
  [1387] = {.lex_state = 407, .external_lex_state = 8},
  [1388] = {.lex_state = 407, .external_lex_state = 8},
  [1389] = {.lex_state = 409},
  [1390] = {.lex_state = 409},
  [1391] = {.lex_state = 409},
  [1392] = {.lex_state = 409},
  [1393] = {.lex_state = 409},
  [1394] = {.lex_state = 409},
  [1395] = {.lex_state = 409},
  [1396] = {.lex_state = 409},
  [1397] = {.lex_state = 409},
  [1398] = {.lex_state = 409},
  [1399] = {.lex_state = 409},
  [1400] = {.lex_state = 409},
  [1401] = {.lex_state = 409},
  [1402] = {.lex_state = 409},
  [1403] = {.lex_state = 409},
  [1404] = {.lex_state = 409},
  [1405] = {.lex_state = 409},
  [1406] = {.lex_state = 409},
  [1407] = {.lex_state = 409},
  [1408] = {.lex_state = 409},
  [1409] = {.lex_state = 409},
  [1410] = {.lex_state = 409},
  [1411] = {.lex_state = 409},
  [1412] = {.lex_state = 409},
  [1413] = {.lex_state = 409},
  [1414] = {.lex_state = 409},
  [1415] = {.lex_state = 409},
  [1416] = {.lex_state = 409},
  [1417] = {.lex_state = 409},
  [1418] = {.lex_state = 409},
  [1419] = {.lex_state = 409},
  [1420] = {.lex_state = 409},
  [1421] = {.lex_state = 409},
  [1422] = {.lex_state = 409},
  [1423] = {.lex_state = 409},
  [1424] = {.lex_state = 407, .external_lex_state = 7},
  [1425] = {.lex_state = 410},
  [1426] = {.lex_state = 406},
  [1427] = {.lex_state = 407, .external_lex_state = 7},
  [1428] = {.lex_state = 410},
  [1429] = {.lex_state = 410},
  [1430] = {.lex_state = 406},
  [1431] = {.lex_state = 407, .external_lex_state = 8},
  [1432] = {.lex_state = 410},
  [1433] = {.lex_state = 406},
  [1434] = {.lex_state = 407, .external_lex_state = 7},
  [1435] = {.lex_state = 406},
  [1436] = {.lex_state = 410},
  [1437] = {.lex_state = 407, .external_lex_state = 7},
  [1438] = {.lex_state = 406},
  [1439] = {.lex_state = 410},
  [1440] = {.lex_state = 410},
  [1441] = {.lex_state = 407, .external_lex_state = 7},
  [1442] = {.lex_state = 407, .external_lex_state = 7},
  [1443] = {.lex_state = 407, .external_lex_state = 7},
  [1444] = {.lex_state = 406},
  [1445] = {.lex_state = 407, .external_lex_state = 7},
  [1446] = {.lex_state = 407, .external_lex_state = 7},
  [1447] = {.lex_state = 407, .external_lex_state = 7},
  [1448] = {.lex_state = 406},
  [1449] = {.lex_state = 407, .external_lex_state = 7},
  [1450] = {.lex_state = 407, .external_lex_state = 7},
  [1451] = {.lex_state = 410},
  [1452] = {.lex_state = 406},
  [1453] = {.lex_state = 406},
  [1454] = {.lex_state = 410},
  [1455] = {.lex_state = 406},
  [1456] = {.lex_state = 410},
  [1457] = {.lex_state = 406},
  [1458] = {.lex_state = 406},
  [1459] = {.lex_state = 406},
  [1460] = {.lex_state = 410},
  [1461] = {.lex_state = 406},
  [1462] = {.lex_state = 406},
  [1463] = {.lex_state = 407, .external_lex_state = 7},
  [1464] = {.lex_state = 406},
  [1465] = {.lex_state = 406},
  [1466] = {.lex_state = 406},
  [1467] = {.lex_state = 407, .external_lex_state = 7},
  [1468] = {.lex_state = 407, .external_lex_state = 7},
  [1469] = {.lex_state = 410},
  [1470] = {.lex_state = 407, .external_lex_state = 7},
  [1471] = {.lex_state = 407, .external_lex_state = 8},
  [1472] = {.lex_state = 407, .external_lex_state = 7},
  [1473] = {.lex_state = 410},
  [1474] = {.lex_state = 407, .external_lex_state = 7},
  [1475] = {.lex_state = 407, .external_lex_state = 7},
  [1476] = {.lex_state = 407, .external_lex_state = 7},
  [1477] = {.lex_state = 406},
  [1478] = {.lex_state = 407, .external_lex_state = 7},
  [1479] = {.lex_state = 406},
  [1480] = {.lex_state = 406},
  [1481] = {.lex_state = 406},
  [1482] = {.lex_state = 406},
  [1483] = {.lex_state = 407, .external_lex_state = 7},
  [1484] = {.lex_state = 406},
  [1485] = {.lex_state = 406},
  [1486] = {.lex_state = 406},
  [1487] = {.lex_state = 407, .external_lex_state = 7},
  [1488] = {.lex_state = 407, .external_lex_state = 7},
  [1489] = {.lex_state = 406},
  [1490] = {.lex_state = 410},
  [1491] = {.lex_state = 410},
  [1492] = {.lex_state = 407, .external_lex_state = 7},
  [1493] = {.lex_state = 407, .external_lex_state = 7},
  [1494] = {.lex_state = 407, .external_lex_state = 7},
  [1495] = {.lex_state = 407, .external_lex_state = 7},
  [1496] = {.lex_state = 406},
  [1497] = {.lex_state = 407, .external_lex_state = 7},
  [1498] = {.lex_state = 410},
  [1499] = {.lex_state = 406},
  [1500] = {.lex_state = 406},
  [1501] = {.lex_state = 407, .external_lex_state = 7},
  [1502] = {.lex_state = 411},
  [1503] = {.lex_state = 442},
  [1504] = {.lex_state = 442},
  [1505] = {.lex_state = 442},
  [1506] = {.lex_state = 442},
  [1507] = {.lex_state = 442},
  [1508] = {.lex_state = 442},
  [1509] = {.lex_state = 442},
  [1510] = {.lex_state = 442},
  [1511] = {.lex_state = 442},
  [1512] = {.lex_state = 442},
  [1513] = {.lex_state = 442},
  [1514] = {.lex_state = 406},
  [1515] = {.lex_state = 442},
  [1516] = {.lex_state = 442},
  [1517] = {.lex_state = 442},
  [1518] = {.lex_state = 442},
  [1519] = {.lex_state = 442},
  [1520] = {.lex_state = 442},
  [1521] = {.lex_state = 442},
  [1522] = {.lex_state = 406},
  [1523] = {.lex_state = 410},
  [1524] = {.lex_state = 442},
  [1525] = {.lex_state = 442},
  [1526] = {.lex_state = 442},
  [1527] = {.lex_state = 442},
  [1528] = {.lex_state = 442},
  [1529] = {.lex_state = 442},
  [1530] = {.lex_state = 442},
  [1531] = {.lex_state = 406},
  [1532] = {.lex_state = 406},
  [1533] = {.lex_state = 410},
  [1534] = {.lex_state = 406},
  [1535] = {.lex_state = 406},
  [1536] = {.lex_state = 442},
  [1537] = {.lex_state = 442},
  [1538] = {.lex_state = 442},
  [1539] = {.lex_state = 406},
  [1540] = {.lex_state = 442},
  [1541] = {.lex_state = 442},
  [1542] = {.lex_state = 406},
  [1543] = {.lex_state = 411},
  [1544] = {.lex_state = 411},
  [1545] = {.lex_state = 411},
  [1546] = {.lex_state = 406},
  [1547] = {.lex_state = 411},
  [1548] = {.lex_state = 411},
  [1549] = {.lex_state = 411},
  [1550] = {.lex_state = 411},
  [1551] = {.lex_state = 411},
  [1552] = {.lex_state = 411},
  [1553] = {.lex_state = 411},
  [1554] = {.lex_state = 411},
  [1555] = {.lex_state = 411},
  [1556] = {.lex_state = 411},
  [1557] = {.lex_state = 411},
  [1558] = {.lex_state = 410},
  [1559] = {.lex_state = 411},
  [1560] = {.lex_state = 407, .external_lex_state = 7},
  [1561] = {.lex_state = 411},
  [1562] = {.lex_state = 411},
  [1563] = {.lex_state = 411},
  [1564] = {.lex_state = 411},
  [1565] = {.lex_state = 411},
  [1566] = {.lex_state = 411},
  [1567] = {.lex_state = 411},
  [1568] = {.lex_state = 406},
  [1569] = {.lex_state = 411},
  [1570] = {.lex_state = 406},
  [1571] = {.lex_state = 411},
  [1572] = {.lex_state = 406},
  [1573] = {.lex_state = 411},
  [1574] = {.lex_state = 411},
  [1575] = {.lex_state = 411},
  [1576] = {.lex_state = 411},
  [1577] = {.lex_state = 411},
  [1578] = {.lex_state = 406},
  [1579] = {.lex_state = 410},
  [1580] = {.lex_state = 410},
  [1581] = {.lex_state = 410},
  [1582] = {.lex_state = 410},
  [1583] = {.lex_state = 410},
  [1584] = {.lex_state = 406},
  [1585] = {.lex_state = 406},
  [1586] = {.lex_state = 406},
  [1587] = {.lex_state = 407, .external_lex_state = 9},
  [1588] = {.lex_state = 407, .external_lex_state = 10},
  [1589] = {.lex_state = 407, .external_lex_state = 10},
  [1590] = {.lex_state = 407, .external_lex_state = 10},
  [1591] = {.lex_state = 407, .external_lex_state = 10},
  [1592] = {.lex_state = 407, .external_lex_state = 10},
  [1593] = {.lex_state = 407, .external_lex_state = 10},
  [1594] = {.lex_state = 407, .external_lex_state = 10},
  [1595] = {.lex_state = 407, .external_lex_state = 10},
  [1596] = {.lex_state = 407, .external_lex_state = 10},
  [1597] = {.lex_state = 407, .external_lex_state = 10},
  [1598] = {.lex_state = 407, .external_lex_state = 10},
  [1599] = {.lex_state = 407, .external_lex_state = 10},
  [1600] = {.lex_state = 407, .external_lex_state = 10},
  [1601] = {.lex_state = 407, .external_lex_state = 10},
  [1602] = {.lex_state = 407, .external_lex_state = 10},
  [1603] = {.lex_state = 407, .external_lex_state = 10},
  [1604] = {.lex_state = 407, .external_lex_state = 10},
  [1605] = {.lex_state = 407},
  [1606] = {.lex_state = 407, .external_lex_state = 10},
  [1607] = {.lex_state = 407, .external_lex_state = 10},
  [1608] = {.lex_state = 407, .external_lex_state = 10},
  [1609] = {.lex_state = 407, .external_lex_state = 10},
  [1610] = {.lex_state = 407, .external_lex_state = 10},
  [1611] = {.lex_state = 407, .external_lex_state = 10},
  [1612] = {.lex_state = 407},
  [1613] = {.lex_state = 407},
  [1614] = {.lex_state = 407, .external_lex_state = 7},
  [1615] = {.lex_state = 407},
  [1616] = {.lex_state = 407, .external_lex_state = 10},
  [1617] = {.lex_state = 407, .external_lex_state = 10},
  [1618] = {.lex_state = 407},
  [1619] = {.lex_state = 407},
  [1620] = {.lex_state = 407, .external_lex_state = 10},
  [1621] = {.lex_state = 407, .external_lex_state = 10},
  [1622] = {.lex_state = 407},
  [1623] = {.lex_state = 407},
  [1624] = {.lex_state = 407},
  [1625] = {.lex_state = 407, .external_lex_state = 10},
  [1626] = {.lex_state = 407, .external_lex_state = 10},
  [1627] = {.lex_state = 407, .external_lex_state = 10},
  [1628] = {.lex_state = 406},
  [1629] = {.lex_state = 407, .external_lex_state = 9},
  [1630] = {.lex_state = 407, .external_lex_state = 9},
  [1631] = {.lex_state = 407, .external_lex_state = 9},
  [1632] = {.lex_state = 407, .external_lex_state = 9},
  [1633] = {.lex_state = 407, .external_lex_state = 9},
  [1634] = {.lex_state = 407},
  [1635] = {.lex_state = 407, .external_lex_state = 9},
  [1636] = {.lex_state = 407},
  [1637] = {.lex_state = 407, .external_lex_state = 9},
  [1638] = {.lex_state = 407, .external_lex_state = 9},
  [1639] = {.lex_state = 407, .external_lex_state = 9},
  [1640] = {.lex_state = 407, .external_lex_state = 9},
  [1641] = {.lex_state = 407, .external_lex_state = 9},
  [1642] = {.lex_state = 407, .external_lex_state = 9},
  [1643] = {.lex_state = 407, .external_lex_state = 9},
  [1644] = {.lex_state = 407},
  [1645] = {.lex_state = 407, .external_lex_state = 9},
  [1646] = {.lex_state = 407, .external_lex_state = 9},
  [1647] = {.lex_state = 407, .external_lex_state = 9},
  [1648] = {.lex_state = 407, .external_lex_state = 9},
  [1649] = {.lex_state = 407, .external_lex_state = 9},
  [1650] = {.lex_state = 406},
  [1651] = {.lex_state = 407, .external_lex_state = 9},
  [1652] = {.lex_state = 407, .external_lex_state = 9},
  [1653] = {.lex_state = 407, .external_lex_state = 9},
  [1654] = {.lex_state = 407, .external_lex_state = 9},
  [1655] = {.lex_state = 407},
  [1656] = {.lex_state = 407, .external_lex_state = 9},
  [1657] = {.lex_state = 407, .external_lex_state = 9},
  [1658] = {.lex_state = 407, .external_lex_state = 9},
  [1659] = {.lex_state = 407, .external_lex_state = 9},
  [1660] = {.lex_state = 407, .external_lex_state = 9},
  [1661] = {.lex_state = 407, .external_lex_state = 9},
  [1662] = {.lex_state = 407, .external_lex_state = 9},
  [1663] = {.lex_state = 406},
  [1664] = {.lex_state = 406},
  [1665] = {.lex_state = 406},
  [1666] = {.lex_state = 406},
  [1667] = {.lex_state = 406},
  [1668] = {.lex_state = 406},
  [1669] = {.lex_state = 406},
  [1670] = {.lex_state = 407},
  [1671] = {.lex_state = 406},
  [1672] = {.lex_state = 406},
  [1673] = {.lex_state = 406},
  [1674] = {.lex_state = 406},
  [1675] = {.lex_state = 406},
  [1676] = {.lex_state = 406},
  [1677] = {.lex_state = 406},
  [1678] = {.lex_state = 407},
  [1679] = {.lex_state = 406},
  [1680] = {.lex_state = 406},
  [1681] = {.lex_state = 406},
  [1682] = {.lex_state = 406},
  [1683] = {.lex_state = 406},
  [1684] = {.lex_state = 406},
  [1685] = {.lex_state = 406},
  [1686] = {.lex_state = 406},
  [1687] = {.lex_state = 406},
  [1688] = {.lex_state = 406},
  [1689] = {.lex_state = 407},
  [1690] = {.lex_state = 406},
  [1691] = {.lex_state = 407},
  [1692] = {.lex_state = 406},
  [1693] = {.lex_state = 407},
  [1694] = {.lex_state = 406},
  [1695] = {.lex_state = 406},
  [1696] = {.lex_state = 442},
  [1697] = {.lex_state = 406},
  [1698] = {.lex_state = 407},
  [1699] = {.lex_state = 407},
  [1700] = {.lex_state = 407},
  [1701] = {.lex_state = 407},
  [1702] = {.lex_state = 407},
  [1703] = {.lex_state = 407},
  [1704] = {.lex_state = 407},
  [1705] = {.lex_state = 407},
  [1706] = {.lex_state = 407},
  [1707] = {.lex_state = 406},
  [1708] = {.lex_state = 406},
  [1709] = {.lex_state = 407},
  [1710] = {.lex_state = 407},
  [1711] = {.lex_state = 407},
  [1712] = {.lex_state = 406},
  [1713] = {.lex_state = 406},
  [1714] = {.lex_state = 406},
  [1715] = {.lex_state = 407},
  [1716] = {.lex_state = 407},
  [1717] = {.lex_state = 407},
  [1718] = {.lex_state = 406},
  [1719] = {.lex_state = 407},
  [1720] = {.lex_state = 407},
  [1721] = {.lex_state = 407},
  [1722] = {.lex_state = 407, .external_lex_state = 7},
  [1723] = {.lex_state = 407},
  [1724] = {.lex_state = 407},
  [1725] = {.lex_state = 407},
  [1726] = {.lex_state = 407},
  [1727] = {.lex_state = 411},
  [1728] = {.lex_state = 406},
  [1729] = {.lex_state = 407},
  [1730] = {.lex_state = 407},
  [1731] = {.lex_state = 407},
  [1732] = {.lex_state = 407},
  [1733] = {.lex_state = 407},
  [1734] = {.lex_state = 411},
  [1735] = {.lex_state = 407},
  [1736] = {.lex_state = 407},
  [1737] = {.lex_state = 407},
  [1738] = {.lex_state = 407},
  [1739] = {.lex_state = 407},
  [1740] = {.lex_state = 407},
  [1741] = {.lex_state = 407},
  [1742] = {.lex_state = 407},
  [1743] = {.lex_state = 407},
  [1744] = {.lex_state = 406},
  [1745] = {.lex_state = 407},
  [1746] = {.lex_state = 407},
  [1747] = {.lex_state = 407},
  [1748] = {.lex_state = 407},
  [1749] = {.lex_state = 407},
  [1750] = {.lex_state = 407},
  [1751] = {.lex_state = 407},
  [1752] = {.lex_state = 407},
  [1753] = {.lex_state = 407},
  [1754] = {.lex_state = 407},
  [1755] = {.lex_state = 407},
  [1756] = {.lex_state = 407},
  [1757] = {.lex_state = 406},
  [1758] = {.lex_state = 407},
  [1759] = {.lex_state = 407},
  [1760] = {.lex_state = 407},
  [1761] = {.lex_state = 407},
  [1762] = {.lex_state = 406},
  [1763] = {.lex_state = 407},
  [1764] = {.lex_state = 407},
  [1765] = {.lex_state = 406},
  [1766] = {.lex_state = 407},
  [1767] = {.lex_state = 407},
  [1768] = {.lex_state = 407},
  [1769] = {.lex_state = 407},
  [1770] = {.lex_state = 407},
  [1771] = {.lex_state = 407},
  [1772] = {.lex_state = 407},
  [1773] = {.lex_state = 407},
  [1774] = {.lex_state = 407},
  [1775] = {.lex_state = 406},
  [1776] = {.lex_state = 407},
  [1777] = {.lex_state = 406},
  [1778] = {.lex_state = 407},
  [1779] = {.lex_state = 407},
  [1780] = {.lex_state = 406},
  [1781] = {.lex_state = 407},
  [1782] = {.lex_state = 407},
  [1783] = {.lex_state = 406},
  [1784] = {.lex_state = 407, .external_lex_state = 10},
  [1785] = {.lex_state = 407, .external_lex_state = 9},
  [1786] = {.lex_state = 407},
  [1787] = {.lex_state = 407},
  [1788] = {.lex_state = 407},
  [1789] = {.lex_state = 407},
  [1790] = {.lex_state = 407},
  [1791] = {.lex_state = 407},
  [1792] = {.lex_state = 407},
  [1793] = {.lex_state = 407},
  [1794] = {.lex_state = 407},
  [1795] = {.lex_state = 407},
  [1796] = {.lex_state = 407},
  [1797] = {.lex_state = 407, .external_lex_state = 7},
  [1798] = {.lex_state = 407, .external_lex_state = 7},
  [1799] = {.lex_state = 407, .external_lex_state = 7},
  [1800] = {.lex_state = 407, .external_lex_state = 7},
  [1801] = {.lex_state = 407, .external_lex_state = 7},
  [1802] = {.lex_state = 407, .external_lex_state = 7},
  [1803] = {.lex_state = 407},
  [1804] = {.lex_state = 407},
  [1805] = {.lex_state = 407},
  [1806] = {.lex_state = 407},
  [1807] = {.lex_state = 407},
  [1808] = {.lex_state = 407},
  [1809] = {.lex_state = 407},
  [1810] = {.lex_state = 407},
  [1811] = {.lex_state = 407},
  [1812] = {.lex_state = 407},
  [1813] = {.lex_state = 407},
  [1814] = {.lex_state = 407},
  [1815] = {.lex_state = 407},
  [1816] = {.lex_state = 407},
  [1817] = {.lex_state = 407},
  [1818] = {.lex_state = 407},
  [1819] = {.lex_state = 407},
  [1820] = {.lex_state = 407},
  [1821] = {.lex_state = 407},
  [1822] = {.lex_state = 407},
  [1823] = {.lex_state = 407},
  [1824] = {.lex_state = 407},
  [1825] = {.lex_state = 407},
  [1826] = {.lex_state = 407},
  [1827] = {.lex_state = 407},
  [1828] = {.lex_state = 407},
  [1829] = {.lex_state = 407},
  [1830] = {.lex_state = 407},
  [1831] = {.lex_state = 407},
  [1832] = {.lex_state = 407},
  [1833] = {.lex_state = 407},
  [1834] = {.lex_state = 407},
  [1835] = {.lex_state = 407},
  [1836] = {.lex_state = 407},
  [1837] = {.lex_state = 407},
  [1838] = {.lex_state = 407},
  [1839] = {.lex_state = 407},
  [1840] = {.lex_state = 407},
  [1841] = {.lex_state = 407},
  [1842] = {.lex_state = 407},
  [1843] = {.lex_state = 407},
  [1844] = {.lex_state = 407},
  [1845] = {.lex_state = 407},
  [1846] = {.lex_state = 407},
  [1847] = {.lex_state = 407},
  [1848] = {.lex_state = 407},
  [1849] = {.lex_state = 407},
  [1850] = {.lex_state = 407},
  [1851] = {.lex_state = 407},
  [1852] = {.lex_state = 407},
  [1853] = {.lex_state = 407},
  [1854] = {.lex_state = 407},
  [1855] = {.lex_state = 407},
  [1856] = {.lex_state = 407},
  [1857] = {.lex_state = 407},
  [1858] = {.lex_state = 407},
  [1859] = {.lex_state = 407},
  [1860] = {.lex_state = 407},
  [1861] = {.lex_state = 407},
  [1862] = {.lex_state = 407},
  [1863] = {.lex_state = 407},
  [1864] = {.lex_state = 407},
  [1865] = {.lex_state = 407},
  [1866] = {.lex_state = 407},
  [1867] = {.lex_state = 407},
  [1868] = {.lex_state = 407},
  [1869] = {.lex_state = 407},
  [1870] = {.lex_state = 407},
  [1871] = {.lex_state = 407},
  [1872] = {.lex_state = 407},
  [1873] = {.lex_state = 407},
  [1874] = {.lex_state = 407},
  [1875] = {.lex_state = 407},
  [1876] = {.lex_state = 407},
  [1877] = {.lex_state = 407},
  [1878] = {.lex_state = 407},
  [1879] = {.lex_state = 407},
  [1880] = {.lex_state = 407},
  [1881] = {.lex_state = 407},
  [1882] = {.lex_state = 407},
  [1883] = {.lex_state = 407},
  [1884] = {.lex_state = 407},
  [1885] = {.lex_state = 407},
  [1886] = {.lex_state = 407},
  [1887] = {.lex_state = 407},
  [1888] = {.lex_state = 407},
  [1889] = {.lex_state = 407},
  [1890] = {.lex_state = 407},
  [1891] = {.lex_state = 407},
  [1892] = {.lex_state = 407},
  [1893] = {.lex_state = 407},
  [1894] = {.lex_state = 407},
  [1895] = {.lex_state = 407},
  [1896] = {.lex_state = 407},
  [1897] = {.lex_state = 407},
  [1898] = {.lex_state = 407},
  [1899] = {.lex_state = 407},
  [1900] = {.lex_state = 407},
  [1901] = {.lex_state = 407},
  [1902] = {.lex_state = 407},
  [1903] = {.lex_state = 407},
  [1904] = {.lex_state = 407},
  [1905] = {.lex_state = 407},
  [1906] = {.lex_state = 407},
  [1907] = {.lex_state = 407},
  [1908] = {.lex_state = 407},
  [1909] = {.lex_state = 407},
  [1910] = {.lex_state = 407},
  [1911] = {.lex_state = 407},
  [1912] = {.lex_state = 407},
  [1913] = {.lex_state = 407},
  [1914] = {.lex_state = 407},
  [1915] = {.lex_state = 407},
  [1916] = {.lex_state = 407},
  [1917] = {.lex_state = 407},
  [1918] = {.lex_state = 407},
  [1919] = {.lex_state = 407},
  [1920] = {.lex_state = 407},
  [1921] = {.lex_state = 407},
  [1922] = {.lex_state = 407},
  [1923] = {.lex_state = 407},
  [1924] = {.lex_state = 407},
  [1925] = {.lex_state = 407},
  [1926] = {.lex_state = 407},
  [1927] = {.lex_state = 407},
  [1928] = {.lex_state = 407},
  [1929] = {.lex_state = 407},
  [1930] = {.lex_state = 407},
  [1931] = {.lex_state = 407},
  [1932] = {.lex_state = 407},
  [1933] = {.lex_state = 407},
  [1934] = {.lex_state = 407},
  [1935] = {.lex_state = 407},
  [1936] = {.lex_state = 407},
  [1937] = {.lex_state = 407},
  [1938] = {.lex_state = 407},
  [1939] = {.lex_state = 407},
  [1940] = {.lex_state = 407},
  [1941] = {.lex_state = 407},
  [1942] = {.lex_state = 407},
  [1943] = {.lex_state = 407},
  [1944] = {.lex_state = 407},
  [1945] = {.lex_state = 407},
  [1946] = {.lex_state = 407},
  [1947] = {.lex_state = 407},
  [1948] = {.lex_state = 407},
  [1949] = {.lex_state = 407},
  [1950] = {.lex_state = 407},
  [1951] = {.lex_state = 407},
  [1952] = {.lex_state = 407},
  [1953] = {.lex_state = 407},
  [1954] = {.lex_state = 407},
  [1955] = {.lex_state = 407},
  [1956] = {.lex_state = 407},
  [1957] = {.lex_state = 407},
  [1958] = {.lex_state = 407},
  [1959] = {.lex_state = 407},
  [1960] = {.lex_state = 407},
  [1961] = {.lex_state = 407},
  [1962] = {.lex_state = 407},
  [1963] = {.lex_state = 407},
  [1964] = {.lex_state = 407},
  [1965] = {.lex_state = 407},
  [1966] = {.lex_state = 407},
  [1967] = {.lex_state = 407},
  [1968] = {.lex_state = 407},
  [1969] = {.lex_state = 407},
  [1970] = {.lex_state = 407},
  [1971] = {.lex_state = 407},
  [1972] = {.lex_state = 407},
  [1973] = {.lex_state = 407},
  [1974] = {.lex_state = 407},
  [1975] = {.lex_state = 407},
  [1976] = {.lex_state = 407},
  [1977] = {.lex_state = 407},
  [1978] = {.lex_state = 407},
  [1979] = {.lex_state = 407},
  [1980] = {.lex_state = 407},
  [1981] = {.lex_state = 407},
  [1982] = {.lex_state = 407},
  [1983] = {.lex_state = 407},
  [1984] = {.lex_state = 407},
  [1985] = {.lex_state = 407},
  [1986] = {.lex_state = 407},
  [1987] = {.lex_state = 407},
  [1988] = {.lex_state = 407},
  [1989] = {.lex_state = 407, .external_lex_state = 7},
  [1990] = {.lex_state = 407},
  [1991] = {.lex_state = 407},
  [1992] = {.lex_state = 407},
  [1993] = {.lex_state = 407},
  [1994] = {.lex_state = 407},
  [1995] = {.lex_state = 407},
  [1996] = {.lex_state = 391, .external_lex_state = 4},
  [1997] = {.lex_state = 391, .external_lex_state = 4},
  [1998] = {.lex_state = 391, .external_lex_state = 4},
  [1999] = {.lex_state = 391, .external_lex_state = 4},
  [2000] = {.lex_state = 391, .external_lex_state = 4},
  [2001] = {.lex_state = 391, .external_lex_state = 4},
  [2002] = {.lex_state = 391, .external_lex_state = 4},
  [2003] = {.lex_state = 391, .external_lex_state = 4},
  [2004] = {.lex_state = 391, .external_lex_state = 4},
  [2005] = {.lex_state = 412},
  [2006] = {.lex_state = 412},
  [2007] = {.lex_state = 412},
  [2008] = {.lex_state = 413},
  [2009] = {.lex_state = 413},
  [2010] = {.lex_state = 413},
  [2011] = {.lex_state = 413},
  [2012] = {.lex_state = 414, .external_lex_state = 6},
  [2013] = {.lex_state = 390, .external_lex_state = 3},
  [2014] = {.lex_state = 390, .external_lex_state = 4},
  [2015] = {.lex_state = 401, .external_lex_state = 6},
  [2016] = {.lex_state = 414},
  [2017] = {.lex_state = 441},
  [2018] = {.lex_state = 401, .external_lex_state = 6},
  [2019] = {.lex_state = 401, .external_lex_state = 6},
  [2020] = {.lex_state = 401, .external_lex_state = 6},
  [2021] = {.lex_state = 401, .external_lex_state = 6},
  [2022] = {.lex_state = 401},
  [2023] = {.lex_state = 401, .external_lex_state = 6},
  [2024] = {.lex_state = 401, .external_lex_state = 6},
  [2025] = {.lex_state = 401, .external_lex_state = 6},
  [2026] = {.lex_state = 401, .external_lex_state = 6},
  [2027] = {.lex_state = 401, .external_lex_state = 6},
  [2028] = {.lex_state = 401, .external_lex_state = 6},
  [2029] = {.lex_state = 401, .external_lex_state = 6},
  [2030] = {.lex_state = 401, .external_lex_state = 6},
  [2031] = {.lex_state = 401, .external_lex_state = 6},
  [2032] = {.lex_state = 401, .external_lex_state = 6},
  [2033] = {.lex_state = 401, .external_lex_state = 6},
  [2034] = {.lex_state = 441},
  [2035] = {.lex_state = 397, .external_lex_state = 4},
  [2036] = {.lex_state = 401, .external_lex_state = 6},
  [2037] = {.lex_state = 401, .external_lex_state = 6},
  [2038] = {.lex_state = 401, .external_lex_state = 6},
  [2039] = {.lex_state = 401, .external_lex_state = 6},
  [2040] = {.lex_state = 401, .external_lex_state = 6},
  [2041] = {.lex_state = 396, .external_lex_state = 4},
  [2042] = {.lex_state = 401, .external_lex_state = 6},
  [2043] = {.lex_state = 401, .external_lex_state = 6},
  [2044] = {.lex_state = 401, .external_lex_state = 6},
  [2045] = {.lex_state = 401, .external_lex_state = 6},
  [2046] = {.lex_state = 401, .external_lex_state = 6},
  [2047] = {.lex_state = 441},
  [2048] = {.lex_state = 401, .external_lex_state = 6},
  [2049] = {.lex_state = 401, .external_lex_state = 6},
  [2050] = {.lex_state = 401, .external_lex_state = 6},
  [2051] = {.lex_state = 401, .external_lex_state = 6},
  [2052] = {.lex_state = 401, .external_lex_state = 6},
  [2053] = {.lex_state = 401, .external_lex_state = 6},
  [2054] = {.lex_state = 401, .external_lex_state = 6},
  [2055] = {.lex_state = 401, .external_lex_state = 6},
  [2056] = {.lex_state = 401, .external_lex_state = 6},
  [2057] = {.lex_state = 401, .external_lex_state = 6},
  [2058] = {.lex_state = 401, .external_lex_state = 6},
  [2059] = {.lex_state = 401, .external_lex_state = 6},
  [2060] = {.lex_state = 401, .external_lex_state = 6},
  [2061] = {.lex_state = 401, .external_lex_state = 6},
  [2062] = {.lex_state = 401, .external_lex_state = 6},
  [2063] = {.lex_state = 401, .external_lex_state = 6},
  [2064] = {.lex_state = 401, .external_lex_state = 6},
  [2065] = {.lex_state = 441},
  [2066] = {.lex_state = 401, .external_lex_state = 6},
  [2067] = {.lex_state = 401, .external_lex_state = 6},
  [2068] = {.lex_state = 401, .external_lex_state = 6},
  [2069] = {.lex_state = 396, .external_lex_state = 4},
  [2070] = {.lex_state = 401, .external_lex_state = 6},
  [2071] = {.lex_state = 396, .external_lex_state = 4},
  [2072] = {.lex_state = 401, .external_lex_state = 6},
  [2073] = {.lex_state = 397, .external_lex_state = 4},
  [2074] = {.lex_state = 396, .external_lex_state = 4},
  [2075] = {.lex_state = 396, .external_lex_state = 4},
  [2076] = {.lex_state = 401, .external_lex_state = 6},
  [2077] = {.lex_state = 397, .external_lex_state = 4},
  [2078] = {.lex_state = 401, .external_lex_state = 6},
  [2079] = {.lex_state = 401, .external_lex_state = 6},
  [2080] = {.lex_state = 401, .external_lex_state = 6},
  [2081] = {.lex_state = 401, .external_lex_state = 6},
  [2082] = {.lex_state = 441},
  [2083] = {.lex_state = 401, .external_lex_state = 6},
  [2084] = {.lex_state = 401, .external_lex_state = 6},
  [2085] = {.lex_state = 397, .external_lex_state = 4},
  [2086] = {.lex_state = 397, .external_lex_state = 4},
  [2087] = {.lex_state = 401, .external_lex_state = 6},
  [2088] = {.lex_state = 396, .external_lex_state = 4},
  [2089] = {.lex_state = 397, .external_lex_state = 4},
  [2090] = {.lex_state = 396, .external_lex_state = 4},
  [2091] = {.lex_state = 401, .external_lex_state = 6},
  [2092] = {.lex_state = 397, .external_lex_state = 4},
  [2093] = {.lex_state = 397, .external_lex_state = 4},
  [2094] = {.lex_state = 401, .external_lex_state = 6},
  [2095] = {.lex_state = 397, .external_lex_state = 4},
  [2096] = {.lex_state = 401, .external_lex_state = 6},
  [2097] = {.lex_state = 396, .external_lex_state = 4},
  [2098] = {.lex_state = 401, .external_lex_state = 6},
  [2099] = {.lex_state = 401, .external_lex_state = 6},
  [2100] = {.lex_state = 401, .external_lex_state = 6},
  [2101] = {.lex_state = 401, .external_lex_state = 6},
  [2102] = {.lex_state = 401, .external_lex_state = 6},
  [2103] = {.lex_state = 441},
  [2104] = {.lex_state = 396, .external_lex_state = 5},
  [2105] = {.lex_state = 396, .external_lex_state = 5},
  [2106] = {.lex_state = 396, .external_lex_state = 5},
  [2107] = {.lex_state = 441},
  [2108] = {.lex_state = 396, .external_lex_state = 5},
  [2109] = {.lex_state = 441},
  [2110] = {.lex_state = 396, .external_lex_state = 5},
  [2111] = {.lex_state = 396, .external_lex_state = 5},
  [2112] = {.lex_state = 396, .external_lex_state = 5},
  [2113] = {.lex_state = 396, .external_lex_state = 5},
  [2114] = {.lex_state = 441},
  [2115] = {.lex_state = 396, .external_lex_state = 5},
  [2116] = {.lex_state = 396, .external_lex_state = 4},
  [2117] = {.lex_state = 441},
  [2118] = {.lex_state = 441},
  [2119] = {.lex_state = 441},
  [2120] = {.lex_state = 441},
  [2121] = {.lex_state = 396, .external_lex_state = 5},
  [2122] = {.lex_state = 441},
  [2123] = {.lex_state = 441},
  [2124] = {.lex_state = 441},
  [2125] = {.lex_state = 441},
  [2126] = {.lex_state = 441},
  [2127] = {.lex_state = 441},
  [2128] = {.lex_state = 441},
  [2129] = {.lex_state = 441},
  [2130] = {.lex_state = 441},
  [2131] = {.lex_state = 441},
  [2132] = {.lex_state = 401},
  [2133] = {.lex_state = 441},
  [2134] = {.lex_state = 441},
  [2135] = {.lex_state = 441},
  [2136] = {.lex_state = 441},
  [2137] = {.lex_state = 441},
  [2138] = {.lex_state = 441},
  [2139] = {.lex_state = 441},
  [2140] = {.lex_state = 441},
  [2141] = {.lex_state = 441},
  [2142] = {.lex_state = 441},
  [2143] = {.lex_state = 441},
  [2144] = {.lex_state = 401},
  [2145] = {.lex_state = 441},
  [2146] = {.lex_state = 441},
  [2147] = {.lex_state = 441},
  [2148] = {.lex_state = 441},
  [2149] = {.lex_state = 441},
  [2150] = {.lex_state = 441},
  [2151] = {.lex_state = 441},
  [2152] = {.lex_state = 441},
  [2153] = {.lex_state = 441},
  [2154] = {.lex_state = 441},
  [2155] = {.lex_state = 441},
  [2156] = {.lex_state = 441},
  [2157] = {.lex_state = 441},
  [2158] = {.lex_state = 441},
  [2159] = {.lex_state = 399, .external_lex_state = 4},
  [2160] = {.lex_state = 441},
  [2161] = {.lex_state = 441},
  [2162] = {.lex_state = 441},
  [2163] = {.lex_state = 401},
  [2164] = {.lex_state = 441},
  [2165] = {.lex_state = 441},
  [2166] = {.lex_state = 441},
  [2167] = {.lex_state = 441},
  [2168] = {.lex_state = 441},
  [2169] = {.lex_state = 401},
  [2170] = {.lex_state = 441},
  [2171] = {.lex_state = 441},
  [2172] = {.lex_state = 441},
  [2173] = {.lex_state = 441},
  [2174] = {.lex_state = 441},
  [2175] = {.lex_state = 441},
  [2176] = {.lex_state = 441},
  [2177] = {.lex_state = 441},
  [2178] = {.lex_state = 401},
  [2179] = {.lex_state = 401},
  [2180] = {.lex_state = 401},
  [2181] = {.lex_state = 440, .external_lex_state = 4},
  [2182] = {.lex_state = 400, .external_lex_state = 4},
  [2183] = {.lex_state = 401},
  [2184] = {.lex_state = 401},
  [2185] = {.lex_state = 401},
  [2186] = {.lex_state = 400, .external_lex_state = 4},
  [2187] = {.lex_state = 395, .external_lex_state = 4},
  [2188] = {.lex_state = 401},
  [2189] = {.lex_state = 401},
  [2190] = {.lex_state = 401},
  [2191] = {.lex_state = 398, .external_lex_state = 4},
  [2192] = {.lex_state = 396, .external_lex_state = 4},
  [2193] = {.lex_state = 401},
  [2194] = {.lex_state = 396, .external_lex_state = 4},
  [2195] = {.lex_state = 401},
  [2196] = {.lex_state = 396, .external_lex_state = 4},
  [2197] = {.lex_state = 401},
  [2198] = {.lex_state = 401},
  [2199] = {.lex_state = 401},
  [2200] = {.lex_state = 396, .external_lex_state = 4},
  [2201] = {.lex_state = 396, .external_lex_state = 4},
  [2202] = {.lex_state = 396, .external_lex_state = 4},
  [2203] = {.lex_state = 401},
  [2204] = {.lex_state = 401},
  [2205] = {.lex_state = 396, .external_lex_state = 4},
  [2206] = {.lex_state = 396, .external_lex_state = 4},
  [2207] = {.lex_state = 396, .external_lex_state = 4},
  [2208] = {.lex_state = 401},
  [2209] = {.lex_state = 396, .external_lex_state = 4},
  [2210] = {.lex_state = 396, .external_lex_state = 4},
  [2211] = {.lex_state = 401},
  [2212] = {.lex_state = 396, .external_lex_state = 4},
  [2213] = {.lex_state = 401},
  [2214] = {.lex_state = 396, .external_lex_state = 4},
  [2215] = {.lex_state = 401},
  [2216] = {.lex_state = 396, .external_lex_state = 4},
  [2217] = {.lex_state = 396, .external_lex_state = 4},
  [2218] = {.lex_state = 396, .external_lex_state = 4},
  [2219] = {.lex_state = 396, .external_lex_state = 4},
  [2220] = {.lex_state = 396, .external_lex_state = 4},
  [2221] = {.lex_state = 401},
  [2222] = {.lex_state = 401},
  [2223] = {.lex_state = 401},
  [2224] = {.lex_state = 401},
  [2225] = {.lex_state = 401},
  [2226] = {.lex_state = 396, .external_lex_state = 4},
  [2227] = {.lex_state = 396, .external_lex_state = 4},
  [2228] = {.lex_state = 396, .external_lex_state = 4},
  [2229] = {.lex_state = 396, .external_lex_state = 4},
  [2230] = {.lex_state = 401},
  [2231] = {.lex_state = 401},
  [2232] = {.lex_state = 396, .external_lex_state = 4},
  [2233] = {.lex_state = 396, .external_lex_state = 4},
  [2234] = {.lex_state = 396, .external_lex_state = 4},
  [2235] = {.lex_state = 396, .external_lex_state = 4},
  [2236] = {.lex_state = 396, .external_lex_state = 4},
  [2237] = {.lex_state = 396, .external_lex_state = 4},
  [2238] = {.lex_state = 396, .external_lex_state = 4},
  [2239] = {.lex_state = 396, .external_lex_state = 4},
  [2240] = {.lex_state = 396, .external_lex_state = 4},
  [2241] = {.lex_state = 396, .external_lex_state = 4},
  [2242] = {.lex_state = 401},
  [2243] = {.lex_state = 401},
  [2244] = {.lex_state = 401},
  [2245] = {.lex_state = 401},
  [2246] = {.lex_state = 401},
  [2247] = {.lex_state = 396, .external_lex_state = 4},
  [2248] = {.lex_state = 396, .external_lex_state = 4},
  [2249] = {.lex_state = 401},
  [2250] = {.lex_state = 396, .external_lex_state = 4},
  [2251] = {.lex_state = 396, .external_lex_state = 4},
  [2252] = {.lex_state = 396, .external_lex_state = 4},
  [2253] = {.lex_state = 396, .external_lex_state = 4},
  [2254] = {.lex_state = 396, .external_lex_state = 4},
  [2255] = {.lex_state = 401},
  [2256] = {.lex_state = 396, .external_lex_state = 4},
  [2257] = {.lex_state = 396, .external_lex_state = 4},
  [2258] = {.lex_state = 396, .external_lex_state = 4},
  [2259] = {.lex_state = 396, .external_lex_state = 4},
  [2260] = {.lex_state = 396, .external_lex_state = 4},
  [2261] = {.lex_state = 396, .external_lex_state = 4},
  [2262] = {.lex_state = 396, .external_lex_state = 4},
  [2263] = {.lex_state = 396, .external_lex_state = 4},
  [2264] = {.lex_state = 401},
  [2265] = {.lex_state = 401},
  [2266] = {.lex_state = 396, .external_lex_state = 4},
  [2267] = {.lex_state = 396, .external_lex_state = 4},
  [2268] = {.lex_state = 396, .external_lex_state = 4},
  [2269] = {.lex_state = 396, .external_lex_state = 4},
  [2270] = {.lex_state = 396, .external_lex_state = 4},
  [2271] = {.lex_state = 396, .external_lex_state = 4},
  [2272] = {.lex_state = 396, .external_lex_state = 4},
  [2273] = {.lex_state = 396, .external_lex_state = 4},
  [2274] = {.lex_state = 396, .external_lex_state = 4},
  [2275] = {.lex_state = 396, .external_lex_state = 4},
  [2276] = {.lex_state = 401},
  [2277] = {.lex_state = 396, .external_lex_state = 4},
  [2278] = {.lex_state = 396, .external_lex_state = 4},
  [2279] = {.lex_state = 401},
  [2280] = {.lex_state = 396, .external_lex_state = 4},
  [2281] = {.lex_state = 401},
  [2282] = {.lex_state = 401},
  [2283] = {.lex_state = 401},
  [2284] = {.lex_state = 401},
  [2285] = {.lex_state = 401},
  [2286] = {.lex_state = 396, .external_lex_state = 4},
  [2287] = {.lex_state = 396, .external_lex_state = 4},
  [2288] = {.lex_state = 401},
  [2289] = {.lex_state = 401},
  [2290] = {.lex_state = 401},
  [2291] = {.lex_state = 396, .external_lex_state = 4},
  [2292] = {.lex_state = 401},
  [2293] = {.lex_state = 401},
  [2294] = {.lex_state = 401},
  [2295] = {.lex_state = 396, .external_lex_state = 4},
  [2296] = {.lex_state = 396, .external_lex_state = 4},
  [2297] = {.lex_state = 401},
  [2298] = {.lex_state = 401},
  [2299] = {.lex_state = 401},
  [2300] = {.lex_state = 401},
  [2301] = {.lex_state = 401},
  [2302] = {.lex_state = 401},
  [2303] = {.lex_state = 401},
  [2304] = {.lex_state = 401},
  [2305] = {.lex_state = 396, .external_lex_state = 4},
  [2306] = {.lex_state = 396, .external_lex_state = 4},
  [2307] = {.lex_state = 396, .external_lex_state = 4},
  [2308] = {.lex_state = 396, .external_lex_state = 4},
  [2309] = {.lex_state = 396, .external_lex_state = 4},
  [2310] = {.lex_state = 396, .external_lex_state = 4},
  [2311] = {.lex_state = 396, .external_lex_state = 4},
  [2312] = {.lex_state = 401},
  [2313] = {.lex_state = 401},
  [2314] = {.lex_state = 404},
  [2315] = {.lex_state = 405, .external_lex_state = 7},
  [2316] = {.lex_state = 404},
  [2317] = {.lex_state = 404},
  [2318] = {.lex_state = 404},
  [2319] = {.lex_state = 404},
  [2320] = {.lex_state = 405, .external_lex_state = 7},
  [2321] = {.lex_state = 404},
  [2322] = {.lex_state = 404},
  [2323] = {.lex_state = 405, .external_lex_state = 7},
  [2324] = {.lex_state = 404},
  [2325] = {.lex_state = 405, .external_lex_state = 7},
  [2326] = {.lex_state = 405, .external_lex_state = 7},
  [2327] = {.lex_state = 404},
  [2328] = {.lex_state = 404},
  [2329] = {.lex_state = 404},
  [2330] = {.lex_state = 404},
  [2331] = {.lex_state = 404},
  [2332] = {.lex_state = 404},
  [2333] = {.lex_state = 404},
  [2334] = {.lex_state = 404},
  [2335] = {.lex_state = 404},
  [2336] = {.lex_state = 404},
  [2337] = {.lex_state = 404},
  [2338] = {.lex_state = 404},
  [2339] = {.lex_state = 404},
  [2340] = {.lex_state = 404},
  [2341] = {.lex_state = 404},
  [2342] = {.lex_state = 404},
  [2343] = {.lex_state = 404},
  [2344] = {.lex_state = 404},
  [2345] = {.lex_state = 404},
  [2346] = {.lex_state = 404},
  [2347] = {.lex_state = 404},
  [2348] = {.lex_state = 404},
  [2349] = {.lex_state = 404},
  [2350] = {.lex_state = 405, .external_lex_state = 7},
  [2351] = {.lex_state = 404},
  [2352] = {.lex_state = 404},
  [2353] = {.lex_state = 404},
  [2354] = {.lex_state = 404},
  [2355] = {.lex_state = 404},
  [2356] = {.lex_state = 404},
  [2357] = {.lex_state = 404},
  [2358] = {.lex_state = 404},
  [2359] = {.lex_state = 404},
  [2360] = {.lex_state = 404},
  [2361] = {.lex_state = 404},
  [2362] = {.lex_state = 404},
  [2363] = {.lex_state = 404},
  [2364] = {.lex_state = 404},
  [2365] = {.lex_state = 404},
  [2366] = {.lex_state = 404},
  [2367] = {.lex_state = 404},
  [2368] = {.lex_state = 405, .external_lex_state = 7},
  [2369] = {.lex_state = 404},
  [2370] = {.lex_state = 404},
  [2371] = {.lex_state = 405, .external_lex_state = 7},
  [2372] = {.lex_state = 405, .external_lex_state = 7},
  [2373] = {.lex_state = 404},
  [2374] = {.lex_state = 405, .external_lex_state = 7},
  [2375] = {.lex_state = 404},
  [2376] = {.lex_state = 404},
  [2377] = {.lex_state = 405, .external_lex_state = 7},
  [2378] = {.lex_state = 404},
  [2379] = {.lex_state = 404},
  [2380] = {.lex_state = 404},
  [2381] = {.lex_state = 405, .external_lex_state = 7},
  [2382] = {.lex_state = 405, .external_lex_state = 7},
  [2383] = {.lex_state = 404},
  [2384] = {.lex_state = 404},
  [2385] = {.lex_state = 404},
  [2386] = {.lex_state = 404},
  [2387] = {.lex_state = 404},
  [2388] = {.lex_state = 404},
  [2389] = {.lex_state = 404},
  [2390] = {.lex_state = 405, .external_lex_state = 7},
  [2391] = {.lex_state = 404},
  [2392] = {.lex_state = 405, .external_lex_state = 7},
  [2393] = {.lex_state = 405, .external_lex_state = 7},
  [2394] = {.lex_state = 405, .external_lex_state = 7},
  [2395] = {.lex_state = 405, .external_lex_state = 7},
  [2396] = {.lex_state = 405, .external_lex_state = 7},
  [2397] = {.lex_state = 405, .external_lex_state = 7},
  [2398] = {.lex_state = 405, .external_lex_state = 7},
  [2399] = {.lex_state = 405, .external_lex_state = 7},
  [2400] = {.lex_state = 405, .external_lex_state = 7},
  [2401] = {.lex_state = 405, .external_lex_state = 7},
  [2402] = {.lex_state = 405, .external_lex_state = 7},
  [2403] = {.lex_state = 405, .external_lex_state = 7},
  [2404] = {.lex_state = 405, .external_lex_state = 7},
  [2405] = {.lex_state = 405, .external_lex_state = 7},
  [2406] = {.lex_state = 405, .external_lex_state = 7},
  [2407] = {.lex_state = 405, .external_lex_state = 7},
  [2408] = {.lex_state = 405, .external_lex_state = 7},
  [2409] = {.lex_state = 405, .external_lex_state = 7},
  [2410] = {.lex_state = 405, .external_lex_state = 7},
  [2411] = {.lex_state = 405, .external_lex_state = 7},
  [2412] = {.lex_state = 405, .external_lex_state = 7},
  [2413] = {.lex_state = 405, .external_lex_state = 7},
  [2414] = {.lex_state = 405, .external_lex_state = 7},
  [2415] = {.lex_state = 405, .external_lex_state = 7},
  [2416] = {.lex_state = 405, .external_lex_state = 7},
  [2417] = {.lex_state = 405, .external_lex_state = 7},
  [2418] = {.lex_state = 405, .external_lex_state = 7},
  [2419] = {.lex_state = 405, .external_lex_state = 7},
  [2420] = {.lex_state = 405, .external_lex_state = 7},
  [2421] = {.lex_state = 405, .external_lex_state = 7},
  [2422] = {.lex_state = 405, .external_lex_state = 7},
  [2423] = {.lex_state = 405, .external_lex_state = 7},
  [2424] = {.lex_state = 405, .external_lex_state = 7},
  [2425] = {.lex_state = 405, .external_lex_state = 7},
  [2426] = {.lex_state = 405, .external_lex_state = 7},
  [2427] = {.lex_state = 405, .external_lex_state = 7},
  [2428] = {.lex_state = 405, .external_lex_state = 7},
  [2429] = {.lex_state = 405, .external_lex_state = 7},
  [2430] = {.lex_state = 405, .external_lex_state = 7},
  [2431] = {.lex_state = 405, .external_lex_state = 7},
  [2432] = {.lex_state = 405, .external_lex_state = 7},
  [2433] = {.lex_state = 405, .external_lex_state = 7},
  [2434] = {.lex_state = 405, .external_lex_state = 7},
  [2435] = {.lex_state = 405, .external_lex_state = 7},
  [2436] = {.lex_state = 405, .external_lex_state = 7},
  [2437] = {.lex_state = 405, .external_lex_state = 7},
  [2438] = {.lex_state = 405, .external_lex_state = 7},
  [2439] = {.lex_state = 405, .external_lex_state = 7},
  [2440] = {.lex_state = 405, .external_lex_state = 7},
  [2441] = {.lex_state = 405, .external_lex_state = 7},
  [2442] = {.lex_state = 415},
  [2443] = {.lex_state = 415},
  [2444] = {.lex_state = 415},
  [2445] = {.lex_state = 415},
  [2446] = {.lex_state = 415},
  [2447] = {.lex_state = 415},
  [2448] = {.lex_state = 415},
  [2449] = {.lex_state = 415},
  [2450] = {.lex_state = 415},
  [2451] = {.lex_state = 415},
  [2452] = {.lex_state = 415},
  [2453] = {.lex_state = 415},
  [2454] = {.lex_state = 415},
  [2455] = {.lex_state = 415},
  [2456] = {.lex_state = 415},
  [2457] = {.lex_state = 415},
  [2458] = {.lex_state = 416},
  [2459] = {.lex_state = 406, .external_lex_state = 8},
  [2460] = {.lex_state = 416, .external_lex_state = 8},
  [2461] = {.lex_state = 406, .external_lex_state = 8},
  [2462] = {.lex_state = 409},
  [2463] = {.lex_state = 406, .external_lex_state = 8},
  [2464] = {.lex_state = 406, .external_lex_state = 8},
  [2465] = {.lex_state = 407},
  [2466] = {.lex_state = 409},
  [2467] = {.lex_state = 407},
  [2468] = {.lex_state = 407},
  [2469] = {.lex_state = 407},
  [2470] = {.lex_state = 406, .external_lex_state = 8},
  [2471] = {.lex_state = 407},
  [2472] = {.lex_state = 406},
  [2473] = {.lex_state = 407},
  [2474] = {.lex_state = 407},
  [2475] = {.lex_state = 406, .external_lex_state = 8},
  [2476] = {.lex_state = 406, .external_lex_state = 8},
  [2477] = {.lex_state = 406, .external_lex_state = 8},
  [2478] = {.lex_state = 407},
  [2479] = {.lex_state = 407},
  [2480] = {.lex_state = 416, .external_lex_state = 7},
  [2481] = {.lex_state = 406, .external_lex_state = 8},
  [2482] = {.lex_state = 407},
  [2483] = {.lex_state = 406, .external_lex_state = 8},
  [2484] = {.lex_state = 406, .external_lex_state = 8},
  [2485] = {.lex_state = 407},
  [2486] = {.lex_state = 407},
  [2487] = {.lex_state = 406, .external_lex_state = 8},
  [2488] = {.lex_state = 406, .external_lex_state = 8},
  [2489] = {.lex_state = 407},
  [2490] = {.lex_state = 406, .external_lex_state = 8},
  [2491] = {.lex_state = 406, .external_lex_state = 8},
  [2492] = {.lex_state = 407},
  [2493] = {.lex_state = 406, .external_lex_state = 8},
  [2494] = {.lex_state = 407, .external_lex_state = 8},
  [2495] = {.lex_state = 406, .external_lex_state = 8},
  [2496] = {.lex_state = 406, .external_lex_state = 8},
  [2497] = {.lex_state = 406, .external_lex_state = 8},
  [2498] = {.lex_state = 406, .external_lex_state = 8},
  [2499] = {.lex_state = 407},
  [2500] = {.lex_state = 406, .external_lex_state = 8},
  [2501] = {.lex_state = 407},
  [2502] = {.lex_state = 407},
  [2503] = {.lex_state = 407},
  [2504] = {.lex_state = 407},
  [2505] = {.lex_state = 406, .external_lex_state = 8},
  [2506] = {.lex_state = 407},
  [2507] = {.lex_state = 406, .external_lex_state = 8},
  [2508] = {.lex_state = 407},
  [2509] = {.lex_state = 406, .external_lex_state = 8},
  [2510] = {.lex_state = 406, .external_lex_state = 8},
  [2511] = {.lex_state = 406, .external_lex_state = 8},
  [2512] = {.lex_state = 442},
  [2513] = {.lex_state = 407},
  [2514] = {.lex_state = 406, .external_lex_state = 8},
  [2515] = {.lex_state = 406, .external_lex_state = 8},
  [2516] = {.lex_state = 406, .external_lex_state = 8},
  [2517] = {.lex_state = 407},
  [2518] = {.lex_state = 407},
  [2519] = {.lex_state = 406, .external_lex_state = 8},
  [2520] = {.lex_state = 406, .external_lex_state = 8},
  [2521] = {.lex_state = 406, .external_lex_state = 8},
  [2522] = {.lex_state = 406, .external_lex_state = 8},
  [2523] = {.lex_state = 407},
  [2524] = {.lex_state = 407},
  [2525] = {.lex_state = 406, .external_lex_state = 8},
  [2526] = {.lex_state = 407},
  [2527] = {.lex_state = 407},
  [2528] = {.lex_state = 407},
  [2529] = {.lex_state = 407, .external_lex_state = 8},
  [2530] = {.lex_state = 406, .external_lex_state = 8},
  [2531] = {.lex_state = 407, .external_lex_state = 8},
  [2532] = {.lex_state = 411},
  [2533] = {.lex_state = 407},
  [2534] = {.lex_state = 406, .external_lex_state = 8},
  [2535] = {.lex_state = 406, .external_lex_state = 8},
  [2536] = {.lex_state = 406, .external_lex_state = 8},
  [2537] = {.lex_state = 406, .external_lex_state = 8},
  [2538] = {.lex_state = 406, .external_lex_state = 8},
  [2539] = {.lex_state = 406, .external_lex_state = 8},
  [2540] = {.lex_state = 406, .external_lex_state = 8},
  [2541] = {.lex_state = 406, .external_lex_state = 8},
  [2542] = {.lex_state = 407},
  [2543] = {.lex_state = 407},
  [2544] = {.lex_state = 406, .external_lex_state = 8},
  [2545] = {.lex_state = 407},
  [2546] = {.lex_state = 407},
  [2547] = {.lex_state = 407},
  [2548] = {.lex_state = 406, .external_lex_state = 8},
  [2549] = {.lex_state = 407, .external_lex_state = 8},
  [2550] = {.lex_state = 407},
  [2551] = {.lex_state = 407},
  [2552] = {.lex_state = 406, .external_lex_state = 8},
  [2553] = {.lex_state = 407},
  [2554] = {.lex_state = 407},
  [2555] = {.lex_state = 407},
  [2556] = {.lex_state = 407},
  [2557] = {.lex_state = 407},
  [2558] = {.lex_state = 407},
  [2559] = {.lex_state = 406, .external_lex_state = 8},
  [2560] = {.lex_state = 407},
  [2561] = {.lex_state = 406, .external_lex_state = 8},
  [2562] = {.lex_state = 406, .external_lex_state = 8},
  [2563] = {.lex_state = 406, .external_lex_state = 8},
  [2564] = {.lex_state = 407},
  [2565] = {.lex_state = 407},
  [2566] = {.lex_state = 407},
  [2567] = {.lex_state = 407},
  [2568] = {.lex_state = 407},
  [2569] = {.lex_state = 406, .external_lex_state = 8},
  [2570] = {.lex_state = 406, .external_lex_state = 8},
  [2571] = {.lex_state = 407},
  [2572] = {.lex_state = 406, .external_lex_state = 8},
  [2573] = {.lex_state = 406, .external_lex_state = 8},
  [2574] = {.lex_state = 406, .external_lex_state = 8},
  [2575] = {.lex_state = 406, .external_lex_state = 8},
  [2576] = {.lex_state = 406, .external_lex_state = 8},
  [2577] = {.lex_state = 406, .external_lex_state = 8},
  [2578] = {.lex_state = 407},
  [2579] = {.lex_state = 406, .external_lex_state = 8},
  [2580] = {.lex_state = 407},
  [2581] = {.lex_state = 407},
  [2582] = {.lex_state = 406, .external_lex_state = 8},
  [2583] = {.lex_state = 406, .external_lex_state = 8},
  [2584] = {.lex_state = 407},
  [2585] = {.lex_state = 407},
  [2586] = {.lex_state = 407},
  [2587] = {.lex_state = 407},
  [2588] = {.lex_state = 407},
  [2589] = {.lex_state = 406, .external_lex_state = 8},
  [2590] = {.lex_state = 406, .external_lex_state = 8},
  [2591] = {.lex_state = 407},
  [2592] = {.lex_state = 407},
  [2593] = {.lex_state = 407},
  [2594] = {.lex_state = 407},
  [2595] = {.lex_state = 406, .external_lex_state = 8},
  [2596] = {.lex_state = 407},
  [2597] = {.lex_state = 416},
  [2598] = {.lex_state = 407, .external_lex_state = 8},
  [2599] = {.lex_state = 409},
  [2600] = {.lex_state = 416, .external_lex_state = 10},
  [2601] = {.lex_state = 407, .external_lex_state = 8},
  [2602] = {.lex_state = 407, .external_lex_state = 8},
  [2603] = {.lex_state = 416, .external_lex_state = 9},
  [2604] = {.lex_state = 407, .external_lex_state = 8},
  [2605] = {.lex_state = 406},
  [2606] = {.lex_state = 407, .external_lex_state = 8},
  [2607] = {.lex_state = 407, .external_lex_state = 8},
  [2608] = {.lex_state = 409},
  [2609] = {.lex_state = 409},
  [2610] = {.lex_state = 409},
  [2611] = {.lex_state = 407, .external_lex_state = 8},
  [2612] = {.lex_state = 407, .external_lex_state = 8},
  [2613] = {.lex_state = 407, .external_lex_state = 8},
  [2614] = {.lex_state = 407, .external_lex_state = 8},
  [2615] = {.lex_state = 407, .external_lex_state = 8},
  [2616] = {.lex_state = 407, .external_lex_state = 8},
  [2617] = {.lex_state = 407, .external_lex_state = 8},
  [2618] = {.lex_state = 407, .external_lex_state = 8},
  [2619] = {.lex_state = 407, .external_lex_state = 8},
  [2620] = {.lex_state = 409},
  [2621] = {.lex_state = 407, .external_lex_state = 8},
  [2622] = {.lex_state = 407, .external_lex_state = 8},
  [2623] = {.lex_state = 407, .external_lex_state = 8},
  [2624] = {.lex_state = 407, .external_lex_state = 8},
  [2625] = {.lex_state = 407, .external_lex_state = 7},
  [2626] = {.lex_state = 407, .external_lex_state = 8},
  [2627] = {.lex_state = 409},
  [2628] = {.lex_state = 416},
  [2629] = {.lex_state = 406},
  [2630] = {.lex_state = 406},
  [2631] = {.lex_state = 407, .external_lex_state = 8},
  [2632] = {.lex_state = 407, .external_lex_state = 8},
  [2633] = {.lex_state = 406},
  [2634] = {.lex_state = 409},
  [2635] = {.lex_state = 407, .external_lex_state = 8},
  [2636] = {.lex_state = 407, .external_lex_state = 8},
  [2637] = {.lex_state = 407, .external_lex_state = 8},
  [2638] = {.lex_state = 407, .external_lex_state = 8},
  [2639] = {.lex_state = 407, .external_lex_state = 8},
  [2640] = {.lex_state = 407, .external_lex_state = 8},
  [2641] = {.lex_state = 409},
  [2642] = {.lex_state = 407, .external_lex_state = 8},
  [2643] = {.lex_state = 409},
  [2644] = {.lex_state = 416},
  [2645] = {.lex_state = 407, .external_lex_state = 8},
  [2646] = {.lex_state = 407, .external_lex_state = 8},
  [2647] = {.lex_state = 407, .external_lex_state = 8},
  [2648] = {.lex_state = 407, .external_lex_state = 8},
  [2649] = {.lex_state = 407, .external_lex_state = 8},
  [2650] = {.lex_state = 407, .external_lex_state = 8},
  [2651] = {.lex_state = 407, .external_lex_state = 8},
  [2652] = {.lex_state = 407, .external_lex_state = 8},
  [2653] = {.lex_state = 407, .external_lex_state = 8},
  [2654] = {.lex_state = 407, .external_lex_state = 8},
  [2655] = {.lex_state = 407, .external_lex_state = 8},
  [2656] = {.lex_state = 407, .external_lex_state = 8},
  [2657] = {.lex_state = 407, .external_lex_state = 8},
  [2658] = {.lex_state = 407, .external_lex_state = 8},
  [2659] = {.lex_state = 407, .external_lex_state = 8},
  [2660] = {.lex_state = 416},
  [2661] = {.lex_state = 407, .external_lex_state = 7},
  [2662] = {.lex_state = 416},
  [2663] = {.lex_state = 407, .external_lex_state = 8},
  [2664] = {.lex_state = 416},
  [2665] = {.lex_state = 407, .external_lex_state = 8},
  [2666] = {.lex_state = 416},
  [2667] = {.lex_state = 407, .external_lex_state = 8},
  [2668] = {.lex_state = 407, .external_lex_state = 8},
  [2669] = {.lex_state = 416},
  [2670] = {.lex_state = 416},
  [2671] = {.lex_state = 407, .external_lex_state = 8},
  [2672] = {.lex_state = 416},
  [2673] = {.lex_state = 416},
  [2674] = {.lex_state = 407, .external_lex_state = 7},
  [2675] = {.lex_state = 407, .external_lex_state = 8},
  [2676] = {.lex_state = 403},
  [2677] = {.lex_state = 409},
  [2678] = {.lex_state = 409},
  [2679] = {.lex_state = 416},
  [2680] = {.lex_state = 416},
  [2681] = {.lex_state = 407, .external_lex_state = 8},
  [2682] = {.lex_state = 416},
  [2683] = {.lex_state = 416},
  [2684] = {.lex_state = 409},
  [2685] = {.lex_state = 407, .external_lex_state = 7},
  [2686] = {.lex_state = 416},
  [2687] = {.lex_state = 409},
  [2688] = {.lex_state = 407, .external_lex_state = 8},
  [2689] = {.lex_state = 416},
  [2690] = {.lex_state = 406},
  [2691] = {.lex_state = 406},
  [2692] = {.lex_state = 407, .external_lex_state = 8},
  [2693] = {.lex_state = 407, .external_lex_state = 8},
  [2694] = {.lex_state = 407, .external_lex_state = 8},
  [2695] = {.lex_state = 406},
  [2696] = {.lex_state = 407, .external_lex_state = 8},
  [2697] = {.lex_state = 407, .external_lex_state = 8},
  [2698] = {.lex_state = 407, .external_lex_state = 8},
  [2699] = {.lex_state = 407, .external_lex_state = 8},
  [2700] = {.lex_state = 416},
  [2701] = {.lex_state = 409},
  [2702] = {.lex_state = 409},
  [2703] = {.lex_state = 409},
  [2704] = {.lex_state = 416},
  [2705] = {.lex_state = 406},
  [2706] = {.lex_state = 409},
  [2707] = {.lex_state = 409},
  [2708] = {.lex_state = 406},
  [2709] = {.lex_state = 406},
  [2710] = {.lex_state = 409},
  [2711] = {.lex_state = 406},
  [2712] = {.lex_state = 409},
  [2713] = {.lex_state = 409},
  [2714] = {.lex_state = 409},
  [2715] = {.lex_state = 409},
  [2716] = {.lex_state = 409},
  [2717] = {.lex_state = 409},
  [2718] = {.lex_state = 409},
  [2719] = {.lex_state = 409},
  [2720] = {.lex_state = 409},
  [2721] = {.lex_state = 407, .external_lex_state = 7},
  [2722] = {.lex_state = 409},
  [2723] = {.lex_state = 411},
  [2724] = {.lex_state = 406},
  [2725] = {.lex_state = 406},
  [2726] = {.lex_state = 406},
  [2727] = {.lex_state = 442},
  [2728] = {.lex_state = 409},
  [2729] = {.lex_state = 409},
  [2730] = {.lex_state = 411},
  [2731] = {.lex_state = 409},
  [2732] = {.lex_state = 409},
  [2733] = {.lex_state = 407, .external_lex_state = 7},
  [2734] = {.lex_state = 411},
  [2735] = {.lex_state = 407, .external_lex_state = 7},
  [2736] = {.lex_state = 409},
  [2737] = {.lex_state = 409},
  [2738] = {.lex_state = 409},
  [2739] = {.lex_state = 442},
  [2740] = {.lex_state = 406},
  [2741] = {.lex_state = 409},
  [2742] = {.lex_state = 409},
  [2743] = {.lex_state = 409},
  [2744] = {.lex_state = 409},
  [2745] = {.lex_state = 409},
  [2746] = {.lex_state = 409},
  [2747] = {.lex_state = 409},
  [2748] = {.lex_state = 409},
  [2749] = {.lex_state = 409},
  [2750] = {.lex_state = 409},
  [2751] = {.lex_state = 409},
  [2752] = {.lex_state = 409},
  [2753] = {.lex_state = 409},
  [2754] = {.lex_state = 407, .external_lex_state = 7},
  [2755] = {.lex_state = 407, .external_lex_state = 7},
  [2756] = {.lex_state = 407, .external_lex_state = 7},
  [2757] = {.lex_state = 409},
  [2758] = {.lex_state = 442},
  [2759] = {.lex_state = 411},
  [2760] = {.lex_state = 409},
  [2761] = {.lex_state = 409},
  [2762] = {.lex_state = 409},
  [2763] = {.lex_state = 409},
  [2764] = {.lex_state = 409},
  [2765] = {.lex_state = 407, .external_lex_state = 7},
  [2766] = {.lex_state = 409},
  [2767] = {.lex_state = 407, .external_lex_state = 7},
  [2768] = {.lex_state = 409},
  [2769] = {.lex_state = 407, .external_lex_state = 7},
  [2770] = {.lex_state = 409},
  [2771] = {.lex_state = 409},
  [2772] = {.lex_state = 409},
  [2773] = {.lex_state = 442},
  [2774] = {.lex_state = 409},
  [2775] = {.lex_state = 409},
  [2776] = {.lex_state = 409},
  [2777] = {.lex_state = 406},
  [2778] = {.lex_state = 407, .external_lex_state = 7},
  [2779] = {.lex_state = 407, .external_lex_state = 7},
  [2780] = {.lex_state = 407, .external_lex_state = 7},
  [2781] = {.lex_state = 407, .external_lex_state = 9},
  [2782] = {.lex_state = 442},
  [2783] = {.lex_state = 407, .external_lex_state = 10},
  [2784] = {.lex_state = 406},
  [2785] = {.lex_state = 407, .external_lex_state = 7},
  [2786] = {.lex_state = 406},
  [2787] = {.lex_state = 406},
  [2788] = {.lex_state = 406},
  [2789] = {.lex_state = 406},
  [2790] = {.lex_state = 406},
  [2791] = {.lex_state = 407, .external_lex_state = 7},
  [2792] = {.lex_state = 406},
  [2793] = {.lex_state = 411},
  [2794] = {.lex_state = 407, .external_lex_state = 7},
  [2795] = {.lex_state = 407, .external_lex_state = 7},
  [2796] = {.lex_state = 442},
  [2797] = {.lex_state = 406},
  [2798] = {.lex_state = 407, .external_lex_state = 7},
  [2799] = {.lex_state = 406},
  [2800] = {.lex_state = 411},
  [2801] = {.lex_state = 406},
  [2802] = {.lex_state = 406},
  [2803] = {.lex_state = 407, .external_lex_state = 9},
  [2804] = {.lex_state = 406},
  [2805] = {.lex_state = 407, .external_lex_state = 7},
  [2806] = {.lex_state = 411},
  [2807] = {.lex_state = 407, .external_lex_state = 7},
  [2808] = {.lex_state = 407, .external_lex_state = 7},
  [2809] = {.lex_state = 407, .external_lex_state = 7},
  [2810] = {.lex_state = 406},
  [2811] = {.lex_state = 407, .external_lex_state = 7},
  [2812] = {.lex_state = 407, .external_lex_state = 7},
  [2813] = {.lex_state = 407, .external_lex_state = 7},
  [2814] = {.lex_state = 407, .external_lex_state = 7},
  [2815] = {.lex_state = 407, .external_lex_state = 7},
  [2816] = {.lex_state = 406},
  [2817] = {.lex_state = 411},
  [2818] = {.lex_state = 406},
  [2819] = {.lex_state = 407, .external_lex_state = 7},
  [2820] = {.lex_state = 407, .external_lex_state = 7},
  [2821] = {.lex_state = 407, .external_lex_state = 7},
  [2822] = {.lex_state = 407, .external_lex_state = 7},
  [2823] = {.lex_state = 407, .external_lex_state = 7},
  [2824] = {.lex_state = 407, .external_lex_state = 7},
  [2825] = {.lex_state = 406},
  [2826] = {.lex_state = 442},
  [2827] = {.lex_state = 406},
  [2828] = {.lex_state = 406},
  [2829] = {.lex_state = 406},
  [2830] = {.lex_state = 406},
  [2831] = {.lex_state = 406},
  [2832] = {.lex_state = 406},
  [2833] = {.lex_state = 406},
  [2834] = {.lex_state = 406},
  [2835] = {.lex_state = 406},
  [2836] = {.lex_state = 407, .external_lex_state = 10},
  [2837] = {.lex_state = 406},
  [2838] = {.lex_state = 407, .external_lex_state = 7},
  [2839] = {.lex_state = 407, .external_lex_state = 10},
  [2840] = {.lex_state = 407, .external_lex_state = 9},
  [2841] = {.lex_state = 407, .external_lex_state = 7},
  [2842] = {.lex_state = 407, .external_lex_state = 7},
  [2843] = {.lex_state = 407, .external_lex_state = 10},
  [2844] = {.lex_state = 406},
  [2845] = {.lex_state = 407, .external_lex_state = 7},
  [2846] = {.lex_state = 442},
  [2847] = {.lex_state = 411},
  [2848] = {.lex_state = 406},
  [2849] = {.lex_state = 406},
  [2850] = {.lex_state = 406},
  [2851] = {.lex_state = 406},
  [2852] = {.lex_state = 406},
  [2853] = {.lex_state = 411},
  [2854] = {.lex_state = 411},
  [2855] = {.lex_state = 406},
  [2856] = {.lex_state = 406},
  [2857] = {.lex_state = 407, .external_lex_state = 7},
  [2858] = {.lex_state = 411},
  [2859] = {.lex_state = 442},
  [2860] = {.lex_state = 406},
  [2861] = {.lex_state = 442},
  [2862] = {.lex_state = 406},
  [2863] = {.lex_state = 406},
  [2864] = {.lex_state = 406},
  [2865] = {.lex_state = 406},
  [2866] = {.lex_state = 406},
  [2867] = {.lex_state = 407, .external_lex_state = 7},
  [2868] = {.lex_state = 407, .external_lex_state = 7},
  [2869] = {.lex_state = 406},
  [2870] = {.lex_state = 442},
  [2871] = {.lex_state = 406},
  [2872] = {.lex_state = 407, .external_lex_state = 9},
  [2873] = {.lex_state = 406},
  [2874] = {.lex_state = 407, .external_lex_state = 7},
  [2875] = {.lex_state = 407, .external_lex_state = 7},
  [2876] = {.lex_state = 407, .external_lex_state = 7},
  [2877] = {.lex_state = 406},
  [2878] = {.lex_state = 407, .external_lex_state = 7},
  [2879] = {.lex_state = 406},
  [2880] = {.lex_state = 407, .external_lex_state = 7},
  [2881] = {.lex_state = 406},
  [2882] = {.lex_state = 442},
  [2883] = {.lex_state = 407, .external_lex_state = 7},
  [2884] = {.lex_state = 442},
  [2885] = {.lex_state = 407, .external_lex_state = 7},
  [2886] = {.lex_state = 407, .external_lex_state = 7},
  [2887] = {.lex_state = 407, .external_lex_state = 7},
  [2888] = {.lex_state = 407, .external_lex_state = 7},
  [2889] = {.lex_state = 407, .external_lex_state = 7},
  [2890] = {.lex_state = 407, .external_lex_state = 7},
  [2891] = {.lex_state = 407, .external_lex_state = 7},
  [2892] = {.lex_state = 406},
  [2893] = {.lex_state = 406},
  [2894] = {.lex_state = 407, .external_lex_state = 7},
  [2895] = {.lex_state = 406},
  [2896] = {.lex_state = 411},
  [2897] = {.lex_state = 406},
  [2898] = {.lex_state = 406},
  [2899] = {.lex_state = 407, .external_lex_state = 7},
  [2900] = {.lex_state = 407, .external_lex_state = 7},
  [2901] = {.lex_state = 407, .external_lex_state = 7},
  [2902] = {.lex_state = 407, .external_lex_state = 7},
  [2903] = {.lex_state = 407, .external_lex_state = 7},
  [2904] = {.lex_state = 407, .external_lex_state = 7},
  [2905] = {.lex_state = 442},
  [2906] = {.lex_state = 442},
  [2907] = {.lex_state = 442},
  [2908] = {.lex_state = 442},
  [2909] = {.lex_state = 442},
  [2910] = {.lex_state = 442},
  [2911] = {.lex_state = 407, .external_lex_state = 9},
  [2912] = {.lex_state = 442},
  [2913] = {.lex_state = 442},
  [2914] = {.lex_state = 442},
  [2915] = {.lex_state = 442},
  [2916] = {.lex_state = 411},
  [2917] = {.lex_state = 411},
  [2918] = {.lex_state = 411},
  [2919] = {.lex_state = 442},
  [2920] = {.lex_state = 407, .external_lex_state = 10},
  [2921] = {.lex_state = 407, .external_lex_state = 9},
  [2922] = {.lex_state = 411},
  [2923] = {.lex_state = 411},
  [2924] = {.lex_state = 442},
  [2925] = {.lex_state = 407, .external_lex_state = 10},
  [2926] = {.lex_state = 442},
  [2927] = {.lex_state = 442},
  [2928] = {.lex_state = 411},
  [2929] = {.lex_state = 442},
  [2930] = {.lex_state = 411},
  [2931] = {.lex_state = 407, .external_lex_state = 10},
  [2932] = {.lex_state = 442},
  [2933] = {.lex_state = 442},
  [2934] = {.lex_state = 442},
  [2935] = {.lex_state = 411},
  [2936] = {.lex_state = 442},
  [2937] = {.lex_state = 442},
  [2938] = {.lex_state = 442},
  [2939] = {.lex_state = 442},
  [2940] = {.lex_state = 442},
  [2941] = {.lex_state = 411},
  [2942] = {.lex_state = 411},
  [2943] = {.lex_state = 411},
  [2944] = {.lex_state = 411},
  [2945] = {.lex_state = 411},
  [2946] = {.lex_state = 407, .external_lex_state = 9},
  [2947] = {.lex_state = 411},
  [2948] = {.lex_state = 411},
  [2949] = {.lex_state = 442},
  [2950] = {.lex_state = 442},
  [2951] = {.lex_state = 407, .external_lex_state = 10},
  [2952] = {.lex_state = 442},
  [2953] = {.lex_state = 442},
  [2954] = {.lex_state = 411},
  [2955] = {.lex_state = 442},
  [2956] = {.lex_state = 411},
  [2957] = {.lex_state = 442},
  [2958] = {.lex_state = 411},
  [2959] = {.lex_state = 442},
  [2960] = {.lex_state = 411},
  [2961] = {.lex_state = 411},
  [2962] = {.lex_state = 407, .external_lex_state = 9},
  [2963] = {.lex_state = 442},
  [2964] = {.lex_state = 442},
  [2965] = {.lex_state = 411},
  [2966] = {.lex_state = 407, .external_lex_state = 9},
  [2967] = {.lex_state = 411},
  [2968] = {.lex_state = 411},
  [2969] = {.lex_state = 411},
  [2970] = {.lex_state = 407, .external_lex_state = 9},
  [2971] = {.lex_state = 442},
  [2972] = {.lex_state = 411},
  [2973] = {.lex_state = 442},
  [2974] = {.lex_state = 411},
  [2975] = {.lex_state = 442},
  [2976] = {.lex_state = 442},
  [2977] = {.lex_state = 442},
  [2978] = {.lex_state = 402},
  [2979] = {.lex_state = 407, .external_lex_state = 10},
  [2980] = {.lex_state = 407, .external_lex_state = 10},
  [2981] = {.lex_state = 407, .external_lex_state = 10},
  [2982] = {.lex_state = 417},
  [2983] = {.lex_state = 407, .external_lex_state = 9},
  [2984] = {.lex_state = 407, .external_lex_state = 9},
  [2985] = {.lex_state = 411},
  [2986] = {.lex_state = 411},
  [2987] = {.lex_state = 411},
  [2988] = {.lex_state = 411},
  [2989] = {.lex_state = 411},
  [2990] = {.lex_state = 411},
  [2991] = {.lex_state = 407, .external_lex_state = 10},
  [2992] = {.lex_state = 411},
  [2993] = {.lex_state = 407, .external_lex_state = 10},
  [2994] = {.lex_state = 411},
  [2995] = {.lex_state = 411},
  [2996] = {.lex_state = 411},
  [2997] = {.lex_state = 411},
  [2998] = {.lex_state = 442},
  [2999] = {.lex_state = 442},
  [3000] = {.lex_state = 411},
  [3001] = {.lex_state = 411},
  [3002] = {.lex_state = 411},
  [3003] = {.lex_state = 411},
  [3004] = {.lex_state = 442},
  [3005] = {.lex_state = 411},
  [3006] = {.lex_state = 442},
  [3007] = {.lex_state = 442},
  [3008] = {.lex_state = 442},
  [3009] = {.lex_state = 442},
  [3010] = {.lex_state = 442},
  [3011] = {.lex_state = 442},
  [3012] = {.lex_state = 411},
  [3013] = {.lex_state = 442},
  [3014] = {.lex_state = 411},
  [3015] = {.lex_state = 411},
  [3016] = {.lex_state = 411},
  [3017] = {.lex_state = 411},
  [3018] = {.lex_state = 411},
  [3019] = {.lex_state = 411},
  [3020] = {.lex_state = 411},
  [3021] = {.lex_state = 407, .external_lex_state = 9},
  [3022] = {.lex_state = 442},
  [3023] = {.lex_state = 442},
  [3024] = {.lex_state = 442},
  [3025] = {.lex_state = 407, .external_lex_state = 9},
  [3026] = {.lex_state = 407, .external_lex_state = 10},
  [3027] = {.lex_state = 407, .external_lex_state = 9},
  [3028] = {.lex_state = 407, .external_lex_state = 10},
  [3029] = {.lex_state = 407, .external_lex_state = 10},
  [3030] = {.lex_state = 407, .external_lex_state = 9},
  [3031] = {.lex_state = 407, .external_lex_state = 10},
  [3032] = {.lex_state = 407, .external_lex_state = 9},
  [3033] = {.lex_state = 407, .external_lex_state = 9},
  [3034] = {.lex_state = 407, .external_lex_state = 10},
  [3035] = {.lex_state = 407, .external_lex_state = 10},
  [3036] = {.lex_state = 407, .external_lex_state = 9},
  [3037] = {.lex_state = 407, .external_lex_state = 9},
  [3038] = {.lex_state = 407, .external_lex_state = 9},
  [3039] = {.lex_state = 407, .external_lex_state = 9},
  [3040] = {.lex_state = 407, .external_lex_state = 10},
  [3041] = {.lex_state = 407, .external_lex_state = 9},
  [3042] = {.lex_state = 407, .external_lex_state = 10},
  [3043] = {.lex_state = 407, .external_lex_state = 9},
  [3044] = {.lex_state = 407, .external_lex_state = 10},
  [3045] = {.lex_state = 407, .external_lex_state = 9},
  [3046] = {.lex_state = 407, .external_lex_state = 10},
  [3047] = {.lex_state = 407, .external_lex_state = 9},
  [3048] = {.lex_state = 407, .external_lex_state = 10},
  [3049] = {.lex_state = 407, .external_lex_state = 10},
  [3050] = {.lex_state = 407, .external_lex_state = 10},
  [3051] = {.lex_state = 407, .external_lex_state = 10},
  [3052] = {.lex_state = 407, .external_lex_state = 10},
  [3053] = {.lex_state = 407, .external_lex_state = 10},
  [3054] = {.lex_state = 407, .external_lex_state = 9},
  [3055] = {.lex_state = 407, .external_lex_state = 10},
  [3056] = {.lex_state = 407, .external_lex_state = 10},
  [3057] = {.lex_state = 407, .external_lex_state = 9},
  [3058] = {.lex_state = 407, .external_lex_state = 10},
  [3059] = {.lex_state = 407, .external_lex_state = 9},
  [3060] = {.lex_state = 407, .external_lex_state = 9},
  [3061] = {.lex_state = 407, .external_lex_state = 9},
  [3062] = {.lex_state = 407, .external_lex_state = 10},
  [3063] = {.lex_state = 407, .external_lex_state = 10},
  [3064] = {.lex_state = 407, .external_lex_state = 9},
  [3065] = {.lex_state = 407, .external_lex_state = 10},
  [3066] = {.lex_state = 407, .external_lex_state = 10},
  [3067] = {.lex_state = 407, .external_lex_state = 10},
  [3068] = {.lex_state = 407, .external_lex_state = 10},
  [3069] = {.lex_state = 407, .external_lex_state = 10},
  [3070] = {.lex_state = 407, .external_lex_state = 9},
  [3071] = {.lex_state = 407, .external_lex_state = 10},
  [3072] = {.lex_state = 407, .external_lex_state = 10},
  [3073] = {.lex_state = 407, .external_lex_state = 10},
  [3074] = {.lex_state = 407, .external_lex_state = 9},
  [3075] = {.lex_state = 407, .external_lex_state = 9},
  [3076] = {.lex_state = 407, .external_lex_state = 10},
  [3077] = {.lex_state = 407, .external_lex_state = 9},
  [3078] = {.lex_state = 407, .external_lex_state = 10},
  [3079] = {.lex_state = 407, .external_lex_state = 9},
  [3080] = {.lex_state = 407, .external_lex_state = 9},
  [3081] = {.lex_state = 407, .external_lex_state = 10},
  [3082] = {.lex_state = 407, .external_lex_state = 9},
  [3083] = {.lex_state = 407, .external_lex_state = 9},
  [3084] = {.lex_state = 407, .external_lex_state = 10},
  [3085] = {.lex_state = 407, .external_lex_state = 9},
  [3086] = {.lex_state = 407, .external_lex_state = 10},
  [3087] = {.lex_state = 407, .external_lex_state = 9},
  [3088] = {.lex_state = 407, .external_lex_state = 10},
  [3089] = {.lex_state = 407, .external_lex_state = 10},
  [3090] = {.lex_state = 407, .external_lex_state = 10},
  [3091] = {.lex_state = 407, .external_lex_state = 9},
  [3092] = {.lex_state = 407, .external_lex_state = 9},
  [3093] = {.lex_state = 407, .external_lex_state = 9},
  [3094] = {.lex_state = 407, .external_lex_state = 10},
  [3095] = {.lex_state = 407, .external_lex_state = 9},
  [3096] = {.lex_state = 407, .external_lex_state = 9},
  [3097] = {.lex_state = 407, .external_lex_state = 9},
  [3098] = {.lex_state = 407, .external_lex_state = 9},
  [3099] = {.lex_state = 407, .external_lex_state = 10},
  [3100] = {.lex_state = 407, .external_lex_state = 9},
  [3101] = {.lex_state = 407, .external_lex_state = 9},
  [3102] = {.lex_state = 407, .external_lex_state = 9},
  [3103] = {.lex_state = 407, .external_lex_state = 9},
  [3104] = {.lex_state = 407, .external_lex_state = 9},
  [3105] = {.lex_state = 407, .external_lex_state = 10},
  [3106] = {.lex_state = 407, .external_lex_state = 10},
  [3107] = {.lex_state = 407, .external_lex_state = 9},
  [3108] = {.lex_state = 407, .external_lex_state = 9},
  [3109] = {.lex_state = 407, .external_lex_state = 10},
  [3110] = {.lex_state = 407, .external_lex_state = 9},
  [3111] = {.lex_state = 407, .external_lex_state = 9},
  [3112] = {.lex_state = 407, .external_lex_state = 9},
  [3113] = {.lex_state = 407, .external_lex_state = 9},
  [3114] = {.lex_state = 407, .external_lex_state = 9},
  [3115] = {.lex_state = 407, .external_lex_state = 9},
  [3116] = {.lex_state = 407, .external_lex_state = 10},
  [3117] = {.lex_state = 407, .external_lex_state = 10},
  [3118] = {.lex_state = 407, .external_lex_state = 10},
  [3119] = {.lex_state = 407, .external_lex_state = 9},
  [3120] = {.lex_state = 407, .external_lex_state = 10},
  [3121] = {.lex_state = 407, .external_lex_state = 10},
  [3122] = {.lex_state = 407, .external_lex_state = 10},
  [3123] = {.lex_state = 407, .external_lex_state = 10},
  [3124] = {.lex_state = 407, .external_lex_state = 10},
  [3125] = {.lex_state = 418},
  [3126] = {.lex_state = 418},
  [3127] = {.lex_state = 420},
  [3128] = {.lex_state = 420},
  [3129] = {.lex_state = 420},
  [3130] = {.lex_state = 420},
  [3131] = {.lex_state = 420},
  [3132] = {.lex_state = 420},
  [3133] = {.lex_state = 420},
  [3134] = {.lex_state = 420, .external_lex_state = 6},
  [3135] = {.lex_state = 420},
  [3136] = {.lex_state = 420, .external_lex_state = 6},
  [3137] = {.lex_state = 420, .external_lex_state = 6},
  [3138] = {.lex_state = 420},
  [3139] = {.lex_state = 422},
  [3140] = {.lex_state = 420},
  [3141] = {.lex_state = 422},
  [3142] = {.lex_state = 422},
  [3143] = {.lex_state = 420},
  [3144] = {.lex_state = 420},
  [3145] = {.lex_state = 420},
  [3146] = {.lex_state = 420},
  [3147] = {.lex_state = 420},
  [3148] = {.lex_state = 420},
  [3149] = {.lex_state = 420},
  [3150] = {.lex_state = 420},
  [3151] = {.lex_state = 420},
  [3152] = {.lex_state = 422},
  [3153] = {.lex_state = 420},
  [3154] = {.lex_state = 420},
  [3155] = {.lex_state = 420},
  [3156] = {.lex_state = 420},
  [3157] = {.lex_state = 420},
  [3158] = {.lex_state = 420},
  [3159] = {.lex_state = 420},
  [3160] = {.lex_state = 422},
  [3161] = {.lex_state = 420},
  [3162] = {.lex_state = 420},
  [3163] = {.lex_state = 420},
  [3164] = {.lex_state = 420},
  [3165] = {.lex_state = 420},
  [3166] = {.lex_state = 420},
  [3167] = {.lex_state = 420},
  [3168] = {.lex_state = 420},
  [3169] = {.lex_state = 420},
  [3170] = {.lex_state = 420},
  [3171] = {.lex_state = 420},
  [3172] = {.lex_state = 420},
  [3173] = {.lex_state = 420},
  [3174] = {.lex_state = 420},
  [3175] = {.lex_state = 420},
  [3176] = {.lex_state = 420},
  [3177] = {.lex_state = 420},
  [3178] = {.lex_state = 420},
  [3179] = {.lex_state = 420},
  [3180] = {.lex_state = 420},
  [3181] = {.lex_state = 420},
  [3182] = {.lex_state = 420},
  [3183] = {.lex_state = 420},
  [3184] = {.lex_state = 420},
  [3185] = {.lex_state = 420},
  [3186] = {.lex_state = 420},
  [3187] = {.lex_state = 420},
  [3188] = {.lex_state = 420},
  [3189] = {.lex_state = 420},
  [3190] = {.lex_state = 420},
  [3191] = {.lex_state = 420},
  [3192] = {.lex_state = 420},
  [3193] = {.lex_state = 420},
  [3194] = {.lex_state = 420},
  [3195] = {.lex_state = 420},
  [3196] = {.lex_state = 420},
  [3197] = {.lex_state = 420},
  [3198] = {.lex_state = 420},
  [3199] = {.lex_state = 420},
  [3200] = {.lex_state = 420},
  [3201] = {.lex_state = 420},
  [3202] = {.lex_state = 420},
  [3203] = {.lex_state = 420},
  [3204] = {.lex_state = 420},
  [3205] = {.lex_state = 420},
  [3206] = {.lex_state = 422},
  [3207] = {.lex_state = 420},
  [3208] = {.lex_state = 420},
  [3209] = {.lex_state = 420},
  [3210] = {.lex_state = 420},
  [3211] = {.lex_state = 420},
  [3212] = {.lex_state = 420},
  [3213] = {.lex_state = 420},
  [3214] = {.lex_state = 420},
  [3215] = {.lex_state = 420},
  [3216] = {.lex_state = 420},
  [3217] = {.lex_state = 420},
  [3218] = {.lex_state = 420},
  [3219] = {.lex_state = 420},
  [3220] = {.lex_state = 420},
  [3221] = {.lex_state = 420},
  [3222] = {.lex_state = 420},
  [3223] = {.lex_state = 420},
  [3224] = {.lex_state = 420},
  [3225] = {.lex_state = 420},
  [3226] = {.lex_state = 420},
  [3227] = {.lex_state = 420},
  [3228] = {.lex_state = 420},
  [3229] = {.lex_state = 420},
  [3230] = {.lex_state = 420},
  [3231] = {.lex_state = 420},
  [3232] = {.lex_state = 420},
  [3233] = {.lex_state = 420},
  [3234] = {.lex_state = 420},
  [3235] = {.lex_state = 423},
  [3236] = {.lex_state = 420},
  [3237] = {.lex_state = 424},
  [3238] = {.lex_state = 420},
  [3239] = {.lex_state = 420},
  [3240] = {.lex_state = 420},
  [3241] = {.lex_state = 420},
  [3242] = {.lex_state = 420},
  [3243] = {.lex_state = 420},
  [3244] = {.lex_state = 420},
  [3245] = {.lex_state = 420},
  [3246] = {.lex_state = 420},
  [3247] = {.lex_state = 420},
  [3248] = {.lex_state = 420},
  [3249] = {.lex_state = 420},
  [3250] = {.lex_state = 420},
  [3251] = {.lex_state = 420},
  [3252] = {.lex_state = 420},
  [3253] = {.lex_state = 420},
  [3254] = {.lex_state = 420},
  [3255] = {.lex_state = 420},
  [3256] = {.lex_state = 420},
  [3257] = {.lex_state = 420},
  [3258] = {.lex_state = 420},
  [3259] = {.lex_state = 420},
  [3260] = {.lex_state = 420},
  [3261] = {.lex_state = 420},
  [3262] = {.lex_state = 425},
  [3263] = {.lex_state = 420},
  [3264] = {.lex_state = 420},
  [3265] = {.lex_state = 420},
  [3266] = {.lex_state = 420},
  [3267] = {.lex_state = 420},
  [3268] = {.lex_state = 426},
  [3269] = {.lex_state = 426},
  [3270] = {.lex_state = 426},
  [3271] = {.lex_state = 426},
  [3272] = {.lex_state = 426},
  [3273] = {.lex_state = 426},
  [3274] = {.lex_state = 426},
  [3275] = {.lex_state = 426},
  [3276] = {.lex_state = 426},
  [3277] = {.lex_state = 426},
  [3278] = {.lex_state = 426},
  [3279] = {.lex_state = 426},
  [3280] = {.lex_state = 426},
  [3281] = {.lex_state = 426},
  [3282] = {.lex_state = 426},
  [3283] = {.lex_state = 426},
  [3284] = {.lex_state = 426},
  [3285] = {.lex_state = 428},
  [3286] = {.lex_state = 428},
  [3287] = {.lex_state = 428},
  [3288] = {.lex_state = 428},
  [3289] = {.lex_state = 428},
  [3290] = {.lex_state = 428},
  [3291] = {.lex_state = 428},
  [3292] = {.lex_state = 428},
  [3293] = {.lex_state = 428},
  [3294] = {.lex_state = 428},
  [3295] = {.lex_state = 429},
  [3296] = {.lex_state = 428},
  [3297] = {.lex_state = 428},
  [3298] = {.lex_state = 428},
  [3299] = {.lex_state = 428},
  [3300] = {.lex_state = 428},
  [3301] = {.lex_state = 428},
  [3302] = {.lex_state = 430, .external_lex_state = 7},
  [3303] = {.lex_state = 430, .external_lex_state = 7},
  [3304] = {.lex_state = 430, .external_lex_state = 7},
  [3305] = {.lex_state = 430},
  [3306] = {.lex_state = 430},
  [3307] = {.lex_state = 430},
  [3308] = {.lex_state = 430},
  [3309] = {.lex_state = 430},
  [3310] = {.lex_state = 430},
  [3311] = {.lex_state = 430},
  [3312] = {.lex_state = 430},
  [3313] = {.lex_state = 430},
  [3314] = {.lex_state = 430},
  [3315] = {.lex_state = 430},
  [3316] = {.lex_state = 430},
  [3317] = {.lex_state = 426},
  [3318] = {.lex_state = 426},
  [3319] = {.lex_state = 426},
  [3320] = {.lex_state = 426},
  [3321] = {.lex_state = 426},
  [3322] = {.lex_state = 426},
  [3323] = {.lex_state = 426},
  [3324] = {.lex_state = 426},
  [3325] = {.lex_state = 426},
  [3326] = {.lex_state = 426},
  [3327] = {.lex_state = 426},
  [3328] = {.lex_state = 426},
  [3329] = {.lex_state = 426},
  [3330] = {.lex_state = 426},
  [3331] = {.lex_state = 426},
  [3332] = {.lex_state = 426},
  [3333] = {.lex_state = 426},
  [3334] = {.lex_state = 426},
  [3335] = {.lex_state = 426},
  [3336] = {.lex_state = 426},
  [3337] = {.lex_state = 426},
  [3338] = {.lex_state = 426},
  [3339] = {.lex_state = 426},
  [3340] = {.lex_state = 426},
  [3341] = {.lex_state = 426},
  [3342] = {.lex_state = 426},
  [3343] = {.lex_state = 426},
  [3344] = {.lex_state = 426},
  [3345] = {.lex_state = 426},
  [3346] = {.lex_state = 426},
  [3347] = {.lex_state = 426},
  [3348] = {.lex_state = 426},
  [3349] = {.lex_state = 426},
  [3350] = {.lex_state = 426},
  [3351] = {.lex_state = 426},
  [3352] = {.lex_state = 426},
  [3353] = {.lex_state = 426},
  [3354] = {.lex_state = 426},
  [3355] = {.lex_state = 426},
  [3356] = {.lex_state = 426},
  [3357] = {.lex_state = 426},
  [3358] = {.lex_state = 426},
  [3359] = {.lex_state = 426},
  [3360] = {.lex_state = 426},
  [3361] = {.lex_state = 426},
  [3362] = {.lex_state = 426},
  [3363] = {.lex_state = 426},
  [3364] = {.lex_state = 426},
  [3365] = {.lex_state = 430, .external_lex_state = 7},
  [3366] = {.lex_state = 426},
  [3367] = {.lex_state = 426},
  [3368] = {.lex_state = 426},
  [3369] = {.lex_state = 426},
  [3370] = {.lex_state = 426},
  [3371] = {.lex_state = 426},
  [3372] = {.lex_state = 426},
  [3373] = {.lex_state = 426},
  [3374] = {.lex_state = 426},
  [3375] = {.lex_state = 426},
  [3376] = {.lex_state = 426},
  [3377] = {.lex_state = 426},
  [3378] = {.lex_state = 426},
  [3379] = {.lex_state = 426},
  [3380] = {.lex_state = 426},
  [3381] = {.lex_state = 426},
  [3382] = {.lex_state = 430, .external_lex_state = 7},
  [3383] = {.lex_state = 430, .external_lex_state = 7},
  [3384] = {.lex_state = 430, .external_lex_state = 7},
  [3385] = {.lex_state = 430, .external_lex_state = 7},
  [3386] = {.lex_state = 430, .external_lex_state = 7},
  [3387] = {.lex_state = 430, .external_lex_state = 7},
  [3388] = {.lex_state = 430, .external_lex_state = 7},
  [3389] = {.lex_state = 430, .external_lex_state = 7},
  [3390] = {.lex_state = 430, .external_lex_state = 7},
  [3391] = {.lex_state = 430, .external_lex_state = 7},
  [3392] = {.lex_state = 426},
  [3393] = {.lex_state = 430, .external_lex_state = 7},
  [3394] = {.lex_state = 430, .external_lex_state = 7},
  [3395] = {.lex_state = 430, .external_lex_state = 7},
  [3396] = {.lex_state = 430, .external_lex_state = 7},
  [3397] = {.lex_state = 430, .external_lex_state = 7},
  [3398] = {.lex_state = 426},
  [3399] = {.lex_state = 430, .external_lex_state = 7},
  [3400] = {.lex_state = 430, .external_lex_state = 7},
  [3401] = {.lex_state = 430, .external_lex_state = 7},
  [3402] = {.lex_state = 430, .external_lex_state = 7},
  [3403] = {.lex_state = 430, .external_lex_state = 7},
  [3404] = {.lex_state = 430, .external_lex_state = 7},
  [3405] = {.lex_state = 430, .external_lex_state = 7},
  [3406] = {.lex_state = 426},
  [3407] = {.lex_state = 430, .external_lex_state = 7},
  [3408] = {.lex_state = 430, .external_lex_state = 7},
  [3409] = {.lex_state = 430, .external_lex_state = 7},
  [3410] = {.lex_state = 430, .external_lex_state = 7},
  [3411] = {.lex_state = 430, .external_lex_state = 7},
  [3412] = {.lex_state = 430, .external_lex_state = 7},
  [3413] = {.lex_state = 430, .external_lex_state = 7},
  [3414] = {.lex_state = 430, .external_lex_state = 7},
  [3415] = {.lex_state = 430, .external_lex_state = 7},
  [3416] = {.lex_state = 430, .external_lex_state = 7},
  [3417] = {.lex_state = 430, .external_lex_state = 7},
  [3418] = {.lex_state = 430, .external_lex_state = 7},
  [3419] = {.lex_state = 430, .external_lex_state = 7},
  [3420] = {.lex_state = 426},
  [3421] = {.lex_state = 430, .external_lex_state = 7},
  [3422] = {.lex_state = 430, .external_lex_state = 7},
  [3423] = {.lex_state = 430, .external_lex_state = 7},
  [3424] = {.lex_state = 430, .external_lex_state = 7},
  [3425] = {.lex_state = 430, .external_lex_state = 7},
  [3426] = {.lex_state = 430, .external_lex_state = 7},
  [3427] = {.lex_state = 430, .external_lex_state = 7},
  [3428] = {.lex_state = 430, .external_lex_state = 7},
  [3429] = {.lex_state = 430, .external_lex_state = 7},
  [3430] = {.lex_state = 426},
  [3431] = {.lex_state = 430, .external_lex_state = 7},
  [3432] = {.lex_state = 430, .external_lex_state = 7},
  [3433] = {.lex_state = 430, .external_lex_state = 7},
  [3434] = {.lex_state = 430, .external_lex_state = 7},
  [3435] = {.lex_state = 430, .external_lex_state = 7},
  [3436] = {.lex_state = 430, .external_lex_state = 7},
  [3437] = {.lex_state = 430, .external_lex_state = 7},
  [3438] = {.lex_state = 430, .external_lex_state = 7},
  [3439] = {.lex_state = 430, .external_lex_state = 7},
  [3440] = {.lex_state = 430, .external_lex_state = 7},
  [3441] = {.lex_state = 426},
  [3442] = {.lex_state = 430, .external_lex_state = 7},
  [3443] = {.lex_state = 426},
  [3444] = {.lex_state = 430, .external_lex_state = 7},
  [3445] = {.lex_state = 430, .external_lex_state = 7},
  [3446] = {.lex_state = 430, .external_lex_state = 7},
  [3447] = {.lex_state = 430, .external_lex_state = 7},
  [3448] = {.lex_state = 430, .external_lex_state = 7},
  [3449] = {.lex_state = 430, .external_lex_state = 7},
  [3450] = {.lex_state = 430, .external_lex_state = 7},
  [3451] = {.lex_state = 430, .external_lex_state = 7},
  [3452] = {.lex_state = 426},
  [3453] = {.lex_state = 426},
  [3454] = {.lex_state = 426},
  [3455] = {.lex_state = 426},
  [3456] = {.lex_state = 426},
  [3457] = {.lex_state = 426},
  [3458] = {.lex_state = 432},
  [3459] = {.lex_state = 430, .external_lex_state = 7},
  [3460] = {.lex_state = 426},
  [3461] = {.lex_state = 430, .external_lex_state = 7},
  [3462] = {.lex_state = 426},
  [3463] = {.lex_state = 426},
  [3464] = {.lex_state = 426},
  [3465] = {.lex_state = 426},
  [3466] = {.lex_state = 430, .external_lex_state = 7},
  [3467] = {.lex_state = 430, .external_lex_state = 7},
  [3468] = {.lex_state = 426},
  [3469] = {.lex_state = 433, .external_lex_state = 7},
  [3470] = {.lex_state = 430, .external_lex_state = 7},
  [3471] = {.lex_state = 426},
  [3472] = {.lex_state = 426},
  [3473] = {.lex_state = 426},
  [3474] = {.lex_state = 430, .external_lex_state = 7},
  [3475] = {.lex_state = 430, .external_lex_state = 7},
  [3476] = {.lex_state = 430},
  [3477] = {.lex_state = 430, .external_lex_state = 7},
  [3478] = {.lex_state = 430, .external_lex_state = 7},
  [3479] = {.lex_state = 430, .external_lex_state = 7},
  [3480] = {.lex_state = 430, .external_lex_state = 7},
  [3481] = {.lex_state = 0, .external_lex_state = 8},
  [3482] = {.lex_state = 0, .external_lex_state = 8},
  [3483] = {.lex_state = 0, .external_lex_state = 8},
  [3484] = {.lex_state = 434},
  [3485] = {.lex_state = 434},
  [3486] = {.lex_state = 434},
  [3487] = {.lex_state = 434},
  [3488] = {.lex_state = 434},
  [3489] = {.lex_state = 434},
  [3490] = {.lex_state = 434},
  [3491] = {.lex_state = 434},
  [3492] = {.lex_state = 434},
  [3493] = {.lex_state = 434},
  [3494] = {.lex_state = 434},
  [3495] = {.lex_state = 434},
  [3496] = {.lex_state = 434},
  [3497] = {.lex_state = 434},
  [3498] = {.lex_state = 434},
  [3499] = {.lex_state = 434},
  [3500] = {.lex_state = 434},
  [3501] = {.lex_state = 434},
  [3502] = {.lex_state = 434},
  [3503] = {.lex_state = 434},
  [3504] = {.lex_state = 434},
  [3505] = {.lex_state = 434},
  [3506] = {.lex_state = 434},
  [3507] = {.lex_state = 434},
  [3508] = {.lex_state = 434},
  [3509] = {.lex_state = 434},
  [3510] = {.lex_state = 434},
  [3511] = {.lex_state = 434},
  [3512] = {.lex_state = 434},
  [3513] = {.lex_state = 434},
  [3514] = {.lex_state = 434},
  [3515] = {.lex_state = 434},
  [3516] = {.lex_state = 434},
  [3517] = {.lex_state = 434},
  [3518] = {.lex_state = 434},
  [3519] = {.lex_state = 434},
  [3520] = {.lex_state = 434},
  [3521] = {.lex_state = 434},
  [3522] = {.lex_state = 434},
  [3523] = {.lex_state = 434},
  [3524] = {.lex_state = 434},
  [3525] = {.lex_state = 434},
  [3526] = {.lex_state = 434},
  [3527] = {.lex_state = 434},
  [3528] = {.lex_state = 434},
  [3529] = {.lex_state = 434},
  [3530] = {.lex_state = 434},
  [3531] = {.lex_state = 434},
  [3532] = {.lex_state = 434},
  [3533] = {.lex_state = 434},
  [3534] = {.lex_state = 434},
  [3535] = {.lex_state = 434},
  [3536] = {.lex_state = 434},
  [3537] = {.lex_state = 434},
  [3538] = {.lex_state = 434},
  [3539] = {.lex_state = 434},
  [3540] = {.lex_state = 434},
  [3541] = {.lex_state = 434},
  [3542] = {.lex_state = 434},
  [3543] = {.lex_state = 434},
  [3544] = {.lex_state = 434},
  [3545] = {.lex_state = 434},
  [3546] = {.lex_state = 418},
  [3547] = {.lex_state = 418},
  [3548] = {.lex_state = 0, .external_lex_state = 11},
  [3549] = {.lex_state = 434},
  [3550] = {.lex_state = 418},
  [3551] = {.lex_state = 434},
  [3552] = {.lex_state = 0, .external_lex_state = 11},
  [3553] = {.lex_state = 418, .external_lex_state = 7},
  [3554] = {.lex_state = 434},
  [3555] = {.lex_state = 434},
  [3556] = {.lex_state = 434},
  [3557] = {.lex_state = 418},
  [3558] = {.lex_state = 418},
  [3559] = {.lex_state = 418, .external_lex_state = 7},
  [3560] = {.lex_state = 434},
  [3561] = {.lex_state = 0, .external_lex_state = 11},
  [3562] = {.lex_state = 434},
  [3563] = {.lex_state = 418},
  [3564] = {.lex_state = 434},
  [3565] = {.lex_state = 418},
  [3566] = {.lex_state = 418},
  [3567] = {.lex_state = 0, .external_lex_state = 11},
  [3568] = {.lex_state = 434},
  [3569] = {.lex_state = 418},
  [3570] = {.lex_state = 434},
  [3571] = {.lex_state = 418},
  [3572] = {.lex_state = 434},
  [3573] = {.lex_state = 418},
  [3574] = {.lex_state = 418},
  [3575] = {.lex_state = 418},
  [3576] = {.lex_state = 418},
  [3577] = {.lex_state = 418},
  [3578] = {.lex_state = 434},
  [3579] = {.lex_state = 418},
  [3580] = {.lex_state = 434},
  [3581] = {.lex_state = 0, .external_lex_state = 11},
  [3582] = {.lex_state = 434},
  [3583] = {.lex_state = 434},
  [3584] = {.lex_state = 418},
  [3585] = {.lex_state = 0, .external_lex_state = 11},
  [3586] = {.lex_state = 0, .external_lex_state = 11},
  [3587] = {.lex_state = 418},
  [3588] = {.lex_state = 434},
  [3589] = {.lex_state = 418},
  [3590] = {.lex_state = 418},
  [3591] = {.lex_state = 434},
  [3592] = {.lex_state = 418},
  [3593] = {.lex_state = 0, .external_lex_state = 11},
  [3594] = {.lex_state = 434},
  [3595] = {.lex_state = 434},
  [3596] = {.lex_state = 434},
  [3597] = {.lex_state = 418},
  [3598] = {.lex_state = 418},
  [3599] = {.lex_state = 436},
  [3600] = {.lex_state = 418},
  [3601] = {.lex_state = 434},
  [3602] = {.lex_state = 434},
  [3603] = {.lex_state = 0, .external_lex_state = 11},
  [3604] = {.lex_state = 418},
  [3605] = {.lex_state = 434},
  [3606] = {.lex_state = 434},
  [3607] = {.lex_state = 418},
  [3608] = {.lex_state = 0, .external_lex_state = 11},
  [3609] = {.lex_state = 0, .external_lex_state = 11},
  [3610] = {.lex_state = 418},
  [3611] = {.lex_state = 418},
  [3612] = {.lex_state = 434},
  [3613] = {.lex_state = 418},
  [3614] = {.lex_state = 434},
  [3615] = {.lex_state = 0, .external_lex_state = 11},
  [3616] = {.lex_state = 434},
  [3617] = {.lex_state = 434},
  [3618] = {.lex_state = 434},
  [3619] = {.lex_state = 434},
  [3620] = {.lex_state = 418},
  [3621] = {.lex_state = 418},
  [3622] = {.lex_state = 0, .external_lex_state = 11},
  [3623] = {.lex_state = 418},
  [3624] = {.lex_state = 436},
  [3625] = {.lex_state = 434},
  [3626] = {.lex_state = 434},
  [3627] = {.lex_state = 0, .external_lex_state = 11},
  [3628] = {.lex_state = 418},
  [3629] = {.lex_state = 0, .external_lex_state = 11},
  [3630] = {.lex_state = 418},
  [3631] = {.lex_state = 434},
  [3632] = {.lex_state = 434},
  [3633] = {.lex_state = 434},
  [3634] = {.lex_state = 434},
  [3635] = {.lex_state = 418},
  [3636] = {.lex_state = 434},
  [3637] = {.lex_state = 0},
  [3638] = {.lex_state = 399},
  [3639] = {.lex_state = 434},
  [3640] = {.lex_state = 418},
  [3641] = {.lex_state = 434},
  [3642] = {.lex_state = 0},
  [3643] = {.lex_state = 0},
  [3644] = {.lex_state = 434},
  [3645] = {.lex_state = 434},
  [3646] = {.lex_state = 434},
  [3647] = {.lex_state = 434},
  [3648] = {.lex_state = 434},
  [3649] = {.lex_state = 399},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 434},
  [3653] = {.lex_state = 418},
  [3654] = {.lex_state = 434},
  [3655] = {.lex_state = 0, .external_lex_state = 2},
  [3656] = {.lex_state = 0},
  [3657] = {.lex_state = 0},
  [3658] = {.lex_state = 418},
  [3659] = {.lex_state = 434},
  [3660] = {.lex_state = 418},
  [3661] = {.lex_state = 434},
  [3662] = {.lex_state = 434},
  [3663] = {.lex_state = 434},
  [3664] = {.lex_state = 0},
  [3665] = {.lex_state = 0},
  [3666] = {.lex_state = 434},
  [3667] = {.lex_state = 436},
  [3668] = {.lex_state = 434},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 0},
  [3671] = {.lex_state = 0},
  [3672] = {.lex_state = 0},
  [3673] = {.lex_state = 434},
  [3674] = {.lex_state = 0},
  [3675] = {.lex_state = 0},
  [3676] = {.lex_state = 0},
  [3677] = {.lex_state = 0},
  [3678] = {.lex_state = 434},
  [3679] = {.lex_state = 434},
  [3680] = {.lex_state = 399},
  [3681] = {.lex_state = 399},
  [3682] = {.lex_state = 434},
  [3683] = {.lex_state = 0},
  [3684] = {.lex_state = 399},
  [3685] = {.lex_state = 399},
  [3686] = {.lex_state = 0},
  [3687] = {.lex_state = 399},
  [3688] = {.lex_state = 0},
  [3689] = {.lex_state = 399},
  [3690] = {.lex_state = 399},
  [3691] = {.lex_state = 399},
  [3692] = {.lex_state = 399},
  [3693] = {.lex_state = 434},
  [3694] = {.lex_state = 418, .external_lex_state = 7},
  [3695] = {.lex_state = 434},
  [3696] = {.lex_state = 0},
  [3697] = {.lex_state = 0},
  [3698] = {.lex_state = 399},
  [3699] = {.lex_state = 399},
  [3700] = {.lex_state = 434},
  [3701] = {.lex_state = 399},
  [3702] = {.lex_state = 0, .external_lex_state = 7},
  [3703] = {.lex_state = 418},
  [3704] = {.lex_state = 399},
  [3705] = {.lex_state = 0, .external_lex_state = 7},
  [3706] = {.lex_state = 434},
  [3707] = {.lex_state = 436},
  [3708] = {.lex_state = 0},
  [3709] = {.lex_state = 418},
  [3710] = {.lex_state = 0},
  [3711] = {.lex_state = 0},
  [3712] = {.lex_state = 0, .external_lex_state = 7},
  [3713] = {.lex_state = 0},
  [3714] = {.lex_state = 0},
  [3715] = {.lex_state = 399},
  [3716] = {.lex_state = 0, .external_lex_state = 2},
  [3717] = {.lex_state = 434},
  [3718] = {.lex_state = 418},
  [3719] = {.lex_state = 0},
  [3720] = {.lex_state = 399},
  [3721] = {.lex_state = 399},
  [3722] = {.lex_state = 418},
  [3723] = {.lex_state = 418},
  [3724] = {.lex_state = 0},
  [3725] = {.lex_state = 0},
  [3726] = {.lex_state = 0},
  [3727] = {.lex_state = 0},
  [3728] = {.lex_state = 434},
  [3729] = {.lex_state = 418, .external_lex_state = 7},
  [3730] = {.lex_state = 434},
  [3731] = {.lex_state = 425},
  [3732] = {.lex_state = 425},
  [3733] = {.lex_state = 418},
  [3734] = {.lex_state = 418, .external_lex_state = 7},
  [3735] = {.lex_state = 0, .external_lex_state = 10},
  [3736] = {.lex_state = 425},
  [3737] = {.lex_state = 418},
  [3738] = {.lex_state = 0, .external_lex_state = 9},
  [3739] = {.lex_state = 425},
  [3740] = {.lex_state = 425},
  [3741] = {.lex_state = 0, .external_lex_state = 10},
  [3742] = {.lex_state = 0, .external_lex_state = 7},
  [3743] = {.lex_state = 418},
  [3744] = {.lex_state = 418, .external_lex_state = 7},
  [3745] = {.lex_state = 418, .external_lex_state = 7},
  [3746] = {.lex_state = 418},
  [3747] = {.lex_state = 418},
  [3748] = {.lex_state = 0, .external_lex_state = 9},
  [3749] = {.lex_state = 0, .external_lex_state = 10},
  [3750] = {.lex_state = 0, .external_lex_state = 9},
  [3751] = {.lex_state = 0, .external_lex_state = 10},
  [3752] = {.lex_state = 0, .external_lex_state = 10},
  [3753] = {.lex_state = 0, .external_lex_state = 9},
  [3754] = {.lex_state = 418},
  [3755] = {.lex_state = 425},
  [3756] = {.lex_state = 418},
  [3757] = {.lex_state = 418},
  [3758] = {.lex_state = 0, .external_lex_state = 10},
  [3759] = {.lex_state = 0, .external_lex_state = 10},
  [3760] = {.lex_state = 0, .external_lex_state = 9},
  [3761] = {.lex_state = 418},
  [3762] = {.lex_state = 0, .external_lex_state = 12},
  [3763] = {.lex_state = 0, .external_lex_state = 7},
  [3764] = {.lex_state = 425},
  [3765] = {.lex_state = 0, .external_lex_state = 9},
  [3766] = {.lex_state = 0, .external_lex_state = 7},
  [3767] = {.lex_state = 0, .external_lex_state = 10},
  [3768] = {.lex_state = 425},
  [3769] = {.lex_state = 0, .external_lex_state = 10},
  [3770] = {.lex_state = 425},
  [3771] = {.lex_state = 0, .external_lex_state = 9},
  [3772] = {.lex_state = 418},
  [3773] = {.lex_state = 0, .external_lex_state = 9},
  [3774] = {.lex_state = 425},
  [3775] = {.lex_state = 0, .external_lex_state = 9},
  [3776] = {.lex_state = 418},
  [3777] = {.lex_state = 425},
  [3778] = {.lex_state = 0, .external_lex_state = 7},
  [3779] = {.lex_state = 418},
  [3780] = {.lex_state = 425},
  [3781] = {.lex_state = 0, .external_lex_state = 10},
  [3782] = {.lex_state = 0, .external_lex_state = 10},
  [3783] = {.lex_state = 0, .external_lex_state = 9},
  [3784] = {.lex_state = 418},
  [3785] = {.lex_state = 0, .external_lex_state = 7},
  [3786] = {.lex_state = 425},
  [3787] = {.lex_state = 0},
  [3788] = {.lex_state = 0, .external_lex_state = 7},
  [3789] = {.lex_state = 0, .external_lex_state = 12},
  [3790] = {.lex_state = 0},
  [3791] = {.lex_state = 425},
  [3792] = {.lex_state = 0, .external_lex_state = 7},
  [3793] = {.lex_state = 0, .external_lex_state = 7},
  [3794] = {.lex_state = 418},
  [3795] = {.lex_state = 0, .external_lex_state = 9},
  [3796] = {.lex_state = 0, .external_lex_state = 10},
  [3797] = {.lex_state = 399},
  [3798] = {.lex_state = 418},
  [3799] = {.lex_state = 425},
  [3800] = {.lex_state = 0, .external_lex_state = 9},
  [3801] = {.lex_state = 0, .external_lex_state = 7},
  [3802] = {.lex_state = 418},
  [3803] = {.lex_state = 0, .external_lex_state = 10},
  [3804] = {.lex_state = 0, .external_lex_state = 10},
  [3805] = {.lex_state = 0, .external_lex_state = 10},
  [3806] = {.lex_state = 0, .external_lex_state = 9},
  [3807] = {.lex_state = 418},
  [3808] = {.lex_state = 0, .external_lex_state = 7},
  [3809] = {.lex_state = 0, .external_lex_state = 7},
  [3810] = {.lex_state = 425},
  [3811] = {.lex_state = 0, .external_lex_state = 9},
  [3812] = {.lex_state = 0, .external_lex_state = 10},
  [3813] = {.lex_state = 425},
  [3814] = {.lex_state = 0, .external_lex_state = 9},
  [3815] = {.lex_state = 418},
  [3816] = {.lex_state = 0, .external_lex_state = 9},
  [3817] = {.lex_state = 425},
  [3818] = {.lex_state = 0},
  [3819] = {.lex_state = 0},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 408},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 0},
  [3824] = {.lex_state = 0},
  [3825] = {.lex_state = 0},
  [3826] = {.lex_state = 422, .external_lex_state = 13},
  [3827] = {.lex_state = 0},
  [3828] = {.lex_state = 418},
  [3829] = {.lex_state = 418},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 0},
  [3833] = {.lex_state = 0},
  [3834] = {.lex_state = 0},
  [3835] = {.lex_state = 408},
  [3836] = {.lex_state = 408},
  [3837] = {.lex_state = 0},
  [3838] = {.lex_state = 0},
  [3839] = {.lex_state = 0, .external_lex_state = 2},
  [3840] = {.lex_state = 0},
  [3841] = {.lex_state = 0},
  [3842] = {.lex_state = 418},
  [3843] = {.lex_state = 0},
  [3844] = {.lex_state = 0},
  [3845] = {.lex_state = 0},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 422},
  [3848] = {.lex_state = 0},
  [3849] = {.lex_state = 0},
  [3850] = {.lex_state = 0},
  [3851] = {.lex_state = 408},
  [3852] = {.lex_state = 408},
  [3853] = {.lex_state = 418},
  [3854] = {.lex_state = 0},
  [3855] = {.lex_state = 0},
  [3856] = {.lex_state = 0},
  [3857] = {.lex_state = 0},
  [3858] = {.lex_state = 0},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 418},
  [3861] = {.lex_state = 0},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 418},
  [3864] = {.lex_state = 0},
  [3865] = {.lex_state = 0},
  [3866] = {.lex_state = 0},
  [3867] = {.lex_state = 0},
  [3868] = {.lex_state = 0},
  [3869] = {.lex_state = 422},
  [3870] = {.lex_state = 0},
  [3871] = {.lex_state = 0},
  [3872] = {.lex_state = 408},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 408},
  [3875] = {.lex_state = 418},
  [3876] = {.lex_state = 0},
  [3877] = {.lex_state = 0},
  [3878] = {.lex_state = 418},
  [3879] = {.lex_state = 418},
  [3880] = {.lex_state = 0},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 418},
  [3883] = {.lex_state = 418},
  [3884] = {.lex_state = 422},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 0},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 408},
  [3890] = {.lex_state = 0},
  [3891] = {.lex_state = 0},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 418},
  [3894] = {.lex_state = 0},
  [3895] = {.lex_state = 418},
  [3896] = {.lex_state = 418},
  [3897] = {.lex_state = 418},
  [3898] = {.lex_state = 418},
  [3899] = {.lex_state = 408},
  [3900] = {.lex_state = 408},
  [3901] = {.lex_state = 408},
  [3902] = {.lex_state = 408},
  [3903] = {.lex_state = 0},
  [3904] = {.lex_state = 434},
  [3905] = {.lex_state = 434},
  [3906] = {.lex_state = 422},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 0},
  [3909] = {.lex_state = 422},
  [3910] = {.lex_state = 0},
  [3911] = {.lex_state = 0},
  [3912] = {.lex_state = 0},
  [3913] = {.lex_state = 0},
  [3914] = {.lex_state = 0},
  [3915] = {.lex_state = 0},
  [3916] = {.lex_state = 0},
  [3917] = {.lex_state = 0},
  [3918] = {.lex_state = 418},
  [3919] = {.lex_state = 418},
  [3920] = {.lex_state = 0},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 0},
  [3923] = {.lex_state = 418},
  [3924] = {.lex_state = 0},
  [3925] = {.lex_state = 0},
  [3926] = {.lex_state = 408},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0, .external_lex_state = 2},
  [3929] = {.lex_state = 0},
  [3930] = {.lex_state = 418},
  [3931] = {.lex_state = 418},
  [3932] = {.lex_state = 408},
  [3933] = {.lex_state = 422},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 0},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 418},
  [3938] = {.lex_state = 418},
  [3939] = {.lex_state = 422, .external_lex_state = 13},
  [3940] = {.lex_state = 418},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 418},
  [3943] = {.lex_state = 418},
  [3944] = {.lex_state = 0},
  [3945] = {.lex_state = 418},
  [3946] = {.lex_state = 418},
  [3947] = {.lex_state = 418},
  [3948] = {.lex_state = 0},
  [3949] = {.lex_state = 0},
  [3950] = {.lex_state = 418},
  [3951] = {.lex_state = 418},
  [3952] = {.lex_state = 422},
  [3953] = {.lex_state = 0},
  [3954] = {.lex_state = 422},
  [3955] = {.lex_state = 422},
  [3956] = {.lex_state = 418},
  [3957] = {.lex_state = 0},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 0},
  [3960] = {.lex_state = 0},
  [3961] = {.lex_state = 0},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 418},
  [3964] = {.lex_state = 418},
  [3965] = {.lex_state = 418},
  [3966] = {.lex_state = 418},
  [3967] = {.lex_state = 0},
  [3968] = {.lex_state = 422},
  [3969] = {.lex_state = 418},
  [3970] = {.lex_state = 418},
  [3971] = {.lex_state = 0},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 0},
  [3974] = {.lex_state = 0},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 418},
  [3978] = {.lex_state = 418},
  [3979] = {.lex_state = 418},
  [3980] = {.lex_state = 0},
  [3981] = {.lex_state = 0},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 418},
  [3984] = {.lex_state = 418},
  [3985] = {.lex_state = 418},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 0},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 0, .external_lex_state = 2},
  [3995] = {.lex_state = 418},
  [3996] = {.lex_state = 418},
  [3997] = {.lex_state = 422},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 0},
  [4001] = {.lex_state = 418},
  [4002] = {.lex_state = 418},
  [4003] = {.lex_state = 422},
  [4004] = {.lex_state = 0},
  [4005] = {.lex_state = 0},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 418},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 0},
  [4013] = {.lex_state = 422, .external_lex_state = 13},
  [4014] = {.lex_state = 0},
  [4015] = {.lex_state = 422},
  [4016] = {.lex_state = 0},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 0},
  [4019] = {.lex_state = 0},
  [4020] = {.lex_state = 0},
  [4021] = {.lex_state = 418},
  [4022] = {.lex_state = 418},
  [4023] = {.lex_state = 418},
  [4024] = {.lex_state = 0},
  [4025] = {.lex_state = 0},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 422},
  [4028] = {.lex_state = 0},
  [4029] = {.lex_state = 418},
  [4030] = {.lex_state = 418},
  [4031] = {.lex_state = 0},
  [4032] = {.lex_state = 0},
  [4033] = {.lex_state = 418},
  [4034] = {.lex_state = 0},
  [4035] = {.lex_state = 418},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 0},
  [4038] = {.lex_state = 418},
  [4039] = {.lex_state = 418},
  [4040] = {.lex_state = 422},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 418},
  [4043] = {.lex_state = 0},
  [4044] = {.lex_state = 422},
  [4045] = {.lex_state = 0},
  [4046] = {.lex_state = 0},
  [4047] = {.lex_state = 0},
  [4048] = {.lex_state = 0},
  [4049] = {.lex_state = 418},
  [4050] = {.lex_state = 418},
  [4051] = {.lex_state = 0},
  [4052] = {.lex_state = 0},
  [4053] = {.lex_state = 0},
  [4054] = {.lex_state = 0},
  [4055] = {.lex_state = 0},
  [4056] = {.lex_state = 418},
  [4057] = {.lex_state = 418},
  [4058] = {.lex_state = 422},
  [4059] = {.lex_state = 0},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 0},
  [4062] = {.lex_state = 0},
  [4063] = {.lex_state = 0},
  [4064] = {.lex_state = 0},
  [4065] = {.lex_state = 0},
  [4066] = {.lex_state = 0},
  [4067] = {.lex_state = 422},
  [4068] = {.lex_state = 0, .external_lex_state = 7},
  [4069] = {.lex_state = 0},
  [4070] = {.lex_state = 408},
  [4071] = {.lex_state = 0, .external_lex_state = 7},
  [4072] = {.lex_state = 0, .external_lex_state = 2},
  [4073] = {.lex_state = 0, .external_lex_state = 7},
  [4074] = {.lex_state = 0},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 0},
  [4077] = {.lex_state = 0},
  [4078] = {.lex_state = 418},
  [4079] = {.lex_state = 418},
  [4080] = {.lex_state = 0},
  [4081] = {.lex_state = 0},
  [4082] = {.lex_state = 0},
  [4083] = {.lex_state = 0},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 0},
  [4086] = {.lex_state = 418},
  [4087] = {.lex_state = 0},
  [4088] = {.lex_state = 422},
  [4089] = {.lex_state = 0},
  [4090] = {.lex_state = 418},
  [4091] = {.lex_state = 418},
  [4092] = {.lex_state = 418},
  [4093] = {.lex_state = 0},
  [4094] = {.lex_state = 0},
  [4095] = {.lex_state = 0},
  [4096] = {.lex_state = 418},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 422},
  [4099] = {.lex_state = 418},
  [4100] = {.lex_state = 418},
  [4101] = {.lex_state = 418},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 0},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 418},
  [4106] = {.lex_state = 0},
  [4107] = {.lex_state = 0},
  [4108] = {.lex_state = 0},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 418},
  [4111] = {.lex_state = 418},
  [4112] = {.lex_state = 0},
  [4113] = {.lex_state = 0},
  [4114] = {.lex_state = 422},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0, .external_lex_state = 7},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 418},
  [4120] = {.lex_state = 418},
  [4121] = {.lex_state = 0, .external_lex_state = 7},
  [4122] = {.lex_state = 0, .external_lex_state = 7},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 0},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0, .external_lex_state = 7},
  [4127] = {.lex_state = 0},
  [4128] = {.lex_state = 0},
  [4129] = {.lex_state = 0},
  [4130] = {.lex_state = 418},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 0},
  [4133] = {.lex_state = 0},
  [4134] = {.lex_state = 422},
  [4135] = {.lex_state = 418},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 0},
  [4138] = {.lex_state = 0},
  [4139] = {.lex_state = 0},
  [4140] = {.lex_state = 0},
  [4141] = {.lex_state = 0},
  [4142] = {.lex_state = 418},
  [4143] = {.lex_state = 418},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 422},
  [4146] = {.lex_state = 418},
  [4147] = {.lex_state = 0, .external_lex_state = 7},
  [4148] = {.lex_state = 418},
  [4149] = {.lex_state = 418},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 0},
  [4153] = {.lex_state = 418},
  [4154] = {.lex_state = 422},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 0},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 418},
  [4161] = {.lex_state = 418},
  [4162] = {.lex_state = 0},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 418},
  [4165] = {.lex_state = 0},
  [4166] = {.lex_state = 0},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 425},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 0, .external_lex_state = 7},
  [4173] = {.lex_state = 0, .external_lex_state = 7},
  [4174] = {.lex_state = 0},
  [4175] = {.lex_state = 418},
  [4176] = {.lex_state = 418},
  [4177] = {.lex_state = 0},
  [4178] = {.lex_state = 425},
  [4179] = {.lex_state = 418},
  [4180] = {.lex_state = 418},
  [4181] = {.lex_state = 422},
  [4182] = {.lex_state = 0},
  [4183] = {.lex_state = 0},
  [4184] = {.lex_state = 408},
  [4185] = {.lex_state = 0, .external_lex_state = 7},
  [4186] = {.lex_state = 0},
  [4187] = {.lex_state = 0},
  [4188] = {.lex_state = 0},
  [4189] = {.lex_state = 0, .external_lex_state = 2},
  [4190] = {.lex_state = 0},
  [4191] = {.lex_state = 418},
  [4192] = {.lex_state = 408},
  [4193] = {.lex_state = 425},
  [4194] = {.lex_state = 0},
  [4195] = {.lex_state = 0},
  [4196] = {.lex_state = 0},
  [4197] = {.lex_state = 0},
  [4198] = {.lex_state = 0},
  [4199] = {.lex_state = 0},
  [4200] = {.lex_state = 422},
  [4201] = {.lex_state = 434},
  [4202] = {.lex_state = 0},
  [4203] = {.lex_state = 422},
  [4204] = {.lex_state = 0},
  [4205] = {.lex_state = 0},
  [4206] = {.lex_state = 422},
  [4207] = {.lex_state = 0},
  [4208] = {.lex_state = 0},
  [4209] = {.lex_state = 0},
  [4210] = {.lex_state = 0},
  [4211] = {.lex_state = 0},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 0},
  [4214] = {.lex_state = 0},
  [4215] = {.lex_state = 0},
  [4216] = {.lex_state = 0},
  [4217] = {.lex_state = 418},
  [4218] = {.lex_state = 418},
  [4219] = {.lex_state = 418},
  [4220] = {.lex_state = 408},
  [4221] = {.lex_state = 0},
  [4222] = {.lex_state = 418},
  [4223] = {.lex_state = 0},
  [4224] = {.lex_state = 418},
  [4225] = {.lex_state = 422},
  [4226] = {.lex_state = 418},
  [4227] = {.lex_state = 408},
  [4228] = {.lex_state = 408},
  [4229] = {.lex_state = 418},
  [4230] = {.lex_state = 0},
  [4231] = {.lex_state = 0, .external_lex_state = 7},
  [4232] = {.lex_state = 422},
  [4233] = {.lex_state = 0},
  [4234] = {.lex_state = 0},
  [4235] = {.lex_state = 408},
  [4236] = {.lex_state = 0},
  [4237] = {.lex_state = 0},
  [4238] = {.lex_state = 0},
  [4239] = {.lex_state = 0},
  [4240] = {.lex_state = 0},
  [4241] = {.lex_state = 422},
  [4242] = {.lex_state = 0},
  [4243] = {.lex_state = 0},
  [4244] = {.lex_state = 0},
  [4245] = {.lex_state = 0},
  [4246] = {.lex_state = 0},
  [4247] = {.lex_state = 0},
  [4248] = {.lex_state = 0},
  [4249] = {.lex_state = 418},
  [4250] = {.lex_state = 0},
  [4251] = {.lex_state = 0},
  [4252] = {.lex_state = 0},
  [4253] = {.lex_state = 0},
  [4254] = {.lex_state = 0},
  [4255] = {.lex_state = 0},
  [4256] = {.lex_state = 422},
  [4257] = {.lex_state = 418},
  [4258] = {.lex_state = 418},
  [4259] = {.lex_state = 418},
  [4260] = {.lex_state = 0, .external_lex_state = 7},
  [4261] = {.lex_state = 0},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 418},
  [4264] = {.lex_state = 418},
  [4265] = {.lex_state = 0},
  [4266] = {.lex_state = 418},
  [4267] = {.lex_state = 418},
  [4268] = {.lex_state = 0},
  [4269] = {.lex_state = 418},
  [4270] = {.lex_state = 436},
  [4271] = {.lex_state = 0, .external_lex_state = 9},
  [4272] = {.lex_state = 436},
  [4273] = {.lex_state = 0, .external_lex_state = 10},
  [4274] = {.lex_state = 0},
  [4275] = {.lex_state = 418},
  [4276] = {.lex_state = 418},
  [4277] = {.lex_state = 418},
  [4278] = {.lex_state = 418},
  [4279] = {.lex_state = 418},
  [4280] = {.lex_state = 418},
  [4281] = {.lex_state = 418},
  [4282] = {.lex_state = 418},
  [4283] = {.lex_state = 418},
  [4284] = {.lex_state = 0, .external_lex_state = 7},
  [4285] = {.lex_state = 0, .external_lex_state = 7},
  [4286] = {.lex_state = 418},
  [4287] = {.lex_state = 418},
  [4288] = {.lex_state = 418},
  [4289] = {.lex_state = 418},
  [4290] = {.lex_state = 0},
  [4291] = {.lex_state = 0},
  [4292] = {.lex_state = 418},
  [4293] = {.lex_state = 0},
  [4294] = {.lex_state = 418},
  [4295] = {.lex_state = 0},
  [4296] = {.lex_state = 418},
  [4297] = {.lex_state = 0},
  [4298] = {.lex_state = 418},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 418},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 418},
  [4303] = {.lex_state = 418},
  [4304] = {.lex_state = 418},
  [4305] = {.lex_state = 418},
  [4306] = {.lex_state = 418},
  [4307] = {.lex_state = 418},
  [4308] = {.lex_state = 0},
  [4309] = {.lex_state = 418},
  [4310] = {.lex_state = 418},
  [4311] = {.lex_state = 418},
  [4312] = {.lex_state = 0},
  [4313] = {.lex_state = 418},
  [4314] = {.lex_state = 422, .external_lex_state = 13},
  [4315] = {.lex_state = 418},
  [4316] = {.lex_state = 418},
  [4317] = {.lex_state = 418},
  [4318] = {.lex_state = 418},
  [4319] = {.lex_state = 418},
  [4320] = {.lex_state = 436},
  [4321] = {.lex_state = 0},
  [4322] = {.lex_state = 408},
  [4323] = {.lex_state = 0},
  [4324] = {.lex_state = 408},
  [4325] = {.lex_state = 438},
  [4326] = {.lex_state = 408},
  [4327] = {.lex_state = 418},
  [4328] = {.lex_state = 418},
  [4329] = {.lex_state = 408},
  [4330] = {.lex_state = 418},
  [4331] = {.lex_state = 418},
  [4332] = {.lex_state = 408},
  [4333] = {.lex_state = 408},
  [4334] = {.lex_state = 418},
  [4335] = {.lex_state = 418},
  [4336] = {.lex_state = 0, .external_lex_state = 7},
  [4337] = {.lex_state = 418},
  [4338] = {.lex_state = 418},
  [4339] = {.lex_state = 418},
  [4340] = {.lex_state = 418},
  [4341] = {.lex_state = 408},
  [4342] = {.lex_state = 418},
  [4343] = {.lex_state = 408},
  [4344] = {.lex_state = 408},
  [4345] = {.lex_state = 0},
  [4346] = {.lex_state = 0},
  [4347] = {.lex_state = 418},
  [4348] = {.lex_state = 408},
  [4349] = {.lex_state = 418},
  [4350] = {.lex_state = 0, .external_lex_state = 7},
  [4351] = {.lex_state = 418},
  [4352] = {.lex_state = 436},
  [4353] = {.lex_state = 418},
  [4354] = {.lex_state = 408},
  [4355] = {.lex_state = 418},
  [4356] = {.lex_state = 418},
  [4357] = {.lex_state = 408},
  [4358] = {.lex_state = 408},
  [4359] = {.lex_state = 408},
  [4360] = {.lex_state = 418},
  [4361] = {.lex_state = 418},
  [4362] = {.lex_state = 0, .external_lex_state = 7},
  [4363] = {.lex_state = 418},
  [4364] = {.lex_state = 418},
  [4365] = {.lex_state = 408},
  [4366] = {.lex_state = 1074},
  [4367] = {.lex_state = 408},
  [4368] = {.lex_state = 0, .external_lex_state = 7},
  [4369] = {.lex_state = 418},
  [4370] = {.lex_state = 0, .external_lex_state = 7},
  [4371] = {.lex_state = 1075},
  [4372] = {.lex_state = 0, .external_lex_state = 7},
  [4373] = {.lex_state = 408},
  [4374] = {.lex_state = 0, .external_lex_state = 7},
  [4375] = {.lex_state = 418},
  [4376] = {.lex_state = 0},
  [4377] = {.lex_state = 418},
  [4378] = {.lex_state = 418},
  [4379] = {.lex_state = 418},
  [4380] = {.lex_state = 418},
  [4381] = {.lex_state = 408},
  [4382] = {.lex_state = 0, .external_lex_state = 7},
  [4383] = {.lex_state = 0, .external_lex_state = 7},
  [4384] = {.lex_state = 418},
  [4385] = {.lex_state = 0, .external_lex_state = 7},
  [4386] = {.lex_state = 0, .external_lex_state = 7},
  [4387] = {.lex_state = 418},
  [4388] = {.lex_state = 408},
  [4389] = {.lex_state = 418},
  [4390] = {.lex_state = 418},
  [4391] = {.lex_state = 418},
  [4392] = {.lex_state = 418},
  [4393] = {.lex_state = 0, .external_lex_state = 7},
  [4394] = {.lex_state = 408},
  [4395] = {.lex_state = 0, .external_lex_state = 7},
  [4396] = {.lex_state = 0, .external_lex_state = 7},
  [4397] = {.lex_state = 0, .external_lex_state = 7},
  [4398] = {.lex_state = 0, .external_lex_state = 7},
  [4399] = {.lex_state = 418},
  [4400] = {.lex_state = 0, .external_lex_state = 7},
  [4401] = {.lex_state = 0, .external_lex_state = 7},
  [4402] = {.lex_state = 0},
  [4403] = {.lex_state = 418},
  [4404] = {.lex_state = 418},
  [4405] = {.lex_state = 0, .external_lex_state = 7},
  [4406] = {.lex_state = 408},
  [4407] = {.lex_state = 0, .external_lex_state = 7},
  [4408] = {.lex_state = 0},
  [4409] = {.lex_state = 0},
  [4410] = {.lex_state = 0},
  [4411] = {.lex_state = 418},
  [4412] = {.lex_state = 0},
  [4413] = {.lex_state = 0},
  [4414] = {.lex_state = 0},
  [4415] = {.lex_state = 418},
  [4416] = {.lex_state = 418},
  [4417] = {.lex_state = 0},
  [4418] = {.lex_state = 0},
  [4419] = {.lex_state = 0},
  [4420] = {.lex_state = 0},
  [4421] = {.lex_state = 418},
  [4422] = {.lex_state = 0},
  [4423] = {.lex_state = 418},
  [4424] = {.lex_state = 408},
  [4425] = {.lex_state = 0},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 418},
  [4428] = {.lex_state = 418},
  [4429] = {.lex_state = 0},
  [4430] = {.lex_state = 0},
  [4431] = {.lex_state = 418},
  [4432] = {.lex_state = 0},
  [4433] = {.lex_state = 0},
  [4434] = {.lex_state = 408},
  [4435] = {.lex_state = 418},
  [4436] = {.lex_state = 0},
  [4437] = {.lex_state = 0},
  [4438] = {.lex_state = 0},
  [4439] = {.lex_state = 418},
  [4440] = {.lex_state = 418},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 0},
  [4444] = {.lex_state = 0},
  [4445] = {.lex_state = 0},
  [4446] = {.lex_state = 0},
  [4447] = {.lex_state = 418},
  [4448] = {.lex_state = 0},
  [4449] = {.lex_state = 0},
  [4450] = {.lex_state = 0},
  [4451] = {.lex_state = 418},
  [4452] = {.lex_state = 418},
  [4453] = {.lex_state = 0},
  [4454] = {.lex_state = 0},
  [4455] = {.lex_state = 408},
  [4456] = {.lex_state = 0},
  [4457] = {.lex_state = 0},
  [4458] = {.lex_state = 0},
  [4459] = {.lex_state = 418},
  [4460] = {.lex_state = 418},
  [4461] = {.lex_state = 0},
  [4462] = {.lex_state = 0},
  [4463] = {.lex_state = 418},
  [4464] = {.lex_state = 418},
  [4465] = {.lex_state = 408},
  [4466] = {.lex_state = 0},
  [4467] = {.lex_state = 0},
  [4468] = {.lex_state = 0},
  [4469] = {.lex_state = 0},
  [4470] = {.lex_state = 0},
  [4471] = {.lex_state = 418},
  [4472] = {.lex_state = 0},
  [4473] = {.lex_state = 0},
  [4474] = {.lex_state = 0},
  [4475] = {.lex_state = 418},
  [4476] = {.lex_state = 418},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 0},
  [4479] = {.lex_state = 0},
  [4480] = {.lex_state = 0},
  [4481] = {.lex_state = 0},
  [4482] = {.lex_state = 0},
  [4483] = {.lex_state = 418},
  [4484] = {.lex_state = 0},
  [4485] = {.lex_state = 408},
  [4486] = {.lex_state = 0},
  [4487] = {.lex_state = 418},
  [4488] = {.lex_state = 418},
  [4489] = {.lex_state = 0},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 418},
  [4492] = {.lex_state = 0},
  [4493] = {.lex_state = 0},
  [4494] = {.lex_state = 408},
  [4495] = {.lex_state = 418},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 0},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 418},
  [4500] = {.lex_state = 418},
  [4501] = {.lex_state = 0},
  [4502] = {.lex_state = 0},
  [4503] = {.lex_state = 0},
  [4504] = {.lex_state = 418},
  [4505] = {.lex_state = 0},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 418},
  [4508] = {.lex_state = 0},
  [4509] = {.lex_state = 0},
  [4510] = {.lex_state = 408},
  [4511] = {.lex_state = 418},
  [4512] = {.lex_state = 418},
  [4513] = {.lex_state = 418},
  [4514] = {.lex_state = 0},
  [4515] = {.lex_state = 1074},
  [4516] = {.lex_state = 418},
  [4517] = {.lex_state = 418},
  [4518] = {.lex_state = 418},
  [4519] = {.lex_state = 418},
  [4520] = {.lex_state = 418},
  [4521] = {.lex_state = 418},
  [4522] = {.lex_state = 408},
  [4523] = {.lex_state = 418},
  [4524] = {.lex_state = 418},
  [4525] = {.lex_state = 408},
  [4526] = {.lex_state = 418},
  [4527] = {.lex_state = 408},
  [4528] = {.lex_state = 418},
  [4529] = {.lex_state = 418},
  [4530] = {.lex_state = 418},
  [4531] = {.lex_state = 418},
  [4532] = {.lex_state = 418},
  [4533] = {.lex_state = 418},
  [4534] = {.lex_state = 418},
  [4535] = {.lex_state = 418},
  [4536] = {.lex_state = 418},
  [4537] = {.lex_state = 418},
  [4538] = {.lex_state = 418},
  [4539] = {.lex_state = 418},
  [4540] = {.lex_state = 418},
  [4541] = {.lex_state = 418},
  [4542] = {.lex_state = 418},
  [4543] = {.lex_state = 436},
  [4544] = {.lex_state = 418},
  [4545] = {.lex_state = 418},
  [4546] = {.lex_state = 418},
  [4547] = {.lex_state = 418},
  [4548] = {.lex_state = 418},
  [4549] = {.lex_state = 418},
  [4550] = {.lex_state = 418},
  [4551] = {.lex_state = 418},
  [4552] = {.lex_state = 418},
  [4553] = {.lex_state = 408},
  [4554] = {.lex_state = 408},
  [4555] = {.lex_state = 418},
  [4556] = {.lex_state = 418},
  [4557] = {.lex_state = 418},
  [4558] = {.lex_state = 0},
  [4559] = {.lex_state = 408},
  [4560] = {.lex_state = 408},
  [4561] = {.lex_state = 408},
  [4562] = {.lex_state = 408},
  [4563] = {.lex_state = 0},
  [4564] = {.lex_state = 438},
  [4565] = {.lex_state = 438},
  [4566] = {.lex_state = 408},
  [4567] = {.lex_state = 0},
  [4568] = {.lex_state = 418},
  [4569] = {.lex_state = 408},
  [4570] = {.lex_state = 408},
  [4571] = {.lex_state = 1075},
  [4572] = {.lex_state = 408},
  [4573] = {.lex_state = 408},
  [4574] = {.lex_state = 408},
  [4575] = {.lex_state = 408},
  [4576] = {.lex_state = 408},
  [4577] = {.lex_state = 0},
  [4578] = {.lex_state = 408},
  [4579] = {.lex_state = 408},
  [4580] = {.lex_state = 0},
  [4581] = {.lex_state = 0},
  [4582] = {.lex_state = 408},
  [4583] = {.lex_state = 438},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 408},
  [4586] = {.lex_state = 438},
  [4587] = {.lex_state = 438},
  [4588] = {.lex_state = 408},
  [4589] = {.lex_state = 408},
  [4590] = {.lex_state = 408},
  [4591] = {.lex_state = 408},
  [4592] = {.lex_state = 438},
  [4593] = {.lex_state = 408},
  [4594] = {.lex_state = 0},
  [4595] = {.lex_state = 0},
  [4596] = {.lex_state = 408},
  [4597] = {.lex_state = 438},
  [4598] = {.lex_state = 418},
  [4599] = {.lex_state = 418},
  [4600] = {.lex_state = 438},
  [4601] = {.lex_state = 408},
  [4602] = {.lex_state = 418},
  [4603] = {.lex_state = 418},
  [4604] = {.lex_state = 408},
  [4605] = {.lex_state = 418},
  [4606] = {.lex_state = 418},
  [4607] = {.lex_state = 438},
  [4608] = {.lex_state = 418},
  [4609] = {.lex_state = 418},
  [4610] = {.lex_state = 438},
  [4611] = {.lex_state = 418},
  [4612] = {.lex_state = 418},
  [4613] = {.lex_state = 408},
  [4614] = {.lex_state = 418},
  [4615] = {.lex_state = 418},
  [4616] = {.lex_state = 438},
  [4617] = {.lex_state = 418},
  [4618] = {.lex_state = 418},
  [4619] = {.lex_state = 438},
  [4620] = {.lex_state = 418},
  [4621] = {.lex_state = 418},
  [4622] = {.lex_state = 408},
  [4623] = {.lex_state = 418},
  [4624] = {.lex_state = 418},
  [4625] = {.lex_state = 408},
  [4626] = {.lex_state = 418},
  [4627] = {.lex_state = 418},
  [4628] = {.lex_state = 438},
  [4629] = {.lex_state = 418},
  [4630] = {.lex_state = 418},
  [4631] = {.lex_state = 438},
  [4632] = {.lex_state = 418},
  [4633] = {.lex_state = 418},
  [4634] = {.lex_state = 408},
  [4635] = {.lex_state = 418},
  [4636] = {.lex_state = 418},
  [4637] = {.lex_state = 408},
  [4638] = {.lex_state = 418},
  [4639] = {.lex_state = 418},
  [4640] = {.lex_state = 438},
  [4641] = {.lex_state = 418},
  [4642] = {.lex_state = 418},
  [4643] = {(TSStateId)(-1)},
  [4644] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_extramodular_text = 0,
  ts_external_token__block_comment_text = 1,
  ts_external_token__indent = 2,
  ts_external_token_bullet_conj = 3,
  ts_external_token_bullet_disj = 4,
  ts_external_token__dedent = 5,
  ts_external_token__begin_proof = 6,
  ts_external_token__begin_proof_step = 7,
  ts_external_token_proof_keyword = 8,
  ts_external_token_by_keyword = 9,
  ts_external_token_obvious_keyword = 10,
  ts_external_token_omitted_keyword = 11,
  ts_external_token_qed_keyword = 12,
  ts_external_token_error_sentinel = 13,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_extramodular_text] = sym_extramodular_text,
  [ts_external_token__block_comment_text] = sym__block_comment_text,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token_bullet_conj] = sym_bullet_conj,
  [ts_external_token_bullet_disj] = sym_bullet_disj,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__begin_proof] = sym__begin_proof,
  [ts_external_token__begin_proof_step] = sym__begin_proof_step,
  [ts_external_token_proof_keyword] = sym_proof_keyword,
  [ts_external_token_by_keyword] = sym_by_keyword,
  [ts_external_token_obvious_keyword] = sym_obvious_keyword,
  [ts_external_token_omitted_keyword] = sym_omitted_keyword,
  [ts_external_token_qed_keyword] = sym_qed_keyword,
  [ts_external_token_error_sentinel] = sym_error_sentinel,
};

static const bool ts_external_scanner_states[14][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_extramodular_text] = true,
    [ts_external_token__block_comment_text] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
    [ts_external_token_qed_keyword] = true,
    [ts_external_token_error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_extramodular_text] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token_qed_keyword] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__begin_proof_step] = true,
  },
  [6] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [7] = {
    [ts_external_token__begin_proof_step] = true,
  },
  [8] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token__begin_proof_step] = true,
    [ts_external_token_proof_keyword] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [9] = {
    [ts_external_token_bullet_disj] = true,
    [ts_external_token__dedent] = true,
  },
  [10] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token__dedent] = true,
  },
  [11] = {
    [ts_external_token_bullet_conj] = true,
    [ts_external_token_bullet_disj] = true,
  },
  [12] = {
    [ts_external_token__begin_proof] = true,
    [ts_external_token_by_keyword] = true,
    [ts_external_token_obvious_keyword] = true,
    [ts_external_token_omitted_keyword] = true,
  },
  [13] = {
    [ts_external_token__block_comment_text] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(1),
    [sym_single_line] = ACTIONS(1),
    [sym_double_line] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_5] = ACTIONS(1),
    [anon_sym_BSLASHAA] = ACTIONS(1),
    [anon_sym_BSLASHEE] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_6] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_7] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_8] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_9] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_10] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_11] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_UNION] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_ENABLED] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_SUBSET] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_DOMAIN] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_UNCHANGED] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [sym__real_number] = ACTIONS(1),
    [sym__binary_number] = ACTIONS(1),
    [sym__octal_number] = ACTIONS(1),
    [sym__hex_number] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [anon_sym_STRING] = ACTIONS(1),
    [anon_sym_BOOLEAN] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_12] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_13] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_14] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_15] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_16] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_17] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_18] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_19] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_20] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_21] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_22] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_23] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_24] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_25] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_26] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_27] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_28] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_29] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_30] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_31] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_32] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_33] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_34] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_35] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_36] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_37] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_38] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_39] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_40] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_41] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_42] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_43] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_44] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_45] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_46] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_47] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_48] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_49] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_50] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_51] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_52] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_53] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_54] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_55] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_56] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_57] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_58] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_59] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_60] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_61] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_62] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_63] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_64] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_65] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_66] = ACTIONS(1),
    [anon_sym_BANG_BANG] = ACTIONS(1),
    [anon_sym_67] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_68] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_69] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_70] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_71] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_72] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_73] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_74] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_75] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [sym_extramodular_text] = ACTIONS(1),
    [sym__block_comment_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym_bullet_conj] = ACTIONS(1),
    [sym_bullet_disj] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym_proof_keyword] = ACTIONS(1),
    [sym_by_keyword] = ACTIONS(1),
    [sym_obvious_keyword] = ACTIONS(1),
    [sym_omitted_keyword] = ACTIONS(1),
    [sym_qed_keyword] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(4594),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(3994),
    [aux_sym_source_file_repeat1] = STATE(3716),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(7),
    [sym_extramodular_text] = ACTIONS(9),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(3631),
    [sym_exists] = STATE(3631),
    [sym_temporal_forall] = STATE(4348),
    [sym_temporal_exists] = STATE(4348),
    [sym_langle_bracket] = STATE(157),
    [sym_operator_definition] = STATE(3479),
    [sym_function_definition] = STATE(3479),
    [sym_instance] = STATE(4362),
    [sym_subexpr_prefix] = STATE(1199),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2607),
    [sym_bound_nonfix_op] = STATE(2607),
    [sym_module_definition] = STATE(3479),
    [sym__expr] = STATE(1344),
    [sym_prefixed_op] = STATE(2654),
    [sym_number] = STATE(2654),
    [sym__nat_number] = STATE(2648),
    [sym_boolean] = STATE(2654),
    [sym_primitive_value_set] = STATE(2654),
    [sym_label] = STATE(2654),
    [sym_subexpression] = STATE(2654),
    [sym_parentheses] = STATE(2654),
    [sym_bounded_quantification] = STATE(2654),
    [sym_unbounded_quantification] = STATE(2654),
    [sym_choose] = STATE(2654),
    [sym_finite_set_literal] = STATE(2654),
    [sym_set_filter] = STATE(2654),
    [sym_set_map] = STATE(2654),
    [sym_function_evaluation] = STATE(2654),
    [sym_function_literal] = STATE(2654),
    [sym_set_of_functions] = STATE(2654),
    [sym_record_literal] = STATE(2654),
    [sym_set_of_records] = STATE(2654),
    [sym_record_value] = STATE(2654),
    [sym_except] = STATE(2654),
    [sym_prev_func_val] = STATE(2654),
    [sym_tuple_literal] = STATE(2654),
    [sym_step_expr_or_stutter] = STATE(2654),
    [sym_step_expr_no_stutter] = STATE(2654),
    [sym_fairness] = STATE(2654),
    [sym_if_then_else] = STATE(2654),
    [sym_case] = STATE(2654),
    [sym_let_in] = STATE(2654),
    [sym_conj_list] = STATE(2654),
    [sym_disj_list] = STATE(2654),
    [sym_lnot] = STATE(253),
    [sym_union] = STATE(204),
    [sym_powerset] = STATE(204),
    [sym_domain] = STATE(248),
    [sym_negative] = STATE(1017),
    [sym_enabled] = STATE(244),
    [sym_unchanged] = STATE(244),
    [sym_always] = STATE(244),
    [sym_eventually] = STATE(244),
    [sym_standalone_prefix_op_symbol] = STATE(4201),
    [sym_bound_prefix_op] = STATE(2654),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4275),
    [sym_bound_infix_op] = STATE(2654),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4309),
    [sym_bound_postfix_op] = STATE(2654),
    [sym_assume_prove] = STATE(3482),
    [sym_definition_proof_step] = STATE(4362),
    [sym_have_proof_step] = STATE(4362),
    [sym_witness_proof_step] = STATE(4362),
    [sym_take_proof_step] = STATE(4362),
    [sym_suffices_proof_step] = STATE(4362),
    [sym_case_proof_step] = STATE(4362),
    [sym_pick_proof_step] = STATE(4362),
    [sym_use_or_hide] = STATE(4362),
    [sym_proof_step_ref] = STATE(2606),
    [aux_sym_definition_proof_step_repeat1] = STATE(3303),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
    [sym_qed_keyword] = ACTIONS(243),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(3631),
    [sym_exists] = STATE(3631),
    [sym_temporal_forall] = STATE(4348),
    [sym_temporal_exists] = STATE(4348),
    [sym_langle_bracket] = STATE(157),
    [sym_operator_definition] = STATE(3479),
    [sym_function_definition] = STATE(3479),
    [sym_instance] = STATE(4362),
    [sym_subexpr_prefix] = STATE(1199),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2607),
    [sym_bound_nonfix_op] = STATE(2607),
    [sym_module_definition] = STATE(3479),
    [sym__expr] = STATE(1344),
    [sym_prefixed_op] = STATE(2654),
    [sym_number] = STATE(2654),
    [sym__nat_number] = STATE(2648),
    [sym_boolean] = STATE(2654),
    [sym_primitive_value_set] = STATE(2654),
    [sym_label] = STATE(2654),
    [sym_subexpression] = STATE(2654),
    [sym_parentheses] = STATE(2654),
    [sym_bounded_quantification] = STATE(2654),
    [sym_unbounded_quantification] = STATE(2654),
    [sym_choose] = STATE(2654),
    [sym_finite_set_literal] = STATE(2654),
    [sym_set_filter] = STATE(2654),
    [sym_set_map] = STATE(2654),
    [sym_function_evaluation] = STATE(2654),
    [sym_function_literal] = STATE(2654),
    [sym_set_of_functions] = STATE(2654),
    [sym_record_literal] = STATE(2654),
    [sym_set_of_records] = STATE(2654),
    [sym_record_value] = STATE(2654),
    [sym_except] = STATE(2654),
    [sym_prev_func_val] = STATE(2654),
    [sym_tuple_literal] = STATE(2654),
    [sym_step_expr_or_stutter] = STATE(2654),
    [sym_step_expr_no_stutter] = STATE(2654),
    [sym_fairness] = STATE(2654),
    [sym_if_then_else] = STATE(2654),
    [sym_case] = STATE(2654),
    [sym_let_in] = STATE(2654),
    [sym_conj_list] = STATE(2654),
    [sym_disj_list] = STATE(2654),
    [sym_lnot] = STATE(253),
    [sym_union] = STATE(204),
    [sym_powerset] = STATE(204),
    [sym_domain] = STATE(248),
    [sym_negative] = STATE(1017),
    [sym_enabled] = STATE(244),
    [sym_unchanged] = STATE(244),
    [sym_always] = STATE(244),
    [sym_eventually] = STATE(244),
    [sym_standalone_prefix_op_symbol] = STATE(4201),
    [sym_bound_prefix_op] = STATE(2654),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4275),
    [sym_bound_infix_op] = STATE(2654),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4309),
    [sym_bound_postfix_op] = STATE(2654),
    [sym_assume_prove] = STATE(3482),
    [sym_definition_proof_step] = STATE(4362),
    [sym_have_proof_step] = STATE(4362),
    [sym_witness_proof_step] = STATE(4362),
    [sym_take_proof_step] = STATE(4362),
    [sym_suffices_proof_step] = STATE(4362),
    [sym_case_proof_step] = STATE(4362),
    [sym_pick_proof_step] = STATE(4362),
    [sym_use_or_hide] = STATE(4362),
    [sym_proof_step_ref] = STATE(2606),
    [aux_sym_definition_proof_step_repeat1] = STATE(3303),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
    [sym_qed_keyword] = ACTIONS(245),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(3631),
    [sym_exists] = STATE(3631),
    [sym_temporal_forall] = STATE(4348),
    [sym_temporal_exists] = STATE(4348),
    [sym_langle_bracket] = STATE(157),
    [sym_operator_definition] = STATE(3479),
    [sym_function_definition] = STATE(3479),
    [sym_instance] = STATE(4362),
    [sym_subexpr_prefix] = STATE(1199),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2607),
    [sym_bound_nonfix_op] = STATE(2607),
    [sym_module_definition] = STATE(3479),
    [sym__expr] = STATE(1344),
    [sym_prefixed_op] = STATE(2654),
    [sym_number] = STATE(2654),
    [sym__nat_number] = STATE(2648),
    [sym_boolean] = STATE(2654),
    [sym_primitive_value_set] = STATE(2654),
    [sym_label] = STATE(2654),
    [sym_subexpression] = STATE(2654),
    [sym_parentheses] = STATE(2654),
    [sym_bounded_quantification] = STATE(2654),
    [sym_unbounded_quantification] = STATE(2654),
    [sym_choose] = STATE(2654),
    [sym_finite_set_literal] = STATE(2654),
    [sym_set_filter] = STATE(2654),
    [sym_set_map] = STATE(2654),
    [sym_function_evaluation] = STATE(2654),
    [sym_function_literal] = STATE(2654),
    [sym_set_of_functions] = STATE(2654),
    [sym_record_literal] = STATE(2654),
    [sym_set_of_records] = STATE(2654),
    [sym_record_value] = STATE(2654),
    [sym_except] = STATE(2654),
    [sym_prev_func_val] = STATE(2654),
    [sym_tuple_literal] = STATE(2654),
    [sym_step_expr_or_stutter] = STATE(2654),
    [sym_step_expr_no_stutter] = STATE(2654),
    [sym_fairness] = STATE(2654),
    [sym_if_then_else] = STATE(2654),
    [sym_case] = STATE(2654),
    [sym_let_in] = STATE(2654),
    [sym_conj_list] = STATE(2654),
    [sym_disj_list] = STATE(2654),
    [sym_lnot] = STATE(253),
    [sym_union] = STATE(204),
    [sym_powerset] = STATE(204),
    [sym_domain] = STATE(248),
    [sym_negative] = STATE(1017),
    [sym_enabled] = STATE(244),
    [sym_unchanged] = STATE(244),
    [sym_always] = STATE(244),
    [sym_eventually] = STATE(244),
    [sym_standalone_prefix_op_symbol] = STATE(4201),
    [sym_bound_prefix_op] = STATE(2654),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4275),
    [sym_bound_infix_op] = STATE(2654),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4309),
    [sym_bound_postfix_op] = STATE(2654),
    [sym_assume_prove] = STATE(3482),
    [sym_definition_proof_step] = STATE(4362),
    [sym_have_proof_step] = STATE(4362),
    [sym_witness_proof_step] = STATE(4362),
    [sym_take_proof_step] = STATE(4362),
    [sym_suffices_proof_step] = STATE(4362),
    [sym_case_proof_step] = STATE(4362),
    [sym_pick_proof_step] = STATE(4362),
    [sym_use_or_hide] = STATE(4362),
    [sym_proof_step_ref] = STATE(2606),
    [aux_sym_definition_proof_step_repeat1] = STATE(3303),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(31),
    [anon_sym_ASSUME] = ACTIONS(33),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(39),
    [anon_sym_SF_] = ACTIONS(41),
    [anon_sym_WF_] = ACTIONS(41),
    [anon_sym_CHOOSE] = ACTIONS(43),
    [anon_sym_IF] = ACTIONS(45),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_INSTANCE] = ACTIONS(49),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(53),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_HAVE] = ACTIONS(57),
    [anon_sym_TAKE] = ACTIONS(59),
    [anon_sym_HIDE] = ACTIONS(61),
    [anon_sym_USE] = ACTIONS(63),
    [anon_sym_DEFINE] = ACTIONS(65),
    [anon_sym_WITNESS] = ACTIONS(67),
    [anon_sym_PICK] = ACTIONS(69),
    [anon_sym_SUFFICES] = ACTIONS(71),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(77),
    [aux_sym_child_id_token1] = ACTIONS(79),
    [sym__real_number] = ACTIONS(81),
    [sym__binary_number] = ACTIONS(81),
    [sym__octal_number] = ACTIONS(81),
    [sym__hex_number] = ACTIONS(81),
    [sym_string] = ACTIONS(83),
    [anon_sym_TRUE] = ACTIONS(85),
    [anon_sym_FALSE] = ACTIONS(85),
    [anon_sym_STRING] = ACTIONS(87),
    [anon_sym_BOOLEAN] = ACTIONS(87),
    [anon_sym_Nat] = ACTIONS(87),
    [anon_sym_Int] = ACTIONS(87),
    [anon_sym_Real] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(89),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(125),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(241),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym__expr] = STATE(1110),
    [sym_prefixed_op] = STATE(2199),
    [sym_number] = STATE(2199),
    [sym__nat_number] = STATE(2198),
    [sym_boolean] = STATE(2199),
    [sym_primitive_value_set] = STATE(2199),
    [sym_label] = STATE(2199),
    [sym_subexpression] = STATE(2199),
    [sym_parentheses] = STATE(2199),
    [sym_bounded_quantification] = STATE(2199),
    [sym_unbounded_quantification] = STATE(2199),
    [sym_choose] = STATE(2199),
    [sym_finite_set_literal] = STATE(2199),
    [sym_set_filter] = STATE(2199),
    [sym_set_map] = STATE(2199),
    [sym_function_evaluation] = STATE(2199),
    [sym_function_literal] = STATE(2199),
    [sym_set_of_functions] = STATE(2199),
    [sym_record_literal] = STATE(2199),
    [sym_set_of_records] = STATE(2199),
    [sym_record_value] = STATE(2199),
    [sym_except] = STATE(2199),
    [sym_prev_func_val] = STATE(2199),
    [sym_tuple_literal] = STATE(2199),
    [sym_step_expr_or_stutter] = STATE(2199),
    [sym_step_expr_no_stutter] = STATE(2199),
    [sym_fairness] = STATE(2199),
    [sym_if_then_else] = STATE(2199),
    [sym_case] = STATE(2199),
    [sym_let_in] = STATE(2199),
    [sym_conj_list] = STATE(2199),
    [sym_disj_list] = STATE(2199),
    [sym_lnot] = STATE(226),
    [sym_union] = STATE(222),
    [sym_powerset] = STATE(222),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(797),
    [sym_enabled] = STATE(216),
    [sym_unchanged] = STATE(216),
    [sym_always] = STATE(216),
    [sym_eventually] = STATE(216),
    [sym_standalone_prefix_op_symbol] = STATE(4281),
    [sym_bound_prefix_op] = STATE(2199),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4279),
    [sym_bound_infix_op] = STATE(2199),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4281),
    [sym_bound_postfix_op] = STATE(2199),
    [sym_proof_step_ref] = STATE(2180),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym__expr] = STATE(1095),
    [sym_prefixed_op] = STATE(2199),
    [sym_number] = STATE(2199),
    [sym__nat_number] = STATE(2198),
    [sym_boolean] = STATE(2199),
    [sym_primitive_value_set] = STATE(2199),
    [sym_label] = STATE(2199),
    [sym_subexpression] = STATE(2199),
    [sym_parentheses] = STATE(2199),
    [sym_bounded_quantification] = STATE(2199),
    [sym_unbounded_quantification] = STATE(2199),
    [sym_choose] = STATE(2199),
    [sym_finite_set_literal] = STATE(2199),
    [sym_set_filter] = STATE(2199),
    [sym_set_map] = STATE(2199),
    [sym_function_evaluation] = STATE(2199),
    [sym_function_literal] = STATE(2199),
    [sym_set_of_functions] = STATE(2199),
    [sym_record_literal] = STATE(2199),
    [sym_set_of_records] = STATE(2199),
    [sym_record_value] = STATE(2199),
    [sym_except] = STATE(2199),
    [sym_prev_func_val] = STATE(2199),
    [sym_tuple_literal] = STATE(2199),
    [sym_step_expr_or_stutter] = STATE(2199),
    [sym_step_expr_no_stutter] = STATE(2199),
    [sym_fairness] = STATE(2199),
    [sym_if_then_else] = STATE(2199),
    [sym_case] = STATE(2199),
    [sym_let_in] = STATE(2199),
    [sym_conj_list] = STATE(2199),
    [sym_disj_list] = STATE(2199),
    [sym_lnot] = STATE(226),
    [sym_union] = STATE(222),
    [sym_powerset] = STATE(222),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(797),
    [sym_enabled] = STATE(216),
    [sym_unchanged] = STATE(216),
    [sym_always] = STATE(216),
    [sym_eventually] = STATE(216),
    [sym_standalone_prefix_op_symbol] = STATE(4281),
    [sym_bound_prefix_op] = STATE(2199),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4279),
    [sym_bound_infix_op] = STATE(2199),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4281),
    [sym_bound_postfix_op] = STATE(2199),
    [sym_proof_step_ref] = STATE(2180),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym__expr] = STATE(1099),
    [sym_prefixed_op] = STATE(2199),
    [sym_number] = STATE(2199),
    [sym__nat_number] = STATE(2198),
    [sym_boolean] = STATE(2199),
    [sym_primitive_value_set] = STATE(2199),
    [sym_label] = STATE(2199),
    [sym_subexpression] = STATE(2199),
    [sym_parentheses] = STATE(2199),
    [sym_bounded_quantification] = STATE(2199),
    [sym_unbounded_quantification] = STATE(2199),
    [sym_choose] = STATE(2199),
    [sym_finite_set_literal] = STATE(2199),
    [sym_set_filter] = STATE(2199),
    [sym_set_map] = STATE(2199),
    [sym_function_evaluation] = STATE(2199),
    [sym_function_literal] = STATE(2199),
    [sym_set_of_functions] = STATE(2199),
    [sym_record_literal] = STATE(2199),
    [sym_set_of_records] = STATE(2199),
    [sym_record_value] = STATE(2199),
    [sym_except] = STATE(2199),
    [sym_prev_func_val] = STATE(2199),
    [sym_tuple_literal] = STATE(2199),
    [sym_step_expr_or_stutter] = STATE(2199),
    [sym_step_expr_no_stutter] = STATE(2199),
    [sym_fairness] = STATE(2199),
    [sym_if_then_else] = STATE(2199),
    [sym_case] = STATE(2199),
    [sym_let_in] = STATE(2199),
    [sym_conj_list] = STATE(2199),
    [sym_disj_list] = STATE(2199),
    [sym_lnot] = STATE(226),
    [sym_union] = STATE(222),
    [sym_powerset] = STATE(222),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(797),
    [sym_enabled] = STATE(216),
    [sym_unchanged] = STATE(216),
    [sym_always] = STATE(216),
    [sym_eventually] = STATE(216),
    [sym_standalone_prefix_op_symbol] = STATE(4281),
    [sym_bound_prefix_op] = STATE(2199),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4279),
    [sym_bound_infix_op] = STATE(2199),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4281),
    [sym_bound_postfix_op] = STATE(2199),
    [sym_proof_step_ref] = STATE(2180),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym__expr] = STATE(1114),
    [sym_prefixed_op] = STATE(2199),
    [sym_number] = STATE(2199),
    [sym__nat_number] = STATE(2198),
    [sym_boolean] = STATE(2199),
    [sym_primitive_value_set] = STATE(2199),
    [sym_label] = STATE(2199),
    [sym_subexpression] = STATE(2199),
    [sym_parentheses] = STATE(2199),
    [sym_bounded_quantification] = STATE(2199),
    [sym_unbounded_quantification] = STATE(2199),
    [sym_choose] = STATE(2199),
    [sym_finite_set_literal] = STATE(2199),
    [sym_set_filter] = STATE(2199),
    [sym_set_map] = STATE(2199),
    [sym_function_evaluation] = STATE(2199),
    [sym_function_literal] = STATE(2199),
    [sym_set_of_functions] = STATE(2199),
    [sym_record_literal] = STATE(2199),
    [sym_set_of_records] = STATE(2199),
    [sym_record_value] = STATE(2199),
    [sym_except] = STATE(2199),
    [sym_prev_func_val] = STATE(2199),
    [sym_tuple_literal] = STATE(2199),
    [sym_step_expr_or_stutter] = STATE(2199),
    [sym_step_expr_no_stutter] = STATE(2199),
    [sym_fairness] = STATE(2199),
    [sym_if_then_else] = STATE(2199),
    [sym_case] = STATE(2199),
    [sym_let_in] = STATE(2199),
    [sym_conj_list] = STATE(2199),
    [sym_disj_list] = STATE(2199),
    [sym_lnot] = STATE(226),
    [sym_union] = STATE(222),
    [sym_powerset] = STATE(222),
    [sym_domain] = STATE(220),
    [sym_negative] = STATE(797),
    [sym_enabled] = STATE(216),
    [sym_unchanged] = STATE(216),
    [sym_always] = STATE(216),
    [sym_eventually] = STATE(216),
    [sym_standalone_prefix_op_symbol] = STATE(4281),
    [sym_bound_prefix_op] = STATE(2199),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4279),
    [sym_bound_infix_op] = STATE(2199),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4281),
    [sym_bound_postfix_op] = STATE(2199),
    [sym_proof_step_ref] = STATE(2180),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [sym_single_line] = ACTIONS(247),
    [sym_double_line] = ACTIONS(247),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(249),
    [anon_sym_10] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_ASSUME] = ACTIONS(254),
    [anon_sym_LOCAL] = ACTIONS(254),
    [anon_sym_UNION] = ACTIONS(256),
    [anon_sym_ASSUMPTION] = ACTIONS(254),
    [anon_sym_ENABLED] = ACTIONS(259),
    [anon_sym_VARIABLE] = ACTIONS(254),
    [anon_sym_AXIOM] = ACTIONS(254),
    [anon_sym_VARIABLES] = ACTIONS(254),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(270),
    [anon_sym_CONSTANT] = ACTIONS(254),
    [anon_sym_CONSTANTS] = ACTIONS(254),
    [anon_sym_INSTANCE] = ACTIONS(254),
    [anon_sym_THEOREM] = ACTIONS(254),
    [anon_sym_COROLLARY] = ACTIONS(254),
    [anon_sym_DOMAIN] = ACTIONS(273),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(278),
    [anon_sym_HIDE] = ACTIONS(254),
    [anon_sym_RECURSIVE] = ACTIONS(254),
    [anon_sym_USE] = ACTIONS(254),
    [anon_sym_LEMMA] = ACTIONS(254),
    [anon_sym_PROPOSITION] = ACTIONS(254),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(284),
    [anon_sym_LBRACK] = ACTIONS(287),
    [anon_sym_BANG] = ACTIONS(254),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(301),
    [anon_sym_BSLASHneg] = ACTIONS(301),
    [anon_sym_TILDE] = ACTIONS(304),
    [anon_sym_12] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(307),
    [anon_sym_LT_GT] = ACTIONS(310),
    [anon_sym_13] = ACTIONS(310),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(127),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(315),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3636),
    [sym_exists] = STATE(3636),
    [sym_temporal_forall] = STATE(4465),
    [sym_temporal_exists] = STATE(4465),
    [sym_langle_bracket] = STATE(150),
    [sym_subexpr_prefix] = STATE(1186),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2478),
    [sym_bound_nonfix_op] = STATE(2478),
    [sym__expr] = STATE(1741),
    [sym_prefixed_op] = STATE(2580),
    [sym_number] = STATE(2580),
    [sym__nat_number] = STATE(2586),
    [sym_boolean] = STATE(2580),
    [sym_primitive_value_set] = STATE(2580),
    [sym_label] = STATE(2580),
    [sym_subexpression] = STATE(2580),
    [sym_parentheses] = STATE(2580),
    [sym_bounded_quantification] = STATE(2580),
    [sym_unbounded_quantification] = STATE(2580),
    [sym_choose] = STATE(2580),
    [sym_finite_set_literal] = STATE(2580),
    [sym_set_filter] = STATE(2580),
    [sym_set_map] = STATE(2580),
    [sym_function_evaluation] = STATE(2580),
    [sym_function_literal] = STATE(2580),
    [sym_set_of_functions] = STATE(2580),
    [sym_record_literal] = STATE(2580),
    [sym_set_of_records] = STATE(2580),
    [sym_record_value] = STATE(2580),
    [sym_except] = STATE(2580),
    [sym_prev_func_val] = STATE(2580),
    [sym_tuple_literal] = STATE(2580),
    [sym_step_expr_or_stutter] = STATE(2580),
    [sym_step_expr_no_stutter] = STATE(2580),
    [sym_fairness] = STATE(2580),
    [sym_if_then_else] = STATE(2580),
    [sym_case] = STATE(2580),
    [sym_let_in] = STATE(2580),
    [sym_conj_list] = STATE(2580),
    [sym_disj_list] = STATE(2580),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(39),
    [sym_powerset] = STATE(39),
    [sym_domain] = STATE(40),
    [sym_negative] = STATE(906),
    [sym_enabled] = STATE(36),
    [sym_unchanged] = STATE(36),
    [sym_always] = STATE(36),
    [sym_eventually] = STATE(36),
    [sym_standalone_prefix_op_symbol] = STATE(4259),
    [sym_bound_prefix_op] = STATE(2580),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2580),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4259),
    [sym_bound_postfix_op] = STATE(2580),
    [sym_assume_prove] = STATE(4308),
    [sym_inner_assume_prove] = STATE(3848),
    [sym_new] = STATE(3848),
    [sym_level] = STATE(3312),
    [sym_proof_step_ref] = STATE(2482),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(3636),
    [sym_exists] = STATE(3636),
    [sym_temporal_forall] = STATE(4465),
    [sym_temporal_exists] = STATE(4465),
    [sym_langle_bracket] = STATE(150),
    [sym_subexpr_prefix] = STATE(1186),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2478),
    [sym_bound_nonfix_op] = STATE(2478),
    [sym__expr] = STATE(1786),
    [sym_prefixed_op] = STATE(2580),
    [sym_number] = STATE(2580),
    [sym__nat_number] = STATE(2586),
    [sym_boolean] = STATE(2580),
    [sym_primitive_value_set] = STATE(2580),
    [sym_label] = STATE(2580),
    [sym_subexpression] = STATE(2580),
    [sym_parentheses] = STATE(2580),
    [sym_bounded_quantification] = STATE(2580),
    [sym_unbounded_quantification] = STATE(2580),
    [sym_choose] = STATE(2580),
    [sym_finite_set_literal] = STATE(2580),
    [sym_set_filter] = STATE(2580),
    [sym_set_map] = STATE(2580),
    [sym_function_evaluation] = STATE(2580),
    [sym_function_literal] = STATE(2580),
    [sym_set_of_functions] = STATE(2580),
    [sym_record_literal] = STATE(2580),
    [sym_set_of_records] = STATE(2580),
    [sym_record_value] = STATE(2580),
    [sym_except] = STATE(2580),
    [sym_prev_func_val] = STATE(2580),
    [sym_tuple_literal] = STATE(2580),
    [sym_step_expr_or_stutter] = STATE(2580),
    [sym_step_expr_no_stutter] = STATE(2580),
    [sym_fairness] = STATE(2580),
    [sym_if_then_else] = STATE(2580),
    [sym_case] = STATE(2580),
    [sym_let_in] = STATE(2580),
    [sym_conj_list] = STATE(2580),
    [sym_disj_list] = STATE(2580),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(39),
    [sym_powerset] = STATE(39),
    [sym_domain] = STATE(40),
    [sym_negative] = STATE(906),
    [sym_enabled] = STATE(36),
    [sym_unchanged] = STATE(36),
    [sym_always] = STATE(36),
    [sym_eventually] = STATE(36),
    [sym_standalone_prefix_op_symbol] = STATE(4259),
    [sym_bound_prefix_op] = STATE(2580),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2580),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4259),
    [sym_bound_postfix_op] = STATE(2580),
    [sym_assume_prove] = STATE(4308),
    [sym_inner_assume_prove] = STATE(4262),
    [sym_new] = STATE(4262),
    [sym_level] = STATE(3312),
    [sym_proof_step_ref] = STATE(2482),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(3636),
    [sym_exists] = STATE(3636),
    [sym_temporal_forall] = STATE(4465),
    [sym_temporal_exists] = STATE(4465),
    [sym_langle_bracket] = STATE(150),
    [sym_subexpr_prefix] = STATE(1186),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2478),
    [sym_bound_nonfix_op] = STATE(2478),
    [sym__expr] = STATE(1761),
    [sym_prefixed_op] = STATE(2580),
    [sym_number] = STATE(2580),
    [sym__nat_number] = STATE(2586),
    [sym_boolean] = STATE(2580),
    [sym_primitive_value_set] = STATE(2580),
    [sym_label] = STATE(2580),
    [sym_subexpression] = STATE(2580),
    [sym_parentheses] = STATE(2580),
    [sym_bounded_quantification] = STATE(2580),
    [sym_unbounded_quantification] = STATE(2580),
    [sym_choose] = STATE(2580),
    [sym_finite_set_literal] = STATE(2580),
    [sym_set_filter] = STATE(2580),
    [sym_set_map] = STATE(2580),
    [sym_function_evaluation] = STATE(2580),
    [sym_function_literal] = STATE(2580),
    [sym_set_of_functions] = STATE(2580),
    [sym_record_literal] = STATE(2580),
    [sym_set_of_records] = STATE(2580),
    [sym_record_value] = STATE(2580),
    [sym_except] = STATE(2580),
    [sym_prev_func_val] = STATE(2580),
    [sym_tuple_literal] = STATE(2580),
    [sym_step_expr_or_stutter] = STATE(2580),
    [sym_step_expr_no_stutter] = STATE(2580),
    [sym_fairness] = STATE(2580),
    [sym_if_then_else] = STATE(2580),
    [sym_case] = STATE(2580),
    [sym_let_in] = STATE(2580),
    [sym_conj_list] = STATE(2580),
    [sym_disj_list] = STATE(2580),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(39),
    [sym_powerset] = STATE(39),
    [sym_domain] = STATE(40),
    [sym_negative] = STATE(906),
    [sym_enabled] = STATE(36),
    [sym_unchanged] = STATE(36),
    [sym_always] = STATE(36),
    [sym_eventually] = STATE(36),
    [sym_standalone_prefix_op_symbol] = STATE(4259),
    [sym_bound_prefix_op] = STATE(2580),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2580),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4259),
    [sym_bound_postfix_op] = STATE(2580),
    [sym_assume_prove] = STATE(4308),
    [sym_inner_assume_prove] = STATE(4032),
    [sym_new] = STATE(4032),
    [sym_level] = STATE(3312),
    [sym_proof_step_ref] = STATE(2482),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3636),
    [sym_exists] = STATE(3636),
    [sym_temporal_forall] = STATE(4465),
    [sym_temporal_exists] = STATE(4465),
    [sym_langle_bracket] = STATE(150),
    [sym_subexpr_prefix] = STATE(1186),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2478),
    [sym_bound_nonfix_op] = STATE(2478),
    [sym__expr] = STATE(1748),
    [sym_prefixed_op] = STATE(2580),
    [sym_number] = STATE(2580),
    [sym__nat_number] = STATE(2586),
    [sym_boolean] = STATE(2580),
    [sym_primitive_value_set] = STATE(2580),
    [sym_label] = STATE(2580),
    [sym_subexpression] = STATE(2580),
    [sym_parentheses] = STATE(2580),
    [sym_bounded_quantification] = STATE(2580),
    [sym_unbounded_quantification] = STATE(2580),
    [sym_choose] = STATE(2580),
    [sym_finite_set_literal] = STATE(2580),
    [sym_set_filter] = STATE(2580),
    [sym_set_map] = STATE(2580),
    [sym_function_evaluation] = STATE(2580),
    [sym_function_literal] = STATE(2580),
    [sym_set_of_functions] = STATE(2580),
    [sym_record_literal] = STATE(2580),
    [sym_set_of_records] = STATE(2580),
    [sym_record_value] = STATE(2580),
    [sym_except] = STATE(2580),
    [sym_prev_func_val] = STATE(2580),
    [sym_tuple_literal] = STATE(2580),
    [sym_step_expr_or_stutter] = STATE(2580),
    [sym_step_expr_no_stutter] = STATE(2580),
    [sym_fairness] = STATE(2580),
    [sym_if_then_else] = STATE(2580),
    [sym_case] = STATE(2580),
    [sym_let_in] = STATE(2580),
    [sym_conj_list] = STATE(2580),
    [sym_disj_list] = STATE(2580),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(39),
    [sym_powerset] = STATE(39),
    [sym_domain] = STATE(40),
    [sym_negative] = STATE(906),
    [sym_enabled] = STATE(36),
    [sym_unchanged] = STATE(36),
    [sym_always] = STATE(36),
    [sym_eventually] = STATE(36),
    [sym_standalone_prefix_op_symbol] = STATE(4259),
    [sym_bound_prefix_op] = STATE(2580),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4287),
    [sym_bound_infix_op] = STATE(2580),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4259),
    [sym_bound_postfix_op] = STATE(2580),
    [sym_assume_prove] = STATE(4308),
    [sym_inner_assume_prove] = STATE(3972),
    [sym_new] = STATE(3972),
    [sym_level] = STATE(3312),
    [sym_proof_step_ref] = STATE(2482),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_ASSUME] = ACTIONS(319),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_VARIABLE] = ACTIONS(321),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_CONSTANT] = ACTIONS(321),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_NEW] = ACTIONS(333),
    [anon_sym_STATE] = ACTIONS(321),
    [anon_sym_ACTION] = ACTIONS(321),
    [anon_sym_TEMPORAL] = ACTIONS(321),
    [sym_identifier] = ACTIONS(335),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3253),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(373),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3256),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(397),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4398),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(415),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3266),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [anon_sym_ONLY] = ACTIONS(439),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4383),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(441),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4396),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [anon_sym_ONLY] = ACTIONS(443),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4393),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3266),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4398),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3255),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3256),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [24] = {
    [sym_block_comment] = STATE(24),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4383),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [25] = {
    [sym_block_comment] = STATE(25),
    [sym_forall] = STATE(3583),
    [sym_exists] = STATE(3583),
    [sym_temporal_forall] = STATE(4525),
    [sym_temporal_exists] = STATE(4525),
    [sym_langle_bracket] = STATE(128),
    [sym_subexpr_prefix] = STATE(1185),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2107),
    [sym_bound_nonfix_op] = STATE(2107),
    [sym__expr] = STATE(1058),
    [sym_prefixed_op] = STATE(2131),
    [sym_number] = STATE(2131),
    [sym__nat_number] = STATE(2123),
    [sym_boolean] = STATE(2131),
    [sym_primitive_value_set] = STATE(2131),
    [sym_label] = STATE(2131),
    [sym_subexpression] = STATE(2131),
    [sym_parentheses] = STATE(2131),
    [sym_bounded_quantification] = STATE(2131),
    [sym_unbounded_quantification] = STATE(2131),
    [sym_choose] = STATE(2131),
    [sym_finite_set_literal] = STATE(2131),
    [sym_set_filter] = STATE(2131),
    [sym_set_map] = STATE(2131),
    [sym_function_evaluation] = STATE(2131),
    [sym_function_literal] = STATE(2131),
    [sym_set_of_functions] = STATE(2131),
    [sym_record_literal] = STATE(2131),
    [sym_set_of_records] = STATE(2131),
    [sym_record_value] = STATE(2131),
    [sym_except] = STATE(2131),
    [sym_prev_func_val] = STATE(2131),
    [sym_tuple_literal] = STATE(2131),
    [sym_step_expr_or_stutter] = STATE(2131),
    [sym_step_expr_no_stutter] = STATE(2131),
    [sym_fairness] = STATE(2131),
    [sym_if_then_else] = STATE(2131),
    [sym_case] = STATE(2131),
    [sym_let_in] = STATE(2131),
    [sym_conj_list] = STATE(2131),
    [sym_disj_list] = STATE(2131),
    [sym_lnot] = STATE(271),
    [sym_union] = STATE(273),
    [sym_powerset] = STATE(273),
    [sym_domain] = STATE(275),
    [sym_negative] = STATE(986),
    [sym_enabled] = STATE(276),
    [sym_unchanged] = STATE(276),
    [sym_always] = STATE(276),
    [sym_eventually] = STATE(276),
    [sym_standalone_prefix_op_symbol] = STATE(4276),
    [sym_bound_prefix_op] = STATE(2131),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4296),
    [sym_bound_infix_op] = STATE(2131),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4276),
    [sym_bound_postfix_op] = STATE(2131),
    [sym_use_body] = STATE(3245),
    [sym_use_body_expr] = STATE(3160),
    [sym_use_body_def] = STATE(3267),
    [sym_module_ref] = STATE(3141),
    [sym_proof_step_ref] = STATE(2109),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(357),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(361),
    [anon_sym_SF_] = ACTIONS(363),
    [anon_sym_WF_] = ACTIONS(363),
    [anon_sym_CHOOSE] = ACTIONS(365),
    [anon_sym_IF] = ACTIONS(367),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(369),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(371),
    [anon_sym_DEFS] = ACTIONS(371),
    [sym_identifier] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_LBRACK] = ACTIONS(379),
    [aux_sym_child_id_token1] = ACTIONS(381),
    [sym__real_number] = ACTIONS(383),
    [sym__binary_number] = ACTIONS(383),
    [sym__octal_number] = ACTIONS(383),
    [sym__hex_number] = ACTIONS(383),
    [sym_string] = ACTIONS(385),
    [anon_sym_TRUE] = ACTIONS(387),
    [anon_sym_FALSE] = ACTIONS(387),
    [anon_sym_STRING] = ACTIONS(389),
    [anon_sym_BOOLEAN] = ACTIONS(389),
    [anon_sym_Nat] = ACTIONS(389),
    [anon_sym_Int] = ACTIONS(389),
    [anon_sym_Real] = ACTIONS(389),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(393),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(395),
  },
  [26] = {
    [sym_block_comment] = STATE(26),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym__expr] = STATE(1560),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(293),
    [sym_union] = STATE(289),
    [sym_powerset] = STATE(289),
    [sym_domain] = STATE(284),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(277),
    [sym_unchanged] = STATE(277),
    [sym_always] = STATE(277),
    [sym_eventually] = STATE(277),
    [sym_standalone_prefix_op_symbol] = STATE(4313),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(4304),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(4313),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_use_body] = STATE(4405),
    [sym_use_body_expr] = STATE(3766),
    [sym_use_body_def] = STATE(4385),
    [sym_module_ref] = STATE(3702),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_DEF] = ACTIONS(413),
    [anon_sym_DEFS] = ACTIONS(413),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(99),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(435),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(437),
  },
  [27] = {
    [sym_block_comment] = STATE(27),
    [sym_forall] = STATE(3636),
    [sym_exists] = STATE(3636),
    [sym_temporal_forall] = STATE(4465),
    [sym_temporal_exists] = STATE(4465),
    [sym_langle_bracket] = STATE(150),
    [sym_operator_declaration] = STATE(3220),
    [sym__id_or_op_declaration] = STATE(3974),
    [sym__op_or_expr] = STATE(4045),
    [sym_subexpr_prefix] = STATE(1186),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2478),
    [sym_bound_nonfix_op] = STATE(2478),
    [sym_lambda] = STATE(3213),
    [sym__expr] = STATE(1792),
    [sym_prefixed_op] = STATE(2580),
    [sym_number] = STATE(2580),
    [sym__nat_number] = STATE(2586),
    [sym_boolean] = STATE(2580),
    [sym_primitive_value_set] = STATE(2580),
    [sym_label] = STATE(2580),
    [sym_subexpression] = STATE(2580),
    [sym_parentheses] = STATE(2580),
    [sym_bounded_quantification] = STATE(2580),
    [sym_unbounded_quantification] = STATE(2580),
    [sym_choose] = STATE(2580),
    [sym_finite_set_literal] = STATE(2580),
    [sym_set_filter] = STATE(2580),
    [sym_set_map] = STATE(2580),
    [sym_function_evaluation] = STATE(2580),
    [sym_function_literal] = STATE(2580),
    [sym_set_of_functions] = STATE(2580),
    [sym_record_literal] = STATE(2580),
    [sym_set_of_records] = STATE(2580),
    [sym_record_value] = STATE(2580),
    [sym_except] = STATE(2580),
    [sym_prev_func_val] = STATE(2580),
    [sym_tuple_literal] = STATE(2580),
    [sym_step_expr_or_stutter] = STATE(2580),
    [sym_step_expr_no_stutter] = STATE(2580),
    [sym_fairness] = STATE(2580),
    [sym_if_then_else] = STATE(2580),
    [sym_case] = STATE(2580),
    [sym_let_in] = STATE(2580),
    [sym_conj_list] = STATE(2580),
    [sym_disj_list] = STATE(2580),
    [sym_lnot] = STATE(32),
    [sym_union] = STATE(39),
    [sym_powerset] = STATE(39),
    [sym_domain] = STATE(40),
    [sym_negative] = STATE(906),
    [sym_enabled] = STATE(36),
    [sym_unchanged] = STATE(36),
    [sym_always] = STATE(36),
    [sym_eventually] = STATE(36),
    [sym_standalone_prefix_op_symbol] = STATE(3667),
    [sym_bound_prefix_op] = STATE(2580),
    [sym_implies] = STATE(3488),
    [sym_plus_arrow] = STATE(3488),
    [sym_equiv] = STATE(3488),
    [sym_iff] = STATE(3488),
    [sym_leads_to] = STATE(3488),
    [sym_land] = STATE(3488),
    [sym_lor] = STATE(3488),
    [sym_assign] = STATE(3488),
    [sym_bnf_rule] = STATE(3488),
    [sym_eq] = STATE(3488),
    [sym_neq] = STATE(3488),
    [sym_lt] = STATE(3488),
    [sym_leq] = STATE(3488),
    [sym_geq] = STATE(3488),
    [sym_approx] = STATE(3488),
    [sym_rs_ttile] = STATE(3488),
    [sym_rd_ttile] = STATE(3488),
    [sym_ls_ttile] = STATE(3488),
    [sym_ld_ttile] = STATE(3488),
    [sym_asymp] = STATE(3488),
    [sym_cong] = STATE(3488),
    [sym_doteq] = STATE(3488),
    [sym_gg] = STATE(3488),
    [sym_ll] = STATE(3488),
    [sym_in] = STATE(3488),
    [sym_notin] = STATE(3488),
    [sym_prec] = STATE(3488),
    [sym_succ] = STATE(3488),
    [sym_preceq] = STATE(3488),
    [sym_succeq] = STATE(3488),
    [sym_sim] = STATE(3488),
    [sym_simeq] = STATE(3488),
    [sym_sqsubset] = STATE(3488),
    [sym_sqsupset] = STATE(3488),
    [sym_sqsubseteq] = STATE(3488),
    [sym_sqsupseteq] = STATE(3488),
    [sym_cap] = STATE(3488),
    [sym_cup] = STATE(3488),
    [sym_dots_2] = STATE(3488),
    [sym_dots_3] = STATE(3488),
    [sym_oplus] = STATE(3488),
    [sym_ominus] = STATE(3488),
    [sym_vertvert] = STATE(3488),
    [sym_minus] = STATE(3488),
    [sym_odot] = STATE(3488),
    [sym_oslash] = STATE(3488),
    [sym_otimes] = STATE(3488),
    [sym_bigcirc] = STATE(3488),
    [sym_bullet] = STATE(3488),
    [sym_div] = STATE(3488),
    [sym_circ] = STATE(3488),
    [sym_star] = STATE(3488),
    [sym_excl] = STATE(3488),
    [sym_qq] = STATE(3488),
    [sym_sqcap] = STATE(3488),
    [sym_sqcup] = STATE(3488),
    [sym_uplus] = STATE(3488),
    [sym_wr] = STATE(3488),
    [sym_cdot] = STATE(3488),
    [sym_infix_op_symbol] = STATE(3761),
    [sym_bound_infix_op] = STATE(2580),
    [sym_sup_plus] = STATE(3317),
    [sym_postfix_op_symbol] = STATE(3802),
    [sym_bound_postfix_op] = STATE(2580),
    [sym_proof_step_ref] = STATE(2482),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(11),
    [anon_sym_2] = ACTIONS(13),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(29),
    [anon_sym_10] = ACTIONS(29),
    [anon_sym_AT] = ACTIONS(317),
    [sym_placeholder] = ACTIONS(445),
    [anon_sym_UNION] = ACTIONS(35),
    [anon_sym_ENABLED] = ACTIONS(37),
    [anon_sym_CASE] = ACTIONS(323),
    [anon_sym_SF_] = ACTIONS(325),
    [anon_sym_WF_] = ACTIONS(325),
    [anon_sym_CHOOSE] = ACTIONS(327),
    [anon_sym_IF] = ACTIONS(329),
    [anon_sym_SUBSET] = ACTIONS(47),
    [anon_sym_DOMAIN] = ACTIONS(51),
    [anon_sym_LET] = ACTIONS(331),
    [anon_sym_UNCHANGED] = ACTIONS(55),
    [anon_sym_LAMBDA] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(339),
    [aux_sym_child_id_token1] = ACTIONS(341),
    [sym__real_number] = ACTIONS(343),
    [sym__binary_number] = ACTIONS(343),
    [sym__octal_number] = ACTIONS(343),
    [sym__hex_number] = ACTIONS(343),
    [sym_string] = ACTIONS(345),
    [anon_sym_TRUE] = ACTIONS(347),
    [anon_sym_FALSE] = ACTIONS(347),
    [anon_sym_STRING] = ACTIONS(349),
    [anon_sym_BOOLEAN] = ACTIONS(349),
    [anon_sym_Nat] = ACTIONS(349),
    [anon_sym_Int] = ACTIONS(349),
    [anon_sym_Real] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_EQ] = ACTIONS(91),
    [anon_sym_BSLASHlnot] = ACTIONS(93),
    [anon_sym_BSLASHneg] = ACTIONS(93),
    [anon_sym_TILDE] = ACTIONS(95),
    [anon_sym_12] = ACTIONS(93),
    [anon_sym_DASH] = ACTIONS(97),
    [sym_negative_dot] = ACTIONS(451),
    [anon_sym_LT_GT] = ACTIONS(101),
    [anon_sym_13] = ACTIONS(101),
    [anon_sym_EQ_GT] = ACTIONS(103),
    [anon_sym_14] = ACTIONS(103),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(105),
    [anon_sym_15] = ACTIONS(105),
    [anon_sym_BSLASHequiv] = ACTIONS(107),
    [anon_sym_16] = ACTIONS(107),
    [anon_sym_LT_EQ_GT] = ACTIONS(109),
    [anon_sym_17] = ACTIONS(109),
    [anon_sym_TILDE_GT] = ACTIONS(111),
    [anon_sym_18] = ACTIONS(111),
    [anon_sym_SLASH_BSLASH] = ACTIONS(113),
    [anon_sym_BSLASHland] = ACTIONS(113),
    [anon_sym_19] = ACTIONS(113),
    [anon_sym_BSLASH_SLASH] = ACTIONS(115),
    [anon_sym_BSLASHlor] = ACTIONS(115),
    [anon_sym_20] = ACTIONS(115),
    [anon_sym_COLON_EQ] = ACTIONS(117),
    [anon_sym_21] = ACTIONS(117),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(119),
    [anon_sym_22] = ACTIONS(119),
    [anon_sym_SLASH_EQ] = ACTIONS(121),
    [anon_sym_POUND] = ACTIONS(123),
    [anon_sym_23] = ACTIONS(121),
    [anon_sym_LT] = ACTIONS(353),
    [sym_gt] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_EQ_LT] = ACTIONS(131),
    [anon_sym_BSLASHleq] = ACTIONS(131),
    [anon_sym_24] = ACTIONS(131),
    [anon_sym_GT_EQ] = ACTIONS(133),
    [anon_sym_BSLASHgeq] = ACTIONS(133),
    [anon_sym_25] = ACTIONS(133),
    [anon_sym_BSLASHapprox] = ACTIONS(135),
    [anon_sym_26] = ACTIONS(135),
    [anon_sym_PIPE_DASH] = ACTIONS(137),
    [anon_sym_27] = ACTIONS(137),
    [anon_sym_PIPE_EQ] = ACTIONS(139),
    [anon_sym_28] = ACTIONS(139),
    [anon_sym_DASH_PIPE] = ACTIONS(141),
    [anon_sym_29] = ACTIONS(141),
    [anon_sym_EQ_PIPE] = ACTIONS(143),
    [anon_sym_30] = ACTIONS(143),
    [anon_sym_BSLASHasymp] = ACTIONS(145),
    [anon_sym_31] = ACTIONS(145),
    [anon_sym_BSLASHcong] = ACTIONS(147),
    [anon_sym_32] = ACTIONS(147),
    [anon_sym_BSLASHdoteq] = ACTIONS(149),
    [anon_sym_33] = ACTIONS(149),
    [anon_sym_BSLASHgg] = ACTIONS(151),
    [anon_sym_34] = ACTIONS(151),
    [anon_sym_BSLASHll] = ACTIONS(153),
    [anon_sym_35] = ACTIONS(153),
    [anon_sym_BSLASHnotin] = ACTIONS(155),
    [anon_sym_36] = ACTIONS(155),
    [anon_sym_BSLASHprec] = ACTIONS(157),
    [anon_sym_37] = ACTIONS(159),
    [anon_sym_BSLASHsucc] = ACTIONS(161),
    [anon_sym_38] = ACTIONS(163),
    [anon_sym_BSLASHpreceq] = ACTIONS(165),
    [anon_sym_39] = ACTIONS(165),
    [anon_sym_BSLASHsucceq] = ACTIONS(167),
    [anon_sym_40] = ACTIONS(167),
    [anon_sym_BSLASHsim] = ACTIONS(169),
    [anon_sym_42] = ACTIONS(171),
    [anon_sym_BSLASHsimeq] = ACTIONS(173),
    [anon_sym_43] = ACTIONS(173),
    [anon_sym_BSLASHsqsubset] = ACTIONS(175),
    [anon_sym_44] = ACTIONS(177),
    [anon_sym_BSLASHsqsupset] = ACTIONS(179),
    [anon_sym_45] = ACTIONS(181),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(183),
    [anon_sym_46] = ACTIONS(183),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(185),
    [anon_sym_47] = ACTIONS(185),
    [sym_compose] = ACTIONS(187),
    [sym_map_to] = ACTIONS(187),
    [sym_map_from] = ACTIONS(187),
    [sym_setminus] = ACTIONS(127),
    [anon_sym_BSLASHcap] = ACTIONS(189),
    [anon_sym_BSLASHintersect] = ACTIONS(189),
    [anon_sym_52] = ACTIONS(189),
    [anon_sym_BSLASHcup] = ACTIONS(191),
    [anon_sym_BSLASHunion] = ACTIONS(191),
    [anon_sym_53] = ACTIONS(191),
    [anon_sym_DOT_DOT] = ACTIONS(193),
    [anon_sym_54] = ACTIONS(195),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(197),
    [anon_sym_55] = ACTIONS(197),
    [sym_plus] = ACTIONS(127),
    [sym_plusplus] = ACTIONS(187),
    [anon_sym_BSLASHoplus] = ACTIONS(199),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(199),
    [anon_sym_56] = ACTIONS(199),
    [anon_sym_BSLASHominus] = ACTIONS(201),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(201),
    [anon_sym_57] = ACTIONS(201),
    [sym_mod] = ACTIONS(127),
    [sym_modmod] = ACTIONS(187),
    [sym_vert] = ACTIONS(127),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [anon_sym_58] = ACTIONS(203),
    [sym_minusminus] = ACTIONS(187),
    [sym_amp] = ACTIONS(127),
    [sym_ampamp] = ACTIONS(187),
    [anon_sym_BSLASHodot] = ACTIONS(205),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(205),
    [anon_sym_59] = ACTIONS(205),
    [anon_sym_BSLASHoslash] = ACTIONS(207),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(207),
    [anon_sym_60] = ACTIONS(207),
    [anon_sym_BSLASHotimes] = ACTIONS(209),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(209),
    [anon_sym_61] = ACTIONS(209),
    [sym_mul] = ACTIONS(127),
    [sym_mulmul] = ACTIONS(187),
    [sym_slash] = ACTIONS(127),
    [sym_slashslash] = ACTIONS(187),
    [anon_sym_BSLASHbigcirc] = ACTIONS(211),
    [anon_sym_62] = ACTIONS(211),
    [anon_sym_BSLASHbullet] = ACTIONS(213),
    [anon_sym_63] = ACTIONS(213),
    [anon_sym_BSLASHdiv] = ACTIONS(215),
    [anon_sym_64] = ACTIONS(215),
    [anon_sym_BSLASHo] = ACTIONS(217),
    [anon_sym_BSLASHcirc] = ACTIONS(219),
    [anon_sym_65] = ACTIONS(219),
    [anon_sym_BSLASHstar] = ACTIONS(221),
    [anon_sym_66] = ACTIONS(221),
    [anon_sym_BANG_BANG] = ACTIONS(223),
    [anon_sym_67] = ACTIONS(223),
    [anon_sym_QMARK_QMARK] = ACTIONS(225),
    [anon_sym_68] = ACTIONS(225),
    [sym_hashhash] = ACTIONS(187),
    [sym_dol] = ACTIONS(127),
    [sym_doldol] = ACTIONS(187),
    [anon_sym_BSLASHsqcap] = ACTIONS(227),
    [anon_sym_69] = ACTIONS(227),
    [anon_sym_BSLASHsqcup] = ACTIONS(229),
    [anon_sym_70] = ACTIONS(229),
    [anon_sym_BSLASHuplus] = ACTIONS(231),
    [anon_sym_71] = ACTIONS(231),
    [anon_sym_BSLASHwr] = ACTIONS(233),
    [anon_sym_73] = ACTIONS(233),
    [anon_sym_BSLASHcdot] = ACTIONS(235),
    [anon_sym_74] = ACTIONS(235),
    [sym_pow] = ACTIONS(127),
    [sym_powpow] = ACTIONS(187),
    [anon_sym_CARET_PLUS] = ACTIONS(237),
    [anon_sym_75] = ACTIONS(237),
    [sym_asterisk] = ACTIONS(239),
    [sym_sup_hash] = ACTIONS(239),
    [sym_prime] = ACTIONS(239),
    [sym__indent] = ACTIONS(355),
  },
  [28] = {
    [sym_block_comment] = STATE(28),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym__op_or_expr] = STATE(4285),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym_lambda] = STATE(3470),
    [sym__expr] = STATE(1797),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(152),
    [sym_union] = STATE(147),
    [sym_powerset] = STATE(147),
    [sym_domain] = STATE(141),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(140),
    [sym_unchanged] = STATE(140),
    [sym_always] = STATE(140),
    [sym_eventually] = STATE(140),
    [sym_standalone_prefix_op_symbol] = STATE(3745),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3445),
    [sym_plus_arrow] = STATE(3445),
    [sym_equiv] = STATE(3445),
    [sym_iff] = STATE(3445),
    [sym_leads_to] = STATE(3445),
    [sym_land] = STATE(3445),
    [sym_lor] = STATE(3445),
    [sym_assign] = STATE(3445),
    [sym_bnf_rule] = STATE(3445),
    [sym_eq] = STATE(3445),
    [sym_neq] = STATE(3445),
    [sym_lt] = STATE(3445),
    [sym_leq] = STATE(3445),
    [sym_geq] = STATE(3445),
    [sym_approx] = STATE(3445),
    [sym_rs_ttile] = STATE(3445),
    [sym_rd_ttile] = STATE(3445),
    [sym_ls_ttile] = STATE(3445),
    [sym_ld_ttile] = STATE(3445),
    [sym_asymp] = STATE(3445),
    [sym_cong] = STATE(3445),
    [sym_doteq] = STATE(3445),
    [sym_gg] = STATE(3445),
    [sym_ll] = STATE(3445),
    [sym_in] = STATE(3445),
    [sym_notin] = STATE(3445),
    [sym_prec] = STATE(3445),
    [sym_succ] = STATE(3445),
    [sym_preceq] = STATE(3445),
    [sym_succeq] = STATE(3445),
    [sym_sim] = STATE(3445),
    [sym_simeq] = STATE(3445),
    [sym_sqsubset] = STATE(3445),
    [sym_sqsupset] = STATE(3445),
    [sym_sqsubseteq] = STATE(3445),
    [sym_sqsupseteq] = STATE(3445),
    [sym_cap] = STATE(3445),
    [sym_cup] = STATE(3445),
    [sym_dots_2] = STATE(3445),
    [sym_dots_3] = STATE(3445),
    [sym_oplus] = STATE(3445),
    [sym_ominus] = STATE(3445),
    [sym_vertvert] = STATE(3445),
    [sym_minus] = STATE(3445),
    [sym_odot] = STATE(3445),
    [sym_oslash] = STATE(3445),
    [sym_otimes] = STATE(3445),
    [sym_bigcirc] = STATE(3445),
    [sym_bullet] = STATE(3445),
    [sym_div] = STATE(3445),
    [sym_circ] = STATE(3445),
    [sym_star] = STATE(3445),
    [sym_excl] = STATE(3445),
    [sym_qq] = STATE(3445),
    [sym_sqcap] = STATE(3445),
    [sym_sqcup] = STATE(3445),
    [sym_uplus] = STATE(3445),
    [sym_wr] = STATE(3445),
    [sym_cdot] = STATE(3445),
    [sym_infix_op_symbol] = STATE(3744),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3416),
    [sym_postfix_op_symbol] = STATE(3745),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_module_ref] = STATE(4285),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(453),
    [anon_sym_2] = ACTIONS(455),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(457),
    [anon_sym_10] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(459),
    [anon_sym_ENABLED] = ACTIONS(461),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(463),
    [anon_sym_DOMAIN] = ACTIONS(465),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(467),
    [anon_sym_LAMBDA] = ACTIONS(469),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(471),
    [anon_sym_BSLASHlnot] = ACTIONS(473),
    [anon_sym_BSLASHneg] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(475),
    [anon_sym_12] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(477),
    [sym_negative_dot] = ACTIONS(479),
    [anon_sym_LT_GT] = ACTIONS(481),
    [anon_sym_13] = ACTIONS(481),
    [anon_sym_EQ_GT] = ACTIONS(483),
    [anon_sym_14] = ACTIONS(483),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(485),
    [anon_sym_15] = ACTIONS(485),
    [anon_sym_BSLASHequiv] = ACTIONS(487),
    [anon_sym_16] = ACTIONS(487),
    [anon_sym_LT_EQ_GT] = ACTIONS(489),
    [anon_sym_17] = ACTIONS(489),
    [anon_sym_TILDE_GT] = ACTIONS(491),
    [anon_sym_18] = ACTIONS(491),
    [anon_sym_SLASH_BSLASH] = ACTIONS(493),
    [anon_sym_BSLASHland] = ACTIONS(493),
    [anon_sym_19] = ACTIONS(493),
    [anon_sym_BSLASH_SLASH] = ACTIONS(495),
    [anon_sym_BSLASHlor] = ACTIONS(495),
    [anon_sym_20] = ACTIONS(495),
    [anon_sym_COLON_EQ] = ACTIONS(497),
    [anon_sym_21] = ACTIONS(497),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(499),
    [anon_sym_22] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(501),
    [anon_sym_POUND] = ACTIONS(503),
    [anon_sym_23] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(505),
    [sym_gt] = ACTIONS(507),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_LT] = ACTIONS(511),
    [anon_sym_BSLASHleq] = ACTIONS(511),
    [anon_sym_24] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_BSLASHgeq] = ACTIONS(513),
    [anon_sym_25] = ACTIONS(513),
    [anon_sym_BSLASHapprox] = ACTIONS(515),
    [anon_sym_26] = ACTIONS(515),
    [anon_sym_PIPE_DASH] = ACTIONS(517),
    [anon_sym_27] = ACTIONS(517),
    [anon_sym_PIPE_EQ] = ACTIONS(519),
    [anon_sym_28] = ACTIONS(519),
    [anon_sym_DASH_PIPE] = ACTIONS(521),
    [anon_sym_29] = ACTIONS(521),
    [anon_sym_EQ_PIPE] = ACTIONS(523),
    [anon_sym_30] = ACTIONS(523),
    [anon_sym_BSLASHasymp] = ACTIONS(525),
    [anon_sym_31] = ACTIONS(525),
    [anon_sym_BSLASHcong] = ACTIONS(527),
    [anon_sym_32] = ACTIONS(527),
    [anon_sym_BSLASHdoteq] = ACTIONS(529),
    [anon_sym_33] = ACTIONS(529),
    [anon_sym_BSLASHgg] = ACTIONS(531),
    [anon_sym_34] = ACTIONS(531),
    [anon_sym_BSLASHll] = ACTIONS(533),
    [anon_sym_35] = ACTIONS(533),
    [anon_sym_BSLASHnotin] = ACTIONS(535),
    [anon_sym_36] = ACTIONS(535),
    [anon_sym_BSLASHprec] = ACTIONS(537),
    [anon_sym_37] = ACTIONS(539),
    [anon_sym_BSLASHsucc] = ACTIONS(541),
    [anon_sym_38] = ACTIONS(543),
    [anon_sym_BSLASHpreceq] = ACTIONS(545),
    [anon_sym_39] = ACTIONS(545),
    [anon_sym_BSLASHsucceq] = ACTIONS(547),
    [anon_sym_40] = ACTIONS(547),
    [anon_sym_BSLASHsim] = ACTIONS(549),
    [anon_sym_42] = ACTIONS(551),
    [anon_sym_BSLASHsimeq] = ACTIONS(553),
    [anon_sym_43] = ACTIONS(553),
    [anon_sym_BSLASHsqsubset] = ACTIONS(555),
    [anon_sym_44] = ACTIONS(557),
    [anon_sym_BSLASHsqsupset] = ACTIONS(559),
    [anon_sym_45] = ACTIONS(561),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(563),
    [anon_sym_46] = ACTIONS(563),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(565),
    [anon_sym_47] = ACTIONS(565),
    [sym_compose] = ACTIONS(567),
    [sym_map_to] = ACTIONS(567),
    [sym_map_from] = ACTIONS(567),
    [sym_setminus] = ACTIONS(507),
    [anon_sym_BSLASHcap] = ACTIONS(569),
    [anon_sym_BSLASHintersect] = ACTIONS(569),
    [anon_sym_52] = ACTIONS(569),
    [anon_sym_BSLASHcup] = ACTIONS(571),
    [anon_sym_BSLASHunion] = ACTIONS(571),
    [anon_sym_53] = ACTIONS(571),
    [anon_sym_DOT_DOT] = ACTIONS(573),
    [anon_sym_54] = ACTIONS(575),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(577),
    [anon_sym_55] = ACTIONS(577),
    [sym_plus] = ACTIONS(507),
    [sym_plusplus] = ACTIONS(567),
    [anon_sym_BSLASHoplus] = ACTIONS(579),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(579),
    [anon_sym_56] = ACTIONS(579),
    [anon_sym_BSLASHominus] = ACTIONS(581),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(581),
    [anon_sym_57] = ACTIONS(581),
    [sym_mod] = ACTIONS(507),
    [sym_modmod] = ACTIONS(567),
    [sym_vert] = ACTIONS(507),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_58] = ACTIONS(583),
    [sym_minusminus] = ACTIONS(567),
    [sym_amp] = ACTIONS(507),
    [sym_ampamp] = ACTIONS(567),
    [anon_sym_BSLASHodot] = ACTIONS(585),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(585),
    [anon_sym_59] = ACTIONS(585),
    [anon_sym_BSLASHoslash] = ACTIONS(587),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(587),
    [anon_sym_60] = ACTIONS(587),
    [anon_sym_BSLASHotimes] = ACTIONS(589),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(589),
    [anon_sym_61] = ACTIONS(589),
    [sym_mul] = ACTIONS(507),
    [sym_mulmul] = ACTIONS(567),
    [sym_slash] = ACTIONS(507),
    [sym_slashslash] = ACTIONS(567),
    [anon_sym_BSLASHbigcirc] = ACTIONS(591),
    [anon_sym_62] = ACTIONS(591),
    [anon_sym_BSLASHbullet] = ACTIONS(593),
    [anon_sym_63] = ACTIONS(593),
    [anon_sym_BSLASHdiv] = ACTIONS(595),
    [anon_sym_64] = ACTIONS(595),
    [anon_sym_BSLASHo] = ACTIONS(597),
    [anon_sym_BSLASHcirc] = ACTIONS(599),
    [anon_sym_65] = ACTIONS(599),
    [anon_sym_BSLASHstar] = ACTIONS(601),
    [anon_sym_66] = ACTIONS(601),
    [anon_sym_BANG_BANG] = ACTIONS(603),
    [anon_sym_67] = ACTIONS(603),
    [anon_sym_QMARK_QMARK] = ACTIONS(605),
    [anon_sym_68] = ACTIONS(605),
    [sym_hashhash] = ACTIONS(567),
    [sym_dol] = ACTIONS(507),
    [sym_doldol] = ACTIONS(567),
    [anon_sym_BSLASHsqcap] = ACTIONS(607),
    [anon_sym_69] = ACTIONS(607),
    [anon_sym_BSLASHsqcup] = ACTIONS(609),
    [anon_sym_70] = ACTIONS(609),
    [anon_sym_BSLASHuplus] = ACTIONS(611),
    [anon_sym_71] = ACTIONS(611),
    [anon_sym_BSLASHwr] = ACTIONS(613),
    [anon_sym_73] = ACTIONS(613),
    [anon_sym_BSLASHcdot] = ACTIONS(615),
    [anon_sym_74] = ACTIONS(615),
    [sym_pow] = ACTIONS(507),
    [sym_powpow] = ACTIONS(567),
    [anon_sym_CARET_PLUS] = ACTIONS(617),
    [anon_sym_75] = ACTIONS(617),
    [sym_asterisk] = ACTIONS(619),
    [sym_sup_hash] = ACTIONS(619),
    [sym_prime] = ACTIONS(619),
    [sym__indent] = ACTIONS(437),
  },
  [29] = {
    [sym_block_comment] = STATE(29),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym__op_or_expr] = STATE(3234),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym_lambda] = STATE(3213),
    [sym__expr] = STATE(1094),
    [sym_prefixed_op] = STATE(2199),
    [sym_number] = STATE(2199),
    [sym__nat_number] = STATE(2198),
    [sym_boolean] = STATE(2199),
    [sym_primitive_value_set] = STATE(2199),
    [sym_label] = STATE(2199),
    [sym_subexpression] = STATE(2199),
    [sym_parentheses] = STATE(2199),
    [sym_bounded_quantification] = STATE(2199),
    [sym_unbounded_quantification] = STATE(2199),
    [sym_choose] = STATE(2199),
    [sym_finite_set_literal] = STATE(2199),
    [sym_set_filter] = STATE(2199),
    [sym_set_map] = STATE(2199),
    [sym_function_evaluation] = STATE(2199),
    [sym_function_literal] = STATE(2199),
    [sym_set_of_functions] = STATE(2199),
    [sym_record_literal] = STATE(2199),
    [sym_set_of_records] = STATE(2199),
    [sym_record_value] = STATE(2199),
    [sym_except] = STATE(2199),
    [sym_prev_func_val] = STATE(2199),
    [sym_tuple_literal] = STATE(2199),
    [sym_step_expr_or_stutter] = STATE(2199),
    [sym_step_expr_no_stutter] = STATE(2199),
    [sym_fairness] = STATE(2199),
    [sym_if_then_else] = STATE(2199),
    [sym_case] = STATE(2199),
    [sym_let_in] = STATE(2199),
    [sym_conj_list] = STATE(2199),
    [sym_disj_list] = STATE(2199),
    [sym_lnot] = STATE(5),
    [sym_union] = STATE(6),
    [sym_powerset] = STATE(6),
    [sym_domain] = STATE(7),
    [sym_negative] = STATE(797),
    [sym_enabled] = STATE(8),
    [sym_unchanged] = STATE(8),
    [sym_always] = STATE(8),
    [sym_eventually] = STATE(8),
    [sym_standalone_prefix_op_symbol] = STATE(3148),
    [sym_bound_prefix_op] = STATE(2199),
    [sym_implies] = STATE(3192),
    [sym_plus_arrow] = STATE(3192),
    [sym_equiv] = STATE(3192),
    [sym_iff] = STATE(3192),
    [sym_leads_to] = STATE(3192),
    [sym_land] = STATE(3192),
    [sym_lor] = STATE(3192),
    [sym_assign] = STATE(3192),
    [sym_bnf_rule] = STATE(3192),
    [sym_eq] = STATE(3192),
    [sym_neq] = STATE(3192),
    [sym_lt] = STATE(3192),
    [sym_leq] = STATE(3192),
    [sym_geq] = STATE(3192),
    [sym_approx] = STATE(3192),
    [sym_rs_ttile] = STATE(3192),
    [sym_rd_ttile] = STATE(3192),
    [sym_ls_ttile] = STATE(3192),
    [sym_ld_ttile] = STATE(3192),
    [sym_asymp] = STATE(3192),
    [sym_cong] = STATE(3192),
    [sym_doteq] = STATE(3192),
    [sym_gg] = STATE(3192),
    [sym_ll] = STATE(3192),
    [sym_in] = STATE(3192),
    [sym_notin] = STATE(3192),
    [sym_prec] = STATE(3192),
    [sym_succ] = STATE(3192),
    [sym_preceq] = STATE(3192),
    [sym_succeq] = STATE(3192),
    [sym_sim] = STATE(3192),
    [sym_simeq] = STATE(3192),
    [sym_sqsubset] = STATE(3192),
    [sym_sqsupset] = STATE(3192),
    [sym_sqsubseteq] = STATE(3192),
    [sym_sqsupseteq] = STATE(3192),
    [sym_cap] = STATE(3192),
    [sym_cup] = STATE(3192),
    [sym_dots_2] = STATE(3192),
    [sym_dots_3] = STATE(3192),
    [sym_oplus] = STATE(3192),
    [sym_ominus] = STATE(3192),
    [sym_vertvert] = STATE(3192),
    [sym_minus] = STATE(3192),
    [sym_odot] = STATE(3192),
    [sym_oslash] = STATE(3192),
    [sym_otimes] = STATE(3192),
    [sym_bigcirc] = STATE(3192),
    [sym_bullet] = STATE(3192),
    [sym_div] = STATE(3192),
    [sym_circ] = STATE(3192),
    [sym_star] = STATE(3192),
    [sym_excl] = STATE(3192),
    [sym_qq] = STATE(3192),
    [sym_sqcap] = STATE(3192),
    [sym_sqcup] = STATE(3192),
    [sym_uplus] = STATE(3192),
    [sym_wr] = STATE(3192),
    [sym_cdot] = STATE(3192),
    [sym_infix_op_symbol] = STATE(3143),
    [sym_bound_infix_op] = STATE(2199),
    [sym_sup_plus] = STATE(3182),
    [sym_postfix_op_symbol] = STATE(3148),
    [sym_bound_postfix_op] = STATE(2199),
    [sym_module_ref] = STATE(3234),
    [sym_proof_step_ref] = STATE(2180),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(621),
    [anon_sym_BSLASHin] = ACTIONS(623),
    [anon_sym_2] = ACTIONS(625),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(627),
    [anon_sym_10] = ACTIONS(627),
    [anon_sym_AT] = ACTIONS(252),
    [anon_sym_UNION] = ACTIONS(629),
    [anon_sym_ENABLED] = ACTIONS(631),
    [anon_sym_CASE] = ACTIONS(262),
    [anon_sym_SF_] = ACTIONS(264),
    [anon_sym_WF_] = ACTIONS(264),
    [anon_sym_CHOOSE] = ACTIONS(266),
    [anon_sym_IF] = ACTIONS(268),
    [anon_sym_SUBSET] = ACTIONS(633),
    [anon_sym_DOMAIN] = ACTIONS(635),
    [anon_sym_LET] = ACTIONS(276),
    [anon_sym_UNCHANGED] = ACTIONS(637),
    [anon_sym_LAMBDA] = ACTIONS(639),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_LBRACK] = ACTIONS(287),
    [aux_sym_child_id_token1] = ACTIONS(289),
    [sym__real_number] = ACTIONS(291),
    [sym__binary_number] = ACTIONS(291),
    [sym__octal_number] = ACTIONS(291),
    [sym__hex_number] = ACTIONS(291),
    [sym_string] = ACTIONS(293),
    [anon_sym_TRUE] = ACTIONS(295),
    [anon_sym_FALSE] = ACTIONS(295),
    [anon_sym_STRING] = ACTIONS(297),
    [anon_sym_BOOLEAN] = ACTIONS(297),
    [anon_sym_Nat] = ACTIONS(297),
    [anon_sym_Int] = ACTIONS(297),
    [anon_sym_Real] = ACTIONS(297),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_BSLASHlnot] = ACTIONS(647),
    [anon_sym_BSLASHneg] = ACTIONS(647),
    [anon_sym_TILDE] = ACTIONS(649),
    [anon_sym_12] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(651),
    [sym_negative_dot] = ACTIONS(653),
    [anon_sym_LT_GT] = ACTIONS(655),
    [anon_sym_13] = ACTIONS(655),
    [anon_sym_EQ_GT] = ACTIONS(657),
    [anon_sym_14] = ACTIONS(657),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(659),
    [anon_sym_15] = ACTIONS(659),
    [anon_sym_BSLASHequiv] = ACTIONS(661),
    [anon_sym_16] = ACTIONS(661),
    [anon_sym_LT_EQ_GT] = ACTIONS(663),
    [anon_sym_17] = ACTIONS(663),
    [anon_sym_TILDE_GT] = ACTIONS(665),
    [anon_sym_18] = ACTIONS(665),
    [anon_sym_SLASH_BSLASH] = ACTIONS(667),
    [anon_sym_BSLASHland] = ACTIONS(667),
    [anon_sym_19] = ACTIONS(667),
    [anon_sym_BSLASH_SLASH] = ACTIONS(669),
    [anon_sym_BSLASHlor] = ACTIONS(669),
    [anon_sym_20] = ACTIONS(669),
    [anon_sym_COLON_EQ] = ACTIONS(671),
    [anon_sym_21] = ACTIONS(671),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(673),
    [anon_sym_22] = ACTIONS(673),
    [anon_sym_SLASH_EQ] = ACTIONS(675),
    [anon_sym_POUND] = ACTIONS(677),
    [anon_sym_23] = ACTIONS(675),
    [anon_sym_LT] = ACTIONS(313),
    [sym_gt] = ACTIONS(679),
    [anon_sym_LT_EQ] = ACTIONS(681),
    [anon_sym_EQ_LT] = ACTIONS(683),
    [anon_sym_BSLASHleq] = ACTIONS(683),
    [anon_sym_24] = ACTIONS(683),
    [anon_sym_GT_EQ] = ACTIONS(685),
    [anon_sym_BSLASHgeq] = ACTIONS(685),
    [anon_sym_25] = ACTIONS(685),
    [anon_sym_BSLASHapprox] = ACTIONS(687),
    [anon_sym_26] = ACTIONS(687),
    [anon_sym_PIPE_DASH] = ACTIONS(689),
    [anon_sym_27] = ACTIONS(689),
    [anon_sym_PIPE_EQ] = ACTIONS(691),
    [anon_sym_28] = ACTIONS(691),
    [anon_sym_DASH_PIPE] = ACTIONS(693),
    [anon_sym_29] = ACTIONS(693),
    [anon_sym_EQ_PIPE] = ACTIONS(695),
    [anon_sym_30] = ACTIONS(695),
    [anon_sym_BSLASHasymp] = ACTIONS(697),
    [anon_sym_31] = ACTIONS(697),
    [anon_sym_BSLASHcong] = ACTIONS(699),
    [anon_sym_32] = ACTIONS(699),
    [anon_sym_BSLASHdoteq] = ACTIONS(701),
    [anon_sym_33] = ACTIONS(701),
    [anon_sym_BSLASHgg] = ACTIONS(703),
    [anon_sym_34] = ACTIONS(703),
    [anon_sym_BSLASHll] = ACTIONS(705),
    [anon_sym_35] = ACTIONS(705),
    [anon_sym_BSLASHnotin] = ACTIONS(707),
    [anon_sym_36] = ACTIONS(707),
    [anon_sym_BSLASHprec] = ACTIONS(709),
    [anon_sym_37] = ACTIONS(711),
    [anon_sym_BSLASHsucc] = ACTIONS(713),
    [anon_sym_38] = ACTIONS(715),
    [anon_sym_BSLASHpreceq] = ACTIONS(717),
    [anon_sym_39] = ACTIONS(717),
    [anon_sym_BSLASHsucceq] = ACTIONS(719),
    [anon_sym_40] = ACTIONS(719),
    [anon_sym_BSLASHsim] = ACTIONS(721),
    [anon_sym_42] = ACTIONS(723),
    [anon_sym_BSLASHsimeq] = ACTIONS(725),
    [anon_sym_43] = ACTIONS(725),
    [anon_sym_BSLASHsqsubset] = ACTIONS(727),
    [anon_sym_44] = ACTIONS(729),
    [anon_sym_BSLASHsqsupset] = ACTIONS(731),
    [anon_sym_45] = ACTIONS(733),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(735),
    [anon_sym_46] = ACTIONS(735),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(737),
    [anon_sym_47] = ACTIONS(737),
    [sym_compose] = ACTIONS(739),
    [sym_map_to] = ACTIONS(739),
    [sym_map_from] = ACTIONS(739),
    [sym_setminus] = ACTIONS(679),
    [anon_sym_BSLASHcap] = ACTIONS(741),
    [anon_sym_BSLASHintersect] = ACTIONS(741),
    [anon_sym_52] = ACTIONS(741),
    [anon_sym_BSLASHcup] = ACTIONS(743),
    [anon_sym_BSLASHunion] = ACTIONS(743),
    [anon_sym_53] = ACTIONS(743),
    [anon_sym_DOT_DOT] = ACTIONS(745),
    [anon_sym_54] = ACTIONS(747),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(749),
    [anon_sym_55] = ACTIONS(749),
    [sym_plus] = ACTIONS(679),
    [sym_plusplus] = ACTIONS(739),
    [anon_sym_BSLASHoplus] = ACTIONS(751),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(751),
    [anon_sym_56] = ACTIONS(751),
    [anon_sym_BSLASHominus] = ACTIONS(753),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(753),
    [anon_sym_57] = ACTIONS(753),
    [sym_mod] = ACTIONS(679),
    [sym_modmod] = ACTIONS(739),
    [sym_vert] = ACTIONS(679),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_58] = ACTIONS(755),
    [sym_minusminus] = ACTIONS(739),
    [sym_amp] = ACTIONS(679),
    [sym_ampamp] = ACTIONS(739),
    [anon_sym_BSLASHodot] = ACTIONS(757),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(757),
    [anon_sym_59] = ACTIONS(757),
    [anon_sym_BSLASHoslash] = ACTIONS(759),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(759),
    [anon_sym_60] = ACTIONS(759),
    [anon_sym_BSLASHotimes] = ACTIONS(761),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(761),
    [anon_sym_61] = ACTIONS(761),
    [sym_mul] = ACTIONS(679),
    [sym_mulmul] = ACTIONS(739),
    [sym_slash] = ACTIONS(679),
    [sym_slashslash] = ACTIONS(739),
    [anon_sym_BSLASHbigcirc] = ACTIONS(763),
    [anon_sym_62] = ACTIONS(763),
    [anon_sym_BSLASHbullet] = ACTIONS(765),
    [anon_sym_63] = ACTIONS(765),
    [anon_sym_BSLASHdiv] = ACTIONS(767),
    [anon_sym_64] = ACTIONS(767),
    [anon_sym_BSLASHo] = ACTIONS(769),
    [anon_sym_BSLASHcirc] = ACTIONS(771),
    [anon_sym_65] = ACTIONS(771),
    [anon_sym_BSLASHstar] = ACTIONS(773),
    [anon_sym_66] = ACTIONS(773),
    [anon_sym_BANG_BANG] = ACTIONS(775),
    [anon_sym_67] = ACTIONS(775),
    [anon_sym_QMARK_QMARK] = ACTIONS(777),
    [anon_sym_68] = ACTIONS(777),
    [sym_hashhash] = ACTIONS(739),
    [sym_dol] = ACTIONS(679),
    [sym_doldol] = ACTIONS(739),
    [anon_sym_BSLASHsqcap] = ACTIONS(779),
    [anon_sym_69] = ACTIONS(779),
    [anon_sym_BSLASHsqcup] = ACTIONS(781),
    [anon_sym_70] = ACTIONS(781),
    [anon_sym_BSLASHuplus] = ACTIONS(783),
    [anon_sym_71] = ACTIONS(783),
    [anon_sym_BSLASHwr] = ACTIONS(785),
    [anon_sym_73] = ACTIONS(785),
    [anon_sym_BSLASHcdot] = ACTIONS(787),
    [anon_sym_74] = ACTIONS(787),
    [sym_pow] = ACTIONS(679),
    [sym_powpow] = ACTIONS(739),
    [anon_sym_CARET_PLUS] = ACTIONS(789),
    [anon_sym_75] = ACTIONS(789),
    [sym_asterisk] = ACTIONS(791),
    [sym_sup_hash] = ACTIONS(791),
    [sym_prime] = ACTIONS(791),
    [sym__indent] = ACTIONS(315),
  },
  [30] = {
    [sym_block_comment] = STATE(30),
    [sym_forall] = STATE(3580),
    [sym_exists] = STATE(3580),
    [sym_temporal_forall] = STATE(4322),
    [sym_temporal_exists] = STATE(4322),
    [sym_langle_bracket] = STATE(86),
    [sym__op_or_expr] = STATE(4147),
    [sym_subexpr_prefix] = STATE(1192),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2733),
    [sym_bound_nonfix_op] = STATE(2733),
    [sym_lambda] = STATE(3470),
    [sym__expr] = STATE(1797),
    [sym_prefixed_op] = STATE(2821),
    [sym_number] = STATE(2821),
    [sym__nat_number] = STATE(2822),
    [sym_boolean] = STATE(2821),
    [sym_primitive_value_set] = STATE(2821),
    [sym_label] = STATE(2821),
    [sym_subexpression] = STATE(2821),
    [sym_parentheses] = STATE(2821),
    [sym_bounded_quantification] = STATE(2821),
    [sym_unbounded_quantification] = STATE(2821),
    [sym_choose] = STATE(2821),
    [sym_finite_set_literal] = STATE(2821),
    [sym_set_filter] = STATE(2821),
    [sym_set_map] = STATE(2821),
    [sym_function_evaluation] = STATE(2821),
    [sym_function_literal] = STATE(2821),
    [sym_set_of_functions] = STATE(2821),
    [sym_record_literal] = STATE(2821),
    [sym_set_of_records] = STATE(2821),
    [sym_record_value] = STATE(2821),
    [sym_except] = STATE(2821),
    [sym_prev_func_val] = STATE(2821),
    [sym_tuple_literal] = STATE(2821),
    [sym_step_expr_or_stutter] = STATE(2821),
    [sym_step_expr_no_stutter] = STATE(2821),
    [sym_fairness] = STATE(2821),
    [sym_if_then_else] = STATE(2821),
    [sym_case] = STATE(2821),
    [sym_let_in] = STATE(2821),
    [sym_conj_list] = STATE(2821),
    [sym_disj_list] = STATE(2821),
    [sym_lnot] = STATE(152),
    [sym_union] = STATE(147),
    [sym_powerset] = STATE(147),
    [sym_domain] = STATE(141),
    [sym_negative] = STATE(784),
    [sym_enabled] = STATE(140),
    [sym_unchanged] = STATE(140),
    [sym_always] = STATE(140),
    [sym_eventually] = STATE(140),
    [sym_standalone_prefix_op_symbol] = STATE(3745),
    [sym_bound_prefix_op] = STATE(2821),
    [sym_implies] = STATE(3445),
    [sym_plus_arrow] = STATE(3445),
    [sym_equiv] = STATE(3445),
    [sym_iff] = STATE(3445),
    [sym_leads_to] = STATE(3445),
    [sym_land] = STATE(3445),
    [sym_lor] = STATE(3445),
    [sym_assign] = STATE(3445),
    [sym_bnf_rule] = STATE(3445),
    [sym_eq] = STATE(3445),
    [sym_neq] = STATE(3445),
    [sym_lt] = STATE(3445),
    [sym_leq] = STATE(3445),
    [sym_geq] = STATE(3445),
    [sym_approx] = STATE(3445),
    [sym_rs_ttile] = STATE(3445),
    [sym_rd_ttile] = STATE(3445),
    [sym_ls_ttile] = STATE(3445),
    [sym_ld_ttile] = STATE(3445),
    [sym_asymp] = STATE(3445),
    [sym_cong] = STATE(3445),
    [sym_doteq] = STATE(3445),
    [sym_gg] = STATE(3445),
    [sym_ll] = STATE(3445),
    [sym_in] = STATE(3445),
    [sym_notin] = STATE(3445),
    [sym_prec] = STATE(3445),
    [sym_succ] = STATE(3445),
    [sym_preceq] = STATE(3445),
    [sym_succeq] = STATE(3445),
    [sym_sim] = STATE(3445),
    [sym_simeq] = STATE(3445),
    [sym_sqsubset] = STATE(3445),
    [sym_sqsupset] = STATE(3445),
    [sym_sqsubseteq] = STATE(3445),
    [sym_sqsupseteq] = STATE(3445),
    [sym_cap] = STATE(3445),
    [sym_cup] = STATE(3445),
    [sym_dots_2] = STATE(3445),
    [sym_dots_3] = STATE(3445),
    [sym_oplus] = STATE(3445),
    [sym_ominus] = STATE(3445),
    [sym_vertvert] = STATE(3445),
    [sym_minus] = STATE(3445),
    [sym_odot] = STATE(3445),
    [sym_oslash] = STATE(3445),
    [sym_otimes] = STATE(3445),
    [sym_bigcirc] = STATE(3445),
    [sym_bullet] = STATE(3445),
    [sym_div] = STATE(3445),
    [sym_circ] = STATE(3445),
    [sym_star] = STATE(3445),
    [sym_excl] = STATE(3445),
    [sym_qq] = STATE(3445),
    [sym_sqcap] = STATE(3445),
    [sym_sqcup] = STATE(3445),
    [sym_uplus] = STATE(3445),
    [sym_wr] = STATE(3445),
    [sym_cdot] = STATE(3445),
    [sym_infix_op_symbol] = STATE(3744),
    [sym_bound_infix_op] = STATE(2821),
    [sym_sup_plus] = STATE(3416),
    [sym_postfix_op_symbol] = STATE(3745),
    [sym_bound_postfix_op] = STATE(2821),
    [sym_module_ref] = STATE(4147),
    [sym_proof_step_ref] = STATE(2721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(399),
    [anon_sym_BSLASHin] = ACTIONS(453),
    [anon_sym_2] = ACTIONS(455),
    [anon_sym_BSLASHA] = ACTIONS(15),
    [anon_sym_BSLASHforall] = ACTIONS(17),
    [anon_sym_4] = ACTIONS(17),
    [anon_sym_BSLASHE] = ACTIONS(19),
    [anon_sym_BSLASHexists] = ACTIONS(21),
    [anon_sym_5] = ACTIONS(21),
    [anon_sym_BSLASHAA] = ACTIONS(23),
    [anon_sym_BSLASHEE] = ACTIONS(25),
    [anon_sym_LT_LT] = ACTIONS(27),
    [anon_sym_8] = ACTIONS(27),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(457),
    [anon_sym_10] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(401),
    [anon_sym_UNION] = ACTIONS(459),
    [anon_sym_ENABLED] = ACTIONS(461),
    [anon_sym_CASE] = ACTIONS(403),
    [anon_sym_SF_] = ACTIONS(405),
    [anon_sym_WF_] = ACTIONS(405),
    [anon_sym_CHOOSE] = ACTIONS(407),
    [anon_sym_IF] = ACTIONS(409),
    [anon_sym_SUBSET] = ACTIONS(463),
    [anon_sym_DOMAIN] = ACTIONS(465),
    [anon_sym_LET] = ACTIONS(411),
    [anon_sym_UNCHANGED] = ACTIONS(467),
    [anon_sym_LAMBDA] = ACTIONS(469),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(421),
    [aux_sym_child_id_token1] = ACTIONS(423),
    [sym__real_number] = ACTIONS(425),
    [sym__binary_number] = ACTIONS(425),
    [sym__octal_number] = ACTIONS(425),
    [sym__hex_number] = ACTIONS(425),
    [sym_string] = ACTIONS(427),
    [anon_sym_TRUE] = ACTIONS(429),
    [anon_sym_FALSE] = ACTIONS(429),
    [anon_sym_STRING] = ACTIONS(431),
    [anon_sym_BOOLEAN] = ACTIONS(431),
    [anon_sym_Nat] = ACTIONS(431),
    [anon_sym_Int] = ACTIONS(431),
    [anon_sym_Real] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(471),
    [anon_sym_BSLASHlnot] = ACTIONS(473),
    [anon_sym_BSLASHneg] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(475),
    [anon_sym_12] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(477),
    [sym_negative_dot] = ACTIONS(479),
    [anon_sym_LT_GT] = ACTIONS(481),
    [anon_sym_13] = ACTIONS(481),
    [anon_sym_EQ_GT] = ACTIONS(483),
    [anon_sym_14] = ACTIONS(483),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(485),
    [anon_sym_15] = ACTIONS(485),
    [anon_sym_BSLASHequiv] = ACTIONS(487),
    [anon_sym_16] = ACTIONS(487),
    [anon_sym_LT_EQ_GT] = ACTIONS(489),
    [anon_sym_17] = ACTIONS(489),
    [anon_sym_TILDE_GT] = ACTIONS(491),
    [anon_sym_18] = ACTIONS(491),
    [anon_sym_SLASH_BSLASH] = ACTIONS(493),
    [anon_sym_BSLASHland] = ACTIONS(493),
    [anon_sym_19] = ACTIONS(493),
    [anon_sym_BSLASH_SLASH] = ACTIONS(495),
    [anon_sym_BSLASHlor] = ACTIONS(495),
    [anon_sym_20] = ACTIONS(495),
    [anon_sym_COLON_EQ] = ACTIONS(497),
    [anon_sym_21] = ACTIONS(497),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(499),
    [anon_sym_22] = ACTIONS(499),
    [anon_sym_SLASH_EQ] = ACTIONS(501),
    [anon_sym_POUND] = ACTIONS(503),
    [anon_sym_23] = ACTIONS(501),
    [anon_sym_LT] = ACTIONS(505),
    [sym_gt] = ACTIONS(507),
    [anon_sym_LT_EQ] = ACTIONS(509),
    [anon_sym_EQ_LT] = ACTIONS(511),
    [anon_sym_BSLASHleq] = ACTIONS(511),
    [anon_sym_24] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_BSLASHgeq] = ACTIONS(513),
    [anon_sym_25] = ACTIONS(513),
    [anon_sym_BSLASHapprox] = ACTIONS(515),
    [anon_sym_26] = ACTIONS(515),
    [anon_sym_PIPE_DASH] = ACTIONS(517),
    [anon_sym_27] = ACTIONS(517),
    [anon_sym_PIPE_EQ] = ACTIONS(519),
    [anon_sym_28] = ACTIONS(519),
    [anon_sym_DASH_PIPE] = ACTIONS(521),
    [anon_sym_29] = ACTIONS(521),
    [anon_sym_EQ_PIPE] = ACTIONS(523),
    [anon_sym_30] = ACTIONS(523),
    [anon_sym_BSLASHasymp] = ACTIONS(525),
    [anon_sym_31] = ACTIONS(525),
    [anon_sym_BSLASHcong] = ACTIONS(527),
    [anon_sym_32] = ACTIONS(527),
    [anon_sym_BSLASHdoteq] = ACTIONS(529),
    [anon_sym_33] = ACTIONS(529),
    [anon_sym_BSLASHgg] = ACTIONS(531),
    [anon_sym_34] = ACTIONS(531),
    [anon_sym_BSLASHll] = ACTIONS(533),
    [anon_sym_35] = ACTIONS(533),
    [anon_sym_BSLASHnotin] = ACTIONS(535),
    [anon_sym_36] = ACTIONS(535),
    [anon_sym_BSLASHprec] = ACTIONS(537),
    [anon_sym_37] = ACTIONS(539),
    [anon_sym_BSLASHsucc] = ACTIONS(541),
    [anon_sym_38] = ACTIONS(543),
    [anon_sym_BSLASHpreceq] = ACTIONS(545),
    [anon_sym_39] = ACTIONS(545),
    [anon_sym_BSLASHsucceq] = ACTIONS(547),
    [anon_sym_40] = ACTIONS(547),
    [anon_sym_BSLASHsim] = ACTIONS(549),
    [anon_sym_42] = ACTIONS(551),
    [anon_sym_BSLASHsimeq] = ACTIONS(553),
    [anon_sym_43] = ACTIONS(553),
    [anon_sym_BSLASHsqsubset] = ACTIONS(555),
    [anon_sym_44] = ACTIONS(557),
    [anon_sym_BSLASHsqsupset] = ACTIONS(559),
    [anon_sym_45] = ACTIONS(561),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(563),
    [anon_sym_46] = ACTIONS(563),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(565),
    [anon_sym_47] = ACTIONS(565),
    [sym_compose] = ACTIONS(567),
    [sym_map_to] = ACTIONS(567),
    [sym_map_from] = ACTIONS(567),
    [sym_setminus] = ACTIONS(507),
    [anon_sym_BSLASHcap] = ACTIONS(569),
    [anon_sym_BSLASHintersect] = ACTIONS(569),
    [anon_sym_52] = ACTIONS(569),
    [anon_sym_BSLASHcup] = ACTIONS(571),
    [anon_sym_BSLASHunion] = ACTIONS(571),
    [anon_sym_53] = ACTIONS(571),
    [anon_sym_DOT_DOT] = ACTIONS(573),
    [anon_sym_54] = ACTIONS(575),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(577),
    [anon_sym_55] = ACTIONS(577),
    [sym_plus] = ACTIONS(507),
    [sym_plusplus] = ACTIONS(567),
    [anon_sym_BSLASHoplus] = ACTIONS(579),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(579),
    [anon_sym_56] = ACTIONS(579),
    [anon_sym_BSLASHominus] = ACTIONS(581),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(581),
    [anon_sym_57] = ACTIONS(581),
    [sym_mod] = ACTIONS(507),
    [sym_modmod] = ACTIONS(567),
    [sym_vert] = ACTIONS(507),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [anon_sym_58] = ACTIONS(583),
    [sym_minusminus] = ACTIONS(567),
    [sym_amp] = ACTIONS(507),
    [sym_ampamp] = ACTIONS(567),
    [anon_sym_BSLASHodot] = ACTIONS(585),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(585),
    [anon_sym_59] = ACTIONS(585),
    [anon_sym_BSLASHoslash] = ACTIONS(587),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(587),
    [anon_sym_60] = ACTIONS(587),
    [anon_sym_BSLASHotimes] = ACTIONS(589),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(589),
    [anon_sym_61] = ACTIONS(589),
    [sym_mul] = ACTIONS(507),
    [sym_mulmul] = ACTIONS(567),
    [sym_slash] = ACTIONS(507),
    [sym_slashslash] = ACTIONS(567),
    [anon_sym_BSLASHbigcirc] = ACTIONS(591),
    [anon_sym_62] = ACTIONS(591),
    [anon_sym_BSLASHbullet] = ACTIONS(593),
    [anon_sym_63] = ACTIONS(593),
    [anon_sym_BSLASHdiv] = ACTIONS(595),
    [anon_sym_64] = ACTIONS(595),
    [anon_sym_BSLASHo] = ACTIONS(597),
    [anon_sym_BSLASHcirc] = ACTIONS(599),
    [anon_sym_65] = ACTIONS(599),
    [anon_sym_BSLASHstar] = ACTIONS(601),
    [anon_sym_66] = ACTIONS(601),
    [anon_sym_BANG_BANG] = ACTIONS(603),
    [anon_sym_67] = ACTIONS(603),
    [anon_sym_QMARK_QMARK] = ACTIONS(605),
    [anon_sym_68] = ACTIONS(605),
    [sym_hashhash] = ACTIONS(567),
    [sym_dol] = ACTIONS(507),
    [sym_doldol] = ACTIONS(567),
    [anon_sym_BSLASHsqcap] = ACTIONS(607),
    [anon_sym_69] = ACTIONS(607),
    [anon_sym_BSLASHsqcup] = ACTIONS(609),
    [anon_sym_70] = ACTIONS(609),
    [anon_sym_BSLASHuplus] = ACTIONS(611),
    [anon_sym_71] = ACTIONS(611),
    [anon_sym_BSLASHwr] = ACTIONS(613),
    [anon_sym_73] = ACTIONS(613),
    [anon_sym_BSLASHcdot] = ACTIONS(615),
    [anon_sym_74] = ACTIONS(615),
    [sym_pow] = ACTIONS(507),
    [sym_powpow] = ACTIONS(567),
    [anon_sym_CARET_PLUS] = ACTIONS(617),
    [anon_sym_75] = ACTIONS(617),
    [sym_asterisk] = ACTIONS(619),
    [sym_sup_hash] = ACTIONS(619),
    [sym_prime] = ACTIONS(619),
    [sym__indent] = ACTIONS(437),
  },
  [31] = {
    [sym_block_comment] = STATE(31),
    [sym_forall] = STATE(3619),
    [sym_exists] = STATE(3619),
    [sym_temporal_forall] = STATE(4388),
    [sym_temporal_exists] = STATE(4388),
    [sym_langle_bracket] = STATE(132),
    [sym__op_or_expr] = STATE(3215),
    [sym_subexpr_prefix] = STATE(1188),
    [sym_subexpr_component] = STATE(4384),
    [sym_bound_op] = STATE(2179),
    [sym_bound_nonfix_op] = STATE(2179),
    [sym_lambda] = STATE(3213),
    [sym__expr] = STATE(1094),
    [sym_prefixed_op] = STATE(2199),
    [sym_nu