#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 901
#define LARGE_STATE_COUNT 321
#define SYMBOL_COUNT 487
#define ALIAS_COUNT 3
#define TOKEN_COUNT 321
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 26
#define MAX_ALIAS_SEQUENCE_LENGTH 12

enum {
  sym_identifier = 1,
  anon_sym_pragma = 2,
  anon_sym_solidity = 3,
  sym__solidity_version = 4,
  anon_sym_LT_EQ = 5,
  anon_sym_LT = 6,
  anon_sym_CARET = 7,
  anon_sym_GT = 8,
  anon_sym_GT_EQ = 9,
  anon_sym_TILDE = 10,
  anon_sym_EQ = 11,
  anon_sym_import = 12,
  anon_sym_as = 13,
  anon_sym_from = 14,
  anon_sym_STAR = 15,
  anon_sym_LBRACE = 16,
  anon_sym_COMMA = 17,
  anon_sym_RBRACE = 18,
  anon_sym_abstract = 19,
  anon_sym_contract = 20,
  anon_sym_interface = 21,
  anon_sym_library = 22,
  anon_sym_is = 23,
  anon_sym_struct = 24,
  anon_sym_enum = 25,
  anon_sym_event = 26,
  anon_sym_anonymous = 27,
  anon_sym_LPAREN = 28,
  anon_sym_RPAREN = 29,
  anon_sym_indexed = 30,
  anon_sym_using = 31,
  anon_sym_for = 32,
  anon_sym_assembly = 33,
  anon_sym_DQUOTEevmasm_DQUOTE = 34,
  sym_yul_leave = 35,
  anon_sym_break = 36,
  anon_sym_continue = 37,
  sym_yul_identifier = 38,
  anon_sym_DOT = 39,
  sym_yul_decimal_number = 40,
  sym_yul_hex_number = 41,
  anon_sym_true = 42,
  anon_sym_false = 43,
  anon_sym_let = 44,
  anon_sym_COLON_EQ = 45,
  anon_sym_if = 46,
  anon_sym_switch = 47,
  anon_sym_default = 48,
  anon_sym_case = 49,
  anon_sym_function = 50,
  anon_sym_DASH_GT = 51,
  anon_sym_stop = 52,
  anon_sym_add = 53,
  anon_sym_sub = 54,
  anon_sym_mul = 55,
  anon_sym_div = 56,
  anon_sym_sdiv = 57,
  anon_sym_mod = 58,
  anon_sym_smod = 59,
  anon_sym_exp = 60,
  anon_sym_not = 61,
  anon_sym_lt = 62,
  anon_sym_gt = 63,
  anon_sym_slt = 64,
  anon_sym_sgt = 65,
  anon_sym_eq = 66,
  anon_sym_iszero = 67,
  anon_sym_and = 68,
  anon_sym_or = 69,
  anon_sym_xor = 70,
  anon_sym_byte = 71,
  anon_sym_shl = 72,
  anon_sym_shr = 73,
  anon_sym_sar = 74,
  anon_sym_addmod = 75,
  anon_sym_mulmod = 76,
  anon_sym_signextend = 77,
  anon_sym_keccak256 = 78,
  anon_sym_pop = 79,
  anon_sym_mload = 80,
  anon_sym_mstore = 81,
  anon_sym_mstore8 = 82,
  anon_sym_sload = 83,
  anon_sym_sstore = 84,
  anon_sym_msize = 85,
  anon_sym_gas = 86,
  anon_sym_address = 87,
  anon_sym_balance = 88,
  anon_sym_selfbalance = 89,
  anon_sym_caller = 90,
  anon_sym_callvalue = 91,
  anon_sym_calldataload = 92,
  anon_sym_calldatasize = 93,
  anon_sym_calldatacopy = 94,
  anon_sym_extcodesize = 95,
  anon_sym_extcodecopy = 96,
  anon_sym_returndatasize = 97,
  anon_sym_returndatacopy = 98,
  anon_sym_extcodehash = 99,
  anon_sym_create = 100,
  anon_sym_create2 = 101,
  anon_sym_call = 102,
  anon_sym_callcode = 103,
  anon_sym_delegatecall = 104,
  anon_sym_staticcall = 105,
  anon_sym_return = 106,
  anon_sym_revert = 107,
  anon_sym_selfdestruct = 108,
  anon_sym_invalid = 109,
  anon_sym_log0 = 110,
  anon_sym_log1 = 111,
  anon_sym_log2 = 112,
  anon_sym_log3 = 113,
  anon_sym_log4 = 114,
  anon_sym_chainid = 115,
  anon_sym_origin = 116,
  anon_sym_gasprice = 117,
  anon_sym_blockhash = 118,
  anon_sym_coinbase = 119,
  anon_sym_timestamp = 120,
  anon_sym_number = 121,
  anon_sym_difficulty = 122,
  anon_sym_gaslimit = 123,
  anon_sym_memory = 124,
  anon_sym_storage = 125,
  anon_sym_calldata = 126,
  anon_sym_var = 127,
  anon_sym_else = 128,
  anon_sym_while = 129,
  anon_sym_do = 130,
  anon_sym_try = 131,
  anon_sym_returns = 132,
  anon_sym_catch = 133,
  anon_sym_emit = 134,
  sym_constant = 135,
  anon_sym_public = 136,
  anon_sym_internal = 137,
  anon_sym_private = 138,
  anon_sym_external = 139,
  anon_sym_pure = 140,
  anon_sym_view = 141,
  anon_sym_payable = 142,
  sym_immutable = 143,
  anon_sym_override = 144,
  anon_sym_modifier = 145,
  anon_sym_constructor = 146,
  anon_sym_fallback = 147,
  anon_sym_receive = 148,
  sym_virtual = 149,
  anon_sym_QMARK = 150,
  anon_sym_COLON = 151,
  anon_sym_new = 152,
  anon_sym_LBRACK = 153,
  anon_sym_RBRACK = 154,
  anon_sym_AMP_AMP = 155,
  anon_sym_PIPE_PIPE = 156,
  anon_sym_GT_GT = 157,
  anon_sym_GT_GT_GT = 158,
  anon_sym_LT_LT = 159,
  anon_sym_AMP = 160,
  anon_sym_PIPE = 161,
  anon_sym_PLUS = 162,
  anon_sym_DASH = 163,
  anon_sym_SLASH = 164,
  anon_sym_PERCENT = 165,
  anon_sym_STAR_STAR = 166,
  anon_sym_EQ_EQ = 167,
  anon_sym_BANG_EQ = 168,
  anon_sym_BANG_EQ_EQ = 169,
  anon_sym_BANG = 170,
  anon_sym_delete = 171,
  anon_sym_PLUS_PLUS = 172,
  anon_sym_DASH_DASH = 173,
  anon_sym_PLUS_EQ = 174,
  anon_sym_DASH_EQ = 175,
  anon_sym_STAR_EQ = 176,
  anon_sym_SLASH_EQ = 177,
  anon_sym_PERCENT_EQ = 178,
  anon_sym_CARET_EQ = 179,
  anon_sym_AMP_EQ = 180,
  anon_sym_PIPE_EQ = 181,
  anon_sym_GT_GT_EQ = 182,
  anon_sym_GT_GT_GT_EQ = 183,
  anon_sym_LT_LT_EQ = 184,
  anon_sym_type = 185,
  anon_sym_mapping = 186,
  anon_sym_EQ_GT = 187,
  anon_sym_bool = 188,
  anon_sym_string = 189,
  anon_sym_int = 190,
  anon_sym_int8 = 191,
  anon_sym_int16 = 192,
  anon_sym_int24 = 193,
  anon_sym_int32 = 194,
  anon_sym_int40 = 195,
  anon_sym_int48 = 196,
  anon_sym_int56 = 197,
  anon_sym_int64 = 198,
  anon_sym_int72 = 199,
  anon_sym_int80 = 200,
  anon_sym_int88 = 201,
  anon_sym_int96 = 202,
  anon_sym_int104 = 203,
  anon_sym_int112 = 204,
  anon_sym_int120 = 205,
  anon_sym_int128 = 206,
  anon_sym_int136 = 207,
  anon_sym_int144 = 208,
  anon_sym_int152 = 209,
  anon_sym_int160 = 210,
  anon_sym_int168 = 211,
  anon_sym_int176 = 212,
  anon_sym_int184 = 213,
  anon_sym_int192 = 214,
  anon_sym_int200 = 215,
  anon_sym_int208 = 216,
  anon_sym_int216 = 217,
  anon_sym_int224 = 218,
  anon_sym_int232 = 219,
  anon_sym_int240 = 220,
  anon_sym_int248 = 221,
  anon_sym_int256 = 222,
  anon_sym_uint = 223,
  anon_sym_uint8 = 224,
  anon_sym_uint16 = 225,
  anon_sym_uint24 = 226,
  anon_sym_uint32 = 227,
  anon_sym_uint40 = 228,
  anon_sym_uint48 = 229,
  anon_sym_uint56 = 230,
  anon_sym_uint64 = 231,
  anon_sym_uint72 = 232,
  anon_sym_uint80 = 233,
  anon_sym_uint88 = 234,
  anon_sym_uint96 = 235,
  anon_sym_uint104 = 236,
  anon_sym_uint112 = 237,
  anon_sym_uint120 = 238,
  anon_sym_uint128 = 239,
  anon_sym_uint136 = 240,
  anon_sym_uint144 = 241,
  anon_sym_uint152 = 242,
  anon_sym_uint160 = 243,
  anon_sym_uint168 = 244,
  anon_sym_uint176 = 245,
  anon_sym_uint184 = 246,
  anon_sym_uint192 = 247,
  anon_sym_uint200 = 248,
  anon_sym_uint208 = 249,
  anon_sym_uint216 = 250,
  anon_sym_uint224 = 251,
  anon_sym_uint232 = 252,
  anon_sym_uint240 = 253,
  anon_sym_uint248 = 254,
  anon_sym_uint256 = 255,
  anon_sym_bytes = 256,
  anon_sym_bytes1 = 257,
  anon_sym_bytes2 = 258,
  anon_sym_bytes3 = 259,
  anon_sym_bytes4 = 260,
  anon_sym_bytes5 = 261,
  anon_sym_bytes6 = 262,
  anon_sym_bytes7 = 263,
  anon_sym_bytes8 = 264,
  anon_sym_bytes9 = 265,
  anon_sym_bytes10 = 266,
  anon_sym_bytes11 = 267,
  anon_sym_bytes12 = 268,
  anon_sym_bytes13 = 269,
  anon_sym_bytes14 = 270,
  anon_sym_bytes15 = 271,
  anon_sym_bytes16 = 272,
  anon_sym_bytes17 = 273,
  anon_sym_bytes18 = 274,
  anon_sym_bytes19 = 275,
  anon_sym_bytes20 = 276,
  anon_sym_bytes21 = 277,
  anon_sym_bytes22 = 278,
  anon_sym_bytes23 = 279,
  anon_sym_bytes24 = 280,
  anon_sym_bytes25 = 281,
  anon_sym_bytes26 = 282,
  anon_sym_bytes27 = 283,
  anon_sym_bytes28 = 284,
  anon_sym_bytes29 = 285,
  anon_sym_bytes30 = 286,
  anon_sym_bytes31 = 287,
  anon_sym_bytes32 = 288,
  anon_sym_fixed = 289,
  aux_sym__fixed_token1 = 290,
  anon_sym_ufixed = 291,
  aux_sym__ufixed_token1 = 292,
  sym__semicolon = 293,
  sym_number = 294,
  aux_sym__decimal_number_token1 = 295,
  aux_sym__decimal_number_token2 = 296,
  aux_sym__hex_number_token1 = 297,
  anon_sym__ = 298,
  sym__hex_digit = 299,
  anon_sym_wei = 300,
  anon_sym_szabo = 301,
  anon_sym_finney = 302,
  anon_sym_gwei = 303,
  anon_sym_ether = 304,
  anon_sym_seconds = 305,
  anon_sym_minutes = 306,
  anon_sym_hours = 307,
  anon_sym_days = 308,
  anon_sym_weeks = 309,
  anon_sym_years = 310,
  anon_sym_hex = 311,
  anon_sym_DQUOTE = 312,
  anon_sym_SQUOTE = 313,
  sym__escape_sequence = 314,
  aux_sym__single_quoted_unicode_char_token1 = 315,
  aux_sym__double_quoted_unicode_char_token1 = 316,
  anon_sym_unicode = 317,
  aux_sym_string_token1 = 318,
  aux_sym_string_token2 = 319,
  sym_comment = 320,
  sym_source_file = 321,
  sym__source_unit = 322,
  sym__directive = 323,
  sym_pragma_directive = 324,
  sym__pragma_version_constraint = 325,
  sym__solidity_version_comparison_operator = 326,
  sym_import_directive = 327,
  sym__source_import = 328,
  sym__import_clause = 329,
  sym__from_clause = 330,
  sym__single_import = 331,
  sym__multiple_import = 332,
  sym__import_declaration = 333,
  sym__declaration = 334,
  sym_constant_variable_declaration = 335,
  sym_contract_declaration = 336,
  sym_interface_declaration = 337,
  sym_library_declaration = 338,
  sym__class_heritage = 339,
  sym_inheritance_specifier = 340,
  sym_contract_body = 341,
  sym_struct_declaration = 342,
  sym_struct_member = 343,
  sym_enum_declaration = 344,
  sym_event_definition = 345,
  sym__event_parameter_list = 346,
  sym_event_paramater = 347,
  sym_using_directive = 348,
  sym_any_source_type = 349,
  sym__statement = 350,
  sym_assembly_statement = 351,
  sym__yul_statement = 352,
  sym_yul_break = 353,
  sym_yul_continue = 354,
  sym__yul_expression = 355,
  sym_yul_path = 356,
  sym__yul_literal = 357,
  sym_yul_string_literal = 358,
  sym_yul_boolean = 359,
  sym_yul_block = 360,
  sym_yul_variable_declaration = 361,
  sym_yul_assignment = 362,
  sym_yul_function_call = 363,
  sym_yul_if_statement = 364,
  sym_yul_for_statement = 365,
  sym_yul_switch_statement = 366,
  sym_yul_function_definition = 367,
  sym_yul_evm_builtin = 368,
  sym_block_statement = 369,
  sym_variable_declaration_statement = 370,
  sym_variable_declaration = 371,
  sym_variable_declaration_tuple = 372,
  sym_expression_statement = 373,
  sym_if_statement = 374,
  sym_for_statement = 375,
  sym_while_statement = 376,
  sym_do_while_statement = 377,
  sym_continue_statement = 378,
  sym_break_statement = 379,
  sym_try_statement = 380,
  sym_catch_clause = 381,
  sym_return_statement = 382,
  sym_emit_statement = 383,
  sym_state_variable_declaration = 384,
  sym_visibility = 385,
  sym_state_mutability = 386,
  sym_override_specifier = 387,
  sym_modifier_definition = 388,
  sym_constructor_definition = 389,
  sym_fallback_receive_definition = 390,
  sym_function_definition = 391,
  sym_modifier_invocation = 392,
  sym__call_arguments = 393,
  sym_function_body = 394,
  sym__expression = 395,
  sym__primary_expression = 396,
  sym_type_cast_expression = 397,
  sym_ternary_expression = 398,
  sym_new_expression = 399,
  sym_tuple_expression = 400,
  sym_inline_array_expression = 401,
  sym_binary_expression = 402,
  sym_unary_expression = 403,
  sym_update_expression = 404,
  sym_member_expression = 405,
  sym_array_access = 406,
  sym_slice_access = 407,
  sym_struct_expression = 408,
  sym__lhs_expression = 409,
  sym_parenthesized_expression = 410,
  sym_assignment_expression = 411,
  sym_augmented_assignment_expression = 412,
  sym_call_expression = 413,
  sym_payable_conversion_expression = 414,
  sym_meta_type_expression = 415,
  sym_type_name = 416,
  sym__array_type = 417,
  sym__function_type = 418,
  sym__parameter_list = 419,
  sym__return_parameters = 420,
  sym__nameless_parameter = 421,
  sym__parameter = 422,
  sym__storage_location = 423,
  sym__user_defined_type = 424,
  sym__mapping = 425,
  sym__mapping_key = 426,
  sym_primitive_type = 427,
  sym__int = 428,
  sym__uint = 429,
  sym__bytes = 430,
  sym__fixed = 431,
  sym__ufixed = 432,
  sym__literal = 433,
  sym_string_literal = 434,
  sym_number_literal = 435,
  sym__decimal_number = 436,
  sym__hex_number = 437,
  sym_number_unit = 438,
  sym_true = 439,
  sym_false = 440,
  sym_boolean_literal = 441,
  sym_hex_string_literal = 442,
  sym__single_quoted_unicode_char = 443,
  sym__double_quoted_unicode_char = 444,
  sym_unicode_string_literal = 445,
  sym_string = 446,
  aux_sym_source_file_repeat1 = 447,
  aux_sym_pragma_directive_repeat1 = 448,
  aux_sym__multiple_import_repeat1 = 449,
  aux_sym__class_heritage_repeat1 = 450,
  aux_sym_contract_body_repeat1 = 451,
  aux_sym_struct_declaration_repeat1 = 452,
  aux_sym_enum_declaration_repeat1 = 453,
  aux_sym__event_parameter_list_repeat1 = 454,
  aux_sym_assembly_statement_repeat1 = 455,
  aux_sym_yul_path_repeat1 = 456,
  aux_sym_yul_variable_declaration_repeat1 = 457,
  aux_sym_yul_assignment_repeat1 = 458,
  aux_sym_yul_function_call_repeat1 = 459,
  aux_sym_yul_switch_statement_repeat1 = 460,
  aux_sym_block_statement_repeat1 = 461,
  aux_sym_variable_declaration_tuple_repeat1 = 462,
  aux_sym_variable_declaration_tuple_repeat2 = 463,
  aux_sym_try_statement_repeat1 = 464,
  aux_sym_state_variable_declaration_repeat1 = 465,
  aux_sym_override_specifier_repeat1 = 466,
  aux_sym_modifier_definition_repeat1 = 467,
  aux_sym_constructor_definition_repeat1 = 468,
  aux_sym_fallback_receive_definition_repeat1 = 469,
  aux_sym_function_definition_repeat1 = 470,
  aux_sym__call_arguments_repeat1 = 471,
  aux_sym__call_arguments_repeat2 = 472,
  aux_sym_tuple_expression_repeat1 = 473,
  aux_sym_inline_array_expression_repeat1 = 474,
  aux_sym_struct_expression_repeat1 = 475,
  aux_sym__parameter_list_repeat1 = 476,
  aux_sym__return_parameters_repeat1 = 477,
  aux_sym__user_defined_type_repeat1 = 478,
  aux_sym_string_literal_repeat1 = 479,
  aux_sym__hex_number_repeat1 = 480,
  aux_sym_hex_string_literal_repeat1 = 481,
  aux_sym_unicode_string_literal_repeat1 = 482,
  aux_sym_unicode_string_literal_repeat2 = 483,
  aux_sym_unicode_string_literal_repeat3 = 484,
  aux_sym_string_repeat1 = 485,
  aux_sym_string_repeat2 = 486,
  alias_sym_enum_value = 487,
  alias_sym_property_identifier = 488,
  alias_sym_type_alias = 489,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_pragma] = "pragma",
  [anon_sym_solidity] = "solidity",
  [sym__solidity_version] = "_solidity_version",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_CARET] = "^",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_TILDE] = "~",
  [anon_sym_EQ] = "=",
  [anon_sym_import] = "import",
  [anon_sym_as] = "as",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_abstract] = "abstract",
  [anon_sym_contract] = "contract",
  [anon_sym_interface] = "interface",
  [anon_sym_library] = "library",
  [anon_sym_is] = "is",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_event] = "event",
  [anon_sym_anonymous] = "anonymous",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_indexed] = "indexed",
  [anon_sym_using] = "using",
  [anon_sym_for] = "for",
  [anon_sym_assembly] = "assembly",
  [anon_sym_DQUOTEevmasm_DQUOTE] = "\"evmasm\"",
  [sym_yul_leave] = "yul_leave",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [sym_yul_identifier] = "yul_identifier",
  [anon_sym_DOT] = ".",
  [sym_yul_decimal_number] = "yul_decimal_number",
  [sym_yul_hex_number] = "yul_hex_number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_let] = "let",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_default] = "default",
  [anon_sym_case] = "case",
  [anon_sym_function] = "function",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_stop] = "stop",
  [anon_sym_add] = "add",
  [anon_sym_sub] = "sub",
  [anon_sym_mul] = "mul",
  [anon_sym_div] = "div",
  [anon_sym_sdiv] = "sdiv",
  [anon_sym_mod] = "mod",
  [anon_sym_smod] = "smod",
  [anon_sym_exp] = "exp",
  [anon_sym_not] = "not",
  [anon_sym_lt] = "lt",
  [anon_sym_gt] = "gt",
  [anon_sym_slt] = "slt",
  [anon_sym_sgt] = "sgt",
  [anon_sym_eq] = "eq",
  [anon_sym_iszero] = "iszero",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_byte] = "byte",
  [anon_sym_shl] = "shl",
  [anon_sym_shr] = "shr",
  [anon_sym_sar] = "sar",
  [anon_sym_addmod] = "addmod",
  [anon_sym_mulmod] = "mulmod",
  [anon_sym_signextend] = "signextend",
  [anon_sym_keccak256] = "keccak256",
  [anon_sym_pop] = "pop",
  [anon_sym_mload] = "mload",
  [anon_sym_mstore] = "mstore",
  [anon_sym_mstore8] = "mstore8",
  [anon_sym_sload] = "sload",
  [anon_sym_sstore] = "sstore",
  [anon_sym_msize] = "msize",
  [anon_sym_gas] = "gas",
  [anon_sym_address] = "address",
  [anon_sym_balance] = "balance",
  [anon_sym_selfbalance] = "selfbalance",
  [anon_sym_caller] = "caller",
  [anon_sym_callvalue] = "callvalue",
  [anon_sym_calldataload] = "calldataload",
  [anon_sym_calldatasize] = "calldatasize",
  [anon_sym_calldatacopy] = "calldatacopy",
  [anon_sym_extcodesize] = "extcodesize",
  [anon_sym_extcodecopy] = "extcodecopy",
  [anon_sym_returndatasize] = "returndatasize",
  [anon_sym_returndatacopy] = "returndatacopy",
  [anon_sym_extcodehash] = "extcodehash",
  [anon_sym_create] = "create",
  [anon_sym_create2] = "create2",
  [anon_sym_call] = "call",
  [anon_sym_callcode] = "callcode",
  [anon_sym_delegatecall] = "delegatecall",
  [anon_sym_staticcall] = "staticcall",
  [anon_sym_return] = "return",
  [anon_sym_revert] = "revert",
  [anon_sym_selfdestruct] = "selfdestruct",
  [anon_sym_invalid] = "invalid",
  [anon_sym_log0] = "log0",
  [anon_sym_log1] = "log1",
  [anon_sym_log2] = "log2",
  [anon_sym_log3] = "log3",
  [anon_sym_log4] = "log4",
  [anon_sym_chainid] = "chainid",
  [anon_sym_origin] = "origin",
  [anon_sym_gasprice] = "gasprice",
  [anon_sym_blockhash] = "blockhash",
  [anon_sym_coinbase] = "coinbase",
  [anon_sym_timestamp] = "timestamp",
  [anon_sym_number] = "number",
  [anon_sym_difficulty] = "difficulty",
  [anon_sym_gaslimit] = "gaslimit",
  [anon_sym_memory] = "memory",
  [anon_sym_storage] = "storage",
  [anon_sym_calldata] = "calldata",
  [anon_sym_var] = "var",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_returns] = "returns",
  [anon_sym_catch] = "catch",
  [anon_sym_emit] = "emit",
  [sym_constant] = "constant",
  [anon_sym_public] = "public",
  [anon_sym_internal] = "internal",
  [anon_sym_private] = "private",
  [anon_sym_external] = "external",
  [anon_sym_pure] = "pure",
  [anon_sym_view] = "view",
  [anon_sym_payable] = "payable",
  [sym_immutable] = "immutable",
  [anon_sym_override] = "override",
  [anon_sym_modifier] = "modifier",
  [anon_sym_constructor] = "constructor",
  [anon_sym_fallback] = "fallback",
  [anon_sym_receive] = "receive",
  [sym_virtual] = "virtual",
  [anon_sym_QMARK] = "?",
  [anon_sym_COLON] = ":",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_BANG] = "!",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_type] = "type",
  [anon_sym_mapping] = "mapping",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_int] = "int",
  [anon_sym_int8] = "int8",
  [anon_sym_int16] = "int16",
  [anon_sym_int24] = "int24",
  [anon_sym_int32] = "int32",
  [anon_sym_int40] = "int40",
  [anon_sym_int48] = "int48",
  [anon_sym_int56] = "int56",
  [anon_sym_int64] = "int64",
  [anon_sym_int72] = "int72",
  [anon_sym_int80] = "int80",
  [anon_sym_int88] = "int88",
  [anon_sym_int96] = "int96",
  [anon_sym_int104] = "int104",
  [anon_sym_int112] = "int112",
  [anon_sym_int120] = "int120",
  [anon_sym_int128] = "int128",
  [anon_sym_int136] = "int136",
  [anon_sym_int144] = "int144",
  [anon_sym_int152] = "int152",
  [anon_sym_int160] = "int160",
  [anon_sym_int168] = "int168",
  [anon_sym_int176] = "int176",
  [anon_sym_int184] = "int184",
  [anon_sym_int192] = "int192",
  [anon_sym_int200] = "int200",
  [anon_sym_int208] = "int208",
  [anon_sym_int216] = "int216",
  [anon_sym_int224] = "int224",
  [anon_sym_int232] = "int232",
  [anon_sym_int240] = "int240",
  [anon_sym_int248] = "int248",
  [anon_sym_int256] = "int256",
  [anon_sym_uint] = "uint",
  [anon_sym_uint8] = "uint8",
  [anon_sym_uint16] = "uint16",
  [anon_sym_uint24] = "uint24",
  [anon_sym_uint32] = "uint32",
  [anon_sym_uint40] = "uint40",
  [anon_sym_uint48] = "uint48",
  [anon_sym_uint56] = "uint56",
  [anon_sym_uint64] = "uint64",
  [anon_sym_uint72] = "uint72",
  [anon_sym_uint80] = "uint80",
  [anon_sym_uint88] = "uint88",
  [anon_sym_uint96] = "uint96",
  [anon_sym_uint104] = "uint104",
  [anon_sym_uint112] = "uint112",
  [anon_sym_uint120] = "uint120",
  [anon_sym_uint128] = "uint128",
  [anon_sym_uint136] = "uint136",
  [anon_sym_uint144] = "uint144",
  [anon_sym_uint152] = "uint152",
  [anon_sym_uint160] = "uint160",
  [anon_sym_uint168] = "uint168",
  [anon_sym_uint176] = "uint176",
  [anon_sym_uint184] = "uint184",
  [anon_sym_uint192] = "uint192",
  [anon_sym_uint200] = "uint200",
  [anon_sym_uint208] = "uint208",
  [anon_sym_uint216] = "uint216",
  [anon_sym_uint224] = "uint224",
  [anon_sym_uint232] = "uint232",
  [anon_sym_uint240] = "uint240",
  [anon_sym_uint248] = "uint248",
  [anon_sym_uint256] = "uint256",
  [anon_sym_bytes] = "bytes",
  [anon_sym_bytes1] = "bytes1",
  [anon_sym_bytes2] = "bytes2",
  [anon_sym_bytes3] = "bytes3",
  [anon_sym_bytes4] = "bytes4",
  [anon_sym_bytes5] = "bytes5",
  [anon_sym_bytes6] = "bytes6",
  [anon_sym_bytes7] = "bytes7",
  [anon_sym_bytes8] = "bytes8",
  [anon_sym_bytes9] = "bytes9",
  [anon_sym_bytes10] = "bytes10",
  [anon_sym_bytes11] = "bytes11",
  [anon_sym_bytes12] = "bytes12",
  [anon_sym_bytes13] = "bytes13",
  [anon_sym_bytes14] = "bytes14",
  [anon_sym_bytes15] = "bytes15",
  [anon_sym_bytes16] = "bytes16",
  [anon_sym_bytes17] = "bytes17",
  [anon_sym_bytes18] = "bytes18",
  [anon_sym_bytes19] = "bytes19",
  [anon_sym_bytes20] = "bytes20",
  [anon_sym_bytes21] = "bytes21",
  [anon_sym_bytes22] = "bytes22",
  [anon_sym_bytes23] = "bytes23",
  [anon_sym_bytes24] = "bytes24",
  [anon_sym_bytes25] = "bytes25",
  [anon_sym_bytes26] = "bytes26",
  [anon_sym_bytes27] = "bytes27",
  [anon_sym_bytes28] = "bytes28",
  [anon_sym_bytes29] = "bytes29",
  [anon_sym_bytes30] = "bytes30",
  [anon_sym_bytes31] = "bytes31",
  [anon_sym_bytes32] = "bytes32",
  [anon_sym_fixed] = "fixed",
  [aux_sym__fixed_token1] = "_fixed_token1",
  [anon_sym_ufixed] = "ufixed",
  [aux_sym__ufixed_token1] = "_ufixed_token1",
  [sym__semicolon] = "_semicolon",
  [sym_number] = "number",
  [aux_sym__decimal_number_token1] = "_decimal_number_token1",
  [aux_sym__decimal_number_token2] = "_decimal_number_token2",
  [aux_sym__hex_number_token1] = "_hex_number_token1",
  [anon_sym__] = "_",
  [sym__hex_digit] = "_hex_digit",
  [anon_sym_wei] = "wei",
  [anon_sym_szabo] = "szabo",
  [anon_sym_finney] = "finney",
  [anon_sym_gwei] = "gwei",
  [anon_sym_ether] = "ether",
  [anon_sym_seconds] = "seconds",
  [anon_sym_minutes] = "minutes",
  [anon_sym_hours] = "hours",
  [anon_sym_days] = "days",
  [anon_sym_weeks] = "weeks",
  [anon_sym_years] = "years",
  [anon_sym_hex] = "hex",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym__escape_sequence] = "_escape_sequence",
  [aux_sym__single_quoted_unicode_char_token1] = "_single_quoted_unicode_char_token1",
  [aux_sym__double_quoted_unicode_char_token1] = "_double_quoted_unicode_char_token1",
  [anon_sym_unicode] = "unicode",
  [aux_sym_string_token1] = "string_token1",
  [aux_sym_string_token2] = "string_token2",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__source_unit] = "_source_unit",
  [sym__directive] = "_directive",
  [sym_pragma_directive] = "pragma_directive",
  [sym__pragma_version_constraint] = "_pragma_version_constraint",
  [sym__solidity_version_comparison_operator] = "_solidity_version_comparison_operator",
  [sym_import_directive] = "import_directive",
  [sym__source_import] = "_source_import",
  [sym__import_clause] = "_import_clause",
  [sym__from_clause] = "_from_clause",
  [sym__single_import] = "_single_import",
  [sym__multiple_import] = "_multiple_import",
  [sym__import_declaration] = "_import_declaration",
  [sym__declaration] = "_declaration",
  [sym_constant_variable_declaration] = "constant_variable_declaration",
  [sym_contract_declaration] = "contract_declaration",
  [sym_interface_declaration] = "interface_declaration",
  [sym_library_declaration] = "library_declaration",
  [sym__class_heritage] = "_class_heritage",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym_contract_body] = "contract_body",
  [sym_struct_declaration] = "struct_declaration",
  [sym_struct_member] = "struct_member",
  [sym_enum_declaration] = "enum_declaration",
  [sym_event_definition] = "event_definition",
  [sym__event_parameter_list] = "_event_parameter_list",
  [sym_event_paramater] = "event_paramater",
  [sym_using_directive] = "using_directive",
  [sym_any_source_type] = "any_source_type",
  [sym__statement] = "_statement",
  [sym_assembly_statement] = "assembly_statement",
  [sym__yul_statement] = "_yul_statement",
  [sym_yul_break] = "yul_break",
  [sym_yul_continue] = "yul_continue",
  [sym__yul_expression] = "_yul_expression",
  [sym_yul_path] = "yul_path",
  [sym__yul_literal] = "_yul_literal",
  [sym_yul_string_literal] = "yul_string_literal",
  [sym_yul_boolean] = "yul_boolean",
  [sym_yul_block] = "yul_block",
  [sym_yul_variable_declaration] = "yul_variable_declaration",
  [sym_yul_assignment] = "yul_assignment",
  [sym_yul_function_call] = "yul_function_call",
  [sym_yul_if_statement] = "yul_if_statement",
  [sym_yul_for_statement] = "yul_for_statement",
  [sym_yul_switch_statement] = "yul_switch_statement",
  [sym_yul_function_definition] = "yul_function_definition",
  [sym_yul_evm_builtin] = "yul_evm_builtin",
  [sym_block_statement] = "block_statement",
  [sym_variable_declaration_statement] = "variable_declaration_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_variable_declaration_tuple] = "variable_declaration_tuple",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_while_statement] = "do_while_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_return_statement] = "return_statement",
  [sym_emit_statement] = "emit_statement",
  [sym_state_variable_declaration] = "state_variable_declaration",
  [sym_visibility] = "visibility",
  [sym_state_mutability] = "state_mutability",
  [sym_override_specifier] = "override_specifier",
  [sym_modifier_definition] = "modifier_definition",
  [sym_constructor_definition] = "constructor_definition",
  [sym_fallback_receive_definition] = "fallback_receive_definition",
  [sym_function_definition] = "function_definition",
  [sym_modifier_invocation] = "modifier_invocation",
  [sym__call_arguments] = "_call_arguments",
  [sym_function_body] = "function_body",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_type_cast_expression] = "type_cast_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_new_expression] = "new_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_inline_array_expression] = "inline_array_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_member_expression] = "member_expression",
  [sym_array_access] = "array_access",
  [sym_slice_access] = "slice_access",
  [sym_struct_expression] = "struct_expression",
  [sym__lhs_expression] = "_lhs_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym_call_expression] = "call_expression",
  [sym_payable_conversion_expression] = "payable_conversion_expression",
  [sym_meta_type_expression] = "meta_type_expression",
  [sym_type_name] = "type_name",
  [sym__array_type] = "_array_type",
  [sym__function_type] = "_function_type",
  [sym__parameter_list] = "_parameter_list",
  [sym__return_parameters] = "_return_parameters",
  [sym__nameless_parameter] = "_nameless_parameter",
  [sym__parameter] = "_parameter",
  [sym__storage_location] = "_storage_location",
  [sym__user_defined_type] = "_user_defined_type",
  [sym__mapping] = "_mapping",
  [sym__mapping_key] = "_mapping_key",
  [sym_primitive_type] = "primitive_type",
  [sym__int] = "_int",
  [sym__uint] = "_uint",
  [sym__bytes] = "_bytes",
  [sym__fixed] = "_fixed",
  [sym__ufixed] = "_ufixed",
  [sym__literal] = "_literal",
  [sym_string_literal] = "string_literal",
  [sym_number_literal] = "number_literal",
  [sym__decimal_number] = "_decimal_number",
  [sym__hex_number] = "_hex_number",
  [sym_number_unit] = "number_unit",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_boolean_literal] = "boolean_literal",
  [sym_hex_string_literal] = "hex_string_literal",
  [sym__single_quoted_unicode_char] = "_single_quoted_unicode_char",
  [sym__double_quoted_unicode_char] = "_double_quoted_unicode_char",
  [sym_unicode_string_literal] = "unicode_string_literal",
  [sym_string] = "string",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_pragma_directive_repeat1] = "pragma_directive_repeat1",
  [aux_sym__multiple_import_repeat1] = "_multiple_import_repeat1",
  [aux_sym__class_heritage_repeat1] = "_class_heritage_repeat1",
  [aux_sym_contract_body_repeat1] = "contract_body_repeat1",
  [aux_sym_struct_declaration_repeat1] = "struct_declaration_repeat1",
  [aux_sym_enum_declaration_repeat1] = "enum_declaration_repeat1",
  [aux_sym__event_parameter_list_repeat1] = "_event_parameter_list_repeat1",
  [aux_sym_assembly_statement_repeat1] = "assembly_statement_repeat1",
  [aux_sym_yul_path_repeat1] = "yul_path_repeat1",
  [aux_sym_yul_variable_declaration_repeat1] = "yul_variable_declaration_repeat1",
  [aux_sym_yul_assignment_repeat1] = "yul_assignment_repeat1",
  [aux_sym_yul_function_call_repeat1] = "yul_function_call_repeat1",
  [aux_sym_yul_switch_statement_repeat1] = "yul_switch_statement_repeat1",
  [aux_sym_block_statement_repeat1] = "block_statement_repeat1",
  [aux_sym_variable_declaration_tuple_repeat1] = "variable_declaration_tuple_repeat1",
  [aux_sym_variable_declaration_tuple_repeat2] = "variable_declaration_tuple_repeat2",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_state_variable_declaration_repeat1] = "state_variable_declaration_repeat1",
  [aux_sym_override_specifier_repeat1] = "override_specifier_repeat1",
  [aux_sym_modifier_definition_repeat1] = "modifier_definition_repeat1",
  [aux_sym_constructor_definition_repeat1] = "constructor_definition_repeat1",
  [aux_sym_fallback_receive_definition_repeat1] = "fallback_receive_definition_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym__call_arguments_repeat1] = "_call_arguments_repeat1",
  [aux_sym__call_arguments_repeat2] = "_call_arguments_repeat2",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_inline_array_expression_repeat1] = "inline_array_expression_repeat1",
  [aux_sym_struct_expression_repeat1] = "struct_expression_repeat1",
  [aux_sym__parameter_list_repeat1] = "_parameter_list_repeat1",
  [aux_sym__return_parameters_repeat1] = "_return_parameters_repeat1",
  [aux_sym__user_defined_type_repeat1] = "_user_defined_type_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym__hex_number_repeat1] = "_hex_number_repeat1",
  [aux_sym_hex_string_literal_repeat1] = "hex_string_literal_repeat1",
  [aux_sym_unicode_string_literal_repeat1] = "unicode_string_literal_repeat1",
  [aux_sym_unicode_string_literal_repeat2] = "unicode_string_literal_repeat2",
  [aux_sym_unicode_string_literal_repeat3] = "unicode_string_literal_repeat3",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_enum_value] = "enum_value",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_type_alias] = "type_alias",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_pragma] = anon_sym_pragma,
  [anon_sym_solidity] = anon_sym_solidity,
  [sym__solidity_version] = sym__solidity_version,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_library] = anon_sym_library,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_anonymous] = anon_sym_anonymous,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_indexed] = anon_sym_indexed,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_assembly] = anon_sym_assembly,
  [anon_sym_DQUOTEevmasm_DQUOTE] = anon_sym_DQUOTEevmasm_DQUOTE,
  [sym_yul_leave] = sym_yul_leave,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [sym_yul_identifier] = sym_yul_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_yul_decimal_number] = sym_yul_decimal_number,
  [sym_yul_hex_number] = sym_yul_hex_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_stop] = anon_sym_stop,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_sub] = anon_sym_sub,
  [anon_sym_mul] = anon_sym_mul,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_sdiv] = anon_sym_sdiv,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_smod] = anon_sym_smod,
  [anon_sym_exp] = anon_sym_exp,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_lt] = anon_sym_lt,
  [anon_sym_gt] = anon_sym_gt,
  [anon_sym_slt] = anon_sym_slt,
  [anon_sym_sgt] = anon_sym_sgt,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_iszero] = anon_sym_iszero,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_shl] = anon_sym_shl,
  [anon_sym_shr] = anon_sym_shr,
  [anon_sym_sar] = anon_sym_sar,
  [anon_sym_addmod] = anon_sym_addmod,
  [anon_sym_mulmod] = anon_sym_mulmod,
  [anon_sym_signextend] = anon_sym_signextend,
  [anon_sym_keccak256] = anon_sym_keccak256,
  [anon_sym_pop] = anon_sym_pop,
  [anon_sym_mload] = anon_sym_mload,
  [anon_sym_mstore] = anon_sym_mstore,
  [anon_sym_mstore8] = anon_sym_mstore8,
  [anon_sym_sload] = anon_sym_sload,
  [anon_sym_sstore] = anon_sym_sstore,
  [anon_sym_msize] = anon_sym_msize,
  [anon_sym_gas] = anon_sym_gas,
  [anon_sym_address] = anon_sym_address,
  [anon_sym_balance] = anon_sym_balance,
  [anon_sym_selfbalance] = anon_sym_selfbalance,
  [anon_sym_caller] = anon_sym_caller,
  [anon_sym_callvalue] = anon_sym_callvalue,
  [anon_sym_calldataload] = anon_sym_calldataload,
  [anon_sym_calldatasize] = anon_sym_calldatasize,
  [anon_sym_calldatacopy] = anon_sym_calldatacopy,
  [anon_sym_extcodesize] = anon_sym_extcodesize,
  [anon_sym_extcodecopy] = anon_sym_extcodecopy,
  [anon_sym_returndatasize] = anon_sym_returndatasize,
  [anon_sym_returndatacopy] = anon_sym_returndatacopy,
  [anon_sym_extcodehash] = anon_sym_extcodehash,
  [anon_sym_create] = anon_sym_create,
  [anon_sym_create2] = anon_sym_create2,
  [anon_sym_call] = anon_sym_call,
  [anon_sym_callcode] = anon_sym_callcode,
  [anon_sym_delegatecall] = anon_sym_delegatecall,
  [anon_sym_staticcall] = anon_sym_staticcall,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_revert] = anon_sym_revert,
  [anon_sym_selfdestruct] = anon_sym_selfdestruct,
  [anon_sym_invalid] = anon_sym_invalid,
  [anon_sym_log0] = anon_sym_log0,
  [anon_sym_log1] = anon_sym_log1,
  [anon_sym_log2] = anon_sym_log2,
  [anon_sym_log3] = anon_sym_log3,
  [anon_sym_log4] = anon_sym_log4,
  [anon_sym_chainid] = anon_sym_chainid,
  [anon_sym_origin] = anon_sym_origin,
  [anon_sym_gasprice] = anon_sym_gasprice,
  [anon_sym_blockhash] = anon_sym_blockhash,
  [anon_sym_coinbase] = anon_sym_coinbase,
  [anon_sym_timestamp] = anon_sym_timestamp,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_difficulty] = anon_sym_difficulty,
  [anon_sym_gaslimit] = anon_sym_gaslimit,
  [anon_sym_memory] = anon_sym_memory,
  [anon_sym_storage] = anon_sym_storage,
  [anon_sym_calldata] = anon_sym_calldata,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_returns] = anon_sym_returns,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_emit] = anon_sym_emit,
  [sym_constant] = sym_constant,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_view] = anon_sym_view,
  [anon_sym_payable] = anon_sym_payable,
  [sym_immutable] = sym_immutable,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_modifier] = anon_sym_modifier,
  [anon_sym_constructor] = anon_sym_constructor,
  [anon_sym_fallback] = anon_sym_fallback,
  [anon_sym_receive] = anon_sym_receive,
  [sym_virtual] = sym_virtual,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_mapping] = anon_sym_mapping,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_int8] = anon_sym_int8,
  [anon_sym_int16] = anon_sym_int16,
  [anon_sym_int24] = anon_sym_int24,
  [anon_sym_int32] = anon_sym_int32,
  [anon_sym_int40] = anon_sym_int40,
  [anon_sym_int48] = anon_sym_int48,
  [anon_sym_int56] = anon_sym_int56,
  [anon_sym_int64] = anon_sym_int64,
  [anon_sym_int72] = anon_sym_int72,
  [anon_sym_int80] = anon_sym_int80,
  [anon_sym_int88] = anon_sym_int88,
  [anon_sym_int96] = anon_sym_int96,
  [anon_sym_int104] = anon_sym_int104,
  [anon_sym_int112] = anon_sym_int112,
  [anon_sym_int120] = anon_sym_int120,
  [anon_sym_int128] = anon_sym_int128,
  [anon_sym_int136] = anon_sym_int136,
  [anon_sym_int144] = anon_sym_int144,
  [anon_sym_int152] = anon_sym_int152,
  [anon_sym_int160] = anon_sym_int160,
  [anon_sym_int168] = anon_sym_int168,
  [anon_sym_int176] = anon_sym_int176,
  [anon_sym_int184] = anon_sym_int184,
  [anon_sym_int192] = anon_sym_int192,
  [anon_sym_int200] = anon_sym_int200,
  [anon_sym_int208] = anon_sym_int208,
  [anon_sym_int216] = anon_sym_int216,
  [anon_sym_int224] = anon_sym_int224,
  [anon_sym_int232] = anon_sym_int232,
  [anon_sym_int240] = anon_sym_int240,
  [anon_sym_int248] = anon_sym_int248,
  [anon_sym_int256] = anon_sym_int256,
  [anon_sym_uint] = anon_sym_uint,
  [anon_sym_uint8] = anon_sym_uint8,
  [anon_sym_uint16] = anon_sym_uint16,
  [anon_sym_uint24] = anon_sym_uint24,
  [anon_sym_uint32] = anon_sym_uint32,
  [anon_sym_uint40] = anon_sym_uint40,
  [anon_sym_uint48] = anon_sym_uint48,
  [anon_sym_uint56] = anon_sym_uint56,
  [anon_sym_uint64] = anon_sym_uint64,
  [anon_sym_uint72] = anon_sym_uint72,
  [anon_sym_uint80] = anon_sym_uint80,
  [anon_sym_uint88] = anon_sym_uint88,
  [anon_sym_uint96] = anon_sym_uint96,
  [anon_sym_uint104] = anon_sym_uint104,
  [anon_sym_uint112] = anon_sym_uint112,
  [anon_sym_uint120] = anon_sym_uint120,
  [anon_sym_uint128] = anon_sym_uint128,
  [anon_sym_uint136] = anon_sym_uint136,
  [anon_sym_uint144] = anon_sym_uint144,
  [anon_sym_uint152] = anon_sym_uint152,
  [anon_sym_uint160] = anon_sym_uint160,
  [anon_sym_uint168] = anon_sym_uint168,
  [anon_sym_uint176] = anon_sym_uint176,
  [anon_sym_uint184] = anon_sym_uint184,
  [anon_sym_uint192] = anon_sym_uint192,
  [anon_sym_uint200] = anon_sym_uint200,
  [anon_sym_uint208] = anon_sym_uint208,
  [anon_sym_uint216] = anon_sym_uint216,
  [anon_sym_uint224] = anon_sym_uint224,
  [anon_sym_uint232] = anon_sym_uint232,
  [anon_sym_uint240] = anon_sym_uint240,
  [anon_sym_uint248] = anon_sym_uint248,
  [anon_sym_uint256] = anon_sym_uint256,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_bytes1] = anon_sym_bytes1,
  [anon_sym_bytes2] = anon_sym_bytes2,
  [anon_sym_bytes3] = anon_sym_bytes3,
  [anon_sym_bytes4] = anon_sym_bytes4,
  [anon_sym_bytes5] = anon_sym_bytes5,
  [anon_sym_bytes6] = anon_sym_bytes6,
  [anon_sym_bytes7] = anon_sym_bytes7,
  [anon_sym_bytes8] = anon_sym_bytes8,
  [anon_sym_bytes9] = anon_sym_bytes9,
  [anon_sym_bytes10] = anon_sym_bytes10,
  [anon_sym_bytes11] = anon_sym_bytes11,
  [anon_sym_bytes12] = anon_sym_bytes12,
  [anon_sym_bytes13] = anon_sym_bytes13,
  [anon_sym_bytes14] = anon_sym_bytes14,
  [anon_sym_bytes15] = anon_sym_bytes15,
  [anon_sym_bytes16] = anon_sym_bytes16,
  [anon_sym_bytes17] = anon_sym_bytes17,
  [anon_sym_bytes18] = anon_sym_bytes18,
  [anon_sym_bytes19] = anon_sym_bytes19,
  [anon_sym_bytes20] = anon_sym_bytes20,
  [anon_sym_bytes21] = anon_sym_bytes21,
  [anon_sym_bytes22] = anon_sym_bytes22,
  [anon_sym_bytes23] = anon_sym_bytes23,
  [anon_sym_bytes24] = anon_sym_bytes24,
  [anon_sym_bytes25] = anon_sym_bytes25,
  [anon_sym_bytes26] = anon_sym_bytes26,
  [anon_sym_bytes27] = anon_sym_bytes27,
  [anon_sym_bytes28] = anon_sym_bytes28,
  [anon_sym_bytes29] = anon_sym_bytes29,
  [anon_sym_bytes30] = anon_sym_bytes30,
  [anon_sym_bytes31] = anon_sym_bytes31,
  [anon_sym_bytes32] = anon_sym_bytes32,
  [anon_sym_fixed] = anon_sym_fixed,
  [aux_sym__fixed_token1] = aux_sym__fixed_token1,
  [anon_sym_ufixed] = anon_sym_ufixed,
  [aux_sym__ufixed_token1] = aux_sym__ufixed_token1,
  [sym__semicolon] = sym__semicolon,
  [sym_number] = sym_number,
  [aux_sym__decimal_number_token1] = aux_sym__decimal_number_token1,
  [aux_sym__decimal_number_token2] = aux_sym__decimal_number_token2,
  [aux_sym__hex_number_token1] = aux_sym__hex_number_token1,
  [anon_sym__] = anon_sym__,
  [sym__hex_digit] = sym__hex_digit,
  [anon_sym_wei] = anon_sym_wei,
  [anon_sym_szabo] = anon_sym_szabo,
  [anon_sym_finney] = anon_sym_finney,
  [anon_sym_gwei] = anon_sym_gwei,
  [anon_sym_ether] = anon_sym_ether,
  [anon_sym_seconds] = anon_sym_seconds,
  [anon_sym_minutes] = anon_sym_minutes,
  [anon_sym_hours] = anon_sym_hours,
  [anon_sym_days] = anon_sym_days,
  [anon_sym_weeks] = anon_sym_weeks,
  [anon_sym_years] = anon_sym_years,
  [anon_sym_hex] = anon_sym_hex,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym__escape_sequence] = sym__escape_sequence,
  [aux_sym__single_quoted_unicode_char_token1] = aux_sym__single_quoted_unicode_char_token1,
  [aux_sym__double_quoted_unicode_char_token1] = aux_sym__double_quoted_unicode_char_token1,
  [anon_sym_unicode] = anon_sym_unicode,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__source_unit] = sym__source_unit,
  [sym__directive] = sym__directive,
  [sym_pragma_directive] = sym_pragma_directive,
  [sym__pragma_version_constraint] = sym__pragma_version_constraint,
  [sym__solidity_version_comparison_operator] = sym__solidity_version_comparison_operator,
  [sym_import_directive] = sym_import_directive,
  [sym__source_import] = sym__source_import,
  [sym__import_clause] = sym__import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym__single_import] = sym__single_import,
  [sym__multiple_import] = sym__multiple_import,
  [sym__import_declaration] = sym__import_declaration,
  [sym__declaration] = sym__declaration,
  [sym_constant_variable_declaration] = sym_constant_variable_declaration,
  [sym_contract_declaration] = sym_contract_declaration,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_library_declaration] = sym_library_declaration,
  [sym__class_heritage] = sym__class_heritage,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym_contract_body] = sym_contract_body,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym_struct_member] = sym_struct_member,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_event_definition] = sym_event_definition,
  [sym__event_parameter_list] = sym__event_parameter_list,
  [sym_event_paramater] = sym_event_paramater,
  [sym_using_directive] = sym_using_directive,
  [sym_any_source_type] = sym_any_source_type,
  [sym__statement] = sym__statement,
  [sym_assembly_statement] = sym_assembly_statement,
  [sym__yul_statement] = sym__yul_statement,
  [sym_yul_break] = sym_yul_break,
  [sym_yul_continue] = sym_yul_continue,
  [sym__yul_expression] = sym__yul_expression,
  [sym_yul_path] = sym_yul_path,
  [sym__yul_literal] = sym__yul_literal,
  [sym_yul_string_literal] = sym_yul_string_literal,
  [sym_yul_boolean] = sym_yul_boolean,
  [sym_yul_block] = sym_yul_block,
  [sym_yul_variable_declaration] = sym_yul_variable_declaration,
  [sym_yul_assignment] = sym_yul_assignment,
  [sym_yul_function_call] = sym_yul_function_call,
  [sym_yul_if_statement] = sym_yul_if_statement,
  [sym_yul_for_statement] = sym_yul_for_statement,
  [sym_yul_switch_statement] = sym_yul_switch_statement,
  [sym_yul_function_definition] = sym_yul_function_definition,
  [sym_yul_evm_builtin] = sym_yul_evm_builtin,
  [sym_block_statement] = sym_block_statement,
  [sym_variable_declaration_statement] = sym_variable_declaration_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_variable_declaration_tuple] = sym_variable_declaration_tuple,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_while_statement] = sym_do_while_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_return_statement] = sym_return_statement,
  [sym_emit_statement] = sym_emit_statement,
  [sym_state_variable_declaration] = sym_state_variable_declaration,
  [sym_visibility] = sym_visibility,
  [sym_state_mutability] = sym_state_mutability,
  [sym_override_specifier] = sym_override_specifier,
  [sym_modifier_definition] = sym_modifier_definition,
  [sym_constructor_definition] = sym_constructor_definition,
  [sym_fallback_receive_definition] = sym_fallback_receive_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_modifier_invocation] = sym_modifier_invocation,
  [sym__call_arguments] = sym__call_arguments,
  [sym_function_body] = sym_function_body,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_type_cast_expression] = sym_type_cast_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_inline_array_expression] = sym_inline_array_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_array_access] = sym_array_access,
  [sym_slice_access] = sym_slice_access,
  [sym_struct_expression] = sym_struct_expression,
  [sym__lhs_expression] = sym__lhs_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_payable_conversion_expression] = sym_payable_conversion_expression,
  [sym_meta_type_expression] = sym_meta_type_expression,
  [sym_type_name] = sym_type_name,
  [sym__array_type] = sym__array_type,
  [sym__function_type] = sym__function_type,
  [sym__parameter_list] = sym__parameter_list,
  [sym__return_parameters] = sym__return_parameters,
  [sym__nameless_parameter] = sym__nameless_parameter,
  [sym__parameter] = sym__parameter,
  [sym__storage_location] = sym__storage_location,
  [sym__user_defined_type] = sym__user_defined_type,
  [sym__mapping] = sym__mapping,
  [sym__mapping_key] = sym__mapping_key,
  [sym_primitive_type] = sym_primitive_type,
  [sym__int] = sym__int,
  [sym__uint] = sym__uint,
  [sym__bytes] = sym__bytes,
  [sym__fixed] = sym__fixed,
  [sym__ufixed] = sym__ufixed,
  [sym__literal] = sym__literal,
  [sym_string_literal] = sym_string_literal,
  [sym_number_literal] = sym_number_literal,
  [sym__decimal_number] = sym__decimal_number,
  [sym__hex_number] = sym__hex_number,
  [sym_number_unit] = sym_number_unit,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_hex_string_literal] = sym_hex_string_literal,
  [sym__single_quoted_unicode_char] = sym__single_quoted_unicode_char,
  [sym__double_quoted_unicode_char] = sym__double_quoted_unicode_char,
  [sym_unicode_string_literal] = sym_unicode_string_literal,
  [sym_string] = sym_string,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_pragma_directive_repeat1] = aux_sym_pragma_directive_repeat1,
  [aux_sym__multiple_import_repeat1] = aux_sym__multiple_import_repeat1,
  [aux_sym__class_heritage_repeat1] = aux_sym__class_heritage_repeat1,
  [aux_sym_contract_body_repeat1] = aux_sym_contract_body_repeat1,
  [aux_sym_struct_declaration_repeat1] = aux_sym_struct_declaration_repeat1,
  [aux_sym_enum_declaration_repeat1] = aux_sym_enum_declaration_repeat1,
  [aux_sym__event_parameter_list_repeat1] = aux_sym__event_parameter_list_repeat1,
  [aux_sym_assembly_statement_repeat1] = aux_sym_assembly_statement_repeat1,
  [aux_sym_yul_path_repeat1] = aux_sym_yul_path_repeat1,
  [aux_sym_yul_variable_declaration_repeat1] = aux_sym_yul_variable_declaration_repeat1,
  [aux_sym_yul_assignment_repeat1] = aux_sym_yul_assignment_repeat1,
  [aux_sym_yul_function_call_repeat1] = aux_sym_yul_function_call_repeat1,
  [aux_sym_yul_switch_statement_repeat1] = aux_sym_yul_switch_statement_repeat1,
  [aux_sym_block_statement_repeat1] = aux_sym_block_statement_repeat1,
  [aux_sym_variable_declaration_tuple_repeat1] = aux_sym_variable_declaration_tuple_repeat1,
  [aux_sym_variable_declaration_tuple_repeat2] = aux_sym_variable_declaration_tuple_repeat2,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_state_variable_declaration_repeat1] = aux_sym_state_variable_declaration_repeat1,
  [aux_sym_override_specifier_repeat1] = aux_sym_override_specifier_repeat1,
  [aux_sym_modifier_definition_repeat1] = aux_sym_modifier_definition_repeat1,
  [aux_sym_constructor_definition_repeat1] = aux_sym_constructor_definition_repeat1,
  [aux_sym_fallback_receive_definition_repeat1] = aux_sym_fallback_receive_definition_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym__call_arguments_repeat1] = aux_sym__call_arguments_repeat1,
  [aux_sym__call_arguments_repeat2] = aux_sym__call_arguments_repeat2,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_inline_array_expression_repeat1] = aux_sym_inline_array_expression_repeat1,
  [aux_sym_struct_expression_repeat1] = aux_sym_struct_expression_repeat1,
  [aux_sym__parameter_list_repeat1] = aux_sym__parameter_list_repeat1,
  [aux_sym__return_parameters_repeat1] = aux_sym__return_parameters_repeat1,
  [aux_sym__user_defined_type_repeat1] = aux_sym__user_defined_type_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym__hex_number_repeat1] = aux_sym__hex_number_repeat1,
  [aux_sym_hex_string_literal_repeat1] = aux_sym_hex_string_literal_repeat1,
  [aux_sym_unicode_string_literal_repeat1] = aux_sym_unicode_string_literal_repeat1,
  [aux_sym_unicode_string_literal_repeat2] = aux_sym_unicode_string_literal_repeat2,
  [aux_sym_unicode_string_literal_repeat3] = aux_sym_unicode_string_literal_repeat3,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_enum_value] = alias_sym_enum_value,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_type_alias] = alias_sym_type_alias,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_solidity] = {
    .visible = true,
    .named = false,
  },
  [sym__solidity_version] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_library] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_anonymous] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indexed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assembly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTEevmasm_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_leave] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_decimal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_hex_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_slt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iszero] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mulmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signextend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keccak256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_msize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_address] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_balance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfbalance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_caller] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldataload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodesize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodecopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodehash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callcode] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegatecall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_staticcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_revert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfdestruct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invalid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chainid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_origin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gasprice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blockhash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_coinbase] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_timestamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_difficulty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gaslimit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_memory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_storage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returns] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_emit] = {
    .visible = true,
    .named = false,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_view] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_payable] = {
    .visible = true,
    .named = false,
  },
  [sym_immutable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_modifier] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [sym_virtual] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mapping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes11] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__fixed_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ufixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ufixed_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__decimal_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_number_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym__hex_digit] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_wei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_szabo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finney] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gwei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ether] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seconds] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minutes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hours] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_days] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weeks] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_years] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_unicode] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__source_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__pragma_version_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym__solidity_version_comparison_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_import_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__source_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__single_import] = {
    .visible = false,
    .named = true,
  },
  [sym__multiple_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_library_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__class_heritage] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_body] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_event_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__event_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym_event_paramater] = {
    .visible = true,
    .named = true,
  },
  [sym_using_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_any_source_type] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_assembly_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_break] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_continue] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_path] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_block] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_evm_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_emit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_state_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_state_mutability] = {
    .visible = true,
    .named = true,
  },
  [sym_override_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_fallback_receive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_access] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__lhs_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_payable_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym__array_type] = {
    .visible = false,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__return_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__nameless_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__storage_location] = {
    .visible = false,
    .named = true,
  },
  [sym__user_defined_type] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping_key] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym__int] = {
    .visible = false,
    .named = true,
  },
  [sym__uint] = {
    .visible = false,
    .named = true,
  },
  [sym__bytes] = {
    .visible = false,
    .named = true,
  },
  [sym__fixed] = {
    .visible = false,
    .named = true,
  },
  [sym__ufixed] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__decimal_number] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_number] = {
    .visible = false,
    .named = true,
  },
  [sym_number_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym_unicode_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pragma_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiple_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_heritage_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__event_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assembly_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_assignment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_function_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_override_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifier_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructor_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fallback_receive_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__call_arguments_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__return_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__user_defined_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_number_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_enum_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_alias] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_ancestor = 1,
  field_ancestor_arguments = 2,
  field_argument = 3,
  field_base = 4,
  field_body = 5,
  field_enum_type_name = 6,
  field_from = 7,
  field_function = 8,
  field_function_name = 9,
  field_import_alias = 10,
  field_import_origin = 11,
  field_index = 12,
  field_left = 13,
  field_name = 14,
  field_object = 15,
  field_operator = 16,
  field_property = 17,
  field_right = 18,
  field_source = 19,
  field_storage_location = 20,
  field_struct_name = 21,
  field_to = 22,
  field_type = 23,
  field_value = 24,
  field_version_constraint = 25,
  field_visibility = 26,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_ancestor] = "ancestor",
  [field_ancestor_arguments] = "ancestor_arguments",
  [field_argument] = "argument",
  [field_base] = "base",
  [field_body] = "body",
  [field_enum_type_name] = "enum_type_name",
  [field_from] = "from",
  [field_function] = "function",
  [field_function_name] = "function_name",
  [field_import_alias] = "import_alias",
  [field_import_origin] = "import_origin",
  [field_index] = "index",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_storage_location] = "storage_location",
  [field_struct_name] = "struct_name",
  [field_to] = "to",
  [field_type] = "type",
  [field_value] = "value",
  [field_version_constraint] = "version_constraint",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[77] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 3},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 1},
  [9] = {.index = 11, .length = 1},
  [10] = {.index = 12, .length = 2},
  [11] = {.index = 14, .length = 1},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 1},
  [14] = {.index = 18, .length = 3},
  [15] = {.index = 21, .length = 2},
  [16] = {.index = 23, .length = 1},
  [17] = {.index = 24, .length = 2},
  [18] = {.index = 26, .length = 1},
  [19] = {.index = 27, .length = 2},
  [20] = {.index = 29, .length = 2},
  [21] = {.index = 31, .length = 4},
  [22] = {.index = 35, .length = 5},
  [23] = {.index = 40, .length = 2},
  [24] = {.index = 42, .length = 2},
  [25] = {.index = 44, .length = 2},
  [26] = {.index = 46, .length = 4},
  [27] = {.index = 50, .length = 2},
  [28] = {.index = 52, .length = 1},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 1},
  [31] = {.index = 26, .length = 1},
  [32] = {.index = 56, .length = 3},
  [33] = {.index = 59, .length = 6},
  [34] = {.index = 65, .length = 5},
  [35] = {.index = 70, .length = 2},
  [36] = {.index = 72, .length = 3},
  [37] = {.index = 75, .length = 2},
  [38] = {.index = 77, .length = 4},
  [39] = {.index = 81, .length = 1},
  [40] = {.index = 82, .length = 4},
  [41] = {.index = 86, .length = 2},
  [43] = {.index = 88, .length = 6},
  [44] = {.index = 94, .length = 7},
  [45] = {.index = 101, .length = 8},
  [46] = {.index = 109, .length = 3},
  [47] = {.index = 112, .length = 2},
  [48] = {.index = 114, .length = 1},
  [49] = {.index = 115, .length = 4},
  [50] = {.index = 119, .length = 5},
  [51] = {.index = 124, .length = 4},
  [52] = {.index = 128, .length = 3},
  [53] = {.index = 131, .length = 1},
  [54] = {.index = 132, .length = 7},
  [55] = {.index = 139, .length = 8},
  [56] = {.index = 147, .length = 1},
  [57] = {.index = 148, .length = 1},
  [58] = {.index = 149, .length = 5},
  [59] = {.index = 154, .length = 3},
  [60] = {.index = 157, .length = 1},
  [61] = {.index = 158, .length = 3},
  [62] = {.index = 161, .length = 2},
  [63] = {.index = 163, .length = 1},
  [64] = {.index = 164, .length = 4},
  [65] = {.index = 168, .length = 1},
  [66] = {.index = 169, .length = 2},
  [67] = {.index = 171, .length = 3},
  [68] = {.index = 174, .length = 2},
  [69] = {.index = 176, .length = 3},
  [70] = {.index = 179, .length = 4},
  [71] = {.index = 183, .length = 3},
  [72] = {.index = 186, .length = 3},
  [73] = {.index = 189, .length = 4},
  [74] = {.index = 193, .length = 5},
  [75] = {.index = 198, .length = 5},
  [76] = {.index = 203, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_import_alias, 0, .inherited = true},
  [1] =
    {field_source, 0},
  [2] =
    {field_name, 1, .inherited = true},
    {field_storage_location, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [5] =
    {field_version_constraint, 0},
  [6] =
    {field_import_origin, 0},
  [7] =
    {field_source, 1, .inherited = true},
  [8] =
    {field_body, 2},
    {field_name, 1},
  [10] =
    {field_type, 0},
  [11] =
    {field_version_constraint, 2, .inherited = true},
  [12] =
    {field_version_constraint, 0, .inherited = true},
    {field_version_constraint, 1, .inherited = true},
  [14] =
    {field_import_alias, 2},
  [15] =
    {field_import_alias, 1, .inherited = true},
    {field_import_origin, 1, .inherited = true},
  [17] =
    {field_source, 1},
  [18] =
    {field_import_alias, 1, .inherited = true},
    {field_import_origin, 1, .inherited = true},
    {field_source, 2, .inherited = true},
  [21] =
    {field_body, 3},
    {field_name, 2},
  [23] =
    {field_ancestor, 0},
  [24] =
    {field_body, 3},
    {field_name, 1},
  [26] =
    {field_enum_type_name, 1},
  [27] =
    {field_name, 1},
    {field_type, 0},
  [29] =
    {field_storage_location, 1},
    {field_type, 0},
  [31] =
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [35] =
    {field_body, 3},
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [40] =
    {field_argument, 1},
    {field_operator, 0},
  [42] =
    {field_argument, 0},
    {field_operator, 1},
  [44] =
    {field_import_alias, 2},
    {field_import_origin, 0},
  [46] =
    {field_import_alias, 0, .inherited = true},
    {field_import_alias, 1, .inherited = true},
    {field_import_origin, 0, .inherited = true},
    {field_import_origin, 1, .inherited = true},
  [50] =
    {field_body, 4},
    {field_name, 2},
  [52] =
    {field_visibility, 0},
  [53] =
    {field_ancestor, 0},
    {field_ancestor_arguments, 1},
  [55] =
    {field_struct_name, 1},
  [56] =
    {field_name, 2},
    {field_storage_location, 1},
    {field_type, 0},
  [59] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_storage_location, 0, .inherited = true},
    {field_storage_location, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [65] =
    {field_body, 4},
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [70] =
    {field_object, 0},
    {field_property, 2},
  [72] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [75] =
    {field_left, 0},
    {field_right, 2},
  [77] =
    {field_import_alias, 1, .inherited = true},
    {field_import_alias, 2, .inherited = true},
    {field_import_origin, 1, .inherited = true},
    {field_import_origin, 2, .inherited = true},
  [81] =
    {field_name, 1},
  [82] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_storage_location, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [86] =
    {field_visibility, 0, .inherited = true},
    {field_visibility, 1, .inherited = true},
  [88] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_storage_location, 1, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 2, .inherited = true},
  [94] =
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_storage_location, 4, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type, 4, .inherited = true},
  [101] =
    {field_body, 5},
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_name, 4, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_storage_location, 4, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type, 4, .inherited = true},
  [109] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
  [112] =
    {field_base, 0},
    {field_index, 2},
  [114] =
    {field_body, 3},
  [115] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [119] =
    {field_body, 3},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [124] =
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_storage_location, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [128] =
    {field_name, 2},
    {field_type, 0},
    {field_visibility, 1, .inherited = true},
  [131] =
    {field_name, 2},
  [132] =
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_storage_location, 5, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type, 5, .inherited = true},
  [139] =
    {field_body, 6},
    {field_function_name, 1},
    {field_name, 2, .inherited = true},
    {field_name, 5, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_storage_location, 5, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_type, 5, .inherited = true},
  [147] =
    {field_source, 3},
  [148] =
    {field_body, 4},
  [149] =
    {field_body, 4},
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [154] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 3},
  [157] =
    {field_left, 1},
  [158] =
    {field_base, 0},
    {field_from, 2},
    {field_to, 4},
  [161] =
    {field_name, 2},
    {field_type, 0},
  [163] =
    {field_body, 5},
  [164] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
    {field_visibility, 1, .inherited = true},
  [168] =
    {field_function, 0},
  [169] =
    {field_left, 1},
    {field_left, 2},
  [171] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
  [174] =
    {field_left, 1},
    {field_right, 3},
  [176] =
    {field_name, 3, .inherited = true},
    {field_storage_location, 3, .inherited = true},
    {field_type, 3, .inherited = true},
  [179] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
  [183] =
    {field_left, 1},
    {field_left, 2},
    {field_right, 4},
  [186] =
    {field_name, 2, .inherited = true},
    {field_storage_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [189] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_right, 5},
  [193] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
  [198] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [203] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
    {field_right, 7},
};

static TSSymbol ts_alias_sequences[77][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [31] = {
    [3] = alias_sym_enum_value,
  },
  [35] = {
    [2] = alias_sym_property_identifier,
  },
  [42] = {
    [1] = alias_sym_enum_value,
  },
  [56] = {
    [1] = alias_sym_type_alias,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(125);
      if (lookahead == '!') ADVANCE(611);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '%') ADVANCE(605);
      if (lookahead == '&') ADVANCE(594);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(598);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(601);
      if (lookahead == '.') ADVANCE(426);
      if (lookahead == '/') ADVANCE(603);
      if (lookahead == '0') ADVANCE(428);
      if (lookahead == ':') ADVANCE(582);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(139);
      if (lookahead == '>') ADVANCE(134);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '_') ADVANCE(937);
      if (lookahead == 'a') ADVANCE(681);
      if (lookahead == 'b') ADVANCE(627);
      if (lookahead == 'c') ADVANCE(628);
      if (lookahead == 'd') ADVANCE(629);
      if (lookahead == 'e') ADVANCE(841);
      if (lookahead == 'f') ADVANCE(632);
      if (lookahead == 'g') ADVANCE(630);
      if (lookahead == 'h') ADVANCE(815);
      if (lookahead == 'i') ADVANCE(740);
      if (lookahead == 'l') ADVANCE(698);
      if (lookahead == 'm') ADVANCE(758);
      if (lookahead == 'n') ADVANCE(819);
      if (lookahead == 'o') ADVANCE(842);
      if (lookahead == 'p') ADVANCE(816);
      if (lookahead == 'r') ADVANCE(699);
      if (lookahead == 's') ADVANCE(637);
      if (lookahead == 't') ADVANCE(757);
      if (lookahead == 'w') ADVANCE(700);
      if (lookahead == 'x') ADVANCE(820);
      if (lookahead == 'y') ADVANCE(723);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(595);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(123)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(429);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '/') ADVANCE(982);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(985);
      if (lookahead != 0) ADVANCE(986);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(981);
      if (lookahead == '\r') ADVANCE(965);
      if (lookahead == 'u') ADVANCE(110);
      if (lookahead == 'x') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(968);
      if (lookahead != 0) ADVANCE(964);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(16)
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '/') ADVANCE(976);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(979);
      if (lookahead != 0) ADVANCE(980);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(975);
      if (lookahead == '\r') ADVANCE(966);
      if (lookahead == 'u') ADVANCE(110);
      if (lookahead == 'x') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(968);
      if (lookahead != 0) ADVANCE(964);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '%') ADVANCE(605);
      if (lookahead == '&') ADVANCE(594);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(598);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(600);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(603);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(134);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == 'r') ADVANCE(739);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(595);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(5)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '%') ADVANCE(604);
      if (lookahead == '&') ADVANCE(593);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(602);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(131);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(135);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == 'c') ADVANCE(658);
      if (lookahead == 'd') ADVANCE(726);
      if (lookahead == 'r') ADVANCE(739);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(596);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '%') ADVANCE(605);
      if (lookahead == '&') ADVANCE(594);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(598);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(600);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(603);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(134);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(595);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '%') ADVANCE(604);
      if (lookahead == '&') ADVANCE(593);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(602);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(131);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(135);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(596);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '%') ADVANCE(604);
      if (lookahead == '&') ADVANCE(593);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(140);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(602);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(131);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '>') ADVANCE(135);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(132);
      if (lookahead == '_') ADVANCE(936);
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'e') ADVANCE(97);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'g') ADVANCE(108);
      if (lookahead == 'h') ADVANCE(78);
      if (lookahead == 'm') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(50);
      if (lookahead == 's') ADVANCE(51);
      if (lookahead == 'w') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(60);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(596);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'c')) ADVANCE(121);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(610);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(929);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == 'a') ADVANCE(694);
      if (lookahead == 'b') ADVANCE(918);
      if (lookahead == 'f') ADVANCE(635);
      if (lookahead == 't') ADVANCE(849);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(930);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(610);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(929);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == 'a') ADVANCE(694);
      if (lookahead == 'b') ADVANCE(918);
      if (lookahead == 'f') ADVANCE(634);
      if (lookahead == 't') ADVANCE(849);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(930);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(610);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == '+') ADVANCE(597);
      if (lookahead == '-') ADVANCE(599);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(929);
      if (lookahead == '=') ADVANCE(38);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == 'a') ADVANCE(694);
      if (lookahead == 'b') ADVANCE(860);
      if (lookahead == 'c') ADVANCE(832);
      if (lookahead == 'f') ADVANCE(633);
      if (lookahead == 'i') ADVANCE(741);
      if (lookahead == 'r') ADVANCE(735);
      if (lookahead == 't') ADVANCE(849);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(930);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(427);
      if (lookahead == 'c') ADVANCE(44);
      if (lookahead == 'd') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 't') ADVANCE(84);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(429);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(427);
      if (lookahead == 'a') ADVANCE(210);
      if (lookahead == 'b') ADVANCE(158);
      if (lookahead == 'c') ADVANCE(164);
      if (lookahead == 'd') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == 'f') ADVANCE(179);
      if (lookahead == 'g') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(319);
      if (lookahead == 'l') ADVANCE(381);
      if (lookahead == 'm') ADVANCE(303);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(359);
      if (lookahead == 'p') ADVANCE(331);
      if (lookahead == 'r') ADVANCE(225);
      if (lookahead == 's') ADVANCE(168);
      if (lookahead == 't') ADVANCE(275);
      if (lookahead == 'x') ADVANCE(336);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(429);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '_') ADVANCE(936);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '/') ADVANCE(973);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(18)
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(974);
      if (lookahead != 0) ADVANCE(972);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '/') ADVANCE(973);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(18)
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(974);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(972);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(150);
      END_STATE();
    case 20:
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '/') ADVANCE(970);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(22)
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(971);
      if (lookahead != 0) ADVANCE(969);
      END_STATE();
    case 22:
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '/') ADVANCE(970);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(22)
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(969);
      END_STATE();
    case 23:
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == ':') ADVANCE(34);
      if (lookahead == 'a') ADVANCE(210);
      if (lookahead == 'b') ADVANCE(157);
      if (lookahead == 'c') ADVANCE(163);
      if (lookahead == 'd') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == 'f') ADVANCE(334);
      if (lookahead == 'g') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(261);
      if (lookahead == 'l') ADVANCE(248);
      if (lookahead == 'm') ADVANCE(303);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(359);
      if (lookahead == 'p') ADVANCE(331);
      if (lookahead == 'r') ADVANCE(225);
      if (lookahead == 's') ADVANCE(167);
      if (lookahead == 't') ADVANCE(276);
      if (lookahead == 'x') ADVANCE(336);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(23)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 24:
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(24)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(424);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(988);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '/') ADVANCE(987);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(934);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(694);
      if (lookahead == 'b') ADVANCE(918);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(29)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 31:
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(210);
      if (lookahead == 'b') ADVANCE(157);
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 'd') ADVANCE(246);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == 'f') ADVANCE(334);
      if (lookahead == 'g') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(261);
      if (lookahead == 'l') ADVANCE(248);
      if (lookahead == 'm') ADVANCE(303);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(359);
      if (lookahead == 'p') ADVANCE(331);
      if (lookahead == 'r') ADVANCE(225);
      if (lookahead == 's') ADVANCE(167);
      if (lookahead == 't') ADVANCE(276);
      if (lookahead == 'x') ADVANCE(336);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(31)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 32:
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == 'a') ADVANCE(210);
      if (lookahead == 'b') ADVANCE(158);
      if (lookahead == 'c') ADVANCE(164);
      if (lookahead == 'd') ADVANCE(250);
      if (lookahead == 'e') ADVANCE(358);
      if (lookahead == 'g') ADVANCE(159);
      if (lookahead == 'i') ADVANCE(319);
      if (lookahead == 'l') ADVANCE(381);
      if (lookahead == 'm') ADVANCE(303);
      if (lookahead == 'n') ADVANCE(335);
      if (lookahead == 'o') ADVANCE(359);
      if (lookahead == 'p') ADVANCE(331);
      if (lookahead == 'r') ADVANCE(225);
      if (lookahead == 's') ADVANCE(168);
      if (lookahead == 't') ADVANCE(276);
      if (lookahead == 'x') ADVANCE(336);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(32)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('f' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 33:
      if (lookahead == '=') ADVANCE(608);
      END_STATE();
    case 34:
      if (lookahead == '=') ADVANCE(439);
      END_STATE();
    case 35:
      if (lookahead == '=') ADVANCE(607);
      END_STATE();
    case 36:
      if (lookahead == '=') ADVANCE(607);
      if (lookahead == '>') ADVANCE(625);
      END_STATE();
    case 37:
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 38:
      if (lookahead == '>') ADVANCE(625);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(939);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(938);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(85);
      END_STATE();
    case 46:
      if (lookahead == 'b') ADVANCE(79);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 48:
      if (lookahead == 'd') ADVANCE(93);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'z') ADVANCE(41);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(940);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(447);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(434);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 63:
      if (lookahead == 'f') ADVANCE(43);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(61);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(75);
      if (lookahead == 'o') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(938);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(946);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      if (lookahead == 'k') ADVANCE(89);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(96);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(39);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(19);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(942);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 81:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 82:
      if (lookahead == 'r') ADVANCE(948);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 85:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(956);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(954);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(958);
      END_STATE();
    case 90:
      if (lookahead == 's') ADVANCE(960);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(952);
      END_STATE();
    case 92:
      if (lookahead == 's') ADVANCE(578);
      END_STATE();
    case 93:
      if (lookahead == 's') ADVANCE(950);
      END_STATE();
    case 94:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 95:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(938);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(444);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(110);
      if (lookahead == 'x') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(968);
      if (lookahead != 0) ADVANCE(964);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 103:
      if (lookahead == 'u') ADVANCE(99);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(69);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(86);
      END_STATE();
    case 106:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 107:
      if (lookahead == 'v') ADVANCE(71);
      END_STATE();
    case 108:
      if (lookahead == 'w') ADVANCE(59);
      END_STATE();
    case 109:
      if (lookahead == 'y') ADVANCE(944);
      END_STATE();
    case 110:
      if (lookahead == '{') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 111:
      if (lookahead == '}') ADVANCE(964);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(933);
      END_STATE();
    case 113:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(934);
      END_STATE();
    case 114:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(931);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(964);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(938);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 123:
      if (eof) ADVANCE(125);
      if (lookahead == '!') ADVANCE(611);
      if (lookahead == '"') ADVANCE(962);
      if (lookahead == '%') ADVANCE(605);
      if (lookahead == '&') ADVANCE(594);
      if (lookahead == '\'') ADVANCE(963);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(598);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(601);
      if (lookahead == '.') ADVANCE(426);
      if (lookahead == '/') ADVANCE(603);
      if (lookahead == '0') ADVANCE(428);
      if (lookahead == ':') ADVANCE(582);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(139);
      if (lookahead == '>') ADVANCE(134);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '_') ADVANCE(937);
      if (lookahead == 'a') ADVANCE(681);
      if (lookahead == 'b') ADVANCE(627);
      if (lookahead == 'c') ADVANCE(628);
      if (lookahead == 'd') ADVANCE(629);
      if (lookahead == 'e') ADVANCE(841);
      if (lookahead == 'f') ADVANCE(632);
      if (lookahead == 'g') ADVANCE(630);
      if (lookahead == 'h') ADVANCE(815);
      if (lookahead == 'i') ADVANCE(740);
      if (lookahead == 'l') ADVANCE(698);
      if (lookahead == 'm') ADVANCE(758);
      if (lookahead == 'n') ADVANCE(819);
      if (lookahead == 'o') ADVANCE(842);
      if (lookahead == 'p') ADVANCE(816);
      if (lookahead == 'r') ADVANCE(699);
      if (lookahead == 's') ADVANCE(637);
      if (lookahead == 't') ADVANCE(757);
      if (lookahead == 'w') ADVANCE(700);
      if (lookahead == 'x') ADVANCE(820);
      if (lookahead == 'y') ADVANCE(723);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(595);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(123)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(429);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 124:
      if (eof) ADVANCE(125);
      if (lookahead == '!') ADVANCE(33);
      if (lookahead == '"') ADVANCE(49);
      if (lookahead == '%') ADVANCE(605);
      if (lookahead == '&') ADVANCE(594);
      if (lookahead == '(') ADVANCE(145);
      if (lookahead == ')') ADVANCE(146);
      if (lookahead == '*') ADVANCE(141);
      if (lookahead == '+') ADVANCE(598);
      if (lookahead == ',') ADVANCE(143);
      if (lookahead == '-') ADVANCE(600);
      if (lookahead == '.') ADVANCE(425);
      if (lookahead == '/') ADVANCE(603);
      if (lookahead == ':') ADVANCE(581);
      if (lookahead == ';') ADVANCE(626);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(134);
      if (lookahead == '?') ADVANCE(580);
      if (lookahead == '[') ADVANCE(583);
      if (lookahead == ']') ADVANCE(584);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == 'a') ADVANCE(694);
      if (lookahead == 'b') ADVANCE(918);
      if (lookahead == 'f') ADVANCE(902);
      if (lookahead == '{') ADVANCE(142);
      if (lookahead == '|') ADVANCE(595);
      if (lookahead == '}') ADVANCE(144);
      if (lookahead == '~') ADVANCE(137);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(124)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(126);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__solidity_version);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(117);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym__solidity_version);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym__solidity_version);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(114);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(592);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(591);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(619);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(136);
      if (lookahead == '>') ADVANCE(587);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(136);
      if (lookahead == '>') ADVANCE(588);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(607);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(607);
      if (lookahead == '>') ADVANCE(625);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(606);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(606);
      if (lookahead == '=') ADVANCE(616);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DQUOTEevmasm_DQUOTE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_yul_leave);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_yul_leave);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_continue);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(301);
      if (lookahead == 'l') ADVANCE(332);
      if (lookahead == 'r') ADVANCE(251);
      if (lookahead == 'y') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(301);
      if (lookahead == 'l') ADVANCE(332);
      if (lookahead == 'y') ADVANCE(390);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(372);
      if (lookahead == 't') ADVANCE(475);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(305);
      if (lookahead == 'h') ADVANCE(169);
      if (lookahead == 'o') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(306);
      if (lookahead == 'h') ADVANCE(169);
      if (lookahead == 'o') ADVANCE(273);
      if (lookahead == 'r') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(306);
      if (lookahead == 'h') ADVANCE(169);
      if (lookahead == 'o') ADVANCE(274);
      if (lookahead == 'r') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(412);
      if (lookahead == 't') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(361);
      if (lookahead == 'd') ADVANCE(277);
      if (lookahead == 'e') ADVANCE(302);
      if (lookahead == 'g') ADVANCE(384);
      if (lookahead == 'h') ADVANCE(297);
      if (lookahead == 'i') ADVANCE(266);
      if (lookahead == 'l') ADVANCE(344);
      if (lookahead == 'm') ADVANCE(337);
      if (lookahead == 's') ADVANCE(402);
      if (lookahead == 't') ADVANCE(174);
      if (lookahead == 'u') ADVANCE(191);
      if (lookahead == 'w') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(361);
      if (lookahead == 'd') ADVANCE(277);
      if (lookahead == 'e') ADVANCE(302);
      if (lookahead == 'g') ADVANCE(384);
      if (lookahead == 'h') ADVANCE(297);
      if (lookahead == 'i') ADVANCE(266);
      if (lookahead == 'l') ADVANCE(344);
      if (lookahead == 'm') ADVANCE(337);
      if (lookahead == 's') ADVANCE(402);
      if (lookahead == 't') ADVANCE(174);
      if (lookahead == 'u') ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(401);
      if (lookahead == 'o') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(374);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(311);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(307);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(396);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'a') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'b') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'b') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'b') ADVANCE(190);
      if (lookahead == 'd') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'b') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(392);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(338);
      if (lookahead == 'h') ADVANCE(177);
      if (lookahead == 's') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(339);
      if (lookahead == 'l') ADVANCE(348);
      if (lookahead == 's') ADVANCE(292);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(341);
      if (lookahead == 's') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'c') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(211);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(455);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(484);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(465);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(467);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(510);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(498);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(500);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(558);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(502);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(528);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'd') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(514);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(508);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(512);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(520);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(545);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(568);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(564);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(526);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(531);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(535);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(265);
      if (lookahead == 'i') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 't') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(304);
      if (lookahead == 'i') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(364);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'e') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'f') ADVANCE(440);
      if (lookahead == 'n') ADVANCE(411);
      if (lookahead == 's') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'f') ADVANCE(264);
      if (lookahead == 'v') ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'f') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'f') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'f') ADVANCE(189);
      if (lookahead == 'l') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'g') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'g') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'g') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'h') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'h') ADVANCE(566);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'h') ADVANCE(539);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'h') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(324);
      if (lookahead == 'n') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'r') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(410);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(391);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(346);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(419);
      if (lookahead == 't') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(420);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'i') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'k') ADVANCE(272);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'k') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(460);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(492);
      if (lookahead == 'r') ADVANCE(494);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(547);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(340);
      if (lookahead == 'o') ADVANCE(213);
      if (lookahead == 's') ADVANCE(289);
      if (lookahead == 'u') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(298);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'l') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'm') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'm') ADVANCE(354);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'm') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'm') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(411);
      if (lookahead == 's') ADVANCE(418);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(562);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(552);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'n') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(360);
      if (lookahead == 'u') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(382);
      if (lookahead == 'u') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(355);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(356);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(173);
      if (lookahead == 't') ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(370);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'o') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(469);
      if (lookahead == 't') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(504);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(570);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(416);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'p') ADVANCE(417);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'q') ADVANCE(481);
      if (lookahead == 'x') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(487);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(488);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(572);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(385);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'r') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(518);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 's') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(403);
      if (lookahead == 'v') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(479);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(576);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(556);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 't') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'u') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'v') ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'v') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'v') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'x') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'y') ADVANCE(574);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'y') ADVANCE(533);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'y') ADVANCE(530);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'y') ADVANCE(537);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'z') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(423);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'z') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(423);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'z') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(423);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'z') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(423);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == 'z') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(423);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_yul_identifier);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(424);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(933);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (lookahead == 'x') ADVANCE(430);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (lookahead == 'x') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(928);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(429);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_yul_hex_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(430);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_let);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_switch);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_default);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_default);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_function);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_stop);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_stop);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_add);
      if (lookahead == 'm') ADVANCE(343);
      if (lookahead == 'r') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_add);
      if (lookahead == 'm') ADVANCE(824);
      if (lookahead == 'r') ADVANCE(731);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_sub);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_sub);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_mul);
      if (lookahead == 'm') ADVANCE(828);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_mul);
      if (lookahead == 'm') ADVANCE(347);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_div);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_div);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_sdiv);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_sdiv);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_mod);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_mod);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_smod);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_smod);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_exp);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_exp);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_lt);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_lt);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_gt);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_gt);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_slt);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_slt);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_sgt);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_sgt);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_eq);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_eq);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_iszero);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'i') ADVANCE(748);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'i') ADVANCE(267);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_xor);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_xor);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_byte);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_byte);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_shl);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_shl);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_shr);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_shr);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_sar);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_sar);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_addmod);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_addmod);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_mulmod);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_mulmod);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_signextend);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_signextend);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_pop);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_pop);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_mload);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_mload);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_mstore);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_mstore);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_sload);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_sload);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_sstore);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_sstore);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_msize);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_msize);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_gas);
      if (lookahead == 'l') ADVANCE(760);
      if (lookahead == 'p') ADVANCE(861);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_gas);
      if (lookahead == 'l') ADVANCE(278);
      if (lookahead == 'p') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_address);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_address);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_balance);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_balance);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_selfbalance);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_selfbalance);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_caller);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_caller);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_callvalue);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_callvalue);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_calldataload);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_calldatasize);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_calldatacopy);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_extcodesize);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_extcodesize);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_extcodecopy);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_extcodecopy);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_returndatasize);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_returndatasize);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_returndatacopy);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_returndatacopy);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_extcodehash);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_extcodehash);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_create);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_create);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == 'c') ADVANCE(833);
      if (lookahead == 'e') ADVANCE(847);
      if (lookahead == 'v') ADVANCE(648);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == 'c') ADVANCE(350);
      if (lookahead == 'd') ADVANCE(184);
      if (lookahead == 'e') ADVANCE(363);
      if (lookahead == 'v') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_callcode);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_callcode);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_delegatecall);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_delegatecall);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_staticcall);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_staticcall);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == 'd') ADVANCE(656);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == 'd') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_revert);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_revert);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_selfdestruct);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_selfdestruct);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_invalid);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_invalid);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_chainid);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_chainid);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_origin);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_origin);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_gasprice);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_gasprice);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_blockhash);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_blockhash);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_coinbase);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_coinbase);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_timestamp);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_timestamp);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_number);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_difficulty);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_difficulty);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_gaslimit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(927);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(423);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_gaslimit);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_returns);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_returns);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(439);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(622);
      if (lookahead == '>') ADVANCE(590);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(589);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(623);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(624);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(585);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(585);
      if (lookahead == '=') ADVANCE(620);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(621);
      if (lookahead == '|') ADVANCE(586);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(586);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(612);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(612);
      if (lookahead == '=') ADVANCE(614);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(613);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(613);
      if (lookahead == '=') ADVANCE(615);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(613);
      if (lookahead == '=') ADVANCE(615);
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(988);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(988);
      if (lookahead == '=') ADVANCE(617);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(618);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(609);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(608);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym__semicolon);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(785);
      if (lookahead == 'l') ADVANCE(817);
      if (lookahead == 'r') ADVANCE(727);
      if (lookahead == 'y') ADVANCE(887);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(784);
      if (lookahead == 'h') ADVANCE(638);
      if (lookahead == 'o') ADVANCE(761);
      if (lookahead == 'r') ADVANCE(729);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(923);
      if (lookahead == 'e') ADVANCE(745);
      if (lookahead == 'i') ADVANCE(742);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(862);
      if (lookahead == 't') ADVANCE(476);
      if (lookahead == 'w') ADVANCE(725);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(673);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'i') ADVANCE(805);
      if (lookahead == 'o') ADVANCE(843);
      if (lookahead == 'u') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'o') ADVANCE(843);
      if (lookahead == 'u') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'u') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(916);
      if (lookahead == 't') ADVANCE(438);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(844);
      if (lookahead == 'd') ADVANCE(759);
      if (lookahead == 'e') ADVANCE(668);
      if (lookahead == 'g') ADVANCE(880);
      if (lookahead == 'h') ADVANCE(779);
      if (lookahead == 'i') ADVANCE(747);
      if (lookahead == 'l') ADVANCE(830);
      if (lookahead == 'm') ADVANCE(821);
      if (lookahead == 's') ADVANCE(900);
      if (lookahead == 't') ADVANCE(647);
      if (lookahead == 'u') ADVANCE(661);
      if (lookahead == 'w') ADVANCE(764);
      if (lookahead == 'z') ADVANCE(639);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'y')) ADVANCE(927);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(762);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(662);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(775);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(904);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(794);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(686);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(790);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(852);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(687);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(898);
      if (lookahead == 'o') ADVANCE(837);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(791);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(786);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(871);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(872);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(891);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(806);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(878);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(787);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(893);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(814);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(873);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(894);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(792);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(458);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(818);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(654);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(660);
      if (lookahead == 'd') ADVANCE(736);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(734);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(776);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(750);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(825);
      if (lookahead == 'l') ADVANCE(743);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(888);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(675);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(826);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(822);
      if (lookahead == 'h') ADVANCE(651);
      if (lookahead == 's') ADVANCE(771);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(823);
      if (lookahead == 's') ADVANCE(774);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(884);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(649);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(712);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(717);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(720);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(655);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(910);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(682);
      if (lookahead == 'n') ADVANCE(683);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(456);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(485);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(466);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(468);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(507);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(511);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(499);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(501);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(561);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(559);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(503);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(869);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(697);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(713);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(714);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(855);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(636);
      if (lookahead == 't') ADVANCE(474);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(896);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(701);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(777);
      if (lookahead == 'i') ADVANCE(941);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(491);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(449);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(433);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(436);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(515);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(917);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(542);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(509);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(513);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(521);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(672);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(546);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(569);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(156);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(565);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(527);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(532);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(523);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(536);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(645);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(749);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(756);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(746);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(640);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(875);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(652);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(846);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(874);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(868);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(853);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(848);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(899);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(877);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(809);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(679);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(901);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(441);
      if (lookahead == 'n') ADVANCE(915);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(441);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(744);
      if (lookahead == 'v') ADVANCE(462);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(664);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(763);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(641);
      if (lookahead == 'l') ADVANCE(724);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(641);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(812);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(767);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'g') ADVANCE(659);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(443);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(567);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(540);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(730);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(650);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(924);
      if (lookahead == 't') ADVANCE(827);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(947);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(795);
      if (lookahead == 'r') ADVANCE(906);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(801);
      if (lookahead == 'l') ADVANCE(829);
      if (lookahead == 'o') ADVANCE(684);
      if (lookahead == 's') ADVANCE(755);
      if (lookahead == 'u') ADVANCE(778);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(914);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(796);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(803);
      if (lookahead == 'n') ADVANCE(897);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(807);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(680);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(670);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(813);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(797);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(690);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(691);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(883);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(925);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(677);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(831);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(926);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(154);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(754);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'k') ADVANCE(865);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(493);
      if (lookahead == 'r') ADVANCE(495);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(543);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(550);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(548);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(876);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(780);
      if (lookahead == 's') ADVANCE(703);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(653);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(781);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(782);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(882);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(885);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(769);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(908);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(657);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(665);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(838);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(728);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(770);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(563);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(551);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(451);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(553);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(912);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(669);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(663);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(897);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(810);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(676);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(768);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(693);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(692);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(722);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(870);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(708);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(907);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(678);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(903);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(836);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(666);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(943);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(879);
      if (lookahead == 'u') ADVANCE(793);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(845);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(685);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(839);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(840);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(688);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(808);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(695);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(858);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(689);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(643);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(646);
      if (lookahead == 't') ADVANCE(478);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(799);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(804);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(696);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(859);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(470);
      if (lookahead == 't') ADVANCE(671);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(505);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(454);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(571);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(921);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(922);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'q') ADVANCE(482);
      if (lookahead == 't') ADVANCE(753);
      if (lookahead == 'x') ADVANCE(835);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(486);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(149);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(497);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(489);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(949);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(525);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(573);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(906);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(864);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(909);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(866);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(881);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(798);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(731);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(800);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(811);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(710);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(711);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(727);
      if (lookahead == 'y') ADVANCE(887);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(772);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(516);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(957);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(955);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(959);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(961);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(519);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(953);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(951);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(579);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(751);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(752);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(703);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(867);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(890);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(705);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(889);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(715);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(472);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(480);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(555);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(446);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(577);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(557);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(920);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(667);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(702);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(773);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(851);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(642);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(709);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(732);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(631);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(738);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(737);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(905);
      if (lookahead == 'v') ADVANCE(733);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(766);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(765);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(834);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(913);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(850);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(788);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(854);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(704);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(716);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(718);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(674);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(789);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(856);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(892);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(857);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(464);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(644);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(706);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(895);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(887);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(945);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(575);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(534);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(538);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(863);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(707);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(927);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(719);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(927);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'z') ADVANCE(721);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(927);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(928);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(30);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(935);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(930);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(115);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(930);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(931);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(932);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(933);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(934);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(aux_sym__hex_number_token1);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym__hex_digit);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym__hex_digit);
      if (lookahead == 'y') ADVANCE(87);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_wei);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_wei);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_szabo);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_szabo);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_finney);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_finney);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_gwei);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_gwei);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_ether);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_ether);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_seconds);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_seconds);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_minutes);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_minutes);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_hours);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_hours);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_days);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_days);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_weeks);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_weeks);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_years);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_years);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(927);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym__escape_sequence);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(981);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(975);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(964);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(967);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(988);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(970);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(971);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(969);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(988);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(973);
      if (lookahead == '\t' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(974);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(972);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(978);
      if (lookahead == '/') ADVANCE(980);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(980);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(977);
      if (lookahead == '/') ADVANCE(978);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(978);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(977);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(978);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(976);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(979);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(980);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(980);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(984);
      if (lookahead == '/') ADVANCE(986);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(986);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(983);
      if (lookahead == '/') ADVANCE(984);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(984);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(983);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(984);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(982);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(985);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(986);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(986);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(988);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(24);
      if (lookahead == 'y') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'm') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(33);
      if (lookahead == 'v') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'm') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      if (lookahead == 's') ADVANCE(42);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'v') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'r') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 17:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'y') ADVANCE(59);
      END_STATE();
    case 18:
      if (lookahead == 'f') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      if (lookahead == 'n') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(72);
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 27:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 33:
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 37:
      if (lookahead == 'x') ADVANCE(83);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 39:
      if (lookahead == 'x') ADVANCE(85);
      END_STATE();
    case 40:
      if (lookahead == 'm') ADVANCE(86);
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(88);
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 43:
      if (lookahead == 'c') ADVANCE(90);
      END_STATE();
    case 44:
      if (lookahead == 'b') ADVANCE(91);
      END_STATE();
    case 45:
      if (lookahead == 'g') ADVANCE(92);
      END_STATE();
    case 46:
      if (lookahead == 'p') ADVANCE(93);
      END_STATE();
    case 47:
      if (lookahead == 'm') ADVANCE(94);
      END_STATE();
    case 48:
      if (lookahead == 'd') ADVANCE(95);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 50:
      if (lookahead == 'w') ADVANCE(97);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(99);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(100);
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 54:
      if (lookahead == 'b') ADVANCE(102);
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 55:
      if (lookahead == 'c') ADVANCE(104);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(105);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 58:
      if (lookahead == 'y') ADVANCE(108);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(112);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(114);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(115);
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(125);
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 'm') ADVANCE(131);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(132);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 84:
      if (lookahead == 'm') ADVANCE(136);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_hex);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(138);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '1') ADVANCE(140);
      if (lookahead == '2') ADVANCE(141);
      if (lookahead == '3') ADVANCE(142);
      if (lookahead == '4') ADVANCE(143);
      if (lookahead == '5') ADVANCE(144);
      if (lookahead == '6') ADVANCE(145);
      if (lookahead == '7') ADVANCE(146);
      if (lookahead == '8') ADVANCE(147);
      if (lookahead == '9') ADVANCE(148);
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(150);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 92:
      if (lookahead == '0') ADVANCE(152);
      if (lookahead == '1') ADVANCE(153);
      if (lookahead == '2') ADVANCE(154);
      if (lookahead == '3') ADVANCE(155);
      if (lookahead == '4') ADVANCE(156);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 94:
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 100:
      if (lookahead == 'g') ADVANCE(163);
      END_STATE();
    case 101:
      if (lookahead == 'v') ADVANCE(164);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(165);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(168);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(170);
      if (lookahead == 'u') ADVANCE(171);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 110:
      if (lookahead == 'x') ADVANCE(173);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 112:
      if (lookahead == 'c') ADVANCE(175);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(176);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 115:
      if (lookahead == 'w') ADVANCE(177);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 117:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 118:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 119:
      if (lookahead == 'y') ADVANCE(181);
      END_STATE();
    case 120:
      if (lookahead == 'm') ADVANCE(182);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 122:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(184);
      END_STATE();
    case 124:
      if (lookahead == 'h') ADVANCE(185);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 126:
      if (lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_emit);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(190);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(191);
      END_STATE();
    case 134:
      if (lookahead == 'b') ADVANCE(192);
      END_STATE();
    case 135:
      if (lookahead == 'd') ADVANCE(193);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 137:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 138:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 139:
      if (lookahead == 'x') ADVANCE(196);
      END_STATE();
    case 140:
      if (lookahead == '0') ADVANCE(197);
      if (lookahead == '1') ADVANCE(198);
      if (lookahead == '2') ADVANCE(199);
      if (lookahead == '3') ADVANCE(200);
      if (lookahead == '4') ADVANCE(201);
      if (lookahead == '5') ADVANCE(202);
      if (lookahead == '6') ADVANCE(203);
      if (lookahead == '7') ADVANCE(204);
      if (lookahead == '8') ADVANCE(205);
      if (lookahead == '9') ADVANCE(206);
      END_STATE();
    case 141:
      if (lookahead == '0') ADVANCE(207);
      if (lookahead == '1') ADVANCE(208);
      if (lookahead == '2') ADVANCE(209);
      if (lookahead == '3') ADVANCE(210);
      if (lookahead == '4') ADVANCE(211);
      if (lookahead == '5') ADVANCE(212);
      END_STATE();
    case 142:
      if (lookahead == '2') ADVANCE(213);
      END_STATE();
    case 143:
      if (lookahead == '0') ADVANCE(214);
      if (lookahead == '8') ADVANCE(215);
      END_STATE();
    case 144:
      if (lookahead == '6') ADVANCE(216);
      END_STATE();
    case 145:
      if (lookahead == '4') ADVANCE(217);
      END_STATE();
    case 146:
      if (lookahead == '2') ADVANCE(218);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_int8);
      if (lookahead == '0') ADVANCE(219);
      if (lookahead == '8') ADVANCE(220);
      END_STATE();
    case 148:
      if (lookahead == '6') ADVANCE(221);
      END_STATE();
    case 149:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(223);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_log0);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_log1);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_log2);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_log3);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_log4);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 159:
      if (lookahead == 'f') ADVANCE(227);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(228);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 162:
      if (lookahead == 'b') ADVANCE(230);
      END_STATE();
    case 163:
      if (lookahead == 'm') ADVANCE(231);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(233);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 168:
      if (lookahead == 'd') ADVANCE(235);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 170:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 171:
      if (lookahead == 'c') ADVANCE(238);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(239);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_uint);
      if (lookahead == '1') ADVANCE(240);
      if (lookahead == '2') ADVANCE(241);
      if (lookahead == '3') ADVANCE(242);
      if (lookahead == '4') ADVANCE(243);
      if (lookahead == '5') ADVANCE(244);
      if (lookahead == '6') ADVANCE(245);
      if (lookahead == '7') ADVANCE(246);
      if (lookahead == '8') ADVANCE(247);
      if (lookahead == '9') ADVANCE(248);
      END_STATE();
    case 175:
      if (lookahead == 'o') ADVANCE(249);
      END_STATE();
    case 176:
      if (lookahead == 'g') ADVANCE(250);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_view);
      END_STATE();
    case 178:
      if (lookahead == 'u') ADVANCE(251);
      END_STATE();
    case 179:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(253);
      END_STATE();
    case 181:
      if (lookahead == 'm') ADVANCE(254);
      END_STATE();
    case 182:
      if (lookahead == 'b') ADVANCE(255);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (lookahead == '1') ADVANCE(256);
      if (lookahead == '2') ADVANCE(257);
      if (lookahead == '3') ADVANCE(258);
      if (lookahead == '4') ADVANCE(259);
      if (lookahead == '5') ADVANCE(260);
      if (lookahead == '6') ADVANCE(261);
      if (lookahead == '7') ADVANCE(262);
      if (lookahead == '8') ADVANCE(263);
      if (lookahead == '9') ADVANCE(264);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(265);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(266);
      if (lookahead == 'r') ADVANCE(267);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(268);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(269);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(270);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 191:
      if (lookahead == 'n') ADVANCE(271);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(272);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_fixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 194:
      if (lookahead == 'a') ADVANCE(274);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(276);
      END_STATE();
    case 197:
      if (lookahead == '4') ADVANCE(277);
      END_STATE();
    case 198:
      if (lookahead == '2') ADVANCE(278);
      END_STATE();
    case 199:
      if (lookahead == '0') ADVANCE(279);
      if (lookahead == '8') ADVANCE(280);
      END_STATE();
    case 200:
      if (lookahead == '6') ADVANCE(281);
      END_STATE();
    case 201:
      if (lookahead == '4') ADVANCE(282);
      END_STATE();
    case 202:
      if (lookahead == '2') ADVANCE(283);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_int16);
      if (lookahead == '0') ADVANCE(284);
      if (lookahead == '8') ADVANCE(285);
      END_STATE();
    case 204:
      if (lookahead == '6') ADVANCE(286);
      END_STATE();
    case 205:
      if (lookahead == '4') ADVANCE(287);
      END_STATE();
    case 206:
      if (lookahead == '2') ADVANCE(288);
      END_STATE();
    case 207:
      if (lookahead == '0') ADVANCE(289);
      if (lookahead == '8') ADVANCE(290);
      END_STATE();
    case 208:
      if (lookahead == '6') ADVANCE(291);
      END_STATE();
    case 209:
      if (lookahead == '4') ADVANCE(292);
      END_STATE();
    case 210:
      if (lookahead == '2') ADVANCE(293);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_int24);
      if (lookahead == '0') ADVANCE(294);
      if (lookahead == '8') ADVANCE(295);
      END_STATE();
    case 212:
      if (lookahead == '6') ADVANCE(296);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_int32);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_int40);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_int48);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_int56);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_int64);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_int72);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_int80);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_int88);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_int96);
      END_STATE();
    case 222:
      if (lookahead == 'f') ADVANCE(297);
      if (lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 223:
      if (lookahead == 'k') ADVANCE(299);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(300);
      END_STATE();
    case 225:
      if (lookahead == 'n') ADVANCE(301);
      END_STATE();
    case 226:
      if (lookahead == 'y') ADVANCE(302);
      END_STATE();
    case 227:
      if (lookahead == 'i') ADVANCE(303);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(304);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(305);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(306);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(307);
      END_STATE();
    case 232:
      if (lookahead == 't') ADVANCE(308);
      END_STATE();
    case 233:
      if (lookahead == 'c') ADVANCE(309);
      END_STATE();
    case 234:
      if (lookahead == 'v') ADVANCE(310);
      END_STATE();
    case 235:
      if (lookahead == 'i') ADVANCE(311);
      END_STATE();
    case 236:
      if (lookahead == 'g') ADVANCE(312);
      END_STATE();
    case 237:
      if (lookahead == 'g') ADVANCE(313);
      END_STATE();
    case 238:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 239:
      if (lookahead == 'd') ADVANCE(315);
      END_STATE();
    case 240:
      if (lookahead == '0') ADVANCE(316);
      if (lookahead == '1') ADVANCE(317);
      if (lookahead == '2') ADVANCE(318);
      if (lookahead == '3') ADVANCE(319);
      if (lookahead == '4') ADVANCE(320);
      if (lookahead == '5') ADVANCE(321);
      if (lookahead == '6') ADVANCE(322);
      if (lookahead == '7') ADVANCE(323);
      if (lookahead == '8') ADVANCE(324);
      if (lookahead == '9') ADVANCE(325);
      END_STATE();
    case 241:
      if (lookahead == '0') ADVANCE(326);
      if (lookahead == '1') ADVANCE(327);
      if (lookahead == '2') ADVANCE(328);
      if (lookahead == '3') ADVANCE(329);
      if (lookahead == '4') ADVANCE(330);
      if (lookahead == '5') ADVANCE(331);
      END_STATE();
    case 242:
      if (lookahead == '2') ADVANCE(332);
      END_STATE();
    case 243:
      if (lookahead == '0') ADVANCE(333);
      if (lookahead == '8') ADVANCE(334);
      END_STATE();
    case 244:
      if (lookahead == '6') ADVANCE(335);
      END_STATE();
    case 245:
      if (lookahead == '4') ADVANCE(336);
      END_STATE();
    case 246:
      if (lookahead == '2') ADVANCE(337);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_uint8);
      if (lookahead == '0') ADVANCE(338);
      if (lookahead == '8') ADVANCE(339);
      END_STATE();
    case 248:
      if (lookahead == '6') ADVANCE(340);
      END_STATE();
    case 249:
      if (lookahead == 'd') ADVANCE(341);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 251:
      if (lookahead == 'a') ADVANCE(342);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 253:
      if (lookahead == 'c') ADVANCE(343);
      END_STATE();
    case 254:
      if (lookahead == 'o') ADVANCE(344);
      END_STATE();
    case 255:
      if (lookahead == 'l') ADVANCE(345);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_bytes1);
      if (lookahead == '0') ADVANCE(346);
      if (lookahead == '1') ADVANCE(347);
      if (lookahead == '2') ADVANCE(348);
      if (lookahead == '3') ADVANCE(349);
      if (lookahead == '4') ADVANCE(350);
      if (lookahead == '5') ADVANCE(351);
      if (lookahead == '6') ADVANCE(352);
      if (lookahead == '7') ADVANCE(353);
      if (lookahead == '8') ADVANCE(354);
      if (lookahead == '9') ADVANCE(355);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_bytes2);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == '1') ADVANCE(357);
      if (lookahead == '2') ADVANCE(358);
      if (lookahead == '3') ADVANCE(359);
      if (lookahead == '4') ADVANCE(360);
      if (lookahead == '5') ADVANCE(361);
      if (lookahead == '6') ADVANCE(362);
      if (lookahead == '7') ADVANCE(363);
      if (lookahead == '8') ADVANCE(364);
      if (lookahead == '9') ADVANCE(365);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_bytes3);
      if (lookahead == '0') ADVANCE(366);
      if (lookahead == '1') ADVANCE(367);
      if (lookahead == '2') ADVANCE(368);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_bytes4);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_bytes5);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_bytes6);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_bytes7);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_bytes8);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_bytes9);
      END_STATE();
    case 265:
      if (lookahead == 't') ADVANCE(369);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(370);
      END_STATE();
    case 267:
      if (lookahead == 'u') ADVANCE(371);
      END_STATE();
    case 268:
      if (lookahead == 'c') ADVANCE(372);
      END_STATE();
    case 269:
      if (lookahead == '2') ADVANCE(373);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 271:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 272:
      if (lookahead == 'c') ADVANCE(375);
      END_STATE();
    case 273:
      if (lookahead == 'x') ADVANCE(376);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(273);
      END_STATE();
    case 274:
      if (lookahead == 'b') ADVANCE(377);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 276:
      if (lookahead == 'd') ADVANCE(378);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_int104);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_int112);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_int120);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_int128);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_int136);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_int144);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_int152);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_int160);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_int168);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_int176);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_int184);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_int192);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_int200);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_int208);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_int216);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_int224);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_int232);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_int240);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_int248);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_int256);
      END_STATE();
    case 297:
      if (lookahead == 'a') ADVANCE(379);
      END_STATE();
    case 298:
      if (lookahead == 'a') ADVANCE(380);
      END_STATE();
    case 299:
      if (lookahead == '2') ADVANCE(381);
      END_STATE();
    case 300:
      if (lookahead == 'y') ADVANCE(382);
      END_STATE();
    case 301:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_memory);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(384);
      END_STATE();
    case 304:
      if (lookahead == '8') ADVANCE(385);
      END_STATE();
    case 305:
      if (lookahead == 'd') ADVANCE(386);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(387);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(388);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(389);
      END_STATE();
    case 311:
      if (lookahead == 't') ADVANCE(390);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(391);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_ufixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(392);
      END_STATE();
    case 316:
      if (lookahead == '4') ADVANCE(393);
      END_STATE();
    case 317:
      if (lookahead == '2') ADVANCE(394);
      END_STATE();
    case 318:
      if (lookahead == '0') ADVANCE(395);
      if (lookahead == '8') ADVANCE(396);
      END_STATE();
    case 319:
      if (lookahead == '6') ADVANCE(397);
      END_STATE();
    case 320:
      if (lookahead == '4') ADVANCE(398);
      END_STATE();
    case 321:
      if (lookahead == '2') ADVANCE(399);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_uint16);
      if (lookahead == '0') ADVANCE(400);
      if (lookahead == '8') ADVANCE(401);
      END_STATE();
    case 323:
      if (lookahead == '6') ADVANCE(402);
      END_STATE();
    case 324:
      if (lookahead == '4') ADVANCE(403);
      END_STATE();
    case 325:
      if (lookahead == '2') ADVANCE(404);
      END_STATE();
    case 326:
      if (lookahead == '0') ADVANCE(405);
      if (lookahead == '8') ADVANCE(406);
      END_STATE();
    case 327:
      if (lookahead == '6') ADVANCE(407);
      END_STATE();
    case 328:
      if (lookahead == '4') ADVANCE(408);
      END_STATE();
    case 329:
      if (lookahead == '2') ADVANCE(409);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_uint24);
      if (lookahead == '0') ADVANCE(410);
      if (lookahead == '8') ADVANCE(411);
      END_STATE();
    case 331:
      if (lookahead == '6') ADVANCE(412);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_uint32);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_uint40);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_uint48);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_uint56);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_uint64);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_uint72);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_uint80);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_uint88);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_uint96);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(413);
      END_STATE();
    case 342:
      if (lookahead == 'l') ADVANCE(414);
      END_STATE();
    case 343:
      if (lookahead == 't') ADVANCE(415);
      END_STATE();
    case 344:
      if (lookahead == 'u') ADVANCE(416);
      END_STATE();
    case 345:
      if (lookahead == 'y') ADVANCE(417);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_bytes10);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_bytes11);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_bytes12);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_bytes13);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_bytes14);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_bytes15);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_bytes16);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_bytes17);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_bytes18);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_bytes19);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_bytes20);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_bytes21);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_bytes22);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_bytes23);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_bytes24);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_bytes25);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_bytes26);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_bytes27);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_bytes28);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_bytes29);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_bytes30);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_bytes31);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_bytes32);
      END_STATE();
    case 369:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 371:
      if (lookahead == 'c') ADVANCE(420);
      END_STATE();
    case 372:
      if (lookahead == 't') ADVANCE(421);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_create2);
      END_STATE();
    case 374:
      if (lookahead == 'l') ADVANCE(422);
      END_STATE();
    case 375:
      if (lookahead == 'k') ADVANCE(423);
      END_STATE();
    case 376:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(424);
      END_STATE();
    case 377:
      if (lookahead == 'l') ADVANCE(425);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_indexed);
      END_STATE();
    case 379:
      if (lookahead == 'c') ADVANCE(426);
      END_STATE();
    case 380:
      if (lookahead == 'l') ADVANCE(427);
      END_STATE();
    case 381:
      if (lookahead == '5') ADVANCE(428);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_library);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_mapping);
      END_STATE();
    case 384:
      if (lookahead == 'r') ADVANCE(429);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_mstore8);
      END_STATE();
    case 386:
      if (lookahead == 'e') ADVANCE(430);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_payable);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_receive);
      END_STATE();
    case 390:
      if (lookahead == 'y') ADVANCE(431);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_storage);
      END_STATE();
    case 392:
      if (lookahead == 'x') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(392);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_uint104);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_uint112);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_uint120);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_uint128);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_uint136);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_uint144);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_uint152);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_uint160);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_uint168);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_uint176);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_uint184);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_uint192);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_uint200);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_uint208);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_uint216);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_uint224);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_uint232);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_uint240);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_uint248);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_uint256);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_unicode);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_virtual);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 416:
      if (lookahead == 's') ADVANCE(433);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_assembly);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_calldata);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_constant);
      END_STATE();
    case 420:
      if (lookahead == 't') ADVANCE(434);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_fallback);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(aux_sym__fixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(424);
      END_STATE();
    case 425:
      if (lookahead == 'e') ADVANCE(435);
      END_STATE();
    case 426:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 428:
      if (lookahead == '6') ADVANCE(437);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_modifier);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_solidity);
      END_STATE();
    case 432:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(438);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_anonymous);
      END_STATE();
    case 434:
      if (lookahead == 'o') ADVANCE(439);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_immutable);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_keccak256);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(aux_sym__ufixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(438);
      END_STATE();
    case 439:
      if (lookahead == 'r') ADVANCE(440);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_constructor);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 124},
  [2] = {.lex_state = 12},
  [3] = {.lex_state = 12},
  [4] = {.lex_state = 12},
  [5] = {.lex_state = 12},
  [6] = {.lex_state = 12},
  [7] = {.lex_state = 12},
  [8] = {.lex_state = 12},
  [9] = {.lex_state = 12},
  [10] = {.lex_state = 12},
  [11] = {.lex_state = 12},
  [12] = {.lex_state = 12},
  [13] = {.lex_state = 12},
  [14] = {.lex_state = 12},
  [15] = {.lex_state = 12},
  [16] = {.lex_state = 12},
  [17] = {.lex_state = 12},
  [18] = {.lex_state = 12},
  [19] = {.lex_state = 12},
  [20] = {.lex_state = 11},
  [21] = {.lex_state = 11},
  [22] = {.lex_state = 11},
  [23] = {.lex_state = 10},
  [24] = {.lex_state = 10},
  [25] = {.lex_state = 10},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 10},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 10},
  [33] = {.lex_state = 10},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 10},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 10},
  [38] = {.lex_state = 10},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 10},
  [42] = {.lex_state = 10},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 10},
  [45] = {.lex_state = 10},
  [46] = {.lex_state = 10},
  [47] = {.lex_state = 10},
  [48] = {.lex_state = 10},
  [49] = {.lex_state = 10},
  [50] = {.lex_state = 10},
  [51] = {.lex_state = 10},
  [52] = {.lex_state = 10},
  [53] = {.lex_state = 10},
  [54] = {.lex_state = 10},
  [55] = {.lex_state = 10},
  [56] = {.lex_state = 10},
  [57] = {.lex_state = 10},
  [58] = {.lex_state = 10},
  [59] = {.lex_state = 10},
  [60] = {.lex_state = 10},
  [61] = {.lex_state = 10},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 10},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 10},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 10},
  [73] = {.lex_state = 10},
  [74] = {.lex_state = 10},
  [75] = {.lex_state = 10},
  [76] = {.lex_state = 10},
  [77] = {.lex_state = 10},
  [78] = {.lex_state = 10},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 10},
  [81] = {.lex_state = 10},
  [82] = {.lex_state = 10},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 10},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 10},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 10},
  [95] = {.lex_state = 10},
  [96] = {.lex_state = 12},
  [97] = {.lex_state = 12},
  [98] = {.lex_state = 12},
  [99] = {.lex_state = 12},
  [100] = {.lex_state = 12},
  [101] = {.lex_state = 12},
  [102] = {.lex_state = 12},
  [103] = {.lex_state = 12},
  [104] = {.lex_state = 12},
  [105] = {.lex_state = 12},
  [106] = {.lex_state = 12},
  [107] = {.lex_state = 12},
  [108] = {.lex_state = 12},
  [109] = {.lex_state = 12},
  [110] = {.lex_state = 12},
  [111] = {.lex_state = 12},
  [112] = {.lex_state = 12},
  [113] = {.lex_state = 12},
  [114] = {.lex_state = 12},
  [115] = {.lex_state = 12},
  [116] = {.lex_state = 12},
  [117] = {.lex_state = 12},
  [118] = {.lex_state = 12},
  [119] = {.lex_state = 12},
  [120] = {.lex_state = 12},
  [121] = {.lex_state = 12},
  [122] = {.lex_state = 124},
  [123] = {.lex_state = 124},
  [124] = {.lex_state = 124},
  [125] = {.lex_state = 124},
  [126] = {.lex_state = 124},
  [127] = {.lex_state = 10},
  [128] = {.lex_state = 10},
  [129] = {.lex_state = 10},
  [130] = {.lex_state = 124},
  [131] = {.lex_state = 124},
  [132] = {.lex_state = 124},
  [133] = {.lex_state = 124},
  [134] = {.lex_state = 124},
  [135] = {.lex_state = 124},
  [136] = {.lex_state = 124},
  [137] = {.lex_state = 124},
  [138] = {.lex_state = 124},
  [139] = {.lex_state = 124},
  [140] = {.lex_state = 124},
  [141] = {.lex_state = 124},
  [142] = {.lex_state = 124},
  [143] = {.lex_state = 124},
  [144] = {.lex_state = 124},
  [145] = {.lex_state = 124},
  [146] = {.lex_state = 124},
  [147] = {.lex_state = 124},
  [148] = {.lex_state = 124},
  [149] = {.lex_state = 124},
  [150] = {.lex_state = 124},
  [151] = {.lex_state = 124},
  [152] = {.lex_state = 124},
  [153] = {.lex_state = 124},
  [154] = {.lex_state = 124},
  [155] = {.lex_state = 124},
  [156] = {.lex_state = 124},
  [157] = {.lex_state = 124},
  [158] = {.lex_state = 124},
  [159] = {.lex_state = 124},
  [160] = {.lex_state = 124},
  [161] = {.lex_state = 124},
  [162] = {.lex_state = 124},
  [163] = {.lex_state = 124},
  [164] = {.lex_state = 124},
  [165] = {.lex_state = 124},
  [166] = {.lex_state = 124},
  [167] = {.lex_state = 124},
  [168] = {.lex_state = 124},
  [169] = {.lex_state = 124},
  [170] = {.lex_state = 124},
  [171] = {.lex_state = 124},
  [172] = {.lex_state = 124},
  [173] = {.lex_state = 124},
  [174] = {.lex_state = 124},
  [175] = {.lex_state = 124},
  [176] = {.lex_state = 124},
  [177] = {.lex_state = 124},
  [178] = {.lex_state = 124},
  [179] = {.lex_state = 124},
  [180] = {.lex_state = 124},
  [181] = {.lex_state = 124},
  [182] = {.lex_state = 124},
  [183] = {.lex_state = 124},
  [184] = {.lex_state = 124},
  [185] = {.lex_state = 124},
  [186] = {.lex_state = 124},
  [187] = {.lex_state = 124},
  [188] = {.lex_state = 124},
  [189] = {.lex_state = 124},
  [190] = {.lex_state = 124},
  [191] = {.lex_state = 124},
  [192] = {.lex_state = 124},
  [193] = {.lex_state = 124},
  [194] = {.lex_state = 124},
  [195] = {.lex_state = 124},
  [196] = {.lex_state = 124},
  [197] = {.lex_state = 124},
  [198] = {.lex_state = 124},
  [199] = {.lex_state = 124},
  [200] = {.lex_state = 124},
  [201] = {.lex_state = 124},
  [202] = {.lex_state = 124},
  [203] = {.lex_state = 124},
  [204] = {.lex_state = 124},
  [205] = {.lex_state = 124},
  [206] = {.lex_state = 124},
  [207] = {.lex_state = 124},
  [208] = {.lex_state = 124},
  [209] = {.lex_state = 124},
  [210] = {.lex_state = 124},
  [211] = {.lex_state = 124},
  [212] = {.lex_state = 124},
  [213] = {.lex_state = 124},
  [214] = {.lex_state = 124},
  [215] = {.lex_state = 124},
  [216] = {.lex_state = 124},
  [217] = {.lex_state = 124},
  [218] = {.lex_state = 124},
  [219] = {.lex_state = 124},
  [220] = {.lex_state = 124},
  [221] = {.lex_state = 124},
  [222] = {.lex_state = 124},
  [223] = {.lex_state = 124},
  [224] = {.lex_state = 124},
  [225] = {.lex_state = 124},
  [226] = {.lex_state = 124},
  [227] = {.lex_state = 124},
  [228] = {.lex_state = 29},
  [229] = {.lex_state = 29},
  [230] = {.lex_state = 124},
  [231] = {.lex_state = 23},
  [232] = {.lex_state = 23},
  [233] = {.lex_state = 23},
  [234] = {.lex_state = 23},
  [235] = {.lex_state = 23},
  [236] = {.lex_state = 23},
  [237] = {.lex_state = 23},
  [238] = {.lex_state = 23},
  [239] = {.lex_state = 23},
  [240] = {.lex_state = 23},
  [241] = {.lex_state = 23},
  [242] = {.lex_state = 23},
  [243] = {.lex_state = 14},
  [244] = {.lex_state = 14},
  [245] = {.lex_state = 23},
  [246] = {.lex_state = 23},
  [247] = {.lex_state = 14},
  [248] = {.lex_state = 14},
  [249] = {.lex_state = 14},
  [250] = {.lex_state = 14},
  [251] = {.lex_state = 23},
  [252] = {.lex_state = 14},
  [253] = {.lex_state = 14},
  [254] = {.lex_state = 14},
  [255] = {.lex_state = 23},
  [256] = {.lex_state = 14},
  [257] = {.lex_state = 14},
  [258] = {.lex_state = 14},
  [259] = {.lex_state = 23},
  [260] = {.lex_state = 23},
  [261] = {.lex_state = 23},
  [262] = {.lex_state = 31},
  [263] = {.lex_state = 23},
  [264] = {.lex_state = 23},
  [265] = {.lex_state = 23},
  [266] = {.lex_state = 31},
  [267] = {.lex_state = 23},
  [268] = {.lex_state = 23},
  [269] = {.lex_state = 31},
  [270] = {.lex_state = 31},
  [271] = {.lex_state = 31},
  [272] = {.lex_state = 23},
  [273] = {.lex_state = 23},
  [274] = {.lex_state = 23},
  [275] = {.lex_state = 23},
  [276] = {.lex_state = 23},
  [277] = {.lex_state = 23},
  [278] = {.lex_state = 23},
  [279] = {.lex_state = 23},
  [280] = {.lex_state = 23},
  [281] = {.lex_state = 23},
  [282] = {.lex_state = 23},
  [283] = {.lex_state = 23},
  [284] = {.lex_state = 23},
  [285] = {.lex_state = 23},
  [286] = {.lex_state = 23},
  [287] = {.lex_state = 23},
  [288] = {.lex_state = 23},
  [289] = {.lex_state = 23},
  [290] = {.lex_state = 23},
  [291] = {.lex_state = 23},
  [292] = {.lex_state = 23},
  [293] = {.lex_state = 23},
  [294] = {.lex_state = 23},
  [295] = {.lex_state = 23},
  [296] = {.lex_state = 23},
  [297] = {.lex_state = 23},
  [298] = {.lex_state = 23},
  [299] = {.lex_state = 23},
  [300] = {.lex_state = 23},
  [301] = {.lex_state = 23},
  [302] = {.lex_state = 23},
  [303] = {.lex_state = 23},
  [304] = {.lex_state = 23},
  [305] = {.lex_state = 23},
  [306] = {.lex_state = 23},
  [307] = {.lex_state = 23},
  [308] = {.lex_state = 23},
  [309] = {.lex_state = 23},
  [310] = {.lex_state = 23},
  [311] = {.lex_state = 23},
  [312] = {.lex_state = 23},
  [313] = {.lex_state = 14},
  [314] = {.lex_state = 14},
  [315] = {.lex_state = 32},
  [316] = {.lex_state = 32},
  [317] = {.lex_state = 32},
  [318] = {.lex_state = 32},
  [319] = {.lex_state = 32},
  [320] = {.lex_state = 32},
  [321] = {.lex_state = 7},
  [322] = {.lex_state = 7},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 9},
  [326] = {.lex_state = 5},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 9},
  [330] = {.lex_state = 8},
  [331] = {.lex_state = 8},
  [332] = {.lex_state = 9},
  [333] = {.lex_state = 9},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 7},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 8},
  [339] = {.lex_state = 8},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 8},
  [344] = {.lex_state = 7},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 7},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 7},
  [350] = {.lex_state = 7},
  [351] = {.lex_state = 7},
  [352] = {.lex_state = 7},
  [353] = {.lex_state = 7},
  [354] = {.lex_state = 7},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 124},
  [366] = {.lex_state = 6},
  [367] = {.lex_state = 6},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 7},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 124},
  [387] = {.lex_state = 124},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 7},
  [390] = {.lex_state = 7},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 124},
  [394] = {.lex_state = 124},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 124},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 124},
  [404] = {.lex_state = 124},
  [405] = {.lex_state = 124},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 124},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 5},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 124},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 124},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 7},
  [420] = {.lex_state = 124},
  [421] = {.lex_state = 124},
  [422] = {.lex_state = 124},
  [423] = {.lex_state = 124},
  [424] = {.lex_state = 124},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 124},
  [427] = {.lex_state = 124},
  [428] = {.lex_state = 9},
  [429] = {.lex_state = 124},
  [430] = {.lex_state = 124},
  [431] = {.lex_state = 124},
  [432] = {.lex_state = 124},
  [433] = {.lex_state = 124},
  [434] = {.lex_state = 5},
  [435] = {.lex_state = 5},
  [436] = {.lex_state = 124},
  [437] = {.lex_state = 5},
  [438] = {.lex_state = 124},
  [439] = {.lex_state = 124},
  [440] = {.lex_state = 5},
  [441] = {.lex_state = 5},
  [442] = {.lex_state = 124},
  [443] = {.lex_state = 124},
  [444] = {.lex_state = 5},
  [445] = {.lex_state = 5},
  [446] = {.lex_state = 5},
  [447] = {.lex_state = 124},
  [448] = {.lex_state = 5},
  [449] = {.lex_state = 124},
  [450] = {.lex_state = 5},
  [451] = {.lex_state = 5},
  [452] = {.lex_state = 124},
  [453] = {.lex_state = 124},
  [454] = {.lex_state = 124},
  [455] = {.lex_state = 5},
  [456] = {.lex_state = 124},
  [457] = {.lex_state = 124},
  [458] = {.lex_state = 124},
  [459] = {.lex_state = 5},
  [460] = {.lex_state = 124},
  [461] = {.lex_state = 124},
  [462] = {.lex_state = 124},
  [463] = {.lex_state = 5},
  [464] = {.lex_state = 124},
  [465] = {.lex_state = 124},
  [466] = {.lex_state = 124},
  [467] = {.lex_state = 9},
  [468] = {.lex_state = 5},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 5},
  [471] = {.lex_state = 5},
  [472] = {.lex_state = 5},
  [473] = {.lex_state = 124},
  [474] = {.lex_state = 5},
  [475] = {.lex_state = 124},
  [476] = {.lex_state = 5},
  [477] = {.lex_state = 5},
  [478] = {.lex_state = 5},
  [479] = {.lex_state = 5},
  [480] = {.lex_state = 5},
  [481] = {.lex_state = 7},
  [482] = {.lex_state = 8},
  [483] = {.lex_state = 8},
  [484] = {.lex_state = 5},
  [485] = {.lex_state = 5},
  [486] = {.lex_state = 5},
  [487] = {.lex_state = 5},
  [488] = {.lex_state = 7},
  [489] = {.lex_state = 7},
  [490] = {.lex_state = 7},
  [491] = {.lex_state = 7},
  [492] = {.lex_state = 7},
  [493] = {.lex_state = 7},
  [494] = {.lex_state = 7},
  [495] = {.lex_state = 5},
  [496] = {.lex_state = 7},
  [497] = {.lex_state = 7},
  [498] = {.lex_state = 5},
  [499] = {.lex_state = 7},
  [500] = {.lex_state = 5},
  [501] = {.lex_state = 7},
  [502] = {.lex_state = 7},
  [503] = {.lex_state = 7},
  [504] = {.lex_state = 7},
  [505] = {.lex_state = 5},
  [506] = {.lex_state = 7},
  [507] = {.lex_state = 5},
  [508] = {.lex_state = 5},
  [509] = {.lex_state = 5},
  [510] = {.lex_state = 5},
  [511] = {.lex_state = 5},
  [512] = {.lex_state = 7},
  [513] = {.lex_state = 124},
  [514] = {.lex_state = 7},
  [515] = {.lex_state = 7},
  [516] = {.lex_state = 124},
  [517] = {.lex_state = 7},
  [518] = {.lex_state = 7},
  [519] = {.lex_state = 124},
  [520] = {.lex_state = 7},
  [521] = {.lex_state = 7},
  [522] = {.lex_state = 124},
  [523] = {.lex_state = 7},
  [524] = {.lex_state = 7},
  [525] = {.lex_state = 7},
  [526] = {.lex_state = 124},
  [527] = {.lex_state = 7},
  [528] = {.lex_state = 7},
  [529] = {.lex_state = 7},
  [530] = {.lex_state = 13},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 124},
  [533] = {.lex_state = 124},
  [534] = {.lex_state = 7},
  [535] = {.lex_state = 7},
  [536] = {.lex_state = 7},
  [537] = {.lex_state = 7},
  [538] = {.lex_state = 7},
  [539] = {.lex_state = 7},
  [540] = {.lex_state = 7},
  [541] = {.lex_state = 7},
  [542] = {.lex_state = 7},
  [543] = {.lex_state = 7},
  [544] = {.lex_state = 7},
  [545] = {.lex_state = 7},
  [546] = {.lex_state = 13},
  [547] = {.lex_state = 17},
  [548] = {.lex_state = 21},
  [549] = {.lex_state = 21},
  [550] = {.lex_state = 7},
  [551] = {.lex_state = 7},
  [552] = {.lex_state = 13},
  [553] = {.lex_state = 15},
  [554] = {.lex_state = 17},
  [555] = {.lex_state = 13},
  [556] = {.lex_state = 21},
  [557] = {.lex_state = 7},
  [558] = {.lex_state = 17},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 3},
  [564] = {.lex_state = 7},
  [565] = {.lex_state = 3},
  [566] = {.lex_state = 15},
  [567] = {.lex_state = 124},
  [568] = {.lex_state = 1},
  [569] = {.lex_state = 7},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 7},
  [573] = {.lex_state = 3},
  [574] = {.lex_state = 15},
  [575] = {.lex_state = 15},
  [576] = {.lex_state = 124},
  [577] = {.lex_state = 3},
  [578] = {.lex_state = 15},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 13},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 7},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 13},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 7},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 7},
  [591] = {.lex_state = 3},
  [592] = {.lex_state = 15},
  [593] = {.lex_state = 7},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 7},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 7},
  [599] = {.lex_state = 7},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 7},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 7},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 29},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 7},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 29},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 9},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 9},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 29},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 13},
  [665] = {.lex_state = 7},
  [666] = {.lex_state = 7},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 24},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 29},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 24},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 7},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 24},
  [683] = {.lex_state = 7},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 24},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 7},
  [689] = {.lex_state = 24},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 7},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 13},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 7},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 7},
  [705] = {.lex_state = 7},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 7},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 7},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 7},
  [718] = {.lex_state = 7},
  [719] = {.lex_state = 7},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 7},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 7},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 7},
  [728] = {.lex_state = 7},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 15},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 124},
  [733] = {.lex_state = 7},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 15},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 7},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 7},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 7},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 7},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 124},
  [751] = {.lex_state = 7},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 7},
  [754] = {.lex_state = 24},
  [755] = {.lex_state = 124},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 7},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 7},
  [763] = {.lex_state = 7},
  [764] = {.lex_state = 7},
  [765] = {.lex_state = 124},
  [766] = {.lex_state = 7},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 7},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 24},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 7},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 13},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 7},
  [778] = {.lex_state = 24},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 13},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 13},
  [783] = {.lex_state = 7},
  [784] = {.lex_state = 13},
  [785] = {.lex_state = 7},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 7},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 24},
  [795] = {.lex_state = 7},
  [796] = {.lex_state = 24},
  [797] = {.lex_state = 24},
  [798] = {.lex_state = 7},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 24},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 7},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 124},
  [809] = {.lex_state = 7},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 7},
  [813] = {.lex_state = 15},
  [814] = {.lex_state = 7},
  [815] = {.lex_state = 12},
  [816] = {.lex_state = 7},
  [817] = {.lex_state = 24},
  [818] = {.lex_state = 7},
  [819] = {.lex_state = 7},
  [820] = {.lex_state = 7},
  [821] = {.lex_state = 7},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 7},
  [824] = {.lex_state = 7},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 15},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 124},
  [829] = {.lex_state = 7},
  [830] = {.lex_state = 7},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 7},
  [833] = {.lex_state = 124},
  [834] = {.lex_state = 7},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 124},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 24},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 7},
  [842] = {.lex_state = 7},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 24},
  [845] = {.lex_state = 7},
  [846] = {.lex_state = 7},
  [847] = {.lex_state = 124},
  [848] = {.lex_state = 124},
  [849] = {.lex_state = 7},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 124},
  [856] = {.lex_state = 24},
  [857] = {.lex_state = 7},
  [858] = {.lex_state = 7},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 124},
  [862] = {.lex_state = 24},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 7},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 24},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 24},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 7},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 124},
  [881] = {.lex_state = 7},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 12},
  [884] = {.lex_state = 124},
  [885] = {.lex_state = 9},
  [886] = {.lex_state = 7},
  [887] = {.lex_state = 24},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 7},
  [890] = {.lex_state = 7},
  [891] = {.lex_state = 7},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 24},
  [894] = {.lex_state = 7},
  [895] = {.lex_state = 7},
  [896] = {.lex_state = 7},
  [897] = {.lex_state = 7},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 7},
  [900] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [anon_sym_solidity] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_library] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_anonymous] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_indexed] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_assembly] = ACTIONS(1),
    [sym_yul_leave] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_yul_decimal_number] = ACTIONS(1),
    [sym_yul_hex_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_stop] = ACTIONS(1),
    [anon_sym_add] = ACTIONS(1),
    [anon_sym_sub] = ACTIONS(1),
    [anon_sym_mul] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_sdiv] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_smod] = ACTIONS(1),
    [anon_sym_exp] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_lt] = ACTIONS(1),
    [anon_sym_gt] = ACTIONS(1),
    [anon_sym_slt] = ACTIONS(1),
    [anon_sym_sgt] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_shl] = ACTIONS(1),
    [anon_sym_shr] = ACTIONS(1),
    [anon_sym_sar] = ACTIONS(1),
    [anon_sym_addmod] = ACTIONS(1),
    [anon_sym_mulmod] = ACTIONS(1),
    [anon_sym_signextend] = ACTIONS(1),
    [anon_sym_keccak256] = ACTIONS(1),
    [anon_sym_pop] = ACTIONS(1),
    [anon_sym_mload] = ACTIONS(1),
    [anon_sym_mstore] = ACTIONS(1),
    [anon_sym_mstore8] = ACTIONS(1),
    [anon_sym_sload] = ACTIONS(1),
    [anon_sym_sstore] = ACTIONS(1),
    [anon_sym_msize] = ACTIONS(1),
    [anon_sym_gas] = ACTIONS(1),
    [anon_sym_address] = ACTIONS(1),
    [anon_sym_balance] = ACTIONS(1),
    [anon_sym_selfbalance] = ACTIONS(1),
    [anon_sym_caller] = ACTIONS(1),
    [anon_sym_callvalue] = ACTIONS(1),
    [anon_sym_extcodesize] = ACTIONS(1),
    [anon_sym_extcodecopy] = ACTIONS(1),
    [anon_sym_returndatasize] = ACTIONS(1),
    [anon_sym_returndatacopy] = ACTIONS(1),
    [anon_sym_extcodehash] = ACTIONS(1),
    [anon_sym_create] = ACTIONS(1),
    [anon_sym_create2] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [anon_sym_callcode] = ACTIONS(1),
    [anon_sym_delegatecall] = ACTIONS(1),
    [anon_sym_staticcall] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_revert] = ACTIONS(1),
    [anon_sym_selfdestruct] = ACTIONS(1),
    [anon_sym_invalid] = ACTIONS(1),
    [anon_sym_log0] = ACTIONS(1),
    [anon_sym_log1] = ACTIONS(1),
    [anon_sym_log2] = ACTIONS(1),
    [anon_sym_log3] = ACTIONS(1),
    [anon_sym_log4] = ACTIONS(1),
    [anon_sym_chainid] = ACTIONS(1),
    [anon_sym_origin] = ACTIONS(1),
    [anon_sym_gasprice] = ACTIONS(1),
    [anon_sym_blockhash] = ACTIONS(1),
    [anon_sym_coinbase] = ACTIONS(1),
    [anon_sym_timestamp] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_difficulty] = ACTIONS(1),
    [anon_sym_gaslimit] = ACTIONS(1),
    [anon_sym_memory] = ACTIONS(1),
    [anon_sym_storage] = ACTIONS(1),
    [anon_sym_calldata] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_emit] = ACTIONS(1),
    [sym_constant] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_internal] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_view] = ACTIONS(1),
    [anon_sym_payable] = ACTIONS(1),
    [sym_immutable] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_modifier] = ACTIONS(1),
    [anon_sym_constructor] = ACTIONS(1),
    [anon_sym_fallback] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [sym_virtual] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_mapping] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_int8] = ACTIONS(1),
    [anon_sym_int16] = ACTIONS(1),
    [anon_sym_int24] = ACTIONS(1),
    [anon_sym_int32] = ACTIONS(1),
    [anon_sym_int40] = ACTIONS(1),
    [anon_sym_int48] = ACTIONS(1),
    [anon_sym_int56] = ACTIONS(1),
    [anon_sym_int64] = ACTIONS(1),
    [anon_sym_int72] = ACTIONS(1),
    [anon_sym_int80] = ACTIONS(1),
    [anon_sym_int88] = ACTIONS(1),
    [anon_sym_int96] = ACTIONS(1),
    [anon_sym_int104] = ACTIONS(1),
    [anon_sym_int112] = ACTIONS(1),
    [anon_sym_int120] = ACTIONS(1),
    [anon_sym_int128] = ACTIONS(1),
    [anon_sym_int136] = ACTIONS(1),
    [anon_sym_int144] = ACTIONS(1),
    [anon_sym_int152] = ACTIONS(1),
    [anon_sym_int160] = ACTIONS(1),
    [anon_sym_int168] = ACTIONS(1),
    [anon_sym_int176] = ACTIONS(1),
    [anon_sym_int184] = ACTIONS(1),
    [anon_sym_int192] = ACTIONS(1),
    [anon_sym_int200] = ACTIONS(1),
    [anon_sym_int208] = ACTIONS(1),
    [anon_sym_int216] = ACTIONS(1),
    [anon_sym_int224] = ACTIONS(1),
    [anon_sym_int232] = ACTIONS(1),
    [anon_sym_int240] = ACTIONS(1),
    [anon_sym_int248] = ACTIONS(1),
    [anon_sym_int256] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_uint8] = ACTIONS(1),
    [anon_sym_uint16] = ACTIONS(1),
    [anon_sym_uint24] = ACTIONS(1),
    [anon_sym_uint32] = ACTIONS(1),
    [anon_sym_uint40] = ACTIONS(1),
    [anon_sym_uint48] = ACTIONS(1),
    [anon_sym_uint56] = ACTIONS(1),
    [anon_sym_uint64] = ACTIONS(1),
    [anon_sym_uint72] = ACTIONS(1),
    [anon_sym_uint80] = ACTIONS(1),
    [anon_sym_uint88] = ACTIONS(1),
    [anon_sym_uint96] = ACTIONS(1),
    [anon_sym_uint104] = ACTIONS(1),
    [anon_sym_uint112] = ACTIONS(1),
    [anon_sym_uint120] = ACTIONS(1),
    [anon_sym_uint128] = ACTIONS(1),
    [anon_sym_uint136] = ACTIONS(1),
    [anon_sym_uint144] = ACTIONS(1),
    [anon_sym_uint152] = ACTIONS(1),
    [anon_sym_uint160] = ACTIONS(1),
    [anon_sym_uint168] = ACTIONS(1),
    [anon_sym_uint176] = ACTIONS(1),
    [anon_sym_uint184] = ACTIONS(1),
    [anon_sym_uint192] = ACTIONS(1),
    [anon_sym_uint200] = ACTIONS(1),
    [anon_sym_uint208] = ACTIONS(1),
    [anon_sym_uint216] = ACTIONS(1),
    [anon_sym_uint224] = ACTIONS(1),
    [anon_sym_uint232] = ACTIONS(1),
    [anon_sym_uint240] = ACTIONS(1),
    [anon_sym_uint248] = ACTIONS(1),
    [anon_sym_uint256] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_bytes1] = ACTIONS(1),
    [anon_sym_bytes2] = ACTIONS(1),
    [anon_sym_bytes3] = ACTIONS(1),
    [anon_sym_bytes4] = ACTIONS(1),
    [anon_sym_bytes5] = ACTIONS(1),
    [anon_sym_bytes6] = ACTIONS(1),
    [anon_sym_bytes7] = ACTIONS(1),
    [anon_sym_bytes8] = ACTIONS(1),
    [anon_sym_bytes9] = ACTIONS(1),
    [anon_sym_bytes10] = ACTIONS(1),
    [anon_sym_bytes11] = ACTIONS(1),
    [anon_sym_bytes12] = ACTIONS(1),
    [anon_sym_bytes13] = ACTIONS(1),
    [anon_sym_bytes14] = ACTIONS(1),
    [anon_sym_bytes15] = ACTIONS(1),
    [anon_sym_bytes16] = ACTIONS(1),
    [anon_sym_bytes17] = ACTIONS(1),
    [anon_sym_bytes18] = ACTIONS(1),
    [anon_sym_bytes19] = ACTIONS(1),
    [anon_sym_bytes20] = ACTIONS(1),
    [anon_sym_bytes21] = ACTIONS(1),
    [anon_sym_bytes22] = ACTIONS(1),
    [anon_sym_bytes23] = ACTIONS(1),
    [anon_sym_bytes24] = ACTIONS(1),
    [anon_sym_bytes25] = ACTIONS(1),
    [anon_sym_bytes26] = ACTIONS(1),
    [anon_sym_bytes27] = ACTIONS(1),
    [anon_sym_bytes28] = ACTIONS(1),
    [anon_sym_bytes29] = ACTIONS(1),
    [anon_sym_bytes30] = ACTIONS(1),
    [anon_sym_bytes31] = ACTIONS(1),
    [anon_sym_bytes32] = ACTIONS(1),
    [anon_sym_fixed] = ACTIONS(1),
    [aux_sym__fixed_token1] = ACTIONS(1),
    [anon_sym_ufixed] = ACTIONS(1),
    [aux_sym__ufixed_token1] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [aux_sym__decimal_number_token2] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_wei] = ACTIONS(1),
    [anon_sym_szabo] = ACTIONS(1),
    [anon_sym_finney] = ACTIONS(1),
    [anon_sym_gwei] = ACTIONS(1),
    [anon_sym_ether] = ACTIONS(1),
    [anon_sym_seconds] = ACTIONS(1),
    [anon_sym_minutes] = ACTIONS(1),
    [anon_sym_hours] = ACTIONS(1),
    [anon_sym_days] = ACTIONS(1),
    [anon_sym_weeks] = ACTIONS(1),
    [anon_sym_years] = ACTIONS(1),
    [anon_sym_hex] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__escape_sequence] = ACTIONS(1),
    [anon_sym_unicode] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(867),
    [sym__source_unit] = STATE(123),
    [sym__directive] = STATE(123),
    [sym_pragma_directive] = STATE(123),
    [sym_import_directive] = STATE(123),
    [sym__declaration] = STATE(123),
    [sym_constant_variable_declaration] = STATE(123),
    [sym_contract_declaration] = STATE(123),
    [sym_interface_declaration] = STATE(123),
    [sym_library_declaration] = STATE(123),
    [sym_struct_declaration] = STATE(123),
    [sym_enum_declaration] = STATE(123),
    [sym_function_definition] = STATE(123),
    [sym_type_name] = STATE(748),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(352),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(352),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [aux_sym_source_file_repeat1] = STATE(123),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_pragma] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_abstract] = ACTIONS(13),
    [anon_sym_contract] = ACTIONS(15),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_library] = ACTIONS(19),
    [anon_sym_struct] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(23),
    [anon_sym_function] = ACTIONS(25),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__statement] = STATE(6),
    [sym_assembly_statement] = STATE(6),
    [sym_block_statement] = STATE(6),
    [sym_variable_declaration_statement] = STATE(6),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_while_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_emit_statement] = STATE(6),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__statement] = STATE(5),
    [sym_assembly_statement] = STATE(5),
    [sym_block_statement] = STATE(5),
    [sym_variable_declaration_statement] = STATE(5),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(5),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_do_while_statement] = STATE(5),
    [sym_continue_statement] = STATE(5),
    [sym_break_statement] = STATE(5),
    [sym_try_statement] = STATE(5),
    [sym_return_statement] = STATE(5),
    [sym_emit_statement] = STATE(5),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(5),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__statement] = STATE(2),
    [sym_assembly_statement] = STATE(2),
    [sym_block_statement] = STATE(2),
    [sym_variable_declaration_statement] = STATE(2),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_do_while_statement] = STATE(2),
    [sym_continue_statement] = STATE(2),
    [sym_break_statement] = STATE(2),
    [sym_try_statement] = STATE(2),
    [sym_return_statement] = STATE(2),
    [sym_emit_statement] = STATE(2),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(2),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__statement] = STATE(6),
    [sym_assembly_statement] = STATE(6),
    [sym_block_statement] = STATE(6),
    [sym_variable_declaration_statement] = STATE(6),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_while_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_emit_statement] = STATE(6),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__statement] = STATE(6),
    [sym_assembly_statement] = STATE(6),
    [sym_block_statement] = STATE(6),
    [sym_variable_declaration_statement] = STATE(6),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_while_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_emit_statement] = STATE(6),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(107),
    [anon_sym_TILDE] = ACTIONS(110),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_RBRACE] = ACTIONS(116),
    [anon_sym_LPAREN] = ACTIONS(118),
    [anon_sym_for] = ACTIONS(121),
    [anon_sym_assembly] = ACTIONS(124),
    [anon_sym_break] = ACTIONS(127),
    [anon_sym_continue] = ACTIONS(130),
    [anon_sym_true] = ACTIONS(133),
    [anon_sym_false] = ACTIONS(136),
    [anon_sym_if] = ACTIONS(139),
    [anon_sym_function] = ACTIONS(142),
    [anon_sym_byte] = ACTIONS(145),
    [anon_sym_address] = ACTIONS(148),
    [anon_sym_return] = ACTIONS(151),
    [anon_sym_var] = ACTIONS(154),
    [anon_sym_while] = ACTIONS(157),
    [anon_sym_do] = ACTIONS(160),
    [anon_sym_try] = ACTIONS(163),
    [anon_sym_emit] = ACTIONS(166),
    [anon_sym_payable] = ACTIONS(169),
    [anon_sym_new] = ACTIONS(172),
    [anon_sym_LBRACK] = ACTIONS(175),
    [anon_sym_PLUS] = ACTIONS(178),
    [anon_sym_DASH] = ACTIONS(178),
    [anon_sym_BANG] = ACTIONS(110),
    [anon_sym_delete] = ACTIONS(181),
    [anon_sym_PLUS_PLUS] = ACTIONS(184),
    [anon_sym_DASH_DASH] = ACTIONS(184),
    [anon_sym_type] = ACTIONS(187),
    [anon_sym_mapping] = ACTIONS(190),
    [anon_sym_bool] = ACTIONS(145),
    [anon_sym_string] = ACTIONS(145),
    [anon_sym_int] = ACTIONS(145),
    [anon_sym_int8] = ACTIONS(145),
    [anon_sym_int16] = ACTIONS(145),
    [anon_sym_int24] = ACTIONS(145),
    [anon_sym_int32] = ACTIONS(145),
    [anon_sym_int40] = ACTIONS(145),
    [anon_sym_int48] = ACTIONS(145),
    [anon_sym_int56] = ACTIONS(145),
    [anon_sym_int64] = ACTIONS(145),
    [anon_sym_int72] = ACTIONS(145),
    [anon_sym_int80] = ACTIONS(145),
    [anon_sym_int88] = ACTIONS(145),
    [anon_sym_int96] = ACTIONS(145),
    [anon_sym_int104] = ACTIONS(145),
    [anon_sym_int112] = ACTIONS(145),
    [anon_sym_int120] = ACTIONS(145),
    [anon_sym_int128] = ACTIONS(145),
    [anon_sym_int136] = ACTIONS(145),
    [anon_sym_int144] = ACTIONS(145),
    [anon_sym_int152] = ACTIONS(145),
    [anon_sym_int160] = ACTIONS(145),
    [anon_sym_int168] = ACTIONS(145),
    [anon_sym_int176] = ACTIONS(145),
    [anon_sym_int184] = ACTIONS(145),
    [anon_sym_int192] = ACTIONS(145),
    [anon_sym_int200] = ACTIONS(145),
    [anon_sym_int208] = ACTIONS(145),
    [anon_sym_int216] = ACTIONS(145),
    [anon_sym_int224] = ACTIONS(145),
    [anon_sym_int232] = ACTIONS(145),
    [anon_sym_int240] = ACTIONS(145),
    [anon_sym_int248] = ACTIONS(145),
    [anon_sym_int256] = ACTIONS(145),
    [anon_sym_uint] = ACTIONS(145),
    [anon_sym_uint8] = ACTIONS(145),
    [anon_sym_uint16] = ACTIONS(145),
    [anon_sym_uint24] = ACTIONS(145),
    [anon_sym_uint32] = ACTIONS(145),
    [anon_sym_uint40] = ACTIONS(145),
    [anon_sym_uint48] = ACTIONS(145),
    [anon_sym_uint56] = ACTIONS(145),
    [anon_sym_uint64] = ACTIONS(145),
    [anon_sym_uint72] = ACTIONS(145),
    [anon_sym_uint80] = ACTIONS(145),
    [anon_sym_uint88] = ACTIONS(145),
    [anon_sym_uint96] = ACTIONS(145),
    [anon_sym_uint104] = ACTIONS(145),
    [anon_sym_uint112] = ACTIONS(145),
    [anon_sym_uint120] = ACTIONS(145),
    [anon_sym_uint128] = ACTIONS(145),
    [anon_sym_uint136] = ACTIONS(145),
    [anon_sym_uint144] = ACTIONS(145),
    [anon_sym_uint152] = ACTIONS(145),
    [anon_sym_uint160] = ACTIONS(145),
    [anon_sym_uint168] = ACTIONS(145),
    [anon_sym_uint176] = ACTIONS(145),
    [anon_sym_uint184] = ACTIONS(145),
    [anon_sym_uint192] = ACTIONS(145),
    [anon_sym_uint200] = ACTIONS(145),
    [anon_sym_uint208] = ACTIONS(145),
    [anon_sym_uint216] = ACTIONS(145),
    [anon_sym_uint224] = ACTIONS(145),
    [anon_sym_uint232] = ACTIONS(145),
    [anon_sym_uint240] = ACTIONS(145),
    [anon_sym_uint248] = ACTIONS(145),
    [anon_sym_uint256] = ACTIONS(145),
    [anon_sym_bytes] = ACTIONS(145),
    [anon_sym_bytes1] = ACTIONS(145),
    [anon_sym_bytes2] = ACTIONS(145),
    [anon_sym_bytes3] = ACTIONS(145),
    [anon_sym_bytes4] = ACTIONS(145),
    [anon_sym_bytes5] = ACTIONS(145),
    [anon_sym_bytes6] = ACTIONS(145),
    [anon_sym_bytes7] = ACTIONS(145),
    [anon_sym_bytes8] = ACTIONS(145),
    [anon_sym_bytes9] = ACTIONS(145),
    [anon_sym_bytes10] = ACTIONS(145),
    [anon_sym_bytes11] = ACTIONS(145),
    [anon_sym_bytes12] = ACTIONS(145),
    [anon_sym_bytes13] = ACTIONS(145),
    [anon_sym_bytes14] = ACTIONS(145),
    [anon_sym_bytes15] = ACTIONS(145),
    [anon_sym_bytes16] = ACTIONS(145),
    [anon_sym_bytes17] = ACTIONS(145),
    [anon_sym_bytes18] = ACTIONS(145),
    [anon_sym_bytes19] = ACTIONS(145),
    [anon_sym_bytes20] = ACTIONS(145),
    [anon_sym_bytes21] = ACTIONS(145),
    [anon_sym_bytes22] = ACTIONS(145),
    [anon_sym_bytes23] = ACTIONS(145),
    [anon_sym_bytes24] = ACTIONS(145),
    [anon_sym_bytes25] = ACTIONS(145),
    [anon_sym_bytes26] = ACTIONS(145),
    [anon_sym_bytes27] = ACTIONS(145),
    [anon_sym_bytes28] = ACTIONS(145),
    [anon_sym_bytes29] = ACTIONS(145),
    [anon_sym_bytes30] = ACTIONS(145),
    [anon_sym_bytes31] = ACTIONS(145),
    [anon_sym_bytes32] = ACTIONS(145),
    [anon_sym_fixed] = ACTIONS(145),
    [aux_sym__fixed_token1] = ACTIONS(145),
    [anon_sym_ufixed] = ACTIONS(145),
    [aux_sym__ufixed_token1] = ACTIONS(145),
    [aux_sym__decimal_number_token1] = ACTIONS(193),
    [aux_sym__decimal_number_token2] = ACTIONS(196),
    [aux_sym__hex_number_token1] = ACTIONS(199),
    [anon_sym_hex] = ACTIONS(202),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(208),
    [anon_sym_unicode] = ACTIONS(211),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__statement] = STATE(6),
    [sym_assembly_statement] = STATE(6),
    [sym_block_statement] = STATE(6),
    [sym_variable_declaration_statement] = STATE(6),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_while_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_emit_statement] = STATE(6),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__statement] = STATE(7),
    [sym_assembly_statement] = STATE(7),
    [sym_block_statement] = STATE(7),
    [sym_variable_declaration_statement] = STATE(7),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_while_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_emit_statement] = STATE(7),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__statement] = STATE(2),
    [sym_assembly_statement] = STATE(2),
    [sym_block_statement] = STATE(2),
    [sym_variable_declaration_statement] = STATE(2),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_do_while_statement] = STATE(2),
    [sym_continue_statement] = STATE(2),
    [sym_break_statement] = STATE(2),
    [sym_try_statement] = STATE(2),
    [sym_return_statement] = STATE(2),
    [sym_emit_statement] = STATE(2),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_block_statement_repeat1] = STATE(2),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__statement] = STATE(117),
    [sym_assembly_statement] = STATE(117),
    [sym_block_statement] = STATE(117),
    [sym_variable_declaration_statement] = STATE(117),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(117),
    [sym_if_statement] = STATE(117),
    [sym_for_statement] = STATE(117),
    [sym_while_statement] = STATE(117),
    [sym_do_while_statement] = STATE(117),
    [sym_continue_statement] = STATE(117),
    [sym_break_statement] = STATE(117),
    [sym_try_statement] = STATE(117),
    [sym_return_statement] = STATE(117),
    [sym_emit_statement] = STATE(117),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__statement] = STATE(824),
    [sym_assembly_statement] = STATE(824),
    [sym_block_statement] = STATE(824),
    [sym_variable_declaration_statement] = STATE(824),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(824),
    [sym_if_statement] = STATE(824),
    [sym_for_statement] = STATE(824),
    [sym_while_statement] = STATE(824),
    [sym_do_while_statement] = STATE(824),
    [sym_continue_statement] = STATE(824),
    [sym_break_statement] = STATE(824),
    [sym_try_statement] = STATE(824),
    [sym_return_statement] = STATE(824),
    [sym_emit_statement] = STATE(824),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__statement] = STATE(121),
    [sym_assembly_statement] = STATE(121),
    [sym_block_statement] = STATE(121),
    [sym_variable_declaration_statement] = STATE(121),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(121),
    [sym_if_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_do_while_statement] = STATE(121),
    [sym_continue_statement] = STATE(121),
    [sym_break_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_return_statement] = STATE(121),
    [sym_emit_statement] = STATE(121),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(222),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(224),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__statement] = STATE(104),
    [sym_assembly_statement] = STATE(104),
    [sym_block_statement] = STATE(104),
    [sym_variable_declaration_statement] = STATE(104),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(104),
    [sym_if_statement] = STATE(104),
    [sym_for_statement] = STATE(104),
    [sym_while_statement] = STATE(104),
    [sym_do_while_statement] = STATE(104),
    [sym_continue_statement] = STATE(104),
    [sym_break_statement] = STATE(104),
    [sym_try_statement] = STATE(104),
    [sym_return_statement] = STATE(104),
    [sym_emit_statement] = STATE(104),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(222),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(224),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__statement] = STATE(117),
    [sym_assembly_statement] = STATE(117),
    [sym_block_statement] = STATE(117),
    [sym_variable_declaration_statement] = STATE(117),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(117),
    [sym_if_statement] = STATE(117),
    [sym_for_statement] = STATE(117),
    [sym_while_statement] = STATE(117),
    [sym_do_while_statement] = STATE(117),
    [sym_continue_statement] = STATE(117),
    [sym_break_statement] = STATE(117),
    [sym_try_statement] = STATE(117),
    [sym_return_statement] = STATE(117),
    [sym_emit_statement] = STATE(117),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(222),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(224),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__statement] = STATE(107),
    [sym_assembly_statement] = STATE(107),
    [sym_block_statement] = STATE(107),
    [sym_variable_declaration_statement] = STATE(107),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_do_while_statement] = STATE(107),
    [sym_continue_statement] = STATE(107),
    [sym_break_statement] = STATE(107),
    [sym_try_statement] = STATE(107),
    [sym_return_statement] = STATE(107),
    [sym_emit_statement] = STATE(107),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(222),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(224),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__statement] = STATE(105),
    [sym_assembly_statement] = STATE(105),
    [sym_block_statement] = STATE(105),
    [sym_variable_declaration_statement] = STATE(105),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_do_while_statement] = STATE(105),
    [sym_continue_statement] = STATE(105),
    [sym_break_statement] = STATE(105),
    [sym_try_statement] = STATE(105),
    [sym_return_statement] = STATE(105),
    [sym_emit_statement] = STATE(105),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(220),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(222),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(224),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__statement] = STATE(112),
    [sym_assembly_statement] = STATE(112),
    [sym_block_statement] = STATE(112),
    [sym_variable_declaration_statement] = STATE(112),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(112),
    [sym_if_statement] = STATE(112),
    [sym_for_statement] = STATE(112),
    [sym_while_statement] = STATE(112),
    [sym_do_while_statement] = STATE(112),
    [sym_continue_statement] = STATE(112),
    [sym_break_statement] = STATE(112),
    [sym_try_statement] = STATE(112),
    [sym_return_statement] = STATE(112),
    [sym_emit_statement] = STATE(112),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__statement] = STATE(121),
    [sym_assembly_statement] = STATE(121),
    [sym_block_statement] = STATE(121),
    [sym_variable_declaration_statement] = STATE(121),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(121),
    [sym_if_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_do_while_statement] = STATE(121),
    [sym_continue_statement] = STATE(121),
    [sym_break_statement] = STATE(121),
    [sym_try_statement] = STATE(121),
    [sym_return_statement] = STATE(121),
    [sym_emit_statement] = STATE(121),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__statement] = STATE(107),
    [sym_assembly_statement] = STATE(107),
    [sym_block_statement] = STATE(107),
    [sym_variable_declaration_statement] = STATE(107),
    [sym_variable_declaration] = STATE(755),
    [sym_variable_declaration_tuple] = STATE(847),
    [sym_expression_statement] = STATE(107),
    [sym_if_statement] = STATE(107),
    [sym_for_statement] = STATE(107),
    [sym_while_statement] = STATE(107),
    [sym_do_while_statement] = STATE(107),
    [sym_continue_statement] = STATE(107),
    [sym_break_statement] = STATE(107),
    [sym_try_statement] = STATE(107),
    [sym_return_statement] = STATE(107),
    [sym_emit_statement] = STATE(107),
    [sym__expression] = STATE(462),
    [sym__primary_expression] = STATE(462),
    [sym_type_cast_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_new_expression] = STATE(462),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(462),
    [sym_struct_expression] = STATE(462),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_call_expression] = STATE(462),
    [sym_payable_conversion_expression] = STATE(462),
    [sym_meta_type_expression] = STATE(462),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(462),
    [sym_string_literal] = STATE(462),
    [sym_number_literal] = STATE(462),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(462),
    [sym_hex_string_literal] = STATE(462),
    [sym_unicode_string_literal] = STATE(462),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_for] = ACTIONS(43),
    [anon_sym_assembly] = ACTIONS(45),
    [anon_sym_break] = ACTIONS(47),
    [anon_sym_continue] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_if] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_while] = ACTIONS(63),
    [anon_sym_do] = ACTIONS(65),
    [anon_sym_try] = ACTIONS(67),
    [anon_sym_emit] = ACTIONS(69),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_variable_declaration_statement] = STATE(26),
    [sym_variable_declaration] = STATE(808),
    [sym_variable_declaration_tuple] = STATE(884),
    [sym_expression_statement] = STATE(26),
    [sym__expression] = STATE(432),
    [sym__primary_expression] = STATE(432),
    [sym_type_cast_expression] = STATE(432),
    [sym_ternary_expression] = STATE(432),
    [sym_new_expression] = STATE(432),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(432),
    [sym_binary_expression] = STATE(432),
    [sym_unary_expression] = STATE(432),
    [sym_update_expression] = STATE(432),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(432),
    [sym_struct_expression] = STATE(432),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(432),
    [sym_augmented_assignment_expression] = STATE(432),
    [sym_call_expression] = STATE(432),
    [sym_payable_conversion_expression] = STATE(432),
    [sym_meta_type_expression] = STATE(432),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(432),
    [sym_string_literal] = STATE(432),
    [sym_number_literal] = STATE(432),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(432),
    [sym_hex_string_literal] = STATE(432),
    [sym_unicode_string_literal] = STATE(432),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym__semicolon] = ACTIONS(226),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_variable_declaration_statement] = STATE(29),
    [sym_variable_declaration] = STATE(808),
    [sym_variable_declaration_tuple] = STATE(884),
    [sym_expression_statement] = STATE(29),
    [sym__expression] = STATE(432),
    [sym__primary_expression] = STATE(432),
    [sym_type_cast_expression] = STATE(432),
    [sym_ternary_expression] = STATE(432),
    [sym_new_expression] = STATE(432),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(432),
    [sym_binary_expression] = STATE(432),
    [sym_unary_expression] = STATE(432),
    [sym_update_expression] = STATE(432),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(432),
    [sym_struct_expression] = STATE(432),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(432),
    [sym_augmented_assignment_expression] = STATE(432),
    [sym_call_expression] = STATE(432),
    [sym_payable_conversion_expression] = STATE(432),
    [sym_meta_type_expression] = STATE(432),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(432),
    [sym_string_literal] = STATE(432),
    [sym_number_literal] = STATE(432),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(432),
    [sym_hex_string_literal] = STATE(432),
    [sym_unicode_string_literal] = STATE(432),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(61),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym__semicolon] = ACTIONS(228),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_variable_declaration] = STATE(632),
    [sym__expression] = STATE(424),
    [sym__primary_expression] = STATE(424),
    [sym_type_cast_expression] = STATE(424),
    [sym_ternary_expression] = STATE(424),
    [sym_new_expression] = STATE(424),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(424),
    [sym_struct_expression] = STATE(424),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(424),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym_call_expression] = STATE(424),
    [sym_payable_conversion_expression] = STATE(424),
    [sym_meta_type_expression] = STATE(424),
    [sym_type_name] = STATE(550),
    [sym__array_type] = STATE(352),
    [sym__function_type] = STATE(352),
    [sym__user_defined_type] = STATE(390),
    [sym__mapping] = STATE(352),
    [sym_primitive_type] = STATE(389),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(424),
    [sym_string_literal] = STATE(424),
    [sym_number_literal] = STATE(424),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(424),
    [sym_hex_string_literal] = STATE(424),
    [sym_unicode_string_literal] = STATE(424),
    [sym_string] = STATE(370),
    [aux_sym_tuple_expression_repeat1] = STATE(659),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(234),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_mapping] = ACTIONS(31),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__expression] = STATE(424),
    [sym__primary_expression] = STATE(424),
    [sym_type_cast_expression] = STATE(424),
    [sym_ternary_expression] = STATE(424),
    [sym_new_expression] = STATE(424),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(424),
    [sym_struct_expression] = STATE(424),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(424),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym_call_expression] = STATE(424),
    [sym_payable_conversion_expression] = STATE(424),
    [sym_meta_type_expression] = STATE(424),
    [sym__user_defined_type] = STATE(424),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(424),
    [sym_string_literal] = STATE(424),
    [sym_number_literal] = STATE(424),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(424),
    [sym_hex_string_literal] = STATE(424),
    [sym_unicode_string_literal] = STATE(424),
    [sym_string] = STATE(370),
    [aux_sym_tuple_expression_repeat1] = STATE(659),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(230),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(236),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__expression] = STATE(420),
    [sym__primary_expression] = STATE(420),
    [sym_type_cast_expression] = STATE(420),
    [sym_ternary_expression] = STATE(420),
    [sym_new_expression] = STATE(420),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_update_expression] = STATE(420),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(420),
    [sym_struct_expression] = STATE(420),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(420),
    [sym_augmented_assignment_expression] = STATE(420),
    [sym_call_expression] = STATE(420),
    [sym_payable_conversion_expression] = STATE(420),
    [sym_meta_type_expression] = STATE(420),
    [sym__user_defined_type] = STATE(420),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(420),
    [sym_string_literal] = STATE(420),
    [sym_number_literal] = STATE(420),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(420),
    [sym_hex_string_literal] = STATE(420),
    [sym_unicode_string_literal] = STATE(420),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(242),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_expression_statement] = STATE(43),
    [sym__expression] = STATE(432),
    [sym__primary_expression] = STATE(432),
    [sym_type_cast_expression] = STATE(432),
    [sym_ternary_expression] = STATE(432),
    [sym_new_expression] = STATE(432),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(432),
    [sym_binary_expression] = STATE(432),
    [sym_unary_expression] = STATE(432),
    [sym_update_expression] = STATE(432),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(432),
    [sym_struct_expression] = STATE(432),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(432),
    [sym_augmented_assignment_expression] = STATE(432),
    [sym_call_expression] = STATE(432),
    [sym_payable_conversion_expression] = STATE(432),
    [sym_meta_type_expression] = STATE(432),
    [sym__user_defined_type] = STATE(432),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(432),
    [sym_string_literal] = STATE(432),
    [sym_number_literal] = STATE(432),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(432),
    [sym_hex_string_literal] = STATE(432),
    [sym_unicode_string_literal] = STATE(432),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym__semicolon] = ACTIONS(246),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_expression_statement] = STATE(48),
    [sym__expression] = STATE(432),
    [sym__primary_expression] = STATE(432),
    [sym_type_cast_expression] = STATE(432),
    [sym_ternary_expression] = STATE(432),
    [sym_new_expression] = STATE(432),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(432),
    [sym_binary_expression] = STATE(432),
    [sym_unary_expression] = STATE(432),
    [sym_update_expression] = STATE(432),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(432),
    [sym_struct_expression] = STATE(432),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(432),
    [sym_augmented_assignment_expression] = STATE(432),
    [sym_call_expression] = STATE(432),
    [sym_payable_conversion_expression] = STATE(432),
    [sym_meta_type_expression] = STATE(432),
    [sym__user_defined_type] = STATE(432),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(432),
    [sym_string_literal] = STATE(432),
    [sym_number_literal] = STATE(432),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(432),
    [sym_hex_string_literal] = STATE(432),
    [sym_unicode_string_literal] = STATE(432),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym__semicolon] = ACTIONS(252),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(254),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(256),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(258),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(260),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(262),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(264),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(266),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(268),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__expression] = STATE(421),
    [sym__primary_expression] = STATE(421),
    [sym_type_cast_expression] = STATE(421),
    [sym_ternary_expression] = STATE(421),
    [sym_new_expression] = STATE(421),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(421),
    [sym_struct_expression] = STATE(421),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(421),
    [sym_augmented_assignment_expression] = STATE(421),
    [sym_call_expression] = STATE(421),
    [sym_payable_conversion_expression] = STATE(421),
    [sym_meta_type_expression] = STATE(421),
    [sym__user_defined_type] = STATE(421),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(421),
    [sym_string_literal] = STATE(421),
    [sym_number_literal] = STATE(421),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(421),
    [sym_hex_string_literal] = STATE(421),
    [sym_unicode_string_literal] = STATE(421),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__expression] = STATE(431),
    [sym__primary_expression] = STATE(431),
    [sym_type_cast_expression] = STATE(431),
    [sym_ternary_expression] = STATE(431),
    [sym_new_expression] = STATE(431),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_update_expression] = STATE(431),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(431),
    [sym_struct_expression] = STATE(431),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(431),
    [sym_augmented_assignment_expression] = STATE(431),
    [sym_call_expression] = STATE(431),
    [sym_payable_conversion_expression] = STATE(431),
    [sym_meta_type_expression] = STATE(431),
    [sym__user_defined_type] = STATE(431),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(431),
    [sym_string_literal] = STATE(431),
    [sym_number_literal] = STATE(431),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(431),
    [sym_hex_string_literal] = STATE(431),
    [sym_unicode_string_literal] = STATE(431),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_COMMA] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(274),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(276),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__expression] = STATE(423),
    [sym__primary_expression] = STATE(423),
    [sym_type_cast_expression] = STATE(423),
    [sym_ternary_expression] = STATE(423),
    [sym_new_expression] = STATE(423),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(423),
    [sym_binary_expression] = STATE(423),
    [sym_unary_expression] = STATE(423),
    [sym_update_expression] = STATE(423),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(423),
    [sym_struct_expression] = STATE(423),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(423),
    [sym_augmented_assignment_expression] = STATE(423),
    [sym_call_expression] = STATE(423),
    [sym_payable_conversion_expression] = STATE(423),
    [sym_meta_type_expression] = STATE(423),
    [sym__user_defined_type] = STATE(423),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(423),
    [sym_string_literal] = STATE(423),
    [sym_number_literal] = STATE(423),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(423),
    [sym_hex_string_literal] = STATE(423),
    [sym_unicode_string_literal] = STATE(423),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(278),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__expression] = STATE(430),
    [sym__primary_expression] = STATE(430),
    [sym_type_cast_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym_new_expression] = STATE(430),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_update_expression] = STATE(430),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(430),
    [sym_struct_expression] = STATE(430),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(430),
    [sym_augmented_assignment_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_payable_conversion_expression] = STATE(430),
    [sym_meta_type_expression] = STATE(430),
    [sym__user_defined_type] = STATE(430),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_number_literal] = STATE(430),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(430),
    [sym_hex_string_literal] = STATE(430),
    [sym_unicode_string_literal] = STATE(430),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__expression] = STATE(466),
    [sym__primary_expression] = STATE(466),
    [sym_type_cast_expression] = STATE(466),
    [sym_ternary_expression] = STATE(466),
    [sym_new_expression] = STATE(466),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(466),
    [sym_binary_expression] = STATE(466),
    [sym_unary_expression] = STATE(466),
    [sym_update_expression] = STATE(466),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(466),
    [sym_struct_expression] = STATE(466),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(466),
    [sym_augmented_assignment_expression] = STATE(466),
    [sym_call_expression] = STATE(466),
    [sym_payable_conversion_expression] = STATE(466),
    [sym_meta_type_expression] = STATE(466),
    [sym__user_defined_type] = STATE(466),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(466),
    [sym_string_literal] = STATE(466),
    [sym_number_literal] = STATE(466),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(466),
    [sym_hex_string_literal] = STATE(466),
    [sym_unicode_string_literal] = STATE(466),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(280),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__expression] = STATE(443),
    [sym__primary_expression] = STATE(443),
    [sym_type_cast_expression] = STATE(443),
    [sym_ternary_expression] = STATE(443),
    [sym_new_expression] = STATE(443),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(443),
    [sym_binary_expression] = STATE(443),
    [sym_unary_expression] = STATE(443),
    [sym_update_expression] = STATE(443),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(443),
    [sym_struct_expression] = STATE(443),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(443),
    [sym_augmented_assignment_expression] = STATE(443),
    [sym_call_expression] = STATE(443),
    [sym_payable_conversion_expression] = STATE(443),
    [sym_meta_type_expression] = STATE(443),
    [sym__user_defined_type] = STATE(443),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(443),
    [sym_string_literal] = STATE(443),
    [sym_number_literal] = STATE(443),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(443),
    [sym_hex_string_literal] = STATE(443),
    [sym_unicode_string_literal] = STATE(443),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [sym__semicolon] = ACTIONS(282),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__expression] = STATE(454),
    [sym__primary_expression] = STATE(454),
    [sym_type_cast_expression] = STATE(454),
    [sym_ternary_expression] = STATE(454),
    [sym_new_expression] = STATE(454),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(454),
    [sym_binary_expression] = STATE(454),
    [sym_unary_expression] = STATE(454),
    [sym_update_expression] = STATE(454),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(454),
    [sym_struct_expression] = STATE(454),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(454),
    [sym_augmented_assignment_expression] = STATE(454),
    [sym_call_expression] = STATE(454),
    [sym_payable_conversion_expression] = STATE(454),
    [sym_meta_type_expression] = STATE(454),
    [sym__user_defined_type] = STATE(454),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(454),
    [sym_string_literal] = STATE(454),
    [sym_number_literal] = STATE(454),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(454),
    [sym_hex_string_literal] = STATE(454),
    [sym_unicode_string_literal] = STATE(454),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(284),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__expression] = STATE(433),
    [sym__primary_expression] = STATE(433),
    [sym_type_cast_expression] = STATE(433),
    [sym_ternary_expression] = STATE(433),
    [sym_new_expression] = STATE(433),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(433),
    [sym_binary_expression] = STATE(433),
    [sym_unary_expression] = STATE(433),
    [sym_update_expression] = STATE(433),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(433),
    [sym_struct_expression] = STATE(433),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(433),
    [sym_augmented_assignment_expression] = STATE(433),
    [sym_call_expression] = STATE(433),
    [sym_payable_conversion_expression] = STATE(433),
    [sym_meta_type_expression] = STATE(433),
    [sym__user_defined_type] = STATE(433),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(433),
    [sym_string_literal] = STATE(433),
    [sym_number_literal] = STATE(433),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(433),
    [sym_hex_string_literal] = STATE(433),
    [sym_unicode_string_literal] = STATE(433),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(286),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__expression] = STATE(426),
    [sym__primary_expression] = STATE(426),
    [sym_type_cast_expression] = STATE(426),
    [sym_ternary_expression] = STATE(426),
    [sym_new_expression] = STATE(426),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(426),
    [sym_struct_expression] = STATE(426),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(426),
    [sym_augmented_assignment_expression] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_payable_conversion_expression] = STATE(426),
    [sym_meta_type_expression] = STATE(426),
    [sym__user_defined_type] = STATE(426),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(426),
    [sym_string_literal] = STATE(426),
    [sym_number_literal] = STATE(426),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(426),
    [sym_hex_string_literal] = STATE(426),
    [sym_unicode_string_literal] = STATE(426),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(288),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__expression] = STATE(464),
    [sym__primary_expression] = STATE(464),
    [sym_type_cast_expression] = STATE(464),
    [sym_ternary_expression] = STATE(464),
    [sym_new_expression] = STATE(464),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(464),
    [sym_binary_expression] = STATE(464),
    [sym_unary_expression] = STATE(464),
    [sym_update_expression] = STATE(464),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(464),
    [sym_struct_expression] = STATE(464),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(464),
    [sym_augmented_assignment_expression] = STATE(464),
    [sym_call_expression] = STATE(464),
    [sym_payable_conversion_expression] = STATE(464),
    [sym_meta_type_expression] = STATE(464),
    [sym__user_defined_type] = STATE(464),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(464),
    [sym_string_literal] = STATE(464),
    [sym_number_literal] = STATE(464),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(464),
    [sym_hex_string_literal] = STATE(464),
    [sym_unicode_string_literal] = STATE(464),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(290),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__expression] = STATE(426),
    [sym__primary_expression] = STATE(426),
    [sym_type_cast_expression] = STATE(426),
    [sym_ternary_expression] = STATE(426),
    [sym_new_expression] = STATE(426),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(426),
    [sym_struct_expression] = STATE(426),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(426),
    [sym_augmented_assignment_expression] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_payable_conversion_expression] = STATE(426),
    [sym_meta_type_expression] = STATE(426),
    [sym__user_defined_type] = STATE(426),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(426),
    [sym_string_literal] = STATE(426),
    [sym_number_literal] = STATE(426),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(426),
    [sym_hex_string_literal] = STATE(426),
    [sym_unicode_string_literal] = STATE(426),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__expression] = STATE(417),
    [sym__primary_expression] = STATE(417),
    [sym_type_cast_expression] = STATE(417),
    [sym_ternary_expression] = STATE(417),
    [sym_new_expression] = STATE(417),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(417),
    [sym_binary_expression] = STATE(417),
    [sym_unary_expression] = STATE(417),
    [sym_update_expression] = STATE(417),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(417),
    [sym_struct_expression] = STATE(417),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(417),
    [sym_augmented_assignment_expression] = STATE(417),
    [sym_call_expression] = STATE(417),
    [sym_payable_conversion_expression] = STATE(417),
    [sym_meta_type_expression] = STATE(417),
    [sym__user_defined_type] = STATE(417),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(417),
    [sym_string_literal] = STATE(417),
    [sym_number_literal] = STATE(417),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(417),
    [sym_hex_string_literal] = STATE(417),
    [sym_unicode_string_literal] = STATE(417),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__expression] = STATE(434),
    [sym__primary_expression] = STATE(434),
    [sym_type_cast_expression] = STATE(434),
    [sym_ternary_expression] = STATE(434),
    [sym_new_expression] = STATE(434),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(434),
    [sym_binary_expression] = STATE(434),
    [sym_unary_expression] = STATE(434),
    [sym_update_expression] = STATE(434),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(434),
    [sym_struct_expression] = STATE(434),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(434),
    [sym_augmented_assignment_expression] = STATE(434),
    [sym_call_expression] = STATE(434),
    [sym_payable_conversion_expression] = STATE(434),
    [sym_meta_type_expression] = STATE(434),
    [sym__user_defined_type] = STATE(434),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(434),
    [sym_string_literal] = STATE(434),
    [sym_number_literal] = STATE(434),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(434),
    [sym_hex_string_literal] = STATE(434),
    [sym_unicode_string_literal] = STATE(434),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__expression] = STATE(403),
    [sym__primary_expression] = STATE(403),
    [sym_type_cast_expression] = STATE(403),
    [sym_ternary_expression] = STATE(403),
    [sym_new_expression] = STATE(403),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(403),
    [sym_binary_expression] = STATE(403),
    [sym_unary_expression] = STATE(403),
    [sym_update_expression] = STATE(403),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(403),
    [sym_struct_expression] = STATE(403),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(403),
    [sym_augmented_assignment_expression] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_payable_conversion_expression] = STATE(403),
    [sym_meta_type_expression] = STATE(403),
    [sym__user_defined_type] = STATE(403),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(403),
    [sym_string_literal] = STATE(403),
    [sym_number_literal] = STATE(403),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(403),
    [sym_hex_string_literal] = STATE(403),
    [sym_unicode_string_literal] = STATE(403),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__expression] = STATE(436),
    [sym__primary_expression] = STATE(436),
    [sym_type_cast_expression] = STATE(436),
    [sym_ternary_expression] = STATE(436),
    [sym_new_expression] = STATE(436),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(436),
    [sym_binary_expression] = STATE(436),
    [sym_unary_expression] = STATE(436),
    [sym_update_expression] = STATE(436),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(436),
    [sym_struct_expression] = STATE(436),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(436),
    [sym_augmented_assignment_expression] = STATE(436),
    [sym_call_expression] = STATE(436),
    [sym_payable_conversion_expression] = STATE(436),
    [sym_meta_type_expression] = STATE(436),
    [sym__user_defined_type] = STATE(436),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(436),
    [sym_string_literal] = STATE(436),
    [sym_number_literal] = STATE(436),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(436),
    [sym_hex_string_literal] = STATE(436),
    [sym_unicode_string_literal] = STATE(436),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__expression] = STATE(447),
    [sym__primary_expression] = STATE(447),
    [sym_type_cast_expression] = STATE(447),
    [sym_ternary_expression] = STATE(447),
    [sym_new_expression] = STATE(447),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(447),
    [sym_binary_expression] = STATE(447),
    [sym_unary_expression] = STATE(447),
    [sym_update_expression] = STATE(447),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(447),
    [sym_struct_expression] = STATE(447),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(447),
    [sym_augmented_assignment_expression] = STATE(447),
    [sym_call_expression] = STATE(447),
    [sym_payable_conversion_expression] = STATE(447),
    [sym_meta_type_expression] = STATE(447),
    [sym__user_defined_type] = STATE(447),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(447),
    [sym_string_literal] = STATE(447),
    [sym_number_literal] = STATE(447),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(447),
    [sym_hex_string_literal] = STATE(447),
    [sym_unicode_string_literal] = STATE(447),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__expression] = STATE(427),
    [sym__primary_expression] = STATE(427),
    [sym_type_cast_expression] = STATE(427),
    [sym_ternary_expression] = STATE(427),
    [sym_new_expression] = STATE(427),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(427),
    [sym_binary_expression] = STATE(427),
    [sym_unary_expression] = STATE(427),
    [sym_update_expression] = STATE(427),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(427),
    [sym_struct_expression] = STATE(427),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(427),
    [sym_augmented_assignment_expression] = STATE(427),
    [sym_call_expression] = STATE(427),
    [sym_payable_conversion_expression] = STATE(427),
    [sym_meta_type_expression] = STATE(427),
    [sym__user_defined_type] = STATE(427),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(427),
    [sym_string_literal] = STATE(427),
    [sym_number_literal] = STATE(427),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(427),
    [sym_hex_string_literal] = STATE(427),
    [sym_unicode_string_literal] = STATE(427),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__expression] = STATE(404),
    [sym__primary_expression] = STATE(404),
    [sym_type_cast_expression] = STATE(404),
    [sym_ternary_expression] = STATE(404),
    [sym_new_expression] = STATE(404),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(404),
    [sym_struct_expression] = STATE(404),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(404),
    [sym_augmented_assignment_expression] = STATE(404),
    [sym_call_expression] = STATE(404),
    [sym_payable_conversion_expression] = STATE(404),
    [sym_meta_type_expression] = STATE(404),
    [sym__user_defined_type] = STATE(404),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(404),
    [sym_string_literal] = STATE(404),
    [sym_number_literal] = STATE(404),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(404),
    [sym_hex_string_literal] = STATE(404),
    [sym_unicode_string_literal] = STATE(404),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__expression] = STATE(456),
    [sym__primary_expression] = STATE(456),
    [sym_type_cast_expression] = STATE(456),
    [sym_ternary_expression] = STATE(456),
    [sym_new_expression] = STATE(456),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(456),
    [sym_binary_expression] = STATE(456),
    [sym_unary_expression] = STATE(456),
    [sym_update_expression] = STATE(456),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(456),
    [sym_struct_expression] = STATE(456),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(456),
    [sym_augmented_assignment_expression] = STATE(456),
    [sym_call_expression] = STATE(456),
    [sym_payable_conversion_expression] = STATE(456),
    [sym_meta_type_expression] = STATE(456),
    [sym__user_defined_type] = STATE(456),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(456),
    [sym_string_literal] = STATE(456),
    [sym_number_literal] = STATE(456),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(456),
    [sym_hex_string_literal] = STATE(456),
    [sym_unicode_string_literal] = STATE(456),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__expression] = STATE(438),
    [sym__primary_expression] = STATE(438),
    [sym_type_cast_expression] = STATE(438),
    [sym_ternary_expression] = STATE(438),
    [sym_new_expression] = STATE(438),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(438),
    [sym_binary_expression] = STATE(438),
    [sym_unary_expression] = STATE(438),
    [sym_update_expression] = STATE(438),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(438),
    [sym_struct_expression] = STATE(438),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(438),
    [sym_augmented_assignment_expression] = STATE(438),
    [sym_call_expression] = STATE(438),
    [sym_payable_conversion_expression] = STATE(438),
    [sym_meta_type_expression] = STATE(438),
    [sym__user_defined_type] = STATE(438),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(438),
    [sym_string_literal] = STATE(438),
    [sym_number_literal] = STATE(438),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(438),
    [sym_hex_string_literal] = STATE(438),
    [sym_unicode_string_literal] = STATE(438),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__expression] = STATE(455),
    [sym__primary_expression] = STATE(455),
    [sym_type_cast_expression] = STATE(455),
    [sym_ternary_expression] = STATE(455),
    [sym_new_expression] = STATE(455),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(455),
    [sym_binary_expression] = STATE(455),
    [sym_unary_expression] = STATE(455),
    [sym_update_expression] = STATE(455),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(455),
    [sym_struct_expression] = STATE(455),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(455),
    [sym_augmented_assignment_expression] = STATE(455),
    [sym_call_expression] = STATE(455),
    [sym_payable_conversion_expression] = STATE(455),
    [sym_meta_type_expression] = STATE(455),
    [sym__user_defined_type] = STATE(455),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(455),
    [sym_string_literal] = STATE(455),
    [sym_number_literal] = STATE(455),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(455),
    [sym_hex_string_literal] = STATE(455),
    [sym_unicode_string_literal] = STATE(455),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__expression] = STATE(405),
    [sym__primary_expression] = STATE(405),
    [sym_type_cast_expression] = STATE(405),
    [sym_ternary_expression] = STATE(405),
    [sym_new_expression] = STATE(405),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(405),
    [sym_binary_expression] = STATE(405),
    [sym_unary_expression] = STATE(405),
    [sym_update_expression] = STATE(405),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(405),
    [sym_struct_expression] = STATE(405),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(405),
    [sym_augmented_assignment_expression] = STATE(405),
    [sym_call_expression] = STATE(405),
    [sym_payable_conversion_expression] = STATE(405),
    [sym_meta_type_expression] = STATE(405),
    [sym__user_defined_type] = STATE(405),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(405),
    [sym_string_literal] = STATE(405),
    [sym_number_literal] = STATE(405),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(405),
    [sym_hex_string_literal] = STATE(405),
    [sym_unicode_string_literal] = STATE(405),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__expression] = STATE(413),
    [sym__primary_expression] = STATE(413),
    [sym_type_cast_expression] = STATE(413),
    [sym_ternary_expression] = STATE(413),
    [sym_new_expression] = STATE(413),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(413),
    [sym_struct_expression] = STATE(413),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(413),
    [sym_augmented_assignment_expression] = STATE(413),
    [sym_call_expression] = STATE(413),
    [sym_payable_conversion_expression] = STATE(413),
    [sym_meta_type_expression] = STATE(413),
    [sym__user_defined_type] = STATE(413),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(413),
    [sym_string_literal] = STATE(413),
    [sym_number_literal] = STATE(413),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(413),
    [sym_hex_string_literal] = STATE(413),
    [sym_unicode_string_literal] = STATE(413),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__expression] = STATE(453),
    [sym__primary_expression] = STATE(453),
    [sym_type_cast_expression] = STATE(453),
    [sym_ternary_expression] = STATE(453),
    [sym_new_expression] = STATE(453),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(453),
    [sym_binary_expression] = STATE(453),
    [sym_unary_expression] = STATE(453),
    [sym_update_expression] = STATE(453),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(453),
    [sym_struct_expression] = STATE(453),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(453),
    [sym_augmented_assignment_expression] = STATE(453),
    [sym_call_expression] = STATE(453),
    [sym_payable_conversion_expression] = STATE(453),
    [sym_meta_type_expression] = STATE(453),
    [sym__user_defined_type] = STATE(453),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(453),
    [sym_string_literal] = STATE(453),
    [sym_number_literal] = STATE(453),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(453),
    [sym_hex_string_literal] = STATE(453),
    [sym_unicode_string_literal] = STATE(453),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__expression] = STATE(426),
    [sym__primary_expression] = STATE(426),
    [sym_type_cast_expression] = STATE(426),
    [sym_ternary_expression] = STATE(426),
    [sym_new_expression] = STATE(426),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(426),
    [sym_struct_expression] = STATE(426),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(426),
    [sym_augmented_assignment_expression] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_payable_conversion_expression] = STATE(426),
    [sym_meta_type_expression] = STATE(426),
    [sym__user_defined_type] = STATE(426),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(426),
    [sym_string_literal] = STATE(426),
    [sym_number_literal] = STATE(426),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(426),
    [sym_hex_string_literal] = STATE(426),
    [sym_unicode_string_literal] = STATE(426),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__expression] = STATE(422),
    [sym__primary_expression] = STATE(422),
    [sym_type_cast_expression] = STATE(422),
    [sym_ternary_expression] = STATE(422),
    [sym_new_expression] = STATE(422),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(422),
    [sym_binary_expression] = STATE(422),
    [sym_unary_expression] = STATE(422),
    [sym_update_expression] = STATE(422),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(422),
    [sym_struct_expression] = STATE(422),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(422),
    [sym_augmented_assignment_expression] = STATE(422),
    [sym_call_expression] = STATE(422),
    [sym_payable_conversion_expression] = STATE(422),
    [sym_meta_type_expression] = STATE(422),
    [sym__user_defined_type] = STATE(422),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(422),
    [sym_string_literal] = STATE(422),
    [sym_number_literal] = STATE(422),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(422),
    [sym_hex_string_literal] = STATE(422),
    [sym_unicode_string_literal] = STATE(422),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__expression] = STATE(394),
    [sym__primary_expression] = STATE(394),
    [sym_type_cast_expression] = STATE(394),
    [sym_ternary_expression] = STATE(394),
    [sym_new_expression] = STATE(394),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(394),
    [sym_struct_expression] = STATE(394),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(394),
    [sym_augmented_assignment_expression] = STATE(394),
    [sym_call_expression] = STATE(394),
    [sym_payable_conversion_expression] = STATE(394),
    [sym_meta_type_expression] = STATE(394),
    [sym__user_defined_type] = STATE(394),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(394),
    [sym_string_literal] = STATE(394),
    [sym_number_literal] = STATE(394),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(394),
    [sym_hex_string_literal] = STATE(394),
    [sym_unicode_string_literal] = STATE(394),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__expression] = STATE(460),
    [sym__primary_expression] = STATE(460),
    [sym_type_cast_expression] = STATE(460),
    [sym_ternary_expression] = STATE(460),
    [sym_new_expression] = STATE(460),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(460),
    [sym_binary_expression] = STATE(460),
    [sym_unary_expression] = STATE(460),
    [sym_update_expression] = STATE(460),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(460),
    [sym_struct_expression] = STATE(460),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(460),
    [sym_augmented_assignment_expression] = STATE(460),
    [sym_call_expression] = STATE(460),
    [sym_payable_conversion_expression] = STATE(460),
    [sym_meta_type_expression] = STATE(460),
    [sym__user_defined_type] = STATE(460),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(460),
    [sym_string_literal] = STATE(460),
    [sym_number_literal] = STATE(460),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(460),
    [sym_hex_string_literal] = STATE(460),
    [sym_unicode_string_literal] = STATE(460),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__expression] = STATE(442),
    [sym__primary_expression] = STATE(442),
    [sym_type_cast_expression] = STATE(442),
    [sym_ternary_expression] = STATE(442),
    [sym_new_expression] = STATE(442),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(442),
    [sym_binary_expression] = STATE(442),
    [sym_unary_expression] = STATE(442),
    [sym_update_expression] = STATE(442),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(442),
    [sym_struct_expression] = STATE(442),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(442),
    [sym_augmented_assignment_expression] = STATE(442),
    [sym_call_expression] = STATE(442),
    [sym_payable_conversion_expression] = STATE(442),
    [sym_meta_type_expression] = STATE(442),
    [sym__user_defined_type] = STATE(442),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(442),
    [sym_string_literal] = STATE(442),
    [sym_number_literal] = STATE(442),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(442),
    [sym_hex_string_literal] = STATE(442),
    [sym_unicode_string_literal] = STATE(442),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__expression] = STATE(473),
    [sym__primary_expression] = STATE(473),
    [sym_type_cast_expression] = STATE(473),
    [sym_ternary_expression] = STATE(473),
    [sym_new_expression] = STATE(473),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(473),
    [sym_binary_expression] = STATE(473),
    [sym_unary_expression] = STATE(473),
    [sym_update_expression] = STATE(473),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(473),
    [sym_struct_expression] = STATE(473),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(473),
    [sym_augmented_assignment_expression] = STATE(473),
    [sym_call_expression] = STATE(473),
    [sym_payable_conversion_expression] = STATE(473),
    [sym_meta_type_expression] = STATE(473),
    [sym__user_defined_type] = STATE(473),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(473),
    [sym_string_literal] = STATE(473),
    [sym_number_literal] = STATE(473),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(473),
    [sym_hex_string_literal] = STATE(473),
    [sym_unicode_string_literal] = STATE(473),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__expression] = STATE(425),
    [sym__primary_expression] = STATE(425),
    [sym_type_cast_expression] = STATE(425),
    [sym_ternary_expression] = STATE(425),
    [sym_new_expression] = STATE(425),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(425),
    [sym_struct_expression] = STATE(425),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(425),
    [sym_augmented_assignment_expression] = STATE(425),
    [sym_call_expression] = STATE(425),
    [sym_payable_conversion_expression] = STATE(425),
    [sym_meta_type_expression] = STATE(425),
    [sym__user_defined_type] = STATE(425),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(425),
    [sym_string_literal] = STATE(425),
    [sym_number_literal] = STATE(425),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(425),
    [sym_hex_string_literal] = STATE(425),
    [sym_unicode_string_literal] = STATE(425),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__expression] = STATE(386),
    [sym__primary_expression] = STATE(386),
    [sym_type_cast_expression] = STATE(386),
    [sym_ternary_expression] = STATE(386),
    [sym_new_expression] = STATE(386),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(386),
    [sym_binary_expression] = STATE(386),
    [sym_unary_expression] = STATE(386),
    [sym_update_expression] = STATE(386),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(386),
    [sym_struct_expression] = STATE(386),
    [sym__lhs_expression] = STATE(522),
    [sym_parenthesized_expression] = STATE(393),
    [sym_assignment_expression] = STATE(386),
    [sym_augmented_assignment_expression] = STATE(386),
    [sym_call_expression] = STATE(386),
    [sym_payable_conversion_expression] = STATE(386),
    [sym_meta_type_expression] = STATE(386),
    [sym__user_defined_type] = STATE(386),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(339),
    [sym__uint] = STATE(339),
    [sym__bytes] = STATE(339),
    [sym__fixed] = STATE(339),
    [sym__ufixed] = STATE(339),
    [sym__literal] = STATE(386),
    [sym_string_literal] = STATE(386),
    [sym_number_literal] = STATE(386),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(386),
    [sym_hex_string_literal] = STATE(386),
    [sym_unicode_string_literal] = STATE(386),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(33),
    [anon_sym_TILDE] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(27),
    [anon_sym_address] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(35),
    [anon_sym_delete] = ACTIONS(79),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(27),
    [anon_sym_string] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(27),
    [anon_sym_int8] = ACTIONS(27),
    [anon_sym_int16] = ACTIONS(27),
    [anon_sym_int24] = ACTIONS(27),
    [anon_sym_int32] = ACTIONS(27),
    [anon_sym_int40] = ACTIONS(27),
    [anon_sym_int48] = ACTIONS(27),
    [anon_sym_int56] = ACTIONS(27),
    [anon_sym_int64] = ACTIONS(27),
    [anon_sym_int72] = ACTIONS(27),
    [anon_sym_int80] = ACTIONS(27),
    [anon_sym_int88] = ACTIONS(27),
    [anon_sym_int96] = ACTIONS(27),
    [anon_sym_int104] = ACTIONS(27),
    [anon_sym_int112] = ACTIONS(27),
    [anon_sym_int120] = ACTIONS(27),
    [anon_sym_int128] = ACTIONS(27),
    [anon_sym_int136] = ACTIONS(27),
    [anon_sym_int144] = ACTIONS(27),
    [anon_sym_int152] = ACTIONS(27),
    [anon_sym_int160] = ACTIONS(27),
    [anon_sym_int168] = ACTIONS(27),
    [anon_sym_int176] = ACTIONS(27),
    [anon_sym_int184] = ACTIONS(27),
    [anon_sym_int192] = ACTIONS(27),
    [anon_sym_int200] = ACTIONS(27),
    [anon_sym_int208] = ACTIONS(27),
    [anon_sym_int216] = ACTIONS(27),
    [anon_sym_int224] = ACTIONS(27),
    [anon_sym_int232] = ACTIONS(27),
    [anon_sym_int240] = ACTIONS(27),
    [anon_sym_int248] = ACTIONS(27),
    [anon_sym_int256] = ACTIONS(27),
    [anon_sym_uint] = ACTIONS(27),
    [anon_sym_uint8] = ACTIONS(27),
    [anon_sym_uint16] = ACTIONS(27),
    [anon_sym_uint24] = ACTIONS(27),
    [anon_sym_uint32] = ACTIONS(27),
    [anon_sym_uint40] = ACTIONS(27),
    [anon_sym_uint48] = ACTIONS(27),
    [anon_sym_uint56] = ACTIONS(27),
    [anon_sym_uint64] = ACTIONS(27),
    [anon_sym_uint72] = ACTIONS(27),
    [anon_sym_uint80] = ACTIONS(27),
    [anon_sym_uint88] = ACTIONS(27),
    [anon_sym_uint96] = ACTIONS(27),
    [anon_sym_uint104] = ACTIONS(27),
    [anon_sym_uint112] = ACTIONS(27),
    [anon_sym_uint120] = ACTIONS(27),
    [anon_sym_uint128] = ACTIONS(27),
    [anon_sym_uint136] = ACTIONS(27),
    [anon_sym_uint144] = ACTIONS(27),
    [anon_sym_uint152] = ACTIONS(27),
    [anon_sym_uint160] = ACTIONS(27),
    [anon_sym_uint168] = ACTIONS(27),
    [anon_sym_uint176] = ACTIONS(27),
    [anon_sym_uint184] = ACTIONS(27),
    [anon_sym_uint192] = ACTIONS(27),
    [anon_sym_uint200] = ACTIONS(27),
    [anon_sym_uint208] = ACTIONS(27),
    [anon_sym_uint216] = ACTIONS(27),
    [anon_sym_uint224] = ACTIONS(27),
    [anon_sym_uint232] = ACTIONS(27),
    [anon_sym_uint240] = ACTIONS(27),
    [anon_sym_uint248] = ACTIONS(27),
    [anon_sym_uint256] = ACTIONS(27),
    [anon_sym_bytes] = ACTIONS(27),
    [anon_sym_bytes1] = ACTIONS(27),
    [anon_sym_bytes2] = ACTIONS(27),
    [anon_sym_bytes3] = ACTIONS(27),
    [anon_sym_bytes4] = ACTIONS(27),
    [anon_sym_bytes5] = ACTIONS(27),
    [anon_sym_bytes6] = ACTIONS(27),
    [anon_sym_bytes7] = ACTIONS(27),
    [anon_sym_bytes8] = ACTIONS(27),
    [anon_sym_bytes9] = ACTIONS(27),
    [anon_sym_bytes10] = ACTIONS(27),
    [anon_sym_bytes11] = ACTIONS(27),
    [anon_sym_bytes12] = ACTIONS(27),
    [anon_sym_bytes13] = ACTIONS(27),
    [anon_sym_bytes14] = ACTIONS(27),
    [anon_sym_bytes15] = ACTIONS(27),
    [anon_sym_bytes16] = ACTIONS(27),
    [anon_sym_bytes17] = ACTIONS(27),
    [anon_sym_bytes18] = ACTIONS(27),
    [anon_sym_bytes19] = ACTIONS(27),
    [anon_sym_bytes20] = ACTIONS(27),
    [anon_sym_bytes21] = ACTIONS(27),
    [anon_sym_bytes22] = ACTIONS(27),
    [anon_sym_bytes23] = ACTIONS(27),
    [anon_sym_bytes24] = ACTIONS(27),
    [anon_sym_bytes25] = ACTIONS(27),
    [anon_sym_bytes26] = ACTIONS(27),
    [anon_sym_bytes27] = ACTIONS(27),
    [anon_sym_bytes28] = ACTIONS(27),
    [anon_sym_bytes29] = ACTIONS(27),
    [anon_sym_bytes30] = ACTIONS(27),
    [anon_sym_bytes31] = ACTIONS(27),
    [anon_sym_bytes32] = ACTIONS(27),
    [anon_sym_fixed] = ACTIONS(27),
    [aux_sym__fixed_token1] = ACTIONS(27),
    [anon_sym_ufixed] = ACTIONS(27),
    [aux_sym__ufixed_token1] = ACTIONS(27),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__expression] = STATE(446),
    [sym__primary_expression] = STATE(446),
    [sym_type_cast_expression] = STATE(446),
    [sym_ternary_expression] = STATE(446),
    [sym_new_expression] = STATE(446),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(446),
    [sym_binary_expression] = STATE(446),
    [sym_unary_expression] = STATE(446),
    [sym_update_expression] = STATE(446),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(446),
    [sym_struct_expression] = STATE(446),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(446),
    [sym_augmented_assignment_expression] = STATE(446),
    [sym_call_expression] = STATE(446),
    [sym_payable_conversion_expression] = STATE(446),
    [sym_meta_type_expression] = STATE(446),
    [sym__user_defined_type] = STATE(446),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(446),
    [sym_string_literal] = STATE(446),
    [sym_number_literal] = STATE(446),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(446),
    [sym_hex_string_literal] = STATE(446),
    [sym_unicode_string_literal] = STATE(446),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__expression] = STATE(450),
    [sym__primary_expression] = STATE(450),
    [sym_type_cast_expression] = STATE(450),
    [sym_ternary_expression] = STATE(450),
    [sym_new_expression] = STATE(450),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(450),
    [sym_binary_expression] = STATE(450),
    [sym_unary_expression] = STATE(450),
    [sym_update_expression] = STATE(450),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(450),
    [sym_struct_expression] = STATE(450),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(450),
    [sym_augmented_assignment_expression] = STATE(450),
    [sym_call_expression] = STATE(450),
    [sym_payable_conversion_expression] = STATE(450),
    [sym_meta_type_expression] = STATE(450),
    [sym__user_defined_type] = STATE(450),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(450),
    [sym_string_literal] = STATE(450),
    [sym_number_literal] = STATE(450),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(450),
    [sym_hex_string_literal] = STATE(450),
    [sym_unicode_string_literal] = STATE(450),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26] = ACTIONS(298),
    [anon_sym_bytes27] = ACTIONS(298),
    [anon_sym_bytes28] = ACTIONS(298),
    [anon_sym_bytes29] = ACTIONS(298),
    [anon_sym_bytes30] = ACTIONS(298),
    [anon_sym_bytes31] = ACTIONS(298),
    [anon_sym_bytes32] = ACTIONS(298),
    [anon_sym_fixed] = ACTIONS(298),
    [aux_sym__fixed_token1] = ACTIONS(298),
    [anon_sym_ufixed] = ACTIONS(298),
    [aux_sym__ufixed_token1] = ACTIONS(298),
    [aux_sym__decimal_number_token1] = ACTIONS(85),
    [aux_sym__decimal_number_token2] = ACTIONS(87),
    [aux_sym__hex_number_token1] = ACTIONS(89),
    [anon_sym_hex] = ACTIONS(91),
    [anon_sym_DQUOTE] = ACTIONS(93),
    [anon_sym_SQUOTE] = ACTIONS(95),
    [anon_sym_unicode] = ACTIONS(97),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__expression] = STATE(380),
    [sym__primary_expression] = STATE(380),
    [sym_type_cast_expression] = STATE(380),
    [sym_ternary_expression] = STATE(380),
    [sym_new_expression] = STATE(380),
    [sym_tuple_expression] = STATE(345),
    [sym_inline_array_expression] = STATE(380),
    [sym_binary_expression] = STATE(380),
    [sym_unary_expression] = STATE(380),
    [sym_update_expression] = STATE(380),
    [sym_member_expression] = STATE(345),
    [sym_array_access] = STATE(345),
    [sym_slice_access] = STATE(380),
    [sym_struct_expression] = STATE(380),
    [sym__lhs_expression] = STATE(513),
    [sym_parenthesized_expression] = STATE(463),
    [sym_assignment_expression] = STATE(380),
    [sym_augmented_assignment_expression] = STATE(380),
    [sym_call_expression] = STATE(380),
    [sym_payable_conversion_expression] = STATE(380),
    [sym_meta_type_expression] = STATE(380),
    [sym__user_defined_type] = STATE(380),
    [sym_primitive_type] = STATE(411),
    [sym__int] = STATE(470),
    [sym__uint] = STATE(470),
    [sym__bytes] = STATE(470),
    [sym__fixed] = STATE(470),
    [sym__ufixed] = STATE(470),
    [sym__literal] = STATE(380),
    [sym_string_literal] = STATE(380),
    [sym_number_literal] = STATE(380),
    [sym__decimal_number] = STATE(340),
    [sym__hex_number] = STATE(340),
    [sym_true] = STATE(414),
    [sym_false] = STATE(414),
    [sym_boolean_literal] = STATE(380),
    [sym_hex_string_literal] = STATE(380),
    [sym_unicode_string_literal] = STATE(380),
    [sym_string] = STATE(370),
    [aux_sym_string_literal_repeat1] = STATE(370),
    [aux_sym_hex_string_literal_repeat1] = STATE(373),
    [aux_sym_unicode_string_literal_repeat3] = STATE(374),
    [sym_identifier] = ACTIONS(294),
    [anon_sym_TILDE] = ACTIONS(296),
    [anon_sym_LPAREN] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [anon_sym_byte] = ACTIONS(298),
    [anon_sym_address] = ACTIONS(300),
    [anon_sym_var] = ACTIONS(298),
    [anon_sym_payable] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_BANG] = ACTIONS(296),
    [anon_sym_delete] = ACTIONS(306),
    [anon_sym_PLUS_PLUS] = ACTIONS(308),
    [anon_sym_DASH_DASH] = ACTIONS(308),
    [anon_sym_type] = ACTIONS(83),
    [anon_sym_bool] = ACTIONS(298),
    [anon_sym_string] = ACTIONS(298),
    [anon_sym_int] = ACTIONS(298),
    [anon_sym_int8] = ACTIONS(298),
    [anon_sym_int16] = ACTIONS(298),
    [anon_sym_int24] = ACTIONS(298),
    [anon_sym_int32] = ACTIONS(298),
    [anon_sym_int40] = ACTIONS(298),
    [anon_sym_int48] = ACTIONS(298),
    [anon_sym_int56] = ACTIONS(298),
    [anon_sym_int64] = ACTIONS(298),
    [anon_sym_int72] = ACTIONS(298),
    [anon_sym_int80] = ACTIONS(298),
    [anon_sym_int88] = ACTIONS(298),
    [anon_sym_int96] = ACTIONS(298),
    [anon_sym_int104] = ACTIONS(298),
    [anon_sym_int112] = ACTIONS(298),
    [anon_sym_int120] = ACTIONS(298),
    [anon_sym_int128] = ACTIONS(298),
    [anon_sym_int136] = ACTIONS(298),
    [anon_sym_int144] = ACTIONS(298),
    [anon_sym_int152] = ACTIONS(298),
    [anon_sym_int160] = ACTIONS(298),
    [anon_sym_int168] = ACTIONS(298),
    [anon_sym_int176] = ACTIONS(298),
    [anon_sym_int184] = ACTIONS(298),
    [anon_sym_int192] = ACTIONS(298),
    [anon_sym_int200] = ACTIONS(298),
    [anon_sym_int208] = ACTIONS(298),
    [anon_sym_int216] = ACTIONS(298),
    [anon_sym_int224] = ACTIONS(298),
    [anon_sym_int232] = ACTIONS(298),
    [anon_sym_int240] = ACTIONS(298),
    [anon_sym_int248] = ACTIONS(298),
    [anon_sym_int256] = ACTIONS(298),
    [anon_sym_uint] = ACTIONS(298),
    [anon_sym_uint8] = ACTIONS(298),
    [anon_sym_uint16] = ACTIONS(298),
    [anon_sym_uint24] = ACTIONS(298),
    [anon_sym_uint32] = ACTIONS(298),
    [anon_sym_uint40] = ACTIONS(298),
    [anon_sym_uint48] = ACTIONS(298),
    [anon_sym_uint56] = ACTIONS(298),
    [anon_sym_uint64] = ACTIONS(298),
    [anon_sym_uint72] = ACTIONS(298),
    [anon_sym_uint80] = ACTIONS(298),
    [anon_sym_uint88] = ACTIONS(298),
    [anon_sym_uint96] = ACTIONS(298),
    [anon_sym_uint104] = ACTIONS(298),
    [anon_sym_uint112] = ACTIONS(298),
    [anon_sym_uint120] = ACTIONS(298),
    [anon_sym_uint128] = ACTIONS(298),
    [anon_sym_uint136] = ACTIONS(298),
    [anon_sym_uint144] = ACTIONS(298),
    [anon_sym_uint152] = ACTIONS(298),
    [anon_sym_uint160] = ACTIONS(298),
    [anon_sym_uint168] = ACTIONS(298),
    [anon_sym_uint176] = ACTIONS(298),
    [anon_sym_uint184] = ACTIONS(298),
    [anon_sym_uint192] = ACTIONS(298),
    [anon_sym_uint200] = ACTIONS(298),
    [anon_sym_uint208] = ACTIONS(298),
    [anon_sym_uint216] = ACTIONS(298),
    [anon_sym_uint224] = ACTIONS(298),
    [anon_sym_uint232] = ACTIONS(298),
    [anon_sym_uint240] = ACTIONS(298),
    [anon_sym_uint248] = ACTIONS(298),
    [anon_sym_uint256] = ACTIONS(298),
    [anon_sym_bytes] = ACTIONS(298),
    [anon_sym_bytes1] = ACTIONS(298),
    [anon_sym_bytes2] = ACTIONS(298),
    [anon_sym_bytes3] = ACTIONS(298),
    [anon_sym_bytes4] = ACTIONS(298),
    [anon_sym_bytes5] = ACTIONS(298),
    [anon_sym_bytes6] = ACTIONS(298),
    [anon_sym_bytes7] = ACTIONS(298),
    [anon_sym_bytes8] = ACTIONS(298),
    [anon_sym_bytes9] = ACTIONS(298),
    [anon_sym_bytes10] = ACTIONS(298),
    [anon_sym_bytes11] = ACTIONS(298),
    [anon_sym_bytes12] = ACTIONS(298),
    [anon_sym_bytes13] = ACTIONS(298),
    [anon_sym_bytes14] = ACTIONS(298),
    [anon_sym_bytes15] = ACTIONS(298),
    [anon_sym_bytes16] = ACTIONS(298),
    [anon_sym_bytes17] = ACTIONS(298),
    [anon_sym_bytes18] = ACTIONS(298),
    [anon_sym_bytes19] = ACTIONS(298),
    [anon_sym_bytes20] = ACTIONS(298),
    [anon_sym_bytes21] = ACTIONS(298),
    [anon_sym_bytes22] = ACTIONS(298),
    [anon_sym_bytes23] = ACTIONS(298),
    [anon_sym_bytes24] = ACTIONS(298),
    [anon_sym_bytes25] = ACTIONS(298),
    [anon_sym_bytes26