#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1151
#define LARGE_STATE_COUNT 794
#define SYMBOL_COUNT 122
#define ALIAS_COUNT 0
#define TOKEN_COUNT 77
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 14
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 18

enum {
  anon_sym_LF = 1,
  anon_sym_SEMI = 2,
  anon_sym_function = 3,
  anon_sym_BSLASH = 4,
  anon_sym_if = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_else = 8,
  anon_sym_while = 9,
  anon_sym_repeat = 10,
  anon_sym_for = 11,
  anon_sym_in = 12,
  anon_sym_switch = 13,
  anon_sym_COMMA = 14,
  anon_sym_EQ = 15,
  anon_sym_LBRACE = 16,
  anon_sym_RBRACE = 17,
  anon_sym_LT_DASH = 18,
  anon_sym_COLON_EQ = 19,
  anon_sym_LT_LT_DASH = 20,
  anon_sym_DASH_GT_GT = 21,
  anon_sym_DASH_GT = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_LBRACK_LBRACK = 25,
  anon_sym_RBRACK_RBRACK = 26,
  anon_sym_DOLLAR = 27,
  anon_sym_AT = 28,
  anon_sym_COLON_COLON = 29,
  anon_sym_COLON_COLON_COLON = 30,
  sym_dots = 31,
  anon_sym_PIPE_GT = 32,
  anon_sym_DASH = 33,
  anon_sym_PLUS = 34,
  anon_sym_BANG = 35,
  anon_sym_TILDE = 36,
  anon_sym_STAR = 37,
  anon_sym_SLASH = 38,
  anon_sym_CARET = 39,
  anon_sym_LT = 40,
  anon_sym_GT = 41,
  anon_sym_LT_EQ = 42,
  anon_sym_GT_EQ = 43,
  anon_sym_EQ_EQ = 44,
  anon_sym_BANG_EQ = 45,
  anon_sym_PIPE_PIPE = 46,
  anon_sym_PIPE = 47,
  anon_sym_AMP_AMP = 48,
  anon_sym_AMP = 49,
  anon_sym_COLON = 50,
  sym_break = 51,
  sym_next = 52,
  sym_true = 53,
  sym_false = 54,
  sym_null = 55,
  sym_inf = 56,
  sym_nan = 57,
  anon_sym_NA = 58,
  anon_sym_NA_character_ = 59,
  anon_sym_NA_complex_ = 60,
  anon_sym_NA_integer_ = 61,
  anon_sym_NA_real_ = 62,
  aux_sym_identifier_token1 = 63,
  anon_sym_BQUOTE = 64,
  aux_sym_identifier_token2 = 65,
  sym_integer = 66,
  sym_float = 67,
  anon_sym_i = 68,
  sym_comment = 69,
  anon_sym_DQUOTE = 70,
  aux_sym_string_token1 = 71,
  anon_sym_SQUOTE = 72,
  aux_sym_string_token2 = 73,
  anon_sym_PERCENT = 74,
  aux_sym_special_token1 = 75,
  sym_escape_sequence = 76,
  sym_program = 77,
  sym_function_definition = 78,
  sym_lambda_function = 79,
  sym_if = 80,
  sym_while = 81,
  sym_repeat = 82,
  sym_for = 83,
  sym_switch = 84,
  sym_formal_parameters = 85,
  sym__formal_parameter = 86,
  sym_arguments = 87,
  sym__argument = 88,
  sym_call = 89,
  sym__assignment = 90,
  sym_left_assignment = 91,
  sym_left_assignment2 = 92,
  sym_equals_assignment = 93,
  sym_super_assignment = 94,
  sym_super_right_assignment = 95,
  sym_right_assignment = 96,
  sym_brace_list = 97,
  sym_paren_list = 98,
  sym_subset = 99,
  sym_subset2 = 100,
  sym_dollar = 101,
  sym_slot = 102,
  sym_namespace_get = 103,
  sym_namespace_get_internal = 104,
  sym_pipe = 105,
  sym_unary = 106,
  sym_binary = 107,
  sym_na = 108,
  sym__expression = 109,
  sym_identifier = 110,
  sym_complex = 111,
  sym_string = 112,
  sym_special = 113,
  aux_sym_program_repeat1 = 114,
  aux_sym_formal_parameters_repeat1 = 115,
  aux_sym_block_repeat1 = 116,
  aux_sym_arguments_repeat1 = 117,
  aux_sym_identifier_repeat1 = 118,
  aux_sym_string_repeat1 = 119,
  aux_sym_string_repeat2 = 120,
  aux_sym_special_repeat1 = 121,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_function] = "function",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_if] = "if",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_switch] = "switch",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [sym_dots] = "dots",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_AMP] = "&",
  [anon_sym_COLON] = ":",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_character_] = "NA_character_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_i] = "i",
  [sym_comment] = "comment",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_PERCENT] = "%",
  [aux_sym_special_token1] = "special_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_lambda_function] = "lambda_function",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_repeat] = "repeat",
  [sym_for] = "for",
  [sym_switch] = "switch",
  [sym_formal_parameters] = "formal_parameters",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_call] = "call",
  [sym__assignment] = "_assignment",
  [sym_left_assignment] = "left_assignment",
  [sym_left_assignment2] = "left_assignment2",
  [sym_equals_assignment] = "equals_assignment",
  [sym_super_assignment] = "super_assignment",
  [sym_super_right_assignment] = "super_right_assignment",
  [sym_right_assignment] = "right_assignment",
  [sym_brace_list] = "brace_list",
  [sym_paren_list] = "paren_list",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_dollar] = "dollar",
  [sym_slot] = "slot",
  [sym_namespace_get] = "namespace_get",
  [sym_namespace_get_internal] = "namespace_get_internal",
  [sym_pipe] = "pipe",
  [sym_unary] = "unary",
  [sym_binary] = "binary",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym_identifier] = "identifier",
  [sym_complex] = "complex",
  [sym_string] = "string",
  [sym_special] = "special",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_identifier_repeat1] = "identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_special_repeat1] = "special_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_LBRACK] = anon_sym_LBRACK_LBRACK,
  [anon_sym_RBRACK_RBRACK] = anon_sym_RBRACK_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [sym_dots] = sym_dots,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_i] = anon_sym_i,
  [sym_comment] = sym_comment,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [aux_sym_special_token1] = aux_sym_special_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_lambda_function] = sym_lambda_function,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_repeat] = sym_repeat,
  [sym_for] = sym_for,
  [sym_switch] = sym_switch,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_arguments] = sym_arguments,
  [sym__argument] = sym__argument,
  [sym_call] = sym_call,
  [sym__assignment] = sym__assignment,
  [sym_left_assignment] = sym_left_assignment,
  [sym_left_assignment2] = sym_left_assignment2,
  [sym_equals_assignment] = sym_equals_assignment,
  [sym_super_assignment] = sym_super_assignment,
  [sym_super_right_assignment] = sym_super_right_assignment,
  [sym_right_assignment] = sym_right_assignment,
  [sym_brace_list] = sym_brace_list,
  [sym_paren_list] = sym_paren_list,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_dollar] = sym_dollar,
  [sym_slot] = sym_slot,
  [sym_namespace_get] = sym_namespace_get,
  [sym_namespace_get_internal] = sym_namespace_get_internal,
  [sym_pipe] = sym_pipe,
  [sym_unary] = sym_unary,
  [sym_binary] = sym_binary,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym_identifier] = sym_identifier,
  [sym_complex] = sym_complex,
  [sym_string] = sym_string,
  [sym_special] = sym_special,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_identifier_repeat1] = aux_sym_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_special_repeat1] = aux_sym_special_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_special_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_function] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_left_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_assignment2] = {
    .visible = true,
    .named = true,
  },
  [sym_equals_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_super_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_right_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_list] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_list] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_dollar] = {
    .visible = true,
    .named = true,
  },
  [sym_slot] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_get_internal] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe] = {
    .visible = true,
    .named = true,
  },
  [sym_unary] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_special] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_special_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_function = 6,
  field_left = 7,
  field_name = 8,
  field_namespace = 9,
  field_operand = 10,
  field_operator = 11,
  field_right = 12,
  field_value = 13,
  field_vector = 14,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_value] = "value",
  [field_vector] = "vector",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 3},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 4},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 2},
  [15] = {.index = 27, .length = 2},
  [16] = {.index = 29, .length = 4},
  [17] = {.index = 33, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_operand, 1},
    {field_operator, 0},
  [3] =
    {field_function, 0},
  [4] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [6] =
    {field_value, 0},
  [7] =
    {field_name, 0},
    {field_value, 2},
  [9] =
    {field_name, 2},
    {field_value, 0},
  [11] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [14] =
    {field_function, 2},
    {field_namespace, 0},
  [16] =
    {field_name, 0},
  [17] =
    {field_arguments, 2},
    {field_function, 0},
  [19] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 2},
    {field_consequence, 4},
  [25] =
    {field_body, 4},
    {field_condition, 2},
  [27] =
    {field_body, 4},
    {field_value, 2},
  [29] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 2},
    {field_consequence, 4},
  [33] =
    {field_body, 6},
    {field_name, 2},
    {field_vector, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(222);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(223);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(224);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(221);
      if (lookahead == '\r') ADVANCE(225);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(227);
      if (lookahead != 0) ADVANCE(221);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead == '\r') ADVANCE(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(214);
      if (lookahead == '\r') ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(218);
      if (lookahead == '\r') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0) ADVANCE(212);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0) ADVANCE(216);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 26:
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 27:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(27)
      END_STATE();
    case 28:
      if (lookahead == '!') ADVANCE(32);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(206);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(28)
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '.') ADVANCE(118);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 33:
      if (lookahead == ']') ADVANCE(79);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == '}') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 47:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(47)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 48:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 49:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(104);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(207);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(88);
      if (lookahead == '"') ADVANCE(209);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '%') ADVANCE(217);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '\'') ADVANCE(213);
      if (lookahead == '(') ADVANCE(58);
      if (lookahead == ')') ADVANCE(59);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(87);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(201);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(54);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(94);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 'F') ADVANCE(120);
      if (lookahead == 'I') ADVANCE(170);
      if (lookahead == 'N') ADVANCE(121);
      if (lookahead == 'T') ADVANCE(128);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '`') ADVANCE(195);
      if (lookahead == 'b') ADVANCE(179);
      if (lookahead == 'f') ADVANCE(174);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(144);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == 's') ADVANCE(190);
      if (lookahead == 'w') ADVANCE(159);
      if (lookahead == '{') ADVANCE(69);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(70);
      if (lookahead == '~') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(53);
      if (lookahead == '.') ADVANCE(117);
      if (lookahead == '0') ADVANCE(201);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_repeat);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_switch);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[') ADVANCE(78);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(83);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_dots);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(75);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '<') ADVANCE(31);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(85);
      if (lookahead == '|') ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(101);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(82);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(72);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_break);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_next);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_inf);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_nan);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(140);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(124);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'A') ADVANCE(112);
      if (lookahead == 'U') ADVANCE(126);
      if (lookahead == 'a') ADVANCE(127);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(107);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'E') ADVANCE(108);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(129);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(109);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'L') ADVANCE(125);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'R') ADVANCE(130);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'S') ADVANCE(123);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'U') ADVANCE(122);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(116);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(115);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '_') ADVANCE(113);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(164);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(182);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(166);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(185);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(143);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(160);
      if (lookahead == 'i') ADVANCE(173);
      if (lookahead == 'r') ADVANCE(153);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(189);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(191);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(177);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(135);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(157);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(192);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(138);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(110);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(162);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'h') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(169);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(175);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'k') ADVANCE(105);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(183);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(131);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(148);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(150);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'm') ADVANCE(176);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(142);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(188);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(178);
      if (lookahead == 'u') ADVANCE(171);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(172);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(168);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'p') ADVANCE(151);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(64);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(139);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(147);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(106);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(141);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(161);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(149);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 't') ADVANCE(154);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'w') ADVANCE(163);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(184);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'x') ADVANCE(132);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      if (lookahead == '.' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead == '#') ADVANCE(198);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_identifier_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(199);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'L') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_i);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(211);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"') ADVANCE(212);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(216);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(215);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(216);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_special_token1);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%') ADVANCE(220);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_special_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(210);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(214);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(196);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(218);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(221);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(226);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 51},
  [2] = {.lex_state = 51},
  [3] = {.lex_state = 22},
  [4] = {.lex_state = 51},
  [5] = {.lex_state = 22},
  [6] = {.lex_state = 51},
  [7] = {.lex_state = 51},
  [8] = {.lex_state = 51},
  [9] = {.lex_state = 22},
  [10] = {.lex_state = 22},
  [11] = {.lex_state = 22},
  [12] = {.lex_state = 51},
  [13] = {.lex_state = 22},
  [14] = {.lex_state = 51},
  [15] = {.lex_state = 22},
  [16] = {.lex_state = 51},
  [17] = {.lex_state = 51},
  [18] = {.lex_state = 51},
  [19] = {.lex_state = 51},
  [20] = {.lex_state = 22},
  [21] = {.lex_state = 51},
  [22] = {.lex_state = 22},
  [23] = {.lex_state = 51},
  [24] = {.lex_state = 51},
  [25] = {.lex_state = 51},
  [26] = {.lex_state = 22},
  [27] = {.lex_state = 51},
  [28] = {.lex_state = 22},
  [29] = {.lex_state = 51},
  [30] = {.lex_state = 51},
  [31] = {.lex_state = 51},
  [32] = {.lex_state = 51},
  [33] = {.lex_state = 51},
  [34] = {.lex_state = 51},
  [35] = {.lex_state = 51},
  [36] = {.lex_state = 51},
  [37] = {.lex_state = 51},
  [38] = {.lex_state = 51},
  [39] = {.lex_state = 51},
  [40] = {.lex_state = 51},
  [41] = {.lex_state = 51},
  [42] = {.lex_state = 22},
  [43] = {.lex_state = 51},
  [44] = {.lex_state = 51},
  [45] = {.lex_state = 51},
  [46] = {.lex_state = 51},
  [47] = {.lex_state = 51},
  [48] = {.lex_state = 51},
  [49] = {.lex_state = 51},
  [50] = {.lex_state = 51},
  [51] = {.lex_state = 51},
  [52] = {.lex_state = 51},
  [53] = {.lex_state = 51},
  [54] = {.lex_state = 51},
  [55] = {.lex_state = 51},
  [56] = {.lex_state = 51},
  [57] = {.lex_state = 51},
  [58] = {.lex_state = 51},
  [59] = {.lex_state = 51},
  [60] = {.lex_state = 51},
  [61] = {.lex_state = 51},
  [62] = {.lex_state = 51},
  [63] = {.lex_state = 51},
  [64] = {.lex_state = 51},
  [65] = {.lex_state = 51},
  [66] = {.lex_state = 51},
  [67] = {.lex_state = 51},
  [68] = {.lex_state = 51},
  [69] = {.lex_state = 51},
  [70] = {.lex_state = 51},
  [71] = {.lex_state = 51},
  [72] = {.lex_state = 51},
  [73] = {.lex_state = 51},
  [74] = {.lex_state = 51},
  [75] = {.lex_state = 51},
  [76] = {.lex_state = 51},
  [77] = {.lex_state = 51},
  [78] = {.lex_state = 51},
  [79] = {.lex_state = 51},
  [80] = {.lex_state = 51},
  [81] = {.lex_state = 51},
  [82] = {.lex_state = 51},
  [83] = {.lex_state = 51},
  [84] = {.lex_state = 21},
  [85] = {.lex_state = 21},
  [86] = {.lex_state = 21},
  [87] = {.lex_state = 21},
  [88] = {.lex_state = 51},
  [89] = {.lex_state = 51},
  [90] = {.lex_state = 51},
  [91] = {.lex_state = 51},
  [92] = {.lex_state = 51},
  [93] = {.lex_state = 51},
  [94] = {.lex_state = 51},
  [95] = {.lex_state = 51},
  [96] = {.lex_state = 22},
  [97] = {.lex_state = 51},
  [98] = {.lex_state = 51},
  [99] = {.lex_state = 51},
  [100] = {.lex_state = 51},
  [101] = {.lex_state = 51},
  [102] = {.lex_state = 51},
  [103] = {.lex_state = 51},
  [104] = {.lex_state = 51},
  [105] = {.lex_state = 51},
  [106] = {.lex_state = 51},
  [107] = {.lex_state = 51},
  [108] = {.lex_state = 51},
  [109] = {.lex_state = 51},
  [110] = {.lex_state = 51},
  [111] = {.lex_state = 51},
  [112] = {.lex_state = 51},
  [113] = {.lex_state = 51},
  [114] = {.lex_state = 51},
  [115] = {.lex_state = 51},
  [116] = {.lex_state = 51},
  [117] = {.lex_state = 51},
  [118] = {.lex_state = 51},
  [119] = {.lex_state = 51},
  [120] = {.lex_state = 51},
  [121] = {.lex_state = 51},
  [122] = {.lex_state = 51},
  [123] = {.lex_state = 51},
  [124] = {.lex_state = 51},
  [125] = {.lex_state = 51},
  [126] = {.lex_state = 51},
  [127] = {.lex_state = 51},
  [128] = {.lex_state = 51},
  [129] = {.lex_state = 51},
  [130] = {.lex_state = 51},
  [131] = {.lex_state = 51},
  [132] = {.lex_state = 51},
  [133] = {.lex_state = 51},
  [134] = {.lex_state = 51},
  [135] = {.lex_state = 51},
  [136] = {.lex_state = 51},
  [137] = {.lex_state = 51},
  [138] = {.lex_state = 51},
  [139] = {.lex_state = 51},
  [140] = {.lex_state = 51},
  [141] = {.lex_state = 51},
  [142] = {.lex_state = 51},
  [143] = {.lex_state = 51},
  [144] = {.lex_state = 51},
  [145] = {.lex_state = 51},
  [146] = {.lex_state = 51},
  [147] = {.lex_state = 51},
  [148] = {.lex_state = 51},
  [149] = {.lex_state = 51},
  [150] = {.lex_state = 51},
  [151] = {.lex_state = 51},
  [152] = {.lex_state = 51},
  [153] = {.lex_state = 51},
  [154] = {.lex_state = 51},
  [155] = {.lex_state = 51},
  [156] = {.lex_state = 51},
  [157] = {.lex_state = 51},
  [158] = {.lex_state = 51},
  [159] = {.lex_state = 51},
  [160] = {.lex_state = 51},
  [161] = {.lex_state = 22},
  [162] = {.lex_state = 51},
  [163] = {.lex_state = 51},
  [164] = {.lex_state = 22},
  [165] = {.lex_state = 51},
  [166] = {.lex_state = 51},
  [167] = {.lex_state = 51},
  [168] = {.lex_state = 51},
  [169] = {.lex_state = 51},
  [170] = {.lex_state = 51},
  [171] = {.lex_state = 51},
  [172] = {.lex_state = 51},
  [173] = {.lex_state = 22},
  [174] = {.lex_state = 51},
  [175] = {.lex_state = 51},
  [176] = {.lex_state = 51},
  [177] = {.lex_state = 51},
  [178] = {.lex_state = 51},
  [179] = {.lex_state = 51},
  [180] = {.lex_state = 51},
  [181] = {.lex_state = 51},
  [182] = {.lex_state = 51},
  [183] = {.lex_state = 51},
  [184] = {.lex_state = 51},
  [185] = {.lex_state = 51},
  [186] = {.lex_state = 51},
  [187] = {.lex_state = 51},
  [188] = {.lex_state = 51},
  [189] = {.lex_state = 51},
  [190] = {.lex_state = 51},
  [191] = {.lex_state = 51},
  [192] = {.lex_state = 51},
  [193] = {.lex_state = 51},
  [194] = {.lex_state = 51},
  [195] = {.lex_state = 51},
  [196] = {.lex_state = 51},
  [197] = {.lex_state = 51},
  [198] = {.lex_state = 51},
  [199] = {.lex_state = 51},
  [200] = {.lex_state = 51},
  [201] = {.lex_state = 22},
  [202] = {.lex_state = 51},
  [203] = {.lex_state = 51},
  [204] = {.lex_state = 51},
  [205] = {.lex_state = 51},
  [206] = {.lex_state = 51},
  [207] = {.lex_state = 51},
  [208] = {.lex_state = 51},
  [209] = {.lex_state = 51},
  [210] = {.lex_state = 51},
  [211] = {.lex_state = 51},
  [212] = {.lex_state = 51},
  [213] = {.lex_state = 51},
  [214] = {.lex_state = 51},
  [215] = {.lex_state = 51},
  [216] = {.lex_state = 51},
  [217] = {.lex_state = 51},
  [218] = {.lex_state = 51},
  [219] = {.lex_state = 51},
  [220] = {.lex_state = 51},
  [221] = {.lex_state = 51},
  [222] = {.lex_state = 51},
  [223] = {.lex_state = 51},
  [224] = {.lex_state = 51},
  [225] = {.lex_state = 51},
  [226] = {.lex_state = 51},
  [227] = {.lex_state = 51},
  [228] = {.lex_state = 51},
  [229] = {.lex_state = 51},
  [230] = {.lex_state = 51},
  [231] = {.lex_state = 51},
  [232] = {.lex_state = 51},
  [233] = {.lex_state = 51},
  [234] = {.lex_state = 51},
  [235] = {.lex_state = 51},
  [236] = {.lex_state = 51},
  [237] = {.lex_state = 21},
  [238] = {.lex_state = 51},
  [239] = {.lex_state = 51},
  [240] = {.lex_state = 51},
  [241] = {.lex_state = 51},
  [242] = {.lex_state = 51},
  [243] = {.lex_state = 51},
  [244] = {.lex_state = 51},
  [245] = {.lex_state = 51},
  [246] = {.lex_state = 51},
  [247] = {.lex_state = 51},
  [248] = {.lex_state = 51},
  [249] = {.lex_state = 51},
  [250] = {.lex_state = 51},
  [251] = {.lex_state = 51},
  [252] = {.lex_state = 51},
  [253] = {.lex_state = 51},
  [254] = {.lex_state = 51},
  [255] = {.lex_state = 51},
  [256] = {.lex_state = 51},
  [257] = {.lex_state = 51},
  [258] = {.lex_state = 51},
  [259] = {.lex_state = 51},
  [260] = {.lex_state = 21},
  [261] = {.lex_state = 51},
  [262] = {.lex_state = 51},
  [263] = {.lex_state = 51},
  [264] = {.lex_state = 51},
  [265] = {.lex_state = 51},
  [266] = {.lex_state = 51},
  [267] = {.lex_state = 51},
  [268] = {.lex_state = 51},
  [269] = {.lex_state = 51},
  [270] = {.lex_state = 51},
  [271] = {.lex_state = 51},
  [272] = {.lex_state = 51},
  [273] = {.lex_state = 51},
  [274] = {.lex_state = 51},
  [275] = {.lex_state = 51},
  [276] = {.lex_state = 51},
  [277] = {.lex_state = 51},
  [278] = {.lex_state = 51},
  [279] = {.lex_state = 51},
  [280] = {.lex_state = 51},
  [281] = {.lex_state = 51},
  [282] = {.lex_state = 51},
  [283] = {.lex_state = 24},
  [284] = {.lex_state = 24},
  [285] = {.lex_state = 24},
  [286] = {.lex_state = 24},
  [287] = {.lex_state = 51},
  [288] = {.lex_state = 51},
  [289] = {.lex_state = 51},
  [290] = {.lex_state = 51},
  [291] = {.lex_state = 51},
  [292] = {.lex_state = 51},
  [293] = {.lex_state = 51},
  [294] = {.lex_state = 51},
  [295] = {.lex_state = 51},
  [296] = {.lex_state = 51},
  [297] = {.lex_state = 51},
  [298] = {.lex_state = 51},
  [299] = {.lex_state = 51},
  [300] = {.lex_state = 51},
  [301] = {.lex_state = 51},
  [302] = {.lex_state = 51},
  [303] = {.lex_state = 51},
  [304] = {.lex_state = 51},
  [305] = {.lex_state = 51},
  [306] = {.lex_state = 51},
  [307] = {.lex_state = 51},
  [308] = {.lex_state = 21},
  [309] = {.lex_state = 21},
  [310] = {.lex_state = 51},
  [311] = {.lex_state = 51},
  [312] = {.lex_state = 51},
  [313] = {.lex_state = 21},
  [314] = {.lex_state = 51},
  [315] = {.lex_state = 21},
  [316] = {.lex_state = 21},
  [317] = {.lex_state = 21},
  [318] = {.lex_state = 51},
  [319] = {.lex_state = 51},
  [320] = {.lex_state = 21},
  [321] = {.lex_state = 21},
  [322] = {.lex_state = 21},
  [323] = {.lex_state = 51},
  [324] = {.lex_state = 51},
  [325] = {.lex_state = 51},
  [326] = {.lex_state = 51},
  [327] = {.lex_state = 21},
  [328] = {.lex_state = 21},
  [329] = {.lex_state = 21},
  [330] = {.lex_state = 47},
  [331] = {.lex_state = 51},
  [332] = {.lex_state = 51},
  [333] = {.lex_state = 21},
  [334] = {.lex_state = 21},
  [335] = {.lex_state = 21},
  [336] = {.lex_state = 21},
  [337] = {.lex_state = 21},
  [338] = {.lex_state = 21},
  [339] = {.lex_state = 47},
  [340] = {.lex_state = 21},
  [341] = {.lex_state = 21},
  [342] = {.lex_state = 51},
  [343] = {.lex_state = 51},
  [344] = {.lex_state = 51},
  [345] = {.lex_state = 51},
  [346] = {.lex_state = 51},
  [347] = {.lex_state = 51},
  [348] = {.lex_state = 51},
  [349] = {.lex_state = 51},
  [350] = {.lex_state = 51},
  [351] = {.lex_state = 51},
  [352] = {.lex_state = 51},
  [353] = {.lex_state = 51},
  [354] = {.lex_state = 51},
  [355] = {.lex_state = 51},
  [356] = {.lex_state = 51},
  [357] = {.lex_state = 51},
  [358] = {.lex_state = 51},
  [359] = {.lex_state = 51},
  [360] = {.lex_state = 51},
  [361] = {.lex_state = 51},
  [362] = {.lex_state = 51},
  [363] = {.lex_state = 51},
  [364] = {.lex_state = 51},
  [365] = {.lex_state = 51},
  [366] = {.lex_state = 51},
  [367] = {.lex_state = 51},
  [368] = {.lex_state = 51},
  [369] = {.lex_state = 51},
  [370] = {.lex_state = 51},
  [371] = {.lex_state = 51},
  [372] = {.lex_state = 47},
  [373] = {.lex_state = 51},
  [374] = {.lex_state = 51},
  [375] = {.lex_state = 47},
  [376] = {.lex_state = 51},
  [377] = {.lex_state = 51},
  [378] = {.lex_state = 51},
  [379] = {.lex_state = 51},
  [380] = {.lex_state = 51},
  [381] = {.lex_state = 51},
  [382] = {.lex_state = 51},
  [383] = {.lex_state = 51},
  [384] = {.lex_state = 51},
  [385] = {.lex_state = 51},
  [386] = {.lex_state = 51},
  [387] = {.lex_state = 51},
  [388] = {.lex_state = 51},
  [389] = {.lex_state = 51},
  [390] = {.lex_state = 51},
  [391] = {.lex_state = 51},
  [392] = {.lex_state = 51},
  [393] = {.lex_state = 51},
  [394] = {.lex_state = 51},
  [395] = {.lex_state = 51},
  [396] = {.lex_state = 51},
  [397] = {.lex_state = 51},
  [398] = {.lex_state = 51},
  [399] = {.lex_state = 47},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 51},
  [402] = {.lex_state = 51},
  [403] = {.lex_state = 51},
  [404] = {.lex_state = 51},
  [405] = {.lex_state = 51},
  [406] = {.lex_state = 47},
  [407] = {.lex_state = 51},
  [408] = {.lex_state = 51},
  [409] = {.lex_state = 51},
  [410] = {.lex_state = 51},
  [411] = {.lex_state = 47},
  [412] = {.lex_state = 21},
  [413] = {.lex_state = 51},
  [414] = {.lex_state = 21},
  [415] = {.lex_state = 21},
  [416] = {.lex_state = 21},
  [417] = {.lex_state = 47},
  [418] = {.lex_state = 51},
  [419] = {.lex_state = 51},
  [420] = {.lex_state = 51},
  [421] = {.lex_state = 51},
  [422] = {.lex_state = 51},
  [423] = {.lex_state = 51},
  [424] = {.lex_state = 51},
  [425] = {.lex_state = 51},
  [426] = {.lex_state = 51},
  [427] = {.lex_state = 51},
  [428] = {.lex_state = 51},
  [429] = {.lex_state = 51},
  [430] = {.lex_state = 51},
  [431] = {.lex_state = 47},
  [432] = {.lex_state = 24},
  [433] = {.lex_state = 51},
  [434] = {.lex_state = 21},
  [435] = {.lex_state = 21},
  [436] = {.lex_state = 21},
  [437] = {.lex_state = 22},
  [438] = {.lex_state = 24},
  [439] = {.lex_state = 24},
  [440] = {.lex_state = 24},
  [441] = {.lex_state = 21},
  [442] = {.lex_state = 21},
  [443] = {.lex_state = 21},
  [444] = {.lex_state = 21},
  [445] = {.lex_state = 21},
  [446] = {.lex_state = 24},
  [447] = {.lex_state = 24},
  [448] = {.lex_state = 24},
  [449] = {.lex_state = 24},
  [450] = {.lex_state = 24},
  [451] = {.lex_state = 24},
  [452] = {.lex_state = 21},
  [453] = {.lex_state = 21},
  [454] = {.lex_state = 21},
  [455] = {.lex_state = 21},
  [456] = {.lex_state = 21},
  [457] = {.lex_state = 24},
  [458] = {.lex_state = 24},
  [459] = {.lex_state = 24},
  [460] = {.lex_state = 24},
  [461] = {.lex_state = 24},
  [462] = {.lex_state = 24},
  [463] = {.lex_state = 24},
  [464] = {.lex_state = 24},
  [465] = {.lex_state = 24},
  [466] = {.lex_state = 21},
  [467] = {.lex_state = 21},
  [468] = {.lex_state = 24},
  [469] = {.lex_state = 21},
  [470] = {.lex_state = 21},
  [471] = {.lex_state = 21},
  [472] = {.lex_state = 24},
  [473] = {.lex_state = 24},
  [474] = {.lex_state = 49},
  [475] = {.lex_state = 21},
  [476] = {.lex_state = 21},
  [477] = {.lex_state = 24},
  [478] = {.lex_state = 25},
  [479] = {.lex_state = 24},
  [480] = {.lex_state = 47},
  [481] = {.lex_state = 47},
  [482] = {.lex_state = 24},
  [483] = {.lex_state = 48},
  [484] = {.lex_state = 47},
  [485] = {.lex_state = 47},
  [486] = {.lex_state = 47},
  [487] = {.lex_state = 48},
  [488] = {.lex_state = 47},
  [489] = {.lex_state = 47},
  [490] = {.lex_state = 47},
  [491] = {.lex_state = 22},
  [492] = {.lex_state = 47},
  [493] = {.lex_state = 47},
  [494] = {.lex_state = 47},
  [495] = {.lex_state = 47},
  [496] = {.lex_state = 47},
  [497] = {.lex_state = 47},
  [498] = {.lex_state = 47},
  [499] = {.lex_state = 47},
  [500] = {.lex_state = 47},
  [501] = {.lex_state = 48},
  [502] = {.lex_state = 48},
  [503] = {.lex_state = 22},
  [504] = {.lex_state = 22},
  [505] = {.lex_state = 47},
  [506] = {.lex_state = 47},
  [507] = {.lex_state = 47},
  [508] = {.lex_state = 24},
  [509] = {.lex_state = 47},
  [510] = {.lex_state = 47},
  [511] = {.lex_state = 47},
  [512] = {.lex_state = 47},
  [513] = {.lex_state = 47},
  [514] = {.lex_state = 51},
  [515] = {.lex_state = 22},
  [516] = {.lex_state = 47},
  [517] = {.lex_state = 47},
  [518] = {.lex_state = 47},
  [519] = {.lex_state = 47},
  [520] = {.lex_state = 47},
  [521] = {.lex_state = 47},
  [522] = {.lex_state = 47},
  [523] = {.lex_state = 47},
  [524] = {.lex_state = 22},
  [525] = {.lex_state = 22},
  [526] = {.lex_state = 22},
  [527] = {.lex_state = 47},
  [528] = {.lex_state = 47},
  [529] = {.lex_state = 47},
  [530] = {.lex_state = 47},
  [531] = {.lex_state = 47},
  [532] = {.lex_state = 47},
  [533] = {.lex_state = 47},
  [534] = {.lex_state = 47},
  [535] = {.lex_state = 47},
  [536] = {.lex_state = 51},
  [537] = {.lex_state = 22},
  [538] = {.lex_state = 22},
  [539] = {.lex_state = 22},
  [540] = {.lex_state = 22},
  [541] = {.lex_state = 22},
  [542] = {.lex_state = 47},
  [543] = {.lex_state = 22},
  [544] = {.lex_state = 47},
  [545] = {.lex_state = 22},
  [546] = {.lex_state = 47},
  [547] = {.lex_state = 47},
  [548] = {.lex_state = 48},
  [549] = {.lex_state = 22},
  [550] = {.lex_state = 49},
  [551] = {.lex_state = 48},
  [552] = {.lex_state = 22},
  [553] = {.lex_state = 47},
  [554] = {.lex_state = 51},
  [555] = {.lex_state = 48},
  [556] = {.lex_state = 47},
  [557] = {.lex_state = 22},
  [558] = {.lex_state = 22},
  [559] = {.lex_state = 51},
  [560] = {.lex_state = 48},
  [561] = {.lex_state = 22},
  [562] = {.lex_state = 23},
  [563] = {.lex_state = 22},
  [564] = {.lex_state = 22},
  [565] = {.lex_state = 22},
  [566] = {.lex_state = 22},
  [567] = {.lex_state = 22},
  [568] = {.lex_state = 22},
  [569] = {.lex_state = 47},
  [570] = {.lex_state = 47},
  [571] = {.lex_state = 47},
  [572] = {.lex_state = 48},
  [573] = {.lex_state = 47},
  [574] = {.lex_state = 48},
  [575] = {.lex_state = 22},
  [576] = {.lex_state = 48},
  [577] = {.lex_state = 48},
  [578] = {.lex_state = 47},
  [579] = {.lex_state = 47},
  [580] = {.lex_state = 22},
  [581] = {.lex_state = 22},
  [582] = {.lex_state = 22},
  [583] = {.lex_state = 47},
  [584] = {.lex_state = 47},
  [585] = {.lex_state = 48},
  [586] = {.lex_state = 47},
  [587] = {.lex_state = 47},
  [588] = {.lex_state = 47},
  [589] = {.lex_state = 48},
  [590] = {.lex_state = 47},
  [591] = {.lex_state = 22},
  [592] = {.lex_state = 22},
  [593] = {.lex_state = 22},
  [594] = {.lex_state = 22},
  [595] = {.lex_state = 51},
  [596] = {.lex_state = 50},
  [597] = {.lex_state = 48},
  [598] = {.lex_state = 47},
  [599] = {.lex_state = 48},
  [600] = {.lex_state = 48},
  [601] = {.lex_state = 48},
  [602] = {.lex_state = 48},
  [603] = {.lex_state = 48},
  [604] = {.lex_state = 22},
  [605] = {.lex_state = 47},
  [606] = {.lex_state = 47},
  [607] = {.lex_state = 47},
  [608] = {.lex_state = 22},
  [609] = {.lex_state = 22},
  [610] = {.lex_state = 22},
  [611] = {.lex_state = 22},
  [612] = {.lex_state = 22},
  [613] = {.lex_state = 47},
  [614] = {.lex_state = 47},
  [615] = {.lex_state = 48},
  [616] = {.lex_state = 48},
  [617] = {.lex_state = 47},
  [618] = {.lex_state = 48},
  [619] = {.lex_state = 48},
  [620] = {.lex_state = 47},
  [621] = {.lex_state = 48},
  [622] = {.lex_state = 48},
  [623] = {.lex_state = 47},
  [624] = {.lex_state = 51},
  [625] = {.lex_state = 47},
  [626] = {.lex_state = 51},
  [627] = {.lex_state = 51},
  [628] = {.lex_state = 51},
  [629] = {.lex_state = 47},
  [630] = {.lex_state = 47},
  [631] = {.lex_state = 47},
  [632] = {.lex_state = 48},
  [633] = {.lex_state = 48},
  [634] = {.lex_state = 48},
  [635] = {.lex_state = 48},
  [636] = {.lex_state = 47},
  [637] = {.lex_state = 22},
  [638] = {.lex_state = 22},
  [639] = {.lex_state = 22},
  [640] = {.lex_state = 22},
  [641] = {.lex_state = 48},
  [642] = {.lex_state = 48},
  [643] = {.lex_state = 48},
  [644] = {.lex_state = 48},
  [645] = {.lex_state = 48},
  [646] = {.lex_state = 48},
  [647] = {.lex_state = 47},
  [648] = {.lex_state = 47},
  [649] = {.lex_state = 22},
  [650] = {.lex_state = 47},
  [651] = {.lex_state = 22},
  [652] = {.lex_state = 51},
  [653] = {.lex_state = 22},
  [654] = {.lex_state = 47},
  [655] = {.lex_state = 48},
  [656] = {.lex_state = 47},
  [657] = {.lex_state = 47},
  [658] = {.lex_state = 48},
  [659] = {.lex_state = 24},
  [660] = {.lex_state = 48},
  [661] = {.lex_state = 48},
  [662] = {.lex_state = 48},
  [663] = {.lex_state = 50},
  [664] = {.lex_state = 48},
  [665] = {.lex_state = 48},
  [666] = {.lex_state = 48},
  [667] = {.lex_state = 47},
  [668] = {.lex_state = 47},
  [669] = {.lex_state = 47},
  [670] = {.lex_state = 47},
  [671] = {.lex_state = 47},
  [672] = {.lex_state = 48},
  [673] = {.lex_state = 47},
  [674] = {.lex_state = 48},
  [675] = {.lex_state = 48},
  [676] = {.lex_state = 48},
  [677] = {.lex_state = 47},
  [678] = {.lex_state = 48},
  [679] = {.lex_state = 48},
  [680] = {.lex_state = 47},
  [681] = {.lex_state = 47},
  [682] = {.lex_state = 48},
  [683] = {.lex_state = 47},
  [684] = {.lex_state = 48},
  [685] = {.lex_state = 48},
  [686] = {.lex_state = 24},
  [687] = {.lex_state = 48},
  [688] = {.lex_state = 47},
  [689] = {.lex_state = 51},
  [690] = {.lex_state = 24},
  [691] = {.lex_state = 51},
  [692] = {.lex_state = 24},
  [693] = {.lex_state = 51},
  [694] = {.lex_state = 48},
  [695] = {.lex_state = 51},
  [696] = {.lex_state = 48},
  [697] = {.lex_state = 24},
  [698] = {.lex_state = 24},
  [699] = {.lex_state = 51},
  [700] = {.lex_state = 51},
  [701] = {.lex_state = 24},
  [702] = {.lex_state = 24},
  [703] = {.lex_state = 48},
  [704] = {.lex_state = 24},
  [705] = {.lex_state = 24},
  [706] = {.lex_state = 51},
  [707] = {.lex_state = 51},
  [708] = {.lex_state = 51},
  [709] = {.lex_state = 51},
  [710] = {.lex_state = 51},
  [711] = {.lex_state = 51},
  [712] = {.lex_state = 24},
  [713] = {.lex_state = 24},
  [714] = {.lex_state = 24},
  [715] = {.lex_state = 24},
  [716] = {.lex_state = 24},
  [717] = {.lex_state = 51},
  [718] = {.lex_state = 51},
  [719] = {.lex_state = 51},
  [720] = {.lex_state = 51},
  [721] = {.lex_state = 51},
  [722] = {.lex_state = 26},
  [723] = {.lex_state = 51},
  [724] = {.lex_state = 51},
  [725] = {.lex_state = 51},
  [726] = {.lex_state = 24},
  [727] = {.lex_state = 24},
  [728] = {.lex_state = 24},
  [729] = {.lex_state = 24},
  [730] = {.lex_state = 24},
  [731] = {.lex_state = 48},
  [732] = {.lex_state = 48},
  [733] = {.lex_state = 48},
  [734] = {.lex_state = 51},
  [735] = {.lex_state = 51},
  [736] = {.lex_state = 48},
  [737] = {.lex_state = 51},
  [738] = {.lex_state = 48},
  [739] = {.lex_state = 48},
  [740] = {.lex_state = 48},
  [741] = {.lex_state = 48},
  [742] = {.lex_state = 48},
  [743] = {.lex_state = 48},
  [744] = {.lex_state = 51},
  [745] = {.lex_state = 48},
  [746] = {.lex_state = 48},
  [747] = {.lex_state = 48},
  [748] = {.lex_state = 48},
  [749] = {.lex_state = 48},
  [750] = {.lex_state = 48},
  [751] = {.lex_state = 48},
  [752] = {.lex_state = 51},
  [753] = {.lex_state = 51},
  [754] = {.lex_state = 51},
  [755] = {.lex_state = 48},
  [756] = {.lex_state = 48},
  [757] = {.lex_state = 51},
  [758] = {.lex_state = 48},
  [759] = {.lex_state = 48},
  [760] = {.lex_state = 48},
  [761] = {.lex_state = 51},
  [762] = {.lex_state = 48},
  [763] = {.lex_state = 48},
  [764] = {.lex_state = 48},
  [765] = {.lex_state = 51},
  [766] = {.lex_state = 51},
  [767] = {.lex_state = 51},
  [768] = {.lex_state = 48},
  [769] = {.lex_state = 48},
  [770] = {.lex_state = 51},
  [771] = {.lex_state = 51},
  [772] = {.lex_state = 51},
  [773] = {.lex_state = 48},
  [774] = {.lex_state = 48},
  [775] = {.lex_state = 48},
  [776] = {.lex_state = 48},
  [777] = {.lex_state = 48},
  [778] = {.lex_state = 51},
  [779] = {.lex_state = 48},
  [780] = {.lex_state = 48},
  [781] = {.lex_state = 48},
  [782] = {.lex_state = 51},
  [783] = {.lex_state = 48},
  [784] = {.lex_state = 48},
  [785] = {.lex_state = 48},
  [786] = {.lex_state = 48},
  [787] = {.lex_state = 51},
  [788] = {.lex_state = 51},
  [789] = {.lex_state = 51},
  [790] = {.lex_state = 51},
  [791] = {.lex_state = 51},
  [792] = {.lex_state = 48},
  [793] = {.lex_state = 48},
  [794] = {.lex_state = 27},
  [795] = {.lex_state = 22},
  [796] = {.lex_state = 27},
  [797] = {.lex_state = 27},
  [798] = {.lex_state = 51},
  [799] = {.lex_state = 27},
  [800] = {.lex_state = 27},
  [801] = {.lex_state = 27},
  [802] = {.lex_state = 27},
  [803] = {.lex_state = 28},
  [804] = {.lex_state = 27},
  [805] = {.lex_state = 51},
  [806] = {.lex_state = 27},
  [807] = {.lex_state = 27},
  [808] = {.lex_state = 27},
  [809] = {.lex_state = 27},
  [810] = {.lex_state = 51},
  [811] = {.lex_state = 27},
  [812] = {.lex_state = 27},
  [813] = {.lex_state = 27},
  [814] = {.lex_state = 27},
  [815] = {.lex_state = 27},
  [816] = {.lex_state = 27},
  [817] = {.lex_state = 27},
  [818] = {.lex_state = 27},
  [819] = {.lex_state = 27},
  [820] = {.lex_state = 27},
  [821] = {.lex_state = 27},
  [822] = {.lex_state = 27},
  [823] = {.lex_state = 27},
  [824] = {.lex_state = 27},
  [825] = {.lex_state = 27},
  [826] = {.lex_state = 27},
  [827] = {.lex_state = 27},
  [828] = {.lex_state = 27},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 27},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 27},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 51},
  [841] = {.lex_state = 51},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 51},
  [846] = {.lex_state = 27},
  [847] = {.lex_state = 27},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 27},
  [850] = {.lex_state = 51},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 27},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 27},
  [855] = {.lex_state = 27},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 51},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 28},
  [861] = {.lex_state = 27},
  [862] = {.lex_state = 27},
  [863] = {.lex_state = 27},
  [864] = {.lex_state = 27},
  [865] = {.lex_state = 27},
  [866] = {.lex_state = 27},
  [867] = {.lex_state = 27},
  [868] = {.lex_state = 27},
  [869] = {.lex_state = 27},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 27},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 51},
  [877] = {.lex_state = 27},
  [878] = {.lex_state = 27},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 29},
  [930] = {.lex_state = 29},
  [931] = {.lex_state = 29},
  [932] = {.lex_state = 29},
  [933] = {.lex_state = 30},
  [934] = {.lex_state = 30},
  [935] = {.lex_state = 30},
  [936] = {.lex_state = 30},
  [937] = {.lex_state = 30},
  [938] = {.lex_state = 30},
  [939] = {.lex_state = 30},
  [940] = {.lex_state = 30},
  [941] = {.lex_state = 30},
  [942] = {.lex_state = 13},
  [943] = {.lex_state = 13},
  [944] = {.lex_state = 16},
  [945] = {.lex_state = 18},
  [946] = {.lex_state = 13},
  [947] = {.lex_state = 16},
  [948] = {.lex_state = 18},
  [949] = {.lex_state = 13},
  [950] = {.lex_state = 16},
  [951] = {.lex_state = 18},
  [952] = {.lex_state = 13},
  [953] = {.lex_state = 16},
  [954] = {.lex_state = 16},
  [955] = {.lex_state = 13},
  [956] = {.lex_state = 18},
  [957] = {.lex_state = 13},
  [958] = {.lex_state = 16},
  [959] = {.lex_state = 18},
  [960] = {.lex_state = 20},
  [961] = {.lex_state = 18},
  [962] = {.lex_state = 13},
  [963] = {.lex_state = 16},
  [964] = {.lex_state = 18},
  [965] = {.lex_state = 18},
  [966] = {.lex_state = 16},
  [967] = {.lex_state = 13},
  [968] = {.lex_state = 18},
  [969] = {.lex_state = 13},
  [970] = {.lex_state = 16},
  [971] = {.lex_state = 16},
  [972] = {.lex_state = 13},
  [973] = {.lex_state = 20},
  [974] = {.lex_state = 16},
  [975] = {.lex_state = 18},
  [976] = {.lex_state = 13},
  [977] = {.lex_state = 18},
  [978] = {.lex_state = 18},
  [979] = {.lex_state = 13},
  [980] = {.lex_state = 16},
  [981] = {.lex_state = 16},
  [982] = {.lex_state = 18},
  [983] = {.lex_state = 13},
  [984] = {.lex_state = 16},
  [985] = {.lex_state = 16},
  [986] = {.lex_state = 18},
  [987] = {.lex_state = 16},
  [988] = {.lex_state = 13},
  [989] = {.lex_state = 18},
  [990] = {.lex_state = 13},
  [991] = {.lex_state = 16},
  [992] = {.lex_state = 13},
  [993] = {.lex_state = 18},
  [994] = {.lex_state = 13},
  [995] = {.lex_state = 16},
  [996] = {.lex_state = 18},
  [997] = {.lex_state = 13},
  [998] = {.lex_state = 16},
  [999] = {.lex_state = 18},
  [1000] = {.lex_state = 20},
  [1001] = {.lex_state = 18},
  [1002] = {.lex_state = 30},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 30},
  [1005] = {.lex_state = 30},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 30},
  [1008] = {.lex_state = 30},
  [1009] = {.lex_state = 30},
  [1010] = {.lex_state = 30},
  [1011] = {.lex_state = 30},
  [1012] = {.lex_state = 30},
  [1013] = {.lex_state = 30},
  [1014] = {.lex_state = 30},
  [1015] = {.lex_state = 30},
  [1016] = {.lex_state = 30},
  [1017] = {.lex_state = 30},
  [1018] = {.lex_state = 30},
  [1019] = {.lex_state = 30},
  [1020] = {.lex_state = 30},
  [1021] = {.lex_state = 30},
  [1022] = {.lex_state = 30},
  [1023] = {.lex_state = 30},
  [1024] = {.lex_state = 30},
  [1025] = {.lex_state = 30},
  [1026] = {.lex_state = 30},
  [1027] = {.lex_state = 30},
  [1028] = {.lex_state = 30},
  [1029] = {.lex_state = 30},
  [1030] = {.lex_state = 30},
  [1031] = {.lex_state = 30},
  [1032] = {.lex_state = 30},
  [1033] = {.lex_state = 30},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 30},
  [1036] = {.lex_state = 30},
  [1037] = {.lex_state = 30},
  [1038] = {.lex_state = 30},
  [1039] = {.lex_state = 30},
  [1040] = {.lex_state = 30},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 30},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 27},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 27},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 51},
  [1078] = {.lex_state = 51},
  [1079] = {.lex_state = 27},
  [1080] = {.lex_state = 51},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 27},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 27},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 51},
  [1091] = {.lex_state = 27},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 27},
  [1096] = {.lex_state = 51},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 27},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 27},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 27},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 51},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 51},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 51},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 51},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [aux_sym_identifier_token1] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1127),
    [sym_function_definition] = STATE(603),
    [sym_lambda_function] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_repeat] = STATE(603),
    [sym_for] = STATE(603),
    [sym_switch] = STATE(603),
    [sym_call] = STATE(603),
    [sym__assignment] = STATE(603),
    [sym_left_assignment] = STATE(603),
    [sym_left_assignment2] = STATE(603),
    [sym_equals_assignment] = STATE(603),
    [sym_super_assignment] = STATE(603),
    [sym_super_right_assignment] = STATE(603),
    [sym_right_assignment] = STATE(603),
    [sym_brace_list] = STATE(603),
    [sym_paren_list] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_dollar] = STATE(603),
    [sym_slot] = STATE(603),
    [sym_namespace_get] = STATE(603),
    [sym_namespace_get_internal] = STATE(603),
    [sym_pipe] = STATE(603),
    [sym_unary] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(603),
    [sym_string] = STATE(603),
    [aux_sym_program_repeat1] = STATE(70),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [2] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1090),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(69),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [3] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(15),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(113),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(103),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [4] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1104),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(139),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [5] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1098),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(143),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [6] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1122),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(145),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [7] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1115),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(147),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [8] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1070),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [9] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1082),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(151),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [10] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1071),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(153),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [11] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1112),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(155),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [12] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1108),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(157),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [13] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1109),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(159),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [14] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1110),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(161),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [15] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(15),
    [anon_sym_SEMI] = ACTIONS(163),
    [anon_sym_function] = ACTIONS(166),
    [anon_sym_BSLASH] = ACTIONS(169),
    [anon_sym_if] = ACTIONS(172),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_RPAREN] = ACTIONS(178),
    [anon_sym_while] = ACTIONS(180),
    [anon_sym_repeat] = ACTIONS(183),
    [anon_sym_for] = ACTIONS(186),
    [anon_sym_switch] = ACTIONS(189),
    [anon_sym_COMMA] = ACTIONS(192),
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_RBRACK] = ACTIONS(178),
    [sym_dots] = ACTIONS(198),
    [anon_sym_DASH] = ACTIONS(201),
    [anon_sym_PLUS] = ACTIONS(201),
    [anon_sym_BANG] = ACTIONS(204),
    [anon_sym_TILDE] = ACTIONS(207),
    [sym_break] = ACTIONS(210),
    [sym_next] = ACTIONS(210),
    [sym_true] = ACTIONS(210),
    [sym_false] = ACTIONS(210),
    [sym_null] = ACTIONS(210),
    [sym_inf] = ACTIONS(210),
    [sym_nan] = ACTIONS(210),
    [anon_sym_NA] = ACTIONS(213),
    [anon_sym_NA_character_] = ACTIONS(213),
    [anon_sym_NA_complex_] = ACTIONS(213),
    [anon_sym_NA_integer_] = ACTIONS(213),
    [anon_sym_NA_real_] = ACTIONS(213),
    [aux_sym_identifier_token1] = ACTIONS(216),
    [anon_sym_BQUOTE] = ACTIONS(219),
    [sym_integer] = ACTIONS(163),
    [sym_float] = ACTIONS(222),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_SQUOTE] = ACTIONS(228),
  },
  [16] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1077),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(231),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [17] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1119),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(233),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [18] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1084),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(235),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [19] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1121),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(237),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [20] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1124),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(239),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [21] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1125),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(241),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [22] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1086),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(243),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [23] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1078),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(245),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [24] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1080),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(247),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [25] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1073),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [26] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1088),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(251),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [27] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1130),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(253),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [28] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1131),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [anon_sym_RBRACK] = ACTIONS(255),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [29] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1132),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(257),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [30] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym_arguments] = STATE(1096),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(35),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(259),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [31] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1102),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [32] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1118),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [33] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1100),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [34] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_function] = ACTIONS(264),
    [anon_sym_BSLASH] = ACTIONS(267),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_while] = ACTIONS(276),
    [anon_sym_repeat] = ACTIONS(279),
    [anon_sym_for] = ACTIONS(282),
    [anon_sym_switch] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(288),
    [anon_sym_LBRACE] = ACTIONS(291),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(178),
    [sym_dots] = ACTIONS(294),
    [anon_sym_DASH] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(297),
    [anon_sym_BANG] = ACTIONS(300),
    [anon_sym_TILDE] = ACTIONS(303),
    [sym_break] = ACTIONS(306),
    [sym_next] = ACTIONS(306),
    [sym_true] = ACTIONS(306),
    [sym_false] = ACTIONS(306),
    [sym_null] = ACTIONS(306),
    [sym_inf] = ACTIONS(306),
    [sym_nan] = ACTIONS(306),
    [anon_sym_NA] = ACTIONS(309),
    [anon_sym_NA_character_] = ACTIONS(309),
    [anon_sym_NA_complex_] = ACTIONS(309),
    [anon_sym_NA_integer_] = ACTIONS(309),
    [anon_sym_NA_real_] = ACTIONS(309),
    [aux_sym_identifier_token1] = ACTIONS(312),
    [anon_sym_BQUOTE] = ACTIONS(315),
    [sym_integer] = ACTIONS(261),
    [sym_float] = ACTIONS(318),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(324),
  },
  [35] = {
    [sym_function_definition] = STATE(595),
    [sym_lambda_function] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_repeat] = STATE(595),
    [sym_for] = STATE(595),
    [sym_switch] = STATE(595),
    [sym__argument] = STATE(798),
    [sym_call] = STATE(595),
    [sym__assignment] = STATE(595),
    [sym_left_assignment] = STATE(595),
    [sym_left_assignment2] = STATE(595),
    [sym_equals_assignment] = STATE(595),
    [sym_super_assignment] = STATE(595),
    [sym_super_right_assignment] = STATE(595),
    [sym_right_assignment] = STATE(595),
    [sym_brace_list] = STATE(595),
    [sym_paren_list] = STATE(595),
    [sym_subset] = STATE(595),
    [sym_subset2] = STATE(595),
    [sym_dollar] = STATE(595),
    [sym_slot] = STATE(595),
    [sym_namespace_get] = STATE(595),
    [sym_namespace_get_internal] = STATE(595),
    [sym_pipe] = STATE(595),
    [sym_unary] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_na] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_identifier] = STATE(559),
    [sym_complex] = STATE(595),
    [sym_string] = STATE(788),
    [aux_sym_arguments_repeat1] = STATE(34),
    [anon_sym_SEMI] = ACTIONS(47),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_COMMA] = ACTIONS(327),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(103),
    [sym_dots] = ACTIONS(71),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_true] = ACTIONS(79),
    [sym_false] = ACTIONS(79),
    [sym_null] = ACTIONS(79),
    [sym_inf] = ACTIONS(79),
    [sym_nan] = ACTIONS(79),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(47),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [36] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1074),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [37] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1116),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [38] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1094),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [39] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1069),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [40] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1107),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [41] = {
    [sym_function_definition] = STATE(437),
    [sym_lambda_function] = STATE(437),
    [sym_if] = STATE(437),
    [sym_while] = STATE(437),
    [sym_repeat] = STATE(437),
    [sym_for] = STATE(437),
    [sym_switch] = STATE(437),
    [sym_arguments] = STATE(1128),
    [sym__argument] = STATE(795),
    [sym_call] = STATE(437),
    [sym__assignment] = STATE(437),
    [sym_left_assignment] = STATE(437),
    [sym_left_assignment2] = STATE(437),
    [sym_equals_assignment] = STATE(437),
    [sym_super_assignment] = STATE(437),
    [sym_super_right_assignment] = STATE(437),
    [sym_right_assignment] = STATE(437),
    [sym_brace_list] = STATE(437),
    [sym_paren_list] = STATE(437),
    [sym_subset] = STATE(437),
    [sym_subset2] = STATE(437),
    [sym_dollar] = STATE(437),
    [sym_slot] = STATE(437),
    [sym_namespace_get] = STATE(437),
    [sym_namespace_get_internal] = STATE(437),
    [sym_pipe] = STATE(437),
    [sym_unary] = STATE(437),
    [sym_binary] = STATE(437),
    [sym_na] = STATE(437),
    [sym__expression] = STATE(437),
    [sym_identifier] = STATE(96),
    [sym_complex] = STATE(437),
    [sym_string] = STATE(604),
    [aux_sym_arguments_repeat1] = STATE(3),
    [anon_sym_SEMI] = ACTIONS(93),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_COMMA] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(117),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(125),
    [sym_next] = ACTIONS(125),
    [sym_true] = ACTIONS(125),
    [sym_false] = ACTIONS(125),
    [sym_null] = ACTIONS(125),
    [sym_inf] = ACTIONS(125),
    [sym_nan] = ACTIONS(125),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(93),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [42] = {
    [sym_function_definition] = STATE(561),
    [sym_lambda_function] = STATE(561),
    [sym_if] = STATE(561),
    [sym_while] = STATE(561),
    [sym_repeat] = STATE(561),
    [sym_for] = STATE(561),
    [sym_switch] = STATE(561),
    [sym_call] = STATE(561),
    [sym__assignment] = STATE(561),
    [sym_left_assignment] = STATE(561),
    [sym_left_assignment2] = STATE(561),
    [sym_equals_assignment] = STATE(561),
    [sym_super_assignment] = STATE(561),
    [sym_super_right_assignment] = STATE(561),
    [sym_right_assignment] = STATE(561),
    [sym_brace_list] = STATE(561),
    [sym_paren_list] = STATE(561),
    [sym_subset] = STATE(561),
    [sym_subset2] = STATE(561),
    [sym_dollar] = STATE(561),
    [sym_slot] = STATE(561),
    [sym_namespace_get] = STATE(561),
    [sym_namespace_get_internal] = STATE(561),
    [sym_pipe] = STATE(561),
    [sym_unary] = STATE(561),
    [sym_binary] = STATE(561),
    [sym_na] = STATE(561),
    [sym__expression] = STATE(561),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(561),
    [sym_string] = STATE(561),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_BSLASH] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_RBRACK] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(329),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(329),
    [anon_sym_TILDE] = ACTIONS(329),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
  },
  [43] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(353),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [44] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(64),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(375),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [45] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(51),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(379),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [46] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(383),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [47] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(62),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [48] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [49] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(46),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(389),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [50] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(48),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [51] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [52] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(395),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [53] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(397),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [54] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(60),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [55] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(61),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(401),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [56] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(403),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [57] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [58] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(56),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(407),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [59] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(57),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [60] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(411),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [61] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(413),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [62] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(415),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [63] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(69),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [64] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(419),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [65] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [66] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(52),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(423),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [67] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(65),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [68] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(43),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(427),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [69] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [70] = {
    [sym_function_definition] = STATE(603),
    [sym_lambda_function] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_repeat] = STATE(603),
    [sym_for] = STATE(603),
    [sym_switch] = STATE(603),
    [sym_call] = STATE(603),
    [sym__assignment] = STATE(603),
    [sym_left_assignment] = STATE(603),
    [sym_left_assignment2] = STATE(603),
    [sym_equals_assignment] = STATE(603),
    [sym_super_assignment] = STATE(603),
    [sym_super_right_assignment] = STATE(603),
    [sym_right_assignment] = STATE(603),
    [sym_brace_list] = STATE(603),
    [sym_paren_list] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_dollar] = STATE(603),
    [sym_slot] = STATE(603),
    [sym_namespace_get] = STATE(603),
    [sym_namespace_get_internal] = STATE(603),
    [sym_pipe] = STATE(603),
    [sym_unary] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(603),
    [sym_string] = STATE(603),
    [aux_sym_program_repeat1] = STATE(71),
    [ts_builtin_sym_end] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(27),
    [sym_next] = ACTIONS(27),
    [sym_true] = ACTIONS(27),
    [sym_false] = ACTIONS(27),
    [sym_null] = ACTIONS(27),
    [sym_inf] = ACTIONS(27),
    [sym_nan] = ACTIONS(27),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(7),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [71] = {
    [sym_function_definition] = STATE(603),
    [sym_lambda_function] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_repeat] = STATE(603),
    [sym_for] = STATE(603),
    [sym_switch] = STATE(603),
    [sym_call] = STATE(603),
    [sym__assignment] = STATE(603),
    [sym_left_assignment] = STATE(603),
    [sym_left_assignment2] = STATE(603),
    [sym_equals_assignment] = STATE(603),
    [sym_super_assignment] = STATE(603),
    [sym_super_right_assignment] = STATE(603),
    [sym_right_assignment] = STATE(603),
    [sym_brace_list] = STATE(603),
    [sym_paren_list] = STATE(603),
    [sym_subset] = STATE(603),
    [sym_subset2] = STATE(603),
    [sym_dollar] = STATE(603),
    [sym_slot] = STATE(603),
    [sym_namespace_get] = STATE(603),
    [sym_namespace_get_internal] = STATE(603),
    [sym_pipe] = STATE(603),
    [sym_unary] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_na] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(603),
    [sym_string] = STATE(603),
    [aux_sym_program_repeat1] = STATE(71),
    [ts_builtin_sym_end] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(438),
    [anon_sym_BSLASH] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(444),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_while] = ACTIONS(450),
    [anon_sym_repeat] = ACTIONS(453),
    [anon_sym_for] = ACTIONS(456),
    [anon_sym_switch] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(462),
    [sym_dots] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(468),
    [anon_sym_PLUS] = ACTIONS(468),
    [anon_sym_BANG] = ACTIONS(471),
    [anon_sym_TILDE] = ACTIONS(474),
    [sym_break] = ACTIONS(465),
    [sym_next] = ACTIONS(465),
    [sym_true] = ACTIONS(465),
    [sym_false] = ACTIONS(465),
    [sym_null] = ACTIONS(465),
    [sym_inf] = ACTIONS(465),
    [sym_nan] = ACTIONS(465),
    [anon_sym_NA] = ACTIONS(477),
    [anon_sym_NA_character_] = ACTIONS(477),
    [anon_sym_NA_complex_] = ACTIONS(477),
    [anon_sym_NA_integer_] = ACTIONS(477),
    [anon_sym_NA_real_] = ACTIONS(477),
    [aux_sym_identifier_token1] = ACTIONS(480),
    [anon_sym_BQUOTE] = ACTIONS(483),
    [sym_integer] = ACTIONS(435),
    [sym_float] = ACTIONS(486),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(492),
  },
  [72] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(495),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [73] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(497),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [74] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(72),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(499),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [75] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(73),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [76] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(53),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(503),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [77] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(505),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [78] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(507),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [79] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(79),
    [anon_sym_SEMI] = ACTIONS(509),
    [anon_sym_function] = ACTIONS(512),
    [anon_sym_BSLASH] = ACTIONS(515),
    [anon_sym_if] = ACTIONS(518),
    [anon_sym_LPAREN] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(524),
    [anon_sym_repeat] = ACTIONS(527),
    [anon_sym_for] = ACTIONS(530),
    [anon_sym_switch] = ACTIONS(533),
    [anon_sym_LBRACE] = ACTIONS(536),
    [anon_sym_RBRACE] = ACTIONS(433),
    [sym_dots] = ACTIONS(539),
    [anon_sym_DASH] = ACTIONS(542),
    [anon_sym_PLUS] = ACTIONS(542),
    [anon_sym_BANG] = ACTIONS(545),
    [anon_sym_TILDE] = ACTIONS(548),
    [sym_break] = ACTIONS(539),
    [sym_next] = ACTIONS(539),
    [sym_true] = ACTIONS(539),
    [sym_false] = ACTIONS(539),
    [sym_null] = ACTIONS(539),
    [sym_inf] = ACTIONS(539),
    [sym_nan] = ACTIONS(539),
    [anon_sym_NA] = ACTIONS(551),
    [anon_sym_NA_character_] = ACTIONS(551),
    [anon_sym_NA_complex_] = ACTIONS(551),
    [anon_sym_NA_integer_] = ACTIONS(551),
    [anon_sym_NA_real_] = ACTIONS(551),
    [aux_sym_identifier_token1] = ACTIONS(554),
    [anon_sym_BQUOTE] = ACTIONS(557),
    [sym_integer] = ACTIONS(509),
    [sym_float] = ACTIONS(560),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(563),
    [anon_sym_SQUOTE] = ACTIONS(566),
  },
  [80] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(80),
    [anon_sym_SEMI] = ACTIONS(569),
    [anon_sym_function] = ACTIONS(572),
    [anon_sym_BSLASH] = ACTIONS(575),
    [anon_sym_if] = ACTIONS(578),
    [anon_sym_LPAREN] = ACTIONS(581),
    [anon_sym_RPAREN] = ACTIONS(584),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_repeat] = ACTIONS(589),
    [anon_sym_for] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(595),
    [anon_sym_LBRACE] = ACTIONS(598),
    [sym_dots] = ACTIONS(601),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_BANG] = ACTIONS(607),
    [anon_sym_TILDE] = ACTIONS(610),
    [sym_break] = ACTIONS(601),
    [sym_next] = ACTIONS(601),
    [sym_true] = ACTIONS(601),
    [sym_false] = ACTIONS(601),
    [sym_null] = ACTIONS(601),
    [sym_inf] = ACTIONS(601),
    [sym_nan] = ACTIONS(601),
    [anon_sym_NA] = ACTIONS(613),
    [anon_sym_NA_character_] = ACTIONS(613),
    [anon_sym_NA_complex_] = ACTIONS(613),
    [anon_sym_NA_integer_] = ACTIONS(613),
    [anon_sym_NA_real_] = ACTIONS(613),
    [aux_sym_identifier_token1] = ACTIONS(616),
    [anon_sym_BQUOTE] = ACTIONS(619),
    [sym_integer] = ACTIONS(569),
    [sym_float] = ACTIONS(622),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(625),
    [anon_sym_SQUOTE] = ACTIONS(628),
  },
  [81] = {
    [sym_function_definition] = STATE(765),
    [sym_lambda_function] = STATE(765),
    [sym_if] = STATE(765),
    [sym_while] = STATE(765),
    [sym_repeat] = STATE(765),
    [sym_for] = STATE(765),
    [sym_switch] = STATE(765),
    [sym_call] = STATE(765),
    [sym__assignment] = STATE(765),
    [sym_left_assignment] = STATE(765),
    [sym_left_assignment2] = STATE(765),
    [sym_equals_assignment] = STATE(765),
    [sym_super_assignment] = STATE(765),
    [sym_super_right_assignment] = STATE(765),
    [sym_right_assignment] = STATE(765),
    [sym_brace_list] = STATE(765),
    [sym_paren_list] = STATE(765),
    [sym_subset] = STATE(765),
    [sym_subset2] = STATE(765),
    [sym_dollar] = STATE(765),
    [sym_slot] = STATE(765),
    [sym_namespace_get] = STATE(765),
    [sym_namespace_get_internal] = STATE(765),
    [sym_pipe] = STATE(765),
    [sym_unary] = STATE(765),
    [sym_binary] = STATE(765),
    [sym_na] = STATE(765),
    [sym__expression] = STATE(765),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(765),
    [sym_string] = STATE(765),
    [aux_sym_block_repeat1] = STATE(78),
    [anon_sym_SEMI] = ACTIONS(377),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_RPAREN] = ACTIONS(631),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(377),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [82] = {
    [sym_function_definition] = STATE(652),
    [sym_lambda_function] = STATE(652),
    [sym_if] = STATE(652),
    [sym_while] = STATE(652),
    [sym_repeat] = STATE(652),
    [sym_for] = STATE(652),
    [sym_switch] = STATE(652),
    [sym_call] = STATE(652),
    [sym__assignment] = STATE(652),
    [sym_left_assignment] = STATE(652),
    [sym_left_assignment2] = STATE(652),
    [sym_equals_assignment] = STATE(652),
    [sym_super_assignment] = STATE(652),
    [sym_super_right_assignment] = STATE(652),
    [sym_right_assignment] = STATE(652),
    [sym_brace_list] = STATE(652),
    [sym_paren_list] = STATE(652),
    [sym_subset] = STATE(652),
    [sym_subset2] = STATE(652),
    [sym_dollar] = STATE(652),
    [sym_slot] = STATE(652),
    [sym_namespace_get] = STATE(652),
    [sym_namespace_get_internal] = STATE(652),
    [sym_pipe] = STATE(652),
    [sym_unary] = STATE(652),
    [sym_binary] = STATE(652),
    [sym_na] = STATE(652),
    [sym__expression] = STATE(652),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(652),
    [sym_string] = STATE(652),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_function] = ACTIONS(331),
    [anon_sym_BSLASH] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(331),
    [anon_sym_repeat] = ACTIONS(331),
    [anon_sym_for] = ACTIONS(331),
    [anon_sym_switch] = ACTIONS(331),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(329),
    [sym_dots] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(329),
    [anon_sym_PLUS] = ACTIONS(329),
    [anon_sym_BANG] = ACTIONS(329),
    [anon_sym_TILDE] = ACTIONS(329),
    [sym_break] = ACTIONS(331),
    [sym_next] = ACTIONS(331),
    [sym_true] = ACTIONS(331),
    [sym_false] = ACTIONS(331),
    [sym_null] = ACTIONS(331),
    [sym_inf] = ACTIONS(331),
    [sym_nan] = ACTIONS(331),
    [anon_sym_NA] = ACTIONS(331),
    [anon_sym_NA_character_] = ACTIONS(331),
    [anon_sym_NA_complex_] = ACTIONS(331),
    [anon_sym_NA_integer_] = ACTIONS(331),
    [anon_sym_NA_real_] = ACTIONS(331),
    [aux_sym_identifier_token1] = ACTIONS(331),
    [anon_sym_BQUOTE] = ACTIONS(329),
    [sym_integer] = ACTIONS(329),
    [sym_float] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
  },
  [83] = {
    [sym_function_definition] = STATE(589),
    [sym_lambda_function] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_repeat] = STATE(589),
    [sym_for] = STATE(589),
    [sym_switch] = STATE(589),
    [sym_call] = STATE(589),
    [sym__assignment] = STATE(589),
    [sym_left_assignment] = STATE(589),
    [sym_left_assignment2] = STATE(589),
    [sym_equals_assignment] = STATE(589),
    [sym_super_assignment] = STATE(589),
    [sym_super_right_assignment] = STATE(589),
    [sym_right_assignment] = STATE(589),
    [sym_brace_list] = STATE(589),
    [sym_paren_list] = STATE(589),
    [sym_subset] = STATE(589),
    [sym_subset2] = STATE(589),
    [sym_dollar] = STATE(589),
    [sym_slot] = STATE(589),
    [sym_namespace_get] = STATE(589),
    [sym_namespace_get_internal] = STATE(589),
    [sym_pipe] = STATE(589),
    [sym_unary] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_na] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(589),
    [sym_string] = STATE(589),
    [aux_sym_program_repeat1] = STATE(77),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(633),
    [sym_dots] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(355),
    [sym_next] = ACTIONS(355),
    [sym_true] = ACTIONS(355),
    [sym_false] = ACTIONS(355),
    [sym_null] = ACTIONS(355),
    [sym_inf] = ACTIONS(355),
    [sym_nan] = ACTIONS(355),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(333),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [84] = {
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(635),
    [anon_sym_RPAREN] = ACTIONS(635),
    [anon_sym_else] = ACTIONS(637),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_switch] = ACTIONS(637),
    [anon_sym_COMMA] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(635),
    [anon_sym_LT_DASH] = ACTIONS(635),
    [anon_sym_COLON_EQ] = ACTIONS(635),
    [anon_sym_LT_LT_DASH] = ACTIONS(635),
    [anon_sym_DASH_GT_GT] = ACTIONS(635),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_RBRACK] = ACTIONS(635),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(635),
    [anon_sym_DOLLAR] = ACTIONS(635),
    [anon_sym_AT] = ACTIONS(635),
    [anon_sym_COLON_COLON] = ACTIONS(639),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(641),
    [sym_dots] = ACTIONS(637),
    [anon_sym_PIPE_GT] = ACTIONS(635),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_BANG] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_SLASH] = ACTIONS(635),
    [anon_sym_CARET] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_LT_EQ] = ACTIONS(635),
    [anon_sym_GT_EQ] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_BANG_EQ] = ACTIONS(635),
    [anon_sym_PIPE_PIPE] = ACTIONS(635),
    [anon_sym_PIPE] = ACTIONS(637),
    [anon_sym_AMP_AMP] = ACTIONS(635),
    [anon_sym_AMP] = ACTIONS(637),
    [anon_sym_COLON] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(637),
    [anon_sym_NA_character_] = ACTIONS(637),
    [anon_sym_NA_complex_] = ACTIONS(637),
    [anon_sym_NA_integer_] = ACTIONS(637),
    [anon_sym_NA_real_] = ACTIONS(637),
    [aux_sym_identifier_token1] = ACTIONS(637),
    [anon_sym_BQUOTE] = ACTIONS(635),
    [sym_integer] = ACTIONS(635),
    [sym_float] = ACTIONS(637),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(635),
    [anon_sym_SQUOTE] = ACTIONS(635),
    [anon_sym_PERCENT] = ACTIONS(635),
  },
  [85] = {
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_function] = ACTIONS(645),
    [anon_sym_BSLASH] = ACTIONS(643),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_RPAREN] = ACTIONS(643),
    [anon_sym_else] = ACTIONS(645),
    [anon_sym_while] = ACTIONS(645),
    [anon_sym_repeat] = ACTIONS(645),
    [anon_sym_for] = ACTIONS(645),
    [anon_sym_switch] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_LT_DASH] = ACTIONS(643),
    [anon_sym_COLON_EQ] = ACTIONS(643),
    [anon_sym_LT_LT_DASH] = ACTIONS(643),
    [anon_sym_DASH_GT_GT] = ACTIONS(643),
    [anon_sym_DASH_GT] = ACTIONS(645),
    [anon_sym_LBRACK] = ACTIONS(645),
    [anon_sym_RBRACK] = ACTIONS(643),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(645),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(643),
    [sym_dots] = ACTIONS(645),
    [anon_sym_PIPE_GT] = ACTIONS(643),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(643),
    [anon_sym_BANG] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(643),
    [anon_sym_STAR] = ACTIONS(643),
    [anon_sym_SLASH] = ACTIONS(643),
    [anon_sym_CARET] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_PIPE_PIPE] = ACTIONS(643),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(643),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_COLON] = ACTIONS(645),
    [sym_break] = ACTIONS(645),
    [sym_next] = ACTIONS(645),
    [sym_true] = ACTIONS(645),
    [sym_false] = ACTIONS(645),
    [sym_null] = ACTIONS(645),
    [sym_inf] = ACTIONS(645),
    [sym_nan] = ACTIONS(645),
    [anon_sym_NA] = ACTIONS(645),
    [anon_sym_NA_character_] = ACTIONS(645),
    [anon_sym_NA_complex_] = ACTIONS(645),
    [anon_sym_NA_integer_] = ACTIONS(645),
    [anon_sym_NA_real_] = ACTIONS(645),
    [aux_sym_identifier_token1] = ACTIONS(645),
    [anon_sym_BQUOTE] = ACTIONS(643),
    [sym_integer] = ACTIONS(643),
    [sym_float] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(643),
    [anon_sym_SQUOTE] = ACTIONS(643),
    [anon_sym_PERCENT] = ACTIONS(643),
  },
  [86] = {
    [anon_sym_SEMI] = ACTIONS(647),
    [anon_sym_function] = ACTIONS(649),
    [anon_sym_BSLASH] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(647),
    [anon_sym_RPAREN] = ACTIONS(647),
    [anon_sym_else] = ACTIONS(649),
    [anon_sym_while] = ACTIONS(649),
    [anon_sym_repeat] = ACTIONS(649),
    [anon_sym_for] = ACTIONS(649),
    [anon_sym_switch] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_LT_DASH] = ACTIONS(647),
    [anon_sym_COLON_EQ] = ACTIONS(647),
    [anon_sym_LT_LT_DASH] = ACTIONS(647),
    [anon_sym_DASH_GT_GT] = ACTIONS(647),
    [anon_sym_DASH_GT] = ACTIONS(649),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_RBRACK] = ACTIONS(647),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(647),
    [anon_sym_DOLLAR] = ACTIONS(647),
    [anon_sym_AT] = ACTIONS(647),
    [anon_sym_COLON_COLON] = ACTIONS(649),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(647),
    [sym_dots] = ACTIONS(649),
    [anon_sym_PIPE_GT] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(649),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(649),
    [anon_sym_GT] = ACTIONS(649),
    [anon_sym_LT_EQ] = ACTIONS(647),
    [anon_sym_GT_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(649),
    [anon_sym_COLON] = ACTIONS(649),
    [sym_break] = ACTIONS(649),
    [sym_next] = ACTIONS(649),
    [sym_true] = ACTIONS(649),
    [sym_false] = ACTIONS(649),
    [sym_null] = ACTIONS(649),
    [sym_inf] = ACTIONS(649),
    [sym_nan] = ACTIONS(649),
    [anon_sym_NA] = ACTIONS(649),
    [anon_sym_NA_character_] = ACTIONS(649),
    [anon_sym_NA_complex_] = ACTIONS(649),
    [anon_sym_NA_integer_] = ACTIONS(649),
    [anon_sym_NA_real_] = ACTIONS(649),
    [aux_sym_identifier_token1] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(647),
    [sym_integer] = ACTIONS(647),
    [sym_float] = ACTIONS(649),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(647),
    [anon_sym_SQUOTE] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
  },
  [87] = {
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(653),
    [anon_sym_BSLASH] = ACTIONS(651),
    [anon_sym_if] = ACTIONS(653),
    [anon_sym_LPAREN] = ACTIONS(651),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_else] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(653),
    [anon_sym_repeat] = ACTIONS(653),
    [anon_sym_for] = ACTIONS(653),
    [anon_sym_switch] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(651),
    [anon_sym_EQ] = ACTIONS(653),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_LT_DASH] = ACTIONS(651),
    [anon_sym_COLON_EQ] = ACTIONS(651),
    [anon_sym_LT_LT_DASH] = ACTIONS(651),
    [anon_sym_DASH_GT_GT] = ACTIONS(651),
    [anon_sym_DASH_GT] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_RBRACK] = ACTIONS(651),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(651),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [anon_sym_AT] = ACTIONS(651),
    [anon_sym_COLON_COLON] = ACTIONS(653),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(651),
    [sym_dots] = ACTIONS(653),
    [anon_sym_PIPE_GT] = ACTIONS(651),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_PLUS] = ACTIONS(651),
    [anon_sym_BANG] = ACTIONS(653),
    [anon_sym_TILDE] = ACTIONS(651),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_SLASH] = ACTIONS(651),
    [anon_sym_CARET] = ACTIONS(651),
    [anon_sym_LT] = ACTIONS(653),
    [anon_sym_GT] = ACTIONS(653),
    [anon_sym_LT_EQ] = ACTIONS(651),
    [anon_sym_GT_EQ] = ACTIONS(651),
    [anon_sym_EQ_EQ] = ACTIONS(651),
    [anon_sym_BANG_EQ] = ACTIONS(651),
    [anon_sym_PIPE_PIPE] = ACTIONS(651),
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(651),
    [anon_sym_AMP] = ACTIONS(653),
    [anon_sym_COLON] = ACTIONS(653),
    [sym_break] = ACTIONS(653),
    [sym_next] = ACTIONS(653),
    [sym_true] = ACTIONS(653),
    [sym_false] = ACTIONS(653),
    [sym_null] = ACTIONS(653),
    [sym_inf] = ACTIONS(653),
    [sym_nan] = ACTIONS(653),
    [anon_sym_NA] = ACTIONS(653),
    [anon_sym_NA_character_] = ACTIONS(653),
    [anon_sym_NA_complex_] = ACTIONS(653),
    [anon_sym_NA_integer_] = ACTIONS(653),
    [anon_sym_NA_real_] = ACTIONS(653),
    [aux_sym_identifier_token1] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(651),
    [sym_integer] = ACTIONS(651),
    [sym_float] = ACTIONS(653),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [anon_sym_SQUOTE] = ACTIONS(651),
    [anon_sym_PERCENT] = ACTIONS(651),
  },
  [88] = {
    [sym_function_definition] = STATE(451),
    [sym_lambda_function] = STATE(451),
    [sym_if] = STATE(451),
    [sym_while] = STATE(451),
    [sym_repeat] = STATE(451),
    [sym_for] = STATE(451),
    [sym_switch] = STATE(451),
    [sym_call] = STATE(451),
    [sym__assignment] = STATE(451),
    [sym_left_assignment] = STATE(451),
    [sym_left_assignment2] = STATE(451),
    [sym_equals_assignment] = STATE(451),
    [sym_super_assignment] = STATE(451),
    [sym_super_right_assignment] = STATE(451),
    [sym_right_assignment] = STATE(451),
    [sym_brace_list] = STATE(451),
    [sym_paren_list] = STATE(451),
    [sym_subset] = STATE(451),
    [sym_subset2] = STATE(451),
    [sym_dollar] = STATE(451),
    [sym_slot] = STATE(451),
    [sym_namespace_get] = STATE(451),
    [sym_namespace_get_internal] = STATE(451),
    [sym_pipe] = STATE(451),
    [sym_unary] = STATE(451),
    [sym_binary] = STATE(451),
    [sym_na] = STATE(451),
    [sym__expression] = STATE(451),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(451),
    [sym_string] = STATE(451),
    [anon_sym_SEMI] = ACTIONS(655),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(675),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(675),
    [sym_next] = ACTIONS(675),
    [sym_true] = ACTIONS(675),
    [sym_false] = ACTIONS(675),
    [sym_null] = ACTIONS(675),
    [sym_inf] = ACTIONS(675),
    [sym_nan] = ACTIONS(675),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(655),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [89] = {
    [sym_function_definition] = STATE(717),
    [sym_lambda_function] = STATE(717),
    [sym_if] = STATE(717),
    [sym_while] = STATE(717),
    [sym_repeat] = STATE(717),
    [sym_for] = STATE(717),
    [sym_switch] = STATE(717),
    [sym_call] = STATE(717),
    [sym__assignment] = STATE(717),
    [sym_left_assignment] = STATE(717),
    [sym_left_assignment2] = STATE(717),
    [sym_equals_assignment] = STATE(717),
    [sym_super_assignment] = STATE(717),
    [sym_super_right_assignment] = STATE(717),
    [sym_right_assignment] = STATE(717),
    [sym_brace_list] = STATE(717),
    [sym_paren_list] = STATE(717),
    [sym_subset] = STATE(717),
    [sym_subset2] = STATE(717),
    [sym_dollar] = STATE(717),
    [sym_slot] = STATE(717),
    [sym_namespace_get] = STATE(717),
    [sym_namespace_get_internal] = STATE(717),
    [sym_pipe] = STATE(717),
    [sym_unary] = STATE(717),
    [sym_binary] = STATE(717),
    [sym_na] = STATE(717),
    [sym__expression] = STATE(717),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(717),
    [sym_string] = STATE(717),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(697),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(697),
    [sym_next] = ACTIONS(697),
    [sym_true] = ACTIONS(697),
    [sym_false] = ACTIONS(697),
    [sym_null] = ACTIONS(697),
    [sym_inf] = ACTIONS(697),
    [sym_nan] = ACTIONS(697),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(695),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [90] = {
    [sym_function_definition] = STATE(889),
    [sym_lambda_function] = STATE(889),
    [sym_if] = STATE(889),
    [sym_while] = STATE(889),
    [sym_repeat] = STATE(889),
    [sym_for] = STATE(889),
    [sym_switch] = STATE(889),
    [sym_call] = STATE(889),
    [sym__assignment] = STATE(889),
    [sym_left_assignment] = STATE(889),
    [sym_left_assignment2] = STATE(889),
    [sym_equals_assignment] = STATE(889),
    [sym_super_assignment] = STATE(889),
    [sym_super_right_assignment] = STATE(889),
    [sym_right_assignment] = STATE(889),
    [sym_brace_list] = STATE(889),
    [sym_paren_list] = STATE(889),
    [sym_subset] = STATE(889),
    [sym_subset2] = STATE(889),
    [sym_dollar] = STATE(889),
    [sym_slot] = STATE(889),
    [sym_namespace_get] = STATE(889),
    [sym_namespace_get_internal] = STATE(889),
    [sym_pipe] = STATE(889),
    [sym_unary] = STATE(889),
    [sym_binary] = STATE(889),
    [sym_na] = STATE(889),
    [sym__expression] = STATE(889),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(889),
    [sym_string] = STATE(889),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(713),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(713),
    [sym_next] = ACTIONS(713),
    [sym_true] = ACTIONS(713),
    [sym_false] = ACTIONS(713),
    [sym_null] = ACTIONS(713),
    [sym_inf] = ACTIONS(713),
    [sym_nan] = ACTIONS(713),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(699),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [91] = {
    [sym_function_definition] = STATE(893),
    [sym_lambda_function] = STATE(893),
    [sym_if] = STATE(893),
    [sym_while] = STATE(893),
    [sym_repeat] = STATE(893),
    [sym_for] = STATE(893),
    [sym_switch] = STATE(893),
    [sym_call] = STATE(893),
    [sym__assignment] = STATE(893),
    [sym_left_assignment] = STATE(893),
    [sym_left_assignment2] = STATE(893),
    [sym_equals_assignment] = STATE(893),
    [sym_super_assignment] = STATE(893),
    [sym_super_right_assignment] = STATE(893),
    [sym_right_assignment] = STATE(893),
    [sym_brace_list] = STATE(893),
    [sym_paren_list] = STATE(893),
    [sym_subset] = STATE(893),
    [sym_subset2] = STATE(893),
    [sym_dollar] = STATE(893),
    [sym_slot] = STATE(893),
    [sym_namespace_get] = STATE(893),
    [sym_namespace_get_internal] = STATE(893),
    [sym_pipe] = STATE(893),
    [sym_unary] = STATE(893),
    [sym_binary] = STATE(893),
    [sym_na] = STATE(893),
    [sym__expression] = STATE(893),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(893),
    [sym_string] = STATE(893),
    [anon_sym_SEMI] = ACTIONS(723),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(725),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(725),
    [sym_next] = ACTIONS(725),
    [sym_true] = ACTIONS(725),
    [sym_false] = ACTIONS(725),
    [sym_null] = ACTIONS(725),
    [sym_inf] = ACTIONS(725),
    [sym_nan] = ACTIONS(725),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(723),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [92] = {
    [sym_function_definition] = STATE(918),
    [sym_lambda_function] = STATE(918),
    [sym_if] = STATE(918),
    [sym_while] = STATE(918),
    [sym_repeat] = STATE(918),
    [sym_for] = STATE(918),
    [sym_switch] = STATE(918),
    [sym_call] = STATE(918),
    [sym__assignment] = STATE(918),
    [sym_left_assignment] = STATE(918),
    [sym_left_assignment2] = STATE(918),
    [sym_equals_assignment] = STATE(918),
    [sym_super_assignment] = STATE(918),
    [sym_super_right_assignment] = STATE(918),
    [sym_right_assignment] = STATE(918),
    [sym_brace_list] = STATE(918),
    [sym_paren_list] = STATE(918),
    [sym_subset] = STATE(918),
    [sym_subset2] = STATE(918),
    [sym_dollar] = STATE(918),
    [sym_slot] = STATE(918),
    [sym_namespace_get] = STATE(918),
    [sym_namespace_get_internal] = STATE(918),
    [sym_pipe] = STATE(918),
    [sym_unary] = STATE(918),
    [sym_binary] = STATE(918),
    [sym_na] = STATE(918),
    [sym__expression] = STATE(918),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(918),
    [sym_string] = STATE(918),
    [anon_sym_SEMI] = ACTIONS(727),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(729),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(729),
    [sym_next] = ACTIONS(729),
    [sym_true] = ACTIONS(729),
    [sym_false] = ACTIONS(729),
    [sym_null] = ACTIONS(729),
    [sym_inf] = ACTIONS(729),
    [sym_nan] = ACTIONS(729),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(727),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [93] = {
    [sym_function_definition] = STATE(917),
    [sym_lambda_function] = STATE(917),
    [sym_if] = STATE(917),
    [sym_while] = STATE(917),
    [sym_repeat] = STATE(917),
    [sym_for] = STATE(917),
    [sym_switch] = STATE(917),
    [sym_call] = STATE(917),
    [sym__assignment] = STATE(917),
    [sym_left_assignment] = STATE(917),
    [sym_left_assignment2] = STATE(917),
    [sym_equals_assignment] = STATE(917),
    [sym_super_assignment] = STATE(917),
    [sym_super_right_assignment] = STATE(917),
    [sym_right_assignment] = STATE(917),
    [sym_brace_list] = STATE(917),
    [sym_paren_list] = STATE(917),
    [sym_subset] = STATE(917),
    [sym_subset2] = STATE(917),
    [sym_dollar] = STATE(917),
    [sym_slot] = STATE(917),
    [sym_namespace_get] = STATE(917),
    [sym_namespace_get_internal] = STATE(917),
    [sym_pipe] = STATE(917),
    [sym_unary] = STATE(917),
    [sym_binary] = STATE(917),
    [sym_na] = STATE(917),
    [sym__expression] = STATE(917),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(917),
    [sym_string] = STATE(917),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(733),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(733),
    [sym_next] = ACTIONS(733),
    [sym_true] = ACTIONS(733),
    [sym_false] = ACTIONS(733),
    [sym_null] = ACTIONS(733),
    [sym_inf] = ACTIONS(733),
    [sym_nan] = ACTIONS(733),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(731),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [94] = {
    [sym_function_definition] = STATE(915),
    [sym_lambda_function] = STATE(915),
    [sym_if] = STATE(915),
    [sym_while] = STATE(915),
    [sym_repeat] = STATE(915),
    [sym_for] = STATE(915),
    [sym_switch] = STATE(915),
    [sym_call] = STATE(915),
    [sym__assignment] = STATE(915),
    [sym_left_assignment] = STATE(915),
    [sym_left_assignment2] = STATE(915),
    [sym_equals_assignment] = STATE(915),
    [sym_super_assignment] = STATE(915),
    [sym_super_right_assignment] = STATE(915),
    [sym_right_assignment] = STATE(915),
    [sym_brace_list] = STATE(915),
    [sym_paren_list] = STATE(915),
    [sym_subset] = STATE(915),
    [sym_subset2] = STATE(915),
    [sym_dollar] = STATE(915),
    [sym_slot] = STATE(915),
    [sym_namespace_get] = STATE(915),
    [sym_namespace_get_internal] = STATE(915),
    [sym_pipe] = STATE(915),
    [sym_unary] = STATE(915),
    [sym_binary] = STATE(915),
    [sym_na] = STATE(915),
    [sym__expression] = STATE(915),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(915),
    [sym_string] = STATE(915),
    [anon_sym_SEMI] = ACTIONS(735),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(737),
    [sym_next] = ACTIONS(737),
    [sym_true] = ACTIONS(737),
    [sym_false] = ACTIONS(737),
    [sym_null] = ACTIONS(737),
    [sym_inf] = ACTIONS(737),
    [sym_nan] = ACTIONS(737),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(735),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [95] = {
    [sym_function_definition] = STATE(912),
    [sym_lambda_function] = STATE(912),
    [sym_if] = STATE(912),
    [sym_while] = STATE(912),
    [sym_repeat] = STATE(912),
    [sym_for] = STATE(912),
    [sym_switch] = STATE(912),
    [sym_call] = STATE(912),
    [sym__assignment] = STATE(912),
    [sym_left_assignment] = STATE(912),
    [sym_left_assignment2] = STATE(912),
    [sym_equals_assignment] = STATE(912),
    [sym_super_assignment] = STATE(912),
    [sym_super_right_assignment] = STATE(912),
    [sym_right_assignment] = STATE(912),
    [sym_brace_list] = STATE(912),
    [sym_paren_list] = STATE(912),
    [sym_subset] = STATE(912),
    [sym_subset2] = STATE(912),
    [sym_dollar] = STATE(912),
    [sym_slot] = STATE(912),
    [sym_namespace_get] = STATE(912),
    [sym_namespace_get_internal] = STATE(912),
    [sym_pipe] = STATE(912),
    [sym_unary] = STATE(912),
    [sym_binary] = STATE(912),
    [sym_na] = STATE(912),
    [sym__expression] = STATE(912),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(912),
    [sym_string] = STATE(912),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(741),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(741),
    [sym_next] = ACTIONS(741),
    [sym_true] = ACTIONS(741),
    [sym_false] = ACTIONS(741),
    [sym_null] = ACTIONS(741),
    [sym_inf] = ACTIONS(741),
    [sym_nan] = ACTIONS(741),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(739),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [96] = {
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(635),
    [anon_sym_RPAREN] = ACTIONS(635),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_switch] = ACTIONS(637),
    [anon_sym_COMMA] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(743),
    [anon_sym_LBRACE] = ACTIONS(635),
    [anon_sym_LT_DASH] = ACTIONS(635),
    [anon_sym_COLON_EQ] = ACTIONS(635),
    [anon_sym_LT_LT_DASH] = ACTIONS(635),
    [anon_sym_DASH_GT_GT] = ACTIONS(635),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_RBRACK] = ACTIONS(635),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(635),
    [anon_sym_DOLLAR] = ACTIONS(635),
    [anon_sym_AT] = ACTIONS(635),
    [anon_sym_COLON_COLON] = ACTIONS(745),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(747),
    [sym_dots] = ACTIONS(637),
    [anon_sym_PIPE_GT] = ACTIONS(635),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_BANG] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_SLASH] = ACTIONS(635),
    [anon_sym_CARET] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_LT_EQ] = ACTIONS(635),
    [anon_sym_GT_EQ] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_BANG_EQ] = ACTIONS(635),
    [anon_sym_PIPE_PIPE] = ACTIONS(635),
    [anon_sym_PIPE] = ACTIONS(637),
    [anon_sym_AMP_AMP] = ACTIONS(635),
    [anon_sym_AMP] = ACTIONS(637),
    [anon_sym_COLON] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(637),
    [anon_sym_NA_character_] = ACTIONS(637),
    [anon_sym_NA_complex_] = ACTIONS(637),
    [anon_sym_NA_integer_] = ACTIONS(637),
    [anon_sym_NA_real_] = ACTIONS(637),
    [aux_sym_identifier_token1] = ACTIONS(637),
    [anon_sym_BQUOTE] = ACTIONS(635),
    [sym_integer] = ACTIONS(635),
    [sym_float] = ACTIONS(637),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(635),
    [anon_sym_SQUOTE] = ACTIONS(635),
    [anon_sym_PERCENT] = ACTIONS(635),
  },
  [97] = {
    [sym_function_definition] = STATE(904),
    [sym_lambda_function] = STATE(904),
    [sym_if] = STATE(904),
    [sym_while] = STATE(904),
    [sym_repeat] = STATE(904),
    [sym_for] = STATE(904),
    [sym_switch] = STATE(904),
    [sym_call] = STATE(904),
    [sym__assignment] = STATE(904),
    [sym_left_assignment] = STATE(904),
    [sym_left_assignment2] = STATE(904),
    [sym_equals_assignment] = STATE(904),
    [sym_super_assignment] = STATE(904),
    [sym_super_right_assignment] = STATE(904),
    [sym_right_assignment] = STATE(904),
    [sym_brace_list] = STATE(904),
    [sym_paren_list] = STATE(904),
    [sym_subset] = STATE(904),
    [sym_subset2] = STATE(904),
    [sym_dollar] = STATE(904),
    [sym_slot] = STATE(904),
    [sym_namespace_get] = STATE(904),
    [sym_namespace_get_internal] = STATE(904),
    [sym_pipe] = STATE(904),
    [sym_unary] = STATE(904),
    [sym_binary] = STATE(904),
    [sym_na] = STATE(904),
    [sym__expression] = STATE(904),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(904),
    [sym_string] = STATE(904),
    [anon_sym_SEMI] = ACTIONS(749),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(751),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(751),
    [sym_next] = ACTIONS(751),
    [sym_true] = ACTIONS(751),
    [sym_false] = ACTIONS(751),
    [sym_null] = ACTIONS(751),
    [sym_inf] = ACTIONS(751),
    [sym_nan] = ACTIONS(751),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(749),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [98] = {
    [sym_function_definition] = STATE(890),
    [sym_lambda_function] = STATE(890),
    [sym_if] = STATE(890),
    [sym_while] = STATE(890),
    [sym_repeat] = STATE(890),
    [sym_for] = STATE(890),
    [sym_switch] = STATE(890),
    [sym_call] = STATE(890),
    [sym__assignment] = STATE(890),
    [sym_left_assignment] = STATE(890),
    [sym_left_assignment2] = STATE(890),
    [sym_equals_assignment] = STATE(890),
    [sym_super_assignment] = STATE(890),
    [sym_super_right_assignment] = STATE(890),
    [sym_right_assignment] = STATE(890),
    [sym_brace_list] = STATE(890),
    [sym_paren_list] = STATE(890),
    [sym_subset] = STATE(890),
    [sym_subset2] = STATE(890),
    [sym_dollar] = STATE(890),
    [sym_slot] = STATE(890),
    [sym_namespace_get] = STATE(890),
    [sym_namespace_get_internal] = STATE(890),
    [sym_pipe] = STATE(890),
    [sym_unary] = STATE(890),
    [sym_binary] = STATE(890),
    [sym_na] = STATE(890),
    [sym__expression] = STATE(890),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(890),
    [sym_string] = STATE(890),
    [anon_sym_SEMI] = ACTIONS(753),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(755),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(755),
    [sym_next] = ACTIONS(755),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_null] = ACTIONS(755),
    [sym_inf] = ACTIONS(755),
    [sym_nan] = ACTIONS(755),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(753),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [99] = {
    [sym_function_definition] = STATE(887),
    [sym_lambda_function] = STATE(887),
    [sym_if] = STATE(887),
    [sym_while] = STATE(887),
    [sym_repeat] = STATE(887),
    [sym_for] = STATE(887),
    [sym_switch] = STATE(887),
    [sym_call] = STATE(887),
    [sym__assignment] = STATE(887),
    [sym_left_assignment] = STATE(887),
    [sym_left_assignment2] = STATE(887),
    [sym_equals_assignment] = STATE(887),
    [sym_super_assignment] = STATE(887),
    [sym_super_right_assignment] = STATE(887),
    [sym_right_assignment] = STATE(887),
    [sym_brace_list] = STATE(887),
    [sym_paren_list] = STATE(887),
    [sym_subset] = STATE(887),
    [sym_subset2] = STATE(887),
    [sym_dollar] = STATE(887),
    [sym_slot] = STATE(887),
    [sym_namespace_get] = STATE(887),
    [sym_namespace_get_internal] = STATE(887),
    [sym_pipe] = STATE(887),
    [sym_unary] = STATE(887),
    [sym_binary] = STATE(887),
    [sym_na] = STATE(887),
    [sym__expression] = STATE(887),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(887),
    [sym_string] = STATE(887),
    [anon_sym_SEMI] = ACTIONS(757),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(759),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(759),
    [sym_next] = ACTIONS(759),
    [sym_true] = ACTIONS(759),
    [sym_false] = ACTIONS(759),
    [sym_null] = ACTIONS(759),
    [sym_inf] = ACTIONS(759),
    [sym_nan] = ACTIONS(759),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(757),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [100] = {
    [sym_function_definition] = STATE(916),
    [sym_lambda_function] = STATE(916),
    [sym_if] = STATE(916),
    [sym_while] = STATE(916),
    [sym_repeat] = STATE(916),
    [sym_for] = STATE(916),
    [sym_switch] = STATE(916),
    [sym_call] = STATE(916),
    [sym__assignment] = STATE(916),
    [sym_left_assignment] = STATE(916),
    [sym_left_assignment2] = STATE(916),
    [sym_equals_assignment] = STATE(916),
    [sym_super_assignment] = STATE(916),
    [sym_super_right_assignment] = STATE(916),
    [sym_right_assignment] = STATE(916),
    [sym_brace_list] = STATE(916),
    [sym_paren_list] = STATE(916),
    [sym_subset] = STATE(916),
    [sym_subset2] = STATE(916),
    [sym_dollar] = STATE(916),
    [sym_slot] = STATE(916),
    [sym_namespace_get] = STATE(916),
    [sym_namespace_get_internal] = STATE(916),
    [sym_pipe] = STATE(916),
    [sym_unary] = STATE(916),
    [sym_binary] = STATE(916),
    [sym_na] = STATE(916),
    [sym__expression] = STATE(916),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(916),
    [sym_string] = STATE(916),
    [anon_sym_SEMI] = ACTIONS(761),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(763),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(763),
    [sym_next] = ACTIONS(763),
    [sym_true] = ACTIONS(763),
    [sym_false] = ACTIONS(763),
    [sym_null] = ACTIONS(763),
    [sym_inf] = ACTIONS(763),
    [sym_nan] = ACTIONS(763),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(761),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [101] = {
    [sym_function_definition] = STATE(907),
    [sym_lambda_function] = STATE(907),
    [sym_if] = STATE(907),
    [sym_while] = STATE(907),
    [sym_repeat] = STATE(907),
    [sym_for] = STATE(907),
    [sym_switch] = STATE(907),
    [sym_call] = STATE(907),
    [sym__assignment] = STATE(907),
    [sym_left_assignment] = STATE(907),
    [sym_left_assignment2] = STATE(907),
    [sym_equals_assignment] = STATE(907),
    [sym_super_assignment] = STATE(907),
    [sym_super_right_assignment] = STATE(907),
    [sym_right_assignment] = STATE(907),
    [sym_brace_list] = STATE(907),
    [sym_paren_list] = STATE(907),
    [sym_subset] = STATE(907),
    [sym_subset2] = STATE(907),
    [sym_dollar] = STATE(907),
    [sym_slot] = STATE(907),
    [sym_namespace_get] = STATE(907),
    [sym_namespace_get_internal] = STATE(907),
    [sym_pipe] = STATE(907),
    [sym_unary] = STATE(907),
    [sym_binary] = STATE(907),
    [sym_na] = STATE(907),
    [sym__expression] = STATE(907),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(907),
    [sym_string] = STATE(907),
    [anon_sym_SEMI] = ACTIONS(765),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(767),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(767),
    [sym_next] = ACTIONS(767),
    [sym_true] = ACTIONS(767),
    [sym_false] = ACTIONS(767),
    [sym_null] = ACTIONS(767),
    [sym_inf] = ACTIONS(767),
    [sym_nan] = ACTIONS(767),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(765),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [102] = {
    [sym_function_definition] = STATE(891),
    [sym_lambda_function] = STATE(891),
    [sym_if] = STATE(891),
    [sym_while] = STATE(891),
    [sym_repeat] = STATE(891),
    [sym_for] = STATE(891),
    [sym_switch] = STATE(891),
    [sym_call] = STATE(891),
    [sym__assignment] = STATE(891),
    [sym_left_assignment] = STATE(891),
    [sym_left_assignment2] = STATE(891),
    [sym_equals_assignment] = STATE(891),
    [sym_super_assignment] = STATE(891),
    [sym_super_right_assignment] = STATE(891),
    [sym_right_assignment] = STATE(891),
    [sym_brace_list] = STATE(891),
    [sym_paren_list] = STATE(891),
    [sym_subset] = STATE(891),
    [sym_subset2] = STATE(891),
    [sym_dollar] = STATE(891),
    [sym_slot] = STATE(891),
    [sym_namespace_get] = STATE(891),
    [sym_namespace_get_internal] = STATE(891),
    [sym_pipe] = STATE(891),
    [sym_unary] = STATE(891),
    [sym_binary] = STATE(891),
    [sym_na] = STATE(891),
    [sym__expression] = STATE(891),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(891),
    [sym_string] = STATE(891),
    [anon_sym_SEMI] = ACTIONS(769),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(771),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(771),
    [sym_next] = ACTIONS(771),
    [sym_true] = ACTIONS(771),
    [sym_false] = ACTIONS(771),
    [sym_null] = ACTIONS(771),
    [sym_inf] = ACTIONS(771),
    [sym_nan] = ACTIONS(771),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(769),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [103] = {
    [sym_function_definition] = STATE(883),
    [sym_lambda_function] = STATE(883),
    [sym_if] = STATE(883),
    [sym_while] = STATE(883),
    [sym_repeat] = STATE(883),
    [sym_for] = STATE(883),
    [sym_switch] = STATE(883),
    [sym_call] = STATE(883),
    [sym__assignment] = STATE(883),
    [sym_left_assignment] = STATE(883),
    [sym_left_assignment2] = STATE(883),
    [sym_equals_assignment] = STATE(883),
    [sym_super_assignment] = STATE(883),
    [sym_super_right_assignment] = STATE(883),
    [sym_right_assignment] = STATE(883),
    [sym_brace_list] = STATE(883),
    [sym_paren_list] = STATE(883),
    [sym_subset] = STATE(883),
    [sym_subset2] = STATE(883),
    [sym_dollar] = STATE(883),
    [sym_slot] = STATE(883),
    [sym_namespace_get] = STATE(883),
    [sym_namespace_get_internal] = STATE(883),
    [sym_pipe] = STATE(883),
    [sym_unary] = STATE(883),
    [sym_binary] = STATE(883),
    [sym_na] = STATE(883),
    [sym__expression] = STATE(883),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(883),
    [sym_string] = STATE(883),
    [anon_sym_SEMI] = ACTIONS(773),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(775),
    [sym_next] = ACTIONS(775),
    [sym_true] = ACTIONS(775),
    [sym_false] = ACTIONS(775),
    [sym_null] = ACTIONS(775),
    [sym_inf] = ACTIONS(775),
    [sym_nan] = ACTIONS(775),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(773),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [104] = {
    [sym_function_definition] = STATE(886),
    [sym_lambda_function] = STATE(886),
    [sym_if] = STATE(886),
    [sym_while] = STATE(886),
    [sym_repeat] = STATE(886),
    [sym_for] = STATE(886),
    [sym_switch] = STATE(886),
    [sym_call] = STATE(886),
    [sym__assignment] = STATE(886),
    [sym_left_assignment] = STATE(886),
    [sym_left_assignment2] = STATE(886),
    [sym_equals_assignment] = STATE(886),
    [sym_super_assignment] = STATE(886),
    [sym_super_right_assignment] = STATE(886),
    [sym_right_assignment] = STATE(886),
    [sym_brace_list] = STATE(886),
    [sym_paren_list] = STATE(886),
    [sym_subset] = STATE(886),
    [sym_subset2] = STATE(886),
    [sym_dollar] = STATE(886),
    [sym_slot] = STATE(886),
    [sym_namespace_get] = STATE(886),
    [sym_namespace_get_internal] = STATE(886),
    [sym_pipe] = STATE(886),
    [sym_unary] = STATE(886),
    [sym_binary] = STATE(886),
    [sym_na] = STATE(886),
    [sym__expression] = STATE(886),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(886),
    [sym_string] = STATE(886),
    [anon_sym_SEMI] = ACTIONS(777),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(779),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(779),
    [sym_next] = ACTIONS(779),
    [sym_true] = ACTIONS(779),
    [sym_false] = ACTIONS(779),
    [sym_null] = ACTIONS(779),
    [sym_inf] = ACTIONS(779),
    [sym_nan] = ACTIONS(779),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(777),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [105] = {
    [sym_function_definition] = STATE(897),
    [sym_lambda_function] = STATE(897),
    [sym_if] = STATE(897),
    [sym_while] = STATE(897),
    [sym_repeat] = STATE(897),
    [sym_for] = STATE(897),
    [sym_switch] = STATE(897),
    [sym_call] = STATE(897),
    [sym__assignment] = STATE(897),
    [sym_left_assignment] = STATE(897),
    [sym_left_assignment2] = STATE(897),
    [sym_equals_assignment] = STATE(897),
    [sym_super_assignment] = STATE(897),
    [sym_super_right_assignment] = STATE(897),
    [sym_right_assignment] = STATE(897),
    [sym_brace_list] = STATE(897),
    [sym_paren_list] = STATE(897),
    [sym_subset] = STATE(897),
    [sym_subset2] = STATE(897),
    [sym_dollar] = STATE(897),
    [sym_slot] = STATE(897),
    [sym_namespace_get] = STATE(897),
    [sym_namespace_get_internal] = STATE(897),
    [sym_pipe] = STATE(897),
    [sym_unary] = STATE(897),
    [sym_binary] = STATE(897),
    [sym_na] = STATE(897),
    [sym__expression] = STATE(897),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(897),
    [sym_string] = STATE(897),
    [anon_sym_SEMI] = ACTIONS(781),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(783),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(783),
    [sym_next] = ACTIONS(783),
    [sym_true] = ACTIONS(783),
    [sym_false] = ACTIONS(783),
    [sym_null] = ACTIONS(783),
    [sym_inf] = ACTIONS(783),
    [sym_nan] = ACTIONS(783),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(781),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [106] = {
    [sym_function_definition] = STATE(901),
    [sym_lambda_function] = STATE(901),
    [sym_if] = STATE(901),
    [sym_while] = STATE(901),
    [sym_repeat] = STATE(901),
    [sym_for] = STATE(901),
    [sym_switch] = STATE(901),
    [sym_call] = STATE(901),
    [sym__assignment] = STATE(901),
    [sym_left_assignment] = STATE(901),
    [sym_left_assignment2] = STATE(901),
    [sym_equals_assignment] = STATE(901),
    [sym_super_assignment] = STATE(901),
    [sym_super_right_assignment] = STATE(901),
    [sym_right_assignment] = STATE(901),
    [sym_brace_list] = STATE(901),
    [sym_paren_list] = STATE(901),
    [sym_subset] = STATE(901),
    [sym_subset2] = STATE(901),
    [sym_dollar] = STATE(901),
    [sym_slot] = STATE(901),
    [sym_namespace_get] = STATE(901),
    [sym_namespace_get_internal] = STATE(901),
    [sym_pipe] = STATE(901),
    [sym_unary] = STATE(901),
    [sym_binary] = STATE(901),
    [sym_na] = STATE(901),
    [sym__expression] = STATE(901),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(901),
    [sym_string] = STATE(901),
    [anon_sym_SEMI] = ACTIONS(785),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(787),
    [sym_next] = ACTIONS(787),
    [sym_true] = ACTIONS(787),
    [sym_false] = ACTIONS(787),
    [sym_null] = ACTIONS(787),
    [sym_inf] = ACTIONS(787),
    [sym_nan] = ACTIONS(787),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(785),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [107] = {
    [sym_function_definition] = STATE(903),
    [sym_lambda_function] = STATE(903),
    [sym_if] = STATE(903),
    [sym_while] = STATE(903),
    [sym_repeat] = STATE(903),
    [sym_for] = STATE(903),
    [sym_switch] = STATE(903),
    [sym_call] = STATE(903),
    [sym__assignment] = STATE(903),
    [sym_left_assignment] = STATE(903),
    [sym_left_assignment2] = STATE(903),
    [sym_equals_assignment] = STATE(903),
    [sym_super_assignment] = STATE(903),
    [sym_super_right_assignment] = STATE(903),
    [sym_right_assignment] = STATE(903),
    [sym_brace_list] = STATE(903),
    [sym_paren_list] = STATE(903),
    [sym_subset] = STATE(903),
    [sym_subset2] = STATE(903),
    [sym_dollar] = STATE(903),
    [sym_slot] = STATE(903),
    [sym_namespace_get] = STATE(903),
    [sym_namespace_get_internal] = STATE(903),
    [sym_pipe] = STATE(903),
    [sym_unary] = STATE(903),
    [sym_binary] = STATE(903),
    [sym_na] = STATE(903),
    [sym__expression] = STATE(903),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(903),
    [sym_string] = STATE(903),
    [anon_sym_SEMI] = ACTIONS(789),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(791),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(791),
    [sym_next] = ACTIONS(791),
    [sym_true] = ACTIONS(791),
    [sym_false] = ACTIONS(791),
    [sym_null] = ACTIONS(791),
    [sym_inf] = ACTIONS(791),
    [sym_nan] = ACTIONS(791),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(789),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [108] = {
    [sym_function_definition] = STATE(899),
    [sym_lambda_function] = STATE(899),
    [sym_if] = STATE(899),
    [sym_while] = STATE(899),
    [sym_repeat] = STATE(899),
    [sym_for] = STATE(899),
    [sym_switch] = STATE(899),
    [sym_call] = STATE(899),
    [sym__assignment] = STATE(899),
    [sym_left_assignment] = STATE(899),
    [sym_left_assignment2] = STATE(899),
    [sym_equals_assignment] = STATE(899),
    [sym_super_assignment] = STATE(899),
    [sym_super_right_assignment] = STATE(899),
    [sym_right_assignment] = STATE(899),
    [sym_brace_list] = STATE(899),
    [sym_paren_list] = STATE(899),
    [sym_subset] = STATE(899),
    [sym_subset2] = STATE(899),
    [sym_dollar] = STATE(899),
    [sym_slot] = STATE(899),
    [sym_namespace_get] = STATE(899),
    [sym_namespace_get_internal] = STATE(899),
    [sym_pipe] = STATE(899),
    [sym_unary] = STATE(899),
    [sym_binary] = STATE(899),
    [sym_na] = STATE(899),
    [sym__expression] = STATE(899),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(899),
    [sym_string] = STATE(899),
    [anon_sym_SEMI] = ACTIONS(793),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(795),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(795),
    [sym_next] = ACTIONS(795),
    [sym_true] = ACTIONS(795),
    [sym_false] = ACTIONS(795),
    [sym_null] = ACTIONS(795),
    [sym_inf] = ACTIONS(795),
    [sym_nan] = ACTIONS(795),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(793),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [109] = {
    [sym_function_definition] = STATE(896),
    [sym_lambda_function] = STATE(896),
    [sym_if] = STATE(896),
    [sym_while] = STATE(896),
    [sym_repeat] = STATE(896),
    [sym_for] = STATE(896),
    [sym_switch] = STATE(896),
    [sym_call] = STATE(896),
    [sym__assignment] = STATE(896),
    [sym_left_assignment] = STATE(896),
    [sym_left_assignment2] = STATE(896),
    [sym_equals_assignment] = STATE(896),
    [sym_super_assignment] = STATE(896),
    [sym_super_right_assignment] = STATE(896),
    [sym_right_assignment] = STATE(896),
    [sym_brace_list] = STATE(896),
    [sym_paren_list] = STATE(896),
    [sym_subset] = STATE(896),
    [sym_subset2] = STATE(896),
    [sym_dollar] = STATE(896),
    [sym_slot] = STATE(896),
    [sym_namespace_get] = STATE(896),
    [sym_namespace_get_internal] = STATE(896),
    [sym_pipe] = STATE(896),
    [sym_unary] = STATE(896),
    [sym_binary] = STATE(896),
    [sym_na] = STATE(896),
    [sym__expression] = STATE(896),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(896),
    [sym_string] = STATE(896),
    [anon_sym_SEMI] = ACTIONS(797),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(799),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(799),
    [sym_next] = ACTIONS(799),
    [sym_true] = ACTIONS(799),
    [sym_false] = ACTIONS(799),
    [sym_null] = ACTIONS(799),
    [sym_inf] = ACTIONS(799),
    [sym_nan] = ACTIONS(799),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(797),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [110] = {
    [sym_function_definition] = STATE(913),
    [sym_lambda_function] = STATE(913),
    [sym_if] = STATE(913),
    [sym_while] = STATE(913),
    [sym_repeat] = STATE(913),
    [sym_for] = STATE(913),
    [sym_switch] = STATE(913),
    [sym_call] = STATE(913),
    [sym__assignment] = STATE(913),
    [sym_left_assignment] = STATE(913),
    [sym_left_assignment2] = STATE(913),
    [sym_equals_assignment] = STATE(913),
    [sym_super_assignment] = STATE(913),
    [sym_super_right_assignment] = STATE(913),
    [sym_right_assignment] = STATE(913),
    [sym_brace_list] = STATE(913),
    [sym_paren_list] = STATE(913),
    [sym_subset] = STATE(913),
    [sym_subset2] = STATE(913),
    [sym_dollar] = STATE(913),
    [sym_slot] = STATE(913),
    [sym_namespace_get] = STATE(913),
    [sym_namespace_get_internal] = STATE(913),
    [sym_pipe] = STATE(913),
    [sym_unary] = STATE(913),
    [sym_binary] = STATE(913),
    [sym_na] = STATE(913),
    [sym__expression] = STATE(913),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(913),
    [sym_string] = STATE(913),
    [anon_sym_SEMI] = ACTIONS(801),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(803),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(803),
    [sym_next] = ACTIONS(803),
    [sym_true] = ACTIONS(803),
    [sym_false] = ACTIONS(803),
    [sym_null] = ACTIONS(803),
    [sym_inf] = ACTIONS(803),
    [sym_nan] = ACTIONS(803),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(801),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [111] = {
    [sym_function_definition] = STATE(884),
    [sym_lambda_function] = STATE(884),
    [sym_if] = STATE(884),
    [sym_while] = STATE(884),
    [sym_repeat] = STATE(884),
    [sym_for] = STATE(884),
    [sym_switch] = STATE(884),
    [sym_call] = STATE(884),
    [sym__assignment] = STATE(884),
    [sym_left_assignment] = STATE(884),
    [sym_left_assignment2] = STATE(884),
    [sym_equals_assignment] = STATE(884),
    [sym_super_assignment] = STATE(884),
    [sym_super_right_assignment] = STATE(884),
    [sym_right_assignment] = STATE(884),
    [sym_brace_list] = STATE(884),
    [sym_paren_list] = STATE(884),
    [sym_subset] = STATE(884),
    [sym_subset2] = STATE(884),
    [sym_dollar] = STATE(884),
    [sym_slot] = STATE(884),
    [sym_namespace_get] = STATE(884),
    [sym_namespace_get_internal] = STATE(884),
    [sym_pipe] = STATE(884),
    [sym_unary] = STATE(884),
    [sym_binary] = STATE(884),
    [sym_na] = STATE(884),
    [sym__expression] = STATE(884),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(884),
    [sym_string] = STATE(884),
    [anon_sym_SEMI] = ACTIONS(805),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(807),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(807),
    [sym_next] = ACTIONS(807),
    [sym_true] = ACTIONS(807),
    [sym_false] = ACTIONS(807),
    [sym_null] = ACTIONS(807),
    [sym_inf] = ACTIONS(807),
    [sym_nan] = ACTIONS(807),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(805),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [112] = {
    [sym_function_definition] = STATE(898),
    [sym_lambda_function] = STATE(898),
    [sym_if] = STATE(898),
    [sym_while] = STATE(898),
    [sym_repeat] = STATE(898),
    [sym_for] = STATE(898),
    [sym_switch] = STATE(898),
    [sym_call] = STATE(898),
    [sym__assignment] = STATE(898),
    [sym_left_assignment] = STATE(898),
    [sym_left_assignment2] = STATE(898),
    [sym_equals_assignment] = STATE(898),
    [sym_super_assignment] = STATE(898),
    [sym_super_right_assignment] = STATE(898),
    [sym_right_assignment] = STATE(898),
    [sym_brace_list] = STATE(898),
    [sym_paren_list] = STATE(898),
    [sym_subset] = STATE(898),
    [sym_subset2] = STATE(898),
    [sym_dollar] = STATE(898),
    [sym_slot] = STATE(898),
    [sym_namespace_get] = STATE(898),
    [sym_namespace_get_internal] = STATE(898),
    [sym_pipe] = STATE(898),
    [sym_unary] = STATE(898),
    [sym_binary] = STATE(898),
    [sym_na] = STATE(898),
    [sym__expression] = STATE(898),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(898),
    [sym_string] = STATE(898),
    [anon_sym_SEMI] = ACTIONS(809),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(811),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(811),
    [sym_next] = ACTIONS(811),
    [sym_true] = ACTIONS(811),
    [sym_false] = ACTIONS(811),
    [sym_null] = ACTIONS(811),
    [sym_inf] = ACTIONS(811),
    [sym_nan] = ACTIONS(811),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(809),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [113] = {
    [sym_function_definition] = STATE(882),
    [sym_lambda_function] = STATE(882),
    [sym_if] = STATE(882),
    [sym_while] = STATE(882),
    [sym_repeat] = STATE(882),
    [sym_for] = STATE(882),
    [sym_switch] = STATE(882),
    [sym_call] = STATE(882),
    [sym__assignment] = STATE(882),
    [sym_left_assignment] = STATE(882),
    [sym_left_assignment2] = STATE(882),
    [sym_equals_assignment] = STATE(882),
    [sym_super_assignment] = STATE(882),
    [sym_super_right_assignment] = STATE(882),
    [sym_right_assignment] = STATE(882),
    [sym_brace_list] = STATE(882),
    [sym_paren_list] = STATE(882),
    [sym_subset] = STATE(882),
    [sym_subset2] = STATE(882),
    [sym_dollar] = STATE(882),
    [sym_slot] = STATE(882),
    [sym_namespace_get] = STATE(882),
    [sym_namespace_get_internal] = STATE(882),
    [sym_pipe] = STATE(882),
    [sym_unary] = STATE(882),
    [sym_binary] = STATE(882),
    [sym_na] = STATE(882),
    [sym__expression] = STATE(882),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(882),
    [sym_string] = STATE(882),
    [anon_sym_SEMI] = ACTIONS(813),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(815),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(815),
    [sym_next] = ACTIONS(815),
    [sym_true] = ACTIONS(815),
    [sym_false] = ACTIONS(815),
    [sym_null] = ACTIONS(815),
    [sym_inf] = ACTIONS(815),
    [sym_nan] = ACTIONS(815),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(813),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [114] = {
    [sym_function_definition] = STATE(905),
    [sym_lambda_function] = STATE(905),
    [sym_if] = STATE(905),
    [sym_while] = STATE(905),
    [sym_repeat] = STATE(905),
    [sym_for] = STATE(905),
    [sym_switch] = STATE(905),
    [sym_call] = STATE(905),
    [sym__assignment] = STATE(905),
    [sym_left_assignment] = STATE(905),
    [sym_left_assignment2] = STATE(905),
    [sym_equals_assignment] = STATE(905),
    [sym_super_assignment] = STATE(905),
    [sym_super_right_assignment] = STATE(905),
    [sym_right_assignment] = STATE(905),
    [sym_brace_list] = STATE(905),
    [sym_paren_list] = STATE(905),
    [sym_subset] = STATE(905),
    [sym_subset2] = STATE(905),
    [sym_dollar] = STATE(905),
    [sym_slot] = STATE(905),
    [sym_namespace_get] = STATE(905),
    [sym_namespace_get_internal] = STATE(905),
    [sym_pipe] = STATE(905),
    [sym_unary] = STATE(905),
    [sym_binary] = STATE(905),
    [sym_na] = STATE(905),
    [sym__expression] = STATE(905),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(905),
    [sym_string] = STATE(905),
    [anon_sym_SEMI] = ACTIONS(817),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(819),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(819),
    [sym_next] = ACTIONS(819),
    [sym_true] = ACTIONS(819),
    [sym_false] = ACTIONS(819),
    [sym_null] = ACTIONS(819),
    [sym_inf] = ACTIONS(819),
    [sym_nan] = ACTIONS(819),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(817),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [115] = {
    [sym_function_definition] = STATE(895),
    [sym_lambda_function] = STATE(895),
    [sym_if] = STATE(895),
    [sym_while] = STATE(895),
    [sym_repeat] = STATE(895),
    [sym_for] = STATE(895),
    [sym_switch] = STATE(895),
    [sym_call] = STATE(895),
    [sym__assignment] = STATE(895),
    [sym_left_assignment] = STATE(895),
    [sym_left_assignment2] = STATE(895),
    [sym_equals_assignment] = STATE(895),
    [sym_super_assignment] = STATE(895),
    [sym_super_right_assignment] = STATE(895),
    [sym_right_assignment] = STATE(895),
    [sym_brace_list] = STATE(895),
    [sym_paren_list] = STATE(895),
    [sym_subset] = STATE(895),
    [sym_subset2] = STATE(895),
    [sym_dollar] = STATE(895),
    [sym_slot] = STATE(895),
    [sym_namespace_get] = STATE(895),
    [sym_namespace_get_internal] = STATE(895),
    [sym_pipe] = STATE(895),
    [sym_unary] = STATE(895),
    [sym_binary] = STATE(895),
    [sym_na] = STATE(895),
    [sym__expression] = STATE(895),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(895),
    [sym_string] = STATE(895),
    [anon_sym_SEMI] = ACTIONS(821),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(823),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(823),
    [sym_next] = ACTIONS(823),
    [sym_true] = ACTIONS(823),
    [sym_false] = ACTIONS(823),
    [sym_null] = ACTIONS(823),
    [sym_inf] = ACTIONS(823),
    [sym_nan] = ACTIONS(823),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(821),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [116] = {
    [sym_function_definition] = STATE(602),
    [sym_lambda_function] = STATE(602),
    [sym_if] = STATE(602),
    [sym_while] = STATE(602),
    [sym_repeat] = STATE(602),
    [sym_for] = STATE(602),
    [sym_switch] = STATE(602),
    [sym_call] = STATE(602),
    [sym__assignment] = STATE(602),
    [sym_left_assignment] = STATE(602),
    [sym_left_assignment2] = STATE(602),
    [sym_equals_assignment] = STATE(602),
    [sym_super_assignment] = STATE(602),
    [sym_super_right_assignment] = STATE(602),
    [sym_right_assignment] = STATE(602),
    [sym_brace_list] = STATE(602),
    [sym_paren_list] = STATE(602),
    [sym_subset] = STATE(602),
    [sym_subset2] = STATE(602),
    [sym_dollar] = STATE(602),
    [sym_slot] = STATE(602),
    [sym_namespace_get] = STATE(602),
    [sym_namespace_get_internal] = STATE(602),
    [sym_pipe] = STATE(602),
    [sym_unary] = STATE(602),
    [sym_binary] = STATE(602),
    [sym_na] = STATE(602),
    [sym__expression] = STATE(602),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(602),
    [sym_string] = STATE(602),
    [anon_sym_SEMI] = ACTIONS(825),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(827),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(827),
    [sym_next] = ACTIONS(827),
    [sym_true] = ACTIONS(827),
    [sym_false] = ACTIONS(827),
    [sym_null] = ACTIONS(827),
    [sym_inf] = ACTIONS(827),
    [sym_nan] = ACTIONS(827),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(825),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [117] = {
    [sym_function_definition] = STATE(908),
    [sym_lambda_function] = STATE(908),
    [sym_if] = STATE(908),
    [sym_while] = STATE(908),
    [sym_repeat] = STATE(908),
    [sym_for] = STATE(908),
    [sym_switch] = STATE(908),
    [sym_call] = STATE(908),
    [sym__assignment] = STATE(908),
    [sym_left_assignment] = STATE(908),
    [sym_left_assignment2] = STATE(908),
    [sym_equals_assignment] = STATE(908),
    [sym_super_assignment] = STATE(908),
    [sym_super_right_assignment] = STATE(908),
    [sym_right_assignment] = STATE(908),
    [sym_brace_list] = STATE(908),
    [sym_paren_list] = STATE(908),
    [sym_subset] = STATE(908),
    [sym_subset2] = STATE(908),
    [sym_dollar] = STATE(908),
    [sym_slot] = STATE(908),
    [sym_namespace_get] = STATE(908),
    [sym_namespace_get_internal] = STATE(908),
    [sym_pipe] = STATE(908),
    [sym_unary] = STATE(908),
    [sym_binary] = STATE(908),
    [sym_na] = STATE(908),
    [sym__expression] = STATE(908),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(908),
    [sym_string] = STATE(908),
    [anon_sym_SEMI] = ACTIONS(829),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(831),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(831),
    [sym_next] = ACTIONS(831),
    [sym_true] = ACTIONS(831),
    [sym_false] = ACTIONS(831),
    [sym_null] = ACTIONS(831),
    [sym_inf] = ACTIONS(831),
    [sym_nan] = ACTIONS(831),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(829),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [118] = {
    [sym_function_definition] = STATE(914),
    [sym_lambda_function] = STATE(914),
    [sym_if] = STATE(914),
    [sym_while] = STATE(914),
    [sym_repeat] = STATE(914),
    [sym_for] = STATE(914),
    [sym_switch] = STATE(914),
    [sym_call] = STATE(914),
    [sym__assignment] = STATE(914),
    [sym_left_assignment] = STATE(914),
    [sym_left_assignment2] = STATE(914),
    [sym_equals_assignment] = STATE(914),
    [sym_super_assignment] = STATE(914),
    [sym_super_right_assignment] = STATE(914),
    [sym_right_assignment] = STATE(914),
    [sym_brace_list] = STATE(914),
    [sym_paren_list] = STATE(914),
    [sym_subset] = STATE(914),
    [sym_subset2] = STATE(914),
    [sym_dollar] = STATE(914),
    [sym_slot] = STATE(914),
    [sym_namespace_get] = STATE(914),
    [sym_namespace_get_internal] = STATE(914),
    [sym_pipe] = STATE(914),
    [sym_unary] = STATE(914),
    [sym_binary] = STATE(914),
    [sym_na] = STATE(914),
    [sym__expression] = STATE(914),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(914),
    [sym_string] = STATE(914),
    [anon_sym_SEMI] = ACTIONS(833),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(835),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(835),
    [sym_next] = ACTIONS(835),
    [sym_true] = ACTIONS(835),
    [sym_false] = ACTIONS(835),
    [sym_null] = ACTIONS(835),
    [sym_inf] = ACTIONS(835),
    [sym_nan] = ACTIONS(835),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(833),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [119] = {
    [sym_function_definition] = STATE(902),
    [sym_lambda_function] = STATE(902),
    [sym_if] = STATE(902),
    [sym_while] = STATE(902),
    [sym_repeat] = STATE(902),
    [sym_for] = STATE(902),
    [sym_switch] = STATE(902),
    [sym_call] = STATE(902),
    [sym__assignment] = STATE(902),
    [sym_left_assignment] = STATE(902),
    [sym_left_assignment2] = STATE(902),
    [sym_equals_assignment] = STATE(902),
    [sym_super_assignment] = STATE(902),
    [sym_super_right_assignment] = STATE(902),
    [sym_right_assignment] = STATE(902),
    [sym_brace_list] = STATE(902),
    [sym_paren_list] = STATE(902),
    [sym_subset] = STATE(902),
    [sym_subset2] = STATE(902),
    [sym_dollar] = STATE(902),
    [sym_slot] = STATE(902),
    [sym_namespace_get] = STATE(902),
    [sym_namespace_get_internal] = STATE(902),
    [sym_pipe] = STATE(902),
    [sym_unary] = STATE(902),
    [sym_binary] = STATE(902),
    [sym_na] = STATE(902),
    [sym__expression] = STATE(902),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(902),
    [sym_string] = STATE(902),
    [anon_sym_SEMI] = ACTIONS(837),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(839),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(839),
    [sym_next] = ACTIONS(839),
    [sym_true] = ACTIONS(839),
    [sym_false] = ACTIONS(839),
    [sym_null] = ACTIONS(839),
    [sym_inf] = ACTIONS(839),
    [sym_nan] = ACTIONS(839),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(837),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [120] = {
    [sym_function_definition] = STATE(911),
    [sym_lambda_function] = STATE(911),
    [sym_if] = STATE(911),
    [sym_while] = STATE(911),
    [sym_repeat] = STATE(911),
    [sym_for] = STATE(911),
    [sym_switch] = STATE(911),
    [sym_call] = STATE(911),
    [sym__assignment] = STATE(911),
    [sym_left_assignment] = STATE(911),
    [sym_left_assignment2] = STATE(911),
    [sym_equals_assignment] = STATE(911),
    [sym_super_assignment] = STATE(911),
    [sym_super_right_assignment] = STATE(911),
    [sym_right_assignment] = STATE(911),
    [sym_brace_list] = STATE(911),
    [sym_paren_list] = STATE(911),
    [sym_subset] = STATE(911),
    [sym_subset2] = STATE(911),
    [sym_dollar] = STATE(911),
    [sym_slot] = STATE(911),
    [sym_namespace_get] = STATE(911),
    [sym_namespace_get_internal] = STATE(911),
    [sym_pipe] = STATE(911),
    [sym_unary] = STATE(911),
    [sym_binary] = STATE(911),
    [sym_na] = STATE(911),
    [sym__expression] = STATE(911),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(911),
    [sym_string] = STATE(911),
    [anon_sym_SEMI] = ACTIONS(841),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(843),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(843),
    [sym_next] = ACTIONS(843),
    [sym_true] = ACTIONS(843),
    [sym_false] = ACTIONS(843),
    [sym_null] = ACTIONS(843),
    [sym_inf] = ACTIONS(843),
    [sym_nan] = ACTIONS(843),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(841),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [121] = {
    [sym_function_definition] = STATE(894),
    [sym_lambda_function] = STATE(894),
    [sym_if] = STATE(894),
    [sym_while] = STATE(894),
    [sym_repeat] = STATE(894),
    [sym_for] = STATE(894),
    [sym_switch] = STATE(894),
    [sym_call] = STATE(894),
    [sym__assignment] = STATE(894),
    [sym_left_assignment] = STATE(894),
    [sym_left_assignment2] = STATE(894),
    [sym_equals_assignment] = STATE(894),
    [sym_super_assignment] = STATE(894),
    [sym_super_right_assignment] = STATE(894),
    [sym_right_assignment] = STATE(894),
    [sym_brace_list] = STATE(894),
    [sym_paren_list] = STATE(894),
    [sym_subset] = STATE(894),
    [sym_subset2] = STATE(894),
    [sym_dollar] = STATE(894),
    [sym_slot] = STATE(894),
    [sym_namespace_get] = STATE(894),
    [sym_namespace_get_internal] = STATE(894),
    [sym_pipe] = STATE(894),
    [sym_unary] = STATE(894),
    [sym_binary] = STATE(894),
    [sym_na] = STATE(894),
    [sym__expression] = STATE(894),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(894),
    [sym_string] = STATE(894),
    [anon_sym_SEMI] = ACTIONS(845),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(847),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(847),
    [sym_next] = ACTIONS(847),
    [sym_true] = ACTIONS(847),
    [sym_false] = ACTIONS(847),
    [sym_null] = ACTIONS(847),
    [sym_inf] = ACTIONS(847),
    [sym_nan] = ACTIONS(847),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(845),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [122] = {
    [sym_function_definition] = STATE(888),
    [sym_lambda_function] = STATE(888),
    [sym_if] = STATE(888),
    [sym_while] = STATE(888),
    [sym_repeat] = STATE(888),
    [sym_for] = STATE(888),
    [sym_switch] = STATE(888),
    [sym_call] = STATE(888),
    [sym__assignment] = STATE(888),
    [sym_left_assignment] = STATE(888),
    [sym_left_assignment2] = STATE(888),
    [sym_equals_assignment] = STATE(888),
    [sym_super_assignment] = STATE(888),
    [sym_super_right_assignment] = STATE(888),
    [sym_right_assignment] = STATE(888),
    [sym_brace_list] = STATE(888),
    [sym_paren_list] = STATE(888),
    [sym_subset] = STATE(888),
    [sym_subset2] = STATE(888),
    [sym_dollar] = STATE(888),
    [sym_slot] = STATE(888),
    [sym_namespace_get] = STATE(888),
    [sym_namespace_get_internal] = STATE(888),
    [sym_pipe] = STATE(888),
    [sym_unary] = STATE(888),
    [sym_binary] = STATE(888),
    [sym_na] = STATE(888),
    [sym__expression] = STATE(888),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(888),
    [sym_string] = STATE(888),
    [anon_sym_SEMI] = ACTIONS(849),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(851),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(851),
    [sym_next] = ACTIONS(851),
    [sym_true] = ACTIONS(851),
    [sym_false] = ACTIONS(851),
    [sym_null] = ACTIONS(851),
    [sym_inf] = ACTIONS(851),
    [sym_nan] = ACTIONS(851),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(849),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [123] = {
    [sym_function_definition] = STATE(597),
    [sym_lambda_function] = STATE(597),
    [sym_if] = STATE(597),
    [sym_while] = STATE(597),
    [sym_repeat] = STATE(597),
    [sym_for] = STATE(597),
    [sym_switch] = STATE(597),
    [sym_call] = STATE(597),
    [sym__assignment] = STATE(597),
    [sym_left_assignment] = STATE(597),
    [sym_left_assignment2] = STATE(597),
    [sym_equals_assignment] = STATE(597),
    [sym_super_assignment] = STATE(597),
    [sym_super_right_assignment] = STATE(597),
    [sym_right_assignment] = STATE(597),
    [sym_brace_list] = STATE(597),
    [sym_paren_list] = STATE(597),
    [sym_subset] = STATE(597),
    [sym_subset2] = STATE(597),
    [sym_dollar] = STATE(597),
    [sym_slot] = STATE(597),
    [sym_namespace_get] = STATE(597),
    [sym_namespace_get_internal] = STATE(597),
    [sym_pipe] = STATE(597),
    [sym_unary] = STATE(597),
    [sym_binary] = STATE(597),
    [sym_na] = STATE(597),
    [sym__expression] = STATE(597),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(597),
    [sym_string] = STATE(597),
    [anon_sym_SEMI] = ACTIONS(853),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(855),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(855),
    [sym_next] = ACTIONS(855),
    [sym_true] = ACTIONS(855),
    [sym_false] = ACTIONS(855),
    [sym_null] = ACTIONS(855),
    [sym_inf] = ACTIONS(855),
    [sym_nan] = ACTIONS(855),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(853),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [124] = {
    [sym_function_definition] = STATE(848),
    [sym_lambda_function] = STATE(848),
    [sym_if] = STATE(848),
    [sym_while] = STATE(848),
    [sym_repeat] = STATE(848),
    [sym_for] = STATE(848),
    [sym_switch] = STATE(848),
    [sym_call] = STATE(848),
    [sym__assignment] = STATE(848),
    [sym_left_assignment] = STATE(848),
    [sym_left_assignment2] = STATE(848),
    [sym_equals_assignment] = STATE(848),
    [sym_super_assignment] = STATE(848),
    [sym_super_right_assignment] = STATE(848),
    [sym_right_assignment] = STATE(848),
    [sym_brace_list] = STATE(848),
    [sym_paren_list] = STATE(848),
    [sym_subset] = STATE(848),
    [sym_subset2] = STATE(848),
    [sym_dollar] = STATE(848),
    [sym_slot] = STATE(848),
    [sym_namespace_get] = STATE(848),
    [sym_namespace_get_internal] = STATE(848),
    [sym_pipe] = STATE(848),
    [sym_unary] = STATE(848),
    [sym_binary] = STATE(848),
    [sym_na] = STATE(848),
    [sym__expression] = STATE(848),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(848),
    [sym_string] = STATE(848),
    [anon_sym_SEMI] = ACTIONS(857),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(859),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(859),
    [sym_next] = ACTIONS(859),
    [sym_true] = ACTIONS(859),
    [sym_false] = ACTIONS(859),
    [sym_null] = ACTIONS(859),
    [sym_inf] = ACTIONS(859),
    [sym_nan] = ACTIONS(859),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(857),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [125] = {
    [sym_function_definition] = STATE(892),
    [sym_lambda_function] = STATE(892),
    [sym_if] = STATE(892),
    [sym_while] = STATE(892),
    [sym_repeat] = STATE(892),
    [sym_for] = STATE(892),
    [sym_switch] = STATE(892),
    [sym_call] = STATE(892),
    [sym__assignment] = STATE(892),
    [sym_left_assignment] = STATE(892),
    [sym_left_assignment2] = STATE(892),
    [sym_equals_assignment] = STATE(892),
    [sym_super_assignment] = STATE(892),
    [sym_super_right_assignment] = STATE(892),
    [sym_right_assignment] = STATE(892),
    [sym_brace_list] = STATE(892),
    [sym_paren_list] = STATE(892),
    [sym_subset] = STATE(892),
    [sym_subset2] = STATE(892),
    [sym_dollar] = STATE(892),
    [sym_slot] = STATE(892),
    [sym_namespace_get] = STATE(892),
    [sym_namespace_get_internal] = STATE(892),
    [sym_pipe] = STATE(892),
    [sym_unary] = STATE(892),
    [sym_binary] = STATE(892),
    [sym_na] = STATE(892),
    [sym__expression] = STATE(892),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(892),
    [sym_string] = STATE(892),
    [anon_sym_SEMI] = ACTIONS(861),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(863),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(863),
    [sym_next] = ACTIONS(863),
    [sym_true] = ACTIONS(863),
    [sym_false] = ACTIONS(863),
    [sym_null] = ACTIONS(863),
    [sym_inf] = ACTIONS(863),
    [sym_nan] = ACTIONS(863),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(861),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [126] = {
    [sym_function_definition] = STATE(885),
    [sym_lambda_function] = STATE(885),
    [sym_if] = STATE(885),
    [sym_while] = STATE(885),
    [sym_repeat] = STATE(885),
    [sym_for] = STATE(885),
    [sym_switch] = STATE(885),
    [sym_call] = STATE(885),
    [sym__assignment] = STATE(885),
    [sym_left_assignment] = STATE(885),
    [sym_left_assignment2] = STATE(885),
    [sym_equals_assignment] = STATE(885),
    [sym_super_assignment] = STATE(885),
    [sym_super_right_assignment] = STATE(885),
    [sym_right_assignment] = STATE(885),
    [sym_brace_list] = STATE(885),
    [sym_paren_list] = STATE(885),
    [sym_subset] = STATE(885),
    [sym_subset2] = STATE(885),
    [sym_dollar] = STATE(885),
    [sym_slot] = STATE(885),
    [sym_namespace_get] = STATE(885),
    [sym_namespace_get_internal] = STATE(885),
    [sym_pipe] = STATE(885),
    [sym_unary] = STATE(885),
    [sym_binary] = STATE(885),
    [sym_na] = STATE(885),
    [sym__expression] = STATE(885),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(885),
    [sym_string] = STATE(885),
    [anon_sym_SEMI] = ACTIONS(865),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(867),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(867),
    [sym_next] = ACTIONS(867),
    [sym_true] = ACTIONS(867),
    [sym_false] = ACTIONS(867),
    [sym_null] = ACTIONS(867),
    [sym_inf] = ACTIONS(867),
    [sym_nan] = ACTIONS(867),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(865),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [127] = {
    [sym_function_definition] = STATE(508),
    [sym_lambda_function] = STATE(508),
    [sym_if] = STATE(508),
    [sym_while] = STATE(508),
    [sym_repeat] = STATE(508),
    [sym_for] = STATE(508),
    [sym_switch] = STATE(508),
    [sym_call] = STATE(508),
    [sym__assignment] = STATE(508),
    [sym_left_assignment] = STATE(508),
    [sym_left_assignment2] = STATE(508),
    [sym_equals_assignment] = STATE(508),
    [sym_super_assignment] = STATE(508),
    [sym_super_right_assignment] = STATE(508),
    [sym_right_assignment] = STATE(508),
    [sym_brace_list] = STATE(508),
    [sym_paren_list] = STATE(508),
    [sym_subset] = STATE(508),
    [sym_subset2] = STATE(508),
    [sym_dollar] = STATE(508),
    [sym_slot] = STATE(508),
    [sym_namespace_get] = STATE(508),
    [sym_namespace_get_internal] = STATE(508),
    [sym_pipe] = STATE(508),
    [sym_unary] = STATE(508),
    [sym_binary] = STATE(508),
    [sym_na] = STATE(508),
    [sym__expression] = STATE(508),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(508),
    [sym_string] = STATE(508),
    [anon_sym_SEMI] = ACTIONS(869),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(871),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(871),
    [sym_next] = ACTIONS(871),
    [sym_true] = ACTIONS(871),
    [sym_false] = ACTIONS(871),
    [sym_null] = ACTIONS(871),
    [sym_inf] = ACTIONS(871),
    [sym_nan] = ACTIONS(871),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(869),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [128] = {
    [sym_function_definition] = STATE(556),
    [sym_lambda_function] = STATE(556),
    [sym_if] = STATE(556),
    [sym_while] = STATE(556),
    [sym_repeat] = STATE(556),
    [sym_for] = STATE(556),
    [sym_switch] = STATE(556),
    [sym_call] = STATE(556),
    [sym__assignment] = STATE(556),
    [sym_left_assignment] = STATE(556),
    [sym_left_assignment2] = STATE(556),
    [sym_equals_assignment] = STATE(556),
    [sym_super_assignment] = STATE(556),
    [sym_super_right_assignment] = STATE(556),
    [sym_right_assignment] = STATE(556),
    [sym_brace_list] = STATE(556),
    [sym_paren_list] = STATE(556),
    [sym_subset] = STATE(556),
    [sym_subset2] = STATE(556),
    [sym_dollar] = STATE(556),
    [sym_slot] = STATE(556),
    [sym_namespace_get] = STATE(556),
    [sym_namespace_get_internal] = STATE(556),
    [sym_pipe] = STATE(556),
    [sym_unary] = STATE(556),
    [sym_binary] = STATE(556),
    [sym_na] = STATE(556),
    [sym__expression] = STATE(556),
    [sym_identifier] = STATE(330),
    [sym_complex] = STATE(556),
    [sym_string] = STATE(556),
    [anon_sym_SEMI] = ACTIONS(873),
    [anon_sym_function] = ACTIONS(875),
    [anon_sym_BSLASH] = ACTIONS(877),
    [anon_sym_if] = ACTIONS(879),
    [anon_sym_LPAREN] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_repeat] = ACTIONS(885),
    [anon_sym_for] = ACTIONS(887),
    [anon_sym_switch] = ACTIONS(889),
    [anon_sym_LBRACE] = ACTIONS(891),
    [sym_dots] = ACTIONS(893),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_PLUS] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(897),
    [anon_sym_TILDE] = ACTIONS(899),
    [sym_break] = ACTIONS(893),
    [sym_next] = ACTIONS(893),
    [sym_true] = ACTIONS(893),
    [sym_false] = ACTIONS(893),
    [sym_null] = ACTIONS(893),
    [sym_inf] = ACTIONS(893),
    [sym_nan] = ACTIONS(893),
    [anon_sym_NA] = ACTIONS(901),
    [anon_sym_NA_character_] = ACTIONS(901),
    [anon_sym_NA_complex_] = ACTIONS(901),
    [anon_sym_NA_integer_] = ACTIONS(901),
    [anon_sym_NA_real_] = ACTIONS(901),
    [aux_sym_identifier_token1] = ACTIONS(903),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [sym_integer] = ACTIONS(873),
    [sym_float] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(909),
    [anon_sym_SQUOTE] = ACTIONS(911),
  },
  [129] = {
    [sym_function_definition] = STATE(601),
    [sym_lambda_function] = STATE(601),
    [sym_if] = STATE(601),
    [sym_while] = STATE(601),
    [sym_repeat] = STATE(601),
    [sym_for] = STATE(601),
    [sym_switch] = STATE(601),
    [sym_call] = STATE(601),
    [sym__assignment] = STATE(601),
    [sym_left_assignment] = STATE(601),
    [sym_left_assignment2] = STATE(601),
    [sym_equals_assignment] = STATE(601),
    [sym_super_assignment] = STATE(601),
    [sym_super_right_assignment] = STATE(601),
    [sym_right_assignment] = STATE(601),
    [sym_brace_list] = STATE(601),
    [sym_paren_list] = STATE(601),
    [sym_subset] = STATE(601),
    [sym_subset2] = STATE(601),
    [sym_dollar] = STATE(601),
    [sym_slot] = STATE(601),
    [sym_namespace_get] = STATE(601),
    [sym_namespace_get_internal] = STATE(601),
    [sym_pipe] = STATE(601),
    [sym_unary] = STATE(601),
    [sym_binary] = STATE(601),
    [sym_na] = STATE(601),
    [sym__expression] = STATE(601),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(601),
    [sym_string] = STATE(601),
    [anon_sym_SEMI] = ACTIONS(913),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(915),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(915),
    [sym_next] = ACTIONS(915),
    [sym_true] = ACTIONS(915),
    [sym_false] = ACTIONS(915),
    [sym_null] = ACTIONS(915),
    [sym_inf] = ACTIONS(915),
    [sym_nan] = ACTIONS(915),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(913),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [130] = {
    [sym_function_definition] = STATE(910),
    [sym_lambda_function] = STATE(910),
    [sym_if] = STATE(910),
    [sym_while] = STATE(910),
    [sym_repeat] = STATE(910),
    [sym_for] = STATE(910),
    [sym_switch] = STATE(910),
    [sym_call] = STATE(910),
    [sym__assignment] = STATE(910),
    [sym_left_assignment] = STATE(910),
    [sym_left_assignment2] = STATE(910),
    [sym_equals_assignment] = STATE(910),
    [sym_super_assignment] = STATE(910),
    [sym_super_right_assignment] = STATE(910),
    [sym_right_assignment] = STATE(910),
    [sym_brace_list] = STATE(910),
    [sym_paren_list] = STATE(910),
    [sym_subset] = STATE(910),
    [sym_subset2] = STATE(910),
    [sym_dollar] = STATE(910),
    [sym_slot] = STATE(910),
    [sym_namespace_get] = STATE(910),
    [sym_namespace_get_internal] = STATE(910),
    [sym_pipe] = STATE(910),
    [sym_unary] = STATE(910),
    [sym_binary] = STATE(910),
    [sym_na] = STATE(910),
    [sym__expression] = STATE(910),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(910),
    [sym_string] = STATE(910),
    [anon_sym_SEMI] = ACTIONS(917),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(919),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(919),
    [sym_next] = ACTIONS(919),
    [sym_true] = ACTIONS(919),
    [sym_false] = ACTIONS(919),
    [sym_null] = ACTIONS(919),
    [sym_inf] = ACTIONS(919),
    [sym_nan] = ACTIONS(919),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(917),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [131] = {
    [sym_function_definition] = STATE(585),
    [sym_lambda_function] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_repeat] = STATE(585),
    [sym_for] = STATE(585),
    [sym_switch] = STATE(585),
    [sym_call] = STATE(585),
    [sym__assignment] = STATE(585),
    [sym_left_assignment] = STATE(585),
    [sym_left_assignment2] = STATE(585),
    [sym_equals_assignment] = STATE(585),
    [sym_super_assignment] = STATE(585),
    [sym_super_right_assignment] = STATE(585),
    [sym_right_assignment] = STATE(585),
    [sym_brace_list] = STATE(585),
    [sym_paren_list] = STATE(585),
    [sym_subset] = STATE(585),
    [sym_subset2] = STATE(585),
    [sym_dollar] = STATE(585),
    [sym_slot] = STATE(585),
    [sym_namespace_get] = STATE(585),
    [sym_namespace_get_internal] = STATE(585),
    [sym_pipe] = STATE(585),
    [sym_unary] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_na] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(585),
    [sym_string] = STATE(585),
    [anon_sym_SEMI] = ACTIONS(921),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(923),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(923),
    [sym_next] = ACTIONS(923),
    [sym_true] = ACTIONS(923),
    [sym_false] = ACTIONS(923),
    [sym_null] = ACTIONS(923),
    [sym_inf] = ACTIONS(923),
    [sym_nan] = ACTIONS(923),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(921),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [132] = {
    [sym_function_definition] = STATE(881),
    [sym_lambda_function] = STATE(881),
    [sym_if] = STATE(881),
    [sym_while] = STATE(881),
    [sym_repeat] = STATE(881),
    [sym_for] = STATE(881),
    [sym_switch] = STATE(881),
    [sym_call] = STATE(881),
    [sym__assignment] = STATE(881),
    [sym_left_assignment] = STATE(881),
    [sym_left_assignment2] = STATE(881),
    [sym_equals_assignment] = STATE(881),
    [sym_super_assignment] = STATE(881),
    [sym_super_right_assignment] = STATE(881),
    [sym_right_assignment] = STATE(881),
    [sym_brace_list] = STATE(881),
    [sym_paren_list] = STATE(881),
    [sym_subset] = STATE(881),
    [sym_subset2] = STATE(881),
    [sym_dollar] = STATE(881),
    [sym_slot] = STATE(881),
    [sym_namespace_get] = STATE(881),
    [sym_namespace_get_internal] = STATE(881),
    [sym_pipe] = STATE(881),
    [sym_unary] = STATE(881),
    [sym_binary] = STATE(881),
    [sym_na] = STATE(881),
    [sym__expression] = STATE(881),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(881),
    [sym_string] = STATE(881),
    [anon_sym_SEMI] = ACTIONS(925),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(927),
    [sym_next] = ACTIONS(927),
    [sym_true] = ACTIONS(927),
    [sym_false] = ACTIONS(927),
    [sym_null] = ACTIONS(927),
    [sym_inf] = ACTIONS(927),
    [sym_nan] = ACTIONS(927),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(925),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [133] = {
    [sym_function_definition] = STATE(484),
    [sym_lambda_function] = STATE(484),
    [sym_if] = STATE(484),
    [sym_while] = STATE(484),
    [sym_repeat] = STATE(484),
    [sym_for] = STATE(484),
    [sym_switch] = STATE(484),
    [sym_call] = STATE(484),
    [sym__assignment] = STATE(484),
    [sym_left_assignment] = STATE(484),
    [sym_left_assignment2] = STATE(484),
    [sym_equals_assignment] = STATE(484),
    [sym_super_assignment] = STATE(484),
    [sym_super_right_assignment] = STATE(484),
    [sym_right_assignment] = STATE(484),
    [sym_brace_list] = STATE(484),
    [sym_paren_list] = STATE(484),
    [sym_subset] = STATE(484),
    [sym_subset2] = STATE(484),
    [sym_dollar] = STATE(484),
    [sym_slot] = STATE(484),
    [sym_namespace_get] = STATE(484),
    [sym_namespace_get_internal] = STATE(484),
    [sym_pipe] = STATE(484),
    [sym_unary] = STATE(484),
    [sym_binary] = STATE(484),
    [sym_na] = STATE(484),
    [sym__expression] = STATE(484),
    [sym_identifier] = STATE(330),
    [sym_complex] = STATE(484),
    [sym_string] = STATE(484),
    [anon_sym_SEMI] = ACTIONS(929),
    [anon_sym_function] = ACTIONS(875),
    [anon_sym_BSLASH] = ACTIONS(877),
    [anon_sym_if] = ACTIONS(879),
    [anon_sym_LPAREN] = ACTIONS(881),
    [anon_sym_while] = ACTIONS(883),
    [anon_sym_repeat] = ACTIONS(885),
    [anon_sym_for] = ACTIONS(887),
    [anon_sym_switch] = ACTIONS(889),
    [anon_sym_LBRACE] = ACTIONS(891),
    [sym_dots] = ACTIONS(931),
    [anon_sym_DASH] = ACTIONS(895),
    [anon_sym_PLUS] = ACTIONS(895),
    [anon_sym_BANG] = ACTIONS(897),
    [anon_sym_TILDE] = ACTIONS(899),
    [sym_break] = ACTIONS(931),
    [sym_next] = ACTIONS(931),
    [sym_true] = ACTIONS(931),
    [sym_false] = ACTIONS(931),
    [sym_null] = ACTIONS(931),
    [sym_inf] = ACTIONS(931),
    [sym_nan] = ACTIONS(931),
    [anon_sym_NA] = ACTIONS(901),
    [anon_sym_NA_character_] = ACTIONS(901),
    [anon_sym_NA_complex_] = ACTIONS(901),
    [anon_sym_NA_integer_] = ACTIONS(901),
    [anon_sym_NA_real_] = ACTIONS(901),
    [aux_sym_identifier_token1] = ACTIONS(903),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [sym_integer] = ACTIONS(929),
    [sym_float] = ACTIONS(907),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(909),
    [anon_sym_SQUOTE] = ACTIONS(911),
  },
  [134] = {
    [sym_function_definition] = STATE(906),
    [sym_lambda_function] = STATE(906),
    [sym_if] = STATE(906),
    [sym_while] = STATE(906),
    [sym_repeat] = STATE(906),
    [sym_for] = STATE(906),
    [sym_switch] = STATE(906),
    [sym_call] = STATE(906),
    [sym__assignment] = STATE(906),
    [sym_left_assignment] = STATE(906),
    [sym_left_assignment2] = STATE(906),
    [sym_equals_assignment] = STATE(906),
    [sym_super_assignment] = STATE(906),
    [sym_super_right_assignment] = STATE(906),
    [sym_right_assignment] = STATE(906),
    [sym_brace_list] = STATE(906),
    [sym_paren_list] = STATE(906),
    [sym_subset] = STATE(906),
    [sym_subset2] = STATE(906),
    [sym_dollar] = STATE(906),
    [sym_slot] = STATE(906),
    [sym_namespace_get] = STATE(906),
    [sym_namespace_get_internal] = STATE(906),
    [sym_pipe] = STATE(906),
    [sym_unary] = STATE(906),
    [sym_binary] = STATE(906),
    [sym_na] = STATE(906),
    [sym__expression] = STATE(906),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(906),
    [sym_string] = STATE(906),
    [anon_sym_SEMI] = ACTIONS(933),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(935),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(935),
    [sym_next] = ACTIONS(935),
    [sym_true] = ACTIONS(935),
    [sym_false] = ACTIONS(935),
    [sym_null] = ACTIONS(935),
    [sym_inf] = ACTIONS(935),
    [sym_nan] = ACTIONS(935),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(933),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [135] = {
    [sym_function_definition] = STATE(922),
    [sym_lambda_function] = STATE(922),
    [sym_if] = STATE(922),
    [sym_while] = STATE(922),
    [sym_repeat] = STATE(922),
    [sym_for] = STATE(922),
    [sym_switch] = STATE(922),
    [sym_call] = STATE(716),
    [sym__assignment] = STATE(922),
    [sym_left_assignment] = STATE(922),
    [sym_left_assignment2] = STATE(922),
    [sym_equals_assignment] = STATE(922),
    [sym_super_assignment] = STATE(922),
    [sym_super_right_assignment] = STATE(922),
    [sym_right_assignment] = STATE(922),
    [sym_brace_list] = STATE(922),
    [sym_paren_list] = STATE(922),
    [sym_subset] = STATE(922),
    [sym_subset2] = STATE(922),
    [sym_dollar] = STATE(922),
    [sym_slot] = STATE(922),
    [sym_namespace_get] = STATE(922),
    [sym_namespace_get_internal] = STATE(922),
    [sym_pipe] = STATE(922),
    [sym_unary] = STATE(922),
    [sym_binary] = STATE(922),
    [sym_na] = STATE(922),
    [sym__expression] = STATE(922),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(922),
    [sym_string] = STATE(922),
    [anon_sym_SEMI] = ACTIONS(937),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(939),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(939),
    [sym_next] = ACTIONS(939),
    [sym_true] = ACTIONS(939),
    [sym_false] = ACTIONS(939),
    [sym_null] = ACTIONS(939),
    [sym_inf] = ACTIONS(939),
    [sym_nan] = ACTIONS(939),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(937),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [136] = {
    [sym_function_definition] = STATE(574),
    [sym_lambda_function] = STATE(574),
    [sym_if] = STATE(574),
    [sym_while] = STATE(574),
    [sym_repeat] = STATE(574),
    [sym_for] = STATE(574),
    [sym_switch] = STATE(574),
    [sym_call] = STATE(574),
    [sym__assignment] = STATE(574),
    [sym_left_assignment] = STATE(574),
    [sym_left_assignment2] = STATE(574),
    [sym_equals_assignment] = STATE(574),
    [sym_super_assignment] = STATE(574),
    [sym_super_right_assignment] = STATE(574),
    [sym_right_assignment] = STATE(574),
    [sym_brace_list] = STATE(574),
    [sym_paren_list] = STATE(574),
    [sym_subset] = STATE(574),
    [sym_subset2] = STATE(574),
    [sym_dollar] = STATE(574),
    [sym_slot] = STATE(574),
    [sym_namespace_get] = STATE(574),
    [sym_namespace_get_internal] = STATE(574),
    [sym_pipe] = STATE(574),
    [sym_unary] = STATE(574),
    [sym_binary] = STATE(574),
    [sym_na] = STATE(574),
    [sym__expression] = STATE(574),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(574),
    [sym_string] = STATE(574),
    [anon_sym_SEMI] = ACTIONS(941),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(943),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(943),
    [sym_next] = ACTIONS(943),
    [sym_true] = ACTIONS(943),
    [sym_false] = ACTIONS(943),
    [sym_null] = ACTIONS(943),
    [sym_inf] = ACTIONS(943),
    [sym_nan] = ACTIONS(943),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(941),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [137] = {
    [sym_function_definition] = STATE(808),
    [sym_lambda_function] = STATE(808),
    [sym_if] = STATE(808),
    [sym_while] = STATE(808),
    [sym_repeat] = STATE(808),
    [sym_for] = STATE(808),
    [sym_switch] = STATE(808),
    [sym_call] = STATE(808),
    [sym__assignment] = STATE(808),
    [sym_left_assignment] = STATE(808),
    [sym_left_assignment2] = STATE(808),
    [sym_equals_assignment] = STATE(808),
    [sym_super_assignment] = STATE(808),
    [sym_super_right_assignment] = STATE(808),
    [sym_right_assignment] = STATE(808),
    [sym_brace_list] = STATE(808),
    [sym_paren_list] = STATE(808),
    [sym_subset] = STATE(808),
    [sym_subset2] = STATE(808),
    [sym_dollar] = STATE(808),
    [sym_slot] = STATE(808),
    [sym_namespace_get] = STATE(808),
    [sym_namespace_get_internal] = STATE(808),
    [sym_pipe] = STATE(808),
    [sym_unary] = STATE(808),
    [sym_binary] = STATE(808),
    [sym_na] = STATE(808),
    [sym__expression] = STATE(808),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(808),
    [sym_string] = STATE(808),
    [anon_sym_SEMI] = ACTIONS(945),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(965),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(965),
    [sym_next] = ACTIONS(965),
    [sym_true] = ACTIONS(965),
    [sym_false] = ACTIONS(965),
    [sym_null] = ACTIONS(965),
    [sym_inf] = ACTIONS(965),
    [sym_nan] = ACTIONS(965),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(945),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [138] = {
    [sym_function_definition] = STATE(925),
    [sym_lambda_function] = STATE(925),
    [sym_if] = STATE(925),
    [sym_while] = STATE(925),
    [sym_repeat] = STATE(925),
    [sym_for] = STATE(925),
    [sym_switch] = STATE(925),
    [sym_call] = STATE(863),
    [sym__assignment] = STATE(925),
    [sym_left_assignment] = STATE(925),
    [sym_left_assignment2] = STATE(925),
    [sym_equals_assignment] = STATE(925),
    [sym_super_assignment] = STATE(925),
    [sym_super_right_assignment] = STATE(925),
    [sym_right_assignment] = STATE(925),
    [sym_brace_list] = STATE(925),
    [sym_paren_list] = STATE(925),
    [sym_subset] = STATE(925),
    [sym_subset2] = STATE(925),
    [sym_dollar] = STATE(925),
    [sym_slot] = STATE(925),
    [sym_namespace_get] = STATE(925),
    [sym_namespace_get_internal] = STATE(925),
    [sym_pipe] = STATE(925),
    [sym_unary] = STATE(925),
    [sym_binary] = STATE(925),
    [sym_na] = STATE(925),
    [sym__expression] = STATE(925),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(925),
    [sym_string] = STATE(925),
    [anon_sym_SEMI] = ACTIONS(985),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(987),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(987),
    [sym_next] = ACTIONS(987),
    [sym_true] = ACTIONS(987),
    [sym_false] = ACTIONS(987),
    [sym_null] = ACTIONS(987),
    [sym_inf] = ACTIONS(987),
    [sym_nan] = ACTIONS(987),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(985),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [139] = {
    [sym_function_definition] = STATE(687),
    [sym_lambda_function] = STATE(687),
    [sym_if] = STATE(687),
    [sym_while] = STATE(687),
    [sym_repeat] = STATE(687),
    [sym_for] = STATE(687),
    [sym_switch] = STATE(687),
    [sym_call] = STATE(687),
    [sym__assignment] = STATE(687),
    [sym_left_assignment] = STATE(687),
    [sym_left_assignment2] = STATE(687),
    [sym_equals_assignment] = STATE(687),
    [sym_super_assignment] = STATE(687),
    [sym_super_right_assignment] = STATE(687),
    [sym_right_assignment] = STATE(687),
    [sym_brace_list] = STATE(687),
    [sym_paren_list] = STATE(687),
    [sym_subset] = STATE(687),
    [sym_subset2] = STATE(687),
    [sym_dollar] = STATE(687),
    [sym_slot] = STATE(687),
    [sym_namespace_get] = STATE(687),
    [sym_namespace_get_internal] = STATE(687),
    [sym_pipe] = STATE(687),
    [sym_unary] = STATE(687),
    [sym_binary] = STATE(687),
    [sym_na] = STATE(687),
    [sym__expression] = STATE(687),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(687),
    [sym_string] = STATE(687),
    [anon_sym_SEMI] = ACTIONS(989),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(991),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(991),
    [sym_next] = ACTIONS(991),
    [sym_true] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [sym_null] = ACTIONS(991),
    [sym_inf] = ACTIONS(991),
    [sym_nan] = ACTIONS(991),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(989),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [140] = {
    [sym_function_definition] = STATE(655),
    [sym_lambda_function] = STATE(655),
    [sym_if] = STATE(655),
    [sym_while] = STATE(655),
    [sym_repeat] = STATE(655),
    [sym_for] = STATE(655),
    [sym_switch] = STATE(655),
    [sym_call] = STATE(655),
    [sym__assignment] = STATE(655),
    [sym_left_assignment] = STATE(655),
    [sym_left_assignment2] = STATE(655),
    [sym_equals_assignment] = STATE(655),
    [sym_super_assignment] = STATE(655),
    [sym_super_right_assignment] = STATE(655),
    [sym_right_assignment] = STATE(655),
    [sym_brace_list] = STATE(655),
    [sym_paren_list] = STATE(655),
    [sym_subset] = STATE(655),
    [sym_subset2] = STATE(655),
    [sym_dollar] = STATE(655),
    [sym_slot] = STATE(655),
    [sym_namespace_get] = STATE(655),
    [sym_namespace_get_internal] = STATE(655),
    [sym_pipe] = STATE(655),
    [sym_unary] = STATE(655),
    [sym_binary] = STATE(655),
    [sym_na] = STATE(655),
    [sym__expression] = STATE(655),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(655),
    [sym_string] = STATE(655),
    [anon_sym_SEMI] = ACTIONS(993),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(995),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(995),
    [sym_next] = ACTIONS(995),
    [sym_true] = ACTIONS(995),
    [sym_false] = ACTIONS(995),
    [sym_null] = ACTIONS(995),
    [sym_inf] = ACTIONS(995),
    [sym_nan] = ACTIONS(995),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(993),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [141] = {
    [sym_function_definition] = STATE(900),
    [sym_lambda_function] = STATE(900),
    [sym_if] = STATE(900),
    [sym_while] = STATE(900),
    [sym_repeat] = STATE(900),
    [sym_for] = STATE(900),
    [sym_switch] = STATE(900),
    [sym_call] = STATE(900),
    [sym__assignment] = STATE(900),
    [sym_left_assignment] = STATE(900),
    [sym_left_assignment2] = STATE(900),
    [sym_equals_assignment] = STATE(900),
    [sym_super_assignment] = STATE(900),
    [sym_super_right_assignment] = STATE(900),
    [sym_right_assignment] = STATE(900),
    [sym_brace_list] = STATE(900),
    [sym_paren_list] = STATE(900),
    [sym_subset] = STATE(900),
    [sym_subset2] = STATE(900),
    [sym_dollar] = STATE(900),
    [sym_slot] = STATE(900),
    [sym_namespace_get] = STATE(900),
    [sym_namespace_get_internal] = STATE(900),
    [sym_pipe] = STATE(900),
    [sym_unary] = STATE(900),
    [sym_binary] = STATE(900),
    [sym_na] = STATE(900),
    [sym__expression] = STATE(900),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(900),
    [sym_string] = STATE(900),
    [anon_sym_SEMI] = ACTIONS(997),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(999),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(999),
    [sym_next] = ACTIONS(999),
    [sym_true] = ACTIONS(999),
    [sym_false] = ACTIONS(999),
    [sym_null] = ACTIONS(999),
    [sym_inf] = ACTIONS(999),
    [sym_nan] = ACTIONS(999),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(997),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [142] = {
    [sym_function_definition] = STATE(544),
    [sym_lambda_function] = STATE(544),
    [sym_if] = STATE(544),
    [sym_while] = STATE(544),
    [sym_repeat] = STATE(544),
    [sym_for] = STATE(544),
    [sym_switch] = STATE(544),
    [sym_call] = STATE(544),
    [sym__assignment] = STATE(544),
    [sym_left_assignment] = STATE(544),
    [sym_left_assignment2] = STATE(544),
    [sym_equals_assignment] = STATE(544),
    [sym_super_assignment] = STATE(544),
    [sym_super_right_assignment] = STATE(544),
    [sym_right_assignment] = STATE(544),
    [sym_brace_list] = STATE(544),
    [sym_paren_list] = STATE(544),
    [sym_subset] = STATE(544),
    [sym_subset2] = STATE(544),
    [sym_dollar] = STATE(544),
    [sym_slot] = STATE(544),
    [sym_namespace_get] = STATE(544),
    [sym_namespace_get_internal] = STATE(544),
    [sym_pipe] = STATE(544),
    [sym_unary] = STATE(544),
    [sym_binary] = STATE(544),
    [sym_na] = STATE(544),
    [sym__expression] = STATE(544),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(544),
    [sym_string] = STATE(544),
    [anon_sym_SEMI] = ACTIONS(1001),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1021),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1021),
    [sym_next] = ACTIONS(1021),
    [sym_true] = ACTIONS(1021),
    [sym_false] = ACTIONS(1021),
    [sym_null] = ACTIONS(1021),
    [sym_inf] = ACTIONS(1021),
    [sym_nan] = ACTIONS(1021),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1001),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [143] = {
    [sym_function_definition] = STATE(920),
    [sym_lambda_function] = STATE(920),
    [sym_if] = STATE(920),
    [sym_while] = STATE(920),
    [sym_repeat] = STATE(920),
    [sym_for] = STATE(920),
    [sym_switch] = STATE(920),
    [sym_call] = STATE(631),
    [sym__assignment] = STATE(920),
    [sym_left_assignment] = STATE(920),
    [sym_left_assignment2] = STATE(920),
    [sym_equals_assignment] = STATE(920),
    [sym_super_assignment] = STATE(920),
    [sym_super_right_assignment] = STATE(920),
    [sym_right_assignment] = STATE(920),
    [sym_brace_list] = STATE(920),
    [sym_paren_list] = STATE(920),
    [sym_subset] = STATE(920),
    [sym_subset2] = STATE(920),
    [sym_dollar] = STATE(920),
    [sym_slot] = STATE(920),
    [sym_namespace_get] = STATE(920),
    [sym_namespace_get_internal] = STATE(920),
    [sym_pipe] = STATE(920),
    [sym_unary] = STATE(920),
    [sym_binary] = STATE(920),
    [sym_na] = STATE(920),
    [sym__expression] = STATE(920),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(920),
    [sym_string] = STATE(920),
    [anon_sym_SEMI] = ACTIONS(1041),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1043),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1043),
    [sym_next] = ACTIONS(1043),
    [sym_true] = ACTIONS(1043),
    [sym_false] = ACTIONS(1043),
    [sym_null] = ACTIONS(1043),
    [sym_inf] = ACTIONS(1043),
    [sym_nan] = ACTIONS(1043),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1041),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [144] = {
    [sym_function_definition] = STATE(909),
    [sym_lambda_function] = STATE(909),
    [sym_if] = STATE(909),
    [sym_while] = STATE(909),
    [sym_repeat] = STATE(909),
    [sym_for] = STATE(909),
    [sym_switch] = STATE(909),
    [sym_call] = STATE(909),
    [sym__assignment] = STATE(909),
    [sym_left_assignment] = STATE(909),
    [sym_left_assignment2] = STATE(909),
    [sym_equals_assignment] = STATE(909),
    [sym_super_assignment] = STATE(909),
    [sym_super_right_assignment] = STATE(909),
    [sym_right_assignment] = STATE(909),
    [sym_brace_list] = STATE(909),
    [sym_paren_list] = STATE(909),
    [sym_subset] = STATE(909),
    [sym_subset2] = STATE(909),
    [sym_dollar] = STATE(909),
    [sym_slot] = STATE(909),
    [sym_namespace_get] = STATE(909),
    [sym_namespace_get_internal] = STATE(909),
    [sym_pipe] = STATE(909),
    [sym_unary] = STATE(909),
    [sym_binary] = STATE(909),
    [sym_na] = STATE(909),
    [sym__expression] = STATE(909),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(909),
    [sym_string] = STATE(909),
    [anon_sym_SEMI] = ACTIONS(1045),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1047),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1047),
    [sym_next] = ACTIONS(1047),
    [sym_true] = ACTIONS(1047),
    [sym_false] = ACTIONS(1047),
    [sym_null] = ACTIONS(1047),
    [sym_inf] = ACTIONS(1047),
    [sym_nan] = ACTIONS(1047),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1045),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [145] = {
    [sym_function_definition] = STATE(919),
    [sym_lambda_function] = STATE(919),
    [sym_if] = STATE(919),
    [sym_while] = STATE(919),
    [sym_repeat] = STATE(919),
    [sym_for] = STATE(919),
    [sym_switch] = STATE(919),
    [sym_call] = STATE(919),
    [sym__assignment] = STATE(919),
    [sym_left_assignment] = STATE(919),
    [sym_left_assignment2] = STATE(919),
    [sym_equals_assignment] = STATE(919),
    [sym_super_assignment] = STATE(919),
    [sym_super_right_assignment] = STATE(919),
    [sym_right_assignment] = STATE(919),
    [sym_brace_list] = STATE(919),
    [sym_paren_list] = STATE(919),
    [sym_subset] = STATE(919),
    [sym_subset2] = STATE(919),
    [sym_dollar] = STATE(919),
    [sym_slot] = STATE(919),
    [sym_namespace_get] = STATE(919),
    [sym_namespace_get_internal] = STATE(919),
    [sym_pipe] = STATE(919),
    [sym_unary] = STATE(919),
    [sym_binary] = STATE(919),
    [sym_na] = STATE(919),
    [sym__expression] = STATE(919),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(919),
    [sym_string] = STATE(919),
    [anon_sym_SEMI] = ACTIONS(1049),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1051),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1051),
    [sym_next] = ACTIONS(1051),
    [sym_true] = ACTIONS(1051),
    [sym_false] = ACTIONS(1051),
    [sym_null] = ACTIONS(1051),
    [sym_inf] = ACTIONS(1051),
    [sym_nan] = ACTIONS(1051),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1049),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [146] = {
    [sym_function_definition] = STATE(260),
    [sym_lambda_function] = STATE(260),
    [sym_if] = STATE(260),
    [sym_while] = STATE(260),
    [sym_repeat] = STATE(260),
    [sym_for] = STATE(260),
    [sym_switch] = STATE(260),
    [sym_call] = STATE(260),
    [sym__assignment] = STATE(260),
    [sym_left_assignment] = STATE(260),
    [sym_left_assignment2] = STATE(260),
    [sym_equals_assignment] = STATE(260),
    [sym_super_assignment] = STATE(260),
    [sym_super_right_assignment] = STATE(260),
    [sym_right_assignment] = STATE(260),
    [sym_brace_list] = STATE(260),
    [sym_paren_list] = STATE(260),
    [sym_subset] = STATE(260),
    [sym_subset2] = STATE(260),
    [sym_dollar] = STATE(260),
    [sym_slot] = STATE(260),
    [sym_namespace_get] = STATE(260),
    [sym_namespace_get_internal] = STATE(260),
    [sym_pipe] = STATE(260),
    [sym_unary] = STATE(260),
    [sym_binary] = STATE(260),
    [sym_na] = STATE(260),
    [sym__expression] = STATE(260),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(260),
    [sym_string] = STATE(260),
    [anon_sym_SEMI] = ACTIONS(1053),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1073),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1073),
    [sym_next] = ACTIONS(1073),
    [sym_true] = ACTIONS(1073),
    [sym_false] = ACTIONS(1073),
    [sym_null] = ACTIONS(1073),
    [sym_inf] = ACTIONS(1073),
    [sym_nan] = ACTIONS(1073),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1053),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [147] = {
    [sym_function_definition] = STATE(921),
    [sym_lambda_function] = STATE(921),
    [sym_if] = STATE(921),
    [sym_while] = STATE(921),
    [sym_repeat] = STATE(921),
    [sym_for] = STATE(921),
    [sym_switch] = STATE(921),
    [sym_call] = STATE(456),
    [sym__assignment] = STATE(921),
    [sym_left_assignment] = STATE(921),
    [sym_left_assignment2] = STATE(921),
    [sym_equals_assignment] = STATE(921),
    [sym_super_assignment] = STATE(921),
    [sym_super_right_assignment] = STATE(921),
    [sym_right_assignment] = STATE(921),
    [sym_brace_list] = STATE(921),
    [sym_paren_list] = STATE(921),
    [sym_subset] = STATE(921),
    [sym_subset2] = STATE(921),
    [sym_dollar] = STATE(921),
    [sym_slot] = STATE(921),
    [sym_namespace_get] = STATE(921),
    [sym_namespace_get_internal] = STATE(921),
    [sym_pipe] = STATE(921),
    [sym_unary] = STATE(921),
    [sym_binary] = STATE(921),
    [sym_na] = STATE(921),
    [sym__expression] = STATE(921),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(921),
    [sym_string] = STATE(921),
    [anon_sym_SEMI] = ACTIONS(1093),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1095),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1095),
    [sym_next] = ACTIONS(1095),
    [sym_true] = ACTIONS(1095),
    [sym_false] = ACTIONS(1095),
    [sym_null] = ACTIONS(1095),
    [sym_inf] = ACTIONS(1095),
    [sym_nan] = ACTIONS(1095),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1093),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [148] = {
    [sym_function_definition] = STATE(464),
    [sym_lambda_function] = STATE(464),
    [sym_if] = STATE(464),
    [sym_while] = STATE(464),
    [sym_repeat] = STATE(464),
    [sym_for] = STATE(464),
    [sym_switch] = STATE(464),
    [sym_call] = STATE(464),
    [sym__assignment] = STATE(464),
    [sym_left_assignment] = STATE(464),
    [sym_left_assignment2] = STATE(464),
    [sym_equals_assignment] = STATE(464),
    [sym_super_assignment] = STATE(464),
    [sym_super_right_assignment] = STATE(464),
    [sym_right_assignment] = STATE(464),
    [sym_brace_list] = STATE(464),
    [sym_paren_list] = STATE(464),
    [sym_subset] = STATE(464),
    [sym_subset2] = STATE(464),
    [sym_dollar] = STATE(464),
    [sym_slot] = STATE(464),
    [sym_namespace_get] = STATE(464),
    [sym_namespace_get_internal] = STATE(464),
    [sym_pipe] = STATE(464),
    [sym_unary] = STATE(464),
    [sym_binary] = STATE(464),
    [sym_na] = STATE(464),
    [sym__expression] = STATE(464),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(464),
    [sym_string] = STATE(464),
    [anon_sym_SEMI] = ACTIONS(1097),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1099),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1099),
    [sym_next] = ACTIONS(1099),
    [sym_true] = ACTIONS(1099),
    [sym_false] = ACTIONS(1099),
    [sym_null] = ACTIONS(1099),
    [sym_inf] = ACTIONS(1099),
    [sym_nan] = ACTIONS(1099),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1097),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [149] = {
    [sym_function_definition] = STATE(465),
    [sym_lambda_function] = STATE(465),
    [sym_if] = STATE(465),
    [sym_while] = STATE(465),
    [sym_repeat] = STATE(465),
    [sym_for] = STATE(465),
    [sym_switch] = STATE(465),
    [sym_call] = STATE(465),
    [sym__assignment] = STATE(465),
    [sym_left_assignment] = STATE(465),
    [sym_left_assignment2] = STATE(465),
    [sym_equals_assignment] = STATE(465),
    [sym_super_assignment] = STATE(465),
    [sym_super_right_assignment] = STATE(465),
    [sym_right_assignment] = STATE(465),
    [sym_brace_list] = STATE(465),
    [sym_paren_list] = STATE(465),
    [sym_subset] = STATE(465),
    [sym_subset2] = STATE(465),
    [sym_dollar] = STATE(465),
    [sym_slot] = STATE(465),
    [sym_namespace_get] = STATE(465),
    [sym_namespace_get_internal] = STATE(465),
    [sym_pipe] = STATE(465),
    [sym_unary] = STATE(465),
    [sym_binary] = STATE(465),
    [sym_na] = STATE(465),
    [sym__expression] = STATE(465),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(465),
    [sym_string] = STATE(465),
    [anon_sym_SEMI] = ACTIONS(1101),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1103),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1103),
    [sym_next] = ACTIONS(1103),
    [sym_true] = ACTIONS(1103),
    [sym_false] = ACTIONS(1103),
    [sym_null] = ACTIONS(1103),
    [sym_inf] = ACTIONS(1103),
    [sym_nan] = ACTIONS(1103),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1101),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [150] = {
    [sym_function_definition] = STATE(468),
    [sym_lambda_function] = STATE(468),
    [sym_if] = STATE(468),
    [sym_while] = STATE(468),
    [sym_repeat] = STATE(468),
    [sym_for] = STATE(468),
    [sym_switch] = STATE(468),
    [sym_call] = STATE(468),
    [sym__assignment] = STATE(468),
    [sym_left_assignment] = STATE(468),
    [sym_left_assignment2] = STATE(468),
    [sym_equals_assignment] = STATE(468),
    [sym_super_assignment] = STATE(468),
    [sym_super_right_assignment] = STATE(468),
    [sym_right_assignment] = STATE(468),
    [sym_brace_list] = STATE(468),
    [sym_paren_list] = STATE(468),
    [sym_subset] = STATE(468),
    [sym_subset2] = STATE(468),
    [sym_dollar] = STATE(468),
    [sym_slot] = STATE(468),
    [sym_namespace_get] = STATE(468),
    [sym_namespace_get_internal] = STATE(468),
    [sym_pipe] = STATE(468),
    [sym_unary] = STATE(468),
    [sym_binary] = STATE(468),
    [sym_na] = STATE(468),
    [sym__expression] = STATE(468),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(468),
    [sym_string] = STATE(468),
    [anon_sym_SEMI] = ACTIONS(1105),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1107),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1107),
    [sym_next] = ACTIONS(1107),
    [sym_true] = ACTIONS(1107),
    [sym_false] = ACTIONS(1107),
    [sym_null] = ACTIONS(1107),
    [sym_inf] = ACTIONS(1107),
    [sym_nan] = ACTIONS(1107),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1105),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [151] = {
    [sym_function_definition] = STATE(576),
    [sym_lambda_function] = STATE(576),
    [sym_if] = STATE(576),
    [sym_while] = STATE(576),
    [sym_repeat] = STATE(576),
    [sym_for] = STATE(576),
    [sym_switch] = STATE(576),
    [sym_call] = STATE(576),
    [sym__assignment] = STATE(576),
    [sym_left_assignment] = STATE(576),
    [sym_left_assignment2] = STATE(576),
    [sym_equals_assignment] = STATE(576),
    [sym_super_assignment] = STATE(576),
    [sym_super_right_assignment] = STATE(576),
    [sym_right_assignment] = STATE(576),
    [sym_brace_list] = STATE(576),
    [sym_paren_list] = STATE(576),
    [sym_subset] = STATE(576),
    [sym_subset2] = STATE(576),
    [sym_dollar] = STATE(576),
    [sym_slot] = STATE(576),
    [sym_namespace_get] = STATE(576),
    [sym_namespace_get_internal] = STATE(576),
    [sym_pipe] = STATE(576),
    [sym_unary] = STATE(576),
    [sym_binary] = STATE(576),
    [sym_na] = STATE(576),
    [sym__expression] = STATE(576),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(576),
    [sym_string] = STATE(576),
    [anon_sym_SEMI] = ACTIONS(1109),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1111),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1111),
    [sym_next] = ACTIONS(1111),
    [sym_true] = ACTIONS(1111),
    [sym_false] = ACTIONS(1111),
    [sym_null] = ACTIONS(1111),
    [sym_inf] = ACTIONS(1111),
    [sym_nan] = ACTIONS(1111),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1109),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [152] = {
    [sym_function_definition] = STATE(577),
    [sym_lambda_function] = STATE(577),
    [sym_if] = STATE(577),
    [sym_while] = STATE(577),
    [sym_repeat] = STATE(577),
    [sym_for] = STATE(577),
    [sym_switch] = STATE(577),
    [sym_call] = STATE(577),
    [sym__assignment] = STATE(577),
    [sym_left_assignment] = STATE(577),
    [sym_left_assignment2] = STATE(577),
    [sym_equals_assignment] = STATE(577),
    [sym_super_assignment] = STATE(577),
    [sym_super_right_assignment] = STATE(577),
    [sym_right_assignment] = STATE(577),
    [sym_brace_list] = STATE(577),
    [sym_paren_list] = STATE(577),
    [sym_subset] = STATE(577),
    [sym_subset2] = STATE(577),
    [sym_dollar] = STATE(577),
    [sym_slot] = STATE(577),
    [sym_namespace_get] = STATE(577),
    [sym_namespace_get_internal] = STATE(577),
    [sym_pipe] = STATE(577),
    [sym_unary] = STATE(577),
    [sym_binary] = STATE(577),
    [sym_na] = STATE(577),
    [sym__expression] = STATE(577),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(577),
    [sym_string] = STATE(577),
    [anon_sym_SEMI] = ACTIONS(1113),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1115),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1115),
    [sym_next] = ACTIONS(1115),
    [sym_true] = ACTIONS(1115),
    [sym_false] = ACTIONS(1115),
    [sym_null] = ACTIONS(1115),
    [sym_inf] = ACTIONS(1115),
    [sym_nan] = ACTIONS(1115),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1113),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [153] = {
    [sym_function_definition] = STATE(473),
    [sym_lambda_function] = STATE(473),
    [sym_if] = STATE(473),
    [sym_while] = STATE(473),
    [sym_repeat] = STATE(473),
    [sym_for] = STATE(473),
    [sym_switch] = STATE(473),
    [sym_call] = STATE(473),
    [sym__assignment] = STATE(473),
    [sym_left_assignment] = STATE(473),
    [sym_left_assignment2] = STATE(473),
    [sym_equals_assignment] = STATE(473),
    [sym_super_assignment] = STATE(473),
    [sym_super_right_assignment] = STATE(473),
    [sym_right_assignment] = STATE(473),
    [sym_brace_list] = STATE(473),
    [sym_paren_list] = STATE(473),
    [sym_subset] = STATE(473),
    [sym_subset2] = STATE(473),
    [sym_dollar] = STATE(473),
    [sym_slot] = STATE(473),
    [sym_namespace_get] = STATE(473),
    [sym_namespace_get_internal] = STATE(473),
    [sym_pipe] = STATE(473),
    [sym_unary] = STATE(473),
    [sym_binary] = STATE(473),
    [sym_na] = STATE(473),
    [sym__expression] = STATE(473),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(473),
    [sym_string] = STATE(473),
    [anon_sym_SEMI] = ACTIONS(1117),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1119),
    [sym_next] = ACTIONS(1119),
    [sym_true] = ACTIONS(1119),
    [sym_false] = ACTIONS(1119),
    [sym_null] = ACTIONS(1119),
    [sym_inf] = ACTIONS(1119),
    [sym_nan] = ACTIONS(1119),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1117),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [154] = {
    [sym_function_definition] = STATE(472),
    [sym_lambda_function] = STATE(472),
    [sym_if] = STATE(472),
    [sym_while] = STATE(472),
    [sym_repeat] = STATE(472),
    [sym_for] = STATE(472),
    [sym_switch] = STATE(472),
    [sym_call] = STATE(472),
    [sym__assignment] = STATE(472),
    [sym_left_assignment] = STATE(472),
    [sym_left_assignment2] = STATE(472),
    [sym_equals_assignment] = STATE(472),
    [sym_super_assignment] = STATE(472),
    [sym_super_right_assignment] = STATE(472),
    [sym_right_assignment] = STATE(472),
    [sym_brace_list] = STATE(472),
    [sym_paren_list] = STATE(472),
    [sym_subset] = STATE(472),
    [sym_subset2] = STATE(472),
    [sym_dollar] = STATE(472),
    [sym_slot] = STATE(472),
    [sym_namespace_get] = STATE(472),
    [sym_namespace_get_internal] = STATE(472),
    [sym_pipe] = STATE(472),
    [sym_unary] = STATE(472),
    [sym_binary] = STATE(472),
    [sym_na] = STATE(472),
    [sym__expression] = STATE(472),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(472),
    [sym_string] = STATE(472),
    [anon_sym_SEMI] = ACTIONS(1121),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1123),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1123),
    [sym_next] = ACTIONS(1123),
    [sym_true] = ACTIONS(1123),
    [sym_false] = ACTIONS(1123),
    [sym_null] = ACTIONS(1123),
    [sym_inf] = ACTIONS(1123),
    [sym_nan] = ACTIONS(1123),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1121),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [155] = {
    [sym_function_definition] = STATE(923),
    [sym_lambda_function] = STATE(923),
    [sym_if] = STATE(923),
    [sym_while] = STATE(923),
    [sym_repeat] = STATE(923),
    [sym_for] = STATE(923),
    [sym_switch] = STATE(923),
    [sym_call] = STATE(625),
    [sym__assignment] = STATE(923),
    [sym_left_assignment] = STATE(923),
    [sym_left_assignment2] = STATE(923),
    [sym_equals_assignment] = STATE(923),
    [sym_super_assignment] = STATE(923),
    [sym_super_right_assignment] = STATE(923),
    [sym_right_assignment] = STATE(923),
    [sym_brace_list] = STATE(923),
    [sym_paren_list] = STATE(923),
    [sym_subset] = STATE(923),
    [sym_subset2] = STATE(923),
    [sym_dollar] = STATE(923),
    [sym_slot] = STATE(923),
    [sym_namespace_get] = STATE(923),
    [sym_namespace_get_internal] = STATE(923),
    [sym_pipe] = STATE(923),
    [sym_unary] = STATE(923),
    [sym_binary] = STATE(923),
    [sym_na] = STATE(923),
    [sym__expression] = STATE(923),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(923),
    [sym_string] = STATE(923),
    [anon_sym_SEMI] = ACTIONS(1125),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1127),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1127),
    [sym_next] = ACTIONS(1127),
    [sym_true] = ACTIONS(1127),
    [sym_false] = ACTIONS(1127),
    [sym_null] = ACTIONS(1127),
    [sym_inf] = ACTIONS(1127),
    [sym_nan] = ACTIONS(1127),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1125),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [156] = {
    [sym_function_definition] = STATE(563),
    [sym_lambda_function] = STATE(563),
    [sym_if] = STATE(563),
    [sym_while] = STATE(563),
    [sym_repeat] = STATE(563),
    [sym_for] = STATE(563),
    [sym_switch] = STATE(563),
    [sym_call] = STATE(563),
    [sym__assignment] = STATE(563),
    [sym_left_assignment] = STATE(563),
    [sym_left_assignment2] = STATE(563),
    [sym_equals_assignment] = STATE(563),
    [sym_super_assignment] = STATE(563),
    [sym_super_right_assignment] = STATE(563),
    [sym_right_assignment] = STATE(563),
    [sym_brace_list] = STATE(563),
    [sym_paren_list] = STATE(563),
    [sym_subset] = STATE(563),
    [sym_subset2] = STATE(563),
    [sym_dollar] = STATE(563),
    [sym_slot] = STATE(563),
    [sym_namespace_get] = STATE(563),
    [sym_namespace_get_internal] = STATE(563),
    [sym_pipe] = STATE(563),
    [sym_unary] = STATE(563),
    [sym_binary] = STATE(563),
    [sym_na] = STATE(563),
    [sym__expression] = STATE(563),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(563),
    [sym_string] = STATE(563),
    [anon_sym_SEMI] = ACTIONS(1129),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1131),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1131),
    [sym_next] = ACTIONS(1131),
    [sym_true] = ACTIONS(1131),
    [sym_false] = ACTIONS(1131),
    [sym_null] = ACTIONS(1131),
    [sym_inf] = ACTIONS(1131),
    [sym_nan] = ACTIONS(1131),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1129),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [157] = {
    [sym_function_definition] = STATE(564),
    [sym_lambda_function] = STATE(564),
    [sym_if] = STATE(564),
    [sym_while] = STATE(564),
    [sym_repeat] = STATE(564),
    [sym_for] = STATE(564),
    [sym_switch] = STATE(564),
    [sym_call] = STATE(564),
    [sym__assignment] = STATE(564),
    [sym_left_assignment] = STATE(564),
    [sym_left_assignment2] = STATE(564),
    [sym_equals_assignment] = STATE(564),
    [sym_super_assignment] = STATE(564),
    [sym_super_right_assignment] = STATE(564),
    [sym_right_assignment] = STATE(564),
    [sym_brace_list] = STATE(564),
    [sym_paren_list] = STATE(564),
    [sym_subset] = STATE(564),
    [sym_subset2] = STATE(564),
    [sym_dollar] = STATE(564),
    [sym_slot] = STATE(564),
    [sym_namespace_get] = STATE(564),
    [sym_namespace_get_internal] = STATE(564),
    [sym_pipe] = STATE(564),
    [sym_unary] = STATE(564),
    [sym_binary] = STATE(564),
    [sym_na] = STATE(564),
    [sym__expression] = STATE(564),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(564),
    [sym_string] = STATE(564),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1135),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1135),
    [sym_next] = ACTIONS(1135),
    [sym_true] = ACTIONS(1135),
    [sym_false] = ACTIONS(1135),
    [sym_null] = ACTIONS(1135),
    [sym_inf] = ACTIONS(1135),
    [sym_nan] = ACTIONS(1135),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1133),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [158] = {
    [sym_function_definition] = STATE(565),
    [sym_lambda_function] = STATE(565),
    [sym_if] = STATE(565),
    [sym_while] = STATE(565),
    [sym_repeat] = STATE(565),
    [sym_for] = STATE(565),
    [sym_switch] = STATE(565),
    [sym_call] = STATE(565),
    [sym__assignment] = STATE(565),
    [sym_left_assignment] = STATE(565),
    [sym_left_assignment2] = STATE(565),
    [sym_equals_assignment] = STATE(565),
    [sym_super_assignment] = STATE(565),
    [sym_super_right_assignment] = STATE(565),
    [sym_right_assignment] = STATE(565),
    [sym_brace_list] = STATE(565),
    [sym_paren_list] = STATE(565),
    [sym_subset] = STATE(565),
    [sym_subset2] = STATE(565),
    [sym_dollar] = STATE(565),
    [sym_slot] = STATE(565),
    [sym_namespace_get] = STATE(565),
    [sym_namespace_get_internal] = STATE(565),
    [sym_pipe] = STATE(565),
    [sym_unary] = STATE(565),
    [sym_binary] = STATE(565),
    [sym_na] = STATE(565),
    [sym__expression] = STATE(565),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(565),
    [sym_string] = STATE(565),
    [anon_sym_SEMI] = ACTIONS(1137),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1139),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1139),
    [sym_next] = ACTIONS(1139),
    [sym_true] = ACTIONS(1139),
    [sym_false] = ACTIONS(1139),
    [sym_null] = ACTIONS(1139),
    [sym_inf] = ACTIONS(1139),
    [sym_nan] = ACTIONS(1139),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1137),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [159] = {
    [sym_function_definition] = STATE(566),
    [sym_lambda_function] = STATE(566),
    [sym_if] = STATE(566),
    [sym_while] = STATE(566),
    [sym_repeat] = STATE(566),
    [sym_for] = STATE(566),
    [sym_switch] = STATE(566),
    [sym_call] = STATE(566),
    [sym__assignment] = STATE(566),
    [sym_left_assignment] = STATE(566),
    [sym_left_assignment2] = STATE(566),
    [sym_equals_assignment] = STATE(566),
    [sym_super_assignment] = STATE(566),
    [sym_super_right_assignment] = STATE(566),
    [sym_right_assignment] = STATE(566),
    [sym_brace_list] = STATE(566),
    [sym_paren_list] = STATE(566),
    [sym_subset] = STATE(566),
    [sym_subset2] = STATE(566),
    [sym_dollar] = STATE(566),
    [sym_slot] = STATE(566),
    [sym_namespace_get] = STATE(566),
    [sym_namespace_get_internal] = STATE(566),
    [sym_pipe] = STATE(566),
    [sym_unary] = STATE(566),
    [sym_binary] = STATE(566),
    [sym_na] = STATE(566),
    [sym__expression] = STATE(566),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(566),
    [sym_string] = STATE(566),
    [anon_sym_SEMI] = ACTIONS(1141),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1143),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1143),
    [sym_next] = ACTIONS(1143),
    [sym_true] = ACTIONS(1143),
    [sym_false] = ACTIONS(1143),
    [sym_null] = ACTIONS(1143),
    [sym_inf] = ACTIONS(1143),
    [sym_nan] = ACTIONS(1143),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1141),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [160] = {
    [sym_function_definition] = STATE(731),
    [sym_lambda_function] = STATE(731),
    [sym_if] = STATE(731),
    [sym_while] = STATE(731),
    [sym_repeat] = STATE(731),
    [sym_for] = STATE(731),
    [sym_switch] = STATE(731),
    [sym_call] = STATE(731),
    [sym__assignment] = STATE(731),
    [sym_left_assignment] = STATE(731),
    [sym_left_assignment2] = STATE(731),
    [sym_equals_assignment] = STATE(731),
    [sym_super_assignment] = STATE(731),
    [sym_super_right_assignment] = STATE(731),
    [sym_right_assignment] = STATE(731),
    [sym_brace_list] = STATE(731),
    [sym_paren_list] = STATE(731),
    [sym_subset] = STATE(731),
    [sym_subset2] = STATE(731),
    [sym_dollar] = STATE(731),
    [sym_slot] = STATE(731),
    [sym_namespace_get] = STATE(731),
    [sym_namespace_get_internal] = STATE(731),
    [sym_pipe] = STATE(731),
    [sym_unary] = STATE(731),
    [sym_binary] = STATE(731),
    [sym_na] = STATE(731),
    [sym__expression] = STATE(731),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(731),
    [sym_string] = STATE(731),
    [anon_sym_SEMI] = ACTIONS(1145),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1147),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1147),
    [sym_next] = ACTIONS(1147),
    [sym_true] = ACTIONS(1147),
    [sym_false] = ACTIONS(1147),
    [sym_null] = ACTIONS(1147),
    [sym_inf] = ACTIONS(1147),
    [sym_nan] = ACTIONS(1147),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1145),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [161] = {
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_function] = ACTIONS(645),
    [anon_sym_BSLASH] = ACTIONS(643),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_RPAREN] = ACTIONS(643),
    [anon_sym_while] = ACTIONS(645),
    [anon_sym_repeat] = ACTIONS(645),
    [anon_sym_for] = ACTIONS(645),
    [anon_sym_switch] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_LT_DASH] = ACTIONS(643),
    [anon_sym_COLON_EQ] = ACTIONS(643),
    [anon_sym_LT_LT_DASH] = ACTIONS(643),
    [anon_sym_DASH_GT_GT] = ACTIONS(643),
    [anon_sym_DASH_GT] = ACTIONS(645),
    [anon_sym_LBRACK] = ACTIONS(645),
    [anon_sym_RBRACK] = ACTIONS(643),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(645),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(643),
    [sym_dots] = ACTIONS(645),
    [anon_sym_PIPE_GT] = ACTIONS(643),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(643),
    [anon_sym_BANG] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(643),
    [anon_sym_STAR] = ACTIONS(643),
    [anon_sym_SLASH] = ACTIONS(643),
    [anon_sym_CARET] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_PIPE_PIPE] = ACTIONS(643),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(643),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_COLON] = ACTIONS(645),
    [sym_break] = ACTIONS(645),
    [sym_next] = ACTIONS(645),
    [sym_true] = ACTIONS(645),
    [sym_false] = ACTIONS(645),
    [sym_null] = ACTIONS(645),
    [sym_inf] = ACTIONS(645),
    [sym_nan] = ACTIONS(645),
    [anon_sym_NA] = ACTIONS(645),
    [anon_sym_NA_character_] = ACTIONS(645),
    [anon_sym_NA_complex_] = ACTIONS(645),
    [anon_sym_NA_integer_] = ACTIONS(645),
    [anon_sym_NA_real_] = ACTIONS(645),
    [aux_sym_identifier_token1] = ACTIONS(645),
    [anon_sym_BQUOTE] = ACTIONS(643),
    [sym_integer] = ACTIONS(643),
    [sym_float] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(643),
    [anon_sym_SQUOTE] = ACTIONS(643),
    [anon_sym_PERCENT] = ACTIONS(643),
  },
  [162] = {
    [sym_function_definition] = STATE(694),
    [sym_lambda_function] = STATE(694),
    [sym_if] = STATE(694),
    [sym_while] = STATE(694),
    [sym_repeat] = STATE(694),
    [sym_for] = STATE(694),
    [sym_switch] = STATE(694),
    [sym_call] = STATE(694),
    [sym__assignment] = STATE(694),
    [sym_left_assignment] = STATE(694),
    [sym_left_assignment2] = STATE(694),
    [sym_equals_assignment] = STATE(694),
    [sym_super_assignment] = STATE(694),
    [sym_super_right_assignment] = STATE(694),
    [sym_right_assignment] = STATE(694),
    [sym_brace_list] = STATE(694),
    [sym_paren_list] = STATE(694),
    [sym_subset] = STATE(694),
    [sym_subset2] = STATE(694),
    [sym_dollar] = STATE(694),
    [sym_slot] = STATE(694),
    [sym_namespace_get] = STATE(694),
    [sym_namespace_get_internal] = STATE(694),
    [sym_pipe] = STATE(694),
    [sym_unary] = STATE(694),
    [sym_binary] = STATE(694),
    [sym_na] = STATE(694),
    [sym__expression] = STATE(694),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(694),
    [sym_string] = STATE(694),
    [anon_sym_SEMI] = ACTIONS(1149),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1151),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1151),
    [sym_next] = ACTIONS(1151),
    [sym_true] = ACTIONS(1151),
    [sym_false] = ACTIONS(1151),
    [sym_null] = ACTIONS(1151),
    [sym_inf] = ACTIONS(1151),
    [sym_nan] = ACTIONS(1151),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1149),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [163] = {
    [sym_function_definition] = STATE(685),
    [sym_lambda_function] = STATE(685),
    [sym_if] = STATE(685),
    [sym_while] = STATE(685),
    [sym_repeat] = STATE(685),
    [sym_for] = STATE(685),
    [sym_switch] = STATE(685),
    [sym_call] = STATE(685),
    [sym__assignment] = STATE(685),
    [sym_left_assignment] = STATE(685),
    [sym_left_assignment2] = STATE(685),
    [sym_equals_assignment] = STATE(685),
    [sym_super_assignment] = STATE(685),
    [sym_super_right_assignment] = STATE(685),
    [sym_right_assignment] = STATE(685),
    [sym_brace_list] = STATE(685),
    [sym_paren_list] = STATE(685),
    [sym_subset] = STATE(685),
    [sym_subset2] = STATE(685),
    [sym_dollar] = STATE(685),
    [sym_slot] = STATE(685),
    [sym_namespace_get] = STATE(685),
    [sym_namespace_get_internal] = STATE(685),
    [sym_pipe] = STATE(685),
    [sym_unary] = STATE(685),
    [sym_binary] = STATE(685),
    [sym_na] = STATE(685),
    [sym__expression] = STATE(685),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(685),
    [sym_string] = STATE(685),
    [anon_sym_SEMI] = ACTIONS(1153),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1155),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1155),
    [sym_next] = ACTIONS(1155),
    [sym_true] = ACTIONS(1155),
    [sym_false] = ACTIONS(1155),
    [sym_null] = ACTIONS(1155),
    [sym_inf] = ACTIONS(1155),
    [sym_nan] = ACTIONS(1155),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1153),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [164] = {
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(635),
    [anon_sym_RPAREN] = ACTIONS(635),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_switch] = ACTIONS(637),
    [anon_sym_COMMA] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(635),
    [anon_sym_LT_DASH] = ACTIONS(635),
    [anon_sym_COLON_EQ] = ACTIONS(635),
    [anon_sym_LT_LT_DASH] = ACTIONS(635),
    [anon_sym_DASH_GT_GT] = ACTIONS(635),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_RBRACK] = ACTIONS(635),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(635),
    [anon_sym_DOLLAR] = ACTIONS(635),
    [anon_sym_AT] = ACTIONS(635),
    [anon_sym_COLON_COLON] = ACTIONS(745),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(747),
    [sym_dots] = ACTIONS(637),
    [anon_sym_PIPE_GT] = ACTIONS(635),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_BANG] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_SLASH] = ACTIONS(635),
    [anon_sym_CARET] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_LT_EQ] = ACTIONS(635),
    [anon_sym_GT_EQ] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_BANG_EQ] = ACTIONS(635),
    [anon_sym_PIPE_PIPE] = ACTIONS(635),
    [anon_sym_PIPE] = ACTIONS(637),
    [anon_sym_AMP_AMP] = ACTIONS(635),
    [anon_sym_AMP] = ACTIONS(637),
    [anon_sym_COLON] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(637),
    [anon_sym_NA_character_] = ACTIONS(637),
    [anon_sym_NA_complex_] = ACTIONS(637),
    [anon_sym_NA_integer_] = ACTIONS(637),
    [anon_sym_NA_real_] = ACTIONS(637),
    [aux_sym_identifier_token1] = ACTIONS(637),
    [anon_sym_BQUOTE] = ACTIONS(635),
    [sym_integer] = ACTIONS(635),
    [sym_float] = ACTIONS(637),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(635),
    [anon_sym_SQUOTE] = ACTIONS(635),
    [anon_sym_PERCENT] = ACTIONS(635),
  },
  [165] = {
    [sym_function_definition] = STATE(567),
    [sym_lambda_function] = STATE(567),
    [sym_if] = STATE(567),
    [sym_while] = STATE(567),
    [sym_repeat] = STATE(567),
    [sym_for] = STATE(567),
    [sym_switch] = STATE(567),
    [sym_call] = STATE(567),
    [sym__assignment] = STATE(567),
    [sym_left_assignment] = STATE(567),
    [sym_left_assignment2] = STATE(567),
    [sym_equals_assignment] = STATE(567),
    [sym_super_assignment] = STATE(567),
    [sym_super_right_assignment] = STATE(567),
    [sym_right_assignment] = STATE(567),
    [sym_brace_list] = STATE(567),
    [sym_paren_list] = STATE(567),
    [sym_subset] = STATE(567),
    [sym_subset2] = STATE(567),
    [sym_dollar] = STATE(567),
    [sym_slot] = STATE(567),
    [sym_namespace_get] = STATE(567),
    [sym_namespace_get_internal] = STATE(567),
    [sym_pipe] = STATE(567),
    [sym_unary] = STATE(567),
    [sym_binary] = STATE(567),
    [sym_na] = STATE(567),
    [sym__expression] = STATE(567),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(567),
    [sym_string] = STATE(567),
    [anon_sym_SEMI] = ACTIONS(1157),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1159),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1159),
    [sym_next] = ACTIONS(1159),
    [sym_true] = ACTIONS(1159),
    [sym_false] = ACTIONS(1159),
    [sym_null] = ACTIONS(1159),
    [sym_inf] = ACTIONS(1159),
    [sym_nan] = ACTIONS(1159),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1157),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [166] = {
    [sym_function_definition] = STATE(568),
    [sym_lambda_function] = STATE(568),
    [sym_if] = STATE(568),
    [sym_while] = STATE(568),
    [sym_repeat] = STATE(568),
    [sym_for] = STATE(568),
    [sym_switch] = STATE(568),
    [sym_call] = STATE(568),
    [sym__assignment] = STATE(568),
    [sym_left_assignment] = STATE(568),
    [sym_left_assignment2] = STATE(568),
    [sym_equals_assignment] = STATE(568),
    [sym_super_assignment] = STATE(568),
    [sym_super_right_assignment] = STATE(568),
    [sym_right_assignment] = STATE(568),
    [sym_brace_list] = STATE(568),
    [sym_paren_list] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym_dollar] = STATE(568),
    [sym_slot] = STATE(568),
    [sym_namespace_get] = STATE(568),
    [sym_namespace_get_internal] = STATE(568),
    [sym_pipe] = STATE(568),
    [sym_unary] = STATE(568),
    [sym_binary] = STATE(568),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(568),
    [sym_string] = STATE(568),
    [anon_sym_SEMI] = ACTIONS(1161),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1163),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1163),
    [sym_next] = ACTIONS(1163),
    [sym_true] = ACTIONS(1163),
    [sym_false] = ACTIONS(1163),
    [sym_null] = ACTIONS(1163),
    [sym_inf] = ACTIONS(1163),
    [sym_nan] = ACTIONS(1163),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1161),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [167] = {
    [sym_function_definition] = STATE(684),
    [sym_lambda_function] = STATE(684),
    [sym_if] = STATE(684),
    [sym_while] = STATE(684),
    [sym_repeat] = STATE(684),
    [sym_for] = STATE(684),
    [sym_switch] = STATE(684),
    [sym_call] = STATE(684),
    [sym__assignment] = STATE(684),
    [sym_left_assignment] = STATE(684),
    [sym_left_assignment2] = STATE(684),
    [sym_equals_assignment] = STATE(684),
    [sym_super_assignment] = STATE(684),
    [sym_super_right_assignment] = STATE(684),
    [sym_right_assignment] = STATE(684),
    [sym_brace_list] = STATE(684),
    [sym_paren_list] = STATE(684),
    [sym_subset] = STATE(684),
    [sym_subset2] = STATE(684),
    [sym_dollar] = STATE(684),
    [sym_slot] = STATE(684),
    [sym_namespace_get] = STATE(684),
    [sym_namespace_get_internal] = STATE(684),
    [sym_pipe] = STATE(684),
    [sym_unary] = STATE(684),
    [sym_binary] = STATE(684),
    [sym_na] = STATE(684),
    [sym__expression] = STATE(684),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(684),
    [sym_string] = STATE(684),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1167),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1167),
    [sym_next] = ACTIONS(1167),
    [sym_true] = ACTIONS(1167),
    [sym_false] = ACTIONS(1167),
    [sym_null] = ACTIONS(1167),
    [sym_inf] = ACTIONS(1167),
    [sym_nan] = ACTIONS(1167),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1165),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [168] = {
    [sym_function_definition] = STATE(807),
    [sym_lambda_function] = STATE(807),
    [sym_if] = STATE(807),
    [sym_while] = STATE(807),
    [sym_repeat] = STATE(807),
    [sym_for] = STATE(807),
    [sym_switch] = STATE(807),
    [sym_call] = STATE(807),
    [sym__assignment] = STATE(807),
    [sym_left_assignment] = STATE(807),
    [sym_left_assignment2] = STATE(807),
    [sym_equals_assignment] = STATE(807),
    [sym_super_assignment] = STATE(807),
    [sym_super_right_assignment] = STATE(807),
    [sym_right_assignment] = STATE(807),
    [sym_brace_list] = STATE(807),
    [sym_paren_list] = STATE(807),
    [sym_subset] = STATE(807),
    [sym_subset2] = STATE(807),
    [sym_dollar] = STATE(807),
    [sym_slot] = STATE(807),
    [sym_namespace_get] = STATE(807),
    [sym_namespace_get_internal] = STATE(807),
    [sym_pipe] = STATE(807),
    [sym_unary] = STATE(807),
    [sym_binary] = STATE(807),
    [sym_na] = STATE(807),
    [sym__expression] = STATE(807),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(807),
    [sym_string] = STATE(807),
    [anon_sym_SEMI] = ACTIONS(1169),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1171),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1171),
    [sym_next] = ACTIONS(1171),
    [sym_true] = ACTIONS(1171),
    [sym_false] = ACTIONS(1171),
    [sym_null] = ACTIONS(1171),
    [sym_inf] = ACTIONS(1171),
    [sym_nan] = ACTIONS(1171),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1169),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [169] = {
    [sym_function_definition] = STATE(815),
    [sym_lambda_function] = STATE(815),
    [sym_if] = STATE(815),
    [sym_while] = STATE(815),
    [sym_repeat] = STATE(815),
    [sym_for] = STATE(815),
    [sym_switch] = STATE(815),
    [sym_call] = STATE(815),
    [sym__assignment] = STATE(815),
    [sym_left_assignment] = STATE(815),
    [sym_left_assignment2] = STATE(815),
    [sym_equals_assignment] = STATE(815),
    [sym_super_assignment] = STATE(815),
    [sym_super_right_assignment] = STATE(815),
    [sym_right_assignment] = STATE(815),
    [sym_brace_list] = STATE(815),
    [sym_paren_list] = STATE(815),
    [sym_subset] = STATE(815),
    [sym_subset2] = STATE(815),
    [sym_dollar] = STATE(815),
    [sym_slot] = STATE(815),
    [sym_namespace_get] = STATE(815),
    [sym_namespace_get_internal] = STATE(815),
    [sym_pipe] = STATE(815),
    [sym_unary] = STATE(815),
    [sym_binary] = STATE(815),
    [sym_na] = STATE(815),
    [sym__expression] = STATE(815),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(815),
    [sym_string] = STATE(815),
    [anon_sym_SEMI] = ACTIONS(1173),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1175),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1175),
    [sym_next] = ACTIONS(1175),
    [sym_true] = ACTIONS(1175),
    [sym_false] = ACTIONS(1175),
    [sym_null] = ACTIONS(1175),
    [sym_inf] = ACTIONS(1175),
    [sym_nan] = ACTIONS(1175),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1173),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [170] = {
    [sym_function_definition] = STATE(804),
    [sym_lambda_function] = STATE(804),
    [sym_if] = STATE(804),
    [sym_while] = STATE(804),
    [sym_repeat] = STATE(804),
    [sym_for] = STATE(804),
    [sym_switch] = STATE(804),
    [sym_call] = STATE(804),
    [sym__assignment] = STATE(804),
    [sym_left_assignment] = STATE(804),
    [sym_left_assignment2] = STATE(804),
    [sym_equals_assignment] = STATE(804),
    [sym_super_assignment] = STATE(804),
    [sym_super_right_assignment] = STATE(804),
    [sym_right_assignment] = STATE(804),
    [sym_brace_list] = STATE(804),
    [sym_paren_list] = STATE(804),
    [sym_subset] = STATE(804),
    [sym_subset2] = STATE(804),
    [sym_dollar] = STATE(804),
    [sym_slot] = STATE(804),
    [sym_namespace_get] = STATE(804),
    [sym_namespace_get_internal] = STATE(804),
    [sym_pipe] = STATE(804),
    [sym_unary] = STATE(804),
    [sym_binary] = STATE(804),
    [sym_na] = STATE(804),
    [sym__expression] = STATE(804),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(804),
    [sym_string] = STATE(804),
    [anon_sym_SEMI] = ACTIONS(1177),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1179),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1179),
    [sym_next] = ACTIONS(1179),
    [sym_true] = ACTIONS(1179),
    [sym_false] = ACTIONS(1179),
    [sym_null] = ACTIONS(1179),
    [sym_inf] = ACTIONS(1179),
    [sym_nan] = ACTIONS(1179),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1177),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [171] = {
    [sym_function_definition] = STATE(802),
    [sym_lambda_function] = STATE(802),
    [sym_if] = STATE(802),
    [sym_while] = STATE(802),
    [sym_repeat] = STATE(802),
    [sym_for] = STATE(802),
    [sym_switch] = STATE(802),
    [sym_call] = STATE(802),
    [sym__assignment] = STATE(802),
    [sym_left_assignment] = STATE(802),
    [sym_left_assignment2] = STATE(802),
    [sym_equals_assignment] = STATE(802),
    [sym_super_assignment] = STATE(802),
    [sym_super_right_assignment] = STATE(802),
    [sym_right_assignment] = STATE(802),
    [sym_brace_list] = STATE(802),
    [sym_paren_list] = STATE(802),
    [sym_subset] = STATE(802),
    [sym_subset2] = STATE(802),
    [sym_dollar] = STATE(802),
    [sym_slot] = STATE(802),
    [sym_namespace_get] = STATE(802),
    [sym_namespace_get_internal] = STATE(802),
    [sym_pipe] = STATE(802),
    [sym_unary] = STATE(802),
    [sym_binary] = STATE(802),
    [sym_na] = STATE(802),
    [sym__expression] = STATE(802),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(802),
    [sym_string] = STATE(802),
    [anon_sym_SEMI] = ACTIONS(1181),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1183),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1183),
    [sym_next] = ACTIONS(1183),
    [sym_true] = ACTIONS(1183),
    [sym_false] = ACTIONS(1183),
    [sym_null] = ACTIONS(1183),
    [sym_inf] = ACTIONS(1183),
    [sym_nan] = ACTIONS(1183),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1181),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [172] = {
    [sym_function_definition] = STATE(806),
    [sym_lambda_function] = STATE(806),
    [sym_if] = STATE(806),
    [sym_while] = STATE(806),
    [sym_repeat] = STATE(806),
    [sym_for] = STATE(806),
    [sym_switch] = STATE(806),
    [sym_call] = STATE(806),
    [sym__assignment] = STATE(806),
    [sym_left_assignment] = STATE(806),
    [sym_left_assignment2] = STATE(806),
    [sym_equals_assignment] = STATE(806),
    [sym_super_assignment] = STATE(806),
    [sym_super_right_assignment] = STATE(806),
    [sym_right_assignment] = STATE(806),
    [sym_brace_list] = STATE(806),
    [sym_paren_list] = STATE(806),
    [sym_subset] = STATE(806),
    [sym_subset2] = STATE(806),
    [sym_dollar] = STATE(806),
    [sym_slot] = STATE(806),
    [sym_namespace_get] = STATE(806),
    [sym_namespace_get_internal] = STATE(806),
    [sym_pipe] = STATE(806),
    [sym_unary] = STATE(806),
    [sym_binary] = STATE(806),
    [sym_na] = STATE(806),
    [sym__expression] = STATE(806),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(806),
    [sym_string] = STATE(806),
    [anon_sym_SEMI] = ACTIONS(1185),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1187),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1187),
    [sym_next] = ACTIONS(1187),
    [sym_true] = ACTIONS(1187),
    [sym_false] = ACTIONS(1187),
    [sym_null] = ACTIONS(1187),
    [sym_inf] = ACTIONS(1187),
    [sym_nan] = ACTIONS(1187),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1185),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [173] = {
    [anon_sym_SEMI] = ACTIONS(647),
    [anon_sym_function] = ACTIONS(649),
    [anon_sym_BSLASH] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(647),
    [anon_sym_RPAREN] = ACTIONS(647),
    [anon_sym_while] = ACTIONS(649),
    [anon_sym_repeat] = ACTIONS(649),
    [anon_sym_for] = ACTIONS(649),
    [anon_sym_switch] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_LT_DASH] = ACTIONS(647),
    [anon_sym_COLON_EQ] = ACTIONS(647),
    [anon_sym_LT_LT_DASH] = ACTIONS(647),
    [anon_sym_DASH_GT_GT] = ACTIONS(647),
    [anon_sym_DASH_GT] = ACTIONS(649),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_RBRACK] = ACTIONS(647),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(647),
    [anon_sym_DOLLAR] = ACTIONS(647),
    [anon_sym_AT] = ACTIONS(647),
    [anon_sym_COLON_COLON] = ACTIONS(649),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(647),
    [sym_dots] = ACTIONS(649),
    [anon_sym_PIPE_GT] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(649),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(649),
    [anon_sym_GT] = ACTIONS(649),
    [anon_sym_LT_EQ] = ACTIONS(647),
    [anon_sym_GT_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(649),
    [anon_sym_COLON] = ACTIONS(649),
    [sym_break] = ACTIONS(649),
    [sym_next] = ACTIONS(649),
    [sym_true] = ACTIONS(649),
    [sym_false] = ACTIONS(649),
    [sym_null] = ACTIONS(649),
    [sym_inf] = ACTIONS(649),
    [sym_nan] = ACTIONS(649),
    [anon_sym_NA] = ACTIONS(649),
    [anon_sym_NA_character_] = ACTIONS(649),
    [anon_sym_NA_complex_] = ACTIONS(649),
    [anon_sym_NA_integer_] = ACTIONS(649),
    [anon_sym_NA_real_] = ACTIONS(649),
    [aux_sym_identifier_token1] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(647),
    [sym_integer] = ACTIONS(647),
    [sym_float] = ACTIONS(649),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(647),
    [anon_sym_SQUOTE] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
  },
  [174] = {
    [sym_function_definition] = STATE(928),
    [sym_lambda_function] = STATE(928),
    [sym_if] = STATE(928),
    [sym_while] = STATE(928),
    [sym_repeat] = STATE(928),
    [sym_for] = STATE(928),
    [sym_switch] = STATE(928),
    [sym_call] = STATE(771),
    [sym__assignment] = STATE(928),
    [sym_left_assignment] = STATE(928),
    [sym_left_assignment2] = STATE(928),
    [sym_equals_assignment] = STATE(928),
    [sym_super_assignment] = STATE(928),
    [sym_super_right_assignment] = STATE(928),
    [sym_right_assignment] = STATE(928),
    [sym_brace_list] = STATE(928),
    [sym_paren_list] = STATE(928),
    [sym_subset] = STATE(928),
    [sym_subset2] = STATE(928),
    [sym_dollar] = STATE(928),
    [sym_slot] = STATE(928),
    [sym_namespace_get] = STATE(928),
    [sym_namespace_get_internal] = STATE(928),
    [sym_pipe] = STATE(928),
    [sym_unary] = STATE(928),
    [sym_binary] = STATE(928),
    [sym_na] = STATE(928),
    [sym__expression] = STATE(928),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(928),
    [sym_string] = STATE(928),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1191),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1191),
    [sym_next] = ACTIONS(1191),
    [sym_true] = ACTIONS(1191),
    [sym_false] = ACTIONS(1191),
    [sym_null] = ACTIONS(1191),
    [sym_inf] = ACTIONS(1191),
    [sym_nan] = ACTIONS(1191),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1189),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [175] = {
    [sym_function_definition] = STATE(682),
    [sym_lambda_function] = STATE(682),
    [sym_if] = STATE(682),
    [sym_while] = STATE(682),
    [sym_repeat] = STATE(682),
    [sym_for] = STATE(682),
    [sym_switch] = STATE(682),
    [sym_call] = STATE(682),
    [sym__assignment] = STATE(682),
    [sym_left_assignment] = STATE(682),
    [sym_left_assignment2] = STATE(682),
    [sym_equals_assignment] = STATE(682),
    [sym_super_assignment] = STATE(682),
    [sym_super_right_assignment] = STATE(682),
    [sym_right_assignment] = STATE(682),
    [sym_brace_list] = STATE(682),
    [sym_paren_list] = STATE(682),
    [sym_subset] = STATE(682),
    [sym_subset2] = STATE(682),
    [sym_dollar] = STATE(682),
    [sym_slot] = STATE(682),
    [sym_namespace_get] = STATE(682),
    [sym_namespace_get_internal] = STATE(682),
    [sym_pipe] = STATE(682),
    [sym_unary] = STATE(682),
    [sym_binary] = STATE(682),
    [sym_na] = STATE(682),
    [sym__expression] = STATE(682),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(682),
    [sym_string] = STATE(682),
    [anon_sym_SEMI] = ACTIONS(1193),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1195),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1195),
    [sym_next] = ACTIONS(1195),
    [sym_true] = ACTIONS(1195),
    [sym_false] = ACTIONS(1195),
    [sym_null] = ACTIONS(1195),
    [sym_inf] = ACTIONS(1195),
    [sym_nan] = ACTIONS(1195),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1193),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [176] = {
    [sym_function_definition] = STATE(679),
    [sym_lambda_function] = STATE(679),
    [sym_if] = STATE(679),
    [sym_while] = STATE(679),
    [sym_repeat] = STATE(679),
    [sym_for] = STATE(679),
    [sym_switch] = STATE(679),
    [sym_call] = STATE(679),
    [sym__assignment] = STATE(679),
    [sym_left_assignment] = STATE(679),
    [sym_left_assignment2] = STATE(679),
    [sym_equals_assignment] = STATE(679),
    [sym_super_assignment] = STATE(679),
    [sym_super_right_assignment] = STATE(679),
    [sym_right_assignment] = STATE(679),
    [sym_brace_list] = STATE(679),
    [sym_paren_list] = STATE(679),
    [sym_subset] = STATE(679),
    [sym_subset2] = STATE(679),
    [sym_dollar] = STATE(679),
    [sym_slot] = STATE(679),
    [sym_namespace_get] = STATE(679),
    [sym_namespace_get_internal] = STATE(679),
    [sym_pipe] = STATE(679),
    [sym_unary] = STATE(679),
    [sym_binary] = STATE(679),
    [sym_na] = STATE(679),
    [sym__expression] = STATE(679),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(679),
    [sym_string] = STATE(679),
    [anon_sym_SEMI] = ACTIONS(1197),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1199),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1199),
    [sym_next] = ACTIONS(1199),
    [sym_true] = ACTIONS(1199),
    [sym_false] = ACTIONS(1199),
    [sym_null] = ACTIONS(1199),
    [sym_inf] = ACTIONS(1199),
    [sym_nan] = ACTIONS(1199),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1197),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [177] = {
    [sym_function_definition] = STATE(558),
    [sym_lambda_function] = STATE(558),
    [sym_if] = STATE(558),
    [sym_while] = STATE(558),
    [sym_repeat] = STATE(558),
    [sym_for] = STATE(558),
    [sym_switch] = STATE(558),
    [sym_call] = STATE(558),
    [sym__assignment] = STATE(558),
    [sym_left_assignment] = STATE(558),
    [sym_left_assignment2] = STATE(558),
    [sym_equals_assignment] = STATE(558),
    [sym_super_assignment] = STATE(558),
    [sym_super_right_assignment] = STATE(558),
    [sym_right_assignment] = STATE(558),
    [sym_brace_list] = STATE(558),
    [sym_paren_list] = STATE(558),
    [sym_subset] = STATE(558),
    [sym_subset2] = STATE(558),
    [sym_dollar] = STATE(558),
    [sym_slot] = STATE(558),
    [sym_namespace_get] = STATE(558),
    [sym_namespace_get_internal] = STATE(558),
    [sym_pipe] = STATE(558),
    [sym_unary] = STATE(558),
    [sym_binary] = STATE(558),
    [sym_na] = STATE(558),
    [sym__expression] = STATE(558),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(558),
    [sym_string] = STATE(558),
    [anon_sym_SEMI] = ACTIONS(1201),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1203),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1203),
    [sym_next] = ACTIONS(1203),
    [sym_true] = ACTIONS(1203),
    [sym_false] = ACTIONS(1203),
    [sym_null] = ACTIONS(1203),
    [sym_inf] = ACTIONS(1203),
    [sym_nan] = ACTIONS(1203),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1201),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [178] = {
    [sym_function_definition] = STATE(557),
    [sym_lambda_function] = STATE(557),
    [sym_if] = STATE(557),
    [sym_while] = STATE(557),
    [sym_repeat] = STATE(557),
    [sym_for] = STATE(557),
    [sym_switch] = STATE(557),
    [sym_call] = STATE(557),
    [sym__assignment] = STATE(557),
    [sym_left_assignment] = STATE(557),
    [sym_left_assignment2] = STATE(557),
    [sym_equals_assignment] = STATE(557),
    [sym_super_assignment] = STATE(557),
    [sym_super_right_assignment] = STATE(557),
    [sym_right_assignment] = STATE(557),
    [sym_brace_list] = STATE(557),
    [sym_paren_list] = STATE(557),
    [sym_subset] = STATE(557),
    [sym_subset2] = STATE(557),
    [sym_dollar] = STATE(557),
    [sym_slot] = STATE(557),
    [sym_namespace_get] = STATE(557),
    [sym_namespace_get_internal] = STATE(557),
    [sym_pipe] = STATE(557),
    [sym_unary] = STATE(557),
    [sym_binary] = STATE(557),
    [sym_na] = STATE(557),
    [sym__expression] = STATE(557),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(557),
    [sym_string] = STATE(557),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1207),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1207),
    [sym_next] = ACTIONS(1207),
    [sym_true] = ACTIONS(1207),
    [sym_false] = ACTIONS(1207),
    [sym_null] = ACTIONS(1207),
    [sym_inf] = ACTIONS(1207),
    [sym_nan] = ACTIONS(1207),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1205),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [179] = {
    [sym_function_definition] = STATE(552),
    [sym_lambda_function] = STATE(552),
    [sym_if] = STATE(552),
    [sym_while] = STATE(552),
    [sym_repeat] = STATE(552),
    [sym_for] = STATE(552),
    [sym_switch] = STATE(552),
    [sym_call] = STATE(552),
    [sym__assignment] = STATE(552),
    [sym_left_assignment] = STATE(552),
    [sym_left_assignment2] = STATE(552),
    [sym_equals_assignment] = STATE(552),
    [sym_super_assignment] = STATE(552),
    [sym_super_right_assignment] = STATE(552),
    [sym_right_assignment] = STATE(552),
    [sym_brace_list] = STATE(552),
    [sym_paren_list] = STATE(552),
    [sym_subset] = STATE(552),
    [sym_subset2] = STATE(552),
    [sym_dollar] = STATE(552),
    [sym_slot] = STATE(552),
    [sym_namespace_get] = STATE(552),
    [sym_namespace_get_internal] = STATE(552),
    [sym_pipe] = STATE(552),
    [sym_unary] = STATE(552),
    [sym_binary] = STATE(552),
    [sym_na] = STATE(552),
    [sym__expression] = STATE(552),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(552),
    [sym_string] = STATE(552),
    [anon_sym_SEMI] = ACTIONS(1209),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1211),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1211),
    [sym_next] = ACTIONS(1211),
    [sym_true] = ACTIONS(1211),
    [sym_false] = ACTIONS(1211),
    [sym_null] = ACTIONS(1211),
    [sym_inf] = ACTIONS(1211),
    [sym_nan] = ACTIONS(1211),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1209),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [180] = {
    [sym_function_definition] = STATE(549),
    [sym_lambda_function] = STATE(549),
    [sym_if] = STATE(549),
    [sym_while] = STATE(549),
    [sym_repeat] = STATE(549),
    [sym_for] = STATE(549),
    [sym_switch] = STATE(549),
    [sym_call] = STATE(549),
    [sym__assignment] = STATE(549),
    [sym_left_assignment] = STATE(549),
    [sym_left_assignment2] = STATE(549),
    [sym_equals_assignment] = STATE(549),
    [sym_super_assignment] = STATE(549),
    [sym_super_right_assignment] = STATE(549),
    [sym_right_assignment] = STATE(549),
    [sym_brace_list] = STATE(549),
    [sym_paren_list] = STATE(549),
    [sym_subset] = STATE(549),
    [sym_subset2] = STATE(549),
    [sym_dollar] = STATE(549),
    [sym_slot] = STATE(549),
    [sym_namespace_get] = STATE(549),
    [sym_namespace_get_internal] = STATE(549),
    [sym_pipe] = STATE(549),
    [sym_unary] = STATE(549),
    [sym_binary] = STATE(549),
    [sym_na] = STATE(549),
    [sym__expression] = STATE(549),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(549),
    [sym_string] = STATE(549),
    [anon_sym_SEMI] = ACTIONS(1213),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1215),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1215),
    [sym_next] = ACTIONS(1215),
    [sym_true] = ACTIONS(1215),
    [sym_false] = ACTIONS(1215),
    [sym_null] = ACTIONS(1215),
    [sym_inf] = ACTIONS(1215),
    [sym_nan] = ACTIONS(1215),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1213),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [181] = {
    [sym_function_definition] = STATE(545),
    [sym_lambda_function] = STATE(545),
    [sym_if] = STATE(545),
    [sym_while] = STATE(545),
    [sym_repeat] = STATE(545),
    [sym_for] = STATE(545),
    [sym_switch] = STATE(545),
    [sym_call] = STATE(545),
    [sym__assignment] = STATE(545),
    [sym_left_assignment] = STATE(545),
    [sym_left_assignment2] = STATE(545),
    [sym_equals_assignment] = STATE(545),
    [sym_super_assignment] = STATE(545),
    [sym_super_right_assignment] = STATE(545),
    [sym_right_assignment] = STATE(545),
    [sym_brace_list] = STATE(545),
    [sym_paren_list] = STATE(545),
    [sym_subset] = STATE(545),
    [sym_subset2] = STATE(545),
    [sym_dollar] = STATE(545),
    [sym_slot] = STATE(545),
    [sym_namespace_get] = STATE(545),
    [sym_namespace_get_internal] = STATE(545),
    [sym_pipe] = STATE(545),
    [sym_unary] = STATE(545),
    [sym_binary] = STATE(545),
    [sym_na] = STATE(545),
    [sym__expression] = STATE(545),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(545),
    [sym_string] = STATE(545),
    [anon_sym_SEMI] = ACTIONS(1217),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1219),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1219),
    [sym_next] = ACTIONS(1219),
    [sym_true] = ACTIONS(1219),
    [sym_false] = ACTIONS(1219),
    [sym_null] = ACTIONS(1219),
    [sym_inf] = ACTIONS(1219),
    [sym_nan] = ACTIONS(1219),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1217),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [182] = {
    [sym_function_definition] = STATE(924),
    [sym_lambda_function] = STATE(924),
    [sym_if] = STATE(924),
    [sym_while] = STATE(924),
    [sym_repeat] = STATE(924),
    [sym_for] = STATE(924),
    [sym_switch] = STATE(924),
    [sym_call] = STATE(777),
    [sym__assignment] = STATE(924),
    [sym_left_assignment] = STATE(924),
    [sym_left_assignment2] = STATE(924),
    [sym_equals_assignment] = STATE(924),
    [sym_super_assignment] = STATE(924),
    [sym_super_right_assignment] = STATE(924),
    [sym_right_assignment] = STATE(924),
    [sym_brace_list] = STATE(924),
    [sym_paren_list] = STATE(924),
    [sym_subset] = STATE(924),
    [sym_subset2] = STATE(924),
    [sym_dollar] = STATE(924),
    [sym_slot] = STATE(924),
    [sym_namespace_get] = STATE(924),
    [sym_namespace_get_internal] = STATE(924),
    [sym_pipe] = STATE(924),
    [sym_unary] = STATE(924),
    [sym_binary] = STATE(924),
    [sym_na] = STATE(924),
    [sym__expression] = STATE(924),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(924),
    [sym_string] = STATE(924),
    [anon_sym_SEMI] = ACTIONS(1221),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1223),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1223),
    [sym_next] = ACTIONS(1223),
    [sym_true] = ACTIONS(1223),
    [sym_false] = ACTIONS(1223),
    [sym_null] = ACTIONS(1223),
    [sym_inf] = ACTIONS(1223),
    [sym_nan] = ACTIONS(1223),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1221),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [183] = {
    [sym_function_definition] = STATE(672),
    [sym_lambda_function] = STATE(672),
    [sym_if] = STATE(672),
    [sym_while] = STATE(672),
    [sym_repeat] = STATE(672),
    [sym_for] = STATE(672),
    [sym_switch] = STATE(672),
    [sym_call] = STATE(672),
    [sym__assignment] = STATE(672),
    [sym_left_assignment] = STATE(672),
    [sym_left_assignment2] = STATE(672),
    [sym_equals_assignment] = STATE(672),
    [sym_super_assignment] = STATE(672),
    [sym_super_right_assignment] = STATE(672),
    [sym_right_assignment] = STATE(672),
    [sym_brace_list] = STATE(672),
    [sym_paren_list] = STATE(672),
    [sym_subset] = STATE(672),
    [sym_subset2] = STATE(672),
    [sym_dollar] = STATE(672),
    [sym_slot] = STATE(672),
    [sym_namespace_get] = STATE(672),
    [sym_namespace_get_internal] = STATE(672),
    [sym_pipe] = STATE(672),
    [sym_unary] = STATE(672),
    [sym_binary] = STATE(672),
    [sym_na] = STATE(672),
    [sym__expression] = STATE(672),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(672),
    [sym_string] = STATE(672),
    [anon_sym_SEMI] = ACTIONS(1225),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1227),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1227),
    [sym_next] = ACTIONS(1227),
    [sym_true] = ACTIONS(1227),
    [sym_false] = ACTIONS(1227),
    [sym_null] = ACTIONS(1227),
    [sym_inf] = ACTIONS(1227),
    [sym_nan] = ACTIONS(1227),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1225),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [184] = {
    [sym_function_definition] = STATE(666),
    [sym_lambda_function] = STATE(666),
    [sym_if] = STATE(666),
    [sym_while] = STATE(666),
    [sym_repeat] = STATE(666),
    [sym_for] = STATE(666),
    [sym_switch] = STATE(666),
    [sym_call] = STATE(666),
    [sym__assignment] = STATE(666),
    [sym_left_assignment] = STATE(666),
    [sym_left_assignment2] = STATE(666),
    [sym_equals_assignment] = STATE(666),
    [sym_super_assignment] = STATE(666),
    [sym_super_right_assignment] = STATE(666),
    [sym_right_assignment] = STATE(666),
    [sym_brace_list] = STATE(666),
    [sym_paren_list] = STATE(666),
    [sym_subset] = STATE(666),
    [sym_subset2] = STATE(666),
    [sym_dollar] = STATE(666),
    [sym_slot] = STATE(666),
    [sym_namespace_get] = STATE(666),
    [sym_namespace_get_internal] = STATE(666),
    [sym_pipe] = STATE(666),
    [sym_unary] = STATE(666),
    [sym_binary] = STATE(666),
    [sym_na] = STATE(666),
    [sym__expression] = STATE(666),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(666),
    [sym_string] = STATE(666),
    [anon_sym_SEMI] = ACTIONS(1229),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1231),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1231),
    [sym_next] = ACTIONS(1231),
    [sym_true] = ACTIONS(1231),
    [sym_false] = ACTIONS(1231),
    [sym_null] = ACTIONS(1231),
    [sym_inf] = ACTIONS(1231),
    [sym_nan] = ACTIONS(1231),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1229),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [185] = {
    [sym_function_definition] = STATE(543),
    [sym_lambda_function] = STATE(543),
    [sym_if] = STATE(543),
    [sym_while] = STATE(543),
    [sym_repeat] = STATE(543),
    [sym_for] = STATE(543),
    [sym_switch] = STATE(543),
    [sym_call] = STATE(543),
    [sym__assignment] = STATE(543),
    [sym_left_assignment] = STATE(543),
    [sym_left_assignment2] = STATE(543),
    [sym_equals_assignment] = STATE(543),
    [sym_super_assignment] = STATE(543),
    [sym_super_right_assignment] = STATE(543),
    [sym_right_assignment] = STATE(543),
    [sym_brace_list] = STATE(543),
    [sym_paren_list] = STATE(543),
    [sym_subset] = STATE(543),
    [sym_subset2] = STATE(543),
    [sym_dollar] = STATE(543),
    [sym_slot] = STATE(543),
    [sym_namespace_get] = STATE(543),
    [sym_namespace_get_internal] = STATE(543),
    [sym_pipe] = STATE(543),
    [sym_unary] = STATE(543),
    [sym_binary] = STATE(543),
    [sym_na] = STATE(543),
    [sym__expression] = STATE(543),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(543),
    [sym_string] = STATE(543),
    [anon_sym_SEMI] = ACTIONS(1233),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1235),
    [sym_next] = ACTIONS(1235),
    [sym_true] = ACTIONS(1235),
    [sym_false] = ACTIONS(1235),
    [sym_null] = ACTIONS(1235),
    [sym_inf] = ACTIONS(1235),
    [sym_nan] = ACTIONS(1235),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1233),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [186] = {
    [sym_function_definition] = STATE(541),
    [sym_lambda_function] = STATE(541),
    [sym_if] = STATE(541),
    [sym_while] = STATE(541),
    [sym_repeat] = STATE(541),
    [sym_for] = STATE(541),
    [sym_switch] = STATE(541),
    [sym_call] = STATE(541),
    [sym__assignment] = STATE(541),
    [sym_left_assignment] = STATE(541),
    [sym_left_assignment2] = STATE(541),
    [sym_equals_assignment] = STATE(541),
    [sym_super_assignment] = STATE(541),
    [sym_super_right_assignment] = STATE(541),
    [sym_right_assignment] = STATE(541),
    [sym_brace_list] = STATE(541),
    [sym_paren_list] = STATE(541),
    [sym_subset] = STATE(541),
    [sym_subset2] = STATE(541),
    [sym_dollar] = STATE(541),
    [sym_slot] = STATE(541),
    [sym_namespace_get] = STATE(541),
    [sym_namespace_get_internal] = STATE(541),
    [sym_pipe] = STATE(541),
    [sym_unary] = STATE(541),
    [sym_binary] = STATE(541),
    [sym_na] = STATE(541),
    [sym__expression] = STATE(541),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(541),
    [sym_string] = STATE(541),
    [anon_sym_SEMI] = ACTIONS(1237),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1239),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1239),
    [sym_next] = ACTIONS(1239),
    [sym_true] = ACTIONS(1239),
    [sym_false] = ACTIONS(1239),
    [sym_null] = ACTIONS(1239),
    [sym_inf] = ACTIONS(1239),
    [sym_nan] = ACTIONS(1239),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1237),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [187] = {
    [sym_function_definition] = STATE(540),
    [sym_lambda_function] = STATE(540),
    [sym_if] = STATE(540),
    [sym_while] = STATE(540),
    [sym_repeat] = STATE(540),
    [sym_for] = STATE(540),
    [sym_switch] = STATE(540),
    [sym_call] = STATE(540),
    [sym__assignment] = STATE(540),
    [sym_left_assignment] = STATE(540),
    [sym_left_assignment2] = STATE(540),
    [sym_equals_assignment] = STATE(540),
    [sym_super_assignment] = STATE(540),
    [sym_super_right_assignment] = STATE(540),
    [sym_right_assignment] = STATE(540),
    [sym_brace_list] = STATE(540),
    [sym_paren_list] = STATE(540),
    [sym_subset] = STATE(540),
    [sym_subset2] = STATE(540),
    [sym_dollar] = STATE(540),
    [sym_slot] = STATE(540),
    [sym_namespace_get] = STATE(540),
    [sym_namespace_get_internal] = STATE(540),
    [sym_pipe] = STATE(540),
    [sym_unary] = STATE(540),
    [sym_binary] = STATE(540),
    [sym_na] = STATE(540),
    [sym__expression] = STATE(540),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(540),
    [sym_string] = STATE(540),
    [anon_sym_SEMI] = ACTIONS(1241),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1243),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1243),
    [sym_next] = ACTIONS(1243),
    [sym_true] = ACTIONS(1243),
    [sym_false] = ACTIONS(1243),
    [sym_null] = ACTIONS(1243),
    [sym_inf] = ACTIONS(1243),
    [sym_nan] = ACTIONS(1243),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1241),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [188] = {
    [sym_function_definition] = STATE(539),
    [sym_lambda_function] = STATE(539),
    [sym_if] = STATE(539),
    [sym_while] = STATE(539),
    [sym_repeat] = STATE(539),
    [sym_for] = STATE(539),
    [sym_switch] = STATE(539),
    [sym_call] = STATE(539),
    [sym__assignment] = STATE(539),
    [sym_left_assignment] = STATE(539),
    [sym_left_assignment2] = STATE(539),
    [sym_equals_assignment] = STATE(539),
    [sym_super_assignment] = STATE(539),
    [sym_super_right_assignment] = STATE(539),
    [sym_right_assignment] = STATE(539),
    [sym_brace_list] = STATE(539),
    [sym_paren_list] = STATE(539),
    [sym_subset] = STATE(539),
    [sym_subset2] = STATE(539),
    [sym_dollar] = STATE(539),
    [sym_slot] = STATE(539),
    [sym_namespace_get] = STATE(539),
    [sym_namespace_get_internal] = STATE(539),
    [sym_pipe] = STATE(539),
    [sym_unary] = STATE(539),
    [sym_binary] = STATE(539),
    [sym_na] = STATE(539),
    [sym__expression] = STATE(539),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(539),
    [sym_string] = STATE(539),
    [anon_sym_SEMI] = ACTIONS(1245),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1247),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1247),
    [sym_next] = ACTIONS(1247),
    [sym_true] = ACTIONS(1247),
    [sym_false] = ACTIONS(1247),
    [sym_null] = ACTIONS(1247),
    [sym_inf] = ACTIONS(1247),
    [sym_nan] = ACTIONS(1247),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1245),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [189] = {
    [sym_function_definition] = STATE(538),
    [sym_lambda_function] = STATE(538),
    [sym_if] = STATE(538),
    [sym_while] = STATE(538),
    [sym_repeat] = STATE(538),
    [sym_for] = STATE(538),
    [sym_switch] = STATE(538),
    [sym_call] = STATE(538),
    [sym__assignment] = STATE(538),
    [sym_left_assignment] = STATE(538),
    [sym_left_assignment2] = STATE(538),
    [sym_equals_assignment] = STATE(538),
    [sym_super_assignment] = STATE(538),
    [sym_super_right_assignment] = STATE(538),
    [sym_right_assignment] = STATE(538),
    [sym_brace_list] = STATE(538),
    [sym_paren_list] = STATE(538),
    [sym_subset] = STATE(538),
    [sym_subset2] = STATE(538),
    [sym_dollar] = STATE(538),
    [sym_slot] = STATE(538),
    [sym_namespace_get] = STATE(538),
    [sym_namespace_get_internal] = STATE(538),
    [sym_pipe] = STATE(538),
    [sym_unary] = STATE(538),
    [sym_binary] = STATE(538),
    [sym_na] = STATE(538),
    [sym__expression] = STATE(538),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(538),
    [sym_string] = STATE(538),
    [anon_sym_SEMI] = ACTIONS(1249),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1251),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1251),
    [sym_next] = ACTIONS(1251),
    [sym_true] = ACTIONS(1251),
    [sym_false] = ACTIONS(1251),
    [sym_null] = ACTIONS(1251),
    [sym_inf] = ACTIONS(1251),
    [sym_nan] = ACTIONS(1251),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1249),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [190] = {
    [sym_function_definition] = STATE(537),
    [sym_lambda_function] = STATE(537),
    [sym_if] = STATE(537),
    [sym_while] = STATE(537),
    [sym_repeat] = STATE(537),
    [sym_for] = STATE(537),
    [sym_switch] = STATE(537),
    [sym_call] = STATE(537),
    [sym__assignment] = STATE(537),
    [sym_left_assignment] = STATE(537),
    [sym_left_assignment2] = STATE(537),
    [sym_equals_assignment] = STATE(537),
    [sym_super_assignment] = STATE(537),
    [sym_super_right_assignment] = STATE(537),
    [sym_right_assignment] = STATE(537),
    [sym_brace_list] = STATE(537),
    [sym_paren_list] = STATE(537),
    [sym_subset] = STATE(537),
    [sym_subset2] = STATE(537),
    [sym_dollar] = STATE(537),
    [sym_slot] = STATE(537),
    [sym_namespace_get] = STATE(537),
    [sym_namespace_get_internal] = STATE(537),
    [sym_pipe] = STATE(537),
    [sym_unary] = STATE(537),
    [sym_binary] = STATE(537),
    [sym_na] = STATE(537),
    [sym__expression] = STATE(537),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(537),
    [sym_string] = STATE(537),
    [anon_sym_SEMI] = ACTIONS(1253),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1255),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1255),
    [sym_next] = ACTIONS(1255),
    [sym_true] = ACTIONS(1255),
    [sym_false] = ACTIONS(1255),
    [sym_null] = ACTIONS(1255),
    [sym_inf] = ACTIONS(1255),
    [sym_nan] = ACTIONS(1255),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1253),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [191] = {
    [sym_function_definition] = STATE(526),
    [sym_lambda_function] = STATE(526),
    [sym_if] = STATE(526),
    [sym_while] = STATE(526),
    [sym_repeat] = STATE(526),
    [sym_for] = STATE(526),
    [sym_switch] = STATE(526),
    [sym_call] = STATE(526),
    [sym__assignment] = STATE(526),
    [sym_left_assignment] = STATE(526),
    [sym_left_assignment2] = STATE(526),
    [sym_equals_assignment] = STATE(526),
    [sym_super_assignment] = STATE(526),
    [sym_super_right_assignment] = STATE(526),
    [sym_right_assignment] = STATE(526),
    [sym_brace_list] = STATE(526),
    [sym_paren_list] = STATE(526),
    [sym_subset] = STATE(526),
    [sym_subset2] = STATE(526),
    [sym_dollar] = STATE(526),
    [sym_slot] = STATE(526),
    [sym_namespace_get] = STATE(526),
    [sym_namespace_get_internal] = STATE(526),
    [sym_pipe] = STATE(526),
    [sym_unary] = STATE(526),
    [sym_binary] = STATE(526),
    [sym_na] = STATE(526),
    [sym__expression] = STATE(526),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(526),
    [sym_string] = STATE(526),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1259),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1259),
    [sym_next] = ACTIONS(1259),
    [sym_true] = ACTIONS(1259),
    [sym_false] = ACTIONS(1259),
    [sym_null] = ACTIONS(1259),
    [sym_inf] = ACTIONS(1259),
    [sym_nan] = ACTIONS(1259),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1257),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [192] = {
    [sym_function_definition] = STATE(525),
    [sym_lambda_function] = STATE(525),
    [sym_if] = STATE(525),
    [sym_while] = STATE(525),
    [sym_repeat] = STATE(525),
    [sym_for] = STATE(525),
    [sym_switch] = STATE(525),
    [sym_call] = STATE(525),
    [sym__assignment] = STATE(525),
    [sym_left_assignment] = STATE(525),
    [sym_left_assignment2] = STATE(525),
    [sym_equals_assignment] = STATE(525),
    [sym_super_assignment] = STATE(525),
    [sym_super_right_assignment] = STATE(525),
    [sym_right_assignment] = STATE(525),
    [sym_brace_list] = STATE(525),
    [sym_paren_list] = STATE(525),
    [sym_subset] = STATE(525),
    [sym_subset2] = STATE(525),
    [sym_dollar] = STATE(525),
    [sym_slot] = STATE(525),
    [sym_namespace_get] = STATE(525),
    [sym_namespace_get_internal] = STATE(525),
    [sym_pipe] = STATE(525),
    [sym_unary] = STATE(525),
    [sym_binary] = STATE(525),
    [sym_na] = STATE(525),
    [sym__expression] = STATE(525),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(525),
    [sym_string] = STATE(525),
    [anon_sym_SEMI] = ACTIONS(1261),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1263),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1263),
    [sym_next] = ACTIONS(1263),
    [sym_true] = ACTIONS(1263),
    [sym_false] = ACTIONS(1263),
    [sym_null] = ACTIONS(1263),
    [sym_inf] = ACTIONS(1263),
    [sym_nan] = ACTIONS(1263),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1261),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [193] = {
    [sym_function_definition] = STATE(524),
    [sym_lambda_function] = STATE(524),
    [sym_if] = STATE(524),
    [sym_while] = STATE(524),
    [sym_repeat] = STATE(524),
    [sym_for] = STATE(524),
    [sym_switch] = STATE(524),
    [sym_call] = STATE(524),
    [sym__assignment] = STATE(524),
    [sym_left_assignment] = STATE(524),
    [sym_left_assignment2] = STATE(524),
    [sym_equals_assignment] = STATE(524),
    [sym_super_assignment] = STATE(524),
    [sym_super_right_assignment] = STATE(524),
    [sym_right_assignment] = STATE(524),
    [sym_brace_list] = STATE(524),
    [sym_paren_list] = STATE(524),
    [sym_subset] = STATE(524),
    [sym_subset2] = STATE(524),
    [sym_dollar] = STATE(524),
    [sym_slot] = STATE(524),
    [sym_namespace_get] = STATE(524),
    [sym_namespace_get_internal] = STATE(524),
    [sym_pipe] = STATE(524),
    [sym_unary] = STATE(524),
    [sym_binary] = STATE(524),
    [sym_na] = STATE(524),
    [sym__expression] = STATE(524),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(524),
    [sym_string] = STATE(524),
    [anon_sym_SEMI] = ACTIONS(1265),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1267),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1267),
    [sym_next] = ACTIONS(1267),
    [sym_true] = ACTIONS(1267),
    [sym_false] = ACTIONS(1267),
    [sym_null] = ACTIONS(1267),
    [sym_inf] = ACTIONS(1267),
    [sym_nan] = ACTIONS(1267),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1265),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [194] = {
    [sym_function_definition] = STATE(482),
    [sym_lambda_function] = STATE(482),
    [sym_if] = STATE(482),
    [sym_while] = STATE(482),
    [sym_repeat] = STATE(482),
    [sym_for] = STATE(482),
    [sym_switch] = STATE(482),
    [sym_call] = STATE(482),
    [sym__assignment] = STATE(482),
    [sym_left_assignment] = STATE(482),
    [sym_left_assignment2] = STATE(482),
    [sym_equals_assignment] = STATE(482),
    [sym_super_assignment] = STATE(482),
    [sym_super_right_assignment] = STATE(482),
    [sym_right_assignment] = STATE(482),
    [sym_brace_list] = STATE(482),
    [sym_paren_list] = STATE(482),
    [sym_subset] = STATE(482),
    [sym_subset2] = STATE(482),
    [sym_dollar] = STATE(482),
    [sym_slot] = STATE(482),
    [sym_namespace_get] = STATE(482),
    [sym_namespace_get_internal] = STATE(482),
    [sym_pipe] = STATE(482),
    [sym_unary] = STATE(482),
    [sym_binary] = STATE(482),
    [sym_na] = STATE(482),
    [sym__expression] = STATE(482),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(482),
    [sym_string] = STATE(482),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1271),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1271),
    [sym_next] = ACTIONS(1271),
    [sym_true] = ACTIONS(1271),
    [sym_false] = ACTIONS(1271),
    [sym_null] = ACTIONS(1271),
    [sym_inf] = ACTIONS(1271),
    [sym_nan] = ACTIONS(1271),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1269),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [195] = {
    [sym_function_definition] = STATE(479),
    [sym_lambda_function] = STATE(479),
    [sym_if] = STATE(479),
    [sym_while] = STATE(479),
    [sym_repeat] = STATE(479),
    [sym_for] = STATE(479),
    [sym_switch] = STATE(479),
    [sym_call] = STATE(479),
    [sym__assignment] = STATE(479),
    [sym_left_assignment] = STATE(479),
    [sym_left_assignment2] = STATE(479),
    [sym_equals_assignment] = STATE(479),
    [sym_super_assignment] = STATE(479),
    [sym_super_right_assignment] = STATE(479),
    [sym_right_assignment] = STATE(479),
    [sym_brace_list] = STATE(479),
    [sym_paren_list] = STATE(479),
    [sym_subset] = STATE(479),
    [sym_subset2] = STATE(479),
    [sym_dollar] = STATE(479),
    [sym_slot] = STATE(479),
    [sym_namespace_get] = STATE(479),
    [sym_namespace_get_internal] = STATE(479),
    [sym_pipe] = STATE(479),
    [sym_unary] = STATE(479),
    [sym_binary] = STATE(479),
    [sym_na] = STATE(479),
    [sym__expression] = STATE(479),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(479),
    [sym_string] = STATE(479),
    [anon_sym_SEMI] = ACTIONS(1273),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1275),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1275),
    [sym_next] = ACTIONS(1275),
    [sym_true] = ACTIONS(1275),
    [sym_false] = ACTIONS(1275),
    [sym_null] = ACTIONS(1275),
    [sym_inf] = ACTIONS(1275),
    [sym_nan] = ACTIONS(1275),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1273),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [196] = {
    [sym_function_definition] = STATE(477),
    [sym_lambda_function] = STATE(477),
    [sym_if] = STATE(477),
    [sym_while] = STATE(477),
    [sym_repeat] = STATE(477),
    [sym_for] = STATE(477),
    [sym_switch] = STATE(477),
    [sym_call] = STATE(477),
    [sym__assignment] = STATE(477),
    [sym_left_assignment] = STATE(477),
    [sym_left_assignment2] = STATE(477),
    [sym_equals_assignment] = STATE(477),
    [sym_super_assignment] = STATE(477),
    [sym_super_right_assignment] = STATE(477),
    [sym_right_assignment] = STATE(477),
    [sym_brace_list] = STATE(477),
    [sym_paren_list] = STATE(477),
    [sym_subset] = STATE(477),
    [sym_subset2] = STATE(477),
    [sym_dollar] = STATE(477),
    [sym_slot] = STATE(477),
    [sym_namespace_get] = STATE(477),
    [sym_namespace_get_internal] = STATE(477),
    [sym_pipe] = STATE(477),
    [sym_unary] = STATE(477),
    [sym_binary] = STATE(477),
    [sym_na] = STATE(477),
    [sym__expression] = STATE(477),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(477),
    [sym_string] = STATE(477),
    [anon_sym_SEMI] = ACTIONS(1277),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1279),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1279),
    [sym_next] = ACTIONS(1279),
    [sym_true] = ACTIONS(1279),
    [sym_false] = ACTIONS(1279),
    [sym_null] = ACTIONS(1279),
    [sym_inf] = ACTIONS(1279),
    [sym_nan] = ACTIONS(1279),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1277),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [197] = {
    [sym_function_definition] = STATE(463),
    [sym_lambda_function] = STATE(463),
    [sym_if] = STATE(463),
    [sym_while] = STATE(463),
    [sym_repeat] = STATE(463),
    [sym_for] = STATE(463),
    [sym_switch] = STATE(463),
    [sym_call] = STATE(463),
    [sym__assignment] = STATE(463),
    [sym_left_assignment] = STATE(463),
    [sym_left_assignment2] = STATE(463),
    [sym_equals_assignment] = STATE(463),
    [sym_super_assignment] = STATE(463),
    [sym_super_right_assignment] = STATE(463),
    [sym_right_assignment] = STATE(463),
    [sym_brace_list] = STATE(463),
    [sym_paren_list] = STATE(463),
    [sym_subset] = STATE(463),
    [sym_subset2] = STATE(463),
    [sym_dollar] = STATE(463),
    [sym_slot] = STATE(463),
    [sym_namespace_get] = STATE(463),
    [sym_namespace_get_internal] = STATE(463),
    [sym_pipe] = STATE(463),
    [sym_unary] = STATE(463),
    [sym_binary] = STATE(463),
    [sym_na] = STATE(463),
    [sym__expression] = STATE(463),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(463),
    [sym_string] = STATE(463),
    [anon_sym_SEMI] = ACTIONS(1281),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1283),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1283),
    [sym_next] = ACTIONS(1283),
    [sym_true] = ACTIONS(1283),
    [sym_false] = ACTIONS(1283),
    [sym_null] = ACTIONS(1283),
    [sym_inf] = ACTIONS(1283),
    [sym_nan] = ACTIONS(1283),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1281),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [198] = {
    [sym_function_definition] = STATE(462),
    [sym_lambda_function] = STATE(462),
    [sym_if] = STATE(462),
    [sym_while] = STATE(462),
    [sym_repeat] = STATE(462),
    [sym_for] = STATE(462),
    [sym_switch] = STATE(462),
    [sym_call] = STATE(462),
    [sym__assignment] = STATE(462),
    [sym_left_assignment] = STATE(462),
    [sym_left_assignment2] = STATE(462),
    [sym_equals_assignment] = STATE(462),
    [sym_super_assignment] = STATE(462),
    [sym_super_right_assignment] = STATE(462),
    [sym_right_assignment] = STATE(462),
    [sym_brace_list] = STATE(462),
    [sym_paren_list] = STATE(462),
    [sym_subset] = STATE(462),
    [sym_subset2] = STATE(462),
    [sym_dollar] = STATE(462),
    [sym_slot] = STATE(462),
    [sym_namespace_get] = STATE(462),
    [sym_namespace_get_internal] = STATE(462),
    [sym_pipe] = STATE(462),
    [sym_unary] = STATE(462),
    [sym_binary] = STATE(462),
    [sym_na] = STATE(462),
    [sym__expression] = STATE(462),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(462),
    [sym_string] = STATE(462),
    [anon_sym_SEMI] = ACTIONS(1285),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1287),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1287),
    [sym_next] = ACTIONS(1287),
    [sym_true] = ACTIONS(1287),
    [sym_false] = ACTIONS(1287),
    [sym_null] = ACTIONS(1287),
    [sym_inf] = ACTIONS(1287),
    [sym_nan] = ACTIONS(1287),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1285),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [199] = {
    [sym_function_definition] = STATE(461),
    [sym_lambda_function] = STATE(461),
    [sym_if] = STATE(461),
    [sym_while] = STATE(461),
    [sym_repeat] = STATE(461),
    [sym_for] = STATE(461),
    [sym_switch] = STATE(461),
    [sym_call] = STATE(461),
    [sym__assignment] = STATE(461),
    [sym_left_assignment] = STATE(461),
    [sym_left_assignment2] = STATE(461),
    [sym_equals_assignment] = STATE(461),
    [sym_super_assignment] = STATE(461),
    [sym_super_right_assignment] = STATE(461),
    [sym_right_assignment] = STATE(461),
    [sym_brace_list] = STATE(461),
    [sym_paren_list] = STATE(461),
    [sym_subset] = STATE(461),
    [sym_subset2] = STATE(461),
    [sym_dollar] = STATE(461),
    [sym_slot] = STATE(461),
    [sym_namespace_get] = STATE(461),
    [sym_namespace_get_internal] = STATE(461),
    [sym_pipe] = STATE(461),
    [sym_unary] = STATE(461),
    [sym_binary] = STATE(461),
    [sym_na] = STATE(461),
    [sym__expression] = STATE(461),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(461),
    [sym_string] = STATE(461),
    [anon_sym_SEMI] = ACTIONS(1289),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1291),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1291),
    [sym_next] = ACTIONS(1291),
    [sym_true] = ACTIONS(1291),
    [sym_false] = ACTIONS(1291),
    [sym_null] = ACTIONS(1291),
    [sym_inf] = ACTIONS(1291),
    [sym_nan] = ACTIONS(1291),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1289),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [200] = {
    [sym_function_definition] = STATE(460),
    [sym_lambda_function] = STATE(460),
    [sym_if] = STATE(460),
    [sym_while] = STATE(460),
    [sym_repeat] = STATE(460),
    [sym_for] = STATE(460),
    [sym_switch] = STATE(460),
    [sym_call] = STATE(460),
    [sym__assignment] = STATE(460),
    [sym_left_assignment] = STATE(460),
    [sym_left_assignment2] = STATE(460),
    [sym_equals_assignment] = STATE(460),
    [sym_super_assignment] = STATE(460),
    [sym_super_right_assignment] = STATE(460),
    [sym_right_assignment] = STATE(460),
    [sym_brace_list] = STATE(460),
    [sym_paren_list] = STATE(460),
    [sym_subset] = STATE(460),
    [sym_subset2] = STATE(460),
    [sym_dollar] = STATE(460),
    [sym_slot] = STATE(460),
    [sym_namespace_get] = STATE(460),
    [sym_namespace_get_internal] = STATE(460),
    [sym_pipe] = STATE(460),
    [sym_unary] = STATE(460),
    [sym_binary] = STATE(460),
    [sym_na] = STATE(460),
    [sym__expression] = STATE(460),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(460),
    [sym_string] = STATE(460),
    [anon_sym_SEMI] = ACTIONS(1293),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1295),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1295),
    [sym_next] = ACTIONS(1295),
    [sym_true] = ACTIONS(1295),
    [sym_false] = ACTIONS(1295),
    [sym_null] = ACTIONS(1295),
    [sym_inf] = ACTIONS(1295),
    [sym_nan] = ACTIONS(1295),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1293),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [201] = {
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(653),
    [anon_sym_BSLASH] = ACTIONS(651),
    [anon_sym_if] = ACTIONS(653),
    [anon_sym_LPAREN] = ACTIONS(651),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_while] = ACTIONS(653),
    [anon_sym_repeat] = ACTIONS(653),
    [anon_sym_for] = ACTIONS(653),
    [anon_sym_switch] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(651),
    [anon_sym_EQ] = ACTIONS(653),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_LT_DASH] = ACTIONS(651),
    [anon_sym_COLON_EQ] = ACTIONS(651),
    [anon_sym_LT_LT_DASH] = ACTIONS(651),
    [anon_sym_DASH_GT_GT] = ACTIONS(651),
    [anon_sym_DASH_GT] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_RBRACK] = ACTIONS(651),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(651),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [anon_sym_AT] = ACTIONS(651),
    [anon_sym_COLON_COLON] = ACTIONS(653),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(651),
    [sym_dots] = ACTIONS(653),
    [anon_sym_PIPE_GT] = ACTIONS(651),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_PLUS] = ACTIONS(651),
    [anon_sym_BANG] = ACTIONS(653),
    [anon_sym_TILDE] = ACTIONS(651),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_SLASH] = ACTIONS(651),
    [anon_sym_CARET] = ACTIONS(651),
    [anon_sym_LT] = ACTIONS(653),
    [anon_sym_GT] = ACTIONS(653),
    [anon_sym_LT_EQ] = ACTIONS(651),
    [anon_sym_GT_EQ] = ACTIONS(651),
    [anon_sym_EQ_EQ] = ACTIONS(651),
    [anon_sym_BANG_EQ] = ACTIONS(651),
    [anon_sym_PIPE_PIPE] = ACTIONS(651),
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(651),
    [anon_sym_AMP] = ACTIONS(653),
    [anon_sym_COLON] = ACTIONS(653),
    [sym_break] = ACTIONS(653),
    [sym_next] = ACTIONS(653),
    [sym_true] = ACTIONS(653),
    [sym_false] = ACTIONS(653),
    [sym_null] = ACTIONS(653),
    [sym_inf] = ACTIONS(653),
    [sym_nan] = ACTIONS(653),
    [anon_sym_NA] = ACTIONS(653),
    [anon_sym_NA_character_] = ACTIONS(653),
    [anon_sym_NA_complex_] = ACTIONS(653),
    [anon_sym_NA_integer_] = ACTIONS(653),
    [anon_sym_NA_real_] = ACTIONS(653),
    [aux_sym_identifier_token1] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(651),
    [sym_integer] = ACTIONS(651),
    [sym_float] = ACTIONS(653),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [anon_sym_SQUOTE] = ACTIONS(651),
    [anon_sym_PERCENT] = ACTIONS(651),
  },
  [202] = {
    [sym_function_definition] = STATE(459),
    [sym_lambda_function] = STATE(459),
    [sym_if] = STATE(459),
    [sym_while] = STATE(459),
    [sym_repeat] = STATE(459),
    [sym_for] = STATE(459),
    [sym_switch] = STATE(459),
    [sym_call] = STATE(459),
    [sym__assignment] = STATE(459),
    [sym_left_assignment] = STATE(459),
    [sym_left_assignment2] = STATE(459),
    [sym_equals_assignment] = STATE(459),
    [sym_super_assignment] = STATE(459),
    [sym_super_right_assignment] = STATE(459),
    [sym_right_assignment] = STATE(459),
    [sym_brace_list] = STATE(459),
    [sym_paren_list] = STATE(459),
    [sym_subset] = STATE(459),
    [sym_subset2] = STATE(459),
    [sym_dollar] = STATE(459),
    [sym_slot] = STATE(459),
    [sym_namespace_get] = STATE(459),
    [sym_namespace_get_internal] = STATE(459),
    [sym_pipe] = STATE(459),
    [sym_unary] = STATE(459),
    [sym_binary] = STATE(459),
    [sym_na] = STATE(459),
    [sym__expression] = STATE(459),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(459),
    [sym_string] = STATE(459),
    [anon_sym_SEMI] = ACTIONS(1297),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1299),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1299),
    [sym_next] = ACTIONS(1299),
    [sym_true] = ACTIONS(1299),
    [sym_false] = ACTIONS(1299),
    [sym_null] = ACTIONS(1299),
    [sym_inf] = ACTIONS(1299),
    [sym_nan] = ACTIONS(1299),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1297),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [203] = {
    [sym_function_definition] = STATE(458),
    [sym_lambda_function] = STATE(458),
    [sym_if] = STATE(458),
    [sym_while] = STATE(458),
    [sym_repeat] = STATE(458),
    [sym_for] = STATE(458),
    [sym_switch] = STATE(458),
    [sym_call] = STATE(458),
    [sym__assignment] = STATE(458),
    [sym_left_assignment] = STATE(458),
    [sym_left_assignment2] = STATE(458),
    [sym_equals_assignment] = STATE(458),
    [sym_super_assignment] = STATE(458),
    [sym_super_right_assignment] = STATE(458),
    [sym_right_assignment] = STATE(458),
    [sym_brace_list] = STATE(458),
    [sym_paren_list] = STATE(458),
    [sym_subset] = STATE(458),
    [sym_subset2] = STATE(458),
    [sym_dollar] = STATE(458),
    [sym_slot] = STATE(458),
    [sym_namespace_get] = STATE(458),
    [sym_namespace_get_internal] = STATE(458),
    [sym_pipe] = STATE(458),
    [sym_unary] = STATE(458),
    [sym_binary] = STATE(458),
    [sym_na] = STATE(458),
    [sym__expression] = STATE(458),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(458),
    [sym_string] = STATE(458),
    [anon_sym_SEMI] = ACTIONS(1301),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1303),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1303),
    [sym_next] = ACTIONS(1303),
    [sym_true] = ACTIONS(1303),
    [sym_false] = ACTIONS(1303),
    [sym_null] = ACTIONS(1303),
    [sym_inf] = ACTIONS(1303),
    [sym_nan] = ACTIONS(1303),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1301),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [204] = {
    [sym_function_definition] = STATE(457),
    [sym_lambda_function] = STATE(457),
    [sym_if] = STATE(457),
    [sym_while] = STATE(457),
    [sym_repeat] = STATE(457),
    [sym_for] = STATE(457),
    [sym_switch] = STATE(457),
    [sym_call] = STATE(457),
    [sym__assignment] = STATE(457),
    [sym_left_assignment] = STATE(457),
    [sym_left_assignment2] = STATE(457),
    [sym_equals_assignment] = STATE(457),
    [sym_super_assignment] = STATE(457),
    [sym_super_right_assignment] = STATE(457),
    [sym_right_assignment] = STATE(457),
    [sym_brace_list] = STATE(457),
    [sym_paren_list] = STATE(457),
    [sym_subset] = STATE(457),
    [sym_subset2] = STATE(457),
    [sym_dollar] = STATE(457),
    [sym_slot] = STATE(457),
    [sym_namespace_get] = STATE(457),
    [sym_namespace_get_internal] = STATE(457),
    [sym_pipe] = STATE(457),
    [sym_unary] = STATE(457),
    [sym_binary] = STATE(457),
    [sym_na] = STATE(457),
    [sym__expression] = STATE(457),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(457),
    [sym_string] = STATE(457),
    [anon_sym_SEMI] = ACTIONS(1305),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1307),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1307),
    [sym_next] = ACTIONS(1307),
    [sym_true] = ACTIONS(1307),
    [sym_false] = ACTIONS(1307),
    [sym_null] = ACTIONS(1307),
    [sym_inf] = ACTIONS(1307),
    [sym_nan] = ACTIONS(1307),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1305),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [205] = {
    [sym_function_definition] = STATE(665),
    [sym_lambda_function] = STATE(665),
    [sym_if] = STATE(665),
    [sym_while] = STATE(665),
    [sym_repeat] = STATE(665),
    [sym_for] = STATE(665),
    [sym_switch] = STATE(665),
    [sym_call] = STATE(665),
    [sym__assignment] = STATE(665),
    [sym_left_assignment] = STATE(665),
    [sym_left_assignment2] = STATE(665),
    [sym_equals_assignment] = STATE(665),
    [sym_super_assignment] = STATE(665),
    [sym_super_right_assignment] = STATE(665),
    [sym_right_assignment] = STATE(665),
    [sym_brace_list] = STATE(665),
    [sym_paren_list] = STATE(665),
    [sym_subset] = STATE(665),
    [sym_subset2] = STATE(665),
    [sym_dollar] = STATE(665),
    [sym_slot] = STATE(665),
    [sym_namespace_get] = STATE(665),
    [sym_namespace_get_internal] = STATE(665),
    [sym_pipe] = STATE(665),
    [sym_unary] = STATE(665),
    [sym_binary] = STATE(665),
    [sym_na] = STATE(665),
    [sym__expression] = STATE(665),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(665),
    [sym_string] = STATE(665),
    [anon_sym_SEMI] = ACTIONS(1309),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1311),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1311),
    [sym_next] = ACTIONS(1311),
    [sym_true] = ACTIONS(1311),
    [sym_false] = ACTIONS(1311),
    [sym_null] = ACTIONS(1311),
    [sym_inf] = ACTIONS(1311),
    [sym_nan] = ACTIONS(1311),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1309),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [206] = {
    [sym_function_definition] = STATE(450),
    [sym_lambda_function] = STATE(450),
    [sym_if] = STATE(450),
    [sym_while] = STATE(450),
    [sym_repeat] = STATE(450),
    [sym_for] = STATE(450),
    [sym_switch] = STATE(450),
    [sym_call] = STATE(450),
    [sym__assignment] = STATE(450),
    [sym_left_assignment] = STATE(450),
    [sym_left_assignment2] = STATE(450),
    [sym_equals_assignment] = STATE(450),
    [sym_super_assignment] = STATE(450),
    [sym_super_right_assignment] = STATE(450),
    [sym_right_assignment] = STATE(450),
    [sym_brace_list] = STATE(450),
    [sym_paren_list] = STATE(450),
    [sym_subset] = STATE(450),
    [sym_subset2] = STATE(450),
    [sym_dollar] = STATE(450),
    [sym_slot] = STATE(450),
    [sym_namespace_get] = STATE(450),
    [sym_namespace_get_internal] = STATE(450),
    [sym_pipe] = STATE(450),
    [sym_unary] = STATE(450),
    [sym_binary] = STATE(450),
    [sym_na] = STATE(450),
    [sym__expression] = STATE(450),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(450),
    [sym_string] = STATE(450),
    [anon_sym_SEMI] = ACTIONS(1313),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1315),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1315),
    [sym_next] = ACTIONS(1315),
    [sym_true] = ACTIONS(1315),
    [sym_false] = ACTIONS(1315),
    [sym_null] = ACTIONS(1315),
    [sym_inf] = ACTIONS(1315),
    [sym_nan] = ACTIONS(1315),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1313),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [207] = {
    [sym_function_definition] = STATE(449),
    [sym_lambda_function] = STATE(449),
    [sym_if] = STATE(449),
    [sym_while] = STATE(449),
    [sym_repeat] = STATE(449),
    [sym_for] = STATE(449),
    [sym_switch] = STATE(449),
    [sym_call] = STATE(449),
    [sym__assignment] = STATE(449),
    [sym_left_assignment] = STATE(449),
    [sym_left_assignment2] = STATE(449),
    [sym_equals_assignment] = STATE(449),
    [sym_super_assignment] = STATE(449),
    [sym_super_right_assignment] = STATE(449),
    [sym_right_assignment] = STATE(449),
    [sym_brace_list] = STATE(449),
    [sym_paren_list] = STATE(449),
    [sym_subset] = STATE(449),
    [sym_subset2] = STATE(449),
    [sym_dollar] = STATE(449),
    [sym_slot] = STATE(449),
    [sym_namespace_get] = STATE(449),
    [sym_namespace_get_internal] = STATE(449),
    [sym_pipe] = STATE(449),
    [sym_unary] = STATE(449),
    [sym_binary] = STATE(449),
    [sym_na] = STATE(449),
    [sym__expression] = STATE(449),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(449),
    [sym_string] = STATE(449),
    [anon_sym_SEMI] = ACTIONS(1317),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1319),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1319),
    [sym_next] = ACTIONS(1319),
    [sym_true] = ACTIONS(1319),
    [sym_false] = ACTIONS(1319),
    [sym_null] = ACTIONS(1319),
    [sym_inf] = ACTIONS(1319),
    [sym_nan] = ACTIONS(1319),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1317),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [208] = {
    [sym_function_definition] = STATE(448),
    [sym_lambda_function] = STATE(448),
    [sym_if] = STATE(448),
    [sym_while] = STATE(448),
    [sym_repeat] = STATE(448),
    [sym_for] = STATE(448),
    [sym_switch] = STATE(448),
    [sym_call] = STATE(448),
    [sym__assignment] = STATE(448),
    [sym_left_assignment] = STATE(448),
    [sym_left_assignment2] = STATE(448),
    [sym_equals_assignment] = STATE(448),
    [sym_super_assignment] = STATE(448),
    [sym_super_right_assignment] = STATE(448),
    [sym_right_assignment] = STATE(448),
    [sym_brace_list] = STATE(448),
    [sym_paren_list] = STATE(448),
    [sym_subset] = STATE(448),
    [sym_subset2] = STATE(448),
    [sym_dollar] = STATE(448),
    [sym_slot] = STATE(448),
    [sym_namespace_get] = STATE(448),
    [sym_namespace_get_internal] = STATE(448),
    [sym_pipe] = STATE(448),
    [sym_unary] = STATE(448),
    [sym_binary] = STATE(448),
    [sym_na] = STATE(448),
    [sym__expression] = STATE(448),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(448),
    [sym_string] = STATE(448),
    [anon_sym_SEMI] = ACTIONS(1321),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1323),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1323),
    [sym_next] = ACTIONS(1323),
    [sym_true] = ACTIONS(1323),
    [sym_false] = ACTIONS(1323),
    [sym_null] = ACTIONS(1323),
    [sym_inf] = ACTIONS(1323),
    [sym_nan] = ACTIONS(1323),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1321),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [209] = {
    [sym_function_definition] = STATE(446),
    [sym_lambda_function] = STATE(446),
    [sym_if] = STATE(446),
    [sym_while] = STATE(446),
    [sym_repeat] = STATE(446),
    [sym_for] = STATE(446),
    [sym_switch] = STATE(446),
    [sym_call] = STATE(446),
    [sym__assignment] = STATE(446),
    [sym_left_assignment] = STATE(446),
    [sym_left_assignment2] = STATE(446),
    [sym_equals_assignment] = STATE(446),
    [sym_super_assignment] = STATE(446),
    [sym_super_right_assignment] = STATE(446),
    [sym_right_assignment] = STATE(446),
    [sym_brace_list] = STATE(446),
    [sym_paren_list] = STATE(446),
    [sym_subset] = STATE(446),
    [sym_subset2] = STATE(446),
    [sym_dollar] = STATE(446),
    [sym_slot] = STATE(446),
    [sym_namespace_get] = STATE(446),
    [sym_namespace_get_internal] = STATE(446),
    [sym_pipe] = STATE(446),
    [sym_unary] = STATE(446),
    [sym_binary] = STATE(446),
    [sym_na] = STATE(446),
    [sym__expression] = STATE(446),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(446),
    [sym_string] = STATE(446),
    [anon_sym_SEMI] = ACTIONS(1325),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1327),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1327),
    [sym_next] = ACTIONS(1327),
    [sym_true] = ACTIONS(1327),
    [sym_false] = ACTIONS(1327),
    [sym_null] = ACTIONS(1327),
    [sym_inf] = ACTIONS(1327),
    [sym_nan] = ACTIONS(1327),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1325),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [210] = {
    [sym_function_definition] = STATE(447),
    [sym_lambda_function] = STATE(447),
    [sym_if] = STATE(447),
    [sym_while] = STATE(447),
    [sym_repeat] = STATE(447),
    [sym_for] = STATE(447),
    [sym_switch] = STATE(447),
    [sym_call] = STATE(447),
    [sym__assignment] = STATE(447),
    [sym_left_assignment] = STATE(447),
    [sym_left_assignment2] = STATE(447),
    [sym_equals_assignment] = STATE(447),
    [sym_super_assignment] = STATE(447),
    [sym_super_right_assignment] = STATE(447),
    [sym_right_assignment] = STATE(447),
    [sym_brace_list] = STATE(447),
    [sym_paren_list] = STATE(447),
    [sym_subset] = STATE(447),
    [sym_subset2] = STATE(447),
    [sym_dollar] = STATE(447),
    [sym_slot] = STATE(447),
    [sym_namespace_get] = STATE(447),
    [sym_namespace_get_internal] = STATE(447),
    [sym_pipe] = STATE(447),
    [sym_unary] = STATE(447),
    [sym_binary] = STATE(447),
    [sym_na] = STATE(447),
    [sym__expression] = STATE(447),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(447),
    [sym_string] = STATE(447),
    [anon_sym_SEMI] = ACTIONS(1329),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1331),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1331),
    [sym_next] = ACTIONS(1331),
    [sym_true] = ACTIONS(1331),
    [sym_false] = ACTIONS(1331),
    [sym_null] = ACTIONS(1331),
    [sym_inf] = ACTIONS(1331),
    [sym_nan] = ACTIONS(1331),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1329),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [211] = {
    [sym_function_definition] = STATE(432),
    [sym_lambda_function] = STATE(432),
    [sym_if] = STATE(432),
    [sym_while] = STATE(432),
    [sym_repeat] = STATE(432),
    [sym_for] = STATE(432),
    [sym_switch] = STATE(432),
    [sym_call] = STATE(432),
    [sym__assignment] = STATE(432),
    [sym_left_assignment] = STATE(432),
    [sym_left_assignment2] = STATE(432),
    [sym_equals_assignment] = STATE(432),
    [sym_super_assignment] = STATE(432),
    [sym_super_right_assignment] = STATE(432),
    [sym_right_assignment] = STATE(432),
    [sym_brace_list] = STATE(432),
    [sym_paren_list] = STATE(432),
    [sym_subset] = STATE(432),
    [sym_subset2] = STATE(432),
    [sym_dollar] = STATE(432),
    [sym_slot] = STATE(432),
    [sym_namespace_get] = STATE(432),
    [sym_namespace_get_internal] = STATE(432),
    [sym_pipe] = STATE(432),
    [sym_unary] = STATE(432),
    [sym_binary] = STATE(432),
    [sym_na] = STATE(432),
    [sym__expression] = STATE(432),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(432),
    [sym_string] = STATE(432),
    [anon_sym_SEMI] = ACTIONS(1333),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1335),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1335),
    [sym_next] = ACTIONS(1335),
    [sym_true] = ACTIONS(1335),
    [sym_false] = ACTIONS(1335),
    [sym_null] = ACTIONS(1335),
    [sym_inf] = ACTIONS(1335),
    [sym_nan] = ACTIONS(1335),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1333),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [212] = {
    [sym_function_definition] = STATE(438),
    [sym_lambda_function] = STATE(438),
    [sym_if] = STATE(438),
    [sym_while] = STATE(438),
    [sym_repeat] = STATE(438),
    [sym_for] = STATE(438),
    [sym_switch] = STATE(438),
    [sym_call] = STATE(438),
    [sym__assignment] = STATE(438),
    [sym_left_assignment] = STATE(438),
    [sym_left_assignment2] = STATE(438),
    [sym_equals_assignment] = STATE(438),
    [sym_super_assignment] = STATE(438),
    [sym_super_right_assignment] = STATE(438),
    [sym_right_assignment] = STATE(438),
    [sym_brace_list] = STATE(438),
    [sym_paren_list] = STATE(438),
    [sym_subset] = STATE(438),
    [sym_subset2] = STATE(438),
    [sym_dollar] = STATE(438),
    [sym_slot] = STATE(438),
    [sym_namespace_get] = STATE(438),
    [sym_namespace_get_internal] = STATE(438),
    [sym_pipe] = STATE(438),
    [sym_unary] = STATE(438),
    [sym_binary] = STATE(438),
    [sym_na] = STATE(438),
    [sym__expression] = STATE(438),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(438),
    [sym_string] = STATE(438),
    [anon_sym_SEMI] = ACTIONS(1337),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1339),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1339),
    [sym_next] = ACTIONS(1339),
    [sym_true] = ACTIONS(1339),
    [sym_false] = ACTIONS(1339),
    [sym_null] = ACTIONS(1339),
    [sym_inf] = ACTIONS(1339),
    [sym_nan] = ACTIONS(1339),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1337),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [213] = {
    [sym_function_definition] = STATE(439),
    [sym_lambda_function] = STATE(439),
    [sym_if] = STATE(439),
    [sym_while] = STATE(439),
    [sym_repeat] = STATE(439),
    [sym_for] = STATE(439),
    [sym_switch] = STATE(439),
    [sym_call] = STATE(439),
    [sym__assignment] = STATE(439),
    [sym_left_assignment] = STATE(439),
    [sym_left_assignment2] = STATE(439),
    [sym_equals_assignment] = STATE(439),
    [sym_super_assignment] = STATE(439),
    [sym_super_right_assignment] = STATE(439),
    [sym_right_assignment] = STATE(439),
    [sym_brace_list] = STATE(439),
    [sym_paren_list] = STATE(439),
    [sym_subset] = STATE(439),
    [sym_subset2] = STATE(439),
    [sym_dollar] = STATE(439),
    [sym_slot] = STATE(439),
    [sym_namespace_get] = STATE(439),
    [sym_namespace_get_internal] = STATE(439),
    [sym_pipe] = STATE(439),
    [sym_unary] = STATE(439),
    [sym_binary] = STATE(439),
    [sym_na] = STATE(439),
    [sym__expression] = STATE(439),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(439),
    [sym_string] = STATE(439),
    [anon_sym_SEMI] = ACTIONS(1341),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1343),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1343),
    [sym_next] = ACTIONS(1343),
    [sym_true] = ACTIONS(1343),
    [sym_false] = ACTIONS(1343),
    [sym_null] = ACTIONS(1343),
    [sym_inf] = ACTIONS(1343),
    [sym_nan] = ACTIONS(1343),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1341),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [214] = {
    [sym_function_definition] = STATE(440),
    [sym_lambda_function] = STATE(440),
    [sym_if] = STATE(440),
    [sym_while] = STATE(440),
    [sym_repeat] = STATE(440),
    [sym_for] = STATE(440),
    [sym_switch] = STATE(440),
    [sym_call] = STATE(440),
    [sym__assignment] = STATE(440),
    [sym_left_assignment] = STATE(440),
    [sym_left_assignment2] = STATE(440),
    [sym_equals_assignment] = STATE(440),
    [sym_super_assignment] = STATE(440),
    [sym_super_right_assignment] = STATE(440),
    [sym_right_assignment] = STATE(440),
    [sym_brace_list] = STATE(440),
    [sym_paren_list] = STATE(440),
    [sym_subset] = STATE(440),
    [sym_subset2] = STATE(440),
    [sym_dollar] = STATE(440),
    [sym_slot] = STATE(440),
    [sym_namespace_get] = STATE(440),
    [sym_namespace_get_internal] = STATE(440),
    [sym_pipe] = STATE(440),
    [sym_unary] = STATE(440),
    [sym_binary] = STATE(440),
    [sym_na] = STATE(440),
    [sym__expression] = STATE(440),
    [sym_identifier] = STATE(285),
    [sym_complex] = STATE(440),
    [sym_string] = STATE(440),
    [anon_sym_SEMI] = ACTIONS(1345),
    [anon_sym_function] = ACTIONS(657),
    [anon_sym_BSLASH] = ACTIONS(659),
    [anon_sym_if] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(663),
    [anon_sym_while] = ACTIONS(665),
    [anon_sym_repeat] = ACTIONS(667),
    [anon_sym_for] = ACTIONS(669),
    [anon_sym_switch] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [sym_dots] = ACTIONS(1347),
    [anon_sym_DASH] = ACTIONS(677),
    [anon_sym_PLUS] = ACTIONS(677),
    [anon_sym_BANG] = ACTIONS(679),
    [anon_sym_TILDE] = ACTIONS(681),
    [sym_break] = ACTIONS(1347),
    [sym_next] = ACTIONS(1347),
    [sym_true] = ACTIONS(1347),
    [sym_false] = ACTIONS(1347),
    [sym_null] = ACTIONS(1347),
    [sym_inf] = ACTIONS(1347),
    [sym_nan] = ACTIONS(1347),
    [anon_sym_NA] = ACTIONS(683),
    [anon_sym_NA_character_] = ACTIONS(683),
    [anon_sym_NA_complex_] = ACTIONS(683),
    [anon_sym_NA_integer_] = ACTIONS(683),
    [anon_sym_NA_real_] = ACTIONS(683),
    [aux_sym_identifier_token1] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(687),
    [sym_integer] = ACTIONS(1345),
    [sym_float] = ACTIONS(689),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(691),
    [anon_sym_SQUOTE] = ACTIONS(693),
  },
  [215] = {
    [sym_function_definition] = STATE(490),
    [sym_lambda_function] = STATE(490),
    [sym_if] = STATE(490),
    [sym_while] = STATE(490),
    [sym_repeat] = STATE(490),
    [sym_for] = STATE(490),
    [sym_switch] = STATE(490),
    [sym_call] = STATE(490),
    [sym__assignment] = STATE(490),
    [sym_left_assignment] = STATE(490),
    [sym_left_assignment2] = STATE(490),
    [sym_equals_assignment] = STATE(490),
    [sym_super_assignment] = STATE(490),
    [sym_super_right_assignment] = STATE(490),
    [sym_right_assignment] = STATE(490),
    [sym_brace_list] = STATE(490),
    [sym_paren_list] = STATE(490),
    [sym_subset] = STATE(490),
    [sym_subset2] = STATE(490),
    [sym_dollar] = STATE(490),
    [sym_slot] = STATE(490),
    [sym_namespace_get] = STATE(490),
    [sym_namespace_get_internal] = STATE(490),
    [sym_pipe] = STATE(490),
    [sym_unary] = STATE(490),
    [sym_binary] = STATE(490),
    [sym_na] = STATE(490),
    [sym__expression] = STATE(490),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(490),
    [sym_string] = STATE(490),
    [anon_sym_SEMI] = ACTIONS(1349),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1351),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1351),
    [sym_next] = ACTIONS(1351),
    [sym_true] = ACTIONS(1351),
    [sym_false] = ACTIONS(1351),
    [sym_null] = ACTIONS(1351),
    [sym_inf] = ACTIONS(1351),
    [sym_nan] = ACTIONS(1351),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1349),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [216] = {
    [sym_function_definition] = STATE(489),
    [sym_lambda_function] = STATE(489),
    [sym_if] = STATE(489),
    [sym_while] = STATE(489),
    [sym_repeat] = STATE(489),
    [sym_for] = STATE(489),
    [sym_switch] = STATE(489),
    [sym_call] = STATE(489),
    [sym__assignment] = STATE(489),
    [sym_left_assignment] = STATE(489),
    [sym_left_assignment2] = STATE(489),
    [sym_equals_assignment] = STATE(489),
    [sym_super_assignment] = STATE(489),
    [sym_super_right_assignment] = STATE(489),
    [sym_right_assignment] = STATE(489),
    [sym_brace_list] = STATE(489),
    [sym_paren_list] = STATE(489),
    [sym_subset] = STATE(489),
    [sym_subset2] = STATE(489),
    [sym_dollar] = STATE(489),
    [sym_slot] = STATE(489),
    [sym_namespace_get] = STATE(489),
    [sym_namespace_get_internal] = STATE(489),
    [sym_pipe] = STATE(489),
    [sym_unary] = STATE(489),
    [sym_binary] = STATE(489),
    [sym_na] = STATE(489),
    [sym__expression] = STATE(489),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(489),
    [sym_string] = STATE(489),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1355),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1355),
    [sym_next] = ACTIONS(1355),
    [sym_true] = ACTIONS(1355),
    [sym_false] = ACTIONS(1355),
    [sym_null] = ACTIONS(1355),
    [sym_inf] = ACTIONS(1355),
    [sym_nan] = ACTIONS(1355),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1353),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [217] = {
    [sym_function_definition] = STATE(488),
    [sym_lambda_function] = STATE(488),
    [sym_if] = STATE(488),
    [sym_while] = STATE(488),
    [sym_repeat] = STATE(488),
    [sym_for] = STATE(488),
    [sym_switch] = STATE(488),
    [sym_call] = STATE(488),
    [sym__assignment] = STATE(488),
    [sym_left_assignment] = STATE(488),
    [sym_left_assignment2] = STATE(488),
    [sym_equals_assignment] = STATE(488),
    [sym_super_assignment] = STATE(488),
    [sym_super_right_assignment] = STATE(488),
    [sym_right_assignment] = STATE(488),
    [sym_brace_list] = STATE(488),
    [sym_paren_list] = STATE(488),
    [sym_subset] = STATE(488),
    [sym_subset2] = STATE(488),
    [sym_dollar] = STATE(488),
    [sym_slot] = STATE(488),
    [sym_namespace_get] = STATE(488),
    [sym_namespace_get_internal] = STATE(488),
    [sym_pipe] = STATE(488),
    [sym_unary] = STATE(488),
    [sym_binary] = STATE(488),
    [sym_na] = STATE(488),
    [sym__expression] = STATE(488),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(488),
    [sym_string] = STATE(488),
    [anon_sym_SEMI] = ACTIONS(1357),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1359),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1359),
    [sym_next] = ACTIONS(1359),
    [sym_true] = ACTIONS(1359),
    [sym_false] = ACTIONS(1359),
    [sym_null] = ACTIONS(1359),
    [sym_inf] = ACTIONS(1359),
    [sym_nan] = ACTIONS(1359),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1357),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [218] = {
    [sym_function_definition] = STATE(486),
    [sym_lambda_function] = STATE(486),
    [sym_if] = STATE(486),
    [sym_while] = STATE(486),
    [sym_repeat] = STATE(486),
    [sym_for] = STATE(486),
    [sym_switch] = STATE(486),
    [sym_call] = STATE(486),
    [sym__assignment] = STATE(486),
    [sym_left_assignment] = STATE(486),
    [sym_left_assignment2] = STATE(486),
    [sym_equals_assignment] = STATE(486),
    [sym_super_assignment] = STATE(486),
    [sym_super_right_assignment] = STATE(486),
    [sym_right_assignment] = STATE(486),
    [sym_brace_list] = STATE(486),
    [sym_paren_list] = STATE(486),
    [sym_subset] = STATE(486),
    [sym_subset2] = STATE(486),
    [sym_dollar] = STATE(486),
    [sym_slot] = STATE(486),
    [sym_namespace_get] = STATE(486),
    [sym_namespace_get_internal] = STATE(486),
    [sym_pipe] = STATE(486),
    [sym_unary] = STATE(486),
    [sym_binary] = STATE(486),
    [sym_na] = STATE(486),
    [sym__expression] = STATE(486),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(486),
    [sym_string] = STATE(486),
    [anon_sym_SEMI] = ACTIONS(1361),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1363),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1363),
    [sym_next] = ACTIONS(1363),
    [sym_true] = ACTIONS(1363),
    [sym_false] = ACTIONS(1363),
    [sym_null] = ACTIONS(1363),
    [sym_inf] = ACTIONS(1363),
    [sym_nan] = ACTIONS(1363),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1361),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [219] = {
    [sym_function_definition] = STATE(553),
    [sym_lambda_function] = STATE(553),
    [sym_if] = STATE(553),
    [sym_while] = STATE(553),
    [sym_repeat] = STATE(553),
    [sym_for] = STATE(553),
    [sym_switch] = STATE(553),
    [sym_call] = STATE(553),
    [sym__assignment] = STATE(553),
    [sym_left_assignment] = STATE(553),
    [sym_left_assignment2] = STATE(553),
    [sym_equals_assignment] = STATE(553),
    [sym_super_assignment] = STATE(553),
    [sym_super_right_assignment] = STATE(553),
    [sym_right_assignment] = STATE(553),
    [sym_brace_list] = STATE(553),
    [sym_paren_list] = STATE(553),
    [sym_subset] = STATE(553),
    [sym_subset2] = STATE(553),
    [sym_dollar] = STATE(553),
    [sym_slot] = STATE(553),
    [sym_namespace_get] = STATE(553),
    [sym_namespace_get_internal] = STATE(553),
    [sym_pipe] = STATE(553),
    [sym_unary] = STATE(553),
    [sym_binary] = STATE(553),
    [sym_na] = STATE(553),
    [sym__expression] = STATE(553),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(553),
    [sym_string] = STATE(553),
    [anon_sym_SEMI] = ACTIONS(1365),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1367),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1367),
    [sym_next] = ACTIONS(1367),
    [sym_true] = ACTIONS(1367),
    [sym_false] = ACTIONS(1367),
    [sym_null] = ACTIONS(1367),
    [sym_inf] = ACTIONS(1367),
    [sym_nan] = ACTIONS(1367),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1365),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [220] = {
    [sym_function_definition] = STATE(927),
    [sym_lambda_function] = STATE(927),
    [sym_if] = STATE(927),
    [sym_while] = STATE(927),
    [sym_repeat] = STATE(927),
    [sym_for] = STATE(927),
    [sym_switch] = STATE(927),
    [sym_call] = STATE(745),
    [sym__assignment] = STATE(927),
    [sym_left_assignment] = STATE(927),
    [sym_left_assignment2] = STATE(927),
    [sym_equals_assignment] = STATE(927),
    [sym_super_assignment] = STATE(927),
    [sym_super_right_assignment] = STATE(927),
    [sym_right_assignment] = STATE(927),
    [sym_brace_list] = STATE(927),
    [sym_paren_list] = STATE(927),
    [sym_subset] = STATE(927),
    [sym_subset2] = STATE(927),
    [sym_dollar] = STATE(927),
    [sym_slot] = STATE(927),
    [sym_namespace_get] = STATE(927),
    [sym_namespace_get_internal] = STATE(927),
    [sym_pipe] = STATE(927),
    [sym_unary] = STATE(927),
    [sym_binary] = STATE(927),
    [sym_na] = STATE(927),
    [sym__expression] = STATE(927),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(927),
    [sym_string] = STATE(927),
    [anon_sym_SEMI] = ACTIONS(1369),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1371),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1371),
    [sym_next] = ACTIONS(1371),
    [sym_true] = ACTIONS(1371),
    [sym_false] = ACTIONS(1371),
    [sym_null] = ACTIONS(1371),
    [sym_inf] = ACTIONS(1371),
    [sym_nan] = ACTIONS(1371),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1369),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [221] = {
    [sym_function_definition] = STATE(664),
    [sym_lambda_function] = STATE(664),
    [sym_if] = STATE(664),
    [sym_while] = STATE(664),
    [sym_repeat] = STATE(664),
    [sym_for] = STATE(664),
    [sym_switch] = STATE(664),
    [sym_call] = STATE(664),
    [sym__assignment] = STATE(664),
    [sym_left_assignment] = STATE(664),
    [sym_left_assignment2] = STATE(664),
    [sym_equals_assignment] = STATE(664),
    [sym_super_assignment] = STATE(664),
    [sym_super_right_assignment] = STATE(664),
    [sym_right_assignment] = STATE(664),
    [sym_brace_list] = STATE(664),
    [sym_paren_list] = STATE(664),
    [sym_subset] = STATE(664),
    [sym_subset2] = STATE(664),
    [sym_dollar] = STATE(664),
    [sym_slot] = STATE(664),
    [sym_namespace_get] = STATE(664),
    [sym_namespace_get_internal] = STATE(664),
    [sym_pipe] = STATE(664),
    [sym_unary] = STATE(664),
    [sym_binary] = STATE(664),
    [sym_na] = STATE(664),
    [sym__expression] = STATE(664),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(664),
    [sym_string] = STATE(664),
    [anon_sym_SEMI] = ACTIONS(1373),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1375),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1375),
    [sym_next] = ACTIONS(1375),
    [sym_true] = ACTIONS(1375),
    [sym_false] = ACTIONS(1375),
    [sym_null] = ACTIONS(1375),
    [sym_inf] = ACTIONS(1375),
    [sym_nan] = ACTIONS(1375),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1373),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [222] = {
    [sym_function_definition] = STATE(662),
    [sym_lambda_function] = STATE(662),
    [sym_if] = STATE(662),
    [sym_while] = STATE(662),
    [sym_repeat] = STATE(662),
    [sym_for] = STATE(662),
    [sym_switch] = STATE(662),
    [sym_call] = STATE(662),
    [sym__assignment] = STATE(662),
    [sym_left_assignment] = STATE(662),
    [sym_left_assignment2] = STATE(662),
    [sym_equals_assignment] = STATE(662),
    [sym_super_assignment] = STATE(662),
    [sym_super_right_assignment] = STATE(662),
    [sym_right_assignment] = STATE(662),
    [sym_brace_list] = STATE(662),
    [sym_paren_list] = STATE(662),
    [sym_subset] = STATE(662),
    [sym_subset2] = STATE(662),
    [sym_dollar] = STATE(662),
    [sym_slot] = STATE(662),
    [sym_namespace_get] = STATE(662),
    [sym_namespace_get_internal] = STATE(662),
    [sym_pipe] = STATE(662),
    [sym_unary] = STATE(662),
    [sym_binary] = STATE(662),
    [sym_na] = STATE(662),
    [sym__expression] = STATE(662),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(662),
    [sym_string] = STATE(662),
    [anon_sym_SEMI] = ACTIONS(1377),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1379),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1379),
    [sym_next] = ACTIONS(1379),
    [sym_true] = ACTIONS(1379),
    [sym_false] = ACTIONS(1379),
    [sym_null] = ACTIONS(1379),
    [sym_inf] = ACTIONS(1379),
    [sym_nan] = ACTIONS(1379),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1377),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [223] = {
    [sym_function_definition] = STATE(661),
    [sym_lambda_function] = STATE(661),
    [sym_if] = STATE(661),
    [sym_while] = STATE(661),
    [sym_repeat] = STATE(661),
    [sym_for] = STATE(661),
    [sym_switch] = STATE(661),
    [sym_call] = STATE(661),
    [sym__assignment] = STATE(661),
    [sym_left_assignment] = STATE(661),
    [sym_left_assignment2] = STATE(661),
    [sym_equals_assignment] = STATE(661),
    [sym_super_assignment] = STATE(661),
    [sym_super_right_assignment] = STATE(661),
    [sym_right_assignment] = STATE(661),
    [sym_brace_list] = STATE(661),
    [sym_paren_list] = STATE(661),
    [sym_subset] = STATE(661),
    [sym_subset2] = STATE(661),
    [sym_dollar] = STATE(661),
    [sym_slot] = STATE(661),
    [sym_namespace_get] = STATE(661),
    [sym_namespace_get_internal] = STATE(661),
    [sym_pipe] = STATE(661),
    [sym_unary] = STATE(661),
    [sym_binary] = STATE(661),
    [sym_na] = STATE(661),
    [sym__expression] = STATE(661),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(661),
    [sym_string] = STATE(661),
    [anon_sym_SEMI] = ACTIONS(1381),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1383),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1383),
    [sym_next] = ACTIONS(1383),
    [sym_true] = ACTIONS(1383),
    [sym_false] = ACTIONS(1383),
    [sym_null] = ACTIONS(1383),
    [sym_inf] = ACTIONS(1383),
    [sym_nan] = ACTIONS(1383),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1381),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [224] = {
    [sym_function_definition] = STATE(660),
    [sym_lambda_function] = STATE(660),
    [sym_if] = STATE(660),
    [sym_while] = STATE(660),
    [sym_repeat] = STATE(660),
    [sym_for] = STATE(660),
    [sym_switch] = STATE(660),
    [sym_call] = STATE(660),
    [sym__assignment] = STATE(660),
    [sym_left_assignment] = STATE(660),
    [sym_left_assignment2] = STATE(660),
    [sym_equals_assignment] = STATE(660),
    [sym_super_assignment] = STATE(660),
    [sym_super_right_assignment] = STATE(660),
    [sym_right_assignment] = STATE(660),
    [sym_brace_list] = STATE(660),
    [sym_paren_list] = STATE(660),
    [sym_subset] = STATE(660),
    [sym_subset2] = STATE(660),
    [sym_dollar] = STATE(660),
    [sym_slot] = STATE(660),
    [sym_namespace_get] = STATE(660),
    [sym_namespace_get_internal] = STATE(660),
    [sym_pipe] = STATE(660),
    [sym_unary] = STATE(660),
    [sym_binary] = STATE(660),
    [sym_na] = STATE(660),
    [sym__expression] = STATE(660),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(660),
    [sym_string] = STATE(660),
    [anon_sym_SEMI] = ACTIONS(1385),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1387),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1387),
    [sym_next] = ACTIONS(1387),
    [sym_true] = ACTIONS(1387),
    [sym_false] = ACTIONS(1387),
    [sym_null] = ACTIONS(1387),
    [sym_inf] = ACTIONS(1387),
    [sym_nan] = ACTIONS(1387),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1385),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [225] = {
    [sym_function_definition] = STATE(572),
    [sym_lambda_function] = STATE(572),
    [sym_if] = STATE(572),
    [sym_while] = STATE(572),
    [sym_repeat] = STATE(572),
    [sym_for] = STATE(572),
    [sym_switch] = STATE(572),
    [sym_call] = STATE(572),
    [sym__assignment] = STATE(572),
    [sym_left_assignment] = STATE(572),
    [sym_left_assignment2] = STATE(572),
    [sym_equals_assignment] = STATE(572),
    [sym_super_assignment] = STATE(572),
    [sym_super_right_assignment] = STATE(572),
    [sym_right_assignment] = STATE(572),
    [sym_brace_list] = STATE(572),
    [sym_paren_list] = STATE(572),
    [sym_subset] = STATE(572),
    [sym_subset2] = STATE(572),
    [sym_dollar] = STATE(572),
    [sym_slot] = STATE(572),
    [sym_namespace_get] = STATE(572),
    [sym_namespace_get_internal] = STATE(572),
    [sym_pipe] = STATE(572),
    [sym_unary] = STATE(572),
    [sym_binary] = STATE(572),
    [sym_na] = STATE(572),
    [sym__expression] = STATE(572),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(572),
    [sym_string] = STATE(572),
    [anon_sym_SEMI] = ACTIONS(1389),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1391),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1391),
    [sym_next] = ACTIONS(1391),
    [sym_true] = ACTIONS(1391),
    [sym_false] = ACTIONS(1391),
    [sym_null] = ACTIONS(1391),
    [sym_inf] = ACTIONS(1391),
    [sym_nan] = ACTIONS(1391),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1389),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [226] = {
    [sym_function_definition] = STATE(480),
    [sym_lambda_function] = STATE(480),
    [sym_if] = STATE(480),
    [sym_while] = STATE(480),
    [sym_repeat] = STATE(480),
    [sym_for] = STATE(480),
    [sym_switch] = STATE(480),
    [sym_call] = STATE(480),
    [sym__assignment] = STATE(480),
    [sym_left_assignment] = STATE(480),
    [sym_left_assignment2] = STATE(480),
    [sym_equals_assignment] = STATE(480),
    [sym_super_assignment] = STATE(480),
    [sym_super_right_assignment] = STATE(480),
    [sym_right_assignment] = STATE(480),
    [sym_brace_list] = STATE(480),
    [sym_paren_list] = STATE(480),
    [sym_subset] = STATE(480),
    [sym_subset2] = STATE(480),
    [sym_dollar] = STATE(480),
    [sym_slot] = STATE(480),
    [sym_namespace_get] = STATE(480),
    [sym_namespace_get_internal] = STATE(480),
    [sym_pipe] = STATE(480),
    [sym_unary] = STATE(480),
    [sym_binary] = STATE(480),
    [sym_na] = STATE(480),
    [sym__expression] = STATE(480),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(480),
    [sym_string] = STATE(480),
    [anon_sym_SEMI] = ACTIONS(1393),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1395),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1395),
    [sym_next] = ACTIONS(1395),
    [sym_true] = ACTIONS(1395),
    [sym_false] = ACTIONS(1395),
    [sym_null] = ACTIONS(1395),
    [sym_inf] = ACTIONS(1395),
    [sym_nan] = ACTIONS(1395),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1393),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [227] = {
    [sym_function_definition] = STATE(481),
    [sym_lambda_function] = STATE(481),
    [sym_if] = STATE(481),
    [sym_while] = STATE(481),
    [sym_repeat] = STATE(481),
    [sym_for] = STATE(481),
    [sym_switch] = STATE(481),
    [sym_call] = STATE(481),
    [sym__assignment] = STATE(481),
    [sym_left_assignment] = STATE(481),
    [sym_left_assignment2] = STATE(481),
    [sym_equals_assignment] = STATE(481),
    [sym_super_assignment] = STATE(481),
    [sym_super_right_assignment] = STATE(481),
    [sym_right_assignment] = STATE(481),
    [sym_brace_list] = STATE(481),
    [sym_paren_list] = STATE(481),
    [sym_subset] = STATE(481),
    [sym_subset2] = STATE(481),
    [sym_dollar] = STATE(481),
    [sym_slot] = STATE(481),
    [sym_namespace_get] = STATE(481),
    [sym_namespace_get_internal] = STATE(481),
    [sym_pipe] = STATE(481),
    [sym_unary] = STATE(481),
    [sym_binary] = STATE(481),
    [sym_na] = STATE(481),
    [sym__expression] = STATE(481),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(481),
    [sym_string] = STATE(481),
    [anon_sym_SEMI] = ACTIONS(1397),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1399),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1399),
    [sym_next] = ACTIONS(1399),
    [sym_true] = ACTIONS(1399),
    [sym_false] = ACTIONS(1399),
    [sym_null] = ACTIONS(1399),
    [sym_inf] = ACTIONS(1399),
    [sym_nan] = ACTIONS(1399),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1397),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [228] = {
    [sym_function_definition] = STATE(485),
    [sym_lambda_function] = STATE(485),
    [sym_if] = STATE(485),
    [sym_while] = STATE(485),
    [sym_repeat] = STATE(485),
    [sym_for] = STATE(485),
    [sym_switch] = STATE(485),
    [sym_call] = STATE(485),
    [sym__assignment] = STATE(485),
    [sym_left_assignment] = STATE(485),
    [sym_left_assignment2] = STATE(485),
    [sym_equals_assignment] = STATE(485),
    [sym_super_assignment] = STATE(485),
    [sym_super_right_assignment] = STATE(485),
    [sym_right_assignment] = STATE(485),
    [sym_brace_list] = STATE(485),
    [sym_paren_list] = STATE(485),
    [sym_subset] = STATE(485),
    [sym_subset2] = STATE(485),
    [sym_dollar] = STATE(485),
    [sym_slot] = STATE(485),
    [sym_namespace_get] = STATE(485),
    [sym_namespace_get_internal] = STATE(485),
    [sym_pipe] = STATE(485),
    [sym_unary] = STATE(485),
    [sym_binary] = STATE(485),
    [sym_na] = STATE(485),
    [sym__expression] = STATE(485),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(485),
    [sym_string] = STATE(485),
    [anon_sym_SEMI] = ACTIONS(1401),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1403),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1403),
    [sym_next] = ACTIONS(1403),
    [sym_true] = ACTIONS(1403),
    [sym_false] = ACTIONS(1403),
    [sym_null] = ACTIONS(1403),
    [sym_inf] = ACTIONS(1403),
    [sym_nan] = ACTIONS(1403),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1401),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [229] = {
    [sym_function_definition] = STATE(492),
    [sym_lambda_function] = STATE(492),
    [sym_if] = STATE(492),
    [sym_while] = STATE(492),
    [sym_repeat] = STATE(492),
    [sym_for] = STATE(492),
    [sym_switch] = STATE(492),
    [sym_call] = STATE(492),
    [sym__assignment] = STATE(492),
    [sym_left_assignment] = STATE(492),
    [sym_left_assignment2] = STATE(492),
    [sym_equals_assignment] = STATE(492),
    [sym_super_assignment] = STATE(492),
    [sym_super_right_assignment] = STATE(492),
    [sym_right_assignment] = STATE(492),
    [sym_brace_list] = STATE(492),
    [sym_paren_list] = STATE(492),
    [sym_subset] = STATE(492),
    [sym_subset2] = STATE(492),
    [sym_dollar] = STATE(492),
    [sym_slot] = STATE(492),
    [sym_namespace_get] = STATE(492),
    [sym_namespace_get_internal] = STATE(492),
    [sym_pipe] = STATE(492),
    [sym_unary] = STATE(492),
    [sym_binary] = STATE(492),
    [sym_na] = STATE(492),
    [sym__expression] = STATE(492),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(492),
    [sym_string] = STATE(492),
    [anon_sym_SEMI] = ACTIONS(1405),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1407),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1407),
    [sym_next] = ACTIONS(1407),
    [sym_true] = ACTIONS(1407),
    [sym_false] = ACTIONS(1407),
    [sym_null] = ACTIONS(1407),
    [sym_inf] = ACTIONS(1407),
    [sym_nan] = ACTIONS(1407),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1405),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [230] = {
    [sym_function_definition] = STATE(493),
    [sym_lambda_function] = STATE(493),
    [sym_if] = STATE(493),
    [sym_while] = STATE(493),
    [sym_repeat] = STATE(493),
    [sym_for] = STATE(493),
    [sym_switch] = STATE(493),
    [sym_call] = STATE(493),
    [sym__assignment] = STATE(493),
    [sym_left_assignment] = STATE(493),
    [sym_left_assignment2] = STATE(493),
    [sym_equals_assignment] = STATE(493),
    [sym_super_assignment] = STATE(493),
    [sym_super_right_assignment] = STATE(493),
    [sym_right_assignment] = STATE(493),
    [sym_brace_list] = STATE(493),
    [sym_paren_list] = STATE(493),
    [sym_subset] = STATE(493),
    [sym_subset2] = STATE(493),
    [sym_dollar] = STATE(493),
    [sym_slot] = STATE(493),
    [sym_namespace_get] = STATE(493),
    [sym_namespace_get_internal] = STATE(493),
    [sym_pipe] = STATE(493),
    [sym_unary] = STATE(493),
    [sym_binary] = STATE(493),
    [sym_na] = STATE(493),
    [sym__expression] = STATE(493),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(493),
    [sym_string] = STATE(493),
    [anon_sym_SEMI] = ACTIONS(1409),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1411),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1411),
    [sym_next] = ACTIONS(1411),
    [sym_true] = ACTIONS(1411),
    [sym_false] = ACTIONS(1411),
    [sym_null] = ACTIONS(1411),
    [sym_inf] = ACTIONS(1411),
    [sym_nan] = ACTIONS(1411),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1409),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [231] = {
    [sym_function_definition] = STATE(515),
    [sym_lambda_function] = STATE(515),
    [sym_if] = STATE(515),
    [sym_while] = STATE(515),
    [sym_repeat] = STATE(515),
    [sym_for] = STATE(515),
    [sym_switch] = STATE(515),
    [sym_call] = STATE(515),
    [sym__assignment] = STATE(515),
    [sym_left_assignment] = STATE(515),
    [sym_left_assignment2] = STATE(515),
    [sym_equals_assignment] = STATE(515),
    [sym_super_assignment] = STATE(515),
    [sym_super_right_assignment] = STATE(515),
    [sym_right_assignment] = STATE(515),
    [sym_brace_list] = STATE(515),
    [sym_paren_list] = STATE(515),
    [sym_subset] = STATE(515),
    [sym_subset2] = STATE(515),
    [sym_dollar] = STATE(515),
    [sym_slot] = STATE(515),
    [sym_namespace_get] = STATE(515),
    [sym_namespace_get_internal] = STATE(515),
    [sym_pipe] = STATE(515),
    [sym_unary] = STATE(515),
    [sym_binary] = STATE(515),
    [sym_na] = STATE(515),
    [sym__expression] = STATE(515),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(515),
    [sym_string] = STATE(515),
    [anon_sym_SEMI] = ACTIONS(1413),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1415),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1415),
    [sym_next] = ACTIONS(1415),
    [sym_true] = ACTIONS(1415),
    [sym_false] = ACTIONS(1415),
    [sym_null] = ACTIONS(1415),
    [sym_inf] = ACTIONS(1415),
    [sym_nan] = ACTIONS(1415),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1413),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [232] = {
    [sym_function_definition] = STATE(494),
    [sym_lambda_function] = STATE(494),
    [sym_if] = STATE(494),
    [sym_while] = STATE(494),
    [sym_repeat] = STATE(494),
    [sym_for] = STATE(494),
    [sym_switch] = STATE(494),
    [sym_call] = STATE(494),
    [sym__assignment] = STATE(494),
    [sym_left_assignment] = STATE(494),
    [sym_left_assignment2] = STATE(494),
    [sym_equals_assignment] = STATE(494),
    [sym_super_assignment] = STATE(494),
    [sym_super_right_assignment] = STATE(494),
    [sym_right_assignment] = STATE(494),
    [sym_brace_list] = STATE(494),
    [sym_paren_list] = STATE(494),
    [sym_subset] = STATE(494),
    [sym_subset2] = STATE(494),
    [sym_dollar] = STATE(494),
    [sym_slot] = STATE(494),
    [sym_namespace_get] = STATE(494),
    [sym_namespace_get_internal] = STATE(494),
    [sym_pipe] = STATE(494),
    [sym_unary] = STATE(494),
    [sym_binary] = STATE(494),
    [sym_na] = STATE(494),
    [sym__expression] = STATE(494),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(494),
    [sym_string] = STATE(494),
    [anon_sym_SEMI] = ACTIONS(1417),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1419),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1419),
    [sym_next] = ACTIONS(1419),
    [sym_true] = ACTIONS(1419),
    [sym_false] = ACTIONS(1419),
    [sym_null] = ACTIONS(1419),
    [sym_inf] = ACTIONS(1419),
    [sym_nan] = ACTIONS(1419),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1417),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [233] = {
    [sym_function_definition] = STATE(495),
    [sym_lambda_function] = STATE(495),
    [sym_if] = STATE(495),
    [sym_while] = STATE(495),
    [sym_repeat] = STATE(495),
    [sym_for] = STATE(495),
    [sym_switch] = STATE(495),
    [sym_call] = STATE(495),
    [sym__assignment] = STATE(495),
    [sym_left_assignment] = STATE(495),
    [sym_left_assignment2] = STATE(495),
    [sym_equals_assignment] = STATE(495),
    [sym_super_assignment] = STATE(495),
    [sym_super_right_assignment] = STATE(495),
    [sym_right_assignment] = STATE(495),
    [sym_brace_list] = STATE(495),
    [sym_paren_list] = STATE(495),
    [sym_subset] = STATE(495),
    [sym_subset2] = STATE(495),
    [sym_dollar] = STATE(495),
    [sym_slot] = STATE(495),
    [sym_namespace_get] = STATE(495),
    [sym_namespace_get_internal] = STATE(495),
    [sym_pipe] = STATE(495),
    [sym_unary] = STATE(495),
    [sym_binary] = STATE(495),
    [sym_na] = STATE(495),
    [sym__expression] = STATE(495),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(495),
    [sym_string] = STATE(495),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1423),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1423),
    [sym_next] = ACTIONS(1423),
    [sym_true] = ACTIONS(1423),
    [sym_false] = ACTIONS(1423),
    [sym_null] = ACTIONS(1423),
    [sym_inf] = ACTIONS(1423),
    [sym_nan] = ACTIONS(1423),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1421),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [234] = {
    [sym_function_definition] = STATE(496),
    [sym_lambda_function] = STATE(496),
    [sym_if] = STATE(496),
    [sym_while] = STATE(496),
    [sym_repeat] = STATE(496),
    [sym_for] = STATE(496),
    [sym_switch] = STATE(496),
    [sym_call] = STATE(496),
    [sym__assignment] = STATE(496),
    [sym_left_assignment] = STATE(496),
    [sym_left_assignment2] = STATE(496),
    [sym_equals_assignment] = STATE(496),
    [sym_super_assignment] = STATE(496),
    [sym_super_right_assignment] = STATE(496),
    [sym_right_assignment] = STATE(496),
    [sym_brace_list] = STATE(496),
    [sym_paren_list] = STATE(496),
    [sym_subset] = STATE(496),
    [sym_subset2] = STATE(496),
    [sym_dollar] = STATE(496),
    [sym_slot] = STATE(496),
    [sym_namespace_get] = STATE(496),
    [sym_namespace_get_internal] = STATE(496),
    [sym_pipe] = STATE(496),
    [sym_unary] = STATE(496),
    [sym_binary] = STATE(496),
    [sym_na] = STATE(496),
    [sym__expression] = STATE(496),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(496),
    [sym_string] = STATE(496),
    [anon_sym_SEMI] = ACTIONS(1425),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1427),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1427),
    [sym_next] = ACTIONS(1427),
    [sym_true] = ACTIONS(1427),
    [sym_false] = ACTIONS(1427),
    [sym_null] = ACTIONS(1427),
    [sym_inf] = ACTIONS(1427),
    [sym_nan] = ACTIONS(1427),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1425),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [235] = {
    [sym_function_definition] = STATE(497),
    [sym_lambda_function] = STATE(497),
    [sym_if] = STATE(497),
    [sym_while] = STATE(497),
    [sym_repeat] = STATE(497),
    [sym_for] = STATE(497),
    [sym_switch] = STATE(497),
    [sym_call] = STATE(497),
    [sym__assignment] = STATE(497),
    [sym_left_assignment] = STATE(497),
    [sym_left_assignment2] = STATE(497),
    [sym_equals_assignment] = STATE(497),
    [sym_super_assignment] = STATE(497),
    [sym_super_right_assignment] = STATE(497),
    [sym_right_assignment] = STATE(497),
    [sym_brace_list] = STATE(497),
    [sym_paren_list] = STATE(497),
    [sym_subset] = STATE(497),
    [sym_subset2] = STATE(497),
    [sym_dollar] = STATE(497),
    [sym_slot] = STATE(497),
    [sym_namespace_get] = STATE(497),
    [sym_namespace_get_internal] = STATE(497),
    [sym_pipe] = STATE(497),
    [sym_unary] = STATE(497),
    [sym_binary] = STATE(497),
    [sym_na] = STATE(497),
    [sym__expression] = STATE(497),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(497),
    [sym_string] = STATE(497),
    [anon_sym_SEMI] = ACTIONS(1429),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1431),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1431),
    [sym_next] = ACTIONS(1431),
    [sym_true] = ACTIONS(1431),
    [sym_false] = ACTIONS(1431),
    [sym_null] = ACTIONS(1431),
    [sym_inf] = ACTIONS(1431),
    [sym_nan] = ACTIONS(1431),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1429),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [236] = {
    [sym_function_definition] = STATE(498),
    [sym_lambda_function] = STATE(498),
    [sym_if] = STATE(498),
    [sym_while] = STATE(498),
    [sym_repeat] = STATE(498),
    [sym_for] = STATE(498),
    [sym_switch] = STATE(498),
    [sym_call] = STATE(498),
    [sym__assignment] = STATE(498),
    [sym_left_assignment] = STATE(498),
    [sym_left_assignment2] = STATE(498),
    [sym_equals_assignment] = STATE(498),
    [sym_super_assignment] = STATE(498),
    [sym_super_right_assignment] = STATE(498),
    [sym_right_assignment] = STATE(498),
    [sym_brace_list] = STATE(498),
    [sym_paren_list] = STATE(498),
    [sym_subset] = STATE(498),
    [sym_subset2] = STATE(498),
    [sym_dollar] = STATE(498),
    [sym_slot] = STATE(498),
    [sym_namespace_get] = STATE(498),
    [sym_namespace_get_internal] = STATE(498),
    [sym_pipe] = STATE(498),
    [sym_unary] = STATE(498),
    [sym_binary] = STATE(498),
    [sym_na] = STATE(498),
    [sym__expression] = STATE(498),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(498),
    [sym_string] = STATE(498),
    [anon_sym_SEMI] = ACTIONS(1433),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1435),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1435),
    [sym_next] = ACTIONS(1435),
    [sym_true] = ACTIONS(1435),
    [sym_false] = ACTIONS(1435),
    [sym_null] = ACTIONS(1435),
    [sym_inf] = ACTIONS(1435),
    [sym_nan] = ACTIONS(1435),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1433),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [237] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1437),
    [anon_sym_function] = ACTIONS(1439),
    [anon_sym_BSLASH] = ACTIONS(1437),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1437),
    [anon_sym_else] = ACTIONS(1443),
    [anon_sym_while] = ACTIONS(1439),
    [anon_sym_repeat] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1439),
    [anon_sym_switch] = ACTIONS(1439),
    [anon_sym_COMMA] = ACTIONS(1437),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1437),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1437),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1439),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1439),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1439),
    [sym_next] = ACTIONS(1439),
    [sym_true] = ACTIONS(1439),
    [sym_false] = ACTIONS(1439),
    [sym_null] = ACTIONS(1439),
    [sym_inf] = ACTIONS(1439),
    [sym_nan] = ACTIONS(1439),
    [anon_sym_NA] = ACTIONS(1439),
    [anon_sym_NA_character_] = ACTIONS(1439),
    [anon_sym_NA_complex_] = ACTIONS(1439),
    [anon_sym_NA_integer_] = ACTIONS(1439),
    [anon_sym_NA_real_] = ACTIONS(1439),
    [aux_sym_identifier_token1] = ACTIONS(1439),
    [anon_sym_BQUOTE] = ACTIONS(1437),
    [sym_integer] = ACTIONS(1437),
    [sym_float] = ACTIONS(1439),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1437),
    [anon_sym_SQUOTE] = ACTIONS(1437),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [238] = {
    [sym_function_definition] = STATE(499),
    [sym_lambda_function] = STATE(499),
    [sym_if] = STATE(499),
    [sym_while] = STATE(499),
    [sym_repeat] = STATE(499),
    [sym_for] = STATE(499),
    [sym_switch] = STATE(499),
    [sym_call] = STATE(499),
    [sym__assignment] = STATE(499),
    [sym_left_assignment] = STATE(499),
    [sym_left_assignment2] = STATE(499),
    [sym_equals_assignment] = STATE(499),
    [sym_super_assignment] = STATE(499),
    [sym_super_right_assignment] = STATE(499),
    [sym_right_assignment] = STATE(499),
    [sym_brace_list] = STATE(499),
    [sym_paren_list] = STATE(499),
    [sym_subset] = STATE(499),
    [sym_subset2] = STATE(499),
    [sym_dollar] = STATE(499),
    [sym_slot] = STATE(499),
    [sym_namespace_get] = STATE(499),
    [sym_namespace_get_internal] = STATE(499),
    [sym_pipe] = STATE(499),
    [sym_unary] = STATE(499),
    [sym_binary] = STATE(499),
    [sym_na] = STATE(499),
    [sym__expression] = STATE(499),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(499),
    [sym_string] = STATE(499),
    [anon_sym_SEMI] = ACTIONS(1493),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1495),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1495),
    [sym_next] = ACTIONS(1495),
    [sym_true] = ACTIONS(1495),
    [sym_false] = ACTIONS(1495),
    [sym_null] = ACTIONS(1495),
    [sym_inf] = ACTIONS(1495),
    [sym_nan] = ACTIONS(1495),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1493),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [239] = {
    [sym_function_definition] = STATE(500),
    [sym_lambda_function] = STATE(500),
    [sym_if] = STATE(500),
    [sym_while] = STATE(500),
    [sym_repeat] = STATE(500),
    [sym_for] = STATE(500),
    [sym_switch] = STATE(500),
    [sym_call] = STATE(500),
    [sym__assignment] = STATE(500),
    [sym_left_assignment] = STATE(500),
    [sym_left_assignment2] = STATE(500),
    [sym_equals_assignment] = STATE(500),
    [sym_super_assignment] = STATE(500),
    [sym_super_right_assignment] = STATE(500),
    [sym_right_assignment] = STATE(500),
    [sym_brace_list] = STATE(500),
    [sym_paren_list] = STATE(500),
    [sym_subset] = STATE(500),
    [sym_subset2] = STATE(500),
    [sym_dollar] = STATE(500),
    [sym_slot] = STATE(500),
    [sym_namespace_get] = STATE(500),
    [sym_namespace_get_internal] = STATE(500),
    [sym_pipe] = STATE(500),
    [sym_unary] = STATE(500),
    [sym_binary] = STATE(500),
    [sym_na] = STATE(500),
    [sym__expression] = STATE(500),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(500),
    [sym_string] = STATE(500),
    [anon_sym_SEMI] = ACTIONS(1497),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1499),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1499),
    [sym_next] = ACTIONS(1499),
    [sym_true] = ACTIONS(1499),
    [sym_false] = ACTIONS(1499),
    [sym_null] = ACTIONS(1499),
    [sym_inf] = ACTIONS(1499),
    [sym_nan] = ACTIONS(1499),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1497),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [240] = {
    [sym_function_definition] = STATE(504),
    [sym_lambda_function] = STATE(504),
    [sym_if] = STATE(504),
    [sym_while] = STATE(504),
    [sym_repeat] = STATE(504),
    [sym_for] = STATE(504),
    [sym_switch] = STATE(504),
    [sym_call] = STATE(504),
    [sym__assignment] = STATE(504),
    [sym_left_assignment] = STATE(504),
    [sym_left_assignment2] = STATE(504),
    [sym_equals_assignment] = STATE(504),
    [sym_super_assignment] = STATE(504),
    [sym_super_right_assignment] = STATE(504),
    [sym_right_assignment] = STATE(504),
    [sym_brace_list] = STATE(504),
    [sym_paren_list] = STATE(504),
    [sym_subset] = STATE(504),
    [sym_subset2] = STATE(504),
    [sym_dollar] = STATE(504),
    [sym_slot] = STATE(504),
    [sym_namespace_get] = STATE(504),
    [sym_namespace_get_internal] = STATE(504),
    [sym_pipe] = STATE(504),
    [sym_unary] = STATE(504),
    [sym_binary] = STATE(504),
    [sym_na] = STATE(504),
    [sym__expression] = STATE(504),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(504),
    [sym_string] = STATE(504),
    [anon_sym_SEMI] = ACTIONS(1501),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1503),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1503),
    [sym_next] = ACTIONS(1503),
    [sym_true] = ACTIONS(1503),
    [sym_false] = ACTIONS(1503),
    [sym_null] = ACTIONS(1503),
    [sym_inf] = ACTIONS(1503),
    [sym_nan] = ACTIONS(1503),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1501),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [241] = {
    [sym_function_definition] = STATE(503),
    [sym_lambda_function] = STATE(503),
    [sym_if] = STATE(503),
    [sym_while] = STATE(503),
    [sym_repeat] = STATE(503),
    [sym_for] = STATE(503),
    [sym_switch] = STATE(503),
    [sym_call] = STATE(503),
    [sym__assignment] = STATE(503),
    [sym_left_assignment] = STATE(503),
    [sym_left_assignment2] = STATE(503),
    [sym_equals_assignment] = STATE(503),
    [sym_super_assignment] = STATE(503),
    [sym_super_right_assignment] = STATE(503),
    [sym_right_assignment] = STATE(503),
    [sym_brace_list] = STATE(503),
    [sym_paren_list] = STATE(503),
    [sym_subset] = STATE(503),
    [sym_subset2] = STATE(503),
    [sym_dollar] = STATE(503),
    [sym_slot] = STATE(503),
    [sym_namespace_get] = STATE(503),
    [sym_namespace_get_internal] = STATE(503),
    [sym_pipe] = STATE(503),
    [sym_unary] = STATE(503),
    [sym_binary] = STATE(503),
    [sym_na] = STATE(503),
    [sym__expression] = STATE(503),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(503),
    [sym_string] = STATE(503),
    [anon_sym_SEMI] = ACTIONS(1505),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1507),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1507),
    [sym_next] = ACTIONS(1507),
    [sym_true] = ACTIONS(1507),
    [sym_false] = ACTIONS(1507),
    [sym_null] = ACTIONS(1507),
    [sym_inf] = ACTIONS(1507),
    [sym_nan] = ACTIONS(1507),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1505),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [242] = {
    [sym_function_definition] = STATE(505),
    [sym_lambda_function] = STATE(505),
    [sym_if] = STATE(505),
    [sym_while] = STATE(505),
    [sym_repeat] = STATE(505),
    [sym_for] = STATE(505),
    [sym_switch] = STATE(505),
    [sym_call] = STATE(505),
    [sym__assignment] = STATE(505),
    [sym_left_assignment] = STATE(505),
    [sym_left_assignment2] = STATE(505),
    [sym_equals_assignment] = STATE(505),
    [sym_super_assignment] = STATE(505),
    [sym_super_right_assignment] = STATE(505),
    [sym_right_assignment] = STATE(505),
    [sym_brace_list] = STATE(505),
    [sym_paren_list] = STATE(505),
    [sym_subset] = STATE(505),
    [sym_subset2] = STATE(505),
    [sym_dollar] = STATE(505),
    [sym_slot] = STATE(505),
    [sym_namespace_get] = STATE(505),
    [sym_namespace_get_internal] = STATE(505),
    [sym_pipe] = STATE(505),
    [sym_unary] = STATE(505),
    [sym_binary] = STATE(505),
    [sym_na] = STATE(505),
    [sym__expression] = STATE(505),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(505),
    [sym_string] = STATE(505),
    [anon_sym_SEMI] = ACTIONS(1509),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1511),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1511),
    [sym_next] = ACTIONS(1511),
    [sym_true] = ACTIONS(1511),
    [sym_false] = ACTIONS(1511),
    [sym_null] = ACTIONS(1511),
    [sym_inf] = ACTIONS(1511),
    [sym_nan] = ACTIONS(1511),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1509),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [243] = {
    [sym_function_definition] = STATE(506),
    [sym_lambda_function] = STATE(506),
    [sym_if] = STATE(506),
    [sym_while] = STATE(506),
    [sym_repeat] = STATE(506),
    [sym_for] = STATE(506),
    [sym_switch] = STATE(506),
    [sym_call] = STATE(506),
    [sym__assignment] = STATE(506),
    [sym_left_assignment] = STATE(506),
    [sym_left_assignment2] = STATE(506),
    [sym_equals_assignment] = STATE(506),
    [sym_super_assignment] = STATE(506),
    [sym_super_right_assignment] = STATE(506),
    [sym_right_assignment] = STATE(506),
    [sym_brace_list] = STATE(506),
    [sym_paren_list] = STATE(506),
    [sym_subset] = STATE(506),
    [sym_subset2] = STATE(506),
    [sym_dollar] = STATE(506),
    [sym_slot] = STATE(506),
    [sym_namespace_get] = STATE(506),
    [sym_namespace_get_internal] = STATE(506),
    [sym_pipe] = STATE(506),
    [sym_unary] = STATE(506),
    [sym_binary] = STATE(506),
    [sym_na] = STATE(506),
    [sym__expression] = STATE(506),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(506),
    [sym_string] = STATE(506),
    [anon_sym_SEMI] = ACTIONS(1513),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1515),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1515),
    [sym_next] = ACTIONS(1515),
    [sym_true] = ACTIONS(1515),
    [sym_false] = ACTIONS(1515),
    [sym_null] = ACTIONS(1515),
    [sym_inf] = ACTIONS(1515),
    [sym_nan] = ACTIONS(1515),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1513),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [244] = {
    [sym_function_definition] = STATE(507),
    [sym_lambda_function] = STATE(507),
    [sym_if] = STATE(507),
    [sym_while] = STATE(507),
    [sym_repeat] = STATE(507),
    [sym_for] = STATE(507),
    [sym_switch] = STATE(507),
    [sym_call] = STATE(507),
    [sym__assignment] = STATE(507),
    [sym_left_assignment] = STATE(507),
    [sym_left_assignment2] = STATE(507),
    [sym_equals_assignment] = STATE(507),
    [sym_super_assignment] = STATE(507),
    [sym_super_right_assignment] = STATE(507),
    [sym_right_assignment] = STATE(507),
    [sym_brace_list] = STATE(507),
    [sym_paren_list] = STATE(507),
    [sym_subset] = STATE(507),
    [sym_subset2] = STATE(507),
    [sym_dollar] = STATE(507),
    [sym_slot] = STATE(507),
    [sym_namespace_get] = STATE(507),
    [sym_namespace_get_internal] = STATE(507),
    [sym_pipe] = STATE(507),
    [sym_unary] = STATE(507),
    [sym_binary] = STATE(507),
    [sym_na] = STATE(507),
    [sym__expression] = STATE(507),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(507),
    [sym_string] = STATE(507),
    [anon_sym_SEMI] = ACTIONS(1517),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1519),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1519),
    [sym_next] = ACTIONS(1519),
    [sym_true] = ACTIONS(1519),
    [sym_false] = ACTIONS(1519),
    [sym_null] = ACTIONS(1519),
    [sym_inf] = ACTIONS(1519),
    [sym_nan] = ACTIONS(1519),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1517),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [245] = {
    [sym_function_definition] = STATE(674),
    [sym_lambda_function] = STATE(674),
    [sym_if] = STATE(674),
    [sym_while] = STATE(674),
    [sym_repeat] = STATE(674),
    [sym_for] = STATE(674),
    [sym_switch] = STATE(674),
    [sym_call] = STATE(674),
    [sym__assignment] = STATE(674),
    [sym_left_assignment] = STATE(674),
    [sym_left_assignment2] = STATE(674),
    [sym_equals_assignment] = STATE(674),
    [sym_super_assignment] = STATE(674),
    [sym_super_right_assignment] = STATE(674),
    [sym_right_assignment] = STATE(674),
    [sym_brace_list] = STATE(674),
    [sym_paren_list] = STATE(674),
    [sym_subset] = STATE(674),
    [sym_subset2] = STATE(674),
    [sym_dollar] = STATE(674),
    [sym_slot] = STATE(674),
    [sym_namespace_get] = STATE(674),
    [sym_namespace_get_internal] = STATE(674),
    [sym_pipe] = STATE(674),
    [sym_unary] = STATE(674),
    [sym_binary] = STATE(674),
    [sym_na] = STATE(674),
    [sym__expression] = STATE(674),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(674),
    [sym_string] = STATE(674),
    [anon_sym_SEMI] = ACTIONS(1521),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1523),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1523),
    [sym_next] = ACTIONS(1523),
    [sym_true] = ACTIONS(1523),
    [sym_false] = ACTIONS(1523),
    [sym_null] = ACTIONS(1523),
    [sym_inf] = ACTIONS(1523),
    [sym_nan] = ACTIONS(1523),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1521),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [246] = {
    [sym_function_definition] = STATE(703),
    [sym_lambda_function] = STATE(703),
    [sym_if] = STATE(703),
    [sym_while] = STATE(703),
    [sym_repeat] = STATE(703),
    [sym_for] = STATE(703),
    [sym_switch] = STATE(703),
    [sym_call] = STATE(703),
    [sym__assignment] = STATE(703),
    [sym_left_assignment] = STATE(703),
    [sym_left_assignment2] = STATE(703),
    [sym_equals_assignment] = STATE(703),
    [sym_super_assignment] = STATE(703),
    [sym_super_right_assignment] = STATE(703),
    [sym_right_assignment] = STATE(703),
    [sym_brace_list] = STATE(703),
    [sym_paren_list] = STATE(703),
    [sym_subset] = STATE(703),
    [sym_subset2] = STATE(703),
    [sym_dollar] = STATE(703),
    [sym_slot] = STATE(703),
    [sym_namespace_get] = STATE(703),
    [sym_namespace_get_internal] = STATE(703),
    [sym_pipe] = STATE(703),
    [sym_unary] = STATE(703),
    [sym_binary] = STATE(703),
    [sym_na] = STATE(703),
    [sym__expression] = STATE(703),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(703),
    [sym_string] = STATE(703),
    [anon_sym_SEMI] = ACTIONS(1525),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1527),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1527),
    [sym_next] = ACTIONS(1527),
    [sym_true] = ACTIONS(1527),
    [sym_false] = ACTIONS(1527),
    [sym_null] = ACTIONS(1527),
    [sym_inf] = ACTIONS(1527),
    [sym_nan] = ACTIONS(1527),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1525),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [247] = {
    [sym_function_definition] = STATE(622),
    [sym_lambda_function] = STATE(622),
    [sym_if] = STATE(622),
    [sym_while] = STATE(622),
    [sym_repeat] = STATE(622),
    [sym_for] = STATE(622),
    [sym_switch] = STATE(622),
    [sym_call] = STATE(622),
    [sym__assignment] = STATE(622),
    [sym_left_assignment] = STATE(622),
    [sym_left_assignment2] = STATE(622),
    [sym_equals_assignment] = STATE(622),
    [sym_super_assignment] = STATE(622),
    [sym_super_right_assignment] = STATE(622),
    [sym_right_assignment] = STATE(622),
    [sym_brace_list] = STATE(622),
    [sym_paren_list] = STATE(622),
    [sym_subset] = STATE(622),
    [sym_subset2] = STATE(622),
    [sym_dollar] = STATE(622),
    [sym_slot] = STATE(622),
    [sym_namespace_get] = STATE(622),
    [sym_namespace_get_internal] = STATE(622),
    [sym_pipe] = STATE(622),
    [sym_unary] = STATE(622),
    [sym_binary] = STATE(622),
    [sym_na] = STATE(622),
    [sym__expression] = STATE(622),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(622),
    [sym_string] = STATE(622),
    [anon_sym_SEMI] = ACTIONS(1529),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1531),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1531),
    [sym_next] = ACTIONS(1531),
    [sym_true] = ACTIONS(1531),
    [sym_false] = ACTIONS(1531),
    [sym_null] = ACTIONS(1531),
    [sym_inf] = ACTIONS(1531),
    [sym_nan] = ACTIONS(1531),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1529),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [248] = {
    [sym_function_definition] = STATE(678),
    [sym_lambda_function] = STATE(678),
    [sym_if] = STATE(678),
    [sym_while] = STATE(678),
    [sym_repeat] = STATE(678),
    [sym_for] = STATE(678),
    [sym_switch] = STATE(678),
    [sym_call] = STATE(678),
    [sym__assignment] = STATE(678),
    [sym_left_assignment] = STATE(678),
    [sym_left_assignment2] = STATE(678),
    [sym_equals_assignment] = STATE(678),
    [sym_super_assignment] = STATE(678),
    [sym_super_right_assignment] = STATE(678),
    [sym_right_assignment] = STATE(678),
    [sym_brace_list] = STATE(678),
    [sym_paren_list] = STATE(678),
    [sym_subset] = STATE(678),
    [sym_subset2] = STATE(678),
    [sym_dollar] = STATE(678),
    [sym_slot] = STATE(678),
    [sym_namespace_get] = STATE(678),
    [sym_namespace_get_internal] = STATE(678),
    [sym_pipe] = STATE(678),
    [sym_unary] = STATE(678),
    [sym_binary] = STATE(678),
    [sym_na] = STATE(678),
    [sym__expression] = STATE(678),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(678),
    [sym_string] = STATE(678),
    [anon_sym_SEMI] = ACTIONS(1533),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1535),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1535),
    [sym_next] = ACTIONS(1535),
    [sym_true] = ACTIONS(1535),
    [sym_false] = ACTIONS(1535),
    [sym_null] = ACTIONS(1535),
    [sym_inf] = ACTIONS(1535),
    [sym_nan] = ACTIONS(1535),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1533),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [249] = {
    [sym_function_definition] = STATE(511),
    [sym_lambda_function] = STATE(511),
    [sym_if] = STATE(511),
    [sym_while] = STATE(511),
    [sym_repeat] = STATE(511),
    [sym_for] = STATE(511),
    [sym_switch] = STATE(511),
    [sym_call] = STATE(511),
    [sym__assignment] = STATE(511),
    [sym_left_assignment] = STATE(511),
    [sym_left_assignment2] = STATE(511),
    [sym_equals_assignment] = STATE(511),
    [sym_super_assignment] = STATE(511),
    [sym_super_right_assignment] = STATE(511),
    [sym_right_assignment] = STATE(511),
    [sym_brace_list] = STATE(511),
    [sym_paren_list] = STATE(511),
    [sym_subset] = STATE(511),
    [sym_subset2] = STATE(511),
    [sym_dollar] = STATE(511),
    [sym_slot] = STATE(511),
    [sym_namespace_get] = STATE(511),
    [sym_namespace_get_internal] = STATE(511),
    [sym_pipe] = STATE(511),
    [sym_unary] = STATE(511),
    [sym_binary] = STATE(511),
    [sym_na] = STATE(511),
    [sym__expression] = STATE(511),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(511),
    [sym_string] = STATE(511),
    [anon_sym_SEMI] = ACTIONS(1537),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1539),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1539),
    [sym_next] = ACTIONS(1539),
    [sym_true] = ACTIONS(1539),
    [sym_false] = ACTIONS(1539),
    [sym_null] = ACTIONS(1539),
    [sym_inf] = ACTIONS(1539),
    [sym_nan] = ACTIONS(1539),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1537),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [250] = {
    [sym_function_definition] = STATE(512),
    [sym_lambda_function] = STATE(512),
    [sym_if] = STATE(512),
    [sym_while] = STATE(512),
    [sym_repeat] = STATE(512),
    [sym_for] = STATE(512),
    [sym_switch] = STATE(512),
    [sym_call] = STATE(512),
    [sym__assignment] = STATE(512),
    [sym_left_assignment] = STATE(512),
    [sym_left_assignment2] = STATE(512),
    [sym_equals_assignment] = STATE(512),
    [sym_super_assignment] = STATE(512),
    [sym_super_right_assignment] = STATE(512),
    [sym_right_assignment] = STATE(512),
    [sym_brace_list] = STATE(512),
    [sym_paren_list] = STATE(512),
    [sym_subset] = STATE(512),
    [sym_subset2] = STATE(512),
    [sym_dollar] = STATE(512),
    [sym_slot] = STATE(512),
    [sym_namespace_get] = STATE(512),
    [sym_namespace_get_internal] = STATE(512),
    [sym_pipe] = STATE(512),
    [sym_unary] = STATE(512),
    [sym_binary] = STATE(512),
    [sym_na] = STATE(512),
    [sym__expression] = STATE(512),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(512),
    [sym_string] = STATE(512),
    [anon_sym_SEMI] = ACTIONS(1541),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1543),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1543),
    [sym_next] = ACTIONS(1543),
    [sym_true] = ACTIONS(1543),
    [sym_false] = ACTIONS(1543),
    [sym_null] = ACTIONS(1543),
    [sym_inf] = ACTIONS(1543),
    [sym_nan] = ACTIONS(1543),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1541),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [251] = {
    [sym_function_definition] = STATE(513),
    [sym_lambda_function] = STATE(513),
    [sym_if] = STATE(513),
    [sym_while] = STATE(513),
    [sym_repeat] = STATE(513),
    [sym_for] = STATE(513),
    [sym_switch] = STATE(513),
    [sym_call] = STATE(513),
    [sym__assignment] = STATE(513),
    [sym_left_assignment] = STATE(513),
    [sym_left_assignment2] = STATE(513),
    [sym_equals_assignment] = STATE(513),
    [sym_super_assignment] = STATE(513),
    [sym_super_right_assignment] = STATE(513),
    [sym_right_assignment] = STATE(513),
    [sym_brace_list] = STATE(513),
    [sym_paren_list] = STATE(513),
    [sym_subset] = STATE(513),
    [sym_subset2] = STATE(513),
    [sym_dollar] = STATE(513),
    [sym_slot] = STATE(513),
    [sym_namespace_get] = STATE(513),
    [sym_namespace_get_internal] = STATE(513),
    [sym_pipe] = STATE(513),
    [sym_unary] = STATE(513),
    [sym_binary] = STATE(513),
    [sym_na] = STATE(513),
    [sym__expression] = STATE(513),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(513),
    [sym_string] = STATE(513),
    [anon_sym_SEMI] = ACTIONS(1545),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1547),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1547),
    [sym_next] = ACTIONS(1547),
    [sym_true] = ACTIONS(1547),
    [sym_false] = ACTIONS(1547),
    [sym_null] = ACTIONS(1547),
    [sym_inf] = ACTIONS(1547),
    [sym_nan] = ACTIONS(1547),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1545),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [252] = {
    [sym_function_definition] = STATE(522),
    [sym_lambda_function] = STATE(522),
    [sym_if] = STATE(522),
    [sym_while] = STATE(522),
    [sym_repeat] = STATE(522),
    [sym_for] = STATE(522),
    [sym_switch] = STATE(522),
    [sym_call] = STATE(522),
    [sym__assignment] = STATE(522),
    [sym_left_assignment] = STATE(522),
    [sym_left_assignment2] = STATE(522),
    [sym_equals_assignment] = STATE(522),
    [sym_super_assignment] = STATE(522),
    [sym_super_right_assignment] = STATE(522),
    [sym_right_assignment] = STATE(522),
    [sym_brace_list] = STATE(522),
    [sym_paren_list] = STATE(522),
    [sym_subset] = STATE(522),
    [sym_subset2] = STATE(522),
    [sym_dollar] = STATE(522),
    [sym_slot] = STATE(522),
    [sym_namespace_get] = STATE(522),
    [sym_namespace_get_internal] = STATE(522),
    [sym_pipe] = STATE(522),
    [sym_unary] = STATE(522),
    [sym_binary] = STATE(522),
    [sym_na] = STATE(522),
    [sym__expression] = STATE(522),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(522),
    [sym_string] = STATE(522),
    [anon_sym_SEMI] = ACTIONS(1549),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1551),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1551),
    [sym_next] = ACTIONS(1551),
    [sym_true] = ACTIONS(1551),
    [sym_false] = ACTIONS(1551),
    [sym_null] = ACTIONS(1551),
    [sym_inf] = ACTIONS(1551),
    [sym_nan] = ACTIONS(1551),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1549),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [253] = {
    [sym_function_definition] = STATE(675),
    [sym_lambda_function] = STATE(675),
    [sym_if] = STATE(675),
    [sym_while] = STATE(675),
    [sym_repeat] = STATE(675),
    [sym_for] = STATE(675),
    [sym_switch] = STATE(675),
    [sym_call] = STATE(675),
    [sym__assignment] = STATE(675),
    [sym_left_assignment] = STATE(675),
    [sym_left_assignment2] = STATE(675),
    [sym_equals_assignment] = STATE(675),
    [sym_super_assignment] = STATE(675),
    [sym_super_right_assignment] = STATE(675),
    [sym_right_assignment] = STATE(675),
    [sym_brace_list] = STATE(675),
    [sym_paren_list] = STATE(675),
    [sym_subset] = STATE(675),
    [sym_subset2] = STATE(675),
    [sym_dollar] = STATE(675),
    [sym_slot] = STATE(675),
    [sym_namespace_get] = STATE(675),
    [sym_namespace_get_internal] = STATE(675),
    [sym_pipe] = STATE(675),
    [sym_unary] = STATE(675),
    [sym_binary] = STATE(675),
    [sym_na] = STATE(675),
    [sym__expression] = STATE(675),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(675),
    [sym_string] = STATE(675),
    [anon_sym_SEMI] = ACTIONS(1553),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1555),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1555),
    [sym_next] = ACTIONS(1555),
    [sym_true] = ACTIONS(1555),
    [sym_false] = ACTIONS(1555),
    [sym_null] = ACTIONS(1555),
    [sym_inf] = ACTIONS(1555),
    [sym_nan] = ACTIONS(1555),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1553),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [254] = {
    [sym_function_definition] = STATE(696),
    [sym_lambda_function] = STATE(696),
    [sym_if] = STATE(696),
    [sym_while] = STATE(696),
    [sym_repeat] = STATE(696),
    [sym_for] = STATE(696),
    [sym_switch] = STATE(696),
    [sym_call] = STATE(696),
    [sym__assignment] = STATE(696),
    [sym_left_assignment] = STATE(696),
    [sym_left_assignment2] = STATE(696),
    [sym_equals_assignment] = STATE(696),
    [sym_super_assignment] = STATE(696),
    [sym_super_right_assignment] = STATE(696),
    [sym_right_assignment] = STATE(696),
    [sym_brace_list] = STATE(696),
    [sym_paren_list] = STATE(696),
    [sym_subset] = STATE(696),
    [sym_subset2] = STATE(696),
    [sym_dollar] = STATE(696),
    [sym_slot] = STATE(696),
    [sym_namespace_get] = STATE(696),
    [sym_namespace_get_internal] = STATE(696),
    [sym_pipe] = STATE(696),
    [sym_unary] = STATE(696),
    [sym_binary] = STATE(696),
    [sym_na] = STATE(696),
    [sym__expression] = STATE(696),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(696),
    [sym_string] = STATE(696),
    [anon_sym_SEMI] = ACTIONS(1557),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1559),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1559),
    [sym_next] = ACTIONS(1559),
    [sym_true] = ACTIONS(1559),
    [sym_false] = ACTIONS(1559),
    [sym_null] = ACTIONS(1559),
    [sym_inf] = ACTIONS(1559),
    [sym_nan] = ACTIONS(1559),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1557),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [255] = {
    [sym_function_definition] = STATE(523),
    [sym_lambda_function] = STATE(523),
    [sym_if] = STATE(523),
    [sym_while] = STATE(523),
    [sym_repeat] = STATE(523),
    [sym_for] = STATE(523),
    [sym_switch] = STATE(523),
    [sym_call] = STATE(523),
    [sym__assignment] = STATE(523),
    [sym_left_assignment] = STATE(523),
    [sym_left_assignment2] = STATE(523),
    [sym_equals_assignment] = STATE(523),
    [sym_super_assignment] = STATE(523),
    [sym_super_right_assignment] = STATE(523),
    [sym_right_assignment] = STATE(523),
    [sym_brace_list] = STATE(523),
    [sym_paren_list] = STATE(523),
    [sym_subset] = STATE(523),
    [sym_subset2] = STATE(523),
    [sym_dollar] = STATE(523),
    [sym_slot] = STATE(523),
    [sym_namespace_get] = STATE(523),
    [sym_namespace_get_internal] = STATE(523),
    [sym_pipe] = STATE(523),
    [sym_unary] = STATE(523),
    [sym_binary] = STATE(523),
    [sym_na] = STATE(523),
    [sym__expression] = STATE(523),
    [sym_identifier] = STATE(399),
    [sym_complex] = STATE(523),
    [sym_string] = STATE(523),
    [anon_sym_SEMI] = ACTIONS(1561),
    [anon_sym_function] = ACTIONS(1003),
    [anon_sym_BSLASH] = ACTIONS(1005),
    [anon_sym_if] = ACTIONS(1007),
    [anon_sym_LPAREN] = ACTIONS(1009),
    [anon_sym_while] = ACTIONS(1011),
    [anon_sym_repeat] = ACTIONS(1013),
    [anon_sym_for] = ACTIONS(1015),
    [anon_sym_switch] = ACTIONS(1017),
    [anon_sym_LBRACE] = ACTIONS(1019),
    [sym_dots] = ACTIONS(1563),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_TILDE] = ACTIONS(1027),
    [sym_break] = ACTIONS(1563),
    [sym_next] = ACTIONS(1563),
    [sym_true] = ACTIONS(1563),
    [sym_false] = ACTIONS(1563),
    [sym_null] = ACTIONS(1563),
    [sym_inf] = ACTIONS(1563),
    [sym_nan] = ACTIONS(1563),
    [anon_sym_NA] = ACTIONS(1029),
    [anon_sym_NA_character_] = ACTIONS(1029),
    [anon_sym_NA_complex_] = ACTIONS(1029),
    [anon_sym_NA_integer_] = ACTIONS(1029),
    [anon_sym_NA_real_] = ACTIONS(1029),
    [aux_sym_identifier_token1] = ACTIONS(1031),
    [anon_sym_BQUOTE] = ACTIONS(1033),
    [sym_integer] = ACTIONS(1561),
    [sym_float] = ACTIONS(1035),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [anon_sym_SQUOTE] = ACTIONS(1039),
  },
  [256] = {
    [sym_function_definition] = STATE(416),
    [sym_lambda_function] = STATE(416),
    [sym_if] = STATE(416),
    [sym_while] = STATE(416),
    [sym_repeat] = STATE(416),
    [sym_for] = STATE(416),
    [sym_switch] = STATE(416),
    [sym_call] = STATE(416),
    [sym__assignment] = STATE(416),
    [sym_left_assignment] = STATE(416),
    [sym_left_assignment2] = STATE(416),
    [sym_equals_assignment] = STATE(416),
    [sym_super_assignment] = STATE(416),
    [sym_super_right_assignment] = STATE(416),
    [sym_right_assignment] = STATE(416),
    [sym_brace_list] = STATE(416),
    [sym_paren_list] = STATE(416),
    [sym_subset] = STATE(416),
    [sym_subset2] = STATE(416),
    [sym_dollar] = STATE(416),
    [sym_slot] = STATE(416),
    [sym_namespace_get] = STATE(416),
    [sym_namespace_get_internal] = STATE(416),
    [sym_pipe] = STATE(416),
    [sym_unary] = STATE(416),
    [sym_binary] = STATE(416),
    [sym_na] = STATE(416),
    [sym__expression] = STATE(416),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(416),
    [sym_string] = STATE(416),
    [anon_sym_SEMI] = ACTIONS(1565),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1567),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1567),
    [sym_next] = ACTIONS(1567),
    [sym_true] = ACTIONS(1567),
    [sym_false] = ACTIONS(1567),
    [sym_null] = ACTIONS(1567),
    [sym_inf] = ACTIONS(1567),
    [sym_nan] = ACTIONS(1567),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1565),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [257] = {
    [sym_function_definition] = STATE(415),
    [sym_lambda_function] = STATE(415),
    [sym_if] = STATE(415),
    [sym_while] = STATE(415),
    [sym_repeat] = STATE(415),
    [sym_for] = STATE(415),
    [sym_switch] = STATE(415),
    [sym_call] = STATE(415),
    [sym__assignment] = STATE(415),
    [sym_left_assignment] = STATE(415),
    [sym_left_assignment2] = STATE(415),
    [sym_equals_assignment] = STATE(415),
    [sym_super_assignment] = STATE(415),
    [sym_super_right_assignment] = STATE(415),
    [sym_right_assignment] = STATE(415),
    [sym_brace_list] = STATE(415),
    [sym_paren_list] = STATE(415),
    [sym_subset] = STATE(415),
    [sym_subset2] = STATE(415),
    [sym_dollar] = STATE(415),
    [sym_slot] = STATE(415),
    [sym_namespace_get] = STATE(415),
    [sym_namespace_get_internal] = STATE(415),
    [sym_pipe] = STATE(415),
    [sym_unary] = STATE(415),
    [sym_binary] = STATE(415),
    [sym_na] = STATE(415),
    [sym__expression] = STATE(415),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(415),
    [sym_string] = STATE(415),
    [anon_sym_SEMI] = ACTIONS(1569),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1571),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1571),
    [sym_next] = ACTIONS(1571),
    [sym_true] = ACTIONS(1571),
    [sym_false] = ACTIONS(1571),
    [sym_null] = ACTIONS(1571),
    [sym_inf] = ACTIONS(1571),
    [sym_nan] = ACTIONS(1571),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1569),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [258] = {
    [sym_function_definition] = STATE(414),
    [sym_lambda_function] = STATE(414),
    [sym_if] = STATE(414),
    [sym_while] = STATE(414),
    [sym_repeat] = STATE(414),
    [sym_for] = STATE(414),
    [sym_switch] = STATE(414),
    [sym_call] = STATE(414),
    [sym__assignment] = STATE(414),
    [sym_left_assignment] = STATE(414),
    [sym_left_assignment2] = STATE(414),
    [sym_equals_assignment] = STATE(414),
    [sym_super_assignment] = STATE(414),
    [sym_super_right_assignment] = STATE(414),
    [sym_right_assignment] = STATE(414),
    [sym_brace_list] = STATE(414),
    [sym_paren_list] = STATE(414),
    [sym_subset] = STATE(414),
    [sym_subset2] = STATE(414),
    [sym_dollar] = STATE(414),
    [sym_slot] = STATE(414),
    [sym_namespace_get] = STATE(414),
    [sym_namespace_get_internal] = STATE(414),
    [sym_pipe] = STATE(414),
    [sym_unary] = STATE(414),
    [sym_binary] = STATE(414),
    [sym_na] = STATE(414),
    [sym__expression] = STATE(414),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(414),
    [sym_string] = STATE(414),
    [anon_sym_SEMI] = ACTIONS(1573),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1575),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1575),
    [sym_next] = ACTIONS(1575),
    [sym_true] = ACTIONS(1575),
    [sym_false] = ACTIONS(1575),
    [sym_null] = ACTIONS(1575),
    [sym_inf] = ACTIONS(1575),
    [sym_nan] = ACTIONS(1575),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1573),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [259] = {
    [sym_function_definition] = STATE(412),
    [sym_lambda_function] = STATE(412),
    [sym_if] = STATE(412),
    [sym_while] = STATE(412),
    [sym_repeat] = STATE(412),
    [sym_for] = STATE(412),
    [sym_switch] = STATE(412),
    [sym_call] = STATE(412),
    [sym__assignment] = STATE(412),
    [sym_left_assignment] = STATE(412),
    [sym_left_assignment2] = STATE(412),
    [sym_equals_assignment] = STATE(412),
    [sym_super_assignment] = STATE(412),
    [sym_super_right_assignment] = STATE(412),
    [sym_right_assignment] = STATE(412),
    [sym_brace_list] = STATE(412),
    [sym_paren_list] = STATE(412),
    [sym_subset] = STATE(412),
    [sym_subset2] = STATE(412),
    [sym_dollar] = STATE(412),
    [sym_slot] = STATE(412),
    [sym_namespace_get] = STATE(412),
    [sym_namespace_get_internal] = STATE(412),
    [sym_pipe] = STATE(412),
    [sym_unary] = STATE(412),
    [sym_binary] = STATE(412),
    [sym_na] = STATE(412),
    [sym__expression] = STATE(412),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(412),
    [sym_string] = STATE(412),
    [anon_sym_SEMI] = ACTIONS(1577),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1579),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1579),
    [sym_next] = ACTIONS(1579),
    [sym_true] = ACTIONS(1579),
    [sym_false] = ACTIONS(1579),
    [sym_null] = ACTIONS(1579),
    [sym_inf] = ACTIONS(1579),
    [sym_nan] = ACTIONS(1579),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1577),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [260] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1437),
    [anon_sym_function] = ACTIONS(1439),
    [anon_sym_BSLASH] = ACTIONS(1437),
    [anon_sym_if] = ACTIONS(1439),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1437),
    [anon_sym_else] = ACTIONS(1581),
    [anon_sym_while] = ACTIONS(1439),
    [anon_sym_repeat] = ACTIONS(1439),
    [anon_sym_for] = ACTIONS(1439),
    [anon_sym_switch] = ACTIONS(1439),
    [anon_sym_COMMA] = ACTIONS(1437),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1437),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1437),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1439),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1439),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1439),
    [sym_next] = ACTIONS(1439),
    [sym_true] = ACTIONS(1439),
    [sym_false] = ACTIONS(1439),
    [sym_null] = ACTIONS(1439),
    [sym_inf] = ACTIONS(1439),
    [sym_nan] = ACTIONS(1439),
    [anon_sym_NA] = ACTIONS(1439),
    [anon_sym_NA_character_] = ACTIONS(1439),
    [anon_sym_NA_complex_] = ACTIONS(1439),
    [anon_sym_NA_integer_] = ACTIONS(1439),
    [anon_sym_NA_real_] = ACTIONS(1439),
    [aux_sym_identifier_token1] = ACTIONS(1439),
    [anon_sym_BQUOTE] = ACTIONS(1437),
    [sym_integer] = ACTIONS(1437),
    [sym_float] = ACTIONS(1439),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1437),
    [anon_sym_SQUOTE] = ACTIONS(1437),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [261] = {
    [sym_function_definition] = STATE(872),
    [sym_lambda_function] = STATE(872),
    [sym_if] = STATE(872),
    [sym_while] = STATE(872),
    [sym_repeat] = STATE(872),
    [sym_for] = STATE(872),
    [sym_switch] = STATE(872),
    [sym_call] = STATE(872),
    [sym__assignment] = STATE(872),
    [sym_left_assignment] = STATE(872),
    [sym_left_assignment2] = STATE(872),
    [sym_equals_assignment] = STATE(872),
    [sym_super_assignment] = STATE(872),
    [sym_super_right_assignment] = STATE(872),
    [sym_right_assignment] = STATE(872),
    [sym_brace_list] = STATE(872),
    [sym_paren_list] = STATE(872),
    [sym_subset] = STATE(872),
    [sym_subset2] = STATE(872),
    [sym_dollar] = STATE(872),
    [sym_slot] = STATE(872),
    [sym_namespace_get] = STATE(872),
    [sym_namespace_get_internal] = STATE(872),
    [sym_pipe] = STATE(872),
    [sym_unary] = STATE(872),
    [sym_binary] = STATE(872),
    [sym_na] = STATE(872),
    [sym__expression] = STATE(872),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(872),
    [sym_string] = STATE(872),
    [anon_sym_SEMI] = ACTIONS(1583),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1585),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1585),
    [sym_next] = ACTIONS(1585),
    [sym_true] = ACTIONS(1585),
    [sym_false] = ACTIONS(1585),
    [sym_null] = ACTIONS(1585),
    [sym_inf] = ACTIONS(1585),
    [sym_nan] = ACTIONS(1585),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1583),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [262] = {
    [sym_function_definition] = STATE(873),
    [sym_lambda_function] = STATE(873),
    [sym_if] = STATE(873),
    [sym_while] = STATE(873),
    [sym_repeat] = STATE(873),
    [sym_for] = STATE(873),
    [sym_switch] = STATE(873),
    [sym_call] = STATE(873),
    [sym__assignment] = STATE(873),
    [sym_left_assignment] = STATE(873),
    [sym_left_assignment2] = STATE(873),
    [sym_equals_assignment] = STATE(873),
    [sym_super_assignment] = STATE(873),
    [sym_super_right_assignment] = STATE(873),
    [sym_right_assignment] = STATE(873),
    [sym_brace_list] = STATE(873),
    [sym_paren_list] = STATE(873),
    [sym_subset] = STATE(873),
    [sym_subset2] = STATE(873),
    [sym_dollar] = STATE(873),
    [sym_slot] = STATE(873),
    [sym_namespace_get] = STATE(873),
    [sym_namespace_get_internal] = STATE(873),
    [sym_pipe] = STATE(873),
    [sym_unary] = STATE(873),
    [sym_binary] = STATE(873),
    [sym_na] = STATE(873),
    [sym__expression] = STATE(873),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(873),
    [sym_string] = STATE(873),
    [anon_sym_SEMI] = ACTIONS(1587),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1589),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1589),
    [sym_next] = ACTIONS(1589),
    [sym_true] = ACTIONS(1589),
    [sym_false] = ACTIONS(1589),
    [sym_null] = ACTIONS(1589),
    [sym_inf] = ACTIONS(1589),
    [sym_nan] = ACTIONS(1589),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1587),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [263] = {
    [sym_function_definition] = STATE(874),
    [sym_lambda_function] = STATE(874),
    [sym_if] = STATE(874),
    [sym_while] = STATE(874),
    [sym_repeat] = STATE(874),
    [sym_for] = STATE(874),
    [sym_switch] = STATE(874),
    [sym_call] = STATE(874),
    [sym__assignment] = STATE(874),
    [sym_left_assignment] = STATE(874),
    [sym_left_assignment2] = STATE(874),
    [sym_equals_assignment] = STATE(874),
    [sym_super_assignment] = STATE(874),
    [sym_super_right_assignment] = STATE(874),
    [sym_right_assignment] = STATE(874),
    [sym_brace_list] = STATE(874),
    [sym_paren_list] = STATE(874),
    [sym_subset] = STATE(874),
    [sym_subset2] = STATE(874),
    [sym_dollar] = STATE(874),
    [sym_slot] = STATE(874),
    [sym_namespace_get] = STATE(874),
    [sym_namespace_get_internal] = STATE(874),
    [sym_pipe] = STATE(874),
    [sym_unary] = STATE(874),
    [sym_binary] = STATE(874),
    [sym_na] = STATE(874),
    [sym__expression] = STATE(874),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(874),
    [sym_string] = STATE(874),
    [anon_sym_SEMI] = ACTIONS(1591),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1593),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1593),
    [sym_next] = ACTIONS(1593),
    [sym_true] = ACTIONS(1593),
    [sym_false] = ACTIONS(1593),
    [sym_null] = ACTIONS(1593),
    [sym_inf] = ACTIONS(1593),
    [sym_nan] = ACTIONS(1593),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1591),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [264] = {
    [sym_function_definition] = STATE(646),
    [sym_lambda_function] = STATE(646),
    [sym_if] = STATE(646),
    [sym_while] = STATE(646),
    [sym_repeat] = STATE(646),
    [sym_for] = STATE(646),
    [sym_switch] = STATE(646),
    [sym_call] = STATE(646),
    [sym__assignment] = STATE(646),
    [sym_left_assignment] = STATE(646),
    [sym_left_assignment2] = STATE(646),
    [sym_equals_assignment] = STATE(646),
    [sym_super_assignment] = STATE(646),
    [sym_super_right_assignment] = STATE(646),
    [sym_right_assignment] = STATE(646),
    [sym_brace_list] = STATE(646),
    [sym_paren_list] = STATE(646),
    [sym_subset] = STATE(646),
    [sym_subset2] = STATE(646),
    [sym_dollar] = STATE(646),
    [sym_slot] = STATE(646),
    [sym_namespace_get] = STATE(646),
    [sym_namespace_get_internal] = STATE(646),
    [sym_pipe] = STATE(646),
    [sym_unary] = STATE(646),
    [sym_binary] = STATE(646),
    [sym_na] = STATE(646),
    [sym__expression] = STATE(646),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(646),
    [sym_string] = STATE(646),
    [anon_sym_SEMI] = ACTIONS(1595),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1597),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1597),
    [sym_next] = ACTIONS(1597),
    [sym_true] = ACTIONS(1597),
    [sym_false] = ACTIONS(1597),
    [sym_null] = ACTIONS(1597),
    [sym_inf] = ACTIONS(1597),
    [sym_nan] = ACTIONS(1597),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1595),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [265] = {
    [sym_function_definition] = STATE(645),
    [sym_lambda_function] = STATE(645),
    [sym_if] = STATE(645),
    [sym_while] = STATE(645),
    [sym_repeat] = STATE(645),
    [sym_for] = STATE(645),
    [sym_switch] = STATE(645),
    [sym_call] = STATE(645),
    [sym__assignment] = STATE(645),
    [sym_left_assignment] = STATE(645),
    [sym_left_assignment2] = STATE(645),
    [sym_equals_assignment] = STATE(645),
    [sym_super_assignment] = STATE(645),
    [sym_super_right_assignment] = STATE(645),
    [sym_right_assignment] = STATE(645),
    [sym_brace_list] = STATE(645),
    [sym_paren_list] = STATE(645),
    [sym_subset] = STATE(645),
    [sym_subset2] = STATE(645),
    [sym_dollar] = STATE(645),
    [sym_slot] = STATE(645),
    [sym_namespace_get] = STATE(645),
    [sym_namespace_get_internal] = STATE(645),
    [sym_pipe] = STATE(645),
    [sym_unary] = STATE(645),
    [sym_binary] = STATE(645),
    [sym_na] = STATE(645),
    [sym__expression] = STATE(645),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(645),
    [sym_string] = STATE(645),
    [anon_sym_SEMI] = ACTIONS(1599),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1601),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1601),
    [sym_next] = ACTIONS(1601),
    [sym_true] = ACTIONS(1601),
    [sym_false] = ACTIONS(1601),
    [sym_null] = ACTIONS(1601),
    [sym_inf] = ACTIONS(1601),
    [sym_nan] = ACTIONS(1601),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1599),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [266] = {
    [sym_function_definition] = STATE(644),
    [sym_lambda_function] = STATE(644),
    [sym_if] = STATE(644),
    [sym_while] = STATE(644),
    [sym_repeat] = STATE(644),
    [sym_for] = STATE(644),
    [sym_switch] = STATE(644),
    [sym_call] = STATE(644),
    [sym__assignment] = STATE(644),
    [sym_left_assignment] = STATE(644),
    [sym_left_assignment2] = STATE(644),
    [sym_equals_assignment] = STATE(644),
    [sym_super_assignment] = STATE(644),
    [sym_super_right_assignment] = STATE(644),
    [sym_right_assignment] = STATE(644),
    [sym_brace_list] = STATE(644),
    [sym_paren_list] = STATE(644),
    [sym_subset] = STATE(644),
    [sym_subset2] = STATE(644),
    [sym_dollar] = STATE(644),
    [sym_slot] = STATE(644),
    [sym_namespace_get] = STATE(644),
    [sym_namespace_get_internal] = STATE(644),
    [sym_pipe] = STATE(644),
    [sym_unary] = STATE(644),
    [sym_binary] = STATE(644),
    [sym_na] = STATE(644),
    [sym__expression] = STATE(644),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(644),
    [sym_string] = STATE(644),
    [anon_sym_SEMI] = ACTIONS(1603),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1605),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1605),
    [sym_next] = ACTIONS(1605),
    [sym_true] = ACTIONS(1605),
    [sym_false] = ACTIONS(1605),
    [sym_null] = ACTIONS(1605),
    [sym_inf] = ACTIONS(1605),
    [sym_nan] = ACTIONS(1605),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1603),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [267] = {
    [sym_function_definition] = STATE(643),
    [sym_lambda_function] = STATE(643),
    [sym_if] = STATE(643),
    [sym_while] = STATE(643),
    [sym_repeat] = STATE(643),
    [sym_for] = STATE(643),
    [sym_switch] = STATE(643),
    [sym_call] = STATE(643),
    [sym__assignment] = STATE(643),
    [sym_left_assignment] = STATE(643),
    [sym_left_assignment2] = STATE(643),
    [sym_equals_assignment] = STATE(643),
    [sym_super_assignment] = STATE(643),
    [sym_super_right_assignment] = STATE(643),
    [sym_right_assignment] = STATE(643),
    [sym_brace_list] = STATE(643),
    [sym_paren_list] = STATE(643),
    [sym_subset] = STATE(643),
    [sym_subset2] = STATE(643),
    [sym_dollar] = STATE(643),
    [sym_slot] = STATE(643),
    [sym_namespace_get] = STATE(643),
    [sym_namespace_get_internal] = STATE(643),
    [sym_pipe] = STATE(643),
    [sym_unary] = STATE(643),
    [sym_binary] = STATE(643),
    [sym_na] = STATE(643),
    [sym__expression] = STATE(643),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(643),
    [sym_string] = STATE(643),
    [anon_sym_SEMI] = ACTIONS(1607),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1609),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1609),
    [sym_next] = ACTIONS(1609),
    [sym_true] = ACTIONS(1609),
    [sym_false] = ACTIONS(1609),
    [sym_null] = ACTIONS(1609),
    [sym_inf] = ACTIONS(1609),
    [sym_nan] = ACTIONS(1609),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1607),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [268] = {
    [sym_function_definition] = STATE(642),
    [sym_lambda_function] = STATE(642),
    [sym_if] = STATE(642),
    [sym_while] = STATE(642),
    [sym_repeat] = STATE(642),
    [sym_for] = STATE(642),
    [sym_switch] = STATE(642),
    [sym_call] = STATE(642),
    [sym__assignment] = STATE(642),
    [sym_left_assignment] = STATE(642),
    [sym_left_assignment2] = STATE(642),
    [sym_equals_assignment] = STATE(642),
    [sym_super_assignment] = STATE(642),
    [sym_super_right_assignment] = STATE(642),
    [sym_right_assignment] = STATE(642),
    [sym_brace_list] = STATE(642),
    [sym_paren_list] = STATE(642),
    [sym_subset] = STATE(642),
    [sym_subset2] = STATE(642),
    [sym_dollar] = STATE(642),
    [sym_slot] = STATE(642),
    [sym_namespace_get] = STATE(642),
    [sym_namespace_get_internal] = STATE(642),
    [sym_pipe] = STATE(642),
    [sym_unary] = STATE(642),
    [sym_binary] = STATE(642),
    [sym_na] = STATE(642),
    [sym__expression] = STATE(642),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(642),
    [sym_string] = STATE(642),
    [anon_sym_SEMI] = ACTIONS(1611),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1613),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1613),
    [sym_next] = ACTIONS(1613),
    [sym_true] = ACTIONS(1613),
    [sym_false] = ACTIONS(1613),
    [sym_null] = ACTIONS(1613),
    [sym_inf] = ACTIONS(1613),
    [sym_nan] = ACTIONS(1613),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1611),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [269] = {
    [sym_function_definition] = STATE(641),
    [sym_lambda_function] = STATE(641),
    [sym_if] = STATE(641),
    [sym_while] = STATE(641),
    [sym_repeat] = STATE(641),
    [sym_for] = STATE(641),
    [sym_switch] = STATE(641),
    [sym_call] = STATE(641),
    [sym__assignment] = STATE(641),
    [sym_left_assignment] = STATE(641),
    [sym_left_assignment2] = STATE(641),
    [sym_equals_assignment] = STATE(641),
    [sym_super_assignment] = STATE(641),
    [sym_super_right_assignment] = STATE(641),
    [sym_right_assignment] = STATE(641),
    [sym_brace_list] = STATE(641),
    [sym_paren_list] = STATE(641),
    [sym_subset] = STATE(641),
    [sym_subset2] = STATE(641),
    [sym_dollar] = STATE(641),
    [sym_slot] = STATE(641),
    [sym_namespace_get] = STATE(641),
    [sym_namespace_get_internal] = STATE(641),
    [sym_pipe] = STATE(641),
    [sym_unary] = STATE(641),
    [sym_binary] = STATE(641),
    [sym_na] = STATE(641),
    [sym__expression] = STATE(641),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(641),
    [sym_string] = STATE(641),
    [anon_sym_SEMI] = ACTIONS(1615),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1617),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1617),
    [sym_next] = ACTIONS(1617),
    [sym_true] = ACTIONS(1617),
    [sym_false] = ACTIONS(1617),
    [sym_null] = ACTIONS(1617),
    [sym_inf] = ACTIONS(1617),
    [sym_nan] = ACTIONS(1617),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1615),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [270] = {
    [sym_function_definition] = STATE(829),
    [sym_lambda_function] = STATE(829),
    [sym_if] = STATE(829),
    [sym_while] = STATE(829),
    [sym_repeat] = STATE(829),
    [sym_for] = STATE(829),
    [sym_switch] = STATE(829),
    [sym_call] = STATE(829),
    [sym__assignment] = STATE(829),
    [sym_left_assignment] = STATE(829),
    [sym_left_assignment2] = STATE(829),
    [sym_equals_assignment] = STATE(829),
    [sym_super_assignment] = STATE(829),
    [sym_super_right_assignment] = STATE(829),
    [sym_right_assignment] = STATE(829),
    [sym_brace_list] = STATE(829),
    [sym_paren_list] = STATE(829),
    [sym_subset] = STATE(829),
    [sym_subset2] = STATE(829),
    [sym_dollar] = STATE(829),
    [sym_slot] = STATE(829),
    [sym_namespace_get] = STATE(829),
    [sym_namespace_get_internal] = STATE(829),
    [sym_pipe] = STATE(829),
    [sym_unary] = STATE(829),
    [sym_binary] = STATE(829),
    [sym_na] = STATE(829),
    [sym__expression] = STATE(829),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(829),
    [sym_string] = STATE(829),
    [anon_sym_SEMI] = ACTIONS(1619),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1621),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1621),
    [sym_next] = ACTIONS(1621),
    [sym_true] = ACTIONS(1621),
    [sym_false] = ACTIONS(1621),
    [sym_null] = ACTIONS(1621),
    [sym_inf] = ACTIONS(1621),
    [sym_nan] = ACTIONS(1621),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1619),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [271] = {
    [sym_function_definition] = STATE(237),
    [sym_lambda_function] = STATE(237),
    [sym_if] = STATE(237),
    [sym_while] = STATE(237),
    [sym_repeat] = STATE(237),
    [sym_for] = STATE(237),
    [sym_switch] = STATE(237),
    [sym_call] = STATE(237),
    [sym__assignment] = STATE(237),
    [sym_left_assignment] = STATE(237),
    [sym_left_assignment2] = STATE(237),
    [sym_equals_assignment] = STATE(237),
    [sym_super_assignment] = STATE(237),
    [sym_super_right_assignment] = STATE(237),
    [sym_right_assignment] = STATE(237),
    [sym_brace_list] = STATE(237),
    [sym_paren_list] = STATE(237),
    [sym_subset] = STATE(237),
    [sym_subset2] = STATE(237),
    [sym_dollar] = STATE(237),
    [sym_slot] = STATE(237),
    [sym_namespace_get] = STATE(237),
    [sym_namespace_get_internal] = STATE(237),
    [sym_pipe] = STATE(237),
    [sym_unary] = STATE(237),
    [sym_binary] = STATE(237),
    [sym_na] = STATE(237),
    [sym__expression] = STATE(237),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(237),
    [sym_string] = STATE(237),
    [anon_sym_SEMI] = ACTIONS(1623),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1625),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1625),
    [sym_next] = ACTIONS(1625),
    [sym_true] = ACTIONS(1625),
    [sym_false] = ACTIONS(1625),
    [sym_null] = ACTIONS(1625),
    [sym_inf] = ACTIONS(1625),
    [sym_nan] = ACTIONS(1625),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1623),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [272] = {
    [sym_function_definition] = STATE(635),
    [sym_lambda_function] = STATE(635),
    [sym_if] = STATE(635),
    [sym_while] = STATE(635),
    [sym_repeat] = STATE(635),
    [sym_for] = STATE(635),
    [sym_switch] = STATE(635),
    [sym_call] = STATE(635),
    [sym__assignment] = STATE(635),
    [sym_left_assignment] = STATE(635),
    [sym_left_assignment2] = STATE(635),
    [sym_equals_assignment] = STATE(635),
    [sym_super_assignment] = STATE(635),
    [sym_super_right_assignment] = STATE(635),
    [sym_right_assignment] = STATE(635),
    [sym_brace_list] = STATE(635),
    [sym_paren_list] = STATE(635),
    [sym_subset] = STATE(635),
    [sym_subset2] = STATE(635),
    [sym_dollar] = STATE(635),
    [sym_slot] = STATE(635),
    [sym_namespace_get] = STATE(635),
    [sym_namespace_get_internal] = STATE(635),
    [sym_pipe] = STATE(635),
    [sym_unary] = STATE(635),
    [sym_binary] = STATE(635),
    [sym_na] = STATE(635),
    [sym__expression] = STATE(635),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(635),
    [sym_string] = STATE(635),
    [anon_sym_SEMI] = ACTIONS(1627),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1629),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1629),
    [sym_next] = ACTIONS(1629),
    [sym_true] = ACTIONS(1629),
    [sym_false] = ACTIONS(1629),
    [sym_null] = ACTIONS(1629),
    [sym_inf] = ACTIONS(1629),
    [sym_nan] = ACTIONS(1629),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1627),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [273] = {
    [sym_function_definition] = STATE(634),
    [sym_lambda_function] = STATE(634),
    [sym_if] = STATE(634),
    [sym_while] = STATE(634),
    [sym_repeat] = STATE(634),
    [sym_for] = STATE(634),
    [sym_switch] = STATE(634),
    [sym_call] = STATE(634),
    [sym__assignment] = STATE(634),
    [sym_left_assignment] = STATE(634),
    [sym_left_assignment2] = STATE(634),
    [sym_equals_assignment] = STATE(634),
    [sym_super_assignment] = STATE(634),
    [sym_super_right_assignment] = STATE(634),
    [sym_right_assignment] = STATE(634),
    [sym_brace_list] = STATE(634),
    [sym_paren_list] = STATE(634),
    [sym_subset] = STATE(634),
    [sym_subset2] = STATE(634),
    [sym_dollar] = STATE(634),
    [sym_slot] = STATE(634),
    [sym_namespace_get] = STATE(634),
    [sym_namespace_get_internal] = STATE(634),
    [sym_pipe] = STATE(634),
    [sym_unary] = STATE(634),
    [sym_binary] = STATE(634),
    [sym_na] = STATE(634),
    [sym__expression] = STATE(634),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(634),
    [sym_string] = STATE(634),
    [anon_sym_SEMI] = ACTIONS(1631),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1633),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1633),
    [sym_next] = ACTIONS(1633),
    [sym_true] = ACTIONS(1633),
    [sym_false] = ACTIONS(1633),
    [sym_null] = ACTIONS(1633),
    [sym_inf] = ACTIONS(1633),
    [sym_nan] = ACTIONS(1633),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1631),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [274] = {
    [sym_function_definition] = STATE(633),
    [sym_lambda_function] = STATE(633),
    [sym_if] = STATE(633),
    [sym_while] = STATE(633),
    [sym_repeat] = STATE(633),
    [sym_for] = STATE(633),
    [sym_switch] = STATE(633),
    [sym_call] = STATE(633),
    [sym__assignment] = STATE(633),
    [sym_left_assignment] = STATE(633),
    [sym_left_assignment2] = STATE(633),
    [sym_equals_assignment] = STATE(633),
    [sym_super_assignment] = STATE(633),
    [sym_super_right_assignment] = STATE(633),
    [sym_right_assignment] = STATE(633),
    [sym_brace_list] = STATE(633),
    [sym_paren_list] = STATE(633),
    [sym_subset] = STATE(633),
    [sym_subset2] = STATE(633),
    [sym_dollar] = STATE(633),
    [sym_slot] = STATE(633),
    [sym_namespace_get] = STATE(633),
    [sym_namespace_get_internal] = STATE(633),
    [sym_pipe] = STATE(633),
    [sym_unary] = STATE(633),
    [sym_binary] = STATE(633),
    [sym_na] = STATE(633),
    [sym__expression] = STATE(633),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(633),
    [sym_string] = STATE(633),
    [anon_sym_SEMI] = ACTIONS(1635),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1637),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1637),
    [sym_next] = ACTIONS(1637),
    [sym_true] = ACTIONS(1637),
    [sym_false] = ACTIONS(1637),
    [sym_null] = ACTIONS(1637),
    [sym_inf] = ACTIONS(1637),
    [sym_nan] = ACTIONS(1637),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1635),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [275] = {
    [sym_function_definition] = STATE(632),
    [sym_lambda_function] = STATE(632),
    [sym_if] = STATE(632),
    [sym_while] = STATE(632),
    [sym_repeat] = STATE(632),
    [sym_for] = STATE(632),
    [sym_switch] = STATE(632),
    [sym_call] = STATE(632),
    [sym__assignment] = STATE(632),
    [sym_left_assignment] = STATE(632),
    [sym_left_assignment2] = STATE(632),
    [sym_equals_assignment] = STATE(632),
    [sym_super_assignment] = STATE(632),
    [sym_super_right_assignment] = STATE(632),
    [sym_right_assignment] = STATE(632),
    [sym_brace_list] = STATE(632),
    [sym_paren_list] = STATE(632),
    [sym_subset] = STATE(632),
    [sym_subset2] = STATE(632),
    [sym_dollar] = STATE(632),
    [sym_slot] = STATE(632),
    [sym_namespace_get] = STATE(632),
    [sym_namespace_get_internal] = STATE(632),
    [sym_pipe] = STATE(632),
    [sym_unary] = STATE(632),
    [sym_binary] = STATE(632),
    [sym_na] = STATE(632),
    [sym__expression] = STATE(632),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(632),
    [sym_string] = STATE(632),
    [anon_sym_SEMI] = ACTIONS(1639),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1641),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1641),
    [sym_next] = ACTIONS(1641),
    [sym_true] = ACTIONS(1641),
    [sym_false] = ACTIONS(1641),
    [sym_null] = ACTIONS(1641),
    [sym_inf] = ACTIONS(1641),
    [sym_nan] = ACTIONS(1641),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1639),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [276] = {
    [sym_function_definition] = STATE(676),
    [sym_lambda_function] = STATE(676),
    [sym_if] = STATE(676),
    [sym_while] = STATE(676),
    [sym_repeat] = STATE(676),
    [sym_for] = STATE(676),
    [sym_switch] = STATE(676),
    [sym_call] = STATE(676),
    [sym__assignment] = STATE(676),
    [sym_left_assignment] = STATE(676),
    [sym_left_assignment2] = STATE(676),
    [sym_equals_assignment] = STATE(676),
    [sym_super_assignment] = STATE(676),
    [sym_super_right_assignment] = STATE(676),
    [sym_right_assignment] = STATE(676),
    [sym_brace_list] = STATE(676),
    [sym_paren_list] = STATE(676),
    [sym_subset] = STATE(676),
    [sym_subset2] = STATE(676),
    [sym_dollar] = STATE(676),
    [sym_slot] = STATE(676),
    [sym_namespace_get] = STATE(676),
    [sym_namespace_get_internal] = STATE(676),
    [sym_pipe] = STATE(676),
    [sym_unary] = STATE(676),
    [sym_binary] = STATE(676),
    [sym_na] = STATE(676),
    [sym__expression] = STATE(676),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(676),
    [sym_string] = STATE(676),
    [anon_sym_SEMI] = ACTIONS(1643),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1645),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1645),
    [sym_next] = ACTIONS(1645),
    [sym_true] = ACTIONS(1645),
    [sym_false] = ACTIONS(1645),
    [sym_null] = ACTIONS(1645),
    [sym_inf] = ACTIONS(1645),
    [sym_nan] = ACTIONS(1645),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1643),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [277] = {
    [sym_function_definition] = STATE(621),
    [sym_lambda_function] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_repeat] = STATE(621),
    [sym_for] = STATE(621),
    [sym_switch] = STATE(621),
    [sym_call] = STATE(621),
    [sym__assignment] = STATE(621),
    [sym_left_assignment] = STATE(621),
    [sym_left_assignment2] = STATE(621),
    [sym_equals_assignment] = STATE(621),
    [sym_super_assignment] = STATE(621),
    [sym_super_right_assignment] = STATE(621),
    [sym_right_assignment] = STATE(621),
    [sym_brace_list] = STATE(621),
    [sym_paren_list] = STATE(621),
    [sym_subset] = STATE(621),
    [sym_subset2] = STATE(621),
    [sym_dollar] = STATE(621),
    [sym_slot] = STATE(621),
    [sym_namespace_get] = STATE(621),
    [sym_namespace_get_internal] = STATE(621),
    [sym_pipe] = STATE(621),
    [sym_unary] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_na] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(621),
    [sym_string] = STATE(621),
    [anon_sym_SEMI] = ACTIONS(1647),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1649),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1649),
    [sym_next] = ACTIONS(1649),
    [sym_true] = ACTIONS(1649),
    [sym_false] = ACTIONS(1649),
    [sym_null] = ACTIONS(1649),
    [sym_inf] = ACTIONS(1649),
    [sym_nan] = ACTIONS(1649),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1647),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [278] = {
    [sym_function_definition] = STATE(619),
    [sym_lambda_function] = STATE(619),
    [sym_if] = STATE(619),
    [sym_while] = STATE(619),
    [sym_repeat] = STATE(619),
    [sym_for] = STATE(619),
    [sym_switch] = STATE(619),
    [sym_call] = STATE(619),
    [sym__assignment] = STATE(619),
    [sym_left_assignment] = STATE(619),
    [sym_left_assignment2] = STATE(619),
    [sym_equals_assignment] = STATE(619),
    [sym_super_assignment] = STATE(619),
    [sym_super_right_assignment] = STATE(619),
    [sym_right_assignment] = STATE(619),
    [sym_brace_list] = STATE(619),
    [sym_paren_list] = STATE(619),
    [sym_subset] = STATE(619),
    [sym_subset2] = STATE(619),
    [sym_dollar] = STATE(619),
    [sym_slot] = STATE(619),
    [sym_namespace_get] = STATE(619),
    [sym_namespace_get_internal] = STATE(619),
    [sym_pipe] = STATE(619),
    [sym_unary] = STATE(619),
    [sym_binary] = STATE(619),
    [sym_na] = STATE(619),
    [sym__expression] = STATE(619),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(619),
    [sym_string] = STATE(619),
    [anon_sym_SEMI] = ACTIONS(1651),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1653),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1653),
    [sym_next] = ACTIONS(1653),
    [sym_true] = ACTIONS(1653),
    [sym_false] = ACTIONS(1653),
    [sym_null] = ACTIONS(1653),
    [sym_inf] = ACTIONS(1653),
    [sym_nan] = ACTIONS(1653),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1651),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [279] = {
    [sym_function_definition] = STATE(616),
    [sym_lambda_function] = STATE(616),
    [sym_if] = STATE(616),
    [sym_while] = STATE(616),
    [sym_repeat] = STATE(616),
    [sym_for] = STATE(616),
    [sym_switch] = STATE(616),
    [sym_call] = STATE(616),
    [sym__assignment] = STATE(616),
    [sym_left_assignment] = STATE(616),
    [sym_left_assignment2] = STATE(616),
    [sym_equals_assignment] = STATE(616),
    [sym_super_assignment] = STATE(616),
    [sym_super_right_assignment] = STATE(616),
    [sym_right_assignment] = STATE(616),
    [sym_brace_list] = STATE(616),
    [sym_paren_list] = STATE(616),
    [sym_subset] = STATE(616),
    [sym_subset2] = STATE(616),
    [sym_dollar] = STATE(616),
    [sym_slot] = STATE(616),
    [sym_namespace_get] = STATE(616),
    [sym_namespace_get_internal] = STATE(616),
    [sym_pipe] = STATE(616),
    [sym_unary] = STATE(616),
    [sym_binary] = STATE(616),
    [sym_na] = STATE(616),
    [sym__expression] = STATE(616),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(616),
    [sym_string] = STATE(616),
    [anon_sym_SEMI] = ACTIONS(1655),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1657),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1657),
    [sym_next] = ACTIONS(1657),
    [sym_true] = ACTIONS(1657),
    [sym_false] = ACTIONS(1657),
    [sym_null] = ACTIONS(1657),
    [sym_inf] = ACTIONS(1657),
    [sym_nan] = ACTIONS(1657),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1655),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [280] = {
    [sym_function_definition] = STATE(615),
    [sym_lambda_function] = STATE(615),
    [sym_if] = STATE(615),
    [sym_while] = STATE(615),
    [sym_repeat] = STATE(615),
    [sym_for] = STATE(615),
    [sym_switch] = STATE(615),
    [sym_call] = STATE(615),
    [sym__assignment] = STATE(615),
    [sym_left_assignment] = STATE(615),
    [sym_left_assignment2] = STATE(615),
    [sym_equals_assignment] = STATE(615),
    [sym_super_assignment] = STATE(615),
    [sym_super_right_assignment] = STATE(615),
    [sym_right_assignment] = STATE(615),
    [sym_brace_list] = STATE(615),
    [sym_paren_list] = STATE(615),
    [sym_subset] = STATE(615),
    [sym_subset2] = STATE(615),
    [sym_dollar] = STATE(615),
    [sym_slot] = STATE(615),
    [sym_namespace_get] = STATE(615),
    [sym_namespace_get_internal] = STATE(615),
    [sym_pipe] = STATE(615),
    [sym_unary] = STATE(615),
    [sym_binary] = STATE(615),
    [sym_na] = STATE(615),
    [sym__expression] = STATE(615),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(615),
    [sym_string] = STATE(615),
    [anon_sym_SEMI] = ACTIONS(1659),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1661),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1661),
    [sym_next] = ACTIONS(1661),
    [sym_true] = ACTIONS(1661),
    [sym_false] = ACTIONS(1661),
    [sym_null] = ACTIONS(1661),
    [sym_inf] = ACTIONS(1661),
    [sym_nan] = ACTIONS(1661),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1659),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [281] = {
    [sym_function_definition] = STATE(926),
    [sym_lambda_function] = STATE(926),
    [sym_if] = STATE(926),
    [sym_while] = STATE(926),
    [sym_repeat] = STATE(926),
    [sym_for] = STATE(926),
    [sym_switch] = STATE(926),
    [sym_call] = STATE(612),
    [sym__assignment] = STATE(926),
    [sym_left_assignment] = STATE(926),
    [sym_left_assignment2] = STATE(926),
    [sym_equals_assignment] = STATE(926),
    [sym_super_assignment] = STATE(926),
    [sym_super_right_assignment] = STATE(926),
    [sym_right_assignment] = STATE(926),
    [sym_brace_list] = STATE(926),
    [sym_paren_list] = STATE(926),
    [sym_subset] = STATE(926),
    [sym_subset2] = STATE(926),
    [sym_dollar] = STATE(926),
    [sym_slot] = STATE(926),
    [sym_namespace_get] = STATE(926),
    [sym_namespace_get_internal] = STATE(926),
    [sym_pipe] = STATE(926),
    [sym_unary] = STATE(926),
    [sym_binary] = STATE(926),
    [sym_na] = STATE(926),
    [sym__expression] = STATE(926),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(926),
    [sym_string] = STATE(926),
    [anon_sym_SEMI] = ACTIONS(1663),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1665),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1665),
    [sym_next] = ACTIONS(1665),
    [sym_true] = ACTIONS(1665),
    [sym_false] = ACTIONS(1665),
    [sym_null] = ACTIONS(1665),
    [sym_inf] = ACTIONS(1665),
    [sym_nan] = ACTIONS(1665),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1663),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [282] = {
    [sym_function_definition] = STATE(658),
    [sym_lambda_function] = STATE(658),
    [sym_if] = STATE(658),
    [sym_while] = STATE(658),
    [sym_repeat] = STATE(658),
    [sym_for] = STATE(658),
    [sym_switch] = STATE(658),
    [sym_call] = STATE(658),
    [sym__assignment] = STATE(658),
    [sym_left_assignment] = STATE(658),
    [sym_left_assignment2] = STATE(658),
    [sym_equals_assignment] = STATE(658),
    [sym_super_assignment] = STATE(658),
    [sym_super_right_assignment] = STATE(658),
    [sym_right_assignment] = STATE(658),
    [sym_brace_list] = STATE(658),
    [sym_paren_list] = STATE(658),
    [sym_subset] = STATE(658),
    [sym_subset2] = STATE(658),
    [sym_dollar] = STATE(658),
    [sym_slot] = STATE(658),
    [sym_namespace_get] = STATE(658),
    [sym_namespace_get_internal] = STATE(658),
    [sym_pipe] = STATE(658),
    [sym_unary] = STATE(658),
    [sym_binary] = STATE(658),
    [sym_na] = STATE(658),
    [sym__expression] = STATE(658),
    [sym_identifier] = STATE(555),
    [sym_complex] = STATE(658),
    [sym_string] = STATE(658),
    [anon_sym_SEMI] = ACTIONS(1667),
    [anon_sym_function] = ACTIONS(9),
    [anon_sym_BSLASH] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_dots] = ACTIONS(1669),
    [anon_sym_DASH] = ACTIONS(29),
    [anon_sym_PLUS] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_TILDE] = ACTIONS(33),
    [sym_break] = ACTIONS(1669),
    [sym_next] = ACTIONS(1669),
    [sym_true] = ACTIONS(1669),
    [sym_false] = ACTIONS(1669),
    [sym_null] = ACTIONS(1669),
    [sym_inf] = ACTIONS(1669),
    [sym_nan] = ACTIONS(1669),
    [anon_sym_NA] = ACTIONS(35),
    [anon_sym_NA_character_] = ACTIONS(35),
    [anon_sym_NA_complex_] = ACTIONS(35),
    [anon_sym_NA_integer_] = ACTIONS(35),
    [anon_sym_NA_real_] = ACTIONS(35),
    [aux_sym_identifier_token1] = ACTIONS(37),
    [anon_sym_BQUOTE] = ACTIONS(39),
    [sym_integer] = ACTIONS(1667),
    [sym_float] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
  },
  [283] = {
    [anon_sym_SEMI] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(653),
    [anon_sym_BSLASH] = ACTIONS(651),
    [anon_sym_if] = ACTIONS(653),
    [anon_sym_LPAREN] = ACTIONS(651),
    [anon_sym_else] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(653),
    [anon_sym_repeat] = ACTIONS(653),
    [anon_sym_for] = ACTIONS(653),
    [anon_sym_switch] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(651),
    [anon_sym_EQ] = ACTIONS(653),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_LT_DASH] = ACTIONS(651),
    [anon_sym_COLON_EQ] = ACTIONS(651),
    [anon_sym_LT_LT_DASH] = ACTIONS(651),
    [anon_sym_DASH_GT_GT] = ACTIONS(651),
    [anon_sym_DASH_GT] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(651),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(651),
    [anon_sym_DOLLAR] = ACTIONS(651),
    [anon_sym_AT] = ACTIONS(651),
    [anon_sym_COLON_COLON] = ACTIONS(653),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(651),
    [sym_dots] = ACTIONS(653),
    [anon_sym_PIPE_GT] = ACTIONS(651),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_PLUS] = ACTIONS(651),
    [anon_sym_BANG] = ACTIONS(653),
    [anon_sym_TILDE] = ACTIONS(651),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_SLASH] = ACTIONS(651),
    [anon_sym_CARET] = ACTIONS(651),
    [anon_sym_LT] = ACTIONS(653),
    [anon_sym_GT] = ACTIONS(653),
    [anon_sym_LT_EQ] = ACTIONS(651),
    [anon_sym_GT_EQ] = ACTIONS(651),
    [anon_sym_EQ_EQ] = ACTIONS(651),
    [anon_sym_BANG_EQ] = ACTIONS(651),
    [anon_sym_PIPE_PIPE] = ACTIONS(651),
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(651),
    [anon_sym_AMP] = ACTIONS(653),
    [anon_sym_COLON] = ACTIONS(653),
    [sym_break] = ACTIONS(653),
    [sym_next] = ACTIONS(653),
    [sym_true] = ACTIONS(653),
    [sym_false] = ACTIONS(653),
    [sym_null] = ACTIONS(653),
    [sym_inf] = ACTIONS(653),
    [sym_nan] = ACTIONS(653),
    [anon_sym_NA] = ACTIONS(653),
    [anon_sym_NA_character_] = ACTIONS(653),
    [anon_sym_NA_complex_] = ACTIONS(653),
    [anon_sym_NA_integer_] = ACTIONS(653),
    [anon_sym_NA_real_] = ACTIONS(653),
    [aux_sym_identifier_token1] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(651),
    [sym_integer] = ACTIONS(651),
    [sym_float] = ACTIONS(653),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(651),
    [anon_sym_SQUOTE] = ACTIONS(651),
    [anon_sym_PERCENT] = ACTIONS(651),
  },
  [284] = {
    [anon_sym_SEMI] = ACTIONS(647),
    [anon_sym_function] = ACTIONS(649),
    [anon_sym_BSLASH] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(649),
    [anon_sym_LPAREN] = ACTIONS(647),
    [anon_sym_else] = ACTIONS(649),
    [anon_sym_while] = ACTIONS(649),
    [anon_sym_repeat] = ACTIONS(649),
    [anon_sym_for] = ACTIONS(649),
    [anon_sym_switch] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_LT_DASH] = ACTIONS(647),
    [anon_sym_COLON_EQ] = ACTIONS(647),
    [anon_sym_LT_LT_DASH] = ACTIONS(647),
    [anon_sym_DASH_GT_GT] = ACTIONS(647),
    [anon_sym_DASH_GT] = ACTIONS(649),
    [anon_sym_LBRACK] = ACTIONS(649),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(647),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(647),
    [anon_sym_DOLLAR] = ACTIONS(647),
    [anon_sym_AT] = ACTIONS(647),
    [anon_sym_COLON_COLON] = ACTIONS(649),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(647),
    [sym_dots] = ACTIONS(649),
    [anon_sym_PIPE_GT] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(649),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_TILDE] = ACTIONS(647),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(649),
    [anon_sym_GT] = ACTIONS(649),
    [anon_sym_LT_EQ] = ACTIONS(647),
    [anon_sym_GT_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(649),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(649),
    [anon_sym_COLON] = ACTIONS(649),
    [sym_break] = ACTIONS(649),
    [sym_next] = ACTIONS(649),
    [sym_true] = ACTIONS(649),
    [sym_false] = ACTIONS(649),
    [sym_null] = ACTIONS(649),
    [sym_inf] = ACTIONS(649),
    [sym_nan] = ACTIONS(649),
    [anon_sym_NA] = ACTIONS(649),
    [anon_sym_NA_character_] = ACTIONS(649),
    [anon_sym_NA_complex_] = ACTIONS(649),
    [anon_sym_NA_integer_] = ACTIONS(649),
    [anon_sym_NA_real_] = ACTIONS(649),
    [aux_sym_identifier_token1] = ACTIONS(649),
    [anon_sym_BQUOTE] = ACTIONS(647),
    [sym_integer] = ACTIONS(647),
    [sym_float] = ACTIONS(649),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(647),
    [anon_sym_SQUOTE] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
  },
  [285] = {
    [anon_sym_SEMI] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(635),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(635),
    [anon_sym_else] = ACTIONS(637),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_switch] = ACTIONS(637),
    [anon_sym_COMMA] = ACTIONS(635),
    [anon_sym_EQ] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(635),
    [anon_sym_LT_DASH] = ACTIONS(635),
    [anon_sym_COLON_EQ] = ACTIONS(635),
    [anon_sym_LT_LT_DASH] = ACTIONS(635),
    [anon_sym_DASH_GT_GT] = ACTIONS(635),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(635),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(635),
    [anon_sym_DOLLAR] = ACTIONS(635),
    [anon_sym_AT] = ACTIONS(635),
    [anon_sym_COLON_COLON] = ACTIONS(1671),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1673),
    [sym_dots] = ACTIONS(637),
    [anon_sym_PIPE_GT] = ACTIONS(635),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(635),
    [anon_sym_BANG] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(635),
    [anon_sym_SLASH] = ACTIONS(635),
    [anon_sym_CARET] = ACTIONS(635),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_LT_EQ] = ACTIONS(635),
    [anon_sym_GT_EQ] = ACTIONS(635),
    [anon_sym_EQ_EQ] = ACTIONS(635),
    [anon_sym_BANG_EQ] = ACTIONS(635),
    [anon_sym_PIPE_PIPE] = ACTIONS(635),
    [anon_sym_PIPE] = ACTIONS(637),
    [anon_sym_AMP_AMP] = ACTIONS(635),
    [anon_sym_AMP] = ACTIONS(637),
    [anon_sym_COLON] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(637),
    [anon_sym_NA_character_] = ACTIONS(637),
    [anon_sym_NA_complex_] = ACTIONS(637),
    [anon_sym_NA_integer_] = ACTIONS(637),
    [anon_sym_NA_real_] = ACTIONS(637),
    [aux_sym_identifier_token1] = ACTIONS(637),
    [anon_sym_BQUOTE] = ACTIONS(635),
    [sym_integer] = ACTIONS(635),
    [sym_float] = ACTIONS(637),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(635),
    [anon_sym_SQUOTE] = ACTIONS(635),
    [anon_sym_PERCENT] = ACTIONS(635),
  },
  [286] = {
    [anon_sym_SEMI] = ACTIONS(643),
    [anon_sym_function] = ACTIONS(645),
    [anon_sym_BSLASH] = ACTIONS(643),
    [anon_sym_if] = ACTIONS(645),
    [anon_sym_LPAREN] = ACTIONS(643),
    [anon_sym_else] = ACTIONS(645),
    [anon_sym_while] = ACTIONS(645),
    [anon_sym_repeat] = ACTIONS(645),
    [anon_sym_for] = ACTIONS(645),
    [anon_sym_switch] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(643),
    [anon_sym_EQ] = ACTIONS(645),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_LT_DASH] = ACTIONS(643),
    [anon_sym_COLON_EQ] = ACTIONS(643),
    [anon_sym_LT_LT_DASH] = ACTIONS(643),
    [anon_sym_DASH_GT_GT] = ACTIONS(643),
    [anon_sym_DASH_GT] = ACTIONS(645),
    [anon_sym_LBRACK] = ACTIONS(645),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(643),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(643),
    [anon_sym_COLON_COLON] = ACTIONS(645),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(643),
    [sym_dots] = ACTIONS(645),
    [anon_sym_PIPE_GT] = ACTIONS(643),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(643),
    [anon_sym_BANG] = ACTIONS(645),
    [anon_sym_TILDE] = ACTIONS(643),
    [anon_sym_STAR] = ACTIONS(643),
    [anon_sym_SLASH] = ACTIONS(643),
    [anon_sym_CARET] = ACTIONS(643),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(643),
    [anon_sym_GT_EQ] = ACTIONS(643),
    [anon_sym_EQ_EQ] = ACTIONS(643),
    [anon_sym_BANG_EQ] = ACTIONS(643),
    [anon_sym_PIPE_PIPE] = ACTIONS(643),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(643),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_COLON] = ACTIONS(645),
    [sym_break] = ACTIONS(645),
    [sym_next] = ACTIONS(645),
    [sym_true] = ACTIONS(645),
    [sym_false] = ACTIONS(645),
    [sym_null] = ACTIONS(645),
    [sym_inf] = ACTIONS(645),
    [sym_nan] = ACTIONS(645),
    [anon_sym_NA] = ACTIONS(645),
    [anon_sym_NA_character_] = ACTIONS(645),
    [anon_sym_NA_complex_] = ACTIONS(645),
    [anon_sym_NA_integer_] = ACTIONS(645),
    [anon_sym_NA_real_] = ACTIONS(645),
    [aux_sym_identifier_token1] = ACTIONS(645),
    [anon_sym_BQUOTE] = ACTIONS(643),
    [sym_integer] = ACTIONS(643),
    [sym_float] = ACTIONS(645),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(643),
    [anon_sym_SQUOTE] = ACTIONS(643),
    [anon_sym_PERCENT] = ACTIONS(643),
  },
  [287] = {
    [sym_function_definition] = STATE(821),
    [sym_lambda_function] = STATE(821),
    [sym_if] = STATE(821),
    [sym_while] = STATE(821),
    [sym_repeat] = STATE(821),
    [sym_for] = STATE(821),
    [sym_switch] = STATE(821),
    [sym_call] = STATE(821),
    [sym__assignment] = STATE(821),
    [sym_left_assignment] = STATE(821),
    [sym_left_assignment2] = STATE(821),
    [sym_equals_assignment] = STATE(821),
    [sym_super_assignment] = STATE(821),
    [sym_super_right_assignment] = STATE(821),
    [sym_right_assignment] = STATE(821),
    [sym_brace_list] = STATE(821),
    [sym_paren_list] = STATE(821),
    [sym_subset] = STATE(821),
    [sym_subset2] = STATE(821),
    [sym_dollar] = STATE(821),
    [sym_slot] = STATE(821),
    [sym_namespace_get] = STATE(821),
    [sym_namespace_get_internal] = STATE(821),
    [sym_pipe] = STATE(821),
    [sym_unary] = STATE(821),
    [sym_binary] = STATE(821),
    [sym_na] = STATE(821),
    [sym__expression] = STATE(821),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(821),
    [sym_string] = STATE(821),
    [anon_sym_SEMI] = ACTIONS(1675),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1677),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1677),
    [sym_next] = ACTIONS(1677),
    [sym_true] = ACTIONS(1677),
    [sym_false] = ACTIONS(1677),
    [sym_null] = ACTIONS(1677),
    [sym_inf] = ACTIONS(1677),
    [sym_nan] = ACTIONS(1677),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1675),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [288] = {
    [sym_function_definition] = STATE(822),
    [sym_lambda_function] = STATE(822),
    [sym_if] = STATE(822),
    [sym_while] = STATE(822),
    [sym_repeat] = STATE(822),
    [sym_for] = STATE(822),
    [sym_switch] = STATE(822),
    [sym_call] = STATE(822),
    [sym__assignment] = STATE(822),
    [sym_left_assignment] = STATE(822),
    [sym_left_assignment2] = STATE(822),
    [sym_equals_assignment] = STATE(822),
    [sym_super_assignment] = STATE(822),
    [sym_super_right_assignment] = STATE(822),
    [sym_right_assignment] = STATE(822),
    [sym_brace_list] = STATE(822),
    [sym_paren_list] = STATE(822),
    [sym_subset] = STATE(822),
    [sym_subset2] = STATE(822),
    [sym_dollar] = STATE(822),
    [sym_slot] = STATE(822),
    [sym_namespace_get] = STATE(822),
    [sym_namespace_get_internal] = STATE(822),
    [sym_pipe] = STATE(822),
    [sym_unary] = STATE(822),
    [sym_binary] = STATE(822),
    [sym_na] = STATE(822),
    [sym__expression] = STATE(822),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(822),
    [sym_string] = STATE(822),
    [anon_sym_SEMI] = ACTIONS(1679),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1681),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1681),
    [sym_next] = ACTIONS(1681),
    [sym_true] = ACTIONS(1681),
    [sym_false] = ACTIONS(1681),
    [sym_null] = ACTIONS(1681),
    [sym_inf] = ACTIONS(1681),
    [sym_nan] = ACTIONS(1681),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1679),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [289] = {
    [sym_function_definition] = STATE(823),
    [sym_lambda_function] = STATE(823),
    [sym_if] = STATE(823),
    [sym_while] = STATE(823),
    [sym_repeat] = STATE(823),
    [sym_for] = STATE(823),
    [sym_switch] = STATE(823),
    [sym_call] = STATE(823),
    [sym__assignment] = STATE(823),
    [sym_left_assignment] = STATE(823),
    [sym_left_assignment2] = STATE(823),
    [sym_equals_assignment] = STATE(823),
    [sym_super_assignment] = STATE(823),
    [sym_super_right_assignment] = STATE(823),
    [sym_right_assignment] = STATE(823),
    [sym_brace_list] = STATE(823),
    [sym_paren_list] = STATE(823),
    [sym_subset] = STATE(823),
    [sym_subset2] = STATE(823),
    [sym_dollar] = STATE(823),
    [sym_slot] = STATE(823),
    [sym_namespace_get] = STATE(823),
    [sym_namespace_get_internal] = STATE(823),
    [sym_pipe] = STATE(823),
    [sym_unary] = STATE(823),
    [sym_binary] = STATE(823),
    [sym_na] = STATE(823),
    [sym__expression] = STATE(823),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(823),
    [sym_string] = STATE(823),
    [anon_sym_SEMI] = ACTIONS(1683),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1685),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1685),
    [sym_next] = ACTIONS(1685),
    [sym_true] = ACTIONS(1685),
    [sym_false] = ACTIONS(1685),
    [sym_null] = ACTIONS(1685),
    [sym_inf] = ACTIONS(1685),
    [sym_nan] = ACTIONS(1685),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1683),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [290] = {
    [sym_function_definition] = STATE(824),
    [sym_lambda_function] = STATE(824),
    [sym_if] = STATE(824),
    [sym_while] = STATE(824),
    [sym_repeat] = STATE(824),
    [sym_for] = STATE(824),
    [sym_switch] = STATE(824),
    [sym_call] = STATE(824),
    [sym__assignment] = STATE(824),
    [sym_left_assignment] = STATE(824),
    [sym_left_assignment2] = STATE(824),
    [sym_equals_assignment] = STATE(824),
    [sym_super_assignment] = STATE(824),
    [sym_super_right_assignment] = STATE(824),
    [sym_right_assignment] = STATE(824),
    [sym_brace_list] = STATE(824),
    [sym_paren_list] = STATE(824),
    [sym_subset] = STATE(824),
    [sym_subset2] = STATE(824),
    [sym_dollar] = STATE(824),
    [sym_slot] = STATE(824),
    [sym_namespace_get] = STATE(824),
    [sym_namespace_get_internal] = STATE(824),
    [sym_pipe] = STATE(824),
    [sym_unary] = STATE(824),
    [sym_binary] = STATE(824),
    [sym_na] = STATE(824),
    [sym__expression] = STATE(824),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(824),
    [sym_string] = STATE(824),
    [anon_sym_SEMI] = ACTIONS(1687),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1689),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1689),
    [sym_next] = ACTIONS(1689),
    [sym_true] = ACTIONS(1689),
    [sym_false] = ACTIONS(1689),
    [sym_null] = ACTIONS(1689),
    [sym_inf] = ACTIONS(1689),
    [sym_nan] = ACTIONS(1689),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1687),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [291] = {
    [sym_function_definition] = STATE(825),
    [sym_lambda_function] = STATE(825),
    [sym_if] = STATE(825),
    [sym_while] = STATE(825),
    [sym_repeat] = STATE(825),
    [sym_for] = STATE(825),
    [sym_switch] = STATE(825),
    [sym_call] = STATE(825),
    [sym__assignment] = STATE(825),
    [sym_left_assignment] = STATE(825),
    [sym_left_assignment2] = STATE(825),
    [sym_equals_assignment] = STATE(825),
    [sym_super_assignment] = STATE(825),
    [sym_super_right_assignment] = STATE(825),
    [sym_right_assignment] = STATE(825),
    [sym_brace_list] = STATE(825),
    [sym_paren_list] = STATE(825),
    [sym_subset] = STATE(825),
    [sym_subset2] = STATE(825),
    [sym_dollar] = STATE(825),
    [sym_slot] = STATE(825),
    [sym_namespace_get] = STATE(825),
    [sym_namespace_get_internal] = STATE(825),
    [sym_pipe] = STATE(825),
    [sym_unary] = STATE(825),
    [sym_binary] = STATE(825),
    [sym_na] = STATE(825),
    [sym__expression] = STATE(825),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(825),
    [sym_string] = STATE(825),
    [anon_sym_SEMI] = ACTIONS(1691),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1693),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1693),
    [sym_next] = ACTIONS(1693),
    [sym_true] = ACTIONS(1693),
    [sym_false] = ACTIONS(1693),
    [sym_null] = ACTIONS(1693),
    [sym_inf] = ACTIONS(1693),
    [sym_nan] = ACTIONS(1693),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1691),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [292] = {
    [sym_function_definition] = STATE(826),
    [sym_lambda_function] = STATE(826),
    [sym_if] = STATE(826),
    [sym_while] = STATE(826),
    [sym_repeat] = STATE(826),
    [sym_for] = STATE(826),
    [sym_switch] = STATE(826),
    [sym_call] = STATE(826),
    [sym__assignment] = STATE(826),
    [sym_left_assignment] = STATE(826),
    [sym_left_assignment2] = STATE(826),
    [sym_equals_assignment] = STATE(826),
    [sym_super_assignment] = STATE(826),
    [sym_super_right_assignment] = STATE(826),
    [sym_right_assignment] = STATE(826),
    [sym_brace_list] = STATE(826),
    [sym_paren_list] = STATE(826),
    [sym_subset] = STATE(826),
    [sym_subset2] = STATE(826),
    [sym_dollar] = STATE(826),
    [sym_slot] = STATE(826),
    [sym_namespace_get] = STATE(826),
    [sym_namespace_get_internal] = STATE(826),
    [sym_pipe] = STATE(826),
    [sym_unary] = STATE(826),
    [sym_binary] = STATE(826),
    [sym_na] = STATE(826),
    [sym__expression] = STATE(826),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(826),
    [sym_string] = STATE(826),
    [anon_sym_SEMI] = ACTIONS(1695),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1697),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1697),
    [sym_next] = ACTIONS(1697),
    [sym_true] = ACTIONS(1697),
    [sym_false] = ACTIONS(1697),
    [sym_null] = ACTIONS(1697),
    [sym_inf] = ACTIONS(1697),
    [sym_nan] = ACTIONS(1697),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1695),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [293] = {
    [sym_function_definition] = STATE(827),
    [sym_lambda_function] = STATE(827),
    [sym_if] = STATE(827),
    [sym_while] = STATE(827),
    [sym_repeat] = STATE(827),
    [sym_for] = STATE(827),
    [sym_switch] = STATE(827),
    [sym_call] = STATE(827),
    [sym__assignment] = STATE(827),
    [sym_left_assignment] = STATE(827),
    [sym_left_assignment2] = STATE(827),
    [sym_equals_assignment] = STATE(827),
    [sym_super_assignment] = STATE(827),
    [sym_super_right_assignment] = STATE(827),
    [sym_right_assignment] = STATE(827),
    [sym_brace_list] = STATE(827),
    [sym_paren_list] = STATE(827),
    [sym_subset] = STATE(827),
    [sym_subset2] = STATE(827),
    [sym_dollar] = STATE(827),
    [sym_slot] = STATE(827),
    [sym_namespace_get] = STATE(827),
    [sym_namespace_get_internal] = STATE(827),
    [sym_pipe] = STATE(827),
    [sym_unary] = STATE(827),
    [sym_binary] = STATE(827),
    [sym_na] = STATE(827),
    [sym__expression] = STATE(827),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(827),
    [sym_string] = STATE(827),
    [anon_sym_SEMI] = ACTIONS(1699),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1701),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1701),
    [sym_next] = ACTIONS(1701),
    [sym_true] = ACTIONS(1701),
    [sym_false] = ACTIONS(1701),
    [sym_null] = ACTIONS(1701),
    [sym_inf] = ACTIONS(1701),
    [sym_nan] = ACTIONS(1701),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1699),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [294] = {
    [sym_function_definition] = STATE(828),
    [sym_lambda_function] = STATE(828),
    [sym_if] = STATE(828),
    [sym_while] = STATE(828),
    [sym_repeat] = STATE(828),
    [sym_for] = STATE(828),
    [sym_switch] = STATE(828),
    [sym_call] = STATE(828),
    [sym__assignment] = STATE(828),
    [sym_left_assignment] = STATE(828),
    [sym_left_assignment2] = STATE(828),
    [sym_equals_assignment] = STATE(828),
    [sym_super_assignment] = STATE(828),
    [sym_super_right_assignment] = STATE(828),
    [sym_right_assignment] = STATE(828),
    [sym_brace_list] = STATE(828),
    [sym_paren_list] = STATE(828),
    [sym_subset] = STATE(828),
    [sym_subset2] = STATE(828),
    [sym_dollar] = STATE(828),
    [sym_slot] = STATE(828),
    [sym_namespace_get] = STATE(828),
    [sym_namespace_get_internal] = STATE(828),
    [sym_pipe] = STATE(828),
    [sym_unary] = STATE(828),
    [sym_binary] = STATE(828),
    [sym_na] = STATE(828),
    [sym__expression] = STATE(828),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(828),
    [sym_string] = STATE(828),
    [anon_sym_SEMI] = ACTIONS(1703),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1705),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1705),
    [sym_next] = ACTIONS(1705),
    [sym_true] = ACTIONS(1705),
    [sym_false] = ACTIONS(1705),
    [sym_null] = ACTIONS(1705),
    [sym_inf] = ACTIONS(1705),
    [sym_nan] = ACTIONS(1705),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1703),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [295] = {
    [sym_function_definition] = STATE(809),
    [sym_lambda_function] = STATE(809),
    [sym_if] = STATE(809),
    [sym_while] = STATE(809),
    [sym_repeat] = STATE(809),
    [sym_for] = STATE(809),
    [sym_switch] = STATE(809),
    [sym_call] = STATE(809),
    [sym__assignment] = STATE(809),
    [sym_left_assignment] = STATE(809),
    [sym_left_assignment2] = STATE(809),
    [sym_equals_assignment] = STATE(809),
    [sym_super_assignment] = STATE(809),
    [sym_super_right_assignment] = STATE(809),
    [sym_right_assignment] = STATE(809),
    [sym_brace_list] = STATE(809),
    [sym_paren_list] = STATE(809),
    [sym_subset] = STATE(809),
    [sym_subset2] = STATE(809),
    [sym_dollar] = STATE(809),
    [sym_slot] = STATE(809),
    [sym_namespace_get] = STATE(809),
    [sym_namespace_get_internal] = STATE(809),
    [sym_pipe] = STATE(809),
    [sym_unary] = STATE(809),
    [sym_binary] = STATE(809),
    [sym_na] = STATE(809),
    [sym__expression] = STATE(809),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(809),
    [sym_string] = STATE(809),
    [anon_sym_SEMI] = ACTIONS(1707),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1709),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1709),
    [sym_next] = ACTIONS(1709),
    [sym_true] = ACTIONS(1709),
    [sym_false] = ACTIONS(1709),
    [sym_null] = ACTIONS(1709),
    [sym_inf] = ACTIONS(1709),
    [sym_nan] = ACTIONS(1709),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1707),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [296] = {
    [sym_function_definition] = STATE(820),
    [sym_lambda_function] = STATE(820),
    [sym_if] = STATE(820),
    [sym_while] = STATE(820),
    [sym_repeat] = STATE(820),
    [sym_for] = STATE(820),
    [sym_switch] = STATE(820),
    [sym_call] = STATE(820),
    [sym__assignment] = STATE(820),
    [sym_left_assignment] = STATE(820),
    [sym_left_assignment2] = STATE(820),
    [sym_equals_assignment] = STATE(820),
    [sym_super_assignment] = STATE(820),
    [sym_super_right_assignment] = STATE(820),
    [sym_right_assignment] = STATE(820),
    [sym_brace_list] = STATE(820),
    [sym_paren_list] = STATE(820),
    [sym_subset] = STATE(820),
    [sym_subset2] = STATE(820),
    [sym_dollar] = STATE(820),
    [sym_slot] = STATE(820),
    [sym_namespace_get] = STATE(820),
    [sym_namespace_get_internal] = STATE(820),
    [sym_pipe] = STATE(820),
    [sym_unary] = STATE(820),
    [sym_binary] = STATE(820),
    [sym_na] = STATE(820),
    [sym__expression] = STATE(820),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(820),
    [sym_string] = STATE(820),
    [anon_sym_SEMI] = ACTIONS(1711),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1713),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1713),
    [sym_next] = ACTIONS(1713),
    [sym_true] = ACTIONS(1713),
    [sym_false] = ACTIONS(1713),
    [sym_null] = ACTIONS(1713),
    [sym_inf] = ACTIONS(1713),
    [sym_nan] = ACTIONS(1713),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1711),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [297] = {
    [sym_function_definition] = STATE(819),
    [sym_lambda_function] = STATE(819),
    [sym_if] = STATE(819),
    [sym_while] = STATE(819),
    [sym_repeat] = STATE(819),
    [sym_for] = STATE(819),
    [sym_switch] = STATE(819),
    [sym_call] = STATE(819),
    [sym__assignment] = STATE(819),
    [sym_left_assignment] = STATE(819),
    [sym_left_assignment2] = STATE(819),
    [sym_equals_assignment] = STATE(819),
    [sym_super_assignment] = STATE(819),
    [sym_super_right_assignment] = STATE(819),
    [sym_right_assignment] = STATE(819),
    [sym_brace_list] = STATE(819),
    [sym_paren_list] = STATE(819),
    [sym_subset] = STATE(819),
    [sym_subset2] = STATE(819),
    [sym_dollar] = STATE(819),
    [sym_slot] = STATE(819),
    [sym_namespace_get] = STATE(819),
    [sym_namespace_get_internal] = STATE(819),
    [sym_pipe] = STATE(819),
    [sym_unary] = STATE(819),
    [sym_binary] = STATE(819),
    [sym_na] = STATE(819),
    [sym__expression] = STATE(819),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(819),
    [sym_string] = STATE(819),
    [anon_sym_SEMI] = ACTIONS(1715),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1717),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1717),
    [sym_next] = ACTIONS(1717),
    [sym_true] = ACTIONS(1717),
    [sym_false] = ACTIONS(1717),
    [sym_null] = ACTIONS(1717),
    [sym_inf] = ACTIONS(1717),
    [sym_nan] = ACTIONS(1717),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1715),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [298] = {
    [sym_function_definition] = STATE(818),
    [sym_lambda_function] = STATE(818),
    [sym_if] = STATE(818),
    [sym_while] = STATE(818),
    [sym_repeat] = STATE(818),
    [sym_for] = STATE(818),
    [sym_switch] = STATE(818),
    [sym_call] = STATE(818),
    [sym__assignment] = STATE(818),
    [sym_left_assignment] = STATE(818),
    [sym_left_assignment2] = STATE(818),
    [sym_equals_assignment] = STATE(818),
    [sym_super_assignment] = STATE(818),
    [sym_super_right_assignment] = STATE(818),
    [sym_right_assignment] = STATE(818),
    [sym_brace_list] = STATE(818),
    [sym_paren_list] = STATE(818),
    [sym_subset] = STATE(818),
    [sym_subset2] = STATE(818),
    [sym_dollar] = STATE(818),
    [sym_slot] = STATE(818),
    [sym_namespace_get] = STATE(818),
    [sym_namespace_get_internal] = STATE(818),
    [sym_pipe] = STATE(818),
    [sym_unary] = STATE(818),
    [sym_binary] = STATE(818),
    [sym_na] = STATE(818),
    [sym__expression] = STATE(818),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(818),
    [sym_string] = STATE(818),
    [anon_sym_SEMI] = ACTIONS(1719),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1721),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1721),
    [sym_next] = ACTIONS(1721),
    [sym_true] = ACTIONS(1721),
    [sym_false] = ACTIONS(1721),
    [sym_null] = ACTIONS(1721),
    [sym_inf] = ACTIONS(1721),
    [sym_nan] = ACTIONS(1721),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1719),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [299] = {
    [sym_function_definition] = STATE(817),
    [sym_lambda_function] = STATE(817),
    [sym_if] = STATE(817),
    [sym_while] = STATE(817),
    [sym_repeat] = STATE(817),
    [sym_for] = STATE(817),
    [sym_switch] = STATE(817),
    [sym_call] = STATE(817),
    [sym__assignment] = STATE(817),
    [sym_left_assignment] = STATE(817),
    [sym_left_assignment2] = STATE(817),
    [sym_equals_assignment] = STATE(817),
    [sym_super_assignment] = STATE(817),
    [sym_super_right_assignment] = STATE(817),
    [sym_right_assignment] = STATE(817),
    [sym_brace_list] = STATE(817),
    [sym_paren_list] = STATE(817),
    [sym_subset] = STATE(817),
    [sym_subset2] = STATE(817),
    [sym_dollar] = STATE(817),
    [sym_slot] = STATE(817),
    [sym_namespace_get] = STATE(817),
    [sym_namespace_get_internal] = STATE(817),
    [sym_pipe] = STATE(817),
    [sym_unary] = STATE(817),
    [sym_binary] = STATE(817),
    [sym_na] = STATE(817),
    [sym__expression] = STATE(817),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(817),
    [sym_string] = STATE(817),
    [anon_sym_SEMI] = ACTIONS(1723),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1725),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1725),
    [sym_next] = ACTIONS(1725),
    [sym_true] = ACTIONS(1725),
    [sym_false] = ACTIONS(1725),
    [sym_null] = ACTIONS(1725),
    [sym_inf] = ACTIONS(1725),
    [sym_nan] = ACTIONS(1725),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1723),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [300] = {
    [sym_function_definition] = STATE(816),
    [sym_lambda_function] = STATE(816),
    [sym_if] = STATE(816),
    [sym_while] = STATE(816),
    [sym_repeat] = STATE(816),
    [sym_for] = STATE(816),
    [sym_switch] = STATE(816),
    [sym_call] = STATE(816),
    [sym__assignment] = STATE(816),
    [sym_left_assignment] = STATE(816),
    [sym_left_assignment2] = STATE(816),
    [sym_equals_assignment] = STATE(816),
    [sym_super_assignment] = STATE(816),
    [sym_super_right_assignment] = STATE(816),
    [sym_right_assignment] = STATE(816),
    [sym_brace_list] = STATE(816),
    [sym_paren_list] = STATE(816),
    [sym_subset] = STATE(816),
    [sym_subset2] = STATE(816),
    [sym_dollar] = STATE(816),
    [sym_slot] = STATE(816),
    [sym_namespace_get] = STATE(816),
    [sym_namespace_get_internal] = STATE(816),
    [sym_pipe] = STATE(816),
    [sym_unary] = STATE(816),
    [sym_binary] = STATE(816),
    [sym_na] = STATE(816),
    [sym__expression] = STATE(816),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(816),
    [sym_string] = STATE(816),
    [anon_sym_SEMI] = ACTIONS(1727),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1729),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1729),
    [sym_next] = ACTIONS(1729),
    [sym_true] = ACTIONS(1729),
    [sym_false] = ACTIONS(1729),
    [sym_null] = ACTIONS(1729),
    [sym_inf] = ACTIONS(1729),
    [sym_nan] = ACTIONS(1729),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1727),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [301] = {
    [sym_function_definition] = STATE(801),
    [sym_lambda_function] = STATE(801),
    [sym_if] = STATE(801),
    [sym_while] = STATE(801),
    [sym_repeat] = STATE(801),
    [sym_for] = STATE(801),
    [sym_switch] = STATE(801),
    [sym_call] = STATE(801),
    [sym__assignment] = STATE(801),
    [sym_left_assignment] = STATE(801),
    [sym_left_assignment2] = STATE(801),
    [sym_equals_assignment] = STATE(801),
    [sym_super_assignment] = STATE(801),
    [sym_super_right_assignment] = STATE(801),
    [sym_right_assignment] = STATE(801),
    [sym_brace_list] = STATE(801),
    [sym_paren_list] = STATE(801),
    [sym_subset] = STATE(801),
    [sym_subset2] = STATE(801),
    [sym_dollar] = STATE(801),
    [sym_slot] = STATE(801),
    [sym_namespace_get] = STATE(801),
    [sym_namespace_get_internal] = STATE(801),
    [sym_pipe] = STATE(801),
    [sym_unary] = STATE(801),
    [sym_binary] = STATE(801),
    [sym_na] = STATE(801),
    [sym__expression] = STATE(801),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(801),
    [sym_string] = STATE(801),
    [anon_sym_SEMI] = ACTIONS(1731),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1733),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1733),
    [sym_next] = ACTIONS(1733),
    [sym_true] = ACTIONS(1733),
    [sym_false] = ACTIONS(1733),
    [sym_null] = ACTIONS(1733),
    [sym_inf] = ACTIONS(1733),
    [sym_nan] = ACTIONS(1733),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1731),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [302] = {
    [sym_function_definition] = STATE(814),
    [sym_lambda_function] = STATE(814),
    [sym_if] = STATE(814),
    [sym_while] = STATE(814),
    [sym_repeat] = STATE(814),
    [sym_for] = STATE(814),
    [sym_switch] = STATE(814),
    [sym_call] = STATE(814),
    [sym__assignment] = STATE(814),
    [sym_left_assignment] = STATE(814),
    [sym_left_assignment2] = STATE(814),
    [sym_equals_assignment] = STATE(814),
    [sym_super_assignment] = STATE(814),
    [sym_super_right_assignment] = STATE(814),
    [sym_right_assignment] = STATE(814),
    [sym_brace_list] = STATE(814),
    [sym_paren_list] = STATE(814),
    [sym_subset] = STATE(814),
    [sym_subset2] = STATE(814),
    [sym_dollar] = STATE(814),
    [sym_slot] = STATE(814),
    [sym_namespace_get] = STATE(814),
    [sym_namespace_get_internal] = STATE(814),
    [sym_pipe] = STATE(814),
    [sym_unary] = STATE(814),
    [sym_binary] = STATE(814),
    [sym_na] = STATE(814),
    [sym__expression] = STATE(814),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(814),
    [sym_string] = STATE(814),
    [anon_sym_SEMI] = ACTIONS(1735),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1737),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1737),
    [sym_next] = ACTIONS(1737),
    [sym_true] = ACTIONS(1737),
    [sym_false] = ACTIONS(1737),
    [sym_null] = ACTIONS(1737),
    [sym_inf] = ACTIONS(1737),
    [sym_nan] = ACTIONS(1737),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1735),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [303] = {
    [sym_function_definition] = STATE(813),
    [sym_lambda_function] = STATE(813),
    [sym_if] = STATE(813),
    [sym_while] = STATE(813),
    [sym_repeat] = STATE(813),
    [sym_for] = STATE(813),
    [sym_switch] = STATE(813),
    [sym_call] = STATE(813),
    [sym__assignment] = STATE(813),
    [sym_left_assignment] = STATE(813),
    [sym_left_assignment2] = STATE(813),
    [sym_equals_assignment] = STATE(813),
    [sym_super_assignment] = STATE(813),
    [sym_super_right_assignment] = STATE(813),
    [sym_right_assignment] = STATE(813),
    [sym_brace_list] = STATE(813),
    [sym_paren_list] = STATE(813),
    [sym_subset] = STATE(813),
    [sym_subset2] = STATE(813),
    [sym_dollar] = STATE(813),
    [sym_slot] = STATE(813),
    [sym_namespace_get] = STATE(813),
    [sym_namespace_get_internal] = STATE(813),
    [sym_pipe] = STATE(813),
    [sym_unary] = STATE(813),
    [sym_binary] = STATE(813),
    [sym_na] = STATE(813),
    [sym__expression] = STATE(813),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(813),
    [sym_string] = STATE(813),
    [anon_sym_SEMI] = ACTIONS(1739),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1741),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1741),
    [sym_next] = ACTIONS(1741),
    [sym_true] = ACTIONS(1741),
    [sym_false] = ACTIONS(1741),
    [sym_null] = ACTIONS(1741),
    [sym_inf] = ACTIONS(1741),
    [sym_nan] = ACTIONS(1741),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1739),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [304] = {
    [sym_function_definition] = STATE(812),
    [sym_lambda_function] = STATE(812),
    [sym_if] = STATE(812),
    [sym_while] = STATE(812),
    [sym_repeat] = STATE(812),
    [sym_for] = STATE(812),
    [sym_switch] = STATE(812),
    [sym_call] = STATE(812),
    [sym__assignment] = STATE(812),
    [sym_left_assignment] = STATE(812),
    [sym_left_assignment2] = STATE(812),
    [sym_equals_assignment] = STATE(812),
    [sym_super_assignment] = STATE(812),
    [sym_super_right_assignment] = STATE(812),
    [sym_right_assignment] = STATE(812),
    [sym_brace_list] = STATE(812),
    [sym_paren_list] = STATE(812),
    [sym_subset] = STATE(812),
    [sym_subset2] = STATE(812),
    [sym_dollar] = STATE(812),
    [sym_slot] = STATE(812),
    [sym_namespace_get] = STATE(812),
    [sym_namespace_get_internal] = STATE(812),
    [sym_pipe] = STATE(812),
    [sym_unary] = STATE(812),
    [sym_binary] = STATE(812),
    [sym_na] = STATE(812),
    [sym__expression] = STATE(812),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(812),
    [sym_string] = STATE(812),
    [anon_sym_SEMI] = ACTIONS(1743),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1745),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1745),
    [sym_next] = ACTIONS(1745),
    [sym_true] = ACTIONS(1745),
    [sym_false] = ACTIONS(1745),
    [sym_null] = ACTIONS(1745),
    [sym_inf] = ACTIONS(1745),
    [sym_nan] = ACTIONS(1745),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1743),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [305] = {
    [sym_function_definition] = STATE(811),
    [sym_lambda_function] = STATE(811),
    [sym_if] = STATE(811),
    [sym_while] = STATE(811),
    [sym_repeat] = STATE(811),
    [sym_for] = STATE(811),
    [sym_switch] = STATE(811),
    [sym_call] = STATE(811),
    [sym__assignment] = STATE(811),
    [sym_left_assignment] = STATE(811),
    [sym_left_assignment2] = STATE(811),
    [sym_equals_assignment] = STATE(811),
    [sym_super_assignment] = STATE(811),
    [sym_super_right_assignment] = STATE(811),
    [sym_right_assignment] = STATE(811),
    [sym_brace_list] = STATE(811),
    [sym_paren_list] = STATE(811),
    [sym_subset] = STATE(811),
    [sym_subset2] = STATE(811),
    [sym_dollar] = STATE(811),
    [sym_slot] = STATE(811),
    [sym_namespace_get] = STATE(811),
    [sym_namespace_get_internal] = STATE(811),
    [sym_pipe] = STATE(811),
    [sym_unary] = STATE(811),
    [sym_binary] = STATE(811),
    [sym_na] = STATE(811),
    [sym__expression] = STATE(811),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(811),
    [sym_string] = STATE(811),
    [anon_sym_SEMI] = ACTIONS(1747),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1749),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1749),
    [sym_next] = ACTIONS(1749),
    [sym_true] = ACTIONS(1749),
    [sym_false] = ACTIONS(1749),
    [sym_null] = ACTIONS(1749),
    [sym_inf] = ACTIONS(1749),
    [sym_nan] = ACTIONS(1749),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1747),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [306] = {
    [sym_function_definition] = STATE(800),
    [sym_lambda_function] = STATE(800),
    [sym_if] = STATE(800),
    [sym_while] = STATE(800),
    [sym_repeat] = STATE(800),
    [sym_for] = STATE(800),
    [sym_switch] = STATE(800),
    [sym_call] = STATE(800),
    [sym__assignment] = STATE(800),
    [sym_left_assignment] = STATE(800),
    [sym_left_assignment2] = STATE(800),
    [sym_equals_assignment] = STATE(800),
    [sym_super_assignment] = STATE(800),
    [sym_super_right_assignment] = STATE(800),
    [sym_right_assignment] = STATE(800),
    [sym_brace_list] = STATE(800),
    [sym_paren_list] = STATE(800),
    [sym_subset] = STATE(800),
    [sym_subset2] = STATE(800),
    [sym_dollar] = STATE(800),
    [sym_slot] = STATE(800),
    [sym_namespace_get] = STATE(800),
    [sym_namespace_get_internal] = STATE(800),
    [sym_pipe] = STATE(800),
    [sym_unary] = STATE(800),
    [sym_binary] = STATE(800),
    [sym_na] = STATE(800),
    [sym__expression] = STATE(800),
    [sym_identifier] = STATE(799),
    [sym_complex] = STATE(800),
    [sym_string] = STATE(800),
    [anon_sym_SEMI] = ACTIONS(1751),
    [anon_sym_function] = ACTIONS(947),
    [anon_sym_BSLASH] = ACTIONS(949),
    [anon_sym_if] = ACTIONS(951),
    [anon_sym_LPAREN] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(955),
    [anon_sym_repeat] = ACTIONS(957),
    [anon_sym_for] = ACTIONS(959),
    [anon_sym_switch] = ACTIONS(961),
    [anon_sym_LBRACE] = ACTIONS(963),
    [sym_dots] = ACTIONS(1753),
    [anon_sym_DASH] = ACTIONS(967),
    [anon_sym_PLUS] = ACTIONS(967),
    [anon_sym_BANG] = ACTIONS(969),
    [anon_sym_TILDE] = ACTIONS(971),
    [sym_break] = ACTIONS(1753),
    [sym_next] = ACTIONS(1753),
    [sym_true] = ACTIONS(1753),
    [sym_false] = ACTIONS(1753),
    [sym_null] = ACTIONS(1753),
    [sym_inf] = ACTIONS(1753),
    [sym_nan] = ACTIONS(1753),
    [anon_sym_NA] = ACTIONS(973),
    [anon_sym_NA_character_] = ACTIONS(973),
    [anon_sym_NA_complex_] = ACTIONS(973),
    [anon_sym_NA_integer_] = ACTIONS(973),
    [anon_sym_NA_real_] = ACTIONS(973),
    [aux_sym_identifier_token1] = ACTIONS(975),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [sym_integer] = ACTIONS(1751),
    [sym_float] = ACTIONS(979),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(981),
    [anon_sym_SQUOTE] = ACTIONS(983),
  },
  [307] = {
    [sym_function_definition] = STATE(491),
    [sym_lambda_function] = STATE(491),
    [sym_if] = STATE(491),
    [sym_while] = STATE(491),
    [sym_repeat] = STATE(491),
    [sym_for] = STATE(491),
    [sym_switch] = STATE(491),
    [sym_call] = STATE(491),
    [sym__assignment] = STATE(491),
    [sym_left_assignment] = STATE(491),
    [sym_left_assignment2] = STATE(491),
    [sym_equals_assignment] = STATE(491),
    [sym_super_assignment] = STATE(491),
    [sym_super_right_assignment] = STATE(491),
    [sym_right_assignment] = STATE(491),
    [sym_brace_list] = STATE(491),
    [sym_paren_list] = STATE(491),
    [sym_subset] = STATE(491),
    [sym_subset2] = STATE(491),
    [sym_dollar] = STATE(491),
    [sym_slot] = STATE(491),
    [sym_namespace_get] = STATE(491),
    [sym_namespace_get_internal] = STATE(491),
    [sym_pipe] = STATE(491),
    [sym_unary] = STATE(491),
    [sym_binary] = STATE(491),
    [sym_na] = STATE(491),
    [sym__expression] = STATE(491),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(491),
    [sym_string] = STATE(491),
    [anon_sym_SEMI] = ACTIONS(1755),
    [anon_sym_function] = ACTIONS(95),
    [anon_sym_BSLASH] = ACTIONS(97),
    [anon_sym_if] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(105),
    [anon_sym_repeat] = ACTIONS(107),
    [anon_sym_for] = ACTIONS(109),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1757),
    [anon_sym_DASH] = ACTIONS(119),
    [anon_sym_PLUS] = ACTIONS(119),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_TILDE] = ACTIONS(123),
    [sym_break] = ACTIONS(1757),
    [sym_next] = ACTIONS(1757),
    [sym_true] = ACTIONS(1757),
    [sym_false] = ACTIONS(1757),
    [sym_null] = ACTIONS(1757),
    [sym_inf] = ACTIONS(1757),
    [sym_nan] = ACTIONS(1757),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1755),
    [sym_float] = ACTIONS(133),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [308] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1759),
    [anon_sym_function] = ACTIONS(1761),
    [anon_sym_BSLASH] = ACTIONS(1759),
    [anon_sym_if] = ACTIONS(1761),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1759),
    [anon_sym_else] = ACTIONS(1761),
    [anon_sym_while] = ACTIONS(1761),
    [anon_sym_repeat] = ACTIONS(1761),
    [anon_sym_for] = ACTIONS(1761),
    [anon_sym_switch] = ACTIONS(1761),
    [anon_sym_COMMA] = ACTIONS(1759),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1759),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1759),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1761),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1761),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1761),
    [sym_next] = ACTIONS(1761),
    [sym_true] = ACTIONS(1761),
    [sym_false] = ACTIONS(1761),
    [sym_null] = ACTIONS(1761),
    [sym_inf] = ACTIONS(1761),
    [sym_nan] = ACTIONS(1761),
    [anon_sym_NA] = ACTIONS(1761),
    [anon_sym_NA_character_] = ACTIONS(1761),
    [anon_sym_NA_complex_] = ACTIONS(1761),
    [anon_sym_NA_integer_] = ACTIONS(1761),
    [anon_sym_NA_real_] = ACTIONS(1761),
    [aux_sym_identifier_token1] = ACTIONS(1761),
    [anon_sym_BQUOTE] = ACTIONS(1759),
    [sym_integer] = ACTIONS(1759),
    [sym_float] = ACTIONS(1761),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1759),
    [anon_sym_SQUOTE] = ACTIONS(1759),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [309] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1763),
    [anon_sym_function] = ACTIONS(1765),
    [anon_sym_BSLASH] = ACTIONS(1763),
    [anon_sym_if] = ACTIONS(1765),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1763),
    [anon_sym_else] = ACTIONS(1765),
    [anon_sym_while] = ACTIONS(1765),
    [anon_sym_repeat] = ACTIONS(1765),
    [anon_sym_for] = ACTIONS(1765),
    [anon_sym_switch] = ACTIONS(1765),
    [anon_sym_COMMA] = ACTIONS(1763),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1763),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1763),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1765),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1765),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1765),
    [sym_next] = ACTIONS(1765),
    [sym_true] = ACTIONS(1765),
    [sym_false] = ACTIONS(1765),
    [sym_null] = ACTIONS(1765),
    [sym_inf] = ACTIONS(1765),
    [sym_nan] = ACTIONS(1765),
    [anon_sym_NA] = ACTIONS(1765),
    [anon_sym_NA_character_] = ACTIONS(1765),
    [anon_sym_NA_complex_] = ACTIONS(1765),
    [anon_sym_NA_integer_] = ACTIONS(1765),
    [anon_sym_NA_real_] = ACTIONS(1765),
    [aux_sym_identifier_token1] = ACTIONS(1765),
    [anon_sym_BQUOTE] = ACTIONS(1763),
    [sym_integer] = ACTIONS(1763),
    [sym_float] = ACTIONS(1765),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1763),
    [anon_sym_SQUOTE] = ACTIONS(1763),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [310] = {
    [sym_function_definition] = STATE(308),
    [sym_lambda_function] = STATE(308),
    [sym_if] = STATE(308),
    [sym_while] = STATE(308),
    [sym_repeat] = STATE(308),
    [sym_for] = STATE(308),
    [sym_switch] = STATE(308),
    [sym_call] = STATE(308),
    [sym__assignment] = STATE(308),
    [sym_left_assignment] = STATE(308),
    [sym_left_assignment2] = STATE(308),
    [sym_equals_assignment] = STATE(308),
    [sym_super_assignment] = STATE(308),
    [sym_super_right_assignment] = STATE(308),
    [sym_right_assignment] = STATE(308),
    [sym_brace_list] = STATE(308),
    [sym_paren_list] = STATE(308),
    [sym_subset] = STATE(308),
    [sym_subset2] = STATE(308),
    [sym_dollar] = STATE(308),
    [sym_slot] = STATE(308),
    [sym_namespace_get] = STATE(308),
    [sym_namespace_get_internal] = STATE(308),
    [sym_pipe] = STATE(308),
    [sym_unary] = STATE(308),
    [sym_binary] = STATE(308),
    [sym_na] = STATE(308),
    [sym__expression] = STATE(308),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(308),
    [sym_string] = STATE(308),
    [anon_sym_SEMI] = ACTIONS(1767),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1769),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1769),
    [sym_next] = ACTIONS(1769),
    [sym_true] = ACTIONS(1769),
    [sym_false] = ACTIONS(1769),
    [sym_null] = ACTIONS(1769),
    [sym_inf] = ACTIONS(1769),
    [sym_nan] = ACTIONS(1769),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1767),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [311] = {
    [sym_function_definition] = STATE(309),
    [sym_lambda_function] = STATE(309),
    [sym_if] = STATE(309),
    [sym_while] = STATE(309),
    [sym_repeat] = STATE(309),
    [sym_for] = STATE(309),
    [sym_switch] = STATE(309),
    [sym_call] = STATE(309),
    [sym__assignment] = STATE(309),
    [sym_left_assignment] = STATE(309),
    [sym_left_assignment2] = STATE(309),
    [sym_equals_assignment] = STATE(309),
    [sym_super_assignment] = STATE(309),
    [sym_super_right_assignment] = STATE(309),
    [sym_right_assignment] = STATE(309),
    [sym_brace_list] = STATE(309),
    [sym_paren_list] = STATE(309),
    [sym_subset] = STATE(309),
    [sym_subset2] = STATE(309),
    [sym_dollar] = STATE(309),
    [sym_slot] = STATE(309),
    [sym_namespace_get] = STATE(309),
    [sym_namespace_get_internal] = STATE(309),
    [sym_pipe] = STATE(309),
    [sym_unary] = STATE(309),
    [sym_binary] = STATE(309),
    [sym_na] = STATE(309),
    [sym__expression] = STATE(309),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(309),
    [sym_string] = STATE(309),
    [anon_sym_SEMI] = ACTIONS(1771),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1773),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1773),
    [sym_next] = ACTIONS(1773),
    [sym_true] = ACTIONS(1773),
    [sym_false] = ACTIONS(1773),
    [sym_null] = ACTIONS(1773),
    [sym_inf] = ACTIONS(1773),
    [sym_nan] = ACTIONS(1773),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1771),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [312] = {
    [sym_function_definition] = STATE(618),
    [sym_lambda_function] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_repeat] = STATE(618),
    [sym_for] = STATE(618),
    [sym_switch] = STATE(618),
    [sym_call] = STATE(618),
    [sym__assignment] = STATE(618),
    [sym_left_assignment] = STATE(618),
    [sym_left_assignment2] = STATE(618),
    [sym_equals_assignment] = STATE(618),
    [sym_super_assignment] = STATE(618),
    [sym_super_right_assignment] = STATE(618),
    [sym_right_assignment] = STATE(618),
    [sym_brace_list] = STATE(618),
    [sym_paren_list] = STATE(618),
    [sym_subset] = STATE(618),
    [sym_subset2] = STATE(618),
    [sym_dollar] = STATE(618),
    [sym_slot] = STATE(618),
    [sym_namespace_get] = STATE(618),
    [sym_namespace_get_internal] = STATE(618),
    [sym_pipe] = STATE(618),
    [sym_unary] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_na] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(618),
    [sym_string] = STATE(618),
    [anon_sym_SEMI] = ACTIONS(1775),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1777),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1777),
    [sym_next] = ACTIONS(1777),
    [sym_true] = ACTIONS(1777),
    [sym_false] = ACTIONS(1777),
    [sym_null] = ACTIONS(1777),
    [sym_inf] = ACTIONS(1777),
    [sym_nan] = ACTIONS(1777),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1775),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [313] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1779),
    [anon_sym_function] = ACTIONS(1781),
    [anon_sym_BSLASH] = ACTIONS(1779),
    [anon_sym_if] = ACTIONS(1781),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1779),
    [anon_sym_else] = ACTIONS(1781),
    [anon_sym_while] = ACTIONS(1781),
    [anon_sym_repeat] = ACTIONS(1781),
    [anon_sym_for] = ACTIONS(1781),
    [anon_sym_switch] = ACTIONS(1781),
    [anon_sym_COMMA] = ACTIONS(1779),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1779),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1779),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1781),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1781),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1781),
    [sym_next] = ACTIONS(1781),
    [sym_true] = ACTIONS(1781),
    [sym_false] = ACTIONS(1781),
    [sym_null] = ACTIONS(1781),
    [sym_inf] = ACTIONS(1781),
    [sym_nan] = ACTIONS(1781),
    [anon_sym_NA] = ACTIONS(1781),
    [anon_sym_NA_character_] = ACTIONS(1781),
    [anon_sym_NA_complex_] = ACTIONS(1781),
    [anon_sym_NA_integer_] = ACTIONS(1781),
    [anon_sym_NA_real_] = ACTIONS(1781),
    [aux_sym_identifier_token1] = ACTIONS(1781),
    [anon_sym_BQUOTE] = ACTIONS(1779),
    [sym_integer] = ACTIONS(1779),
    [sym_float] = ACTIONS(1781),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1779),
    [anon_sym_SQUOTE] = ACTIONS(1779),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [314] = {
    [sym_function_definition] = STATE(313),
    [sym_lambda_function] = STATE(313),
    [sym_if] = STATE(313),
    [sym_while] = STATE(313),
    [sym_repeat] = STATE(313),
    [sym_for] = STATE(313),
    [sym_switch] = STATE(313),
    [sym_call] = STATE(313),
    [sym__assignment] = STATE(313),
    [sym_left_assignment] = STATE(313),
    [sym_left_assignment2] = STATE(313),
    [sym_equals_assignment] = STATE(313),
    [sym_super_assignment] = STATE(313),
    [sym_super_right_assignment] = STATE(313),
    [sym_right_assignment] = STATE(313),
    [sym_brace_list] = STATE(313),
    [sym_paren_list] = STATE(313),
    [sym_subset] = STATE(313),
    [sym_subset2] = STATE(313),
    [sym_dollar] = STATE(313),
    [sym_slot] = STATE(313),
    [sym_namespace_get] = STATE(313),
    [sym_namespace_get_internal] = STATE(313),
    [sym_pipe] = STATE(313),
    [sym_unary] = STATE(313),
    [sym_binary] = STATE(313),
    [sym_na] = STATE(313),
    [sym__expression] = STATE(313),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(313),
    [sym_string] = STATE(313),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1785),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1785),
    [sym_next] = ACTIONS(1785),
    [sym_true] = ACTIONS(1785),
    [sym_false] = ACTIONS(1785),
    [sym_null] = ACTIONS(1785),
    [sym_inf] = ACTIONS(1785),
    [sym_nan] = ACTIONS(1785),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1783),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [315] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_PLUS] = ACTIONS(1787),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1787),
    [anon_sym_SLASH] = ACTIONS(1787),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1787),
  },
  [316] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_PLUS] = ACTIONS(1787),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1787),
    [anon_sym_SLASH] = ACTIONS(1787),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1789),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1787),
  },
  [317] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [318] = {
    [sym_function_definition] = STATE(600),
    [sym_lambda_function] = STATE(600),
    [sym_if] = STATE(600),
    [sym_while] = STATE(600),
    [sym_repeat] = STATE(600),
    [sym_for] = STATE(600),
    [sym_switch] = STATE(600),
    [sym_call] = STATE(600),
    [sym__assignment] = STATE(600),
    [sym_left_assignment] = STATE(600),
    [sym_left_assignment2] = STATE(600),
    [sym_equals_assignment] = STATE(600),
    [sym_super_assignment] = STATE(600),
    [sym_super_right_assignment] = STATE(600),
    [sym_right_assignment] = STATE(600),
    [sym_brace_list] = STATE(600),
    [sym_paren_list] = STATE(600),
    [sym_subset] = STATE(600),
    [sym_subset2] = STATE(600),
    [sym_dollar] = STATE(600),
    [sym_slot] = STATE(600),
    [sym_namespace_get] = STATE(600),
    [sym_namespace_get_internal] = STATE(600),
    [sym_pipe] = STATE(600),
    [sym_unary] = STATE(600),
    [sym_binary] = STATE(600),
    [sym_na] = STATE(600),
    [sym__expression] = STATE(600),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(600),
    [sym_string] = STATE(600),
    [anon_sym_SEMI] = ACTIONS(1791),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1793),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1793),
    [sym_next] = ACTIONS(1793),
    [sym_true] = ACTIONS(1793),
    [sym_false] = ACTIONS(1793),
    [sym_null] = ACTIONS(1793),
    [sym_inf] = ACTIONS(1793),
    [sym_nan] = ACTIONS(1793),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1791),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [319] = {
    [sym_function_definition] = STATE(599),
    [sym_lambda_function] = STATE(599),
    [sym_if] = STATE(599),
    [sym_while] = STATE(599),
    [sym_repeat] = STATE(599),
    [sym_for] = STATE(599),
    [sym_switch] = STATE(599),
    [sym_call] = STATE(599),
    [sym__assignment] = STATE(599),
    [sym_left_assignment] = STATE(599),
    [sym_left_assignment2] = STATE(599),
    [sym_equals_assignment] = STATE(599),
    [sym_super_assignment] = STATE(599),
    [sym_super_right_assignment] = STATE(599),
    [sym_right_assignment] = STATE(599),
    [sym_brace_list] = STATE(599),
    [sym_paren_list] = STATE(599),
    [sym_subset] = STATE(599),
    [sym_subset2] = STATE(599),
    [sym_dollar] = STATE(599),
    [sym_slot] = STATE(599),
    [sym_namespace_get] = STATE(599),
    [sym_namespace_get_internal] = STATE(599),
    [sym_pipe] = STATE(599),
    [sym_unary] = STATE(599),
    [sym_binary] = STATE(599),
    [sym_na] = STATE(599),
    [sym__expression] = STATE(599),
    [sym_identifier] = STATE(501),
    [sym_complex] = STATE(599),
    [sym_string] = STATE(599),
    [anon_sym_SEMI] = ACTIONS(1795),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_BSLASH] = ACTIONS(337),
    [anon_sym_if] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(341),
    [anon_sym_while] = ACTIONS(343),
    [anon_sym_repeat] = ACTIONS(345),
    [anon_sym_for] = ACTIONS(347),
    [anon_sym_switch] = ACTIONS(349),
    [anon_sym_LBRACE] = ACTIONS(351),
    [sym_dots] = ACTIONS(1797),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_TILDE] = ACTIONS(361),
    [sym_break] = ACTIONS(1797),
    [sym_next] = ACTIONS(1797),
    [sym_true] = ACTIONS(1797),
    [sym_false] = ACTIONS(1797),
    [sym_null] = ACTIONS(1797),
    [sym_inf] = ACTIONS(1797),
    [sym_nan] = ACTIONS(1797),
    [anon_sym_NA] = ACTIONS(363),
    [anon_sym_NA_character_] = ACTIONS(363),
    [anon_sym_NA_complex_] = ACTIONS(363),
    [anon_sym_NA_integer_] = ACTIONS(363),
    [anon_sym_NA_real_] = ACTIONS(363),
    [aux_sym_identifier_token1] = ACTIONS(365),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_integer] = ACTIONS(1795),
    [sym_float] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(373),
  },
  [320] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [321] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [322] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_PLUS] = ACTIONS(1787),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1787),
    [anon_sym_SLASH] = ACTIONS(1787),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1789),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1787),
  },
  [323] = {
    [sym_function_definition] = STATE(624),
    [sym_lambda_function] = STATE(624),
    [sym_if] = STATE(624),
    [sym_while] = STATE(624),
    [sym_repeat] = STATE(624),
    [sym_for] = STATE(624),
    [sym_switch] = STATE(624),
    [sym_call] = STATE(624),
    [sym__assignment] = STATE(624),
    [sym_left_assignment] = STATE(624),
    [sym_left_assignment2] = STATE(624),
    [sym_equals_assignment] = STATE(624),
    [sym_super_assignment] = STATE(624),
    [sym_super_right_assignment] = STATE(624),
    [sym_right_assignment] = STATE(624),
    [sym_brace_list] = STATE(624),
    [sym_paren_list] = STATE(624),
    [sym_subset] = STATE(624),
    [sym_subset2] = STATE(624),
    [sym_dollar] = STATE(624),
    [sym_slot] = STATE(624),
    [sym_namespace_get] = STATE(624),
    [sym_namespace_get_internal] = STATE(624),
    [sym_pipe] = STATE(624),
    [sym_unary] = STATE(624),
    [sym_binary] = STATE(624),
    [sym_na] = STATE(624),
    [sym__expression] = STATE(624),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(624),
    [sym_string] = STATE(624),
    [anon_sym_SEMI] = ACTIONS(1799),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1801),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1801),
    [sym_next] = ACTIONS(1801),
    [sym_true] = ACTIONS(1801),
    [sym_false] = ACTIONS(1801),
    [sym_null] = ACTIONS(1801),
    [sym_inf] = ACTIONS(1801),
    [sym_nan] = ACTIONS(1801),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1799),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [324] = {
    [sym_function_definition] = STATE(626),
    [sym_lambda_function] = STATE(626),
    [sym_if] = STATE(626),
    [sym_while] = STATE(626),
    [sym_repeat] = STATE(626),
    [sym_for] = STATE(626),
    [sym_switch] = STATE(626),
    [sym_call] = STATE(626),
    [sym__assignment] = STATE(626),
    [sym_left_assignment] = STATE(626),
    [sym_left_assignment2] = STATE(626),
    [sym_equals_assignment] = STATE(626),
    [sym_super_assignment] = STATE(626),
    [sym_super_right_assignment] = STATE(626),
    [sym_right_assignment] = STATE(626),
    [sym_brace_list] = STATE(626),
    [sym_paren_list] = STATE(626),
    [sym_subset] = STATE(626),
    [sym_subset2] = STATE(626),
    [sym_dollar] = STATE(626),
    [sym_slot] = STATE(626),
    [sym_namespace_get] = STATE(626),
    [sym_namespace_get_internal] = STATE(626),
    [sym_pipe] = STATE(626),
    [sym_unary] = STATE(626),
    [sym_binary] = STATE(626),
    [sym_na] = STATE(626),
    [sym__expression] = STATE(626),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(626),
    [sym_string] = STATE(626),
    [anon_sym_SEMI] = ACTIONS(1803),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1805),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1805),
    [sym_next] = ACTIONS(1805),
    [sym_true] = ACTIONS(1805),
    [sym_false] = ACTIONS(1805),
    [sym_null] = ACTIONS(1805),
    [sym_inf] = ACTIONS(1805),
    [sym_nan] = ACTIONS(1805),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1803),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [325] = {
    [sym_function_definition] = STATE(627),
    [sym_lambda_function] = STATE(627),
    [sym_if] = STATE(627),
    [sym_while] = STATE(627),
    [sym_repeat] = STATE(627),
    [sym_for] = STATE(627),
    [sym_switch] = STATE(627),
    [sym_call] = STATE(627),
    [sym__assignment] = STATE(627),
    [sym_left_assignment] = STATE(627),
    [sym_left_assignment2] = STATE(627),
    [sym_equals_assignment] = STATE(627),
    [sym_super_assignment] = STATE(627),
    [sym_super_right_assignment] = STATE(627),
    [sym_right_assignment] = STATE(627),
    [sym_brace_list] = STATE(627),
    [sym_paren_list] = STATE(627),
    [sym_subset] = STATE(627),
    [sym_subset2] = STATE(627),
    [sym_dollar] = STATE(627),
    [sym_slot] = STATE(627),
    [sym_namespace_get] = STATE(627),
    [sym_namespace_get_internal] = STATE(627),
    [sym_pipe] = STATE(627),
    [sym_unary] = STATE(627),
    [sym_binary] = STATE(627),
    [sym_na] = STATE(627),
    [sym__expression] = STATE(627),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(627),
    [sym_string] = STATE(627),
    [anon_sym_SEMI] = ACTIONS(1807),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1809),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1809),
    [sym_next] = ACTIONS(1809),
    [sym_true] = ACTIONS(1809),
    [sym_false] = ACTIONS(1809),
    [sym_null] = ACTIONS(1809),
    [sym_inf] = ACTIONS(1809),
    [sym_nan] = ACTIONS(1809),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1807),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [326] = {
    [sym_function_definition] = STATE(628),
    [sym_lambda_function] = STATE(628),
    [sym_if] = STATE(628),
    [sym_while] = STATE(628),
    [sym_repeat] = STATE(628),
    [sym_for] = STATE(628),
    [sym_switch] = STATE(628),
    [sym_call] = STATE(628),
    [sym__assignment] = STATE(628),
    [sym_left_assignment] = STATE(628),
    [sym_left_assignment2] = STATE(628),
    [sym_equals_assignment] = STATE(628),
    [sym_super_assignment] = STATE(628),
    [sym_super_right_assignment] = STATE(628),
    [sym_right_assignment] = STATE(628),
    [sym_brace_list] = STATE(628),
    [sym_paren_list] = STATE(628),
    [sym_subset] = STATE(628),
    [sym_subset2] = STATE(628),
    [sym_dollar] = STATE(628),
    [sym_slot] = STATE(628),
    [sym_namespace_get] = STATE(628),
    [sym_namespace_get_internal] = STATE(628),
    [sym_pipe] = STATE(628),
    [sym_unary] = STATE(628),
    [sym_binary] = STATE(628),
    [sym_na] = STATE(628),
    [sym__expression] = STATE(628),
    [sym_identifier] = STATE(433),
    [sym_complex] = STATE(628),
    [sym_string] = STATE(628),
    [anon_sym_SEMI] = ACTIONS(1811),
    [anon_sym_function] = ACTIONS(49),
    [anon_sym_BSLASH] = ACTIONS(51),
    [anon_sym_if] = ACTIONS(53),
    [anon_sym_LPAREN] = ACTIONS(55),
    [anon_sym_while] = ACTIONS(57),
    [anon_sym_repeat] = ACTIONS(59),
    [anon_sym_for] = ACTIONS(61),
    [anon_sym_switch] = ACTIONS(63),
    [anon_sym_LBRACE] = ACTIONS(67),
    [sym_dots] = ACTIONS(1813),
    [anon_sym_DASH] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(77),
    [sym_break] = ACTIONS(1813),
    [sym_next] = ACTIONS(1813),
    [sym_true] = ACTIONS(1813),
    [sym_false] = ACTIONS(1813),
    [sym_null] = ACTIONS(1813),
    [sym_inf] = ACTIONS(1813),
    [sym_nan] = ACTIONS(1813),
    [anon_sym_NA] = ACTIONS(81),
    [anon_sym_NA_character_] = ACTIONS(81),
    [anon_sym_NA_complex_] = ACTIONS(81),
    [anon_sym_NA_integer_] = ACTIONS(81),
    [anon_sym_NA_real_] = ACTIONS(81),
    [aux_sym_identifier_token1] = ACTIONS(83),
    [anon_sym_BQUOTE] = ACTIONS(85),
    [sym_integer] = ACTIONS(1811),
    [sym_float] = ACTIONS(87),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_SQUOTE] = ACTIONS(91),
  },
  [327] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_PLUS] = ACTIONS(1787),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1787),
    [anon_sym_SLASH] = ACTIONS(1787),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [328] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [329] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1787),
    [anon_sym_function] = ACTIONS(1789),
    [anon_sym_BSLASH] = ACTIONS(1787),
    [anon_sym_if] = ACTIONS(1789),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1787),
    [anon_sym_else] = ACTIONS(1789),
    [anon_sym_while] = ACTIONS(1789),
    [anon_sym_repeat] = ACTIONS(1789),
    [anon_sym_for] = ACTIONS(1789),
    [anon_sym_switch] = ACTIONS(1789),
    [anon_sym_COMMA] = ACTIONS(1787),
    [anon_sym_EQ] = ACTIONS(1789),
    [anon_sym_LBRACE] = ACTIONS(1787),
    [anon_sym_LT_DASH] = ACTIONS(1787),
    [anon_sym_COLON_EQ] = ACTIONS(1787),
    [anon_sym_LT_LT_DASH] = ACTIONS(1787),
    [anon_sym_DASH_GT_GT] = ACTIONS(1787),
    [anon_sym_DASH_GT] = ACTIONS(1789),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1787),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1789),
    [anon_sym_PIPE_GT] = ACTIONS(1787),
    [anon_sym_DASH] = ACTIONS(1789),
    [anon_sym_PLUS] = ACTIONS(1787),
    [anon_sym_BANG] = ACTIONS(1789),
    [anon_sym_TILDE] = ACTIONS(1787),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1789),
    [anon_sym_GT] = ACTIONS(1789),
    [anon_sym_LT_EQ] = ACTIONS(1787),
    [anon_sym_GT_EQ] = ACTIONS(1787),
    [anon_sym_EQ_EQ] = ACTIONS(1787),
    [anon_sym_BANG_EQ] = ACTIONS(1787),
    [anon_sym_PIPE_PIPE] = ACTIONS(1787),
    [anon_sym_PIPE] = ACTIONS(1789),
    [anon_sym_AMP_AMP] = ACTIONS(1787),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1789),
    [sym_next] = ACTIONS(1789),
    [sym_true] = ACTIONS(1789),
    [sym_false] = ACTIONS(1789),
    [sym_null] = ACTIONS(1789),
    [sym_inf] = ACTIONS(1789),
    [sym_nan] = ACTIONS(1789),
    [anon_sym_NA] = ACTIONS(1789),
    [anon_sym_NA_character_] = ACTIONS(1789),
    [anon_sym_NA_complex_] = ACTIONS(1789),
    [anon_sym_NA_integer_] = ACTIONS(1789),
    [anon_sym_NA_real_] = ACTIONS(1789),
    [aux_sym_identifier_token1] = ACTIONS(1789),
    [anon_sym_BQUOTE] = ACTIONS(1787),
    [sym_integer] = ACTIONS(1787),
    [sym_float] = ACTIONS(1789),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1787),
    [anon_sym_SQUOTE] = ACTIONS(1787),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [330] = {
    [ts_builtin_sym_end] = ACTIONS(635),
    [anon_sym_LF] = ACTIONS(637),
    [anon_sym_SEMI] = ACTIONS(637),
    [anon_sym_function] = ACTIONS(637),
    [anon_sym_BSLASH] = ACTIONS(637),
    [anon_sym_if] = ACTIONS(637),
    [anon_sym_LPAREN] = ACTIONS(637),
    [anon_sym_else] = ACTIONS(637),
    [anon_sym_while] = ACTIONS(637),
    [anon_sym_repeat] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(637),
    [anon_sym_switch] = ACTIONS(637),
    [anon_sym_EQ] = ACTIONS(637),
    [anon_sym_LBRACE] = ACTIONS(637),
    [anon_sym_LT_DASH] = ACTIONS(637),
    [anon_sym_COLON_EQ] = ACTIONS(637),
    [anon_sym_LT_LT_DASH] = ACTIONS(637),
    [anon_sym_DASH_GT_GT] = ACTIONS(637),
    [anon_sym_DASH_GT] = ACTIONS(637),
    [anon_sym_LBRACK] = ACTIONS(637),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(637),
    [anon_sym_DOLLAR] = ACTIONS(637),
    [anon_sym_AT] = ACTIONS(637),
    [anon_sym_COLON_COLON] = ACTIONS(1815),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1817),
    [sym_dots] = ACTIONS(637),
    [anon_sym_PIPE_GT] = ACTIONS(637),
    [anon_sym_DASH] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(637),
    [anon_sym_BANG] = ACTIONS(637),
    [anon_sym_TILDE] = ACTIONS(637),
    [anon_sym_STAR] = ACTIONS(637),
    [anon_sym_SLASH] = ACTIONS(637),
    [anon_sym_CARET] = ACTIONS(637),
    [anon_sym_LT] = ACTIONS(637),
    [anon_sym_GT] = ACTIONS(637),
    [anon_sym_LT_EQ] = ACTIONS(637),
    [anon_sym_GT_EQ] = ACTIONS(637),
    [anon_sym_EQ_EQ] = ACTIONS(637),
    [anon_sym_BANG_EQ] = ACTIONS(637),
    [anon_sym_PIPE_PIPE] = ACTIONS(637),
    [anon_sym_PIPE] = ACTIONS(637),
    [anon_sym_AMP_AMP] = ACTIONS(637),
    [anon_sym_AMP] = ACTIONS(637),
    [anon_sym_COLON] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_true] = ACTIONS(637),
    [sym_false] = ACTIONS(637),
    [sym_null] = ACTIONS(637),
    [sym_inf] = ACTIONS(637),
    [sym_nan] = ACTIONS(637),
    [anon_sym_NA] = ACTIONS(637),
    [anon_sym_NA_character_] = ACTIONS(637),
    [anon_sym_NA_complex_] = ACTIONS(637),
    [anon_sym_NA_integer_] = ACTIONS(637),
    [anon_sym_NA_real_] = ACTIONS(637),
    [aux_sym_identifier_token1] = ACTIONS(637),
    [anon_sym_BQUOTE] = ACTIONS(637),
    [sym_integer] = ACTIONS(637),
    [sym_float] = ACTIONS(637),
    [sym_comment] = ACTIONS(1819),
    [anon_sym_DQUOTE] = ACTIONS(637),
    [anon_sym_SQUOTE] = ACTIONS(637),
    [anon_sym_PERCENT] = ACTIONS(637),
  },
  [331] = {
    [sym_function_definition] = STATE(870),
    [sym_lambda_function] = STATE(870),
    [sym_if] = STATE(870),
    [sym_while] = STATE(870),
    [sym_repeat] = STATE(870),
    [sym_for] = STATE(870),
    [sym_switch] = STATE(870),
    [sym_call] = STATE(870),
    [sym__assignment] = STATE(870),
    [sym_left_assignment] = STATE(870),
    [sym_left_assignment2] = STATE(870),
    [sym_equals_assignment] = STATE(870),
    [sym_super_assignment] = STATE(870),
    [sym_super_right_assignment] = STATE(870),
    [sym_right_assignment] = STATE(870),
    [sym_brace_list] = STATE(870),
    [sym_paren_list] = STATE(870),
    [sym_subset] = STATE(870),
    [sym_subset2] = STATE(870),
    [sym_dollar] = STATE(870),
    [sym_slot] = STATE(870),
    [sym_namespace_get] = STATE(870),
    [sym_namespace_get_internal] = STATE(870),
    [sym_pipe] = STATE(870),
    [sym_unary] = STATE(870),
    [sym_binary] = STATE(870),
    [sym_na] = STATE(870),
    [sym__expression] = STATE(870),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(870),
    [sym_string] = STATE(870),
    [anon_sym_SEMI] = ACTIONS(1821),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1823),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1823),
    [sym_next] = ACTIONS(1823),
    [sym_true] = ACTIONS(1823),
    [sym_false] = ACTIONS(1823),
    [sym_null] = ACTIONS(1823),
    [sym_inf] = ACTIONS(1823),
    [sym_nan] = ACTIONS(1823),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1821),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [332] = {
    [sym_function_definition] = STATE(859),
    [sym_lambda_function] = STATE(859),
    [sym_if] = STATE(859),
    [sym_while] = STATE(859),
    [sym_repeat] = STATE(859),
    [sym_for] = STATE(859),
    [sym_switch] = STATE(859),
    [sym_call] = STATE(859),
    [sym__assignment] = STATE(859),
    [sym_left_assignment] = STATE(859),
    [sym_left_assignment2] = STATE(859),
    [sym_equals_assignment] = STATE(859),
    [sym_super_assignment] = STATE(859),
    [sym_super_right_assignment] = STATE(859),
    [sym_right_assignment] = STATE(859),
    [sym_brace_list] = STATE(859),
    [sym_paren_list] = STATE(859),
    [sym_subset] = STATE(859),
    [sym_subset2] = STATE(859),
    [sym_dollar] = STATE(859),
    [sym_slot] = STATE(859),
    [sym_namespace_get] = STATE(859),
    [sym_namespace_get_internal] = STATE(859),
    [sym_pipe] = STATE(859),
    [sym_unary] = STATE(859),
    [sym_binary] = STATE(859),
    [sym_na] = STATE(859),
    [sym__expression] = STATE(859),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(859),
    [sym_string] = STATE(859),
    [anon_sym_SEMI] = ACTIONS(1825),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1827),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1827),
    [sym_next] = ACTIONS(1827),
    [sym_true] = ACTIONS(1827),
    [sym_false] = ACTIONS(1827),
    [sym_null] = ACTIONS(1827),
    [sym_inf] = ACTIONS(1827),
    [sym_nan] = ACTIONS(1827),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1825),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [333] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1829),
    [anon_sym_function] = ACTIONS(1831),
    [anon_sym_BSLASH] = ACTIONS(1829),
    [anon_sym_if] = ACTIONS(1831),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1829),
    [anon_sym_else] = ACTIONS(1831),
    [anon_sym_while] = ACTIONS(1831),
    [anon_sym_repeat] = ACTIONS(1831),
    [anon_sym_for] = ACTIONS(1831),
    [anon_sym_switch] = ACTIONS(1831),
    [anon_sym_COMMA] = ACTIONS(1829),
    [anon_sym_EQ] = ACTIONS(1831),
    [anon_sym_LBRACE] = ACTIONS(1829),
    [anon_sym_LT_DASH] = ACTIONS(1829),
    [anon_sym_COLON_EQ] = ACTIONS(1829),
    [anon_sym_LT_LT_DASH] = ACTIONS(1829),
    [anon_sym_DASH_GT_GT] = ACTIONS(1829),
    [anon_sym_DASH_GT] = ACTIONS(1831),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1829),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1831),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1831),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1831),
    [sym_next] = ACTIONS(1831),
    [sym_true] = ACTIONS(1831),
    [sym_false] = ACTIONS(1831),
    [sym_null] = ACTIONS(1831),
    [sym_inf] = ACTIONS(1831),
    [sym_nan] = ACTIONS(1831),
    [anon_sym_NA] = ACTIONS(1831),
    [anon_sym_NA_character_] = ACTIONS(1831),
    [anon_sym_NA_complex_] = ACTIONS(1831),
    [anon_sym_NA_integer_] = ACTIONS(1831),
    [anon_sym_NA_real_] = ACTIONS(1831),
    [aux_sym_identifier_token1] = ACTIONS(1831),
    [anon_sym_BQUOTE] = ACTIONS(1829),
    [sym_integer] = ACTIONS(1829),
    [sym_float] = ACTIONS(1831),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1829),
    [anon_sym_SQUOTE] = ACTIONS(1829),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [334] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1833),
    [anon_sym_function] = ACTIONS(1835),
    [anon_sym_BSLASH] = ACTIONS(1833),
    [anon_sym_if] = ACTIONS(1835),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1833),
    [anon_sym_else] = ACTIONS(1835),
    [anon_sym_while] = ACTIONS(1835),
    [anon_sym_repeat] = ACTIONS(1835),
    [anon_sym_for] = ACTIONS(1835),
    [anon_sym_switch] = ACTIONS(1835),
    [anon_sym_COMMA] = ACTIONS(1833),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1833),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1833),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1835),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1835),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1835),
    [sym_next] = ACTIONS(1835),
    [sym_true] = ACTIONS(1835),
    [sym_false] = ACTIONS(1835),
    [sym_null] = ACTIONS(1835),
    [sym_inf] = ACTIONS(1835),
    [sym_nan] = ACTIONS(1835),
    [anon_sym_NA] = ACTIONS(1835),
    [anon_sym_NA_character_] = ACTIONS(1835),
    [anon_sym_NA_complex_] = ACTIONS(1835),
    [anon_sym_NA_integer_] = ACTIONS(1835),
    [anon_sym_NA_real_] = ACTIONS(1835),
    [aux_sym_identifier_token1] = ACTIONS(1835),
    [anon_sym_BQUOTE] = ACTIONS(1833),
    [sym_integer] = ACTIONS(1833),
    [sym_float] = ACTIONS(1835),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1833),
    [anon_sym_SQUOTE] = ACTIONS(1833),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [335] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1837),
    [anon_sym_function] = ACTIONS(1839),
    [anon_sym_BSLASH] = ACTIONS(1837),
    [anon_sym_if] = ACTIONS(1839),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1837),
    [anon_sym_else] = ACTIONS(1839),
    [anon_sym_while] = ACTIONS(1839),
    [anon_sym_repeat] = ACTIONS(1839),
    [anon_sym_for] = ACTIONS(1839),
    [anon_sym_switch] = ACTIONS(1839),
    [anon_sym_COMMA] = ACTIONS(1837),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1837),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1837),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1839),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1839),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1839),
    [sym_next] = ACTIONS(1839),
    [sym_true] = ACTIONS(1839),
    [sym_false] = ACTIONS(1839),
    [sym_null] = ACTIONS(1839),
    [sym_inf] = ACTIONS(1839),
    [sym_nan] = ACTIONS(1839),
    [anon_sym_NA] = ACTIONS(1839),
    [anon_sym_NA_character_] = ACTIONS(1839),
    [anon_sym_NA_complex_] = ACTIONS(1839),
    [anon_sym_NA_integer_] = ACTIONS(1839),
    [anon_sym_NA_real_] = ACTIONS(1839),
    [aux_sym_identifier_token1] = ACTIONS(1839),
    [anon_sym_BQUOTE] = ACTIONS(1837),
    [sym_integer] = ACTIONS(1837),
    [sym_float] = ACTIONS(1839),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1837),
    [anon_sym_SQUOTE] = ACTIONS(1837),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [336] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1841),
    [anon_sym_function] = ACTIONS(1843),
    [anon_sym_BSLASH] = ACTIONS(1841),
    [anon_sym_if] = ACTIONS(1843),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1841),
    [anon_sym_else] = ACTIONS(1843),
    [anon_sym_while] = ACTIONS(1843),
    [anon_sym_repeat] = ACTIONS(1843),
    [anon_sym_for] = ACTIONS(1843),
    [anon_sym_switch] = ACTIONS(1843),
    [anon_sym_COMMA] = ACTIONS(1841),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1841),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1841),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1843),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1843),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1843),
    [sym_next] = ACTIONS(1843),
    [sym_true] = ACTIONS(1843),
    [sym_false] = ACTIONS(1843),
    [sym_null] = ACTIONS(1843),
    [sym_inf] = ACTIONS(1843),
    [sym_nan] = ACTIONS(1843),
    [anon_sym_NA] = ACTIONS(1843),
    [anon_sym_NA_character_] = ACTIONS(1843),
    [anon_sym_NA_complex_] = ACTIONS(1843),
    [anon_sym_NA_integer_] = ACTIONS(1843),
    [anon_sym_NA_real_] = ACTIONS(1843),
    [aux_sym_identifier_token1] = ACTIONS(1843),
    [anon_sym_BQUOTE] = ACTIONS(1841),
    [sym_integer] = ACTIONS(1841),
    [sym_float] = ACTIONS(1843),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1841),
    [anon_sym_SQUOTE] = ACTIONS(1841),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [337] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1845),
    [anon_sym_function] = ACTIONS(1847),
    [anon_sym_BSLASH] = ACTIONS(1845),
    [anon_sym_if] = ACTIONS(1847),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1845),
    [anon_sym_else] = ACTIONS(1847),
    [anon_sym_while] = ACTIONS(1847),
    [anon_sym_repeat] = ACTIONS(1847),
    [anon_sym_for] = ACTIONS(1847),
    [anon_sym_switch] = ACTIONS(1847),
    [anon_sym_COMMA] = ACTIONS(1845),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1845),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1845),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1847),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1847),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1847),
    [sym_next] = ACTIONS(1847),
    [sym_true] = ACTIONS(1847),
    [sym_false] = ACTIONS(1847),
    [sym_null] = ACTIONS(1847),
    [sym_inf] = ACTIONS(1847),
    [sym_nan] = ACTIONS(1847),
    [anon_sym_NA] = ACTIONS(1847),
    [anon_sym_NA_character_] = ACTIONS(1847),
    [anon_sym_NA_complex_] = ACTIONS(1847),
    [anon_sym_NA_integer_] = ACTIONS(1847),
    [anon_sym_NA_real_] = ACTIONS(1847),
    [aux_sym_identifier_token1] = ACTIONS(1847),
    [anon_sym_BQUOTE] = ACTIONS(1845),
    [sym_integer] = ACTIONS(1845),
    [sym_float] = ACTIONS(1847),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1845),
    [anon_sym_SQUOTE] = ACTIONS(1845),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [338] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1849),
    [anon_sym_function] = ACTIONS(1851),
    [anon_sym_BSLASH] = ACTIONS(1849),
    [anon_sym_if] = ACTIONS(1851),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1849),
    [anon_sym_else] = ACTIONS(1851),
    [anon_sym_while] = ACTIONS(1851),
    [anon_sym_repeat] = ACTIONS(1851),
    [anon_sym_for] = ACTIONS(1851),
    [anon_sym_switch] = ACTIONS(1851),
    [anon_sym_COMMA] = ACTIONS(1849),
    [anon_sym_EQ] = ACTIONS(1445),
    [anon_sym_LBRACE] = ACTIONS(1849),
    [anon_sym_LT_DASH] = ACTIONS(1447),
    [anon_sym_COLON_EQ] = ACTIONS(1449),
    [anon_sym_LT_LT_DASH] = ACTIONS(1451),
    [anon_sym_DASH_GT_GT] = ACTIONS(1453),
    [anon_sym_DASH_GT] = ACTIONS(1455),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1849),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1851),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1851),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1851),
    [sym_next] = ACTIONS(1851),
    [sym_true] = ACTIONS(1851),
    [sym_false] = ACTIONS(1851),
    [sym_null] = ACTIONS(1851),
    [sym_inf] = ACTIONS(1851),
    [sym_nan] = ACTIONS(1851),
    [anon_sym_NA] = ACTIONS(1851),
    [anon_sym_NA_character_] = ACTIONS(1851),
    [anon_sym_NA_complex_] = ACTIONS(1851),
    [anon_sym_NA_integer_] = ACTIONS(1851),
    [anon_sym_NA_real_] = ACTIONS(1851),
    [aux_sym_identifier_token1] = ACTIONS(1851),
    [anon_sym_BQUOTE] = ACTIONS(1849),
    [sym_integer] = ACTIONS(1849),
    [sym_float] = ACTIONS(1851),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1849),
    [anon_sym_SQUOTE] = ACTIONS(1849),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [339] = {
    [anon_sym_LF] = ACTIONS(653),
    [anon_sym_SEMI] = ACTIONS(653),
    [anon_sym_function] = ACTIONS(653),
    [anon_sym_BSLASH] = ACTIONS(653),
    [anon_sym_if] = ACTIONS(653),
    [anon_sym_LPAREN] = ACTIONS(653),
    [anon_sym_else] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(653),
    [anon_sym_repeat] = ACTIONS(653),
    [anon_sym_for] = ACTIONS(653),
    [anon_sym_switch] = ACTIONS(653),
    [anon_sym_EQ] = ACTIONS(653),
    [anon_sym_LBRACE] = ACTIONS(653),
    [anon_sym_RBRACE] = ACTIONS(653),
    [anon_sym_LT_DASH] = ACTIONS(653),
    [anon_sym_COLON_EQ] = ACTIONS(653),
    [anon_sym_LT_LT_DASH] = ACTIONS(653),
    [anon_sym_DASH_GT_GT] = ACTIONS(653),
    [anon_sym_DASH_GT] = ACTIONS(653),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(653),
    [anon_sym_COLON_COLON] = ACTIONS(653),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(653),
    [sym_dots] = ACTIONS(653),
    [anon_sym_PIPE_GT] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_BANG] = ACTIONS(653),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_STAR] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(653),
    [anon_sym_CARET] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(653),
    [anon_sym_GT] = ACTIONS(653),
    [anon_sym_LT_EQ] = ACTIONS(653),
    [anon_sym_GT_EQ] = ACTIONS(653),
    [anon_sym_EQ_EQ] = ACTIONS(653),
    [anon_sym_BANG_EQ] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_AMP] = ACTIONS(653),
    [anon_sym_COLON] = ACTIONS(653),
    [sym_break] = ACTIONS(653),
    [sym_next] = ACTIONS(653),
    [sym_true] = ACTIONS(653),
    [sym_false] = ACTIONS(653),
    [sym_null] = ACTIONS(653),
    [sym_inf] = ACTIONS(653),
    [sym_nan] = ACTIONS(653),
    [anon_sym_NA] = ACTIONS(653),
    [anon_sym_NA_character_] = ACTIONS(653),
    [anon_sym_NA_complex_] = ACTIONS(653),
    [anon_sym_NA_integer_] = ACTIONS(653),
    [anon_sym_NA_real_] = ACTIONS(653),
    [aux_sym_identifier_token1] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [sym_integer] = ACTIONS(653),
    [sym_float] = ACTIONS(653),
    [sym_comment] = ACTIONS(1819),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_SQUOTE] = ACTIONS(653),
    [anon_sym_PERCENT] = ACTIONS(653),
  },
  [340] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1853),
    [anon_sym_function] = ACTIONS(1855),
    [anon_sym_BSLASH] = ACTIONS(1853),
    [anon_sym_if] = ACTIONS(1855),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1853),
    [anon_sym_else] = ACTIONS(1855),
    [anon_sym_while] = ACTIONS(1855),
    [anon_sym_repeat] = ACTIONS(1855),
    [anon_sym_for] = ACTIONS(1855),
    [anon_sym_switch] = ACTIONS(1855),
    [anon_sym_COMMA] = ACTIONS(1853),
    [anon_sym_EQ] = ACTIONS(1855),
    [anon_sym_LBRACE] = ACTIONS(1853),
    [anon_sym_LT_DASH] = ACTIONS(1853),
    [anon_sym_COLON_EQ] = ACTIONS(1853),
    [anon_sym_LT_LT_DASH] = ACTIONS(1853),
    [anon_sym_DASH_GT_GT] = ACTIONS(1853),
    [anon_sym_DASH_GT] = ACTIONS(1855),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1853),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1855),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1855),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1855),
    [sym_next] = ACTIONS(1855),
    [sym_true] = ACTIONS(1855),
    [sym_false] = ACTIONS(1855),
    [sym_null] = ACTIONS(1855),
    [sym_inf] = ACTIONS(1855),
    [sym_nan] = ACTIONS(1855),
    [anon_sym_NA] = ACTIONS(1855),
    [anon_sym_NA_character_] = ACTIONS(1855),
    [anon_sym_NA_complex_] = ACTIONS(1855),
    [anon_sym_NA_integer_] = ACTIONS(1855),
    [anon_sym_NA_real_] = ACTIONS(1855),
    [aux_sym_identifier_token1] = ACTIONS(1855),
    [anon_sym_BQUOTE] = ACTIONS(1853),
    [sym_integer] = ACTIONS(1853),
    [sym_float] = ACTIONS(1855),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1853),
    [anon_sym_SQUOTE] = ACTIONS(1853),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [341] = {
    [sym_special] = STATE(348),
    [anon_sym_SEMI] = ACTIONS(1857),
    [anon_sym_function] = ACTIONS(1859),
    [anon_sym_BSLASH] = ACTIONS(1857),
    [anon_sym_if] = ACTIONS(1859),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [anon_sym_RPAREN] = ACTIONS(1857),
    [anon_sym_else] = ACTIONS(1859),
    [anon_sym_while] = ACTIONS(1859),
    [anon_sym_repeat] = ACTIONS(1859),
    [anon_sym_for] = ACTIONS(1859),
    [anon_sym_switch] = ACTIONS(1859),
    [anon_sym_COMMA] = ACTIONS(1857),
    [anon_sym_EQ] = ACTIONS(1859),
    [anon_sym_LBRACE] = ACTIONS(1857),
    [anon_sym_LT_DASH] = ACTIONS(1857),
    [anon_sym_COLON_EQ] = ACTIONS(1857),
    [anon_sym_LT_LT_DASH] = ACTIONS(1857),
    [anon_sym_DASH_GT_GT] = ACTIONS(1857),
    [anon_sym_DASH_GT] = ACTIONS(1859),
    [anon_sym_LBRACK] = ACTIONS(1457),
    [anon_sym_RBRACK] = ACTIONS(1857),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1459),
    [anon_sym_DOLLAR] = ACTIONS(1461),
    [anon_sym_AT] = ACTIONS(1463),
    [sym_dots] = ACTIONS(1859),
    [anon_sym_PIPE_GT] = ACTIONS(1465),
    [anon_sym_DASH] = ACTIONS(1467),
    [anon_sym_PLUS] = ACTIONS(1469),
    [anon_sym_BANG] = ACTIONS(1859),
    [anon_sym_TILDE] = ACTIONS(1471),
    [anon_sym_STAR] = ACTIONS(1473),
    [anon_sym_SLASH] = ACTIONS(1473),
    [anon_sym_CARET] = ACTIONS(1475),
    [anon_sym_LT] = ACTIONS(1477),
    [anon_sym_GT] = ACTIONS(1477),
    [anon_sym_LT_EQ] = ACTIONS(1479),
    [anon_sym_GT_EQ] = ACTIONS(1479),
    [anon_sym_EQ_EQ] = ACTIONS(1479),
    [anon_sym_BANG_EQ] = ACTIONS(1479),
    [anon_sym_PIPE_PIPE] = ACTIONS(1481),
    [anon_sym_PIPE] = ACTIONS(1483),
    [anon_sym_AMP_AMP] = ACTIONS(1485),
    [anon_sym_AMP] = ACTIONS(1487),
    [anon_sym_COLON] = ACTIONS(1489),
    [sym_break] = ACTIONS(1859),
    [sym_next] = ACTIONS(1859),
    [sym_true] = ACTIONS(1859),
    [sym_false] = ACTIONS(1859),
    [sym_null] = ACTIONS(1859),
    [sym_inf] = ACTIONS(1859),
    [sym_nan] = ACTIONS(1859),
    [anon_sym_NA] = ACTIONS(1859),
    [anon_sym_NA_character_] = ACTIONS(1859),
    [anon_sym_NA_complex_] = ACTIONS(1859),
    [anon_sym_NA_integer_] = ACTIONS(1859),
    [anon_sym_NA_real_] = ACTIONS(1859),
    [aux_sym_identifier_token1] = ACTIONS(1859),
    [anon_sym_BQUOTE] = ACTIONS(1857),
    [sym_integer] = ACTIONS(1857),
    [sym_float] = ACTIONS(1859),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1857),
    [anon_sym_SQUOTE] = ACTIONS(1857),
    [anon_sym_PERCENT] = ACTIONS(1491),
  },
  [342] = {
    [sym_function_definition] = STATE(853),
    [sym_lambda_function] = STATE(853),
    [sym_if] = STATE(853),
    [sym_while] = STATE(853),
    [sym_repeat] = STATE(853),
    [sym_for] = STATE(853),
    [sym_switch] = STATE(853),
    [sym_call] = STATE(853),
    [sym__assignment] = STATE(853),
    [sym_left_assignment] = STATE(853),
    [sym_left_assignment2] = STATE(853),
    [sym_equals_assignment] = STATE(853),
    [sym_super_assignment] = STATE(853),
    [sym_super_right_assignment] = STATE(853),
    [sym_right_assignment] = STATE(853),
    [sym_brace_list] = STATE(853),
    [sym_paren_list] = STATE(853),
    [sym_subset] = STATE(853),
    [sym_subset2] = STATE(853),
    [sym_dollar] = STATE(853),
    [sym_slot] = STATE(853),
    [sym_namespace_get] = STATE(853),
    [sym_namespace_get_internal] = STATE(853),
    [sym_pipe] = STATE(853),
    [sym_unary] = STATE(853),
    [sym_binary] = STATE(853),
    [sym_na] = STATE(853),
    [sym__expression] = STATE(853),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(853),
    [sym_string] = STATE(853),
    [anon_sym_SEMI] = ACTIONS(1861),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1863),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1863),
    [sym_next] = ACTIONS(1863),
    [sym_true] = ACTIONS(1863),
    [sym_false] = ACTIONS(1863),
    [sym_null] = ACTIONS(1863),
    [sym_inf] = ACTIONS(1863),
    [sym_nan] = ACTIONS(1863),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1861),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [343] = {
    [sym_function_definition] = STATE(851),
    [sym_lambda_function] = STATE(851),
    [sym_if] = STATE(851),
    [sym_while] = STATE(851),
    [sym_repeat] = STATE(851),
    [sym_for] = STATE(851),
    [sym_switch] = STATE(851),
    [sym_call] = STATE(851),
    [sym__assignment] = STATE(851),
    [sym_left_assignment] = STATE(851),
    [sym_left_assignment2] = STATE(851),
    [sym_equals_assignment] = STATE(851),
    [sym_super_assignment] = STATE(851),
    [sym_super_right_assignment] = STATE(851),
    [sym_right_assignment] = STATE(851),
    [sym_brace_list] = STATE(851),
    [sym_paren_list] = STATE(851),
    [sym_subset] = STATE(851),
    [sym_subset2] = STATE(851),
    [sym_dollar] = STATE(851),
    [sym_slot] = STATE(851),
    [sym_namespace_get] = STATE(851),
    [sym_namespace_get_internal] = STATE(851),
    [sym_pipe] = STATE(851),
    [sym_unary] = STATE(851),
    [sym_binary] = STATE(851),
    [sym_na] = STATE(851),
    [sym__expression] = STATE(851),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(851),
    [sym_string] = STATE(851),
    [anon_sym_SEMI] = ACTIONS(1865),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1867),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1867),
    [sym_next] = ACTIONS(1867),
    [sym_true] = ACTIONS(1867),
    [sym_false] = ACTIONS(1867),
    [sym_null] = ACTIONS(1867),
    [sym_inf] = ACTIONS(1867),
    [sym_nan] = ACTIONS(1867),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1865),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [344] = {
    [sym_function_definition] = STATE(844),
    [sym_lambda_function] = STATE(844),
    [sym_if] = STATE(844),
    [sym_while] = STATE(844),
    [sym_repeat] = STATE(844),
    [sym_for] = STATE(844),
    [sym_switch] = STATE(844),
    [sym_call] = STATE(844),
    [sym__assignment] = STATE(844),
    [sym_left_assignment] = STATE(844),
    [sym_left_assignment2] = STATE(844),
    [sym_equals_assignment] = STATE(844),
    [sym_super_assignment] = STATE(844),
    [sym_super_right_assignment] = STATE(844),
    [sym_right_assignment] = STATE(844),
    [sym_brace_list] = STATE(844),
    [sym_paren_list] = STATE(844),
    [sym_subset] = STATE(844),
    [sym_subset2] = STATE(844),
    [sym_dollar] = STATE(844),
    [sym_slot] = STATE(844),
    [sym_namespace_get] = STATE(844),
    [sym_namespace_get_internal] = STATE(844),
    [sym_pipe] = STATE(844),
    [sym_unary] = STATE(844),
    [sym_binary] = STATE(844),
    [sym_na] = STATE(844),
    [sym__expression] = STATE(844),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(844),
    [sym_string] = STATE(844),
    [anon_sym_SEMI] = ACTIONS(1869),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1871),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1871),
    [sym_next] = ACTIONS(1871),
    [sym_true] = ACTIONS(1871),
    [sym_false] = ACTIONS(1871),
    [sym_null] = ACTIONS(1871),
    [sym_inf] = ACTIONS(1871),
    [sym_nan] = ACTIONS(1871),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1869),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [345] = {
    [sym_function_definition] = STATE(875),
    [sym_lambda_function] = STATE(875),
    [sym_if] = STATE(875),
    [sym_while] = STATE(875),
    [sym_repeat] = STATE(875),
    [sym_for] = STATE(875),
    [sym_switch] = STATE(875),
    [sym_call] = STATE(875),
    [sym__assignment] = STATE(875),
    [sym_left_assignment] = STATE(875),
    [sym_left_assignment2] = STATE(875),
    [sym_equals_assignment] = STATE(875),
    [sym_super_assignment] = STATE(875),
    [sym_super_right_assignment] = STATE(875),
    [sym_right_assignment] = STATE(875),
    [sym_brace_list] = STATE(875),
    [sym_paren_list] = STATE(875),
    [sym_subset] = STATE(875),
    [sym_subset2] = STATE(875),
    [sym_dollar] = STATE(875),
    [sym_slot] = STATE(875),
    [sym_namespace_get] = STATE(875),
    [sym_namespace_get_internal] = STATE(875),
    [sym_pipe] = STATE(875),
    [sym_unary] = STATE(875),
    [sym_binary] = STATE(875),
    [sym_na] = STATE(875),
    [sym__expression] = STATE(875),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(875),
    [sym_string] = STATE(875),
    [anon_sym_SEMI] = ACTIONS(1873),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1875),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1875),
    [sym_next] = ACTIONS(1875),
    [sym_true] = ACTIONS(1875),
    [sym_false] = ACTIONS(1875),
    [sym_null] = ACTIONS(1875),
    [sym_inf] = ACTIONS(1875),
    [sym_nan] = ACTIONS(1875),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1873),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [346] = {
    [sym_function_definition] = STATE(880),
    [sym_lambda_function] = STATE(880),
    [sym_if] = STATE(880),
    [sym_while] = STATE(880),
    [sym_repeat] = STATE(880),
    [sym_for] = STATE(880),
    [sym_switch] = STATE(880),
    [sym_call] = STATE(880),
    [sym__assignment] = STATE(880),
    [sym_left_assignment] = STATE(880),
    [sym_left_assignment2] = STATE(880),
    [sym_equals_assignment] = STATE(880),
    [sym_super_assignment] = STATE(880),
    [sym_super_right_assignment] = STATE(880),
    [sym_right_assignment] = STATE(880),
    [sym_brace_list] = STATE(880),
    [sym_paren_list] = STATE(880),
    [sym_subset] = STATE(880),
    [sym_subset2] = STATE(880),
    [sym_dollar] = STATE(880),
    [sym_slot] = STATE(880),
    [sym_namespace_get] = STATE(880),
    [sym_namespace_get_internal] = STATE(880),
    [sym_pipe] = STATE(880),
    [sym_unary] = STATE(880),
    [sym_binary] = STATE(880),
    [sym_na] = STATE(880),
    [sym__expression] = STATE(880),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(880),
    [sym_string] = STATE(880),
    [anon_sym_SEMI] = ACTIONS(1877),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1879),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1879),
    [sym_next] = ACTIONS(1879),
    [sym_true] = ACTIONS(1879),
    [sym_false] = ACTIONS(1879),
    [sym_null] = ACTIONS(1879),
    [sym_inf] = ACTIONS(1879),
    [sym_nan] = ACTIONS(1879),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1877),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [347] = {
    [sym_function_definition] = STATE(879),
    [sym_lambda_function] = STATE(879),
    [sym_if] = STATE(879),
    [sym_while] = STATE(879),
    [sym_repeat] = STATE(879),
    [sym_for] = STATE(879),
    [sym_switch] = STATE(879),
    [sym_call] = STATE(879),
    [sym__assignment] = STATE(879),
    [sym_left_assignment] = STATE(879),
    [sym_left_assignment2] = STATE(879),
    [sym_equals_assignment] = STATE(879),
    [sym_super_assignment] = STATE(879),
    [sym_super_right_assignment] = STATE(879),
    [sym_right_assignment] = STATE(879),
    [sym_brace_list] = STATE(879),
    [sym_paren_list] = STATE(879),
    [sym_subset] = STATE(879),
    [sym_subset2] = STATE(879),
    [sym_dollar] = STATE(879),
    [sym_slot] = STATE(879),
    [sym_namespace_get] = STATE(879),
    [sym_namespace_get_internal] = STATE(879),
    [sym_pipe] = STATE(879),
    [sym_unary] = STATE(879),
    [sym_binary] = STATE(879),
    [sym_na] = STATE(879),
    [sym__expression] = STATE(879),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(879),
    [sym_string] = STATE(879),
    [anon_sym_SEMI] = ACTIONS(1881),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1883),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1883),
    [sym_next] = ACTIONS(1883),
    [sym_true] = ACTIONS(1883),
    [sym_false] = ACTIONS(1883),
    [sym_null] = ACTIONS(1883),
    [sym_inf] = ACTIONS(1883),
    [sym_nan] = ACTIONS(1883),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1881),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [348] = {
    [sym_function_definition] = STATE(315),
    [sym_lambda_function] = STATE(315),
    [sym_if] = STATE(315),
    [sym_while] = STATE(315),
    [sym_repeat] = STATE(315),
    [sym_for] = STATE(315),
    [sym_switch] = STATE(315),
    [sym_call] = STATE(315),
    [sym__assignment] = STATE(315),
    [sym_left_assignment] = STATE(315),
    [sym_left_assignment2] = STATE(315),
    [sym_equals_assignment] = STATE(315),
    [sym_super_assignment] = STATE(315),
    [sym_super_right_assignment] = STATE(315),
    [sym_right_assignment] = STATE(315),
    [sym_brace_list] = STATE(315),
    [sym_paren_list] = STATE(315),
    [sym_subset] = STATE(315),
    [sym_subset2] = STATE(315),
    [sym_dollar] = STATE(315),
    [sym_slot] = STATE(315),
    [sym_namespace_get] = STATE(315),
    [sym_namespace_get_internal] = STATE(315),
    [sym_pipe] = STATE(315),
    [sym_unary] = STATE(315),
    [sym_binary] = STATE(315),
    [sym_na] = STATE(315),
    [sym__expression] = STATE(315),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(315),
    [sym_string] = STATE(315),
    [anon_sym_SEMI] = ACTIONS(1885),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1887),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1887),
    [sym_next] = ACTIONS(1887),
    [sym_true] = ACTIONS(1887),
    [sym_false] = ACTIONS(1887),
    [sym_null] = ACTIONS(1887),
    [sym_inf] = ACTIONS(1887),
    [sym_nan] = ACTIONS(1887),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1885),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [349] = {
    [sym_function_definition] = STATE(316),
    [sym_lambda_function] = STATE(316),
    [sym_if] = STATE(316),
    [sym_while] = STATE(316),
    [sym_repeat] = STATE(316),
    [sym_for] = STATE(316),
    [sym_switch] = STATE(316),
    [sym_call] = STATE(316),
    [sym__assignment] = STATE(316),
    [sym_left_assignment] = STATE(316),
    [sym_left_assignment2] = STATE(316),
    [sym_equals_assignment] = STATE(316),
    [sym_super_assignment] = STATE(316),
    [sym_super_right_assignment] = STATE(316),
    [sym_right_assignment] = STATE(316),
    [sym_brace_list] = STATE(316),
    [sym_paren_list] = STATE(316),
    [sym_subset] = STATE(316),
    [sym_subset2] = STATE(316),
    [sym_dollar] = STATE(316),
    [sym_slot] = STATE(316),
    [sym_namespace_get] = STATE(316),
    [sym_namespace_get_internal] = STATE(316),
    [sym_pipe] = STATE(316),
    [sym_unary] = STATE(316),
    [sym_binary] = STATE(316),
    [sym_na] = STATE(316),
    [sym__expression] = STATE(316),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(316),
    [sym_string] = STATE(316),
    [anon_sym_SEMI] = ACTIONS(1889),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1891),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1891),
    [sym_next] = ACTIONS(1891),
    [sym_true] = ACTIONS(1891),
    [sym_false] = ACTIONS(1891),
    [sym_null] = ACTIONS(1891),
    [sym_inf] = ACTIONS(1891),
    [sym_nan] = ACTIONS(1891),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1889),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [350] = {
    [sym_function_definition] = STATE(842),
    [sym_lambda_function] = STATE(842),
    [sym_if] = STATE(842),
    [sym_while] = STATE(842),
    [sym_repeat] = STATE(842),
    [sym_for] = STATE(842),
    [sym_switch] = STATE(842),
    [sym_call] = STATE(842),
    [sym__assignment] = STATE(842),
    [sym_left_assignment] = STATE(842),
    [sym_left_assignment2] = STATE(842),
    [sym_equals_assignment] = STATE(842),
    [sym_super_assignment] = STATE(842),
    [sym_super_right_assignment] = STATE(842),
    [sym_right_assignment] = STATE(842),
    [sym_brace_list] = STATE(842),
    [sym_paren_list] = STATE(842),
    [sym_subset] = STATE(842),
    [sym_subset2] = STATE(842),
    [sym_dollar] = STATE(842),
    [sym_slot] = STATE(842),
    [sym_namespace_get] = STATE(842),
    [sym_namespace_get_internal] = STATE(842),
    [sym_pipe] = STATE(842),
    [sym_unary] = STATE(842),
    [sym_binary] = STATE(842),
    [sym_na] = STATE(842),
    [sym__expression] = STATE(842),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(842),
    [sym_string] = STATE(842),
    [anon_sym_SEMI] = ACTIONS(1893),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1895),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1895),
    [sym_next] = ACTIONS(1895),
    [sym_true] = ACTIONS(1895),
    [sym_false] = ACTIONS(1895),
    [sym_null] = ACTIONS(1895),
    [sym_inf] = ACTIONS(1895),
    [sym_nan] = ACTIONS(1895),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1893),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [351] = {
    [sym_function_definition] = STATE(837),
    [sym_lambda_function] = STATE(837),
    [sym_if] = STATE(837),
    [sym_while] = STATE(837),
    [sym_repeat] = STATE(837),
    [sym_for] = STATE(837),
    [sym_switch] = STATE(837),
    [sym_call] = STATE(837),
    [sym__assignment] = STATE(837),
    [sym_left_assignment] = STATE(837),
    [sym_left_assignment2] = STATE(837),
    [sym_equals_assignment] = STATE(837),
    [sym_super_assignment] = STATE(837),
    [sym_super_right_assignment] = STATE(837),
    [sym_right_assignment] = STATE(837),
    [sym_brace_list] = STATE(837),
    [sym_paren_list] = STATE(837),
    [sym_subset] = STATE(837),
    [sym_subset2] = STATE(837),
    [sym_dollar] = STATE(837),
    [sym_slot] = STATE(837),
    [sym_namespace_get] = STATE(837),
    [sym_namespace_get_internal] = STATE(837),
    [sym_pipe] = STATE(837),
    [sym_unary] = STATE(837),
    [sym_binary] = STATE(837),
    [sym_na] = STATE(837),
    [sym__expression] = STATE(837),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(837),
    [sym_string] = STATE(837),
    [anon_sym_SEMI] = ACTIONS(1897),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1899),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1899),
    [sym_next] = ACTIONS(1899),
    [sym_true] = ACTIONS(1899),
    [sym_false] = ACTIONS(1899),
    [sym_null] = ACTIONS(1899),
    [sym_inf] = ACTIONS(1899),
    [sym_nan] = ACTIONS(1899),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1897),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [352] = {
    [sym_function_definition] = STATE(835),
    [sym_lambda_function] = STATE(835),
    [sym_if] = STATE(835),
    [sym_while] = STATE(835),
    [sym_repeat] = STATE(835),
    [sym_for] = STATE(835),
    [sym_switch] = STATE(835),
    [sym_call] = STATE(835),
    [sym__assignment] = STATE(835),
    [sym_left_assignment] = STATE(835),
    [sym_left_assignment2] = STATE(835),
    [sym_equals_assignment] = STATE(835),
    [sym_super_assignment] = STATE(835),
    [sym_super_right_assignment] = STATE(835),
    [sym_right_assignment] = STATE(835),
    [sym_brace_list] = STATE(835),
    [sym_paren_list] = STATE(835),
    [sym_subset] = STATE(835),
    [sym_subset2] = STATE(835),
    [sym_dollar] = STATE(835),
    [sym_slot] = STATE(835),
    [sym_namespace_get] = STATE(835),
    [sym_namespace_get_internal] = STATE(835),
    [sym_pipe] = STATE(835),
    [sym_unary] = STATE(835),
    [sym_binary] = STATE(835),
    [sym_na] = STATE(835),
    [sym__expression] = STATE(835),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(835),
    [sym_string] = STATE(835),
    [anon_sym_SEMI] = ACTIONS(1901),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1903),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1903),
    [sym_next] = ACTIONS(1903),
    [sym_true] = ACTIONS(1903),
    [sym_false] = ACTIONS(1903),
    [sym_null] = ACTIONS(1903),
    [sym_inf] = ACTIONS(1903),
    [sym_nan] = ACTIONS(1903),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1901),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [353] = {
    [sym_function_definition] = STATE(834),
    [sym_lambda_function] = STATE(834),
    [sym_if] = STATE(834),
    [sym_while] = STATE(834),
    [sym_repeat] = STATE(834),
    [sym_for] = STATE(834),
    [sym_switch] = STATE(834),
    [sym_call] = STATE(834),
    [sym__assignment] = STATE(834),
    [sym_left_assignment] = STATE(834),
    [sym_left_assignment2] = STATE(834),
    [sym_equals_assignment] = STATE(834),
    [sym_super_assignment] = STATE(834),
    [sym_super_right_assignment] = STATE(834),
    [sym_right_assignment] = STATE(834),
    [sym_brace_list] = STATE(834),
    [sym_paren_list] = STATE(834),
    [sym_subset] = STATE(834),
    [sym_subset2] = STATE(834),
    [sym_dollar] = STATE(834),
    [sym_slot] = STATE(834),
    [sym_namespace_get] = STATE(834),
    [sym_namespace_get_internal] = STATE(834),
    [sym_pipe] = STATE(834),
    [sym_unary] = STATE(834),
    [sym_binary] = STATE(834),
    [sym_na] = STATE(834),
    [sym__expression] = STATE(834),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(834),
    [sym_string] = STATE(834),
    [anon_sym_SEMI] = ACTIONS(1905),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1907),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1907),
    [sym_next] = ACTIONS(1907),
    [sym_true] = ACTIONS(1907),
    [sym_false] = ACTIONS(1907),
    [sym_null] = ACTIONS(1907),
    [sym_inf] = ACTIONS(1907),
    [sym_nan] = ACTIONS(1907),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1905),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [354] = {
    [sym_function_definition] = STATE(833),
    [sym_lambda_function] = STATE(833),
    [sym_if] = STATE(833),
    [sym_while] = STATE(833),
    [sym_repeat] = STATE(833),
    [sym_for] = STATE(833),
    [sym_switch] = STATE(833),
    [sym_call] = STATE(833),
    [sym__assignment] = STATE(833),
    [sym_left_assignment] = STATE(833),
    [sym_left_assignment2] = STATE(833),
    [sym_equals_assignment] = STATE(833),
    [sym_super_assignment] = STATE(833),
    [sym_super_right_assignment] = STATE(833),
    [sym_right_assignment] = STATE(833),
    [sym_brace_list] = STATE(833),
    [sym_paren_list] = STATE(833),
    [sym_subset] = STATE(833),
    [sym_subset2] = STATE(833),
    [sym_dollar] = STATE(833),
    [sym_slot] = STATE(833),
    [sym_namespace_get] = STATE(833),
    [sym_namespace_get_internal] = STATE(833),
    [sym_pipe] = STATE(833),
    [sym_unary] = STATE(833),
    [sym_binary] = STATE(833),
    [sym_na] = STATE(833),
    [sym__expression] = STATE(833),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(833),
    [sym_string] = STATE(833),
    [anon_sym_SEMI] = ACTIONS(1909),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1911),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1911),
    [sym_next] = ACTIONS(1911),
    [sym_true] = ACTIONS(1911),
    [sym_false] = ACTIONS(1911),
    [sym_null] = ACTIONS(1911),
    [sym_inf] = ACTIONS(1911),
    [sym_nan] = ACTIONS(1911),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1909),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [355] = {
    [sym_function_definition] = STATE(831),
    [sym_lambda_function] = STATE(831),
    [sym_if] = STATE(831),
    [sym_while] = STATE(831),
    [sym_repeat] = STATE(831),
    [sym_for] = STATE(831),
    [sym_switch] = STATE(831),
    [sym_call] = STATE(831),
    [sym__assignment] = STATE(831),
    [sym_left_assignment] = STATE(831),
    [sym_left_assignment2] = STATE(831),
    [sym_equals_assignment] = STATE(831),
    [sym_super_assignment] = STATE(831),
    [sym_super_right_assignment] = STATE(831),
    [sym_right_assignment] = STATE(831),
    [sym_brace_list] = STATE(831),
    [sym_paren_list] = STATE(831),
    [sym_subset] = STATE(831),
    [sym_subset2] = STATE(831),
    [sym_dollar] = STATE(831),
    [sym_slot] = STATE(831),
    [sym_namespace_get] = STATE(831),
    [sym_namespace_get_internal] = STATE(831),
    [sym_pipe] = STATE(831),
    [sym_unary] = STATE(831),
    [sym_binary] = STATE(831),
    [sym_na] = STATE(831),
    [sym__expression] = STATE(831),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(831),
    [sym_string] = STATE(831),
    [anon_sym_SEMI] = ACTIONS(1913),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1915),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1915),
    [sym_next] = ACTIONS(1915),
    [sym_true] = ACTIONS(1915),
    [sym_false] = ACTIONS(1915),
    [sym_null] = ACTIONS(1915),
    [sym_inf] = ACTIONS(1915),
    [sym_nan] = ACTIONS(1915),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1913),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [356] = {
    [sym_function_definition] = STATE(830),
    [sym_lambda_function] = STATE(830),
    [sym_if] = STATE(830),
    [sym_while] = STATE(830),
    [sym_repeat] = STATE(830),
    [sym_for] = STATE(830),
    [sym_switch] = STATE(830),
    [sym_call] = STATE(830),
    [sym__assignment] = STATE(830),
    [sym_left_assignment] = STATE(830),
    [sym_left_assignment2] = STATE(830),
    [sym_equals_assignment] = STATE(830),
    [sym_super_assignment] = STATE(830),
    [sym_super_right_assignment] = STATE(830),
    [sym_right_assignment] = STATE(830),
    [sym_brace_list] = STATE(830),
    [sym_paren_list] = STATE(830),
    [sym_subset] = STATE(830),
    [sym_subset2] = STATE(830),
    [sym_dollar] = STATE(830),
    [sym_slot] = STATE(830),
    [sym_namespace_get] = STATE(830),
    [sym_namespace_get_internal] = STATE(830),
    [sym_pipe] = STATE(830),
    [sym_unary] = STATE(830),
    [sym_binary] = STATE(830),
    [sym_na] = STATE(830),
    [sym__expression] = STATE(830),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(830),
    [sym_string] = STATE(830),
    [anon_sym_SEMI] = ACTIONS(1917),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1919),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1919),
    [sym_next] = ACTIONS(1919),
    [sym_true] = ACTIONS(1919),
    [sym_false] = ACTIONS(1919),
    [sym_null] = ACTIONS(1919),
    [sym_inf] = ACTIONS(1919),
    [sym_nan] = ACTIONS(1919),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1917),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [357] = {
    [sym_function_definition] = STATE(856),
    [sym_lambda_function] = STATE(856),
    [sym_if] = STATE(856),
    [sym_while] = STATE(856),
    [sym_repeat] = STATE(856),
    [sym_for] = STATE(856),
    [sym_switch] = STATE(856),
    [sym_call] = STATE(856),
    [sym__assignment] = STATE(856),
    [sym_left_assignment] = STATE(856),
    [sym_left_assignment2] = STATE(856),
    [sym_equals_assignment] = STATE(856),
    [sym_super_assignment] = STATE(856),
    [sym_super_right_assignment] = STATE(856),
    [sym_right_assignment] = STATE(856),
    [sym_brace_list] = STATE(856),
    [sym_paren_list] = STATE(856),
    [sym_subset] = STATE(856),
    [sym_subset2] = STATE(856),
    [sym_dollar] = STATE(856),
    [sym_slot] = STATE(856),
    [sym_namespace_get] = STATE(856),
    [sym_namespace_get_internal] = STATE(856),
    [sym_pipe] = STATE(856),
    [sym_unary] = STATE(856),
    [sym_binary] = STATE(856),
    [sym_na] = STATE(856),
    [sym__expression] = STATE(856),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(856),
    [sym_string] = STATE(856),
    [anon_sym_SEMI] = ACTIONS(1921),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1923),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1923),
    [sym_next] = ACTIONS(1923),
    [sym_true] = ACTIONS(1923),
    [sym_false] = ACTIONS(1923),
    [sym_null] = ACTIONS(1923),
    [sym_inf] = ACTIONS(1923),
    [sym_nan] = ACTIONS(1923),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1921),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [358] = {
    [sym_function_definition] = STATE(857),
    [sym_lambda_function] = STATE(857),
    [sym_if] = STATE(857),
    [sym_while] = STATE(857),
    [sym_repeat] = STATE(857),
    [sym_for] = STATE(857),
    [sym_switch] = STATE(857),
    [sym_call] = STATE(857),
    [sym__assignment] = STATE(857),
    [sym_left_assignment] = STATE(857),
    [sym_left_assignment2] = STATE(857),
    [sym_equals_assignment] = STATE(857),
    [sym_super_assignment] = STATE(857),
    [sym_super_right_assignment] = STATE(857),
    [sym_right_assignment] = STATE(857),
    [sym_brace_list] = STATE(857),
    [sym_paren_list] = STATE(857),
    [sym_subset] = STATE(857),
    [sym_subset2] = STATE(857),
    [sym_dollar] = STATE(857),
    [sym_slot] = STATE(857),
    [sym_namespace_get] = STATE(857),
    [sym_namespace_get_internal] = STATE(857),
    [sym_pipe] = STATE(857),
    [sym_unary] = STATE(857),
    [sym_binary] = STATE(857),
    [sym_na] = STATE(857),
    [sym__expression] = STATE(857),
    [sym_identifier] = STATE(164),
    [sym_complex] = STATE(857),
    [sym_string] = STATE(857),
    [anon_sym_SEMI] = ACTIONS(1925),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_BSLASH] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(707),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_for] = ACTIONS(711),
    [anon_sym_switch] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(115),
    [sym_dots] = ACTIONS(1927),
    [anon_sym_DASH] = ACTIONS(715),
    [anon_sym_PLUS] = ACTIONS(715),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_TILDE] = ACTIONS(719),
    [sym_break] = ACTIONS(1927),
    [sym_next] = ACTIONS(1927),
    [sym_true] = ACTIONS(1927),
    [sym_false] = ACTIONS(1927),
    [sym_null] = ACTIONS(1927),
    [sym_inf] = ACTIONS(1927),
    [sym_nan] = ACTIONS(1927),
    [anon_sym_NA] = ACTIONS(127),
    [anon_sym_NA_character_] = ACTIONS(127),
    [anon_sym_NA_complex_] = ACTIONS(127),
    [anon_sym_NA_integer_] = ACTIONS(127),
    [anon_sym_NA_real_] = ACTIONS(127),
    [aux_sym_identifier_token1] = ACTIONS(129),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [sym_integer] = ACTIONS(1925),
    [sym_float] = ACTIONS(721),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [anon_sym_SQUOTE] = ACTIONS(137),
  },
  [359] = {
    [sym_function_definition] = STATE(317),
    [sym_lambda_function] = STATE(317),
    [sym_if] = STATE(317),
    [sym_while] = STATE(317),
    [sym_repeat] = STATE(317),
    [sym_for] = STATE(317),
    [sym_switch] = STATE(317),
    [sym_call] = STATE(317),
    [sym__assignment] = STATE(317),
    [sym_left_assignment] = STATE(317),
    [sym_left_assignment2] = STATE(317),
    [sym_equals_assignment] = STATE(317),
    [sym_super_assignment] = STATE(317),
    [sym_super_right_assignment] = STATE(317),
    [sym_right_assignment] = STATE(317),
    [sym_brace_list] = STATE(317),
    [sym_paren_list] = STATE(317),
    [sym_subset] = STATE(317),
    [sym_subset2] = STATE(317),
    [sym_dollar] = STATE(317),
    [sym_slot] = STATE(317),
    [sym_namespace_get] = STATE(317),
    [sym_namespace_get_internal] = STATE(317),
    [sym_pipe] = STATE(317),
    [sym_unary] = STATE(317),
    [sym_binary] = STATE(317),
    [sym_na] = STATE(317),
    [sym__expression] = STATE(317),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(317),
    [sym_string] = STATE(317),
    [anon_sym_SEMI] = ACTIONS(1929),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1931),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1931),
    [sym_next] = ACTIONS(1931),
    [sym_true] = ACTIONS(1931),
    [sym_false] = ACTIONS(1931),
    [sym_null] = ACTIONS(1931),
    [sym_inf] = ACTIONS(1931),
    [sym_nan] = ACTIONS(1931),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1929),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [360] = {
    [sym_function_definition] = STATE(320),
    [sym_lambda_function] = STATE(320),
    [sym_if] = STATE(320),
    [sym_while] = STATE(320),
    [sym_repeat] = STATE(320),
    [sym_for] = STATE(320),
    [sym_switch] = STATE(320),
    [sym_call] = STATE(320),
    [sym__assignment] = STATE(320),
    [sym_left_assignment] = STATE(320),
    [sym_left_assignment2] = STATE(320),
    [sym_equals_assignment] = STATE(320),
    [sym_super_assignment] = STATE(320),
    [sym_super_right_assignment] = STATE(320),
    [sym_right_assignment] = STATE(320),
    [sym_brace_list] = STATE(320),
    [sym_paren_list] = STATE(320),
    [sym_subset] = STATE(320),
    [sym_subset2] = STATE(320),
    [sym_dollar] = STATE(320),
    [sym_slot] = STATE(320),
    [sym_namespace_get] = STATE(320),
    [sym_namespace_get_internal] = STATE(320),
    [sym_pipe] = STATE(320),
    [sym_unary] = STATE(320),
    [sym_binary] = STATE(320),
    [sym_na] = STATE(320),
    [sym__expression] = STATE(320),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(320),
    [sym_string] = STATE(320),
    [anon_sym_SEMI] = ACTIONS(1933),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1935),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1935),
    [sym_next] = ACTIONS(1935),
    [sym_true] = ACTIONS(1935),
    [sym_false] = ACTIONS(1935),
    [sym_null] = ACTIONS(1935),
    [sym_inf] = ACTIONS(1935),
    [sym_nan] = ACTIONS(1935),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1933),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [361] = {
    [sym_function_definition] = STATE(321),
    [sym_lambda_function] = STATE(321),
    [sym_if] = STATE(321),
    [sym_while] = STATE(321),
    [sym_repeat] = STATE(321),
    [sym_for] = STATE(321),
    [sym_switch] = STATE(321),
    [sym_call] = STATE(321),
    [sym__assignment] = STATE(321),
    [sym_left_assignment] = STATE(321),
    [sym_left_assignment2] = STATE(321),
    [sym_equals_assignment] = STATE(321),
    [sym_super_assignment] = STATE(321),
    [sym_super_right_assignment] = STATE(321),
    [sym_right_assignment] = STATE(321),
    [sym_brace_list] = STATE(321),
    [sym_paren_list] = STATE(321),
    [sym_subset] = STATE(321),
    [sym_subset2] = STATE(321),
    [sym_dollar] = STATE(321),
    [sym_slot] = STATE(321),
    [sym_namespace_get] = STATE(321),
    [sym_namespace_get_internal] = STATE(321),
    [sym_pipe] = STATE(321),
    [sym_unary] = STATE(321),
    [sym_binary] = STATE(321),
    [sym_na] = STATE(321),
    [sym__expression] = STATE(321),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(321),
    [sym_string] = STATE(321),
    [anon_sym_SEMI] = ACTIONS(1937),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1939),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1939),
    [sym_next] = ACTIONS(1939),
    [sym_true] = ACTIONS(1939),
    [sym_false] = ACTIONS(1939),
    [sym_null] = ACTIONS(1939),
    [sym_inf] = ACTIONS(1939),
    [sym_nan] = ACTIONS(1939),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1937),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [362] = {
    [sym_function_definition] = STATE(322),
    [sym_lambda_function] = STATE(322),
    [sym_if] = STATE(322),
    [sym_while] = STATE(322),
    [sym_repeat] = STATE(322),
    [sym_for] = STATE(322),
    [sym_switch] = STATE(322),
    [sym_call] = STATE(322),
    [sym__assignment] = STATE(322),
    [sym_left_assignment] = STATE(322),
    [sym_left_assignment2] = STATE(322),
    [sym_equals_assignment] = STATE(322),
    [sym_super_assignment] = STATE(322),
    [sym_super_right_assignment] = STATE(322),
    [sym_right_assignment] = STATE(322),
    [sym_brace_list] = STATE(322),
    [sym_paren_list] = STATE(322),
    [sym_subset] = STATE(322),
    [sym_subset2] = STATE(322),
    [sym_dollar] = STATE(322),
    [sym_slot] = STATE(322),
    [sym_namespace_get] = STATE(322),
    [sym_namespace_get_internal] = STATE(322),
    [sym_pipe] = STATE(322),
    [sym_unary] = STATE(322),
    [sym_binary] = STATE(322),
    [sym_na] = STATE(322),
    [sym__expression] = STATE(322),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(322),
    [sym_string] = STATE(322),
    [anon_sym_SEMI] = ACTIONS(1941),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1943),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1943),
    [sym_next] = ACTIONS(1943),
    [sym_true] = ACTIONS(1943),
    [sym_false] = ACTIONS(1943),
    [sym_null] = ACTIONS(1943),
    [sym_inf] = ACTIONS(1943),
    [sym_nan] = ACTIONS(1943),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1941),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [363] = {
    [sym_function_definition] = STATE(327),
    [sym_lambda_function] = STATE(327),
    [sym_if] = STATE(327),
    [sym_while] = STATE(327),
    [sym_repeat] = STATE(327),
    [sym_for] = STATE(327),
    [sym_switch] = STATE(327),
    [sym_call] = STATE(327),
    [sym__assignment] = STATE(327),
    [sym_left_assignment] = STATE(327),
    [sym_left_assignment2] = STATE(327),
    [sym_equals_assignment] = STATE(327),
    [sym_super_assignment] = STATE(327),
    [sym_super_right_assignment] = STATE(327),
    [sym_right_assignment] = STATE(327),
    [sym_brace_list] = STATE(327),
    [sym_paren_list] = STATE(327),
    [sym_subset] = STATE(327),
    [sym_subset2] = STATE(327),
    [sym_dollar] = STATE(327),
    [sym_slot] = STATE(327),
    [sym_namespace_get] = STATE(327),
    [sym_namespace_get_internal] = STATE(327),
    [sym_pipe] = STATE(327),
    [sym_unary] = STATE(327),
    [sym_binary] = STATE(327),
    [sym_na] = STATE(327),
    [sym__expression] = STATE(327),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(327),
    [sym_string] = STATE(327),
    [anon_sym_SEMI] = ACTIONS(1945),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1947),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break] = ACTIONS(1947),
    [sym_next] = ACTIONS(1947),
    [sym_true] = ACTIONS(1947),
    [sym_false] = ACTIONS(1947),
    [sym_null] = ACTIONS(1947),
    [sym_inf] = ACTIONS(1947),
    [sym_nan] = ACTIONS(1947),
    [anon_sym_NA] = ACTIONS(1081),
    [anon_sym_NA_character_] = ACTIONS(1081),
    [anon_sym_NA_complex_] = ACTIONS(1081),
    [anon_sym_NA_integer_] = ACTIONS(1081),
    [anon_sym_NA_real_] = ACTIONS(1081),
    [aux_sym_identifier_token1] = ACTIONS(1083),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [sym_integer] = ACTIONS(1945),
    [sym_float] = ACTIONS(1087),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_SQUOTE] = ACTIONS(1091),
  },
  [364] = {
    [sym_function_definition] = STATE(328),
    [sym_lambda_function] = STATE(328),
    [sym_if] = STATE(328),
    [sym_while] = STATE(328),
    [sym_repeat] = STATE(328),
    [sym_for] = STATE(328),
    [sym_switch] = STATE(328),
    [sym_call] = STATE(328),
    [sym__assignment] = STATE(328),
    [sym_left_assignment] = STATE(328),
    [sym_left_assignment2] = STATE(328),
    [sym_equals_assignment] = STATE(328),
    [sym_super_assignment] = STATE(328),
    [sym_super_right_assignment] = STATE(328),
    [sym_right_assignment] = STATE(328),
    [sym_brace_list] = STATE(328),
    [sym_paren_list] = STATE(328),
    [sym_subset] = STATE(328),
    [sym_subset2] = STATE(328),
    [sym_dollar] = STATE(328),
    [sym_slot] = STATE(328),
    [sym_namespace_get] = STATE(328),
    [sym_namespace_get_internal] = STATE(328),
    [sym_pipe] = STATE(328),
    [sym_unary] = STATE(328),
    [sym_binary] = STATE(328),
    [sym_na] = STATE(328),
    [sym__expression] = STATE(328),
    [sym_identifier] = STATE(84),
    [sym_complex] = STATE(328),
    [sym_string] = STATE(328),
    [anon_sym_SEMI] = ACTIONS(1949),
    [anon_sym_function] = ACTIONS(1055),
    [anon_sym_BSLASH] = ACTIONS(1057),
    [anon_sym_if] = ACTIONS(1059),
    [anon_sym_LPAREN] = ACTIONS(1061),
    [anon_sym_while] = ACTIONS(1063),
    [anon_sym_repeat] = ACTIONS(1065),
    [anon_sym_for] = ACTIONS(1067),
    [anon_sym_switch] = ACTIONS(1069),
    [anon_sym_LBRACE] = ACTIONS(1071),
    [sym_dots] = ACTIONS(1951),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1079),
    [sym_break]